import { ITerraformDependable, TerraformProvider, TerraformResourceLifecycle } from "cdktf";
import { LocalExec } from "cdktf-local-exec";
import { Construct } from "constructs";
import { DockerizedBuild } from "./docker";
export interface CargoOptions {
    /**
     * Architecture of the binary to build.
     *
     * @default "x86"
     */
    readonly arch?: "arm" | "x86";
    /**
     * Name value in the Cargo.toml
     */
    readonly projectName: string;
    /**
     * @stability stable
     */
    readonly dependsOn?: ITerraformDependable[];
    /**
     * @stability stable
     */
    readonly provider?: TerraformProvider;
    /**
     * @stability stable
     */
    readonly lifecycle?: TerraformResourceLifecycle;
    /**
     * @stability stable
     */
    readonly triggers?: {
        [key: string]: string;
    };
    /**
     * The working directory to run the command in.
     *
     * Defaults to process.pwd().
     *
     * @stability stable
     */
    readonly cwd: string;
    /**
     * Rust version to compile with
     *
     * @default 1.58
     */
    readonly rustVersion?: string;
}
/**
 * Builds a binary using cargo inside a docker container.
 * It is built to support https://github.com/awslabs/aws-lambda-rust-runtime
 */
export declare class DockerizedCargoBuild extends DockerizedBuild {
    constructor(scope: Construct, name: string, options: CargoOptions);
    get binaryPath(): string;
}
export interface CrossOptions {
    /**
     * Architecture of the binary to build.
     *
     * @default "x86"
     */
    readonly arch?: "arm" | "x86";
    /**
     * Name value in the Cargo.toml
     */
    readonly projectName: string;
    /**
     * @stability stable
     */
    readonly dependsOn?: ITerraformDependable[];
    /**
     * @stability stable
     */
    readonly provider?: TerraformProvider;
    /**
     * @stability stable
     */
    readonly lifecycle?: TerraformResourceLifecycle;
    /**
     * @stability stable
     */
    readonly triggers?: {
        [key: string]: string;
    };
    /**
     * The working directory to run the command in.
     *
     * Defaults to process.pwd().
     *
     * @stability stable
     */
    readonly cwd: string;
}
export declare class CrossBuild extends LocalExec {
    private target;
    readonly projectName: string;
    constructor(scope: Construct, name: string, config: CrossOptions);
    get binaryPath(): string;
}
