# -*- coding: utf-8 -*-
aflow_prototypes = {
    "prototypes_by_spacegroup": {
        1: [
            {
                "Notes": "FeS<sub>2</sub> (P1) Structure",
                "Pearsons Symbol": "aP12",
                "Prototype": "FeS2",
                "Space Group Number": 1,
                "Space Group Symbol": "$P1$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_aP12_1_4a_8a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_aP12_1_4a_8a.html",
                "atom_labels": ["Fe", "Fe", "Fe", "Fe", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.005417, 0.010834, 0.016250999999999998], [2.6900822, 0.0005417, 2.7280012], [2.7090416999999998, 2.719334, 0.0059587], [5.4137498, 2.7155420999999995, 2.7290846], [2.0893368999999997, 2.0757944, 2.0801279999999998], [0.6224133, 3.3119538000000004, 4.7918782], [4.7962118, 0.6267469, 3.3276630999999997], [3.3330800999999997, 4.8021705, 0.6180796999999999], [3.3319967, 3.3217044, 3.3244129], [4.7962118, 2.0682105999999996, 0.6224133], [0.6213299, 4.7972952, 2.0806697], [2.0893368999999997, 0.6289136999999999, 4.7897114]],
                "lattice_vectors": [[5.417, 0.0, 0.0], [0.0, 5.417, 0.0], [0.0, 0.0, 5.417]]
            },
            {
                "Notes": "AsKSe<sub>2</sub> (P1) Structure",
                "Pearsons Symbol": "aP16",
                "Prototype": "AsKSe2",
                "Space Group Number": 1,
                "Space Group Symbol": "$P1$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC2_aP16_1_4a_4a_8a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC2_aP16_1_4a_4a_8a.html",
                "atom_labels": ["As", "As", "As", "As", "K", "K", "K", "K", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se"],
                "atom_positions": [[0.585775447573104, 3.086817492208668, 2.127224258404604], [0.7395353363096242, 4.789494272366929, 5.316858824396593], [1.1008103298169578, 0.3152026963837512, 8.132726868149128], [2.6700246658200864, 0.9676159340208423, 11.328370542215705], [-0.46834551835408456, -0.5138789712191799, 3.1235343771715067], [-1.7951050734751932, 2.2439489803662056, 5.977860712601413], [4.542209070773809, -1.7743548843517634, 9.113413305922098], [0.9986838110352971, -2.2132782608104904, 11.991776073650362], [4.91072942464053, 2.6126211994009023, 2.4913762077247146], [-1.5218864905785083, 0.6591728380373507, 11.798282793648587], [4.885519740311859, -1.1841780341165786, 6.0067044313594415], [0.8196037549696747, 5.379614330451955, 2.94205931331891], [1.3106392994874476, -1.9624821696548531, 8.508897033618416], [1.690779835545299, 0.6967817963973939, 5.790376540674227], [0.0, 0.0, 0.0], [3.2113133007742376, 1.232556149373401, 8.951167387908187]],
                "lattice_vectors": [[6.554, 0.0, 0.0], [-1.97530319852949, 6.253442353926289, 0.0], [-2.2925982535747624, -3.122519535460066, 12.018216149178555]]
            }
        ],
        2: [
            {
                "Notes": "Cf Structure",
                "Pearsons Symbol": "aP4",
                "Prototype": "Cf",
                "Space Group Number": 2,
                "Space Group Symbol": "$P\\bar{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_aP4_2_aci",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_aP4_2_aci.html",
                "atom_labels": ["Cf", "Cf", "Cf", "Cf"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.27787116161836983, 3.695568104844079, 0.0], [2.137790284967192, 1.9265122732124937, 1.2049769625457962], [1.9610929695602555, 5.492817920085966, 1.5778797638879132]],
                "lattice_vectors": [[3.307, 0.0, 0.0], [0.5557423232367397, 7.391136209688158, 0.0], [0.23614093129070776, 0.028193983610302085, 2.7828567264337094]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 1}, "i": {"X_0": 2}}
            },
            {
                "Notes": "P<sub>2</sub>I<sub>4</sub> Structure",
                "Pearsons Symbol": "aP6",
                "Prototype": "I4P2",
                "Space Group Number": 2,
                "Space Group Symbol": "$P\\bar{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_aP6_2_2i_i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_aP6_2_2i_i.html",
                "atom_labels": ["I", "I", "I", "I", "P", "P"],
                "atom_positions": [[1.4485324525664736, 5.259736689733473, 1.1570323316177584], [-0.05492635423684598, 2.689465020965887, 5.855284829701989], [1.4298045289673125, 6.279379769478626, 4.873560427117225], [-0.03619843063768489, 1.6698219412207338, 2.1387567342025235], [0.16705461566149715, 4.910336745530587, 3.2467028456910434], [1.2265514826681305, 3.0388649651687745, 3.7656143156287043]],
                "lattice_vectors": [[4.56, 0.0, 0.0], [-1.0069602719609116, 6.98782019020899, 0.0], [-2.1594336297094605, 0.9613815204903708, 7.012317161319748]],
                "normalized_wyckoff_matid": {"i": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "H<sub>2</sub>S (90 GPa) Structure",
                "Pearsons Symbol": "aP6",
                "Prototype": "H2S",
                "Space Group Number": 2,
                "Space Group Symbol": "$P\\bar{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_aP6_2_aei_i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_aP6_2_aei_i.html",
                "atom_labels": ["H", "H", "H", "H", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.8581318389036763, 1.3155582404972515, 0.0], [1.7659131739099787, 1.4665478394869897, 2.7189352005787195], [2.941913320820341, 1.7296282189951013, 1.3820228696757593], [0.9579483713541022, 0.6255845082813289, 1.0457443079148923], [3.749878123376218, 2.570591550200762, 3.0552137623395867]],
                "lattice_vectors": [[2.7804, 0.0, 0.0], [0.9358636778073522, 2.631116480994503, 0.0], [0.9915628169229674, 0.5650595774875882, 4.100958070254479]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "e": {"X_0": 1}, "i": {"X_0": 2, "X_1": 2}}
            }
        ],
        3: [
            {
                "Notes": "SiO<sub>2</sub> (P2) Structure",
                "Pearsons Symbol": "mP12",
                "Prototype": "O2Si",
                "Space Group Number": 3,
                "Space Group Symbol": "$P2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_mP12_3_bc3e_2e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_mP12_3_bc3e_2e.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "Si", "Si", "Si", "Si"],
                "atom_positions": [[-0.7318429811719911, 0.656863658, 3.6376623198710036], [2.08025, 3.049933546, 0.0], [-0.1772214470928455, 3.1053088000000004, 1.3770006945639697], [2.874035484748864, 3.1053088000000004, 5.898323945178038], [0.666529866487717, 2.951406062, 4.661591509668294], [2.030284171168301, 2.951406062, 2.613733130073714], [1.7619033803600843, 0.8339736240000001, 1.3679065387642921], [0.9349106572959334, 0.8339736240000001, 5.907418100977715], [-0.260430289632207, 0.0, 5.067336364826705], [2.957244327288225, 0.0, 2.207988274915302], [1.3245750992816414, 2.4183418160000003, 1.294789526134885], [1.372238938374376, 2.4183418160000003, 5.9805351136071225]],
                "lattice_vectors": [[4.1605, 0.0, 0.0], [0.0, 4.1294, 0.0], [-1.4636859623439822, 0.0, 7.275324639742007]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "d": {"X_0": 1}, "e": {"X_0": 6, "X_1": 4}}
            }
        ],
        4: [
            {
                "Notes": "High&ndash;pressure Te Structure",
                "Pearsons Symbol": "mP4",
                "Prototype": "Te",
                "Space Group Number": 4,
                "Space Group Symbol": "$P2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_mP4_4_2a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_mP4_4_2a.html",
                "atom_labels": ["Te", "Te", "Te", "Te"],
                "atom_positions": [[0.6679728529201163, 1.7279900000000001, 2.282244766779799], [2.2109705906634596, 5.48449, 2.472431830678116], [1.4854188688716714, 0.0, 0.0950935319491583], [1.3935245747119043, 3.7565, 4.659583065508756]],
                "lattice_vectors": [[3.104, 0.0, 0.0], [0.0, 7.513, 0.0], [-0.22505655641642436, 0.0, 4.754676597457915]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}}
            }
        ],
        5: [
            {
                "Notes": "Po (A19) Structure",
                "Pearsons Symbol": "mC12",
                "Prototype": "Po",
                "Space Group Number": 5,
                "Space Group Symbol": "$C2$",
                "Strukturbericht Designation": "$A19$",
                "aflow_prototype_id": "A_mC12_5_3c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_mC12_5_3c.html",
                "atom_labels": ["Po", "Po", "Po", "Po", "Po", "Po", "Po", "Po", "Po", "Po", "Po", "Po"],
                "atom_positions": [[0.2504396886412112, 1.1583, 3.452395611937466], [6.6774774078535275, 1.1583, 10.639015049031784], [3.9604396886412117, 3.3033, 3.452395611937466], [2.9674774078535284, 3.3033, 10.639015049031784], [4.477766838597896, 1.287, 5.636564264387701], [2.4501502578968437, 1.287, 8.45484639658155], [0.7677668385978951, 3.4320000000000004, 5.636564264387701], [6.160150257896844, 3.4320000000000004, 8.45484639658155], [1.7834541967546316, 1.8447, 0.9863987462678476], [5.144462899740108, 1.8447, 13.105011914701402], [5.493454196754632, 3.9896999999999996, 0.9863987462678476], [1.434462899740108, 3.9896999999999996, 13.105011914701402]],
                "lattice_vectors": [[7.42, 0.0, 0.0], [0.0, 4.29, 0.0], [-0.49208290350526035, 0.0, 14.09141066096925]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}}
            }
        ],
        6: [
            {
                "Notes": "Mo<sub>8</sub>P<sub>5</sub> (High&ndash;temperature) Structure",
                "Pearsons Symbol": "mP13",
                "Prototype": "Mo8P5",
                "Space Group Number": 6,
                "Space Group Symbol": "$Pm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A8B5_mP13_6_a7b_3a2b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A8B5_mP13_6_a7b_3a2b.html",
                "atom_labels": ["Mo", "P", "P", "P", "Mo", "Mo", "Mo", "Mo", "Mo", "Mo", "Mo", "P", "P"],
                "atom_positions": [[1.0858120626694658, 0.0, 6.350830328054295], [1.6211554842407307, 0.0, 3.794382035096578], [-1.5753712409431413, 0.0, 5.234210550631475], [2.4019507738361194, 0.0, 0.046931679780657785], [1.8490876299528858, 1.60440133325, 1.9436799456329028], [4.102900365464248, 1.60440133325, 0.0008855033920878828], [-0.28124818977676763, 1.60440133325, 4.129102317305797], [3.217360753742306, 1.60440133325, 4.654205828813912], [-1.2965529352493999, 1.60440133325, 6.9963623008863625], [4.255940112426775, 1.60440133325, 2.4121112400473925], [0.0, 1.60440133325, 0.0], [2.822829517537336, 1.60440133325, 7.107050224897347], [-0.566018480540747, 1.60440133325, 1.8161674571722477]],
                "lattice_vectors": [[6.5369054321, 0.0, 0.0], [0.0, 3.2088026665, 0.0], [-3.151742649222706, 0.0, 8.855033920878828]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 3}, "b": {"X_0": 7, "X_1": 2}}
            },
            {
                "Notes": "FeNi Structure",
                "Pearsons Symbol": "mP4",
                "Prototype": "FeNi",
                "Space Group Number": 6,
                "Space Group Symbol": "$Pm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_mP4_6_2b_2a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_mP4_6_2b_2a.html",
                "atom_labels": ["Ni", "Ni", "Fe", "Fe"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.8536756519247517, 0.0, 1.818596077977374], [0.09185076643489654, 1.7909877106, 1.7970742309007186], [1.8942683885243479, 1.7909877106, 0.09684831184494891]],
                "lattice_vectors": [[3.580975428, 0.0, 0.0], [0.0, 3.5819754212, 0.0], [-0.0025041810241585986, 0.0, 3.5869745127758854]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}}
            }
        ],
        7: [
            {
                "Notes": "As<sub>2</sub>Ba Structure",
                "Pearsons Symbol": "mP18",
                "Prototype": "As2Ba",
                "Space Group Number": 7,
                "Space Group Symbol": "$Pc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_mP18_7_6a_3a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_mP18_7_6a_3a.html",
                "atom_labels": ["As", "As", "As", "As", "As", "As", "As", "As", "As", "As", "As", "As", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba"],
                "atom_positions": [[2.7535121149981205, 6.05043479474488, 2.1564371791556085], [0.2930168873292888, 6.48153453985512, 5.334210800074571], [1.5764296766984682, 8.14327367362308, 1.9492463390716919], [-0.8840655509703638, 4.38869566097692, 5.127019959990655], [2.2945188623763664, 4.30222507256818, 0.5675503686961269], [-0.1659763652924659, 8.22974426203182, 3.7453239896150903], [0.19947645494220356, 1.9437084437964598, 2.1812238133987765], [-2.2610187727266284, 10.58826089080354, 5.358997434317739], [-1.7827392314469244, 1.39355499000752, 3.5476664703939305], [0.6777559962219077, 11.13841434459248, 0.3698928494749675], [0.0, 0.93488491236116, 0.0], [-2.460495227668832, 11.59708442223884, 3.177773620918963], [3.269777465947386, 0.984010232152792, 0.5929725576634785], [0.8092822382785542, 11.547959102447207, 3.770746178582441], [-0.6702688934578858, 5.209163693313181, 1.8672597796519828], [-3.130764121126718, 7.322805641286818, 5.045033400570946], [2.274390172657041, 3.40305627281063, 4.230252244167324], [4.734885400325873, 9.12891306178937, 1.0524786232483603]],
                "lattice_vectors": [[6.5499839723, 0.0, 0.0], [0.0, 12.5319693346, 0.0], [-4.920990455337664, 0.0, 6.355547241837926]],
                "normalized_wyckoff_matid": {"a": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "$\\epsilon$&ndash;WO<sub>3</sub> (Low&ndash;temperature) Structure",
                "Pearsons Symbol": "mP16",
                "Prototype": "O3W",
                "Space Group Number": 7,
                "Space Group Symbol": "$Pc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_mP16_7_6a_2a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_mP16_7_6a_2a.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "W", "W", "W", "W"],
                "atom_positions": [[2.659765938399055, 1.5055228584291998, 0.07660276597979424], [2.5419416932958, 3.6503773416707994, 3.9067410649695056], [2.904034022785705, 1.1085185430214999, 4.488922086415942], [3.0218582678889603, 4.0473816570785, 0.6587837874262292], [0.0, 1.0775831418208999, 0.0], [-0.11782424510325526, 4.0783170582791, 3.8301382989897115], [0.3193258133749439, 1.4952110580289997, 4.442960426828065], [0.43715005847819915, 3.6606891420709995, 0.6128221278383544], [1.4492086621702516, 0.36967804434717, 2.1984993836200943], [1.3313844170669962, 4.78622215575283, 6.028637682609805], [4.11119868673136, 2.1659936740620096, 2.305743255991806], [3.993374441628105, 2.98990652603799, 6.135881554981517], [1.5165570006712723, 0.0721826028014, 0.009192331917575307], [1.398732755568017, 5.0837175972986, 3.8393306309072868], [4.200692901481013, 2.7223153056528, 0.597501574642395], [4.082868656377757, 2.4335848944471996, 4.427639873632106]],
                "lattice_vectors": [[5.2778002048, 0.0, 0.0], [0.0, 5.1559002001, 0.0], [-0.23564849020651052, 0.0, 7.660276597979423]],
                "normalized_wyckoff_matid": {"a": {"X_0": 3, "X_1": 1}}
            },
            {
                "Notes": "Rh<sub>2</sub>Ga<sub>9</sub> Structure",
                "Pearsons Symbol": "mP22",
                "Prototype": "Ga9Rh2",
                "Space Group Number": 7,
                "Space Group Symbol": "$Pc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A9B2_mP22_7_9a_2a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A9B2_mP22_7_9a_2a.html",
                "atom_labels": ["Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Rh", "Rh", "Rh", "Rh"],
                "atom_positions": [[3.1653090035351545, 1.51900479803829, 0.1183879329392943], [2.905575525471249, 4.89300363606171, 4.503126189950194], [1.6132555721023345, 1.6818698122644298, 4.882844523007338], [1.87298905016624, 4.73013862183557, 0.4981062659964379], [3.0281111891796813, 2.8552673557047297, 2.5536715608831484], [2.7683777111157757, 3.5567410783952695, 6.9384098178940485], [1.661819966129489, 0.35714886977937, 2.4598381621831154], [1.4020864880655834, 6.05485956432063, 6.844576419194015], [5.149912387198273, 3.52083383116431, 0.4437355116095031], [4.890178909134367, 2.8911746029356897, 4.828473768620403], [0.0, 0.19813106061368999, 0.0], [-0.2597334780639056, 6.2138773734863095, 4.3847382570109], [3.959955556059163, 0.98680809800799, 6.526244421735024], [4.219689034123069, 5.42520033609201, 2.1415061647241234], [0.4467424826727592, 4.06713694974963, 2.857095448268302], [0.18700900460885353, 2.34487148435037, 7.241833705279203], [5.411362697992875, 1.53182881490649, 2.215169767441907], [5.151629219928969, 4.88017961919351, 6.599908024452806], [3.8458223243356993, 0.78034142642997, 3.9576647507780383], [3.5860888462717937, 5.631667007670029, 8.342403007788938], [0.9418755719925388, 2.41155637206501, 0.9977033430002602], [0.6821420939286331, 4.00045206203499, 5.382441600011161]],
                "lattice_vectors": [[6.4165085102, 0.0, 0.0], [0.0, 6.4120084341, 0.0], [-0.5194669561278112, 0.0, 8.7694765140218]],
                "normalized_wyckoff_matid": {"a": {"X_0": 9, "X_1": 2}}
            },
            {
                "Notes": "H<sub>2</sub>S IV Structure",
                "Pearsons Symbol": "mP12",
                "Prototype": "H2S",
                "Space Group Number": 7,
                "Space Group Symbol": "$Pc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_mP12_7_4a_2a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_mP12_7_4a_2a.html",
                "atom_labels": ["H", "H", "H", "H", "H", "H", "H", "H", "S", "S", "S", "S"],
                "atom_positions": [[2.520230639667969, 2.9977541999999997, 2.5150910836379983], [2.5025601308416654, 0.19814579999999998, 5.1793824857968955], [4.971979634475677, 1.8344466, 0.7619873410174445], [4.954309125649373, 1.3614534, 3.4262787431763413], [3.9299559268955666, 3.0297131999999998, 4.257537660649917], [3.94762643572187, 0.1661868, 1.5932462584910199], [1.3713041943926696, 0.4825809, 1.3907601119269442], [1.3536336855663658, 2.7133191, 4.055051514085841], [5.076383033645061, 2.5822872, 1.9182898095544056], [5.058712524818757, 0.6136127999999998, 4.582581211713302], [2.4932804103845845, 2.0741391, 3.5062074852411085], [2.510950919210888, 1.1217609, 0.841916083082211]],
                "lattice_vectors": [[5.0942, 0.0, 0.0], [0.0, 3.1959, 0.0], [-0.035341017652607415, 0.0, 5.328582804317794]],
                "normalized_wyckoff_matid": {"a": {"X_0": 2, "X_1": 1}}
            }
        ],
        8: [
            {
                "Notes": "Monoclinic PZT [Pb(Zr<sub>x</sub>Ti<sub>1&ndash;x</sub>)O<sub>3</sub>] Structure",
                "Pearsons Symbol": "mC10",
                "Prototype": "O3Pb(Ti0.48)Zr0.52",
                "Space Group Number": 8,
                "Space Group Symbol": "$Cm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3BC_mC10_8_ab_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3BC_mC10_8_ab_a_a.html",
                "atom_labels": ["O", "O", "Pb", "Pb", "Zr", "Zr", "O", "O", "O", "O"],
                "atom_positions": [[3.123325774337679, 0.0, 3.725200188953192], [0.2623057743376785, 2.854785, 3.725200188953192], [0.0, 0.0, 0.0], [2.86102, 2.854785, 0.0], [2.976476825485771, 0.0, 1.8580501053495158], [0.1154568254857719, 2.854785, 1.8580501053495158], [1.6345406405602048, 1.389709338, 1.5424463140802191], [1.6345406405602048, 4.319860662, 1.5424463140802191], [4.495560640560204, 4.244494338000001, 1.5424463140802191], [4.495560640560204, 1.465075662, 1.5424463140802191]],
                "lattice_vectors": [[5.72204, 0.0, 0.0], [0.0, 5.70957, 0.0], [-0.03595301539231711, 0.0, 4.136353751891175]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1, "X_2": 1}, "b": {"X_0": 2}}
            }
        ],
        9: [
            {
                "Notes": "Monoclinic (Cc) Low Tridymite (SiO<sub>2</sub>) Structure",
                "Pearsons Symbol": "mC144",
                "Prototype": "O2Si",
                "Space Group Number": 9,
                "Space Group Symbol": "$Cc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_mC144_9_24a_12a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_mC144_9_24a_12a.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[5.33851996753135, 1.7561231999999998, 18.743445088980973], [8.584014731934094, 3.2470768, 7.289372069559699], [-3.923480032468651, 4.257723199999999, 18.743445088980973], [-0.677985268065907, 0.7454768, 7.289372069559699], [-4.192115924615532, 1.701088, 19.41694458252294], [-0.946621160212787, 3.3021119999999993, 7.962871563101666], [5.069884075384468, 4.202688, 19.41694458252294], [8.315378839787213, 0.8005119999999998, 7.962871563101666], [10.40152697957646, 0.6904416, 11.112741643442519], [7.156032215173715, 4.3127584, 22.56681466286379], [1.139526979576459, 3.1920416, 11.112741643442519], [-2.105967784826285, 1.8111583999999998, 22.56681466286379], [1.3035137947594133, 0.7204607999999999, 11.802276839211679], [4.549008559162156, 4.2827392, 0.34820381979040904], [10.565513794759413, 3.2220608, 11.802276839211679], [13.811008559162158, 1.7811391999999997, 0.34820381979040904], [3.3211459586322203, 1.7611263999999998, 15.44238124478376], [6.566640723034964, 3.2420736, 3.9883082253624904], [12.583145958632223, 4.2627264, 15.44238124478376], [15.828640723034965, 0.7404736000000001, 3.9883082253624904], [12.730552137166551, 1.7611263999999998, 14.739101161391293], [15.976046901569294, 3.2420736, 3.2850281419700202], [3.46855213716655, 4.2627264, 14.739101161391293], [6.7140469015692945, 0.7404736000000001, 3.2850281419700202], [10.270956547111505, 0.8205247999999999, 21.105274945585638], [13.516451311514249, 4.182675199999999, 9.651201926164365], [1.0089565471115036, 3.3221248, 21.105274945585638], [4.254451311514248, 1.6810751999999998, 9.651201926164365], [1.629768702085182, 0.8405376, 21.444315506960507], [4.875263466487927, 4.162662399999999, 9.990242487539234], [10.89176870208518, 3.3421376, 21.444315506960507], [14.137263466487925, 1.6610623999999996, 9.990242487539234], [9.446520493186425, 0.7254639999999999, 17.268160484079512], [12.692015257589167, 4.277736, 5.814087464658239], [0.18452049318642336, 3.227064, 17.268160484079512], [3.4300152575891674, 1.7761359999999997, 5.814087464658239], [-0.4774240492218216, 0.7154575999999999, 16.95660969795125], [2.7680707151809223, 4.2877424, 5.502536678529979], [8.78457595077818, 3.2170576, 16.95660969795125], [12.030070715180925, 1.7861423999999997, 5.502536678529979], [7.680336422507432, 1.7060912, 13.394392988911237], [10.925831186910177, 3.2971087999999997, 1.9403199694899635], [-1.58166357749257, 4.207691199999999, 13.394392988911237], [1.663831186910174, 0.7955087999999998, 1.9403199694899635], [-2.1722527722567873, 1.7160976000000001, 12.968301472588767], [1.073241992145957, 3.2871023999999998, 1.5142284531674934], [7.089747227743212, 4.217697599999999, 12.968301472588767], [10.335241992145956, 0.7855023999999998, 1.5142284531674934], [14.526180547638115, 0.05503519999999999, 13.88691812874635], [17.77167531204086, 4.9481648, 2.4328451093250747], [5.264180547638113, 2.5566351999999997, 13.88691812874635], [8.509675312040859, 2.4465648, 2.4328451093250747], [2.867383631931691, 2.4465648, 12.977464731004302], [6.112878396334436, 2.5566351999999997, 1.5233917115830293], [12.129383631931692, 4.9481648, 12.977464731004302], [15.374878396334434, 0.05503520000000005, 1.5233917115830293], [7.680792127218639, 0.025016, 15.373656806667233], [10.926286891621382, 4.978184, 3.9195837872459602], [-1.581207872781364, 2.5266159999999998, 15.373656806667233], [1.66428689162138, 2.476584, 3.9195837872459602], [-2.243159727232683, 2.4815872, 17.879807983316606], [1.002335037170061, 2.5216127999999998, 6.425734963895334], [7.018840272767317, 4.9831872, 17.879807983316606], [10.264335037170062, 0.020012800000000018, 6.425734963895334], [11.24072927329134, 2.4965968, 16.787089417263818], [14.486224037694084, 2.5066032, 5.333016397842547], [1.9787292732913373, 4.9981968, 16.787089417263818], [5.22422403769408, 0.0050032000000000045, 5.333016397842547], [0.8169748256463873, 0.0150096, 19.089358094167494], [4.062469590049132, 4.9881904, 7.635285074746219], [10.078974825646387, 2.5166096, 19.089358094167494], [13.324469590049132, 2.4865904, 7.635285074746219], [-4.7057092534103, 2.4665776, 16.947446439535714], [-1.4602144890075561, 2.5366223999999997, 5.493373420114443], [4.5562907465897, 4.9681776, 16.947446439535714], [7.801785510992444, 0.03502240000000003, 5.493373420114443], [-3.479913495296926, 0.05503519999999999, 21.23126974879927], [-0.23441873089418225, 4.9481648, 9.777196729377998], [5.7820865047030745, 2.5566351999999997, 21.23126974879927], [9.027581269105818, 2.4465648, 9.777196729377998], [3.3705652858552946, 2.4615744, 20.31494390724557], [6.616060050258039, 2.5416255999999997, 8.860870887824298], [12.632565285855293, 4.9631744, 20.31494390724557], [15.878060050258037, 0.040025600000000036, 8.860870887824298], [6.016505235597256, 2.3414976, 11.454073019421273], [9.262, 2.6617024, 0.0], [-3.245494764402744, 4.843097599999999, 11.454073019421273], [0.0, 0.16010239999999987, 0.0], [0.3432191759105239, 2.4565712, 13.511224533709333], [3.588713940313269, 2.5466287999999997, 2.0571515142880576], [9.605219175910525, 4.9581712, 13.511224533709333], [12.85071394031327, 0.045028800000000035, 2.0571515142880576], [-0.8595153136214245, 0.1050672, 20.97240769856035], [2.3859794507813197, 4.8981328, 9.518334679139077], [8.402484686378576, 2.6066672, 20.97240769856035], [11.647979450781321, 2.3965327999999997, 9.518334679139077], [-2.7230494921520565, 0.20513119999999999, 12.924775995114965], [0.5224452722506875, 4.798068799999999, 1.4707029756936922], [6.538950507847943, 2.7067312, 12.924775995114965], [9.784445272250688, 2.2964688, 1.4707029756936922], [-0.9974436068133922, 2.2364303999999997, 16.830614894737618], [2.248051157589351, 2.7667695999999995, 5.376541875316349], [8.26455639318661, 4.7380304, 16.830614894737618], [11.510051157589352, 0.26516959999999995, 5.376541875316349], [12.997734218318584, 0.24515679999999998, 14.260320909179486], [16.243228982721327, 4.7580431999999995, 2.8062478897582133], [3.7357342183185835, 2.7467568, 14.260320909179486], [6.981228982721328, 2.2564432, 2.8062478897582133], [5.489570229835234, 0.21513759999999996, 18.223430173899246], [8.735064994237977, 4.788062399999999, 6.769357154477975], [-3.772429770164767, 2.7167376, 18.223430173899246], [-0.5269350057620233, 2.2864624, 6.769357154477975], [3.3422739994696946, 0.2401536, 15.96926860367714], [6.587768763872439, 4.7630463999999995, 4.515195584255867], [12.604273999469697, 2.7417536, 15.96926860367714], [15.849768763872442, 2.2614464, 4.515195584255867], [1.399846239785364, 2.2214207999999998, 12.338327456520595], [4.645341004188108, 2.7817792, 0.8842544370993215], [10.661846239785364, 4.7230208, 12.338327456520595], [13.907341004188108, 0.28017919999999996, 0.8842544370993215], [9.889058121982117, 2.2464367999999997, 17.549930680357274], [13.13455288638486, 2.7567631999999995, 6.095857660936002], [0.627058121982116, 4.7480368, 17.549930680357274], [3.87255288638486, 0.2551631999999999, 6.095857660936002], [8.041417810988932, 0.20513119999999999, 13.806739617610402], [11.286912575391677, 4.798068799999999, 2.35266659818913], [-1.220582189011068, 2.7067312, 13.806739617610402], [2.024912575391676, 2.2964688, 2.35266659818913], [9.950548240828972, 2.3164816, 20.65398446862044], [13.196043005231717, 2.6867183999999993, 9.199911449199167], [0.6885482408289721, 4.8180816, 20.65398446862044], [3.934043005231716, 0.18511839999999988, 9.199911449199167], [2.2485651989438242, 2.3314912, 21.437443063148855], [5.494059963346568, 2.6717087999999998, 9.983370043727582], [11.510565198943826, 4.833091199999999, 21.437443063148855], [14.756059963346571, 0.17010879999999987, 9.983370043727582], [-2.0778098424176714, 0.2951888, 22.003274270308264], [1.1676849219850727, 4.7080112, 10.549201250886993], [7.184190157582328, 2.7967887999999994, 22.003274270308264], [10.429684921985071, 2.2064112, 10.549201250886993], [-4.357336287966535, 0.24515679999999998, 19.934668683000783], [-1.1118415235637922, 4.7580431999999995, 8.480595663579512], [4.904663712033465, 2.7467568, 19.934668683000783], [8.150158476436209, 2.2564432, 8.480595663579512]],
                "lattice_vectors": [[18.524, 0.0, 0.0], [0.0, 5.0032, 0.0], [-6.490989528805488, 0.0, 22.908146038842546]],
                "normalized_wyckoff_matid": {"a": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "H<sub>3</sub>Cl (20 GPa) Structure",
                "Pearsons Symbol": "mC16",
                "Prototype": "ClH3",
                "Space Group Number": 9,
                "Space Group Symbol": "$Cc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_mC16_9_a_3a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_mC16_9_a_3a.html",
                "atom_labels": ["Cl", "Cl", "Cl", "Cl", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[1.7009177813492604, 3.366857455, 1.7425251340379817], [1.6090414531188273, 6.103642545, 3.4851548258574727], [-0.06743221865073953, 8.102107454999999, 1.7425251340379817], [-0.1593085468811728, 1.368392545, 3.4851548258574727], [0.9622919740020786, 2.5098719099999998, 0.9728404517551489], [0.8704156457716452, 6.960628089999999, 2.7154701435746396], [2.7306419740020784, 7.24512191, 0.9728404517551489], [2.6387656457716453, 2.22537809, 2.7154701435746396], [1.9414381263926948, 0.59247448, 1.4636695307530267], [1.8495617981622614, 8.87802552, 3.2062992225725173], [0.17308812639269427, 5.32772448, 1.4636695307530267], [0.08121179816226101, 4.14277552, 3.2062992225725173], [1.388564852425589, 0.6664390849999999, 1.9529999482159397], [1.4804411806560223, 8.804060914999999, 0.21037025639644882], [3.156914852425589, 5.401689085, 1.9529999482159397], [3.248791180656022, 4.068810915, 0.21037025639644882]],
                "lattice_vectors": [[3.5367, 0.0, 0.0], [0.0, 9.4705, 0.0], [-0.18375265646086653, 0.0, 3.4852593836389816]],
                "normalized_wyckoff_matid": {"a": {"X_0": 3, "X_1": 1}}
            },
            {
                "Notes": "$\\alpha$&ndash;P<sub>3</sub>N<sub>5</sub> Structure",
                "Pearsons Symbol": "mC32",
                "Prototype": "N5P3",
                "Space Group Number": 9,
                "Space Group Symbol": "$Cc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A5B3_mC32_9_5a_3a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B3_mC32_9_5a_3a.html",
                "atom_labels": ["N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P"],
                "atom_positions": [[-0.9996942194546851, 5.81682701, 2.218265090071876], [-2.9937112258760328, 0.01750299, 6.341434402473132], [3.0606907805453147, 2.8996620099999997, 2.218265090071876], [1.0666737741239671, 2.93466799, 6.341434402473132], [-0.7470359757792129, 1.98950653, 3.7108523811611303], [-2.7410529822005603, 3.8448234699999997, 7.834021693562386], [3.3133490242207877, 4.90667153, 3.7108523811611303], [1.3193320177994403, 0.9276584699999998, 7.834021693562386], [2.7414746551523823, 0.69428527, 0.5442583492369658], [0.7474576487310343, 5.14004473, 4.667427661638222], [6.8018596551523824, 3.6114502699999997, 0.5442583492369658], [4.807842648731034, 2.22287973, 4.667427661638222], [0.5669083401121238, 2.0478498299999996, 1.2122117778459691], [-1.427108666309224, 3.78648017, 5.335381090247226], [4.627293340112124, 4.965014829999999, 1.2122117778459691], [2.6332763336907767, 0.86931517, 5.335381090247226], [1.503158283530742, 0.78763455, 2.869725841431274], [-0.49085872289060567, 5.04669545, 6.99289515383253], [5.563543283530742, 3.7047995499999997, 2.869725841431274], [3.5695262771093947, 2.12953045, 6.99289515383253], [0.0, 3.0233498059999997, 0.0], [-1.9940170064213476, 2.810980194, 4.123169312401256], [4.060385, 0.10618480599999995, 0.0], [2.0663679935786528, 5.728145194, 4.123169312401256], [-0.12787778996839266, 1.166866, 2.548118635063976], [-2.12189479638974, 4.667464, 6.671287947465231], [3.9325072100316074, 4.0840309999999995, 2.548118635063976], [1.9384902036102598, 1.7502989999999998, 6.671287947465231], [2.1824263834828317, 1.705958092, 1.6162823704612923], [0.18840937706148422, 4.128371908, 5.739451682862548], [6.242811383482832, 4.623123091999999, 1.6162823704612923], [4.248794377061484, 1.2112069079999999, 5.739451682862548]],
                "lattice_vectors": [[8.12077, 0.0, 0.0], [0.0, 5.83433, 0.0], [-3.988034012842695, 0.0, 8.246338624802512]],
                "normalized_wyckoff_matid": {"a": {"X_0": 5, "X_1": 3}}
            }
        ],
        10: [
            {
                "Notes": "S&ndash;carbon Structure",
                "Pearsons Symbol": "mP8",
                "Prototype": "C",
                "Space Group Number": 10,
                "Space Group Symbol": "$P2/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_mP8_10_2m2n",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_mP8_10_2m2n.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C"],
                "atom_positions": [[-0.2081656606014948, 0.0, 2.64681592295479], [3.8058958109105747, 0.0, 1.276717908878578], [2.150366679098016, 0.0, 1.3077138261500614], [1.4473634712110635, 0.0, 2.6158200056833065], [-0.4816325640675391, 1.2475, 3.5221563208368147], [4.079362714376619, 1.2475, 0.40137751099655333], [1.8415684068257674, 1.2475, 0.5175141124188212], [1.756161743483312, 1.2475, 3.4060197194145467]],
                "lattice_vectors": [[4.7302, 0.0, 0.0], [0.0, 2.495, 0.0], [-1.1324698496909202, 0.0, 3.923533831833368]],
                "normalized_wyckoff_matid": {"m": {"X_0": 1}, "n": {"X_0": 1}}
            },
            {
                "Notes": "Muthmannite (AuAgTe<sub>2</sub>) Structure",
                "Pearsons Symbol": "mP8",
                "Prototype": "AgAuTe2",
                "Space Group Number": 10,
                "Space Group Symbol": "$P2/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC2_mP8_10_ac_eh_mn",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC2_mP8_10_ac_eh_mn.html",
                "atom_labels": ["Ag", "Ag", "Au", "Au", "Te", "Te", "Te", "Te"],
                "atom_positions": [[0.0, 0.0, 0.0], [-0.001361073887333323, 0.0, 3.71351361227018], [2.55887173765, 2.20338955605, 0.0], [2.557510663762667, 2.20338955605, 3.71351361227018], [3.1155358139997333, 0.0, 1.7957809126216138], [1.9994855135256002, 0.0, 5.631246311918747], [0.6528576731207073, 2.20338955605, 1.85029529244974], [4.462163654404626, 2.20338955605, 5.57673193209062]],
                "lattice_vectors": [[5.1177434753, 0.0, 0.0], [0.0, 4.4067791121, 0.0], [-0.002722147774666646, 0.0, 7.42702722454036]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_1": 1}, "e": {"X_2": 1}, "h": {"X_2": 1}, "m": {"X_0": 2}, "n": {"X_0": 2}}
            },
            {
                "Notes": "H<sub>3</sub>Cl (400 GPa) Structure",
                "Pearsons Symbol": "mP16",
                "Prototype": "ClH3",
                "Space Group Number": 10,
                "Space Group Symbol": "$P2/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_mP16_10_mn_3m3n",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_mP16_10_mn_3m3n.html",
                "atom_labels": ["Cl", "Cl", "H", "H", "H", "H", "H", "H", "Cl", "Cl", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[0.9403708702276832, 0.0, 1.543570870868608], [2.658150870856928, 0.0, 3.009735532873598], [0.28955078272399204, 0.0, 0.2686450778207901], [3.3089709583606193, 0.0, 4.284661325921416], [2.8969079137098523, 0.0, 1.5526774836760924], [0.7016138273747585, 0.0, 3.000628920066114], [1.536969740949773, 0.0, 4.239128261883994], [2.0615520001348386, 0.0, 0.31417814185821225], [2.7935180003146223, 1.3075, 0.7330823310024952], [0.8050037407699886, 1.3075, 3.8202240727397108], [2.526148784252158, 1.3075, 3.829330685547195], [1.0723729568324532, 1.3075, 0.7239757181950108], [2.0981900878183133, 1.3075, 2.008008124050313], [1.5003316532662978, 1.3075, 2.545298279691893], [0.19378087040746736, 1.3075, 1.9624750600128908], [3.404740870677143, 1.3075, 2.590831343729315]],
                "lattice_vectors": [[3.678, 0.0, 0.0], [0.0, 2.615, 0.0], [-0.07947825891538896, 0.0, 4.553306403742206]],
                "normalized_wyckoff_matid": {"m": {"X_0": 3, "X_1": 1}, "n": {"X_0": 3, "X_1": 1}}
            },
            {
                "Notes": "$\\delta$&ndash;PdCl<sub>2</sub> Structure",
                "Pearsons Symbol": "mP6",
                "Prototype": "Cl2Pd",
                "Space Group Number": 10,
                "Space Group Symbol": "$P2/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_mP6_10_mn_bg",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_mP6_10_mn_bg.html",
                "atom_labels": ["Pd", "Pd", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[0.0, 1.644, 0.0], [1.2850062677129457, 0.0, 5.846712669355557], [3.200425579463662, 0.0, 1.4733715926776003], [-0.6304130440377705, 0.0, 10.220053746033514], [1.3100560728142743, 1.644, 7.530565918129957], [1.259956462611617, 1.644, 4.162859420581157]],
                "lattice_vectors": [[4.012, 0.0, 0.0], [0.0, 3.288, 0.0], [-1.4419874645741082, 0.0, 11.693425338711114]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "h": {"X_1": 1}, "m": {"X_0": 2}, "n": {"X_0": 2}}
            },
            {
                "Notes": "LiSn Structure",
                "Pearsons Symbol": "mP6",
                "Prototype": "LiSn",
                "Space Group Number": 10,
                "Space Group Symbol": "$P2/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_mP6_10_en_am",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_mP6_10_en_am.html",
                "atom_labels": ["Sn", "Li", "Sn", "Sn", "Li", "Li"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.58502081835, 1.5900128051, 0.0], [-0.06926177051701782, 0.0, 4.945725236319129], [3.3013465685733543, 0.0, 2.5477978490128845], [0.7085674526678291, 1.5900128051, 2.517823756671557], [2.5235173453885076, 1.5900128051, 4.975699328660457]],
                "lattice_vectors": [[5.1700416367, 0.0, 0.0], [0.0, 3.1800256102, 0.0], [-1.9379568386436632, 0.0, 7.493523085332014]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "e": {"X_1": 1}, "m": {"X_0": 2}, "n": {"X_1": 2}}
            }
        ],
        11: [
            {
                "Notes": "KClO<sub>3</sub> (G0<sub>6</sub>) Structure",
                "Pearsons Symbol": "mP10",
                "Prototype": "ClKO3",
                "Space Group Number": 11,
                "Space Group Symbol": "$P2_{1}/m$",
                "Strukturbericht Designation": "$G0_{6}$",
                "aflow_prototype_id": "ABC3_mP10_11_e_e_ef",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC3_mP10_11_e_e_ef.html",
                "atom_labels": ["Cl", "Cl", "K", "K", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.13541487064911997, 1.392, 1.1539921511764475], [2.060114474044977, 4.176, 5.459143385651332], [-0.09021290634976278, 1.392, 4.686067841396165], [2.2857422510438603, 4.176, 1.9270676954316148], [1.5725511686568623, 1.392, 0.7704302900404363], [0.6229781760372346, 4.176, 5.842705246787343], [2.265619024021112, 2.9850048, 4.591500003219528], [-0.07008967932701475, 0.2010048000000001, 2.021635533608252], [-0.07008967932701475, 2.5829951999999996, 2.021635533608252], [2.265619024021112, 5.3669952, 4.591500003219528]],
                "lattice_vectors": [[4.63, 0.0, 0.0], [0.0, 5.568, 0.0], [-2.434470655305903, 0.0, 6.613135536827779]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1, "X_1": 1, "X_2": 1}, "f": {"X_0": 2}}
            },
            {
                "Notes": "$\\alpha$&ndash;Pu Structure",
                "Pearsons Symbol": "mP16",
                "Prototype": "Pu",
                "Space Group Number": 11,
                "Space Group Symbol": "$P2_{1}/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_mP16_11_8e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_mP16_11_8e.html",
                "atom_labels": ["Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu"],
                "atom_positions": [[1.770252211497446, 1.2055, 1.7385377171187888], [2.172730575523827, 3.6165000000000003, 8.993176586083612], [4.366038108219573, 1.2055, 1.8029280029380033], [-0.42305532119830136, 3.6165000000000003, 8.928786300264397], [0.029818147587232623, 1.2055, 3.648782863088816], [3.9131646394340396, 3.6165000000000003, 7.082931440113583], [3.038543133668721, 1.2055, 4.904393436563497], [0.9044396533525508, 3.6165000000000003, 5.827320866638902], [-1.2297556376208536, 1.2055, 6.632199439379083], [5.172738424642126, 3.6165000000000003, 4.099514863823317], [1.4618277599248908, 1.2055, 7.007809439991168], [2.4811550270963814, 3.6165000000000003, 3.723904863211233], [-0.04623193921830191, 1.2055, 9.937567444765422], [3.989214726239574, 3.6165000000000003, 0.7941468584369776], [3.370451611597017, 1.2055, 9.594152587062945], [0.572531175424255, 3.6165000000000003, 1.1375617161394542]],
                "lattice_vectors": [[6.183, 0.0, 0.0], [0.0, 4.822, 0.0], [-2.2400172129787275, 0.0, 10.7317143032024]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1}}
            },
            {
                "Notes": "NiTi Structure",
                "Pearsons Symbol": "mP4",
                "Prototype": "NiTi",
                "Space Group Number": 11,
                "Space Group Symbol": "$P2_{1}/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_mP4_11_e_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_mP4_11_e_e.html",
                "atom_labels": ["Ni", "Ni", "Ti", "Ti"],
                "atom_positions": [[0.6435022253911961, 1.02655, 3.814633380006832], [2.8847724660668703, 3.07965, 0.8080440073014954], [2.1606966483434746, 1.02655, 3.3209314350423025], [1.3675780431145914, 3.07965, 1.3017459522660246]],
                "lattice_vectors": [[2.8837, 0.0, 0.0], [0.0, 4.1062, 0.0], [0.644574691458066, 0.0, 4.622677387308327]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1, "X_1": 1}}
            }
        ],
        12: [
            {
                "Notes": "$\\alpha$&ndash;O Structure",
                "Pearsons Symbol": "mC4",
                "Prototype": "O",
                "Space Group Number": 12,
                "Space Group Symbol": "$C2/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_mC4_12_i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_mC4_12_i.html",
                "atom_labels": ["O", "O", "O", "O"],
                "atom_positions": [[-0.018862704384555506, 0.0, 0.6496829742950581], [2.002321060543194, 0.0, 3.1057099407052773], [2.6826372956154443, 1.7165, 0.6496829742950581], [-0.6991789394568059, 1.7165, 3.1057099407052773]],
                "lattice_vectors": [[5.403, 0.0, 0.0], [0.0, 3.433, 0.0], [-3.4195416438413613, 0.0, 3.7553929150003356]],
                "normalized_wyckoff_matid": {"i": {"X_0": 1}}
            },
            {
                "Notes": "Calaverite (AuTe<sub>2</sub>, C34) Structure",
                "Pearsons Symbol": "mC6",
                "Prototype": "AuTe2",
                "Space Group Number": 12,
                "Space Group Symbol": "$C2/m$",
                "Strukturbericht Designation": "$C34$",
                "aflow_prototype_id": "AB2_mC6_12_a_i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_mC6_12_a_i.html",
                "atom_labels": ["Au", "Au", "Te", "Te", "Te", "Te"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.5945, 2.2035, 0.0], [4.9442907322141085, 0.0, 1.464433743126305], [2.2411704384820106, 0.0, 3.604565021589185], [1.3497907322141085, 2.2035, 1.464433743126305], [5.835670438482011, 2.2035, 3.604565021589185]],
                "lattice_vectors": [[7.189, 0.0, 0.0], [0.0, 4.407, 0.0], [-0.0035388293038805343, 0.0, 5.06899876471549]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "i": {"X_0": 2}}
            },
            {
                "Notes": "$\\beta$&ndash;Pu Structure",
                "Pearsons Symbol": "mC34",
                "Prototype": "Pu",
                "Space Group Number": 12,
                "Space Group Symbol": "$C2/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_mC34_12_ah3i2j",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_mC34_12_ah3i2j.html",
                "atom_labels": ["Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu"],
                "atom_positions": [[0.0, 0.0, 0.0], [5.969355, 5.2315, 0.0], [-2.473133528247024, 2.30186, 3.0536176580345527], [-2.473133528247024, 8.16114, 3.0536176580345527], [3.496221471752976, 7.533359999999999, 3.0536176580345527], [3.496221471752976, 2.92964, 3.0536176580345527], [9.003607979384935, 0.0, 1.4718437111726543], [-2.0111650358789825, 0.0, 4.635391604896451], [3.0342529793849358, 5.2315, 1.4718437111726543], [3.958189964121017, 5.2315, 4.635391604896451], [4.230395772911934, 0.0, 4.549890310471484], [2.762047170594018, 0.0, 1.557345005597622], [-1.7389592270880654, 5.2315, 4.549890310471484], [8.731402170594018, 5.2315, 1.557345005597622], [5.580098300554416, 0.0, 1.453522005224447], [1.412344642951536, 0.0, 4.653713310844658], [-0.3892566994455854, 5.2315, 1.453522005224447], [7.381699642951537, 5.2315, 4.653713310844658], [-0.5250131254037681, 2.427416, 5.881267609374548], [7.517456068909721, 2.427416, 0.22596770669455687], [7.517456068909721, 8.035584, 0.22596770669455687], [-0.5250131254037681, 8.035584, 5.881267609374548], [5.444341874596232, 7.658916, 5.881267609374548], [1.5481010689097203, 7.658916, 0.22596770669455687], [1.5481010689097203, 2.804084, 0.22596770669455687], [5.444341874596232, 2.804084, 5.881267609374548], [1.0770779348944883, 3.6620499999999994, 3.5788398952164955], [5.915365008611465, 3.6620499999999994, 2.52839542085261], [5.915365008611465, 6.800949999999999, 2.52839542085261], [1.0770779348944883, 6.800949999999999, 3.5788398952164955], [7.046432934894488, 8.89355, 3.5788398952164955], [-0.05398999138853643, 8.89355, 2.52839542085261], [-0.05398999138853643, 1.56945, 2.52839542085261], [7.046432934894488, 1.56945, 3.5788398952164955]],
                "lattice_vectors": [[11.93871, 0.0, 0.0], [0.0, 10.463, 0.0], [-4.946267056494048, 0.0, 6.107235316069105]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "h": {"X_0": 2}, "i": {"X_0": 6}, "j": {"X_0": 8}}
            },
            {
                "Notes": "Au<sub>5</sub>Mn<sub>2</sub> Structure",
                "Pearsons Symbol": "mC14",
                "Prototype": "Au5Mn2",
                "Space Group Number": 12,
                "Space Group Symbol": "$C2/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A5B2_mC14_12_a2i_i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B2_mC14_12_a2i_i.html",
                "atom_labels": ["Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Mn", "Mn", "Mn", "Mn"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.594, 1.977, 0.0], [0.9472822623397323, 0.0, 2.7525688854680834], [7.388312255101369, 0.0, 3.6701132562312497], [5.541282262339732, 1.977, 2.7525688854680834], [2.794312255101368, 1.977, 3.6701132562312497], [1.8944726446794653, 0.0, 5.505137770936167], [6.441121872761636, 0.0, 0.9175443707631666], [6.488472644679465, 1.977, 5.505137770936167], [1.8471218727616356, 1.977, 0.9175443707631666], [3.6941603895780974, 0.0, 1.8350245147049167], [4.641434127863004, 0.0, 4.5876576269944165], [8.288160389578097, 1.977, 1.8350245147049167], [0.04743412786300365, 1.977, 4.5876576269944165]],
                "lattice_vectors": [[9.188, 0.0, 0.0], [0.0, 3.954, 0.0], [-0.8524054825588995, 0.0, 6.422682141699333]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "i": {"X_0": 4, "X_1": 2}}
            },
            {
                "Notes": "AlCl<sub>3</sub> (D0<sub>15</sub>) Structure",
                "Pearsons Symbol": "mC16",
                "Prototype": "AlCl3",
                "Space Group Number": 12,
                "Space Group Symbol": "$C2/m$",
                "Strukturbericht Designation": "$D0_{15}$",
                "aflow_prototype_id": "AB3_mC16_12_g_ij",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_mC16_12_g_ij.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[0.0, 1.7008907999999998, 0.0], [0.0, 8.5331092, 0.0], [2.957, 6.8178908, 0.0], [2.957, 3.4161091999999997, 0.0], [0.8340333760840883, 0.0, 1.321309176571312], [3.154635541653818, 0.0, 4.517441051317827], [3.7910333760840884, 5.117, 1.321309176571312], [0.19763554165381886, 5.117, 4.517441051317827], [1.0563307727074815, 3.2882865399999996, 1.3125510512294785], [2.932338145030425, 3.2882865399999996, 4.52619917665966], [2.932338145030425, 6.94571346, 4.52619917665966], [1.0563307727074815, 6.94571346, 1.3125510512294785], [4.013330772707482, 8.40528654, 1.3125510512294785], [-0.02466185496957439, 8.40528654, 4.52619917665966], [-0.02466185496957439, 1.8287134600000001, 4.52619917665966], [4.013330772707482, 1.8287134600000001, 1.3125510512294785]],
                "lattice_vectors": [[5.914, 0.0, 0.0], [0.0, 10.234, 0.0], [-1.9253310822620926, 0.0, 5.838750227889139]],
                "normalized_wyckoff_matid": {"g": {"X_1": 1}, "i": {"X_0": 1}, "j": {"X_0": 2}}
            },
            {
                "Notes": "M&ndash;carbon Structure",
                "Pearsons Symbol": "mC16",
                "Prototype": "C",
                "Space Group Number": 12,
                "Space Group Symbol": "$C2/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_mC16_12_4i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_mC16_12_4i.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C"],
                "atom_positions": [[8.509133868774146, 0.0, 0.49129516480636076], [0.08255824378096753, 0.0, 3.5824624206526834], [3.9646338687741465, 1.248, 0.49129516480636076], [4.627058243780969, 1.248, 3.5824624206526834], [3.8440124554228587, 0.0, 1.4123717548786507], [4.747679657132257, 0.0, 2.661385830580394], [8.388512455422857, 1.248, 1.4123717548786507], [0.20317965713225608, 1.248, 2.661385830580394], [6.674368401069341, 0.0, 3.8317763848827773], [1.9173237114857733, 0.0, 0.24198120057626724], [2.129868401069341, 1.248, 3.8317763848827773], [6.461823711485774, 1.248, 0.24198120057626724], [2.2613304574991173, 0.0, 1.6902020222069576], [6.330361655055998, 0.0, 2.3835555632520866], [6.805830457499118, 1.248, 1.6902020222069576], [1.7858616550559971, 1.248, 2.3835555632520866]],
                "lattice_vectors": [[9.089, 0.0, 0.0], [0.0, 2.496, 0.0], [-0.4973078874448857, 0.0, 4.073757585459044]],
                "normalized_wyckoff_matid": {"i": {"X_0": 1}}
            },
            {
                "Notes": "Thortveitite ([Sc,Y]<sub>2</sub>Si<sub>2</sub>O<sub>7</sub>, $S2_{1}$) Structure",
                "Pearsons Symbol": "mC22",
                "Prototype": "O7Sc,Si2Y]2",
                "Space Group Number": 12,
                "Space Group Symbol": "$C2/m$",
                "Strukturbericht Designation": "$S2_{1}$",
                "aflow_prototype_id": "A7B2C2_mC22_12_aij_h_i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A7B2C2_mC22_12_aij_h_i.html",
                "atom_labels": ["O", "O", "Sc", "Sc", "Sc", "Sc", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.325, 4.308, 0.0], [-0.4951339980949756, 2.62813848, 2.2900854403123225], [-0.4951339980949756, 5.987861519999999, 2.2900854403123225], [2.8298660019050246, 6.93613848, 2.2900854403123225], [2.8298660019050246, 1.6798615199999998, 2.2900854403123225], [2.350938682564726, 0.0, 1.01546968594329], [3.308793321245323, 0.0, 3.5647011946813554], [5.675938682564727, 4.308, 1.01546968594329], [-0.016206678754677063, 4.308, 3.5647011946813554], [0.5666812856362125, 0.0, 4.178856308064313], [5.093050718173838, 0.0, 0.40131457256033143], [3.8916812856362117, 4.308, 4.178856308064313], [1.7680507181738365, 4.308, 0.40131457256033143], [0.8617876090566059, 1.3353938399999998, 3.2897535367174577], [4.7979443947534435, 1.3353938399999998, 1.2904173439071875], [4.7979443947534435, 7.28060616, 1.2904173439071875], [0.8617876090566059, 7.28060616, 3.2897535367174577], [4.186787609056606, 5.64339384, 3.2897535367174577], [1.4729443947534429, 5.64339384, 1.2904173439071875], [1.4729443947534429, 2.97260616, 1.2904173439071875], [4.186787609056606, 2.97260616, 3.2897535367174577]],
                "lattice_vectors": [[6.65, 0.0, 0.0], [0.0, 8.616, 0.0], [-0.9902679961899512, 0.0, 4.580170880624645]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "h": {"X_1": 2}, "i": {"X_0": 2, "X_2": 2}, "j": {"X_0": 4}}
            }
        ],
        13: [
            {
                "Notes": "Monoclinic (Hittorf's) Phosphorus Structure",
                "Pearsons Symbol": "mP84",
                "Prototype": "P",
                "Space Group Number": 13,
                "Space Group Symbol": "$P2/c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_mP84_13_21g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_mP84_13_21g.html",
                "atom_labels": ["P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P"],
                "atom_positions": [[1.6338679429539156, 1.8416205, 3.9403686041725168], [4.442476474729216, 1.8416205, 6.916435837808297], [1.3088208924123468, 7.3083795, 17.773240279789114], [-1.4997876393629535, 7.3083795, 14.797173046153333], [0.8683806592960843, 0.29847300000000004, 2.5394065589793127], [5.207963758387048, 0.29847300000000004, 8.317397883001503], [2.0743081760701783, 8.851527, 19.174202324982318], [-2.2652749230207845, 8.851527, 13.396211000960127], [-0.6685201685416947, 8.6713635, 3.91604936222248], [6.7448645862248275, 8.6713635, 6.940755079758334], [3.6112090039079585, 0.4786365, 17.79755952173915], [-3.802175750858564, 0.4786365, 14.772853804203296], [7.781914119106511, 7.1460585, 2.526161257560096], [-1.70556970142338, 7.1460585, 8.330643184420719], [-4.839225283740249, 2.0039415000000003, 19.187447626401536], [4.648258536789641, 2.0039415000000003, 13.382965699540911], [6.229283619586656, 6.210288, 3.7738252240325316], [-0.15293920190352472, 6.210288, 7.082979217948283], [-3.286594784220394, 2.939712, 17.9397836599291], [3.0956280372697873, 2.939712, 14.630629666013345], [5.653516592654799, 4.715178, 2.258649596109689], [0.4228278250283331, 4.715178, 8.598154845871127], [-2.710827757288536, 4.4348220000000005, 19.454959287851942], [2.5198610103379298, 4.4348220000000005, 13.115454038090503], [4.133470425003486, 4.111278, 3.739951994173551], [1.9428739926796461, 4.111278, 7.116852447807264], [-1.1907815896372231, 5.038722000000001, 17.97365688978808], [0.999814842686617, 5.038722000000001, 14.596756436154365], [3.1757298408639505, 2.5383015, 2.5344124289360015], [2.900614576819182, 2.5383015, 8.322392013044814], [-0.2330410054976867, 6.611698500000001, 19.17919645502563], [0.04207425854708135, 6.611698500000001, 13.391216870916818], [-0.07461469387771426, 3.5746305000000005, 1.57315096364302], [6.150959111560845, 3.5746305000000005, 9.283653478337795], [3.0173035292439767, 5.5753695, 20.14045792031861], [-3.2082702761945834, 5.5753695, 12.429955405623835], [8.919685816926421, 1.4531115000000001, 0.9764609915117546], [-2.8433413992432897, 1.4531115000000001, 9.880343450469061], [-5.976996981560159, 7.6968885, 20.737147892449876], [5.786030234609552, 7.6968885, 11.833265433492569], [6.801412021846006, 1.2698369999999999, 1.5950817086158213], [-0.7250676041628746, 1.2698369999999999, 9.261722733364994], [-3.8587231864797435, 7.8801630000000005, 20.118527175345807], [3.6677564395291373, 7.8801630000000005, 12.451886150596636], [6.614833229610752, 8.3190885, 0.9692955005800471], [-0.5384888119276189, 8.3190885, 9.887508941400768], [-3.672144394244488, 0.8309115, 20.74431338338158], [3.4811776472938822, 0.8309115, 11.826099942560862], [4.50535597011576, 7.984656, 1.4856451198406546], [1.5709884475673717, 7.984656, 9.37115932214016], [-1.562667134749497, 1.1653440000000004, 20.227963764120975], [1.3717003877988907, 1.1653440000000004, 12.342449561821471], [4.4746473391205015, 5.8299225, 0.7174176375260922], [1.6016970785626305, 5.8299225, 10.139386804454723], [-1.531958503754239, 3.3200775, 20.99619124643554], [1.3409917568036327, 3.3200775, 11.574222079506907], [2.3957235202361855, 5.8299225, 1.4367894998517412], [3.6806208974469454, 5.8299225, 9.420014942129074], [0.5469653151300767, 3.3200775, 20.27681938410989], [-0.7379320620806838, 3.3200775, 12.293593941832558], [2.029260946523189, 3.7107825000000005, 0.9597415126711041], [4.047083471159943, 3.7107825000000005, 9.89706292930971], [0.9134278888430735, 5.4392175, 20.753867371290525], [-1.10439463579368, 5.4392175, 11.81654595465192], [0.26549169056171656, 3.5598075000000002, 3.7388663137293534], [5.810852727121415, 3.5598075000000002, 7.1179381282514615], [2.677197144804546, 5.590192500000001, 17.974742570232277], [-2.868163891755153, 5.590192500000001, 14.59567075571017], [6.836282601154523, 0.9200325, 3.76883109398922], [-0.7599381834713914, 0.9200325, 7.0879733479915945], [-3.8935937657882604, 8.2299675, 17.94477778997241], [3.702627018837654, 8.2299675, 14.625635535970035], [4.428030088711045, 7.538136000000001, 3.6782853449431], [1.6483143289720863, 7.538136000000001, 7.178519097037715], [-1.4853412533447827, 1.611864, 18.03532353901853], [1.2943745063941765, 1.611864, 14.535089786923916], [2.8062910959334832, 5.909161500000001, 3.6331210384644597], [3.2700533217496486, 5.909161500000001, 7.223683403516355], [0.1363977394327796, 3.2408385, 18.08048784549717], [-0.32736448638338583, 3.2408385, 14.489925480445276], [7.453779580374473, 2.9550840000000003, 4.355749942122703], [-1.377435162691341, 2.9550840000000003, 6.501054499858112], [-4.51109074500821, 6.194916, 17.357858941838927], [4.320123998057604, 6.194916, 15.212554384103518]],
                "lattice_vectors": [[9.21, 0.0, 0.0], [0.0, 9.15, 0.0], [-6.267311164633738, 0.0, 21.71360888396163]],
                "normalized_wyckoff_matid": {"g": {"X_0": 1}}
            },
            {
                "Notes": "Sylvanite (AgAuTe<sub>4</sub>, E1<sub>b</sub>) Structure",
                "Pearsons Symbol": "mP12",
                "Prototype": "AgAuTe4",
                "Space Group Number": 13,
                "Space Group Symbol": "$P2/c$",
                "Strukturbericht Designation": "$E1_{b}$",
                "aflow_prototype_id": "ABC4_mP12_13_e_a_2g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC4_mP12_13_e_a_2g.html",
                "atom_labels": ["Au", "Au", "Ag", "Ag", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te"],
                "atom_positions": [[0.0, 0.0, 0.0], [-6.013831242939692, 0.0, 4.156414553607764], [-3.006915621469846, 2.3204995999999998, 2.078207276803882], [-9.020746864409539, 2.1575004, 6.234621830411646], [2.6688617012542357, 0.12448839999999999, 0.0024938487321646582], [0.2673070558060716, 0.12448839999999999, 4.153920704875599], [-5.7465241871336215, 4.353511599999999, 8.310335258483363], [-3.344969541685456, 4.353511599999999, 4.158908402339928], [-0.3209499441590622, 1.811351, 1.966815366767194], [3.25711870121937, 1.811351, 2.18959918684057], [-2.756712541720322, 2.6666489999999996, 6.346013740448334], [-6.334781187098755, 2.6666489999999996, 6.123229920374958]],
                "lattice_vectors": [[8.95, 0.0, 0.0], [0.0, 4.478, 0.0], [-12.027662485879384, 0.0, 8.312829107215528]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "f": {"X_2": 1}, "g": {"X_0": 4}}
            },
            {
                "Notes": "H<sub>2</sub>S (15 GPa) Structure",
                "Pearsons Symbol": "mP12",
                "Prototype": "H2S",
                "Space Group Number": 13,
                "Space Group Symbol": "$P2/c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_mP12_13_2g_ef",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_mP12_13_2g_ef.html",
                "atom_labels": ["S", "S", "S", "S", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[-1.058300260484211, 0.6224401599999999, 1.3821983357261185], [-3.1749007814526333, 2.82025984, 4.146595007178355], [1.7544497395157888, 3.4289292, 1.3821983357261185], [-0.36215078145263346, 0.0137708, 4.146595007178355], [-0.0805177344357901, 1.1911741999999998, 1.2439785021535066], [3.5894172134673674, 1.1911741999999998, 1.5204181692987304], [1.4728166924989452, 2.2515258, 4.284814840750967], [-2.197118255404212, 2.2515258, 4.008375173605743], [-0.48482669702981196, 0.9398571, 3.167998585484263], [-0.23947486587545522, 0.9398571, 5.125191428872448], [1.877125655092967, 2.5028428999999996, 2.360794757420211], [1.6317738239386104, 2.5028428999999996, 0.40360191403202633]],
                "lattice_vectors": [[5.6255, 0.0, 0.0], [0.0, 3.4427, 0.0], [-4.233201041936844, 0.0, 5.528793342904474]],
                "normalized_wyckoff_matid": {"e": {"X_1": 1}, "f": {"X_1": 1}, "g": {"X_0": 4}}
            }
        ],
        14: [
            {
                "Notes": "Se (A<sub>k</sub>) Structure",
                "Pearsons Symbol": "mP64",
                "Prototype": "Se",
                "Space Group Number": 14,
                "Space Group Symbol": "$P2_{1}/c$",
                "Strukturbericht Designation": "$A_{k}$",
                "aflow_prototype_id": "A_mP64_14_16e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_mP64_14_16e.html",
                "atom_labels": ["Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se"],
                "atom_positions": [[2.731148616063765, 2.06908919, 0.30270655160542437], [12.010152978601042, 9.42558919, 4.083073680290032], [11.733454573265847, 12.64391081, 8.468853912185487], [2.454450210728571, 5.287410809999999, 4.688486783500881], [3.3646565630755974, 4.179669039999999, 1.0755687440700417], [11.37664503158921, 11.536169039999999, 3.3102114878254145], [11.099946626254015, 10.533330959999999, 7.695991719720871], [3.087958157740404, 3.1768309599999998, 5.461348975965498], [4.788234443852087, 4.69447691, 8.723492312449338], [9.399670340142332, 12.05097691, 4.433848383237031], [9.676368745477527, 10.01852309, 0.048068151341574196], [5.06493284918728, 2.6620230899999995, 4.3377120805538825], [7.09324024047076, 4.23381288, 1.4149404184141121], [7.648061354194047, 11.590312879999999, 2.970839813481344], [7.371362948858853, 10.479187119999999, 7.3566200453768], [6.816541835135567, 3.1226871199999997, 5.800720650309569], [7.885748608042854, 2.12426294, 0.8197023253412609], [6.855552986621953, 9.480762939999998, 3.566077906554195], [6.57885458128676, 12.58873706, 7.951858138449651], [7.609050202707659, 5.232237059999999, 5.205482557236717], [7.053552276372112, 0.5933752899999999, 2.377268316896613], [7.6877493182926955, 7.94987529, 2.0085119149988433], [7.411050912957501, 14.11962471, 6.394292146894299], [6.776853871036918, 6.76312471, 6.76304854879207], [5.367243080322317, 14.29838766, 1.3265230889390998], [9.37405851434249, 6.94188766, 3.0592571429563566], [9.097360109007298, 0.41461233999999997, 7.445037374851813], [5.0905446749871235, 7.771112339999999, 5.712303320834556], [3.2525429072599286, 0.62692093, 2.055176616666211], [11.488758687404877, 7.98342093, 2.3306036152292453], [11.212060282069684, 14.086079069999998, 6.716383847124702], [2.9758445019247346, 6.72957907, 6.440956848561666], [1.3558650712994178, 7.150665129999999, 1.2467018887186023], [13.385436523365389, 14.50716513, 3.139078343176854], [13.108738118030194, 7.562334869999999, 7.52485857507231], [1.079166665964224, 0.20583487000000003, 5.632482120614059], [0.04100631711203174, 8.663455789999999, 2.4398095430034425], [14.700295277552774, 1.3069557899999995, 1.9459706888920139], [14.423596872217582, 6.0495442100000005, 6.33175092078747], [-0.235692088223162, 13.40604421, 6.825589774898899], [14.660847717025147, 10.516263879999999, 1.0644288622810272], [0.08045387763965782, 3.1597638800000007, 3.321351369614429], [-0.19624452769553596, 4.196736120000001, 7.707131601509886], [14.384149311689955, 11.55323612, 5.450209094176483], [1.1508807497163231, 12.20369785, 1.627387612847128], [13.590420844948484, 4.84719785, 2.7583926190483283], [13.31372243961329, 2.5093021499999995, 7.144172850943785], [0.8741823443811294, 9.865802149999999, 6.013167844742584], [2.8746726487132443, 11.96725994, 0.08447012726630648], [11.866628945951563, 4.6107599399999994, 4.30131010462915], [11.589930540616368, 2.74574006, 8.687090336524605], [2.5979742433780504, 10.10224006, 4.470250359161763], [4.578883391327251, 10.881881929999999, 1.2632801379951673], [10.162418203337555, 3.525381929999998, 3.1225000939002885], [9.885719798002363, 3.83111807, 7.508280325795745], [4.302184985992057, 11.18761807, 5.649060369890623], [4.6042088203861695, 8.700826809999999, 0.41910515895992984], [10.137092774278639, 1.3443268099999992, 3.9666750729355265], [9.860394368943444, 6.01217319, 8.352455304830983], [4.327510415050975, 13.368673189999999, 4.804885390855387], [3.5280987828041446, 7.43786289, 2.048422515109092], [11.213202811860663, 0.0813628900000005, 2.3373577167863644], [10.936504406525469, 7.275137109999999, 6.723137948681821], [3.251400377468951, 14.631637109999998, 6.434202747004548]],
                "lattice_vectors": [[15.018, 0.0, 0.0], [0.0, 14.713, 0.0], [-0.5533968106703875, 0.0, 8.771560463790912]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1}}
            },
            {
                "Notes": "Baddeleyite (ZrO<sub>2</sub>, C43) Structure",
                "Pearsons Symbol": "mP12",
                "Prototype": "O2Zr",
                "Space Group Number": 14,
                "Space Group Symbol": "$P2_{1}/c$",
                "Strukturbericht Designation": "$C43$",
                "aflow_prototype_id": "A2B_mP12_14_2e_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_mP12_14_2e_e.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "Zr", "Zr", "Zr", "Zr"],
                "atom_positions": [[0.06654573350105122, 1.72868772, 1.8091420291656943], [4.657512046454056, 4.334487719999999, 0.8150848770798733], [4.231069826409164, 3.48291228, 3.439311783325441], [-0.3598964865438412, 0.87711228, 4.433368935411262], [1.906962576308975, 3.94466004, 2.515059066945752], [2.8170952036461325, 1.3388600399999995, 0.10916783929981554], [2.3906529836012402, 1.2669399599999998, 2.733394745545383], [1.4805203562640825, 3.8727399599999996, 5.13928597319132], [1.2407918711292978, 0.2058582, 1.0932529291419035], [3.48326590882581, 2.8116581999999997, 1.530973977103664], [3.0568236887809177, 5.0057418, 4.155200883349232], [0.8143496510844054, 2.3999418, 3.717479835387471]],
                "lattice_vectors": [[5.1505, 0.0, 0.0], [0.0, 5.2116, 0.0], [-0.8528844400897848, 0.0, 5.248453812491135]],
                "normalized_wyckoff_matid": {"e": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "$\\beta$&ndash;Se (A<sub>l</sub>) Structure",
                "Pearsons Symbol": "mP32",
                "Prototype": "Se",
                "Space Group Number": 14,
                "Space Group Symbol": "$P2_{1}/c$",
                "Strukturbericht Designation": "$A_{l}$",
                "aflow_prototype_id": "A_mP32_14_8e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_mP32_14_8e.html",
                "atom_labels": ["Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se"],
                "atom_positions": [[4.009470351342676, 1.49295, 1.0777863431396375], [4.9493412637923, 5.527950000000001, 5.337608556501062], [4.598152878927276, 6.57705, 11.75300345614176], [3.6582819664776522, 2.54205, 7.493181242780336], [1.6040378959737431, 2.20311, 12.535681633897925], [6.652396949431186, 6.238110000000001, 6.710503065024171], [7.0035853342962096, 5.86689, 0.2951081653834721], [1.955226280838767, 1.8318899999999998, 6.120286734257227], [1.6528320346635201, 0.82314, 10.623893953804997], [6.603602810741409, 4.85814, 8.6222907451171], [6.9547911956064326, 7.246860000000001, 2.206895845476401], [2.0040204195285445, 3.21186, 4.208499054164297], [-0.13292500781000088, 7.4244, 10.93183290898775], [8.389359853214929, 3.3894, 8.314351789934346], [8.740548238079953, 0.6456000000000001, 1.8989568902936471], [0.21826337705502322, 4.6806, 4.51643800934705], [0.8225071395456562, 5.39883, 11.676018717346073], [7.433927705859271, 1.3638300000000003, 7.570165981576024], [7.785116090724295, 2.6711699999999996, 1.1547710819353258], [1.1736955244106804, 6.70617, 5.2606238177053735], [1.2588060907242957, 5.3262, 1.1547710819353258], [7.70000552441068, 1.2912000000000012, 5.2606238177053735], [7.348817139545656, 2.7438, 11.676018717346073], [0.9076177058592717, 6.7788, 7.570165981576024], [3.3136997168431925, 6.02022, 2.0529263678850236], [5.645111898291784, 1.98522, 4.362468531755675], [5.29392351342676, 2.04978, 10.777863431396373], [2.9625113319781686, 6.08478, 8.468321267525724], [2.9620408783566905, 0.16947, 2.694465857849093], [5.996770736778286, 4.204470000000001, 3.7209290417916057], [5.645582351913261, 7.90053, 10.136323941432305], [2.610852493491666, 3.86553, 9.109860757489791]],
                "lattice_vectors": [[9.31, 0.0, 0.0], [0.0, 8.07, 0.0], [-0.702376769730048, 0.0, 12.830789799281398]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1}}
            },
            {
                "Notes": "$\\alpha$&ndash;Toluene Structure",
                "Pearsons Symbol": "mP120",
                "Prototype": "C7H8",
                "Space Group Number": 14,
                "Space Group Symbol": "$P2_{1}/c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A7B8_mP120_14_14e_16e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A7B8_mP120_14_14e_16e.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[-0.6347396244583541, 3.3462768599999997, 8.81765625973791], [4.4742441916859335, 0.4369768599999997, 4.141862052634092], [0.7248487589135146, 2.4723231400000003, 17.101380365006094], [-4.384135057230774, 5.38162314, 21.777174572109914], [2.3107041402996407, 5.1669168, 12.190759686082096], [1.5288004269279396, 2.257616799999999, 0.7687586262899078], [-2.22059500584448, 0.6516831999999999, 13.72827693866191], [-1.4386912924727788, 3.5609832, 25.150277998454097], [-1.4675815803513064, 2.24947076, 8.610822347472453], [5.307086147578887, 5.15877076, 4.348695964899549], [1.5576907148064671, 3.5691292399999996, 17.308214277271553], [-5.216977013123725, 0.65982924, 21.570340659844454], [3.0310498887055473, 4.73983156, 11.07961058597932], [0.808454678522033, 1.8305315599999998, 1.8799077263926822], [-2.9409407542503865, 1.0787684400000002, 14.839426038764685], [-0.7183455440668725, 3.98806844, 24.039128898351322], [-1.239904207561194, 1.36329798, 7.566025981129023], [5.079408774788775, 4.27259798, 5.39349233124298], [1.3300133420163556, 4.45530202, 18.353010643614983], [-4.989299640333614, 1.54600202, 20.525544293501024], [3.080530964126158, 5.50672304, 9.923103171783243], [0.7589736031014224, 2.5974230400000007, 3.0364151405887596], [-2.9904218296709972, 0.31187695999999987, 15.995933452960763], [-0.6688644686462616, 3.2211769599999998, 22.882621484155248], [-0.17466965154628186, 1.5553117799999998, 6.709142630314987], [4.014174218773863, 4.46461178, 6.250375682057016], [0.2647787860014429, 4.26328822, 19.20989399442902], [-3.9240650843187015, 1.3539882200000002, 19.66866094268699], [2.3991188185592636, 0.89199138, 9.856232057291404], [1.440385748668316, 3.80129138, 3.1032862550806], [-2.3090096841041032, 4.92660862, 16.062804567452602], [-1.3502766142131557, 2.01730862, 22.815750369663405], [0.650272836942972, 2.64571742, 6.892131028885678], [3.1892317302846074, 5.5550174199999995, 6.067387283486325], [-0.5601637024878121, 3.17288258, 19.026905595858327], [-3.0991225958294475, 0.26358258000000007, 19.85164934125768], [1.679244821124616, 1.3272226599999999, 10.950274593221849], [2.1602597461029642, 4.236522659999999, 2.0092437191501547], [-1.5891356866694557, 4.4913773400000006, 14.968762031522159], [-2.070150611647803, 1.58207734, 23.90979290559385], [0.42288820705672503, 3.53130834, 7.9338171108341395], [3.4166163601708557, 0.6220083399999999, 5.0257012015378635], [-0.33277907260156336, 2.28729166, 17.985219513909865], [-3.326507225715695, 5.19659166, 20.893335423206143], [1.6386463630693835, 0.56382234, 12.107818768882915], [2.2008582041581963, 3.4731223399999998, 0.851699543489088], [-1.5485372286142232, 5.25477766, 13.811217855861091], [-2.110749069703036, 2.3454776600000002, 25.06733708125492], [-0.8497055766288814, 4.29761796, 9.960685774889122], [4.689210143856461, 1.3883179599999995, 2.9988325374828824], [0.9398147110840417, 1.5209820399999998, 15.958350849854885], [-4.599101009401301, 4.43028204, 22.920204087261123], [2.2703803177774384, 4.34125746, 13.449128914213416], [-5.929666616094697, 1.43195746, 25.429426022902593], [-2.1802711833222777, 1.47734254, 12.46990771053059], [6.019775750549859, 4.38664254, 0.4896106018414104], [-2.2029693400087544, 2.10458762, 9.1934822907967], [6.042473907236335, 5.01388762, 3.7660360215753035], [2.293078474463915, 3.71401238, 16.725554333947308], [-5.952364772781174, 0.8047123799999999, 22.153000603168703], [3.4961326259409264, 3.91184478, 11.111491001027757], [0.34337194128665327, 1.0025447799999994, 1.848027311344247], [-3.4060234914857657, 1.90675522, 14.807545623716248], [-0.2532628068314934, 4.81605522, 24.07100931339976], [-1.8205090374979234, 0.62142648, 7.441355414964005], [5.6600136047255045, 3.5307264800000002, 5.518162897407998], [1.910618171953085, 5.19717352, 18.477681209780002], [-5.569904470270343, 2.2878735199999998, 20.40087372733601], [3.5835038335971268, 5.2047377, 9.175338965159378], [0.2560007336304537, 2.295437699999999, 3.7841793472126253], [-3.4933946991419655, 0.6138623000000002, 16.74369765958463], [-0.1658915991752925, 3.5231623, 22.13485727753138], [-0.011013115373630275, 0.94319506, 6.000256978628237], [3.8505176826012106, 3.8524950600000003, 6.959261333743765], [0.10112224982879126, 4.87540494, 19.918779646115766], [-3.76040854814605, 1.96610494, 18.95977529100024], [2.4265680043189697, 1.4139198, 9.06388710767298], [1.4129365629086108, 4.3232198, 3.895631204699024], [-2.336458869863809, 4.4046802, 16.855149517071027], [-1.32282742845345, 1.4953802, 22.02340542004498], [1.3788008505860494, 2.79060056, 6.300917803475268], [2.460703716641531, 5.699900560000001, 6.658600508896735], [-1.2886917161308884, 3.02799944, 19.618118821268737], [-2.37059458218637, 0.11869943999999985, 19.26043611584727], [1.2104119846921773, 2.15230014, 10.909322515354752], [2.629092582535403, 5.06160014, 2.050195797017251], [-1.120302850237016, 3.66629986, 15.009714109389252], [-2.5389834480802427, 0.75699986, 23.868840827726757], [1.0001079653348817, 4.2778347199999995, 8.04526896832054], [2.8393966018926986, 1.368534719999999, 4.914249344051464], [-0.9099988308797209, 1.5407652800000002, 17.873767656423468], [-2.749287467437538, 4.4500652800000005, 21.004787280692543], [1.1443257406897596, 0.8762811600000001, 12.855842165873026], [2.6951788265378203, 3.7855811600000004, 0.10367614649897612], [-1.0542166062345992, 4.9423188399999995, 13.06319445887098], [-2.60506969208266, 2.03301884, 25.81536047824503], [3.105296645250321, 4.46402992, 13.94703360777475], [-6.76458294356758, 1.5547299199999993, 24.93152132934126], [-3.0151875107951605, 1.35457008, 11.972003016969255], [6.85469207802274, 4.26387008, 0.9875152954027472], [2.164767527658686, 3.3951531, 13.21611677495697], [-5.824053825975945, 0.4858530999999995, 25.66243816215904], [-2.0746583932035256, 2.4234469, 12.702919849787037], [5.9141629604311055, 5.3327469, 0.25659846258496616], [1.514102555346124, 4.62695072, 14.004055488349186], [-5.173388853663383, 1.7176507199999995, 24.874499448766823], [-1.4239934208909628, 1.1916492799999998, 11.91498113639482], [5.2634979881185435, 4.10094928, 1.0445371759771835], [-1.2035512002036897, 5.14480612, 9.6185544914425], [5.04305576743127, 2.2355061199999993, 3.340963820929503], [1.2936603346588509, 0.6737938800000001, 16.300482133301507], [-4.95294663297611, 3.5830938800000003, 22.578072803814504], [0.0028237011375296024, 4.459375039999999, 10.416860819484615], [3.8366808660900515, 1.5500750399999998, 2.5426574928873875], [0.08728543331763165, 1.3592249600000001, 15.502175805259393], [-3.7465717316348894, 4.268524960000001, 23.376379131856616], [-1.488541296748176, 3.9083536199999998, 10.593110268532875], [5.328045863975756, 0.9990536199999998, 2.3664080438391277], [1.5786504312033374, 1.9102463800000002, 15.325926356211129], [-5.237936729520595, 4.81954638, 23.55262858090488]],
                "lattice_vectors": [[7.5889, 0.0, 0.0], [0.0, 5.8186, 0.0], [-7.498790865544839, 0.0, 25.919036624744006]],
                "normalized_wyckoff_matid": {"e": {"X_0": 8, "X_1": 7}}
            },
            {
                "Notes": "$\\gamma$&ndash;PdCl<sub>2</sub> Structure",
                "Pearsons Symbol": "mP6",
                "Prototype": "Cl2Pd",
                "Space Group Number": 14,
                "Space Group Symbol": "$P2_{1}/c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_mP6_14_e_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_mP6_14_e_a.html",
                "atom_labels": ["Pd", "Pd", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[0.0, 0.0, 0.0], [-0.9451993044244574, 1.9304, 3.0627154352658232], [0.8213737969605559, 0.9933838399999998, 1.92399783643399], [3.7830268986149864, 2.9237838399999996, 1.1387175988318332], [2.837827594190529, 2.86741616, 4.201433034097656], [-0.1238255074639016, 0.9370161600000001, 4.986713271699814]],
                "lattice_vectors": [[5.5496, 0.0, 0.0], [0.0, 3.8608, 0.0], [-1.8903986088489149, 0.0, 6.1254308705316465]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "e": {"X_0": 2}}
            }
        ],
        15: [
            {
                "Notes": "Esseneite Structure",
                "Pearsons Symbol": "mC40",
                "Prototype": "CaFeO6Si2",
                "Space Group Number": 15,
                "Space Group Symbol": "$C2/c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC6D2_mC40_15_e_e_3f_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC6D2_mC40_15_e_e_3f_f.html",
                "atom_labels": ["Ca", "Ca", "Ca", "Ca", "Fe", "Fe", "Fe", "Fe", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[-0.3657616838164549, 2.7189403999999997, 1.291713838530714], [-1.0972850514493646, 6.103059599999999, 3.8751415155921425], [4.5292383161835446, 7.1299404, 1.291713838530714], [3.797714948550635, 1.6920596, 3.8751415155921425], [-0.3657616838164549, 7.9909675999999985, 1.291713838530714], [-1.0972850514493646, 0.8310324, 3.8751415155921425], [4.5292383161835446, 3.5799676, 1.291713838530714], [3.797714948550635, 5.2420324, 3.8751415155921425], [2.5394998319333264, 3.6373105999999997, 4.473980051134982], [5.055930065167942, 3.6373105999999997, 3.2763029800493033], [5.787453432800852, 5.1846894, 0.692875302987875], [3.2710231995662364, 5.1846894, 1.8905523740735526], [7.434499831933326, 8.048310599999999, 4.473980051134982], [0.16093006516794384, 8.048310599999999, 3.2763029800493033], [0.8924534328008537, 0.7736894, 0.692875302987875], [8.166023199566236, 0.7736894, 1.8905523740735526], [0.34160952469276934, 2.1269842, 3.5129449552681296], [7.253820372408501, 2.1269842, 4.2373380759161545], [7.98534374004141, 6.695015799999999, 1.6539103988547266], [1.073132892325679, 6.695015799999999, 0.9295172782067016], [5.23660952469277, 6.5379841999999995, 3.5129449552681296], [2.3588203724085006, 6.5379841999999995, 4.2373380759161545], [3.0903437400414107, 2.2840158, 1.6539103988547266], [5.96813289232568, 2.2840158, 0.9295172782067016], [1.4190302204827039, 4.2363244, 0.06406900639112342], [7.639446411884385, 4.2363244, 2.5193586706703046], [6.907923044251476, 4.5856756, 5.102786347731733], [0.6875068528497942, 4.5856756, 2.6474966834525513], [6.314030220482704, 8.647324399999999, 0.06406900639112342], [2.7444464118843857, 8.647324399999999, 2.5193586706703046], [2.0129230442514756, 0.17467559999999985, 5.102786347731733], [5.582506852849794, 0.17467559999999985, 2.6474966834525513], [0.9366335147396176, 3.5790854, 4.011546496940985], [6.658796382361652, 3.5790854, 3.7387365342432988], [7.390319749994562, 5.2429146, 1.1553088571818708], [1.6681568823725275, 5.2429146, 1.4281188198795574], [5.831633514739617, 7.990085399999999, 4.011546496940985], [1.7637963823616525, 7.990085399999999, 3.7387365342432988], [2.4953197499945623, 0.8319145999999998, 1.1553088571818708], [6.563156882372526, 0.8319145999999998, 1.4281188198795574]],
                "lattice_vectors": [[9.79, 0.0, 0.0], [0.0, 8.822, 0.0], [-1.4630467352658196, 0.0, 5.166855354122856]],
                "normalized_wyckoff_matid": {"e": {"X_2": 1, "X_3": 1}, "f": {"X_0": 6, "X_1": 2}}
            },
            {
                "Notes": "Tenorite (CuO, B26) Structure",
                "Pearsons Symbol": "mC8",
                "Prototype": "CuO",
                "Space Group Number": 15,
                "Space Group Symbol": "$C2/c$",
                "Strukturbericht Designation": "$B26$",
                "aflow_prototype_id": "AB_mC8_15_c_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_mC8_15_c_e.html",
                "atom_labels": ["Cu", "Cu", "Cu", "Cu", "O", "O", "O", "O"],
                "atom_positions": [[1.170925, 0.85565, 0.0], [2.217418949408614, 0.85565, 2.2131877602671413], [3.512775, 2.5669500000000003, 0.0], [-0.12443105059138615, 2.5669500000000003, 2.2131877602671413], [-0.6476780252956931, 1.43201584, 1.1065938801335706], [-1.9430340758870792, 1.99058416, 3.319781640400712], [1.694171974704307, 3.14331584, 1.1065938801335706], [0.39881592411292077, 0.27928416, 3.319781640400712]],
                "lattice_vectors": [[4.6837, 0.0, 0.0], [0.0, 3.4226, 0.0], [-2.5907121011827723, 0.0, 4.4263755205342825]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "e": {"X_1": 1}}
            },
            {
                "Notes": "Coesite (SiO<sub>2</sub>) Structure",
                "Pearsons Symbol": "mC48",
                "Prototype": "O2Si",
                "Space Group Number": 15,
                "Space Group Symbol": "$C2/c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_mC48_15_ae3f_2f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_mC48_15_ae3f_2f.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 0.0], [-1.8118012331388178, 0.0, 3.0955630395126277], [3.5678, 6.1846, 0.0], [1.7559987668611823, 6.1846, 3.0955630395126277], [-0.9059006165694089, 1.43853796, 1.5477815197563138], [-2.717701849708227, 10.93066204, 4.643344559268941], [2.6618993834305913, 7.623137959999999, 1.5477815197563138], [0.8500981502917734, 4.74606204, 4.643344559268941], [-1.5084790785476052, 1.5263592799999999, 5.8202776268916425], [3.2086753791311518, 1.5263592799999999, 3.46641149164624], [5.020476612269969, 10.84284072, 0.3708484521336125], [0.30332215459121215, 10.84284072, 2.7247145873790157], [2.059320921452395, 7.710959279999999, 5.8202776268916425], [-0.35912462086884805, 7.710959279999999, 3.46641149164624], [1.4526766122699697, 4.658240719999999, 0.3708484521336125], [3.8711221545912124, 4.658240719999999, 2.7247145873790157], [1.0327595105676801, 1.28392296, 2.031927579136089], [4.2910392562935025, 1.28392296, 1.063635460376539], [2.479238023154685, 11.08527704, 4.1591984998891665], [-0.7790417225711378, 11.08527704, 5.127490618648717], [4.60055951056768, 7.46852296, 2.031927579136089], [0.7232392562935022, 7.46852296, 1.063635460376539], [-1.0885619768453154, 4.90067704, 4.1591984998891665], [2.7887582774288617, 4.90067704, 5.127490618648717], [-1.6100743793739654, 2.61855964, 2.960596490989877], [6.933873146235148, 2.61855964, 0.13496654852275047], [5.12207191309633, 9.75064036, 3.2305295880353784], [-3.421875612512783, 9.75064036, 6.056159530502504], [1.9577256206260345, 8.803159639999999, 2.960596490989877], [3.3660731462351476, 8.803159639999999, 0.13496654852275047], [1.5542719130963298, 3.5660403599999997, 3.2305295880353784], [0.14592438748721698, 3.5660403599999997, 6.056159530502504], [0.7394609977621153, 1.3399554359999999, 0.4474326817311552], [4.584337769099067, 1.3399554359999999, 2.6481303577814725], [2.772536535960249, 11.029244563999999, 5.7436933972941], [-1.0723402353767026, 11.029244563999999, 3.5429957212437833], [4.307260997762116, 7.524555436, 0.4474326817311552], [1.0165377690990667, 7.524555436, 2.6481303577814725], [-0.7952634640397508, 4.844644564, 5.7436933972941], [2.4954597646232974, 4.844644564, 3.5429957212437833], [1.6569292863110434, 1.9542099079999997, 3.3479752497544872], [0.0432670142725033, 1.9542099079999997, 5.938713868783396], [1.8550682474113211, 10.414990092, 2.843150829270768], [3.468730519449861, 10.414990092, 0.2524122102418595], [-1.9108707136889567, 8.138809907999999, 3.3479752497544872], [3.6110670142725034, 8.138809907999999, 5.938713868783396], [5.422868247411321, 4.230390092, 2.843150829270768], [-0.09906948055013876, 4.230390092, 0.2524122102418595]],
                "lattice_vectors": [[7.1356, 0.0, 0.0], [0.0, 12.3692, 0.0], [-3.6236024662776356, 0.0, 6.191126079025255]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "e": {"X_0": 1}, "f": {"X_0": 6, "X_1": 4}}
            },
            {
                "Notes": "B<sub>2</sub>Pd<sub>5</sub> Structure",
                "Pearsons Symbol": "mC28",
                "Prototype": "B2Pd5",
                "Space Group Number": 15,
                "Space Group Symbol": "$C2/c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B5_mC28_15_f_e2f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B5_mC28_15_f_e2f.html",
                "atom_labels": ["Pd", "Pd", "Pd", "Pd", "B", "B", "B", "B", "B", "B", "B", "B", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd"],
                "atom_positions": [[-0.16750709237525507, 2.8377285, 1.3577059232411075], [-0.5025212771257652, 2.1172715, 4.073117769723322], [6.225492907624744, 0.36022849999999995, 1.3577059232411075], [5.890478722874235, 4.5947715, 4.073117769723322], [1.3037238155484214, 1.541005, 0.4181734243582611], [11.147261999701067, 1.541005, 2.2972384221239537], [10.812247814950558, 3.4139950000000003, 5.012650268606169], [0.9687096307979113, 3.4139950000000003, 3.133585270840476], [7.69672381554842, 4.018505, 0.4181734243582611], [4.754261999701069, 4.018505, 2.2972384221239537], [4.419247814950559, 0.936495, 5.012650268606169], [7.36170963079791, 0.936495, 3.133585270840476], [0.94261584792922, 0.471716, 2.2880060218459146], [11.508369967320268, 0.471716, 0.4274058246363006], [11.17335578256976, 4.483284, 3.1428176711185154], [0.6076016631787099, 4.483284, 5.003417868328129], [7.33561584792922, 2.949216, 2.2880060218459146], [5.1153699673202695, 2.949216, 0.4274058246363006], [4.780355782569759, 2.005784, 3.1428176711185154], [7.00060166317871, 2.005784, 5.003417868328129], [8.90232729765058, 0.35973299999999997, 1.7041924748522383], [3.5486585175989096, 0.35973299999999997, 1.0112193716299767], [3.2136443328483995, 4.595267, 3.7266312181121917], [8.56731311290007, 4.595267, 4.419604321334454], [2.5093272976505783, 2.837233, 1.7041924748522383], [9.94165851759891, 2.837233, 1.0112193716299767], [9.6066443328484, 2.117767, 3.7266312181121917], [2.174313112900068, 2.117767, 4.419604321334454]],
                "lattice_vectors": [[12.786, 0.0, 0.0], [0.0, 4.955, 0.0], [-0.6700283695010203, 0.0, 5.43082369296443]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1}, "f": {"X_0": 4, "X_1": 2}}
            },
            {
                "Notes": "H<sub>3</sub>Cl (50 GPa) Structure",
                "Pearsons Symbol": "mC16",
                "Prototype": "ClH3",
                "Space Group Number": 15,
                "Space Group Symbol": "$C2/c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_mC16_15_e_cf",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_mC16_15_e_cf.html",
                "atom_labels": ["H", "H", "H", "H", "Cl", "Cl", "Cl", "Cl", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[0.8205, 2.16725, 0.0], [2.408683800827078, 2.16725, 1.592124193995219], [2.4615, 6.50175, 0.0], [0.7676838008270779, 6.50175, 1.592124193995219], [-0.026408099586461082, 7.4553400000000005, 0.7960620969976095], [-0.07922429875938325, 1.2136600000000002, 2.3881862909928286], [1.614591900413539, 3.120839999999999, 0.7960620969976095], [1.5617757012406168, 5.54816, 2.3881862909928286], [1.8758621246795522, 0.5894920000000001, 0.5381379775703841], [1.3533216761475257, 0.5894920000000001, 1.0539862164248348], [1.3005054769746034, 8.079508, 2.646110410420054], [1.82304592550663, 8.079508, 2.130262171565603], [0.2348621246795522, 4.923992000000001, 0.5381379775703841], [2.9943216761475258, 4.923992000000001, 1.0539862164248348], [2.9415054769746036, 3.7450080000000003, 2.646110410420054], [0.18204592550663, 3.7450080000000003, 2.130262171565603]],
                "lattice_vectors": [[3.282, 0.0, 0.0], [0.0, 8.669, 0.0], [-0.10563239834584433, 0.0, 3.184248387990438]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "e": {"X_1": 1}, "f": {"X_0": 2}}
            },
            {
                "Notes": "H&ndash;III (300 GPa) Structure",
                "Pearsons Symbol": "mC24",
                "Prototype": "H",
                "Space Group Number": 15,
                "Space Group Symbol": "$C2/c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_mC24_15_2e2f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_mC24_15_2e2f.html",
                "atom_labels": ["H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[-0.8205924331631285, 0.2844732, 0.6303456362468266], [-2.4617772994893854, 2.5265268, 1.89103690874048], [1.6489075668368716, 1.6899731999999998, 0.6303456362468266], [0.007722700510614633, 1.1210267999999999, 1.89103690874048], [-0.8205924331631285, 1.0355724, 0.6303456362468266], [-2.4617772994893854, 1.7754275999999998, 1.89103690874048], [1.6489075668368716, 2.4410724, 0.6303456362468266], [0.007722700510614633, 0.36992759999999997, 1.89103690874048], [0.3074380978744206, 0.1888992, 0.6212686590848723], [2.9903770357993227, 0.1888992, 0.6394226134087809], [1.3491921694730655, 2.6221007999999997, 1.9001138859024342], [-1.333746768451836, 2.6221007999999997, 1.8819599315785254], [2.7769380978744205, 1.5943992, 0.6212686590848723], [0.5208770357993228, 1.5943992, 0.6394226134087809], [-1.1203078305269345, 1.2166008, 1.9001138859024342], [1.1357532315481638, 1.2166008, 1.8819599315785254], [0.969513960538285, 0.5503938, 0.5615118927686732], [2.3283011731354577, 0.5503938, 0.69917937972498], [0.687116306809201, 2.2606062000000002, 1.9598706522186333], [-0.671670905787972, 2.2606062000000002, 1.8222031652623263], [3.439013960538286, 1.9558938, 0.5615118927686732], [-0.14119882686454205, 1.9558938, 0.69917937972498], [-1.782383693190799, 0.8551062, 1.9598706522186333], [1.7978290942120287, 0.8551062, 1.8222031652623263]],
                "lattice_vectors": [[4.939, 0.0, 0.0], [0.0, 2.811, 0.0], [-3.282369732652514, 0.0, 2.5213825449873064]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1}, "f": {"X_0": 2}}
            }
        ],
        16: [
            {
                "Notes": "AlPS<sub>4</sub> Structure",
                "Pearsons Symbol": "oP12",
                "Prototype": "AlPS4",
                "Space Group Number": 16,
                "Space Group Symbol": "$P222$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC4_oP12_16_ag_cd_2u",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC4_oP12_16_ag_cd_2u.html",
                "atom_labels": ["Al", "P", "P", "Al", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 2.835, 0.0], [0.0, 0.0, 4.525], [0.0, 2.835, 4.525], [1.122, 1.4742, 1.13125], [1.122, 4.1958, 7.918750000000001], [4.488, 1.4742, 7.918750000000001], [4.488, 4.1958, 1.13125], [4.1514, 4.5360000000000005, 5.7015], [4.1514, 1.1339999999999997, 3.3485], [1.4586000000000001, 4.5360000000000005, 3.3485], [1.4586000000000001, 1.1339999999999997, 5.7015]],
                "lattice_vectors": [[5.61, 0.0, 0.0], [0.0, 5.67, 0.0], [0.0, 0.0, 9.05]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_2": 1}, "d": {"X_2": 1}, "g": {"X_1": 1}, "u": {"X_0": 8}}
            }
        ],
        17: [
            {
                "Notes": "$\\alpha$&ndash;Naumannite (Ag<sub>2</sub>Se) Structure",
                "Pearsons Symbol": "oP12",
                "Prototype": "Ag2Se",
                "Space Group Number": 17,
                "Space Group Symbol": "$P222_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_oP12_17_abe_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP12_17_abe_e.html",
                "atom_labels": ["Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "Se", "Se", "Se", "Se"],
                "atom_positions": [[6.2956235088871, 0.0, 0.0], [0.7543468258128999, 0.0, 2.16499089], [6.1898739538666, 3.92498348425, 0.0], [0.8600963808334, 3.92498348425, 2.16499089], [2.6719387568513002, 1.7662425679125002, 2.26025048916], [2.6719387568513002, 6.0837244005875, 2.0697312908399996], [4.3780315778487005, 1.7662425679125002, 4.2347221808399995], [4.3780315778487005, 6.0837244005875, 0.09525959916000008], [1.4240940076094002, 2.1587409163375004, 0.09525959915999999], [1.4240940076094002, 5.6912260521625, 4.2347221808399995], [5.625876327090601, 2.1587409163375004, 2.0697312908399996], [5.625876327090601, 5.6912260521625, 2.26025048916]],
                "lattice_vectors": [[7.0499703347, 0.0, 0.0], [0.0, 7.8499669685, 0.0], [0.0, 0.0, 4.32998178]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 1}, "e": {"X_0": 2, "X_1": 2}}
            }
        ],
        18: [
            {
                "Notes": "BaS<sub>3</sub> Structure",
                "Pearsons Symbol": "oP16",
                "Prototype": "BaS3",
                "Space Group Number": 18,
                "Space Group Symbol": "$P2_{1}2_{1}2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_oP16_18_ab_3c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_oP16_18_ab_3c.html",
                "atom_labels": ["Ba", "Ba", "Ba", "Ba", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.16, 4.82, 0.0], [0.0, 4.82, 0.0], [4.16, 0.0, 0.0], [2.08, 2.41, 0.0], [6.24, 2.41, 0.0], [2.08, 7.23, 0.0], [6.24, 7.23, 0.0], [2.08, 4.82, 2.41], [6.24, 0.0, 2.41], [2.08, 0.0, 2.41], [6.24, 4.82, 2.41], [1.03168, 2.9787600000000003, 1.8412400000000002], [5.19168, 1.8412400000000002, 2.9787600000000003], [3.12832, 7.79876, 2.9787600000000003], [7.288320000000001, 6.661240000000001, 1.8412400000000002]],
                "lattice_vectors": [[8.32, 0.0, 0.0], [0.0, 9.64, 0.0], [0.0, 0.0, 4.82]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_1": 1}, "c": {"X_0": 6}}
            }
        ],
        19: [
            {
                "Notes": "Naumannite (Ag<sub>2</sub>Se) Structure",
                "Pearsons Symbol": "oP12",
                "Prototype": "Ag2Se",
                "Space Group Number": 19,
                "Space Group Symbol": "$P2_{1}2_{1}2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_oP12_19_2a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP12_19_2a_a.html",
                "atom_labels": ["Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "Se", "Se", "Se", "Se"],
                "atom_positions": [[1.43634, 0.49434000000000006, 2.014845], [5.318340000000001, 3.03666, 2.318155], [6.32766, 4.025340000000001, 0.1516549999999999], [2.44566, 6.56766, 4.181345], [0.42702, 5.402430000000001, 4.298336], [4.30902, 5.19057, 0.034664], [7.33698, 1.871430000000001, 2.2011640000000003], [3.45498, 1.65957, 2.131836], [6.863376000000001, 6.984318, 1.6942030000000001], [2.981375999999999, 3.6086820000000004, 2.638797], [0.900624, 3.453318, 0.47229699999999997], [4.782624, 0.077682, 3.8607030000000004]],
                "lattice_vectors": [[7.764, 0.0, 0.0], [0.0, 7.062, 0.0], [0.0, 0.0, 4.333]],
                "normalized_wyckoff_matid": {"a": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "H<sub>3</sub>Cl (100 GPa) Structure",
                "Pearsons Symbol": "oP16",
                "Prototype": "ClH3",
                "Space Group Number": 19,
                "Space Group Symbol": "$P2_{1}2_{1}2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_oP16_19_a_3a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_oP16_19_a_3a.html",
                "atom_labels": ["Cl", "Cl", "Cl", "Cl", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[3.3101119999999997, 0.5291459999999999, 0.08091899999999999], [0.4761120000000004, 1.621854, 2.9160809999999997], [2.3578880000000004, 2.6801459999999997, 1.417581], [5.1918880000000005, 3.7728539999999997, 1.579419], [1.75708, 0.6840179999999999, 1.249749], [4.591080000000001, 1.4669819999999998, 1.7472509999999999], [3.91092, 2.835018, 0.24875100000000006], [1.07692, 3.6179819999999996, 2.748249], [1.456676, 0.31404599999999994, 1.8071909999999998], [4.290676, 1.8369539999999998, 1.1898090000000001], [4.211324, 2.4650459999999996, 2.688309], [1.377324, 3.9879539999999998, 0.30869099999999994], [5.571644, 0.5334479999999999, 0.680319], [2.7376440000000004, 1.6175519999999999, 2.316681], [0.0963560000000001, 2.6844479999999997, 0.818181], [2.930356, 3.7685519999999997, 2.178819]],
                "lattice_vectors": [[5.668, 0.0, 0.0], [0.0, 4.302, 0.0], [0.0, 0.0, 2.997]],
                "normalized_wyckoff_matid": {"a": {"X_0": 3, "X_1": 1}}
            }
        ],
        20: [
            {
                "Notes": "Orthorhombic Tridymite (SiO<sub>2</sub>) Structure",
                "Pearsons Symbol": "oC24",
                "Prototype": "O2Si",
                "Space Group Number": 20,
                "Space Group Symbol": "$C222_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_oC24_20_abc_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oC24_20_abc_c.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[2.915664, 0.0, 0.0], [5.824336, 0.0, 4.12], [7.285664000000001, 2.52, 0.0], [1.454336, 2.52, 4.12], [0.0, 2.219112, 2.06], [0.0, 2.820888, 6.18], [4.37, 4.739112, 2.06], [4.37, 0.3008879999999999, 6.18], [2.143922, 0.993384, 2.235512], [2.143922, 4.046615999999999, 6.004488], [6.596078, 0.993384, 1.8844880000000002], [6.596078, 4.046615999999999, 6.355512], [6.513922, 3.5133840000000003, 2.235512], [6.513922, 1.526616, 6.004488], [2.2260780000000002, 3.5133840000000003, 1.8844880000000002], [2.2260780000000002, 1.526616, 6.355512], [2.8976596, 0.18088559999999998, 6.6861832], [2.8976596, 4.8591144, 1.5538168], [5.8423404, 0.18088559999999998, 5.6738168], [5.8423404, 4.8591144, 2.5661832000000007], [7.2676596, 2.7008856, 6.6861832], [7.2676596, 2.3391144, 1.5538168], [1.4723404, 2.7008856, 5.6738168], [1.4723404, 2.3391144, 2.5661832000000007]],
                "lattice_vectors": [[8.74, 0.0, 0.0], [0.0, 5.04, 0.0], [0.0, 0.0, 8.24]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 1}, "c": {"X_0": 2, "X_1": 2}}
            }
        ],
        21: [
            {
                "Notes": "Ta<sub>2</sub>H Structure",
                "Pearsons Symbol": "oC6",
                "Prototype": "HTa2",
                "Space Group Number": 21,
                "Space Group Symbol": "$C222$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_oC6_21_a_k",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_oC6_21_a_k.html",
                "atom_labels": ["H", "H", "Ta", "Ta", "Ta", "Ta"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.69912565, 2.3691752, 0.0], [0.849562825, 1.1845876, 1.2765784027052003], [0.849562825, 3.5537628, 3.4867738461948004], [2.548688475, 1.1845876, 3.4867738461948004], [2.548688475, 3.5537628, 1.2765784027052003]],
                "lattice_vectors": [[3.3982513, 0.0, 0.0], [0.0, 4.7383504, 0.0], [0.0, 0.0, 4.7633522489]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "k": {"X_0": 2}}
            }
        ],
        22: [
            {
                "Notes": "CeRu<sub>2</sub>B<sub>2</sub> Structure",
                "Pearsons Symbol": "oF40",
                "Prototype": "B2CeRu2",
                "Space Group Number": 22,
                "Space Group Symbol": "$F222$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BC2_oF40_22_fi_ad_gh",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC2_oF40_22_fi_ad_gh.html",
                "atom_labels": ["Ce", "Ce", "Ce", "Ce", "Ce", "Ce", "Ce", "Ce", "B", "B", "B", "B", "B", "B", "B", "B", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "B", "B", "B", "B", "B", "B", "B", "B"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 4.52810481685, 5.0129553326], [3.2396534462, 0.0, 5.0129553326], [3.2396534462, 4.52810481685, 0.0], [1.6198267231, 2.264052408425, 7.519432998899999], [1.6198267231, 6.792157225275, 2.5064776663], [4.8594801693, 2.264052408425, 2.5064776663], [4.8594801693, 6.792157225275, 7.519432998899999], [0.0, 2.83821609920158, 0.0], [0.0, 6.21799353449842, 0.0], [0.0, 7.36632091605158, 5.0129553326], [0.0, 1.6898887176484199, 5.0129553326], [3.2396534462, 2.83821609920158, 5.0129553326], [3.2396534462, 6.21799353449842, 5.0129553326], [3.2396534462, 7.36632091605158, 0.0], [3.2396534462, 1.6898887176484199, 0.0], [0.0, 0.0, 3.63639779826804], [0.0, 0.0, 6.38951286693196], [0.0, 4.52810481685, 8.64935313086804], [0.0, 4.52810481685, 1.3765575343319598], [3.2396534462, 0.0, 8.64935313086804], [3.2396534462, 0.0, 1.3765575343319598], [3.2396534462, 4.52810481685, 3.63639779826804], [3.2396534462, 4.52810481685, 6.38951286693196], [1.6198267231, 2.264052408425, 1.14696418009888], [1.6198267231, 6.792157225275, 8.87894648510112], [4.8594801693, 2.264052408425, 8.87894648510112], [4.8594801693, 6.792157225275, 1.14696418009888], [1.6198267231, 6.792157225275, 6.15991951269888], [1.6198267231, 2.264052408425, 3.86599115250112], [4.8594801693, 6.792157225275, 3.86599115250112], [4.8594801693, 2.264052408425, 6.15991951269888], [1.6198267231, 0.65114147266303, 2.5064776663], [1.6198267231, 8.40506816103697, 7.519432998899999], [4.8594801693, 0.65114147266303, 7.519432998899999], [4.8594801693, 8.40506816103697, 2.5064776663], [1.6198267231, 5.17924628951303, 7.519432998899999], [1.6198267231, 3.87696334418697, 2.5064776663], [4.8594801693, 5.17924628951303, 2.5064776663], [4.8594801693, 3.87696334418697, 7.519432998899999]],
                "lattice_vectors": [[6.4793068924, 0.0, 0.0], [0.0, 9.0562096337, 0.0], [0.0, 0.0, 10.0259106652]]
            },
            {
                "Notes": "FeS (Low&ndash;temperature) Structure",
                "Pearsons Symbol": "oF8",
                "Prototype": "FeS",
                "Space Group Number": 22,
                "Space Group Symbol": "$F222$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_oF8_22_a_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oF8_22_a_c.html",
                "atom_labels": ["Fe", "Fe", "Fe", "Fe", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 2.7435144421, 2.59751367355], [2.7700145816, 0.0, 2.59751367355], [2.7700145816, 2.7435144421, 0.0], [1.3850072908, 1.37175722105, 1.298756836775], [1.3850072908, 4.11527166315, 3.896270510325], [4.1550218724, 1.37175722105, 3.896270510325], [4.1550218724, 4.11527166315, 1.298756836775]],
                "lattice_vectors": [[5.5400291632, 0.0, 0.0], [0.0, 5.4870288842, 0.0], [0.0, 0.0, 5.1950273471]]
            }
        ],
        23: [
            {
                "Notes": "H<sub>3</sub>S (5 GPa) Structure",
                "Pearsons Symbol": "oI32",
                "Prototype": "H3S",
                "Space Group Number": 23,
                "Space Group Symbol": "$I222$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_oI32_23_ij2k_k",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_oI32_23_ij2k_k.html",
                "atom_labels": ["H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.3736875681], [0.0, 0.0, 7.3296224319], [2.912315, 3.62202, 4.2253425681], [2.912315, 3.62202, 3.4779674319000002], [0.0, 3.62202, 3.4782755643], [0.0, 3.62202, 4.2250344357000005], [2.912315, 0.0, 7.3299305643], [2.912315, 0.0, 0.3733794357000001], [4.396139492500001, 3.568051902, 1.5718604055], [4.396139492500001, 3.6759880979999995, 6.131449594499999], [1.4284905074999998, 3.568051902, 6.131449594499999], [1.4284905074999998, 3.6759880979999995, 1.5718604055], [1.4838244925000001, 7.190071902000001, 5.423515405500001], [1.4838244925000001, 0.05396809800000009, 2.2797945944999998], [4.3408055075, 7.190071902000001, 2.2797945944999998], [4.3408055075, 0.05396809800000009, 5.423515405500001], [2.575068923, 1.6822834091999999, 2.2043791896], [2.575068923, 5.561756590800001, 5.4989308104], [3.2495610770000005, 1.6822834091999999, 5.4989308104], [3.2495610770000005, 5.561756590800001, 2.2043791896], [5.487383922999999, 5.304303409199999, 6.0560341896], [5.487383922999999, 1.9397365908000002, 1.6472758103999998], [0.33724607700000003, 5.304303409199999, 1.6472758103999998], [0.33724607700000003, 1.9397365908000002, 6.0560341896], [4.4270100315, 5.951703264, 2.8107837528], [4.4270100315, 1.292336736, 4.8925262472], [1.3976199685, 5.951703264, 4.8925262472], [1.3976199685, 1.292336736, 2.8107837528], [1.5146950315000007, 2.3296832640000007, 6.6624387528], [1.5146950315000007, 4.914356736, 1.0408712472000001], [4.3099349685, 2.3296832640000007, 1.0408712472000001], [4.3099349685, 4.914356736, 6.6624387528]],
                "lattice_vectors": [[5.82463, 0.0, 0.0], [0.0, 7.24404, 0.0], [0.0, 0.0, 7.70331]],
                "normalized_wyckoff_matid": {"i": {"X_0": 1}, "j": {"X_0": 1}, "k": {"X_0": 4, "X_1": 2}}
            },
            {
                "Notes": "Stannoidite (Cu<sub>8</sub>(Fe,Zn)<sub>3</sub>Sn<sub>2</sub>S<sub>12</sub>) Structure",
                "Pearsons Symbol": "oI50",
                "Prototype": "Cu8(Fe,S12Sn2Zn)3",
                "Space Group Number": 23,
                "Space Group Symbol": "$I222$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A8B2C12D2E_oI50_23_bcfk_i_3k_j_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A8B2C12D2E_oI50_23_bcfk_i_3k_j_a.html",
                "atom_labels": ["Zn", "Zn", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Fe", "Fe", "Fe", "Fe", "Sn", "Sn", "Sn", "Sn", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [5.3835, 2.7055, 8.059], [5.3835, 0.0, 0.0], [0.0, 2.7055, 8.059], [0.0, 0.0, 8.059], [5.3835, 2.7055, 0.0], [2.7035937, 0.0, 8.059], [8.0634063, 0.0, 8.059], [8.087093699999999, 2.7055, 0.0], [2.6799063, 2.7055, 0.0], [0.0, 0.0, 5.3157163999999995], [0.0, 0.0, 10.802283599999999], [5.3835, 2.7055, 13.374716399999999], [5.3835, 2.7055, 2.7432836], [0.0, 2.7055, 2.7287774], [0.0, 2.7055, 13.389222599999998], [5.3835, 0.0, 10.7877774], [5.3835, 0.0, 5.330222599999999], [2.6540654999999997, 0.05789769999999999, 2.732001], [2.6540654999999997, 5.3531023, 13.385998999999998], [8.1129345, 0.05789769999999999, 13.385998999999998], [8.1129345, 5.3531023, 2.732001], [8.0375655, 2.7633977, 10.791001], [8.0375655, 2.6476023, 5.326999], [2.7294345, 2.7633977, 5.326999], [2.7294345, 2.6476023, 10.791001], [1.4083236, 1.3219073, 1.3313468], [1.4083236, 4.0890927, 14.786653199999998], [9.358676399999998, 1.3219073, 14.786653199999998], [9.358676399999998, 4.0890927, 1.3313468], [6.7918236, 4.027407299999999, 9.3903468], [6.7918236, 1.3835927000000001, 6.727653199999999], [3.9751763999999996, 4.027407299999999, 6.727653199999999], [3.9751763999999996, 1.3835927000000001, 9.3903468], [4.082846399999999, 4.0896338, 1.2910518], [4.082846399999999, 1.3213661999999997, 14.826948199999999], [6.6841536, 4.0896338, 14.826948199999999], [6.6841536, 1.3213661999999997, 1.2910518], [9.466346399999999, 1.3841338, 9.3500518], [9.466346399999999, 4.0268662, 6.767948199999999], [1.3006536000000002, 1.3841338, 6.767948199999999], [1.3006536000000002, 4.0268662, 9.3500518], [1.3932497999999998, 4.0517568, 4.103642799999999], [1.3932497999999998, 1.3592431999999999, 12.0143572], [9.3737502, 4.0517568, 12.0143572], [9.3737502, 1.3592431999999999, 4.103642799999999], [6.776749799999999, 1.3462568000000006, 12.162642799999999], [6.776749799999999, 4.0647432, 3.9553572], [3.9902502, 1.3462568000000006, 3.9553572], [3.9902502, 4.0647432, 12.162642799999999]],
                "lattice_vectors": [[10.767, 0.0, 0.0], [0.0, 5.411, 0.0], [0.0, 0.0, 16.118]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_1": 1}, "c": {"X_4": 1}, "g": {"X_1": 2}, "i": {"X_2": 2}, "j": {"X_3": 2}, "k": {"X_0": 12, "X_1": 4}}
            },
            {
                "Notes": "NaFeS<sub>2</sub> Structure",
                "Pearsons Symbol": "oI16",
                "Prototype": "FeNaS2",
                "Space Group Number": 23,
                "Space Group Symbol": "$I222$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC2_oI16_23_ab_i_k",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC2_oI16_23_ab_i_k.html",
                "atom_labels": ["Fe", "Fe", "Fe", "Fe", "Na", "Na", "Na", "Na", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.69996922095, 3.1249643761, 5.4149382709], [2.69996922095, 0.0, 0.0], [0.0, 3.1249643761, 5.4149382709], [0.0, 0.0, 3.032365431704], [0.0, 0.0, 7.797511110095999], [2.69996922095, 3.1249643761, 8.447303702604], [2.69996922095, 3.1249643761, 2.3825728391959995], [1.349984610475, 1.24998575044, 1.245435802307], [1.349984610475, 4.99994300176, 9.584440739493], [4.049953831425, 1.24998575044, 9.584440739493], [4.049953831425, 4.99994300176, 1.245435802307], [4.049953831425, 4.37495012654, 6.660374073207], [4.049953831425, 1.8749786256599998, 4.1695024685929996], [1.349984610475, 4.37495012654, 4.1695024685929996], [1.349984610475, 1.8749786256599998, 6.660374073207]],
                "lattice_vectors": [[5.3999384419, 0.0, 0.0], [0.0, 6.2499287522, 0.0], [0.0, 0.0, 10.8298765418]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_1": 1}, "i": {"X_2": 2}, "k": {"X_0": 4}}
            },
            {
                "Notes": "BPS<sub>4</sub> Structure",
                "Pearsons Symbol": "oI12",
                "Prototype": "BPS4",
                "Space Group Number": 23,
                "Space Group Symbol": "$I222$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC4_oI12_23_a_b_k",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC4_oI12_23_a_b_k.html",
                "atom_labels": ["B", "B", "P", "P", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.62507901155, 2.80008427895, 4.52013605035], [2.62507901155, 0.0, 0.0], [0.0, 2.80008427895, 4.52013605035], [1.102533184851, 1.12003371158, 1.0396312915805], [1.102533184851, 4.48013484632, 8.0006408091195], [4.147624838249, 1.12003371158, 8.0006408091195], [4.147624838249, 4.48013484632, 1.0396312915805], [3.7276121964009996, 3.9201179905299997, 5.5597673419305], [3.7276121964009996, 1.68005056737, 3.4805047587695], [1.5225458266990002, 3.9201179905299997, 3.4805047587695], [1.5225458266990002, 1.68005056737, 5.5597673419305]],
                "lattice_vectors": [[5.2501580231, 0.0, 0.0], [0.0, 5.6001685579, 0.0], [0.0, 0.0, 9.0402721007]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "k": {"X_0": 4}}
            }
        ],
        24: [
            {
                "Notes": "Weberite (Na<sub>2</sub>MgAlF<sub>7</sub>) Structure",
                "Pearsons Symbol": "oI44",
                "Prototype": "AlF7MgNa2",
                "Space Group Number": 24,
                "Space Group Symbol": "$I2_{1}2_{1}2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB7CD2_oI44_24_a_b3d_c_ac",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB7CD2_oI44_24_a_b3d_c_ac.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Na", "Na", "Na", "Na", "F", "F", "F", "F", "Mg", "Mg", "Mg", "Mg", "Na", "Na", "Na", "Na", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F"],
                "atom_positions": [[5.29539878915691, 0.0, 2.4948177433], [5.27988836799309, 0.0, 7.4844532299], [1.75479264894309, 3.64859907265, 2.4948177433], [1.7703030701069107, 3.64859907265, 7.4844532299], [1.75972778294976, 0.0, 2.4948177433], [1.76536793610024, 0.0, 7.4844532299], [5.29046365515024, 3.64859907265, 2.4948177433], [5.28482350199976, 3.64859907265, 7.4844532299], [1.762547859525, 0.99314866757533, 0.0], [1.762547859525, 6.3040494777246705, 4.9896354866], [5.287643578575, 2.6554504050746703, 0.0], [5.287643578575, 4.64174774022533, 4.9896354866], [0.0, 1.824299536325, 9.976277191908041], [0.0, 5.472898608975, 4.99262926789196], [3.52509571905, 1.824299536325, 0.0029937812919599996], [3.52509571905, 5.472898608975, 4.98664170530804], [0.0, 1.824299536325, 4.9916313407946395], [0.0, 5.472898608975, 9.97727511900536], [3.52509571905, 1.824299536325, 4.987639632405361], [3.52509571905, 5.472898608975, 0.00199585419463978], [5.28834859771881, 1.61486994955489, 3.34904333860592], [5.28834859771881, 5.68232819574511, 1.64059214799408], [5.2869385594311895, 1.61486994955489, 6.63022763459408], [1.76184284038119, 2.0337291230951102, 3.34904333860592], [1.7632528786688098, 5.263469022204891, 8.33867882520592], [1.7632528786688098, 2.0337291230951102, 6.63022763459408], [1.76184284038119, 5.263469022204891, 1.64059214799408], [5.2869385594311895, 5.68232819574511, 8.33867882520592], [3.99181839225222, 0.49693919369493, 1.35917670654984], [3.99181839225222, 6.80025895160507, 3.63045878005016], [6.58346876489778, 0.49693919369493, 8.62009426665016], [3.05837304584778, 3.15165987895507, 1.35917670654984], [0.4667226732022202, 4.14553826634493, 6.34881219314984], [0.4667226732022202, 3.15165987895507, 8.62009426665016], [3.05837304584778, 4.14553826634493, 3.63045878005016], [6.58346876489778, 6.80025895160507, 6.34881219314984], [6.59333903291112, 0.51737134850177, 1.3821290297882], [6.59333903291112, 6.779826796798231, 3.6075064568118], [3.9819481242388797, 0.51737134850177, 8.597141943411799], [0.45685240518887993, 3.13122772414823, 1.3821290297882], [3.06824331386112, 4.16597042115177, 6.3717645163882], [3.06824331386112, 3.13122772414823, 8.597141943411799], [0.45685240518887993, 4.16597042115177, 3.6075064568118], [3.9819481242388797, 6.779826796798231, 6.3717645163882]],
                "lattice_vectors": [[7.0501914381, 0.0, 0.0], [0.0, 7.2971981453, 0.0], [0.0, 0.0, 9.9792709732]]
            }
        ],
        25: [
            {
                "Notes": "High&ndash;pressure CdTe Structure",
                "Pearsons Symbol": "oP2",
                "Prototype": "CdTe",
                "Space Group Number": 25,
                "Space Group Symbol": "$Pmm2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_oP2_25_b_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oP2_25_b_a.html",
                "atom_labels": ["Te", "Cd"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 2.629, 0.756625]],
                "lattice_vectors": [[2.8102, 0.0, 0.0], [0.0, 5.258, 0.0], [0.0, 0.0, 3.0265]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}}
            }
        ],
        26: [
            {
                "Notes": "H<sub>2</sub>S (70 GPa) Structure",
                "Pearsons Symbol": "oP12",
                "Prototype": "H2S",
                "Space Group Number": 26,
                "Space Group Symbol": "$Pmc2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_oP12_26_abc_ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP12_26_abc_ab.H2S.html",
                "atom_labels": ["H", "H", "S", "S", "H", "H", "S", "S", "H", "H", "H", "H"],
                "atom_positions": [[0.0, 1.3353795, 4.2452982], [0.0, 1.5995204999999997, 1.7713482000000005], [0.0, 0.5253471, 3.0825416999999997], [0.0, 2.4095528999999996, 0.6085917], [2.3403, 0.1408752, 2.6966055], [2.3403, 2.7940248, 0.22265549999999965], [2.3403, 1.1005875, 1.7565045], [2.3403, 1.8343124999999998, 4.2304545], [3.5151306, 0.3492531, 1.0539026999999999], [1.1654694, 2.5856469, 3.5278526999999995], [1.1654694, 0.3492531, 1.0539026999999999], [3.5151306, 2.5856469, 3.5278526999999995]],
                "lattice_vectors": [[4.6806, 0.0, 0.0], [0.0, 2.9349, 0.0], [0.0, 0.0, 4.9479]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "b": {"X_0": 1, "X_1": 1}, "c": {"X_0": 2}}
            },
            {
                "Notes": "$\\beta$&ndash;SeO<sub>2</sub> Structure",
                "Pearsons Symbol": "oP12",
                "Prototype": "O2Se",
                "Space Group Number": 26,
                "Space Group Symbol": "$Pmc2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_oP12_26_abc_ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP12_26_abc_ab.SeO2.html",
                "atom_labels": ["O", "O", "Se", "Se", "O", "O", "Se", "Se", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.536488447224, 0.0], [0.0, 3.9342486129760004, 3.76573390825], [0.0, 1.11053108575368, 3.4720066634065003], [0.0, 3.3602059744463206, 7.2377405716565], [2.53629121745, 1.0998013168092, 2.1765941989685], [2.53629121745, 3.3709357433908003, 5.9423281072185], [2.53629121745, 1.6903856824616201, 0.6492125257823], [2.53629121745, 2.78035137773838, 4.4149464340323], [1.2833633560297, 2.9149205632504005, 0.90377613798], [3.7892190788703, 1.5558164969496, 4.66951004623], [3.7892190788703, 2.9149205632504005, 0.90377613798], [1.2833633560297, 1.5558164969496, 4.66951004623]],
                "lattice_vectors": [[5.0725824349, 0.0, 0.0], [0.0, 4.4707370602, 0.0], [0.0, 0.0, 7.5314678165]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "b": {"X_0": 1, "X_1": 1}, "c": {"X_0": 2}}
            },
            {
                "Notes": "TlP<sub>5</sub> Structure",
                "Pearsons Symbol": "oP24",
                "Prototype": "P5Tl",
                "Space Group Number": 26,
                "Space Group Symbol": "$Pmc2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A5B_oP24_26_3a3b2c_ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B_oP24_26_3a3b2c_ab.html",
                "atom_labels": ["P", "P", "P", "P", "P", "P", "Tl", "Tl", "P", "P", "P", "P", "P", "P", "Tl", "Tl", "P", "P", "P", "P", "P", "P", "P", "P"],
                "atom_positions": [[0.0, 1.12737611635088, 3.52271008787967], [0.0, 5.797538603249119, 9.58172296692967], [0.0, 0.7755904485952001, 0.0], [0.0, 6.1493242710048, 6.05901287905], [0.0, 1.00549761728592, 10.00464206588736], [0.0, 5.91941710231408, 3.9456291868373614], [0.0, 3.3648160622536403, 1.48688176051887], [0.0, 3.56009865734636, 7.54589463956887], [3.232506871, 0.79359522686616, 0.11633304727775999], [3.232506871, 6.13131949273384, 6.17534592632776], [3.232506871, 2.27552697686056, 1.64562789794998], [3.232506871, 4.6493877427394406, 7.70464077699998], [3.232506871, 1.0837491536174, 3.5202864827280496], [3.232506871, 5.8411655659826005, 9.57929936177805], [3.232506871, 4.995633478719441, 3.41485965863258], [3.232506871, 1.9292812408805597, 9.473872537682581], [1.6091419203838, 1.97637066097384, 4.78298476672207], [4.8558718216162, 4.94854405862616, 10.84199764577207], [4.8558718216162, 1.97637066097384, 4.78298476672207], [1.6091419203838, 4.94854405862616, 10.84199764577207], [1.609788421758, 0.66686928749748, 6.58735880210316], [4.855225320242, 6.25804543210252, 0.528345923053161], [4.855225320242, 0.66686928749748, 6.58735880210316], [1.609788421758, 6.25804543210252, 0.528345923053161]],
                "lattice_vectors": [[6.465013742, 0.0, 0.0], [0.0, 6.9249147196, 0.0], [0.0, 0.0, 12.1180257581]],
                "normalized_wyckoff_matid": {"a": {"X_0": 3, "X_1": 1}, "b": {"X_0": 3, "X_1": 1}, "c": {"X_0": 4}}
            }
        ],
        27: [
            {
                "Notes": "Ca<sub>4</sub>Al<sub>6</sub>O<sub>16</sub>S Structure",
                "Pearsons Symbol": "oP108",
                "Prototype": "Al6Ca4O16S",
                "Space Group Number": 27,
                "Space Group Symbol": "$Pcc2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A6B4C16D_oP108_27_abcd4e_4e_16e_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A6B4C16D_oP108_27_abcd4e_4e_16e_e.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 4.5846300447], [0.0, 6.5196927259, 0.045846300447], [0.0, 6.5196927259, 4.630476345147], [6.5204927311, 0.0, 0.275077802682], [6.5204927311, 0.0, 4.859707847382], [6.5204927311, 6.5196927259, 0.45846300447], [6.5204927311, 6.5196927259, 5.04309304917], [4.8642875774006, 4.9419270862322, 2.7141009864624], [8.1766978847994, 8.0974583655678, 2.7141009864624], [8.1766978847994, 4.9419270862322, 7.2987310311624], [4.8642875774006, 8.0974583655678, 7.2987310311624], [1.5910002263884, 1.629923181475, 2.2831457622605997], [11.4499852358116, 11.409462270325, 2.2831457622605997], [11.4499852358116, 1.629923181475, 6.8677758069606], [1.5910002263884, 11.409462270325, 6.8677758069606], [4.8121236355518, 1.6820807232822, 2.5673928250320004], [8.2288618266482, 11.3573047285178, 2.5673928250320004], [8.2288618266482, 1.6820807232822, 7.152022869732], [4.8121236355518, 11.3573047285178, 7.152022869732], [1.5910002263884, 4.9028089298768, 2.384007623244], [11.4499852358116, 8.1365765219232, 2.384007623244], [11.4499852358116, 4.9028089298768, 6.968637667944], [1.5910002263884, 8.1365765219232, 6.968637667944], [0.7563771568076001, 9.7925784743018, 4.1169977801406], [12.2846083053924, 3.2468069774982, 4.1169977801406], [12.2846083053924, 9.7925784743018, 8.7016278248406], [0.7563771568076001, 3.2468069774982, 8.7016278248406], [3.0907135545414, 7.484607249333199, 0.7885563676883999], [9.9502719076586, 5.5547782024668, 0.7885563676883999], [9.9502719076586, 7.484607249333199, 5.3731864123883994], [3.0907135545414, 5.5547782024668, 5.3731864123883994], [3.3515332637854, 0.1564726254216, 5.0797700895276], [9.6894521984146, 12.8829128263784, 5.0797700895276], [9.6894521984146, 0.1564726254216, 0.49514004482760043], [3.3515332637854, 12.8829128263784, 0.49514004482760043], [6.2987959782426, 3.2207282065946, 0.2567392825032], [6.7421894839574, 9.818657245205399, 0.2567392825032], [6.7421894839574, 3.2207282065946, 4.8413693272032], [6.2987959782426, 9.818657245205399, 4.8413693272032], [9.5068784019438, 2.3862075376794, 3.7777351568328], [3.5341070602562, 10.6531779141206, 3.7777351568328], [3.5341070602562, 2.3862075376794, 8.3623652015328], [9.5068784019438, 10.6531779141206, 8.3623652015328], [2.1126396448764, 8.9189396490312, 2.384007623244], [10.9283458173236, 4.120445802768799, 2.384007623244], [10.9283458173236, 8.9189396490312, 6.968637667944], [2.1126396448764, 4.120445802768799, 6.968637667944], [2.9994266563060004, 2.1384592140952, 6.2259276007026], [10.041558805894, 10.900926237704798, 6.2259276007026], [10.041558805894, 2.1384592140952, 1.6412975560026004], [2.9994266563060004, 10.900926237704798, 1.6412975560026004], [8.4896815358922, 3.8987762500881997, 5.70052899757998], [4.5513039263078, 9.1406092017118, 5.70052899757998], [4.5513039263078, 3.8987762500881997, 1.1158989528799812], [8.4896815358922, 9.1406092017118, 1.1158989528799812], [5.21639418488, 3.3120039047572, 2.1822839012772], [7.82459127732, 9.7273815470428, 2.1822839012772], [7.82459127732, 3.3120039047572, 6.766913945977199], [5.21639418488, 9.7273815470428, 6.766913945977199], [5.6467467051326, 1.1865840761138, 4.034474439336], [7.3942387570673995, 11.8528013756862, 4.034474439336], [7.3942387570673995, 1.1865840761138, 8.619104484035999], [5.6467467051326, 11.8528013756862, 8.619104484035999], [5.803238530679, 5.150557253461, 4.172013340677], [7.2377469315209995, 7.888828198339, 4.172013340677], [7.2377469315209995, 5.150557253461, 8.756643385377], [5.803238530679, 7.888828198339, 8.756643385377], [3.195041438239, 1.173544690662, 2.7874550671776], [9.845944023961, 11.865840761138, 2.7874550671776], [9.845944023961, 1.173544690662, 7.3720851118776], [3.195041438239, 11.865840761138, 7.3720851118776], [5.2685581267288, 0.7432449707526, 1.1553267712644], [7.7724273354712, 12.296140481047399, 1.1553267712644], [7.7724273354712, 0.7432449707526, 5.7399568159644], [5.2685581267288, 12.296140481047399, 5.7399568159644], [1.2128116479846, 0.7041268143971999, 0.9352645291187999], [11.8281738142154, 12.335258637402799, 0.9352645291187999], [11.8281738142154, 0.7041268143971999, 5.519894573818799], [1.2128116479846, 12.335258637402799, 5.519894573818799], [3.1689594673146, 5.2418329516236, 3.0808713900384], [9.8720259948854, 7.7975525001763994, 3.0808713900384], [9.8720259948854, 5.2418329516236, 7.665501434738401], [3.1689594673146, 7.7975525001763994, 7.665501434738401], [1.2910575607578, 6.0763536205388, 1.1369882510856], [11.7499279014422, 6.9630318312612, 1.1369882510856], [11.7499279014422, 6.0763536205388, 5.7216182957856], [1.2910575607578, 6.9630318312612, 5.7216182957856], [5.1120663011824, 6.0893930059906, 1.4120660537676], [7.9289191610176, 6.949992445809398, 1.4120660537676], [7.9289191610176, 6.0893930059906, 5.9966960984676], [5.1120663011824, 6.949992445809398, 5.9966960984676], [1.3432215026066, 3.2989645193054, 1.7513286770754], [11.6977639595934, 9.7404209324946, 1.7513286770754], [11.6977639595934, 3.2989645193054, 6.3359587217754], [1.3432215026066, 9.7404209324946, 6.3359587217754], [0.6129263167234, 5.020163398943, 3.8969355379949997], [12.428059145476599, 8.019222052857, 3.8969355379949997], [12.428059145476599, 5.020163398943, 8.481565582695], [0.6129263167234, 8.019222052857, 8.481565582695], [0.6781312440344, 1.4473717851498, 3.7593966366539995], [12.3628542181656, 11.5920136666502, 3.7593966366539995], [12.3628542181656, 1.4473717851498, 8.344026681353998], [0.6781312440344, 11.5920136666502, 8.344026681353998], [9.733009089858347, 3.27679756403734, 2.5873818120268917], [3.3079763723416518, 9.762587887762658, 2.5873818120268917], [3.3079763723416518, 3.27679756403734, 7.172011856726892], [9.733009089858347, 9.762587887762658, 7.172011856726892]],
                "lattice_vectors": [[13.0409854622, 0.0, 0.0], [0.0, 13.0393854518, 0.0], [0.0, 0.0, 9.1692600894]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_1": 1}, "c": {"X_1": 1}, "d": {"X_1": 1}, "e": {"X_0": 32, "X_1": 8, "X_2": 8, "X_3": 2}}
            }
        ],
        28: [
            {
                "Notes": "Krennerite (AuTe<sub>2</sub>, C46) Structure",
                "Pearsons Symbol": "oP24",
                "Prototype": "AuTe2",
                "Space Group Number": 28,
                "Space Group Symbol": "$Pma2$",
                "Strukturbericht Designation": "$C46$",
                "aflow_prototype_id": "AB2_oP24_28_acd_2c3d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_oP24_28_acd_2c3d.html",
                "atom_labels": ["Au", "Au", "Au", "Au", "Te", "Te", "Te", "Te", "Au", "Au", "Au", "Au", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te"],
                "atom_positions": [[0.0, 0.0, 0.0], [8.27, 0.0, 0.0], [4.135, 2.81358, 0.06244], [12.405, 6.00642, 0.06244], [4.135, 0.15875999999999998, 0.18732000000000001], [12.405, 8.66124, 0.18732000000000001], [4.135, 5.44194, 0.18732000000000001], [12.405, 3.37806, 0.18732000000000001], [10.32096, 2.9458800000000003, 2.23], [6.21904, 5.87412, 2.23], [14.48904, 2.9458800000000003, 2.23], [2.0509600000000017, 5.87412, 2.23], [8.31962, 2.65482, 0.18732000000000001], [8.220379999999999, 6.165180000000001, 0.18732000000000001], [16.49038, 2.65482, 0.18732000000000001], [0.04962000000000188, 6.165180000000001, 0.18732000000000001], [10.45328, 5.60952, 2.23], [6.08672, 3.21048, 2.23], [14.35672, 5.60952, 2.23], [2.1832800000000017, 3.21048, 2.23], [10.238259999999999, 0.31751999999999997, 2.23], [6.30174, 8.50248, 2.23], [14.57174, 0.31751999999999997, 2.23], [1.96826, 8.50248, 2.23]],
                "lattice_vectors": [[16.54, 0.0, 0.0], [0.0, 8.82, 0.0], [0.0, 0.0, 4.46]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 2, "X_1": 1}, "d": {"X_0": 6, "X_1": 2}}
            }
        ],
        29: [
            {
                "Notes": "Pyrite (FeS<sub>2</sub>, Low&ndash;temperature) Structure",
                "Pearsons Symbol": "oP12",
                "Prototype": "FeS2",
                "Space Group Number": 29,
                "Space Group Symbol": "$Pca2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_oP12_29_a_2a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_oP12_29_a_2a.html",
                "atom_labels": ["Fe", "Fe", "Fe", "Fe", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[2.7355258706460304, 1.31060350189993, 0.0], [2.68242990405397, 4.10735227280007, 2.70897788735], [5.39140779140397, 1.31060350189993, 2.70897788735], [0.026547983296030687, 4.10735227280007, 0.0], [3.3320428014405, 0.7314240295845, 2.07724424401998], [2.0859129732595, 4.6865317451155, 4.78622213136998], [4.794890860609501, 0.7314240295845, 4.78622213136998], [0.6230649140905, 4.6865317451155, 2.07724424401998], [3.3320428014405, 3.4404019169345004, 0.61439618485098], [2.0859129732595, 1.9775538577655, 3.3233740722009797], [4.794890860609501, 3.4404019169345004, 3.3233740722009797], [0.6230649140905, 1.9775538577655, 0.61439618485098]],
                "lattice_vectors": [[5.4179557747, 0.0, 0.0], [0.0, 5.4179557747, 0.0], [0.0, 0.0, 5.4179557747]],
                "normalized_wyckoff_matid": {"a": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "Cobaltite (CoAsS) Structure",
                "Pearsons Symbol": "oP12",
                "Prototype": "AsCoS",
                "Space Group Number": 29,
                "Space Group Symbol": "$Pca2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_oP12_29_a_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_oP12_29_a_a_a.html",
                "atom_labels": ["As", "As", "As", "As", "Co", "Co", "Co", "Co", "S", "S", "S", "S"],
                "atom_positions": [[3.25482193171084, 3.1958110978242003, 0.592324474946776], [2.00464632668916, 1.8716765701757998, 3.130567854046776], [4.63438045588916, 3.1958110978242003, 3.130567854046776], [0.6250878025108406, 1.8716765701757998, 0.592324474946776], [2.655821091761664, 1.22080845409788, 0.0], [2.603647166638336, 3.8466792139021204, 2.5382433791], [5.2333812958383366, 1.22080845409788, 2.5382433791], [0.026086962561664397, 3.8466792139021204, 0.0], [3.246880134640656, 0.66531045593172, 1.928861908645672], [2.012588123759344, 4.40217721206828, 4.467105287745672], [4.642322252959344, 0.66531045593172, 4.467105287745672], [0.617146005440656, 4.40217721206828, 1.928861908645672]],
                "lattice_vectors": [[5.2594682584, 0.0, 0.0], [0.0, 5.067487668, 0.0], [0.0, 0.0, 5.0764867582]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1, "X_2": 1}}
            },
            {
                "Notes": "ZrO<sub>2</sub> Structure",
                "Pearsons Symbol": "oP12",
                "Prototype": "O2Zr",
                "Space Group Number": 29,
                "Space Group Symbol": "$Pca2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_oP12_29_2a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP12_29_2a_a.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "Zr", "Zr", "Zr", "Zr"],
                "atom_positions": [[3.3608002171176, 0.34458916142400003, 0.0], [1.8986680412824, 4.722898506576, 2.5382433791], [4.5284021704824005, 0.34458916142400003, 2.5382433791], [0.7310660879176001, 4.722898506576, 0.0], [4.0550500272264, 2.721240877716, 0.5381075963691999], [1.2044182311736, 2.346246790284, 3.0763509754691998], [3.8341523603736, 2.721240877716, 3.0763509754691998], [1.4253158980263996, 2.346246790284, 0.5381075963691999], [2.787518176952, 1.3530192073560001, 1.8072292859191998], [2.471950081448, 3.714468460644, 4.3454726650192], [5.101684210648, 1.3530192073560001, 4.3454726650192], [0.15778404775200014, 3.714468460644, 1.8072292859191998]],
                "lattice_vectors": [[5.2594682584, 0.0, 0.0], [0.0, 5.067487668, 0.0], [0.0, 0.0, 5.0764867582]],
                "normalized_wyckoff_matid": {"a": {"X_0": 2, "X_1": 1}}
            }
        ],
        30: [
            {
                "Notes": "CuBrSe<sub>3</sub> Structure",
                "Pearsons Symbol": "oP20",
                "Prototype": "BrCuSe3",
                "Space Group Number": 30,
                "Space Group Symbol": "$Pnc2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC3_oP20_30_2a_c_3c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC3_oP20_30_2a_c_3c.html",
                "atom_labels": ["Br", "Br", "Br", "Br", "Cu", "Cu", "Cu", "Cu", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se"],
                "atom_positions": [[0.0, 0.0, 12.24121759799864], [0.0, 3.8359852398, 5.076745165598638], [0.0, 0.0, 7.1644724324], [0.0, 3.8359852398, 0.0], [1.3492239084337998, 5.531490715791599, 5.86913581662208], [3.1317588495662, 2.1404797638084, 5.86913581662208], [3.1317588495662, 1.6955054759916006, 13.03360824902208], [1.3492239084337998, 5.9764650036084, 13.03360824902208], [1.6162904808106, 5.6043744353478, 2.48320614506984], [2.8646922771893997, 2.0675960442521997, 2.48320614506984], [2.8646922771893997, 1.768389195547801, 9.64767857746984], [1.6162904808106, 5.9035812840521995, 9.64767857746984], [2.6200306186025997, 6.62014332684684, 0.71071566529408], [1.8609521393973998, 1.05182715275316, 0.71071566529408], [1.8609521393973998, 2.78415808704684, 7.87518809769408], [2.6200306186025997, 4.88781239255316, 7.87518809769408], [2.8239153340915997, 6.53882043976308, 4.28578740906168], [1.6570674239084, 1.1331500398369203, 4.28578740906168], [1.6570674239084, 2.70283519996308, 11.45025984146168], [2.8239153340915997, 4.96913527963692, 11.45025984146168]],
                "lattice_vectors": [[4.480982758, 0.0, 0.0], [0.0, 7.6719704796, 0.0], [0.0, 0.0, 14.3289448648]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 3, "X_2": 1}}
            },
            {
                "Notes": "Bi<sub>5</sub>Nb<sub>3</sub>O<sub>15</sub> Structure",
                "Pearsons Symbol": "oP46",
                "Prototype": "Bi5Nb3O15",
                "Space Group Number": 30,
                "Space Group Symbol": "$Pnc2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A5B3C15_oP46_30_a2c_bc_a7c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B3C15_oP46_30_a2c_bc_a7c.html",
                "atom_labels": ["Bi", "Bi", "O", "O", "Nb", "Nb", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Nb", "Nb", "Nb", "Nb", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 10.5055118845], [0.0, 2.7365030957, 0.0], [0.0, 0.0, 2.2481795432830003], [0.0, 2.7365030957, 12.753691427783], [2.73150309005, 0.0, 10.988765431187002], [2.73150309005, 2.7365030957, 0.48325354668700277], [1.33406610918042, 2.8076521761882, 0.399209451611], [4.12894007091958, 2.6653540152117996, 0.399209451611], [4.12894007091958, 0.07114908048819946, 10.904721336111], [1.33406610918042, 5.401857110911799, 10.904721336111], [2.00765477118675, 0.1422981609764, 0.33617638030400004], [3.45535140891325, 5.330708030423599, 0.33617638030400004], [3.45535140891325, 2.8788012566764, 10.841688264804], [2.00765477118675, 2.5942049347236, 10.841688264804], [0.58672686374274, 0.0164190185742, 0.42022047538], [4.87627931635726, 5.4565871728258, 0.42022047538], [4.87627931635726, 2.7529221142741997, 10.925732359880001], [0.58672686374274, 2.7200840771258, 10.925732359880001], [1.0647399045014898, 0.27365030956999997, 1.554815758906], [4.39826627559851, 5.19935588183, 1.554815758906], [4.39826627559851, 3.01015340527, 12.060327643406], [1.0647399045014898, 2.46285278613, 12.060327643406], [0.5299115994697, 3.7599552534918, 4.62242522918], [4.9330945806303, 1.7130509379081995, 4.62242522918], [4.9330945806303, 1.0234521577918003, 15.12793711368], [0.5299115994697, 4.4495540336082, 15.12793711368], [0.46107772160044, 1.3901435726156, 4.7484913717940005], [5.00192845849956, 4.0828626187844, 4.7484913717940005], [5.00192845849956, 4.126646668315599, 15.254003256294], [0.46107772160044, 1.3463595230843999, 15.254003256294], [2.2562215523813, 2.845963219528, 2.206157495745], [3.2067846277186995, 2.6270429718719996, 2.206157495745], [3.2067846277186995, 0.10946012382800009, 12.711669380245], [2.2562215523813, 5.363546067572, 12.711669380245], [2.7588181209505, 3.9296184454251994, 6.513417368390001], [2.7041880591495, 1.5433877459748, 6.513417368390001], [2.7041880591495, 1.1931153497251998, 17.01892925289], [2.7588181209505, 4.2798908416748, 17.01892925289], [1.6662168849305, 4.1759037240382, 5.693987441399001], [3.7967892951695004, 1.2971024673618, 5.693987441399001], [3.7967892951695004, 1.4394006283381993, 16.199499325899], [1.6662168849305, 4.0336055630617995, 16.199499325899], [3.7967892951694995, 4.1157006559328, 6.072185869241], [1.6662168849305001, 1.3573055354672, 6.072185869241], [1.6662168849305001, 1.3791975602328, 16.577697753741], [3.7967892951694995, 4.0938086311671995, 16.577697753741]],
                "lattice_vectors": [[5.4630061801, 0.0, 0.0], [0.0, 5.4730061914, 0.0], [0.0, 0.0, 21.011023769]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "b": {"X_2": 1}, "c": {"X_0": 14, "X_1": 4, "X_2": 2}}
            }
        ],
        31: [
            {
                "Notes": "Enargite (AsCu<sub>3</sub>S<sub>4</sub>, H2<sub>5</sub>) Structure",
                "Pearsons Symbol": "oP16",
                "Prototype": "AsCu3S4",
                "Space Group Number": 31,
                "Space Group Symbol": "$Pmn2_{1}$",
                "Strukturbericht Designation": "$H2_{5}$",
                "aflow_prototype_id": "AB3C4_oP16_31_a_ab_2ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3C4_oP16_31_a_ab_2ab.html",
                "atom_labels": ["As", "As", "Cu", "Cu", "S", "S", "S", "S", "Cu", "Cu", "Cu", "Cu", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 5.341127999999999, 0.0], [3.715, 1.118872, 3.09], [0.0, 0.978044, 3.079494], [3.715, 5.481956, 6.169493999999999], [0.0, 5.313996, 3.9885719999999996], [3.715, 1.146004, 0.8985719999999998], [0.0, 0.927656, 0.7205879999999999], [3.715, 5.532344, 3.810588], [1.832238, 2.10273, 6.097188], [1.8827619999999996, 4.35727, 3.0071879999999998], [5.5977619999999995, 2.10273, 6.097188], [5.547238, 4.35727, 3.0071879999999998], [1.9303139999999996, 2.1731439999999997, 3.8217119999999993], [1.7846860000000002, 4.286855999999999, 0.7317119999999989], [5.499686, 2.1731439999999997, 3.8217119999999993], [5.645314, 4.286855999999999, 0.7317119999999989]],
                "lattice_vectors": [[7.43, 0.0, 0.0], [0.0, 6.46, 0.0], [0.0, 0.0, 6.18]],
                "normalized_wyckoff_matid": {"a": {"X_0": 2, "X_1": 1, "X_2": 1}, "b": {"X_0": 2, "X_1": 2}}
            }
        ],
        32: [
            {
                "Notes": "Re<sub>2</sub>O<sub>5</sub>[SO<sub>4</sub>]<sub>2</sub> Structure",
                "Pearsons Symbol": "oP34",
                "Prototype": "O4]2O5[Re2S",
                "Space Group Number": 32,
                "Space Group Symbol": "$Pba2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A13B2C2_oP34_32_a6c_c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A13B2C2_oP34_32_a6c_c_c.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Re", "Re", "Re", "Re", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.2130892494, 4.8243521983, 0.0], [6.808352227030401, 5.30678741813, 5.28496145579052], [1.6178262717695997, 4.34191697847, 5.28496145579052], [5.8309155211696, 0.48243521983000043, 5.28496145579052], [2.5952629776304006, 9.16626917677, 5.28496145579052], [5.1736735982632, 7.328190989217699, 5.7569807049719], [3.2525049005368003, 2.3205134073823004, 5.7569807049719], [7.465594149936801, 2.5038387909177007, 5.7569807049719], [0.9605843488631991, 7.1448656056823, 5.7569807049719], [6.9069385154663605, 7.761417816625039, 3.7926953438604003], [1.5192399833336403, 1.8872865799749599, 3.7926953438604003], [5.73232923273364, 2.9370656183250397, 3.7926953438604003], [2.693849266066361, 6.71163877827496, 3.7926953438604003], [4.52233000030596, 6.25332531943646, 2.30042923193028], [3.9038484984940407, 3.3953790771635397, 2.30042923193028], [8.11693774789404, 1.428973121136459, 2.30042923193028], [0.30924075090595965, 8.21973127546354, 2.30042923193028], [6.478888647727321, 8.97040047751902, 1.7232542551465402], [1.94728985107268, 0.67830391908098, 1.7232542551465402], [6.16037910047268, 4.14604827921902, 1.7232542551465402], [2.2657993983273195, 5.50265611738098, 1.7232542551465402], [7.07124899619296, 6.638308624860799, 1.64999970333366], [1.3549295026070405, 3.0103957717392005, 1.64999970333366], [5.568018752007041, 1.8139564265607995, 1.64999970333366], [2.8581597467929596, 7.8347479700392, 1.64999970333366], [5.7016579429980085, 5.863807122945717, 0.49860356233928], [2.724520555801992, 3.784897273654282, 0.49860356233928], [6.937609805201992, 1.039454924645719, 0.49860356233928], [1.4885686935980085, 8.609249471954282, 0.49860356233928], [7.28274607651284, 7.9457080706001, 2.4498921481291402], [1.1434324222871604, 1.7029963259999, 2.4498921481291402], [5.356521671687161, 3.121355872300101, 2.4498921481291402], [3.0696568271128406, 6.527348524299899, 2.4498921481291402]],
                "lattice_vectors": [[8.4261784988, 0.0, 0.0], [0.0, 9.6487043966, 0.0], [0.0, 0.0, 5.9076251462]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_0": 12, "X_1": 2, "X_2": 2}}
            }
        ],
        33: [
            {
                "Notes": "AsK<sub>3</sub>S<sub>4</sub> Structure",
                "Pearsons Symbol": "oP32",
                "Prototype": "AsK3S4",
                "Space Group Number": 33,
                "Space Group Symbol": "$Pna2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3C4_oP32_33_a_3a_4a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3C4_oP32_33_a_3a_4a.html",
                "atom_labels": ["As", "As", "As", "As", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[1.992357, 4.460896, 2.148798], [7.117642999999999, 4.819103999999999, 7.438798], [2.562643, 9.100895999999999, 7.438798], [6.547357, 0.17910399999999985, 2.148798], [4.024798, 1.9042559999999997, 0.015870000000000002], [5.085202, 7.375743999999999, 5.30587], [0.5302019999999997, 6.544256, 5.30587], [8.579797999999998, 2.735744, 0.015870000000000002], [4.0885679999999995, 1.825376, 4.386468000000001], [5.021432, 7.454624, 9.676468000000002], [0.4664320000000002, 6.465375999999999, 9.676468000000002], [8.643567999999998, 2.814624, 4.386468000000001], [1.2954419999999998, 8.515327999999998, 2.376268], [7.814558, 0.7646720000000002, 7.6662680000000005], [3.2595579999999997, 3.8753279999999997, 7.6662680000000005], [5.850441999999999, 5.404672, 2.376268], [1.7400099999999998, 2.3255679999999996, 2.357224], [7.369989999999999, 6.954432, 7.6472240000000005], [2.81499, 6.965567999999999, 7.6472240000000005], [6.29501, 2.314432, 2.357224], [3.119264, 4.975008, 0.43907], [5.990735999999999, 4.3049919999999995, 5.72907], [1.4357360000000001, 0.3350080000000002, 5.72907], [7.674264, 8.944992, 0.43907], [0.062859, 5.452928, 2.340296], [9.047141, 3.827072, 7.630296], [4.492140999999999, 0.8129280000000011, 7.630296], [4.617859, 8.467072, 2.340296], [3.056405, 5.06688, 3.979138], [6.053595, 4.213119999999999, 9.269138], [1.4985949999999997, 0.42688000000000037, 9.269138], [7.6114049999999995, 8.853119999999999, 3.979138]],
                "lattice_vectors": [[9.11, 0.0, 0.0], [0.0, 9.28, 0.0], [0.0, 0.0, 10.58]],
                "normalized_wyckoff_matid": {"a": {"X_0": 4, "X_1": 3, "X_2": 1}}
            },
            {
                "Notes": "Modderite (CoAs) Structure",
                "Pearsons Symbol": "oP8",
                "Prototype": "AsCo",
                "Space Group Number": 33,
                "Space Group Symbol": "$Pna2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_oP8_33_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oP8_33_a_a.html",
                "atom_labels": ["As", "As", "As", "As", "Co", "Co", "Co", "Co"],
                "atom_positions": [[1.05502572, 3.4424622499999997, 0.87416798], [4.230674280000001, 2.42503775, 2.61831798], [1.5878242800000002, 0.50871225, 2.61831798], [3.6978757200000003, 5.358787749999999, 0.87416798], [0.010571400000000002, 1.17526025, 0.872075], [5.2751286, 4.69223975, 2.616225], [2.6322786000000002, 4.10901025, 2.616225], [2.6534214, 1.7584897499999996, 0.872075]],
                "lattice_vectors": [[5.2857, 0.0, 0.0], [0.0, 5.8675, 0.0], [0.0, 0.0, 3.4883]]
            },
            {
                "Notes": "$\\kappa$&ndash;alumina (Al<sub>2</sub>O<sub>3</sub>) Structure",
                "Pearsons Symbol": "oP40",
                "Prototype": "Al2O3",
                "Space Group Number": 33,
                "Space Group Symbol": "$Pna2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B3_oP40_33_4a_6a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_oP40_33_4a_6a.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[3.28741919, 7.010528, 0.0], [1.5562808100000003, 1.319472, 4.47735], [3.97813081, 2.845528000000001, 4.47735], [0.8655691900000004, 5.484472, 0.0], [0.8941470199999999, 2.8588560000000003, 7.045557960000001], [3.94955298, 5.471144000000001, 2.5682079599999996], [1.5277029800000002, 7.023855999999999, 2.5682079599999996], [3.31599702, 1.306144, 7.045557960000001], [3.93066255, 5.405337, 6.2432168400000005], [0.91303745, 2.924663, 1.7658668400000006], [3.33488745, 1.2403370000000002, 1.7658668400000006], [1.5088125500000005, 7.089663, 6.2432168400000005], [3.23413849, 3.9117680000000004, 8.948431710000001], [1.6095615100000003, 4.418232, 4.471081709999999], [4.03141151, 8.076768, 4.471081709999999], [0.8122884899999998, 0.25323199999999985, 8.948431710000001], [1.5935773000000002, 6.924729, 7.993860690000001], [3.2501227000000004, 1.4052709999999997, 3.516510690000001], [0.8282727, 2.7597290000000014, 3.516510690000001], [4.0154273, 5.570271, 7.993860690000001], [0.12012376, 4.088364, 5.63429724], [4.72357624, 4.241636, 1.15694724], [2.3017262400000003, 8.253364, 1.15694724], [2.5419737600000003, 0.07663599999999988, 5.63429724], [2.28477329, 5.536950999999999, 5.713994070000001], [2.55892671, 2.7930490000000003, 1.2366440700000012], [0.13707670999999996, 1.3719509999999988, 1.2366440700000012], [4.7066232900000005, 6.958049000000001, 5.713994070000001], [2.4920836499999997, 5.604424, 1.0853096400000002], [2.3516163500000005, 2.725576, 5.562659640000001], [4.7734663500000005, 1.4394240000000005, 5.562659640000001], [0.0702336499999998, 6.890576, 1.0853096400000002], [4.16945696, 2.749733, 7.7565611400000005], [0.67424304, 5.580266999999999, 3.279211140000001], [3.09609304, 6.914733000000001, 3.279211140000001], [1.7476069600000002, 1.415267, 7.7565611400000005], [1.6274832000000001, 4.158336, 8.059230000000001], [3.2162167999999998, 4.171664, 3.5818799999999995], [0.7943667999999999, 8.323336, 3.5818799999999995], [4.0493332, 0.006664000000000191, 8.059230000000001]],
                "lattice_vectors": [[4.8437, 0.0, 0.0], [0.0, 8.33, 0.0], [0.0, 0.0, 8.9547]],
                "normalized_wyckoff_matid": {"a": {"X_0": 3, "X_1": 2}}
            }
        ],
        34: [
            {
                "Notes": "FeSb<sub>2</sub> Structure",
                "Pearsons Symbol": "oP6",
                "Prototype": "FeSb2",
                "Space Group Number": 34,
                "Space Group Symbol": "$Pnn2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_oP6_34_a_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_oP6_34_a_c.html",
                "atom_labels": ["Fe", "Fe", "Sb", "Sb", "Sb", "Sb"],
                "atom_positions": [[0.0, 0.0, 1.598645259], [2.9163913511, 3.268790306, 0.0], [4.013537777383821, 5.599437794178001, 0.031013718024600002], [1.8192449248161797, 0.9381428178219998, 0.031013718024600002], [4.73563627591618, 2.330647488178, 1.6296589770246002], [1.0971464262838198, 4.206933123822, 1.6296589770246002]],
                "lattice_vectors": [[5.8327827022, 0.0, 0.0], [0.0, 6.537580612, 0.0], [0.0, 0.0, 3.197290518]]
            },
            {
                "Notes": "TiAl<sub>2</sub>Br<sub>8</sub> Structure",
                "Pearsons Symbol": "oP22",
                "Prototype": "Al2Br8Ti",
                "Space Group Number": 34,
                "Space Group Symbol": "$Pnn2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B8C_oP22_34_c_4c_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B8C_oP22_34_c_4c_a.html",
                "atom_labels": ["Ti", "Ti", "Al", "Al", "Al", "Al", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br"],
                "atom_positions": [[0.0, 0.0, 4.3380006217], [3.13700044955, 6.40050091725, 0.0], [3.7957705439555, 10.41361499236575, 4.3293246204566], [2.4782303551445, 2.3873868421342497, 4.3293246204566], [5.6152308046945, 4.013114075115748, 8.6673252421566], [0.6587700944054998, 8.78788775938425, 8.6673252421566], [4.61076326074859, 8.699560846726198, 0.07808401119059999], [1.66323763835141, 4.1014409877738, 0.07808401119059999], [4.80023808790141, 2.2990599294761997, 4.4160846328906], [1.4737628111985905, 10.5019419050238, 4.4160846328906], [4.6615826680313, 11.61690916480875, 2.65832678097776], [1.6124182310687, 1.18409266969125, 2.65832678097776], [4.7494186806186995, 5.216408247558749, 6.99632740267776], [1.5245822184812992, 7.58459358694125, 6.99632740267776], [1.49823141470508, 7.5973945887757495, 1.90524987305064], [4.77576948439492, 5.20360724572425, 1.90524987305064], [1.63876903484492, 1.1968936715257517, 6.24325049475064], [4.63523186425508, 11.60410816297425, 6.24325049475064], [4.47399004114821, 8.26816708490355, 4.4507886378642], [1.8000108579517902, 4.532834749596449, 4.4507886378642], [4.93701130750179, 1.8676661676535518, 0.11278801616419913], [1.336989591598209, 10.93333566684645, 0.11278801616419913]],
                "lattice_vectors": [[6.2740008991, 0.0, 0.0], [0.0, 12.8010018345, 0.0], [0.0, 0.0, 8.6760012434]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "c": {"X_0": 8, "X_1": 2}}
            }
        ],
        35: [
            {
                "Notes": "V<sub>2</sub>MoO<sub>8</sub> Structure",
                "Pearsons Symbol": "oC22",
                "Prototype": "MoO8V2",
                "Space Group Number": 35,
                "Space Group Symbol": "$Cmm2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB8C2_oC22_35_a_ab3e_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB8C2_oC22_35_a_ab3e_e.html",
                "atom_labels": ["Mo", "Mo", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "V", "V", "V", "V"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.2673790115, 2.58681638605, 0.0], [0.0, 0.0, 7.21626331337562], [2.2673790115, 2.58681638605, 7.21626331337562], [0.0, 2.58681638605, 11.8416927958442], [2.2673790115, 0.0, 11.8416927958442], [0.0, 0.9778165939269001, 6.750259327568391], [0.0, 4.1958161781731, 6.750259327568391], [2.2673790115, 3.5646329799769005, 6.750259327568391], [2.2673790115, 1.6089997921231, 6.750259327568391], [0.0, 0.4971861093988101, 1.5080235084478], [0.0, 4.67644666270119, 1.5080235084478], [2.2673790115, 3.08400249544881, 1.5080235084478], [2.2673790115, 2.08963027665119, 1.5080235084478], [0.0, 1.5427772926402201, 1.72928269534301], [0.0, 3.6308554794597803, 1.72928269534301], [2.2673790115, 4.12959367869022, 1.72928269534301], [2.2673790115, 1.04403909340978, 1.72928269534301], [0.0, 0.9653998752738601, 0.04697122403362], [0.0, 4.20823289682614, 0.04697122403362], [2.2673790115, 3.5522162613238604, 0.04697122403362], [2.2673790115, 1.6214165107761402, 0.04697122403362]],
                "lattice_vectors": [[4.534758023, 0.0, 0.0], [0.0, 5.1736327721, 0.0], [0.0, 0.0, 12.3608484299]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_2": 1}, "b": {"X_0": 1}, "e": {"X_0": 6, "X_1": 2}}
            }
        ],
        36: [
            {
                "Notes": "HgBr<sub>2</sub> (C24) Structure",
                "Pearsons Symbol": "oC12",
                "Prototype": "Br2Hg",
                "Space Group Number": 36,
                "Space Group Symbol": "$Cmc2_{1}$",
                "Strukturbericht Designation": "$C24$",
                "aflow_prototype_id": "A2B_oC12_36_2a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oC12_36_2a_a.html",
                "atom_labels": ["Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Hg", "Hg", "Hg", "Hg"],
                "atom_positions": [[0.0, 2.260737, 0.0], [0.0, 4.528263, 6.2225], [2.312, 5.655237, 0.0], [2.312, 1.1337629999999999, 6.2225], [0.0, 0.41412899999999997, 1.6676300000000002], [0.0, 6.374871, 7.89013], [2.312, 3.8086289999999994, 1.6676300000000002], [2.312, 2.980371, 7.89013], [0.0, 2.681655, 4.55487], [0.0, 4.107345, 10.77737], [2.312, 6.076155, 4.55487], [2.312, 0.7128449999999998, 10.77737]],
                "lattice_vectors": [[4.624, 0.0, 0.0], [0.0, 6.789, 0.0], [0.0, 0.0, 12.445]],
                "normalized_wyckoff_matid": {"a": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "HCl Structure",
                "Pearsons Symbol": "oC8",
                "Prototype": "ClH",
                "Space Group Number": 36,
                "Space Group Symbol": "$Cmc2_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_oC8_36_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oC8_36_a_a.html",
                "atom_labels": ["Cl", "Cl", "Cl", "Cl", "H", "H", "H", "H"],
                "atom_positions": [[0.0, 1.376325, 0.0], [0.0, 4.1289750000000005, 2.6865], [2.9125, 4.1289750000000005, 0.0], [2.9125, 1.376325, 2.6865], [0.0, 0.44592930000000003, 4.45959], [0.0, 5.0593707000000006, 1.7730900000000005], [2.9125, 3.1985793, 4.45959], [2.9125, 2.3067207, 1.7730900000000005]],
                "lattice_vectors": [[5.825, 0.0, 0.0], [0.0, 5.5053, 0.0], [0.0, 0.0, 5.373]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}}
            }
        ],
        37: [
            {
                "Notes": "Li<sub>2</sub>Si<sub>2</sub>O<sub>5</sub> Structure",
                "Pearsons Symbol": "oC36",
                "Prototype": "Li2O5Si2",
                "Space Group Number": 37,
                "Space Group Symbol": "$Ccc2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B5C2_oC36_37_d_c2d_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B5C2_oC36_37_d_c2d_d.html",
                "atom_labels": ["O", "O", "O", "O", "Li", "Li", "Li", "Li", "Li", "Li", "Li", "Li", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[1.451790063625, 3.645600604025, 0.0], [4.355370190875, 10.936801812075, 0.0], [4.355370190875, 3.645600604025, 2.3865658597], [1.451790063625, 10.936801812075, 2.3865658597], [3.7978828064430004, 0.85161230110024, 0.22385987763986], [2.009277448057, 13.73079011499976, 0.22385987763986], [2.009277448057, 0.85161230110024, 2.61042573733986], [3.7978828064430004, 13.73079011499976, 2.61042573733986], [0.8943026791929996, 8.14281350915024, 0.22385987763986], [4.912857575307, 6.43958890694976, 0.22385987763986], [4.912857575307, 8.14281350915024, 2.61042573733986], [0.8943026791929996, 6.43958890694976, 2.61042573733986], [3.89370095064225, 1.04701649347598, 2.2481450398374], [1.91345930385775, 13.535385922624021, 2.2481450398374], [1.91345930385775, 1.04701649347598, 4.6347108995374], [3.89370095064225, 13.535385922624021, 4.6347108995374], [0.9901208233922506, 8.33821770152598, 2.2481450398374], [4.817039431107751, 6.244184714574021, 2.2481450398374], [4.817039431107751, 8.33821770152598, 4.6347108995374], [0.9901208233922506, 6.244184714574021, 4.6347108995374], [0.5412273357194001, 2.00799681269697, 1.91116194044776], [5.2659329187806, 12.574405603403031, 1.91116194044776], [5.2659329187806, 2.00799681269697, 4.29772780014776], [0.5412273357194001, 12.574405603403031, 4.29772780014776], [3.4448074629693997, 9.299198020746969, 1.91116194044776], [2.3623527915306, 5.283204395353031, 1.91116194044776], [2.3623527915306, 9.299198020746969, 4.29772780014776], [3.4448074629693997, 5.283204395353031, 4.29772780014776], [0.9012712714984, 2.163445222452596, 0.27254582117774], [4.9058889830016, 12.418957193647405, 0.27254582117774], [4.9058889830016, 2.163445222452596, 2.65911168087774], [0.9012712714984, 12.418957193647405, 2.65911168087774], [3.8048513987484003, 9.454646430502597, 0.27254582117774], [2.0023088557516, 5.127755985597404, 0.27254582117774], [2.0023088557516, 9.454646430502597, 2.65911168087774], [3.8048513987484003, 5.127755985597404, 2.65911168087774]],
                "lattice_vectors": [[5.8071602545, 0.0, 0.0], [0.0, 14.5824024161, 0.0], [0.0, 0.0, 4.7731317194]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "d": {"X_0": 4, "X_1": 2, "X_2": 2}}
            }
        ],
        38: [
            {
                "Notes": "C<sub>2</sub>CeNi Structure",
                "Pearsons Symbol": "oC8",
                "Prototype": "C2CeNi",
                "Space Group Number": 38,
                "Space Group Symbol": "$Amm2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BC_oC8_38_e_a_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC_oC8_38_e_a_b.html",
                "atom_labels": ["Ce", "Ce", "Ni", "Ni", "C", "C", "C", "C"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 2.276, 3.081], [1.9375, 0.0, 3.7859327999999994], [1.9375, 2.276, 0.704932799999999], [1.9375, 0.70556, 1.7956067999999998], [1.9375, 3.8464399999999994, 1.7956067999999998], [1.9375, 2.98156, 4.8766068], [1.9375, 1.5704399999999998, 4.8766068]],
                "lattice_vectors": [[3.875, 0.0, 0.0], [0.0, 4.552, 0.0], [0.0, 0.0, 6.162]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "Au<sub>2</sub>V Structure",
                "Pearsons Symbol": "oC12",
                "Prototype": "Au2V",
                "Space Group Number": 38,
                "Space Group Symbol": "$Amm2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_oC12_38_de_ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oC12_38_de_ab.html",
                "atom_labels": ["V", "V", "V", "V", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au"],
                "atom_positions": [[0.0, 0.0, 0.28859999999999997], [0.0, 4.241, 2.6936], [2.342, 0.0, 2.405], [2.342, 4.241, 0.0], [0.0, 1.44194, 2.6936], [0.0, 7.040059999999999, 2.6936], [0.0, 5.68294, 0.28860000000000025], [0.0, 2.7990599999999994, 0.28860000000000025], [2.342, 1.44194, 0.0], [2.342, 7.040059999999999, 0.0], [2.342, 5.68294, 2.405], [2.342, 2.7990599999999994, 2.405]],
                "lattice_vectors": [[4.684, 0.0, 0.0], [0.0, 8.482, 0.0], [0.0, 0.0, 4.81]]
            }
        ],
        39: [
            {
                "Notes": "VPCl<sub>9</sub> Structure",
                "Pearsons Symbol": "oC44",
                "Prototype": "Cl9PV",
                "Space Group Number": 39,
                "Space Group Symbol": "$Abm2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A9BC_oC44_39_3c3d_a_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A9BC_oC44_39_3c3d_a_c.html",
                "atom_labels": ["P", "P", "P", "P", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "V", "V", "V", "V", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[0.0, 0.0, 8.154055002], [0.0, 0.0, 0.0], [0.0, 5.90846592675, 0.0], [0.0, 5.90846592675, 8.154055002], [1.66057044346116, 2.954232963375, 12.2196668259972], [4.55181430573884, 8.862698890125, 12.2196668259972], [1.66057044346116, 8.862698890125, 4.065611823997197], [4.55181430573884, 2.954232963375, 4.065611823997197], [3.8367688211059203, 2.954232963375, 14.4799708725516], [2.3756159280940796, 8.862698890125, 14.4799708725516], [3.8367688211059203, 8.862698890125, 6.325915870551602], [2.3756159280940796, 2.954232963375, 6.325915870551602], [3.88025551435032, 2.954232963375, 9.8810838514236], [2.33212923484968, 8.862698890125, 9.8810838514236], [3.88025551435032, 8.862698890125, 1.7270288494236017], [2.33212923484968, 2.954232963375, 1.7270288494236017], [3.8460873982297197, 2.954232963375, 12.1919430389904], [2.3662973509702803, 8.862698890125, 12.1919430389904], [3.8460873982297197, 8.862698890125, 4.037888036990401], [2.3662973509702803, 2.954232963375, 4.037888036990401], [1.40772638416872, 1.01271105984495, 4.0101642499836], [4.80465836503128, 10.80422079365505, 4.0101642499836], [1.40772638416872, 10.80422079365505, 12.1642192519836], [4.80465836503128, 1.01271105984495, 12.1642192519836], [1.40772638416872, 6.92117698659495, 12.1642192519836], [4.80465836503128, 4.89575486690505, 12.1642192519836], [1.40772638416872, 4.89575486690505, 4.0101642499836], [4.80465836503128, 6.92117698659495, 4.0101642499836], [1.11139563163188, 7.009803975496199, 1.0583963392595999], [5.10098911756812, 4.807127878003801, 1.0583963392595999], [1.11139563163188, 4.807127878003801, 9.2124513412596], [5.10098911756812, 7.009803975496199, 9.2124513412596], [1.11139563163188, 1.1013380487461994, 9.2124513412596], [5.10098911756812, 10.7155938047538, 9.2124513412596], [1.11139563163188, 10.7155938047538, 1.0583963392595999], [5.10098911756812, 1.1013380487461994, 1.0583963392595999], [1.118229254856, 7.0287110664618, 6.9815018927124], [5.094155494344, 4.7882207870382, 6.9815018927124], [1.118229254856, 4.7882207870382, 15.135556894712398], [5.094155494344, 7.0287110664618, 15.135556894712398], [1.118229254856, 1.1202451397117998, 15.135556894712398], [5.094155494344, 10.6966867137882, 15.135556894712398], [1.118229254856, 10.6966867137882, 6.9815018927124], [5.094155494344, 1.1202451397117998, 6.9815018927124]],
                "lattice_vectors": [[6.2123847492, 0.0, 0.0], [0.0, 11.8169318535, 0.0], [0.0, 0.0, 16.308110004]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 3, "X_2": 1}, "d": {"X_0": 6}}
            },
            {
                "Notes": "Ta<sub>3</sub>S<sub>2</sub> Structure",
                "Pearsons Symbol": "oC40",
                "Prototype": "S2Ta3",
                "Space Group Number": 39,
                "Space Group Symbol": "$Abm2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B3_oC40_39_2d_2c2d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_oC40_39_2d_2c2d.html",
                "atom_labels": ["Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta"],
                "atom_positions": [[2.5792691189999997, 4.305505, 2.802555], [4.8990408809999995, 12.916515, 2.802555], [2.5792691189999997, 12.916515, 0.0], [4.8990408809999995, 4.305505, 0.0], [0.043374197999999996, 4.305505, 4.290151194], [7.434935801999999, 12.916515, 4.290151194], [0.043374197999999996, 12.916515, 1.4875961940000004], [7.434935801999999, 4.305505, 1.4875961940000004], [1.29374763, 9.296446395999999, 2.179827279], [6.184562369999999, 7.925573604000001, 2.179827279], [1.29374763, 7.925573604000001, 4.982382279], [6.184562369999999, 9.296446395999999, 4.982382279], [1.29374763, 0.6854363960000011, 4.982382279], [6.184562369999999, 16.536583604, 4.982382279], [1.29374763, 16.536583604, 2.179827279], [6.184562369999999, 0.6854363960000011, 2.179827279], [4.369576533, 10.598431108, 2.195521587], [3.1087334669999995, 6.623588892000001, 2.195521587], [4.369576533, 6.623588892000001, 4.998076587], [3.1087334669999995, 10.598431108, 4.998076587], [4.369576533, 1.987421107999999, 4.998076587], [3.1087334669999995, 15.234598892000001, 4.998076587], [4.369576533, 15.234598892000001, 2.195521587], [3.1087334669999995, 1.987421107999999, 2.195521587], [2.1017042424, 2.8621275038, 0.115465266], [5.3766057576, 14.359892496199999, 0.115465266], [2.1017042424, 14.359892496199999, 2.9180202659999996], [5.3766057576, 2.8621275038, 2.9180202659999996], [2.1017042424, 11.473137503800002, 2.9180202659999996], [5.3766057576, 5.7488824962, 2.9180202659999996], [2.1017042424, 5.7488824962, 0.115465266], [5.3766057576, 11.473137503800002, 0.115465266], [0.7818573105, 10.458932746, 0.08071358399999999], [6.696452689499999, 6.763087254000001, 0.08071358399999999], [0.7818573105, 6.763087254000001, 2.8832685839999996], [6.696452689499999, 10.458932746, 2.8832685839999996], [0.7818573105, 1.8479227459999992, 2.8832685839999996], [6.696452689499999, 15.374097254, 2.8832685839999996], [0.7818573105, 15.374097254, 0.08071358399999999], [6.696452689499999, 1.8479227459999992, 0.08071358399999999]],
                "lattice_vectors": [[7.47831, 0.0, 0.0], [0.0, 17.22202, 0.0], [0.0, 0.0, 5.60511]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "d": {"X_0": 2, "X_1": 2}}
            }
        ],
        40: [
            {
                "Notes": "K<sub>2</sub>CdPb Structure",
                "Pearsons Symbol": "oC16",
                "Prototype": "CdK2Pb",
                "Space Group Number": 40,
                "Space Group Symbol": "$Ama2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2C_oC16_40_a_2b_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2C_oC16_40_a_2b_b.html",
                "atom_labels": ["Cd", "Cd", "Cd", "Cd", "K", "K", "K", "K", "K", "K", "K", "K", "Pb", "Pb", "Pb", "Pb"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.22900168235, 0.0, 0.0], [0.0, 4.3010022409, 5.47750285385], [3.22900168235, 4.3010022409, 5.47750285385], [1.614500841175, 2.98231495384006, 1.94232251197521], [4.843502523525, 5.61968952795994, 1.94232251197521], [1.614500841175, 7.28331719474006, 7.4198253658252105], [4.843502523525, 1.31868728705994, 7.4198253658252105], [1.614500841175, 7.45019608168698, 3.61624738411177], [4.843502523525, 1.1518084001130202, 3.61624738411177], [1.614500841175, 3.149193840786979, 9.093750237961771], [4.843502523525, 5.45281064101302, 9.093750237961771], [1.614500841175, 6.26311946319858, 0.10188155308161], [4.843502523525, 2.3388850186014203, 0.10188155308161], [1.614500841175, 1.9621172222985797, 5.579384406931609], [4.843502523525, 6.63988725950142, 5.579384406931609]],
                "lattice_vectors": [[6.4580033647, 0.0, 0.0], [0.0, 8.6020044818, 0.0], [0.0, 0.0, 10.9550057077]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_0": 2, "X_2": 1}}
            },
            {
                "Notes": "CeTe<sub>3</sub> Structure",
                "Pearsons Symbol": "oC16",
                "Prototype": "CeTe3",
                "Space Group Number": 40,
                "Space Group Symbol": "$Ama2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_oC16_40_b_3b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_oC16_40_b_3b.html",
                "atom_labels": ["Ce", "Ce", "Ce", "Ce", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te"],
                "atom_positions": [[1.096250559025, 21.58665318864842, 0.0], [3.288751677075, 4.387252391551582, 0.0], [1.096250559025, 8.599700398548421, 2.18665098165], [3.288751677075, 17.374205181651583, 2.18665098165], [1.096250559025, 18.290045092409432, 0.00918393412293], [3.288751677075, 7.683860487790567, 0.00918393412293], [1.096250559025, 5.303092302309433, 2.19583491577293], [3.288751677075, 20.670813277890566, 2.19583491577293], [1.096250559025, 14.797593748095743, 2.17178175497478], [3.288751677075, 11.176311832104258, 2.17178175497478], [1.096250559025, 1.810640957995746, 4.35843273662478], [3.288751677075, 24.163264622204256, 4.35843273662478], [1.096250559025, 24.155212711474398, 2.1770297173307402], [3.288751677075, 1.818692868725604, 2.1770297173307402], [1.096250559025, 11.168259921374396, 4.36368069898074], [3.288751677075, 14.805645658825604, 4.36368069898074]],
                "lattice_vectors": [[4.3850022361, 0.0, 0.0], [0.0, 25.9739055802, 0.0], [0.0, 0.0, 4.3733019633]]
            }
        ],
        41: [
            {
                "Notes": "PtSn<sub>4</sub> Structure",
                "Pearsons Symbol": "oC20",
                "Prototype": "PtSn4",
                "Space Group Number": 41,
                "Space Group Symbol": "$Aba2$",
                "Strukturbericht Designation": "$D1_{c}$",
                "aflow_prototype_id": "AB4_oC20_41_a_2b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4_oC20_41_a_2b.html",
                "atom_labels": ["Pt", "Pt", "Pt", "Pt", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.194, 0.0, 5.6785], [0.0, 3.2095, 5.6785], [3.194, 3.2095, 0.0], [4.299124, 2.099013, 4.270232], [2.0888759999999995, 4.319987, 4.270232], [1.1051240000000002, 4.319987, 9.948732], [5.282876, 2.099013, 9.948732], [4.299124, 5.308513, 9.948732], [2.0888759999999995, 1.1104869999999998, 9.948732], [1.1051240000000002, 1.1104869999999998, 4.270232], [5.282876, 5.308513, 4.270232], [5.282876, 4.319987, 1.419625], [1.1051240000000002, 2.099013, 1.419625], [2.0888759999999995, 2.099013, 7.098125], [4.299124, 4.319987, 7.098125], [5.282876, 1.1104870000000002, 7.098125], [1.1051240000000002, 5.308513, 7.098125], [2.0888759999999995, 5.308513, 1.419625], [4.299124, 1.1104870000000002, 1.419625]],
                "lattice_vectors": [[6.388, 0.0, 0.0], [0.0, 6.419, 0.0], [0.0, 0.0, 11.357]]
            },
            {
                "Notes": "PdSn<sub>2</sub> (C<sub>e</sub>) Structure",
                "Pearsons Symbol": "oC24",
                "Prototype": "PdSn2",
                "Space Group Number": 41,
                "Space Group Symbol": "$Aba2$",
                "Strukturbericht Designation": "$C_{e}$",
                "aflow_prototype_id": "AB2_oC24_41_2a_2b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_oC24_41_2a_2b.html",
                "atom_labels": ["Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn"],
                "atom_positions": [[0.0, 0.0, 0.12154999999999999], [3.239, 0.0, 6.19905], [0.0, 3.239, 6.19905], [3.239, 3.239, 0.12154999999999999], [0.0, 0.0, 2.8928899999999995], [3.239, 0.0, 8.97039], [0.0, 3.239, 8.97039], [3.239, 3.239, 2.8928899999999995], [2.2154760000000002, 1.0235239999999999, 1.519375], [4.262523999999999, 5.454476, 1.519375], [5.4544760000000005, 5.454476, 7.596875], [1.0235239999999999, 1.0235239999999999, 7.596875], [2.2154760000000002, 4.262524, 7.596875], [4.262523999999999, 2.215476, 7.596875], [5.4544760000000005, 2.215476, 1.519375], [1.0235239999999999, 4.262524, 1.519375], [1.6195, 1.6195, 10.635625], [4.858499999999999, 4.858499999999999, 10.635625], [4.858499999999999, 4.858499999999999, 4.5581249999999995], [1.6195, 1.6195, 4.5581249999999995], [1.6195, 4.858499999999999, 4.5581249999999995], [4.858499999999999, 1.6195, 4.5581249999999995], [4.858499999999999, 1.6195, 10.635625], [1.6195, 4.858499999999999, 10.635625]],
                "lattice_vectors": [[6.478, 0.0, 0.0], [0.0, 6.478, 0.0], [0.0, 0.0, 12.155]]
            }
        ],
        42: [
            {
                "Notes": "W<sub>3</sub>O<sub>10</sub> Structure",
                "Pearsons Symbol": "oF52",
                "Prototype": "O10W3",
                "Space Group Number": 42,
                "Space Group Symbol": "$Fmm2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A10B3_oF52_42_2abce_ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A10B3_oF52_42_2abce_ab.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "W", "W", "W", "W", "O", "O", "O", "O", "O", "O", "O", "O", "W", "W", "W", "W", "W", "W", "W", "W", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 5.92703229352], [0.0, 6.333428558, 2.02766894252], [3.72474232865, 0.0, 2.02766894252], [3.72474232865, 6.333428558, 5.92703229352], [0.0, 0.0, 2.10565620954], [0.0, 6.333428558, 6.00501956054], [3.72474232865, 0.0, 6.00501956054], [3.72474232865, 6.333428558, 2.10565620954], [0.0, 0.0, 0.0], [0.0, 6.333428558, 3.899363351], [3.72474232865, 0.0, 3.899363351], [3.72474232865, 6.333428558, 0.0], [1.862371164325, 3.166714279, 2.41760527762], [5.587113492975, 9.500142836999999, 2.41760527762], [5.587113492975, 3.166714279, 2.41760527762], [1.862371164325, 9.500142836999999, 2.41760527762], [1.862371164325, 9.500142836999999, 6.316968628620001], [5.587113492975, 3.166714279, 6.316968628620001], [5.587113492975, 9.500142836999999, 6.316968628620001], [1.862371164325, 3.166714279, 6.316968628620001], [1.862371164325, 3.166714279, 0.46792360211999995], [5.587113492975, 9.500142836999999, 0.46792360211999995], [5.587113492975, 3.166714279, 0.46792360211999995], [1.862371164325, 9.500142836999999, 0.46792360211999995], [1.862371164325, 9.500142836999999, 4.367286953120001], [5.587113492975, 3.166714279, 4.367286953120001], [5.587113492975, 9.500142836999999, 4.367286953120001], [1.862371164325, 3.166714279, 4.367286953120001], [0.0, 10.00681712164, 4.6792360211999995], [0.0, 2.6600399943599995, 4.6792360211999995], [0.0, 3.67338856364, 0.7798726702000006], [0.0, 8.99346855236, 0.7798726702000006], [3.72474232865, 10.00681712164, 0.7798726702000006], [3.72474232865, 2.6600399943599995, 0.7798726702000006], [3.72474232865, 3.67338856364, 4.6792360211999995], [3.72474232865, 8.99346855236, 4.6792360211999995], [1.2664123917410002, 1.3933542827599998, 0.5459108691400001], [6.183072265559, 11.27350283324, 0.5459108691400001], [6.183072265559, 1.3933542827599998, 0.5459108691400001], [1.2664123917410002, 11.27350283324, 0.5459108691400001], [1.2664123917410002, 7.726782840759999, 4.44527422014], [6.183072265559, 4.94007427524, 4.44527422014], [6.183072265559, 7.726782840759999, 4.44527422014], [1.2664123917410002, 4.94007427524, 4.44527422014], [4.991154720391, 1.3933542827599998, 4.44527422014], [2.4583299369089997, 11.27350283324, 4.44527422014], [2.4583299369089997, 1.3933542827599998, 4.44527422014], [4.991154720391, 11.27350283324, 4.44527422014], [4.991154720391, 7.726782840759999, 0.5459108691400001], [2.4583299369089997, 4.94007427524, 0.5459108691400001], [2.4583299369089997, 7.726782840759999, 0.5459108691400001], [4.991154720391, 4.94007427524, 0.5459108691400001]],
                "lattice_vectors": [[7.4494846573, 0.0, 0.0], [0.0, 12.666857116, 0.0], [0.0, 0.0, 7.798726702]],
                "normalized_wyckoff_matid": {"a": {"X_0": 2, "X_1": 1}, "b": {"X_0": 2, "X_1": 2}, "c": {"X_0": 2}, "e": {"X_0": 4}}
            },
            {
                "Notes": "BN (High&ndash;pressure, high&ndash;temperature) Structure",
                "Pearsons Symbol": "oF8",
                "Prototype": "BN",
                "Space Group Number": 42,
                "Space Group Symbol": "$Fmm2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_oF8_42_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oF8_42_a_a.html",
                "atom_labels": ["B", "B", "B", "B", "N", "N", "N", "N"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 1.67503840155, 2.1700497501], [1.2500286579, 0.0, 2.1700497501], [1.2500286579, 1.67503840155, 0.0], [0.0, 0.0, 1.4452531335666001], [0.0, 1.67503840155, 3.6153028836665997], [1.2500286579, 0.0, 3.6153028836665997], [1.2500286579, 1.67503840155, 1.4452531335666001]],
                "lattice_vectors": [[2.5000573158, 0.0, 0.0], [0.0, 3.3500768031, 0.0], [0.0, 0.0, 4.3400995002]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}}
            }
        ],
        43: [
            {
                "Notes": "GeS<sub>2</sub> (C44) Structure",
                "Pearsons Symbol": "oF72",
                "Prototype": "GeS2",
                "Space Group Number": 43,
                "Space Group Symbol": "$Fdd2$",
                "Strukturbericht Designation": "$C44$",
                "aflow_prototype_id": "AB2_oF72_43_ab_3b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_oF72_43_ab_3b.html",
                "atom_labels": ["Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.915, 5.585, 1.715], [0.0, 11.17, 3.43], [2.915, 16.755, 5.1450000000000005], [5.83, 0.0, 3.43], [8.745000000000001, 5.585, 5.1450000000000005], [5.83, 11.17, 0.0], [8.745000000000001, 16.755, 1.715], [1.4575, 3.1028026000000004, 0.0], [10.2025, 19.2371974, 0.0], [1.4575, 8.6878026, 1.715], [4.3725000000000005, 2.4821973999999996, 1.715], [1.4575, 14.272802599999999, 3.43], [10.2025, 8.0671974, 3.43], [1.4575, 19.8578026, 5.1450000000000005], [4.3725000000000005, 13.6521974, 5.1450000000000005], [7.2875, 3.1028026000000004, 3.43], [4.3725000000000005, 19.2371974, 3.43], [7.2875, 8.6878026, 5.1450000000000005], [10.2025, 2.4821973999999996, 5.1450000000000005], [7.2875, 14.272802599999999, 0.0], [4.3725000000000005, 8.0671974, 0.0], [7.2875, 19.8578026, 1.715], [10.2025, 13.6521974, 1.715], [0.2590852, 1.7997104000000002, 1.2576438], [11.4009148, 20.5402896, 1.2576438], [2.6559148, 7.3847104, 2.9726438], [3.1740852000000004, 3.7852895999999996, 2.9726438], [0.2590852, 12.969710399999999, 4.6876438], [11.4009148, 9.3702896, 4.6876438], [2.6559148, 18.554710399999998, 6.4026438], [3.1740852000000004, 14.9552896, 6.4026438], [6.0890852, 1.7997104000000002, 4.6876438], [5.5709148, 20.5402896, 4.6876438], [8.4859148, 7.3847104, 6.4026438], [9.0040852, 3.7852895999999996, 6.4026438], [6.0890852, 12.969710399999999, 1.2576438], [5.5709148, 9.3702896, 1.2576438], [8.4859148, 18.554710399999998, 2.9726438], [9.0040852, 14.9552896, 2.9726438], [1.7814148, 22.0296974, 5.6023562], [9.8785852, 0.3103026, 5.6023562], [1.1335852, 5.2746974, 0.45735620000000005], [4.6964148, 5.8953026, 0.45735620000000005], [1.7814148, 10.8596974, 2.1723562000000003], [9.8785852, 11.480302599999998, 2.1723562000000003], [1.1335852, 16.444697400000003, 3.8873562], [4.6964148, 17.0653026, 3.8873562], [7.6114148, 22.0296974, 2.1723562000000003], [4.0485852, 0.3103026, 2.1723562000000003], [6.9635852, 5.2746974, 3.8873562], [10.526414800000001, 5.8953026, 3.8873562], [7.6114148, 10.8596974, 5.6023562], [4.0485852, 11.480302599999998, 5.6023562], [6.9635852, 16.444697400000003, 0.45735620000000005], [10.526414800000001, 17.0653026, 0.45735620000000005], [0.72875, 2.7925, 1.9055708000000002], [10.93125, 19.5475, 1.9055708000000002], [2.1862500000000002, 8.3775, 3.6205708000000003], [3.64375, 2.7925, 3.6205708000000003], [0.72875, 13.9625, 5.3355708], [10.93125, 8.3775, 5.3355708], [2.1862500000000002, 19.5475, 0.19057079999999943], [3.64375, 13.9625, 0.19057079999999943], [6.55875, 2.7925, 5.3355708], [5.10125, 19.5475, 5.3355708], [8.01625, 8.3775, 0.19057079999999943], [9.47375, 2.7925, 0.19057079999999943], [6.55875, 13.9625, 1.9055708000000002], [5.10125, 8.3775, 1.9055708000000002], [8.01625, 19.5475, 3.6205708000000003], [9.47375, 13.9625, 3.6205708000000003]],
                "lattice_vectors": [[11.66, 0.0, 0.0], [0.0, 22.34, 0.0], [0.0, 0.0, 6.86]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_0": 6, "X_1": 2}}
            }
        ],
        44: [
            {
                "Notes": "High&ndash;pressure GaAs Structure",
                "Pearsons Symbol": "oI4",
                "Prototype": "AsGa",
                "Space Group Number": 44,
                "Space Group Symbol": "$Imm2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_oI4_44_a_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oI4_44_a_b.html",
                "atom_labels": ["As", "As", "Ga", "Ga"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.46, 2.395, 1.3175], [0.0, 2.395, 1.119875], [2.46, 0.0, 2.437375]],
                "lattice_vectors": [[4.92, 0.0, 0.0], [0.0, 4.79, 0.0], [0.0, 0.0, 2.635]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}}
            }
        ],
        45: [
            {
                "Notes": "MnGa<sub>2</sub>Sb<sub>2</sub> Structure",
                "Pearsons Symbol": "oI20",
                "Prototype": "Ga2MnSb2",
                "Space Group Number": 45,
                "Space Group Symbol": "$Iba2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BC2_oI20_45_c_b_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC2_oI20_45_c_b_c.html",
                "atom_labels": ["Mn", "Mn", "Mn", "Mn", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb"],
                "atom_positions": [[0.0, 5.8998359095, 1.4644592694], [0.0, 5.8998359095, 4.3933778082], [2.98391700915, 0.0, 4.3933778082], [2.98391700915, 0.0, 1.4644592694], [1.6286219035940697, 7.421993574151, 2.8879136792568], [4.33921211470593, 4.377678244849, 2.8879136792568], [4.33921211470593, 7.421993574151, 5.8168322180568], [1.6286219035940697, 4.377678244849, 5.8168322180568], [4.6125389127440695, 1.522157664651, 5.8168322180568], [1.3552951055559301, 10.277514154349, 5.8168322180568], [1.3552951055559301, 1.522157664651, 2.8879136792568], [4.6125389127440695, 10.277514154349, 2.8879136792568], [1.3702146906016799, 10.1819368126151, 2.7766147747824], [4.59761932769832, 1.6177350063849, 2.7766147747824], [4.59761932769832, 10.1819368126151, 5.7055333135824], [1.3702146906016799, 1.6177350063849, 5.7055333135824], [4.3541316997516795, 4.2821009031151, 5.7055333135824], [1.6137023185483197, 7.5175709158849005, 5.7055333135824], [1.6137023185483197, 4.2821009031151, 2.7766147747824], [4.3541316997516795, 7.5175709158849005, 2.7766147747824]],
                "lattice_vectors": [[5.9678340183, 0.0, 0.0], [0.0, 11.799671819, 0.0], [0.0, 0.0, 5.8578370776]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "c": {"X_0": 2, "X_1": 2}}
            }
        ],
        46: [
            {
                "Notes": "TiFeSi Structure",
                "Pearsons Symbol": "oI36",
                "Prototype": "FeSiTi",
                "Space Group Number": 46,
                "Space Group Symbol": "$Ima2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_oI36_46_ac_bc_3b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_oI36_46_ac_bc_3b.html",
                "atom_labels": ["Fe", "Fe", "Fe", "Fe", "Si", "Si", "Si", "Si", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 1.571735477775], [3.49846767555, 0.0, 1.571735477775], [3.49846767555, 5.414949968, 4.715206433324999], [0.0, 5.414949968, 4.715206433324999], [1.749233837775, 5.6889464363808, 0.03394948631994], [5.2477015133250005, 5.1409534996192, 0.03394948631994], [5.2477015133250005, 0.2739964683808011, 3.1774204418699394], [1.749233837775, 10.555903467619201, 3.1774204418699394], [1.749233837775, 7.8051088838752, 4.844717436693659], [5.2477015133250005, 3.0247910521248, 4.844717436693659], [5.2477015133250005, 2.390158915875199, 1.7012464811436596], [1.749233837775, 8.4397410201248, 1.7012464811436596], [1.749233837775, 10.8071571461344, 5.7695265918164695], [5.2477015133250005, 0.0227427898656, 5.7695265918164695], [5.2477015133250005, 5.3922071781344005, 2.6260556362664698], [1.749233837775, 5.4376927578656, 2.6260556362664698], [1.749233837775, 3.2446380208256, 5.006291843808929], [5.2477015133250005, 7.5852619151744, 5.006291843808929], [5.2477015133250005, 8.6595879888256, 1.8628208882589299], [1.749233837775, 2.1703119471744, 1.8628208882589299], [3.70487726840745, 6.753525600089601, 0.75380433514089], [3.2920580826925505, 4.076374335910399, 0.75380433514089], [6.79052575824255, 6.753525600089601, 0.75380433514089], [0.20640959285745059, 4.076374335910399, 0.75380433514089], [0.20640959285745059, 1.3385756320896016, 3.8972752906908896], [6.79052575824255, 9.4913243039104, 3.8972752906908896], [3.2920580826925505, 1.3385756320896016, 3.8972752906908896], [3.70487726840745, 9.4913243039104, 3.8972752906908896], [0.0419816121066, 3.6009417287200005, 3.1132936343767197], [6.9549537389934, 7.22895820728, 3.1132936343767197], [3.4564860634434003, 3.6009417287200005, 3.1132936343767197], [3.5404492876566, 7.22895820728, 3.1132936343767197], [3.5404492876566, 9.01589169672, 6.2567645899267195], [3.4564860634434003, 1.8140082392799999, 6.2567645899267195], [6.9549537389934, 9.01589169672, 6.2567645899267195], [0.0419816121066, 1.8140082392799999, 6.2567645899267195]],
                "lattice_vectors": [[6.9969353511, 0.0, 0.0], [0.0, 10.829899936, 0.0], [0.0, 0.0, 6.2869419111]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 3, "X_2": 1}, "c": {"X_0": 2, "X_2": 2}}
            }
        ],
        47: [
            {
                "Notes": "1212C [YBa<sub>2</sub>Cu<sub>3</sub>O<sub>7&ndash;x</sub>] High&ndash;T<sub>c</sub> Structure",
                "Pearsons Symbol": "oP13",
                "Prototype": "Ba2Cu3O7–xY",
                "Space Group Number": 47,
                "Space Group Symbol": "$Pmmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B3C7D_oP13_47_t_aq_eqrs_h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3C7D_oP13_47_t_aq_eqrs_h.html",
                "atom_labels": ["Cu", "O", "Y", "Cu", "Cu", "O", "O", "O", "O", "O", "O", "Ba", "Ba"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 1.94165, 0.0], [1.90935, 1.94165, 5.83435], [0.0, 0.0, 4.147055979999999], [0.0, 0.0, 7.52164402], [0.0, 0.0, 1.84248773], [0.0, 0.0, 9.82621227], [0.0, 1.94165, 4.40026677], [0.0, 1.94165, 7.268433229999999], [1.90935, 0.0, 4.42010356], [1.90935, 0.0, 7.248596439999999], [1.90935, 1.94165, 2.152291715], [1.90935, 1.94165, 9.516408284999999]],
                "lattice_vectors": [[3.8187, 0.0, 0.0], [0.0, 3.8833, 0.0], [0.0, 0.0, 11.6687]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "d": {"X_3": 1}, "e": {"X_1": 1}, "q": {"X_0": 2}, "r": {"X_0": 2, "X_1": 2}, "s": {"X_2": 2}, "t": {"X_0": 2}}
            }
        ],
        48: [
            {
                "Notes": "$\\alpha$&ndash;RbPr[MoO<sub>4</sub>]<sub>2</sub> Structure",
                "Pearsons Symbol": "oP24",
                "Prototype": "MoO4]2Pr[Rb",
                "Space Group Number": 48,
                "Space Group Symbol": "$Pnnn$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B8CD_oP24_48_k_2m_d_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B8CD_oP24_48_k_2m_d_b.html",
                "atom_labels": ["Rb", "Rb", "Pr", "Pr", "Mo", "Mo", "Mo", "Mo", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[4.74767674155, 1.58255891385, 2.385088789575], [1.58255891385, 4.74767674155, 7.155266368725], [1.58255891385, 4.74767674155, 2.385088789575], [4.74767674155, 1.58255891385, 7.155266368725], [1.58255891385, 1.58255891385, 4.74918879780174], [1.58255891385, 1.58255891385, 0.020988781348259808], [4.74767674155, 4.74767674155, 4.79116636049826], [4.74767674155, 4.74767674155, 9.51936637695174], [3.5449319670240005, 3.9817182272466, 1.0876004880462], [3.5449319670240005, 5.5136352558534, 3.6825770911038003], [5.950421516076, 3.9817182272466, 3.6825770911038003], [5.950421516076, 5.5136352558534, 1.0876004880462], [2.7853036883759996, 2.3485174281534, 8.452754670253801], [2.7853036883759996, 0.8166003995466, 5.8577780671962], [0.3798141393240003, 2.3485174281534, 5.8577780671962], [0.3798141393240003, 0.8166003995466, 8.452754670253801], [4.0640112907668, 3.5322714957132004, 5.7337534501383], [4.0640112907668, 5.9630819873868, 8.5767792873117], [5.4313421923332, 3.5322714957132004, 8.5767792873117], [5.4313421923332, 5.9630819873868, 5.7337534501383], [2.2662243646332, 2.7979641596867997, 3.8066017081617005], [2.2662243646332, 0.3671536680132003, 0.9635758709882999], [0.8988934630667994, 2.7979641596867997, 0.9635758709882999], [0.8988934630667994, 0.3671536680132003, 3.8066017081617005]],
                "lattice_vectors": [[6.3302356554, 0.0, 0.0], [0.0, 6.3302356554, 0.0], [0.0, 0.0, 9.5403551583]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "c": {"X_3": 1}, "l": {"X_1": 2}, "m": {"X_0": 8}}
            }
        ],
        49: [
            {
                "Notes": "$\\beta$&ndash;Ta<sub>2</sub>O<sub>5</sub> Structure",
                "Pearsons Symbol": "oP14",
                "Prototype": "O5Ta2",
                "Space Group Number": 49,
                "Space Group Symbol": "$Pccm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A5B2_oP14_49_dehq_ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B2_oP14_49_dehq_ab.html",
                "atom_labels": ["Ta", "Ta", "Ta", "Ta", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.9007571459], [1.83526770005, 3.1114969433, 0.0], [1.83526770005, 3.1114969433, 3.9007571459], [1.83526770005, 0.0, 0.0], [1.83526770005, 0.0, 3.9007571459], [0.0, 0.0, 1.95037857295], [0.0, 0.0, 5.85113571885], [1.83526770005, 3.1114969433, 1.95037857295], [1.83526770005, 3.1114969433, 5.85113571885], [0.0073410708002, 4.237858836774601, 0.0], [0.0073410708002, 1.9851350498253997, 3.9007571459], [3.6631943292997997, 4.237858836774601, 3.9007571459], [3.6631943292997997, 1.9851350498253997, 0.0]],
                "lattice_vectors": [[3.6705354001, 0.0, 0.0], [0.0, 6.2229938866, 0.0], [0.0, 0.0, 7.8015142918]]
            },
            {
                "Notes": "CsPr[MoO<sub>4</sub>]<sub>2</sub> Structure",
                "Pearsons Symbol": "oP24",
                "Prototype": "CsMoO4]2Pr[",
                "Space Group Number": 49,
                "Space Group Symbol": "$Pccm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2C8D_oP24_49_g_q_2qr_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2C8D_oP24_49_g_q_2qr_e.html",
                "atom_labels": ["Pr", "Pr", "Cs", "Cs", "Mo", "Mo", "Mo", "Mo", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 2.385088789575], [0.0, 0.0, 7.155266368725], [0.0, 3.1651178277, 2.385088789575], [0.0, 3.1651178277, 7.155266368725], [3.28159416375936, 5.06165643005784, 0.0], [3.28159416375936, 1.2685792253421602, 4.77017757915], [3.04864149164064, 5.06165643005784, 4.77017757915], [3.04864149164064, 1.2685792253421602, 0.0], [1.6332007990932, 5.88901823021862, 0.0], [1.6332007990932, 0.44121742518138, 4.77017757915], [4.6970348563068, 5.88901823021862, 4.77017757915], [4.6970348563068, 0.44121742518138, 0.0], [2.31180206135208, 3.99247962786078, 0.0], [2.31180206135208, 2.33775602753922, 4.77017757915], [4.01843359404792, 3.99247962786078, 4.77017757915], [4.01843359404792, 2.33775602753922, 0.0], [1.65662267101818, 1.22996478784422, 7.90513828416738], [1.65662267101818, 5.10027086755578, 6.405394453282621], [4.67361298438182, 1.22996478784422, 6.405394453282621], [4.67361298438182, 5.10027086755578, 7.90513828416738], [4.67361298438182, 5.10027086755578, 1.63521687413262], [4.67361298438182, 1.22996478784422, 3.13496070501738], [1.65662267101818, 5.10027086755578, 3.13496070501738], [1.65662267101818, 1.22996478784422, 1.63521687413262]],
                "lattice_vectors": [[6.3302356554, 0.0, 0.0], [0.0, 6.3302356554, 0.0], [0.0, 0.0, 9.5403551583]],
                "normalized_wyckoff_matid": {"e": {"X_2": 1}, "g": {"X_3": 1}, "q": {"X_0": 4, "X_1": 2}, "r": {"X_0": 4}}
            }
        ],
        50: [
            {
                "Notes": "La<sub>2</sub>NiO<sub>4</sub> Structure",
                "Pearsons Symbol": "oP28",
                "Prototype": "La2NiO4",
                "Space Group Number": 50,
                "Space Group Symbol": "$Pban$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BC4_oP28_50_ij_ac_ijm",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC4_oP28_50_ij_ac_ijm.html",
                "atom_labels": ["Ni", "Ni", "Ni", "Ni", "La", "La", "La", "La", "O", "O", "O", "O", "La", "La", "La", "La", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[1.383701749025, 3.136640622425, 0.0], [4.151105247075, 9.409921867275, 0.0], [4.151105247075, 3.136640622425, 2.7339046662], [1.383701749025, 9.409921867275, 2.7339046662], [1.383701749025, 10.94813042851222, 0.0], [1.383701749025, 7.871713306037779, 0.0], [4.151105247075, 1.5984320611877794, 0.0], [4.151105247075, 4.674849183662221, 0.0], [1.383701749025, 5.5832203079165, 0.0], [1.383701749025, 0.6900609369334999, 0.0], [4.151105247075, 6.963342181783499, 0.0], [4.151105247075, 11.8565015527665, 0.0], [1.383701749025, 4.851755714766989, 2.7339046662], [1.383701749025, 1.42152553008301, 2.7339046662], [4.151105247075, 7.694806774933009, 2.7339046662], [4.151105247075, 11.12503695961699, 2.7339046662], [1.383701749025, 11.5930237404828, 2.7339046662], [1.383701749025, 7.226819994067199, 2.7339046662], [4.151105247075, 0.9535387492171999, 2.7339046662], [4.151105247075, 5.319742495632799, 2.7339046662], [2.76740349805, 9.3220959298471, 1.2357249091224], [2.76740349805, 9.4977478047029, 4.2320844232776], [0.0, 9.3220959298471, 4.2320844232776], [0.0, 9.4977478047029, 1.2357249091224], [2.76740349805, 3.2244665598529, 4.2320844232776], [2.76740349805, 3.0488146849970983, 1.2357249091224], [0.0, 3.2244665598529, 1.2357249091224], [0.0, 3.0488146849970983, 4.2320844232776]],
                "lattice_vectors": [[5.5348069961, 0.0, 0.0], [0.0, 12.5465624897, 0.0], [0.0, 0.0, 5.4678093324]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "c": {"X_2": 1}, "i": {"X_0": 2, "X_1": 2}, "j": {"X_0": 2, "X_1": 2}, "m": {"X_0": 4}}
            },
            {
                "Notes": "$\\alpha$&ndash;Tl<sub>2</sub>TeO<sub>3</sub> Structure",
                "Pearsons Symbol": "oP48",
                "Prototype": "O3TeTl2",
                "Space Group Number": 50,
                "Space Group Symbol": "$Pban$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3BC2_oP48_50_3m_m_2m",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3BC2_oP48_50_3m_m_2m.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl"],
                "atom_positions": [[0.5713432558699499, 13.56987277885696, 1.2475295256955998], [0.5713432558699499, 11.39922580834304, 3.9941911705043998], [4.97567864578005, 13.56987277885696, 3.9941911705043998], [4.97567864578005, 11.39922580834304, 1.2475295256955998], [10.52270054743005, 3.0761929459430393, 3.9941911705043998], [10.52270054743005, 5.246839916456959, 1.2475295256955998], [6.11836515751995, 3.0761929459430393, 1.2475295256955998], [6.11836515751995, 5.246839916456959, 3.9941911705043998], [6.6786143695866, 9.266864788996159, 1.651142019303], [6.6786143695866, 15.70223379820384, 3.590578676897], [9.9624513353634, 9.266864788996159, 3.590578676897], [9.9624513353634, 15.70223379820384, 1.651142019303], [4.4154294337134, 7.379200935803841, 3.590578676897], [4.4154294337134, 0.9438319265961596, 1.651142019303], [1.1315924679365985, 7.379200935803841, 1.651142019303], [1.1315924679365985, 0.9438319265961596, 3.590578676897], [6.7008024571932, 14.06093171773856, 0.6080396007592], [6.7008024571932, 10.90816686946144, 4.6336810954408], [9.9402632477568, 14.06093171773856, 4.6336810954408], [9.9402632477568, 10.90816686946144, 0.6080396007592], [4.3932413461068, 2.58513400706144, 4.6336810954408], [4.3932413461068, 5.73789885533856, 0.6080396007592], [1.153780555543201, 2.58513400706144, 0.6080396007592], [1.153780555543201, 5.73789885533856, 4.6336810954408], [6.799095685290437, 11.030681913195968, 1.22865933118928], [6.799095685290437, 13.938416674004031, 4.01306136501072], [9.841970019659563, 11.030681913195968, 4.01306136501072], [9.841970019659563, 13.938416674004031, 1.22865933118928], [4.294948118009563, 5.6153838116040315, 4.01306136501072], [4.294948118009563, 2.7076490507959683, 1.22865933118928], [1.2520737836404376, 5.6153838116040315, 1.22865933118928], [1.2520737836404376, 2.7076490507959683, 4.01306136501072], [1.327291400626812, 11.126063869799072, 1.29942256058798], [1.327291400626812, 13.843034717400927, 3.94229813561202], [4.2197305010231885, 11.126063869799072, 3.94229813561202], [4.2197305010231885, 13.843034717400927, 1.29942256058798], [9.766752402673188, 5.5200018550009275, 3.94229813561202], [9.766752402673188, 2.8030310073990727, 1.29942256058798], [6.8743133022768115, 5.5200018550009275, 1.29942256058798], [6.8743133022768115, 2.8030310073990727, 3.94229813561202], [7.009549696239039, 0.068581790786176, 1.27845567780318], [7.009549696239039, 8.254451071613824, 3.96326501839682], [9.63151600871096, 0.068581790786176, 3.96326501839682], [9.63151600871096, 8.254451071613824, 1.27845567780318], [4.084494107060961, 16.577483934013824, 3.96326501839682], [4.084494107060961, 8.391614653186176, 1.27845567780318], [1.4625277945890378, 16.577483934013824, 1.27845567780318], [1.4625277945890378, 8.391614653186176, 3.96326501839682]],
                "lattice_vectors": [[11.0940438033, 0.0, 0.0], [0.0, 16.6460657248, 0.0], [0.0, 0.0, 5.2417206962]],
                "normalized_wyckoff_matid": {"m": {"X_0": 3, "X_1": 2, "X_2": 1}}
            }
        ],
        51: [
            {
                "Notes": "$\\beta'$&ndash;AuCd (B19) Structure",
                "Pearsons Symbol": "oP4",
                "Prototype": "AuCd",
                "Space Group Number": 51,
                "Space Group Symbol": "$Pmma$",
                "Strukturbericht Designation": "$B19$",
                "aflow_prototype_id": "AB_oP4_51_e_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oP4_51_e_f.html",
                "atom_labels": ["Au", "Au", "Cd", "Cd"],
                "atom_positions": [[1.188725, 0.0, 3.9443624999999995], [3.5661750000000003, 0.0, 0.9102374999999999], [1.188725, 1.5738, 1.5170624999999998], [3.5661750000000003, 1.5738, 3.3375375]],
                "lattice_vectors": [[4.7549, 0.0, 0.0], [0.0, 3.1476, 0.0], [0.0, 0.0, 4.8546]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1}, "f": {"X_1": 1}}
            }
        ],
        52: [
            {
                "Notes": "Sr<sub>2</sub>Bi<sub>3</sub> Structure",
                "Pearsons Symbol": "oP20",
                "Prototype": "Bi3Sr2",
                "Space Group Number": 52,
                "Space Group Symbol": "$Pnna$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B2_oP20_52_de_cd",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B2_oP20_52_de_cd.html",
                "atom_labels": ["Sr", "Sr", "Sr", "Sr", "Bi", "Bi", "Bi", "Bi", "Sr", "Sr", "Sr", "Sr", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi"],
                "atom_positions": [[3.8958005654, 0.0, 2.9413139244182998], [3.8958005654, 3.38611390705, 0.3784534846316999], [11.6874016962, 0.0, 3.6982208936816994], [11.6874016962, 3.38611390705, 6.2610813334683], [6.69142705113104, 1.693056953525, 1.659883704525], [1.1001740796689599, 5.079170860575, 1.659883704525], [8.89177521046896, 5.079170860575, 4.979651113575], [14.48302818193104, 1.693056953525, 4.979651113575], [0.0015583202261600002, 1.693056953525, 1.659883704525], [7.790042810573841, 5.079170860575, 1.659883704525], [15.58164394137384, 5.079170860575, 4.979651113575], [7.79315945102616, 1.693056953525, 4.979651113575], [10.18985595886024, 0.4334225801024, 0.52319534366628], [10.18985595886024, 2.9526913269476, 2.79657206538372], [13.18494743353976, 3.8195364871524005, 2.79657206538372], [13.18494743353976, 6.3388052339976, 0.52319534366628], [5.39334630273976, 6.3388052339976, 6.11633947443372], [5.39334630273976, 3.8195364871524005, 3.8429627527162795], [2.3982548280602423, 2.9526913269476, 3.8429627527162795], [2.3982548280602423, 0.4334225801024, 6.11633947443372]],
                "lattice_vectors": [[15.5832022616, 0.0, 0.0], [0.0, 6.7722278141, 0.0], [0.0, 0.0, 6.6395348181]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "d": {"X_0": 1, "X_1": 1}, "e": {"X_0": 2}}
            },
            {
                "Notes": "GaCl<sub>2</sub> (High&ndash;temperature) Structure",
                "Pearsons Symbol": "oP24",
                "Prototype": "Cl2Ga",
                "Space Group Number": 52,
                "Space Group Symbol": "$Pnna$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_oP24_52_2e_cd",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP24_52_2e_cd.html",
                "atom_labels": ["Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[1.805875221925, 0.0, 3.0296171223005004], [1.805875221925, 4.8605505973, 1.7414334639995002], [5.417625665775001, 0.0, 6.5124840502995], [5.417625665775001, 4.8605505973, 7.800667708600501], [4.88236424999643, 2.43027529865, 2.38552529315], [5.952887081553571, 7.290825895949999, 2.38552529315], [2.3411366377035705, 7.290825895949999, 7.156575879450001], [1.2706138061464296, 2.43027529865, 7.156575879450001], [5.97455758421667, 1.71285803048852, 5.32067561384176], [5.97455758421667, 3.1476925668114797, 8.992476145058241], [4.860693747333331, 6.5734086277885195, 8.992476145058241], [4.860693747333331, 8.008243164111478, 5.32067561384176], [1.2489433034833304, 8.008243164111478, 4.2214255587582405], [1.2489433034833304, 6.5734086277885195, 0.5496250275417588], [2.3628071403666695, 3.1476925668114797, 0.5496250275417588], [2.3628071403666695, 1.71285803048852, 4.2214255587582405], [3.67892900210561, 0.40731414005373995, 7.7691787747309204], [3.67892900210561, 4.45323645724626, 6.543972984169081], [7.15632232944439, 5.26786473735374, 6.543972984169081], [7.15632232944439, 9.313787054546259, 7.7691787747309204], [3.54457188559439, 9.313787054546259, 1.7729223978690798], [3.54457188559439, 5.26786473735374, 2.9981281884309205], [0.06717855825561063, 4.45323645724626, 2.9981281884309205], [0.06717855825561063, 0.40731414005373995, 1.7729223978690798]],
                "lattice_vectors": [[7.2235008877, 0.0, 0.0], [0.0, 9.7211011946, 0.0], [0.0, 0.0, 9.5421011726]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "d": {"X_1": 1}, "e": {"X_0": 4}}
            }
        ],
        53: [
            {
                "Notes": "CuBrSe<sub>3</sub> Structure",
                "Pearsons Symbol": "oP20",
                "Prototype": "BrCuSe3",
                "Space Group Number": 53,
                "Space Group Symbol": "$Pmna$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC3_oP20_53_e_g_hi",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC3_oP20_53_e_g_hi.html",
                "atom_labels": ["Br", "Br", "Br", "Br", "Cu", "Cu", "Cu", "Cu", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se"],
                "atom_positions": [[9.80423014867652, 0.0, 0.0], [11.74037170162348, 0.0, 3.84801819115], [4.55883775152348, 0.0, 0.0], [2.6226961985765183, 0.0, 3.84801819115], [3.59076697505, 1.28177885948952, 1.924009095575], [3.59076697505, 3.2062423572104795, 5.772027286725], [10.77230092515, 3.2062423572104795, 5.772027286725], [10.77230092515, 1.28177885948952, 1.924009095575], [0.0, 1.55195773673486, 2.0840866523268398], [0.0, 2.93606347996514, 5.61194972997316], [7.1815339501, 1.55195773673486, 1.76393153882316], [7.1815339501, 2.93606347996514, 5.932104843476839], [8.97260851725494, 2.71839445095519, 2.7513330066722497], [8.97260851725494, 1.76962676574481, 4.944703375627751], [12.57199333304506, 2.71839445095519, 1.09668518447775], [12.57199333304506, 1.76962676574481, 6.59935119782225], [5.3904593829450596, 1.76962676574481, 4.944703375627751], [5.3904593829450596, 2.71839445095519, 2.7513330066722497], [1.7910745671549406, 1.76962676574481, 6.59935119782225], [1.7910745671549406, 2.71839445095519, 1.09668518447775]],
                "lattice_vectors": [[14.3630679002, 0.0, 0.0], [0.0, 4.4880212167, 0.0], [0.0, 0.0, 7.6960363823]],
                "normalized_wyckoff_matid": {"e": {"X_1": 1}, "g": {"X_2": 1}, "h": {"X_0": 1}, "i": {"X_0": 2}}
            },
            {
                "Notes": "TaNiTe<sub>2</sub> Structure",
                "Pearsons Symbol": "oP16",
                "Prototype": "NiTaTe2",
                "Space Group Number": 53,
                "Space Group Symbol": "$Pmna$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC2_oP16_53_h_e_gh",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC2_oP16_53_h_e_gh.html",
                "atom_labels": ["Ta", "Ta", "Ta", "Ta", "Te", "Te", "Te", "Te", "Ni", "Ni", "Ni", "Ni", "Te", "Te", "Te", "Te"],
                "atom_positions": [[9.295553842883315, 0.0, 0.0], [8.240138946216684, 0.0, 4.61134464885], [2.3949080165166845, 0.0, 0.0], [3.450322913183315, 0.0, 4.61134464885], [2.92261546485, 1.05313400568791, 2.305672324425], [2.92261546485, 2.2451247030120904, 6.917016973275], [8.767846394549998, 2.2451247030120904, 6.917016973275], [8.767846394549998, 1.05313400568791, 2.305672324425], [0.0, 0.39513139330226005, 3.27313243175373], [0.0, 2.90312731539774, 5.9495568659462705], [5.8452309297, 0.39513139330226005, 1.3382122170962703], [5.8452309297, 2.90312731539774, 7.88447708060373], [0.0, 0.7388099507488001, 6.91056109076661], [0.0, 2.5594487579512, 2.3121282069333904], [5.8452309297, 0.7388099507488001, 6.923472855783391], [5.8452309297, 2.5594487579512, 2.299216441916609]],
                "lattice_vectors": [[11.6904618594, 0.0, 0.0], [0.0, 3.2982587087, 0.0], [0.0, 0.0, 9.2226892977]],
                "normalized_wyckoff_matid": {"e": {"X_1": 1}, "g": {"X_0": 1}, "h": {"X_0": 1, "X_2": 1}}
            }
        ],
        54: [
            {
                "Notes": "BiGaO<sub>3</sub> Structure",
                "Pearsons Symbol": "oP20",
                "Prototype": "BiGaO3",
                "Space Group Number": 54,
                "Space Group Symbol": "$Pcca$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC3_oP20_54_e_d_cf",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC3_oP20_54_e_d_cf.html",
                "atom_labels": ["O", "O", "O", "O", "Ga", "Ga", "Ga", "Ga", "Bi", "Bi", "Bi", "Bi", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 4.43303773438716, 2.42889723105], [2.6733744687, 0.6818090804128398, 2.42889723105], [0.0, 0.6818090804128398, 7.286691693150001], [2.6733744687, 4.43303773438716, 7.286691693150001], [1.33668723435, 0.0, 6.234493412659141], [4.01006170305, 0.0, 8.33888997364086], [4.01006170305, 0.0, 3.4810955115408597], [1.33668723435, 0.0, 1.3766989505591416], [1.33668723435, 2.5574234074, 8.64881726032284], [4.01006170305, 2.5574234074, 5.924566125977161], [4.01006170305, 2.5574234074, 1.06677166387716], [1.33668723435, 2.5574234074, 3.791022798222841], [2.1681066941157003, 1.37384785445528, 5.34648858498726], [4.8414811628157, 3.74099896034472, 9.22689480131274], [3.1786422432843002, 1.37384785445528, 9.22689480131274], [0.5052677745842998, 3.74099896034472, 5.34648858498726], [3.1786422432843002, 3.74099896034472, 4.36910033921274], [0.5052677745842998, 1.37384785445528, 0.4886941228872601], [2.1681066941157003, 3.74099896034472, 0.4886941228872601], [4.8414811628157, 1.37384785445528, 4.36910033921274]],
                "lattice_vectors": [[5.3467489374, 0.0, 0.0], [0.0, 5.1148468148, 0.0], [0.0, 0.0, 9.7155889242]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "d": {"X_1": 1}, "e": {"X_2": 1}, "f": {"X_0": 2}}
            }
        ],
        55: [
            {
                "Notes": "Rh<sub>5</sub>Ge<sub>3</sub> Structure",
                "Pearsons Symbol": "oP16",
                "Prototype": "Ge3Rh5",
                "Space Group Number": 55,
                "Space Group Symbol": "$Pbam$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B5_oP16_55_ch_agh",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B5_oP16_55_ch_agh.html",
                "atom_labels": ["Rh", "Rh", "Ge", "Ge", "Rh", "Rh", "Rh", "Rh", "Ge", "Ge", "Ge", "Ge", "Rh", "Rh", "Rh", "Rh"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.70999908645, 5.1599982606, 0.0], [0.0, 5.1599982606, 0.0], [2.70999908645, 0.0, 0.0], [1.8861593641691998, 2.270399234664, 0.0], [4.5961584506192, 2.8895990259360005, 0.0], [0.8238397222808, 7.430397495264, 0.0], [3.5338388087308, 8.049597286536, 0.0], [0.6070397953648, 1.5686394712223999, 1.97999933255], [3.3170388818148, 3.5913587893776, 1.97999933255], [2.1029592910851997, 6.7286377318224, 1.97999933255], [4.8129583775352, 8.7513570499776, 1.97999933255], [0.921399689393, 4.0557586328316, 1.97999933255], [3.631398775843, 1.1042396277684, 1.97999933255], [1.7885993970569998, 9.2157568934316, 1.97999933255], [4.498598483506999, 6.2642378883684, 1.97999933255]],
                "lattice_vectors": [[5.4199981729, 0.0, 0.0], [0.0, 10.3199965212, 0.0], [0.0, 0.0, 3.9599986651]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 1}, "g": {"X_0": 2}, "h": {"X_0": 2, "X_1": 2}}
            },
            {
                "Notes": "GeAs<sub>2</sub> Structure",
                "Pearsons Symbol": "oP24",
                "Prototype": "As2Ge",
                "Space Group Number": 55,
                "Space Group Symbol": "$Pbam$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_oP24_55_2g2h_gh",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP24_55_2g2h_gh.html",
                "atom_labels": ["As", "As", "As", "As", "As", "As", "As", "As", "Ge", "Ge", "Ge", "Ge", "As", "As", "As", "As", "As", "As", "As", "As", "Ge", "Ge", "Ge", "Ge"],
                "atom_positions": [[0.63804920033408, 5.93648316804828, 0.0], [5.71805875713408, 1.44353071565172, 0.0], [4.441960356465921, 13.31649705174828, 0.0], [9.52196991326592, 8.82354459935172, 0.0], [1.0302259381190402, 1.65017110439532, 0.0], [6.110235494919041, 5.72984277930468, 0.0], [4.04978361868096, 9.03018498809532, 0.0], [9.12979317548096, 13.109856663004681, 0.0], [2.05638786859264, 3.93649940556558, 0.0], [7.136397425392641, 3.44351447813442, 0.0], [3.02362168820736, 11.316513289265579, 0.0], [8.10363124500736, 10.823528361834422, 0.0], [2.2961643196736, 0.5667850662681599, 1.86400350665], [7.3761738764736, 6.81322881743184, 1.86400350665], [2.7838452371264, 7.94679894996816, 1.86400350665], [7.863854793926401, 14.19324270113184, 1.86400350665], [3.5885187509235204, 4.35863619971322, 1.86400350665], [8.66852830772352, 3.02137768398678, 1.86400350665], [1.49149080587648, 11.738650083413221, 1.86400350665], [6.571500362676481, 10.40139156768678, 1.86400350665], [4.25908001242112, 2.03393182634772, 1.86400350665], [9.339089569221121, 5.346082057352279, 1.86400350665], [0.8209295443788799, 9.41394571004772, 1.86400350665], [5.9009391011788805, 12.72609594105228, 1.86400350665]],
                "lattice_vectors": [[10.1600191136, 0.0, 0.0], [0.0, 14.7600277674, 0.0], [0.0, 0.0, 3.7280070133]],
                "normalized_wyckoff_matid": {"g": {"X_0": 2, "X_1": 1}, "h": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "R&ndash;carbon Structure",
                "Pearsons Symbol": "oP16",
                "Prototype": "C",
                "Space Group Number": 55,
                "Space Group Symbol": "$Pbam$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_oP16_55_2g2h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_oP16_55_2g2h.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C"],
                "atom_positions": [[5.24250666, 4.5985176, 0.0], [1.3482066600000002, 2.5642824, 0.0], [6.44039334, 2.2109176, 0.0], [2.5460933399999996, 0.1766824, 0.0], [6.5696841, 3.86170424, 0.0], [2.675384100000001, 3.30109576, 0.0], [5.113215899999999, 1.47410424, 0.0], [1.2189158999999998, 0.9134957600000001, 0.0], [7.43499756, 4.112879759999999, 1.2479], [3.54069756, 3.04992024, 1.2479], [4.24790244, 1.7252797599999998, 1.2479], [0.35360244, 0.6623202400000002, 1.2479], [4.44261744, 4.26234352, 1.2479], [0.5483174400000002, 2.9004564800000003, 1.2479], [7.24028256, 1.874743519999999, 1.2479], [3.34598256, 0.5128564800000003, 1.2479]],
                "lattice_vectors": [[7.7886, 0.0, 0.0], [0.0, 4.7752, 0.0], [0.0, 0.0, 2.4958]],
                "normalized_wyckoff_matid": {"g": {"X_0": 1}, "h": {"X_0": 1}}
            }
        ],
        56: [
            {
                "Notes": "Sb<sub>2</sub>O<sub>3</sub> (D5<sub>11</sub>) Structure",
                "Pearsons Symbol": "oP20",
                "Prototype": "O3Sb2",
                "Space Group Number": 56,
                "Space Group Symbol": "$Pccn$",
                "Strukturbericht Designation": "$D5_{11}$",
                "aflow_prototype_id": "A3B2_oP20_56_ce_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B2_oP20_56_ce_e.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb"],
                "atom_positions": [[1.22775, 3.116, 0.156948], [3.6832499999999997, 9.348, 2.5490519999999997], [3.6832499999999997, 9.348, 5.255052], [1.22775, 3.116, 2.8629480000000003], [0.7219169999999999, 0.7229120000000001, 4.659732], [3.1774169999999997, 11.741088, 3.458268], [4.189082999999999, 6.954912000000001, 3.458268], [1.7335829999999997, 5.509088, 4.659732], [4.189082999999999, 11.741088, 0.752268], [1.7335829999999997, 0.7229120000000001, 1.9537319999999998], [0.7219169999999999, 5.509088, 1.9537319999999998], [3.1774169999999997, 6.954912000000001, 0.752268], [0.21608399999999997, 1.5953920000000001, 0.9687479999999999], [2.671584, 10.868608, 1.737252], [4.694915999999999, 7.827392000000001, 1.737252], [2.239416, 4.636608, 0.9687479999999999], [4.694915999999999, 10.868608, 4.443251999999999], [2.239416, 1.5953920000000001, 3.674748], [0.21608399999999997, 4.636608, 3.674748], [2.671584, 7.827392000000001, 4.443251999999999]],
                "lattice_vectors": [[4.911, 0.0, 0.0], [0.0, 12.464, 0.0], [0.0, 0.0, 5.412]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "e": {"X_0": 2, "X_1": 2}}
            }
        ],
        57: [
            {
                "Notes": "TlF&ndash;II Structure",
                "Pearsons Symbol": "oP8",
                "Prototype": "FTl",
                "Space Group Number": 57,
                "Space Group Symbol": "$Pbcm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_oP8_57_d_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oP8_57_d_d.html",
                "atom_labels": ["F", "F", "F", "F", "Tl", "Tl", "Tl", "Tl"],
                "atom_positions": [[5.237914708, 0.34468407999999995, 1.29575], [5.237914708, 2.39961592, 3.88725], [0.8576452920000003, 3.08898408, 1.29575], [0.8576452920000003, 5.14391592, 3.88725], [1.5543678, 0.05269056, 1.29575], [1.5543678, 2.69160944, 3.88725], [4.5411922, 2.7969905600000002, 1.29575], [4.5411922, 5.43590944, 3.88725]],
                "lattice_vectors": [[6.09556, 0.0, 0.0], [0.0, 5.4886, 0.0], [0.0, 0.0, 5.183]],
                "normalized_wyckoff_matid": {"d": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "KCNS (F5<sub>9</sub>) Structure",
                "Pearsons Symbol": "oP16",
                "Prototype": "CKNS",
                "Space Group Number": 57,
                "Space Group Symbol": "$Pbcm$",
                "Strukturbericht Designation": "$F5_{9}$",
                "aflow_prototype_id": "ABCD_oP16_57_d_c_d_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABCD_oP16_57_d_c_d_d.html",
                "atom_labels": ["K", "K", "K", "K", "C", "C", "C", "C", "N", "N", "N", "N", "S", "S", "S", "S"],
                "atom_positions": [[1.3950559999999999, 1.67275, 0.0], [5.311944, 5.01825, 3.8105], [5.311944, 5.01825, 0.0], [1.3950559999999999, 1.67275, 3.8105], [5.1670728, 1.9209861000000001, 1.90525], [5.1670728, 1.4245138999999998, 5.71575], [1.5399272000000002, 5.2664861, 1.90525], [1.5399272000000002, 4.7700138999999995, 5.71575], [5.962523, 2.7794414, 1.90525], [5.962523, 0.5660586000000001, 5.71575], [0.7444769999999999, 6.1249414, 1.90525], [0.7444769999999999, 3.9115585999999998, 5.71575], [4.057735, 0.7273117, 1.90525], [4.057735, 2.6181883, 5.71575], [2.649265, 4.0728117, 1.90525], [2.649265, 5.963688299999999, 5.71575]],
                "lattice_vectors": [[6.707, 0.0, 0.0], [0.0, 6.691, 0.0], [0.0, 0.0, 7.621]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "d": {"X_1": 1, "X_2": 1, "X_3": 1}}
            }
        ],
        58: [
            {
                "Notes": "$\\eta$&ndash;Fe<sub>2</sub>C Structure",
                "Pearsons Symbol": "oP6",
                "Prototype": "CFe2",
                "Space Group Number": 58,
                "Space Group Symbol": "$Pnnm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_oP6_58_a_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_oP6_58_a_g.eta-Fe2C.html",
                "atom_labels": ["C", "C", "Fe", "Fe", "Fe", "Fe"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.352, 2.159, 1.415], [3.13601568, 1.0795, 0.0], [0.7840156799999993, 1.0795, 1.415], [3.9199843199999997, 3.2384999999999997, 1.415], [1.5679843199999999, 3.2384999999999997, 0.0]],
                "lattice_vectors": [[4.704, 0.0, 0.0], [0.0, 4.318, 0.0], [0.0, 0.0, 2.83]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "g": {"X_0": 2}}
            },
            {
                "Notes": "Marcasite (FeS<sub>2</sub>, C18) Structure",
                "Pearsons Symbol": "oP6",
                "Prototype": "FeS2",
                "Space Group Number": 58,
                "Space Group Symbol": "$Pnnm$",
                "Strukturbericht Designation": "$C18$",
                "aflow_prototype_id": "AB2_oP6_58_a_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_oP6_58_a_g.FeS2.html",
                "atom_labels": ["Fe", "Fe", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.2223, 2.7123, 1.6932], [0.8906978400000001, 2.05429602, 0.0], [3.1129978400000002, 0.65800398, 1.6932], [1.33160216, 4.76659602, 1.6932], [3.5539021600000003, 3.3703039799999996, 0.0]],
                "lattice_vectors": [[4.4446, 0.0, 0.0], [0.0, 5.4246, 0.0], [0.0, 0.0, 3.3864]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "g": {"X_0": 2}}
            },
            {
                "Notes": "Hydrophilite (CaCl<sub>2</sub>, C35) Structure",
                "Pearsons Symbol": "oP6",
                "Prototype": "CaCl2",
                "Space Group Number": 58,
                "Space Group Symbol": "$Pnnm$",
                "Strukturbericht Designation": "$C35$",
                "aflow_prototype_id": "AB2_oP6_58_a_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_oP6_58_a_g.CaCl2.html",
                "atom_labels": ["Ca", "Ca", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.12, 3.215, 2.1], [1.7160000000000002, 2.08975, 0.0], [4.836, 1.1252499999999999, 2.1], [1.404, 5.304749999999999, 2.1], [4.524, 4.34025, 0.0]],
                "lattice_vectors": [[6.24, 0.0, 0.0], [0.0, 6.43, 0.0], [0.0, 0.0, 4.2]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "g": {"X_0": 2}}
            },
            {
                "Notes": "$\\alpha$&ndash;PdCl<sub>2</sub> ($C50$) Structure",
                "Pearsons Symbol": "oP6",
                "Prototype": "Cl2Pd",
                "Space Group Number": 58,
                "Space Group Symbol": "$Pnnm$",
                "Strukturbericht Designation": "$C50$",
                "aflow_prototype_id": "A2B_oP6_58_g_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP6_58_g_a.html",
                "atom_labels": ["Pd", "Pd", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.8786, 5.44705, 1.67315], [1.24964472, 6.896945769, 0.0], [3.12824472, 9.444204230999999, 1.67315], [0.62895528, 1.4498957690000016, 1.67315], [2.50755528, 3.9971542309999997, 0.0]],
                "lattice_vectors": [[3.7572, 0.0, 0.0], [0.0, 10.8941, 0.0], [0.0, 0.0, 3.3463]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "g": {"X_0": 2}}
            }
        ],
        59: [
            {
                "Notes": "CNCl Structure",
                "Pearsons Symbol": "oP6",
                "Prototype": "CClN",
                "Space Group Number": 59,
                "Space Group Symbol": "$Pmmn$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_oP6_59_a_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_oP6_59_a_a_a.html",
                "atom_labels": ["C", "C", "Cl", "Cl", "N", "N"],
                "atom_positions": [[1.42, 0.995, 0.860426], [4.26, 2.985, 4.879574], [1.42, 0.995, 2.4320380000000004], [4.26, 2.985, 3.3079620000000003], [1.42, 0.995, 3.5903699999999996], [4.26, 2.985, 2.1496300000000006]],
                "lattice_vectors": [[5.68, 0.0, 0.0], [0.0, 3.98, 0.0], [0.0, 0.0, 5.74]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1, "X_2": 1}}
            },
            {
                "Notes": "$\\beta$&ndash;TiCu<sub>3</sub> (D0<sub>a</sub>) Structure",
                "Pearsons Symbol": "oP8",
                "Prototype": "Cu3Ti",
                "Space Group Number": 59,
                "Space Group Symbol": "$Pmmn$",
                "Strukturbericht Designation": "$D0_{a}$",
                "aflow_prototype_id": "A3B_oP8_59_bf_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_oP8_59_bf_a.html",
                "atom_labels": ["Ti", "Ti", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu"],
                "atom_positions": [[1.2905, 1.08675, 3.04143375], [3.8715, 3.26025, 1.4895662499999998], [1.2905, 3.26025, 1.490699], [3.8715, 1.08675, 3.040301], [2.60681, 1.08675, 0.7883939999999999], [0.025809999999999448, 3.26025, 3.742606], [2.55519, 3.26025, 3.742606], [5.13619, 1.08675, 0.7883939999999999]],
                "lattice_vectors": [[5.162, 0.0, 0.0], [0.0, 4.347, 0.0], [0.0, 0.0, 4.531]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_0": 1}, "e": {"X_0": 2}}
            },
            {
                "Notes": "Vulcanite (CuTe) Structure",
                "Pearsons Symbol": "oP4",
                "Prototype": "CuTe",
                "Space Group Number": 59,
                "Space Group Symbol": "$Pmmn$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_oP4_59_a_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oP4_59_a_b.html",
                "atom_labels": ["Cu", "Cu", "Te", "Te"],
                "atom_positions": [[0.7875, 1.0225, 0.35445], [2.3625, 3.0675, 6.59555], [0.7875, 3.0675, 1.9251500000000001], [2.3625, 1.0225, 5.02485]],
                "lattice_vectors": [[3.15, 0.0, 0.0], [0.0, 4.09, 0.0], [0.0, 0.0, 6.95]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}}
            },
            {
                "Notes": "FeOCl ($E0_{5}$) Structure",
                "Pearsons Symbol": "oP6",
                "Prototype": "ClFeO",
                "Space Group Number": 59,
                "Space Group Symbol": "$Pmmn$",
                "Strukturbericht Designation": "$E0_{5}$",
                "aflow_prototype_id": "ABC_oP6_59_a_b_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_oP6_59_a_b_a.html",
                "atom_labels": ["Cl", "Cl", "O", "O", "Fe", "Fe"],
                "atom_positions": [[0.82525, 0.94325, 2.607083256], [2.47575, 2.82975, 5.302516744], [0.82525, 0.94325, 7.53033468], [2.47575, 2.82975, 0.37926532], [0.82525, 2.82975, 7.058764328], [2.47575, 0.94325, 0.8508356720000004]],
                "lattice_vectors": [[3.301, 0.0, 0.0], [0.0, 3.773, 0.0], [0.0, 0.0, 7.9096]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "b": {"X_2": 1}}
            }
        ],
        60: [
            {
                "Notes": "$\\beta$&ndash;Toluene Structure",
                "Pearsons Symbol": "oP120",
                "Prototype": "C7H8",
                "Space Group Number": 60,
                "Space Group Symbol": "$Pbcn$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A7B8_oP120_60_7d_8d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A7B8_oP120_60_7d_8d.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[5.2907, 4.490344, 4.273637], [12.2157, 1.219656, 3.1163629999999998], [8.5593, 4.490344, 6.811362999999999], [1.6342999999999999, 1.219656, 0.5786370000000003], [8.5593, 6.929656, 3.1163629999999998], [1.6342999999999999, 10.200344, 4.273637], [5.2907, 6.929656, 0.5786370000000003], [12.2157, 10.200344, 6.811362999999999], [3.8281399999999994, 4.3396, 3.998729], [10.75314, 1.3703999999999998, 3.3912709999999997], [10.02186, 4.3396, 7.086270999999999], [3.0968600000000004, 1.3703999999999998, 0.30372900000000097], [10.02186, 7.0804, 3.3912709999999997], [3.0968600000000004, 10.0496, 3.998729], [3.8281399999999994, 7.0804, 0.30372900000000097], [10.75314, 10.0496, 7.086270999999999], [3.13564, 5.288602, 3.2597289999999997], [10.06064, 0.4213979999999999, 4.130271], [10.714360000000001, 5.288602, 0.435271], [3.78936, 0.4213979999999999, 6.954729], [10.714360000000001, 6.131397999999999, 4.130271], [3.78936, 10.998602, 3.2597289999999997], [3.13564, 6.131397999999999, 6.954729], [10.06064, 10.998602, 0.435271], [1.7852649999999999, 5.146994, 3.0069909999999997], [8.710265, 0.5630060000000001, 4.3830089999999995], [12.064734999999999, 5.146994, 0.6880090000000001], [5.139735, 0.5630060000000001, 6.701991], [12.064734999999999, 6.273006, 4.3830089999999995], [5.139735, 10.856994, 3.0069909999999997], [1.7852649999999999, 6.273006, 6.701991], [8.710265, 10.856994, 0.6880090000000001], [1.09969, 4.058668, 3.4858629999999997], [8.02469, 1.651332, 3.904137], [12.750309999999999, 4.058668, 0.20913699999999993], [5.825309999999999, 1.651332, 7.1808629999999996], [12.750309999999999, 7.361332000000001, 3.904137], [5.825309999999999, 9.768668, 3.4858629999999997], [1.09969, 7.361332000000001, 7.1808629999999996], [8.02469, 9.768668, 0.20913699999999993], [1.7672599999999998, 3.109666, 4.219689999999999], [8.69226, 2.600334, 3.17031], [12.082740000000001, 3.109666, 6.86531], [5.1577399999999995, 2.600334, 0.5246899999999997], [12.082740000000001, 8.310334, 3.17031], [5.1577399999999995, 8.819666, 4.219689999999999], [1.7672599999999998, 8.310334, 0.5246899999999997], [8.69226, 8.819666, 6.86531], [3.117635, 3.247848, 4.473906], [10.042634999999999, 2.462152, 2.9160939999999993], [10.732365, 3.247848, 6.611094], [3.8073650000000003, 2.462152, 0.7789059999999995], [10.732365, 8.172152, 2.9160939999999993], [3.8073650000000003, 8.957848, 4.473906], [3.117635, 8.172152, 0.7789059999999995], [10.042634999999999, 8.957848, 6.611094], [3.62316, 6.085718000000001, 2.90427], [10.548160000000001, 11.044281999999999, 4.485729999999999], [10.22684, 6.085718000000001, 0.7907299999999998], [3.30184, 11.044281999999999, 6.59927], [10.22684, 5.334281999999999, 4.485729999999999], [3.30184, 0.3757180000000017, 2.90427], [3.62316, 5.334281999999999, 6.59927], [10.548160000000001, 0.3757180000000017, 0.7907299999999998], [1.3019, 5.842472000000001, 2.4712159999999996], [8.226899999999999, 11.287528, 4.918784], [12.5481, 5.842472000000001, 1.2237840000000002], [5.6231, 11.287528, 6.166216], [12.5481, 5.577527999999999, 4.918784], [5.6231, 0.13247200000000062, 2.4712159999999996], [1.3019, 5.577527999999999, 6.166216], [8.226899999999999, 0.13247200000000062, 1.2237840000000002], [0.12188, 3.9581720000000002, 3.301852], [7.04688, 1.7518279999999997, 4.088148], [13.728119999999999, 3.9581720000000002, 0.39314800000000016], [6.80312, 1.7518279999999997, 6.996852], [13.728119999999999, 7.461828, 4.088148], [6.80312, 9.668172, 3.301852], [0.12188, 7.461828, 6.996852], [7.04688, 9.668172, 0.39314800000000016], [1.270045, 2.313692, 4.570715], [8.195045, 3.396308, 2.8192849999999994], [12.579955, 2.313692, 6.514284999999999], [5.654955, 3.396308, 0.8757150000000004], [12.579955, 9.106308, 2.8192849999999994], [5.654955, 8.023692, 4.570715], [1.270045, 9.106308, 0.8757150000000004], [8.195045, 8.023692, 6.514284999999999], [3.5913049999999997, 2.548944, 5.009681], [10.516305, 3.161056, 2.380319], [10.258695, 2.548944, 6.075319], [3.333695, 3.161056, 1.3146809999999995], [10.258695, 8.871056, 2.380319], [3.333695, 8.258944000000001, 5.009681], [3.5913049999999997, 8.871056, 1.3146809999999995], [10.516305, 8.258944000000001, 6.075319], [5.50122, 5.463328, 4.397049999999999], [12.426219999999999, 0.24667200000000009, 2.99295], [8.34878, 5.463328, 6.68795], [1.42378, 0.24667200000000009, 0.7020499999999997], [8.34878, 5.956672000000001, 2.99295], [1.42378, 11.173328, 4.397049999999999], [5.50122, 5.956672000000001, 0.7020499999999997], [12.426219999999999, 11.173328, 6.68795], [5.80592, 4.138608, 3.491036], [12.73092, 1.571392, 3.8989640000000003], [8.04408, 4.138608, 0.2039640000000001], [1.1190799999999996, 1.571392, 7.186035999999999], [8.04408, 7.281391999999999, 3.8989640000000003], [1.1190799999999996, 9.848608, 3.491036], [5.80592, 7.281391999999999, 7.186035999999999], [12.73092, 9.848608, 0.2039640000000001], [5.54277, 3.987864, 5.0954049999999995], [12.46777, 1.722136, 2.2945949999999997], [8.30723, 3.987864, 5.989595], [1.38223, 1.722136, 1.400405], [8.30723, 7.432136000000001, 2.2945949999999997], [1.38223, 9.697864, 5.0954049999999995], [5.54277, 7.432136000000001, 1.400405], [12.46777, 9.697864, 5.989595]],
                "lattice_vectors": [[13.85, 0.0, 0.0], [0.0, 11.42, 0.0], [0.0, 0.0, 7.39]],
                "normalized_wyckoff_matid": {"d": {"X_0": 8, "X_1": 7}}
            },
            {
                "Notes": "Rh<sub>2</sub>S<sub>3</sub> Structure",
                "Pearsons Symbol": "oP20",
                "Prototype": "Rh2S3",
                "Space Group Number": 60,
                "Space Group Symbol": "$Pbcn$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B3_oP20_60_d_cd",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_oP20_60_d_cd.html",
                "atom_labels": ["Rh", "Rh", "Rh", "Rh", "Rh", "Rh", "Rh", "Rh", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[3.3331625970452, 4.4848958514, 0.20228530251600002], [0.8967391758548, -1.4949652838, 3.267214128516], [-3.3331625970452, 4.4848958514, 2.8626435234840004], [7.5630643699452, -1.4949652838, -0.20228530251600002], [-3.3331625970452, -4.4848958514, -0.20228530251600002], [7.5630643699452, 7.474826419, 2.8626435234840004], [3.3331625970452, -4.4848958514, 3.267214128516], [0.8967391758548, 7.474826419, 0.20228530251600002], [0.0, 3.2709840409544, 1.532464413], [4.2299017729, -0.2810534733544, 4.5973932390000005], [0.0, -3.2709840409544, 4.5973932390000005], [4.2299017729, 6.260914608554399, 1.532464413], [2.9440116339383997, 3.6536951536072, 2.427423630192], [1.2858901389616, -0.6637645860072, 5.492352456192], [-2.9440116339383997, 3.6536951536072, 0.637505195808], [7.1739134068384, -0.6637645860072, -2.427423630192], [-2.9440116339383997, -3.6536951536072, -2.427423630192], [7.1739134068384, 6.6436257212072, 0.637505195808], [2.9440116339383997, -3.6536951536072, 5.492352456192], [1.2858901389616, 6.6436257212072, 2.427423630192]],
                "lattice_vectors": [[8.4598035458, 0.0, 0.0], [0.0, 5.9798611352, 0.0], [0.0, 0.0, 6.129857652]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "d": {"X_0": 2, "X_1": 2}}
            },
            {
                "Notes": "WO<sub>3</sub> Structure",
                "Pearsons Symbol": "oP32",
                "Prototype": "O3W",
                "Space Group Number": 60,
                "Space Group Symbol": "$Pbcn$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_oP32_60_3d_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_oP32_60_3d_d.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "W", "W", "W", "W", "W", "W", "W", "W"],
                "atom_positions": [[3.6816354635412005, 5.5804801763436, 0.24389845864426], [0.011743653791200338, 6.037452182456399, 7.33058783465574], [3.6581481559588, 5.5804801763436, 3.5433446880057398], [7.3280399657088005, 6.037452182456399, 4.03114160529426], [3.6581481559588, 2.1648080628563995, 7.33058783465574], [7.3280399657088005, 1.7078360567435993, 0.24389845864426], [3.6816354635412005, 2.1648080628563995, 4.03114160529426], [0.011743653791200338, 1.7078360567435993, 3.5433446880057398], [1.59053111034565, 5.87944830237672, 1.9557323609300599], [5.2604229200956505, 5.73848405642328, 5.61875393236994], [5.74925250915435, 5.87944830237672, 1.83151078571994], [2.07936069940435, 5.73848405642328, 5.742975507580059], [5.74925250915435, 1.8658399368232799, 5.61875393236994], [2.07936069940435, 2.0068041827767207, 1.9557323609300599], [1.59053111034565, 1.8658399368232799, 5.742975507580059], [5.2604229200956505, 2.0068041827767207, 1.83151078571994], [1.6125504612041501, 3.88503658078272, 0.0984683218129], [5.28244227095415, 7.732895778017279, 7.476017971487099], [5.72723315829585, 3.88503658078272, 3.6887748248371], [2.05734134854585, 7.732895778017279, 3.8857114684628997], [5.72723315829585, 3.8602516584172797, 7.476017971487099], [2.05734134854585, 0.012392461182720355, 0.0984683218129], [1.6125504612041501, 3.8602516584172797, 3.8857114684628997], [5.28244227095415, 0.012392461182720355, 3.6887748248371], [1.820266337636, 6.0645606912936, 0.22041755113503], [5.490158147386, 5.5533716675064, 7.354068742164969], [5.519517281864, 6.0645606912936, 3.56682559551497], [1.8496254721140002, 5.5533716675064, 4.00766069778503], [5.519517281864, 1.6807275479063997, 7.354068742164969], [1.8496254721140002, 2.191916571693599, 0.22041755113503], [1.820266337636, 1.6807275479063997, 4.00766069778503], [5.490158147386, 2.191916571693599, 3.56682559551497]],
                "lattice_vectors": [[7.3397836195, 0.0, 0.0], [0.0, 7.7452882392, 0.0], [0.0, 0.0, 7.5744862933]],
                "normalized_wyckoff_matid": {"d": {"X_0": 3, "X_1": 1}}
            }
        ],
        61: [
            {
                "Notes": "Brookite (TiO<sub>2</sub>, C21) Structure",
                "Pearsons Symbol": "oP24",
                "Prototype": "O2Ti",
                "Space Group Number": 61,
                "Space Group Symbol": "$Pbca$",
                "Strukturbericht Designation": "$C21$",
                "aflow_prototype_id": "A2B_oP24_61_2c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP24_61_2c_c.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti"],
                "atom_positions": [[0.087153, 0.5142459, 0.942823], [4.674153, 1.2102541, 4.195177], [9.086847, 2.2387459, 1.626177], [4.499847, 2.9347540999999997, 3.5118229999999997], [9.086847, 2.9347540999999997, 4.195177], [4.499847, 2.2387459, 0.942823], [0.087153, 1.2102541, 3.5118229999999997], [4.674153, 0.5142459, 1.626177], [2.1228635999999996, 0.382839, 2.7570507999999996], [6.7098636, 1.341661, 2.3809492000000003], [7.051136399999999, 2.107339, 4.9499492], [2.4641364, 3.0661609999999997, 0.18805079999999982], [7.051136399999999, 3.0661609999999997, 2.3809492000000003], [2.4641364, 2.107339, 2.7570507999999996], [2.1228635999999996, 1.341661, 0.18805079999999982], [6.7098636, 0.382839, 4.9499492], [1.1825285999999997, 0.33524279999999995, 4.4330664], [5.7695286, 1.3892571999999999, 0.7049335999999999], [7.991471399999999, 2.0597427999999995, 3.2739336], [3.4044714, 3.1137572000000002, 1.8640664], [7.991471399999999, 3.1137572000000002, 0.7049335999999999], [3.4044714, 2.0597427999999995, 4.4330664], [1.1825285999999997, 1.3892571999999999, 1.8640664], [5.7695286, 0.33524279999999995, 3.2739336]],
                "lattice_vectors": [[9.174, 0.0, 0.0], [0.0, 3.449, 0.0], [0.0, 0.0, 5.138]],
                "normalized_wyckoff_matid": {"c": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "CdSb (B<sub>e</sub>) Structure",
                "Pearsons Symbol": "oP16",
                "Prototype": "CdSb",
                "Space Group Number": 61,
                "Space Group Symbol": "$Pbca$",
                "Strukturbericht Designation": "$B_{e}$",
                "aflow_prototype_id": "AB_oP16_61_c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oP16_61_c_c.html",
                "atom_labels": ["Cd", "Cd", "Cd", "Cd", "Cd", "Cd", "Cd", "Cd", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb"],
                "atom_positions": [[0.8800560000000001, 0.594216, 0.920808], [4.115556, 3.5322839999999998, 7.605192], [5.590944, 4.7207159999999995, 3.342192], [2.355444, 7.658784000000001, 5.183808], [5.590944, 7.658784000000001, 7.605192], [2.355444, 4.7207159999999995, 0.920808], [0.8800560000000001, 3.5322839999999998, 5.183808], [4.115556, 0.594216, 3.342192], [2.9507760000000003, 0.982107, 7.434672], [6.186275999999999, 3.144393, 1.091328], [3.5202240000000002, 5.108607, 5.354328], [0.2847239999999999, 7.270893, 3.171671999999999], [3.5202240000000002, 7.270893, 1.091328], [0.2847239999999999, 5.108607, 7.434672], [2.9507760000000003, 3.144393, 3.171671999999999], [6.186275999999999, 0.982107, 5.354328]],
                "lattice_vectors": [[6.471, 0.0, 0.0], [0.0, 8.253, 0.0], [0.0, 0.0, 8.526]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "Benzene Structure",
                "Pearsons Symbol": "oP48",
                "Prototype": "Be",
                "Space Group Number": 61,
                "Space Group Symbol": "$Pbca$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_oP48_61_3c_3c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oP48_61_3c_3c.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[0.8967458, 4.307671200000001, 3.9019908900000004], [4.3537458, 6.9063288, 5.66100911], [6.017254199999999, 0.5696712000000004, 0.87950911], [2.5602541999999997, 3.1683288, 8.68349089], [6.017254199999999, 3.1683288, 5.66100911], [2.5602541999999997, 0.5696712000000004, 3.9019908900000004], [0.8967458, 6.9063288, 8.68349089], [4.3537458, 4.307671200000001, 0.87950911], [0.8538789999999999, 4.7308128, 5.21355634], [4.310878999999999, 6.4831872, 4.34944366], [6.0601210000000005, 0.9928128000000002, 9.13094366], [2.603121, 2.7451871999999997, 0.43205634], [6.0601210000000005, 2.7451871999999997, 4.34944366], [2.603121, 0.9928128000000002, 5.21355634], [0.8538789999999999, 6.4831872, 0.43205634], [4.310878999999999, 4.7308128, 9.13094366], [0.0394098, 3.3133632, 3.47031707], [3.4964098, 0.42463680000000015, 6.092682930000001], [6.874590199999999, 7.0513632, 1.3111829300000002], [3.4175902, 4.1626368, 8.25181707], [6.874590199999999, 4.1626368, 6.092682930000001], [3.4175902, 7.0513632, 3.47031707], [0.0394098, 0.42463680000000015, 8.25181707], [3.4964098, 3.3133632, 1.3111829300000002], [1.5017208, 4.69119, 3.308798], [4.9587208, 6.522810000000001, 6.254202], [5.4122791999999995, 0.9531899999999996, 1.4727020000000004], [1.9552791999999999, 2.7848100000000002, 8.090298], [5.4122791999999995, 2.7848100000000002, 6.254202], [1.9552791999999999, 0.9531899999999996, 3.308798], [1.5017208, 6.522810000000001, 8.090298], [4.9587208, 4.69119, 1.4727020000000004], [1.4298152, 5.40141, 5.504462800000001], [4.8868152, 5.81259, 4.0585372], [5.4841847999999995, 1.6634100000000012, 8.840037200000001], [2.0271848, 2.0745899999999997, 0.7229628000000011], [5.4841847999999995, 2.0745899999999997, 4.0585372], [2.0271848, 1.6634100000000012, 5.504462800000001], [1.4298152, 5.81259, 0.7229628000000011], [4.8868152, 5.40141, 8.840037200000001], [0.06568299999999999, 3.0285276000000003, 2.5858352], [3.5226829999999993, 0.7094723999999999, 6.977164800000001], [6.848317, 6.7665276, 2.1956648000000003], [3.391317, 4.4474724, 7.3673352], [6.848317, 4.4474724, 6.977164800000001], [3.391317, 6.7665276, 2.5858352], [0.06568299999999999, 0.7094723999999999, 7.3673352], [3.5226829999999993, 3.0285276000000003, 2.1956648000000003]],
                "lattice_vectors": [[6.914, 0.0, 0.0], [0.0, 7.476, 0.0], [0.0, 0.0, 9.563]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}}
            }
        ],
        62: [
            {
                "Notes": "GeS (B16) Structure",
                "Pearsons Symbol": "oP8",
                "Prototype": "GeS",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$B16$",
                "aflow_prototype_id": "AB_oP8_62_c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oP8_62_c_c.GeS.html",
                "atom_labels": ["Ge", "Ge", "Ge", "Ge", "S", "S", "S", "S"],
                "atom_positions": [[3.9074999999999998, 0.91, 1.4285700000000001], [9.1175, 0.91, 0.7164299999999999], [6.5125, 2.73, 2.8614300000000004], [1.3025, 2.73, 3.5735699999999997], [1.4483800000000002, 0.91, 1.6688100000000001], [6.65838, 0.91, 0.47618999999999995], [8.97162, 2.73, 2.62119], [3.7616199999999997, 2.73, 3.81381]],
                "lattice_vectors": [[10.42, 0.0, 0.0], [0.0, 3.64, 0.0], [0.0, 0.0, 4.29]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "FeB (B27) Structure",
                "Pearsons Symbol": "oP8",
                "Prototype": "BFe",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$B27$",
                "aflow_prototype_id": "AB_oP8_62_c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oP8_62_c_c.FeB.html",
                "atom_labels": ["B", "B", "B", "B", "Fe", "Fe", "Fe", "Fe"],
                "atom_positions": [[0.686875, 0.7365, 2.7965699999999996], [3.434375, 0.7365, 3.2829300000000003], [4.808125, 2.2095000000000002, 1.2564300000000002], [2.060625, 2.2095000000000002, 0.7700699999999998], [4.5059000000000005, 0.7365, 0.506625], [1.7584, 0.7365, 1.5198749999999999], [0.9891, 2.2095000000000002, 3.546375], [3.7365999999999997, 2.2095000000000002, 2.533125]],
                "lattice_vectors": [[5.495, 0.0, 0.0], [0.0, 2.946, 0.0], [0.0, 0.0, 4.053]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "MnP (B31) Structure",
                "Pearsons Symbol": "oP8",
                "Prototype": "MnP",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$B31$",
                "aflow_prototype_id": "AB_oP8_62_c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oP8_62_c_c.MnP.html",
                "atom_labels": ["Mn", "Mn", "Mn", "Mn", "P", "P", "P", "P"],
                "atom_positions": [[0.02935296, 0.79505, 1.15230464], [2.6501529600000002, 0.79505, 1.7992953599999997], [5.212247039999999, 2.3851500000000003, 4.7508953599999995], [2.5914470400000003, 2.3851500000000003, 4.1039046400000005], [0.9848966400000001, 0.79505, 3.36246272], [3.6056966399999997, 0.79505, 5.49233728], [4.25670336, 2.3851500000000003, 2.54073728], [1.63590336, 2.3851500000000003, 0.4108627199999993]],
                "lattice_vectors": [[5.2416, 0.0, 0.0], [0.0, 3.1802, 0.0], [0.0, 0.0, 5.9032]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "HgCl<sub>2</sub> (C25) Structure",
                "Pearsons Symbol": "oP12",
                "Prototype": "Cl2Hg",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$C25$",
                "aflow_prototype_id": "A2B_oP12_62_2c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP12_62_2c_c.HgCl2.html",
                "atom_labels": ["Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Hg", "Hg", "Hg", "Hg"],
                "atom_positions": [[9.334755, 1.49075, 0.540625], [2.967255000000001, 1.49075, 1.6218750000000002], [3.400245, 4.47225, 3.7843750000000003], [9.767745, 4.47225, 2.703125], [6.46938, 1.49075, 3.12265], [0.10188000000000008, 1.49075, 3.36485], [6.265619999999999, 4.47225, 1.2023500000000003], [12.63312, 4.47225, 0.96015], [11.13039, 1.49075, 1.933275], [4.762890000000001, 1.49075, 0.22922499999999998], [1.6046099999999999, 4.47225, 2.3917249999999997], [7.97211, 4.47225, 4.095775000000001]],
                "lattice_vectors": [[12.735, 0.0, 0.0], [0.0, 5.963, 0.0], [0.0, 0.0, 4.325]],
                "normalized_wyckoff_matid": {"c": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "CaTiO<sub>3</sub> Pnma Perovskite Structure",
                "Pearsons Symbol": "oP20",
                "Prototype": "CaO3Ti",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3C_oP20_62_c_cd_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3C_oP20_62_c_cd_a.html",
                "atom_labels": ["Ti", "Ti", "Ti", "Ti", "Ca", "Ca", "Ca", "Ca", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.7112, 3.8255, 2.70215], [0.0, 3.8255, 0.0], [2.7112, 0.0, 2.70215], [2.64450448, 1.91275, 5.358903880000001], [5.35570448, 1.91275, 2.74754612], [2.7778955199999995, 5.73825, 0.04539612], [0.06669551999999987, 5.73825, 2.65675388], [0.16972112, 1.91275, 0.31669198], [2.88092112, 1.91275, 2.38545802], [5.2526788799999995, 5.73825, 5.08760802], [2.5414788799999997, 5.73825, 3.01884198], [1.5616511999999998, 4.108587, 1.1511159], [4.2728512, 7.367913, 1.5510341000000003], [3.8607487999999996, 0.28308699999999937, 4.2531841], [1.1495488, 3.542413, 3.8532659], [3.8607487999999996, 3.542413, 4.2531841], [1.1495488, 0.28308699999999937, 3.8532659], [1.5616511999999998, 7.367913, 1.1511159], [4.2728512, 4.108587, 1.5510341000000003]],
                "lattice_vectors": [[5.4224, 0.0, 0.0], [0.0, 7.651, 0.0], [0.0, 0.0, 5.4043]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 1, "X_2": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "$\\alpha$&ndash;Np (A<sub>c</sub>) Structure",
                "Pearsons Symbol": "oP8",
                "Prototype": "Np",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$A_{c}$",
                "aflow_prototype_id": "A_oP8_62_2c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_oP8_62_2c.html",
                "atom_labels": ["Np", "Np", "Np", "Np", "Np", "Np", "Np", "Np"],
                "atom_positions": [[3.091632, 1.18075, 1.4270039999999997], [6.423132, 1.18075, 1.016496], [3.5713680000000005, 3.54225, 3.4599959999999994], [0.23986799999999986, 3.54225, 3.870504], [1.206003, 1.18075, 3.215646], [4.537503, 1.18075, 4.114853999999999], [5.456997, 3.54225, 1.6713539999999998], [2.125497, 3.54225, 0.7721459999999996]],
                "lattice_vectors": [[6.663, 0.0, 0.0], [0.0, 4.723, 0.0], [0.0, 0.0, 4.887]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}}
            },
            {
                "Notes": "Cementite (Fe<sub>3</sub>C, D0<sub>11</sub>) Structure",
                "Pearsons Symbol": "oP16",
                "Prototype": "CFe3",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$D0_{11}$",
                "aflow_prototype_id": "AB3_oP16_62_c_cd",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_oP16_62_c_cd.html",
                "atom_labels": ["C", "C", "C", "C", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe"],
                "atom_positions": [[1.9851, 1.687, 0.22615], [4.5301, 1.687, 2.0353499999999998], [3.1048999999999998, 5.061, 4.296849999999999], [0.5599, 5.061, 2.48765], [0.18324, 1.687, 3.8535959999999996], [2.72824, 1.687, 2.930904], [4.906759999999999, 5.061, 0.669404], [2.36176, 5.061, 1.5920959999999993], [0.9467399999999999, 0.425124, 1.483544], [3.4917399999999996, 2.9488760000000003, 0.7779559999999999], [4.143260000000001, 3.799124, 3.0394559999999995], [1.59826, 6.322876000000001, 3.745044], [4.143260000000001, 6.322876000000001, 3.0394559999999995], [1.59826, 3.799124, 3.745044], [0.9467399999999999, 2.9488760000000003, 1.483544], [3.4917399999999996, 0.425124, 0.7779559999999999]],
                "lattice_vectors": [[5.09, 0.0, 0.0], [0.0, 6.748, 0.0], [0.0, 0.0, 4.523]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "Chalcostibite (CuSbS<sub>2</sub>, F5<sub>6</sub>)",
                "Pearsons Symbol": "oP16",
                "Prototype": "CuS2Sb",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$F5_{6}$",
                "aflow_prototype_id": "AB2C_oP16_62_c_2c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2C_oP16_62_c_2c_c.html",
                "atom_labels": ["Cu", "Cu", "Cu", "Cu", "S", "S", "S", "S", "S", "S", "S", "S", "Sb", "Sb", "Sb", "Sb"],
                "atom_positions": [[1.5177395999999999, 0.94895, 11.996062], [4.5267396, 0.94895, 9.746438], [4.5002604, 2.84685, 2.498938], [1.4912604, 2.84685, 4.748561999999998], [3.7437978, 0.94895, 1.377025], [0.7347978000000006, 0.94895, 5.870475], [2.2742022, 2.84685, 13.117975], [5.2832022, 2.84685, 8.624524999999998], [5.2392708, 0.94895, 11.949678], [2.2302708, 0.94895, 9.792822], [0.7787291999999997, 2.84685, 2.5453219999999996], [3.7877292, 2.84685, 4.702178], [1.360068, 0.94895, 0.9179683499999999], [4.3690679999999995, 0.94895, 6.32953165], [4.657932, 2.84685, 13.577031649999999], [1.648932, 2.84685, 8.16546835]],
                "lattice_vectors": [[6.018, 0.0, 0.0], [0.0, 3.7958, 0.0], [0.0, 0.0, 14.495]],
                "normalized_wyckoff_matid": {"c": {"X_0": 2, "X_1": 1, "X_2": 1}}
            },
            {
                "Notes": "Stibnite (Sb<sub>2</sub>S<sub>3</sub>, D5<sub>8</sub>) Structure",
                "Pearsons Symbol": "oP20",
                "Prototype": "S3Sb2",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$D5_{8}$",
                "aflow_prototype_id": "A3B2_oP20_62_3c_2c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B2_oP20_62_3c_2c.html",
                "atom_labels": ["S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb"],
                "atom_positions": [[3.2966004, 0.9574, 2.15306725], [8.937600400000001, 0.9574, 3.4594327499999995], [7.9853996, 2.8722000000000003, 9.071932749999998], [2.3443996, 2.8722000000000003, 7.76556725], [5.0814128, 0.9574, 9.844325], [10.7224128, 0.9574, 6.993175], [6.2005872, 2.8722000000000003, 1.3806749999999999], [0.5595871999999997, 2.8722000000000003, 4.231825], [7.046737200000001, 0.9574, 6.2983475], [1.4057372000000006, 0.9574, 10.539152499999998], [4.235262799999999, 2.8722000000000003, 4.926652499999999], [9.8762628, 2.8722000000000003, 0.6858475000000017], [10.95064766, 0.9574, 1.9529254999999999], [5.3096476599999995, 0.9574, 3.6595744999999997], [0.33135234, 2.8722000000000003, 9.272074499999999], [5.9723523400000005, 2.8722000000000003, 7.5654255], [7.32641798, 0.9574, 10.82056325], [1.685417979999999, 0.9574, 6.01693675], [3.9555820199999996, 2.8722000000000003, 0.40443674999999996], [9.59658202, 2.8722000000000003, 5.2080632499999995]],
                "lattice_vectors": [[11.282, 0.0, 0.0], [0.0, 3.8296, 0.0], [0.0, 0.0, 11.225]],
                "normalized_wyckoff_matid": {"c": {"X_0": 3, "X_1": 2}}
            },
            {
                "Notes": "SnS (B29) Structure",
                "Pearsons Symbol": "oP8",
                "Prototype": "SSn",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$B29$",
                "aflow_prototype_id": "AB_oP8_62_c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oP8_62_c_c.SnS.html",
                "atom_labels": ["S", "S", "S", "S", "Sn", "Sn", "Sn", "Sn"],
                "atom_positions": [[3.920826, 0.9955, 0.08701289999999999], [9.510826, 0.9955, 2.0774871], [7.259174, 2.9865000000000004, 4.241987099999999], [1.669174, 2.9865000000000004, 2.2515129], [6.9245566, 0.9955, 1.6476174], [1.3345565999999998, 0.9955, 0.5168826], [4.2554434, 2.9865000000000004, 2.6813825999999996], [9.8454434, 2.9865000000000004, 3.8121174]],
                "lattice_vectors": [[11.18, 0.0, 0.0], [0.0, 3.982, 0.0], [0.0, 0.0, 4.329]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "MgB<sub>4</sub> Structure",
                "Pearsons Symbol": "oP20",
                "Prototype": "B4Mg",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B_oP20_62_2cd_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B_oP20_62_2cd_c.html",
                "atom_labels": ["B", "B", "B", "B", "B", "B", "B", "B", "Mg", "Mg", "Mg", "Mg", "B", "B", "B", "B", "B", "B", "B", "B"],
                "atom_positions": [[1.22672264, 1.107, 4.90357472], [3.9587226400000004, 1.107, 6.304425280000001], [4.23727736, 3.3209999999999997, 2.5684252800000005], [1.5052773600000002, 3.3209999999999997, 1.1675747200000006], [3.04896664, 1.107, 4.8313952], [0.31696663999999947, 1.107, 6.376604800000001], [2.4150333600000002, 3.3209999999999997, 2.6406048000000006], [5.14703336, 3.3209999999999997, 1.095395199999999], [0.28035784, 1.107, 2.71696864], [3.01235784, 1.107, 1.01903136], [5.183642160000001, 3.3209999999999997, 4.75503136], [2.45164216, 3.3209999999999997, 6.452968640000001], [0.71463656, 0.2563812, 0.48889296000000004], [3.44663656, 1.9576187999999999, 3.2471070400000004], [4.749363440000001, 2.4703812, 6.98310704], [2.0173634400000005, 4.1716188, 4.22489296], [4.749363440000001, 4.1716188, 6.98310704], [2.0173634400000005, 2.4703812, 4.22489296], [0.71463656, 1.9576187999999999, 0.48889296000000004], [3.44663656, 0.2563812, 3.2471070400000004]],
                "lattice_vectors": [[5.464, 0.0, 0.0], [0.0, 4.428, 0.0], [0.0, 0.0, 7.472]],
                "normalized_wyckoff_matid": {"c": {"X_0": 2, "X_1": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "Cotunnite (PbCl<sub>2</sub>, C23) Structure",
                "Pearsons Symbol": "oP12",
                "Prototype": "Cl2Pb",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$C23$",
                "aflow_prototype_id": "A2B_oP12_62_2c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP12_62_2c_c.PbCl2.html",
                "atom_labels": ["Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Pb", "Pb", "Pb", "Pb"],
                "atom_positions": [[0.95255, 1.13355, 3.81436084], [4.7627500000000005, 1.13355, 0.7082391599999998], [6.66785, 3.40065, 5.23083916], [2.85765, 3.40065, 8.33696084], [0.15393208, 1.13355, 7.5708324], [3.96413208, 1.13355, 5.9969676], [7.46646792, 3.40065, 1.4743676000000001], [3.65626792, 3.40065, 3.0482323999999994], [1.81136908, 1.13355, 0.8674346799999999], [5.62156908, 1.13355, 3.65516532], [5.80903092, 3.40065, 8.177765319999999], [1.9988309199999998, 3.40065, 5.390034679999999]],
                "lattice_vectors": [[7.6204, 0.0, 0.0], [0.0, 4.5342, 0.0], [0.0, 0.0, 9.0452]],
                "normalized_wyckoff_matid": {"c": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "C<sub>3</sub>Cr<sub>7</sub> (D10<sub>1</sub>) Structure",
                "Pearsons Symbol": "oP40",
                "Prototype": "C3Cr7",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$D10_{1}$",
                "aflow_prototype_id": "A3B7_oP40_62_cd_3c2d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B7_oP40_62_cd_3c2d.html",
                "atom_labels": ["C", "C", "C", "C", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "C", "C", "C", "C", "C", "C", "C", "C", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr"],
                "atom_positions": [[2.0792444, 1.7525, 6.834731799999999], [4.3422444, 1.7525, 11.3782682], [2.4467556, 5.2575, 5.3072682], [0.1837556000000001, 5.2575, 0.7637317999999994], [0.2620554, 1.7525, 7.6021062], [2.5250554, 1.7525, 10.6108938], [4.2639446, 5.2575, 4.5398938], [2.0009446, 5.2575, 1.531106200000001], [1.1319526, 1.7525, 2.5048946], [3.3949526, 1.7525, 3.566105399999999], [3.3940474, 5.2575, 9.6371054], [1.1310474, 5.2575, 8.5758946], [1.1853594, 1.7525, 5.057143], [3.4483593999999997, 1.7525, 1.0138570000000002], [3.3406406, 5.2575, 7.0848569999999995], [1.0776405999999998, 5.2575, 11.128143], [0.1303488, 0.203991, 4.1622775999999995], [2.3933488, 3.3010089999999996, 1.9087224], [4.3956512, 3.708991, 7.9797224], [2.1326511999999997, 6.8060089999999995, 10.2332776], [4.3956512, 6.8060089999999995, 7.9797224], [2.1326511999999997, 3.708991, 10.2332776], [0.1303488, 3.3010089999999996, 4.1622775999999995], [2.3933488, 0.203991, 1.9087224], [0.255719, 0.45004199999999994, 9.858089799999998], [2.518719, 3.054958, 8.3549102], [4.270281, 3.955042, 2.2839102000000002], [2.007281, 6.559958, 3.787089800000001], [4.270281, 6.559958, 2.2839102000000002], [2.007281, 3.955042, 3.787089800000001], [0.255719, 3.054958, 9.858089799999998], [2.518719, 0.45004199999999994, 8.3549102], [1.1355734, 0.46055699999999994, 0.2646956], [3.3985734, 3.0444430000000002, 5.8063044], [3.3904265999999996, 3.9655569999999996, 11.877304399999998], [1.1274266, 6.549443, 6.3356956], [3.3904265999999996, 6.549443, 11.877304399999998], [1.1274266, 3.9655569999999996, 6.3356956], [1.1355734, 3.0444430000000002, 0.2646956], [3.3985734, 0.46055699999999994, 5.8063044]],
                "lattice_vectors": [[4.526, 0.0, 0.0], [0.0, 7.01, 0.0], [0.0, 0.0, 12.142]],
                "normalized_wyckoff_matid": {"c": {"X_0": 3, "X_1": 1}, "d": {"X_0": 4, "X_1": 2}}
            },
            {
                "Notes": "Co<sub>2</sub>Si (C37) Structure",
                "Pearsons Symbol": "oP12",
                "Prototype": "Co2Si",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$C37$",
                "aflow_prototype_id": "A2B_oP12_62_2c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP12_62_2c_c.Co2Si.html",
                "atom_labels": ["Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.186884, 0.9345, 2.0047379999999997], [2.645884, 0.9345, 1.549762], [4.731116, 2.8035, 5.104261999999999], [2.272116, 2.8035, 5.559238000000001], [3.3147320000000002, 0.9345, 3.995258], [0.8557319999999997, 0.9345, 6.668241999999999], [1.603268, 2.8035, 3.113742], [4.0622679999999995, 2.8035, 0.44075800000000037], [0.9934360000000001, 0.9345, 4.343599], [3.452436, 0.9345, 6.319901], [3.924564, 2.8035, 2.765401], [1.465564, 2.8035, 0.7890989999999999]],
                "lattice_vectors": [[4.918, 0.0, 0.0], [0.0, 3.738, 0.0], [0.0, 0.0, 7.109]],
                "normalized_wyckoff_matid": {"c": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "Barite (BaSO<sub>4</sub>, $H0_{2}$) Structure",
                "Pearsons Symbol": "oP24",
                "Prototype": "BaO4S",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$H0_{2}$",
                "aflow_prototype_id": "AB4C_oP24_62_c_2cd_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4C_oP24_62_c_2cd_c.html",
                "atom_labels": ["Ba", "Ba", "Ba", "Ba", "O", "O", "O", "O", "O", "O", "O", "O", "S", "S", "S", "S", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[7.244013600000001, 1.3645, 2.4456106999999996], [2.802013599999999, 1.3645, 1.1308893], [1.6399864, 4.093500000000001, 4.7073893], [6.0819864, 4.093500000000001, 6.0221107], [5.2220152, 1.3645, 4.3361486], [0.7800152000000009, 1.3645, 6.3933514], [3.6619848000000004, 4.093500000000001, 2.8168514], [8.103984800000001, 4.093500000000001, 0.7596485999999989], [2.8357728, 1.3645, 3.9448795], [7.277772799999999, 1.3645, 6.7846205], [6.048227200000001, 4.093500000000001, 3.2081204999999997], [1.6062272000000002, 4.093500000000001, 0.36837949999999914], [3.882308, 1.3645, 4.9455842], [8.324308, 1.3645, 5.7839158], [5.001691999999999, 4.093500000000001, 2.2074157999999997], [0.5596920000000001, 4.093500000000001, 1.3690842], [3.7188424, 2.5663516, 5.858306999999999], [8.160842400000002, 0.16264839999999997, 4.871193], [5.1651576, 5.2953516, 1.2946930000000003], [0.7231575999999997, 2.8916484000000002, 2.2818069999999997], [5.1651576, 2.8916484000000002, 1.2946930000000003], [0.7231575999999997, 5.2953516, 2.2818069999999997], [3.7188424, 0.16264839999999997, 5.858306999999999], [8.160842400000002, 2.5663516, 4.871193]],
                "lattice_vectors": [[8.884, 0.0, 0.0], [0.0, 5.458, 0.0], [0.0, 0.0, 7.153]],
                "normalized_wyckoff_matid": {"c": {"X_0": 2, "X_1": 1, "X_2": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "Forsterite (Mg<sub>2</sub>SiO<sub>4</sub>, $S1_{2}$) Structure",
                "Pearsons Symbol": "oP28",
                "Prototype": "Mg2O4Si",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$S1_{2}$",
                "aflow_prototype_id": "A2B4C_oP28_62_ac_2cd_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B4C_oP28_62_ac_2cd_c.html",
                "atom_labels": ["Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "O", "O", "O", "O", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [5.0965, 2.9885, 2.376], [0.0, 2.9885, 0.0], [5.0965, 0.0, 2.376], [2.8275382, 1.49425, 4.711608], [7.924038199999999, 1.49425, 2.4163919999999997], [7.3654618, 4.48275, 0.040392000000000004], [2.2689618, 4.48275, 2.3356079999999997], [0.9306209, 1.49425, 3.6386064], [6.0271209, 1.49425, 3.4893935999999997], [9.262379099999999, 4.48275, 1.1133935999999998], [4.1658791, 4.48275, 1.2626064000000001], [4.5603482, 1.49425, 1.052568], [9.6568482, 1.49425, 1.3234319999999997], [5.6326518, 4.48275, 3.699432], [0.5361517999999997, 4.48275, 3.428568], [0.9581419999999999, 1.49425, 2.0253024], [6.054641999999999, 1.49425, 0.3506975999999999], [9.234858, 4.48275, 2.7266975999999996], [4.138358, 4.48275, 4.4013024], [1.6594204, 0.1978387, 1.3196303999999999], [6.7559204, 2.7906613, 1.0563696], [8.5335796, 3.1863387000000003, 3.4323695999999995], [3.4370795999999997, 5.7791613, 3.6956304], [8.5335796, 5.7791613, 3.4323695999999995], [3.4370795999999997, 3.1863387000000003, 3.6956304], [1.6594204, 2.7906613, 1.3196303999999999], [6.7559204, 0.1978387, 1.0563696]],
                "lattice_vectors": [[10.193, 0.0, 0.0], [0.0, 5.977, 0.0], [0.0, 0.0, 4.752]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 2, "X_1": 1, "X_2": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "$\\epsilon$&ndash;NiAl<sub>3</sub> ($D0_{20}$) Structure",
                "Pearsons Symbol": "oP16",
                "Prototype": "Al3Ni",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$D0_{20}$",
                "aflow_prototype_id": "A3B_oP16_62_cd_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_oP16_62_cd_c.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Ni", "Ni", "Ni", "Ni", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al"],
                "atom_positions": [[0.0725802, 1.837875, 1.9928715], [3.3716802, 1.837875, 0.4081785000000001], [6.5256198, 5.513624999999999, 2.8092285], [3.2265198, 5.513624999999999, 4.3939215], [2.4347358, 1.837875, 2.6651655000000005], [5.7338358000000005, 1.837875, 4.5379845], [4.1634642, 5.513624999999999, 2.1369344999999997], [0.8643642, 5.513624999999999, 0.2641155000000008], [1.1480868, 0.38962949999999996, 4.1105976], [4.4471868, 3.2861205, 3.0925524], [5.4501132000000005, 4.065379500000001, 0.6915024000000001], [2.1510132, 6.961870499999999, 1.7095475999999994], [5.4501132000000005, 6.961870499999999, 0.6915024000000001], [2.1510132, 4.065379500000001, 1.7095475999999994], [1.1480868, 3.2861205, 4.1105976], [4.4471868, 0.38962949999999996, 3.0925524]],
                "lattice_vectors": [[6.5982, 0.0, 0.0], [0.0, 7.3515, 0.0], [0.0, 0.0, 4.8021]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "Tongbaite (Cr<sub>3</sub>C<sub>2</sub>, $D5_{10}$) Structure",
                "Pearsons Symbol": "oP20",
                "Prototype": "C2Cr3",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$D5_{10}$",
                "aflow_prototype_id": "A2B3_oP20_62_2c_3c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_oP20_62_2c_3c.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr"],
                "atom_positions": [[0.5577163199999999, 0.70725, 2.35747545], [3.32416632, 0.70725, 3.37847455], [4.97518368, 2.12175, 9.114424549999999], [2.20873368, 2.12175, 8.09342545], [1.34560128, 0.70725, 10.93960384], [4.112051279999999, 0.70725, 6.2682461599999995], [4.18729872, 2.12175, 0.5322961599999999], [1.4208487200000002, 2.12175, 5.20365384], [0.08686652999999998, 0.70725, 4.60596785], [2.8533165300000003, 0.70725, 1.1299821499999998], [5.44603347, 2.12175, 6.86593215], [2.67958347, 2.12175, 10.34191785], [1.0003483199999998, 0.70725, 8.875809030000001], [3.7667983199999995, 0.70725, 8.33204097], [4.53255168, 2.12175, 2.596090969999999], [1.7661016800000002, 2.12175, 3.1398590300000007], [4.808643389999999, 0.70725, 10.68263328], [2.04219339, 0.70725, 6.5252167199999995], [0.7242566100000001, 2.12175, 0.78926672], [3.4907066099999997, 2.12175, 4.94668328]],
                "lattice_vectors": [[5.5329, 0.0, 0.0], [0.0, 2.829, 0.0], [0.0, 0.0, 11.4719]],
                "normalized_wyckoff_matid": {"c": {"X_0": 3, "X_1": 2}}
            },
            {
                "Notes": "SrH<sub>2</sub> ($C29$) Structure",
                "Pearsons Symbol": "oP12",
                "Prototype": "H2Sr",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$C29$",
                "aflow_prototype_id": "A2B_oP12_62_2c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oP12_62_2c_c.SrH2.html",
                "atom_labels": ["H", "H", "H", "H", "H", "H", "H", "H", "Sr", "Sr", "Sr", "Sr"],
                "atom_positions": [[0.0155, 1.591, 5.565994], [1.953, 1.591, 5.448506], [3.8595, 4.773, 1.7770059999999999], [1.922, 4.773, 1.8944940000000001], [0.9299999999999999, 1.591, 0.5140100000000001], [2.8675, 1.591, 3.15749], [2.945, 4.773, 6.828989999999999], [1.0075, 4.773, 4.185510000000001], [0.9299999999999999, 1.591, 2.86377], [2.8675, 1.591, 0.80773], [2.945, 4.773, 4.47923], [1.0075, 4.773, 6.53527]],
                "lattice_vectors": [[3.875, 0.0, 0.0], [0.0, 6.364, 0.0], [0.0, 0.0, 7.343]],
                "normalized_wyckoff_matid": {"c": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "Westerveldite (FeAs, $B14$) Structure",
                "Pearsons Symbol": "oP8",
                "Prototype": "AsFe",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$B14$",
                "aflow_prototype_id": "AB_oP8_62_c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oP8_62_c_c.FeAs.html",
                "atom_labels": ["As", "As", "As", "As", "Fe", "Fe", "Fe", "Fe"],
                "atom_positions": [[1.093527, 0.83125, 3.4612489], [3.820527, 0.83125, 5.5822511], [4.360473, 2.4937500000000004, 2.5677510999999997], [1.633473, 2.4937500000000004, 0.44674890000000034], [0.03163319999999999, 0.83125, 1.2015797], [2.7586332000000002, 0.83125, 1.8129202999999998], [5.4223668, 2.4937500000000004, 4.8274203], [2.6953667999999995, 2.4937500000000004, 4.2160797]],
                "lattice_vectors": [[5.454, 0.0, 0.0], [0.0, 3.325, 0.0], [0.0, 0.0, 6.029]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "Molybdite (MoO<sub>3</sub>, $D0_{8}$) Structure",
                "Pearsons Symbol": "oP16",
                "Prototype": "MoO3",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$D0_{8}$",
                "aflow_prototype_id": "AB3_oP16_62_c_3c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_oP16_62_c_3c.html",
                "atom_labels": ["Mo", "Mo", "Mo", "Mo", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[5.514290000000001, 0.9241, 1.68419], [12.441790000000001, 0.9241, 0.29721000000000003], [8.34071, 2.7723, 2.27861], [1.4132099999999999, 2.7723, 3.6655900000000003], [1.02527, 0.9241, 3.8597672], [7.952769999999999, 0.9241, 2.0844328], [12.829730000000001, 2.7723, 0.1030328], [5.90223, 2.7723, 1.8783672], [5.73597, 0.9241, 3.7012552], [12.663469999999998, 0.9241, 2.2429448], [8.119030000000002, 2.7723, 0.2615448], [1.1915300000000004, 2.7723, 1.7198552], [3.8239800000000006, 0.9241, 1.941772], [10.75148, 0.9241, 0.03962800000000004], [10.03102, 2.7723, 2.0210280000000003], [3.1035199999999996, 2.7723, 3.923172]],
                "lattice_vectors": [[13.855, 0.0, 0.0], [0.0, 3.6964, 0.0], [0.0, 0.0, 3.9628]],
                "normalized_wyckoff_matid": {"c": {"X_0": 3, "X_1": 1}}
            },
            {
                "Notes": "Cubanite (CuFe<sub>2</sub>S<sub>3</sub>, $E9_{e}$) Structure",
                "Pearsons Symbol": "oP24",
                "Prototype": "CuFe2S3",
                "Space Group Number": 62,
                "Space Group Symbol": "$Pnma$",
                "Strukturbericht Designation": "$E9_{e}$",
                "aflow_prototype_id": "AB2C3_oP24_62_c_d_cd",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2C3_oP24_62_c_d_cd.html",
                "atom_labels": ["Cu", "Cu", "Cu", "Cu", "S", "S", "S", "S", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.766413, 2.77925, 0.5322340999999999], [3.881913, 2.77925, 2.7012659], [5.464587, 8.33775, 5.9347658999999995], [2.349087, 8.33775, 3.7657341], [1.6069749, 2.77925, 2.6689309], [4.7224749, 2.77925, 0.5645690999999999], [4.6240251, 8.33775, 3.7980690999999993], [1.5085251, 8.33775, 5.9024309], [0.8511546, 0.967179, 3.7851351], [3.9666546000000005, 4.591321000000001, 5.915364899999999], [5.3798454, 6.525679, 2.6818648999999994], [2.2643454, 10.149821000000001, 0.5516351000000009], [5.3798454, 10.149821000000001, 2.6818648999999994], [2.2643454, 6.525679, 0.5516351000000009], [0.8511546, 4.591321000000001, 3.7851351], [3.9666546000000005, 0.967179, 5.915364899999999], [1.663677, 0.9404982000000001, 5.897904], [4.779177, 4.6180018, 3.8025959999999994], [4.567323, 6.498998200000001, 0.5690959999999999], [1.4518229999999999, 10.1765018, 2.664404], [4.567323, 10.1765018, 0.5690959999999999], [1.4518229999999999, 6.498998200000001, 2.664404], [1.663677, 4.6180018, 5.897904], [4.779177, 0.9404982000000001, 3.8025959999999994]],
                "lattice_vectors": [[6.231, 0.0, 0.0], [0.0, 11.117, 0.0], [0.0, 0.0, 6.467]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_2": 1}, "d": {"X_0": 2, "X_1": 2}}
            }
        ],
        63: [
            {
                "Notes": "ZrSi<sub>2</sub> (C49) Structure",
                "Pearsons Symbol": "oC12",
                "Prototype": "Si2Zr",
                "Space Group Number": 63,
                "Space Group Symbol": "$Cmcm$",
                "Strukturbericht Designation": "$C49$",
                "aflow_prototype_id": "A2B_oC12_63_2c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oC12_63_2c_c.html",
                "atom_labels": ["Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Zr", "Zr", "Zr", "Zr"],
                "atom_positions": [[0.0, 0.89792, 0.9175], [0.0, 13.822080000000001, 2.7525], [1.865, 8.25792, 0.9175], [1.865, 6.46208, 2.7525], [0.0, 11.040000000000001, 0.9175], [0.0, 3.68, 2.7525], [1.865, 3.68, 0.9175], [1.865, 11.040000000000001, 2.7525], [0.0, 5.8291200000000005, 0.9175], [0.0, 8.89088, 2.7525], [1.865, 13.18912, 0.9175], [1.865, 1.5308799999999998, 2.7525]],
                "lattice_vectors": [[3.73, 0.0, 0.0], [0.0, 14.72, 0.0], [0.0, 0.0, 3.67]],
                "normalized_wyckoff_matid": {"c": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "$\\alpha$&ndash;U (A20) Structure",
                "Pearsons Symbol": "oC4",
                "Prototype": "U",
                "Space Group Number": 63,
                "Space Group Symbol": "$Cmcm$",
                "Strukturbericht Designation": "$A20$",
                "aflow_prototype_id": "A_oC4_63_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_oC4_63_c.html",
                "atom_labels": ["U", "U", "U", "U"],
                "atom_positions": [[0.0, 0.600271092, 1.2329], [0.0, 5.268628908, 3.6987000000000005], [1.4222, 3.5347210920000003, 1.2329], [1.4222, 2.334178908, 3.6987000000000005]],
                "lattice_vectors": [[2.8444, 0.0, 0.0], [0.0, 5.8689, 0.0], [0.0, 0.0, 4.9316]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}}
            },
            {
                "Notes": "CrB (B33) Structure",
                "Pearsons Symbol": "oC8",
                "Prototype": "BCr",
                "Space Group Number": 63,
                "Space Group Symbol": "$Cmcm$",
                "Strukturbericht Designation": "$B33$",
                "aflow_prototype_id": "AB_oC8_63_c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oC8_63_c_c.html",
                "atom_labels": ["B", "B", "B", "B", "Cr", "Cr", "Cr", "Cr"],
                "atom_positions": [[0.0, 3.43132, 0.73365], [0.0, 4.438680000000001, 2.20095], [1.4891, 7.36632, 0.73365], [1.4891, 0.50368, 2.20095], [0.0, 1.1431175, 0.73365], [0.0, 6.7268825, 2.20095], [1.4891, 5.0781175, 0.73365], [1.4891, 2.7918825000000003, 2.20095]],
                "lattice_vectors": [[2.9782, 0.0, 0.0], [0.0, 7.87, 0.0], [0.0, 0.0, 2.9346]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "SrCuO<sub>2</sub> Structure",
                "Pearsons Symbol": "oC16",
                "Prototype": "CuO2Sr",
                "Space Group Number": 63,
                "Space Group Symbol": "$Cmcm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2C_oC16_63_c_2c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2C_oC16_63_c_2c_c.html",
                "atom_labels": ["Cu", "Cu", "Cu", "Cu", "O", "O", "O", "O", "O", "O", "O", "O", "Sr", "Sr", "Sr", "Sr"],
                "atom_positions": [[0.0, 0.9983327799999999, 0.97955], [0.0, 15.343667219999999, 2.93865], [1.7885, 9.16933278, 0.97955], [1.7885, 7.17266722, 2.93865], [0.0, 15.4301164, 0.97955], [0.0, 0.9118836, 2.93865], [1.7885, 7.259116399999999, 0.97955], [1.7885, 9.082883599999999, 2.93865], [0.0, 2.9284863999999997, 0.97955], [0.0, 13.413513599999998, 2.93865], [1.7885, 11.0994864, 0.97955], [1.7885, 5.242513599999999, 2.93865], [0.0, 5.4085483199999995, 0.97955], [0.0, 10.933451680000001, 2.93865], [1.7885, 13.579548319999997, 0.97955], [1.7885, 2.7624516800000003, 2.93865]],
                "lattice_vectors": [[3.577, 0.0, 0.0], [0.0, 16.342, 0.0], [0.0, 0.0, 3.9182]],
                "normalized_wyckoff_matid": {"c": {"X_0": 2, "X_1": 1, "X_2": 1}}
            },
            {
                "Notes": "Post&ndash;perovskite (MgSiO<sub>3</sub>) Structure",
                "Pearsons Symbol": "oC20",
                "Prototype": "MgO3Si",
                "Space Group Number": 63,
                "Space Group Symbol": "$Cmcm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3C_oC20_63_a_cf_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3C_oC20_63_a_cf_c.html",
                "atom_labels": ["Mg", "Mg", "Mg", "Mg", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.0465], [1.228, 4.021, 0.0], [1.228, 4.021, 3.0465], [0.0, 0.619234, 1.52325], [0.0, 7.422766, 4.56975], [1.228, 4.6402339999999995, 1.52325], [1.228, 3.401766, 4.56975], [0.0, 6.0073739999999995, 1.52325], [0.0, 2.034626, 4.56975], [1.228, 1.986373999999999, 1.52325], [1.228, 6.055626, 4.56975], [0.0, 5.074502, 5.703048], [0.0, 2.967498, 0.389952], [0.0, 5.074502, 3.4364520000000005], [0.0, 2.967498, 2.656548], [1.228, 1.053502, 5.703048], [1.228, 6.988498, 0.389952], [1.228, 1.053502, 3.4364520000000005], [1.228, 6.988498, 2.656548]],
                "lattice_vectors": [[2.456, 0.0, 0.0], [0.0, 8.042, 0.0], [0.0, 0.0, 6.093]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 1, "X_2": 1}, "f": {"X_0": 2}}
            },
            {
                "Notes": "Anhydrite (CaSO<sub>4</sub>, $H0_{1}$) Structure",
                "Pearsons Symbol": "oC24",
                "Prototype": "CaO4S",
                "Space Group Number": 63,
                "Space Group Symbol": "$Cmcm$",
                "Strukturbericht Designation": "$H0_{1}$",
                "aflow_prototype_id": "AB4C_oC24_63_c_fg_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4C_oC24_63_c_fg_c.html",
                "atom_labels": ["Ca", "Ca", "Ca", "Ca", "S", "S", "S", "S", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 4.074238, 1.74825], [0.0, 2.1707620000000003, 5.24475], [3.4975, 0.9517380000000006, 1.74825], [3.4975, 5.293262, 5.24475], [0.0, 0.9714722, 1.74825], [0.0, 5.2735278, 5.24475], [3.4975, 4.0939722000000005, 1.74825], [3.4975, 2.1510278, 5.24475], [0.0, 4.3871125, 6.420273300000001], [0.0, 1.8578875, 0.5727267], [0.0, 4.3871125, 4.0692267], [0.0, 1.8578875, 2.9237733], [3.4975, 1.2646125000000008, 6.420273300000001], [3.4975, 4.9803875, 0.5727267], [3.4975, 1.2646125000000008, 4.0692267], [3.4975, 4.9803875, 2.9237733], [1.1884505, 0.101169, 1.74825], [1.1884505, 6.1438310000000005, 5.24475], [5.806549500000001, 0.101169, 1.74825], [5.806549500000001, 6.1438310000000005, 5.24475], [4.6859505, 3.223669, 1.74825], [4.6859505, 3.021331, 5.24475], [2.3090495, 3.223669, 1.74825], [2.3090495, 3.021331, 5.24475]],
                "lattice_vectors": [[6.995, 0.0, 0.0], [0.0, 6.245, 0.0], [0.0, 0.0, 6.993]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1, "X_2": 1}, "f": {"X_0": 2}, "g": {"X_0": 2}}
            },
            {
                "Notes": "Rasvumite (KFe<sub>2</sub>S<sub>3</sub>) Structure",
                "Pearsons Symbol": "oC24",
                "Prototype": "Fe2KS3",
                "Space Group Number": 63,
                "Space Group Symbol": "$Cmcm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BC3_oC24_63_e_c_cg",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC3_oC24_63_e_c_cg.html",
                "atom_labels": ["K", "K", "K", "K", "S", "S", "S", "S", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 7.3816281, 1.35775], [0.0, 3.6373718999999993, 4.07325], [4.5245, 1.8721281000000018, 1.35775], [4.5245, 9.146871899999999, 4.07325], [0.0, 1.3123628999999999, 1.35775], [0.0, 9.7066371, 4.07325], [4.5245, 6.8218629, 1.35775], [4.5245, 4.1971371, 4.07325], [7.693459799999999, 0.0, 0.0], [1.3555402000000003, 0.0, 2.7155], [1.3555402000000003, 0.0, 0.0], [7.693459799999999, 0.0, 2.7155], [3.1689598000000005, 5.5095, 0.0], [5.8800402, 5.5095, 2.7155], [5.8800402, 5.5095, 0.0], [3.1689598000000005, 5.5095, 2.7155], [1.9672526, 4.2522321000000005, 1.35775], [1.9672526, 6.7667679, 4.07325], [7.081747399999999, 4.2522321000000005, 1.35775], [7.081747399999999, 6.7667679, 4.07325], [6.4917526, 9.7617321, 1.35775], [6.4917526, 1.2572678999999998, 4.07325], [2.5572473999999996, 9.7617321, 1.35775], [2.5572473999999996, 1.2572678999999998, 4.07325]],
                "lattice_vectors": [[9.049, 0.0, 0.0], [0.0, 11.019, 0.0], [0.0, 0.0, 5.431]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_2": 1}, "e": {"X_1": 2}, "g": {"X_0": 2}}
            },
            {
                "Notes": "La<sub>43</sub>Ni<sub>17</sub>Mg<sub>5</sub> Structure",
                "Pearsons Symbol": "oC260",
                "Prototype": "La43Mg5Ni17",
                "Space Group Number": 63,
                "Space Group Symbol": "$Cmcm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A43B5C17_oC260_63_c8fg6h_cfg_ce3f2h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A43B5C17_oC260_63_c8fg6h_cfg_ce3f2h.html",
                "atom_labels": ["La", "La", "La", "La", "Mg", "Mg", "Mg", "Mg", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "La", "La", "La", "La", "La", "La", "La", "La", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "La", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni"],
                "atom_positions": [[0.0, 6.865363911999999, 10.5425], [0.0, 10.739036087999999, 31.6275], [5.059475, 15.667563911999999, 10.5425], [5.059475, 1.936836088, 31.6275], [0.0, 0.76051008, 10.5425], [0.0, 16.84388992, 31.6275], [5.059475, 9.562710079999999, 10.5425], [5.059475, 8.04168992, 31.6275], [0.0, 10.539754279999999, 10.5425], [0.0, 7.064645719999999, 31.6275], [5.059475, 1.73755428, 10.5425], [5.059475, 15.866845719999999, 31.6275], [1.290166125, 0.0, 0.0], [8.828783875000001, 0.0, 21.085], [8.828783875000001, 0.0, 0.0], [1.290166125, 0.0, 21.085], [6.349641125, 8.8022, 0.0], [3.769308875, 8.8022, 21.085], [3.769308875, 8.8022, 0.0], [6.349641125, 8.8022, 21.085], [0.0, 2.4632076479999996, 7.3426404000000005], [0.0, 15.141192351999997, 34.8273596], [0.0, 2.4632076479999996, 13.7423596], [0.0, 15.141192351999997, 28.427640400000005], [5.059475, 11.265407648, 7.3426404000000005], [5.059475, 6.338992352, 34.8273596], [5.059475, 11.265407648, 13.7423596], [5.059475, 6.338992352, 28.427640400000005], [0.0, 12.812482319999999, 8.7072616], [0.0, 4.791917679999999, 33.4627384], [0.0, 12.812482319999999, 12.3777384], [0.0, 4.791917679999999, 29.7922616], [5.059475, 4.01028232, 8.7072616], [5.059475, 13.594117679999998, 33.4627384], [5.059475, 4.01028232, 12.3777384], [5.059475, 13.594117679999998, 29.7922616], [0.0, 3.4721158119999993, 26.4119144], [0.0, 14.132284187999998, 15.758085600000001], [0.0, 3.4721158119999993, 36.8430856], [0.0, 14.132284187999998, 5.3269144], [5.059475, 12.274315812, 26.4119144], [5.059475, 5.330084187999999, 15.758085600000001], [5.059475, 12.274315812, 36.8430856], [5.059475, 5.330084187999999, 5.3269144], [0.0, 2.44349072, 1.2161828000000001], [0.0, 15.160909279999998, 40.9538172], [0.0, 2.44349072, 19.868817200000002], [0.0, 15.160909279999998, 22.3011828], [5.059475, 11.245690719999999, 1.2161828000000001], [5.059475, 6.3587092799999985, 40.9538172], [5.059475, 11.245690719999999, 19.868817200000002], [5.059475, 6.3587092799999985, 22.3011828], [0.0, 6.877158859999999, 4.166396], [0.0, 10.72724114, 38.003604], [0.0, 6.877158859999999, 16.918604000000002], [0.0, 10.72724114, 25.251396], [5.059475, 15.679358859999997, 4.166396], [5.059475, 1.9250411399999998, 38.003604], [5.059475, 15.679358859999997, 16.918604000000002], [5.059475, 1.9250411399999998, 25.251396], [0.0, 1.1949866719999997, 23.4334473], [0.0, 16.409413328, 18.7365527], [0.0, 1.1949866719999997, 39.8215527], [0.0, 16.409413328, 2.348447300000001], [5.059475, 9.997186671999998, 23.4334473], [5.059475, 7.607213327999999, 18.7365527], [5.059475, 9.997186671999998, 39.8215527], [5.059475, 7.607213327999999, 2.348447300000001], [0.0, 10.540810543999998, 5.600176], [0.0, 7.063589456, 36.569824], [0.0, 10.540810543999998, 15.484824], [0.0, 7.063589456, 26.685176000000002], [5.059475, 1.738610543999999, 5.600176], [5.059475, 15.865789456, 36.569824], [5.059475, 1.738610543999999, 15.484824], [5.059475, 15.865789456, 26.685176000000002], [0.0, 4.943139475999999, 23.0927137], [0.0, 12.661260524, 19.0772863], [0.0, 4.943139475999999, 40.1622863], [0.0, 12.661260524, 2.0077137000000067], [5.059475, 13.745339475999998, 23.0927137], [5.059475, 3.8590605239999998, 19.0772863], [5.059475, 13.745339475999998, 40.1622863], [5.059475, 3.8590605239999998, 2.0077137000000067], [0.0, 1.1935783199999999, 29.147904000000004], [0.0, 16.410821679999998, 13.022096], [0.0, 1.1935783199999999, 34.107096], [0.0, 16.410821679999998, 8.062904000000001], [5.059475, 9.995778319999998, 29.147904000000004], [5.059475, 7.60862168, 13.022096], [5.059475, 9.995778319999998, 34.107096], [5.059475, 7.60862168, 8.062904000000001], [0.0, 1.3726150679999998, 3.8897608000000004], [0.0, 16.231784932, 38.280239200000004], [0.0, 1.3726150679999998, 17.1952392], [0.0, 16.231784932, 24.974760800000002], [5.059475, 10.174815068, 3.8897608000000004], [5.059475, 7.429584931999999, 38.280239200000004], [5.059475, 10.174815068, 17.1952392], [5.059475, 7.429584931999999, 24.974760800000002], [0.0, 7.981306827999999, 7.063475], [0.0, 9.623093171999999, 35.106525000000005], [0.0, 7.981306827999999, 14.021525], [0.0, 9.623093171999999, 28.148475], [5.059475, 16.783506828, 7.063475], [5.059475, 0.820893172, 35.106525000000005], [5.059475, 16.783506828, 14.021525], [5.059475, 0.820893172, 28.148475], [0.0, 7.595594424, 0.38374700000000006], [0.0, 10.008805576, 41.786253], [0.0, 7.595594424, 20.701253], [0.0, 10.008805576, 21.468747], [5.059475, 16.397794423999997, 0.38374700000000006], [5.059475, 1.2066055759999996, 41.786253], [5.059475, 16.397794423999997, 20.701253], [5.059475, 1.2066055759999996, 21.468747], [1.8828330265000002, 3.595170568, 10.5425], [1.8828330265000002, 14.009229431999998, 31.6275], [8.2361169735, 3.595170568, 10.5425], [8.2361169735, 14.009229431999998, 31.6275], [6.942308026499999, 12.397370568, 10.5425], [6.942308026499999, 5.207029432, 31.6275], [3.1766419734999998, 12.397370568, 10.5425], [3.1766419734999998, 5.207029432, 31.6275], [3.3777055099999997, 6.64390056, 10.5425], [3.3777055099999997, 10.96049944, 31.6275], [6.74124449, 6.64390056, 10.5425], [6.74124449, 10.96049944, 31.6275], [8.43718051, 15.446100559999998, 10.5425], [8.43718051, 2.1582994399999995, 31.6275], [1.6817694900000002, 15.446100559999998, 10.5425], [1.6817694900000002, 2.1582994399999995, 31.6275], [1.905195906, 5.791495511999999, 7.33758], [1.905195906, 11.812904487999997, 34.832420000000006], [8.213754094, 5.791495511999999, 13.747420000000002], [8.213754094, 11.812904487999997, 28.42258], [8.213754094, 11.812904487999997, 34.832420000000006], [8.213754094, 5.791495511999999, 7.33758], [1.905195906, 11.812904487999997, 28.42258], [1.905195906, 5.791495511999999, 13.747420000000002], [6.964670906, 14.593695512, 7.33758], [6.964670906, 3.010704488, 34.832420000000006], [3.154279094, 14.593695512, 13.747420000000002], [3.154279094, 3.010704488, 28.42258], [3.154279094, 3.010704488, 34.832420000000006], [3.154279094, 14.593695512, 7.33758], [6.964670906, 3.010704488, 28.42258], [6.964670906, 14.593695512, 13.747420000000002], [1.957409688, 3.5455261599999996, 4.2688691], [1.957409688, 14.058873839999999, 37.9011309], [8.161540312, 3.5455261599999996, 16.8161309], [8.161540312, 14.058873839999999, 25.353869100000004], [8.161540312, 14.058873839999999, 37.9011309], [8.161540312, 3.5455261599999996, 4.2688691], [1.957409688, 14.058873839999999, 25.353869100000004], [1.957409688, 3.5455261599999996, 16.8161309], [7.016884688, 12.347726159999999, 4.2688691], [7.016884688, 5.2566738399999995, 37.9011309], [3.102065312, 12.347726159999999, 16.8161309], [3.102065312, 5.2566738399999995, 25.353869100000004], [3.102065312, 5.2566738399999995, 37.9011309], [3.102065312, 12.347726159999999, 4.2688691], [7.016884688, 5.2566738399999995, 25.353869100000004], [7.016884688, 12.347726159999999, 16.8161309], [3.1096545245000002, 0.6159779559999999, 8.7102135], [3.1096545245000002, 16.988422044, 33.4597865], [7.0092954755, 0.6159779559999999, 12.3747865], [7.0092954755, 16.988422044, 29.795213500000003], [7.0092954755, 16.988422044, 33.4597865], [7.0092954755, 0.6159779559999999, 8.7102135], [3.1096545245000002, 16.988422044, 29.795213500000003], [3.1096545245000002, 0.6159779559999999, 12.3747865], [8.169129524499999, 9.418177956, 8.7102135], [8.169129524499999, 8.186222043999999, 33.4597865], [1.9498204754999997, 9.418177956, 12.3747865], [1.9498204754999997, 8.186222043999999, 29.795213500000003], [1.9498204754999997, 8.186222043999999, 33.4597865], [1.9498204754999997, 9.418177956, 8.7102135], [8.169129524499999, 8.186222043999999, 29.795213500000003], [8.169129524499999, 9.418177956, 12.3747865], [3.0857738025, 8.731078223999999, 5.3475777], [3.0857738025, 8.873321776, 36.8224223], [7.0331761975, 8.731078223999999, 15.737422300000002], [7.0331761975, 8.873321776, 26.4325777], [7.0331761975, 8.873321776, 36.8224223], [7.0331761975, 8.731078223999999, 5.3475777], [3.0857738025, 8.873321776, 26.4325777], [3.0857738025, 8.731078223999999, 15.737422300000002], [8.145248802500001, 17.533278223999996, 5.3475777], [8.145248802500001, 0.07112177599999979, 36.8224223], [1.9737011975, 17.533278223999996, 15.737422300000002], [1.9737011975, 0.07112177599999979, 26.4325777], [1.9737011975, 0.07112177599999979, 36.8224223], [1.9737011975, 17.533278223999996, 5.3475777], [8.145248802500001, 0.07112177599999979, 26.4325777], [8.145248802500001, 17.533278223999996, 15.737422300000002], [1.981088031, 5.812620791999999, 1.09642], [1.981088031, 11.791779208, 41.07358], [8.137861969, 5.812620791999999, 19.98858], [8.137861969, 11.791779208, 22.181420000000003], [8.137861969, 11.791779208, 41.07358], [8.137861969, 5.812620791999999, 1.09642], [1.981088031, 11.791779208, 22.181420000000003], [1.981088031, 5.812620791999999, 19.98858], [7.0405630310000005, 14.614820791999998, 1.09642], [7.0405630310000005, 2.9895792080000003, 41.07358], [3.078386969, 14.614820791999998, 19.98858], [3.078386969, 2.9895792080000003, 22.181420000000003], [3.078386969, 2.9895792080000003, 41.07358], [3.078386969, 14.614820791999998, 1.09642], [7.0405630310000005, 2.9895792080000003, 22.181420000000003], [7.0405630310000005, 14.614820791999998, 19.98858], [3.2074035814999995, 0.6131612519999999, 1.9069274000000003], [3.2074035814999995, 16.991238747999997, 40.2630726], [6.9115464185, 0.6131612519999999, 19.1780726], [6.9115464185, 16.991238747999997, 22.9919274], [6.9115464185, 16.991238747999997, 40.2630726], [6.9115464185, 0.6131612519999999, 1.9069274000000003], [3.2074035814999995, 16.991238747999997, 22.9919274], [3.2074035814999995, 0.6131612519999999, 19.1780726], [8.2668785815, 9.415361252, 1.9069274000000003], [8.2668785815, 8.189038747999998, 40.2630726], [1.8520714185000002, 9.415361252, 19.1780726], [1.8520714185000002, 8.189038747999998, 22.9919274], [1.8520714185000002, 8.189038747999998, 40.2630726], [1.8520714185000002, 9.415361252, 1.9069274000000003], [8.2668785815, 8.189038747999998, 22.9919274], [8.2668785815, 9.415361252, 19.1780726], [2.84544874, 3.030245372, 7.096367600000001], [2.84544874, 14.574154627999999, 35.0736324], [7.27350126, 3.030245372, 13.988632400000002], [7.27350126, 14.574154627999999, 28.1813676], [7.27350126, 14.574154627999999, 35.0736324], [7.27350126, 3.030245372, 7.096367600000001], [2.84544874, 14.574154627999999, 28.1813676], [2.84544874, 3.030245372, 13.988632400000002], [7.90492374, 11.832445371999999, 7.096367600000001], [7.90492374, 5.771954628, 35.0736324], [2.21402626, 11.832445371999999, 13.988632400000002], [2.21402626, 5.771954628, 28.1813676], [2.21402626, 5.771954628, 35.0736324], [2.21402626, 11.832445371999999, 7.096367600000001], [7.90492374, 5.771954628, 28.1813676], [7.90492374, 11.832445371999999, 13.988632400000002], [2.840389265, 6.326317184, 3.8235539000000003], [2.840389265, 11.278082816, 38.3464461], [7.278560735, 6.326317184, 17.2614461], [7.278560735, 11.278082816, 24.9085539], [7.278560735, 11.278082816, 38.3464461], [7.278560735, 6.326317184, 3.8235539000000003], [2.840389265, 11.278082816, 24.9085539], [2.840389265, 6.326317184, 17.2614461], [7.899864265, 15.128517183999998, 3.8235539000000003], [7.899864265, 2.4758828159999995, 38.3464461], [2.2190857349999997, 15.128517183999998, 17.2614461], [2.2190857349999997, 2.4758828159999995, 24.9085539], [2.2190857349999997, 2.4758828159999995, 38.3464461], [2.2190857349999997, 15.128517183999998, 3.8235539000000003], [7.899864265, 2.4758828159999995, 24.9085539], [7.899864265, 15.128517183999998, 17.2614461]],
                "lattice_vectors": [[10.11895, 0.0, 0.0], [0.0, 17.6044, 0.0], [0.0, 0.0, 42.17]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1, "X_2": 1}, "e": {"X_1": 2}, "f": {"X_0": 16, "X_1": 6, "X_2": 2}, "g": {"X_0": 2, "X_2": 2}, "h": {"X_0": 24, "X_1": 8}}
            },
            {
                "Notes": "MnAl<sub>6</sub> ($D2_{h}$) Structure",
                "Pearsons Symbol": "oC28",
                "Prototype": "Al6Mn",
                "Space Group Number": 63,
                "Space Group Symbol": "$Cmcm$",
                "Strukturbericht Designation": "$D2_{h}$",
                "aflow_prototype_id": "A6B_oC28_63_efg_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A6B_oC28_63_efg_c.html",
                "atom_labels": ["Mn", "Mn", "Mn", "Mn", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al"],
                "atom_positions": [[0.0, 2.969315884, 2.2181], [0.0, 3.5300841159999994, 6.654300000000001], [3.77755, 6.219015884, 2.2181], [3.77755, 0.28038411600000007, 6.654300000000001], [2.463113702, 0.0, 0.0], [5.091986298, 0.0, 4.4362], [5.091986298, 0.0, 0.0], [2.463113702, 0.0, 4.4362], [6.240663702, 3.2497, 0.0], [1.3144362980000002, 3.2497, 4.4362], [1.3144362980000002, 3.2497, 0.0], [6.240663702, 3.2497, 4.4362], [0.0, 0.9045214979999999, 0.890700236], [0.0, 5.594878501999999, 7.981699764000001], [0.0, 0.9045214979999999, 3.5454997640000006], [0.0, 5.594878501999999, 5.326900236], [3.77755, 4.154221498, 0.890700236], [3.77755, 2.3451785019999996, 7.981699764000001], [3.77755, 4.154221498, 3.5454997640000006], [3.77755, 2.3451785019999996, 5.326900236], [2.4001041680000004, 1.8602582679999997, 2.2181], [2.4001041680000004, 4.639141732000001, 6.654300000000001], [5.154995832000001, 1.8602582679999997, 2.2181], [5.154995832000001, 4.639141732000001, 6.654300000000001], [6.177654168, 5.109958267999999, 2.2181], [6.177654168, 1.389441732, 6.654300000000001], [1.377445832, 5.109958267999999, 2.2181], [1.377445832, 1.389441732, 6.654300000000001]],
                "lattice_vectors": [[7.5551, 0.0, 0.0], [0.0, 6.4994, 0.0], [0.0, 0.0, 8.8724]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "e": {"X_0": 2}, "f": {"X_0": 2}, "g": {"X_0": 2}}
            },
            {
                "Notes": "MgSO<sub>4</sub> Structure",
                "Pearsons Symbol": "oC24",
                "Prototype": "MgOS",
                "Space Group Number": 63,
                "Space Group Symbol": "$Cmcm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB4C_oC24_63_a_fg_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4C_oC24_63_a_fg_c.html",
                "atom_labels": ["Mg", "Mg", "Mg", "Mg", "S", "S", "S", "S", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.253], [2.591, 3.9465, 0.0], [2.591, 3.9465, 3.253], [0.0, 2.92041, 1.6265], [0.0, 4.97259, 4.8795], [2.591, 6.86691, 1.6265], [2.591, 1.02609, 4.8795], [0.0, 1.97325, 0.39036], [0.0, 5.91975, 6.11564], [0.0, 1.97325, 2.8626400000000003], [0.0, 5.91975, 3.6433600000000004], [2.591, 5.91975, 0.39036], [2.591, 1.97325, 6.11564], [2.591, 5.91975, 2.8626400000000003], [2.591, 1.97325, 3.6433600000000004], [1.2955, 3.70971, 1.6265], [1.2955, 4.18329, 4.8795], [3.8865000000000003, 3.70971, 1.6265], [3.8865000000000003, 4.18329, 4.8795], [3.8865000000000003, 7.65621, 1.6265], [3.8865000000000003, 0.2367900000000002, 4.8795], [1.2955, 7.65621, 1.6265], [1.2955, 0.2367900000000002, 4.8795]],
                "lattice_vectors": [[5.182, 0.0, 0.0], [0.0, 7.893, 0.0], [0.0, 0.0, 6.506]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_2": 1}, "f": {"X_0": 2}, "g": {"X_0": 2}}
            }
        ],
        64: [
            {
                "Notes": "$\\alpha$&ndash;Ga (A11) Structure",
                "Pearsons Symbol": "oC8",
                "Prototype": "Ga",
                "Space Group Number": 64,
                "Space Group Symbol": "$Cmca$",
                "Strukturbericht Designation": "$A11$",
                "aflow_prototype_id": "A_oC8_64_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_oC8_64_f.alpha-Ga.html",
                "atom_labels": ["Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga"],
                "atom_positions": [[0.0, 1.1866889, 0.366444], [0.0, 6.4743110999999995, 4.1575560000000005], [2.2615, 1.1866889, 1.895556], [2.2615, 6.4743110999999995, 2.628444], [2.2615, 5.0171889, 0.366444], [2.2615, 2.6438110999999997, 4.1575560000000005], [0.0, 5.0171889, 1.895556], [0.0, 2.6438110999999997, 2.628444]],
                "lattice_vectors": [[4.523, 0.0, 0.0], [0.0, 7.661, 0.0], [0.0, 0.0, 4.524]],
                "normalized_wyckoff_matid": {"f": {"X_0": 1}}
            },
            {
                "Notes": "MgB<sub>2</sub>C<sub>2</sub> Crystal Structure",
                "Pearsons Symbol": "oC80",
                "Prototype": "B2C2Mg",
                "Space Group Number": 64,
                "Space Group Symbol": "$Cmca$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B2C_oC80_64_efg_efg_df",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B2C_oC80_64_efg_efg_df.html",
                "atom_labels": ["Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "B", "B", "B", "B", "B", "B", "B", "B", "C", "C", "C", "C", "C", "C", "C", "C", "B", "B", "B", "B", "B", "B", "B", "B", "C", "C", "C", "C", "C", "C", "C", "C", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C"],
                "atom_positions": [[9.246237540000001, 0.0, 0.0], [7.13676246, 0.0, 3.7295], [1.6757624599999996, 0.0, 0.0], [3.7852375400000007, 0.0, 3.7295], [3.7852375400000007, 4.7305, 0.0], [1.6757624599999996, 4.7305, 3.7295], [7.13676246, 4.7305, 0.0], [9.246237540000001, 4.7305, 3.7295], [2.7305, 0.8950106000000001, 1.86475], [2.7305, 8.5659894, 5.59425], [8.191500000000001, 8.5659894, 5.59425], [8.191500000000001, 0.8950106000000001, 1.86475], [8.191500000000001, 5.6255106, 1.86475], [8.191500000000001, 3.8354894, 5.59425], [2.7305, 3.8354894, 5.59425], [2.7305, 5.6255106, 1.86475], [2.7305, 8.771293100000001, 1.86475], [2.7305, 0.6897068999999997, 5.59425], [8.191500000000001, 0.6897068999999997, 5.59425], [8.191500000000001, 8.771293100000001, 1.86475], [8.191500000000001, 4.0407931, 1.86475], [8.191500000000001, 5.4202069, 5.59425], [2.7305, 5.4202069, 5.59425], [2.7305, 4.0407931, 1.86475], [0.0, 5.5687446000000005, 2.058684], [0.0, 3.8922554, 5.400315999999999], [5.461, 5.5687446000000005, 1.6708159999999996], [5.461, 3.8922554, 5.788184], [5.461, 0.8382446000000001, 2.058684], [5.461, 8.6227554, 5.400315999999999], [0.0, 0.8382446000000001, 1.6708159999999996], [0.0, 8.6227554, 5.788184], [0.0, 8.7116888, 1.7260125999999998], [0.0, 0.7493112000000001, 5.732987399999999], [5.461, 8.7116888, 2.0034874], [5.461, 0.7493112000000001, 5.4555126000000005], [5.461, 3.9811888000000004, 1.7260125999999998], [5.461, 5.4798112, 5.732987399999999], [0.0, 3.9811888000000004, 2.0034874], [0.0, 5.4798112, 5.4555126000000005], [0.0, 2.6472824100000003, 7.3747133], [0.0, 6.81371759, 0.08428669999999999], [5.461, 2.6472824100000003, 3.8137866999999996], [5.461, 6.81371759, 3.6452133], [5.461, 7.37778241, 7.3747133], [5.461, 2.08321759, 0.08428669999999999], [0.0, 7.37778241, 3.8137866999999996], [0.0, 2.08321759, 3.6452133], [1.3958316, 3.2309315000000005, 1.8185041999999998], [1.3958316, 6.2300685, 5.640495799999999], [4.0651684, 3.2309315000000005, 1.9109957999999998], [4.0651684, 6.2300685, 5.5480042], [9.5261684, 6.2300685, 5.640495799999999], [9.5261684, 3.2309315000000005, 1.8185041999999998], [6.8568316000000005, 6.2300685, 5.5480042], [6.8568316000000005, 3.2309315000000005, 1.9109957999999998], [6.8568316000000005, 7.961431500000001, 1.8185041999999998], [6.8568316000000005, 1.4995684999999999, 5.640495799999999], [9.5261684, 7.961431500000001, 1.9109957999999998], [9.5261684, 1.4995684999999999, 5.5480042], [4.0651684, 1.4995684999999999, 5.640495799999999], [4.0651684, 7.961431500000001, 1.8185041999999998], [1.3958316, 1.4995684999999999, 5.5480042], [1.3958316, 7.961431500000001, 1.9109957999999998], [1.3597890000000001, 1.655675, 1.6641028999999998], [1.3597890000000001, 7.805325, 5.7948971], [4.101211, 1.655675, 2.0653971], [4.101211, 7.805325, 5.393602899999999], [9.562211, 7.805325, 5.7948971], [9.562211, 1.655675, 1.6641028999999998], [6.820789000000001, 7.805325, 5.393602899999999], [6.820789000000001, 1.655675, 2.0653971], [6.820789000000001, 6.386175000000001, 1.6641028999999998], [6.820789000000001, 3.074825, 5.7948971], [9.562211, 6.386175000000001, 2.0653971], [9.562211, 3.074825, 5.393602899999999], [4.101211, 3.074825, 5.7948971], [4.101211, 6.386175000000001, 1.6641028999999998], [1.3597890000000001, 3.074825, 5.393602899999999], [1.3597890000000001, 6.386175000000001, 2.0653971]],
                "lattice_vectors": [[10.922, 0.0, 0.0], [0.0, 9.461, 0.0], [0.0, 0.0, 7.459]],
                "normalized_wyckoff_matid": {"d": {"X_2": 1}, "e": {"X_0": 1, "X_1": 1}, "f": {"X_0": 1, "X_1": 1, "X_2": 1}, "g": {"X_0": 2, "X_1": 2}}
            },
            {
                "Notes": "Black Phosphorus (A17) Crystal Structure",
                "Pearsons Symbol": "oC8",
                "Prototype": "P",
                "Space Group Number": 64,
                "Space Group Symbol": "$Cmca$",
                "Strukturbericht Designation": "$A17$",
                "aflow_prototype_id": "A_oC8_64_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_oC8_64_f.P.html",
                "atom_labels": ["P", "P", "P", "P", "P", "P", "P", "P"],
                "atom_positions": [[0.0, 1.06540304, 0.352554728], [0.0, 9.41259696, 4.023745272], [1.6568, 1.06540304, 1.8355952719999997], [1.6568, 9.41259696, 2.5407047279999997], [1.6568, 6.3044030399999995, 0.352554728], [1.6568, 4.17359696, 4.023745272], [0.0, 6.3044030399999995, 1.8355952719999997], [0.0, 4.17359696, 2.5407047279999997]],
                "lattice_vectors": [[3.3136, 0.0, 0.0], [0.0, 10.478, 0.0], [0.0, 0.0, 4.3763]],
                "normalized_wyckoff_matid": {"f": {"X_0": 1}}
            },
            {
                "Notes": "H<sub>2</sub>S (170 GPa) Structure",
                "Pearsons Symbol": "oC24",
                "Prototype": "H2S",
                "Space Group Number": 64,
                "Space Group Symbol": "$Cmca$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_oC24_64_2f_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oC24_64_2f_f.html",
                "atom_labels": ["H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 1.6097928, 2.0521350000000003], [0.0, 2.7176072, 5.548365], [1.4993, 1.6097928, 1.7481149999999999], [1.4993, 2.7176072, 5.852385], [1.4993, 3.7734928, 2.0521350000000003], [1.4993, 0.5539072, 5.548365], [0.0, 3.7734928, 1.7481149999999999], [0.0, 0.5539072, 5.852385], [0.0, 2.59644, 0.699246], [0.0, 1.73096, 6.901254000000001], [1.4993, 2.59644, 3.1010040000000005], [1.4993, 1.73096, 4.499496], [1.4993, 0.4327400000000004, 0.699246], [1.4993, 3.89466, 6.901254000000001], [0.0, 0.4327400000000004, 3.1010040000000005], [0.0, 3.89466, 4.499496], [0.0, 1.6054654, 4.6743075], [0.0, 2.7219346, 2.9261925], [1.4993, 1.6054654, 6.7264425], [1.4993, 2.7219346, 0.8740574999999999], [1.4993, 3.7691654, 4.6743075], [1.4993, 0.5582346, 2.9261925], [0.0, 3.7691654, 6.7264425], [0.0, 0.5582346, 0.8740574999999999]],
                "lattice_vectors": [[2.9986, 0.0, 0.0], [0.0, 4.3274, 0.0], [0.0, 0.0, 7.6005]],
                "normalized_wyckoff_matid": {"f": {"X_0": 2, "X_1": 1}}
            }
        ],
        65: [
            {
                "Notes": "Predicted CdPt<sub>3</sub> (<q>L1<sub>3</sub></q>) Structure",
                "Pearsons Symbol": "oC8",
                "Prototype": "CdPt3",
                "Space Group Number": 65,
                "Space Group Symbol": "$Cmmm$",
                "Strukturbericht Designation": "$L1_{3}$",
                "aflow_prototype_id": "AB3_oC8_65_a_bf",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_oC8_65_a_bf.html",
                "atom_labels": ["Cd", "Cd", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.91034, 3.936515, 0.0], [2.91034, 0.0, 0.0], [0.0, 3.936515, 0.0], [1.45517, 1.9682575, 1.436275], [1.45517, 5.9047725, 1.436275], [4.3655100000000004, 1.9682575, 1.436275], [4.3655100000000004, 5.9047725, 1.436275]],
                "lattice_vectors": [[5.82068, 0.0, 0.0], [0.0, 7.87303, 0.0], [0.0, 0.0, 2.87255]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_0": 1}, "f": {"X_0": 2}}
            },
            {
                "Notes": "$\\alpha$&ndash;IrV Crystal Structure",
                "Pearsons Symbol": "oC8",
                "Prototype": "IrV",
                "Space Group Number": 65,
                "Space Group Symbol": "$Cmmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_oC8_65_j_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oC8_65_j_g.html",
                "atom_labels": ["V", "V", "V", "V", "Ir", "Ir", "Ir", "Ir"],
                "atom_positions": [[1.6718800000000003, 0.0, 0.0], [4.29912, 0.0, 0.0], [4.65738, 3.378, 0.0], [1.3136199999999998, 3.378, 0.0], [0.0, 1.48632, 1.398], [0.0, 5.26968, 1.398], [2.9855, 4.86432, 1.398], [2.9855, 1.8916800000000003, 1.398]],
                "lattice_vectors": [[5.971, 0.0, 0.0], [0.0, 6.756, 0.0], [0.0, 0.0, 2.796]],
                "normalized_wyckoff_matid": {"g": {"X_0": 1}, "j": {"X_1": 1}}
            },
            {
                "Notes": "Ga<sub>3</sub>Pt<sub>5</sub> Structure",
                "Pearsons Symbol": "oC16",
                "Prototype": "Ga3Pt5",
                "Space Group Number": 65,
                "Space Group Symbol": "$Cmmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B5_oC16_65_ah_bej",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B5_oC16_65_ah_bej.html",
                "atom_labels": ["Ga", "Ga", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Ga", "Ga", "Ga", "Ga", "Pt", "Pt", "Pt", "Pt"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.0155, 3.72, 0.0], [4.0155, 0.0, 0.0], [0.0, 3.72, 0.0], [2.00775, 1.86, 0.0], [2.00775, 5.58, 0.0], [6.023250000000001, 1.86, 0.0], [6.023250000000001, 5.58, 0.0], [2.00775, 0.0, 1.974], [6.023250000000001, 0.0, 1.974], [6.023250000000001, 3.72, 1.974], [2.00775, 3.72, 1.974], [0.0, 1.6740000000000002, 1.974], [0.0, 5.766000000000001, 1.974], [4.0155, 5.394, 1.974], [4.0155, 2.0460000000000003, 1.974]],
                "lattice_vectors": [[8.031, 0.0, 0.0], [0.0, 7.44, 0.0], [0.0, 0.0, 3.948]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_0": 1}, "e": {"X_0": 2}, "h": {"X_0": 2}, "j": {"X_1": 2}}
            }
        ],
        66: [
            {
                "Notes": "SrAl<sub>2</sub>Se<sub>4</sub> Structure",
                "Pearsons Symbol": "oC28",
                "Prototype": "Al2Se4Sr",
                "Space Group Number": 66,
                "Space Group Symbol": "$Cccm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B4C_oC28_66_l_kl_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B4C_oC28_66_l_kl_a.html",
                "atom_labels": ["Sr", "Sr", "Sr", "Sr", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se"],
                "atom_positions": [[0.0, 0.0, 2.712525561825], [0.0, 0.0, 8.137576685475], [3.13502954335, 5.4100509823, 2.712525561825], [3.13502954335, 5.4100509823, 8.137576685475], [1.567514771675, 2.70502549115, 9.0381351720009], [1.567514771675, 8.11507647345, 7.237018198949101], [4.7025443150249995, 2.70502549115, 7.237018198949101], [4.7025443150249995, 8.11507647345, 9.0381351720009], [4.7025443150249995, 8.11507647345, 1.8119670752991006], [4.7025443150249995, 2.70502549115, 3.6130840483509], [1.567514771675, 8.11507647345, 3.6130840483509], [1.567514771675, 2.70502549115, 1.8119670752991006], [0.0313502954335, 2.8997873265128, 0.0], [0.0313502954335, 7.920314638087199, 5.42505112365], [6.2387087912665, 2.8997873265128, 5.42505112365], [6.2387087912665, 7.920314638087199, 0.0], [3.1663798387835, 8.3098383088128, 0.0], [3.1663798387835, 2.5102636557872, 5.42505112365], [3.1036792479165, 8.3098383088128, 5.42505112365], [3.1036792479165, 2.5102636557872, 0.0], [4.6210335468979, 4.544442825131999, 0.0], [4.6210335468979, 6.275659139468, 5.42505112365], [1.6490255398021, 4.544442825131999, 5.42505112365], [1.6490255398021, 6.275659139468, 0.0], [1.4860040035479005, 9.954493807431998, 0.0], [1.4860040035479005, 0.8656081571680001, 5.42505112365], [4.7840550831521, 9.954493807431998, 5.42505112365], [4.7840550831521, 0.8656081571680001, 0.0]],
                "lattice_vectors": [[6.2700590867, 0.0, 0.0], [0.0, 10.8201019646, 0.0], [0.0, 0.0, 10.8501022473]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "k": {"X_0": 2}, "l": {"X_0": 2, "X_1": 2}}
            },
            {
                "Notes": "$\\beta$&ndash;ThI<sub>3</sub> Structure",
                "Pearsons Symbol": "oC64",
                "Prototype": "I3Th",
                "Space Group Number": 66,
                "Space Group Symbol": "$Cccm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_oC64_66_kl2m_bdl",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_oC64_66_kl2m_bdl.html",
                "atom_labels": ["Th", "Th", "Th", "Th", "Th", "Th", "Th", "Th", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "Th", "Th", "Th", "Th", "Th", "Th", "Th", "Th", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I"],
                "atom_positions": [[0.0, 10.1485, 3.66525], [0.0, 10.1485, 10.99575], [4.3675, 0.0, 3.66525], [4.3675, 0.0, 10.99575], [0.0, 10.1485, 0.0], [0.0, 10.1485, 7.3305], [4.3675, 0.0, 0.0], [4.3675, 0.0, 7.3305], [2.18375, 5.07425, 2.6770986], [2.18375, 15.222750000000001, 4.6534014], [6.55125, 5.07425, 4.6534014], [6.55125, 15.222750000000001, 2.6770986], [6.55125, 15.222750000000001, 11.9839014], [6.55125, 5.07425, 10.0075986], [2.18375, 15.222750000000001, 10.0075986], [2.18375, 5.07425, 11.9839014], [8.457227, 4.0472218, 0.0], [8.457227, 16.2497782, 7.3305], [0.277773, 4.0472218, 7.3305], [0.277773, 16.2497782, 0.0], [4.089727, 14.195721800000001, 0.0], [4.089727, 6.101278199999999, 7.3305], [4.645273, 14.195721800000001, 7.3305], [4.645273, 6.101278199999999, 0.0], [2.856345, 3.4829652, 0.0], [2.856345, 16.8140348, 7.3305], [5.878655, 3.4829652, 7.3305], [5.878655, 16.8140348, 0.0], [7.223844999999999, 13.6314652, 0.0], [7.223844999999999, 6.6655348000000005, 7.3305], [1.5111549999999998, 13.6314652, 7.3305], [1.5111549999999998, 6.6655348000000005, 0.0], [2.5279089999999997, 9.153947, 1.9088622000000002], [2.5279089999999997, 11.143052999999998, 5.4216378], [6.207090999999999, 9.153947, 5.4216378], [6.207090999999999, 11.143052999999998, 1.9088622000000002], [6.207090999999999, 11.143052999999998, 12.7521378], [6.207090999999999, 9.153947, 9.239362199999999], [2.5279089999999997, 11.143052999999998, 9.239362199999999], [2.5279089999999997, 9.153947, 12.7521378], [6.895409, 19.302447, 1.9088622000000002], [6.895409, 0.9945529999999998, 5.4216378], [1.839591, 19.302447, 5.4216378], [1.839591, 0.9945529999999998, 1.9088622000000002], [1.839591, 0.9945529999999998, 12.7521378], [1.839591, 19.302447, 9.239362199999999], [6.895409, 0.9945529999999998, 9.239362199999999], [6.895409, 19.302447, 12.7521378], [0.9896754999999999, 7.658058100000001, 5.4362988], [0.9896754999999999, 12.6389419, 1.8942011999999997], [7.7453245, 7.658058100000001, 1.8942011999999997], [7.7453245, 12.6389419, 5.4362988], [7.7453245, 12.6389419, 9.2247012], [7.7453245, 7.658058100000001, 12.7667988], [0.9896754999999999, 12.6389419, 12.7667988], [0.9896754999999999, 7.658058100000001, 9.2247012], [5.357175499999999, 17.8065581, 5.4362988], [5.357175499999999, 2.4904418999999995, 1.8942011999999997], [3.3778244999999996, 17.8065581, 1.8942011999999997], [3.3778244999999996, 2.4904418999999995, 5.4362988], [3.3778244999999996, 2.4904418999999995, 9.2247012], [3.3778244999999996, 17.8065581, 12.7667988], [5.357175499999999, 2.4904418999999995, 12.7667988], [5.357175499999999, 17.8065581, 9.2247012]],
                "lattice_vectors": [[8.735, 0.0, 0.0], [0.0, 20.297, 0.0], [0.0, 0.0, 14.661]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_1": 1}, "k": {"X_0": 2}, "l": {"X_0": 2, "X_1": 2}, "m": {"X_0": 8}}
            },
            {
                "Notes": "H<sub>3</sub>S (60 GPa) Structure",
                "Pearsons Symbol": "oC64",
                "Prototype": "H3S",
                "Space Group Number": 66,
                "Space Group Symbol": "$Cccm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_oC64_66_gi2lm_2l",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_oC64_66_gi2lm_2l.html",
                "atom_labels": ["H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[4.44980664, 0.0, 1.2075], [3.7071933599999998, 0.0, 1.2075], [3.7071933599999998, 0.0, 3.6225], [4.44980664, 0.0, 3.6225], [0.37130664, 4.0905, 1.2075], [7.78569336, 4.0905, 1.2075], [7.78569336, 4.0905, 3.6225], [0.37130664, 4.0905, 3.6225], [0.0, 0.0, 1.587621], [0.0, 0.0, 0.8273790000000001], [0.0, 0.0, 3.242379], [0.0, 0.0, 4.002621], [4.0785, 4.0905, 1.587621], [4.0785, 4.0905, 0.8273790000000001], [4.0785, 4.0905, 3.242379], [4.0785, 4.0905, 4.002621], [3.20537472, 1.3208224499999999, 0.0], [3.20537472, 6.8601775499999995, 2.415], [4.95162528, 1.3208224499999999, 2.415], [4.95162528, 6.8601775499999995, 0.0], [7.28387472, 5.411322449999999, 0.0], [7.28387472, 2.76967755, 2.415], [0.8731252800000002, 5.411322449999999, 2.415], [0.8731252800000002, 2.76967755, 0.0], [2.76008409, 7.284280589999999, 0.0], [2.76008409, 0.8967194099999998, 2.415], [5.39691591, 7.284280589999999, 2.415], [5.39691591, 0.8967194099999998, 0.0], [6.83858409, 3.19378059, 0.0], [6.83858409, 4.98721941, 2.415], [1.31841591, 3.19378059, 2.415], [1.31841591, 4.98721941, 0.0], [1.9687735199999998, 0.64441737, 0.0], [1.9687735199999998, 7.536582629999999, 2.415], [6.18822648, 0.64441737, 2.415], [6.18822648, 7.536582629999999, 0.0], [6.04727352, 4.73491737, 0.0], [6.04727352, 3.44608263, 2.415], [2.10972648, 4.73491737, 2.415], [2.10972648, 3.44608263, 0.0], [3.45342909, 6.067929509999999, 0.0], [3.45342909, 2.11307049, 2.415], [4.70357091, 6.067929509999999, 2.415], [4.70357091, 2.11307049, 0.0], [7.53192909, 1.9774295099999988, 0.0], [7.53192909, 6.20357049, 2.415], [0.6250709099999998, 1.9774295099999988, 2.415], [0.6250709099999998, 6.20357049, 0.0], [2.7150574499999998, 5.46474438, 1.2049884], [2.7150574499999998, 2.7162556199999996, 1.2100115999999999], [5.44194255, 5.46474438, 1.2100115999999999], [5.44194255, 2.7162556199999996, 1.2049884], [5.44194255, 2.7162556199999996, 3.6250115999999997], [5.44194255, 5.46474438, 3.6199884000000004], [2.7150574499999998, 2.7162556199999996, 3.6199884000000004], [2.7150574499999998, 5.46474438, 3.6250115999999997], [6.79355745, 1.37424438, 1.2049884], [6.79355745, 6.806755619999999, 1.2100115999999999], [1.3634425500000003, 1.37424438, 1.2100115999999999], [1.3634425500000003, 6.806755619999999, 1.2049884], [1.3634425500000003, 6.806755619999999, 3.6250115999999997], [1.3634425500000003, 1.37424438, 3.6199884000000004], [6.79355745, 6.806755619999999, 3.6199884000000004], [6.79355745, 1.37424438, 3.6250115999999997]],
                "lattice_vectors": [[8.157, 0.0, 0.0], [0.0, 8.181, 0.0], [0.0, 0.0, 4.83]],
                "normalized_wyckoff_matid": {"g": {"X_0": 1}, "i": {"X_0": 1}, "l": {"X_0": 2, "X_1": 2}, "m": {"X_0": 2}}
            }
        ],
        67: [
            {
                "Notes": "$\\alpha$&ndash;FeSe Structure",
                "Pearsons Symbol": "oC8",
                "Prototype": "FeSe",
                "Space Group Number": 67,
                "Space Group Symbol": "$Cmma$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_oC8_67_a_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oC8_67_a_g.FeSe.html",
                "atom_labels": ["Fe", "Fe", "Fe", "Fe", "Se", "Se", "Se", "Se"],
                "atom_positions": [[1.3312375, 0.0, 0.0], [3.9937125, 0.0, 0.0], [3.9937125, 2.654515, 0.0], [1.3312375, 2.654515, 0.0], [0.0, 1.3272575, 1.4621793119999997], [0.0, 3.9817725, 4.017020688], [2.662475, 1.3272575, 4.017020688], [2.662475, 3.9817725, 1.4621793119999997]],
                "lattice_vectors": [[5.32495, 0.0, 0.0], [0.0, 5.30903, 0.0], [0.0, 0.0, 5.4792]]
            },
            {
                "Notes": "HoCuP<sub>2</sub> Structure",
                "Pearsons Symbol": "oC16",
                "Prototype": "CuHoP2",
                "Space Group Number": 67,
                "Space Group Symbol": "$Cmma$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC2_oC16_67_b_g_ag",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC2_oC16_67_b_g_ag.html",
                "atom_labels": ["P", "P", "P", "P", "Cu", "Cu", "Cu", "Cu", "Ho", "Ho", "Ho", "Ho", "P", "P", "P", "P"],
                "atom_positions": [[1.31824651315, 0.0, 0.0], [3.9547395394500002, 0.0, 0.0], [3.9547395394500002, 2.65249298395, 0.0], [1.31824651315, 2.65249298395, 0.0], [1.31824651315, 0.0, 4.8224872442], [3.9547395394500002, 0.0, 4.8224872442], [3.9547395394500002, 2.65249298395, 4.8224872442], [1.31824651315, 2.65249298395, 4.8224872442], [0.0, 1.326246491975, 7.3784054836260005], [0.0, 3.9787394759250003, 2.266569004774], [2.6364930263, 1.326246491975, 2.266569004774], [2.6364930263, 3.9787394759250003, 7.3784054836260005], [0.0, 1.326246491975, 3.2821848184025204], [0.0, 3.9787394759250003, 6.36278966999748], [2.6364930263, 1.326246491975, 6.36278966999748], [2.6364930263, 3.9787394759250003, 3.2821848184025204]],
                "lattice_vectors": [[5.2729860526, 0.0, 0.0], [0.0, 5.3049859679, 0.0], [0.0, 0.0, 9.6449744884]]
            },
            {
                "Notes": "$\\alpha$&ndash;PbO Structure",
                "Pearsons Symbol": "oC8",
                "Prototype": "OPb",
                "Space Group Number": 67,
                "Space Group Symbol": "$Cmma$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_oC8_67_a_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oC8_67_a_g.PbO.html",
                "atom_labels": ["O", "O", "O", "O", "Pb", "Pb", "Pb", "Pb"],
                "atom_positions": [[1.40310681965, 0.0, 0.0], [4.20932045895, 0.0, 0.0], [4.20932045895, 2.8044636308, 0.0], [1.40310681965, 2.8044636308, 0.0], [0.0, 1.4022318154, 3.81521062338942], [0.0, 4.2066954461999995, 1.17721364171058], [2.8062136393, 1.4022318154, 1.17721364171058], [2.8062136393, 4.2066954461999995, 3.81521062338942]],
                "lattice_vectors": [[5.6124272786, 0.0, 0.0], [0.0, 5.6089272616, 0.0], [0.0, 0.0, 4.9924242651]]
            },
            {
                "Notes": "Al<sub>2</sub>CuIr Structure",
                "Pearsons Symbol": "oC16",
                "Prototype": "Al2CuIr",
                "Space Group Number": 67,
                "Space Group Symbol": "$Cmma$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BC_oC16_67_ag_b_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC_oC16_67_ag_b_g.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Cu", "Cu", "Cu", "Cu", "Al", "Al", "Al", "Al", "Ir", "Ir", "Ir", "Ir"],
                "atom_positions": [[1.26610168095, 0.0, 0.0], [3.79830504285, 0.0, 0.0], [3.79830504285, 4.0596450692, 0.0], [1.26610168095, 4.0596450692, 0.0], [1.26610168095, 0.0, 2.59245106265], [3.79830504285, 0.0, 2.59245106265], [3.79830504285, 4.0596450692, 2.59245106265], [1.26610168095, 4.0596450692, 2.59245106265], [0.0, 2.0298225346, 1.71361015241165], [0.0, 6.0894676038, 3.47129197288835], [2.5322033619, 2.0298225346, 3.47129197288835], [2.5322033619, 6.0894676038, 1.71361015241165], [0.0, 2.0298225346, 4.250582762320939], [0.0, 6.0894676038, 0.9343193629790602], [2.5322033619, 2.0298225346, 0.9343193629790602], [2.5322033619, 6.0894676038, 4.250582762320939]],
                "lattice_vectors": [[5.0644067238, 0.0, 0.0], [0.0, 8.1192901384, 0.0], [0.0, 0.0, 5.1849021253]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}, "g": {"X_0": 1, "X_2": 1}}
            }
        ],
        68: [
            {
                "Notes": "PdSn<sub>4</sub> Structure",
                "Pearsons Symbol": "oC20",
                "Prototype": "PdSn4",
                "Space Group Number": 68,
                "Space Group Symbol": "$Ccca$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB4_oC20_68_a_i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4_oC20_68_a_i.html",
                "atom_labels": ["Pd", "Pd", "Pd", "Pd", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn"],
                "atom_positions": [[0.0, 2.861345, 1.5973025], [3.22111, 2.861345, 4.791907500000001], [3.22111, 8.584035, 1.5973025], [0.0, 8.584035, 4.791907500000001], [2.134307486, 1.411215354, 0.511775721], [2.134307486, 4.311474646, 2.682829279], [4.307912514000001, 1.411215354, 2.682829279], [4.307912514000001, 4.311474646, 0.511775721], [1.0868025140000002, 4.311474646, 5.877434279], [1.0868025140000002, 1.411215354, 3.7063807210000004], [5.3554174859999994, 4.311474646, 3.7063807210000004], [5.3554174859999994, 1.411215354, 5.877434279], [5.3554174859999994, 7.1339053539999995, 0.511775721], [5.3554174859999994, 10.034164646, 2.682829279], [1.0868025140000002, 7.1339053539999995, 2.682829279], [1.0868025140000002, 10.034164646, 0.511775721], [4.307912514000001, 10.034164646, 5.877434279], [4.307912514000001, 7.1339053539999995, 3.7063807210000004], [2.134307486, 10.034164646, 3.7063807210000004], [2.134307486, 7.1339053539999995, 5.877434279]],
                "lattice_vectors": [[6.44222, 0.0, 0.0], [0.0, 11.44538, 0.0], [0.0, 0.0, 6.38921]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "i": {"X_0": 4}}
            }
        ],
        69: [
            {
                "Notes": "TlF (B24) Structure",
                "Pearsons Symbol": "oF8",
                "Prototype": "FTl",
                "Space Group Number": 69,
                "Space Group Symbol": "$Fmmm$",
                "Strukturbericht Designation": "$B24$",
                "aflow_prototype_id": "AB_oF8_69_a_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_oF8_69_a_b.html",
                "atom_labels": ["F", "F", "F", "F", "Tl", "Tl", "Tl", "Tl"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 2.7475, 2.59], [3.04, 0.0, 2.59], [3.04, 2.7475, 0.0], [0.0, 0.0, 2.59], [0.0, 2.7475, 0.0], [3.04, 0.0, 0.0], [3.04, 2.7475, 2.59]],
                "lattice_vectors": [[6.08, 0.0, 0.0], [0.0, 5.495, 0.0], [0.0, 0.0, 5.18]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}}
            }
        ],
        70: [
            {
                "Notes": "$\\gamma$&ndash;Pu Structure",
                "Pearsons Symbol": "oF8",
                "Prototype": "Pu",
                "Space Group Number": 70,
                "Space Group Symbol": "$Fddd$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_oF8_70_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_oF8_70_a.html",
                "atom_labels": ["Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu", "Pu"],
                "atom_positions": [[0.3948375, 0.721025, 1.27025], [0.3948375, 3.605125, 6.35125], [1.9741875, 0.721025, 6.35125], [1.9741875, 3.605125, 1.27025], [2.7638625, 5.047175, 8.89175], [2.7638625, 2.163075, 3.8107500000000005], [1.1845125, 5.047175, 3.8107500000000005], [1.1845125, 2.163075, 8.89175]],
                "lattice_vectors": [[3.1587, 0.0, 0.0], [0.0, 5.7682, 0.0], [0.0, 0.0, 10.162]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}}
            },
            {
                "Notes": "$\\alpha$&ndash;S (A16) Structure",
                "Pearsons Symbol": "oF128",
                "Prototype": "S",
                "Space Group Number": 70,
                "Space Group Symbol": "$Fddd$",
                "Strukturbericht Designation": "$A16$",
                "aflow_prototype_id": "A_oF128_70_4h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_oF128_70_4h.html",
                "atom_labels": ["S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[1.5084720900000002, 0.60881912, 1.1900196], [1.5084720900000002, 9.04068088, 17.1744804], [6.339977910000001, 0.60881912, 17.1744804], [6.339977910000001, 9.04068088, 1.1900196], [8.956127910000001, 12.25718088, 23.2959804], [8.956127910000001, 3.82531912, 7.3115196], [4.12462209, 12.25718088, 7.3115196], [4.12462209, 3.82531912, 23.2959804], [1.5084720900000002, 7.04181912, 13.4330196], [1.5084720900000002, 2.6076808799999998, 4.9314804], [6.339977910000001, 7.04181912, 4.9314804], [6.339977910000001, 2.6076808799999998, 13.4330196], [8.956127910000001, 5.824180879999999, 11.052980400000001], [8.956127910000001, 10.25831912, 19.5545196], [4.12462209, 5.824180879999999, 19.5545196], [4.12462209, 10.25831912, 11.052980400000001], [6.74077209, 0.60881912, 13.4330196], [6.74077209, 9.04068088, 4.9314804], [1.10767791, 0.60881912, 4.9314804], [1.10767791, 9.04068088, 13.4330196], [3.7238279100000002, 12.25718088, 11.052980400000001], [3.7238279100000002, 3.82531912, 19.5545196], [9.356922090000001, 12.25718088, 19.5545196], [9.356922090000001, 3.82531912, 11.052980400000001], [6.74077209, 7.04181912, 1.1900196], [6.74077209, 2.6076808799999998, 17.1744804], [1.10767791, 7.04181912, 17.1744804], [1.10767791, 2.6076808799999998, 1.1900196], [3.7238279100000002, 5.824180879999999, 23.2959804], [3.7238279100000002, 10.25831912, 7.3115196], [9.356922090000001, 5.824180879999999, 7.3115196], [9.356922090000001, 10.25831912, 23.2959804], [3.063720942, 2.9192953999999998, 6.22091316], [3.063720942, 6.7302045999999995, 12.14358684], [4.784729058000001, 2.9192953999999998, 12.14358684], [4.784729058000001, 6.7302045999999995, 6.22091316], [7.400879058000001, 9.9467046, 18.265086840000002], [7.400879058000001, 6.1357954, 12.34241316], [5.679870942, 9.9467046, 12.34241316], [5.679870942, 6.1357954, 18.265086840000002], [3.063720942, 9.3522954, 18.46391316], [3.063720942, 0.2972046000000001, 24.386586840000003], [4.784729058000001, 9.3522954, 24.386586840000003], [4.784729058000001, 0.2972046000000001, 18.46391316], [7.400879058000001, 3.5137046, 6.02208684], [7.400879058000001, 12.568795399999999, 0.09941315999999883], [5.679870942, 3.5137046, 0.09941315999999883], [5.679870942, 12.568795399999999, 6.02208684], [8.296020942, 2.9192953999999998, 18.46391316], [8.296020942, 6.7302045999999995, 24.386586840000003], [10.017029058, 2.9192953999999998, 24.386586840000003], [10.017029058, 6.7302045999999995, 18.46391316], [2.1685790580000006, 9.9467046, 6.02208684], [2.1685790580000006, 6.1357954, 0.09941315999999883], [0.44757094199999975, 9.9467046, 0.09941315999999883], [0.44757094199999975, 6.1357954, 6.02208684], [8.296020942, 9.3522954, 6.22091316], [8.296020942, 0.2972046000000001, 12.14358684], [10.017029058, 9.3522954, 12.14358684], [10.017029058, 0.2972046000000001, 6.22091316], [2.1685790580000006, 3.5137046, 18.265086840000002], [2.1685790580000006, 12.568795399999999, 12.34241316], [0.44757094199999975, 3.5137046, 12.34241316], [0.44757094199999975, 12.568795399999999, 18.265086840000002], [2.260144308, 3.60531052, 7.986843480000001], [2.260144308, 6.044189479999999, 10.37765652], [5.588305692, 3.60531052, 10.37765652], [5.588305692, 6.044189479999999, 7.986843480000001], [8.204455692, 9.26068948, 16.49915652], [8.204455692, 6.8218105200000005, 14.10834348], [4.876294308, 9.26068948, 14.10834348], [4.876294308, 6.8218105200000005, 16.49915652], [2.260144308, 10.03831052, 20.22984348], [2.260144308, 12.47718948, 22.62065652], [5.588305692, 10.03831052, 22.62065652], [5.588305692, 12.47718948, 20.22984348], [8.204455692, 2.8276894799999996, 4.256156519999999], [8.204455692, 0.3888105199999989, 1.865343479999998], [4.876294308, 2.8276894799999996, 1.865343479999998], [4.876294308, 0.3888105199999989, 4.256156519999999], [7.492444308000001, 3.60531052, 20.22984348], [7.492444308000001, 6.044189479999999, 22.62065652], [0.356005692, 3.60531052, 22.62065652], [0.356005692, 6.044189479999999, 20.22984348], [2.9721556920000003, 9.26068948, 4.256156519999999], [2.9721556920000003, 6.8218105200000005, 1.865343479999998], [10.108594308, 9.26068948, 1.865343479999998], [10.108594308, 6.8218105200000005, 4.256156519999999], [7.492444308000001, 10.03831052, 7.986843480000001], [7.492444308000001, 12.47718948, 10.37765652], [0.356005692, 10.03831052, 10.37765652], [0.356005692, 12.47718948, 7.986843480000001], [2.9721556920000003, 2.8276894799999996, 16.49915652], [2.9721556920000003, 0.3888105199999989, 14.10834348], [10.108594308, 2.8276894799999996, 14.10834348], [10.108594308, 0.3888105199999989, 16.49915652], [2.23994763, 2.02781026, 9.29170242], [2.23994763, 7.62168974, 9.072797580000001], [5.608502370000001, 2.02781026, 9.072797580000001], [5.608502370000001, 7.62168974, 9.29170242], [8.224652370000001, 10.838189739999999, 15.19429758], [8.224652370000001, 5.24431026, 15.41320242], [4.85609763, 10.838189739999999, 15.41320242], [4.85609763, 5.24431026, 15.19429758], [2.23994763, 8.46081026, 21.53470242], [2.23994763, 1.18868974, 21.31579758], [5.608502370000001, 8.46081026, 21.31579758], [5.608502370000001, 1.18868974, 21.53470242], [8.224652370000001, 4.40518974, 2.9512975800000008], [8.224652370000001, 11.67731026, 3.1702024199999994], [4.85609763, 4.40518974, 3.1702024199999994], [4.85609763, 11.67731026, 2.9512975800000008], [7.47224763, 2.02781026, 21.53470242], [7.47224763, 7.62168974, 21.31579758], [0.3762023700000001, 2.02781026, 21.31579758], [0.3762023700000001, 7.62168974, 21.53470242], [2.9923523700000008, 10.838189739999999, 2.9512975800000008], [2.9923523700000008, 5.24431026, 3.1702024199999994], [10.088397630000001, 10.838189739999999, 3.1702024199999994], [10.088397630000001, 5.24431026, 2.9512975800000008], [7.47224763, 8.46081026, 9.29170242], [7.47224763, 1.18868974, 9.072797580000001], [0.3762023700000001, 8.46081026, 9.072797580000001], [0.3762023700000001, 1.18868974, 9.29170242], [2.9923523700000008, 4.40518974, 15.19429758], [2.9923523700000008, 11.67731026, 15.41320242], [10.088397630000001, 4.40518974, 15.41320242], [10.088397630000001, 11.67731026, 15.19429758]],
                "lattice_vectors": [[10.4646, 0.0, 0.0], [0.0, 12.866, 0.0], [0.0, 0.0, 24.486]],
                "normalized_wyckoff_matid": {"h": {"X_0": 1}}
            },
            {
                "Notes": "TiSi<sub>2</sub> (C54) Structure",
                "Pearsons Symbol": "oF24",
                "Prototype": "Si2Ti",
                "Space Group Number": 70,
                "Space Group Symbol": "$Fddd$",
                "Strukturbericht Designation": "$C54$",
                "aflow_prototype_id": "A2B_oF24_70_e_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oF24_70_e_a.html",
                "atom_labels": ["Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[1.0333875, 0.6, 1.0688125], [1.0333875, 3.0, 5.3440625], [5.1669374999999995, 0.6, 5.3440625], [5.1669374999999995, 3.0, 1.0688125], [7.233712499999999, 4.2, 7.4816875], [7.233712499999999, 1.7999999999999998, 3.2064375], [3.1001624999999997, 4.2, 3.2064375], [3.1001624999999997, 1.7999999999999998, 7.4816875], [3.81526665, 0.6, 1.0688125], [3.81526665, 3.0, 5.3440625], [2.3850583499999995, 0.6, 5.3440625], [2.3850583499999995, 3.0, 1.0688125], [4.451833349999999, 4.2, 7.4816875], [4.451833349999999, 1.7999999999999998, 3.2064375], [5.88204165, 4.2, 3.2064375], [5.88204165, 1.7999999999999998, 7.4816875], [7.9488166499999995, 0.6, 5.3440625], [7.9488166499999995, 3.0, 1.0688125], [6.518608349999999, 0.6, 1.0688125], [6.518608349999999, 3.0, 5.3440625], [0.3182833499999998, 4.2, 3.2064375], [0.3182833499999998, 1.7999999999999998, 7.4816875], [1.74849165, 4.2, 7.4816875], [1.74849165, 1.7999999999999998, 3.2064375]],
                "lattice_vectors": [[8.2671, 0.0, 0.0], [0.0, 4.8, 0.0], [0.0, 0.0, 8.5505]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "f": {"X_0": 2}}
            },
            {
                "Notes": "Mn<sub>2</sub>B ($D1_{f}$) Structure",
                "Pearsons Symbol": "oF48",
                "Prototype": "BMn2",
                "Space Group Number": 70,
                "Space Group Symbol": "$Fddd$",
                "Strukturbericht Designation": "$D1_{f}$",
                "aflow_prototype_id": "AB2_oF48_70_f_fg",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_oF48_70_f_fg.html",
                "atom_labels": ["B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn"],
                "atom_positions": [[0.526025, 3.6276052500000002, 0.911425], [0.526025, 7.277019749999999, 4.557125], [2.6301249999999996, 3.6276052500000002, 4.557125], [2.6301249999999996, 7.277019749999999, 0.911425], [3.682175, 10.91189475, 6.379975], [3.682175, 7.26248025, 2.7342750000000002], [1.578075, 10.91189475, 2.7342750000000002], [1.578075, 7.26248025, 6.379975], [0.526025, 10.89735525, 4.557125], [0.526025, 0.007269750000000006, 0.911425], [2.6301249999999996, 10.89735525, 0.911425], [2.6301249999999996, 0.007269750000000006, 4.557125], [3.682175, 3.64214475, 2.7342750000000002], [3.682175, 14.532230250000001, 6.379975], [1.578075, 3.64214475, 6.379975], [1.578075, 14.532230250000001, 2.7342750000000002], [0.526025, 7.900328115000001, 0.911425], [0.526025, 3.0042968849999996, 4.557125], [2.6301249999999996, 7.900328115000001, 4.557125], [2.6301249999999996, 3.0042968849999996, 0.911425], [3.682175, 6.639171885, 6.379975], [3.682175, 11.535203115, 2.7342750000000002], [1.578075, 6.639171885, 2.7342750000000002], [1.578075, 11.535203115, 6.379975], [0.526025, 0.6305781149999987, 4.557125], [0.526025, 10.274046885, 0.911425], [2.6301249999999996, 0.6305781149999987, 0.911425], [2.6301249999999996, 10.274046885, 4.557125], [3.682175, 13.908921885, 2.7342750000000002], [3.682175, 4.265453114999999, 6.379975], [1.578075, 13.908921885, 6.379975], [1.578075, 4.265453114999999, 2.7342750000000002], [0.526025, 1.8174375, 2.14695273], [0.526025, 9.0871875, 3.3215972700000003], [2.6301249999999996, 1.8174375, 3.3215972700000003], [2.6301249999999996, 9.0871875, 2.14695273], [3.682175, 12.7220625, 5.144447270000001], [3.682175, 5.4523125, 3.96980273], [1.578075, 12.7220625, 3.96980273], [1.578075, 5.4523125, 5.144447270000001], [0.526025, 9.0871875, 5.79265273], [0.526025, 1.8174375, 6.96729727], [2.6301249999999996, 9.0871875, 6.96729727], [2.6301249999999996, 1.8174375, 5.79265273], [3.682175, 5.4523125, 1.4987472700000002], [3.682175, 12.7220625, 0.3241027299999991], [1.578075, 5.4523125, 0.3241027299999991], [1.578075, 12.7220625, 1.4987472700000002]],
                "lattice_vectors": [[4.2082, 0.0, 0.0], [0.0, 14.5395, 0.0], [0.0, 0.0, 7.2914]],
                "normalized_wyckoff_matid": {"f": {"X_0": 1}, "g": {"X_0": 1, "X_1": 1}}
            }
        ],
        71: [
            {
                "Notes": "ReSi<sub>2</sub> Structure",
                "Pearsons Symbol": "oI6",
                "Prototype": "ReSi2",
                "Space Group Number": 71,
                "Space Group Symbol": "$Immm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_oI6_71_a_i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_oI6_71_a_i.html",
                "atom_labels": ["Re", "Re", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.572, 1.564, 3.8385], [0.0, 0.0, 2.602503], [0.0, 0.0, 5.074497], [1.572, 1.564, 6.441002999999999], [1.572, 1.564, 1.2359969999999998]],
                "lattice_vectors": [[3.144, 0.0, 0.0], [0.0, 3.128, 0.0], [0.0, 0.0, 7.677]]
            },
            {
                "Notes": "MoPt<sub>2</sub> Structure",
                "Pearsons Symbol": "oI6",
                "Prototype": "MoPt2",
                "Space Group Number": 71,
                "Space Group Symbol": "$Immm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_oI6_71_a_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_oI6_71_a_g.html",
                "atom_labels": ["Mo", "Mo", "Pt", "Pt", "Pt", "Pt"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.37992, 4.139755, 1.96516], [0.0, 2.9253992683, 0.0], [0.0, 5.3541107317000005, 0.0], [1.37992, 7.0651542683, 1.96516], [1.37992, 1.2143557317000002, 1.96516]],
                "lattice_vectors": [[2.75984, 0.0, 0.0], [0.0, 8.27951, 0.0], [0.0, 0.0, 3.93032]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "i": {"X_0": 2}}
            },
            {
                "Notes": "NbPS Structure",
                "Pearsons Symbol": "oI12",
                "Prototype": "NbPS",
                "Space Group Number": 71,
                "Space Group Symbol": "$Immm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_oI12_71_h_j_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_oI12_71_h_j_g.html",
                "atom_labels": ["S", "S", "S", "S", "Nb", "Nb", "Nb", "Nb", "P", "P", "P", "P"],
                "atom_positions": [[0.0, 2.51856, 0.0], [0.0, 9.361440000000002, 0.0], [1.719, 8.45856, 2.3625], [1.719, 3.4214400000000005, 2.3625], [0.0, 1.4636160000000003, 2.3625], [0.0, 10.416384, 2.3625], [1.719, 7.403616, 0.0], [1.719, 4.476384, 0.0], [1.719, 0.0, 1.110375], [1.719, 0.0, 3.6146249999999998], [0.0, 5.94, 3.4728749999999997], [0.0, 5.94, 1.252125]],
                "lattice_vectors": [[3.438, 0.0, 0.0], [0.0, 11.88, 0.0], [0.0, 0.0, 4.725]],
                "normalized_wyckoff_matid": {"g": {"X_0": 1}, "i": {"X_1": 1}, "j": {"X_2": 1}}
            },
            {
                "Notes": "Ta<sub>3</sub>B<sub>4</sub> ($D7_{b}$) Structure",
                "Pearsons Symbol": "oI14",
                "Prototype": "B4Ta3",
                "Space Group Number": 71,
                "Space Group Symbol": "$Immm$",
                "Strukturbericht Designation": "$D7_{b}$",
                "aflow_prototype_id": "A4B3_oI14_71_gh_cg",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B3_oI14_71_gh_cg.html",
                "atom_labels": ["Ta", "Ta", "B", "B", "B", "B", "Ta", "Ta", "Ta", "Ta", "B", "B", "B", "B"],
                "atom_positions": [[1.645, 7.0, 0.0], [0.0, 0.0, 1.565], [0.0, 5.25, 0.0], [0.0, 8.75, 0.0], [1.645, 12.25, 1.565], [1.645, 1.75, 1.565], [0.0, 2.52, 0.0], [0.0, 11.48, 0.0], [1.645, 9.52, 1.565], [1.645, 4.48, 1.565], [0.0, 6.216, 1.565], [0.0, 7.784000000000001, 1.565], [1.645, 13.216, 0.0], [1.645, 0.7839999999999999, 0.0]],
                "lattice_vectors": [[3.29, 0.0, 0.0], [0.0, 14.0, 0.0], [0.0, 0.0, 3.13]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "i": {"X_0": 2}, "j": {"X_0": 2, "X_1": 2}}
            }
        ],
        72: [
            {
                "Notes": "SiS<sub>2</sub> Structure",
                "Pearsons Symbol": "oI12",
                "Prototype": "S2Si",
                "Space Group Number": 72,
                "Space Group Symbol": "$Ibam$",
                "Strukturbericht Designation": "$C42$",
                "aflow_prototype_id": "A2B_oI12_72_j_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oI12_72_j_a.html",
                "atom_labels": ["Si", "Si", "Si", "Si", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 1.38675], [0.0, 0.0, 4.16025], [4.7915, 2.807, 4.16025], [4.7915, 2.807, 1.38675], [1.1327106, 1.1722032, 0.0], [1.1327106, 4.4417968, 2.7735], [8.4502894, 1.1722032, 2.7735], [8.4502894, 4.4417968, 0.0], [5.924210599999999, 3.9792031999999997, 2.7735], [5.924210599999999, 1.6347968, 0.0], [3.6587894000000003, 3.9792031999999997, 0.0], [3.6587894000000003, 1.6347968, 2.7735]],
                "lattice_vectors": [[9.583, 0.0, 0.0], [0.0, 5.614, 0.0], [0.0, 0.0, 5.547]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "j": {"X_0": 2}}
            }
        ],
        73: [
            {
                "Notes": "KAg[CO<sub>3</sub>] Structure",
                "Pearsons Symbol": "oI48",
                "Prototype": "Ag[CKO3]",
                "Space Group Number": 73,
                "Space Group Symbol": "$Ibca$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABCD3_oI48_73_d_e_e_ef",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABCD3_oI48_73_d_e_e_ef.html",
                "atom_labels": ["Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "C", "C", "C", "C", "C", "C", "C", "C", "K", "K", "K", "K", "K", "K", "K", "K", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[1.443760281525, 3.770127728395392, 0.0], [1.443760281525, 2.173914601204608, 10.19457259915], [4.331280844575, 5.145935766004608, 0.0], [4.331280844575, 2.173914601204608, 0.0], [4.331280844575, 3.770127728395392, 10.19457259915], [1.443760281525, 0.7981065635953913, 0.0], [4.331280844575, 0.7981065635953913, 10.19457259915], [1.443760281525, 5.145935766004608, 10.19457259915], [0.0, 1.4860105824, 7.61330681704522], [0.0, 4.4580317472, 2.5812657821047797], [2.88752056305, 1.4860105824, 12.77583838125478], [0.0, 4.4580317472, 12.77583838125478], [0.0, 1.4860105824, 17.80787941619522], [2.88752056305, 4.4580317472, 7.61330681704522], [2.88752056305, 4.4580317472, 17.80787941619522], [2.88752056305, 1.4860105824, 2.5812657821047797], [0.0, 1.4860105824, 3.6765706621574563], [0.0, 4.4580317472, 6.518001936992543], [2.88752056305, 1.4860105824, 16.712574536142544], [0.0, 4.4580317472, 16.712574536142544], [0.0, 1.4860105824, 13.871143261307456], [2.88752056305, 4.4580317472, 3.6765706621574563], [2.88752056305, 4.4580317472, 13.871143261307456], [2.88752056305, 1.4860105824, 6.518001936992543], [0.0, 1.4860105824, 6.3410241566713], [0.0, 4.4580317472, 3.8535484424787], [2.88752056305, 1.4860105824, 14.0481210416287], [0.0, 4.4580317472, 14.0481210416287], [0.0, 1.4860105824, 16.5355967558213], [2.88752056305, 4.4580317472, 6.3410241566713], [2.88752056305, 4.4580317472, 16.5355967558213], [2.88752056305, 1.4860105824, 3.8535484424787], [0.7790530479108899, 3.6401315226470405, 1.97163034067561], [0.7790530479108899, 2.3039108069529597, 8.22294225847439], [2.1084675151391097, 3.6401315226470405, 18.41751485762439], [4.99598807818911, 5.27593197175296, 1.97163034067561], [4.99598807818911, 2.3039108069529597, 18.41751485762439], [4.99598807818911, 3.6401315226470405, 12.16620293982561], [3.66657361096089, 2.3039108069529597, 1.97163034067561], [0.7790530479108899, 0.6681103578470403, 18.41751485762439], [3.66657361096089, 0.6681103578470403, 12.16620293982561], [3.66657361096089, 5.27593197175296, 18.41751485762439], [4.99598807818911, 0.6681103578470403, 8.22294225847439], [2.1084675151391097, 2.3039108069529597, 12.16620293982561], [2.1084675151391097, 5.27593197175296, 8.22294225847439], [2.1084675151391097, 0.6681103578470403, 1.97163034067561], [0.7790530479108899, 5.27593197175296, 12.16620293982561], [3.66657361096089, 3.6401315226470405, 8.22294225847439]],
                "lattice_vectors": [[5.7750411261, 0.0, 0.0], [0.0, 5.9440423296, 0.0], [0.0, 0.0, 20.3891451983]],
                "normalized_wyckoff_matid": {"d": {"X_1": 1}, "e": {"X_0": 1, "X_2": 1, "X_3": 1}, "f": {"X_0": 2}}
            }
        ],
        74: [
            {
                "Notes": "KHg<sub>2</sub> Structure",
                "Pearsons Symbol": "oI12",
                "Prototype": "Hg2K",
                "Space Group Number": 74,
                "Space Group Symbol": "$Imma$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_oI12_74_h_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_oI12_74_h_e.html",
                "atom_labels": ["K", "K", "K", "K", "Hg", "Hg", "Hg", "Hg", "Hg", "Hg", "Hg", "Hg"],
                "atom_positions": [[0.0, 2.024551870275, 8.3626299517907], [0.0, 6.073655610825, 0.4124277101093], [2.5794290495, 6.073655610825, 3.9751011208407], [2.5794290495, 2.024551870275, 4.7999565410593], [0.0, 4.534996189416, 5.8178632298397], [0.0, 3.563211291683999, 2.9571944320603], [0.0, 0.4858924488660004, 2.9571944320603], [0.0, 7.612315032233999, 5.8178632298397], [2.5794290495, 0.4858924488660004, 1.4303343988897004], [2.5794290495, 7.612315032233999, 7.3447232630103], [2.5794290495, 4.534996189416, 7.3447232630103], [2.5794290495, 3.563211291683999, 1.4303343988897004]],
                "lattice_vectors": [[5.158858099, 0.0, 0.0], [0.0, 8.0982074811, 0.0], [0.0, 0.0, 8.7750576619]],
                "normalized_wyckoff_matid": {"e": {"X_1": 1}, "h": {"X_0": 2}}
            },
            {
                "Notes": "Al<sub>4</sub>U ($D1_{b}$) Structure",
                "Pearsons Symbol": "oI20",
                "Prototype": "AlU",
                "Space Group Number": 74,
                "Space Group Symbol": "$Imma$",
                "Strukturbericht Designation": "$D1_{b}$",
                "aflow_prototype_id": "A4B_oI20_74_beh_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B_oI20_74_beh_e.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "U", "U", "U", "U", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al"],
                "atom_positions": [[0.0, 0.0, 6.86], [0.0, 3.125, 6.86], [2.195, 3.125, 0.0], [2.195, 0.0, 0.0], [0.0, 1.5625, 12.197080000000001], [0.0, 4.6875, 1.52292], [2.195, 4.6875, 5.33708], [2.195, 1.5625, 8.38292], [0.0, 1.5625, 1.52292], [0.0, 4.6875, 12.197080000000001], [2.195, 4.6875, 8.38292], [2.195, 1.5625, 5.33708], [0.0, 6.04375, 4.30808], [0.0, 0.20625000000000002, 9.41192], [0.0, 2.9187499999999997, 9.41192], [0.0, 3.3312500000000003, 4.30808], [2.195, 2.9187499999999997, 11.168080000000002], [2.195, 3.3312500000000003, 2.55192], [2.195, 6.04375, 2.55192], [2.195, 0.20625000000000002, 11.168080000000002]],
                "lattice_vectors": [[4.39, 0.0, 0.0], [0.0, 6.25, 0.0], [0.0, 0.0, 13.72]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "e": {"X_0": 1, "X_1": 1}, "h": {"X_0": 2}}
            }
        ],
        75: [
            {
                "Notes": "BaCr<sub>2</sub>Ru<sub>4</sub>O<sub>12</sub> Structure",
                "Pearsons Symbol": "tP76",
                "Prototype": "BaCr2O12Ru4",
                "Space Group Number": 75,
                "Space Group Symbol": "$P4$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2C12D4_tP76_75_2a2b_2d_12d_4d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2C12D4_tP76_75_2a2b_2d_12d_4d.html",
                "atom_labels": ["Ba", "Ba", "Ba", "Ba", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru"],
                "atom_positions": [[0.0, 0.0, 3.04004819237724], [0.0, 0.0, 0.0], [4.9440307247, 4.9440307247, 4.56326465840484], [4.9440307247, 4.9440307247, 1.51956804335448], [1.6513062620498002, 3.4410453843911997, 1.51956804335448], [8.2367551873502, 6.447016065008801, 1.51956804335448], [6.447016065008801, 1.6513062620498002, 1.51956804335448], [3.4410453843911997, 8.2367551873502, 1.51956804335448], [3.2927244626502, 1.5029853403088, 0.0], [6.595336986749801, 8.3850761090912, 0.0], [8.3850761090912, 3.2927244626502, 0.0], [1.5029853403088, 6.595336986749801, 0.0], [2.0567167814752, 1.5029853403088, 7.600576533777241], [7.8313446679248, 8.3850761090912, 7.600576533777241], [8.3850761090912, 2.0567167814752, 7.600576533777241], [1.5029853403088, 7.8313446679248, 7.600576533777241], [4.5287321438252, 1.5029853403088, 7.600576533777241], [5.359329305574801, 8.3850761090912, 7.600576533777241], [8.3850761090912, 4.5287321438252, 7.600576533777241], [1.5029853403088, 5.359329305574801, 7.600576533777241], [2.8873139432248, 3.4410453843911997, 6.08009638475448], [7.0007475061752, 6.447016065008801, 6.08009638475448], [6.447016065008801, 2.8873139432248, 6.08009638475448], [3.4410453843911997, 7.0007475061752, 6.08009638475448], [0.41529858087480004, 3.4410453843911997, 6.08009638475448], [9.4727628685252, 6.447016065008801, 6.08009638475448], [6.447016065008801, 0.41529858087480004, 6.08009638475448], [3.4410453843911997, 9.4727628685252, 6.08009638475448], [2.0567167814752, 1.5029853403088, 4.5605283414], [7.8313446679248, 8.3850761090912, 4.5605283414], [8.3850761090912, 2.0567167814752, 4.5605283414], [1.5029853403088, 7.8313446679248, 4.5605283414], [4.5287321438252, 1.5029853403088, 4.5605283414], [5.359329305574801, 8.3850761090912, 4.5605283414], [8.3850761090912, 4.5287321438252, 4.5605283414], [1.5029853403088, 5.359329305574801, 4.5605283414], [2.8873139432248, 3.4410453843911997, 3.04004819237724], [7.0007475061752, 6.447016065008801, 3.04004819237724], [6.447016065008801, 2.8873139432248, 3.04004819237724], [3.4410453843911997, 7.0007475061752, 3.04004819237724], [0.41529858087480004, 3.4410453843911997, 3.04004819237724], [9.4727628685252, 6.447016065008801, 3.04004819237724], [6.447016065008801, 0.41529858087480004, 3.04004819237724], [3.4410453843911997, 9.4727628685252, 3.04004819237724], [2.0567167814752, 1.5029853403088, 1.51956804335448], [7.8313446679248, 8.3850761090912, 1.51956804335448], [8.3850761090912, 2.0567167814752, 1.51956804335448], [1.5029853403088, 7.8313446679248, 1.51956804335448], [4.5287321438252, 1.5029853403088, 1.51956804335448], [5.359329305574801, 8.3850761090912, 1.51956804335448], [8.3850761090912, 4.5287321438252, 1.51956804335448], [1.5029853403088, 5.359329305574801, 1.51956804335448], [2.8873139432248, 3.4410453843911997, 0.0], [7.0007475061752, 6.447016065008801, 0.0], [6.447016065008801, 2.8873139432248, 0.0], [3.4410453843911997, 7.0007475061752, 0.0], [0.41529858087480004, 3.4410453843911997, 0.0], [9.4727628685252, 6.447016065008801, 0.0], [6.447016065008801, 0.41529858087480004, 0.0], [3.4410453843911997, 9.4727628685252, 0.0], [1.6513062620498002, 3.4410453843911997, 7.600576533777241], [8.2367551873502, 6.447016065008801, 7.600576533777241], [6.447016065008801, 1.6513062620498002, 7.600576533777241], [3.4410453843911997, 8.2367551873502, 7.600576533777241], [3.2927244626502, 1.5029853403088, 6.08009638475448], [6.595336986749801, 8.3850761090912, 6.08009638475448], [8.3850761090912, 3.2927244626502, 6.08009638475448], [1.5029853403088, 6.595336986749801, 6.08009638475448], [1.6513062620498002, 3.4410453843911997, 4.5605283414], [8.2367551873502, 6.447016065008801, 4.5605283414], [6.447016065008801, 1.6513062620498002, 4.5605283414], [3.4410453843911997, 8.2367551873502, 4.5605283414], [3.2927244626502, 1.5029853403088, 3.04004819237724], [6.595336986749801, 8.3850761090912, 3.04004819237724], [8.3850761090912, 3.2927244626502, 3.04004819237724], [1.5029853403088, 6.595336986749801, 3.04004819237724]],
                "lattice_vectors": [[9.8880614494, 0.0, 0.0], [0.0, 9.8880614494, 0.0], [0.0, 0.0, 9.1210566828]],
                "normalized_wyckoff_matid": {"a": {"X_3": 1}, "b": {"X_3": 1}, "d": {"X_0": 24, "X_1": 8, "X_2": 4}}
            }
        ],
        76: [
            {
                "Notes": "Cs<sub>3</sub>P<sub>7</sub> Structure",
                "Pearsons Symbol": "tP40",
                "Prototype": "Cs3P7",
                "Space Group Number": 76,
                "Space Group Symbol": "$P4_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B7_tP40_76_3a_7a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B7_tP40_76_3a_7a.html",
                "atom_labels": ["Cs", "Cs", "Cs", "Cs", "Cs", "Cs", "Cs", "Cs", "Cs", "Cs", "Cs", "Cs", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P"],
                "atom_positions": [[6.725701, 3.4845192, 0.0], [2.3202989999999994, 5.5614808, 8.357], [5.5614808, 6.725701, 4.1785], [3.4845192, 2.3202989999999994, 12.535499999999999], [3.7712774, 6.630717999999999, 13.971232599999999], [5.2747226, 2.415282, 5.614232600000001], [2.415282, 3.7712774, 1.4357326000000012], [6.630717999999999, 5.2747226, 9.7927326], [0.23519599999999996, 7.6022584, 16.570259599999996], [8.810804, 1.4437415999999996, 8.213259599999999], [1.4437415999999996, 0.23519599999999996, 4.0347596], [7.6022584, 8.810804, 12.391759599999999], [7.1463399999999995, 5.427599999999999, 13.546696999999998], [1.8996599999999995, 3.6184, 5.189697], [3.6184, 7.1463399999999995, 1.011197], [5.427599999999999, 1.8996599999999995, 9.368196999999999], [4.007378, 0.85937, 15.828157999999998], [5.038621999999999, 8.18663, 7.471158], [8.18663, 4.007378, 3.292658], [0.85937, 5.038621999999999, 11.649657999999999], [0.958876, 4.278758, 14.9222592], [8.087124, 4.7672419999999995, 6.5652592], [4.7672419999999995, 0.958876, 2.3867592000000006], [4.278758, 8.087124, 10.7437592], [3.2294219999999996, 0.217104, 1.0195539999999998], [5.816578, 8.828895999999999, 9.376553999999999], [8.828895999999999, 3.2294219999999996, 5.198054], [0.217104, 5.816578, 13.555053999999998], [5.689934, 7.182524, 0.284138], [3.3560659999999998, 1.8634759999999995, 8.641138], [1.8634759999999995, 5.689934, 4.462638], [7.182524, 3.3560659999999998, 12.819638], [9.027908, 3.084686, 11.781698599999999], [0.018092, 5.961314, 3.4246985999999975], [5.961314, 9.027908, 15.960198599999998], [3.084686, 0.018092, 7.603198599999997], [0.09950599999999998, 2.62334, 14.039759999999998], [8.946494, 6.42266, 5.682759999999997], [6.42266, 0.09950599999999998, 1.5042599999999975], [2.62334, 8.946494, 9.861259999999996]],
                "lattice_vectors": [[9.046, 0.0, 0.0], [0.0, 9.046, 0.0], [0.0, 0.0, 16.714]],
                "normalized_wyckoff_matid": {"a": {"X_0": 7, "X_1": 3}}
            },
            {
                "Notes": "LaRhC<sub>2</sub> Structure",
                "Pearsons Symbol": "tP16",
                "Prototype": "C2LaRh",
                "Space Group Number": 76,
                "Space Group Symbol": "$P4_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BC_tP16_76_2a_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC_tP16_76_2a_a_a.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C", "La", "La", "La", "La", "Rh", "Rh", "Rh", "Rh"],
                "atom_positions": [[0.5692922116881999, 0.6887241442101999, 2.06781315919713], [3.4117722057117996, 3.2923402731897995, 9.74343735814713], [3.2923402731897995, 0.5692922116881999, 5.90562525867213], [0.6887241442101999, 3.4117722057117996, 13.58124945762213], [1.4053157393421998, 0.5613300828533999, 3.1116980502543297], [2.5757486780578, 3.4197343345466, 10.78732224920433], [3.4197343345466, 1.4053157393421998, 6.9495101497293295], [0.5613300828533999, 2.5757486780578, 14.62513434867933], [1.37784639486214, 1.3834198850464998, 9.11403617383323], [2.6032180225378596, 2.5976445323535002, 1.4384119748832318], [2.5976445323535002, 1.37784639486214, 12.95184827330823], [1.3834198850464998, 2.6032180225378596, 5.276224074358232], [0.60472368500306, 0.62821196506572, 0.0], [3.37634073239694, 3.35285245233428, 7.67562419895], [3.35285245233428, 0.60472368500306, 3.837812099475], [0.62821196506572, 3.37634073239694, 11.513436298424999]],
                "lattice_vectors": [[3.9810644174, 0.0, 0.0], [0.0, 3.9810644174, 0.0], [0.0, 0.0, 15.3512483979]],
                "normalized_wyckoff_matid": {"a": {"X_0": 2, "X_1": 1, "X_2": 1}}
            }
        ],
        77: [
            {
                "Notes": "Pinnoite (MgB<sub>2</sub>O(OH)<sub>6</sub>) Structure",
                "Pearsons Symbol": "tP64",
                "Prototype": "B2H)6MgOO(",
                "Space Group Number": 77,
                "Space Group Symbol": "$P4_{2}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B6CD7_tP64_77_2d_6d_d_ab6d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B6CD7_tP64_77_2d_6d_d_ab6d.html",
                "atom_labels": ["O", "O", "O", "O", "B", "B", "B", "B", "B", "B", "B", "B", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "Mg", "Mg", "Mg", "Mg", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 4.0928247185], [3.8079761117, 3.8079761117, 0.28649773029500003], [3.8079761117, 3.8079761117, 4.379322448795], [0.88878162447078, 0.91619905247502, 3.421601464666], [6.72717059892922, 6.69975317092498, 3.421601464666], [6.69975317092498, 0.88878162447078, 7.514426183166], [0.91619905247502, 6.72717059892922, 7.514426183166], [2.9854532715728, 2.90700896367178, 1.080505725684], [4.6304989518271995, 4.708943259728221, 1.080505725684], [4.708943259728221, 2.9854532715728, 5.173330444184001], [2.90700896367178, 4.6304989518271995, 5.173330444184001], [2.7569747048708, 0.7539792701166, 2.529365676033], [4.8589775185292, 6.8619729532834, 2.529365676033], [6.8619729532834, 2.7569747048708, 6.622190394533], [0.7539792701166, 4.8589775185292, 6.622190394533], [1.0357695023824, 2.9930692237962, 1.3178895593570001], [6.5801827210176, 4.6228829996037994, 1.3178895593570001], [4.6228829996037994, 1.0357695023824, 5.410714277857], [2.9930692237962, 6.5801827210176, 5.410714277857], [1.4622628268928, 2.703663039307, 3.618057051154], [6.1536893965072, 4.912289184093, 3.618057051154], [4.912289184093, 1.4622628268928, 7.710881769654], [2.703663039307, 6.1536893965072, 7.710881769654], [2.3761770937007998, 1.0129216457122001, 0.24556948311000001], [5.2397751296992, 6.6030305776878, 0.24556948311000001], [6.6030305776878, 2.3761770937007998, 4.338394201610001], [1.0129216457122001, 5.2397751296992, 4.338394201610001], [0.2132466622552, 1.066233311276, 1.1459909211800001], [7.4027055611448, 6.549718912124, 1.1459909211800001], [6.549718912124, 0.2132466622552, 5.23881563968], [1.066233311276, 7.4027055611448, 5.23881563968], [3.5794975449979995, 2.6655832781899997, 2.61940781984], [4.036454678402, 4.95036894521, 2.61940781984], [4.95036894521, 3.5794975449979995, 6.712232538340001], [2.6655832781899997, 4.036454678402, 6.712232538340001], [1.8971336988489398, 5.699017048770219, 2.2346822963010005], [5.71881852455106, 1.9169351746297802, 2.2346822963010005], [1.9169351746297802, 1.8971336988489398, 6.327507014801], [5.699017048770219, 5.71881852455106, 6.327507014801], [1.9816707685286798, 0.14317990179992, 0.106413442681], [5.63428145487132, 7.47277232160008, 0.106413442681], [7.47277232160008, 1.9816707685286798, 4.199238161181], [0.14317990179992, 5.63428145487132, 4.199238161181], [1.7638545349394399, 3.68155130479156, 1.506159496408], [5.852097688460559, 3.9344009186084397, 1.506159496408], [3.9344009186084397, 1.7638545349394399, 5.598984214908], [3.68155130479156, 5.852097688460559, 5.598984214908], [1.2520625455269598, 1.96263088797018, 4.3302085521730005], [6.36388967787304, 5.65332133542982, 4.3302085521730005], [5.65332133542982, 1.2520625455269598, 0.2373838336729993], [1.96263088797018, 6.36388967787304, 0.2373838336729993], [2.59399332729004, 1.8011727008340999, 0.09822779324400001], [5.02195889610996, 5.8147795225659005, 0.09822779324400001], [5.8147795225659005, 2.59399332729004, 4.191052511744], [1.8011727008340999, 5.02195889610996, 4.191052511744], [0.13861033046588, 1.61382027613846, 2.251053595175], [7.4773418929341195, 6.00213194726154, 2.251053595175], [6.00213194726154, 0.13861033046588, 6.343878313675001], [1.61382027613846, 7.4773418929341195, 6.343878313675001], [3.66174982901072, 2.29087842879872, 2.1937540491160004], [3.95420239438928, 5.3250737946012805, 2.1937540491160004], [5.3250737946012805, 3.66174982901072, 6.2865787676160005], [2.29087842879872, 3.95420239438928, 6.2865787676160005]],
                "lattice_vectors": [[7.6159522234, 0.0, 0.0], [0.0, 7.6159522234, 0.0], [0.0, 0.0, 8.185649437]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 1}, "d": {"X_0": 12, "X_1": 12, "X_2": 4, "X_3": 2}}
            },
            {
                "Notes": "H<sub>2</sub>S III Structure",
                "Pearsons Symbol": "tP48",
                "Prototype": "H2S",
                "Space Group Number": 77,
                "Space Group Symbol": "$P4_{2}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_tP48_77_8d_4d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tP48_77_8d_4d.html",
                "atom_labels": ["H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[2.5997100000000004, 1.8858000000000004, 0.6683], [10.870289999999999, 11.584200000000001, 0.6683], [11.584200000000001, 2.5997100000000004, 2.7182999999999997], [1.8858000000000004, 10.870289999999999, 2.7182999999999997], [1.22577, 0.79473, 3.4316999999999998], [12.244230000000002, 12.675270000000001, 3.4316999999999998], [12.675270000000001, 1.22577, 1.3816999999999997], [0.79473, 12.244230000000002, 1.3816999999999997], [9.33471, 1.8858000000000004, 0.6683], [4.135290000000001, 11.584200000000001, 0.6683], [11.584200000000001, 9.33471, 2.7182999999999997], [1.8858000000000004, 4.135290000000001, 2.7182999999999997], [7.96077, 0.79473, 3.4316999999999998], [5.5092300000000005, 12.675270000000001, 3.4316999999999998], [12.675270000000001, 7.96077, 1.3816999999999997], [0.79473, 5.5092300000000005, 1.3816999999999997], [2.5997100000000004, 8.620800000000001, 0.6683], [10.870289999999999, 4.8492, 0.6683], [4.8492, 2.5997100000000004, 2.7182999999999997], [8.620800000000001, 10.870289999999999, 2.7182999999999997], [2.5997100000000004, 8.620800000000001, 3.4316999999999998], [10.870289999999999, 4.8492, 3.4316999999999998], [4.8492, 2.5997100000000004, 1.3816999999999997], [8.620800000000001, 10.870289999999999, 1.3816999999999997], [9.33471, 8.620800000000001, 3.4316999999999998], [4.135290000000001, 4.8492, 3.4316999999999998], [4.8492, 9.33471, 1.3816999999999997], [8.620800000000001, 4.135290000000001, 1.3816999999999997], [7.96077, 7.529730000000001, 0.6683], [5.5092300000000005, 5.94027, 0.6683], [5.94027, 7.96077, 2.7182999999999997], [7.529730000000001, 5.5092300000000005, 2.7182999999999997], [1.4817, 1.8858000000000004, 0.0], [11.9883, 11.584200000000001, 0.0], [11.584200000000001, 1.4817, 2.05], [1.8858000000000004, 11.9883, 2.05], [8.2167, 1.8858000000000004, 0.0], [5.2533, 11.584200000000001, 0.0], [11.584200000000001, 8.2167, 2.05], [1.8858000000000004, 5.2533, 2.05], [1.4817, 8.620800000000001, 0.0], [11.9883, 4.8492, 0.0], [4.8492, 1.4817, 2.05], [8.620800000000001, 11.9883, 2.05], [8.2167, 8.620800000000001, 0.0], [5.2533, 4.8492, 0.0], [4.8492, 8.2167, 2.05], [8.620800000000001, 5.2533, 2.05]],
                "lattice_vectors": [[13.47, 0.0, 0.0], [0.0, 13.47, 0.0], [0.0, 0.0, 4.1]],
                "normalized_wyckoff_matid": {"d": {"X_0": 2, "X_1": 1}}
            }
        ],
        78: [
            {
                "Notes": "Sr<sub>2</sub>As<sub>2</sub>O<sub>7</sub> Structure",
                "Pearsons Symbol": "tP88",
                "Prototype": "As2O7Sr2",
                "Space Group Number": 78,
                "Space Group Symbol": "$P4_{3}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B7C2_tP88_78_4a_14a_4a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B7C2_tP88_78_4a_14a_4a.html",
                "atom_labels": ["As", "As", "As", "As", "As", "As", "As", "As", "As", "As", "As", "As", "As", "As", "As", "As", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr"],
                "atom_positions": [[1.035126412157305, 1.6644770149200698, 17.85331844567251], [6.073770038342695, 5.444419435579929, 5.045324840822512], [5.444419435579929, 1.035126412157305, 11.449321643247512], [1.6644770149200698, 6.073770038342695, 24.257315248097512], [1.5680092900867848, 3.43189085044338, 20.46333138246884], [5.540887160413215, 3.6770056000566194, 7.655337777618841], [3.6770056000566194, 1.5680092900867848, 14.05933458004384], [3.43189085044338, 5.540887160413215, 1.2513409751938407], [1.327444234201865, 0.748211351415125, 7.4604001149530275], [5.781452216298134, 6.360685099084875, 20.268393719803026], [6.360685099084875, 1.327444234201865, 1.0564033125280266], [0.748211351415125, 5.781452216298134, 13.864396917378025], [1.77054174996153, 2.519606168950715, 4.867293729715097], [5.33835470053847, 4.589290281549284, 17.675287334565095], [4.589290281549284, 1.77054174996153, 24.079284136990097], [2.519606168950715, 5.33835470053847, 11.271290532140096], [3.2601399121992998, 2.34522493901995, 0.7367157921509719], [3.8487565383007, 4.763671511480049, 13.544709397000972], [4.763671511480049, 3.2601399121992998, 19.94870619942597], [2.34522493901995, 3.8487565383007, 7.140712594575971], [0.6653927077667999, 2.77175872604995, 3.6477165786612797], [6.443503742733199, 4.3371377244500495, 16.45571018351128], [4.3371377244500495, 0.6653927077667999, 22.859706985936278], [2.77175872604995, 6.443503742733199, 10.051713381086278], [2.97649494382435, 1.5262800679223498, 4.287860099031683], [4.13240150667565, 5.582616382577649, 17.095853703881684], [5.582616382577649, 2.97649494382435, 23.499850506306682], [1.5262800679223498, 4.13240150667565, 10.691856901456683], [0.77131526487925, 1.60732148745805, 6.006692840802553], [6.337581185620749, 5.50157496304195, 18.81468644565255], [5.50157496304195, 0.77131526487925, 25.21868324807755], [1.60732148745805, 6.337581185620749, 12.41068964322755], [2.13195804550495, 1.8667962079012999, 8.397432927083853], [4.97693840499505, 5.2421002425987, 21.205426531933853], [5.2421002425987, 2.13195804550495, 1.993436124658854], [1.8667962079012999, 4.97693840499505, 14.801429729508852], [0.55236125420385, 2.6167847834290496, 19.24785278936858], [6.556535196296149, 4.49211166707095, 6.439859184518576], [4.49211166707095, 0.55236125420385, 12.843855986943575], [2.6167847834290496, 6.556535196296149, 0.03586238209357605], [1.9371742827612501, 2.66654705858255, 16.880423251448104], [5.17172216773875, 4.44234939191745, 4.072429646598109], [4.44234939191745, 1.9371742827612501, 10.476426449023108], [2.66654705858255, 5.17172216773875, 23.284420053873106], [0.39525464264779997, 2.43621881358635, 0.525383897670947], [6.7136418078522, 4.67267763691365, 13.333377502520946], [4.67267763691365, 0.39525464264779997, 19.737374304945945], [2.43621881358635, 6.7136418078522, 6.9293807000959475], [2.31110223605755, 2.15897185201685, 13.332352863032558], [4.79779421444245, 4.9499245984831495, 0.5243592581825587], [4.9499245984831495, 2.31110223605755, 6.928356060607558], [2.15897185201685, 4.79779421444245, 19.736349665457556], [3.42009008233555, 0.3881457461973, 15.198989851003397], [3.688806368164449, 6.7207507043026995, 2.390996246153397], [6.7207507043026995, 3.42009008233555, 8.794993048578396], [0.3881457461973, 3.688806368164449, 21.602986653428395], [0.018483130771299996, 0.00639800680545, 8.102849074172303], [7.090413319728699, 7.102498443694549, 20.910842679022302], [7.102498443694549, 0.018483130771299996, 1.6988522717473022], [0.00639800680545, 7.090413319728699, 14.506845876597302], [2.7106222165756497, 2.3701060765966995, 21.034567897245154], [4.39827423392435, 4.7387903739033, 8.226574292395156], [4.7387903739033, 2.7106222165756497, 14.630571094820155], [2.3701060765966995, 4.39827423392435, 1.8225774899701561], [2.00257613010585, 0.4094724355488, 18.38613097963427], [5.10632032039415, 6.6994240149512, 5.57813737478427], [6.6994240149512, 2.00257613010585, 11.98213417720927], [0.4094724355488, 5.10632032039415, 24.79012778205927], [1.194294603684, 0.35757749146014994, 23.520343296074444], [5.914601846816, 6.75131895903985, 10.712349691224443], [6.75131895903985, 1.194294603684, 17.116346493649445], [0.35757749146014994, 5.914601846816, 4.308352888799443], [1.8791656877251701, 1.6127953377249349, 10.922144626471885], [5.22973076277483, 5.496101112775064, 23.730138231321884], [5.496101112775064, 1.8791656877251701, 4.518147824046885], [1.6127953377249349, 5.22973076277483, 17.326141428896886], [0.192011293128005, 2.4754599219931097, 14.682571548855845], [6.916885157371995, 4.63343652850689, 1.8745779440058465], [4.63343652850689, 0.192011293128005, 8.278574746430847], [2.4754599219931097, 6.916885157371995, 21.086568351280846], [1.09533876509304, 2.81398557096592, 23.7882865222879], [6.01355768540696, 4.29491087953408, 10.980292917437904], [4.29491087953408, 1.09533876509304, 17.384289719862903], [2.81398557096592, 6.01355768540696, 4.576296115012905], [2.663632411037845, 1.8318915263293447, 1.6558174132350079], [4.445264039462155, 5.2770049241706545, 14.463811018085007], [5.2770049241706545, 2.663632411037845, 20.867807820510006], [1.8318915263293447, 4.445264039462155, 8.059814215660008]],
                "lattice_vectors": [[7.1088964505, 0.0, 0.0], [0.0, 7.1088964505, 0.0], [0.0, 0.0, 25.6159872097]],
                "normalized_wyckoff_matid": {"a": {"X_0": 7, "X_1": 2, "X_2": 2}}
            }
        ],
        79: [
            {
                "Notes": "TlZn<sub>2</sub>Sb<sub>2</sub> Structure",
                "Pearsons Symbol": "tI20",
                "Prototype": "Sb2TlZn2",
                "Space Group Number": 79,
                "Space Group Symbol": "$I4$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BC2_tI20_79_c_2a_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC2_tI20_79_c_2a_c.html",
                "atom_labels": ["Tl", "Tl", "Tl", "Tl", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.32448545635, 4.32448545635, 3.6434877466], [0.0, 0.0, 3.56770320147072], [4.32448545635, 4.32448545635, 7.21119094807072], [2.9147031975799, 1.4184312296827999, 1.60021981830672], [5.7342677151201, 7.2305396830171995, 1.60021981830672], [7.2305396830171995, 2.9147031975799, 1.60021981830672], [1.4184312296827999, 5.7342677151201, 1.60021981830672], [7.239188653929899, 5.7429166860328, 5.24370756490672], [1.4097822587700997, 2.9060542266671994, 5.24370756490672], [2.9060542266671994, 7.239188653929899, 5.24370756490672], [5.7429166860328, 1.4097822587700997, 5.24370756490672], [1.31377868163913, 1.3648076100240598, 0.0], [7.335192231060869, 7.28416330267594, 0.0], [7.28416330267594, 1.31377868163913, 0.0], [1.3648076100240598, 7.335192231060869, 0.0], [5.63826413798913, 5.689293066374059, 3.6434877466], [3.0107067747108696, 2.9596778463259397, 3.6434877466], [2.9596778463259397, 5.63826413798913, 3.6434877466], [5.689293066374059, 3.0107067747108696, 3.6434877466]],
                "lattice_vectors": [[8.6489709127, 0.0, 0.0], [0.0, 8.6489709127, 0.0], [0.0, 0.0, 7.2869754932]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "c": {"X_0": 2, "X_1": 2}}
            }
        ],
        80: [
            {
                "Notes": "$\\beta$&ndash;NbO<sub>2</sub> Structure",
                "Pearsons Symbol": "tI48",
                "Prototype": "NbO2",
                "Space Group Number": 80,
                "Space Group Symbol": "$I4_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_tI48_80_2b_4b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_tI48_80_2b_4b.html",
                "atom_labels": ["Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[2.5405352999999997, 4.9201668000000005, 0.1789515], [7.1524646999999995, 4.772833199999999, 0.1789515], [4.772833199999999, 7.3870353, 1.6752015], [4.9201668000000005, 2.3059647, 1.6752015], [7.3870353, 0.07366680000000049, 3.1714515000000003], [2.3059647, 9.6193332, 3.1714515000000003], [9.6193332, 2.5405352999999997, 4.667701500000001], [0.07366680000000049, 7.1524646999999995, 4.667701500000001], [2.3796315, 4.758293699999999, 2.875194], [7.313368499999999, 4.9347063, 2.875194], [4.9347063, 7.2261315, 4.371443999999999], [4.758293699999999, 2.4668685, 4.371443999999999], [7.2261315, 9.6047937, 5.867694], [2.4668685, 0.08820629999999997, 5.867694], [0.08820629999999997, 2.3796315, 1.3789439999999997], [9.6047937, 7.313368499999999, 1.3789439999999997], [3.8519981999999997, 1.4510421, 0.04608450000000001], [5.8410018, 8.241957900000001, 0.04608450000000001], [8.241957900000001, 8.6984982, 1.5423345], [1.4510421, 0.9945018000000002, 1.5423345], [8.6984982, 6.297542099999999, 3.0385845000000002], [0.9945018000000002, 3.3954579, 3.0385845000000002], [3.3954579, 3.8519981999999997, 4.5348345000000005], [6.297542099999999, 5.8410018, 4.5348345000000005], [1.0681686, 3.5301906, 5.926347], [8.6248314, 6.162809399999999, 5.926347], [6.162809399999999, 5.9146686, 1.437597], [3.5301906, 3.7783313999999995, 1.437597], [5.9146686, 8.3766906, 2.933847], [3.7783313999999995, 1.3163093999999997, 2.933847], [1.3163093999999997, 1.0681686, 4.430097], [8.3766906, 8.6248314, 4.430097], [5.8991598, 3.4982037, 3.030804], [3.7938401999999996, 6.1947963, 3.030804], [6.1947963, 1.0526598000000003, 4.527054], [3.4982037, 8.640340199999999, 4.527054], [1.0526598000000003, 8.3447037, 0.03830399999999977], [8.640340199999999, 1.3482963, 0.03830399999999977], [1.3482963, 5.8991598, 1.5345539999999998], [8.3447037, 3.7938401999999996, 1.5345539999999998], [6.30045, 1.0061334, 1.486674], [3.3925499999999995, 8.6868666, 1.486674], [8.6868666, 1.4539499999999992, 2.982924], [1.0061334, 8.239049999999999, 2.982924], [1.4539499999999992, 5.8526334, 4.4791739999999995], [8.239049999999999, 3.8403666, 4.4791739999999995], [3.8403666, 6.30045, 5.975424], [5.8526334, 3.3925499999999995, 5.975424]],
                "lattice_vectors": [[9.693, 0.0, 0.0], [0.0, 9.693, 0.0], [0.0, 0.0, 5.985]],
                "normalized_wyckoff_matid": {"b": {"X_0": 2, "X_1": 1}}
            }
        ],
        81: [
            {
                "Notes": "GeSe<sub>2</sub> (High&ndash;pressure) Structure",
                "Pearsons Symbol": "tP12",
                "Prototype": "GeSe2",
                "Space Group Number": 81,
                "Space Group Symbol": "$P\\bar{4}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_tP12_81_adg_2h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_tP12_81_adg_2h.html",
                "atom_labels": ["Ge", "Ge", "Ge", "Ge", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.6695510219, 2.6695510219, 5.01823990165], [0.0, 2.6695510219, 2.509119950825], [2.6695510219, 0.0, 7.5273598524750005], [1.4623800497968198, 1.2493498782492, 1.2846694148224], [3.8767219940031796, 4.0897521655508, 1.2846694148224], [1.2493498782492, 3.8767219940031796, 8.751810388477601], [4.0897521655508, 1.4623800497968198, 8.751810388477601], [1.2221204578258198, 1.227993470074, 6.39624857864309], [4.116981585974179, 4.111108573726, 6.39624857864309], [1.227993470074, 4.116981585974179, 3.6402312246569104], [4.111108573726, 1.2221204578258198, 3.6402312246569104]],
                "lattice_vectors": [[5.3391020438, 0.0, 0.0], [0.0, 5.3391020438, 0.0], [0.0, 0.0, 10.0364798033]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_1": 1}, "g": {"X_1": 2}, "h": {"X_0": 8}}
            }
        ],
        82: [
            {
                "Notes": "CdAl<sub>2</sub>S<sub>4</sub> (E3) Structure",
                "Pearsons Symbol": "tI14",
                "Prototype": "Al2CdS4",
                "Space Group Number": 82,
                "Space Group Symbol": "$I\\bar{4}$",
                "Strukturbericht Designation": "$E3$",
                "aflow_prototype_id": "A2BC4_tI14_82_bc_a_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC4_tI14_82_bc_a_g.html",
                "atom_labels": ["Cd", "Cd", "Al", "Al", "Al", "Al", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.775, 2.775, 5.15], [0.0, 0.0, 5.15], [2.775, 2.775, 0.0], [0.0, 2.775, 2.575], [2.775, 0.0, 7.7250000000000005], [1.443, 1.3875, 1.3390000000000002], [4.107, 4.1625, 1.3390000000000002], [1.3875, 4.107, 8.961], [4.1625, 1.443, 8.961], [4.218, 4.1625, 6.489000000000001], [1.3319999999999999, 1.3875, 6.489000000000001], [4.1625, 1.3319999999999999, 3.8110000000000004], [1.3875, 4.218, 3.8110000000000004]],
                "lattice_vectors": [[5.55, 0.0, 0.0], [0.0, 5.55, 0.0], [0.0, 0.0, 10.3]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "d": {"X_1": 1}, "g": {"X_0": 4}}
            },
            {
                "Notes": "BPO<sub>4</sub> (H0<sub>7</sub>) Structure",
                "Pearsons Symbol": "tI12",
                "Prototype": "BO4P",
                "Space Group Number": 82,
                "Space Group Symbol": "$I\\bar{4}$",
                "Strukturbericht Designation": "$H0_{7}$",
                "aflow_prototype_id": "AB4C_tI12_82_c_g_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4C_tI12_82_c_g_a.html",
                "atom_labels": ["P", "P", "B", "B", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.1702, 2.1702, 3.3251], [0.0, 2.1702, 1.66255], [2.1702, 0.0, 4.98765], [1.1111424, 1.11374664, 2.4752044399999997], [3.2292576, 3.2266533600000002, 2.4752044399999997], [1.11374664, 3.2292576, 4.17499556], [3.2266533600000002, 1.1111424, 4.17499556], [3.2813423999999998, 3.2839466399999995, 5.80030444], [1.0590575999999998, 1.05645336, 5.80030444], [3.2839466399999995, 1.0590575999999998, 0.8498955600000001], [1.05645336, 3.2813423999999998, 0.8498955600000001]],
                "lattice_vectors": [[4.3404, 0.0, 0.0], [0.0, 4.3404, 0.0], [0.0, 0.0, 6.6502]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_2": 1}, "g": {"X_0": 4}}
            },
            {
                "Notes": "Ni<sub>3</sub>P ($D0_{e}$) Structure",
                "Pearsons Symbol": "tI32",
                "Prototype": "Ni3P",
                "Space Group Number": 82,
                "Space Group Symbol": "$I\\bar{4}$",
                "Strukturbericht Designation": "$D0_{e}$",
                "aflow_prototype_id": "A3B_tI32_82_3g_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_tI32_82_3g_g.html",
                "atom_labels": ["Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "P", "P", "P", "P", "P", "P", "P", "P"],
                "atom_positions": [[0.6939350000000001, 1.0001618, 1.06126926], [8.260065, 7.953838200000001, 1.06126926], [1.0001618, 8.260065, 3.37733074], [7.953838200000001, 0.6939350000000001, 3.37733074], [5.170935, 5.4771618, 3.28056926], [3.783065, 3.4768382, 3.28056926], [5.4771618, 3.783065, 1.15803074], [3.4768382, 5.170935, 1.15803074], [3.2673146, 0.2874234, 4.3342929], [5.6866854, 8.6665766, 4.3342929], [0.2874234, 5.6866854, 0.10430709999999985], [8.6665766, 3.2673146, 0.10430709999999985], [7.744314600000001, 4.7644234, 2.1149929000000007], [1.2096854000000001, 4.1895766000000005, 2.1149929000000007], [4.7644234, 1.2096854000000001, 2.3236071], [4.1895766000000005, 7.744314600000001, 2.3236071], [1.5123306, 1.96988, 3.33960264], [7.4416694, 6.984120000000001, 3.33960264], [1.96988, 7.4416694, 1.0989973600000003], [6.984120000000001, 1.5123306, 1.0989973600000003], [5.989330600000001, 6.44688, 1.1203026399999998], [2.9646694000000005, 2.5071200000000005, 1.1203026399999998], [6.44688, 2.9646694000000005, 3.3182973600000003], [2.5071200000000005, 5.989330600000001, 3.3182973600000003], [2.5626348, 0.43605980000000005, 2.1336350200000003], [6.3913652, 8.517940200000002, 2.1336350200000003], [0.43605980000000005, 6.3913652, 2.30496498], [8.517940200000002, 2.5626348, 2.30496498], [7.039634800000001, 4.9130598, 4.35293502], [1.9143652, 4.0409402000000005, 4.35293502], [4.9130598, 1.9143652, 0.08566497999999993], [4.0409402000000005, 7.039634800000001, 0.08566497999999993]],
                "lattice_vectors": [[8.954, 0.0, 0.0], [0.0, 8.954, 0.0], [0.0, 0.0, 4.4386]],
                "normalized_wyckoff_matid": {"g": {"X_0": 3, "X_1": 1}}
            }
        ],
        83: [
            {
                "Notes": "Ti<sub>2</sub>Ge<sub>3</sub> Structure",
                "Pearsons Symbol": "tP10",
                "Prototype": "Ge3Ti2",
                "Space Group Number": 83,
                "Space Group Symbol": "$P4/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B2_tP10_83_adk_j",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B2_tP10_83_adk_j.html",
                "atom_labels": ["Ge", "Ge", "Ti", "Ti", "Ti", "Ti", "Ge", "Ge", "Ge", "Ge"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.1420032372, 3.1420032372, 2.00500206575], [2.3565024278999998, 1.2002452366104, 0.0], [3.9275040465, 5.0837612377895995, 0.0], [5.0837612377895995, 2.3565024278999998, 0.0], [1.2002452366104, 3.9275040465, 0.0], [0.6849567057096, 1.9731780329616, 2.00500206575], [5.5990497686904, 4.3108284414383995, 2.00500206575], [4.3108284414383995, 0.6849567057096, 2.00500206575], [1.9731780329616, 5.5990497686904, 2.00500206575]],
                "lattice_vectors": [[6.2840064744, 0.0, 0.0], [0.0, 6.2840064744, 0.0], [0.0, 0.0, 4.0100041315]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "d": {"X_0": 1}, "j": {"X_1": 4}, "k": {"X_0": 4}}
            }
        ],
        84: [
            {
                "Notes": "PdS (B34) Structure",
                "Pearsons Symbol": "tP16",
                "Prototype": "PdS",
                "Space Group Number": 84,
                "Space Group Symbol": "$P4_{2}/m$",
                "Strukturbericht Designation": "$B34$",
                "aflow_prototype_id": "AB_tP16_84_cej_k",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tP16_84_cej_k.html",
                "atom_labels": ["Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 3.2145, 0.0], [3.2145, 0.0, 3.3055], [0.0, 0.0, 1.65275], [0.0, 0.0, 4.95825], [3.00742191, 1.6530887700000003, 0.0], [3.4215780900000006, 4.775911229999999, 0.0], [4.775911229999999, 3.00742191, 3.3055], [1.6530887700000003, 3.4215780900000006, 3.3055], [1.24471869, 1.97717466, 1.5141834399999998], [5.18428131, 4.451825340000001, 1.5141834399999998], [4.451825340000001, 1.24471869, 4.81968344], [1.97717466, 5.18428131, 4.81968344], [5.18428131, 4.451825340000001, 5.09681656], [1.24471869, 1.97717466, 5.09681656], [1.97717466, 5.18428131, 1.7913165599999998], [4.451825340000001, 1.24471869, 1.7913165599999998]],
                "lattice_vectors": [[6.429, 0.0, 0.0], [0.0, 6.429, 0.0], [0.0, 0.0, 6.611]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "e": {"X_0": 1}, "j": {"X_0": 2}, "k": {"X_1": 4}}
            }
        ],
        85: [
            {
                "Notes": "SrBr<sub>2</sub> Structure",
                "Pearsons Symbol": "tP30",
                "Prototype": "Br2Sr",
                "Space Group Number": 85,
                "Space Group Symbol": "$P4/n$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_tP30_85_ab2g_cg",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tP30_85_ab2g_cg.html",
                "atom_labels": ["Br", "Br", "Br", "Br", "Sr", "Sr", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Br", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr"],
                "atom_positions": [[2.9044975667, 8.7134927001, 0.0], [8.7134927001, 2.9044975667, 0.0], [2.9044975667, 8.7134927001, 3.56899701], [8.7134927001, 2.9044975667, 3.56899701], [2.9044975667, 2.9044975667, 4.651830702833999], [8.7134927001, 8.7134927001, 2.4861633171660005], [6.306245116819039, 7.68181516440816, 4.256385834126], [11.120740283380961, 9.74517023579184, 4.256385834126], [9.74517023579184, 6.306245116819039, 4.256385834126], [7.68181516440816, 11.120740283380961, 4.256385834126], [5.31174514998096, 3.93617510239184, 2.8816081858739997], [0.4972499834190394, 1.87282003100816, 2.8816081858739997], [1.87282003100816, 5.31174514998096, 2.8816081858739997], [3.93617510239184, 0.4972499834190394, 2.8816081858739997], [7.58770944324708, 6.2853327343388, 0.8979596477159999], [9.83927595695292, 11.1416526658612, 0.8979596477159999], [11.1416526658612, 7.58770944324708, 0.8979596477159999], [6.2853327343388, 9.83927595695292, 0.8979596477159999], [4.0302808235529195, 5.3326575324612, 6.240034372284], [1.7787143098470801, 0.4763376009387991, 6.240034372284], [0.4763376009387991, 4.0302808235529195, 6.240034372284], [5.3326575324612, 1.7787143098470801, 6.240034372284], [6.80349510023808, 1.2140799828806, 1.801629690648], [10.623490299961919, 4.5949151505194, 1.801629690648], [4.5949151505194, 6.80349510023808, 1.801629690648], [1.2140799828806, 10.623490299961919, 1.801629690648], [4.81449516656192, 10.4039102839194, 5.3363643293520004], [0.9944999668380788, 7.023075116280601, 5.3363643293520004], [7.023075116280601, 4.81449516656192, 5.3363643293520004], [10.4039102839194, 0.9944999668380788, 5.3363643293520004]],
                "lattice_vectors": [[11.6179902668, 0.0, 0.0], [0.0, 11.6179902668, 0.0], [0.0, 0.0, 7.13799402]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 1}, "c": {"X_1": 1}, "g": {"X_0": 8, "X_1": 4}}
            }
        ],
        86: [
            {
                "Notes": "Ti<sub>3</sub>P Structure",
                "Pearsons Symbol": "tP32",
                "Prototype": "PTi3",
                "Space Group Number": 86,
                "Space Group Symbol": "$P4_{2}/n$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_tP32_86_g_3g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_tP32_86_g_3g.html",
                "atom_labels": ["P", "P", "P", "P", "P", "P", "P", "P", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti"],
                "atom_positions": [[0.4389121707187, 2.0807836211839597, 2.67592902149764], [4.5600874957813, 2.91821604531604, 2.67592902149764], [7.91721571181604, 5.4379118372187, 0.1769291881976405], [7.079783287683959, 9.5590871622813, 0.1769291881976405], [9.5590871622813, 7.91721571181604, 2.32207064510236], [5.4379118372187, 7.079783287683959, 2.32207064510236], [2.0807836211839597, 4.5600874957813, 4.82107047840236], [2.91821604531604, 0.4389121707187, 4.82107047840236], [1.1006797465699698, 2.21465683225283, 0.1474409901647], [3.8983199199300294, 2.78434283424717, 0.1474409901647], [7.783342500747169, 6.099679413069969, 2.6464408234647], [7.2136564987528295, 8.89731958643003, 2.6464408234647], [8.89731958643003, 7.783342500747169, 4.8505586764353], [6.099679413069969, 7.2136564987528295, 4.8505586764353], [2.21465683225283, 3.8983199199300294, 2.3515588431353], [2.78434283424717, 1.1006797465699698, 2.3515588431353], [1.4272144047857498, 6.659967295691289, 3.5750691615189805], [3.57178526171425, 8.337031703808709, 3.5750691615189805], [3.3380320373087096, 6.426214071285749, 1.0760693282189804], [1.6609676291912887, 8.57078492821425, 1.0760693282189804], [8.57078492821425, 3.3380320373087096, 1.4229305050810197], [6.426214071285749, 1.6609676291912887, 1.4229305050810197], [6.659967295691289, 3.57178526171425, 3.92193033838102], [8.337031703808709, 1.4272144047857498, 3.92193033838102], [5.3331328042088595, 0.69556081359681, 3.79498114684938], [9.663866195291138, 4.30343885290319, 3.79498114684938], [9.30243851940319, 0.33413313770886005, 1.2959813135493805], [5.6945604800968095, 4.66486652879114, 1.2959813135493805], [4.66486652879114, 9.30243851940319, 1.2030185197506202], [0.33413313770886005, 5.6945604800968095, 1.2030185197506202], [0.69556081359681, 9.663866195291138, 3.70201835305062], [4.30343885290319, 5.3331328042088595, 3.70201835305062]],
                "lattice_vectors": [[9.997999333, 0.0, 0.0], [0.0, 9.997999333, 0.0], [0.0, 0.0, 4.9979996666]],
                "normalized_wyckoff_matid": {"g": {"X_0": 3, "X_1": 1}}
            }
        ],
        87: [
            {
                "Notes": "Ni<sub>4</sub>Mo (D1<sub>a</sub>) Structure",
                "Pearsons Symbol": "tI10",
                "Prototype": "MoNi4",
                "Space Group Number": 87,
                "Space Group Symbol": "$I4/m$",
                "Strukturbericht Designation": "$D1_{a}$",
                "aflow_prototype_id": "AB4_tI10_87_a_h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4_tI10_87_a_h.html",
                "atom_labels": ["Mo", "Mo", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.86, 2.86, 1.782], [2.288, 4.576, 0.0], [3.432, 1.1439999999999997, 0.0], [1.1439999999999997, 2.288, 0.0], [4.576, 3.432, 0.0], [5.148, 1.7160000000000002, 1.782], [0.5719999999999998, 4.004, 1.782], [4.004, 5.148, 1.782], [1.7160000000000002, 0.5719999999999998, 1.782]],
                "lattice_vectors": [[5.72, 0.0, 0.0], [0.0, 5.72, 0.0], [0.0, 0.0, 3.564]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "h": {"X_0": 4}}
            },
            {
                "Notes": "Ti<sub>5</sub>Te<sub>4</sub> Structure",
                "Pearsons Symbol": "tI18",
                "Prototype": "Te4Ti5",
                "Space Group Number": 87,
                "Space Group Symbol": "$I4/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B5_tI18_87_h_ah",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B5_tI18_87_h_ah.html",
                "atom_labels": ["Ti", "Ti", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti"],
                "atom_positions": [[0.0, 0.0, 0.0], [5.082, 5.082, 1.886], [2.8428708, 9.5653404, 0.0], [7.321129199999999, 0.5986596, 0.0], [0.5986596, 2.8428708, 0.0], [9.5653404, 7.321129199999999, 0.0], [7.924870800000001, 4.4833403999999994, 1.886], [2.2391292, 5.680659599999999, 1.886], [5.680659599999999, 7.924870800000001, 1.886], [4.4833403999999994, 2.2391292, 1.886], [3.8135327999999995, 6.968438399999999, 0.0], [6.3504672, 3.1955616, 0.0], [3.1955616, 3.8135327999999995, 0.0], [6.968438399999999, 6.3504672, 0.0], [8.8955328, 1.8864383999999998, 1.886], [1.2684672000000001, 8.2775616, 1.886], [8.2775616, 8.8955328, 1.886], [1.8864383999999998, 1.2684672000000001, 1.886]],
                "lattice_vectors": [[10.164, 0.0, 0.0], [0.0, 10.164, 0.0], [0.0, 0.0, 3.772]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "h": {"X_0": 4, "X_1": 4}}
            }
        ],
        88: [
            {
                "Notes": "$\\alpha$&ndash;NbO<sub>2</sub> Structure",
                "Pearsons Symbol": "tI96",
                "Prototype": "NbO2",
                "Space Group Number": 88,
                "Space Group Symbol": "$I4_{1}/a$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_tI96_88_2f_4f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_tI96_88_2f_4f.html",
                "atom_labels": ["Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[1.57773, 1.706134, 2.8305144], [12.08227, 5.123866, 2.8305144], [8.538866, 4.99273, 4.321514400000001], [5.1211340000000005, 1.8372700000000002, 4.321514400000001], [12.08227, 11.953866, 3.1334856], [1.57773, 8.536134, 3.1334856], [5.1211340000000005, 8.66727, 1.6424855999999999], [8.538866, 11.82273, 1.6424855999999999], [8.40773, 8.536134, 5.8125144], [5.25227, 11.953866, 5.8125144], [1.7088659999999998, 11.82273, 1.339514400000001], [11.951134, 8.66727, 1.339514400000001], [5.25227, 5.123866, 0.1514855999999999], [8.40773, 1.706134, 0.1514855999999999], [11.951134, 1.8372700000000002, 4.6244856], [1.7088659999999998, 4.99273, 4.6244856], [1.852296, 1.7075, 0.1592388], [11.807704000000001, 5.1225000000000005, 0.1592388], [8.5375, 5.267296, 1.6502388000000001], [5.1225000000000005, 1.562704, 1.6502388000000001], [11.807704000000001, 11.9525, 5.804761200000001], [1.852296, 8.5375, 5.804761200000001], [5.1225000000000005, 8.392704, 4.313761200000001], [8.5375, 12.097296, 4.313761200000001], [8.682296, 8.5375, 3.1412388], [4.977704, 11.9525, 3.1412388], [1.7075, 12.097296, 4.6322388], [11.9525, 8.392704, 4.6322388], [4.977704, 5.1225000000000005, 2.8227612], [8.682296, 1.7075, 2.8227612], [11.9525, 1.562704, 1.3317612], [1.7075, 5.267296, 1.3317612], [13.476956000000001, 1.7238920000000002, 5.9365656], [0.183044, 5.106108000000001, 5.9365656], [8.521108, 3.2319560000000003, 1.4635656000000001], [5.138891999999999, 3.5980440000000002, 1.4635656000000001], [0.183044, 11.936108, 0.0274344], [13.476956000000001, 8.553892, 0.0274344], [5.138891999999999, 10.428044, 4.5004344000000005], [8.521108, 10.061956, 4.5004344000000005], [6.646955999999999, 8.553892, 2.9545656000000005], [7.013044, 11.936108, 2.9545656000000005], [1.6911079999999998, 10.061956, 4.4455656], [11.968892, 10.428044, 4.4455656], [7.013044, 5.106108000000001, 3.0094344000000004], [6.646955999999999, 1.7238920000000002, 3.0094344000000004], [11.968892, 3.5980440000000002, 1.5184344], [1.6911079999999998, 3.2319560000000003, 1.5184344], [13.317134, 1.7102320000000002, 2.982], [0.342866, 5.1197680000000005, 2.982], [8.534768, 3.0721339999999997, 4.473000000000001], [5.125232, 3.7578660000000004, 4.473000000000001], [0.342866, 11.949768, 2.982], [13.317134, 8.540232, 2.982], [5.125232, 10.587866, 1.491], [8.534768, 9.902134, 1.491], [6.487134, 8.540232, 0.0], [7.172866, 11.949768, 0.0], [1.7047679999999998, 9.902134, 1.491], [11.955232, 10.587866, 1.491], [7.172866, 5.1197680000000005, 0.0], [6.487134, 1.7102320000000002, 0.0], [11.955232, 3.7578660000000004, 4.473000000000001], [1.7047679999999998, 3.0721339999999997, 4.473000000000001], [3.7414739999999997, 1.70067, 5.9628072], [9.918526, 5.12933, 5.9628072], [8.544329999999999, 7.156474, 1.4898072], [5.11567, 13.333525999999999, 1.4898072], [9.918526, 11.95933, 0.0011928000000000002], [3.7414739999999997, 8.53067, 0.0011928000000000002], [5.11567, 6.503526000000001, 4.4741928], [8.544329999999999, 0.32647400000000043, 4.4741928], [10.571474, 8.53067, 2.9808072000000005], [3.0885260000000003, 11.95933, 2.9808072000000005], [1.7143300000000001, 0.32647400000000043, 4.471807200000001], [11.945670000000002, 6.503526000000001, 4.471807200000001], [3.0885260000000003, 5.12933, 2.9831928], [10.571474, 1.70067, 2.9831928], [11.945670000000002, 13.333525999999999, 1.4921928], [1.7143300000000001, 7.156474, 1.4921928], [3.593946, 1.695206, 3.0076452000000002], [10.066054, 5.134794, 3.0076452000000002], [8.549794, 7.008946, 4.4986452], [5.110206, 13.481054, 4.4986452], [10.066054, 11.964794, 2.9563548], [3.593946, 8.525206, 2.9563548], [5.110206, 6.651054, 1.4653548000000003], [8.549794, 0.17894600000000152, 1.4653548000000003], [10.423946, 8.525206, 0.025645199999999826], [3.236054, 11.964794, 0.025645199999999826], [1.7197940000000003, 0.17894600000000152, 1.5166452], [11.940206, 6.651054, 1.5166452], [3.236054, 5.134794, 5.938354800000001], [10.423946, 1.695206, 5.938354800000001], [11.940206, 13.481054, 4.4473548], [1.7197940000000003, 7.008946, 4.4473548]],
                "lattice_vectors": [[13.66, 0.0, 0.0], [0.0, 13.66, 0.0], [0.0, 0.0, 5.964]],
                "normalized_wyckoff_matid": {"f": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "ThCl<sub>4</sub> Structure",
                "Pearsons Symbol": "tI20",
                "Prototype": "Cl4Th",
                "Space Group Number": 88,
                "Space Group Symbol": "$I4_{1}/a$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B_tI20_88_f_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B_tI20_88_f_a.html",
                "atom_labels": ["Th", "Th", "Th", "Th", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[0.0, 1.60199870725, 1.6154986963625], [3.2039974145, 1.60199870725, 4.8464960890875], [0.0, 4.80599612175, 11.3084908745375], [3.2039974145, 4.80599612175, 8.0774934818125], [0.9419752398629999, 0.108935912093, 3.8513488921282], [5.466019589137, 3.095061502407, 3.8513488921282], [4.697060209657, 2.543973947113, 7.082346284853201], [1.710934619343, 0.660023467387, 7.082346284853201], [5.466019589137, 6.299058916907, 9.0726406787718], [0.9419752398629999, 3.312933326593, 9.0726406787718], [1.710934619343, 3.864020881887, 5.8416432860468], [4.697060209657, 5.747971361613, 5.8416432860468], [4.145972654363, 3.312933326593, 10.313343677578201], [2.262022174637, 6.299058916907, 10.313343677578201], [1.493062795157, 5.747971361613, 0.6203514994032006], [4.914932033843, 3.864020881887, 0.6203514994032006], [2.262022174637, 3.095061502407, 2.6106458933218], [4.145972654363, 0.108935912093, 2.6106458933218], [4.914932033843, 0.660023467387, 12.303638071496799], [1.493062795157, 2.543973947113, 12.303638071496799]],
                "lattice_vectors": [[6.407994829, 0.0, 0.0], [0.0, 6.407994829, 0.0], [0.0, 0.0, 12.9239895709]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "f": {"X_0": 4}}
            }
        ],
        89: [
            {
                "Notes": "C<sub>17</sub>FeO<sub>4</sub>Pt Structure",
                "Pearsons Symbol": "tP184",
                "Prototype": "C17FeO4Pt",
                "Space Group Number": 89,
                "Space Group Symbol": "$P422$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A17BC4D_tP184_89_17p_p_4p_io",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A17BC4D_tP184_89_17p_p_4p_io.html",
                "atom_labels": ["Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 8.12515, 11.556642048], [0.0, 8.12515, 1.7617579519999995], [8.12515, 0.0, 1.7617579519999995], [8.12515, 0.0, 11.556642048], [1.781357886, 8.12515, 0.0], [14.468942113999999, 8.12515, 0.0], [8.12515, 14.468942113999999, 0.0], [8.12515, 1.781357886, 0.0], [2.77717627, 7.881395499999999, 10.51221312], [2.77717627, 8.3689045, 2.8061868800000003], [13.47312373, 7.881395499999999, 2.8061868800000003], [13.47312373, 8.3689045, 10.51221312], [8.3689045, 13.47312373, 2.8061868800000003], [8.3689045, 2.77717627, 10.51221312], [7.881395499999999, 13.47312373, 10.51221312], [7.881395499999999, 2.77717627, 2.8061868800000003], [3.7928200199999997, 7.51901381, 9.460059520000001], [3.7928200199999997, 8.73128619, 3.8583404799999994], [12.457479979999999, 7.51901381, 3.8583404799999994], [12.457479979999999, 8.73128619, 9.460059520000001], [8.73128619, 12.457479979999999, 3.8583404799999994], [8.73128619, 3.7928200199999997, 9.460059520000001], [7.51901381, 12.457479979999999, 9.460059520000001], [7.51901381, 3.7928200199999997, 3.8583404799999994], [3.48731438, 7.12250649, 8.157520000000002], [3.48731438, 9.12779351, 5.16088], [12.762985619999998, 7.12250649, 5.16088], [12.762985619999998, 9.12779351, 8.157520000000002], [9.12779351, 12.762985619999998, 5.16088], [9.12779351, 3.48731438, 8.157520000000002], [7.12250649, 12.762985619999998, 8.157520000000002], [7.12250649, 3.48731438, 5.16088], [4.688211549999999, 6.7601248, 7.499591040000001], [4.688211549999999, 9.490175200000001, 5.818808959999999], [11.56208845, 6.7601248, 5.818808959999999], [11.56208845, 9.490175200000001, 7.499591040000001], [9.490175200000001, 11.56208845, 5.818808959999999], [9.490175200000001, 4.688211549999999, 7.499591040000001], [6.7601248, 11.56208845, 7.499591040000001], [6.7601248, 4.688211549999999, 5.818808959999999], [5.7526062, 6.89337726, 8.42122432], [5.7526062, 9.35692274, 4.89717568], [10.4976938, 6.89337726, 4.89717568], [10.4976938, 9.35692274, 8.42122432], [9.35692274, 10.4976938, 4.89717568], [9.35692274, 5.7526062, 8.42122432], [6.89337726, 10.4976938, 8.42122432], [6.89337726, 5.7526062, 4.89717568], [5.2098461799999995, 7.441012369999999, 9.60123456], [5.2098461799999995, 8.80928763, 3.7171654400000005], [11.04045382, 7.441012369999999, 3.7171654400000005], [11.04045382, 8.80928763, 9.60123456], [8.80928763, 11.04045382, 3.7171654400000005], [8.80928763, 5.2098461799999995, 9.60123456], [7.441012369999999, 11.04045382, 9.60123456], [7.441012369999999, 5.2098461799999995, 3.7171654400000005], [3.8025702, 3.6725678, 8.8034624], [3.8025702, 12.5777322, 4.5149376], [12.4477298, 3.6725678, 4.5149376], [12.4477298, 12.5777322, 8.8034624], [12.5777322, 12.4477298, 4.5149376], [12.5777322, 3.8025702, 8.8034624], [3.6725678, 12.4477298, 8.8034624], [3.6725678, 3.8025702, 4.5149376], [5.055468329999999, 3.69694325, 9.269606399999999], [5.055468329999999, 12.553356749999999, 4.048793600000001], [11.194831670000001, 3.69694325, 4.048793600000001], [11.194831670000001, 12.553356749999999, 9.269606399999999], [12.553356749999999, 11.194831670000001, 4.048793600000001], [12.553356749999999, 5.055468329999999, 9.269606399999999], [3.69694325, 11.194831670000001, 9.269606399999999], [3.69694325, 5.055468329999999, 4.048793600000001], [5.11559444, 4.251078479999999, 10.5748096], [5.11559444, 11.999221519999999, 2.7435903999999995], [11.13470556, 4.251078479999999, 2.7435903999999995], [11.13470556, 11.999221519999999, 10.5748096], [11.999221519999999, 11.13470556, 2.7435903999999995], [11.999221519999999, 5.11559444, 10.5748096], [4.251078479999999, 11.13470556, 10.5748096], [4.251078479999999, 5.11559444, 2.7435903999999995], [3.8350707999999996, 4.663836099999999, 10.894451199999999], [3.8350707999999996, 11.5864639, 2.4239488000000007], [12.415229199999999, 4.663836099999999, 2.4239488000000007], [12.415229199999999, 11.5864639, 10.894451199999999], [11.5864639, 12.415229199999999, 2.4239488000000007], [11.5864639, 3.8350707999999996, 10.894451199999999], [4.663836099999999, 12.415229199999999, 10.894451199999999], [4.663836099999999, 3.8350707999999996, 2.4239488000000007], [2.9088036999999995, 4.3063295, 9.762387200000001], [2.9088036999999995, 11.943970499999999, 3.5560128000000004], [13.3414963, 4.3063295, 3.5560128000000004], [13.3414963, 11.943970499999999, 9.762387200000001], [11.943970499999999, 13.3414963, 3.5560128000000004], [11.943970499999999, 2.9088036999999995, 9.762387200000001], [4.3063295, 13.3414963, 9.762387200000001], [4.3063295, 2.9088036999999995, 3.5560128000000004], [15.11927912, 5.58197805, 12.199654400000002], [15.11927912, 10.66832195, 1.1187456], [1.13102088, 5.58197805, 1.1187456], [1.13102088, 10.66832195, 12.199654400000002], [10.66832195, 1.13102088, 1.1187456], [10.66832195, 15.11927912, 12.199654400000002], [5.58197805, 1.13102088, 12.199654400000002], [5.58197805, 15.11927912, 1.1187456], [14.9827766, 4.082075359999999, 12.0265152], [14.9827766, 12.16822464, 1.2918848], [1.2675234, 4.082075359999999, 1.2918848], [1.2675234, 12.16822464, 12.0265152], [12.16822464, 1.2675234, 1.2918848], [12.16822464, 14.9827766, 12.0265152], [4.082075359999999, 1.2675234, 12.0265152], [4.082075359999999, 14.9827766, 1.2918848], [16.185298799999998, 6.1426134, 7.311801600000001], [16.185298799999998, 10.1076866, 6.0065984], [0.0650012, 6.1426134, 6.0065984], [0.0650012, 10.1076866, 7.311801600000001], [10.1076866, 0.0650012, 6.0065984], [10.1076866, 16.185298799999998, 7.311801600000001], [6.1426134, 0.0650012, 7.311801600000001], [6.1426134, 16.185298799999998, 6.0065984], [16.087797, 5.0213427, 7.8978112], [16.087797, 11.228957300000001, 5.420588800000001], [0.162503, 5.0213427, 5.420588800000001], [0.162503, 11.228957300000001, 7.8978112], [11.228957300000001, 0.162503, 5.420588800000001], [11.228957300000001, 16.087797, 7.8978112], [5.0213427, 0.162503, 7.8978112], [5.0213427, 16.087797, 5.420588800000001], [16.201549099999998, 3.8675713999999997, 7.431667200000001], [16.201549099999998, 12.3827286, 5.8867328], [0.0487509, 3.8675713999999997, 5.8867328], [0.0487509, 12.3827286, 7.431667200000001], [12.3827286, 0.0487509, 5.8867328], [12.3827286, 16.201549099999998, 7.431667200000001], [3.8675713999999997, 0.0487509, 7.431667200000001], [3.8675713999999997, 16.201549099999998, 5.8867328], [16.1527982, 2.6812995, 7.99104], [16.1527982, 13.5690005, 5.3273600000000005], [0.0975018, 2.6812995, 5.3273600000000005], [0.0975018, 13.5690005, 7.99104], [13.5690005, 0.0975018, 5.3273600000000005], [13.5690005, 16.1527982, 7.99104], [2.6812995, 0.0975018, 7.99104], [2.6812995, 16.1527982, 5.3273600000000005], [4.34858028, 5.62747889, 9.24696512], [4.34858028, 10.622821109999999, 4.07143488], [11.90171972, 5.62747889, 4.07143488], [11.90171972, 10.622821109999999, 9.24696512], [10.622821109999999, 11.90171972, 4.07143488], [10.622821109999999, 4.34858028, 9.24696512], [5.62747889, 11.90171972, 9.24696512], [5.62747889, 4.34858028, 4.07143488], [3.19318395, 7.91227107, 11.72418752], [3.19318395, 8.33802893, 1.5942124800000004], [13.05711605, 7.91227107, 1.5942124800000004], [13.05711605, 8.33802893, 11.72418752], [8.33802893, 13.05711605, 1.5942124800000004], [8.33802893, 3.19318395, 11.72418752], [7.91227107, 13.05711605, 11.72418752], [7.91227107, 3.19318395, 1.5942124800000004], [1.5600288, 7.94477167, 10.14062976], [1.5600288, 8.30552833, 3.1777702400000005], [14.6902712, 7.94477167, 3.1777702400000005], [14.6902712, 8.30552833, 10.14062976], [8.30552833, 14.6902712, 3.1777702400000005], [8.30552833, 1.5600288, 10.14062976], [7.94477167, 14.6902712, 10.14062976], [7.94477167, 1.5600288, 3.1777702400000005], [1.8574092899999999, 6.0938625, 0.23573568], [1.8574092899999999, 10.1564375, 13.08266432], [14.39289071, 6.0938625, 13.08266432], [14.39289071, 10.1564375, 0.23573568], [10.1564375, 14.39289071, 13.08266432], [10.1564375, 1.8574092899999999, 0.23573568], [6.0938625, 14.39289071, 0.23573568], [6.0938625, 1.8574092899999999, 13.08266432], [16.01304562, 6.12311304, 11.48445632], [16.01304562, 10.12718696, 1.8339436800000006], [0.23725438, 6.12311304, 1.8339436800000006], [0.23725438, 10.12718696, 11.48445632], [10.12718696, 0.23725438, 1.8339436800000006], [10.12718696, 16.01304562, 11.48445632], [6.12311304, 0.23725438, 11.48445632], [6.12311304, 16.01304562, 1.8339436800000006]],
                "lattice_vectors": [[16.2503, 0.0, 0.0], [0.0, 16.2503, 0.0], [0.0, 0.0, 13.3184]],
                "normalized_wyckoff_matid": {"i": {"X_2": 1}, "l": {"X_2": 1}, "p": {"X_0": 34, "X_1": 8, "X_3": 2}}
            }
        ],
        90: [
            {
                "Notes": "Na<sub>4</sub>Ti<sub>2</sub>Si<sub>8</sub>O<sub>22</sub>[H<sub>2</sub>O]<sub>4</sub> Structure",
                "Pearsons Symbol": "tP40",
                "Prototype": "H2Na4O22[O]4Si8Ti2",
                "Space Group Number": 90,
                "Space Group Symbol": "$P42_{1}2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B2C13D_tP40_90_g_d_cef2g_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B2C13D_tP40_90_g_d_cef2g_c.html",
                "atom_labels": ["O", "O", "Ti", "Ti", "Na", "Na", "Na", "Na", "O", "O", "O", "O", "O", "O", "O", "O", "H", "H", "H", "H", "H", "H", "H", "H", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 3.68699734895, 10.00862420358], [3.68699734895, 0.0, 0.70036809642], [0.0, 3.68699734895, 8.319816117870001], [3.68699734895, 0.0, 2.3891761821299995], [0.0, 0.0, 8.896174083456], [3.68699734895, 3.68699734895, 1.8128182165439999], [0.0, 0.0, 1.8128182165439999], [3.68699734895, 3.68699734895, 8.896174083456], [4.775398966360039, 4.775398966360039, 0.0], [1.0884016174100397, 6.28559308048996, 0.0], [6.28559308048996, 1.0884016174100397, 0.0], [2.59859573153996, 2.59859573153996, 0.0], [5.785636239972339, 5.785636239972339, 5.35449615], [2.0986388910223397, 5.27535580687766, 5.35449615], [5.27535580687766, 2.0986388910223397, 5.35449615], [1.5883584579276602, 1.5883584579276602, 5.35449615], [4.7783485642392, 5.5378700181228995, 0.010708992300000001], [1.0913512152892009, 5.5231220287271, 10.6982833077], [6.2826434826107995, 1.8508726691728992, 10.6982833077], [2.5956461336607997, 1.8361246797771, 0.010708992300000001], [1.8361246797771, 2.5956461336607997, 10.6982833077], [5.5231220287271, 1.0913512152892009, 0.010708992300000001], [1.8508726691728992, 6.2826434826107995, 0.010708992300000001], [5.5378700181228995, 4.7783485642392, 10.6982833077], [5.531970822364579, 3.94803676125566, 3.507944607711], [1.8449734734145797, 7.11295528559434, 7.201047692289001], [5.52902122448542, 0.2610394123056607, 7.201047692289001], [1.8420238755354201, 3.42595793664434, 3.507944607711], [3.42595793664434, 1.8420238755354201, 7.201047692289001], [7.11295528559434, 1.8449734734145797, 3.507944607711], [0.2610394123056607, 5.52902122448542, 3.507944607711], [3.94803676125566, 5.531970822364579, 7.201047692289001], [5.374904735299309, 6.497226728319689, 2.82181947105], [1.687907386349309, 4.56376531853031, 7.88717282895], [5.68608731155069, 2.81022937936969, 7.88717282895], [1.99908996260069, 0.87676796958031, 2.82181947105], [0.87676796958031, 1.99908996260069, 7.88717282895], [4.56376531853031, 1.687907386349309, 2.82181947105], [2.81022937936969, 5.68608731155069, 2.82181947105], [6.497226728319689, 5.374904735299309, 7.88717282895]],
                "lattice_vectors": [[7.3739946979, 0.0, 0.0], [0.0, 7.3739946979, 0.0], [0.0, 0.0, 10.7089923]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_3": 1}, "d": {"X_2": 2}, "e": {"X_0": 2}, "f": {"X_0": 2}, "g": {"X_0": 8, "X_1": 4}}
            },
            {
                "Notes": "BaCu<sub>4</sub>[VO][PO<sub>4</sub>]<sub>4</sub> Structure",
                "Pearsons Symbol": "tP54",
                "Prototype": "BaCu4[O4]4O][PV",
                "Space Group Number": 90,
                "Space Group Symbol": "$P42_{1}2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB4C17D4E_tP54_90_a_g_c4g_g_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4C17D4E_tP54_90_a_g_c4g_g_c.html",
                "atom_labels": ["Ba", "Ba", "O", "O", "V", "V", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "P", "P", "P", "P", "P", "P", "P", "P"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.78005313825, 4.78005313825, 0.0], [0.0, 4.78005313825, 1.4570761978267], [4.78005313825, 0.0, 5.7030033983733], [0.0, 4.78005313825, 6.9953977654874], [4.78005313825, 0.0, 0.1646818307126], [7.302965184618351, 4.9253667536528, 2.9141523956534], [2.5229120463683503, 9.4147926610972, 4.2459272005466], [7.03719423013165, 0.145313615402801, 4.2459272005466], [2.25714109188165, 4.634739522847201, 2.9141523956534], [4.634739522847201, 2.25714109188165, 4.2459272005466], [9.4147926610972, 2.5229120463683503, 2.9141523956534], [0.145313615402801, 7.03719423013165, 2.9141523956534], [4.9253667536528, 7.302965184618351, 4.2459272005466], [6.23796934541625, 8.2828760779596, 3.1969755397033], [1.4579162071662488, 6.057283336790401, 3.9631040564967], [8.102190069333751, 3.502822939709601, 3.9631040564967], [3.3221369310837505, 1.2772301985404007, 3.1969755397033], [1.2772301985404007, 3.3221369310837505, 3.9631040564967], [6.057283336790401, 1.4579162071662488, 3.1969755397033], [3.502822939709601, 8.102190069333751, 3.1969755397033], [8.2828760779596, 6.23796934541625, 3.9631040564967], [8.3995093745329, 8.011369059707, 1.9389495546509599], [3.619456236282901, 6.328790355043001, 5.22113004154904], [5.9406500402171005, 3.231315921457001, 5.22113004154904], [1.1605969019670996, 1.5487372167930005, 1.9389495546509599], [1.5487372167930005, 1.1605969019670996, 5.22113004154904], [6.328790355043001, 3.619456236282901, 1.9389495546509599], [3.231315921457001, 5.9406500402171005, 1.9389495546509599], [8.011369059707, 8.3995093745329, 5.22113004154904], [6.3727668439149, 8.569679266254601, 0.67519550592166], [1.5927137056648988, 5.770480148495401, 6.48488409027834], [7.967392570835101, 3.789626128004599, 6.48488409027834], [3.1873394325851008, 0.9904270102454004, 0.67519550592166], [0.9904270102454004, 3.1873394325851008, 6.48488409027834], [5.770480148495401, 1.5927137056648988, 0.67519550592166], [3.789626128004599, 7.967392570835101, 0.67519550592166], [8.569679266254601, 6.3727668439149, 6.48488409027834], [6.5372006718707, 6.271429717384001, 1.76710764434216], [1.7571475336206999, 8.068729697366, 5.39297195185784], [7.8029587428793015, 1.4913765791340015, 5.39297195185784], [3.0229056046293006, 3.288676559116, 1.76710764434216], [3.288676559116, 3.0229056046293006, 5.39297195185784], [8.068729697366, 1.7571475336206999, 1.76710764434216], [1.4913765791340015, 7.8029587428793015, 1.76710764434216], [6.271429717384001, 6.5372006718707, 5.39297195185784], [6.889968593473551, 7.757070232752101, 1.8680647666485801], [2.109915455223549, 6.5830891819979005, 5.2920148295514196], [7.4501908212764505, 2.9770170945020995, 5.2920148295514196], [2.67013768302645, 1.8030360437479, 1.8680647666485801], [1.8030360437479, 2.67013768302645, 5.2920148295514196], [6.5830891819979005, 2.109915455223549, 1.8680647666485801], [2.9770170945020995, 7.4501908212764505, 1.8680647666485801], [7.757070232752101, 6.889968593473551, 5.2920148295514196]],
                "lattice_vectors": [[9.5601062765, 0.0, 0.0], [0.0, 9.5601062765, 0.0], [0.0, 0.0, 7.1600795962]],
                "normalized_wyckoff_matid": {"a": {"X_3": 1}, "c": {"X_0": 1, "X_4": 1}, "g": {"X_0": 16, "X_1": 4, "X_2": 4}}
            }
        ],
        91: [
            {
                "Notes": "ThBC Structure",
                "Pearsons Symbol": "tP24",
                "Prototype": "BCTh",
                "Space Group Number": 91,
                "Space Group Symbol": "$P4_{1}22$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_tP24_91_d_d_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_tP24_91_d_d_d.html",
                "atom_labels": ["B", "B", "B", "B", "B", "B", "B", "B", "C", "C", "C", "C", "C", "C", "C", "C", "Th", "Th", "Th", "Th", "Th", "Th", "Th", "Th"],
                "atom_positions": [[1.1398884985986, 0.7599256657324001, 0.4796750514372], [1.1398884985986, 3.0020825804676003, 12.143352617962801], [2.6221197476014004, 0.7599256657324001, 24.7663802873628], [2.6221197476014004, 3.0020825804676003, 13.1027027208372], [3.0020825804676003, 2.6221197476014004, 5.831838783262801], [3.0020825804676003, 1.1398884985986, 6.791188886137201], [0.7599256657324001, 2.6221197476014004, 19.4142165555372], [0.7599256657324001, 1.1398884985986, 18.454866452662802], [1.1135544408752, 0.7110195585318, 2.019684427104], [1.1135544408752, 3.0509886876682, 10.603343242296], [2.6484538053248, 0.7110195585318, 23.226370911696], [2.6484538053248, 3.0509886876682, 14.642712096504], [3.0509886876682, 2.6484538053248, 4.2918294075959995], [3.0509886876682, 1.1135544408752, 8.331198261804001], [0.7110195585318, 2.6484538053248, 20.954225931204], [0.7110195585318, 1.1135544408752, 16.914857076996], [1.1191974532445, 0.74600623522146, 4.5316669333146], [1.1191974532445, 3.01600201097854, 8.0913607360854], [2.6428107929555003, 0.74600623522146, 20.7143884054854], [2.6428107929555003, 3.01600201097854, 17.1546946027146], [3.01600201097854, 2.6428107929555003, 1.7798469013854004], [3.01600201097854, 1.1191974532445, 10.8431807680146], [0.74600623522146, 2.6428107929555003, 23.4662084374146], [0.74600623522146, 1.1191974532445, 14.402874570785402]],
                "lattice_vectors": [[3.7620082462, 0.0, 0.0], [0.0, 3.7620082462, 0.0], [0.0, 0.0, 25.2460553388]],
                "normalized_wyckoff_matid": {"d": {"X_0": 1, "X_1": 1, "X_2": 1}}
            }
        ],
        92: [
            {
                "Notes": "$\\alpha$&ndash;Cristobalite (SiO<sub>2</sub>, $C30$, low) Structure",
                "Pearsons Symbol": "tP12",
                "Prototype": "O2Si",
                "Space Group Number": 92,
                "Space Group Symbol": "$P4_{1}2_{1}2$",
                "Strukturbericht Designation": "$C30$",
                "aflow_prototype_id": "A2B_tP12_92_b_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tP12_92_b_a.html",
                "atom_labels": ["Si", "Si", "Si", "Si", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[1.5103979, 1.5103979, 0.0], [3.9888978999999996, 0.9681020999999999, 5.167725], [0.9681020999999999, 3.9888978999999996, 1.722575], [3.4466021000000002, 3.4466021000000002, 3.44515], [1.1802617, 0.5497312999999999, 1.25816878], [3.6587617, 1.9287687, 3.9095562200000002], [1.2982383000000002, 3.0282313, 0.4644062199999999], [3.7767383, 4.4072686999999995, 4.70331878], [4.4072686999999995, 3.7767383, 2.1869812200000003], [1.9287687, 3.6587617, 2.9807437799999996], [3.0282313, 1.2982383000000002, 6.42589378], [0.5497312999999999, 1.1802617, 5.63213122]],
                "lattice_vectors": [[4.957, 0.0, 0.0], [0.0, 4.957, 0.0], [0.0, 0.0, 6.8903]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_0": 2}}
            }
        ],
        93: [
            {
                "Notes": "AsPh<sub>4</sub>CeS<sub>8</sub>P<sub>4</sub>Me<sub>8</sub> Structure",
                "Pearsons Symbol": "tP184",
                "Prototype": "AsCeMe8P4Ph4S8",
                "Space Group Number": 93,
                "Space Group Symbol": "$P4_{2}22$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB32CD4E8_tP184_93_i_16p_af_2p_4p",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB32CD4E8_tP184_93_i_16p_af_2p_4p.html",
                "atom_labels": ["Ce", "Ce", "Ce", "Ce", "As", "As", "As", "As", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 16.7395], [5.7305, 5.7305, 8.36975], [5.7305, 5.7305, 25.10925], [0.0, 5.7305, 20.85038641], [0.0, 5.7305, 12.62861359], [5.7305, 0.0, 29.36811359], [5.7305, 0.0, 4.110886409999998], [4.229109, 1.6045400000000003, 18.0887037], [4.229109, 9.85646, 15.3902963], [7.231891, 1.6045400000000003, 15.3902963], [7.231891, 9.85646, 18.0887037], [9.85646, 7.231891, 32.1297963], [9.85646, 4.229109, 1.3492037000000001], [1.6045400000000003, 7.231891, 1.3492037000000001], [1.6045400000000003, 4.229109, 32.1297963], [2.8767110000000002, 1.478469, 20.6665867], [2.8767110000000002, 9.982531, 12.812413300000001], [8.584289, 1.478469, 12.812413300000001], [8.584289, 9.982531, 20.6665867], [9.982531, 8.584289, 29.5519133], [9.982531, 2.8767110000000002, 3.9270866999999985], [1.478469, 8.584289, 3.9270866999999985], [1.478469, 2.8767110000000002, 29.5519133], [1.5816180000000002, 7.415267, 26.3881478], [1.5816180000000002, 4.045733, 7.0908522], [9.879382, 7.415267, 7.0908522], [9.879382, 4.045733, 26.3881478], [4.045733, 9.879382, 23.8303522], [4.045733, 1.5816180000000002, 9.6486478], [7.415267, 9.879382, 9.6486478], [7.415267, 1.5816180000000002, 23.8303522], [2.464115, 6.64738, 28.9425955], [2.464115, 4.81362, 4.536404499999998], [8.996885, 6.64738, 4.536404499999998], [8.996885, 4.81362, 28.9425955], [4.81362, 8.996885, 21.2759045], [4.81362, 2.464115, 12.203095500000002], [6.64738, 8.996885, 12.203095500000002], [6.64738, 2.464115, 21.2759045], [1.5816180000000002, 5.925337000000001, 19.786088999999997], [1.5816180000000002, 5.535663, 13.692911], [9.879382, 5.925337000000001, 13.692911], [9.879382, 5.535663, 19.786088999999997], [5.535663, 9.879382, 30.432411000000002], [5.535663, 1.5816180000000002, 3.046588999999999], [5.925337000000001, 9.879382, 3.046588999999999], [5.925337000000001, 1.5816180000000002, 30.432411000000002], [1.512852, 6.64738, 18.5507139], [1.512852, 4.81362, 14.928286099999998], [9.948148, 6.64738, 14.928286099999998], [9.948148, 4.81362, 18.5507139], [4.81362, 9.948148, 31.667786099999997], [4.81362, 1.512852, 1.8112139000000012], [6.64738, 9.948148, 1.8112139000000012], [6.64738, 1.512852, 31.667786099999997], [2.796484, 6.933905, 17.944744], [2.796484, 4.527095, 15.534256], [8.664516, 6.933905, 15.534256], [8.664516, 4.527095, 17.944744], [4.527095, 8.664516, 32.273756], [4.527095, 2.796484, 1.205244000000001], [6.933905, 8.664516, 1.205244000000001], [6.933905, 2.796484, 32.273756], [3.954045, 6.349394000000001, 18.396710499999998], [3.954045, 5.111605999999999, 15.0822895], [7.5069550000000005, 6.349394000000001, 15.0822895], [7.5069550000000005, 5.111605999999999, 18.396710499999998], [5.111605999999999, 7.5069550000000005, 31.8217895], [5.111605999999999, 3.954045, 1.6572105000000033], [6.349394000000001, 7.5069550000000005, 1.6572105000000033], [6.349394000000001, 3.954045, 31.8217895], [3.9311230000000004, 5.558585, 19.5584318], [3.9311230000000004, 5.902415, 13.920568199999998], [7.529877000000001, 5.558585, 13.920568199999998], [7.529877000000001, 5.902415, 19.5584318], [5.902415, 7.529877000000001, 30.660068199999998], [5.902415, 3.9311230000000004, 2.818931800000002], [5.558585, 7.529877000000001, 2.818931800000002], [5.558585, 3.9311230000000004, 30.660068199999998], [2.716257, 5.306443000000001, 20.1911849], [2.716257, 6.154557, 13.287815100000001], [8.744743, 5.306443000000001, 13.287815100000001], [8.744743, 6.154557, 20.1911849], [6.154557, 8.744743, 30.0273151], [6.154557, 2.716257, 3.4516848999999987], [5.306443000000001, 8.744743, 3.4516848999999987], [5.306443000000001, 2.716257, 30.0273151], [0.091688, 4.194726, 21.942136599999998], [0.091688, 7.266274, 11.5368634], [11.369312, 4.194726, 11.5368634], [11.369312, 7.266274, 21.942136599999998], [7.266274, 11.369312, 28.2763634], [7.266274, 0.091688, 5.202636599999999], [4.194726, 11.369312, 5.202636599999999], [4.194726, 0.091688, 28.2763634], [0.882497, 4.252031, 23.0737268], [0.882497, 7.208969000000001, 10.405273199999998], [10.578503000000001, 4.252031, 10.405273199999998], [10.578503000000001, 7.208969000000001, 23.0737268], [7.208969000000001, 10.578503000000001, 27.1447732], [7.208969000000001, 0.882497, 6.334226800000001], [4.252031, 10.578503000000001, 6.334226800000001], [4.252031, 0.882497, 27.1447732], [0.939802, 3.1288530000000003, 23.940832899999997], [0.939802, 8.332147, 9.5381671], [10.521198, 3.1288530000000003, 9.5381671], [10.521198, 8.332147, 23.940832899999997], [8.332147, 10.521198, 26.277667100000002], [8.332147, 0.939802, 7.201332900000002], [3.1288530000000003, 10.521198, 7.201332900000002], [3.1288530000000003, 0.939802, 26.277667100000002], [0.263603, 1.9483700000000002, 23.5390849], [0.263603, 9.51263, 9.939915100000002], [11.197397, 1.9483700000000002, 9.939915100000002], [11.197397, 9.51263, 23.5390849], [9.51263, 11.197397, 26.6794151], [9.51263, 0.263603, 6.799584900000002], [1.9483700000000002, 11.197397, 6.799584900000002], [1.9483700000000002, 0.263603, 26.6794151], [11.002559999999999, 1.8910650000000002, 22.357276199999998], [11.002559999999999, 9.569935, 11.121723800000002], [0.45844, 1.8910650000000002, 11.121723800000002], [0.45844, 9.569935, 22.357276199999998], [9.569935, 0.45844, 27.8612238], [9.569935, 11.002559999999999, 5.617776199999998], [1.8910650000000002, 0.45844, 5.617776199999998], [1.8910650000000002, 11.002559999999999, 27.8612238], [10.88795, 3.0371650000000003, 21.4533432], [10.88795, 8.423835, 12.025656799999998], [0.5730500000000001, 3.0371650000000003, 12.025656799999998], [0.5730500000000001, 8.423835, 21.4533432], [8.423835, 0.5730500000000001, 28.7651568], [8.423835, 10.88795, 4.713843200000001], [3.0371650000000003, 0.5730500000000001, 4.713843200000001], [3.0371650000000003, 10.88795, 28.7651568], [2.6039392, 1.1678759, 18.8687644], [2.6039392, 10.2931241, 14.6102356], [8.8570608, 1.1678759, 14.6102356], [8.8570608, 10.2931241, 18.8687644], [10.2931241, 8.8570608, 31.3497356], [10.2931241, 2.6039392, 2.1292644000000034], [1.1678759, 8.8570608, 2.1292644000000034], [1.1678759, 2.6039392, 31.3497356], [2.9810061, 6.6496722, 27.184948000000002], [2.9810061, 4.8113278, 6.294051999999998], [8.4799939, 6.6496722, 6.294051999999998], [8.4799939, 4.8113278, 27.184948000000002], [4.8113278, 8.4799939, 23.033551999999997], [4.8113278, 2.9810061, 10.445448], [6.6496722, 8.4799939, 10.445448], [6.6496722, 2.9810061, 23.033551999999997], [1.1701681, 2.3495049999999997, 18.1991844], [1.1701681, 9.111495000000001, 15.279815600000001], [10.2908319, 2.3495049999999997, 15.279815600000001], [10.2908319, 9.111495000000001, 18.1991844], [9.111495000000001, 10.2908319, 32.0193156], [9.111495000000001, 1.1701681, 1.4596844000000027], [2.3495049999999997, 10.2908319, 1.4596844000000027], [2.3495049999999997, 1.1701681, 32.0193156], [2.2188496, 10.6862364, 18.607628199999997], [2.2188496, 0.7747636, 14.8713718], [9.2421504, 10.6862364, 14.8713718], [9.2421504, 0.7747636, 18.607628199999997], [0.7747636, 9.2421504, 31.6108718], [0.7747636, 2.2188496, 1.8681282000000023], [10.6862364, 9.2421504, 1.8681282000000023], [10.6862364, 2.2188496, 31.6108718], [4.630244, 7.7453438, 26.9472471], [4.630244, 3.7156562000000006, 6.531752900000002], [6.830756, 7.7453438, 6.531752900000002], [6.830756, 3.7156562000000006, 26.9472471], [3.7156562000000006, 6.830756, 23.2712529], [3.7156562000000006, 4.630244, 10.207747099999999], [7.7453438, 6.830756, 10.207747099999999], [7.7453438, 4.630244, 23.2712529], [3.2193948999999997, 4.790698, 26.488584799999998], [3.2193948999999997, 6.670302000000001, 6.990415199999999], [8.241605100000001, 4.790698, 6.990415199999999], [8.241605100000001, 6.670302000000001, 26.488584799999998], [6.670302000000001, 8.241605100000001, 23.7299152], [6.670302000000001, 3.2193948999999997, 9.749084799999997], [4.790698, 8.241605100000001, 9.749084799999997], [4.790698, 3.2193948999999997, 23.7299152]],
                "lattice_vectors": [[11.461, 0.0, 0.0], [0.0, 11.461, 0.0], [0.0, 0.0, 33.479]],
                "normalized_wyckoff_matid": {"a": {"X_3": 1}, "f": {"X_3": 1}, "i": {"X_4": 2}, "p": {"X_0": 64, "X_1": 16, "X_2": 8}}
            }
        ],
        94: [
            {
                "Notes": "Na<sub>5</sub>Fe<sub>3</sub>F<sub>14</sub> (High&ndash;temperature) Structure",
                "Pearsons Symbol": "tP44",
                "Prototype": "F14Fe3Na5",
                "Space Group Number": 94,
                "Space Group Symbol": "$P4_{2}2_{1}2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A14B3C5_tP44_94_c3g_ad_bg",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A14B3C5_tP44_94_c3g_ad_bg.html",
                "atom_labels": ["Fe", "Fe", "Na", "Na", "F", "F", "F", "F", "Fe", "Fe", "Fe", "Fe", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.6725657596, 3.6725657596, 5.2000931109], [0.0, 0.0, 5.2000931109], [3.6725657596, 3.6725657596, 0.0], [0.0, 0.0, 8.554153167430501], [3.6725657596, 3.6725657596, 7.0461261652695], [0.0, 0.0, 1.8460330543695], [3.6725657596, 3.6725657596, 3.3540600565305003], [0.0, 3.6725657596, 10.38354592384512], [3.6725657596, 0.0, 5.21673340885488], [3.6725657596, 0.0, 0.01664029795488], [0.0, 3.6725657596, 5.18345281294512], [5.20476019450512, 7.3275032035539205, 6.53235696591258], [1.5321944349051209, 3.6901940752460796, 9.067922366787421], [5.812937084294879, 3.6549374439539197, 9.067922366787421], [2.14037132469488, 0.017628315646079997, 6.53235696591258], [0.017628315646079997, 2.14037132469488, 3.86782925588742], [3.6901940752460796, 1.5321944349051209, 1.3322638550125787], [3.6549374439539197, 5.812937084294879, 1.3322638550125787], [7.3275032035539205, 5.20476019450512, 3.86782925588742], [7.13432624459896, 4.8294239738739995, 6.49179623964756], [3.46176048499896, 6.188273304926, 9.10848309305244], [3.8833710342010397, 1.1568582142739998, 9.10848309305244], [0.21080527460103998, 2.5157075453260003, 6.49179623964756], [2.5157075453260003, 0.21080527460103998, 3.9083899821524404], [6.188273304926, 3.46176048499896, 1.2917031287475609], [1.1568582142739998, 3.8833710342010397, 1.2917031287475609], [4.8294239738739995, 7.13432624459896, 3.9083899821524404], [3.9663710203680003, 5.5088486394, 5.66602145363664], [0.29380526076800023, 5.5088486394, 9.934257879063361], [7.051326258432, 1.8362828798, 9.934257879063361], [3.3787604988319995, 1.8362828798, 5.66602145363664], [1.8362828798, 3.3787604988319995, 4.73416476816336], [5.5088486394, 0.29380526076800023, 0.4659283427366395], [1.8362828798, 7.051326258432, 0.4659283427366395], [5.5088486394, 3.9663710203680003, 4.73416476816336], [5.370760166839039, 5.397202640308159, 7.69925785999854], [1.698194407239039, 5.62049463849184, 7.90102147270146], [5.64693711196096, 1.7246368807081591, 7.90102147270146], [1.9743713523609603, 1.9479288788918399, 7.69925785999854], [1.9479288788918399, 1.9743713523609603, 2.7009283618014606], [5.62049463849184, 1.698194407239039, 2.4991647490985396], [1.7246368807081591, 5.64693711196096, 2.4991647490985396], [5.397202640308159, 5.370760166839039, 2.7009283618014606]],
                "lattice_vectors": [[7.3451315192, 0.0, 0.0], [0.0, 7.3451315192, 0.0], [0.0, 0.0, 10.4001862218]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "c": {"X_0": 2}, "d": {"X_2": 2}, "g": {"X_0": 12, "X_1": 4}}
            },
            {
                "Notes": "Li<sub>2</sub>MoF<sub>6</sub> Structure",
                "Pearsons Symbol": "tP18",
                "Prototype": "F6Li2Mo",
                "Space Group Number": 94,
                "Space Group Symbol": "$P4_{2}2_{1}2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A6B2C_tP18_94_eg_c_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A6B2C_tP18_94_eg_c_a.html",
                "atom_labels": ["Mo", "Mo", "Li", "Li", "Li", "Li", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.34316045505, 2.34316045505, 4.595520505], [0.0, 0.0, 6.087226460923], [2.34316045505, 2.34316045505, 7.699335054076999], [0.0, 0.0, 3.1038145490769997], [2.34316045505, 2.34316045505, 1.4917059559230008], [3.3240074215339304, 3.3240074215339304, 0.0], [0.9808469664839302, 3.7054739436160697, 4.595520505], [3.7054739436160697, 0.9808469664839302, 4.595520505], [1.36231348856607, 1.36231348856607, 0.0], [3.2054435025084005, 3.3132288834406998, 6.046785880479], [0.8622830474584008, 3.7162524817093003, 7.739775634520999], [3.8240378626415996, 0.9700684283906993, 7.739775634520999], [1.4808774075915998, 1.3730920266593003, 6.046785880479], [1.3730920266593003, 1.4808774075915998, 3.1442551295209995], [3.7162524817093003, 0.8622830474584008, 1.4512653754790013], [0.9700684283906993, 3.8240378626415996, 1.4512653754790013], [3.3132288834406998, 3.2054435025084005, 3.1442551295209995]],
                "lattice_vectors": [[4.6863209101, 0.0, 0.0], [0.0, 4.6863209101, 0.0], [0.0, 0.0, 9.19104101]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "c": {"X_1": 2}, "e": {"X_0": 2}, "g": {"X_0": 4}}
            }
        ],
        95: [
            {
                "Notes": "ThBC Structure",
                "Pearsons Symbol": "tP24",
                "Prototype": "BCTh",
                "Space Group Number": 95,
                "Space Group Symbol": "$P4_{3}22$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_tP24_95_d_d_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_tP24_95_d_d_d.html",
                "atom_labels": ["B", "B", "B", "B", "B", "B", "B", "B", "C", "C", "C", "C", "C", "C", "C", "C", "Th", "Th", "Th", "Th", "Th", "Th", "Th", "Th"],
                "atom_positions": [[1.1398884985986, 0.7599256657324001, 24.7663802873628], [1.1398884985986, 3.0020825804676003, 13.1027027208372], [2.6221197476014004, 0.7599256657324001, 0.4796750514372], [2.6221197476014004, 3.0020825804676003, 12.143352617962801], [3.0020825804676003, 2.6221197476014004, 19.4142165555372], [3.0020825804676003, 1.1398884985986, 18.454866452662802], [0.7599256657324001, 2.6221197476014004, 5.831838783262801], [0.7599256657324001, 1.1398884985986, 6.791188886137201], [1.1135544408752, 0.7110195585318, 23.226370911696], [1.1135544408752, 3.0509886876682, 14.642712096504], [2.6484538053248, 0.7110195585318, 2.019684427104], [2.6484538053248, 3.0509886876682, 10.603343242296], [3.0509886876682, 2.6484538053248, 20.954225931204], [3.0509886876682, 1.1135544408752, 16.914857076996], [0.7110195585318, 2.6484538053248, 4.2918294075959995], [0.7110195585318, 1.1135544408752, 8.331198261804001], [1.1191974532445, 0.74600623522146, 20.7143884054854], [1.1191974532445, 3.01600201097854, 17.1546946027146], [2.6428107929555003, 0.74600623522146, 4.5316669333146], [2.6428107929555003, 3.01600201097854, 8.0913607360854], [3.01600201097854, 2.6428107929555003, 23.4662084374146], [3.01600201097854, 1.1191974532445, 14.402874570785402], [0.74600623522146, 2.6428107929555003, 1.7798469013854004], [0.74600623522146, 1.1191974532445, 10.8431807680146]],
                "lattice_vectors": [[3.7620082462, 0.0, 0.0], [0.0, 3.7620082462, 0.0], [0.0, 0.0, 25.2460553388]],
                "normalized_wyckoff_matid": {"d": {"X_0": 1, "X_1": 1, "X_2": 1}}
            }
        ],
        96: [
            {
                "Notes": "<q>ST12</q> Structure of Si",
                "Pearsons Symbol": "tP12",
                "Prototype": "Si",
                "Space Group Number": 96,
                "Space Group Symbol": "$P4_{3}2_{1}2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_tP12_96_ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tP12_96_ab.html",
                "atom_labels": ["Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.468553761, 0.468553761, 0.0], [3.227998761, 2.290891239, 1.73845], [2.290891239, 3.227998761, 5.21535], [5.050336239, 5.050336239, 3.4769], [0.966909528, 2.092763088, 1.9067319600000001], [3.726354528, 0.666681912, 6.78551804], [1.7925354719999997, 4.852208087999999, 3.3086180400000003], [4.5519804719999994, 3.426126912, 5.38363196], [3.426126912, 4.5519804719999994, 1.57016804], [0.666681912, 3.726354528, 0.16828196], [4.852208087999999, 1.7925354719999997, 3.64518196], [2.092763088, 0.966909528, 5.04706804]],
                "lattice_vectors": [[5.51889, 0.0, 0.0], [0.0, 5.51889, 0.0], [0.0, 0.0, 6.9538]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 2}}
            },
            {
                "Notes": "Keatite (SiO<sub>2</sub>) Structure",
                "Pearsons Symbol": "tP36",
                "Prototype": "O2Si",
                "Space Group Number": 96,
                "Space Group Symbol": "$P4_{3}2_{1}2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_tP36_96_3b_ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tP36_96_3b_ab.html",
                "atom_labels": ["Si", "Si", "Si", "Si", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[3.06024, 3.06024, 0.0], [6.79224, 0.6717600000000002, 2.155], [0.6717600000000002, 6.79224, 6.465], [4.403760000000001, 4.403760000000001, 4.31], [3.32148, 0.9852480000000001, 3.448], [7.05348, 2.7467520000000003, 7.326999999999999], [0.41052, 4.7172480000000006, 3.0169999999999995], [4.14252, 6.478752, 7.757999999999999], [6.478752, 4.14252, 0.8619999999999998], [2.7467520000000003, 7.05348, 1.292999999999999], [4.7172480000000006, 0.41052, 5.603], [0.9852480000000001, 3.32148, 5.172], [0.8732880000000001, 0.918072, 2.5515199999999996], [4.605288, 2.813928, 8.223479999999999], [2.858712, 4.650072000000001, 3.91348], [6.590712000000001, 6.545928, 6.86152], [6.545928, 6.590712000000001, 1.75848], [2.813928, 4.605288, 0.3965200000000003], [4.650072000000001, 2.858712, 4.70652], [0.918072, 0.8732880000000001, 6.068479999999999], [2.567616, 2.216808, 1.2326599999999999], [6.299616, 1.515192, 0.92234], [1.1643840000000003, 5.948808, 5.23234], [4.896384, 5.247192000000001, 5.54266], [5.247192000000001, 4.896384, 3.0773399999999995], [1.515192, 6.299616, 7.697659999999999], [5.948808, 1.1643840000000003, 3.38766], [2.216808, 2.567616, 7.387339999999999], [2.4332640000000003, 0.89568, 2.1377599999999997], [6.1652640000000005, 2.83632, 0.017240000000000012], [1.298736, 4.62768, 4.32724], [5.030736, 6.568320000000001, 6.44776], [6.568320000000001, 5.030736, 2.17224], [2.83632, 6.1652640000000005, 8.60276], [4.62768, 1.298736, 4.2927599999999995], [0.89568, 2.4332640000000003, 6.482239999999999]],
                "lattice_vectors": [[7.464, 0.0, 0.0], [0.0, 7.464, 0.0], [0.0, 0.0, 8.62]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_0": 6, "X_1": 2}}
            }
        ],
        97: [
            {
                "Notes": "NaGdCu<sub>2</sub>F<sub>8</sub> Structure",
                "Pearsons Symbol": "tI24",
                "Prototype": "Cu2F8GdNa",
                "Space Group Number": 97,
                "Space Group Symbol": "$I422$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B8CD_tI24_97_d_k_a_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B8CD_tI24_97_d_k_a_b.html",
                "atom_labels": ["Gd", "Gd", "Na", "Na", "Cu", "Cu", "Cu", "Cu", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.70342723385, 2.70342723385, 5.19086028145], [0.0, 0.0, 5.19086028145], [2.70342723385, 2.70342723385, 0.0], [0.0, 2.70342723385, 2.595430140725], [0.0, 2.70342723385, 7.786290422175], [2.70342723385, 0.0, 7.786290422175], [2.70342723385, 0.0, 2.595430140725], [0.9175432031686899, 1.69126407749656, 1.28421883363073], [0.9175432031686899, 3.71559039020344, 9.09750172926927], [4.48931126453131, 1.69126407749656, 9.09750172926927], [4.48931126453131, 3.71559039020344, 1.28421883363073], [3.71559039020344, 4.48931126453131, 9.09750172926927], [3.71559039020344, 0.9175432031686899, 1.28421883363073], [1.69126407749656, 4.48931126453131, 1.28421883363073], [1.69126407749656, 0.9175432031686899, 9.09750172926927], [3.6209704370186895, 4.39469131134656, 6.475079115080731], [3.6209704370186895, 1.01216315635344, 3.9066414478192697], [1.7858840306813102, 4.39469131134656, 3.9066414478192697], [1.7858840306813102, 1.01216315635344, 6.475079115080731], [1.01216315635344, 1.7858840306813102, 3.9066414478192697], [1.01216315635344, 3.6209704370186895, 6.475079115080731], [4.39469131134656, 1.7858840306813102, 6.475079115080731], [4.39469131134656, 3.6209704370186895, 3.9066414478192697]],
                "lattice_vectors": [[5.4068544677, 0.0, 0.0], [0.0, 5.4068544677, 0.0], [0.0, 0.0, 10.3817205629]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "b": {"X_3": 1}, "d": {"X_1": 2}, "k": {"X_0": 8}}
            },
            {
                "Notes": "Ta<sub>2</sub>Se<sub>8</sub>I Structure",
                "Pearsons Symbol": "tI44",
                "Prototype": "ISe8Ta2",
                "Space Group Number": 97,
                "Space Group Symbol": "$I422$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB8C2_tI44_97_e_2k_cd",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB8C2_tI44_97_e_2k_cd.html",
                "atom_labels": ["Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "I", "I", "I", "I", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se"],
                "atom_positions": [[0.0, 4.76585133775, 0.0], [4.76585133775, 0.0, 0.0], [4.76585133775, 0.0, 6.380501791], [0.0, 4.76585133775, 6.380501791], [0.0, 4.76585133775, 3.1902508955], [0.0, 4.76585133775, 9.5707526865], [4.76585133775, 0.0, 9.5707526865], [4.76585133775, 0.0, 3.1902508955], [0.0, 0.0, 1.9817838562846], [0.0, 0.0, 10.7792197257154], [4.76585133775, 4.76585133775, 8.362285647284601], [4.76585133775, 4.76585133775, 4.398717934715401], [0.42797345012995003, 2.7070035598419997, 4.712638622832601], [0.42797345012995003, 6.8246991156579995, 8.048364959167401], [9.10372922537005, 2.7070035598419997, 8.048364959167401], [9.10372922537005, 6.8246991156579995, 4.712638622832601], [6.8246991156579995, 9.10372922537005, 8.048364959167401], [6.8246991156579995, 0.42797345012995003, 4.712638622832601], [2.7070035598419997, 9.10372922537005, 4.712638622832601], [2.7070035598419997, 0.42797345012995003, 8.048364959167401], [5.193824787879951, 7.472854897592001, 11.0931404138326], [5.193824787879951, 2.0588477779080003, 1.6678631681673999], [4.33787788762005, 7.472854897592001, 1.6678631681673999], [4.33787788762005, 2.0588477779080003, 11.0931404138326], [2.0588477779080003, 4.33787788762005, 1.6678631681673999], [2.0588477779080003, 5.193824787879951, 11.0931404138326], [7.472854897592001, 4.33787788762005, 11.0931404138326], [7.472854897592001, 5.193824787879951, 1.6678631681673999], [2.973891234756, 1.1552423642706, 1.5198355266162], [2.973891234756, 8.376460311229401, 11.2411680553838], [6.557811440744, 1.1552423642706, 11.2411680553838], [6.557811440744, 8.376460311229401, 1.5198355266162], [8.376460311229401, 6.557811440744, 11.2411680553838], [8.376460311229401, 2.973891234756, 1.5198355266162], [1.1552423642706, 6.557811440744, 1.5198355266162], [1.1552423642706, 2.973891234756, 11.2411680553838], [7.7397425725060005, 5.9210937020206, 7.9003373176162], [7.7397425725060005, 3.6106089734794002, 4.8606662643838], [1.791960102994, 5.9210937020206, 4.8606662643838], [1.791960102994, 3.6106089734794002, 7.9003373176162], [3.6106089734794002, 1.791960102994, 4.8606662643838], [3.6106089734794002, 7.7397425725060005, 7.9003373176162], [5.9210937020206, 1.791960102994, 7.9003373176162], [5.9210937020206, 7.7397425725060005, 4.8606662643838]],
                "lattice_vectors": [[9.5317026755, 0.0, 0.0], [0.0, 9.5317026755, 0.0], [0.0, 0.0, 12.761003582]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "d": {"X_1": 1}, "e": {"X_2": 1}, "k": {"X_0": 8}}
            }
        ],
        98: [
            {
                "Notes": "CdAs<sub>2</sub> Structure",
                "Pearsons Symbol": "tI12",
                "Prototype": "As2Cd",
                "Space Group Number": 98,
                "Space Group Symbol": "$I4_{1}22$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_tI12_98_f_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tI12_98_f_a.html",
                "atom_labels": ["Cd", "Cd", "Cd", "Cd", "As", "As", "As", "As", "As", "As", "As", "As"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 3.9766883245, 1.1690553631], [3.9766883245, 3.9766883245, 2.3381107262], [3.9766883245, 0.0, 3.5071660893], [3.49948572556, 1.98834416225, 0.58452768155], [4.45389092344, 5.96503248675, 0.58452768155], [5.96503248675, 4.45389092344, 4.09169377085], [5.96503248675, 7.476174050059999, 1.75358304465], [1.98834416225, 0.47720259894, 1.75358304465], [1.98834416225, 3.49948572556, 4.09169377085], [7.476174050059999, 5.96503248675, 2.92263840775], [0.47720259894, 1.98834416225, 2.92263840775]],
                "lattice_vectors": [[7.953376649, 0.0, 0.0], [0.0, 7.953376649, 0.0], [0.0, 0.0, 4.6762214524]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "f": {"X_0": 2}}
            }
        ],
        99: [
            {
                "Notes": "Tetragonal PZT [Pb(Zr<sub>x</sub>Ti<sub>1&ndash;x</sub>)O<sub>3</sub>] Structure",
                "Pearsons Symbol": "tP5",
                "Prototype": "O3Pb(Ti0.48)Zr0.52",
                "Space Group Number": 99,
                "Space Group Symbol": "$P4mm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3BC_tP5_99_bc_a_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3BC_tP5_99_bc_a_b.html",
                "atom_labels": ["Pb", "O", "Zr", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.023, 2.023, 3.7142836200000002], [2.023, 2.023, 1.86976698], [2.023, 0.0, 1.5667629], [0.0, 2.023, 1.5667629]],
                "lattice_vectors": [[4.046, 0.0, 0.0], [0.0, 4.046, 0.0], [0.0, 0.0, 4.1394]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "b": {"X_2": 1}, "c": {"X_0": 2}}
            }
        ],
        100: [
            {
                "Notes": "Fresnoite (Ba<sub>2</sub>TiSi<sub>2</sub>O<sub>8</sub>) Structure",
                "Pearsons Symbol": "tP26",
                "Prototype": "Ba2O8Si2Ti",
                "Space Group Number": 100,
                "Space Group Symbol": "$P4bm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B8C2D_tP26_100_c_abcd_c_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B8C2D_tP26_100_c_abcd_c_a.html",
                "atom_labels": ["O", "O", "Ti", "Ti", "O", "O", "Ba", "Ba", "Ba", "Ba", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 4.1183001599999995], [4.2635, 4.2635, 4.1183001599999995], [0.0, 0.0, 2.42075184], [4.2635, 4.2635, 2.42075184], [4.2635, 0.0, 1.9314952799999998], [0.0, 4.2635, 1.9314952799999998], [2.78841427, 7.051914269999999, 0.0], [5.73858573, 1.4750857299999998, 0.0], [1.4750857299999998, 2.78841427, 0.0], [7.051914269999999, 5.73858573, 0.0], [1.0735493, 5.337049299999999, 4.14174696], [7.453450699999999, 3.1899507, 4.14174696], [3.1899507, 1.0735493, 4.14174696], [5.337049299999999, 7.453450699999999, 4.14174696], [1.0931614, 5.356661399999999, 2.5379858399999997], [7.4338386, 3.1703386, 2.5379858399999997], [3.1703386, 1.0931614, 2.5379858399999997], [5.356661399999999, 7.4338386, 2.5379858399999997], [2.4932947999999997, 4.9217844, 1.8606338399999998], [6.033705199999999, 3.6052155999999993, 1.8606338399999998], [3.6052155999999993, 2.4932947999999997, 1.8606338399999998], [4.9217844, 6.033705199999999, 1.8606338399999998], [1.7702052, 0.6582843999999994, 1.8606338399999998], [6.7567948, 7.868715599999999, 1.8606338399999998], [0.6582843999999994, 6.7567948, 1.8606338399999998], [7.868715599999999, 1.7702052, 1.8606338399999998]],
                "lattice_vectors": [[8.527, 0.0, 0.0], [0.0, 8.527, 0.0], [0.0, 0.0, 5.2104]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_3": 1}, "b": {"X_0": 1}, "c": {"X_0": 2, "X_1": 2, "X_2": 2}, "d": {"X_0": 4}}
            },
            {
                "Notes": "Ce<sub>3</sub>Si<sub>6</sub>N<sub>11</sub> Structure",
                "Pearsons Symbol": "tP40",
                "Prototype": "Ce3N11Si6",
                "Space Group Number": 100,
                "Space Group Symbol": "$P4bm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B11C6_tP40_100_ac_bc2d_cd",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B11C6_tP40_100_ac_bc2d_cd.html",
                "atom_labels": ["Ce", "Ce", "N", "N", "Ce", "Ce", "Ce", "Ce", "N", "N", "N", "N", "Si", "Si", "Si", "Si", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 0.0], [5.06556000895, 5.06556000895, 0.0], [5.06556000895, 0.0, 0.32572225865759996], [0.0, 5.06556000895, 0.32572225865759996], [1.834847146441869, 6.9004071553918696, 0.0746446842757], [8.296272871458132, 3.230712862508131, 0.0746446842757], [3.230712862508131, 1.834847146441869, 0.0746446842757], [6.9004071553918696, 8.296272871458132, 0.0746446842757], [6.62170004369944, 1.55614003474944, 3.3502860890496], [3.5094199742005605, 8.57497998315056, 3.3502860890496], [8.57497998315056, 6.62170004369944, 3.3502860890496], [1.55614003474944, 3.5094199742005605, 3.3502860890496], [6.25495349905146, 1.1893934901014602, 0.2093928805656], [3.8761665188485406, 8.941726527798542, 0.2093928805656], [8.941726527798542, 6.25495349905146, 0.2093928805656], [1.1893934901014602, 3.8761665188485406, 0.2093928805656], [5.890233178407061, 6.868899372136201, 3.1030861606040996], [4.24088683949294, 3.2622206457638, 3.1030861606040996], [3.2622206457638, 5.890233178407061, 3.1030861606040996], [6.868899372136201, 4.24088683949294, 3.1030861606040996], [9.30644684844294, 1.8033393631861996, 3.1030861606040996], [0.8246731694570593, 8.3277806547138, 3.1030861606040996], [1.8033393631861996, 0.8246731694570593, 3.1030861606040996], [8.3277806547138, 9.30644684844294, 3.1030861606040996], [7.38356026904552, 5.8152628902745995, 0.8443574026510999], [2.74755974885448, 4.315857127625401, 0.8443574026510999], [4.315857127625401, 7.38356026904552, 0.8443574026510999], [5.8152628902745995, 2.74755974885448, 0.8443574026510999], [7.813119757804481, 0.7497028813245985, 0.8443574026510999], [2.318000260095521, 9.3814171365754, 0.8443574026510999], [0.7497028813245985, 2.318000260095521, 0.8443574026510999], [9.3814171365754, 7.813119757804481, 0.8443574026510999], [7.19106898870542, 5.857813594349781, 2.5854204280946997], [2.9400510291945805, 4.27330642355022, 2.5854204280946997], [4.27330642355022, 7.19106898870542, 2.5854204280946997], [5.857813594349781, 2.9400510291945805, 2.5854204280946997], [8.00561103814458, 0.7922535853997805, 2.5854204280946997], [2.12550897975542, 9.33886643250022, 2.5854204280946997], [0.7922535853997805, 2.12550897975542, 2.5854204280946997], [9.33886643250022, 8.00561103814458, 2.5854204280946997]],
                "lattice_vectors": [[10.1311200179, 0.0, 0.0], [0.0, 10.1311200179, 0.0], [0.0, 0.0, 4.8470574205]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "b": {"X_0": 1}, "c": {"X_0": 2, "X_1": 2, "X_2": 2}, "d": {"X_0": 8, "X_1": 4}}
            }
        ],
        101: [],
        102: [
            {
                "Notes": "Gd<sub>3</sub>Al<sub>2</sub> Structure",
                "Pearsons Symbol": "tP20",
                "Prototype": "Al2Gd3",
                "Space Group Number": 102,
                "Space Group Symbol": "$P4_{2}nm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B3_tP20_102_2c_b2c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_tP20_102_2c_b2c.html",
                "atom_labels": ["Gd", "Gd", "Gd", "Gd", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Gd", "Gd", "Gd", "Gd", "Gd", "Gd", "Gd", "Gd"],
                "atom_positions": [[0.0, 4.16449249465, 3.7889931714], [0.0, 4.16449249465, 0.0], [4.16449249465, 0.0, 0.0], [4.16449249465, 0.0, 3.7889931714], [5.0307069335372, 5.0307069335372, 3.3267360044892], [3.2982780557628004, 3.2982780557628004, 3.3267360044892], [7.462770550412801, 0.8662144388872008, 7.1157291758892], [0.8662144388872008, 7.462770550412801, 7.1157291758892], [5.188957648333901, 5.188957648333901, 0.2349175766268], [3.1400273409661, 3.1400273409661, 0.2349175766268], [7.3045198356161, 1.0244651536839, 4.0239107480268], [1.0244651536839, 7.3045198356161, 4.0239107480268], [6.6215430664935, 6.6215430664935, 5.49404009853], [1.7074419228064996, 1.7074419228064996, 5.49404009853], [5.8719344174565, 2.4570505718434994, 1.7050469271300006], [2.4570505718434994, 5.8719344174565, 1.7050469271300006], [7.0629792709264, 7.0629792709264, 1.9020745720428], [1.2660057183736002, 1.2660057183736002, 1.9020745720428], [5.430498213023601, 2.898486776276399, 5.6910677434428], [2.898486776276399, 5.430498213023601, 5.6910677434428]],
                "lattice_vectors": [[8.3289849893, 0.0, 0.0], [0.0, 8.3289849893, 0.0], [0.0, 0.0, 7.5779863428]],
                "normalized_wyckoff_matid": {"b": {"X_0": 1}, "c": {"X_0": 2, "X_1": 2}}
            }
        ],
        103: [
            {
                "Notes": "NbTe<sub>4</sub> Structure",
                "Pearsons Symbol": "tP10",
                "Prototype": "NbTe4",
                "Space Group Number": 103,
                "Space Group Symbol": "$P4cc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB4_tP10_103_a_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4_tP10_103_a_d.html",
                "atom_labels": ["Nb", "Nb", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.42348788295], [0.9433406611584, 2.14610000413536, 1.6569681353477999], [5.6076361524416, 4.40487680946464, 1.6569681353477999], [4.40487680946464, 0.9433406611584, 1.6569681353477999], [2.14610000413536, 5.6076361524416, 1.6569681353477999], [5.6076361524416, 2.14610000413536, 5.0804560182978], [0.9433406611584, 4.40487680946464, 5.0804560182978], [2.14610000413536, 0.9433406611584, 5.0804560182978], [4.40487680946464, 5.6076361524416, 5.0804560182978]],
                "lattice_vectors": [[6.5509768136, 0.0, 0.0], [0.0, 6.5509768136, 0.0], [0.0, 0.0, 6.8469757659]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_0": 4}}
            }
        ],
        104: [
            {
                "Notes": "Tl<sub>4</sub>HgI<sub>6</sub> Structure",
                "Pearsons Symbol": "tP22",
                "Prototype": "HgI6Tl4",
                "Space Group Number": 104,
                "Space Group Symbol": "$P4nc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB6C4_tP22_104_a_2ac_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB6C4_tP22_104_a_2ac_c.html",
                "atom_labels": ["Hg", "Hg", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl"],
                "atom_positions": [[0.0, 0.0, 7.2485038448628], [4.69700767545, 4.69700767545, 2.6374963099628], [0.0, 0.0, 4.6110075349], [4.69700767545, 4.69700767545, 0.0], [0.0, 0.0, 0.59850877803002], [4.69700767545, 4.69700767545, 5.2095163129300195], [7.79421453664173, 6.066655113611221, 2.6374963099627995], [1.59980081425827, 3.32736023728878, 2.6374963099627995], [3.32736023728878, 7.79421453664173, 2.6374963099627995], [6.066655113611221, 1.59980081425827, 2.6374963099627995], [6.29680848970827, 1.3696474381612194, 7.2485038448628], [3.097206861191729, 8.02436791273878, 7.2485038448628], [1.3696474381612194, 3.097206861191729, 7.2485038448628], [8.02436791273878, 6.29680848970827, 7.2485038448628], [6.09765536426919, 8.06758038335292, 0.33199254251279997], [3.2963599866308098, 1.32643496754708, 0.33199254251279997], [1.32643496754708, 6.09765536426919, 0.33199254251279997], [8.06758038335292, 3.2963599866308098, 0.33199254251279997], [7.99336766208081, 3.37057270790292, 4.9430000774128], [1.40064768881919, 6.02344264299708, 4.9430000774128], [3.37057270790292, 1.40064768881919, 4.9430000774128], [6.02344264299708, 7.99336766208081, 4.9430000774128]],
                "lattice_vectors": [[9.3940153509, 0.0, 0.0], [0.0, 9.3940153509, 0.0], [0.0, 0.0, 9.2220150698]],
                "normalized_wyckoff_matid": {"a": {"X_0": 2, "X_2": 1}, "c": {"X_0": 4, "X_1": 4}}
            },
            {
                "Notes": "Ba<sub>5</sub>In<sub>4</sub>Bi<sub>5</sub> Structure",
                "Pearsons Symbol": "tP28",
                "Prototype": "Ba5Bi5In4",
                "Space Group Number": 104,
                "Space Group Symbol": "$P4nc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A5B5C4_tP28_104_ac_ac_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B5C4_tP28_104_ac_ac_c.html",
                "atom_labels": ["Ba", "Ba", "Bi", "Bi", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "In", "In", "In", "In", "In", "In", "In", "In"],
                "atom_positions": [[0.0, 0.0, 4.5056011544], [5.3112980641, 5.3112980641, 0.0], [0.0, 0.0, 7.94878155659248], [5.3112980641, 5.3112980641, 3.443180402192479], [8.62129901764712, 6.43410647485074, 2.93855307289968], [2.00129711055288, 4.18848965334926, 2.93855307289968], [4.18848965334926, 8.62129901764712, 2.93855307289968], [6.43410647485074, 2.00129711055288, 2.93855307289968], [7.31259517465288, 1.1228084107507412, 7.444154227299681], [3.3100009535471187, 9.499787717449259, 7.444154227299681], [1.1228084107507412, 3.3100009535471187, 7.444154227299681], [9.499787717449259, 7.31259517465288, 7.444154227299681], [6.473622532447643, 8.595911012900721, 0.08812955858006401], [4.148973595752357, 2.026685115299278, 0.08812955858006401], [2.026685115299278, 6.473622532447643, 0.08812955858006401], [8.595911012900721, 4.148973595752357, 0.08812955858006401], [9.460271659852356, 3.2846129488007216, 4.593730712980064], [1.1623244683476448, 7.337983179399278, 4.593730712980064], [3.2846129488007216, 1.1623244683476448, 4.593730712980064], [7.337983179399278, 9.460271659852356, 4.593730712980064], [8.62129901764712, 9.8577692069696, 1.51478310810928], [2.00129711055288, 0.7648269212304, 1.51478310810928], [0.7648269212304, 8.62129901764712, 1.51478310810928], [9.8577692069696, 2.00129711055288, 1.51478310810928], [7.31259517465288, 4.5464711428696, 6.02038426250928], [3.3100009535471187, 6.0761249853304, 6.02038426250928], [4.5464711428696, 3.3100009535471187, 6.02038426250928], [6.0761249853304, 7.31259517465288, 6.02038426250928]],
                "lattice_vectors": [[10.6225961282, 0.0, 0.0], [0.0, 10.6225961282, 0.0], [0.0, 0.0, 9.0112023088]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "c": {"X_0": 4, "X_1": 4, "X_2": 4}}
            }
        ],
        105: [
            {
                "Notes": "BaGe<sub>2</sub>As<sub>2</sub> Structure",
                "Pearsons Symbol": "tP20",
                "Prototype": "As2BaGe2",
                "Space Group Number": 105,
                "Space Group Symbol": "$P4_{2}mc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BC2_tP20_105_f_ac_2e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC2_tP20_105_f_ac_2e.html",
                "atom_labels": ["Ba", "Ba", "Ba", "Ba", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "As", "As", "As", "As", "As", "As", "As", "As"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 4.33192510665], [0.0, 3.89293269625, 0.20879879014053], [3.89293269625, 0.0, 4.54072389679053], [2.60904349302675, 3.89293269625, 3.17443471815312], [5.17682189947325, 3.89293269625, 3.17443471815312], [3.89293269625, 2.60904349302675, 7.506359824803121], [3.89293269625, 5.17682189947325, 7.506359824803121], [1.270653232056, 3.89293269625, 5.25722430943044], [6.515212160443999, 3.89293269625, 5.25722430943044], [3.89293269625, 1.270653232056, 0.9252992027804401], [3.89293269625, 6.515212160443999, 0.9252992027804401], [2.68845932003025, 1.7829631748825001, 2.21621288456214], [5.0974060724697505, 6.0029022176175, 2.21621288456214], [6.0029022176175, 2.68845932003025, 6.5481379912121405], [1.7829631748825001, 5.0974060724697505, 6.5481379912121405], [5.0974060724697505, 1.7829631748825001, 2.21621288456214], [2.68845932003025, 6.0029022176175, 2.21621288456214], [1.7829631748825001, 2.68845932003025, 6.5481379912121405], [6.0029022176175, 5.0974060724697505, 6.5481379912121405]],
                "lattice_vectors": [[7.7858653925, 0.0, 0.0], [0.0, 7.7858653925, 0.0], [0.0, 0.0, 8.6638502133]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "c": {"X_2": 1}, "e": {"X_0": 4}, "f": {"X_1": 4}}
            }
        ],
        106: [
            {
                "Notes": "NaZn[OH]<sub>3</sub> Structure",
                "Pearsons Symbol": "tP64",
                "Prototype": "H]3NaOZn[",
                "Space Group Number": 106,
                "Space Group Symbol": "$P4_{2}bc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3BC3D_tP64_106_3c_c_3c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3BC3D_tP64_106_3c_c_3c_c.html",
                "atom_labels": ["H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn"],
                "atom_positions": [[9.054883546020399, 6.6503570541345995, 1.06601972498], [1.7763168678796002, 4.1808433597654, 1.06601972498], [4.1808433597654, 9.054883546020399, 3.7310690374299997], [6.6503570541345995, 1.7763168678796002, 3.7310690374299997], [7.1919170748296, 1.2347568471845987, 1.06601972498], [3.6392833390703982, 9.596443566715399, 1.06601972498], [1.2347568471845987, 3.6392833390703982, 3.7310690374299997], [9.596443566715399, 7.1919170748296, 3.7310690374299997], [5.7513674197809, 9.152364349745499, 0.586310848739], [5.0798329941191, 1.6788360641545002, 0.586310848739], [1.6788360641545002, 5.7513674197809, 3.251360161189], [9.152364349745499, 5.0798329941191, 3.251360161189], [10.4954332010691, 3.7367641427954994, 0.586310848739], [0.3357672128309015, 7.0944362711045, 0.586310848739], [3.7367641427954994, 0.3357672128309015, 3.251360161189], [7.0944362711045, 10.4954332010691, 3.251360161189], [9.2931699551262, 8.935740341467499, 0.42640788999199997], [1.5380304587738, 1.8954600724325004, 0.42640788999199997], [1.8954600724325004, 9.2931699551262, 3.0914572024419997], [8.935740341467499, 1.5380304587738, 3.0914572024419997], [6.9536306657238, 3.5201401345174994, 0.42640788999199997], [3.877569748176201, 7.311060279382501, 0.42640788999199997], [3.5201401345174994, 3.877569748176201, 3.0914572024419997], [7.311060279382501, 6.9536306657238, 3.0914572024419997], [6.42181872540131, 6.719243488767004, 0.18282238283406999], [4.40938168849869, 4.111956925132995, 0.18282238283406999], [4.111956925132995, 6.42181872540131, 2.84787169528407], [6.719243488767004, 4.40938168849869, 2.84787169528407], [9.82498189544869, 1.3036432818170043, 0.18282238283406999], [1.0062185184513097, 9.527557132082995, 0.18282238283406999], [1.3036432818170043, 1.0062185184513097, 2.84787169528407], [9.527557132082995, 9.82498189544869, 2.84787169528407], [8.82309585716294, 6.708845536369659, 0.36671078539311996], [2.00810455673706, 4.1223548775303405, 0.36671078539311996], [4.1223548775303405, 8.82309585716294, 3.0317600978431196], [6.708845536369659, 2.00810455673706, 3.0317600978431196], [7.42370476368706, 1.2932453294196593, 0.36671078539311996], [3.40749565021294, 9.53795508448034, 0.36671078539311996], [1.2932453294196593, 3.40749565021294, 3.0317600978431196], [9.53795508448034, 7.42370476368706, 3.0317600978431196], [6.15320495513659, 8.98773010345422, 0.70463903821178], [4.67799545876341, 1.8434703104457801, 0.70463903821178], [1.8434703104457801, 6.15320495513659, 3.3696883506617796], [8.98773010345422, 4.67799545876341, 3.3696883506617796], [10.093595665713408, 3.572129896504221, 0.70463903821178], [0.7376047481865905, 7.25907051739578, 0.70463903821178], [3.572129896504221, 0.7376047481865905, 3.3696883506617796], [7.25907051739578, 10.093595665713408, 3.3696883506617796], [9.38956763880991, 9.75457909275834, 0.33899427254364], [1.44163277509009, 1.07662132114166, 0.33899427254364], [1.07662132114166, 9.38956763880991, 3.00404358499364], [9.75457909275834, 1.44163277509009, 3.00404358499364], [6.85723298204009, 4.33897888580834, 0.33899427254364], [3.97396743185991, 6.49222152809166, 0.33899427254364], [4.33897888580834, 3.97396743185991, 3.00404358499364], [6.49222152809166, 6.85723298204009, 3.00404358499364], [7.504397206770614, 10.216313166402896, 0.0], [3.326803207129385, 0.614887247497103, 0.0], [0.614887247497103, 7.504397206770614, 2.66504931245], [10.216313166402896, 3.326803207129385, 2.66504931245], [8.742403414079385, 4.8007129594528966, 0.0], [2.0887969998206146, 6.030487454447103, 0.0], [4.8007129594528966, 2.0887969998206146, 2.66504931245], [6.030487454447103, 8.742403414079385, 2.66504931245]],
                "lattice_vectors": [[10.8312004139, 0.0, 0.0], [0.0, 10.8312004139, 0.0], [0.0, 0.0, 5.3300986249]],
                "normalized_wyckoff_matid": {"c": {"X_0": 3, "X_1": 3, "X_2": 1, "X_3": 1}}
            }
        ],
        107: [
            {
                "Notes": "GeP (High&ndash;pressure, superconducting) Structure",
                "Pearsons Symbol": "tI4",
                "Prototype": "GeP",
                "Space Group Number": 107,
                "Space Group Symbol": "$I4mm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_tI4_107_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tI4_107_a_a.html",
                "atom_labels": ["Ge", "Ge", "P", "P"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.77202525515, 1.77202525515, 2.7905397712], [0.0, 0.0, 2.3831209646048], [1.77202525515, 1.77202525515, 5.173660735804801]],
                "lattice_vectors": [[3.5440505103, 0.0, 0.0], [0.0, 3.5440505103, 0.0], [0.0, 0.0, 5.5810795424]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "Co<sub>5</sub>Ge<sub>7</sub> Structure",
                "Pearsons Symbol": "tI24",
                "Prototype": "Co5Ge7",
                "Space Group Number": 107,
                "Space Group Symbol": "$I4mm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A5B7_tI24_107_ac_abd",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B7_tI24_107_ac_abd.html",
                "atom_labels": ["Co", "Co", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.8200098524, 3.8200098524, 2.90500749245], [0.0, 0.0, 0.3253608391544], [3.8200098524, 3.8200098524, 3.2303683316044], [0.0, 3.8200098524, 0.232400599396], [3.8200098524, 0.0, 0.232400599396], [3.8200098524, 0.0, 3.137408091846], [0.0, 3.8200098524, 3.137408091846], [1.680804335056, 1.680804335056, 0.0], [5.959215369744, 5.959215369744, 0.0], [5.959215369744, 1.680804335056, 0.0], [1.680804335056, 5.959215369744, 0.0], [5.500814187456, 5.500814187456, 2.90500749245], [2.139205517344, 2.139205517344, 2.90500749245], [2.139205517344, 5.500814187456, 2.90500749245], [5.500814187456, 2.139205517344, 2.90500749245], [1.8565247882664, 0.0, 1.6849043456209998], [5.7834949165336, 0.0, 1.6849043456209998], [0.0, 1.8565247882664, 1.6849043456209998], [0.0, 5.7834949165336, 1.6849043456209998], [5.6765346406664, 3.8200098524, 4.589911838071], [1.9634850641336001, 3.8200098524, 4.589911838071], [3.8200098524, 5.6765346406664, 4.589911838071], [3.8200098524, 1.9634850641336001, 4.589911838071]],
                "lattice_vectors": [[7.6400197048, 0.0, 0.0], [0.0, 7.6400197048, 0.0], [0.0, 0.0, 5.8100149849]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "b": {"X_0": 2}, "c": {"X_1": 4}, "d": {"X_0": 4}}
            }
        ],
        108: [
            {
                "Notes": "Sr<sub>5</sub>Si<sub>3</sub> Structure",
                "Pearsons Symbol": "tI32",
                "Prototype": "Si3Sr5",
                "Space Group Number": 108,
                "Space Group Symbol": "$I4cm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B5_tI32_108_ac_a2c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B5_tI32_108_ac_a2c.html",
                "atom_labels": ["Si", "Si", "Si", "Si", "Sr", "Sr", "Sr", "Sr", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr", "Sr"],
                "atom_positions": [[0.0, 0.0, 0.109815823922], [0.0, 0.0, 7.953803246922], [4.02749354235, 4.02749354235, 7.953803246922], [4.02749354235, 4.02749354235, 0.109815823922], [0.0, 0.0, 11.765981134499999], [0.0, 0.0, 3.9219937115], [4.02749354235, 4.02749354235, 3.9219937115], [4.02749354235, 4.02749354235, 11.765981134499999], [0.8779935922323, 4.9054871345823, 4.031809535422], [7.176993492467701, 3.1494999501177, 4.031809535422], [3.1494999501177, 0.8779935922323, 4.031809535422], [4.9054871345823, 7.176993492467701, 4.031809535422], [7.176993492467701, 4.9054871345823, 11.875796958421999], [0.8779935922323, 3.1494999501177, 11.875796958421999], [4.9054871345823, 0.8779935922323, 11.875796958421999], [3.1494999501177, 7.176993492467701, 11.875796958421999], [5.445171269257201, 1.4176777269072, 1.788429132444], [2.6098158154427997, 6.637309357792801, 1.788429132444], [6.637309357792801, 5.445171269257201, 1.788429132444], [1.4176777269072, 2.6098158154427997, 1.788429132444], [2.6098158154427997, 1.4176777269072, 9.632416555444], [5.445171269257201, 6.637309357792801, 9.632416555444], [1.4176777269072, 5.445171269257201, 9.632416555444], [6.637309357792801, 2.6098158154427997, 9.632416555444], [5.445171269257201, 1.4176777269072, 6.2751899384000005], [2.6098158154427997, 6.637309357792801, 6.2751899384000005], [6.637309357792801, 5.445171269257201, 6.2751899384000005], [1.4176777269072, 2.6098158154427997, 6.2751899384000005], [2.6098158154427997, 1.4176777269072, 14.1191773614], [5.445171269257201, 6.637309357792801, 14.1191773614], [1.4176777269072, 5.445171269257201, 14.1191773614], [6.637309357792801, 2.6098158154427997, 14.1191773614]],
                "lattice_vectors": [[8.0549870847, 0.0, 0.0], [0.0, 8.0549870847, 0.0], [0.0, 0.0, 15.687974846]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "c": {"X_0": 4, "X_1": 2}}
            }
        ],
        109: [
            {
                "Notes": "LaPtSi Structure",
                "Pearsons Symbol": "tI12",
                "Prototype": "LaPtSi",
                "Space Group Number": 109,
                "Space Group Symbol": "$I4_{1}md$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_tI12_109_a_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_tI12_109_a_a_a.html",
                "atom_labels": ["La", "La", "La", "La", "Pt", "Pt", "Pt", "Pt", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 1.1776782610872], [0.0, 2.12453474705, 4.8124877088872005], [2.12453474705, 2.12453474705, 8.447297156687199], [2.12453474705, 0.0, 12.0821066044872], [0.0, 0.0, 9.6831323689392], [0.0, 2.12453474705, 13.3179418167392], [2.12453474705, 2.12453474705, 2.413513473339199], [2.12453474705, 0.0, 6.0483229211391984], [0.0, 0.0, 7.2696188956], [0.0, 2.12453474705, 10.9044283434], [2.12453474705, 2.12453474705, 0.0], [2.12453474705, 0.0, 3.6348094478]],
                "lattice_vectors": [[4.2490694941, 0.0, 0.0], [0.0, 4.2490694941, 0.0], [0.0, 0.0, 14.5392377912]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1, "X_2": 1}}
            },
            {
                "Notes": "NbAs Structure",
                "Pearsons Symbol": "tI8",
                "Prototype": "AsNb",
                "Space Group Number": 109,
                "Space Group Symbol": "$I4_{1}md$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_tI8_109_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tI8_109_a_a.html",
                "atom_labels": ["As", "As", "As", "As", "Nb", "Nb", "Nb", "Nb"],
                "atom_positions": [[0.0, 0.0, 4.8589004823007995], [0.0, 1.7258572752, 7.7789127913758], [1.7258572752, 1.7258572752, 10.698925100450799], [1.7258572752, 0.0, 1.9388881732257992], [0.0, 0.0, 0.0], [0.0, 1.7258572752, 2.920012309075], [1.7258572752, 1.7258572752, 5.84002461815], [1.7258572752, 0.0, 8.760036927225]],
                "lattice_vectors": [[3.4517145504, 0.0, 0.0], [0.0, 3.4517145504, 0.0], [0.0, 0.0, 11.6800492363]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}}
            }
        ],
        110: [
            {
                "Notes": "Be[BH<sub>4</sub>]<sub>2</sub> Structure",
                "Pearsons Symbol": "tI176",
                "Prototype": "BBe[H4]2",
                "Space Group Number": 110,
                "Space Group Symbol": "$I4_{1}cd$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BC8_tI176_110_2b_b_8b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC8_tI176_110_2b_b_8b.html",
                "atom_labels": ["B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[7.478758473, 11.389069086000001, 2.35690518], [6.141271527, 2.2309609139999993, 2.35690518], [2.2309609139999993, 0.6687434730000019, 4.63191018], [11.389069086000001, 12.951286526999999, 4.63191018], [6.141271527, 11.389069086000001, 6.90691518], [7.478758473, 2.2309609139999993, 6.90691518], [4.579054086000001, 7.478758473, 4.63191018], [9.040975913999999, 6.141271527, 4.63191018], [0.6687434730000019, 4.579054086000001, 6.90691518], [12.951286526999999, 9.040975913999999, 6.90691518], [9.040975913999999, 7.478758473, 0.08190017999999907], [4.579054086000001, 6.141271527, 0.08190017999999907], [12.951286526999999, 4.579054086000001, 2.35690518], [0.6687434730000019, 9.040975913999999, 2.35690518], [11.389069086000001, 0.6687434730000019, 0.08190017999999907], [2.2309609139999993, 12.951286526999999, 0.08190017999999907], [10.984554195, 8.697751157999999, 3.3706474080000004], [2.635475805, 4.922278842000001, 3.3706474080000004], [4.922278842000001, 4.1745391949999995, 5.645652408000001], [8.697751157999999, 9.445490805, 5.645652408000001], [2.635475805, 8.697751157999999, 7.920657408000001], [10.984554195, 4.922278842000001, 7.920657408000001], [1.8877361579999978, 10.984554195, 5.645652408000001], [11.732293842, 2.635475805, 5.645652408000001], [4.1745391949999995, 1.8877361579999978, 7.920657408000001], [9.445490805, 11.732293842, 7.920657408000001], [11.732293842, 10.984554195, 1.0956424080000007], [1.8877361579999978, 2.635475805, 1.0956424080000007], [9.445490805, 1.8877361579999978, 3.3706474080000004], [4.1745391949999995, 11.732293842, 3.3706474080000004], [8.697751157999999, 4.1745391949999995, 1.0956424080000007], [4.922278842000001, 9.445490805, 1.0956424080000007], [2.721281994, 1.1835806070000001, 0.0], [10.898748006, 12.436449393, 0.0], [12.436449393, 9.531296994, 2.275005], [1.1835806070000001, 4.088733006, 2.275005], [10.898748006, 1.1835806070000001, 4.55001], [2.721281994, 12.436449393, 4.55001], [7.993595607, 2.721281994, 2.275005], [5.626434393, 10.898748006, 2.275005], [9.531296994, 7.993595607, 4.55001], [4.088733006, 5.626434393, 4.55001], [5.626434393, 2.721281994, 6.8250150000000005], [7.993595607, 10.898748006, 6.8250150000000005], [4.088733006, 7.993595607, 0.0], [9.531296994, 5.626434393, 0.0], [1.1835806070000001, 9.531296994, 6.8250150000000005], [12.436449393, 4.088733006, 6.8250150000000005], [7.745711061, 12.319317134999999, 2.8191861960000004], [5.874318939, 1.300712865, 2.8191861960000004], [1.300712865, 0.9356960609999998, 5.0941911960000015], [12.319317134999999, 12.684333939, 5.0941911960000015], [5.874318939, 12.319317134999999, 7.369196196000002], [7.745711061, 1.300712865, 7.369196196000002], [5.5093021349999995, 7.745711061, 5.0941911960000015], [8.110727865000001, 5.874318939, 5.0941911960000015], [0.9356960609999998, 5.5093021349999995, 7.369196196000002], [12.684333939, 8.110727865000001, 7.369196196000002], [8.110727865000001, 7.745711061, 0.5441811960000007], [5.5093021349999995, 5.874318939, 0.5441811960000007], [12.684333939, 5.5093021349999995, 2.8191861960000004], [0.9356960609999998, 8.110727865000001, 2.8191861960000004], [12.319317134999999, 0.9356960609999998, 0.5441811960000007], [1.300712865, 12.684333939, 0.5441811960000007], [8.188362036, 10.633157421, 1.894624164], [5.431667964000001, 2.986872579000001, 1.894624164], [2.986872579000001, 1.3783470359999994, 4.169629164], [10.633157421, 12.241682964, 4.169629164], [5.431667964000001, 10.633157421, 6.444634164], [8.188362036, 2.986872579000001, 6.444634164], [3.823142420999999, 8.188362036, 4.169629164], [9.796887579, 5.431667964000001, 4.169629164], [1.3783470359999994, 3.823142420999999, 6.444634164], [12.241682964, 9.796887579, 6.444634164], [9.796887579, 8.188362036, 8.719639164], [3.823142420999999, 5.431667964000001, 8.719639164], [12.241682964, 3.823142420999999, 1.894624164], [1.3783470359999994, 9.796887579, 1.894624164], [10.633157421, 1.3783470359999994, 8.719639164], [2.986872579000001, 12.241682964, 8.719639164], [6.854961099, 10.802045793, 3.1686269640000004], [6.765068901, 2.8179842069999994, 3.1686269640000004], [2.8179842069999994, 0.044946098999998074, 5.443631964000001], [10.802045793, 13.575083901000001, 5.443631964000001], [6.765068901, 10.802045793, 7.718636964000001], [6.854961099, 2.8179842069999994, 7.718636964000001], [3.9920307929999987, 6.854961099, 5.443631964000001], [9.627999207, 6.765068901, 5.443631964000001], [0.044946098999998074, 3.9920307929999987, 7.718636964000001], [13.575083901000001, 9.627999207, 7.718636964000001], [9.627999207, 6.854961099, 0.8936219640000006], [3.9920307929999987, 6.765068901, 0.8936219640000006], [13.575083901000001, 3.9920307929999987, 3.1686269640000004], [0.044946098999998074, 9.627999207, 3.1686269640000004], [10.802045793, 0.044946098999998074, 0.8936219640000006], [2.8179842069999994, 13.575083901000001, 0.8936219640000006], [8.734525239, 6.923061249, 3.7846983180000002], [4.885504761, 6.696968751, 3.7846983180000002], [6.696968751, 1.9245102389999997, 6.0597033179999995], [6.923061249, 11.695519761, 6.0597033179999995], [4.885504761, 6.923061249, 8.334708318], [8.734525239, 6.696968751, 8.334708318], [0.11304624899999964, 8.734525239, 6.0597033179999995], [13.506983751, 4.885504761, 6.0597033179999995], [1.9245102389999997, 0.11304624899999964, 8.334708318], [11.695519761, 13.506983751, 8.334708318], [13.506983751, 8.734525239, 1.5096933179999996], [0.11304624899999964, 4.885504761, 1.5096933179999996], [11.695519761, 0.11304624899999964, 3.7846983180000002], [1.9245102389999997, 13.506983751, 3.7846983180000002], [6.923061249, 1.9245102389999997, 1.5096933179999996], [6.696968751, 11.695519761, 1.5096933179999996], [11.489857308, 8.245566162000001, 2.504325504], [2.130172692, 5.374463838, 2.504325504], [5.374463838, 4.679842307999999, 4.779330504000001], [8.245566162000001, 8.940187692, 4.779330504000001], [2.130172692, 8.245566162000001, 7.054335504000001], [11.489857308, 5.374463838, 7.054335504000001], [1.4355511619999992, 11.489857308, 4.779330504000001], [12.184478837999999, 2.130172692, 4.779330504000001], [4.679842307999999, 1.4355511619999992, 7.054335504000001], [8.940187692, 12.184478837999999, 7.054335504000001], [12.184478837999999, 11.489857308, 0.229320503999999], [1.4355511619999992, 2.130172692, 0.229320503999999], [8.940187692, 1.4355511619999992, 2.504325504], [4.679842307999999, 12.184478837999999, 2.504325504], [8.245566162000001, 4.679842307999999, 0.229320503999999], [5.374463838, 8.940187692, 0.229320503999999], [11.405413122, 9.700185366000001, 3.5526478080000006], [2.2146168779999997, 3.919844633999999, 3.5526478080000006], [3.919844633999999, 4.5953981220000015, 5.827652808000001], [9.700185366000001, 9.024631878, 5.827652808000001], [2.2146168779999997, 9.700185366000001, 8.102657808000002], [11.405413122, 3.919844633999999, 8.102657808000002], [2.890170366000002, 11.405413122, 5.827652808000001], [10.729859633999999, 2.2146168779999997, 5.827652808000001], [4.5953981220000015, 2.890170366000002, 8.102657808000002], [9.024631878, 10.729859633999999, 8.102657808000002], [10.729859633999999, 11.405413122, 1.2776428080000009], [2.890170366000002, 2.2146168779999997, 1.2776428080000009], [9.024631878, 2.890170366000002, 3.5526478080000006], [4.5953981220000015, 10.729859633999999, 3.5526478080000006], [9.700185366000001, 4.5953981220000015, 1.2776428080000009], [3.919844633999999, 9.024631878, 1.2776428080000009], [9.923553858, 8.784919350000001, 3.19865703], [3.6964761419999994, 4.83511065, 3.19865703], [4.83511065, 3.113538858000002, 5.47366203], [8.784919350000001, 10.506491142, 5.47366203], [3.6964761419999994, 8.784919350000001, 7.74866703], [9.923553858, 4.83511065, 7.74866703], [1.9749043500000003, 9.923553858, 5.47366203], [11.645125649999999, 3.6964761419999994, 5.47366203], [3.113538858000002, 1.9749043500000003, 7.74866703], [10.506491142, 11.645125649999999, 7.74866703], [11.645125649999999, 9.923553858, 0.9236520299999994], [1.9749043500000003, 3.6964761419999994, 0.9236520299999994], [10.506491142, 1.9749043500000003, 3.19865703], [3.113538858000002, 11.645125649999999, 3.19865703], [8.784919350000001, 3.113538858000002, 0.9236520299999994], [4.83511065, 10.506491142, 0.9236520299999994], [11.100324449999999, 8.034455697, 4.332519522], [2.5197055500000007, 5.5855743030000005, 4.332519522], [5.5855743030000005, 4.29030945, 6.607524522], [8.034455697, 9.329720550000001, 6.607524522], [2.5197055500000007, 8.034455697, 8.882529522], [11.100324449999999, 5.5855743030000005, 8.882529522], [1.2244406970000012, 11.100324449999999, 6.607524522], [12.395589303, 2.5197055500000007, 6.607524522], [4.29030945, 1.2244406970000012, 8.882529522], [9.329720550000001, 12.395589303, 8.882529522], [12.395589303, 11.100324449999999, 2.057514522], [1.2244406970000012, 2.5197055500000007, 2.057514522], [9.329720550000001, 1.2244406970000012, 4.332519522], [4.29030945, 12.395589303, 4.332519522], [8.034455697, 4.29030945, 2.057514522], [5.5855743030000005, 9.329720550000001, 2.057514522]],
                "lattice_vectors": [[13.62003, 0.0, 0.0], [0.0, 13.62003, 0.0], [0.0, 0.0, 9.10002]],
                "normalized_wyckoff_matid": {"b": {"X_0": 8, "X_1": 2, "X_2": 1}}
            }
        ],
        111: [
            {
                "Notes": "MnF<sub>2</sub> Structure",
                "Pearsons Symbol": "tP12",
                "Prototype": "F2Mn",
                "Space Group Number": 111,
                "Space Group Symbol": "$P\\bar{4}2m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_tP12_111_2n_adf",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tP12_111_2n_adf.html",
                "atom_labels": ["Mn", "Mn", "Mn", "Mn", "F", "F", "F", "F", "F", "F", "F", "F"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.5609965931, 2.5609965931, 0.0], [2.5609965931, 0.0, 2.627996504], [0.0, 2.5609965931, 2.627996504], [1.0500086031709999, 1.0500086031709999, 1.4716780422400002], [1.0500086031709999, 4.071984583029001, 3.7843149657599997], [4.071984583029001, 1.0500086031709999, 3.7843149657599997], [4.071984583029001, 4.071984583029001, 1.4716780422400002], [1.5417199490462, 1.5417199490462, 3.269227650976], [1.5417199490462, 3.5802732371538, 1.986765357024], [3.5802732371538, 1.5417199490462, 1.986765357024], [3.5802732371538, 3.5802732371538, 3.269227650976]],
                "lattice_vectors": [[5.1219931862, 0.0, 0.0], [0.0, 5.1219931862, 0.0], [0.0, 0.0, 5.255993008]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_1": 1}, "f": {"X_1": 2}, "n": {"X_0": 8}}
            },
            {
                "Notes": "VN (Low&ndash;temperature) Structure",
                "Pearsons Symbol": "tP8",
                "Prototype": "NV",
                "Space Group Number": 111,
                "Space Group Symbol": "$P\\bar{4}2m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_tP8_111_n_n",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tP8_111_n_n.html",
                "atom_labels": ["N", "N", "N", "N", "V", "V", "V", "V"],
                "atom_positions": [[1.04172573610092, 1.04172573610092, 3.08355016787457], [1.04172573610092, 3.08882833249908, 1.0427045730254303], [3.08882833249908, 1.04172573610092, 1.0427045730254303], [3.08882833249908, 3.08882833249908, 3.08355016787457], [1.00847477584869, 1.00847477584869, 1.006971206969236], [1.00847477584869, 3.1220792927513106, 3.1192835339307643], [3.1220792927513106, 1.00847477584869, 3.1192835339307643], [3.1220792927513106, 3.1220792927513106, 1.006971206969236]],
                "lattice_vectors": [[4.1305540686, 0.0, 0.0], [0.0, 4.1305540686, 0.0], [0.0, 0.0, 4.1262547409]]
            }
        ],
        112: [
            {
                "Notes": "$\\alpha$&ndash;CuAlCl<sub>4</sub> Structure",
                "Pearsons Symbol": "tP12",
                "Prototype": "AlCl4Cu",
                "Space Group Number": 112,
                "Space Group Symbol": "$P\\bar{4}2c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB4C_tP12_112_b_n_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4C_tP12_112_b_n_e.html",
                "atom_labels": ["Al", "Al", "Cu", "Cu", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[2.7205491388, 0.0, 2.528242130975], [0.0, 2.7205491388, 7.584726392924999], [0.0, 0.0, 0.0], [0.0, 0.0, 5.05648426195], [1.26995233799184, 1.5022872344453602, 6.366113685795049], [1.26995233799184, 3.93881104315464, 8.80333910005495], [4.171145939608159, 1.5022872344453602, 8.80333910005495], [4.171145939608159, 3.93881104315464, 6.366113685795049], [1.5022872344453602, 1.26995233799184, 1.3096294238450494], [1.5022872344453602, 4.171145939608159, 3.7468548381049502], [3.93881104315464, 1.26995233799184, 3.7468548381049502], [3.93881104315464, 4.171145939608159, 1.3096294238450494]],
                "lattice_vectors": [[5.4410982776, 0.0, 0.0], [0.0, 5.4410982776, 0.0], [0.0, 0.0, 10.1129685239]],
                "normalized_wyckoff_matid": {"b": {"X_1": 1}, "e": {"X_2": 1}, "n": {"X_0": 4}}
            }
        ],
        113: [
            {
                "Notes": "BaS<sub>3</sub> (D0<sub>17</sub>) Structure",
                "Pearsons Symbol": "tP8",
                "Prototype": "BaS3",
                "Space Group Number": 113,
                "Space Group Symbol": "$P\\bar{4}2_{1}m$",
                "Strukturbericht Designation": "$D0_{17}$",
                "aflow_prototype_id": "AB3_tP8_113_a_ce",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_tP8_113_a_ce.html",
                "atom_labels": ["Ba", "Ba", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.4355, 3.4355, 0.0], [0.0, 3.4355, 0.8586286], [3.4355, 0.0, 3.3094714], [1.2347187000000002, 4.6702187, 1.9840155999999998], [4.6702187, 5.6362813, 2.1840844], [2.2007813000000005, 1.2347187, 2.1840844], [5.6362813, 2.2007813000000005, 1.9840155999999998]],
                "lattice_vectors": [[6.871, 0.0, 0.0], [0.0, 6.871, 0.0], [0.0, 0.0, 4.1681]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 1}, "e": {"X_0": 2}}
            },
            {
                "Notes": "Akermanite (Ca<sub>2</sub>MgSi<sub>2</sub>O<sub>7</sub>, $S5_{3}$) Structure",
                "Pearsons Symbol": "tP24",
                "Prototype": "Ca2MgO7Si2",
                "Space Group Number": 113,
                "Space Group Symbol": "$P\\bar{4}2_{1}m$",
                "Strukturbericht Designation": "$S5_{3}$",
                "aflow_prototype_id": "A2BC7D2_tP24_113_e_a_cef_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC7D2_tP24_113_e_a_cef_e.html",
                "atom_labels": ["Mg", "Mg", "O", "O", "Ca", "Ca", "Ca", "Ca", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.9169, 3.9169, 0.0], [0.0, 3.9169, 4.107224820000001], [3.9169, 0.0, 0.9009751799999999], [6.52085512, 2.6039551199999997, 2.4715467], [2.60395512, 1.3129448800000003, 2.5366532999999998], [5.22984488, 6.52085512, 2.5366532999999998], [1.3129448799999999, 5.22984488, 2.4715467], [5.019115660000001, 1.10221566, 3.74162622], [1.1022156600000004, 2.81468434, 1.26657378], [6.7315843399999995, 5.019115660000001, 1.26657378], [2.8146843399999995, 6.7315843399999995, 3.74162622], [5.01049848, 1.09359848, 0.32152643999999997], [1.0935984799999996, 2.8233015200000002, 4.68667356], [6.74020152, 5.01049848, 4.68667356], [2.8233015200000007, 6.74020152, 0.32152643999999997], [0.6251372399999999, 1.4586535600000001, 3.9344419200000003], [4.54203724, 2.45824644, 1.0737580800000002], [3.29176276, 5.37555356, 1.0737580800000002], [7.20866276, 6.37514644, 3.9344419200000003], [5.37555356, 4.54203724, 3.9344419200000003], [1.4586535600000001, 7.20866276, 1.0737580800000002], [6.37514644, 0.6251372399999999, 1.0737580800000002], [2.45824644, 3.29176276, 3.9344419200000003]],
                "lattice_vectors": [[7.8338, 0.0, 0.0], [0.0, 7.8338, 0.0], [0.0, 0.0, 5.0082]],
                "normalized_wyckoff_matid": {"a": {"X_3": 1}, "c": {"X_0": 1}, "e": {"X_0": 2, "X_1": 2, "X_2": 2}, "f": {"X_0": 4}}
            }
        ],
        114: [
            {
                "Notes": "Pd<sub>4</sub>Se Structure",
                "Pearsons Symbol": "tP10",
                "Prototype": "Pd4Se",
                "Space Group Number": 114,
                "Space Group Symbol": "$P\\bar{4}2_{1}c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B_tP10_114_e_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B_tP10_114_e_a.html",
                "atom_labels": ["Se", "Se", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.61617957435, 2.61617957435, 2.8234779559], [3.2754568270861997, 4.0184518262016, 4.7773247013828], [0.6592772527361994, 3.8300868968483996, 3.6931091663172], [4.573081895963799, 1.4022722518516, 3.6931091663172], [1.9569023216138, 1.2139073224983998, 4.7773247013828], [1.4022722518516, 0.6592772527361994, 1.9538467454828006], [4.0184518262016, 1.9569023216138, 0.8696312104172002], [1.2139073224983998, 3.2754568270861997, 0.8696312104172002], [3.8300868968483996, 4.573081895963799, 1.9538467454828006]],
                "lattice_vectors": [[5.2323591487, 0.0, 0.0], [0.0, 5.2323591487, 0.0], [0.0, 0.0, 5.6469559118]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "e": {"X_0": 4}}
            },
            {
                "Notes": "SeO<sub>3</sub> Structure",
                "Pearsons Symbol": "tP32",
                "Prototype": "O3Se",
                "Space Group Number": 114,
                "Space Group Symbol": "$P\\bar{4}2_{1}c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_tP32_114_3e_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_tP32_114_3e_e.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se"],
                "atom_positions": [[5.78175260046, 7.1597369702363, 4.2716327432108], [0.9636254334100008, 7.2946445309137005, 3.6485762985891994], [8.67262890069, 2.341609803186299, 3.6485762985891994], [3.8545017336400003, 2.4765173638637, 4.2716327432108], [2.341609803186299, 0.9636254334100008, 1.6315630626108009], [7.1597369702363, 3.8545017336400003, 1.0085066179891997], [2.4765173638637, 5.78175260046, 1.0085066179891997], [7.2946445309137005, 8.67262890069, 1.6315630626108009], [8.0559086233076, 5.348121155425501, 3.1892041741647996], [3.237781456257599, 9.1062603457245, 4.7310048676352], [6.3984728778424005, 0.5299939883755016, 4.7310048676352], [1.5803457107924004, 4.288133178674499, 3.1892041741647996], [0.5299939883755016, 3.237781456257599, 0.5491344935648005], [5.348121155425501, 1.5803457107924004, 2.0909351870352], [4.288133178674499, 8.0559086233076, 2.0909351870352], [9.1062603457245, 6.3984728778424005, 0.5491344935648005], [8.4895400683421, 8.662992646355901, 4.4564376208528], [3.6714129012921, 5.7913888547941, 3.4637714209472], [5.9648414328079005, 3.8448654793059003, 3.4637714209472], [1.1467142657579, 0.9732616877440998, 4.4564376208528], [3.8448654793059003, 3.6714129012921, 1.8163679402527992], [8.662992646355901, 1.1467142657579, 0.8237017403472001], [0.9732616877440998, 8.4895400683421, 0.8237017403472001], [5.7913888547941, 5.9648414328079005, 1.8163679402527992], [4.938580346226249, 7.00844777719093, 2.9727184603555994], [0.12045317917624958, 7.445933723959071, 4.9474905814444], [9.51580115492375, 2.1903206101409305, 4.9474905814444], [4.697673987873751, 2.6278065569090705, 2.9727184603555994], [2.1903206101409305, 0.12045317917624958, 0.3326487797555997], [7.00844777719093, 4.697673987873751, 2.3074209008444004], [2.6278065569090705, 4.938580346226249, 2.3074209008444004], [7.445933723959071, 9.51580115492375, 0.3326487797555997]],
                "lattice_vectors": [[9.6362543341, 0.0, 0.0], [0.0, 9.6362543341, 0.0], [0.0, 0.0, 5.2801393612]],
                "normalized_wyckoff_matid": {"e": {"X_0": 3, "X_1": 1}}
            }
        ],
        115: [
            {
                "Notes": "HgI<sub>2</sub> Structure",
                "Pearsons Symbol": "tP12",
                "Prototype": "HgI2",
                "Space Group Number": 115,
                "Space Group Symbol": "$P\\bar{4}m2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_tP12_115_j_egi",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_tP12_115_j_egi.html",
                "atom_labels": ["I", "I", "I", "I", "I", "I", "I", "I", "Hg", "Hg", "Hg", "Hg"],
                "atom_positions": [[0.0, 0.0, 0.17760176944991998], [0.0, 0.0, 5.98912633645008], [0.0, 4.3931700226, 0.19425193533585], [4.3931700226, 0.0, 5.97247617056415], [2.3194180451318958, 2.3194180451318958, 3.08336405295], [6.466922000068103, 6.466922000068103, 3.08336405295], [6.466922000068103, 2.3194180451318958, 3.08336405295], [2.3194180451318958, 6.466922000068103, 3.08336405295], [2.189380212462936, 0.0, 1.538290326016755], [6.596959832737064, 0.0, 1.538290326016755], [0.0, 6.596959832737064, 4.628437779883245], [0.0, 2.189380212462936, 4.628437779883245]],
                "lattice_vectors": [[8.7863400452, 0.0, 0.0], [0.0, 8.7863400452, 0.0], [0.0, 0.0, 6.1667281059]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1}, "g": {"X_0": 1}, "h": {"X_0": 2}, "j": {"X_1": 2}}
            },
            {
                "Notes": "Rh<sub>3</sub>P<sub>2</sub> Structure",
                "Pearsons Symbol": "tP5",
                "Prototype": "P2Rh3",
                "Space Group Number": 115,
                "Space Group Symbol": "$P\\bar{4}m2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B3_tP5_115_g_ag",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_tP5_115_g_ag.html",
                "atom_labels": ["Rh", "P", "P", "Rh", "Rh"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 1.66345942215, 1.5561650394752], [1.66345942215, 0.0, 4.5946849189248], [0.0, 1.66345942215, 3.8799561537587204], [1.66345942215, 0.0, 2.27089380464128]],
                "lattice_vectors": [[3.3269188443, 0.0, 0.0], [0.0, 3.3269188443, 0.0], [0.0, 0.0, 6.1508499584]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "g": {"X_0": 2, "X_1": 2}}
            }
        ],
        116: [
            {
                "Notes": "Ru<sub>2</sub>Sn<sub>3</sub> Structure",
                "Pearsons Symbol": "tP20",
                "Prototype": "Ru2Sn3",
                "Space Group Number": 116,
                "Space Group Symbol": "$P\\bar{4}c2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B3_tP20_116_bci_fj",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_tP20_116_bci_fj.html",
                "atom_labels": ["Ru", "Ru", "Ru", "Ru", "Sn", "Sn", "Sn", "Sn", "Ru", "Ru", "Ru", "Ru", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn"],
                "atom_positions": [[3.08600575925, 3.08600575925, 2.478754625975], [3.08600575925, 3.08600575925, 7.4362638779250005], [0.0, 0.0, 0.0], [0.0, 0.0, 4.95750925195], [1.0924460387744999, 1.0924460387744999, 7.4362638779250005], [5.0795654797255, 5.0795654797255, 7.4362638779250005], [5.0795654797255, 1.0924460387744999, 2.478754625975], [1.0924460387744999, 5.0795654797255, 2.478754625975], [0.0, 3.08600575925, 6.1968865649375005], [3.08600575925, 0.0, 8.6756411909125], [0.0, 3.08600575925, 1.2393773129875], [3.08600575925, 0.0, 3.7181319389625003], [4.0426675446175, 1.333154487996, 5.7705407692698], [2.1293439738825, 4.838857030504, 5.7705407692698], [4.838857030504, 2.1293439738825, 9.1019869865802], [1.333154487996, 4.0426675446175, 9.1019869865802], [2.1293439738825, 1.333154487996, 0.8130315173197986], [4.0426675446175, 4.838857030504, 0.8130315173197986], [1.333154487996, 2.1293439738825, 4.1444777346302], [4.838857030504, 4.0426675446175, 4.1444777346302]],
                "lattice_vectors": [[6.1720115185, 0.0, 0.0], [0.0, 6.1720115185, 0.0], [0.0, 0.0, 9.9150185039]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_1": 1}, "e": {"X_0": 2}, "i": {"X_1": 2}, "j": {"X_0": 4}}
            }
        ],
        117: [
            {
                "Notes": "$\\beta$&ndash;Bi<sub>2</sub>O<sub>3</sub> (High&ndash;temperature, $D5_{12}$) Structure",
                "Pearsons Symbol": "tP20",
                "Prototype": "Bi2O3",
                "Space Group Number": 117,
                "Space Group Symbol": "$P\\bar{4}b2$",
                "Strukturbericht Designation": "$D5_{12}$",
                "aflow_prototype_id": "A2B3_tP20_117_i_adgh",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_tP20_117_i_adgh.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.86448304655, 3.86448304655, 0.0], [0.0, 3.86448304655, 2.8099876726], [3.86448304655, 0.0, 2.8099876726], [5.6421452479630005, 1.7776622014130001, 0.0], [2.0868208451370003, 5.951303891687, 0.0], [5.951303891687, 5.6421452479630005, 0.0], [1.777662201413, 2.0868208451370003, 0.0], [5.6421452479630005, 1.7776622014130001, 2.8099876726], [2.0868208451370003, 5.951303891687, 2.8099876726], [5.951303891687, 5.6421452479630005, 2.8099876726], [1.777662201413, 2.0868208451370003, 2.8099876726], [5.796724569825001, 4.019062368412, 1.4049938363], [1.932241523275, 3.709903724688, 1.4049938363], [7.574386771238, 5.796724569825001, 4.2149815089], [0.15457932186200016, 1.932241523275, 4.2149815089], [5.796724569825001, 0.15457932186200016, 1.4049938363], [1.932241523275, 7.574386771238, 1.4049938363], [4.019062368412, 1.932241523275, 4.2149815089], [3.709903724688, 5.796724569825001, 4.2149815089]],
                "lattice_vectors": [[7.7289660931, 0.0, 0.0], [0.0, 7.7289660931, 0.0], [0.0, 0.0, 5.6199753452]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "d": {"X_0": 1}, "g": {"X_0": 2}, "h": {"X_0": 2}, "i": {"X_1": 4}}
            }
        ],
        118: [
            {
                "Notes": "RuIn<sub>3</sub> Structure",
                "Pearsons Symbol": "tP16",
                "Prototype": "In3Ru",
                "Space Group Number": 118,
                "Space Group Symbol": "$P\\bar{4}n2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_tP16_118_ei_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_tP16_118_ei_f.html",
                "atom_labels": ["In", "In", "In", "In", "Ru", "Ru", "Ru", "Ru", "In", "In", "In", "In", "In", "In", "In", "In"],
                "atom_positions": [[0.0, 0.0, 1.7168286230493], [3.4991512699, 3.4991512699, 1.9051726914007], [3.4991512699, 3.4991512699, 5.3388299374993], [0.0, 0.0, 5.5271740058507], [1.04974538097, 2.44940588893, 1.811000657225], [5.94855715883, 4.548896650870001, 1.811000657225], [2.44940588893, 5.94855715883, 5.433001971675], [4.548896650870001, 1.0497453809700001, 5.433001971675], [2.4004177711514, 1.0427470784302, 3.6871973381100998], [4.5978847686486, 5.9555554613698, 3.6871973381100998], [2.4564041914698, 1.0987334987485997, 7.1788066052399], [4.5418983483302, 5.8995690410514, 7.1788066052399], [1.0987334987485997, 4.5418983483302, 0.06519602366009924], [5.8995690410514, 2.4564041914698, 0.06519602366009924], [1.0427470784302, 4.5978847686486, 3.5568052907899], [5.9555554613698, 2.4004177711514, 3.5568052907899]],
                "lattice_vectors": [[6.9983025398, 0.0, 0.0], [0.0, 6.9983025398, 0.0], [0.0, 0.0, 7.2440026289]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1}, "f": {"X_1": 1}, "i": {"X_0": 2}}
            },
            {
                "Notes": "Ir<sub>3</sub>Ga<sub>5</sub> Structure",
                "Pearsons Symbol": "tP32",
                "Prototype": "Ga5Ir3",
                "Space Group Number": 118,
                "Space Group Symbol": "$P\\bar{4}n2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A5B3_tP32_118_g2i_aceh",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B3_tP32_118_g2i_aceh.html",
                "atom_labels": ["Ir", "Ir", "Ir", "Ir", "Ir", "Ir", "Ir", "Ir", "Ga", "Ga", "Ga", "Ga", "Ir", "Ir", "Ir", "Ir", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.9114917927, 2.9114917927, 7.0999799856], [0.0, 2.9114917927, 3.5499899928], [2.9114917927, 0.0, 10.6499699784], [0.0, 0.0, 9.52675314467808], [2.9114917927, 2.9114917927, 11.773186812121919], [2.9114917927, 2.9114917927, 2.4267731590780808], [0.0, 0.0, 4.67320682652192], [3.9305139201450006, 1.019022127445, 3.5499899928], [1.892469665255, 4.803961457955, 3.5499899928], [4.803961457955, 3.9305139201450006, 10.6499699784], [1.0190221274450002, 1.8924696652550002, 10.6499699784], [0.0, 2.9114917927, 8.322596539120319], [0.0, 2.9114917927, 12.97734341767968], [2.9114917927, 0.0, 1.2226165535203208], [2.9114917927, 0.0, 5.87736343207968], [4.250778017342, 4.9495360475900005, 7.8312779241168], [1.5722055680580003, 0.8734475378100002, 7.8312779241168], [3.7849393305100003, 4.483697360758001, 13.4686620326832], [2.0380442548900004, 1.3392862246419999, 13.4686620326832], [4.483697360758001, 2.0380442548900004, 0.7312979385167983], [1.3392862246419999, 3.7849393305100003, 0.7312979385167983], [4.9495360475900005, 1.5722055680580003, 6.3686820470832], [0.8734475378100002, 4.250778017342, 6.3686820470832], [4.891306211736, 4.65838686832, 2.12999399568], [0.9316773736640003, 1.1645967170799998, 2.12999399568], [4.07608850978, 3.8431691663640004, 4.96998598992], [1.7468950756200003, 1.9798144190359992, 4.96998598992], [3.8431691663640004, 1.7468950756200003, 9.22997398128], [1.9798144190359992, 4.07608850978, 9.22997398128], [4.65838686832, 0.9316773736640003, 12.06996597552], [1.1645967170799998, 4.891306211736, 12.06996597552]],
                "lattice_vectors": [[5.8229835854, 0.0, 0.0], [0.0, 5.8229835854, 0.0], [0.0, 0.0, 14.1999599712]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_1": 1}, "e": {"X_1": 2}, "f": {"X_0": 2}, "h": {"X_1": 2}, "i": {"X_0": 8}}
            }
        ],
        119: [
            {
                "Notes": "GaSb Structure",
                "Pearsons Symbol": "tI4",
                "Prototype": "GaSb",
                "Space Group Number": 119,
                "Space Group Symbol": "$I\\bar{4}m2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_tI4_119_c_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tI4_119_c_a.html",
                "atom_labels": ["Sb", "Sb", "Ga", "Ga"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.7395050752, 2.7395050752, 1.5300028345], [0.0, 2.7395050752, 0.76500141725], [2.7395050752, 0.0, 2.29500425175]],
                "lattice_vectors": [[5.4790101504, 0.0, 0.0], [0.0, 5.4790101504, 0.0], [0.0, 0.0, 3.060005669]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "d": {"X_1": 1}}
            },
            {
                "Notes": "RbGa<sub>3</sub> Structure",
                "Pearsons Symbol": "tI24",
                "Prototype": "Ga3Rb",
                "Space Group Number": 119,
                "Space Group Symbol": "$I\\bar{4}m2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_tI24_119_b2i_af",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_tI24_119_b2i_af.html",
                "atom_labels": ["Rb", "Rb", "Ga", "Ga", "Rb", "Rb", "Rb", "Rb", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.1575, 3.1575, 7.5], [0.0, 0.0, 7.5], [3.1575, 3.1575, 0.0], [0.0, 3.1575, 5.58], [3.1575, 0.0, 9.42], [3.1575, 0.0, 13.08], [0.0, 3.1575, 1.92], [1.3059420000000002, 0.0, 3.3434999999999997], [5.0090580000000005, 0.0, 3.3434999999999997], [0.0, 5.0090580000000005, 11.6565], [0.0, 1.3059420000000002, 11.6565], [4.463442000000001, 3.1575, 10.8435], [1.8515580000000003, 3.1575, 10.8435], [3.1575, 1.8515580000000003, 4.1565], [3.1575, 4.463442000000001, 4.1565], [1.9368105, 0.0, 5.8755], [4.3781895, 0.0, 5.8755], [0.0, 4.3781895, 9.124500000000001], [0.0, 1.9368105, 9.124500000000001], [5.0943105, 3.1575, 13.375499999999999], [1.2206895000000002, 3.1575, 13.375499999999999], [3.1575, 1.2206895000000002, 1.6245], [3.1575, 5.0943105, 1.6245]],
                "lattice_vectors": [[6.315, 0.0, 0.0], [0.0, 6.315, 0.0], [0.0, 0.0, 15.0]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}, "f": {"X_1": 2}, "i": {"X_0": 8}}
            }
        ],
        120: [
            {
                "Notes": "KAu<sub>4</sub>Sn<sub>2</sub> Structure",
                "Pearsons Symbol": "tI28",
                "Prototype": "Au4KSn2",
                "Space Group Number": 120,
                "Space Group Symbol": "$I\\bar{4}c2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4BC2_tI28_120_i_d_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4BC2_tI28_120_i_d_e.html",
                "atom_labels": ["K", "K", "K", "K", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Sn", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au", "Au"],
                "atom_positions": [[0.0, 4.42352942405, 0.0], [4.42352942405, 0.0, 4.08902719905], [0.0, 4.42352942405, 4.08902719905], [4.42352942405, 0.0, 0.0], [7.5730823739736, 7.5730823739736, 2.044513599525], [1.2739764741264001, 1.2739764741264001, 2.044513599525], [1.2739764741264001, 7.5730823739736, 6.133540798575], [7.5730823739736, 1.2739764741264001, 6.133540798575], [3.149552949923599, 3.149552949923599, 6.133540798575], [5.6975058981763995, 5.6975058981763995, 6.133540798575], [5.6975058981763995, 3.149552949923599, 2.044513599525], [3.149552949923599, 5.6975058981763995, 2.044513599525], [5.70812236879412, 5.81694119262575, 0.69595242927831], [3.13893647930588, 3.03011765547425, 0.69595242927831], [3.03011765547425, 3.13893647930588, 3.3930747697716903], [5.81694119262575, 5.70812236879412, 3.3930747697716903], [3.13893647930588, 5.81694119262575, 4.78497962832831], [5.70812236879412, 3.03011765547425, 4.78497962832831], [5.81694119262575, 3.13893647930588, 7.4821019688216905], [3.03011765547425, 5.70812236879412, 7.4821019688216905], [1.28459294474412, 1.3934117685757497, 4.78497962832831], [7.562465903355879, 7.4536470795242495, 4.78497962832831], [7.4536470795242495, 7.562465903355879, 7.4821019688216905], [1.3934117685757497, 1.28459294474412, 7.4821019688216905], [7.562465903355879, 1.3934117685757497, 0.69595242927831], [1.28459294474412, 7.4536470795242495, 0.69595242927831], [1.3934117685757497, 7.562465903355879, 3.3930747697716903], [7.4536470795242495, 1.28459294474412, 3.3930747697716903]],
                "lattice_vectors": [[8.8470588481, 0.0, 0.0], [0.0, 8.8470588481, 0.0], [0.0, 0.0, 8.1780543981]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "h": {"X_1": 2}, "i": {"X_0": 4}}
            }
        ],
        121: [
            {
                "Notes": "Stannite (Cu<sub>2</sub>FeS<sub>4</sub>Sn, H2<sub>6</sub>) Structure",
                "Pearsons Symbol": "tI16",
                "Prototype": "Cu2FeS4Sn",
                "Space Group Number": 121,
                "Space Group Symbol": "$I\\bar{4}2m$",
                "Strukturbericht Designation": "$H2_{6}$",
                "aflow_prototype_id": "A2BC4D_tI16_121_d_a_i_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC4D_tI16_121_d_a_i_b.html",
                "atom_labels": ["Fe", "Fe", "Sn", "Sn", "Cu", "Cu", "Cu", "Cu", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.73, 2.73, 5.3625], [0.0, 0.0, 5.3625], [2.73, 2.73, 0.0], [0.0, 2.73, 2.68125], [0.0, 2.73, 8.04375], [2.73, 0.0, 2.68125], [2.73, 0.0, 8.04375], [1.3377, 1.3377, 1.4157], [1.3377, 4.1223, 9.3093], [4.1223, 1.3377, 9.3093], [4.1223, 4.1223, 1.4157], [4.0677, 4.0677, 6.7782], [4.0677, 1.3923, 3.9467999999999996], [1.3923, 4.0677, 3.9467999999999996], [1.3923, 1.3923, 6.7782]],
                "lattice_vectors": [[5.46, 0.0, 0.0], [0.0, 5.46, 0.0], [0.0, 0.0, 10.725]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "b": {"X_3": 1}, "d": {"X_1": 2}, "i": {"X_0": 4}}
            }
        ],
        122: [
            {
                "Notes": "Chalcopyrite (CuFeS<sub>2</sub>, E1<sub>1</sub>) Structure",
                "Pearsons Symbol": "tI16",
                "Prototype": "CuFeS2",
                "Space Group Number": 122,
                "Space Group Symbol": "$I\\bar{4}2d$",
                "Strukturbericht Designation": "$E1_{1}$",
                "aflow_prototype_id": "ABC2_tI16_122_a_b_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC2_tI16_122_a_b_d.html",
                "atom_labels": ["Cu", "Cu", "Cu", "Cu", "Fe", "Fe", "Fe", "Fe", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 2.6445, 2.60575], [2.6445, 2.6445, 5.2115], [2.6445, 0.0, 7.81725], [0.0, 0.0, 5.2115], [0.0, 2.6445, 7.81725], [2.6445, 2.6445, 0.0], [2.6445, 0.0, 2.60575], [1.3613886, 1.32225, 1.302875], [3.9276113999999995, 3.9667499999999998, 1.302875], [1.32225, 4.0058886000000005, 3.908625], [1.32225, 3.9276113999999995, 9.120125], [3.9667499999999998, 1.3613886, 9.120125], [3.9667499999999998, 1.2831114, 3.908625], [4.0058886000000005, 3.9667499999999998, 6.514375], [1.2831114, 1.32225, 6.514375]],
                "lattice_vectors": [[5.289, 0.0, 0.0], [0.0, 5.289, 0.0], [0.0, 0.0, 10.423]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "d": {"X_0": 2}}
            }
        ],
        123: [
            {
                "Notes": "CuTi<sub>3</sub> (L6<sub>0</sub>) Structure",
                "Pearsons Symbol": "tP4",
                "Prototype": "CuTi3",
                "Space Group Number": 123,
                "Space Group Symbol": "$P4/mmm$",
                "Strukturbericht Designation": "$L6_{0}$",
                "aflow_prototype_id": "AB3_tP4_123_a_ce",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_tP4_123_a_ce.html",
                "atom_labels": ["Cu", "Ti", "Ti", "Ti"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.079, 2.079, 0.0], [0.0, 2.079, 1.797], [2.079, 0.0, 1.797]],
                "lattice_vectors": [[4.158, 0.0, 0.0], [0.0, 4.158, 0.0], [0.0, 0.0, 3.594]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_1": 1}, "e": {"X_0": 2}}
            },
            {
                "Notes": "CuAu (L1<sub>0</sub>) Structure",
                "Pearsons Symbol": "tP2",
                "Prototype": "AuCu",
                "Space Group Number": 123,
                "Space Group Symbol": "$P4/mmm$",
                "Strukturbericht Designation": "$L1_{0}$",
                "aflow_prototype_id": "AB_tP2_123_a_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tP2_123_a_d.html",
                "atom_labels": ["Au", "Cu"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.4, 1.4, 1.835]],
                "lattice_vectors": [[2.8, 0.0, 0.0], [0.0, 2.8, 0.0], [0.0, 0.0, 3.67]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "d": {"X_1": 1}}
            },
            {
                "Notes": "HoCoGa<sub>5</sub> Structure",
                "Pearsons Symbol": "tP7",
                "Prototype": "CoGa5Ho",
                "Space Group Number": 123,
                "Space Group Symbol": "$P4/mmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB5C_tP7_123_b_ci_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB5C_tP7_123_b_ci_a.html",
                "atom_labels": ["Ho", "Co", "Ga", "Ga", "Ga", "Ga", "Ga"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.3975], [2.1035, 2.1035, 0.0], [0.0, 2.1035, 2.12004], [0.0, 2.1035, 4.67496], [2.1035, 0.0, 4.67496], [2.1035, 0.0, 2.12004]],
                "lattice_vectors": [[4.207, 0.0, 0.0], [0.0, 4.207, 0.0], [0.0, 0.0, 6.795]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "d": {"X_0": 1}, "i": {"X_0": 4}}
            },
            {
                "Notes": "CaCuO<sub>2</sub> Structure",
                "Pearsons Symbol": "tP4",
                "Prototype": "CaCuO2",
                "Space Group Number": 123,
                "Space Group Symbol": "$P4/mmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC2_tP4_123_d_a_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC2_tP4_123_d_a_f.html",
                "atom_labels": ["Cu", "Ca", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.93055, 1.93055, 1.59975], [0.0, 1.93055, 0.0], [1.93055, 0.0, 0.0]],
                "lattice_vectors": [[3.8611, 0.0, 0.0], [0.0, 3.8611, 0.0], [0.0, 0.0, 3.1995]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_2": 1}, "e": {"X_0": 2}}
            },
            {
                "Notes": "CaRbFe<sub>4</sub>As<sub>4</sub> (Superconducting) Structure",
                "Pearsons Symbol": "tP10",
                "Prototype": "As4CaFe4Rb",
                "Space Group Number": 123,
                "Space Group Symbol": "$P4/mmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4BC4D_tP10_123_gh_a_i_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4BC4D_tP10_123_gh_a_i_d.html",
                "atom_labels": ["Ca", "Rb", "As", "As", "As", "As", "Fe", "Fe", "Fe", "Fe"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.93785, 1.93785, 6.552], [0.0, 0.0, 4.3714944], [0.0, 0.0, 8.7325056], [1.93785, 1.93785, 1.5633072], [1.93785, 1.93785, 11.5406928], [0.0, 1.93785, 2.9431583999999997], [0.0, 1.93785, 10.1608416], [1.93785, 0.0, 10.1608416], [1.93785, 0.0, 2.9431583999999997]],
                "lattice_vectors": [[3.8757, 0.0, 0.0], [0.0, 3.8757, 0.0], [0.0, 0.0, 13.104]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "d": {"X_3": 1}, "g": {"X_0": 2}, "h": {"X_0": 2}, "i": {"X_1": 4}}
            }
        ],
        124: [
            {
                "Notes": "Nb<sub>4</sub>CoSi Structure",
                "Pearsons Symbol": "tP12",
                "Prototype": "CoNb4Si",
                "Space Group Number": 124,
                "Space Group Symbol": "$P4/mcc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB4C_tP12_124_a_m_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4C_tP12_124_a_m_c.html",
                "atom_labels": ["Co", "Co", "Si", "Si", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb"],
                "atom_positions": [[0.0, 0.0, 1.263144034875], [0.0, 0.0, 3.789432104625], [3.09424042425, 3.09424042425, 1.263144034875], [3.09424042425, 3.09424042425, 3.789432104625], [1.0025338974570002, 4.0967743217070005, 0.0], [1.0025338974570002, 2.0917065267929997, 2.52628806975], [5.185946951043, 4.0967743217070005, 2.52628806975], [5.185946951043, 2.0917065267929997, 0.0], [2.0917065267929997, 5.185946951043, 2.52628806975], [2.0917065267929997, 1.0025338974570002, 0.0], [4.0967743217070005, 5.185946951043, 0.0], [4.0967743217070005, 1.0025338974570002, 2.52628806975]],
                "lattice_vectors": [[6.1884808485, 0.0, 0.0], [0.0, 6.1884808485, 0.0], [0.0, 0.0, 5.0525761395]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_2": 1}, "m": {"X_0": 4}}
            },
            {
                "Notes": "NbTe<sub>4</sub> Structure",
                "Pearsons Symbol": "tP10",
                "Prototype": "NbTe4",
                "Space Group Number": 124,
                "Space Group Symbol": "$P4/mcc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB4_tP10_124_a_m",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4_tP10_124_a_m.html",
                "atom_labels": ["Nb", "Nb", "Te", "Te", "Te", "Te", "Te", "Te", "Te", "Te"],
                "atom_positions": [[0.0, 0.0, 1.70924136645], [0.0, 0.0, 5.12772409935], [0.9261028221667499, 2.1843028668789097, 0.0], [0.9261028221667499, 4.314664306221089, 3.4184827329], [5.57286435093325, 2.1843028668789097, 3.4184827329], [5.57286435093325, 4.314664306221089, 0.0], [4.314664306221089, 5.57286435093325, 3.4184827329], [4.314664306221089, 0.9261028221667499, 0.0], [2.1843028668789097, 5.57286435093325, 0.0], [2.1843028668789097, 0.9261028221667499, 3.4184827329]],
                "lattice_vectors": [[6.4989671731, 0.0, 0.0], [0.0, 6.4989671731, 0.0], [0.0, 0.0, 6.8369654658]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "m": {"X_0": 4}}
            }
        ],
        125: [
            {
                "Notes": "PtPb<sub>4</sub> Structure",
                "Pearsons Symbol": "tP10",
                "Prototype": "Pb4Pt",
                "Space Group Number": 125,
                "Space Group Symbol": "$P4/nbm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B_tP10_125_m_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B_tP10_125_m_a.html",
                "atom_labels": ["Pt", "Pt", "Pb", "Pb", "Pb", "Pb", "Pb", "Pb", "Pb", "Pb"],
                "atom_positions": [[1.659968651225, 1.659968651225, 0.0], [4.979905953675, 4.979905953675, 0.0], [2.8219467070825, 3.8179278978175, 1.5223212507135], [2.8219467070825, 6.1418840095325, 4.4475660069864995], [0.49799059536750007, 3.8179278978175, 4.4475660069864995], [0.49799059536750007, 6.1418840095325, 1.5223212507135], [6.1418840095325, 0.49799059536750007, 4.4475660069864995], [6.1418840095325, 2.8219467070825, 1.5223212507135], [3.8179278978175, 0.49799059536750007, 1.5223212507135], [3.8179278978175, 2.8219467070825, 4.4475660069864995]],
                "lattice_vectors": [[6.6398746049, 0.0, 0.0], [0.0, 6.6398746049, 0.0], [0.0, 0.0, 5.9698872577]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "m": {"X_0": 4}}
            },
            {
                "Notes": "KCeSe<sub>4</sub> Structure",
                "Pearsons Symbol": "tP12",
                "Prototype": "CeKSe4",
                "Space Group Number": 125,
                "Space Group Symbol": "$P4/nbm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC4_tP12_125_a_b_m",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC4_tP12_125_a_b_m.html",
                "atom_labels": ["Ce", "Ce", "K", "K", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se"],
                "atom_positions": [[1.5939969107, 1.5939969107, 0.0], [4.781990732100001, 4.781990732100001, 0.0], [1.5939969107, 1.5939969107, 4.1644919289], [4.781990732100001, 4.781990732100001, 4.1644919289], [2.43690247707816, 3.93908516572184, 1.8015592084421401], [2.43690247707816, 5.62489629847816, 6.527424649357862], [0.7510913443218401, 3.93908516572184, 6.527424649357862], [0.7510913443218401, 5.62489629847816, 1.8015592084421401], [5.62489629847816, 0.7510913443218401, 6.527424649357862], [5.62489629847816, 2.43690247707816, 1.8015592084421401], [3.93908516572184, 0.7510913443218401, 1.8015592084421401], [3.93908516572184, 2.43690247707816, 6.527424649357862]],
                "lattice_vectors": [[6.3759876428, 0.0, 0.0], [0.0, 6.3759876428, 0.0], [0.0, 0.0, 8.3289838578]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "m": {"X_0": 4}}
            }
        ],
        126: [
            {
                "Notes": "BiAl<sub>2</sub>S<sub>4</sub> Structure",
                "Pearsons Symbol": "tP28",
                "Prototype": "Al2BiS4",
                "Space Group Number": 126,
                "Space Group Symbol": "$P4/nnc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BC4_tP28_126_cd_e_k",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC4_tP28_126_cd_e_k.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Bi", "Bi", "Bi", "Bi", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[1.873006036975, 5.6190181109249995, 8.912278725524999], [5.6190181109249995, 1.873006036975, 8.912278725524999], [5.6190181109249995, 1.873006036975, 2.970759575175], [1.873006036975, 5.6190181109249995, 2.970759575175], [1.873006036975, 5.6190181109249995, 0.0], [1.873006036975, 5.6190181109249995, 5.94151915035], [5.6190181109249995, 1.873006036975, 5.94151915035], [5.6190181109249995, 1.873006036975, 0.0], [1.873006036975, 1.873006036975, 1.403149162546656], [1.873006036975, 1.873006036975, 4.538369987803343], [5.6190181109249995, 5.6190181109249995, 10.479889138153343], [5.6190181109249995, 5.6190181109249995, 7.344668312896655], [0.6480600887933499, 4.43827510521596, 1.49013300290778], [0.6480600887933499, 6.7997611166340395, 4.45138614744222], [3.0979519851566497, 4.43827510521596, 4.45138614744222], [3.0979519851566497, 6.7997611166340395, 1.49013300290778], [6.7997611166340395, 3.0979519851566497, 4.45138614744222], [6.7997611166340395, 0.6480600887933499, 1.49013300290778], [4.43827510521596, 3.0979519851566497, 1.49013300290778], [4.43827510521596, 0.6480600887933499, 4.45138614744222], [6.843964059106649, 3.0537490426840397, 10.39290529779222], [6.843964059106649, 0.6922630312659602, 7.431652153257779], [4.39407216274335, 3.0537490426840397, 7.431652153257779], [4.39407216274335, 0.6922630312659602, 10.39290529779222], [0.6922630312659602, 4.39407216274335, 7.431652153257779], [0.6922630312659602, 6.843964059106649, 10.39290529779222], [3.0537490426840397, 4.39407216274335, 10.39290529779222], [3.0537490426840397, 6.843964059106649, 7.431652153257779]],
                "lattice_vectors": [[7.4920241479, 0.0, 0.0], [0.0, 7.4920241479, 0.0], [0.0, 0.0, 11.8830383007]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "d": {"X_1": 1}, "e": {"X_2": 1}, "k": {"X_0": 4}}
            }
        ],
        127: [
            {
                "Notes": "Si<sub>2</sub>U<sub>3</sub> (D5<sub>a</sub>) Structure",
                "Pearsons Symbol": "tP10",
                "Prototype": "Si2U3",
                "Space Group Number": 127,
                "Space Group Symbol": "$P4/mbm$",
                "Strukturbericht Designation": "$D5_{a}$",
                "aflow_prototype_id": "A2B3_tP10_127_g_ah",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_tP10_127_g_ah.html",
                "atom_labels": ["U", "U", "Si", "Si", "Si", "Si", "U", "U", "U", "U"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.6682, 3.6682, 0.0], [2.81791124, 6.4861112400000005, 0.0], [6.4861112400000005, 4.51848876, 0.0], [0.8502887600000001, 2.817911240000001, 0.0], [4.51848876, 0.8502887600000001, 0.0], [1.3359584400000002, 5.00415844, 1.945], [5.00415844, 6.00044156, 1.945], [2.33224156, 1.335958440000001, 1.945], [6.00044156, 2.33224156, 1.945]],
                "lattice_vectors": [[7.3364, 0.0, 0.0], [0.0, 7.3364, 0.0], [0.0, 0.0, 3.89]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "g": {"X_1": 2}, "h": {"X_0": 2}}
            },
            {
                "Notes": "ThB<sub>4</sub> ($D1_{e}$) Structure",
                "Pearsons Symbol": "tP20",
                "Prototype": "B4Th",
                "Space Group Number": 127,
                "Space Group Symbol": "$P4/mbm$",
                "Strukturbericht Designation": "$D1_{e}$",
                "aflow_prototype_id": "A4B_tP20_127_ehj_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B_tP20_127_ehj_g.html",
                "atom_labels": ["B", "B", "B", "B", "Th", "Th", "Th", "Th", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B"],
                "atom_positions": [[0.0, 0.0, 0.8226000000000001], [3.628, 3.628, 3.2904000000000004], [0.0, 0.0, 3.2904000000000004], [3.628, 3.628, 0.8226000000000001], [2.2493600000000002, 5.87736, 0.0], [5.87736, 5.00664, 0.0], [1.37864, 2.2493600000000002, 0.0], [5.00664, 1.3786399999999996, 0.0], [0.7256, 4.3536, 2.0565], [4.3536, 6.5304, 2.0565], [2.9024, 0.7256000000000007, 2.0565], [6.5304, 2.9024, 2.0565], [1.4512, 0.29024, 2.0565], [5.0792, 3.3377600000000003, 2.0565], [2.1768, 3.9182400000000004, 2.0565], [5.8048, 6.96576, 2.0565], [3.3377600000000003, 2.1768, 2.0565], [6.96576, 1.4512, 2.0565], [0.29024, 5.8048, 2.0565], [3.9182400000000004, 5.0792, 2.0565]],
                "lattice_vectors": [[7.256, 0.0, 0.0], [0.0, 7.256, 0.0], [0.0, 0.0, 4.113]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1}, "g": {"X_0": 1}, "h": {"X_1": 1}, "i": {"X_0": 2}}
            }
        ],
        128: [
            {
                "Notes": "K<sub>2</sub>SnCl<sub>6</sub> (Low&ndash;temperature) Structure",
                "Pearsons Symbol": "tP18",
                "Prototype": "Cl6K2Sn",
                "Space Group Number": 128,
                "Space Group Symbol": "$P4/mnc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A6B2C_tP18_128_eh_d_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A6B2C_tP18_128_eh_d_a.html",
                "atom_labels": ["Sn", "Sn", "K", "K", "K", "K", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.5287662855, 3.5287662855, 4.98908164175], [0.0, 3.5287662855, 2.494540820875], [3.5287662855, 0.0, 2.494540820875], [0.0, 3.5287662855, 7.483622462625], [3.5287662855, 0.0, 7.483622462625], [0.0, 0.0, 2.5174905964270504], [3.5287662855, 3.5287662855, 2.47159104532295], [0.0, 0.0, 7.460672687072951], [3.5287662855, 3.5287662855, 7.50657223817705], [1.5646549709907, 1.7721464285781, 0.0], [5.0934212564907, 1.7566198569219003, 4.98908164175], [1.9641113145093, 5.3009127140781, 4.98908164175], [5.4928776000093, 5.2853861424219, 0.0], [1.7566198569219003, 1.9641113145093, 4.98908164175], [5.2853861424219, 1.5646549709907, 0.0], [1.7721464285781, 5.4928776000093, 0.0], [5.3009127140781, 5.0934212564907, 4.98908164175]],
                "lattice_vectors": [[7.057532571, 0.0, 0.0], [0.0, 7.057532571, 0.0], [0.0, 0.0, 9.9781632835]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "d": {"X_1": 2}, "e": {"X_0": 2}, "h": {"X_0": 4}}
            },
            {
                "Notes": "FeCu<sub>2</sub>Al<sub>7</sub> ($E9_{a}$) Structure",
                "Pearsons Symbol": "tP40",
                "Prototype": "Al7Cu2Fe",
                "Space Group Number": 128,
                "Space Group Symbol": "$P4/mnc$",
                "Strukturbericht Designation": "$E9_{a}$",
                "aflow_prototype_id": "A7B2C_tP40_128_egi_h_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A7B2C_tP40_128_egi_h_e.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Fe", "Fe", "Fe", "Fe", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al"],
                "atom_positions": [[0.0, 0.0, 5.442419999999999], [3.168, 3.168, 1.99258], [0.0, 0.0, 9.427579999999999], [3.168, 3.168, 12.877419999999999], [0.0, 0.0, 2.985896], [3.168, 3.168, 4.449104], [0.0, 0.0, 11.884103999999999], [3.168, 3.168, 10.420895999999999], [1.0454400000000001, 4.21344, 3.7175], [4.21344, 5.29056, 3.7175], [2.12256, 1.0454400000000004, 3.7175], [5.29056, 2.12256, 3.7175], [5.29056, 2.12256, 11.1525], [2.12256, 1.0454400000000004, 11.1525], [4.21344, 5.29056, 11.1525], [1.0454400000000001, 4.21344, 11.1525], [1.7614080000000003, 0.557568, 0.0], [4.9294080000000005, 2.6104320000000003, 7.435], [1.4065919999999998, 3.725568, 7.435], [4.574592, 5.7784320000000005, 0.0], [2.6104320000000003, 1.4065919999999998, 7.435], [5.7784320000000005, 1.7614080000000003, 0.0], [0.557568, 4.574592, 0.0], [3.725568, 4.9294080000000005, 7.435], [1.254528, 2.66112, 1.487], [4.422528, 0.5068800000000001, 5.948], [1.913472, 5.82912, 5.948], [5.081472000000001, 3.674880000000001, 1.487], [0.5068800000000001, 1.913472, 5.948], [3.674880000000001, 1.254528, 1.487], [2.66112, 5.081472000000001, 1.487], [5.82912, 4.422528, 5.948], [5.081472000000001, 3.674880000000001, 13.383], [1.913472, 5.82912, 8.921999999999999], [4.422528, 0.5068800000000001, 8.921999999999999], [1.254528, 2.66112, 13.383], [5.82912, 4.422528, 8.921999999999999], [2.66112, 5.081472000000001, 13.383], [3.674880000000001, 1.254528, 13.383], [0.5068800000000001, 1.913472, 8.921999999999999]],
                "lattice_vectors": [[6.336, 0.0, 0.0], [0.0, 6.336, 0.0], [0.0, 0.0, 14.87]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1, "X_2": 1}, "g": {"X_0": 2}, "h": {"X_1": 2}, "i": {"X_0": 4}}
            }
        ],
        129: [
            {
                "Notes": "PbO (B10) Structure",
                "Pearsons Symbol": "tP4",
                "Prototype": "OPb",
                "Space Group Number": 129,
                "Space Group Symbol": "$P4/nmm$",
                "Strukturbericht Designation": "$B10$",
                "aflow_prototype_id": "AB_tP4_129_a_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tP4_129_a_c.html",
                "atom_labels": ["O", "O", "Pb", "Pb"],
                "atom_positions": [[2.973375, 0.991125, 0.0], [0.991125, 2.973375, 0.0], [0.991125, 0.991125, 1.18295808], [2.973375, 2.973375, 3.8126419199999995]],
                "lattice_vectors": [[3.9645, 0.0, 0.0], [0.0, 3.9645, 0.0], [0.0, 0.0, 4.9956]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_1": 1}}
            },
            {
                "Notes": "AsCuSiZr Structure",
                "Pearsons Symbol": "tP8",
                "Prototype": "AsCuSiZr",
                "Space Group Number": 129,
                "Space Group Symbol": "$P4/nmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABCD_tP8_129_c_b_a_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABCD_tP8_129_c_b_a_c.html",
                "atom_labels": ["Si", "Si", "Cu", "Cu", "As", "As", "Zr", "Zr"],
                "atom_positions": [[2.7552, 0.9184, 0.0], [0.9184, 2.7552, 0.0], [2.7552, 0.9184, 4.7856], [0.9184, 2.7552, 4.7856], [0.9184, 0.9184, 6.50171616], [2.7552, 2.7552, 3.0694838399999997], [0.9184, 0.9184, 2.1496915199999997], [2.7552, 2.7552, 7.421508479999999]],
                "lattice_vectors": [[3.6736, 0.0, 0.0], [0.0, 3.6736, 0.0], [0.0, 0.0, 9.5712]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}, "c": {"X_2": 1, "X_3": 1}}
            },
            {
                "Notes": "$\\gamma$&ndash;CuTi (B11) Structure",
                "Pearsons Symbol": "tP4",
                "Prototype": "CuTi",
                "Space Group Number": 129,
                "Space Group Symbol": "$P4/nmm$",
                "Strukturbericht Designation": "$B11$",
                "aflow_prototype_id": "AB_tP4_129_c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tP4_129_c_c.html",
                "atom_labels": ["Cu", "Cu", "Ti", "Ti"],
                "atom_positions": [[0.77675, 0.77675, 0.5919], [2.3302500000000004, 2.3302500000000004, 5.3271], [0.77675, 0.77675, 3.84735], [2.3302500000000004, 2.3302500000000004, 2.0716499999999995]],
                "lattice_vectors": [[3.107, 0.0, 0.0], [0.0, 3.107, 0.0], [0.0, 0.0, 5.919]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "$\\beta$&ndash;Np (A<sub>d</sub>) Structure",
                "Pearsons Symbol": "tP4",
                "Prototype": "Np",
                "Space Group Number": 129,
                "Space Group Symbol": "$P4/nmm$",
                "Strukturbericht Designation": "$A_{d}$",
                "aflow_prototype_id": "A_tP4_129_ac",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tP4_129_ac.html",
                "atom_labels": ["Np", "Np", "Np", "Np"],
                "atom_positions": [[3.67275, 1.22425, 0.0], [1.22425, 3.67275, 0.0], [1.22425, 1.22425, 1.2705], [3.67275, 3.67275, 2.1174999999999997]],
                "lattice_vectors": [[4.897, 0.0, 0.0], [0.0, 4.897, 0.0], [0.0, 0.0, 3.388]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_0": 1}}
            },
            {
                "Notes": "Cu<sub>2</sub>Sb (C38) Structure",
                "Pearsons Symbol": "tP6",
                "Prototype": "Cu2Sb",
                "Space Group Number": 129,
                "Space Group Symbol": "$P4/nmm$",
                "Strukturbericht Designation": "$C38$",
                "aflow_prototype_id": "A2B_tP6_129_ac_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tP6_129_ac_c.html",
                "atom_labels": ["Cu", "Cu", "Cu", "Cu", "Sb", "Sb"],
                "atom_positions": [[3.0004500000000003, 1.00015, 0.0], [1.00015, 3.0004500000000003, 0.0], [1.00015, 1.00015, 1.6481610000000002], [3.0004500000000003, 3.0004500000000003, 4.456139], [1.00015, 1.00015, 4.27301], [3.0004500000000003, 3.0004500000000003, 1.8312900000000003]],
                "lattice_vectors": [[4.0006, 0.0, 0.0], [0.0, 4.0006, 0.0], [0.0, 0.0, 6.1043]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "Matlockite (E0<sub>1</sub>, PbFCl) Structure",
                "Pearsons Symbol": "tP6",
                "Prototype": "ClFPb",
                "Space Group Number": 129,
                "Space Group Symbol": "$P4/nmm$",
                "Strukturbericht Designation": "$E0_{1}$",
                "aflow_prototype_id": "ABC_tP6_129_c_a_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_tP6_129_c_a_c.html",
                "atom_labels": ["F", "F", "Cl", "Cl", "Pb", "Pb"],
                "atom_positions": [[3.0825000000000005, 1.0275, 0.0], [1.0275, 3.0825000000000005, 0.0], [1.0275, 1.0275, 4.707726200000001], [3.0825000000000005, 3.0825000000000005, 2.5382738], [1.0275, 1.0275, 1.4912268000000002], [3.0825000000000005, 3.0825000000000005, 5.754773200000001]],
                "lattice_vectors": [[4.11, 0.0, 0.0], [0.0, 4.11, 0.0], [0.0, 0.0, 7.246]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_1": 1, "X_2": 1}}
            }
        ],
        130: [
            {
                "Notes": "CuBi<sub>2</sub>O<sub>4</sub> Structure",
                "Pearsons Symbol": "tP28",
                "Prototype": "Bi2CuO4",
                "Space Group Number": 130,
                "Space Group Symbol": "$P4/ncc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BC4_tP28_130_f_c_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BC4_tP28_130_f_c_g.html",
                "atom_labels": ["Cu", "Cu", "Cu", "Cu", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[2.127583433575, 2.127583433575, 3.3722522434799993], [6.382750300725, 6.382750300725, 5.34908976552], [6.382750300725, 6.382750300725, 2.4419757625200003], [2.127583433575, 2.127583433575, 0.46513824048000035], [4.94875906649545, 3.5615746678045497, 1.4535570015], [0.693592199345451, 4.94875906649545, 1.4535570015], [3.5615746678045497, 7.8167415349545495, 1.4535570015], [7.8167415349545495, 0.6935921993454501, 1.4535570015], [3.5615746678045497, 4.94875906649545, 4.3606710044999994], [7.8167415349545495, 3.5615746678045497, 4.3606710044999994], [4.94875906649545, 0.6935921993454501, 4.3606710044999994], [0.693592199345451, 7.8167415349545495, 4.3606710044999994], [0.38296501804349997, 1.1574053878648, 3.4710941195819998], [4.6381318851935, 7.3529283464352, 5.250247889418], [8.1273687162565, 5.412572255014799, 5.250247889418], [3.8722018491065, 3.0977614792851997, 3.4710941195819998], [7.3529283464352, 8.1273687162565, 5.250247889418], [3.0977614792851997, 0.38296501804349997, 3.4710941195819998], [1.1574053878648, 3.8722018491065, 3.4710941195819998], [5.412572255014799, 4.6381318851935, 5.250247889418], [8.1273687162565, 7.3529283464352, 2.343133886418], [3.8722018491065, 1.1574053878648, 0.5639801165819998], [0.38296501804349997, 3.0977614792851997, 0.5639801165819998], [4.6381318851935, 5.412572255014799, 2.343133886418], [1.1574053878648, 0.38296501804349997, 0.5639801165819998], [5.412572255014799, 8.1273687162565, 2.343133886418], [7.3529283464352, 4.6381318851935, 2.343133886418], [3.0977614792851997, 3.8722018491065, 0.5639801165819998]],
                "lattice_vectors": [[8.5103337343, 0.0, 0.0], [0.0, 8.5103337343, 0.0], [0.0, 0.0, 5.814228006]],
                "normalized_wyckoff_matid": {"c": {"X_2": 1}, "f": {"X_1": 2}, "g": {"X_0": 4}}
            },
            {
                "Notes": "Ba<sub>5</sub>Si<sub>3</sub> Structure",
                "Pearsons Symbol": "tP32",
                "Prototype": "BaSi",
                "Space Group Number": 130,
                "Space Group Symbol": "$P4/ncc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A5B3_tP32_130_cg_cf",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B3_tP32_130_cg_cf.html",
                "atom_labels": ["Ba", "Ba", "Ba", "Ba", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba", "Ba"],
                "atom_positions": [[2.11625, 2.11625, 3.735795], [6.34875, 6.34875, 4.489205], [6.34875, 6.34875, 12.714205], [2.11625, 2.11625, 11.960795], [2.11625, 2.11625, 0.156275], [6.34875, 6.34875, 8.068724999999999], [6.34875, 6.34875, 16.293725], [2.11625, 2.11625, 8.381274999999999], [1.254513, 7.210487, 4.1125], [5.487013, 1.254513, 4.1125], [7.210487, 2.977986999999999, 4.1125], [2.977987, 5.487013, 4.1125], [7.210487, 1.254513, 12.337499999999999], [2.977987, 7.210487, 12.337499999999999], [1.254513, 5.487013, 12.337499999999999], [5.487013, 2.977986999999999, 12.337499999999999], [4.90944605, 0.67694605, 1.758176], [0.676946049999999, 7.78805395, 6.466824], [3.55555395, 4.90944605, 6.466824], [7.78805395, 3.55555395, 1.758176], [7.78805395, 3.55555395, 6.466824], [3.55555395, 4.90944605, 1.758176], [0.67694605, 7.78805395, 1.758176], [4.90944605, 0.676946049999999, 6.466824], [3.55555395, 7.78805395, 14.691824], [7.78805395, 0.67694605, 9.983175999999998], [4.90944605, 3.55555395, 9.983175999999998], [0.676946049999999, 4.90944605, 14.691824], [0.67694605, 4.90944605, 9.983175999999998], [4.90944605, 3.55555395, 14.691824], [7.78805395, 0.676946049999999, 14.691824], [3.55555395, 7.78805395, 9.983175999999998]],
                "lattice_vectors": [[8.465, 0.0, 0.0], [0.0, 8.465, 0.0], [0.0, 0.0, 16.45]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}, "f": {"X_1": 2}, "g": {"X_0": 4}}
            }
        ],
        131: [
            {
                "Notes": "Cooperite (PtS, $B17$) Structure",
                "Pearsons Symbol": "tP4",
                "Prototype": "PtS",
                "Space Group Number": 131,
                "Space Group Symbol": "$P4_{2}/mmc$",
                "Strukturbericht Designation": "$B17$",
                "aflow_prototype_id": "AB_tP4_131_c_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tP4_131_c_e.html",
                "atom_labels": ["Pt", "Pt", "S", "S"],
                "atom_positions": [[0.0, 2.45365, 0.0], [2.45365, 0.0, 3.0548], [0.0, 0.0, 1.5274], [0.0, 0.0, 4.5822]],
                "lattice_vectors": [[4.9073, 0.0, 0.0], [0.0, 4.9073, 0.0], [0.0, 0.0, 6.1096]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "e": {"X_1": 1}}
            }
        ],
        132: [
            {
                "Notes": "AgUF<sub>6</sub> Structure",
                "Pearsons Symbol": "tP16",
                "Prototype": "AgF6U",
                "Space Group Number": 132,
                "Space Group Symbol": "$P4_{2}/mcm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB6C_tP16_132_d_io_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB6C_tP16_132_d_io_a.html",
                "atom_labels": ["U", "U", "Ag", "Ag", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.97499441465], [2.71149619005, 2.71149619005, 1.987497207325], [2.71149619005, 2.71149619005, 5.9624916219749995], [1.62689771403, 1.62689771403, 0.0], [1.62689771403, 3.7960946660699997, 3.97499441465], [3.7960946660699997, 1.62689771403, 3.97499441465], [3.7960946660699997, 3.7960946660699997, 0.0], [1.08459847602, 1.08459847602, 2.6473462801569], [1.08459847602, 4.33839390408, 1.3276481344930997], [4.33839390408, 1.08459847602, 1.3276481344930997], [4.33839390408, 4.33839390408, 2.6473462801569], [4.33839390408, 4.33839390408, 5.3026425491431], [4.33839390408, 1.08459847602, 6.6223406948068995], [1.08459847602, 4.33839390408, 6.6223406948068995], [1.08459847602, 1.08459847602, 5.3026425491431]],
                "lattice_vectors": [[5.4229923801, 0.0, 0.0], [0.0, 5.4229923801, 0.0], [0.0, 0.0, 7.9499888293]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_2": 1}, "i": {"X_0": 2}, "o": {"X_0": 4}}
            },
            {
                "Notes": "Rb<sub>2</sub>TiCu<sub>2</sub>S<sub>4</sub> Structure",
                "Pearsons Symbol": "tP18",
                "Prototype": "Cu2Rb2Se4Ti",
                "Space Group Number": 132,
                "Space Group Symbol": "$P4_{2}/mcm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B2C4D_tP18_132_e_i_o_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B2C4D_tP18_132_e_i_o_d.html",
                "atom_labels": ["Ti", "Ti", "Cu", "Cu", "Cu", "Cu", "Rb", "Rb", "Rb", "Rb", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[2.8023, 2.8023, 3.2885], [2.8023, 2.8023, 9.8655], [0.0, 2.8023, 3.2885], [2.8023, 0.0, 9.8655], [0.0, 2.8023, 9.8655], [2.8023, 0.0, 3.2885], [1.3277297399999999, 1.3277297399999999, 0.0], [1.3277297399999999, 4.27687026, 6.577], [4.27687026, 1.3277297399999999, 6.577], [4.27687026, 4.27687026, 0.0], [1.474906536, 1.474906536, 4.57798662], [1.474906536, 4.129693463999999, 1.9990133799999998], [4.129693463999999, 1.474906536, 1.9990133799999998], [4.129693463999999, 4.129693463999999, 4.57798662], [4.129693463999999, 4.129693463999999, 8.57601338], [4.129693463999999, 1.474906536, 11.15498662], [1.474906536, 4.129693463999999, 11.15498662], [1.474906536, 1.474906536, 8.57601338]],
                "lattice_vectors": [[5.6046, 0.0, 0.0], [0.0, 5.6046, 0.0], [0.0, 0.0, 13.154]],
                "normalized_wyckoff_matid": {"b": {"X_3": 1}, "e": {"X_1": 2}, "i": {"X_2": 2}, "o": {"X_0": 4}}
            }
        ],
        133: [
            {
                "Notes": "$\\beta$&ndash;V<sub>3</sub>S Structure",
                "Pearsons Symbol": "tP32",
                "Prototype": "SV3",
                "Space Group Number": 133,
                "Space Group Symbol": "$P4_{2}/nbc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_tP32_133_h_i2j",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_tP32_133_h_i2j.html",
                "atom_labels": ["S", "S", "S", "S", "S", "S", "S", "S", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V", "V"],
                "atom_positions": [[9.07237438735143, 2.345252400825, 0.0], [4.999140017598571, 2.345252400825, 0.0], [2.345252400825, 4.999140017598571, 2.33150238675], [2.345252400825, 9.07237438735143, 2.33150238675], [0.30863521594857, 7.035757202475001, 0.0], [4.3818695857014305, 7.035757202475001, 0.0], [7.035757202475001, 4.3818695857014305, 2.33150238675], [7.035757202475001, 0.30863521594857, 2.33150238675], [8.42977522952538, 2.345252400825, 2.33150238675], [5.641739175424621, 2.345252400825, 2.33150238675], [2.345252400825, 5.641739175424621, 0.0], [2.345252400825, 8.42977522952538, 0.0], [0.9512343737746205, 7.035757202475001, 2.33150238675], [3.7392704278753808, 7.035757202475001, 2.33150238675], [7.035757202475001, 3.7392704278753808, 0.0], [7.035757202475001, 0.9512343737746205, 0.0], [6.172704318971401, 6.172704318971401, 1.165751193375], [6.172704318971401, 7.8988100859786, 3.497253580125], [7.8988100859786, 6.172704318971401, 3.497253580125], [7.8988100859786, 7.8988100859786, 1.165751193375], [3.2083052843286, 3.2083052843286, 3.497253580125], [3.2083052843286, 1.4821995173213993, 1.165751193375], [1.4821995173213993, 3.2083052843286, 1.165751193375], [1.4821995173213993, 1.4821995173213993, 3.497253580125], [0.44278365327576, 0.44278365327576, 1.165751193375], [0.44278365327576, 4.24772114837424, 3.497253580125], [4.24772114837424, 0.44278365327576, 3.497253580125], [4.24772114837424, 4.24772114837424, 1.165751193375], [8.93822595002424, 8.93822595002424, 3.497253580125], [8.93822595002424, 5.1332884549257605, 1.165751193375], [5.1332884549257605, 8.93822595002424, 1.165751193375], [5.1332884549257605, 5.1332884549257605, 3.497253580125]],
                "lattice_vectors": [[9.3810096033, 0.0, 0.0], [0.0, 9.3810096033, 0.0], [0.0, 0.0, 4.6630047735]],
                "normalized_wyckoff_matid": {"h": {"X_1": 1}, "i": {"X_0": 1}, "j": {"X_0": 2}}
            }
        ],
        134: [
            {
                "Notes": "T&ndash;50 B (A<sub>g</sub>) Structure",
                "Pearsons Symbol": "tP50",
                "Prototype": "B",
                "Space Group Number": 134,
                "Space Group Symbol": "$P4_{2}/nnm$",
                "Strukturbericht Designation": "$A_{g}$",
                "aflow_prototype_id": "A_tP50_134_b2m2n",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tP50_134_b2m2n.html",
                "atom_labels": ["B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B"],
                "atom_positions": [[6.555, 2.185, 1.2575], [2.185, 6.555, 3.7725], [0.041951999999999996, 8.698048, 0.8475550000000001], [0.041951999999999996, 4.411952, 1.667445], [4.328048, 8.698048, 1.667445], [4.328048, 4.411952, 0.8475550000000001], [4.411952, 4.328048, 4.182445], [4.411952, 0.041951999999999996, 3.362555], [8.698048, 4.328048, 3.362555], [8.698048, 0.041951999999999996, 4.182445], [1.14057, 7.599430000000001, 3.15884], [1.14057, 5.5105699999999995, 4.38616], [3.2294300000000002, 7.599430000000001, 4.38616], [3.2294300000000002, 5.5105699999999995, 3.15884], [5.5105699999999995, 3.2294300000000002, 1.8711600000000002], [5.5105699999999995, 1.14057, 0.6438400000000006], [7.599430000000001, 3.2294300000000002, 0.6438400000000006], [7.599430000000001, 1.14057, 1.8711600000000002], [1.4814300000000002, 4.569272000000001, 0.822405], [1.4814300000000002, 8.540728, 1.6925950000000003], [2.88857, 4.569272000000001, 1.6925950000000003], [2.88857, 8.540728, 0.822405], [8.540728, 2.88857, 4.207595], [8.540728, 1.4814300000000002, 3.337405], [4.569272000000001, 2.88857, 3.337405], [4.569272000000001, 1.4814300000000002, 4.207595], [7.258570000000001, 4.1707279999999995, 4.207595], [7.258570000000001, 0.19927200000000134, 3.337405], [5.85143, 4.1707279999999995, 3.337405], [5.85143, 0.19927200000000134, 4.207595], [0.19927200000000134, 5.85143, 0.822405], [0.19927200000000134, 7.258570000000001, 1.6925950000000003], [4.1707279999999995, 5.85143, 1.6925950000000003], [4.1707279999999995, 7.258570000000001, 0.822405], [0.6581220000000001, 2.9567419999999998, 0.746955], [0.6581220000000001, 1.4132580000000001, 1.7680450000000003], [3.711878, 2.9567419999999998, 1.7680450000000003], [3.711878, 1.4132580000000001, 0.746955], [1.4132580000000001, 3.711878, 4.283045], [1.4132580000000001, 0.6581220000000001, 3.261955], [2.9567419999999998, 3.711878, 3.261955], [2.9567419999999998, 0.6581220000000001, 4.283045], [8.081878, 5.783258, 4.283045], [8.081878, 7.326742, 3.261955], [5.028122000000001, 5.783258, 3.261955], [5.028122000000001, 7.326742, 4.283045], [7.326742, 5.028122000000001, 0.746955], [7.326742, 8.081878, 1.7680450000000003], [5.783258, 5.028122000000001, 1.7680450000000003], [5.783258, 8.081878, 0.746955]],
                "lattice_vectors": [[8.74, 0.0, 0.0], [0.0, 8.74, 0.0], [0.0, 0.0, 5.03]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "m": {"X_0": 8}, "n": {"X_0": 16}}
            }
        ],
        135: [
            {
                "Notes": "Downeyite (SeO<sub>2</sub>, $C47$) Structure",
                "Pearsons Symbol": "tP24",
                "Prototype": "O2Se",
                "Space Group Number": 135,
                "Space Group Symbol": "$P4_{2}/mbc$",
                "Strukturbericht Designation": "$C47$",
                "aflow_prototype_id": "A2B_tP24_135_gh_h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tP24_135_gh_h.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se"],
                "atom_positions": [[3.016486064, 7.177386064, 1.263525], [7.177386064, 5.305313935999999, 3.790575], [1.1444139359999999, 3.016486064000001, 3.790575], [5.305313935999999, 1.1444139359999999, 1.263525], [5.305313935999999, 1.1444139359999999, 3.790575], [1.1444139359999999, 3.016486064000001, 1.263525], [7.177386064, 5.305313935999999, 1.263525], [3.016486064, 7.177386064, 3.790575], [7.840050998, 1.4444980440000001, 0.0], [3.679150998, 2.716401956, 0.0], [4.642649002, 5.605398044, 0.0], [0.481749002, 6.877301955999999, 0.0], [2.716401956, 4.642649002, 2.52705], [6.877301955999999, 7.840050998, 2.52705], [1.4444980440000001, 0.481749002, 2.52705], [5.605398044, 3.679150998, 2.52705], [1.114788328, 1.741669522, 0.0], [5.275688327999999, 2.4192304780000002, 0.0], [3.0461116720000003, 5.902569521999999, 0.0], [7.207011672, 6.580130478, 0.0], [2.4192304780000002, 3.0461116720000003, 2.52705], [6.580130478, 1.114788328, 2.52705], [1.741669522, 7.207011672, 2.52705], [5.902569521999999, 5.275688327999999, 2.52705]],
                "lattice_vectors": [[8.3218, 0.0, 0.0], [0.0, 8.3218, 0.0], [0.0, 0.0, 5.0541]],
                "normalized_wyckoff_matid": {"g": {"X_0": 1}, "h": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "ZnSb<sub>2</sub>O<sub>4</sub> Structure",
                "Pearsons Symbol": "tP28",
                "Prototype": "O4Sb2Zn",
                "Space Group Number": 135,
                "Space Group Symbol": "$P4_{2}/mbc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B2C_tP28_135_gh_h_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B2C_tP28_135_gh_h_d.html",
                "atom_labels": ["Zn", "Zn", "Zn", "Zn", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb"],
                "atom_positions": [[0.0, 4.2454511947, 1.479982986275], [4.2454511947, 0.0, 4.439948958825], [0.0, 4.2454511947, 4.439948958825], [4.2454511947, 0.0, 1.479982986275], [1.4349625038086002, 5.680413698508601, 1.479982986275], [5.680413698508601, 7.0559398855914, 4.439948958825], [2.8104886908914, 1.4349625038086005, 4.439948958825], [7.0559398855914, 2.8104886908914, 1.479982986275], [7.0559398855914, 2.8104886908914, 4.439948958825], [2.8104886908914, 1.4349625038086005, 1.479982986275], [5.680413698508601, 7.0559398855914, 1.479982986275], [1.4349625038086002, 5.680413698508601, 4.439948958825], [0.9679628723916001, 3.2774883223084004, 0.0], [5.2134140670916, 0.9679628723916, 0.0], [3.2774883223084004, 7.522939517008401, 0.0], [7.522939517008401, 5.2134140670916, 0.0], [0.9679628723916, 3.2774883223084004, 2.95996597255], [5.2134140670916, 0.9679628723916001, 2.95996597255], [3.2774883223084004, 7.522939517008401, 2.95996597255], [7.522939517008401, 5.2134140670916, 2.95996597255], [1.4179806990298, 1.485907918145, 0.0], [5.6634318937298005, 2.759543276555, 0.0], [2.8274704956702, 5.731359112845, 0.0], [7.0729216903702, 7.004994471255, 0.0], [2.759543276555, 2.8274704956702, 2.95996597255], [7.004994471255, 1.4179806990298, 2.95996597255], [1.485907918145, 7.0729216903702, 2.95996597255], [5.731359112845, 5.6634318937298005, 2.95996597255]],
                "lattice_vectors": [[8.4909023894, 0.0, 0.0], [0.0, 8.4909023894, 0.0], [0.0, 0.0, 5.9199319451]],
                "normalized_wyckoff_matid": {"d": {"X_2": 1}, "g": {"X_0": 2}, "h": {"X_0": 2, "X_1": 2}}
            }
        ],
        136: [
            {
                "Notes": "$\\beta$&ndash;BeO Structure",
                "Pearsons Symbol": "tP8",
                "Prototype": "BeO",
                "Space Group Number": 136,
                "Space Group Symbol": "$P4_{2}/mnm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_tP8_136_g_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tP8_136_g_f.html",
                "atom_labels": ["O", "O", "O", "O", "Be", "Be", "Be", "Be"],
                "atom_positions": [[1.4725, 1.4725, 0.0], [3.8475, 0.9025, 1.37], [0.9025, 3.8475, 1.37], [3.2775, 3.2775, 0.0], [1.596, 3.1540000000000004, 0.0], [3.9710000000000005, 3.9709999999999996, 1.37], [0.7789999999999999, 0.7790000000000007, 1.37], [3.1539999999999995, 1.5959999999999999, 0.0]],
                "lattice_vectors": [[4.75, 0.0, 0.0], [0.0, 4.75, 0.0], [0.0, 0.0, 2.74]],
                "normalized_wyckoff_matid": {"f": {"X_0": 1}, "g": {"X_1": 1}}
            },
            {
                "Notes": "$\\sigma$&ndash;CrFe (D8<sub>b</sub>) Structure",
                "Pearsons Symbol": "tP30",
                "Prototype": "CrFe",
                "Space Group Number": 136,
                "Space Group Symbol": "$P4_{2}/mnm$",
                "Strukturbericht Designation": "$D8_{b}$",
                "aflow_prototype_id": "sigma_tP30_136_bf2ij",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/sigma_tP30_136_bf2ij.html",
                "atom_labels": ["Pd", "Pd", "Rh", "Rh", "Rh", "Rh", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe"],
                "atom_positions": [[0.0, 0.0, 2.2791], [4.3983, 4.3983, 0.0], [3.506676624, 3.506676624, 0.0], [7.904976624, 0.8916233760000001, 2.2791], [0.8916233760000001, 7.904976624, 2.2791], [5.289923376, 5.289923376, 0.0], [1.154289852, 4.077136134, 0.0], [5.552589852, 0.32116386599999985, 2.2791], [3.244010148, 8.475436133999999, 2.2791], [7.642310148, 4.719463866, 0.0], [4.719463866, 7.642310148, 0.0], [0.32116386599999985, 5.552589852, 2.2791], [8.475436133999999, 3.244010148, 2.2791], [4.077136134, 1.154289852, 0.0], [0.581367294, 6.503590278, 0.0], [4.9796672939999995, 6.691309722, 2.2791], [3.8169327060000002, 2.1052902780000005, 2.2791], [8.215232706, 2.2930097219999994, 0.0], [2.2930097219999994, 8.215232706, 0.0], [6.691309722, 4.9796672939999995, 2.2791], [2.1052902780000005, 3.8169327060000002, 2.2791], [6.503590278, 0.581367294, 0.0], [1.606874922, 1.606874922, 1.148757564], [6.005174922, 2.791425078, 1.130342436], [2.791425078, 6.005174922, 1.130342436], [7.1897250779999995, 7.1897250779999995, 1.148757564], [7.1897250779999995, 7.1897250779999995, 3.409442436], [2.791425078, 6.005174922, 3.4278575640000004], [6.005174922, 2.791425078, 3.4278575640000004], [1.606874922, 1.606874922, 3.409442436]],
                "lattice_vectors": [[8.7966, 0.0, 0.0], [0.0, 8.7966, 0.0], [0.0, 0.0, 4.5582]],
                "normalized_wyckoff_matid": {"a": {"X_4": 1}, "f": {"X_3": 2}, "i": {"X_0": 4, "X_1": 4}, "j": {"X_2": 4}}
            },
            {
                "Notes": "$\\beta$&ndash;U (A<sub>b</sub>) Structure",
                "Pearsons Symbol": "tP30",
                "Prototype": "U",
                "Space Group Number": 136,
                "Space Group Symbol": "$P4_{2}/mnm$",
                "Strukturbericht Designation": "$A_{b}$",
                "aflow_prototype_id": "A_tP30_136_bf2ij",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tP30_136_bf2ij.html",
                "atom_labels": ["U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U", "U"],
                "atom_positions": [[0.0, 0.0, 2.817], [5.295, 5.295, 0.0], [1.093947, 1.093947, 0.0], [6.388946999999999, 4.201053, 2.817], [4.201053, 6.388946999999999, 2.817], [9.496053, 9.496053, 0.0], [3.883353, 0.405597, 0.0], [9.178353, 4.889403, 2.817], [1.4116469999999997, 5.700597, 2.817], [6.706646999999999, 10.184403, 0.0], [10.184403, 6.706646999999999, 0.0], [4.889403, 9.178353, 2.817], [5.700597, 1.4116469999999997, 2.817], [0.405597, 3.883353, 0.0], [5.938872, 2.492886, 0.0], [0.6438719999999997, 2.802114, 2.817], [9.946128, 7.787886, 2.817], [4.651128, 8.097114, 0.0], [8.097114, 4.651128, 0.0], [2.802114, 0.6438719999999997, 2.817], [7.787886, 9.946128, 2.817], [2.492886, 5.938872, 0.0], [3.370797, 3.370797, 1.5211800000000002], [8.665797, 1.9242029999999997, 1.29582], [1.9242029999999997, 8.665797, 1.29582], [7.219202999999999, 7.219202999999999, 1.5211800000000002], [7.219202999999999, 7.219202999999999, 4.11282], [1.9242029999999997, 8.665797, 4.33818], [8.665797, 1.9242029999999997, 4.33818], [3.370797, 3.370797, 4.11282]],
                "lattice_vectors": [[10.59, 0.0, 0.0], [0.0, 10.59, 0.0], [0.0, 0.0, 5.634]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "f": {"X_0": 2}, "i": {"X_0": 8}, "j": {"X_0": 4}}
            },
            {
                "Notes": "Rutile (TiO<sub>2</sub>, C4) Structure",
                "Pearsons Symbol": "tP6",
                "Prototype": "O2Ti",
                "Space Group Number": 136,
                "Space Group Symbol": "$P4_{2}/mnm$",
                "Strukturbericht Designation": "$C4$",
                "aflow_prototype_id": "A2B_tP6_136_f_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tP6_136_f_a.html",
                "atom_labels": ["Ti", "Ti", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.2961, 2.2961, 1.4787], [1.400437312, 1.400437312, 0.0], [3.6965373120000002, 0.8956626879999999, 1.4787], [0.8956626879999999, 3.6965373120000002, 1.4787], [3.191762688, 3.191762688, 0.0]],
                "lattice_vectors": [[4.5922, 0.0, 0.0], [0.0, 4.5922, 0.0], [0.0, 0.0, 2.9574]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "f": {"X_0": 2}}
            },
            {
                "Notes": "$\\gamma$&ndash;N Structure",
                "Pearsons Symbol": "tP4",
                "Prototype": "N",
                "Space Group Number": 136,
                "Space Group Symbol": "$P4_{2}/mnm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_tP4_136_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tP4_136_f.html",
                "atom_labels": ["N", "N", "N", "N"],
                "atom_positions": [[0.387786, 0.387786, 0.0], [2.3662859999999997, 1.590714, 2.5545], [1.590714, 2.3662859999999997, 2.5545], [3.569214, 3.569214, 0.0]],
                "lattice_vectors": [[3.957, 0.0, 0.0], [0.0, 3.957, 0.0], [0.0, 0.0, 5.109]],
                "normalized_wyckoff_matid": {"f": {"X_0": 1}}
            }
        ],
        137: [
            {
                "Notes": "CeCo<sub>4</sub>B<sub>4</sub> Structure",
                "Pearsons Symbol": "tP18",
                "Prototype": "B4CeCo4",
                "Space Group Number": 137,
                "Space Group Symbol": "$P4_{2}/nmc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4BC4_tP18_137_g_b_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4BC4_tP18_137_g_b_g.html",
                "atom_labels": ["Ce", "Ce", "B", "B", "B", "B", "B", "B", "B", "B", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co"],
                "atom_positions": [[3.794482578075, 1.264827526025, 1.765858236075], [1.264827526025, 3.794482578075, 5.2975747082249995], [1.264827526025, 0.40474480832799997, 0.70634329443], [3.794482578075, 4.654565295772, 6.35708964987], [3.794482578075, 2.9343998603779995, 6.35708964987], [1.264827526025, 2.1249102437219998, 0.70634329443], [4.654565295772, 3.794482578075, 2.82537317772], [2.1249102437219998, 1.264827526025, 4.238059766579999], [0.40474480832799997, 1.264827526025, 4.238059766579999], [2.9343998603779995, 3.794482578075, 2.82537317772], [1.264827526025, 2.5448329823623, 2.7123582506112], [3.794482578075, 2.5144771217376998, 4.351074693688799], [3.794482578075, 0.015177930312300573, 4.351074693688799], [1.264827526025, 5.0441321737877, 2.7123582506112], [2.5144771217376998, 3.794482578075, 0.8193582215387999], [5.0441321737877, 1.264827526025, 6.2440747227612], [2.5448329823623, 1.264827526025, 6.2440747227612], [0.015177930312300573, 3.794482578075, 0.8193582215387999]],
                "lattice_vectors": [[5.0593101041, 0.0, 0.0], [0.0, 5.0593101041, 0.0], [0.0, 0.0, 7.0634329443]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "g": {"X_0": 4, "X_1": 4}}
            },
            {
                "Notes": "Zn<sub>3</sub>P<sub>2</sub> ($D5_{9}$) Structure",
                "Pearsons Symbol": "tP40",
                "Prototype": "P2Zn3",
                "Space Group Number": 137,
                "Space Group Symbol": "$P4_{2}/nmc$",
                "Strukturbericht Designation": "$D5_{9}$",
                "aflow_prototype_id": "A2B3_tP40_137_cdf_3g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_tP40_137_cdf_3g.html",
                "atom_labels": ["P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn"],
                "atom_positions": [[6.072749999999999, 2.02425, 0.0], [2.02425, 6.072749999999999, 0.0], [6.072749999999999, 2.02425, 5.725], [2.02425, 6.072749999999999, 5.725], [2.02425, 2.02425, 0.12594999999999998], [6.072749999999999, 6.072749999999999, 11.32405], [6.072749999999999, 6.072749999999999, 5.599049999999999], [2.02425, 2.02425, 5.85095], [4.137567, 3.9594329999999998, 2.8625], [0.08906700000000098, 4.137567, 8.587499999999999], [3.9594329999999998, 8.007933, 8.587499999999999], [8.007933, 0.08906700000000008, 2.8625], [3.9594329999999998, 4.137567, 8.587499999999999], [8.007933, 3.9594329999999998, 2.8625], [4.137567, 0.08906700000000008, 2.8625], [0.08906700000000098, 8.007933, 8.587499999999999], [2.02425, 4.315701, 1.6831499999999997], [6.072749999999999, 3.7812989999999997, 9.76685], [6.072749999999999, 0.2672009999999993, 9.76685], [2.02425, 7.8297989999999995, 1.6831499999999997], [3.7812989999999997, 6.072749999999999, 4.041849999999999], [7.8297989999999995, 2.02425, 7.40815], [4.315701, 2.02425, 7.40815], [0.2672009999999993, 6.072749999999999, 4.041849999999999], [2.02425, 3.781299, 9.8928], [6.072749999999999, 4.315700999999999, 1.5572], [6.072749999999999, 7.829799, 1.5572], [2.02425, 0.2672009999999998, 9.8928], [4.315700999999999, 6.072749999999999, 7.2822], [0.2672009999999998, 2.02425, 4.167799999999998], [3.781299, 2.02425, 4.167799999999998], [7.829799, 6.072749999999999, 7.2822], [2.02425, 4.0485, 6.904349999999999], [6.072749999999999, 4.0485, 4.54565], [6.072749999999999, 0.0, 4.54565], [2.02425, 0.0, 6.904349999999999], [4.0485, 6.072749999999999, 10.27065], [0.0, 2.02425, 1.1793499999999997], [4.0485, 2.02425, 1.1793499999999997], [0.0, 6.072749999999999, 10.27065]],
                "lattice_vectors": [[8.097, 0.0, 0.0], [0.0, 8.097, 0.0], [0.0, 0.0, 11.45]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "d": {"X_1": 1}, "f": {"X_1": 2}, "g": {"X_0": 6}}
            },
            {
                "Notes": "ZrO<sub>2</sub> (High&ndash;temperature) Structure",
                "Pearsons Symbol": "tP6",
                "Prototype": "O2Zr",
                "Space Group Number": 137,
                "Space Group Symbol": "$P4_{2}/nmc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_tP6_137_d_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tP6_137_d_a.html",
                "atom_labels": ["Zr", "Zr", "O", "O", "O", "O"],
                "atom_positions": [[2.7300600525, 0.9100200175, 3.9525869441249997], [0.9100200175, 2.7300600525, 1.317528981375], [0.9100200175, 0.9100200175, 2.9776154979075], [2.7300600525, 2.7300600525, 2.2925004275925], [2.7300600525, 2.7300600525, 4.9275583903425], [0.9100200175, 0.9100200175, 0.3425575351574997]],
                "lattice_vectors": [[3.64008007, 0.0, 0.0], [0.0, 3.64008007, 0.0], [0.0, 0.0, 5.2701159255]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "HgI<sub>2</sub> ($C13$) Structure",
                "Pearsons Symbol": "tP6",
                "Prototype": "HgI",
                "Space Group Number": 137,
                "Space Group Symbol": "$P4_{2}/nmc$",
                "Strukturbericht Designation": "$C13$",
                "aflow_prototype_id": "AB2_tP6_137_a_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_tP6_137_a_d.html",
                "atom_labels": ["Hg", "Hg", "I", "I", "I", "I"],
                "atom_positions": [[3.275625, 1.091875, 9.352500000000001], [1.091875, 3.275625, 3.1175], [1.091875, 1.091875, 4.85083], [3.275625, 3.275625, 7.61917], [3.275625, 3.275625, 1.38417], [1.091875, 1.091875, 11.085830000000001]],
                "lattice_vectors": [[4.3675, 0.0, 0.0], [0.0, 4.3675, 0.0], [0.0, 0.0, 12.47]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_0": 2}}
            }
        ],
        138: [
            {
                "Notes": "Cl (A18) Structure",
                "Pearsons Symbol": "tP16",
                "Prototype": "Cl",
                "Space Group Number": 138,
                "Space Group Symbol": "$P4_{2}/ncm$",
                "Strukturbericht Designation": "$A18$",
                "aflow_prototype_id": "A_tP16_138_j",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tP16_138_j.html",
                "atom_labels": ["Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[3.21, 7.849520000000001, 5.24484], [7.49, 0.7104800000000001, 3.93516], [5.3500000000000005, 3.5695200000000002, 3.93516], [1.07, 4.99048, 5.24484], [0.7104800000000001, 5.3500000000000005, 0.8751600000000002], [4.99048, 3.21, 2.18484], [7.849520000000001, 1.07, 2.18484], [3.5695200000000002, 7.49, 0.8751600000000002], [5.3500000000000005, 0.7104800000000001, 0.8751600000000002], [1.07, 7.849520000000001, 2.18484], [3.21, 4.99048, 2.18484], [7.49, 3.5695200000000002, 0.8751600000000002], [7.849520000000001, 3.21, 5.24484], [3.5695200000000002, 5.3500000000000005, 3.93516], [0.7104800000000001, 7.49, 3.93516], [4.99048, 1.07, 5.24484]],
                "lattice_vectors": [[8.56, 0.0, 0.0], [0.0, 8.56, 0.0], [0.0, 0.0, 6.12]],
                "normalized_wyckoff_matid": {"j": {"X_0": 1}}
            },
            {
                "Notes": "C (T12 Group IV) Structure",
                "Pearsons Symbol": "tP12",
                "Prototype": "C",
                "Space Group Number": 138,
                "Space Group Symbol": "$P4_{2}/ncm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_tP12_138_bi",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tP12_138_bi.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C"],
                "atom_positions": [[2.541, 0.847, 4.50825], [0.847, 2.541, 4.50825], [2.541, 0.847, 1.50275], [0.847, 2.541, 1.50275], [0.29136799999999996, 0.29136799999999996, 0.643177], [1.9853679999999998, 3.096632, 2.362323], [3.096632, 1.9853679999999998, 2.362323], [1.402632, 1.402632, 0.643177], [3.096632, 3.096632, 5.3678230000000005], [1.402632, 0.29136799999999996, 3.648677], [0.29136799999999996, 1.402632, 3.648677], [1.9853679999999998, 1.9853679999999998, 5.3678230000000005]],
                "lattice_vectors": [[3.388, 0.0, 0.0], [0.0, 3.388, 0.0], [0.0, 0.0, 6.011]],
                "normalized_wyckoff_matid": {"b": {"X_0": 1}, "i": {"X_0": 2}}
            }
        ],
        139: [
            {
                "Notes": "V<sub>4</sub>Zn<sub>5</sub> Structure",
                "Pearsons Symbol": "tI18",
                "Prototype": "V4Zn5",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B5_tI18_139_i_ah",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B5_tI18_139_i_ah.html",
                "atom_labels": ["Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "V", "V", "V", "V", "V", "V", "V", "V"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.455, 4.455, 1.61], [2.92248, 2.92248, 0.0], [2.92248, 5.987519999999999, 0.0], [5.987519999999999, 2.92248, 0.0], [5.987519999999999, 5.987519999999999, 0.0], [7.377480000000001, 7.377480000000001, 1.61], [7.377480000000001, 1.5325199999999999, 1.61], [1.5325199999999999, 7.377480000000001, 1.61], [1.5325199999999999, 1.5325199999999999, 1.61], [3.1006799999999997, 0.0, 0.0], [5.8093200000000005, 0.0, 0.0], [0.0, 5.8093200000000005, 0.0], [0.0, 3.1006799999999997, 0.0], [7.55568, 4.455, 1.61], [1.3543200000000002, 4.455, 1.61], [4.455, 1.3543200000000002, 1.61], [4.455, 7.55568, 1.61]],
                "lattice_vectors": [[8.91, 0.0, 0.0], [0.0, 8.91, 0.0], [0.0, 0.0, 3.22]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "h": {"X_0": 4}, "i": {"X_1": 4}}
            },
            {
                "Notes": "Al<sub>3</sub>Zr (D0<sub>23</sub>) Structure",
                "Pearsons Symbol": "tI16",
                "Prototype": "Al3Zr",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "$D0_{23}$",
                "aflow_prototype_id": "A3B_tI16_139_cde_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_tI16_139_cde_e.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Zr", "Zr", "Zr", "Zr"],
                "atom_positions": [[0.0, 1.99965, 0.0], [1.99965, 0.0, 0.0], [1.99965, 0.0, 8.6415], [0.0, 1.99965, 8.6415], [0.0, 1.99965, 4.32075], [0.0, 1.99965, 12.962250000000001], [1.99965, 0.0, 12.962250000000001], [1.99965, 0.0, 4.32075], [0.0, 0.0, 6.48077934], [0.0, 0.0, 10.802220660000001], [1.99965, 1.99965, 15.12227934], [1.99965, 1.99965, 2.1607206600000004], [0.0, 0.0, 2.05425738], [0.0, 0.0, 15.228742620000002], [1.99965, 1.99965, 10.69575738], [1.99965, 1.99965, 6.587242620000001]],
                "lattice_vectors": [[3.9993, 0.0, 0.0], [0.0, 3.9993, 0.0], [0.0, 0.0, 17.283]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "d": {"X_0": 1}, "e": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "Al<sub>3</sub>Ti (D0<sub>22</sub>) Structure",
                "Pearsons Symbol": "tI8",
                "Prototype": "Al3Ti",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "$D0_{22}$",
                "aflow_prototype_id": "A3B_tI8_139_bd_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_tI8_139_bd_a.html",
                "atom_labels": ["Ti", "Ti", "Al", "Al", "Al", "Al", "Al", "Al"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.92685, 1.92685, 4.29195], [0.0, 0.0, 4.29195], [1.92685, 1.92685, 0.0], [0.0, 1.92685, 2.145975], [0.0, 1.92685, 6.437925], [1.92685, 0.0, 6.437925], [1.92685, 0.0, 2.145975]],
                "lattice_vectors": [[3.8537, 0.0, 0.0], [0.0, 3.8537, 0.0], [0.0, 0.0, 8.5839]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "Hypothetical Tetrahedrally Bonded Carbon with 4&ndash;Member Rings",
                "Pearsons Symbol": "tI8",
                "Prototype": "C",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_tI8_139_h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tI8_139_h.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C"],
                "atom_positions": [[0.7760924544, 0.7760924544, 0.0], [0.7760924544, 3.5557475455999996, 0.0], [3.5557475455999996, 0.7760924544, 0.0], [3.5557475455999996, 3.5557475455999996, 0.0], [2.9420124544, 2.9420124544, 1.24346], [2.9420124544, 1.3898275456, 1.24346], [1.3898275456, 2.9420124544, 1.24346], [1.3898275456, 1.3898275456, 1.24346]],
                "lattice_vectors": [[4.33184, 0.0, 0.0], [0.0, 4.33184, 0.0], [0.0, 0.0, 2.48692]],
                "normalized_wyckoff_matid": {"h": {"X_0": 1}}
            },
            {
                "Notes": "$\\alpha$&ndash;Pa (A<sub>a</sub>) Structure",
                "Pearsons Symbol": "tI2",
                "Prototype": "Pa",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "$A_{a}$",
                "aflow_prototype_id": "A_tI2_139_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tI2_139_a.alpha-Pa.html",
                "atom_labels": ["Pa", "Pa"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.966, 1.966, 1.619]],
                "lattice_vectors": [[3.932, 0.0, 0.0], [0.0, 3.932, 0.0], [0.0, 0.0, 3.238]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}}
            },
            {
                "Notes": "Hypothetical BCT5 Si Structure",
                "Pearsons Symbol": "tI4",
                "Prototype": "Si",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_tI4_139_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tI4_139_e.html",
                "atom_labels": ["Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 5.327308349999999], [0.0, 0.0, 1.1773416500000002], [1.67458, 1.67458, 2.0749833499999997], [1.67458, 1.67458, 4.429666650000001]],
                "lattice_vectors": [[3.34916, 0.0, 0.0], [0.0, 3.34916, 0.0], [0.0, 0.0, 6.50465]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1}}
            },
            {
                "Notes": "Al<sub>4</sub>Ba (D1<sub>3</sub>) Structure",
                "Pearsons Symbol": "tI10",
                "Prototype": "Al4Ba",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "$D1_{3}$",
                "aflow_prototype_id": "A4B_tI10_139_de_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B_tI10_139_de_a.html",
                "atom_labels": ["Ba", "Ba", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.265, 2.265, 5.55], [0.0, 2.265, 2.775], [0.0, 2.265, 8.325], [2.265, 0.0, 8.325], [2.265, 0.0, 2.775], [0.0, 0.0, 4.218], [0.0, 0.0, 6.882], [2.265, 2.265, 9.767999999999999], [2.265, 2.265, 1.3319999999999999]],
                "lattice_vectors": [[4.53, 0.0, 0.0], [0.0, 4.53, 0.0], [0.0, 0.0, 11.1]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_0": 2}, "e": {"X_0": 2}}
            },
            {
                "Notes": "Mn<sub>12</sub>Th (D2<sub>b</sub>) Structure",
                "Pearsons Symbol": "tI26",
                "Prototype": "Mn12Th",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "$D2_{b}$",
                "aflow_prototype_id": "A12B_tI26_139_fij_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A12B_tI26_139_fij_a.html",
                "atom_labels": ["Th", "Th", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.235, 4.235, 2.475], [2.1175, 2.1175, 1.2375], [2.1175, 6.352500000000001, 3.7125000000000004], [6.352500000000001, 2.1175, 3.7125000000000004], [6.352500000000001, 6.352500000000001, 1.2375], [6.352500000000001, 6.352500000000001, 3.7125000000000004], [6.352500000000001, 2.1175, 1.2375], [2.1175, 6.352500000000001, 1.2375], [2.1175, 2.1175, 3.7125000000000004], [3.0576700000000003, 0.0, 0.0], [5.412330000000001, 0.0, 0.0], [0.0, 5.412330000000001, 0.0], [0.0, 3.0576700000000003, 0.0], [7.29267, 4.235, 2.475], [1.1773300000000002, 4.235, 2.475], [4.235, 1.1773300000000002, 2.475], [4.235, 7.29267, 2.475], [2.3546600000000004, 4.235, 0.0], [6.115340000000001, 4.235, 0.0], [4.235, 6.115340000000001, 0.0], [4.235, 2.3546600000000004, 0.0], [6.58966, 0.0, 2.475], [1.88034, 0.0, 2.475], [0.0, 1.88034, 2.475], [0.0, 6.58966, 2.475]],
                "lattice_vectors": [[8.47, 0.0, 0.0], [0.0, 8.47, 0.0], [0.0, 0.0, 4.95]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "f": {"X_0": 4}, "i": {"X_0": 4}, "j": {"X_0": 4}}
            },
            {
                "Notes": "0201 [(La,Ba)<sub>2</sub>CuO<sub>4</sub>] High&ndash;T<sub>c</sub> Structure",
                "Pearsons Symbol": "tI14",
                "Prototype": "CuLa2O4",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2C4_tI14_139_a_e_ce",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2C4_tI14_139_a_e_ce.html",
                "atom_labels": ["Cu", "Cu", "O", "O", "O", "O", "La", "La", "La", "La", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.89085, 1.89085, 6.62435], [0.0, 1.89085, 0.0], [1.89085, 0.0, 0.0], [1.89085, 0.0, 6.62435], [0.0, 1.89085, 6.62435], [0.0, 0.0, 4.779468525], [0.0, 0.0, 8.469231474999999], [1.89085, 1.89085, 11.403818525], [1.89085, 1.89085, 1.8448814749999998], [0.0, 0.0, 2.41656288], [0.0, 0.0, 10.832137119999999], [1.89085, 1.89085, 9.04091288], [1.89085, 1.89085, 4.20778712]],
                "lattice_vectors": [[3.7817, 0.0, 0.0], [0.0, 3.7817, 0.0], [0.0, 0.0, 13.2487]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "c": {"X_0": 2}, "e": {"X_0": 2, "X_1": 2}}
            },
            {
                "Notes": "ThH<sub>2</sub> (L'2) Structure",
                "Pearsons Symbol": "tI6",
                "Prototype": "H2Th",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "$L'2$",
                "aflow_prototype_id": "A2B_tI6_139_d_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tI6_139_d_a.html",
                "atom_labels": ["Th", "Th", "H", "H", "H", "H"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.05, 2.05, 2.515], [0.0, 2.05, 1.2575], [0.0, 2.05, 3.7725], [2.05, 0.0, 3.7725], [2.05, 0.0, 1.2575]],
                "lattice_vectors": [[4.1, 0.0, 0.0], [0.0, 4.1, 0.0], [0.0, 0.0, 5.03]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "Pt<sub>8</sub>Ti Structure",
                "Pearsons Symbol": "tI18",
                "Prototype": "Pt8Ti",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A8B_tI18_139_hi_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A8B_tI18_139_hi_a.html",
                "atom_labels": ["Ti", "Ti", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt", "Pt"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.156, 4.156, 1.9485], [2.767896, 2.767896, 0.0], [2.767896, 5.544104, 0.0], [5.544104, 2.767896, 0.0], [5.544104, 5.544104, 0.0], [6.923895999999999, 6.923895999999999, 1.9485], [6.923895999999999, 1.3881039999999998, 1.9485], [1.3881039999999998, 6.923895999999999, 1.9485], [1.3881039999999998, 1.3881039999999998, 1.9485], [2.7180239999999998, 0.0, 0.0], [5.593976, 0.0, 0.0], [0.0, 5.593976, 0.0], [0.0, 2.7180239999999998, 0.0], [6.8740239999999995, 4.156, 1.9485], [1.4379759999999997, 4.156, 1.9485], [4.156, 1.4379759999999997, 1.9485], [4.156, 6.8740239999999995, 1.9485]],
                "lattice_vectors": [[8.312, 0.0, 0.0], [0.0, 8.312, 0.0], [0.0, 0.0, 3.897]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "h": {"X_0": 4}, "i": {"X_0": 4}}
            },
            {
                "Notes": "MoSi<sub>2</sub> (C11<sub>b</sub>) Structure",
                "Pearsons Symbol": "tI6",
                "Prototype": "MoSi2",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "$C11_{b}$",
                "aflow_prototype_id": "AB2_tI6_139_a_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_tI6_139_a_e.html",
                "atom_labels": ["Mo", "Mo", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.6032, 1.6032, 3.9239], [0.0, 0.0, 2.63136734], [0.0, 0.0, 5.216432660000001], [1.6032, 1.6032, 6.555267339999999], [1.6032, 1.6032, 1.2925326600000002]],
                "lattice_vectors": [[3.2064, 0.0, 0.0], [0.0, 3.2064, 0.0], [0.0, 0.0, 7.8478]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "e": {"X_0": 2}}
            },
            {
                "Notes": "In (A6) Structure",
                "Pearsons Symbol": "tI2",
                "Prototype": "In",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "$A6$",
                "aflow_prototype_id": "A_tI2_139_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tI2_139_a.In.html",
                "atom_labels": ["In", "In"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.626415, 1.626415, 2.47315]],
                "lattice_vectors": [[3.25283, 0.0, 0.0], [0.0, 3.25283, 0.0], [0.0, 0.0, 4.9463]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}}
            },
            {
                "Notes": "Calomel (Hg<sub>2</sub>Cl<sub>2</sub>, $D3_{1}$) Structure",
                "Pearsons Symbol": "tI8",
                "Prototype": "Cl2Hg2",
                "Space Group Number": 139,
                "Space Group Symbol": "$I4/mmm$",
                "Strukturbericht Designation": "$D3_{1}$",
                "aflow_prototype_id": "AB_tI8_139_e_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tI8_139_e_e.html",
                "atom_labels": ["Cl", "Cl", "Cl", "Cl", "Hg", "Hg", "Hg", "Hg"],
                "atom_positions": [[0.0, 0.0, 3.65985224], [0.0, 0.0, 7.24554776], [2.23975, 2.23975, 9.11255224], [2.23975, 2.23975, 1.79284776], [0.0, 0.0, 1.2977425999999999], [0.0, 0.0, 9.6076574], [2.23975, 2.23975, 6.7504426], [2.23975, 2.23975, 4.1549574]],
                "lattice_vectors": [[4.4795, 0.0, 0.0], [0.0, 4.4795, 0.0], [0.0, 0.0, 10.9054]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1, "X_1": 1}}
            }
        ],
        140: [
            {
                "Notes": "Khatyrkite (Al<sub>2</sub>Cu, C16) Structure",
                "Pearsons Symbol": "tI12",
                "Prototype": "Al2Cu",
                "Space Group Number": 140,
                "Space Group Symbol": "$I4/mcm$",
                "Strukturbericht Designation": "$C16$",
                "aflow_prototype_id": "A2B_tI12_140_h_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tI12_140_h_a.html",
                "atom_labels": ["Cu", "Cu", "Cu", "Cu", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al"],
                "atom_positions": [[0.0, 0.0, 1.215], [0.0, 0.0, 3.6450000000000005], [3.02, 3.02, 3.6450000000000005], [3.02, 3.02, 1.215], [0.9543200000000001, 3.97432, 0.0], [0.9543200000000001, 2.06568, 2.43], [5.08568, 3.97432, 2.43], [5.08568, 2.06568, 0.0], [2.06568, 5.08568, 2.43], [2.06568, 0.9543200000000001, 0.0], [3.97432, 5.08568, 0.0], [3.97432, 0.9543200000000001, 2.43]],
                "lattice_vectors": [[6.04, 0.0, 0.0], [0.0, 6.04, 0.0], [0.0, 0.0, 4.86]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "h": {"X_0": 2}}
            },
            {
                "Notes": "SiU<sub>3</sub> (D0<sub>c</sub>) Structure",
                "Pearsons Symbol": "tI16",
                "Prototype": "SiU3",
                "Space Group Number": 140,
                "Space Group Symbol": "$I4/mcm$",
                "Strukturbericht Designation": "$D0_{c}$",
                "aflow_prototype_id": "AB3_tI16_140_b_ah",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_tI16_140_b_ah.html",
                "atom_labels": ["U", "U", "U", "U", "Si", "Si", "Si", "Si", "U", "U", "U", "U", "U", "U", "U", "U"],
                "atom_positions": [[0.0, 0.0, 2.16975], [0.0, 0.0, 6.50925], [3.0085, 3.0085, 6.50925], [3.0085, 3.0085, 2.16975], [0.0, 3.0085, 2.16975], [3.0085, 0.0, 2.16975], [0.0, 3.0085, 6.50925], [3.0085, 0.0, 6.50925], [1.3899270000000001, 4.398427, 0.0], [1.3899270000000001, 1.6185730000000003, 4.3395], [4.627073, 4.398427, 4.3395], [4.627073, 1.6185730000000003, 0.0], [1.6185730000000003, 4.627073, 4.3395], [1.6185730000000003, 1.3899270000000001, 0.0], [4.398427, 4.627073, 0.0], [4.398427, 1.3899270000000001, 4.3395]],
                "lattice_vectors": [[6.017, 0.0, 0.0], [0.0, 6.017, 0.0], [0.0, 0.0, 8.679]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}, "h": {"X_0": 2}}
            },
            {
                "Notes": "SeTl (B37) Structure",
                "Pearsons Symbol": "tI16",
                "Prototype": "SeTl",
                "Space Group Number": 140,
                "Space Group Symbol": "$I4/mcm$",
                "Strukturbericht Designation": "$B37$",
                "aflow_prototype_id": "AB_tI16_140_ab_h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tI16_140_ab_h.html",
                "atom_labels": ["Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl", "Tl"],
                "atom_positions": [[0.0, 0.0, 1.7525], [0.0, 0.0, 5.2575], [4.015, 4.015, 5.2575], [4.015, 4.015, 1.7525], [0.0, 4.015, 1.7525], [4.015, 0.0, 1.7525], [0.0, 4.015, 5.2575], [4.015, 0.0, 5.2575], [1.4373699999999998, 5.45237, 0.0], [1.4373699999999998, 2.577629999999999, 3.505], [6.592629999999999, 5.45237, 3.505], [6.592629999999999, 2.577629999999999, 0.0], [2.577629999999999, 6.592629999999999, 3.505], [2.577629999999999, 1.4373699999999998, 0.0], [5.45237, 6.592629999999999, 0.0], [5.45237, 1.4373699999999998, 3.505]],
                "lattice_vectors": [[8.03, 0.0, 0.0], [0.0, 8.03, 0.0], [0.0, 0.0, 7.01]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 1}, "h": {"X_1": 2}}
            },
            {
                "Notes": "W<sub>5</sub>Si<sub>3</sub> ($D8_{m}$) Structure",
                "Pearsons Symbol": "tI32",
                "Prototype": "Si3W5",
                "Space Group Number": 140,
                "Space Group Symbol": "$I4/mcm$",
                "Strukturbericht Designation": "$D8_{m}$",
                "aflow_prototype_id": "A3B5_tI32_140_ah_bk",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B5_tI32_140_ah_bk.html",
                "atom_labels": ["Si", "Si", "Si", "Si", "W", "W", "W", "W", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W"],
                "atom_positions": [[0.0, 0.0, 1.2425], [0.0, 0.0, 3.7275], [4.82, 4.82, 3.7275], [4.82, 4.82, 1.2425], [0.0, 4.82, 1.2425], [4.82, 0.0, 1.2425], [0.0, 4.82, 3.7275], [4.82, 0.0, 3.7275], [1.6388000000000003, 6.458800000000001, 0.0], [1.6388000000000003, 3.1811999999999996, 2.485], [8.0012, 6.458800000000001, 2.485], [8.0012, 3.1811999999999996, 0.0], [3.1811999999999996, 8.0012, 2.485], [3.1811999999999996, 1.6388000000000003, 0.0], [6.458800000000001, 8.0012, 0.0], [6.458800000000001, 1.6388000000000003, 2.485], [0.71336, 2.1497200000000003, 0.0], [0.71336, 7.49028, 2.485], [8.92664, 2.1497200000000003, 2.485], [8.92664, 7.49028, 0.0], [7.49028, 8.92664, 2.485], [7.49028, 0.71336, 0.0], [2.1497200000000003, 8.92664, 0.0], [2.1497200000000003, 0.71336, 2.485], [5.53336, 6.969720000000001, 2.485], [5.53336, 2.6702800000000004, 0.0], [4.1066400000000005, 6.969720000000001, 0.0], [4.1066400000000005, 2.6702800000000004, 2.485], [2.6702800000000004, 4.1066400000000005, 0.0], [2.6702800000000004, 5.53336, 2.485], [6.969720000000001, 4.1066400000000005, 2.485], [6.969720000000001, 5.53336, 0.0]],
                "lattice_vectors": [[9.64, 0.0, 0.0], [0.0, 9.64, 0.0], [0.0, 0.0, 4.97]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_0": 1}, "h": {"X_1": 2}, "k": {"X_0": 4}}
            },
            {
                "Notes": "Cr<sub>5</sub>B<sub>3</sub> ($D8_{l}$) Structure",
                "Pearsons Symbol": "tI32",
                "Prototype": "B3Cr5",
                "Space Group Number": 140,
                "Space Group Symbol": "$I4/mcm$",
                "Strukturbericht Designation": "$D8_{l}$",
                "aflow_prototype_id": "A3B5_tI32_140_ah_cl",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B5_tI32_140_ah_cl.html",
                "atom_labels": ["B", "B", "B", "B", "Cr", "Cr", "Cr", "Cr", "B", "B", "B", "B", "B", "B", "B", "B", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr"],
                "atom_positions": [[0.0, 0.0, 2.615], [0.0, 0.0, 7.845000000000001], [2.73, 2.73, 7.845000000000001], [2.73, 2.73, 2.615], [0.0, 0.0, 0.0], [0.0, 0.0, 5.23], [2.73, 2.73, 5.23], [2.73, 2.73, 0.0], [3.4125, 0.6825, 0.0], [3.4125, 4.7775, 5.23], [2.0475, 0.6825, 5.23], [2.0475, 4.7775, 0.0], [4.7775, 2.0475, 5.23], [4.7775, 3.4125, 0.0], [0.6825, 2.0475, 0.0], [0.6825, 3.4125, 5.23], [0.90636, 3.6363600000000003, 1.5690000000000002], [0.90636, 1.8236399999999997, 3.661], [4.55364, 3.6363600000000003, 3.661], [4.55364, 1.8236399999999997, 1.5690000000000002], [1.8236399999999997, 4.55364, 3.661], [1.8236399999999997, 0.90636, 1.5690000000000002], [3.6363600000000003, 4.55364, 1.5690000000000002], [3.6363600000000003, 0.90636, 3.661], [4.55364, 1.8236399999999997, 8.891], [4.55364, 3.6363600000000003, 6.799], [0.90636, 1.8236399999999997, 6.799], [0.90636, 3.6363600000000003, 8.891], [3.6363600000000003, 0.90636, 6.799], [3.6363600000000003, 4.55364, 8.891], [1.8236399999999997, 0.90636, 8.891], [1.8236399999999997, 4.55364, 6.799]],
                "lattice_vectors": [[5.46, 0.0, 0.0], [0.0, 5.46, 0.0], [0.0, 0.0, 10.46]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 1}, "h": {"X_1": 2}, "l": {"X_0": 4}}
            }
        ],
        141: [
            {
                "Notes": "Hausmannite (Mn<sub>3</sub>O<sub>4</sub>) Structure",
                "Pearsons Symbol": "tI28",
                "Prototype": "Mn3O4",
                "Space Group Number": 141,
                "Space Group Symbol": "$I4_{1}/amd$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B4_tI28_141_ad_h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B4_tI28_141_ad_h.html",
                "atom_labels": ["Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 4.3237499999999995, 1.18025], [0.0, 1.44125, 8.26175], [2.8825, 1.44125, 5.90125], [2.8825, 4.3237499999999995, 3.54075], [0.0, 0.0, 4.721], [0.0, 2.8825, 4.721], [1.44125, 1.44125, 2.3605], [1.44125, 4.3237499999999995, 7.0815], [4.3237499999999995, 4.3237499999999995, 7.0815], [4.3237499999999995, 1.44125, 2.3605], [2.8825, 2.8825, 0.0], [2.8825, 0.0, 0.0], [0.0, 0.160267, 2.4445338000000003], [0.0, 5.6047329999999995, 6.9974662], [0.0, 3.042767, 6.9974662], [0.0, 2.7222329999999997, 2.4445338000000003], [1.280983, 1.44125, 4.6369662], [1.280983, 4.3237499999999995, 4.8050338], [4.484017, 4.3237499999999995, 4.8050338], [4.484017, 1.44125, 4.6369662], [2.8825, 3.042767, 7.1655338], [2.8825, 2.7222329999999997, 2.2764661999999998], [2.8825, 0.160267, 2.2764661999999998], [2.8825, 5.6047329999999995, 7.1655338], [4.163482999999999, 4.3237499999999995, 9.3579662], [4.163482999999999, 1.44125, 0.08403380000000123], [1.6015169999999999, 1.44125, 0.08403380000000123], [1.6015169999999999, 4.3237499999999995, 9.3579662]],
                "lattice_vectors": [[5.765, 0.0, 0.0], [0.0, 5.765, 0.0], [0.0, 0.0, 9.442]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_1": 2}, "h": {"X_0": 4}}
            },
            {
                "Notes": "Ga<sub>2</sub>Hf Structure",
                "Pearsons Symbol": "tI24",
                "Prototype": "Ga2Hf",
                "Space Group Number": 141,
                "Space Group Symbol": "$I4_{1}/amd$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_tI24_141_2e_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tI24_141_2e_e.html",
                "atom_labels": ["Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Hf", "Hf", "Hf", "Hf", "Hf", "Hf", "Hf", "Hf"],
                "atom_positions": [[0.0, 1.0115, 3.18075], [0.0, 3.0345000000000004, 22.26525], [0.0, 1.0115, 15.90375], [0.0, 3.0345000000000004, 9.542250000000001], [2.023, 3.0345000000000004, 15.90375], [2.023, 1.0115, 9.542250000000001], [2.023, 3.0345000000000004, 3.18075], [2.023, 1.0115, 22.26525], [0.0, 1.0115, 7.3538939999999995], [0.0, 3.0345000000000004, 18.092106000000005], [0.0, 1.0115, 11.730606000000002], [0.0, 3.0345000000000004, 13.715393999999998], [2.023, 3.0345000000000004, 20.076894], [2.023, 1.0115, 5.369106000000001], [2.023, 3.0345000000000004, 24.453606000000004], [2.023, 1.0115, 0.9923939999999981], [0.0, 1.0115, 24.148254], [0.0, 3.0345000000000004, 1.297746], [0.0, 1.0115, 20.382246000000002], [0.0, 3.0345000000000004, 5.063754], [2.023, 3.0345000000000004, 11.425254], [2.023, 1.0115, 14.020746000000003], [2.023, 3.0345000000000004, 7.659246], [2.023, 1.0115, 17.786754]],
                "lattice_vectors": [[4.046, 0.0, 0.0], [0.0, 4.046, 0.0], [0.0, 0.0, 25.446]],
                "normalized_wyckoff_matid": {"e": {"X_0": 2, "X_1": 1}}
            },
            {
                "Notes": "NbP (\"40\") Structure",
                "Pearsons Symbol": "tI8",
                "Prototype": "NbP",
                "Space Group Number": 141,
                "Space Group Symbol": "$I4_{1}/amd$",
                "Strukturbericht Designation": "$\"40\"$",
                "aflow_prototype_id": "AB_tI8_141_a_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tI8_141_a_b.html",
                "atom_labels": ["Nb", "Nb", "Nb", "Nb", "P", "P", "P", "P"],
                "atom_positions": [[0.0, 2.4937500000000004, 1.4225], [0.0, 0.83125, 9.957500000000001], [1.6625, 0.83125, 7.112500000000001], [1.6625, 2.4937500000000004, 4.2675], [0.0, 0.83125, 4.2675], [0.0, 2.4937500000000004, 7.112500000000001], [1.6625, 2.4937500000000004, 9.957500000000001], [1.6625, 0.83125, 1.4225]],
                "lattice_vectors": [[3.325, 0.0, 0.0], [0.0, 3.325, 0.0], [0.0, 0.0, 11.38]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}}
            },
            {
                "Notes": "Anatase (TiO<sub>2</sub>, C5) Structure",
                "Pearsons Symbol": "tI12",
                "Prototype": "O2Ti",
                "Space Group Number": 141,
                "Space Group Symbol": "$I4_{1}/amd$",
                "Strukturbericht Designation": "$C5$",
                "aflow_prototype_id": "A2B_tI12_141_e_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tI12_141_e_a.html",
                "atom_labels": ["Ti", "Ti", "Ti", "Ti", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 2.83875, 1.18925], [0.0, 0.94625, 8.32475], [1.8925, 0.94625, 5.946249999999999], [1.8925, 2.83875, 3.5677499999999998], [0.0, 0.94625, 0.7902328399999999], [0.0, 2.83875, 8.72376716], [0.0, 0.94625, 6.34526716], [0.0, 2.83875, 3.16873284], [1.8925, 2.83875, 5.5472328399999995], [1.8925, 0.94625, 3.9667671599999994], [1.8925, 2.83875, 1.58826716], [1.8925, 0.94625, 7.925732839999999]],
                "lattice_vectors": [[3.785, 0.0, 0.0], [0.0, 3.785, 0.0], [0.0, 0.0, 9.514]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "e": {"X_0": 2}}
            },
            {
                "Notes": "MoB (B<sub>g</sub>) Structure",
                "Pearsons Symbol": "tI16",
                "Prototype": "BMo",
                "Space Group Number": 141,
                "Space Group Symbol": "$I4_{1}/amd$",
                "Strukturbericht Designation": "$B_{g}$",
                "aflow_prototype_id": "AB_tI16_141_e_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_tI16_141_e_e.html",
                "atom_labels": ["B", "B", "B", "B", "B", "B", "B", "B", "Mo", "Mo", "Mo", "Mo", "Mo", "Mo", "Mo", "Mo"],
                "atom_positions": [[0.0, 0.777, 3.8453800000000005], [0.0, 2.331, 13.09462], [0.0, 0.777, 8.859620000000001], [0.0, 2.331, 8.08038], [1.554, 2.331, 12.315380000000001], [1.554, 0.777, 4.624620000000001], [1.554, 2.331, 0.3896199999999999], [1.554, 0.777, 16.55038], [0.0, 0.777, 1.20274], [0.0, 2.331, 15.737260000000003], [0.0, 0.777, 11.502260000000001], [0.0, 2.331, 5.437740000000001], [1.554, 2.331, 9.67274], [1.554, 0.777, 7.26726], [1.554, 2.331, 3.03226], [1.554, 0.777, 13.90774]],
                "lattice_vectors": [[3.108, 0.0, 0.0], [0.0, 3.108, 0.0], [0.0, 0.0, 16.94]],
                "normalized_wyckoff_matid": {"e": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "Zircon (ZrSiO<sub>4</sub>, $S1_{1}$) Structure",
                "Pearsons Symbol": "tI24",
                "Prototype": "O4SiZr",
                "Space Group Number": 141,
                "Space Group Symbol": "$I4_{1}/amd$",
                "Strukturbericht Designation": "$S1_{1}$",
                "aflow_prototype_id": "A4BC_tI24_141_h_b_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4BC_tI24_141_h_b_a.html",
                "atom_labels": ["Zr", "Zr", "Zr", "Zr", "Si", "Si", "Si", "Si", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 4.95315, 0.74745], [0.0, 1.65105, 5.23215], [3.3021, 1.65105, 3.7372499999999995], [3.3021, 4.95315, 2.24235], [0.0, 1.65105, 2.24235], [0.0, 4.95315, 3.7372499999999995], [3.3021, 4.95315, 5.23215], [3.3021, 1.65105, 0.74745], [0.0, 0.4358772, 1.1666199599999998], [0.0, 6.168322799999999, 4.812980039999999], [0.0, 3.7379772, 4.812980039999999], [0.0, 2.8662227999999996, 1.1666199599999998], [1.2151728, 1.65105, 3.3180800399999995], [1.2151728, 4.95315, 2.6615199599999997], [5.3890272, 4.95315, 2.6615199599999997], [5.3890272, 1.65105, 3.3180800399999995], [3.3021, 3.7379772, 4.15641996], [3.3021, 2.8662227999999996, 1.82318004], [3.3021, 0.4358772, 1.82318004], [3.3021, 6.168322799999999, 4.15641996], [4.5172728, 4.95315, 0.32828004], [4.5172728, 1.65105, 5.6513199599999995], [2.0869272, 1.65105, 5.6513199599999995], [2.0869272, 4.95315, 0.32828004]],
                "lattice_vectors": [[6.6042, 0.0, 0.0], [0.0, 6.6042, 0.0], [0.0, 0.0, 5.9796]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "h": {"X_0": 4}}
            },
            {
                "Notes": "$\\beta$&ndash;In<sub>2</sub>S<sub>3</sub> Crystal Structure",
                "Pearsons Symbol": "tI80",
                "Prototype": "In2S3",
                "Space Group Number": 141,
                "Space Group Symbol": "$I4_{1}/amd$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B3_tI80_141_ceh_3h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_tI80_141_ceh_3h.html",
                "atom_labels": ["In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "In", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 3.79685, 0.0], [1.898425, 1.898425, 24.263999999999996], [1.898425, 5.6952750000000005, 8.088], [5.6952750000000005, 5.6952750000000005, 8.088], [5.6952750000000005, 1.898425, 24.263999999999996], [3.79685, 3.79685, 16.176], [3.79685, 0.0, 16.176], [0.0, 1.898425, 6.612748799999999], [0.0, 5.6952750000000005, 25.739251199999998], [0.0, 1.898425, 17.651251199999997], [0.0, 5.6952750000000005, 14.7007488], [3.79685, 5.6952750000000005, 22.788748799999997], [3.79685, 1.898425, 9.563251199999998], [3.79685, 5.6952750000000005, 1.4752512], [3.79685, 1.898425, 30.876748799999998], [0.0, 3.9494833700000003, 10.753804799999997], [0.0, 3.64421663, 21.598195199999996], [0.0, 0.15263337000000005, 21.598195199999996], [0.0, 7.44106663, 10.753804799999997], [5.54264163, 1.898425, 13.5101952], [5.54264163, 5.6952750000000005, 18.8418048], [2.0510583700000002, 5.6952750000000005, 18.8418048], [2.0510583700000002, 1.898425, 13.5101952], [3.79685, 0.15263337000000005, 26.9298048], [3.79685, 7.44106663, 5.4221952], [3.79685, 3.9494833700000003, 5.4221952], [3.79685, 3.64421663, 26.9298048], [1.74579163, 5.6952750000000005, 29.686195199999997], [1.74579163, 1.898425, 2.6658048000000005], [5.84790837, 1.898425, 2.6658048000000005], [5.84790837, 5.6952750000000005, 29.686195199999997], [0.0, 3.9183492, 8.240054399999998], [0.0, 3.6753508, 24.1119456], [0.0, 0.12149920000000011, 24.1119456], [0.0, 7.4722008, 8.240054399999998], [5.5737758, 1.898425, 16.023945599999998], [5.5737758, 5.6952750000000005, 16.328054399999996], [2.0199242, 5.6952750000000005, 16.328054399999996], [2.0199242, 1.898425, 16.023945599999998], [3.79685, 0.12149920000000011, 24.416054399999997], [3.79685, 7.4722008, 7.9359456], [3.79685, 3.9183492, 7.9359456], [3.79685, 3.6753508, 24.416054399999997], [1.7769257999999999, 5.6952750000000005, 32.1999456], [1.7769257999999999, 1.898425, 0.15205439999999762], [5.8167742, 1.898425, 0.15205439999999762], [5.8167742, 5.6952750000000005, 32.1999456], [0.0, 3.7512878, 2.7790367999999996], [0.0, 3.8424122, 29.572963199999997], [0.0, 7.5481378, 29.572963199999997], [0.0, 0.04556220000000004, 2.7790367999999996], [5.7408372000000005, 1.898425, 21.4849632], [5.7408372000000005, 5.6952750000000005, 10.867036799999997], [1.8528628, 5.6952750000000005, 10.867036799999997], [1.8528628, 1.898425, 21.4849632], [3.79685, 7.5481378, 18.9550368], [3.79685, 0.04556220000000004, 13.3969632], [3.79685, 3.7512878, 13.3969632], [3.79685, 3.8424122, 18.9550368], [1.9439872, 5.6952750000000005, 5.308963199999999], [1.9439872, 1.898425, 27.043036799999996], [5.6497128, 1.898425, 27.043036799999996], [5.6497128, 5.6952750000000005, 5.308963199999999], [0.0, 3.5439797900000003, 13.4713728], [0.0, 4.04972021, 18.8806272], [0.0, 7.34082979, 18.8806272], [0.0, 0.25287021, 13.4713728], [5.94814521, 1.898425, 10.792627199999998], [5.94814521, 5.6952750000000005, 21.5593728], [1.6455547899999992, 5.6952750000000005, 21.5593728], [1.6455547899999992, 1.898425, 10.792627199999998], [3.79685, 7.34082979, 29.647372799999996], [3.79685, 0.25287021, 2.7046272], [3.79685, 3.5439797900000003, 2.7046272], [3.79685, 4.04972021, 29.647372799999996], [2.15129521, 5.6952750000000005, 26.968627199999997], [2.15129521, 1.898425, 5.383372799999996], [5.44240479, 1.898425, 5.383372799999996], [5.44240479, 5.6952750000000005, 26.968627199999997]],
                "lattice_vectors": [[7.5937, 0.0, 0.0], [0.0, 7.5937, 0.0], [0.0, 0.0, 32.352]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "e": {"X_1": 1}, "h": {"X_0": 6, "X_1": 2}}
            },
            {
                "Notes": "$\\beta$&ndash;Sn (A5) Structure",
                "Pearsons Symbol": "tI4",
                "Prototype": "Sn",
                "Space Group Number": 141,
                "Space Group Symbol": "$I4_{1}/amd$",
                "Strukturbericht Designation": "$A5$",
                "aflow_prototype_id": "A_tI4_141_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tI4_141_a.html",
                "atom_labels": ["Sn", "Sn", "Sn", "Sn"],
                "atom_positions": [[0.0, 4.37385, 0.3977375], [0.0, 1.45795, 2.7841625000000003], [2.9159, 1.45795, 1.9886875000000002], [2.9159, 4.37385, 1.1932125]],
                "lattice_vectors": [[5.8318, 0.0, 0.0], [0.0, 5.8318, 0.0], [0.0, 0.0, 3.1819]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}}
            },
            {
                "Notes": "$\\alpha$&ndash;ThSi<sub>2</sub> ($C_{c}$) Structure",
                "Pearsons Symbol": "tI12",
                "Prototype": "Si2Th",
                "Space Group Number": 141,
                "Space Group Symbol": "$I4_{1}/amd$",
                "Strukturbericht Designation": "$C_{c}$",
                "aflow_prototype_id": "A2B_tI12_141_e_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_tI12_141_e_a.ThSi2.html",
                "atom_labels": ["Th", "Th", "Th", "Th", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 3.0945, 1.79325], [0.0, 1.0315, 12.55275], [2.063, 1.0315, 8.96625], [2.063, 3.0945, 5.37975], [0.0, 1.0315, 4.181858999999999], [0.0, 3.0945, 10.164141], [0.0, 1.0315, 6.577641000000001], [0.0, 3.0945, 7.768358999999999], [2.063, 3.0945, 11.354859], [2.063, 1.0315, 2.9911410000000003], [2.063, 3.0945, 13.750641], [2.063, 1.0315, 0.5953590000000013]],
                "lattice_vectors": [[4.126, 0.0, 0.0], [0.0, 4.126, 0.0], [0.0, 0.0, 14.346]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "e": {"X_0": 2}}
            }
        ],
        142: [
            {
                "Notes": "PPrS<sub>4</sub> Structure",
                "Pearsons Symbol": "tI96",
                "Prototype": "PPrS4",
                "Space Group Number": 142,
                "Space Group Symbol": "$I4_{1}/acd$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC4_tI96_142_e_ab_2g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC4_tI96_142_e_ab_2g.html",
                "atom_labels": ["Pr", "Pr", "Pr", "Pr", "Pr", "Pr", "Pr", "Pr", "Pr", "Pr", "Pr", "Pr", "Pr", "Pr", "Pr", "Pr", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 2.7285, 7.260375], [5.457, 2.7285, 12.100625], [0.0, 2.7285, 16.940875000000002], [0.0, 8.1855, 12.100625], [5.457, 8.1855, 16.940875000000002], [0.0, 8.1855, 2.420125], [5.457, 8.1855, 7.260375], [5.457, 2.7285, 2.420125], [0.0, 2.7285, 2.420125], [5.457, 2.7285, 16.940875000000002], [0.0, 8.1855, 7.260375], [0.0, 8.1855, 16.940875000000002], [0.0, 2.7285, 12.100625], [5.457, 2.7285, 7.260375], [5.457, 8.1855, 12.100625], [5.457, 8.1855, 2.420125], [0.409275, 0.0, 4.84025], [5.866275, 5.457, 14.52075], [5.047725, 0.0, 14.52075], [10.504725, 5.457, 4.84025], [2.7285, 2.319225, 0.0], [2.7285, 8.594775, 9.6805], [8.1855, 7.776225, 9.6805], [8.1855, 3.1377749999999995, 0.0], [10.504725, 0.0, 14.52075], [0.409275, 5.457, 14.52075], [2.7285, 3.1377749999999995, 9.6805], [8.1855, 2.319225, 9.6805], [5.047725, 5.457, 4.84025], [5.866275, 0.0, 4.84025], [8.1855, 8.594775, 0.0], [2.7285, 7.776225, 0.0], [2.7088548, 3.4892057999999997, 17.682401300000002], [8.1658548, 1.9677942000000002, 1.6785987], [2.7481452, 3.4892057999999997, 1.6785987], [8.2051452, 1.9677942000000002, 17.682401300000002], [10.1532942, 0.019645199999999956, 6.5188487], [10.1532942, 10.894354799999999, 3.1616513], [0.760705800000001, 5.4766452, 3.1616513], [0.760705800000001, 5.4373548, 6.5188487], [8.2051452, 7.4247942, 1.6785987], [8.2051452, 3.4892057999999997, 8.0019013], [2.7088548, 1.9677942000000002, 8.0019013], [2.7088548, 8.9462058, 1.6785987], [6.2177058, 5.4373548, 3.1616513], [0.760705800000001, 0.019645199999999956, 16.1993487], [10.1532942, 5.4373548, 16.1993487], [4.6962942, 0.019645199999999956, 3.1616513], [8.1658548, 8.9462058, 8.0019013], [2.7088548, 7.4247942, 11.3590987], [8.2051452, 8.9462058, 11.3590987], [2.7481452, 7.4247942, 8.0019013], [4.6962942, 5.4766452, 16.1993487], [4.6962942, 5.4373548, 12.842151300000001], [6.2177058, 0.019645199999999956, 12.842151300000001], [6.2177058, 10.894354799999999, 16.1993487], [2.7481452, 1.9677942000000002, 11.3590987], [2.7481452, 8.9462058, 17.682401300000002], [8.1658548, 7.4247942, 17.682401300000002], [8.1658548, 3.4892057999999997, 11.3590987], [0.760705800000001, 10.894354799999999, 12.842151300000001], [6.2177058, 5.4766452, 6.5188487], [4.6962942, 10.894354799999999, 6.5188487], [10.1532942, 5.4766452, 12.842151300000001], [1.0073622, 1.2190938, 0.0484025], [6.4643622, 4.237906199999999, 19.312597500000003], [4.4496378, 1.2190938, 19.312597500000003], [9.906637799999999, 4.237906199999999, 0.0484025], [1.5094062, 1.7211378, 4.7918475], [1.5094062, 9.1928622, 4.8886525], [9.4045938, 7.178137799999999, 4.8886525], [9.4045938, 3.7358621999999997, 4.7918475], [9.906637799999999, 9.6949062, 19.312597500000003], [9.906637799999999, 1.2190938, 9.728902499999998], [1.0073622, 4.237906199999999, 9.728902499999998], [1.0073622, 6.6760938, 19.312597500000003], [3.9475938, 3.7358621999999997, 4.8886525], [9.4045938, 1.7211378, 14.472347500000001], [1.5094062, 3.7358621999999997, 14.472347500000001], [6.9664062, 1.7211378, 4.8886525], [6.4643622, 6.6760938, 9.728902499999998], [1.0073622, 9.6949062, 9.6320975], [9.906637799999999, 6.6760938, 9.6320975], [4.4496378, 9.6949062, 9.728902499999998], [6.9664062, 7.178137799999999, 14.472347500000001], [6.9664062, 3.7358621999999997, 14.5691525], [3.9475938, 1.7211378, 14.5691525], [3.9475938, 9.1928622, 14.472347500000001], [4.4496378, 4.237906199999999, 9.6320975], [4.4496378, 6.6760938, 0.0484025], [6.4643622, 9.6949062, 0.0484025], [6.4643622, 1.2190938, 9.6320975], [9.4045938, 9.1928622, 14.5691525], [3.9475938, 7.178137799999999, 4.7918475], [6.9664062, 9.1928622, 4.7918475], [1.5094062, 7.178137799999999, 14.5691525]],
                "lattice_vectors": [[10.914, 0.0, 0.0], [0.0, 10.914, 0.0], [0.0, 0.0, 19.361]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_1": 1}, "e": {"X_2": 2}, "g": {"X_0": 8}}
            },
            {
                "Notes": "S&ndash;III Structure",
                "Pearsons Symbol": "tI16",
                "Prototype": "S",
                "Space Group Number": 142,
                "Space Group Symbol": "$I4_{1}/acd$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_tI16_142_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_tI16_142_f.html",
                "atom_labels": ["S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[1.2074429500000001, 3.35591795, 0.4522375], [5.504392950000001, 0.9410320499999999, 3.1656625000000003], [3.08950705, 3.35591795, 3.1656625000000003], [7.386457049999999, 0.9410320499999999, 0.4522375], [7.386457049999999, 7.65286795, 1.3567125], [1.2074429500000006, 5.237982049999999, 1.3567125], [7.386457049999999, 5.237982049999999, 3.1656625000000003], [7.386457049999999, 3.35591795, 2.2611875], [1.2074429500000001, 0.9410320499999999, 2.2611875], [1.2074429500000001, 7.65286795, 3.1656625000000003], [5.504392950000001, 3.35591795, 1.3567125], [3.08950705, 0.9410320499999999, 1.3567125], [5.504392950000001, 7.65286795, 2.2611875], [3.08950705, 5.237982049999999, 2.2611875], [3.08950705, 7.65286795, 0.4522375], [5.504392950000001, 5.237982049999999, 0.4522375]],
                "lattice_vectors": [[8.5939, 0.0, 0.0], [0.0, 8.5939, 0.0], [0.0, 0.0, 3.6179]],
                "normalized_wyckoff_matid": {"f": {"X_0": 1}}
            }
        ],
        143: [
            {
                "Notes": "MoS<sub>2</sub> Structure",
                "Pearsons Symbol": "hP12",
                "Prototype": "MoS2",
                "Space Group Number": 143,
                "Space Group Symbol": "$P3$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_hP12_143_cd_ab2d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_hP12_143_cd_ab2d.html",
                "atom_labels": ["S", "S", "Mo", "Mo", "Mo", "Mo", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [-3.2501929683275885e-05, 3.753018335503525, 3.070182281], [3.2502254703796845, 1.8764810202549838, 1.5350911405], [-0.5145055469056347, 1.5081428774077046, 1.5350911405], [2.2013556975311865, 4.4298530430463705, 1.5350911405], [-1.6868501506255487, 5.321002791062943, 1.5350911405], [1.625063982295316, 0.9382686576242707, 3.070182281], [4.875289452675, 0.9382123626307131, 3.070182281], [3.2502254703796853, 3.753018335503525, 3.070182281], [-1.6250964842249993, 2.8147496778792545, 0.0], [1.6250964842250006, 2.8147496778792545, 0.0], [3.25019296845, 0.0, 0.0]],
                "lattice_vectors": [[6.5003859369, 0.0, 0.0], [-3.2501929684499986, 5.629499355758509, 0.0], [0.0, 0.0, 6.140364562]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 1}, "c": {"X_1": 1}, "d": {"X_0": 6, "X_1": 3}}
            },
            {
                "Notes": "Simpsonite (Ta<sub>3</sub>Al<sub>4</sub>O<sub>13</sub>[OH]) Structure",
                "Pearsons Symbol": "hP21",
                "Prototype": "Al4H]OO13[Ta3",
                "Space Group Number": 143,
                "Space Group Symbol": "$P3$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B14C3_hP21_143_bd_ac4d_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B14C3_hP21_143_bd_ac4d_d.html",
                "atom_labels": ["O", "Al", "O", "Al", "Al", "Al", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Ta", "Ta", "Ta"],
                "atom_positions": [[0.0, 0.0, 0.0], [-3.690693962214431e-05, 4.261667613550125, 1.3774523912315], [3.6907308692896246, 2.1308018444277725, 2.2445699621051], [3.0116062732776, 0.5753222512180107, 1.3639036791866], [5.377341103143951, 2.3204664132459767, 1.3639036791866], [2.6831345106284514, 3.4966807935139097, 1.3639036791866], [-1.590689097772849, 3.867444022076628, 2.4207032186888], [1.136733740403801, 3.0811702787453465, 2.4207032186888], [0.4539553573690515, 5.836324615133821, 2.4207032186888], [1.6497402011704503, 0.37715569802069593, 2.6329663740588996], [6.2298914084468, 1.2401390748477121, 2.6329663740588996], [3.1924502774327514, 4.77517468510949, 2.6329663740588996], [-0.5425320124654492, 2.742369397472518, 0.361298987864], [1.5869984038105014, 4.551438254080263, 0.361298987864], [-1.044466391345048, 5.491131264403014, 0.361298987864], [2.1848908257112005, 1.8921709595614575, 0.32065285172929997], [4.650274392561, 0.946085479780729, 0.32065285172929997], [4.236916668777801, 3.5542130186357115, 0.32065285172929997], [0.6174530999011555, 1.7624038295645064, 3.6400873027298], [1.8556809242695813, 6.045997613355495, 3.6400873027298], [-2.473134024170734, 4.976537473035793, 3.6400873027298]],
                "lattice_vectors": [[7.3813879247, 0.0, 0.0], [-3.6906939623499984, 6.392469457977898, 0.0], [0.0, 0.0, 4.5162373483]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 1}, "c": {"X_1": 1}, "d": {"X_0": 12, "X_1": 3, "X_2": 3}}
            },
            {
                "Notes": "ScRh<sub>6</sub>P<sub>4</sub> Structure",
                "Pearsons Symbol": "hP11",
                "Prototype": "P4Rh6Sc",
                "Space Group Number": 143,
                "Space Group Symbol": "$P3$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B6C_hP11_143_bd_2d_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B6C_hP11_143_bd_2d_a.html",
                "atom_labels": ["Sc", "P", "P", "P", "P", "Rh", "Rh", "Rh", "Rh", "Rh", "Rh"],
                "atom_positions": [[0.0, 0.0, 0.0014662461094], [-3.48363437333155e-05, 4.022574599311614, 3.6630493428085495], [5.032806579323216, 1.15547877625838, 1.8320745136953], [3.450191483464881, 3.7807989618981774, 1.8320745136953], [1.967905057561905, 1.0975539916522155, 1.8320745136953], [2.1424351396717505, 2.8962392303082107, 0.0010996845820499999], [3.3878344281801254, 0.4072836417620922, 0.0010996845820499999], [4.920633552498126, 2.7303088577384695, 0.0010996845820499999], [-1.488208604337839, 4.821031552117209, 1.8335407598046998], [0.05260287903909505, 2.3344894962630143, 1.8335407598046998], [1.4356057252987462, 4.912142411237322, 1.8335407598046998]],
                "lattice_vectors": [[6.9672687469, 0.0, 0.0], [-3.483634373449999, 6.033831729808773, 0.0], [0.0, 0.0, 3.6656152735]]
            }
        ],
        144: [
            {
                "Notes": "IrGe<sub>4</sub> Structure",
                "Pearsons Symbol": "hP15",
                "Prototype": "Ge4Ir",
                "Space Group Number": 144,
                "Space Group Symbol": "$P3_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B_hP15_144_4a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B_hP15_144_4a_a.html",
                "atom_labels": ["Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge", "Ir", "Ir", "Ir"],
                "atom_positions": [[2.36609636376654, 1.1809100163014026, 1.76544542092212], [4.00937421661622, 1.458644550673109, 4.360162382888787], [2.9472101279172405, 2.7428976495314257, 6.954879344855453], [-0.1308282859398094, 2.622868965103343, 0.88895003116978], [0.9015032244926107, 3.957717114796815, 3.483666993136447], [-0.7706749385527987, 4.184318353111715, 6.078383955103113], [0.47794276431218, 0.0064589426598071235, 0.0], [5.97055548161893, 0.4106811041194029, 2.5947169619666663], [2.8741824623688914, 4.965312169726726, 5.189433923933333], [3.7850083675698, 0.007535433103108311, 0.01401147159462], [4.316090411919291, 3.2741456833005613, 2.6087284335612866], [1.2215819288109102, 2.100771100102267, 5.203445395527953], [1.97267923787628, 0.004305961773204749, 3.94033717844258], [5.22505178097854, 1.706237352632382, 6.535054140409246], [2.124949689445182, 3.6719089021003493, 1.3456202164759137]],
                "lattice_vectors": [[6.2151204722, 0.0, 0.0], [-3.1075602360999985, 5.3824522165059365, 0.0], [0.0, 0.0, 7.7841508859]]
            },
            {
                "Notes": "ZnTe (High&ndash;pressure) Structure",
                "Pearsons Symbol": "hP6",
                "Prototype": "TeZn",
                "Space Group Number": 144,
                "Space Group Symbol": "$P3_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_hP6_144_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP6_144_a_a.html",
                "atom_labels": ["Te", "Te", "Te", "Zn", "Zn", "Zn"],
                "atom_positions": [[1.0113124353750003, 0.5605262465266294, 1.8404876261328], [3.0541635548325, 0.5955591369345438, 4.9546798869328], [2.0023986220425005, 2.3472036573302604, 8.0688721477328], [-0.12135749224499973, 1.1210524930532588, 0.0], [1.1124436789125003, 2.8376641230410615, 3.1141922608], [-0.9910861866674991, 3.0478614654885474, 6.2283845216]],
                "lattice_vectors": [[4.0452497415, 0.0, 0.0], [-2.022624870749999, 3.503289040791434, 0.0], [0.0, 0.0, 9.3425767824]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}}
            }
        ],
        145: [
            {
                "Notes": "Sheldrickite (NaCa<sub>3</sub>[CO<sub>3</sub>]<sub>2</sub>F<sub>3</sub>[H<sub>2</sub>O]) Structure",
                "Pearsons Symbol": "hP48",
                "Prototype": "CCa3[F3[H2NaO3]2O]",
                "Space Group Number": 145,
                "Space Group Symbol": "$P3_{2}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B3C3DE7_hP48_145_2a_3a_3a_a_7a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3C3DE7_hP48_145_2a_3a_3a_a_7a.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "F", "F", "F", "F", "F", "F", "F", "F", "F", "Na", "Na", "Na", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[2.9728975883385997, -1.4562244538182798, 2.5273967509056003], [-0.22532142355054996, 3.302717061259859, 12.556748937038984], [-2.74757616478805, -1.8464926074415788, 7.542072843972217], [3.9817994848336, 1.8639673008873985, 2.5424407791848003], [-3.6051427768088, 2.516355856197988, 12.571792965318185], [-0.37665670802479995, -4.380323157085386, 7.557116872251417], [2.06892148907908, -3.593961952023515, 0.0], [2.078001606147535, 3.5887195439897694, 10.029352186133384], [-4.146923095226615, 0.005242408033745679, 5.014676093066616], [2.109613865571045, 3.6667731747144288, 0.0676981272564], [-4.230325652003534, -0.006407387596800314, 10.097050313389785], [2.12071178643249, -3.6603657871176285, 5.0823742203230164], [2.49400548813564, 0.002329959126109215, -0.06468932160056], [-1.2490205478608098, 2.1587071303402183, 9.964662864532825], [-1.2449849402748299, -2.1610370894663276, 4.949986771466057], [0.88447066259395, 1.5668975123084694, 0.150440282792], [-1.79920838208275, -0.017474693445819423, 10.179792468925383], [0.9147377194888, -1.54942281886265, 5.1651163758586165], [0.91810072581045, -1.5668975123084696, -0.075220141396], [0.8979226878805501, 1.5785473079390155, 9.954132044737383], [-1.816023413691, -0.011649795630546252, 4.939455951670617], [4.9234412548956, 0.023299591261092663, -0.300880565584], [-2.4818986653776998, 4.252175405149377, 9.728471620549385], [-2.4415425895179, -4.27547499641047, 4.713795527482617], [1.0021758838516999, 1.7241697533208435, 2.482264666068], [-1.9942627487384499, 0.005824897815273143, 12.511616852201383], [0.9920868648867499, -1.7299946511361166, 7.496940759134617], [3.4033623975098, -1.8406677096263062, 1.353962545128], [-0.10761620229279986, 3.8677321493413515, 11.383314731261384], [-3.295746195217, -2.027064439715046, 6.368638638194617], [3.36636932797165, -1.9513407681164956, 3.5804787304496], [0.0067260126433001, 3.891031740602444, 13.609830916582984], [-3.37309534061495, -1.939690972485949, 8.595154823516218], [2.1052419573529, -0.46599182522184956, 2.5123527226264004], [-0.64906022007845, 2.0561889287914115, 12.541704908759785], [-1.4561817372744499, -1.5901971035695617, 7.527028815693017], [3.27893116360875, 1.9396909724859492, -1.3840506016864], [-3.31928723946855, 1.8697921987026718, 8.645301584446983], [0.04035607585979994, -3.809483171188621, 3.6306254913802167], [3.3697323342933, 1.9222162790401298, 11.448505520471201], [-3.3495542963634, 1.9571656659317682, 21.477857706604585], [-0.020178037929899948, -3.8793819449718985, 16.463181613537817], [1.9068245843755502, -4.223050916073012, 2.482264666068], [2.7038570826066, 3.7628839886664354, 12.511616852201383], [-4.61068166698215, 0.46016692740657617, 7.496940759134617], [1.36201756026825, -0.005824897815273108, 12.5015875000152], [-0.67596427065165, 1.1824542565004434, 22.530939686148585], [-0.6860532896166001, -1.1766293586851704, 17.516263593081817]],
                "lattice_vectors": [[3.36300632165, -5.82489781527312, 0.0], [3.36300632165, 5.82489781527312, 0.0], [0.0, 0.0, 15.0440282792]],
                "normalized_wyckoff_matid": {"a": {"X_0": 7, "X_1": 3, "X_2": 3, "X_3": 2, "X_4": 1}}
            }
        ],
        146: [
            {
                "Notes": "$\\gamma$&ndash;Ag<sub>3</sub>SI (Low&ndash;temperature) Structure",
                "Pearsons Symbol": "hR5",
                "Prototype": "Ag3IS",
                "Space Group Number": 146,
                "Space Group Symbol": "$R3$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3BC_hR5_146_b_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3BC_hR5_146_b_a_a.html",
                "atom_labels": ["I", "I", "I", "S", "S", "S", "Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "Ag"],
                "atom_positions": [[0.0, 0.0, 3.963729492162], [7.195328538304549e-16, 3.9755500696685973, 1.1525738239620005], [3.44292735435, 1.9877750348342986, 6.7748851603619995], [0.0, 0.0, 0.0], [7.195328538304549e-16, 3.9755500696685973, 5.6223113364], [3.44292735435, 1.9877750348342986, 2.8111556682], [2.1827815133843567, 0.6957411399423529, 0.9670656614174821], [5.1919344503598, 1.5424736715307192, 0.9670656614174821], [2.954066099305844, 3.7251102930298248, 0.9670656614174821], [2.1827815133843576, 4.67129120961095, 6.589376997817482], [-1.6939202583401987, 5.5180237411993165, 6.589376997817482], [-0.4888612550441562, 1.7373352581955253, 6.589376997817482], [-1.2601458409656427, 2.6835161747766514, 3.778221329617482], [1.749007096009801, 3.5302487063650183, 3.778221329617482], [-0.4888612550441557, 5.7128853278641225, 3.778221329617482]],
                "lattice_vectors": [[6.8858547087, 0.0, 0.0], [-3.4429273543499987, 5.963325104502896, 0.0], [0.0, 0.0, 8.4334670046]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1, "X_2": 1}, "b": {"X_0": 3}}
            },
            {
                "Notes": "FePSe<sub>3</sub> Structure",
                "Pearsons Symbol": "hR10",
                "Prototype": "FePSe3",
                "Space Group Number": 146,
                "Space Group Symbol": "$R3$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC3_hR10_146_2a_2a_2b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC3_hR10_146_2a_2a_2b.html",
                "atom_labels": ["Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "P", "P", "P", "P", "P", "P", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se", "Se"],
                "atom_positions": [[0.0, 0.0, 7.74364384354108], [1.0041021689018621e-15, 3.6170358381654273, 1.143759889274415], [3.1324449222500004, 1.8085179190827136, 14.343527797807747], [0.0, 0.0, 14.36662739164768], [1.0041021689018621e-15, 3.6170358381654273, 7.766743437381011], [3.1324449222500004, 1.8085179190827136, 1.1668594831143457], [0.0, 0.0, 2.24132059086896], [1.0041021689018621e-15, 3.6170358381654273, 15.441088499402293], [3.1324449222500004, 1.8085179190827136, 8.841204545135627], [0.0, 0.0, 0.0], [1.0041021689018621e-15, 3.6170358381654273, 13.199767908533333], [3.1324449222500004, 1.8085179190827136, 6.599883954266667], [-1.0293214014513494, 1.8023689581578326, 2.84323000749808], [2.086208318218501, 3.6329507958533553, 2.84323000749808], [-1.0568869167671486, 5.415787760485094, 2.84323000749808], [-1.029321401451348, 5.41940479632326, 16.042997916031414], [-1.0462366040314997, 1.8244328767706417, 16.042997916031414], [2.0755580054828506, 3.6072698414023807, 16.042997916031414], [2.1031235207986505, 3.6108868772405462, 9.443113961764746], [2.0862083182185, 0.015914957687927937, 9.443113961764746], [5.20800292773285, 1.7987519223196669, 9.443113961764746], [0.9096620054214004, 1.7459431990824517, 6.118092425605201], [1.165582755569227, 5.340372563259345, 6.118092425605201], [-2.075244760990624, 3.764791752154485, 6.118092425605201], [0.909662005421401, 5.362979037247879, 19.317860334138533], [-1.9668621666807742, 3.531854644176632, 19.317860334138533], [1.0572001612593755, 1.9562738330717715, 19.317860334138533], [4.042106927671401, 3.554461118165166, 12.717976379871867], [1.1655827555692255, 1.723336725093918, 12.717976379871867], [4.189645083509374, 0.1477559139890577, 12.717976379871867]],
                "lattice_vectors": [[6.2648898445, 0.0, 0.0], [-3.1324449222499986, 5.425553757248141, 0.0], [0.0, 0.0, 19.7996518628]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1, "X_2": 1}, "b": {"X_0": 3}}
            }
        ],
        147: [
            {
                "Notes": "$\\zeta$&ndash;AgZn (B<sub>b</sub>) Structure",
                "Pearsons Symbol": "hP9",
                "Prototype": "AgZn",
                "Space Group Number": 147,
                "Space Group Symbol": "$P\\bar{3}$",
                "Strukturbericht Designation": "$B_{b}$",
                "aflow_prototype_id": "A2B_hP9_147_g_ad",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_hP9_147_g_ad.html",
                "atom_labels": ["Zn", "Zn", "Zn", "Ag", "Ag", "Ag", "Ag", "Ag", "Ag"],
                "atom_positions": [[0.0, 0.0, 0.0], [-3.8179999998608986e-05, 4.40866869876526, 0.704925], [3.8180381800000003, 2.204301284532714, 2.114775], [2.54530788, 0.0, 0.704925], [-1.2726539399999994, 2.204301284532714, 0.704925], [2.5453460600000013, 4.40866869876526, 0.704925], [5.09069212, 0.0, 2.114775], [-2.5453460599999986, 4.40866869876526, 2.114775], [1.2726539400000008, 2.204301284532714, 2.114775]],
                "lattice_vectors": [[7.636, 0.0, 0.0], [-3.8179999999999983, 6.612969983297974, 0.0], [0.0, 0.0, 2.8197]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_1": 2}, "g": {"X_0": 6}}
            }
        ],
        148: [
            {
                "Notes": "BiI<sub>3</sub> (D0<sub>5</sub>) Structure",
                "Pearsons Symbol": "hR8",
                "Prototype": "BiI3",
                "Space Group Number": 148,
                "Space Group Symbol": "$R\\bar{3}$",
                "Strukturbericht Designation": "$D0_{5}$",
                "aflow_prototype_id": "AB3_hR8_148_c_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_hR8_148_c_f.html",
                "atom_labels": ["Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I", "I"],
                "atom_positions": [[0.0, 0.0, 6.894007725900001], [0.0, 0.0, 13.7882222741], [1.0268870938764015e-15, 4.327967728915424, 20.682161059233334], [1.0268870938764015e-15, 4.327967728915424, 6.894145607433332], [3.74813, 2.163983864457712, 13.788084392566669], [3.74813, 2.163983864457712, 6.894076666597022e-05], [-2.500002709999999, 4.330131712779882, 1.8200362399999999], [1.2481272900000007, 2.1618198805932543, 1.8200362399999999], [5.000005420000001, 0.0, 1.8200362399999999], [-1.2481272899999993, 2.1618198805932543, 18.86219376], [2.5000027100000017, 4.330131712779882, 18.86219376], [2.49625458, 0.0, 18.86219376], [1.24812729, 2.1661478483221708, 15.608189573333332], [1.2481272900000013, 6.489787609508679, 15.608189573333332], [-2.496254579999999, 4.327967728915424, 15.608189573333332], [-1.2481272899999982, 6.489787609508679, 11.968117093333333], [-1.2481272900000002, 2.1661478483221708, 11.968117093333333], [2.4962545800000004, 4.327967728915424, 11.968117093333333], [4.99625729, 0.002163983864457474, 8.714112906666667], [4.996257290000002, 4.325803745050966, 8.714112906666667], [1.2518754200000015, 2.163983864457712, 8.714112906666667], [2.5000027100000013, 4.325803745050966, 5.0740404266666665], [2.5000027100000013, 0.002163983864457474, 5.0740404266666665], [6.244384580000001, 2.163983864457712, 5.0740404266666665]],
                "lattice_vectors": [[7.49626, 0.0, 0.0], [-3.7481299999999984, 6.491951593373137, 0.0], [0.0, 0.0, 20.68223]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "f": {"X_0": 3}}
            },
            {
                "Notes": "PdAl Structure",
                "Pearsons Symbol": "hR26",
                "Prototype": "AlPd",
                "Space Group Number": 148,
                "Space Group Symbol": "$R\\bar{3}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_hR26_148_b2f_a2f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hR26_148_b2f_a2f.html",
                "atom_labels": ["Pd", "Pd", "Pd", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd"],
                "atom_positions": [[0.0, 0.0, 0.0], [2.6582254915770894e-15, 9.04072786524035, 3.5006666666666666], [7.829500000000001, 4.520363932620175, 1.7503333333333333], [0.0, 0.0, 2.6255], [2.6582254915770894e-15, 9.04072786524035, 0.875166666666666], [7.829500000000001, 4.520363932620175, 4.3758333333333335], [13.372786000000001, 0.9221542422545159, 0.871666], [8.173998000000001, 11.120095274245633, 0.871666], [1.9417159999999998, 1.5188422813603788, 0.871666], [-5.543285999999997, 12.638937555606011, 4.379334], [-0.34449799999999886, 2.4409965236148943, 4.379334], [5.887784000000004, 12.042249516500148, 4.379334], [-2.286213999999996, 9.962882107494867, 4.372332666666667], [0.34449799999999997, 6.599731341625459, 4.372332666666667], [1.9417160000000007, 10.55957014660073, 4.372332666666667], [2.2862140000000024, 8.118573622985835, 2.6290006666666663], [-0.3444979999999964, 11.481724388855245, 2.6290006666666663], [-1.941715999999998, 7.521885583879972, 2.6290006666666663], [5.543286000000001, 5.442518174874691, 2.621999333333333], [8.173998000000001, 2.0793674090052807, 2.621999333333333], [9.771216, 6.039206213980555, 2.621999333333333], [10.115714, 3.5982096903656595, 0.8786673333333332], [7.4850020000000015, 6.961360456235068, 0.8786673333333332], [5.887784000000003, 3.0015216512597975, 0.8786673333333332], [4.674289795000003, 7.734297485073794, 0.8944028300000001], [6.6237569999999995, 0.18090496458345967, 0.8944028300000001], [12.190453205, 5.645889348203273, 0.8944028300000001], [3.1552102050000013, 5.826794312786733, 4.356597170000001], [1.2057430000000031, 13.380186833277067, 4.356597170000001], [-4.360953204999998, 7.915202449657254, 4.356597170000001], [12.503789795000001, 3.2139335524536197, 4.395069496666666], [6.623757000000001, 9.221632829823811, 4.395069496666666], [4.360953205, 1.1255254155830967, 4.395069496666666], [10.984710205, 1.3064303801665564, 2.606263836666667], [9.035243000000003, 8.85982290065689, 2.606263836666667], [3.4685467950000013, 3.394838517037078, 2.606263836666667], [-3.1552102049999964, 12.254661417693969, 2.6447361633333335], [-1.2057429999999993, 4.701268897203636, 2.6447361633333335], [4.360953205000002, 10.16625328082345, 2.6447361633333335], [-4.674289794999997, 10.347158245406908, 0.8559305033333332], [1.2057430000000027, 4.339458968036716, 0.8559305033333332], [3.468546795000002, 12.43556638227743, 0.8559305033333332], [-2.2628037949999977, 9.949366219336333, 1.7468501700000003], [0.344498000000001, 6.626763117942525, 1.7468501700000003], [1.9183057950000024, 10.546054258442195, 1.7468501700000003], [10.092303795000001, 3.6117255785241937, 3.5041498300000002], [7.485002000000003, 6.934328679918003, 3.5041498300000002], [5.911194205000001, 3.015037539418331, 3.5041498300000002], [5.566696205000002, 5.429002286716156, 5.247516836666667], [8.173998, 2.1063991853223487, 5.247516836666667], [9.747805795000003, 6.02569032582202, 5.247516836666667], [-5.566696204999997, 12.652453443764545, 1.7538164966666665], [-0.3444979999999997, 2.413964747297826, 1.7538164966666665], [5.911194205000004, 12.055765404658683, 1.7538164966666665], [13.396196205, 0.9086383540959811, 3.4971835033333334], [8.173998000000003, 11.147127050562702, 3.4971835033333334], [1.9183057950000004, 1.5053263932018446, 3.4971835033333334], [2.2628037950000026, 8.132089511144368, 0.003483163333333125], [-0.34449799999999925, 11.454692612538178, 0.003483163333333125], [-1.9183057949999984, 7.535401472038506, 0.003483163333333125], [-3.155366794999997, 12.254751824972622, 0.008769170000000001], [-1.2057429999999985, 4.70108808264633, 0.008769170000000001], [4.3611097950000035, 10.166343688102103, 0.008769170000000001], [10.984866795000002, 1.3063399728879046, 5.2422308300000005], [9.035243000000003, 8.860003715214198, 5.2422308300000005], [3.4683902050000004, 3.394748109758426, 5.2422308300000005], [4.674133205000002, 7.734387892352446, 3.5094358366666665], [6.623757000000001, 0.1807241500261522, 3.5094358366666665], [12.190609795000002, 5.6459797554819255, 3.5094358366666665], [-4.674133204999998, 10.347067838128256, 3.491897496666667], [1.2057430000000007, 4.339639782594021, 3.491897496666667], [3.4683902050000026, 12.435475974998777, 3.491897496666667], [12.503633205000002, 3.214023959732271, 1.7591025033333334], [6.623757000000003, 9.221452015266504, 1.7591025033333334], [4.361109795000001, 1.1256158228617497, 1.7591025033333334], [3.1553667950000017, 5.826703905508079, 1.7415641633333334], [1.2057430000000025, 13.380367647834372, 1.7415641633333334], [-4.361109795000001, 7.915112042378601, 1.7415641633333334]],
                "lattice_vectors": [[15.659, 0.0, 0.0], [-7.829499999999997, 13.561091797860527, 0.0], [0.0, 0.0, 5.251]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}, "f": {"X_0": 12, "X_1": 12}}
            },
            {
                "Notes": "Ilmenite (FeTiO<sub>3</sub>, $E2_{2}$) Structure",
                "Pearsons Symbol": "hR10",
                "Prototype": "FeO3Ti",
                "Space Group Number": 148,
                "Space Group Symbol": "$R\\bar{3}$",
                "Strukturbericht Designation": "$E2_{2}$",
                "aflow_prototype_id": "AB3C_hR10_148_c_f_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3C_hR10_148_c_f_c.html",
                "atom_labels": ["Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 5.005564135], [0.0, 0.0, 9.079935865], [9.083178653668256e-16, 2.9377891097444917, 0.31039746833333387], [9.083178653668256e-16, 2.9377891097444917, 4.384769198333332], [2.5442000000000005, 1.4688945548722459, 9.700730801666667], [2.5442000000000005, 1.4688945548722459, 13.775102531666667], [0.0, 0.0, 2.0621172], [0.0, 0.0, 12.0233828], [9.083178653668256e-16, 2.9377891097444917, 11.452450533333332], [9.083178653668256e-16, 2.9377891097444917, 7.328216133333333], [2.5442000000000005, 1.4688945548722459, 6.757283866666667], [2.5442000000000005, 1.4688945548722459, 2.6330494666666664], [4.221463850000001, 1.2960497326004288, 3.45179263], [1.8552560820000008, 3.007870068957447, 3.45179263], [1.555880068, 0.10276386305886233, 3.45179263], [-1.677263849999999, 3.110633932016309, 10.63370737], [0.6889439180000003, 1.398813595659291, 10.63370737], [0.9883199320000013, 4.303919801557876, 10.63370737], [-0.8669361499999988, 4.2338388423449205, 12.842125963333332], [-0.6889439179999994, 1.5389755140852006, 12.842125963333332], [1.5558800680000011, 3.0405529728033542, 12.842125963333332], [0.8669361500000006, 1.641739377144063, 5.938540703333333], [0.6889439180000017, 4.336602705403783, 5.938540703333333], [-1.5558800679999991, 2.835025246685629, 5.938540703333333], [1.6772638500000008, 2.764944287472675, 8.146959296666667], [1.855256082, 0.07008095921295482, 8.146959296666667], [4.100080068, 1.5716584179311082, 8.146959296666667], [3.41113615, 0.17284482227181716, 1.2433740366666663], [3.233143918, 2.867708150531537, 1.2433740366666663], [0.9883199320000005, 1.3661306918133835, 1.2433740366666663]],
                "lattice_vectors": [[5.0884, 0.0, 0.0], [-2.5441999999999987, 4.406683664616738, 0.0], [0.0, 0.0, 14.0855]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1, "X_2": 1}, "f": {"X_0": 3}}
            },
            {
                "Notes": "Solid Cubane (C<sub>8</sub>H<sub>8</sub>) Structure",
                "Pearsons Symbol": "hR16",
                "Prototype": "C8H8",
                "Space Group Number": 148,
                "Space Group Symbol": "$R\\bar{3}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_hR16_148_cf_cf",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hR16_148_cf_cf.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "H", "H", "H", "H", "H", "H", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[0.0, 0.0, 1.3547683836], [0.0, 0.0, 10.3788916164], [1.0046987316177555e-15, 3.6356497006220683, 9.1772083836], [1.0046987316177555e-15, 3.6356497006220683, 6.4676716164], [3.1485650000000005, 1.8178248503110341, 5.2659883836], [3.1485650000000005, 1.8178248503110341, 2.5564516164], [0.0, 0.0, 2.4640686], [0.0, 0.0, 9.269591400000001], [1.0046987316177555e-15, 3.6356497006220683, 10.2865086], [1.0046987316177555e-15, 3.6356497006220683, 5.3583714], [3.1485650000000005, 1.8178248503110341, 6.3752886], [3.1485650000000005, 1.8178248503110341, 1.4471513999999999], [-2.222351633949999, 4.598315206601283, 0.4503378708], [0.27748303345000047, 1.2297039764899051, 0.4503378708], [1.9448686005000013, 5.078929918775017, 0.4503378708], [5.37091663395, 0.8551593443318198, 11.2833221292], [2.8710819665500007, 4.223770574443198, 11.2833221292], [1.2036963995, 0.37454463215808553, 11.2833221292], [0.9262133660500009, 2.7804903562902483, 8.272777870799999], [0.2774830334500016, 4.865353677111973, 8.272777870799999], [-1.2036963994999994, 3.261105068463983, 8.272777870799999], [-0.9262133660499989, 4.490809044953888, 7.3721021292], [-0.2774830334499995, 2.4059457241321636, 7.3721021292], [1.2036963995000007, 4.010194332780154, 7.3721021292], [4.07477836605, 0.9626655059792145, 4.3615578708000005], [3.426048033450001, 3.047528826800939, 4.3615578708000005], [1.944868600500001, 1.4432802181529485, 4.3615578708000005], [2.2223516339500002, 2.6729841946428543, 3.4608821292], [2.8710819665500003, 0.5881208738211287, 3.4608821292], [4.352261399500001, 2.1923694824691196, 3.4608821292], [-1.5446859889999989, 3.9384993206838863, 0.8096225400000001], [0.5100675300000007, 2.1464875832472696, 0.8096225400000001], [1.0346184590000007, 4.821962197935049, 0.8096225400000001], [4.693250989, 1.514975230249216, 10.924037460000001], [2.6384974700000012, 3.306986967685833, 10.924037460000001], [2.1139465410000007, 0.6315123529980533, 10.924037460000001], [1.6038790110000012, 2.1206744703728515, 8.63206254], [3.65863253, 0.3286627329362351, 8.63206254], [4.183183459, 3.004137347624015, 8.63206254], [-1.6038790109999992, 5.150624930871285, 7.012817459999999], [-0.5100675300000002, 1.4891621173747986, 7.012817459999999], [2.1139465410000016, 4.267162053620122, 7.012817459999999], [4.752444011000001, 0.30284962006181765, 4.72084254], [3.6586325300000007, 3.964312433558304, 4.72084254], [1.0346184589999998, 1.1863124973129808, 4.72084254], [1.5446859890000004, 3.33280008056025, 3.10159746], [-0.5100675299999999, 5.124811817996868, 3.10159746], [-1.0346184589999994, 2.4493372033090877, 3.10159746]],
                "lattice_vectors": [[6.29713, 0.0, 0.0], [-3.1485649999999987, 5.453474550933103, 0.0], [0.0, 0.0, 11.73366]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1}, "f": {"X_0": 3, "X_1": 3}}
            },
            {
                "Notes": "Phenakite (Be<sub>2</sub>SiO<sub>4</sub>, $S1_{3}$) Structure",
                "Pearsons Symbol": "hR42",
                "Prototype": "Be2O4Si",
                "Space Group Number": 148,
                "Space Group Symbol": "$R\\bar{3}$",
                "Strukturbericht Designation": "$S1_{3}$",
                "aflow_prototype_id": "A2B4C_hR42_148_2f_4f_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B4C_hR42_148_2f_4f_f.html",
                "atom_labels": ["Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "Be", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[-2.513833207499998, 7.009094037801332, 0.676900992], [1.4069131095000007, 5.091852188146211, 0.676900992], [1.1069200980000025, 9.445939025290047, 0.676900992], [8.733883207500002, 3.764348587817463, 7.553899008], [4.813136890500001, 5.681590437472584, 7.553899008], [5.113129902, 1.327503600328748, 7.553899008], [3.7062167925, 3.417946495928401, 6.164100992], [7.6269631095, 1.500704646273279, 6.164100992], [7.326970098000003, 5.854791483417115, 6.164100992], [2.5138332075, 0.1732010459445311, 4.810299008], [11.0331868905, 2.090442895599652, 4.810299008], [5.113129902000003, 8.50979868407461, 4.810299008], [3.706216792500003, 10.600241579674263, 3.420500992], [-4.813136890499998, 8.682999730019143, 3.420500992], [1.106920098, 2.2636439415441836, 3.420500992], [2.5138332075000016, 7.355496129690394, 2.066699008], [-1.406913109499997, 9.272737979345516, 2.066699008], [-1.1069200979999991, 4.918651142201679, 2.066699008], [3.6911642715000017, 10.585446051801748, 0.696819528], [-4.792797326999997, 8.677361628378401, 0.696819528], [1.1016330555000013, 2.2840775710574412, 0.696819528], [2.5288857285000006, 0.18799657381704798, 7.5339804720000005], [11.012847327, 2.0960809972403935, 7.5339804720000005], [5.118416944500001, 8.489365054561354, 7.5339804720000005], [-2.5288857284999993, 6.994298509928815, 6.184019527999999], [1.4272526730000024, 5.086214086505469, 6.184019527999999], [1.1016330555000018, 9.466372654803305, 6.184019527999999], [2.528885728500002, 7.370291657562911, 4.790380472], [-1.4272526729999984, 9.278376080986257, 4.790380472], [-1.101633055500001, 4.898217512688423, 4.790380472], [3.691164271500001, 3.403150968055883, 3.440419528], [7.6473026729999996, 1.4950665446325375, 3.440419528], [7.321683055500001, 5.875225112930372, 3.440419528], [8.7489357285, 3.77914411568998, 2.046780472], [4.792797327000001, 5.687228539113325, 2.046780472], [5.118416944499997, 1.3070699708154898, 2.046780472], [4.3675947090000005, 4.895021391376155, 0.690893352], [6.0170897685, 1.3349372757404245, 0.690893352], [8.275465522500001, 4.543483958502215, 0.690893352], [1.8524552910000018, 5.87842123424264, 7.5399066480000005], [0.20296023150000206, 9.43850534987837, 7.5399066480000005], [-2.0554155224999984, 6.2299586671165805, 7.5399066480000005], [10.587644709, 1.3038738495032236, 6.178093352], [6.017089768500003, 8.517232359486288, 6.178093352], [2.0554155225, 0.9523364166292829, 6.178093352], [8.072505291, 2.2872736923697072, 4.796306648], [6.423010231500001, 5.847357808005438, 4.796306648], [4.164634477500001, 2.638811125243648, 4.796306648], [-1.852455290999999, 8.486168933249088, 3.434493352], [-0.20296023149999867, 4.926084817613356, 3.434493352], [2.0554155225000015, 8.134631500375146, 3.434493352], [-4.367594708999998, 9.469568776115572, 2.052706648], [0.20296023149999987, 2.256210266132507, 2.052706648], [4.164634477500001, 9.821106208989512, 2.052706648], [2.074759878000001, 3.597467961546628, 0.684967176], [2.067171417000003, 10.771503405946182, 0.684967176], [-4.141931294999998, 7.177913883744779, 0.684967176], [4.145290122000003, 7.175974664072167, 7.5458328240000005], [4.152878583, 0.0019392196726115284, 7.5458328240000005], [10.361981295, 3.5955287418740167, 7.5458328240000005], [8.294809878, 0.006320419673694707, 6.172167175999999], [8.287221417000001, 7.1803558640732525, 6.172167175999999], [2.078118705000001, 3.5867663418718467, 6.172167175999999], [10.365340122, 3.584827122199235, 4.802232824], [4.1528785830000015, 7.184234303418474, 4.802232824], [4.141931294999999, 0.004381200001084972, 4.802232824], [-4.145290121999998, 7.188615503419559, 3.428567176], [2.067171417000001, 3.58920832220032, 3.428567176], [2.078118705000001, 10.76906142561771, 3.428567176], [-2.074759877999997, 10.767122205945098, 2.0586328239999996], [-2.067171417000001, 3.593086761545543, 2.0586328239999996], [4.141931295000003, 7.186676283746948, 2.0586328239999996], [4.155739806000001, 2.6478967285245876, 2.0456007240000003], [8.0690842635, 2.275027879251921, 2.0456007240000003], [6.4353259304999995, 5.850518017842287, 2.0456007240000003], [2.064310194000002, 8.125545897094208, 6.185199276], [-1.8490342634999972, 8.498414746366873, 6.185199276], [-0.21527593049999855, 4.922924607776508, 6.185199276], [4.155739806000002, 9.830191812270451, 7.532800724], [-4.371015736499997, 9.457322962997784, 7.532800724], [0.2152759305000004, 2.2593704759693543, 7.532800724], [8.284360194, 4.534398355221276, 3.441599276], [4.371015736500001, 4.907267204493942, 3.441599276], [6.0047740695, 1.3317770659035773, 3.441599276], [-2.064310193999998, 6.239044270397519, 4.789200724], [1.849034263500001, 5.8661754211248525, 4.789200724], [0.2152759305000019, 9.441665559715219, 4.789200724], [2.0643101939999995, 0.943250813348344, 0.6979992759999999], [10.5910657365, 1.3161196626210103, 0.6979992759999999], [6.0047740695, 8.51407214964944, 0.6979992759999999], [-2.0632527854999987, 6.246549768760034, 2.074902372], [1.8420056070000013, 5.863338414566773, 2.074902372], [0.22124717850000303, 9.436997067910784, 2.074902372], [8.283302785500002, 4.526892856858761, 6.155897628000001], [4.378044393000001, 4.9101042110520225, 6.155897628000001], [5.998802821499999, 1.3364455577080114, 6.155897628000001], [4.1567972145, 2.655402226887102, 7.562102372], [8.062055607, 2.2721908726938405, 7.562102372], [6.441297178500003, 5.845849526037852, 7.562102372], [2.0632527855000005, 0.9357453149858289, 3.412297628], [10.598094393000002, 1.3189566691790906, 3.412297628], [5.998802821500003, 8.518740641453874, 3.412297628], [4.156797214500002, 9.837697310632967, 4.818502372], [-4.378044392999999, 9.454485956439704, 4.818502372], [0.22124717850000086, 2.25470198416492, 4.818502372], [2.0632527855000014, 8.118040398731694, 0.668697628], [-1.8420056069999984, 8.501251752924954, 0.668697628], [-0.22124717849999967, 4.927593099580943, 0.668697628], [3.6873078405000013, 3.4172282664200258, 0.6843910200000001], [7.637039590499999, 1.484688128236526, 0.6843910200000001], [7.335802569000002, 5.8715262309622425, 0.6843910200000001], [2.5327421595000015, 7.356214359198769, 7.54640898], [-1.4169895904999972, 9.28875449738227, 7.54640898], [-1.115752568999999, 4.901916394656552, 7.54640898], [3.6873078405000026, 10.599523350165889, 6.171591019999999], [-4.803060409499998, 8.666983211982389, 6.171591019999999], [1.1157525690000005, 2.280378689089311, 6.171591019999999], [8.7527921595, 3.7650668173258373, 4.80280898], [4.803060409500001, 5.697606955509337, 4.80280898], [5.104297431000001, 1.3107688527836192, 4.80280898], [-2.5327421594999993, 7.008375808292957, 3.42799102], [1.4169895905000003, 5.075835670109457, 3.42799102], [1.1157525690000025, 9.462673772835174, 3.42799102], [2.5327421594999997, 0.1739192754529056, 2.0592089799999997], [11.0231104095, 2.1064594136364057, 2.0592089799999997], [5.104297431, 8.493063936529483, 2.0592089799999997]],
                "lattice_vectors": [[12.4401, 0.0, 0.0], [-6.220049999999997, 10.773442625618795, 0.0], [0.0, 0.0, 8.2308]],
                "normalized_wyckoff_matid": {"f": {"X_0": 4, "X_1": 2, "X_2": 1}}
            },
            {
                "Notes": "$\\beta$&ndash;PdCl<sub>2</sub> Structure",
                "Pearsons Symbol": "hR18",
                "Prototype": "Cl2Pd",
                "Space Group Number": 148,
                "Space Group Symbol": "$R\\bar{3}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_hR18_148_2f_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_hR18_148_2f_f.html",
                "atom_labels": ["Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd", "Pd"],
                "atom_positions": [[4.676732995000003, 8.628008066908698, 0.0038707649999999995], [-3.2868906674999967, 11.035285592648483, 0.0038707649999999995], [-1.3898423274999998, 2.9349464318747187, 0.0038707649999999995], [1.8468170050000008, 2.6711119788072515, 8.597829234999999], [9.8104406675, 0.2638344530674672, 8.597829234999999], [7.913392327500002, 8.364173613841231, 8.597829234999999], [-1.8468170049999983, 4.861634718336715, 5.7383374316666655], [3.236659332500003, 7.2689122440765, 5.7383374316666655], [-1.3898423274999976, 10.467693129018684, 5.7383374316666655], [1.8468170050000032, 10.203858675951217, 5.730595901666666], [-3.236659332499998, 7.796581150211434, 5.730595901666666], [1.3898423275000014, 4.597800265269248, 5.730595901666666], [4.676732995, 1.0952613697647327, 2.871104098333333], [9.7602093325, 3.502538895504516, 2.871104098333333], [5.133707672500001, 6.701319780446703, 2.871104098333333], [8.370367005000002, 6.437485327379235, 2.863362568333333], [3.2868906675000003, 4.030207801639451, 2.863362568333333], [7.9133923275, 0.8314269166972653, 2.863362568333333], [4.816076023000003, 10.492588856852747, 2.6893215049999997], [-4.971336512999997, 10.223669799764705, 2.6893215049999997], [0.15526049000000067, 1.8819814348144492, 2.6893215049999997], [1.7074739770000007, 0.8065311888632045, 5.912378495], [11.494886512999999, 1.0754502459512447, 5.912378495], [6.368289510000003, 9.417138610901501, 5.912378495], [-1.7074739769999996, 6.726215508280762, 8.423788171666665], [1.5522134870000026, 6.457296451192721, 8.423788171666665], [0.15526049000000164, 9.414728131958416, 8.423788171666665], [1.707473977000002, 8.33927788600717, 3.045145161666666], [-1.5522134869999982, 8.60819694309521, 3.045145161666666], [-0.15526048999999895, 5.650765262329516, 3.045145161666666], [4.816076022999998, 2.9598421597087787, 5.556554838333333], [8.075763487000001, 2.690923102620738, 5.556554838333333], [6.678810490000003, 5.648354783386432, 5.556554838333333], [8.231023977000001, 4.572904537435188, 0.1779118283333333], [4.971336513000001, 4.841823594523227, 0.1779118283333333], [6.368289509999999, 1.8843919137575336, 0.1779118283333333], [11.486927782, 1.0761281931539872, 1.3685304699999998], [6.371681756000003, 9.409907174072243, 1.3685304699999998], [1.7120404620000007, 0.8130846784897198, 1.3685304699999998], [-4.963377781999998, 10.222991852561963, 7.23316953], [0.1518682440000004, 1.889212871643707, 7.23316953], [4.811509538000003, 10.486035367226231, 7.23316953], [-1.5601722179999977, 8.608874890297953, 7.102997136666666], [-0.15186824399999854, 5.64353382550026, 7.102997136666666], [1.7120404620000014, 8.345831375633686, 7.102997136666666], [1.560172218000001, 6.456618503989979, 4.365936196666666], [0.15186824400000185, 9.421959568787674, 4.365936196666666], [-1.7120404619999985, 6.719662018654247, 4.365936196666666], [4.963377782, 4.84250154172597, 4.235763803333333], [6.371681756, 1.8771604769282761, 4.235763803333333], [8.235590462000003, 4.579458027061703, 4.235763803333333], [8.083722218000002, 2.6902451554179962, 1.498702863333333], [6.675418244000001, 5.65558622021569, 1.498702863333333], [4.811509537999999, 2.953288670082264, 1.498702863333333]],
                "lattice_vectors": [[13.0471, 0.0, 0.0], [-6.5235499999999975, 11.29912004571595, 0.0], [0.0, 0.0, 8.6017]],
                "normalized_wyckoff_matid": {"f": {"X_0": 2, "X_1": 1}}
            }
        ],
        149: [
            {
                "Notes": "Ti<sub>3</sub>O (Room&ndash;temperature) Structure",
                "Pearsons Symbol": "hP24",
                "Prototype": "OTi3",
                "Space Group Number": 149,
                "Space Group Symbol": "$P312$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_hP24_149_acgi_3l",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_hP24_149_acgi_3l.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti", "Ti"],
                "atom_positions": [[0.0, 0.0, 0.0], [-2.57090783375273e-05, 2.96864350301333, 0.0], [0.0, 0.0, 4.769300172621339], [0.0, 0.0, 9.53874342567866], [2.570933542928339, 1.484299486791716, 4.769300172621339], [2.5709078338500007, 1.484344016221614, 9.53874342567866], [-0.8569607082572201, 1.484299486791716, 6.023686354884299], [1.7139471255927805, 2.96864350301333, 6.023686354884299], [1.7139214165144412, 0.0, 6.023686354884299], [-1.7139471255927787, 2.96864350301333, 8.284357243415698], [0.856960708257221, 1.484299486791716, 8.284357243415698], [3.4278942511855592, 0.0, 8.284357243415698], [0.856960708257221, 1.484299486791716, 3.5197787251818], [3.4278942511855592, 0.0, 3.5197787251818], [-1.7139471255927787, 2.96864350301333, 3.5197787251818], [1.7139214165144412, 0.0, 10.7882648731182], [-0.8569607082572201, 1.484299486791716, 10.7882648731182], [1.7139471255927805, 2.96864350301333, 10.7882648731182], [-0.8569607082572201, 1.484299486791716, 1.2591078366503998], [1.7139471255927805, 2.96864350301333, 1.2591078366503998], [1.7139214165144412, 0.0, 1.2591078366503998], [-1.7139471255927787, 2.96864350301333, 13.0489357616496], [0.856960708257221, 1.484299486791716, 13.0489357616496], [3.4278942511855592, 0.0, 13.0489357616496]],
                "lattice_vectors": [[5.1418156677, 0.0, 0.0], [-2.570907833849999, 4.452942989805046, 0.0], [0.0, 0.0, 14.3080435983]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_1": 1}, "g": {"X_1": 2}, "i": {"X_1": 2}, "l": {"X_0": 18}}
            }
        ],
        150: [
            {
                "Notes": "Original Fe<sub>2</sub>P (C22) Structure",
                "Pearsons Symbol": "hP9",
                "Prototype": "Fe2P",
                "Space Group Number": 150,
                "Space Group Symbol": "$P321$",
                "Strukturbericht Designation": "$C22$",
                "aflow_prototype_id": "A2B_hP9_150_ef_bd",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_hP9_150_ef_bd.html",
                "atom_labels": ["P", "P", "P", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe"],
                "atom_positions": [[0.0, 0.0, 1.725], [-2.9249999999054565e-05, 3.377515962254684, 3.0187500000000003], [2.9249707500000004, 1.6887326498842816, 0.43125], [1.521, 0.0, 0.0], [-0.7604999999999996, 1.3172246391561313, 0.0], [2.1645000000000008, 3.749023972982835, 0.0], [3.51, 0.0, 1.725], [-1.754999999999999, 3.0397491672833796, 1.725], [1.1700000000000004, 2.0264994448555864, 1.725]],
                "lattice_vectors": [[5.85, 0.0, 0.0], [-2.9249999999999985, 5.066248612138966, 0.0], [0.0, 0.0, 3.45]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_1": 2}, "e": {"X_0": 3}, "f": {"X_0": 3}}
            }
        ],
        151: [
            {
                "Notes": "CrCl<sub>3</sub> (D0<sub>4</sub>) Crystal Structure",
                "Pearsons Symbol": "hP24",
                "Prototype": "Cl3Cr",
                "Space Group Number": 151,
                "Space Group Symbol": "$P3_{1}12$",
                "Strukturbericht Designation": "$D0_{4}$",
                "aflow_prototype_id": "A3B_hP24_151_3c_2a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hP24_151_3c_2a.html",
                "atom_labels": ["Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[5.0142669500000006, 0.5789281963428345, 5.766609000000001], [3.008500000000001, 4.0530184618853, 11.533275666666668], [1.00273305, 0.5789281963428344, 17.299942333333334], [2.0060678000000007, 2.315712785371338, 5.766609000000001], [3.0085, 0.5794492838282915, 11.533275666666668], [4.010932200000001, 2.315712785371338, 17.299942333333334], [5.0142669500000006, 0.5789281963428345, 1.26463], [3.008500000000001, 4.0530184618853, 7.031296666666667], [1.00273305, 0.5789281963428344, 12.797963333333334], [3.008500000000001, 4.0530184618853, 16.03537], [1.00273305, 0.5789281963428345, 4.502036666666666], [5.0142669500000006, 0.5789281963428344, 10.268703333333333], [2.0060678000000007, 2.315712785371338, 1.26463], [3.0085, 0.5794492838282915, 7.031296666666667], [4.010932200000001, 2.315712785371338, 12.797963333333334], [3.0085, 0.5794492838282915, 16.03537], [4.010932200000001, 2.315712785371338, 4.502036666666666], [2.0060678000000007, 2.315712785371338, 10.268703333333333], [-1.002973729999999, 4.052914244388208, 1.26463], [6.017000000032626e-05, 2.31581700286843, 7.031296666666667], [1.0029135600000008, 4.0530184618853, 12.797963333333334], [-6.016999999950377e-05, 2.31581700286843, 16.03537], [1.002973730000001, 4.052914244388208, 4.502036666666666], [-1.0029135599999994, 4.0530184618853, 10.268703333333333]],
                "lattice_vectors": [[6.017, 0.0, 0.0], [-3.008499999999999, 5.210874854570968, 0.0], [0.0, 0.0, 17.3]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 3}}
            }
        ],
        152: [
            {
                "Notes": "$\\gamma$&ndash;Se (A8) Structure",
                "Pearsons Symbol": "hP3",
                "Prototype": "Se",
                "Space Group Number": 152,
                "Space Group Symbol": "$P3_{1}21$",
                "Strukturbericht Designation": "$A8$",
                "aflow_prototype_id": "A_hP3_152_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hP3_152_a.html",
                "atom_labels": ["Se", "Se", "Se"],
                "atom_positions": [[0.98414148, 0.0, 1.651183488], [-0.4920707399999998, 0.852291522598015, 3.3023834880000003], [1.6910292600000005, 2.928948595405601, 4.953583488]],
                "lattice_vectors": [[4.3662, 0.0, 0.0], [-2.183099999999999, 3.781240118003616, 0.0], [0.0, 0.0, 4.9536]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}}
            },
            {
                "Notes": "$\\alpha$&ndash;Quartz (low Quartz) Structure",
                "Pearsons Symbol": "hP9",
                "Prototype": "O2Si",
                "Space Group Number": 152,
                "Space Group Symbol": "$P3_{1}21$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_hP9_152_c_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_hP9_152_c_a.html",
                "atom_labels": ["Si", "Si", "Si", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[2.3090886, 0.0, 1.8019819799999999], [-1.1545442999999995, 1.9997293871890438, 3.60398198], [1.3024557000000003, 2.2559194470076873, 5.40598198], [1.3739544000000001, 1.1354071089636877, 1.1568839999999998], [3.2437314, 0.6221758595595621, 2.958884], [2.7533142000000006, 2.498065865673481, 4.760883999999999], [-1.0830455999999995, 3.1202417252330434, 2.447116], [0.29631420000000025, 1.7575829685232498, 4.249116], [0.7867314000000003, 3.633472974637169, 0.6451159999999999]],
                "lattice_vectors": [[4.914, 0.0, 0.0], [-2.456999999999999, 4.255648834196731, 0.0], [0.0, 0.0, 5.406]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 2}}
            }
        ],
        153: [
            {
                "Notes": "CrCl<sub>3</sub> Structure",
                "Pearsons Symbol": "hP24",
                "Prototype": "Cl3Cr",
                "Space Group Number": 153,
                "Space Group Symbol": "$P3_{2}12$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_hP24_153_3c_2b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hP24_153_3c_2b.html",
                "atom_labels": ["Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[-2.005766949999999, 4.6319466582281335, 2.8833910000000005], [3.341760645980684e-16, 1.1578563926856689, 14.416724333333333], [2.0057669500000017, 4.6319466582281335, 8.650057666666667], [1.0024322000000008, 2.89516206919963, 2.8833910000000005], [1.1127722743253799e-15, 4.631425570742676, 14.416724333333333], [-1.0024321999999994, 2.89516206919963, 8.650057666666667], [2.7819306858134497e-16, 1.157856392685669, 1.6187610000000001], [2.0057669500000017, 4.6319466582281335, 13.152094333333334], [-2.005766949999999, 4.6319466582281335, 7.385427666666667], [-2.005766949999999, 4.6319466582281335, 15.681239], [2.7819306858134497e-16, 1.157856392685669, 9.914572333333332], [2.0057669500000017, 4.6319466582281335, 4.1479056666666665], [1.1127722743253799e-15, 4.631425570742676, 1.6187610000000001], [-1.0024321999999994, 2.89516206919963, 13.152094333333334], [1.0024322000000008, 2.89516206919963, 7.385427666666667], [1.0024322000000008, 2.89516206919963, 15.681239], [1.1127722743253799e-15, 4.631425570742676, 9.914572333333332], [-1.0024321999999994, 2.89516206919963, 4.1479056666666665], [3.0084398300000013, 2.8950578517025383, 1.6187610000000001], [2.0055864400000005, 1.1578563926856695, 13.152094333333334], [4.0114737300000005, 1.1579606101827604, 7.385427666666667], [4.01141356, 1.1578563926856695, 15.681239], [3.008560170000001, 2.8950578517025383, 9.914572333333332], [2.0055262700000007, 1.1579606101827604, 4.1479056666666665]],
                "lattice_vectors": [[6.017, 0.0, 0.0], [-3.008499999999999, 5.210874854570968, 0.0], [0.0, 0.0, 17.3]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 3}}
            }
        ],
        154: [
            {
                "Notes": "Cinnabar (B9) Structure",
                "Pearsons Symbol": "hP6",
                "Prototype": "HgS",
                "Space Group Number": 154,
                "Space Group Symbol": "$P3_{2}21$",
                "Strukturbericht Designation": "$B9$",
                "aflow_prototype_id": "AB_hP6_154_a_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP6_154_a_b.html",
                "atom_labels": ["Hg", "Hg", "Hg", "S", "S", "S"],
                "atom_positions": [[2.9835709999999995, 0.0, 6.33069832], [-1.491785499999999, 2.583848279994541, 3.1653649866666664], [0.5807145000000001, 1.0058270186919567, 3.1653333333540705e-05], [2.0264905, 0.0, 1.5826983200000002], [-1.0132452499999995, 1.7549922535278288, 7.913364986666666], [1.0592547500000002, 1.834683045158669, 4.748031653333333]],
                "lattice_vectors": [[4.145, 0.0, 0.0], [-2.072499999999999, 3.589675298686498, 0.0], [0.0, 0.0, 9.496]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}}
            },
            {
                "Notes": "S&ndash;II Structure",
                "Pearsons Symbol": "hP9",
                "Prototype": "S",
                "Space Group Number": 154,
                "Space Group Symbol": "$P3_{2}21$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_hP9_154_bc",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hP9_154_bc.html",
                "atom_labels": ["S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[6.0515832, 0.0, 0.709897531], [-3.025791599999999, 5.240824784315126, 3.549430864333333], [0.42830840000000014, 0.7418519101085338, 2.1296641976666666], [-0.25560339999999937, 3.1947493548222345, 0.21722429999999998], [0.8151676000000009, 4.1639429793188665, 3.056757633333333], [-0.559564199999999, 4.606661054706218, 1.6369909666666664], [3.1984966, 2.787927339601425, 1.2025423666666666], [2.8945358000000003, 1.3760156397174417, 4.0420757], [4.269267600000001, 1.8187337151047929, 2.622309033333333]],
                "lattice_vectors": [[6.9082, 0.0, 0.0], [-3.4540999999999986, 5.98267669442366, 0.0], [0.0, 0.0, 4.2593]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_0": 2}}
            }
        ],
        155: [
            {
                "Notes": "Hazelwoodite (Ni<sub>3</sub>S<sub>2</sub>, D5<sub>e</sub>)  Structure",
                "Pearsons Symbol": "hR5",
                "Prototype": "Ni3S2",
                "Space Group Number": 155,
                "Space Group Symbol": "$R32$",
                "Strukturbericht Designation": "$D5_{e}$",
                "aflow_prototype_id": "A3B2_hR5_155_e_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B2_hR5_155_e_c.html",
                "atom_labels": ["S", "S", "S", "S", "S", "S", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni"],
                "atom_positions": [[0.0, 0.0, 1.7935528449999998], [0.0, 0.0, 5.320897155], [8.462297529376882e-16, 3.309925999253357, 6.536519511666666], [8.462297529376882e-16, 3.309925999253357, 2.9494138216666665], [2.86648, 1.6549629996266786, 4.165036178333333], [2.86648, 1.6549629996266786, 0.5779304883333333], [4.270481904, 0.0, 3.557225], [-2.1352409519999993, 3.6983458152657387, 3.557225], [0.7312390480000004, 1.266543183614297, 3.557225], [-1.4624780959999988, 3.309925999253357, 1.1857416666666656], [0.7312390480000005, 2.04338281563906, 1.1857416666666656], [0.7312390480000015, 4.576469182867654, 1.1857416666666656], [1.4040019040000005, 1.6549629996266786, 5.928708333333333], [3.5977190479999996, 0.3884198160123817, 5.928708333333333], [3.5977190480000005, 2.9215061832409757, 5.928708333333333]],
                "lattice_vectors": [[5.73296, 0.0, 0.0], [-2.866479999999999, 4.964888998880036, 0.0], [0.0, 0.0, 7.11445]],
                "normalized_wyckoff_matid": {"c": {"X_1": 2}, "d": {"X_0": 3}}
            },
            {
                "Notes": "AlF<sub>3</sub> (D0<sub>14</sub>)  Structure",
                "Pearsons Symbol": "hR8",
                "Prototype": "AlF3",
                "Space Group Number": 155,
                "Space Group Symbol": "$R32$",
                "Strukturbericht Designation": "$D0_{14}$",
                "aflow_prototype_id": "AB3_hR8_155_c_de",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_hR8_155_c_de.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Al", "Al", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F"],
                "atom_positions": [[0.0, 0.0, 2.95170939], [0.0, 0.0, 9.502760610000001], [6.830846999150708e-16, 2.8383001113577357, 11.25468939], [6.830846999150708e-16, 2.8383001113577357, 5.35127061], [2.4580400000000004, 1.4191500556788679, 7.10319939], [2.4580400000000004, 1.4191500556788679, 1.19978061], [2.1139144, 0.0, 0.0], [-1.0569571999999996, 1.8307035718257396, 0.0], [1.4010828000000006, 2.426746595210864, 0.0], [2.113914400000001, 2.8383001113577357, 8.30298], [1.4010828, 0.41155351614687175, 8.30298], [3.8591228000000006, 1.0075965395319961, 8.30298], [-0.3441255999999996, 1.4191500556788679, 4.15149], [1.4010828000000008, 3.2498536275046073, 4.15149], [-1.0569571999999992, 3.845896650889732, 4.15149], [2.8021656, 0.0, 6.227235], [-1.4010827999999993, 2.4267465952108638, 6.227235], [1.0569572000000003, 1.8307035718257398, 6.227235], [2.8021656000000013, 2.8383001113577357, 2.075744999999998], [1.0569572000000005, 1.007596539531996, 2.075744999999998], [3.5149972000000007, 0.41155351614687175, 2.075744999999998], [0.3441255999999998, 1.4191500556788679, 10.378725], [1.056957200000001, 3.845896650889732, 10.378725], [-1.4010827999999995, 3.2498536275046077, 10.378725]],
                "lattice_vectors": [[4.91608, 0.0, 0.0], [-2.458039999999999, 4.257450167036604, 0.0], [0.0, 0.0, 12.45447]],
                "normalized_wyckoff_matid": {"c": {"X_1": 2}, "d": {"X_0": 3}, "e": {"X_0": 3}}
            }
        ],
        156: [
            {
                "Notes": "$\\beta$&ndash;CuI Structure",
                "Pearsons Symbol": "hP4",
                "Prototype": "CuI",
                "Space Group Number": 156,
                "Space Group Symbol": "$P3m1$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_hP4_156_ab_ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP4_156_ab_ab.html",
                "atom_labels": ["Cu", "I", "Cu", "I"],
                "atom_positions": [[0.0, 0.0, 4.5593633102868], [0.0, 0.0, 0.0], [-2.1397418387244055e-05, 2.470773407060236, 6.4089163512522], [-2.1397418387244055e-05, 2.470773407060236, 3.58440511815]],
                "lattice_vectors": [[4.2794836776, 0.0, 0.0], [-2.139741838799999, 3.7061415798824546, 0.0], [0.0, 0.0, 7.1688102363]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "b": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "CuI Structure",
                "Pearsons Symbol": "hP12",
                "Prototype": "CuI",
                "Space Group Number": 156,
                "Space Group Symbol": "$P3m1$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_hP12_156_2ab3c_2ab3c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP12_156_2ab3c_2ab3c.html",
                "atom_labels": ["Cu", "Cu", "I", "I", "Cu", "I", "Cu", "Cu", "Cu", "I", "I", "I"],
                "atom_positions": [[0.0, 0.0, 7.8224656446375], [0.0, 0.0, 14.77569890684288], [0.0, 0.0, 10.42995419285], [0.0, 0.0, 17.38318745505538], [-2.1249906672200876e-05, 2.453740136221533, 0.869232382432119], [-2.1249906672200876e-05, 2.453740136221533, 3.476720930644619], [2.125011917206673, 1.2268516651517598, 9.560721810417881], [2.125011917206673, 1.2268516651517598, 16.514163671707117], [2.125011917206673, 1.2268516651517598, 2.6074885482125], [2.125011917206673, 1.2268516651517598, 6.953233262205381], [2.125011917206673, 1.2268516651517598, 13.906675123494617], [2.125011917206673, 1.2268516651517598, 0.0]],
                "lattice_vectors": [[4.2499813346, 0.0, 0.0], [-2.124990667299999, 3.680591801373293, 0.0], [0.0, 0.0, 20.8599083857]],
                "normalized_wyckoff_matid": {"a": {"X_0": 3, "X_1": 3}, "b": {"X_0": 2, "X_1": 2}, "c": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "CdI<sub>2</sub> (Polytype 6H<sub>1</sub>) Structure",
                "Pearsons Symbol": "hP9",
                "Prototype": "CdI2",
                "Space Group Number": 156,
                "Space Group Symbol": "$P3m1$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_hP9_156_b2c_3a2bc",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_hP9_156_b2c_3a2bc.html",
                "atom_labels": ["I", "I", "I", "Cd", "I", "I", "Cd", "Cd", "I"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 13.669446852025859], [0.0, 0.0, 6.834620905674141], [-2.119903615933284e-05, 2.447866085976556, 15.378050818275], [-2.119903615933284e-05, 2.447866085976556, 3.417412973175859], [-2.119903615933284e-05, 2.447866085976556, 10.25203387885], [2.11992481503616, 1.2239146840844277, 1.708603966249141], [2.11992481503616, 1.2239146840844277, 8.543429912600859], [2.11992481503616, 1.2239146840844277, 17.086654784524143]],
                "lattice_vectors": [[4.239807232, 0.0, 0.0], [-2.1199036159999993, 3.671780770060984, 0.0], [0.0, 0.0, 20.5040677577]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 2}, "b": {"X_0": 2, "X_1": 1}, "c": {"X_0": 3}}
            }
        ],
        157: [
            {
                "Notes": "Ag<sub>5</sub>Pb<sub>2</sub>O<sub>6</sub> Structure",
                "Pearsons Symbol": "hP13",
                "Prototype": "Ag5O6Pb2",
                "Space Group Number": 157,
                "Space Group Symbol": "$P31m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A5B6C2_hP13_157_2ac_2c_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B6C2_hP13_157_2ac_2c_b.html",
                "atom_labels": ["Ag", "Ag", "Pb", "Pb", "Ag", "Ag", "Ag", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 1.696992], [0.0, 0.0, 4.731008], [-2.9694999999027263e-05, 3.428900393133431, 0.141416], [2.9695000000000005, 1.7144759131910807, 0.141416], [2.9695, 0.0, 3.355416], [-1.4847499999999993, 2.5716624365378906, 3.355416], [1.4847500000000007, 2.5716624365378906, 3.355416], [3.581217, 0.0, 1.38202], [-1.7906084999999992, 3.101424898464696, 1.38202], [1.1788915000000004, 2.041899974611085, 1.38202], [2.357783, 0.0, 5.328812], [-1.1788914999999995, 2.041899974611085, 5.328812], [1.790608500000001, 3.101424898464696, 5.328812]],
                "lattice_vectors": [[5.939, 0.0, 0.0], [-2.9694999999999987, 5.143324873075781, 0.0], [0.0, 0.0, 6.428]],
                "normalized_wyckoff_matid": {"a": {"X_1": 2}, "b": {"X_2": 2}, "c": {"X_0": 6, "X_1": 3}}
            }
        ],
        158: [
            {
                "Notes": "$\\beta$&ndash;RuCl<sub>3</sub> Structure",
                "Pearsons Symbol": "hP8",
                "Prototype": "Cl3Ru",
                "Space Group Number": 158,
                "Space Group Symbol": "$P3c1$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_hP8_158_d_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hP8_158_d_a.html",
                "atom_labels": ["Ru", "Ru", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 2.829], [1.8635400000000002, 0.14310203772134067, 1.340946], [5.064300000000001, 1.5423219621077826, 1.340946], [2.252160000000002, 3.6146514713316416, 1.340946], [4.256460000000001, 0.14310203772134067, 4.169946], [3.8678400000000015, 3.6146514713316416, 4.169946], [1.0557000000000005, 1.5423219621077826, 4.169946]],
                "lattice_vectors": [[6.12, 0.0, 0.0], [-3.0599999999999987, 5.300075471160765, 0.0], [0.0, 0.0, 5.658]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_0": 3}}
            }
        ],
        159: [
            {
                "Notes": "Bi<sub>2</sub>O<sub>3</sub> (High&ndash;pressure) Structure",
                "Pearsons Symbol": "hP20",
                "Prototype": "Bi2O3",
                "Space Group Number": 159,
                "Space Group Symbol": "$P31c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B3_hP20_159_bc_2c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_hP20_159_bc_2c.html",
                "atom_labels": ["Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[-3.87442889447658e-05, 4.473827499532401, 0.0], [3.8744288946000007, 2.236947303304679, 3.15094217235], [2.0147030251920004, 1.033448985147059, 0.13233957123870002], [5.8465132019514, 1.2280595083241026, 0.13233957123870002], [3.7620704566566006, 4.449199202288962, 0.13233957123870002], [1.9720843073514016, 5.48264818743602, 3.2832817435887005], [-1.8597258694079981, 5.677258710613064, 3.2832817435887005], [-0.11235843794339946, 2.2615084934711613, 3.2832817435887005], [3.2583947003586, 0.40935316944136746, 1.8086408069289], [5.765150195164801, 2.617176001346448, 1.8086408069289], [2.599741788276601, 3.6841785249723067, 1.8086408069289], [1.8907213005648005, 4.093531694413675, 4.9595829792789], [-0.6160341942413983, 6.301354526318756, 4.9595829792789], [-1.2746871063233993, 3.0265291707878155, 4.9595829792789], [0.06199086231360049, 1.8924195702043545, 0.5230564006101001], [2.2045500410274013, 5.818183572224026, 0.5230564006101001], [-2.2665409033409984, 5.710812249091864, 0.5230564006101001], [6.0789789356274, 0.8925241235360961, 3.6739985729601], [3.936419756913601, 4.8182881255557675, 3.6739985729601], [1.6078879912589998, 0.9998954466682582, 3.6739985729601]],
                "lattice_vectors": [[7.7488577892, 0.0, 0.0], [-3.874428894599998, 6.710707695760123, 0.0], [0.0, 0.0, 6.3018843447]],
                "normalized_wyckoff_matid": {"b": {"X_1": 1}, "c": {"X_0": 6, "X_1": 3}}
            },
            {
                "Notes": "YbBaCo<sub>4</sub>O<sub>7</sub> Structure",
                "Pearsons Symbol": "hP26",
                "Prototype": "BaCo4O7Yb",
                "Space Group Number": 159,
                "Space Group Symbol": "$P31c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB4C7D_hP26_159_b_ac_a2c_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4C7D_hP26_159_b_ac_a2c_b.html",
                "atom_labels": ["Co", "Co", "O", "O", "Ba", "Ba", "Yb", "Yb", "Co", "Co", "Co", "Co", "Co", "Co", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 5.11397733775], [0.0, 0.0, 3.12668574430035], [0.0, 0.0, 8.24066308205035], [-3.132655489346488e-05, 3.6172970666195337, 0.62697362160815], [3.1326554894500007, 1.8086756629021186, 5.74095095935815], [-3.132655489346488e-05, 3.6172970666195337, 4.47882135240145], [3.1326554894500007, 1.8086756629021186, 9.592798690151449], [1.6524757706848754, 0.8545821590780694, 2.5283503957835998], [4.6989832341749995, 1.0037949170123357, 2.5283503957835998], [3.046507463490126, 3.567541394246544, 2.5283503957835998], [1.566327744725001, 4.422123553324614, 7.642327733533599], [-1.4801797187651238, 4.57133631125888, 7.642327733533599], [-0.08614802595987457, 1.8583770760904053, 7.642327733533599], [-1.6036063450494542, 2.7938054203764953, 3.1727115403400994], [1.5149521946980207, 2.640251927665959, 3.1727115403400994], [0.08865415035143663, 5.417779592631444, 3.1727115403400994], [4.647607684148021, 2.7856665426709903, 8.2866888780901], [1.5290491444005452, 2.632113049960454, 8.2866888780901], [3.221309639801435, 0.008138877705505424, 8.2866888780901], [1.7345513445084653, 0.627778767017985, 0.6320875989458999], [4.85436294645172, 1.188276145003792, 0.6320875989458999], [2.8090521773898156, 3.609863558315172, 0.6320875989458999], [1.7217074570017208, 4.237642325333158, 5.746064936695899], [-1.3981041449415337, 4.798139703318964, 5.746064936695899], [-0.3236033120601845, 1.8160549120217768, 5.746064936695899]],
                "lattice_vectors": [[6.2653109789, 0.0, 0.0], [-3.1326554894499985, 5.425918470336949, 0.0], [0.0, 0.0, 10.2279546755]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "b": {"X_2": 1, "X_3": 1}, "c": {"X_0": 6, "X_1": 3}}
            },
            {
                "Notes": "Nierite ($\\alpha$&ndash;Si<sub>3</sub>N<sub>4</sub>) Structure",
                "Pearsons Symbol": "hP28",
                "Prototype": "N4Si3",
                "Space Group Number": 159,
                "Space Group Symbol": "$P31c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B3_hP28_159_ab2c_2c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B3_hP28_159_ab2c_2c.html",
                "atom_labels": ["N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 2.80849637205], [-3.873994995533913e-05, 4.473326473676117, 2.04964065232209], [3.8739949956500004, 2.2366967866188623, 4.85813702437209], [-1.1788566771762943, 2.610843942141355, 0.22917330395928], [2.202366155027026, 4.383614359807112, 0.22917330395928], [-1.0235094778507283, 6.425454019518278, 0.22917330395928], [6.076361150677026, 2.32634180092626, 3.03766967600928], [2.695138318473706, 4.099112218592017, 3.03766967600928], [2.85048551779927, 0.284502141215095, 3.03766967600928], [1.2164344286341007, 2.145843980202532, 1.52332843219992], [1.4074223819196467, 6.690497287867246, 1.52332843219992], [-2.623856810553744, 4.583571053396967, 1.52332843219992], [5.281417377569645, 0.0194588728661265, 4.33182480424992], [5.0904294242841015, 4.56411218053084, 4.33182480424992], [1.2501381850962554, 2.126385107336406, 4.33182480424992], [-1.335366075000554, 3.4146966901972133, 1.78171009842852], [1.5844639532208513, 3.8461468713323685, 1.78171009842852], [-0.2490978782202932, 6.1590687599371625, 1.78171009842852], [5.45845894887085, 2.8638092894010034, 4.5902064704785195], [2.5386289206494457, 3.295259470536159, 4.5902064704785195], [3.624897117429705, 0.5508874007962099, 4.5902064704785195], [0.3335509691254656, 1.7197617639959633, 0.15390560118834], [2.217862135009627, 6.138938891454963, 0.15390560118834], [-2.5514131041350887, 5.561211666015819, 0.15390560118834], [6.0918571306596245, 0.5710172692784099, 2.96240197323834], [4.207545964775467, 4.990194396737409, 2.96240197323834], [1.3225818915149101, 1.1487444947175534, 2.96240197323834]],
                "lattice_vectors": [[7.7479899913, 0.0, 0.0], [-3.873994995649998, 6.709956160733372, 0.0], [0.0, 0.0, 5.6169927441]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 1}, "c": {"X_0": 6, "X_1": 6}}
            }
        ],
        160: [
            {
                "Notes": "Millerite (NiS, B13) Structure",
                "Pearsons Symbol": "hR6",
                "Prototype": "NiS",
                "Space Group Number": 160,
                "Space Group Symbol": "$R3m$",
                "Strukturbericht Designation": "$B13$",
                "aflow_prototype_id": "AB_hR6_160_b_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hR6_160_b_b.html",
                "atom_labels": ["Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[8.352033415000001, 0.7314834989040109, 0.27719119999999997], [4.8095000000000026, 6.867331361194494, 0.27719119999999997], [1.2669665850000003, 0.7314834989040109, 0.27719119999999997], [-1.2669665849999987, 6.2850157382390215, 2.3771245333333333], [9.995980102909622e-16, 4.090565241526988, 2.3771245333333333], [1.2669665850000014, 6.2850157382390215, 2.3771245333333333], [3.542533415, 3.508249618571516, 1.3271578666666668], [4.809499999999999, 1.3137991218594833, 1.3271578666666668], [6.076466585, 3.508249618571516, 1.3271578666666668], [1.6217153050000008, 4.617234471444324, 0.891642193], [1.9582352450697725e-15, 7.426127775116382, 0.891642193], [-1.6217153049999988, 4.617234471444324, 0.891642193], [6.431215304999999, 1.84046835177682, 2.9915755263333335], [4.8095, 4.649361655448877, 2.9915755263333335], [3.1877846950000004, 1.8404683517768188, 2.9915755263333335], [-3.1877846949999977, 7.394000591111829, 1.9416088596666667], [-7.012371720331135e-17, 1.8725955357813717, 1.9416088596666667], [3.187784695000001, 7.394000591111829, 1.9416088596666667]],
                "lattice_vectors": [[9.619, 0.0, 0.0], [-4.809499999999998, 8.330298359002516, 0.0], [0.0, 0.0, 3.1499]],
                "normalized_wyckoff_matid": {"b": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "Moissanite 9R Crystal Structure",
                "Pearsons Symbol": "hR6",
                "Prototype": "CSi",
                "Space Group Number": 160,
                "Space Group Symbol": "$R3m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_hR6_160_3a_3a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hR6_160_3a_3a.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C", "C", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.99931762654171e-16, 1.7423911508900636, 14.784686666666666], [1.5089550000000003, 0.8711955754450318, 7.392343333333333], [0.0, 0.0, 4.9281796066], [4.99931762654171e-16, 1.7423911508900636, 19.712866273266663], [1.5089550000000003, 0.8711955754450318, 12.320522939933333], [0.0, 0.0, 17.248850393399998], [4.99931762654171e-16, 1.7423911508900636, 9.856507060066665], [1.5089550000000003, 0.8711955754450318, 2.4641637267333345], [0.0, 0.0, 1.8480119098999999], [4.99931762654171e-16, 1.7423911508900636, 16.632698576566664], [1.5089550000000003, 0.8711955754450318, 9.240355243233333], [0.0, 0.0, 6.7764132867999995], [4.99931762654171e-16, 1.7423911508900636, 21.561099953466663], [1.5089550000000003, 0.8711955754450318, 14.168756620133331], [0.0, 0.0, 19.0968623033], [4.99931762654171e-16, 1.7423911508900636, 11.704518969966664], [1.5089550000000003, 0.8711955754450318, 4.312175636633333]],
                "lattice_vectors": [[3.01791, 0.0, 0.0], [-1.5089549999999994, 2.6135867263350954, 0.0], [0.0, 0.0, 22.17703]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "Cr<sub>5</sub>Al<sub>8</sub> ($D8_{10}$) Structure",
                "Pearsons Symbol": "hR26",
                "Prototype": "Al8Cr5",
                "Space Group Number": 160,
                "Space Group Symbol": "$R3m$",
                "Strukturbericht Designation": "$D8_{10}$",
                "aflow_prototype_id": "A8B5_hR26_160_a3bc_a3b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A8B5_hR26_160_a3bc_a3b.html",
                "atom_labels": ["Al", "Al", "Al", "Cr", "Cr", "Cr", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Cr", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al"],
                "atom_positions": [[0.0, 0.0, 5.33343552], [1.4195751981323684e-15, 7.342960116655953, 2.6878821866666667], [6.35919, 3.6714800583279765, 0.04232885333333396], [0.0, 0.0, 1.53971204], [1.4195751981323684e-15, 7.342960116655953, 6.830818706666666], [6.35919, 3.6714800583279765, 4.185265373333333], [4.0825363881, 4.985906634009976, 0.8466035222], [6.35919, 1.0426269069639784, 0.8466035222], [8.635843611900002, 4.985906634009976, 0.8466035222], [10.4417263881, 1.3144265756819986, 6.1377101888666665], [6.359190000000002, 8.385587023619932, 6.1377101888666665], [2.2766536119000005, 1.3144265756819986, 6.1377101888666665], [-2.2766536118999987, 8.657386692337953, 3.492156855533333], [9.764647235381098e-16, 4.714106965291955, 3.492156855533333], [2.276653611900002, 8.657386692337953, 3.492156855533333], [-1.481627678099998, 8.198378255445789, 0.7407284778], [1.3833126736528809e-15, 5.632123839076281, 0.7407284778], [1.4816276781000026, 8.198378255445787, 0.7407284778], [4.877562321900001, 4.526898197117812, 6.031835144466666], [6.359190000000001, 1.9606437807483053, 6.031835144466666], [7.8408176781000005, 4.526898197117811, 6.031835144466666], [11.2367523219, 0.8554181387898362, 3.386281811133333], [6.359190000000002, 9.303603897404258, 3.386281811133333], [1.4816276780999997, 0.855418138789835, 3.386281811133333], [2.3273999481000014, 5.999235130108497, 2.1164691222000003], [2.0361891813536204e-15, 10.030410089750866, 2.1164691222000003], [-2.3273999480999987, 5.999235130108497, 2.1164691222000003], [8.686589948100002, 2.3277550717805187, 7.407575788866667], [6.359190000000002, 6.358930031422889, 7.407575788866667], [4.031790051900001, 2.32775507178052, 7.407575788866667], [-4.031790051899999, 9.670715188436473, 4.762022455533333], [3.034861262444603e-16, 2.6874499730949126, 4.762022455533333], [4.0317900519000025, 9.670715188436473, 4.762022455533333], [7.688197118100001, 2.904177440938013, 2.1164691222000003], [6.359190000000001, 5.206085293107905, 2.1164691222000003], [5.0301828819, 2.9041774409380126, 2.1164691222000003], [-5.030182881899996, 10.247137557593966, 7.407575788866667], [3.3348769340098727e-16, 1.534605234779927, 7.407575788866667], [5.030182881900003, 10.247137557593966, 7.407575788866667], [1.3290071181000012, 6.575657499265989, 4.762022455533333], [1.713184790711845e-15, 8.877565351435882, 4.762022455533333], [-1.3290071180999994, 6.575657499265989, 4.762022455533333], [10.54353702, 1.255646179948168, 0.88890592], [6.359190000000003, 8.503147815087594, 0.88890592], [2.1748429799999998, 1.255646179948168, 0.88890592], [-2.1748429799999967, 8.598606296604121, 6.180012586666666], [4.1522221512953694e-16, 4.831667756759618, 6.180012586666666], [2.174842980000001, 8.598606296604121, 6.180012586666666], [4.184347020000001, 4.927126238276144, 3.534459253333333], [6.35919, 1.16018769843164, 3.534459253333333], [8.534032980000001, 4.927126238276145, 3.534459253333333], [-4.139896281899997, 9.733130349428048, 1.8942426421999998], [6.560827699786389e-16, 2.562619651111762, 1.8942426421999998], [4.139896281900001, 9.733130349428048, 1.8942426421999998], [2.219293718100002, 6.0616502911000705, 7.185349308866667], [1.4095241533359134e-15, 9.905579767767716, 7.185349308866667], [-2.2192937181, 6.061650291100072, 7.185349308866667], [8.578483718100001, 2.390170232772095, 4.539795975533333], [6.359190000000001, 6.234099709439738, 4.539795975533333], [4.139896281899998, 2.390170232772096, 4.539795975533333], [4.737660141900001, 7.339251921797042, 2.5979069178], [3.9935713200000005, 0.43330807648386827, 2.5979069178], [10.3463385381, 3.24188017670302, 2.5979069178], [2.3720414619000016, 3.24188017670302, 2.5979069178], [8.724808679999999, 0.43330807648386827, 2.5979069178], [7.9807198581000005, 7.339251921797042, 2.5979069178], [-1.6215298580999995, 3.667771863469065, 7.8890135844666665], [3.9935713200000027, 7.776268193139821, 7.8890135844666665], [-2.3720414618999976, 10.584840293358972, 7.8890135844666665], [2.372041461900004, 10.584840293358972, 7.8890135844666665], [-3.9935713199999987, 7.776268193139821, 7.8890135844666665], [1.6215298581000006, 3.667771863469065, 7.8890135844666665], [-1.621529858099999, 11.01073198012502, 5.2434602511333335], [-2.3656186799999994, 4.1047881348118445, 5.2434602511333335], [3.987148538100001, 6.9133602350309955, 5.2434602511333335], [-3.987148538099998, 6.9133602350309955, 5.2434602511333335], [2.365618679999999, 4.1047881348118445, 5.2434602511333335], [1.6215298581000013, 11.01073198012502, 5.2434602511333335]],
                "lattice_vectors": [[12.71838, 0.0, 0.0], [-6.359189999999997, 11.01444017498393, 0.0], [0.0, 0.0, 7.93666]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "b": {"X_0": 9, "X_1": 9}, "c": {"X_0": 6}}
            },
            {
                "Notes": "H<sub>3</sub>S (130 GPa) Structure",
                "Pearsons Symbol": "hR4",
                "Prototype": "H3S",
                "Space Group Number": 160,
                "Space Group Symbol": "$R3m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_hR4_160_b_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hR4_160_b_a.html",
                "atom_labels": ["S", "S", "S", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[0.0, 0.0, 0.0], [5.255980835746262e-16, 2.5432279357803016, 1.7926666666666666], [2.2025, 1.2716139678901508, 0.8963333333333333], [1.1957372500000003, 1.852868712612739, 0.01729027], [2.2025, 0.10910447844497478, 0.01729027], [3.209262750000001, 1.852868712612739, 0.01729027], [3.39823725, 0.5812547447225874, 1.8099569366666668], [2.2025000000000006, 2.652332414225276, 1.8099569366666668], [1.0067627500000003, 0.5812547447225879, 1.8099569366666668], [-1.00676275, 3.1244826805028896, 0.9136236033333333], [2.424562032625014e-16, 1.3807184463351256, 0.9136236033333333], [1.006762750000001, 3.1244826805028896, 0.9136236033333333]],
                "lattice_vectors": [[4.405, 0.0, 0.0], [-2.2024999999999992, 3.8148419036704526, 0.0], [0.0, 0.0, 2.689]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_0": 3}}
            },
            {
                "Notes": "Carbonyl Sulphide (COS, $F0_{2}$) Structure",
                "Pearsons Symbol": "hR3",
                "Prototype": "COS",
                "Space Group Number": 160,
                "Space Group Symbol": "$R3m$",
                "Strukturbericht Designation": "$F0_{2}$",
                "aflow_prototype_id": "ABC_hR3_160_a_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_hR3_160_a_a_a.html",
                "atom_labels": ["C", "C", "C", "O", "O", "O", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [7.062924319474935e-16, 3.562424365980748, 3.90748], [3.08515, 1.781212182990374, 1.95374], [0.0, 0.0, 4.651229743200001], [7.062924319474935e-16, 3.562424365980748, 2.6974897432000007], [3.08515, 1.781212182990374, 0.7437497431999999], [0.0, 0.0, 1.5100261086000002], [7.062924319474935e-16, 3.562424365980748, 5.4175061086000005], [3.08515, 1.781212182990374, 3.4637661086]],
                "lattice_vectors": [[6.1703, 0.0, 0.0], [-3.0851499999999987, 5.343636548971122, 0.0], [0.0, 0.0, 5.86122]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1, "X_2": 1}}
            },
            {
                "Notes": "Moissanite&ndash;15R (SiC, $B7$) Structure",
                "Pearsons Symbol": "hR10",
                "Prototype": "CSi",
                "Space Group Number": 160,
                "Space Group Symbol": "$R3m$",
                "Strukturbericht Designation": "$B7$",
                "aflow_prototype_id": "AB_hR10_160_5a_5a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hR10_160_5a_5a.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 0.0], [3.5323595900157064e-16, 1.7840123317959435, 25.266666666666666], [1.545, 0.8920061658979718, 12.633333333333333], [0.0, 0.0, 5.053207], [3.5323595900157064e-16, 1.7840123317959435, 30.319873666666666], [1.545, 0.8920061658979718, 17.686540333333333], [0.0, 0.0, 15.16], [3.5323595900157064e-16, 1.7840123317959435, 2.526666666666666], [1.545, 0.8920061658979718, 27.793333333333333], [0.0, 0.0, 22.74], [3.5323595900157064e-16, 1.7840123317959435, 10.106666666666664], [1.545, 0.8920061658979718, 35.373333333333335], [0.0, 0.0, 32.846793], [3.5323595900157064e-16, 1.7840123317959435, 20.21345966666666], [1.545, 0.8920061658979718, 7.580126333333332], [0.0, 0.0, 1.895], [3.5323595900157064e-16, 1.7840123317959435, 27.161666666666665], [1.545, 0.8920061658979718, 14.528333333333332], [0.0, 0.0, 6.948206999999999], [3.5323595900157064e-16, 1.7840123317959435, 32.21487366666666], [1.545, 0.8920061658979718, 19.58154033333333], [0.0, 0.0, 17.055], [3.5323595900157064e-16, 1.7840123317959435, 4.421666666666668], [1.545, 0.8920061658979718, 29.688333333333333], [0.0, 0.0, 24.635], [3.5323595900157064e-16, 1.7840123317959435, 12.001666666666665], [1.545, 0.8920061658979718, 37.26833333333333], [0.0, 0.0, 34.741793], [3.5323595900157064e-16, 1.7840123317959435, 22.108459666666665], [1.545, 0.8920061658979718, 9.475126333333332]],
                "lattice_vectors": [[3.09, 0.0, 0.0], [-1.5449999999999993, 2.6760184976939154, 0.0], [0.0, 0.0, 37.9]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}}
            }
        ],
        161: [
            {
                "Notes": "Ferroelectric LiNbO<sub>3</sub> Structure",
                "Pearsons Symbol": "hR10",
                "Prototype": "LiNbO3",
                "Space Group Number": 161,
                "Space Group Symbol": "$R3c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC3_hR10_161_a_a_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC3_hR10_161_a_a_b.html",
                "atom_labels": ["Li", "Li", "Li", "Li", "Li", "Li", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 3.9893212499999997], [0.0, 0.0, 10.927271249999999], [8.373709133498626e-16, 3.0335137843761317, 13.239921249999998], [8.373709133498626e-16, 3.0335137843761317, 6.301971249999999], [2.6271, 1.5167568921880659, 8.61462125], [2.6271, 1.5167568921880659, 1.67667125], [0.0, 0.0, 0.17761152], [0.0, 0.0, 7.11556152], [8.373709133498626e-16, 3.0335137843761317, 9.42821152], [8.373709133498626e-16, 3.0335137843761317, 2.49026152], [2.6271, 1.5167568921880659, 4.802911519999999], [2.6271, 1.5167568921880659, 11.740861520000001], [1.5907090500000012, 3.2793800765998173, 1.156278747], [-1.0082809799999988, 4.2881750855941, 1.156278747], [-0.5824280699999996, 1.5329861909344782, 1.156278747], [0.5824280700000005, 1.5329861909344782, 8.094228747], [1.0082809800000014, 4.2881750855941, 8.094228747], [-1.5907090499999992, 3.2793800765998173, 8.094228747], [4.2178090500000005, 1.7626231844117513, 10.406878746999999], [1.6188190200000012, 2.771418193406034, 10.406878746999999], [2.0446719300000002, 0.016229298746412033, 10.406878746999999], [3.2095280700000006, 0.016229298746412033, 3.4689287469999996], [3.6353809800000003, 2.771418193406034, 3.4689287469999996], [1.0363909500000006, 1.7626231844117513, 3.4689287469999996], [1.5907090499999992, 0.2458662922236857, 5.781578747], [4.2459190200000005, 1.2546613012179682, 5.781578747], [2.044671930000001, 3.049743083122544, 5.781578747], [3.2095280700000015, 3.049743083122544, 12.719528747], [1.0082809799999997, 1.2546613012179682, 12.719528747], [3.66349095, 0.2458662922236857, 12.719528747]],
                "lattice_vectors": [[5.2542, 0.0, 0.0], [-2.6270999999999987, 4.550270676564198, 0.0], [0.0, 0.0, 13.8759]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1, "X_2": 1}, "b": {"X_0": 3}}
            }
        ],
        162: [
            {
                "Notes": "$\\beta$&ndash;V<sub>2</sub>N Structure",
                "Pearsons Symbol": "hP9",
                "Prototype": "NV2",
                "Space Group Number": 162,
                "Space Group Symbol": "$P\\bar{3}1m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_hP9_162_ad_k",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_hP9_162_ad_k.html",
                "atom_labels": ["N", "N", "N", "V", "V", "V", "V", "V", "V"],
                "atom_positions": [[0.0, 0.0, 0.0], [-2.4584999999384847e-05, 2.838845467761758, 2.284], [2.458524585, 1.4194014426463268, 2.284], [1.598025, 0.0, 1.242496], [-0.7990124999999997, 1.3839302458826275, 1.242496], [1.6594875000000007, 2.874316664525457, 1.242496], [0.7990125000000003, 1.3839302458826275, 3.3255039999999996], [3.318975, 0.0, 3.3255039999999996], [-1.6594874999999993, 2.874316664525457, 3.3255039999999996]],
                "lattice_vectors": [[4.917, 0.0, 0.0], [-2.458499999999999, 4.258246910408085, 0.0], [0.0, 0.0, 4.568]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_1": 2}, "k": {"X_0": 6}}
            }
        ],
        163: [
            {
                "Notes": "KAg(CN)<sub>2</sub> (F5<sub>10</sub>) Structure",
                "Pearsons Symbol": "hP36",
                "Prototype": "Ag(CKN)2",
                "Space Group Number": 163,
                "Space Group Symbol": "$P\\bar{3}1c$",
                "Strukturbericht Designation": "$F5_{10}$",
                "aflow_prototype_id": "AB2CD2_hP36_163_h_i_bf_i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2CD2_hP36_163_h_i_bf_i.html",
                "atom_labels": ["K", "K", "K", "K", "K", "K", "Ag", "Ag", "Ag", "Ag", "Ag", "Ag", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N", "N"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 8.7765], [-3.691999999853494e-05, 4.263175703468136, 0.17553000000000002], [1.2970258467248641e-15, 4.263111756152321, 8.60097], [3.692036920000001, 2.1315558780761603, 17.377470000000002], [3.692000000000001, 2.1316198253919754, 8.95203], [5.534308, 1.0679201741178974, 4.38825], [3.692000000000001, 4.258891233308501, 4.38825], [1.8496920000000006, 1.0679201741178976, 4.38825], [-1.8423079999999983, 5.326811407426398, 13.164750000000002], [4.848317303185469e-16, 2.1358403482357953, 13.164750000000002], [1.8423080000000014, 5.326811407426398, 13.164750000000002], [2.3197943600000004, 0.24511006152059286, 2.474973], [6.011831280000001, 1.8864458165555675, 2.474973], [2.7443743600000015, 4.263175703468136, 2.474973], [1.3721687200000006, 1.8864458165555675, 6.301527], [5.064205640000001, 0.24511006152059286, 6.301527], [4.639625640000002, 4.263175703468136, 6.301527], [1.372205640000002, 6.149621520023703, 15.078027], [-2.3198312799999985, 4.508285764988728, 15.078027], [0.9476256400000009, 2.1315558780761603, 15.078027], [2.3198312800000016, 4.508285764988728, 11.251473], [-1.372205639999998, 6.149621520023703, 11.251473], [-0.9476256399999995, 2.1315558780761603, 11.251473], [-1.1137287199999995, 2.334077027263668, 1.4568990000000002], [2.227494360000001, 4.263175703468136, 1.4568990000000002], [-1.1137656399999982, 6.192210432356788, 1.4568990000000002], [-2.227494359999999, 4.263175703468136, 7.3196010000000005], [1.113728720000001, 2.334077027263668, 7.3196010000000005], [1.1137656400000013, 6.192210432356788, 7.3196010000000005], [4.805728720000002, 4.060654554280628, 16.096101], [1.4645056400000005, 2.1315558780761603, 16.096101], [4.805765640000001, 0.20252114918750783, 16.096101], [5.919494360000001, 2.1315558780761603, 10.233399], [2.5782712800000014, 4.060654554280628, 10.233399], [2.57823436, 0.20252114918750783, 10.233399]],
                "lattice_vectors": [[7.384, 0.0, 0.0], [-3.6919999999999984, 6.3947315815442956, 0.0], [0.0, 0.0, 17.553]],
                "normalized_wyckoff_matid": {"b": {"X_2": 1}, "f": {"X_2": 2}, "h": {"X_3": 3}, "i": {"X_0": 6, "X_1": 6}}
            }
        ],
        164: [
            {
                "Notes": "Al<sub>3</sub>Ni<sub>2</sub> (D5<sub>13</sub>) Structure",
                "Pearsons Symbol": "hP5",
                "Prototype": "Al3Ni2",
                "Space Group Number": 164,
                "Space Group Symbol": "$P\\bar{3}m1$",
                "Strukturbericht Designation": "$D5_{13}$",
                "aflow_prototype_id": "A3B2_hP5_164_ad_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B2_hP5_164_ad_d.html",
                "atom_labels": ["Al", "Al", "Al", "Ni", "Ni"],
                "atom_positions": [[0.0, 0.0, 0.0], [-2.0140999999248664e-05, 2.3256939827614223, 3.1691088], [2.0140798590000006, 1.1628295487630536, 1.7214912], [-2.0140999999248664e-05, 2.3256939827614223, 0.7286994], [2.0140798590000006, 1.1628295487630536, 4.1619006]],
                "lattice_vectors": [[4.0282, 0.0, 0.0], [-2.014099999999999, 3.488523531524476, 0.0], [0.0, 0.0, 4.8906]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "d": {"X_0": 2, "X_1": 2}}
            },
            {
                "Notes": "$\\omega$  (C6) Phase",
                "Pearsons Symbol": "hP3",
                "Prototype": "CdI2",
                "Space Group Number": 164,
                "Space Group Symbol": "$P\\bar{3}m1$",
                "Strukturbericht Designation": "$C6$",
                "aflow_prototype_id": "AB2_hP3_164_a_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_hP3_164_a_d.html",
                "atom_labels": ["Cd", "I", "I"],
                "atom_positions": [[0.0, 0.0, 0.0], [-2.119999999933804e-05, 2.44797738118972, 1.7236799999999999], [2.1199788000000006, 1.2239703308563, 5.11632]],
                "lattice_vectors": [[4.24, 0.0, 0.0], [-2.119999999999999, 3.67194771204602, 0.0], [0.0, 0.0, 6.84]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "La<sub>2</sub>O<sub>3</sub> ($D5_{2}$) Structure",
                "Pearsons Symbol": "hP5",
                "Prototype": "La2O3",
                "Space Group Number": 164,
                "Space Group Symbol": "$P\\bar{3}m1$",
                "Strukturbericht Designation": "$D5_{2}$",
                "aflow_prototype_id": "A2B3_hP5_164_d_ad",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_hP5_164_d_ad.html",
                "atom_labels": ["O", "La", "La", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [-1.969049999926865e-05, 2.2736744634111408, 1.51377587], [1.9690303095000004, 1.1368201792323571, 4.62232413], [-1.969049999926865e-05, 2.2736744634111408, 3.9700567], [1.9690303095000004, 1.1368201792323571, 2.1660432999999997]],
                "lattice_vectors": [[3.9381, 0.0, 0.0], [-1.969049999999999, 3.410494642643498, 0.0], [0.0, 0.0, 6.1361]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "d": {"X_0": 2, "X_1": 2}}
            },
            {
                "Notes": "delta<sub>H</sub><sup>II</sup>&ndash;NW<sub>2</sub> Structure",
                "Pearsons Symbol": "hP9",
                "Prototype": "HIINW2",
                "Space Group Number": 164,
                "Space Group Symbol": "$P\\bar{3}m1$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_hP9_164_bd_c2d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_hP9_164_bd_c2d.html",
                "atom_labels": ["N", "W", "W", "N", "N", "W", "W", "W", "W"],
                "atom_positions": [[0.0, 0.0, 11.425], [0.0, 0.0, 1.386995], [0.0, 0.0, 21.463005000000003], [-1.4449999999459431e-05, 1.6685506206694085, 3.5189000000000004], [1.4449855500000004, 0.8342627962676197, 19.3311], [-1.4449999999459431e-05, 1.6685506206694085, 6.2295955], [1.4449855500000004, 0.8342627962676197, 16.620404500000003], [-1.4449999999459431e-05, 1.6685506206694085, 9.0035855], [1.4449855500000004, 0.8342627962676197, 13.846414500000002]],
                "lattice_vectors": [[2.89, 0.0, 0.0], [-1.4449999999999994, 2.502813416937028, 0.0], [0.0, 0.0, 22.85]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 2}, "d": {"X_0": 4, "X_1": 2}}
            },
            {
                "Notes": "CuNiSb<sub>2</sub> Structure",
                "Pearsons Symbol": "hP4",
                "Prototype": "CuNiSb",
                "Space Group Number": 164,
                "Space Group Symbol": "$P\\bar{3}m1$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC2_hP4_164_a_b_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC2_hP4_164_a_b_d.html",
                "atom_labels": ["Cu", "Ni", "Sb", "Sb"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 2.5661], [-2.024099999936145e-05, 2.3372410458802415, 1.3908262], [2.024079759, 1.1686029937199227, 3.7413738]],
                "lattice_vectors": [[4.0482, 0.0, 0.0], [-2.024099999999999, 3.505844039600164, 0.0], [0.0, 0.0, 5.1322]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "d": {"X_0": 2}}
            }
        ],
        165: [
            {
                "Notes": "H<sub>3</sub>Ho Structure",
                "Pearsons Symbol": "hP24",
                "Prototype": "H3Ho",
                "Space Group Number": 165,
                "Space Group Symbol": "$P\\bar{3}c1$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_hP24_165_adg_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hP24_165_adg_f.html",
                "atom_labels": ["H", "H", "H", "H", "H", "H", "Ho", "Ho", "Ho", "Ho", "Ho", "Ho", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[0.0, 0.0, 1.64], [0.0, 0.0, 4.92], [-3.153999999902468e-05, 3.64194370767565, 1.09552], [3.15396846, 1.8209445393965897, 2.1844799999999998], [3.1540315399999996, 1.8209445393965897, 5.464479999999999], [3.154000000085744e-05, 3.64194370767565, 4.37552], [4.201128, 0.0, 1.64], [-2.100563999999999, 3.6382835725501117, 1.64], [1.0534360000000003, 1.8246046745221278, 1.64], [2.1068719999999996, 0.0, 4.92], [-1.0534359999999994, 1.8246046745221278, 4.92], [2.1005640000000008, 3.6382835725501117, 4.92], [2.1573359999999995, 0.1529608709180227, 0.62976], [5.096864, 1.7918273450396944, 0.62976], [2.207800000000001, 3.5181000311145225, 0.62976], [-0.9966639999999988, 5.309927376154216, 2.65024], [-0.9461999999999995, 1.9447882159577172, 2.65024], [1.9428640000000006, 3.6710609020325453, 2.65024], [0.9966640000000012, 5.309927376154216, 5.9302399999999995], [-1.9428639999999993, 3.6710609020325453, 5.9302399999999995], [0.9462000000000003, 1.9447882159577172, 5.9302399999999995], [4.150664, 0.1529608709180227, 3.9097599999999995], [4.1002, 3.5181000311145225, 3.9097599999999995], [1.2111360000000002, 1.7918273450396944, 3.9097599999999995]],
                "lattice_vectors": [[6.308, 0.0, 0.0], [-3.1539999999999986, 5.4628882470722395, 0.0], [0.0, 0.0, 6.56]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "d": {"X_0": 2}, "f": {"X_1": 3}, "g": {"X_0": 6}}
            },
            {
                "Notes": "Cu<sub>3</sub>P ($D0_{21}$) Structure",
                "Pearsons Symbol": "hP24",
                "Prototype": "Cu3P",
                "Space Group Number": 165,
                "Space Group Symbol": "$P\\bar{3}c1$",
                "Strukturbericht Designation": "$D0_{21}$",
                "aflow_prototype_id": "A3B_hP24_165_bdg_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hP24_165_bdg_f.html",
                "atom_labels": ["Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "P", "P", "P", "P", "P", "P", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.5675], [-3.534999999853312e-05, 4.08188681250267, 1.21295], [3.534964650000001, 2.0409127922533115, 2.3545499999999997], [3.5350353500000002, 2.0409127922533115, 5.92205], [3.535000000122395e-05, 4.08188681250267, 4.78045], [2.6866000000000003, 0.0, 1.78375], [-1.3432999999999995, 2.326663849807273, 1.78375], [2.191700000000001, 3.796135754948709, 1.78375], [4.3834, 0.0, 5.35125], [-2.191699999999999, 3.796135754948709, 5.35125], [1.3433000000000008, 2.326663849807273, 5.35125], [4.63085, 0.4285959723329188, 0.5708], [4.383400000000002, 3.796135754948708, 0.5708], [1.590750000000001, 1.8980678774743547, 0.5708], [1.0958500000000009, 5.694203632423063, 2.9966999999999997], [-1.9442499999999987, 4.224731727281627, 2.9966999999999997], [0.8484000000000006, 2.326663849807274, 2.9966999999999997], [-1.0958499999999978, 5.694203632423063, 6.5642000000000005], [-0.8483999999999997, 2.326663849807274, 6.5642000000000005], [1.9442500000000005, 4.224731727281627, 6.5642000000000005], [2.439150000000001, 0.4285959723329188, 4.138299999999999], [5.47925, 1.8980678774743547, 4.138299999999999], [2.6866000000000008, 3.796135754948708, 4.138299999999999]],
                "lattice_vectors": [[7.07, 0.0, 0.0], [-3.5349999999999984, 6.122799604755982, 0.0], [0.0, 0.0, 7.135]],
                "normalized_wyckoff_matid": {"b": {"X_0": 1}, "d": {"X_0": 2}, "f": {"X_1": 3}, "g": {"X_0": 6}}
            }
        ],
        166: [
            {
                "Notes": "Caswellsilverite (CrNaS<sub>2</sub>, F5<sub>1</sub>) Crystal Structure",
                "Pearsons Symbol": "hR4",
                "Prototype": "CrNaS2",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "$F5_{1}$",
                "aflow_prototype_id": "ABC2_hR4_166_a_b_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC2_hR4_166_a_b_c.html",
                "atom_labels": ["Cr", "Cr", "Cr", "Na", "Na", "Na", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [5.098902781478879e-16, 2.053115292265228, 12.909999999999998], [1.77805, 1.026557646132614, 6.454999999999999], [0.0, 0.0, 9.6825], [5.098902781478879e-16, 2.053115292265228, 3.227499999999997], [1.77805, 1.026557646132614, 16.137499999999996], [0.0, 0.0, 5.1646455], [0.0, 0.0, 14.2003545], [5.098902781478879e-16, 2.053115292265228, 18.0746455], [5.098902781478879e-16, 2.053115292265228, 7.745354499999999], [1.77805, 1.026557646132614, 11.619645499999999], [1.77805, 1.026557646132614, 1.2903544999999996]],
                "lattice_vectors": [[3.5561, 0.0, 0.0], [-1.778049999999999, 3.0796729383978425, 0.0], [0.0, 0.0, 19.365]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "c": {"X_0": 2}}
            },
            {
                "Notes": "Fe<sub>7</sub>W<sub>6</sub> (D8<sub>5</sub>) $\\mu$&ndash;phase",
                "Pearsons Symbol": "hR13",
                "Prototype": "Fe7W6",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "$D8_{5}$",
                "aflow_prototype_id": "A7B6_hR13_166_ah_3c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A7B6_hR13_166_ah_3c.html",
                "atom_labels": ["Fe", "Fe", "Fe", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "W", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe"],
                "atom_positions": [[0.0, 0.0, 0.0], [6.801411286024479e-16, 2.74645523053505, 17.226666666666667], [2.3785000000000003, 1.373227615267525, 8.613333333333333], [0.0, 0.0, 4.3152800000000004], [0.0, 0.0, 21.52472], [6.801411286024479e-16, 2.74645523053505, 21.541946666666668], [6.801411286024479e-16, 2.74645523053505, 12.911386666666665], [2.3785000000000003, 1.373227615267525, 12.928613333333333], [2.3785000000000003, 1.373227615267525, 4.298053333333333], [0.0, 0.0, 8.94064], [0.0, 0.0, 16.89936], [6.801411286024479e-16, 2.74645523053505, 0.327306666666665], [6.801411286024479e-16, 2.74645523053505, 8.286026666666666], [2.3785000000000003, 1.373227615267525, 17.553973333333335], [2.3785000000000003, 1.373227615267525, 25.512693333333335], [0.0, 0.0, 11.57632], [0.0, 0.0, 14.26368], [6.801411286024479e-16, 2.74645523053505, 2.9629866666666675], [6.801411286024479e-16, 2.74645523053505, 5.650346666666666], [2.3785000000000003, 1.373227615267525, 20.189653333333332], [2.3785000000000003, 1.373227615267525, 22.877013333333334], [3.5677262149999995, 0.6866275399099152, 6.6323528000000005], [2.3785000000000003, 2.7464277659827445, 6.6323528000000005], [1.189273785, 0.6866275399099151, 6.6323528000000005], [-1.1892262149999993, 3.4330553058926596, 19.2076472], [2.9314289662352163e-16, 1.3732550798198302, 19.2076472], [1.1892262150000008, 3.4330553058926596, 19.2076472], [-1.1892737849999988, 3.433082770444965, 23.859019466666666], [-9.911291935319836e-17, 1.37320015071522, 23.859019466666666], [1.1892737850000001, 3.433082770444965, 23.859019466666666], [1.1892737850000006, 2.0598276906251347, 10.594313866666665], [2.3785000000000003, 2.7464552305073048e-05, 10.594313866666665], [3.567726215, 2.0598276906251347, 10.594313866666665], [1.1892262150000001, 2.05985515517744, 15.245686133333333], [8.450947556563429e-16, 4.119655381250269, 15.245686133333333], [-1.189226215, 2.05985515517744, 15.245686133333333], [3.5677737849999995, 0.68660007535761, 1.9809805333333326], [2.3785000000000003, 2.7464826950873547, 1.9809805333333326], [1.1892262150000008, 0.6866000753576097, 1.9809805333333326]],
                "lattice_vectors": [[4.757, 0.0, 0.0], [-2.378499999999999, 4.119682845802575, 0.0], [0.0, 0.0, 25.84]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_1": 6}, "h": {"X_0": 6}}
            },
            {
                "Notes": "$\\alpha$&ndash;B (hR12) Structure",
                "Pearsons Symbol": "hR12",
                "Prototype": "B",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_hR12_166_2h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hR12_166_2h.html",
                "atom_labels": ["B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B"],
                "atom_positions": [[3.3205319400000004, 0.9165251117709331, 2.8402003077], [2.4540000000000006, 2.4174024582321594, 2.8402003077], [1.5874680600000004, 0.9165251117709331, 2.8402003077], [-0.8665319399999993, 3.333927570003093, 9.7253896923], [4.825322008628063e-16, 1.8330502235418662, 9.7253896923], [0.8665319400000007, 3.333927570003093, 9.7253896923], [-1.5874680599999995, 3.750160232953617, 11.2172603077], [4.728517192612949e-16, 1.000584897640817, 11.2172603077], [1.5874680600000006, 3.750160232953617, 11.2172603077], [1.5874680600000004, 1.9171100094117501, 5.536859692299999], [2.454, 0.4162326629505242, 5.536859692299999], [3.3205319400000004, 1.9171100094117506, 5.536859692299999], [0.8665319400000002, 2.3333426723622748, 7.0287303077], [8.833381788993695e-16, 3.834220018823501, 7.0287303077], [-0.8665319399999997, 2.3333426723622748, 7.0287303077], [4.041468060000001, 0.5002924488204085, 1.3483296922999997], [2.4540000000000006, 3.2498677841332078, 1.3483296922999997], [0.8665319399999997, 0.5002924488204087, 1.3483296922999997], [-1.0103117999999993, 3.416938910878139, 0.30785695500000004], [3.025945716217394e-16, 1.6670275417917733, 0.30785695500000004], [1.0103118000000002, 3.4169389108781396, 0.30785695500000004], [3.4643118000000004, 0.8335137708958864, 12.257733045], [2.454000000000001, 2.5834251399822525, 12.257733045], [1.4436882000000006, 0.8335137708958866, 12.257733045], [1.4436882000000004, 2.000121350286797, 8.684916954999998], [2.4540000000000006, 0.25020998120043125, 8.684916954999998], [3.4643117999999995, 2.0001213502867974, 8.684916954999998], [-1.4436881999999995, 3.66714889207857, 8.069203045], [2.1891419047885087e-16, 1.1666075793909108, 8.069203045], [1.4436882000000009, 3.66714889207857, 8.069203045], [3.8976882000000006, 0.5833037896954554, 4.496386955], [2.454000000000001, 3.083845102383115, 4.496386955], [1.0103118, 0.5833037896954554, 4.496386955], [1.0103118, 2.2503313314872284, 3.8806730449999995], [1.0632758081404365e-15, 4.000242700573594, 3.8806730449999995], [-1.0103117999999995, 2.250331331487229, 3.8806730449999995]],
                "lattice_vectors": [[4.908, 0.0, 0.0], [-2.4539999999999993, 4.250452681774026, 0.0], [0.0, 0.0, 12.56559]],
                "normalized_wyckoff_matid": {"h": {"X_0": 1}}
            },
            {
                "Notes": "CuPt (L1<sub>1</sub>) Structure",
                "Pearsons Symbol": "hR2",
                "Prototype": "CuPt",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "$L1_{1}$",
                "aflow_prototype_id": "AB_hR2_166_a_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hR2_166_a_b.html",
                "atom_labels": ["Cu", "Cu", "Cu", "Pt", "Pt", "Pt"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.279909759929978e-16, 1.8071063425635288, 9.986666666666666], [1.565, 0.9035531712817644, 4.993333333333333], [0.0, 0.0, 7.49], [4.279909759929978e-16, 1.8071063425635288, 2.4966666666666644], [1.565, 0.9035531712817644, 12.483333333333333]],
                "lattice_vectors": [[3.13, 0.0, 0.0], [-1.5649999999999993, 2.710659513845293, 0.0], [0.0, 0.0, 14.98]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}}
            },
            {
                "Notes": "$\\alpha$&ndash;Sm (C19) Structure",
                "Pearsons Symbol": "hR3",
                "Prototype": "Sm",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "$C19$",
                "aflow_prototype_id": "A_hR3_166_ac",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hR3_166_ac.html",
                "atom_labels": ["Sm", "Sm", "Sm", "Sm", "Sm", "Sm", "Sm", "Sm", "Sm"],
                "atom_positions": [[0.0, 0.0, 0.0], [5.110793270072614e-16, 2.0902158205633534, 17.4996], [1.81018, 1.0451079102816767, 8.7498], [0.0, 0.0, 5.833141668000001], [0.0, 0.0, 20.416258332], [5.110793270072614e-16, 2.0902158205633534, 23.332741668], [5.110793270072614e-16, 2.0902158205633534, 11.666458332], [1.81018, 1.0451079102816767, 14.582941668000002], [1.81018, 1.0451079102816767, 2.9166583319999995]],
                "lattice_vectors": [[3.62036, 0.0, 0.0], [-1.810179999999999, 3.1353237308450304, 0.0], [0.0, 0.0, 26.2494]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_0": 2}}
            },
            {
                "Notes": "Bi<sub>2</sub>Te<sub>3</sub> Structure (C33)",
                "Pearsons Symbol": "hR5",
                "Prototype": "Bi2Te3",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "$C33$",
                "aflow_prototype_id": "A2B3_hR5_166_c_ac",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_hR5_166_c_ac.html",
                "atom_labels": ["Te", "Te", "Te", "Bi", "Bi", "Bi", "Bi", "Bi", "Bi", "Te", "Te", "Te", "Te", "Te", "Te"],
                "atom_positions": [[0.0, 0.0, 0.0], [5.249345402802419e-16, 2.5225241551271615, 20.281953333333334], [2.18457, 1.2612620775635808, 10.140976666666667], [0.0, 0.0, 12.138749070000001], [0.0, 0.0, 18.28418093], [5.249345402802419e-16, 2.5225241551271615, 1.9977724033333295], [5.249345402802419e-16, 2.5225241551271615, 8.143204263333331], [2.18457, 1.2612620775635808, 22.279725736666666], [2.18457, 1.2612620775635808, 28.425157596666665], [0.0, 0.0, 6.3279694399999995], [0.0, 0.0, 24.09496056], [5.249345402802419e-16, 2.5225241551271615, 26.60992277333333], [5.249345402802419e-16, 2.5225241551271615, 13.953983893333334], [2.18457, 1.2612620775635808, 16.468946106666667], [2.18457, 1.2612620775635808, 3.8130072266666666]],
                "lattice_vectors": [[4.36914, 0.0, 0.0], [-2.184569999999999, 3.7837862326907423, 0.0], [0.0, 0.0, 30.42293]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_0": 2, "X_1": 2}}
            },
            {
                "Notes": "Rhombohedral Graphite Structure",
                "Pearsons Symbol": "hR2",
                "Prototype": "C",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_hR2_166_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hR2_166_c.C.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C"],
                "atom_positions": [[0.0, 0.0, 1.6740334800000003], [0.0, 0.0, 8.36996652], [3.415046023746981e-16, 1.4179722611297207, 8.37003348], [3.415046023746981e-16, 1.4179722611297207, 5.02196652], [1.2280000000000002, 0.7089861305648604, 5.02203348], [1.2280000000000002, 0.7089861305648604, 1.6739665199999998]],
                "lattice_vectors": [[2.456, 0.0, 0.0], [-1.2279999999999995, 2.1269583916945813, 0.0], [0.0, 0.0, 10.044]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}}
            },
            {
                "Notes": "$\\beta$&ndash;Po (A<sub>i</sub>) Structure",
                "Pearsons Symbol": "hR1",
                "Prototype": "Po",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "$A_{i}$",
                "aflow_prototype_id": "A_hR1_166_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hR1_166_a.beta-Po.html",
                "atom_labels": ["Po", "Po", "Po"],
                "atom_positions": [[0.0, 0.0, 0.0], [8.341190701107356e-16, 2.9320502480687467, 3.277773333333333], [2.53923, 1.4660251240343734, 1.6388866666666666]],
                "lattice_vectors": [[5.07846, 0.0, 0.0], [-2.5392299999999985, 4.39807537210312, 0.0], [0.0, 0.0, 4.91666]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}}
            },
            {
                "Notes": "Mo<sub>2</sub>B<sub>5</sub> (D8<sub>i</sub>) Structure",
                "Pearsons Symbol": "hR7",
                "Prototype": "B5Mo2",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "$D8_{i}$",
                "aflow_prototype_id": "A5B2_hR7_166_a2c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B2_hR7_166_a2c_c.html",
                "atom_labels": ["B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "Mo", "Mo", "Mo", "Mo", "Mo", "Mo"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.998039019691683e-16, 1.7384016605299633, 13.953333333333333], [1.5055000000000003, 0.8692008302649816, 6.976666666666667], [0.0, 0.0, 3.89298], [0.0, 0.0, 17.037020000000002], [4.998039019691683e-16, 1.7384016605299633, 17.846313333333335], [4.998039019691683e-16, 1.7384016605299633, 10.060353333333332], [1.5055000000000003, 0.8692008302649816, 10.869646666666666], [1.5055000000000003, 0.8692008302649816, 3.0836866666666665], [0.0, 0.0, 6.9765969000000005], [0.0, 0.0, 13.9534031], [4.998039019691683e-16, 1.7384016605299633, 20.929930233333334], [4.998039019691683e-16, 1.7384016605299633, 6.976736433333332], [1.5055000000000003, 0.8692008302649816, 13.953263566666667], [1.5055000000000003, 0.8692008302649816, 6.976666666596188e-05], [0.0, 0.0, 1.56975], [0.0, 0.0, 19.36025], [4.998039019691683e-16, 1.7384016605299633, 15.523083333333332], [4.998039019691683e-16, 1.7384016605299633, 12.383583333333334], [1.5055000000000003, 0.8692008302649816, 8.546416666666666], [1.5055000000000003, 0.8692008302649816, 5.406916666666666]],
                "lattice_vectors": [[3.011, 0.0, 0.0], [-1.5054999999999994, 2.607602490794945, 0.0], [0.0, 0.0, 20.93]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_0": 4, "X_1": 2}}
            },
            {
                "Notes": "$\\alpha$&ndash;Hg (A10) Structure",
                "Pearsons Symbol": "hR1",
                "Prototype": "Hg",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "$A10$",
                "aflow_prototype_id": "A_hR1_166_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hR1_166_a.alpha-Hg.html",
                "atom_labels": ["Hg", "Hg", "Hg"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.3404927800120653e-16, 1.9961365941989042, 4.442266666666667], [1.728705, 0.9980682970994521, 2.2211333333333334]],
                "lattice_vectors": [[3.45741, 0.0, 0.0], [-1.7287049999999993, 2.9942048912983563, 0.0], [0.0, 0.0, 6.6634]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}}
            },
            {
                "Notes": "$\\beta$&ndash;B (R&ndash;105) Structure",
                "Pearsons Symbol": "hR105",
                "Prototype": "B",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_hR105_166_bc9h4i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hR105_166_bc9h4i.html",
                "atom_labels": ["B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B"],
                "atom_positions": [[0.0, 0.0, 11.945], [1.6830981053317373e-15, 6.327758950318299, 3.9816666666666634], [5.48, 3.1638794751591495, 19.90833333333333], [0.0, 0.0, 9.192872], [0.0, 0.0, 14.697128], [1.6830981053317373e-15, 6.327758950318299, 1.229538666666664], [1.6830981053317373e-15, 6.327758950318299, 6.733794666666666], [5.48, 3.1638794751591495, 17.156205333333332], [5.48, 3.1638794751591495, 22.660461333333334], [-4.541769199999998, 8.949950620535452, 7.817524700000001], [3.5816487553574916e-16, 1.0833756098839962, 7.817524700000001], [4.541769200000002, 8.949950620535452, 7.817524700000001], [10.021769200000001, 0.5416878049419981, 16.0724753], [5.480000000000003, 8.408262815593453, 16.0724753], [0.9382308000000004, 0.5416878049419981, 16.0724753], [0.9382308000000016, 5.786071145376301, 23.744191366666666], [2.0762350061431787e-15, 7.411134560202295, 23.744191366666666], [-0.9382307999999987, 5.786071145376301, 23.744191366666666], [-0.9382307999999981, 6.869446755260296, 8.109141966666666], [1.2899612045202956e-15, 5.244383340434303, 8.109141966666666], [0.9382308000000026, 6.869446755260296, 8.109141966666666], [6.4182308, 2.6221916702171515, 15.780858033333335], [5.48, 4.247255085043146, 15.780858033333335], [4.5417692, 2.6221916702171515, 15.780858033333335], [4.541769200000002, 3.7055672801011474, 0.1458086333333324], [5.480000000000001, 2.080503865275153, 0.1458086333333324], [6.418230800000002, 3.7055672801011474, 0.1458086333333324], [1.4889160000000017, 5.468132896917558, 1.5671840000000001], [2.261707265915902e-15, 8.047011057119782, 1.5671840000000001], [-1.4889159999999995, 5.468132896917559, 1.5671840000000001], [3.9910840000000007, 4.02350552855989, 22.322816], [5.480000000000001, 1.4446273683576671, 22.322816], [6.968916000000003, 4.023505528559891, 22.322816], [6.968916000000002, 2.304253421758408, 17.493850666666667], [5.480000000000002, 4.883131581960631, 17.493850666666667], [3.9910840000000007, 2.3042534217584083, 17.493850666666667], [9.471084, 0.8596260534007412, 14.359482666666667], [5.480000000000002, 7.7723863186759665, 14.359482666666667], [1.4889160000000008, 0.8596260534007412, 14.359482666666667], [-3.9910839999999976, 8.632012372076709, 9.530517333333332], [5.208775633036567e-16, 1.7192521068014823, 9.530517333333332], [3.991084000000003, 8.632012372076709, 9.530517333333332], [-1.4889159999999992, 7.18738500371904, 6.396149333333334], [1.384265146953112e-15, 4.608506843516817, 6.396149333333334], [1.4889160000000015, 7.187385003719041, 6.396149333333334], [-0.9956611999999981, 6.902604212159965, 2.7361217000000004], [1.6651220846597423e-15, 5.178068426634967, 2.7361217000000004], [0.9956612000000024, 6.902604212159965, 2.7361217000000004], [6.475661200000002, 2.589034213317484, 21.1538783], [5.480000000000002, 4.313569998842482, 21.1538783], [4.484338800000001, 2.5890342133174835, 21.1538783], [4.4843388000000015, 3.7387247370008145, 18.662788366666668], [5.48, 2.014188951475817, 18.662788366666668], [6.475661200000002, 3.738724737000815, 18.662788366666668], [-4.484338799999998, 8.916793163635782, 13.190544966666666], [2.9331133077903346e-16, 1.1496905236833312, 13.190544966666666], [4.484338800000002, 8.916793163635782, 13.190544966666666], [9.9643388, 0.5748452618416656, 10.699455033333333], [5.480000000000002, 8.341947901794116, 10.699455033333333], [0.9956611999999997, 0.5748452618416656, 10.699455033333333], [0.9956612000000009, 5.752913688476633, 5.227211633333333], [1.2569849161536695e-15, 7.477449474001631, 5.227211633333333], [-0.9956611999999985, 5.7529136884766325, 5.227211633333333], [9.277694799999999, 0.9712793600791074, 7.201162699999999], [5.480000000000002, 7.549079705319234, 7.201162699999999], [1.6823052000000007, 0.9712793600791076, 7.201162699999999], [-3.7976947999999977, 8.520359065398342, 16.6888373], [4.4030841195308327e-16, 1.9425587201582153, 16.6888373], [3.7976948000000026, 8.520359065398342, 16.6888373], [-1.682305199999999, 7.299038310397407, 23.127829366666667], [2.295281120723302e-15, 4.385200230160082, 23.127829366666667], [1.6823052000000025, 7.299038310397407, 23.127829366666667], [1.6823052000000014, 5.356479590239192, 8.725503966666666], [2.1234065172848206e-15, 8.270317670476514, 8.725503966666666], [-1.6823051999999996, 5.356479590239191, 8.725503966666666], [3.7976948000000017, 4.135158835238257, 15.164496033333334], [5.48, 1.2213207550009337, 15.164496033333334], [7.162305200000002, 4.135158835238257, 15.164496033333334], [7.162305200000002, 2.192600115080041, 0.7621706333333335], [5.480000000000002, 5.106438195317364, 0.7621706333333335], [3.797694799999999, 2.192600115080042, 0.7621706333333335], [-2.680267999999998, 7.875212401618639, 0.6689200000000001], [8.333884693456639e-16, 3.232852047717619, 0.6689200000000001], [2.680268000000002, 7.875212401618639, 0.6689200000000001], [8.160268, 1.6164260238588095, 23.22108], [5.480000000000002, 6.258786377759829, 23.22108], [2.7997320000000006, 1.6164260238588095, 23.22108], [2.7997320000000028, 4.711332926459489, 16.595586666666666], [5.480000000000001, 0.06897257255846924, 16.595586666666666], [8.160268, 4.711332926459489, 16.595586666666666], [-2.7997319999999974, 7.944184974177109, 15.257746666666666], [2.4130741849148776e-16, 3.094906902600681, 15.257746666666666], [2.799732000000002, 7.944184974177109, 15.257746666666666], [8.279732000000001, 1.5474534513003404, 8.632253333333333], [5.480000000000002, 6.3967315228767685, 8.632253333333333], [2.6802680000000016, 1.5474534513003397, 8.632253333333333], [2.6802680000000003, 4.78030549901796, 7.294413333333332], [2.3107631363927792e-15, 9.422665852918978, 7.294413333333332], [-2.6802679999999994, 4.78030549901796, 7.294413333333332], [8.828882800000002, 1.2304010890946417, 5.5623087], [5.480000000000003, 7.030836247288165, 5.5623087], [2.1311172000000007, 1.230401089094642, 5.5623087], [-3.348882799999998, 8.261237336382807, 18.3276913], [5.802782254704654e-16, 2.460802178189284, 18.3276913], [3.348882800000002, 8.261237336382807, 18.3276913], [-2.1311171999999976, 7.5581600394129405, 21.488975366666665], [7.164622672917176e-16, 3.866956772129016, 21.488975366666665], [2.131117200000002, 7.5581600394129405, 21.488975366666665], [2.131117200000001, 5.0973578612236565, 10.364357966666667], [3.373599355427359e-15, 8.788561128507583, 10.364357966666667], [-2.1311172, 5.0973578612236565, 10.364357966666667], [3.3488828000000006, 4.3942805642537905, 13.525642033333334], [5.48, 0.7030772969698651, 13.525642033333334], [7.611117200000002, 4.394280564253792, 13.525642033333334], [7.611117200000002, 1.933478386064508, 2.401024633333333], [5.480000000000003, 5.624681653348433, 2.401024633333333], [3.3488828000000015, 1.9334783860645077, 2.401024633333333], [7.252780000000001, 2.140364464945165, 5.227132], [5.480000000000003, 5.210909495587119, 5.227132], [3.7072200000000013, 2.140364464945165, 5.227132], [-1.772779999999998, 7.351273960532284, 18.662868], [1.204831789891614e-15, 4.28072892989033, 18.662868], [1.7727800000000016, 7.351273960532284, 18.662868], [-3.707219999999999, 8.468123415263465, 21.153798666666667], [1.5307577427847714e-15, 2.0470300204279677, 21.153798666666667], [3.707220000000002, 8.468123415263465, 21.153798666666667], [3.7072200000000004, 4.187394485373135, 10.699534666666667], [5.4799999999999995, 1.11684945473118, 10.699534666666667], [7.2527800000000004, 4.187394485373134, 10.699534666666667], [1.7727800000000027, 5.304243940104314, 13.190465333333334], [2.1613644207718602e-15, 8.374788970746268, 13.190465333333334], [-1.772779999999998, 5.304243940104314, 13.190465333333334], [9.187220000000002, 1.0235150102139838, 2.7362013333333333], [5.480000000000003, 7.444608405049479, 2.7362013333333333], [1.7727799999999982, 1.0235150102139847, 2.7362013333333333], [-4.036567999999998, 8.658272571720529, 0.31057], [5.029416882962324e-16, 1.6667317075138401, 0.31057], [4.036568000000003, 8.658272571720529, 0.31057], [9.516568000000001, 0.8333658537569201, 23.57943], [5.480000000000003, 7.824906717963609, 23.57943], [1.4434320000000005, 0.8333658537569201, 23.57943], [1.4434320000000014, 5.494393096561379, 16.237236666666668], [2.2271180455391e-15, 7.994490657832139, 16.237236666666668], [-1.4434319999999987, 5.494393096561379, 16.237236666666668], [-1.443431999999998, 7.161124804075219, 15.616096666666666], [1.139078165124374e-15, 4.661027242804459, 15.616096666666666], [1.443432000000003, 7.161124804075219, 15.616096666666666], [6.923432000000002, 2.3305136214022295, 8.273903333333333], [5.480000000000002, 4.83061118267299, 8.273903333333333], [4.036568000000001, 2.3305136214022295, 8.273903333333333], [4.036568000000001, 3.9972453289160694, 7.652763333333333], [5.48, 1.4971477676453093, 7.652763333333333], [6.923432000000001, 3.9972453289160694, 7.652763333333333], [10.053005200000001, 0.5236536919335908, 1.3777363], [5.480000000000004, 8.444331041610267, 1.3777363], [0.9069948000000003, 0.5236536919335908, 1.3777363], [-4.573005199999998, 8.967984733543858, 22.512263700000002], [3.4910456747638817e-16, 1.0473073838671816, 22.512263700000002], [4.5730052000000025, 8.967984733543858, 22.512263700000002], [-0.9069947999999985, 6.851412642251891, 17.304402966666665], [1.333993537855349e-15, 5.280451566451117, 17.304402966666665], [0.9069948000000017, 6.851412642251891, 17.304402966666665], [0.9069948000000019, 5.804105258384707, 14.548930366666665], [2.0322026728081252e-15, 7.3750663341854805, 14.548930366666665], [-0.9069947999999983, 5.804105258384707, 14.548930366666665], [4.573005200000001, 3.6875331670927403, 9.341069633333333], [5.48, 2.116572091291968, 9.341069633333333], [6.386994800000001, 3.6875331670927403, 9.341069633333333], [6.386994800000002, 2.6402257832255587, 6.585597033333333], [5.480000000000002, 4.2111868590263315, 6.585597033333333], [4.573005200000001, 2.6402257832255587, 6.585597033333333], [-1.1995171999999976, 8.694625546890107, 0.3256207], [-1.4500079999999989, 4.105513284556015, 0.3256207], [2.6495252000000025, 6.183138019508774, 0.3256207], [8.129525200000002, 3.3085004059686742, 23.5643793], [4.029992000000001, 5.3861251409214335, 23.5643793], [4.2804828, 0.7970128785873414, 23.5643793], [6.6795172, 0.7970128785873414, 23.5643793], [6.930008000000001, 5.3861251409214335, 23.5643793], [2.8304748000000006, 3.3085004059686742, 23.5643793], [-2.649525199999998, 6.183138019508774, 0.3256207], [1.4500080000000015, 4.105513284556015, 0.3256207], [1.199517200000003, 8.694625546890107, 0.3256207], [4.2804828000000015, 5.530746071730958, 16.252287366666668], [4.029992000000001, 0.9416338093968661, 16.252287366666668], [8.129525200000002, 3.0192585443496247, 16.252287366666668], [2.6495252000000007, 0.14462093080952376, 15.601045966666666], [9.509992, 2.2222456657622836, 15.601045966666666], [4.280482800000002, 7.12477182890564, 15.601045966666666], [6.679517200000002, 7.12477182890564, 15.601045966666666], [1.4500080000000006, 2.2222456657622836, 15.601045966666666], [8.310474800000001, 0.14462093080952376, 15.601045966666666], [2.8304748000000015, 3.0192585443496247, 16.252287366666668], [6.930008000000001, 0.9416338093968661, 16.252287366666668], [6.679517200000001, 5.530746071730958, 16.252287366666668], [-1.1995172000000005, 2.3668665965718083, 8.288954033333333], [4.029992000000003, 7.269392759715165, 8.288954033333333], [-2.8304747999999975, 9.347017494667924, 8.288954033333333], [2.649525200000002, 6.472379881127824, 7.637712633333334], [-1.450007999999998, 8.550004616080583, 7.637712633333334], [-1.1995171999999987, 3.9608923537464906, 7.637712633333334], [1.1995172000000012, 3.9608923537464906, 7.637712633333334], [1.4500080000000024, 8.550004616080583, 7.637712633333334], [-2.649525199999998, 6.472379881127824, 7.637712633333334], [2.830474800000003, 9.347017494667924, 8.288954033333333], [-4.029991999999999, 7.269392759715165, 8.288954033333333], [1.1995172000000007, 2.3668665965718083, 8.288954033333333], [-1.6774827999999975, 8.397916929709682, 2.0824913], [-0.9540679999999986, 3.8399372414111568, 2.0824913], [2.631550800000002, 6.745422679834059, 2.0824913], [8.111550800000002, 2.74621574564339, 21.8075087], [4.525932000000003, 5.651701184066292, 21.8075087], [3.8025172000000005, 1.093721495767767, 21.8075087], [7.157482800000001, 1.093721495767767, 21.8075087], [6.434068000000003, 5.651701184066292, 21.8075087], [2.848449200000001, 2.74621574564339, 21.8075087], [-2.6315507999999976, 6.745422679834059, 2.0824913], [0.9540680000000008, 3.8399372414111568, 2.0824913], [1.6774828000000028, 8.397916929709682, 2.0824913], [3.8025172000000023, 5.234037454550532, 18.009157966666667], [4.525932000000002, 0.676057766252007, 18.009157966666667], [8.1115508, 3.581543204674909, 18.009157966666667], [-2.8484491999999975, 9.073974695961688, 13.844175366666667], [-0.9540679999999984, 2.487821708907141, 13.844175366666667], [3.8025172000000014, 7.421480446086066, 13.844175366666667], [-3.8025171999999983, 7.421480446086066, 13.844175366666667], [0.9540680000000017, 2.487821708907141, 13.844175366666667], [2.848449200000002, 9.073974695961688, 13.844175366666667], [2.8484492000000023, 3.581543204674909, 18.009157966666667], [6.434068000000001, 0.676057766252007, 18.009157966666667], [7.157482800000001, 5.234037454550532, 18.009157966666667], [9.282517200000001, 2.070157979391383, 10.045824633333334], [4.525932000000004, 7.003816716570306, 10.045824633333334], [2.6315507999999985, 0.4176637295157594, 10.045824633333334], [2.6315508000000007, 5.91009522080254, 5.880842033333333], [-0.954067999999997, 8.815580659225441, 5.880842033333333], [-1.6774827999999995, 4.257600970926917, 5.880842033333333], [1.6774828000000008, 4.257600970926917, 5.880842033333333], [0.9540680000000019, 8.815580659225441, 5.880842033333333], [-2.6315507999999985, 5.91009522080254, 5.880842033333333], [8.328449200000001, 0.4176637295157594, 10.045824633333334], [6.434068000000003, 7.003816716570306, 10.045824633333334], [1.6774827999999988, 2.070157979391383, 10.045824633333334], [8.851350800000002, 2.9588284463740853, 4.8694987], [3.9719040000000017, 6.186080427420673, 4.8694987], [3.6167452000000004, 0.3467295516826912, 4.8694987], [-1.8632547999999975, 9.144908873794758, 19.020501300000003], [-1.5080959999999992, 3.3055579980567766, 19.020501300000003], [3.371350800000002, 6.532809979103363, 19.020501300000003], [-3.371350799999998, 6.532809979103363, 19.020501300000003], [1.5080960000000012, 3.3055579980567766, 19.020501300000003], [1.863254800000002, 9.144908873794758, 19.020501300000003], [7.3432548, 0.3467295516826912, 4.8694987], [6.988096000000003, 6.186080427420673, 4.8694987], [2.1086492000000012, 2.9588284463740853, 4.8694987], [-2.1086491999999972, 9.286587396692383, 20.796165366666667], [-1.5080959999999992, 3.0222009522615223, 20.796165366666667], [3.6167452000000018, 6.674488502000989, 20.796165366666667], [3.6167452000000013, 5.9810293986356085, 11.057167966666666], [3.9719039999999994, 0.14167852289762756, 11.057167966666666], [8.8513508, 3.3689305039442137, 11.057167966666666], [2.108649200000001, 3.3689305039442137, 11.057167966666666], [6.988096, 0.14167852289762756, 11.057167966666666], [7.343254800000001, 5.9810293986356085, 11.057167966666666], [-3.616745199999998, 6.674488502000989, 20.796165366666667], [1.5080960000000012, 3.0222009522615223, 20.796165366666667], [2.1086492000000026, 9.286587396692383, 20.796165366666667], [3.3713508000000023, 6.122707921533235, 12.832832033333334], [-1.5080959999999974, 9.34995990257982, 12.832832033333334], [-1.8632547999999982, 3.510609026841841, 12.832832033333334], [9.096745199999999, 2.817149923476458, 3.0938346333333326], [3.9719040000000017, 6.469437473215925, 3.0938346333333326], [3.3713507999999996, 0.20505102878506423, 3.0938346333333326], [7.5886492, 0.20505102878506423, 3.0938346333333326], [6.988096000000001, 6.469437473215925, 3.0938346333333326], [1.8632548000000004, 2.817149923476458, 3.0938346333333326], [1.8632548000000009, 3.510609026841841, 12.832832033333334], [1.5080960000000037, 9.34995990257982, 12.832832033333334], [-3.3713507999999974, 6.122707921533235, 12.832832033333334], [-0.9294079999999997, 1.6401551199225033, 4.207029], [4.524288000000002, 7.866669927035709, 4.207029], [-3.594879999999997, 9.476451803996685, 4.207029], [1.8851200000000004, 0.015186621480763919, 19.682971], [10.004288, 1.6249684984417394, 19.682971], [4.550592000000003, 7.851483305554945, 19.682971], [6.4094080000000035, 7.851483305554945, 19.682971], [0.9557120000000006, 1.6249684984417394, 19.682971], [9.07488, 0.015186621480763919, 19.682971], [3.594880000000003, 9.476451803996685, 4.207029], [-4.524287999999998, 7.866669927035709, 4.207029], [0.9294080000000006, 1.6401551199225033, 4.207029], [-0.9294079999999979, 7.967914070240802, 20.133695666666668], [-0.9557119999999988, 4.7027904518765595, 20.133695666666668], [1.8851200000000017, 6.312572328837534, 20.133695666666668], [1.885120000000002, 6.3429455717990635, 11.719637666666666], [-0.9557119999999978, 7.952727448760038, 11.719637666666666], [-0.9294079999999989, 4.687603830395796, 11.719637666666666], [0.9294080000000016, 4.687603830395796, 11.719637666666666], [0.9557120000000024, 7.952727448760038, 11.719637666666666], [-1.8851199999999988, 6.3429455717990635, 11.719637666666666], [-1.8851199999999984, 6.312572328837534, 20.133695666666668], [0.9557120000000012, 4.7027904518765595, 20.133695666666668], [0.9294080000000021, 7.967914070240802, 20.133695666666668], [4.550592000000002, 4.804034595081653, 12.170362333333333], [4.524288, 1.53891097671741, 12.170362333333333], [7.365120000000002, 3.148692853678386, 12.170362333333333], [7.365120000000001, 3.179066096639913, 3.756304333333333], [4.524288, 4.788847973600888, 3.756304333333333], [4.550592000000001, 1.5237243552366462, 3.756304333333333], [6.409408, 1.5237243552366462, 3.756304333333333], [6.435712000000001, 4.788847973600888, 3.756304333333333], [3.594880000000001, 3.179066096639913, 3.756304333333333], [3.5948800000000003, 3.148692853678386, 12.170362333333333], [6.435712000000001, 1.53891097671741, 12.170362333333333], [6.409408000000002, 4.804034595081653, 12.170362333333333]],
                "lattice_vectors": [[10.96, 0.0, 0.0], [-5.479999999999998, 9.491638425477449, 0.0], [0.0, 0.0, 23.89]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_0": 2}, "h": {"X_0": 54}, "i": {"X_0": 48}}
            },
            {
                "Notes": "$\\alpha$&ndash;As (A7) Structure",
                "Pearsons Symbol": "hR2",
                "Prototype": "As",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "$A7$",
                "aflow_prototype_id": "A_hR2_166_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hR2_166_c.alpha-As.html",
                "atom_labels": ["As", "As", "As", "As", "As", "As"],
                "atom_positions": [[0.0, 0.0, 2.379454042], [0.0, 0.0, 8.077845958000001], [5.136539342013671e-16, 2.170548337018398, 9.350987375333332], [5.136539342013671e-16, 2.170548337018398, 4.5920792913333335], [1.87975, 1.085274168509199, 5.865220708666667], [1.87975, 1.085274168509199, 1.1063126246666666]],
                "lattice_vectors": [[3.7595, 0.0, 0.0], [-1.8797499999999991, 3.2558225055275973, 0.0], [0.0, 0.0, 10.4573]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}}
            },
            {
                "Notes": "CaC<sub>6</sub> Structure",
                "Pearsons Symbol": "hR7",
                "Prototype": "C6Ca",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A6B_hR7_166_g_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A6B_hR7_166_g_a.html",
                "atom_labels": ["Ca", "Ca", "Ca", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C"],
                "atom_positions": [[0.0, 0.0, 0.0], [5.982814244021029e-16, 2.5016818104094156, 9.048866666666665], [2.16652, 1.2508409052047078, 4.524433333333333], [2.8887077767999996, 0.0, 6.78665], [-1.4443538883999991, 2.5016943188184677, 6.78665], [0.7221661116000003, 1.250828396795656, 6.78665], [1.4443322232, 0.0, 6.78665], [-0.7221661115999997, 1.250828396795656, 6.78665], [1.4443538884000005, 2.5016943188184677, 6.78665], [-1.444332223199999, 2.5016818104094156, 2.2622166666666645], [0.7221661116000002, 1.25085341361376, 2.2622166666666645], [0.7221661116000011, 3.752510207205072, 2.2622166666666645], [1.4443322232000009, 2.5016818104094156, 2.2622166666666663], [-0.7221661115999991, 3.752510207205072, 2.2622166666666663], [-0.7221661115999994, 1.25085341361376, 2.2622166666666663], [0.7221877768, 1.2508409052047078, 11.311083333333332], [2.8886861115999993, 1.2508409052129025e-05, 11.311083333333332], [2.8886861115999998, 2.501669302000364, 11.311083333333332], [3.6108522231999993, 1.2508409052047078, 11.311083333333332], [1.4443538884000002, 2.501669302000364, 11.311083333333332], [1.4443538883999996, 1.2508409052129025e-05, 11.311083333333332]],
                "lattice_vectors": [[4.33304, 0.0, 0.0], [-2.166519999999999, 3.752522715614124, 0.0], [0.0, 0.0, 13.5733]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "g": {"X_0": 6}}
            },
            {
                "Notes": "$\\beta$&ndash;O Structure",
                "Pearsons Symbol": "hR2",
                "Prototype": "O",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_hR2_166_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hR2_166_c.beta-O.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.6125583], [0.0, 0.0, 10.6684417], [5.049479353165983e-16, 1.8989050353646793, 8.133224966666667], [5.049479353165983e-16, 1.8989050353646793, 6.908108366666666], [1.6445000000000003, 0.9494525176823396, 4.372891633333333], [1.6445000000000003, 0.9494525176823396, 3.147775033333333]],
                "lattice_vectors": [[3.289, 0.0, 0.0], [-1.6444999999999994, 2.848357553047019, 0.0], [0.0, 0.0, 11.281]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}}
            },
            {
                "Notes": "SmSI Structure",
                "Pearsons Symbol": "hR6",
                "Prototype": "ISSm",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_hR6_166_c_c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_hR6_166_c_c_c.html",
                "atom_labels": ["I", "I", "I", "I", "I", "I", "S", "S", "S", "S", "S", "S", "Sm", "Sm", "Sm", "Sm", "Sm", "Sm"],
                "atom_positions": [[0.0, 0.0, 3.5536099], [0.0, 0.0, 27.1073901], [5.894322067471573e-16, 2.225569817672169, 23.994276566666667], [5.894322067471573e-16, 2.225569817672169, 16.887056766666667], [1.9274000000000002, 1.1127849088360846, 13.773943233333334], [1.9274000000000002, 1.1127849088360846, 6.666723433333333], [0.0, 0.0, 9.2504237], [0.0, 0.0, 21.4105763], [5.894322067471573e-16, 2.225569817672169, 29.691090366666664], [5.894322067471573e-16, 2.225569817672169, 11.190242966666665], [1.9274000000000002, 1.1127849088360846, 19.470757033333335], [1.9274000000000002, 1.1127849088360846, 0.9699096333333321], [0.0, 0.0, 11.697171500000001], [0.0, 0.0, 18.9638285], [5.894322067471573e-16, 2.225569817672169, 1.4768381666666675], [5.894322067471573e-16, 2.225569817672169, 8.743495166666666], [1.9274000000000002, 1.1127849088360846, 21.917504833333332], [1.9274000000000002, 1.1127849088360846, 29.184161833333334]],
                "lattice_vectors": [[3.8548, 0.0, 0.0], [-1.9273999999999991, 3.3383547265082543, 0.0], [0.0, 0.0, 30.661]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1, "X_1": 1, "X_2": 1}}
            },
            {
                "Notes": "Al<sub>4</sub>C<sub>3</sub> ($D7_{1}$) Structure",
                "Pearsons Symbol": "hR7",
                "Prototype": "Al4C3",
                "Space Group Number": 166,
                "Space Group Symbol": "$R\\bar{3}m$",
                "Strukturbericht Designation": "$D7_{1}$",
                "aflow_prototype_id": "A4B3_hR7_166_2c_ac",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B3_hR7_166_2c_ac.html",
                "atom_labels": ["C", "C", "C", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "C", "C", "C", "C", "C", "C"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.317842379938004e-16, 1.925463147747402, 16.644666666666666], [1.6675, 0.962731573873701, 8.322333333333333], [0.0, 0.0, 7.345790739999999], [0.0, 0.0, 17.62120926], [4.317842379938004e-16, 1.925463147747402, 23.990457406666664], [4.317842379938004e-16, 1.925463147747402, 9.298875926666666], [1.6675, 0.962731573873701, 15.668124073333331], [1.6675, 0.962731573873701, 0.9765425933333333], [0.0, 0.0, 3.23747089], [0.0, 0.0, 21.72952911], [4.317842379938004e-16, 1.925463147747402, 19.882137556666667], [4.317842379938004e-16, 1.925463147747402, 13.407195776666663], [1.6675, 0.962731573873701, 11.559804223333332], [1.6675, 0.962731573873701, 5.084862443333332], [0.0, 0.0, 5.4128456], [0.0, 0.0, 19.554154399999998], [4.317842379938004e-16, 1.925463147747402, 22.057512266666663], [4.317842379938004e-16, 1.925463147747402, 11.231821066666665], [1.6675, 0.962731573873701, 13.735178933333334], [1.6675, 0.962731573873701, 2.909487733333333]],
                "lattice_vectors": [[3.335, 0.0, 0.0], [-1.6674999999999993, 2.8881947216211032, 0.0], [0.0, 0.0, 24.967]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 4, "X_1": 2}}
            }
        ],
        167: [
            {
                "Notes": "Calcite (CaCO<sub>3</sub>, G0<sub>1</sub>) Structure",
                "Pearsons Symbol": "hR10",
                "Prototype": "CCaO3",
                "Space Group Number": 167,
                "Space Group Symbol": "$R\\bar{3}c$",
                "Strukturbericht Designation": "$G0_{1}$",
                "aflow_prototype_id": "ABC3_hR10_167_a_b_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC3_hR10_167_a_b_e.CaCO3.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "Ca", "Ca", "Ca", "Ca", "Ca", "Ca", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 4.26525], [0.0, 0.0, 12.79575], [6.10400618938911e-16, 2.8798231427178536, 15.639249999999999], [6.10400618938911e-16, 2.8798231427178536, 7.10875], [2.494, 1.4399115713589268, 9.95225], [2.494, 1.4399115713589268, 1.4217499999999996], [0.0, 0.0, 0.0], [0.0, 0.0, 8.5305], [6.10400618938911e-16, 2.8798231427178536, 11.373999999999999], [6.10400618938911e-16, 2.8798231427178536, 2.8434999999999997], [2.494, 1.4399115713589268, 5.686999999999999], [2.494, 1.4399115713589268, 14.217500000000001], [3.7075804000000003, 0.0, 4.26525], [-1.8537901999999995, 3.2108588129732705, 4.26525], [0.6402098000000004, 1.1088759011035096, 4.26525], [1.2804196000000003, 0.0, 12.79575], [-0.6402097999999999, 1.1088759011035096, 12.79575], [1.8537902000000008, 3.2108588129732705, 12.79575], [-1.2804195999999994, 2.8798231427178536, 15.639249999999999], [0.6402098000000005, 1.7709472416143437, 15.639249999999999], [0.6402098000000015, 3.988699043821363, 15.639249999999999], [1.2804196000000014, 2.8798231427178536, 7.10875], [-0.6402097999999993, 3.988699043821363, 7.10875], [-0.6402097999999995, 1.7709472416143437, 7.10875], [1.2135804, 1.4399115713589268, 9.95225], [3.1342098000000003, 0.33103567025541725, 9.95225], [3.1342098000000007, 2.5487874724624366, 9.95225], [3.7744196000000008, 1.4399115713589268, 1.4217499999999996], [1.8537902000000004, 2.5487874724624366, 1.4217499999999996], [1.8537901999999997, 0.33103567025541725, 1.4217499999999996]],
                "lattice_vectors": [[4.988, 0.0, 0.0], [-2.4939999999999993, 4.31973471407678, 0.0], [0.0, 0.0, 17.061]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "e": {"X_0": 3}}
            },
            {
                "Notes": "Paraelectric LiNbO<sub>3</sub> Structure",
                "Pearsons Symbol": "hR10",
                "Prototype": "LiNbO3",
                "Space Group Number": 167,
                "Space Group Symbol": "$R\\bar{3}c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC3_hR10_167_a_b_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC3_hR10_167_a_b_e.LiNbO3.html",
                "atom_labels": ["Li", "Li", "Li", "Li", "Li", "Li", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 3.4622], [0.0, 0.0, 10.386600000000001], [9.859705644525244e-16, 3.0512961726671723, 12.694733333333334], [9.859705644525244e-16, 3.0512961726671723, 5.770333333333333], [2.6425000000000005, 1.5256480863335862, 8.078466666666666], [2.6425000000000005, 1.5256480863335862, 1.1540666666666666], [0.0, 0.0, 0.0], [0.0, 0.0, 6.9244], [9.859705644525244e-16, 3.0512961726671723, 9.232533333333333], [9.859705644525244e-16, 3.0512961726671723, 2.308133333333333], [2.6425000000000005, 1.5256480863335862, 4.616266666666666], [2.6425000000000005, 1.5256480863335862, 11.540666666666668], [2.0739925500000003, 0.0, 3.4622], [-1.0369962749999995, 1.7961302355596678, 3.4622], [1.6055037250000008, 2.7808140234410907, 3.4622], [3.21100745, 0.0, 10.386600000000001], [-1.605503724999999, 2.7808140234410907, 10.386600000000001], [1.0369962750000008, 1.7961302355596678, 10.386600000000001], [2.0739925500000007, 3.0512961726671723, 12.694733333333334], [1.6055037250000004, 0.2704821492260811, 12.694733333333334], [4.248003725000001, 1.2551659371075046, 12.694733333333334], [3.211007450000001, 3.0512961726671723, 5.770333333333333], [1.0369962750000006, 1.2551659371075046, 5.770333333333333], [3.679496275, 0.2704821492260811, 5.770333333333333], [-0.56850745, 1.5256480863335862, 8.078466666666666], [1.605503725000001, 3.321778321893254, 8.078466666666666], [-1.036996274999999, 4.306462109774677, 8.078466666666666], [0.5685074500000002, 1.5256480863335862, 1.1540666666666666], [1.0369962750000012, 4.306462109774677, 1.1540666666666666], [-1.6055037249999995, 3.321778321893254, 1.1540666666666666]],
                "lattice_vectors": [[5.285, 0.0, 0.0], [-2.6424999999999987, 4.576944259000759, 0.0], [0.0, 0.0, 13.8488]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "e": {"X_0": 3}}
            },
            {
                "Notes": "Corundum (Al<sub>2</sub>O<sub>3</sub>, D5<sub>1</sub>) Structure",
                "Pearsons Symbol": "hR10",
                "Prototype": "Al2O3",
                "Space Group Number": 167,
                "Space Group Symbol": "$R\\bar{3}c$",
                "Strukturbericht Designation": "$D5_{1}$",
                "aflow_prototype_id": "A2B3_hR10_167_c_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_hR10_167_c_e.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 4.576213552], [0.0, 0.0, 1.9211364480000004], [0.0, 0.0, 8.418486448], [0.0, 0.0, 11.073563552], [6.802095923556332e-16, 2.7485914265310516, 0.2446468853333318], [6.802095923556332e-16, 2.7485914265310516, 10.584269781333333], [6.802095923556332e-16, 2.7485914265310516, 4.086919781333333], [6.802095923556332e-16, 2.7485914265310516, 6.741996885333333], [2.3803500000000004, 1.3742957132655258, 8.907780218666666], [2.3803500000000004, 1.3742957132655258, 6.252703114666668], [2.3803500000000004, 1.3742957132655258, 12.750053114666667], [2.3803500000000004, 1.3742957132655258, 2.410430218666666], [1.4572502699999998, 0.0, 3.248675], [-0.7286251349999997, 1.2620157534917322, 3.248675], [1.6517248650000003, 2.860871386304845, 3.248675], [3.3034497299999996, 0.0, 9.746025], [-1.6517248649999994, 2.860871386304845, 9.746025], [0.7286251350000001, 1.2620157534917322, 9.746025], [1.4572502700000005, 2.7485914265310516, 11.911808333333333], [-0.7286251349999988, 4.010607180022784, 11.911808333333333], [-0.7286251349999996, 1.4865756730393191, 11.911808333333333], [-1.4572502699999994, 2.7485914265310516, 5.414458333333333], [0.7286251350000004, 1.4865756730393191, 5.414458333333333], [0.728625135000001, 4.010607180022784, 5.414458333333333], [3.83760027, 1.3742957132655258, 7.580241666666666], [1.6517248650000007, 2.636311466757258, 7.580241666666666], [1.6517248649999998, 0.11227995977379344, 7.580241666666666], [0.9230997300000002, 1.3742957132655258, 1.0828916666666664], [3.108975135, 0.11227995977379344, 1.0828916666666664], [3.108975135, 2.636311466757258, 1.0828916666666664]],
                "lattice_vectors": [[4.7607, 0.0, 0.0], [-2.380349999999999, 4.122887139796577, 0.0], [0.0, 0.0, 12.9947]],
                "normalized_wyckoff_matid": {"c": {"X_1": 2}, "e": {"X_0": 3}}
            },
            {
                "Notes": "PrNiO<sub>3</sub> Structure",
                "Pearsons Symbol": "hR10",
                "Prototype": "NiO3Pr",
                "Space Group Number": 167,
                "Space Group Symbol": "$R\\bar{3}c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3C_hR10_167_b_e_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3C_hR10_167_b_e_a.html",
                "atom_labels": ["Pr", "Pr", "Pr", "Pr", "Pr", "Pr", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 3.27645], [0.0, 0.0, 9.82935], [9.151512880833935e-16, 3.1510045641562208, 12.01365], [9.151512880833935e-16, 3.1510045641562208, 5.46075], [2.7288500000000004, 1.5755022820781104, 7.6450499999999995], [2.7288500000000004, 1.5755022820781104, 1.0921499999999997], [0.0, 0.0, 0.0], [0.0, 0.0, 6.5529], [9.151512880833935e-16, 3.1510045641562208, 8.7372], [9.151512880833935e-16, 3.1510045641562208, 2.1843], [2.7288500000000004, 1.5755022820781104, 4.3686], [2.7288500000000004, 1.5755022820781104, 10.9215], [2.42649342, 0.0, 3.27645], [-1.2132467099999993, 2.101404943835784, 3.27645], [1.5156032900000007, 2.6251019023985473, 3.27645], [3.03120658, 0.0, 9.82935], [-1.5156032899999994, 2.6251019023985473, 9.82935], [1.2132467100000006, 2.101404943835784, 9.82935], [2.4264934200000017, 3.1510045641562208, 12.01365], [1.5156032900000003, 0.5259026617576731, 12.01365], [4.24445329, 1.049599620320437, 12.01365], [3.031206580000001, 3.1510045641562208, 5.46075], [1.2132467100000004, 1.049599620320437, 5.46075], [3.942096710000001, 0.5259026617576731, 5.46075], [-0.30235657999999976, 1.5755022820781104, 7.6450499999999995], [1.5156032900000007, 3.676907225913894, 7.6450499999999995], [-1.2132467099999993, 4.200604184476658, 7.6450499999999995], [0.3023565800000002, 1.5755022820781104, 1.0921499999999997], [1.2132467100000008, 4.200604184476658, 1.0921499999999997], [-1.5156032899999994, 3.676907225913894, 1.0921499999999997]],
                "lattice_vectors": [[5.4577, 0.0, 0.0], [-2.7288499999999987, 4.726506846234331, 0.0], [0.0, 0.0, 13.1058]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "e": {"X_0": 3}}
            },
            {
                "Notes": "KBO<sub>2</sub> ($F5_{13}$) Structure",
                "Pearsons Symbol": "hR24",
                "Prototype": "BKO2",
                "Space Group Number": 167,
                "Space Group Symbol": "$R\\bar{3}c$",
                "Strukturbericht Designation": "$F5_{13}$",
                "aflow_prototype_id": "ABC2_hR24_167_e_e_2e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC2_hR24_167_e_e_2e.html",
                "atom_labels": ["B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[11.342364, 0.0, 1.835], [-5.671181999999997, 9.82277536297008, 1.835], [0.7088180000000002, 1.2277087893193561, 1.835], [1.4176359999999997, 0.0, 5.505], [-0.7088179999999995, 1.2277087893193561, 5.505], [5.671182000000003, 9.82277536297008, 5.505], [-1.4176359999999986, 7.366989434859624, 6.728333333333333], [0.708818000000002, 6.139280645540267, 6.728333333333333], [0.7088180000000012, 8.59469822417898, 6.728333333333333], [1.4176360000000008, 7.366989434859624, 3.058333333333333], [-0.7088179999999978, 8.59469822417898, 3.058333333333333], [-0.7088179999999984, 6.139280645540267, 3.058333333333333], [4.962363999999999, 3.683494717429812, 4.281666666666666], [7.088818, 2.4557859281104553, 4.281666666666666], [7.088818000000001, 4.9112035067491675, 4.281666666666666], [7.797636, 3.683494717429812, 0.6116666666666665], [5.671182000000001, 4.9112035067491675, 0.6116666666666665], [5.671181999999999, 2.4557859281104553, 0.6116666666666665], [7.162188, 0.0, 1.835], [-3.5810939999999984, 6.202636754680062, 1.835], [2.7989060000000006, 4.847847397609375, 1.835], [5.597811999999999, 0.0, 5.505], [-2.798905999999999, 4.847847397609375, 5.505], [3.581094000000002, 6.202636754680062, 5.505], [7.162188000000003, 7.366989434859624, 6.728333333333333], [2.7989060000000006, 2.5191420372502487, 6.728333333333333], [9.178906000000001, 1.164352680179563, 6.728333333333333], [5.597812000000002, 7.366989434859624, 3.058333333333333], [3.581094, 1.164352680179563, 3.058333333333333], [9.961094000000001, 2.5191420372502487, 3.058333333333333], [0.782188000000001, 3.683494717429812, 4.281666666666666], [2.7989060000000014, 9.886131472109874, 4.281666666666666], [-3.581093999999999, 8.53134211503919, 4.281666666666666], [-0.7821879999999997, 3.683494717429812, 0.6116666666666665], [3.581094000000001, 8.53134211503919, 0.6116666666666665], [-2.798905999999998, 9.886131472109874, 0.6116666666666665], [10.007668, 0.0, 1.835], [-5.003833999999998, 8.666894720640606, 1.835], [1.3761660000000007, 2.3835894316488315, 1.835], [2.752332, 0.0, 5.505], [-1.3761659999999993, 2.3835894316488315, 5.505], [5.003834000000003, 8.666894720640606, 5.505], [-2.752331999999999, 7.366989434859624, 6.728333333333333], [1.3761660000000018, 4.983400003210791, 6.728333333333333], [1.3761660000000013, 9.750578866508455, 6.728333333333333], [2.752332000000001, 7.366989434859624, 3.058333333333333], [-1.3761659999999978, 9.750578866508455, 3.058333333333333], [-1.376165999999999, 4.983400003210791, 3.058333333333333], [3.6276679999999994, 3.683494717429812, 4.281666666666666], [7.756166, 1.2999052857809799, 4.281666666666666], [7.756166000000002, 6.067084149078643, 4.281666666666666], [9.132332000000002, 3.683494717429812, 0.6116666666666665], [5.003834000000001, 6.067084149078643, 0.6116666666666665], [5.0038339999999994, 1.2999052857809799, 0.6116666666666665], [1.383184, 0.0, 1.835], [-0.6915919999999997, 1.197872482108175, 1.835], [5.688408000000003, 9.852611670181261, 1.835], [11.376816, 0.0, 5.505], [-5.688407999999997, 9.852611670181261, 5.505], [0.6915920000000003, 1.197872482108175, 5.505], [1.3831840000000017, 7.366989434859624, 6.728333333333333], [-0.6915919999999977, 8.564861916967798, 6.728333333333333], [-0.691591999999999, 6.16911695275145, 6.728333333333333], [-1.3831839999999982, 7.366989434859624, 3.058333333333333], [0.691592000000001, 6.16911695275145, 3.058333333333333], [0.6915920000000023, 8.564861916967798, 3.058333333333333], [7.763184, 3.683494717429812, 4.281666666666666], [5.688408000000001, 4.881367199537987, 4.281666666666666], [5.688408000000001, 2.485622235321637, 4.281666666666666], [4.996816000000001, 3.683494717429812, 0.6116666666666665], [7.071592, 2.485622235321637, 0.6116666666666665], [7.071592000000001, 4.881367199537987, 0.6116666666666665]],
                "lattice_vectors": [[12.76, 0.0, 0.0], [-6.379999999999997, 11.050484152289437, 0.0], [0.0, 0.0, 7.34]],
                "normalized_wyckoff_matid": {"e": {"X_0": 2, "X_1": 1, "X_2": 1}}
            }
        ],
        168: [
            {
                "Notes": "Al[PO<sub>4</sub>] Structure",
                "Pearsons Symbol": "hP72",
                "Prototype": "Al[O4]P",
                "Space Group Number": 168,
                "Space Group Symbol": "$P6$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB4C_hP72_168_2d_8d_2d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4C_hP72_168_2d_8d_2d.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P"],
                "atom_positions": [[5.411784228161399, 1.3465596649296057, 5.246243955318859], [1.5397372365402016, 5.360022453852536, 5.246243955318859], [9.8878925663788, 4.01346278892293, 5.246243955318859], [1.4681855508386028, 10.569897546836815, 5.246243955318859], [5.340232542459802, 6.556434757913885, 5.246243955318859], [-3.007922787378798, 7.9029944228434905, 5.246243955318859], [-1.4475456415015988, 5.5530690606831525, 1.04538940801652], [8.2270678617282, 1.5229232316637484, 1.04538940801652], [2.7946437242298026, 7.886311382747016, 1.04538940801652], [8.327515420501602, 6.363388151083269, 1.04538940801652], [-1.3470980827281966, 10.393533980102672, 1.04538940801652], [4.085326054770201, 4.030145829019404, 1.04538940801652], [4.3034210967645, 2.4464486655756463, 0.38258231946672], [0.0330238549392009, 4.950096325767771, 0.38258231946672], [9.489542316174699, 2.503647660192125, 0.38258231946672], [2.5765486822355026, 9.470008546190774, 0.38258231946672], [6.846945924060801, 6.966360885998649, 0.38258231946672], [-2.609572537174698, 9.412809551574297, 0.38258231946672], [-0.03921582774029895, 4.991803926008954, 4.678243450321119], [9.4173026334952, 2.4619400599509427, 4.678243450321119], [2.5765486822355013, 9.38659334570841, 4.678243450321119], [6.919185606740302, 6.924653285757467, 4.678243450321119], [-2.537332854495198, 9.454517151815478, 4.678243450321119], [4.3034210967645, 2.529863866058011, 4.678243450321119], [5.1888732073218, 1.065331274731918, 6.920041602985759], [1.6718326562970014, 5.026361651923076, 6.920041602985759], [10.242899006975199, 3.961030377191159, 6.920041602985759], [1.691096571678203, 10.851125937034503, 6.920041602985759], [5.208137122703001, 6.890095559843345, 6.920041602985759], [-3.362929227975198, 7.955426834575262, 6.920041602985759], [-1.2927463214740984, 5.847405553813783, 2.72589902620038], [8.049564641429999, 1.8041516218614362, 2.72589902620038], [2.462341183904101, 7.873203279814073, 2.72589902620038], [8.172716100474101, 6.069051657952638, 2.72589902620038], [-1.1695948624299974, 10.112305589904985, 2.72589902620038], [4.417628595095901, 4.043253931952347, 2.72589902620038], [5.0815456787694, 0.12631444644472406, 0.79536850625976], [2.4313813198986005, 4.463904871527701, 0.79536850625976], [11.1097751991292, 4.337590425082977, 0.79536850625976], [1.798424100230602, 11.790142765321695, 0.79536850625976], [4.448588459101402, 7.452552340238719, 0.79536850625976], [-4.229805420129198, 7.578866786683443, 0.79536850625976], [-2.408677419627899, 4.3697648595547465, 4.09346301903098], [8.771273471247099, 0.09890659485766129, 4.09346301903098], [4.2999811118750015, 7.645598947069335, 4.09346301903098], [9.288647198627901, 7.546692352211674, 4.09346301903098], [-1.8913036922470967, 11.81755061690876, 4.09346301903098], [2.5799886671250007, 4.270858264697086, 4.09346301903098], [6.721730474083, 1.9256994854214535, 0.29952168431934], [1.6931605626119017, 6.784039090658624, 0.29952168431934], [8.731369646528902, 4.858339605237171, 0.29952168431934], [0.1582393049170019, 9.990757726344967, 0.29952168431934], [5.1868092163881006, 5.132418121107797, 0.29952168431934], [-1.8513998675288978, 7.05811760652925, 0.29952168431934], [-1.7991120972084984, 6.703007181618611, 4.98615509778666], [7.0554090083645, 1.7934268103708462, 4.98615509778666], [1.9745513265730017, 7.006876840518655, 4.98615509778666], [8.679081876208501, 5.2134500301478095, 4.98615509778666], [-0.17543922936449746, 10.123030401395575, 4.98615509778666], [4.905418452427001, 4.909580371247766, 4.98615509778666], [5.3175286421891, 1.3978004309402012, 0.0], [1.4482336384795005, 5.304015104957234, 0.0], [9.890644554290402, 3.9062146740170323, 0.0], [1.5624411368109008, 10.51865678082622, 0.0], [5.431736140520501, 6.612442106809186, 0.0], [-3.0106747752903984, 8.010242537749388, 0.0], [-1.3808099346452987, 5.46846221447961, 4.1891085988976595], [8.333707393302701, 1.5384146260390448, 4.1891085988976595], [2.8345475489480014, 7.986409623325855, 4.1891085988976595], [8.2607797136453, 6.447994997286811, 4.1891085988976595], [-1.453737614302698, 10.378042585727377, 4.1891085988976595], [4.045422230052001, 3.9300475884405652, 4.1891085988976595]],
                "lattice_vectors": [[13.759939558, 0.0, 0.0], [-6.879969778999997, 11.91645721176642, 0.0], [0.0, 0.0, 8.3899631462]],
                "normalized_wyckoff_matid": {"d": {"X_0": 4, "X_1": 1, "X_2": 1}}
            },
            {
                "Notes": "K<sub>2</sub>Ta<sub>4</sub>O<sub>9</sub>F<sub>4</sub> Structure",
                "Pearsons Symbol": "hP57",
                "Prototype": "F4K2O9Ta4",
                "Space Group Number": 168,
                "Space Group Symbol": "$P6$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B13C4_hP57_168_d_c6d_2d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B13C4_hP57_168_d_c6d_2d.html",
                "atom_labels": ["O", "O", "O", "K", "K", "K", "K", "K", "K", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta", "Ta"],
                "atom_positions": [[7.96807130425, 0.0, 0.0], [3.984035652125002, 6.900552168646306, 0.0], [-3.9840356521249984, 6.900552168646306, 0.0], [6.486010041659501, 2.4703976763753777, 2.160079329984], [1.1035778756386272, 6.852248303465782, 2.160079329984], [10.553710442479126, 4.3818506270904045, 2.160079329984], [1.482061262590505, 11.330706660917233, 2.160079329984], [6.864493428611377, 6.948856033826831, 2.160079329984], [-2.585639138229123, 9.419253710202208, 2.160079329984], [-0.9322643425972493, 2.5808065110737184, 0.0272442438016], [13.234966436359251, 0.48303865180524147, 0.0272442438016], [6.199159474706502, 11.703336478024134, 0.0272442438016], [8.900335646847253, 11.220297826218893, 0.0272442438016], [-5.266895132109247, 13.31806568548737, 0.0272442438016], [1.7689118295435007, 2.097767859268477, 0.0272442438016], [5.290799346021999, 0.4692375474679488, 0.07005662691839999], [2.23902803649425, 4.816585413715122, 0.07005662691839999], [12.884371298972251, 4.347347866247172, 0.07005662691839999], [2.677271958228004, 13.331866789824662, 0.07005662691839999], [5.729043267755753, 8.984518923577491, 0.07005662691839999], [-4.916299994722248, 9.45375647104544, 0.07005662691839999], [-0.41433970782099866, 5.354828482869534, 0.038920348288], [11.091555255516003, 2.318585528665159, 0.038920348288], [3.5378236590870027, 10.764861383088238, 0.038920348288], [8.382411012071001, 8.446275854423078, 0.038920348288], [-3.123483951265997, 11.482518808627452, 0.038920348288], [4.430247645163001, 3.0362429542043747, 0.038920348288], [-1.4262847634607474, 7.8528283679194955, 0.077840696576], [8.422251368592253, 2.6912153457720596, 0.077840696576], [1.880464827803002, 8.639491315145177, 0.077840696576], [9.394356067710751, 5.948275969373117, 0.077840696576], [-0.4541800643422474, 11.109888991520553, 0.077840696576], [6.087606476447002, 5.161613022147436, 0.077840696576], [-2.1354431095389987, 6.265701369130846, 2.0978067727232], [9.442164495536252, 1.283502703368213, 2.0978067727232], [3.609536300825253, 8.81890567152998, 2.0978067727232], [10.103514413789002, 7.535402968161767, 2.0978067727232], [-1.474093191286247, 12.5176016339244, 2.0978067727232], [4.358535003424752, 4.982198665762633, 2.0978067727232], [3.5936001582167507, 1.3111049120427982, 2.160079329984], [0.6613499182527511, 3.7677014840808836, 2.160079329984], [13.003892368536, 2.456596572038085, 2.160079329984], [4.374471146033253, 12.489999425249815, 2.160079329984], [7.306721385997253, 10.03340285321173, 2.160079329984], [-5.035821064285997, 11.344507765254527, 2.160079329984], [3.4804535456964008, 1.242099390356335, 0.3347149952768], [0.6645371467744513, 3.635210882442874, 0.3347149952768], [13.120226209578052, 2.3931114920865393, 0.3347149952768], [4.487617758553602, 12.559004946936277, 0.3347149952768], [7.3035341574755535, 10.165893454849737, 0.3347149952768], [-5.1521549053280475, 11.407992845206072, 0.3347149952768], [-2.2230918938857487, 6.028322374529413, 0.27633447284479995], [9.603916343012525, 1.088907132212387, 0.27633447284479995], [3.8589369326482763, 8.861689094975587, 0.27633447284479995], [10.191163198135754, 7.772781962763198, 0.27633447284479995], [-1.635845038762522, 12.712197205080225, 0.27633447284479995], [4.109134371601726, 4.9394152423170254, 0.27633447284479995]],
                "lattice_vectors": [[15.9361426085, 0.0, 0.0], [-7.968071304249997, 13.801104337292612, 0.0], [0.0, 0.0, 3.8920348288]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "d": {"X_0": 12, "X_1": 4, "X_2": 2}}
            }
        ],
        169: [
            {
                "Notes": "$\\alpha$&ndash;Al<sub>2</sub>S<sub>3</sub> Structure",
                "Pearsons Symbol": "hP30",
                "Prototype": "Al2S3",
                "Space Group Number": 169,
                "Space Group Symbol": "$P6_{1}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B3_hP30_169_2a_3a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_hP30_169_2a_3a.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[-1.0670604340476795, 1.9929852759399318, 2.2772009274319363], [4.17050555904384, 0.07239119471142529, 5.257206328698603], [2.0225601658915213, 3.6479593581119008, 8.237211729965269], [4.282066261247682, 3.5755681634004755, 11.217217131231937], [-0.9554997318438389, 5.496162244628982, 14.197222532498603], [1.1924456613084806, 1.9205940812285063, 17.177227933765273], [1.1098200115494403, 1.7964153395312155, 5.343626485335337], [-1.0008313140073597, 1.859339993395762, 8.323631886602003], [4.319360328843201, 0.06292465386454647, 11.303637287868671], [2.105185815650561, 3.772138099809192, 14.283642689135338], [4.215837141207361, 3.7092134459446453, 17.263648090402004], [-1.1043545016431988, 5.505628785475861, 2.3636210840686704], [2.15212490072768, 0.0, 0.07152012963040001], [1.0760624503638405, 1.8637948361472343, 3.051525530897067], [-1.0760624503638396, 1.8637948361472343, 6.031530932163734], [4.277886753672321, 0.0, 9.011536333430401], [2.138943376836161, 3.7047586031931727, 11.991541734697067], [-2.1389433768361594, 3.7047586031931727, 14.971547135963736], [-0.9982593093455996, 1.861567414771498, 0.0], [4.318717327677761, 0.06626578592815086, 2.980005401266667], [2.101970809823361, 3.77325181049706, 5.960010802533334], [4.213265136545601, 3.706986024568909, 8.9400162038], [-1.103711500477759, 5.502287653412257, 11.920021605066667], [1.1130350173766406, 1.7953016288433472, 14.900027006333335], [2.15276790189312, 0.03563874201177861, 6.047563361222548], [1.0455198950054405, 1.8821710624970578, 9.027568762489215], [5.32276364751232, 1.846532320485279, 12.007574163755882], [1.0622379253068805, 5.5329146973286285, 14.98757956502255], [2.1694859321945614, 3.686382376843349, 0.08755255868921258], [-2.1077578203123193, 3.722021118855128, 3.067557959955881]],
                "lattice_vectors": [[6.4300116544, 0.0, 0.0], [-3.215005827199999, 5.568553439340407, 0.0], [0.0, 0.0, 17.8800324076]],
                "normalized_wyckoff_matid": {"a": {"X_0": 3, "X_1": 2}}
            }
        ],
        170: [
            {
                "Notes": "Al<sub>2</sub>S<sub>3</sub> Structure",
                "Pearsons Symbol": "hP30",
                "Prototype": "Al2S3",
                "Space Group Number": 170,
                "Space Group Symbol": "$P6_{5}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B3_hP30_170_2a_3a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3_hP30_170_2a_3a.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[-1.0670604340476795, 1.9929852759399318, 15.602831480168065], [4.17050555904384, 0.07239119471142529, 12.622826078901399], [2.0225601658915213, 3.6479593581119008, 9.642820677634731], [4.282066261247682, 3.5755681634004755, 6.662815276368066], [-0.9554997318438389, 5.496162244628982, 3.682809875101398], [1.1924456613084806, 1.9205940812285063, 0.7028044738347295], [1.1098200115494403, 1.7964153395312155, 12.536405922264665], [-1.0008313140073597, 1.859339993395762, 9.556400520997999], [4.319360328843201, 0.06292465386454647, 6.57639511973133], [2.105185815650561, 3.772138099809192, 3.5963897184646663], [4.215837141207361, 3.7092134459446453, 0.6163843171979978], [-1.1043545016431988, 5.505628785475861, 15.516411323531331], [2.15212490072768, 0.0, 17.8085122779696], [1.0760624503638405, 1.8637948361472343, 14.828506876702935], [-1.0760624503638396, 1.8637948361472343, 11.848501475436267], [4.277886753672321, 0.0, 8.8684960741696], [2.138943376836161, 3.7047586031931727, 5.888490672902933], [-2.1389433768361594, 3.7047586031931727, 2.9084852716362666], [-0.9982593093455996, 1.861567414771498, 0.0], [4.318717327677761, 0.06626578592815086, 14.900027006333335], [2.101970809823361, 3.77325181049706, 11.920021605066667], [4.213265136545601, 3.706986024568909, 8.9400162038], [-1.103711500477759, 5.502287653412257, 5.960010802533334], [1.1130350173766406, 1.7953016288433472, 2.980005401266667], [2.15276790189312, 0.03563874201177861, 11.832469046377453], [1.0455198950054405, 1.8821710624970578, 8.852463645110785], [5.32276364751232, 1.846532320485279, 5.87245824384412], [1.0622379253068805, 5.5329146973286285, 2.892452842577452], [2.1694859321945614, 3.686382376843349, 17.792479848910784], [-2.1077578203123193, 3.722021118855128, 14.812474447644119]],
                "lattice_vectors": [[6.4300116544, 0.0, 0.0], [-3.215005827199999, 5.568553439340407, 0.0], [0.0, 0.0, 17.8800324076]],
                "normalized_wyckoff_matid": {"a": {"X_0": 3, "X_1": 2}}
            }
        ],
        171: [
            {
                "Notes": "Sr[S<sub>2</sub>O<sub>6</sub>][H<sub>2</sub>O]<sub>4</sub> Structure",
                "Pearsons Symbol": "hP39",
                "Prototype": "H2O6][O]4S2Sr[",
                "Space Group Number": 171,
                "Space Group Symbol": "$P6_{2}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A10B2C_hP39_171_5c_c_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A10B2C_hP39_171_5c_c_a.html",
                "atom_labels": ["Sr", "Sr", "Sr", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 6.4299905008666665], [0.0, 0.0, 12.859981001733333], [5.4952318818263, 1.3847379339447714, 4.5587989652094585], [1.5483977125330017, 5.451379376320128, 10.988789466076124], [2.373156494106701, 4.0666414423753565, 17.418779966942793], [-2.335236550126299, 4.088534532240096, 4.5587989652094585], [1.611597619167, 0.02189308986473947, 10.988789466076124], [0.7868388375933003, 1.406631023809511, 17.418779966942793], [-0.6888789823105996, 1.357371571613847, 2.128455455596884], [4.8000329088523, 0.082099086992773, 8.55844595646355], [2.3289165594629004, 4.197999981563793, 14.988436457330216], [3.8488743140106005, 4.11590089457102, 2.128455455596884], [-1.6400375771522988, 5.391173379192094, 8.55844595646355], [0.8310787722371002, 1.275272484621074, 14.988436457330216], [3.6971945380890006, 1.0508683135074945, 3.227790931530058], [0.9385186135149011, 3.727298549471895, 9.657781432396725], [3.5613147388259003, 2.6764302359644003, 16.08777193326339], [-0.5371992063889993, 4.422404152677373, 3.227790931530058], [2.2214767181850994, 1.7459739167129724, 9.657781432396725], [-0.4013194071258991, 2.7968422302204665, 16.08777193326339], [2.2372766948436005, 1.028975223642755, 5.696907283862858], [0.22751966388240066, 2.4520260648508208, 12.126897784729525], [4.310233632438801, 1.4230508412080656, 18.55688828559619], [0.9227186368564011, 4.444297242542112, 5.696907283862858], [2.932475667817601, 3.021246401334047, 12.126897784729525], [-1.150238300738799, 4.0502216249768015, 18.55688828559619], [2.0476769749416004, 1.3683181165462168, 0.9259186321248001], [-0.16115976191669945, 2.4574993373170053, 7.355909132991466], [4.1111539265417, 1.0891812207707887, 13.785899633858133], [1.1123183567584005, 4.104954349638651, 0.9259186321248001], [3.3211550936167002, 3.0157731288678615, 7.355909132991466], [-0.9511585948416986, 4.384091245414078, 13.785899633858133], [2.1519568208877, 0.3557627103020164, 9.73506991821714], [0.7678788656031006, 2.0415306298869553, 16.165060419083808], [4.9359127081154, 1.685767919584939, 3.3050794173504716], [1.0080385108123013, 5.1175097558828515, 9.73506991821714], [2.3921164660969003, 3.431741836297912, 16.165060419083808], [-1.7759173764153988, 3.7875045465999277, 3.3050794173504716]],
                "lattice_vectors": [[6.3199906634, 0.0, 0.0], [-3.1599953316999985, 5.473272466184867, 0.0], [0.0, 0.0, 19.2899715026]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "c": {"X_0": 10, "X_1": 2}}
            }
        ],
        172: [
            {
                "Notes": "Sr[S<sub>2</sub>O<sub>6</sub>][H<sub>2</sub>O]<sub>4</sub> Structure",
                "Pearsons Symbol": "hP39",
                "Prototype": "H2O6][O]4S2Sr[",
                "Space Group Number": 172,
                "Space Group Symbol": "$P6_{4}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A10B2C_hP39_172_5c_c_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A10B2C_hP39_172_5c_c_a.html",
                "atom_labels": ["Sr", "Sr", "Sr", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "S", "S", "S", "S", "S", "S"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 12.859981001733333], [0.0, 0.0, 6.4299905008666665], [5.4952318818263, 1.3847379339447714, 14.731172537390542], [1.5483977125330017, 5.451379376320128, 8.301182036523874], [2.373156494106701, 4.0666414423753565, 1.8711915356572086], [-2.335236550126299, 4.088534532240096, 14.731172537390542], [1.611597619167, 0.02189308986473947, 8.301182036523874], [0.7868388375933003, 1.406631023809511, 1.8711915356572086], [-0.6888789823105996, 1.357371571613847, 17.161516047003115], [4.8000329088523, 0.082099086992773, 10.73152554613645], [2.3289165594629004, 4.197999981563793, 4.301535045269784], [3.8488743140106005, 4.11590089457102, 17.161516047003115], [-1.6400375771522988, 5.391173379192094, 10.73152554613645], [0.8310787722371002, 1.275272484621074, 4.301535045269784], [3.6971945380890006, 1.0508683135074945, 16.06218057106994], [0.9385186135149011, 3.727298549471895, 9.632190070203277], [3.5613147388259003, 2.6764302359644003, 3.202199569336608], [-0.5371992063889993, 4.422404152677373, 16.06218057106994], [2.2214767181850994, 1.7459739167129724, 9.632190070203277], [-0.4013194071258991, 2.7968422302204665, 3.202199569336608], [2.2372766948436005, 1.028975223642755, 13.593064218737142], [0.22751966388240066, 2.4520260648508208, 7.163073717870475], [4.310233632438801, 1.4230508412080656, 0.7330832170038097], [0.9227186368564011, 4.444297242542112, 13.593064218737142], [2.932475667817601, 3.021246401334047, 7.163073717870475], [-1.150238300738799, 4.0502216249768015, 0.7330832170038097], [2.0476769749416004, 1.3683181165462168, 18.3640528704752], [-0.16115976191669945, 2.4574993373170053, 11.934062369608531], [4.1111539265417, 1.0891812207707887, 5.504071868741867], [1.1123183567584005, 4.104954349638651, 18.3640528704752], [3.3211550936167002, 3.0157731288678615, 11.934062369608531], [-0.9511585948416986, 4.384091245414078, 5.504071868741867], [2.1519568208877, 0.3557627103020164, 9.554901584382858], [0.7678788656031006, 2.0415306298869553, 3.1249110835161895], [4.9359127081154, 1.685767919584939, 15.984892085249525], [1.0080385108123013, 5.1175097558828515, 9.554901584382858], [2.3921164660969003, 3.431741836297912, 3.1249110835161895], [-1.7759173764153988, 3.7875045465999277, 15.984892085249525]],
                "lattice_vectors": [[6.3199906634, 0.0, 0.0], [-3.1599953316999985, 5.473272466184867, 0.0], [0.0, 0.0, 19.2899715026]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "c": {"X_0": 10, "X_1": 2}}
            }
        ],
        173: [
            {
                "Notes": "$\\beta$&ndash;Si<sub>3</sub>N<sub>4</sub> Structure",
                "Pearsons Symbol": "hP14",
                "Prototype": "N4Si3",
                "Space Group Number": 173,
                "Space Group Symbol": "$P6_{3}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B3_hP14_173_bc_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B3_hP14_173_bc_c.html",
                "atom_labels": ["N", "N", "N", "N", "N", "N", "N", "N", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[-3.8015190108637506e-05, 4.389637996740904, 0.0], [3.8014809958098907, 2.194786076250087, 1.45450727385], [2.3778501413805, 0.206092473484618, 0.145450727385], [1.0104437531238006, 2.1623248655702416, 1.599958001235], [6.2356316337433, 1.9562323920856235, 0.145450727385], [1.4236688696195017, 6.378331599506373, 1.599958001235], [2.7910752578762006, 4.422099207420749, 0.145450727385], [-2.4341126227432985, 4.628191680905367, 1.599958001235], [0.21478582412150077, 2.6752515008562394, 0.0378171891201], [5.3935951728067995, 1.5236357304901151, 1.4923244629701], [1.3772903376853014, 5.432808302624866, 0.0378171891201], [3.5867331868785004, 3.909172572134751, 1.4923244629701], [-1.5920761618067985, 5.060788342500875, 0.0378171891201], [2.4242286733147, 1.1516157703661243, 1.4923244629701]],
                "lattice_vectors": [[7.603038022, 0.0, 0.0], [-3.801519010999998, 6.58442407299099, 0.0], [0.0, 0.0, 2.9090145477]],
                "normalized_wyckoff_matid": {"b": {"X_0": 1}, "c": {"X_0": 3, "X_1": 3}}
            },
            {
                "Notes": "PI<sub>3</sub> Structure",
                "Pearsons Symbol": "hP8",
                "Prototype": "I3P",
                "Space Group Number": 173,
                "Space Group Symbol": "$P6_{3}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_hP8_173_c_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hP8_173_c_b.html",
                "atom_labels": ["P", "P", "I", "I", "I", "I", "I", "I"],
                "atom_positions": [[-3.566485999443502e-05, 4.118243894976702, 0.0], [3.566450334740005, 2.0590910608135724, 3.70698544805], [-0.9989727284879593, 2.14662389713712, 1.0824397508306], [4.77445480766452, 0.20817618801013227, 4.7894251988806005], [2.2069415365524816, 4.238887246663286, 1.0824397508306], [4.56545872808796, 4.0307110586531545, 4.7894251988806005], [-1.2079688080645188, 5.969158767780143, 1.0824397508306], [1.3595444630475202, 1.938447709126988, 4.7894251988806005]],
                "lattice_vectors": [[7.1329719992, 0.0, 0.0], [-3.566485999599998, 6.177334955790275, 0.0], [0.0, 0.0, 7.4139708961]],
                "normalized_wyckoff_matid": {"b": {"X_1": 1}, "c": {"X_0": 3}}
            }
        ],
        174: [
            {
                "Notes": "Fe<sub>12</sub>Zr<sub>2</sub>P<sub>7</sub> Structure",
                "Pearsons Symbol": "hP21",
                "Prototype": "Fe12P7Zr2",
                "Space Group Number": 174,
                "Space Group Symbol": "$P\\bar{6}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A12B7C2_hP21_174_2j2k_ajk_cf",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A12B7C2_hP21_174_2j2k_ajk_cf.html",
                "atom_labels": ["P", "Zr", "Zr", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "P", "P", "P", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "P", "P", "P"],
                "atom_positions": [[0.0, 0.0, 0.0], [-4.500201065241035e-05, 5.196410574955227, 0.0], [4.500246067410654, 2.5981663145931657, 1.79604033545], [2.204648501939461, 2.8988031452230474, 0.0], [5.38764071549688, 0.4598800364833551, 0.0], [5.908313978763662, 4.4358937078419896, 0.0], [-0.1773079219767594, 2.1606567137828145, 0.0], [2.7176714233950614, 6.560695367932882, 0.0], [-2.540363501418298, 6.867801697381089, 0.0], [3.2050431987778802, 0.9384670575016264, 0.0], [6.585144218999821, 2.306415301617369, 0.0], [3.7104157784223, 4.549694530429397, 0.0], [-1.5161177389332592, 3.3976560661541444, 1.79604033545], [2.315803468254842, 4.782752379426893, 1.79604033545], [-0.7996857293215782, 7.408745333515747, 1.79604033545], [1.4508648234849604, 0.9665275343040006, 1.79604033545], [7.43793232089312, 0.7732220274432006, 1.79604033545], [4.6118060518219215, 6.054827327801191, 1.79604033545], [0.7569338192002805, 3.1926586939590216, 1.79604033545], [1.3568106212181024, 6.853771458979901, 1.79604033545], [-2.1137444404183787, 5.542723626157862, 1.79604033545]],
                "lattice_vectors": [[9.0004021308, 0.0, 0.0], [-4.500201065399998, 7.7945768895483925, 0.0], [0.0, 0.0, 3.5920806709]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_2": 1}, "f": {"X_2": 1}, "j": {"X_0": 6, "X_1": 3}, "k": {"X_0": 6, "X_1": 3}}
            },
            {
                "Notes": "GdSI Structure",
                "Pearsons Symbol": "hP12",
                "Prototype": "GdIS",
                "Space Group Number": 174,
                "Space Group Symbol": "$P\\bar{6}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_hP12_174_cj_fk_aj",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_hP12_174_cj_fk_aj.html",
                "atom_labels": ["S", "Gd", "I", "Gd", "Gd", "Gd", "S", "S", "S", "I", "I", "I"],
                "atom_positions": [[0.0, 0.0, 0.0], [-5.365160787150567e-05, 6.195185025414543, 0.0], [5.3652144389578735, 3.0975460490518993, 2.1200635357], [2.409010845128024, 1.4341471867224058, 0.0], [8.2838082556684, 1.3691909965118856, 0.0], [5.402663261253578, 6.48939289123215, 0.0], [-2.4035383811249247, 4.807408566753724, 0.0], [2.4035920327328015, 4.80750149406447, 0.0], [-5.365160787116736e-05, 8.97055208811469, 0.0], [-0.08042376020237563, 2.9209841586370366, 2.1200635357], [2.8757261820196027, 7.762589975744797, 2.1200635357], [-2.795302421817221, 7.90188801455105, 2.1200635357]],
                "lattice_vectors": [[10.7303215747, 0.0, 0.0], [-5.365160787349997, 9.292731074466442, 0.0], [0.0, 0.0, 4.2401270714]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_1": 1}, "f": {"X_2": 1}, "j": {"X_0": 3, "X_1": 3}, "k": {"X_2": 3}}
            }
        ],
        175: [
            {
                "Notes": "Nb<sub>7</sub>Ru<sub>6</sub>B<sub>8</sub> Structure",
                "Pearsons Symbol": "hP21",
                "Prototype": "B8Nb7Ru6",
                "Space Group Number": 175,
                "Space Group Symbol": "$P6/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A8B7C6_hP21_175_ck_aj_k",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A8B7C6_hP21_175_ck_aj_k.html",
                "atom_labels": ["Nb", "B", "B", "Nb", "Nb", "Nb", "Nb", "Nb", "Nb", "B", "B", "B", "B", "B", "B", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru"],
                "atom_positions": [[0.0, 0.0, 0.0], [-4.752881268827411e-05, 5.488182000882027, 0.0], [4.752833740137311, 2.744049839281813, 0.0], [3.0438877510736493, 0.7101946408509344, 0.0], [0.9068972749283501, 2.991181439123531, 0.0], [7.368772061754702, 2.2809867982725964, 0.0], [1.7089935178763525, 7.522037199312906, 0.0], [3.845983994021653, 5.241050401040308, 0.0], [-2.6158907928047, 5.951245041891243, 0.0], [-0.42205585668275963, 1.8193232366762084, 1.5641444716], [7.719154468901695, 0.5441505246348298, 1.5641444716], [3.3883290566344573, 6.95705912812246, 1.5641444716], [5.174937125632762, 6.412908603487631, 1.5641444716], [-2.9662731999516936, 7.6880813155290095, 1.5641444716], [1.3645522123155458, 1.2751727120413785, 1.5641444716], [-0.9773349753341878, 4.229144463247369, 1.5641444716], [5.354548508786381, 1.2681753149772395, 1.5641444716], [1.57900221517057, 5.2712626918937096, 1.5641444716], [5.730216244284191, 4.00308737691647, 1.5641444716], [-0.601667239836379, 6.9640565251866, 1.5641444716], [3.173879053779432, 2.96096914827013, 1.5641444716]],
                "lattice_vectors": [[9.5057625379, 0.0, 0.0], [-4.752881268949999, 8.23223184016384, 0.0], [0.0, 0.0, 3.1282889432]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 2}, "j": {"X_1": 6}, "k": {"X_0": 6, "X_2": 6}}
            },
            {
                "Notes": "Mg[NH] Structure",
                "Pearsons Symbol": "hP36",
                "Prototype": "H]Mg[N",
                "Space Group Number": 175,
                "Space Group Symbol": "$P6/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_hP36_175_jk_jk_jk",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_hP36_175_jk_jk_jk.html",
                "atom_labels": ["H", "H", "H", "H", "H", "H", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "N", "N", "N", "N", "N", "N", "H", "H", "H", "H", "H", "H", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "N", "N", "N", "N", "N", "N"],
                "atom_positions": [[2.60664949957121, 0.5997067800371462, 0.0], [0.7839634434516709, 2.5572780754092355, 0.0], [9.757276180980462, 1.9575712953720894, 0.0], [3.1833316189787926, 9.428834692155935, 0.0], [5.006017675098331, 7.471263396783844, 0.0], [-3.9672950624304577, 8.07097017682099, 0.0], [-0.8766031413484688, 4.171873252432321, 0.0], [7.528712448450566, 1.3267760367711445, 0.0], [2.615334471249037, 7.183444256531904, 0.0], [6.666584259898472, 5.85666821976076, 0.0], [-1.7387313299005636, 8.701765435421935, 0.0], [3.174646647300966, 2.8450972156611765, 0.0], [3.5921042859484196, 0.7641748601811127, 0.0], [1.1342573011239458, 3.4929409947648495, 0.0], [9.122115252275526, 2.7287661345837373, 0.0], [2.1978768326015823, 9.264366612011967, 0.0], [4.655723817426057, 6.53560047742823, 0.0], [-3.332134133725523, 7.299775337609343, 0.0], [-0.6131590004544433, 5.743345701124976, 1.84060757675], [6.299499456982401, 2.340661579609865, 1.84060757675], [1.1226773388868463, 6.625857350677968, 1.84060757675], [6.403140119004446, 4.2851957710681035, 1.84060757675], [-0.5095183384323977, 7.687879892583214, 1.84060757675], [4.667303779663156, 3.402684121515112, 1.84060757675], [4.541082191278765, 0.7170407152618051, 1.84060757675], [1.6495656206748965, 4.291212895951419, 1.84060757675], [8.688445666496131, 3.574172180689614, 1.84060757675], [1.2488989272712376, 9.311500756931274, 1.84060757675], [4.1404154978751055, 5.737328576241661, 1.84060757675], [-2.898464547946128, 6.454369291503466, 1.84060757675], [-1.3386436346087591, 5.060402026868629, 1.84060757675], [6.5282037111651245, 1.370901619248794, 1.84060757675], [2.0768662272238867, 6.3390410645732445, 1.84060757675], [7.128624753158761, 4.968139445324451, 1.84060757675], [-0.7382225926151221, 8.657639852944286, 1.84060757675], [3.7131148913261165, 3.6895004076198346, 1.84060757675]],
                "lattice_vectors": [[11.5799622371, 0.0, 0.0], [-5.789981118549997, 10.02854147219308, 0.0], [0.0, 0.0, 3.6812151535]],
                "normalized_wyckoff_matid": {"j": {"X_0": 1, "X_1": 1, "X_2": 1}, "k": {"X_0": 1, "X_1": 1, "X_2": 1}}
            }
        ],
        176: [
            {
                "Notes": "UCl<sub>3</sub> Structure",
                "Pearsons Symbol": "hP8",
                "Prototype": "Cl3U",
                "Space Group Number": 176,
                "Space Group Symbol": "$P6_{3}/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_hP8_176_h_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hP8_176_h_c.html",
                "atom_labels": ["U", "U", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[-3.72146676948448e-05, 4.297201168316026, 1.080240354125], [3.7214295549323047, 2.1485683553103954, 3.240721062375], [2.4822183353232004, 0.534998870460993, 1.080240354125], [0.7777865548464006, 2.4171635713599082, 3.240721062375], [5.738501758723201, 1.882164700898915, 1.080240354125], [1.2392484342768013, 5.910770653165429, 3.240721062375], [2.9436802147536008, 4.028605952266513, 1.080240354125], [-2.0170349891231987, 4.563604822727506, 3.240721062375]],
                "lattice_vectors": [[7.4429335392, 0.0, 0.0], [-3.7214667695999983, 6.445769523626422, 0.0], [0.0, 0.0, 4.3209614165]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "h": {"X_0": 3}}
            },
            {
                "Notes": "Fe<sub>3</sub>Te<sub>3</sub>Tl Structure",
                "Pearsons Symbol": "hP14",
                "Prototype": "Fe3Te3Tl",
                "Space Group Number": 176,
                "Space Group Symbol": "$P6_{3}/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B3C_hP14_176_h_h_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B3C_hP14_176_h_h_c.html",
                "atom_labels": ["Tl", "Tl", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Te", "Te", "Te", "Te", "Te", "Te"],
                "atom_positions": [[-4.675016355194103e-05, 5.398270893673964, 1.0550036909], [4.674969605186448, 2.699094960007714, 3.1650110727], [0.6007396016624752, 1.3773619317112535, 1.0550036909], [8.457572088463687, 1.2089367219546745, 3.1650110727], [3.1818161314512117, 7.928940643925099, 1.0550036909], [4.074276753687527, 6.720003921970425, 3.1650110727], [-3.782555733113684, 6.888429131727004, 1.0550036909], [1.49320022389879, 0.16842520975657901, 3.1650110727], [3.12197592210273, 0.3740983024400935, 1.0550036909], [1.2370093276256107, 2.890759609764359, 3.1650110727], [7.46506611622288, 2.516661307324265, 1.0550036909], [1.5530404332472725, 7.723267551241585, 3.1650110727], [3.438007027724392, 5.206606243917319, 1.0550036909], [-2.790049760872879, 5.5807045463574125, 3.1650110727]],
                "lattice_vectors": [[9.3500327107, 0.0, 0.0], [-4.675016355349999, 8.097365853681678, 0.0], [0.0, 0.0, 4.2200147636]],
                "normalized_wyckoff_matid": {"c": {"X_2": 1}, "h": {"X_0": 3, "X_1": 3}}
            },
            {
                "Notes": "Er<sub>3</sub>Ru<sub>2</sub> Structure",
                "Pearsons Symbol": "hP10",
                "Prototype": "Er3Ru2",
                "Space Group Number": 176,
                "Space Group Symbol": "$P6_{3}/m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B2_hP10_176_h_bc",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B2_hP10_176_h_bc.html",
                "atom_labels": ["Ru", "Ru", "Ru", "Ru", "Er", "Er", "Er", "Er", "Er", "Er"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 1.9685109907], [-3.9350219700774664e-05, 4.543794706384062, 0.98425549535], [3.934982619980299, 2.2718632749021244, 2.95276648605], [2.66755139359858, 0.623632705287686, 0.98425549535], [0.7936939313893411, 2.6219836254007953, 2.95276648605], [5.996186478190761, 1.9983509201131098, 0.98425549535], [1.2674705766014212, 6.1920252759985, 2.95276648605], [3.1413280388106615, 4.193674355885389, 0.98425549535], [-2.061164507990759, 4.817307061173076, 2.95276648605]],
                "lattice_vectors": [[7.8700439404, 0.0, 0.0], [-3.9350219701999984, 6.8156579812861855, 0.0], [0.0, 0.0, 3.9370219814]],
                "normalized_wyckoff_matid": {"b": {"X_1": 1}, "c": {"X_1": 1}, "h": {"X_0": 3}}
            }
        ],
        177: [
            {
                "Notes": "SiO<sub>2</sub> Structure",
                "Pearsons Symbol": "hP36",
                "Prototype": "O2Si",
                "Space Group Number": 177,
                "Space Group Symbol": "$P622$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_hP36_177_j2lm_n",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_hP36_177_j2lm_n.html",
                "atom_labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[7.907233925000001, 0.0, 0.0], [3.953616962500002, 6.847865452716137, 0.0], [-3.9536169624999986, 6.847865452716137, 0.0], [4.876266074999999, 0.0, 0.0], [2.4381330375000005, 4.222970296562234, 0.0], [-2.4381330374999988, 4.222970296562234, 0.0], [1.1330016050000018, 6.7264183845465535, 0.0], [7.524751605000001, 4.344417364731818, 0.0], [2.5118553281799904e-15, 8.688834729463636, 0.0], [5.2587483950000005, 4.344417364731818, 0.0], [-1.1330016049999982, 6.7264183845465535, 0.0], [6.39175, 2.3820010198147346, 0.0], [8.805977892500001, 2.2964234594728126, 0.0], [2.414227892500002, 8.774412289805559, 0.0], [6.391750000000002, 6.477988830332746, 0.0], [-2.414227892499998, 8.774412289805559, 0.0], [3.977522107500001, 2.2964234594728126, 0.0], [1.2038518804047271e-15, 4.592846918945625, 0.0], [2.1306898625000015, 6.150402800511599, 1.86041], [8.5224398625, 4.920432948766773, 1.86041], [2.3040749752567536e-15, 9.840865897533545, 1.86041], [4.261060137500001, 4.920432948766773, 1.86041], [-2.130689862499999, 6.150402800511599, 1.86041], [6.39175, 1.2299698517448268, 1.86041], [1.1112696550000025, 9.62631310071253, 0.6123725556], [5.002503137500002, 5.775544302041033, 0.6123725556], [-2.5005165174999977, 7.220066950606876, 0.6123725556], [5.280480345, 1.4445226485658424, 0.6123725556], [1.389246862500001, 5.2952914472373385, 0.6123725556], [8.892266517500001, 3.8507687986714956, 0.6123725556], [7.503019655000001, 1.4445226485658424, 3.1084474444], [2.5005165175000017, 7.220066950606876, 3.1084474444], [7.780996862500001, 5.775544302041033, 3.1084474444], [-1.1112696549999976, 9.62631310071253, 3.1084474444], [3.891233482500001, 3.8507687986714956, 3.1084474444], [-1.3892468624999983, 5.2952914472373385, 3.1084474444]],
                "lattice_vectors": [[12.7835, 0.0, 0.0], [-6.391749999999997, 11.070835749278372, 0.0], [0.0, 0.0, 3.72082]],
                "normalized_wyckoff_matid": {"j": {"X_0": 1}, "l": {"X_0": 2}, "m": {"X_0": 1}, "n": {"X_1": 2}}
            }
        ],
        178: [
            {
                "Notes": "Sc&ndash;V (High&ndash;pressure) Structure",
                "Pearsons Symbol": "hP6",
                "Prototype": "Sc",
                "Space Group Number": 178,
                "Space Group Symbol": "$P6_{1}22$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_hP6_178_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hP6_178_a.html",
                "atom_labels": ["Sc", "Sc", "Sc", "Sc", "Sc", "Sc"],
                "atom_positions": [[1.085655, 0.0, 0.0], [0.5428275000000002, 0.940204809745595, 1.7409999999999999], [-0.5428274999999998, 0.940204809745595, 3.4819999999999998], [1.2693449999999997, 0.0, 5.223], [0.6346725000000001, 1.0992850161667582, 6.9639999999999995], [-0.6346724999999996, 1.0992850161667582, 8.705]],
                "lattice_vectors": [[2.355, 0.0, 0.0], [-1.1774999999999995, 2.0394898259123533, 0.0], [0.0, 0.0, 10.446]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}}
            },
            {
                "Notes": "AuF<sub>3</sub> Structure",
                "Pearsons Symbol": "hP24",
                "Prototype": "AuF3",
                "Space Group Number": 178,
                "Space Group Symbol": "$P6_{1}22$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_hP24_178_b_ac",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_hP24_178_b_ac.html",
                "atom_labels": ["F", "F", "F", "F", "F", "F", "Au", "Au", "Au", "Au", "Au", "Au", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F"],
                "atom_positions": [[4.3050654638729995, 0.0, 0.0], [2.1525327319365006, 3.728296056669057, 2.7099915420999996], [-2.152532731936499, 3.728296056669057, 5.419983084199999], [0.8439184661270003, 0.0, 8.1299746263], [0.42195923306350036, 0.7308548303887795, 10.839966168399998], [-0.4219592330634999, 0.7308548303887795, 13.5499577105], [2.574491965000001, 2.3196502914474864, 4.06498731315], [-0.7216300977894989, 3.3894005892526615, 6.774978855249999], [1.8528618672105004, 1.069750297805175, 9.484970397349997], [6.69813039316125e-16, 2.13950059561035, 12.19496193945], [3.2961220627895007, 1.069750297805175, 14.904953481549997], [0.7216300977895009, 3.3894005892526615, 1.3549957710500022], [1.9506925618805009, 1.3818908598992234, 16.173771521561218], [-0.22140630898999922, 2.3802947435114734, 2.6238138110612197], [2.9768850591294997, 0.9984038836122497, 5.333805353161218], [0.6237994031195007, 3.0772600271586126, 8.043796895261218], [2.7958982739900007, 2.078856143546363, 10.75378843736122], [-0.402393094129499, 3.460747003445587, 13.46377997946122], [-0.6237994031194987, 3.0772600271586126, 0.08617773103877999], [2.1720988708705007, 0.9984038836122497, 2.7961692731387795], [0.2214063089900006, 2.3802947435114734, 5.50616081523878], [3.1982913681195004, 1.3818908598992234, 8.216152357338778], [0.40239309412950053, 3.460747003445587, 10.926143899438777], [2.35308565601, 2.078856143546363, 13.636135441538778]],
                "lattice_vectors": [[5.14898393, 0.0, 0.0], [-2.5744919649999987, 4.459150887057836, 0.0], [0.0, 0.0, 16.2599492526]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}, "c": {"X_0": 2}}
            }
        ],
        179: [
            {
                "Notes": "AuF<sub>3</sub> Structure",
                "Pearsons Symbol": "hP24",
                "Prototype": "AuF3",
                "Space Group Number": 179,
                "Space Group Symbol": "$P6_{5}22$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_hP24_179_b_ac",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_hP24_179_b_ac.html",
                "atom_labels": ["F", "F", "F", "F", "F", "F", "Au", "Au", "Au", "Au", "Au", "Au", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F"],
                "atom_positions": [[4.3050654638729995, 0.0, 0.0], [2.1525327319365006, 3.728296056669057, 13.5499577105], [-2.152532731936499, 3.728296056669057, 10.839966168399998], [0.8439184661270003, 0.0, 8.1299746263], [0.42195923306350036, 0.7308548303887795, 5.419983084199999], [-0.4219592330634999, 0.7308548303887795, 2.7099915420999996], [2.574491965000001, 2.3196502914474864, 12.19496193945], [-0.7216300977894989, 3.3894005892526615, 9.484970397350002], [1.8528618672105004, 1.069750297805175, 6.774978855249997], [6.69813039316125e-16, 2.13950059561035, 4.06498731315], [3.2961220627895007, 1.069750297805175, 1.3549957710499987], [0.7216300977895009, 3.3894005892526615, 14.904953481549997], [1.9506925618805009, 1.3818908598992234, 0.08617773103877999], [-0.22140630898999922, 2.3802947435114734, 13.636135441538778], [2.9768850591294997, 0.9984038836122497, 10.926143899438777], [0.6237994031195007, 3.0772600271586126, 8.216152357338778], [2.7958982739900007, 2.078856143546363, 5.50616081523878], [-0.402393094129499, 3.460747003445587, 2.7961692731387795], [-0.6237994031194987, 3.0772600271586126, 16.173771521561218], [2.1720988708705007, 0.9984038836122497, 13.46377997946122], [0.2214063089900006, 2.3802947435114734, 10.75378843736122], [3.1982913681195004, 1.3818908598992234, 8.043796895261218], [0.40239309412950053, 3.460747003445587, 5.333805353161218], [2.35308565601, 2.078856143546363, 2.6238138110612197]],
                "lattice_vectors": [[5.14898393, 0.0, 0.0], [-2.5744919649999987, 4.459150887057836, 0.0], [0.0, 0.0, 16.2599492526]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}, "c": {"X_0": 2}}
            }
        ],
        180: [
            {
                "Notes": "$\\beta$&ndash;Quartz (SiO<sub>2</sub>, C8)",
                "Pearsons Symbol": "hP9",
                "Prototype": "O2Si",
                "Space Group Number": 180,
                "Space Group Symbol": "$P6_{2}22$",
                "Strukturbericht Designation": "$C8$",
                "aflow_prototype_id": "A2B_hP9_180_j_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_hP9_180_j_c.html",
                "atom_labels": ["Si", "Si", "Si", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[2.49885, 0.0, 0.0], [1.2494250000000005, 2.1640675802467446, 1.8200333333333332], [-1.2494249999999996, 2.1640675802467446, 3.6400666666666663], [3.4682284599796275e-16, 1.793579210508502, 2.73005], [3.44441484, 0.896789605254251, 4.550083333333332], [0.945564840000001, 3.431345555239238, 0.9100166666666658], [2.49885, 2.5345559499849872, 2.73005], [-0.9455648399999992, 3.431345555239238, 4.550083333333332], [1.5532851600000002, 0.896789605254251, 0.9100166666666658]],
                "lattice_vectors": [[4.9977, 0.0, 0.0], [-2.498849999999999, 4.328135160493489, 0.0], [0.0, 0.0, 5.4601]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "j": {"X_0": 2}}
            },
            {
                "Notes": "Mg<sub>2</sub>Ni (C<sub>a</sub>) Structure",
                "Pearsons Symbol": "hP18",
                "Prototype": "Mg2Ni",
                "Space Group Number": 180,
                "Space Group Symbol": "$P6_{2}22$",
                "Strukturbericht Designation": "$C_{a}$",
                "aflow_prototype_id": "A2B_hP18_180_fi_bd",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_hP18_180_fi_bd.html",
                "atom_labels": ["Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg"],
                "atom_positions": [[0.0, 0.0, 6.605], [0.0, 0.0, 11.008333333333333], [0.0, 0.0, 2.201666666666665], [2.599, 0.0, 6.605], [1.2995000000000008, 2.2508000244357564, 11.008333333333333], [-1.2994999999999994, 2.2508000244357564, 2.201666666666665], [2.599, 0.0, 2.15323], [1.2995000000000008, 2.2508000244357564, 6.556563333333333], [-1.2994999999999994, 2.2508000244357564, 10.959896666666667], [2.599, 0.0, 11.05677], [1.2995000000000008, 2.2508000244357564, 2.250103333333333], [-1.2994999999999994, 2.2508000244357564, 6.653436666666666], [3.5235321327320434e-16, 1.0272651311524792, 0.0], [4.308362300000001, 0.5136325655762396, 4.403333333333333], [1.7093623000000018, 3.9879674832952734, 8.806666666666667], [2.5990000000000015, 3.474334917719034, 0.0], [-1.709362299999999, 3.9879674832952734, 4.403333333333333], [0.8896377000000003, 0.5136325655762396, 8.806666666666667]],
                "lattice_vectors": [[5.198, 0.0, 0.0], [-2.598999999999999, 4.501600048871513, 0.0], [0.0, 0.0, 13.21]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_1": 1}, "f": {"X_0": 2}, "j": {"X_0": 2}}
            },
            {
                "Notes": "CrSi<sub>2</sub> (C40) Structure",
                "Pearsons Symbol": "hP9",
                "Prototype": "CrSi2",
                "Space Group Number": 180,
                "Space Group Symbol": "$P6_{2}22$",
                "Strukturbericht Designation": "$C40$",
                "aflow_prototype_id": "AB2_hP9_180_d_j",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_hP9_180_d_j.html",
                "atom_labels": ["Cr", "Cr", "Cr", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[2.21379, 0.0, 3.184025], [1.1068950000000004, 1.9171983786439526, 5.306708333333333], [-1.1068949999999995, 1.9171983786439526, 1.0613416666666657], [3.052060185027017e-16, 1.2698755180786083, 3.184025], [3.3278355417, 0.6349377590393042, 5.306708333333333], [1.1140455417000004, 3.199458998248601, 1.0613416666666657], [2.2137900000000004, 2.5645212392092964, 3.184025], [-1.1140455416999993, 3.199458998248601, 5.306708333333333], [1.0997444583, 0.6349377590393042, 1.0613416666666657]],
                "lattice_vectors": [[4.42758, 0.0, 0.0], [-2.213789999999999, 3.834396757287905, 0.0], [0.0, 0.0, 6.36805]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "i": {"X_0": 2}}
            }
        ],
        181: [
            {
                "Notes": "$\\beta$&ndash;SiO<sub>2</sub> Structure",
                "Pearsons Symbol": "hP9",
                "Prototype": "O2Si",
                "Space Group Number": 181,
                "Space Group Symbol": "$P6_{4}22$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_hP9_181_j_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_hP9_181_j_c.html",
                "atom_labels": ["Si", "Si", "Si", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[2.49885, 0.0, 0.0], [1.2494250000000005, 2.1640675802467446, 3.6400666666666663], [-1.2494249999999996, 2.1640675802467446, 1.8200333333333332], [3.4682284599796275e-16, 1.793579210508502, 2.73005], [3.44441484, 0.896789605254251, 0.9100166666666658], [0.945564840000001, 3.431345555239238, 4.550083333333332], [2.49885, 2.5345559499849872, 2.73005], [-0.9455648399999992, 3.431345555239238, 0.9100166666666658], [1.5532851600000002, 0.896789605254251, 4.550083333333332]],
                "lattice_vectors": [[4.9977, 0.0, 0.0], [-2.498849999999999, 4.328135160493489, 0.0], [0.0, 0.0, 5.4601]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "j": {"X_0": 2}}
            }
        ],
        182: [
            {
                "Notes": "Bainite (Fe<sub>3</sub>C) Structure",
                "Pearsons Symbol": "hP8",
                "Prototype": "CFe3",
                "Space Group Number": 182,
                "Space Group Symbol": "$P6_{3}22$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_hP8_182_c_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_hP8_182_c_g.html",
                "atom_labels": ["C", "C", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe"],
                "atom_positions": [[-2.4253499999307385e-05, 2.8005669535228717, 1.05135], [2.4253257465000004, 1.4002624726143051, 3.15405], [1.57599243, 0.0, 0.0], [0.7879962150000004, 1.3648494805519689, 2.1027], [-0.7879962149999997, 1.3648494805519689, 0.0], [3.27470757, 0.0, 2.1027], [1.6373537850000004, 2.8359799455852084, 0.0], [-1.6373537849999995, 2.8359799455852084, 2.1027]],
                "lattice_vectors": [[4.8507, 0.0, 0.0], [-2.425349999999999, 4.200829426137177, 0.0], [0.0, 0.0, 4.2054]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "g": {"X_0": 3}}
            }
        ],
        183: [
            {
                "Notes": "AuCN Structure",
                "Pearsons Symbol": "hP3",
                "Prototype": "AuCN",
                "Space Group Number": 183,
                "Space Group Symbol": "$P6mm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_hP3_183_a_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_hP3_183_a_a_a.html",
                "atom_labels": ["Au", "C", "N"],
                "atom_positions": [[0.0, 0.0, 3.0835407493568], [0.0, 0.0, 0.0], [0.0, 0.0, 1.1461845548596001]],
                "lattice_vectors": [[3.3908401495, 0.0, 0.0], [-1.6954200747499992, 2.936553709639224, 0.0], [0.0, 0.0, 5.0716130746]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1, "X_2": 1}}
            }
        ],
        184: [
            {
                "Notes": "Al[PO<sub>4</sub>] (Framework type AFI) Structure",
                "Pearsons Symbol": "hP72",
                "Prototype": "Al[O4]P",
                "Space Group Number": 184,
                "Space Group Symbol": "$P6cc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB4C_hP72_184_d_4d_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4C_hP72_184_d_4d_d.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P"],
                "atom_positions": [[5.435780452360638, 1.4319008291027382, 0.0], [1.4778277324773497, 5.4234743756905495, 0.0], [9.759932107716711, 3.991573546587812, 0.0], [1.4231619614393642, 10.448135917787978, 0.0], [5.381114681322654, 6.4565623712001665, 0.0], [-2.9009896939167086, 7.888463200302905, 0.0], [8.282104375239362, 1.4319008291027382, 4.2262645172], [2.9009896939167117, 7.888463200302905, 4.2262645172], [8.336770146277349, 6.4565623712001665, 4.2262645172], [-1.4231619614393594, 10.448135917787978, 4.2262645172], [3.9579527198832904, 3.991573546587812, 4.2262645172], [-1.4778277324773468, 5.4234743756905495, 4.2262645172], [4.3423964421767804, 2.4579796029316894, 0.6001295614423999], [0.042525442965560885, 4.989615433694101, 0.6001295614423999], [9.418013828388782, 2.5316358307624114, 0.6001295614423999], [2.516545971623223, 9.422057143959028, 0.6001295614423999], [6.816416970834442, 6.890421313196617, 0.6001295614423999], [-2.5590714145887787, 9.348400916128305, 0.6001295614423999], [9.375488385423223, 2.4579796029316894, 4.826394078642399], [2.5590714145887827, 9.348400916128305, 4.826394078642399], [6.901467856765562, 6.890421313196617, 4.826394078642399], [-2.5165459716232186, 9.422057143959028, 4.826394078642399], [4.299870999211221, 2.5316358307624114, 4.826394078642399], [-0.042525442965558984, 4.989615433694101, 4.826394078642399], [-1.420486973897979, 5.368588605919915, 2.52054415805808], [8.35830722545668, 1.4541164978194236, 2.52054415805808], [2.9198517855546626, 7.965564638790226, 2.52054415805808], [8.279429387697983, 6.511448140970803, 2.52054415805808], [-1.499364811656678, 10.425920249071293, 2.52054415805808], [3.9390906282453413, 3.914472108100491, 2.52054415805808], [1.420486973897981, 5.368588605919915, 6.746808675258079], [9.778794199354662, 3.914472108100491, 6.746808675258079], [1.499364811656683, 10.425920249071293, 6.746808675258079], [5.438455439902022, 6.511448140970803, 6.746808675258079], [-2.919851785554658, 7.965564638790226, 6.746808675258079], [5.359577602143321, 1.4541164978194236, 6.746808675258079], [4.9651884133498205, 0.022572069819092364, 0.5485691343325599], [2.4630462207955803, 4.311265335446641, 0.5485691343325599], [11.215742635045762, 4.288693265627549, 0.5485691343325599], [1.8937540004501827, 11.857464677071624, 0.5485691343325599], [4.395896193004422, 7.568771411444076, 0.5485691343325599], [-4.356800221245758, 7.591343481263168, 0.5485691343325599], [8.75269641425018, 0.022572069819092364, 4.77483365153256], [4.356800221245762, 7.591343481263168, 4.77483365153256], [9.321988634595582, 7.568771411444076, 4.77483365153256], [-1.8937540004501778, 11.857464677071624, 4.77483365153256], [2.5021421925542415, 4.288693265627549, 4.77483365153256], [-2.463046220795579, 4.311265335446641, 4.77483365153256], [-1.8251645763121787, 6.815577081691204, 0.50884224787088], [6.902839645248322, 1.8271496516717922, 0.50884224787088], [1.8690618077605012, 6.891609316871306, 0.50884224787088], [8.684106990112182, 5.064459665199513, 0.50884224787088], [-0.04389723144831805, 10.052887095218926, 0.50884224787088], [4.989880606039502, 4.988427430019412, 0.50884224787088], [1.8251645763121818, 6.815577081691204, 4.73510676507088], [8.728004221560502, 4.988427430019412, 4.73510676507088], [0.043897231448321784, 10.052887095218926, 4.73510676507088], [5.033777837487822, 5.064459665199513, 4.73510676507088], [-1.869061807760499, 6.891609316871306, 4.73510676507088], [6.815045182351681, 1.8271496516717922, 4.73510676507088], [-1.416645966146251, 5.37571662796805, 1.0773593507246237], [8.354054681160124, 1.4610069191326205, 1.0773593507246237], [2.9117582335063776, 7.965327038055287, 1.0773593507246237], [8.275588379946255, 6.504320118922667, 1.0773593507246237], [-1.4951122673601214, 10.419029827758097, 1.0773593507246237], [3.9471841802936254, 3.9147097088354292, 1.0773593507246237], [1.4166459661462536, 5.37571662796805, 5.303623867924624], [9.770700647306377, 3.9147097088354292, 5.303623867924624], [1.4951122673601258, 10.419029827758097, 5.303623867924624], [5.442296447653749, 6.504320118922667, 5.303623867924624], [-2.911758233506374, 7.965327038055287, 5.303623867924624], [5.363830146439877, 1.4610069191326205, 5.303623867924624]],
                "lattice_vectors": [[13.7178848276, 0.0, 0.0], [-6.858942413799998, 11.880036746890717, 0.0], [0.0, 0.0, 8.4525290344]],
                "normalized_wyckoff_matid": {"d": {"X_0": 4, "X_1": 1, "X_2": 1}}
            }
        ],
        185: [
            {
                "Notes": "KNiCl<sub>3</sub> (Room&ndash;temperature) Structure",
                "Pearsons Symbol": "hP30",
                "Prototype": "Cl3KNi",
                "Space Group Number": 185,
                "Space Group Symbol": "$P6_{3}cm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3BC_hP30_185_cd_c_ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3BC_hP30_185_cd_c_ab.html",
                "atom_labels": ["Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "K", "K", "K", "K", "K", "K", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 2.9630228386], [-5.897545457298975e-05, 6.809932964385934, 2.2341192203044002], [5.897486482045426, 3.4049154079511057, 5.1971420589044], [5.897545457657699e-05, 6.809932964385934, 5.1971420589044], [5.897545457500001, 3.4050175564348284, 2.2341192203044002], [1.8848555282169999, 0.0, 1.41988054425712], [0.9424277641085004, 1.632332769899459, 4.38290338285712], [-0.9424277641084995, 1.632332769899459, 1.41988054425712], [9.910235386783, 0.0, 4.38290338285712], [4.955117693391503, 8.582515602437581, 1.41988054425712], [-4.9551176933914975, 8.582515602437581, 4.38290338285712], [7.8401969312004995, 0.0, 1.01098339253032], [3.9200984656002515, 6.7898097130924295, 3.97400623113032], [-3.920098465600248, 6.7898097130924295, 1.01098339253032], [3.9548939837995003, 0.0, 3.97400623113032], [1.977446991899751, 3.42503865924461, 1.01098339253032], [-1.9774469918997493, 3.42503865924461, 3.97400623113032], [-0.938889236833999, 5.1646273370536075, 0.68031004374256], [6.8529478216149995, 1.769211738088775, 3.6433328823425604], [1.8942916009490012, 6.819432773372207, 0.68031004374256], [6.8364346943340015, 5.050221035283432, 3.6433328823425604], [-0.9554023641149971, 8.445636634248263, 0.68031004374256], [4.003253856551002, 3.3954155989648322, 3.6433328823425604], [0.9388892368340015, 5.1646273370536075, 3.6433328823425604], [7.791837058449001, 3.3954155989648322, 0.68031004374256], [0.9554023641150016, 8.445636634248263, 3.6433328823425604], [4.9586562206660005, 5.050221035283432, 0.68031004374256], [-1.894291600948998, 6.819432773372207, 3.6433328823425604], [4.942143093385001, 1.769211738088775, 0.68031004374256]],
                "lattice_vectors": [[11.795090915, 0.0, 0.0], [-5.897545457499997, 10.21484837233704, 0.0], [0.0, 0.0, 5.9260456772]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_1": 2}, "c": {"X_0": 3, "X_2": 3}, "d": {"X_0": 6}}
            },
            {
                "Notes": "$\\beta$&ndash;RuCl<sub>3</sub> Structure",
                "Pearsons Symbol": "hP8",
                "Prototype": "Cl3Ru",
                "Space Group Number": 185,
                "Space Group Symbol": "$P6_{3}cm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_hP8_185_c_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hP8_185_c_a.html",
                "atom_labels": ["Ru", "Ru", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 2.8288689617], [1.8665135397285, 0.0, 1.386145791233], [0.9332567698642504, 1.616448141912496, 4.215014752933], [-0.9332567698642495, 1.616448141912496, 1.386145791233], [4.253202983971501, 0.0, 4.215014752933], [2.126601491985751, 3.683381831571098, 1.386145791233], [-2.1266014919857494, 3.683381831571098, 4.215014752933]],
                "lattice_vectors": [[6.1197165237, 0.0, 0.0], [-3.0598582618499988, 5.299829973483594, 0.0], [0.0, 0.0, 5.6577379234]]
            },
            {
                "Notes": "Cu<sub>3</sub>P Structure",
                "Pearsons Symbol": "hP24",
                "Prototype": "Cu3P",
                "Space Group Number": 185,
                "Space Group Symbol": "$P6_{3}cm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_hP24_185_ab2c_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hP24_185_ab2c_c.html",
                "atom_labels": ["Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "P", "P", "P", "P", "P", "P"],
                "atom_positions": [[0.0, 0.0, 2.2950459], [0.0, 0.0, 5.866545899999999], [-3.479649999894098e-05, 4.017973818140005, 1.4271714], [3.4796152035000008, 2.00895677441704, 4.9986714], [3.479650000070487e-05, 4.017973818140005, 4.9986714], [3.479650000000001, 2.009017043722965, 1.4271714], [1.95277958, 0.0, 0.5464395], [0.9763897900000004, 1.6911567242715069, 4.1179395], [-0.9763897899999997, 1.6911567242715069, 0.5464395], [5.00652042, 0.0, 4.1179395], [2.503260210000001, 4.335773868285538, 0.5464395], [-2.503260209999999, 4.335773868285538, 4.1179395], [2.6173927299999997, 0.0, 3.0329178], [1.3086963650000003, 2.2667285958607044, 6.604417799999999], [-1.3086963649999994, 2.2667285958607044, 3.0329178], [4.34190727, 0.0, 6.604417799999999], [2.170953635000001, 3.76020199669634, 3.0329178], [-2.170953634999999, 3.76020199669634, 6.604417799999999], [2.31187946, 0.0, 5.35725], [1.1559397300000005, 2.00214634284745, 1.78575], [-1.1559397299999996, 2.00214634284745, 5.35725], [4.64742054, 0.0, 1.78575], [2.3237102700000007, 4.024784249709594, 5.35725], [-2.323710269999999, 4.024784249709594, 1.78575]],
                "lattice_vectors": [[6.9593, 0.0, 0.0], [-3.4796499999999986, 6.026930592557044, 0.0], [0.0, 0.0, 7.143]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 2}, "c": {"X_0": 6, "X_1": 3}}
            },
            {
                "Notes": "Na<sub>3</sub>As Structure",
                "Pearsons Symbol": "hP24",
                "Prototype": "AsNa3",
                "Space Group Number": 185,
                "Space Group Symbol": "$P6_{3}cm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_hP24_185_c_ab2c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_hP24_185_c_ab2c.html",
                "atom_labels": ["Na", "Na", "Na", "Na", "Na", "Na", "As", "As", "As", "As", "As", "As", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na"],
                "atom_positions": [[0.0, 0.0, 2.4153316000000005], [0.0, 0.0, 6.9148316], [-4.3918999998677366e-05, 5.071354651154307, 2.0796689], [4.391856081, 2.535639290607445, 6.5791689], [4.3919000001107334e-05, 5.071354651154307, 6.5791689], [4.391900000000001, 2.5357153605468623, 2.0796689], [2.9170999799999997, 0.0, 2.24975], [1.4585499900000003, 2.526282688059078, 6.74925], [-1.4585499899999994, 2.526282688059078, 2.24975], [5.866700019999999, 0.0, 6.74925], [2.9333500100000003, 5.080711253702674, 2.24975], [-2.9333500099999985, 5.080711253702674, 6.74925], [2.76953214, 0.0, 5.276113700000001], [1.3847660700000004, 2.398485189837481, 0.7766137000000004], [-1.3847660699999995, 2.398485189837481, 5.276113700000001], [6.0142678599999995, 0.0, 0.7766137000000004], [3.007133930000001, 5.208508751924271, 5.276113700000001], [-3.0071339299999984, 5.208508751924271, 0.7766137000000004], [3.0901408399999997, 0.0, 8.3069769], [1.5450704200000005, 2.6761404687117842, 3.8074769000000006], [-1.5450704199999992, 2.6761404687117842, 8.3069769], [5.693659159999999, 0.0, 3.8074769000000006], [2.8468295800000005, 4.930853473049968, 8.3069769], [-2.8468295799999987, 4.930853473049968, 3.8074769000000006]],
                "lattice_vectors": [[8.7838, 0.0, 0.0], [-4.391899999999998, 7.606993941761752, 0.0], [0.0, 0.0, 8.999]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 2}, "c": {"X_0": 6, "X_1": 3}}
            }
        ],
        186: [
            {
                "Notes": "Al<sub>5</sub>C<sub>3</sub>N (E9<sub>4</sub>) Structure",
                "Pearsons Symbol": "hP18",
                "Prototype": "Al5C3N",
                "Space Group Number": 186,
                "Space Group Symbol": "$P6_{3}mc$",
                "Strukturbericht Designation": "$E9_{4}$",
                "aflow_prototype_id": "A5B3C_hP18_186_2a3b_2ab_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B3C_hP18_186_2a3b_2ab_b.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "C", "C", "C", "C", "Al", "Al", "Al", "Al", "Al", "Al", "C", "C", "N", "N"],
                "atom_positions": [[0.0, 0.0, 3.3448999999999995], [0.0, 0.0, 14.1349], [0.0, 0.0, 7.445099999999999], [0.0, 0.0, 18.2351], [0.0, 0.0, 0.0], [0.0, 0.0, 10.79], [0.0, 0.0, 5.351839999999999], [0.0, 0.0, 16.14184], [-1.64049999995291e-05, 1.8942957046423283, 0.9710999999999999], [1.6404835950000003, 0.9471336451744151, 11.7611], [-1.64049999995291e-05, 1.8942957046423283, 5.6323799999999995], [1.6404835950000003, 0.9471336451744151, 16.42238], [-1.64049999995291e-05, 1.8942957046423283, 9.8189], [1.6404835950000003, 0.9471336451744151, 20.6089], [-1.64049999995291e-05, 1.8942957046423283, 7.919859999999999], [1.6404835950000003, 0.9471336451744151, 18.70986], [-1.64049999995291e-05, 1.8942957046423283, 2.95646], [1.6404835950000003, 0.9471336451744151, 13.746459999999999]],
                "lattice_vectors": [[3.281, 0.0, 0.0], [-1.6404999999999994, 2.8414293498167433, 0.0], [0.0, 0.0, 21.58]],
                "normalized_wyckoff_matid": {"a": {"X_0": 2, "X_1": 2}, "b": {"X_0": 3, "X_1": 1, "X_2": 1}}
            },
            {
                "Notes": "Original BN (B12) Structure",
                "Pearsons Symbol": "hP4",
                "Prototype": "BN",
                "Space Group Number": 186,
                "Space Group Symbol": "$P6_{3}mc$",
                "Strukturbericht Designation": "$B12$",
                "aflow_prototype_id": "AB_hP4_186_b_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP4_186_b_a.html",
                "atom_labels": ["N", "N", "B", "B"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.35], [-1.2549999999499903e-05, 1.4491564214118389, 0.335], [1.2549874500000002, 0.7245673420871019, 3.6850000000000005]],
                "lattice_vectors": [[2.51, 0.0, 0.0], [-1.2549999999999992, 2.173723763498941, 0.0], [0.0, 0.0, 6.7]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}}
            },
            {
                "Notes": "Moissanite&ndash;6H SiC (B6) Structure",
                "Pearsons Symbol": "hP12",
                "Prototype": "CSi",
                "Space Group Number": 186,
                "Space Group Symbol": "$P6_{3}mc$",
                "Strukturbericht Designation": "$B6$",
                "aflow_prototype_id": "AB_hP12_186_a2b_a2b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP12_186_a2b_a2b.html",
                "atom_labels": ["C", "C", "Si", "Si", "C", "C", "C", "C", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 1.896017904], [0.0, 0.0, 9.455897903999999], [0.0, 0.0, 0.0], [0.0, 0.0, 7.55988], [-1.540644999951741e-05, 1.778992505869357, 4.417237884], [1.5406295935500003, 0.8894829105575964, 11.977117884], [-1.540644999951741e-05, 1.778992505869357, 14.492289959999999], [1.5406295935500003, 0.8894829105575964, 6.93240996], [-1.540644999951741e-05, 1.778992505869357, 2.52121998], [1.5406295935500003, 0.8894829105575964, 10.08109998], [-1.540644999951741e-05, 1.778992505869357, 12.602319959999999], [1.5406295935500003, 0.8894829105575964, 5.0424399599999985]],
                "lattice_vectors": [[3.08129, 0.0, 0.0], [-1.5406449999999994, 2.6684754164269533, 0.0], [0.0, 0.0, 15.11976]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "b": {"X_0": 2, "X_1": 2}}
            },
            {
                "Notes": "Buckled Graphite Structure",
                "Pearsons Symbol": "hP4",
                "Prototype": "C",
                "Space Group Number": 186,
                "Space Group Symbol": "$P6_{3}mc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_hP4_186_ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hP4_186_ab.html",
                "atom_labels": ["C", "C", "C", "C"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.4], [-1.2349999999607395e-05, 1.4260622951742004, 0.48572399999999993], [1.2349876500000003, 0.7130204521733635, 3.8857239999999997]],
                "lattice_vectors": [[2.47, 0.0, 0.0], [-1.2349999999999997, 2.139082747347564, 0.0], [0.0, 0.0, 6.8]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 1}}
            },
            {
                "Notes": "Wurtzite (ZnS, B4) Structure",
                "Pearsons Symbol": "hP4",
                "Prototype": "SZn",
                "Space Group Number": 186,
                "Space Group Symbol": "$P6_{3}mc$",
                "Strukturbericht Designation": "$B4$",
                "aflow_prototype_id": "AB_hP4_186_b_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP4_186_b_b.html",
                "atom_labels": ["S", "S", "Zn", "Zn"],
                "atom_positions": [[-1.9113499999268457e-05, 2.207047909215553, 2.34651036], [1.9113308865000005, 1.1035074018312212, 5.47686036], [-1.9113499999268457e-05, 2.207047909215553, 0.0], [1.9113308865000005, 1.1035074018312212, 3.13035]],
                "lattice_vectors": [[3.8227, 0.0, 0.0], [-1.9113499999999992, 3.310555311046774, 0.0], [0.0, 0.0, 6.2607]],
                "normalized_wyckoff_matid": {"b": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "Moissanite&ndash;4H SiC (B5) Structure",
                "Pearsons Symbol": "hP8",
                "Prototype": "CSi",
                "Space Group Number": 186,
                "Space Group Symbol": "$P6_{3}mc$",
                "Strukturbericht Designation": "$B5$",
                "aflow_prototype_id": "AB_hP8_186_ab_ab",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP8_186_ab_ab.html",
                "atom_labels": ["C", "C", "Si", "Si", "C", "C", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 1.894328832], [0.0, 0.0, 6.936728832], [0.0, 0.0, 0.0], [0.0, 0.0, 5.0424], [-1.5402549999376306e-05, 1.7785421704077227, 4.404133008], [1.5402395974500005, 0.8892577462042783, 9.446533008], [-1.5402549999376306e-05, 1.7785421704077227, 2.5193847359999997], [1.5402395974500005, 0.8892577462042783, 7.561784735999999]],
                "lattice_vectors": [[3.08051, 0.0, 0.0], [-1.5402549999999993, 2.667799916612001, 0.0], [0.0, 0.0, 10.0848]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}, "b": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "Fe<sub>3</sub>Th<sub>7</sub> ($D10_{2}$) Structure",
                "Pearsons Symbol": "hP20",
                "Prototype": "Fe3Th7",
                "Space Group Number": 186,
                "Space Group Symbol": "$P6_{3}mc$",
                "Strukturbericht Designation": "$D10_{2}$",
                "aflow_prototype_id": "A3B7_hP20_186_c_b2c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B7_hP20_186_c_b2c.html",
                "atom_labels": ["Th", "Th", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Th", "Th", "Th", "Th", "Th", "Th", "Th", "Th", "Th", "Th", "Th", "Th"],
                "atom_positions": [[-4.924999999844544e-05, 5.686928586018571, 0.369], [4.924950750000001, 2.8434216412581494, 3.4440000000000004], [7.116625, 1.5781147920461933, 1.9065], [2.1916250000000006, 6.952235435230527, 4.9815000000000005], [4.925000000000001, 5.374120643184333, 1.9065], [-2.191624999999998, 6.952235435230527, 4.9815000000000005], [2.733375000000001, 1.5781147920461938, 1.9065], [1.2345680033831762e-16, 3.1562295840923875, 4.9815000000000005], [-3.0633499999999985, 7.4555260986398535, 1.5375], [1.86165, 1.0748241286368667, 4.612500000000001], [3.5362823780360486e-16, 2.1496482572737334, 1.5375], [7.9883500000000005, 1.0748241286368667, 4.612500000000001], [3.0633500000000016, 7.4555260986398535, 1.5375], [4.925000000000002, 6.380701970002987, 4.612500000000001], [3.1126000000000014, 3.889839703638185, 1.9065], [-1.812399999999999, 4.640510523638536, 4.9815000000000005], [4.925000000000001, 0.7506708200003516, 1.9065], [1.8124, 4.640510523638536, 4.9815000000000005], [6.737399999999999, 3.889839703638184, 1.9065], [2.2039259306438906e-15, 7.779679407276368, 4.9815000000000005]],
                "lattice_vectors": [[9.85, 0.0, 0.0], [-4.924999999999998, 8.53035022727672, 0.0], [0.0, 0.0, 6.15]],
                "normalized_wyckoff_matid": {"b": {"X_0": 1}, "c": {"X_0": 6, "X_1": 3}}
            }
        ],
        187: [
            {
                "Notes": "BaPtSb Structure",
                "Pearsons Symbol": "hP3",
                "Prototype": "BaPtSb",
                "Space Group Number": 187,
                "Space Group Symbol": "$P\\bar{6}m2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_hP3_187_a_d_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_hP3_187_a_d_f.html",
                "atom_labels": ["Ba", "Pt", "Sb"],
                "atom_positions": [[0.0, 0.0, 0.0], [-2.2674999999354827e-05, 2.618296562192307, 2.442], [2.267522675, 1.3091286439701229, 2.442]],
                "lattice_vectors": [[4.535, 0.0, 0.0], [-2.267499999999999, 3.9274252061624297, 0.0], [0.0, 0.0, 4.884]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "d": {"X_1": 1}, "e": {"X_2": 1}}
            },
            {
                "Notes": "Tungsten Carbide (B<sub>h</sub>) Structure",
                "Pearsons Symbol": "hP2",
                "Prototype": "CW",
                "Space Group Number": 187,
                "Space Group Symbol": "$P\\bar{6}m2$",
                "Strukturbericht Designation": "$B_{h}$",
                "aflow_prototype_id": "AB_hP2_187_d_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP2_187_d_a.html",
                "atom_labels": ["W", "C"],
                "atom_positions": [[0.0, 0.0, 0.0], [-1.4532499999532126e-05, 1.6780769477424342, 1.4183]],
                "lattice_vectors": [[2.9065, 0.0, 0.0], [-1.4532499999999993, 2.517102836099471, 0.0], [0.0, 0.0, 2.8366]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "f": {"X_1": 1}}
            },
            {
                "Notes": "Re<sub>3</sub>N Structure",
                "Pearsons Symbol": "hP4",
                "Prototype": "NRe3",
                "Space Group Number": 187,
                "Space Group Symbol": "$P\\bar{6}m2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3_hP4_187_e_fh",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_hP4_187_e_fh.html",
                "atom_labels": ["N", "Re", "Re", "Re"],
                "atom_positions": [[1.4032640325000003, 0.8101586635726902, 0.0], [1.4032640325000003, 0.8101586635726902, 3.556], [-1.4032499999486291e-05, 1.6203416321483375, 1.408176], [4.4984014735405255e-16, 1.6203173271453803, 5.703824]],
                "lattice_vectors": [[2.8065, 0.0, 0.0], [-1.4032499999999994, 2.4305002957210275, 0.0], [0.0, 0.0, 7.112]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_0": 1}, "i": {"X_0": 2}}
            }
        ],
        188: [
            {
                "Notes": "BaSi<sub>4</sub>O<sub>9</sub> ($S3_{2}$) Structure",
                "Pearsons Symbol": "hP28",
                "Prototype": "BaO9Si4",
                "Space Group Number": 188,
                "Space Group Symbol": "$P\\bar{6}c2$",
                "Strukturbericht Designation": "$S3_{2}$",
                "aflow_prototype_id": "AB9C4_hP28_188_e_kl_ak",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB9C4_hP28_188_e_kl_ak.html",
                "atom_labels": ["Si", "Si", "Ba", "Ba", "O", "O", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "Si", "Si", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 4.6732953256], [3.2477139756149884, 1.8750310370764718, 0.0], [3.2476490219850125, 1.8750310370764718, 4.6732953256], [-1.1074593910907993, 2.7172846511569926, 2.3366476628], [1.4481736571299084, 3.3074190708002673, 2.3366476628], [-0.34071426603910654, 5.2255950034888246, 2.3366476628], [-1.4481736571299073, 3.3074190708002673, 7.0099429884], [1.1074593910908008, 2.7172846511569926, 7.0099429884], [0.3407142660391091, 5.2255950034888246, 7.0099429884], [-1.6689835222333191, 4.243387673263754, 2.3366476628], [0.40729173676450847, 2.058073397339479, 2.3366476628], [1.2616917854688137, 4.94883765484285, 2.3366476628], [-0.40729173676450725, 2.058073397339479, 7.0099429884], [1.6689835222333214, 4.243387673263754, 7.0099429884], [-1.261691785468811, 4.94883765484285, 7.0099429884], [1.484807504436372, 0.007143939690658264, 5.63786348080384], [5.7467724121266, 1.2823090487263447, 5.63786348080384], [2.5114645798370296, 4.335696374306039, 5.63786348080384], [0.7485905854734002, 1.2823090487263447, 3.7087271703961604], [5.010555493163628, 0.007143939690658264, 3.7087271703961604], [3.983898417762973, 4.335696374306039, 3.7087271703961604], [2.5114645798370296, 4.335696374306039, 8.38202249599616], [1.484807504436372, 0.007143939690658264, 8.38202249599616], [5.7467724121266, 1.2823090487263447, 8.38202249599616], [5.010555493163628, 0.007143939690658264, 0.9645681552038395], [3.983898417762973, 4.335696374306039, 0.9645681552038395], [0.7485905854734002, 1.2823090487263447, 0.9645681552038395]],
                "lattice_vectors": [[6.4953629976, 0.0, 0.0], [-3.2476814987999987, 5.625149362723042, 0.0], [0.0, 0.0, 9.3465906512]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "e": {"X_2": 1}, "k": {"X_0": 3, "X_1": 3}, "l": {"X_0": 6}}
            },
            {
                "Notes": "LiScI<sub>3</sub> Structure",
                "Pearsons Symbol": "hP10",
                "Prototype": "I3LiSc",
                "Space Group Number": 188,
                "Space Group Symbol": "$P\\bar{6}c2$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3BC_hP10_188_k_c_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3BC_hP10_188_k_c_a.html",
                "atom_labels": ["Sc", "Sc", "Li", "Li", "I", "I", "I", "I", "I", "I"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.3841515607], [-3.643213162780826e-05, 4.20684123473201, 0.0], [3.6432131629890974e-05, 4.20684123473201, 3.3841515607], [-1.1609098743580843, 2.0624987738643665, 1.69207578035], [2.4374917666382463, 4.273603471316023, 1.69207578035], [-1.2765818922801584, 6.284358356712628, 1.69207578035], [-2.4374917666382436, 4.273603471316023, 5.07622734105], [1.1609098743580855, 2.0624987738643665, 5.07622734105], [1.276581892280162, 6.284358356712628, 5.07622734105]],
                "lattice_vectors": [[7.2864263258, 0.0, 0.0], [-3.643213162899998, 6.310230300946509, 0.0], [0.0, 0.0, 6.7683031214]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "e": {"X_2": 1}, "k": {"X_0": 3}}
            }
        ],
        189: [
            {
                "Notes": "Revised Fe<sub>2</sub>P (C22) Crystal Structure",
                "Pearsons Symbol": "hP9",
                "Prototype": "Fe2P",
                "Space Group Number": 189,
                "Space Group Symbol": "$P\\bar{6}2m$",
                "Strukturbericht Designation": "$C22$",
                "aflow_prototype_id": "A2B_hP9_189_fg_bc",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_hP9_189_fg_bc.html",
                "atom_labels": ["P", "P", "P", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe"],
                "atom_positions": [[0.0, 0.0, 1.7185], [-2.9384999998877462e-05, 3.393104497465091, 0.0], [2.938470615000001, 1.6965268005760554, 0.0], [1.504512, 0.0, 0.0], [-0.7522559999999996, 1.3029456122985335, 0.0], [2.1862440000000007, 3.7866856857426128, 0.0], [3.461553, 0.0, 1.7185], [-1.730776499999999, 2.997792834546235, 1.7185], [1.2077235000000004, 2.0918384634949114, 1.7185]],
                "lattice_vectors": [[5.877, 0.0, 0.0], [-2.9384999999999986, 5.089631298041146, 0.0], [0.0, 0.0, 3.437]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_1": 2}, "f": {"X_0": 3}, "g": {"X_0": 3}}
            },
            {
                "Notes": "$\\pi$&ndash;FeMg<sub>3</sub>Al<sub>9</sub>Si<sub>5</sub> Structure",
                "Pearsons Symbol": "hP18",
                "Prototype": "Al9FeMg3Si5",
                "Space Group Number": 189,
                "Space Group Symbol": "$P\\bar{6}2m$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A9BC3D5_hP18_189_fi_a_g_bh",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A9BC3D5_hP18_189_fi_a_g_bh.html",
                "atom_labels": ["Fe", "Si", "Al", "Al", "Al", "Mg", "Mg", "Mg", "Si", "Si", "Si", "Si", "Al", "Al", "Al", "Al", "Al", "Al"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.95], [2.4947999999999997, 0.0, 0.0], [-1.2473999999999994, 2.1605601773614174, 0.0], [2.052600000000001, 3.5552074876158777, 0.0], [2.8379999999999996, 0.0, 3.95], [-1.4189999999999994, 2.4577800959402367, 3.95], [1.8810000000000007, 3.2579875690370583, 3.95], [-3.299999999917627e-05, 3.810530829210413, 2.1014000000000004], [3.299967, 1.9052368357668819, 5.7986], [3.30000000007232e-05, 3.810530829210413, 5.7986], [3.3000000000000003, 1.9052939934435313, 2.1014000000000004], [4.983, 0.0, 1.8644], [-2.491499999999999, 4.3154045870578575, 1.8644], [0.8085000000000003, 1.4003630779194374, 1.8644], [4.983, 0.0, 6.0356000000000005], [-2.491499999999999, 4.3154045870578575, 6.0356000000000005], [0.8085000000000003, 1.4003630779194374, 6.0356000000000005]],
                "lattice_vectors": [[6.6, 0.0, 0.0], [-3.2999999999999985, 5.715767664977295, 0.0], [0.0, 0.0, 7.9]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_3": 1}, "f": {"X_2": 3}, "g": {"X_0": 3}, "h": {"X_1": 4}, "i": {"X_0": 6}}
            },
            {
                "Notes": "$\\pi$&ndash;FeMg<sub>3</sub>Al<sub>8</sub>Si<sub>6</sub> ($E9_{b}$) Structure",
                "Pearsons Symbol": "hP18",
                "Prototype": "Al8FeMg3Si6",
                "Space Group Number": 189,
                "Space Group Symbol": "$P\\bar{6}2m$",
                "Strukturbericht Designation": "$E9_{b}$",
                "aflow_prototype_id": "A8BC3D6_hP18_189_bfh_a_g_i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A8BC3D6_hP18_189_bfh_a_g_i.html",
                "atom_labels": ["Fe", "Al", "Al", "Al", "Al", "Mg", "Mg", "Mg", "Al", "Al", "Al", "Al", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.98], [2.66786, 0.0, 0.0], [-1.3339299999999996, 2.3104345337403527, 0.0], [1.9760700000000009, 3.4226536393126312, 0.0], [2.93928, 0.0, 3.98], [-1.4696399999999994, 2.545491148835525, 3.98], [1.8403600000000009, 3.1875970242174594, 3.98], [-3.309999999891899e-05, 3.822077892329233, 1.8387600000000002], [3.309966900000001, 1.9110102807237512, 6.12124], [3.310000000065317e-05, 3.822077892329233, 6.12124], [3.310000000000001, 1.9110676116054814, 1.8387600000000002], [4.965, 0.0, 1.76712], [-2.482499999999999, 4.299816129789738, 1.76712], [0.8275000000000003, 1.433272043263246, 1.76712], [4.965, 0.0, 6.192880000000001], [-2.482499999999999, 4.299816129789738, 6.192880000000001], [0.8275000000000003, 1.433272043263246, 6.192880000000001]],
                "lattice_vectors": [[6.62, 0.0, 0.0], [-3.3099999999999987, 5.733088173052984, 0.0], [0.0, 0.0, 7.96]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_3": 1}, "f": {"X_2": 3}, "g": {"X_0": 3}, "h": {"X_0": 4}, "i": {"X_1": 6}}
            }
        ],
        190: [
            {
                "Notes": "$\\alpha$&ndash;Sm<sub>3</sub>Ge<sub>5</sub> (High&ndash;temperature) Structure",
                "Pearsons Symbol": "hP16",
                "Prototype": "Ge5Sm3",
                "Space Group Number": 190,
                "Space Group Symbol": "$P\\bar{6}2c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A5B3_hP16_190_bdh_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B3_hP16_190_bdh_g.html",
                "atom_labels": ["Ge", "Ge", "Ge", "Ge", "Sm", "Sm", "Sm", "Sm", "Sm", "Sm", "Ge", "Ge", "Ge", "Ge", "Ge", "Ge"],
                "atom_positions": [[0.0, 0.0, 2.12271842485], [0.0, 0.0, 6.36815527455], [3.4618831239350545, 1.9986791795235963, 2.12271842485], [3.461848505541782e-05, 3.997418320022188, 6.36815527455], [2.29382081971117, 0.0, 0.0], [-1.1469104098555845, 1.9865071015995182, 0.0], [2.314938095594416, 4.009590397946266, 0.0], [2.314938095594416, 4.009590397946266, 4.2454368497], [2.29382081971117, 0.0, 4.2454368497], [-1.1469104098555845, 1.9865071015995182, 4.2454368497], [-1.8783989990571692, 4.006592349196493, 2.12271842485], [0.9312372479660506, 2.366060073320766, 2.12271842485], [0.9471617510911218, 5.619542576574309, 2.12271842485], [1.5834495063928302, 1.989505150349291, 6.36815527455], [4.40901025654112, 0.3765549229714752, 6.36815527455], [4.3930857534160515, 3.630037426225018, 6.36815527455]],
                "lattice_vectors": [[6.9236970109, 0.0, 0.0], [-3.4618485054499986, 5.996097499545784, 0.0], [0.0, 0.0, 8.4908736994]],
                "normalized_wyckoff_matid": {"b": {"X_0": 1}, "c": {"X_0": 1}, "g": {"X_1": 3}, "h": {"X_0": 3}}
            },
            {
                "Notes": "Troilite (FeS) Structure",
                "Pearsons Symbol": "hP24",
                "Prototype": "FeS",
                "Space Group Number": 190,
                "Space Group Symbol": "$P\\bar{6}2c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_hP24_190_i_afh",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP24_190_i_afh.html",
                "atom_labels": ["S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe", "Fe"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 5.87998231155], [-2.9849910202877477e-05, 3.446787972166803, 6.115181604012], [2.9849611704897967, 1.7233681353028643, 5.644783019088], [2.9849910204777392e-05, 3.446787972166803, 11.524765330638], [2.9849910204000003, 1.7234198368639388, 0.23519929246200022], [2.003824471994521, 3.4397048582995695, 2.939991155775], [1.98919801599456, 0.015510468322409016, 2.939991155775], [4.9619505732109195, 1.7149407808476886, 2.939991155775], [-0.9811665484054795, 1.7304512491700976, 8.819973467325], [1.9769595528109205, 3.4552153266219787, 8.819973467325], [-0.9957930044054386, 5.154645639147258, 8.819973467325], [1.2951876037515604, 1.6715114695449433, 7.3264579601913], [3.8748168435812405, 0.2859096327430727, 7.3264579601913], [3.7849686138672007, 3.212735005181651, 7.3264579601913], [-1.6898034166484392, 3.4986446379247242, 4.4335066629087], [0.7999775934672004, 1.957421102288016, 4.4335066629087], [0.8898258231812409, 4.884246474726595, 4.4335066629087], [3.7849686138672007, 3.212735005181651, 10.3134889744587], [1.2951876037515604, 1.6715114695449433, 10.3134889744587], [3.8748168435812405, 0.2859096327430727, 10.3134889744587], [0.8898258231812409, 4.884246474726595, 1.4464756486413], [-1.6898034166484392, 3.4986446379247242, 1.4464756486413], [0.7999775934672004, 1.957421102288016, 1.4464756486413]],
                "lattice_vectors": [[5.9699820408, 0.0, 0.0], [-2.9849910203999985, 5.170156107469667, 0.0], [0.0, 0.0, 11.7599646231]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "f": {"X_0": 2}, "h": {"X_0": 3}, "i": {"X_1": 6}}
            },
            {
                "Notes": "Li<sub>2</sub>Sb Structure",
                "Pearsons Symbol": "hP18",
                "Prototype": "Li2Sb",
                "Space Group Number": 190,
                "Space Group Symbol": "$P\\bar{6}2c$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2B_hP18_190_gh_bf",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_hP18_190_gh_bf.html",
                "atom_labels": ["Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Li", "Li", "Li", "Li", "Li", "Li", "Li", "Li", "Li", "Li", "Li", "Li"],
                "atom_positions": [[0.0, 0.0, 1.5675], [0.0, 0.0, 4.7025], [-3.972999999854383e-05, 4.587648177106961, 0.14107499999999998], [3.9729602700000006, 2.2937896813641885, 6.128925], [3.973000000082121e-05, 4.587648177106961, 2.9939249999999995], [3.9730000000000003, 2.293858495742773, 3.2760749999999996], [2.336124, 0.0, 0.0], [-1.1680619999999993, 2.023142730390518, 0.0], [2.8049380000000013, 4.8582951280806315, 0.0], [2.8049380000000013, 4.8582951280806315, 3.135], [2.336124, 0.0, 3.135], [-1.1680619999999993, 2.023142730390518, 3.135], [4.823222, 0.0688143785847115, 1.5675], [5.474794000000001, 4.142625590799632, 1.5675], [1.6209840000000006, 2.669997889086806, 1.5675], [0.8502220000000018, 6.812623479886438, 4.7025], [-2.352015999999999, 4.211439969384343, 4.7025], [1.5017940000000005, 2.7388122676715176, 4.7025]],
                "lattice_vectors": [[7.946, 0.0, 0.0], [-3.972999999999998, 6.881437858471149, 0.0], [0.0, 0.0, 6.27]],
                "normalized_wyckoff_matid": {"b": {"X_1": 1}, "f": {"X_1": 2}, "g": {"X_0": 3}, "h": {"X_0": 3}}
            }
        ],
        191: [
            {
                "Notes": "Li<sub>3</sub>N Structure",
                "Pearsons Symbol": "hP4",
                "Prototype": "Li3N",
                "Space Group Number": 191,
                "Space Group Symbol": "$P6/mmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A3B_hP4_191_bc_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hP4_191_bc_a.html",
                "atom_labels": ["N", "Li", "Li", "Li"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 1.93675], [-1.8287999999328084e-05, 2.111726903169698, 0.0], [1.8287817120000003, 1.0558476137122648, 0.0]],
                "lattice_vectors": [[3.6576, 0.0, 0.0], [-1.828799999999999, 3.167574516881963, 0.0], [0.0, 0.0, 3.8735]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "CaCu<sub>5</sub> (D2<sub>d</sub>) Structure",
                "Pearsons Symbol": "hP6",
                "Prototype": "CaCu5",
                "Space Group Number": 191,
                "Space Group Symbol": "$P6/mmm$",
                "Strukturbericht Designation": "$D2_{d}$",
                "aflow_prototype_id": "AB5_hP6_191_a_cg",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB5_hP6_191_a_cg.html",
                "atom_labels": ["Ca", "Cu", "Cu", "Cu", "Cu", "Cu"],
                "atom_positions": [[0.0, 0.0, 0.0], [-2.702499999896903e-05, 3.1205938078609523, 0.0], [2.702472975000001, 1.560273499593939, 0.0], [2.7025, 0.0, 2.0915], [1.3512500000000007, 2.3404336537274455, 2.0915], [-1.3512499999999994, 2.3404336537274455, 2.0915]],
                "lattice_vectors": [[5.405, 0.0, 0.0], [-2.702499999999999, 4.680867307454891, 0.0], [0.0, 0.0, 4.183]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_0": 2}, "g": {"X_0": 3}}
            },
            {
                "Notes": "CoSn (B35) Structure",
                "Pearsons Symbol": "hP6",
                "Prototype": "CoSn",
                "Space Group Number": 191,
                "Space Group Symbol": "$P6/mmm$",
                "Strukturbericht Designation": "$B35$",
                "aflow_prototype_id": "AB_hP6_191_f_ad",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP6_191_f_ad.html",
                "atom_labels": ["Sn", "Sn", "Sn", "Co", "Co", "Co"],
                "atom_positions": [[0.0, 0.0, 0.0], [-2.6394999999006014e-05, 3.0478473102123895, 2.12985], [2.6394736050000005, 1.5239007963656621, 2.12985], [2.6395, 0.0, 0.0], [1.3197500000000006, 2.285874053289026, 0.0], [-1.3197499999999993, 2.285874053289026, 0.0]],
                "lattice_vectors": [[5.279, 0.0, 0.0], [-2.6394999999999986, 4.571748106578052, 0.0], [0.0, 0.0, 4.2597]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "d": {"X_0": 2}, "f": {"X_1": 3}}
            },
            {
                "Notes": "AlB<sub>4</sub>Mg Structure",
                "Pearsons Symbol": "hP6",
                "Prototype": "AlB4Mg",
                "Space Group Number": 191,
                "Space Group Symbol": "$P6/mmm$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB4C_hP6_191_a_h_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB4C_hP6_191_a_h_b.html",
                "atom_labels": ["Al", "Mg", "B", "B", "B", "B"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.35624], [-1.5221799999398375e-05, 1.7576708538204568, 1.619721424], [1.5221647782000005, 0.8788222444447371, 1.619721424], [1.5221647782000005, 0.8788222444447371, 5.0927585760000005], [5.323451290450976e-16, 1.7576444888894742, 5.0927585760000005]],
                "lattice_vectors": [[3.04436, 0.0, 0.0], [-1.5221799999999994, 2.636493098265194, 0.0], [0.0, 0.0, 6.71248]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_2": 1}, "h": {"X_0": 4}}
            },
            {
                "Notes": "Simple Hexagonal Lattice (A<sub>f</sub>)",
                "Pearsons Symbol": "hP1",
                "Prototype": "HgSn6–10",
                "Space Group Number": 191,
                "Space Group Symbol": "$P6/mmm$",
                "Strukturbericht Designation": "$A_{f}$",
                "aflow_prototype_id": "A_hP1_191_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hP1_191_a.html",
                "atom_labels": ["Sn"],
                "atom_positions": [[0.0, 0.0, 0.0]],
                "lattice_vectors": [[3.2062, 0.0, 0.0], [-1.6030999999999993, 2.7766506496136674, 0.0], [0.0, 0.0, 2.9856]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}}
            },
            {
                "Notes": "Hexagonal $\\omega$  (C32) Structure",
                "Pearsons Symbol": "hP3",
                "Prototype": "AlB2",
                "Space Group Number": 191,
                "Space Group Symbol": "$P6/mmm$",
                "Strukturbericht Designation": "$C32$",
                "aflow_prototype_id": "AB2_hP3_191_a_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_hP3_191_a_d.html",
                "atom_labels": ["Al", "B", "B"],
                "atom_positions": [[0.0, 0.0, 0.0], [-1.5024999999571351e-05, 1.7349462336026198, 1.62685], [1.502484975, 0.8674601047696181, 1.62685]],
                "lattice_vectors": [[3.005, 0.0, 0.0], [-1.5024999999999993, 2.602406338372238, 0.0], [0.0, 0.0, 3.2537]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "d": {"X_0": 2}}
            },
            {
                "Notes": "Cu<sub>2</sub>Te (C<sub>h</sub>) Structure",
                "Pearsons Symbol": "hP6",
                "Prototype": "Cu2Te",
                "Space Group Number": 191,
                "Space Group Symbol": "$P6/mmm$",
                "Strukturbericht Designation": "$C_{h}$",
                "aflow_prototype_id": "A2B_hP6_191_h_e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_hP6_191_h_e.html",
                "atom_labels": ["Te", "Te", "Cu", "Cu", "Cu", "Cu"],
                "atom_positions": [[0.0, 0.0, 2.2175819999999997], [0.0, 0.0, 5.029418], [-2.118499999925081e-05, 2.4462453217218973, 1.15952], [2.1184788150000005, 1.2231043141127695, 1.15952], [2.1184788150000005, 1.2231043141127695, 6.087479999999999], [6.527685414425833e-16, 2.446208628225539, 6.087479999999999]],
                "lattice_vectors": [[4.237, 0.0, 0.0], [-2.118499999999999, 3.669349635834667, 0.0], [0.0, 0.0, 7.247]],
                "normalized_wyckoff_matid": {"e": {"X_1": 1}, "h": {"X_0": 2}}
            }
        ],
        192: [
            {
                "Notes": "Beryl (Be<sub>3</sub>Al<sub>2</sub>Si<sub>6</sub>O<sub>18</sub>, $G3_{1}$) Structure",
                "Pearsons Symbol": "hP58",
                "Prototype": "Al2Be3O18Si6",
                "Space Group Number": 192,
                "Space Group Symbol": "$P6/mcc$",
                "Strukturbericht Designation": "$G3_{1}$",
                "aflow_prototype_id": "A2B3C18D6_hP58_192_c_f_lm_l",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B3C18D6_hP58_192_c_f_lm_l.html",
                "atom_labels": ["Al", "Al", "Al", "Al", "Be", "Be", "Be", "Be", "Be", "Be", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "Si", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[-4.606999999845592e-05, 5.319731978840114, 2.2985], [4.606953930000001, 2.6598260916297045, 2.2985], [4.607046070000001, 2.6598260916297045, 6.8955], [4.607000000111831e-05, 5.319731978840114, 6.8955], [4.607, 0.0, 2.2985], [2.303500000000001, 3.989779035234909, 2.2985], [-2.303499999999999, 3.989779035234909, 2.2985], [4.607, 0.0, 6.8955], [2.303500000000001, 3.989779035234909, 6.8955], [-2.303499999999999, 3.989779035234909, 6.8955], [1.7677059000000008, 1.8903573068943, 0.0], [-0.7532444999999994, 2.4760568692667846, 0.0], [6.6930496, 0.5856995623724849, 0.0], [2.839294100000002, 6.089200763575518, 0.0], [5.360244500000002, 5.503501201203034, 0.0], [-2.086049599999998, 7.393858508097334, 0.0], [-2.8392940999999987, 6.089200763575518, 4.597], [2.5209504000000003, 0.5856995623724849, 4.597], [0.7532445000000004, 2.4760568692667846, 4.597], [7.446294100000001, 1.8903573068943, 4.597], [2.086049600000002, 7.393858508097334, 4.597], [3.853755500000001, 5.503501201203034, 4.597], [3.0373951000000003, 0.9248307803674519, 0.0], [0.7177706000000005, 3.0928767081141015, 0.0], [6.894375500000001, 2.1680459277466495, 0.0], [1.5696049000000023, 7.054727290102367, 0.0], [3.889229400000001, 4.886681362355717, 0.0], [-2.2873754999999987, 5.811512142723168, 0.0], [-1.5696048999999987, 7.054727290102367, 4.597], [2.3196245000000006, 2.1680459277466495, 4.597], [-0.7177705999999994, 3.0928767081141015, 4.597], [6.1766049, 0.9248307803674519, 4.597], [2.2873755000000022, 5.811512142723168, 4.597], [5.324770600000001, 4.886681362355717, 4.597], [3.9223998000000004, 1.1618236550604055, 1.3358882000000003], [0.9550311000000007, 3.9778096981292044, 1.3358882000000003], [6.2466313000000016, 2.815986043068799, 1.3358882000000003], [0.6846002000000014, 6.817734415409413, 1.3358882000000003], [3.6519689000000013, 4.001748372340614, 1.3358882000000003], [-1.639631299999999, 5.1635720274010195, 1.3358882000000003], [-0.684600199999999, 6.817734415409413, 3.2611118000000006], [2.9673687000000006, 2.815986043068799, 3.2611118000000006], [-0.9550310999999991, 3.9778096981292044, 3.2611118000000006], [5.2916002, 1.1618236550604055, 3.2611118000000006], [1.6396313000000013, 5.1635720274010195, 3.2611118000000006], [5.562031100000001, 4.001748372340614, 3.2611118000000006], [0.6846002000000014, 6.817734415409413, 7.8581118000000005], [3.6519689000000013, 4.001748372340614, 7.8581118000000005], [-1.639631299999999, 5.1635720274010195, 7.8581118000000005], [3.9223998000000004, 1.1618236550604055, 7.8581118000000005], [0.9550311000000007, 3.9778096981292044, 7.8581118000000005], [6.2466313000000016, 2.815986043068799, 7.8581118000000005], [5.2916002, 1.1618236550604055, 5.932888200000001], [1.6396313000000013, 5.1635720274010195, 5.932888200000001], [5.562031100000001, 4.001748372340614, 5.932888200000001], [-0.684600199999999, 6.817734415409413, 5.932888200000001], [2.9673687000000006, 2.815986043068799, 5.932888200000001], [-0.9550310999999991, 3.9778096981292044, 5.932888200000001]],
                "lattice_vectors": [[9.214, 0.0, 0.0], [-4.606999999999998, 7.979558070469818, 0.0], [0.0, 0.0, 9.194]],
                "normalized_wyckoff_matid": {"c": {"X_3": 2}, "f": {"X_2": 3}, "l": {"X_0": 6, "X_1": 6}, "m": {"X_0": 12}}
            }
        ],
        193: [
            {
                "Notes": "Mavlyanovite (Mn<sub>5</sub>Si<sub>3</sub>, $D8_{8}$) Structure",
                "Pearsons Symbol": "hP16",
                "Prototype": "Mn5Si3",
                "Space Group Number": 193,
                "Space Group Symbol": "$P6_{3}/mcm$",
                "Strukturbericht Designation": "$D8_{8}$",
                "aflow_prototype_id": "A5B3_hP16_193_dg_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B3_hP16_193_dg_g.html",
                "atom_labels": ["Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Si", "Si", "Si", "Si", "Si", "Si"],
                "atom_positions": [[-3.45520803442827e-05, 3.989750526360089, 0.0], [3.4551734824696556, 1.994845340200712, 2.40714493175], [3.4552425866303462, 1.994845340200712, 0.0], [3.4552080346331283e-05, 3.989750526360089, 2.40714493175], [1.6294761090937802, 0.0, 1.203572465875], [0.8147380545468904, 1.411167705335037, 3.6107173976249998], [-0.8147380545468897, 1.411167705335037, 1.203572465875], [5.28093996000622, 0.0, 3.6107173976249998], [2.6404699800031115, 4.573428161225764, 1.203572465875], [-2.640469980003109, 4.573428161225764, 3.6107173976249998], [4.14072130860472, 0.0, 1.203572465875], [2.0703606543023607, 3.585969843243232, 3.6107173976249998], [-2.070360654302359, 3.585969843243232, 1.203572465875], [2.7696947604952804, 0.0, 3.6107173976249998], [1.3848473802476409, 2.3986260233175694, 1.203572465875], [-1.3848473802476395, 2.3986260233175694, 3.6107173976249998]],
                "lattice_vectors": [[6.9104160691, 0.0, 0.0], [-3.4552080345499987, 5.9845958665608014, 0.0], [0.0, 0.0, 4.8142898635]],
                "normalized_wyckoff_matid": {"d": {"X_0": 2}, "g": {"X_0": 3, "X_1": 3}}
            }
        ],
        194: [
            {
                "Notes": "Lonsdaleite (Hexagonal Diamond) Structure",
                "Pearsons Symbol": "hP4",
                "Prototype": "C",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_hP4_194_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hP4_194_f.html",
                "atom_labels": ["C", "C", "C", "C"],
                "atom_positions": [[-1.2539999999503427e-05, 1.4480017150999571, 0.25077085], [1.2539874600000003, 0.7239899975914151, 2.34227085], [1.2539874600000003, 0.7239899975914151, 3.93222915], [4.394958708076047e-16, 1.4479799951828303, 1.8407291499999998]],
                "lattice_vectors": [[2.508, 0.0, 0.0], [-1.2539999999999993, 2.1719917126913724, 0.0], [0.0, 0.0, 4.183]],
                "normalized_wyckoff_matid": {"f": {"X_0": 1}}
            },
            {
                "Notes": "W<sub>2</sub>B<sub>5</sub> (D8<sub>h</sub>) Structure",
                "Pearsons Symbol": "hP14",
                "Prototype": "B5W2",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$D8_{h}$",
                "aflow_prototype_id": "A5B2_hP14_194_abdf_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B2_hP14_194_abdf_f.html",
                "atom_labels": ["B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "W", "W", "W", "W"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 6.935], [0.0, 0.0, 3.4675], [0.0, 0.0, 10.4025], [-1.4909999999482354e-05, 1.7216671110159778, 10.4025], [1.4909850900000003, 0.8608206430692186, 3.4675], [-1.4909999999482354e-05, 1.7216671110159778, 7.32336], [1.4909850900000003, 0.8608206430692186, 0.3883600000000003], [1.4909850900000003, 0.8608206430692186, 6.546639999999999], [4.497846006756846e-16, 1.7216412861384371, 13.481639999999999], [-1.4909999999482354e-05, 1.7216671110159778, 1.9279300000000001], [1.4909850900000003, 0.8608206430692186, 8.86293], [1.4909850900000003, 0.8608206430692186, 11.94207], [4.497846006756846e-16, 1.7216412861384371, 5.00707]],
                "lattice_vectors": [[2.982, 0.0, 0.0], [-1.4909999999999994, 2.5824877540851965, 0.0], [0.0, 0.0, 13.87]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_0": 1}, "c": {"X_0": 1}, "f": {"X_0": 2, "X_1": 2}}
            },
            {
                "Notes": "AsTi (B<sub>i</sub>) Structure",
                "Pearsons Symbol": "hP8",
                "Prototype": "AsTi",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$B_{i}$",
                "aflow_prototype_id": "AB_hP8_194_ad_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP8_194_ad_f.html",
                "atom_labels": ["As", "As", "As", "As", "Ti", "Ti", "Ti", "Ti"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 6.14], [-1.819999999943311e-05, 2.1015654876251375, 9.209999999999999], [1.8199818000000003, 1.05076698215022, 3.07], [-1.819999999943311e-05, 2.1015654876251375, 1.535], [1.8199818000000003, 1.05076698215022, 7.675], [1.8199818000000003, 1.05076698215022, 10.745], [4.840517320303662e-16, 2.10153396430044, 4.6049999999999995]],
                "lattice_vectors": [[3.64, 0.0, 0.0], [-1.8199999999999992, 3.152332469775357, 0.0], [0.0, 0.0, 12.28]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_0": 1}, "f": {"X_1": 2}}
            },
            {
                "Notes": "MgNi<sub>2</sub> Hexagonal Laves (C36) Structure",
                "Pearsons Symbol": "hP24",
                "Prototype": "MgNi2",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$C36$",
                "aflow_prototype_id": "AB2_hP24_194_ef_fgh",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_hP24_194_ef_fgh.html",
                "atom_labels": ["Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni"],
                "atom_positions": [[0.0, 0.0, 0.72767948], [0.0, 0.0, 8.640679480000001], [0.0, 0.0, 15.09832052], [0.0, 0.0, 7.18532052], [-2.411999999919715e-05, 2.785151624259248, 13.35983442], [2.4119758800000004, 1.3925549235968848, 5.446834420000002], [2.4119758800000004, 1.3925549235968848, 2.4661655800000006], [6.930687845851935e-16, 2.7851098471937696, 10.37916558], [-2.411999999919715e-05, 2.785151624259248, 1.98046564], [2.4119758800000004, 1.3925549235968848, 9.89346564], [2.4119758800000004, 1.3925549235968848, 13.84553436], [6.930687845851935e-16, 2.7851098471937696, 5.93253436], [2.412, 0.0, 0.0], [1.2060000000000004, 2.0888532739280663, 7.913], [-1.2059999999999995, 2.0888532739280663, 0.0], [2.412, 0.0, 7.913], [1.2060000000000004, 2.0888532739280663, 0.0], [-1.2059999999999995, 2.0888532739280663, 7.913], [2.575673363480746e-16, 1.372710817494568, 3.9565], [3.63519756, 0.686355408747284, 11.8695], [1.2231975600000007, 3.4913511391088483, 3.9565], [2.4120000000000004, 2.8049957303615645, 11.8695], [-1.2231975599999991, 3.4913511391088483, 3.9565], [1.18880244, 0.686355408747284, 11.8695]],
                "lattice_vectors": [[4.824, 0.0, 0.0], [-2.411999999999999, 4.177706547856133, 0.0], [0.0, 0.0, 15.826]],
                "normalized_wyckoff_matid": {"e": {"X_1": 2}, "f": {"X_0": 2, "X_1": 2}, "g": {"X_0": 3}, "h": {"X_0": 3}}
            },
            {
                "Notes": "AlCCr<sub>2</sub> Structure",
                "Pearsons Symbol": "hP8",
                "Prototype": "AlCCr2",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC2_hP8_194_d_a_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC2_hP8_194_d_a_f.html",
                "atom_labels": ["C", "C", "Al", "Al", "Cr", "Cr", "Cr", "Cr"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 6.41], [-1.4299999999438279e-05, 1.651230025991179, 9.615], [1.4299857000000002, 0.8256026288323155, 3.205], [-1.4299999999438279e-05, 1.651230025991179, 1.10252], [1.4299857000000002, 0.8256026288323155, 7.512519999999999], [1.4299857000000002, 0.8256026288323155, 11.71748], [4.966349109736257e-16, 1.651205257664631, 5.307480000000001]],
                "lattice_vectors": [[2.86, 0.0, 0.0], [-1.4299999999999993, 2.4768326548234945, 0.0], [0.0, 0.0, 12.82]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_2": 1}, "f": {"X_0": 2}}
            },
            {
                "Notes": "NiAs (B8<sub>1</sub>) Structure",
                "Pearsons Symbol": "hP4",
                "Prototype": "AsNi",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$B8_{1}$",
                "aflow_prototype_id": "AB_hP4_194_c_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP4_194_c_a.html",
                "atom_labels": ["Ni", "Ni", "As", "As"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 2.522], [-1.809499999934059e-05, 2.0894410713503766, 1.261], [1.8094819050000004, 1.0447048649455069, 3.7829999999999995]],
                "lattice_vectors": [[3.619, 0.0, 0.0], [-1.8094999999999992, 3.1341459362958837, 0.0], [0.0, 0.0, 5.044]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_1": 1}}
            },
            {
                "Notes": "Ni<sub>2</sub>In (B8<sub>2</sub>) Structure",
                "Pearsons Symbol": "hP6",
                "Prototype": "InNi2",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$B8_{2}$",
                "aflow_prototype_id": "AB2_hP6_194_c_ad",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_hP6_194_c_ad.html",
                "atom_labels": ["Ni", "Ni", "In", "In", "Ni", "Ni"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 2.5645], [-2.0929999999248158e-05, 2.416800310768908, 1.28225], [2.0929790700000006, 1.2083820294727528, 3.8467499999999997], [-2.0929999999248158e-05, 2.416800310768908, 3.8467499999999997], [2.0929790700000006, 1.2083820294727528, 1.28225]],
                "lattice_vectors": [[4.186, 0.0, 0.0], [-2.092999999999999, 3.6251823402416603, 0.0], [0.0, 0.0, 5.129]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_0": 1}, "d": {"X_1": 1}}
            },
            {
                "Notes": "Hexagonal Close Packed (Mg, A3) Structure",
                "Pearsons Symbol": "hP2",
                "Prototype": "Mg",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$A3$",
                "aflow_prototype_id": "A_hP2_194_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hP2_194_c.html",
                "atom_labels": ["Mg", "Mg"],
                "atom_positions": [[-1.604649999944265e-05, 1.8528994833613606, 1.30265], [1.6046339535000003, 0.9264358450040385, 3.9079500000000005]],
                "lattice_vectors": [[3.2093, 0.0, 0.0], [-1.6046499999999992, 2.779335328365399, 0.0], [0.0, 0.0, 5.2106]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}}
            },
            {
                "Notes": "Molybdenite (MoS<sub>2</sub>, C7) Structure",
                "Pearsons Symbol": "hP6",
                "Prototype": "MoS2",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$C7$",
                "aflow_prototype_id": "AB2_hP6_194_c_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_hP6_194_c_f.html",
                "atom_labels": ["Mo", "Mo", "S", "S", "S", "S"],
                "atom_positions": [[-1.5804999999518508e-05, 1.8250133259294117, 3.07375], [1.5804841950000001, 0.9124929754331991, 9.22125], [-1.5804999999518508e-05, 1.8250133259294117, 7.715112499999999], [1.5804841950000001, 0.9124929754331991, 1.5676124999999994], [1.5804841950000001, 0.9124929754331991, 4.579887500000001], [4.0955693947353213e-16, 1.8249859508663981, 10.7273875]],
                "lattice_vectors": [[3.161, 0.0, 0.0], [-1.5804999999999993, 2.7375063013626106, 0.0], [0.0, 0.0, 12.295]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "f": {"X_0": 2}}
            },
            {
                "Notes": "Covellite (CuS, B18) Structure",
                "Pearsons Symbol": "hP12",
                "Prototype": "CuS",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$B18$",
                "aflow_prototype_id": "AB_hP12_194_df_ce",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP12_194_df_ce.html",
                "atom_labels": ["S", "S", "Cu", "Cu", "S", "S", "S", "S", "Cu", "Cu", "Cu", "Cu"],
                "atom_positions": [[-1.9879999999359148e-05, 2.2955561480213036, 4.0955], [1.9879801200000002, 1.1477608574256246, 12.2865], [-1.9879999999359148e-05, 2.2955561480213036, 12.2865], [1.9879801200000002, 1.1477608574256246, 4.0955], [0.0, 0.0, 1.0435334000000003], [0.0, 0.0, 9.2345334], [0.0, 0.0, 15.338466600000002], [0.0, 0.0, 7.147466600000001], [-1.9879999999359148e-05, 2.2955561480213036, 1.7568056800000003], [1.9879801200000002, 1.1477608574256246, 9.94780568], [1.9879801200000002, 1.1477608574256246, 14.625194320000002], [5.503685684971061e-16, 2.2955217148512492, 6.4341943200000005]],
                "lattice_vectors": [[3.976, 0.0, 0.0], [-1.987999999999999, 3.443317005446928, 0.0], [0.0, 0.0, 16.382]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "d": {"X_1": 1}, "e": {"X_0": 2}, "f": {"X_1": 2}}
            },
            {
                "Notes": "AlN<sub>3</sub>Ti<sub>4</sub> Structure",
                "Pearsons Symbol": "hP16",
                "Prototype": "AlN3Ti4",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3C4_hP16_194_c_af_ef",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3C4_hP16_194_c_af_ef.html",
                "atom_labels": ["N", "N", "Al", "Al", "Ti", "Ti", "Ti", "Ti", "N", "N", "N", "N", "Ti", "Ti", "Ti", "Ti"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 11.686], [-1.4939999999508788e-05, 1.7251312299516235, 5.843], [1.4939850600000002, 0.8625526765562792, 17.529], [0.0, 0.0, 3.6062996], [0.0, 0.0, 15.2922996], [0.0, 0.0, 19.7657004], [0.0, 0.0, 8.0797004], [-1.4939999999508788e-05, 1.7251312299516235, 14.14006], [1.4939850600000002, 0.8625526765562792, 2.4540599999999997], [1.4939850600000002, 0.8625526765562792, 9.23194], [4.232125405678744e-16, 1.7251053531125584, 20.91794], [-1.4939999999508788e-05, 1.7251312299516235, 1.2597508000000002], [1.4939850600000002, 0.8625526765562792, 12.9457508], [1.4939850600000002, 0.8625526765562792, 22.112249199999997], [4.232125405678744e-16, 1.7251053531125584, 10.426249199999999]],
                "lattice_vectors": [[2.988, 0.0, 0.0], [-1.4939999999999993, 2.5876839065079027, 0.0], [0.0, 0.0, 23.372]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_2": 1}, "e": {"X_0": 2}, "f": {"X_0": 2, "X_1": 2}}
            },
            {
                "Notes": "MgZn<sub>2</sub> Hexagonal Laves (C14) Structure",
                "Pearsons Symbol": "hP12",
                "Prototype": "MgZn2",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$C14$",
                "aflow_prototype_id": "AB2_hP12_194_f_ah",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_hP12_194_f_ah.html",
                "atom_labels": ["Zn", "Zn", "Mg", "Mg", "Mg", "Mg", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 4.283], [-2.611499999903068e-05, 3.0155155334796953, 0.53845876], [2.6114738850000005, 1.5077351504864278, 4.8214587600000005], [2.6114738850000005, 1.5077351504864278, 8.02754124], [8.504585125024278e-16, 3.0154703009728556, 3.74454124], [3.8948955599999997, 0.7667814559459372, 2.1415], [1.283395560000001, 3.756469228020186, 6.4245], [2.6115000000000004, 2.9896877720742485, 2.1415], [-1.2833955599999989, 3.756469228020186, 6.4245], [1.3281044400000002, 0.7667814559459372, 2.1415], [4.147367249629497e-16, 1.5335629118918743, 6.4245]],
                "lattice_vectors": [[5.223, 0.0, 0.0], [-2.6114999999999986, 4.523250683966123, 0.0], [0.0, 0.0, 8.566]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "f": {"X_1": 2}, "h": {"X_0": 3}}
            },
            {
                "Notes": "Hypothetical Tetrahedrally Bonded Carbon with 3&ndash;Member Rings",
                "Pearsons Symbol": "hP6",
                "Prototype": "C",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_hP6_194_h",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hP6_194_h.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C"],
                "atom_positions": [[7.276644904408158e-16, 3.4175952810579466, 0.626415], [1.4447256667500001, 1.7087976405289733, 1.879245], [-0.7574993332499994, 2.105567949169398, 0.626415], [2.202225, 0.39677030864042456, 1.879245], [0.7574993332500004, 2.105567949169398, 0.626415], [2.95972433325, 1.7087976405289733, 1.879245]],
                "lattice_vectors": [[4.40445, 0.0, 0.0], [-2.202224999999999, 3.814365589698371, 0.0], [0.0, 0.0, 2.50566]],
                "normalized_wyckoff_matid": {"h": {"X_0": 1}}
            },
            {
                "Notes": "Na<sub>3</sub>As (D0<sub>18</sub>) Structure",
                "Pearsons Symbol": "hP8",
                "Prototype": "AsNa3",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$D0_{18}$",
                "aflow_prototype_id": "AB3_hP8_194_c_bf",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3_hP8_194_c_bf.html",
                "atom_labels": ["Na", "Na", "As", "As", "Na", "Na", "Na", "Na"],
                "atom_positions": [[0.0, 0.0, 2.2455], [0.0, 0.0, 6.7364999999999995], [-2.5439999999102027e-05, 2.9375728574276647, 2.2455], [2.5439745600000006, 1.4687643970275601, 6.7364999999999995], [-2.5439999999102027e-05, 2.9375728574276647, 8.236494], [2.5439745600000006, 1.4687643970275601, 3.7454939999999994], [2.5439745600000006, 1.4687643970275601, 0.745506], [7.821805070307164e-16, 2.9375287940551202, 5.236505999999999]],
                "lattice_vectors": [[5.088, 0.0, 0.0], [-2.5439999999999987, 4.406337254455225, 0.0], [0.0, 0.0, 8.982]],
                "normalized_wyckoff_matid": {"b": {"X_0": 1}, "c": {"X_1": 1}, "f": {"X_0": 2}}
            },
            {
                "Notes": "Hexagonal Graphite (A9) Crystal Structure",
                "Pearsons Symbol": "hP4",
                "Prototype": "C",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$A9$",
                "aflow_prototype_id": "A_hP4_194_bc",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hP4_194_bc.html",
                "atom_labels": ["C", "C", "C", "C"],
                "atom_positions": [[0.0, 0.0, 1.67775], [0.0, 0.0, 5.033250000000001], [-1.2319999999654975e-05, 1.4225981762385542, 1.67775], [1.2319876800000003, 0.7112884186863025, 5.033250000000001]],
                "lattice_vectors": [[2.464, 0.0, 0.0], [-1.2319999999999995, 2.133886594924857, 0.0], [0.0, 0.0, 6.711]],
                "normalized_wyckoff_matid": {"b": {"X_0": 1}, "c": {"X_0": 1}}
            },
            {
                "Notes": "LiBC Structure",
                "Pearsons Symbol": "hP6",
                "Prototype": "BCLi",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "ABC_hP6_194_c_d_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_hP6_194_c_d_a.html",
                "atom_labels": ["Li", "Li", "B", "B", "C", "C"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.529], [-1.3759999999517563e-05, 1.5888758851495541, 1.7645], [1.37598624, 0.7944260260652211, 5.2935], [-1.3759999999517563e-05, 1.5888758851495541, 5.2935], [1.37598624, 0.7944260260652211, 1.7645]],
                "lattice_vectors": [[2.752, 0.0, 0.0], [-1.3759999999999992, 2.383301911214775, 0.0], [0.0, 0.0, 7.058]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_1": 1}, "d": {"X_2": 1}}
            },
            {
                "Notes": "CaIn<sub>2</sub> Structure",
                "Pearsons Symbol": "hP6",
                "Prototype": "CaIn2",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB2_hP6_194_b_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB2_hP6_194_b_f.html",
                "atom_labels": ["Ca", "Ca", "In", "In", "In", "In"],
                "atom_positions": [[0.0, 0.0, 1.9375], [0.0, 0.0, 5.8125], [-2.447499999931259e-05, 2.8261436983310566, 0.34875], [2.447475525, 1.4130506531937708, 4.22375], [2.447475525, 1.4130506531937708, 7.40125], [5.760133703347492e-16, 2.8261013063875415, 3.52625]],
                "lattice_vectors": [[4.895, 0.0, 0.0], [-2.447499999999999, 4.239194351524827, 0.0], [0.0, 0.0, 7.75]],
                "normalized_wyckoff_matid": {"b": {"X_1": 1}, "f": {"X_0": 2}}
            },
            {
                "Notes": "$\\beta$&ndash;Tridymite (SiO<sub>2</sub>) Structure (C10)",
                "Pearsons Symbol": "hP12",
                "Prototype": "O2Si",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$C10$",
                "aflow_prototype_id": "A2B_hP12_194_cg_f",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B_hP12_194_cg_f.html",
                "atom_labels": ["O", "O", "Si", "Si", "Si", "Si", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[-2.5259999999017434e-05, 2.916788143813789, 2.0675], [2.52597474, 1.458372196105195, 6.2025], [-2.5259999999017434e-05, 2.916788143813789, 0.51274], [2.52597474, 1.458372196105195, 4.647740000000001], [2.52597474, 1.458372196105195, 7.757259999999999], [8.675920781797686e-16, 2.91674439221039, 3.62226], [2.526, 0.0, 0.0], [1.2630000000000006, 2.187580169959492, 4.135], [-1.2629999999999992, 2.187580169959492, 0.0], [2.526, 0.0, 4.135], [1.2630000000000006, 2.187580169959492, 0.0], [-1.2629999999999992, 2.187580169959492, 4.135]],
                "lattice_vectors": [[5.052, 0.0, 0.0], [-2.5259999999999985, 4.375160339918984, 0.0], [0.0, 0.0, 8.27]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "f": {"X_1": 2}, "g": {"X_0": 3}}
            },
            {
                "Notes": "$\\alpha$&ndash;La (A3') Structure",
                "Pearsons Symbol": "hP4",
                "Prototype": "La",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$A3'$",
                "aflow_prototype_id": "A_hP4_194_ac",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_hP4_194_ac.html",
                "atom_labels": ["La", "La", "La", "La"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 6.065], [-1.8849999999389073e-05, 2.1766213978974633, 3.0325], [1.8849811500000002, 1.0882943743698705, 9.0975]],
                "lattice_vectors": [[3.77, 0.0, 0.0], [-1.8849999999999991, 3.264915772267334, 0.0], [0.0, 0.0, 12.13]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_0": 1}}
            },
            {
                "Notes": "CMo Structure",
                "Pearsons Symbol": "hP12",
                "Prototype": "CMo",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB_hP12_194_af_bf",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP12_194_af_bf.html",
                "atom_labels": ["C", "C", "Mo", "Mo", "C", "C", "C", "C", "Mo", "Mo", "Mo", "Mo"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 7.305], [0.0, 0.0, 3.6525], [0.0, 0.0, 10.9575], [-1.5049999999544037e-05, 1.737832999382325, 2.42526], [1.50498495, 0.8689034660088355, 9.73026], [1.50498495, 0.8689034660088355, 12.18474], [3.874626841593454e-16, 1.737806932017671, 4.879739999999999], [-1.5049999999544037e-05, 1.737832999382325, 8.517629999999999], [1.50498495, 0.8689034660088355, 1.2126299999999994], [1.50498495, 0.8689034660088355, 6.092370000000001], [3.874626841593454e-16, 1.737806932017671, 13.39737]],
                "lattice_vectors": [[3.01, 0.0, 0.0], [-1.5049999999999992, 2.6067364653911604, 0.0], [0.0, 0.0, 14.61]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "b": {"X_1": 1}, "f": {"X_0": 2, "X_1": 2}}
            },
            {
                "Notes": "Ni<sub>3</sub>Sn (D0<sub>19</sub>) Structure",
                "Pearsons Symbol": "hP8",
                "Prototype": "Ni3Sn",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$D0_{19}$",
                "aflow_prototype_id": "A3B_hP8_194_h_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hP8_194_h_c.html",
                "atom_labels": ["Sn", "Sn", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni"],
                "atom_positions": [[-2.6474999998903807e-05, 3.0570849607074453, 1.06175], [2.6474735250000005, 1.5285195523311574, 3.18525], [2.6475000000000004, 3.110874101645388, 1.06175], [-1.3703459999999992, 3.8482393073419954, 3.18525], [1.2771540000000003, 0.737365205696607, 1.06175], [7.515779110178756e-16, 1.4747304113932147, 3.18525], [4.0178460000000005, 0.7373652056966076, 1.06175], [1.3703460000000007, 3.848239307341996, 3.18525]],
                "lattice_vectors": [[5.295, 0.0, 0.0], [-2.6474999999999986, 4.585604513038603, 0.0], [0.0, 0.0, 4.247]],
                "normalized_wyckoff_matid": {"c": {"X_1": 1}, "h": {"X_0": 3}}
            },
            {
                "Notes": "BN (B<sub>k</sub>) Structure",
                "Pearsons Symbol": "hP4",
                "Prototype": "BN",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$B_{k}$",
                "aflow_prototype_id": "AB_hP4_194_c_d",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_hP4_194_c_d.html",
                "atom_labels": ["B", "B", "N", "N"],
                "atom_positions": [[-1.251994999947071e-05, 1.445686528944634, 1.6653], [1.2519824800500003, 0.7228324218775629, 4.9959], [-1.251994999947071e-05, 1.445686528944634, 4.9959], [1.2519824800500003, 0.7228324218775629, 1.6653]],
                "lattice_vectors": [[2.50399, 0.0, 0.0], [-1.2519949999999993, 2.1685189508221967, 0.0], [0.0, 0.0, 6.6612]],
                "normalized_wyckoff_matid": {"c": {"X_0": 1}, "d": {"X_1": 1}}
            },
            {
                "Notes": "Co<sub>2</sub>Al<sub>5</sub> ($D8_{11}$) Structure",
                "Pearsons Symbol": "hP28",
                "Prototype": "Al5Co2",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$D8_{11}$",
                "aflow_prototype_id": "A5B2_hP28_194_ahk_ch",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A5B2_hP28_194_ahk_ch.html",
                "atom_labels": ["Al", "Al", "Co", "Co", "Al", "Al", "Al", "Al", "Al", "Al", "Co", "Co", "Co", "Co", "Co", "Co", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.7965], [-3.827999999849973e-05, 4.420215761884079, 1.89825], [3.8279617200000007, 2.210074729489583, 5.69475], [3.8280000000000003, 0.4375991724306617, 1.89825], [1.535028000000001, 3.5339448319021622, 5.69475], [5.363028, 3.0963456594715004, 1.89825], [1.6676864333931005e-15, 6.192691318943, 5.69475], [2.2929720000000002, 3.0963456594715, 1.89825], [-1.5350279999999987, 3.5339448319021614, 5.69475], [3.8280000000000007, 4.932936125582005, 1.89825], [-2.3580479999999984, 5.781613308477834, 5.69475], [1.4699520000000001, 0.8486771828958288, 1.89825], [4.2368952790639015e-16, 1.6973543657916577, 5.69475], [6.1860479999999995, 0.8486771828958288, 1.89825], [2.3580480000000015, 5.781613308477834, 5.69475], [6.083347159346887e-16, 2.599073872618476, 3.333327], [5.405136000000001, 1.299536936309238, 7.129827000000001], [1.5771360000000008, 5.330753555064425, 3.333327], [3.828000000000001, 4.031216618755186, 7.129827000000001], [-1.5771359999999988, 5.330753555064425, 3.333327], [2.250864, 1.299536936309238, 7.129827000000001], [3.828000000000001, 4.031216618755186, 4.259672999999999], [-1.5771359999999988, 5.330753555064425, 0.463173], [2.250864, 1.299536936309238, 4.259672999999999], [6.083347159346887e-16, 2.599073872618476, 0.463173], [5.405136000000001, 1.299536936309238, 4.259672999999999], [1.5771360000000008, 5.330753555064425, 0.463173]],
                "lattice_vectors": [[7.656, 0.0, 0.0], [-3.827999999999998, 6.630290491373662, 0.0], [0.0, 0.0, 7.593]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "c": {"X_1": 1}, "h": {"X_0": 3, "X_1": 3}, "k": {"X_0": 6}}
            },
            {
                "Notes": "Ni<sub>3</sub>Ti ($D0_{24}$) Structure",
                "Pearsons Symbol": "hP16",
                "Prototype": "Ni3Ti",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$D0_{24}$",
                "aflow_prototype_id": "A3B_hP16_194_gh_ac",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_hP16_194_gh_ac.html",
                "atom_labels": ["Ti", "Ti", "Ti", "Ti", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 4.152], [-2.54799999989399e-05, 2.942191682675192, 2.076], [2.547974520000001, 1.4710737750103078, 6.228], [2.548, 0.0, 0.0], [1.2740000000000007, 2.20663272884275, 4.152], [-1.2739999999999994, 2.20663272884275, 0.0], [2.548, 0.0, 4.152], [1.2740000000000007, 2.20663272884275, 0.0], [-1.2739999999999994, 2.20663272884275, 4.152], [2.547974520000001, 2.942191682675192, 2.076], [-1.2740254799999988, 3.677706503853058, 6.228], [1.2740000000000005, 0.7355148211778655, 2.076], [2.5480000000494213e-05, 1.4710737750103078, 6.228], [3.8220254800000006, 0.7355589538324424, 2.076], [1.2740000000000014, 3.6777506365076347, 6.228]],
                "lattice_vectors": [[5.096, 0.0, 0.0], [-2.5479999999999987, 4.4132654576855, 0.0], [0.0, 0.0, 8.304]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "c": {"X_1": 1}, "g": {"X_0": 3}, "h": {"X_0": 3}}
            },
            {
                "Notes": "Al<sub>9</sub>Mn<sub>3</sub>Si ($E9_{c}$) Structure",
                "Pearsons Symbol": "hP26",
                "Prototype": "Al9Mn3Si",
                "Space Group Number": 194,
                "Space Group Symbol": "$P6_{3}/mmc$",
                "Strukturbericht Designation": "$E9_{c}$",
                "aflow_prototype_id": "A9B3C_hP26_194_hk_h_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A9B3C_hP26_194_hk_h_a.html",
                "atom_labels": ["Si", "Si", "Al", "Al", "Al", "Al", "Al", "Al", "Mn", "Mn", "Mn", "Mn", "Mn", "Mn", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al", "Al"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 0.0, 3.8725], [1.604035571034501e-15, 5.959907154507359, 1.93625], [2.351569000000001, 2.9799535772536796, 5.80875], [-1.4049309999999995, 3.5264952813788084, 1.93625], [3.7565000000000004, 0.5465417041251287, 5.80875], [1.4049310000000008, 3.5264952813788084, 1.93625], [5.161431000000001, 2.9799535772536796, 5.80875], [3.886357902160853e-16, 1.561547726071797, 1.93625], [6.16066, 0.7807738630358985, 5.80875], [2.404160000000002, 5.725674995596589, 1.93625], [3.7565000000000013, 4.94490113256069, 5.80875], [-2.4041599999999983, 5.725674995596589, 1.93625], [1.35234, 0.7807738630358985, 5.80875], [6.826312848318139e-16, 2.6155924411702602, 7.226085], [5.2478305, 1.3077962205851301, 3.353585], [1.4913305000000014, 5.198652638047357, 7.226085], [3.7565000000000004, 3.8908564174622273, 3.353585], [-1.4913304999999983, 5.198652638047357, 7.226085], [2.2651695000000003, 1.3077962205851301, 3.353585], [3.7565000000000004, 3.8908564174622273, 0.518915], [-1.4913304999999983, 5.198652638047357, 4.391414999999999], [2.2651695000000003, 1.3077962205851301, 0.518915], [6.826312848318139e-16, 2.6155924411702602, 4.391414999999999], [5.2478305, 1.3077962205851301, 0.518915], [1.4913305000000014, 5.198652638047357, 4.391414999999999]],
                "lattice_vectors": [[7.513, 0.0, 0.0], [-3.756499999999998, 6.506448858632488, 0.0], [0.0, 0.0, 7.745]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "h": {"X_0": 3, "X_1": 3}, "k": {"X_0": 6}}
            }
        ],
        195: [
            {
                "Notes": "PrRu<sub>4</sub>P<sub>12</sub> Structure",
                "Pearsons Symbol": "cP34",
                "Prototype": "P12PrRu4",
                "Space Group Number": 195,
                "Space Group Symbol": "$P23$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A12BC4_cP34_195_2j_ab_2e",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A12BC4_cP34_195_2j_ab_2e.html",
                "atom_labels": ["Pr", "Pr", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "Ru", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P", "P"],
                "atom_positions": [[0.0, 0.0, 0.0], [4.01788862995, 4.01788862995, 4.01788862995], [2.00331927089307, 2.00331927089307, 2.00331927089307], [2.00331927089307, 6.03245798900693, 6.03245798900693], [6.03245798900693, 2.00331927089307, 6.03245798900693], [6.03245798900693, 6.03245798900693, 2.00331927089307], [6.03245798900693, 6.03245798900693, 6.03245798900693], [6.03245798900693, 2.0033192708930696, 2.0033192708930696], [2.0033192708930696, 6.03245798900693, 2.0033192708930696], [2.0033192708930696, 2.0033192708930696, 6.03245798900693], [1.1430893152207748, 4.01788862995, 2.859049191299821], [1.1430893152207748, 4.01788862995, 5.176728068600179], [6.892687944679225, 4.01788862995, 5.176728068600179], [6.892687944679225, 4.01788862995, 2.859049191299821], [4.01788862995, 2.859049191299821, 1.1430893152207748], [4.01788862995, 5.176728068600179, 6.892687944679225], [4.01788862995, 2.859049191299821, 6.892687944679225], [4.01788862995, 5.176728068600179, 1.1430893152207748], [2.859049191299821, 1.1430893152207748, 4.01788862995], [2.859049191299821, 6.892687944679225, 4.01788862995], [5.176728068600179, 1.1430893152207748, 4.01788862995], [5.176728068600179, 6.892687944679225, 4.01788862995], [0.00160715545198, 1.1479911393493138, 2.879299349994769], [0.00160715545198, 6.887786120550686, 5.156477909905231], [8.03417010444802, 1.1479911393493138, 5.156477909905231], [8.03417010444802, 6.887786120550686, 2.879299349994769], [1.1479911393493138, 2.879299349994769, 0.00160715545198], [1.1479911393493138, 5.156477909905231, 8.03417010444802], [6.887786120550686, 2.879299349994769, 8.03417010444802], [6.887786120550686, 5.156477909905231, 0.00160715545198], [2.879299349994769, 0.00160715545198, 1.1479911393493138], [2.879299349994769, 8.03417010444802, 6.887786120550686], [5.156477909905231, 0.00160715545198, 6.887786120550686], [5.156477909905231, 8.03417010444802, 1.1479911393493138]],
                "lattice_vectors": [[8.0357772599, 0.0, 0.0], [0.0, 8.0357772599, 0.0], [0.0, 0.0, 8.0357772599]]
            }
        ],
        196: [
            {
                "Notes": "Cu<sub>2</sub>Fe[CN]<sub>6</sub> Structure",
                "Pearsons Symbol": "cF60",
                "Prototype": "CCu2Fe[N]6",
                "Space Group Number": 196,
                "Space Group Symbol": "$F23$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A12B2C_cF60_196_h_bc_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A12B2C_cF60_196_h_bc_a.html",
                "atom_labels": ["Fe", "Fe", "Fe", "Fe", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "Cu", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 4.9899966667, 4.9899966667], [4.9899966667, 0.0, 4.9899966667], [4.9899966667, 4.9899966667, 0.0], [4.9899966667, 4.9899966667, 4.9899966667], [4.9899966667, 0.0, 0.0], [0.0, 4.9899966667, 0.0], [0.0, 0.0, 4.9899966667], [2.49499833335, 2.49499833335, 2.49499833335], [2.49499833335, 7.48499500005, 7.48499500005], [7.48499500005, 2.49499833335, 7.48499500005], [7.48499500005, 7.48499500005, 2.49499833335], [0.0, 0.6237495833375, 2.49499833335], [0.0, 9.3562437500625, 7.48499500005], [0.0, 0.6237495833375, 7.48499500005], [0.0, 9.3562437500625, 2.49499833335], [0.6237495833375, 2.49499833335, 0.0], [0.6237495833375, 7.48499500005, 0.0], [9.3562437500625, 2.49499833335, 0.0], [9.3562437500625, 7.48499500005, 0.0], [2.49499833335, 0.0, 0.6237495833375], [2.49499833335, 0.0, 9.3562437500625], [7.48499500005, 0.0, 9.3562437500625], [7.48499500005, 0.0, 0.6237495833375], [0.0, 5.6137462500375, 7.48499500005], [0.0, 4.3662470833625, 2.49499833335], [0.0, 5.6137462500375, 2.49499833335], [0.0, 4.3662470833625, 7.48499500005], [0.6237495833375, 7.48499500005, 4.9899966667], [0.6237495833375, 2.49499833335, 4.9899966667], [9.3562437500625, 7.48499500005, 4.9899966667], [9.3562437500625, 2.49499833335, 4.9899966667], [2.49499833335, 4.9899966667, 5.6137462500375], [2.49499833335, 4.9899966667, 4.3662470833625], [7.48499500005, 4.9899966667, 4.3662470833625], [7.48499500005, 4.9899966667, 5.6137462500375], [4.9899966667, 0.6237495833375, 7.48499500005], [4.9899966667, 9.3562437500625, 2.49499833335], [4.9899966667, 0.6237495833375, 2.49499833335], [4.9899966667, 9.3562437500625, 7.48499500005], [5.6137462500375, 2.49499833335, 4.9899966667], [5.6137462500375, 7.48499500005, 4.9899966667], [4.3662470833625, 2.49499833335, 4.9899966667], [4.3662470833625, 7.48499500005, 4.9899966667], [7.48499500005, 0.0, 5.6137462500375], [7.48499500005, 0.0, 4.3662470833625], [2.49499833335, 0.0, 4.3662470833625], [2.49499833335, 0.0, 5.6137462500375], [4.9899966667, 5.6137462500375, 2.49499833335], [4.9899966667, 4.3662470833625, 7.48499500005], [4.9899966667, 5.6137462500375, 7.48499500005], [4.9899966667, 4.3662470833625, 2.49499833335], [5.6137462500375, 7.48499500005, 0.0], [5.6137462500375, 2.49499833335, 0.0], [4.3662470833625, 7.48499500005, 0.0], [4.3662470833625, 2.49499833335, 0.0], [7.48499500005, 4.9899966667, 0.6237495833375], [7.48499500005, 4.9899966667, 9.3562437500625], [2.49499833335, 4.9899966667, 9.3562437500625], [2.49499833335, 4.9899966667, 0.6237495833375]],
                "lattice_vectors": [[9.9799933334, 0.0, 0.0], [0.0, 9.9799933334, 0.0], [0.0, 0.0, 9.9799933334]],
                "normalized_wyckoff_matid": {"a": {"X_2": 1}, "b": {"X_1": 1}, "c": {"X_1": 1}, "h": {"X_0": 12}}
            }
        ],
        197: [
            {
                "Notes": "Ga<sub>4</sub>Ni Structure",
                "Pearsons Symbol": "cI40",
                "Prototype": "Ga4Ni",
                "Space Group Number": 197,
                "Space Group Symbol": "$I23$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A4B_cI40_197_cde_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A4B_cI40_197_cde_c.html",
                "atom_labels": ["Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ni", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga", "Ga"],
                "atom_positions": [[1.4060406, 1.4060406, 1.4060406], [1.4060406, 7.0234594, 7.0234594], [7.0234594, 1.4060406, 7.0234594], [7.0234594, 7.0234594, 1.4060406], [5.620790600000001, 5.620790600000001, 5.620790600000001], [5.620790600000001, 2.8087094, 2.8087094], [2.8087094, 5.620790600000001, 2.8087094], [2.8087094, 2.8087094, 5.620790600000001], [2.8196677500000003, 2.8196677500000003, 2.8196677500000003], [2.8196677500000003, 5.60983225, 5.60983225], [5.60983225, 2.8196677500000003, 5.60983225], [5.60983225, 5.60983225, 2.8196677500000003], [7.034417750000001, 7.034417750000001, 7.034417750000001], [7.034417750000001, 1.39508225, 1.39508225], [1.39508225, 7.034417750000001, 1.39508225], [1.39508225, 1.39508225, 7.034417750000001], [5.4589442, 0.0, 0.0], [2.9705558000000005, 0.0, 0.0], [0.0, 0.0, 5.4589442], [0.0, 0.0, 2.9705558000000005], [0.0, 5.4589442, 0.0], [0.0, 2.9705558000000005, 0.0], [1.2441941999999997, 4.21475, 4.21475], [7.185305800000001, 4.21475, 4.21475], [4.21475, 4.21475, 1.2441941999999997], [4.21475, 4.21475, 7.185305800000001], [4.21475, 1.2441941999999997, 4.21475], [4.21475, 7.185305800000001, 4.21475], [6.3086378000000005, 4.21475, 0.0], [2.120862200000001, 4.21475, 0.0], [4.21475, 0.0, 6.3086378000000005], [4.21475, 0.0, 2.120862200000001], [0.0, 6.3086378000000005, 4.21475], [0.0, 2.120862200000001, 4.21475], [2.0938877999999996, 0.0, 4.21475], [6.335612200000001, 0.0, 4.21475], [0.0, 4.21475, 2.0938877999999996], [0.0, 4.21475, 6.335612200000001], [4.21475, 2.0938877999999996, 0.0], [4.21475, 6.335612200000001, 0.0]],
                "lattice_vectors": [[8.4295, 0.0, 0.0], [0.0, 8.4295, 0.0], [0.0, 0.0, 8.4295]]
            }
        ],
        198: [
            {
                "Notes": "FeSi (B20) Structure",
                "Pearsons Symbol": "cP8",
                "Prototype": "FeSi",
                "Space Group Number": 198,
                "Space Group Symbol": "$P2_{1}3$",
                "Strukturbericht Designation": "$B20$",
                "aflow_prototype_id": "AB_cP8_198_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_cP8_198_a_a.FeSi.html",
                "atom_labels": ["Fe", "Fe", "Fe", "Fe", "Si", "Si", "Si", "Si"],
                "atom_positions": [[0.6125488576, 0.6125488576, 0.6125488576], [2.8559888576, 1.6308911424, 3.8743311424000004], [3.8743311424000004, 2.8559888576, 1.6308911424], [1.6308911424, 3.8743311424000004, 2.8559888576], [3.7797477120000003, 3.7797477120000003, 3.7797477120000003], [1.5363077120000002, 2.950572288, 0.7071322879999998], [0.7071322879999998, 1.5363077120000002, 2.950572288], [2.950572288, 0.7071322879999998, 1.5363077120000002]],
                "lattice_vectors": [[4.48688, 0.0, 0.0], [0.0, 4.48688, 0.0], [0.0, 0.0, 4.48688]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "$\\alpha$&ndash;N (P2<sub>1</sub>3) Structure",
                "Pearsons Symbol": "cP8",
                "Prototype": "N",
                "Space Group Number": 198,
                "Space Group Symbol": "$P2_{1}3$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_cP8_198_2a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_cP8_198_2a.html",
                "atom_labels": ["N", "N", "N", "N", "N", "N", "N", "N"],
                "atom_positions": [[0.39493500000000004, 0.39493500000000004, 0.39493500000000004], [3.219935, 2.430065, 5.255065000000001], [5.255065000000001, 3.219935, 2.430065], [2.430065, 5.255065000000001, 3.219935], [5.43643, 5.43643, 5.43643], [2.6114300000000004, 3.0385700000000004, 0.21357], [0.21357, 2.6114300000000004, 3.0385700000000004], [3.0385700000000004, 0.21357, 2.6114300000000004]],
                "lattice_vectors": [[5.65, 0.0, 0.0], [0.0, 5.65, 0.0], [0.0, 0.0, 5.65]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}}
            },
            {
                "Notes": "$\\alpha$&ndash;CO (B21) Structure",
                "Pearsons Symbol": "cP8",
                "Prototype": "CO",
                "Space Group Number": 198,
                "Space Group Symbol": "$P2_{1}3$",
                "Strukturbericht Designation": "$B21$",
                "aflow_prototype_id": "AB_cP8_198_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_cP8_198_a_a.alpha-CO.html",
                "atom_labels": ["C", "C", "C", "C", "O", "O", "O", "O"],
                "atom_positions": [[5.39354, 5.39354, 5.39354], [2.57854, 3.05146, 0.23646], [0.23646, 2.57854, 3.05146], [3.05146, 0.23646, 2.57854], [0.37721, 0.37721, 0.37721], [3.1922099999999998, 2.43779, 5.25279], [5.25279, 3.1922099999999998, 2.43779], [2.43779, 5.25279, 3.1922099999999998]],
                "lattice_vectors": [[5.63, 0.0, 0.0], [0.0, 5.63, 0.0], [0.0, 0.0, 5.63]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}}
            },
            {
                "Notes": "Ullmanite (NiSSb, F0<sub>1</sub>) Structure",
                "Pearsons Symbol": "cP12",
                "Prototype": "NiSSb",
                "Space Group Number": 198,
                "Space Group Symbol": "$P2_{1}3$",
                "Strukturbericht Designation": "$F0_{1}$",
                "aflow_prototype_id": "ABC_cP12_198_a_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC_cP12_198_a_a_a.html",
                "atom_labels": ["Ni", "Ni", "Ni", "Ni", "S", "S", "S", "S", "Sb", "Sb", "Sb", "Sb"],
                "atom_positions": [[5.7398560000000005, 5.7398560000000005, 5.7398560000000005], [2.799356, 3.0816440000000003, 0.14114400000000002], [0.14114400000000002, 2.799356, 3.0816440000000003], [3.0816440000000003, 0.14114400000000002, 2.799356], [2.29359, 2.29359, 2.29359], [5.23409, 0.64691, 3.58741], [3.58741, 5.23409, 0.64691], [0.64691, 3.58741, 5.23409], [5.145875, 5.145875, 5.145875], [2.205375, 3.675625, 0.735125], [0.735125, 2.205375, 3.675625], [3.675625, 0.735125, 2.205375]],
                "lattice_vectors": [[5.881, 0.0, 0.0], [0.0, 5.881, 0.0], [0.0, 0.0, 5.881]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1, "X_2": 1}}
            },
            {
                "Notes": "Ammonia (NH<sub>3</sub>, D1) Structure",
                "Pearsons Symbol": "cP16",
                "Prototype": "H3N",
                "Space Group Number": 198,
                "Space Group Symbol": "$P2_{1}3$",
                "Strukturbericht Designation": "$D1$",
                "aflow_prototype_id": "A3B_cP16_198_b_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A3B_cP16_198_b_a.html",
                "atom_labels": ["N", "N", "N", "N", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[1.08099635, 1.08099635, 1.08099635], [3.6462463499999997, 1.4842536499999999, 4.04950365], [4.04950365, 3.6462463499999997, 1.4842536499999999], [1.4842536499999999, 4.04950365, 3.6462463499999997], [1.89264145, 1.37035655, 0.5946249499999999], [4.45789145, 1.19489345, 4.53587505], [3.23785855, 3.9356065499999997, 1.9706250499999998], [0.67260855, 3.7601434499999997, 3.15987495], [1.37035655, 0.5946249499999999, 1.89264145], [3.9356065499999997, 1.9706250499999998, 3.23785855], [3.7601434499999997, 3.15987495, 0.67260855], [1.19489345, 4.53587505, 4.45789145], [0.5946249499999999, 1.89264145, 1.37035655], [3.15987495, 0.67260855, 3.7601434499999997], [4.53587505, 4.45789145, 1.19489345], [1.9706250499999998, 3.23785855, 3.9356065499999997]],
                "lattice_vectors": [[5.1305, 0.0, 0.0], [0.0, 5.1305, 0.0], [0.0, 0.0, 5.1305]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1}, "b": {"X_0": 3}}
            },
            {
                "Notes": "Sodium Chlorate (NaClO<sub>3</sub>, $G3$) Structure",
                "Pearsons Symbol": "cP20",
                "Prototype": "ClNaO3",
                "Space Group Number": 198,
                "Space Group Symbol": "$P2_{1}3$",
                "Strukturbericht Designation": "$G3$",
                "aflow_prototype_id": "ABC3_cP20_198_a_a_b",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/ABC3_cP20_198_a_a_b.html",
                "atom_labels": ["Cl", "Cl", "Cl", "Cl", "Na", "Na", "Na", "Na", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[2.73969, 2.73969, 2.73969], [6.0246900000000005, 0.5453100000000002, 3.83031], [3.83031, 6.0246900000000005, 0.5453100000000002], [0.5453100000000002, 3.83031, 6.0246900000000005], [0.42048, 0.42048, 0.42048], [3.7054800000000006, 2.86452, 6.14952], [6.14952, 3.7054800000000006, 2.86452], [2.86452, 6.14952, 3.7054800000000006], [1.99071, 3.88944, 3.285], [5.27571, 5.965560000000001, 3.285], [4.57929, 0.6044400000000005, 0.0], [1.2942900000000002, 2.6805600000000003, 0.0], [3.88944, 3.285, 1.99071], [0.6044400000000005, 0.0, 4.57929], [2.6805600000000003, 0.0, 1.2942900000000002], [5.965560000000001, 3.285, 5.27571], [3.285, 1.99071, 3.88944], [0.0, 1.2942900000000002, 2.6805600000000003], [3.285, 5.27571, 5.965560000000001], [0.0, 4.57929, 0.6044400000000005]],
                "lattice_vectors": [[6.57, 0.0, 0.0], [0.0, 6.57, 0.0], [0.0, 0.0, 6.57]],
                "normalized_wyckoff_matid": {"a": {"X_1": 1, "X_2": 1}, "b": {"X_0": 3}}
            }
        ],
        199: [
            {
                "Notes": "CoU (B<sub>a</sub>) Structure",
                "Pearsons Symbol": "cI16",
                "Prototype": "CoU",
                "Space Group Number": 199,
                "Space Group Symbol": "$I2_{1}3$",
                "Strukturbericht Designation": "$B_{a}$",
                "aflow_prototype_id": "AB_cI16_199_a_a",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB_cI16_199_a_a.html",
                "atom_labels": ["Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "U", "U", "U", "U", "U", "U", "U", "U"],
                "atom_positions": [[1.8685758, 1.8685758, 1.8685758], [1.8685758, 4.487124199999999, 1.3092742], [1.3092742, 1.8685758, 4.487124199999999], [4.487124199999999, 1.3092742, 1.8685758], [5.0464258, 5.0464258, 5.0464258], [5.0464258, 1.3092742, 4.487124199999999], [4.487124199999999, 5.0464258, 1.3092742], [1.3092742, 4.487124199999999, 5.0464258], [0.22054279, 0.22054279, 0.22054279], [0.22054279, 6.13515721, 2.9573072099999997], [2.9573072099999997, 0.22054279, 6.13515721], [6.13515721, 2.9573072099999997, 0.22054279], [3.3983927899999995, 3.3983927899999995, 3.3983927899999995], [3.3983927899999995, 2.9573072099999997, 6.13515721], [6.13515721, 3.3983927899999995, 2.9573072099999997], [2.9573072099999997, 6.13515721, 3.3983927899999995]],
                "lattice_vectors": [[6.3557, 0.0, 0.0], [0.0, 6.3557, 0.0], [0.0, 0.0, 6.3557]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1, "X_1": 1}}
            }
        ],
        200: [
            {
                "Notes": "Mg<sub>2</sub>Zn<sub>11</sub> ($D8_{c}$) Structure",
                "Pearsons Symbol": "cP39",
                "Prototype": "Mg2Zn11",
                "Space Group Number": 200,
                "Space Group Symbol": "$Pm\\bar{3}$",
                "Strukturbericht Designation": "$D8_{c}$",
                "aflow_prototype_id": "A2B11_cP39_200_f_aghij",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2B11_cP39_200_f_aghij.html",
                "atom_labels": ["Zn", "Mg", "Mg", "Mg", "Mg", "Mg", "Mg", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn", "Zn"],
                "atom_positions": [[0.0, 0.0, 0.0], [1.5393640259159997, 0.0, 4.2760111831], [7.012658340284, 0.0, 4.2760111831], [0.0, 4.2760111831, 1.5393640259159997], [0.0, 4.2760111831, 7.012658340284], [4.2760111831, 1.5393640259159997, 0.0], [4.2760111831, 7.012658340284, 0.0], [2.907687604508, 4.2760111831, 0.0], [5.644334761691999, 4.2760111831, 0.0], [4.2760111831, 0.0, 2.907687604508], [4.2760111831, 0.0, 5.644334761691999], [0.0, 2.907687604508, 4.2760111831], [0.0, 5.644334761691999, 4.2760111831], [2.266285927043, 4.2760111831, 4.2760111831], [6.285736439157, 4.2760111831, 4.2760111831], [4.2760111831, 4.2760111831, 2.266285927043], [4.2760111831, 4.2760111831, 6.285736439157], [4.2760111831, 2.266285927043, 4.2760111831], [4.2760111831, 6.285736439157, 4.2760111831], [2.3774622178036, 2.3774622178036, 2.3774622178036], [2.3774622178036, 6.1745601483964, 6.1745601483964], [6.1745601483964, 2.3774622178036, 6.1745601483964], [6.1745601483964, 6.1745601483964, 2.3774622178036], [6.1745601483964, 6.1745601483964, 6.1745601483964], [6.1745601483964, 2.3774622178036, 2.3774622178036], [2.3774622178036, 6.1745601483964, 2.3774622178036], [2.3774622178036, 2.3774622178036, 6.1745601483964], [0.0, 1.3426675114934, 2.1978697481134], [0.0, 7.209354854706599, 6.3541526180866], [0.0, 1.3426675114934, 6.3541526180866], [0.0, 7.209354854706599, 2.1978697481134], [1.3426675114934, 2.1978697481134, 0.0], [1.3426675114934, 6.3541526180866, 0.0], [7.209354854706599, 2.1978697481134, 0.0], [7.209354854706599, 6.3541526180866, 0.0], [2.1978697481134, 0.0, 1.3426675114934], [2.1978697481134, 0.0, 7.209354854706599], [6.3541526180866, 0.0, 7.209354854706599], [6.3541526180866, 0.0, 1.3426675114934]],
                "lattice_vectors": [[8.5520223662, 0.0, 0.0], [0.0, 8.5520223662, 0.0], [0.0, 0.0, 8.5520223662]],
                "normalized_wyckoff_matid": {"a": {"X_0": 1}, "f": {"X_1": 6}, "g": {"X_0": 6}, "h": {"X_0": 6}, "i": {"X_0": 8}, "j": {"X_0": 12}}
            }
        ],
        201: [
            {
                "Notes": "KSbO<sub>3</sub> (High&ndash;temperature) Structure",
                "Pearsons Symbol": "cP60",
                "Prototype": "KO3Sb",
                "Space Group Number": 201,
                "Space Group Symbol": "$Pn\\bar{3}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "AB3C_cP60_201_be_fh_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/AB3C_cP60_201_be_fh_g.html",
                "atom_labels": ["K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "K", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "Sb", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 4.77995839205, 4.77995839205], [4.77995839205, 0.0, 4.77995839205], [4.77995839205, 4.77995839205, 0.0], [3.7178516373364903, 3.7178516373364903, 3.7178516373364903], [3.7178516373364903, 1.06210675471351, 1.06210675471351], [1.06210675471351, 3.7178516373364903, 1.06210675471351], [1.06210675471351, 1.06210675471351, 3.7178516373364903], [5.84206514676351, 5.84206514676351, 5.84206514676351], [5.84206514676351, 8.49781002938649, 8.49781002938649], [8.49781002938649, 5.84206514676351, 8.49781002938649], [8.49781002938649, 8.49781002938649, 5.84206514676351], [5.84206514676351, 2.389979196025, 2.389979196025], [8.49781002938649, 2.389979196025, 2.389979196025], [2.389979196025, 2.389979196025, 5.84206514676351], [2.389979196025, 2.389979196025, 8.49781002938649], [2.389979196025, 5.84206514676351, 2.389979196025], [2.389979196025, 8.49781002938649, 2.389979196025], [3.7178516373364903, 7.169937588075, 7.169937588075], [1.06210675471351, 7.169937588075, 7.169937588075], [7.169937588075, 7.169937588075, 3.7178516373364903], [7.169937588075, 7.169937588075, 1.06210675471351], [7.169937588075, 3.7178516373364903, 7.169937588075], [7.169937588075, 1.06210675471351, 7.169937588075], [0.92922391141452, 7.169937588075, 2.389979196025], [3.85073448063548, 7.169937588075, 2.389979196025], [7.169937588075, 2.389979196025, 0.92922391141452], [7.169937588075, 2.389979196025, 3.85073448063548], [2.389979196025, 0.92922391141452, 7.169937588075], [2.389979196025, 3.85073448063548, 7.169937588075], [8.630692872685481, 2.389979196025, 7.169937588075], [5.7091823034645195, 2.389979196025, 7.169937588075], [2.389979196025, 7.169937588075, 8.630692872685481], [2.389979196025, 7.169937588075, 5.7091823034645195], [7.169937588075, 8.630692872685481, 2.389979196025], [7.169937588075, 5.7091823034645195, 2.389979196025], [0.37188076290148997, 0.92922391141452, 7.169937588075], [0.37188076290148997, 3.85073448063548, 7.169937588075], [4.408077629148511, 0.92922391141452, 7.169937588075], [4.408077629148511, 3.85073448063548, 7.169937588075], [0.92922391141452, 7.169937588075, 0.37188076290148997], [0.92922391141452, 7.169937588075, 4.408077629148511], [3.85073448063548, 7.169937588075, 4.408077629148511], [3.85073448063548, 7.169937588075, 0.37188076290148997], [7.169937588075, 0.37188076290148997, 0.92922391141452], [7.169937588075, 4.408077629148511, 3.85073448063548], [7.169937588075, 0.37188076290148997, 3.85073448063548], [7.169937588075, 4.408077629148511, 0.92922391141452], [9.18803602119851, 8.630692872685481, 2.389979196025], [9.18803602119851, 5.7091823034645195, 2.389979196025], [5.151839154951491, 8.630692872685481, 2.389979196025], [5.151839154951491, 5.7091823034645195, 2.389979196025], [8.630692872685481, 2.389979196025, 9.18803602119851], [8.630692872685481, 2.389979196025, 5.151839154951491], [5.7091823034645195, 2.389979196025, 5.151839154951491], [5.7091823034645195, 2.389979196025, 9.18803602119851], [2.389979196025, 9.18803602119851, 8.630692872685481], [2.389979196025, 5.151839154951491, 5.7091823034645195], [2.389979196025, 9.18803602119851, 5.7091823034645195], [2.389979196025, 5.151839154951491, 8.630692872685481]],
                "lattice_vectors": [[9.5599167841, 0.0, 0.0], [0.0, 9.5599167841, 0.0], [0.0, 0.0, 9.5599167841]],
                "normalized_wyckoff_matid": {"b": {"X_1": 1}, "e": {"X_1": 2}, "f": {"X_0": 3}, "g": {"X_2": 3}, "h": {"X_0": 6}}
            }
        ],
        202: [
            {
                "Notes": "KB<sub>6</sub>H<sub>6</sub> Structure",
                "Pearsons Symbol": "cF104",
                "Prototype": "B6H6K",
                "Space Group Number": 202,
                "Space Group Symbol": "$Fm\\bar{3}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A6B6C_cF104_202_h_h_c",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A6B6C_cF104_202_h_h_c.html",
                "atom_labels": ["K", "K", "K", "K", "K", "K", "K", "K", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"],
                "atom_positions": [[2.6525074167, 2.6525074167, 2.6525074167], [2.6525074167, 7.957522250099999, 7.957522250099999], [7.957522250099999, 2.6525074167, 7.957522250099999], [7.957522250099999, 7.957522250099999, 2.6525074167], [7.957522250099999, 7.957522250099999, 7.957522250099999], [7.957522250099999, 2.6525074167, 2.6525074167], [2.6525074167, 7.957522250099999, 2.6525074167], [2.6525074167, 2.6525074167, 7.957522250099999], [0.0, 6.182464286844359, 6.74691786511812], [0.0, 4.42756537995564, 3.8631118016818795], [0.0, 6.182464286844359, 3.8631118016818795], [0.0, 4.42756537995564, 6.74691786511812], [6.182464286844359, 6.74691786511812, 0.0], [6.182464286844359, 3.8631118016818795, 0.0], [4.42756537995564, 6.74691786511812, 0.0], [4.42756537995564, 3.8631118016818795, 0.0], [6.74691786511812, 0.0, 6.182464286844359], [6.74691786511812, 0.0, 4.42756537995564], [3.8631118016818795, 0.0, 4.42756537995564], [3.8631118016818795, 0.0, 6.182464286844359], [0.0, 0.8774494534443599, 1.441903031718119], [0.0, 9.73258021335564, 9.16812663508188], [0.0, 0.8774494534443599, 9.16812663508188], [0.0, 9.73258021335564, 1.441903031718119], [6.182464286844359, 1.441903031718119, 5.3050148334], [6.182464286844359, 9.16812663508188, 5.3050148334], [4.42756537995564, 1.441903031718119, 5.3050148334], [4.42756537995564, 9.16812663508188, 5.3050148334], [6.74691786511812, 5.3050148334, 0.8774494534443599], [6.74691786511812, 5.3050148334, 9.73258021335564], [3.8631118016818795, 5.3050148334, 9.73258021335564], [3.8631118016818795, 5.3050148334, 0.8774494534443599], [5.3050148334, 6.182464286844359, 1.441903031718119], [5.3050148334, 4.42756537995564, 9.16812663508188], [5.3050148334, 6.182464286844359, 9.16812663508188], [5.3050148334, 4.42756537995564, 1.441903031718119], [0.8774494534443599, 6.74691786511812, 5.3050148334], [0.8774494534443599, 3.8631118016818795, 5.3050148334], [9.73258021335564, 6.74691786511812, 5.3050148334], [9.73258021335564, 3.8631118016818795, 5.3050148334], [1.441903031718119, 0.0, 0.8774494534443599], [1.441903031718119, 0.0, 9.73258021335564], [9.16812663508188, 0.0, 9.73258021335564], [9.16812663508188, 0.0, 0.8774494534443599], [5.3050148334, 0.8774494534443599, 6.74691786511812], [5.3050148334, 9.73258021335564, 3.8631118016818795], [5.3050148334, 0.8774494534443599, 3.8631118016818795], [5.3050148334, 9.73258021335564, 6.74691786511812], [0.8774494534443599, 1.441903031718119, 0.0], [0.8774494534443599, 9.16812663508188, 0.0], [9.73258021335564, 1.441903031718119, 0.0], [9.73258021335564, 9.16812663508188, 0.0], [1.441903031718119, 5.3050148334, 6.182464286844359], [1.441903031718119, 5.3050148334, 4.42756537995564], [9.16812663508188, 5.3050148334, 4.42756537995564], [9.16812663508188, 5.3050148334, 6.182464286844359], [0.0, 6.769198927418399, 7.639221360095999], [0.0, 3.8408307393815995, 2.970808306704], [0.0, 6.769198927418399, 2.970808306704], [0.0, 3.8408307393815995, 7.639221360095999], [6.769198927418399, 7.639221360095999, 0.0], [6.769198927418399, 2.970808306704, 0.0], [3.8408307393815995, 7.639221360095999, 0.0], [3.8408307393815995, 2.970808306704, 0.0], [7.639221360095999, 0.0, 6.769198927418399], [7.639221360095999, 0.0, 3.8408307393815995], [2.970808306704, 0.0, 3.8408307393815995], [2.970808306704, 0.0, 6.769198927418399], [0.0, 1.4641840940183988, 2.3342065266959997], [0.0, 9.1458455727816, 8.275823140104], [0.0, 1.4641840940183988, 8.275823140104], [0.0, 9.1458455727816, 2.3342065266959997], [6.769198927418399, 2.3342065266959997, 5.3050148334], [6.769198927418399, 8.275823140104, 5.3050148334], [3.8408307393815995, 2.3342065266959997, 5.3050148334], [3.8408307393815995, 8.275823140104, 5.3050148334], [7.639221360095999, 5.3050148334, 1.4641840940183988], [7.639221360095999, 5.3050148334, 9.1458455727816], [2.970808306704, 5.3050148334, 9.1458455727816], [2.970808306704, 5.3050148334, 1.4641840940183988], [5.3050148334, 6.769198927418399, 2.3342065266959997], [5.3050148334, 3.8408307393815995, 8.275823140104], [5.3050148334, 6.769198927418399, 8.275823140104], [5.3050148334, 3.8408307393815995, 2.3342065266959997], [1.4641840940183988, 7.639221360095999, 5.3050148334], [1.4641840940183988, 2.970808306704, 5.3050148334], [9.1458455727816, 7.639221360095999, 5.3050148334], [9.1458455727816, 2.970808306704, 5.3050148334], [2.3342065266959997, 0.0, 1.4641840940183988], [2.3342065266959997, 0.0, 9.1458455727816], [8.275823140104, 0.0, 9.1458455727816], [8.275823140104, 0.0, 1.4641840940183988], [5.3050148334, 1.4641840940183988, 7.639221360095999], [5.3050148334, 9.1458455727816, 2.970808306704], [5.3050148334, 1.4641840940183988, 2.970808306704], [5.3050148334, 9.1458455727816, 7.639221360095999], [1.4641840940183988, 2.3342065266959997, 0.0], [1.4641840940183988, 8.275823140104, 0.0], [9.1458455727816, 2.3342065266959997, 0.0], [9.1458455727816, 8.275823140104, 0.0], [2.3342065266959997, 5.3050148334, 6.769198927418399], [2.3342065266959997, 5.3050148334, 3.8408307393815995], [8.275823140104, 5.3050148334, 3.8408307393815995], [8.275823140104, 5.3050148334, 6.769198927418399]],
                "lattice_vectors": [[10.6100296668, 0.0, 0.0], [0.0, 10.6100296668, 0.0], [0.0, 0.0, 10.6100296668]],
                "normalized_wyckoff_matid": {"c": {"X_2": 1}, "h": {"X_0": 6, "X_1": 6}}
            },
            {
                "Notes": "FCC C<sub>60</sub> Buckminsterfullerene Structure",
                "Pearsons Symbol": "cF240",
                "Prototype": "C",
                "Space Group Number": 202,
                "Space Group Symbol": "$Fm\\bar{3}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A_cF240_202_h2i",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A_cF240_202_h2i.html",
                "atom_labels": ["C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C"],
                "atom_positions": [[0.0, 3.55074, 0.74152], [0.0, 10.70926, 13.518479999999998], [0.0, 3.55074, 13.518479999999998], [0.0, 10.70926, 0.74152], [3.55074, 0.74152, 0.0], [3.55074, 13.518479999999998, 0.0], [10.70926, 0.74152, 0.0], [10.70926, 13.518479999999998, 0.0], [0.74152, 0.0, 3.55074], [0.74152, 0.0, 10.70926], [13.518479999999998, 0.0, 10.70926], [13.518479999999998, 0.0, 3.55074], [0.0, 10.68074, 7.87152], [0.0, 3.57926, 6.38848], [0.0, 10.68074, 6.38848], [0.0, 3.57926, 7.87152], [3.55074, 7.87152, 7.13], [3.55074, 6.38848, 7.13], [10.70926, 7.87152, 7.13], [10.70926, 6.38848, 7.13], [0.74152, 7.13, 10.68074], [0.74152, 7.13, 3.57926], [13.518479999999998, 7.13, 3.57926], [13.518479999999998, 7.13, 10.68074], [7.13, 3.55074, 7.87152], [7.13, 10.70926, 6.38848], [7.13, 3.55074, 6.38848], [7.13, 10.70926, 7.87152], [10.68074, 0.74152, 7.13], [10.68074, 13.518479999999998, 7.13], [3.57926, 0.74152, 7.13], [3.57926, 13.518479999999998, 7.13], [7.87152, 0.0, 10.68074], [7.87152, 0.0, 3.57926], [6.38848, 0.0, 3.57926], [6.38848, 0.0, 10.68074], [7.13, 10.68074, 0.74152], [7.13, 3.57926, 13.518479999999998], [7.13, 10.68074, 13.518479999999998], [7.13, 3.57926, 0.74152], [10.68074, 7.87152, 0.0], [10.68074, 6.38848, 0.0], [3.57926, 7.87152, 0.0], [3.57926, 6.38848, 0.0], [7.87152, 7.13, 3.55074], [7.87152, 7.13, 10.70926], [6.38848, 7.13, 10.70926], [6.38848, 7.13, 3.55074], [1.4972999999999999, 1.2121000000000002, 3.1372], [1.4972999999999999, 13.0479, 11.1228], [12.7627, 1.2121000000000002, 11.1228], [12.7627, 13.0479, 3.1372], [1.2121000000000002, 3.1372, 1.4972999999999999], [1.2121000000000002, 11.1228, 12.7627], [13.0479, 3.1372, 12.7627], [13.0479, 11.1228, 1.4972999999999999], [3.1372, 1.4972999999999999, 1.2121000000000002], [3.1372, 12.7627, 13.0479], [11.1228, 1.4972999999999999, 13.0479], [11.1228, 12.7627, 1.2121000000000002], [12.7627, 13.0479, 11.1228], [12.7627, 1.2121000000000002, 3.1372], [1.4972999999999999, 13.0479, 3.1372], [1.4972999999999999, 1.2121000000000002, 11.1228], [13.0479, 11.1228, 12.7627], [13.0479, 3.1372, 1.4972999999999999], [1.2121000000000002, 11.1228, 1.4972999999999999], [1.2121000000000002, 3.1372, 12.7627], [11.1228, 12.7627, 13.0479], [11.1228, 1.4972999999999999, 1.2121000000000002], [3.1372, 12.7627, 1.2121000000000002], [3.1372, 1.4972999999999999, 13.0479], [1.4972999999999999, 8.342099999999999, 10.267199999999999], [1.4972999999999999, 5.9178999999999995, 3.9928000000000003], [12.7627, 8.342099999999999, 3.9928000000000003], [12.7627, 5.9178999999999995, 10.267199999999999], [1.2121000000000002, 10.267199999999999, 8.6273], [1.2121000000000002, 3.9928000000000003, 5.6327], [13.0479, 10.267199999999999, 5.6327], [13.0479, 3.9928000000000003, 8.6273], [3.1372, 8.6273, 8.342099999999999], [3.1372, 5.6327, 5.9178999999999995], [11.1228, 8.6273, 5.9178999999999995], [11.1228, 5.6327, 8.342099999999999], [12.7627, 5.9178999999999995, 3.9928000000000003], [12.7627, 8.342099999999999, 10.267199999999999], [1.4972999999999999, 5.9178999999999995, 10.267199999999999], [1.4972999999999999, 8.342099999999999, 3.9928000000000003], [13.0479, 3.9928000000000003, 5.6327], [13.0479, 10.267199999999999, 8.6273], [1.2121000000000002, 3.9928000000000003, 8.6273], [1.2121000000000002, 10.267199999999999, 5.6327], [11.1228, 5.6327, 5.9178999999999995], [11.1228, 8.6273, 8.342099999999999], [3.1372, 5.6327, 8.342099999999999], [3.1372, 8.6273, 5.9178999999999995], [8.6273, 1.2121000000000002, 10.267199999999999], [8.6273, 13.0479, 3.9928000000000003], [5.6327, 1.2121000000000002, 3.9928000000000003], [5.6327, 13.0479, 10.267199999999999], [8.342099999999999, 3.1372, 8.6273], [8.342099999999999, 11.1228, 5.6327], [5.9178999999999995, 3.1372, 5.6327], [5.9178999999999995, 11.1228, 8.6273], [10.267199999999999, 1.4972999999999999, 8.342099999999999], [10.267199999999999, 12.7627, 5.9178999999999995], [3.9928000000000003, 1.4972999999999999, 5.9178999999999995], [3.9928000000000003, 12.7627, 8.342099999999999], [5.6327, 13.0479, 3.9928000000000003], [5.6327, 1.2121000000000002, 10.267199999999999], [8.6273, 13.0479, 10.267199999999999], [8.6273, 1.2121000000000002, 3.9928000000000003], [5.9178999999999995, 11.1228, 5.6327], [5.9178999999999995, 3.1372, 8.6273], [8.342099999999999, 11.1228, 8.6273], [8.342099999999999, 3.1372, 5.6327], [3.9928000000000003, 12.7627, 5.9178999999999995], [3.9928000000000003, 1.4972999999999999, 8.342099999999999], [10.267199999999999, 12.7627, 8.342099999999999], [10.267199999999999, 1.4972999999999999, 5.9178999999999995], [8.6273, 8.342099999999999, 3.1372], [8.6273, 5.9178999999999995, 11.1228], [5.6327, 8.342099999999999, 11.1228], [5.6327, 5.9178999999999995, 3.1372], [8.342099999999999, 10.267199999999999, 1.4972999999999999], [8.342099999999999, 3.9928000000000003, 12.7627], [5.9178999999999995, 10.267199999999999, 12.7627], [5.9178999999999995, 3.9928000000000003, 1.4972999999999999], [10.267199999999999, 8.6273, 1.2121000000000002], [10.267199999999999, 5.6327, 13.0479], [3.9928000000000003, 8.6273, 13.0479], [3.9928000000000003, 5.6327, 1.2121000000000002], [5.6327, 5.9178999999999995, 11.1228], [5.6327, 8.342099999999999, 3.1372], [8.6273, 5.9178999999999995, 3.1372], [8.6273, 8.342099999999999, 11.1228], [5.9178999999999995, 3.9928000000000003, 12.7627], [5.9178999999999995, 10.267199999999999, 1.4972999999999999], [8.342099999999999, 3.9928000000000003, 1.4972999999999999], [8.342099999999999, 10.267199999999999, 12.7627], [3.9928000000000003, 5.6327, 13.0479], [3.9928000000000003, 8.6273, 1.2121000000000002], [10.267199999999999, 5.6327, 1.2121000000000002], [10.267199999999999, 8.6273, 13.0479], [2.6381, 0.74152, 2.3529], [2.6381, 13.518479999999998, 11.9071], [11.621899999999998, 0.74152, 11.9071], [11.621899999999998, 13.518479999999998, 2.3529], [0.74152, 2.3529, 2.6381], [0.74152, 11.9071, 11.621899999999998], [13.518479999999998, 2.3529, 11.621899999999998], [13.518479999999998, 11.9071, 2.6381], [2.3529, 2.6381, 0.74152], [2.3529, 11.621899999999998, 13.518479999999998], [11.9071, 2.6381, 13.518479999999998], [11.9071, 11.621899999999998, 0.74152], [11.621899999999998, 13.518479999999998, 11.9071], [11.621899999999998, 0.74152, 2.3529], [2.6381, 13.518479999999998, 2.3529], [2.6381, 0.74152, 11.9071], [13.518479999999998, 11.9071, 11.621899999999998], [13.518479999999998, 2.3529, 2.6381], [0.74152, 11.9071, 2.6381], [0.74152, 2.3529, 11.621899999999998], [11.9071, 11.621899999999998, 13.518479999999998], [11.9071, 2.6381, 0.74152], [2.3529, 11.621899999999998, 0.74152], [2.3529, 2.6381, 13.518479999999998], [2.6381, 7.87152, 9.4829], [2.6381, 6.38848, 4.777099999999999], [11.621899999999998, 7.87152, 4.777099999999999], [11.621899999999998, 6.38848, 9.4829], [0.74152, 9.4829, 9.7681], [0.74152, 4.777099999999999, 4.4919], [13.518479999999998, 9.4829, 4.4919], [13.518479999999998, 4.777099999999999, 9.7681], [2.3529, 9.7681, 7.87152], [2.3529, 4.4919, 6.38848], [11.9071, 9.7681, 6.38848], [11.9071, 4.4919, 7.87152], [11.621899999999998, 6.38848, 4.777099999999999], [11.621899999999998, 7.87152, 9.4829], [2.6381, 6.38848, 9.4829], [2.6381, 7.87152, 4.777099999999999], [13.518479999999998, 4.777099999999999, 4.4919], [13.518479999999998, 9.4829, 9.7681], [0.74152, 4.777099999999999, 9.7681], [0.74152, 9.4829, 4.4919], [11.9071, 4.4919, 6.38848], [11.9071, 9.7681, 7.87152], [2.3529, 4.4919, 7.87152], [2.3529, 9.7681, 6.38848], [9.7681, 0.74152, 9.4829], [9.7681, 13.518479999999998, 4.777099999999999], [4.4919, 0.74152, 4.777099999999999], [4.4919, 13.518479999999998, 9.4829], [7.87152, 2.3529, 9.7681], [7.87152, 11.9071, 4.4919], [6.38848, 2.3529, 4.4919], [6.38848, 11.9071, 9.7681], [9.4829, 2.6381, 7.87152], [9.4829, 11.621899999999998, 6.38848], [4.777099999999999, 2.6381, 6.38848], [4.777099999999999, 11.621899999999998, 7.87152], [4.4919, 13.518479999999998, 4.777099999999999], [4.4919, 0.74152, 9.4829], [9.7681, 13.518479999999998, 9.4829], [9.7681, 0.74152, 4.777099999999999], [6.38848, 11.9071, 4.4919], [6.38848, 2.3529, 9.7681], [7.87152, 11.9071, 9.7681], [7.87152, 2.3529, 4.4919], [4.777099999999999, 11.621899999999998, 6.38848], [4.777099999999999, 2.6381, 7.87152], [9.4829, 11.621899999999998, 7.87152], [9.4829, 2.6381, 6.38848], [9.7681, 7.87152, 2.3529], [9.7681, 6.38848, 11.9071], [4.4919, 7.87152, 11.9071], [4.4919, 6.38848, 2.3529], [7.87152, 9.4829, 2.6381], [7.87152, 4.777099999999999, 11.621899999999998], [6.38848, 9.4829, 11.621899999999998], [6.38848, 4.777099999999999, 2.6381], [9.4829, 9.7681, 0.74152], [9.4829, 4.4919, 13.518479999999998], [4.777099999999999, 9.7681, 13.518479999999998], [4.777099999999999, 4.4919, 0.74152], [4.4919, 6.38848, 11.9071], [4.4919, 7.87152, 2.3529], [9.7681, 6.38848, 2.3529], [9.7681, 7.87152, 11.9071], [6.38848, 4.777099999999999, 11.621899999999998], [6.38848, 9.4829, 2.6381], [7.87152, 4.777099999999999, 2.6381], [7.87152, 9.4829, 11.621899999999998], [4.777099999999999, 4.4919, 13.518479999999998], [4.777099999999999, 9.7681, 0.74152], [9.4829, 4.4919, 0.74152], [9.4829, 9.7681, 13.518479999999998]],
                "lattice_vectors": [[14.26, 0.0, 0.0], [0.0, 14.26, 0.0], [0.0, 0.0, 14.26]],
                "normalized_wyckoff_matid": {"h": {"X_0": 1}, "i": {"X_0": 4}}
            }
        ],
        203: [
            {
                "Notes": "Pyrochlore (Na<sub>3</sub>Co(CO<sub>3</sub>)<sub>2</sub>Cl) Structure",
                "Pearsons Symbol": "cF208",
                "Prototype": "CClCo(Na3O3)2",
                "Space Group Number": 203,
                "Space Group Symbol": "$Fd\\bar{3}$",
                "Strukturbericht Designation": "None",
                "aflow_prototype_id": "A2BCD3E6_cF208_203_e_c_d_f_g",
                "aflow_prototype_url": "http://www.aflowlib.org/CrystalDatabase/A2BCD3E6_cF208_203_e_c_d_f_g.html",
                "atom_labels": ["Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Cl", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "Co", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "Na", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"],
                "atom_positions": [[0.0, 0.0, 0.0], [0.0, 10.49235, 10.49235], [10.49235, 0.0, 10.49235], [10.49235, 10.49235, 0.0], [0.0, 3.49745, 3.49745], [3.49745, 0.0, 3.49745], [3.49745, 3.49745, 0.0], [0.0, 6.9949, 6.9949], [10.49235, 6.9949, 3.49745], [10.49235, 3.49745, 6.9949], [3.49745, 6.9949, 10.49235], [3.49745, 10.49235, 6.9949], [6.9949, 0.0, 6.9949], [6.9949, 10.49235, 3.49745], [6.9949, 3.49745, 10.49235], [6.9949, 6.9949, 0.0], [6.9949, 6.9949, 6.9949], [6.9949, 3.49745, 3.49745], [3.49745, 6.9949, 3.49745], [3.49745, 3.49745, 6.9949], [6.9949, 10.49235, 10.49235], [10.49235, 6.9949, 10.49235], [10.49235, 10.49235, 6.9949], [6.9949, 0.0, 0.0], [3.49745, 0.0, 10.49235], [3.49745, 10.49235, 0.0], [10.49235, 0.0, 3.49745], [10.49235, 3.49745, 0.0], [0.0, 6.9949, 0.0], [0.0, 3.49745, 10.49235], [0.0, 10.49235, 3.49745], [0.0, 0.0, 6.9949], [3.9535174800000004, 3.9535174800000004, 3.9535174800000004], [3.9535174800000004, 6.53883252, 6.53883252], [6.53883252, 3.9535174800000004, 6.53883252], [6.53883252, 6.53883252, 3.9535174800000004], [10.03628252, 10.03628252, 10.03628252], [10.03628252, 7.45096748, 7.45096748], [7.45096748, 10.03628252, 7.45096748], [7.45096748, 7.45096748, 10.03628252], [3.9535174800000004, 10.94841748, 10.94841748], [3.9535174800000004, 13.533732520000001, 13.533732520000001], [6.53883252, 10.94841748, 13.533732520000001], [6.53883252, 13.533732520000001, 10.94841748], [10.03628252, 3.04138252, 3.04138252], [10.03628252, 0.45606747999999947, 0.45606747999999947], [7.45096748, 3.04138252, 0.45606747999999947], [7.45096748, 0.45606747999999947, 3.04138252], [10.94841748, 3.9535174800000004, 10.94841748], [10.94841748, 6.53883252, 13.533732520000001], [13.533732520000001, 3.9535174800000004, 13.533732520000001], [13.533732520000001, 6.53883252, 10.94841748], [3.04138252, 10.03628252, 3.04138252], [3.04138252, 7.45096748, 0.45606747999999947], [0.45606747999999947, 10.03628252, 0.45606747999999947], [0.45606747999999947, 7.45096748, 3.04138252], [1