"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lib_1 = require("../lib");
describe('Docker image asset', () => {
    test('valid input', () => {
        expect(() => {
            lib_1.AssetManifestSchema.validate({
                version: lib_1.AssetManifestSchema.currentVersion(),
                dockerImages: {
                    asset: {
                        source: {
                            directory: '.',
                        },
                        destinations: {
                            dest: {
                                region: 'us-north-20',
                                repositoryName: 'REPO',
                                imageTag: 'TAG',
                            },
                        },
                    },
                },
            });
        }).not.toThrow();
    });
    test('invalid input', () => {
        expect(() => {
            lib_1.AssetManifestSchema.validate({
                version: lib_1.AssetManifestSchema.currentVersion(),
                dockerImages: {
                    asset: {
                        source: {},
                        destinations: {},
                    },
                },
            });
        }).toThrow(/dockerImages: source: Expected key 'directory' missing/);
    });
});
describe('File asset', () => {
    describe('valid input', () => {
        test('without packaging', () => {
            expect(() => {
                lib_1.AssetManifestSchema.validate({
                    version: lib_1.AssetManifestSchema.currentVersion(),
                    files: {
                        asset: {
                            source: {
                                path: 'a/b/c',
                            },
                            destinations: {
                                dest: {
                                    region: 'us-north-20',
                                    bucketName: 'Bouquet',
                                    objectKey: 'key',
                                },
                            },
                        },
                    },
                });
            }).not.toThrow();
        });
        for (const packaging of Object.values(lib_1.FileAssetPackaging)) {
            test(`with "${packaging}" packaging`, () => {
                expect(() => {
                    lib_1.AssetManifestSchema.validate({
                        version: lib_1.AssetManifestSchema.currentVersion(),
                        files: {
                            asset: {
                                source: {
                                    path: 'a/b/c',
                                    packaging,
                                },
                                destinations: {
                                    dest: {
                                        region: 'us-north-20',
                                        bucketName: 'Bouquet',
                                        objectKey: 'key',
                                    },
                                },
                            },
                        },
                    });
                }).not.toThrow();
            });
        }
    });
    describe('invalid input', () => {
        test('bad "source.path" property', () => {
            expect(() => {
                lib_1.AssetManifestSchema.validate({
                    version: lib_1.AssetManifestSchema.currentVersion(),
                    files: {
                        asset: {
                            source: {
                                path: 3,
                            },
                            destinations: {
                                dest: {
                                    region: 'us-north-20',
                                    bucketName: 'Bouquet',
                                    objectKey: 'key',
                                },
                            },
                        },
                    },
                });
            }).toThrow(/Expected a string, got '3'/);
        });
        test('bad "source.packaging" property', () => {
            expect(() => {
                lib_1.AssetManifestSchema.validate({
                    version: lib_1.AssetManifestSchema.currentVersion(),
                    files: {
                        asset: {
                            source: {
                                path: 'a/b/c',
                                packaging: 'BLACK_HOLE',
                            },
                            destinations: {
                                dest: {
                                    region: 'us-north-20',
                                    bucketName: 'Bouquet',
                                    objectKey: 'key',
                                },
                            },
                        },
                    },
                });
            }).toThrow(/Expected a FileAssetPackaging \(one of [^)]+\), got 'BLACK_HOLE'/);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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