"""AMBER force-field parameters"""

atoms_per_residue = {
    "GLH": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "HG2",
        "HG3",
        "CD",
        "OE1",
        "OE2",
        "HE2",
        "C",
        "O",
    ],
    "ILE": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB",
        "CG2",
        "HG21",
        "HG22",
        "HG23",
        "CG1",
        "HG12",
        "HG13",
        "CD1",
        "HD11",
        "HD12",
        "HD13",
        "C",
        "O",
    ],
    "DTN": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "C7",
        "H71",
        "H72",
        "H73",
        "C4",
        "O4",
        "N3",
        "H3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
        "H3T",
    ],
    "GLN": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "HG2",
        "HG3",
        "CD",
        "OE1",
        "NE2",
        "HE21",
        "HE22",
        "C",
        "O",
    ],
    "DG": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "O6",
        "N1",
        "H1",
        "C2",
        "N2",
        "H21",
        "H22",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
    ],
    "DA3": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "N6",
        "H61",
        "H62",
        "N1",
        "C2",
        "H2",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
        "H3T",
    ],
    "DC": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "H5",
        "C4",
        "N4",
        "H41",
        "H42",
        "N3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
    ],
    "DA": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "N6",
        "H61",
        "H62",
        "N1",
        "C2",
        "H2",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
    ],
    "GLY": ["N", "H", "CA", "HA2", "HA3", "C", "O"],
    "RCN": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "H5",
        "C4",
        "N4",
        "H41",
        "H42",
        "N3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
        "H3T",
    ],
    "HIP": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "ND1",
        "HD1",
        "CE1",
        "HE1",
        "NE2",
        "HE2",
        "CD2",
        "HD2",
        "C",
        "O",
    ],
    "TYR": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "CD1",
        "HD1",
        "CE1",
        "HE1",
        "CZ",
        "OH",
        "HH",
        "CE2",
        "HE2",
        "CD2",
        "HD2",
        "C",
        "O",
    ],
    "RU3": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "H5",
        "C4",
        "O4",
        "N3",
        "H3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
        "H3T",
    ],
    "DT": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "C7",
        "H71",
        "H72",
        "H73",
        "C4",
        "O4",
        "N3",
        "H3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
    ],
    "ALA": ["N", "H", "CA", "HA", "CB", "HB1", "HB2", "HB3", "C", "O"],
    "GLU": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "HG2",
        "HG3",
        "CD",
        "OE1",
        "OE2",
        "C",
        "O",
    ],
    "RGN": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "O6",
        "N1",
        "H1",
        "C2",
        "N2",
        "H21",
        "H22",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
        "H3T",
    ],
    "RU5": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "H5",
        "C4",
        "O4",
        "N3",
        "H3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
    ],
    "DCN": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "H5",
        "C4",
        "N4",
        "H41",
        "H42",
        "N3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
        "H3T",
    ],
    "RU": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "H5",
        "C4",
        "O4",
        "N3",
        "H3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
    ],
    "ASP": ["N", "H", "CA", "HA", "CB", "HB2", "HB3", "CG", "OD1", "OD2", "C", "O"],
    "SER": ["N", "H", "CA", "HA", "CB", "HB2", "HB3", "OG", "HG", "C", "O"],
    "LYS": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "HG2",
        "HG3",
        "CD",
        "HD2",
        "HD3",
        "CE",
        "HE2",
        "HE3",
        "NZ",
        "HZ1",
        "HZ2",
        "HZ3",
        "C",
        "O",
    ],
    "RAN": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "N6",
        "H61",
        "H62",
        "N1",
        "C2",
        "H2",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
        "H3T",
    ],
    "DAN": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "N6",
        "H61",
        "H62",
        "N1",
        "C2",
        "H2",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
        "H3T",
    ],
    "CYX": ["N", "H", "CA", "HA", "CB", "HB2", "HB3", "SG", "C", "O"],
    "DGN": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "O6",
        "N1",
        "H1",
        "C2",
        "N2",
        "H21",
        "H22",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
        "H3T",
    ],
    "RG": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "O6",
        "N1",
        "H1",
        "C2",
        "N2",
        "H21",
        "H22",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
    ],
    "HID": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "ND1",
        "HD1",
        "CE1",
        "HE1",
        "NE2",
        "CD2",
        "HD2",
        "C",
        "O",
    ],
    "RA": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "N6",
        "H61",
        "H62",
        "N1",
        "C2",
        "H2",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
    ],
    "RC": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "H5",
        "C4",
        "N4",
        "H41",
        "H42",
        "N3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
    ],
    "LYN": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "HG2",
        "HG3",
        "CD",
        "HD2",
        "HD3",
        "CE",
        "HE2",
        "HE3",
        "NZ",
        "HZ2",
        "HZ3",
        "C",
        "O",
    ],
    "ASH": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "OD1",
        "OD2",
        "HD2",
        "C",
        "O",
    ],
    "ASN": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "OD1",
        "ND2",
        "HD21",
        "HD22",
        "C",
        "O",
    ],
    "CYM": ["N", "HN", "CA", "HA", "CB", "HB3", "HB2", "SG", "C", "O"],
    "HIE": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "ND1",
        "CE1",
        "HE1",
        "NE2",
        "HE2",
        "CD2",
        "HD2",
        "C",
        "O",
    ],
    "CYS": ["N", "H", "CA", "HA", "CB", "HB2", "HB3", "SG", "HG", "C", "O"],
    "VAL": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB",
        "CG1",
        "HG11",
        "HG12",
        "HG13",
        "CG2",
        "HG21",
        "HG22",
        "HG23",
        "C",
        "O",
    ],
    "THR": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB",
        "CG2",
        "HG21",
        "HG22",
        "HG23",
        "OG1",
        "HG1",
        "C",
        "O",
    ],
    "DG3": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "O6",
        "N1",
        "H1",
        "C2",
        "N2",
        "H21",
        "H22",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
        "H3T",
    ],
    "RA5": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "N6",
        "H61",
        "H62",
        "N1",
        "C2",
        "H2",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
    ],
    "RA3": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "N6",
        "H61",
        "H62",
        "N1",
        "C2",
        "H2",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
        "H3T",
    ],
    "DG5": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "O6",
        "N1",
        "H1",
        "C2",
        "N2",
        "H21",
        "H22",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
    ],
    "TRP": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "CD1",
        "HD1",
        "NE1",
        "HE1",
        "CE2",
        "CZ2",
        "HZ2",
        "CH2",
        "HH2",
        "CZ3",
        "HZ3",
        "CE3",
        "HE3",
        "CD2",
        "C",
        "O",
    ],
    "DC5": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "H5",
        "C4",
        "N4",
        "H41",
        "H42",
        "N3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
    ],
    "DC3": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "H5",
        "C4",
        "N4",
        "H41",
        "H42",
        "N3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
        "H3T",
    ],
    "RG3": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "O6",
        "N1",
        "H1",
        "C2",
        "N2",
        "H21",
        "H22",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
        "H3T",
    ],
    "RUN": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "H5",
        "C4",
        "O4",
        "N3",
        "H3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
        "H3T",
    ],
    "RG5": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "O6",
        "N1",
        "H1",
        "C2",
        "N2",
        "H21",
        "H22",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
    ],
    "DA5": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N9",
        "C8",
        "H8",
        "N7",
        "C5",
        "C6",
        "N6",
        "H61",
        "H62",
        "N1",
        "C2",
        "H2",
        "N3",
        "C4",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
    ],
    "RC5": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "H5",
        "C4",
        "N4",
        "H41",
        "H42",
        "N3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
    ],
    "PHE": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "CD1",
        "HD1",
        "CE1",
        "HE1",
        "CZ",
        "HZ",
        "CE2",
        "HE2",
        "CD2",
        "HD2",
        "C",
        "O",
    ],
    "RC3": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "H5",
        "C4",
        "N4",
        "H41",
        "H42",
        "N3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "O2'",
        "HO'2",
        "O3'",
        "H3T",
    ],
    "MET": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "HG2",
        "HG3",
        "SD",
        "CE",
        "HE1",
        "HE2",
        "HE3",
        "C",
        "O",
    ],
    "LEU": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "HG",
        "CD1",
        "HD11",
        "HD12",
        "HD13",
        "CD2",
        "HD21",
        "HD22",
        "HD23",
        "C",
        "O",
    ],
    "ARG": [
        "N",
        "H",
        "CA",
        "HA",
        "CB",
        "HB2",
        "HB3",
        "CG",
        "HG2",
        "HG3",
        "CD",
        "HD2",
        "HD3",
        "NE",
        "HE",
        "CZ",
        "NH1",
        "HH11",
        "HH12",
        "NH2",
        "HH21",
        "HH22",
        "C",
        "O",
    ],
    "DT3": [
        "P",
        "O1P",
        "O2P",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "C7",
        "H71",
        "H72",
        "H73",
        "C4",
        "O4",
        "N3",
        "H3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
        "H3T",
    ],
    "PRO": [
        "N",
        "CD",
        "HD2",
        "HD3",
        "CG",
        "HG2",
        "HG3",
        "CB",
        "HB2",
        "HB3",
        "CA",
        "HA",
        "C",
        "O",
    ],
    "DT5": [
        "H5T",
        "O5'",
        "C5'",
        "H5'1",
        "H5'2",
        "C4'",
        "H4'",
        "O4'",
        "C1'",
        "H1'",
        "N1",
        "C6",
        "H6",
        "C5",
        "C7",
        "H71",
        "H72",
        "H73",
        "C4",
        "O4",
        "N3",
        "H3",
        "C2",
        "O2",
        "C3'",
        "H3'",
        "C2'",
        "H2'1",
        "H2'2",
        "O3'",
    ],
}

charges = {
    "DC3-H3T": 0.4396,
    "RGN-O2'": -0.6139,
    "RAN-H5T": 0.4295,
    "RU-C4'": 0.1065,
    "DT-C3'": 0.0713,
    "RAN-C2'": 0.067,
    "RU-O4'": -0.3548,
    "DTN-H2'1": 0.0718,
    "DTN-H2'2": 0.0718,
    "LYS-HB2": 0.0362,
    "DG3-H2'1": 0.0718,
    "DG3-H2'2": 0.0718,
    "ILE-HG23": 0.0882,
    "HID-NE2": -0.5727,
    "GLU-CD": 0.8054,
    "GLU-CG": 0.0136,
    "GLU-CA": 0.0397,
    "GLU-CB": 0.056,
    "DC3-H3'": 0.0985,
    "DT-H3": 0.342,
    "DG-O1P": -0.7761,
    "DA5-H1'": 0.1838,
    "RC5-O2'": -0.6139,
    "DCN-C2": 0.7959,
    "DCN-C6": -0.0183,
    "DCN-C5": -0.5222,
    "DCN-C4": 0.8439,
    "CYX-CB": -0.079,
    "HIE-ND1": -0.5432,
    "CYX-CA": 0.0429,
    "RU3-C2": 0.4687,
    "RCN-O4'": -0.3548,
    "SER-HB2": 0.0352,
    "SER-HB3": 0.0352,
    "DC5-N4": -0.9773,
    "DC5-N1": -0.0339,
    "DC5-N3": -0.7748,
    "RC5-H5T": 0.4295,
    "DCN-C1'": -0.0116,
    "GLU-HG2": -0.0425,
    "RA5-C5'": 0.0558,
    "RGN-N7": -0.5709,
    "RGN-N2": -0.9672,
    "RGN-N3": -0.6323,
    "RGN-N1": -0.4787,
    "RGN-N9": 0.0492,
    "RUN-O2": -0.5477,
    "DT5-H6": 0.2607,
    "DT5-H3": 0.342,
    "RG5-O3'": -0.5246,
    "RA3-O1P": -0.776,
    "DTN-C2'": -0.0854,
    "DTN-H5T": 0.4422,
    "TYR-HE2": 0.1656,
    "TYR-HE1": 0.1656,
    "RCN-C5": -0.5215,
    "RCN-C4": 0.8185,
    "RCN-C6": 0.0053,
    "RCN-C2": 0.7538,
    "CYM-HB3": 0.1122,
    "CYM-HB2": 0.1122,
    "RA3-HO'2": 0.4186,
    "DC3-C1'": -0.0116,
    "DT5-H2'1": 0.0718,
    "DT5-H2'2": 0.0718,
    "RU3-O4": -0.5761,
    "DT3-C2'": -0.0854,
    "RU3-O2": -0.5477,
    "VAL-HA": 0.0969,
    "VAL-HB": -0.0297,
    "PRO-HA": 0.0641,
    "DG5-H5T": 0.4422,
    "RG5-C5'": 0.0558,
    "DA-O5'": -0.4954,
    "RG3-C1'": 0.0191,
    "RU-HO'2": 0.4186,
    "DG5-N1": -0.5053,
    "DG5-N3": -0.6636,
    "DG5-N2": -0.923,
    "DG5-N7": -0.5725,
    "DG5-N9": 0.0577,
    "RUN-C1'": 0.0674,
    "RA5-O5'": -0.6223,
    "RCN-C4'": 0.1065,
    "DA5-N9": -0.0268,
    "DG3-C6": 0.4918,
    "DA5-N3": -0.7417,
    "DA5-N1": -0.7624,
    "DA5-N7": -0.6175,
    "DA5-N6": -0.9123,
    "RG-P": 1.1662,
    "ILE-HG21": 0.0882,
    "ILE-HG22": 0.0882,
    "RC3-H5'1": 0.0679,
    "RC3-H5'2": 0.0679,
    "DA-H2": 0.0598,
    "DA-H8": 0.1877,
    "RAN-H61": 0.4115,
    "RAN-H62": 0.4115,
    "DAN-N3": -0.7417,
    "DAN-N1": -0.7624,
    "DAN-N6": -0.9123,
    "DAN-N7": -0.6175,
    "RC3-H1'": 0.2029,
    "LYS-HE2": 0.1135,
    "RU-C2": 0.4687,
    "DAN-N9": -0.0268,
    "RU-C4": 0.5952,
    "RU-C5": -0.3635,
    "RU-C6": -0.1126,
    "RC5-H42": 0.4234,
    "RC5-H41": 0.4234,
    "DA-C5'": -0.0069,
    "RC5-O3'": -0.5246,
    "RC5-H4'": 0.1174,
    "RA-H1'": 0.2007,
    "RU3-O4'": -0.3548,
    "MET-HE1": 0.0684,
    "DG-H1'": 0.1746,
    "MET-HE2": 0.0684,
    "RCN-O3'": -0.6541,
    "ARG-NE": -0.5295,
    "DT-H6": 0.2607,
    "DCN-H42": 0.4314,
    "DA5-H2'2": 0.0718,
    "DC-C1'": -0.0116,
    "RAN-H2'1": 0.0972,
    "RGN-O6": -0.5597,
    "RU3-H5'2": 0.0679,
    "RU3-H5'1": 0.0679,
    "DT3-C1'": 0.068,
    "RA-N7": -0.6073,
    "DCN-N1": -0.0339,
    "DCN-N3": -0.7748,
    "DCN-N4": -0.9773,
    "RA-N1": -0.7615,
    "DTN-C3'": 0.0713,
    "RA-N9": -0.0251,
    "LEU-CG": 0.3531,
    "LEU-CA": -0.0518,
    "LEU-CB": -0.1102,
    "HIP-HB3": 0.081,
    "HIP-HB2": 0.081,
    "DTN-H4'": 0.1176,
    "RG3-O6": -0.5597,
    "ASN-ND2": -0.9191,
    "DT-H4'": 0.1176,
    "DC5-H1'": 0.1963,
    "DG5-H4'": 0.1176,
    "RU3-N3": -0.3549,
    "RU3-N1": 0.0418,
    "DGN-C3'": 0.0713,
    "DA-O4'": -0.3691,
    "RG3-C2'": 0.067,
    "RU3-P": 1.1662,
    "THR-HG23": 0.0642,
    "THR-HG21": 0.0642,
    "LYS-C": 0.7341,
    "LYS-N": -0.3479,
    "LYS-O": -0.5894,
    "LYS-H": 0.2747,
    "DG3-O1P": -0.7761,
    "DAN-H1'": 0.1838,
    "DA5-C2": 0.5716,
    "DA5-C4": 0.38,
    "DA5-C5": 0.0725,
    "DA5-C6": 0.6897,
    "DA5-C8": 0.1607,
    "RC3-O1P": -0.776,
    "ASP-HB2": -0.0122,
    "ASP-HB3": -0.0122,
    "RC-N3": -0.7584,
    "DC3-H1'": 0.1963,
    "RG5-H5T": 0.4295,
    "LYS-HD2": 0.0621,
    "LYS-HD3": 0.0621,
    "DG5-C6": 0.4918,
    "DG5-C4": 0.1814,
    "CYM-CB": -0.2413,
    "DG5-C2": 0.7432,
    "DG5-C8": 0.0736,
    "DT5-C5": 0.0025,
    "DTN-C4": 0.5194,
    "DTN-C5": 0.0025,
    "DTN-C6": -0.2209,
    "DT5-C6": -0.2209,
    "DTN-C2": 0.5677,
    "RU-H5'2": 0.0679,
    "RU-H5'1": 0.0679,
    "DG-H21": 0.4235,
    "DG-H22": 0.4235,
    "DA3-H1'": 0.1838,
    "ILE-HD12": 0.0186,
    "ILE-HD13": 0.0186,
    "ILE-HD11": 0.0186,
    "RU5-H1'": 0.1824,
    "DG-C3'": 0.0713,
    "RA5-N9": -0.0251,
    "RU3-O5'": -0.4989,
    "RA5-N7": -0.6073,
    "RA5-N6": -0.9019,
    "RA5-N1": -0.7615,
    "RA5-N3": -0.6997,
    "RCN-O2'": -0.6139,
    "RC-H5'1": 0.0679,
    "RC-H5'2": 0.0679,
    "HIE-CD2": -0.2207,
    "HIP-CB": -0.0414,
    "HIP-CA": -0.1354,
    "HIP-CG": -0.0012,
    "RU-N3": -0.3549,
    "RU-N1": 0.0418,
    "DG-O3'": -0.5232,
    "DCN-C3'": 0.0713,
    "DA-P": 1.1659,
    "DTN-H3T": 0.4396,
    "DG3-C4'": 0.1629,
    "RU-H3'": 0.0615,
    "ARG-CZ": 0.8076,
    "ARG-CG": 0.039,
    "DA-H3'": 0.0985,
    "ARG-CB": -0.0007,
    "ARG-CA": -0.2637,
    "GLU-HG3": -0.0425,
    "DCN-O2": -0.6548,
    "DCN-H4'": 0.1176,
    "DA5-H2'1": 0.0718,
    "DCN-H41": 0.4314,
    "TRP-HZ3": 0.1447,
    "DTN-H3'": 0.0985,
    "DG5-H5'1": 0.0754,
    "DG5-H5'2": 0.0754,
    "RG3-N9": 0.0492,
    "LYN-HZ3": 0.38604,
    "LYN-HZ2": 0.38604,
    "RG3-N7": -0.5709,
    "RG3-N1": -0.4787,
    "RG3-N3": -0.6323,
    "RG3-N2": -0.9672,
    "DC3-H2'1": 0.0718,
    "DC3-H2'2": 0.0718,
    "TRP-CD2": 0.1243,
    "DT-H71": 0.077,
    "DT-H72": 0.077,
    "DT-H73": 0.077,
    "DA3-O3'": -0.6549,
    "RGN-H21": 0.4364,
    "ASP-HA": 0.088,
    "ARG-HB2": 0.0327,
    "ARG-HB3": 0.0327,
    "RU3-HO'2": 0.4186,
    "DC5-O3'": -0.5232,
    "DT3-H72": 0.077,
    "DT3-H73": 0.077,
    "RCN-HO'2": 0.4186,
    "DT3-H71": 0.077,
    "DG3-O6": -0.5699,
    "DGN-C2'": -0.0854,
    "TRP-HH2": 0.1417,
    "RG3-C3'": 0.2022,
    "RC-C5'": 0.0558,
    "RUN-C3'": 0.2022,
    "VAL-HG23": 0.0791,
    "VAL-HG22": 0.0791,
    "VAL-HG21": 0.0791,
    "RG-C8": 0.1374,
    "RG-C6": 0.477,
    "RG-C4": 0.1222,
    "RG-C5": 0.1744,
    "RG-C2": 0.7657,
    "GLH-H": 0.2719,
    "GLH-O": -0.5679,
    "GLH-N": -0.4157,
    "GLH-C": 0.5973,
    "RUN-O4": -0.5761,
    "RU-C1'": 0.0674,
    "RU3-C4'": 0.1065,
    "GLN-NE2": -0.9407,
    "LYS-HG3": 0.0103,
    "LYS-HG2": 0.0103,
    "HIE-HE1": 0.1435,
    "HIE-HE2": 0.3339,
    "GLN-HA": 0.085,
    "ILE-HG13": 0.0236,
    "ILE-HG12": 0.0236,
    "RC3-H3'": 0.0615,
    "RC3-O2'": -0.6139,
    "LYS-HZ1": 0.34,
    "GLN-HB3": 0.0171,
    "GLN-HB2": 0.0171,
    "DA5-H61": 0.4167,
    "DAN-C5'": -0.0069,
    "DG-H3'": 0.0985,
    "HIE-CG": 0.1868,
    "HIE-CA": -0.0581,
    "HIE-CB": -0.0074,
    "DA3-O1P": -0.7761,
    "RC3-O2P": -0.776,
    "RA-H3'": 0.0615,
    "LEU-HD11": 0.1,
    "LEU-HD12": 0.1,
    "LEU-HD13": 0.1,
    "RC3-H3T": 0.4376,
    "RG3-H2'1": 0.0972,
    "RU3-H3'": 0.0615,
    "DAN-H2'2": 0.0718,
    "RG3-HO'2": 0.4186,
    "HIE-CE1": 0.1635,
    "TYR-HB2": 0.0295,
    "DC-H5": 0.1863,
    "DC-H6": 0.2293,
    "RCN-H5'2": 0.0679,
    "RCN-H5'1": 0.0679,
    "RU-O4": -0.5761,
    "DCN-C2'": -0.0854,
    "RU-O2": -0.5477,
    "DTN-C1'": 0.068,
    "CYM-O": -0.5679,
    "CYM-N": -0.4157,
    "DG5-C5": 0.1991,
    "CYM-C": 0.5973,
    "DG-O2P": -0.7761,
    "RAN-H2": 0.0473,
    "GLY-C": 0.5973,
    "GLY-N": -0.4157,
    "GLY-O": -0.5679,
    "GLY-H": 0.2719,
    "ASH-CB": -0.0316,
    "ASH-CA": 0.0341,
    "ASH-CG": 0.6462,
    "DG3-C5'": -0.0069,
    "DCN-H6": 0.2293,
    "DCN-H5": 0.1863,
    "RG-O5'": -0.4989,
    "ASH-HB2": 0.0488,
    "ASH-HB3": 0.0488,
    "RG-C5'": 0.0558,
    "RG3-H4'": 0.1174,
    "THR-CA": -0.0389,
    "THR-CB": 0.3654,
    "RCN-H4'": 0.1174,
    "ASH-HA": 0.0864,
    "RCN-H41": 0.4234,
    "DC3-C4'": 0.1629,
    "RCN-H42": 0.4234,
    "DCN-H5T": 0.4422,
    "DC-H2'1": 0.0718,
    "DC-H2'2": 0.0718,
    "RC-C4'": 0.1065,
    "RA5-HO'2": 0.4186,
    "CYM-SG": -0.8844,
    "DC5-O4'": -0.3691,
    "VAL-C": 0.5973,
    "DG-C5'": -0.0069,
    "DG3-N9": 0.0577,
    "DG3-N3": -0.6636,
    "DG3-N2": -0.923,
    "DG3-N1": -0.5053,
    "VAL-H": 0.2719,
    "DG3-N7": -0.5725,
    "VAL-N": -0.4157,
    "DGN-C5'": -0.0069,
    "DT3-O1P": -0.7761,
    "DG5-C1'": 0.0358,
    "RUN-C2'": 0.067,
    "GLU-C": 0.5366,
    "DT-O1P": -0.7761,
    "GLU-H": 0.2936,
    "GLU-N": -0.5163,
    "GLU-O": -0.5819,
    "RU3-C5'": 0.0558,
    "DA3-O2P": -0.7761,
    "DGN-H8": 0.1997,
    "DGN-H1": 0.352,
    "DAN-O4'": -0.3691,
    "RA3-H5'2": 0.0679,
    "RA3-H5'1": 0.0679,
    "DT-C2": 0.5677,
    "CYX-HB2": 0.091,
    "CYX-HB3": 0.091,
    "RAN-H1'": 0.2007,
    "RC3-O3'": -0.6541,
    "RA3-C5'": 0.0558,
    "VAL-HG12": 0.0791,
    "VAL-HG13": 0.0791,
    "RU5-O2'": -0.6139,
    "VAL-HG11": 0.0791,
    "DAN-C4'": 0.1629,
    "DGN-O5'": -0.6318,
    "DA-C2'": -0.0854,
    "RC5-O2": -0.6252,
    "DA3-H3'": 0.0985,
    "RA-H4'": 0.1174,
    "RU5-H3'": 0.0615,
    "HIE-HD2": 0.1862,
    "DT-O5'": -0.4954,
    "RC-HO'2": 0.4186,
    "RA5-C1'": 0.0394,
    "DA3-H3T": 0.4396,
    "RC-H3'": 0.0615,
    "RC-O4'": -0.3548,
    "HID-HB3": 0.0402,
    "HID-HB2": 0.0402,
    "DA5-H5T": 0.4422,
    "RC-H5": 0.1928,
    "DC5-C4'": 0.1629,
    "DAN-C4": 0.38,
    "DAN-C6": 0.6897,
    "DAN-C2": 0.5716,
    "MET-N": -0.4157,
    "MET-O": -0.5679,
    "RU-H5": 0.1811,
    "DG-O5'": -0.4954,
    "RU-H6": 0.2188,
    "RA5-H5T": 0.4295,
    "DC-C2'": -0.0854,
    "RUN-C6": -0.1126,
    "RUN-C5": -0.3635,
    "RUN-C4": 0.5952,
    "RUN-C2": 0.4687,
    "LEU-CD1": -0.4121,
    "RA3-H61": 0.4115,
    "RA3-H62": 0.4115,
    "LEU-CD2": -0.4121,
    "DTN-O2": -0.5881,
    "DTN-O4": -0.5563,
    "DG3-C2'": -0.0854,
    "ALA-N": -0.4157,
    "ALA-O": -0.5679,
    "ALA-H": 0.2719,
    "DA-H1'": 0.1838,
    "ALA-C": 0.5973,
    "RU5-H6": 0.2188,
    "RU5-H5": 0.1811,
    "RU5-H3": 0.3154,
    "DTN-H1'": 0.1804,
    "DA-H62": 0.4167,
    "RG-C4'": 0.1065,
    "RA-O3'": -0.5246,
    "THR-HG1": 0.4102,
    "DTN-N1": -0.0239,
    "DT-O2P": -0.7761,
    "DT-H1'": 0.1804,
    "RC3-P": 1.1662,
    "DC3-C5'": -0.0069,
    "RC-C3'": 0.2022,
    "DTN-O4'": -0.3691,
    "ARG-HD2": 0.0687,
    "ARG-HD3": 0.0687,
    "RU3-C4": 0.5952,
    "RU3-C5": -0.3635,
    "RU3-C6": -0.1126,
    "DT3-H1'": 0.1804,
    "DT5-C5'": -0.0069,
    "DC-C5": -0.5222,
    "RCN-H5T": 0.4295,
    "DC5-O5'": -0.6318,
    "DG-C4'": 0.1629,
    "DG3-O4'": -0.3691,
    "DC-C2": 0.7959,
    "DGN-C4'": 0.1629,
    "DG3-C2": 0.7432,
    "DG3-C4": 0.1814,
    "DG3-C5": 0.1991,
    "DG5-C2'": -0.0854,
    "DG3-C8": 0.0736,
    "LYS-CE": -0.0143,
    "RUN-C5'": 0.0558,
    "RUN-O5'": -0.6223,
    "DT5-O5'": -0.6318,
    "ASN-C": 0.5973,
    "RU3-C2'": 0.067,
    "ASN-H": 0.2719,
    "ASN-N": -0.4157,
    "ASN-O": -0.5679,
    "DAN-O3'": -0.6549,
    "RA5-H5'1": 0.0679,
    "DA3-P": 1.1659,
    "RA5-H5'2": 0.0679,
    "DC3-O2": -0.6548,
    "DCN-H2'2": 0.0718,
    "DCN-H2'1": 0.0718,
    "DA3-H5'1": 0.0754,
    "RU-C3'": 0.2022,
    "DG3-P": 1.1659,
    "DA5-H62": 0.4167,
    "RG-H2'1": 0.0972,
    "RGN-O5'": -0.6223,
    "PHE-CZ": -0.1072,
    "PHE-CA": -0.0024,
    "PHE-CB": -0.0343,
    "RGN-H22": 0.4364,
    "PHE-CG": 0.0118,
    "RU5-O3'": -0.5246,
    "RU-H4'": 0.1174,
    "DGN-O4'": -0.3691,
    "DA-C3'": 0.0713,
    "RC5-N3": -0.7584,
    "RC5-N1": -0.0484,
    "DA-C1'": 0.0431,
    "RAN-O3'": -0.6541,
    "RC5-N4": -0.953,
    "DA5-O3'": -0.5232,
    "DA5-H4'": 0.1176,
    "TRP-CA": -0.0275,
    "TRP-CB": -0.005,
    "TRP-CG": -0.1415,
    "RA5-C2'": 0.067,
    "HIP-HA": 0.1212,
    "RC-P": 1.1662,
    "RU3-H1'": 0.1824,
    "DC-O2": -0.6548,
    "DC-O5'": -0.4954,
    "DC5-C5'": -0.0069,
    "DT-C5": 0.0025,
    "DT-C4": 0.5194,
    "DT-C7": -0.2269,
    "DT-C6": -0.2209,
    "GLU-HB2": -0.0173,
    "GLU-HB3": -0.0173,
    "DG-O4'": -0.3691,
    "DT3-C5": 0.0025,
    "VAL-CG2": -0.3192,
    "DC-C5'": -0.0069,
    "RA3-C2'": 0.067,
    "DA-H61": 0.4167,
    "DTN-N3": -0.434,
    "ILE-CD1": -0.066,
    "DG3-C3'": 0.0713,
    "DA5-O4'": -0.3691,
    "DC3-O4'": -0.3691,
    "RU5-O2": -0.5477,
    "RU5-O4": -0.5761,
    "DT3-C2": 0.5677,
    "RA-O2P": -0.776,
    "DT3-C7": -0.2269,
    "DT3-C6": -0.2209,
    "RGN-C5'": 0.0558,
    "DT3-C4": 0.5194,
    "RA-O2'": -0.6139,
    "THR-C": 0.5973,
    "THR-H": 0.2719,
    "THR-N": -0.4157,
    "THR-O": -0.5679,
    "DA-C4": 0.38,
    "DC3-H5'1": 0.0754,
    "PRO-CD": 0.0192,
    "PRO-CG": 0.0189,
    "PRO-CA": -0.0266,
    "RC-C2'": 0.067,
    "PRO-CB": -0.007,
    "DTN-O5'": -0.6318,
    "PHE-HB3": 0.0295,
    "DC-H5'2": 0.0754,
    "DC-H5'1": 0.0754,
    "DT-O3'": -0.5232,
    "DT5-C4'": 0.1629,
    "DA3-C2'": -0.0854,
    "DG3-O5'": -0.4954,
    "DAN-H5'2": 0.0754,
    "DT3-O3'": -0.6549,
    "DG5-C3'": 0.0713,
    "TRP-CH2": -0.1134,
    "RU5-H2'1": 0.0972,
    "RG-O3'": -0.5246,
    "DAN-H2'1": 0.0718,
    "ASP-CB": -0.0303,
    "ASP-CA": 0.0381,
    "ASP-CG": 0.7994,
    "LYN-HG2": 0.01041,
    "LYN-HG3": 0.01041,
    "ARG-HG3": 0.0285,
    "ARG-HG2": 0.0285,
    "DG-C2": 0.7432,
    "RUN-O4'": -0.3548,
    "DG-C4": 0.1814,
    "DT5-O4'": -0.3691,
    "DG-C6": 0.4918,
    "RU3-C3'": 0.2022,
    "DG-C8": 0.0736,
    "RA-H5'2": 0.0679,
    "RA-H5'1": 0.0679,
    "RGN-H3T": 0.4376,
    "CYS-HB3": 0.1112,
    "CYS-HB2": 0.1112,
    "RC-O5'": -0.4989,
    "DT-P": 1.1659,
    "RU-C2'": 0.067,
    "GLH-HE2": 0.4641,
    "RGN-H3'": 0.0615,
    "RGN-O4'": -0.3548,
    "GLN-HG2": 0.0352,
    "CYX-H": 0.2719,
    "CYX-N": -0.4157,
    "CYX-O": -0.5679,
    "CYX-C": 0.5973,
    "PRO-HG2": 0.0213,
    "PRO-HG3": 0.0213,
    "RAN-O2'": -0.6139,
    "LEU-HD21": 0.1,
    "LEU-HD23": 0.1,
    "LEU-HD22": 0.1,
    "RAN-H3'": 0.0615,
    "RA-H62": 0.4115,
    "RC3-H4'": 0.1174,
    "RC3-H41": 0.4234,
    "HIE-HB2": 0.0367,
    "HIE-HB3": 0.0367,
    "DC3-C4": 0.8439,
    "DC3-C5": -0.5222,
    "DC3-C6": -0.0183,
    "DC5-H6": 0.2293,
    "DC5-H5": 0.1863,
    "RU5-H5T": 0.4295,
    "RA5-C3'": 0.2022,
    "RAN-H3T": 0.4376,
    "RC5-O4'": -0.3548,
    "HID-HD2": 0.1147,
    "HID-HD1": 0.3649,
    "MET-HA": 0.088,
    "PHE-HB2": 0.0295,
    "DC3-O5'": -0.4954,
    "RGN-H1": 0.3424,
    "DTN-C4'": 0.1629,
    "RGN-H8": 0.164,
    "RA3-H4'": 0.1174,
    "DC-C4'": 0.1629,
    "RC-H1'": 0.2029,
    "RA-C5": 0.0515,
    "RA-C6": 0.7009,
    "RA-C2": 0.5875,
    "RA3-C3'": 0.2022,
    "RA-C8": 0.2006,
    "GLH-CB": -0.0071,
    "GLH-CA": 0.0145,
    "GLH-CG": -0.0174,
    "GLH-CD": 0.6801,
    "DC3-C3'": 0.0713,
    "RU5-N1": 0.0418,
    "RU5-N3": -0.3549,
    "DC-C3'": 0.0713,
    "RGN-C4'": 0.1065,
    "RG3-H5'1": 0.0679,
    "RG3-H5'2": 0.0679,
    "RC5-HO'2": 0.4186,
    "RG-O2'": -0.6139,
    "LEU-HA": 0.0922,
    "ARG-NH1": -0.8627,
    "LEU-HG": -0.0361,
    "RCN-H3'": 0.0615,
    "DT-H3'": 0.0985,
    "RC-C1'": 0.0066,
    "RG-O2P": -0.776,
    "RU3-H3T": 0.4376,
    "DT3-H3'": 0.0985,
    "RCN-H3T": 0.4376,
    "DT-O4'": -0.3691,
    "ASN-HA": 0.1048,
    "RU-O1P": -0.776,
    "DGN-H1'": 0.1746,
    "DG3-H3'": 0.0985,
    "DG5-C4'": 0.1629,
    "LYS-HE3": 0.1135,
    "RUN-C4'": 0.1065,
    "TRP-HB2": 0.0339,
    "TRP-HB3": 0.0339,
    "DC5-H3'": 0.0985,
    "LYN-HD3": 0.01155,
    "LYN-HD2": 0.01155,
    "GLY-CA": -0.0252,
    "RG3-O1P": -0.776,
    "GLN-C": 0.5973,
    "RA-O1P": -0.776,
    "GLN-H": 0.2719,
    "GLN-O": -0.5679,
    "GLN-N": -0.4157,
    "GLN-CA": -0.0031,
    "RG5-C5": 0.1744,
    "LEU-HB2": 0.0457,
    "DG3-H3T": 0.4396,
    "DT3-O2P": -0.7761,
    "RC3-C1'": 0.0066,
    "GLN-CG": -0.0645,
    "ALA-HB2": 0.0603,
    "ALA-HB3": 0.0603,
    "ALA-HB1": 0.0603,
    "PRO-HD3": 0.0391,
    "PRO-HD2": 0.0391,
    "GLU-HA": 0.1105,
    "RU-P": 1.1662,
    "RAN-O5'": -0.6223,
    "DA3-H4'": 0.1176,
    "VAL-CA": -0.0875,
    "RU5-H4'": 0.1174,
    "RAN-C5'": 0.0558,
    "VAL-CB": 0.2985,
    "RA-P": 1.1662,
    "RC5-O5'": -0.6223,
    "RA3-H3T": 0.4376,
    "HID-HE1": 0.1392,
    "DC5-H2'2": 0.0718,
    "DC5-H2'1": 0.0718,
    "DT-C4'": 0.1629,
    "DC3-O2P": -0.7761,
    "DA-H4'": 0.1176,
    "RC5-H5'2": 0.0679,
    "RC5-H5'1": 0.0679,
    "HID-CE1": 0.2057,
    "DTN-C5'": -0.0069,
    "DT-O4": -0.5563,
    "DT5-C2": 0.5677,
    "RA3-H3'": 0.0615,
    "DT5-C4": 0.5194,
    "DT5-C7": -0.2269,
    "DT-O2": -0.5881,
    "DTN-H3": 0.342,
    "DTN-H6": 0.2607,
    "DG3-C1'": 0.0358,
    "GLU-OE2": -0.8188,
    "GLU-OE1": -0.8188,
    "RUN-H5'1": 0.0679,
    "RUN-H5'2": 0.0679,
    "DT5-H3'": 0.0985,
    "DCN-H1'": 0.1963,
    "RG-O1P": -0.776,
    "ALA-HA": 0.0823,
    "DG-C5": 0.1991,
    "ILE-HB": 0.0187,
    "ILE-HA": 0.0869,
    "RGN-C3'": 0.2022,
    "TYR-HB3": 0.0295,
    "RCN-H5": 0.1928,
    "RCN-H6": 0.1958,
    "HID-CG": -0.0266,
    "HID-CB": -0.0462,
    "HID-CA": 0.0188,
    "ASN-HB2": 0.0797,
    "ASN-HB3": 0.0797,
    "RUN-H6": 0.2188,
    "RUN-H5": 0.1811,
    "RUN-H3": 0.3154,
    "DG-H5'2": 0.0754,
    "RC3-H5": 0.1928,
    "RG3-O2P": -0.776,
    "DTN-O3'": -0.6549,
    "SER-CA": -0.0249,
    "SER-CB": 0.2117,
    "DT5-C2'": -0.0854,
    "DG5-O5'": -0.6318,
    "DGN-H21": 0.4235,
    "DGN-H22": 0.4235,
    "DG-C1'": 0.0358,
    "RG-H4'": 0.1174,
    "DT3-O5'": -0.4954,
    "DG5-C5'": -0.0069,
    "LYN-HE2": -0.03358,
    "LYN-HE3": -0.03358,
    "RG5-C2'": 0.067,
    "DG3-H21": 0.4235,
    "DG3-H22": 0.4235,
    "MET-HE3": 0.0684,
    "RG3-O2'": -0.6139,
    "DT5-H1'": 0.1804,
    "RU3-C1'": 0.0674,
    "VAL-CG1": -0.3192,
    "RA3-C8": 0.2006,
    "RA3-C4": 0.3053,
    "RA3-C5": 0.0515,
    "RA3-C6": 0.7009,
    "RA3-C2": 0.5875,
    "RG5-HO'2": 0.4186,
    "DA-C2": 0.5716,
    "DC3-P": 1.1659,
    "DA-C6": 0.6897,
    "DA5-C4'": 0.1629,
    "DA-C5": 0.0725,
    "DC3-H5'2": 0.0754,
    "DA-C8": 0.1607,
    "DT3-C5'": -0.0069,
    "RCN-C3'": 0.2022,
    "RC3-H2'1": 0.0972,
    "RG5-H5'2": 0.0679,
    "RG5-H5'1": 0.0679,
    "GLN-HG3": 0.0352,
    "RGN-H1'": 0.2006,
    "RC5-C4'": 0.1065,
    "DT-N1": -0.0239,
    "RC5-C2": 0.7538,
    "RC5-C4": 0.8185,
    "RC5-C5": -0.5215,
    "RC5-C6": 0.0053,
    "RAN-O4'": -0.3548,
    "RA5-H8": 0.1553,
    "RG5-C8": 0.1374,
    "RG5-C4": 0.1222,
    "RA5-H2": 0.0473,
    "RG5-C6": 0.477,
    "GLN-CB": -0.0036,
    "GLN-CD": 0.6951,
    "RG5-C2": 0.7657,
    "RUN-H1'": 0.1824,
    "GLH-HG2": 0.043,
    "GLH-HG3": 0.043,
    "RG5-H4'": 0.1174,
    "RAN-C4'": 0.1065,
    "RG3-H1'": 0.2006,
    "RAN-C2": 0.5875,
    "RAN-C6": 0.7009,
    "RAN-C5": 0.0515,
    "RAN-C4": 0.3053,
    "HIE-HA": 0.136,
    "RC3-H6": 0.1958,
    "DG-H5'1": 0.0754,
    "RAN-C8": 0.2006,
    "RGN-H5'2": 0.0679,
    "LYS-HB3": 0.0362,
    "RGN-H5'1": 0.0679,
    "DT-C5'": -0.0069,
    "LEU-HB3": 0.0457,
    "ASN-OD1": -0.5931,
    "RC5-H3'": 0.0615,
    "DC3-O3'": -0.6549,
    "LYN-HA": 0.0994,
    "HID-CD2": 0.1292,
    "ILE-CG2": -0.3204,
    "DT-N3": -0.434,
    "ILE-CG1": -0.043,
    "DC-H1'": 0.1963,
    "DCN-H5'1": 0.0754,
    "DCN-H5'2": 0.0754,
    "RA3-C1'": 0.0394,
    "RG-HO'2": 0.4186,
    "ASN-HD21": 0.4196,
    "CYS-CB": -0.1231,
    "CYS-CA": 0.0213,
    "ASN-HD22": 0.4196,
    "DT3-N1": -0.0239,
    "DT3-N3": -0.434,
    "RGN-C2'": 0.067,
    "DCN-O3'": -0.6549,
    "PHE-CE1": -0.1704,
    "PHE-CE2": -0.1704,
    "DGN-H3T": 0.4396,
    "RCN-H1'": 0.2029,
    "DT5-N1": -0.0239,
    "DGN-H3'": 0.0985,
    "RU-O3'": -0.5246,
    "RG3-H8": 0.164,
    "RG3-H1": 0.3424,
    "RG3-O3'": -0.6541,
    "TYR-H": 0.2719,
    "TYR-O": -0.5679,
    "TYR-N": -0.4157,
    "RA5-H2'1": 0.0972,
    "TYR-C": 0.5973,
    "VAL-O": -0.5679,
    "DG3-H1'": 0.1746,
    "DT3-O4'": -0.3691,
    "LYN-HB3": 0.034,
    "LYN-HB2": 0.034,
    "RG5-C3'": 0.2022,
    "DT5-C1'": 0.068,
    "THR-CG2": -0.2438,
    "DG-N9": 0.0577,
    "DG-N3": -0.6636,
    "DG-N2": -0.923,
    "DG-N1": -0.5053,
    "DG-N7": -0.5725,
    "DAN-H62": 0.4167,
    "DAN-H61": 0.4167,
    "DA-O3'": -0.5232,
    "TRP-N": -0.4157,
    "TRP-O": -0.5679,
    "TRP-H": 0.2719,
    "DA5-C5'": -0.0069,
    "MET-CB": 0.0342,
    "TRP-C": 0.5973,
    "DT3-C4'": 0.1629,
    "RU-O5'": -0.4989,
    "DA-N7": -0.6175,
    "DA-N6": -0.9123,
    "DA-N1": -0.7624,
    "DA-N3": -0.7417,
    "RCN-C2'": 0.067,
    "DA-N9": -0.0268,
    "CYM-HA": 0.0508,
    "CYM-HN": 0.2719,
    "RAN-H8": 0.1553,
    "PRO-HB3": 0.0253,
    "PRO-HB2": 0.0253,
    "RA-N6": -0.9019,
    "DC3-C2": 0.7959,
    "RC5-C5'": 0.0558,
    "DA5-H8": 0.1877,
    "RA-N3": -0.6997,
    "DA5-H2": 0.0598,
    "RA-H61": 0.4115,
    "DT-H2'1": 0.0718,
    "DT-H2'2": 0.0718,
    "RUN-O3'": -0.6541,
    "RC3-C2'": 0.067,
    "RU5-C1'": 0.0674,
    "RG5-H3'": 0.0615,
    "TRP-CD1": -0.1638,
    "RU3-O2P": -0.776,
    "DC-N4": -0.9773,
    "DC-N3": -0.7748,
    "DC-N1": -0.0339,
    "HIE-H": 0.2719,
    "HIE-N": -0.4157,
    "HIE-O": -0.5679,
    "RC3-O2": -0.6252,
    "GLY-HA3": 0.0698,
    "GLY-HA2": 0.0698,
    "RC3-H42": 0.4234,
    "DC5-C1'": -0.0116,
    "DC-O1P": -0.7761,
    "DA3-C1'": 0.0431,
    "RC-C2": 0.7538,
    "RC-C6": 0.0053,
    "RC-C4": 0.8185,
    "RC-C5": -0.5215,
    "DGN-H2'2": 0.0718,
    "DGN-H2'1": 0.0718,
    "RA3-H1'": 0.2007,
    "RU3-O2'": -0.6139,
    "RC-H4'": 0.1174,
    "RC-H41": 0.4234,
    "RC-H42": 0.4234,
    "RGN-C1'": 0.0191,
    "RA-H2": 0.0473,
    "RU5-C6": -0.1126,
    "RU5-C4": 0.5952,
    "RU5-C5": -0.3635,
    "RU5-C2": 0.4687,
    "RA-H8": 0.1553,
    "DCN-H3'": 0.0985,
    "DT3-O4": -0.5563,
    "DT3-O2": -0.5881,
    "RC5-H2'1": 0.0972,
    "CYS-H": 0.2719,
    "CYS-O": -0.5679,
    "CYS-N": -0.4157,
    "RCN-N3": -0.7584,
    "CYS-C": 0.5973,
    "RCN-N1": -0.0484,
    "RCN-N4": -0.953,
    "CYX-HA": 0.0766,
    "LYS-HA": 0.1426,
    "GLH-HA": 0.0779,
    "PHE-CD2": -0.1256,
    "DCN-H3T": 0.4396,
    "PHE-CD1": -0.1256,
    "DG5-H2'2": 0.0718,
    "DT5-O4": -0.5563,
    "DG5-H2'1": 0.0718,
    "DT5-O2": -0.5881,
    "RG5-H2'1": 0.0972,
    "DGN-H4'": 0.1176,
    "RGN-HO'2": 0.4186,
    "DA-H2'2": 0.0718,
    "DA-H2'1": 0.0718,
    "HIP-HD2": 0.2317,
    "HIP-HD1": 0.3866,
    "DAN-C3'": 0.0713,
    "PHE-H": 0.2719,
    "PHE-O": -0.5679,
    "PHE-N": -0.4157,
    "RA3-O4'": -0.3548,
    "PHE-C": 0.5973,
    "DT5-N3": -0.434,
    "DA3-C6": 0.6897,
    "RG3-O4'": -0.3548,
    "DT3-H2'2": 0.0718,
    "DT3-H2'1": 0.0718,
    "DA3-C5": 0.0725,
    "RG-H22": 0.4364,
    "RG-H21": 0.4364,
    "DC-O4'": -0.3691,
    "LYS-HZ2": 0.34,
    "LYS-HZ3": 0.34,
    "RA-C1'": 0.0394,
    "RU3-H5": 0.1811,
    "RU3-H6": 0.2188,
    "RU3-H3": 0.3154,
    "DT5-H71": 0.077,
    "DT5-H72": 0.077,
    "DT5-H73": 0.077,
    "MET-HG2": 0.044,
    "RG3-C4'": 0.1065,
    "DA5-C2'": -0.0854,
    "DT3-H5'2": 0.0754,
    "RCN-C1'": 0.0066,
    "DA-O2P": -0.7761,
    "DG-O6": -0.5699,
    "RC5-C2'": 0.067,
    "DGN-N9": 0.0577,
    "SER-OG": -0.6546,
    "DGN-N7": -0.5725,
    "DGN-N1": -0.5053,
    "DGN-N2": -0.923,
    "DGN-N3": -0.6636,
    "DA3-H2": 0.0598,
    "DA3-H8": 0.1877,
    "RU-H1'": 0.1824,
    "DGN-O3'": -0.6549,
    "CYS-SG": -0.3119,
    "RG-H1": 0.3424,
    "TRP-HA": 0.1123,
    "RG3-H3T": 0.4376,
    "RG-H8": 0.164,
    "RC3-C3'": 0.2022,
    "TRP-HZ2": 0.1572,
    "RUN-H3'": 0.0615,
    "RU5-C2'": 0.067,
    "DC5-C2'": -0.0854,
    "RG5-O6": -0.5597,
    "RUN-H3T": 0.4376,
    "MET-HB2": 0.0241,
    "MET-HB3": 0.0241,
    "RG5-H21": 0.4364,
    "RG5-H22": 0.4364,
    "RG3-H3'": 0.0615,
    "RC3-N1": -0.0484,
    "RC3-N3": -0.7584,
    "RC3-N4": -0.953,
    "RC5-H1'": 0.2029,
    "LYN-NZ": -1.03581,
    "DAN-H5'1": 0.0754,
    "THR-HA": 0.1007,
    "THR-HB": 0.0043,
    "RU3-O3'": -0.6541,
    "RU3-H4'": 0.1174,
    "DG-H4'": 0.1176,
    "RCN-H2'1": 0.0972,
    "RA-C4": 0.3053,
    "TYR-CE1": -0.2341,
    "TYR-CE2": -0.2341,
    "DC-H3'": 0.0985,
    "DT3-H3": 0.342,
    "DT3-H6": 0.2607,
    "DCN-C5'": -0.0069,
    "DC3-O1P": -0.7761,
    "RCN-O2": -0.6252,
    "DCN-O5'": -0.6318,
    "THR-OG1": -0.6761,
    "DGN-H5T": 0.4422,
    "RGN-C5": 0.1744,
    "RA-C3'": 0.2022,
    "RGN-C6": 0.477,
    "DC5-H5'1": 0.0754,
    "DC5-H5'2": 0.0754,
    "HIP-HE1": 0.2681,
    "HIP-HE2": 0.3911,
    "DG-C2'": -0.0854,
    "HID-HA": 0.0881,
    "RA3-O5'": -0.4989,
    "TRP-CE2": 0.138,
    "TRP-CE3": -0.2387,
    "RG3-O5'": -0.4989,
    "RG-H3'": 0.0615,
    "DA-O1P": -0.7761,
    "DG5-H1'": 0.1746,
    "RA5-H4'": 0.1174,
    "DG3-H5'2": 0.0754,
    "DG3-H5'1": 0.0754,
    "RG3-P": 1.1662,
    "ILE-CB": 0.1303,
    "ILE-CA": -0.0597,
    "DT5-H4'": 0.1176,
    "DAN-H4'": 0.1176,
    "RG5-C1'": 0.0191,
    "RA3-N3": -0.6997,
    "RG3-C5'": 0.0558,
    "DA5-C3'": 0.0713,
    "RA5-H62": 0.4115,
    "GLH-HB3": 0.0256,
    "RA5-H61": 0.4115,
    "DGN-H5'1": 0.0754,
    "DGN-H5'2": 0.0754,
    "PRO-C": 0.5896,
    "PRO-O": -0.5748,
    "PRO-N": -0.2548,
    "RA5-C8": 0.2006,
    "DC5-C3'": 0.0713,
    "TYR-CA": -0.0014,
    "TYR-CB": -0.0152,
    "TYR-CG": -0.0011,
    "DG-H1": 0.352,
    "RA5-C2": 0.5875,
    "RGN-H4'": 0.1174,
    "RC5-C3'": 0.2022,
    "DG-H8": 0.1997,
    "TYR-CZ": 0.3226,
    "DGN-O6": -0.5699,
    "RU5-C3'": 0.2022,
    "RA5-C6": 0.7009,
    "RG5-N1": -0.4787,
    "RC3-O4'": -0.3548,
    "RA5-C5": 0.0515,
    "LEU-H": 0.2719,
    "ASP-C": 0.5366,
    "LEU-N": -0.4157,
    "LEU-O": -0.5679,
    "THR-HG22": 0.0642,
    "ASP-H": 0.2936,
    "LEU-C": 0.5973,
    "ASP-N": -0.5163,
    "ASP-O": -0.5819,
    "RC3-C4'": 0.1065,
    "RA3-N9": -0.0251,
    "RA3-N7": -0.6073,
    "RA3-N6": -0.9019,
    "RA-HO'2": 0.4186,
    "RUN-H4'": 0.1174,
    "RA3-N1": -0.7615,
    "GLH-HB2": 0.0256,
    "ASH-H": 0.2719,
    "ASH-N": -0.4157,
    "ASH-O": -0.5679,
    "RG5-N9": 0.0492,
    "RG3-H22": 0.4364,
    "ASH-C": 0.5973,
    "RG5-H1'": 0.2006,
    "RG3-H21": 0.4364,
    "RAN-C1'": 0.0394,
    "RG5-N2": -0.9672,
    "RA5-C4": 0.3053,
    "DT5-H5'1": 0.0754,
    "RA-H2'1": 0.0972,
    "RAN-N9": -0.0251,
    "RAN-N1": -0.7615,
    "RAN-N3": -0.6997,
    "DA5-O5'": -0.6318,
    "RAN-N6": -0.9019,
    "RAN-N7": -0.6073,
    "DC-O3'": -0.5232,
    "RAN-HO'2": 0.4186,
    "DA3-C3'": 0.0713,
    "DC5-C2": 0.7959,
    "DC3-N4": -0.9773,
    "DC5-C6": -0.0183,
    "DC5-C4": 0.8439,
    "DC5-C5": -0.5222,
    "RA3-C4'": 0.1065,
    "RC-O3'": -0.5246,
    "CYS-HA": 0.1124,
    "CYS-HG": 0.1933,
    "HIP-CE1": -0.017,
    "SER-H": 0.2719,
    "SER-N": -0.4157,
    "SER-O": -0.5679,
    "SER-C": 0.5973,
    "TYR-CD2": -0.1906,
    "TYR-CD1": -0.1906,
    "DC-H4'": 0.1176,
    "TRP-NE1": -0.3418,
    "DCN-C4'": 0.1629,
    "DC-H42": 0.4314,
    "DC-H41": 0.4314,
    "ASP-OD2": -0.8014,
    "ASP-OD1": -0.8014,
    "RU3-H2'1": 0.0972,
    "ASH-HD2": 0.4747,
    "DCN-O4'": -0.3691,
    "GLN-HE21": 0.4251,
    "RG5-O4'": -0.3548,
    "GLN-HE22": 0.4251,
    "DG-H2'1": 0.0718,
    "DG-H2'2": 0.0718,
    "LYS-NZ": -0.3854,
    "ILE-C": 0.5973,
    "PHE-HD1": 0.133,
    "RU5-HO'2": 0.4186,
    "PHE-HD2": 0.133,
    "RA-C2'": 0.067,
    "ILE-H": 0.2719,
    "RGN-H2'1": 0.0972,
    "ILE-O": -0.5679,
    "DC5-H5T": 0.4422,
    "RG-C3'": 0.2022,
    "RA3-O2'": -0.6139,
    "TRP-HE1": 0.3412,
    "TRP-HE3": 0.17,
    "RA3-O2P": -0.776,
    "RG3-C8": 0.1374,
    "RG3-C2": 0.7657,
    "RG3-C6": 0.477,
    "RG3-C4": 0.1222,
    "RG3-C5": 0.1744,
    "DC3-C2'": -0.0854,
    "DT3-H3T": 0.4396,
    "ARG-NH2": -0.8627,
    "TYR-HA": 0.0876,
    "RGN-H5T": 0.4295,
    "DAN-H5T": 0.4422,
    "RUN-O2'": -0.6139,
    "RA5-H1'": 0.2007,
    "TYR-HH": 0.3992,
    "HIP-ND1": -0.1513,
    "DG3-H8": 0.1997,
    "DG3-H1": 0.352,
    "RA5-O2'": -0.6139,
    "ARG-C": 0.7341,
    "ARG-N": -0.3479,
    "ARG-O": -0.5894,
    "ARG-H": 0.2747,
    "DT5-H5T": 0.4422,
    "DA3-H2'2": 0.0718,
    "DA3-H2'1": 0.0718,
    "RC-H6": 0.1958,
    "DA3-N1": -0.7624,
    "DA3-N3": -0.7417,
    "RU5-C4'": 0.1065,
    "DA3-N7": -0.6175,
    "DA3-N6": -0.9123,
    "DA3-N9": -0.0268,
    "DC-O2P": -0.7761,
    "TRP-CZ3": -0.1972,
    "TRP-CZ2": -0.2601,
    "RA3-P": 1.1662,
    "RC3-O5'": -0.4989,
    "RG-H5'1": 0.0679,
    "RG-H5'2": 0.0679,
    "RG-N9": 0.0492,
    "DAN-C5": 0.0725,
    "RU-O2P": -0.776,
    "RG-N1": -0.4787,
    "RG-N3": -0.6323,
    "RG-N2": -0.9672,
    "RG-N7": -0.5709,
    "DTN-H5'2": 0.0754,
    "DTN-H5'1": 0.0754,
    "RC3-C5'": 0.0558,
    "DC3-N3": -0.7748,
    "HIP-H": 0.2747,
    "DC3-N1": -0.0339,
    "HIP-O": -0.5894,
    "HIP-N": -0.3479,
    "HIP-C": 0.7341,
    "MET-C": 0.5973,
    "RUN-H5T": 0.4295,
    "RU-O2'": -0.6139,
    "RU-H3": 0.3154,
    "DA3-O4'": -0.3691,
    "RU5-O4'": -0.3548,
    "MET-H": 0.2719,
    "DAN-C8": 0.1607,
    "DT-C1'": 0.068,
    "DA5-H3'": 0.0985,
    "DA3-C4'": 0.1629,
    "HID-O": -0.5679,
    "HID-N": -0.4157,
    "HID-H": 0.2719,
    "HID-C": 0.5973,
    "DT5-C3'": 0.0713,
    "DAN-C2'": -0.0854,
    "RC-O2P": -0.776,
    "DG5-O4'": -0.3691,
    "RC-O2'": -0.6139,
    "HIP-CD2": -0.1141,
    "DAN-O5'": -0.6318,
    "RU3-O1P": -0.776,
    "PHE-HA": 0.0978,
    "DC-C4": 0.8439,
    "RC-N4": -0.953,
    "DC-C6": -0.0183,
    "RC-N1": -0.0484,
    "PHE-HZ": 0.1297,
    "DT-H5'2": 0.0754,
    "LYS-CG": 0.0187,
    "LYS-CD": -0.0479,
    "DT-H5'1": 0.0754,
    "LYS-CB": -0.0094,
    "CYX-SG": -0.1081,
    "LYS-CA": -0.24,
    "DTN-H73": 0.077,
    "DTN-H72": 0.077,
    "DTN-H71": 0.077,
    "DC-P": 1.1659,
    "RG5-O5'": -0.6223,
    "RC-H2'1": 0.0972,
    "DG-P": 1.1659,
    "GLH-OE2": -0.6511,
    "GLH-OE1": -0.5838,
    "PHE-HE2": 0.143,
    "PHE-HE1": 0.143,
    "DA3-H5'2": 0.0754,
    "RA-C5'": 0.0558,
    "ARG-HH22": 0.4478,
    "ARG-HH21": 0.4478,
    "RG-C2'": 0.067,
    "ALA-CB": -0.1825,
    "ALA-CA": 0.0337,
    "RA3-O3'": -0.6541,
    "TRP-HD1": 0.2062,
    "RA3-H2'1": 0.0972,
    "RG-H1'": 0.2006,
    "DC5-H4'": 0.1176,
    "DG5-H3'": 0.0985,
    "RUN-H2'1": 0.0972,
    "RA-O5'": -0.4989,
    "DC5-H41": 0.4314,
    "DC5-H42": 0.4314,
    "SER-HA": 0.0843,
    "DT5-H5'2": 0.0754,
    "SER-HG": 0.4275,
    "DA3-H62": 0.4167,
    "DA3-H61": 0.4167,
    "RUN-HO'2": 0.4186,
    "RU5-H5'1": 0.0679,
    "RU-H2'1": 0.0972,
    "RU5-H5'2": 0.0679,
    "DG3-O2P": -0.7761,
    "DA5-C1'": 0.0431,
    "HIP-NE2": -0.1718,
    "DT3-P": 1.1659,
    "DG5-H1": 0.352,
    "DG5-H8": 0.1997,
    "RA5-O3'": -0.5246,
    "LYN-C": 0.5973,
    "LYN-O": -0.5679,
    "LYN-N": -0.4157,
    "LYN-H": 0.2719,
    "DA-H5'1": 0.0754,
    "DA-H5'2": 0.0754,
    "RC5-C1'": 0.0066,
    "RG5-N7": -0.5709,
    "RAN-H5'1": 0.0679,
    "RAN-H5'2": 0.0679,
    "RU5-C5'": 0.0558,
    "RGN-O3'": -0.6541,
    "CYM-CA": -0.0351,
    "DGN-C8": 0.0736,
    "DGN-C6": 0.4918,
    "DGN-C5": 0.1991,
    "DGN-C4": 0.1814,
    "DGN-C2": 0.7432,
    "RU-C5'": 0.0558,
    "RG-O6": -0.5597,
    "DT5-O3'": -0.5232,
    "RA3-H8": 0.1553,
    "RA3-H2": 0.0473,
    "RA5-H3'": 0.0615,
    "RG5-H8": 0.164,
    "DT-C2'": -0.0854,
    "RG5-H1": 0.3424,
    "TYR-OH": -0.5579,
    "RAN-H4'": 0.1174,
    "MET-CA": -0.0237,
    "RAN-C3'": 0.2022,
    "MET-CE": -0.0536,
    "MET-CG": 0.0018,
    "RC3-C6": 0.0053,
    "RC3-C4": 0.8185,
    "RC3-C5": -0.5215,
    "RC3-C2": 0.7538,
    "DAN-H8": 0.1877,
    "DA3-O5'": -0.4954,
    "HID-ND1": -0.3811,
    "DAN-H2": 0.0598,
    "RU5-O5'": -0.6223,
    "DC3-H42": 0.4314,
    "DA5-H5'2": 0.0754,
    "DA5-H5'1": 0.0754,
    "DC3-H41": 0.4314,
    "DA-C4'": 0.1629,
    "DC3-H4'": 0.1176,
    "RG5-N3": -0.6323,
    "DTN-C7": -0.2269,
    "DA3-C5'": -0.0069,
    "MET-SD": -0.2737,
    "RC5-H5": 0.1928,
    "DA3-C4": 0.38,
    "RC5-H6": 0.1958,
    "DA3-C2": 0.5716,
    "DA3-C8": 0.1607,
    "MET-HG3": 0.044,
    "HIE-NE2": -0.2795,
    "DC3-H5": 0.1863,
    "DT3-H5'1": 0.0754,
    "DAN-C1'": 0.0431,
    "DC3-H6": 0.2293,
    "GLN-OE1": -0.6086,
    "ARG-HE": 0.3456,
    "DC5-O2": -0.6548,
    "ARG-HA": 0.156,
    "LYN-CE": 0.32604,
    "LYN-CD": -0.03768,
    "LYN-CG": 0.06612,
    "RGN-C2": 0.7657,
    "LYN-CA": -0.07206,
    "RGN-C4": 0.1222,
    "LYN-CB": -0.04845,
    "RA5-C4'": 0.1065,
    "RGN-C8": 0.1374,
    "RC-O2": -0.6252,
    "RCN-O5'": -0.6223,
    "RUN-N1": 0.0418,
    "RUN-N3": -0.3549,
    "RG5-O2'": -0.6139,
    "RC-O1P": -0.776,
    "HIE-C": 0.5973,
    "RA-C4'": 0.1065,
    "ASN-CG": 0.713,
    "ARG-HH12": 0.4478,
    "ASN-CA": 0.0143,
    "ASN-CB": -0.2041,
    "ARG-HH11": 0.4478,
    "ARG-CD": 0.0486,
    "RG-C1'": 0.0191,
    "TYR-HD1": 0.1699,
    "DG5-O3'": -0.5232,
    "TYR-HD2": 0.1699,
    "ILE-N": -0.4157,
    "RC3-HO'2": 0.4186,
    "DG3-O3'": -0.6549,
    "DG3-H4'": 0.1176,
    "RA-O4'": -0.3548,
    "ASH-OD2": -0.6376,
    "ASH-OD1": -0.5554,
    "DG5-H22": 0.4235,
    "DG5-H21": 0.4235,
    "DT3-H4'": 0.1176,
    "DT3-C3'": 0.0713,
    "DAN-H3T": 0.4396,
    "DGN-C1'": 0.0358,
    "RG5-C4'": 0.1065,
    "RG-O4'": -0.3548,
    "DG5-O6": -0.5699,
    "RA5-O4'": -0.3548,
    "RCN-C5'": 0.0558,
    "DAN-H3'": 0.0985,
}

nt_charges = {
    "HID-H2": 0.1963,
    "HID-H3": 0.1963,
    "HID-H1": 0.1963,
    "ASN-HB2": 0.0515,
    "ALA-HB2": 0.03,
    "ALA-HB3": 0.03,
    "ALA-HB1": 0.03,
    "THR-OG1": -0.6764,
    "GLU-H1": 0.2391,
    "GLU-H3": 0.2391,
    "GLU-H2": 0.2391,
    "PRO-HD3": 0.1,
    "PRO-HD2": 0.1,
    "GLU-HA": 0.1202,
    "THR-CA": 0.0034,
    "THR-CB": 0.4514,
    "LYS-HB2": 0.0283,
    "ILE-HG21": 0.0947,
    "ILE-HG22": 0.0947,
    "ILE-HG23": 0.0947,
    "HID-NE2": -0.5711,
    "HIP-HE1": 0.2645,
    "HIP-HE2": 0.3921,
    "GLU-CD": 0.8087,
    "VAL-CA": -0.0054,
    "GLU-CG": -0.0236,
    "GLU-CA": 0.0588,
    "GLU-CB": 0.0909,
    "HID-HA": 0.0958,
    "VAL-CB": 0.3196,
    "TRP-CE2": 0.1575,
    "TRP-CE3": -0.2265,
    "ASP-N": 0.0782,
    "ASP-O": -0.5889,
    "VAL-C": 0.6163,
    "HID-HE1": 0.1385,
    "VAL-O": -0.5722,
    "VAL-N": 0.0577,
    "CYX-CB": -0.0277,
    "HIE-ND1": -0.5579,
    "CYX-CA": 0.1055,
    "SER-HB2": 0.0273,
    "SER-HB3": 0.0273,
    "ILE-CB": 0.1885,
    "HID-CE1": 0.2127,
    "ILE-CA": 0.0257,
    "GLU-C": 0.5621,
    "GLU-N": 0.0017,
    "GLU-O": -0.5889,
    "GLU-HG3": -0.0315,
    "GLU-HG2": -0.0315,
    "PRO-C": 0.526,
    "GLU-OE1": -0.8189,
    "PRO-O": -0.5,
    "PRO-N": -0.202,
    "ALA-HA": 0.0889,
    "TYR-CA": 0.057,
    "TYR-CB": 0.0659,
    "TYR-CG": -0.0205,
    "ILE-HB": 0.0213,
    "ILE-HA": 0.1031,
    "TYR-CZ": 0.3139,
    "CYX-HB2": 0.068,
    "CYX-HB3": 0.068,
    "TYR-HB3": 0.0102,
    "TYR-HB2": 0.0102,
    "HID-CG": -0.0399,
    "HID-CB": 0.0259,
    "HID-CA": 0.0964,
    "ILE-H3": 0.2329,
    "ILE-H2": 0.2329,
    "ILE-H1": 0.2329,
    "ASN-HB3": 0.0515,
    "THR-CG2": -0.2554,
    "ASP-C": 0.5621,
    "LEU-N": 0.101,
    "LEU-O": -0.5713,
    "LEU-C": 0.6123,
    "ALA-H3": 0.1997,
    "ALA-H2": 0.1997,
    "ALA-H1": 0.1997,
    "TYR-HE2": 0.165,
    "TYR-HE1": 0.165,
    "VAL-HG12": 0.0735,
    "VAL-HG13": 0.0735,
    "VAL-HG11": 0.0735,
    "SER-CA": 0.0567,
    "SER-CB": 0.2596,
    "TYR-H1": 0.1873,
    "TYR-H2": 0.1873,
    "TYR-H3": 0.1873,
    "PRO-H2": 0.312,
    "PRO-H3": 0.312,
    "HIE-HD2": 0.1963,
    "VAL-H1": 0.2272,
    "VAL-H2": 0.2272,
    "VAL-H3": 0.2272,
    "VAL-HA": 0.1093,
    "VAL-HB": -0.0221,
    "TYR-HA": 0.0983,
    "PRO-HA": 0.1,
    "TYR-HH": 0.4001,
    "HID-HB3": 0.0209,
    "HID-HB2": 0.0209,
    "MET-C": 0.6123,
    "MET-N": 0.1592,
    "MET-O": -0.5713,
    "CYS-HA": 0.1411,
    "VAL-CG2": -0.3129,
    "HIP-CE1": -0.0011,
    "SER-N": 0.1849,
    "SER-O": -0.5722,
    "SER-C": 0.6163,
    "LEU-CD1": -0.4106,
    "LEU-CD2": -0.4104,
    "TRP-NE1": -0.3444,
    "LYS-HB3": 0.0283,
    "ALA-N": 0.1414,
    "ALA-O": -0.5722,
    "ALA-C": 0.6163,
    "ASP-OD2": -0.8084,
    "ASP-OD1": -0.8084,
    "GLN-HG2": 0.0331,
    "GLN-HG3": 0.0331,
    "GLN-HE21": 0.4429,
    "GLN-HE22": 0.4429,
    "ASN-H2": 0.1921,
    "ARG-NE": -0.565,
    "CYS-H2": 0.2023,
    "CYS-H3": 0.2023,
    "CYS-H1": 0.2023,
    "ILE-C": 0.6123,
    "PHE-HD1": 0.1374,
    "ILE-HG13": 0.0201,
    "THR-HG1": 0.407,
    "PHE-HD2": 0.1374,
    "ILE-HG12": 0.0201,
    "ILE-N": 0.0311,
    "ILE-O": -0.5713,
    "HIE-H1": 0.2016,
    "LYS-HE2": 0.1171,
    "HIE-H3": 0.2016,
    "HIE-H2": 0.2016,
    "GLN-CA": 0.0536,
    "GLN-CB": 0.0651,
    "GLN-CD": 0.7354,
    "GLN-CG": -0.0903,
    "TRP-HE1": 0.3412,
    "TRP-HE3": 0.1646,
    "ARG-HD2": 0.0527,
    "ARG-HD3": 0.0527,
    "HIE-HA": 0.138,
    "ARG-NH2": -0.8693,
    "LEU-HB2": 0.0256,
    "LEU-HB3": 0.0256,
    "ASN-OD1": -0.5744,
    "MET-HE1": 0.0597,
    "MET-HE3": 0.0597,
    "MET-HE2": 0.0597,
    "HID-CD2": 0.1046,
    "ILE-CG2": -0.372,
    "ILE-CG1": -0.0387,
    "HIP-ND1": -0.151,
    "ASN-C": 0.6163,
    "ASN-N": 0.1801,
    "ASN-O": -0.5722,
    "ARG-C": 0.7214,
    "ARG-N": 0.1305,
    "ARG-O": -0.6013,
    "ASN-HD21": 0.4097,
    "CYS-CB": -0.1195,
    "CYS-CA": 0.0927,
    "ASN-HD22": 0.4097,
    "ACE-O": -0.5679,
    "LEU-CG": 0.3421,
    "LEU-CA": 0.0104,
    "LEU-CB": -0.0244,
    "TRP-CZ3": -0.2034,
    "TRP-CZ2": -0.271,
    "HIP-HB3": 0.0531,
    "HIP-HB2": 0.0531,
    "PHE-CE1": -0.1602,
    "PHE-CE2": -0.1603,
    "PHE-CZ": -0.1208,
    "PHE-CA": 0.0733,
    "PHE-CB": 0.033,
    "PHE-CG": 0.0031,
    "HIP-O": -0.6013,
    "HIP-N": 0.256,
    "HIP-C": 0.7214,
    "MET-HB2": 0.0125,
    "ASN-ND2": -0.8634,
    "TRP-CA": 0.0421,
    "TRP-CB": 0.0543,
    "TRP-CG": -0.1654,
    "TYR-O": -0.5713,
    "TYR-N": 0.194,
    "TYR-C": 0.6123,
    "HIP-HA": 0.1047,
    "HID-O": -0.5713,
    "HID-N": 0.1542,
    "PHE-H1": 0.1921,
    "PHE-H2": 0.1921,
    "PHE-H3": 0.1921,
    "HID-C": 0.6123,
    "GLU-HB2": -0.0232,
    "GLU-HB3": -0.0232,
    "THR-HG22": 0.0627,
    "THR-HG23": 0.0627,
    "THR-HG21": 0.0627,
    "LYS-C": 0.7214,
    "LYS-N": 0.0966,
    "LYS-O": -0.6013,
    "HIP-CD2": -0.1433,
    "VAL-CG1": -0.3129,
    "CYS-HSG": 0.1975,
    "TRP-N": 0.1913,
    "TRP-O": -0.5713,
    "PHE-HA": 0.1041,
    "ILE-CD1": -0.0908,
    "TRP-C": 0.6123,
    "HIP-H2": 0.1704,
    "HIP-H3": 0.1704,
    "HIP-H1": 0.1704,
    "PHE-HZ": 0.1329,
    "LYS-CG": -0.0048,
    "LYS-CD": -0.0608,
    "LYS-CE": -0.0181,
    "LYS-CB": 0.0212,
    "CYX-SG": -0.0984,
    "LYS-CA": -0.0015,
    "ASP-HB2": -0.0169,
    "ASP-HB3": -0.0169,
    "PRO-HB3": 0.1,
    "PRO-HB2": 0.1,
    "TYR-CD2": -0.2002,
    "TYR-CD1": -0.2002,
    "PHE-HE2": 0.1433,
    "PHE-HE1": 0.1433,
    "ARG-HH22": 0.4494,
    "ARG-HH21": 0.4494,
    "THR-C": 0.6163,
    "LYS-HD2": 0.0633,
    "LYS-HD3": 0.0633,
    "THR-N": 0.1812,
    "THR-O": -0.5722,
    "ALA-CB": -0.0597,
    "ALA-CA": 0.0962,
    "PRO-CD": -0.012,
    "PRO-CG": -0.121,
    "TRP-HD1": 0.2195,
    "PRO-CA": 0.1,
    "PRO-CB": -0.115,
    "PHE-HB3": 0.0104,
    "PHE-HB2": 0.0104,
    "ILE-HD12": 0.0226,
    "ILE-HD13": 0.0226,
    "HIE-N": 0.1472,
    "ILE-HD11": 0.0226,
    "GLY-HA3": 0.0895,
    "GLY-HA2": 0.0895,
    "SER-HA": 0.0782,
    "SER-HG": 0.4239,
    "SER-H1": 0.1898,
    "SER-H3": 0.1898,
    "SER-H2": 0.1898,
    "PHE-C": 0.6123,
    "TRP-CH2": -0.108,
    "HIE-CD2": -0.2349,
    "ASP-CB": -0.0235,
    "HIP-CB": 0.0484,
    "HIP-CA": 0.0581,
    "ASP-CA": 0.0292,
    "HIP-CG": -0.0236,
    "ASP-CG": 0.8194,
    "ARG-HG3": 0.0309,
    "ARG-HG2": 0.0309,
    "HIP-NE2": -0.1739,
    "ACE-CH3": -0.3662,
    "CYX-H3": 0.1815,
    "CYX-H2": 0.1815,
    "CYX-H1": 0.1815,
    "LYS-H3": 0.2165,
    "LYS-H2": 0.2165,
    "LYS-H1": 0.2165,
    "CYS-HB3": 0.1188,
    "CYS-HB2": 0.1188,
    "ARG-CZ": 0.8281,
    "ARG-CG": 0.0236,
    "ARG-CD": 0.0935,
    "ARG-CB": 0.0118,
    "ARG-CA": -0.0223,
    "CYS-O": -0.5713,
    "CYS-N": 0.1325,
    "CYS-C": 0.6123,
    "TRP-HZ2": 0.1589,
    "TRP-HZ3": 0.1458,
    "ACE-C": 0.5972,
    "CYX-HA": 0.0922,
    "LYS-HA": 0.118,
    "PHE-CD2": -0.1391,
    "PHE-CD1": -0.1392,
    "CYX-N": 0.2069,
    "CYX-O": -0.5713,
    "CYX-C": 0.6123,
    "PRO-HG2": 0.1,
    "PRO-HG3": 0.1,
    "TYR-OH": -0.5578,
    "MET-CA": 0.0221,
    "MET-CB": 0.0865,
    "MET-CE": -0.0341,
    "MET-CG": 0.0334,
    "GLU-OE2": -0.8189,
    "MET-H1": 0.1984,
    "MET-H3": 0.1984,
    "MET-H2": 0.1984,
    "LEU-HD21": 0.098,
    "LEU-HD23": 0.098,
    "LEU-HD22": 0.098,
    "HID-ND1": -0.3819,
    "HIP-HD2": 0.2495,
    "HIP-HD1": 0.3821,
    "HIE-HB2": 0.0223,
    "HIE-HB3": 0.0223,
    "PHE-O": -0.5713,
    "PHE-N": 0.1737,
    "ASP-H3": 0.22,
    "ASP-H2": 0.22,
    "ASP-H1": 0.22,
    "ASP-HA": 0.1141,
    "ARG-HB2": 0.0226,
    "ARG-HB3": 0.0226,
    "TRP-CD1": -0.1788,
    "MET-SD": -0.2774,
    "TRP-CD2": 0.1132,
    "ACE-HH33": 0.1123,
    "ACE-HH32": 0.1123,
    "ACE-HH31": 0.1123,
    "HID-HD2": 0.1299,
    "HID-HD1": 0.3632,
    "MET-HA": 0.1116,
    "MET-HG3": 0.0292,
    "MET-HG2": 0.0292,
    "TRP-HH2": 0.1411,
    "LYS-HZ2": 0.3382,
    "LYS-HZ3": 0.3382,
    "LYS-HZ1": 0.3382,
    "GLN-OE1": -0.6133,
    "ARG-HE": 0.3592,
    "ARG-HA": 0.1242,
    "HIE-NE2": -0.2781,
    "VAL-HG23": 0.0735,
    "VAL-HG22": 0.0735,
    "VAL-HG21": 0.0735,
    "LYS-NZ": -0.3764,
    "ARG-H3": 0.2083,
    "ARG-H2": 0.2083,
    "ARG-H1": 0.2083,
    "HIE-O": -0.5713,
    "SER-OG": -0.6714,
    "GLN-NE2": -1.0031,
    "HIE-C": 0.6123,
    "LYS-HG3": 0.0121,
    "LYS-HG2": 0.0121,
    "HIE-HE1": 0.1397,
    "HIE-HE2": 0.3324,
    "GLN-HA": 0.1015,
    "ASN-H1": 0.1921,
    "ASN-H3": 0.1921,
    "ASN-CG": 0.5833,
    "ARG-HH12": 0.4494,
    "ASN-CA": 0.0368,
    "ASN-CB": -0.0283,
    "ARG-HH11": 0.4494,
    "CYS-SG": -0.3298,
    "TRP-HA": 0.1162,
    "LEU-HA": 0.1053,
    "ARG-NH1": -0.8693,
    "GLN-HB3": 0.005,
    "GLN-HB2": 0.005,
    "LEU-HG": -0.038,
    "TYR-HD1": 0.172,
    "TYR-HD2": 0.172,
    "GLN-C": 0.6123,
    "HIE-CG": 0.174,
    "HIE-CA": 0.0236,
    "HIE-CB": 0.0489,
    "MET-HB3": 0.0125,
    "TRP-H1": 0.1888,
    "TRP-H3": 0.1888,
    "TRP-H2": 0.1888,
    "LEU-H1": 0.2148,
    "LEU-H3": 0.2148,
    "LEU-H2": 0.2148,
    "ASN-HA": 0.1231,
    "LEU-HD11": 0.098,
    "LEU-HD12": 0.098,
    "LEU-HD13": 0.098,
    "GLN-H1": 0.1996,
    "GLN-H2": 0.1996,
    "GLN-H3": 0.1996,
    "THR-HA": 0.1087,
    "LYS-HE3": 0.1171,
    "THR-HB": -0.0323,
    "TRP-HB2": 0.0222,
    "TRP-HB3": 0.0222,
    "HIE-CE1": 0.1804,
    "GLY-CA": -0.01,
    "TYR-CE1": -0.2239,
    "TYR-CE2": -0.2239,
    "GLY-C": 0.6163,
    "GLY-N": 0.2943,
    "GLY-O": -0.5722,
    "THR-H1": 0.1934,
    "THR-H3": 0.1934,
    "THR-H2": 0.1934,
    "GLN-O": -0.5713,
    "GLN-N": 0.1493,
    "GLY-H1": 0.1642,
    "GLY-H3": 0.1642,
    "GLY-H2": 0.1642,
}

unified_charges = {
    "GLN-CB": 0.030600000000000002,
    "DA5-C2'": 0.0582,
    "RCN-O2": -0.6252,
    "RGN-O2'": -0.19529999999999997,
    "DCN-O5'": -0.18960000000000005,
    "RG5-C2": 0.7657,
    "RG-O5'": -0.4989,
    "RAN-H5T": 0.4295,
    "LEU-CA": 0.040400000000000005,
    "RU-C4'": 0.2239,
    "THR-OG1": -0.2659,
    "DGN-H5T": 0.4422,
    "LYN-CA": 0.027340000000000003,
    "RG-C5'": 0.1916,
    "DT-C3'": 0.1698,
    "THR-CA": 0.0618,
    "THR-CB": 0.36970000000000003,
    "RA-C3'": 0.2637,
    "LYN-C": 0.5973,
    "LYN-CB": 0.019550000000000005,
    "RAN-C2'": 0.1642,
    "RU-O4'": -0.3548,
    "RU-P": 1.1662,
    "RAN-O5'": -0.19279999999999997,
    "HID-NE2": -0.5727,
    "GLU-CD": 0.8054,
    "VAL-CA": 0.009400000000000006,
    "DC3-C4'": 0.28049999999999997,
    "GLU-CG": -0.0714,
    "DG-C2'": 0.0582,
    "GLU-CA": 0.1502,
    "GLU-CB": 0.0214,
    "DCN-H5T": 0.4422,
    "RA3-O5'": -0.4989,
    "RAN-C5'": 0.1916,
    "LEU-C": 0.5973,
    "TRP-CE2": 0.138,
    "TRP-CE3": -0.06869999999999998,
    "DG-O1P": -0.7761,
    "RG3-O5'": -0.4989,
    "SER-O": -0.5679,
    "RA-P": 1.1662,
    "RC3-O3'": -0.21650000000000003,
    "DA-O1P": -0.7761,
    "CYM-SG": -0.8844,
    "DCN-C2": 0.7959,
    "DC5-O4'": -0.3691,
    "DCN-C6": 0.211,
    "DCN-C5": -0.3359,
    "DCN-C4": 0.8439,
    "VAL-C": 0.5973,
    "DG-C5'": 0.14389999999999997,
    "DG3-N9": 0.0577,
    "RC5-O5'": -0.19279999999999997,
    "DG3-N3": -0.6636,
    "DG3-N2": -0.07600000000000007,
    "DG3-N1": -0.1533,
    "TRP-C": 0.5973,
    "DG3-N7": -0.5725,
    "VAL-N": -0.14380000000000004,
    "CYX-CB": 0.103,
    "DT-C4'": 0.28049999999999997,
    "RG3-P": 1.1662,
    "DC3-O2P": -0.7761,
    "DGN-C5'": 0.14389999999999997,
    "DT3-O1P": -0.7761,
    "RCN-O4'": -0.3548,
    "DG5-C1'": 0.2104,
    "ILE-CB": 0.149,
    "HID-CE1": 0.3449,
    "ILE-CA": 0.027200000000000002,
    "DTN-C5'": 0.14389999999999997,
    "DC5-N4": -0.11449999999999994,
    "RUN-O3'": -0.21650000000000003,
    "DT5-C2": 0.5677,
    "DT5-C5": 0.0025,
    "DT5-C4": 0.5194,
    "DC5-N3": -0.7748,
    "DT-O2": -0.5881,
    "RUN-C2'": 0.1642,
    "LYN-N": -0.14380000000000004,
    "RC5-H5T": 0.4295,
    "GLU-C": 0.5366,
    "DT-O1P": -0.7761,
    "DAN-C4'": 0.28049999999999997,
    "RG3-C5'": 0.1916,
    "GLU-N": -0.22269999999999995,
    "DA5-C3'": 0.1698,
    "DCN-C1'": 0.1847,
    "DG3-C1'": 0.2104,
    "RA5-C5'": 0.1916,
    "RU3-C5'": 0.1916,
    "GLU-OE2": -0.8188,
    "DA3-O2P": -0.7761,
    "RG3-C1'": 0.2197,
    "PRO-O": -0.5748,
    "PRO-N": -0.2548,
    "RGN-C1'": 0.2197,
    "RGN-N7": -0.5709,
    "RGN-N2": -0.09439999999999993,
    "RGN-N3": -0.6323,
    "RGN-N1": -0.13630000000000003,
    "DAN-O4'": -0.3691,
    "RG-O1P": -0.776,
    "RU5-N3": -0.03949999999999998,
    "DG-C5": 0.1991,
    "TYR-CA": 0.0862,
    "RUN-O2": -0.5477,
    "RG-C5": 0.1744,
    "TYR-CG": -0.0011,
    "RUN-O4": -0.5761,
    "RG5-O3'": -0.5246,
    "RA5-C2": 0.6348,
    "RA3-O1P": -0.776,
    "DT-C2": 0.5677,
    "RC5-C3'": 0.2637,
    "DTN-C2'": 0.0582,
    "DT-C5": 0.0025,
    "RG3-C5": 0.1744,
    "RGN-C3'": 0.2637,
    "DGN-O6": -0.5699,
    "RU5-C3'": 0.2637,
    "RAN-C1'": 0.24009999999999998,
    "PHE-CZ": 0.022500000000000006,
    "RG-C8": 0.3014,
    "RA5-C4": 0.3053,
    "HID-CA": 0.1069,
    "RC3-O4'": -0.3548,
    "RA5-C5": 0.0515,
    "THR-CG2": -0.051199999999999996,
    "ASP-C": 0.5366,
    "LEU-N": -0.14380000000000004,
    "LEU-O": -0.5679,
    "ASH-O": -0.5679,
    "GLH-N": -0.14380000000000004,
    "ASP-N": -0.22269999999999995,
    "DTN-H5T": 0.4422,
    "RC-O2P": -0.776,
    "RC3-C4'": 0.2239,
    "RA3-N9": -0.0251,
    "RA3-N7": -0.6073,
    "RA3-N6": -0.07890000000000008,
    "RU5-O2'": -0.19529999999999997,
    "RCN-C6": 0.2011,
    "RA3-N3": -0.6997,
    "RA3-N1": -0.7615,
    "RCN-C2": 0.7538,
    "RA5-C8": 0.3559,
    "ASH-N": -0.14380000000000004,
    "DC5-C3'": 0.1698,
    "RG5-N9": 0.0492,
    "DGN-O5'": -0.18960000000000005,
    "RG3-O2P": -0.776,
    "RA5-C6": 0.7009,
    "RG5-N2": -0.09439999999999993,
    "DA-C2'": 0.0582,
    "DTN-O3'": -0.21530000000000005,
    "RC5-O2": -0.6252,
    "ASP-O": -0.5819,
    "SER-CA": 0.0594,
    "DT-O5'": -0.4954,
    "DT5-C2'": 0.0582,
    "RAN-N9": -0.0251,
    "DG5-O5'": -0.18960000000000005,
    "DC3-C1'": 0.1847,
    "RA5-H5T": 0.4295,
    "DG-C1'": 0.2104,
    "RAN-N6": -0.07890000000000008,
    "RAN-N7": -0.6073,
    "LYS-N": -0.07319999999999999,
    "SER-CB": 0.2821,
    "LYS-O": -0.5894,
    "DC-O3'": -0.5232,
    "RC-O2'": -0.19529999999999997,
    "RU-C1'": 0.24980000000000002,
    "RU3-O4": -0.5761,
    "DT3-C2'": 0.0582,
    "RU3-O2": -0.5477,
    "RA5-C1'": 0.24009999999999998,
    "DA3-C3'": 0.1698,
    "DT3-O5'": -0.4954,
    "DG5-C5'": 0.14389999999999997,
    "RG5-C2'": 0.1642,
    "RC-O4'": -0.3548,
    "DG5-H5T": 0.4422,
    "ASH-C": 0.5973,
    "DA5-H5T": 0.4422,
    "RU5-C4'": 0.2239,
    "RG5-C5'": 0.1916,
    "DC5-C2": 0.7959,
    "DAN-C4": 0.38,
    "DC3-N4": -0.11449999999999994,
    "DC5-C6": 0.211,
    "RU3-C4'": 0.2239,
    "DC5-C4": 0.8439,
    "DC5-C5": -0.3359,
    "RA3-C4'": 0.2239,
    "MET-O": -0.5679,
    "DG-O5'": -0.4954,
    "RG3-O2'": -0.19529999999999997,
    "DG5-N1": -0.1533,
    "DG5-N3": -0.6636,
    "DG5-N2": -0.07600000000000007,
    "DG5-N7": -0.5725,
    "DG5-N9": 0.0577,
    "RC-O3'": -0.5246,
    "RU3-C1'": 0.24980000000000002,
    "HIP-CE1": 0.2511,
    "DA5-O5'": -0.18960000000000005,
    "DC-C2'": 0.0582,
    "RUN-C6": 0.10619999999999999,
    "RUN-C5": -0.18239999999999998,
    "RUN-C4": 0.5952,
    "RA3-C8": 0.3559,
    "RUN-C2": 0.4687,
    "SER-N": -0.14380000000000004,
    "RA5-O5'": -0.19279999999999997,
    "RA3-C4": 0.3053,
    "RA3-C5": 0.0515,
    "RA3-C6": 0.7009,
    "SER-C": 0.5973,
    "LEU-CD1": -0.11210000000000003,
    "RCN-C4'": 0.2239,
    "RA3-C2": 0.6348,
    "LEU-CD2": -0.11210000000000003,
    "DA-C2": 0.6314,
    "DA5-N9": -0.0268,
    "DA-C6": 0.6897,
    "DG3-C6": 0.4918,
    "DA-C4": 0.38,
    "DA-C5": 0.0725,
    "DA5-N3": -0.7417,
    "DA-C8": 0.34840000000000004,
    "DCN-C4'": 0.28049999999999997,
    "DA5-N7": -0.6175,
    "DA5-N6": -0.07889999999999997,
    "RG-P": 1.1662,
    "DT3-C5'": 0.14389999999999997,
    "ALA-O": -0.5679,
    "ALA-C": 0.5973,
    "ASP-OD2": -0.8014,
    "ASP-OD1": -0.8014,
    "RCN-C3'": 0.2637,
    "RG5-N1": -0.13630000000000003,
    "HIE-CD2": -0.0345,
    "DCN-O4'": -0.3691,
    "PHE-CB": 0.0247,
    "GLU-OE1": -0.8188,
    "MET-SD": -0.2737,
    "RG5-O4'": -0.3548,
    "RC5-C4'": 0.2239,
    "RC5-C1'": 0.2095,
    "ILE-CG2": -0.055800000000000016,
    "LYS-NZ": 0.6346,
    "RG-C4'": 0.2239,
    "RU3-O4'": -0.3548,
    "RUN-O2'": -0.19529999999999997,
    "ILE-C": 0.5973,
    "RA-O3'": -0.5246,
    "RA-C2'": 0.1642,
    "ILE-CG1": 0.004200000000000002,
    "ILE-N": -0.14380000000000004,
    "ILE-O": -0.5679,
    "DAN-N3": -0.7417,
    "DAN-N1": -0.7624,
    "DAN-N6": -0.07889999999999997,
    "DAN-N7": -0.6175,
    "RCN-O3'": -0.21650000000000003,
    "RC5-C2": 0.7538,
    "DAN-N9": -0.0268,
    "RC5-C4": 0.8185,
    "RC5-C5": -0.3287,
    "RC5-C6": 0.2011,
    "RAN-O4'": -0.3548,
    "DT-O2P": -0.7761,
    "RU-C3'": 0.2637,
    "RG5-C8": 0.3014,
    "RG5-C4": 0.1222,
    "RG-C3'": 0.2637,
    "RG5-C6": 0.477,
    "RC3-C1'": 0.2095,
    "GLN-CD": 0.6951,
    "RC3-P": 1.1662,
    "DC3-C5'": 0.14389999999999997,
    "RA3-O2'": -0.19529999999999997,
    "DT5-C6": 0.039799999999999974,
    "RAN-C4'": 0.2239,
    "RC-C3'": 0.2637,
    "DTN-O4'": -0.3691,
    "DA-C5'": 0.14389999999999997,
    "RU3-C2": 0.4687,
    "RA3-O2P": -0.776,
    "RU3-C4": 0.5952,
    "RU3-C5": -0.18239999999999998,
    "RU3-C6": 0.10619999999999999,
    "RG3-C8": 0.3014,
    "RC5-O3'": -0.5246,
    "DT5-C5'": 0.14389999999999997,
    "RC-N4": -0.10619999999999996,
    "RG3-C2": 0.7657,
    "RCN-H5T": 0.4295,
    "RG3-C6": 0.477,
    "RG3-C4": 0.1222,
    "DC5-O5'": -0.18960000000000005,
    "DC3-C2'": 0.0582,
    "RAN-C2": 0.6348,
    "DG-C4'": 0.28049999999999997,
    "RAN-C6": 0.7009,
    "RAN-C5": 0.0515,
    "RAN-C4": 0.3053,
    "DG3-O4'": -0.3691,
    "RAN-C8": 0.3559,
    "DT-C5'": 0.14389999999999997,
    "DC3-O4'": -0.3691,
    "DGN-C4'": 0.28049999999999997,
    "ASN-OD1": -0.5931,
    "DAN-C5": 0.0725,
    "GLN-CG": 0.0059000000000000025,
    "RC-C4'": 0.2239,
    "DG3-C2": 0.7432,
    "DG3-C4": 0.1814,
    "DG3-C5": 0.1991,
    "DG5-C2'": 0.0582,
    "DC3-O3'": -0.21530000000000005,
    "DG3-C8": 0.2733,
    "RC5-O4'": -0.3548,
    "DA5-C2": 0.6314,
    "DAN-H5T": 0.4422,
    "LYS-CE": 0.2127,
    "ARG-NE": -0.18389999999999995,
    "DT-N3": -0.09199999999999997,
    "DT-N1": -0.0239,
    "DA5-C4": 0.38,
    "RG-O4'": -0.3548,
    "RUN-C5'": 0.1916,
    "CYX-SG": -0.1081,
    "HID-N": -0.14380000000000004,
    "TYR-CE1": -0.0685,
    "DA5-C6": 0.6897,
    "LYS-CD": 0.0763,
    "HIP-ND1": 0.2353,
    "RA3-C1'": 0.24009999999999998,
    "VAL-CG1": -0.08189999999999997,
    "DT3-C1'": 0.2484,
    "RUN-O5'": -0.19279999999999997,
    "DT5-O5'": -0.18960000000000005,
    "ASN-C": 0.5973,
    "RU3-C2'": 0.1642,
    "DC-C1'": 0.1847,
    "ILE-CD1": -0.010200000000000008,
    "RA5-O2'": -0.19529999999999997,
    "ASN-O": -0.5679,
    "RGN-O6": -0.5597,
    "ARG-C": 0.7341,
    "ARG-N": -0.07319999999999999,
    "ARG-O": -0.5894,
    "DAN-O3'": -0.21530000000000005,
    "RC5-O2'": -0.19529999999999997,
    "LYS-CB": 0.063,
    "DT5-H5T": 0.4422,
    "CYS-CB": 0.09929999999999999,
    "CYS-CA": 0.13369999999999999,
    "RA-N7": -0.6073,
    "RA-N6": -0.07890000000000008,
    "DCN-N3": -0.7748,
    "RA-N3": -0.6997,
    "RA-N1": -0.7615,
    "DT3-N1": -0.0239,
    "DTN-C3'": 0.1698,
    "RA-N9": -0.0251,
    "RGN-C2'": 0.1642,
    "DA3-N1": -0.7624,
    "DA3-N3": -0.7417,
    "DG3-P": 1.1659,
    "DA3-N7": -0.6175,
    "DA3-N6": -0.07889999999999997,
    "DA3-N9": -0.0268,
    "PHE-CD2": 0.007400000000000018,
    "DC-O2P": -0.7761,
    "DC5-C2'": 0.0582,
    "DCN-O3'": -0.21530000000000005,
    "TRP-CZ3": -0.05249999999999999,
    "RGN-H5T": 0.4295,
    "RA3-P": 1.1662,
    "RC3-O5'": -0.4989,
    "RG-N9": 0.0492,
    "DC5-C4'": 0.28049999999999997,
    "RGN-O5'": -0.19279999999999997,
    "PHE-CE2": -0.027400000000000008,
    "RU-O2P": -0.776,
    "RG-N1": -0.13630000000000003,
    "RG-N3": -0.6323,
    "RG-N2": -0.09439999999999993,
    "RG-N7": -0.5709,
    "PHE-CA": 0.0954,
    "DA-O5'": -0.4954,
    "DT5-N3": -0.09199999999999997,
    "PHE-CG": 0.0118,
    "DT5-N1": -0.0239,
    "DC3-N3": -0.7748,
    "RU5-O3'": -0.5246,
    "RA-C1'": 0.24009999999999998,
    "HIE-CG": 0.1868,
    "DC3-N1": -0.0339,
    "HIP-O": -0.5894,
    "HIP-N": -0.07319999999999999,
    "RG3-O6": -0.5597,
    "HIP-C": 0.7341,
    "DGN-O4'": -0.3691,
    "RUN-H5T": 0.4295,
    "HIE-CA": 0.07790000000000001,
    "RC5-N3": -0.7584,
    "RC5-N1": -0.0484,
    "DA-C1'": 0.2269,
    "ASN-N": -0.14380000000000004,
    "RAN-O3'": -0.21650000000000003,
    "RC5-N4": -0.10619999999999996,
    "ASN-ND2": -0.07990000000000008,
    "DA5-O3'": -0.5232,
    "MET-N": -0.14380000000000004,
    "DA3-O4'": -0.3691,
    "RU5-O4'": -0.3548,
    "DAN-C8": 0.34840000000000004,
    "TRP-CA": 0.0848,
    "TRP-CB": 0.0628,
    "VAL-CB": 0.2688,
    "DT-C1'": 0.2484,
    "TRP-CG": -0.1415,
    "RU3-N3": -0.03949999999999998,
    "RG3-O3'": -0.21650000000000003,
    "RU3-N1": 0.0418,
    "TYR-O": -0.5679,
    "TYR-N": -0.14380000000000004,
    "TYR-C": 0.5973,
    "VAL-O": -0.5679,
    "RA5-C2'": 0.1642,
    "DA3-C4'": 0.28049999999999997,
    "RC-P": 1.1662,
    "DT3-O4'": -0.3691,
    "HID-O": -0.5679,
    "RU5-C6": 0.10619999999999999,
    "RG5-C3'": 0.2637,
    "HID-C": 0.5973,
    "RCN-C5": -0.3287,
    "DT5-C1'": 0.2484,
    "RC5-C5'": 0.1916,
    "DC-O5'": -0.4954,
    "RG5-C1'": 0.2197,
    "DGN-C3'": 0.1698,
    "RC3-O2P": -0.776,
    "DAN-C2'": 0.0582,
    "DA-O4'": -0.3691,
    "DT-C4": 0.5194,
    "DT-C7": 0.00410000000000002,
    "DT-C6": 0.039799999999999974,
    "RG3-C2'": 0.1642,
    "RU3-P": 1.1662,
    "RA3-C5'": 0.1916,
    "DG-O4'": -0.3691,
    "RCN-C4": 0.8185,
    "DG-N9": 0.0577,
    "RGN-C5'": 0.1916,
    "DG-N3": -0.6636,
    "DG-N2": -0.07600000000000007,
    "DG-N1": -0.1533,
    "DG-N7": -0.5725,
    "HIP-CD2": 0.1176,
    "VAL-CG2": -0.08189999999999997,
    "DC-C5'": 0.14389999999999997,
    "DG3-O1P": -0.7761,
    "RU3-O1P": -0.776,
    "DA-O3'": -0.5232,
    "TRP-N": -0.14380000000000004,
    "TRP-O": -0.5679,
    "DA3-P": 1.1659,
    "RA3-C2'": 0.1642,
    "DA5-C5'": 0.14389999999999997,
    "DTN-N3": -0.09199999999999997,
    "MET-CB": 0.0824,
    "DTN-N1": -0.0239,
    "DG3-C3'": 0.1698,
    "DT3-C4'": 0.28049999999999997,
    "DC-C4": 0.8439,
    "DC-C5": -0.3359,
    "DC-C6": 0.211,
    "RC-N1": -0.0484,
    "RC3-N3": -0.7584,
    "DC-C2": 0.7959,
    "MET-CE": 0.1516,
    "LYS-CG": 0.0393,
    "DA-N7": -0.6175,
    "DA-N6": -0.07889999999999997,
    "DA-N1": -0.7624,
    "DA5-C5": 0.0725,
    "DA-N3": -0.7417,
    "LYS-CA": -0.09739999999999999,
    "DA5-C8": 0.34840000000000004,
    "RCN-C2'": 0.1642,
    "DA-N9": -0.0268,
    "RC3-O1P": -0.776,
    "RG5-H5T": 0.4295,
    "DC-P": 1.1659,
    "RU5-O2": -0.5477,
    "TRP-CZ2": -0.10289999999999999,
    "RU5-O4": -0.5761,
    "DCN-N1": -0.0339,
    "RG5-O5'": -0.19279999999999997,
    "RC-N3": -0.7584,
    "DG-P": 1.1659,
    "DT3-C2": 0.5677,
    "GLH-OE1": -0.5838,
    "RA-O2P": -0.776,
    "DT3-C7": 0.00410000000000002,
    "DT3-C6": 0.039799999999999974,
    "DT3-C5": 0.0025,
    "DT3-C4": 0.5194,
    "DCN-N4": -0.11449999999999994,
    "TYR-CD1": -0.020699999999999996,
    "RA-O2'": -0.19529999999999997,
    "HID-CD2": 0.2439,
    "DTN-O2": -0.5881,
    "RA-C5'": 0.1916,
    "THR-C": 0.5973,
    "DTN-O4": -0.5563,
    "THR-N": -0.14380000000000004,
    "THR-O": -0.5679,
    "DG5-C6": 0.4918,
    "DG5-C4": 0.1814,
    "DG5-C5": 0.1991,
    "DG5-C2": 0.7432,
    "DA5-C4'": 0.28049999999999997,
    "DT-O4": -0.5563,
    "RG-C2'": 0.1642,
    "ALA-CB": -0.0016000000000000042,
    "DG5-C8": 0.2733,
    "ALA-CA": 0.11599999999999999,
    "DC5-N1": -0.0339,
    "RU5-C1'": 0.24980000000000002,
    "DA5-N1": -0.7624,
    "RA3-O3'": -0.21650000000000003,
    "PRO-CD": 0.09740000000000001,
    "PRO-CG": 0.0615,
    "PRO-CA": 0.037500000000000006,
    "DT5-C7": 0.00410000000000002,
    "RC-C2'": 0.1642,
    "PRO-CB": 0.0436,
    "DA-C4'": 0.28049999999999997,
    "DTN-C5": 0.0025,
    "DTN-C6": 0.039799999999999974,
    "DTN-C7": 0.00410000000000002,
    "DTN-C2": 0.5677,
    "RU3-O2P": -0.776,
    "DT-O3'": -0.5232,
    "DT5-C4'": 0.28049999999999997,
    "CYX-CA": 0.1195,
    "DC-N4": -0.11449999999999994,
    "DC-N3": -0.7748,
    "PRO-C": 0.5896,
    "DC-N1": -0.0339,
    "ALA-N": -0.14380000000000004,
    "DC3-C3'": 0.1698,
    "HIE-N": -0.14380000000000004,
    "HIE-O": -0.5679,
    "RC3-O2": -0.6252,
    "HIE-C": 0.5973,
    "DG3-O5'": -0.4954,
    "RA-O5'": -0.4989,
    "RA5-N9": -0.0251,
    "RU3-O5'": -0.4989,
    "RA5-N7": -0.6073,
    "RA5-N6": -0.07890000000000008,
    "RA5-N1": -0.7615,
    "RA5-N3": -0.6997,
    "DC5-C1'": 0.1847,
    "CYM-CA": 0.0157,
    "DC-O1P": -0.7761,
    "DA3-C1'": 0.2269,
    "DT3-O3'": -0.21530000000000005,
    "RCN-O2'": -0.19529999999999997,
    "RC-C2": 0.7538,
    "DG5-C3'": 0.1698,
    "TRP-NE1": -0.0005999999999999894,
    "RC-C6": 0.2011,
    "RC-C4": 0.8185,
    "RC-C5": -0.3287,
    "CYM-CB": -0.0169,
    "LEU-CB": -0.018800000000000004,
    "TRP-CH2": 0.028299999999999992,
    "RG-O3'": -0.5246,
    "RU3-O2'": -0.19529999999999997,
    "ASP-CB": -0.054700000000000006,
    "HIP-CB": 0.12060000000000001,
    "HIP-CA": -0.01419999999999999,
    "ASP-CA": 0.1261,
    "HIP-CG": -0.0012,
    "ASP-CG": 0.7994,
    "DG3-O2P": -0.7761,
    "RU-N3": -0.03949999999999998,
    "RU-N1": 0.0418,
    "DA5-C1'": 0.2269,
    "DG-O3'": -0.5232,
    "DCN-C3'": 0.1698,
    "HIP-NE2": 0.2193,
    "RU-O1P": -0.776,
    "DT3-P": 1.1659,
    "DG-C2": 0.7432,
    "RUN-O4'": -0.3548,
    "DG-C4": 0.1814,
    "DT5-O4'": -0.3691,
    "DG-C6": 0.4918,
    "RU3-C3'": 0.2637,
    "DG-C8": 0.2733,
    "DA-P": 1.1659,
    "RU5-C5": -0.18239999999999998,
    "RU5-C2": 0.4687,
    "RA5-O3'": -0.5246,
    "RU-O3'": -0.5246,
    "RC3-C2'": 0.1642,
    "LYN-O": -0.5679,
    "RC-C5'": 0.1916,
    "GLU-O": -0.5819,
    "GLH-OE2": -0.187,
    "DT3-O4": -0.5563,
    "DT3-O2": -0.5881,
    "DG3-C4'": 0.28049999999999997,
    "RU5-H5T": 0.4295,
    "ARG-CZ": 0.8076,
    "RUN-C1'": 0.24980000000000002,
    "DC3-P": 1.1659,
    "ARG-CG": 0.096,
    "ARG-CD": 0.186,
    "ARG-CB": 0.06470000000000001,
    "ARG-CA": -0.10769999999999999,
    "DT-P": 1.1659,
    "RU-C2'": 0.1642,
    "DCN-O2": -0.6548,
    "PHE-CE1": -0.027400000000000008,
    "RG5-N7": -0.5709,
    "CYS-O": -0.5679,
    "RU5-C5'": 0.1916,
    "RCN-N3": -0.7584,
    "CYS-C": 0.5973,
    "RCN-N1": -0.0484,
    "RCN-N4": -0.10619999999999996,
    "DAN-C6": 0.6897,
    "RGN-O3'": -0.21650000000000003,
    "DGN-C8": 0.2733,
    "DGN-C6": 0.4918,
    "DGN-C5": 0.1991,
    "DGN-C4": 0.1814,
    "DGN-C2": 0.7432,
    "RGN-O4'": -0.3548,
    "RU-C5'": 0.1916,
    "RG-O6": -0.5597,
    "TYR-CD2": -0.020699999999999996,
    "PHE-CD1": 0.007400000000000018,
    "DT5-O3'": -0.5232,
    "DT5-O4": -0.5563,
    "CYX-N": -0.14380000000000004,
    "CYX-O": -0.5679,
    "DT5-O2": -0.5881,
    "CYX-C": 0.5973,
    "DT-C2'": 0.0582,
    "RG3-N9": 0.0492,
    "RG3-N7": -0.5709,
    "RG3-N1": -0.13630000000000003,
    "TYR-OH": -0.15869999999999995,
    "RG3-N3": -0.6323,
    "RG3-N2": -0.09439999999999993,
    "MET-CA": 0.0643,
    "RAN-C3'": 0.2637,
    "RU-O5'": -0.4989,
    "MET-CG": 0.08979999999999999,
    "RC3-C6": 0.2011,
    "RAN-O2'": -0.19529999999999997,
    "RC3-C4": 0.8185,
    "RC3-C5": -0.3287,
    "RC3-C2": 0.7538,
    "DA3-O5'": -0.4954,
    "HID-ND1": -0.016199999999999992,
    "RU5-O5'": -0.19279999999999997,
    "DAN-C3'": 0.1698,
    "DTN-C4": 0.5194,
    "DG-C3'": 0.1698,
    "PHE-O": -0.5679,
    "PHE-N": -0.14380000000000004,
    "RA3-O4'": -0.3548,
    "DTN-O5'": -0.18960000000000005,
    "PHE-C": 0.5973,
    "RG5-N3": -0.6323,
    "DA3-O3'": -0.21530000000000005,
    "DC3-C4": 0.8439,
    "DC3-C5": -0.3359,
    "DC3-C6": 0.211,
    "RG3-O4'": -0.3548,
    "DC3-C2": 0.7959,
    "DAN-C2": 0.6314,
    "RA-O1P": -0.776,
    "RC3-C5'": 0.1916,
    "RA5-C3'": 0.2637,
    "DA3-C5'": 0.14389999999999997,
    "TRP-CD1": 0.04239999999999999,
    "DC5-O3'": -0.5232,
    "TRP-CD2": 0.1243,
    "DA3-C6": 0.6897,
    "DA3-C4": 0.38,
    "DA3-C5": 0.0725,
    "DA3-C2": 0.6314,
    "DC-O4'": -0.3691,
    "LEU-CG": 0.317,
    "DA3-C8": 0.34840000000000004,
    "DGN-C2'": 0.0582,
    "DAN-C1'": 0.2269,
    "DG3-O6": -0.5699,
    "DG3-C2'": 0.0582,
    "DC3-O5'": -0.4954,
    "DTN-C4'": 0.28049999999999997,
    "GLN-OE1": -0.6086,
    "DC5-O2": -0.6548,
    "DC-C4'": 0.28049999999999997,
    "CYM-O": -0.5679,
    "RA-C4": 0.3053,
    "RA-C5": 0.0515,
    "RA-C6": 0.7009,
    "RA-C2": 0.6348,
    "HIE-NE2": 0.05439999999999995,
    "RG3-C4'": 0.2239,
    "RA3-C3'": 0.2637,
    "RA-C8": 0.3559,
    "LYN-CE": 0.25888,
    "LYN-CD": -0.014580000000000001,
    "LYN-CG": 0.08694,
    "RGN-C2": 0.7657,
    "RGN-C5": 0.1744,
    "RGN-C4": 0.1222,
    "RGN-C6": 0.477,
    "RA5-C4'": 0.2239,
    "RGN-C8": 0.3014,
    "RGN-N9": 0.0492,
    "RC-O2": -0.6252,
    "RCN-O5'": -0.19279999999999997,
    "GLH-CB": 0.0441,
    "GLH-CA": 0.0924,
    "GLH-CG": 0.0686,
    "RCN-C1'": 0.2095,
    "GLH-CD": 0.6801,
    "TYR-CB": 0.0438,
    "DA-O2P": -0.7761,
    "DAN-O5'": -0.18960000000000005,
    "RG-C6": 0.477,
    "RG-C4": 0.1222,
    "DC-C3'": 0.1698,
    "RG-C2": 0.7657,
    "RU5-C4": 0.5952,
    "RU-O2'": -0.19529999999999997,
    "RUN-N1": 0.0418,
    "GLH-O": -0.5679,
    "RUN-N3": -0.03949999999999998,
    "GLH-C": 0.5973,
    "RG5-O2'": -0.19529999999999997,
    "RG3-C3'": 0.2637,
    "DG-O6": -0.5699,
    "RC5-C2'": 0.1642,
    "DGN-N9": 0.0577,
    "SER-OG": -0.22709999999999997,
    "RC-O1P": -0.776,
    "RGN-C4'": 0.2239,
    "DGN-N7": -0.5725,
    "DGN-N1": -0.1533,
    "DGN-N2": -0.07600000000000007,
    "DGN-N3": -0.6636,
    "GLN-NE2": -0.09050000000000008,
    "DT3-N3": -0.09199999999999997,
    "RA-C4'": 0.2239,
    "ASN-CG": 0.713,
    "ASN-CA": 0.11910000000000001,
    "ASN-CB": -0.04470000000000002,
    "DGN-O3'": -0.21530000000000005,
    "CYS-SG": -0.11860000000000001,
    "GLY-N": -0.14380000000000004,
    "RG-O2'": -0.19529999999999997,
    "ARG-NH2": 0.03289999999999993,
    "RC3-O2'": -0.19529999999999997,
    "ARG-NH1": 0.03289999999999993,
    "RG-C1'": 0.2197,
    "RC3-C3'": 0.2637,
    "DG5-O3'": -0.5232,
    "RU5-C2'": 0.1642,
    "GLN-C": 0.5973,
    "DAN-C5'": 0.14389999999999997,
    "RG5-O6": -0.5597,
    "MET-C": 0.5973,
    "DC3-O2": -0.6548,
    "RC-C1'": 0.2095,
    "DA-C3'": 0.1698,
    "HIE-CB": 0.066,
    "RG-O2P": -0.776,
    "LYS-C": 0.7341,
    "DA3-O1P": -0.7761,
    "DC-O2": -0.6548,
    "DG3-O3'": -0.21530000000000005,
    "DT5-C3'": 0.1698,
    "DT-O4'": -0.3691,
    "DG5-O4'": -0.3691,
    "DC5-C5'": 0.14389999999999997,
    "TYR-CZ": 0.3226,
    "RC3-N1": -0.0484,
    "DA5-O4'": -0.3691,
    "HIE-CE1": 0.307,
    "RC3-N4": -0.10619999999999996,
    "RA-O4'": -0.3548,
    "DC5-H5T": 0.4422,
    "ASH-OD2": -0.16289999999999993,
    "ASH-OD1": -0.5554,
    "DT3-C3'": 0.1698,
    "CYS-N": -0.14380000000000004,
    "RUN-C3'": 0.2637,
    "DA3-C2'": 0.0582,
    "LYN-NZ": -0.26372999999999996,
    "DG5-C4'": 0.28049999999999997,
    "RUN-C4'": 0.2239,
    "RC-O5'": -0.4989,
    "RU-C2": 0.4687,
    "RAN-N1": -0.7615,
    "RU3-O3'": -0.21650000000000003,
    "DGN-C1'": 0.2104,
    "RU-C4": 0.5952,
    "RG5-C4'": 0.2239,
    "RU-C5": -0.18239999999999998,
    "GLY-CA": 0.1144,
    "RU-C6": 0.10619999999999999,
    "RU-O4": -0.5761,
    "DCN-C2'": 0.0582,
    "RU-O2": -0.5477,
    "DTN-C1'": 0.2484,
    "DG5-O6": -0.5699,
    "CYM-N": -0.14380000000000004,
    "CYM-C": 0.5973,
    "HIE-ND1": -0.5432,
    "RG3-O1P": -0.776,
    "DG-O2P": -0.7761,
    "RU5-N1": 0.0418,
    "TYR-CE2": -0.0685,
    "RA5-O4'": -0.3548,
    "GLY-C": 0.5973,
    "RCN-C5'": 0.1916,
    "GLY-O": -0.5679,
    "RAN-N3": -0.6997,
    "ASH-CB": 0.066,
    "HID-CG": -0.0266,
    "ASH-CA": 0.1205,
    "ASH-CG": 0.6462,
    "DCN-C5'": 0.14389999999999997,
    "DG3-C5'": 0.14389999999999997,
    "GLN-O": -0.5679,
    "GLN-N": -0.14380000000000004,
    "GLN-CA": 0.0819,
    "RG5-C5": 0.1744,
    "DC3-O1P": -0.7761,
    "DT3-O2P": -0.7761,
    "HID-CB": 0.0342,
}

amber_types = {
    "DC3-H3T": "HO",
    "RGN-O2'": "OH",
    "RAN-H5T": "HO",
    "RU-C4'": "CT",
    "DT-C3'": "CT",
    "RAN-C2'": "CT",
    "RU-O4'": "OS",
    "DTN-H2'1": "HC",
    "DTN-H2'2": "HC",
    "LYS-HB2": "HC",
    "DG3-H2'1": "HC",
    "DG3-H2'2": "HC",
    "ILE-HG23": "HC",
    "HID-NE2": "NB",
    "GLU-CD": "C",
    "GLU-CG": "CT",
    "GLU-CA": "CT",
    "GLU-CB": "CT",
    "DC3-H3'": "H1",
    "DT-H3": "H",
    "DG-O1P": "O2",
    "DA5-H1'": "H2",
    "RC5-O2'": "OH",
    "DCN-C2": "C",
    "DCN-C6": "CM",
    "DCN-C5": "CM",
    "DCN-C4": "CA",
    "CYX-CB": "CT",
    "HIE-ND1": "NB",
    "CYX-CA": "CT",
    "RU3-C2": "C",
    "RCN-O4'": "OS",
    "SER-HB2": "H1",
    "SER-HB3": "H1",
    "DC5-N4": "N2",
    "DC5-N1": "N*",
    "DC5-N3": "NC",
    "RC5-H5T": "HO",
    "DCN-C1'": "CT",
    "GLU-HG2": "HC",
    "RA5-C5'": "CT",
    "RGN-N7": "NB",
    "RGN-N2": "N2",
    "RGN-N3": "NC",
    "RGN-N1": "NA",
    "RGN-N9": "N*",
    "RUN-O2": "O",
    "DT5-H6": "H4",
    "DT5-H3": "H",
    "RG5-O3'": "OS",
    "RA3-O1P": "O2",
    "DTN-C2'": "CT",
    "DTN-H5T": "HO",
    "TYR-HE2": "HA",
    "TYR-HE1": "HA",
    "RCN-C5": "CM",
    "RCN-C4": "CA",
    "RCN-C6": "CM",
    "RCN-C2": "C",
    "CYM-HB3": "H1",
    "CYM-HB2": "H1",
    "RA3-HO'2": "HO",
    "DC3-C1'": "CT",
    "DT5-H2'1": "HC",
    "DT5-H2'2": "HC",
    "RU3-O4": "O",
    "DT3-C2'": "CT",
    "RU3-O2": "O",
    "VAL-HA": "H1",
    "VAL-HB": "HC",
    "PRO-HA": "H1",
    "DG5-H5T": "HO",
    "RG5-C5'": "CT",
    "DA-O5'": "OS",
    "RG3-C1'": "CT",
    "RU-HO'2": "HO",
    "DG5-N1": "NA",
    "DG5-N3": "NC",
    "DG5-N2": "N2",
    "DG5-N7": "NB",
    "DG5-N9": "N*",
    "RUN-C1'": "CT",
    "RA5-O5'": "OH",
    "RCN-C4'": "CT",
    "DA5-N9": "N*",
    "DG3-C6": "C",
    "DA5-N3": "NC",
    "DA5-N1": "NC",
    "DA5-N7": "NB",
    "DA5-N6": "N2",
    "RG-P": "P",
    "ILE-HG21": "HC",
    "ILE-HG22": "HC",
    "RC3-H5'1": "H1",
    "RC3-H5'2": "H1",
    "DA-H2": "H5",
    "DA-H8": "H5",
    "RAN-H61": "H",
    "RAN-H62": "H",
    "DAN-N3": "NC",
    "DAN-N1": "NC",
    "DAN-N6": "N2",
    "DAN-N7": "NB",
    "RC3-H1'": "H2",
    "LYS-HE2": "HP",
    "RU-C2": "C",
    "DAN-N9": "N*",
    "RU-C4": "C",
    "RU-C5": "CM",
    "RU-C6": "CM",
    "RC5-H42": "H",
    "RC5-H41": "H",
    "DA-C5'": "CT",
    "RC5-O3'": "OS",
    "RC5-H4'": "H1",
    "RA-H1'": "H2",
    "RU3-O4'": "OS",
    "MET-HE1": "H1",
    "DG-H1'": "H2",
    "MET-HE2": "H1",
    "RCN-O3'": "OH",
    "ARG-NE": "N2",
    "DT-H6": "H4",
    "DCN-H42": "H",
    "DA5-H2'2": "HC",
    "DC-C1'": "CT",
    "RAN-H2'1": "H1",
    "RGN-O6": "O",
    "RU3-H5'2": "H1",
    "RU3-H5'1": "H1",
    "DT3-C1'": "CT",
    "RA-N7": "NB",
    "DCN-N1": "N*",
    "DCN-N3": "NC",
    "DCN-N4": "N2",
    "RA-N1": "NC",
    "DTN-C3'": "CT",
    "RA-N9": "N*",
    "LEU-CG": "CT",
    "LEU-CA": "CT",
    "LEU-CB": "CT",
    "HIP-HB3": "HC",
    "HIP-HB2": "HC",
    "DTN-H4'": "H1",
    "RG3-O6": "O",
    "ASN-ND2": "N",
    "DT-H4'": "H1",
    "DC5-H1'": "H2",
    "DG5-H4'": "H1",
    "RU3-N3": "NA",
    "RU3-N1": "N*",
    "DGN-C3'": "CT",
    "DA-O4'": "OS",
    "RG3-C2'": "CT",
    "RU3-P": "P",
    "THR-HG23": "HC",
    "THR-HG21": "HC",
    "LYS-C": "C",
    "LYS-N": "N",
    "LYS-O": "O",
    "LYS-H": "H",
    "DG3-O1P": "O2",
    "DAN-H1'": "H2",
    "DA5-C2": "CQ",
    "DA5-C4": "CB",
    "DA5-C5": "CB",
    "DA5-C6": "CA",
    "DA5-C8": "CK",
    "RC3-O1P": "O2",
    "ASP-HB2": "HC",
    "ASP-HB3": "HC",
    "RC-N3": "NC",
    "DC3-H1'": "H2",
    "RG5-H5T": "HO",
    "LYS-HD2": "HC",
    "LYS-HD3": "HC",
    "DG5-C6": "C",
    "DG5-C4": "CB",
    "CYM-CB": "CT",
    "DG5-C2": "CA",
    "DG5-C8": "CK",
    "DT5-C5": "CM",
    "DTN-C4": "C",
    "DTN-C5": "CM",
    "DTN-C6": "CM",
    "DT5-C6": "CM",
    "DTN-C2": "C",
    "RU-H5'2": "H1",
    "RU-H5'1": "H1",
    "DG-H21": "H",
    "DG-H22": "H",
    "DA3-H1'": "H2",
    "ILE-HD12": "HC",
    "ILE-HD13": "HC",
    "ILE-HD11": "HC",
    "RU5-H1'": "H2",
    "DG-C3'": "CT",
    "RA5-N9": "N*",
    "RU3-O5'": "OS",
    "RA5-N7": "NB",
    "RA5-N6": "N2",
    "RA5-N1": "NC",
    "RA5-N3": "NC",
    "RCN-O2'": "OH",
    "RC-H5'1": "H1",
    "RC-H5'2": "H1",
    "HIE-CD2": "CW",
    "HIP-CB": "CT",
    "HIP-CA": "CT",
    "HIP-CG": "CC",
    "RU-N3": "NA",
    "RU-N1": "N*",
    "DG-O3'": "OS",
    "DCN-C3'": "CT",
    "DA-P": "P",
    "DTN-H3T": "HO",
    "DG3-C4'": "CT",
    "RU-H3'": "H1",
    "ARG-CZ": "CA",
    "ARG-CG": "CT",
    "DA-H3'": "H1",
    "ARG-CB": "CT",
    "ARG-CA": "CT",
    "GLU-HG3": "HC",
    "DCN-O2": "O",
    "DCN-H4'": "H1",
    "DA5-H2'1": "HC",
    "DCN-H41": "H",
    "TRP-HZ3": "HA",
    "DTN-H3'": "H1",
    "DG5-H5'1": "H1",
    "DG5-H5'2": "H1",
    "RG3-N9": "N*",
    "LYN-HZ3": "H",
    "LYN-HZ2": "H",
    "RG3-N7": "NB",
    "RG3-N1": "NA",
    "RG3-N3": "NC",
    "RG3-N2": "N2",
    "DC3-H2'1": "HC",
    "DC3-H2'2": "HC",
    "TRP-CD2": "CB",
    "DT-H71": "HC",
    "DT-H72": "HC",
    "DT-H73": "HC",
    "DA3-O3'": "OH",
    "RGN-H21": "H",
    "ASP-HA": "H1",
    "ARG-HB2": "HC",
    "ARG-HB3": "HC",
    "RU3-HO'2": "HO",
    "DC5-O3'": "OS",
    "DT3-H72": "HC",
    "DT3-H73": "HC",
    "RCN-HO'2": "HO",
    "DT3-H71": "HC",
    "DG3-O6": "O",
    "DGN-C2'": "CT",
    "TRP-HH2": "HA",
    "RG3-C3'": "CT",
    "RC-C5'": "CT",
    "RUN-C3'": "CT",
    "VAL-HG23": "HC",
    "VAL-HG22": "HC",
    "VAL-HG21": "HC",
    "RG-C8": "CK",
    "RG-C6": "C",
    "RG-C4": "CB",
    "RG-C5": "CB",
    "RG-C2": "CA",
    "GLH-H": "H",
    "GLH-O": "O",
    "GLH-N": "N",
    "GLH-C": "C",
    "RUN-O4": "O",
    "RU-C1'": "CT",
    "RU3-C4'": "CT",
    "GLN-NE2": "N",
    "LYS-HG3": "HC",
    "LYS-HG2": "HC",
    "HIE-HE1": "H5",
    "HIE-HE2": "H",
    "GLN-HA": "H1",
    "ILE-HG13": "HC",
    "ILE-HG12": "HC",
    "RC3-H3'": "H1",
    "RC3-O2'": "OH",
    "LYS-HZ1": "H",
    "GLN-HB3": "HC",
    "GLN-HB2": "HC",
    "DA5-H61": "H",
    "DAN-C5'": "CT",
    "DG-H3'": "H1",
    "HIE-CG": "CC",
    "HIE-CA": "CT",
    "HIE-CB": "CT",
    "DA3-O1P": "O2",
    "RC3-O2P": "O2",
    "RA-H3'": "H1",
    "LEU-HD11": "HC",
    "LEU-HD12": "HC",
    "LEU-HD13": "HC",
    "RC3-H3T": "HO",
    "RG3-H2'1": "H1",
    "RU3-H3'": "H1",
    "DAN-H2'2": "HC",
    "RG3-HO'2": "HO",
    "HIE-CE1": "CR",
    "TYR-HB2": "HC",
    "DC-H5": "HA",
    "DC-H6": "H4",
    "RCN-H5'2": "H1",
    "RCN-H5'1": "H1",
    "RU-O4": "O",
    "DCN-C2'": "CT",
    "RU-O2": "O",
    "DTN-C1'": "CT",
    "CYM-O": "O",
    "CYM-N": "N",
    "DG5-C5": "CB",
    "CYM-C": "C",
    "DG-O2P": "O2",
    "RAN-H2": "H5",
    "GLY-C": "C",
    "GLY-N": "N",
    "GLY-O": "O",
    "GLY-H": "H",
    "ASH-CB": "CT",
    "ASH-CA": "CT",
    "ASH-CG": "C",
    "DG3-C5'": "CT",
    "DCN-H6": "H4",
    "DCN-H5": "HA",
    "RG-O5'": "OS",
    "ASH-HB2": "HC",
    "ASH-HB3": "HC",
    "RG-C5'": "CT",
    "RG3-H4'": "H1",
    "THR-CA": "CT",
    "THR-CB": "CT",
    "RCN-H4'": "H1",
    "ASH-HA": "H1",
    "RCN-H41": "H",
    "DC3-C4'": "CT",
    "RCN-H42": "H",
    "DCN-H5T": "HO",
    "DC-H2'1": "HC",
    "DC-H2'2": "HC",
    "RC-C4'": "CT",
    "RA5-HO'2": "HO",
    "CYM-SG": "SH",
    "DC5-O4'": "OS",
    "VAL-C": "C",
    "DG-C5'": "CT",
    "DG3-N9": "N*",
    "DG3-N3": "NC",
    "DG3-N2": "N2",
    "DG3-N1": "NA",
    "VAL-H": "H",
    "DG3-N7": "NB",
    "VAL-N": "N",
    "DGN-C5'": "CT",
    "DT3-O1P": "O2",
    "DG5-C1'": "CT",
    "RUN-C2'": "CT",
    "GLU-C": "C",
    "DT-O1P": "O2",
    "GLU-H": "H",
    "GLU-N": "N",
    "GLU-O": "O",
    "RU3-C5'": "CT",
    "DA3-O2P": "O2",
    "DGN-H8": "H5",
    "DGN-H1": "H",
    "DAN-O4'": "OS",
    "RA3-H5'2": "H1",
    "RA3-H5'1": "H1",
    "DT-C2": "C",
    "CYX-HB2": "H1",
    "CYX-HB3": "H1",
    "RAN-H1'": "H2",
    "RC3-O3'": "OH",
    "RA3-C5'": "CT",
    "VAL-HG12": "HC",
    "VAL-HG13": "HC",
    "RU5-O2'": "OH",
    "VAL-HG11": "HC",
    "DAN-C4'": "CT",
    "DGN-O5'": "OH",
    "DA-C2'": "CT",
    "RC5-O2": "O",
    "DA3-H3'": "H1",
    "RA-H4'": "H1",
    "RU5-H3'": "H1",
    "HIE-HD2": "H4",
    "DT-O5'": "OS",
    "RC-HO'2": "HO",
    "RA5-C1'": "CT",
    "DA3-H3T": "HO",
    "RC-H3'": "H1",
    "RC-O4'": "OS",
    "HID-HB3": "HC",
    "HID-HB2": "HC",
    "DA5-H5T": "HO",
    "RC-H5": "HA",
    "DC5-C4'": "CT",
    "DAN-C4": "CB",
    "DAN-C6": "CA",
    "DAN-C2": "CQ",
    "MET-N": "N",
    "MET-O": "O",
    "RU-H5": "HA",
    "DG-O5'": "OS",
    "RU-H6": "H4",
    "RA5-H5T": "HO",
    "DC-C2'": "CT",
    "RUN-C6": "CM",
    "RUN-C5": "CM",
    "RUN-C4": "C",
    "RUN-C2": "C",
    "LEU-CD1": "CT",
    "RA3-H61": "H",
    "RA3-H62": "H",
    "LEU-CD2": "CT",
    "DTN-O2": "O",
    "DTN-O4": "O",
    "DG3-C2'": "CT",
    "ALA-N": "N",
    "ALA-O": "O",
    "ALA-H": "H",
    "DA-H1'": "H2",
    "ALA-C": "C",
    "RU5-H6": "H4",
    "RU5-H5": "HA",
    "RU5-H3": "H",
    "DTN-H1'": "H2",
    "DA-H62": "H",
    "RG-C4'": "CT",
    "RA-O3'": "OS",
    "THR-HG1": "HO",
    "DTN-N1": "N*",
    "DT-O2P": "O2",
    "DT-H1'": "H2",
    "RC3-P": "P",
    "DC3-C5'": "CT",
    "RC-C3'": "CT",
    "DTN-O4'": "OS",
    "ARG-HD2": "H1",
    "ARG-HD3": "H1",
    "RU3-C4": "C",
    "RU3-C5": "CM",
    "RU3-C6": "CM",
    "DT3-H1'": "H2",
    "DT5-C5'": "CT",
    "DC-C5": "CM",
    "RCN-H5T": "HO",
    "DC5-O5'": "OH",
    "DG-C4'": "CT",
    "DG3-O4'": "OS",
    "DC-C2": "C",
    "DGN-C4'": "CT",
    "DG3-C2": "CA",
    "DG3-C4": "CB",
    "DG3-C5": "CB",
    "DG5-C2'": "CT",
    "DG3-C8": "CK",
    "LYS-CE": "CT",
    "RUN-C5'": "CT",
    "RUN-O5'": "OH",
    "DT5-O5'": "OH",
    "ASN-C": "C",
    "RU3-C2'": "CT",
    "ASN-H": "H",
    "ASN-N": "N",
    "ASN-O": "O",
    "DAN-O3'": "OH",
    "RA5-H5'1": "H1",
    "DA3-P": "P",
    "RA5-H5'2": "H1",
    "DC3-O2": "O",
    "DCN-H2'2": "HC",
    "DCN-H2'1": "HC",
    "DA3-H5'1": "H1",
    "RU-C3'": "CT",
    "DG3-P": "P",
    "DA5-H62": "H",
    "RG-H2'1": "H1",
    "RGN-O5'": "OH",
    "PHE-CZ": "CA",
    "PHE-CA": "CT",
    "PHE-CB": "CT",
    "RGN-H22": "H",
    "PHE-CG": "CA",
    "RU5-O3'": "OS",
    "RU-H4'": "H1",
    "DGN-O4'": "OS",
    "DA-C3'": "CT",
    "RC5-N3": "NC",
    "RC5-N1": "N*",
    "DA-C1'": "CT",
    "RAN-O3'": "OH",
    "RC5-N4": "N2",
    "DA5-O3'": "OS",
    "DA5-H4'": "H1",
    "TRP-CA": "CT",
    "TRP-CB": "CT",
    "TRP-CG": "C*",
    "RA5-C2'": "CT",
    "HIP-HA": "H1",
    "RC-P": "P",
    "RU3-H1'": "H2",
    "DC-O2": "O",
    "DC-O5'": "OS",
    "DC5-C5'": "CT",
    "DT-C5": "CM",
    "DT-C4": "C",
    "DT-C7": "CT",
    "DT-C6": "CM",
    "GLU-HB2": "HC",
    "GLU-HB3": "HC",
    "DG-O4'": "OS",
    "DT3-C5": "CM",
    "VAL-CG2": "CT",
    "DC-C5'": "CT",
    "RA3-C2'": "CT",
    "DA-H61": "H",
    "DTN-N3": "NA",
    "ILE-CD1": "CT",
    "DG3-C3'": "CT",
    "DA5-O4'": "OS",
    "DC3-O4'": "OS",
    "RU5-O2": "O",
    "RU5-O4": "O",
    "DT3-C2": "C",
    "RA-O2P": "O2",
    "DT3-C7": "CT",
    "DT3-C6": "CM",
    "RGN-C5'": "CT",
    "DT3-C4": "C",
    "RA-O2'": "OH",
    "THR-C": "C",
    "THR-H": "H",
    "THR-N": "N",
    "THR-O": "O",
    "DA-C4": "CB",
    "DC3-H5'1": "H1",
    "PRO-CD": "CT",
    "PRO-CG": "CT",
    "PRO-CA": "CT",
    "RC-C2'": "CT",
    "PRO-CB": "CT",
    "DTN-O5'": "OH",
    "PHE-HB3": "HC",
    "DC-H5'2": "H1",
    "DC-H5'1": "H1",
    "DT-O3'": "OS",
    "DT5-C4'": "CT",
    "DA3-C2'": "CT",
    "DG3-O5'": "OS",
    "DAN-H5'2": "H1",
    "DT3-O3'": "OH",
    "DG5-C3'": "CT",
    "TRP-CH2": "CA",
    "RU5-H2'1": "H1",
    "RG-O3'": "OS",
    "DAN-H2'1": "HC",
    "ASP-CB": "CT",
    "ASP-CA": "CT",
    "ASP-CG": "C",
    "LYN-HG2": "HC",
    "LYN-HG3": "HC",
    "ARG-HG3": "HC",
    "ARG-HG2": "HC",
    "DG-C2": "CA",
    "RUN-O4'": "OS",
    "DG-C4": "CB",
    "DT5-O4'": "OS",
    "DG-C6": "C",
    "RU3-C3'": "CT",
    "DG-C8": "CK",
    "RA-H5'2": "H1",
    "RA-H5'1": "H1",
    "RGN-H3T": "HO",
    "CYS-HB3": "H1",
    "CYS-HB2": "H1",
    "RC-O5'": "OS",
    "DT-P": "P",
    "RU-C2'": "CT",
    "GLH-HE2": "HO",
    "RGN-H3'": "H1",
    "RGN-O4'": "OS",
    "GLN-HG2": "HC",
    "CYX-H": "H",
    "CYX-N": "N",
    "CYX-O": "O",
    "CYX-C": "C",
    "PRO-HG2": "HC",
    "PRO-HG3": "HC",
    "RAN-O2'": "OH",
    "LEU-HD21": "HC",
    "LEU-HD23": "HC",
    "LEU-HD22": "HC",
    "RAN-H3'": "H1",
    "RA-H62": "H",
    "RC3-H4'": "H1",
    "RC3-H41": "H",
    "HIE-HB2": "HC",
    "HIE-HB3": "HC",
    "DC3-C4": "CA",
    "DC3-C5": "CM",
    "DC3-C6": "CM",
    "DC5-H6": "H4",
    "DC5-H5": "HA",
    "RU5-H5T": "HO",
    "RA5-C3'": "CT",
    "RAN-H3T": "HO",
    "RC5-O4'": "OS",
    "HID-HD2": "H4",
    "HID-HD1": "H",
    "MET-HA": "H1",
    "PHE-HB2": "HC",
    "DC3-O5'": "OS",
    "RGN-H1": "H",
    "DTN-C4'": "CT",
    "RGN-H8": "H5",
    "RA3-H4'": "H1",
    "DC-C4'": "CT",
    "RC-H1'": "H2",
    "RA-C5": "CB",
    "RA-C6": "CA",
    "RA-C2": "CQ",
    "RA3-C3'": "CT",
    "RA-C8": "CK",
    "GLH-CB": "CT",
    "GLH-CA": "CT",
    "GLH-CG": "CT",
    "GLH-CD": "C",
    "DC3-C3'": "CT",
    "RU5-N1": "N*",
    "RU5-N3": "NA",
    "DC-C3'": "CT",
    "RGN-C4'": "CT",
    "RG3-H5'1": "H1",
    "RG3-H5'2": "H1",
    "RC5-HO'2": "HO",
    "RG-O2'": "OH",
    "LEU-HA": "H1",
    "ARG-NH1": "N2",
    "LEU-HG": "HC",
    "RCN-H3'": "H1",
    "DT-H3'": "H1",
    "RC-C1'": "CT",
    "RG-O2P": "O2",
    "RU3-H3T": "HO",
    "DT3-H3'": "H1",
    "RCN-H3T": "HO",
    "DT-O4'": "OS",
    "ASN-HA": "H1",
    "RU-O1P": "O2",
    "DGN-H1'": "H2",
    "DG3-H3'": "H1",
    "DG5-C4'": "CT",
    "LYS-HE3": "HP",
    "RUN-C4'": "CT",
    "TRP-HB2": "HC",
    "TRP-HB3": "HC",
    "DC5-H3'": "H1",
    "LYN-HD3": "HC",
    "LYN-HD2": "HC",
    "GLY-CA": "CT",
    "RG3-O1P": "O2",
    "GLN-C": "C",
    "RA-O1P": "O2",
    "GLN-H": "H",
    "GLN-O": "O",
    "GLN-N": "N",
    "GLN-CA": "CT",
    "RG5-C5": "CB",
    "LEU-HB2": "HC",
    "DG3-H3T": "HO",
    "DT3-O2P": "O2",
    "RC3-C1'": "CT",
    "GLN-CG": "CT",
    "ALA-HB2": "HC",
    "ALA-HB3": "HC",
    "ALA-HB1": "HC",
    "PRO-HD3": "H1",
    "PRO-HD2": "H1",
    "GLU-HA": "H1",
    "RU-P": "P",
    "RAN-O5'": "OH",
    "DA3-H4'": "H1",
    "VAL-CA": "CT",
    "RU5-H4'": "H1",
    "RAN-C5'": "CT",
    "VAL-CB": "CT",
    "RA-P": "P",
    "RC5-O5'": "OH",
    "RA3-H3T": "HO",
    "HID-HE1": "H5",
    "DC5-H2'2": "HC",
    "DC5-H2'1": "HC",
    "DT-C4'": "CT",
    "DC3-O2P": "O2",
    "DA-H4'": "H1",
    "RC5-H5'2": "H1",
    "RC5-H5'1": "H1",
    "HID-CE1": "CR",
    "DTN-C5'": "CT",
    "DT-O4": "O",
    "DT5-C2": "C",
    "RA3-H3'": "H1",
    "DT5-C4": "C",
    "DT5-C7": "CT",
    "DT-O2": "O",
    "DTN-H3": "H",
    "DTN-H6": "H4",
    "DG3-C1'": "CT",
    "GLU-OE2": "O2",
    "GLU-OE1": "O2",
    "RUN-H5'1": "H1",
    "RUN-H5'2": "H1",
    "DT5-H3'": "H1",
    "DCN-H1'": "H2",
    "RG-O1P": "O2",
    "ALA-HA": "H1",
    "DG-C5": "CB",
    "ILE-HB": "HC",
    "ILE-HA": "H1",
    "RGN-C3'": "CT",
    "TYR-HB3": "HC",
    "RCN-H5": "HA",
    "RCN-H6": "H4",
    "HID-CG": "CC",
    "HID-CB": "CT",
    "HID-CA": "CT",
    "ASN-HB2": "HC",
    "ASN-HB3": "HC",
    "RUN-H6": "H4",
    "RUN-H5": "HA",
    "RUN-H3": "H",
    "DG-H5'2": "H1",
    "RC3-H5": "HA",
    "RG3-O2P": "O2",
    "DTN-O3'": "OH",
    "SER-CA": "CT",
    "SER-CB": "CT",
    "DT5-C2'": "CT",
    "DG5-O5'": "OH",
    "DGN-H21": "H",
    "DGN-H22": "H",
    "DG-C1'": "CT",
    "RG-H4'": "H1",
    "DT3-O5'": "OS",
    "DG5-C5'": "CT",
    "LYN-HE2": "HP",
    "LYN-HE3": "HP",
    "RG5-C2'": "CT",
    "DG3-H21": "H",
    "DG3-H22": "H",
    "MET-HE3": "H1",
    "RG3-O2'": "OH",
    "DT5-H1'": "H2",
    "RU3-C1'": "CT",
    "VAL-CG1": "CT",
    "RA3-C8": "CK",
    "RA3-C4": "CB",
    "RA3-C5": "CB",
    "RA3-C6": "CA",
    "RA3-C2": "CQ",
    "RG5-HO'2": "HO",
    "DA-C2": "CQ",
    "DC3-P": "P",
    "DA-C6": "CA",
    "DA5-C4'": "CT",
    "DA-C5": "CB",
    "DC3-H5'2": "H1",
    "DA-C8": "CK",
    "DT3-C5'": "CT",
    "RCN-C3'": "CT",
    "RC3-H2'1": "H1",
    "RG5-H5'2": "H1",
    "RG5-H5'1": "H1",
    "GLN-HG3": "HC",
    "RGN-H1'": "H2",
    "RC5-C4'": "CT",
    "DT-N1": "N*",
    "RC5-C2": "C",
    "RC5-C4": "CA",
    "RC5-C5": "CM",
    "RC5-C6": "CM",
    "RAN-O4'": "OS",
    "RA5-H8": "H5",
    "RG5-C8": "CK",
    "RG5-C4": "CB",
    "RA5-H2": "H5",
    "RG5-C6": "C",
    "GLN-CB": "CT",
    "GLN-CD": "C",
    "RG5-C2": "CA",
    "RUN-H1'": "H2",
    "GLH-HG2": "HC",
    "GLH-HG3": "HC",
    "RG5-H4'": "H1",
    "RAN-C4'": "CT",
    "RG3-H1'": "H2",
    "RAN-C2": "CQ",
    "RAN-C6": "CA",
    "RAN-C5": "CB",
    "RAN-C4": "CB",
    "HIE-HA": "H1",
    "RC3-H6": "H4",
    "DG-H5'1": "H1",
    "RAN-C8": "CK",
    "RGN-H5'2": "H1",
    "LYS-HB3": "HC",
    "RGN-H5'1": "H1",
    "DT-C5'": "CT",
    "LEU-HB3": "HC",
    "ASN-OD1": "O",
    "RC5-H3'": "H1",
    "DC3-O3'": "OH",
    "LYN-HA": "H1",
    "HID-CD2": "CV",
    "ILE-CG2": "CT",
    "DT-N3": "NA",
    "ILE-CG1": "CT",
    "DC-H1'": "H2",
    "DCN-H5'1": "H1",
    "DCN-H5'2": "H1",
    "RA3-C1'": "CT",
    "RG-HO'2": "HO",
    "ASN-HD21": "H",
    "CYS-CB": "CT",
    "CYS-CA": "CT",
    "ASN-HD22": "H",
    "DT3-N1": "N*",
    "DT3-N3": "NA",
    "RGN-C2'": "CT",
    "DCN-O3'": "OH",
    "PHE-CE1": "CA",
    "PHE-CE2": "CA",
    "DGN-H3T": "HO",
    "RCN-H1'": "H2",
    "DT5-N1": "N*",
    "DGN-H3'": "H1",
    "RU-O3'": "OS",
    "RG3-H8": "H5",
    "RG3-H1": "H",
    "RG3-O3'": "OH",
    "TYR-H": "H",
    "TYR-O": "O",
    "TYR-N": "N",
    "RA5-H2'1": "H1",
    "TYR-C": "C",
    "VAL-O": "O",
    "DG3-H1'": "H2",
    "DT3-O4'": "OS",
    "LYN-HB3": "HC",
    "LYN-HB2": "HC",
    "RG5-C3'": "CT",
    "DT5-C1'": "CT",
    "THR-CG2": "CT",
    "DG-N9": "N*",
    "DG-N3": "NC",
    "DG-N2": "N2",
    "DG-N1": "NA",
    "DG-N7": "NB",
    "DAN-H62": "H",
    "DAN-H61": "H",
    "DA-O3'": "OS",
    "TRP-N": "N",
    "TRP-O": "O",
    "TRP-H": "H",
    "DA5-C5'": "CT",
    "MET-CB": "CT",
    "TRP-C": "C",
    "DT3-C4'": "CT",
    "RU-O5'": "OS",
    "DA-N7": "NB",
    "DA-N6": "N2",
    "DA-N1": "NC",
    "DA-N3": "NC",
    "RCN-C2'": "CT",
    "DA-N9": "N*",
    "CYM-HA": "H1",
    "CYM-HN": "H",
    "RAN-H8": "H5",
    "PRO-HB3": "HC",
    "PRO-HB2": "HC",
    "RA-N6": "N2",
    "DC3-C2": "C",
    "RC5-C5'": "CT",
    "DA5-H8": "H5",
    "RA-N3": "NC",
    "DA5-H2": "H5",
    "RA-H61": "H",
    "DT-H2'1": "HC",
    "DT-H2'2": "HC",
    "RUN-O3'": "OH",
    "RC3-C2'": "CT",
    "RU5-C1'": "CT",
    "RG5-H3'": "H1",
    "TRP-CD1": "CW",
    "RU3-O2P": "O2",
    "DC-N4": "N2",
    "DC-N3": "NC",
    "DC-N1": "N*",
    "HIE-H": "H",
    "HIE-N": "N",
    "HIE-O": "O",
    "RC3-O2": "O",
    "GLY-HA3": "H1",
    "GLY-HA2": "H1",
    "RC3-H42": "H",
    "DC5-C1'": "CT",
    "DC-O1P": "O2",
    "DA3-C1'": "CT",
    "RC-C2": "C",
    "RC-C6": "CM",
    "RC-C4": "CA",
    "RC-C5": "CM",
    "DGN-H2'2": "HC",
    "DGN-H2'1": "HC",
    "RA3-H1'": "H2",
    "RU3-O2'": "OH",
    "RC-H4'": "H1",
    "RC-H41": "H",
    "RC-H42": "H",
    "RGN-C1'": "CT",
    "RA-H2": "H5",
    "RU5-C6": "CM",
    "RU5-C4": "C",
    "RU5-C5": "CM",
    "RU5-C2": "C",
    "RA-H8": "H5",
    "DCN-H3'": "H1",
    "DT3-O4": "O",
    "DT3-O2": "O",
    "RC5-H2'1": "H1",
    "CYS-H": "H",
    "CYS-O": "O",
    "CYS-N": "N",
    "RCN-N3": "NC",
    "CYS-C": "C",
    "RCN-N1": "N*",
    "RCN-N4": "N2",
    "CYX-HA": "H1",
    "LYS-HA": "H1",
    "GLH-HA": "H1",
    "PHE-CD2": "CA",
    "DCN-H3T": "HO",
    "PHE-CD1": "CA",
    "DG5-H2'2": "HC",
    "DT5-O4": "O",
    "DG5-H2'1": "HC",
    "DT5-O2": "O",
    "RG5-H2'1": "H1",
    "DGN-H4'": "H1",
    "RGN-HO'2": "HO",
    "DA-H2'2": "HC",
    "DA-H2'1": "HC",
    "HIP-HD2": "H4",
    "HIP-HD1": "H",
    "DAN-C3'": "CT",
    "PHE-H": "H",
    "PHE-O": "O",
    "PHE-N": "N",
    "RA3-O4'": "OS",
    "PHE-C": "C",
    "DT5-N3": "NA",
    "DA3-C6": "CA",
    "RG3-O4'": "OS",
    "DT3-H2'2": "HC",
    "DT3-H2'1": "HC",
    "DA3-C5": "CB",
    "RG-H22": "H",
    "RG-H21": "H",
    "DC-O4'": "OS",
    "LYS-HZ2": "H",
    "LYS-HZ3": "H",
    "RA-C1'": "CT",
    "RU3-H5": "HA",
    "RU3-H6": "H4",
    "RU3-H3": "H",
    "DT5-H71": "HC",
    "DT5-H72": "HC",
    "DT5-H73": "HC",
    "MET-HG2": "H1",
    "RG3-C4'": "CT",
    "DA5-C2'": "CT",
    "DT3-H5'2": "H1",
    "RCN-C1'": "CT",
    "DA-O2P": "O2",
    "DG-O6": "O",
    "RC5-C2'": "CT",
    "DGN-N9": "N*",
    "SER-OG": "OH",
    "DGN-N7": "NB",
    "DGN-N1": "NA",
    "DGN-N2": "N2",
    "DGN-N3": "NC",
    "DA3-H2": "H5",
    "DA3-H8": "H5",
    "RU-H1'": "H2",
    "DGN-O3'": "OH",
    "CYS-SG": "SH",
    "RG-H1": "H",
    "TRP-HA": "H1",
    "RG3-H3T": "HO",
    "RG-H8": "H5",
    "RC3-C3'": "CT",
    "TRP-HZ2": "HA",
    "RUN-H3'": "H1",
    "RU5-C2'": "CT",
    "DC5-C2'": "CT",
    "RG5-O6": "O",
    "RUN-H3T": "HO",
    "MET-HB2": "HC",
    "MET-HB3": "HC",
    "RG5-H21": "H",
    "RG5-H22": "H",
    "RG3-H3'": "H1",
    "RC3-N1": "N*",
    "RC3-N3": "NC",
    "RC3-N4": "N2",
    "RC5-H1'": "H2",
    "LYN-NZ": "N3",
    "DAN-H5'1": "H1",
    "THR-HA": "H1",
    "THR-HB": "H1",
    "RU3-O3'": "OH",
    "RU3-H4'": "H1",
    "DG-H4'": "H1",
    "RCN-H2'1": "H1",
    "RA-C4": "CB",
    "TYR-CE1": "CA",
    "TYR-CE2": "CA",
    "DC-H3'": "H1",
    "DT3-H3": "H",
    "DT3-H6": "H4",
    "DCN-C5'": "CT",
    "DC3-O1P": "O2",
    "RCN-O2": "O",
    "DCN-O5'": "OH",
    "THR-OG1": "OH",
    "DGN-H5T": "HO",
    "RGN-C5": "CB",
    "RA-C3'": "CT",
    "RGN-C6": "C",
    "DC5-H5'1": "H1",
    "DC5-H5'2": "H1",
    "HIP-HE1": "H5",
    "HIP-HE2": "H",
    "DG-C2'": "CT",
    "HID-HA": "H1",
    "RA3-O5'": "OS",
    "TRP-CE2": "CN",
    "TRP-CE3": "CA",
    "RG3-O5'": "OS",
    "RG-H3'": "H1",
    "DA-O1P": "O2",
    "DG5-H1'": "H2",
    "RA5-H4'": "H1",
    "DG3-H5'2": "H1",
    "DG3-H5'1": "H1",
    "RG3-P": "P",
    "ILE-CB": "CT",
    "ILE-CA": "CT",
    "DT5-H4'": "H1",
    "DAN-H4'": "H1",
    "RG5-C1'": "CT",
    "RA3-N3": "NC",
    "RG3-C5'": "CT",
    "DA5-C3'": "CT",
    "RA5-H62": "H",
    "GLH-HB3": "HC",
    "RA5-H61": "H",
    "DGN-H5'1": "H1",
    "DGN-H5'2": "H1",
    "PRO-C": "C",
    "PRO-O": "O",
    "PRO-N": "N",
    "RA5-C8": "CK",
    "DC5-C3'": "CT",
    "TYR-CA": "CT",
    "TYR-CB": "CT",
    "TYR-CG": "CA",
    "DG-H1": "H",
    "RA5-C2": "CQ",
    "RGN-H4'": "H1",
    "RC5-C3'": "CT",
    "DG-H8": "H5",
    "TYR-CZ": "C",
    "DGN-O6": "O",
    "RU5-C3'": "CT",
    "RA5-C6": "CA",
    "RG5-N1": "NA",
    "RC3-O4'": "OS",
    "RA5-C5": "CB",
    "LEU-H": "H",
    "ASP-C": "C",
    "LEU-N": "N",
    "LEU-O": "O",
    "THR-HG22": "HC",
    "ASP-H": "H",
    "LEU-C": "C",
    "ASP-N": "N",
    "ASP-O": "O",
    "RC3-C4'": "CT",
    "RA3-N9": "N*",
    "RA3-N7": "NB",
    "RA3-N6": "N2",
    "RA-HO'2": "HO",
    "RUN-H4'": "H1",
    "RA3-N1": "NC",
    "GLH-HB2": "HC",
    "ASH-H": "H",
    "ASH-N": "N",
    "ASH-O": "O",
    "RG5-N9": "N*",
    "RG3-H22": "H",
    "ASH-C": "C",
    "RG5-H1'": "H2",
    "RG3-H21": "H",
    "RAN-C1'": "CT",
    "RG5-N2": "N2",
    "RA5-C4": "CB",
    "DT5-H5'1": "H1",
    "RA-H2'1": "H1",
    "RAN-N9": "N*",
    "RAN-N1": "NC",
    "RAN-N3": "NC",
    "DA5-O5'": "OH",
    "RAN-N6": "N2",
    "RAN-N7": "NB",
    "DC-O3'": "OS",
    "RAN-HO'2": "HO",
    "DA3-C3'": "CT",
    "DC5-C2": "C",
    "DC3-N4": "N2",
    "DC5-C6": "CM",
    "DC5-C4": "CA",
    "DC5-C5": "CM",
    "RA3-C4'": "CT",
    "RC-O3'": "OS",
    "CYS-HA": "H1",
    "CYS-HG": "HS",
    "HIP-CE1": "CR",
    "SER-H": "H",
    "SER-N": "N",
    "SER-O": "O",
    "SER-C": "C",
    "TYR-CD2": "CA",
    "TYR-CD1": "CA",
    "DC-H4'": "H1",
    "TRP-NE1": "NA",
    "DCN-C4'": "CT",
    "DC-H42": "H",
    "DC-H41": "H",
    "ASP-OD2": "O2",
    "ASP-OD1": "O2",
    "RU3-H2'1": "H1",
    "ASH-HD2": "HO",
    "DCN-O4'": "OS",
    "GLN-HE21": "H",
    "RG5-O4'": "OS",
    "GLN-HE22": "H",
    "DG-H2'1": "HC",
    "DG-H2'2": "HC",
    "LYS-NZ": "N3",
    "ILE-C": "C",
    "PHE-HD1": "HA",
    "RU5-HO'2": "HO",
    "PHE-HD2": "HA",
    "RA-C2'": "CT",
    "ILE-H": "H",
    "RGN-H2'1": "H1",
    "ILE-O": "O",
    "DC5-H5T": "HO",
    "RG-C3'": "CT",
    "RA3-O2'": "OH",
    "TRP-HE1": "H",
    "TRP-HE3": "HA",
    "RA3-O2P": "O2",
    "RG3-C8": "CK",
    "RG3-C2": "CA",
    "RG3-C6": "C",
    "RG3-C4": "CB",
    "RG3-C5": "CB",
    "DC3-C2'": "CT",
    "DT3-H3T": "HO",
    "ARG-NH2": "N2",
    "TYR-HA": "H1",
    "RGN-H5T": "HO",
    "DAN-H5T": "HO",
    "RUN-O2'": "OH",
    "RA5-H1'": "H2",
    "TYR-HH": "HO",
    "HIP-ND1": "NA",
    "DG3-H8": "H5",
    "DG3-H1": "H",
    "RA5-O2'": "OH",
    "ARG-C": "C",
    "ARG-N": "N",
    "ARG-O": "O",
    "ARG-H": "H",
    "DT5-H5T": "HO",
    "DA3-H2'2": "HC",
    "DA3-H2'1": "HC",
    "RC-H6": "H4",
    "DA3-N1": "NC",
    "DA3-N3": "NC",
    "RU5-C4'": "CT",
    "DA3-N7": "NB",
    "DA3-N6": "N2",
    "DA3-N9": "N*",
    "DC-O2P": "O2",
    "TRP-CZ3": "CA",
    "TRP-CZ2": "CA",
    "RA3-P": "P",
    "RC3-O5'": "OS",
    "RG-H5'1": "H1",
    "RG-H5'2": "H1",
    "RG-N9": "N*",
    "DAN-C5": "CB",
    "RU-O2P": "O2",
    "RG-N1": "NA",
    "RG-N3": "NC",
    "RG-N2": "N2",
    "RG-N7": "NB",
    "DTN-H5'2": "H1",
    "DTN-H5'1": "H1",
    "RC3-C5'": "CT",
    "DC3-N3": "NC",
    "HIP-H": "H",
    "DC3-N1": "N*",
    "HIP-O": "O",
    "HIP-N": "N",
    "HIP-C": "C",
    "MET-C": "C",
    "RUN-H5T": "HO",
    "RU-O2'": "OH",
    "RU-H3": "H",
    "DA3-O4'": "OS",
    "RU5-O4'": "OS",
    "MET-H": "H",
    "DAN-C8": "CK",
    "DT-C1'": "CT",
    "DA5-H3'": "H1",
    "DA3-C4'": "CT",
    "HID-O": "O",
    "HID-N": "N",
    "HID-H": "H",
    "HID-C": "C",
    "DT5-C3'": "CT",
    "DAN-C2'": "CT",
    "RC-O2P": "O2",
    "DG5-O4'": "OS",
    "RC-O2'": "OH",
    "HIP-CD2": "CW",
    "DAN-O5'": "OH",
    "RU3-O1P": "O2",
    "PHE-HA": "H1",
    "DC-C4": "CA",
    "RC-N4": "N2",
    "DC-C6": "CM",
    "RC-N1": "N*",
    "PHE-HZ": "HA",
    "DT-H5'2": "H1",
    "LYS-CG": "CT",
    "LYS-CD": "CT",
    "DT-H5'1": "H1",
    "LYS-CB": "CT",
    "CYX-SG": "S",
    "LYS-CA": "CT",
    "DTN-H73": "HC",
    "DTN-H72": "HC",
    "DTN-H71": "HC",
    "DC-P": "P",
    "RG5-O5'": "OH",
    "RC-H2'1": "H1",
    "DG-P": "P",
    "GLH-OE2": "OH",
    "GLH-OE1": "O",
    "PHE-HE2": "HA",
    "PHE-HE1": "HA",
    "DA3-H5'2": "H1",
    "RA-C5'": "CT",
    "ARG-HH22": "H",
    "ARG-HH21": "H",
    "RG-C2'": "CT",
    "ALA-CB": "CT",
    "ALA-CA": "CT",
    "RA3-O3'": "OH",
    "TRP-HD1": "H4",
    "RA3-H2'1": "H1",
    "RG-H1'": "H2",
    "DC5-H4'": "H1",
    "DG5-H3'": "H1",
    "RUN-H2'1": "H1",
    "RA-O5'": "OS",
    "DC5-H41": "H",
    "DC5-H42": "H",
    "SER-HA": "H1",
    "DT5-H5'2": "H1",
    "SER-HG": "HO",
    "DA3-H62": "H",
    "DA3-H61": "H",
    "RUN-HO'2": "HO",
    "RU5-H5'1": "H1",
    "RU-H2'1": "H1",
    "RU5-H5'2": "H1",
    "DG3-O2P": "O2",
    "DA5-C1'": "CT",
    "HIP-NE2": "NA",
    "DT3-P": "P",
    "DG5-H1": "H",
    "DG5-H8": "H5",
    "RA5-O3'": "OS",
    "LYN-C": "C",
    "LYN-O": "O",
    "LYN-N": "N",
    "LYN-H": "H",
    "DA-H5'1": "H1",
    "DA-H5'2": "H1",
    "RC5-C1'": "CT",
    "RG5-N7": "NB",
    "RAN-H5'1": "H1",
    "RAN-H5'2": "H1",
    "RU5-C5'": "CT",
    "RGN-O3'": "OH",
    "CYM-CA": "CT",
    "DGN-C8": "CK",
    "DGN-C6": "C",
    "DGN-C5": "CB",
    "DGN-C4": "CB",
    "DGN-C2": "CA",
    "RU-C5'": "CT",
    "RG-O6": "O",
    "DT5-O3'": "OS",
    "RA3-H8": "H5",
    "RA3-H2": "H5",
    "RA5-H3'": "H1",
    "RG5-H8": "H5",
    "DT-C2'": "CT",
    "RG5-H1": "H",
    "TYR-OH": "OH",
    "RAN-H4'": "H1",
    "MET-CA": "CT",
    "RAN-C3'": "CT",
    "MET-CE": "CT",
    "MET-CG": "CT",
    "RC3-C6": "CM",
    "RC3-C4": "CA",
    "RC3-C5": "CM",
    "RC3-C2": "C",
    "DAN-H8": "H5",
    "DA3-O5'": "OS",
    "HID-ND1": "NA",
    "DAN-H2": "H5",
    "RU5-O5'": "OH",
    "DC3-H42": "H",
    "DA5-H5'2": "H1",
    "DA5-H5'1": "H1",
    "DC3-H41": "H",
    "DA-C4'": "CT",
    "DC3-H4'": "H1",
    "RG5-N3": "NC",
    "DTN-C7": "CT",
    "DA3-C5'": "CT",
    "MET-SD": "S",
    "RC5-H5": "HA",
    "DA3-C4": "CB",
    "RC5-H6": "H4",
    "DA3-C2": "CQ",
    "DA3-C8": "CK",
    "MET-HG3": "H1",
    "HIE-NE2": "NA",
    "DC3-H5": "HA",
    "DT3-H5'1": "H1",
    "DAN-C1'": "CT",
    "DC3-H6": "H4",
    "GLN-OE1": "O",
    "ARG-HE": "H",
    "DC5-O2": "O",
    "ARG-HA": "H1",
    "LYN-CE": "CT",
    "LYN-CD": "CT",
    "LYN-CG": "CT",
    "RGN-C2": "CA",
    "LYN-CA": "CT",
    "RGN-C4": "CB",
    "LYN-CB": "CT",
    "RA5-C4'": "CT",
    "RGN-C8": "CK",
    "RC-O2": "O",
    "RCN-O5'": "OH",
    "RUN-N1": "N*",
    "RUN-N3": "NA",
    "RG5-O2'": "OH",
    "RC-O1P": "O2",
    "HIE-C": "C",
    "RA-C4'": "CT",
    "ASN-CG": "C",
    "ARG-HH12": "H",
    "ASN-CA": "CT",
    "ASN-CB": "CT",
    "ARG-HH11": "H",
    "ARG-CD": "CT",
    "RG-C1'": "CT",
    "TYR-HD1": "HA",
    "DG5-O3'": "OS",
    "TYR-HD2": "HA",
    "ILE-N": "N",
    "RC3-HO'2": "HO",
    "DG3-O3'": "OH",
    "DG3-H4'": "H1",
    "RA-O4'": "OS",
    "ASH-OD2": "OH",
    "ASH-OD1": "O",
    "DG5-H22": "H",
    "DG5-H21": "H",
    "DT3-H4'": "H1",
    "DT3-C3'": "CT",
    "DAN-H3T": "HO",
    "DGN-C1'": "CT",
    "RG5-C4'": "CT",
    "RG-O4'": "OS",
    "DG5-O6": "O",
    "RA5-O4'": "OS",
    "RCN-C5'": "CT",
    "DAN-H3'": "H1",
}

bond_structure = {
    "GLH": {
        "C": ["O"],
        "OE2": ["HE2"],
        "CA": ["HA", "CB", "C"],
        "CG": ["HG2", "HG3", "CD"],
        "CD": ["OE1", "OE2"],
        "CB": ["HB2", "HB3", "CG"],
        "N": ["H", "CA"],
    },
    "ILE": {
        "C": ["O"],
        "CB": ["HB", "CG2", "CG1"],
        "CA": ["HA", "CB", "C"],
        "N": ["H", "CA"],
        "CD1": ["HD11", "HD12", "HD13"],
        "CG1": ["HG12", "HG13", "CD1"],
        "CG2": ["HG21", "HG22", "HG23"],
    },
    "DTN": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "H2'2"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "N3": ["H3", "C2"],
        "C7": ["H71", "H72", "H73"],
        "C6": ["H6", "C5"],
        "C5": ["C7", "C4"],
        "C4": ["O4", "N3"],
    },
    "GLN": {
        "C": ["O"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["HG2", "HG3", "CD"],
        "CD": ["OE1", "NE2"],
        "N": ["H", "CA"],
        "NE2": ["HE21", "HE22"],
    },
    "DG": {
        "N3": ["C4"],
        "N9": ["C8", "C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "H2'2"],
        "C2": ["N2", "N3"],
        "N1": ["H1", "C2"],
        "N2": ["H21", "H22"],
        "N7": ["C5"],
        "C6": ["O6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "DA3": {
        "C2'": ["H2'1", "H2'2"],
        "N3": ["C4"],
        "N9": ["C8", "C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "N6": ["H61", "H62"],
        "C2": ["H2", "N3"],
        "N1": ["C2"],
        "N7": ["C5"],
        "C6": ["N6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "DC": {
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "H2'2"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "N3": ["C2"],
        "N4": ["H41", "H42"],
        "C6": ["H6", "C5"],
        "C5": ["H5", "C4"],
        "C4": ["N4", "N3"],
    },
    "DA": {
        "C2'": ["H2'1", "H2'2"],
        "N3": ["C4"],
        "N9": ["C8", "C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "N6": ["H61", "H62"],
        "C2": ["H2", "N3"],
        "N1": ["C2"],
        "N7": ["C5"],
        "C6": ["N6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "GLY": {"CA": ["HA2", "HA3", "C"], "C": ["O"], "N": ["H", "CA"]},
    "RCN": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "O2'"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "O2'": ["HO'2"],
        "N3": ["C2"],
        "N4": ["H41", "H42"],
        "C6": ["H6", "C5"],
        "C5": ["H5", "C4"],
        "C4": ["N4", "N3"],
    },
    "HIP": {
        "C": ["O"],
        "CD2": ["HD2"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["ND1", "CD2"],
        "N": ["H", "CA"],
        "CE1": ["HE1", "NE2"],
        "ND1": ["HD1", "CE1"],
        "NE2": ["HE2", "CD2"],
    },
    "TYR": {
        "C": ["O"],
        "CD2": ["HD2"],
        "OH": ["HH"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["CD1", "CD2"],
        "N": ["H", "CA"],
        "CZ": ["OH", "CE2"],
        "CD1": ["HD1", "CE1"],
        "CE1": ["HE1", "CZ"],
        "CE2": ["HE2", "CD2"],
    },
    "RU3": {
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "O2'"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "N3": ["H3", "C2"],
        "O2'": ["HO'2"],
        "C6": ["H6", "C5"],
        "C5": ["H5", "C4"],
        "C4": ["O4", "N3"],
    },
    "DT": {
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "H2'2"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "N3": ["H3", "C2"],
        "C7": ["H71", "H72", "H73"],
        "C6": ["H6", "C5"],
        "C5": ["C7", "C4"],
        "C4": ["O4", "N3"],
    },
    "ALA": {
        "CB": ["HB1", "HB2", "HB3"],
        "CA": ["HA", "CB", "C"],
        "C": ["O"],
        "N": ["H", "CA"],
    },
    "GLU": {
        "C": ["O"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["HG2", "HG3", "CD"],
        "CD": ["OE1", "OE2"],
        "N": ["H", "CA"],
    },
    "RGN": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "N3": ["C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "N9": ["C8", "C4"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "O2'"],
        "C2": ["N2", "N3"],
        "N1": ["H1", "C2"],
        "N2": ["H21", "H22"],
        "N7": ["C5"],
        "O2'": ["HO'2"],
        "C6": ["O6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "RU5": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "O2'"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "N3": ["H3", "C2"],
        "O2'": ["HO'2"],
        "C6": ["H6", "C5"],
        "C5": ["H5", "C4"],
        "C4": ["O4", "N3"],
    },
    "DCN": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "H2'2"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "N3": ["C2"],
        "N4": ["H41", "H42"],
        "C6": ["H6", "C5"],
        "C5": ["H5", "C4"],
        "C4": ["N4", "N3"],
    },
    "RU": {
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "O2'"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "N3": ["H3", "C2"],
        "O2'": ["HO'2"],
        "C6": ["H6", "C5"],
        "C5": ["H5", "C4"],
        "C4": ["O4", "N3"],
    },
    "ASP": {
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["OD1", "OD2"],
        "C": ["O"],
        "N": ["H", "CA"],
    },
    "SER": {
        "OG": ["HG"],
        "CB": ["HB2", "HB3", "OG"],
        "CA": ["HA", "CB", "C"],
        "C": ["O"],
        "N": ["H", "CA"],
    },
    "LYS": {
        "C": ["O"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["HG2", "HG3", "CD"],
        "CE": ["HE2", "HE3", "NZ"],
        "CD": ["HD2", "HD3", "CE"],
        "NZ": ["HZ1", "HZ2", "HZ3"],
        "N": ["H", "CA"],
    },
    "RAN": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "C2'": ["H2'1", "O2'"],
        "N3": ["C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "N9": ["C8", "C4"],
        "C4'": ["H4'", "O4'", "C3'"],
        "N6": ["H61", "H62"],
        "C2": ["H2", "N3"],
        "N1": ["C2"],
        "N7": ["C5"],
        "O2'": ["HO'2"],
        "C6": ["N6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "DAN": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "C2'": ["H2'1", "H2'2"],
        "N3": ["C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "N9": ["C8", "C4"],
        "C4'": ["H4'", "O4'", "C3'"],
        "N6": ["H61", "H62"],
        "C2": ["H2", "N3"],
        "N1": ["C2"],
        "N7": ["C5"],
        "C6": ["N6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "CYX": {
        "CB": ["HB2", "HB3", "SG"],
        "CA": ["HA", "CB", "C"],
        "C": ["O"],
        "N": ["H", "CA"],
    },
    "DGN": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "N3": ["C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "N9": ["C8", "C4"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "H2'2"],
        "C2": ["N2", "N3"],
        "N1": ["H1", "C2"],
        "N2": ["H21", "H22"],
        "N7": ["C5"],
        "C6": ["O6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "RG": {
        "N3": ["C4"],
        "N9": ["C8", "C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "O2'"],
        "C2": ["N2", "N3"],
        "N1": ["H1", "C2"],
        "N2": ["H21", "H22"],
        "N7": ["C5"],
        "O2'": ["HO'2"],
        "C6": ["O6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "HID": {
        "C": ["O"],
        "CD2": ["HD2"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["ND1", "CD2"],
        "N": ["H", "CA"],
        "CE1": ["HE1", "NE2"],
        "ND1": ["HD1", "CE1"],
        "NE2": ["CD2"],
    },
    "RA": {
        "C2'": ["H2'1", "O2'"],
        "N3": ["C4"],
        "N9": ["C8", "C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "N6": ["H61", "H62"],
        "C2": ["H2", "N3"],
        "N1": ["C2"],
        "N7": ["C5"],
        "O2'": ["HO'2"],
        "C6": ["N6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "RC": {
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "O2'"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "O2'": ["HO'2"],
        "N3": ["C2"],
        "N4": ["H41", "H42"],
        "C6": ["H6", "C5"],
        "C5": ["H5", "C4"],
        "C4": ["N4", "N3"],
    },
    "LYN": {
        "C": ["O"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["HG2", "HG3", "CD"],
        "CE": ["HE2", "HE3", "NZ"],
        "CD": ["HD2", "HD3", "CE"],
        "NZ": ["HZ2", "HZ3"],
        "N": ["H", "CA"],
    },
    "ASH": {
        "C": ["O"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["OD1", "OD2"],
        "N": ["H", "CA"],
        "OD2": ["HD2"],
    },
    "ASN": {
        "C": ["O"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["OD1", "ND2"],
        "N": ["H", "CA"],
        "ND2": ["HD21", "HD22"],
    },
    "CYM": {
        "CB": ["HB3", "HB2", "SG"],
        "CA": ["HA", "CB", "C"],
        "C": ["O"],
        "N": ["HN", "CA"],
    },
    "HIE": {
        "C": ["O"],
        "CD2": ["HD2"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["ND1", "CD2"],
        "N": ["H", "CA"],
        "CE1": ["HE1", "NE2"],
        "ND1": ["CE1"],
        "NE2": ["HE2", "CD2"],
    },
    "CYS": {
        "CB": ["HB2", "HB3", "SG"],
        "CA": ["HA", "CB", "C"],
        "SG": ["HG"],
        "C": ["O"],
        "N": ["H", "CA"],
    },
    "VAL": {
        "C": ["O"],
        "CB": ["HB", "CG1", "CG2"],
        "CA": ["HA", "CB", "C"],
        "N": ["H", "CA"],
        "CG1": ["HG11", "HG12", "HG13"],
        "CG2": ["HG21", "HG22", "HG23"],
    },
    "THR": {
        "C": ["O"],
        "CB": ["HB", "CG2", "OG1"],
        "CA": ["HA", "CB", "C"],
        "OG1": ["HG1"],
        "N": ["H", "CA"],
        "CG2": ["HG21", "HG22", "HG23"],
    },
    "DG3": {
        "N3": ["C4"],
        "N9": ["C8", "C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "H2'2"],
        "C2": ["N2", "N3"],
        "N1": ["H1", "C2"],
        "N2": ["H21", "H22"],
        "N7": ["C5"],
        "C6": ["O6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "RA5": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "C2'": ["H2'1", "O2'"],
        "N3": ["C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "N9": ["C8", "C4"],
        "C4'": ["H4'", "O4'", "C3'"],
        "N6": ["H61", "H62"],
        "C2": ["H2", "N3"],
        "N1": ["C2"],
        "N7": ["C5"],
        "O2'": ["HO'2"],
        "C6": ["N6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "RA3": {
        "C2'": ["H2'1", "O2'"],
        "N3": ["C4"],
        "N9": ["C8", "C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "N6": ["H61", "H62"],
        "C2": ["H2", "N3"],
        "N1": ["C2"],
        "N7": ["C5"],
        "O2'": ["HO'2"],
        "C6": ["N6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "DG5": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "N3": ["C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "N9": ["C8", "C4"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "H2'2"],
        "C2": ["N2", "N3"],
        "N1": ["H1", "C2"],
        "N2": ["H21", "H22"],
        "N7": ["C5"],
        "C6": ["O6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "TRP": {
        "C": ["O"],
        "CZ2": ["HZ2", "CH2"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["CD1", "CD2"],
        "CH2": ["HH2", "CZ3"],
        "N": ["H", "CA"],
        "CE2": ["CZ2", "CD2"],
        "CE3": ["HE3", "CD2"],
        "CD1": ["HD1", "NE1"],
        "CZ3": ["HZ3", "CE3"],
        "NE1": ["HE1", "CE2"],
    },
    "DC5": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "H2'2"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "N3": ["C2"],
        "N4": ["H41", "H42"],
        "C6": ["H6", "C5"],
        "C5": ["H5", "C4"],
        "C4": ["N4", "N3"],
    },
    "DC3": {
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "H2'2"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "N3": ["C2"],
        "N4": ["H41", "H42"],
        "C6": ["H6", "C5"],
        "C5": ["H5", "C4"],
        "C4": ["N4", "N3"],
    },
    "RG3": {
        "N3": ["C4"],
        "N9": ["C8", "C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "O2'"],
        "C2": ["N2", "N3"],
        "N1": ["H1", "C2"],
        "N2": ["H21", "H22"],
        "N7": ["C5"],
        "O2'": ["HO'2"],
        "C6": ["O6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "RUN": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "O2'"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "N3": ["H3", "C2"],
        "O2'": ["HO'2"],
        "C6": ["H6", "C5"],
        "C5": ["H5", "C4"],
        "C4": ["O4", "N3"],
    },
    "RG5": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "N3": ["C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "N9": ["C8", "C4"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "O2'"],
        "C2": ["N2", "N3"],
        "N1": ["H1", "C2"],
        "N2": ["H21", "H22"],
        "N7": ["C5"],
        "O2'": ["HO'2"],
        "C6": ["O6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "DA5": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "C2'": ["H2'1", "H2'2"],
        "N3": ["C4"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N9", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "N9": ["C8", "C4"],
        "C4'": ["H4'", "O4'", "C3'"],
        "N6": ["H61", "H62"],
        "C2": ["H2", "N3"],
        "N1": ["C2"],
        "N7": ["C5"],
        "C6": ["N6", "N1"],
        "C5": ["C6", "C4"],
        "C8": ["H8", "N7"],
    },
    "RC5": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "O2'"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "O2'": ["HO'2"],
        "N3": ["C2"],
        "N4": ["H41", "H42"],
        "C6": ["H6", "C5"],
        "C5": ["H5", "C4"],
        "C4": ["N4", "N3"],
    },
    "PHE": {
        "C": ["O"],
        "CD2": ["HD2"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["CD1", "CD2"],
        "N": ["H", "CA"],
        "CZ": ["HZ", "CE2"],
        "CD1": ["HD1", "CE1"],
        "CE1": ["HE1", "CZ"],
        "CE2": ["HE2", "CD2"],
    },
    "RC3": {
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "O2'"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "O2'": ["HO'2"],
        "N3": ["C2"],
        "N4": ["H41", "H42"],
        "C6": ["H6", "C5"],
        "C5": ["H5", "C4"],
        "C4": ["N4", "N3"],
    },
    "MET": {
        "C": ["O"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["HG2", "HG3", "SD"],
        "CE": ["HE1", "HE2", "HE3"],
        "N": ["H", "CA"],
        "SD": ["CE"],
    },
    "LEU": {
        "C": ["O"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["HG", "CD1", "CD2"],
        "N": ["H", "CA"],
        "CD1": ["HD11", "HD12", "HD13"],
        "CD2": ["HD21", "HD22", "HD23"],
    },
    "ARG": {
        "C": ["O"],
        "CB": ["HB2", "HB3", "CG"],
        "CA": ["HA", "CB", "C"],
        "CG": ["HG2", "HG3", "CD"],
        "NE": ["HE", "CZ"],
        "CD": ["HD2", "HD3", "NE"],
        "CZ": ["NH1", "NH2"],
        "NH1": ["HH11", "HH12"],
        "NH2": ["HH21", "HH22"],
        "N": ["H", "CA"],
    },
    "DT3": {
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "O3'": ["H3T"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "C5'": ["H5'1", "H5'2", "C4'"],
        "P": ["O1P", "O2P", "O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "H2'2"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "N3": ["H3", "C2"],
        "C7": ["H71", "H72", "H73"],
        "C6": ["H6", "C5"],
        "C5": ["C7", "C4"],
        "C4": ["O4", "N3"],
    },
    "PRO": {
        "C": ["O"],
        "CB": ["HB2", "HB3", "CA"],
        "CA": ["HA", "C"],
        "CG": ["HG2", "HG3", "CB"],
        "CD": ["HD2", "HD3", "CG"],
        "N": ["CD", "CA"],
    },
    "DT5": {
        "C5'": ["H5'1", "H5'2", "C4'"],
        "O5'": ["C5'"],
        "C3'": ["H3'", "C2'", "O3'"],
        "C1'": ["H1'", "N1", "C2'"],
        "O4'": ["C1'"],
        "H5T": ["O5'"],
        "C4'": ["H4'", "O4'", "C3'"],
        "C2'": ["H2'1", "H2'2"],
        "C2": ["O2"],
        "N1": ["C6", "C2"],
        "N3": ["H3", "C2"],
        "C7": ["H71", "H72", "H73"],
        "C6": ["H6", "C5"],
        "C5": ["C7", "C4"],
        "C4": ["O4", "N3"],
    },
}

masses = {
    "IP": 22.99,
    "Rb": 85.47,
    "HS": 1.008,
    "HP": 1.008,
    "HW": 1.008,
    "Li": 6.94,
    "HO": 1.008,
    "BR": 79.9,
    "HC": 1.008,
    "HA": 1.008,
    "N2": 14.01,
    "C*": 12.01,
    "N3": 14.01,
    "LC": 12.01,
    "NO": 14.01,
    "NA": 14.01,
    "NB": 14.01,
    "NC": 14.01,
    "O2": 16.0,
    "I": 126.9,
    "H": 1.008,
    "NP": 14.01,
    "C0": 40.08,
    "N*": 14.01,
    "K": 39.1,
    "CK": 12.01,
    "Cs": 132.91,
    "C": 12.01,
    "CN": 12.01,
    "CM": 12.01,
    "F": 19.0,
    "CC": 12.01,
    "CB": 12.01,
    "CA": 12.01,
    "O": 16.0,
    "N": 14.01,
    "P": 30.97,
    "S": 32.06,
    "CX": 12.0,
    "IM": 35.45,
    "CR": 12.01,
    "CQ": 12.01,
    "IB": 131.0,
    "CW": 12.01,
    "CV": 12.01,
    "CU": 63.55,
    "CT": 12.01,
    "MG": 24.305,
    "OH": 16.0,
    "H2": 1.008,
    "H3": 1.008,
    "H1": 1.008,
    "CY": 12.0,
    "H4": 1.008,
    "H5": 1.008,
    "CD": 12.0,
    "SH": 32.06,
    "LO": 16.0,
    "OW": 16.0,
    "OS": 16.0,
    "FE": 55.0,
}

translate = {"OP1": "O1P", "OP2": "O2P"}
