"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentfulWebhook = void 0;
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class ContentfulWebhook extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const handler = new aws_lambda_1.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: '91f2075f-b950-4743-a66b-ee0f6febf50d',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'contentful-webhook')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::ContentfulWebhook',
            timeout: core_1.Duration.minutes(15),
        });
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::ContentfulWebhook',
            pascalCaseProperties: true,
            properties: {
                ...props,
            },
        });
    }
}
exports.ContentfulWebhook = ContentfulWebhook;
//# sourceMappingURL=data:application/json;base64,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