"""
Django settings for wui project.

Generated by 'django-admin startproject' using Django 1.11.2.

For more information on this file, see
https://docs.djangoproject.com/en/1.11/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.11/ref/settings/
"""

import os
import site
from . import settings_logging
import katana.wui.core.core_utils.core_settings as core_settings
try:
    import ldap
    from django_auth_ldap.config import LDAPSearch, LDAPSearchUnion, GroupOfNamesType
except Exception as err:
    print("Please install django auth ldap to authenticate against ldap")
    print("Error while importing django auth ldap: \n", err)

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.11/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'ayb*8x8=kl7nb+1gc_b@v$oaiopv=v2v6_zc+#d3p+xyq4xo(d'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ["*"]


# Application definition

INSTALLED_APPS = [

    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'rest_framework',
    'katana.wui.administration',
    'katana.wui.users',
    'katana.wui.core',
    'katana.native.wapp_management',

]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'katana.wui.users.middleware.UserExpiryMiddleware',
    'katana.wui.users.middleware.LoginRequiredMiddleware',
    'katana.wui.users.middleware.UserActivityMiddleware',
]

ROOT_URLCONF = 'katana.wui.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [
            os.path.join(BASE_DIR, 'wui', 'administration', 'templates'),
        ],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'katana.wui.wsgi.application'

# Django Rest Framework
# https://www.django-rest-framework.org/api-guide/settings/
REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'rest_framework.authentication.BasicAuthentication',
        'rest_framework.authentication.SessionAuthentication',
    ),
    'DEFAULT_PERMISSION_CLASSES': (
        'rest_framework.permissions.IsAuthenticated',
        'katana.wui.users.rest_addons.IsNotExpiredPermission',
    ),
}

# Database
# https://docs.djangoproject.com/en/1.11/ref/settings/#databases
if os.environ["pipmode"] == "True":
    virtual_env = os.getenv('VIRTUAL_ENV')
    if virtual_env:
        dbsqlite_path = virtual_env + os.sep + "katana_configs" + os.sep + "db.sqlite3"
        en_config_path = virtual_env + os.sep + "katana_configs" + os.sep + "en_config.ini"
    elif os.path.exists(site.getuserbase() + os.sep + "katana_configs"):
        dbsqlite_path = site.getuserbase() + os.sep + "katana_configs" + os.sep + "db.sqlite3"
        en_config_path = site.getuserbase() + os.sep + "katana_configs" + os.sep + "en_config.ini"
    elif os.path.exists("/usr/local/katana_configs"):
        dbsqlite_path = "/usr/local/katana_configs/db.sqlite3"
        en_config_path = "/usr/local/katana_configs/en_config.ini"
    else:
        print("--An error occured: Can not find katana_configs directory")
        exit()
else:
    dbsqlite_path = os.path.join(BASE_DIR, "katana_configs", "db.sqlite3")
    en_config_path = os.path.join(BASE_DIR, 'katana_configs', 'en_config.ini')

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': dbsqlite_path,
    },
    'postgresql': {
        'ENGINE': 'django.db.backends.postgresql_psycopg2',
        'NAME': os.environ.get('DB_NAME', 'warrior'),
        'USER': os.environ.get('DB_USER', 'warrior'),
        'PASSWORD': os.environ.get('DB_PASSWORD', 'qwerty'),
        'HOST': os.environ.get('DB_HOST', 'katana-db'),
        'PORT': os.environ.get('DB_PORT', ''),
    }
}

DATABASE_ROUTERS = ['katana.dbrouter.DbRouter']

# Authentication settings
AUTH_USER_MODEL = 'users.User'
LOGIN_URL = '/katana/login'
LOGIN_REDIRECT_URL = '/'
LOGOUT_REDIRECT_URL = '/'

AUTHENTICATION_BACKENDS = (
    'django.contrib.auth.backends.ModelBackend',
)

MULTI_USER_SUPPORT = False
USER_HOME_DIR_TEMPLATE = None

# Logging
settings_logging.BASE_DIR = BASE_DIR
settings_logging.DEBUG = DEBUG
LOGGING = settings_logging.get_log_config()

# LDAP Settings (if available)
CONFIG_FILE = os.path.join(BASE_DIR, 'wui', 'config.ini')
ENCRYPTED_CONFIG_FILE = en_config_path

if os.getenv("KATANA_CRYPTO_KEY", None) and os.path.exists(ENCRYPTED_CONFIG_FILE):
    key = os.getenv("KATANA_CRYPTO_KEY")
    encrypt_settings = core_settings.ENCRYPT_SETTINGS(key)
    encrypt_settings.decrypt_file(ENCRYPTED_CONFIG_FILE, CONFIG_FILE)

try:
    LOGGING['loggers']['django_auth_ldap'] = {
        "level": "DEBUG",
        "handlers": ["django_file", "console"],
    }
    ldap_settings = core_settings.LDAPSettings(CONFIG_FILE)
    for config, value in ldap_settings.configs.items():
        locals()[config.upper()] = value
    if ldap_settings.enabled and not ldap_settings.errors:
        AUTHENTICATION_BACKENDS = AUTHENTICATION_BACKENDS + ('django_auth_ldap.backend.LDAPBackend',)
    if ldap_settings.errors:
        print("Errors encountered during import of LDAP settings from", CONFIG_FILE)
        print("Errors are:")
        for k, v in ldap_settings.errors.items():
            print("LDAP Attribute", k, "is", v)
except Exception as ex:
    print("Unexpected failure to import LDAP settings from", CONFIG_FILE)
    print("Error encountered:\n", ex)

#Mail Servers
EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
try:
    email_settings = core_settings.EMAILSettings(CONFIG_FILE)
    for config, value in email_settings.configs.items():
        locals()[config.upper()] = value
except Exception as ex:
    print("Unexpected failure to import Email settings from", CONFIG_FILE)
    print("Error encountered:\n", ex)

# Password validation
# https://docs.djangoproject.com/en/1.11/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]



##


# Internationalization
# https://docs.djangoproject.com/en/1.11/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.11/howto/static-files/

STATIC_URL = '/static/'
STATICFILES_DIRS = [
        os.path.join(BASE_DIR, 'static')
    ]
DATA_UPLOAD_MAX_MEMORY_SIZE = 10242880
STATIC_ROOT = os.path.join(os.path.dirname(BASE_DIR), 'static')
