# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/02_featue_extractor.ipynb (unless otherwise specified).

__all__ = ['get_features']

# Cell
def get_features(path):
    '''
    This function outputs the features from the VGG16 architecture (7x7x512) and flattens it a
    and returns it as an .npy array
    '''

    all_features = []
    for fx in sorted(os.listdir(path)):
        if fx.endswith('.jpg'):
            image = load_img(path+fx, target_size=(224, 224))
            # convert the image pixels to a numpy array
            image = img_to_array(image)

            # reshape data for the model
            image = image.reshape((1, image.shape[0], image.shape[1], image.shape[2]))

            # prepare the image for the VGG model
            image = preprocess_input(image)

            # get extracted features
            # features = model.predict(image)
            features = vgg16.predict(image)

            # print(features.shape)
            # print(features.reshape(-1,).shape)
            # all_features.append(features.reshape(-1,))
            all_features.append(features.flatten())
            print('Done with {}'.format(fx[:-4]))
    return np.asarray(all_features)
