# Conceptual Repository
> This intend to be an [readme-documented][-0], [open-source-licensed][-1], [semantic-versioned][-2],
[conventional-committed][-3] and [changelogged][-4] git repository starting point 
for the development of a brand-new project

A straightforward begin for an open-source project repository

[-0]: https://www.makeareadme.com/ "Make a README"
[-1]: https://choosealicense.com/licenses/ "Choose a License"
[-2]: https://semver.org/ "Semantic Versioning"
[-3]: https://www.conventionalcommits.org/en/v1.0.0/ "Conventional Commits"
[-4]: https://keepachangelog.com/en/1.0.0/ "Keep a Changelog"
[-5]: https://github.com/RichardLitt/standard-readme/blob/master/spec.md "Standard readme specification"
[-6]: https://www.repostatus.org "Repo maintenance status"

### Table of Contents
<details>
  <summary>See all</summary>

  * [Getting started](#getting-started)
    * [Development environment](#development-environment)
    * [Repo publication](#repo-publication)
  * [Project specifications](#project-specifications)
    * [Features](#features)
    * [Folder structure](#folder-structure)
  * [Maintainance](#maintainance-)
  * [License](#license-)
    
</details>


## Getting started
First of all, create a new repository from this [![template][B1]][A1] \
Name it accordingly and place where it best fits for your team.

[B1]: https://img.shields.io/static/v1?label=template&message=%20&style=social&logo=github "Github template badge"
[A1]: https://github.com/generic-tree/root/generate "Github repository's template generation URL"

### Development environment
Make sure you have `Git` installed:
```bash
$ git --version
git version 2.25.1
```

Thus, clone the recent-created repository locally
and you'll be ready to start developing your project. 

### Repo publication
After all, you should make this project your own: \
Write a good README to present your project to the world. \
And also ensure to tailor the project license to your needs.

[help]: https://gist.github.com/PurpleBooth/109311bb0361f32d87a2 (Check this README template)


## Project specifications
Here some descriptions about this template project:

### Features
This project shortens a repository start setup, considering:
* Inclusion of a mature README document, inspired by [Standard Readme][-5]
* Inclusion of an open-source LICENSE file
* Inclusion of a structured, yet raw, CHANGELOG file
* Compliance with widely-used version control conventions, such as:
    * [Semantic Versioning][-2]
    * [Conventional Commit][-3]
    * [Keep a Changelog][-4]

### Folder structure
```
.
├── .git/               version control folder
├── .gitignore          ignored files manifest
├── CHANGELOG.md        release notes description
├── LICENSE             license file
└── README.md           readme document
```


## Maintainance [![][B2]][-6]
This project is maintained by the author, [@artu-hnrq](https://github.com/artu-hnrq). \
It has reached a stable, usable state and is being **actively developed**.

[B2]: https://www.repostatus.org/badges/latest/active.svg "Repostatus active badge"


## License [![][B3]][6]
This project is published under the permissions established by [GNU General Public License v3.0][6].

[B3]: https://img.shields.io/github/license/artu-hnrq/Django_GoogleAppEngine_Template?color=green "License badge"
[6]: https://choosealicense.com/licenses/gpl-3.0/ "GPL 3.0 License description"
