import click
import click_log
import logging
import yaml
import json

from convisoappsec.flowcli import help_option
from convisoappsec.flowcli.context import pass_flow_context
from convisoappsec.flowcli.common import project_code_option


logger = logging.getLogger(__name__)
click_log.basic_config(logger)


@click.command('assert-security-rules')
@click_log.simple_verbosity_option(logger)
@project_code_option(
    required=True
)
@click.option(
    '--rules-file',
    'rules_file',
    type=click.File('r'),
    required=True
)
@help_option
@pass_flow_context
def assert_security_rules(flow_context, project_code, rules_file):
    try:
        rules = yaml.load(
            rules_file,
            Loader=yaml.Loader
        )

        flow = flow_context.create_flow_api_client()
        click.secho(
            '\U0001F4AC Starting vulnerabilities security rules assertion',
            bold=True
        )

        response = flow.security_gate.vulnerabilities(project_code, rules)
        __raise_if_gate_locked(response)

        click.secho(
            '\U00002705 Vulnerabilities security rules assertion finished',
            bold=True
        )
    except Exception as e:
        raise click.ClickException(str(e)) from e


def __raise_if_gate_locked(response):
    if response['locked']:
        click.secho('\U0001F4AC Vulnerabilities summary', bold=True)

        logger.info(
            json.dumps(response['summary'], indent=4)
        )

        raise click.ClickException(
            'Vulnerabilities quantity offending security rules'
        )


EPILOG = '''
'''

SHORT_HELP = ''

command = 'flow vulnerability assert-security-rules'
assert_security_rules.short_help = SHORT_HELP
assert_security_rules.epilog = EPILOG.format(
    command=command,
)
