"""
    Whop API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.10
    Contact: support@whop.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from whop.whopclient.api_client import ApiClient, Endpoint as _Endpoint
from whop.whopclient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from whop.whopclient.model.ban_license_by_key_request import BanLicenseByKeyRequest
from whop.whopclient.model.ban_license_by_key_response import BanLicenseByKeyResponse
from whop.whopclient.model.error_response import ErrorResponse
from whop.whopclient.model.get_license_by_key_response import GetLicenseByKeyResponse
from whop.whopclient.model.get_licenses_response import GetLicensesResponse
from whop.whopclient.model.reset_license_by_key_request import ResetLicenseByKeyRequest
from whop.whopclient.model.reset_license_by_key_response import ResetLicenseByKeyResponse
from whop.whopclient.model.update_license_by_key_request import UpdateLicenseByKeyRequest
from whop.whopclient.model.update_license_by_key_response import UpdateLicenseByKeyResponse
from whop.whopclient.model.validate_license_by_key_request import ValidateLicenseByKeyRequest
from whop.whopclient.model.validate_license_by_key_response import ValidateLicenseByKeyResponse


class LicensesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.ban_license_by_key_endpoint = _Endpoint(
            settings={
                'response_type': (BanLicenseByKeyResponse,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/v1/licenses/{key}/ban',
                'operation_id': 'ban_license_by_key',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'key',
                    'ban_license_by_key_request',
                ],
                'required': [
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'key':
                        (str,),
                    'ban_license_by_key_request':
                        (BanLicenseByKeyRequest,),
                },
                'attribute_map': {
                    'key': 'key',
                },
                'location_map': {
                    'key': 'path',
                    'ban_license_by_key_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_license_by_key_endpoint = _Endpoint(
            settings={
                'response_type': (GetLicenseByKeyResponse,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/v1/licenses/{key}',
                'operation_id': 'get_license_by_key',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'key',
                ],
                'required': [
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'key':
                        (str,),
                },
                'attribute_map': {
                    'key': 'key',
                },
                'location_map': {
                    'key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_licenses_endpoint = _Endpoint(
            settings={
                'response_type': (GetLicensesResponse,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/v1/licenses',
                'operation_id': 'get_licenses',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'discord_account_id',
                    'page',
                    'start',
                    'end',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'discord_account_id':
                        (str,),
                    'page':
                        (int,),
                    'start':
                        (str,),
                    'end':
                        (str,),
                },
                'attribute_map': {
                    'discord_account_id': 'discord_account_id',
                    'page': 'page',
                    'start': 'start',
                    'end': 'end',
                },
                'location_map': {
                    'discord_account_id': 'query',
                    'page': 'query',
                    'start': 'query',
                    'end': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.reset_license_by_key_endpoint = _Endpoint(
            settings={
                'response_type': (ResetLicenseByKeyResponse,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/v1/licenses/{key}/reset',
                'operation_id': 'reset_license_by_key',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'key',
                    'reset_license_by_key_request',
                ],
                'required': [
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'key':
                        (str,),
                    'reset_license_by_key_request':
                        (ResetLicenseByKeyRequest,),
                },
                'attribute_map': {
                    'key': 'key',
                },
                'location_map': {
                    'key': 'path',
                    'reset_license_by_key_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_license_by_key_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateLicenseByKeyResponse,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/v1/licenses/{key}',
                'operation_id': 'update_license_by_key',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'key',
                    'update_license_by_key_request',
                ],
                'required': [
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'key':
                        (str,),
                    'update_license_by_key_request':
                        (UpdateLicenseByKeyRequest,),
                },
                'attribute_map': {
                    'key': 'key',
                },
                'location_map': {
                    'key': 'path',
                    'update_license_by_key_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.validate_license_by_key_endpoint = _Endpoint(
            settings={
                'response_type': (ValidateLicenseByKeyResponse,),
                'auth': [
                    'Bearer'
                ],
                'endpoint_path': '/v1/licenses/{key}/validate',
                'operation_id': 'validate_license_by_key',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'key',
                    'validate_license_by_key_request',
                ],
                'required': [
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'key':
                        (str,),
                    'validate_license_by_key_request':
                        (ValidateLicenseByKeyRequest,),
                },
                'attribute_map': {
                    'key': 'key',
                },
                'location_map': {
                    'key': 'path',
                    'validate_license_by_key_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def ban_license_by_key(
        self,
        key,
        **kwargs
    ):
        """Ban License  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ban_license_by_key(key, async_req=True)
        >>> result = thread.get()

        Args:
            key (str): Key of the license you wish to ban.

        Keyword Args:
            ban_license_by_key_request (BanLicenseByKeyRequest): Details of license key metadata.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            BanLicenseByKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['key'] = \
            key
        return self.ban_license_by_key_endpoint.call_with_http_info(**kwargs)

    def get_license_by_key(
        self,
        key,
        **kwargs
    ):
        """Fetch License  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_license_by_key(key, async_req=True)
        >>> result = thread.get()

        Args:
            key (str): Key of the license you wish to fetch.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetLicenseByKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['key'] = \
            key
        return self.get_license_by_key_endpoint.call_with_http_info(**kwargs)

    def get_licenses(
        self,
        **kwargs
    ):
        """Fetch All Licenses  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_licenses(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            discord_account_id (str): ID of the Discord account for which you want to fetch licenses.. [optional]
            page (int): Page number of license data to fetch.. [optional]
            start (str): Start date of license creation. Date should be in the format YYYY-MM-DD.. [optional]
            end (str): End date of license creation. Date should be in the format YYYY-MM-DD.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            GetLicensesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.get_licenses_endpoint.call_with_http_info(**kwargs)

    def reset_license_by_key(
        self,
        key,
        **kwargs
    ):
        """Reset License  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reset_license_by_key(key, async_req=True)
        >>> result = thread.get()

        Args:
            key (str): Key of the license you wish to reset.

        Keyword Args:
            reset_license_by_key_request (ResetLicenseByKeyRequest): Details of license key metadata.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ResetLicenseByKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['key'] = \
            key
        return self.reset_license_by_key_endpoint.call_with_http_info(**kwargs)

    def update_license_by_key(
        self,
        key,
        **kwargs
    ):
        """Update License  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_license_by_key(key, async_req=True)
        >>> result = thread.get()

        Args:
            key (str): Key of the license you wish to update.

        Keyword Args:
            update_license_by_key_request (UpdateLicenseByKeyRequest): Details of license key metadata.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UpdateLicenseByKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['key'] = \
            key
        return self.update_license_by_key_endpoint.call_with_http_info(**kwargs)

    def validate_license_by_key(
        self,
        key,
        **kwargs
    ):
        """Validate Key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.validate_license_by_key(key, async_req=True)
        >>> result = thread.get()

        Args:
            key (str): Key of the license you wish to validate.

        Keyword Args:
            validate_license_by_key_request (ValidateLicenseByKeyRequest): Details of license key metadata.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ValidateLicenseByKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['key'] = \
            key
        return self.validate_license_by_key_endpoint.call_with_http_info(**kwargs)

