//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: luo_rudy_1991
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "new_luo_rudy_1991_with_range.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellnew_luo_rudy_1991_with_rangeFromCellML::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude = -25.5; // microA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 2.0; // millisecond
        const double var_chaste_interface__membrane__stim_end = 100000000000.0; // millisecond
        const double var_chaste_interface__membrane__stim_period = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start, var_chaste_interface__membrane__stim_end
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellnew_luo_rudy_1991_with_rangeFromCellML::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellnew_luo_rudy_1991_with_rangeFromCellML::Cellnew_luo_rudy_1991_with_rangeFromCellML(boost::shared_ptr<AbstractIvpOdeSolver> pSolver, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCardiacCell(
                pSolver,
                8,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellnew_luo_rudy_1991_with_rangeFromCellML>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 145.0; // (var_ionic_concentrations__Ki) [millimolar]
        this->mParameters[1] = 18.0; // (var_ionic_concentrations__Nai) [millimolar]
        this->mParameters[2] = 5.4000000000000004; // (var_ionic_concentrations__Ko) [millimolar]
        this->mParameters[3] = 140.0; // (var_ionic_concentrations__Nao) [millimolar]
        this->mParameters[4] = 0.089999999999999997; // (var_slow_inward_current__P_si) [milliS_per_cm2]
        this->mParameters[5] = 1.0; // (var_membrane__C) [microF_per_cm2]
        this->mParameters[6] = 0.28199999999999997; // (var_time_dependent_potassium_current__g_K_max) [milliS_per_cm2]
        this->mParameters[7] = 23.0; // (var_fast_sodium_current__g_Na) [milliS_per_cm2]
        this->mParameters[8] = 0; // (var_fast_sodium_current__perc_reduced_inact_for_IpNa) [dimensionless]
        this->mParameters[9] = 0; // (var_fast_sodium_current__shift_INa_inact) [millivolt]
        this->mParameters[10] = 0.60470000000000002; // (var_time_independent_potassium_current__g_K1_max) [milliS_per_cm2]
        this->mParameters[11] = 0.039210000000000002; // (var_background_current__g_b) [milliS_per_cm2]
        this->mParameters[12] = 0.0183; // (var_plateau_potassium_current__g_Kp) [milliS_per_cm2]
    }

    Cellnew_luo_rudy_1991_with_rangeFromCellML::~Cellnew_luo_rudy_1991_with_rangeFromCellML()
    {
    }
    
    
    void Cellnew_luo_rudy_1991_with_rangeFromCellML::VerifyStateVariables()
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.00187018
        
        if (var_chaste_interface__fast_sodium_current_m_gate__m < 0.0 || var_chaste_interface__fast_sodium_current_m_gate__m > 1.0)
        {
            EXCEPTION(DumpState("State variable membrane_fast_sodium_current_m_gate has gone out of range. Check numerical parameters, for example time and space stepsizes, and/or solver tolerances"));
        }
        
    }

    
    double Cellnew_luo_rudy_1991_with_rangeFromCellML::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -83.853
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 0.0002
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.00187018
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.9804713
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[4];
        // Units: dimensionless; Initial value: 0.98767124
        double var_chaste_interface__slow_inward_current_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 0.00316354
        double var_chaste_interface__slow_inward_current_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.99427859
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[7];
        // Units: dimensionless; Initial value: 0.16647703
        
        const double var_background_current__E_b = -59.869999999999997; // millivolt
        const double var_membrane__F = 96484.600000000006; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(mParameters[3] / mParameters[1]) / var_membrane__F; // millivolt
        const double var_background_current__i_b = (-var_background_current__E_b + var_chaste_interface__membrane__V) * mParameters[11]; // microA_per_cm2
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * mParameters[7] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // microA_per_cm2
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_inward_current__E_si = 7.7000000000000002 - 13.028700000000001 * log(var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_slow_inward_current__i_si = (-var_slow_inward_current__E_si + var_chaste_interface__membrane__V) * mParameters[4] * var_chaste_interface__slow_inward_current_d_gate__d * var_chaste_interface__slow_inward_current_f_gate__f; // microA_per_cm2
        const double var_time_dependent_potassium_current__PR_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((mParameters[3] * var_time_dependent_potassium_current__PR_NaK + mParameters[2]) / (mParameters[1] * var_time_dependent_potassium_current__PR_NaK + mParameters[0])) / var_membrane__F; // millivolt
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(mParameters[2]) * mParameters[6]; // milliS_per_cm2
        const double var_time_dependent_potassium_current_Xi_gate__B = 0.040000000000000001; // per_millivolt
        const double var_time_dependent_potassium_current_Xi_gate__A = 2.8370000000000002 * var_time_dependent_potassium_current_Xi_gate__B; // dimensionless
        const double var_time_dependent_potassium_current_Xi_gate__v0 = -77.0; // millivolt
        const double var_time_dependent_potassium_current_Xi_gate__U = (-var_time_dependent_potassium_current_Xi_gate__v0 + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current_Xi_gate__B; // dimensionless
        const double var_time_dependent_potassium_current_Xi_gate__temp_Xi = (((var_time_dependent_potassium_current_Xi_gate__U >= -9.9999999999999995e-8) && (var_time_dependent_potassium_current_Xi_gate__U <= 9.9999999999999995e-8)) ? ((1.0 + 0.5 * var_time_dependent_potassium_current_Xi_gate__U) * var_time_dependent_potassium_current_Xi_gate__A) : ((-1.0 + exp(var_time_dependent_potassium_current_Xi_gate__U)) * var_time_dependent_potassium_current_Xi_gate__A / var_time_dependent_potassium_current_Xi_gate__U)); // dimensionless
        const double var_time_dependent_potassium_current_Xi_gate__Xi = ((var_chaste_interface__membrane__V > -100.0) ? (var_time_dependent_potassium_current_Xi_gate__temp_Xi / exp(1.4000000000000001 + 0.040000000000000001 * var_chaste_interface__membrane__V)) : (1.0)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_chaste_interface__time_dependent_potassium_current_X_gate__X * var_time_dependent_potassium_current_Xi_gate__Xi; // microA_per_cm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(mParameters[2] / mParameters[0]) / var_membrane__F; // millivolt
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // millivolt
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * mParameters[12]; // microA_per_cm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(mParameters[2]) * mParameters[10]; // milliS_per_cm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_millisecond
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // microA_per_cm2
        const double var_chaste_interface__i_ionic = var_background_current__i_b + var_fast_sodium_current__i_Na + var_plateau_potassium_current__i_Kp + var_slow_inward_current__i_si + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellnew_luo_rudy_1991_with_rangeFromCellML::EvaluateYDerivatives(double var_chaste_interface__environment__time, const std::vector<double>& rY, std::vector<double>& rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -83.853
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 0.0002
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.00187018
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.9804713
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[4];
        // Units: dimensionless; Initial value: 0.98767124
        double var_chaste_interface__slow_inward_current_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 0.00316354
        double var_chaste_interface__slow_inward_current_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.99427859
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[7];
        // Units: dimensionless; Initial value: 0.16647703

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_fast_sodium_current_m_gate__B = -0.10000000000000001; // per_millivolt
        const double var_fast_sodium_current_m_gate__A = -0.32000000000000001 / var_fast_sodium_current_m_gate__B; // per_millisecond
        const double var_fast_sodium_current_m_gate__v0 = -47.130000000000003; // millivolt
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (0.13500000000000001 * exp(-11.764705882352942 + 0.14705882352941177 * mParameters[9] - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0)); // per_millisecond
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V - 0.34999999999999998 * mParameters[9]) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__V - 0.079000000000000001 * mParameters[9])) : (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 + 0.0900900900900901 * mParameters[9] - 0.0900900900900901 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_h_gate__h_inf = 0.01 * mParameters[8] + (1.0 - 0.01 * mParameters[8]) * var_fast_sodium_current_h_gate__alpha_h / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h); // dimensionless
        const double var_fast_sodium_current_h_gate__tau_h = 1 / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h); // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = (-var_chaste_interface__fast_sodium_current_h_gate__h + var_fast_sodium_current_h_gate__h_inf) / var_fast_sodium_current_h_gate__tau_h; // 1 / millisecond
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V - 0.24440000000000001 * mParameters[9]) - 3.4740000000000003e-5 * exp(0.043909999999999998 * mParameters[9] - 0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V - 0.311 * mParameters[9]))) : (0)); // per_millisecond
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (0.1212 * exp(0.01052 * mParameters[9] - 0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 + 0.13780000000000001 * mParameters[9] - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (0.29999999999999999 * exp(2.5349999999999999e-7 * mParameters[9] - 2.5349999999999999e-7 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 + 0.10000000000000001 * mParameters[9] - 0.10000000000000001 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_j_gate__j_inf = 0.01 * mParameters[8] + (1.0 - 0.01 * mParameters[8]) * var_fast_sodium_current_j_gate__alpha_j / (var_fast_sodium_current_j_gate__alpha_j + var_fast_sodium_current_j_gate__beta_j); // dimensionless
        const double var_fast_sodium_current_j_gate__tau_j = 1 / (var_fast_sodium_current_j_gate__alpha_j + var_fast_sodium_current_j_gate__beta_j); // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_j_gate__j = (-var_chaste_interface__fast_sodium_current_j_gate__j + var_fast_sodium_current_j_gate__j_inf) / var_fast_sodium_current_j_gate__tau_j; // 1 / millisecond
        const double var_fast_sodium_current_m_gate__U = (-var_fast_sodium_current_m_gate__v0 + var_chaste_interface__membrane__V) * var_fast_sodium_current_m_gate__B; // dimensionless
        const double var_fast_sodium_current_m_gate__alpha_m = (((var_fast_sodium_current_m_gate__U >= -9.9999999999999995e-8) && (var_fast_sodium_current_m_gate__U <= 9.9999999999999995e-8)) ? ((1.0 - 0.5 * var_fast_sodium_current_m_gate__U) * var_fast_sodium_current_m_gate__A) : (var_fast_sodium_current_m_gate__A * var_fast_sodium_current_m_gate__U / (-1.0 + exp(var_fast_sodium_current_m_gate__U)))); // per_millisecond
        const double var_fast_sodium_current_m_gate__beta_m = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m * var_chaste_interface__fast_sodium_current_m_gate__m; // 1 / millisecond
        const double var_slow_inward_current__E_si = 7.7000000000000002 - 13.028700000000001 * log(var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_slow_inward_current_d_gate__alpha_d = 0.095000000000000001 * exp(0.050000000000000003 - 0.01 * var_chaste_interface__membrane__V) / (1.0 + exp(0.35999999999999999 - 0.071999999999999995 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_slow_inward_current_d_gate__beta_d = 0.070000000000000007 * exp(-0.748 - 0.017000000000000001 * var_chaste_interface__membrane__V) / (1.0 + exp(2.2000000000000002 + 0.050000000000000003 * var_chaste_interface__membrane__V)); // per_millisecond
        const double d_dt_chaste_interface_var_slow_inward_current_d_gate__d = (1.0 - var_chaste_interface__slow_inward_current_d_gate__d) * var_slow_inward_current_d_gate__alpha_d - var_slow_inward_current_d_gate__beta_d * var_chaste_interface__slow_inward_current_d_gate__d; // 1 / millisecond
        const double var_slow_inward_current_f_gate__alpha_f = 0.012 * exp(-0.224 - 0.0080000000000000002 * var_chaste_interface__membrane__V) / (1.0 + exp(4.2000000000000002 + 0.14999999999999999 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_slow_inward_current_f_gate__beta_f = 0.0064999999999999997 * exp(-0.59999999999999998 - 0.02 * var_chaste_interface__membrane__V) / (1.0 + exp(-6.0 - 0.20000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double d_dt_chaste_interface_var_slow_inward_current_f_gate__f = (1.0 - var_chaste_interface__slow_inward_current_f_gate__f) * var_slow_inward_current_f_gate__alpha_f - var_slow_inward_current_f_gate__beta_f * var_chaste_interface__slow_inward_current_f_gate__f; // 1 / millisecond
        const double var_slow_inward_current__i_si = (-var_slow_inward_current__E_si + var_chaste_interface__membrane__V) * mParameters[4] * var_chaste_interface__slow_inward_current_d_gate__d * var_chaste_interface__slow_inward_current_f_gate__f; // microA_per_cm2
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai = 7.0000000000000007e-6 - 0.070000000000000007 * var_chaste_interface__intracellular_calcium_concentration__Cai - 0.0001 * var_slow_inward_current__i_si; // millimolar / millisecond
        const double var_time_dependent_potassium_current_X_gate__alpha_X = 0.00050000000000000001 * exp(4.1500000000000004 + 0.083000000000000004 * var_chaste_interface__membrane__V) / (1.0 + exp(2.8500000000000001 + 0.057000000000000002 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_time_dependent_potassium_current_X_gate__beta_X = 0.0012999999999999999 * exp(-1.2 - 0.059999999999999998 * var_chaste_interface__membrane__V) / (1.0 + exp(-0.80000000000000004 - 0.040000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double d_dt_chaste_interface_var_time_dependent_potassium_current_X_gate__X = (1.0 - var_chaste_interface__time_dependent_potassium_current_X_gate__X) * var_time_dependent_potassium_current_X_gate__alpha_X - var_chaste_interface__time_dependent_potassium_current_X_gate__X * var_time_dependent_potassium_current_X_gate__beta_X; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_background_current__E_b = -59.869999999999997; // millivolt
            const double var_membrane__F = 96484.600000000006; // coulomb_per_mole
            const double var_membrane__I_stim = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // microA_per_cm2
            const double var_membrane__R = 8314.0; // joule_per_kilomole_kelvin
            const double var_membrane__T = 310.0; // kelvin
            const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(mParameters[3] / mParameters[1]) / var_membrane__F; // millivolt
            const double var_background_current__i_b = (-var_background_current__E_b + var_chaste_interface__membrane__V) * mParameters[11]; // microA_per_cm2
            const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * mParameters[7] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // microA_per_cm2
            const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
            const double var_time_dependent_potassium_current__PR_NaK = 0.018329999999999999; // dimensionless
            const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((mParameters[3] * var_time_dependent_potassium_current__PR_NaK + mParameters[2]) / (mParameters[1] * var_time_dependent_potassium_current__PR_NaK + mParameters[0])) / var_membrane__F; // millivolt
            const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(mParameters[2]) * mParameters[6]; // milliS_per_cm2
            const double var_time_dependent_potassium_current_Xi_gate__B = 0.040000000000000001; // per_millivolt
            const double var_time_dependent_potassium_current_Xi_gate__A = 2.8370000000000002 * var_time_dependent_potassium_current_Xi_gate__B; // dimensionless
            const double var_time_dependent_potassium_current_Xi_gate__v0 = -77.0; // millivolt
            const double var_time_dependent_potassium_current_Xi_gate__U = (-var_time_dependent_potassium_current_Xi_gate__v0 + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current_Xi_gate__B; // dimensionless
            const double var_time_dependent_potassium_current_Xi_gate__temp_Xi = (((var_time_dependent_potassium_current_Xi_gate__U >= -9.9999999999999995e-8) && (var_time_dependent_potassium_current_Xi_gate__U <= 9.9999999999999995e-8)) ? ((1.0 + 0.5 * var_time_dependent_potassium_current_Xi_gate__U) * var_time_dependent_potassium_current_Xi_gate__A) : ((-1.0 + exp(var_time_dependent_potassium_current_Xi_gate__U)) * var_time_dependent_potassium_current_Xi_gate__A / var_time_dependent_potassium_current_Xi_gate__U)); // dimensionless
            const double var_time_dependent_potassium_current_Xi_gate__Xi = ((var_chaste_interface__membrane__V > -100.0) ? (var_time_dependent_potassium_current_Xi_gate__temp_Xi / exp(1.4000000000000001 + 0.040000000000000001 * var_chaste_interface__membrane__V)) : (1.0)); // dimensionless
            const double var_time_dependent_potassium_current__i_K = (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_chaste_interface__time_dependent_potassium_current_X_gate__X * var_time_dependent_potassium_current_Xi_gate__Xi; // microA_per_cm2
            const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(mParameters[2] / mParameters[0]) / var_membrane__F; // millivolt
            const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // millivolt
            const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * mParameters[12]; // microA_per_cm2
            const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(mParameters[2]) * mParameters[10]; // milliS_per_cm2
            const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_millisecond
            const double var_time_independent_potassium_current_K1_gate__beta_K1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_millisecond
            const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
            const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // microA_per_cm2
            d_dt_chaste_interface_var_membrane__V = -1.0 * (var_background_current__i_b + var_fast_sodium_current__i_Na + var_membrane__I_stim + var_plateau_potassium_current__i_Kp + var_slow_inward_current__i_si + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1) / mParameters[5]; // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__V;
        rDY[1] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai;
        rDY[2] = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        rDY[3] = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        rDY[4] = d_dt_chaste_interface_var_fast_sodium_current_j_gate__j;
        rDY[5] = d_dt_chaste_interface_var_slow_inward_current_d_gate__d;
        rDY[6] = d_dt_chaste_interface_var_slow_inward_current_f_gate__f;
        rDY[7] = d_dt_chaste_interface_var_time_dependent_potassium_current_X_gate__X;
    }

    std::vector<double> Cellnew_luo_rudy_1991_with_rangeFromCellML::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -83.853
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 0.0002
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.00187018
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.9804713
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[4];
        // Units: dimensionless; Initial value: 0.98767124
        double var_chaste_interface__slow_inward_current_d_gate__d = rY[5];
        // Units: dimensionless; Initial value: 0.00316354
        double var_chaste_interface__slow_inward_current_f_gate__f = rY[6];
        // Units: dimensionless; Initial value: 0.99427859
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[7];
        // Units: dimensionless; Initial value: 0.16647703
        

        // Mathematics
        const double var_background_current__E_b = -59.869999999999997; // millivolt
        const double var_membrane__F = 96484.600000000006; // coulomb_per_mole
        const double var_membrane__I_stim = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // microA_per_cm2
        const double var_membrane__R = 8314.0; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(mParameters[3] / mParameters[1]) / var_membrane__F; // millivolt
        const double var_background_current__i_b = (-var_background_current__E_b + var_chaste_interface__membrane__V) * mParameters[11]; // microA_per_cm2
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * mParameters[7] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // microA_per_cm2
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (0.13500000000000001 * exp(-11.764705882352942 + 0.14705882352941177 * mParameters[9] - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0)); // per_millisecond
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V - 0.34999999999999998 * mParameters[9]) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__V - 0.079000000000000001 * mParameters[9])) : (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 + 0.0900900900900901 * mParameters[9] - 0.0900900900900901 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_h_gate__tau_h = 1 / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h); // millisecond
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V - 0.24440000000000001 * mParameters[9]) - 3.4740000000000003e-5 * exp(0.043909999999999998 * mParameters[9] - 0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V - 0.311 * mParameters[9]))) : (0)); // per_millisecond
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (0.1212 * exp(0.01052 * mParameters[9] - 0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 + 0.13780000000000001 * mParameters[9] - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (0.29999999999999999 * exp(2.5349999999999999e-7 * mParameters[9] - 2.5349999999999999e-7 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 + 0.10000000000000001 * mParameters[9] - 0.10000000000000001 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_j_gate__tau_j = 1 / (var_fast_sodium_current_j_gate__alpha_j + var_fast_sodium_current_j_gate__beta_j); // millisecond
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_inward_current__E_si = 7.7000000000000002 - 13.028700000000001 * log(var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_slow_inward_current_f_gate__alpha_f = 0.012 * exp(-0.224 - 0.0080000000000000002 * var_chaste_interface__membrane__V) / (1.0 + exp(4.2000000000000002 + 0.14999999999999999 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_slow_inward_current_f_gate__beta_f = 0.0064999999999999997 * exp(-0.59999999999999998 - 0.02 * var_chaste_interface__membrane__V) / (1.0 + exp(-6.0 - 0.20000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_slow_inward_current__i_si = (-var_slow_inward_current__E_si + var_chaste_interface__membrane__V) * mParameters[4] * var_chaste_interface__slow_inward_current_d_gate__d * var_chaste_interface__slow_inward_current_f_gate__f; // microA_per_cm2
        const double var_slow_inward_current_f_gate__tau_f = 1 / (var_slow_inward_current_f_gate__alpha_f + var_slow_inward_current_f_gate__beta_f); // millisecond
        const double var_time_dependent_potassium_current__PR_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((mParameters[3] * var_time_dependent_potassium_current__PR_NaK + mParameters[2]) / (mParameters[1] * var_time_dependent_potassium_current__PR_NaK + mParameters[0])) / var_membrane__F; // millivolt
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(mParameters[2]) * mParameters[6]; // milliS_per_cm2
        const double var_time_dependent_potassium_current_Xi_gate__B = 0.040000000000000001; // per_millivolt
        const double var_time_dependent_potassium_current_Xi_gate__A = 2.8370000000000002 * var_time_dependent_potassium_current_Xi_gate__B; // dimensionless
        const double var_time_dependent_potassium_current_Xi_gate__v0 = -77.0; // millivolt
        const double var_time_dependent_potassium_current_Xi_gate__U = (-var_time_dependent_potassium_current_Xi_gate__v0 + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current_Xi_gate__B; // dimensionless
        const double var_time_dependent_potassium_current_Xi_gate__temp_Xi = (((var_time_dependent_potassium_current_Xi_gate__U >= -9.9999999999999995e-8) && (var_time_dependent_potassium_current_Xi_gate__U <= 9.9999999999999995e-8)) ? ((1.0 + 0.5 * var_time_dependent_potassium_current_Xi_gate__U) * var_time_dependent_potassium_current_Xi_gate__A) : ((-1.0 + exp(var_time_dependent_potassium_current_Xi_gate__U)) * var_time_dependent_potassium_current_Xi_gate__A / var_time_dependent_potassium_current_Xi_gate__U)); // dimensionless
        const double var_time_dependent_potassium_current_Xi_gate__Xi = ((var_chaste_interface__membrane__V > -100.0) ? (var_time_dependent_potassium_current_Xi_gate__temp_Xi / exp(1.4000000000000001 + 0.040000000000000001 * var_chaste_interface__membrane__V)) : (1.0)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_chaste_interface__time_dependent_potassium_current_X_gate__X * var_time_dependent_potassium_current_Xi_gate__Xi; // microA_per_cm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(mParameters[2] / mParameters[0]) / var_membrane__F; // millivolt
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // millivolt
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * mParameters[12]; // microA_per_cm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(mParameters[2]) * mParameters[10]; // milliS_per_cm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_millisecond
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // microA_per_cm2

        std::vector<double> dqs(11);
        dqs[0] = var_slow_inward_current__i_si;
        dqs[1] = var_slow_inward_current_f_gate__tau_f;
        dqs[2] = var_time_dependent_potassium_current__i_K;
        dqs[3] = var_fast_sodium_current__i_Na;
        dqs[4] = var_fast_sodium_current_h_gate__tau_h;
        dqs[5] = var_fast_sodium_current_j_gate__tau_j;
        dqs[6] = var_time_independent_potassium_current__i_K1;
        dqs[7] = var_background_current__i_b;
        dqs[8] = var_plateau_potassium_current__i_Kp;
        dqs[9] = var_membrane__I_stim;
        dqs[10] = var_chaste_interface__environment__time;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellnew_luo_rudy_1991_with_rangeFromCellML>::Initialise(void)
{
    this->mSystemName = "luo_rudy_1991";
    this->mFreeVariableName = "time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-83.853);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0002);

    // rY[2]:
    this->mVariableNames.push_back("membrane_fast_sodium_current_m_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00187018);

    // rY[3]:
    this->mVariableNames.push_back("membrane_fast_sodium_current_h_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9804713);

    // rY[4]:
    this->mVariableNames.push_back("membrane_fast_sodium_current_j_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.98767124);

    // rY[5]:
    this->mVariableNames.push_back("membrane_L_type_calcium_current_d_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00316354);

    // rY[6]:
    this->mVariableNames.push_back("membrane_L_type_calcium_current_f_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99427859);

    // rY[7]:
    this->mVariableNames.push_back("time_dependent_potassium_current_X_gate__X");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.16647703);

    // mParameters[0]:
    this->mParameterNames.push_back("cytosolic_potassium_concentration");
    this->mParameterUnits.push_back("millimolar");

    // mParameters[1]:
    this->mParameterNames.push_back("cytosolic_sodium_concentration");
    this->mParameterUnits.push_back("millimolar");

    // mParameters[2]:
    this->mParameterNames.push_back("extracellular_potassium_concentration");
    this->mParameterUnits.push_back("millimolar");

    // mParameters[3]:
    this->mParameterNames.push_back("extracellular_sodium_concentration");
    this->mParameterUnits.push_back("millimolar");

    // mParameters[4]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("milliS_per_cm2");

    // mParameters[5]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF_per_cm2");

    // mParameters[6]:
    this->mParameterNames.push_back("membrane_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("milliS_per_cm2");

    // mParameters[7]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("milliS_per_cm2");

    // mParameters[8]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_reduced_inactivation");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[9]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_shift_inactivation");
    this->mParameterUnits.push_back("millivolt");

    // mParameters[10]:
    this->mParameterNames.push_back("membrane_inward_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("milliS_per_cm2");

    // mParameters[11]:
    this->mParameterNames.push_back("membrane_leakage_current_conductance");
    this->mParameterUnits.push_back("milliS_per_cm2");

    // mParameters[12]:
    this->mParameterNames.push_back("membrane_plateau_potassium_current_conductance");
    this->mParameterUnits.push_back("milliS_per_cm2");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("membrane_L_type_calcium_current");
    this->mDerivedQuantityUnits.push_back("microA_per_cm2");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_L_type_calcium_current_f_gate_tau");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_delayed_rectifier_potassium_current");
    this->mDerivedQuantityUnits.push_back("microA_per_cm2");

    // Derived Quantity index [3]:
    this->mDerivedQuantityNames.push_back("membrane_fast_sodium_current");
    this->mDerivedQuantityUnits.push_back("microA_per_cm2");

    // Derived Quantity index [4]:
    this->mDerivedQuantityNames.push_back("membrane_fast_sodium_current_h_gate_tau");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [5]:
    this->mDerivedQuantityNames.push_back("membrane_fast_sodium_current_j_gate_tau");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [6]:
    this->mDerivedQuantityNames.push_back("membrane_inward_rectifier_potassium_current");
    this->mDerivedQuantityUnits.push_back("microA_per_cm2");

    // Derived Quantity index [7]:
    this->mDerivedQuantityNames.push_back("membrane_leakage_current");
    this->mDerivedQuantityUnits.push_back("microA_per_cm2");

    // Derived Quantity index [8]:
    this->mDerivedQuantityNames.push_back("membrane_plateau_potassium_current");
    this->mDerivedQuantityUnits.push_back("microA_per_cm2");

    // Derived Quantity index [9]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("microA_per_cm2");

    // Derived Quantity index [10]:
    this->mDerivedQuantityNames.push_back("time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellnew_luo_rudy_1991_with_rangeFromCellML)
