//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: matsuoka_model_2003
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "dynamic_matsuoka_model_2003.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.0040000000000000001 * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 2.0; // millisecond
        const double var_chaste_interface__membrane__stim_period = 400.0; // millisecond
        const double var_chaste_interface__membrane__stim_start = 50.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::Dynamicmatsuoka_model_2003FromCellMLGRL1Opt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                37,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Dynamicmatsuoka_model_2003FromCellMLGRL1Opt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 132.0; // (var_membrane__Cm) [picoF]
    }

    Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::~Dynamicmatsuoka_model_2003FromCellMLGRL1Opt()
    {
    }
    
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-1.8) : (0.074870384603595908 * (-1.8 * exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm) + var_internal_ion_concentrations__Cai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : (0.037435192301797954 * (-5.4000000000000004 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Ki) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-140.0) : (0.037435192301797954 * (-140.0 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Nai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_time_independent_potassium_current__E_K = 26.712831923985377 * log(5.4000000000000004 / var_chaste_interface__internal_ion_concentrations__Ki); // millivolt
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_membrane__i_tot = 0.38500000000000001 * var_constant_field_equations__CF_Na + 0.040000000000000001 * var_constant_field_equations__CF_Ca + 0.15400000000000003 * var_constant_field_equations__CF_K + 21.0 * (-0.040000000000000001 * (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) / (1.0 + 14.894617648090152 * pow(1 / exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm), 1.0600000000000001)) + 0.37 * var_chaste_interface__sodium_potassium_pump_y_gate__y / ((1.0 + 0.094 / var_chaste_interface__ATP_production__ATPi) * (1.0 + 4.4045579125871104 * pow(1 / var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001) * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001))))) * mParameters[0] + 8712.0 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca + 6.8099999999999996 * (-0.6399652192815608 * (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm) + var_chaste_interface__sodium_calcium_exchanger_y_gate__y * exp(0.011979261536575346 * var_chaste_interface__membrane__Vm) / (1.0 + 669.921875 * (1.0 + 724.63768115942037 * var_internal_ion_concentrations__Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3))) * mParameters[0] + 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_K + 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na + 3.1798799999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K + 66.022388395163091 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)) + 0.16117199999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na + 612.0 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca + 2860.0 * var_constant_field_equations__CF_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + 0.2016 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na + 0.033000000000000002 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_chaste_interface__transient_outward_current_y2_gate__y2 + 5.04 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K + 0.00297 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_chaste_interface__transient_outward_current_y2_gate__y2 + 286.0 * var_constant_field_equations__CF_K * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + 1.1459999999999999 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (pow(var_time_independent_potassium_current__fO, 4) + 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2) + 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB) * mParameters[0] * var_chaste_interface__time_independent_potassium_current_y_gate__y + 0.0086400000000000001 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * mParameters[0] * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 + ((var_chaste_interface__membrane__Vm == (-3.0)) ? (0.0014308470000000001 * var_constant_field_equations__CF_K) : (0.00011 * (3.0 + var_chaste_interface__membrane__Vm) * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_chaste_interface__i_ionic = HeartConfig::Instance()->GetCapacitance() * var_membrane__i_tot / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;

        double d_dt_chaste_interface_var_membrane__Vm;
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        

        // Mathematics
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-1.8) : (0.074870384603595908 * (-1.8 * exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm) + var_internal_ion_concentrations__Cai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Ca = 8712.0 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca; // picoA
        const double var_T_type_Ca_channel__i_Ca_T = 612.0 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca; // picoA
        const double var_background_Cab_current__i_Cab = 0.040000000000000001 * var_constant_field_equations__CF_Ca; // picoA
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : (0.037435192301797954 * (-5.4000000000000004 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Ki) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_K = 3.1798799999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K; // picoA
        const double var_background_Kpl_current__i_Kpl = ((var_chaste_interface__membrane__Vm == (-3.0)) ? (0.0014308470000000001 * var_constant_field_equations__CF_K) : (0.00011 * (3.0 + var_chaste_interface__membrane__Vm) * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_background_NSC_current__i_bNSC_K = 0.15400000000000003 * var_constant_field_equations__CF_K; // picoA
        const double var_background_lCa_current__i_lCa_K = 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_K; // picoA
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-140.0) : (0.037435192301797954 * (-140.0 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Nai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Na = 0.16117199999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na; // picoA
        const double var_background_NSC_current__i_bNSC_Na = 0.38500000000000001 * var_constant_field_equations__CF_Na; // picoA
        const double var_background_lCa_current__i_lCa_Na = 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na; // picoA
        const double var_membrane__i_ext = 1.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time) * mParameters[0] / HeartConfig::Instance()->GetCapacitance(); // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_K = 5.04 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_Na = 0.2016 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na; // picoA
        const double var_sodium_calcium_exchanger__k1 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + 669.921875 * (1.0 + 724.63768115942037 * var_internal_ion_concentrations__Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa = 6.8099999999999996 * (-0.6399652192815608 * (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 + var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * mParameters[0]; // picoA
        const double var_sodium_current__i_Na_K = 286.0 * var_constant_field_equations__CF_K * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na_Na = 2860.0 * var_constant_field_equations__CF_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_potassium_pump__Nao_Eff = 140.0 * exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm); // millimolar
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + 0.094 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + 4.4045579125871104 * pow(1 / var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001) * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + 2804.9496956618664 * pow(1 / var_sodium_potassium_pump__Nao_Eff, 1.0600000000000001)); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = 21.0 * (-0.040000000000000001 * (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__p_E2Na + var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y) * mParameters[0]; // picoA
        const double var_time_independent_potassium_current__E_K = 26.712831923985377 * log(5.4000000000000004 / var_chaste_interface__internal_ion_concentrations__Ki); // millivolt
        const double var_background_KATP_current__i_KATP = 66.022388395163091 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)); // picoA
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.0086400000000000001 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * mParameters[0] * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // picoA
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = 1.1459999999999999 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (pow(var_time_independent_potassium_current__fO, 4) + 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2) + 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB) * mParameters[0] * var_chaste_interface__time_independent_potassium_current_y_gate__y; // picoA
        const double var_transient_outward_current__i_to_K = 0.033000000000000002 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_transient_outward_current__i_to_Na = 0.00297 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        d_dt_chaste_interface_var_membrane__Vm = (-var_L_type_Ca_channel__i_CaL_Ca - var_L_type_Ca_channel__i_CaL_K - var_L_type_Ca_channel__i_CaL_Na - var_T_type_Ca_channel__i_Ca_T - var_background_Cab_current__i_Cab - var_background_KATP_current__i_KATP - var_background_Kpl_current__i_Kpl - var_background_NSC_current__i_bNSC_K - var_background_NSC_current__i_bNSC_Na - var_background_lCa_current__i_lCa_K - var_background_lCa_current__i_lCa_Na - var_membrane__i_ext - var_rapid_time_dependent_potassium_current__i_Kr - var_slow_time_dependent_potassium_current__i_Ks_K - var_slow_time_dependent_potassium_current__i_Ks_Na - var_sodium_calcium_exchanger__i_NaCa - var_sodium_current__i_Na_K - var_sodium_current__i_Na_Na - var_sodium_potassium_pump__i_NaK - var_time_independent_potassium_current__i_K1 - var_transient_outward_current__i_to_K - var_transient_outward_current__i_to_Na) / mParameters[0]; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane__Vm;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__Vm;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta = 1e-8;

        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na = rY[6];
        // Units: dimensionless; Initial value: 0.3556412697995689
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na = rY[7];
        // Units: dimensionless; Initial value: 0.40285968661346977
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = rY[10];
        // Units: dimensionless; Initial value: 0.9968480629364956
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = rY[11];
        // Units: dimensionless; Initial value: 0.000877325391245903
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C = rY[14];
        // Units: dimensionless; Initial value: 0.4250747299372254
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        double var_chaste_interface__SR_calcium_pump_y_gate__y = rY[28];
        // Units: dimensionless; Initial value: 0.46108441538480216
        double var_chaste_interface__RyR_channel__p_open_RyR = rY[29];
        // Units: dimensionless; Initial value: 0.00034314360001543243
        double var_chaste_interface__RyR_channel__p_close_RyR = rY[30];
        // Units: dimensionless; Initial value: 0.19135178123107768
        double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rY[31];
        // Units: millimolar; Initial value: 9.455741736977666
        double var_chaste_interface__Ca_concentrations_in_SR__Caup = rY[32];
        // Units: millimolar; Initial value: 2.611712901567567
        double var_chaste_interface__NL_model__pCa = rY[33];
        // Units: dimensionless; Initial value: 0.02490898775497523
        double var_chaste_interface__NL_model__pCaCB = rY[34];
        // Units: dimensionless; Initial value: 0.001990153835322864
        double var_chaste_interface__NL_model__pCB = rY[35];
        // Units: dimensionless; Initial value: 0.00042941813853474524
        double var_chaste_interface__NL_model__X = rY[36];
        // Units: micrometre; Initial value: 0.9573749975411884
        
        
        // Mathematics
        const double var_Ca_concentrations_in_SR__Carel = -5.4000000000000004 + 0.5 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + 5.4000000000000004 * sqrt(pow((1 - 0.092592592592592587 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total), 2) + 0.027434842249657067 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total); // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__p_CCa = 1.0 - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa; // dimensionless
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL = 1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // dimensionless
        const double d_dt_chaste_interface_var_NL_model__X = 1.1488559970494261 - 1.2 * var_chaste_interface__NL_model__X; // micrometre / millisecond
        const double var_NL_model__Q_a = -0.0038999999999999998 * var_chaste_interface__NL_model__pCaCB + 0.0038999999999999998 * var_chaste_interface__NL_model__pCa * exp(-0.86212130841993795); // per_millisecond
        const double var_NL_model__Q_d2 = 0.027 * pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_chaste_interface__NL_model__pCaCB; // per_millisecond
        const double var_SR_T_current__i_SR_T = 386.0 * var_chaste_interface__Ca_concentrations_in_SR__Caup - 386.0 * var_Ca_concentrations_in_SR__Carel; // picoA
        const double var_SR_calcium_pump__k2 = 1 / (1.0 + 0.10000000000000001 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_SR_calcium_pump__p_E1Ca = 1 / (1.0 + 0.080000000000000002 / var_chaste_interface__Ca_concentrations_in_SR__Caup); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_NL_model__Q_b = -0.029999999999999999 * var_chaste_interface__NL_model__pCa + 39.0 * (1.0 - var_chaste_interface__NL_model__pCB - var_chaste_interface__NL_model__pCa - var_chaste_interface__NL_model__pCaCB) * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCa = -var_NL_model__Q_a + var_NL_model__Q_b; // 1 / millisecond
        const double var_NL_model__Q_r = 0.029999999999999999 * var_chaste_interface__NL_model__pCaCB - 1560.0 * var_chaste_interface__NL_model__pCB * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCB = -0.12 * var_chaste_interface__NL_model__pCB - 0.027 * pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_chaste_interface__NL_model__pCB + var_NL_model__Q_r; // 1 / millisecond
        const double d_dt_chaste_interface_var_NL_model__pCaCB = -var_NL_model__Q_d2 - var_NL_model__Q_r + var_NL_model__Q_a; // 1 / millisecond
        const double var_RyR_channel__i_RyR = 62000.0 * (-var_internal_ion_concentrations__Cai + var_Ca_concentrations_in_SR__Carel) * var_chaste_interface__RyR_channel__p_open_RyR; // picoA
        const double var_SR_L_current__i_SR_L = 459.0 * var_chaste_interface__Ca_concentrations_in_SR__Caup - 459.0 * var_internal_ion_concentrations__Cai; // picoA
        const double var_SR_calcium_pump__p_E2Ca = 1 / (1.0 + 0.00080000000000000004 / var_internal_ion_concentrations__Cai); // dimensionless
        const double var_SR_calcium_pump__i_SR_U = 1625.0 * var_SR_calcium_pump__p_E1Ca * var_chaste_interface__SR_calcium_pump_y_gate__y - 162500.0 * (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca; // picoA
        const double d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y = (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * (0.01 - 0.01 * var_SR_calcium_pump__p_E2Ca + var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca) - (1.0 - 0.98999999999999999 * var_SR_calcium_pump__p_E1Ca) * var_chaste_interface__SR_calcium_pump_y_gate__y; // 1 / millisecond
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total = 3.2387883511406234e-5 * var_SR_T_current__i_SR_T - 3.2387883511406234e-5 * var_RyR_channel__i_RyR; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup = -1.2955153404562494e-5 * var_SR_L_current__i_SR_L - 1.2955153404562494e-5 * var_SR_T_current__i_SR_T - 1.2955153404562494e-5 * var_SR_calcium_pump__i_SR_U; // millimolar / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_ultra_slow_gate__y = (1.0 - var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y) / (58.0 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm) + 250000.0 * exp(0.1111111111111111 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y / (66.0 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 1800.0 * exp(-0.071428571428571425 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI = 1 / (11.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 2200000.0 * exp(0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP = 1 / (480.0 * exp(0.14285714285714285 * var_chaste_interface__membrane__Vm) + 2.2000000000000002 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI = 1 / (2.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.0018 * exp(-0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = 0.0040000000000000001 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI * var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL - (0.001 + var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL; // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP = 1 / (1.5 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 0.27000000000000002 * exp(-0.16949152542372881 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = 0.001 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL - (0.0040000000000000001 + var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI = 0.040000000000000001 / (1.0 + 0.25 * var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP * var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI / (var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI * var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = (0.040000000000000001 - var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI) * var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL - (var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP + var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // 1 / millisecond
        const double d_dt_chaste_interface_var_T_type_Ca_channel_y1_gate__y1 = (1.0 - var_chaste_interface__T_type_Ca_channel_y1_gate__y1) / (0.019 * exp(-0.17857142857142858 * var_chaste_interface__membrane__Vm) + 0.81999999999999995 * exp(-0.0040000000000000001 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 / (1.5 * exp(0.0001 * var_chaste_interface__membrane__Vm) + 40.0 * exp(0.15873015873015872 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double d_dt_chaste_interface_var_T_type_Ca_channel_y2_gate__y2 = (1.0 - var_chaste_interface__T_type_Ca_channel_y2_gate__y2) / (30.0 * exp(0.00033333333333333332 * var_chaste_interface__membrane__Vm) + 62000.0 * exp(0.099009900990099015 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 / (1.2 * exp(-0.040000000000000001 * var_chaste_interface__membrane__Vm) + 0.00059999999999999995 * exp(-0.14925373134328357 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-1.8) : (0.074870384603595908 * (-1.8 * exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm) + var_internal_ion_concentrations__Cai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Ca = 8712.0 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__iCaL = 0.067599999999999993 * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__Cacm = -0.29999999999999999 * var_L_type_Ca_channel_Ca_dependent_gate__iCaL + var_internal_ion_concentrations__Cai; // millimolar
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C = 0.34999999999999998 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + 0.0041999999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__p_CCa - (0.14299999999999999 + 6.9539999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C; // 1 / millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca = 6.9539999999999997 * (1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL) * var_internal_ion_concentrations__Cai + 6.9539999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U = 0.14299999999999999 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C + 2.0019999999999998 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa - (0.34999999999999998 + var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa = 0.00029999999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__p_CCa - 2.3519999999999999 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa + var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U; // 1 / millisecond
        const double var_RyR_channel__k1 = 280000.0 * pow(var_internal_ion_concentrations__Cai, 2) - 150.0 * var_L_type_Ca_channel__p_open_CaL * var_L_type_Ca_channel_Ca_dependent_gate__iCaL; // per_millisecond
        const double d_dt_chaste_interface_var_RyR_channel__p_close_RyR = -(0.00084900000000000004 + var_RyR_channel__k1) * var_chaste_interface__RyR_channel__p_close_RyR + 0.000377 * pow(var_Ca_concentrations_in_SR__Carel, 2) * (1.0 - var_chaste_interface__RyR_channel__p_close_RyR - var_chaste_interface__RyR_channel__p_open_RyR); // 1 / millisecond
        const double d_dt_chaste_interface_var_RyR_channel__p_open_RyR = var_RyR_channel__k1 * var_chaste_interface__RyR_channel__p_close_RyR - 0.080000000000000002 * var_chaste_interface__RyR_channel__p_open_RyR / (1.0 + 0.35999999999999999 / var_Ca_concentrations_in_SR__Carel); // 1 / millisecond
        const double var_T_type_Ca_channel__i_Ca_T = 612.0 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca; // picoA
        const double var_background_Cab_current__i_Cab = 0.040000000000000001 * var_constant_field_equations__CF_Ca; // picoA
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : (0.037435192301797954 * (-5.4000000000000004 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Ki) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_K = 3.1798799999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K; // picoA
        const double var_background_Kpl_current__i_Kpl = ((var_chaste_interface__membrane__Vm == (-3.0)) ? (0.0014308470000000001 * var_constant_field_equations__CF_K) : (0.00011 * (3.0 + var_chaste_interface__membrane__Vm) * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_background_NSC_current__i_bNSC_K = 0.15400000000000003 * var_constant_field_equations__CF_K; // picoA
        const double var_background_lCa_current__i_lCa_K = 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_K; // picoA
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-140.0) : (0.037435192301797954 * (-140.0 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Nai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Na = 0.16117199999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na; // picoA
        const double var_background_NSC_current__i_bNSC_Na = 0.38500000000000001 * var_constant_field_equations__CF_Na; // picoA
        const double var_background_lCa_current__i_lCa_Na = 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na; // picoA
        const double var_membrane__i_ext = 1.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time) * mParameters[0] / HeartConfig::Instance()->GetCapacitance(); // picoA
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y1_gate__y1 = -(1 / (160.0 * exp(0.035714285714285712 * var_chaste_interface__membrane__Vm) + 200.0 * exp(0.001 * var_chaste_interface__membrane__Vm)) + 0.00040000000000000002 / exp(0.050000000000000003 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 + (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) / (5.0 * exp(-0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 20.0 * exp(-0.086956521739130432 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y2_gate__y2 = -(1 / (1600.0 * exp(0.035714285714285712 * var_chaste_interface__membrane__Vm) + 2000.0 * exp(0.001 * var_chaste_interface__membrane__Vm)) + 0.0001 / exp(0.050000000000000003 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2) / (20.0 * exp(-0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 200.0 * exp(-0.076923076923076927 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y3_gate__y3 = (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3) / (2.5 * exp(0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 10.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 / (2.0 * exp(-0.0066666666666666671 * var_chaste_interface__membrane__Vm) + 0.34999999999999998 * exp(-0.058823529411764705 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y1_gate__y1 = (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1) / (85.0 * exp(-0.095238095238095233 * var_chaste_interface__membrane__Vm) + 370.0 * exp(-0.016129032258064516 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 / (260.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 1450.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2 = -0.004444 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 + 3.7000000000000002 * (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_internal_ion_concentrations__Cai; // 1 / millisecond
        const double var_slow_time_dependent_potassium_current__i_Ks_K = 5.04 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_Na = 0.2016 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na; // picoA
        const double var_sodium_calcium_exchanger__k1 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + 669.921875 * (1.0 + 724.63768115942037 * var_internal_ion_concentrations__Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y = (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * (0.20379327210477693 + 0.6399652192815608 * var_sodium_calcium_exchanger__k2) - (1 / (1.0 + 0.0013799999999999999 * (1.0 + 0.0014927113702623907 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)) / var_internal_ion_concentrations__Cai) + var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na) * var_chaste_interface__sodium_calcium_exchanger_y_gate__y; // 1 / millisecond
        const double var_sodium_calcium_exchanger__i_NaCa = 6.8099999999999996 * (-0.6399652192815608 * (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 + var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * mParameters[0]; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total = 0.070000000000000007 * var_NL_model__Q_d2 + 0.070000000000000007 * var_NL_model__Q_r + 6.4775767022812476e-7 * var_RyR_channel__i_RyR + 6.4775767022812476e-7 * var_SR_L_current__i_SR_L + 6.4775767022812476e-7 * var_SR_calcium_pump__i_SR_U + 1.2955153404562495e-6 * var_sodium_calcium_exchanger__i_NaCa - 0.070000000000000007 * var_NL_model__Q_b - 6.4775767022812476e-7 * var_L_type_Ca_channel__i_CaL_Ca - 6.4775767022812476e-7 * var_T_type_Ca_channel__i_Ca_T - 6.4775767022812476e-7 * var_background_Cab_current__i_Cab; // millimolar / millisecond
        const double d_dt_chaste_interface_var_sodium_current_ultra_slow_gate__y = (1.0 - var_chaste_interface__sodium_current_ultra_slow_gate__y) / (8000.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 9000000000.0 * exp(0.20000000000000001 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__sodium_current_ultra_slow_gate__y / (4000.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.014 * exp(-0.20000000000000001 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AI_RI = 1 / (1300.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm) + 0.040000000000000001 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_AI = 1.25 / exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_RP = 1 / (26.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm) + 0.02 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RI_AI = 1 / (5.0 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm) + 0.0001027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_AP = 1 / (0.25 * exp(-0.02 * var_chaste_interface__membrane__Vm) + 0.1027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_RI = 0.01 / (1.0 + 8.7499999999999999e-5 * var_sodium_current_voltage_dependent_gate__k_AP_RP * var_sodium_current_voltage_dependent_gate__k_RI_AI / (var_sodium_current_voltage_dependent_gate__k_AI_RI * var_sodium_current_voltage_dependent_gate__k_AP_AI * var_sodium_current_voltage_dependent_gate__k_RP_AP)); // per_millisecond
        const double var_sodium_current__i_Na_K = 286.0 * var_constant_field_equations__CF_K * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na_Na = 2860.0 * var_constant_field_equations__CF_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na = 8.7499999999999999e-5 * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na + var_sodium_current_voltage_dependent_gate__k_RP_AP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na - (var_sodium_current_voltage_dependent_gate__k_AP_AI + var_sodium_current_voltage_dependent_gate__k_AP_RP) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // 1 / millisecond
        const double var_sodium_current_voltage_dependent_gate__p_RI_Na = 1.0 - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // dimensionless
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na = var_sodium_current_voltage_dependent_gate__k_AP_AI * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + var_sodium_current_voltage_dependent_gate__k_RI_AI * var_sodium_current_voltage_dependent_gate__p_RI_Na - (8.7499999999999999e-5 + var_sodium_current_voltage_dependent_gate__k_AI_RI) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na; // 1 / millisecond
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na = (0.01 - var_sodium_current_voltage_dependent_gate__k_RP_RI) * var_sodium_current_voltage_dependent_gate__p_RI_Na + var_sodium_current_voltage_dependent_gate__k_AP_RP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na - (var_sodium_current_voltage_dependent_gate__k_RP_AP + var_sodium_current_voltage_dependent_gate__k_RP_RI) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // 1 / millisecond
        const double var_sodium_potassium_pump__Nao_Eff = 140.0 * exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm); // millimolar
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + 0.094 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + 4.4045579125871104 * pow(1 / var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001) * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + 2804.9496956618664 * pow(1 / var_sodium_potassium_pump__Nao_Eff, 1.0600000000000001)); // dimensionless
        const double d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y = (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * (0.040000000000000001 * var_sodium_potassium_pump__p_E2Na + 0.16500000000000001 / (1.0331690520373935 + 0.00036833781854815162 * pow(var_sodium_potassium_pump__Nao_Eff, 1.0600000000000001))) - (0.01 / (1.0 + 49.999265664512095 * pow(1 / var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001) * (1.0 + 0.22703754152993499 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001))) + var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na) * var_chaste_interface__sodium_potassium_pump_y_gate__y; // 1 / millisecond
        const double var_sodium_potassium_pump__i_NaK = 21.0 * (-0.040000000000000001 * (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__p_E2Na + var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y) * mParameters[0]; // picoA
        const double d_dt_chaste_interface_var_ATP_production__ATPi = 0.014999999999999999 + 3.2387883511406238e-7 * var_SR_calcium_pump__i_SR_U - 0.0030000000000000001 * var_chaste_interface__ATP_production__ATPi - 0.028000000000000004 * var_chaste_interface__NL_model__pCaCB - 1.2955153404562495e-6 * var_sodium_potassium_pump__i_NaK; // millimolar / millisecond
        const double var_time_independent_potassium_current__E_K = 26.712831923985377 * log(5.4000000000000004 / var_chaste_interface__internal_ion_concentrations__Ki); // millivolt
        const double var_background_KATP_current__i_KATP = 66.022388395163091 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)); // picoA
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.0086400000000000001 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * mParameters[0] * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // picoA
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y = (1.0 - var_chaste_interface__time_independent_potassium_current_y_gate__y) / (7.0 * exp(-0.32333333333333331 + 0.0033333333333333335 * var_chaste_interface__membrane__Vm - 0.0033333333333333335 * var_time_independent_potassium_current__E_K) + 8000.0 * exp(-11.411764705882353 + 0.11764705882352941 * var_chaste_interface__membrane__Vm - 0.11764705882352941 * var_time_independent_potassium_current__E_K)) - 1.0 * pow(var_time_independent_potassium_current__fO, 4) * var_chaste_interface__time_independent_potassium_current_y_gate__y / (0.00013999999999999999 * exp(10.659340659340661 + 0.10989010989010989 * var_time_independent_potassium_current__E_K - 0.10989010989010989 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(0.19400000000000001 + 0.002 * var_time_independent_potassium_current__E_K - 0.002 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double var_time_independent_potassium_current__i_K1 = 1.1459999999999999 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (pow(var_time_independent_potassium_current__fO, 4) + 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2) + 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB) * mParameters[0] * var_chaste_interface__time_independent_potassium_current_y_gate__y; // picoA
        const double d_dt_chaste_interface_var_transient_outward_current_y1_gate__y1 = (1.0 - var_chaste_interface__transient_outward_current_y1_gate__y1) / (11.0 * exp(-0.035714285714285712 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__transient_outward_current_y1_gate__y1 / (4.4000000000000004 * exp(0.0625 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(0.002 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_y2_gate__y2 = 0.0038 * (1.0 - var_chaste_interface__transient_outward_current_y2_gate__y2) * exp(-1.1946902654867255 - 0.088495575221238937 * var_chaste_interface__membrane__Vm) / (1.0 + 0.051334999999999999 * exp(-1.1946902654867255 - 0.088495575221238937 * var_chaste_interface__membrane__Vm)) - 0.0038 * var_chaste_interface__transient_outward_current_y2_gate__y2 * exp(1.1946902654867255 + 0.088495575221238937 * var_chaste_interface__membrane__Vm) / (1.0 + 0.067083000000000004 * exp(1.1946902654867255 + 0.088495575221238937 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double var_transient_outward_current__i_to_K = 0.033000000000000002 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Ki = 2.591030680912499e-6 * var_sodium_potassium_pump__i_NaK - 1.2955153404562495e-6 * var_L_type_Ca_channel__i_CaL_K - 1.2955153404562495e-6 * var_background_KATP_current__i_KATP - 1.2955153404562495e-6 * var_background_Kpl_current__i_Kpl - 1.2955153404562495e-6 * var_background_NSC_current__i_bNSC_K - 1.2955153404562495e-6 * var_background_lCa_current__i_lCa_K - 1.2955153404562495e-6 * var_membrane__i_ext - 1.2955153404562495e-6 * var_rapid_time_dependent_potassium_current__i_Kr - 1.2955153404562495e-6 * var_slow_time_dependent_potassium_current__i_Ks_K - 1.2955153404562495e-6 * var_sodium_current__i_Na_K - 1.2955153404562495e-6 * var_time_independent_potassium_current__i_K1 - 1.2955153404562495e-6 * var_transient_outward_current__i_to_K; // millimolar / millisecond
        const double var_transient_outward_current__i_to_Na = 0.00297 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Nai = -3.8865460213687481e-6 * var_sodium_calcium_exchanger__i_NaCa - 3.8865460213687481e-6 * var_sodium_potassium_pump__i_NaK - 1.2955153404562495e-6 * var_L_type_Ca_channel__i_CaL_Na - 1.2955153404562495e-6 * var_background_NSC_current__i_bNSC_Na - 1.2955153404562495e-6 * var_background_lCa_current__i_lCa_Na - 1.2955153404562495e-6 * var_slow_time_dependent_potassium_current__i_Ks_Na - 1.2955153404562495e-6 * var_sodium_current__i_Na_Na - 1.2955153404562495e-6 * var_transient_outward_current__i_to_Na; // millimolar / millisecond
        
        mEvalF[1] = d_dt_chaste_interface_var_internal_ion_concentrations__Nai;
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        mEvalF[2] = d_dt_chaste_interface_var_internal_ion_concentrations__Ki;
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        mEvalF[3] = d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total;
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        mEvalF[4] = d_dt_chaste_interface_var_ATP_production__ATPi;
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        mEvalF[5] = d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na;
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        mEvalF[6] = d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na;
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        mEvalF[7] = d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na;
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        mEvalF[8] = d_dt_chaste_interface_var_sodium_current_ultra_slow_gate__y;
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        mEvalF[9] = d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        mEvalF[10] = d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL;
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        mEvalF[11] = d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL;
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        mEvalF[12] = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U;
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        mEvalF[13] = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa;
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        mEvalF[14] = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C;
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        mEvalF[15] = d_dt_chaste_interface_var_L_type_Ca_channel_ultra_slow_gate__y;
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        mEvalF[16] = d_dt_chaste_interface_var_T_type_Ca_channel_y1_gate__y1;
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        mEvalF[17] = d_dt_chaste_interface_var_T_type_Ca_channel_y2_gate__y2;
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time, rY, delta);
        mEvalF[18] = d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y;
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time, rY, delta);
        mEvalF[19] = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y1_gate__y1;
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time, rY, delta);
        mEvalF[20] = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y2_gate__y2;
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time, rY, delta);
        mEvalF[21] = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y3_gate__y3;
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time, rY, delta);
        mEvalF[22] = d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y1_gate__y1;
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time, rY, delta);
        mEvalF[23] = d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2;
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time, rY, delta);
        mEvalF[24] = d_dt_chaste_interface_var_transient_outward_current_y1_gate__y1;
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time, rY, delta);
        mEvalF[25] = d_dt_chaste_interface_var_transient_outward_current_y2_gate__y2;
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time, rY, delta);
        mEvalF[26] = d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y;
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time, rY, delta);
        mEvalF[27] = d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y;
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__environment__time, rY, delta);
        mEvalF[28] = d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y;
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__environment__time, rY, delta);
        mEvalF[29] = d_dt_chaste_interface_var_RyR_channel__p_open_RyR;
        mPartialF[29] = EvaluatePartialDerivative29(var_chaste_interface__environment__time, rY, delta);
        mEvalF[30] = d_dt_chaste_interface_var_RyR_channel__p_close_RyR;
        mPartialF[30] = EvaluatePartialDerivative30(var_chaste_interface__environment__time, rY, delta);
        mEvalF[31] = d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total;
        mPartialF[31] = EvaluatePartialDerivative31(var_chaste_interface__environment__time, rY, delta);
        mEvalF[32] = d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup;
        mPartialF[32] = EvaluatePartialDerivative32(var_chaste_interface__environment__time, rY, delta);
        mEvalF[33] = d_dt_chaste_interface_var_NL_model__pCa;
        mPartialF[33] = EvaluatePartialDerivative33(var_chaste_interface__environment__time, rY, delta);
        mEvalF[34] = d_dt_chaste_interface_var_NL_model__pCaCB;
        mPartialF[34] = EvaluatePartialDerivative34(var_chaste_interface__environment__time, rY, delta);
        mEvalF[35] = d_dt_chaste_interface_var_NL_model__pCB;
        mPartialF[35] = EvaluatePartialDerivative35(var_chaste_interface__environment__time, rY, delta);
        mEvalF[36] = d_dt_chaste_interface_var_NL_model__X;
        mPartialF[36] = EvaluatePartialDerivative36(var_chaste_interface__environment__time, rY, delta);
        
        {
            if (fabs(mPartialF[1]) < delta){
                rY[1] += mDt*d_dt_chaste_interface_var_internal_ion_concentrations__Nai;
            }
            else
            {
                rY[1] += (d_dt_chaste_interface_var_internal_ion_concentrations__Nai/mPartialF[1])*(exp(mPartialF[1]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[2]) < delta){
                rY[2] += mDt*d_dt_chaste_interface_var_internal_ion_concentrations__Ki;
            }
            else
            {
                rY[2] += (d_dt_chaste_interface_var_internal_ion_concentrations__Ki/mPartialF[2])*(exp(mPartialF[2]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[3]) < delta){
                rY[3] += mDt*d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total;
            }
            else
            {
                rY[3] += (d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total/mPartialF[3])*(exp(mPartialF[3]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[4]) < delta){
                rY[4] += mDt*d_dt_chaste_interface_var_ATP_production__ATPi;
            }
            else
            {
                rY[4] += (d_dt_chaste_interface_var_ATP_production__ATPi/mPartialF[4])*(exp(mPartialF[4]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[5]) < delta){
                rY[5] += mDt*d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na;
            }
            else
            {
                rY[5] += (d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na/mPartialF[5])*(exp(mPartialF[5]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[6]) < delta){
                rY[6] += mDt*d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na;
            }
            else
            {
                rY[6] += (d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na/mPartialF[6])*(exp(mPartialF[6]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[7]) < delta){
                rY[7] += mDt*d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na;
            }
            else
            {
                rY[7] += (d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na/mPartialF[7])*(exp(mPartialF[7]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[8]) < delta){
                rY[8] += mDt*d_dt_chaste_interface_var_sodium_current_ultra_slow_gate__y;
            }
            else
            {
                rY[8] += (d_dt_chaste_interface_var_sodium_current_ultra_slow_gate__y/mPartialF[8])*(exp(mPartialF[8]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[9]) < delta){
                rY[9] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
            }
            else
            {
                rY[9] += (d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL/mPartialF[9])*(exp(mPartialF[9]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[10]) < delta){
                rY[10] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL;
            }
            else
            {
                rY[10] += (d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL/mPartialF[10])*(exp(mPartialF[10]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[11]) < delta){
                rY[11] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL;
            }
            else
            {
                rY[11] += (d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL/mPartialF[11])*(exp(mPartialF[11]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[12]) < delta){
                rY[12] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U;
            }
            else
            {
                rY[12] += (d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U/mPartialF[12])*(exp(mPartialF[12]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[13]) < delta){
                rY[13] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa;
            }
            else
            {
                rY[13] += (d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa/mPartialF[13])*(exp(mPartialF[13]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[14]) < delta){
                rY[14] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C;
            }
            else
            {
                rY[14] += (d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C/mPartialF[14])*(exp(mPartialF[14]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[15]) < delta){
                rY[15] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_ultra_slow_gate__y;
            }
            else
            {
                rY[15] += (d_dt_chaste_interface_var_L_type_Ca_channel_ultra_slow_gate__y/mPartialF[15])*(exp(mPartialF[15]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[16]) < delta){
                rY[16] += mDt*d_dt_chaste_interface_var_T_type_Ca_channel_y1_gate__y1;
            }
            else
            {
                rY[16] += (d_dt_chaste_interface_var_T_type_Ca_channel_y1_gate__y1/mPartialF[16])*(exp(mPartialF[16]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[17]) < delta){
                rY[17] += mDt*d_dt_chaste_interface_var_T_type_Ca_channel_y2_gate__y2;
            }
            else
            {
                rY[17] += (d_dt_chaste_interface_var_T_type_Ca_channel_y2_gate__y2/mPartialF[17])*(exp(mPartialF[17]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[18]) < delta){
                rY[18] += mDt*d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y;
            }
            else
            {
                rY[18] += (d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y/mPartialF[18])*(exp(mPartialF[18]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[19]) < delta){
                rY[19] += mDt*d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y1_gate__y1;
            }
            else
            {
                rY[19] += (d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y1_gate__y1/mPartialF[19])*(exp(mPartialF[19]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[20]) < delta){
                rY[20] += mDt*d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y2_gate__y2;
            }
            else
            {
                rY[20] += (d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y2_gate__y2/mPartialF[20])*(exp(mPartialF[20]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[21]) < delta){
                rY[21] += mDt*d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y3_gate__y3;
            }
            else
            {
                rY[21] += (d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y3_gate__y3/mPartialF[21])*(exp(mPartialF[21]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[22]) < delta){
                rY[22] += mDt*d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y1_gate__y1;
            }
            else
            {
                rY[22] += (d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y1_gate__y1/mPartialF[22])*(exp(mPartialF[22]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[23]) < delta){
                rY[23] += mDt*d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2;
            }
            else
            {
                rY[23] += (d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2/mPartialF[23])*(exp(mPartialF[23]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[24]) < delta){
                rY[24] += mDt*d_dt_chaste_interface_var_transient_outward_current_y1_gate__y1;
            }
            else
            {
                rY[24] += (d_dt_chaste_interface_var_transient_outward_current_y1_gate__y1/mPartialF[24])*(exp(mPartialF[24]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[25]) < delta){
                rY[25] += mDt*d_dt_chaste_interface_var_transient_outward_current_y2_gate__y2;
            }
            else
            {
                rY[25] += (d_dt_chaste_interface_var_transient_outward_current_y2_gate__y2/mPartialF[25])*(exp(mPartialF[25]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[26]) < delta){
                rY[26] += mDt*d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y;
            }
            else
            {
                rY[26] += (d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y/mPartialF[26])*(exp(mPartialF[26]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[27]) < delta){
                rY[27] += mDt*d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y;
            }
            else
            {
                rY[27] += (d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y/mPartialF[27])*(exp(mPartialF[27]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[28]) < delta){
                rY[28] += mDt*d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y;
            }
            else
            {
                rY[28] += (d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y/mPartialF[28])*(exp(mPartialF[28]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[29]) < delta){
                rY[29] += mDt*d_dt_chaste_interface_var_RyR_channel__p_open_RyR;
            }
            else
            {
                rY[29] += (d_dt_chaste_interface_var_RyR_channel__p_open_RyR/mPartialF[29])*(exp(mPartialF[29]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[30]) < delta){
                rY[30] += mDt*d_dt_chaste_interface_var_RyR_channel__p_close_RyR;
            }
            else
            {
                rY[30] += (d_dt_chaste_interface_var_RyR_channel__p_close_RyR/mPartialF[30])*(exp(mPartialF[30]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[31]) < delta){
                rY[31] += mDt*d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total;
            }
            else
            {
                rY[31] += (d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total/mPartialF[31])*(exp(mPartialF[31]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[32]) < delta){
                rY[32] += mDt*d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup;
            }
            else
            {
                rY[32] += (d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup/mPartialF[32])*(exp(mPartialF[32]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[33]) < delta){
                rY[33] += mDt*d_dt_chaste_interface_var_NL_model__pCa;
            }
            else
            {
                rY[33] += (d_dt_chaste_interface_var_NL_model__pCa/mPartialF[33])*(exp(mPartialF[33]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[34]) < delta){
                rY[34] += mDt*d_dt_chaste_interface_var_NL_model__pCaCB;
            }
            else
            {
                rY[34] += (d_dt_chaste_interface_var_NL_model__pCaCB/mPartialF[34])*(exp(mPartialF[34]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[35]) < delta){
                rY[35] += mDt*d_dt_chaste_interface_var_NL_model__pCB;
            }
            else
            {
                rY[35] += (d_dt_chaste_interface_var_NL_model__pCB/mPartialF[35])*(exp(mPartialF[35]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[36]) < delta){
                rY[36] += mDt*d_dt_chaste_interface_var_NL_model__X;
            }
            else
            {
                rY[36] += (d_dt_chaste_interface_var_NL_model__X/mPartialF[36])*(exp(mPartialF[36]*mDt)-1.0);
            }
            
        }        
        
    }
   
    
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__Vm;
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        
        
        // Mathematics
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-1.8) : (0.074870384603595908 * (-1.8 * exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm) + var_internal_ion_concentrations__Cai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Ca = 8712.0 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca; // picoA
        const double var_T_type_Ca_channel__i_Ca_T = 612.0 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca; // picoA
        const double var_background_Cab_current__i_Cab = 0.040000000000000001 * var_constant_field_equations__CF_Ca; // picoA
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : (0.037435192301797954 * (-5.4000000000000004 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Ki) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_K = 3.1798799999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K; // picoA
        const double var_background_Kpl_current__i_Kpl = ((var_chaste_interface__membrane__Vm == (-3.0)) ? (0.0014308470000000001 * var_constant_field_equations__CF_K) : (0.00011 * (3.0 + var_chaste_interface__membrane__Vm) * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_background_NSC_current__i_bNSC_K = 0.15400000000000003 * var_constant_field_equations__CF_K; // picoA
        const double var_background_lCa_current__i_lCa_K = 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_K; // picoA
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-140.0) : (0.037435192301797954 * (-140.0 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Nai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Na = 0.16117199999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na; // picoA
        const double var_background_NSC_current__i_bNSC_Na = 0.38500000000000001 * var_constant_field_equations__CF_Na; // picoA
        const double var_background_lCa_current__i_lCa_Na = 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na; // picoA
        const double var_membrane__i_ext = 1.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time) * mParameters[0] / HeartConfig::Instance()->GetCapacitance(); // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_K = 5.04 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_Na = 0.2016 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na; // picoA
        const double var_sodium_calcium_exchanger__k1 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + 669.921875 * (1.0 + 724.63768115942037 * var_internal_ion_concentrations__Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa = 6.8099999999999996 * (-0.6399652192815608 * (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 + var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * mParameters[0]; // picoA
        const double var_sodium_current__i_Na_K = 286.0 * var_constant_field_equations__CF_K * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na_Na = 2860.0 * var_constant_field_equations__CF_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_potassium_pump__Nao_Eff = 140.0 * exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm); // millimolar
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + 0.094 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + 4.4045579125871104 * pow(1 / var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001) * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + 2804.9496956618664 * pow(1 / var_sodium_potassium_pump__Nao_Eff, 1.0600000000000001)); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = 21.0 * (-0.040000000000000001 * (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__p_E2Na + var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y) * mParameters[0]; // picoA
        const double var_time_independent_potassium_current__E_K = 26.712831923985377 * log(5.4000000000000004 / var_chaste_interface__internal_ion_concentrations__Ki); // millivolt
        const double var_background_KATP_current__i_KATP = 66.022388395163091 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)); // picoA
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.0086400000000000001 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * mParameters[0] * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // picoA
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = 1.1459999999999999 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (pow(var_time_independent_potassium_current__fO, 4) + 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2) + 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB) * mParameters[0] * var_chaste_interface__time_independent_potassium_current_y_gate__y; // picoA
        const double var_transient_outward_current__i_to_K = 0.033000000000000002 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_transient_outward_current__i_to_Na = 0.00297 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        d_dt_chaste_interface_var_membrane__Vm = (-var_L_type_Ca_channel__i_CaL_Ca - var_L_type_Ca_channel__i_CaL_K - var_L_type_Ca_channel__i_CaL_Na - var_T_type_Ca_channel__i_Ca_T - var_background_Cab_current__i_Cab - var_background_KATP_current__i_KATP - var_background_Kpl_current__i_Kpl - var_background_NSC_current__i_bNSC_K - var_background_NSC_current__i_bNSC_Na - var_background_lCa_current__i_lCa_K - var_background_lCa_current__i_lCa_Na - var_membrane__i_ext - var_rapid_time_dependent_potassium_current__i_Kr - var_slow_time_dependent_potassium_current__i_Ks_K - var_slow_time_dependent_potassium_current__i_Ks_Na - var_sodium_calcium_exchanger__i_NaCa - var_sodium_current__i_Na_K - var_sodium_current__i_Na_Na - var_sodium_potassium_pump__i_NaK - var_time_independent_potassium_current__i_K1 - var_transient_outward_current__i_to_K - var_transient_outward_current__i_to_Na) / mParameters[0]; // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane__Vm;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
            // Units: millimolar; Initial value: 4.925761439682025
            double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
            // Units: millimolar; Initial value: 143.1837333000449
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            double var_chaste_interface__ATP_production__ATPi = rY[4];
            // Units: millimolar; Initial value: 4.657102729020499
            double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
            // Units: dimensionless; Initial value: 1.779648367445368e-05
            double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
            // Units: dimensionless; Initial value: 0.5861887862983165
            double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
            // Units: dimensionless; Initial value: 1.5445004166497696e-06
            double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
            // Units: dimensionless; Initial value: 0.17246483915629204
            double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
            // Units: dimensionless; Initial value: 6.098246017787626e-05
            double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
            // Units: dimensionless; Initial value: 0.9985266538252986
            double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
            // Units: dimensionless; Initial value: 1.6882718240109127e-05
            double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
            // Units: dimensionless; Initial value: 0.8585352091865849
            double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
            // Units: dimensionless; Initial value: 0.6080573900752752
            double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
            // Units: dimensionless; Initial value: 0.0018339931180983765
            double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
            // Units: dimensionless; Initial value: 0.20443083454225305
            double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
            // Units: dimensionless; Initial value: 0.967887666264921
            double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
            // Units: dimensionless; Initial value: 0.09738789658609195
            double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
            // Units: dimensionless; Initial value: 0.09745345578743213
            double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
            // Units: dimensionless; Initial value: 0.0007956883250874798
            double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
            // Units: dimensionless; Initial value: 0.9999125083105881
            double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
            // Units: dimensionless; Initial value: 0.9891789193465331
            double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
            // Units: dimensionless; Initial value: 0.5910747147428818
            
            const double var_x0 = 1 / mParameters[0];
            const double var_x1 = 0.037435192301797954 * var_chaste_interface__membrane__Vm;
            const double var_x2 = exp(-var_x1);
            const double var_x3 = 1.0 - var_x2;
            const double var_x4 = 1 / var_x3;
            const double var_x5 = -5.4000000000000004 * var_x2 + var_chaste_interface__internal_ion_concentrations__Ki;
            const double var_x6 = var_x4 * var_x5;
            const double var_x7 = var_x4 * var_chaste_interface__membrane__Vm;
            const double var_x8 = var_x2 * var_x7;
            const double var_x9 = var_x2 * var_chaste_interface__membrane__Vm / pow(var_x3, 2);
            const double var_x10 = var_x5 * var_x9;
            const double var_x11 = var_chaste_interface__membrane__Vm == (-3.0);
            const double var_x12 = -0.076923076923076927 * var_chaste_interface__membrane__Vm;
            const double var_x13 = exp(-0.23076923076923078 + var_x12);
            const double var_x14 = 1.0 - var_x13;
            const double var_x15 = 1 / var_x14;
            const double var_x16 = 0.00011 * var_x15;
            const double var_x17 = 3.0 + var_chaste_interface__membrane__Vm;
            const double var_x18 = var_x13 * var_x17 / pow(var_x14, 2);
            const double var_x19 = var_chaste_interface__membrane__Vm == 0;
            const double var_x20 = var_x15 * var_x17;
            const double var_x21 = 4.1178711531977753e-6 * var_x6;
            const double var_x22 = ((var_x11) ? (5.3564032599450697e-5 * var_x6 + 1.0827971248429142e-5 * var_x8 - 2.0051798608202113e-6 * var_x10) : ((var_x19) ? (var_x16 * var_chaste_interface__internal_ion_concentrations__Ki - 8.4615384615384621e-6 * var_x18 * var_chaste_interface__internal_ion_concentrations__Ki) : (var_x20 * var_x21 + 8.3242781186752018e-7 * var_x20 * var_x8 - 1.5415329849398521e-7 * var_x10 * var_x20 + var_x15 * var_x21 * var_chaste_interface__membrane__Vm - 3.1675931947675192e-7 * var_x18 * var_x6 * var_chaste_interface__membrane__Vm)));
            const double var_x23 = -140.0 * var_x2 + var_chaste_interface__internal_ion_concentrations__Nai;
            const double var_x24 = var_x23 * var_x4;
            const double var_x25 = ((var_x19) ? (0) : (0.037435192301797954 * var_x24 + 0.196195107174163 * var_x8 - 0.0014013936226725929 * var_x23 * var_x9));
            const double var_x26 = 0.074870384603595908 * var_chaste_interface__membrane__Vm;
            const double var_x27 = exp(-var_x26);
            const double var_x28 = 1.0 - var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            const double var_x31 = -0.026190000000000001 + 0.5 * var_x30 + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x32 = var_x31 - 1.8 * var_x27;
            const double var_x33 = var_x29 * var_x32;
            const double var_x34 = var_x27 * var_chaste_interface__membrane__Vm;
            const double var_x35 = ((var_x19) ? (0) : (0.074870384603595908 * var_x33 + 0.010090034083242669 * var_x29 * var_x34 - 0.0056055744906903715 * var_x32 * var_x34 / pow(var_x28, 2)));
            const double var_x36 = pow(var_chaste_interface__ATP_production__ATPi, 2);
            const double var_x37 = 1 / (1.0 + 99.999999999999986 * var_x36);
            const double var_x38 = ((var_x19) ? (0) : (0.037435192301797954 * var_x6 + 0.0075675255624320014 * var_x8 - 0.0014013936226725929 * var_x10));
            const double var_x39 = exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm);
            const double var_x40 = var_x39 * (-0.6399652192815608 + 0.6399652192815608 * var_chaste_interface__sodium_calcium_exchanger_y_gate__y);
            const double var_x41 = pow(var_chaste_interface__internal_ion_concentrations__Nai, 3);
            const double var_x42 = 1 / var_x41;
            const double var_x43 = -17.978260869565219 + 362.31884057971018 * var_x30 + 362.31884057971018 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x44 = var_x42 * var_x43;
            const double var_x45 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm);
            const double var_x46 = var_x45 / (1.0 + 669.921875 * var_x44);
            const double var_x47 = var_x46 * var_chaste_interface__sodium_calcium_exchanger_y_gate__y;
            const double var_x48 = -0.052380000000000003 + var_x30 + var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x49 = 1.0 + 1.3823999999999997e-8 / pow(var_x48, 3);
            const double var_x50 = 1 / var_x49;
            const double var_x51 = 0.11 * var_x50;
            const double var_x52 = -0.0034560000000000003 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 - 0.0051840000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1;
            const double var_x53 = mParameters[0] * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3;
            const double var_x54 = var_x52 * var_x53;
            const double var_x55 = 1 / var_chaste_interface__internal_ion_concentrations__Ki;
            const double var_x56 = log(5.4000000000000004 * var_x55);
            const double var_x57 = exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.40069247885978065 * var_x56);
            const double var_x58 = 1.0 + var_x57;
            const double var_x59 = exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.93494911733948827 * var_x56);
            const double var_x60 = var_x59 / var_x58;
            const double var_x61 = exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 1.7096212431350641 * var_x56);
            const double var_x62 = 1.0 + var_x61;
            const double var_x63 = exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.80138495771956131 * var_x56);
            const double var_x64 = 1.0 + var_x63;
            const double var_x65 = exp(0.47999999999999998 + 1.282215932351298 * var_x56 - 0.048000000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x66 = var_x65 / var_x64;
            const double var_x67 = var_x62 * var_x66;
            const double var_x68 = var_x67 + 0.25 * var_x60;
            const double var_x69 = pow(var_x68, (-4));
            const double var_x70 = pow(var_x62, 4);
            const double var_x71 = pow(var_x64, (-4));
            const double var_x72 = pow(var_x65, 4);
            const double var_x73 = var_x70 * var_x71 * var_x72;
            const double var_x74 = var_x69 * var_x73;
            const double var_x75 = pow(var_x58, (-2));
            const double var_x76 = pow(var_x65, 2);
            const double var_x77 = pow(var_x59, 2);
            const double var_x78 = var_x69 * var_x75 * var_x76 * var_x77;
            const double var_x79 = pow(var_x64, (-2));
            const double var_x80 = pow(var_x62, 2);
            const double var_x81 = var_x79 * var_x80;
            const double var_x82 = var_x78 * var_x81;
            const double var_x83 = 1 / (0.75 * var_x60 + 3.0 * var_x67);
            const double var_x84 = pow(var_x65, 3);
            const double var_x85 = var_x83 * var_x84 / pow(var_x68, 3);
            const double var_x86 = pow(var_x62, 3);
            const double var_x87 = pow(var_x64, (-3));
            const double var_x88 = var_x60 * var_x86 * var_x87;
            const double var_x89 = var_x85 * var_x88;
            const double var_x90 = mParameters[0] * var_chaste_interface__time_independent_potassium_current_y_gate__y;
            const double var_x91 = 612.0 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2;
            const double var_x92 = var_x91 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1;
            const double var_x93 = var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na;
            const double var_x94 = 2860.0 * var_x93;
            const double var_x95 = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2);
            const double var_x96 = 0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2;
            const double var_x97 = var_x95 * var_x96;
            const double var_x98 = 0.2016 * var_x97;
            const double var_x99 = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3);
            const double var_x100 = var_x99 * var_chaste_interface__transient_outward_current_y2_gate__y2;
            const double var_x101 = 0.033000000000000002 * var_x100;
            const double var_x102 = 5.04 * var_x97;
            const double var_x103 = 0.00297 * var_x100;
            const double var_x104 = 286.0 * var_x93;
            const double var_x105 = 0.192 * var_x74;
            const double var_x106 = pow(var_x68, (-5));
            const double var_x107 = var_x57 * var_x59 * var_x75;
            const double var_x108 = var_x61 * var_x66;
            const double var_x109 = 0.12 * var_x63;
            const double var_x110 = var_x62 * var_x79;
            const double var_x111 = var_x110 * var_x65;
            const double var_x112 = var_x106 * (0.014999999999999999 * var_x107 + 0.192 * var_x67 - 0.25600000000000001 * var_x108 - 0.035000000000000003 * var_x60 + var_x109 * var_x111);
            const double var_x113 = var_x73;
            const double var_x114 = var_x112 * var_x113;
            const double var_x115 = var_x69 * var_x72;
            const double var_x116 = var_x71 * var_x86;
            const double var_x117 = var_x115 * var_x116 * var_x61;
            const double var_x118 = 0.25600000000000001 * var_x117;
            const double var_x119 = var_x115 * var_x70 / pow(var_x64, 5);
            const double var_x120 = var_x109 * var_x119;
            const double var_x121 = var_x76 * var_x77 * var_x81;
            const double var_x122 = 0.125 * var_x121 * var_x75;
            const double var_x123 = var_x110 * var_x61 * var_x78;
            const double var_x124 = var_x111 * var_x63;
            const double var_x125 = var_x84 * var_x88;
            const double var_x126 = var_x125 * (0.01125 * var_x107 + 0.089999999999999997 * var_x124 + 0.14400000000000002 * var_x67 - 0.192 * var_x108 - 0.026250000000000002 * var_x60);
            const double var_x127 = 0.22222222222222221 * var_x106;
            const double var_x128 = var_x121 * var_x57 * var_x69 / pow(var_x58, 3);
            const double var_x129 = var_x80 * var_x87;
            const double var_x130 = var_x129 * var_x78;
            const double var_x131 = 2.0 * var_x69 * var_x83;
            const double var_x132 = var_x60 * var_x85;
            const double var_x133 = var_x129 * var_x61;
            const double var_x134 = var_x85 * var_x86 * var_x87;
            const double var_x135 = var_x116 * var_x63;
            const double var_x136 = var_x114 + var_x118 - var_x105 - var_x120 + 0.016 * var_x123 - 0.0032499999999999994 * var_x82 - 0.0037499999999999999 * var_x128 - 0.218 * var_x89 + var_x112 * var_x122 + var_x126 * var_x127 + var_x126 * var_x131 + 0.38400000000000001 * var_x132 * var_x133 - 0.0074999999999999997 * var_x130 * var_x63 - 0.029999999999999999 * var_x107 * var_x134 - 0.17999999999999999 * var_x132 * var_x135;
            const double var_x137 = 30.612905384887238 * var_x56 - 1.1459999999999999 * var_chaste_interface__membrane__Vm;
            const double var_x138 = var_x137 * var_x90;
            const double var_x139 = 1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y;
            const double var_x140 = exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm);
            const double var_x141 = pow(1 / var_x140, 1.0600000000000001);
            const double var_x142 = var_x141 / pow((0.067138346456864173 + var_x141), 2);
            const double var_x143 = var_x139 * var_x142 * mParameters[0];
            const double var_x144 = var_x35 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
            const double var_x145 = var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa;
            const double var_x146 = pow(var_chaste_interface__ATP_production__ATPi, (-3));
            const double var_x147 = 1 / (1.0 + 2.7439999999999993 * var_x146);
            const double var_x148 = var_x147 * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y;
            const double var_x149 = var_x145 * var_x148;
            const double var_x150 = 8712.0 * var_x149;
            const double var_x151 = var_x149 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
            const double var_x152 = 3.1798799999999998 * var_x151;
            const double var_x153 = 0.16117199999999998 * var_x151;
            
            partialF = var_x0 * (var_x54 - var_x22 - 0.38500000000000001 * var_x25 - 0.040000000000000001 * var_x35 - 66.022388395163091 * var_x37 - 0.15400000000000003 * var_x38 - 0.0018350576517438713 * var_x143 + var_x136 * var_x138 + var_x90 * (-0.14324999999999999 * var_x82 - 1.1459999999999999 * var_x74 - 2.2919999999999998 * var_x89) + (0.17335488851116596 * var_x40 - 0.081578771064078098 * var_x47) * mParameters[0] - var_x101 * var_x38 - var_x102 * var_x38 - var_x103 * var_x25 - var_x104 * var_x38 - var_x144 * var_x150 - var_x152 * var_x38 - var_x153 * var_x25 - var_x25 * var_x51 - var_x25 * var_x94 - var_x25 * var_x98 - var_x35 * var_x92 - var_x38 * var_x51);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        
        
        // Mathematics
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-140.0) : (0.037435192301797954 * (-140.0 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Nai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Na = 0.16117199999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na; // picoA
        const double var_background_NSC_current__i_bNSC_Na = 0.38500000000000001 * var_constant_field_equations__CF_Na; // picoA
        const double var_background_lCa_current__i_lCa_Na = 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_Na = 0.2016 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na; // picoA
        const double var_sodium_calcium_exchanger__k1 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + 669.921875 * (1.0 + 724.63768115942037 * var_internal_ion_concentrations__Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa = 6.8099999999999996 * (-0.6399652192815608 * (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 + var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * mParameters[0]; // picoA
        const double var_sodium_current__i_Na_Na = 2860.0 * var_constant_field_equations__CF_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_potassium_pump__Nao_Eff = 140.0 * exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm); // millimolar
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + 0.094 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + 4.4045579125871104 * pow(1 / var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001) * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + 2804.9496956618664 * pow(1 / var_sodium_potassium_pump__Nao_Eff, 1.0600000000000001)); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = 21.0 * (-0.040000000000000001 * (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__p_E2Na + var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y) * mParameters[0]; // picoA
        const double var_transient_outward_current__i_to_Na = 0.00297 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Nai = -3.8865460213687481e-6 * var_sodium_calcium_exchanger__i_NaCa - 3.8865460213687481e-6 * var_sodium_potassium_pump__i_NaK - 1.2955153404562495e-6 * var_L_type_Ca_channel__i_CaL_Na - 1.2955153404562495e-6 * var_background_NSC_current__i_bNSC_Na - 1.2955153404562495e-6 * var_background_lCa_current__i_lCa_Na - 1.2955153404562495e-6 * var_slow_time_dependent_potassium_current__i_Ks_Na - 1.2955153404562495e-6 * var_sodium_current__i_Na_Na - 1.2955153404562495e-6 * var_transient_outward_current__i_to_Na; // millimolar / millisecond

        return d_dt_chaste_interface_var_internal_ion_concentrations__Nai;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
            // Units: millimolar; Initial value: 4.925761439682025
            double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
            // Units: millimolar; Initial value: 143.1837333000449
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            double var_chaste_interface__ATP_production__ATPi = rY[4];
            // Units: millimolar; Initial value: 4.657102729020499
            double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
            // Units: dimensionless; Initial value: 1.779648367445368e-05
            double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
            // Units: dimensionless; Initial value: 0.5861887862983165
            double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
            // Units: dimensionless; Initial value: 1.5445004166497696e-06
            double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
            // Units: dimensionless; Initial value: 0.17246483915629204
            double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
            // Units: dimensionless; Initial value: 6.098246017787626e-05
            double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
            // Units: dimensionless; Initial value: 0.9985266538252986
            double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
            // Units: dimensionless; Initial value: 0.09738789658609195
            double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
            // Units: dimensionless; Initial value: 0.09745345578743213
            double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
            // Units: dimensionless; Initial value: 0.0007956883250874798
            double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
            // Units: dimensionless; Initial value: 0.9999125083105881
            double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
            // Units: dimensionless; Initial value: 0.9891789193465331
            double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
            // Units: dimensionless; Initial value: 0.5910747147428818
            
            const double var_x1 = 0.037435192301797954 * var_chaste_interface__membrane__Vm;
            const double var_x2 = exp(-var_x1);
            const double var_x3 = 1.0 - var_x2;
            const double var_x4 = 1 / var_x3;
            const double var_x19 = var_chaste_interface__membrane__Vm == 0;
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            const double var_x41 = pow(var_chaste_interface__internal_ion_concentrations__Nai, 3);
            const double var_x42 = 1 / var_x41;
            const double var_x43 = -17.978260869565219 + 362.31884057971018 * var_x30 + 362.31884057971018 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x44 = var_x42 * var_x43;
            const double var_x45 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm);
            const double var_x48 = -0.052380000000000003 + var_x30 + var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x49 = 1.0 + 1.3823999999999997e-8 / pow(var_x48, 3);
            const double var_x50 = 1 / var_x49;
            const double var_x93 = var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na;
            const double var_x95 = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2);
            const double var_x96 = 0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2;
            const double var_x97 = var_x95 * var_x96;
            const double var_x99 = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3);
            const double var_x100 = var_x99 * var_chaste_interface__transient_outward_current_y2_gate__y2;
            const double var_x145 = var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa;
            const double var_x146 = pow(var_chaste_interface__ATP_production__ATPi, (-3));
            const double var_x147 = 1 / (1.0 + 2.7439999999999993 * var_x146);
            const double var_x148 = var_x147 * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y;
            const double var_x149 = var_x145 * var_x148;
            const double var_x151 = var_x149 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
            const double var_x154 = var_x1 * var_x4;
            const double var_x155 = ((var_x19) ? (0) : (var_x154));
            const double var_x156 = var_x45 / pow((0.0014927113702623907 + var_x44), 2);
            const double var_x157 = var_x156 * var_x43 / pow(var_chaste_interface__internal_ion_concentrations__Nai, 4);
            const double var_x158 = mParameters[0] * var_chaste_interface__sodium_calcium_exchanger_y_gate__y;
            const double var_x159 = var_x157 * var_x158;
            const double var_x160 = 1 / var_chaste_interface__internal_ion_concentrations__Nai;
            const double var_x161 = pow(var_x160, 1.0600000000000001);
            const double var_x162 = var_x161 * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001));
            const double var_x163 = 1 / var_chaste_interface__ATP_production__ATPi;
            const double var_x164 = 1.0 + 0.094 * var_x163;
            const double var_x165 = 1 / var_x164;
            const double var_x166 = var_x165 / pow((0.22703754152993499 + var_x162), 2);
            const double var_x167 = var_x160 * var_x162 * var_x166;
            const double var_x168 = mParameters[0] * var_chaste_interface__sodium_potassium_pump_y_gate__y;
            const double var_x169 = var_x167 * var_x168;
            const double var_x236 = 1.4250668745018745e-7 * var_x50;
            const double var_x237 = 3.8476805611550606e-9 * var_x100;
            const double var_x238 = 2.6117589263597991e-7 * var_x97;
            const double var_x239 = 0.0037051738737048732 * var_x93;
            const double var_x240 = 2.0880079845201463e-7 * var_x151;
            
            partialF = -7.2675557857281787e-6 * var_x169 - 1.1852447006087616e-7 * var_x159 - 4.9877340607565601e-7 * var_x155 - var_x155 * var_x236 - var_x155 * var_x237 - var_x155 * var_x238 - var_x155 * var_x239 - var_x155 * var_x240;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        
        
        // Mathematics
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : (0.037435192301797954 * (-5.4000000000000004 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Ki) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_K = 3.1798799999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K; // picoA
        const double var_background_Kpl_current__i_Kpl = ((var_chaste_interface__membrane__Vm == (-3.0)) ? (0.0014308470000000001 * var_constant_field_equations__CF_K) : (0.00011 * (3.0 + var_chaste_interface__membrane__Vm) * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_background_NSC_current__i_bNSC_K = 0.15400000000000003 * var_constant_field_equations__CF_K; // picoA
        const double var_background_lCa_current__i_lCa_K = 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_K; // picoA
        const double var_membrane__i_ext = 1.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time) * mParameters[0] / HeartConfig::Instance()->GetCapacitance(); // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_K = 5.04 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K; // picoA
        const double var_sodium_current__i_Na_K = 286.0 * var_constant_field_equations__CF_K * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_potassium_pump__Nao_Eff = 140.0 * exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm); // millimolar
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + 0.094 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + 4.4045579125871104 * pow(1 / var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001) * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + 2804.9496956618664 * pow(1 / var_sodium_potassium_pump__Nao_Eff, 1.0600000000000001)); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = 21.0 * (-0.040000000000000001 * (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__p_E2Na + var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y) * mParameters[0]; // picoA
        const double var_time_independent_potassium_current__E_K = 26.712831923985377 * log(5.4000000000000004 / var_chaste_interface__internal_ion_concentrations__Ki); // millivolt
        const double var_background_KATP_current__i_KATP = 66.022388395163091 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)); // picoA
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.0086400000000000001 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * mParameters[0] * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // picoA
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = 1.1459999999999999 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (pow(var_time_independent_potassium_current__fO, 4) + 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2) + 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB) * mParameters[0] * var_chaste_interface__time_independent_potassium_current_y_gate__y; // picoA
        const double var_transient_outward_current__i_to_K = 0.033000000000000002 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Ki = 2.591030680912499e-6 * var_sodium_potassium_pump__i_NaK - 1.2955153404562495e-6 * var_L_type_Ca_channel__i_CaL_K - 1.2955153404562495e-6 * var_background_KATP_current__i_KATP - 1.2955153404562495e-6 * var_background_Kpl_current__i_Kpl - 1.2955153404562495e-6 * var_background_NSC_current__i_bNSC_K - 1.2955153404562495e-6 * var_background_lCa_current__i_lCa_K - 1.2955153404562495e-6 * var_membrane__i_ext - 1.2955153404562495e-6 * var_rapid_time_dependent_potassium_current__i_Kr - 1.2955153404562495e-6 * var_slow_time_dependent_potassium_current__i_Ks_K - 1.2955153404562495e-6 * var_sodium_current__i_Na_K - 1.2955153404562495e-6 * var_time_independent_potassium_current__i_K1 - 1.2955153404562495e-6 * var_transient_outward_current__i_to_K; // millimolar / millisecond

        return d_dt_chaste_interface_var_internal_ion_concentrations__Ki;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
            // Units: millimolar; Initial value: 4.925761439682025
            double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
            // Units: millimolar; Initial value: 143.1837333000449
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            double var_chaste_interface__ATP_production__ATPi = rY[4];
            // Units: millimolar; Initial value: 4.657102729020499
            double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
            // Units: dimensionless; Initial value: 1.779648367445368e-05
            double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
            // Units: dimensionless; Initial value: 0.5861887862983165
            double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
            // Units: dimensionless; Initial value: 1.5445004166497696e-06
            double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
            // Units: dimensionless; Initial value: 0.17246483915629204
            double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
            // Units: dimensionless; Initial value: 6.098246017787626e-05
            double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
            // Units: dimensionless; Initial value: 0.9985266538252986
            double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
            // Units: dimensionless; Initial value: 0.6080573900752752
            double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
            // Units: dimensionless; Initial value: 0.0018339931180983765
            double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
            // Units: dimensionless; Initial value: 0.20443083454225305
            double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
            // Units: dimensionless; Initial value: 0.967887666264921
            double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
            // Units: dimensionless; Initial value: 0.09738789658609195
            double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
            // Units: dimensionless; Initial value: 0.09745345578743213
            double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
            // Units: dimensionless; Initial value: 0.0007956883250874798
            double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
            // Units: dimensionless; Initial value: 0.9999125083105881
            double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
            // Units: dimensionless; Initial value: 0.5910747147428818
            
            const double var_x1 = 0.037435192301797954 * var_chaste_interface__membrane__Vm;
            const double var_x2 = exp(-var_x1);
            const double var_x3 = 1.0 - var_x2;
            const double var_x4 = 1 / var_x3;
            const double var_x7 = var_x4 * var_chaste_interface__membrane__Vm;
            const double var_x11 = var_chaste_interface__membrane__Vm == (-3.0);
            const double var_x12 = -0.076923076923076927 * var_chaste_interface__membrane__Vm;
            const double var_x13 = exp(-0.23076923076923078 + var_x12);
            const double var_x14 = 1.0 - var_x13;
            const double var_x15 = 1 / var_x14;
            const double var_x16 = 0.00011 * var_x15;
            const double var_x17 = 3.0 + var_chaste_interface__membrane__Vm;
            const double var_x19 = var_chaste_interface__membrane__Vm == 0;
            const double var_x20 = var_x15 * var_x17;
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            const double var_x36 = pow(var_chaste_interface__ATP_production__ATPi, 2);
            const double var_x37 = 1 / (1.0 + 99.999999999999986 * var_x36);
            const double var_x48 = -0.052380000000000003 + var_x30 + var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x49 = 1.0 + 1.3823999999999997e-8 / pow(var_x48, 3);
            const double var_x50 = 1 / var_x49;
            const double var_x53 = mParameters[0] * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3;
            const double var_x55 = 1 / var_chaste_interface__internal_ion_concentrations__Ki;
            const double var_x56 = log(5.4000000000000004 * var_x55);
            const double var_x57 = exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.40069247885978065 * var_x56);
            const double var_x58 = 1.0 + var_x57;
            const double var_x59 = exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.93494911733948827 * var_x56);
            const double var_x60 = var_x59 / var_x58;
            const double var_x61 = exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 1.7096212431350641 * var_x56);
            const double var_x62 = 1.0 + var_x61;
            const double var_x63 = exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.80138495771956131 * var_x56);
            const double var_x64 = 1.0 + var_x63;
            const double var_x65 = exp(0.47999999999999998 + 1.282215932351298 * var_x56 - 0.048000000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x66 = var_x65 / var_x64;
            const double var_x67 = var_x62 * var_x66;
            const double var_x68 = var_x67 + 0.25 * var_x60;
            const double var_x69 = pow(var_x68, (-4));
            const double var_x70 = pow(var_x62, 4);
            const double var_x71 = pow(var_x64, (-4));
            const double var_x72 = pow(var_x65, 4);
            const double var_x73 = var_x70 * var_x71 * var_x72;
            const double var_x74 = var_x69 * var_x73;
            const double var_x75 = pow(var_x58, (-2));
            const double var_x76 = pow(var_x65, 2);
            const double var_x77 = pow(var_x59, 2);
            const double var_x78 = var_x69 * var_x75 * var_x76 * var_x77;
            const double var_x79 = pow(var_x64, (-2));
            const double var_x80 = pow(var_x62, 2);
            const double var_x81 = var_x79 * var_x80;
            const double var_x82 = var_x78 * var_x81;
            const double var_x83 = 1 / (0.75 * var_x60 + 3.0 * var_x67);
            const double var_x84 = pow(var_x65, 3);
            const double var_x85 = var_x83 * var_x84 / pow(var_x68, 3);
            const double var_x86 = pow(var_x62, 3);
            const double var_x87 = pow(var_x64, (-3));
            const double var_x88 = var_x60 * var_x86 * var_x87;
            const double var_x89 = var_x85 * var_x88;
            const double var_x90 = mParameters[0] * var_chaste_interface__time_independent_potassium_current_y_gate__y;
            const double var_x93 = var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na;
            const double var_x95 = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2);
            const double var_x96 = 0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2;
            const double var_x97 = var_x95 * var_x96;
            const double var_x99 = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3);
            const double var_x100 = var_x99 * var_chaste_interface__transient_outward_current_y2_gate__y2;
            const double var_x106 = pow(var_x68, (-5));
            const double var_x107 = var_x57 * var_x59 * var_x75;
            const double var_x108 = var_x61 * var_x66;
            const double var_x110 = var_x62 * var_x79;
            const double var_x111 = var_x110 * var_x65;
            const double var_x113 = var_x73;
            const double var_x115 = var_x69 * var_x72;
            const double var_x116 = var_x71 * var_x86;
            const double var_x117 = var_x115 * var_x116 * var_x61;
            const double var_x119 = var_x115 * var_x70 / pow(var_x64, 5);
            const double var_x121 = var_x76 * var_x77 * var_x81;
            const double var_x122 = 0.125 * var_x121 * var_x75;
            const double var_x123 = var_x110 * var_x61 * var_x78;
            const double var_x124 = var_x111 * var_x63;
            const double var_x125 = var_x84 * var_x88;
            const double var_x127 = 0.22222222222222221 * var_x106;
            const double var_x128 = var_x121 * var_x57 * var_x69 / pow(var_x58, 3);
            const double var_x129 = var_x80 * var_x87;
            const double var_x130 = var_x129 * var_x78;
            const double var_x131 = 2.0 * var_x69 * var_x83;
            const double var_x133 = var_x129 * var_x61;
            const double var_x134 = var_x85 * var_x86 * var_x87;
            const double var_x135 = var_x116 * var_x63;
            const double var_x145 = var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa;
            const double var_x146 = pow(var_chaste_interface__ATP_production__ATPi, (-3));
            const double var_x147 = 1 / (1.0 + 2.7439999999999993 * var_x146);
            const double var_x148 = var_x147 * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y;
            const double var_x149 = var_x145 * var_x148;
            const double var_x151 = var_x149 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
            const double var_x154 = var_x1 * var_x4;
            const double var_x160 = 1 / var_chaste_interface__internal_ion_concentrations__Nai;
            const double var_x161 = pow(var_x160, 1.0600000000000001);
            const double var_x162 = var_x161 * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001));
            const double var_x163 = 1 / var_chaste_interface__ATP_production__ATPi;
            const double var_x164 = 1.0 + 0.094 * var_x163;
            const double var_x165 = 1 / var_x164;
            const double var_x166 = var_x165 / pow((0.22703754152993499 + var_x162), 2);
            const double var_x168 = mParameters[0] * var_chaste_interface__sodium_potassium_pump_y_gate__y;
            const double var_x170 = ((var_x11) ? (5.3564032599450697e-5 * var_x7) : ((var_x19) ? (var_x16 * var_x17) : (4.1178711531977753e-6 * var_x20 * var_x7)));
            const double var_x171 = ((var_x19) ? (1) : (var_x154));
            const double var_x172 = var_x37 * var_x55;
            const double var_x173 = var_x55 * var_x60;
            const double var_x174 = var_x107 * var_x55;
            const double var_x175 = var_x55 * var_x67;
            const double var_x176 = var_x108 * var_x55;
            const double var_x177 = var_x124 * var_x55;
            const double var_x178 = var_x106 * (0.40069247885978065 * var_x174 + 3.2055398308782452 * var_x177 + 5.1288637294051922 * var_x175 - 6.8384849725402566 * var_x176 - 0.93494911733948827 * var_x173);
            const double var_x179 = var_x113 * var_x178;
            const double var_x180 = 5.1288637294051922 * var_x55 * var_x74;
            const double var_x181 = 6.8384849725402566 * var_x117 * var_x55;
            const double var_x182 = var_x55 * var_x63;
            const double var_x183 = 3.2055398308782452 * var_x119 * var_x182;
            const double var_x184 = var_x125 * (0.30051935914483546 * var_x174 + 2.4041548731586837 * var_x177 + 3.8466477970538944 * var_x175 - 5.1288637294051922 * var_x176 - 0.70121183800461617 * var_x173);
            const double var_x185 = var_x173 * var_x85;
            const double var_x186 = var_x179 + var_x181 - var_x180 - var_x183 + var_x122 * var_x178 + var_x127 * var_x184 + var_x131 * var_x184 + 10.257727458810384 * var_x133 * var_x185 + 0.42740531078376603 * var_x123 * var_x55 - 0.10017311971494516 * var_x128 * var_x55 - 0.20034623942989033 * var_x130 * var_x182 - 0.80138495771956131 * var_x134 * var_x174 - 4.8083097463173674 * var_x135 * var_x185 - 0.086816703752952459 * var_x55 * var_x82 - 5.823397359428812 * var_x134 * var_x173;
            const double var_x187 = 26.712831923985377 * var_x55;
            const double var_x188 = var_x74;
            const double var_x189 = var_x188 + 0.125 * var_x82 + 2.0 * var_x89;
            const double var_x190 = var_x189 * var_x55 * var_x90;
            const double var_x191 = var_x161 * var_x166 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 0.12000000000000011);
            const double var_x192 = var_x168 * var_x191;
            const double var_x236 = 1.4250668745018745e-7 * var_x50;
            const double var_x245 = -4.477301016616798e-9 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 - 6.7159515249251966e-9 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1;
            const double var_x246 = var_x245 * var_x53;
            const double var_x247 = 0.00037051738737048736 * var_x93;
            const double var_x248 = 6.5293973158994975e-6 * var_x97;
            const double var_x249 = 4.2752006235056235e-8 * var_x100;
            const double var_x250 = 3.9659488542057145e-5 * var_x56 - 1.4846605801628617e-6 * var_chaste_interface__membrane__Vm;
            const double var_x251 = var_x250 * var_x90;
            const double var_x252 = 4.1195833208100184e-6 * var_x151;
            
            partialF = -3.9659488542057145e-5 * var_x190 - 1.0238719530354315e-7 * var_x192 - 0.0022848291065246224 * var_x172 - 1.2955153404562495e-6 * var_x170 - 1.9950936243026244e-7 * var_x171 + var_x186 * var_x251 + var_x187 * var_x246 - var_x171 * var_x236 - var_x171 * var_x247 - var_x171 * var_x248 - var_x171 * var_x249 - var_x171 * var_x252;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__SR_calcium_pump_y_gate__y = rY[28];
        // Units: dimensionless; Initial value: 0.46108441538480216
        double var_chaste_interface__RyR_channel__p_open_RyR = rY[29];
        // Units: dimensionless; Initial value: 0.00034314360001543243
        double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rY[31];
        // Units: millimolar; Initial value: 9.455741736977666
        double var_chaste_interface__Ca_concentrations_in_SR__Caup = rY[32];
        // Units: millimolar; Initial value: 2.611712901567567
        double var_chaste_interface__NL_model__pCa = rY[33];
        // Units: dimensionless; Initial value: 0.02490898775497523
        double var_chaste_interface__NL_model__pCaCB = rY[34];
        // Units: dimensionless; Initial value: 0.001990153835322864
        double var_chaste_interface__NL_model__pCB = rY[35];
        // Units: dimensionless; Initial value: 0.00042941813853474524
        double var_chaste_interface__NL_model__X = rY[36];
        // Units: micrometre; Initial value: 0.9573749975411884
        
        
        // Mathematics
        const double var_Ca_concentrations_in_SR__Carel = -5.4000000000000004 + 0.5 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + 5.4000000000000004 * sqrt(pow((1 - 0.092592592592592587 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total), 2) + 0.027434842249657067 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total); // millimolar
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double d_dt_chaste_interface_var_NL_model__X = 1.1488559970494261 - 1.2 * var_chaste_interface__NL_model__X; // micrometre / millisecond
        const double var_NL_model__Q_d2 = 0.027 * pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_chaste_interface__NL_model__pCaCB; // per_millisecond
        const double var_SR_calcium_pump__k2 = 1 / (1.0 + 0.10000000000000001 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_SR_calcium_pump__p_E1Ca = 1 / (1.0 + 0.080000000000000002 / var_chaste_interface__Ca_concentrations_in_SR__Caup); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_NL_model__Q_b = -0.029999999999999999 * var_chaste_interface__NL_model__pCa + 39.0 * (1.0 - var_chaste_interface__NL_model__pCB - var_chaste_interface__NL_model__pCa - var_chaste_interface__NL_model__pCaCB) * var_internal_ion_concentrations__Cai; // per_millisecond
        const double var_NL_model__Q_r = 0.029999999999999999 * var_chaste_interface__NL_model__pCaCB - 1560.0 * var_chaste_interface__NL_model__pCB * var_internal_ion_concentrations__Cai; // per_millisecond
        const double var_RyR_channel__i_RyR = 62000.0 * (-var_internal_ion_concentrations__Cai + var_Ca_concentrations_in_SR__Carel) * var_chaste_interface__RyR_channel__p_open_RyR; // picoA
        const double var_SR_L_current__i_SR_L = 459.0 * var_chaste_interface__Ca_concentrations_in_SR__Caup - 459.0 * var_internal_ion_concentrations__Cai; // picoA
        const double var_SR_calcium_pump__p_E2Ca = 1 / (1.0 + 0.00080000000000000004 / var_internal_ion_concentrations__Cai); // dimensionless
        const double var_SR_calcium_pump__i_SR_U = 1625.0 * var_SR_calcium_pump__p_E1Ca * var_chaste_interface__SR_calcium_pump_y_gate__y - 162500.0 * (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca; // picoA
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-1.8) : (0.074870384603595908 * (-1.8 * exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm) + var_internal_ion_concentrations__Cai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Ca = 8712.0 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca; // picoA
        const double var_T_type_Ca_channel__i_Ca_T = 612.0 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca; // picoA
        const double var_background_Cab_current__i_Cab = 0.040000000000000001 * var_constant_field_equations__CF_Ca; // picoA
        const double var_sodium_calcium_exchanger__k1 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + 669.921875 * (1.0 + 724.63768115942037 * var_internal_ion_concentrations__Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa = 6.8099999999999996 * (-0.6399652192815608 * (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 + var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * mParameters[0]; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total = 0.070000000000000007 * var_NL_model__Q_d2 + 0.070000000000000007 * var_NL_model__Q_r + 6.4775767022812476e-7 * var_RyR_channel__i_RyR + 6.4775767022812476e-7 * var_SR_L_current__i_SR_L + 6.4775767022812476e-7 * var_SR_calcium_pump__i_SR_U + 1.2955153404562495e-6 * var_sodium_calcium_exchanger__i_NaCa - 0.070000000000000007 * var_NL_model__Q_b - 6.4775767022812476e-7 * var_L_type_Ca_channel__i_CaL_Ca - 6.4775767022812476e-7 * var_T_type_Ca_channel__i_Ca_T - 6.4775767022812476e-7 * var_background_Cab_current__i_Cab; // millimolar / millisecond

        return d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
            // Units: millimolar; Initial value: 4.925761439682025
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            double var_chaste_interface__ATP_production__ATPi = rY[4];
            // Units: millimolar; Initial value: 4.657102729020499
            double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
            // Units: dimensionless; Initial value: 1.5445004166497696e-06
            double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
            // Units: dimensionless; Initial value: 0.17246483915629204
            double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
            // Units: dimensionless; Initial value: 6.098246017787626e-05
            double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
            // Units: dimensionless; Initial value: 0.9985266538252986
            double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
            // Units: dimensionless; Initial value: 1.6882718240109127e-05
            double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
            // Units: dimensionless; Initial value: 0.8585352091865849
            double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
            // Units: dimensionless; Initial value: 0.9891789193465331
            double var_chaste_interface__SR_calcium_pump_y_gate__y = rY[28];
            // Units: dimensionless; Initial value: 0.46108441538480216
            double var_chaste_interface__RyR_channel__p_open_RyR = rY[29];
            // Units: dimensionless; Initial value: 0.00034314360001543243
            double var_chaste_interface__NL_model__pCa = rY[33];
            // Units: dimensionless; Initial value: 0.02490898775497523
            double var_chaste_interface__NL_model__pCaCB = rY[34];
            // Units: dimensionless; Initial value: 0.001990153835322864
            double var_chaste_interface__NL_model__pCB = rY[35];
            // Units: dimensionless; Initial value: 0.00042941813853474524
            
            const double var_x19 = var_chaste_interface__membrane__Vm == 0;
            const double var_x26 = 0.074870384603595908 * var_chaste_interface__membrane__Vm;
            const double var_x27 = exp(-var_x26);
            const double var_x28 = 1.0 - var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            const double var_x31 = -0.026190000000000001 + 0.5 * var_x30 + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x41 = pow(var_chaste_interface__internal_ion_concentrations__Nai, 3);
            const double var_x42 = 1 / var_x41;
            const double var_x43 = -17.978260869565219 + 362.31884057971018 * var_x30 + 362.31884057971018 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x44 = var_x42 * var_x43;
            const double var_x45 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm);
            const double var_x48 = -0.052380000000000003 + var_x30 + var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x145 = var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa;
            const double var_x146 = pow(var_chaste_interface__ATP_production__ATPi, (-3));
            const double var_x147 = 1 / (1.0 + 2.7439999999999993 * var_x146);
            const double var_x148 = var_x147 * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y;
            const double var_x149 = var_x145 * var_x148;
            const double var_x151 = var_x149 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
            const double var_x156 = var_x45 / pow((0.0014927113702623907 + var_x44), 2);
            const double var_x158 = mParameters[0] * var_chaste_interface__sodium_calcium_exchanger_y_gate__y;
            const double var_x163 = 1 / var_chaste_interface__ATP_production__ATPi;
            const double var_x193 = (-0.047620000000000003 + var_chaste_interface__internal_ion_concentrations__Ca_Total) / var_x30;
            const double var_x194 = 0.5 * var_x193;
            const double var_x195 = 0.5 + var_x194;
            const double var_x196 = ((var_x19) ? (0) : (var_x195 * var_x26 * var_x29));
            const double var_x201 = var_x156 * var_x42 * (362.31884057971018 + 362.31884057971018 * var_x193);
            const double var_x202 = var_x158 * var_x201;
            const double var_x256 = 0.00039642769417961232 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2;
            const double var_x258 = 1.0 - var_chaste_interface__NL_model__pCB - var_chaste_interface__NL_model__pCa - var_chaste_interface__NL_model__pCaCB;
            const double var_x259 = 1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y;
            const double var_x260 = 1.0 + 0.10000000000000001 * var_x163;
            const double var_x261 = 1 / var_x260;
            const double var_x262 = 1 / var_x31;
            const double var_x263 = 1.0 + 0.00080000000000000004 * var_x262;
            const double var_x264 = pow(var_x48, 2);
            const double var_x265 = (-0.5 - var_x194) / var_x264;
            const double var_x266 = var_x265 / pow(var_x263, 2);
            const double var_x267 = var_x261 * var_x266;
            const double var_x268 = var_x259 * var_x267;
            const double var_x269 = var_x151 * var_x196;
            
            partialF = -0.00014866038531735463 + 0.00033683398851862484 * var_x268 - 0.0056432648230274225 * var_x269 - 0.00014866038531735463 * var_x193 - 2.591030680912499e-8 * var_x196 - 1.3169385562319573e-8 * var_x202 + var_x258 * (-1.3650000000000002 - 1.3650000000000002 * var_x193) + (-54.600000000000009 - 54.600000000000009 * var_x193) * var_chaste_interface__NL_model__pCB + (-0.020080487777071866 - 0.020080487777071866 * var_x193) * var_chaste_interface__RyR_channel__p_open_RyR - var_x196 * var_x256;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        double var_chaste_interface__SR_calcium_pump_y_gate__y = rY[28];
        // Units: dimensionless; Initial value: 0.46108441538480216
        double var_chaste_interface__Ca_concentrations_in_SR__Caup = rY[32];
        // Units: millimolar; Initial value: 2.611712901567567
        double var_chaste_interface__NL_model__pCaCB = rY[34];
        // Units: dimensionless; Initial value: 0.001990153835322864
        
        
        // Mathematics
        const double var_SR_calcium_pump__k2 = 1 / (1.0 + 0.10000000000000001 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_SR_calcium_pump__p_E1Ca = 1 / (1.0 + 0.080000000000000002 / var_chaste_interface__Ca_concentrations_in_SR__Caup); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_SR_calcium_pump__p_E2Ca = 1 / (1.0 + 0.00080000000000000004 / var_internal_ion_concentrations__Cai); // dimensionless
        const double var_SR_calcium_pump__i_SR_U = 1625.0 * var_SR_calcium_pump__p_E1Ca * var_chaste_interface__SR_calcium_pump_y_gate__y - 162500.0 * (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca; // picoA
        const double var_sodium_potassium_pump__Nao_Eff = 140.0 * exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm); // millimolar
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + 0.094 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + 4.4045579125871104 * pow(1 / var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001) * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + 2804.9496956618664 * pow(1 / var_sodium_potassium_pump__Nao_Eff, 1.0600000000000001)); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = 21.0 * (-0.040000000000000001 * (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__p_E2Na + var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y) * mParameters[0]; // picoA
        const double d_dt_chaste_interface_var_ATP_production__ATPi = 0.014999999999999999 + 3.2387883511406238e-7 * var_SR_calcium_pump__i_SR_U - 0.0030000000000000001 * var_chaste_interface__ATP_production__ATPi - 0.028000000000000004 * var_chaste_interface__NL_model__pCaCB - 1.2955153404562495e-6 * var_sodium_potassium_pump__i_NaK; // millimolar / millisecond

        return d_dt_chaste_interface_var_ATP_production__ATPi;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
            // Units: millimolar; Initial value: 4.925761439682025
            double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
            // Units: millimolar; Initial value: 143.1837333000449
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            double var_chaste_interface__ATP_production__ATPi = rY[4];
            // Units: millimolar; Initial value: 4.657102729020499
            double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
            // Units: dimensionless; Initial value: 0.5910747147428818
            double var_chaste_interface__SR_calcium_pump_y_gate__y = rY[28];
            // Units: dimensionless; Initial value: 0.46108441538480216
            
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            const double var_x31 = -0.026190000000000001 + 0.5 * var_x30 + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x36 = pow(var_chaste_interface__ATP_production__ATPi, 2);
            const double var_x160 = 1 / var_chaste_interface__internal_ion_concentrations__Nai;
            const double var_x161 = pow(var_x160, 1.0600000000000001);
            const double var_x162 = var_x161 * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001));
            const double var_x163 = 1 / var_chaste_interface__ATP_production__ATPi;
            const double var_x164 = 1.0 + 0.094 * var_x163;
            const double var_x205 = 1 / (1.0 + 4.4045579125871104 * var_x162);
            const double var_x206 = 1 / var_x36;
            const double var_x207 = var_x205 * var_x206 * var_chaste_interface__sodium_potassium_pump_y_gate__y / pow(var_x164, 2);
            const double var_x208 = var_x207 * mParameters[0];
            const double var_x259 = 1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y;
            const double var_x260 = 1.0 + 0.10000000000000001 * var_x163;
            const double var_x262 = 1 / var_x31;
            const double var_x263 = 1.0 + 0.00080000000000000004 * var_x262;
            const double var_x270 = 1 / var_x263;
            const double var_x271 = var_x206 * var_x259 * var_x270 / pow(var_x260, 2);
            
            partialF = -0.0030000000000000001 - 9.4621849436243545e-7 * var_x208 - 0.005263031070603514 * var_x271;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na = rY[6];
        // Units: dimensionless; Initial value: 0.3556412697995689
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na = rY[7];
        // Units: dimensionless; Initial value: 0.40285968661346977
        
        
        // Mathematics
        const double var_sodium_current_voltage_dependent_gate__k_AP_AI = 1.25 / exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_RP = 1 / (26.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm) + 0.02 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_AP = 1 / (0.25 * exp(-0.02 * var_chaste_interface__membrane__Vm) + 0.1027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na = 8.7499999999999999e-5 * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na + var_sodium_current_voltage_dependent_gate__k_RP_AP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na - (var_sodium_current_voltage_dependent_gate__k_AP_AI + var_sodium_current_voltage_dependent_gate__k_AP_RP) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x284 = exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x285 = 1 / var_x284;
            const double var_x287 = exp(0.00125 * var_chaste_interface__membrane__Vm);
            const double var_x288 = 0.058823529411764705 * var_chaste_interface__membrane__Vm;
            const double var_x289 = exp(var_x288);
            const double var_x297 = 1 / (26.0 * var_x289 + 0.02 * var_x287);
            const double var_x298 = var_x297;
            const double var_x299 = 1.25 * var_x285;
            
            partialF = -var_x298 - var_x299;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na = rY[6];
        // Units: dimensionless; Initial value: 0.3556412697995689
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na = rY[7];
        // Units: dimensionless; Initial value: 0.40285968661346977
        
        
        // Mathematics
        const double var_sodium_current_voltage_dependent_gate__k_AI_RI = 1 / (1300.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm) + 0.040000000000000001 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_AI = 1.25 / exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_RP = 1 / (26.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm) + 0.02 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RI_AI = 1 / (5.0 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm) + 0.0001027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_AP = 1 / (0.25 * exp(-0.02 * var_chaste_interface__membrane__Vm) + 0.1027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_RI = 0.01 / (1.0 + 8.7499999999999999e-5 * var_sodium_current_voltage_dependent_gate__k_AP_RP * var_sodium_current_voltage_dependent_gate__k_RI_AI / (var_sodium_current_voltage_dependent_gate__k_AI_RI * var_sodium_current_voltage_dependent_gate__k_AP_AI * var_sodium_current_voltage_dependent_gate__k_RP_AP)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__p_RI_Na = 1.0 - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // dimensionless
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na = (0.01 - var_sodium_current_voltage_dependent_gate__k_RP_RI) * var_sodium_current_voltage_dependent_gate__p_RI_Na + var_sodium_current_voltage_dependent_gate__k_AP_RP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na - (var_sodium_current_voltage_dependent_gate__k_RP_AP + var_sodium_current_voltage_dependent_gate__k_RP_RI) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x292 = exp(-0.125 * var_chaste_interface__membrane__Vm);
            const double var_x293 = exp(-0.02 * var_chaste_interface__membrane__Vm);
            const double var_x300 = 0.25 * var_x293 + 0.1027 * var_x292;
            const double var_x301 = 1 / var_x300;
            
            partialF = -0.01 - var_x301;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na = rY[6];
        // Units: dimensionless; Initial value: 0.3556412697995689
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na = rY[7];
        // Units: dimensionless; Initial value: 0.40285968661346977
        
        
        // Mathematics
        const double var_sodium_current_voltage_dependent_gate__k_AI_RI = 1 / (1300.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm) + 0.040000000000000001 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_AI = 1.25 / exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RI_AI = 1 / (5.0 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm) + 0.0001027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__p_RI_Na = 1.0 - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // dimensionless
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na = var_sodium_current_voltage_dependent_gate__k_AP_AI * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + var_sodium_current_voltage_dependent_gate__k_RI_AI * var_sodium_current_voltage_dependent_gate__p_RI_Na - (8.7499999999999999e-5 + var_sodium_current_voltage_dependent_gate__k_AI_RI) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x284 = exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x287 = exp(0.00125 * var_chaste_interface__membrane__Vm);
            const double var_x292 = exp(-0.125 * var_chaste_interface__membrane__Vm);
            const double var_x302 = 1 / (5.0 * var_x284 + 0.0001027 * var_x292);
            const double var_x303 = exp(0.050000000000000003 * var_chaste_interface__membrane__Vm);
            const double var_x304 = 1300.0 * var_x303 + 0.040000000000000001 * var_x287;
            const double var_x316 = -1.0 * var_x302;
            
            partialF = -8.7499999999999999e-5 + var_x316 - 1.0 / var_x304;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_sodium_current_ultra_slow_gate__y = (1.0 - var_chaste_interface__sodium_current_ultra_slow_gate__y) / (8000.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 9000000000.0 * exp(0.20000000000000001 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__sodium_current_ultra_slow_gate__y / (4000.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.014 * exp(-0.20000000000000001 * var_chaste_interface__membrane__Vm)); // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_ultra_slow_gate__y;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x317 = 0.01 * var_chaste_interface__membrane__Vm;
            const double var_x318 = exp(var_x317);
            const double var_x319 = 0.20000000000000001 * var_chaste_interface__membrane__Vm;
            const double var_x320 = exp(var_x319);
            const double var_x321 = exp(-var_x319);
            const double var_x322 = exp(-var_x317);
            
            partialF = -1.0 / (4000.0 * var_x322 + 0.014 * var_x321) - 1.0 / (8000.0 * var_x318 + 9000000000.0 * var_x320);
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = rY[10];
        // Units: dimensionless; Initial value: 0.9968480629364956
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = rY[11];
        // Units: dimensionless; Initial value: 0.000877325391245903
        
        
        // Mathematics
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP = 1 / (480.0 * exp(0.14285714285714285 * var_chaste_interface__membrane__Vm) + 2.2000000000000002 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP = 1 / (1.5 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 0.27000000000000002 * exp(-0.16949152542372881 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = 0.001 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL - (0.0040000000000000001 + var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x324 = 0.015384615384615385 * var_chaste_interface__membrane__Vm;
            const double var_x329 = exp(var_x324);
            const double var_x330 = exp(0.14285714285714285 * var_chaste_interface__membrane__Vm);
            const double var_x333 = 1 / (480.0 * var_x330 + 2.2000000000000002 * var_x329);
            const double var_x334 = var_x333;
            
            partialF = -0.0040000000000000001 - var_x334;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = rY[10];
        // Units: dimensionless; Initial value: 0.9968480629364956
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = rY[11];
        // Units: dimensionless; Initial value: 0.000877325391245903
        
        
        // Mathematics
        const double var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL = 1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // dimensionless
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI = 1 / (11.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 2200000.0 * exp(0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP = 1 / (480.0 * exp(0.14285714285714285 * var_chaste_interface__membrane__Vm) + 2.2000000000000002 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI = 1 / (2.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.0018 * exp(-0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP = 1 / (1.5 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 0.27000000000000002 * exp(-0.16949152542372881 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI = 0.040000000000000001 / (1.0 + 0.25 * var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP * var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI / (var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI * var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = (0.040000000000000001 - var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI) * var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL - (var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP + var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x323 = exp(-0.16949152542372881 * var_chaste_interface__membrane__Vm);
            const double var_x324 = 0.015384615384615385 * var_chaste_interface__membrane__Vm;
            const double var_x325 = exp(-var_x324);
            const double var_x335 = 1.5 * var_x325 + 0.27000000000000002 * var_x323;
            const double var_x336 = 1 / var_x335;
            
            partialF = -0.040000000000000001 - var_x336;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = rY[10];
        // Units: dimensionless; Initial value: 0.9968480629364956
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = rY[11];
        // Units: dimensionless; Initial value: 0.000877325391245903
        
        
        // Mathematics
        const double var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL = 1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // dimensionless
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI = 1 / (11.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 2200000.0 * exp(0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI = 1 / (2.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.0018 * exp(-0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = 0.0040000000000000001 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI * var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL - (0.001 + var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x317 = 0.01 * var_chaste_interface__membrane__Vm;
            const double var_x318 = exp(var_x317);
            const double var_x322 = exp(-var_x317);
            const double var_x337 = 0.13513513513513511 * var_chaste_interface__membrane__Vm;
            const double var_x338 = exp(var_x337);
            const double var_x339 = 11.0 * var_x318 + 2200000.0 * var_x338;
            const double var_x341 = exp(-var_x337);
            const double var_x342 = 1 / (2.0 * var_x322 + 0.0018 * var_x341);
            const double var_x353 = -1.0 * var_x342;
            
            partialF = -0.001 + var_x353 - 1.0 / var_x339;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C = rY[14];
        // Units: dimensionless; Initial value: 0.4250747299372254
        
        
        // Mathematics
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-1.8) : (0.074870384603595908 * (-1.8 * exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm) + var_internal_ion_concentrations__Cai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__iCaL = 0.067599999999999993 * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__Cacm = -0.29999999999999999 * var_L_type_Ca_channel_Ca_dependent_gate__iCaL + var_internal_ion_concentrations__Cai; // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca = 6.9539999999999997 * (1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL) * var_internal_ion_concentrations__Cai + 6.9539999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U = 0.14299999999999999 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C + 2.0019999999999998 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa - (0.34999999999999998 + var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
            // Units: dimensionless; Initial value: 1.5445004166497696e-06
            
            const double var_x19 = var_chaste_interface__membrane__Vm == 0;
            const double var_x26 = 0.074870384603595908 * var_chaste_interface__membrane__Vm;
            const double var_x27 = exp(-var_x26);
            const double var_x28 = 1.0 - var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            const double var_x31 = -0.026190000000000001 + 0.5 * var_x30 + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x32 = var_x31 - 1.8 * var_x27;
            const double var_x33 = var_x29 * var_x32;
            const double var_x213 = ((var_x19) ? (-1.8) : (var_x26 * var_x33));
            const double var_x350 = 1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
            const double var_x356 = 6.9539999999999997 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
            const double var_x361 = 6.9539999999999997 * var_x31 * var_x350;
            const double var_x362 = var_x356 * (var_x31 - 0.020279999999999996 * var_x213);
            const double var_x363 = -var_x362;
            
            partialF = -0.34999999999999998 + var_x363 - var_x361;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C = rY[14];
        // Units: dimensionless; Initial value: 0.4250747299372254
        
        
        // Mathematics
        const double var_L_type_Ca_channel_Ca_dependent_gate__p_CCa = 1.0 - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa; // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-1.8) : (0.074870384603595908 * (-1.8 * exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm) + var_internal_ion_concentrations__Cai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__iCaL = 0.067599999999999993 * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__Cacm = -0.29999999999999999 * var_L_type_Ca_channel_Ca_dependent_gate__iCaL + var_internal_ion_concentrations__Cai; // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca = 6.9539999999999997 * (1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL) * var_internal_ion_concentrations__Cai + 6.9539999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa = 0.00029999999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__p_CCa - 2.3519999999999999 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa + var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -2.3523000000000001;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C = rY[14];
        // Units: dimensionless; Initial value: 0.4250747299372254
        
        
        // Mathematics
        const double var_L_type_Ca_channel_Ca_dependent_gate__p_CCa = 1.0 - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa; // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-1.8) : (0.074870384603595908 * (-1.8 * exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm) + var_internal_ion_concentrations__Cai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__iCaL = 0.067599999999999993 * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__Cacm = -0.29999999999999999 * var_L_type_Ca_channel_Ca_dependent_gate__iCaL + var_internal_ion_concentrations__Cai; // millimolar
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C = 0.34999999999999998 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + 0.0041999999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__p_CCa - (0.14299999999999999 + 6.9539999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
            // Units: dimensionless; Initial value: 1.5445004166497696e-06
            
            const double var_x19 = var_chaste_interface__membrane__Vm == 0;
            const double var_x26 = 0.074870384603595908 * var_chaste_interface__membrane__Vm;
            const double var_x27 = exp(-var_x26);
            const double var_x28 = 1.0 - var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            const double var_x31 = -0.026190000000000001 + 0.5 * var_x30 + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x32 = var_x31 - 1.8 * var_x27;
            const double var_x33 = var_x29 * var_x32;
            const double var_x213 = ((var_x19) ? (-1.8) : (var_x26 * var_x33));
            const double var_x356 = 6.9539999999999997 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
            const double var_x362 = var_x356 * (var_x31 - 0.020279999999999996 * var_x213);
            const double var_x363 = -var_x362;
            
            partialF = -0.1472 + var_x363;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_L_type_Ca_channel_ultra_slow_gate__y = (1.0 - var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y) / (58.0 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm) + 250000.0 * exp(0.1111111111111111 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y / (66.0 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 1800.0 * exp(-0.071428571428571425 * var_chaste_interface__membrane__Vm)); // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_ultra_slow_gate__y;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x324 = 0.015384615384615385 * var_chaste_interface__membrane__Vm;
            const double var_x325 = exp(-var_x324);
            const double var_x329 = exp(var_x324);
            const double var_x364 = exp(0.1111111111111111 * var_chaste_interface__membrane__Vm);
            const double var_x365 = exp(-0.071428571428571425 * var_chaste_interface__membrane__Vm);
            
            partialF = -1.0 / (58.0 * var_x329 + 250000.0 * var_x364) - 1.0 / (66.0 * var_x325 + 1800.0 * var_x365);
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_T_type_Ca_channel_y1_gate__y1 = (1.0 - var_chaste_interface__T_type_Ca_channel_y1_gate__y1) / (0.019 * exp(-0.17857142857142858 * var_chaste_interface__membrane__Vm) + 0.81999999999999995 * exp(-0.0040000000000000001 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 / (1.5 * exp(0.0001 * var_chaste_interface__membrane__Vm) + 40.0 * exp(0.15873015873015872 * var_chaste_interface__membrane__Vm)); // 1 / millisecond

        return d_dt_chaste_interface_var_T_type_Ca_channel_y1_gate__y1;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x366 = exp(-0.17857142857142858 * var_chaste_interface__membrane__Vm);
            const double var_x367 = exp(-0.0040000000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x368 = exp(0.0001 * var_chaste_interface__membrane__Vm);
            const double var_x369 = exp(0.15873015873015872 * var_chaste_interface__membrane__Vm);
            
            partialF = -1.0 / (1.5 * var_x368 + 40.0 * var_x369) - 1.0 / (0.019 * var_x366 + 0.81999999999999995 * var_x367);
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_T_type_Ca_channel_y2_gate__y2 = (1.0 - var_chaste_interface__T_type_Ca_channel_y2_gate__y2) / (30.0 * exp(0.00033333333333333332 * var_chaste_interface__membrane__Vm) + 62000.0 * exp(0.099009900990099015 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 / (1.2 * exp(-0.040000000000000001 * var_chaste_interface__membrane__Vm) + 0.00059999999999999995 * exp(-0.14925373134328357 * var_chaste_interface__membrane__Vm)); // 1 / millisecond

        return d_dt_chaste_interface_var_T_type_Ca_channel_y2_gate__y2;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x370 = exp(0.00033333333333333332 * var_chaste_interface__membrane__Vm);
            const double var_x371 = exp(0.099009900990099015 * var_chaste_interface__membrane__Vm);
            const double var_x372 = exp(-0.14925373134328357 * var_chaste_interface__membrane__Vm);
            const double var_x373 = exp(-0.040000000000000001 * var_chaste_interface__membrane__Vm);
            
            partialF = -1.0 / (30.0 * var_x370 + 62000.0 * var_x371) - 1.0 / (1.2 * var_x373 + 0.00059999999999999995 * var_x372);
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
        // Units: dimensionless; Initial value: 0.6080573900752752
        
        
        // Mathematics
        const double var_time_independent_potassium_current__E_K = 26.712831923985377 * log(5.4000000000000004 / var_chaste_interface__internal_ion_concentrations__Ki); // millivolt
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y = (1.0 - var_chaste_interface__time_independent_potassium_current_y_gate__y) / (7.0 * exp(-0.32333333333333331 + 0.0033333333333333335 * var_chaste_interface__membrane__Vm - 0.0033333333333333335 * var_time_independent_potassium_current__E_K) + 8000.0 * exp(-11.411764705882353 + 0.11764705882352941 * var_chaste_interface__membrane__Vm - 0.11764705882352941 * var_time_independent_potassium_current__E_K)) - 1.0 * pow(var_time_independent_potassium_current__fO, 4) * var_chaste_interface__time_independent_potassium_current_y_gate__y / (0.00013999999999999999 * exp(10.659340659340661 + 0.10989010989010989 * var_time_independent_potassium_current__E_K - 0.10989010989010989 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(0.19400000000000001 + 0.002 * var_time_independent_potassium_current__E_K - 0.002 * var_chaste_interface__membrane__Vm)); // 1 / millisecond

        return d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
            // Units: millimolar; Initial value: 143.1837333000449
            
            const double var_x55 = 1 / var_chaste_interface__internal_ion_concentrations__Ki;
            const double var_x56 = log(5.4000000000000004 * var_x55);
            const double var_x57 = exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.40069247885978065 * var_x56);
            const double var_x58 = 1.0 + var_x57;
            const double var_x59 = exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.93494911733948827 * var_x56);
            const double var_x60 = var_x59 / var_x58;
            const double var_x61 = exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 1.7096212431350641 * var_x56);
            const double var_x62 = 1.0 + var_x61;
            const double var_x63 = exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.80138495771956131 * var_x56);
            const double var_x64 = 1.0 + var_x63;
            const double var_x65 = exp(0.47999999999999998 + 1.282215932351298 * var_x56 - 0.048000000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x66 = var_x65 / var_x64;
            const double var_x67 = var_x62 * var_x66;
            const double var_x68 = var_x67 + 0.25 * var_x60;
            const double var_x69 = pow(var_x68, (-4));
            const double var_x70 = pow(var_x62, 4);
            const double var_x71 = pow(var_x64, (-4));
            const double var_x72 = pow(var_x65, 4);
            const double var_x73 = var_x70 * var_x71 * var_x72;
            const double var_x74 = var_x69 * var_x73;
            const double var_x188 = var_x74;
            const double var_x374 = 0.0033333333333333335 * var_chaste_interface__membrane__Vm;
            const double var_x375 = exp(-0.32333333333333331 + var_x374 - 0.08904277307995126 * var_x56);
            const double var_x376 = exp(-11.411764705882353 + 0.11764705882352941 * var_chaste_interface__membrane__Vm - 3.142686108704162 * var_x56);
            const double var_x378 = exp(10.659340659340661 + 2.9354760356027887 * var_x56 - 0.10989010989010989 * var_chaste_interface__membrane__Vm);
            const double var_x379 = 0.002 * var_chaste_interface__membrane__Vm;
            const double var_x380 = exp(0.19400000000000001 - var_x379 + 0.053425663847970754 * var_x56);
            const double var_x381 = 1 / (0.00013999999999999999 * var_x378 + 0.20000000000000001 * var_x380);
            
            partialF = -1.0 / (7.0 * var_x375 + 8000.0 * var_x376) - var_x188 * var_x381;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y1_gate__y1 = -(1 / (160.0 * exp(0.035714285714285712 * var_chaste_interface__membrane__Vm) + 200.0 * exp(0.001 * var_chaste_interface__membrane__Vm)) + 0.00040000000000000002 / exp(0.050000000000000003 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 + (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) / (5.0 * exp(-0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 20.0 * exp(-0.086956521739130432 * var_chaste_interface__membrane__Vm)); // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y1_gate__y1;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x303 = exp(0.050000000000000003 * var_chaste_interface__membrane__Vm);
            const double var_x374 = 0.0033333333333333335 * var_chaste_interface__membrane__Vm;
            const double var_x384 = 1 / var_x303;
            const double var_x385 = 0.035714285714285712 * var_chaste_interface__membrane__Vm;
            const double var_x386 = exp(var_x385);
            const double var_x387 = exp(0.001 * var_chaste_interface__membrane__Vm);
            const double var_x389 = exp(-var_x374);
            const double var_x390 = exp(-0.086956521739130432 * var_chaste_interface__membrane__Vm);
            
            partialF = -1.0 / (5.0 * var_x389 + 20.0 * var_x390) - 1.0 / (160.0 * var_x386 + 200.0 * var_x387) - 0.00040000000000000002 * var_x384;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y2_gate__y2 = -(1 / (1600.0 * exp(0.035714285714285712 * var_chaste_interface__membrane__Vm) + 2000.0 * exp(0.001 * var_chaste_interface__membrane__Vm)) + 0.0001 / exp(0.050000000000000003 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2) / (20.0 * exp(-0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 200.0 * exp(-0.076923076923076927 * var_chaste_interface__membrane__Vm)); // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y2_gate__y2;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x12 = -0.076923076923076927 * var_chaste_interface__membrane__Vm;
            const double var_x303 = exp(0.050000000000000003 * var_chaste_interface__membrane__Vm);
            const double var_x374 = 0.0033333333333333335 * var_chaste_interface__membrane__Vm;
            const double var_x384 = 1 / var_x303;
            const double var_x385 = 0.035714285714285712 * var_chaste_interface__membrane__Vm;
            const double var_x386 = exp(var_x385);
            const double var_x387 = exp(0.001 * var_chaste_interface__membrane__Vm);
            const double var_x389 = exp(-var_x374);
            const double var_x391 = exp(var_x12);
            
            partialF = -1.0 / (20.0 * var_x389 + 200.0 * var_x391) - 1.0 / (1600.0 * var_x386 + 2000.0 * var_x387) - 0.0001 * var_x384;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y3_gate__y3 = (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3) / (2.5 * exp(0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 10.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 / (2.0 * exp(-0.0066666666666666671 * var_chaste_interface__membrane__Vm) + 0.34999999999999998 * exp(-0.058823529411764705 * var_chaste_interface__membrane__Vm)); // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y3_gate__y3;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x288 = 0.058823529411764705 * var_chaste_interface__membrane__Vm;
            const double var_x289 = exp(var_x288);
            const double var_x374 = 0.0033333333333333335 * var_chaste_interface__membrane__Vm;
            const double var_x392 = exp(var_x374);
            const double var_x393 = exp(-var_x288);
            const double var_x394 = exp(-0.0066666666666666671 * var_chaste_interface__membrane__Vm);
            
            partialF = -1.0 / (2.0 * var_x394 + 0.34999999999999998 * var_x393) - 1.0 / (2.5 * var_x392 + 10.0 * var_x289);
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y1_gate__y1 = (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1) / (85.0 * exp(-0.095238095238095233 * var_chaste_interface__membrane__Vm) + 370.0 * exp(-0.016129032258064516 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 / (260.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 1450.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm)); // 1 / millisecond

        return d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y1_gate__y1;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x303 = exp(0.050000000000000003 * var_chaste_interface__membrane__Vm);
            const double var_x317 = 0.01 * var_chaste_interface__membrane__Vm;
            const double var_x318 = exp(var_x317);
            const double var_x395 = exp(-0.095238095238095233 * var_chaste_interface__membrane__Vm);
            const double var_x396 = exp(-0.016129032258064516 * var_chaste_interface__membrane__Vm);
            
            partialF = -1.0 / (260.0 * var_x318 + 1450.0 * var_x303) - 1.0 / (85.0 * var_x395 + 370.0 * var_x396);
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        
        
        // Mathematics
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2 = -0.004444 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 + 3.7000000000000002 * (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_internal_ion_concentrations__Cai; // 1 / millisecond

        return d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            
            partialF = 0.092459000000000013 - 1.8500000000000001 * var_x30 - 1.8500000000000001 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_transient_outward_current_y1_gate__y1 = (1.0 - var_chaste_interface__transient_outward_current_y1_gate__y1) / (11.0 * exp(-0.035714285714285712 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__transient_outward_current_y1_gate__y1 / (4.4000000000000004 * exp(0.0625 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(0.002 * var_chaste_interface__membrane__Vm)); // 1 / millisecond

        return d_dt_chaste_interface_var_transient_outward_current_y1_gate__y1;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x284 = exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x379 = 0.002 * var_chaste_interface__membrane__Vm;
            const double var_x385 = 0.035714285714285712 * var_chaste_interface__membrane__Vm;
            const double var_x397 = exp(-var_x385);
            const double var_x398 = exp(var_x379);
            const double var_x399 = exp(0.0625 * var_chaste_interface__membrane__Vm);
            
            partialF = -1.0 / (11.0 * var_x397 + 0.20000000000000001 * var_x284) - 1.0 / (4.4000000000000004 * var_x399 + 0.20000000000000001 * var_x398);
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_transient_outward_current_y2_gate__y2 = 0.0038 * (1.0 - var_chaste_interface__transient_outward_current_y2_gate__y2) * exp(-1.1946902654867255 - 0.088495575221238937 * var_chaste_interface__membrane__Vm) / (1.0 + 0.051334999999999999 * exp(-1.1946902654867255 - 0.088495575221238937 * var_chaste_interface__membrane__Vm)) - 0.0038 * var_chaste_interface__transient_outward_current_y2_gate__y2 * exp(1.1946902654867255 + 0.088495575221238937 * var_chaste_interface__membrane__Vm) / (1.0 + 0.067083000000000004 * exp(1.1946902654867255 + 0.088495575221238937 * var_chaste_interface__membrane__Vm)); // 1 / millisecond

        return d_dt_chaste_interface_var_transient_outward_current_y2_gate__y2;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            
            const double var_x400 = 0.088495575221238937 * var_chaste_interface__membrane__Vm;
            const double var_x401 = exp(-1.1946902654867255 - var_x400);
            const double var_x402 = 1.0 + 0.051334999999999999 * var_x401;
            const double var_x404 = exp(1.1946902654867255 + var_x400);
            const double var_x405 = 1.0 + 0.067083000000000004 * var_x404;
            const double var_x406 = var_x404 / var_x405;
            const double var_x407 = var_x401 / var_x402;
            
            partialF = -0.0038 * var_x406 - 0.0038 * var_x407;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        
        
        // Mathematics
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_sodium_calcium_exchanger__k1 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + 669.921875 * (1.0 + 724.63768115942037 * var_internal_ion_concentrations__Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y = (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * (0.20379327210477693 + 0.6399652192815608 * var_sodium_calcium_exchanger__k2) - (1 / (1.0 + 0.0013799999999999999 * (1.0 + 0.0014927113702623907 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)) / var_internal_ion_concentrations__Cai) + var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na) * var_chaste_interface__sodium_calcium_exchanger_y_gate__y; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
            // Units: millimolar; Initial value: 4.925761439682025
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            const double var_x31 = -0.026190000000000001 + 0.5 * var_x30 + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x39 = exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm);
            const double var_x41 = pow(var_chaste_interface__internal_ion_concentrations__Nai, 3);
            const double var_x42 = 1 / var_x41;
            const double var_x43 = -17.978260869565219 + 362.31884057971018 * var_x30 + 362.31884057971018 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x44 = var_x42 * var_x43;
            const double var_x45 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm);
            const double var_x46 = var_x45 / (1.0 + 669.921875 * var_x44);
            const double var_x262 = 1 / var_x31;
            const double var_x408 = 1.0 + 0.0014927113702623907 * var_x41;
            const double var_x409 = 1.0 + 0.0013799999999999999 * var_x262 * var_x408;
            
            partialF = -0.20379327210477693 - 1.0 * var_x46 - 1.0 / var_x409 - 0.6399652192815608 * var_x39;
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative27(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        
        
        // Mathematics
        const double var_sodium_potassium_pump__Nao_Eff = 140.0 * exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm); // millimolar
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + 0.094 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + 4.4045579125871104 * pow(1 / var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001) * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + 2804.9496956618664 * pow(1 / var_sodium_potassium_pump__Nao_Eff, 1.0600000000000001)); // dimensionless
        const double d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y = (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * (0.040000000000000001 * var_sodium_potassium_pump__p_E2Na + 0.16500000000000001 / (1.0331690520373935 + 0.00036833781854815162 * pow(var_sodium_potassium_pump__Nao_Eff, 1.0600000000000001))) - (0.01 / (1.0 + 49.999265664512095 * pow(1 / var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001) * (1.0 + 0.22703754152993499 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001))) + var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na) * var_chaste_interface__sodium_potassium_pump_y_gate__y; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative27(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
            // Units: millimolar; Initial value: 4.925761439682025
            double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
            // Units: millimolar; Initial value: 143.1837333000449
            double var_chaste_interface__ATP_production__ATPi = rY[4];
            // Units: millimolar; Initial value: 4.657102729020499
            
            const double var_x55 = 1 / var_chaste_interface__internal_ion_concentrations__Ki;
            const double var_x140 = exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm);
            const double var_x141 = pow(1 / var_x140, 1.0600000000000001);
            const double var_x160 = 1 / var_chaste_interface__internal_ion_concentrations__Nai;
            const double var_x161 = pow(var_x160, 1.0600000000000001);
            const double var_x162 = var_x161 * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001));
            const double var_x163 = 1 / var_chaste_interface__ATP_production__ATPi;
            const double var_x164 = 1.0 + 0.094 * var_x163;
            const double var_x165 = 1 / var_x164;
            const double var_x205 = 1 / (1.0 + 4.4045579125871104 * var_x162);
            const double var_x234 = 1 / (1.0 + 14.894617648090152 * var_x141);
            const double var_x235 = var_x165 * var_x205;
            const double var_x411 = pow(var_x140, 1.0600000000000001);
            const double var_x412 = pow(var_x55, 1.1200000000000001);
            const double var_x413 = var_x412 * (1.0 + 0.22703754152993499 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001));
            
            partialF = -0.37 * var_x235 - 0.01 / (1.0 + 49.999265664512095 * var_x413) - 0.040000000000000001 * var_x234 - 0.16500000000000001 / (1.0331690520373935 + 0.069365261764196454 * var_x411);
        }
        else
        {
            const double y_save = rY[27];
            rY[27] += delta;
            const double temp = EvaluateYDerivative27(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[27])/delta;
            rY[27] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative28(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__SR_calcium_pump_y_gate__y = rY[28];
        // Units: dimensionless; Initial value: 0.46108441538480216
        double var_chaste_interface__Ca_concentrations_in_SR__Caup = rY[32];
        // Units: millimolar; Initial value: 2.611712901567567
        
        
        // Mathematics
        const double var_SR_calcium_pump__k2 = 1 / (1.0 + 0.10000000000000001 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_SR_calcium_pump__p_E1Ca = 1 / (1.0 + 0.080000000000000002 / var_chaste_interface__Ca_concentrations_in_SR__Caup); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_SR_calcium_pump__p_E2Ca = 1 / (1.0 + 0.00080000000000000004 / var_internal_ion_concentrations__Cai); // dimensionless
        const double d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y = (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * (0.01 - 0.01 * var_SR_calcium_pump__p_E2Ca + var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca) - (1.0 - 0.98999999999999999 * var_SR_calcium_pump__p_E1Ca) * var_chaste_interface__SR_calcium_pump_y_gate__y; // 1 / millisecond

        return d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative28(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            double var_chaste_interface__ATP_production__ATPi = rY[4];
            // Units: millimolar; Initial value: 4.657102729020499
            double var_chaste_interface__Ca_concentrations_in_SR__Caup = rY[32];
            // Units: millimolar; Initial value: 2.611712901567567
            
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            const double var_x31 = -0.026190000000000001 + 0.5 * var_x30 + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x163 = 1 / var_chaste_interface__ATP_production__ATPi;
            const double var_x260 = 1.0 + 0.10000000000000001 * var_x163;
            const double var_x261 = 1 / var_x260;
            const double var_x262 = 1 / var_x31;
            const double var_x263 = 1.0 + 0.00080000000000000004 * var_x262;
            const double var_x270 = 1 / var_x263;
            const double var_x275 = 1.0 + 0.080000000000000002 / var_chaste_interface__Ca_concentrations_in_SR__Caup;
            const double var_x276 = 1 / var_x275;
            const double var_x277 = var_x261 * var_x270;
            
            partialF = -1.01 + 0.01 * var_x270 + 0.98999999999999999 * var_x276 - 1.0 * var_x277;
        }
        else
        {
            const double y_save = rY[28];
            rY[28] += delta;
            const double temp = EvaluateYDerivative28(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[28])/delta;
            rY[28] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative29(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__RyR_channel__p_open_RyR = rY[29];
        // Units: dimensionless; Initial value: 0.00034314360001543243
        double var_chaste_interface__RyR_channel__p_close_RyR = rY[30];
        // Units: dimensionless; Initial value: 0.19135178123107768
        double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rY[31];
        // Units: millimolar; Initial value: 9.455741736977666
        
        
        // Mathematics
        const double var_Ca_concentrations_in_SR__Carel = -5.4000000000000004 + 0.5 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + 5.4000000000000004 * sqrt(pow((1 - 0.092592592592592587 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total), 2) + 0.027434842249657067 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total); // millimolar
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-1.8) : (0.074870384603595908 * (-1.8 * exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm) + var_internal_ion_concentrations__Cai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__iCaL = 0.067599999999999993 * var_constant_field_equations__CF_Ca; // picoA
        const double var_RyR_channel__k1 = 280000.0 * pow(var_internal_ion_concentrations__Cai, 2) - 150.0 * var_L_type_Ca_channel__p_open_CaL * var_L_type_Ca_channel_Ca_dependent_gate__iCaL; // per_millisecond
        const double d_dt_chaste_interface_var_RyR_channel__p_open_RyR = var_RyR_channel__k1 * var_chaste_interface__RyR_channel__p_close_RyR - 0.080000000000000002 * var_chaste_interface__RyR_channel__p_open_RyR / (1.0 + 0.35999999999999999 / var_Ca_concentrations_in_SR__Carel); // 1 / millisecond

        return d_dt_chaste_interface_var_RyR_channel__p_open_RyR;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative29(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rY[31];
            // Units: millimolar; Initial value: 9.455741736977666
            
            const double var_x278 = 0.092592592592592587 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total;
            const double var_x279 = sqrt(pow((1 - var_x278), 2) + 0.027434842249657067 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total);
            const double var_x425 = 1.0 + 0.35999999999999999 / (-5.4000000000000004 + 0.5 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + 5.4000000000000004 * var_x279);
            
            partialF = -0.080000000000000002 / var_x425;
        }
        else
        {
            const double y_save = rY[29];
            rY[29] += delta;
            const double temp = EvaluateYDerivative29(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[29])/delta;
            rY[29] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative30(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__RyR_channel__p_open_RyR = rY[29];
        // Units: dimensionless; Initial value: 0.00034314360001543243
        double var_chaste_interface__RyR_channel__p_close_RyR = rY[30];
        // Units: dimensionless; Initial value: 0.19135178123107768
        double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rY[31];
        // Units: millimolar; Initial value: 9.455741736977666
        
        
        // Mathematics
        const double var_Ca_concentrations_in_SR__Carel = -5.4000000000000004 + 0.5 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + 5.4000000000000004 * sqrt(pow((1 - 0.092592592592592587 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total), 2) + 0.027434842249657067 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total); // millimolar
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-1.8) : (0.074870384603595908 * (-1.8 * exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm) + var_internal_ion_concentrations__Cai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__iCaL = 0.067599999999999993 * var_constant_field_equations__CF_Ca; // picoA
        const double var_RyR_channel__k1 = 280000.0 * pow(var_internal_ion_concentrations__Cai, 2) - 150.0 * var_L_type_Ca_channel__p_open_CaL * var_L_type_Ca_channel_Ca_dependent_gate__iCaL; // per_millisecond
        const double d_dt_chaste_interface_var_RyR_channel__p_close_RyR = -(0.00084900000000000004 + var_RyR_channel__k1) * var_chaste_interface__RyR_channel__p_close_RyR + 0.000377 * pow(var_Ca_concentrations_in_SR__Carel, 2) * (1.0 - var_chaste_interface__RyR_channel__p_close_RyR - var_chaste_interface__RyR_channel__p_open_RyR); // 1 / millisecond

        return d_dt_chaste_interface_var_RyR_channel__p_close_RyR;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative30(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.95752434460744
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            double var_chaste_interface__ATP_production__ATPi = rY[4];
            // Units: millimolar; Initial value: 4.657102729020499
            double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
            // Units: dimensionless; Initial value: 1.5445004166497696e-06
            double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
            // Units: dimensionless; Initial value: 0.17246483915629204
            double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
            // Units: dimensionless; Initial value: 6.098246017787626e-05
            double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
            // Units: dimensionless; Initial value: 0.9985266538252986
            double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rY[31];
            // Units: millimolar; Initial value: 9.455741736977666
            
            const double var_x19 = var_chaste_interface__membrane__Vm == 0;
            const double var_x26 = 0.074870384603595908 * var_chaste_interface__membrane__Vm;
            const double var_x27 = exp(-var_x26);
            const double var_x28 = 1.0 - var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            const double var_x31 = -0.026190000000000001 + 0.5 * var_x30 + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x32 = var_x31 - 1.8 * var_x27;
            const double var_x33 = var_x29 * var_x32;
            const double var_x48 = -0.052380000000000003 + var_x30 + var_chaste_interface__internal_ion_concentrations__Ca_Total;
            const double var_x145 = var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa;
            const double var_x146 = pow(var_chaste_interface__ATP_production__ATPi, (-3));
            const double var_x147 = 1 / (1.0 + 2.7439999999999993 * var_x146);
            const double var_x148 = var_x147 * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y;
            const double var_x149 = var_x145 * var_x148;
            const double var_x151 = var_x149 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
            const double var_x213 = ((var_x19) ? (-1.8) : (var_x26 * var_x33));
            const double var_x264 = pow(var_x48, 2);
            const double var_x278 = 0.092592592592592587 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total;
            const double var_x279 = sqrt(pow((1 - var_x278), 2) + 0.027434842249657067 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total);
            const double var_x419 = 10.139999999999999 * var_x213;
            const double var_x426 = 70000.0 * var_x264;
            const double var_x427 = var_x151 * var_x419;
            const double var_x428 = -1 + var_x278 + var_x279;
            const double var_x429 = pow(var_x428, 2);
            const double var_x430 = -0.010993320000000001 * var_x429;
            
            partialF = -0.00084900000000000004 + var_x427 + var_x430 - var_x426;
        }
        else
        {
            const double y_save = rY[30];
            rY[30] += delta;
            const double temp = EvaluateYDerivative30(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[30])/delta;
            rY[30] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative31(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__RyR_channel__p_open_RyR = rY[29];
        // Units: dimensionless; Initial value: 0.00034314360001543243
        double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rY[31];
        // Units: millimolar; Initial value: 9.455741736977666
        double var_chaste_interface__Ca_concentrations_in_SR__Caup = rY[32];
        // Units: millimolar; Initial value: 2.611712901567567
        
        
        // Mathematics
        const double var_Ca_concentrations_in_SR__Carel = -5.4000000000000004 + 0.5 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + 5.4000000000000004 * sqrt(pow((1 - 0.092592592592592587 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total), 2) + 0.027434842249657067 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total); // millimolar
        const double var_SR_T_current__i_SR_T = 386.0 * var_chaste_interface__Ca_concentrations_in_SR__Caup - 386.0 * var_Ca_concentrations_in_SR__Carel; // picoA
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_RyR_channel__i_RyR = 62000.0 * (-var_internal_ion_concentrations__Cai + var_Ca_concentrations_in_SR__Carel) * var_chaste_interface__RyR_channel__p_open_RyR; // picoA
        const double d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total = 3.2387883511406234e-5 * var_SR_T_current__i_SR_T - 3.2387883511406234e-5 * var_RyR_channel__i_RyR; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative31(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__RyR_channel__p_open_RyR = rY[29];
            // Units: dimensionless; Initial value: 0.00034314360001543243
            double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rY[31];
            // Units: millimolar; Initial value: 9.455741736977666
            
            const double var_x278 = 0.092592592592592587 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total;
            const double var_x279 = sqrt(pow((1 - var_x278), 2) + 0.027434842249657067 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total);
            const double var_x280 = (-0.078875171467764058 + 0.0085733882030178329 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total) / var_x279;
            
            partialF = -0.0062508615177014034 - 0.067509304391175154 * var_x280 + (-1.0040243888535934 - 10.843463399618807 * var_x280) * var_chaste_interface__RyR_channel__p_open_RyR;
        }
        else
        {
            const double y_save = rY[31];
            rY[31] += delta;
            const double temp = EvaluateYDerivative31(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[31])/delta;
            rY[31] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative32(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__SR_calcium_pump_y_gate__y = rY[28];
        // Units: dimensionless; Initial value: 0.46108441538480216
        double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rY[31];
        // Units: millimolar; Initial value: 9.455741736977666
        double var_chaste_interface__Ca_concentrations_in_SR__Caup = rY[32];
        // Units: millimolar; Initial value: 2.611712901567567
        
        
        // Mathematics
        const double var_Ca_concentrations_in_SR__Carel = -5.4000000000000004 + 0.5 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + 5.4000000000000004 * sqrt(pow((1 - 0.092592592592592587 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total), 2) + 0.027434842249657067 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total); // millimolar
        const double var_SR_T_current__i_SR_T = 386.0 * var_chaste_interface__Ca_concentrations_in_SR__Caup - 386.0 * var_Ca_concentrations_in_SR__Carel; // picoA
        const double var_SR_calcium_pump__k2 = 1 / (1.0 + 0.10000000000000001 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_SR_calcium_pump__p_E1Ca = 1 / (1.0 + 0.080000000000000002 / var_chaste_interface__Ca_concentrations_in_SR__Caup); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_SR_L_current__i_SR_L = 459.0 * var_chaste_interface__Ca_concentrations_in_SR__Caup - 459.0 * var_internal_ion_concentrations__Cai; // picoA
        const double var_SR_calcium_pump__p_E2Ca = 1 / (1.0 + 0.00080000000000000004 / var_internal_ion_concentrations__Cai); // dimensionless
        const double var_SR_calcium_pump__i_SR_U = 1625.0 * var_SR_calcium_pump__p_E1Ca * var_chaste_interface__SR_calcium_pump_y_gate__y - 162500.0 * (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca; // picoA
        const double d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup = -1.2955153404562494e-5 * var_SR_L_current__i_SR_L - 1.2955153404562494e-5 * var_SR_T_current__i_SR_T - 1.2955153404562494e-5 * var_SR_calcium_pump__i_SR_U; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative32(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__SR_calcium_pump_y_gate__y = rY[28];
            // Units: dimensionless; Initial value: 0.46108441538480216
            double var_chaste_interface__Ca_concentrations_in_SR__Caup = rY[32];
            // Units: millimolar; Initial value: 2.611712901567567
            
            const double var_x275 = 1.0 + 0.080000000000000002 / var_chaste_interface__Ca_concentrations_in_SR__Caup;
            const double var_x281 = var_chaste_interface__SR_calcium_pump_y_gate__y / (pow(var_x275, 2) * pow(var_chaste_interface__Ca_concentrations_in_SR__Caup, 2));
            
            partialF = -0.010947104626855308 - 0.0016841699425931243 * var_x281;
        }
        else
        {
            const double y_save = rY[32];
            rY[32] += delta;
            const double temp = EvaluateYDerivative32(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[32])/delta;
            rY[32] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative33(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__NL_model__pCa = rY[33];
        // Units: dimensionless; Initial value: 0.02490898775497523
        double var_chaste_interface__NL_model__pCaCB = rY[34];
        // Units: dimensionless; Initial value: 0.001990153835322864
        double var_chaste_interface__NL_model__pCB = rY[35];
        // Units: dimensionless; Initial value: 0.00042941813853474524
        
        
        // Mathematics
        const double var_NL_model__Q_a = -0.0038999999999999998 * var_chaste_interface__NL_model__pCaCB + 0.0038999999999999998 * var_chaste_interface__NL_model__pCa * exp(-0.86212130841993795); // per_millisecond
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_NL_model__Q_b = -0.029999999999999999 * var_chaste_interface__NL_model__pCa + 39.0 * (1.0 - var_chaste_interface__NL_model__pCB - var_chaste_interface__NL_model__pCa - var_chaste_interface__NL_model__pCaCB) * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCa = -var_NL_model__Q_a + var_NL_model__Q_b; // 1 / millisecond

        return d_dt_chaste_interface_var_NL_model__pCa;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative33(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            const double var_x431 = 0.0038999999999999998 * exp(-0.86212130841993795);
            const double var_x432 = -19.5 * var_x30 - 19.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            
            partialF = 0.99141000000000001 + var_x432 - var_x431;
        }
        else
        {
            const double y_save = rY[33];
            rY[33] += delta;
            const double temp = EvaluateYDerivative33(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[33])/delta;
            rY[33] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative34(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__NL_model__pCa = rY[33];
        // Units: dimensionless; Initial value: 0.02490898775497523
        double var_chaste_interface__NL_model__pCaCB = rY[34];
        // Units: dimensionless; Initial value: 0.001990153835322864
        double var_chaste_interface__NL_model__pCB = rY[35];
        // Units: dimensionless; Initial value: 0.00042941813853474524
        double var_chaste_interface__NL_model__X = rY[36];
        // Units: micrometre; Initial value: 0.9573749975411884
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_NL_model__X = 1.1488559970494261 - 1.2 * var_chaste_interface__NL_model__X; // micrometre / millisecond
        const double var_NL_model__Q_a = -0.0038999999999999998 * var_chaste_interface__NL_model__pCaCB + 0.0038999999999999998 * var_chaste_interface__NL_model__pCa * exp(-0.86212130841993795); // per_millisecond
        const double var_NL_model__Q_d2 = 0.027 * pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_chaste_interface__NL_model__pCaCB; // per_millisecond
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_NL_model__Q_r = 0.029999999999999999 * var_chaste_interface__NL_model__pCaCB - 1560.0 * var_chaste_interface__NL_model__pCB * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCaCB = -var_NL_model__Q_d2 - var_NL_model__Q_r + var_NL_model__Q_a; // 1 / millisecond

        return d_dt_chaste_interface_var_NL_model__pCaCB;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative34(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__NL_model__X = rY[36];
            // Units: micrometre; Initial value: 0.9573749975411884
            
            const double var_x283 = pow((0.95737999754118841 - var_chaste_interface__NL_model__X), 2);
            const double var_x434 = -0.038879999999999998 * var_x283;
            
            partialF = -0.0339 + var_x434;
        }
        else
        {
            const double y_save = rY[34];
            rY[34] += delta;
            const double temp = EvaluateYDerivative34(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[34])/delta;
            rY[34] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative35(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__NL_model__pCaCB = rY[34];
        // Units: dimensionless; Initial value: 0.001990153835322864
        double var_chaste_interface__NL_model__pCB = rY[35];
        // Units: dimensionless; Initial value: 0.00042941813853474524
        double var_chaste_interface__NL_model__X = rY[36];
        // Units: micrometre; Initial value: 0.9573749975411884
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_NL_model__X = 1.1488559970494261 - 1.2 * var_chaste_interface__NL_model__X; // micrometre / millisecond
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_NL_model__Q_r = 0.029999999999999999 * var_chaste_interface__NL_model__pCaCB - 1560.0 * var_chaste_interface__NL_model__pCB * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCB = -0.12 * var_chaste_interface__NL_model__pCB - 0.027 * pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_chaste_interface__NL_model__pCB + var_NL_model__Q_r; // 1 / millisecond

        return d_dt_chaste_interface_var_NL_model__pCB;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative35(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
            // Units: millimolar; Initial value: 0.00040180173572968586
            double var_chaste_interface__NL_model__X = rY[36];
            // Units: micrometre; Initial value: 0.9573749975411884
            
            const double var_x30 = sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total);
            const double var_x283 = pow((0.95737999754118841 - var_chaste_interface__NL_model__X), 2);
            const double var_x434 = -0.038879999999999998 * var_x283;
            const double var_x435 = 780.0 * var_x30;
            const double var_x436 = 780.0 * var_chaste_interface__internal_ion_concentrations__Ca_Total;
            
            partialF = 40.736400000000003 + var_x434 - var_x435 - var_x436;
        }
        else
        {
            const double y_save = rY[35];
            rY[35] += delta;
            const double temp = EvaluateYDerivative35(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[35])/delta;
            rY[35] = y_save;
        }
        return partialF;
    }
    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluateYDerivative36(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__NL_model__X = rY[36];
        // Units: micrometre; Initial value: 0.9573749975411884
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_NL_model__X = 1.1488559970494261 - 1.2 * var_chaste_interface__NL_model__X; // micrometre / millisecond

        return d_dt_chaste_interface_var_NL_model__X;
    }

    double Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::EvaluatePartialDerivative36(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -1.2;
        }
        else
        {
            const double y_save = rY[36];
            rY[36] += delta;
            const double temp = EvaluateYDerivative36(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[36])/delta;
            rY[36] = y_save;
        }
        return partialF;
    }

    std::vector<double> Dynamicmatsuoka_model_2003FromCellMLGRL1Opt::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        

        // Mathematics
        const double var_internal_ion_concentrations__CMDN_max = 0.050000000000000003; // millimolar
        const double var_internal_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_internal_ion_concentrations__b1 = -var_chaste_interface__internal_ion_concentrations__Ca_Total + var_internal_ion_concentrations__CMDN_max + var_internal_ion_concentrations__K_mCMDN; // millimolar
        const double var_internal_ion_concentrations__c1 = var_chaste_interface__internal_ion_concentrations__Ca_Total * var_internal_ion_concentrations__K_mCMDN; // millimolar2
        const double var_internal_ion_concentrations__Cai = sqrt(0.25 * pow(var_internal_ion_concentrations__b1, 2) + var_internal_ion_concentrations__c1) - 0.5 * var_internal_ion_concentrations__b1; // millimolar
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF
        const double var_membrane__i_ext_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(4);
        dqs[0] = var_internal_ion_concentrations__Cai;
        dqs[1] = var_chaste_interface__environment__time;
        dqs[2] = var_membrane__Cm_converted;
        dqs[3] = var_membrane__i_ext_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Dynamicmatsuoka_model_2003FromCellMLGRL1Opt>::Initialise(void)
{
    this->mSystemName = "matsuoka_model_2003";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-85.95752434460744);

    // rY[1]:
    this->mVariableNames.push_back("internal_ion_concentrations__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(4.925761439682025);

    // rY[2]:
    this->mVariableNames.push_back("internal_ion_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(143.1837333000449);

    // rY[3]:
    this->mVariableNames.push_back("internal_ion_concentrations__Ca_Total");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00040180173572968586);

    // rY[4]:
    this->mVariableNames.push_back("ATP_production__ATPi");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(4.657102729020499);

    // rY[5]:
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_AP_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.779648367445368e-05);

    // rY[6]:
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_RP_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3556412697995689);

    // rY[7]:
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_AI_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.40285968661346977);

    // rY[8]:
    this->mVariableNames.push_back("sodium_current_ultra_slow_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5861887862983165);

    // rY[9]:
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.5445004166497696e-06);

    // rY[10]:
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9968480629364956);

    // rY[11]:
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000877325391245903);

    // rY[12]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_U");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.17246483915629204);

    // rY[13]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_UCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.098246017787626e-05);

    // rY[14]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4250747299372254);

    // rY[15]:
    this->mVariableNames.push_back("L_type_Ca_channel_ultra_slow_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9985266538252986);

    // rY[16]:
    this->mVariableNames.push_back("T_type_Ca_channel_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.6882718240109127e-05);

    // rY[17]:
    this->mVariableNames.push_back("T_type_Ca_channel_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8585352091865849);

    // rY[18]:
    this->mVariableNames.push_back("time_independent_potassium_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6080573900752752);

    // rY[19]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0018339931180983765);

    // rY[20]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.20443083454225305);

    // rY[21]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y3_gate__y3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.967887666264921);

    // rY[22]:
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09738789658609195);

    // rY[23]:
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09745345578743213);

    // rY[24]:
    this->mVariableNames.push_back("transient_outward_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0007956883250874798);

    // rY[25]:
    this->mVariableNames.push_back("transient_outward_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999125083105881);

    // rY[26]:
    this->mVariableNames.push_back("sodium_calcium_exchanger_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9891789193465331);

    // rY[27]:
    this->mVariableNames.push_back("sodium_potassium_pump_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5910747147428818);

    // rY[28]:
    this->mVariableNames.push_back("SR_calcium_pump_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.46108441538480216);

    // rY[29]:
    this->mVariableNames.push_back("RyR_channel__p_open_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00034314360001543243);

    // rY[30]:
    this->mVariableNames.push_back("RyR_channel__p_close_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.19135178123107768);

    // rY[31]:
    this->mVariableNames.push_back("Ca_concentrations_in_SR__Ca_Total");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.455741736977666);

    // rY[32]:
    this->mVariableNames.push_back("Ca_concentrations_in_SR__Caup");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.611712901567567);

    // rY[33]:
    this->mVariableNames.push_back("NL_model__pCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02490898775497523);

    // rY[34]:
    this->mVariableNames.push_back("NL_model__pCaCB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001990153835322864);

    // rY[35]:
    this->mVariableNames.push_back("NL_model__pCB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00042941813853474524);

    // rY[36]:
    this->mVariableNames.push_back("NL_model__X");
    this->mVariableUnits.push_back("micrometre");
    this->mInitialConditions.push_back(0.9573749975411884);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("picoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("cytosolic_calcium_concentration");
    this->mDerivedQuantityUnits.push_back("millimolar");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    // Derived Quantity index [3]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Dynamicmatsuoka_model_2003FromCellMLGRL1Opt)
extern "C"
{
    AbstractCardiacCellInterface* MakeCardiacCell(
            boost::shared_ptr<AbstractIvpOdeSolver> pSolver,
            boost::shared_ptr<AbstractStimulusFunction> pStimulus)
    {
        return new Dynamicmatsuoka_model_2003FromCellMLGRL1Opt(pSolver, pStimulus);
    }

}