//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: winslow_model_1999
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "winslow_model_1999.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellwinslow_model_1999FromCellMLRushLarsenOpt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -21.126799999999999 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 2.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellwinslow_model_1999FromCellMLRushLarsenOpt::Cellwinslow_model_1999FromCellMLRushLarsenOpt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractRushLarsenCardiacCell(
                33,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellwinslow_model_1999FromCellMLRushLarsenOpt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
    }

    Cellwinslow_model_1999FromCellMLRushLarsenOpt::~Cellwinslow_model_1999FromCellMLRushLarsenOpt()
    {
    }
    
    double Cellwinslow_model_1999FromCellMLRushLarsenOpt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -96.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr = rY[4];
        // Units: dimensionless; Initial value: 0.51
        double var_chaste_interface__slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks = rY[5];
        // Units: dimensionless; Initial value: 0.264
        double var_chaste_interface__transient_outward_potassium_current_X_to1_gate__X_to1 = rY[6];
        // Units: dimensionless; Initial value: 2.63
        double var_chaste_interface__transient_outward_potassium_current_Y_to1_gate__Y_to1 = rY[7];
        // Units: dimensionless; Initial value: 0.99
        double var_chaste_interface__L_type_Ca_current__O = rY[8];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_current__O_Ca = rY[9];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_current_y_gate__y = rY[20];
        // Units: dimensionless; Initial value: 0.798
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[27];
        // Units: millimolar; Initial value: 10.0
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[28];
        // Units: millimolar; Initial value: 8e-05
        double var_chaste_interface__intracellular_ion_concentrations__Ki = rY[29];
        // Units: millimolar; Initial value: 157.8
        
        const double var_sarcolemmal_calcium_pump__i_p_Ca = 0.050000000000000003 * var_chaste_interface__intracellular_ion_concentrations__Cai / (5.0000000000000002e-5 + var_chaste_interface__intracellular_ion_concentrations__Cai); // microA_per_microF
        const double var_L_type_Ca_current__i_Ca_max = 4.5147771746328917 * (-0.68200000000000005 + 0.001 * exp(0.074867781645490947 * var_chaste_interface__membrane__V)) * var_chaste_interface__membrane__V / (-1.0 + exp(0.074867781645490947 * var_chaste_interface__membrane__V)); // microA_per_microF
        const double var_L_type_Ca_current__i_Ca = (var_chaste_interface__L_type_Ca_current__O + var_chaste_interface__L_type_Ca_current__O_Ca) * var_L_type_Ca_current__i_Ca_max * var_chaste_interface__L_type_Ca_current_y_gate__y; // microA_per_microF
        const double var_calcium_background_current__i_Ca_b = 0.00038420000000000001 * var_chaste_interface__membrane__V - 0.005131713422727534 * log(2.0 / var_chaste_interface__intracellular_ion_concentrations__Cai); // microA_per_microF
        const double var_L_type_Ca_current__i_Ca_K = 2.0912447872899554e-6 * (-4.0 + var_chaste_interface__intracellular_ion_concentrations__Ki * exp(0.037433890822745473 * var_chaste_interface__membrane__V)) * (var_chaste_interface__L_type_Ca_current__O + var_chaste_interface__L_type_Ca_current__O_Ca) * var_chaste_interface__L_type_Ca_current_y_gate__y * var_chaste_interface__membrane__V / ((1.0 - 3.773584905660377 * var_L_type_Ca_current__i_Ca_max) * (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V))); // microA_per_microF
        const double var_rapid_activating_delayed_rectifiyer_K_current__E_K = 26.713760659695648 * log(4.0 / var_chaste_interface__intracellular_ion_concentrations__Ki); // millivolt
        const double var_plateau_potassium_current__i_Kp = 0.0022160000000000001 * (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // microA_per_microF
        const double var_rapid_activating_delayed_rectifiyer_K_current__i_Kr = 0.0033999999999999998 * (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr / (1.0 + 1.4944999999999999 * exp(0.044600000000000001 * var_chaste_interface__membrane__V)); // microA_per_microF
        const double var_Na_Ca_exchanger__i_NaCa = 0.00013456270662374128 * (2.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3) * exp(0.013101861787960915 * var_chaste_interface__membrane__V) - 2628072.0 * var_chaste_interface__intracellular_ion_concentrations__Cai * exp(-0.024332029034784559 * var_chaste_interface__membrane__V)) / (1.0 + 0.20000000000000001 * exp(-0.024332029034784559 * var_chaste_interface__membrane__V)); // microA_per_microF
        const double var_fast_sodium_current__E_Na = 26.713760659695648 * log(138.0 / var_chaste_interface__intracellular_ion_concentrations__Nai); // millivolt
        const double var_fast_sodium_current__i_Na = 12.800000000000001 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // microA_per_microF
        const double var_slow_activating_delayed_rectifiyer_K_current__i_Ks = 0.0027133999999999999 * pow(var_chaste_interface__slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks, 2) * (-26.713760659695648 * log(6.5295399999999999 / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.018329999999999999 * var_chaste_interface__intracellular_ion_concentrations__Nai)) + var_chaste_interface__membrane__V); // microA_per_microF
        const double var_sodium_background_current__i_Na_b = 0.0030999999999999999 * var_chaste_interface__membrane__V - 0.0030999999999999999 * var_fast_sodium_current__E_Na; // microA_per_microF
        const double var_sodium_potassium_pump__i_NaK = 0.504 / ((1.0 + 31.622776601683793 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Nai, 1.5)) * (1.0 + 0.1245 * exp(-0.0037433890822745476 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0505200594353643)) * exp(-0.037433890822745473 * var_chaste_interface__membrane__V))); // microA_per_microF
        const double var_time_independent_potassium_current__i_K1 = 0.6588235294117647 * (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) / (2.0 + exp(0.056150836234118207 * var_chaste_interface__membrane__V - 0.056150836234118207 * var_rapid_activating_delayed_rectifiyer_K_current__E_K)); // microA_per_microF
        const double var_transient_outward_potassium_current__i_to1 = 0.23815 * (-var_rapid_activating_delayed_rectifiyer_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__transient_outward_potassium_current_X_to1_gate__X_to1 * var_chaste_interface__transient_outward_potassium_current_Y_to1_gate__Y_to1; // microA_per_microF
        const double var_chaste_interface__i_ionic = (var_L_type_Ca_current__i_Ca + var_L_type_Ca_current__i_Ca_K + var_Na_Ca_exchanger__i_NaCa + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_plateau_potassium_current__i_Kp + var_rapid_activating_delayed_rectifiyer_K_current__i_Kr + var_sarcolemmal_calcium_pump__i_p_Ca + var_slow_activating_delayed_rectifiyer_K_current__i_Ks + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_potassium_current__i_to1) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellwinslow_model_1999FromCellMLRushLarsenOpt::EvaluateEquations(double var_chaste_interface__environment__time_converted, std::vector<double> &rDY, std::vector<double> &rAlphaOrTau, std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -96.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr = rY[4];
        // Units: dimensionless; Initial value: 0.51
        double var_chaste_interface__slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks = rY[5];
        // Units: dimensionless; Initial value: 0.264
        double var_chaste_interface__transient_outward_potassium_current_X_to1_gate__X_to1 = rY[6];
        // Units: dimensionless; Initial value: 2.63
        double var_chaste_interface__transient_outward_potassium_current_Y_to1_gate__Y_to1 = rY[7];
        // Units: dimensionless; Initial value: 0.99
        double var_chaste_interface__L_type_Ca_current__O = rY[8];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_current__O_Ca = rY[9];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_current__C0 = rY[10];
        // Units: dimensionless; Initial value: 0.997208
        double var_chaste_interface__L_type_Ca_current__C1 = rY[11];
        // Units: dimensionless; Initial value: 6.38897e-05
        double var_chaste_interface__L_type_Ca_current__C2 = rY[12];
        // Units: dimensionless; Initial value: 1.535e-09
        double var_chaste_interface__L_type_Ca_current__C3 = rY[13];
        // Units: dimensionless; Initial value: 1.63909e-14
        double var_chaste_interface__L_type_Ca_current__C4 = rY[14];
        // Units: dimensionless; Initial value: 6.56337e-20
        double var_chaste_interface__L_type_Ca_current__C_Ca0 = rY[15];
        // Units: dimensionless; Initial value: 0.00272826
        double var_chaste_interface__L_type_Ca_current__C_Ca1 = rY[16];
        // Units: dimensionless; Initial value: 6.99215e-07
        double var_chaste_interface__L_type_Ca_current__C_Ca2 = rY[17];
        // Units: dimensionless; Initial value: 6.71989e-11
        double var_chaste_interface__L_type_Ca_current__C_Ca3 = rY[18];
        // Units: dimensionless; Initial value: 2.87031e-15
        double var_chaste_interface__L_type_Ca_current__C_Ca4 = rY[19];
        // Units: dimensionless; Initial value: 4.59752e-20
        double var_chaste_interface__L_type_Ca_current_y_gate__y = rY[20];
        // Units: dimensionless; Initial value: 0.798
        double var_chaste_interface__RyR_channel__P_O1 = rY[21];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__RyR_channel__P_O2 = rY[22];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__RyR_channel__P_C1 = rY[23];
        // Units: dimensionless; Initial value: 0.47
        double var_chaste_interface__RyR_channel__P_C2 = rY[24];
        // Units: dimensionless; Initial value: 0.53
        double var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa = rY[25];
        // Units: millimolar; Initial value: 0.98
        double var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa = rY[26];
        // Units: millimolar; Initial value: 0.078
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[27];
        // Units: millimolar; Initial value: 10.0
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[28];
        // Units: millimolar; Initial value: 8e-05
        double var_chaste_interface__intracellular_ion_concentrations__Ki = rY[29];
        // Units: millimolar; Initial value: 157.8
        double var_chaste_interface__intracellular_ion_concentrations__Ca_ss = rY[30];
        // Units: millimolar; Initial value: 0.00011
        double var_chaste_interface__intracellular_ion_concentrations__Ca_JSR = rY[31];
        // Units: millimolar; Initial value: 0.257
        double var_chaste_interface__intracellular_ion_concentrations__Ca_NSR = rY[32];
        // Units: millimolar; Initial value: 0.257

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double d_dt_chaste_interface_var_L_type_Ca_current__O = 0.29999999999999999 * var_chaste_interface__L_type_Ca_current__C4 - 2.0 * var_chaste_interface__L_type_Ca_current__O; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current__O_Ca = 0.0070000000000000001 * var_chaste_interface__L_type_Ca_current__C_Ca4 - 7.0 * var_chaste_interface__L_type_Ca_current__O_Ca; // 1 / millisecond
        const double d_dt_chaste_interface_var_RyR_channel__P_C2 = 0.10000000000000001 * var_chaste_interface__RyR_channel__P_O1 - 0.00080000000000000004 * var_chaste_interface__RyR_channel__P_C2; // 1 / millisecond
        const double d_dt_chaste_interface_var_RyR_channel__P_C1 = 0.57599999999999996 * var_chaste_interface__RyR_channel__P_O1 - 12150000000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 4.0) * var_chaste_interface__RyR_channel__P_C1; // 1 / millisecond
        const double d_dt_chaste_interface_var_RyR_channel__P_O1 = 0.00080000000000000004 * var_chaste_interface__RyR_channel__P_C2 + 1.9299999999999999 * var_chaste_interface__RyR_channel__P_O2 - 0.67600000000000005 * var_chaste_interface__RyR_channel__P_O1 + 12150000000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 4.0) * var_chaste_interface__RyR_channel__P_C1 - 4050000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 3.0) * var_chaste_interface__RyR_channel__P_O1; // 1 / millisecond
        const double d_dt_chaste_interface_var_RyR_channel__P_O2 = -1.9299999999999999 * var_chaste_interface__RyR_channel__P_O2 + 4050000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 3.0) * var_chaste_interface__RyR_channel__P_O1; // 1 / millisecond
        const double d_dt_chaste_interface_var_intracellular_Ca_fluxes__HTRPNCa = -6.6000000000000005e-5 * var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa + 20.0 * (1.0 - var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_Ca_fluxes__LTRPNCa = -0.040000000000000001 * var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa + 40.0 * (1.0 - var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ki = 0; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Nai = 0; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_NSR = 0.13257434520702313 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR - 0.13257434520702313 * var_chaste_interface__intracellular_ion_concentrations__Ca_NSR + 0.012304761904761905 * (2752.4498037978587 * pow(var_chaste_interface__intracellular_ion_concentrations__Cai, 1.2) - 0.096656534954407292 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_NSR, 1.0)) / (1.0 + 33855.471141425078 * pow(var_chaste_interface__intracellular_ion_concentrations__Cai, 1.2) + 0.303951367781155 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_NSR, 1.0)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_JSR = 0.001 * (1740.0382808421784 * var_chaste_interface__intracellular_ion_concentrations__Ca_NSR - 1740.0382808421784 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR - 1800.0 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) * (var_chaste_interface__RyR_channel__P_O1 + var_chaste_interface__RyR_channel__P_O2)) / (1.0 + 12.0 / pow((0.80000000000000004 + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR), 2)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current__C0 = 0.01 * var_chaste_interface__L_type_Ca_current__C_Ca0 + 0.050000000000000003 * var_chaste_interface__L_type_Ca_current__C1 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) - 0.001 * (1600.0 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 103.75 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss) * var_chaste_interface__L_type_Ca_current__C0; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current__C1 = 0.0050000000000000001 * var_chaste_interface__L_type_Ca_current__C_Ca1 + 0.10000000000000001 * var_chaste_interface__L_type_Ca_current__C2 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 1.6000000000000001 * var_chaste_interface__L_type_Ca_current__C0 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) - 0.001 * (50.0 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 1200.0 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 207.5 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss) * var_chaste_interface__L_type_Ca_current__C1; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current__C2 = 0.0025000000000000001 * var_chaste_interface__L_type_Ca_current__C_Ca2 + 0.14999999999999999 * var_chaste_interface__L_type_Ca_current__C3 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 1.2 * var_chaste_interface__L_type_Ca_current__C1 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) - 0.001 * (100.0 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 800.0 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 415.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss) * var_chaste_interface__L_type_Ca_current__C2; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current__C3 = 0.00125 * var_chaste_interface__L_type_Ca_current__C_Ca3 + 0.20000000000000001 * var_chaste_interface__L_type_Ca_current__C4 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 0.80000000000000004 * var_chaste_interface__L_type_Ca_current__C2 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) - 0.001 * (400.0 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 150.0 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 830.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss) * var_chaste_interface__L_type_Ca_current__C3; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current__C4 = 2.0 * var_chaste_interface__L_type_Ca_current__O + 0.00062500000000000001 * var_chaste_interface__L_type_Ca_current__C_Ca4 + 0.40000000000000002 * var_chaste_interface__L_type_Ca_current__C3 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) - 0.001 * (300.0 + 200.0 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 1660.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss) * var_chaste_interface__L_type_Ca_current__C4; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current__C_Ca0 = 0.025000000000000001 * var_chaste_interface__L_type_Ca_current__C_Ca1 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 0.10375 * var_chaste_interface__L_type_Ca_current__C0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 0.001 * (10.0 + 3200.0 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V)) * var_chaste_interface__L_type_Ca_current__C_Ca0; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current__C_Ca1 = 0.050000000000000003 * var_chaste_interface__L_type_Ca_current__C_Ca2 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 3.2000000000000002 * var_chaste_interface__L_type_Ca_current__C_Ca0 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 0.20749999999999999 * var_chaste_interface__L_type_Ca_current__C1 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 0.001 * (5.0 + 25.0 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 2400.0 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V)) * var_chaste_interface__L_type_Ca_current__C_Ca1; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current__C_Ca2 = 0.074999999999999997 * var_chaste_interface__L_type_Ca_current__C_Ca3 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 2.3999999999999999 * var_chaste_interface__L_type_Ca_current__C_Ca1 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 0.41499999999999998 * var_chaste_interface__L_type_Ca_current__C2 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 0.001 * (2.5 + 50.0 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 1600.0 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V)) * var_chaste_interface__L_type_Ca_current__C_Ca2; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current__C_Ca3 = 0.10000000000000001 * var_chaste_interface__L_type_Ca_current__C_Ca4 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 1.6000000000000001 * var_chaste_interface__L_type_Ca_current__C_Ca2 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 0.82999999999999996 * var_chaste_interface__L_type_Ca_current__C3 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 0.001 * (1.25 + 800.0 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 75.0 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V)) * var_chaste_interface__L_type_Ca_current__C_Ca3; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current__C_Ca4 = 7.0 * var_chaste_interface__L_type_Ca_current__O_Ca + 0.80000000000000004 * var_chaste_interface__L_type_Ca_current__C_Ca3 * exp(0.20000000000000001 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 1.6599999999999999 * var_chaste_interface__L_type_Ca_current__C4 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 0.001 * (7.625 + 100.0 * exp(-0.15384615384615385 - 0.076923076923076927 * var_chaste_interface__membrane__V)) * var_chaste_interface__L_type_Ca_current__C_Ca4; // 1 / millisecond
        const double var_L_type_Ca_current_y_gate__tau_y = 0.02 + 0.59999999999999998 / (1.0 + exp(2.1052631578947367 + 0.10526315789473684 * var_chaste_interface__membrane__V)); // second
        const double var_L_type_Ca_current_y_gate__y_infinity = 0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(2.5 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (135.0 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0)); // per_second
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (3560.0 * exp(0.079000000000000001 * var_chaste_interface__membrane__V) + 310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V)) : (7692.3076923076924 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)))); // per_second
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? (1000.0 * (37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))) : (0)); // per_second
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (121.2 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (300.0 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)))); // per_second
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * (((var_chaste_interface__membrane__V >= -90.0) && (fabs(47.130000000000003 + var_chaste_interface__membrane__V) < 1.0000000000000001e-5)) ? (1000.0 * (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) / (-0.13565000000000002 - 0.0050000000000000001 * var_chaste_interface__membrane__V) - 80.0 * var_chaste_interface__fast_sodium_current_m_gate__m * exp(-0.090909090909090912 * var_chaste_interface__membrane__V)) : ((var_chaste_interface__membrane__V >= -90.0) ? (-80.0 * var_chaste_interface__fast_sodium_current_m_gate__m * exp(-0.090909090909090912 * var_chaste_interface__membrane__V) + 320.0 * (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * (47.130000000000003 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__V))) : (0))); // 1 / millisecond
        const double var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr_inf = exp(-5.4950000000000001 + 0.1691 * var_chaste_interface__membrane__V) / (exp(-7.6769999999999996 - 0.012800000000000001 * var_chaste_interface__membrane__V) + exp(-5.4950000000000001 + 0.1691 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__tau_X_kr = 0.027 + 0.001 / (exp(-7.6769999999999996 - 0.012800000000000001 * var_chaste_interface__membrane__V) + exp(-5.4950000000000001 + 0.1691 * var_chaste_interface__membrane__V)); // second
        const double var_slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks_infinity = 1 / (1.0 + exp(1.8161764705882353 - 0.073529411764705885 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_activating_delayed_rectifiyer_K_current_X_ks_gate__tau_X_ks = 0.001 / (0.00013100000000000001 * (-10.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-0.68699999999999994 + 0.068699999999999997 * var_chaste_interface__membrane__V)) + 7.1899999999999999e-5 * (-10.0 + var_chaste_interface__membrane__V) / (1.0 - exp(1.48 - 0.14799999999999999 * var_chaste_interface__membrane__V))); // second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_ss = 0.001 * (806491.88514357049 * var_chaste_interface__intracellular_ion_concentrations__Cai - 806491.88514357049 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss + 240000.0 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) * (var_chaste_interface__RyR_channel__P_O1 + var_chaste_interface__RyR_channel__P_O2) - 2990.8119021922685 * (-0.68200000000000005 + 0.001 * exp(0.074867781645490947 * var_chaste_interface__membrane__V)) * (var_chaste_interface__L_type_Ca_current__O + var_chaste_interface__L_type_Ca_current__O_Ca) * var_chaste_interface__L_type_Ca_current_y_gate__y * var_chaste_interface__membrane__V / (-1.0 + exp(0.074867781645490947 * var_chaste_interface__membrane__V))) / (1.0 + 0.00011900000000000002 / pow((0.0023800000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_ss), 2)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Cai = 0.001 * (2.8000000000000003 * var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa + 37.453183520599246 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss + 0.0092400000000000017 * var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa + 0.00015787156411954756 * log(2.0 / var_chaste_interface__intracellular_ion_concentrations__Cai) - 37.453183520599246 * var_chaste_interface__intracellular_ion_concentrations__Cai - 1.181949379053441e-5 * var_chaste_interface__membrane__V + 8.279349689624225e-6 * (2.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3) * exp(0.013101861787960915 * var_chaste_interface__membrane__V) - 2628072.0 * var_chaste_interface__intracellular_ion_concentrations__Cai * exp(-0.024332029034784559 * var_chaste_interface__membrane__V)) / (1.0 + 0.20000000000000001 * exp(-0.024332029034784559 * var_chaste_interface__membrane__V)) - 1.0 * (2752.4498037978587 * pow(var_chaste_interface__intracellular_ion_concentrations__Cai, 1.2) - 0.096656534954407292 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_NSR, 1.0)) / (1.0 + 33855.471141425078 * pow(var_chaste_interface__intracellular_ion_concentrations__Cai, 1.2) + 0.303951367781155 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_NSR, 1.0)) - 0.0015381954438488301 * var_chaste_interface__intracellular_ion_concentrations__Cai / (5.0000000000000002e-5 + var_chaste_interface__intracellular_ion_concentrations__Cai) - 2800.0000000000005 * (1.0 - var_chaste_interface__intracellular_Ca_fluxes__HTRPNCa) * var_chaste_interface__intracellular_ion_concentrations__Cai - 2800.0000000000005 * (1.0 - var_chaste_interface__intracellular_Ca_fluxes__LTRPNCa) * var_chaste_interface__intracellular_ion_concentrations__Cai) / (1.0 + 0.00011900000000000002 / pow((0.0023800000000000002 + var_chaste_interface__intracellular_ion_concentrations__Cai), 2)); // millimolar / millisecond
        const double var_transient_outward_potassium_current_X_to1_gate__alpha_X_to1 = 45.159999999999997 * exp(0.035770000000000003 * var_chaste_interface__membrane__V); // per_second
        const double var_transient_outward_potassium_current_X_to1_gate__beta_X_to1 = 98.900000000000006 * exp(-0.062370000000000002 * var_chaste_interface__membrane__V); // per_second
        const double var_transient_outward_potassium_current_Y_to1_gate__alpha_Y_to1 = 5.415 * exp(-6.7000000000000002 - 0.20000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.051334999999999999 * exp(-6.7000000000000002 - 0.20000000000000001 * var_chaste_interface__membrane__V)); // per_second
        const double var_transient_outward_potassium_current_Y_to1_gate__beta_Y_to1 = 5.415 * exp(6.7000000000000002 + 0.20000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.051334999999999999 * exp(6.7000000000000002 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // per_second

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__V = 0.082812658045056511 * log(138.0 / var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.005131713422727534 * log(2.0 / var_chaste_interface__intracellular_ion_concentrations__Cai) - 0.0034841999999999998 * var_chaste_interface__membrane__V - 0.0027133999999999999 * pow(var_chaste_interface__slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks, 2) * (-26.713760659695648 * log(6.5295399999999999 / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.018329999999999999 * var_chaste_interface__intracellular_ion_concentrations__Nai)) + var_chaste_interface__membrane__V) - 0.504 / ((1.0 + 31.622776601683793 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Nai, 1.5)) * (1.0 + 0.1245 * exp(-0.0037433890822745476 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0505200594353643)) * exp(-0.037433890822745473 * var_chaste_interface__membrane__V))) - 0.050000000000000003 * var_chaste_interface__intracellular_ion_concentrations__Cai / (5.0000000000000002e-5 + var_chaste_interface__intracellular_ion_concentrations__Cai) - 0.00013456270662374128 * (2.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3) * exp(0.013101861787960915 * var_chaste_interface__membrane__V) - 2628072.0 * var_chaste_interface__intracellular_ion_concentrations__Cai * exp(-0.024332029034784559 * var_chaste_interface__membrane__V)) / (1.0 + 0.20000000000000001 * exp(-0.024332029034784559 * var_chaste_interface__membrane__V)) - 0.0022160000000000001 * (-26.713760659695648 * log(4.0 / var_chaste_interface__intracellular_ion_concentrations__Ki) + var_chaste_interface__membrane__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)) - 0.6588235294117647 * (-26.713760659695648 * log(4.0 / var_chaste_interface__intracellular_ion_concentrations__Ki) + var_chaste_interface__membrane__V) / (2.0 + exp(0.056150836234118207 * var_chaste_interface__membrane__V - 1.5 * log(4.0 / var_chaste_interface__intracellular_ion_concentrations__Ki))) - 1.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted) / HeartConfig::Instance()->GetCapacitance() - 0.0033999999999999998 * (-26.713760659695648 * log(4.0 / var_chaste_interface__intracellular_ion_concentrations__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr / (1.0 + 1.4944999999999999 * exp(0.044600000000000001 * var_chaste_interface__membrane__V)) - 0.23815 * (-26.713760659695648 * log(4.0 / var_chaste_interface__intracellular_ion_concentrations__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__transient_outward_potassium_current_X_to1_gate__X_to1 * var_chaste_interface__transient_outward_potassium_current_Y_to1_gate__Y_to1 - 12.800000000000001 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695648 * log(138.0 / var_chaste_interface__intracellular_ion_concentrations__Nai) + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j - 4.5147771746328917 * (-0.68200000000000005 + 0.001 * exp(0.074867781645490947 * var_chaste_interface__membrane__V)) * (var_chaste_interface__L_type_Ca_current__O + var_chaste_interface__L_type_Ca_current__O_Ca) * var_chaste_interface__L_type_Ca_current_y_gate__y * var_chaste_interface__membrane__V / (-1.0 + exp(0.074867781645490947 * var_chaste_interface__membrane__V)) - 2.091244787289955e-6 * (-4.0 + var_chaste_interface__intracellular_ion_concentrations__Ki * exp(0.037433890822745473 * var_chaste_interface__membrane__V)) * (var_chaste_interface__L_type_Ca_current__O + var_chaste_interface__L_type_Ca_current__O_Ca) * var_chaste_interface__L_type_Ca_current_y_gate__y * var_chaste_interface__membrane__V / ((1.0 - 17.036894998614684 * (-0.68200000000000005 + 0.001 * exp(0.074867781645490947 * var_chaste_interface__membrane__V)) * var_chaste_interface__membrane__V / (-1.0 + exp(0.074867781645490947 * var_chaste_interface__membrane__V))) * (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V))); // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__V;
        rDY[1] = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        rAlphaOrTau[2] = 0.001 * var_fast_sodium_current_h_gate__alpha_h;
        rBetaOrInf[2] = 0.001 * var_fast_sodium_current_h_gate__beta_h;
        rAlphaOrTau[3] = 0.001 * var_fast_sodium_current_j_gate__alpha_j;
        rBetaOrInf[3] = 0.001 * var_fast_sodium_current_j_gate__beta_j;
        rAlphaOrTau[4] = 1000.0 * var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__tau_X_kr;
        rBetaOrInf[4] = var_rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr_inf;
        rAlphaOrTau[5] = 1000.0 * var_slow_activating_delayed_rectifiyer_K_current_X_ks_gate__tau_X_ks;
        rBetaOrInf[5] = var_slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks_infinity;
        rAlphaOrTau[6] = 0.001 * var_transient_outward_potassium_current_X_to1_gate__alpha_X_to1;
        rBetaOrInf[6] = 0.001 * var_transient_outward_potassium_current_X_to1_gate__beta_X_to1;
        rAlphaOrTau[7] = 0.001 * var_transient_outward_potassium_current_Y_to1_gate__alpha_Y_to1;
        rBetaOrInf[7] = 0.001 * var_transient_outward_potassium_current_Y_to1_gate__beta_Y_to1;
        rDY[8] = d_dt_chaste_interface_var_L_type_Ca_current__O;
        rDY[9] = d_dt_chaste_interface_var_L_type_Ca_current__O_Ca;
        rDY[10] = d_dt_chaste_interface_var_L_type_Ca_current__C0;
        rDY[11] = d_dt_chaste_interface_var_L_type_Ca_current__C1;
        rDY[12] = d_dt_chaste_interface_var_L_type_Ca_current__C2;
        rDY[13] = d_dt_chaste_interface_var_L_type_Ca_current__C3;
        rDY[14] = d_dt_chaste_interface_var_L_type_Ca_current__C4;
        rDY[15] = d_dt_chaste_interface_var_L_type_Ca_current__C_Ca0;
        rDY[16] = d_dt_chaste_interface_var_L_type_Ca_current__C_Ca1;
        rDY[17] = d_dt_chaste_interface_var_L_type_Ca_current__C_Ca2;
        rDY[18] = d_dt_chaste_interface_var_L_type_Ca_current__C_Ca3;
        rDY[19] = d_dt_chaste_interface_var_L_type_Ca_current__C_Ca4;
        rAlphaOrTau[20] = 1000.0 * var_L_type_Ca_current_y_gate__tau_y;
        rBetaOrInf[20] = var_L_type_Ca_current_y_gate__y_infinity;
        rDY[21] = d_dt_chaste_interface_var_RyR_channel__P_O1;
        rDY[22] = d_dt_chaste_interface_var_RyR_channel__P_O2;
        rDY[23] = d_dt_chaste_interface_var_RyR_channel__P_C1;
        rDY[24] = d_dt_chaste_interface_var_RyR_channel__P_C2;
        rDY[25] = d_dt_chaste_interface_var_intracellular_Ca_fluxes__HTRPNCa;
        rDY[26] = d_dt_chaste_interface_var_intracellular_Ca_fluxes__LTRPNCa;
        rDY[27] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Nai;
        rDY[28] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Cai;
        rDY[29] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ki;
        rDY[30] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_ss;
        rDY[31] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_JSR;
        rDY[32] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_NSR;
    }
    void Cellwinslow_model_1999FromCellMLRushLarsenOpt::ComputeOneStepExceptVoltage(const std::vector<double> &rDY, const std::vector<double> &rAlphaOrTau, const std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        
        rY[1] += mDt * rDY[1];
        {
            const double tau_inv = rAlphaOrTau[2] + rBetaOrInf[2];
            const double y_inf = rAlphaOrTau[2] / tau_inv;
            rY[2] = y_inf + (rY[2] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[3] + rBetaOrInf[3];
            const double y_inf = rAlphaOrTau[3] / tau_inv;
            rY[3] = y_inf + (rY[3] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[4] = rBetaOrInf[4] + (rY[4] - rBetaOrInf[4])*exp(-mDt/rAlphaOrTau[4]);
        rY[5] = rBetaOrInf[5] + (rY[5] - rBetaOrInf[5])*exp(-mDt/rAlphaOrTau[5]);
        {
            const double tau_inv = rAlphaOrTau[6] + rBetaOrInf[6];
            const double y_inf = rAlphaOrTau[6] / tau_inv;
            rY[6] = y_inf + (rY[6] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[7] + rBetaOrInf[7];
            const double y_inf = rAlphaOrTau[7] / tau_inv;
            rY[7] = y_inf + (rY[7] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[8] += mDt * rDY[8];
        rY[9] += mDt * rDY[9];
        rY[10] += mDt * rDY[10];
        rY[11] += mDt * rDY[11];
        rY[12] += mDt * rDY[12];
        rY[13] += mDt * rDY[13];
        rY[14] += mDt * rDY[14];
        rY[15] += mDt * rDY[15];
        rY[16] += mDt * rDY[16];
        rY[17] += mDt * rDY[17];
        rY[18] += mDt * rDY[18];
        rY[19] += mDt * rDY[19];
        rY[20] = rBetaOrInf[20] + (rY[20] - rBetaOrInf[20])*exp(-mDt/rAlphaOrTau[20]);
        rY[21] += mDt * rDY[21];
        rY[22] += mDt * rDY[22];
        rY[23] += mDt * rDY[23];
        rY[24] += mDt * rDY[24];
        rY[25] += mDt * rDY[25];
        rY[26] += mDt * rDY[26];
        rY[27] += mDt * rDY[27];
        rY[28] += mDt * rDY[28];
        rY[29] += mDt * rDY[29];
        rY[30] += mDt * rDY[30];
        rY[31] += mDt * rDY[31];
        rY[32] += mDt * rDY[32];
    }

    std::vector<double> Cellwinslow_model_1999FromCellMLRushLarsenOpt::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellwinslow_model_1999FromCellMLRushLarsenOpt>::Initialise(void)
{
    this->mSystemName = "winslow_model_1999";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-96.1638);

    // rY[1]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0328302);

    // rY[2]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.988354);

    // rY[3]:
    this->mVariableNames.push_back("fast_sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99254);

    // rY[4]:
    this->mVariableNames.push_back("rapid_activating_delayed_rectifiyer_K_current_X_kr_gate__X_kr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.51);

    // rY[5]:
    this->mVariableNames.push_back("slow_activating_delayed_rectifiyer_K_current_X_ks_gate__X_ks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.264);

    // rY[6]:
    this->mVariableNames.push_back("transient_outward_potassium_current_X_to1_gate__X_to1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.63);

    // rY[7]:
    this->mVariableNames.push_back("transient_outward_potassium_current_Y_to1_gate__Y_to1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99);

    // rY[8]:
    this->mVariableNames.push_back("L_type_Ca_current__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.84546e-21);

    // rY[9]:
    this->mVariableNames.push_back("L_type_Ca_current__O_Ca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[10]:
    this->mVariableNames.push_back("L_type_Ca_current__C0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.997208);

    // rY[11]:
    this->mVariableNames.push_back("L_type_Ca_current__C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.38897e-05);

    // rY[12]:
    this->mVariableNames.push_back("L_type_Ca_current__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.535e-09);

    // rY[13]:
    this->mVariableNames.push_back("L_type_Ca_current__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.63909e-14);

    // rY[14]:
    this->mVariableNames.push_back("L_type_Ca_current__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.56337e-20);

    // rY[15]:
    this->mVariableNames.push_back("L_type_Ca_current__C_Ca0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00272826);

    // rY[16]:
    this->mVariableNames.push_back("L_type_Ca_current__C_Ca1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.99215e-07);

    // rY[17]:
    this->mVariableNames.push_back("L_type_Ca_current__C_Ca2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.71989e-11);

    // rY[18]:
    this->mVariableNames.push_back("L_type_Ca_current__C_Ca3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.87031e-15);

    // rY[19]:
    this->mVariableNames.push_back("L_type_Ca_current__C_Ca4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(4.59752e-20);

    // rY[20]:
    this->mVariableNames.push_back("L_type_Ca_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.798);

    // rY[21]:
    this->mVariableNames.push_back("RyR_channel__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[22]:
    this->mVariableNames.push_back("RyR_channel__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[23]:
    this->mVariableNames.push_back("RyR_channel__P_C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.47);

    // rY[24]:
    this->mVariableNames.push_back("RyR_channel__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.53);

    // rY[25]:
    this->mVariableNames.push_back("intracellular_Ca_fluxes__HTRPNCa");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.98);

    // rY[26]:
    this->mVariableNames.push_back("intracellular_Ca_fluxes__LTRPNCa");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.078);

    // rY[27]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(10.0);

    // rY[28]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Cai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8e-05);

    // rY[29]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(157.8);

    // rY[30]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_ss");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00011);

    // rY[31]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_JSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.257);

    // rY[32]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_NSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.257);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.0001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellwinslow_model_1999FromCellMLRushLarsenOpt)

