//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: pandit_model_2001_epi
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "pandit_model_2001_epi.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellpandit_model_2001_epiFromCellMLRushLarsenOpt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.00059999999999999995 * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 5.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellpandit_model_2001_epiFromCellMLRushLarsenOpt::Cellpandit_model_2001_epiFromCellMLRushLarsenOpt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractRushLarsenCardiacCell(
                26,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellpandit_model_2001_epiFromCellMLRushLarsenOpt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 0.0001; // (var_membrane__Cm) [microF]
    }

    Cellpandit_model_2001_epiFromCellMLRushLarsenOpt::~Cellpandit_model_2001_epiFromCellMLRushLarsenOpt()
    {
    }
    
    double Cellpandit_model_2001_epiFromCellMLRushLarsenOpt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.50146
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.004164108
        double var_chaste_interface__sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.6735613
        double var_chaste_interface__sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.6729362
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 2.171081e-06
        double var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 = rY[5];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 = rY[6];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact = rY[7];
        // Units: dimensionless; Initial value: 0.9913102
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.002191519
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.9842542
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = rY[10];
        // Units: dimensionless; Initial value: 0.6421196
        double var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss = rY[11];
        // Units: dimensionless; Initial value: 0.002907171
        double var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss = rY[12];
        // Units: dimensionless; Initial value: 0.3142767
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[13];
        // Units: dimensionless; Initial value: 0.003578708
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[20];
        // Units: millimolar; Initial value: 10.73519
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[21];
        // Units: millimolar; Initial value: 7.901351e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[22];
        // Units: millimolar; Initial value: 139.2751
        
        const double var_L_type_Ca_channel__i_Ca_L = 0.031 * (-65.0 + var_chaste_interface__membrane__V) * ((0.10000000000000001 - 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + (0.90000000000000002 + 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11) * var_chaste_interface__L_type_Ca_channel_d_gate__d; // nanoA
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P = 0.0040000000000000001 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // nanoA
        const double var_Ca_independent_transient_outward_K_current__E_K = 25.420807984495319 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i); // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = 0.035000000000000003 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.88600000000000001 * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + 0.114 * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r; // nanoA
        const double var_inward_rectifier__i_K1 = 0.0001 * (10.0 + 48.0 / (exp(1.48 + 0.040000000000000001 * var_chaste_interface__membrane__V) + exp(-1.48 - 0.040000000000000001 * var_chaste_interface__membrane__V))) / (1.0 + exp(4.5158823529411762 + 0.058823529411764705 * var_Ca_independent_transient_outward_K_current__E_K - 0.058823529411764705 * var_chaste_interface__membrane__V)) + 0.024 * (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(-35.49354838709678)) * (1.0 + exp(-0.10977188457982838 + 0.06345195640452507 * var_chaste_interface__membrane__V - 0.06345195640452507 * var_Ca_independent_transient_outward_K_current__E_K))); // nanoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = 9.9839999999999996e-6 * (1.2 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.018714999999999999 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.018714999999999999 * var_chaste_interface__membrane__V)) / (1.0 + 0.00012 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 274.40000000000003 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // nanoA
        const double var_sodium_current__E_Na = 25.420807984495319 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i); // millivolt
        const double var_background_currents__i_B = 0.00025054999999999999 * var_chaste_interface__membrane__V - 0.00013799999999999999 * var_Ca_independent_transient_outward_K_current__E_K - 8.0149999999999997e-5 * var_sodium_current__E_Na - 0.00041181708934882422 * log(1.2 / var_chaste_interface__intracellular_ion_concentrations__Ca_i); // nanoA
        const double var_hyperpolarisation_activated_current__i_f = 0.00116 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + 0.00029 * (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_sodium_current__i_Na = 0.80000000000000004 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__sodium_current_h_gate__h * var_chaste_interface__sodium_current_j_gate__j; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 0.062608695652173918 / ((1.0 + 31.622776601683793 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5)) * (1.0 + 0.1245 * exp(-0.0039337852699643568 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.039337852699643565 * var_chaste_interface__membrane__V))); // nanoA
        const double var_steady_state_outward_K_current__i_ss = 0.0070000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss; // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_Ca_independent_transient_outward_K_current__i_t + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B + var_hyperpolarisation_activated_current__i_f + var_inward_rectifier__i_K1 + var_sarcolemmal_calcium_pump_current__i_Ca_P + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_steady_state_outward_K_current__i_ss) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellpandit_model_2001_epiFromCellMLRushLarsenOpt::EvaluateEquations(double var_chaste_interface__environment__time_converted, std::vector<double> &rDY, std::vector<double> &rAlphaOrTau, std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.50146
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.004164108
        double var_chaste_interface__sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.6735613
        double var_chaste_interface__sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.6729362
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 2.171081e-06
        double var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 = rY[5];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 = rY[6];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact = rY[7];
        // Units: dimensionless; Initial value: 0.9913102
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.002191519
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.9842542
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = rY[10];
        // Units: dimensionless; Initial value: 0.6421196
        double var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss = rY[11];
        // Units: dimensionless; Initial value: 0.002907171
        double var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss = rY[12];
        // Units: dimensionless; Initial value: 0.3142767
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[13];
        // Units: dimensionless; Initial value: 0.003578708
        double var_chaste_interface__SR_Ca_release_channel__P_O1 = rY[14];
        // Units: dimensionless; Initial value: 0.0004327548
        double var_chaste_interface__SR_Ca_release_channel__P_O2 = rY[15];
        // Units: dimensionless; Initial value: 6.06254e-10
        double var_chaste_interface__SR_Ca_release_channel__P_C1 = rY[16];
        // Units: dimensionless; Initial value: 0.6348229
        double var_chaste_interface__SR_Ca_release_channel__P_C2 = rY[17];
        // Units: dimensionless; Initial value: 0.3647471
        double var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa = rY[18];
        // Units: millimolar; Initial value: 0.1394301
        double var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa = rY[19];
        // Units: millimolar; Initial value: 0.0051619
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[20];
        // Units: millimolar; Initial value: 10.73519
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[21];
        // Units: millimolar; Initial value: 7.901351e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[22];
        // Units: millimolar; Initial value: 139.2751
        double var_chaste_interface__intracellular_ion_concentrations__Ca_ss = rY[23];
        // Units: millimolar; Initial value: 8.737212e-05
        double var_chaste_interface__intracellular_ion_concentrations__Ca_JSR = rY[24];
        // Units: millimolar; Initial value: 0.06607948
        double var_chaste_interface__intracellular_ion_concentrations__Ca_NSR = rY[25];
        // Units: millimolar; Initial value: 0.06600742

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_C2 = 0.10000000000000001 * var_chaste_interface__SR_Ca_release_channel__P_O1 - 0.00080000000000000004 * var_chaste_interface__SR_Ca_release_channel__P_C2; // 1 / millisecond
        const double d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__HTRPNCa = -6.6000000000000005e-5 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa + 200.0 * (0.14000000000000001 - var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__LTRPNCa = -0.040000000000000001 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa + 40.0 * (0.070000000000000007 - var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_inact_gate__Ca_inact = 0.11111111111111112 / (1.0 + 100.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss) - 0.11111111111111112 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact; // 1 / millisecond
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_C1 = 0.57599999999999996 * var_chaste_interface__SR_Ca_release_channel__P_O1 - 12150000000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 4.0) * var_chaste_interface__SR_Ca_release_channel__P_C1; // 1 / millisecond
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_O1 = 0.00080000000000000004 * var_chaste_interface__SR_Ca_release_channel__P_C2 + 1.9299999999999999 * var_chaste_interface__SR_Ca_release_channel__P_O2 - 0.67600000000000005 * var_chaste_interface__SR_Ca_release_channel__P_O1 + 12150000000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 4.0) * var_chaste_interface__SR_Ca_release_channel__P_C1 - 4050000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 3.0) * var_chaste_interface__SR_Ca_release_channel__P_O1; // 1 / millisecond
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_O2 = -1.9299999999999999 * var_chaste_interface__SR_Ca_release_channel__P_O2 + 4050000.0 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_ss, 3.0) * var_chaste_interface__SR_Ca_release_channel__P_O1; // 1 / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_NSR = 0.19333758676024207 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR - 0.19333758676024207 * var_chaste_interface__intracellular_ion_concentrations__Ca_NSR + 0.0018571428571428571 * (1354.2188456570032 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 1.2) - 0.2735562310030395 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_NSR, 1.0)) / (1.0 + 33855.471141425078 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 1.2) + 0.303951367781155 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_NSR, 1.0)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_JSR = 0.001 * (1740.0382808421784 * var_chaste_interface__intracellular_ion_concentrations__Ca_NSR - 1740.0382808421784 * var_chaste_interface__intracellular_ion_concentrations__Ca_JSR - 1800.0 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) * (var_chaste_interface__SR_Ca_release_channel__P_O1 + var_chaste_interface__SR_Ca_release_channel__P_O2)) / (1.0 + 12.0 / pow((0.80000000000000004 + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR), 2)); // millimolar / millisecond
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_infinity = 1 / (1.0 + exp(-0.92819614711033271 - 0.087565674255691769 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_r_gate__tau_r = 1 / (45.159999999999997 * exp(1.7885000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V) + 98.900000000000006 * exp(-3.8000000000000003 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // second
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_infinity = 1 / (1.0 + exp(6.5803808776746413 + 0.14526227103034528 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s_gate__tau_s = 0.035000000000000003 + 0.34999999999999998 * exp(-21.777777777777779 * pow((1 + 0.014285714285714285 * var_chaste_interface__membrane__V), 2)); // second
        const double var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow_infinity = 1 / (1.0 + exp(6.5803808776746413 + 0.14526227103034528 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s_slow_gate__tau_s_slow = 0.035000000000000003 + 3.7000000000000002 * exp(-5.4444444444444446 * pow((1 + 0.014285714285714285 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_d_gate__d_infinity = 1 / (1.0 + exp(-3.0600000000000001 - 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_d_gate__tau_d = 0.00025000000000000001 + 0.0010499999999999999 * exp(-0.64800000000000002 * pow((-1 + 0.055555555555555552 * var_chaste_interface__membrane__V), 2)) + 0.0030500000000000002 * exp(-0.22049999999999997 * pow((1 + 0.14285714285714285 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_11_gate__f_11_infinity = 1 / (1.0 + exp(4.9444444444444438 + 0.18518518518518517 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_11_gate__tau_f_11 = 0.0016999999999999999 + 0.014999999999999999 / (1.0 + exp(3.0 + 0.040000000000000001 * var_chaste_interface__membrane__V)) + 0.040000000000000001 / (1.0 + exp(1.0 - 0.040000000000000001 * var_chaste_interface__membrane__V)) + 0.105 * exp(-14.0625 * pow((1 + 0.022222222222222223 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_12_gate__f_12_infinity = 1 / (1.0 + exp(4.9444444444444438 + 0.18518518518518517 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_12_gate__tau_f_12 = 0.0016999999999999999 + 0.014999999999999999 / (1.0 + exp(3.0 + 0.040000000000000001 * var_chaste_interface__membrane__V)) + 0.080000000000000002 / (1.0 + exp(-11.0 - 0.20000000000000001 * var_chaste_interface__membrane__V)) + 0.041000000000000002 * exp(-15.340277777777779 * pow((1 + 0.021276595744680851 * var_chaste_interface__membrane__V), 2)); // second
        const double var_hyperpolarisation_activated_current_y_gate__tau_y = 1 / (0.56230000000000002 * exp(-5.6377730796335452 - 0.070472163495419307 * var_chaste_interface__membrane__V) + 0.11885 * exp(2.8198801550934083 + 0.035248501938667604 * var_chaste_interface__membrane__V)); // second
        const double var_hyperpolarisation_activated_current_y_gate__y_infinity = 1 / (1.0 + exp(13.225190839694655 + 0.095419847328244267 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_ss = 0.001 * (29213.483146067414 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 29213.483146067414 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss + 84000.0 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) * (var_chaste_interface__SR_Ca_release_channel__P_O1 + var_chaste_interface__SR_Ca_release_channel__P_O2) - 13.386950228182727 * (-65.0 + var_chaste_interface__membrane__V) * ((0.10000000000000001 - 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + (0.90000000000000002 + 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11) * var_chaste_interface__L_type_Ca_channel_d_gate__d) / (1.0 + 0.00011900000000000002 / pow((0.0023800000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_ss), 2)); // millimolar / millisecond
        const double var_sodium_current_h_gate__h_infinity = 1 / (1.0 + exp(12.537067545304776 + 0.16474464579901152 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h_gate__tau_h = ((var_chaste_interface__membrane__V >= -40.0) ? (0.00045370000000000002 + 0.00045370000000000002 * exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)) : (0.00349 / (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V) + 0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__V)))); // second
        const double var_sodium_current_j_gate__j_infinity = 1 / (1.0 + exp(12.537067545304776 + 0.16474464579901152 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_j_gate__tau_j = ((var_chaste_interface__membrane__V >= -40.0) ? (0.01163 * (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)) / exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V)) : (0.00349 / (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V)) + (37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))))); // second
        const double var_sodium_current_m_gate__m_infinity = 1 / (1.0 + exp(-6.9230769230769234 - 0.15384615384615385 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_m_gate__tau_m = 0.0013600000000000001 / (0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V) + 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__V))); // second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = 0.001 * (40.0 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa + 0.066000000000000003 * var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa + 0.00022799730679188537 * log(1.2 / var_chaste_interface__intracellular_ion_concentrations__Ca_i) + 37.453183520599246 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss - 37.453183520599246 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 1.7937848940989261e-5 * var_chaste_interface__membrane__V + 1.1055029865854122e-5 * (1.2 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.018714999999999999 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.018714999999999999 * var_chaste_interface__membrane__V)) / (1.0 + 0.00012 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 274.40000000000003 * var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 1.0 * (1354.2188456570032 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 1.2) - 0.2735562310030395 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_NSR, 1.0)) / (1.0 + 33855.471141425078 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 1.2) + 0.303951367781155 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_NSR, 1.0)) - 40000.0 * (0.070000000000000007 - var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa) * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 200000.0 * (0.14000000000000001 - var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa) * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 0.0022145492519739826 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i)) / (1.0 + 0.0014999999999999998 / pow((0.00014999999999999999 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2) + 0.00011900000000000002 / pow((0.0023800000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = 2.2560474246135324e-6 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i) - 8.8748061272857348e-8 * var_chaste_interface__membrane__V - 3.3165089597562367e-8 * (1.2 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.018714999999999999 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.018714999999999999 * var_chaste_interface__membrane__V)) / (1.0 + 0.00012 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 274.40000000000003 * var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 3.2110964153622751e-7 * (-25.420807984495319 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i) + var_chaste_interface__membrane__V) * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y - 0.00020797506018538275 / ((1.0 + 31.622776601683793 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5)) * (1.0 + 0.1245 * exp(-0.0039337852699643568 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.039337852699643565 * var_chaste_interface__membrane__V))) - 0.00088581970078959317 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-25.420807984495319 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i) + var_chaste_interface__membrane__V) * var_chaste_interface__sodium_current_h_gate__h * var_chaste_interface__sodium_current_j_gate__j; // millimolar / millisecond
        const double var_steady_state_outward_K_current_r_ss_gate__r_ss_infinity = 1 / (1.0 + exp(-0.97292724196277491 - 0.084602368866328256 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_steady_state_outward_K_current_r_ss_gate__tau_r_ss = 10.0 / (45.159999999999997 * exp(1.7885000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V) + 98.900000000000006 * exp(-3.8000000000000003 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = 3.8843985601580465e-6 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i) - 1.528038983862048e-7 * var_chaste_interface__membrane__V + 0.00013865004012358849 / ((1.0 + 31.622776601683793 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5)) * (1.0 + 0.1245 * exp(-0.0039337852699643568 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.039337852699643565 * var_chaste_interface__membrane__V))) - 1.2844385661449098e-6 * (-25.420807984495319 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y - 1.1072746259869914e-7 * (10.0 + 48.0 / (exp(1.48 + 0.040000000000000001 * var_chaste_interface__membrane__V) + exp(-1.48 - 0.040000000000000001 * var_chaste_interface__membrane__V))) / (1.0 + exp(4.5158823529411762 + 1.4953416461467837 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i) - 0.058823529411764705 * var_chaste_interface__membrane__V)) - 2.6574591023687795e-5 * (-1.73 - 25.420807984495319 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) / ((1.0 + exp(-35.49354838709678)) * (1.0 + exp(-0.10977188457982838 + 0.06345195640452507 * var_chaste_interface__membrane__V - 1.613 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i)))) - 7.7509223819089404e-6 * (-25.420807984495319 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss - 3.8754611909544704e-5 * (0.88600000000000001 * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + 0.114 * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow) * (-25.420807984495319 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r; // millimolar / millisecond
        const double var_steady_state_outward_K_current_s_ss_gate__s_ss_infinity = 1 / (1.0 + exp(8.4951456310679614 + 0.097087378640776698 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_steady_state_outward_K_current_s_ss_gate__tau_s_ss = 2.1000000000000001; // second

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__V = 0.001 * (0.0020374777599573 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i) + 0.00041181708934882422 * log(1.2 / var_chaste_interface__intracellular_ion_concentrations__Ca_i) + 0.0035080715018603542 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i) - 0.00025054999999999999 * var_chaste_interface__membrane__V - 0.0040000000000000001 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 9.9839999999999996e-6 * (1.2 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.018714999999999999 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.018714999999999999 * var_chaste_interface__membrane__V)) / (1.0 + 0.00012 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 274.40000000000003 * var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 0.0001 * (10.0 + 48.0 / (exp(1.48 + 0.040000000000000001 * var_chaste_interface__membrane__V) + exp(-1.48 - 0.040000000000000001 * var_chaste_interface__membrane__V))) / (1.0 + exp(4.5158823529411762 + 1.4953416461467837 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i) - 0.058823529411764705 * var_chaste_interface__membrane__V)) - 0.062608695652173918 / ((1.0 + 31.622776601683793 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5)) * (1.0 + 0.1245 * exp(-0.0039337852699643568 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.039337852699643565 * var_chaste_interface__membrane__V))) - 0.00116 * (-25.420807984495319 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y - 0.00029 * (-25.420807984495319 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i) + var_chaste_interface__membrane__V) * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y - 1000.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted) * mParameters[0] / HeartConfig::Instance()->GetCapacitance() - 0.031 * (-65.0 + var_chaste_interface__membrane__V) * ((0.10000000000000001 - 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + (0.90000000000000002 + 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11) * var_chaste_interface__L_type_Ca_channel_d_gate__d - 0.035000000000000003 * (0.88600000000000001 * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + 0.114 * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow) * (-25.420807984495319 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r - 0.024 * (-1.73 - 25.420807984495319 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) / ((1.0 + exp(-35.49354838709678)) * (1.0 + exp(-0.10977188457982838 + 0.06345195640452507 * var_chaste_interface__membrane__V - 1.613 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i)))) - 0.0070000000000000001 * (-25.420807984495319 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss - 0.80000000000000004 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-25.420807984495319 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i) + var_chaste_interface__membrane__V) * var_chaste_interface__sodium_current_h_gate__h * var_chaste_interface__sodium_current_j_gate__j) / mParameters[0]; // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__V;
        rAlphaOrTau[1] = 1000.0 * var_sodium_current_m_gate__tau_m;
        rBetaOrInf[1] = var_sodium_current_m_gate__m_infinity;
        rAlphaOrTau[2] = 1000.0 * var_sodium_current_h_gate__tau_h;
        rBetaOrInf[2] = var_sodium_current_h_gate__h_infinity;
        rAlphaOrTau[3] = 1000.0 * var_sodium_current_j_gate__tau_j;
        rBetaOrInf[3] = var_sodium_current_j_gate__j_infinity;
        rAlphaOrTau[4] = 1000.0 * var_L_type_Ca_channel_d_gate__tau_d;
        rBetaOrInf[4] = var_L_type_Ca_channel_d_gate__d_infinity;
        rAlphaOrTau[5] = 1000.0 * var_L_type_Ca_channel_f_11_gate__tau_f_11;
        rBetaOrInf[5] = var_L_type_Ca_channel_f_11_gate__f_11_infinity;
        rAlphaOrTau[6] = 1000.0 * var_L_type_Ca_channel_f_12_gate__tau_f_12;
        rBetaOrInf[6] = var_L_type_Ca_channel_f_12_gate__f_12_infinity;
        rDY[7] = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_inact_gate__Ca_inact;
        rAlphaOrTau[8] = 1000.0 * var_Ca_independent_transient_outward_K_current_r_gate__tau_r;
        rBetaOrInf[8] = var_Ca_independent_transient_outward_K_current_r_gate__r_infinity;
        rAlphaOrTau[9] = 1000.0 * var_Ca_independent_transient_outward_K_current_s_gate__tau_s;
        rBetaOrInf[9] = var_Ca_independent_transient_outward_K_current_s_gate__s_infinity;
        rAlphaOrTau[10] = 1000.0 * var_Ca_independent_transient_outward_K_current_s_slow_gate__tau_s_slow;
        rBetaOrInf[10] = var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow_infinity;
        rAlphaOrTau[11] = 1000.0 * var_steady_state_outward_K_current_r_ss_gate__tau_r_ss;
        rBetaOrInf[11] = var_steady_state_outward_K_current_r_ss_gate__r_ss_infinity;
        rAlphaOrTau[12] = 1000.0 * var_steady_state_outward_K_current_s_ss_gate__tau_s_ss;
        rBetaOrInf[12] = var_steady_state_outward_K_current_s_ss_gate__s_ss_infinity;
        rAlphaOrTau[13] = 1000.0 * var_hyperpolarisation_activated_current_y_gate__tau_y;
        rBetaOrInf[13] = var_hyperpolarisation_activated_current_y_gate__y_infinity;
        rDY[14] = d_dt_chaste_interface_var_SR_Ca_release_channel__P_O1;
        rDY[15] = d_dt_chaste_interface_var_SR_Ca_release_channel__P_O2;
        rDY[16] = d_dt_chaste_interface_var_SR_Ca_release_channel__P_C1;
        rDY[17] = d_dt_chaste_interface_var_SR_Ca_release_channel__P_C2;
        rDY[18] = d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__HTRPNCa;
        rDY[19] = d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__LTRPNCa;
        rDY[20] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
        rDY[21] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
        rDY[22] = d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
        rDY[23] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_ss;
        rDY[24] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_JSR;
        rDY[25] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_NSR;
    }
    void Cellpandit_model_2001_epiFromCellMLRushLarsenOpt::ComputeOneStepExceptVoltage(const std::vector<double> &rDY, const std::vector<double> &rAlphaOrTau, const std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        
        rY[1] = rBetaOrInf[1] + (rY[1] - rBetaOrInf[1])*exp(-mDt/rAlphaOrTau[1]);
        rY[2] = rBetaOrInf[2] + (rY[2] - rBetaOrInf[2])*exp(-mDt/rAlphaOrTau[2]);
        rY[3] = rBetaOrInf[3] + (rY[3] - rBetaOrInf[3])*exp(-mDt/rAlphaOrTau[3]);
        rY[4] = rBetaOrInf[4] + (rY[4] - rBetaOrInf[4])*exp(-mDt/rAlphaOrTau[4]);
        rY[5] = rBetaOrInf[5] + (rY[5] - rBetaOrInf[5])*exp(-mDt/rAlphaOrTau[5]);
        rY[6] = rBetaOrInf[6] + (rY[6] - rBetaOrInf[6])*exp(-mDt/rAlphaOrTau[6]);
        rY[7] += mDt * rDY[7];
        rY[8] = rBetaOrInf[8] + (rY[8] - rBetaOrInf[8])*exp(-mDt/rAlphaOrTau[8]);
        rY[9] = rBetaOrInf[9] + (rY[9] - rBetaOrInf[9])*exp(-mDt/rAlphaOrTau[9]);
        rY[10] = rBetaOrInf[10] + (rY[10] - rBetaOrInf[10])*exp(-mDt/rAlphaOrTau[10]);
        rY[11] = rBetaOrInf[11] + (rY[11] - rBetaOrInf[11])*exp(-mDt/rAlphaOrTau[11]);
        rY[12] = rBetaOrInf[12] + (rY[12] - rBetaOrInf[12])*exp(-mDt/rAlphaOrTau[12]);
        rY[13] = rBetaOrInf[13] + (rY[13] - rBetaOrInf[13])*exp(-mDt/rAlphaOrTau[13]);
        rY[14] += mDt * rDY[14];
        rY[15] += mDt * rDY[15];
        rY[16] += mDt * rDY[16];
        rY[17] += mDt * rDY[17];
        rY[18] += mDt * rDY[18];
        rY[19] += mDt * rDY[19];
        rY[20] += mDt * rDY[20];
        rY[21] += mDt * rDY[21];
        rY[22] += mDt * rDY[22];
        rY[23] += mDt * rDY[23];
        rY[24] += mDt * rDY[24];
        rY[25] += mDt * rDY[25];
    }

    std::vector<double> Cellpandit_model_2001_epiFromCellMLRushLarsenOpt::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellpandit_model_2001_epiFromCellMLRushLarsenOpt>::Initialise(void)
{
    this->mSystemName = "pandit_model_2001_epi";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-80.50146);

    // rY[1]:
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004164108);

    // rY[2]:
    this->mVariableNames.push_back("sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6735613);

    // rY[3]:
    this->mVariableNames.push_back("sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6729362);

    // rY[4]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.171081e-06);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_11_gate__f_11");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999529);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_12_gate__f_12");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999529);

    // rY[7]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_inact_gate__Ca_inact");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9913102);

    // rY[8]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002191519);

    // rY[9]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9842542);

    // rY[10]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s_slow_gate__s_slow");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6421196);

    // rY[11]:
    this->mVariableNames.push_back("steady_state_outward_K_current_r_ss_gate__r_ss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002907171);

    // rY[12]:
    this->mVariableNames.push_back("steady_state_outward_K_current_s_ss_gate__s_ss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3142767);

    // rY[13]:
    this->mVariableNames.push_back("hyperpolarisation_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.003578708);

    // rY[14]:
    this->mVariableNames.push_back("SR_Ca_release_channel__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0004327548);

    // rY[15]:
    this->mVariableNames.push_back("SR_Ca_release_channel__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.06254e-10);

    // rY[16]:
    this->mVariableNames.push_back("SR_Ca_release_channel__P_C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6348229);

    // rY[17]:
    this->mVariableNames.push_back("SR_Ca_release_channel__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3647471);

    // rY[18]:
    this->mVariableNames.push_back("intracellular_and_SR_Ca_fluxes__HTRPNCa");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.1394301);

    // rY[19]:
    this->mVariableNames.push_back("intracellular_and_SR_Ca_fluxes__LTRPNCa");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0051619);

    // rY[20]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(10.73519);

    // rY[21]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.901351e-05);

    // rY[22]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(139.2751);

    // rY[23]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_ss");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.737212e-05);

    // rY[24]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_JSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.06607948);

    // rY[25]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_NSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.06600742);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.00001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellpandit_model_2001_epiFromCellMLRushLarsenOpt)
