//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: nygren_atrial_model_1998
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "nygren_atrial_model_1998.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.00027999999999999998 * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 6.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt::Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractRushLarsenCardiacCell(
                29,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 0.050000000000000003; // (var_membrane__Cm) [nanoF]
    }

    Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt::~Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt()
    {
    }
    
    double Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0032017
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.8814
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.8742
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 1.3005e-05
        double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.0010678
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.949
        double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
        // Units: dimensionless; Initial value: 0.00015949
        double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
        // Units: dimensionless; Initial value: 0.9912
        double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
        // Units: dimensionless; Initial value: 0.0048357
        double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.0001
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
        // Units: millimolar; Initial value: 129.435
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
        // Units: millimolar; Initial value: 130.011
        double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
        // Units: millimolar; Initial value: 1.8147
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
        // Units: millimolar; Initial value: 5.3581
        
        const double var_Ca_independent_transient_outward_K_current__E_K = 26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i); // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = 7.5 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s; // picoA
        const double var_L_type_Ca_channel__i_Ca_L = 6.75 * (-60.0 + var_chaste_interface__membrane__V) * ((1.0 - var_chaste_interface__intracellular_ion_concentrations__Ca_d / (0.025000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d)) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 * var_chaste_interface__intracellular_ion_concentrations__Ca_d / (0.025000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d)) * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L; // picoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = 0.037484200000000002 * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(0.017058350483361479 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.020849095035219586 * var_chaste_interface__membrane__V)) / (1.0 + 0.00029999999999999997 * pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + 0.00029999999999999997 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c); // picoA
        const double var_background_currents__i_B_Ca = 0.078681000000000001 * var_chaste_interface__membrane__V - 1.0378040372231492 * log(var_chaste_interface__cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_delayed_rectifier_K_currents__i_Ks = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n; // picoA
        const double var_delayed_rectifier_K_currents__i_Kr = 0.5 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a / (1.0 + exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)); // picoA
        const double var_inward_rectifier__i_K1 = 3.0 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(0.20470020580033774 + 0.056861168277871597 * var_chaste_interface__membrane__V - 0.056861168277871597 * var_Ca_independent_transient_outward_K_current__E_K)); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP = 4.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_sodium_current__E_Na = 26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i); // millivolt
        const double var_background_currents__i_B_Na = 0.060599 * var_chaste_interface__membrane__V - 0.060599 * var_sodium_current__E_Na; // picoA
        const double var_sodium_current__i_Na = 5.8521211132021298 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037907445518581065 * var_chaste_interface__membrane__V - 0.037907445518581065 * var_sodium_current__E_Na)) * (0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V / (-1.0 + exp(0.037907445518581065 * var_chaste_interface__membrane__V)); // picoA
        const double var_sodium_potassium_pump__i_NaK = 70.825299999999999 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (200.0 + var_chaste_interface__membrane__V) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // picoA
        const double var_sustained_outward_K_current__i_sus = 2.75 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus; // picoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_Ca_independent_transient_outward_K_current__i_t + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_delayed_rectifier_K_currents__i_Kr + var_delayed_rectifier_K_currents__i_Ks + var_inward_rectifier__i_K1 + var_sarcolemmal_calcium_pump_current__i_CaP + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_sustained_outward_K_current__i_sus) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt::EvaluateEquations(double var_chaste_interface__environment__time_converted, std::vector<double> &rDY, std::vector<double> &rAlphaOrTau, std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0032017
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.8814
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.8742
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 1.3005e-05
        double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.0010678
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.949
        double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
        // Units: dimensionless; Initial value: 0.00015949
        double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
        // Units: dimensionless; Initial value: 0.9912
        double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
        // Units: dimensionless; Initial value: 0.0048357
        double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.0001
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
        // Units: millimolar; Initial value: 129.435
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        double var_chaste_interface__intracellular_Ca_buffering__O_C = rY[17];
        // Units: dimensionless; Initial value: 0.0275
        double var_chaste_interface__intracellular_Ca_buffering__O_TC = rY[18];
        // Units: dimensionless; Initial value: 0.0133
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[19];
        // Units: dimensionless; Initial value: 0.1961
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[20];
        // Units: dimensionless; Initial value: 0.7094
        double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
        // Units: millimolar; Initial value: 130.011
        double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
        // Units: millimolar; Initial value: 1.8147
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
        // Units: millimolar; Initial value: 5.3581
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[24];
        // Units: millimolar; Initial value: 0.6465
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[25];
        // Units: millimolar; Initial value: 0.6646
        double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = rY[26];
        // Units: dimensionless; Initial value: 0.4369
        double var_chaste_interface__Ca_handling_by_the_SR__F1 = rY[27];
        // Units: dimensionless; Initial value: 0.4284
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[28];
        // Units: dimensionless; Initial value: 0.0028

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse = -0.40000000000000002 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse + 0.47999999999999998 * (1.0 - var_chaste_interface__Ca_handling_by_the_SR__O_Calse) * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // 1 / millisecond
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg = 5.0 - 5.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC - 5.6660000000000004 * var_chaste_interface__intracellular_Ca_buffering__O_TMgMg; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1 = 0.00081499999999999997 - 0.00081499999999999997 * var_chaste_interface__Ca_handling_by_the_SR__F1 - 0.00081499999999999997 * var_chaste_interface__Ca_handling_by_the_SR__F2 - 0.001 * (203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_d, 4) / pow((0.0030000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d), 4) + 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4)) * var_chaste_interface__Ca_handling_by_the_SR__F1; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2 = 0.001 * (203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_d, 4) / pow((0.0030000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d), 4) + 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4)) * var_chaste_interface__Ca_handling_by_the_SR__F1 - 0.001 * (33.960000000000001 + 339.60000000000002 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4)) * var_chaste_interface__Ca_handling_by_the_SR__F2; // 1 / millisecond
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C = -0.47599999999999998 * var_chaste_interface__intracellular_Ca_buffering__O_C + 200.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_C) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / millisecond
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC = -0.39200000000000002 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 78.400000000000006 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TC) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / millisecond
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC = -0.0066 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 200.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel = 0.099999999999999992 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + 12.4 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse - 0.099999999999999992 * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel - 14.880000000000001 * (1.0 - var_chaste_interface__Ca_handling_by_the_SR__O_Calse) * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel - 23.501339000540224 * pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel) / pow((0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2), 2); // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up = 0.011111111111111112 * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel - 0.011111111111111112 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + 0.036557638445284799 * (3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 0.32000000000000006 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up) / (1.3999999999999999 + 0.80000000000000004 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + 3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // millimolar / millisecond
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_infinity = 1 / (1.0 + exp(0.090909090909090912 - 0.090909090909090912 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_r_gate__tau_r = 0.0015 + 0.0035000000000000001 * exp(-0.0011111111111111111 * pow(var_chaste_interface__membrane__V, 2)); // second
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_infinity = 1 / (1.0 + exp(3.5217391304347827 + 0.086956521739130432 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s_gate__tau_s = 0.01414 + 0.48120000000000002 * exp(-12.275731601256398 * pow((1 + 0.019065776930409912 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_d_L_gate__d_L_infinity = 1 / (1.0 + exp(-1.5517241379310345 - 0.17241379310344829 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_d_L_gate__tau_d_L = 0.002 + 0.0027000000000000001 * exp(-1.3611111111111112 * pow((1 + 0.028571428571428571 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_L1_gate__f_L_infinity = 1 / (1.0 + exp(3.859154929577465 + 0.14084507042253522 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_L1_gate__tau_f_L1 = 0.01 + 0.161 * exp(-7.716049382716049 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_L2_gate__tau_f_L2 = 0.062600000000000003 + 1.3323 * exp(-7.9349335449315621 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)); // second
        const double var_delayed_rectifier_K_currents_n_gate__n_infinity = 1 / (1.0 + exp(1.5669291338582676 - 0.07874015748031496 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents_n_gate__tau_n = 0.69999999999999996 + 0.40000000000000002 * exp(-pow((-1.0 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2)); // second
        const double var_delayed_rectifier_K_currents_pa_gate__p_a_infinity = 1 / (1.0 + exp(-2.5 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents_pa_gate__tau_p_a = 0.031179999999999999 + 0.21718000000000001 * exp(-0.82285842787521646 * pow((1 + 0.049658350548228189 * var_chaste_interface__membrane__V), 2)); // second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_d = 0.099999999999999992 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 0.099999999999999992 * var_chaste_interface__intracellular_ion_concentrations__Ca_d - 0.00029723661994331282 * (-60.0 + var_chaste_interface__membrane__V) * ((1.0 - var_chaste_interface__intracellular_ion_concentrations__Ca_d / (0.025000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d)) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 * var_chaste_interface__intracellular_ion_concentrations__Ca_d / (0.025000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d)) * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L; // millimolar / millisecond
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__Ca_c = 7.2874493927125512e-5 + 5.0951796282701077e-7 * var_chaste_interface__membrane__V - 6.7205525966826332e-6 * log(var_chaste_interface__cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 4.048582995951417e-5 * var_chaste_interface__cleft_space_ion_concentrations__Ca_c + 2.5902973415539245e-5 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 4.8547611805137808e-7 * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(0.017058350483361479 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.020849095035219586 * var_chaste_interface__membrane__V)) / (1.0 + 0.00029999999999999997 * pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + 0.00029999999999999997 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) + 4.3711267638722472e-5 * (-60.0 + var_chaste_interface__membrane__V) * ((1.0 - var_chaste_interface__intracellular_ion_concentrations__Ca_d / (0.025000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d)) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 * var_chaste_interface__intracellular_ion_concentrations__Ca_d / (0.025000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d)) * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = 0.002 * var_chaste_interface__intracellular_ion_concentrations__Ca_d + 0.0010559999999999999 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 0.021419999999999998 * var_chaste_interface__intracellular_Ca_buffering__O_C + 0.031359999999999999 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 9.1399515314883814e-7 * log(var_chaste_interface__cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 0.002 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 6.9294442944473474e-8 * var_chaste_interface__membrane__V + 6.6024752054987431e-8 * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(0.017058350483361479 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.020849095035219586 * var_chaste_interface__membrane__V)) / (1.0 + 0.00029999999999999997 * pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + 0.00029999999999999997 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) - 6.2720000000000002 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TC) * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 32.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 3.5228043845133373e-6 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 9.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_C) * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 0.0024659630691593361 * (3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 0.32000000000000006 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up) / (1.3999999999999999 + 0.80000000000000004 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + 3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i) + 0.17614021922566686 * pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel) / pow((0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2), 2); // millimolar / millisecond
        const double var_sodium_current_h1_gate__h_infinity = 1 / (1.0 + exp(12.0 + 0.18867924528301888 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h1_gate__tau_h1 = 0.00029999999999999997 + 0.029999999999999999 / (1.0 + exp(10.96875 + 0.3125 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h2_gate__tau_h2 = 0.0030000000000000001 + 0.12 / (1.0 + exp(10.96875 + 0.3125 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_m_gate__m_infinity = 1 / (1.0 + exp(-3.3032886723507917 - 0.12180267965895249 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_m_gate__tau_m = 2.4000000000000001e-5 + 4.1999999999999998e-5 * exp(-0.78827269000771605 * pow((1 + 0.039108330074305829 * var_chaste_interface__membrane__V), 2)); // second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__Na_c = 0.0090691505932400367 + 7.848471430041313e-7 * var_chaste_interface__membrane__V - 6.993006993006993e-5 * var_chaste_interface__cleft_space_ion_concentrations__Na_c - 2.0704300494725328e-5 * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) + 1.4564283541541343e-6 * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(0.017058350483361479 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.020849095035219586 * var_chaste_interface__membrane__V)) / (1.0 + 0.00029999999999999997 * pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + 0.00029999999999999997 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) + 7.5793668809895348e-5 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037907445518581065 * var_chaste_interface__membrane__V - 1.0 * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i))) * (0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V / (-1.0 + exp(0.037907445518581065 * var_chaste_interface__membrane__V)) + 0.0027518787945713876 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (200.0 + var_chaste_interface__membrane__V) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = 2.9591556829912034e-6 + 2.8157848672826448e-6 * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) - 1.0673921144856187e-7 * var_chaste_interface__membrane__V - 1.9807425616496227e-7 * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(0.017058350483361479 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.020849095035219586 * var_chaste_interface__membrane__V)) / (1.0 + 0.00029999999999999997 * pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + 0.00029999999999999997 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) - 0.00037425551606170871 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (200.0 + var_chaste_interface__membrane__V) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))) - 1.0307938958145768e-5 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037907445518581065 * var_chaste_interface__membrane__V - 1.0 * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i))) * (0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V / (-1.0 + exp(0.037907445518581065 * var_chaste_interface__membrane__V)); // millimolar / millisecond
        const double var_sustained_outward_K_current_r_sus_gate__r_sus_infinity = 1 / (1.0 + exp(-0.53749999999999998 - 0.125 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_outward_K_current_r_sus_gate__tau_r_sus = 0.00050000000000000001 + 0.0089999999999999993 / (1.0 + exp(0.41666666666666669 + 0.083333333333333329 * var_chaste_interface__membrane__V)); // second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c = 0.00054000000000000001 - 0.0001 * var_chaste_interface__cleft_space_ion_concentrations__K_c + 1.2951486707769622e-5 * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n + 9.7136150308272163e-5 * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + 3.5616588446366462e-5 * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus + 3.8854460123308864e-5 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999) * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) / (1.0 + exp(0.20470020580033774 + 0.056861168277871597 * var_chaste_interface__membrane__V - 1.5 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i))) + 6.4757433538848112e-6 * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a / (1.0 + exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)) - 0.0018345858630475916 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (200.0 + var_chaste_interface__membrane__V) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = -1.7614021922566687e-6 * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n - 1.3210516441925016e-5 * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s - 4.843856028705839e-6 * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus - 8.8070109612833433e-7 * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a / (1.0 + exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)) - 5.2842065767700058e-6 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999) * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) / (1.0 + exp(0.20470020580033774 + 0.056861168277871597 * var_chaste_interface__membrane__V - 1.5 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i))) + 0.00024950367737447247 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (200.0 + var_chaste_interface__membrane__V) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // millimolar / millisecond
        const double var_sustained_outward_K_current_s_sus_gate__s_sus_infinity = 0.59999999999999998 + 0.40000000000000002 / (1.0 + exp(2.0 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_outward_K_current_s_sus_gate__tau_s_sus = 0.29999999999999999 + 0.047 / (1.0 + exp(6.0 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // second

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__V = -0.001 * (0.13928000000000001 * var_chaste_interface__membrane__V - 1.0378040372231492 * log(var_chaste_interface__cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 1.5986041573362213 * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) + (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n + 4.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i) + 0.037484200000000002 * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(0.017058350483361479 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.020849095035219586 * var_chaste_interface__membrane__V)) / (1.0 + 0.00029999999999999997 * pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + 0.00029999999999999997 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) + 0.5 * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a / (1.0 + exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)) + 3.0 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999) * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) / (1.0 + exp(0.20470020580033774 + 0.056861168277871597 * var_chaste_interface__membrane__V - 1.5 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i))) + 2.75 * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus + 7.5 * (-26.380041870925616 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + 6.75 * (-60.0 + var_chaste_interface__membrane__V) * ((1.0 - var_chaste_interface__intracellular_ion_concentrations__Ca_d / (0.025000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d)) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 * var_chaste_interface__intracellular_ion_concentrations__Ca_d / (0.025000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d)) * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L + 1000.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted) * mParameters[0] / HeartConfig::Instance()->GetCapacitance() + 70.825299999999999 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (200.0 + var_chaste_interface__membrane__V) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))) + 5.8521211132021298 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037907445518581065 * var_chaste_interface__membrane__V - 1.0 * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i))) * (0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V / (-1.0 + exp(0.037907445518581065 * var_chaste_interface__membrane__V))) / mParameters[0]; // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__V;
        rDY[1] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
        rAlphaOrTau[2] = 1000.0 * var_sodium_current_m_gate__tau_m;
        rBetaOrInf[2] = var_sodium_current_m_gate__m_infinity;
        rAlphaOrTau[3] = 1000.0 * var_sodium_current_h1_gate__tau_h1;
        rBetaOrInf[3] = var_sodium_current_h1_gate__h_infinity;
        rAlphaOrTau[4] = 1000.0 * var_sodium_current_h2_gate__tau_h2;
        rBetaOrInf[4] = var_sodium_current_h1_gate__h_infinity;
        rAlphaOrTau[5] = 1000.0 * var_L_type_Ca_channel_d_L_gate__tau_d_L;
        rBetaOrInf[5] = var_L_type_Ca_channel_d_L_gate__d_L_infinity;
        rAlphaOrTau[6] = 1000.0 * var_L_type_Ca_channel_f_L1_gate__tau_f_L1;
        rBetaOrInf[6] = var_L_type_Ca_channel_f_L1_gate__f_L_infinity;
        rAlphaOrTau[7] = 1000.0 * var_L_type_Ca_channel_f_L2_gate__tau_f_L2;
        rBetaOrInf[7] = var_L_type_Ca_channel_f_L1_gate__f_L_infinity;
        rAlphaOrTau[8] = 1000.0 * var_Ca_independent_transient_outward_K_current_r_gate__tau_r;
        rBetaOrInf[8] = var_Ca_independent_transient_outward_K_current_r_gate__r_infinity;
        rAlphaOrTau[9] = 1000.0 * var_Ca_independent_transient_outward_K_current_s_gate__tau_s;
        rBetaOrInf[9] = var_Ca_independent_transient_outward_K_current_s_gate__s_infinity;
        rAlphaOrTau[10] = 1000.0 * var_sustained_outward_K_current_r_sus_gate__tau_r_sus;
        rBetaOrInf[10] = var_sustained_outward_K_current_r_sus_gate__r_sus_infinity;
        rAlphaOrTau[11] = 1000.0 * var_sustained_outward_K_current_s_sus_gate__tau_s_sus;
        rBetaOrInf[11] = var_sustained_outward_K_current_s_sus_gate__s_sus_infinity;
        rAlphaOrTau[12] = 1000.0 * var_delayed_rectifier_K_currents_n_gate__tau_n;
        rBetaOrInf[12] = var_delayed_rectifier_K_currents_n_gate__n_infinity;
        rAlphaOrTau[13] = 1000.0 * var_delayed_rectifier_K_currents_pa_gate__tau_p_a;
        rBetaOrInf[13] = var_delayed_rectifier_K_currents_pa_gate__p_a_infinity;
        rDY[14] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
        rDY[15] = d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
        rDY[16] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_d;
        rDY[17] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C;
        rDY[18] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC;
        rDY[19] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC;
        rDY[20] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg;
        rDY[21] = d_dt_chaste_interface_var_cleft_space_ion_concentrations__Na_c;
        rDY[22] = d_dt_chaste_interface_var_cleft_space_ion_concentrations__Ca_c;
        rDY[23] = d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c;
        rDY[24] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel;
        rDY[25] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up;
        rDY[26] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse;
        rDY[27] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1;
        rDY[28] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2;
    }
    void Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt::ComputeOneStepExceptVoltage(const std::vector<double> &rDY, const std::vector<double> &rAlphaOrTau, const std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        
        rY[1] += mDt * rDY[1];
        rY[2] = rBetaOrInf[2] + (rY[2] - rBetaOrInf[2])*exp(-mDt/rAlphaOrTau[2]);
        rY[3] = rBetaOrInf[3] + (rY[3] - rBetaOrInf[3])*exp(-mDt/rAlphaOrTau[3]);
        rY[4] = rBetaOrInf[4] + (rY[4] - rBetaOrInf[4])*exp(-mDt/rAlphaOrTau[4]);
        rY[5] = rBetaOrInf[5] + (rY[5] - rBetaOrInf[5])*exp(-mDt/rAlphaOrTau[5]);
        rY[6] = rBetaOrInf[6] + (rY[6] - rBetaOrInf[6])*exp(-mDt/rAlphaOrTau[6]);
        rY[7] = rBetaOrInf[7] + (rY[7] - rBetaOrInf[7])*exp(-mDt/rAlphaOrTau[7]);
        rY[8] = rBetaOrInf[8] + (rY[8] - rBetaOrInf[8])*exp(-mDt/rAlphaOrTau[8]);
        rY[9] = rBetaOrInf[9] + (rY[9] - rBetaOrInf[9])*exp(-mDt/rAlphaOrTau[9]);
        rY[10] = rBetaOrInf[10] + (rY[10] - rBetaOrInf[10])*exp(-mDt/rAlphaOrTau[10]);
        rY[11] = rBetaOrInf[11] + (rY[11] - rBetaOrInf[11])*exp(-mDt/rAlphaOrTau[11]);
        rY[12] = rBetaOrInf[12] + (rY[12] - rBetaOrInf[12])*exp(-mDt/rAlphaOrTau[12]);
        rY[13] = rBetaOrInf[13] + (rY[13] - rBetaOrInf[13])*exp(-mDt/rAlphaOrTau[13]);
        rY[14] += mDt * rDY[14];
        rY[15] += mDt * rDY[15];
        rY[16] += mDt * rDY[16];
        rY[17] += mDt * rDY[17];
        rY[18] += mDt * rDY[18];
        rY[19] += mDt * rDY[19];
        rY[20] += mDt * rDY[20];
        rY[21] += mDt * rDY[21];
        rY[22] += mDt * rDY[22];
        rY[23] += mDt * rDY[23];
        rY[24] += mDt * rDY[24];
        rY[25] += mDt * rDY[25];
        rY[26] += mDt * rDY[26];
        rY[27] += mDt * rDY[27];
        rY[28] += mDt * rDY[28];
    }

    std::vector<double> Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(3);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__Cm_converted;
        dqs[2] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt>::Initialise(void)
{
    this->mSystemName = "nygren_atrial_model_1998";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-74.2525);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(6.729e-05);

    // rY[2]:
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0032017);

    // rY[3]:
    this->mVariableNames.push_back("sodium_current_h1_gate__h1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8814);

    // rY[4]:
    this->mVariableNames.push_back("sodium_current_h2_gate__h2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8742);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_L_gate__d_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.3005e-05);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_L1_gate__f_L_1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9986);

    // rY[7]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_L2_gate__f_L_2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9986);

    // rY[8]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0010678);

    // rY[9]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.949);

    // rY[10]:
    this->mVariableNames.push_back("sustained_outward_K_current_r_sus_gate__r_sus");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00015949);

    // rY[11]:
    this->mVariableNames.push_back("sustained_outward_K_current_s_sus_gate__s_sus");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9912);

    // rY[12]:
    this->mVariableNames.push_back("delayed_rectifier_K_currents_n_gate__n");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0048357);

    // rY[13]:
    this->mVariableNames.push_back("delayed_rectifier_K_currents_pa_gate__p_a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001);

    // rY[14]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.5547);

    // rY[15]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(129.435);

    // rY[16]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_d");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.2495e-05);

    // rY[17]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0275);

    // rY[18]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TC");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0133);

    // rY[19]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TMgC");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1961);

    // rY[20]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TMgMg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.7094);

    // rY[21]:
    this->mVariableNames.push_back("cleft_space_ion_concentrations__Na_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(130.011);

    // rY[22]:
    this->mVariableNames.push_back("cleft_space_ion_concentrations__Ca_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.8147);

    // rY[23]:
    this->mVariableNames.push_back("cleft_space_ion_concentrations__K_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.3581);

    // rY[24]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.6465);

    // rY[25]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.6646);

    // rY[26]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__O_Calse");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4369);

    // rY[27]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4284);

    // rY[28]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0028);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("nanoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellnygren_atrial_model_1998FromCellMLRushLarsenOpt)
