//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: kurata_model_2002
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "kurata_model_2002.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"


    Cellkurata_model_2002FromCellMLRushLarsenOpt::Cellkurata_model_2002FromCellMLRushLarsenOpt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractRushLarsenCardiacCell(
                27,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellkurata_model_2002FromCellMLRushLarsenOpt>::Instance();
        Init();
        
        this->mParameters[0] = 32.0; // (var_membrane__Cm) [picoF]
    }

    Cellkurata_model_2002FromCellMLRushLarsenOpt::~Cellkurata_model_2002FromCellMLRushLarsenOpt()
    {
    }
    
    double Cellkurata_model_2002FromCellMLRushLarsenOpt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__L_type_calcium_channel_current_d_gate__d = rY[1];
        // Units: dimensionless; Initial value: 0.000602055134
        double var_chaste_interface__L_type_calcium_channel_current_f_gate__f = rY[2];
        // Units: dimensionless; Initial value: 0.626999773853
        double var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa = rY[3];
        // Units: dimensionless; Initial value: 0.589580408056
        double var_chaste_interface__T_type_calcium_channel_current_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 0.004571884917
        double var_chaste_interface__T_type_calcium_channel_current_f_gate__f = rY[5];
        // Units: dimensionless; Initial value: 0.249637570396
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = rY[6];
        // Units: dimensionless; Initial value: 0.629323128348
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = rY[7];
        // Units: dimensionless; Initial value: 0.3493633709533
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = rY[8];
        // Units: dimensionless; Initial value: 0.852396631172
        double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = rY[9];
        // Units: dimensionless; Initial value: 0.054409723782
        double var_chaste_interface__AP_sensitive_currents_q_gate__q = rY[10];
        // Units: dimensionless; Initial value: 0.531446952485
        double var_chaste_interface__AP_sensitive_currents_r_gate__r = rY[11];
        // Units: dimensionless; Initial value: 0.005550489445
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[12];
        // Units: dimensionless; Initial value: 0.067156687129
        double var_chaste_interface__sustained_inward_current_qa_gate__qa = rY[13];
        // Units: dimensionless; Initial value: 0.426018100136
        double var_chaste_interface__sustained_inward_current_qi_gate__qi = rY[14];
        // Units: dimensionless; Initial value: 0.333330378068
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
        // Units: millimolar; Initial value: 9.438646305915
        double var_chaste_interface__intracellular_ion_concentrations__Ki = rY[20];
        // Units: millimolar; Initial value: 139.984146485614
        
        const double var_L_type_calcium_channel_current__i_CaL = 0.57999999999999996 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_channel_current_d_gate__d * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa * var_chaste_interface__L_type_calcium_channel_current_f_gate__f; // picoA
        const double var_T_type_calcium_channel_current__i_CaT = 0.45800000000000002 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_calcium_channel_current_d_gate__d * var_chaste_interface__T_type_calcium_channel_current_f_gate__f; // picoA
        const double var_background_muscarinic_potassium_channel_current__i_K_ACh = 0.0021962113249247841 * var_chaste_interface__intracellular_ion_concentrations__Ki - 0.011859541154593834 * exp(-0.037415977988011655 * var_chaste_interface__membrane__V); // picoA
        const double var_reversal_potentials__E_K = 26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki); // millivolt
        const double var_AP_sensitive_currents__i_sus = 0.02 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_AP_sensitive_currents__i_to = 0.17999999999999999 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr = 0.067616443970885107 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (0.40000000000000002 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + 0.59999999999999998 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF) * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy; // picoA
        const double var_reversal_potentials__E_Na = 26.726549826397882 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai); // millivolt
        const double var_hyperpolarisation_activated_current__i_h = 0.14373749999999999 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) + 0.23126250000000001 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V); // picoA
        const double var_slowly_activating_delayed_rectifier_potassium_current__i_Ks = 0.025899999999999999 * pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2) * (-26.726549826397882 * log(22.199999999999999 / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.12 * var_chaste_interface__intracellular_ion_concentrations__Nai)) + var_chaste_interface__membrane__V); // picoA
        const double var_sodium_calcium_exchange_current__Qco = 0; // dimensionless
        const double var_sodium_calcium_exchange_current__di = 1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai; // dimensionless
        const double var_sodium_calcium_exchange_current__do = 4.8791826399715319 + 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco); // dimensionless
        const double var_sodium_calcium_exchange_current__k12 = 48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k14 = 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k21 = 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k23 = 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k32 = exp(0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k41 = exp(-0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k43 = var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai); // dimensionless
        const double var_sodium_calcium_exchange_current__i_NaCa = 125.0 * (((0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 - (0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12) / (0.96776646412697098 * (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k23 + 0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k21 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k23 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32); // picoA
        const double var_sodium_dependent_background_current__i_b_Na = 0.0054000000000000003 * var_chaste_interface__membrane__V - 0.0054000000000000003 * var_reversal_potentials__E_Na; // picoA
        const double var_sodium_potassium_pump_current__i_NaK = 3.0052188053939588 / ((1.0 + 30.900566853219949 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Nai, 1.3)) * (1.0 + exp(-4.0 + 0.033333333333333333 * var_reversal_potentials__E_Na - 0.033333333333333333 * var_chaste_interface__membrane__V))); // picoA
        const double var_sustained_inward_current__i_st = 0.014999999999999999 * (-37.399999999999999 + var_chaste_interface__membrane__V) * var_chaste_interface__sustained_inward_current_qa_gate__qa * var_chaste_interface__sustained_inward_current_qi_gate__qi; // picoA
        const double var_chaste_interface__i_ionic = (var_AP_sensitive_currents__i_sus + var_AP_sensitive_currents__i_to + var_L_type_calcium_channel_current__i_CaL + var_T_type_calcium_channel_current__i_CaT + var_background_muscarinic_potassium_channel_current__i_K_ACh + var_hyperpolarisation_activated_current__i_h + var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr + var_slowly_activating_delayed_rectifier_potassium_current__i_Ks + var_sodium_calcium_exchange_current__i_NaCa + var_sodium_dependent_background_current__i_b_Na + var_sodium_potassium_pump_current__i_NaK + var_sustained_inward_current__i_st) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellkurata_model_2002FromCellMLRushLarsenOpt::EvaluateEquations(double var_chaste_interface__environment__time, std::vector<double> &rDY, std::vector<double> &rAlphaOrTau, std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__L_type_calcium_channel_current_d_gate__d = rY[1];
        // Units: dimensionless; Initial value: 0.000602055134
        double var_chaste_interface__L_type_calcium_channel_current_f_gate__f = rY[2];
        // Units: dimensionless; Initial value: 0.626999773853
        double var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa = rY[3];
        // Units: dimensionless; Initial value: 0.589580408056
        double var_chaste_interface__T_type_calcium_channel_current_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 0.004571884917
        double var_chaste_interface__T_type_calcium_channel_current_f_gate__f = rY[5];
        // Units: dimensionless; Initial value: 0.249637570396
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = rY[6];
        // Units: dimensionless; Initial value: 0.629323128348
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = rY[7];
        // Units: dimensionless; Initial value: 0.3493633709533
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = rY[8];
        // Units: dimensionless; Initial value: 0.852396631172
        double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = rY[9];
        // Units: dimensionless; Initial value: 0.054409723782
        double var_chaste_interface__AP_sensitive_currents_q_gate__q = rY[10];
        // Units: dimensionless; Initial value: 0.531446952485
        double var_chaste_interface__AP_sensitive_currents_r_gate__r = rY[11];
        // Units: dimensionless; Initial value: 0.005550489445
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[12];
        // Units: dimensionless; Initial value: 0.067156687129
        double var_chaste_interface__sustained_inward_current_qa_gate__qa = rY[13];
        // Units: dimensionless; Initial value: 0.426018100136
        double var_chaste_interface__sustained_inward_current_qi_gate__qi = rY[14];
        // Units: dimensionless; Initial value: 0.333330378068
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[15];
        // Units: millimolar; Initial value: 0.000312494921
        double var_chaste_interface__intracellular_ion_concentrations__Ca_up = rY[16];
        // Units: millimolar; Initial value: 1.462338380106
        double var_chaste_interface__intracellular_ion_concentrations__Ca_rel = rY[17];
        // Units: millimolar; Initial value: 0.296742023718
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
        // Units: millimolar; Initial value: 9.438646305915
        double var_chaste_interface__intracellular_ion_concentrations__Ki = rY[20];
        // Units: millimolar; Initial value: 139.984146485614
        double var_chaste_interface__calcium_buffering__fTMM = rY[21];
        // Units: millimolar; Initial value: 0.350600895635
        double var_chaste_interface__calcium_buffering__fCMi = rY[22];
        // Units: millimolar; Initial value: 0.116947220413
        double var_chaste_interface__calcium_buffering__fCMs = rY[23];
        // Units: millimolar; Initial value: 0.074631965653
        double var_chaste_interface__calcium_buffering__fTC = rY[24];
        // Units: millimolar; Initial value: 0.059206293446
        double var_chaste_interface__calcium_buffering__fTMC = rY[25];
        // Units: millimolar; Initial value: 0.602955114871
        double var_chaste_interface__calcium_buffering__fCQ = rY[26];
        // Units: millimolar; Initial value: 0.260317260703

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double d_dt_chaste_interface_var_calcium_buffering__fCQ = -0.44500000000000001 * var_chaste_interface__calcium_buffering__fCQ + 0.53400000000000003 * (1.0 - var_chaste_interface__calcium_buffering__fCQ) * var_chaste_interface__intracellular_ion_concentrations__Ca_rel; // millimolar / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_channel_current_fCa_gate__fCa = (0.021000000000000001 + 60.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub) * (-var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa + 0.00035 / (0.00035 + var_chaste_interface__intracellular_ion_concentrations__Ca_sub)); // 1 / millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fCMs = -0.54200000000000004 * var_chaste_interface__calcium_buffering__fCMs + 227.69999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fCMs) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_rel = 4.4500000000000002 * var_chaste_interface__calcium_buffering__fCQ + 0.016666666666666666 * var_chaste_interface__intracellular_ion_concentrations__Ca_up - 0.016666666666666666 * var_chaste_interface__intracellular_ion_concentrations__Ca_rel - 0.5 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_sub + var_chaste_interface__intracellular_ion_concentrations__Ca_rel) / (1.0 + 1.4399999999999998e-6 / pow(var_chaste_interface__intracellular_ion_concentrations__Ca_sub, 2)) - 5.3399999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fCQ) * var_chaste_interface__intracellular_ion_concentrations__Ca_rel; // millimolar / millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fCMi = -0.54200000000000004 * var_chaste_interface__calcium_buffering__fCMi + 227.69999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fCMi) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar / millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fTC = -0.44600000000000001 * var_chaste_interface__calcium_buffering__fTC + 88.799999999999997 * (1.0 - var_chaste_interface__calcium_buffering__fTC) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar / millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fTMC = -0.0075100000000000002 * var_chaste_interface__calcium_buffering__fTMC + 227.69999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fTMC - var_chaste_interface__calcium_buffering__fTMM) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar / millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fTMM = 5.6925000000000008 - 5.6925000000000008 * var_chaste_interface__calcium_buffering__fTMC - 6.4435000000000002 * var_chaste_interface__calcium_buffering__fTMM; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_up = 0.0050000000000000001 / (1.0 + 0.00059999999999999995 / var_chaste_interface__intracellular_ion_concentrations__Cai) + 0.0017241196262903437 * var_chaste_interface__intracellular_ion_concentrations__Ca_rel - 0.0017241196262903437 * var_chaste_interface__intracellular_ion_concentrations__Ca_up; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Cai = 0.024390000000000002 * var_chaste_interface__calcium_buffering__fCMi + 0.55412061888222286 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.013826 * var_chaste_interface__calcium_buffering__fTC + 0.00046562000000000003 * var_chaste_interface__calcium_buffering__fTMC - 0.00012887906536154087 / (1.0 + 0.00059999999999999995 / var_chaste_interface__intracellular_ion_concentrations__Cai) - 0.55412061888222286 * var_chaste_interface__intracellular_ion_concentrations__Cai - 10.246499999999999 * (1.0 - var_chaste_interface__calcium_buffering__fCMi) * var_chaste_interface__intracellular_ion_concentrations__Cai - 2.7527999999999997 * (1.0 - var_chaste_interface__calcium_buffering__fTC) * var_chaste_interface__intracellular_ion_concentrations__Cai - 14.1174 * (1.0 - var_chaste_interface__calcium_buffering__fTMC - var_chaste_interface__calcium_buffering__fTMM) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar / millisecond
        const double var_AP_sensitive_currents_q_gate__q_infinity = 1 / (1.0 + exp(3.7692307692307692 + 0.076923076923076927 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_AP_sensitive_currents_q_gate__tau_q = 6.0599999999999996 + 39.101999999999997 / (0.065000000000000002 * exp(4.593 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 0.56999999999999995 * exp(-3.52 - 0.080000000000000002 * var_chaste_interface__membrane__V)); // millisecond
        const double var_AP_sensitive_currents_r_gate__r_infinity = 1 / (1.0 + exp(1.2866666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_AP_sensitive_currents_r_gate__tau_r = 2.75352 + 14.40516 / (1.0369999999999999 * exp(2.7548999999999997 + 0.089999999999999997 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8607999999999998 - 0.12 * var_chaste_interface__membrane__V)); // millisecond
        const double var_L_type_calcium_channel_current_d_gate__d_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_calcium_channel_current_d_gate__tau_d = 1 / (0.011429999999999999 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)) - 0.028389999999999999 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V)) - 0.084900000000000003 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20798668885191349 * var_chaste_interface__membrane__V))); // millisecond
        const double var_L_type_calcium_channel_current_f_gate__f_infinity = 1 / (1.0 + exp(6.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_calcium_channel_current_f_gate__tau_f = 44.299999999999997 + 257.10000000000002 * exp(-5.4668495419491743 * pow((1 + 0.030769230769230771 * var_chaste_interface__membrane__V), 2)); // millisecond
        const double var_T_type_calcium_channel_current_d_gate__d_infinity = 1 / (1.0 + exp(-4.3833333333333337 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_calcium_channel_current_d_gate__tau_d = 1 / (1.0680000000000001 * exp(0.87666666666666671 + 0.033333333333333333 * var_chaste_interface__membrane__V) + 1.0680000000000001 * exp(-0.87666666666666671 - 0.033333333333333333 * var_chaste_interface__membrane__V)); // millisecond
        const double var_T_type_calcium_channel_current_f_gate__f_infinity = 1 / (1.0 + exp(11.017857142857144 + 0.17857142857142858 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_calcium_channel_current_f_gate__tau_f = 1 / (0.014999999999999999 * exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V) + 0.015299999999999999 * exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V)); // millisecond
        const double var_hyperpolarisation_activated_current_y_gate__tau_y = 0.71665290000000004 / (exp(-8.5404617897664554 - 0.022074080614542406 * var_chaste_interface__membrane__V) + exp(-3.8001143986272159 + 0.051999376007487906 * var_chaste_interface__membrane__V)); // millisecond
        const double var_hyperpolarisation_activated_current_y_gate__y_infinity = 1 / (1.0 + exp(4.7407407407407405 + 0.07407407407407407 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity = 1 / (1.0 + exp(-2.1886792452830188 - 0.094339622641509441 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__tau_paF = 0.84655354000000005 / (0.037199999999999997 * exp(0.062893081761006289 * var_chaste_interface__membrane__V) + 0.00096000000000000002 * exp(-0.044444444444444446 * var_chaste_interface__membrane__V)); // millisecond
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__tau_paS = 0.84655354000000005 / (0.0041999999999999997 * exp(0.058823529411764705 * var_chaste_interface__membrane__V) + 0.00014999999999999999 * exp(-0.046296296296296294 * var_chaste_interface__membrane__V)); // millisecond
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__pi_infinity = 1 / (1.0 + exp(1.672514619883041 + 0.058479532163742687 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__tau_pi = 1 / (0.10000000000000001 * exp(-0.018299935950224173 * var_chaste_interface__membrane__V) + 0.65600000000000003 * exp(0.009420009985210585 * var_chaste_interface__membrane__V)); // millisecond
        const double var_slowly_activating_delayed_rectifier_potassium_current_n_gate__n_infinity = 0.014 / ((1.0 + exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V)) * (0.001 * exp(-0.022222222222222223 * var_chaste_interface__membrane__V) + 0.014 / (1.0 + exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V)))); // dimensionless
        const double var_slowly_activating_delayed_rectifier_potassium_current_n_gate__tau_n = 1 / (0.001 * exp(-0.022222222222222223 * var_chaste_interface__membrane__V) + 0.014 / (1.0 + exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V))); // millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_sub = 0.024390000000000002 * var_chaste_interface__calcium_buffering__fCMs + 25.0 * var_chaste_interface__intracellular_ion_concentrations__Cai - 25.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.00014764809009680174 * (250.0 * (0.54600054600054604 * ((48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) * var_chaste_interface__intracellular_ion_concentrations__Nai * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + 48.309178743961354 * (0.96776646412697098 + exp(0.0080724972509135153 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) * exp(0) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) - 48.309178743961354 * (0.96776646412697098 * (0.54600054600054604 * exp(0) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0))) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) + 0.54600054600054604 * (var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + exp(-0.0080724972509135153 * var_chaste_interface__membrane__V)) * exp(0) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0))) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) / (0.96776646412697098 * (0.54600054600054604 * exp(0) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0))) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) + 0.64386064857757164 * (48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + (48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) * var_chaste_interface__intracellular_ion_concentrations__Nai * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.54600054600054604 * (var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + exp(-0.0080724972509135153 * var_chaste_interface__membrane__V)) * exp(0) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + 48.309178743961354 * (0.96776646412697098 + exp(0.0080724972509135153 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * (0.54600054600054604 * exp(0) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0))) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / ((26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) * (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) + 32.140377158446256 * (var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + exp(-0.0080724972509135153 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / ((4.8791826399715319 + 0.54600054600054604 * exp(0)) * (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) + 0.00060342106912241779 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * (0.96776646412697098 + exp(0.0080724972509135153 * var_chaste_interface__membrane__V)) * exp(0) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / ((4.8791826399715319 + 0.54600054600054604 * exp(0)) * (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai))) - 0.45800000000000002 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_calcium_channel_current_d_gate__d * var_chaste_interface__T_type_calcium_channel_current_f_gate__f - 0.57999999999999996 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_channel_current_d_gate__d * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa * var_chaste_interface__L_type_calcium_channel_current_f_gate__f) * mParameters[0] + 0.060150151005755319 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_sub + var_chaste_interface__intracellular_ion_concentrations__Ca_rel) / (1.0 + 1.4399999999999998e-6 / pow(var_chaste_interface__intracellular_ion_concentrations__Ca_sub, 2)) - 10.246499999999999 * (1.0 - var_chaste_interface__calcium_buffering__fCMs) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ki = 6.4032609285536579e-6 * (0.011859541154593834 * exp(-0.037415977988011655 * var_chaste_interface__membrane__V) - 0.0021962113249247841 * var_chaste_interface__intracellular_ion_concentrations__Ki + 6.0104376107879176 / ((1.0 + 30.900566853219949 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Nai, 1.3)) * (1.0 + exp(-4.0 + 0.89088499421326284 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai) - 0.033333333333333333 * var_chaste_interface__membrane__V))) - 0.025899999999999999 * pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2) * (-26.726549826397882 * log(22.199999999999999 / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.12 * var_chaste_interface__intracellular_ion_concentrations__Nai)) + var_chaste_interface__membrane__V) - 0.02 * (-26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_r_gate__r - 0.23126250000000001 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki) + var_chaste_interface__membrane__V) - 0.17999999999999999 * (-26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r - 0.067616443970885107 * (0.40000000000000002 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + 0.59999999999999998 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF) * (-26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy) * mParameters[0]; // millimolar / millisecond
        const double var_sustained_inward_current_qa_gate__qa_infinity = 1 / (1.0 + exp(-11.4 - 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_inward_current_qa_gate__tau_qa = 1 / (1 / (16.0 * exp(0.125 * var_chaste_interface__membrane__V) + 15.0 * exp(0.02 * var_chaste_interface__membrane__V)) + 1 / (0.20000000000000001 * exp(-0.0014285714285714286 * var_chaste_interface__membrane__V) + 0.14999999999999999 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V))); // millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Nai = 6.4032609285536579e-6 * (0.14432336906254858 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai) - 0.0054000000000000003 * var_chaste_interface__membrane__V - 375.0 * (0.54600054600054604 * ((48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) * var_chaste_interface__intracellular_ion_concentrations__Nai * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + 48.309178743961354 * (0.96776646412697098 + exp(0.0080724972509135153 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) * exp(0) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) - 48.309178743961354 * (0.96776646412697098 * (0.54600054600054604 * exp(0) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0))) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) + 0.54600054600054604 * (var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + exp(-0.0080724972509135153 * var_chaste_interface__membrane__V)) * exp(0) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0))) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) / (0.96776646412697098 * (0.54600054600054604 * exp(0) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0))) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) + 0.64386064857757164 * (48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + (48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) * var_chaste_interface__intracellular_ion_concentrations__Nai * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.54600054600054604 * (var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + exp(-0.0080724972509135153 * var_chaste_interface__membrane__V)) * exp(0) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + 48.309178743961354 * (0.96776646412697098 + exp(0.0080724972509135153 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * (0.54600054600054604 * exp(0) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0))) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / ((26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) * (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) + 32.140377158446256 * (var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + exp(-0.0080724972509135153 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / ((4.8791826399715319 + 0.54600054600054604 * exp(0)) * (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) + 0.00060342106912241779 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * (0.96776646412697098 + exp(0.0080724972509135153 * var_chaste_interface__membrane__V)) * exp(0) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / ((4.8791826399715319 + 0.54600054600054604 * exp(0)) * (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai))) - 0.14373749999999999 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-26.726549826397882 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai) + var_chaste_interface__membrane__V) - 9.0156564161818764 / ((1.0 + 30.900566853219949 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Nai, 1.3)) * (1.0 + exp(-4.0 + 0.89088499421326284 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai) - 0.033333333333333333 * var_chaste_interface__membrane__V))) - 0.014999999999999999 * (-37.399999999999999 + var_chaste_interface__membrane__V) * var_chaste_interface__sustained_inward_current_qa_gate__qa * var_chaste_interface__sustained_inward_current_qi_gate__qi) * mParameters[0]; // millimolar / millisecond
        const double var_sustained_inward_current_qi_gate__qi_infinity = 1 / ((700.0 * exp(0.014285714285714285 * var_chaste_interface__membrane__V) + 3100.0 * exp(0.076923076923076927 * var_chaste_interface__membrane__V)) * (1 / (50.0 * exp(-0.0014285714285714286 * var_chaste_interface__membrane__V) + 95.0 * exp(-0.10000000000000001 * var_chaste_interface__membrane__V)) + 1 / (700.0 * exp(0.014285714285714285 * var_chaste_interface__membrane__V) + 3100.0 * exp(0.076923076923076927 * var_chaste_interface__membrane__V)) + 0.00022900000000000001 / (1.0 + exp(-0.20000000000000001 * var_chaste_interface__membrane__V)))); // dimensionless
        const double var_sustained_inward_current_qi_gate__tau_qi = 6.6500000000000004 / (1 / (50.0 * exp(-0.0014285714285714286 * var_chaste_interface__membrane__V) + 95.0 * exp(-0.10000000000000001 * var_chaste_interface__membrane__V)) + 1 / (700.0 * exp(0.014285714285714285 * var_chaste_interface__membrane__V) + 3100.0 * exp(0.076923076923076927 * var_chaste_interface__membrane__V)) + 0.00022900000000000001 / (1.0 + exp(-0.20000000000000001 * var_chaste_interface__membrane__V))); // millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__V = 0.14432336906254858 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.011859541154593834 * exp(-0.037415977988011655 * var_chaste_interface__membrane__V) - 0.0054000000000000003 * var_chaste_interface__membrane__V - 0.0021962113249247841 * var_chaste_interface__intracellular_ion_concentrations__Ki - 125.0 * (0.54600054600054604 * ((48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) * var_chaste_interface__intracellular_ion_concentrations__Nai * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + 48.309178743961354 * (0.96776646412697098 + exp(0.0080724972509135153 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) * exp(0) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) - 48.309178743961354 * (0.96776646412697098 * (0.54600054600054604 * exp(0) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0))) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) + 0.54600054600054604 * (var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + exp(-0.0080724972509135153 * var_chaste_interface__membrane__V)) * exp(0) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0))) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) / (0.96776646412697098 * (0.54600054600054604 * exp(0) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0))) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) + 0.64386064857757164 * (48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + (48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) * var_chaste_interface__intracellular_ion_concentrations__Nai * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.54600054600054604 * (var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + exp(-0.0080724972509135153 * var_chaste_interface__membrane__V)) * exp(0) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + 48.309178743961354 * (0.96776646412697098 + exp(0.0080724972509135153 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) + 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * (0.54600054600054604 * exp(0) / (4.8791826399715319 + 0.54600054600054604 * exp(0)) + 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / (4.8791826399715319 + 0.54600054600054604 * exp(0))) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / ((26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) * (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) + 32.140377158446256 * (var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai) + exp(-0.0080724972509135153 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / ((4.8791826399715319 + 0.54600054600054604 * exp(0)) * (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai)) + 0.00060342106912241779 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * (0.96776646412697098 + exp(0.0080724972509135153 * var_chaste_interface__membrane__V)) * exp(0) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / ((4.8791826399715319 + 0.54600054600054604 * exp(0)) * (1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai))) - 0.025899999999999999 * pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2) * (-26.726549826397882 * log(22.199999999999999 / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.12 * var_chaste_interface__intracellular_ion_concentrations__Nai)) + var_chaste_interface__membrane__V) - 0.14373749999999999 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-26.726549826397882 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai) + var_chaste_interface__membrane__V) - 0.02 * (-26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_r_gate__r - 0.23126250000000001 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki) + var_chaste_interface__membrane__V) - 3.0052188053939588 / ((1.0 + 30.900566853219949 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Nai, 1.3)) * (1.0 + exp(-4.0 + 0.89088499421326284 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai) - 0.033333333333333333 * var_chaste_interface__membrane__V))) - 0.014999999999999999 * (-37.399999999999999 + var_chaste_interface__membrane__V) * var_chaste_interface__sustained_inward_current_qa_gate__qa * var_chaste_interface__sustained_inward_current_qi_gate__qi - 0.17999999999999999 * (-26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r - 0.45800000000000002 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_calcium_channel_current_d_gate__d * var_chaste_interface__T_type_calcium_channel_current_f_gate__f - 0.067616443970885107 * (0.40000000000000002 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + 0.59999999999999998 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF) * (-26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy - 0.57999999999999996 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_channel_current_d_gate__d * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa * var_chaste_interface__L_type_calcium_channel_current_f_gate__f; // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__V;
        rAlphaOrTau[1] = var_L_type_calcium_channel_current_d_gate__tau_d;
        rBetaOrInf[1] = var_L_type_calcium_channel_current_d_gate__d_infinity;
        rAlphaOrTau[2] = var_L_type_calcium_channel_current_f_gate__tau_f;
        rBetaOrInf[2] = var_L_type_calcium_channel_current_f_gate__f_infinity;
        rDY[3] = d_dt_chaste_interface_var_L_type_calcium_channel_current_fCa_gate__fCa;
        rAlphaOrTau[4] = var_T_type_calcium_channel_current_d_gate__tau_d;
        rBetaOrInf[4] = var_T_type_calcium_channel_current_d_gate__d_infinity;
        rAlphaOrTau[5] = var_T_type_calcium_channel_current_f_gate__tau_f;
        rBetaOrInf[5] = var_T_type_calcium_channel_current_f_gate__f_infinity;
        rAlphaOrTau[6] = var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__tau_paS;
        rBetaOrInf[6] = var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity;
        rAlphaOrTau[7] = var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__tau_paF;
        rBetaOrInf[7] = var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity;
        rAlphaOrTau[8] = var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__tau_pi;
        rBetaOrInf[8] = var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__pi_infinity;
        rAlphaOrTau[9] = var_slowly_activating_delayed_rectifier_potassium_current_n_gate__tau_n;
        rBetaOrInf[9] = var_slowly_activating_delayed_rectifier_potassium_current_n_gate__n_infinity;
        rAlphaOrTau[10] = var_AP_sensitive_currents_q_gate__tau_q;
        rBetaOrInf[10] = var_AP_sensitive_currents_q_gate__q_infinity;
        rAlphaOrTau[11] = var_AP_sensitive_currents_r_gate__tau_r;
        rBetaOrInf[11] = var_AP_sensitive_currents_r_gate__r_infinity;
        rAlphaOrTau[12] = var_hyperpolarisation_activated_current_y_gate__tau_y;
        rBetaOrInf[12] = var_hyperpolarisation_activated_current_y_gate__y_infinity;
        rAlphaOrTau[13] = var_sustained_inward_current_qa_gate__tau_qa;
        rBetaOrInf[13] = var_sustained_inward_current_qa_gate__qa_infinity;
        rAlphaOrTau[14] = var_sustained_inward_current_qi_gate__tau_qi;
        rBetaOrInf[14] = var_sustained_inward_current_qi_gate__qi_infinity;
        rDY[15] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Cai;
        rDY[16] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_up;
        rDY[17] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_rel;
        rDY[18] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_sub;
        rDY[19] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Nai;
        rDY[20] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ki;
        rDY[21] = d_dt_chaste_interface_var_calcium_buffering__fTMM;
        rDY[22] = d_dt_chaste_interface_var_calcium_buffering__fCMi;
        rDY[23] = d_dt_chaste_interface_var_calcium_buffering__fCMs;
        rDY[24] = d_dt_chaste_interface_var_calcium_buffering__fTC;
        rDY[25] = d_dt_chaste_interface_var_calcium_buffering__fTMC;
        rDY[26] = d_dt_chaste_interface_var_calcium_buffering__fCQ;
    }
    void Cellkurata_model_2002FromCellMLRushLarsenOpt::ComputeOneStepExceptVoltage(const std::vector<double> &rDY, const std::vector<double> &rAlphaOrTau, const std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        
        rY[1] = rBetaOrInf[1] + (rY[1] - rBetaOrInf[1])*exp(-mDt/rAlphaOrTau[1]);
        rY[2] = rBetaOrInf[2] + (rY[2] - rBetaOrInf[2])*exp(-mDt/rAlphaOrTau[2]);
        rY[3] += mDt * rDY[3];
        rY[4] = rBetaOrInf[4] + (rY[4] - rBetaOrInf[4])*exp(-mDt/rAlphaOrTau[4]);
        rY[5] = rBetaOrInf[5] + (rY[5] - rBetaOrInf[5])*exp(-mDt/rAlphaOrTau[5]);
        rY[6] = rBetaOrInf[6] + (rY[6] - rBetaOrInf[6])*exp(-mDt/rAlphaOrTau[6]);
        rY[7] = rBetaOrInf[7] + (rY[7] - rBetaOrInf[7])*exp(-mDt/rAlphaOrTau[7]);
        rY[8] = rBetaOrInf[8] + (rY[8] - rBetaOrInf[8])*exp(-mDt/rAlphaOrTau[8]);
        rY[9] = rBetaOrInf[9] + (rY[9] - rBetaOrInf[9])*exp(-mDt/rAlphaOrTau[9]);
        rY[10] = rBetaOrInf[10] + (rY[10] - rBetaOrInf[10])*exp(-mDt/rAlphaOrTau[10]);
        rY[11] = rBetaOrInf[11] + (rY[11] - rBetaOrInf[11])*exp(-mDt/rAlphaOrTau[11]);
        rY[12] = rBetaOrInf[12] + (rY[12] - rBetaOrInf[12])*exp(-mDt/rAlphaOrTau[12]);
        rY[13] = rBetaOrInf[13] + (rY[13] - rBetaOrInf[13])*exp(-mDt/rAlphaOrTau[13]);
        rY[14] = rBetaOrInf[14] + (rY[14] - rBetaOrInf[14])*exp(-mDt/rAlphaOrTau[14]);
        rY[15] += mDt * rDY[15];
        rY[16] += mDt * rDY[16];
        rY[17] += mDt * rDY[17];
        rY[18] += mDt * rDY[18];
        rY[19] += mDt * rDY[19];
        rY[20] += mDt * rDY[20];
        rY[21] += mDt * rDY[21];
        rY[22] += mDt * rDY[22];
        rY[23] += mDt * rDY[23];
        rY[24] += mDt * rDY[24];
        rY[25] += mDt * rDY[25];
        rY[26] += mDt * rDY[26];
    }

    std::vector<double> Cellkurata_model_2002FromCellMLRushLarsenOpt::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_membrane__Cm_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellkurata_model_2002FromCellMLRushLarsenOpt>::Initialise(void)
{
    this->mSystemName = "kurata_model_2002";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-58.600291137693);

    // rY[1]:
    this->mVariableNames.push_back("L_type_calcium_channel_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000602055134);

    // rY[2]:
    this->mVariableNames.push_back("L_type_calcium_channel_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.626999773853);

    // rY[3]:
    this->mVariableNames.push_back("L_type_calcium_channel_current_fCa_gate__fCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.589580408056);

    // rY[4]:
    this->mVariableNames.push_back("T_type_calcium_channel_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004571884917);

    // rY[5]:
    this->mVariableNames.push_back("T_type_calcium_channel_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.249637570396);

    // rY[6]:
    this->mVariableNames.push_back("rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.629323128348);

    // rY[7]:
    this->mVariableNames.push_back("rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3493633709533);

    // rY[8]:
    this->mVariableNames.push_back("rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.852396631172);

    // rY[9]:
    this->mVariableNames.push_back("slowly_activating_delayed_rectifier_potassium_current_n_gate__n");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.054409723782);

    // rY[10]:
    this->mVariableNames.push_back("AP_sensitive_currents_q_gate__q");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.531446952485);

    // rY[11]:
    this->mVariableNames.push_back("AP_sensitive_currents_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.005550489445);

    // rY[12]:
    this->mVariableNames.push_back("hyperpolarisation_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.067156687129);

    // rY[13]:
    this->mVariableNames.push_back("sustained_inward_current_qa_gate__qa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.426018100136);

    // rY[14]:
    this->mVariableNames.push_back("sustained_inward_current_qi_gate__qi");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.333330378068);

    // rY[15]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Cai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.000312494921);

    // rY[16]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.462338380106);

    // rY[17]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.296742023718);

    // rY[18]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_sub");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00019074741);

    // rY[19]:
    this->mVariableNames.push_back("cytosolic_sodium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.438646305915);

    // rY[20]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(139.984146485614);

    // rY[21]:
    this->mVariableNames.push_back("calcium_buffering__fTMM");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.350600895635);

    // rY[22]:
    this->mVariableNames.push_back("calcium_buffering__fCMi");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.116947220413);

    // rY[23]:
    this->mVariableNames.push_back("calcium_buffering__fCMs");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.074631965653);

    // rY[24]:
    this->mVariableNames.push_back("calcium_buffering__fTC");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.059206293446);

    // rY[25]:
    this->mVariableNames.push_back("calcium_buffering__fTMC");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.602955114871);

    // rY[26]:
    this->mVariableNames.push_back("calcium_buffering__fCQ");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.260317260703);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("picoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellkurata_model_2002FromCellMLRushLarsenOpt)
