//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: hund_rudy_2004
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "hund_rudy_2004_a.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellhund_rudy_2004_aFromCellMLRushLarsenOpt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__cell__stim_amplitude_converted = -15.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__cell__stim_duration = 3.0; // ms
        const double var_chaste_interface__cell__stim_offset = 0; // ms
        const double var_chaste_interface__cell__stim_period = 1000.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__cell__stim_amplitude_converted),
                var_chaste_interface__cell__stim_duration,
                var_chaste_interface__cell__stim_period,
                var_chaste_interface__cell__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellhund_rudy_2004_aFromCellMLRushLarsenOpt::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellhund_rudy_2004_aFromCellMLRushLarsenOpt::Cellhund_rudy_2004_aFromCellMLRushLarsenOpt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractRushLarsenCardiacCell(
                29,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellhund_rudy_2004_aFromCellMLRushLarsenOpt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 1.0; // (var_ICaL__G_CaL_mult) [dimensionless]
        this->mParameters[1] = 1.0; // (var_INa__G_Na_mult) [dimensionless]
        this->mParameters[2] = 1.0; // (var_IKr__G_Kr_mult) [dimensionless]
    }

    Cellhund_rudy_2004_aFromCellMLRushLarsenOpt::~Cellhund_rudy_2004_aFromCellMLRushLarsenOpt()
    {
    }
    
    double Cellhund_rudy_2004_aFromCellMLRushLarsenOpt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__Ito2__AA = rY[17];
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        double var_chaste_interface__Na__Na_i = rY[23];
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = rY[24];
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = rY[25];
        // Units: mM; Initial value: 15.59207157178
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        const double var_Environment__tissue = 0; // dimensionless
        const double var_INaCa__ca_i_NaCa = 1.5 * var_chaste_interface__Ca__Ca_i; // mM
        const double var_INaCa__INaCa = 4.5 * (1.8 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.01310255922773 * var_chaste_interface__cell__V) - 2744000.0 * var_INaCa__ca_i_NaCa * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) / ((1.0 + 0.27000000000000002 * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) * (1.0 + 1.5624999999999999e-8 / pow(var_INaCa__ca_i_NaCa, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_INaCa__ca_i_NaCa)); // uA_per_uF
        const double var_INaK__INaK = 0.48423913043478262 / ((1.0 + 100.0 / pow(var_chaste_interface__Na__Na_i, 2)) * (1.0 + 0.1245 * exp(-0.00374358835078 * var_chaste_interface__cell__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.0374358835078 * var_chaste_interface__cell__V))); // uA_per_uF
        const double var_cell__caiont = -2.0 * var_INaCa__INaCa + 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i) + 0.0028824983370005666 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074871767015599999 * var_chaste_interface__cell__V)) * var_chaste_interface__cell__V / (-1.0 + exp(0.074871767015599999 * var_chaste_interface__cell__V)) + ((var_Environment__tissue == 0) ? (3.5108651860830804 * pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V))) : (3.5108651860830804 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] * var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)))); // uA_per_uF
        const double var_cell__clont = 0.00022499999999999999 * var_chaste_interface__cell__V + 0.00601027620873753 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 0.001444800488100033 * (-100.0 * exp(0.0374358835078 * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2__AA * var_chaste_interface__cell__V / (1.0 - exp(0.0374358835078 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_reversal_potentials__EK = 26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_reversal_potentials__ENa = 26.712338705500134 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_cell__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + 0.0064999999999999997 * pow(var_chaste_interface__INal__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * var_chaste_interface__INal__hL + pow(var_chaste_interface__INa__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * ((var_Environment__tissue == 0) ? (8.25) : (33.0)) * mParameters[1] * var_chaste_interface__INa__H * var_chaste_interface__INa__J; // uA_per_uF
        const double var_cell__kiont = -2.0 * var_INaK__INaK + 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)) + 0.51000000000000001 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)) + (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__EK) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__cell__V)))) + (0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.712338705500134 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V) * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2 + 0.013854200000000001 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * mParameters[2] * var_chaste_interface__IKr__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)) + 0.19 * pow(var_chaste_interface__Ito__ydv, 3) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv * exp(0.0033333333333333335 * var_chaste_interface__cell__V); // uA_per_uF
        const double var_chaste_interface__i_ionic = (var_cell__caiont + var_cell__clont + var_cell__kiont + var_cell__naiont) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellhund_rudy_2004_aFromCellMLRushLarsenOpt::EvaluateEquations(double var_chaste_interface__Environment__time, std::vector<double> &rDY, std::vector<double> &rAlphaOrTau, std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__Ito2__AA = rY[17];
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        double var_chaste_interface__Irel__CaMKtrap = rY[20];
        // Units: dimensionless; Initial value: 0.021123704774
        double var_chaste_interface__Irel__ro = rY[21];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Irel__ri = rY[22];
        // Units: dimensionless; Initial value: 0.862666650318
        double var_chaste_interface__Na__Na_i = rY[23];
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = rY[24];
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = rY[25];
        // Units: mM; Initial value: 15.59207157178
        double var_chaste_interface__Ca__Ca_jsr = rY[26];
        // Units: mM; Initial value: 1.737580994071
        double var_chaste_interface__Ca__Ca_nsr = rY[27];
        // Units: mM; Initial value: 1.832822335168
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265

        // Mathematics
        double d_dt_chaste_interface_var_cell__V;
        const double d_dt_chaste_interface_var_Irel__CaMKtrap = -0.00068000000000000005 * var_chaste_interface__Irel__CaMKtrap + 0.0025000000000000005 * (1.0 - var_chaste_interface__Irel__CaMKtrap) * (0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss); // 1 / ms
        const double d_dt_chaste_interface_var_Ito2__AA = 1 / (1.0 + 0.1502 / var_chaste_interface__Ca__Ca_ss) - 1.0 * var_chaste_interface__Ito2__AA; // 1 / ms
        const double var_ICaL__dpss = 9.0 - 8.0 / (1.0 + exp(-19.117647058823529 - 0.29411764705882354 * var_chaste_interface__cell__V)); // dimensionless
        const double var_ICaL__dss = 1 / (1.0 + exp(0.59347181008902072 - 0.14836795252225518 * var_chaste_interface__cell__V)); // dimensionless
        const double var_ICaL__f2ss = 0.23000000000000001 + 0.77000000000000002 / (1.0 + exp(2.4457142857142857 + 0.14285714285714285 * var_chaste_interface__cell__V)); // dimensionless
        const double var_ICaL__fss = 0.29999999999999999 + 0.69999999999999996 / (1.0 + exp(2.4457142857142857 + 0.14285714285714285 * var_chaste_interface__cell__V)); // dimensionless
        const double d_dt_chaste_interface_var_ICaL__fca = (0.14999999999999999 - var_chaste_interface__ICaL__fca + 0.55000000000000004 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss) + 0.29999999999999999 / (1.0 - 70.217303721661608 * pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)))) / (0.5 + 1 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss) + 10.0 * (0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap) / (0.14999999999999999 + 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap)); // 1 / ms
        const double var_ICaL__taud = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__cell__V) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__cell__V)); // ms
        const double var_ICaL__tauf = 1 / (0.052900000000000003 + 0.24110000000000001 * exp(-0.19019454876899997 * pow((-1 + 0.10318426646304972 * var_chaste_interface__cell__V), 2))); // ms
        const double var_ICaL__tauf2 = 1 / (0.0054000000000000003 + 0.042299999999999997 * exp(-1.20074125971556 * pow((-1 + 0.053842757610673787 * var_chaste_interface__cell__V), 2))); // ms
        const double d_dt_chaste_interface_var_ICaL__fca2 = (-var_chaste_interface__ICaL__fca2 + 1 / (1.0 - 351.08651860830804 * pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)))) / (125.0 + 300.0 / (1.0 + exp(-4.375 - 87.77162965207701 * pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V))))); // 1 / ms
        const double var_IKr__tauxr = 1 / (0.00029999999999999997 * (38.360799999999998 + var_chaste_interface__cell__V) / (-1.0 + exp(5.8385137599999997 + 0.1522 * var_chaste_interface__cell__V)) + 0.00059999999999999995 * (-1.7383999999999999 + var_chaste_interface__cell__V) / (1.0 - exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__cell__V))); // ms
        const double var_IKr__xrss = 1 / (1.0 + exp(-2.3729411764705883 - 0.23529411764705882 * var_chaste_interface__cell__V)); // dimensionless
        const double var_IKs__tauxs = 1 / (7.6100000000000007e-5 * (44.600000000000001 + var_chaste_interface__cell__V) / (1.0 - exp(-444.66200000000003 - 9.9700000000000006 * var_chaste_interface__cell__V)) + 0.00036000000000000002 * (-0.55000000000000004 + var_chaste_interface__cell__V) / (-1.0 + exp(-0.070400000000000004 + 0.128 * var_chaste_interface__cell__V))); // ms
        const double var_IKs__xss = 1 / (1.0 + exp(0.4251012145748988 - 0.04048582995951417 * var_chaste_interface__cell__V)); // dimensionless
        const double var_INa__ah = ((var_chaste_interface__cell__V >= -40.0) ? (0) : (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V))); // per_ms
        const double var_INa__aj = ((var_chaste_interface__cell__V >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__cell__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__cell__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__cell__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V)))); // per_ms
        const double var_INa__am = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double var_INa__bh = ((var_chaste_interface__cell__V >= -40.0) ? (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V))) : (310000.0 * exp(0.34999999999999998 * var_chaste_interface__cell__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__cell__V))); // per_ms
        const double var_INa__bj = ((var_chaste_interface__cell__V >= -40.0) ? (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__V))) : (0.1212 * exp(-0.01052 * var_chaste_interface__cell__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V)))); // per_ms
        const double var_INa__bm = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__cell__V); // per_ms
        const double var_INal__amL = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double var_INal__bmL = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__cell__V); // per_ms
        const double var_INal__hLss = 1 / (1.0 + exp(14.918032786885247 + 0.16393442622950821 * var_chaste_interface__cell__V)); // dimensionless
        const double d_dt_chaste_interface_var_Irel__ro = -0.33333333333333331 * var_chaste_interface__Irel__ro + 0.33333333333333331 * pow(var_chaste_interface__Ca__Ca_jsr, 1.8999999999999999) / ((1.0 + 0.00036056965579880955 * pow((-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)), 2) * pow(var_chaste_interface__ICaL__d, (-2 * var_chaste_interface__ICaL__dp)) / (pow((-1 + 0.066666666666666666 * var_chaste_interface__cell__V), 2) * pow((-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)), 2) * pow(mParameters[0], 2) * pow(var_chaste_interface__ICaL__f, 2) * pow(var_chaste_interface__ICaL__f2, 2) * pow(var_chaste_interface__ICaL__fca, 2) * pow(var_chaste_interface__ICaL__fca2, 2))) * (pow(var_chaste_interface__Ca__Ca_jsr, 1.8999999999999999) + 1644.6531773416521 * pow((var_chaste_interface__Ca__Ca_ss / (0.0028 + var_chaste_interface__Ca__Ca_ss)), 1.8999999999999999))); // 1 / ms
        const double d_dt_chaste_interface_var_Irel__ri = (-var_chaste_interface__Irel__ri + 1 / (1.0 + exp(-16.0 + 80.0 / (1.0 + exp(3.3333333333333335 + 234.05767907220539 * pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)))) + 40000.0 * var_chaste_interface__Ca__Ca_ss))) / (3.0 + (350.0 - 10.0 * (0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap) / (0.14999999999999999 + 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap)) / (1.0 + exp(-15.0 + 5000.0 * var_chaste_interface__Ca__Ca_ss + 15.0 / (1.0 + exp(3.3333333333333335 + 234.05767907220539 * pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)))))) + 10.0 * (0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap) / (0.14999999999999999 + 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap)); // 1 / ms
        const double d_dt_chaste_interface_var_Ca__Ca_jsr = (0.0083333333333333332 * var_chaste_interface__Ca__Ca_nsr - 0.0083333333333333332 * var_chaste_interface__Ca__Ca_jsr - 3000.0 * (-var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_jsr) * var_chaste_interface__Irel__ri * var_chaste_interface__Irel__ro / (1.0 + exp(2.6000000000000001 + 0.70217303721661617 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V))))) / (1.0 + 8.0 / pow((0.80000000000000004 + var_chaste_interface__Ca__Ca_jsr), 2)); // mM / ms
        const double var_Ito__ay = 25.0 * exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double var_Ito__ay2 = 0.029999999999999999 / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double var_Ito__ay3 = 0.0022499999999999998 / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double var_Ito__by = 25.0 * exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double var_Ito__by2 = 0.20000000000000001 * exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double var_Ito__by3 = 0.10000000000000001 * exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V)); // per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_nsr = 0.00072463768115942019 * var_chaste_interface__Ca__Ca_jsr - 0.0010163043478260869 * var_chaste_interface__Ca__Ca_nsr + 0.0043750000000000004 * (1.0 + 0.75 * (0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap) / (0.14999999999999999 + 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap)) * var_chaste_interface__Ca__Ca_i / (0.00092000000000000003 - 0.00017000000000000001 * (0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap) / (0.14999999999999999 + 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap) + var_chaste_interface__Ca__Ca_i); // mM / ms
        const double d_dt_chaste_interface_var_Ca__Ca_i = (0.14705882352941174 * var_chaste_interface__Ca__Ca_ss + 2.3676470588235295e-5 * var_chaste_interface__Ca__Ca_nsr - 0.14705882352941174 * var_chaste_interface__Ca__Ca_i - 1.768721357868101e-6 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i) - 8.8666719524733664e-8 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074871767015599999 * var_chaste_interface__cell__V)) * var_chaste_interface__cell__V / (-1.0 + exp(0.074871767015599999 * var_chaste_interface__cell__V)) - 0.00035514705882352943 * (1.0 + 0.75 * (0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap) / (0.14999999999999999 + 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap)) * var_chaste_interface__Ca__Ca_i / (0.00092000000000000003 - 0.00017000000000000001 * (0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap) / (0.14999999999999999 + 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap) + var_chaste_interface__Ca__Ca_i) + 0.00027684334297065928 * (1.8 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.01310255922773 * var_chaste_interface__cell__V) - 4116000.0 * var_chaste_interface__Ca__Ca_i * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) / ((1.0 + 0.27000000000000002 * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) * (1.0 + 6.9444444444444451e-9 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 6516533.0625 * var_chaste_interface__Ca__Ca_i))) / (1.0 + 0.00011900000000000002 / pow((0.0023800000000000002 + var_chaste_interface__Ca__Ca_i), 2) + 3.5000000000000004e-5 / pow((0.00050000000000000001 + var_chaste_interface__Ca__Ca_i), 2)); // mM / ms
        const double d_dt_chaste_interface_var_Ca__Ca_ss = (5.0 * var_chaste_interface__Ca__Ca_i - 5.0 * var_chaste_interface__Ca__Ca_ss + 719.99999999999989 * (-var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_jsr) * var_chaste_interface__Irel__ri * var_chaste_interface__Irel__ro / (1.0 + exp(2.6000000000000001 + 0.70217303721661617 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)))) - 0.0036718475849305066 * pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V))) / (1.0 + 0.0097788000000000007 / pow((0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss), 2) + 4.0890000000000003e-5 / pow((0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss), 2)); // mM / ms
        const double d_dt_chaste_interface_var_Cl__Cl_i = 3.6975665728975948e-7 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 1.3842167148532964e-8 * var_chaste_interface__cell__V + 7.0755999999999996e-6 * (26.712338705500134 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i)) / (87.825100000000006 + 26.712338705500134 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i)) + 5.0122473098513041 * pow((log(100.0 / var_chaste_interface__Cl__Cl_i) + log(140.0 / var_chaste_interface__Na__Na_i)), 4) / (59494197.640692554 + 509152.23122530844 * pow((log(100.0 / var_chaste_interface__Cl__Cl_i) + log(140.0 / var_chaste_interface__Na__Na_i)), 4)) + 3.0760371441184366e-5 * GetIntracellularAreaStimulus(var_chaste_interface__Environment__time) / HeartConfig::Instance()->GetCapacitance() + 8.8885199344722979e-8 * (-100.0 * exp(0.0374358835078 * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2__AA * var_chaste_interface__cell__V / (1.0 - exp(0.0374358835078 * var_chaste_interface__cell__V)); // mM / ms
        const double d_dt_chaste_interface_var_Na__Na_i = 5.0122473098513041 * pow((log(100.0 / var_chaste_interface__Cl__Cl_i) + log(140.0 / var_chaste_interface__Na__Na_i)), 4) / (59494197.640692554 + 509152.23122530844 * pow((log(100.0 / var_chaste_interface__Cl__Cl_i) + log(140.0 / var_chaste_interface__Na__Na_i)), 4)) - 8.9372253111180233e-5 / ((1.0 + 100.0 / pow(var_chaste_interface__Na__Na_i, 2)) * (1.0 + 0.1245 * exp(-0.00374358835078 * var_chaste_interface__cell__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.0374358835078 * var_chaste_interface__cell__V))) - 3.998848287353967e-7 * pow(var_chaste_interface__INal__mL, 3) * (-26.712338705500134 * log(140.0 / var_chaste_interface__Na__Na_i) + var_chaste_interface__cell__V) * var_chaste_interface__INal__hL - 0.00083053002891197785 * (1.8 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.01310255922773 * var_chaste_interface__cell__V) - 4116000.0 * var_chaste_interface__Ca__Ca_i * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) / ((1.0 + 0.27000000000000002 * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) * (1.0 + 6.9444444444444451e-9 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 6516533.0625 * var_chaste_interface__Ca__Ca_i)) - 0.00050754612877954204 * pow(var_chaste_interface__INa__m, 3) * (-26.712338705500134 * log(140.0 / var_chaste_interface__Na__Na_i) + var_chaste_interface__cell__V) * mParameters[1] * var_chaste_interface__INa__H * var_chaste_interface__INa__J; // mM / ms
        const double d_dt_chaste_interface_var_K__K_i = 7.0755999999999996e-6 * (26.712338705500134 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i)) / (87.825100000000006 + 26.712338705500134 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i)) + 5.9581502074120151e-5 / ((1.0 + 100.0 / pow(var_chaste_interface__Na__Na_i, 2)) * (1.0 + 0.1245 * exp(-0.00374358835078 * var_chaste_interface__cell__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.0374358835078 * var_chaste_interface__cell__V))) - 1.6979725035533768e-7 * (-26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)) - 3.0760371441184366e-5 * GetIntracellularAreaStimulus(var_chaste_interface__Environment__time) / HeartConfig::Instance()->GetCapacitance() - 3.137557887000805e-5 * (-26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__cell__V) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 6.370892781261781 * log(5.4000000000000004 / var_chaste_interface__K__K_i))) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 6.370892781261781 * log(5.4000000000000004 / var_chaste_interface__K__K_i))) + (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 1.6494869150646332 * log(5.4000000000000004 / var_chaste_interface__K__K_i)) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 2.1455350448257708 * log(5.4000000000000004 / var_chaste_interface__K__K_i))) / (1.0 + exp(-2.4444678999999998 + 13.738155796238718 * log(5.4000000000000004 / var_chaste_interface__K__K_i) - 0.51429999999999998 * var_chaste_interface__cell__V)))) - 8.5232067604091287e-7 * (-26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__cell__V) * mParameters[2] * var_chaste_interface__IKr__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)) - 6.1520742882368733e-5 * (0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.712338705500134 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V) * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2 - 1.1688941147650058e-5 * pow(var_chaste_interface__Ito__ydv, 3) * (-26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__cell__V) * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv * exp(0.0033333333333333335 * var_chaste_interface__cell__V); // mM / ms

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_cell__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_cell__V = -0.00022499999999999999 * var_chaste_interface__cell__V - 0.00601027620873753 * log(100.0 / var_chaste_interface__Cl__Cl_i) - 1.0 * GetIntracellularAreaStimulus(var_chaste_interface__Environment__time) / HeartConfig::Instance()->GetCapacitance() - 0.0027599999999999999 * (-26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)) - 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i) - 0.48423913043478262 / ((1.0 + 100.0 / pow(var_chaste_interface__Na__Na_i, 2)) * (1.0 + 0.1245 * exp(-0.00374358835078 * var_chaste_interface__cell__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.0374358835078 * var_chaste_interface__cell__V))) - 0.0064999999999999997 * pow(var_chaste_interface__INal__mL, 3) * (-26.712338705500134 * log(140.0 / var_chaste_interface__Na__Na_i) + var_chaste_interface__cell__V) * var_chaste_interface__INal__hL - 0.0028824983370005666 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074871767015599999 * var_chaste_interface__cell__V)) * var_chaste_interface__cell__V / (-1.0 + exp(0.074871767015599999 * var_chaste_interface__cell__V)) - 0.51000000000000001 * (-26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__cell__V) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 6.370892781261781 * log(5.4000000000000004 / var_chaste_interface__K__K_i))) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 6.370892781261781 * log(5.4000000000000004 / var_chaste_interface__K__K_i))) + (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 1.6494869150646332 * log(5.4000000000000004 / var_chaste_interface__K__K_i)) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 2.1455350448257708 * log(5.4000000000000004 / var_chaste_interface__K__K_i))) / (1.0 + exp(-2.4444678999999998 + 13.738155796238718 * log(5.4000000000000004 / var_chaste_interface__K__K_i) - 0.51429999999999998 * var_chaste_interface__cell__V)))) - (0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.712338705500134 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V) * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2 - 4.5 * (1.8 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.01310255922773 * var_chaste_interface__cell__V) - 4116000.0 * var_chaste_interface__Ca__Ca_i * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) / ((1.0 + 0.27000000000000002 * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) * (1.0 + 6.9444444444444451e-9 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 6516533.0625 * var_chaste_interface__Ca__Ca_i)) - 0.013854200000000001 * (-26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__cell__V) * mParameters[2] * var_chaste_interface__IKr__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)) - 0.001444800488100033 * (-100.0 * exp(0.0374358835078 * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2__AA * var_chaste_interface__cell__V / (1.0 - exp(0.0374358835078 * var_chaste_interface__cell__V)) - 8.25 * pow(var_chaste_interface__INa__m, 3) * (-26.712338705500134 * log(140.0 / var_chaste_interface__Na__Na_i) + var_chaste_interface__cell__V) * mParameters[1] * var_chaste_interface__INa__H * var_chaste_interface__INa__J - 0.19 * pow(var_chaste_interface__Ito__ydv, 3) * (-26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__cell__V) * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv * exp(0.0033333333333333335 * var_chaste_interface__cell__V) - 3.5108651860830804 * pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)); // mV / ms
        }
        
        rDY[0] = d_dt_chaste_interface_var_cell__V;
        rDY[1] = d_dt_chaste_interface_var_Ca__Ca_i;
        rAlphaOrTau[2] = var_INa__ah;
        rBetaOrInf[2] = var_INa__bh;
        rAlphaOrTau[3] = var_INa__am;
        rBetaOrInf[3] = var_INa__bm;
        rAlphaOrTau[4] = var_INa__aj;
        rBetaOrInf[4] = var_INa__bj;
        rAlphaOrTau[5] = var_ICaL__taud;
        rBetaOrInf[5] = var_ICaL__dss;
        rAlphaOrTau[6] = 10.0;
        rBetaOrInf[6] = var_ICaL__dpss;
        rAlphaOrTau[7] = var_ICaL__tauf;
        rBetaOrInf[7] = var_ICaL__fss;
        rDY[8] = d_dt_chaste_interface_var_ICaL__fca;
        rDY[9] = d_dt_chaste_interface_var_ICaL__fca2;
        rAlphaOrTau[10] = var_ICaL__tauf2;
        rBetaOrInf[10] = var_ICaL__f2ss;
        rAlphaOrTau[11] = var_IKr__tauxr;
        rBetaOrInf[11] = var_IKr__xrss;
        rAlphaOrTau[12] = var_IKs__tauxs;
        rBetaOrInf[12] = var_IKs__xss;
        rAlphaOrTau[13] = 2.0 * var_IKs__tauxs;
        rBetaOrInf[13] = var_IKs__xss;
        rAlphaOrTau[14] = var_Ito__ay;
        rBetaOrInf[14] = var_Ito__by;
        rAlphaOrTau[15] = var_Ito__ay2;
        rBetaOrInf[15] = var_Ito__by2;
        rAlphaOrTau[16] = var_Ito__ay3;
        rBetaOrInf[16] = var_Ito__by3;
        rDY[17] = d_dt_chaste_interface_var_Ito2__AA;
        rAlphaOrTau[18] = var_INal__amL;
        rBetaOrInf[18] = var_INal__bmL;
        rAlphaOrTau[19] = 600.0;
        rBetaOrInf[19] = var_INal__hLss;
        rDY[20] = d_dt_chaste_interface_var_Irel__CaMKtrap;
        rDY[21] = d_dt_chaste_interface_var_Irel__ro;
        rDY[22] = d_dt_chaste_interface_var_Irel__ri;
        rDY[23] = d_dt_chaste_interface_var_Na__Na_i;
        rDY[24] = d_dt_chaste_interface_var_K__K_i;
        rDY[25] = d_dt_chaste_interface_var_Cl__Cl_i;
        rDY[26] = d_dt_chaste_interface_var_Ca__Ca_jsr;
        rDY[27] = d_dt_chaste_interface_var_Ca__Ca_nsr;
        rDY[28] = d_dt_chaste_interface_var_Ca__Ca_ss;
    }
    void Cellhund_rudy_2004_aFromCellMLRushLarsenOpt::ComputeOneStepExceptVoltage(const std::vector<double> &rDY, const std::vector<double> &rAlphaOrTau, const std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        
        rY[1] += mDt * rDY[1];
        {
            const double tau_inv = rAlphaOrTau[2] + rBetaOrInf[2];
            const double y_inf = rAlphaOrTau[2] / tau_inv;
            rY[2] = y_inf + (rY[2] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[3] + rBetaOrInf[3];
            const double y_inf = rAlphaOrTau[3] / tau_inv;
            rY[3] = y_inf + (rY[3] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[4] + rBetaOrInf[4];
            const double y_inf = rAlphaOrTau[4] / tau_inv;
            rY[4] = y_inf + (rY[4] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[5] = rBetaOrInf[5] + (rY[5] - rBetaOrInf[5])*exp(-mDt/rAlphaOrTau[5]);
        rY[6] = rBetaOrInf[6] + (rY[6] - rBetaOrInf[6])*exp(-mDt/rAlphaOrTau[6]);
        rY[7] = rBetaOrInf[7] + (rY[7] - rBetaOrInf[7])*exp(-mDt/rAlphaOrTau[7]);
        rY[8] += mDt * rDY[8];
        rY[9] += mDt * rDY[9];
        rY[10] = rBetaOrInf[10] + (rY[10] - rBetaOrInf[10])*exp(-mDt/rAlphaOrTau[10]);
        rY[11] = rBetaOrInf[11] + (rY[11] - rBetaOrInf[11])*exp(-mDt/rAlphaOrTau[11]);
        rY[12] = rBetaOrInf[12] + (rY[12] - rBetaOrInf[12])*exp(-mDt/rAlphaOrTau[12]);
        rY[13] = rBetaOrInf[13] + (rY[13] - rBetaOrInf[13])*exp(-mDt/rAlphaOrTau[13]);
        {
            const double tau_inv = rAlphaOrTau[14] + rBetaOrInf[14];
            const double y_inf = rAlphaOrTau[14] / tau_inv;
            rY[14] = y_inf + (rY[14] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[15] + rBetaOrInf[15];
            const double y_inf = rAlphaOrTau[15] / tau_inv;
            rY[15] = y_inf + (rY[15] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[16] + rBetaOrInf[16];
            const double y_inf = rAlphaOrTau[16] / tau_inv;
            rY[16] = y_inf + (rY[16] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[17] += mDt * rDY[17];
        {
            const double tau_inv = rAlphaOrTau[18] + rBetaOrInf[18];
            const double y_inf = rAlphaOrTau[18] / tau_inv;
            rY[18] = y_inf + (rY[18] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[19] = rBetaOrInf[19] + (rY[19] - rBetaOrInf[19])*exp(-mDt/rAlphaOrTau[19]);
        rY[20] += mDt * rDY[20];
        rY[21] += mDt * rDY[21];
        rY[22] += mDt * rDY[22];
        rY[23] += mDt * rDY[23];
        rY[24] += mDt * rDY[24];
        rY[25] += mDt * rDY[25];
        rY[26] += mDt * rDY[26];
        rY[27] += mDt * rDY[27];
        rY[28] += mDt * rDY[28];
    }

    std::vector<double> Cellhund_rudy_2004_aFromCellMLRushLarsenOpt::ComputeDerivedQuantities(double var_chaste_interface__Environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__Environment__time;
        dqs[1] = var_cell__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellhund_rudy_2004_aFromCellMLRushLarsenOpt>::Initialise(void)
{
    this->mSystemName = "hund_rudy_2004";
    this->mFreeVariableName = "Environment__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-85.781844107117);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.00012131666);

    // rY[2]:
    this->mVariableNames.push_back("INa__H");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.987317750543);

    // rY[3]:
    this->mVariableNames.push_back("INa__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001356538159);

    // rY[4]:
    this->mVariableNames.push_back("INa__J");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.991924983076);

    // rY[5]:
    this->mVariableNames.push_back("ICaL__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.64013e-06);

    // rY[6]:
    this->mVariableNames.push_back("ICaL__dp");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.98230672628);

    // rY[7]:
    this->mVariableNames.push_back("ICaL__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999961508634);

    // rY[8]:
    this->mVariableNames.push_back("ICaL__fca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.97836624923);

    // rY[9]:
    this->mVariableNames.push_back("ICaL__fca2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.893052931249);

    // rY[10]:
    this->mVariableNames.push_back("ICaL__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.992234519148);

    // rY[11]:
    this->mVariableNames.push_back("IKr__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.24074e-06);

    // rY[12]:
    this->mVariableNames.push_back("IKs__xs1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.019883138161);

    // rY[13]:
    this->mVariableNames.push_back("IKs__xs2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.019890650554);

    // rY[14]:
    this->mVariableNames.push_back("Ito__ydv");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.013970786703);

    // rY[15]:
    this->mVariableNames.push_back("Ito__ydv2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99996472752);

    // rY[16]:
    this->mVariableNames.push_back("Ito__zdv");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.829206149767);

    // rY[17]:
    this->mVariableNames.push_back("Ito2__AA");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000816605172);

    // rY[18]:
    this->mVariableNames.push_back("INal__mL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001356538159);

    // rY[19]:
    this->mVariableNames.push_back("INal__hL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.26130711759);

    // rY[20]:
    this->mVariableNames.push_back("Irel__CaMKtrap");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.021123704774);

    // rY[21]:
    this->mVariableNames.push_back("Irel__ro");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[22]:
    this->mVariableNames.push_back("Irel__ri");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.862666650318);

    // rY[23]:
    this->mVariableNames.push_back("Na__Na_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(12.972433387269);

    // rY[24]:
    this->mVariableNames.push_back("K__K_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(135.469546216758);

    // rY[25]:
    this->mVariableNames.push_back("Cl__Cl_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(15.59207157178);

    // rY[26]:
    this->mVariableNames.push_back("Ca__Ca_jsr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.737580994071);

    // rY[27]:
    this->mVariableNames.push_back("Ca__Ca_nsr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.832822335168);

    // rY[28]:
    this->mVariableNames.push_back("Ca__Ca_ss");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.00012271265);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("Environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellhund_rudy_2004_aFromCellMLRushLarsenOpt)
