//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: dokos_model_1996
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "dokos_model_1996.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    double Celldokos_model_1996FromCellMLRushLarsenOpt::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Celldokos_model_1996FromCellMLRushLarsenOpt::Celldokos_model_1996FromCellMLRushLarsenOpt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractRushLarsenCardiacCell(
                18,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celldokos_model_1996FromCellMLRushLarsenOpt>::Instance();
        Init();
        
        this->mParameters[0] = 3.1999999999999999e-5; // (var_membrane__C) [nanoF]
    }

    Celldokos_model_1996FromCellMLRushLarsenOpt::~Celldokos_model_1996FromCellMLRushLarsenOpt()
    {
    }
    
    double Celldokos_model_1996FromCellMLRushLarsenOpt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__E = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -64.9
        double var_chaste_interface__ion_concentrations__Cai = rY[1];
        // Units: millimolar; Initial value: 3.4e-05
        double var_chaste_interface__L_type_calcium_current_d_gate__dL = rY[2];
        // Units: dimensionless; Initial value: 0.0001
        double var_chaste_interface__L_type_calcium_current_f_gate__fL = rY[3];
        // Units: dimensionless; Initial value: 0.1505
        double var_chaste_interface__L_type_calcium_current_f2_gate__fL2 = rY[4];
        // Units: dimensionless; Initial value: 0.219
        double var_chaste_interface__T_type_calcium_current_d_gate__dT = rY[5];
        // Units: dimensionless; Initial value: 0.001
        double var_chaste_interface__T_type_calcium_current_f_gate__fT = rY[6];
        // Units: dimensionless; Initial value: 0.1328
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[7];
        // Units: dimensionless; Initial value: 0.0139
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[8];
        // Units: dimensionless; Initial value: 0.0087
        double var_chaste_interface__delayed_rectifying_potassium_current_x_gate__x = rY[9];
        // Units: dimensionless; Initial value: 0.5682
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[10];
        // Units: dimensionless; Initial value: 0.0287
        double var_chaste_interface__ion_concentrations__Cao = rY[11];
        // Units: millimolar; Initial value: 2.0004
        double var_chaste_interface__ion_concentrations__Nai = rY[14];
        // Units: millimolar; Initial value: 7.4994
        double var_chaste_interface__ion_concentrations__Nao = rY[15];
        // Units: millimolar; Initial value: 139.9929
        double var_chaste_interface__ion_concentrations__Ki = rY[16];
        // Units: millimolar; Initial value: 140.0073
        double var_chaste_interface__ion_concentrations__Ko = rY[17];
        // Units: millimolar; Initial value: 5.4243
        
        const double var_reversal_potentials__E_Ca = 13.356880329847826 * log(var_chaste_interface__ion_concentrations__Cao / var_chaste_interface__ion_concentrations__Cai); // millivolt
        const double var_reversal_potentials__E_Na = 26.713760659695652 * log(var_chaste_interface__ion_concentrations__Nao / var_chaste_interface__ion_concentrations__Nai); // millivolt
        const double var_sodium_calcium_exchange_current__Qco = 0; // dimensionless
        const double var_sodium_calcium_exchange_current__di = 1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai; // dimensionless
        const double var_sodium_calcium_exchange_current__do = 1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0.037433890822745473 * var_chaste_interface__membrane__E * var_sodium_calcium_exchange_current__Qco); // dimensionless
        const double var_sodium_calcium_exchange_current__k12 = 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k14 = (0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k21 = 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(-0.037433890822745473 * var_chaste_interface__membrane__E * var_sodium_calcium_exchange_current__Qco) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k23 = (2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k32 = exp(0.0080763619450073352 * var_chaste_interface__membrane__E); // dimensionless
        const double var_sodium_calcium_exchange_current__k34 = var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao); // dimensionless
        const double var_sodium_calcium_exchange_current__k41 = exp(-0.0080763619450073352 * var_chaste_interface__membrane__E); // dimensionless
        const double var_sodium_calcium_exchange_current__k43 = var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai); // dimensionless
        const double var_membrane__i_tot = 0.00024000000000000001 * var_chaste_interface__membrane__E - 0.00024000000000000001 * var_reversal_potentials__E_Na + 4.0 * (((var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k32 + var_sodium_calcium_exchange_current__k34) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41) * var_sodium_calcium_exchange_current__k21 - ((var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k34 * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12) / ((var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k23 * var_sodium_calcium_exchange_current__k34 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k34 * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k32 + var_sodium_calcium_exchange_current__k34) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k32 + var_sodium_calcium_exchange_current__k34) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k21 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k23 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32) + 6.9999999999999994e-5 * pow(var_chaste_interface__ion_concentrations__Ko, 0.40999999999999998) * (-var_chaste_interface__ion_concentrations__Ko * exp(-0.037433890822745473 * var_chaste_interface__membrane__E) + var_chaste_interface__ion_concentrations__Ki) + 0.25 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__E) * var_chaste_interface__fast_sodium_current_h_gate__h + 0.00025999999999999998 * pow(var_chaste_interface__ion_concentrations__Ko, 0.58999999999999997) * (-var_chaste_interface__ion_concentrations__Ko * exp(-0.037433890822745473 * var_chaste_interface__membrane__E) + var_chaste_interface__ion_concentrations__Ki) * var_chaste_interface__delayed_rectifying_potassium_current_x_gate__x + 0.085000000000000006 * (75.0 - var_reversal_potentials__E_Ca + var_chaste_interface__membrane__E) * var_chaste_interface__T_type_calcium_current_d_gate__dT * var_chaste_interface__T_type_calcium_current_f_gate__fT + 9.0999999999999993e-6 * pow(var_chaste_interface__ion_concentrations__Ko, 0.58999999999999997) * (-var_chaste_interface__ion_concentrations__Nao * exp(-0.037433890822745473 * var_chaste_interface__membrane__E) + var_chaste_interface__ion_concentrations__Nai) * var_chaste_interface__delayed_rectifying_potassium_current_x_gate__x + 0.0080999999999999996 * pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__E) * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (71.36612580598495 + pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001)) + 0.40000000000000002 * (75.0 - var_reversal_potentials__E_Ca + var_chaste_interface__membrane__E) * var_chaste_interface__L_type_calcium_current_d_gate__dL * var_chaste_interface__L_type_calcium_current_f2_gate__fL2 * var_chaste_interface__L_type_calcium_current_f_gate__fL + 0.0135 * pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001) * (-26.713760659695652 * log(var_chaste_interface__ion_concentrations__Ko / var_chaste_interface__ion_concentrations__Ki) + var_chaste_interface__membrane__E) * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (71.36612580598495 + pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001)) + 0.22600000000000001 * (1.0 - 0.035938096628557313 * pow((-1 + 0.025000000000000001 * var_chaste_interface__membrane__E), 2)) * var_chaste_interface__ion_concentrations__Ko * var_chaste_interface__ion_concentrations__Nai / ((1.0 + var_chaste_interface__ion_concentrations__Ko) * (40.0 + var_chaste_interface__ion_concentrations__Nai)); // picoA
        const double var_chaste_interface__i_ionic = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_membrane__i_tot / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celldokos_model_1996FromCellMLRushLarsenOpt::EvaluateEquations(double var_chaste_interface__environment__time_converted, std::vector<double> &rDY, std::vector<double> &rAlphaOrTau, std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__E = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -64.9
        double var_chaste_interface__ion_concentrations__Cai = rY[1];
        // Units: millimolar; Initial value: 3.4e-05
        double var_chaste_interface__L_type_calcium_current_d_gate__dL = rY[2];
        // Units: dimensionless; Initial value: 0.0001
        double var_chaste_interface__L_type_calcium_current_f_gate__fL = rY[3];
        // Units: dimensionless; Initial value: 0.1505
        double var_chaste_interface__L_type_calcium_current_f2_gate__fL2 = rY[4];
        // Units: dimensionless; Initial value: 0.219
        double var_chaste_interface__T_type_calcium_current_d_gate__dT = rY[5];
        // Units: dimensionless; Initial value: 0.001
        double var_chaste_interface__T_type_calcium_current_f_gate__fT = rY[6];
        // Units: dimensionless; Initial value: 0.1328
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[7];
        // Units: dimensionless; Initial value: 0.0139
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[8];
        // Units: dimensionless; Initial value: 0.0087
        double var_chaste_interface__delayed_rectifying_potassium_current_x_gate__x = rY[9];
        // Units: dimensionless; Initial value: 0.5682
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[10];
        // Units: dimensionless; Initial value: 0.0287
        double var_chaste_interface__ion_concentrations__Cao = rY[11];
        // Units: millimolar; Initial value: 2.0004
        double var_chaste_interface__ion_concentrations__Caup = rY[12];
        // Units: millimolar; Initial value: 0.5832
        double var_chaste_interface__ion_concentrations__Carel = rY[13];
        // Units: millimolar; Initial value: 0.1101
        double var_chaste_interface__ion_concentrations__Nai = rY[14];
        // Units: millimolar; Initial value: 7.4994
        double var_chaste_interface__ion_concentrations__Nao = rY[15];
        // Units: millimolar; Initial value: 139.9929
        double var_chaste_interface__ion_concentrations__Ki = rY[16];
        // Units: millimolar; Initial value: 140.0073
        double var_chaste_interface__ion_concentrations__Ko = rY[17];
        // Units: millimolar; Initial value: 5.4243

        // Mathematics
        double d_dt_chaste_interface_var_membrane__E;
        const double var_L_type_calcium_current_d_gate__tau_dL = 0.002; // second
        const double d_dt_chaste_interface_var_L_type_calcium_current_f2_gate__fL2 = 0.0030000000000000001 - 0.0030000000000000001 * var_chaste_interface__L_type_calcium_current_f2_gate__fL2 - 40.0 * var_chaste_interface__L_type_calcium_current_f2_gate__fL2 * var_chaste_interface__ion_concentrations__Cai; // 1 / millisecond
        const double var_L_type_calcium_current_d_gate__dL_infinity = 1 / (1.0 + exp(-1.0 - 0.15151515151515152 * var_chaste_interface__membrane__E)); // dimensionless
        const double var_L_type_calcium_current_f_gate__fL_infinity = 1 / (1.0 + exp(4.166666666666667 + 0.16666666666666666 * var_chaste_interface__membrane__E)); // dimensionless
        const double var_L_type_calcium_current_f_gate__tau_fL = 0.031 + 1 / (1.0 + exp(4.6419753086419755 + 0.1234567901234568 * var_chaste_interface__membrane__E)); // second
        const double var_T_type_calcium_current_d_gate__dT_infinity = 1 / (1.0 + exp(-3.7704918032786887 - 0.16393442622950821 * var_chaste_interface__membrane__E)); // dimensionless
        const double var_T_type_calcium_current_d_gate__tau_dT = 0.00059999999999999995 + 0.0054000000000000003 / (1.0 + exp(3.0 + 0.029999999999999999 * var_chaste_interface__membrane__E)); // second
        const double var_T_type_calcium_current_f_gate__fT_infinity = 1 / (1.0 + exp(11.363636363636365 + 0.15151515151515152 * var_chaste_interface__membrane__E)); // dimensionless
        const double var_T_type_calcium_current_f_gate__tau_fT = 0.001 + 0.040000000000000001 / (1.0 + exp(5.2000000000000002 + 0.080000000000000002 * var_chaste_interface__membrane__E)); // second
        const double var_delayed_rectifying_potassium_current_x_gate__tau_x = 1 / (17.0 * exp(0.039800000000000002 * var_chaste_interface__membrane__E) + 0.21099999999999999 * exp(-0.050999999999999997 * var_chaste_interface__membrane__E)); // second
        const double var_delayed_rectifying_potassium_current_x_gate__x_infinity = 1 / (1.0 + exp(-3.3918918918918921 - 0.13513513513513511 * var_chaste_interface__membrane__E)); // dimensionless
        const double var_fast_sodium_current_h_gate__alpha_h = 32.399999999999999 * exp(-13.076000000000002 - 0.14000000000000001 * var_chaste_interface__membrane__E); // per_second
        const double var_fast_sodium_current_h_gate__beta_h = 709.0 / (1.0 + 4.2000000000000002 * exp(-2.7239999999999998 - 0.059999999999999998 * var_chaste_interface__membrane__E)); // per_second
        const double var_fast_sodium_current_m_gate__alpha_m = 200.0 * (34.299999999999997 + var_chaste_interface__membrane__E) / (1.0 - exp(-3.0869999999999997 - 0.089999999999999997 * var_chaste_interface__membrane__E)); // per_second
        const double var_fast_sodium_current_m_gate__beta_m = 8000.0 * exp(-8.4299999999999997 - 0.14999999999999999 * var_chaste_interface__membrane__E); // per_second
        const double var_hyperpolarising_activated_current_y_gate__alpha_y = 0.35999999999999999 * (137.80000000000001 + var_chaste_interface__membrane__E) / (-1.0 + exp(9.0948000000000011 + 0.066000000000000003 * var_chaste_interface__membrane__E)); // per_second
        const double var_hyperpolarising_activated_current_y_gate__beta_y = 0.10000000000000001 * (76.299999999999997 + var_chaste_interface__membrane__E) / (1.0 - exp(-16.023 - 0.20999999999999999 * var_chaste_interface__membrane__E)); // per_second
        const double d_dt_chaste_interface_var_ion_concentrations__Carel = 0.0025000000000000001 * var_chaste_interface__ion_concentrations__Caup - 0.19999999999999998 * pow(var_chaste_interface__ion_concentrations__Cai, 2) * var_chaste_interface__ion_concentrations__Carel / (9.9999999999999995e-7 + pow(var_chaste_interface__ion_concentrations__Cai, 2)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_ion_concentrations__Caup = -0.0010714285714285713 * var_chaste_interface__ion_concentrations__Caup + 0.0031388927908509588 * pow(var_chaste_interface__ion_concentrations__Cai, 2) / (2.4999999999999999e-7 + pow(var_chaste_interface__ion_concentrations__Cai, 2)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_ion_concentrations__Cai = 0.016582829838457897 * (0.27300027300027302 * (((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) - 48.309178743961354 * (((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + 0.27300027300027302 * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) / (((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + ((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + 0.27300027300027302 * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 48.309178743961354 * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + (2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * ((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / ((4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) * (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) + (0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * ((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / ((26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) + 0.27300027300027302 * (0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / ((1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) + 48.309178743961354 * (2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / ((1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai))) - 4.3944499071913426e-5 * pow(var_chaste_interface__ion_concentrations__Cai, 2) / (2.4999999999999999e-7 + pow(var_chaste_interface__ion_concentrations__Cai, 2)) + 0.0011999999999999999 * pow(var_chaste_interface__ion_concentrations__Cai, 2) * var_chaste_interface__ion_concentrations__Carel / (9.9999999999999995e-7 + pow(var_chaste_interface__ion_concentrations__Cai, 2)) - 0.00017619256703361517 * (75.0 - 13.356880329847826 * log(var_chaste_interface__ion_concentrations__Cao / var_chaste_interface__ion_concentrations__Cai) + var_chaste_interface__membrane__E) * var_chaste_interface__T_type_calcium_current_d_gate__dT * var_chaste_interface__T_type_calcium_current_f_gate__fT - 0.00082914149192289482 * (75.0 - 13.356880329847826 * log(var_chaste_interface__ion_concentrations__Cao / var_chaste_interface__ion_concentrations__Cai) + var_chaste_interface__membrane__E) * var_chaste_interface__L_type_calcium_current_d_gate__dL * var_chaste_interface__L_type_calcium_current_f2_gate__fL2 * var_chaste_interface__L_type_calcium_current_f_gate__fL; // millimolar / millisecond
        const double d_dt_chaste_interface_var_ion_concentrations__Cao = 0.02 - 0.01 * var_chaste_interface__ion_concentrations__Cao - 0.082914149192289482 * (0.27300027300027302 * (((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) - 48.309178743961354 * (((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + 0.27300027300027302 * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) / (((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + ((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + 0.27300027300027302 * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 48.309178743961354 * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + (2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * ((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / ((4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) * (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) + (0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * ((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / ((26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) + 0.27300027300027302 * (0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / ((1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) + 48.309178743961354 * (2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / ((1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai))) + 0.00088096283516807576 * (75.0 - 13.356880329847826 * log(var_chaste_interface__ion_concentrations__Cao / var_chaste_interface__ion_concentrations__Cai) + var_chaste_interface__membrane__E) * var_chaste_interface__T_type_calcium_current_d_gate__dT * var_chaste_interface__T_type_calcium_current_f_gate__fT + 0.0041457074596144743 * (75.0 - 13.356880329847826 * log(var_chaste_interface__ion_concentrations__Cao / var_chaste_interface__ion_concentrations__Cai) + var_chaste_interface__membrane__E) * var_chaste_interface__L_type_calcium_current_d_gate__dL * var_chaste_interface__L_type_calcium_current_f2_gate__fL2 * var_chaste_interface__L_type_calcium_current_f_gate__fL; // millimolar / millisecond
        const double d_dt_chaste_interface_var_ion_concentrations__Ki = -2.9019952217301315e-7 * pow(var_chaste_interface__ion_concentrations__Ko, 0.40999999999999998) * (-var_chaste_interface__ion_concentrations__Ko * exp(-0.037433890822745473 * var_chaste_interface__membrane__E) + var_chaste_interface__ion_concentrations__Ki) - 1.0778839394997632e-6 * pow(var_chaste_interface__ion_concentrations__Ko, 0.58999999999999997) * (-var_chaste_interface__ion_concentrations__Ko * exp(-0.037433890822745473 * var_chaste_interface__membrane__E) + var_chaste_interface__ion_concentrations__Ki) * var_chaste_interface__delayed_rectifying_potassium_current_x_gate__x - 5.5967050704795398e-5 * pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001) * (-26.713760659695652 * log(var_chaste_interface__ion_concentrations__Ko / var_chaste_interface__ion_concentrations__Ki) + var_chaste_interface__membrane__E) * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (71.36612580598495 + pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001)) + 0.0018738597717457423 * (1.0 - 0.035938096628557313 * pow((-1 + 0.025000000000000001 * var_chaste_interface__membrane__E), 2)) * var_chaste_interface__ion_concentrations__Ko * var_chaste_interface__ion_concentrations__Nai / ((1.0 + var_chaste_interface__ion_concentrations__Ko) * (40.0 + var_chaste_interface__ion_concentrations__Nai)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_ion_concentrations__Ko = 0.053999999999999999 - 0.01 * var_chaste_interface__ion_concentrations__Ko + 1.4509976108650656e-6 * pow(var_chaste_interface__ion_concentrations__Ko, 0.40999999999999998) * (-var_chaste_interface__ion_concentrations__Ko * exp(-0.037433890822745473 * var_chaste_interface__membrane__E) + var_chaste_interface__ion_concentrations__Ki) + 5.3894196974988154e-6 * pow(var_chaste_interface__ion_concentrations__Ko, 0.58999999999999997) * (-var_chaste_interface__ion_concentrations__Ko * exp(-0.037433890822745473 * var_chaste_interface__membrane__E) + var_chaste_interface__ion_concentrations__Ki) * var_chaste_interface__delayed_rectifying_potassium_current_x_gate__x + 0.00027983525352397697 * pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001) * (-26.713760659695652 * log(var_chaste_interface__ion_concentrations__Ko / var_chaste_interface__ion_concentrations__Ki) + var_chaste_interface__membrane__E) * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (71.36612580598495 + pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001)) - 0.0093692988587287113 * (1.0 - 0.035938096628557313 * pow((-1 + 0.025000000000000001 * var_chaste_interface__membrane__E), 2)) * var_chaste_interface__ion_concentrations__Ko * var_chaste_interface__ion_concentrations__Nai / ((1.0 + var_chaste_interface__ion_concentrations__Ko) * (40.0 + var_chaste_interface__ion_concentrations__Nai)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_ion_concentrations__Nai = 2.6579384841901423e-5 * log(var_chaste_interface__ion_concentrations__Nao / var_chaste_interface__ion_concentrations__Nai) - 9.949697903074737e-7 * var_chaste_interface__membrane__E - 0.049748489515373688 * (0.27300027300027302 * (((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) - 48.309178743961354 * (((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + 0.27300027300027302 * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) / (((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + ((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + 0.27300027300027302 * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 48.309178743961354 * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + (2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * ((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / ((4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) * (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) + (0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * ((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / ((26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) + 0.27300027300027302 * (0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / ((1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) + 48.309178743961354 * (2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / ((1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai))) - 3.7725937882491711e-8 * pow(var_chaste_interface__ion_concentrations__Ko, 0.58999999999999997) * (-var_chaste_interface__ion_concentrations__Nao * exp(-0.037433890822745473 * var_chaste_interface__membrane__E) + var_chaste_interface__ion_concentrations__Nai) * var_chaste_interface__delayed_rectifying_potassium_current_x_gate__x - 0.0010364268649036186 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(var_chaste_interface__ion_concentrations__Nao / var_chaste_interface__ion_concentrations__Nai) + var_chaste_interface__membrane__E) * var_chaste_interface__fast_sodium_current_h_gate__h - 3.3580230422877238e-5 * pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001) * (-26.713760659695652 * log(var_chaste_interface__ion_concentrations__Nao / var_chaste_interface__ion_concentrations__Nai) + var_chaste_interface__membrane__E) * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (71.36612580598495 + pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001)) - 0.0028107896576186134 * (1.0 - 0.035938096628557313 * pow((-1 + 0.025000000000000001 * var_chaste_interface__membrane__E), 2)) * var_chaste_interface__ion_concentrations__Ko * var_chaste_interface__ion_concentrations__Nai / ((1.0 + var_chaste_interface__ion_concentrations__Ko) * (40.0 + var_chaste_interface__ion_concentrations__Nai)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_ion_concentrations__Nao = 1.3999999999999999 + 4.9748489515373691e-6 * var_chaste_interface__membrane__E - 0.01 * var_chaste_interface__ion_concentrations__Nao - 0.0001328969242095071 * log(var_chaste_interface__ion_concentrations__Nao / var_chaste_interface__ion_concentrations__Nai) + 0.24874244757686842 * (0.27300027300027302 * (((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) - 48.309178743961354 * (((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + 0.27300027300027302 * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) / (((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + ((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + 0.27300027300027302 * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 48.309178743961354 * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + (2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * ((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / ((4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) * (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) + (0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * ((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / ((26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) + 0.27300027300027302 * (0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / ((1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) + 48.309178743961354 * (2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / ((1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai))) + 0.0051821343245180927 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(var_chaste_interface__ion_concentrations__Nao / var_chaste_interface__ion_concentrations__Nai) + var_chaste_interface__membrane__E) * var_chaste_interface__fast_sodium_current_h_gate__h + 1.8862968941245856e-7 * pow(var_chaste_interface__ion_concentrations__Ko, 0.58999999999999997) * (-var_chaste_interface__ion_concentrations__Nao * exp(-0.037433890822745473 * var_chaste_interface__membrane__E) + var_chaste_interface__ion_concentrations__Nai) * var_chaste_interface__delayed_rectifying_potassium_current_x_gate__x + 0.00016790115211438617 * pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001) * (-26.713760659695652 * log(var_chaste_interface__ion_concentrations__Nao / var_chaste_interface__ion_concentrations__Nai) + var_chaste_interface__membrane__E) * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (71.36612580598495 + pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001)) + 0.014053948288093067 * (1.0 - 0.035938096628557313 * pow((-1 + 0.025000000000000001 * var_chaste_interface__membrane__E), 2)) * var_chaste_interface__ion_concentrations__Ko * var_chaste_interface__ion_concentrations__Nai / ((1.0 + var_chaste_interface__ion_concentrations__Ko) * (40.0 + var_chaste_interface__ion_concentrations__Nai)); // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__E = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__E = -0.001 * (0.00024000000000000001 * var_chaste_interface__membrane__E - 0.0064113025583269565 * log(var_chaste_interface__ion_concentrations__Nao / var_chaste_interface__ion_concentrations__Nai) + 4.0 * (0.27300027300027302 * (((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) - 48.309178743961354 * (((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + 0.27300027300027302 * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) / (((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + ((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + 0.27300027300027302 * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 48.309178743961354 * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + (2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * ((0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) * var_chaste_interface__ion_concentrations__Nao * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / ((4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) * (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) + (0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * ((2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0) / (1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0))) * var_chaste_interface__ion_concentrations__Nai * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / ((26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) + 0.27300027300027302 * (0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3)) * (var_chaste_interface__ion_concentrations__Nao / (4.6630000000000003 + var_chaste_interface__ion_concentrations__Nao) + exp(0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cao * exp(0) * exp(0.0080763619450073352 * var_chaste_interface__membrane__E) / ((1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai)) + 48.309178743961354 * (2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2)) * (var_chaste_interface__ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__ion_concentrations__Nai) + exp(-0.0080763619450073352 * var_chaste_interface__membrane__E)) * var_chaste_interface__ion_concentrations__Cai * exp(-0.0080763619450073352 * var_chaste_interface__membrane__E) * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) / ((1.0 + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao + 2.3464309350494594e-7 * pow(var_chaste_interface__ion_concentrations__Nao, 3) + 0.00061425061425061424 * var_chaste_interface__ion_concentrations__Nao + 1.094140745013563e-6 * pow(var_chaste_interface__ion_concentrations__Nao, 2) + 0.27300027300027302 * var_chaste_interface__ion_concentrations__Cao * exp(0)) * (1.0 + 0.0011051656880977081 * pow(var_chaste_interface__ion_concentrations__Nai, 2) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai + 0.0025297242600556538 * var_chaste_interface__ion_concentrations__Nai + 4.1799004844845232e-5 * pow(var_chaste_interface__ion_concentrations__Nai, 3) + 48.309178743961354 * var_chaste_interface__ion_concentrations__Cai * exp(-0.0051246996536338544 * var_chaste_interface__membrane__E) + 1.8271247633873431 * var_chaste_interface__ion_concentrations__Cai * var_chaste_interface__ion_concentrations__Nai))) + 6.9999999999999994e-5 * pow(var_chaste_interface__ion_concentrations__Ko, 0.40999999999999998) * (-var_chaste_interface__ion_concentrations__Ko * exp(-0.037433890822745473 * var_chaste_interface__membrane__E) + var_chaste_interface__ion_concentrations__Ki) + 0.25 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(var_chaste_interface__ion_concentrations__Nao / var_chaste_interface__ion_concentrations__Nai) + var_chaste_interface__membrane__E) * var_chaste_interface__fast_sodium_current_h_gate__h + 0.00025999999999999998 * pow(var_chaste_interface__ion_concentrations__Ko, 0.58999999999999997) * (-var_chaste_interface__ion_concentrations__Ko * exp(-0.037433890822745473 * var_chaste_interface__membrane__E) + var_chaste_interface__ion_concentrations__Ki) * var_chaste_interface__delayed_rectifying_potassium_current_x_gate__x + 0.085000000000000006 * (75.0 - 13.356880329847826 * log(var_chaste_interface__ion_concentrations__Cao / var_chaste_interface__ion_concentrations__Cai) + var_chaste_interface__membrane__E) * var_chaste_interface__T_type_calcium_current_d_gate__dT * var_chaste_interface__T_type_calcium_current_f_gate__fT + 9.0999999999999993e-6 * pow(var_chaste_interface__ion_concentrations__Ko, 0.58999999999999997) * (-var_chaste_interface__ion_concentrations__Nao * exp(-0.037433890822745473 * var_chaste_interface__membrane__E) + var_chaste_interface__ion_concentrations__Nai) * var_chaste_interface__delayed_rectifying_potassium_current_x_gate__x + 0.0080999999999999996 * pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001) * (-26.713760659695652 * log(var_chaste_interface__ion_concentrations__Nao / var_chaste_interface__ion_concentrations__Nai) + var_chaste_interface__membrane__E) * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (71.36612580598495 + pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001)) + 0.40000000000000002 * (75.0 - 13.356880329847826 * log(var_chaste_interface__ion_concentrations__Cao / var_chaste_interface__ion_concentrations__Cai) + var_chaste_interface__membrane__E) * var_chaste_interface__L_type_calcium_current_d_gate__dL * var_chaste_interface__L_type_calcium_current_f2_gate__fL2 * var_chaste_interface__L_type_calcium_current_f_gate__fL + 0.0135 * pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001) * (-26.713760659695652 * log(var_chaste_interface__ion_concentrations__Ko / var_chaste_interface__ion_concentrations__Ki) + var_chaste_interface__membrane__E) * var_chaste_interface__hyperpolarising_activated_current_y_gate__y / (71.36612580598495 + pow(var_chaste_interface__ion_concentrations__Ko, 1.8300000000000001)) + 0.22600000000000001 * (1.0 - 0.035938096628557313 * pow((-1 + 0.025000000000000001 * var_chaste_interface__membrane__E), 2)) * var_chaste_interface__ion_concentrations__Ko * var_chaste_interface__ion_concentrations__Nai / ((1.0 + var_chaste_interface__ion_concentrations__Ko) * (40.0 + var_chaste_interface__ion_concentrations__Nai))) / mParameters[0]; // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__E;
        rDY[1] = d_dt_chaste_interface_var_ion_concentrations__Cai;
        rAlphaOrTau[2] = 1000.0 * var_L_type_calcium_current_d_gate__tau_dL;
        rBetaOrInf[2] = var_L_type_calcium_current_d_gate__dL_infinity;
        rAlphaOrTau[3] = 1000.0 * var_L_type_calcium_current_f_gate__tau_fL;
        rBetaOrInf[3] = var_L_type_calcium_current_f_gate__fL_infinity;
        rDY[4] = d_dt_chaste_interface_var_L_type_calcium_current_f2_gate__fL2;
        rAlphaOrTau[5] = 1000.0 * var_T_type_calcium_current_d_gate__tau_dT;
        rBetaOrInf[5] = var_T_type_calcium_current_d_gate__dT_infinity;
        rAlphaOrTau[6] = 1000.0 * var_T_type_calcium_current_f_gate__tau_fT;
        rBetaOrInf[6] = var_T_type_calcium_current_f_gate__fT_infinity;
        rAlphaOrTau[7] = 0.001 * var_fast_sodium_current_m_gate__alpha_m;
        rBetaOrInf[7] = 0.001 * var_fast_sodium_current_m_gate__beta_m;
        rAlphaOrTau[8] = 0.001 * var_fast_sodium_current_h_gate__alpha_h;
        rBetaOrInf[8] = 0.001 * var_fast_sodium_current_h_gate__beta_h;
        rAlphaOrTau[9] = 1000.0 * var_delayed_rectifying_potassium_current_x_gate__tau_x;
        rBetaOrInf[9] = var_delayed_rectifying_potassium_current_x_gate__x_infinity;
        rAlphaOrTau[10] = 0.001 * var_hyperpolarising_activated_current_y_gate__alpha_y;
        rBetaOrInf[10] = 0.001 * var_hyperpolarising_activated_current_y_gate__beta_y;
        rDY[11] = d_dt_chaste_interface_var_ion_concentrations__Cao;
        rDY[12] = d_dt_chaste_interface_var_ion_concentrations__Caup;
        rDY[13] = d_dt_chaste_interface_var_ion_concentrations__Carel;
        rDY[14] = d_dt_chaste_interface_var_ion_concentrations__Nai;
        rDY[15] = d_dt_chaste_interface_var_ion_concentrations__Nao;
        rDY[16] = d_dt_chaste_interface_var_ion_concentrations__Ki;
        rDY[17] = d_dt_chaste_interface_var_ion_concentrations__Ko;
    }
    void Celldokos_model_1996FromCellMLRushLarsenOpt::ComputeOneStepExceptVoltage(const std::vector<double> &rDY, const std::vector<double> &rAlphaOrTau, const std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        
        rY[1] += mDt * rDY[1];
        rY[2] = rBetaOrInf[2] + (rY[2] - rBetaOrInf[2])*exp(-mDt/rAlphaOrTau[2]);
        rY[3] = rBetaOrInf[3] + (rY[3] - rBetaOrInf[3])*exp(-mDt/rAlphaOrTau[3]);
        rY[4] += mDt * rDY[4];
        rY[5] = rBetaOrInf[5] + (rY[5] - rBetaOrInf[5])*exp(-mDt/rAlphaOrTau[5]);
        rY[6] = rBetaOrInf[6] + (rY[6] - rBetaOrInf[6])*exp(-mDt/rAlphaOrTau[6]);
        {
            const double tau_inv = rAlphaOrTau[7] + rBetaOrInf[7];
            const double y_inf = rAlphaOrTau[7] / tau_inv;
            rY[7] = y_inf + (rY[7] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[8] + rBetaOrInf[8];
            const double y_inf = rAlphaOrTau[8] / tau_inv;
            rY[8] = y_inf + (rY[8] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[9] = rBetaOrInf[9] + (rY[9] - rBetaOrInf[9])*exp(-mDt/rAlphaOrTau[9]);
        {
            const double tau_inv = rAlphaOrTau[10] + rBetaOrInf[10];
            const double y_inf = rAlphaOrTau[10] / tau_inv;
            rY[10] = y_inf + (rY[10] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[11] += mDt * rDY[11];
        rY[12] += mDt * rDY[12];
        rY[13] += mDt * rDY[13];
        rY[14] += mDt * rDY[14];
        rY[15] += mDt * rDY[15];
        rY[16] += mDt * rDY[16];
        rY[17] += mDt * rDY[17];
    }

    std::vector<double> Celldokos_model_1996FromCellMLRushLarsenOpt::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__C_converted = 0.001 * mParameters[0]; // uF

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__C_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celldokos_model_1996FromCellMLRushLarsenOpt>::Initialise(void)
{
    this->mSystemName = "dokos_model_1996";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-64.9);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(3.4e-05);

    // rY[2]:
    this->mVariableNames.push_back("L_type_calcium_current_d_gate__dL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001);

    // rY[3]:
    this->mVariableNames.push_back("L_type_calcium_current_f_gate__fL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1505);

    // rY[4]:
    this->mVariableNames.push_back("L_type_calcium_current_f2_gate__fL2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.219);

    // rY[5]:
    this->mVariableNames.push_back("T_type_calcium_current_d_gate__dT");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001);

    // rY[6]:
    this->mVariableNames.push_back("T_type_calcium_current_f_gate__fT");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1328);

    // rY[7]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0139);

    // rY[8]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0087);

    // rY[9]:
    this->mVariableNames.push_back("delayed_rectifying_potassium_current_x_gate__x");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5682);

    // rY[10]:
    this->mVariableNames.push_back("hyperpolarising_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0287);

    // rY[11]:
    this->mVariableNames.push_back("ion_concentrations__Cao");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.0004);

    // rY[12]:
    this->mVariableNames.push_back("ion_concentrations__Caup");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.5832);

    // rY[13]:
    this->mVariableNames.push_back("ion_concentrations__Carel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.1101);

    // rY[14]:
    this->mVariableNames.push_back("ion_concentrations__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.4994);

    // rY[15]:
    this->mVariableNames.push_back("ion_concentrations__Nao");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(139.9929);

    // rY[16]:
    this->mVariableNames.push_back("ion_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(140.0073);

    // rY[17]:
    this->mVariableNames.push_back("ion_concentrations__Ko");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.4243);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__C");
    this->mParameterUnits.push_back("nanoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celldokos_model_1996FromCellMLRushLarsenOpt)
