//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: decker_2009
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "decker_2009.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Celldecker_2009FromCellMLRushLarsenOpt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -80.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 0.5; // ms
        const double var_chaste_interface__membrane__stim_offset = 0; // ms
        const double var_chaste_interface__membrane__stim_period = 1000.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Celldecker_2009FromCellMLRushLarsenOpt::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Celldecker_2009FromCellMLRushLarsenOpt::Celldecker_2009FromCellMLRushLarsenOpt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractRushLarsenCardiacCell(
                48,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celldecker_2009FromCellMLRushLarsenOpt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 0.00015552; // (var_ICaL__PCa) [L_per_F_ms]
        this->mParameters[1] = 9.0749999999999993; // (var_INa__g_Na) [mS_per_uF]
        this->mParameters[2] = 0.013854200000000001; // (var_IKr__gKr_max) [mS_per_uF]
    }

    Celldecker_2009FromCellMLRushLarsenOpt::~Celldecker_2009FromCellMLRushLarsenOpt()
    {
    }
    
    double Celldecker_2009FromCellMLRushLarsenOpt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__IKs__O1 = rY[17];
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = rY[18];
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        double var_chaste_interface__Irel__Irel = rY[37];
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = rY[43];
        // Units: mM; Initial value: 6.935607
        double var_chaste_interface__Cl__Cl_i = rY[44];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = rY[46];
        // Units: mM; Initial value: 145.5689
        
        const double var_INaCa__INaCa = (6.4800000000000004 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 9878400.0 * var_chaste_interface__Ca__Ca_i * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_i)); // uA_per_uF
        const double var_INaCa__INaCa_ss_sr = (1.6200000000000001 * pow(var_chaste_interface__Na__Na_ss_sr, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 2469600.0 * var_chaste_interface__Ca__Ca_ss_sr * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_ss_sr, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_ss_sr, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr)); // uA_per_uF
        const double var_INaK__INaK = 0.062337970750628316 * pow(var_chaste_interface__Na__Na_i, 3) / (pow((1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i), 3) * (1.0 + exp(-3.4441726741524206 - 0.037436659501656748 * var_chaste_interface__membrane__Vm))); // uA_per_uF
        const double var_membrane__caiont = -2.0 * var_INaCa__INaCa - 2.0 * var_INaCa__INaCa_ss_sr + 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i) + 0.0028826178386108462 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) + 14448.603861345418 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss_CaL * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * mParameters[0] * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_membrane__clont = 0.00022499999999999999 * var_chaste_interface__membrane__Vm + 0.0060101516266440041 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 0.0032509358688027189 * (1.0 - 1.0 / (1.0 + 6.2499999999999991 * pow(var_chaste_interface__Irel__Irel, 2))) * (-100.0 * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2_i2f_gate__i2f * var_chaste_interface__membrane__Vm / (1.0 - exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_reversal_potentials__EK = 26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_reversal_potentials__ENa = 26.711785007306684 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_membrane__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaCa__INaCa_ss_sr + 3.0 * var_INaK__INaK + 0.0064999999999999997 * pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * var_chaste_interface__INaL_hL_gate__hL + 1.1558883089076335e-5 * (-140.0 + var_chaste_interface__Na__Na_i * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)) + pow(var_chaste_interface__INa_m_gate__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * mParameters[1] * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // uA_per_uF
        const double var_membrane__kiont = -2.0 * var_INaK__INaK + 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)) + (0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.711785007306684 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__membrane__Vm) * (var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2) + 0.51000000000000001 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)) + (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 0.080320000000000003 * var_reversal_potentials__EK) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 0.061749999999999999 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__membrane__Vm)))) + 1.0 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * mParameters[2] * var_chaste_interface__IKr_xr_gate__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)) + 0.4975 * pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s * exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm); // uA_per_uF
        const double var_chaste_interface__i_ionic = (var_membrane__caiont + var_membrane__clont + var_membrane__kiont + var_membrane__naiont) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celldecker_2009FromCellMLRushLarsenOpt::EvaluateEquations(double var_chaste_interface__environment__time, std::vector<double> &rDY, std::vector<double> &rAlphaOrTau, std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__IKs__C1 = rY[2];
        // Units: dimensionless; Initial value: 0.476653873938053
        double var_chaste_interface__IKs__C2 = rY[3];
        // Units: dimensionless; Initial value: 0.2551771850026437
        double var_chaste_interface__IKs__C3 = rY[4];
        // Units: dimensionless; Initial value: 0.05122852186842027
        double var_chaste_interface__IKs__C4 = rY[5];
        // Units: dimensionless; Initial value: 0.004570874421666423
        double var_chaste_interface__IKs__C5 = rY[6];
        // Units: dimensionless; Initial value: 0.0001529389211563687
        double var_chaste_interface__IKs__C6 = rY[7];
        // Units: dimensionless; Initial value: 0.1328281770413747
        double var_chaste_interface__IKs__C7 = rY[8];
        // Units: dimensionless; Initial value: 0.05333228495514583
        double var_chaste_interface__IKs__C8 = rY[9];
        // Units: dimensionless; Initial value: 0.007137874613383642
        double var_chaste_interface__IKs__C9 = rY[10];
        // Units: dimensionless; Initial value: 0.0003184390970637536
        double var_chaste_interface__IKs__C10 = rY[11];
        // Units: dimensionless; Initial value: 0.01388061042363991
        double var_chaste_interface__IKs__C11 = rY[12];
        // Units: dimensionless; Initial value: 0.003715500164470033
        double var_chaste_interface__IKs__C12 = rY[13];
        // Units: dimensionless; Initial value: 0.0002486371465457659
        double var_chaste_interface__IKs__C13 = rY[14];
        // Units: dimensionless; Initial value: 0.0006446803014431032
        double var_chaste_interface__IKs__C14 = rY[15];
        // Units: dimensionless; Initial value: 8.628258026770862e-05
        double var_chaste_interface__IKs__C15 = rY[16];
        // Units: dimensionless; Initial value: 1.122823524761588e-05
        double var_chaste_interface__IKs__O1 = rY[17];
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = rY[18];
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        double var_chaste_interface__ICaL__C = rY[19];
        // Units: dimensionless; Initial value: 0.9999613782488198
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__C_star = rY[21];
        // Units: dimensionless; Initial value: 5.936477396599124e-11
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__ICaL__CI = rY[23];
        // Units: dimensionless; Initial value: 1.587938121237188e-05
        double var_chaste_interface__ICaL__OI = rY[24];
        // Units: dimensionless; Initial value: 3.611420243201921e-10
        double var_chaste_interface__ICaL__CI_star = rY[25];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ICaL__OI_star = rY[26];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        double var_chaste_interface__Irel__Irel = rY[37];
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_JSR = rY[38];
        // Units: mM; Initial value: 0.917692717
        double var_chaste_interface__Ca__Ca_NSR = rY[39];
        // Units: mM; Initial value: 0.929835335
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = rY[43];
        // Units: mM; Initial value: 6.935607
        double var_chaste_interface__Cl__Cl_i = rY[44];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__Cl__Cl_ss = rY[45];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = rY[46];
        // Units: mM; Initial value: 145.5689
        double var_chaste_interface__CaMK_active__CaMK_trap = rY[47];
        // Units: dimensionless; Initial value: 0.0018861341

        // Mathematics
        double d_dt_chaste_interface_var_membrane__Vm;
        const double d_dt_chaste_interface_var_CaMK_active__CaMK_trap = -0.00068000000000000005 * var_chaste_interface__CaMK_active__CaMK_trap + 0.0025000000000000005 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) * (0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr); // 1 / ms
        const double var_INaL_hL_gate__tau_hL = 600.0; // ms
        const double var_Ito2_i2f_gate__tau_i2f = 8.0; // ms
        const double d_dt_chaste_interface_var_Ca__Ca_JSR = (-var_chaste_interface__Irel__Irel + 0.040000000000000001 * var_chaste_interface__Ca__Ca_NSR - 0.040000000000000001 * var_chaste_interface__Ca__Ca_JSR) / (1.0 + 8.0 / pow((0.80000000000000004 + var_chaste_interface__Ca__Ca_JSR), 2)); // mM / ms
        const double d_dt_chaste_interface_var_Ca__Ca_NSR = 0.0034782608695652171 * var_chaste_interface__Ca__Ca_JSR - 0.0037699275362318837 * var_chaste_interface__Ca__Ca_NSR + 0.0043750000000000004 * (1.0 + 0.75 * (0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap) / (0.14999999999999999 + var_chaste_interface__CaMK_active__CaMK_trap + 0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr))) * var_chaste_interface__Ca__Ca_i / (0.00092000000000000003 - 0.00017000000000000001 * (0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap) / (0.14999999999999999 + var_chaste_interface__CaMK_active__CaMK_trap + 0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr)) + var_chaste_interface__Ca__Ca_i); // mM / ms
        const double d_dt_chaste_interface_var_ICaL__C = var_chaste_interface__ICaL__C_star + (-3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)) - (0.80000000000000004 - 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))) - 1.0 / ((1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)) * (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm))))) * var_chaste_interface__ICaL__C + (1.0 - 1.0 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm))) * var_chaste_interface__ICaL__O / (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm))) + (0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))) * var_chaste_interface__ICaL__CI; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__O = var_chaste_interface__ICaL__O_star + (-3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)) - (1.0 - 1.0 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm))) / (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm))) - (0.80000000000000004 - 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)))) * var_chaste_interface__ICaL__O + (0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))) * var_chaste_interface__ICaL__OI + var_chaste_interface__ICaL__C / ((1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)) * (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)))); // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__C_star = (-1.0 - (0.99990000999900008 - 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))) - 1.0 / ((1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)) * (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm))))) * var_chaste_interface__ICaL__C_star + 3.0 * var_chaste_interface__ICaL__C / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)) + (1.0 - 1.0 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm))) * var_chaste_interface__ICaL__O_star / (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm))) + (9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))) * var_chaste_interface__ICaL__CI_star; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__O_star = (-1.0 - (1.0 - 1.0 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm))) / (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm))) - (0.99990000999900008 - 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)))))) * var_chaste_interface__ICaL__O_star + 3.0 * var_chaste_interface__ICaL__O / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)) + (9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))) * var_chaste_interface__ICaL__OI_star + var_chaste_interface__ICaL__C_star / ((1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)) * (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)))); // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__CI = 9.9999999999999995e-7 * var_chaste_interface__ICaL__CI_star + (-(0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))) - 1.0 / ((1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)) * (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)))) - 3.0000000000000001e-6 * (0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.99990000999900008 - 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) / ((1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)) * (0.80000000000000004 - 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))))) * var_chaste_interface__ICaL__CI + (1.0 - 1.0 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm))) * var_chaste_interface__ICaL__OI / (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm))) + (0.80000000000000004 - 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))) * var_chaste_interface__ICaL__C; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__CI_star = (-9.9999999999999995e-7 - (9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))) - 1.0 / ((1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)) * (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm))))) * var_chaste_interface__ICaL__CI_star + (1.0 - 1.0 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm))) * var_chaste_interface__ICaL__OI_star / (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm))) + (0.99990000999900008 - 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))) * var_chaste_interface__ICaL__C_star + 3.0000000000000001e-6 * (0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.99990000999900008 - 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * var_chaste_interface__ICaL__CI / ((1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)) * (0.80000000000000004 - 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)))); // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__OI = 9.9999999999999995e-7 * var_chaste_interface__ICaL__OI_star + (-(1.0 - 1.0 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm))) / (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm))) - (0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))) - 3.0000000000000001e-6 * (0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.99990000999900008 - 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) / ((1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)) * (0.80000000000000004 - 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))))) * var_chaste_interface__ICaL__OI + (0.80000000000000004 - 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))) * var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__CI / ((1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)) * (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)))); // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__OI_star = (-9.9999999999999995e-7 - (1.0 - 1.0 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm))) / (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm))) - (9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)))))) * var_chaste_interface__ICaL__OI_star + (0.99990000999900008 - 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))) * var_chaste_interface__ICaL__O_star + var_chaste_interface__ICaL__CI_star / ((1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)) * (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)))) + 3.0000000000000001e-6 * (0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (0.99990000999900008 - 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * var_chaste_interface__ICaL__OI / ((1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)) * (0.80000000000000004 - 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm))) * (9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)))); // 1 / ms
        const double var_IKr_xr_gate__tau_xr = 1 / (0.00029999999999999997 * (38.360799999999998 + var_chaste_interface__membrane__Vm) / (-1.0 + exp(5.8385137599999997 + 0.1522 * var_chaste_interface__membrane__Vm)) + 0.00059999999999999995 * (-1.7383999999999999 + var_chaste_interface__membrane__Vm) / (1.0 - exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__membrane__Vm))); // ms
        const double var_IKr_xr_gate__xr_infinity = 1 / (1.0 + exp(-2.3729411764705883 - 0.23529411764705882 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_INaL_hL_gate__hL_infinity = 1 / (1.0 + exp(14.918032786885247 + 0.16393442622950821 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_INaL_mL_gate__amL = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__Vm) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_INaL_mL_gate__bmL = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_INa_h_gate__ah = ((var_chaste_interface__membrane__Vm >= -40.0) ? (0) : (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__Vm))); // per_ms
        const double var_INa_h_gate__bh = ((var_chaste_interface__membrane__Vm >= -40.0) ? (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__Vm))) : (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__Vm) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__Vm))); // per_ms
        const double var_INa_j_gate__aj = ((var_chaste_interface__membrane__Vm >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__membrane__Vm) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__Vm) - 6.9480000000000006e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__Vm)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__Vm)))); // per_ms
        const double var_INa_j_gate__bj = ((var_chaste_interface__membrane__Vm >= -40.0) ? (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__Vm))) : (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__Vm)))); // per_ms
        const double var_INa_m_gate__am = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__Vm) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_INa_m_gate__bm = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_Ito1_a_gate__a_infinity = 1 / (1.0 + exp(-1.3230057479321462 - 0.14019346698443852 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_Ito1_a_gate__tau_a = 1 / (3.5 / (1.0 + exp(3.403513787634354 + 0.034035137876343539 * var_chaste_interface__membrane__Vm)) + 0.82719827942757873 / (1.0 + exp(0.62658348478969694 - 0.034035137876343539 * var_chaste_interface__membrane__Vm))); // ms
        const double var_Ito1_i1f_gate__alpha_i1f = 0.025000000000000001 / (1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_Ito1_i1f_gate__beta_i1f = 0.10208977775055385 / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_Ito1_i1s_gate__alpha_i1s = 0.0040000000000000001 / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_Ito1_i1s_gate__beta_i1s = 0.10208977775055385 / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm)); // per_ms
        const double var_Ito2_i2f_gate__i2f_infinity = 0.025000000000000001 / ((1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)) * (0.025000000000000001 / (1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)) + 0.20000000000000001 / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm)))); // dimensionless
        const double d_dt_chaste_interface_var_Ca__Ca_ss_CaL = (5.0 * var_chaste_interface__Ca__Ca_ss_sr - 5.0 * var_chaste_interface__Ca__Ca_ss_CaL - 151.10797107941448 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss_CaL * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * mParameters[0] * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm))) / (1.0 + 0.0097788000000000007 / pow((0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss_CaL), 2) + 4.0890000000000003e-5 / pow((0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss_CaL), 2)); // mM / ms
        const double d_dt_chaste_interface_var_IKs__C1 = 0.083986000000000005 * var_chaste_interface__IKs__C2 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) - 0.059456000000000002 * var_chaste_interface__IKs__C1 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C10 = (-0.0062345999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) - 0.029728000000000001 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C10 + 0.083986000000000005 * var_chaste_interface__IKs__C11 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) + 0.014600999999999999 * var_chaste_interface__IKs__C7 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C11 = (-0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) - 0.0062345999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) - 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm) - 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C11 + 0.16797200000000001 * var_chaste_interface__IKs__C12 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) + 0.0093518999999999998 * var_chaste_interface__IKs__C13 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) + 0.029201999999999999 * var_chaste_interface__IKs__C8 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm) + 0.029728000000000001 * var_chaste_interface__IKs__C10 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C12 = (-0.16797200000000001 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) - 0.0062345999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) - 0.029201999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C12 + 0.0093518999999999998 * var_chaste_interface__IKs__C14 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) + 0.014864 * var_chaste_interface__IKs__C11 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm) + 0.043802999999999995 * var_chaste_interface__IKs__C9 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C13 = (-0.0093518999999999998 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) - 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C13 + 0.083986000000000005 * var_chaste_interface__IKs__C14 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) + 0.014600999999999999 * var_chaste_interface__IKs__C11 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C14 = (-0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) - 0.0093518999999999998 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) - 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C14 + 0.0124692 * var_chaste_interface__IKs__C15 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) + 0.029201999999999999 * var_chaste_interface__IKs__C12 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm) + 0.014864 * var_chaste_interface__IKs__C13 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C15 = (-0.089538000000000006 - 0.0124692 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C15 + 0.07732 * var_chaste_interface__IKs__O1 * exp(-0.0024231252229042349 * var_chaste_interface__membrane__Vm) + 0.014600999999999999 * var_chaste_interface__IKs__C14 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C2 = (-0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) - 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm) - 0.044592 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C2 + 0.16797200000000001 * var_chaste_interface__IKs__C3 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) + 0.0031172999999999999 * var_chaste_interface__IKs__C6 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) + 0.059456000000000002 * var_chaste_interface__IKs__C1 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C3 = (-0.16797200000000001 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) - 0.029201999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm) - 0.029728000000000001 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C3 + 0.0031172999999999999 * var_chaste_interface__IKs__C7 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) + 0.25195800000000002 * var_chaste_interface__IKs__C4 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) + 0.044592 * var_chaste_interface__IKs__C2 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C4 = (-0.25195800000000002 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) - 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm) - 0.043802999999999995 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C4 + 0.33594400000000002 * var_chaste_interface__IKs__C5 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) + 0.0031172999999999999 * var_chaste_interface__IKs__C8 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) + 0.029728000000000001 * var_chaste_interface__IKs__C3 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C5 = (-0.33594400000000002 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) - 0.058403999999999998 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C5 + 0.0031172999999999999 * var_chaste_interface__IKs__C9 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) + 0.014864 * var_chaste_interface__IKs__C4 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C6 = (-0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) - 0.044592 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C6 + 0.083986000000000005 * var_chaste_interface__IKs__C7 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) + 0.014600999999999999 * var_chaste_interface__IKs__C2 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C7 = (-0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) - 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) - 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm) - 0.029728000000000001 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C7 + 0.16797200000000001 * var_chaste_interface__IKs__C8 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) + 0.0062345999999999999 * var_chaste_interface__IKs__C10 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) + 0.029201999999999999 * var_chaste_interface__IKs__C3 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm) + 0.044592 * var_chaste_interface__IKs__C6 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C8 = (-0.16797200000000001 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) - 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) - 0.029201999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm) - 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C8 + 0.0062345999999999999 * var_chaste_interface__IKs__C11 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) + 0.25195800000000002 * var_chaste_interface__IKs__C9 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) + 0.029728000000000001 * var_chaste_interface__IKs__C7 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm) + 0.043802999999999995 * var_chaste_interface__IKs__C4 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C9 = (-0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) - 0.25195800000000002 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm) - 0.043802999999999995 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__C9 + 0.0062345999999999999 * var_chaste_interface__IKs__C12 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm) + 0.058403999999999998 * var_chaste_interface__IKs__C5 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm) + 0.014864 * var_chaste_interface__IKs__C8 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__O1 = 0.089538000000000006 * var_chaste_interface__IKs__C15 + (-0.07732 * exp(-0.0024231252229042349 * var_chaste_interface__membrane__Vm) - 0.58638000000000001 * exp(0.0105593841790373 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__IKs__O1 + 0.79405000000000003 * var_chaste_interface__IKs__O2 * exp(-0.003001446738885828 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_IKs__O2 = 0.58638000000000001 * var_chaste_interface__IKs__O1 * exp(0.0105593841790373 * var_chaste_interface__membrane__Vm) - 0.79405000000000003 * var_chaste_interface__IKs__O2 * exp(-0.003001446738885828 * var_chaste_interface__membrane__Vm); // 1 / ms
        const double d_dt_chaste_interface_var_Ca__Ca_i = (2.3746312684365782e-5 * var_chaste_interface__Ca__Ca_NSR + 0.014749262536873154 * var_chaste_interface__Ca__Ca_ss_sr - 0.014749262536873154 * var_chaste_interface__Ca__Ca_i - 1.7739020544754105e-6 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i) - 0.00035619469026548675 * (1.0 + 0.75 * (0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap) / (0.14999999999999999 + var_chaste_interface__CaMK_active__CaMK_trap + 0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr))) * var_chaste_interface__Ca__Ca_i / (0.00092000000000000003 - 0.00017000000000000001 * (0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap) / (0.14999999999999999 + var_chaste_interface__CaMK_active__CaMK_trap + 0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr)) + var_chaste_interface__Ca__Ca_i) - 8.8930116629204303e-8 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) + 6.1700941025231664e-5 * (6.4800000000000004 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 9878400.0 * var_chaste_interface__Ca__Ca_i * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_i))) / (1.0 + 0.00011900000000000002 / pow((0.0023800000000000002 + var_chaste_interface__Ca__Ca_i), 2) + 3.5000000000000004e-5 / pow((0.00050000000000000001 + var_chaste_interface__Ca__Ca_i), 2)); // mM / ms
        const double d_dt_chaste_interface_var_Ca__Ca_ss_sr = (0.5 * var_chaste_interface__Ca__Ca_ss_CaL + 0.23999999999999996 * var_chaste_interface__Irel__Irel + 5.0 * var_chaste_interface__Ca__Ca_i - 5.5 * var_chaste_interface__Ca__Ca_ss_sr + 0.0020916619007553534 * (1.6200000000000001 * pow(var_chaste_interface__Na__Na_ss_sr, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 2469600.0 * var_chaste_interface__Ca__Ca_ss_sr * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_ss_sr, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_ss_sr, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr))) / (1.0 + 0.0097788000000000007 / pow((0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss_sr), 2) + 4.0890000000000003e-5 / pow((0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss_sr), 2)); // mM / ms
        const double d_dt_chaste_interface_var_Na__Na_ss_sr = 5.0 * var_chaste_interface__Na__Na_i - 5.0 * var_chaste_interface__Na__Na_ss_sr - 0.0062749857022660607 * (1.6200000000000001 * pow(var_chaste_interface__Na__Na_ss_sr, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 2469600.0 * var_chaste_interface__Ca__Ca_ss_sr * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_ss_sr, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_ss_sr, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr)); // mM / ms
        const double d_dt_chaste_interface_var_Irel__Irel = (1.0 + 0.0123 / var_chaste_interface__Ca__Ca_JSR) * (-var_chaste_interface__Irel__Irel - 14448.603861345418 * (0.53437500000000004 + 0.53437500000000004 / (1.0 + 2.9619676669542428e-6 * pow(1 / (0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap), 10.0))) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss_CaL * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * mParameters[0] * var_chaste_interface__membrane__Vm / ((1.0 + pow(1 / var_chaste_interface__Ca__Ca_JSR, 8.0)) * (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)))) / (4.75 + 4.75 / (1.0 + 2.9619676669542428e-6 * pow(1 / (0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap), 10.0))); // mM_per_ms / ms
        const double d_dt_chaste_interface_var_Cl__Cl_ss = 5.0 * var_chaste_interface__Cl__Cl_i - 5.0 * var_chaste_interface__Cl__Cl_ss + 6.799858698573652e-6 * (1.0 - 1.0 / (1.0 + 6.2499999999999991 * pow(var_chaste_interface__Irel__Irel, 2))) * (-100.0 * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2_i2f_gate__i2f * var_chaste_interface__membrane__Vm / (1.0 - exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)); // mM / ms
        const double d_dt_chaste_interface_var_Cl__Cl_i = 0.14749262536873156 * var_chaste_interface__Cl__Cl_ss + 1.3882711730677125e-8 * var_chaste_interface__membrane__Vm + 3.7083201106826184e-7 * log(100.0 / var_chaste_interface__Cl__Cl_i) - 0.14749262536873156 * var_chaste_interface__Cl__Cl_i + 1.77e-5 * (26.711785007306684 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i)) / (87.825100000000006 + 26.711785007306684 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i)) + 12.529604814733942 * pow((log(100.0 / var_chaste_interface__Cl__Cl_i) + log(140.0 / var_chaste_interface__Na__Na_i)), 4) / (59494197.640692554 + 509110.01733929582 * pow((log(100.0 / var_chaste_interface__Cl__Cl_i) + log(140.0 / var_chaste_interface__Na__Na_i)), 4)); // mM / ms
        const double d_dt_chaste_interface_var_Na__Na_i = 0.14749262536873156 * var_chaste_interface__Na__Na_ss_sr - 0.14749262536873156 * var_chaste_interface__Na__Na_i + 12.529604814733942 * pow((log(100.0 / var_chaste_interface__Cl__Cl_i) + log(140.0 / var_chaste_interface__Na__Na_i)), 4) / (59494197.640692554 + 509110.01733929582 * pow((log(100.0 / var_chaste_interface__Cl__Cl_i) + log(140.0 / var_chaste_interface__Na__Na_i)), 4)) - 7.1319396379664657e-10 * (-140.0 + var_chaste_interface__Na__Na_i * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)) - 4.0105611666400582e-7 * pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-26.711785007306684 * log(140.0 / var_chaste_interface__Na__Na_i) + var_chaste_interface__membrane__Vm) * var_chaste_interface__INaL_hL_gate__hL - 1.1538934370751403e-5 * pow(var_chaste_interface__Na__Na_i, 3) / (pow((1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i), 3) * (1.0 + exp(-3.4441726741524206 - 0.037436659501656748 * var_chaste_interface__membrane__Vm))) - 0.00018510282307569501 * (6.4800000000000004 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 9878400.0 * var_chaste_interface__Ca__Ca_i * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_i)) - 6.1700941025231664e-5 * pow(var_chaste_interface__INa_m_gate__m, 3) * (-26.711785007306684 * log(140.0 / var_chaste_interface__Na__Na_i) + var_chaste_interface__membrane__Vm) * mParameters[1] * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // mM / ms
        const double d_dt_chaste_interface_var_K__K_i = 1.77e-5 * (26.711785007306684 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i)) / (87.825100000000006 + 26.711785007306684 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i)) - 6.1700941025231664e-5 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time) / HeartConfig::Instance()->GetCapacitance() - 1.7029459722963939e-7 * (-26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__membrane__Vm) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)) + 7.6926229138342684e-6 * pow(var_chaste_interface__Na__Na_i, 3) / (pow((1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i), 3) * (1.0 + exp(-3.4441726741524206 - 0.037436659501656748 * var_chaste_interface__membrane__Vm))) - 6.1700941025231664e-5 * (0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.711785007306684 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__membrane__Vm) * (var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2) - 3.1467479922868152e-5 * (-26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__membrane__Vm) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 6.3707607242426434 * log(5.4000000000000004 / var_chaste_interface__K__K_i))) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 6.3707607242426434 * log(5.4000000000000004 / var_chaste_interface__K__K_i))) + (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 2.1454905717868731 * log(5.4000000000000004 / var_chaste_interface__K__K_i)) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 1.6494527242011876 * log(5.4000000000000004 / var_chaste_interface__K__K_i))) / (1.0 + exp(-2.4444678999999998 + 13.737871029257827 * log(5.4000000000000004 / var_chaste_interface__K__K_i) - 0.51429999999999998 * var_chaste_interface__membrane__Vm)))) - 6.1700941025231664e-5 * (-26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__membrane__Vm) * mParameters[2] * var_chaste_interface__IKr_xr_gate__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)) - 3.0696218160052752e-5 * pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__membrane__Vm) * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s * exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm); // mM / ms

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__Vm = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__Vm = -0.00022499999999999999 * var_chaste_interface__membrane__Vm - 0.0060101516266440041 * log(100.0 / var_chaste_interface__Cl__Cl_i) - GetIntracellularAreaStimulus(var_chaste_interface__environment__time) / HeartConfig::Instance()->GetCapacitance() - 0.0027599999999999999 * (-26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__membrane__Vm) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)) - 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i) - (0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.711785007306684 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__membrane__Vm) * (var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2) - 0.0064999999999999997 * pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-26.711785007306684 * log(140.0 / var_chaste_interface__Na__Na_i) + var_chaste_interface__membrane__Vm) * var_chaste_interface__INaL_hL_gate__hL - 1.1558883089076335e-5 * (-140.0 + var_chaste_interface__Na__Na_i * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)) - 0.062337970750628316 * pow(var_chaste_interface__Na__Na_i, 3) / (pow((1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i), 3) * (1.0 + exp(-3.4441726741524206 - 0.037436659501656748 * var_chaste_interface__membrane__Vm))) - 0.51000000000000001 * (-26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__membrane__Vm) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 6.3707607242426434 * log(5.4000000000000004 / var_chaste_interface__K__K_i))) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 6.3707607242426434 * log(5.4000000000000004 / var_chaste_interface__K__K_i))) + (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 2.1454905717868731 * log(5.4000000000000004 / var_chaste_interface__K__K_i)) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 1.6494527242011876 * log(5.4000000000000004 / var_chaste_interface__K__K_i))) / (1.0 + exp(-2.4444678999999998 + 13.737871029257827 * log(5.4000000000000004 / var_chaste_interface__K__K_i) - 0.51429999999999998 * var_chaste_interface__membrane__Vm)))) - 0.0028826178386108462 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) - 1.0 * (6.4800000000000004 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 9878400.0 * var_chaste_interface__Ca__Ca_i * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_i)) - 1.0 * (1.6200000000000001 * pow(var_chaste_interface__Na__Na_ss_sr, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 2469600.0 * var_chaste_interface__Ca__Ca_ss_sr * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_ss_sr, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_ss_sr, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr)) - 1.0 * (-26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__membrane__Vm) * mParameters[2] * var_chaste_interface__IKr_xr_gate__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)) - pow(var_chaste_interface__INa_m_gate__m, 3) * (-26.711785007306684 * log(140.0 / var_chaste_interface__Na__Na_i) + var_chaste_interface__membrane__Vm) * mParameters[1] * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j - 0.4975 * pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i) + var_chaste_interface__membrane__Vm) * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s * exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm) - 14448.603861345418 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss_CaL * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * mParameters[0] * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) - 0.0032509358688027189 * (1.0 - 1.0 / (1.0 + 6.2499999999999991 * pow(var_chaste_interface__Irel__Irel, 2))) * (-100.0 * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2_i2f_gate__i2f * var_chaste_interface__membrane__Vm / (1.0 - exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)); // mV / ms
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__Vm;
        rDY[1] = d_dt_chaste_interface_var_Ca__Ca_i;
        rDY[2] = d_dt_chaste_interface_var_IKs__C1;
        rDY[3] = d_dt_chaste_interface_var_IKs__C2;
        rDY[4] = d_dt_chaste_interface_var_IKs__C3;
        rDY[5] = d_dt_chaste_interface_var_IKs__C4;
        rDY[6] = d_dt_chaste_interface_var_IKs__C5;
        rDY[7] = d_dt_chaste_interface_var_IKs__C6;
        rDY[8] = d_dt_chaste_interface_var_IKs__C7;
        rDY[9] = d_dt_chaste_interface_var_IKs__C8;
        rDY[10] = d_dt_chaste_interface_var_IKs__C9;
        rDY[11] = d_dt_chaste_interface_var_IKs__C10;
        rDY[12] = d_dt_chaste_interface_var_IKs__C11;
        rDY[13] = d_dt_chaste_interface_var_IKs__C12;
        rDY[14] = d_dt_chaste_interface_var_IKs__C13;
        rDY[15] = d_dt_chaste_interface_var_IKs__C14;
        rDY[16] = d_dt_chaste_interface_var_IKs__C15;
        rDY[17] = d_dt_chaste_interface_var_IKs__O1;
        rDY[18] = d_dt_chaste_interface_var_IKs__O2;
        rDY[19] = d_dt_chaste_interface_var_ICaL__C;
        rDY[20] = d_dt_chaste_interface_var_ICaL__O;
        rDY[21] = d_dt_chaste_interface_var_ICaL__C_star;
        rDY[22] = d_dt_chaste_interface_var_ICaL__O_star;
        rDY[23] = d_dt_chaste_interface_var_ICaL__CI;
        rDY[24] = d_dt_chaste_interface_var_ICaL__OI;
        rDY[25] = d_dt_chaste_interface_var_ICaL__CI_star;
        rDY[26] = d_dt_chaste_interface_var_ICaL__OI_star;
        rAlphaOrTau[27] = var_INa_m_gate__am;
        rBetaOrInf[27] = var_INa_m_gate__bm;
        rAlphaOrTau[28] = var_INa_h_gate__ah;
        rBetaOrInf[28] = var_INa_h_gate__bh;
        rAlphaOrTau[29] = var_INa_j_gate__aj;
        rBetaOrInf[29] = var_INa_j_gate__bj;
        rAlphaOrTau[30] = var_INaL_mL_gate__amL;
        rBetaOrInf[30] = var_INaL_mL_gate__bmL;
        rAlphaOrTau[31] = var_INaL_hL_gate__tau_hL;
        rBetaOrInf[31] = var_INaL_hL_gate__hL_infinity;
        rAlphaOrTau[32] = var_IKr_xr_gate__tau_xr;
        rBetaOrInf[32] = var_IKr_xr_gate__xr_infinity;
        rAlphaOrTau[33] = var_Ito1_a_gate__tau_a;
        rBetaOrInf[33] = var_Ito1_a_gate__a_infinity;
        rAlphaOrTau[34] = var_Ito1_i1f_gate__alpha_i1f;
        rBetaOrInf[34] = var_Ito1_i1f_gate__beta_i1f;
        rAlphaOrTau[35] = var_Ito1_i1s_gate__alpha_i1s;
        rBetaOrInf[35] = var_Ito1_i1s_gate__beta_i1s;
        rAlphaOrTau[36] = var_Ito2_i2f_gate__tau_i2f;
        rBetaOrInf[36] = var_Ito2_i2f_gate__i2f_infinity;
        rDY[37] = d_dt_chaste_interface_var_Irel__Irel;
        rDY[38] = d_dt_chaste_interface_var_Ca__Ca_JSR;
        rDY[39] = d_dt_chaste_interface_var_Ca__Ca_NSR;
        rDY[40] = d_dt_chaste_interface_var_Ca__Ca_ss_sr;
        rDY[41] = d_dt_chaste_interface_var_Ca__Ca_ss_CaL;
        rDY[42] = d_dt_chaste_interface_var_Na__Na_i;
        rDY[43] = d_dt_chaste_interface_var_Na__Na_ss_sr;
        rDY[44] = d_dt_chaste_interface_var_Cl__Cl_i;
        rDY[45] = d_dt_chaste_interface_var_Cl__Cl_ss;
        rDY[46] = d_dt_chaste_interface_var_K__K_i;
        rDY[47] = d_dt_chaste_interface_var_CaMK_active__CaMK_trap;
    }
    void Celldecker_2009FromCellMLRushLarsenOpt::ComputeOneStepExceptVoltage(const std::vector<double> &rDY, const std::vector<double> &rAlphaOrTau, const std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        
        rY[1] += mDt * rDY[1];
        rY[2] += mDt * rDY[2];
        rY[3] += mDt * rDY[3];
        rY[4] += mDt * rDY[4];
        rY[5] += mDt * rDY[5];
        rY[6] += mDt * rDY[6];
        rY[7] += mDt * rDY[7];
        rY[8] += mDt * rDY[8];
        rY[9] += mDt * rDY[9];
        rY[10] += mDt * rDY[10];
        rY[11] += mDt * rDY[11];
        rY[12] += mDt * rDY[12];
        rY[13] += mDt * rDY[13];
        rY[14] += mDt * rDY[14];
        rY[15] += mDt * rDY[15];
        rY[16] += mDt * rDY[16];
        rY[17] += mDt * rDY[17];
        rY[18] += mDt * rDY[18];
        rY[19] += mDt * rDY[19];
        rY[20] += mDt * rDY[20];
        rY[21] += mDt * rDY[21];
        rY[22] += mDt * rDY[22];
        rY[23] += mDt * rDY[23];
        rY[24] += mDt * rDY[24];
        rY[25] += mDt * rDY[25];
        rY[26] += mDt * rDY[26];
        {
            const double tau_inv = rAlphaOrTau[27] + rBetaOrInf[27];
            const double y_inf = rAlphaOrTau[27] / tau_inv;
            rY[27] = y_inf + (rY[27] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[28] + rBetaOrInf[28];
            const double y_inf = rAlphaOrTau[28] / tau_inv;
            rY[28] = y_inf + (rY[28] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[29] + rBetaOrInf[29];
            const double y_inf = rAlphaOrTau[29] / tau_inv;
            rY[29] = y_inf + (rY[29] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[30] + rBetaOrInf[30];
            const double y_inf = rAlphaOrTau[30] / tau_inv;
            rY[30] = y_inf + (rY[30] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[31] = rBetaOrInf[31] + (rY[31] - rBetaOrInf[31])*exp(-mDt/rAlphaOrTau[31]);
        rY[32] = rBetaOrInf[32] + (rY[32] - rBetaOrInf[32])*exp(-mDt/rAlphaOrTau[32]);
        rY[33] = rBetaOrInf[33] + (rY[33] - rBetaOrInf[33])*exp(-mDt/rAlphaOrTau[33]);
        {
            const double tau_inv = rAlphaOrTau[34] + rBetaOrInf[34];
            const double y_inf = rAlphaOrTau[34] / tau_inv;
            rY[34] = y_inf + (rY[34] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[35] + rBetaOrInf[35];
            const double y_inf = rAlphaOrTau[35] / tau_inv;
            rY[35] = y_inf + (rY[35] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[36] = rBetaOrInf[36] + (rY[36] - rBetaOrInf[36])*exp(-mDt/rAlphaOrTau[36]);
        rY[37] += mDt * rDY[37];
        rY[38] += mDt * rDY[38];
        rY[39] += mDt * rDY[39];
        rY[40] += mDt * rDY[40];
        rY[41] += mDt * rDY[41];
        rY[42] += mDt * rDY[42];
        rY[43] += mDt * rDY[43];
        rY[44] += mDt * rDY[44];
        rY[45] += mDt * rDY[45];
        rY[46] += mDt * rDY[46];
        rY[47] += mDt * rDY[47];
    }

    std::vector<double> Celldecker_2009FromCellMLRushLarsenOpt::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celldecker_2009FromCellMLRushLarsenOpt>::Initialise(void)
{
    this->mSystemName = "decker_2009";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-87.472528);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(7.09945e-05);

    // rY[2]:
    this->mVariableNames.push_back("IKs__C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.476653873938053);

    // rY[3]:
    this->mVariableNames.push_back("IKs__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.2551771850026437);

    // rY[4]:
    this->mVariableNames.push_back("IKs__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.05122852186842027);

    // rY[5]:
    this->mVariableNames.push_back("IKs__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004570874421666423);

    // rY[6]:
    this->mVariableNames.push_back("IKs__C5");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001529389211563687);

    // rY[7]:
    this->mVariableNames.push_back("IKs__C6");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1328281770413747);

    // rY[8]:
    this->mVariableNames.push_back("IKs__C7");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.05333228495514583);

    // rY[9]:
    this->mVariableNames.push_back("IKs__C8");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.007137874613383642);

    // rY[10]:
    this->mVariableNames.push_back("IKs__C9");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0003184390970637536);

    // rY[11]:
    this->mVariableNames.push_back("IKs__C10");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01388061042363991);

    // rY[12]:
    this->mVariableNames.push_back("IKs__C11");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.003715500164470033);

    // rY[13]:
    this->mVariableNames.push_back("IKs__C12");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0002486371465457659);

    // rY[14]:
    this->mVariableNames.push_back("IKs__C13");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0006446803014431032);

    // rY[15]:
    this->mVariableNames.push_back("IKs__C14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.628258026770862e-05);

    // rY[16]:
    this->mVariableNames.push_back("IKs__C15");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.122823524761588e-05);

    // rY[17]:
    this->mVariableNames.push_back("IKs__O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.051906959485266e-05);

    // rY[18]:
    this->mVariableNames.push_back("IKs__O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.372219883411999e-06);

    // rY[19]:
    this->mVariableNames.push_back("ICaL__C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999613782488198);

    // rY[20]:
    this->mVariableNames.push_back("ICaL__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.27419494597377e-05);

    // rY[21]:
    this->mVariableNames.push_back("ICaL__C_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(5.936477396599124e-11);

    // rY[22]:
    this->mVariableNames.push_back("ICaL__O_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.350122566369778e-15);

    // rY[23]:
    this->mVariableNames.push_back("ICaL__CI");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.587938121237188e-05);

    // rY[24]:
    this->mVariableNames.push_back("ICaL__OI");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.611420243201921e-10);

    // rY[25]:
    this->mVariableNames.push_back("ICaL__CI_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[26]:
    this->mVariableNames.push_back("ICaL__OI_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[27]:
    this->mVariableNames.push_back("INa_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001022252813581797);

    // rY[28]:
    this->mVariableNames.push_back("INa_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9913109066867);

    // rY[29]:
    this->mVariableNames.push_back("INa_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9970771239754529);

    // rY[30]:
    this->mVariableNames.push_back("INaL_mL_gate__mL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001022252813581797);

    // rY[31]:
    this->mVariableNames.push_back("INaL_hL_gate__hL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3593255076983574);

    // rY[32]:
    this->mVariableNames.push_back("IKr_xr_gate__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.235996442041028e-08);

    // rY[33]:
    this->mVariableNames.push_back("Ito1_a_gate__a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.773318268499115e-05);

    // rY[34]:
    this->mVariableNames.push_back("Ito1_i1f_gate__i1f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9979722);

    // rY[35]:
    this->mVariableNames.push_back("Ito1_i1s_gate__i1s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9874435);

    // rY[36]:
    this->mVariableNames.push_back("Ito2_i2f_gate__i2f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9960352);

    // rY[37]:
    this->mVariableNames.push_back("Irel__Irel");
    this->mVariableUnits.push_back("mM_per_ms");
    this->mInitialConditions.push_back(0.00107332);

    // rY[38]:
    this->mVariableNames.push_back("Ca__Ca_JSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.917692717);

    // rY[39]:
    this->mVariableNames.push_back("Ca__Ca_NSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.929835335);

    // rY[40]:
    this->mVariableNames.push_back("Ca__Ca_ss_sr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(9.04757e-05);

    // rY[41]:
    this->mVariableNames.push_back("Ca__Ca_ss_CaL");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(9.61545e-05);

    // rY[42]:
    this->mVariableNames.push_back("Na__Na_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(6.935575);

    // rY[43]:
    this->mVariableNames.push_back("Na__Na_ss_sr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(6.935607);

    // rY[44]:
    this->mVariableNames.push_back("Cl__Cl_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(20.26842);

    // rY[45]:
    this->mVariableNames.push_back("Cl__Cl_ss");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(20.26842);

    // rY[46]:
    this->mVariableNames.push_back("K__K_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(145.5689);

    // rY[47]:
    this->mVariableNames.push_back("CaMK_active__CaMK_trap");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0018861341);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("L_per_F_ms");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("mS_per_uF");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("mS_per_uF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celldecker_2009FromCellMLRushLarsenOpt)
