//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: bondarenko_model_2004_apex
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "bondarenko_model_2004_apex.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellbondarenko_model_2004_apexFromCellMLRushLarsenOpt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -80.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 0.5; // millisecond
        const double var_chaste_interface__membrane__stim_period = 71.430000000000007; // millisecond
        const double var_chaste_interface__membrane__stim_start = 20.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellbondarenko_model_2004_apexFromCellMLRushLarsenOpt::Cellbondarenko_model_2004_apexFromCellMLRushLarsenOpt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractRushLarsenCardiacCell(
                41,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellbondarenko_model_2004_apexFromCellMLRushLarsenOpt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
    }

    Cellbondarenko_model_2004_apexFromCellMLRushLarsenOpt::~Cellbondarenko_model_2004_apexFromCellMLRushLarsenOpt()
    {
    }
    
    double Cellbondarenko_model_2004_apexFromCellMLRushLarsenOpt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__potassium_concentration__Ki = rY[27];
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) / (0.25 + pow(var_chaste_interface__calcium_concentration__Cai, 2)); // picoA_per_picoF
        const double var_L_type_calcium_current__i_CaL = 0.1729 * (-63.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O; // picoA_per_picoF
        const double var_calcium_activated_chloride_current__i_ClCa = 2.0 * (40.0 + var_chaste_interface__membrane__V) * var_chaste_interface__calcium_concentration__Cai / ((1.0 + exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V)) * (10.0 + var_chaste_interface__calcium_concentration__Cai)); // picoA_per_picoF
        const double var_calcium_background_current__i_Cab = 0.00036699999999999998 * var_chaste_interface__membrane__V - 0.0047112379481865285 * log(1800.0 / var_chaste_interface__calcium_concentration__Cai); // picoA_per_picoF
        const double var_fast_transient_outward_potassium_current__E_K = 25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki); // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = 0.40670000000000001 * pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = 0.050000000000000003 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = 0.0057499999999999999 * pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V); // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__i_Kto_s = 0; // picoA_per_picoF
        const double var_fast_sodium_current__E_Na = 25.674321243523316 * log(140600.0 / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)); // millivolt
        const double var_fast_sodium_current__i_Na = 13.0 * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = 0.078 * (-25.674321243523316 * log(8257.1428571428569 / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = 0.0025999999999999999 * var_chaste_interface__membrane__V - 0.0025999999999999999 * var_fast_sodium_current__E_Na; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = 2.6970585464294846e-17 * (1800.0 * pow(var_chaste_interface__sodium_concentration__Nai, 3) * exp(0.013632298072467722 * var_chaste_interface__membrane__V) - 2744000000000000.0 * var_chaste_interface__calcium_concentration__Cai * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) / (1.0 + 0.10000000000000001 * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = 0.68869565217391304 / ((1.0 + 3043189.1166997822 * pow(1 / var_chaste_interface__sodium_concentration__Nai, 1.5)) * (1.0 + 0.1245 * exp(-0.0038949423064193493 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.038949423064193495 * var_chaste_interface__membrane__V))); // picoA_per_picoF
        const double var_time_independent_potassium_current__i_K1 = 0.28280213903743318 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = 0.16 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        const double var_chaste_interface__i_ionic = (var_L_type_calcium_current__i_CaL + var_calcium_activated_chloride_current__i_ClCa + var_calcium_background_current__i_Cab + var_calcium_pump_current__i_pCa + var_fast_sodium_current__i_Na + var_fast_transient_outward_potassium_current__i_Kto_f + var_non_inactivating_steady_state_potassium_current__i_Kss + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_slow_delayed_rectifier_potassium_current__i_Ks + var_slow_transient_outward_potassium_current__i_Kto_s + var_sodium_background_current__i_Nab + var_sodium_calcium_exchange_current__i_NaCa + var_sodium_potassium_pump_current__i_NaK + var_time_independent_potassium_current__i_K1 + var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellbondarenko_model_2004_apexFromCellMLRushLarsenOpt::EvaluateEquations(double var_chaste_interface__environment__time, std::vector<double> &rDY, std::vector<double> &rAlphaOrTau, std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__CaJSR = rY[3];
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_concentration__CaNSR = rY[4];
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_fluxes__P_RyR = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__calcium_buffering__LTRPN_Ca = rY[6];
        // Units: micromolar; Initial value: 11.2684
        double var_chaste_interface__calcium_buffering__HTRPN_Ca = rY[7];
        // Units: micromolar; Initial value: 125.29
        double var_chaste_interface__ryanodine_receptors__P_O1 = rY[8];
        // Units: dimensionless; Initial value: 1.49102e-05
        double var_chaste_interface__ryanodine_receptors__P_O2 = rY[9];
        // Units: dimensionless; Initial value: 9.51726e-11
        double var_chaste_interface__ryanodine_receptors__P_C2 = rY[10];
        // Units: dimensionless; Initial value: 0.00016774
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__L_type_calcium_current__C2 = rY[12];
        // Units: dimensionless; Initial value: 0.000124216
        double var_chaste_interface__L_type_calcium_current__C3 = rY[13];
        // Units: dimensionless; Initial value: 5.78679e-09
        double var_chaste_interface__L_type_calcium_current__C4 = rY[14];
        // Units: dimensionless; Initial value: 1.19816e-13
        double var_chaste_interface__L_type_calcium_current__I1 = rY[15];
        // Units: dimensionless; Initial value: 4.97923e-19
        double var_chaste_interface__L_type_calcium_current__I2 = rY[16];
        // Units: dimensionless; Initial value: 3.45847e-14
        double var_chaste_interface__L_type_calcium_current__I3 = rY[17];
        // Units: dimensionless; Initial value: 1.85106e-14
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__fast_sodium_current__C_Na1 = rY[20];
        // Units: dimensionless; Initial value: 0.000279132
        double var_chaste_interface__fast_sodium_current__C_Na2 = rY[21];
        // Units: dimensionless; Initial value: 0.020752
        double var_chaste_interface__fast_sodium_current__I1_Na = rY[22];
        // Units: dimensionless; Initial value: 6.73345e-07
        double var_chaste_interface__fast_sodium_current__I2_Na = rY[23];
        // Units: dimensionless; Initial value: 1.55787e-09
        double var_chaste_interface__fast_sodium_current__IF_Na = rY[24];
        // Units: dimensionless; Initial value: 0.000153176
        double var_chaste_interface__fast_sodium_current__IC_Na2 = rY[25];
        // Units: dimensionless; Initial value: 0.0113879
        double var_chaste_interface__fast_sodium_current__IC_Na3 = rY[26];
        // Units: dimensionless; Initial value: 0.34278
        double var_chaste_interface__potassium_concentration__Ki = rY[27];
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        
        
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 = rY[38];
        // Units: dimensionless; Initial value: 0.000992513
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 = rY[39];
        // Units: dimensionless; Initial value: 0.000641229
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K = rY[40];
        // Units: dimensionless; Initial value: 3.19129e-05

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__iKss = 0; // 1 / millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__HTRPN_Ca = -3.1999999999999999e-5 * var_chaste_interface__calcium_buffering__HTRPN_Ca + 0.0023700000000000001 * (140.0 - var_chaste_interface__calcium_buffering__HTRPN_Ca) * var_chaste_interface__calcium_concentration__Cai; // micromolar / millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__LTRPN_Ca = -0.019599999999999999 * var_chaste_interface__calcium_buffering__LTRPN_Ca + 0.0327 * (70.0 - var_chaste_interface__calcium_buffering__LTRPN_Ca) * var_chaste_interface__calcium_concentration__Cai; // micromolar / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C2 = 0.10000000000000001 * var_chaste_interface__L_type_calcium_current__C3 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) - 0.050000000000000003 * var_chaste_interface__L_type_calcium_current__C2 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 1.6000000000000001 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * (1.0 - var_chaste_interface__L_type_calcium_current__C3 - var_chaste_interface__L_type_calcium_current__C4 - var_chaste_interface__L_type_calcium_current__I1 - var_chaste_interface__L_type_calcium_current__I2 - var_chaste_interface__L_type_calcium_current__I3 - var_chaste_interface__L_type_calcium_current__O - 2 * var_chaste_interface__L_type_calcium_current__C2) * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)) - 1.2000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__C2 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C3 = 0.15000000000000002 * var_chaste_interface__L_type_calcium_current__C4 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) - 0.10000000000000001 * var_chaste_interface__L_type_calcium_current__C3 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 1.2000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__C2 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)) - 0.80000000000000004 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__C3 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C4 = 0.20000000000000001 * var_chaste_interface__L_type_calcium_current__O * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 1.0000000000000002e-6 * var_chaste_interface__L_type_calcium_current__I1 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 0.0001 * var_chaste_interface__L_type_calcium_current__I3 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 0.00040000000000000002 * var_chaste_interface__L_type_calcium_current__I2 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) - 0.002 * (13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__C4 - 0.15000000000000002 * var_chaste_interface__L_type_calcium_current__C4 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 0.80000000000000004 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__C3 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)) - 0.23324 * (13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__C4 * var_chaste_interface__calcium_concentration__Cass / (20.0 + var_chaste_interface__calcium_concentration__Cass) - 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__C4 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)) - 0.00093296000000000004 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__C4 * var_chaste_interface__calcium_concentration__Cass * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / ((1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)) * (20.0 + var_chaste_interface__calcium_concentration__Cass)); // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I1 = -0.00050000000000000001 * var_chaste_interface__L_type_calcium_current__I1 - 0.001 * (13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__I1 + 0.23324 * var_chaste_interface__L_type_calcium_current__O * var_chaste_interface__calcium_concentration__Cass / (20.0 + var_chaste_interface__calcium_concentration__Cass) - 0.002 * (13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__I1 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 0.00040000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__I3 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)) + 0.00093296000000000004 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__C4 * var_chaste_interface__calcium_concentration__Cass * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / ((1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)) * (20.0 + var_chaste_interface__calcium_concentration__Cass)); // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I2 = 0.00050000000000000001 * var_chaste_interface__L_type_calcium_current__I3 + 0.001 * (13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__O + 0.002 * (13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__C4 - 0.00040000000000000002 * var_chaste_interface__L_type_calcium_current__I2 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) - 0.23324 * var_chaste_interface__L_type_calcium_current__I2 * var_chaste_interface__calcium_concentration__Cass / (20.0 + var_chaste_interface__calcium_concentration__Cass) - 0.00040000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__I2 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I3 = -0.00050000000000000001 * var_chaste_interface__L_type_calcium_current__I3 + 0.001 * (13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__I1 - 0.0001 * var_chaste_interface__L_type_calcium_current__I3 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) + 0.23324 * var_chaste_interface__L_type_calcium_current__I2 * var_chaste_interface__calcium_concentration__Cass / (20.0 + var_chaste_interface__calcium_concentration__Cass) + 0.23324 * (13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__C4 * var_chaste_interface__calcium_concentration__Cass / (20.0 + var_chaste_interface__calcium_concentration__Cass) - 0.00040000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__I3 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__O = 0.00050000000000000001 * var_chaste_interface__L_type_calcium_current__I1 - 0.001 * (13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__O - 0.20000000000000001 * var_chaste_interface__L_type_calcium_current__O * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V) - 0.23324 * var_chaste_interface__L_type_calcium_current__O * var_chaste_interface__calcium_concentration__Cass / (20.0 + var_chaste_interface__calcium_concentration__Cass) + 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__C4 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)) + 0.00040000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * var_chaste_interface__L_type_calcium_current__I2 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_calcium_fluxes__P_RyR = -0.040000000000000001 * var_chaste_interface__calcium_fluxes__P_RyR - 0.00247 * (-63.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O * exp(-0.038580246913580245 * pow((-1 + 0.20000000000000001 * var_chaste_interface__membrane__V), 2)); // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__C_Na1 = -(0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__C_Na1 + 6.9999999999999997e-7 * var_chaste_interface__fast_sodium_current__IF_Na * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V) + 0.22 * var_chaste_interface__fast_sodium_current__O_Na * exp(0.36945812807881773 - 0.04926108374384236 * var_chaste_interface__membrane__V) + 3.802 * var_chaste_interface__fast_sodium_current__C_Na2 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V)) - 0.20000000000000001 * var_chaste_interface__fast_sodium_current__C_Na1 * exp(0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V) - 3.802 * var_chaste_interface__fast_sodium_current__C_Na1 / (0.25 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__C_Na2 = -(0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__C_Na2 + 0.20000000000000001 * var_chaste_interface__fast_sodium_current__C_Na1 * exp(0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V) + 6.9999999999999997e-7 * var_chaste_interface__fast_sodium_current__IC_Na2 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V) + 3.802 * (1.0 - var_chaste_interface__fast_sodium_current__C_Na1 - var_chaste_interface__fast_sodium_current__C_Na2 - var_chaste_interface__fast_sodium_current__I1_Na - var_chaste_interface__fast_sodium_current__I2_Na - var_chaste_interface__fast_sodium_current__IC_Na2 - var_chaste_interface__fast_sodium_current__IC_Na3 - var_chaste_interface__fast_sodium_current__IF_Na - var_chaste_interface__fast_sodium_current__O_Na) / (0.20000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V)) - 0.19170000000000001 * var_chaste_interface__fast_sodium_current__C_Na2 * exp(-0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V) - 3.802 * var_chaste_interface__fast_sodium_current__C_Na2 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IC_Na2 = (0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__C_Na2 + 0.20000000000000001 * var_chaste_interface__fast_sodium_current__IF_Na * exp(0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V) + 3.802 * var_chaste_interface__fast_sodium_current__IC_Na3 / (0.20000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V)) - 6.9999999999999997e-7 * var_chaste_interface__fast_sodium_current__IC_Na2 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V) - 0.19170000000000001 * var_chaste_interface__fast_sodium_current__IC_Na2 * exp(-0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V) - 3.802 * var_chaste_interface__fast_sodium_current__IC_Na2 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IC_Na3 = (0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V) * (1.0 - var_chaste_interface__fast_sodium_current__C_Na1 - var_chaste_interface__fast_sodium_current__C_Na2 - var_chaste_interface__fast_sodium_current__I1_Na - var_chaste_interface__fast_sodium_current__I2_Na - var_chaste_interface__fast_sodium_current__IC_Na2 - var_chaste_interface__fast_sodium_current__IC_Na3 - var_chaste_interface__fast_sodium_current__IF_Na - var_chaste_interface__fast_sodium_current__O_Na) + 0.19170000000000001 * var_chaste_interface__fast_sodium_current__IC_Na2 * exp(-0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V) - 6.9999999999999997e-7 * var_chaste_interface__fast_sodium_current__IC_Na3 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V) - 3.802 * var_chaste_interface__fast_sodium_current__IC_Na3 / (0.20000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__O_Na = 3.802 * var_chaste_interface__fast_sodium_current__C_Na1 / (0.25 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V)) - 1.0 * var_chaste_interface__fast_sodium_current__O_Na / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)) - 0.22 * var_chaste_interface__fast_sodium_current__O_Na * exp(0.36945812807881773 - 0.04926108374384236 * var_chaste_interface__membrane__V) + 1.2097272727272726e-5 * var_chaste_interface__fast_sodium_current__IF_Na * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V) / ((0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)) * (0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V) * (0.25 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V)) * exp(0.36945812807881773 - 0.04926108374384236 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IF_Na = (0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__C_Na1 + var_chaste_interface__fast_sodium_current__O_Na / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)) + 6.9999999999999997e-7 * var_chaste_interface__fast_sodium_current__I1_Na * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V) + 3.802 * var_chaste_interface__fast_sodium_current__IC_Na2 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V)) - 0.20000000000000001 * var_chaste_interface__fast_sodium_current__IF_Na * exp(0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V) - 6.9999999999999997e-7 * var_chaste_interface__fast_sodium_current__IF_Na * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V) - 0.001 * var_chaste_interface__fast_sodium_current__IF_Na / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)) - 1.2097272727272726e-5 * var_chaste_interface__fast_sodium_current__IF_Na * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V) / ((0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)) * (0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V) * (0.25 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V)) * exp(0.36945812807881773 - 0.04926108374384236 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__I1_Na = 0.001 * var_chaste_interface__fast_sodium_current__IF_Na / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)) + 1.4e-8 * var_chaste_interface__fast_sodium_current__I2_Na * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V) - 6.9999999999999997e-7 * var_chaste_interface__fast_sodium_current__I1_Na * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V) - 1.0526315789473684e-5 * var_chaste_interface__fast_sodium_current__I1_Na / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__I2_Na = 1.0526315789473684e-5 * var_chaste_interface__fast_sodium_current__I1_Na / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)) - 1.4e-8 * var_chaste_interface__fast_sodium_current__I2_Na * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // 1 / millisecond
        const double var_fast_transient_outward_potassium_current__alpha_a = 0.18064 * exp(1.0731000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_transient_outward_potassium_current__alpha_i = 0.00015200000000000001 * exp(-1.9285714285714286 - 0.14285714285714285 * var_chaste_interface__membrane__V) / (1.0 + 0.0067083000000000004 * exp(-4.7857142857142856 - 0.14285714285714285 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_transient_outward_potassium_current__beta_a = 0.39560000000000001 * exp(-1.8711 - 0.062370000000000002 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_transient_outward_potassium_current__beta_i = 0.00095 * exp(4.7857142857142856 + 0.14285714285714285 * var_chaste_interface__membrane__V) / (1.0 + 0.051334999999999999 * exp(4.7857142857142856 + 0.14285714285714285 * var_chaste_interface__membrane__V)); // per_millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__CaNSR = 0.0028598665395614866 * var_chaste_interface__calcium_concentration__CaJSR + 0.0002143069590085796 * var_chaste_interface__calcium_concentration__Cai - 0.0030741734985700662 * var_chaste_interface__calcium_concentration__CaNSR + 5.5424213536701616 * pow(var_chaste_interface__calcium_concentration__Cai, 2) / (0.25 + pow(var_chaste_interface__calcium_concentration__Cai, 2)); // micromolar / millisecond
        const double var_non_inactivating_steady_state_potassium_current__tau_Kss = 13.17 + 39.299999999999997 * exp(-0.086199999999999999 * var_chaste_interface__membrane__V); // millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__I_K = 0.090820999999999999 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * exp(0.11695499999999999 + 0.023390999999999999 * var_chaste_interface__membrane__V) - 0.0064970000000000002 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K * exp(-0.16339999999999999 - 0.032680000000000001 * var_chaste_interface__membrane__V); // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__O_K = 0.0064970000000000002 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K * exp(-0.16339999999999999 - 0.032680000000000001 * var_chaste_interface__membrane__V) + 0.013733 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * exp(0.038198000000000003 * var_chaste_interface__membrane__V) - 6.8899999999999994e-5 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * exp(-0.041779999999999998 * var_chaste_interface__membrane__V) - 0.090820999999999999 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * exp(0.11695499999999999 + 0.023390999999999999 * var_chaste_interface__membrane__V); // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K1 = 0.036777999999999998 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 - 0.023761000000000001 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 + 0.022348 * (1.0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K) * exp(0.01176 * var_chaste_interface__membrane__V) - 0.047002000000000002 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 * exp(-0.063100000000000003 * var_chaste_interface__membrane__V); // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K2 = 0.023761000000000001 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 - 0.036777999999999998 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 + 6.8899999999999994e-5 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * exp(-0.041779999999999998 * var_chaste_interface__membrane__V) - 0.013733 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * exp(0.038198000000000003 * var_chaste_interface__membrane__V); // 1 / millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__CaJSR = (0.050000000000000003 * var_chaste_interface__calcium_concentration__CaNSR - 0.050000000000000003 * var_chaste_interface__calcium_concentration__CaJSR - 4.5 * (-var_chaste_interface__calcium_concentration__Cass + var_chaste_interface__calcium_concentration__CaJSR) * (var_chaste_interface__ryanodine_receptors__P_O1 + var_chaste_interface__ryanodine_receptors__P_O2) * var_chaste_interface__calcium_fluxes__P_RyR) / (1.0 + 18.75 / pow((1 + 0.00125 * var_chaste_interface__calcium_concentration__CaJSR), 2)); // micromolar / millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__Cass = (2175.0841750841751 * var_chaste_interface__calcium_concentration__Cai - 2175.0841750841751 * var_chaste_interface__calcium_concentration__Cass - 92.541511836848613 * (-63.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O + 363.63636363636363 * (-var_chaste_interface__calcium_concentration__Cass + var_chaste_interface__calcium_concentration__CaJSR) * (var_chaste_interface__ryanodine_receptors__P_O1 + var_chaste_interface__ryanodine_receptors__P_O2) * var_chaste_interface__calcium_fluxes__P_RyR) / (1.0 + 11.899999999999999 / pow((0.23799999999999999 + var_chaste_interface__calcium_concentration__Cass), 2)); // micromolar / millisecond
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_C2 = 0.0089999999999999993 * var_chaste_interface__ryanodine_receptors__P_O1 - 0.00080000000000000004 * var_chaste_interface__ryanodine_receptors__P_C2; // 1 / millisecond
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_O2 = -0.96499999999999997 * var_chaste_interface__ryanodine_receptors__P_O2 + 0.0040499999999999998 * pow(var_chaste_interface__calcium_concentration__Cass, 3.0) * var_chaste_interface__ryanodine_receptors__P_O1; // 1 / millisecond
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_O1 = 0.00080000000000000004 * var_chaste_interface__ryanodine_receptors__P_C2 + 0.96499999999999997 * var_chaste_interface__ryanodine_receptors__P_O2 - 0.080249999999999988 * var_chaste_interface__ryanodine_receptors__P_O1 + 0.0060749999999999997 * pow(var_chaste_interface__calcium_concentration__Cass, 4.0) * (1.0 - var_chaste_interface__ryanodine_receptors__P_C2 - var_chaste_interface__ryanodine_receptors__P_O1 - var_chaste_interface__ryanodine_receptors__P_O2) - 0.0040499999999999998 * pow(var_chaste_interface__calcium_concentration__Cass, 3.0) * var_chaste_interface__ryanodine_receptors__P_O1; // 1 / millisecond
        const double var_slow_delayed_rectifier_potassium_current__alpha_n = 4.8133299999999997e-6 * (26.5 + var_chaste_interface__membrane__V) / (1.0 - exp(-3.3919999999999999 - 0.128 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_slow_delayed_rectifier_potassium_current__beta_n = 9.5333299999999997e-5 * exp(-1.0069999999999999 - 0.037999999999999999 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_slow_transient_outward_potassium_current__ass = 1 / (1.0 + exp(-2.9220779220779218 - 0.12987012987012986 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_transient_outward_potassium_current__iss = 1 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_transient_outward_potassium_current__tau_ta_s = 2.0579999999999998 + 0.49299999999999999 * exp(-0.062899999999999998 * var_chaste_interface__membrane__V); // millisecond
        const double var_slow_transient_outward_potassium_current__tau_ti_s = 270.0 + 1050.0 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V)); // millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__Cai = (0.125 * var_chaste_interface__calcium_concentration__Cass + 0.019599999999999999 * var_chaste_interface__calcium_buffering__LTRPN_Ca + 3.1999999999999999e-5 * var_chaste_interface__calcium_buffering__HTRPN_Ca + 1.7399999999999999e-5 * var_chaste_interface__calcium_concentration__CaNSR + 0.00014491407891765456 * log(1800.0 / var_chaste_interface__calcium_concentration__Cai) - 0.1250174 * var_chaste_interface__calcium_concentration__Cai - 1.12886395354433e-5 * var_chaste_interface__membrane__V + 1.6591891954566281e-18 * (1800.0 * pow(var_chaste_interface__sodium_concentration__Nai, 3) * exp(0.013632298072467722 * var_chaste_interface__membrane__V) - 2744000000000000.0 * var_chaste_interface__calcium_concentration__Cai * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) / (1.0 + 0.10000000000000001 * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) - 0.0327 * (70.0 - var_chaste_interface__calcium_buffering__LTRPN_Ca) * var_chaste_interface__calcium_concentration__Cai - 0.0023700000000000001 * (140.0 - var_chaste_interface__calcium_buffering__HTRPN_Ca) * var_chaste_interface__calcium_concentration__Cai - 0.48075923579139868 * pow(var_chaste_interface__calcium_concentration__Cai, 2) / (0.25 + pow(var_chaste_interface__calcium_concentration__Cai, 2))) / (1.0 + 11.899999999999999 / pow((0.23799999999999999 + var_chaste_interface__calcium_concentration__Cai), 2)); // micromolar / millisecond
        const double d_dt_chaste_interface_var_sodium_concentration__Nai = 0.0041065570047509742 * log(140600.0 / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)) - 0.00015994802611527293 * var_chaste_interface__membrane__V - 0.12710251172237072 / ((1.0 + 3043189.1166997822 * pow(1 / var_chaste_interface__sodium_concentration__Nai, 1.5)) * (1.0 + 0.1245 * exp(-0.0038949423064193493 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.038949423064193495 * var_chaste_interface__membrane__V))) - 4.9775675863698838e-18 * (1800.0 * pow(var_chaste_interface__sodium_concentration__Nai, 3) * exp(0.013632298072467722 * var_chaste_interface__membrane__V) - 2744000000000000.0 * var_chaste_interface__calcium_concentration__Cai * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) / (1.0 + 0.10000000000000001 * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) - 0.79974013057636462 * (-25.674321243523316 * log(140600.0 / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)) + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na; // micromolar / millisecond
        const double d_dt_chaste_interface_var_potassium_concentration__Ki = 0.084735007814913818 / ((1.0 + 3043189.1166997822 * pow(1 / var_chaste_interface__sodium_concentration__Nai, 1.5)) * (1.0 + 0.1245 * exp(-0.0038949423064193493 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.038949423064193495 * var_chaste_interface__membrane__V))) - 0.0047984407834581883 * (-25.674321243523316 * log(8257.1428571428569 / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K - 0.017397555353928618 * (-25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki) + var_chaste_interface__membrane__V) / (1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 2.300419183419689 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki))) - 0.00035373121160108434 * pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki) + var_chaste_interface__membrane__V) - 0.025019562392723654 * pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__fast_transient_outward_potassium_current__ito_f - 0.0098429554532475649 * (-25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur - 0.003075923579139864 * (-25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // micromolar / millisecond
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_aur = 2.0579999999999998 + 0.49299999999999999 * exp(-0.062899999999999998 * var_chaste_interface__membrane__V); // millisecond
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_iur = 1200.0 - 170.0 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V)); // millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__V = 0.0047112379481865285 * log(1800.0 / var_chaste_interface__calcium_concentration__Cai) + 0.066753235233160624 * log(140600.0 / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)) - 0.002967 * var_chaste_interface__membrane__V - GetIntracellularAreaStimulus(var_chaste_interface__environment__time) / HeartConfig::Instance()->GetCapacitance() - 1.0 * pow(var_chaste_interface__calcium_concentration__Cai, 2) / (0.25 + pow(var_chaste_interface__calcium_concentration__Cai, 2)) - 13.0 * (-25.674321243523316 * log(140600.0 / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)) + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na - 0.1729 * (-63.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O - 0.0057499999999999999 * pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki) + var_chaste_interface__membrane__V) - 0.078 * (-25.674321243523316 * log(8257.1428571428569 / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K - 0.68869565217391304 / ((1.0 + 3043189.1166997822 * pow(1 / var_chaste_interface__sodium_concentration__Nai, 1.5)) * (1.0 + 0.1245 * exp(-0.0038949423064193493 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.038949423064193495 * var_chaste_interface__membrane__V))) - 2.6970585464294846e-17 * (1800.0 * pow(var_chaste_interface__sodium_concentration__Nai, 3) * exp(0.013632298072467722 * var_chaste_interface__membrane__V) - 2744000000000000.0 * var_chaste_interface__calcium_concentration__Cai * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) / (1.0 + 0.10000000000000001 * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) - 0.28280213903743318 * (-25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki) + var_chaste_interface__membrane__V) / (1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 2.300419183419689 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki))) - 0.050000000000000003 * (-25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss - 0.16 * (-25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur - 0.40670000000000001 * pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki) + var_chaste_interface__membrane__V) * var_chaste_interface__fast_transient_outward_potassium_current__ito_f - 2.0 * (40.0 + var_chaste_interface__membrane__V) * var_chaste_interface__calcium_concentration__Cai / ((1.0 + exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V)) * (10.0 + var_chaste_interface__calcium_concentration__Cai)); // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__V;
        rDY[1] = d_dt_chaste_interface_var_calcium_concentration__Cai;
        rDY[2] = d_dt_chaste_interface_var_calcium_concentration__Cass;
        rDY[3] = d_dt_chaste_interface_var_calcium_concentration__CaJSR;
        rDY[4] = d_dt_chaste_interface_var_calcium_concentration__CaNSR;
        rDY[5] = d_dt_chaste_interface_var_calcium_fluxes__P_RyR;
        rDY[6] = d_dt_chaste_interface_var_calcium_buffering__LTRPN_Ca;
        rDY[7] = d_dt_chaste_interface_var_calcium_buffering__HTRPN_Ca;
        rDY[8] = d_dt_chaste_interface_var_ryanodine_receptors__P_O1;
        rDY[9] = d_dt_chaste_interface_var_ryanodine_receptors__P_O2;
        rDY[10] = d_dt_chaste_interface_var_ryanodine_receptors__P_C2;
        rDY[11] = d_dt_chaste_interface_var_L_type_calcium_current__O;
        rDY[12] = d_dt_chaste_interface_var_L_type_calcium_current__C2;
        rDY[13] = d_dt_chaste_interface_var_L_type_calcium_current__C3;
        rDY[14] = d_dt_chaste_interface_var_L_type_calcium_current__C4;
        rDY[15] = d_dt_chaste_interface_var_L_type_calcium_current__I1;
        rDY[16] = d_dt_chaste_interface_var_L_type_calcium_current__I2;
        rDY[17] = d_dt_chaste_interface_var_L_type_calcium_current__I3;
        rDY[18] = d_dt_chaste_interface_var_sodium_concentration__Nai;
        rDY[19] = d_dt_chaste_interface_var_fast_sodium_current__O_Na;
        rDY[20] = d_dt_chaste_interface_var_fast_sodium_current__C_Na1;
        rDY[21] = d_dt_chaste_interface_var_fast_sodium_current__C_Na2;
        rDY[22] = d_dt_chaste_interface_var_fast_sodium_current__I1_Na;
        rDY[23] = d_dt_chaste_interface_var_fast_sodium_current__I2_Na;
        rDY[24] = d_dt_chaste_interface_var_fast_sodium_current__IF_Na;
        rDY[25] = d_dt_chaste_interface_var_fast_sodium_current__IC_Na2;
        rDY[26] = d_dt_chaste_interface_var_fast_sodium_current__IC_Na3;
        rDY[27] = d_dt_chaste_interface_var_potassium_concentration__Ki;
        rAlphaOrTau[28] = var_fast_transient_outward_potassium_current__alpha_a;
        rBetaOrInf[28] = var_fast_transient_outward_potassium_current__beta_a;
        rAlphaOrTau[29] = var_fast_transient_outward_potassium_current__alpha_i;
        rBetaOrInf[29] = var_fast_transient_outward_potassium_current__beta_i;
        rAlphaOrTau[30] = var_slow_transient_outward_potassium_current__tau_ta_s;
        rBetaOrInf[30] = var_slow_transient_outward_potassium_current__ass;
        rAlphaOrTau[31] = var_slow_transient_outward_potassium_current__tau_ti_s;
        rBetaOrInf[31] = var_slow_transient_outward_potassium_current__iss;
        rAlphaOrTau[32] = var_slow_delayed_rectifier_potassium_current__alpha_n;
        rBetaOrInf[32] = var_slow_delayed_rectifier_potassium_current__beta_n;
        rAlphaOrTau[33] = var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_aur;
        rBetaOrInf[33] = var_slow_transient_outward_potassium_current__ass;
        rAlphaOrTau[34] = var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_iur;
        rBetaOrInf[34] = var_slow_transient_outward_potassium_current__iss;
        rAlphaOrTau[35] = var_non_inactivating_steady_state_potassium_current__tau_Kss;
        rBetaOrInf[35] = var_slow_transient_outward_potassium_current__ass;
        rDY[36] = d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__iKss;
        rDY[37] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__O_K;
        rDY[38] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K1;
        rDY[39] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K2;
        rDY[40] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__I_K;
    }
    void Cellbondarenko_model_2004_apexFromCellMLRushLarsenOpt::ComputeOneStepExceptVoltage(const std::vector<double> &rDY, const std::vector<double> &rAlphaOrTau, const std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        
        rY[1] += mDt * rDY[1];
        rY[2] += mDt * rDY[2];
        rY[3] += mDt * rDY[3];
        rY[4] += mDt * rDY[4];
        rY[5] += mDt * rDY[5];
        rY[6] += mDt * rDY[6];
        rY[7] += mDt * rDY[7];
        rY[8] += mDt * rDY[8];
        rY[9] += mDt * rDY[9];
        rY[10] += mDt * rDY[10];
        rY[11] += mDt * rDY[11];
        rY[12] += mDt * rDY[12];
        rY[13] += mDt * rDY[13];
        rY[14] += mDt * rDY[14];
        rY[15] += mDt * rDY[15];
        rY[16] += mDt * rDY[16];
        rY[17] += mDt * rDY[17];
        rY[18] += mDt * rDY[18];
        rY[19] += mDt * rDY[19];
        rY[20] += mDt * rDY[20];
        rY[21] += mDt * rDY[21];
        rY[22] += mDt * rDY[22];
        rY[23] += mDt * rDY[23];
        rY[24] += mDt * rDY[24];
        rY[25] += mDt * rDY[25];
        rY[26] += mDt * rDY[26];
        rY[27] += mDt * rDY[27];
        {
            const double tau_inv = rAlphaOrTau[28] + rBetaOrInf[28];
            const double y_inf = rAlphaOrTau[28] / tau_inv;
            rY[28] = y_inf + (rY[28] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[29] + rBetaOrInf[29];
            const double y_inf = rAlphaOrTau[29] / tau_inv;
            rY[29] = y_inf + (rY[29] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[30] = rBetaOrInf[30] + (rY[30] - rBetaOrInf[30])*exp(-mDt/rAlphaOrTau[30]);
        rY[31] = rBetaOrInf[31] + (rY[31] - rBetaOrInf[31])*exp(-mDt/rAlphaOrTau[31]);
        {
            const double tau_inv = rAlphaOrTau[32] + rBetaOrInf[32];
            const double y_inf = rAlphaOrTau[32] / tau_inv;
            rY[32] = y_inf + (rY[32] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[33] = rBetaOrInf[33] + (rY[33] - rBetaOrInf[33])*exp(-mDt/rAlphaOrTau[33]);
        rY[34] = rBetaOrInf[34] + (rY[34] - rBetaOrInf[34])*exp(-mDt/rAlphaOrTau[34]);
        rY[35] = rBetaOrInf[35] + (rY[35] - rBetaOrInf[35])*exp(-mDt/rAlphaOrTau[35]);
        rY[36] += mDt * rDY[36];
        rY[37] += mDt * rDY[37];
        rY[38] += mDt * rDY[38];
        rY[39] += mDt * rDY[39];
        rY[40] += mDt * rDY[40];
    }

    std::vector<double> Cellbondarenko_model_2004_apexFromCellMLRushLarsenOpt::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_membrane__i_stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellbondarenko_model_2004_apexFromCellMLRushLarsenOpt>::Initialise(void)
{
    this->mSystemName = "bondarenko_model_2004_apex";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-82.4202);

    // rY[1]:
    this->mVariableNames.push_back("calcium_concentration__Cai");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(0.115001);

    // rY[2]:
    this->mVariableNames.push_back("calcium_concentration__Cass");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(0.115001);

    // rY[3]:
    this->mVariableNames.push_back("calcium_concentration__CaJSR");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(1299.5);

    // rY[4]:
    this->mVariableNames.push_back("calcium_concentration__CaNSR");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(1299.5);

    // rY[5]:
    this->mVariableNames.push_back("calcium_fluxes__P_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[6]:
    this->mVariableNames.push_back("calcium_buffering__LTRPN_Ca");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(11.2684);

    // rY[7]:
    this->mVariableNames.push_back("calcium_buffering__HTRPN_Ca");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(125.29);

    // rY[8]:
    this->mVariableNames.push_back("ryanodine_receptors__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.49102e-05);

    // rY[9]:
    this->mVariableNames.push_back("ryanodine_receptors__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.51726e-11);

    // rY[10]:
    this->mVariableNames.push_back("ryanodine_receptors__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00016774);

    // rY[11]:
    this->mVariableNames.push_back("L_type_calcium_current__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.30308e-19);

    // rY[12]:
    this->mVariableNames.push_back("L_type_calcium_current__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000124216);

    // rY[13]:
    this->mVariableNames.push_back("L_type_calcium_current__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(5.78679e-09);

    // rY[14]:
    this->mVariableNames.push_back("L_type_calcium_current__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.19816e-13);

    // rY[15]:
    this->mVariableNames.push_back("L_type_calcium_current__I1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(4.97923e-19);

    // rY[16]:
    this->mVariableNames.push_back("L_type_calcium_current__I2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.45847e-14);

    // rY[17]:
    this->mVariableNames.push_back("L_type_calcium_current__I3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.85106e-14);

    // rY[18]:
    this->mVariableNames.push_back("sodium_concentration__Nai");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(14237.1);

    // rY[19]:
    this->mVariableNames.push_back("fast_sodium_current__O_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.13483e-07);

    // rY[20]:
    this->mVariableNames.push_back("fast_sodium_current__C_Na1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000279132);

    // rY[21]:
    this->mVariableNames.push_back("fast_sodium_current__C_Na2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.020752);

    // rY[22]:
    this->mVariableNames.push_back("fast_sodium_current__I1_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.73345e-07);

    // rY[23]:
    this->mVariableNames.push_back("fast_sodium_current__I2_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.55787e-09);

    // rY[24]:
    this->mVariableNames.push_back("fast_sodium_current__IF_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000153176);

    // rY[25]:
    this->mVariableNames.push_back("fast_sodium_current__IC_Na2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0113879);

    // rY[26]:
    this->mVariableNames.push_back("fast_sodium_current__IC_Na3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.34278);

    // rY[27]:
    this->mVariableNames.push_back("potassium_concentration__Ki");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(143720.0);

    // rY[28]:
    this->mVariableNames.push_back("fast_transient_outward_potassium_current__ato_f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00265563);

    // rY[29]:
    this->mVariableNames.push_back("fast_transient_outward_potassium_current__ito_f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999977);

    // rY[30]:
    this->mVariableNames.push_back("slow_transient_outward_potassium_current__ato_s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // rY[31]:
    this->mVariableNames.push_back("slow_transient_outward_potassium_current__ito_s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.998543);

    // rY[32]:
    this->mVariableNames.push_back("slow_delayed_rectifier_potassium_current__nKs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000262753);

    // rY[33]:
    this->mVariableNames.push_back("ultra_rapidly_activating_delayed_rectifier_potassium_current__aur");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // rY[34]:
    this->mVariableNames.push_back("ultra_rapidly_activating_delayed_rectifier_potassium_current__iur");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.998543);

    // rY[35]:
    this->mVariableNames.push_back("non_inactivating_steady_state_potassium_current__aKss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // rY[36]:
    this->mVariableNames.push_back("non_inactivating_steady_state_potassium_current__iKss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // rY[37]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__O_K");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000175298);

    // rY[38]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__C_K1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000992513);

    // rY[39]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__C_K2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000641229);

    // rY[40]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__I_K");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.19129e-05);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.0002;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellbondarenko_model_2004_apexFromCellMLRushLarsenOpt)
