//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: aslanidi_model_2009
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "aslanidi_model_2009.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellaslanidi_model_2009FromCellMLRushLarsenOpt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_chaste_interface__membrane__stim_amplitude_converted = -1.9999999999999998e-5 * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 0.20000000000000001; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 500.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 10.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellaslanidi_model_2009FromCellMLRushLarsenOpt::Cellaslanidi_model_2009FromCellMLRushLarsenOpt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractRushLarsenCardiacCell(
                29,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellaslanidi_model_2009FromCellMLRushLarsenOpt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 5.0000000000000002e-5; // (var_membrane__Cm) [nanoF]
    }

    Cellaslanidi_model_2009FromCellMLRushLarsenOpt::~Cellaslanidi_model_2009FromCellMLRushLarsenOpt()
    {
    }
    
    double Cellaslanidi_model_2009FromCellMLRushLarsenOpt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.01309
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.706
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.61493
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 3e-05
        double var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.99981
        double var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.00046
        double var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.30752
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 6e-05
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = rY[9];
        // Units: dimensionless; Initial value: 0.5753
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = rY[10];
        // Units: dimensionless; Initial value: 0.39871
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = rY[11];
        // Units: dimensionless; Initial value: 0.57363
        double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = rY[12];
        // Units: dimensionless; Initial value: 0.02032
        double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.00016
        double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = rY[14];
        // Units: dimensionless; Initial value: 0.76898
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[17];
        // Units: millimolar; Initial value: 100.0
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
        // Units: millimolar; Initial value: 5.0
        
        const double var_environment__PM = 0; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__E_K = 26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i); // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_sus = ((var_environment__PM == 0) ? (0.098000000000000004 + 0.0014 * var_chaste_interface__membrane__V) : (0.070000000000000007 + 0.001 * var_chaste_interface__membrane__V)); // picoA
        const double var_Ca_independent_transient_outward_K_current__i_to = ((var_environment__PM == 0) ? (0.0100004 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r) : (0.050001999999999998 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r)); // picoA
        const double var_L_type_Ca_channel__i_Ca_L = ((var_environment__PM == 0) ? (0.0072000000000000007 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L)) : (0.0040000000000000001 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L))); // picoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = 2.0000000000000002e-5 * (2.5 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.016955889611951675 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.02072386508127427 * var_chaste_interface__membrane__V)) / (1.0 + 0.00074999999999999991 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_T_type_Ca_channel__i_Ca_T = 0.0060000000000000001 * (-38.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T; // picoA
        const double var_background_currents__i_B_Ca = ((var_environment__PM == 0) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 0.0002653945091048535 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i)) : (3.1000000000000001e-5 * var_chaste_interface__membrane__V - 0.00041136148911252295 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i))); // picoA
        const double var_delayed_rectifier_K_current__i_Kr = 0.0035000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i; // picoA
        const double var_delayed_rectifier_K_current__i_Ks = 0.0025000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_z_gate__z; // picoA
        const double var_inward_rectifier__i_K1 = ((var_environment__PM == 0) ? (0.010160000000000001 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3))) : (0.0050800000000000003 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3)))); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP = 0.0095090000000000001 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_sodium_current__E_Na = 26.53945091048535 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i); // millivolt
        const double var_background_currents__i_B_Na = ((var_environment__PM == 0) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 2.0000000000000002e-5 * var_sodium_current__E_Na) : (6.3999999999999997e-5 * var_chaste_interface__membrane__V - 6.3999999999999997e-5 * var_sodium_current__E_Na)); // picoA
        const double var_sodium_current__i_Na = 0.71257887225271721 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V - 0.037679754693225945 * var_sodium_current__E_Na)) * (0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__membrane__V / (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V)); // picoA
        const double var_sodium_potassium_pump__i_p = 0.10305599999999999 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // picoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_Ca_independent_transient_outward_K_current__i_sus + var_Ca_independent_transient_outward_K_current__i_to + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_T_type_Ca_channel__i_Ca_T + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_delayed_rectifier_K_current__i_Kr + var_delayed_rectifier_K_current__i_Ks + var_inward_rectifier__i_K1 + var_sarcolemmal_calcium_pump_current__i_CaP + var_sodium_current__i_Na + var_sodium_potassium_pump__i_p) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellaslanidi_model_2009FromCellMLRushLarsenOpt::EvaluateEquations(double var_chaste_interface__environment__time_converted, std::vector<double> &rDY, std::vector<double> &rAlphaOrTau, std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.01309
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.706
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.61493
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 3e-05
        double var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.99981
        double var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.00046
        double var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.30752
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 6e-05
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = rY[9];
        // Units: dimensionless; Initial value: 0.5753
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = rY[10];
        // Units: dimensionless; Initial value: 0.39871
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = rY[11];
        // Units: dimensionless; Initial value: 0.57363
        double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = rY[12];
        // Units: dimensionless; Initial value: 0.02032
        double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.00016
        double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = rY[14];
        // Units: dimensionless; Initial value: 0.76898
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[17];
        // Units: millimolar; Initial value: 100.0
        double var_chaste_interface__intracellular_Ca_buffering__O_C = rY[18];
        // Units: dimensionless; Initial value: 0.029108
        double var_chaste_interface__intracellular_Ca_buffering__O_TC = rY[19];
        // Units: dimensionless; Initial value: 0.014071
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[20];
        // Units: dimensionless; Initial value: 0.214036
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[21];
        // Units: dimensionless; Initial value: 0.693565
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
        // Units: millimolar; Initial value: 5.0
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[23];
        // Units: millimolar; Initial value: 0.726776
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[24];
        // Units: millimolar; Initial value: 0.730866
        double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = rY[25];
        // Units: dimensionless; Initial value: 0.465921
        double var_chaste_interface__Ca_handling_by_the_SR__F1 = rY[26];
        // Units: dimensionless; Initial value: 0.288039
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[27];
        // Units: dimensionless; Initial value: 0.002262
        double var_chaste_interface__Ca_handling_by_the_SR__F3 = rY[28];
        // Units: dimensionless; Initial value: 0.612697

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse = -0.40000000000000002 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse + 0.47999999999999998 * (1.0 - var_chaste_interface__Ca_handling_by_the_SR__O_Calse) * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // 1 / millisecond
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg = 5.0 - 5.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC - 5.6660000000000004 * var_chaste_interface__intracellular_Ca_buffering__O_TMgMg; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F3 = -0.00081499999999999997 * var_chaste_interface__Ca_handling_by_the_SR__F3 + 0.001 * (33.960000000000001 + 339.60000000000002 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4)) * var_chaste_interface__Ca_handling_by_the_SR__F2; // 1 / millisecond
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C = -0.47599999999999998 * var_chaste_interface__intracellular_Ca_buffering__O_C + 200.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_C) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / millisecond
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC = -0.39200000000000002 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 78.400000000000006 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TC) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / millisecond
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC = -0.0066 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 200.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel = 0.099999999999999992 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + 12.4 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse - 0.099999999999999992 * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel - 14.880000000000001 * (1.0 - var_chaste_interface__Ca_handling_by_the_SR__O_Calse) * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel - 23.554751134632365 * pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel) / pow((0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2), 2); // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up = 0.011085915847820609 * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel - 0.011085915847820609 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + 0.036557638445284792 * (3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 0.32000000000000006 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up) / (1.3999999999999999 + 0.80000000000000004 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + 3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // millimolar / millisecond
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_infinity = 1 / (1.0 + exp(-2.6628794603230959 - 0.17752529735487307 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_r_gate__tau_r = 0.00040000000000000002 + 1 / (8.0109999999999992 * exp(-0.1388888888888889 * var_chaste_interface__membrane__V) + 386.60000000000002 * exp(0.083333333333333329 * var_chaste_interface__membrane__V)); // second
        const double var_Ca_independent_transient_outward_K_current_s1_gate__s1_infinity = 1 / (1.0 + exp(4.0070821529745047 + 0.14164305949008499 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s1_gate__tau_s1 = 0.020400000000000001 + 0.54659999999999997 / (1.0 + exp(327.99999999999994 + 10.0 * var_chaste_interface__membrane__V)); // second
        const double var_Ca_independent_transient_outward_K_current_s2_gate__s2_infinity = 1 / (1.0 + exp(4.0070821529745047 + 0.14164305949008499 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s2_gate__tau_s2 = 5.75 / (1.0 + exp(327.99999999999994 + 10.0 * var_chaste_interface__membrane__V)) + 0.45000000000000001 / (1.0 + exp(0.96921975662133131 - 0.071581961345740866 * var_chaste_interface__membrane__V)); // second
        const double var_Ca_independent_transient_outward_K_current_s3_gate__s3_infinity = 0.39975990396158467 + 0.60024009603841544 / (1.0 + exp(1.8506208911614319 + 0.036523009495982472 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s3_gate__tau_s3 = 0.5 + 7.5 / (1.0 + exp(46.0 + 2.0 * var_chaste_interface__membrane__V)); // second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1 = 0.00081499999999999997 * var_chaste_interface__Ca_handling_by_the_SR__F3 - 0.001 * (240.0 * exp(-1.6000000000000001 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4)) * var_chaste_interface__Ca_handling_by_the_SR__F1; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2 = 0.001 * (240.0 * exp(-1.6000000000000001 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4)) * var_chaste_interface__Ca_handling_by_the_SR__F1 - 0.001 * (33.960000000000001 + 339.60000000000002 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4)) * var_chaste_interface__Ca_handling_by_the_SR__F2; // 1 / millisecond
        const double var_L_type_Ca_channel_d_L_gate__d_L_infinity = 1 / (1.0 + exp(-1.6590909090909092 - 0.15151515151515152 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_d_L_gate__tau_d_L = 1 / (4.4800000000000004 * (5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)) - 50.0 * (10.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0798668885191347 - 0.20798668885191349 * var_chaste_interface__membrane__V)) - 16.719999999999999 * (45.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-18.0 - 0.40000000000000002 * var_chaste_interface__membrane__V))); // second
        const double var_L_type_Ca_channel_f_L_gate__f_L_infinity = 8.4900000000000002 * (18.0 + var_chaste_interface__membrane__V) / ((-1.0 + exp(4.5 + 0.25 * var_chaste_interface__membrane__V)) * (67.921999999999997 / (1.0 + exp(-4.5 - 0.25 * var_chaste_interface__membrane__V)) + 8.4900000000000002 * (18.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(4.5 + 0.25 * var_chaste_interface__membrane__V)))); // dimensionless
        const double var_L_type_Ca_channel_f_L_gate__tau_f_L = 1 / (67.921999999999997 / (1.0 + exp(-4.5 - 0.25 * var_chaste_interface__membrane__V)) + 8.4900000000000002 * (18.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(4.5 + 0.25 * var_chaste_interface__membrane__V))); // second
        const double var_T_type_Ca_channel_d_T_gate__d_T_infinity = 1 / (1.0 + exp(-3.7704918032786887 - 0.16393442622950821 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_d_T_gate__tau_d_T = 1 / (674.173 * exp(0.77666666666666673 + 0.033333333333333333 * var_chaste_interface__membrane__V) + 674.173 * exp(-0.77666666666666673 - 0.033333333333333333 * var_chaste_interface__membrane__V)); // second
        const double var_T_type_Ca_channel_f_T_gate__f_T_infinity = 9.6370000000000005 * exp(-0.9003601440576231 - 0.012004801920768308 * var_chaste_interface__membrane__V) / (9.6370000000000005 * exp(4.876462938881664 + 0.065019505851755519 * var_chaste_interface__membrane__V) + 9.6370000000000005 * exp(-0.9003601440576231 - 0.012004801920768308 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_f_T_gate__tau_f_T = 1 / (9.6370000000000005 * exp(4.876462938881664 + 0.065019505851755519 * var_chaste_interface__membrane__V) + 9.6370000000000005 * exp(-0.9003601440576231 - 0.012004801920768308 * var_chaste_interface__membrane__V)); // second
        const double var_delayed_rectifier_K_current_pa_gate__p_a_infinity = 1 / (1.0 + exp(-0.68918918918918914 - 0.13513513513513511 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_current_pa_gate__tau_p_a = 1 / (9.0 * exp(0.03941508020968823 * var_chaste_interface__membrane__V) + 1.3 * exp(-0.076769537847382163 * var_chaste_interface__membrane__V)); // second
        const double var_delayed_rectifier_K_current_pi_gate__p_i_infinity = 1 / (1.0 + exp(2.539728728905752 + 0.05358970648917756 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_current_pi_gate__tau_p_i = 1 / (100.0 * exp(-0.018299935950224173 * var_chaste_interface__membrane__V) + 656.0 * exp(0.009420009985210585 * var_chaste_interface__membrane__V)); // second
        const double var_delayed_rectifier_K_current_z_gate__tau_z = 0.059999999999999998 + 1 / (0.29999999999999999 * exp(-0.045816915605241454 * var_chaste_interface__membrane__V) + 1.6599999999999999 * exp(0.014398433450440593 * var_chaste_interface__membrane__V)); // second
        const double var_delayed_rectifier_K_current_z_gate__z_infinity = 1 / (1.0 + exp(0.065217391304347824 - 0.072463768115942032 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = 0.0010559999999999999 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 0.021419999999999998 * var_chaste_interface__intracellular_Ca_buffering__O_C + 0.031359999999999999 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 2.3373323507508574e-7 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 1.7614021922566692e-8 * var_chaste_interface__membrane__V + 3.5228043845133383e-8 * (2.5 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.016955889611951675 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.02072386508127427 * var_chaste_interface__membrane__V)) / (1.0 + 0.00074999999999999991 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 8.3745867230843319e-6 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 6.2720000000000002 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TC) * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 32.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 0.0024659630691593361 * (3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 0.32000000000000006 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up) / (1.3999999999999999 + 0.80000000000000004 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + 3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 9.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_C) * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 6.3410478921240078e-6 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L) + 0.17614021922566689 * pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel) / pow((0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2), 2) - 5.2842065767700066e-6 * (-38.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T; // millimolar / millisecond
        const double var_sodium_current_h1_gate__h_infinity = 44.899999999999999 * exp(-12.010771992818672 - 0.17953321364452424 * var_chaste_interface__membrane__V) / (1491.0 / (1.0 + 323.30000000000001 * exp(-7.333333333333333 - 0.077519379844961239 * var_chaste_interface__membrane__V)) + 44.899999999999999 * exp(-12.010771992818672 - 0.17953321364452424 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h1_gate__tau_h1 = 0.00014999999999999999 + 0.029999999999999999 / (1.0 + exp(6.666666666666667 + 0.16666666666666666 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h2_gate__tau_h2 = 0.00044999999999999999 + 0.12 / (1.0 + exp(30.0 + 0.5 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_m_gate__alpha_m = -460.0 * (44.399999999999999 + var_chaste_interface__membrane__V) / (-1.0 + exp(-3.5035114021936398 - 0.078907914463820727 * var_chaste_interface__membrane__V)); // per_second
        const double var_sodium_current_m_gate__beta_m = 18400.0 * exp(-3.5035114021936398 - 0.078907914463820727 * var_chaste_interface__membrane__V); // per_second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c = 0.00040627234757013896 + 5.8038906795734136e-6 * var_chaste_interface__membrane__V + 1.0364090499238238e-5 * (-26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_z_gate__z + 1.4509726698933535e-5 * (-26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i + 4.145802025143283e-5 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * (-26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r + 4.2119663788904201e-5 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 1.393 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i))) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3)) - 0.00085446536839159674 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = -8.0609592771852979e-5 - 1.151565611026471e-6 * var_chaste_interface__membrane__V - 2.0563671625472697e-6 * (-26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_z_gate__z - 2.8789140275661778e-6 * (-26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i - 8.2257976689350868e-6 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * (-26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r - 8.3570761485921043e-6 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 1.393 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i))) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3)) + 0.00016953677944277714 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = 4.3659884291485854e-7 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i) - 1.6450937300378158e-8 * var_chaste_interface__membrane__V - 4.9352811901134478e-8 * (2.5 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.016955889611951675 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.02072386508127427 * var_chaste_interface__membrane__V)) / (1.0 + 0.00074999999999999991 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 0.00025430516916416572 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))) - 0.00058612951745018135 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V - 1.0 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i))) * (0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__membrane__V / (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V)); // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__V = -0.001 * (0.098000000000000004 + 0.0014400000000000001 * var_chaste_interface__membrane__V - 0.0002653945091048535 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i) - 0.00053078901820970701 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i) + 0.0095090000000000001 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i) + 0.0025000000000000001 * (-26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_z_gate__z + 2.0000000000000002e-5 * (2.5 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.016955889611951675 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.02072386508127427 * var_chaste_interface__membrane__V)) / (1.0 + 0.00074999999999999991 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i) + 0.0072000000000000007 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L) + 0.0060000000000000001 * (-38.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T + 0.0035000000000000001 * (-26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i + 1000.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted) * mParameters[0] / HeartConfig::Instance()->GetCapacitance() + 0.010160000000000001 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 1.393 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i))) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3)) + 0.0100004 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * (-26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) + var_chaste_interface__membrane__V) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r + 0.71257887225271721 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V - 1.0 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i))) * (0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__membrane__V / (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V)) + 0.10305599999999999 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5)))) / mParameters[0]; // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__V;
        rAlphaOrTau[1] = 0.001 * var_sodium_current_m_gate__alpha_m;
        rBetaOrInf[1] = 0.001 * var_sodium_current_m_gate__beta_m;
        rAlphaOrTau[2] = 1000.0 * var_sodium_current_h1_gate__tau_h1;
        rBetaOrInf[2] = var_sodium_current_h1_gate__h_infinity;
        rAlphaOrTau[3] = 1000.0 * var_sodium_current_h2_gate__tau_h2;
        rBetaOrInf[3] = var_sodium_current_h1_gate__h_infinity;
        rAlphaOrTau[4] = 1000.0 * var_L_type_Ca_channel_d_L_gate__tau_d_L;
        rBetaOrInf[4] = var_L_type_Ca_channel_d_L_gate__d_L_infinity;
        rAlphaOrTau[5] = 1000.0 * var_L_type_Ca_channel_f_L_gate__tau_f_L;
        rBetaOrInf[5] = var_L_type_Ca_channel_f_L_gate__f_L_infinity;
        rAlphaOrTau[6] = 1000.0 * var_T_type_Ca_channel_d_T_gate__tau_d_T;
        rBetaOrInf[6] = var_T_type_Ca_channel_d_T_gate__d_T_infinity;
        rAlphaOrTau[7] = 1000.0 * var_T_type_Ca_channel_f_T_gate__tau_f_T;
        rBetaOrInf[7] = var_T_type_Ca_channel_f_T_gate__f_T_infinity;
        rAlphaOrTau[8] = 1000.0 * var_Ca_independent_transient_outward_K_current_r_gate__tau_r;
        rBetaOrInf[8] = var_Ca_independent_transient_outward_K_current_r_gate__r_infinity;
        rAlphaOrTau[9] = 1000.0 * var_Ca_independent_transient_outward_K_current_s1_gate__tau_s1;
        rBetaOrInf[9] = var_Ca_independent_transient_outward_K_current_s1_gate__s1_infinity;
        rAlphaOrTau[10] = 1000.0 * var_Ca_independent_transient_outward_K_current_s2_gate__tau_s2;
        rBetaOrInf[10] = var_Ca_independent_transient_outward_K_current_s2_gate__s2_infinity;
        rAlphaOrTau[11] = 1000.0 * var_Ca_independent_transient_outward_K_current_s3_gate__tau_s3;
        rBetaOrInf[11] = var_Ca_independent_transient_outward_K_current_s3_gate__s3_infinity;
        rAlphaOrTau[12] = 1000.0 * var_delayed_rectifier_K_current_z_gate__tau_z;
        rBetaOrInf[12] = var_delayed_rectifier_K_current_z_gate__z_infinity;
        rAlphaOrTau[13] = 1000.0 * var_delayed_rectifier_K_current_pa_gate__tau_p_a;
        rBetaOrInf[13] = var_delayed_rectifier_K_current_pa_gate__p_a_infinity;
        rAlphaOrTau[14] = 1000.0 * var_delayed_rectifier_K_current_pi_gate__tau_p_i;
        rBetaOrInf[14] = var_delayed_rectifier_K_current_pi_gate__p_i_infinity;
        rDY[15] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
        rDY[16] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
        rDY[17] = d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
        rDY[18] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C;
        rDY[19] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC;
        rDY[20] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC;
        rDY[21] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg;
        rDY[22] = d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c;
        rDY[23] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel;
        rDY[24] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up;
        rDY[25] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse;
        rDY[26] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1;
        rDY[27] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2;
        rDY[28] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F3;
    }
    void Cellaslanidi_model_2009FromCellMLRushLarsenOpt::ComputeOneStepExceptVoltage(const std::vector<double> &rDY, const std::vector<double> &rAlphaOrTau, const std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        
        {
            const double tau_inv = rAlphaOrTau[1] + rBetaOrInf[1];
            const double y_inf = rAlphaOrTau[1] / tau_inv;
            rY[1] = y_inf + (rY[1] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[2] = rBetaOrInf[2] + (rY[2] - rBetaOrInf[2])*exp(-mDt/rAlphaOrTau[2]);
        rY[3] = rBetaOrInf[3] + (rY[3] - rBetaOrInf[3])*exp(-mDt/rAlphaOrTau[3]);
        rY[4] = rBetaOrInf[4] + (rY[4] - rBetaOrInf[4])*exp(-mDt/rAlphaOrTau[4]);
        rY[5] = rBetaOrInf[5] + (rY[5] - rBetaOrInf[5])*exp(-mDt/rAlphaOrTau[5]);
        rY[6] = rBetaOrInf[6] + (rY[6] - rBetaOrInf[6])*exp(-mDt/rAlphaOrTau[6]);
        rY[7] = rBetaOrInf[7] + (rY[7] - rBetaOrInf[7])*exp(-mDt/rAlphaOrTau[7]);
        rY[8] = rBetaOrInf[8] + (rY[8] - rBetaOrInf[8])*exp(-mDt/rAlphaOrTau[8]);
        rY[9] = rBetaOrInf[9] + (rY[9] - rBetaOrInf[9])*exp(-mDt/rAlphaOrTau[9]);
        rY[10] = rBetaOrInf[10] + (rY[10] - rBetaOrInf[10])*exp(-mDt/rAlphaOrTau[10]);
        rY[11] = rBetaOrInf[11] + (rY[11] - rBetaOrInf[11])*exp(-mDt/rAlphaOrTau[11]);
        rY[12] = rBetaOrInf[12] + (rY[12] - rBetaOrInf[12])*exp(-mDt/rAlphaOrTau[12]);
        rY[13] = rBetaOrInf[13] + (rY[13] - rBetaOrInf[13])*exp(-mDt/rAlphaOrTau[13]);
        rY[14] = rBetaOrInf[14] + (rY[14] - rBetaOrInf[14])*exp(-mDt/rAlphaOrTau[14]);
        rY[15] += mDt * rDY[15];
        rY[16] += mDt * rDY[16];
        rY[17] += mDt * rDY[17];
        rY[18] += mDt * rDY[18];
        rY[19] += mDt * rDY[19];
        rY[20] += mDt * rDY[20];
        rY[21] += mDt * rDY[21];
        rY[22] += mDt * rDY[22];
        rY[23] += mDt * rDY[23];
        rY[24] += mDt * rDY[24];
        rY[25] += mDt * rDY[25];
        rY[26] += mDt * rDY[26];
        rY[27] += mDt * rDY[27];
        rY[28] += mDt * rDY[28];
    }

    std::vector<double> Cellaslanidi_model_2009FromCellMLRushLarsenOpt::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(3);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__Cm_converted;
        dqs[2] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellaslanidi_model_2009FromCellMLRushLarsenOpt>::Initialise(void)
{
    this->mSystemName = "aslanidi_model_2009";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-80.0);

    // rY[1]:
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01309);

    // rY[2]:
    this->mVariableNames.push_back("sodium_current_h1_gate__h1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.706);

    // rY[3]:
    this->mVariableNames.push_back("sodium_current_h2_gate__h2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.61493);

    // rY[4]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_L_gate__d_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3e-05);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_L_gate__f_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99981);

    // rY[6]:
    this->mVariableNames.push_back("T_type_Ca_channel_d_T_gate__d_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00046);

    // rY[7]:
    this->mVariableNames.push_back("T_type_Ca_channel_f_T_gate__f_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.30752);

    // rY[8]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6e-05);

    // rY[9]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s1_gate__s1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5753);

    // rY[10]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s2_gate__s2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.39871);

    // rY[11]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s3_gate__s3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.57363);

    // rY[12]:
    this->mVariableNames.push_back("delayed_rectifier_K_current_z_gate__z");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02032);

    // rY[13]:
    this->mVariableNames.push_back("delayed_rectifier_K_current_pa_gate__p_a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00016);

    // rY[14]:
    this->mVariableNames.push_back("delayed_rectifier_K_current_pi_gate__p_i");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.76898);

    // rY[15]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.4);

    // rY[16]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.1e-05);

    // rY[17]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(100.0);

    // rY[18]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.029108);

    // rY[19]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TC");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.014071);

    // rY[20]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TMgC");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.214036);

    // rY[21]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TMgMg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.693565);

    // rY[22]:
    this->mVariableNames.push_back("cleft_space_ion_concentrations__K_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.0);

    // rY[23]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.726776);

    // rY[24]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.730866);

    // rY[25]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__O_Calse");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.465921);

    // rY[26]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.288039);

    // rY[27]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002262);

    // rY[28]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.612697);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("nanoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellaslanidi_model_2009FromCellMLRushLarsenOpt)
