//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: grandi2010
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "grandi2010ss.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellgrandi2010ssFromCellMLRushLarsen::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__cell__stim_amplitude_converted = -15.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__cell__stim_duration = 3.0; // ms
        const double var_chaste_interface__cell__stim_offset = 0; // ms
        const double var_chaste_interface__cell__stim_period = 1000.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__cell__stim_amplitude_converted),
                var_chaste_interface__cell__stim_duration,
                var_chaste_interface__cell__stim_period,
                var_chaste_interface__cell__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellgrandi2010ssFromCellMLRushLarsen::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[37];
    }
    Cellgrandi2010ssFromCellMLRushLarsen::Cellgrandi2010ssFromCellMLRushLarsen(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractRushLarsenCardiacCell(
                38,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellgrandi2010ssFromCellMLRushLarsen>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 1.0; // (var_cell__G_CaL_mult) [dimensionless]
        this->mParameters[1] = 23.0; // (var_cell__GNa) [dimensionless]
        this->mParameters[2] = 1.0; // (var_cell__gkr_mult) [dimensionless]
    }

    Cellgrandi2010ssFromCellMLRushLarsen::~Cellgrandi2010ssFromCellMLRushLarsen()
    {
    }
    
    double Cellgrandi2010ssFromCellMLRushLarsen::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__cell__sVm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -81.3842590704928
        double var_chaste_interface__cell__sm = rY[1];
        // Units: dimensionless; Initial value: 0.00384941567866232
        double var_chaste_interface__cell__sh = rY[2];
        // Units: dimensionless; Initial value: 0.623723834301669
        double var_chaste_interface__cell__sj = rY[3];
        // Units: dimensionless; Initial value: 0.622080736932815
        double var_chaste_interface__cell__sd = rY[4];
        // Units: dimensionless; Initial value: 2.95884913218079e-06
        double var_chaste_interface__cell__sf = rY[5];
        // Units: dimensionless; Initial value: 0.995094078386247
        double var_chaste_interface__cell__sfcaBj = rY[6];
        // Units: dimensionless; Initial value: 0.0246274349529557
        double var_chaste_interface__cell__sfcaBsl = rY[7];
        // Units: dimensionless; Initial value: 0.0150911724206476
        double var_chaste_interface__cell__sxtos = rY[8];
        // Units: dimensionless; Initial value: 0.000442853722673121
        double var_chaste_interface__cell__sytos = rY[9];
        // Units: dimensionless; Initial value: 0.789013894749951
        double var_chaste_interface__cell__sxtof = rY[10];
        // Units: dimensionless; Initial value: 0.000442846429332686
        double var_chaste_interface__cell__sytof = rY[11];
        // Units: dimensionless; Initial value: 0.999995784674368
        double var_chaste_interface__cell__sxkr = rY[12];
        // Units: dimensionless; Initial value: 0.020160578118589
        double var_chaste_interface__cell__sxks = rY[13];
        // Units: dimensionless; Initial value: 0.00430143235332308
        double var_chaste_interface__cell__sNaj = rY[32];
        // Units: dimensionless; Initial value: 8.21411036389602
        double var_chaste_interface__cell__sNasl = rY[33];
        // Units: dimensionless; Initial value: 8.21322794157889
        double var_chaste_interface__cell__sNai = rY[34];
        // Units: dimensionless; Initial value: 8.21340895351653
        double var_chaste_interface__cell__sCaj = rY[35];
        // Units: dimensionless; Initial value: 0.000175648385857736
        double var_chaste_interface__cell__sCasl = rY[36];
        // Units: dimensionless; Initial value: 0.000105614570409386
        
        const double var_cell__Cao = 1.8; // dimensionless
        const double var_cell__Cli = 15.0; // dimensionless
        const double var_cell__Clo = 150.0; // dimensionless
        const double var_cell__Fjunc = 0.11; // dimensionless
        const double var_cell__Fjunc_CaL = 0.90000000000000002; // dimensionless
        const double var_cell__Frdy = 96485.0; // dimensionless
        const double var_cell__Fsl = 1.0 - var_cell__Fjunc; // dimensionless
        const double var_cell__Fsl_CaL = 1.0 - var_cell__Fjunc_CaL; // dimensionless
        const double var_cell__GCaB = 0.00055130000000000001; // dimensionless
        const double var_cell__GClB = 0.0089999999999999993; // dimensionless
        const double var_cell__GClCa = 0.0548125; // dimensionless
        const double var_cell__GNaB = 0.00059699999999999998; // dimensionless
        const double var_cell__GtoFast = 0.1144; // dimensionless
        const double var_cell__GtoSlow = 0.015599999999999999; // dimensionless
        const double var_cell__IbarNCX = 4.5; // dimensionless
        const double var_cell__IbarNaK = 1.8; // dimensionless
        const double var_cell__IbarSLCaP = 0.067299999999999999; // dimensionless
        const double var_cell__KdClCa = 0.10000000000000001; // dimensionless
        const double var_cell__Kdact = 0.00014999999999999999; // dimensionless
        const double var_cell__KmCai = 0.0035899999999999999; // dimensionless
        const double var_cell__KmCao = 1.3; // dimensionless
        const double var_cell__KmKo = 1.5; // dimensionless
        const double var_cell__KmNai = 12.289999999999999; // dimensionless
        const double var_cell__KmNaip = 11.0; // dimensionless
        const double var_cell__KmNao = 87.5; // dimensionless
        const double var_cell__KmPCa = 0.00050000000000000001; // dimensionless
        const double var_cell__Ko = 5.4000000000000004; // dimensionless
        const double var_cell__Nao = 140.0; // dimensionless
        const double var_cell__Q10CaL = 1.8; // dimensionless
        const double var_cell__Q10NCX = 1.5700000000000001; // dimensionless
        const double var_cell__Q10SLCaP = 2.3500000000000001; // dimensionless
        const double var_cell__R = 8314.0; // dimensionless
        const double var_cell__Temp = 310.0; // dimensionless
        const double var_cell__FoRT = var_cell__Frdy / (var_cell__R * var_cell__Temp); // dimensionless
        const double var_cell__Qpow = -31.0 + 0.10000000000000001 * var_cell__Temp; // dimensionless
        const double var_cell__ecl = log(var_cell__Cli / var_cell__Clo) / var_cell__FoRT; // dimensionless
        const double var_cell__fcaCaMSL = 0; // dimensionless
        const double var_cell__fcaCaj = 0; // dimensionless
        const double var_cell__gkp = 0.002; // dimensionless
        const double var_cell__gkr = 0.015061601901917734 * sqrt(var_cell__Ko) * mParameters[2]; // dimensionless
        const double var_cell__gks_junc = 0.0035000000000000001; // dimensionless
        const double var_cell__gks_sl = 0.0035000000000000001; // dimensionless
        const double var_cell__ksat = 0.32000000000000001; // dimensionless
        const double var_cell__nu = 0.27000000000000002; // dimensionless
        const double var_cell__pCa = 0.00027 * mParameters[0]; // dimensionless
        const double var_cell__pK = 1.35e-7 * mParameters[0]; // dimensionless
        const double var_cell__pNa = 7.4999999999999993e-9 * mParameters[0]; // dimensionless
        const double var_cell__pNaK = 0.018329999999999999; // dimensionless
        const double var_cell__I_pca_junc = pow(var_cell__Q10SLCaP, var_cell__Qpow) * pow(var_chaste_interface__cell__sCaj, 1.6000000000000001) * var_cell__Fjunc * var_cell__IbarSLCaP / (pow(var_cell__KmPCa, 1.6000000000000001) + pow(var_chaste_interface__cell__sCaj, 1.6000000000000001)); // dimensionless
        const double var_cell__Ka_junc = 1 / (1.0 + pow(var_cell__Kdact, 2) / pow(var_chaste_interface__cell__sCaj, 2)); // dimensionless
        const double var_cell__eca_junc = 0.5 * log(var_cell__Cao / var_chaste_interface__cell__sCaj) / var_cell__FoRT; // dimensionless
        const double var_cell__I_pca_sl = pow(var_cell__Q10SLCaP, var_cell__Qpow) * pow(var_chaste_interface__cell__sCasl, 1.6000000000000001) * var_cell__Fsl * var_cell__IbarSLCaP / (pow(var_cell__KmPCa, 1.6000000000000001) + pow(var_chaste_interface__cell__sCasl, 1.6000000000000001)); // dimensionless
        const double var_cell__Ka_sl = 1 / (1.0 + pow(var_cell__Kdact, 2) / pow(var_chaste_interface__cell__sCasl, 2)); // dimensionless
        const double var_cell__eca_sl = 0.5 * log(var_cell__Cao / var_chaste_interface__cell__sCasl) / var_cell__FoRT; // dimensionless
        const double var_cell__sKi = 120.0; // dimensionless
        const double var_cell__ek = log(var_cell__Ko / var_cell__sKi) / var_cell__FoRT; // dimensionless
        const double var_cell__eks = log((var_cell__Nao * var_cell__pNaK + var_cell__Ko) / (var_cell__pNaK * var_chaste_interface__cell__sNai + var_cell__sKi)) / var_cell__FoRT; // dimensionless
        const double var_cell__ena_junc = log(var_cell__Nao / var_chaste_interface__cell__sNaj) / var_cell__FoRT; // dimensionless
        const double var_cell__s3_junc = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCaj + pow(var_chaste_interface__cell__sNaj, 3) * var_cell__Cao + pow(var_chaste_interface__cell__sNaj, 3) * var_cell__KmCao + pow(var_cell__KmNao, 3) * (1.0 + var_chaste_interface__cell__sCaj / var_cell__KmCai) * var_chaste_interface__cell__sCaj + pow(var_cell__Nao, 3) * (1.0 + pow(var_chaste_interface__cell__sNaj, 3) / pow(var_cell__KmNai, 3)) * var_cell__KmCai; // dimensionless
        const double var_cell__ena_sl = log(var_cell__Nao / var_chaste_interface__cell__sNasl) / var_cell__FoRT; // dimensionless
        const double var_cell__s3_sl = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCasl + pow(var_chaste_interface__cell__sNasl, 3) * var_cell__Cao + pow(var_chaste_interface__cell__sNasl, 3) * var_cell__KmCao + pow(var_cell__KmNao, 3) * (1.0 + var_chaste_interface__cell__sCasl / var_cell__KmCai) * var_chaste_interface__cell__sCasl + pow(var_cell__Nao, 3) * (1.0 + pow(var_chaste_interface__cell__sNasl, 3) / pow(var_cell__KmNai, 3)) * var_cell__KmCai; // dimensionless
        const double var_cell__I_ClCa_junc = (-var_cell__ecl + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__GClCa / (1.0 + var_cell__KdClCa / var_chaste_interface__cell__sCaj); // dimensionless
        const double var_cell__I_ClCa_sl = (-var_cell__ecl + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__GClCa / (1.0 + var_cell__KdClCa / var_chaste_interface__cell__sCasl); // dimensionless
        const double var_cell__I_ClCa = var_cell__I_ClCa_junc + var_cell__I_ClCa_sl; // dimensionless
        const double var_cell__I_Clbk = (-var_cell__ecl + var_chaste_interface__cell__sVm) * var_cell__GClB; // dimensionless
        const double var_cell__I_Cl_tot = var_cell__I_ClCa + var_cell__I_Clbk; // dimensionless
        const double var_cell__I_cabk_junc = (-var_cell__eca_junc + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__GCaB; // dimensionless
        const double var_cell__I_cabk_sl = (-var_cell__eca_sl + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__GCaB; // dimensionless
        const double var_cell__I_nabk_junc = (-var_cell__ena_junc + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__GNaB; // dimensionless
        const double var_cell__I_nabk_sl = (-var_cell__ena_sl + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__GNaB; // dimensionless
        const double var_cell__aki = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__sVm - 0.23849999999999999 * var_cell__ek)); // dimensionless
        const double var_cell__bki = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__sVm - 0.080320000000000003 * var_cell__ek) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__sVm - 0.061749999999999999 * var_cell__ek)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_cell__ek - 0.51429999999999998 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarca_j = 4.0 * (-0.34100000000000003 * var_cell__Cao + 0.34100000000000003 * var_chaste_interface__cell__sCaj * exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pCa * var_chaste_interface__cell__sVm / (-1.0 + exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarca_sl = 4.0 * (-0.34100000000000003 * var_cell__Cao + 0.34100000000000003 * var_chaste_interface__cell__sCasl * exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pCa * var_chaste_interface__cell__sVm / (-1.0 + exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibark = (-0.75 * var_cell__Ko + 0.75 * var_cell__sKi * exp(var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pK * var_chaste_interface__cell__sVm / (-1.0 + exp(var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarna_j = (-0.75 * var_cell__Nao + 0.75 * var_chaste_interface__cell__sNaj * exp(var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pNa * var_chaste_interface__cell__sVm / (-1.0 + exp(var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarna_sl = (-0.75 * var_cell__Nao + 0.75 * var_chaste_interface__cell__sNasl * exp(var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pNa * var_chaste_interface__cell__sVm / (-1.0 + exp(var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__kiss = var_cell__aki / (var_cell__aki + var_cell__bki); // dimensionless
        const double var_cell__I_ki = 0.15061601901917732 * sqrt(var_cell__Ko) * (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__kiss; // dimensionless
        const double var_cell__kp_kp = 1 / (1.0 + exp(7.4880000000000004 - 0.16722408026755853 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__I_kp_junc = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__gkp * var_cell__kp_kp; // dimensionless
        const double var_cell__I_kp_sl = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__gkp * var_cell__kp_kp; // dimensionless
        const double var_cell__I_kp = var_cell__I_kp_junc + var_cell__I_kp_sl; // dimensionless
        const double var_cell__rkr = 1 / (1.0 + exp(3.0833333333333335 + 0.041666666666666664 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__s1_junc = pow(var_chaste_interface__cell__sNaj, 3) * var_cell__Cao * exp(var_cell__FoRT * var_cell__nu * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__s1_sl = pow(var_chaste_interface__cell__sNasl, 3) * var_cell__Cao * exp(var_cell__FoRT * var_cell__nu * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__s2_junc = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCaj * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__I_ncx_junc = pow(var_cell__Q10NCX, var_cell__Qpow) * (-var_cell__s2_junc + var_cell__s1_junc) * var_cell__Fjunc * var_cell__IbarNCX * var_cell__Ka_junc / ((1.0 + var_cell__ksat * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__s3_junc); // dimensionless
        const double var_cell__s2_sl = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCasl * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__I_ncx_sl = pow(var_cell__Q10NCX, var_cell__Qpow) * (-var_cell__s2_sl + var_cell__s1_sl) * var_cell__Fsl * var_cell__IbarNCX * var_cell__Ka_sl / ((1.0 + var_cell__ksat * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__s3_sl); // dimensionless
        const double var_cell__I_CaNa_junc = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__Fjunc_CaL * var_cell__ibarna_j * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_junc = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__Fjunc_CaL * var_cell__ibarca_j * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_tot_junc = -2.0 * var_cell__I_ncx_junc + var_cell__I_Ca_junc + var_cell__I_cabk_junc + var_cell__I_pca_junc; // dimensionless
        const double var_cell__I_CaK = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * ((1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__Fjunc_CaL + (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__Fsl_CaL) * var_cell__ibark * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_CaNa_sl = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__Fsl_CaL * var_cell__ibarna_sl * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_sl = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__Fsl_CaL * var_cell__ibarca_sl * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_tot_sl = -2.0 * var_cell__I_ncx_sl + var_cell__I_Ca_sl + var_cell__I_cabk_sl + var_cell__I_pca_sl; // dimensionless
        const double var_cell__I_Ca_tot = var_cell__I_Ca_tot_junc + var_cell__I_Ca_tot_sl; // dimensionless
        const double var_cell__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_cell__Nao); // dimensionless
        const double var_cell__fnak = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_cell__FoRT * var_chaste_interface__cell__sVm) + 0.036499999999999998 * var_cell__sigma * exp(-var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__I_nak_junc = var_cell__Fjunc * var_cell__IbarNaK * var_cell__Ko * var_cell__fnak / ((1.0 + pow(var_cell__KmNaip, 4) / pow(var_chaste_interface__cell__sNaj, 4)) * (var_cell__KmKo + var_cell__Ko)); // dimensionless
        const double var_cell__I_nak_sl = var_cell__Fsl * var_cell__IbarNaK * var_cell__Ko * var_cell__fnak / ((1.0 + pow(var_cell__KmNaip, 4) / pow(var_chaste_interface__cell__sNasl, 4)) * (var_cell__KmKo + var_cell__Ko)); // dimensionless
        const double var_cell__I_nak = var_cell__I_nak_junc + var_cell__I_nak_sl; // dimensionless
        const double var_cell__I_Na_junc = pow(var_chaste_interface__cell__sm, 3) * (-var_cell__ena_junc + var_chaste_interface__cell__sVm) * var_cell__Fjunc * mParameters[1] * var_chaste_interface__cell__sh * var_chaste_interface__cell__sj; // dimensionless
        const double var_cell__I_Na_sl = pow(var_chaste_interface__cell__sm, 3) * (-var_cell__ena_sl + var_chaste_interface__cell__sVm) * var_cell__Fsl * mParameters[1] * var_chaste_interface__cell__sh * var_chaste_interface__cell__sj; // dimensionless
        const double var_cell__I_Na_tot_junc = 3.0 * var_cell__I_nak_junc + 3.0 * var_cell__I_ncx_junc + var_cell__I_CaNa_junc + var_cell__I_Na_junc + var_cell__I_nabk_junc; // dimensionless
        const double var_cell__I_Na_tot_sl = 3.0 * var_cell__I_nak_sl + 3.0 * var_cell__I_ncx_sl + var_cell__I_CaNa_sl + var_cell__I_Na_sl + var_cell__I_nabk_sl; // dimensionless
        const double var_cell__I_Na_tot = var_cell__I_Na_tot_junc + var_cell__I_Na_tot_sl; // dimensionless
        const double var_cell__I_kr = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__gkr * var_cell__rkr * var_chaste_interface__cell__sxkr; // dimensionless
        const double var_cell__I_ks_junc = pow(var_chaste_interface__cell__sxks, 2) * (-var_cell__eks + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__gks_junc; // dimensionless
        const double var_cell__I_ks_sl = pow(var_chaste_interface__cell__sxks, 2) * (-var_cell__eks + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__gks_sl; // dimensionless
        const double var_cell__I_ks = var_cell__I_ks_junc + var_cell__I_ks_sl; // dimensionless
        const double var_cell__I_tof = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__GtoFast * var_chaste_interface__cell__sxtof * var_chaste_interface__cell__sytof; // dimensionless
        const double var_cell__I_tos = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__GtoSlow * var_chaste_interface__cell__sxtos * var_chaste_interface__cell__sytos; // dimensionless
        const double var_cell__I_to = var_cell__I_tof + var_cell__I_tos; // dimensionless
        const double var_cell__I_K_tot = -2.0 * var_cell__I_nak + var_cell__I_CaK + var_cell__I_ki + var_cell__I_kp + var_cell__I_kr + var_cell__I_ks + var_cell__I_to; // dimensionless
        const double var_cell__I_tot = var_cell__I_Ca_tot + var_cell__I_Cl_tot + var_cell__I_K_tot + var_cell__I_Na_tot; // uA_per_uF
        const double var_chaste_interface__i_ionic = HeartConfig::Instance()->GetCapacitance() * var_cell__I_tot; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellgrandi2010ssFromCellMLRushLarsen::EvaluateEquations(double var_chaste_interface__cell__time, std::vector<double> &rDY, std::vector<double> &rAlphaOrTau, std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__cell__sVm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -81.3842590704928
        double var_chaste_interface__cell__sm = rY[1];
        // Units: dimensionless; Initial value: 0.00384941567866232
        double var_chaste_interface__cell__sh = rY[2];
        // Units: dimensionless; Initial value: 0.623723834301669
        double var_chaste_interface__cell__sj = rY[3];
        // Units: dimensionless; Initial value: 0.622080736932815
        double var_chaste_interface__cell__sd = rY[4];
        // Units: dimensionless; Initial value: 2.95884913218079e-06
        double var_chaste_interface__cell__sf = rY[5];
        // Units: dimensionless; Initial value: 0.995094078386247
        double var_chaste_interface__cell__sfcaBj = rY[6];
        // Units: dimensionless; Initial value: 0.0246274349529557
        double var_chaste_interface__cell__sfcaBsl = rY[7];
        // Units: dimensionless; Initial value: 0.0150911724206476
        double var_chaste_interface__cell__sxtos = rY[8];
        // Units: dimensionless; Initial value: 0.000442853722673121
        double var_chaste_interface__cell__sytos = rY[9];
        // Units: dimensionless; Initial value: 0.789013894749951
        double var_chaste_interface__cell__sxtof = rY[10];
        // Units: dimensionless; Initial value: 0.000442846429332686
        double var_chaste_interface__cell__sytof = rY[11];
        // Units: dimensionless; Initial value: 0.999995784674368
        double var_chaste_interface__cell__sxkr = rY[12];
        // Units: dimensionless; Initial value: 0.020160578118589
        double var_chaste_interface__cell__sxks = rY[13];
        // Units: dimensionless; Initial value: 0.00430143235332308
        double var_chaste_interface__cell__sRyRr = rY[14];
        // Units: dimensionless; Initial value: 0.893326456705696
        double var_chaste_interface__cell__sRyRo = rY[15];
        // Units: dimensionless; Initial value: 7.56436968249499e-07
        double var_chaste_interface__cell__sRyRi = rY[16];
        // Units: dimensionless; Initial value: 9.03266331737064e-08
        double var_chaste_interface__cell__sNaBj = rY[17];
        // Units: dimensionless; Initial value: 3.41097946062695
        double var_chaste_interface__cell__sNaBsl = rY[18];
        // Units: dimensionless; Initial value: 0.744248540671373
        double var_chaste_interface__cell__sTnCL = rY[19];
        // Units: dimensionless; Initial value: 0.00904644567707666
        double var_chaste_interface__cell__sTnCHc = rY[20];
        // Units: dimensionless; Initial value: 0.1183943202639
        double var_chaste_interface__cell__sTnCHm = rY[21];
        // Units: dimensionless; Initial value: 0.0101423649465603
        double var_chaste_interface__cell__sCaM = rY[22];
        // Units: dimensionless; Initial value: 0.000299824763475116
        double var_chaste_interface__cell__sMyoc = rY[23];
        // Units: dimensionless; Initial value: 0.00201443980536826
        double var_chaste_interface__cell__sMyom = rY[24];
        // Units: dimensionless; Initial value: 0.137467597337588
        double var_chaste_interface__cell__sSRB = rY[25];
        // Units: dimensionless; Initial value: 0.00220110816535249
        double var_chaste_interface__cell__sSLLj = rY[26];
        // Units: dimensionless; Initial value: 0.00739549938515031
        double var_chaste_interface__cell__sSLLsl = rY[27];
        // Units: dimensionless; Initial value: 0.00979616077807075
        double var_chaste_interface__cell__sSLHj = rY[28];
        // Units: dimensionless; Initial value: 0.0735225248399363
        double var_chaste_interface__cell__sSLHsl = rY[29];
        // Units: dimensionless; Initial value: 0.113642236788144
        double var_chaste_interface__cell__sCsqnb = rY[30];
        // Units: dimensionless; Initial value: 1.20762712858574
        double var_chaste_interface__cell__sCa_sr = rY[31];
        // Units: dimensionless; Initial value: 0.563755421404699
        double var_chaste_interface__cell__sNaj = rY[32];
        // Units: dimensionless; Initial value: 8.21411036389602
        double var_chaste_interface__cell__sNasl = rY[33];
        // Units: dimensionless; Initial value: 8.21322794157889
        double var_chaste_interface__cell__sNai = rY[34];
        // Units: dimensionless; Initial value: 8.21340895351653
        double var_chaste_interface__cell__sCaj = rY[35];
        // Units: dimensionless; Initial value: 0.000175648385857736
        double var_chaste_interface__cell__sCasl = rY[36];
        // Units: dimensionless; Initial value: 0.000105614570409386
        double var_chaste_interface__cell__sCai = rY[37];
        // Units: dimensionless; Initial value: 8.85230799863012e-05

        // Mathematics
        double d_dt_chaste_interface_var_cell__sVm;
        const double var_cell__Bmax_CaM = 0.024; // dimensionless
        const double var_cell__Bmax_Naj = 7.5609999999999999; // dimensionless
        const double var_cell__Bmax_Nasl = 1.6499999999999999; // dimensionless
        const double var_cell__Bmax_SR = 0.017100000000000001; // dimensionless
        const double var_cell__Bmax_TnChigh = 0.14000000000000001; // dimensionless
        const double var_cell__Bmax_TnClow = 0.070000000000000007; // dimensionless
        const double var_cell__Bmax_myosin = 0.14000000000000001; // dimensionless
        const double var_cell__Cao = 1.8; // dimensionless
        const double var_cell__Cmem = 1.3809999999999999e-10; // dimensionless
        const double var_cell__Fjunc = 0.11; // dimensionless
        const double var_cell__Fjunc_CaL = 0.90000000000000002; // dimensionless
        const double var_cell__Frdy = 96485.0; // dimensionless
        const double var_cell__Fsl = 1.0 - var_cell__Fjunc; // dimensionless
        const double var_cell__Fsl_CaL = 1.0 - var_cell__Fjunc_CaL; // dimensionless
        const double var_cell__GCaB = 0.00055130000000000001; // dimensionless
        const double var_cell__GNaB = 0.00059699999999999998; // dimensionless
        const double var_cell__IbarNCX = 4.5; // dimensionless
        const double var_cell__IbarNaK = 1.8; // dimensionless
        const double var_cell__IbarSLCaP = 0.067299999999999999; // dimensionless
        const double var_cell__J_ca_juncsl = 8.2413054227789685e-13; // dimensionless
        const double var_cell__J_ca_slmyo = 3.7242560798480505e-12; // dimensionless
        const double var_cell__J_na_juncsl = 1.8312782322060799e-14; // dimensionless
        const double var_cell__J_na_slmyo = 1.6386279222197945e-12; // dimensionless
        const double var_cell__Kdact = 0.00014999999999999999; // dimensionless
        const double var_cell__KmCai = 0.0035899999999999999; // dimensionless
        const double var_cell__KmCao = 1.3; // dimensionless
        const double var_cell__KmKo = 1.5; // dimensionless
        const double var_cell__KmNai = 12.289999999999999; // dimensionless
        const double var_cell__KmNaip = 11.0; // dimensionless
        const double var_cell__KmNao = 87.5; // dimensionless
        const double var_cell__KmPCa = 0.00050000000000000001; // dimensionless
        const double var_cell__Kmf = 0.00024600000000000002; // dimensionless
        const double var_cell__Kmr = 1.7; // dimensionless
        const double var_cell__Ko = 5.4000000000000004; // dimensionless
        const double var_cell__MaxSR = 15.0; // dimensionless
        const double var_cell__Mgi = 1.0; // dimensionless
        const double var_cell__MinSR = 1.0; // dimensionless
        const double var_cell__Nao = 140.0; // dimensionless
        const double var_cell__Q10CaL = 1.8; // dimensionless
        const double var_cell__Q10NCX = 1.5700000000000001; // dimensionless
        const double var_cell__Q10SLCaP = 2.3500000000000001; // dimensionless
        const double var_cell__Q10SRCaP = 2.6000000000000001; // dimensionless
        const double var_cell__R = 8314.0; // dimensionless
        const double var_cell__Temp = 310.0; // dimensionless
        const double var_cell__FoRT = var_cell__Frdy / (var_cell__R * var_cell__Temp); // dimensionless
        const double var_cell__Qpow = -31.0 + 0.10000000000000001 * var_cell__Temp; // dimensionless
        const double var_cell__Vmax_SRCaP = 0.0053114; // dimensionless
        const double var_cell__cellLength = 100.0; // dimensionless
        const double var_cell__cellRadius = 10.25; // dimensionless
        const double var_cell__Vcell = 1.0000000000000001e-15 * M_PI * pow(var_cell__cellRadius, 2) * var_cell__cellLength; // dimensionless
        const double var_cell__Vjunc = 0.00053900000000000009 * var_cell__Vcell; // dimensionless
        const double var_cell__Vmyo = 0.65000000000000002 * var_cell__Vcell; // dimensionless
        const double var_cell__Bmax_SLhighj = 0.000165 * var_cell__Vmyo / var_cell__Vjunc; // dimensionless
        const double var_cell__Bmax_SLlowj = 0.00046000000000000001 * var_cell__Vmyo / var_cell__Vjunc; // dimensionless
        const double var_cell__Vsl = 0.02 * var_cell__Vcell; // dimensionless
        const double var_cell__Bmax_SLhighsl = 0.0134 * var_cell__Vmyo / var_cell__Vsl; // dimensionless
        const double var_cell__Bmax_SLlowsl = 0.037400000000000003 * var_cell__Vmyo / var_cell__Vsl; // dimensionless
        const double var_cell__Vsr = 0.035000000000000003 * var_cell__Vcell; // dimensionless
        const double var_cell__Bmax_Csqn = 0.14000000000000001 * var_cell__Vmyo / var_cell__Vsr; // dimensionless
        const double var_cell__ec50SR = 0.45000000000000001; // dimensionless
        const double var_cell__fcaCaMSL = 0; // dimensionless
        const double var_cell__fcaCaj = 0; // dimensionless
        const double var_cell__hillSRCaP = 1.7869999999999999; // dimensionless
        const double var_cell__kiCa = 0.5; // dimensionless
        const double var_cell__kim = 0.0050000000000000001; // dimensionless
        const double var_cell__koCa = 10.0; // dimensionless
        const double var_cell__koff_cam = 0.23799999999999999; // dimensionless
        const double var_cell__koff_csqn = 65.0; // dimensionless
        const double var_cell__koff_myoca = 0.00046000000000000001; // dimensionless
        const double var_cell__koff_myomg = 5.7000000000000003e-5; // dimensionless
        const double var_cell__koff_na = 0.001; // dimensionless
        const double var_cell__koff_slh = 0.029999999999999999; // dimensionless
        const double var_cell__koff_sll = 1.3; // dimensionless
        const double var_cell__koff_sr = 0.059999999999999998; // dimensionless
        const double var_cell__koff_tnchca = 3.1999999999999999e-5; // dimensionless
        const double var_cell__koff_tnchmg = 0.0033300000000000001; // dimensionless
        const double var_cell__koff_tncl = 0.019599999999999999; // dimensionless
        const double var_cell__kom = 0.059999999999999998; // dimensionless
        const double var_cell__kon_cam = 34.0; // dimensionless
        const double var_cell__kon_csqn = 100.0; // dimensionless
        const double var_cell__kon_myoca = 13.800000000000001; // dimensionless
        const double var_cell__kon_myomg = 0.015699999999999999; // dimensionless
        const double var_cell__kon_na = 0.0001; // dimensionless
        const double var_cell__kon_slh = 100.0; // dimensionless
        const double var_cell__kon_sll = 100.0; // dimensionless
        const double var_cell__kon_sr = 100.0; // dimensionless
        const double var_cell__kon_tnchca = 2.3700000000000001; // dimensionless
        const double var_cell__kon_tnchmg = 0.0030000000000000001; // dimensionless
        const double var_cell__kon_tncl = 32.700000000000003; // dimensionless
        const double var_cell__ks = 25.0; // dimensionless
        const double var_cell__ksat = 0.32000000000000001; // dimensionless
        const double var_cell__nu = 0.27000000000000002; // dimensionless
        const double var_cell__pCa = 0.00027 * mParameters[0]; // dimensionless
        const double var_cell__pNa = 7.4999999999999993e-9 * mParameters[0]; // dimensionless
        const double var_cell__kCaSR = -(-var_cell__MinSR + var_cell__MaxSR) / (1.0 + pow((var_cell__ec50SR / var_chaste_interface__cell__sCa_sr), 2.5)) + var_cell__MaxSR; // dimensionless
        const double var_cell__kiSRCa = var_cell__kCaSR * var_cell__kiCa; // dimensionless
        const double var_cell__koSRCa = var_cell__koCa / var_cell__kCaSR; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCaM = -var_cell__koff_cam * var_chaste_interface__cell__sCaM + (-var_chaste_interface__cell__sCaM + var_cell__Bmax_CaM) * var_cell__kon_cam * var_chaste_interface__cell__sCai; // 1 / ms
        const double var_cell__J_serca = pow(var_cell__Q10SRCaP, var_cell__Qpow) * (pow((var_chaste_interface__cell__sCai / var_cell__Kmf), var_cell__hillSRCaP) - pow((var_chaste_interface__cell__sCa_sr / var_cell__Kmr), var_cell__hillSRCaP)) * var_cell__Vmax_SRCaP / (1.0 + pow((var_chaste_interface__cell__sCai / var_cell__Kmf), var_cell__hillSRCaP) + pow((var_chaste_interface__cell__sCa_sr / var_cell__Kmr), var_cell__hillSRCaP)); // dimensionless
        const double var_cell__I_pca_junc = pow(var_cell__Q10SLCaP, var_cell__Qpow) * pow(var_chaste_interface__cell__sCaj, 1.6000000000000001) * var_cell__Fjunc * var_cell__IbarSLCaP / (pow(var_cell__KmPCa, 1.6000000000000001) + pow(var_chaste_interface__cell__sCaj, 1.6000000000000001)); // dimensionless
        const double var_cell__J_SRleak = 5.3480000000000003e-6 * var_chaste_interface__cell__sCa_sr - 5.3480000000000003e-6 * var_chaste_interface__cell__sCaj; // dimensionless
        const double var_cell__Ka_junc = 1 / (1.0 + pow(var_cell__Kdact, 2) / pow(var_chaste_interface__cell__sCaj, 2)); // dimensionless
        const double var_cell__eca_junc = 0.5 * log(var_cell__Cao / var_chaste_interface__cell__sCaj) / var_cell__FoRT; // dimensionless
        const double var_cell__I_pca_sl = pow(var_cell__Q10SLCaP, var_cell__Qpow) * pow(var_chaste_interface__cell__sCasl, 1.6000000000000001) * var_cell__Fsl * var_cell__IbarSLCaP / (pow(var_cell__KmPCa, 1.6000000000000001) + pow(var_chaste_interface__cell__sCasl, 1.6000000000000001)); // dimensionless
        const double var_cell__Ka_sl = 1 / (1.0 + pow(var_cell__Kdact, 2) / pow(var_chaste_interface__cell__sCasl, 2)); // dimensionless
        const double var_cell__eca_sl = 0.5 * log(var_cell__Cao / var_chaste_interface__cell__sCasl) / var_cell__FoRT; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCsqnb = -var_cell__koff_csqn * var_chaste_interface__cell__sCsqnb + (-var_chaste_interface__cell__sCsqnb + var_cell__Bmax_Csqn) * var_cell__kon_csqn * var_chaste_interface__cell__sCa_sr; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sMyoc = -var_cell__koff_myoca * var_chaste_interface__cell__sMyoc + (-var_chaste_interface__cell__sMyoc - var_chaste_interface__cell__sMyom + var_cell__Bmax_myosin) * var_cell__kon_myoca * var_chaste_interface__cell__sCai; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sMyom = -var_cell__koff_myomg * var_chaste_interface__cell__sMyom + (-var_chaste_interface__cell__sMyoc - var_chaste_interface__cell__sMyom + var_cell__Bmax_myosin) * var_cell__Mgi * var_cell__kon_myomg; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sNaBj = -var_cell__koff_na * var_chaste_interface__cell__sNaBj + (-var_chaste_interface__cell__sNaBj + var_cell__Bmax_Naj) * var_cell__kon_na * var_chaste_interface__cell__sNaj; // 1 / ms
        const double var_cell__ena_junc = log(var_cell__Nao / var_chaste_interface__cell__sNaj) / var_cell__FoRT; // dimensionless
        const double var_cell__s3_junc = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCaj + pow(var_chaste_interface__cell__sNaj, 3) * var_cell__Cao + pow(var_chaste_interface__cell__sNaj, 3) * var_cell__KmCao + pow(var_cell__KmNao, 3) * (1.0 + var_chaste_interface__cell__sCaj / var_cell__KmCai) * var_chaste_interface__cell__sCaj + pow(var_cell__Nao, 3) * (1.0 + pow(var_chaste_interface__cell__sNaj, 3) / pow(var_cell__KmNai, 3)) * var_cell__KmCai; // dimensionless
        const double d_dt_chaste_interface_var_cell__sNaBsl = -var_cell__koff_na * var_chaste_interface__cell__sNaBsl + (-var_chaste_interface__cell__sNaBsl + var_cell__Bmax_Nasl) * var_cell__kon_na * var_chaste_interface__cell__sNasl; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sNai = (-var_chaste_interface__cell__sNai + var_chaste_interface__cell__sNasl) * var_cell__J_na_slmyo / var_cell__Vmyo; // 1 / ms
        const double var_cell__ena_sl = log(var_cell__Nao / var_chaste_interface__cell__sNasl) / var_cell__FoRT; // dimensionless
        const double var_cell__s3_sl = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCasl + pow(var_chaste_interface__cell__sNasl, 3) * var_cell__Cao + pow(var_chaste_interface__cell__sNasl, 3) * var_cell__KmCao + pow(var_cell__KmNao, 3) * (1.0 + var_chaste_interface__cell__sCasl / var_cell__KmCai) * var_chaste_interface__cell__sCasl + pow(var_cell__Nao, 3) * (1.0 + pow(var_chaste_interface__cell__sNasl, 3) / pow(var_cell__KmNai, 3)) * var_cell__KmCai; // dimensionless
        const double var_cell__J_SRCarel = (-var_chaste_interface__cell__sCaj + var_chaste_interface__cell__sCa_sr) * var_cell__ks * var_chaste_interface__cell__sRyRo; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCa_sr = -d_dt_chaste_interface_var_cell__sCsqnb - var_cell__J_SRCarel - var_cell__J_SRleak * var_cell__Vmyo / var_cell__Vsr + var_cell__J_serca; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sRyRo = var_cell__kim * var_chaste_interface__cell__sRyRi - var_cell__kom * var_chaste_interface__cell__sRyRo + pow(var_chaste_interface__cell__sCaj, 2) * var_cell__koSRCa * var_chaste_interface__cell__sRyRr - var_cell__kiSRCa * var_chaste_interface__cell__sCaj * var_chaste_interface__cell__sRyRo; // 1 / ms
        const double var_cell__RI = 1.0 - var_chaste_interface__cell__sRyRi - var_chaste_interface__cell__sRyRo - var_chaste_interface__cell__sRyRr; // dimensionless
        const double d_dt_chaste_interface_var_cell__sRyRi = -var_cell__kim * var_chaste_interface__cell__sRyRi - var_cell__kom * var_chaste_interface__cell__sRyRi + pow(var_chaste_interface__cell__sCaj, 2) * var_cell__RI * var_cell__koSRCa + var_cell__kiSRCa * var_chaste_interface__cell__sCaj * var_chaste_interface__cell__sRyRo; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sRyRr = var_cell__RI * var_cell__kim + var_cell__kom * var_chaste_interface__cell__sRyRo - pow(var_chaste_interface__cell__sCaj, 2) * var_cell__koSRCa * var_chaste_interface__cell__sRyRr - var_cell__kiSRCa * var_chaste_interface__cell__sCaj * var_chaste_interface__cell__sRyRr; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sSLHj = -var_cell__koff_slh * var_chaste_interface__cell__sSLHj + (-var_chaste_interface__cell__sSLHj + var_cell__Bmax_SLhighj) * var_cell__kon_slh * var_chaste_interface__cell__sCaj; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sSLHsl = -var_cell__koff_slh * var_chaste_interface__cell__sSLHsl + (-var_chaste_interface__cell__sSLHsl + var_cell__Bmax_SLhighsl) * var_cell__kon_slh * var_chaste_interface__cell__sCasl; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sSLLj = -var_cell__koff_sll * var_chaste_interface__cell__sSLLj + (-var_chaste_interface__cell__sSLLj + var_cell__Bmax_SLlowj) * var_cell__kon_sll * var_chaste_interface__cell__sCaj; // 1 / ms
        const double var_cell__J_CaB_junction = d_dt_chaste_interface_var_cell__sSLHj + d_dt_chaste_interface_var_cell__sSLLj; // dimensionless
        const double d_dt_chaste_interface_var_cell__sSLLsl = -var_cell__koff_sll * var_chaste_interface__cell__sSLLsl + (-var_chaste_interface__cell__sSLLsl + var_cell__Bmax_SLlowsl) * var_cell__kon_sll * var_chaste_interface__cell__sCasl; // 1 / ms
        const double var_cell__J_CaB_sl = d_dt_chaste_interface_var_cell__sSLHsl + d_dt_chaste_interface_var_cell__sSLLsl; // dimensionless
        const double d_dt_chaste_interface_var_cell__sSRB = -var_cell__koff_sr * var_chaste_interface__cell__sSRB + (-var_chaste_interface__cell__sSRB + var_cell__Bmax_SR) * var_cell__kon_sr * var_chaste_interface__cell__sCai; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sTnCHc = -var_cell__koff_tnchca * var_chaste_interface__cell__sTnCHc + (-var_chaste_interface__cell__sTnCHc - var_chaste_interface__cell__sTnCHm + var_cell__Bmax_TnChigh) * var_cell__kon_tnchca * var_chaste_interface__cell__sCai; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sTnCHm = -var_cell__koff_tnchmg * var_chaste_interface__cell__sTnCHm + (-var_chaste_interface__cell__sTnCHc - var_chaste_interface__cell__sTnCHm + var_cell__Bmax_TnChigh) * var_cell__Mgi * var_cell__kon_tnchmg; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sTnCL = -var_cell__koff_tncl * var_chaste_interface__cell__sTnCL + (-var_chaste_interface__cell__sTnCL + var_cell__Bmax_TnClow) * var_cell__kon_tncl * var_chaste_interface__cell__sCai; // 1 / ms
        const double var_cell__J_CaB_cytosol = d_dt_chaste_interface_var_cell__sCaM + d_dt_chaste_interface_var_cell__sMyoc + d_dt_chaste_interface_var_cell__sMyom + d_dt_chaste_interface_var_cell__sSRB + d_dt_chaste_interface_var_cell__sTnCHc + d_dt_chaste_interface_var_cell__sTnCHm + d_dt_chaste_interface_var_cell__sTnCL; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCai = -var_cell__J_CaB_cytosol + (-var_chaste_interface__cell__sCai + var_chaste_interface__cell__sCasl) * var_cell__J_ca_slmyo / var_cell__Vmyo - var_cell__J_serca * var_cell__Vsr / var_cell__Vmyo; // 1 / ms
        const double var_cell__I_cabk_junc = (-var_cell__eca_junc + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__GCaB; // dimensionless
        const double var_cell__I_cabk_sl = (-var_cell__eca_sl + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__GCaB; // dimensionless
        const double var_cell__I_nabk_junc = (-var_cell__ena_junc + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__GNaB; // dimensionless
        const double var_cell__I_nabk_sl = (-var_cell__ena_sl + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__GNaB; // dimensionless
        const double var_cell__ah = ((var_chaste_interface__cell__sVm >= -40.0) ? (0) : (0.057000000000000002 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__sVm))); // dimensionless
        const double var_cell__aj = ((var_chaste_interface__cell__sVm >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__cell__sVm) * (-25428.0 * exp(0.24440000000000001 * var_chaste_interface__cell__sVm) - 6.9480000000000002e-6 * exp(-0.043909999999999998 * var_chaste_interface__cell__sVm)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__sVm)))); // dimensionless
        const double var_cell__bh = ((var_chaste_interface__cell__sVm >= -40.0) ? (5.9230769230769234 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__sVm))) : (310000.0 * exp(0.34849999999999998 * var_chaste_interface__cell__sVm) + 2.7000000000000002 * exp(0.079000000000000001 * var_chaste_interface__cell__sVm))); // dimensionless
        const double var_cell__bj = ((var_chaste_interface__cell__sVm >= -40.0) ? (0.59999999999999998 * exp(0.057000000000000002 * var_chaste_interface__cell__sVm) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__sVm))) : (0.024240000000000001 * exp(-0.01052 * var_chaste_interface__cell__sVm) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__sVm)))); // dimensionless
        const double var_cell__dss = 1 / (1.0 + exp(-0.83333333333333337 - 0.16666666666666666 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__fss = 1 / (1.0 + exp(3.8888888888888888 + 0.1111111111111111 * var_chaste_interface__cell__sVm)) + 0.59999999999999998 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__hss = 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__cell__sVm)), 2); // dimensionless
        const double var_cell__ibarca_j = 4.0 * (-0.34100000000000003 * var_cell__Cao + 0.34100000000000003 * var_chaste_interface__cell__sCaj * exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pCa * var_chaste_interface__cell__sVm / (-1.0 + exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarca_sl = 4.0 * (-0.34100000000000003 * var_cell__Cao + 0.34100000000000003 * var_chaste_interface__cell__sCasl * exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pCa * var_chaste_interface__cell__sVm / (-1.0 + exp(2.0 * var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarna_j = (-0.75 * var_cell__Nao + 0.75 * var_chaste_interface__cell__sNaj * exp(var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pNa * var_chaste_interface__cell__sVm / (-1.0 + exp(var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ibarna_sl = (-0.75 * var_cell__Nao + 0.75 * var_chaste_interface__cell__sNasl * exp(var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pNa * var_chaste_interface__cell__sVm / (-1.0 + exp(var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__jss = 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__cell__sVm)), 2); // dimensionless
        const double var_cell__mss = 1 / pow((1.0 + exp(-6.2967884828349945 - 0.11074197120708749 * var_chaste_interface__cell__sVm)), 2); // dimensionless
        const double var_cell__s1_junc = pow(var_chaste_interface__cell__sNaj, 3) * var_cell__Cao * exp(var_cell__FoRT * var_cell__nu * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__s1_sl = pow(var_chaste_interface__cell__sNasl, 3) * var_cell__Cao * exp(var_cell__FoRT * var_cell__nu * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__s2_junc = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCaj * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__I_ncx_junc = pow(var_cell__Q10NCX, var_cell__Qpow) * (-var_cell__s2_junc + var_cell__s1_junc) * var_cell__Fjunc * var_cell__IbarNCX * var_cell__Ka_junc / ((1.0 + var_cell__ksat * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__s3_junc); // dimensionless
        const double var_cell__s2_sl = pow(var_cell__Nao, 3) * var_chaste_interface__cell__sCasl * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__I_ncx_sl = pow(var_cell__Q10NCX, var_cell__Qpow) * (-var_cell__s2_sl + var_cell__s1_sl) * var_cell__Fsl * var_cell__IbarNCX * var_cell__Ka_sl / ((1.0 + var_cell__ksat * exp((-1.0 + var_cell__nu) * var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__s3_sl); // dimensionless
        const double d_dt_chaste_interface_var_cell__sfcaBj = -0.011900000000000001 * var_chaste_interface__cell__sfcaBj + 1.7 * (1.0 - var_chaste_interface__cell__sfcaBj) * var_chaste_interface__cell__sCaj; // 1 / ms
        const double var_cell__I_CaNa_junc = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__Fjunc_CaL * var_cell__ibarna_j * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_junc = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__Fjunc_CaL * var_cell__ibarca_j * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_tot_junc = -2.0 * var_cell__I_ncx_junc + var_cell__I_Ca_junc + var_cell__I_cabk_junc + var_cell__I_pca_junc; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCaj = -var_cell__J_CaB_junction + (-var_chaste_interface__cell__sCaj + var_chaste_interface__cell__sCasl) * var_cell__J_ca_juncsl / var_cell__Vjunc + var_cell__J_SRCarel * var_cell__Vsr / var_cell__Vjunc + var_cell__J_SRleak * var_cell__Vmyo / var_cell__Vjunc - 0.5 * var_cell__Cmem * var_cell__I_Ca_tot_junc / (var_cell__Frdy * var_cell__Vjunc); // 1 / ms
        const double d_dt_chaste_interface_var_cell__sfcaBsl = -0.011900000000000001 * var_chaste_interface__cell__sfcaBsl + 1.7 * (1.0 - var_chaste_interface__cell__sfcaBsl) * var_chaste_interface__cell__sCasl; // 1 / ms
        const double var_cell__I_CaNa_sl = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__Fsl_CaL * var_cell__ibarna_sl * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_sl = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__Fsl_CaL * var_cell__ibarca_sl * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
        const double var_cell__I_Ca_tot_sl = -2.0 * var_cell__I_ncx_sl + var_cell__I_Ca_sl + var_cell__I_cabk_sl + var_cell__I_pca_sl; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCasl = -var_cell__J_CaB_sl + (-var_chaste_interface__cell__sCasl + var_chaste_interface__cell__sCai) * var_cell__J_ca_slmyo / var_cell__Vsl + (-var_chaste_interface__cell__sCasl + var_chaste_interface__cell__sCaj) * var_cell__J_ca_juncsl / var_cell__Vsl - 0.5 * var_cell__Cmem * var_cell__I_Ca_tot_sl / (var_cell__Frdy * var_cell__Vsl); // 1 / ms
        const double var_cell__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_cell__Nao); // dimensionless
        const double var_cell__fnak = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_cell__FoRT * var_chaste_interface__cell__sVm) + 0.036499999999999998 * var_cell__sigma * exp(-var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__I_nak_junc = var_cell__Fjunc * var_cell__IbarNaK * var_cell__Ko * var_cell__fnak / ((1.0 + pow(var_cell__KmNaip, 4) / pow(var_chaste_interface__cell__sNaj, 4)) * (var_cell__KmKo + var_cell__Ko)); // dimensionless
        const double var_cell__I_nak_sl = var_cell__Fsl * var_cell__IbarNaK * var_cell__Ko * var_cell__fnak / ((1.0 + pow(var_cell__KmNaip, 4) / pow(var_chaste_interface__cell__sNasl, 4)) * (var_cell__KmKo + var_cell__Ko)); // dimensionless
        const double var_cell__I_Na_junc = pow(var_chaste_interface__cell__sm, 3) * (-var_cell__ena_junc + var_chaste_interface__cell__sVm) * var_cell__Fjunc * mParameters[1] * var_chaste_interface__cell__sh * var_chaste_interface__cell__sj; // dimensionless
        const double var_cell__I_Na_sl = pow(var_chaste_interface__cell__sm, 3) * (-var_cell__ena_sl + var_chaste_interface__cell__sVm) * var_cell__Fsl * mParameters[1] * var_chaste_interface__cell__sh * var_chaste_interface__cell__sj; // dimensionless
        const double var_cell__I_Na_tot_junc = 3.0 * var_cell__I_nak_junc + 3.0 * var_cell__I_ncx_junc + var_cell__I_CaNa_junc + var_cell__I_Na_junc + var_cell__I_nabk_junc; // dimensionless
        const double d_dt_chaste_interface_var_cell__sNaj = -d_dt_chaste_interface_var_cell__sNaBj + (-var_chaste_interface__cell__sNaj + var_chaste_interface__cell__sNasl) * var_cell__J_na_juncsl / var_cell__Vjunc - var_cell__Cmem * var_cell__I_Na_tot_junc / (var_cell__Frdy * var_cell__Vjunc); // 1 / ms
        const double var_cell__I_Na_tot_sl = 3.0 * var_cell__I_nak_sl + 3.0 * var_cell__I_ncx_sl + var_cell__I_CaNa_sl + var_cell__I_Na_sl + var_cell__I_nabk_sl; // dimensionless
        const double d_dt_chaste_interface_var_cell__sNasl = -d_dt_chaste_interface_var_cell__sNaBsl + (-var_chaste_interface__cell__sNasl + var_chaste_interface__cell__sNai) * var_cell__J_na_slmyo / var_cell__Vsl + (-var_chaste_interface__cell__sNasl + var_chaste_interface__cell__sNaj) * var_cell__J_na_juncsl / var_cell__Vsl - var_cell__Cmem * var_cell__I_Na_tot_sl / (var_cell__Frdy * var_cell__Vsl); // 1 / ms
        const double var_cell__taud = 28.571428571428569 * (1.0 - exp(-0.83333333333333337 - 0.16666666666666666 * var_chaste_interface__cell__sVm)) * var_cell__dss / (5.0 + var_chaste_interface__cell__sVm); // dimensionless
        const double var_cell__tauf = 1 / (0.02 + 0.019699999999999999 * exp(-0.23877882250000002 * pow((1 + 0.068965517241379309 * var_chaste_interface__cell__sVm), 2))); // dimensionless
        const double var_cell__tauh = 1 / (var_cell__ah + var_cell__bh); // dimensionless
        const double var_cell__tauj = 1 / (var_cell__aj + var_cell__bj); // dimensionless
        const double var_cell__taum = 0.12920000000000001 * exp(-8.682389366752302 * pow((1 + 0.021838829438742085 * var_chaste_interface__cell__sVm), 2)) + 0.064869999999999997 * exp(-0.0089012876052174655 * pow((-1 + 0.2073398299813394 * var_chaste_interface__cell__sVm), 2)); // dimensionless
        const double var_cell__tauxr = 230.0 / (1.0 + exp(2.0 + 0.050000000000000003 * var_chaste_interface__cell__sVm)) + 3300.0 / ((1.0 + exp(1.2222222222222223 + 0.1111111111111111 * var_chaste_interface__cell__sVm)) * (1.0 + exp(-2.4444444444444446 - 0.1111111111111111 * var_chaste_interface__cell__sVm))); // dimensionless
        const double var_cell__tauxs = 990.10000000000002 / (1.0 + exp(-0.17252124645892353 - 0.070821529745042494 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__tauxtof = 0.5 + 8.5 * exp(-0.81000000000000005 * pow((1 + 0.022222222222222223 * var_chaste_interface__cell__sVm), 2)); // dimensionless
        const double var_cell__tauxtos = 0.5 + 9.0 / (1.0 + exp(0.20000000000000001 + 0.066666666666666666 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__tauytof = 7.0 + 85.0 * exp(-7.2727272727272725 * pow((1 + 0.025000000000000001 * var_chaste_interface__cell__sVm), 2)); // dimensionless
        const double var_cell__tauytos = 30.0 + 800.0 / (1.0 + exp(6.0 + 0.10000000000000001 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__xrss = 1 / (1.0 + exp(-2.0 - 0.20000000000000001 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__xsss = 1 / (1.0 + exp(-0.26666666666666666 - 0.070175438596491224 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__xtoss = 1 / (1.0 + exp(1.4615384615384615 - 0.076923076923076927 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__ytoss = 1 / (1.0 + exp(3.8999999999999999 + 0.20000000000000001 * var_chaste_interface__cell__sVm)); // dimensionless

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_cell__sVm = 0.0;
        }
        else
        {
            const double var_cell__Cli = 15.0; // dimensionless
            const double var_cell__Clo = 150.0; // dimensionless
            const double var_cell__GClB = 0.0089999999999999993; // dimensionless
            const double var_cell__GClCa = 0.0548125; // dimensionless
            const double var_cell__GtoFast = 0.1144; // dimensionless
            const double var_cell__GtoSlow = 0.015599999999999999; // dimensionless
            const double var_cell__KdClCa = 0.10000000000000001; // dimensionless
            const double var_cell__ecl = log(var_cell__Cli / var_cell__Clo) / var_cell__FoRT; // dimensionless
            const double var_cell__gkp = 0.002; // dimensionless
            const double var_cell__gkr = 0.015061601901917734 * sqrt(var_cell__Ko) * mParameters[2]; // dimensionless
            const double var_cell__gks_junc = 0.0035000000000000001; // dimensionless
            const double var_cell__gks_sl = 0.0035000000000000001; // dimensionless
            const double var_cell__pK = 1.35e-7 * mParameters[0]; // dimensionless
            const double var_cell__pNaK = 0.018329999999999999; // dimensionless
            const double var_cell__sKi = 120.0; // dimensionless
            const double var_cell__ek = log(var_cell__Ko / var_cell__sKi) / var_cell__FoRT; // dimensionless
            const double var_cell__eks = log((var_cell__Nao * var_cell__pNaK + var_cell__Ko) / (var_cell__pNaK * var_chaste_interface__cell__sNai + var_cell__sKi)) / var_cell__FoRT; // dimensionless
            const double var_cell__I_ClCa_junc = (-var_cell__ecl + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__GClCa / (1.0 + var_cell__KdClCa / var_chaste_interface__cell__sCaj); // dimensionless
            const double var_cell__I_ClCa_sl = (-var_cell__ecl + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__GClCa / (1.0 + var_cell__KdClCa / var_chaste_interface__cell__sCasl); // dimensionless
            const double var_cell__I_ClCa = var_cell__I_ClCa_junc + var_cell__I_ClCa_sl; // dimensionless
            const double var_cell__I_Clbk = (-var_cell__ecl + var_chaste_interface__cell__sVm) * var_cell__GClB; // dimensionless
            const double var_cell__I_Cl_tot = var_cell__I_ClCa + var_cell__I_Clbk; // dimensionless
            const double var_cell__aki = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__sVm - 0.23849999999999999 * var_cell__ek)); // dimensionless
            const double var_cell__bki = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__sVm - 0.080320000000000003 * var_cell__ek) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__sVm - 0.061749999999999999 * var_cell__ek)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_cell__ek - 0.51429999999999998 * var_chaste_interface__cell__sVm)); // dimensionless
            const double var_cell__ibark = (-0.75 * var_cell__Ko + 0.75 * var_cell__sKi * exp(var_cell__FoRT * var_chaste_interface__cell__sVm)) * var_cell__FoRT * var_cell__Frdy * var_cell__pK * var_chaste_interface__cell__sVm / (-1.0 + exp(var_cell__FoRT * var_chaste_interface__cell__sVm)); // dimensionless
            const double var_cell__kiss = var_cell__aki / (var_cell__aki + var_cell__bki); // dimensionless
            const double var_cell__I_ki = 0.15061601901917732 * sqrt(var_cell__Ko) * (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__kiss; // dimensionless
            const double var_cell__kp_kp = 1 / (1.0 + exp(7.4880000000000004 - 0.16722408026755853 * var_chaste_interface__cell__sVm)); // dimensionless
            const double var_cell__I_kp_junc = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__gkp * var_cell__kp_kp; // dimensionless
            const double var_cell__I_kp_sl = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__gkp * var_cell__kp_kp; // dimensionless
            const double var_cell__I_kp = var_cell__I_kp_junc + var_cell__I_kp_sl; // dimensionless
            const double var_cell__rkr = 1 / (1.0 + exp(3.0833333333333335 + 0.041666666666666664 * var_chaste_interface__cell__sVm)); // dimensionless
            const double var_cell__I_CaK = 0.45000000000000001 * pow(var_cell__Q10CaL, var_cell__Qpow) * ((1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__Fjunc_CaL + (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__Fsl_CaL) * var_cell__ibark * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf; // dimensionless
            const double var_cell__I_Ca_tot = var_cell__I_Ca_tot_junc + var_cell__I_Ca_tot_sl; // dimensionless
            const double var_cell__I_nak = var_cell__I_nak_junc + var_cell__I_nak_sl; // dimensionless
            const double var_cell__I_Na_tot = var_cell__I_Na_tot_junc + var_cell__I_Na_tot_sl; // dimensionless
            const double var_cell__I_kr = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__gkr * var_cell__rkr * var_chaste_interface__cell__sxkr; // dimensionless
            const double var_cell__I_ks_junc = pow(var_chaste_interface__cell__sxks, 2) * (-var_cell__eks + var_chaste_interface__cell__sVm) * var_cell__Fjunc * var_cell__gks_junc; // dimensionless
            const double var_cell__I_ks_sl = pow(var_chaste_interface__cell__sxks, 2) * (-var_cell__eks + var_chaste_interface__cell__sVm) * var_cell__Fsl * var_cell__gks_sl; // dimensionless
            const double var_cell__I_ks = var_cell__I_ks_junc + var_cell__I_ks_sl; // dimensionless
            const double var_cell__I_tof = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__GtoFast * var_chaste_interface__cell__sxtof * var_chaste_interface__cell__sytof; // dimensionless
            const double var_cell__I_tos = (-var_cell__ek + var_chaste_interface__cell__sVm) * var_cell__GtoSlow * var_chaste_interface__cell__sxtos * var_chaste_interface__cell__sytos; // dimensionless
            const double var_cell__I_to = var_cell__I_tof + var_cell__I_tos; // dimensionless
            const double var_cell__I_K_tot = -2.0 * var_cell__I_nak + var_cell__I_CaK + var_cell__I_ki + var_cell__I_kp + var_cell__I_kr + var_cell__I_ks + var_cell__I_to; // dimensionless
            const double var_cell__I_tot = var_cell__I_Ca_tot + var_cell__I_Cl_tot + var_cell__I_K_tot + var_cell__I_Na_tot; // uA_per_uF
            const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__cell__time); // uA_per_cm2
            const double var_cell__i_Stim = var_cell__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
            d_dt_chaste_interface_var_cell__sVm = -var_cell__I_tot - var_cell__i_Stim; // millivolt / ms
        }
        
        rDY[0] = d_dt_chaste_interface_var_cell__sVm;
        rAlphaOrTau[1] = var_cell__taum;
        rBetaOrInf[1] = var_cell__mss;
        rAlphaOrTau[2] = var_cell__tauh;
        rBetaOrInf[2] = var_cell__hss;
        rAlphaOrTau[3] = var_cell__tauj;
        rBetaOrInf[3] = var_cell__jss;
        rAlphaOrTau[4] = var_cell__taud;
        rBetaOrInf[4] = var_cell__dss;
        rAlphaOrTau[5] = var_cell__tauf;
        rBetaOrInf[5] = var_cell__fss;
        rDY[6] = d_dt_chaste_interface_var_cell__sfcaBj;
        rDY[7] = d_dt_chaste_interface_var_cell__sfcaBsl;
        rAlphaOrTau[8] = var_cell__tauxtos;
        rBetaOrInf[8] = var_cell__xtoss;
        rAlphaOrTau[9] = var_cell__tauytos;
        rBetaOrInf[9] = var_cell__ytoss;
        rAlphaOrTau[10] = var_cell__tauxtof;
        rBetaOrInf[10] = var_cell__xtoss;
        rAlphaOrTau[11] = var_cell__tauytof;
        rBetaOrInf[11] = var_cell__ytoss;
        rAlphaOrTau[12] = var_cell__tauxr;
        rBetaOrInf[12] = var_cell__xrss;
        rAlphaOrTau[13] = var_cell__tauxs;
        rBetaOrInf[13] = var_cell__xsss;
        rDY[14] = d_dt_chaste_interface_var_cell__sRyRr;
        rDY[15] = d_dt_chaste_interface_var_cell__sRyRo;
        rDY[16] = d_dt_chaste_interface_var_cell__sRyRi;
        rDY[17] = d_dt_chaste_interface_var_cell__sNaBj;
        rDY[18] = d_dt_chaste_interface_var_cell__sNaBsl;
        rDY[19] = d_dt_chaste_interface_var_cell__sTnCL;
        rDY[20] = d_dt_chaste_interface_var_cell__sTnCHc;
        rDY[21] = d_dt_chaste_interface_var_cell__sTnCHm;
        rDY[22] = d_dt_chaste_interface_var_cell__sCaM;
        rDY[23] = d_dt_chaste_interface_var_cell__sMyoc;
        rDY[24] = d_dt_chaste_interface_var_cell__sMyom;
        rDY[25] = d_dt_chaste_interface_var_cell__sSRB;
        rDY[26] = d_dt_chaste_interface_var_cell__sSLLj;
        rDY[27] = d_dt_chaste_interface_var_cell__sSLLsl;
        rDY[28] = d_dt_chaste_interface_var_cell__sSLHj;
        rDY[29] = d_dt_chaste_interface_var_cell__sSLHsl;
        rDY[30] = d_dt_chaste_interface_var_cell__sCsqnb;
        rDY[31] = d_dt_chaste_interface_var_cell__sCa_sr;
        rDY[32] = d_dt_chaste_interface_var_cell__sNaj;
        rDY[33] = d_dt_chaste_interface_var_cell__sNasl;
        rDY[34] = d_dt_chaste_interface_var_cell__sNai;
        rDY[35] = d_dt_chaste_interface_var_cell__sCaj;
        rDY[36] = d_dt_chaste_interface_var_cell__sCasl;
        rDY[37] = d_dt_chaste_interface_var_cell__sCai;
    }
    void Cellgrandi2010ssFromCellMLRushLarsen::ComputeOneStepExceptVoltage(const std::vector<double> &rDY, const std::vector<double> &rAlphaOrTau, const std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        
        rY[1] = rBetaOrInf[1] + (rY[1] - rBetaOrInf[1])*exp(-mDt/rAlphaOrTau[1]);
        rY[2] = rBetaOrInf[2] + (rY[2] - rBetaOrInf[2])*exp(-mDt/rAlphaOrTau[2]);
        rY[3] = rBetaOrInf[3] + (rY[3] - rBetaOrInf[3])*exp(-mDt/rAlphaOrTau[3]);
        rY[4] = rBetaOrInf[4] + (rY[4] - rBetaOrInf[4])*exp(-mDt/rAlphaOrTau[4]);
        rY[5] = rBetaOrInf[5] + (rY[5] - rBetaOrInf[5])*exp(-mDt/rAlphaOrTau[5]);
        rY[6] += mDt * rDY[6];
        rY[7] += mDt * rDY[7];
        rY[8] = rBetaOrInf[8] + (rY[8] - rBetaOrInf[8])*exp(-mDt/rAlphaOrTau[8]);
        rY[9] = rBetaOrInf[9] + (rY[9] - rBetaOrInf[9])*exp(-mDt/rAlphaOrTau[9]);
        rY[10] = rBetaOrInf[10] + (rY[10] - rBetaOrInf[10])*exp(-mDt/rAlphaOrTau[10]);
        rY[11] = rBetaOrInf[11] + (rY[11] - rBetaOrInf[11])*exp(-mDt/rAlphaOrTau[11]);
        rY[12] = rBetaOrInf[12] + (rY[12] - rBetaOrInf[12])*exp(-mDt/rAlphaOrTau[12]);
        rY[13] = rBetaOrInf[13] + (rY[13] - rBetaOrInf[13])*exp(-mDt/rAlphaOrTau[13]);
        rY[14] += mDt * rDY[14];
        rY[15] += mDt * rDY[15];
        rY[16] += mDt * rDY[16];
        rY[17] += mDt * rDY[17];
        rY[18] += mDt * rDY[18];
        rY[19] += mDt * rDY[19];
        rY[20] += mDt * rDY[20];
        rY[21] += mDt * rDY[21];
        rY[22] += mDt * rDY[22];
        rY[23] += mDt * rDY[23];
        rY[24] += mDt * rDY[24];
        rY[25] += mDt * rDY[25];
        rY[26] += mDt * rDY[26];
        rY[27] += mDt * rDY[27];
        rY[28] += mDt * rDY[28];
        rY[29] += mDt * rDY[29];
        rY[30] += mDt * rDY[30];
        rY[31] += mDt * rDY[31];
        rY[32] += mDt * rDY[32];
        rY[33] += mDt * rDY[33];
        rY[34] += mDt * rDY[34];
        rY[35] += mDt * rDY[35];
        rY[36] += mDt * rDY[36];
        rY[37] += mDt * rDY[37];
    }

    std::vector<double> Cellgrandi2010ssFromCellMLRushLarsen::ComputeDerivedQuantities(double var_chaste_interface__cell__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__cell__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__cell__time;
        dqs[1] = var_cell__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellgrandi2010ssFromCellMLRushLarsen>::Initialise(void)
{
    this->mSystemName = "grandi2010";
    this->mFreeVariableName = "cell__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-81.3842590704928);

    // rY[1]:
    this->mVariableNames.push_back("cell__sm");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00384941567866232);

    // rY[2]:
    this->mVariableNames.push_back("cell__sh");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.623723834301669);

    // rY[3]:
    this->mVariableNames.push_back("cell__sj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.622080736932815);

    // rY[4]:
    this->mVariableNames.push_back("cell__sd");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.95884913218079e-06);

    // rY[5]:
    this->mVariableNames.push_back("cell__sf");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.995094078386247);

    // rY[6]:
    this->mVariableNames.push_back("cell__sfcaBj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0246274349529557);

    // rY[7]:
    this->mVariableNames.push_back("cell__sfcaBsl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0150911724206476);

    // rY[8]:
    this->mVariableNames.push_back("cell__sxtos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000442853722673121);

    // rY[9]:
    this->mVariableNames.push_back("cell__sytos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.789013894749951);

    // rY[10]:
    this->mVariableNames.push_back("cell__sxtof");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000442846429332686);

    // rY[11]:
    this->mVariableNames.push_back("cell__sytof");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999995784674368);

    // rY[12]:
    this->mVariableNames.push_back("cell__sxkr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.020160578118589);

    // rY[13]:
    this->mVariableNames.push_back("cell__sxks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00430143235332308);

    // rY[14]:
    this->mVariableNames.push_back("cell__sRyRr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.893326456705696);

    // rY[15]:
    this->mVariableNames.push_back("cell__sRyRo");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.56436968249499e-07);

    // rY[16]:
    this->mVariableNames.push_back("cell__sRyRi");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.03266331737064e-08);

    // rY[17]:
    this->mVariableNames.push_back("cell__sNaBj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.41097946062695);

    // rY[18]:
    this->mVariableNames.push_back("cell__sNaBsl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.744248540671373);

    // rY[19]:
    this->mVariableNames.push_back("cell__sTnCL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00904644567707666);

    // rY[20]:
    this->mVariableNames.push_back("cell__sTnCHc");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1183943202639);

    // rY[21]:
    this->mVariableNames.push_back("cell__sTnCHm");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0101423649465603);

    // rY[22]:
    this->mVariableNames.push_back("cell__sCaM");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000299824763475116);

    // rY[23]:
    this->mVariableNames.push_back("cell__sMyoc");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00201443980536826);

    // rY[24]:
    this->mVariableNames.push_back("cell__sMyom");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.137467597337588);

    // rY[25]:
    this->mVariableNames.push_back("cell__sSRB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00220110816535249);

    // rY[26]:
    this->mVariableNames.push_back("cell__sSLLj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00739549938515031);

    // rY[27]:
    this->mVariableNames.push_back("cell__sSLLsl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00979616077807075);

    // rY[28]:
    this->mVariableNames.push_back("cell__sSLHj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0735225248399363);

    // rY[29]:
    this->mVariableNames.push_back("cell__sSLHsl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.113642236788144);

    // rY[30]:
    this->mVariableNames.push_back("cell__sCsqnb");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.20762712858574);

    // rY[31]:
    this->mVariableNames.push_back("cell__sCa_sr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.563755421404699);

    // rY[32]:
    this->mVariableNames.push_back("cell__sNaj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.21411036389602);

    // rY[33]:
    this->mVariableNames.push_back("cell__sNasl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.21322794157889);

    // rY[34]:
    this->mVariableNames.push_back("cell__sNai");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.21340895351653);

    // rY[35]:
    this->mVariableNames.push_back("cell__sCaj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000175648385857736);

    // rY[36]:
    this->mVariableNames.push_back("cell__sCasl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000105614570409386);

    // rY[37]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.85230799863012e-05);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("cell__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellgrandi2010ssFromCellMLRushLarsen)
