//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: bondarenko_model_2004_apex
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "bondarenko_model_2004_apex.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellbondarenko_model_2004_apexFromCellMLRushLarsen::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -80.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 0.5; // millisecond
        const double var_chaste_interface__membrane__stim_period = 71.430000000000007; // millisecond
        const double var_chaste_interface__membrane__stim_start = 20.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellbondarenko_model_2004_apexFromCellMLRushLarsen::Cellbondarenko_model_2004_apexFromCellMLRushLarsen(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractRushLarsenCardiacCell(
                41,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellbondarenko_model_2004_apexFromCellMLRushLarsen>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
    }

    Cellbondarenko_model_2004_apexFromCellMLRushLarsen::~Cellbondarenko_model_2004_apexFromCellMLRushLarsen()
    {
    }
    
    double Cellbondarenko_model_2004_apexFromCellMLRushLarsen::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__potassium_concentration__Ki = rY[27];
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_transient_outward_potassium_current__ato_s = rY[30];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__slow_transient_outward_potassium_current__ito_s = rY[31];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        
        const double var_L_type_calcium_current__E_CaL = 63.0; // millivolt
        const double var_L_type_calcium_current__g_CaL = 0.1729; // milliS_per_microF
        const double var_calcium_activated_chloride_current__E_Cl = -40.0; // millivolt
        const double var_calcium_activated_chloride_current__Km_Cl = 10.0; // micromolar
        const double var_calcium_activated_chloride_current__g_ClCa = 10.0; // milliS_per_microF
        const double var_calcium_background_current__g_Cab = 0.00036699999999999998; // milliS_per_microF
        const double var_calcium_pump_current__Km_pCa = 0.5; // micromolar
        const double var_calcium_pump_current__i_pCa_max = 1.0; // picoA_per_picoF
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) * var_calcium_pump_current__i_pCa_max / (pow(var_chaste_interface__calcium_concentration__Cai, 2) + pow(var_calcium_pump_current__Km_pCa, 2)); // picoA_per_picoF
        const double var_fast_sodium_current__g_Na = 13.0; // milliS_per_microF
        const double var_fast_transient_outward_potassium_current__g_Kto_f = 0.40670000000000001; // milliS_per_microF
        const double var_membrane__Cao = 1800.0; // micromolar
        const double var_membrane__F = 96.5; // coulomb_per_millimole
        const double var_membrane__Ko = 5400.0; // micromolar
        const double var_membrane__Nao = 140000.0; // micromolar
        const double var_membrane__R = 8.3140000000000001; // joule_per_mole_kelvin
        const double var_membrane__T = 298.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_membrane__Cao / var_chaste_interface__calcium_concentration__Cai) / var_membrane__F; // millivolt
        const double var_L_type_calcium_current__i_CaL = (-var_L_type_calcium_current__E_CaL + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__g_CaL; // picoA_per_picoF
        const double var_calcium_activated_chloride_current__O_ClCa = 0.20000000000000001 / (1.0 + exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_calcium_activated_chloride_current__i_ClCa = (-var_calcium_activated_chloride_current__E_Cl + var_chaste_interface__membrane__V) * var_calcium_activated_chloride_current__O_ClCa * var_calcium_activated_chloride_current__g_ClCa * var_chaste_interface__calcium_concentration__Cai / (var_calcium_activated_chloride_current__Km_Cl + var_chaste_interface__calcium_concentration__Cai); // picoA_per_picoF
        const double var_calcium_background_current__i_Cab = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__g_Kss = 0.050000000000000003; // milliS_per_microF
        const double var_fast_transient_outward_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_membrane__Ko / var_chaste_interface__potassium_concentration__Ki) / var_membrane__F; // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_fast_transient_outward_potassium_current__g_Kto_f * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_non_inactivating_steady_state_potassium_current__g_Kss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr = 0.078; // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.0057499999999999999; // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks; // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__g_Kto_s = 0; // milliS_per_microF
        const double var_slow_transient_outward_potassium_current__i_Kto_s = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__slow_transient_outward_potassium_current__ato_s * var_slow_transient_outward_potassium_current__g_Kto_s * var_chaste_interface__slow_transient_outward_potassium_current__ito_s; // picoA_per_picoF
        const double var_sodium_background_current__g_Nab = 0.0025999999999999999; // milliS_per_microF
        const double var_sodium_calcium_exchange_current__K_mCa = 1380.0; // micromolar
        const double var_sodium_calcium_exchange_current__K_mNa = 87500.0; // micromolar
        const double var_sodium_calcium_exchange_current__eta = 0.34999999999999998; // dimensionless
        const double var_sodium_calcium_exchange_current__k_NaCa = 292.80000000000001; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__k_sat = 0.10000000000000001; // dimensionless
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log((var_membrane__Nao + 0.1111111111111111 * var_membrane__Ko) / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__g_Na; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_membrane__R * var_membrane__T * log((var_membrane__Ko + 0.020408163265306124 * var_membrane__Nao) / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) / var_membrane__F + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__g_Kr; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = (pow(var_chaste_interface__sodium_concentration__Nai, 3) * var_membrane__Cao * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__eta / (var_membrane__R * var_membrane__T)) - pow(var_membrane__Nao, 3) * var_chaste_interface__calcium_concentration__Cai * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchange_current__k_NaCa / ((1.0 + var_sodium_calcium_exchange_current__k_sat * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_membrane__Nao, 3) + pow(var_sodium_calcium_exchange_current__K_mNa, 3)) * (var_membrane__Cao + var_sodium_calcium_exchange_current__K_mCa)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__Km_Ko = 1500.0; // micromolar
        const double var_sodium_potassium_pump_current__Km_Nai = 21000.0; // micromolar
        const double var_sodium_potassium_pump_current__i_NaK_max = 0.88; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(1.4858841010401188e-5 * var_membrane__Nao); // dimensionless
        const double var_sodium_potassium_pump_current__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump_current__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump_current__i_NaK = var_membrane__Ko * var_sodium_potassium_pump_current__f_NaK * var_sodium_potassium_pump_current__i_NaK_max / ((1.0 + pow((var_sodium_potassium_pump_current__Km_Nai / var_chaste_interface__sodium_concentration__Nai), 1.5)) * (var_membrane__Ko + var_sodium_potassium_pump_current__Km_Ko)); // picoA_per_picoF
        const double var_time_independent_potassium_current__i_K1 = 0.29380000000000001 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_membrane__Ko / ((1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)) * (210.0 + var_membrane__Ko)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur = 0.16; // milliS_per_microF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        const double var_chaste_interface__i_ionic = (var_L_type_calcium_current__i_CaL + var_calcium_activated_chloride_current__i_ClCa + var_calcium_background_current__i_Cab + var_calcium_pump_current__i_pCa + var_fast_sodium_current__i_Na + var_fast_transient_outward_potassium_current__i_Kto_f + var_non_inactivating_steady_state_potassium_current__i_Kss + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_slow_delayed_rectifier_potassium_current__i_Ks + var_slow_transient_outward_potassium_current__i_Kto_s + var_sodium_background_current__i_Nab + var_sodium_calcium_exchange_current__i_NaCa + var_sodium_potassium_pump_current__i_NaK + var_time_independent_potassium_current__i_K1 + var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellbondarenko_model_2004_apexFromCellMLRushLarsen::EvaluateEquations(double var_chaste_interface__environment__time, std::vector<double> &rDY, std::vector<double> &rAlphaOrTau, std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__CaJSR = rY[3];
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_concentration__CaNSR = rY[4];
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_fluxes__P_RyR = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__calcium_buffering__LTRPN_Ca = rY[6];
        // Units: micromolar; Initial value: 11.2684
        double var_chaste_interface__calcium_buffering__HTRPN_Ca = rY[7];
        // Units: micromolar; Initial value: 125.29
        double var_chaste_interface__ryanodine_receptors__P_O1 = rY[8];
        // Units: dimensionless; Initial value: 1.49102e-05
        double var_chaste_interface__ryanodine_receptors__P_O2 = rY[9];
        // Units: dimensionless; Initial value: 9.51726e-11
        double var_chaste_interface__ryanodine_receptors__P_C2 = rY[10];
        // Units: dimensionless; Initial value: 0.00016774
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__L_type_calcium_current__C2 = rY[12];
        // Units: dimensionless; Initial value: 0.000124216
        double var_chaste_interface__L_type_calcium_current__C3 = rY[13];
        // Units: dimensionless; Initial value: 5.78679e-09
        double var_chaste_interface__L_type_calcium_current__C4 = rY[14];
        // Units: dimensionless; Initial value: 1.19816e-13
        double var_chaste_interface__L_type_calcium_current__I1 = rY[15];
        // Units: dimensionless; Initial value: 4.97923e-19
        double var_chaste_interface__L_type_calcium_current__I2 = rY[16];
        // Units: dimensionless; Initial value: 3.45847e-14
        double var_chaste_interface__L_type_calcium_current__I3 = rY[17];
        // Units: dimensionless; Initial value: 1.85106e-14
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__fast_sodium_current__C_Na1 = rY[20];
        // Units: dimensionless; Initial value: 0.000279132
        double var_chaste_interface__fast_sodium_current__C_Na2 = rY[21];
        // Units: dimensionless; Initial value: 0.020752
        double var_chaste_interface__fast_sodium_current__I1_Na = rY[22];
        // Units: dimensionless; Initial value: 6.73345e-07
        double var_chaste_interface__fast_sodium_current__I2_Na = rY[23];
        // Units: dimensionless; Initial value: 1.55787e-09
        double var_chaste_interface__fast_sodium_current__IF_Na = rY[24];
        // Units: dimensionless; Initial value: 0.000153176
        double var_chaste_interface__fast_sodium_current__IC_Na2 = rY[25];
        // Units: dimensionless; Initial value: 0.0113879
        double var_chaste_interface__fast_sodium_current__IC_Na3 = rY[26];
        // Units: dimensionless; Initial value: 0.34278
        double var_chaste_interface__potassium_concentration__Ki = rY[27];
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_transient_outward_potassium_current__ato_s = rY[30];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__slow_transient_outward_potassium_current__ito_s = rY[31];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 = rY[38];
        // Units: dimensionless; Initial value: 0.000992513
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 = rY[39];
        // Units: dimensionless; Initial value: 0.000641229
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K = rY[40];
        // Units: dimensionless; Initial value: 3.19129e-05

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__iKss = 0; // 1 / millisecond
        const double var_L_type_calcium_current__E_CaL = 63.0; // millivolt
        const double var_L_type_calcium_current__Kpc_half = 20.0; // micromolar
        const double var_L_type_calcium_current__Kpc_max = 0.23324; // per_millisecond
        const double var_L_type_calcium_current__Kpcb = 0.00050000000000000001; // per_millisecond
        const double var_L_type_calcium_current__C1 = 1.0 - var_chaste_interface__L_type_calcium_current__C3 - var_chaste_interface__L_type_calcium_current__C4 - var_chaste_interface__L_type_calcium_current__I1 - var_chaste_interface__L_type_calcium_current__I2 - var_chaste_interface__L_type_calcium_current__I3 - var_chaste_interface__L_type_calcium_current__O - 2 * var_chaste_interface__L_type_calcium_current__C2; // dimensionless
        const double var_L_type_calcium_current__g_CaL = 0.1729; // milliS_per_microF
        const double var_L_type_calcium_current__i_CaL_max = 7.0; // picoA_per_picoF
        const double var_calcium_background_current__g_Cab = 0.00036699999999999998; // milliS_per_microF
        const double var_calcium_buffering__HTRPN_tot = 140.0; // micromolar
        const double var_calcium_buffering__LTRPN_tot = 70.0; // micromolar
        const double var_calcium_concentration__CMDN_tot = 50.0; // micromolar
        const double var_calcium_concentration__CSQN_tot = 15000.0; // micromolar
        const double var_L_type_calcium_current__gamma = var_L_type_calcium_current__Kpc_max * var_chaste_interface__calcium_concentration__Cass / (var_L_type_calcium_current__Kpc_half + var_chaste_interface__calcium_concentration__Cass); // per_millisecond
        const double var_calcium_concentration__Km_CMDN = 0.23799999999999999; // micromolar
        const double var_calcium_concentration__Bi = 1 / (1.0 + var_calcium_concentration__CMDN_tot * var_calcium_concentration__Km_CMDN / pow((var_chaste_interface__calcium_concentration__Cai + var_calcium_concentration__Km_CMDN), 2)); // dimensionless
        const double var_calcium_concentration__Bss = 1 / (1.0 + var_calcium_concentration__CMDN_tot * var_calcium_concentration__Km_CMDN / pow((var_chaste_interface__calcium_concentration__Cass + var_calcium_concentration__Km_CMDN), 2)); // dimensionless
        const double var_calcium_concentration__Km_CSQN = 800.0; // micromolar
        const double var_calcium_concentration__BJSR = 1 / (1.0 + var_calcium_concentration__CSQN_tot * var_calcium_concentration__Km_CSQN / pow((var_chaste_interface__calcium_concentration__CaJSR + var_calcium_concentration__Km_CSQN), 2)); // dimensionless
        const double var_calcium_fluxes__Km_up = 0.5; // micromolar
        const double var_calcium_fluxes__k_minus_htrpn = 3.1999999999999999e-5; // per_millisecond
        const double var_calcium_fluxes__k_minus_ltrpn = 0.019599999999999999; // per_millisecond
        const double var_calcium_fluxes__k_plus_htrpn = 0.0023700000000000001; // per_micromolar_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__HTRPN_Ca = -var_chaste_interface__calcium_buffering__HTRPN_Ca * var_calcium_fluxes__k_minus_htrpn + (-var_chaste_interface__calcium_buffering__HTRPN_Ca + var_calcium_buffering__HTRPN_tot) * var_chaste_interface__calcium_concentration__Cai * var_calcium_fluxes__k_plus_htrpn; // micromolar / millisecond
        const double var_calcium_fluxes__k_plus_ltrpn = 0.0327; // per_micromolar_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__LTRPN_Ca = -var_chaste_interface__calcium_buffering__LTRPN_Ca * var_calcium_fluxes__k_minus_ltrpn + (-var_chaste_interface__calcium_buffering__LTRPN_Ca + var_calcium_buffering__LTRPN_tot) * var_chaste_interface__calcium_concentration__Cai * var_calcium_fluxes__k_plus_ltrpn; // micromolar / millisecond
        const double var_calcium_fluxes__J_trpn = -var_chaste_interface__calcium_buffering__HTRPN_Ca * var_calcium_fluxes__k_minus_htrpn - var_chaste_interface__calcium_buffering__LTRPN_Ca * var_calcium_fluxes__k_minus_ltrpn + (-var_chaste_interface__calcium_buffering__HTRPN_Ca + var_calcium_buffering__HTRPN_tot) * var_chaste_interface__calcium_concentration__Cai * var_calcium_fluxes__k_plus_htrpn + (-var_chaste_interface__calcium_buffering__LTRPN_Ca + var_calcium_buffering__LTRPN_tot) * var_chaste_interface__calcium_concentration__Cai * var_calcium_fluxes__k_plus_ltrpn; // micromolar_per_millisecond
        const double var_calcium_fluxes__tau_tr = 20.0; // millisecond
        const double var_calcium_fluxes__J_tr = (-var_chaste_interface__calcium_concentration__CaJSR + var_chaste_interface__calcium_concentration__CaNSR) / var_calcium_fluxes__tau_tr; // micromolar_per_millisecond
        const double var_calcium_fluxes__tau_xfer = 8.0; // millisecond
        const double var_calcium_fluxes__J_xfer = (-var_chaste_interface__calcium_concentration__Cai + var_chaste_interface__calcium_concentration__Cass) / var_calcium_fluxes__tau_xfer; // micromolar_per_millisecond
        const double var_calcium_fluxes__v1 = 4.5; // per_millisecond
        const double var_calcium_fluxes__v2 = 1.7399999999999999e-5; // per_millisecond
        const double var_calcium_fluxes__J_leak = (-var_chaste_interface__calcium_concentration__Cai + var_chaste_interface__calcium_concentration__CaNSR) * var_calcium_fluxes__v2; // micromolar_per_millisecond
        const double var_calcium_fluxes__v3 = 0.45000000000000001; // micromolar_per_millisecond
        const double var_calcium_fluxes__J_up = pow(var_chaste_interface__calcium_concentration__Cai, 2) * var_calcium_fluxes__v3 / (pow(var_chaste_interface__calcium_concentration__Cai, 2) + pow(var_calcium_fluxes__Km_up, 2)); // micromolar_per_millisecond
        const double var_calcium_pump_current__Km_pCa = 0.5; // micromolar
        const double var_calcium_pump_current__i_pCa_max = 1.0; // picoA_per_picoF
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) * var_calcium_pump_current__i_pCa_max / (pow(var_chaste_interface__calcium_concentration__Cai, 2) + pow(var_calcium_pump_current__Km_pCa, 2)); // picoA_per_picoF
        const double var_fast_sodium_current__C_Na3 = 1.0 - var_chaste_interface__fast_sodium_current__C_Na1 - var_chaste_interface__fast_sodium_current__C_Na2 - var_chaste_interface__fast_sodium_current__I1_Na - var_chaste_interface__fast_sodium_current__I2_Na - var_chaste_interface__fast_sodium_current__IC_Na2 - var_chaste_interface__fast_sodium_current__IC_Na3 - var_chaste_interface__fast_sodium_current__IF_Na - var_chaste_interface__fast_sodium_current__O_Na; // dimensionless
        const double var_fast_sodium_current__g_Na = 13.0; // milliS_per_microF
        const double var_fast_transient_outward_potassium_current__g_Kto_f = 0.40670000000000001; // milliS_per_microF
        const double var_membrane__Acap = 0.00015339999999999999; // cm2
        const double var_membrane__Cao = 1800.0; // micromolar
        const double var_membrane__Cm = 1.0; // microF_per_cm2
        const double var_membrane__F = 96.5; // coulomb_per_millimole
        const double var_membrane__Ko = 5400.0; // micromolar
        const double var_membrane__Nao = 140000.0; // micromolar
        const double var_membrane__R = 8.3140000000000001; // joule_per_mole_kelvin
        const double var_membrane__T = 298.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_membrane__Cao / var_chaste_interface__calcium_concentration__Cai) / var_membrane__F; // millivolt
        const double var_L_type_calcium_current__Kpcf = 13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2)); // per_millisecond
        const double var_L_type_calcium_current__alpha = 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_current__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C2 = -var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__beta + 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__beta + 4.0 * var_L_type_calcium_current__C1 * var_L_type_calcium_current__alpha - 3.0 * var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__alpha; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C3 = 3.0 * var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__alpha + 3.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__beta - 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__alpha - 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C4 = -var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha + 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__alpha + 4.0 * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__beta + 0.0080000000000000002 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__beta - 3.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__beta - 0.002 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf + 4.0 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__Kpcb * var_L_type_calcium_current__beta + 0.040000000000000001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcb * var_L_type_calcium_current__beta - 1.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__gamma - 0.01 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha * var_L_type_calcium_current__gamma; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I1 = var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__gamma - var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcb + 0.001 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__alpha - 0.001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf + 0.01 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha * var_L_type_calcium_current__gamma - 0.040000000000000001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I2 = var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__Kpcb - var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__gamma + 0.001 * var_L_type_calcium_current__Kpcf * var_chaste_interface__L_type_calcium_current__O + 0.002 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf - 0.001 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__alpha - 0.0080000000000000002 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I3 = var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__gamma - var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__Kpcb + 0.001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf - 0.001 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__alpha + var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__gamma - 4.0 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__Kpcb * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__O = var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha + var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcb - var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__gamma + 0.001 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__alpha - 4.0 * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__beta - 0.001 * var_L_type_calcium_current__Kpcf * var_chaste_interface__L_type_calcium_current__O; // 1 / millisecond
        const double var_L_type_calcium_current__i_CaL = (-var_L_type_calcium_current__E_CaL + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__g_CaL; // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_fluxes__P_RyR = -0.040000000000000001 * var_chaste_interface__calcium_fluxes__P_RyR - 0.10000000000000001 * var_L_type_calcium_current__i_CaL * exp(-0.038580246913580245 * pow((-1 + 0.20000000000000001 * var_chaste_interface__membrane__V), 2)) / var_L_type_calcium_current__i_CaL_max; // 1 / millisecond
        const double var_calcium_background_current__i_Cab = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // picoA_per_picoF
        const double var_fast_sodium_current__alpha_Na11 = 3.802 / (0.20000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na12 = 3.802 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na13 = 3.802 / (0.25 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na2 = 1 / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na3 = 6.9999999999999997e-7 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__alpha_Na4 = 0.001 * var_fast_sodium_current__alpha_Na2; // per_millisecond
        const double var_fast_sodium_current__alpha_Na5 = 1.0526315789473684e-5 * var_fast_sodium_current__alpha_Na2; // per_millisecond
        const double var_fast_sodium_current__beta_Na11 = 0.19170000000000001 * exp(-0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na12 = 0.20000000000000001 * exp(0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na13 = 0.22 * exp(0.36945812807881773 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na3 = 0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__C_Na1 = var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__alpha_Na12 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na3 + var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__beta_Na13 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__alpha_Na13 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na3; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__C_Na2 = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na12 + var_fast_sodium_current__C_Na3 * var_fast_sodium_current__alpha_Na11 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__alpha_Na12 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na11 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na3; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IC_Na2 = var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na11 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na12 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__beta_Na11; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IC_Na3 = var_fast_sodium_current__C_Na3 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__beta_Na11 - var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na11 - var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na3; // 1 / millisecond
        const double var_fast_sodium_current__beta_Na2 = var_fast_sodium_current__alpha_Na13 * var_fast_sodium_current__alpha_Na2 * var_fast_sodium_current__alpha_Na3 / (var_fast_sodium_current__beta_Na13 * var_fast_sodium_current__beta_Na3); // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__O_Na = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__alpha_Na13 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na2 - var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__alpha_Na2 - var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__beta_Na13; // 1 / millisecond
        const double var_fast_sodium_current__beta_Na4 = var_fast_sodium_current__alpha_Na3; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IF_Na = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__beta_Na4 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na12 + var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__alpha_Na2 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na4 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na2; // 1 / millisecond
        const double var_fast_sodium_current__beta_Na5 = 0.02 * var_fast_sodium_current__alpha_Na3; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__I1_Na = var_chaste_interface__fast_sodium_current__I2_Na * var_fast_sodium_current__beta_Na5 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na4 - var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__alpha_Na5 - var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__beta_Na4; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__I2_Na = var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__alpha_Na5 - var_chaste_interface__fast_sodium_current__I2_Na * var_fast_sodium_current__beta_Na5; // 1 / millisecond
        const double var_fast_transient_outward_potassium_current__alpha_a = 0.18064 * exp(1.0731000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_transient_outward_potassium_current__alpha_i = 0.00015200000000000001 * exp(-1.9285714285714286 - 0.14285714285714285 * var_chaste_interface__membrane__V) / (1.0 + 0.0067083000000000004 * exp(-4.7857142857142856 - 0.14285714285714285 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_transient_outward_potassium_current__beta_a = 0.39560000000000001 * exp(-1.8711 - 0.062370000000000002 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_transient_outward_potassium_current__beta_i = 0.00095 * exp(4.7857142857142856 + 0.14285714285714285 * var_chaste_interface__membrane__V) / (1.0 + 0.051334999999999999 * exp(4.7857142857142856 + 0.14285714285714285 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_membrane__VJSR = 1.1999999999999999e-7; // microlitre
        const double var_membrane__VNSR = 2.0980000000000001e-6; // microlitre
        const double var_membrane__Vmyo = 2.584e-5; // microlitre
        const double d_dt_chaste_interface_var_calcium_concentration__CaNSR = (-var_calcium_fluxes__J_leak + var_calcium_fluxes__J_up) * var_membrane__Vmyo / var_membrane__VNSR - var_calcium_fluxes__J_tr * var_membrane__VJSR / var_membrane__VNSR; // micromolar / millisecond
        const double var_membrane__Vss = 1.4849999999999999e-9; // microlitre
        const double var_non_inactivating_steady_state_potassium_current__g_Kss = 0.050000000000000003; // milliS_per_microF
        const double var_non_inactivating_steady_state_potassium_current__tau_Kss = 13.17 + 39.299999999999997 * exp(-0.086199999999999999 * var_chaste_interface__membrane__V); // millisecond
        const double var_fast_transient_outward_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_membrane__Ko / var_chaste_interface__potassium_concentration__Ki) / var_membrane__F; // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_fast_transient_outward_potassium_current__g_Kto_f * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_non_inactivating_steady_state_potassium_current__g_Kss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__C_K0 = 1.0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K; // dimensionless
        const double var_rapid_delayed_rectifier_potassium_current__alpha_a0 = 0.022348 * exp(0.01176 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__alpha_a1 = 0.013733 * exp(0.038198000000000003 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__alpha_i = 0.090820999999999999 * exp(0.11695499999999999 + 0.023390999999999999 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_a0 = 0.047002000000000002 * exp(-0.063100000000000003 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_a1 = 6.8899999999999994e-5 * exp(-0.041779999999999998 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_i = 0.0064970000000000002 * exp(-0.16339999999999999 - 0.032680000000000001 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__I_K = var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__alpha_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K * var_rapid_delayed_rectifier_potassium_current__beta_i; // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__O_K = var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__alpha_a1 + var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K * var_rapid_delayed_rectifier_potassium_current__beta_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__alpha_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__beta_a1; // 1 / millisecond
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr = 0.078; // milliS_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__kb = 0.036777999999999998; // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__kf = 0.023761000000000001; // per_millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K1 = var_rapid_delayed_rectifier_potassium_current__C_K0 * var_rapid_delayed_rectifier_potassium_current__alpha_a0 + var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__kb - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 * var_rapid_delayed_rectifier_potassium_current__beta_a0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 * var_rapid_delayed_rectifier_potassium_current__kf; // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K2 = var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 * var_rapid_delayed_rectifier_potassium_current__kf + var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__beta_a1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__alpha_a1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__kb; // 1 / millisecond
        const double var_calcium_fluxes__J_rel = (-var_chaste_interface__calcium_concentration__Cass + var_chaste_interface__calcium_concentration__CaJSR) * (var_chaste_interface__ryanodine_receptors__P_O1 + var_chaste_interface__ryanodine_receptors__P_O2) * var_chaste_interface__calcium_fluxes__P_RyR * var_calcium_fluxes__v1; // micromolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__CaJSR = (-var_calcium_fluxes__J_rel + var_calcium_fluxes__J_tr) * var_calcium_concentration__BJSR; // micromolar / millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__Cass = (var_calcium_fluxes__J_rel * var_membrane__VJSR / var_membrane__Vss - var_calcium_fluxes__J_xfer * var_membrane__Vmyo / var_membrane__Vss - 0.5 * var_L_type_calcium_current__i_CaL * var_membrane__Acap * var_membrane__Cm / (var_membrane__F * var_membrane__Vss)) * var_calcium_concentration__Bss; // micromolar / millisecond
        const double var_ryanodine_receptors__P_C1 = 1.0 - var_chaste_interface__ryanodine_receptors__P_C2 - var_chaste_interface__ryanodine_receptors__P_O1 - var_chaste_interface__ryanodine_receptors__P_O2; // dimensionless
        const double var_ryanodine_receptors__k_minus_a = 0.071249999999999994; // per_millisecond
        const double var_ryanodine_receptors__k_minus_b = 0.96499999999999997; // per_millisecond
        const double var_ryanodine_receptors__k_minus_c = 0.00080000000000000004; // per_millisecond
        const double var_ryanodine_receptors__k_plus_a = 0.0060749999999999997; // micromolar4_per_millisecond
        const double var_ryanodine_receptors__k_plus_b = 0.0040499999999999998; // micromolar3_per_millisecond
        const double var_ryanodine_receptors__k_plus_c = 0.0089999999999999993; // per_millisecond
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_C2 = var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_plus_c - var_chaste_interface__ryanodine_receptors__P_C2 * var_ryanodine_receptors__k_minus_c; // 1 / millisecond
        const double var_ryanodine_receptors__m = 3.0; // dimensionless
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_O2 = -var_chaste_interface__ryanodine_receptors__P_O2 * var_ryanodine_receptors__k_minus_b + pow(var_chaste_interface__calcium_concentration__Cass, var_ryanodine_receptors__m) * var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_plus_b; // 1 / millisecond
        const double var_ryanodine_receptors__n = 4.0; // dimensionless
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_O1 = var_chaste_interface__ryanodine_receptors__P_C2 * var_ryanodine_receptors__k_minus_c + var_chaste_interface__ryanodine_receptors__P_O2 * var_ryanodine_receptors__k_minus_b - var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_minus_a - var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_plus_c + pow(var_chaste_interface__calcium_concentration__Cass, var_ryanodine_receptors__n) * var_ryanodine_receptors__P_C1 * var_ryanodine_receptors__k_plus_a - pow(var_chaste_interface__calcium_concentration__Cass, var_ryanodine_receptors__m) * var_chaste_interface__ryanodine_receptors__P_O1 * var_ryanodine_receptors__k_plus_b; // 1 / millisecond
        const double var_slow_delayed_rectifier_potassium_current__alpha_n = 4.8133299999999997e-6 * (26.5 + var_chaste_interface__membrane__V) / (1.0 - exp(-3.3919999999999999 - 0.128 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_slow_delayed_rectifier_potassium_current__beta_n = 9.5333299999999997e-5 * exp(-1.0069999999999999 - 0.037999999999999999 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.0057499999999999999; // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks; // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__ass = 1 / (1.0 + exp(-2.9220779220779218 - 0.12987012987012986 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_transient_outward_potassium_current__g_Kto_s = 0; // milliS_per_microF
        const double var_slow_transient_outward_potassium_current__iss = 1 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_transient_outward_potassium_current__i_Kto_s = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__slow_transient_outward_potassium_current__ato_s * var_slow_transient_outward_potassium_current__g_Kto_s * var_chaste_interface__slow_transient_outward_potassium_current__ito_s; // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__tau_ta_s = 2.0579999999999998 + 0.49299999999999999 * exp(-0.062899999999999998 * var_chaste_interface__membrane__V); // millisecond
        const double var_slow_transient_outward_potassium_current__tau_ti_s = 270.0 + 1050.0 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V)); // millisecond
        const double var_sodium_background_current__g_Nab = 0.0025999999999999999; // milliS_per_microF
        const double var_sodium_calcium_exchange_current__K_mCa = 1380.0; // micromolar
        const double var_sodium_calcium_exchange_current__K_mNa = 87500.0; // micromolar
        const double var_sodium_calcium_exchange_current__eta = 0.34999999999999998; // dimensionless
        const double var_sodium_calcium_exchange_current__k_NaCa = 292.80000000000001; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__k_sat = 0.10000000000000001; // dimensionless
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log((var_membrane__Nao + 0.1111111111111111 * var_membrane__Ko) / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__g_Na; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_membrane__R * var_membrane__T * log((var_membrane__Ko + 0.020408163265306124 * var_membrane__Nao) / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) / var_membrane__F + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__g_Kr; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = (pow(var_chaste_interface__sodium_concentration__Nai, 3) * var_membrane__Cao * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__eta / (var_membrane__R * var_membrane__T)) - pow(var_membrane__Nao, 3) * var_chaste_interface__calcium_concentration__Cai * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchange_current__k_NaCa / ((1.0 + var_sodium_calcium_exchange_current__k_sat * exp((-1.0 + var_sodium_calcium_exchange_current__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_membrane__Nao, 3) + pow(var_sodium_calcium_exchange_current__K_mNa, 3)) * (var_membrane__Cao + var_sodium_calcium_exchange_current__K_mCa)); // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_concentration__Cai = (-var_calcium_fluxes__J_trpn - var_calcium_fluxes__J_up - 0.5 * (-2.0 * var_sodium_calcium_exchange_current__i_NaCa + var_calcium_background_current__i_Cab + var_calcium_pump_current__i_pCa) * var_membrane__Acap * var_membrane__Cm / (var_membrane__F * var_membrane__Vmyo) + var_calcium_fluxes__J_leak + var_calcium_fluxes__J_xfer) * var_calcium_concentration__Bi; // micromolar / millisecond
        const double var_sodium_potassium_pump_current__Km_Ko = 1500.0; // micromolar
        const double var_sodium_potassium_pump_current__Km_Nai = 21000.0; // micromolar
        const double var_sodium_potassium_pump_current__i_NaK_max = 0.88; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(1.4858841010401188e-5 * var_membrane__Nao); // dimensionless
        const double var_sodium_potassium_pump_current__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump_current__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump_current__i_NaK = var_membrane__Ko * var_sodium_potassium_pump_current__f_NaK * var_sodium_potassium_pump_current__i_NaK_max / ((1.0 + pow((var_sodium_potassium_pump_current__Km_Nai / var_chaste_interface__sodium_concentration__Nai), 1.5)) * (var_membrane__Ko + var_sodium_potassium_pump_current__Km_Ko)); // picoA_per_picoF
        const double d_dt_chaste_interface_var_sodium_concentration__Nai = (-var_fast_sodium_current__i_Na - var_sodium_background_current__i_Nab - 3.0 * var_sodium_calcium_exchange_current__i_NaCa - 3.0 * var_sodium_potassium_pump_current__i_NaK) * var_membrane__Acap * var_membrane__Cm / (var_membrane__F * var_membrane__Vmyo); // micromolar / millisecond
        const double var_time_independent_potassium_current__i_K1 = 0.29380000000000001 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_membrane__Ko / ((1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)) * (210.0 + var_membrane__Ko)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur = 0.16; // milliS_per_microF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_ultra_rapidly_activating_delayed_rectifier_potassium_current__g_Kur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        const double d_dt_chaste_interface_var_potassium_concentration__Ki = (-var_fast_transient_outward_potassium_current__i_Kto_f - var_non_inactivating_steady_state_potassium_current__i_Kss - var_rapid_delayed_rectifier_potassium_current__i_Kr - var_slow_delayed_rectifier_potassium_current__i_Ks - var_slow_transient_outward_potassium_current__i_Kto_s - var_time_independent_potassium_current__i_K1 - var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur + 2.0 * var_sodium_potassium_pump_current__i_NaK) * var_membrane__Acap * var_membrane__Cm / (var_membrane__F * var_membrane__Vmyo); // micromolar / millisecond
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_aur = 2.0579999999999998 + 0.49299999999999999 * exp(-0.062899999999999998 * var_chaste_interface__membrane__V); // millisecond
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_iur = 1200.0 - 170.0 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V)); // millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_calcium_activated_chloride_current__E_Cl = -40.0; // millivolt
            const double var_calcium_activated_chloride_current__Km_Cl = 10.0; // micromolar
            const double var_calcium_activated_chloride_current__g_ClCa = 10.0; // milliS_per_microF
            const double var_calcium_activated_chloride_current__O_ClCa = 0.20000000000000001 / (1.0 + exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V)); // dimensionless
            const double var_calcium_activated_chloride_current__i_ClCa = (-var_calcium_activated_chloride_current__E_Cl + var_chaste_interface__membrane__V) * var_calcium_activated_chloride_current__O_ClCa * var_calcium_activated_chloride_current__g_ClCa * var_chaste_interface__calcium_concentration__Cai / (var_calcium_activated_chloride_current__Km_Cl + var_chaste_interface__calcium_concentration__Cai); // picoA_per_picoF
            const double var_membrane__i_stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
            const double var_membrane__i_stim = var_membrane__i_stim_converted / HeartConfig::Instance()->GetCapacitance(); // picoA_per_picoF
            d_dt_chaste_interface_var_membrane__V = -var_L_type_calcium_current__i_CaL - var_calcium_activated_chloride_current__i_ClCa - var_calcium_background_current__i_Cab - var_calcium_pump_current__i_pCa - var_fast_sodium_current__i_Na - var_fast_transient_outward_potassium_current__i_Kto_f - var_membrane__i_stim - var_non_inactivating_steady_state_potassium_current__i_Kss - var_rapid_delayed_rectifier_potassium_current__i_Kr - var_slow_delayed_rectifier_potassium_current__i_Ks - var_slow_transient_outward_potassium_current__i_Kto_s - var_sodium_background_current__i_Nab - var_sodium_calcium_exchange_current__i_NaCa - var_sodium_potassium_pump_current__i_NaK - var_time_independent_potassium_current__i_K1 - var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur; // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__V;
        rDY[1] = d_dt_chaste_interface_var_calcium_concentration__Cai;
        rDY[2] = d_dt_chaste_interface_var_calcium_concentration__Cass;
        rDY[3] = d_dt_chaste_interface_var_calcium_concentration__CaJSR;
        rDY[4] = d_dt_chaste_interface_var_calcium_concentration__CaNSR;
        rDY[5] = d_dt_chaste_interface_var_calcium_fluxes__P_RyR;
        rDY[6] = d_dt_chaste_interface_var_calcium_buffering__LTRPN_Ca;
        rDY[7] = d_dt_chaste_interface_var_calcium_buffering__HTRPN_Ca;
        rDY[8] = d_dt_chaste_interface_var_ryanodine_receptors__P_O1;
        rDY[9] = d_dt_chaste_interface_var_ryanodine_receptors__P_O2;
        rDY[10] = d_dt_chaste_interface_var_ryanodine_receptors__P_C2;
        rDY[11] = d_dt_chaste_interface_var_L_type_calcium_current__O;
        rDY[12] = d_dt_chaste_interface_var_L_type_calcium_current__C2;
        rDY[13] = d_dt_chaste_interface_var_L_type_calcium_current__C3;
        rDY[14] = d_dt_chaste_interface_var_L_type_calcium_current__C4;
        rDY[15] = d_dt_chaste_interface_var_L_type_calcium_current__I1;
        rDY[16] = d_dt_chaste_interface_var_L_type_calcium_current__I2;
        rDY[17] = d_dt_chaste_interface_var_L_type_calcium_current__I3;
        rDY[18] = d_dt_chaste_interface_var_sodium_concentration__Nai;
        rDY[19] = d_dt_chaste_interface_var_fast_sodium_current__O_Na;
        rDY[20] = d_dt_chaste_interface_var_fast_sodium_current__C_Na1;
        rDY[21] = d_dt_chaste_interface_var_fast_sodium_current__C_Na2;
        rDY[22] = d_dt_chaste_interface_var_fast_sodium_current__I1_Na;
        rDY[23] = d_dt_chaste_interface_var_fast_sodium_current__I2_Na;
        rDY[24] = d_dt_chaste_interface_var_fast_sodium_current__IF_Na;
        rDY[25] = d_dt_chaste_interface_var_fast_sodium_current__IC_Na2;
        rDY[26] = d_dt_chaste_interface_var_fast_sodium_current__IC_Na3;
        rDY[27] = d_dt_chaste_interface_var_potassium_concentration__Ki;
        rAlphaOrTau[28] = var_fast_transient_outward_potassium_current__alpha_a;
        rBetaOrInf[28] = var_fast_transient_outward_potassium_current__beta_a;
        rAlphaOrTau[29] = var_fast_transient_outward_potassium_current__alpha_i;
        rBetaOrInf[29] = var_fast_transient_outward_potassium_current__beta_i;
        rAlphaOrTau[30] = var_slow_transient_outward_potassium_current__tau_ta_s;
        rBetaOrInf[30] = var_slow_transient_outward_potassium_current__ass;
        rAlphaOrTau[31] = var_slow_transient_outward_potassium_current__tau_ti_s;
        rBetaOrInf[31] = var_slow_transient_outward_potassium_current__iss;
        rAlphaOrTau[32] = var_slow_delayed_rectifier_potassium_current__alpha_n;
        rBetaOrInf[32] = var_slow_delayed_rectifier_potassium_current__beta_n;
        rAlphaOrTau[33] = var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_aur;
        rBetaOrInf[33] = var_slow_transient_outward_potassium_current__ass;
        rAlphaOrTau[34] = var_ultra_rapidly_activating_delayed_rectifier_potassium_current__tau_iur;
        rBetaOrInf[34] = var_slow_transient_outward_potassium_current__iss;
        rAlphaOrTau[35] = var_non_inactivating_steady_state_potassium_current__tau_Kss;
        rBetaOrInf[35] = var_slow_transient_outward_potassium_current__ass;
        rDY[36] = d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__iKss;
        rDY[37] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__O_K;
        rDY[38] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K1;
        rDY[39] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K2;
        rDY[40] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__I_K;
    }
    void Cellbondarenko_model_2004_apexFromCellMLRushLarsen::ComputeOneStepExceptVoltage(const std::vector<double> &rDY, const std::vector<double> &rAlphaOrTau, const std::vector<double> &rBetaOrInf)
    {
        std::vector<double>& rY = rGetStateVariables();
        
        rY[1] += mDt * rDY[1];
        rY[2] += mDt * rDY[2];
        rY[3] += mDt * rDY[3];
        rY[4] += mDt * rDY[4];
        rY[5] += mDt * rDY[5];
        rY[6] += mDt * rDY[6];
        rY[7] += mDt * rDY[7];
        rY[8] += mDt * rDY[8];
        rY[9] += mDt * rDY[9];
        rY[10] += mDt * rDY[10];
        rY[11] += mDt * rDY[11];
        rY[12] += mDt * rDY[12];
        rY[13] += mDt * rDY[13];
        rY[14] += mDt * rDY[14];
        rY[15] += mDt * rDY[15];
        rY[16] += mDt * rDY[16];
        rY[17] += mDt * rDY[17];
        rY[18] += mDt * rDY[18];
        rY[19] += mDt * rDY[19];
        rY[20] += mDt * rDY[20];
        rY[21] += mDt * rDY[21];
        rY[22] += mDt * rDY[22];
        rY[23] += mDt * rDY[23];
        rY[24] += mDt * rDY[24];
        rY[25] += mDt * rDY[25];
        rY[26] += mDt * rDY[26];
        rY[27] += mDt * rDY[27];
        {
            const double tau_inv = rAlphaOrTau[28] + rBetaOrInf[28];
            const double y_inf = rAlphaOrTau[28] / tau_inv;
            rY[28] = y_inf + (rY[28] - y_inf)*exp(-mDt*tau_inv);
        }
        {
            const double tau_inv = rAlphaOrTau[29] + rBetaOrInf[29];
            const double y_inf = rAlphaOrTau[29] / tau_inv;
            rY[29] = y_inf + (rY[29] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[30] = rBetaOrInf[30] + (rY[30] - rBetaOrInf[30])*exp(-mDt/rAlphaOrTau[30]);
        rY[31] = rBetaOrInf[31] + (rY[31] - rBetaOrInf[31])*exp(-mDt/rAlphaOrTau[31]);
        {
            const double tau_inv = rAlphaOrTau[32] + rBetaOrInf[32];
            const double y_inf = rAlphaOrTau[32] / tau_inv;
            rY[32] = y_inf + (rY[32] - y_inf)*exp(-mDt*tau_inv);
        }
        rY[33] = rBetaOrInf[33] + (rY[33] - rBetaOrInf[33])*exp(-mDt/rAlphaOrTau[33]);
        rY[34] = rBetaOrInf[34] + (rY[34] - rBetaOrInf[34])*exp(-mDt/rAlphaOrTau[34]);
        rY[35] = rBetaOrInf[35] + (rY[35] - rBetaOrInf[35])*exp(-mDt/rAlphaOrTau[35]);
        rY[36] += mDt * rDY[36];
        rY[37] += mDt * rDY[37];
        rY[38] += mDt * rDY[38];
        rY[39] += mDt * rDY[39];
        rY[40] += mDt * rDY[40];
    }

    std::vector<double> Cellbondarenko_model_2004_apexFromCellMLRushLarsen::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_membrane__i_stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellbondarenko_model_2004_apexFromCellMLRushLarsen>::Initialise(void)
{
    this->mSystemName = "bondarenko_model_2004_apex";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-82.4202);

    // rY[1]:
    this->mVariableNames.push_back("calcium_concentration__Cai");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(0.115001);

    // rY[2]:
    this->mVariableNames.push_back("calcium_concentration__Cass");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(0.115001);

    // rY[3]:
    this->mVariableNames.push_back("calcium_concentration__CaJSR");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(1299.5);

    // rY[4]:
    this->mVariableNames.push_back("calcium_concentration__CaNSR");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(1299.5);

    // rY[5]:
    this->mVariableNames.push_back("calcium_fluxes__P_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[6]:
    this->mVariableNames.push_back("calcium_buffering__LTRPN_Ca");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(11.2684);

    // rY[7]:
    this->mVariableNames.push_back("calcium_buffering__HTRPN_Ca");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(125.29);

    // rY[8]:
    this->mVariableNames.push_back("ryanodine_receptors__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.49102e-05);

    // rY[9]:
    this->mVariableNames.push_back("ryanodine_receptors__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.51726e-11);

    // rY[10]:
    this->mVariableNames.push_back("ryanodine_receptors__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00016774);

    // rY[11]:
    this->mVariableNames.push_back("L_type_calcium_current__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.30308e-19);

    // rY[12]:
    this->mVariableNames.push_back("L_type_calcium_current__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000124216);

    // rY[13]:
    this->mVariableNames.push_back("L_type_calcium_current__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(5.78679e-09);

    // rY[14]:
    this->mVariableNames.push_back("L_type_calcium_current__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.19816e-13);

    // rY[15]:
    this->mVariableNames.push_back("L_type_calcium_current__I1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(4.97923e-19);

    // rY[16]:
    this->mVariableNames.push_back("L_type_calcium_current__I2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.45847e-14);

    // rY[17]:
    this->mVariableNames.push_back("L_type_calcium_current__I3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.85106e-14);

    // rY[18]:
    this->mVariableNames.push_back("sodium_concentration__Nai");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(14237.1);

    // rY[19]:
    this->mVariableNames.push_back("fast_sodium_current__O_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.13483e-07);

    // rY[20]:
    this->mVariableNames.push_back("fast_sodium_current__C_Na1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000279132);

    // rY[21]:
    this->mVariableNames.push_back("fast_sodium_current__C_Na2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.020752);

    // rY[22]:
    this->mVariableNames.push_back("fast_sodium_current__I1_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.73345e-07);

    // rY[23]:
    this->mVariableNames.push_back("fast_sodium_current__I2_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.55787e-09);

    // rY[24]:
    this->mVariableNames.push_back("fast_sodium_current__IF_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000153176);

    // rY[25]:
    this->mVariableNames.push_back("fast_sodium_current__IC_Na2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0113879);

    // rY[26]:
    this->mVariableNames.push_back("fast_sodium_current__IC_Na3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.34278);

    // rY[27]:
    this->mVariableNames.push_back("potassium_concentration__Ki");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(143720.0);

    // rY[28]:
    this->mVariableNames.push_back("fast_transient_outward_potassium_current__ato_f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00265563);

    // rY[29]:
    this->mVariableNames.push_back("fast_transient_outward_potassium_current__ito_f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999977);

    // rY[30]:
    this->mVariableNames.push_back("slow_transient_outward_potassium_current__ato_s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // rY[31]:
    this->mVariableNames.push_back("slow_transient_outward_potassium_current__ito_s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.998543);

    // rY[32]:
    this->mVariableNames.push_back("slow_delayed_rectifier_potassium_current__nKs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000262753);

    // rY[33]:
    this->mVariableNames.push_back("ultra_rapidly_activating_delayed_rectifier_potassium_current__aur");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // rY[34]:
    this->mVariableNames.push_back("ultra_rapidly_activating_delayed_rectifier_potassium_current__iur");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.998543);

    // rY[35]:
    this->mVariableNames.push_back("non_inactivating_steady_state_potassium_current__aKss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // rY[36]:
    this->mVariableNames.push_back("non_inactivating_steady_state_potassium_current__iKss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // rY[37]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__O_K");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000175298);

    // rY[38]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__C_K1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000992513);

    // rY[39]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__C_K2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000641229);

    // rY[40]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__I_K");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.19129e-05);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.0002;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellbondarenko_model_2004_apexFromCellMLRushLarsen)
