//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: matsuoka_model_2003
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "matsuoka_model_2003.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellmatsuoka_model_2003FromCellMLOpt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -4000.0 * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 2.0; // millisecond
        const double var_chaste_interface__membrane__stim_period = 400.0; // millisecond
        const double var_chaste_interface__membrane__stim_start = 50.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellmatsuoka_model_2003FromCellMLOpt::Cellmatsuoka_model_2003FromCellMLOpt(boost::shared_ptr<AbstractIvpOdeSolver> pSolver, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCardiacCell(
                pSolver,
                37,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellmatsuoka_model_2003FromCellMLOpt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 132.0; // (var_membrane__Cm) [picoF]
    }

    Cellmatsuoka_model_2003FromCellMLOpt::~Cellmatsuoka_model_2003FromCellMLOpt()
    {
    }
    
    double Cellmatsuoka_model_2003FromCellMLOpt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-1.8) : (0.074870384603595908 * (-1.8 * exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm) + var_internal_ion_concentrations__Cai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : (0.037435192301797954 * (-5.4000000000000004 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Ki) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-140.0) : (0.037435192301797954 * (-140.0 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Nai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_time_independent_potassium_current__E_K = 26.712831923985377 * log(5.4000000000000004 / var_chaste_interface__internal_ion_concentrations__Ki); // millivolt
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_membrane__i_tot = 0.38500000000000001 * var_constant_field_equations__CF_Na + 0.040000000000000001 * var_constant_field_equations__CF_Ca + 0.15400000000000003 * var_constant_field_equations__CF_K + 21.0 * (-0.040000000000000001 * (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) / (1.0 + 14.894617648090152 * pow(1 / exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm), 1.0600000000000001)) + 0.37 * var_chaste_interface__sodium_potassium_pump_y_gate__y / ((1.0 + 0.094 / var_chaste_interface__ATP_production__ATPi) * (1.0 + 4.4045579125871104 * pow(1 / var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001) * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001))))) * mParameters[0] + 8712.0 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca + 6.8099999999999996 * (-0.6399652192815608 * (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm) + var_chaste_interface__sodium_calcium_exchanger_y_gate__y * exp(0.011979261536575346 * var_chaste_interface__membrane__Vm) / (1.0 + 669.921875 * (1.0 + 724.63768115942037 * var_internal_ion_concentrations__Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3))) * mParameters[0] + 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_K + 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na + 3.1798799999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K + 66.022388395163091 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)) + 0.16117199999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na + 612.0 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca + 2860.0 * var_constant_field_equations__CF_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + 0.2016 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na + 0.033000000000000002 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_chaste_interface__transient_outward_current_y2_gate__y2 + 5.04 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K + 0.00297 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_chaste_interface__transient_outward_current_y2_gate__y2 + 286.0 * var_constant_field_equations__CF_K * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + 1.1459999999999999 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (pow(var_time_independent_potassium_current__fO, 4) + 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2) + 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB) * mParameters[0] * var_chaste_interface__time_independent_potassium_current_y_gate__y + 0.0086400000000000001 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * mParameters[0] * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 + ((var_chaste_interface__membrane__Vm == (-3.0)) ? (0.0014308470000000001 * var_constant_field_equations__CF_K) : (0.00011 * (3.0 + var_chaste_interface__membrane__Vm) * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_chaste_interface__i_ionic = HeartConfig::Instance()->GetCapacitance() * var_membrane__i_tot / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellmatsuoka_model_2003FromCellMLOpt::EvaluateYDerivatives(double var_chaste_interface__environment__time, const std::vector<double>& rY, std::vector<double>& rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na = rY[6];
        // Units: dimensionless; Initial value: 0.3556412697995689
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na = rY[7];
        // Units: dimensionless; Initial value: 0.40285968661346977
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = rY[10];
        // Units: dimensionless; Initial value: 0.9968480629364956
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = rY[11];
        // Units: dimensionless; Initial value: 0.000877325391245903
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C = rY[14];
        // Units: dimensionless; Initial value: 0.4250747299372254
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        double var_chaste_interface__SR_calcium_pump_y_gate__y = rY[28];
        // Units: dimensionless; Initial value: 0.46108441538480216
        double var_chaste_interface__RyR_channel__p_open_RyR = rY[29];
        // Units: dimensionless; Initial value: 0.00034314360001543243
        double var_chaste_interface__RyR_channel__p_close_RyR = rY[30];
        // Units: dimensionless; Initial value: 0.19135178123107768
        double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rY[31];
        // Units: millimolar; Initial value: 9.455741736977666
        double var_chaste_interface__Ca_concentrations_in_SR__Caup = rY[32];
        // Units: millimolar; Initial value: 2.611712901567567
        double var_chaste_interface__NL_model__pCa = rY[33];
        // Units: dimensionless; Initial value: 0.02490898775497523
        double var_chaste_interface__NL_model__pCaCB = rY[34];
        // Units: dimensionless; Initial value: 0.001990153835322864
        double var_chaste_interface__NL_model__pCB = rY[35];
        // Units: dimensionless; Initial value: 0.00042941813853474524
        double var_chaste_interface__NL_model__X = rY[36];
        // Units: micrometre; Initial value: 0.9573749975411884

        // Mathematics
        double d_dt_chaste_interface_var_membrane__Vm;
        const double var_Ca_concentrations_in_SR__Carel = -5.4000000000000004 + 0.5 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + 5.4000000000000004 * sqrt(pow((1 - 0.092592592592592587 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total), 2) + 0.027434842249657067 * var_chaste_interface__Ca_concentrations_in_SR__Ca_Total); // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__p_CCa = 1.0 - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa; // dimensionless
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL = 1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // dimensionless
        const double d_dt_chaste_interface_var_NL_model__X = 1.1488559970494261 - 1.2 * var_chaste_interface__NL_model__X; // micrometre / millisecond
        const double var_NL_model__Q_a = -0.0038999999999999998 * var_chaste_interface__NL_model__pCaCB + 0.0038999999999999998 * var_chaste_interface__NL_model__pCa * exp(-0.86212130841993795); // per_millisecond
        const double var_NL_model__Q_d2 = 0.027 * pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_chaste_interface__NL_model__pCaCB; // per_millisecond
        const double var_SR_T_current__i_SR_T = 386.0 * var_chaste_interface__Ca_concentrations_in_SR__Caup - 386.0 * var_Ca_concentrations_in_SR__Carel; // picoA
        const double var_SR_calcium_pump__k2 = 1 / (1.0 + 0.10000000000000001 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_SR_calcium_pump__p_E1Ca = 1 / (1.0 + 0.080000000000000002 / var_chaste_interface__Ca_concentrations_in_SR__Caup); // dimensionless
        const double var_internal_ion_concentrations__Cai = -0.026190000000000001 + 0.5 * sqrt(pow((0.052380000000000003 - var_chaste_interface__internal_ion_concentrations__Ca_Total), 2) + 0.0095200000000000007 * var_chaste_interface__internal_ion_concentrations__Ca_Total) + 0.5 * var_chaste_interface__internal_ion_concentrations__Ca_Total; // millimolar
        const double var_NL_model__Q_b = -0.029999999999999999 * var_chaste_interface__NL_model__pCa + 39.0 * (1.0 - var_chaste_interface__NL_model__pCB - var_chaste_interface__NL_model__pCa - var_chaste_interface__NL_model__pCaCB) * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCa = -var_NL_model__Q_a + var_NL_model__Q_b; // 1 / millisecond
        const double var_NL_model__Q_r = 0.029999999999999999 * var_chaste_interface__NL_model__pCaCB - 1560.0 * var_chaste_interface__NL_model__pCB * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCB = -0.12 * var_chaste_interface__NL_model__pCB - 0.027 * pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_chaste_interface__NL_model__pCB + var_NL_model__Q_r; // 1 / millisecond
        const double d_dt_chaste_interface_var_NL_model__pCaCB = -var_NL_model__Q_d2 - var_NL_model__Q_r + var_NL_model__Q_a; // 1 / millisecond
        const double var_RyR_channel__i_RyR = 62000.0 * (-var_internal_ion_concentrations__Cai + var_Ca_concentrations_in_SR__Carel) * var_chaste_interface__RyR_channel__p_open_RyR; // picoA
        const double var_SR_L_current__i_SR_L = 459.0 * var_chaste_interface__Ca_concentrations_in_SR__Caup - 459.0 * var_internal_ion_concentrations__Cai; // picoA
        const double var_SR_calcium_pump__p_E2Ca = 1 / (1.0 + 0.00080000000000000004 / var_internal_ion_concentrations__Cai); // dimensionless
        const double var_SR_calcium_pump__i_SR_U = 1625.0 * var_SR_calcium_pump__p_E1Ca * var_chaste_interface__SR_calcium_pump_y_gate__y - 162500.0 * (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca; // picoA
        const double d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y = (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * (0.01 - 0.01 * var_SR_calcium_pump__p_E2Ca + var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca) - (1.0 - 0.98999999999999999 * var_SR_calcium_pump__p_E1Ca) * var_chaste_interface__SR_calcium_pump_y_gate__y; // 1 / millisecond
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total = 3.2387883511406234e-5 * var_SR_T_current__i_SR_T - 3.2387883511406234e-5 * var_RyR_channel__i_RyR; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup = -1.2955153404562494e-5 * var_SR_L_current__i_SR_L - 1.2955153404562494e-5 * var_SR_T_current__i_SR_T - 1.2955153404562494e-5 * var_SR_calcium_pump__i_SR_U; // millimolar / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_ultra_slow_gate__y = (1.0 - var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y) / (58.0 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm) + 250000.0 * exp(0.1111111111111111 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y / (66.0 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 1800.0 * exp(-0.071428571428571425 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI = 1 / (11.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 2200000.0 * exp(0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP = 1 / (480.0 * exp(0.14285714285714285 * var_chaste_interface__membrane__Vm) + 2.2000000000000002 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI = 1 / (2.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.0018 * exp(-0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = 0.0040000000000000001 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI * var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL - (0.001 + var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL; // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP = 1 / (1.5 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 0.27000000000000002 * exp(-0.16949152542372881 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = 0.001 * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL - (0.0040000000000000001 + var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI = 0.040000000000000001 / (1.0 + 0.25 * var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP * var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI / (var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI * var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = (0.040000000000000001 - var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI) * var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL - (var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP + var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // 1 / millisecond
        const double d_dt_chaste_interface_var_T_type_Ca_channel_y1_gate__y1 = (1.0 - var_chaste_interface__T_type_Ca_channel_y1_gate__y1) / (0.019 * exp(-0.17857142857142858 * var_chaste_interface__membrane__Vm) + 0.81999999999999995 * exp(-0.0040000000000000001 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 / (1.5 * exp(0.0001 * var_chaste_interface__membrane__Vm) + 40.0 * exp(0.15873015873015872 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double d_dt_chaste_interface_var_T_type_Ca_channel_y2_gate__y2 = (1.0 - var_chaste_interface__T_type_Ca_channel_y2_gate__y2) / (30.0 * exp(0.00033333333333333332 * var_chaste_interface__membrane__Vm) + 62000.0 * exp(0.099009900990099015 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 / (1.2 * exp(-0.040000000000000001 * var_chaste_interface__membrane__Vm) + 0.00059999999999999995 * exp(-0.14925373134328357 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-1.8) : (0.074870384603595908 * (-1.8 * exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm) + var_internal_ion_concentrations__Cai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.074870384603595908 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Ca = 8712.0 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__iCaL = 0.067599999999999993 * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__Cacm = -0.29999999999999999 * var_L_type_Ca_channel_Ca_dependent_gate__iCaL + var_internal_ion_concentrations__Cai; // millimolar
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C = 0.34999999999999998 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + 0.0041999999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__p_CCa - (0.14299999999999999 + 6.9539999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C; // 1 / millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca = 6.9539999999999997 * (1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL) * var_internal_ion_concentrations__Cai + 6.9539999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U = 0.14299999999999999 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C + 2.0019999999999998 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa - (0.34999999999999998 + var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa = 0.00029999999999999997 * var_L_type_Ca_channel_Ca_dependent_gate__p_CCa - 2.3519999999999999 * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa + var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U; // 1 / millisecond
        const double var_RyR_channel__k1 = 280000.0 * pow(var_internal_ion_concentrations__Cai, 2) - 150.0 * var_L_type_Ca_channel__p_open_CaL * var_L_type_Ca_channel_Ca_dependent_gate__iCaL; // per_millisecond
        const double d_dt_chaste_interface_var_RyR_channel__p_close_RyR = -(0.00084900000000000004 + var_RyR_channel__k1) * var_chaste_interface__RyR_channel__p_close_RyR + 0.000377 * pow(var_Ca_concentrations_in_SR__Carel, 2) * (1.0 - var_chaste_interface__RyR_channel__p_close_RyR - var_chaste_interface__RyR_channel__p_open_RyR); // 1 / millisecond
        const double d_dt_chaste_interface_var_RyR_channel__p_open_RyR = var_RyR_channel__k1 * var_chaste_interface__RyR_channel__p_close_RyR - 0.080000000000000002 * var_chaste_interface__RyR_channel__p_open_RyR / (1.0 + 0.35999999999999999 / var_Ca_concentrations_in_SR__Carel); // 1 / millisecond
        const double var_T_type_Ca_channel__i_Ca_T = 612.0 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca; // picoA
        const double var_background_Cab_current__i_Cab = 0.040000000000000001 * var_constant_field_equations__CF_Ca; // picoA
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : (0.037435192301797954 * (-5.4000000000000004 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Ki) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_K = 3.1798799999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K; // picoA
        const double var_background_Kpl_current__i_Kpl = ((var_chaste_interface__membrane__Vm == (-3.0)) ? (0.0014308470000000001 * var_constant_field_equations__CF_K) : (0.00011 * (3.0 + var_chaste_interface__membrane__Vm) * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_background_NSC_current__i_bNSC_K = 0.15400000000000003 * var_constant_field_equations__CF_K; // picoA
        const double var_background_lCa_current__i_lCa_K = 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_K; // picoA
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-140.0) : (0.037435192301797954 * (-140.0 * exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm) + var_chaste_interface__internal_ion_concentrations__Nai) * var_chaste_interface__membrane__Vm / (1.0 - exp(-0.037435192301797954 * var_chaste_interface__membrane__Vm)))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Na = 0.16117199999999998 * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na; // picoA
        const double var_background_NSC_current__i_bNSC_Na = 0.38500000000000001 * var_constant_field_equations__CF_Na; // picoA
        const double var_background_lCa_current__i_lCa_Na = 0.11 * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na; // picoA
        const double var_membrane__i_ext = 1.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time) * mParameters[0] / HeartConfig::Instance()->GetCapacitance(); // picoA
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y1_gate__y1 = -(1 / (160.0 * exp(0.035714285714285712 * var_chaste_interface__membrane__Vm) + 200.0 * exp(0.001 * var_chaste_interface__membrane__Vm)) + 0.00040000000000000002 / exp(0.050000000000000003 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 + (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) / (5.0 * exp(-0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 20.0 * exp(-0.086956521739130432 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y2_gate__y2 = -(1 / (1600.0 * exp(0.035714285714285712 * var_chaste_interface__membrane__Vm) + 2000.0 * exp(0.001 * var_chaste_interface__membrane__Vm)) + 0.0001 / exp(0.050000000000000003 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2) / (20.0 * exp(-0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 200.0 * exp(-0.076923076923076927 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y3_gate__y3 = (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3) / (2.5 * exp(0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 10.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 / (2.0 * exp(-0.0066666666666666671 * var_chaste_interface__membrane__Vm) + 0.34999999999999998 * exp(-0.058823529411764705 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y1_gate__y1 = (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1) / (85.0 * exp(-0.095238095238095233 * var_chaste_interface__membrane__Vm) + 370.0 * exp(-0.016129032258064516 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 / (260.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 1450.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2 = -0.004444 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 + 3.7000000000000002 * (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_internal_ion_concentrations__Cai; // 1 / millisecond
        const double var_slow_time_dependent_potassium_current__i_Ks_K = 5.04 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_Na = 0.2016 * pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na; // picoA
        const double var_sodium_calcium_exchanger__k1 = exp(0.011979261536575346 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp(-0.025455930765222609 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + 669.921875 * (1.0 + 724.63768115942037 * var_internal_ion_concentrations__Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y = (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * (0.20379327210477693 + 0.6399652192815608 * var_sodium_calcium_exchanger__k2) - (1 / (1.0 + 0.0013799999999999999 * (1.0 + 0.0014927113702623907 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)) / var_internal_ion_concentrations__Cai) + var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na) * var_chaste_interface__sodium_calcium_exchanger_y_gate__y; // 1 / millisecond
        const double var_sodium_calcium_exchanger__i_NaCa = 6.8099999999999996 * (-0.6399652192815608 * (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 + var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * mParameters[0]; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total = 0.070000000000000007 * var_NL_model__Q_d2 + 0.070000000000000007 * var_NL_model__Q_r + 6.4775767022812476e-7 * var_RyR_channel__i_RyR + 6.4775767022812476e-7 * var_SR_L_current__i_SR_L + 6.4775767022812476e-7 * var_SR_calcium_pump__i_SR_U + 1.2955153404562495e-6 * var_sodium_calcium_exchanger__i_NaCa - 0.070000000000000007 * var_NL_model__Q_b - 6.4775767022812476e-7 * var_L_type_Ca_channel__i_CaL_Ca - 6.4775767022812476e-7 * var_T_type_Ca_channel__i_Ca_T - 6.4775767022812476e-7 * var_background_Cab_current__i_Cab; // millimolar / millisecond
        const double d_dt_chaste_interface_var_sodium_current_ultra_slow_gate__y = (1.0 - var_chaste_interface__sodium_current_ultra_slow_gate__y) / (8000.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 9000000000.0 * exp(0.20000000000000001 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__sodium_current_ultra_slow_gate__y / (4000.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.014 * exp(-0.20000000000000001 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AI_RI = 1 / (1300.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm) + 0.040000000000000001 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_AI = 1.25 / exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_RP = 1 / (26.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm) + 0.02 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RI_AI = 1 / (5.0 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm) + 0.0001027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_AP = 1 / (0.25 * exp(-0.02 * var_chaste_interface__membrane__Vm) + 0.1027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_RI = 0.01 / (1.0 + 8.7499999999999999e-5 * var_sodium_current_voltage_dependent_gate__k_AP_RP * var_sodium_current_voltage_dependent_gate__k_RI_AI / (var_sodium_current_voltage_dependent_gate__k_AI_RI * var_sodium_current_voltage_dependent_gate__k_AP_AI * var_sodium_current_voltage_dependent_gate__k_RP_AP)); // per_millisecond
        const double var_sodium_current__i_Na_K = 286.0 * var_constant_field_equations__CF_K * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na_Na = 2860.0 * var_constant_field_equations__CF_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na = 8.7499999999999999e-5 * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na + var_sodium_current_voltage_dependent_gate__k_RP_AP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na - (var_sodium_current_voltage_dependent_gate__k_AP_AI + var_sodium_current_voltage_dependent_gate__k_AP_RP) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // 1 / millisecond
        const double var_sodium_current_voltage_dependent_gate__p_RI_Na = 1.0 - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // dimensionless
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na = var_sodium_current_voltage_dependent_gate__k_AP_AI * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + var_sodium_current_voltage_dependent_gate__k_RI_AI * var_sodium_current_voltage_dependent_gate__p_RI_Na - (8.7499999999999999e-5 + var_sodium_current_voltage_dependent_gate__k_AI_RI) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na; // 1 / millisecond
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na = (0.01 - var_sodium_current_voltage_dependent_gate__k_RP_RI) * var_sodium_current_voltage_dependent_gate__p_RI_Na + var_sodium_current_voltage_dependent_gate__k_AP_RP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na - (var_sodium_current_voltage_dependent_gate__k_RP_AP + var_sodium_current_voltage_dependent_gate__k_RP_RI) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // 1 / millisecond
        const double var_sodium_potassium_pump__Nao_Eff = 140.0 * exp(-0.030696857687474322 * var_chaste_interface__membrane__Vm); // millimolar
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + 0.094 / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + 4.4045579125871104 * pow(1 / var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001) * (1.0 + 0.020000293738509214 * pow(var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + 2804.9496956618664 * pow(1 / var_sodium_potassium_pump__Nao_Eff, 1.0600000000000001)); // dimensionless
        const double d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y = (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * (0.040000000000000001 * var_sodium_potassium_pump__p_E2Na + 0.16500000000000001 / (1.0331690520373935 + 0.00036833781854815162 * pow(var_sodium_potassium_pump__Nao_Eff, 1.0600000000000001))) - (0.01 / (1.0 + 49.999265664512095 * pow(1 / var_chaste_interface__internal_ion_concentrations__Ki, 1.1200000000000001) * (1.0 + 0.22703754152993499 * pow(var_chaste_interface__internal_ion_concentrations__Nai, 1.0600000000000001))) + var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na) * var_chaste_interface__sodium_potassium_pump_y_gate__y; // 1 / millisecond
        const double var_sodium_potassium_pump__i_NaK = 21.0 * (-0.040000000000000001 * (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__p_E2Na + var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y) * mParameters[0]; // picoA
        const double d_dt_chaste_interface_var_ATP_production__ATPi = 0.014999999999999999 + 3.2387883511406238e-7 * var_SR_calcium_pump__i_SR_U - 0.0030000000000000001 * var_chaste_interface__ATP_production__ATPi - 0.028000000000000004 * var_chaste_interface__NL_model__pCaCB - 1.2955153404562495e-6 * var_sodium_potassium_pump__i_NaK; // millimolar / millisecond
        const double var_time_independent_potassium_current__E_K = 26.712831923985377 * log(5.4000000000000004 / var_chaste_interface__internal_ion_concentrations__Ki); // millivolt
        const double var_background_KATP_current__i_KATP = 66.022388395163091 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)); // picoA
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.0086400000000000001 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * mParameters[0] * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // picoA
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y = (1.0 - var_chaste_interface__time_independent_potassium_current_y_gate__y) / (7.0 * exp(-0.32333333333333331 + 0.0033333333333333335 * var_chaste_interface__membrane__Vm - 0.0033333333333333335 * var_time_independent_potassium_current__E_K) + 8000.0 * exp(-11.411764705882353 + 0.11764705882352941 * var_chaste_interface__membrane__Vm - 0.11764705882352941 * var_time_independent_potassium_current__E_K)) - 1.0 * pow(var_time_independent_potassium_current__fO, 4) * var_chaste_interface__time_independent_potassium_current_y_gate__y / (0.00013999999999999999 * exp(10.659340659340661 + 0.10989010989010989 * var_time_independent_potassium_current__E_K - 0.10989010989010989 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(0.19400000000000001 + 0.002 * var_time_independent_potassium_current__E_K - 0.002 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double var_time_independent_potassium_current__i_K1 = 1.1459999999999999 * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (pow(var_time_independent_potassium_current__fO, 4) + 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2) + 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB) * mParameters[0] * var_chaste_interface__time_independent_potassium_current_y_gate__y; // picoA
        const double d_dt_chaste_interface_var_transient_outward_current_y1_gate__y1 = (1.0 - var_chaste_interface__transient_outward_current_y1_gate__y1) / (11.0 * exp(-0.035714285714285712 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm)) - 1.0 * var_chaste_interface__transient_outward_current_y1_gate__y1 / (4.4000000000000004 * exp(0.0625 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(0.002 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_y2_gate__y2 = 0.0038 * (1.0 - var_chaste_interface__transient_outward_current_y2_gate__y2) * exp(-1.1946902654867255 - 0.088495575221238937 * var_chaste_interface__membrane__Vm) / (1.0 + 0.051334999999999999 * exp(-1.1946902654867255 - 0.088495575221238937 * var_chaste_interface__membrane__Vm)) - 0.0038 * var_chaste_interface__transient_outward_current_y2_gate__y2 * exp(1.1946902654867255 + 0.088495575221238937 * var_chaste_interface__membrane__Vm) / (1.0 + 0.067083000000000004 * exp(1.1946902654867255 + 0.088495575221238937 * var_chaste_interface__membrane__Vm)); // 1 / millisecond
        const double var_transient_outward_current__i_to_K = 0.033000000000000002 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Ki = 2.591030680912499e-6 * var_sodium_potassium_pump__i_NaK - 1.2955153404562495e-6 * var_L_type_Ca_channel__i_CaL_K - 1.2955153404562495e-6 * var_background_KATP_current__i_KATP - 1.2955153404562495e-6 * var_background_Kpl_current__i_Kpl - 1.2955153404562495e-6 * var_background_NSC_current__i_bNSC_K - 1.2955153404562495e-6 * var_background_lCa_current__i_lCa_K - 1.2955153404562495e-6 * var_membrane__i_ext - 1.2955153404562495e-6 * var_rapid_time_dependent_potassium_current__i_Kr - 1.2955153404562495e-6 * var_slow_time_dependent_potassium_current__i_Ks_K - 1.2955153404562495e-6 * var_sodium_current__i_Na_K - 1.2955153404562495e-6 * var_time_independent_potassium_current__i_K1 - 1.2955153404562495e-6 * var_transient_outward_current__i_to_K; // millimolar / millisecond
        const double var_transient_outward_current__i_to_Na = 0.00297 * pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Nai = -3.8865460213687481e-6 * var_sodium_calcium_exchanger__i_NaCa - 3.8865460213687481e-6 * var_sodium_potassium_pump__i_NaK - 1.2955153404562495e-6 * var_L_type_Ca_channel__i_CaL_Na - 1.2955153404562495e-6 * var_background_NSC_current__i_bNSC_Na - 1.2955153404562495e-6 * var_background_lCa_current__i_lCa_Na - 1.2955153404562495e-6 * var_slow_time_dependent_potassium_current__i_Ks_Na - 1.2955153404562495e-6 * var_sodium_current__i_Na_Na - 1.2955153404562495e-6 * var_transient_outward_current__i_to_Na; // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__Vm = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__Vm = (-var_L_type_Ca_channel__i_CaL_Ca - var_L_type_Ca_channel__i_CaL_K - var_L_type_Ca_channel__i_CaL_Na - var_T_type_Ca_channel__i_Ca_T - var_background_Cab_current__i_Cab - var_background_KATP_current__i_KATP - var_background_Kpl_current__i_Kpl - var_background_NSC_current__i_bNSC_K - var_background_NSC_current__i_bNSC_Na - var_background_lCa_current__i_lCa_K - var_background_lCa_current__i_lCa_Na - var_membrane__i_ext - var_rapid_time_dependent_potassium_current__i_Kr - var_slow_time_dependent_potassium_current__i_Ks_K - var_slow_time_dependent_potassium_current__i_Ks_Na - var_sodium_calcium_exchanger__i_NaCa - var_sodium_current__i_Na_K - var_sodium_current__i_Na_Na - var_sodium_potassium_pump__i_NaK - var_time_independent_potassium_current__i_K1 - var_transient_outward_current__i_to_K - var_transient_outward_current__i_to_Na) / mParameters[0]; // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__Vm;
        rDY[1] = d_dt_chaste_interface_var_internal_ion_concentrations__Nai;
        rDY[2] = d_dt_chaste_interface_var_internal_ion_concentrations__Ki;
        rDY[3] = d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total;
        rDY[4] = d_dt_chaste_interface_var_ATP_production__ATPi;
        rDY[5] = d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na;
        rDY[6] = d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na;
        rDY[7] = d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na;
        rDY[8] = d_dt_chaste_interface_var_sodium_current_ultra_slow_gate__y;
        rDY[9] = d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        rDY[10] = d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL;
        rDY[11] = d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL;
        rDY[12] = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U;
        rDY[13] = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa;
        rDY[14] = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C;
        rDY[15] = d_dt_chaste_interface_var_L_type_Ca_channel_ultra_slow_gate__y;
        rDY[16] = d_dt_chaste_interface_var_T_type_Ca_channel_y1_gate__y1;
        rDY[17] = d_dt_chaste_interface_var_T_type_Ca_channel_y2_gate__y2;
        rDY[18] = d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y;
        rDY[19] = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y1_gate__y1;
        rDY[20] = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y2_gate__y2;
        rDY[21] = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y3_gate__y3;
        rDY[22] = d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y1_gate__y1;
        rDY[23] = d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2;
        rDY[24] = d_dt_chaste_interface_var_transient_outward_current_y1_gate__y1;
        rDY[25] = d_dt_chaste_interface_var_transient_outward_current_y2_gate__y2;
        rDY[26] = d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y;
        rDY[27] = d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y;
        rDY[28] = d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y;
        rDY[29] = d_dt_chaste_interface_var_RyR_channel__p_open_RyR;
        rDY[30] = d_dt_chaste_interface_var_RyR_channel__p_close_RyR;
        rDY[31] = d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total;
        rDY[32] = d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup;
        rDY[33] = d_dt_chaste_interface_var_NL_model__pCa;
        rDY[34] = d_dt_chaste_interface_var_NL_model__pCaCB;
        rDY[35] = d_dt_chaste_interface_var_NL_model__pCB;
        rDY[36] = d_dt_chaste_interface_var_NL_model__X;
    }

    std::vector<double> Cellmatsuoka_model_2003FromCellMLOpt::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        

        // Mathematics
        const double var_internal_ion_concentrations__CMDN_max = 0.050000000000000003; // millimolar
        const double var_internal_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_internal_ion_concentrations__b1 = -var_chaste_interface__internal_ion_concentrations__Ca_Total + var_internal_ion_concentrations__CMDN_max + var_internal_ion_concentrations__K_mCMDN; // millimolar
        const double var_internal_ion_concentrations__c1 = var_chaste_interface__internal_ion_concentrations__Ca_Total * var_internal_ion_concentrations__K_mCMDN; // millimolar2
        const double var_internal_ion_concentrations__Cai = sqrt(0.25 * pow(var_internal_ion_concentrations__b1, 2) + var_internal_ion_concentrations__c1) - 0.5 * var_internal_ion_concentrations__b1; // millimolar
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF
        const double var_membrane__i_ext_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(4);
        dqs[0] = var_internal_ion_concentrations__Cai;
        dqs[1] = var_chaste_interface__environment__time;
        dqs[2] = var_membrane__Cm_converted;
        dqs[3] = var_membrane__i_ext_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellmatsuoka_model_2003FromCellMLOpt>::Initialise(void)
{
    this->mSystemName = "matsuoka_model_2003";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-85.95752434460744);

    // rY[1]:
    this->mVariableNames.push_back("internal_ion_concentrations__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(4.925761439682025);

    // rY[2]:
    this->mVariableNames.push_back("internal_ion_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(143.1837333000449);

    // rY[3]:
    this->mVariableNames.push_back("internal_ion_concentrations__Ca_Total");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00040180173572968586);

    // rY[4]:
    this->mVariableNames.push_back("ATP_production__ATPi");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(4.657102729020499);

    // rY[5]:
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_AP_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.779648367445368e-05);

    // rY[6]:
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_RP_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3556412697995689);

    // rY[7]:
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_AI_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.40285968661346977);

    // rY[8]:
    this->mVariableNames.push_back("sodium_current_ultra_slow_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5861887862983165);

    // rY[9]:
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.5445004166497696e-06);

    // rY[10]:
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9968480629364956);

    // rY[11]:
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000877325391245903);

    // rY[12]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_U");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.17246483915629204);

    // rY[13]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_UCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.098246017787626e-05);

    // rY[14]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4250747299372254);

    // rY[15]:
    this->mVariableNames.push_back("L_type_Ca_channel_ultra_slow_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9985266538252986);

    // rY[16]:
    this->mVariableNames.push_back("T_type_Ca_channel_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.6882718240109127e-05);

    // rY[17]:
    this->mVariableNames.push_back("T_type_Ca_channel_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8585352091865849);

    // rY[18]:
    this->mVariableNames.push_back("time_independent_potassium_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6080573900752752);

    // rY[19]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0018339931180983765);

    // rY[20]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.20443083454225305);

    // rY[21]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y3_gate__y3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.967887666264921);

    // rY[22]:
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09738789658609195);

    // rY[23]:
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09745345578743213);

    // rY[24]:
    this->mVariableNames.push_back("transient_outward_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0007956883250874798);

    // rY[25]:
    this->mVariableNames.push_back("transient_outward_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999125083105881);

    // rY[26]:
    this->mVariableNames.push_back("sodium_calcium_exchanger_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9891789193465331);

    // rY[27]:
    this->mVariableNames.push_back("sodium_potassium_pump_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5910747147428818);

    // rY[28]:
    this->mVariableNames.push_back("SR_calcium_pump_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.46108441538480216);

    // rY[29]:
    this->mVariableNames.push_back("RyR_channel__p_open_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00034314360001543243);

    // rY[30]:
    this->mVariableNames.push_back("RyR_channel__p_close_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.19135178123107768);

    // rY[31]:
    this->mVariableNames.push_back("Ca_concentrations_in_SR__Ca_Total");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.455741736977666);

    // rY[32]:
    this->mVariableNames.push_back("Ca_concentrations_in_SR__Caup");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.611712901567567);

    // rY[33]:
    this->mVariableNames.push_back("NL_model__pCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02490898775497523);

    // rY[34]:
    this->mVariableNames.push_back("NL_model__pCaCB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001990153835322864);

    // rY[35]:
    this->mVariableNames.push_back("NL_model__pCB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00042941813853474524);

    // rY[36]:
    this->mVariableNames.push_back("NL_model__X");
    this->mVariableUnits.push_back("micrometre");
    this->mInitialConditions.push_back(0.9573749975411884);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("picoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("cytosolic_calcium_concentration");
    this->mDerivedQuantityUnits.push_back("millimolar");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    // Derived Quantity index [3]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellmatsuoka_model_2003FromCellMLOpt)
