//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: grandi2010
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "grandi2010ss.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellgrandi2010ssFromCellMLOpt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__cell__stim_amplitude_converted = -15.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__cell__stim_duration = 3.0; // ms
        const double var_chaste_interface__cell__stim_offset = 0; // ms
        const double var_chaste_interface__cell__stim_period = 1000.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__cell__stim_amplitude_converted),
                var_chaste_interface__cell__stim_duration,
                var_chaste_interface__cell__stim_period,
                var_chaste_interface__cell__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellgrandi2010ssFromCellMLOpt::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[37];
    }
    Cellgrandi2010ssFromCellMLOpt::Cellgrandi2010ssFromCellMLOpt(boost::shared_ptr<AbstractIvpOdeSolver> pSolver, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCardiacCell(
                pSolver,
                38,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellgrandi2010ssFromCellMLOpt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 1.0; // (var_cell__G_CaL_mult) [dimensionless]
        this->mParameters[1] = 23.0; // (var_cell__GNa) [dimensionless]
        this->mParameters[2] = 1.0; // (var_cell__gkr_mult) [dimensionless]
    }

    Cellgrandi2010ssFromCellMLOpt::~Cellgrandi2010ssFromCellMLOpt()
    {
    }
    
    double Cellgrandi2010ssFromCellMLOpt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__cell__sVm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -81.3842590704928
        double var_chaste_interface__cell__sm = rY[1];
        // Units: dimensionless; Initial value: 0.00384941567866232
        double var_chaste_interface__cell__sh = rY[2];
        // Units: dimensionless; Initial value: 0.623723834301669
        double var_chaste_interface__cell__sj = rY[3];
        // Units: dimensionless; Initial value: 0.622080736932815
        double var_chaste_interface__cell__sd = rY[4];
        // Units: dimensionless; Initial value: 2.95884913218079e-06
        double var_chaste_interface__cell__sf = rY[5];
        // Units: dimensionless; Initial value: 0.995094078386247
        double var_chaste_interface__cell__sfcaBj = rY[6];
        // Units: dimensionless; Initial value: 0.0246274349529557
        double var_chaste_interface__cell__sfcaBsl = rY[7];
        // Units: dimensionless; Initial value: 0.0150911724206476
        double var_chaste_interface__cell__sxtos = rY[8];
        // Units: dimensionless; Initial value: 0.000442853722673121
        double var_chaste_interface__cell__sytos = rY[9];
        // Units: dimensionless; Initial value: 0.789013894749951
        double var_chaste_interface__cell__sxtof = rY[10];
        // Units: dimensionless; Initial value: 0.000442846429332686
        double var_chaste_interface__cell__sytof = rY[11];
        // Units: dimensionless; Initial value: 0.999995784674368
        double var_chaste_interface__cell__sxkr = rY[12];
        // Units: dimensionless; Initial value: 0.020160578118589
        double var_chaste_interface__cell__sxks = rY[13];
        // Units: dimensionless; Initial value: 0.00430143235332308
        double var_chaste_interface__cell__sNaj = rY[32];
        // Units: dimensionless; Initial value: 8.21411036389602
        double var_chaste_interface__cell__sNasl = rY[33];
        // Units: dimensionless; Initial value: 8.21322794157889
        double var_chaste_interface__cell__sNai = rY[34];
        // Units: dimensionless; Initial value: 8.21340895351653
        double var_chaste_interface__cell__sCaj = rY[35];
        // Units: dimensionless; Initial value: 0.000175648385857736
        double var_chaste_interface__cell__sCasl = rY[36];
        // Units: dimensionless; Initial value: 0.000105614570409386
        
        const double var_cell__Qpow = 0; // dimensionless
        const double var_cell__fcaCaMSL = 0; // dimensionless
        const double var_cell__fcaCaj = 0; // dimensionless
        const double var_cell__pCa = 0.00027 * mParameters[0]; // dimensionless
        const double var_cell__pNa = 7.4999999999999993e-9 * mParameters[0]; // dimensionless
        const double var_cell__eks = 26.712338705498265 * log(7.9662000000000006 / (120.0 + 0.018329999999999999 * var_chaste_interface__cell__sNai)); // dimensionless
        const double var_cell__ena_junc = 26.712338705498265 * log(140.0 / var_chaste_interface__cell__sNaj); // dimensionless
        const double var_cell__ena_sl = 26.712338705498265 * log(140.0 / var_chaste_interface__cell__sNasl); // dimensionless
        const double var_cell__kp_kp = 1 / (1.0 + exp(7.4880000000000004 - 0.16722408026755853 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__I_ncx_junc = 0.495 * pow(1.5700000000000001, var_cell__Qpow) * (1.8 * pow(var_chaste_interface__cell__sNaj, 3) * exp(0.010107688547106707 * var_chaste_interface__cell__sVm) - 2744000.0 * var_chaste_interface__cell__sCaj * exp(-0.027328194960695912 * var_chaste_interface__cell__sVm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328194960695912 * var_chaste_interface__cell__sVm)) * (1.0 + 2.2499999999999996e-8 / pow(var_chaste_interface__cell__sCaj, 2)) * (9850.9599999999991 + 2744000.0 * var_chaste_interface__cell__sCaj + 8.4066800865219591 * pow(var_chaste_interface__cell__sNaj, 3) + 669921.875 * (1.0 + 278.55153203342621 * var_chaste_interface__cell__sCaj) * var_chaste_interface__cell__sCaj)); // dimensionless
        const double var_cell__I_ncx_sl = 4.0049999999999999 * pow(1.5700000000000001, var_cell__Qpow) * (1.8 * pow(var_chaste_interface__cell__sNasl, 3) * exp(0.010107688547106707 * var_chaste_interface__cell__sVm) - 2744000.0 * var_chaste_interface__cell__sCasl * exp(-0.027328194960695912 * var_chaste_interface__cell__sVm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328194960695912 * var_chaste_interface__cell__sVm)) * (1.0 + 2.2499999999999996e-8 / pow(var_chaste_interface__cell__sCasl, 2)) * (9850.9599999999991 + 2744000.0 * var_chaste_interface__cell__sCasl + 8.4066800865219591 * pow(var_chaste_interface__cell__sNasl, 3) + 669921.875 * (1.0 + 278.55153203342621 * var_chaste_interface__cell__sCasl) * var_chaste_interface__cell__sCasl)); // dimensionless
        const double var_cell__fnak = 1 / (1.0 + 0.1245 * exp(-0.003743588350780262 * var_chaste_interface__cell__sVm) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.037435883507802616 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__I_nak_junc = 0.15495652173913044 * var_cell__fnak / (1.0 + 14641.0 / pow(var_chaste_interface__cell__sNaj, 4)); // dimensionless
        const double var_cell__I_nak_sl = 1.2537391304347827 * var_cell__fnak / (1.0 + 14641.0 / pow(var_chaste_interface__cell__sNasl, 4)); // dimensionless
        const double var_cell__I_tot = 0.5535668961205934 + var_cell__I_nak_junc + var_cell__I_nak_sl + var_cell__I_ncx_junc + var_cell__I_ncx_sl + 0.010148299999999999 * var_chaste_interface__cell__sVm - 6.567e-5 * var_cell__ena_junc - 0.00053133 * var_cell__ena_sl - 0.00080995817805876559 * log(1.8 / var_chaste_interface__cell__sCaj) - 0.0065532979861118307 * log(1.8 / var_chaste_interface__cell__sCasl) + 0.002 * (82.837440942604388 + var_chaste_interface__cell__sVm) * var_cell__kp_kp + 0.0035000000000000001 * pow(var_chaste_interface__cell__sxks, 2) * (-var_cell__eks + var_chaste_interface__cell__sVm) + 0.006029375 * (61.507432902288166 + var_chaste_interface__cell__sVm) / (1.0 + 0.10000000000000001 / var_chaste_interface__cell__sCaj) + 0.048783124999999997 * (61.507432902288166 + var_chaste_interface__cell__sVm) / (1.0 + 0.10000000000000001 / var_chaste_interface__cell__sCasl) + 0.1144 * (82.837440942604388 + var_chaste_interface__cell__sVm) * var_chaste_interface__cell__sxtof * var_chaste_interface__cell__sytof + 0.0074029999999999999 * pow(2.3500000000000001, var_cell__Qpow) * pow(var_chaste_interface__cell__sCaj, 1.6000000000000001) / (5.2281977629563632e-6 + pow(var_chaste_interface__cell__sCaj, 1.6000000000000001)) + 0.015599999999999999 * (82.837440942604388 + var_chaste_interface__cell__sVm) * var_chaste_interface__cell__sxtos * var_chaste_interface__cell__sytos + 0.35699999999999998 * (82.837440942604388 + var_chaste_interface__cell__sVm) / ((1.0 + exp(5.6339521648111468 + 0.23849999999999999 * var_chaste_interface__cell__sVm)) * (1.02 / (1.0 + exp(5.6339521648111468 + 0.23849999999999999 * var_chaste_interface__cell__sVm)) + (0.49124000000000001 * exp(7.0933355765099853 + 0.080320000000000003 * var_chaste_interface__cell__sVm) + exp(-31.583430521794174 + 0.061749999999999999 * var_chaste_interface__cell__sVm)) / (1.0 + exp(-45.047763776781437 - 0.51429999999999998 * var_chaste_interface__cell__sVm)))) + 0.059896999999999999 * pow(2.3500000000000001, var_cell__Qpow) * pow(var_chaste_interface__cell__sCasl, 1.6000000000000001) / (5.2281977629563632e-6 + pow(var_chaste_interface__cell__sCasl, 1.6000000000000001)) + 0.035000000000000003 * (82.837440942604388 + var_chaste_interface__cell__sVm) * mParameters[2] * var_chaste_interface__cell__sxkr / (1.0 + exp(3.0833333333333335 + 0.041666666666666664 * var_chaste_interface__cell__sVm)) + 0.11 * pow(var_chaste_interface__cell__sm, 3) * (-var_cell__ena_junc + var_chaste_interface__cell__sVm) * mParameters[1] * var_chaste_interface__cell__sh * var_chaste_interface__cell__sj + 0.89000000000000001 * pow(var_chaste_interface__cell__sm, 3) * (-var_cell__ena_sl + var_chaste_interface__cell__sVm) * mParameters[1] * var_chaste_interface__cell__sh * var_chaste_interface__cell__sj + 1462.860494201386 * pow(1.8, var_cell__Qpow) * (-105.0 + 0.75 * var_chaste_interface__cell__sNaj * exp(0.037435883507802616 * var_chaste_interface__cell__sVm)) * (1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__pNa * var_chaste_interface__cell__sVm * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf / (-1.0 + exp(0.037435883507802616 * var_chaste_interface__cell__sVm)) + 5851.4419768055441 * pow(1.8, var_cell__Qpow) * (-0.61380000000000001 + 0.34100000000000003 * var_chaste_interface__cell__sCaj * exp(0.074871767015605231 * var_chaste_interface__cell__sVm)) * (1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__pCa * var_chaste_interface__cell__sVm * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf / (-1.0 + exp(0.074871767015605231 * var_chaste_interface__cell__sVm)) + 0.0002194290741302079 * pow(1.8, var_cell__Qpow) * (-4.0500000000000007 + 90.0 * exp(0.037435883507802616 * var_chaste_interface__cell__sVm)) * (1.0 + 0.099999999999999978 * var_cell__fcaCaMSL + 0.90000000000000002 * var_cell__fcaCaj - 0.099999999999999978 * var_chaste_interface__cell__sfcaBsl - 0.90000000000000002 * var_chaste_interface__cell__sfcaBj) * mParameters[0] * var_chaste_interface__cell__sVm * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf / (-1.0 + exp(0.037435883507802616 * var_chaste_interface__cell__sVm)) + 162.54005491126506 * pow(1.8, var_cell__Qpow) * (-105.0 + 0.75 * var_chaste_interface__cell__sNasl * exp(0.037435883507802616 * var_chaste_interface__cell__sVm)) * (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__pNa * var_chaste_interface__cell__sVm * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf / (-1.0 + exp(0.037435883507802616 * var_chaste_interface__cell__sVm)) + 650.16021964506024 * pow(1.8, var_cell__Qpow) * (-0.61380000000000001 + 0.34100000000000003 * var_chaste_interface__cell__sCasl * exp(0.074871767015605231 * var_chaste_interface__cell__sVm)) * (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__pCa * var_chaste_interface__cell__sVm * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf / (-1.0 + exp(0.074871767015605231 * var_chaste_interface__cell__sVm)); // uA_per_uF
        const double var_chaste_interface__i_ionic = HeartConfig::Instance()->GetCapacitance() * var_cell__I_tot; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellgrandi2010ssFromCellMLOpt::EvaluateYDerivatives(double var_chaste_interface__cell__time, const std::vector<double>& rY, std::vector<double>& rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__cell__sVm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -81.3842590704928
        double var_chaste_interface__cell__sm = rY[1];
        // Units: dimensionless; Initial value: 0.00384941567866232
        double var_chaste_interface__cell__sh = rY[2];
        // Units: dimensionless; Initial value: 0.623723834301669
        double var_chaste_interface__cell__sj = rY[3];
        // Units: dimensionless; Initial value: 0.622080736932815
        double var_chaste_interface__cell__sd = rY[4];
        // Units: dimensionless; Initial value: 2.95884913218079e-06
        double var_chaste_interface__cell__sf = rY[5];
        // Units: dimensionless; Initial value: 0.995094078386247
        double var_chaste_interface__cell__sfcaBj = rY[6];
        // Units: dimensionless; Initial value: 0.0246274349529557
        double var_chaste_interface__cell__sfcaBsl = rY[7];
        // Units: dimensionless; Initial value: 0.0150911724206476
        double var_chaste_interface__cell__sxtos = rY[8];
        // Units: dimensionless; Initial value: 0.000442853722673121
        double var_chaste_interface__cell__sytos = rY[9];
        // Units: dimensionless; Initial value: 0.789013894749951
        double var_chaste_interface__cell__sxtof = rY[10];
        // Units: dimensionless; Initial value: 0.000442846429332686
        double var_chaste_interface__cell__sytof = rY[11];
        // Units: dimensionless; Initial value: 0.999995784674368
        double var_chaste_interface__cell__sxkr = rY[12];
        // Units: dimensionless; Initial value: 0.020160578118589
        double var_chaste_interface__cell__sxks = rY[13];
        // Units: dimensionless; Initial value: 0.00430143235332308
        double var_chaste_interface__cell__sRyRr = rY[14];
        // Units: dimensionless; Initial value: 0.893326456705696
        double var_chaste_interface__cell__sRyRo = rY[15];
        // Units: dimensionless; Initial value: 7.56436968249499e-07
        double var_chaste_interface__cell__sRyRi = rY[16];
        // Units: dimensionless; Initial value: 9.03266331737064e-08
        double var_chaste_interface__cell__sNaBj = rY[17];
        // Units: dimensionless; Initial value: 3.41097946062695
        double var_chaste_interface__cell__sNaBsl = rY[18];
        // Units: dimensionless; Initial value: 0.744248540671373
        double var_chaste_interface__cell__sTnCL = rY[19];
        // Units: dimensionless; Initial value: 0.00904644567707666
        double var_chaste_interface__cell__sTnCHc = rY[20];
        // Units: dimensionless; Initial value: 0.1183943202639
        double var_chaste_interface__cell__sTnCHm = rY[21];
        // Units: dimensionless; Initial value: 0.0101423649465603
        double var_chaste_interface__cell__sCaM = rY[22];
        // Units: dimensionless; Initial value: 0.000299824763475116
        double var_chaste_interface__cell__sMyoc = rY[23];
        // Units: dimensionless; Initial value: 0.00201443980536826
        double var_chaste_interface__cell__sMyom = rY[24];
        // Units: dimensionless; Initial value: 0.137467597337588
        double var_chaste_interface__cell__sSRB = rY[25];
        // Units: dimensionless; Initial value: 0.00220110816535249
        double var_chaste_interface__cell__sSLLj = rY[26];
        // Units: dimensionless; Initial value: 0.00739549938515031
        double var_chaste_interface__cell__sSLLsl = rY[27];
        // Units: dimensionless; Initial value: 0.00979616077807075
        double var_chaste_interface__cell__sSLHj = rY[28];
        // Units: dimensionless; Initial value: 0.0735225248399363
        double var_chaste_interface__cell__sSLHsl = rY[29];
        // Units: dimensionless; Initial value: 0.113642236788144
        double var_chaste_interface__cell__sCsqnb = rY[30];
        // Units: dimensionless; Initial value: 1.20762712858574
        double var_chaste_interface__cell__sCa_sr = rY[31];
        // Units: dimensionless; Initial value: 0.563755421404699
        double var_chaste_interface__cell__sNaj = rY[32];
        // Units: dimensionless; Initial value: 8.21411036389602
        double var_chaste_interface__cell__sNasl = rY[33];
        // Units: dimensionless; Initial value: 8.21322794157889
        double var_chaste_interface__cell__sNai = rY[34];
        // Units: dimensionless; Initial value: 8.21340895351653
        double var_chaste_interface__cell__sCaj = rY[35];
        // Units: dimensionless; Initial value: 0.000175648385857736
        double var_chaste_interface__cell__sCasl = rY[36];
        // Units: dimensionless; Initial value: 0.000105614570409386
        double var_chaste_interface__cell__sCai = rY[37];
        // Units: dimensionless; Initial value: 8.85230799863012e-05

        // Mathematics
        double d_dt_chaste_interface_var_cell__sVm;
        const double var_cell__Qpow = 0; // dimensionless
        const double var_cell__Vcell = 1.0506250000000001e-11 * M_PI; // dimensionless
        const double var_cell__Vjunc = 0.00053900000000000009 * var_cell__Vcell; // dimensionless
        const double var_cell__Vmyo = 0.65000000000000002 * var_cell__Vcell; // dimensionless
        const double var_cell__Vsl = 0.02 * var_cell__Vcell; // dimensionless
        const double var_cell__Vsr = 0.035000000000000003 * var_cell__Vcell; // dimensionless
        const double var_cell__fcaCaMSL = 0; // dimensionless
        const double var_cell__fcaCaj = 0; // dimensionless
        const double var_cell__pCa = 0.00027 * mParameters[0]; // dimensionless
        const double var_cell__pNa = 7.4999999999999993e-9 * mParameters[0]; // dimensionless
        const double var_cell__kCaSR = 15.0 - 14.0 / (1.0 + 0.13584112963311223 * pow(1 / var_chaste_interface__cell__sCa_sr, 2.5)); // dimensionless
        const double var_cell__kiSRCa = 0.5 * var_cell__kCaSR; // dimensionless
        const double var_cell__koSRCa = 10.0 / var_cell__kCaSR; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCaM = -0.23799999999999999 * var_chaste_interface__cell__sCaM + 34.0 * (0.024 - var_chaste_interface__cell__sCaM) * var_chaste_interface__cell__sCai; // 1 / ms
        const double var_cell__J_serca = 0.0053114 * pow(2.6000000000000001, var_cell__Qpow) * (2814485.1633595936 * pow(var_chaste_interface__cell__sCai, 1.7869999999999999) - 0.38742512113256738 * pow(var_chaste_interface__cell__sCa_sr, 1.7869999999999999)) / (1.0 + 0.38742512113256738 * pow(var_chaste_interface__cell__sCa_sr, 1.7869999999999999) + 2814485.1633595936 * pow(var_chaste_interface__cell__sCai, 1.7869999999999999)); // dimensionless
        const double var_cell__J_SRleak = 5.3480000000000003e-6 * var_chaste_interface__cell__sCa_sr - 5.3480000000000003e-6 * var_chaste_interface__cell__sCaj; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCsqnb = -65.0 * var_chaste_interface__cell__sCsqnb + 100.0 * (-var_chaste_interface__cell__sCsqnb + 0.14000000000000001 * var_cell__Vmyo / var_cell__Vsr) * var_chaste_interface__cell__sCa_sr; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sMyoc = -0.00046000000000000001 * var_chaste_interface__cell__sMyoc + 13.800000000000001 * (0.14000000000000001 - var_chaste_interface__cell__sMyoc - var_chaste_interface__cell__sMyom) * var_chaste_interface__cell__sCai; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sMyom = 0.0021979999999999999 - 0.015699999999999999 * var_chaste_interface__cell__sMyoc - 0.015757 * var_chaste_interface__cell__sMyom; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sNaBj = -0.001 * var_chaste_interface__cell__sNaBj + 0.0001 * (7.5609999999999999 - var_chaste_interface__cell__sNaBj) * var_chaste_interface__cell__sNaj; // 1 / ms
        const double var_cell__ena_junc = 26.712338705498265 * log(140.0 / var_chaste_interface__cell__sNaj); // dimensionless
        const double d_dt_chaste_interface_var_cell__sNaBsl = -0.001 * var_chaste_interface__cell__sNaBsl + 0.0001 * (1.6499999999999999 - var_chaste_interface__cell__sNaBsl) * var_chaste_interface__cell__sNasl; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sNai = 1.6386279222197945e-12 * (-var_chaste_interface__cell__sNai + var_chaste_interface__cell__sNasl) / var_cell__Vmyo; // 1 / ms
        const double var_cell__ena_sl = 26.712338705498265 * log(140.0 / var_chaste_interface__cell__sNasl); // dimensionless
        const double var_cell__J_SRCarel = 25.0 * (-var_chaste_interface__cell__sCaj + var_chaste_interface__cell__sCa_sr) * var_chaste_interface__cell__sRyRo; // dimensionless
        const double d_dt_chaste_interface_var_cell__sCa_sr = -d_dt_chaste_interface_var_cell__sCsqnb - var_cell__J_SRCarel - var_cell__J_SRleak * var_cell__Vmyo / var_cell__Vsr + var_cell__J_serca; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sRyRo = 0.0050000000000000001 * var_chaste_interface__cell__sRyRi - 0.059999999999999998 * var_chaste_interface__cell__sRyRo + pow(var_chaste_interface__cell__sCaj, 2) * var_cell__koSRCa * var_chaste_interface__cell__sRyRr - var_cell__kiSRCa * var_chaste_interface__cell__sCaj * var_chaste_interface__cell__sRyRo; // 1 / ms
        const double var_cell__RI = 1.0 - var_chaste_interface__cell__sRyRi - var_chaste_interface__cell__sRyRo - var_chaste_interface__cell__sRyRr; // dimensionless
        const double d_dt_chaste_interface_var_cell__sRyRi = -0.065000000000000002 * var_chaste_interface__cell__sRyRi + pow(var_chaste_interface__cell__sCaj, 2) * var_cell__RI * var_cell__koSRCa + var_cell__kiSRCa * var_chaste_interface__cell__sCaj * var_chaste_interface__cell__sRyRo; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sRyRr = 0.059999999999999998 * var_chaste_interface__cell__sRyRo + 0.0050000000000000001 * var_cell__RI - pow(var_chaste_interface__cell__sCaj, 2) * var_cell__koSRCa * var_chaste_interface__cell__sRyRr - var_cell__kiSRCa * var_chaste_interface__cell__sCaj * var_chaste_interface__cell__sRyRr; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sSLHj = -0.029999999999999999 * var_chaste_interface__cell__sSLHj + 100.0 * (-var_chaste_interface__cell__sSLHj + 0.000165 * var_cell__Vmyo / var_cell__Vjunc) * var_chaste_interface__cell__sCaj; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sSLHsl = -0.029999999999999999 * var_chaste_interface__cell__sSLHsl + 100.0 * (-var_chaste_interface__cell__sSLHsl + 0.0134 * var_cell__Vmyo / var_cell__Vsl) * var_chaste_interface__cell__sCasl; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sSLLj = -1.3 * var_chaste_interface__cell__sSLLj + 100.0 * (-var_chaste_interface__cell__sSLLj + 0.00046000000000000001 * var_cell__Vmyo / var_cell__Vjunc) * var_chaste_interface__cell__sCaj; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sSLLsl = -1.3 * var_chaste_interface__cell__sSLLsl + 100.0 * (-var_chaste_interface__cell__sSLLsl + 0.037400000000000003 * var_cell__Vmyo / var_cell__Vsl) * var_chaste_interface__cell__sCasl; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sSRB = -0.059999999999999998 * var_chaste_interface__cell__sSRB + 100.0 * (0.017100000000000001 - var_chaste_interface__cell__sSRB) * var_chaste_interface__cell__sCai; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sTnCHc = -3.1999999999999999e-5 * var_chaste_interface__cell__sTnCHc + 2.3700000000000001 * (0.14000000000000001 - var_chaste_interface__cell__sTnCHc - var_chaste_interface__cell__sTnCHm) * var_chaste_interface__cell__sCai; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sTnCHm = 0.00042000000000000007 - 0.0030000000000000001 * var_chaste_interface__cell__sTnCHc - 0.0063300000000000006 * var_chaste_interface__cell__sTnCHm; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sTnCL = -0.019599999999999999 * var_chaste_interface__cell__sTnCL + 32.700000000000003 * (0.070000000000000007 - var_chaste_interface__cell__sTnCL) * var_chaste_interface__cell__sCai; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sCai = -d_dt_chaste_interface_var_cell__sCaM - d_dt_chaste_interface_var_cell__sMyoc - d_dt_chaste_interface_var_cell__sMyom - d_dt_chaste_interface_var_cell__sSRB - d_dt_chaste_interface_var_cell__sTnCHc - d_dt_chaste_interface_var_cell__sTnCHm - d_dt_chaste_interface_var_cell__sTnCL + 3.7242560798480505e-12 * (-var_chaste_interface__cell__sCai + var_chaste_interface__cell__sCasl) / var_cell__Vmyo - var_cell__J_serca * var_cell__Vsr / var_cell__Vmyo; // 1 / ms
        const double var_cell__dss = 1 / (1.0 + exp(-0.83333333333333337 - 0.16666666666666666 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__I_ncx_junc = 0.495 * pow(1.5700000000000001, var_cell__Qpow) * (1.8 * pow(var_chaste_interface__cell__sNaj, 3) * exp(0.010107688547106707 * var_chaste_interface__cell__sVm) - 2744000.0 * var_chaste_interface__cell__sCaj * exp(-0.027328194960695912 * var_chaste_interface__cell__sVm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328194960695912 * var_chaste_interface__cell__sVm)) * (1.0 + 2.2499999999999996e-8 / pow(var_chaste_interface__cell__sCaj, 2)) * (9850.9599999999991 + 2744000.0 * var_chaste_interface__cell__sCaj + 8.4066800865219591 * pow(var_chaste_interface__cell__sNaj, 3) + 669921.875 * (1.0 + 278.55153203342621 * var_chaste_interface__cell__sCaj) * var_chaste_interface__cell__sCaj)); // dimensionless
        const double var_cell__I_ncx_sl = 4.0049999999999999 * pow(1.5700000000000001, var_cell__Qpow) * (1.8 * pow(var_chaste_interface__cell__sNasl, 3) * exp(0.010107688547106707 * var_chaste_interface__cell__sVm) - 2744000.0 * var_chaste_interface__cell__sCasl * exp(-0.027328194960695912 * var_chaste_interface__cell__sVm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328194960695912 * var_chaste_interface__cell__sVm)) * (1.0 + 2.2499999999999996e-8 / pow(var_chaste_interface__cell__sCasl, 2)) * (9850.9599999999991 + 2744000.0 * var_chaste_interface__cell__sCasl + 8.4066800865219591 * pow(var_chaste_interface__cell__sNasl, 3) + 669921.875 * (1.0 + 278.55153203342621 * var_chaste_interface__cell__sCasl) * var_chaste_interface__cell__sCasl)); // dimensionless
        const double d_dt_chaste_interface_var_cell__sfcaBj = -0.011900000000000001 * var_chaste_interface__cell__sfcaBj + 1.7 * (1.0 - var_chaste_interface__cell__sfcaBj) * var_chaste_interface__cell__sCaj; // 1 / ms
        const double var_cell__I_Ca_tot_junc = 6.0643000000000002e-5 * var_chaste_interface__cell__sVm - 2.0 * var_cell__I_ncx_junc - 0.00080995817805876559 * log(1.8 / var_chaste_interface__cell__sCaj) + 0.0074029999999999999 * pow(2.3500000000000001, var_cell__Qpow) * pow(var_chaste_interface__cell__sCaj, 1.6000000000000001) / (5.2281977629563632e-6 + pow(var_chaste_interface__cell__sCaj, 1.6000000000000001)) + 5851.4419768055441 * pow(1.8, var_cell__Qpow) * (-0.61380000000000001 + 0.34100000000000003 * var_chaste_interface__cell__sCaj * exp(0.074871767015605231 * var_chaste_interface__cell__sVm)) * (1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__pCa * var_chaste_interface__cell__sVm * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf / (-1.0 + exp(0.074871767015605231 * var_chaste_interface__cell__sVm)); // dimensionless
        const double d_dt_chaste_interface_var_cell__sCaj = -d_dt_chaste_interface_var_cell__sSLHj - d_dt_chaste_interface_var_cell__sSLLj + 8.2413054227789685e-13 * (-var_chaste_interface__cell__sCaj + var_chaste_interface__cell__sCasl) / var_cell__Vjunc - 7.1565528320464314e-16 * var_cell__I_Ca_tot_junc / var_cell__Vjunc + var_cell__J_SRCarel * var_cell__Vsr / var_cell__Vjunc + var_cell__J_SRleak * var_cell__Vmyo / var_cell__Vjunc; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sfcaBsl = -0.011900000000000001 * var_chaste_interface__cell__sfcaBsl + 1.7 * (1.0 - var_chaste_interface__cell__sfcaBsl) * var_chaste_interface__cell__sCasl; // 1 / ms
        const double var_cell__I_Ca_tot_sl = 0.00049065700000000003 * var_chaste_interface__cell__sVm - 2.0 * var_cell__I_ncx_sl - 0.0065532979861118307 * log(1.8 / var_chaste_interface__cell__sCasl) + 0.059896999999999999 * pow(2.3500000000000001, var_cell__Qpow) * pow(var_chaste_interface__cell__sCasl, 1.6000000000000001) / (5.2281977629563632e-6 + pow(var_chaste_interface__cell__sCasl, 1.6000000000000001)) + 650.16021964506024 * pow(1.8, var_cell__Qpow) * (-0.61380000000000001 + 0.34100000000000003 * var_chaste_interface__cell__sCasl * exp(0.074871767015605231 * var_chaste_interface__cell__sVm)) * (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__pCa * var_chaste_interface__cell__sVm * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf / (-1.0 + exp(0.074871767015605231 * var_chaste_interface__cell__sVm)); // dimensionless
        const double d_dt_chaste_interface_var_cell__sCasl = -d_dt_chaste_interface_var_cell__sSLHsl - d_dt_chaste_interface_var_cell__sSLLsl + 8.2413054227789685e-13 * (-var_chaste_interface__cell__sCasl + var_chaste_interface__cell__sCaj) / var_cell__Vsl + 3.7242560798480505e-12 * (-var_chaste_interface__cell__sCasl + var_chaste_interface__cell__sCai) / var_cell__Vsl - 7.1565528320464314e-16 * var_cell__I_Ca_tot_sl / var_cell__Vsl; // 1 / ms
        const double var_cell__fnak = 1 / (1.0 + 0.1245 * exp(-0.003743588350780262 * var_chaste_interface__cell__sVm) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.037435883507802616 * var_chaste_interface__cell__sVm)); // dimensionless
        const double var_cell__I_nak_junc = 0.15495652173913044 * var_cell__fnak / (1.0 + 14641.0 / pow(var_chaste_interface__cell__sNaj, 4)); // dimensionless
        const double var_cell__I_nak_sl = 1.2537391304347827 * var_cell__fnak / (1.0 + 14641.0 / pow(var_chaste_interface__cell__sNasl, 4)); // dimensionless
        const double var_cell__I_Na_tot_junc = 3.0 * var_cell__I_nak_junc + 3.0 * var_cell__I_ncx_junc + 6.567e-5 * var_chaste_interface__cell__sVm - 6.567e-5 * var_cell__ena_junc + 0.11 * pow(var_chaste_interface__cell__sm, 3) * (-var_cell__ena_junc + var_chaste_interface__cell__sVm) * mParameters[1] * var_chaste_interface__cell__sh * var_chaste_interface__cell__sj + 1462.860494201386 * pow(1.8, var_cell__Qpow) * (-105.0 + 0.75 * var_chaste_interface__cell__sNaj * exp(0.037435883507802616 * var_chaste_interface__cell__sVm)) * (1.0 - var_chaste_interface__cell__sfcaBj + var_cell__fcaCaj) * var_cell__pNa * var_chaste_interface__cell__sVm * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf / (-1.0 + exp(0.037435883507802616 * var_chaste_interface__cell__sVm)); // dimensionless
        const double d_dt_chaste_interface_var_cell__sNaj = -d_dt_chaste_interface_var_cell__sNaBj + 1.8312782322060799e-14 * (-var_chaste_interface__cell__sNaj + var_chaste_interface__cell__sNasl) / var_cell__Vjunc - 1.4313105664092863e-15 * var_cell__I_Na_tot_junc / var_cell__Vjunc; // 1 / ms
        const double var_cell__I_Na_tot_sl = 3.0 * var_cell__I_nak_sl + 3.0 * var_cell__I_ncx_sl + 0.00053133 * var_chaste_interface__cell__sVm - 0.00053133 * var_cell__ena_sl + 0.89000000000000001 * pow(var_chaste_interface__cell__sm, 3) * (-var_cell__ena_sl + var_chaste_interface__cell__sVm) * mParameters[1] * var_chaste_interface__cell__sh * var_chaste_interface__cell__sj + 162.54005491126506 * pow(1.8, var_cell__Qpow) * (-105.0 + 0.75 * var_chaste_interface__cell__sNasl * exp(0.037435883507802616 * var_chaste_interface__cell__sVm)) * (1.0 - var_chaste_interface__cell__sfcaBsl + var_cell__fcaCaMSL) * var_cell__pNa * var_chaste_interface__cell__sVm * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf / (-1.0 + exp(0.037435883507802616 * var_chaste_interface__cell__sVm)); // dimensionless
        const double d_dt_chaste_interface_var_cell__sNasl = -d_dt_chaste_interface_var_cell__sNaBsl + 1.6386279222197945e-12 * (-var_chaste_interface__cell__sNasl + var_chaste_interface__cell__sNai) / var_cell__Vsl + 1.8312782322060799e-14 * (-var_chaste_interface__cell__sNasl + var_chaste_interface__cell__sNaj) / var_cell__Vsl - 1.4313105664092863e-15 * var_cell__I_Na_tot_sl / var_cell__Vsl; // 1 / ms
        const double d_dt_chaste_interface_var_cell__sd = 0.035000000000000003 * (5.0 + var_chaste_interface__cell__sVm) * (-var_chaste_interface__cell__sd + var_cell__dss) / ((1.0 - exp(-0.83333333333333337 - 0.16666666666666666 * var_chaste_interface__cell__sVm)) * var_cell__dss); // 1 / ms
        const double d_dt_chaste_interface_var_cell__sf = (0.02 + 0.019699999999999999 * exp(-0.23877882250000002 * pow((1 + 0.068965517241379309 * var_chaste_interface__cell__sVm), 2))) * (-var_chaste_interface__cell__sf + 1 / (1.0 + exp(3.8888888888888888 + 0.1111111111111111 * var_chaste_interface__cell__sVm)) + 0.59999999999999998 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__cell__sVm))); // 1 / ms
        const double d_dt_chaste_interface_var_cell__sh = (-var_chaste_interface__cell__sh + 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__cell__sVm)), 2)) * (((var_chaste_interface__cell__sVm >= -40.0) ? (0) : (0.057000000000000002 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__sVm))) + ((var_chaste_interface__cell__sVm >= -40.0) ? (5.9230769230769234 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__sVm))) : (310000.0 * exp(0.34849999999999998 * var_chaste_interface__cell__sVm) + 2.7000000000000002 * exp(0.079000000000000001 * var_chaste_interface__cell__sVm)))); // 1 / ms
        const double d_dt_chaste_interface_var_cell__sj = (-var_chaste_interface__cell__sj + 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__cell__sVm)), 2)) * (((var_chaste_interface__cell__sVm >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__cell__sVm) * (-25428.0 * exp(0.24440000000000001 * var_chaste_interface__cell__sVm) - 6.9480000000000002e-6 * exp(-0.043909999999999998 * var_chaste_interface__cell__sVm)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__sVm)))) + ((var_chaste_interface__cell__sVm >= -40.0) ? (0.59999999999999998 * exp(0.057000000000000002 * var_chaste_interface__cell__sVm) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__sVm))) : (0.024240000000000001 * exp(-0.01052 * var_chaste_interface__cell__sVm) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__sVm))))); // 1 / ms
        const double d_dt_chaste_interface_var_cell__sm = (-var_chaste_interface__cell__sm + 1 / pow((1.0 + exp(-6.2967884828349945 - 0.11074197120708749 * var_chaste_interface__cell__sVm)), 2)) / (0.12920000000000001 * exp(-8.682389366752302 * pow((1 + 0.021838829438742085 * var_chaste_interface__cell__sVm), 2)) + 0.064869999999999997 * exp(-0.0089012876052174655 * pow((-1 + 0.2073398299813394 * var_chaste_interface__cell__sVm), 2))); // 1 / ms
        const double d_dt_chaste_interface_var_cell__sxkr = (-var_chaste_interface__cell__sxkr + 1 / (1.0 + exp(-2.0 - 0.20000000000000001 * var_chaste_interface__cell__sVm))) / (230.0 / (1.0 + exp(2.0 + 0.050000000000000003 * var_chaste_interface__cell__sVm)) + 3300.0 / ((1.0 + exp(1.2222222222222223 + 0.1111111111111111 * var_chaste_interface__cell__sVm)) * (1.0 + exp(-2.4444444444444446 - 0.1111111111111111 * var_chaste_interface__cell__sVm)))); // 1 / ms
        const double d_dt_chaste_interface_var_cell__sxks = (0.00100999899000101 + 0.00100999899000101 * exp(-0.17252124645892353 - 0.070821529745042494 * var_chaste_interface__cell__sVm)) * (-var_chaste_interface__cell__sxks + 1 / (1.0 + exp(-0.26666666666666666 - 0.070175438596491224 * var_chaste_interface__cell__sVm))); // 1 / ms
        const double var_cell__xtoss = 1 / (1.0 + exp(1.4615384615384615 - 0.076923076923076927 * var_chaste_interface__cell__sVm)); // dimensionless
        const double d_dt_chaste_interface_var_cell__sxtof = (-var_chaste_interface__cell__sxtof + var_cell__xtoss) / (0.5 + 8.5 * exp(-0.81000000000000005 * pow((1 + 0.022222222222222223 * var_chaste_interface__cell__sVm), 2))); // 1 / ms
        const double d_dt_chaste_interface_var_cell__sxtos = (-var_chaste_interface__cell__sxtos + var_cell__xtoss) / (0.5 + 9.0 / (1.0 + exp(0.20000000000000001 + 0.066666666666666666 * var_chaste_interface__cell__sVm))); // 1 / ms
        const double var_cell__ytoss = 1 / (1.0 + exp(3.8999999999999999 + 0.20000000000000001 * var_chaste_interface__cell__sVm)); // dimensionless
        const double d_dt_chaste_interface_var_cell__sytof = (-var_chaste_interface__cell__sytof + var_cell__ytoss) / (7.0 + 85.0 * exp(-7.2727272727272725 * pow((1 + 0.025000000000000001 * var_chaste_interface__cell__sVm), 2))); // 1 / ms
        const double d_dt_chaste_interface_var_cell__sytos = (-var_chaste_interface__cell__sytos + var_cell__ytoss) / (30.0 + 800.0 / (1.0 + exp(6.0 + 0.10000000000000001 * var_chaste_interface__cell__sVm))); // 1 / ms

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_cell__sVm = 0.0;
        }
        else
        {
            const double var_cell__eks = 26.712338705498265 * log(7.9662000000000006 / (120.0 + 0.018329999999999999 * var_chaste_interface__cell__sNai)); // dimensionless
            const double var_cell__kp_kp = 1 / (1.0 + exp(7.4880000000000004 - 0.16722408026755853 * var_chaste_interface__cell__sVm)); // dimensionless
            d_dt_chaste_interface_var_cell__sVm = -0.5535668961205934 - var_cell__I_Ca_tot_junc - var_cell__I_Ca_tot_sl - var_cell__I_Na_tot_junc - var_cell__I_Na_tot_sl + 2.0 * var_cell__I_nak_junc + 2.0 * var_cell__I_nak_sl - 0.0089999999999999993 * var_chaste_interface__cell__sVm - GetIntracellularAreaStimulus(var_chaste_interface__cell__time) / HeartConfig::Instance()->GetCapacitance() - 0.002 * (82.837440942604388 + var_chaste_interface__cell__sVm) * var_cell__kp_kp - 0.0035000000000000001 * pow(var_chaste_interface__cell__sxks, 2) * (-var_cell__eks + var_chaste_interface__cell__sVm) - 0.006029375 * (61.507432902288166 + var_chaste_interface__cell__sVm) / (1.0 + 0.10000000000000001 / var_chaste_interface__cell__sCaj) - 0.048783124999999997 * (61.507432902288166 + var_chaste_interface__cell__sVm) / (1.0 + 0.10000000000000001 / var_chaste_interface__cell__sCasl) - 0.1144 * (82.837440942604388 + var_chaste_interface__cell__sVm) * var_chaste_interface__cell__sxtof * var_chaste_interface__cell__sytof - 0.015599999999999999 * (82.837440942604388 + var_chaste_interface__cell__sVm) * var_chaste_interface__cell__sxtos * var_chaste_interface__cell__sytos - 0.35699999999999998 * (82.837440942604388 + var_chaste_interface__cell__sVm) / ((1.0 + exp(5.6339521648111468 + 0.23849999999999999 * var_chaste_interface__cell__sVm)) * (1.02 / (1.0 + exp(5.6339521648111468 + 0.23849999999999999 * var_chaste_interface__cell__sVm)) + (0.49124000000000001 * exp(7.0933355765099853 + 0.080320000000000003 * var_chaste_interface__cell__sVm) + exp(-31.583430521794174 + 0.061749999999999999 * var_chaste_interface__cell__sVm)) / (1.0 + exp(-45.047763776781437 - 0.51429999999999998 * var_chaste_interface__cell__sVm)))) - 0.035000000000000003 * (82.837440942604388 + var_chaste_interface__cell__sVm) * mParameters[2] * var_chaste_interface__cell__sxkr / (1.0 + exp(3.0833333333333335 + 0.041666666666666664 * var_chaste_interface__cell__sVm)) - 0.0002194290741302079 * pow(1.8, var_cell__Qpow) * (-4.0500000000000007 + 90.0 * exp(0.037435883507802616 * var_chaste_interface__cell__sVm)) * (1.0 + 0.099999999999999978 * var_cell__fcaCaMSL + 0.90000000000000002 * var_cell__fcaCaj - 0.099999999999999978 * var_chaste_interface__cell__sfcaBsl - 0.90000000000000002 * var_chaste_interface__cell__sfcaBj) * mParameters[0] * var_chaste_interface__cell__sVm * var_chaste_interface__cell__sd * var_chaste_interface__cell__sf / (-1.0 + exp(0.037435883507802616 * var_chaste_interface__cell__sVm)); // millivolt / ms
        }
        
        rDY[0] = d_dt_chaste_interface_var_cell__sVm;
        rDY[1] = d_dt_chaste_interface_var_cell__sm;
        rDY[2] = d_dt_chaste_interface_var_cell__sh;
        rDY[3] = d_dt_chaste_interface_var_cell__sj;
        rDY[4] = d_dt_chaste_interface_var_cell__sd;
        rDY[5] = d_dt_chaste_interface_var_cell__sf;
        rDY[6] = d_dt_chaste_interface_var_cell__sfcaBj;
        rDY[7] = d_dt_chaste_interface_var_cell__sfcaBsl;
        rDY[8] = d_dt_chaste_interface_var_cell__sxtos;
        rDY[9] = d_dt_chaste_interface_var_cell__sytos;
        rDY[10] = d_dt_chaste_interface_var_cell__sxtof;
        rDY[11] = d_dt_chaste_interface_var_cell__sytof;
        rDY[12] = d_dt_chaste_interface_var_cell__sxkr;
        rDY[13] = d_dt_chaste_interface_var_cell__sxks;
        rDY[14] = d_dt_chaste_interface_var_cell__sRyRr;
        rDY[15] = d_dt_chaste_interface_var_cell__sRyRo;
        rDY[16] = d_dt_chaste_interface_var_cell__sRyRi;
        rDY[17] = d_dt_chaste_interface_var_cell__sNaBj;
        rDY[18] = d_dt_chaste_interface_var_cell__sNaBsl;
        rDY[19] = d_dt_chaste_interface_var_cell__sTnCL;
        rDY[20] = d_dt_chaste_interface_var_cell__sTnCHc;
        rDY[21] = d_dt_chaste_interface_var_cell__sTnCHm;
        rDY[22] = d_dt_chaste_interface_var_cell__sCaM;
        rDY[23] = d_dt_chaste_interface_var_cell__sMyoc;
        rDY[24] = d_dt_chaste_interface_var_cell__sMyom;
        rDY[25] = d_dt_chaste_interface_var_cell__sSRB;
        rDY[26] = d_dt_chaste_interface_var_cell__sSLLj;
        rDY[27] = d_dt_chaste_interface_var_cell__sSLLsl;
        rDY[28] = d_dt_chaste_interface_var_cell__sSLHj;
        rDY[29] = d_dt_chaste_interface_var_cell__sSLHsl;
        rDY[30] = d_dt_chaste_interface_var_cell__sCsqnb;
        rDY[31] = d_dt_chaste_interface_var_cell__sCa_sr;
        rDY[32] = d_dt_chaste_interface_var_cell__sNaj;
        rDY[33] = d_dt_chaste_interface_var_cell__sNasl;
        rDY[34] = d_dt_chaste_interface_var_cell__sNai;
        rDY[35] = d_dt_chaste_interface_var_cell__sCaj;
        rDY[36] = d_dt_chaste_interface_var_cell__sCasl;
        rDY[37] = d_dt_chaste_interface_var_cell__sCai;
    }

    std::vector<double> Cellgrandi2010ssFromCellMLOpt::ComputeDerivedQuantities(double var_chaste_interface__cell__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__cell__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__cell__time;
        dqs[1] = var_cell__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellgrandi2010ssFromCellMLOpt>::Initialise(void)
{
    this->mSystemName = "grandi2010";
    this->mFreeVariableName = "cell__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-81.3842590704928);

    // rY[1]:
    this->mVariableNames.push_back("cell__sm");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00384941567866232);

    // rY[2]:
    this->mVariableNames.push_back("cell__sh");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.623723834301669);

    // rY[3]:
    this->mVariableNames.push_back("cell__sj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.622080736932815);

    // rY[4]:
    this->mVariableNames.push_back("cell__sd");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.95884913218079e-06);

    // rY[5]:
    this->mVariableNames.push_back("cell__sf");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.995094078386247);

    // rY[6]:
    this->mVariableNames.push_back("cell__sfcaBj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0246274349529557);

    // rY[7]:
    this->mVariableNames.push_back("cell__sfcaBsl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0150911724206476);

    // rY[8]:
    this->mVariableNames.push_back("cell__sxtos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000442853722673121);

    // rY[9]:
    this->mVariableNames.push_back("cell__sytos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.789013894749951);

    // rY[10]:
    this->mVariableNames.push_back("cell__sxtof");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000442846429332686);

    // rY[11]:
    this->mVariableNames.push_back("cell__sytof");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999995784674368);

    // rY[12]:
    this->mVariableNames.push_back("cell__sxkr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.020160578118589);

    // rY[13]:
    this->mVariableNames.push_back("cell__sxks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00430143235332308);

    // rY[14]:
    this->mVariableNames.push_back("cell__sRyRr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.893326456705696);

    // rY[15]:
    this->mVariableNames.push_back("cell__sRyRo");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.56436968249499e-07);

    // rY[16]:
    this->mVariableNames.push_back("cell__sRyRi");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.03266331737064e-08);

    // rY[17]:
    this->mVariableNames.push_back("cell__sNaBj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.41097946062695);

    // rY[18]:
    this->mVariableNames.push_back("cell__sNaBsl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.744248540671373);

    // rY[19]:
    this->mVariableNames.push_back("cell__sTnCL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00904644567707666);

    // rY[20]:
    this->mVariableNames.push_back("cell__sTnCHc");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1183943202639);

    // rY[21]:
    this->mVariableNames.push_back("cell__sTnCHm");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0101423649465603);

    // rY[22]:
    this->mVariableNames.push_back("cell__sCaM");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000299824763475116);

    // rY[23]:
    this->mVariableNames.push_back("cell__sMyoc");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00201443980536826);

    // rY[24]:
    this->mVariableNames.push_back("cell__sMyom");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.137467597337588);

    // rY[25]:
    this->mVariableNames.push_back("cell__sSRB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00220110816535249);

    // rY[26]:
    this->mVariableNames.push_back("cell__sSLLj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00739549938515031);

    // rY[27]:
    this->mVariableNames.push_back("cell__sSLLsl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00979616077807075);

    // rY[28]:
    this->mVariableNames.push_back("cell__sSLHj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0735225248399363);

    // rY[29]:
    this->mVariableNames.push_back("cell__sSLHsl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.113642236788144);

    // rY[30]:
    this->mVariableNames.push_back("cell__sCsqnb");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.20762712858574);

    // rY[31]:
    this->mVariableNames.push_back("cell__sCa_sr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.563755421404699);

    // rY[32]:
    this->mVariableNames.push_back("cell__sNaj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.21411036389602);

    // rY[33]:
    this->mVariableNames.push_back("cell__sNasl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.21322794157889);

    // rY[34]:
    this->mVariableNames.push_back("cell__sNai");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.21340895351653);

    // rY[35]:
    this->mVariableNames.push_back("cell__sCaj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000175648385857736);

    // rY[36]:
    this->mVariableNames.push_back("cell__sCasl");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000105614570409386);

    // rY[37]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.85230799863012e-05);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("cell__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellgrandi2010ssFromCellMLOpt)
