//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: pandit_model_2001_epi
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "pandit_model_2001_epi.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellpandit_model_2001_epiFromCellML::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.00059999999999999995 * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 5.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellpandit_model_2001_epiFromCellML::Cellpandit_model_2001_epiFromCellML(boost::shared_ptr<AbstractIvpOdeSolver> pSolver, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCardiacCell(
                pSolver,
                26,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellpandit_model_2001_epiFromCellML>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 0.0001; // (var_membrane__Cm) [microF]
    }

    Cellpandit_model_2001_epiFromCellML::~Cellpandit_model_2001_epiFromCellML()
    {
    }
    
    double Cellpandit_model_2001_epiFromCellML::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.50146
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.004164108
        double var_chaste_interface__sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.6735613
        double var_chaste_interface__sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.6729362
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 2.171081e-06
        double var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 = rY[5];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 = rY[6];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact = rY[7];
        // Units: dimensionless; Initial value: 0.9913102
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.002191519
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.9842542
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = rY[10];
        // Units: dimensionless; Initial value: 0.6421196
        double var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss = rY[11];
        // Units: dimensionless; Initial value: 0.002907171
        double var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss = rY[12];
        // Units: dimensionless; Initial value: 0.3142767
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[13];
        // Units: dimensionless; Initial value: 0.003578708
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[20];
        // Units: millimolar; Initial value: 10.73519
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[21];
        // Units: millimolar; Initial value: 7.901351e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[22];
        // Units: millimolar; Initial value: 139.2751
        
        const double var_Ca_independent_transient_outward_K_current__a = 0.88600000000000001; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__b = 0.114; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__g_t = 0.035000000000000003; // microS
        const double var_L_type_Ca_channel__E_Ca_L = 65.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.031; // microS
        const double var_Na_Ca_ion_exchanger_current__K_NaCa = 9.9839999999999996e-6; // nanoA_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.0001; // millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma_NaCa = 0.5; // dimensionless
        const double var_background_currents__g_B_Ca = 3.2400000000000001e-5; // microS
        const double var_background_currents__g_B_K = 0.00013799999999999999; // microS
        const double var_background_currents__g_B_Na = 8.0149999999999997e-5; // microS
        const double var_hyperpolarisation_activated_current__f_Na = 0.20000000000000001; // dimensionless
        const double var_hyperpolarisation_activated_current__f_K = 1.0 - var_hyperpolarisation_activated_current__f_Na; // dimensionless
        const double var_hyperpolarisation_activated_current__g_f = 0.0014499999999999999; // microS
        const double var_inward_rectifier__g_K1 = 0.024; // microS
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.5; // millijoule_per_mole_kelvin
        const double var_membrane__T = 295.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * ((0.10000000000000001 - 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + (0.90000000000000002 + 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d; // nanoA
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P_max = 0.0040000000000000001; // nanoA
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_Ca_P_max / (0.00040000000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // nanoA
        const double var_sodium_current__g_Na = 0.80000000000000004; // microS
        const double var_sodium_potassium_pump__K_m_K = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 10.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.080000000000000002; // nanoA
        const double var_standard_ionic_concentrations__Ca_o = 1.2; // millimolar
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Ca_o / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // nanoA
        const double var_standard_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__K_o / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (var_Ca_independent_transient_outward_K_current__a * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + var_Ca_independent_transient_outward_K_current__b * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r; // nanoA
        const double var_background_currents__i_B_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_background_currents__g_B_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_K * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_inward_rectifier__i_K1 = 0.0001 * (10.0 + 48.0 / (exp(1.48 + 0.040000000000000001 * var_chaste_interface__membrane__V) + exp(-1.48 - 0.040000000000000001 * var_chaste_interface__membrane__V))) / (1.0 + exp(4.5158823529411762 + 0.058823529411764705 * var_Ca_independent_transient_outward_K_current__E_K - 0.058823529411764705 * var_chaste_interface__membrane__V)) + (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp(1.613 * (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (1.0 + exp(8.0548387096774192 - 8.064516129032258 * var_standard_ionic_concentrations__K_o))); // nanoA
        const double var_standard_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_Na_Ca_ion_exchanger_current__gamma_NaCa * var_chaste_interface__membrane__V) - pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_Na_Ca_ion_exchanger_current__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_Na_Ca_ion_exchanger_current__K_NaCa / (1.0 + (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o + pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i) * var_Na_Ca_ion_exchanger_current__d_NaCa); // nanoA
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Na_o / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // nanoA
        const double var_background_currents__i_B = var_background_currents__i_B_Ca + var_background_currents__i_B_K + var_background_currents__i_B_Na; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_Na * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_hyperpolarisation_activated_current__i_f = var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na; // nanoA
        const double var_sodium_current__i_Na = pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_current__g_Na * var_chaste_interface__sodium_current_h_gate__h * var_chaste_interface__sodium_current_j_gate__j; // nanoA
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_standard_ionic_concentrations__Na_o); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_sodium_potassium_pump__i_NaK_max * var_standard_ionic_concentrations__K_o / ((1.0 + pow((var_sodium_potassium_pump__K_m_Na / var_chaste_interface__intracellular_ion_concentrations__Na_i), 1.5)) * (var_sodium_potassium_pump__K_m_K + var_standard_ionic_concentrations__K_o) * (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // nanoA
        const double var_steady_state_outward_K_current__g_ss = 0.0070000000000000001; // microS
        const double var_steady_state_outward_K_current__i_ss = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_steady_state_outward_K_current__g_ss * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss; // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_Ca_independent_transient_outward_K_current__i_t + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B + var_hyperpolarisation_activated_current__i_f + var_inward_rectifier__i_K1 + var_sarcolemmal_calcium_pump_current__i_Ca_P + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_steady_state_outward_K_current__i_ss) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellpandit_model_2001_epiFromCellML::EvaluateYDerivatives(double var_chaste_interface__environment__time_converted, const std::vector<double>& rY, std::vector<double>& rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.50146
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.004164108
        double var_chaste_interface__sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.6735613
        double var_chaste_interface__sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.6729362
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 2.171081e-06
        double var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 = rY[5];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 = rY[6];
        // Units: dimensionless; Initial value: 0.9999529
        double var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact = rY[7];
        // Units: dimensionless; Initial value: 0.9913102
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.002191519
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.9842542
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = rY[10];
        // Units: dimensionless; Initial value: 0.6421196
        double var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss = rY[11];
        // Units: dimensionless; Initial value: 0.002907171
        double var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss = rY[12];
        // Units: dimensionless; Initial value: 0.3142767
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[13];
        // Units: dimensionless; Initial value: 0.003578708
        double var_chaste_interface__SR_Ca_release_channel__P_O1 = rY[14];
        // Units: dimensionless; Initial value: 0.0004327548
        double var_chaste_interface__SR_Ca_release_channel__P_O2 = rY[15];
        // Units: dimensionless; Initial value: 6.06254e-10
        double var_chaste_interface__SR_Ca_release_channel__P_C1 = rY[16];
        // Units: dimensionless; Initial value: 0.6348229
        double var_chaste_interface__SR_Ca_release_channel__P_C2 = rY[17];
        // Units: dimensionless; Initial value: 0.3647471
        double var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa = rY[18];
        // Units: millimolar; Initial value: 0.1394301
        double var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa = rY[19];
        // Units: millimolar; Initial value: 0.0051619
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[20];
        // Units: millimolar; Initial value: 10.73519
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[21];
        // Units: millimolar; Initial value: 7.901351e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[22];
        // Units: millimolar; Initial value: 139.2751
        double var_chaste_interface__intracellular_ion_concentrations__Ca_ss = rY[23];
        // Units: millimolar; Initial value: 8.737212e-05
        double var_chaste_interface__intracellular_ion_concentrations__Ca_JSR = rY[24];
        // Units: millimolar; Initial value: 0.06607948
        double var_chaste_interface__intracellular_ion_concentrations__Ca_NSR = rY[25];
        // Units: millimolar; Initial value: 0.06600742

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_Ca_independent_transient_outward_K_current__a = 0.88600000000000001; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__b = 0.114; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__g_t = 0.035000000000000003; // microS
        const double var_L_type_Ca_channel__E_Ca_L = 65.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.031; // microS
        const double var_L_type_Ca_channel_Ca_inact_gate__tau_Ca_inact = 0.0089999999999999993; // second
        const double var_Na_Ca_ion_exchanger_current__K_NaCa = 9.9839999999999996e-6; // nanoA_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.0001; // millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma_NaCa = 0.5; // dimensionless
        const double var_SERCA2a_pump__K_SR = 1.0; // dimensionless
        const double var_SERCA2a_pump__K_fb = 0.00016799999999999999; // millimolar
        const double var_SERCA2a_pump__K_rb = 3.29; // millimolar
        const double var_SERCA2a_pump__N_fb = 1.2; // dimensionless
        const double var_SERCA2a_pump__N_rb = 1.0; // dimensionless
        const double var_SERCA2a_pump__Vmaxf = 0.040000000000000001; // millimolar_per_second
        const double var_SERCA2a_pump__Vmaxr = 0.90000000000000002; // millimolar_per_second
        const double var_SR_Ca_release_channel__k_a_minus = 576.0; // per_second
        const double var_SR_Ca_release_channel__k_a_plus = 12150000000000.0; // per_second
        const double var_SR_Ca_release_channel__k_b_minus = 1930.0; // per_second
        const double var_SR_Ca_release_channel__k_b_plus = 4050000000.0; // per_second
        const double var_SR_Ca_release_channel__k_c_minus = 0.80000000000000004; // per_second
        const double var_SR_Ca_release_channel__k_c_plus = 100.0; // per_second
        const double var_SR_Ca_release_channel__P_C2_orig_deriv = var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_c_plus - var_chaste_interface__SR_Ca_release_channel__P_C2 * var_SR_Ca_release_channel__k_c_minus; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_C2 = 0.001 * var_SR_Ca_release_channel__P_C2_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_release_channel__m = 3.0; // dimensionless
        const double var_SR_Ca_release_channel__n = 4.0; // dimensionless
        const double var_SR_Ca_release_channel__v1 = 1800.0; // per_second
        const double var_background_currents__g_B_Ca = 3.2400000000000001e-5; // microS
        const double var_background_currents__g_B_K = 0.00013799999999999999; // microS
        const double var_background_currents__g_B_Na = 8.0149999999999997e-5; // microS
        const double var_hyperpolarisation_activated_current__f_Na = 0.20000000000000001; // dimensionless
        const double var_hyperpolarisation_activated_current__f_K = 1.0 - var_hyperpolarisation_activated_current__f_Na; // dimensionless
        const double var_hyperpolarisation_activated_current__g_f = 0.0014499999999999999; // microS
        const double var_intracellular_and_SR_Ca_fluxes__HTRPN_tot = 0.14000000000000001; // millimolar
        const double var_intracellular_and_SR_Ca_fluxes__LTRPN_tot = 0.070000000000000007; // millimolar
        const double var_intracellular_and_SR_Ca_fluxes__k_htrpn_minus = 0.066000000000000003; // per_second
        const double var_intracellular_and_SR_Ca_fluxes__k_htrpn_plus = 200000.0; // per_millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__k_ltrpn_minus = 40.0; // per_second
        const double var_intracellular_and_SR_Ca_fluxes__k_ltrpn_plus = 40000.0; // per_millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__tau_tr = 0.00057470000000000004; // second
        const double var_intracellular_and_SR_Ca_fluxes__tau_xfer = 0.026700000000000002; // second
        const double var_intracellular_ion_concentrations__CMDN_tot = 0.050000000000000003; // millimolar
        const double var_intracellular_ion_concentrations__CSQN_tot = 15.0; // millimolar
        const double var_SERCA2a_pump__rb = pow((var_chaste_interface__intracellular_ion_concentrations__Ca_NSR / var_SERCA2a_pump__K_rb), var_SERCA2a_pump__N_rb); // dimensionless
        const double var_intracellular_and_SR_Ca_fluxes__J_tr = (-var_chaste_interface__intracellular_ion_concentrations__Ca_JSR + var_chaste_interface__intracellular_ion_concentrations__Ca_NSR) / var_intracellular_and_SR_Ca_fluxes__tau_tr; // millimolar_per_second
        const double var_SERCA2a_pump__fb = pow((var_chaste_interface__intracellular_ion_concentrations__Ca_i / var_SERCA2a_pump__K_fb), var_SERCA2a_pump__N_fb); // dimensionless
        const double var_SERCA2a_pump__J_up = (var_SERCA2a_pump__Vmaxf * var_SERCA2a_pump__fb - var_SERCA2a_pump__Vmaxr * var_SERCA2a_pump__rb) * var_SERCA2a_pump__K_SR / (1.0 + var_SERCA2a_pump__fb + var_SERCA2a_pump__rb); // millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__HTRPNCa_orig_deriv = -var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa * var_intracellular_and_SR_Ca_fluxes__k_htrpn_minus + (-var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa + var_intracellular_and_SR_Ca_fluxes__HTRPN_tot) * var_intracellular_and_SR_Ca_fluxes__k_htrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__HTRPNCa = 0.001 * var_intracellular_and_SR_Ca_fluxes__HTRPNCa_orig_deriv; // millimolar / millisecond
        const double var_intracellular_and_SR_Ca_fluxes__J_HTRPNCa = -var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa * var_intracellular_and_SR_Ca_fluxes__k_htrpn_minus + (-var_chaste_interface__intracellular_and_SR_Ca_fluxes__HTRPNCa + var_intracellular_and_SR_Ca_fluxes__HTRPN_tot) * var_intracellular_and_SR_Ca_fluxes__k_htrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__J_LTRPNCa = -var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa * var_intracellular_and_SR_Ca_fluxes__k_ltrpn_minus + (-var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa + var_intracellular_and_SR_Ca_fluxes__LTRPN_tot) * var_intracellular_and_SR_Ca_fluxes__k_ltrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__J_trpn = var_intracellular_and_SR_Ca_fluxes__J_HTRPNCa + var_intracellular_and_SR_Ca_fluxes__J_LTRPNCa; // millimolar_per_second
        const double var_intracellular_and_SR_Ca_fluxes__LTRPNCa_orig_deriv = -var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa * var_intracellular_and_SR_Ca_fluxes__k_ltrpn_minus + (-var_chaste_interface__intracellular_and_SR_Ca_fluxes__LTRPNCa + var_intracellular_and_SR_Ca_fluxes__LTRPN_tot) * var_intracellular_and_SR_Ca_fluxes__k_ltrpn_plus * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__LTRPNCa = 0.001 * var_intracellular_and_SR_Ca_fluxes__LTRPNCa_orig_deriv; // millimolar / millisecond
        const double var_L_type_Ca_channel_Ca_inact_gate__Ca_inact_infinity = 1 / (1.0 + 100.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_ss); // dimensionless
        const double var_L_type_Ca_channel_Ca_inact_gate__Ca_inact_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact + var_L_type_Ca_channel_Ca_inact_gate__Ca_inact_infinity) / var_L_type_Ca_channel_Ca_inact_gate__tau_Ca_inact; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_inact_gate__Ca_inact = 0.001 * var_L_type_Ca_channel_Ca_inact_gate__Ca_inact_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_release_channel__J_rel = (-var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_chaste_interface__intracellular_ion_concentrations__Ca_JSR) * (var_chaste_interface__SR_Ca_release_channel__P_O1 + var_chaste_interface__SR_Ca_release_channel__P_O2) * var_SR_Ca_release_channel__v1; // millimolar_per_second
        const double var_SR_Ca_release_channel__P_C1_orig_deriv = var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_a_minus - pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss), var_SR_Ca_release_channel__n) * var_chaste_interface__SR_Ca_release_channel__P_C1 * var_SR_Ca_release_channel__k_a_plus; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_C1 = 0.001 * var_SR_Ca_release_channel__P_C1_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_release_channel__P_O1_orig_deriv = var_chaste_interface__SR_Ca_release_channel__P_C2 * var_SR_Ca_release_channel__k_c_minus + var_chaste_interface__SR_Ca_release_channel__P_O2 * var_SR_Ca_release_channel__k_b_minus - var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_a_minus - var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_c_plus + pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss), var_SR_Ca_release_channel__n) * var_chaste_interface__SR_Ca_release_channel__P_C1 * var_SR_Ca_release_channel__k_a_plus - pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss), var_SR_Ca_release_channel__m) * var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_b_plus; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_O1 = 0.001 * var_SR_Ca_release_channel__P_O1_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_release_channel__P_O2_orig_deriv = -var_chaste_interface__SR_Ca_release_channel__P_O2 * var_SR_Ca_release_channel__k_b_minus + pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss), var_SR_Ca_release_channel__m) * var_chaste_interface__SR_Ca_release_channel__P_O1 * var_SR_Ca_release_channel__k_b_plus; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_release_channel__P_O2 = 0.001 * var_SR_Ca_release_channel__P_O2_orig_deriv; // 1 / millisecond
        const double var_intracellular_and_SR_Ca_fluxes__J_xfer = (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__intracellular_ion_concentrations__Ca_ss) / var_intracellular_and_SR_Ca_fluxes__tau_xfer; // millimolar_per_second
        const double var_intracellular_ion_concentrations__EGTA_tot = 10.0; // millimolar
        const double var_intracellular_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_intracellular_ion_concentrations__K_mCSQN = 0.80000000000000004; // millimolar
        const double var_intracellular_ion_concentrations__K_mEGTA = 0.00014999999999999999; // millimolar
        const double var_intracellular_ion_concentrations__V_JSR = 5.6000000000000004e-7; // micro_litre
        const double var_intracellular_ion_concentrations__V_NSR = 5.04e-6; // micro_litre
        const double var_intracellular_ion_concentrations__V_SS = 1.2e-8; // micro_litre
        const double var_intracellular_ion_concentrations__V_myo = 9.3600000000000002e-6; // micro_litre
        const double var_intracellular_ion_concentrations__Ca_NSR_orig_deriv = var_SERCA2a_pump__J_up * var_intracellular_ion_concentrations__V_myo / var_intracellular_ion_concentrations__V_NSR - var_intracellular_and_SR_Ca_fluxes__J_tr * var_intracellular_ion_concentrations__V_JSR / var_intracellular_ion_concentrations__V_NSR; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_NSR = 0.001 * var_intracellular_ion_concentrations__Ca_NSR_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__beta_JSR = 1 / (1.0 + var_intracellular_ion_concentrations__CSQN_tot * var_intracellular_ion_concentrations__K_mCSQN / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_JSR + var_intracellular_ion_concentrations__K_mCSQN), 2)); // dimensionless
        const double var_intracellular_ion_concentrations__Ca_JSR_orig_deriv = (-var_SR_Ca_release_channel__J_rel + var_intracellular_and_SR_Ca_fluxes__J_tr) * var_intracellular_ion_concentrations__beta_JSR; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_JSR = 0.001 * var_intracellular_ion_concentrations__Ca_JSR_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__beta_SS = 1 / (1.0 + var_intracellular_ion_concentrations__CMDN_tot * var_intracellular_ion_concentrations__K_mCMDN / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_ss + var_intracellular_ion_concentrations__K_mCMDN), 2)); // dimensionless
        const double var_intracellular_ion_concentrations__beta_i = 1 / (1.0 + var_intracellular_ion_concentrations__CMDN_tot * var_intracellular_ion_concentrations__K_mCMDN / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_intracellular_ion_concentrations__K_mCMDN), 2) + var_intracellular_ion_concentrations__EGTA_tot * var_intracellular_ion_concentrations__K_mEGTA / pow((var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_intracellular_ion_concentrations__K_mEGTA), 2)); // dimensionless
        const double var_inward_rectifier__g_K1 = 0.024; // microS
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.5; // millijoule_per_mole_kelvin
        const double var_membrane__T = 295.0; // kelvin
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_infinity = 1 / (1.0 + exp(-0.92819614711033271 - 0.087565674255691769 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_r_gate__tau_r = 1 / (45.159999999999997 * exp(1.7885000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V) + 98.900000000000006 * exp(-3.8000000000000003 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // second
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r + var_Ca_independent_transient_outward_K_current_r_gate__r_infinity) / var_Ca_independent_transient_outward_K_current_r_gate__tau_r; // 1 / second
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_infinity = 1 / (1.0 + exp(6.5803808776746413 + 0.14526227103034528 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s_gate__tau_s = 0.035000000000000003 + 0.34999999999999998 * exp(-21.777777777777779 * pow((1 + 0.014285714285714285 * var_chaste_interface__membrane__V), 2)); // second
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + var_Ca_independent_transient_outward_K_current_s_gate__s_infinity) / var_Ca_independent_transient_outward_K_current_s_gate__tau_s; // 1 / second
        const double var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow_infinity = 1 / (1.0 + exp(6.5803808776746413 + 0.14526227103034528 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s_slow_gate__tau_s_slow = 0.035000000000000003 + 3.7000000000000002 * exp(-5.4444444444444446 * pow((1 + 0.014285714285714285 * var_chaste_interface__membrane__V), 2)); // second
        const double var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow + var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow_infinity) / var_Ca_independent_transient_outward_K_current_s_slow_gate__tau_s_slow; // 1 / second
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r = 0.001 * var_Ca_independent_transient_outward_K_current_r_gate__r_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_gate__s = 0.001 * var_Ca_independent_transient_outward_K_current_s_gate__s_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow = 0.001 * var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * ((0.10000000000000001 - 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + (0.90000000000000002 + 0.10000000000000001 * var_chaste_interface__L_type_Ca_channel_Ca_inact_gate__Ca_inact) * var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d; // nanoA
        const double var_L_type_Ca_channel_d_gate__d_infinity = 1 / (1.0 + exp(-3.0600000000000001 - 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_d_gate__tau_d = 0.00025000000000000001 + 0.0010499999999999999 * exp(-0.64800000000000002 * pow((-1 + 0.055555555555555552 * var_chaste_interface__membrane__V), 2)) + 0.0030500000000000002 * exp(-0.22049999999999997 * pow((1 + 0.14285714285714285 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_d_gate__d_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_d_gate__d + var_L_type_Ca_channel_d_gate__d_infinity) / var_L_type_Ca_channel_d_gate__tau_d; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d = 0.001 * var_L_type_Ca_channel_d_gate__d_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_11_gate__f_11_infinity = 1 / (1.0 + exp(4.9444444444444438 + 0.18518518518518517 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_11_gate__tau_f_11 = 0.0016999999999999999 + 0.014999999999999999 / (1.0 + exp(3.0 + 0.040000000000000001 * var_chaste_interface__membrane__V)) + 0.040000000000000001 / (1.0 + exp(1.0 - 0.040000000000000001 * var_chaste_interface__membrane__V)) + 0.105 * exp(-14.0625 * pow((1 + 0.022222222222222223 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_11_gate__f_11_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_11_gate__f_11 + var_L_type_Ca_channel_f_11_gate__f_11_infinity) / var_L_type_Ca_channel_f_11_gate__tau_f_11; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_11_gate__f_11 = 0.001 * var_L_type_Ca_channel_f_11_gate__f_11_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_12_gate__f_12_infinity = 1 / (1.0 + exp(4.9444444444444438 + 0.18518518518518517 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_12_gate__tau_f_12 = 0.0016999999999999999 + 0.014999999999999999 / (1.0 + exp(3.0 + 0.040000000000000001 * var_chaste_interface__membrane__V)) + 0.080000000000000002 / (1.0 + exp(-11.0 - 0.20000000000000001 * var_chaste_interface__membrane__V)) + 0.041000000000000002 * exp(-15.340277777777779 * pow((1 + 0.021276595744680851 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_12_gate__f_12_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_12_gate__f_12 + var_L_type_Ca_channel_f_12_gate__f_12_infinity) / var_L_type_Ca_channel_f_12_gate__tau_f_12; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_12_gate__f_12 = 0.001 * var_L_type_Ca_channel_f_12_gate__f_12_orig_deriv; // 1 / millisecond
        const double var_hyperpolarisation_activated_current_y_gate__tau_y = 1 / (0.56230000000000002 * exp(-5.6377730796335452 - 0.070472163495419307 * var_chaste_interface__membrane__V) + 0.11885 * exp(2.8198801550934083 + 0.035248501938667604 * var_chaste_interface__membrane__V)); // second
        const double var_hyperpolarisation_activated_current_y_gate__y_infinity = 1 / (1.0 + exp(13.225190839694655 + 0.095419847328244267 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_hyperpolarisation_activated_current_y_gate__y_orig_deriv = (-var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + var_hyperpolarisation_activated_current_y_gate__y_infinity) / var_hyperpolarisation_activated_current_y_gate__tau_y; // 1 / second
        const double d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y = 0.001 * var_hyperpolarisation_activated_current_y_gate__y_orig_deriv; // 1 / millisecond
        const double var_intracellular_ion_concentrations__Ca_ss_orig_deriv = (var_SR_Ca_release_channel__J_rel * var_intracellular_ion_concentrations__V_JSR / var_intracellular_ion_concentrations__V_SS - var_intracellular_and_SR_Ca_fluxes__J_xfer * var_intracellular_ion_concentrations__V_myo / var_intracellular_ion_concentrations__V_SS - 0.5 * var_L_type_Ca_channel__i_Ca_L / (var_intracellular_ion_concentrations__V_SS * var_membrane__F)) * var_intracellular_ion_concentrations__beta_SS; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_ss = 0.001 * var_intracellular_ion_concentrations__Ca_ss_orig_deriv; // millimolar / millisecond
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P_max = 0.0040000000000000001; // nanoA
        const double var_sarcolemmal_calcium_pump_current__i_Ca_P = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_Ca_P_max / (0.00040000000000000002 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // nanoA
        const double var_sodium_current__g_Na = 0.80000000000000004; // microS
        const double var_sodium_current_h_gate__h_infinity = 1 / (1.0 + exp(12.537067545304776 + 0.16474464579901152 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h_gate__tau_h = ((var_chaste_interface__membrane__V >= -40.0) ? (0.00045370000000000002 + 0.00045370000000000002 * exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)) : (0.00349 / (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V) + 0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__V)))); // second
        const double var_sodium_current_h_gate__h_orig_deriv = (-var_chaste_interface__sodium_current_h_gate__h + var_sodium_current_h_gate__h_infinity) / var_sodium_current_h_gate__tau_h; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h = 0.001 * var_sodium_current_h_gate__h_orig_deriv; // 1 / millisecond
        const double var_sodium_current_j_gate__j_infinity = 1 / (1.0 + exp(12.537067545304776 + 0.16474464579901152 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_j_gate__tau_j = ((var_chaste_interface__membrane__V >= -40.0) ? (0.01163 * (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)) / exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V)) : (0.00349 / (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V)) + (37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))))); // second
        const double var_sodium_current_j_gate__j_orig_deriv = (-var_chaste_interface__sodium_current_j_gate__j + var_sodium_current_j_gate__j_infinity) / var_sodium_current_j_gate__tau_j; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_j_gate__j = 0.001 * var_sodium_current_j_gate__j_orig_deriv; // 1 / millisecond
        const double var_sodium_current_m_gate__m_infinity = 1 / (1.0 + exp(-6.9230769230769234 - 0.15384615384615385 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_m_gate__tau_m = 0.0013600000000000001 / (0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V) + 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__V))); // second
        const double var_sodium_current_m_gate__m_orig_deriv = (-var_chaste_interface__sodium_current_m_gate__m + var_sodium_current_m_gate__m_infinity) / var_sodium_current_m_gate__tau_m; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * var_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond
        const double var_sodium_potassium_pump__K_m_K = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 10.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.080000000000000002; // nanoA
        const double var_standard_ionic_concentrations__Ca_o = 1.2; // millimolar
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Ca_o / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // nanoA
        const double var_standard_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__K_o / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (var_Ca_independent_transient_outward_K_current__a * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + var_Ca_independent_transient_outward_K_current__b * var_chaste_interface__Ca_independent_transient_outward_K_current_s_slow_gate__s_slow) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r; // nanoA
        const double var_background_currents__i_B_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_background_currents__g_B_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_K * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_inward_rectifier__i_K1 = 0.0001 * (10.0 + 48.0 / (exp(1.48 + 0.040000000000000001 * var_chaste_interface__membrane__V) + exp(-1.48 - 0.040000000000000001 * var_chaste_interface__membrane__V))) / (1.0 + exp(4.5158823529411762 + 0.058823529411764705 * var_Ca_independent_transient_outward_K_current__E_K - 0.058823529411764705 * var_chaste_interface__membrane__V)) + (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / ((1.0 + exp(1.613 * (-1.73 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (1.0 + exp(8.0548387096774192 - 8.064516129032258 * var_standard_ionic_concentrations__K_o))); // nanoA
        const double var_standard_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_Na_Ca_ion_exchanger_current__gamma_NaCa * var_chaste_interface__membrane__V) - pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_Na_Ca_ion_exchanger_current__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_Na_Ca_ion_exchanger_current__K_NaCa / (1.0 + (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_standard_ionic_concentrations__Ca_o + pow(var_standard_ionic_concentrations__Na_o, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i) * var_Na_Ca_ion_exchanger_current__d_NaCa); // nanoA
        const double var_intracellular_ion_concentrations__Ca_i_orig_deriv = (-var_SERCA2a_pump__J_up - var_intracellular_and_SR_Ca_fluxes__J_trpn - 0.5 * (-2.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B_Ca + var_sarcolemmal_calcium_pump_current__i_Ca_P) / (var_intracellular_ion_concentrations__V_myo * var_membrane__F) + var_intracellular_and_SR_Ca_fluxes__J_xfer) * var_intracellular_ion_concentrations__beta_i; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = 0.001 * var_intracellular_ion_concentrations__Ca_i_orig_deriv; // millimolar / millisecond
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_standard_ionic_concentrations__Na_o / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__f_Na * var_hyperpolarisation_activated_current__g_f * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // nanoA
        const double var_sodium_current__i_Na = pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_current__g_Na * var_chaste_interface__sodium_current_h_gate__h * var_chaste_interface__sodium_current_j_gate__j; // nanoA
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_standard_ionic_concentrations__Na_o); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_sodium_potassium_pump__i_NaK_max * var_standard_ionic_concentrations__K_o / ((1.0 + pow((var_sodium_potassium_pump__K_m_Na / var_chaste_interface__intracellular_ion_concentrations__Na_i), 1.5)) * (var_sodium_potassium_pump__K_m_K + var_standard_ionic_concentrations__K_o) * (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // nanoA
        const double var_intracellular_ion_concentrations__Na_i_orig_deriv = (-var_background_currents__i_B_Na - var_hyperpolarisation_activated_current__i_f_Na - var_sodium_current__i_Na - 3.0 * var_Na_Ca_ion_exchanger_current__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__V_myo * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = 0.001 * var_intracellular_ion_concentrations__Na_i_orig_deriv; // millimolar / millisecond
        const double var_steady_state_outward_K_current__g_ss = 0.0070000000000000001; // microS
        const double var_steady_state_outward_K_current_r_ss_gate__r_ss_infinity = 1 / (1.0 + exp(-0.97292724196277491 - 0.084602368866328256 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_steady_state_outward_K_current_r_ss_gate__tau_r_ss = 10.0 / (45.159999999999997 * exp(1.7885000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V) + 98.900000000000006 * exp(-3.8000000000000003 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // second
        const double var_steady_state_outward_K_current_r_ss_gate__r_ss_orig_deriv = (-var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss + var_steady_state_outward_K_current_r_ss_gate__r_ss_infinity) / var_steady_state_outward_K_current_r_ss_gate__tau_r_ss; // 1 / second
        const double d_dt_chaste_interface_var_steady_state_outward_K_current_r_ss_gate__r_ss = 0.001 * var_steady_state_outward_K_current_r_ss_gate__r_ss_orig_deriv; // 1 / millisecond
        const double var_steady_state_outward_K_current__i_ss = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_steady_state_outward_K_current__g_ss * var_chaste_interface__steady_state_outward_K_current_r_ss_gate__r_ss * var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss; // nanoA
        const double var_intracellular_ion_concentrations__K_i_orig_deriv = (-var_Ca_independent_transient_outward_K_current__i_t - var_background_currents__i_B_K - var_hyperpolarisation_activated_current__i_f_K - var_inward_rectifier__i_K1 - var_steady_state_outward_K_current__i_ss + 2.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__V_myo * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = 0.001 * var_intracellular_ion_concentrations__K_i_orig_deriv; // millimolar / millisecond
        const double var_steady_state_outward_K_current_s_ss_gate__s_ss_infinity = 1 / (1.0 + exp(8.4951456310679614 + 0.097087378640776698 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_steady_state_outward_K_current_s_ss_gate__tau_s_ss = 2.1000000000000001; // second
        const double var_steady_state_outward_K_current_s_ss_gate__s_ss_orig_deriv = (-var_chaste_interface__steady_state_outward_K_current_s_ss_gate__s_ss + var_steady_state_outward_K_current_s_ss_gate__s_ss_infinity) / var_steady_state_outward_K_current_s_ss_gate__tau_s_ss; // 1 / second
        const double d_dt_chaste_interface_var_steady_state_outward_K_current_s_ss_gate__s_ss = 0.001 * var_steady_state_outward_K_current_s_ss_gate__s_ss_orig_deriv; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
            const double var_membrane__i_Stim = 1000.0 * mParameters[0] * var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // nanoA
            const double var_background_currents__i_B = var_background_currents__i_B_Ca + var_background_currents__i_B_K + var_background_currents__i_B_Na; // nanoA
            const double var_hyperpolarisation_activated_current__i_f = var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na; // nanoA
            const double var_membrane__V_orig_deriv = (-var_Ca_independent_transient_outward_K_current__i_t - var_L_type_Ca_channel__i_Ca_L - var_Na_Ca_ion_exchanger_current__i_NaCa - var_background_currents__i_B - var_hyperpolarisation_activated_current__i_f - var_inward_rectifier__i_K1 - var_membrane__i_Stim - var_sarcolemmal_calcium_pump_current__i_Ca_P - var_sodium_current__i_Na - var_sodium_potassium_pump__i_NaK - var_steady_state_outward_K_current__i_ss) / mParameters[0]; // millivolt / second
            d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__V;
        rDY[1] = d_dt_chaste_interface_var_sodium_current_m_gate__m;
        rDY[2] = d_dt_chaste_interface_var_sodium_current_h_gate__h;
        rDY[3] = d_dt_chaste_interface_var_sodium_current_j_gate__j;
        rDY[4] = d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d;
        rDY[5] = d_dt_chaste_interface_var_L_type_Ca_channel_f_11_gate__f_11;
        rDY[6] = d_dt_chaste_interface_var_L_type_Ca_channel_f_12_gate__f_12;
        rDY[7] = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_inact_gate__Ca_inact;
        rDY[8] = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r;
        rDY[9] = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_gate__s;
        rDY[10] = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_slow_gate__s_slow;
        rDY[11] = d_dt_chaste_interface_var_steady_state_outward_K_current_r_ss_gate__r_ss;
        rDY[12] = d_dt_chaste_interface_var_steady_state_outward_K_current_s_ss_gate__s_ss;
        rDY[13] = d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;
        rDY[14] = d_dt_chaste_interface_var_SR_Ca_release_channel__P_O1;
        rDY[15] = d_dt_chaste_interface_var_SR_Ca_release_channel__P_O2;
        rDY[16] = d_dt_chaste_interface_var_SR_Ca_release_channel__P_C1;
        rDY[17] = d_dt_chaste_interface_var_SR_Ca_release_channel__P_C2;
        rDY[18] = d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__HTRPNCa;
        rDY[19] = d_dt_chaste_interface_var_intracellular_and_SR_Ca_fluxes__LTRPNCa;
        rDY[20] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
        rDY[21] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
        rDY[22] = d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
        rDY[23] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_ss;
        rDY[24] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_JSR;
        rDY[25] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_NSR;
    }

    std::vector<double> Cellpandit_model_2001_epiFromCellML::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellpandit_model_2001_epiFromCellML>::Initialise(void)
{
    this->mSystemName = "pandit_model_2001_epi";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-80.50146);

    // rY[1]:
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004164108);

    // rY[2]:
    this->mVariableNames.push_back("sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6735613);

    // rY[3]:
    this->mVariableNames.push_back("sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6729362);

    // rY[4]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.171081e-06);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_11_gate__f_11");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999529);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_12_gate__f_12");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999529);

    // rY[7]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_inact_gate__Ca_inact");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9913102);

    // rY[8]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002191519);

    // rY[9]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9842542);

    // rY[10]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s_slow_gate__s_slow");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6421196);

    // rY[11]:
    this->mVariableNames.push_back("steady_state_outward_K_current_r_ss_gate__r_ss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002907171);

    // rY[12]:
    this->mVariableNames.push_back("steady_state_outward_K_current_s_ss_gate__s_ss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3142767);

    // rY[13]:
    this->mVariableNames.push_back("hyperpolarisation_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.003578708);

    // rY[14]:
    this->mVariableNames.push_back("SR_Ca_release_channel__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0004327548);

    // rY[15]:
    this->mVariableNames.push_back("SR_Ca_release_channel__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.06254e-10);

    // rY[16]:
    this->mVariableNames.push_back("SR_Ca_release_channel__P_C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6348229);

    // rY[17]:
    this->mVariableNames.push_back("SR_Ca_release_channel__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3647471);

    // rY[18]:
    this->mVariableNames.push_back("intracellular_and_SR_Ca_fluxes__HTRPNCa");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.1394301);

    // rY[19]:
    this->mVariableNames.push_back("intracellular_and_SR_Ca_fluxes__LTRPNCa");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0051619);

    // rY[20]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(10.73519);

    // rY[21]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.901351e-05);

    // rY[22]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(139.2751);

    // rY[23]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_ss");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.737212e-05);

    // rY[24]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_JSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.06607948);

    // rY[25]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_NSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.06600742);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.00001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellpandit_model_2001_epiFromCellML)
