//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: nygren_atrial_model_1998
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "nygren_atrial_model_1998.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellnygren_atrial_model_1998FromCellML::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.00027999999999999998 * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 6.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellnygren_atrial_model_1998FromCellML::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellnygren_atrial_model_1998FromCellML::Cellnygren_atrial_model_1998FromCellML(boost::shared_ptr<AbstractIvpOdeSolver> pSolver, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCardiacCell(
                pSolver,
                29,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellnygren_atrial_model_1998FromCellML>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 0.050000000000000003; // (var_membrane__Cm) [nanoF]
    }

    Cellnygren_atrial_model_1998FromCellML::~Cellnygren_atrial_model_1998FromCellML()
    {
    }
    
    double Cellnygren_atrial_model_1998FromCellML::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0032017
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.8814
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.8742
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 1.3005e-05
        double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.0010678
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.949
        double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
        // Units: dimensionless; Initial value: 0.00015949
        double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
        // Units: dimensionless; Initial value: 0.9912
        double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
        // Units: dimensionless; Initial value: 0.0048357
        double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.0001
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
        // Units: millimolar; Initial value: 129.435
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
        // Units: millimolar; Initial value: 130.011
        double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
        // Units: millimolar; Initial value: 1.8147
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
        // Units: millimolar; Initial value: 5.3581
        
        const double var_Ca_independent_transient_outward_K_current__g_t = 7.5; // nanoS
        const double var_L_type_Ca_channel__E_Ca_app = 60.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 6.75; // nanoS
        const double var_L_type_Ca_channel__k_Ca = 0.025000000000000001; // millimolar
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.00029999999999999997; // per_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma = 0.45000000000000001; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__k_NaCa = 0.037484200000000002; // picoA_per_millimolar_4
        const double var_background_currents__g_B_Ca = 0.078681000000000001; // nanoS
        const double var_background_currents__g_B_Na = 0.060599; // nanoS
        const double var_delayed_rectifier_K_currents__g_Kr = 0.5; // nanoS
        const double var_delayed_rectifier_K_currents__g_Ks = 1.0; // nanoS
        const double var_L_type_Ca_channel__f_Ca = var_chaste_interface__intracellular_ion_concentrations__Ca_d / (var_L_type_Ca_channel__k_Ca + var_chaste_interface__intracellular_ion_concentrations__Ca_d); // dimensionless
        const double var_inward_rectifier__g_K1 = 3.0; // nanoS
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 306.14999999999998; // kelvin
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s; // picoA
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * ((1.0 - var_L_type_Ca_channel__f_Ca) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_L_type_Ca_channel__f_Ca * var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L; // picoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(var_Na_Ca_ion_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_ion_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_ion_exchanger_current__k_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) * var_Na_Ca_ion_exchanger_current__d_NaCa); // picoA
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // picoA
        const double var_delayed_rectifier_K_currents__i_Ks = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Ks * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n; // picoA
        const double var_delayed_rectifier_K_currents_pi_gate__p_i = 1 / (1.0 + exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents__i_Kr = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Kr * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a * var_delayed_rectifier_K_currents_pi_gate__p_i; // picoA
        const double var_inward_rectifier__i_K1 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / (1.0 + exp(1.5 * (3.6000000000000001 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP_max = 4.0; // picoA
        const double var_sarcolemmal_calcium_pump_current__k_CaP = 0.00020000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump_current__i_CaP = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_CaP_max / (var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_sarcolemmal_calcium_pump_current__k_CaP); // picoA
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // picoA
        const double var_sodium_current__P_Na = 0.0016000000000000001; // nanolitre_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA
        const double var_sodium_potassium_pump__i_NaK_max = 70.825299999999999; // picoA
        const double var_sodium_potassium_pump__k_NaK_K = 1.0; // millimolar
        const double var_sodium_potassium_pump__k_NaK_Na = 11.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c * var_sodium_potassium_pump__i_NaK_max / ((200.0 + var_chaste_interface__membrane__V) * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) + pow(var_sodium_potassium_pump__k_NaK_Na, 1.5)) * (var_chaste_interface__cleft_space_ion_concentrations__K_c + var_sodium_potassium_pump__k_NaK_K)); // picoA
        const double var_sustained_outward_K_current__g_sus = 2.75; // nanoS
        const double var_sustained_outward_K_current__i_sus = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_sustained_outward_K_current__g_sus * var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus; // picoA
        const double var_chaste_interface__i_ionic = 9.9999999999999995e-7 * (var_Ca_independent_transient_outward_K_current__i_t + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_delayed_rectifier_K_currents__i_Kr + var_delayed_rectifier_K_currents__i_Ks + var_inward_rectifier__i_K1 + var_sarcolemmal_calcium_pump_current__i_CaP + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_sustained_outward_K_current__i_sus) * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellnygren_atrial_model_1998FromCellML::EvaluateYDerivatives(double var_chaste_interface__environment__time_converted, const std::vector<double>& rY, std::vector<double>& rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0032017
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.8814
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.8742
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 1.3005e-05
        double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.0010678
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.949
        double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
        // Units: dimensionless; Initial value: 0.00015949
        double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
        // Units: dimensionless; Initial value: 0.9912
        double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
        // Units: dimensionless; Initial value: 0.0048357
        double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.0001
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
        // Units: millimolar; Initial value: 129.435
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        double var_chaste_interface__intracellular_Ca_buffering__O_C = rY[17];
        // Units: dimensionless; Initial value: 0.0275
        double var_chaste_interface__intracellular_Ca_buffering__O_TC = rY[18];
        // Units: dimensionless; Initial value: 0.0133
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[19];
        // Units: dimensionless; Initial value: 0.1961
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[20];
        // Units: dimensionless; Initial value: 0.7094
        double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
        // Units: millimolar; Initial value: 130.011
        double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
        // Units: millimolar; Initial value: 1.8147
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
        // Units: millimolar; Initial value: 5.3581
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[24];
        // Units: millimolar; Initial value: 0.6465
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[25];
        // Units: millimolar; Initial value: 0.6646
        double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = rY[26];
        // Units: dimensionless; Initial value: 0.4369
        double var_chaste_interface__Ca_handling_by_the_SR__F1 = rY[27];
        // Units: dimensionless; Initial value: 0.4284
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[28];
        // Units: dimensionless; Initial value: 0.0028

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_Ca_handling_by_the_SR__I_up_max = 2800.0; // picoA
        const double var_Ca_handling_by_the_SR__O_Calse_orig_deriv = -400.0 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse + 480.0 * (1.0 - var_chaste_interface__Ca_handling_by_the_SR__O_Calse) * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // 1 / second
        const double var_Ca_handling_by_the_SR__Vol_rel = 4.4100000000000001e-5; // nanolitre
        const double var_Ca_handling_by_the_SR__Vol_up = 0.0003969; // nanolitre
        const double var_Ca_handling_by_the_SR__alpha_rel = 200000.0; // picoA_per_millimolar
        const double var_Ca_handling_by_the_SR__k_cyca = 0.00029999999999999997; // millimolar
        const double var_Ca_handling_by_the_SR__k_rel_d = 0.0030000000000000001; // millimolar
        const double var_Ca_handling_by_the_SR__k_rel_i = 0.00029999999999999997; // millimolar
        const double var_Ca_handling_by_the_SR__k_srca = 0.5; // millimolar
        const double var_Ca_handling_by_the_SR__k_xcs = 0.40000000000000002; // dimensionless
        const double var_Ca_handling_by_the_SR__r_recov = 0.81499999999999995; // per_second
        const double var_Ca_handling_by_the_SR__tau_tr = 0.01; // second
        const double var_Ca_independent_transient_outward_K_current__g_t = 7.5; // nanoS
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse = 0.001 * var_Ca_handling_by_the_SR__O_Calse_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel__E_Ca_app = 60.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 6.75; // nanoS
        const double var_L_type_Ca_channel__k_Ca = 0.025000000000000001; // millimolar
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.00029999999999999997; // per_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma = 0.45000000000000001; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__k_NaCa = 0.037484200000000002; // picoA_per_millimolar_4
        const double var_background_currents__g_B_Ca = 0.078681000000000001; // nanoS
        const double var_background_currents__g_B_Na = 0.060599; // nanoS
        const double var_cleft_space_ion_concentrations__Ca_b = 1.8; // millimolar
        const double var_cleft_space_ion_concentrations__K_b = 5.4000000000000004; // millimolar
        const double var_cleft_space_ion_concentrations__Na_b = 130.0; // millimolar
        const double var_cleft_space_ion_concentrations__tau_Ca = 24.699999999999999; // second
        const double var_cleft_space_ion_concentrations__tau_K = 10.0; // second
        const double var_cleft_space_ion_concentrations__tau_Na = 14.300000000000001; // second
        const double var_delayed_rectifier_K_currents__g_Kr = 0.5; // nanoS
        const double var_delayed_rectifier_K_currents__g_Ks = 1.0; // nanoS
        const double var_intracellular_Ca_buffering__Mg_i = 2.5; // millimolar
        const double var_intracellular_Ca_buffering__O_TMgMg_orig_deriv = -666.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgMg + 2000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_intracellular_Ca_buffering__Mg_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg = 0.001 * var_intracellular_Ca_buffering__O_TMgMg_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel__f_Ca = var_chaste_interface__intracellular_ion_concentrations__Ca_d / (var_L_type_Ca_channel__k_Ca + var_chaste_interface__intracellular_ion_concentrations__Ca_d); // dimensionless
        const double var_Ca_handling_by_the_SR__i_rel = pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel) * var_Ca_handling_by_the_SR__alpha_rel / pow((0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2), 2); // picoA
        const double var_Ca_handling_by_the_SR__i_up = (var_chaste_interface__intracellular_ion_concentrations__Ca_i / var_Ca_handling_by_the_SR__k_cyca - pow(var_Ca_handling_by_the_SR__k_xcs, 2) * var_chaste_interface__Ca_handling_by_the_SR__Ca_up / var_Ca_handling_by_the_SR__k_srca) * var_Ca_handling_by_the_SR__I_up_max / ((var_Ca_handling_by_the_SR__k_cyca + var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_Ca_handling_by_the_SR__k_cyca + (var_chaste_interface__Ca_handling_by_the_SR__Ca_up + var_Ca_handling_by_the_SR__k_srca) * var_Ca_handling_by_the_SR__k_xcs / var_Ca_handling_by_the_SR__k_srca); // picoA
        const double var_Ca_handling_by_the_SR__r_act = 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_d, 4) / pow((var_Ca_handling_by_the_SR__k_rel_d + var_chaste_interface__intracellular_ion_concentrations__Ca_d), 4) + 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((var_Ca_handling_by_the_SR__k_rel_i + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double var_Ca_handling_by_the_SR__F1_orig_deriv = (1.0 - var_chaste_interface__Ca_handling_by_the_SR__F1 - var_chaste_interface__Ca_handling_by_the_SR__F2) * var_Ca_handling_by_the_SR__r_recov - var_chaste_interface__Ca_handling_by_the_SR__F1 * var_Ca_handling_by_the_SR__r_act; // 1 / second
        const double var_Ca_handling_by_the_SR__r_inact = 33.960000000000001 + 339.60000000000002 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((var_Ca_handling_by_the_SR__k_rel_i + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double var_Ca_handling_by_the_SR__F2_orig_deriv = var_chaste_interface__Ca_handling_by_the_SR__F1 * var_Ca_handling_by_the_SR__r_act - var_chaste_interface__Ca_handling_by_the_SR__F2 * var_Ca_handling_by_the_SR__r_inact; // 1 / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1 = 0.001 * var_Ca_handling_by_the_SR__F1_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2 = 0.001 * var_Ca_handling_by_the_SR__F2_orig_deriv; // 1 / millisecond
        const double var_intracellular_Ca_buffering__O_C_orig_deriv = -476.0 * var_chaste_interface__intracellular_Ca_buffering__O_C + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_C) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C = 0.001 * var_intracellular_Ca_buffering__O_C_orig_deriv; // 1 / millisecond
        const double var_intracellular_Ca_buffering__O_TC_orig_deriv = -392.0 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 78400.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TC) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC = 0.001 * var_intracellular_Ca_buffering__O_TC_orig_deriv; // 1 / millisecond
        const double var_intracellular_Ca_buffering__O_TMgC_orig_deriv = -6.5999999999999996 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC = 0.001 * var_intracellular_Ca_buffering__O_TMgC_orig_deriv; // 1 / millisecond
        const double var_intracellular_Ca_buffering__dOCdt = var_intracellular_Ca_buffering__O_C_orig_deriv; // per_second
        const double var_intracellular_Ca_buffering__dOTCdt = var_intracellular_Ca_buffering__O_TC_orig_deriv; // per_second
        const double var_intracellular_Ca_buffering__dOTMgCdt = var_intracellular_Ca_buffering__O_TMgC_orig_deriv; // per_second
        const double var_intracellular_ion_concentrations__Vol_i = 0.0058840000000000003; // nanolitre
        const double var_cleft_space_ion_concentrations__Vol_c = 0.13600000000000001 * var_intracellular_ion_concentrations__Vol_i; // nanolitre
        const double var_intracellular_ion_concentrations__Vol_d = 0.02 * var_intracellular_ion_concentrations__Vol_i; // nanolitre
        const double var_intracellular_ion_concentrations__phi_Na_en = -1.6799999999999999; // picoA
        const double var_intracellular_ion_concentrations__tau_di = 0.01; // second
        const double var_inward_rectifier__g_K1 = 3.0; // nanoS
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_Ca_handling_by_the_SR__i_tr = 2.0 * (-var_chaste_interface__Ca_handling_by_the_SR__Ca_rel + var_chaste_interface__Ca_handling_by_the_SR__Ca_up) * var_Ca_handling_by_the_SR__Vol_rel * var_membrane__F / var_Ca_handling_by_the_SR__tau_tr; // picoA
        const double var_Ca_handling_by_the_SR__Ca_rel_orig_deriv = -31.0 * var_Ca_handling_by_the_SR__O_Calse_orig_deriv + 0.5 * (-var_Ca_handling_by_the_SR__i_rel + var_Ca_handling_by_the_SR__i_tr) / (var_Ca_handling_by_the_SR__Vol_rel * var_membrane__F); // millimolar / second
        const double var_Ca_handling_by_the_SR__Ca_up_orig_deriv = 0.5 * (-var_Ca_handling_by_the_SR__i_tr + var_Ca_handling_by_the_SR__i_up) / (var_Ca_handling_by_the_SR__Vol_up * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel = 0.001 * var_Ca_handling_by_the_SR__Ca_rel_orig_deriv; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up = 0.001 * var_Ca_handling_by_the_SR__Ca_up_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__i_di = 2.0 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__intracellular_ion_concentrations__Ca_d) * var_intracellular_ion_concentrations__Vol_d * var_membrane__F / var_intracellular_ion_concentrations__tau_di; // picoA
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 306.14999999999998; // kelvin
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s; // picoA
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_infinity = 1 / (1.0 + exp(0.090909090909090912 - 0.090909090909090912 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_r_gate__tau_r = 0.0015 + 0.0035000000000000001 * exp(-0.0011111111111111111 * pow(var_chaste_interface__membrane__V, 2)); // second
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r + var_Ca_independent_transient_outward_K_current_r_gate__r_infinity) / var_Ca_independent_transient_outward_K_current_r_gate__tau_r; // 1 / second
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_infinity = 1 / (1.0 + exp(3.5217391304347827 + 0.086956521739130432 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s_gate__tau_s = 0.01414 + 0.48120000000000002 * exp(-12.275731601256398 * pow((1 + 0.019065776930409912 * var_chaste_interface__membrane__V), 2)); // second
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + var_Ca_independent_transient_outward_K_current_s_gate__s_infinity) / var_Ca_independent_transient_outward_K_current_s_gate__tau_s; // 1 / second
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r = 0.001 * var_Ca_independent_transient_outward_K_current_r_gate__r_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_gate__s = 0.001 * var_Ca_independent_transient_outward_K_current_s_gate__s_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * ((1.0 - var_L_type_Ca_channel__f_Ca) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_L_type_Ca_channel__f_Ca * var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L; // picoA
        const double var_L_type_Ca_channel_d_L_gate__d_L_infinity = 1 / (1.0 + exp(-1.5517241379310345 - 0.17241379310344829 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_d_L_gate__tau_d_L = 0.002 + 0.0027000000000000001 * exp(-1.3611111111111112 * pow((1 + 0.028571428571428571 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_d_L_gate__d_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L + var_L_type_Ca_channel_d_L_gate__d_L_infinity) / var_L_type_Ca_channel_d_L_gate__tau_d_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L = 0.001 * var_L_type_Ca_channel_d_L_gate__d_L_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_L1_gate__f_L_infinity = 1 / (1.0 + exp(3.859154929577465 + 0.14084507042253522 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_L1_gate__tau_f_L1 = 0.01 + 0.161 * exp(-7.716049382716049 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_L1_gate__f_L_1_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 + var_L_type_Ca_channel_f_L1_gate__f_L_infinity) / var_L_type_Ca_channel_f_L1_gate__tau_f_L1; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_L1_gate__f_L_1 = 0.001 * var_L_type_Ca_channel_f_L1_gate__f_L_1_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_L2_gate__tau_f_L2 = 0.062600000000000003 + 1.3323 * exp(-7.9349335449315621 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_L2_gate__f_L_2_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_L_type_Ca_channel_f_L1_gate__f_L_infinity) / var_L_type_Ca_channel_f_L2_gate__tau_f_L2; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_L2_gate__f_L_2 = 0.001 * var_L_type_Ca_channel_f_L2_gate__f_L_2_orig_deriv; // 1 / millisecond
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(var_Na_Ca_ion_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_ion_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_ion_exchanger_current__k_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) * var_Na_Ca_ion_exchanger_current__d_NaCa); // picoA
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // picoA
        const double var_delayed_rectifier_K_currents__i_Ks = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Ks * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n; // picoA
        const double var_delayed_rectifier_K_currents_n_gate__n_infinity = 1 / (1.0 + exp(1.5669291338582676 - 0.07874015748031496 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents_n_gate__tau_n = 0.69999999999999996 + 0.40000000000000002 * exp(-pow((-1.0 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2)); // second
        const double var_delayed_rectifier_K_currents_n_gate__n_orig_deriv = (-var_chaste_interface__delayed_rectifier_K_currents_n_gate__n + var_delayed_rectifier_K_currents_n_gate__n_infinity) / var_delayed_rectifier_K_currents_n_gate__tau_n; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifier_K_currents_n_gate__n = 0.001 * var_delayed_rectifier_K_currents_n_gate__n_orig_deriv; // 1 / millisecond
        const double var_delayed_rectifier_K_currents_pa_gate__p_a_infinity = 1 / (1.0 + exp(-2.5 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents_pa_gate__tau_p_a = 0.031179999999999999 + 0.21718000000000001 * exp(-0.82285842787521646 * pow((1 + 0.049658350548228189 * var_chaste_interface__membrane__V), 2)); // second
        const double var_delayed_rectifier_K_currents_pa_gate__p_a_orig_deriv = (-var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a + var_delayed_rectifier_K_currents_pa_gate__p_a_infinity) / var_delayed_rectifier_K_currents_pa_gate__tau_p_a; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifier_K_currents_pa_gate__p_a = 0.001 * var_delayed_rectifier_K_currents_pa_gate__p_a_orig_deriv; // 1 / millisecond
        const double var_delayed_rectifier_K_currents_pi_gate__p_i = 1 / (1.0 + exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents__i_Kr = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Kr * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a * var_delayed_rectifier_K_currents_pi_gate__p_i; // picoA
        const double var_intracellular_ion_concentrations__Ca_d_orig_deriv = 0.5 * (-var_L_type_Ca_channel__i_Ca_L - var_intracellular_ion_concentrations__i_di) / (var_intracellular_ion_concentrations__Vol_d * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_d = 0.001 * var_intracellular_ion_concentrations__Ca_d_orig_deriv; // millimolar / millisecond
        const double var_inward_rectifier__i_K1 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / (1.0 + exp(1.5 * (3.6000000000000001 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP_max = 4.0; // picoA
        const double var_sarcolemmal_calcium_pump_current__k_CaP = 0.00020000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump_current__i_CaP = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_CaP_max / (var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_sarcolemmal_calcium_pump_current__k_CaP); // picoA
        const double var_cleft_space_ion_concentrations__Ca_c_orig_deriv = (-var_chaste_interface__cleft_space_ion_concentrations__Ca_c + var_cleft_space_ion_concentrations__Ca_b) / var_cleft_space_ion_concentrations__tau_Ca + 0.5 * (-2.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + var_L_type_Ca_channel__i_Ca_L + var_background_currents__i_B_Ca + var_sarcolemmal_calcium_pump_current__i_CaP) / (var_cleft_space_ion_concentrations__Vol_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__Ca_c = 0.001 * var_cleft_space_ion_concentrations__Ca_c_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__Ca_i_orig_deriv = -0.044999999999999998 * var_intracellular_Ca_buffering__dOCdt - 0.080000000000000002 * var_intracellular_Ca_buffering__dOTCdt - 0.16 * var_intracellular_Ca_buffering__dOTMgCdt + 0.5 * (-var_Ca_handling_by_the_SR__i_up - var_background_currents__i_B_Ca - var_sarcolemmal_calcium_pump_current__i_CaP + 2.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + var_Ca_handling_by_the_SR__i_rel + var_intracellular_ion_concentrations__i_di) / (var_intracellular_ion_concentrations__Vol_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = 0.001 * var_intracellular_ion_concentrations__Ca_i_orig_deriv; // millimolar / millisecond
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // picoA
        const double var_sodium_current__P_Na = 0.0016000000000000001; // nanolitre_per_second
        const double var_sodium_current_h1_gate__h_infinity = 1 / (1.0 + exp(12.0 + 0.18867924528301888 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h1_gate__tau_h1 = 0.00029999999999999997 + 0.029999999999999999 / (1.0 + exp(10.96875 + 0.3125 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h1_gate__h1_orig_deriv = (-var_chaste_interface__sodium_current_h1_gate__h1 + var_sodium_current_h1_gate__h_infinity) / var_sodium_current_h1_gate__tau_h1; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h1_gate__h1 = 0.001 * var_sodium_current_h1_gate__h1_orig_deriv; // 1 / millisecond
        const double var_sodium_current_h2_gate__tau_h2 = 0.0030000000000000001 + 0.12 / (1.0 + exp(10.96875 + 0.3125 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h2_gate__h2_orig_deriv = (-var_chaste_interface__sodium_current_h2_gate__h2 + var_sodium_current_h1_gate__h_infinity) / var_sodium_current_h2_gate__tau_h2; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h2_gate__h2 = 0.001 * var_sodium_current_h2_gate__h2_orig_deriv; // 1 / millisecond
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA
        const double var_sodium_current_m_gate__m_infinity = 1 / (1.0 + exp(-3.3032886723507917 - 0.12180267965895249 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_m_gate__tau_m = 2.4000000000000001e-5 + 4.1999999999999998e-5 * exp(-0.78827269000771605 * pow((1 + 0.039108330074305829 * var_chaste_interface__membrane__V), 2)); // second
        const double var_sodium_current_m_gate__m_orig_deriv = (-var_chaste_interface__sodium_current_m_gate__m + var_sodium_current_m_gate__m_infinity) / var_sodium_current_m_gate__tau_m; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * var_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond
        const double var_sodium_potassium_pump__i_NaK_max = 70.825299999999999; // picoA
        const double var_sodium_potassium_pump__k_NaK_K = 1.0; // millimolar
        const double var_sodium_potassium_pump__k_NaK_Na = 11.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c * var_sodium_potassium_pump__i_NaK_max / ((200.0 + var_chaste_interface__membrane__V) * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) + pow(var_sodium_potassium_pump__k_NaK_Na, 1.5)) * (var_chaste_interface__cleft_space_ion_concentrations__K_c + var_sodium_potassium_pump__k_NaK_K)); // picoA
        const double var_cleft_space_ion_concentrations__Na_c_orig_deriv = (-var_chaste_interface__cleft_space_ion_concentrations__Na_c + var_cleft_space_ion_concentrations__Na_b) / var_cleft_space_ion_concentrations__tau_Na + (3.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + 3.0 * var_sodium_potassium_pump__i_NaK + var_background_currents__i_B_Na + var_intracellular_ion_concentrations__phi_Na_en + var_sodium_current__i_Na) / (var_cleft_space_ion_concentrations__Vol_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__Na_c = 0.001 * var_cleft_space_ion_concentrations__Na_c_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__Na_i_orig_deriv = (-var_background_currents__i_B_Na - var_intracellular_ion_concentrations__phi_Na_en - var_sodium_current__i_Na - 3.0 * var_Na_Ca_ion_exchanger_current__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__Vol_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = 0.001 * var_intracellular_ion_concentrations__Na_i_orig_deriv; // millimolar / millisecond
        const double var_sustained_outward_K_current__g_sus = 2.75; // nanoS
        const double var_sustained_outward_K_current_r_sus_gate__r_sus_infinity = 1 / (1.0 + exp(-0.53749999999999998 - 0.125 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_outward_K_current_r_sus_gate__tau_r_sus = 0.00050000000000000001 + 0.0089999999999999993 / (1.0 + exp(0.41666666666666669 + 0.083333333333333329 * var_chaste_interface__membrane__V)); // second
        const double var_sustained_outward_K_current_r_sus_gate__r_sus_orig_deriv = (-var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus + var_sustained_outward_K_current_r_sus_gate__r_sus_infinity) / var_sustained_outward_K_current_r_sus_gate__tau_r_sus; // 1 / second
        const double d_dt_chaste_interface_var_sustained_outward_K_current_r_sus_gate__r_sus = 0.001 * var_sustained_outward_K_current_r_sus_gate__r_sus_orig_deriv; // 1 / millisecond
        const double var_sustained_outward_K_current__i_sus = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_sustained_outward_K_current__g_sus * var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus; // picoA
        const double var_cleft_space_ion_concentrations__K_c_orig_deriv = (-var_chaste_interface__cleft_space_ion_concentrations__K_c + var_cleft_space_ion_concentrations__K_b) / var_cleft_space_ion_concentrations__tau_K + (-2.0 * var_sodium_potassium_pump__i_NaK + var_Ca_independent_transient_outward_K_current__i_t + var_delayed_rectifier_K_currents__i_Kr + var_delayed_rectifier_K_currents__i_Ks + var_inward_rectifier__i_K1 + var_sustained_outward_K_current__i_sus) / (var_cleft_space_ion_concentrations__Vol_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c = 0.001 * var_cleft_space_ion_concentrations__K_c_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__K_i_orig_deriv = (-var_Ca_independent_transient_outward_K_current__i_t - var_delayed_rectifier_K_currents__i_Kr - var_delayed_rectifier_K_currents__i_Ks - var_inward_rectifier__i_K1 - var_sustained_outward_K_current__i_sus + 2.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__Vol_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = 0.001 * var_intracellular_ion_concentrations__K_i_orig_deriv; // millimolar / millisecond
        const double var_sustained_outward_K_current_s_sus_gate__s_sus_infinity = 0.59999999999999998 + 0.40000000000000002 / (1.0 + exp(2.0 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_outward_K_current_s_sus_gate__tau_s_sus = 0.29999999999999999 + 0.047 / (1.0 + exp(6.0 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // second
        const double var_sustained_outward_K_current_s_sus_gate__s_sus_orig_deriv = (-var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus + var_sustained_outward_K_current_s_sus_gate__s_sus_infinity) / var_sustained_outward_K_current_s_sus_gate__tau_s_sus; // 1 / second
        const double d_dt_chaste_interface_var_sustained_outward_K_current_s_sus_gate__s_sus = 0.001 * var_sustained_outward_K_current_s_sus_gate__s_sus_orig_deriv; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
            const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
            const double var_membrane__i_Stim = 1000000.0 * var_membrane__Cm_converted * var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // picoA
            const double var_membrane__V_orig_deriv = -1.0 * (var_Ca_independent_transient_outward_K_current__i_t + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_delayed_rectifier_K_currents__i_Kr + var_delayed_rectifier_K_currents__i_Ks + var_inward_rectifier__i_K1 + var_membrane__i_Stim + var_sarcolemmal_calcium_pump_current__i_CaP + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_sustained_outward_K_current__i_sus) / mParameters[0]; // millivolt / second
            d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__V;
        rDY[1] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
        rDY[2] = d_dt_chaste_interface_var_sodium_current_m_gate__m;
        rDY[3] = d_dt_chaste_interface_var_sodium_current_h1_gate__h1;
        rDY[4] = d_dt_chaste_interface_var_sodium_current_h2_gate__h2;
        rDY[5] = d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L;
        rDY[6] = d_dt_chaste_interface_var_L_type_Ca_channel_f_L1_gate__f_L_1;
        rDY[7] = d_dt_chaste_interface_var_L_type_Ca_channel_f_L2_gate__f_L_2;
        rDY[8] = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r;
        rDY[9] = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_gate__s;
        rDY[10] = d_dt_chaste_interface_var_sustained_outward_K_current_r_sus_gate__r_sus;
        rDY[11] = d_dt_chaste_interface_var_sustained_outward_K_current_s_sus_gate__s_sus;
        rDY[12] = d_dt_chaste_interface_var_delayed_rectifier_K_currents_n_gate__n;
        rDY[13] = d_dt_chaste_interface_var_delayed_rectifier_K_currents_pa_gate__p_a;
        rDY[14] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
        rDY[15] = d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
        rDY[16] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_d;
        rDY[17] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C;
        rDY[18] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC;
        rDY[19] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC;
        rDY[20] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg;
        rDY[21] = d_dt_chaste_interface_var_cleft_space_ion_concentrations__Na_c;
        rDY[22] = d_dt_chaste_interface_var_cleft_space_ion_concentrations__Ca_c;
        rDY[23] = d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c;
        rDY[24] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel;
        rDY[25] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up;
        rDY[26] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse;
        rDY[27] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1;
        rDY[28] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2;
    }

    std::vector<double> Cellnygren_atrial_model_1998FromCellML::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(3);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__Cm_converted;
        dqs[2] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellnygren_atrial_model_1998FromCellML>::Initialise(void)
{
    this->mSystemName = "nygren_atrial_model_1998";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-74.2525);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(6.729e-05);

    // rY[2]:
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0032017);

    // rY[3]:
    this->mVariableNames.push_back("sodium_current_h1_gate__h1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8814);

    // rY[4]:
    this->mVariableNames.push_back("sodium_current_h2_gate__h2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8742);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_L_gate__d_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.3005e-05);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_L1_gate__f_L_1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9986);

    // rY[7]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_L2_gate__f_L_2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9986);

    // rY[8]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0010678);

    // rY[9]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.949);

    // rY[10]:
    this->mVariableNames.push_back("sustained_outward_K_current_r_sus_gate__r_sus");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00015949);

    // rY[11]:
    this->mVariableNames.push_back("sustained_outward_K_current_s_sus_gate__s_sus");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9912);

    // rY[12]:
    this->mVariableNames.push_back("delayed_rectifier_K_currents_n_gate__n");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0048357);

    // rY[13]:
    this->mVariableNames.push_back("delayed_rectifier_K_currents_pa_gate__p_a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001);

    // rY[14]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.5547);

    // rY[15]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(129.435);

    // rY[16]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_d");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.2495e-05);

    // rY[17]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0275);

    // rY[18]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TC");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0133);

    // rY[19]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TMgC");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1961);

    // rY[20]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TMgMg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.7094);

    // rY[21]:
    this->mVariableNames.push_back("cleft_space_ion_concentrations__Na_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(130.011);

    // rY[22]:
    this->mVariableNames.push_back("cleft_space_ion_concentrations__Ca_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.8147);

    // rY[23]:
    this->mVariableNames.push_back("cleft_space_ion_concentrations__K_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.3581);

    // rY[24]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.6465);

    // rY[25]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.6646);

    // rY[26]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__O_Calse");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4369);

    // rY[27]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4284);

    // rY[28]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0028);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("nanoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellnygren_atrial_model_1998FromCellML)
