//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: matsuoka_model_2003
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "matsuoka_model_2003.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellmatsuoka_model_2003FromCellML::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.0040000000000000001 * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 2.0; // millisecond
        const double var_chaste_interface__membrane__stim_period = 400.0; // millisecond
        const double var_chaste_interface__membrane__stim_start = 50.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellmatsuoka_model_2003FromCellML::Cellmatsuoka_model_2003FromCellML(boost::shared_ptr<AbstractIvpOdeSolver> pSolver, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCardiacCell(
                pSolver,
                37,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellmatsuoka_model_2003FromCellML>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 132.0; // (var_membrane__Cm) [picoF]
    }

    Cellmatsuoka_model_2003FromCellML::~Cellmatsuoka_model_2003FromCellML()
    {
    }
    
    double Cellmatsuoka_model_2003FromCellML::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        
        const double var_L_type_Ca_channel__P_CaL = 8712.0; // picoA_per_millimolar
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_T_type_Ca_channel__P_CaT = 612.0; // picoA_per_millimolar
        const double var_background_Cab_current__P_Cab = 0.040000000000000001; // picoA_per_millimolar
        const double var_background_KATP_current__N = 2333.0; // picoF
        const double var_background_KATP_current__P_KATP = 0.023599999999999999; // nanoS_per_picoF
        const double var_background_KATP_current__p_open = 0.80000000000000004 / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)); // dimensionless
        const double var_background_NSC_current__P_bNSC = 0.38500000000000001; // picoA_per_millimolar
        const double var_background_lCa_current__P_lCa = 0.11; // picoA_per_millimolar
        const double var_external_ion_concentrations__Cao = 1.8; // millimolar
        const double var_external_ion_concentrations__Ko = 5.4000000000000004; // millimolar
        const double var_background_KATP_current__gamma = pow(var_external_ion_concentrations__Ko, 0.23999999999999999) * var_background_KATP_current__N * var_background_KATP_current__P_KATP; // nanoS
        const double var_background_Kpl_current__P_Kpl = 8.3986538766456042e-5 * pow(var_external_ion_concentrations__Ko, 0.16); // nanoS_per_millimolar
        const double var_external_ion_concentrations__Nao = 140.0; // millimolar
        const double var_internal_ion_concentrations__CMDN_max = 0.050000000000000003; // millimolar
        const double var_internal_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_internal_ion_concentrations__b1 = -var_chaste_interface__internal_ion_concentrations__Ca_Total + var_internal_ion_concentrations__CMDN_max + var_internal_ion_concentrations__K_mCMDN; // millimolar
        const double var_internal_ion_concentrations__c1 = var_chaste_interface__internal_ion_concentrations__Ca_Total * var_internal_ion_concentrations__K_mCMDN; // millimolar2
        const double var_internal_ion_concentrations__Cai = sqrt(0.25 * pow(var_internal_ion_concentrations__b1, 2) + var_internal_ion_concentrations__c1) - 0.5 * var_internal_ion_concentrations__b1; // millimolar
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF
        const double var_membrane__F = 96.486699999999999; // coulomb_per_millimole
        const double var_membrane__R = 8.3142999999999994; // coulomb_millivolt_per_kelvin_millimole
        const double var_membrane__T = 310.0; // kelvin
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Cao) : (2.0 * (-var_external_ion_concentrations__Cao * exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_internal_ion_concentrations__Cai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Ca = var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca; // picoA
        const double var_T_type_Ca_channel__i_Ca_T = var_T_type_Ca_channel__P_CaT * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca; // picoA
        const double var_background_Cab_current__i_Cab = var_background_Cab_current__P_Cab * var_constant_field_equations__CF_Ca; // picoA
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : ((-var_external_ion_concentrations__Ko * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Ki) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_K = 0.00036499999999999998 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K; // picoA
        const double var_background_Kpl_current__i_Kpl = ((var_chaste_interface__membrane__Vm == (-3.0)) ? (13.0077 * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K) : ((3.0 + var_chaste_interface__membrane__Vm) * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_background_NSC_current__i_bNSC_K = 0.40000000000000002 * var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_K; // picoA
        const double var_background_lCa_current__i_lCa_K = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_K; // picoA
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Nao) : ((-var_external_ion_concentrations__Nao * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Nai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Na = 1.8499999999999999e-5 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na; // picoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaL_Ca + var_L_type_Ca_channel__i_CaL_K + var_L_type_Ca_channel__i_CaL_Na; // picoA
        const double var_background_NSC_current__i_bNSC_Na = var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_Na; // picoA
        const double var_background_NSC_current__i_bNSC = var_background_NSC_current__i_bNSC_K + var_background_NSC_current__i_bNSC_Na; // picoA
        const double var_background_lCa_current__i_lCa_Na = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na; // picoA
        const double var_background_lCa_current__i_lCa = var_background_lCa_current__i_lCa_K + var_background_lCa_current__i_lCa_Na; // picoA
        const double var_rapid_time_dependent_potassium_current__P_Kr = 0.0086400000000000001; // nanoS_per_picoF
        const double var_rapid_time_dependent_potassium_current__g_Kr = 0.71370912277944121 * pow(var_external_ion_concentrations__Ko, 0.20000000000000001) * mParameters[0] * var_rapid_time_dependent_potassium_current__P_Kr; // nanoS
        const double var_slow_time_dependent_potassium_current__P_Ks_K = 5.04; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current__P_Ks_Na = 0.2016; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current__i_Ks_K = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K * var_slow_time_dependent_potassium_current__P_Ks_K; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_Na = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na * var_slow_time_dependent_potassium_current__P_Ks_Na; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks = var_slow_time_dependent_potassium_current__i_Ks_K + var_slow_time_dependent_potassium_current__i_Ks_Na; // picoA
        const double var_sodium_calcium_exchanger__Km_Cai = 0.0013799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Cao = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nai = 8.75; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nao = 87.5; // millimolar
        const double var_sodium_calcium_exchanger__P_NaCa = 6.8099999999999996; // picoA_per_picoF
        const double var_sodium_calcium_exchanger__Partition = 0.32000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger__k1 = exp(var_membrane__F * var_chaste_interface__membrane__Vm * var_sodium_calcium_exchanger__Partition / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp((-1.0 + var_sodium_calcium_exchanger__Partition) * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nai, 3) * (1.0 + var_internal_ion_concentrations__Cai / var_sodium_calcium_exchanger__Km_Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__p_E2Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nao, 3) * (1.0 + var_external_ion_concentrations__Cao / var_sodium_calcium_exchanger__Km_Cao) / pow(var_external_ion_concentrations__Nao, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa = (var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y - (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 * var_sodium_calcium_exchanger__p_E2Na) * mParameters[0] * var_sodium_calcium_exchanger__P_NaCa; // picoA
        const double var_sodium_current__P_Na = 2860.0; // picoA_per_millimolar
        const double var_sodium_current__i_Na_K = 0.10000000000000001 * var_constant_field_equations__CF_K * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na_Na = var_constant_field_equations__CF_Na * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na = var_sodium_current__i_Na_K + var_sodium_current__i_Na_Na; // picoA
        const double var_sodium_potassium_pump__Km_ATP = 0.094; // millimolar
        const double var_sodium_potassium_pump__Km_Ki = 32.880000000000003; // millimolar
        const double var_sodium_potassium_pump__Km_Ko = 0.25800000000000001; // millimolar
        const double var_sodium_potassium_pump__Km_Nai = 4.0499999999999998; // millimolar
        const double var_sodium_potassium_pump__Km_Nao = 69.799999999999997; // millimolar
        const double var_sodium_potassium_pump__Nao_Eff = var_external_ion_concentrations__Nao * exp(-0.81999999999999995 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // millimolar
        const double var_sodium_potassium_pump__P_NaK = 21.0; // picoA_per_picoF
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + var_sodium_potassium_pump__Km_ATP / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__k2 = 0.040000000000000001; // per_millisecond
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nai / var_chaste_interface__internal_ion_concentrations__Nai), 1.0600000000000001) * (1.0 + pow((var_chaste_interface__internal_ion_concentrations__Ki / var_sodium_potassium_pump__Km_Ki), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nao / var_sodium_potassium_pump__Nao_Eff), 1.0600000000000001) * (1.0 + pow((var_external_ion_concentrations__Ko / var_sodium_potassium_pump__Km_Ko), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = (var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y - (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__k2 * var_sodium_potassium_pump__p_E2Na) * mParameters[0] * var_sodium_potassium_pump__P_NaK; // picoA
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_external_ion_concentrations__Ko / var_chaste_interface__internal_ion_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_background_KATP_current__i_KATP = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * var_background_KATP_current__gamma * var_background_KATP_current__p_open; // picoA
        const double var_membrane__i_I = var_background_Cab_current__i_Cab + var_background_KATP_current__i_KATP + var_background_Kpl_current__i_Kpl + var_background_NSC_current__i_bNSC + var_background_lCa_current__i_lCa; // picoA
        const double var_rapid_time_dependent_potassium_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * var_rapid_time_dependent_potassium_current__g_Kr * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // picoA
        const double var_time_independent_potassium_current__P_K1_0 = 1.1459999999999999; // nanoS_per_picoF
        const double var_time_independent_potassium_current__g_K1 = 0.50938071193859957 * pow(var_external_ion_concentrations__Ko, 0.40000000000000002) * mParameters[0] * var_time_independent_potassium_current__P_K1_0; // nanoS
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO2 = 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2); // dimensionless
        const double var_time_independent_potassium_current__fO3 = 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB; // dimensionless
        const double var_time_independent_potassium_current__fO4 = pow(var_time_independent_potassium_current__fO, 4); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (var_time_independent_potassium_current__fO2 + var_time_independent_potassium_current__fO3 + var_time_independent_potassium_current__fO4) * var_time_independent_potassium_current__g_K1 * var_chaste_interface__time_independent_potassium_current_y_gate__y; // picoA
        const double var_transient_outward_current__P_to_K = 0.033000000000000002; // picoA_per_millimolar
        const double var_transient_outward_current__P_to_Na = 0.00297; // picoA_per_millimolar
        const double var_transient_outward_current__i_to_K = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_transient_outward_current__P_to_K * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_transient_outward_current__i_to_Na = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_transient_outward_current__P_to_Na * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_transient_outward_current__i_to = var_transient_outward_current__i_to_K + var_transient_outward_current__i_to_Na; // picoA
        const double var_membrane__i_tot = var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_membrane__i_I + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks + var_sodium_calcium_exchanger__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to; // picoA
        const double var_chaste_interface__i_ionic = 9.9999999999999995e-7 * HeartConfig::Instance()->GetCapacitance() * var_membrane__i_tot / var_membrane__Cm_converted; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellmatsuoka_model_2003FromCellML::EvaluateYDerivatives(double var_chaste_interface__environment__time, const std::vector<double>& rY, std::vector<double>& rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.95752434460744
        double var_chaste_interface__internal_ion_concentrations__Nai = rY[1];
        // Units: millimolar; Initial value: 4.925761439682025
        double var_chaste_interface__internal_ion_concentrations__Ki = rY[2];
        // Units: millimolar; Initial value: 143.1837333000449
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        double var_chaste_interface__ATP_production__ATPi = rY[4];
        // Units: millimolar; Initial value: 4.657102729020499
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na = rY[5];
        // Units: dimensionless; Initial value: 1.779648367445368e-05
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na = rY[6];
        // Units: dimensionless; Initial value: 0.3556412697995689
        double var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na = rY[7];
        // Units: dimensionless; Initial value: 0.40285968661346977
        double var_chaste_interface__sodium_current_ultra_slow_gate__y = rY[8];
        // Units: dimensionless; Initial value: 0.5861887862983165
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = rY[9];
        // Units: dimensionless; Initial value: 1.5445004166497696e-06
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = rY[10];
        // Units: dimensionless; Initial value: 0.9968480629364956
        double var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = rY[11];
        // Units: dimensionless; Initial value: 0.000877325391245903
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U = rY[12];
        // Units: dimensionless; Initial value: 0.17246483915629204
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa = rY[13];
        // Units: dimensionless; Initial value: 6.098246017787626e-05
        double var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C = rY[14];
        // Units: dimensionless; Initial value: 0.4250747299372254
        double var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y = rY[15];
        // Units: dimensionless; Initial value: 0.9985266538252986
        double var_chaste_interface__T_type_Ca_channel_y1_gate__y1 = rY[16];
        // Units: dimensionless; Initial value: 1.6882718240109127e-05
        double var_chaste_interface__T_type_Ca_channel_y2_gate__y2 = rY[17];
        // Units: dimensionless; Initial value: 0.8585352091865849
        double var_chaste_interface__time_independent_potassium_current_y_gate__y = rY[18];
        // Units: dimensionless; Initial value: 0.6080573900752752
        double var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1 = rY[19];
        // Units: dimensionless; Initial value: 0.0018339931180983765
        double var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 = rY[20];
        // Units: dimensionless; Initial value: 0.20443083454225305
        double var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3 = rY[21];
        // Units: dimensionless; Initial value: 0.967887666264921
        double var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1 = rY[22];
        // Units: dimensionless; Initial value: 0.09738789658609195
        double var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2 = rY[23];
        // Units: dimensionless; Initial value: 0.09745345578743213
        double var_chaste_interface__transient_outward_current_y1_gate__y1 = rY[24];
        // Units: dimensionless; Initial value: 0.0007956883250874798
        double var_chaste_interface__transient_outward_current_y2_gate__y2 = rY[25];
        // Units: dimensionless; Initial value: 0.9999125083105881
        double var_chaste_interface__sodium_calcium_exchanger_y_gate__y = rY[26];
        // Units: dimensionless; Initial value: 0.9891789193465331
        double var_chaste_interface__sodium_potassium_pump_y_gate__y = rY[27];
        // Units: dimensionless; Initial value: 0.5910747147428818
        double var_chaste_interface__SR_calcium_pump_y_gate__y = rY[28];
        // Units: dimensionless; Initial value: 0.46108441538480216
        double var_chaste_interface__RyR_channel__p_open_RyR = rY[29];
        // Units: dimensionless; Initial value: 0.00034314360001543243
        double var_chaste_interface__RyR_channel__p_close_RyR = rY[30];
        // Units: dimensionless; Initial value: 0.19135178123107768
        double var_chaste_interface__Ca_concentrations_in_SR__Ca_Total = rY[31];
        // Units: millimolar; Initial value: 9.455741736977666
        double var_chaste_interface__Ca_concentrations_in_SR__Caup = rY[32];
        // Units: millimolar; Initial value: 2.611712901567567
        double var_chaste_interface__NL_model__pCa = rY[33];
        // Units: dimensionless; Initial value: 0.02490898775497523
        double var_chaste_interface__NL_model__pCaCB = rY[34];
        // Units: dimensionless; Initial value: 0.001990153835322864
        double var_chaste_interface__NL_model__pCB = rY[35];
        // Units: dimensionless; Initial value: 0.00042941813853474524
        double var_chaste_interface__NL_model__X = rY[36];
        // Units: micrometre; Initial value: 0.9573749975411884

        // Mathematics
        double d_dt_chaste_interface_var_membrane__Vm;
        const double var_ATP_production__Adenosine_Total = 5.0; // millimolar
        const double var_ATP_production__ProducingRate_Max = 0.0030000000000000001; // per_millisecond
        const double var_Ca_concentrations_in_SR__CSQN_max = 10.0; // millimolar
        const double var_Ca_concentrations_in_SR__K_mCSQN = 0.80000000000000004; // millimolar
        const double var_Ca_concentrations_in_SR__V_rel = 160.0; // micrometre3
        const double var_Ca_concentrations_in_SR__V_up = 400.0; // micrometre3
        const double var_Ca_concentrations_in_SR__b1 = -var_chaste_interface__Ca_concentrations_in_SR__Ca_Total + var_Ca_concentrations_in_SR__CSQN_max + var_Ca_concentrations_in_SR__K_mCSQN; // millimolar
        const double var_Ca_concentrations_in_SR__c1 = var_chaste_interface__Ca_concentrations_in_SR__Ca_Total * var_Ca_concentrations_in_SR__K_mCSQN; // millimolar2
        const double var_Ca_concentrations_in_SR__Carel = sqrt(0.25 * pow(var_Ca_concentrations_in_SR__b1, 2) + var_Ca_concentrations_in_SR__c1) - 0.5 * var_Ca_concentrations_in_SR__b1; // millimolar
        const double var_L_type_Ca_channel__P_CaL = 8712.0; // picoA_per_millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_C = 0.0041999999999999997; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_UCa = 0.00029999999999999997; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_C_CCa = 6.9539999999999997; // per_millimolar_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_C_U = 0.14299999999999999; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_CCa = 0.34999999999999998; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_U_C = 0.34999999999999998; // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_U_UCa = 6.9539999999999997; // per_millimolar_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_U = var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_C * var_L_type_Ca_channel_Ca_dependent_gate__k_C_U * var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_CCa * var_L_type_Ca_channel_Ca_dependent_gate__k_U_UCa / (var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_UCa * var_L_type_Ca_channel_Ca_dependent_gate__k_C_CCa * var_L_type_Ca_channel_Ca_dependent_gate__k_U_C); // per_millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__p_CCa = 1.0 - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa; // dimensionless
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AI_AP = 0.001; // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AP_AI = 0.0040000000000000001; // per_millisecond
        const double var_L_type_Ca_channel__p_open_CaL = (var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U + var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa) * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL / (1.0 + 2.7439999999999993 / pow(var_chaste_interface__ATP_production__ATPi, 3)); // dimensionless
        const double var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL = 1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // dimensionless
        const double var_NL_model__B = 1.2; // per_millisecond
        const double var_NL_model__L = 0.96237999754118841; // micrometre
        const double var_NL_model__L_a = 1.1699999999999999; // micrometre
        const double var_NL_model__EffFraction = exp(-20.0 * pow((-var_NL_model__L_a + var_NL_model__L), 2)); // dimensionless
        const double var_NL_model__T_t = 0.070000000000000007; // millimolar
        const double var_NL_model__Y_1 = 39.0; // per_millimolar_millisecond
        const double var_NL_model__Y_2 = 0.0038999999999999998; // per_millisecond
        const double var_NL_model__Y_3 = 0.029999999999999999; // per_millisecond
        const double var_NL_model__Y_4 = 0.12; // per_millisecond
        const double var_NL_model__Y_d = 0.027; // millisecond_per_micrometre2
        const double var_NL_model__Z_1 = 0.029999999999999999; // per_millisecond
        const double var_NL_model__Z_2 = 0.0038999999999999998; // per_millisecond
        const double var_NL_model__Z_3 = 1560.0; // per_millimolar_millisecond
        const double var_NL_model__h = -var_chaste_interface__NL_model__X + var_NL_model__L; // micrometre
        const double var_NL_model__h_c = 0.0050000000000000001; // micrometre
        const double d_dt_chaste_interface_var_NL_model__X = (-var_NL_model__h_c + var_NL_model__h) * var_NL_model__B; // micrometre / millisecond
        const double var_NL_model__Q_d = var_NL_model__Y_4 * var_chaste_interface__NL_model__pCB; // per_millisecond
        const double var_NL_model__Q_d1 = pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_NL_model__Y_d * var_chaste_interface__NL_model__pCB; // per_millisecond
        const double var_NL_model__Q_a = -var_NL_model__Z_2 * var_chaste_interface__NL_model__pCaCB + var_NL_model__EffFraction * var_NL_model__Y_2 * var_chaste_interface__NL_model__pCa; // per_millisecond
        const double var_NL_model__Q_d2 = pow(d_dt_chaste_interface_var_NL_model__X, 2) * var_NL_model__Y_d * var_chaste_interface__NL_model__pCaCB; // per_millisecond
        const double var_NL_model__dATPdt = -0.40000000000000002 * var_NL_model__T_t * var_chaste_interface__NL_model__pCaCB; // millimolar_per_millisecond
        const double var_NL_model__p = 1.0 - var_chaste_interface__NL_model__pCB - var_chaste_interface__NL_model__pCa - var_chaste_interface__NL_model__pCaCB; // dimensionless
        const double var_RyR_channel__Diadid_Factor = -150.0; // per_picoA_millisecond
        const double var_RyR_channel__P_RyR = 62000.0; // picoA_per_millimolar
        const double var_RyR_channel__k2 = 0.080000000000000002 / (1.0 + 0.35999999999999999 / var_Ca_concentrations_in_SR__Carel); // per_millisecond
        const double var_RyR_channel__k3 = 0.000377 * pow(var_Ca_concentrations_in_SR__Carel, 2); // per_millisecond
        const double var_RyR_channel__k4 = 0.00084900000000000004; // per_millisecond
        const double var_SR_L_current__P_SR_L = 459.0; // picoA_per_millimolar
        const double var_SR_T_current__P_SR_T = 386.0; // picoA_per_millimolar
        const double var_SR_T_current__i_SR_T = (-var_Ca_concentrations_in_SR__Carel + var_chaste_interface__Ca_concentrations_in_SR__Caup) * var_SR_T_current__P_SR_T; // picoA
        const double var_SR_calcium_pump__Km_ATP = 0.10000000000000001; // millimolar
        const double var_SR_calcium_pump__Km_CaCyto = 0.00080000000000000004; // millimolar
        const double var_SR_calcium_pump__Km_CaSR = 0.080000000000000002; // millimolar
        const double var_SR_calcium_pump__i_max = 162500.0; // picoA
        const double var_SR_calcium_pump__k1 = 0.01; // per_millisecond
        const double var_SR_calcium_pump__k2 = 1 / (1.0 + var_SR_calcium_pump__Km_ATP / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_SR_calcium_pump__k3 = 1.0; // per_millisecond
        const double var_SR_calcium_pump__k4 = 0.01; // per_millisecond
        const double var_SR_calcium_pump__p_E1Ca = 1 / (1.0 + var_SR_calcium_pump__Km_CaSR / var_chaste_interface__Ca_concentrations_in_SR__Caup); // dimensionless
        const double var_SR_calcium_pump__p_E1 = 1.0 - var_SR_calcium_pump__p_E1Ca; // dimensionless
        const double var_SR_calcium_pump_y_gate__beta_y = var_SR_calcium_pump__k1 * var_SR_calcium_pump__p_E1Ca + var_SR_calcium_pump__k3 * var_SR_calcium_pump__p_E1; // per_millisecond
        const double var_T_type_Ca_channel__P_CaT = 612.0; // picoA_per_millimolar
        const double var_background_Cab_current__P_Cab = 0.040000000000000001; // picoA_per_millimolar
        const double var_background_KATP_current__N = 2333.0; // picoF
        const double var_background_KATP_current__P_KATP = 0.023599999999999999; // nanoS_per_picoF
        const double var_background_KATP_current__p_open = 0.80000000000000004 / (1.0 + 99.999999999999986 * pow(var_chaste_interface__ATP_production__ATPi, 2)); // dimensionless
        const double var_background_NSC_current__P_bNSC = 0.38500000000000001; // picoA_per_millimolar
        const double var_background_lCa_current__P_lCa = 0.11; // picoA_per_millimolar
        const double var_external_ion_concentrations__Cao = 1.8; // millimolar
        const double var_external_ion_concentrations__Ko = 5.4000000000000004; // millimolar
        const double var_background_KATP_current__gamma = pow(var_external_ion_concentrations__Ko, 0.23999999999999999) * var_background_KATP_current__N * var_background_KATP_current__P_KATP; // nanoS
        const double var_background_Kpl_current__P_Kpl = 8.3986538766456042e-5 * pow(var_external_ion_concentrations__Ko, 0.16); // nanoS_per_millimolar
        const double var_external_ion_concentrations__Nao = 140.0; // millimolar
        const double var_internal_ion_concentrations__CMDN_max = 0.050000000000000003; // millimolar
        const double var_internal_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_internal_ion_concentrations__Vi = 8000.0; // micrometre3
        const double var_internal_ion_concentrations__b1 = -var_chaste_interface__internal_ion_concentrations__Ca_Total + var_internal_ion_concentrations__CMDN_max + var_internal_ion_concentrations__K_mCMDN; // millimolar
        const double var_internal_ion_concentrations__c1 = var_chaste_interface__internal_ion_concentrations__Ca_Total * var_internal_ion_concentrations__K_mCMDN; // millimolar2
        const double var_internal_ion_concentrations__Cai = sqrt(0.25 * pow(var_internal_ion_concentrations__b1, 2) + var_internal_ion_concentrations__c1) - 0.5 * var_internal_ion_concentrations__b1; // millimolar
        const double var_NL_model__Q_b = -var_NL_model__Z_1 * var_chaste_interface__NL_model__pCa + var_NL_model__Y_1 * var_NL_model__p * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCa = -var_NL_model__Q_a + var_NL_model__Q_b; // 1 / millisecond
        const double var_NL_model__Q_r = var_NL_model__Y_3 * var_chaste_interface__NL_model__pCaCB - var_NL_model__Z_3 * var_chaste_interface__NL_model__pCB * var_internal_ion_concentrations__Cai; // per_millisecond
        const double d_dt_chaste_interface_var_NL_model__pCB = -var_NL_model__Q_d - var_NL_model__Q_d1 + var_NL_model__Q_r; // 1 / millisecond
        const double d_dt_chaste_interface_var_NL_model__pCaCB = -var_NL_model__Q_d2 - var_NL_model__Q_r + var_NL_model__Q_a; // 1 / millisecond
        const double var_NL_model__dCaidt = (-var_NL_model__Q_b + var_NL_model__Q_d2 + var_NL_model__Q_r) * var_NL_model__T_t; // millimolar_per_millisecond
        const double var_RyR_channel__i_RyR = (-var_internal_ion_concentrations__Cai + var_Ca_concentrations_in_SR__Carel) * var_RyR_channel__P_RyR * var_chaste_interface__RyR_channel__p_open_RyR; // picoA
        const double var_SR_L_current__i_SR_L = (-var_internal_ion_concentrations__Cai + var_chaste_interface__Ca_concentrations_in_SR__Caup) * var_SR_L_current__P_SR_L; // picoA
        const double var_SR_calcium_pump__p_E2Ca = 1 / (1.0 + var_SR_calcium_pump__Km_CaCyto / var_internal_ion_concentrations__Cai); // dimensionless
        const double var_SR_calcium_pump__i_SR_U = (var_SR_calcium_pump__k1 * var_SR_calcium_pump__p_E1Ca * var_chaste_interface__SR_calcium_pump_y_gate__y - (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca) * var_SR_calcium_pump__i_max; // picoA
        const double var_SR_calcium_pump__p_E2 = 1.0 - var_SR_calcium_pump__p_E2Ca; // dimensionless
        const double var_SR_calcium_pump_y_gate__alpha_y = var_SR_calcium_pump__k2 * var_SR_calcium_pump__p_E2Ca + var_SR_calcium_pump__k4 * var_SR_calcium_pump__p_E2; // per_millisecond
        const double d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y = (1.0 - var_chaste_interface__SR_calcium_pump_y_gate__y) * var_SR_calcium_pump_y_gate__alpha_y - var_SR_calcium_pump_y_gate__beta_y * var_chaste_interface__SR_calcium_pump_y_gate__y; // 1 / millisecond
        const double var_background_lCa_current__p_open = 1 / (1.0 + 1.7279999999999996e-9 / pow(var_internal_ion_concentrations__Cai, 3)); // dimensionless
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF
        const double var_membrane__F = 96.486699999999999; // coulomb_per_millimole
        const double d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total = 0.5 * (-var_RyR_channel__i_RyR + var_SR_T_current__i_SR_T) / (var_Ca_concentrations_in_SR__V_rel * var_membrane__F); // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup = 0.5 * (-var_SR_L_current__i_SR_L - var_SR_T_current__i_SR_T - var_SR_calcium_pump__i_SR_U) / (var_Ca_concentrations_in_SR__V_up * var_membrane__F); // millimolar / millisecond
        const double var_membrane__R = 8.3142999999999994; // coulomb_millivolt_per_kelvin_millimole
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel_ultra_slow_gate__alpha_y = 1 / (58.0 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm) + 250000.0 * exp(0.1111111111111111 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_ultra_slow_gate__beta_y = 1 / (66.0 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 1800.0 * exp(-0.071428571428571425 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_ultra_slow_gate__y = (1.0 - var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y) * var_L_type_Ca_channel_ultra_slow_gate__alpha_y - var_L_type_Ca_channel_ultra_slow_gate__beta_y * var_chaste_interface__L_type_Ca_channel_ultra_slow_gate__y; // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI = 1 / (11.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 2200000.0 * exp(0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP = 1 / (480.0 * exp(0.14285714285714285 * var_chaste_interface__membrane__Vm) + 2.2000000000000002 * exp(0.015384615384615385 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI = 1 / (2.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.0018 * exp(-0.13513513513513511 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL = var_L_type_Ca_channel_voltage_dependent_gate__k_AP_AI * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI * var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL - (var_L_type_Ca_channel_voltage_dependent_gate__k_AI_AP + var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL; // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP = 1 / (1.5 * exp(-0.015384615384615385 * var_chaste_interface__membrane__Vm) + 0.27000000000000002 * exp(-0.16949152542372881 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL = var_L_type_Ca_channel_voltage_dependent_gate__k_AI_AP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL - (var_L_type_Ca_channel_voltage_dependent_gate__k_AP_AI + var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // 1 / millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI = 0.040000000000000001 / (1.0 + var_L_type_Ca_channel_voltage_dependent_gate__k_AI_AP * var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP * var_L_type_Ca_channel_voltage_dependent_gate__k_RI_AI / (var_L_type_Ca_channel_voltage_dependent_gate__k_AI_RI * var_L_type_Ca_channel_voltage_dependent_gate__k_AP_AI * var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP)); // per_millisecond
        const double var_L_type_Ca_channel_voltage_dependent_gate__k_RI_RP = 0.040000000000000001 - var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI; // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL = var_L_type_Ca_channel_voltage_dependent_gate__k_AP_RP * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL + var_L_type_Ca_channel_voltage_dependent_gate__k_RI_RP * var_L_type_Ca_channel_voltage_dependent_gate__p_RI_CaL - (var_L_type_Ca_channel_voltage_dependent_gate__k_RP_AP + var_L_type_Ca_channel_voltage_dependent_gate__k_RP_RI) * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL; // 1 / millisecond
        const double var_T_type_Ca_channel_y1_gate__alpha_y1 = 1 / (0.019 * exp(-0.17857142857142858 * var_chaste_interface__membrane__Vm) + 0.81999999999999995 * exp(-0.0040000000000000001 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_T_type_Ca_channel_y1_gate__beta_y1 = 1 / (1.5 * exp(0.0001 * var_chaste_interface__membrane__Vm) + 40.0 * exp(0.15873015873015872 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_T_type_Ca_channel_y1_gate__y1 = (1.0 - var_chaste_interface__T_type_Ca_channel_y1_gate__y1) * var_T_type_Ca_channel_y1_gate__alpha_y1 - var_T_type_Ca_channel_y1_gate__beta_y1 * var_chaste_interface__T_type_Ca_channel_y1_gate__y1; // 1 / millisecond
        const double var_T_type_Ca_channel_y2_gate__alpha_y2 = 1 / (30.0 * exp(0.00033333333333333332 * var_chaste_interface__membrane__Vm) + 62000.0 * exp(0.099009900990099015 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_T_type_Ca_channel_y2_gate__beta_y2 = 1 / (1.2 * exp(-0.040000000000000001 * var_chaste_interface__membrane__Vm) + 0.00059999999999999995 * exp(-0.14925373134328357 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_T_type_Ca_channel_y2_gate__y2 = (1.0 - var_chaste_interface__T_type_Ca_channel_y2_gate__y2) * var_T_type_Ca_channel_y2_gate__alpha_y2 - var_T_type_Ca_channel_y2_gate__beta_y2 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2; // 1 / millisecond
        const double var_constant_field_equations__CF_Ca = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Cao) : (2.0 * (-var_external_ion_concentrations__Cao * exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_internal_ion_concentrations__Cai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-2.0 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Ca = var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__iCaL = 0.067599999999999993 * var_constant_field_equations__CF_Ca; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__CaDiadic = var_L_type_Ca_channel__p_open_CaL * var_L_type_Ca_channel_Ca_dependent_gate__iCaL; // picoA
        const double var_L_type_Ca_channel_Ca_dependent_gate__Cacm = -0.29999999999999999 * var_L_type_Ca_channel_Ca_dependent_gate__iCaL + var_internal_ion_concentrations__Cai; // millimolar
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C = var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_C * var_L_type_Ca_channel_Ca_dependent_gate__p_CCa + var_L_type_Ca_channel_Ca_dependent_gate__k_U_C * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - (var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_L_type_Ca_channel_Ca_dependent_gate__k_C_CCa * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL + var_L_type_Ca_channel_Ca_dependent_gate__k_C_U) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C; // 1 / millisecond
        const double var_L_type_Ca_channel_Ca_dependent_gate__CaEffC = var_L_type_Ca_channel_Ca_dependent_gate__Cacm * var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL; // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__CaEffU = (1.0 - var_chaste_interface__L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL) * var_internal_ion_concentrations__Cai + var_L_type_Ca_channel_Ca_dependent_gate__CaEffC; // millimolar
        const double var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca = var_L_type_Ca_channel_Ca_dependent_gate__CaEffU * var_L_type_Ca_channel_Ca_dependent_gate__k_U_UCa; // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U = var_L_type_Ca_channel_Ca_dependent_gate__k_C_U * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_C + var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_U * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa - (var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca + var_L_type_Ca_channel_Ca_dependent_gate__k_U_C) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa = var_L_type_Ca_channel_Ca_dependent_gate__k_CCa_UCa * var_L_type_Ca_channel_Ca_dependent_gate__p_CCa + var_L_type_Ca_channel_Ca_dependent_gate__k_UUCa_Ca * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_U - (var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_CCa + var_L_type_Ca_channel_Ca_dependent_gate__k_UCa_U) * var_chaste_interface__L_type_Ca_channel_Ca_dependent_gate__p_UCa; // 1 / millisecond
        const double var_RyR_channel__k1 = 280000.0 * pow(var_internal_ion_concentrations__Cai, 2) + var_L_type_Ca_channel_Ca_dependent_gate__CaDiadic * var_RyR_channel__Diadid_Factor; // per_millisecond
        const double d_dt_chaste_interface_var_RyR_channel__p_close_RyR = (1.0 - var_chaste_interface__RyR_channel__p_close_RyR - var_chaste_interface__RyR_channel__p_open_RyR) * var_RyR_channel__k3 - (var_RyR_channel__k1 + var_RyR_channel__k4) * var_chaste_interface__RyR_channel__p_close_RyR; // 1 / millisecond
        const double d_dt_chaste_interface_var_RyR_channel__p_open_RyR = var_RyR_channel__k1 * var_chaste_interface__RyR_channel__p_close_RyR - var_RyR_channel__k2 * var_chaste_interface__RyR_channel__p_open_RyR; // 1 / millisecond
        const double var_T_type_Ca_channel__i_Ca_T = var_T_type_Ca_channel__P_CaT * var_chaste_interface__T_type_Ca_channel_y1_gate__y1 * var_chaste_interface__T_type_Ca_channel_y2_gate__y2 * var_constant_field_equations__CF_Ca; // picoA
        const double var_background_Cab_current__i_Cab = var_background_Cab_current__P_Cab * var_constant_field_equations__CF_Ca; // picoA
        const double var_constant_field_equations__CF_K = ((var_chaste_interface__membrane__Vm == 0) ? (var_chaste_interface__internal_ion_concentrations__Ki) : ((-var_external_ion_concentrations__Ko * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Ki) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_K = 0.00036499999999999998 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_K; // picoA
        const double var_background_Kpl_current__i_Kpl = ((var_chaste_interface__membrane__Vm == (-3.0)) ? (13.0077 * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K) : ((3.0 + var_chaste_interface__membrane__Vm) * var_background_Kpl_current__P_Kpl * var_constant_field_equations__CF_K / (1.0 - exp(-0.23076923076923078 - 0.076923076923076927 * var_chaste_interface__membrane__Vm)))); // picoA
        const double var_background_NSC_current__i_bNSC_K = 0.40000000000000002 * var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_K; // picoA
        const double var_background_lCa_current__i_lCa_K = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_K; // picoA
        const double var_constant_field_equations__CF_Na = ((var_chaste_interface__membrane__Vm == 0) ? (-var_external_ion_concentrations__Nao) : ((-var_external_ion_concentrations__Nao * exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)) + var_chaste_interface__internal_ion_concentrations__Nai) * var_membrane__F * var_chaste_interface__membrane__Vm / ((1.0 - exp(-var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T))); // millimolar
        const double var_L_type_Ca_channel__i_CaL_Na = 1.8499999999999999e-5 * var_L_type_Ca_channel__P_CaL * var_L_type_Ca_channel__p_open_CaL * var_constant_field_equations__CF_Na; // picoA
        const double var_background_NSC_current__i_bNSC_Na = var_background_NSC_current__P_bNSC * var_constant_field_equations__CF_Na; // picoA
        const double var_background_lCa_current__i_lCa_Na = var_background_lCa_current__P_lCa * var_background_lCa_current__p_open * var_constant_field_equations__CF_Na; // picoA
        const double var_membrane__i_ext_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_ext = 1000000.0 * var_membrane__Cm_converted * var_membrane__i_ext_converted / HeartConfig::Instance()->GetCapacitance(); // picoA
        const double var_rapid_time_dependent_potassium_current__P_Kr = 0.0086400000000000001; // nanoS_per_picoF
        const double var_rapid_time_dependent_potassium_current__g_Kr = 0.71370912277944121 * pow(var_external_ion_concentrations__Ko, 0.20000000000000001) * mParameters[0] * var_rapid_time_dependent_potassium_current__P_Kr; // nanoS
        const double var_rapid_time_dependent_potassium_current_y1_gate__alpha_y1 = 1 / (5.0 * exp(-0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 20.0 * exp(-0.086956521739130432 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_rapid_time_dependent_potassium_current_y1_gate__beta_y1 = 1 / (160.0 * exp(0.035714285714285712 * var_chaste_interface__membrane__Vm) + 200.0 * exp(0.001 * var_chaste_interface__membrane__Vm)) + 0.00040000000000000002 / exp(0.050000000000000003 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y1_gate__y1 = (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * var_rapid_time_dependent_potassium_current_y1_gate__alpha_y1 - var_rapid_time_dependent_potassium_current_y1_gate__beta_y1 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1; // 1 / millisecond
        const double var_rapid_time_dependent_potassium_current_y2_gate__alpha_y2 = 1 / (20.0 * exp(-0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 200.0 * exp(-0.076923076923076927 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_rapid_time_dependent_potassium_current_y2_gate__beta_y2 = 1 / (1600.0 * exp(0.035714285714285712 * var_chaste_interface__membrane__Vm) + 2000.0 * exp(0.001 * var_chaste_interface__membrane__Vm)) + 0.0001 / exp(0.050000000000000003 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y2_gate__y2 = (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2) * var_rapid_time_dependent_potassium_current_y2_gate__alpha_y2 - var_rapid_time_dependent_potassium_current_y2_gate__beta_y2 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2; // 1 / millisecond
        const double var_rapid_time_dependent_potassium_current_y3_gate__alpha_y3 = 1 / (2.5 * exp(0.0033333333333333335 * var_chaste_interface__membrane__Vm) + 10.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_rapid_time_dependent_potassium_current_y3_gate__beta_y3 = 1 / (2.0 * exp(-0.0066666666666666671 * var_chaste_interface__membrane__Vm) + 0.34999999999999998 * exp(-0.058823529411764705 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y3_gate__y3 = (1.0 - var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3) * var_rapid_time_dependent_potassium_current_y3_gate__alpha_y3 - var_rapid_time_dependent_potassium_current_y3_gate__beta_y3 * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // 1 / millisecond
        const double var_slow_time_dependent_potassium_current__P_Ks_K = 5.04; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current__P_Ks_Na = 0.2016; // picoA_per_millimolar
        const double var_slow_time_dependent_potassium_current_y1_gate__alpha_y1 = 1 / (85.0 * exp(-0.095238095238095233 * var_chaste_interface__membrane__Vm) + 370.0 * exp(-0.016129032258064516 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_slow_time_dependent_potassium_current_y1_gate__beta_y1 = 1 / (260.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 1450.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y1_gate__y1 = (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1) * var_slow_time_dependent_potassium_current_y1_gate__alpha_y1 - var_slow_time_dependent_potassium_current_y1_gate__beta_y1 * var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1; // 1 / millisecond
        const double var_slow_time_dependent_potassium_current_y2_gate__alpha_y2 = 3.7000000000000002 * var_internal_ion_concentrations__Cai; // per_millisecond
        const double var_slow_time_dependent_potassium_current_y2_gate__beta_y2 = 0.004444; // per_millisecond
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2 = (1.0 - var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_slow_time_dependent_potassium_current_y2_gate__alpha_y2 - var_slow_time_dependent_potassium_current_y2_gate__beta_y2 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2; // 1 / millisecond
        const double var_slow_time_dependent_potassium_current__i_Ks_K = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_K * var_slow_time_dependent_potassium_current__P_Ks_K; // picoA
        const double var_slow_time_dependent_potassium_current__i_Ks_Na = pow(var_chaste_interface__slow_time_dependent_potassium_current_y1_gate__y1, 2) * (0.10000000000000001 + 0.90000000000000002 * var_chaste_interface__slow_time_dependent_potassium_current_y2_gate__y2) * var_constant_field_equations__CF_Na * var_slow_time_dependent_potassium_current__P_Ks_Na; // picoA
        const double var_sodium_calcium_exchanger__Km_Cai = 0.0013799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Cao = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nai = 8.75; // millimolar
        const double var_sodium_calcium_exchanger__Km_Nao = 87.5; // millimolar
        const double var_sodium_calcium_exchanger__P_NaCa = 6.8099999999999996; // picoA_per_picoF
        const double var_sodium_calcium_exchanger__Partition = 0.32000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger__k1 = exp(var_membrane__F * var_chaste_interface__membrane__Vm * var_sodium_calcium_exchanger__Partition / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__k2 = exp((-1.0 + var_sodium_calcium_exchanger__Partition) * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // per_millisecond
        const double var_sodium_calcium_exchanger__k3 = 1.0; // per_millisecond
        const double var_sodium_calcium_exchanger__k4 = 1.0; // per_millisecond
        const double var_sodium_calcium_exchanger__p_E1Ca = 1 / (1.0 + (1.0 + pow(var_chaste_interface__internal_ion_concentrations__Nai, 3) / pow(var_sodium_calcium_exchanger__Km_Nai, 3)) * var_sodium_calcium_exchanger__Km_Cai / var_internal_ion_concentrations__Cai); // dimensionless
        const double var_sodium_calcium_exchanger__p_E1Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nai, 3) * (1.0 + var_internal_ion_concentrations__Cai / var_sodium_calcium_exchanger__Km_Cai) / pow(var_chaste_interface__internal_ion_concentrations__Nai, 3)); // dimensionless
        const double var_sodium_calcium_exchanger__p_E2Ca = 1 / (1.0 + (1.0 + pow(var_external_ion_concentrations__Nao, 3) / pow(var_sodium_calcium_exchanger__Km_Nao, 3)) * var_sodium_calcium_exchanger__Km_Cao / var_external_ion_concentrations__Cao); // dimensionless
        const double var_sodium_calcium_exchanger__p_E2Na = 1 / (1.0 + pow(var_sodium_calcium_exchanger__Km_Nao, 3) * (1.0 + var_external_ion_concentrations__Cao / var_sodium_calcium_exchanger__Km_Cao) / pow(var_external_ion_concentrations__Nao, 3)); // dimensionless
        const double var_sodium_calcium_exchanger_y_gate__alpha_y = var_sodium_calcium_exchanger__k2 * var_sodium_calcium_exchanger__p_E2Na + var_sodium_calcium_exchanger__k4 * var_sodium_calcium_exchanger__p_E2Ca; // per_millisecond
        const double var_sodium_calcium_exchanger_y_gate__beta_y = var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na + var_sodium_calcium_exchanger__k3 * var_sodium_calcium_exchanger__p_E1Ca; // per_millisecond
        const double d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y = (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger_y_gate__alpha_y - var_sodium_calcium_exchanger_y_gate__beta_y * var_chaste_interface__sodium_calcium_exchanger_y_gate__y; // 1 / millisecond
        const double var_sodium_calcium_exchanger__i_NaCa = (var_sodium_calcium_exchanger__k1 * var_sodium_calcium_exchanger__p_E1Na * var_chaste_interface__sodium_calcium_exchanger_y_gate__y - (1.0 - var_chaste_interface__sodium_calcium_exchanger_y_gate__y) * var_sodium_calcium_exchanger__k2 * var_sodium_calcium_exchanger__p_E2Na) * mParameters[0] * var_sodium_calcium_exchanger__P_NaCa; // picoA
        const double var_internal_ion_concentrations__i_net_Ca = -2.0 * var_sodium_calcium_exchanger__i_NaCa + var_L_type_Ca_channel__i_CaL_Ca + var_T_type_Ca_channel__i_Ca_T + var_background_Cab_current__i_Cab; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total = 0.5 * (-var_internal_ion_concentrations__i_net_Ca + var_RyR_channel__i_RyR + var_SR_L_current__i_SR_L + var_SR_calcium_pump__i_SR_U) / (var_internal_ion_concentrations__Vi * var_membrane__F) + var_NL_model__dCaidt; // millimolar / millisecond
        const double var_sodium_current__P_Na = 2860.0; // picoA_per_millimolar
        const double var_sodium_current_ultra_slow_gate__alpha_y = 1 / (8000.0 * exp(0.01 * var_chaste_interface__membrane__Vm) + 9000000000.0 * exp(0.20000000000000001 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_ultra_slow_gate__beta_y = 1 / (4000.0 * exp(-0.01 * var_chaste_interface__membrane__Vm) + 0.014 * exp(-0.20000000000000001 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_sodium_current_ultra_slow_gate__y = (1.0 - var_chaste_interface__sodium_current_ultra_slow_gate__y) * var_sodium_current_ultra_slow_gate__alpha_y - var_sodium_current_ultra_slow_gate__beta_y * var_chaste_interface__sodium_current_ultra_slow_gate__y; // 1 / millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AI_AP = 8.7499999999999999e-5; // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AI_RI = 1 / (1300.0 * exp(0.050000000000000003 * var_chaste_interface__membrane__Vm) + 0.040000000000000001 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_AI = 1.25 / exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_AP_RP = 1 / (26.0 * exp(0.058823529411764705 * var_chaste_interface__membrane__Vm) + 0.02 * exp(0.00125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RI_AI = 1 / (5.0 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm) + 0.0001027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_AP = 1 / (0.25 * exp(-0.02 * var_chaste_interface__membrane__Vm) + 0.1027 * exp(-0.125 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RP_RI = 0.01 / (1.0 + var_sodium_current_voltage_dependent_gate__k_AI_AP * var_sodium_current_voltage_dependent_gate__k_AP_RP * var_sodium_current_voltage_dependent_gate__k_RI_AI / (var_sodium_current_voltage_dependent_gate__k_AI_RI * var_sodium_current_voltage_dependent_gate__k_AP_AI * var_sodium_current_voltage_dependent_gate__k_RP_AP)); // per_millisecond
        const double var_sodium_current_voltage_dependent_gate__k_RI_RP = 0.01 - var_sodium_current_voltage_dependent_gate__k_RP_RI; // per_millisecond
        const double var_sodium_current__i_Na_K = 0.10000000000000001 * var_constant_field_equations__CF_K * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double var_sodium_current__i_Na_Na = var_constant_field_equations__CF_Na * var_sodium_current__P_Na * var_chaste_interface__sodium_current_ultra_slow_gate__y * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // picoA
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na = var_sodium_current_voltage_dependent_gate__k_AI_AP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na + var_sodium_current_voltage_dependent_gate__k_RP_AP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na - (var_sodium_current_voltage_dependent_gate__k_AP_AI + var_sodium_current_voltage_dependent_gate__k_AP_RP) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na; // 1 / millisecond
        const double var_sodium_current_voltage_dependent_gate__p_RI_Na = 1.0 - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na - var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // dimensionless
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na = var_sodium_current_voltage_dependent_gate__k_AP_AI * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + var_sodium_current_voltage_dependent_gate__k_RI_AI * var_sodium_current_voltage_dependent_gate__p_RI_Na - (var_sodium_current_voltage_dependent_gate__k_AI_AP + var_sodium_current_voltage_dependent_gate__k_AI_RI) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AI_Na; // 1 / millisecond
        const double d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na = var_sodium_current_voltage_dependent_gate__k_AP_RP * var_chaste_interface__sodium_current_voltage_dependent_gate__p_AP_Na + var_sodium_current_voltage_dependent_gate__k_RI_RP * var_sodium_current_voltage_dependent_gate__p_RI_Na - (var_sodium_current_voltage_dependent_gate__k_RP_AP + var_sodium_current_voltage_dependent_gate__k_RP_RI) * var_chaste_interface__sodium_current_voltage_dependent_gate__p_RP_Na; // 1 / millisecond
        const double var_sodium_potassium_pump__Km_ATP = 0.094; // millimolar
        const double var_sodium_potassium_pump__Km_Ki = 32.880000000000003; // millimolar
        const double var_sodium_potassium_pump__Km_Ko = 0.25800000000000001; // millimolar
        const double var_sodium_potassium_pump__Km_Nai = 4.0499999999999998; // millimolar
        const double var_sodium_potassium_pump__Km_Nao = 69.799999999999997; // millimolar
        const double var_sodium_potassium_pump__Nao_Eff = var_external_ion_concentrations__Nao * exp(-0.81999999999999995 * var_membrane__F * var_chaste_interface__membrane__Vm / (var_membrane__R * var_membrane__T)); // millimolar
        const double var_sodium_potassium_pump__P_NaK = 21.0; // picoA_per_picoF
        const double var_sodium_potassium_pump__k1 = 0.37 / (1.0 + var_sodium_potassium_pump__Km_ATP / var_chaste_interface__ATP_production__ATPi); // per_millisecond
        const double var_sodium_potassium_pump__k2 = 0.040000000000000001; // per_millisecond
        const double var_sodium_potassium_pump__k3 = 0.01; // per_millisecond
        const double var_sodium_potassium_pump__k4 = 0.16500000000000001; // per_millisecond
        const double var_sodium_potassium_pump__p_E1K = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Ki / var_chaste_interface__internal_ion_concentrations__Ki), 1.1200000000000001) * (1.0 + pow((var_chaste_interface__internal_ion_concentrations__Nai / var_sodium_potassium_pump__Km_Nai), 1.0600000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E1Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nai / var_chaste_interface__internal_ion_concentrations__Nai), 1.0600000000000001) * (1.0 + pow((var_chaste_interface__internal_ion_concentrations__Ki / var_sodium_potassium_pump__Km_Ki), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2K = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Ko / var_external_ion_concentrations__Ko), 1.1200000000000001) * (1.0 + pow((var_sodium_potassium_pump__Nao_Eff / var_sodium_potassium_pump__Km_Nao), 1.0600000000000001))); // dimensionless
        const double var_sodium_potassium_pump__p_E2Na = 1 / (1.0 + pow((var_sodium_potassium_pump__Km_Nao / var_sodium_potassium_pump__Nao_Eff), 1.0600000000000001) * (1.0 + pow((var_external_ion_concentrations__Ko / var_sodium_potassium_pump__Km_Ko), 1.1200000000000001))); // dimensionless
        const double var_sodium_potassium_pump_y_gate__alpha_y = var_sodium_potassium_pump__k2 * var_sodium_potassium_pump__p_E2Na + var_sodium_potassium_pump__k4 * var_sodium_potassium_pump__p_E2K; // per_millisecond
        const double var_sodium_potassium_pump_y_gate__beta_y = var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na + var_sodium_potassium_pump__k3 * var_sodium_potassium_pump__p_E1K; // per_millisecond
        const double d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y = (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump_y_gate__alpha_y - var_sodium_potassium_pump_y_gate__beta_y * var_chaste_interface__sodium_potassium_pump_y_gate__y; // 1 / millisecond
        const double var_sodium_potassium_pump__i_NaK = (var_sodium_potassium_pump__k1 * var_sodium_potassium_pump__p_E1Na * var_chaste_interface__sodium_potassium_pump_y_gate__y - (1.0 - var_chaste_interface__sodium_potassium_pump_y_gate__y) * var_sodium_potassium_pump__k2 * var_sodium_potassium_pump__p_E2Na) * mParameters[0] * var_sodium_potassium_pump__P_NaK; // picoA
        const double d_dt_chaste_interface_var_ATP_production__ATPi = (-var_chaste_interface__ATP_production__ATPi + var_ATP_production__Adenosine_Total) * var_ATP_production__ProducingRate_Max - var_sodium_potassium_pump__i_NaK / (var_internal_ion_concentrations__Vi * var_membrane__F) + 0.25 * var_SR_calcium_pump__i_SR_U / (var_internal_ion_concentrations__Vi * var_membrane__F) + var_NL_model__dATPdt; // millimolar / millisecond
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_external_ion_concentrations__Ko / var_chaste_interface__internal_ion_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_background_KATP_current__i_KATP = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * var_background_KATP_current__gamma * var_background_KATP_current__p_open; // picoA
        const double var_rapid_time_dependent_potassium_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (0.40000000000000002 * var_chaste_interface__rapid_time_dependent_potassium_current_y2_gate__y2 + 0.59999999999999998 * var_chaste_interface__rapid_time_dependent_potassium_current_y1_gate__y1) * var_rapid_time_dependent_potassium_current__g_Kr * var_chaste_interface__rapid_time_dependent_potassium_current_y3_gate__y3; // picoA
        const double var_time_independent_potassium_current__P_K1_0 = 1.1459999999999999; // nanoS_per_picoF
        const double var_time_independent_potassium_current__g_K1 = 0.50938071193859957 * pow(var_external_ion_concentrations__Ko, 0.40000000000000002) * mParameters[0] * var_time_independent_potassium_current__P_K1_0; // nanoS
        const double var_time_independent_potassium_current__lambda = 3.0 * (1.0 + exp(-2.4319999999999999 + 0.064000000000000001 * var_chaste_interface__membrane__Vm - 0.064000000000000001 * var_time_independent_potassium_current__E_K)) * exp(0.47999999999999998 + 0.048000000000000001 * var_time_independent_potassium_current__E_K - 0.048000000000000001 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-2.1000000000000001 + 0.029999999999999999 * var_chaste_interface__membrane__Vm - 0.029999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__mu = 0.75 * exp(-0.35000000000000003 + 0.035000000000000003 * var_chaste_interface__membrane__Vm - 0.035000000000000003 * var_time_independent_potassium_current__E_K) / (1.0 + exp(-2.1000000000000001 + 0.014999999999999999 * var_chaste_interface__membrane__Vm - 0.014999999999999999 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current__fB = var_time_independent_potassium_current__mu / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO = var_time_independent_potassium_current__lambda / (var_time_independent_potassium_current__lambda + var_time_independent_potassium_current__mu); // dimensionless
        const double var_time_independent_potassium_current__fO2 = 2.0 * pow(var_time_independent_potassium_current__fB, 2) * pow(var_time_independent_potassium_current__fO, 2); // dimensionless
        const double var_time_independent_potassium_current__fO3 = 2.6666666666666665 * pow(var_time_independent_potassium_current__fO, 3) * var_time_independent_potassium_current__fB; // dimensionless
        const double var_time_independent_potassium_current__fO4 = pow(var_time_independent_potassium_current__fO, 4); // dimensionless
        const double var_time_independent_potassium_current_y_gate__alpha_y = 1 / (7.0 * exp(-0.32333333333333331 + 0.0033333333333333335 * var_chaste_interface__membrane__Vm - 0.0033333333333333335 * var_time_independent_potassium_current__E_K) + 8000.0 * exp(-11.411764705882353 + 0.11764705882352941 * var_chaste_interface__membrane__Vm - 0.11764705882352941 * var_time_independent_potassium_current__E_K)); // per_millisecond
        const double var_time_independent_potassium_current_y_gate__beta_y = pow(var_time_independent_potassium_current__fO, 4) / (0.00013999999999999999 * exp(10.659340659340661 + 0.10989010989010989 * var_time_independent_potassium_current__E_K - 0.10989010989010989 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(0.19400000000000001 + 0.002 * var_time_independent_potassium_current__E_K - 0.002 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y = (1.0 - var_chaste_interface__time_independent_potassium_current_y_gate__y) * var_time_independent_potassium_current_y_gate__alpha_y - var_time_independent_potassium_current_y_gate__beta_y * var_chaste_interface__time_independent_potassium_current_y_gate__y; // 1 / millisecond
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__Vm) * (var_time_independent_potassium_current__fO2 + var_time_independent_potassium_current__fO3 + var_time_independent_potassium_current__fO4) * var_time_independent_potassium_current__g_K1 * var_chaste_interface__time_independent_potassium_current_y_gate__y; // picoA
        const double var_transient_outward_current__P_to_K = 0.033000000000000002; // picoA_per_millimolar
        const double var_transient_outward_current__P_to_Na = 0.00297; // picoA_per_millimolar
        const double var_transient_outward_current_y1_gate__alpha_y1 = 1 / (11.0 * exp(-0.035714285714285712 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(-0.0025000000000000001 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_transient_outward_current_y1_gate__beta_y1 = 1 / (4.4000000000000004 * exp(0.0625 * var_chaste_interface__membrane__Vm) + 0.20000000000000001 * exp(0.002 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_y1_gate__y1 = (1.0 - var_chaste_interface__transient_outward_current_y1_gate__y1) * var_transient_outward_current_y1_gate__alpha_y1 - var_transient_outward_current_y1_gate__beta_y1 * var_chaste_interface__transient_outward_current_y1_gate__y1; // 1 / millisecond
        const double var_transient_outward_current_y2_gate__alpha_y2 = 0.0038 * exp(-1.1946902654867255 - 0.088495575221238937 * var_chaste_interface__membrane__Vm) / (1.0 + 0.051334999999999999 * exp(-1.1946902654867255 - 0.088495575221238937 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double var_transient_outward_current_y2_gate__beta_y2 = 0.0038 * exp(1.1946902654867255 + 0.088495575221238937 * var_chaste_interface__membrane__Vm) / (1.0 + 0.067083000000000004 * exp(1.1946902654867255 + 0.088495575221238937 * var_chaste_interface__membrane__Vm)); // per_millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_y2_gate__y2 = (1.0 - var_chaste_interface__transient_outward_current_y2_gate__y2) * var_transient_outward_current_y2_gate__alpha_y2 - var_transient_outward_current_y2_gate__beta_y2 * var_chaste_interface__transient_outward_current_y2_gate__y2; // 1 / millisecond
        const double var_transient_outward_current__i_to_K = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_K * var_transient_outward_current__P_to_K * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_internal_ion_concentrations__i_net_K = -2.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_CaL_K + var_background_KATP_current__i_KATP + var_background_Kpl_current__i_Kpl + var_background_NSC_current__i_bNSC_K + var_background_lCa_current__i_lCa_K + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks_K + var_sodium_current__i_Na_K + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to_K; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Ki = (-var_internal_ion_concentrations__i_net_K - var_membrane__i_ext) / (var_internal_ion_concentrations__Vi * var_membrane__F); // millimolar / millisecond
        const double var_transient_outward_current__i_to_Na = pow(var_chaste_interface__transient_outward_current_y1_gate__y1, 3) * var_constant_field_equations__CF_Na * var_transient_outward_current__P_to_Na * var_chaste_interface__transient_outward_current_y2_gate__y2; // picoA
        const double var_internal_ion_concentrations__i_net_Na = 3.0 * var_sodium_calcium_exchanger__i_NaCa + 3.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_CaL_Na + var_background_NSC_current__i_bNSC_Na + var_background_lCa_current__i_lCa_Na + var_slow_time_dependent_potassium_current__i_Ks_Na + var_sodium_current__i_Na_Na + var_transient_outward_current__i_to_Na; // picoA
        const double d_dt_chaste_interface_var_internal_ion_concentrations__Nai = -var_internal_ion_concentrations__i_net_Na / (var_internal_ion_concentrations__Vi * var_membrane__F); // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__Vm = 0.0;
        }
        else
        {
            const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaL_Ca + var_L_type_Ca_channel__i_CaL_K + var_L_type_Ca_channel__i_CaL_Na; // picoA
            const double var_background_NSC_current__i_bNSC = var_background_NSC_current__i_bNSC_K + var_background_NSC_current__i_bNSC_Na; // picoA
            const double var_background_lCa_current__i_lCa = var_background_lCa_current__i_lCa_K + var_background_lCa_current__i_lCa_Na; // picoA
            const double var_slow_time_dependent_potassium_current__i_Ks = var_slow_time_dependent_potassium_current__i_Ks_K + var_slow_time_dependent_potassium_current__i_Ks_Na; // picoA
            const double var_sodium_current__i_Na = var_sodium_current__i_Na_K + var_sodium_current__i_Na_Na; // picoA
            const double var_membrane__i_I = var_background_Cab_current__i_Cab + var_background_KATP_current__i_KATP + var_background_Kpl_current__i_Kpl + var_background_NSC_current__i_bNSC + var_background_lCa_current__i_lCa; // picoA
            const double var_transient_outward_current__i_to = var_transient_outward_current__i_to_K + var_transient_outward_current__i_to_Na; // picoA
            const double var_membrane__i_tot = var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_membrane__i_I + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks + var_sodium_calcium_exchanger__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to; // picoA
            d_dt_chaste_interface_var_membrane__Vm = (-var_membrane__i_ext - var_membrane__i_tot) / mParameters[0]; // millivolt / millisecond
        }
        
        rDY[0] = d_dt_chaste_interface_var_membrane__Vm;
        rDY[1] = d_dt_chaste_interface_var_internal_ion_concentrations__Nai;
        rDY[2] = d_dt_chaste_interface_var_internal_ion_concentrations__Ki;
        rDY[3] = d_dt_chaste_interface_var_internal_ion_concentrations__Ca_Total;
        rDY[4] = d_dt_chaste_interface_var_ATP_production__ATPi;
        rDY[5] = d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AP_Na;
        rDY[6] = d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_RP_Na;
        rDY[7] = d_dt_chaste_interface_var_sodium_current_voltage_dependent_gate__p_AI_Na;
        rDY[8] = d_dt_chaste_interface_var_sodium_current_ultra_slow_gate__y;
        rDY[9] = d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL;
        rDY[10] = d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL;
        rDY[11] = d_dt_chaste_interface_var_L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL;
        rDY[12] = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_U;
        rDY[13] = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_UCa;
        rDY[14] = d_dt_chaste_interface_var_L_type_Ca_channel_Ca_dependent_gate__p_C;
        rDY[15] = d_dt_chaste_interface_var_L_type_Ca_channel_ultra_slow_gate__y;
        rDY[16] = d_dt_chaste_interface_var_T_type_Ca_channel_y1_gate__y1;
        rDY[17] = d_dt_chaste_interface_var_T_type_Ca_channel_y2_gate__y2;
        rDY[18] = d_dt_chaste_interface_var_time_independent_potassium_current_y_gate__y;
        rDY[19] = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y1_gate__y1;
        rDY[20] = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y2_gate__y2;
        rDY[21] = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_y3_gate__y3;
        rDY[22] = d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y1_gate__y1;
        rDY[23] = d_dt_chaste_interface_var_slow_time_dependent_potassium_current_y2_gate__y2;
        rDY[24] = d_dt_chaste_interface_var_transient_outward_current_y1_gate__y1;
        rDY[25] = d_dt_chaste_interface_var_transient_outward_current_y2_gate__y2;
        rDY[26] = d_dt_chaste_interface_var_sodium_calcium_exchanger_y_gate__y;
        rDY[27] = d_dt_chaste_interface_var_sodium_potassium_pump_y_gate__y;
        rDY[28] = d_dt_chaste_interface_var_SR_calcium_pump_y_gate__y;
        rDY[29] = d_dt_chaste_interface_var_RyR_channel__p_open_RyR;
        rDY[30] = d_dt_chaste_interface_var_RyR_channel__p_close_RyR;
        rDY[31] = d_dt_chaste_interface_var_Ca_concentrations_in_SR__Ca_Total;
        rDY[32] = d_dt_chaste_interface_var_Ca_concentrations_in_SR__Caup;
        rDY[33] = d_dt_chaste_interface_var_NL_model__pCa;
        rDY[34] = d_dt_chaste_interface_var_NL_model__pCaCB;
        rDY[35] = d_dt_chaste_interface_var_NL_model__pCB;
        rDY[36] = d_dt_chaste_interface_var_NL_model__X;
    }

    std::vector<double> Cellmatsuoka_model_2003FromCellML::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__internal_ion_concentrations__Ca_Total = rY[3];
        // Units: millimolar; Initial value: 0.00040180173572968586
        

        // Mathematics
        const double var_internal_ion_concentrations__CMDN_max = 0.050000000000000003; // millimolar
        const double var_internal_ion_concentrations__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_internal_ion_concentrations__b1 = -var_chaste_interface__internal_ion_concentrations__Ca_Total + var_internal_ion_concentrations__CMDN_max + var_internal_ion_concentrations__K_mCMDN; // millimolar
        const double var_internal_ion_concentrations__c1 = var_chaste_interface__internal_ion_concentrations__Ca_Total * var_internal_ion_concentrations__K_mCMDN; // millimolar2
        const double var_internal_ion_concentrations__Cai = sqrt(0.25 * pow(var_internal_ion_concentrations__b1, 2) + var_internal_ion_concentrations__c1) - 0.5 * var_internal_ion_concentrations__b1; // millimolar
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF
        const double var_membrane__i_ext_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(4);
        dqs[0] = var_internal_ion_concentrations__Cai;
        dqs[1] = var_chaste_interface__environment__time;
        dqs[2] = var_membrane__Cm_converted;
        dqs[3] = var_membrane__i_ext_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellmatsuoka_model_2003FromCellML>::Initialise(void)
{
    this->mSystemName = "matsuoka_model_2003";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-85.95752434460744);

    // rY[1]:
    this->mVariableNames.push_back("internal_ion_concentrations__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(4.925761439682025);

    // rY[2]:
    this->mVariableNames.push_back("internal_ion_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(143.1837333000449);

    // rY[3]:
    this->mVariableNames.push_back("internal_ion_concentrations__Ca_Total");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00040180173572968586);

    // rY[4]:
    this->mVariableNames.push_back("ATP_production__ATPi");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(4.657102729020499);

    // rY[5]:
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_AP_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.779648367445368e-05);

    // rY[6]:
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_RP_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3556412697995689);

    // rY[7]:
    this->mVariableNames.push_back("sodium_current_voltage_dependent_gate__p_AI_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.40285968661346977);

    // rY[8]:
    this->mVariableNames.push_back("sodium_current_ultra_slow_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5861887862983165);

    // rY[9]:
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_AP_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.5445004166497696e-06);

    // rY[10]:
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_RP_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9968480629364956);

    // rY[11]:
    this->mVariableNames.push_back("L_type_Ca_channel_voltage_dependent_gate__p_AI_CaL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000877325391245903);

    // rY[12]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_U");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.17246483915629204);

    // rY[13]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_UCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.098246017787626e-05);

    // rY[14]:
    this->mVariableNames.push_back("L_type_Ca_channel_Ca_dependent_gate__p_C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4250747299372254);

    // rY[15]:
    this->mVariableNames.push_back("L_type_Ca_channel_ultra_slow_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9985266538252986);

    // rY[16]:
    this->mVariableNames.push_back("T_type_Ca_channel_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.6882718240109127e-05);

    // rY[17]:
    this->mVariableNames.push_back("T_type_Ca_channel_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8585352091865849);

    // rY[18]:
    this->mVariableNames.push_back("time_independent_potassium_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.6080573900752752);

    // rY[19]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0018339931180983765);

    // rY[20]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.20443083454225305);

    // rY[21]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_y3_gate__y3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.967887666264921);

    // rY[22]:
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09738789658609195);

    // rY[23]:
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09745345578743213);

    // rY[24]:
    this->mVariableNames.push_back("transient_outward_current_y1_gate__y1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0007956883250874798);

    // rY[25]:
    this->mVariableNames.push_back("transient_outward_current_y2_gate__y2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999125083105881);

    // rY[26]:
    this->mVariableNames.push_back("sodium_calcium_exchanger_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9891789193465331);

    // rY[27]:
    this->mVariableNames.push_back("sodium_potassium_pump_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5910747147428818);

    // rY[28]:
    this->mVariableNames.push_back("SR_calcium_pump_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.46108441538480216);

    // rY[29]:
    this->mVariableNames.push_back("RyR_channel__p_open_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00034314360001543243);

    // rY[30]:
    this->mVariableNames.push_back("RyR_channel__p_close_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.19135178123107768);

    // rY[31]:
    this->mVariableNames.push_back("Ca_concentrations_in_SR__Ca_Total");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.455741736977666);

    // rY[32]:
    this->mVariableNames.push_back("Ca_concentrations_in_SR__Caup");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.611712901567567);

    // rY[33]:
    this->mVariableNames.push_back("NL_model__pCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02490898775497523);

    // rY[34]:
    this->mVariableNames.push_back("NL_model__pCaCB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001990153835322864);

    // rY[35]:
    this->mVariableNames.push_back("NL_model__pCB");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00042941813853474524);

    // rY[36]:
    this->mVariableNames.push_back("NL_model__X");
    this->mVariableUnits.push_back("micrometre");
    this->mInitialConditions.push_back(0.9573749975411884);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("picoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("cytosolic_calcium_concentration");
    this->mDerivedQuantityUnits.push_back("millimolar");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    // Derived Quantity index [3]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellmatsuoka_model_2003FromCellML)
