//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: Noble_SAN_model_1989
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "noble_SAN_model_1989.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellnoble_SAN_model_1989FromCellMLGRL2Opt::Cellnoble_SAN_model_1989FromCellMLGRL2Opt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                14,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellnoble_SAN_model_1989FromCellMLGRL2Opt>::Instance();
        Init();
        
        this->mParameters[0] = 6.0000000000000002e-5; // (var_membrane__C) [microF]
    }

    Cellnoble_SAN_model_1989FromCellMLGRL2Opt::~Cellnoble_SAN_model_1989FromCellMLGRL2Opt()
    {
    }
    
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        
        const double var_hyperpolarising_activated_current__E_K = 26.713760659695652 * log(3.0 / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = 26.713760659695652 * log(140.0 / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = 2.0000000000000002e-5 * (2.0 * pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0) * exp(0.018716945411372737 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_calcium_concentration__Cai * exp(-0.018716945411372737 * var_chaste_interface__membrane__V)) / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + 0.00020000000000000001 * pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0) + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai)); // nanoA
        const double var_calcium_background_current__i_Ca_b = 0.0001 * var_chaste_interface__membrane__V - 0.0013356880329847825 * log(2.0 / var_chaste_interface__intracellular_calcium_concentration__Cai); // nanoA
        const double var_fast_sodium_current__i_Na = 0.012500000000000001 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(140.36000000000001 / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)) + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_f = 0.0037499999999999999 * pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) + 0.0037499999999999999 * pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V); // nanoA
        const double var_second_inward_current__i_si = 0.017968267594917826 * (-50.0 + var_chaste_interface__membrane__V) * (-2.0 * exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_calcium_concentration__Cai * exp(3.7433890822745473)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane__V)) + 4.4920668987294567e-5 * (-50.0 + var_chaste_interface__membrane__V) * (-3.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_potassium_concentration__Ki * exp(1.8716945411372736)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V)) + 4.4920668987294567e-5 * (-50.0 + var_chaste_interface__membrane__V) * (-140.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_sodium_concentration__Nai * exp(1.8716945411372736)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_sodium_background_current__i_Na_b = 0.00069999999999999999 * var_chaste_interface__membrane__V - 0.00069999999999999999 * var_hyperpolarising_activated_current__E_Na; // nanoA
        const double var_sodium_potassium_pump__i_p = 0.33750000000000002 * var_chaste_interface__intracellular_sodium_concentration__Nai / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Nai); // nanoA
        const double var_time_dependent_potassium_current__i_K = (0.0057142857142857143 * var_chaste_interface__intracellular_potassium_concentration__Ki - 0.017142857142857144 * exp(-0.037433890822745473 * var_chaste_interface__membrane__V)) * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__i_K1 = 0.0017307692307692306 * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(0.74867781645490938 + 0.074867781645490947 * var_chaste_interface__membrane__V - 0.074867781645490947 * var_hyperpolarising_activated_current__E_K)); // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_Na_Ca_exchanger__i_NaCa + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_hyperpolarising_activated_current__i_f + var_second_inward_current__i_si + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_p + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellnoble_SAN_model_1989FromCellMLGRL2Opt::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_hyperpolarising_activated_current__E_K = 26.713760659695652 * log(3.0 / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = 26.713760659695652 * log(140.0 / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = 2.0000000000000002e-5 * (2.0 * pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0) * exp(0.018716945411372737 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_calcium_concentration__Cai * exp(-0.018716945411372737 * var_chaste_interface__membrane__V)) / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + 0.00020000000000000001 * pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0) + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai)); // nanoA
        const double var_calcium_background_current__i_Ca_b = 0.0001 * var_chaste_interface__membrane__V - 0.0013356880329847825 * log(2.0 / var_chaste_interface__intracellular_calcium_concentration__Cai); // nanoA
        const double var_fast_sodium_current__i_Na = 0.012500000000000001 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(140.36000000000001 / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)) + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fK = 0.0037499999999999999 * pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = 0.0037499999999999999 * pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V); // nanoA
        const double var_second_inward_current__i_siCa = 0.017968267594917826 * (-50.0 + var_chaste_interface__membrane__V) * (-2.0 * exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_calcium_concentration__Cai * exp(3.7433890822745473)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane__V)); // nanoA
        const double var_second_inward_current__i_siK = 4.4920668987294567e-5 * (-50.0 + var_chaste_interface__membrane__V) * (-3.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_potassium_concentration__Ki * exp(1.8716945411372736)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_second_inward_current__i_siNa = 4.4920668987294567e-5 * (-50.0 + var_chaste_interface__membrane__V) * (-140.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_sodium_concentration__Nai * exp(1.8716945411372736)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_sodium_background_current__i_Na_b = 0.00069999999999999999 * var_chaste_interface__membrane__V - 0.00069999999999999999 * var_hyperpolarising_activated_current__E_Na; // nanoA
        const double var_sodium_potassium_pump__i_p = 0.33750000000000002 * var_chaste_interface__intracellular_sodium_concentration__Nai / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Nai); // nanoA
        const double var_time_dependent_potassium_current__i_K = (0.0057142857142857143 * var_chaste_interface__intracellular_potassium_concentration__Ki - 0.017142857142857144 * exp(-0.037433890822745473 * var_chaste_interface__membrane__V)) * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__i_K1 = 0.0017307692307692306 * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(0.74867781645490938 + 0.074867781645490947 * var_chaste_interface__membrane__V - 0.074867781645490947 * var_hyperpolarising_activated_current__E_K)); // nanoA
        d_dt_chaste_interface_var_membrane__V = 0.001 * (-var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_hyperpolarising_activated_current__i_fK - var_hyperpolarising_activated_current__i_fNa - var_second_inward_current__i_siCa - var_second_inward_current__i_siK - var_second_inward_current__i_siNa - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_p - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1) / mParameters[0]; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Cellnoble_SAN_model_1989FromCellMLGRL2Opt::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[10];
        // Units: millimolar; Initial value: 2.3909
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[11];
        // Units: millimolar; Initial value: 0.2207
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.237
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        
        
        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_intracellular_calcium_concentration__i_rel = 3.0554258119568201 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel / (3.9999999999999998e-6 + pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0)); // nanoA
        const double var_intracellular_calcium_concentration__i_tr = 0.152771290597841 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_rel + var_chaste_interface__intracellular_calcium_concentration__Ca_up) * var_chaste_interface__intracellular_calcium_concentration__p; // nanoA
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel = 0.032728662436727896 * var_intracellular_calcium_concentration__i_tr - 0.032728662436727896 * var_intracellular_calcium_concentration__i_rel; // millimolar / millisecond
        const double var_intracellular_calcium_concentration__i_up = 61.108516239136399 * (5.0 - var_chaste_interface__intracellular_calcium_concentration__Ca_up) * var_chaste_interface__intracellular_calcium_concentration__Cai; // nanoA
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up = 0.013091464974691156 * var_intracellular_calcium_concentration__i_up - 0.013091464974691156 * var_intracellular_calcium_concentration__i_tr; // millimolar / millisecond
        const double var_hyperpolarising_activated_current__E_K = 26.713760659695652 * log(3.0 / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = 26.713760659695652 * log(140.0 / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = 2.0000000000000002e-5 * (2.0 * pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0) * exp(0.018716945411372737 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_calcium_concentration__Cai * exp(-0.018716945411372737 * var_chaste_interface__membrane__V)) / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + 0.00020000000000000001 * pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0) + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai)); // nanoA
        const double var_calcium_background_current__i_Ca_b = 0.0001 * var_chaste_interface__membrane__V - 0.0013356880329847825 * log(2.0 / var_chaste_interface__intracellular_calcium_concentration__Cai); // nanoA
        const double var_fast_sodium_current__i_Na = 0.012500000000000001 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(140.36000000000001 / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)) + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = 0.02 * (1.0 - var_chaste_interface__fast_sodium_current_h_gate__h) * exp(-9.375 - 0.125 * var_chaste_interface__membrane__V) - 2.0 * var_chaste_interface__fast_sodium_current_h_gate__h / (1.0 + 320.0 * exp(-7.5 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * ((fabs(41.0 + var_chaste_interface__membrane__V) < 1.0000000000000001e-5) ? (2000.0) : (200.0 * (41.0 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.1000000000000005 - 0.10000000000000001 * var_chaste_interface__membrane__V)))) - 8.0 * var_chaste_interface__fast_sodium_current_m_gate__m * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V); // 1 / millisecond
        const double var_hyperpolarising_activated_current__i_fK = 0.0037499999999999999 * pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = 0.0037499999999999999 * pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V); // nanoA
        const double d_dt_chaste_interface_var_hyperpolarising_activated_current_y_gate__y = 2.8e-5 * (1.0 - var_chaste_interface__hyperpolarising_activated_current_y_gate__y) * exp(-0.0625 * var_chaste_interface__membrane__V) - 0.0195 * var_chaste_interface__hyperpolarising_activated_current_y_gate__y * exp(0.052631578947368418 * var_chaste_interface__membrane__V); // 1 / millisecond
        const double var_intracellular_calcium_concentration__E0_p = 64.0 + var_chaste_interface__membrane__V; // millivolt
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__p = -0.0050000000000000001 * var_chaste_interface__intracellular_calcium_concentration__p / (1.0 + exp(-0.25 * var_intracellular_calcium_concentration__E0_p)) + 0.00062500000000000001 * (1.0 - var_chaste_interface__intracellular_calcium_concentration__p) * var_intracellular_calcium_concentration__E0_p / (-1.0 + exp(0.25 * var_intracellular_calcium_concentration__E0_p)); // 1 / millisecond
        const double var_second_inward_current_d_gate__E0_d = 19.0 + var_chaste_interface__membrane__V; // millivolt
        const double d_dt_chaste_interface_var_second_inward_current_d_gate__d = 0.001 * (1.0 - var_chaste_interface__second_inward_current_d_gate__d) * ((fabs(var_second_inward_current_d_gate__E0_d) < 0.0001) ? (120.0) : (30.0 * var_second_inward_current_d_gate__E0_d / (1.0 - exp(-0.25 * var_second_inward_current_d_gate__E0_d)))) - 0.001 * ((fabs(var_second_inward_current_d_gate__E0_d) < 0.0001) ? (120.0) : (12.0 * var_second_inward_current_d_gate__E0_d / (-1.0 + exp(0.10000000000000001 * var_second_inward_current_d_gate__E0_d)))) * var_chaste_interface__second_inward_current_d_gate__d; // 1 / millisecond
        const double d_dt_chaste_interface_var_second_inward_current_f2_gate__f2 = 0.01 - 0.001 * (10.0 + 20000.0 * var_chaste_interface__intracellular_calcium_concentration__Cai) * var_chaste_interface__second_inward_current_f2_gate__f2; // 1 / millisecond
        const double var_second_inward_current__i_siCa = 0.017968267594917826 * (-50.0 + var_chaste_interface__membrane__V) * (-2.0 * exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_calcium_concentration__Cai * exp(3.7433890822745473)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane__V)); // nanoA
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai = 0.00065457324873455789 * var_intracellular_calcium_concentration__i_rel + 0.0013091464974691158 * var_Na_Ca_exchanger__i_NaCa - 0.00065457324873455789 * var_calcium_background_current__i_Ca_b - 0.00065457324873455789 * var_intracellular_calcium_concentration__i_up - 0.00065457324873455789 * var_second_inward_current__i_siCa; // millimolar / millisecond
        const double var_second_inward_current__i_siK = 4.4920668987294567e-5 * (-50.0 + var_chaste_interface__membrane__V) * (-3.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_potassium_concentration__Ki * exp(1.8716945411372736)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_second_inward_current__i_siNa = 4.4920668987294567e-5 * (-50.0 + var_chaste_interface__membrane__V) * (-140.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_sodium_concentration__Nai * exp(1.8716945411372736)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double d_dt_chaste_interface_var_second_inward_current_f_gate__f = 0.001 * (1.0 - var_chaste_interface__second_inward_current_f_gate__f) * ((fabs(34.0 + var_chaste_interface__membrane__V) < 0.0001) ? (25.0) : (6.25 * (34.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(8.5 + 0.25 * var_chaste_interface__membrane__V)))) - 0.050000000000000003 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 + exp(-8.5 - 0.25 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double var_sodium_background_current__i_Na_b = 0.00069999999999999999 * var_chaste_interface__membrane__V - 0.00069999999999999999 * var_hyperpolarising_activated_current__E_Na; // nanoA
        const double var_sodium_potassium_pump__i_p = 0.33750000000000002 * var_chaste_interface__intracellular_sodium_concentration__Nai / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Nai); // nanoA
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai = -0.0013091464974691158 * var_fast_sodium_current__i_Na - 0.0013091464974691158 * var_hyperpolarising_activated_current__i_fNa - 0.0013091464974691158 * var_second_inward_current__i_siNa - 0.0013091464974691158 * var_sodium_background_current__i_Na_b - 0.0039274394924073471 * var_Na_Ca_exchanger__i_NaCa - 0.0039274394924073471 * var_sodium_potassium_pump__i_p; // millimolar / millisecond
        const double var_time_dependent_potassium_current__i_K = (0.0057142857142857143 * var_chaste_interface__intracellular_potassium_concentration__Ki - 0.017142857142857144 * exp(-0.037433890822745473 * var_chaste_interface__membrane__V)) * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double d_dt_chaste_interface_var_time_dependent_potassium_current_x_gate__x = 0.0021000000000000003 * (1.0 - var_chaste_interface__time_dependent_potassium_current_x_gate__x) * exp(0.035714285714285712 * var_chaste_interface__membrane__V) - 0.00095999999999999992 * var_chaste_interface__time_dependent_potassium_current_x_gate__x * exp(-0.041666666666666664 * var_chaste_interface__membrane__V); // 1 / millisecond
        const double var_time_independent_potassium_current__i_K1 = 0.0017307692307692306 * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(0.74867781645490938 + 0.074867781645490947 * var_chaste_interface__membrane__V - 0.074867781645490947 * var_hyperpolarising_activated_current__E_K)); // nanoA
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki = 0.0026182929949382316 * var_sodium_potassium_pump__i_p - 0.0013091464974691158 * var_hyperpolarising_activated_current__i_fK - 0.0013091464974691158 * var_second_inward_current__i_siK - 0.0013091464974691158 * var_time_dependent_potassium_current__i_K - 0.0013091464974691158 * var_time_independent_potassium_current__i_K1; // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__V = 0.001 * (-var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_hyperpolarising_activated_current__i_fK - var_hyperpolarising_activated_current__i_fNa - var_second_inward_current__i_siCa - var_second_inward_current__i_siK - var_second_inward_current__i_siNa - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_p - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1) / mParameters[0]; // millivolt / millisecond
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        mEvalF[1] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai;
        mEvalF[2] = d_dt_chaste_interface_var_hyperpolarising_activated_current_y_gate__y;
        mEvalF[3] = d_dt_chaste_interface_var_time_dependent_potassium_current_x_gate__x;
        mEvalF[4] = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        mEvalF[5] = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        mEvalF[6] = d_dt_chaste_interface_var_second_inward_current_d_gate__d;
        mEvalF[7] = d_dt_chaste_interface_var_second_inward_current_f_gate__f;
        mEvalF[8] = d_dt_chaste_interface_var_second_inward_current_f2_gate__f2;
        mEvalF[9] = d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai;
        mEvalF[10] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up;
        mEvalF[11] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel;
        mEvalF[12] = d_dt_chaste_interface_var_intracellular_calcium_concentration__p;
        mEvalF[13] = d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        rY[13] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        
        
        // Mathematics
        const double var_hyperpolarising_activated_current__E_K = 26.713760659695652 * log(3.0 / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = 26.713760659695652 * log(140.0 / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = 2.0000000000000002e-5 * (2.0 * pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0) * exp(0.018716945411372737 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_calcium_concentration__Cai * exp(-0.018716945411372737 * var_chaste_interface__membrane__V)) / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + 0.00020000000000000001 * pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0) + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai)); // nanoA
        const double var_calcium_background_current__i_Ca_b = 0.0001 * var_chaste_interface__membrane__V - 0.0013356880329847825 * log(2.0 / var_chaste_interface__intracellular_calcium_concentration__Cai); // nanoA
        const double var_fast_sodium_current__i_Na = 0.012500000000000001 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(140.36000000000001 / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)) + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fK = 0.0037499999999999999 * pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = 0.0037499999999999999 * pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V); // nanoA
        const double var_second_inward_current__i_siCa = 0.017968267594917826 * (-50.0 + var_chaste_interface__membrane__V) * (-2.0 * exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_calcium_concentration__Cai * exp(3.7433890822745473)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane__V)); // nanoA
        const double var_second_inward_current__i_siK = 4.4920668987294567e-5 * (-50.0 + var_chaste_interface__membrane__V) * (-3.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_potassium_concentration__Ki * exp(1.8716945411372736)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_second_inward_current__i_siNa = 4.4920668987294567e-5 * (-50.0 + var_chaste_interface__membrane__V) * (-140.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_sodium_concentration__Nai * exp(1.8716945411372736)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_sodium_background_current__i_Na_b = 0.00069999999999999999 * var_chaste_interface__membrane__V - 0.00069999999999999999 * var_hyperpolarising_activated_current__E_Na; // nanoA
        const double var_sodium_potassium_pump__i_p = 0.33750000000000002 * var_chaste_interface__intracellular_sodium_concentration__Nai / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Nai); // nanoA
        const double var_time_dependent_potassium_current__i_K = (0.0057142857142857143 * var_chaste_interface__intracellular_potassium_concentration__Ki - 0.017142857142857144 * exp(-0.037433890822745473 * var_chaste_interface__membrane__V)) * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__i_K1 = 0.0017307692307692306 * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(0.74867781645490938 + 0.074867781645490947 * var_chaste_interface__membrane__V - 0.074867781645490947 * var_hyperpolarising_activated_current__E_K)); // nanoA
        d_dt_chaste_interface_var_membrane__V = 0.001 * (-var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_hyperpolarising_activated_current__i_fK - var_hyperpolarising_activated_current__i_fNa - var_second_inward_current__i_siCa - var_second_inward_current__i_siK - var_second_inward_current__i_siNa - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_p - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1) / mParameters[0]; // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane__V;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
            // Units: millimolar; Initial value: 5.6e-05
            double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
            // Units: dimensionless; Initial value: 0.0822
            double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
            // Units: dimensionless; Initial value: 0.1231
            double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
            // Units: dimensionless; Initial value: 0.0365
            double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
            // Units: dimensionless; Initial value: 0.1969
            double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
            // Units: dimensionless; Initial value: 0.9997
            double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
            // Units: dimensionless; Initial value: 0.5765
            double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
            // Units: millimolar; Initial value: 7.5
            double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
            // Units: millimolar; Initial value: 140.0
            
            const double var_x0 = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2);
            const double var_x1 = 0.074867781645490947 * var_chaste_interface__membrane__V;
            const double var_x2 = 1 / var_chaste_interface__intracellular_potassium_concentration__Ki;
            const double var_x3 = log(3.0 * var_x2);
            const double var_x4 = exp(0.74867781645490938 + var_x1 - 2.0 * var_x3);
            const double var_x5 = 1.0 + var_x4;
            const double var_x6 = 1 / var_x5;
            const double var_x7 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
            const double var_x8 = var_x7 * var_chaste_interface__fast_sodium_current_h_gate__h;
            const double var_x9 = -0.037433890822745473 * var_chaste_interface__membrane__V;
            const double var_x10 = exp(var_x9);
            const double var_x11 = var_x10 * var_chaste_interface__time_dependent_potassium_current_x_gate__x;
            const double var_x12 = -26.713760659695652 * var_x3 + var_chaste_interface__membrane__V;
            const double var_x13 = var_x12 * var_x4 / pow(var_x5, 2);
            const double var_x14 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0);
            const double var_x15 = 0.018716945411372737 * var_chaste_interface__membrane__V;
            const double var_x16 = exp(var_x15);
            const double var_x17 = var_x14 * var_x16;
            const double var_x18 = exp(-var_x15);
            const double var_x19 = var_x18 * var_chaste_interface__intracellular_calcium_concentration__Cai;
            const double var_x20 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai);
            const double var_x21 = 1 / (1.0 + 0.00020000000000000001 * var_x14 + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai);
            const double var_x22 = var_x20 * var_x21;
            const double var_x23 = var_x22 * (0.037433890822745473 * var_x17 + 51359.298208806787 * var_x19);
            const double var_x24 = var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f;
            const double var_x25 = var_x24 * var_chaste_interface__second_inward_current_d_gate__d;
            const double var_x26 = exp(3.7433890822745473 - var_x1);
            const double var_x27 = 1.0 - var_x26;
            const double var_x28 = 1 / var_x27;
            const double var_x29 = exp(3.7433890822745473);
            const double var_x30 = -2.0 * var_x26 + var_x29 * var_chaste_interface__intracellular_calcium_concentration__Cai;
            const double var_x31 = var_x28 * var_x30;
            const double var_x32 = 0.017968267594917826 * var_x31;
            const double var_x33 = exp(1.8716945411372736 + var_x9);
            const double var_x34 = 1.0 - var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x36 = 4.4920668987294567e-5 * var_x35;
            const double var_x37 = exp(1.8716945411372736);
            const double var_x38 = -3.0 * var_x33 + var_x37 * var_chaste_interface__intracellular_potassium_concentration__Ki;
            const double var_x39 = var_x25 * var_x38;
            const double var_x40 = -140.0 * var_x33 + var_x37 * var_chaste_interface__intracellular_sodium_concentration__Nai;
            const double var_x41 = var_x36 * var_x40;
            const double var_x42 = -50.0 + var_chaste_interface__membrane__V;
            const double var_x43 = var_x25 * var_x42;
            const double var_x44 = var_x28 * var_x43;
            const double var_x45 = var_x26 * var_x44;
            const double var_x46 = var_x33 * var_x35 * var_x43;
            const double var_x47 = var_x26 * var_x30 * var_x43 / pow(var_x27, 2);
            const double var_x48 = var_x33 * var_x42 / pow(var_x34, 2);
            const double var_x49 = 1.6815554185550732e-6 * var_x48;
            const double var_x50 = var_x25 * var_x40;
            const double var_x51 = 1 / mParameters[0];
            const double var_x52 = 0.001 * var_x51;
            
            partialF = var_x52 * (-0.00080000000000000004 + 0.00012957885284796509 * var_x13 + 0.0013452443348440585 * var_x47 - 0.0074999999999999997 * var_x0 - 0.012500000000000001 * var_x8 - 2.0000000000000002e-5 * var_x23 - 0.0017307692307692306 * var_x6 - 0.002690488669688117 * var_x45 - 0.0006417238426756367 * var_x11 - 0.00024046242485337545 * var_x46 + var_x39 * var_x49 + var_x49 * var_x50 - var_x25 * var_x32 - var_x25 * var_x41 - var_x36 * var_x39);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[10];
        // Units: millimolar; Initial value: 2.3909
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[11];
        // Units: millimolar; Initial value: 0.2207
        
        
        // Mathematics
        const double var_intracellular_calcium_concentration__i_rel = 3.0554258119568201 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel / (3.9999999999999998e-6 + pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0)); // nanoA
        const double var_intracellular_calcium_concentration__i_up = 61.108516239136399 * (5.0 - var_chaste_interface__intracellular_calcium_concentration__Ca_up) * var_chaste_interface__intracellular_calcium_concentration__Cai; // nanoA
        const double var_Na_Ca_exchanger__i_NaCa = 2.0000000000000002e-5 * (2.0 * pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0) * exp(0.018716945411372737 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_calcium_concentration__Cai * exp(-0.018716945411372737 * var_chaste_interface__membrane__V)) / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + 0.00020000000000000001 * pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0) + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai)); // nanoA
        const double var_calcium_background_current__i_Ca_b = 0.0001 * var_chaste_interface__membrane__V - 0.0013356880329847825 * log(2.0 / var_chaste_interface__intracellular_calcium_concentration__Cai); // nanoA
        const double var_second_inward_current__i_siCa = 0.017968267594917826 * (-50.0 + var_chaste_interface__membrane__V) * (-2.0 * exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_calcium_concentration__Cai * exp(3.7433890822745473)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane__V)); // nanoA
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai = 0.00065457324873455789 * var_intracellular_calcium_concentration__i_rel + 0.0013091464974691158 * var_Na_Ca_exchanger__i_NaCa - 0.00065457324873455789 * var_calcium_background_current__i_Ca_b - 0.00065457324873455789 * var_intracellular_calcium_concentration__i_up - 0.00065457324873455789 * var_second_inward_current__i_siCa; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
            // Units: millimolar; Initial value: 5.6e-05
            double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
            // Units: dimensionless; Initial value: 0.9997
            double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
            // Units: dimensionless; Initial value: 0.5765
            double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
            // Units: millimolar; Initial value: 7.5
            double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[10];
            // Units: millimolar; Initial value: 2.3909
            double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[11];
            // Units: millimolar; Initial value: 0.2207
            
            const double var_x1 = 0.074867781645490947 * var_chaste_interface__membrane__V;
            const double var_x14 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0);
            const double var_x15 = 0.018716945411372737 * var_chaste_interface__membrane__V;
            const double var_x16 = exp(var_x15);
            const double var_x17 = var_x14 * var_x16;
            const double var_x18 = exp(-var_x15);
            const double var_x19 = var_x18 * var_chaste_interface__intracellular_calcium_concentration__Cai;
            const double var_x20 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai);
            const double var_x21 = 1 / (1.0 + 0.00020000000000000001 * var_x14 + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai);
            const double var_x22 = var_x20 * var_x21;
            const double var_x24 = var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f;
            const double var_x25 = var_x24 * var_chaste_interface__second_inward_current_d_gate__d;
            const double var_x26 = exp(3.7433890822745473 - var_x1);
            const double var_x27 = 1.0 - var_x26;
            const double var_x28 = 1 / var_x27;
            const double var_x29 = exp(3.7433890822745473);
            const double var_x42 = -50.0 + var_chaste_interface__membrane__V;
            const double var_x43 = var_x25 * var_x42;
            const double var_x44 = var_x28 * var_x43;
            const double var_x53 = 1 / var_chaste_interface__intracellular_calcium_concentration__Cai;
            const double var_x54 = 2.0 * var_x17 - 2744000.0 * var_x19;
            const double var_x55 = var_x21 * var_x54 / pow((0.0068999999999999999 + var_chaste_interface__intracellular_calcium_concentration__Cai), 2);
            const double var_x56 = var_x20 * var_x54 / pow((0.0036443148688046646 + 7.2886297376093296e-7 * var_x14 + var_chaste_interface__intracellular_calcium_concentration__Cai), 2);
            const double var_x57 = var_x18 * var_x22;
            const double var_x58 = var_x29 * var_x44;
            const double var_x83 = 0.0040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel;
            const double var_x84 = pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0);
            const double var_x85 = 3.9999999999999998e-6 + var_x84;
            const double var_x86 = 1 / var_x85;
            const double var_x87 = var_x86 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 1.0);
            const double var_x88 = pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 3.0) / pow(var_x85, 2);
            
            partialF = -0.19999999999999998 + 0.040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_up - 8.7430565504672044e-7 * var_x53 - 1.1761547293737243e-5 * var_x58 - 1.8066221665073799e-10 * var_x55 - 9.5418840923404938e-11 * var_x56 - 0.071845959781105084 * var_x57 + var_x83 * var_x87 - var_x83 * var_x88;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_hyperpolarising_activated_current_y_gate__y = 2.8e-5 * (1.0 - var_chaste_interface__hyperpolarising_activated_current_y_gate__y) * exp(-0.0625 * var_chaste_interface__membrane__V) - 0.0195 * var_chaste_interface__hyperpolarising_activated_current_y_gate__y * exp(0.052631578947368418 * var_chaste_interface__membrane__V); // 1 / millisecond

        return d_dt_chaste_interface_var_hyperpolarising_activated_current_y_gate__y;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x90 = exp(-0.0625 * var_chaste_interface__membrane__V);
            const double var_x91 = exp(0.052631578947368418 * var_chaste_interface__membrane__V);
            
            partialF = -2.8e-5 * var_x90 - 0.0195 * var_x91;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_time_dependent_potassium_current_x_gate__x = 0.0021000000000000003 * (1.0 - var_chaste_interface__time_dependent_potassium_current_x_gate__x) * exp(0.035714285714285712 * var_chaste_interface__membrane__V) - 0.00095999999999999992 * var_chaste_interface__time_dependent_potassium_current_x_gate__x * exp(-0.041666666666666664 * var_chaste_interface__membrane__V); // 1 / millisecond

        return d_dt_chaste_interface_var_time_dependent_potassium_current_x_gate__x;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x92 = exp(0.035714285714285712 * var_chaste_interface__membrane__V);
            const double var_x93 = exp(-0.041666666666666664 * var_chaste_interface__membrane__V);
            
            partialF = -0.00095999999999999992 * var_x93 - 0.0021000000000000003 * var_x92;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * ((fabs(41.0 + var_chaste_interface__membrane__V) < 1.0000000000000001e-5) ? (2000.0) : (200.0 * (41.0 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.1000000000000005 - 0.10000000000000001 * var_chaste_interface__membrane__V)))) - 8.0 * var_chaste_interface__fast_sodium_current_m_gate__m * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V); // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x94 = exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V);
            const double var_x96 = 41.0 + var_chaste_interface__membrane__V;
            const double var_x97 = fabs(var_x96) < 1.0000000000000001e-5;
            const double var_x99 = -0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x100 = exp(-4.1000000000000005 + var_x99);
            const double var_x101 = 1.0 - var_x100;
            const double var_x102 = 0.20000000000000001 / var_x101;
            const double var_x103 = -8.0 * var_x94;
            
            partialF = ((var_x97) ? (-2.0 + var_x103) : (var_x103 - var_x102 * var_x96));
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = 0.02 * (1.0 - var_chaste_interface__fast_sodium_current_h_gate__h) * exp(-9.375 - 0.125 * var_chaste_interface__membrane__V) - 2.0 * var_chaste_interface__fast_sodium_current_h_gate__h / (1.0 + 320.0 * exp(-7.5 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x99 = -0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x104 = exp(-9.375 - 0.125 * var_chaste_interface__membrane__V);
            const double var_x105 = exp(-7.5 + var_x99);
            
            partialF = -2.0 / (1.0 + 320.0 * var_x105) - 0.02 * var_x104;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_second_inward_current_d_gate__E0_d = 19.0 + var_chaste_interface__membrane__V; // millivolt
        const double d_dt_chaste_interface_var_second_inward_current_d_gate__d = 0.001 * (1.0 - var_chaste_interface__second_inward_current_d_gate__d) * ((fabs(var_second_inward_current_d_gate__E0_d) < 0.0001) ? (120.0) : (30.0 * var_second_inward_current_d_gate__E0_d / (1.0 - exp(-0.25 * var_second_inward_current_d_gate__E0_d)))) - 0.001 * ((fabs(var_second_inward_current_d_gate__E0_d) < 0.0001) ? (120.0) : (12.0 * var_second_inward_current_d_gate__E0_d / (-1.0 + exp(0.10000000000000001 * var_second_inward_current_d_gate__E0_d)))) * var_chaste_interface__second_inward_current_d_gate__d; // 1 / millisecond

        return d_dt_chaste_interface_var_second_inward_current_d_gate__d;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x106 = 19.0 + var_chaste_interface__membrane__V;
            const double var_x107 = fabs(var_x106) < 0.0001;
            const double var_x109 = 0.25 * var_chaste_interface__membrane__V;
            const double var_x110 = -var_x109;
            const double var_x111 = exp(-4.75 + var_x110);
            const double var_x112 = 1.0 - var_x111;
            const double var_x113 = 0.029999999999999999 / var_x112;
            const double var_x114 = exp(1.8999999999999999 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x115 = -1.0 + var_x114;
            const double var_x116 = 0.012 / var_x115;
            
            partialF = ((var_x107) ? (-0.23999999999999999) : (-var_x106 * var_x113 - var_x106 * var_x116));
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_second_inward_current_f_gate__f = 0.001 * (1.0 - var_chaste_interface__second_inward_current_f_gate__f) * ((fabs(34.0 + var_chaste_interface__membrane__V) < 0.0001) ? (25.0) : (6.25 * (34.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(8.5 + 0.25 * var_chaste_interface__membrane__V)))) - 0.050000000000000003 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 + exp(-8.5 - 0.25 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_second_inward_current_f_gate__f;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x109 = 0.25 * var_chaste_interface__membrane__V;
            const double var_x110 = -var_x109;
            const double var_x117 = exp(-8.5 + var_x110);
            const double var_x118 = 1.0 + var_x117;
            const double var_x120 = 34.0 + var_chaste_interface__membrane__V;
            const double var_x121 = fabs(var_x120) < 0.0001;
            const double var_x123 = exp(8.5 + var_x109);
            const double var_x124 = -1.0 + var_x123;
            const double var_x125 = 0.0062500000000000003 / var_x124;
            const double var_x126 = -0.050000000000000003 / var_x118;
            
            partialF = ((var_x121) ? (-0.025000000000000001 + var_x126) : (var_x126 - var_x120 * var_x125));
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_second_inward_current_f2_gate__f2 = 0.01 - 0.001 * (10.0 + 20000.0 * var_chaste_interface__intracellular_calcium_concentration__Cai) * var_chaste_interface__second_inward_current_f2_gate__f2; // 1 / millisecond

        return d_dt_chaste_interface_var_second_inward_current_f2_gate__f2;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
            // Units: millimolar; Initial value: 5.6e-05
            
            
            partialF = -0.01 - 20.0 * var_chaste_interface__intracellular_calcium_concentration__Cai;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        
        
        // Mathematics
        const double var_hyperpolarising_activated_current__E_Na = 26.713760659695652 * log(140.0 / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = 2.0000000000000002e-5 * (2.0 * pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0) * exp(0.018716945411372737 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_calcium_concentration__Cai * exp(-0.018716945411372737 * var_chaste_interface__membrane__V)) / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + 0.00020000000000000001 * pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0) + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai)); // nanoA
        const double var_fast_sodium_current__i_Na = 0.012500000000000001 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(140.36000000000001 / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)) + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = 0.0037499999999999999 * pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V); // nanoA
        const double var_second_inward_current__i_siNa = 4.4920668987294567e-5 * (-50.0 + var_chaste_interface__membrane__V) * (-140.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_sodium_concentration__Nai * exp(1.8716945411372736)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_sodium_background_current__i_Na_b = 0.00069999999999999999 * var_chaste_interface__membrane__V - 0.00069999999999999999 * var_hyperpolarising_activated_current__E_Na; // nanoA
        const double var_sodium_potassium_pump__i_p = 0.33750000000000002 * var_chaste_interface__intracellular_sodium_concentration__Nai / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Nai); // nanoA
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai = -0.0013091464974691158 * var_fast_sodium_current__i_Na - 0.0013091464974691158 * var_hyperpolarising_activated_current__i_fNa - 0.0013091464974691158 * var_second_inward_current__i_siNa - 0.0013091464974691158 * var_sodium_background_current__i_Na_b - 0.0039274394924073471 * var_Na_Ca_exchanger__i_NaCa - 0.0039274394924073471 * var_sodium_potassium_pump__i_p; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
            // Units: millimolar; Initial value: 5.6e-05
            double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
            // Units: dimensionless; Initial value: 0.0822
            double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
            // Units: dimensionless; Initial value: 0.0365
            double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
            // Units: dimensionless; Initial value: 0.1969
            double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
            // Units: dimensionless; Initial value: 0.9997
            double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
            // Units: dimensionless; Initial value: 0.5765
            double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
            // Units: millimolar; Initial value: 7.5
            double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
            // Units: millimolar; Initial value: 140.0
            
            const double var_x0 = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2);
            const double var_x7 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
            const double var_x8 = var_x7 * var_chaste_interface__fast_sodium_current_h_gate__h;
            const double var_x9 = -0.037433890822745473 * var_chaste_interface__membrane__V;
            const double var_x14 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0);
            const double var_x15 = 0.018716945411372737 * var_chaste_interface__membrane__V;
            const double var_x16 = exp(var_x15);
            const double var_x17 = var_x14 * var_x16;
            const double var_x18 = exp(-var_x15);
            const double var_x19 = var_x18 * var_chaste_interface__intracellular_calcium_concentration__Cai;
            const double var_x20 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai);
            const double var_x21 = 1 / (1.0 + 0.00020000000000000001 * var_x14 + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai);
            const double var_x22 = var_x20 * var_x21;
            const double var_x24 = var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f;
            const double var_x25 = var_x24 * var_chaste_interface__second_inward_current_d_gate__d;
            const double var_x33 = exp(1.8716945411372736 + var_x9);
            const double var_x34 = 1.0 - var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x37 = exp(1.8716945411372736);
            const double var_x42 = -50.0 + var_chaste_interface__membrane__V;
            const double var_x43 = var_x25 * var_x42;
            const double var_x54 = 2.0 * var_x17 - 2744000.0 * var_x19;
            const double var_x56 = var_x20 * var_x54 / pow((0.0036443148688046646 + 7.2886297376093296e-7 * var_x14 + var_chaste_interface__intracellular_calcium_concentration__Cai), 2);
            const double var_x60 = 1 / var_chaste_interface__intracellular_sodium_concentration__Nai;
            const double var_x62 = var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki;
            const double var_x71 = 1 / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Nai);
            const double var_x72 = var_chaste_interface__intracellular_sodium_concentration__Nai / pow((1 + 0.025000000000000001 * var_chaste_interface__intracellular_sodium_concentration__Nai), 2);
            const double var_x74 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 2.0);
            const double var_x75 = var_x56 * var_x74;
            const double var_x76 = var_x16 * var_x22 * var_x74;
            const double var_x77 = var_x8 * (0.0008549444286121402 * var_chaste_interface__intracellular_potassium_concentration__Ki + 0.0071245369051011684 * var_chaste_interface__intracellular_sodium_concentration__Nai) / pow(var_x62, 2);
            const double var_x78 = var_x37 * var_x43;
            const double var_x128 = 5.8807736468686208e-8 * var_x35;
            const double var_x132 = 0.00013114584825700806 * var_x0;
            const double var_x133 = -var_x128 * var_x78;
            
            partialF = var_x133 + 8.2844426792967482e-7 * var_x72 + 6.2592534133428895e-16 * var_x75 - 2.4480558341308171e-5 * var_x60 - 0.061358770871178837 * var_x77 - 4.7129273908888172e-7 * var_x76 - 0.0013255108286874798 * var_x71 - var_x132 * var_x60;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[10];
        // Units: millimolar; Initial value: 2.3909
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[11];
        // Units: millimolar; Initial value: 0.2207
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.237
        
        
        // Mathematics
        const double var_intracellular_calcium_concentration__i_tr = 0.152771290597841 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_rel + var_chaste_interface__intracellular_calcium_concentration__Ca_up) * var_chaste_interface__intracellular_calcium_concentration__p; // nanoA
        const double var_intracellular_calcium_concentration__i_up = 61.108516239136399 * (5.0 - var_chaste_interface__intracellular_calcium_concentration__Ca_up) * var_chaste_interface__intracellular_calcium_concentration__Cai; // nanoA
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up = 0.013091464974691156 * var_intracellular_calcium_concentration__i_up - 0.013091464974691156 * var_intracellular_calcium_concentration__i_tr; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
            // Units: millimolar; Initial value: 5.6e-05
            double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
            // Units: dimensionless; Initial value: 0.237
            
            const double var_x134 = 0.002 * var_chaste_interface__intracellular_calcium_concentration__p;
            
            partialF = -var_x134 - 0.79999999999999993 * var_chaste_interface__intracellular_calcium_concentration__Cai;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[10];
        // Units: millimolar; Initial value: 2.3909
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[11];
        // Units: millimolar; Initial value: 0.2207
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.237
        
        
        // Mathematics
        const double var_intracellular_calcium_concentration__i_rel = 3.0554258119568201 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel / (3.9999999999999998e-6 + pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0)); // nanoA
        const double var_intracellular_calcium_concentration__i_tr = 0.152771290597841 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_rel + var_chaste_interface__intracellular_calcium_concentration__Ca_up) * var_chaste_interface__intracellular_calcium_concentration__p; // nanoA
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel = 0.032728662436727896 * var_intracellular_calcium_concentration__i_tr - 0.032728662436727896 * var_intracellular_calcium_concentration__i_rel; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
            // Units: millimolar; Initial value: 5.6e-05
            double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
            // Units: dimensionless; Initial value: 0.237
            
            const double var_x84 = pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0);
            const double var_x85 = 3.9999999999999998e-6 + var_x84;
            const double var_x86 = 1 / var_x85;
            const double var_x89 = var_x84 * var_x86;
            const double var_x136 = 0.0050000000000000001 * var_chaste_interface__intracellular_calcium_concentration__p;
            
            partialF = -var_x136 - 0.099999999999999992 * var_x89;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.237
        
        
        // Mathematics
        const double var_intracellular_calcium_concentration__E0_p = 64.0 + var_chaste_interface__membrane__V; // millivolt
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__p = -0.0050000000000000001 * var_chaste_interface__intracellular_calcium_concentration__p / (1.0 + exp(-0.25 * var_intracellular_calcium_concentration__E0_p)) + 0.00062500000000000001 * (1.0 - var_chaste_interface__intracellular_calcium_concentration__p) * var_intracellular_calcium_concentration__E0_p / (-1.0 + exp(0.25 * var_intracellular_calcium_concentration__E0_p)); // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__p;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x109 = 0.25 * var_chaste_interface__membrane__V;
            const double var_x110 = -var_x109;
            const double var_x138 = exp(16.0 + var_x109);
            const double var_x139 = -1.0 + var_x138;
            const double var_x140 = 0.00062500000000000001 / var_x139;
            const double var_x141 = exp(-16.0 + var_x110);
            const double var_x142 = 1.0 + var_x141;
            const double var_x143 = 64.0 + var_chaste_interface__membrane__V;
            
            partialF = -0.0050000000000000001 / var_x142 - var_x140 * var_x143;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluateYDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        
        
        // Mathematics
        const double var_hyperpolarising_activated_current__E_K = 26.713760659695652 * log(3.0 / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__i_fK = 0.0037499999999999999 * pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V); // nanoA
        const double var_second_inward_current__i_siK = 4.4920668987294567e-5 * (-50.0 + var_chaste_interface__membrane__V) * (-3.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V) + var_chaste_interface__intracellular_potassium_concentration__Ki * exp(1.8716945411372736)) * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_sodium_potassium_pump__i_p = 0.33750000000000002 * var_chaste_interface__intracellular_sodium_concentration__Nai / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Nai); // nanoA
        const double var_time_dependent_potassium_current__i_K = (0.0057142857142857143 * var_chaste_interface__intracellular_potassium_concentration__Ki - 0.017142857142857144 * exp(-0.037433890822745473 * var_chaste_interface__membrane__V)) * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__i_K1 = 0.0017307692307692306 * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(0.74867781645490938 + 0.074867781645490947 * var_chaste_interface__membrane__V - 0.074867781645490947 * var_hyperpolarising_activated_current__E_K)); // nanoA
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki = 0.0026182929949382316 * var_sodium_potassium_pump__i_p - 0.0013091464974691158 * var_hyperpolarising_activated_current__i_fK - 0.0013091464974691158 * var_second_inward_current__i_siK - 0.0013091464974691158 * var_time_dependent_potassium_current__i_K - 0.0013091464974691158 * var_time_independent_potassium_current__i_K1; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2Opt::EvaluatePartialDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
            // Units: dimensionless; Initial value: 0.0822
            double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
            // Units: dimensionless; Initial value: 0.1231
            double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
            // Units: dimensionless; Initial value: 0.9997
            double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
            // Units: dimensionless; Initial value: 0.5765
            double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
            // Units: millimolar; Initial value: 140.0
            
            const double var_x0 = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2);
            const double var_x1 = 0.074867781645490947 * var_chaste_interface__membrane__V;
            const double var_x2 = 1 / var_chaste_interface__intracellular_potassium_concentration__Ki;
            const double var_x3 = log(3.0 * var_x2);
            const double var_x4 = exp(0.74867781645490938 + var_x1 - 2.0 * var_x3);
            const double var_x5 = 1.0 + var_x4;
            const double var_x6 = 1 / var_x5;
            const double var_x9 = -0.037433890822745473 * var_chaste_interface__membrane__V;
            const double var_x12 = -26.713760659695652 * var_x3 + var_chaste_interface__membrane__V;
            const double var_x13 = var_x12 * var_x4 / pow(var_x5, 2);
            const double var_x24 = var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f;
            const double var_x25 = var_x24 * var_chaste_interface__second_inward_current_d_gate__d;
            const double var_x33 = exp(1.8716945411372736 + var_x9);
            const double var_x34 = 1.0 - var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x37 = exp(1.8716945411372736);
            const double var_x42 = -50.0 + var_chaste_interface__membrane__V;
            const double var_x43 = var_x25 * var_x42;
            const double var_x78 = var_x37 * var_x43;
            const double var_x80 = var_x2 * var_x6;
            const double var_x81 = var_x13 * var_x2;
            const double var_x128 = 5.8807736468686208e-8 * var_x35;
            const double var_x132 = 0.00013114584825700806 * var_x0;
            const double var_x133 = -var_x128 * var_x78;
            
            partialF = var_x133 + 4.5316609527777084e-6 * var_x81 - 7.4808371283949473e-6 * var_chaste_interface__time_dependent_potassium_current_x_gate__x - 6.0528853041696024e-5 * var_x80 - var_x132 * var_x2;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }

    std::vector<double> Cellnoble_SAN_model_1989FromCellMLGRL2Opt::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics

        std::vector<double> dqs(1);
        dqs[0] = var_chaste_interface__environment__time_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellnoble_SAN_model_1989FromCellMLGRL2Opt>::Initialise(void)
{
    this->mSystemName = "Noble_SAN_model_1989";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-69.1865);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.6e-05);

    // rY[2]:
    this->mVariableNames.push_back("hyperpolarising_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0822);

    // rY[3]:
    this->mVariableNames.push_back("time_dependent_potassium_current_x_gate__x");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1231);

    // rY[4]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0365);

    // rY[5]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1969);

    // rY[6]:
    this->mVariableNames.push_back("second_inward_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[7]:
    this->mVariableNames.push_back("second_inward_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9997);

    // rY[8]:
    this->mVariableNames.push_back("second_inward_current_f2_gate__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5765);

    // rY[9]:
    this->mVariableNames.push_back("intracellular_sodium_concentration__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.5);

    // rY[10]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.3909);

    // rY[11]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.2207);

    // rY[12]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__p");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.237);

    // rY[13]:
    this->mVariableNames.push_back("intracellular_potassium_concentration__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(140.0);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellnoble_SAN_model_1989FromCellMLGRL2Opt)

