//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: kurata_model_2002
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "kurata_model_2002.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"


    Cellkurata_model_2002FromCellMLGRL2Opt::Cellkurata_model_2002FromCellMLGRL2Opt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                27,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellkurata_model_2002FromCellMLGRL2Opt>::Instance();
        Init();
        
        this->mParameters[0] = 32.0; // (var_membrane__Cm) [picoF]
    }

    Cellkurata_model_2002FromCellMLGRL2Opt::~Cellkurata_model_2002FromCellMLGRL2Opt()
    {
    }
    
    double Cellkurata_model_2002FromCellMLGRL2Opt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__L_type_calcium_channel_current_d_gate__d = rY[1];
        // Units: dimensionless; Initial value: 0.000602055134
        double var_chaste_interface__L_type_calcium_channel_current_f_gate__f = rY[2];
        // Units: dimensionless; Initial value: 0.626999773853
        double var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa = rY[3];
        // Units: dimensionless; Initial value: 0.589580408056
        double var_chaste_interface__T_type_calcium_channel_current_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 0.004571884917
        double var_chaste_interface__T_type_calcium_channel_current_f_gate__f = rY[5];
        // Units: dimensionless; Initial value: 0.249637570396
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = rY[6];
        // Units: dimensionless; Initial value: 0.629323128348
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = rY[7];
        // Units: dimensionless; Initial value: 0.3493633709533
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = rY[8];
        // Units: dimensionless; Initial value: 0.852396631172
        double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = rY[9];
        // Units: dimensionless; Initial value: 0.054409723782
        double var_chaste_interface__AP_sensitive_currents_q_gate__q = rY[10];
        // Units: dimensionless; Initial value: 0.531446952485
        double var_chaste_interface__AP_sensitive_currents_r_gate__r = rY[11];
        // Units: dimensionless; Initial value: 0.005550489445
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[12];
        // Units: dimensionless; Initial value: 0.067156687129
        double var_chaste_interface__sustained_inward_current_qa_gate__qa = rY[13];
        // Units: dimensionless; Initial value: 0.426018100136
        double var_chaste_interface__sustained_inward_current_qi_gate__qi = rY[14];
        // Units: dimensionless; Initial value: 0.333330378068
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
        // Units: millimolar; Initial value: 9.438646305915
        double var_chaste_interface__intracellular_ion_concentrations__Ki = rY[20];
        // Units: millimolar; Initial value: 139.984146485614
        
        const double var_L_type_calcium_channel_current__i_CaL = 0.57999999999999996 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_channel_current_d_gate__d * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa * var_chaste_interface__L_type_calcium_channel_current_f_gate__f; // picoA
        const double var_T_type_calcium_channel_current__i_CaT = 0.45800000000000002 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_calcium_channel_current_d_gate__d * var_chaste_interface__T_type_calcium_channel_current_f_gate__f; // picoA
        const double var_background_muscarinic_potassium_channel_current__i_K_ACh = 0.0021962113249247841 * var_chaste_interface__intracellular_ion_concentrations__Ki - 0.011859541154593834 * exp(-0.037415977988011655 * var_chaste_interface__membrane__V); // picoA
        const double var_reversal_potentials__E_K = 26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki); // millivolt
        const double var_AP_sensitive_currents__i_sus = 0.02 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_AP_sensitive_currents__i_to = 0.17999999999999999 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr = 0.067616443970885107 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (0.40000000000000002 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + 0.59999999999999998 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF) * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy; // picoA
        const double var_reversal_potentials__E_Na = 26.726549826397882 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai); // millivolt
        const double var_hyperpolarisation_activated_current__i_h = 0.14373749999999999 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) + 0.23126250000000001 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V); // picoA
        const double var_slowly_activating_delayed_rectifier_potassium_current__i_Ks = 0.025899999999999999 * pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2) * (-26.726549826397882 * log(22.199999999999999 / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.12 * var_chaste_interface__intracellular_ion_concentrations__Nai)) + var_chaste_interface__membrane__V); // picoA
        const double var_sodium_calcium_exchange_current__Qco = 0; // dimensionless
        const double var_sodium_calcium_exchange_current__di = 1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai; // dimensionless
        const double var_sodium_calcium_exchange_current__do = 4.8791826399715319 + 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco); // dimensionless
        const double var_sodium_calcium_exchange_current__k12 = 48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k14 = 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k21 = 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k23 = 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k32 = exp(0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k41 = exp(-0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k43 = var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai); // dimensionless
        const double var_sodium_calcium_exchange_current__i_NaCa = 125.0 * (((0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 - (0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12) / (0.96776646412697098 * (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k23 + 0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k21 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k23 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32); // picoA
        const double var_sodium_dependent_background_current__i_b_Na = 0.0054000000000000003 * var_chaste_interface__membrane__V - 0.0054000000000000003 * var_reversal_potentials__E_Na; // picoA
        const double var_sodium_potassium_pump_current__i_NaK = 3.0052188053939588 / ((1.0 + 30.900566853219949 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Nai, 1.3)) * (1.0 + exp(-4.0 + 0.033333333333333333 * var_reversal_potentials__E_Na - 0.033333333333333333 * var_chaste_interface__membrane__V))); // picoA
        const double var_sustained_inward_current__i_st = 0.014999999999999999 * (-37.399999999999999 + var_chaste_interface__membrane__V) * var_chaste_interface__sustained_inward_current_qa_gate__qa * var_chaste_interface__sustained_inward_current_qi_gate__qi; // picoA
        const double var_chaste_interface__i_ionic = (var_AP_sensitive_currents__i_sus + var_AP_sensitive_currents__i_to + var_L_type_calcium_channel_current__i_CaL + var_T_type_calcium_channel_current__i_CaT + var_background_muscarinic_potassium_channel_current__i_K_ACh + var_hyperpolarisation_activated_current__i_h + var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr + var_slowly_activating_delayed_rectifier_potassium_current__i_Ks + var_sodium_calcium_exchange_current__i_NaCa + var_sodium_dependent_background_current__i_b_Na + var_sodium_potassium_pump_current__i_NaK + var_sustained_inward_current__i_st) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellkurata_model_2002FromCellMLGRL2Opt::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__L_type_calcium_channel_current_d_gate__d = rY[1];
        // Units: dimensionless; Initial value: 0.000602055134
        double var_chaste_interface__L_type_calcium_channel_current_f_gate__f = rY[2];
        // Units: dimensionless; Initial value: 0.626999773853
        double var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa = rY[3];
        // Units: dimensionless; Initial value: 0.589580408056
        double var_chaste_interface__T_type_calcium_channel_current_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 0.004571884917
        double var_chaste_interface__T_type_calcium_channel_current_f_gate__f = rY[5];
        // Units: dimensionless; Initial value: 0.249637570396
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = rY[6];
        // Units: dimensionless; Initial value: 0.629323128348
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = rY[7];
        // Units: dimensionless; Initial value: 0.3493633709533
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = rY[8];
        // Units: dimensionless; Initial value: 0.852396631172
        double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = rY[9];
        // Units: dimensionless; Initial value: 0.054409723782
        double var_chaste_interface__AP_sensitive_currents_q_gate__q = rY[10];
        // Units: dimensionless; Initial value: 0.531446952485
        double var_chaste_interface__AP_sensitive_currents_r_gate__r = rY[11];
        // Units: dimensionless; Initial value: 0.005550489445
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[12];
        // Units: dimensionless; Initial value: 0.067156687129
        double var_chaste_interface__sustained_inward_current_qa_gate__qa = rY[13];
        // Units: dimensionless; Initial value: 0.426018100136
        double var_chaste_interface__sustained_inward_current_qi_gate__qi = rY[14];
        // Units: dimensionless; Initial value: 0.333330378068
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
        // Units: millimolar; Initial value: 9.438646305915
        double var_chaste_interface__intracellular_ion_concentrations__Ki = rY[20];
        // Units: millimolar; Initial value: 139.984146485614
        

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_L_type_calcium_channel_current__i_CaL = 0.57999999999999996 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_channel_current_d_gate__d * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa * var_chaste_interface__L_type_calcium_channel_current_f_gate__f; // picoA
        const double var_T_type_calcium_channel_current__i_CaT = 0.45800000000000002 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_calcium_channel_current_d_gate__d * var_chaste_interface__T_type_calcium_channel_current_f_gate__f; // picoA
        const double var_background_muscarinic_potassium_channel_current__i_K_ACh = 0.0021962113249247841 * var_chaste_interface__intracellular_ion_concentrations__Ki - 0.011859541154593834 * exp(-0.037415977988011655 * var_chaste_interface__membrane__V); // picoA
        const double var_reversal_potentials__E_K = 26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki); // millivolt
        const double var_AP_sensitive_currents__i_sus = 0.02 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_AP_sensitive_currents__i_to = 0.17999999999999999 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_hyperpolarisation_activated_current__i_h_K = 0.23126250000000001 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V); // picoA
        const double var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr = 0.067616443970885107 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (0.40000000000000002 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + 0.59999999999999998 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF) * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy; // picoA
        const double var_reversal_potentials__E_Na = 26.726549826397882 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai); // millivolt
        const double var_hyperpolarisation_activated_current__i_h_Na = 0.14373749999999999 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V); // picoA
        const double var_slowly_activating_delayed_rectifier_potassium_current__i_Ks = 0.025899999999999999 * pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2) * (-26.726549826397882 * log(22.199999999999999 / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.12 * var_chaste_interface__intracellular_ion_concentrations__Nai)) + var_chaste_interface__membrane__V); // picoA
        const double var_sodium_calcium_exchange_current__Qco = 0; // dimensionless
        const double var_sodium_calcium_exchange_current__di = 1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai; // dimensionless
        const double var_sodium_calcium_exchange_current__do = 4.8791826399715319 + 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco); // dimensionless
        const double var_sodium_calcium_exchange_current__k12 = 48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k14 = 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k21 = 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k23 = 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k32 = exp(0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k41 = exp(-0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k43 = var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai); // dimensionless
        const double var_sodium_calcium_exchange_current__i_NaCa = 125.0 * (((0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 - (0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12) / (0.96776646412697098 * (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k23 + 0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k21 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k23 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32); // picoA
        const double var_sodium_dependent_background_current__i_b_Na = 0.0054000000000000003 * var_chaste_interface__membrane__V - 0.0054000000000000003 * var_reversal_potentials__E_Na; // picoA
        const double var_sodium_potassium_pump_current__i_NaK = 3.0052188053939588 / ((1.0 + 30.900566853219949 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Nai, 1.3)) * (1.0 + exp(-4.0 + 0.033333333333333333 * var_reversal_potentials__E_Na - 0.033333333333333333 * var_chaste_interface__membrane__V))); // picoA
        const double var_sustained_inward_current__i_st = 0.014999999999999999 * (-37.399999999999999 + var_chaste_interface__membrane__V) * var_chaste_interface__sustained_inward_current_qa_gate__qa * var_chaste_interface__sustained_inward_current_qi_gate__qi; // picoA
        d_dt_chaste_interface_var_membrane__V = -1.0 * var_AP_sensitive_currents__i_sus - 1.0 * var_AP_sensitive_currents__i_to - 1.0 * var_L_type_calcium_channel_current__i_CaL - 1.0 * var_T_type_calcium_channel_current__i_CaT - 1.0 * var_background_muscarinic_potassium_channel_current__i_K_ACh - 1.0 * var_hyperpolarisation_activated_current__i_h_K - 1.0 * var_hyperpolarisation_activated_current__i_h_Na - 1.0 * var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr - 1.0 * var_slowly_activating_delayed_rectifier_potassium_current__i_Ks - 1.0 * var_sodium_calcium_exchange_current__i_NaCa - 1.0 * var_sodium_dependent_background_current__i_b_Na - 1.0 * var_sodium_potassium_pump_current__i_NaK - 1.0 * var_sustained_inward_current__i_st; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Cellkurata_model_2002FromCellMLGRL2Opt::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__L_type_calcium_channel_current_d_gate__d = rY[1];
        // Units: dimensionless; Initial value: 0.000602055134
        double var_chaste_interface__L_type_calcium_channel_current_f_gate__f = rY[2];
        // Units: dimensionless; Initial value: 0.626999773853
        double var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa = rY[3];
        // Units: dimensionless; Initial value: 0.589580408056
        double var_chaste_interface__T_type_calcium_channel_current_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 0.004571884917
        double var_chaste_interface__T_type_calcium_channel_current_f_gate__f = rY[5];
        // Units: dimensionless; Initial value: 0.249637570396
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = rY[6];
        // Units: dimensionless; Initial value: 0.629323128348
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = rY[7];
        // Units: dimensionless; Initial value: 0.3493633709533
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = rY[8];
        // Units: dimensionless; Initial value: 0.852396631172
        double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = rY[9];
        // Units: dimensionless; Initial value: 0.054409723782
        double var_chaste_interface__AP_sensitive_currents_q_gate__q = rY[10];
        // Units: dimensionless; Initial value: 0.531446952485
        double var_chaste_interface__AP_sensitive_currents_r_gate__r = rY[11];
        // Units: dimensionless; Initial value: 0.005550489445
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[12];
        // Units: dimensionless; Initial value: 0.067156687129
        double var_chaste_interface__sustained_inward_current_qa_gate__qa = rY[13];
        // Units: dimensionless; Initial value: 0.426018100136
        double var_chaste_interface__sustained_inward_current_qi_gate__qi = rY[14];
        // Units: dimensionless; Initial value: 0.333330378068
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[15];
        // Units: millimolar; Initial value: 0.000312494921
        double var_chaste_interface__intracellular_ion_concentrations__Ca_up = rY[16];
        // Units: millimolar; Initial value: 1.462338380106
        double var_chaste_interface__intracellular_ion_concentrations__Ca_rel = rY[17];
        // Units: millimolar; Initial value: 0.296742023718
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
        // Units: millimolar; Initial value: 9.438646305915
        double var_chaste_interface__intracellular_ion_concentrations__Ki = rY[20];
        // Units: millimolar; Initial value: 139.984146485614
        double var_chaste_interface__calcium_buffering__fTMM = rY[21];
        // Units: millimolar; Initial value: 0.350600895635
        double var_chaste_interface__calcium_buffering__fCMi = rY[22];
        // Units: millimolar; Initial value: 0.116947220413
        double var_chaste_interface__calcium_buffering__fCMs = rY[23];
        // Units: millimolar; Initial value: 0.074631965653
        double var_chaste_interface__calcium_buffering__fTC = rY[24];
        // Units: millimolar; Initial value: 0.059206293446
        double var_chaste_interface__calcium_buffering__fTMC = rY[25];
        // Units: millimolar; Initial value: 0.602955114871
        double var_chaste_interface__calcium_buffering__fCQ = rY[26];
        // Units: millimolar; Initial value: 0.260317260703
        
        
        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_calcium_buffering__delta_fCQ = -0.44500000000000001 * var_chaste_interface__calcium_buffering__fCQ + 0.53400000000000003 * (1.0 - var_chaste_interface__calcium_buffering__fCQ) * var_chaste_interface__intracellular_ion_concentrations__Ca_rel; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fCQ = var_calcium_buffering__delta_fCQ; // millimolar / millisecond
        const double var_L_type_calcium_channel_current_fCa_gate__fCa_infinity = 0.00035 / (0.00035 + var_chaste_interface__intracellular_ion_concentrations__Ca_sub); // dimensionless
        const double d_dt_chaste_interface_var_L_type_calcium_channel_current_fCa_gate__fCa = 0.021000000000000001 * (-var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa + var_L_type_calcium_channel_current_fCa_gate__fCa_infinity) / var_L_type_calcium_channel_current_fCa_gate__fCa_infinity; // 1 / millisecond
        const double var_calcium_buffering__delta_fCMs = -0.54200000000000004 * var_chaste_interface__calcium_buffering__fCMs + 227.69999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fCMs) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fCMs = var_calcium_buffering__delta_fCMs; // millimolar / millisecond
        const double var_intracellular_calcium_dynamics__j_rel = 0.5 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_sub + var_chaste_interface__intracellular_ion_concentrations__Ca_rel) / (1.0 + 1.4399999999999998e-6 / pow(var_chaste_interface__intracellular_ion_concentrations__Ca_sub, 2)); // millimolar_per_millisecond
        const double var_intracellular_calcium_dynamics__j_tr = 0.016666666666666666 * var_chaste_interface__intracellular_ion_concentrations__Ca_up - 0.016666666666666666 * var_chaste_interface__intracellular_ion_concentrations__Ca_rel; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_rel = -var_intracellular_calcium_dynamics__j_rel - 10.0 * var_calcium_buffering__delta_fCQ + var_intracellular_calcium_dynamics__j_tr; // millimolar / millisecond
        const double var_calcium_buffering__delta_fCMi = -0.54200000000000004 * var_chaste_interface__calcium_buffering__fCMi + 227.69999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fCMi) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fCMi = var_calcium_buffering__delta_fCMi; // millimolar / millisecond
        const double var_calcium_buffering__delta_fTC = -0.44600000000000001 * var_chaste_interface__calcium_buffering__fTC + 88.799999999999997 * (1.0 - var_chaste_interface__calcium_buffering__fTC) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fTC = var_calcium_buffering__delta_fTC; // millimolar / millisecond
        const double var_calcium_buffering__delta_fTMC = -0.0075100000000000002 * var_chaste_interface__calcium_buffering__fTMC + 227.69999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fTMC - var_chaste_interface__calcium_buffering__fTMM) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fTMC = var_calcium_buffering__delta_fTMC; // millimolar / millisecond
        const double var_intracellular_calcium_dynamics__j_Ca_dif = 25.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub - 25.0 * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double var_intracellular_calcium_dynamics__j_up = 0.0050000000000000001 / (1.0 + 0.00059999999999999995 / var_chaste_interface__intracellular_ion_concentrations__Cai); // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fTMM = 5.6925000000000008 - 5.6925000000000008 * var_chaste_interface__calcium_buffering__fTMC - 6.4435000000000002 * var_chaste_interface__calcium_buffering__fTMM; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_up = -0.10344717757742063 * var_intracellular_calcium_dynamics__j_tr + var_intracellular_calcium_dynamics__j_up; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Cai = 0.022164824755288914 * var_intracellular_calcium_dynamics__j_Ca_dif - 0.031 * var_calcium_buffering__delta_fTC - 0.062 * var_calcium_buffering__delta_fTMC - 0.044999999999999998 * var_calcium_buffering__delta_fCMi - 0.025775813072308175 * var_intracellular_calcium_dynamics__j_up; // millimolar / millisecond
        const double d_dt_chaste_interface_var_AP_sensitive_currents_q_gate__q = (-var_chaste_interface__AP_sensitive_currents_q_gate__q + 1 / (1.0 + exp(3.7692307692307692 + 0.076923076923076927 * var_chaste_interface__membrane__V))) / (6.0599999999999996 + 39.101999999999997 / (0.065000000000000002 * exp(4.593 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 0.56999999999999995 * exp(-3.52 - 0.080000000000000002 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double d_dt_chaste_interface_var_AP_sensitive_currents_r_gate__r = (-var_chaste_interface__AP_sensitive_currents_r_gate__r + 1 / (1.0 + exp(1.2866666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V))) / (2.75352 + 14.40516 / (1.0369999999999999 * exp(2.7548999999999997 + 0.089999999999999997 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8607999999999998 - 0.12 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double var_L_type_calcium_channel_current__i_CaL = 0.57999999999999996 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_channel_current_d_gate__d * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa * var_chaste_interface__L_type_calcium_channel_current_f_gate__f; // picoA
        const double d_dt_chaste_interface_var_L_type_calcium_channel_current_d_gate__d = (-var_chaste_interface__L_type_calcium_channel_current_d_gate__d + 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V))) * (0.011429999999999999 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)) - 0.028389999999999999 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V)) - 0.084900000000000003 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20798668885191349 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_channel_current_f_gate__f = (-var_chaste_interface__L_type_calcium_channel_current_f_gate__f + 1 / (1.0 + exp(6.0 + 0.20000000000000001 * var_chaste_interface__membrane__V))) / (44.299999999999997 + 257.10000000000002 * exp(-5.4668495419491743 * pow((1 + 0.030769230769230771 * var_chaste_interface__membrane__V), 2))); // 1 / millisecond
        const double var_T_type_calcium_channel_current__i_CaT = 0.45800000000000002 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_calcium_channel_current_d_gate__d * var_chaste_interface__T_type_calcium_channel_current_f_gate__f; // picoA
        const double d_dt_chaste_interface_var_T_type_calcium_channel_current_d_gate__d = (-var_chaste_interface__T_type_calcium_channel_current_d_gate__d + 1 / (1.0 + exp(-4.3833333333333337 - 0.16666666666666666 * var_chaste_interface__membrane__V))) * (1.0680000000000001 * exp(0.87666666666666671 + 0.033333333333333333 * var_chaste_interface__membrane__V) + 1.0680000000000001 * exp(-0.87666666666666671 - 0.033333333333333333 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_T_type_calcium_channel_current_f_gate__f = (-var_chaste_interface__T_type_calcium_channel_current_f_gate__f + 1 / (1.0 + exp(11.017857142857144 + 0.17857142857142858 * var_chaste_interface__membrane__V))) * (0.014999999999999999 * exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V) + 0.015299999999999999 * exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double var_background_muscarinic_potassium_channel_current__i_K_ACh = 0.0021962113249247841 * var_chaste_interface__intracellular_ion_concentrations__Ki - 0.011859541154593834 * exp(-0.037415977988011655 * var_chaste_interface__membrane__V); // picoA
        const double d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y = (-var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + 1 / (1.0 + exp(4.7407407407407405 + 0.07407407407407407 * var_chaste_interface__membrane__V))) * (1.3953756414018557 * exp(-8.5404617897664554 - 0.022074080614542406 * var_chaste_interface__membrane__V) + 1.3953756414018557 * exp(-3.8001143986272159 + 0.051999376007487906 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity = 1 / (1.0 + exp(-2.1886792452830188 - 0.094339622641509441 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = (-var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF + var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity) * (0.043942879265498072 * exp(0.062893081761006289 * var_chaste_interface__membrane__V) + 0.0011340097874967246 * exp(-0.044444444444444446 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = (-var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity) * (0.0049612928202981696 * exp(0.058823529411764705 * var_chaste_interface__membrane__V) + 0.0001771890292963632 * exp(-0.046296296296296294 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = (-var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy + 1 / (1.0 + exp(1.672514619883041 + 0.058479532163742687 * var_chaste_interface__membrane__V))) * (0.10000000000000001 * exp(-0.018299935950224173 * var_chaste_interface__membrane__V) + 0.65600000000000003 * exp(0.009420009985210585 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double var_reversal_potentials__E_K = 26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki); // millivolt
        const double var_AP_sensitive_currents__i_sus = 0.02 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_AP_sensitive_currents__i_to = 0.17999999999999999 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_hyperpolarisation_activated_current__i_h_K = 0.23126250000000001 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V); // picoA
        const double var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr = 0.067616443970885107 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (0.40000000000000002 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + 0.59999999999999998 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF) * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy; // picoA
        const double var_reversal_potentials__E_Na = 26.726549826397882 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai); // millivolt
        const double var_hyperpolarisation_activated_current__i_h_Na = 0.14373749999999999 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V); // picoA
        const double var_slowly_activating_delayed_rectifier_potassium_current_n_gate__alpha_n = 0.014 / (1.0 + exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_slowly_activating_delayed_rectifier_potassium_current_n_gate__beta_n = 0.001 * exp(-0.022222222222222223 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_slowly_activating_delayed_rectifier_potassium_current__i_Ks = 0.025899999999999999 * pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2) * (-26.726549826397882 * log(22.199999999999999 / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.12 * var_chaste_interface__intracellular_ion_concentrations__Nai)) + var_chaste_interface__membrane__V); // picoA
        const double d_dt_chaste_interface_var_slowly_activating_delayed_rectifier_potassium_current_n_gate__n = (-var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n + var_slowly_activating_delayed_rectifier_potassium_current_n_gate__alpha_n / (var_slowly_activating_delayed_rectifier_potassium_current_n_gate__alpha_n + var_slowly_activating_delayed_rectifier_potassium_current_n_gate__beta_n)) * (var_slowly_activating_delayed_rectifier_potassium_current_n_gate__alpha_n + var_slowly_activating_delayed_rectifier_potassium_current_n_gate__beta_n); // 1 / millisecond
        const double var_sodium_calcium_exchange_current__Qco = 0; // dimensionless
        const double var_sodium_calcium_exchange_current__di = 1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai; // dimensionless
        const double var_sodium_calcium_exchange_current__do = 4.8791826399715319 + 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco); // dimensionless
        const double var_sodium_calcium_exchange_current__k12 = 48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k14 = 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k21 = 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k23 = 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k32 = exp(0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k41 = exp(-0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k43 = var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai); // dimensionless
        const double var_sodium_calcium_exchange_current__i_NaCa = 125.0 * (((0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 - (0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12) / (0.96776646412697098 * (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k23 + 0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k21 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k23 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32); // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_sub = -var_intracellular_calcium_dynamics__j_Ca_dif + 0.12030030201151064 * var_intracellular_calcium_dynamics__j_rel - 0.044999999999999998 * var_calcium_buffering__delta_fCMs + 0.00014764809009680174 * (-var_L_type_calcium_channel_current__i_CaL - var_T_type_calcium_channel_current__i_CaT + 2.0 * var_sodium_calcium_exchange_current__i_NaCa) * mParameters[0]; // millimolar / millisecond
        const double var_sodium_dependent_background_current__i_b_Na = 0.0054000000000000003 * var_chaste_interface__membrane__V - 0.0054000000000000003 * var_reversal_potentials__E_Na; // picoA
        const double var_sodium_potassium_pump_current__i_NaK = 3.0052188053939588 / ((1.0 + 30.900566853219949 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Nai, 1.3)) * (1.0 + exp(-4.0 + 0.033333333333333333 * var_reversal_potentials__E_Na - 0.033333333333333333 * var_chaste_interface__membrane__V))); // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ki = 6.4032609285536579e-6 * (-var_AP_sensitive_currents__i_sus - var_AP_sensitive_currents__i_to - var_background_muscarinic_potassium_channel_current__i_K_ACh - var_hyperpolarisation_activated_current__i_h_K - var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr - var_slowly_activating_delayed_rectifier_potassium_current__i_Ks + 2.0 * var_sodium_potassium_pump_current__i_NaK) * mParameters[0]; // millimolar / millisecond
        const double d_dt_chaste_interface_var_sustained_inward_current_qa_gate__qa = (-var_chaste_interface__sustained_inward_current_qa_gate__qa + 1 / (1.0 + exp(-11.4 - 0.20000000000000001 * var_chaste_interface__membrane__V))) * (1 / (16.0 * exp(0.125 * var_chaste_interface__membrane__V) + 15.0 * exp(0.02 * var_chaste_interface__membrane__V)) + 1 / (0.20000000000000001 * exp(-0.0014285714285714286 * var_chaste_interface__membrane__V) + 0.14999999999999999 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double var_sustained_inward_current_qi_gate__alpha_qi = 1 / (700.0 * exp(0.014285714285714285 * var_chaste_interface__membrane__V) + 3100.0 * exp(0.076923076923076927 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_sustained_inward_current_qi_gate__beta_qi = 1 / (50.0 * exp(-0.0014285714285714286 * var_chaste_interface__membrane__V) + 95.0 * exp(-0.10000000000000001 * var_chaste_interface__membrane__V)) + 0.00022900000000000001 / (1.0 + exp(-0.20000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_sustained_inward_current__i_st = 0.014999999999999999 * (-37.399999999999999 + var_chaste_interface__membrane__V) * var_chaste_interface__sustained_inward_current_qa_gate__qa * var_chaste_interface__sustained_inward_current_qi_gate__qi; // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Nai = 6.4032609285536579e-6 * (-var_hyperpolarisation_activated_current__i_h_Na - var_sodium_dependent_background_current__i_b_Na - var_sustained_inward_current__i_st - 3.0 * var_sodium_calcium_exchange_current__i_NaCa - 3.0 * var_sodium_potassium_pump_current__i_NaK) * mParameters[0]; // millimolar / millisecond
        const double d_dt_chaste_interface_var_sustained_inward_current_qi_gate__qi = (-var_chaste_interface__sustained_inward_current_qi_gate__qi + var_sustained_inward_current_qi_gate__alpha_qi / (var_sustained_inward_current_qi_gate__alpha_qi + var_sustained_inward_current_qi_gate__beta_qi)) * (0.15037593984962405 * var_sustained_inward_current_qi_gate__alpha_qi + 0.15037593984962405 * var_sustained_inward_current_qi_gate__beta_qi); // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__V = -1.0 * var_AP_sensitive_currents__i_sus - 1.0 * var_AP_sensitive_currents__i_to - 1.0 * var_L_type_calcium_channel_current__i_CaL - 1.0 * var_T_type_calcium_channel_current__i_CaT - 1.0 * var_background_muscarinic_potassium_channel_current__i_K_ACh - 1.0 * var_hyperpolarisation_activated_current__i_h_K - 1.0 * var_hyperpolarisation_activated_current__i_h_Na - 1.0 * var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr - 1.0 * var_slowly_activating_delayed_rectifier_potassium_current__i_Ks - 1.0 * var_sodium_calcium_exchange_current__i_NaCa - 1.0 * var_sodium_dependent_background_current__i_b_Na - 1.0 * var_sodium_potassium_pump_current__i_NaK - 1.0 * var_sustained_inward_current__i_st; // millivolt / millisecond
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        mEvalF[1] = d_dt_chaste_interface_var_L_type_calcium_channel_current_d_gate__d;
        mEvalF[2] = d_dt_chaste_interface_var_L_type_calcium_channel_current_f_gate__f;
        mEvalF[3] = d_dt_chaste_interface_var_L_type_calcium_channel_current_fCa_gate__fCa;
        mEvalF[4] = d_dt_chaste_interface_var_T_type_calcium_channel_current_d_gate__d;
        mEvalF[5] = d_dt_chaste_interface_var_T_type_calcium_channel_current_f_gate__f;
        mEvalF[6] = d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS;
        mEvalF[7] = d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF;
        mEvalF[8] = d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy;
        mEvalF[9] = d_dt_chaste_interface_var_slowly_activating_delayed_rectifier_potassium_current_n_gate__n;
        mEvalF[10] = d_dt_chaste_interface_var_AP_sensitive_currents_q_gate__q;
        mEvalF[11] = d_dt_chaste_interface_var_AP_sensitive_currents_r_gate__r;
        mEvalF[12] = d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;
        mEvalF[13] = d_dt_chaste_interface_var_sustained_inward_current_qa_gate__qa;
        mEvalF[14] = d_dt_chaste_interface_var_sustained_inward_current_qi_gate__qi;
        mEvalF[15] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Cai;
        mEvalF[16] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_up;
        mEvalF[17] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_rel;
        mEvalF[18] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_sub;
        mEvalF[19] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Nai;
        mEvalF[20] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ki;
        mEvalF[21] = d_dt_chaste_interface_var_calcium_buffering__fTMM;
        mEvalF[22] = d_dt_chaste_interface_var_calcium_buffering__fCMi;
        mEvalF[23] = d_dt_chaste_interface_var_calcium_buffering__fCMs;
        mEvalF[24] = d_dt_chaste_interface_var_calcium_buffering__fTC;
        mEvalF[25] = d_dt_chaste_interface_var_calcium_buffering__fTMC;
        mEvalF[26] = d_dt_chaste_interface_var_calcium_buffering__fCQ;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time, rY, delta);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time, rY, delta);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time, rY, delta);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time, rY, delta);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time, rY, delta);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time, rY, delta);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time, rY, delta);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time, rY, delta);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time, rY, delta);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        rY[13] = y_save;
        
        
        y_save = rY[14];
        rY[14] = mYInit[14];
        mEvalF[14] = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        rY[14] = y_save;
        
        
        y_save = rY[15];
        rY[15] = mYInit[15];
        mEvalF[15] = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        rY[15] = y_save;
        
        
        y_save = rY[16];
        rY[16] = mYInit[16];
        mEvalF[16] = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        rY[16] = y_save;
        
        
        y_save = rY[17];
        rY[17] = mYInit[17];
        mEvalF[17] = EvaluateYDerivative17(var_chaste_interface__environment__time, rY);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time, rY, delta);
        rY[17] = y_save;
        
        
        y_save = rY[18];
        rY[18] = mYInit[18];
        mEvalF[18] = EvaluateYDerivative18(var_chaste_interface__environment__time, rY);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time, rY, delta);
        rY[18] = y_save;
        
        
        y_save = rY[19];
        rY[19] = mYInit[19];
        mEvalF[19] = EvaluateYDerivative19(var_chaste_interface__environment__time, rY);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time, rY, delta);
        rY[19] = y_save;
        
        
        y_save = rY[20];
        rY[20] = mYInit[20];
        mEvalF[20] = EvaluateYDerivative20(var_chaste_interface__environment__time, rY);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time, rY, delta);
        rY[20] = y_save;
        
        
        y_save = rY[21];
        rY[21] = mYInit[21];
        mEvalF[21] = EvaluateYDerivative21(var_chaste_interface__environment__time, rY);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time, rY, delta);
        rY[21] = y_save;
        
        
        y_save = rY[22];
        rY[22] = mYInit[22];
        mEvalF[22] = EvaluateYDerivative22(var_chaste_interface__environment__time, rY);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time, rY, delta);
        rY[22] = y_save;
        
        
        y_save = rY[23];
        rY[23] = mYInit[23];
        mEvalF[23] = EvaluateYDerivative23(var_chaste_interface__environment__time, rY);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time, rY, delta);
        rY[23] = y_save;
        
        
        y_save = rY[24];
        rY[24] = mYInit[24];
        mEvalF[24] = EvaluateYDerivative24(var_chaste_interface__environment__time, rY);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time, rY, delta);
        rY[24] = y_save;
        
        
        y_save = rY[25];
        rY[25] = mYInit[25];
        mEvalF[25] = EvaluateYDerivative25(var_chaste_interface__environment__time, rY);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time, rY, delta);
        rY[25] = y_save;
        
        
        y_save = rY[26];
        rY[26] = mYInit[26];
        mEvalF[26] = EvaluateYDerivative26(var_chaste_interface__environment__time, rY);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time, rY, delta);
        rY[26] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__L_type_calcium_channel_current_d_gate__d = rY[1];
        // Units: dimensionless; Initial value: 0.000602055134
        double var_chaste_interface__L_type_calcium_channel_current_f_gate__f = rY[2];
        // Units: dimensionless; Initial value: 0.626999773853
        double var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa = rY[3];
        // Units: dimensionless; Initial value: 0.589580408056
        double var_chaste_interface__T_type_calcium_channel_current_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 0.004571884917
        double var_chaste_interface__T_type_calcium_channel_current_f_gate__f = rY[5];
        // Units: dimensionless; Initial value: 0.249637570396
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = rY[6];
        // Units: dimensionless; Initial value: 0.629323128348
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = rY[7];
        // Units: dimensionless; Initial value: 0.3493633709533
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = rY[8];
        // Units: dimensionless; Initial value: 0.852396631172
        double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = rY[9];
        // Units: dimensionless; Initial value: 0.054409723782
        double var_chaste_interface__AP_sensitive_currents_q_gate__q = rY[10];
        // Units: dimensionless; Initial value: 0.531446952485
        double var_chaste_interface__AP_sensitive_currents_r_gate__r = rY[11];
        // Units: dimensionless; Initial value: 0.005550489445
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[12];
        // Units: dimensionless; Initial value: 0.067156687129
        double var_chaste_interface__sustained_inward_current_qa_gate__qa = rY[13];
        // Units: dimensionless; Initial value: 0.426018100136
        double var_chaste_interface__sustained_inward_current_qi_gate__qi = rY[14];
        // Units: dimensionless; Initial value: 0.333330378068
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
        // Units: millimolar; Initial value: 9.438646305915
        double var_chaste_interface__intracellular_ion_concentrations__Ki = rY[20];
        // Units: millimolar; Initial value: 139.984146485614
        
        
        // Mathematics
        const double var_L_type_calcium_channel_current__i_CaL = 0.57999999999999996 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_channel_current_d_gate__d * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa * var_chaste_interface__L_type_calcium_channel_current_f_gate__f; // picoA
        const double var_T_type_calcium_channel_current__i_CaT = 0.45800000000000002 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_calcium_channel_current_d_gate__d * var_chaste_interface__T_type_calcium_channel_current_f_gate__f; // picoA
        const double var_background_muscarinic_potassium_channel_current__i_K_ACh = 0.0021962113249247841 * var_chaste_interface__intracellular_ion_concentrations__Ki - 0.011859541154593834 * exp(-0.037415977988011655 * var_chaste_interface__membrane__V); // picoA
        const double var_reversal_potentials__E_K = 26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki); // millivolt
        const double var_AP_sensitive_currents__i_sus = 0.02 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_AP_sensitive_currents__i_to = 0.17999999999999999 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_hyperpolarisation_activated_current__i_h_K = 0.23126250000000001 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V); // picoA
        const double var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr = 0.067616443970885107 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (0.40000000000000002 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + 0.59999999999999998 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF) * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy; // picoA
        const double var_reversal_potentials__E_Na = 26.726549826397882 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai); // millivolt
        const double var_hyperpolarisation_activated_current__i_h_Na = 0.14373749999999999 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V); // picoA
        const double var_slowly_activating_delayed_rectifier_potassium_current__i_Ks = 0.025899999999999999 * pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2) * (-26.726549826397882 * log(22.199999999999999 / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.12 * var_chaste_interface__intracellular_ion_concentrations__Nai)) + var_chaste_interface__membrane__V); // picoA
        const double var_sodium_calcium_exchange_current__Qco = 0; // dimensionless
        const double var_sodium_calcium_exchange_current__di = 1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai; // dimensionless
        const double var_sodium_calcium_exchange_current__do = 4.8791826399715319 + 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco); // dimensionless
        const double var_sodium_calcium_exchange_current__k12 = 48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k14 = 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k21 = 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k23 = 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k32 = exp(0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k41 = exp(-0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k43 = var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai); // dimensionless
        const double var_sodium_calcium_exchange_current__i_NaCa = 125.0 * (((0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 - (0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12) / (0.96776646412697098 * (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k23 + 0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k21 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k23 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32); // picoA
        const double var_sodium_dependent_background_current__i_b_Na = 0.0054000000000000003 * var_chaste_interface__membrane__V - 0.0054000000000000003 * var_reversal_potentials__E_Na; // picoA
        const double var_sodium_potassium_pump_current__i_NaK = 3.0052188053939588 / ((1.0 + 30.900566853219949 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Nai, 1.3)) * (1.0 + exp(-4.0 + 0.033333333333333333 * var_reversal_potentials__E_Na - 0.033333333333333333 * var_chaste_interface__membrane__V))); // picoA
        const double var_sustained_inward_current__i_st = 0.014999999999999999 * (-37.399999999999999 + var_chaste_interface__membrane__V) * var_chaste_interface__sustained_inward_current_qa_gate__qa * var_chaste_interface__sustained_inward_current_qi_gate__qi; // picoA
        d_dt_chaste_interface_var_membrane__V = -1.0 * var_AP_sensitive_currents__i_sus - 1.0 * var_AP_sensitive_currents__i_to - 1.0 * var_L_type_calcium_channel_current__i_CaL - 1.0 * var_T_type_calcium_channel_current__i_CaT - 1.0 * var_background_muscarinic_potassium_channel_current__i_K_ACh - 1.0 * var_hyperpolarisation_activated_current__i_h_K - 1.0 * var_hyperpolarisation_activated_current__i_h_Na - 1.0 * var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr - 1.0 * var_slowly_activating_delayed_rectifier_potassium_current__i_Ks - 1.0 * var_sodium_calcium_exchange_current__i_NaCa - 1.0 * var_sodium_dependent_background_current__i_b_Na - 1.0 * var_sodium_potassium_pump_current__i_NaK - 1.0 * var_sustained_inward_current__i_st; // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane__V;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            double var_chaste_interface__L_type_calcium_channel_current_d_gate__d = rY[1];
            // Units: dimensionless; Initial value: 0.000602055134
            double var_chaste_interface__L_type_calcium_channel_current_f_gate__f = rY[2];
            // Units: dimensionless; Initial value: 0.626999773853
            double var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa = rY[3];
            // Units: dimensionless; Initial value: 0.589580408056
            double var_chaste_interface__T_type_calcium_channel_current_d_gate__d = rY[4];
            // Units: dimensionless; Initial value: 0.004571884917
            double var_chaste_interface__T_type_calcium_channel_current_f_gate__f = rY[5];
            // Units: dimensionless; Initial value: 0.249637570396
            double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = rY[6];
            // Units: dimensionless; Initial value: 0.629323128348
            double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = rY[7];
            // Units: dimensionless; Initial value: 0.3493633709533
            double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = rY[8];
            // Units: dimensionless; Initial value: 0.852396631172
            double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = rY[9];
            // Units: dimensionless; Initial value: 0.054409723782
            double var_chaste_interface__AP_sensitive_currents_q_gate__q = rY[10];
            // Units: dimensionless; Initial value: 0.531446952485
            double var_chaste_interface__AP_sensitive_currents_r_gate__r = rY[11];
            // Units: dimensionless; Initial value: 0.005550489445
            double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[12];
            // Units: dimensionless; Initial value: 0.067156687129
            double var_chaste_interface__sustained_inward_current_qa_gate__qa = rY[13];
            // Units: dimensionless; Initial value: 0.426018100136
            double var_chaste_interface__sustained_inward_current_qi_gate__qi = rY[14];
            // Units: dimensionless; Initial value: 0.333330378068
            double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
            // Units: millimolar; Initial value: 0.00019074741
            double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
            // Units: millimolar; Initial value: 9.438646305915
            
            const double var_x0 = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2);
            const double var_x1 = pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2);
            const double var_x2 = exp(-0.037415977988011655 * var_chaste_interface__membrane__V);
            const double var_x3 = -0.040569866382531065 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF - 0.027046577588354045 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS;
            const double var_x4 = var_x3 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy;
            const double var_x5 = exp(-0.0051222473865587953 * var_chaste_interface__membrane__V);
            const double var_x6 = 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x7 = 1.0 + var_x6;
            const double var_x8 = (var_x5 + var_x7) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
            const double var_x9 = var_x7 * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x10 = (1.0 + 0.43687199650502401 * var_x9) * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x11 = pow((0.0207 + var_x8 + 5.2365292183152033e-5 * var_x10), (-2));
            const double var_x12 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_sub, 2);
            const double var_x13 = var_x11 * var_x12 * pow(var_x5, 2);
            const double var_x14 = 0.0051222473865587953 * var_x13;
            const double var_x15 = 1 / (1.0 + 48.309178743961354 * var_x8 + 0.0025297242600556538 * var_x10);
            const double var_x16 = var_x5 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
            const double var_x17 = var_x15 * var_x16;
            const double var_x18 = 0.24745156456805775 * var_x17;
            const double var_x19 = pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2);
            const double var_x20 = 0.0080724972509135153 * var_chaste_interface__membrane__V;
            const double var_x21 = exp(var_x20);
            const double var_x22 = var_x15 * var_x21;
            const double var_x23 = var_x19 * var_x22;
            const double var_x24 = var_x23 * var_x7;
            const double var_x25 = var_x19 * var_x7;
            const double var_x26 = var_x21 * var_x25;
            const double var_x27 = 1.1718129359175982e-7 * var_x11 * var_x16;
            const double var_x28 = var_x14 - var_x18 + 8.9214469789726909e-6 * var_x24 + var_x26 * var_x27;
            const double var_x29 = 1 / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai);
            const double var_x30 = var_x29 * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x31 = var_x21 * var_x30;
            const double var_x32 = var_x28 * var_x31;
            const double var_x33 = 48.309178743961354 * var_x5;
            const double var_x34 = var_x15 * var_x33;
            const double var_x35 = var_x34 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
            const double var_x36 = var_x35 + 0.0011051656880977081 * var_x24;
            const double var_x37 = var_x21 * var_x36;
            const double var_x38 = var_x30 * var_x37;
            const double var_x39 = 0.0080724972509135153 * var_x38;
            const double var_x40 = exp(-var_x20);
            const double var_x41 = 0.96776646412697098 + var_x21;
            const double var_x42 = var_x40 * var_x41;
            const double var_x43 = var_x14 * var_x42;
            const double var_x44 = 0.38997571260451763 * var_x17 * var_x21 * var_x40;
            const double var_x45 = var_x17 * var_x42;
            const double var_x46 = 0.63742727717257541 * var_x45;
            const double var_x47 = exp(0);
            const double var_x48 = 0.54600054600054604 * var_x47;
            const double var_x49 = 1 / (4.8791826399715319 + var_x48);
            const double var_x50 = var_x48 * var_x49;
            const double var_x51 = var_x40 * var_x49;
            const double var_x52 = 0.66530580717983756 * var_x51;
            const double var_x53 = var_x50 + var_x52;
            const double var_x54 = var_x40 * var_x53;
            const double var_x55 = var_x30 + var_x40;
            const double var_x56 = var_x21 * var_x55;
            const double var_x57 = 0.96776646412697098 * var_x54 + var_x50 * var_x56;
            const double var_x58 = var_x49 * pow(var_x40, 2);
            const double var_x59 = 0.0051975633156138403 * var_x58;
            const double var_x60 = 0.64386064857757164 * var_x51;
            const double var_x61 = var_x47 * var_x49;
            const double var_x62 = 0.0080724972509135153 * var_x40 * (var_x60 + 0.52840101781434401 * var_x61);
            const double var_x63 = var_x56 * var_x61;
            const double var_x64 = 0.0044075879065866861 * var_x63;
            const double var_x65 = 0.0044075879065866861 * var_x21 * var_x47 * var_x51;
            const double var_x66 = var_x18 * var_x57 + var_x50 * (var_x32 + var_x39 + var_x43 + var_x44 - var_x46) - var_x14 * var_x57 - var_x35 * (var_x64 - var_x59 - var_x62 - var_x65);
            const double var_x67 = var_x29 * var_x53;
            const double var_x68 = pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3);
            const double var_x69 = var_x22 * var_x68;
            const double var_x70 = var_x67 * var_x69;
            const double var_x71 = var_x7 * var_x70;
            const double var_x72 = var_x51 * var_x55;
            const double var_x73 = 32.140377158446256 * var_x72;
            const double var_x74 = var_x41 * var_x61;
            const double var_x75 = var_x24 * var_x74;
            const double var_x76 = var_x38 + var_x35 * var_x42;
            const double var_x77 = 1 / (var_x57 + var_x76 + 0.0011051656880977081 * var_x71 + 0.00060342106912241779 * var_x75 + var_x17 * var_x73 + var_x36 * var_x60);
            const double var_x78 = 125.0 * var_x77;
            const double var_x79 = var_chaste_interface__sustained_inward_current_qa_gate__qa * var_chaste_interface__sustained_inward_current_qi_gate__qi;
            const double var_x80 = var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r;
            const double var_x81 = var_chaste_interface__T_type_calcium_channel_current_d_gate__d * var_chaste_interface__T_type_calcium_channel_current_f_gate__f;
            const double var_x82 = var_chaste_interface__L_type_calcium_channel_current_d_gate__d * var_chaste_interface__L_type_calcium_channel_current_f_gate__f;
            const double var_x83 = var_x82 * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa;
            const double var_x84 = var_x36 * var_x51;
            const double var_x85 = 4.871114921634011e-6 * var_x61;
            const double var_x86 = var_x69 * var_x7;
            const double var_x87 = var_x21 * var_x67 * var_x68 * var_x7;
            const double var_x88 = var_x26 * var_x74;
            const double var_x89 = var_x46 + var_x59 + var_x62 + var_x65 - var_x32 - var_x39 - var_x43 - var_x44 - var_x64 + 0.0051975633156138403 * var_x84 - 8.9214469789726909e-6 * var_x71 - var_x27 * var_x87 - var_x28 * var_x60 + 0.42408406915774627 * var_x17 * var_x72 + 0.25945310625488094 * var_x17 * var_x58 - 0.0034078609320893128 * var_x13 * var_x72 - var_x24 * var_x41 * var_x85 + 5.9354904835575489e-6 * var_x29 * var_x51 * var_x86 - 6.398105028215114e-8 * var_x11 * var_x16 * var_x88 - var_x15 * var_x25 * var_x85 * pow(var_x21, 2);
            const double var_x90 = (var_x50 * var_x76 - var_x35 * var_x57) / pow((var_x45 + 0.0207 * var_x38 + 0.020032765807428299 * var_x54 + 2.2876929743622558e-5 * var_x71 + 0.011302211302211302 * var_x63 + 1.2490816130834047e-5 * var_x75 + 0.013327915425555734 * var_x84 + var_x17 * var_x52 * var_x55), 2);
            const double var_x91 = 0.053561249999999998 * var_x90;
            const double var_x92 = 1 / var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x93 = pow(var_x92, 1.3);
            const double var_x94 = log(140.0 * var_x92);
            const double var_x95 = 0.033333333333333333 * var_chaste_interface__membrane__V;
            const double var_x96 = -var_x95;
            const double var_x97 = exp(-4.0 + var_x96 + 0.89088499421326284 * var_x94);
            const double var_x98 = 1.0 + var_x97;
            const double var_x99 = var_x97 / (pow(var_x98, 2) * (1.0 + 30.900566853219949 * var_x93));
            
            partialF = -0.0054000000000000003 + var_x4 - 0.375 * var_x0 - 0.014999999999999999 * var_x79 - 0.17999999999999999 * var_x80 - 0.025899999999999999 * var_x1 - 0.57999999999999996 * var_x83 - 0.02 * var_chaste_interface__AP_sensitive_currents_r_gate__r - 0.45800000000000002 * var_x81 - 0.10017396017979863 * var_x99 - 0.00044373633078820127 * var_x2 - var_x66 * var_x78 - var_x89 * var_x91;
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__L_type_calcium_channel_current_d_gate__d = rY[1];
        // Units: dimensionless; Initial value: 0.000602055134
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_L_type_calcium_channel_current_d_gate__d = (-var_chaste_interface__L_type_calcium_channel_current_d_gate__d + 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V))) * (0.011429999999999999 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)) - 0.028389999999999999 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V)) - 0.084900000000000003 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20798668885191349 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_calcium_channel_current_d_gate__d;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x162 = 0.40000000000000002 * var_chaste_interface__membrane__V;
            const double var_x163 = exp(-2.0 + var_x162);
            const double var_x164 = -1.0 + var_x163;
            const double var_x165 = 0.011429999999999999 / var_x164;
            const double var_x166 = exp(-14.0 - var_x162);
            const double var_x167 = -1.0 + var_x166;
            const double var_x168 = 0.028389999999999999 / var_x167;
            const double var_x169 = exp(-0.20798668885191349 * var_chaste_interface__membrane__V);
            const double var_x170 = -1.0 + var_x169;
            const double var_x171 = 0.084900000000000003 / var_x170;
            const double var_x172 = -5.0 + var_chaste_interface__membrane__V;
            const double var_x173 = 35.0 + var_chaste_interface__membrane__V;
            const double var_x174 = var_x165 * var_x172;
            const double var_x175 = var_x168 * var_x173;
            const double var_x176 = var_x171 * var_chaste_interface__membrane__V;
            
            partialF = var_x175 + var_x176 - var_x174;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__L_type_calcium_channel_current_f_gate__f = rY[2];
        // Units: dimensionless; Initial value: 0.626999773853
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_L_type_calcium_channel_current_f_gate__f = (-var_chaste_interface__L_type_calcium_channel_current_f_gate__f + 1 / (1.0 + exp(6.0 + 0.20000000000000001 * var_chaste_interface__membrane__V))) / (44.299999999999997 + 257.10000000000002 * exp(-5.4668495419491743 * pow((1 + 0.030769230769230771 * var_chaste_interface__membrane__V), 2))); // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_calcium_channel_current_f_gate__f;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x180 = exp(-5.4668495419491743 * pow((1 + 0.030769230769230771 * var_chaste_interface__membrane__V), 2));
            const double var_x181 = 1 / (44.299999999999997 + 257.10000000000002 * var_x180);
            
            partialF = -var_x181;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa = rY[3];
        // Units: dimensionless; Initial value: 0.589580408056
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
        // Units: millimolar; Initial value: 0.00019074741
        
        
        // Mathematics
        const double var_L_type_calcium_channel_current_fCa_gate__fCa_infinity = 0.00035 / (0.00035 + var_chaste_interface__intracellular_ion_concentrations__Ca_sub); // dimensionless
        const double d_dt_chaste_interface_var_L_type_calcium_channel_current_fCa_gate__fCa = 0.021000000000000001 * (-var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa + var_L_type_calcium_channel_current_fCa_gate__fCa_infinity) / var_L_type_calcium_channel_current_fCa_gate__fCa_infinity; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_calcium_channel_current_fCa_gate__fCa;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
            // Units: millimolar; Initial value: 0.00019074741
            
            const double var_x182 = 60.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
            
            partialF = -0.021000000000000001 - var_x182;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__T_type_calcium_channel_current_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 0.004571884917
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_T_type_calcium_channel_current_d_gate__d = (-var_chaste_interface__T_type_calcium_channel_current_d_gate__d + 1 / (1.0 + exp(-4.3833333333333337 - 0.16666666666666666 * var_chaste_interface__membrane__V))) * (1.0680000000000001 * exp(0.87666666666666671 + 0.033333333333333333 * var_chaste_interface__membrane__V) + 1.0680000000000001 * exp(-0.87666666666666671 - 0.033333333333333333 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_T_type_calcium_channel_current_d_gate__d;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x95 = 0.033333333333333333 * var_chaste_interface__membrane__V;
            const double var_x96 = -var_x95;
            const double var_x186 = exp(0.87666666666666671 + var_x95);
            const double var_x187 = exp(-0.87666666666666671 + var_x96);
            const double var_x188 = 1.0680000000000001 * var_x186;
            const double var_x189 = 1.0680000000000001 * var_x187;
            
            partialF = -var_x188 - var_x189;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__T_type_calcium_channel_current_f_gate__f = rY[5];
        // Units: dimensionless; Initial value: 0.249637570396
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_T_type_calcium_channel_current_f_gate__f = (-var_chaste_interface__T_type_calcium_channel_current_f_gate__f + 1 / (1.0 + exp(11.017857142857144 + 0.17857142857142858 * var_chaste_interface__membrane__V))) * (0.014999999999999999 * exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V) + 0.015299999999999999 * exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_T_type_calcium_channel_current_f_gate__f;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x192 = exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V);
            const double var_x193 = exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V);
            const double var_x194 = 0.014999999999999999 * var_x192;
            const double var_x195 = 0.015299999999999999 * var_x193;
            
            partialF = -var_x194 - var_x195;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = rY[6];
        // Units: dimensionless; Initial value: 0.629323128348
        
        
        // Mathematics
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity = 1 / (1.0 + exp(-2.1886792452830188 - 0.094339622641509441 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = (-var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity) * (0.0049612928202981696 * exp(0.058823529411764705 * var_chaste_interface__membrane__V) + 0.0001771890292963632 * exp(-0.046296296296296294 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x199 = exp(0.058823529411764705 * var_chaste_interface__membrane__V);
            const double var_x200 = exp(-0.046296296296296294 * var_chaste_interface__membrane__V);
            const double var_x201 = 0.0049612928202981696 * var_x199;
            const double var_x202 = 0.0001771890292963632 * var_x200;
            
            partialF = -var_x201 - var_x202;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = rY[7];
        // Units: dimensionless; Initial value: 0.3493633709533
        
        
        // Mathematics
        const double var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity = 1 / (1.0 + exp(-2.1886792452830188 - 0.094339622641509441 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = (-var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF + var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__pa_infinity) * (0.043942879265498072 * exp(0.062893081761006289 * var_chaste_interface__membrane__V) + 0.0011340097874967246 * exp(-0.044444444444444446 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x204 = exp(0.062893081761006289 * var_chaste_interface__membrane__V);
            const double var_x205 = exp(-0.044444444444444446 * var_chaste_interface__membrane__V);
            const double var_x206 = 0.043942879265498072 * var_x204;
            const double var_x207 = 0.0011340097874967246 * var_x205;
            
            partialF = -var_x206 - var_x207;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = rY[8];
        // Units: dimensionless; Initial value: 0.852396631172
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = (-var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy + 1 / (1.0 + exp(1.672514619883041 + 0.058479532163742687 * var_chaste_interface__membrane__V))) * (0.10000000000000001 * exp(-0.018299935950224173 * var_chaste_interface__membrane__V) + 0.65600000000000003 * exp(0.009420009985210585 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x210 = exp(0.009420009985210585 * var_chaste_interface__membrane__V);
            const double var_x211 = exp(-0.018299935950224173 * var_chaste_interface__membrane__V);
            const double var_x212 = 0.10000000000000001 * var_x211;
            const double var_x213 = 0.65600000000000003 * var_x210;
            
            partialF = -var_x212 - var_x213;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = rY[9];
        // Units: dimensionless; Initial value: 0.054409723782
        
        
        // Mathematics
        const double var_slowly_activating_delayed_rectifier_potassium_current_n_gate__alpha_n = 0.014 / (1.0 + exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_slowly_activating_delayed_rectifier_potassium_current_n_gate__beta_n = 0.001 * exp(-0.022222222222222223 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_slowly_activating_delayed_rectifier_potassium_current_n_gate__n = (-var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n + var_slowly_activating_delayed_rectifier_potassium_current_n_gate__alpha_n / (var_slowly_activating_delayed_rectifier_potassium_current_n_gate__alpha_n + var_slowly_activating_delayed_rectifier_potassium_current_n_gate__beta_n)) * (var_slowly_activating_delayed_rectifier_potassium_current_n_gate__alpha_n + var_slowly_activating_delayed_rectifier_potassium_current_n_gate__beta_n); // 1 / millisecond

        return d_dt_chaste_interface_var_slowly_activating_delayed_rectifier_potassium_current_n_gate__n;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x214 = exp(-0.022222222222222223 * var_chaste_interface__membrane__V);
            const double var_x215 = 0.001 * var_x214;
            const double var_x216 = exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V);
            const double var_x217 = 1.0 + var_x216;
            const double var_x218 = 1 / var_x217;
            const double var_x219 = 0.014 * var_x218;
            
            partialF = -var_x215 - var_x219;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__AP_sensitive_currents_q_gate__q = rY[10];
        // Units: dimensionless; Initial value: 0.531446952485
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_AP_sensitive_currents_q_gate__q = (-var_chaste_interface__AP_sensitive_currents_q_gate__q + 1 / (1.0 + exp(3.7692307692307692 + 0.076923076923076927 * var_chaste_interface__membrane__V))) / (6.0599999999999996 + 39.101999999999997 / (0.065000000000000002 * exp(4.593 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 0.56999999999999995 * exp(-3.52 - 0.080000000000000002 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_AP_sensitive_currents_q_gate__q;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x227 = exp(4.593 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x228 = exp(-3.52 - 0.080000000000000002 * var_chaste_interface__membrane__V);
            const double var_x229 = 1 / (0.065000000000000002 * var_x227 + 0.56999999999999995 * var_x228);
            const double var_x230 = 1 / (6.0599999999999996 + 39.101999999999997 * var_x229);
            
            partialF = -var_x230;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__AP_sensitive_currents_r_gate__r = rY[11];
        // Units: dimensionless; Initial value: 0.005550489445
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_AP_sensitive_currents_r_gate__r = (-var_chaste_interface__AP_sensitive_currents_r_gate__r + 1 / (1.0 + exp(1.2866666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V))) / (2.75352 + 14.40516 / (1.0369999999999999 * exp(2.7548999999999997 + 0.089999999999999997 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8607999999999998 - 0.12 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_AP_sensitive_currents_r_gate__r;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x233 = exp(2.7548999999999997 + 0.089999999999999997 * var_chaste_interface__membrane__V);
            const double var_x234 = exp(-2.8607999999999998 - 0.12 * var_chaste_interface__membrane__V);
            const double var_x235 = 1 / (1.0369999999999999 * var_x233 + 0.36899999999999999 * var_x234);
            const double var_x236 = 1 / (2.75352 + 14.40516 * var_x235);
            
            partialF = -var_x236;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[12];
        // Units: dimensionless; Initial value: 0.067156687129
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y = (-var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + 1 / (1.0 + exp(4.7407407407407405 + 0.07407407407407407 * var_chaste_interface__membrane__V))) * (1.3953756414018557 * exp(-8.5404617897664554 - 0.022074080614542406 * var_chaste_interface__membrane__V) + 1.3953756414018557 * exp(-3.8001143986272159 + 0.051999376007487906 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x239 = exp(-3.8001143986272159 + 0.051999376007487906 * var_chaste_interface__membrane__V);
            const double var_x240 = exp(-8.5404617897664554 - 0.022074080614542406 * var_chaste_interface__membrane__V);
            const double var_x241 = 1.3953756414018557 * var_x240;
            const double var_x242 = 1.3953756414018557 * var_x239;
            
            partialF = -var_x241 - var_x242;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__sustained_inward_current_qa_gate__qa = rY[13];
        // Units: dimensionless; Initial value: 0.426018100136
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_sustained_inward_current_qa_gate__qa = (-var_chaste_interface__sustained_inward_current_qa_gate__qa + 1 / (1.0 + exp(-11.4 - 0.20000000000000001 * var_chaste_interface__membrane__V))) * (1 / (16.0 * exp(0.125 * var_chaste_interface__membrane__V) + 15.0 * exp(0.02 * var_chaste_interface__membrane__V)) + 1 / (0.20000000000000001 * exp(-0.0014285714285714286 * var_chaste_interface__membrane__V) + 0.14999999999999999 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_sustained_inward_current_qa_gate__qa;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x246 = exp(0.02 * var_chaste_interface__membrane__V);
            const double var_x247 = exp(0.125 * var_chaste_interface__membrane__V);
            const double var_x248 = exp(-0.090909090909090912 * var_chaste_interface__membrane__V);
            const double var_x249 = exp(-0.0014285714285714286 * var_chaste_interface__membrane__V);
            const double var_x250 = 1 / (16.0 * var_x247 + 15.0 * var_x246);
            const double var_x251 = 1 / (0.20000000000000001 * var_x249 + 0.14999999999999999 * var_x248);
            
            partialF = -var_x250 - var_x251;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__sustained_inward_current_qi_gate__qi = rY[14];
        // Units: dimensionless; Initial value: 0.333330378068
        
        
        // Mathematics
        const double var_sustained_inward_current_qi_gate__alpha_qi = 1 / (700.0 * exp(0.014285714285714285 * var_chaste_interface__membrane__V) + 3100.0 * exp(0.076923076923076927 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_sustained_inward_current_qi_gate__beta_qi = 1 / (50.0 * exp(-0.0014285714285714286 * var_chaste_interface__membrane__V) + 95.0 * exp(-0.10000000000000001 * var_chaste_interface__membrane__V)) + 0.00022900000000000001 / (1.0 + exp(-0.20000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double d_dt_chaste_interface_var_sustained_inward_current_qi_gate__qi = (-var_chaste_interface__sustained_inward_current_qi_gate__qi + var_sustained_inward_current_qi_gate__alpha_qi / (var_sustained_inward_current_qi_gate__alpha_qi + var_sustained_inward_current_qi_gate__beta_qi)) * (0.15037593984962405 * var_sustained_inward_current_qi_gate__alpha_qi + 0.15037593984962405 * var_sustained_inward_current_qi_gate__beta_qi); // 1 / millisecond

        return d_dt_chaste_interface_var_sustained_inward_current_qi_gate__qi;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            
            const double var_x177 = 0.20000000000000001 * var_chaste_interface__membrane__V;
            const double var_x224 = 0.076923076923076927 * var_chaste_interface__membrane__V;
            const double var_x243 = -var_x177;
            const double var_x249 = exp(-0.0014285714285714286 * var_chaste_interface__membrane__V);
            const double var_x252 = exp(-0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x253 = 1 / (50.0 * var_x249 + 95.0 * var_x252);
            const double var_x254 = exp(0.014285714285714285 * var_chaste_interface__membrane__V);
            const double var_x255 = exp(var_x224);
            const double var_x256 = 1 / (700.0 * var_x254 + 3100.0 * var_x255);
            const double var_x258 = exp(var_x243);
            const double var_x259 = 1.0 + var_x258;
            const double var_x260 = 1 / var_x259;
            const double var_x267 = 3.4436090225563911e-5 * var_x260;
            const double var_x268 = 0.15037593984962405 * var_x253;
            const double var_x269 = 0.15037593984962405 * var_x256;
            
            partialF = -var_x267 - var_x268 - var_x269;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[15];
        // Units: millimolar; Initial value: 0.000312494921
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__calcium_buffering__fTMM = rY[21];
        // Units: millimolar; Initial value: 0.350600895635
        double var_chaste_interface__calcium_buffering__fCMi = rY[22];
        // Units: millimolar; Initial value: 0.116947220413
        double var_chaste_interface__calcium_buffering__fTC = rY[24];
        // Units: millimolar; Initial value: 0.059206293446
        double var_chaste_interface__calcium_buffering__fTMC = rY[25];
        // Units: millimolar; Initial value: 0.602955114871
        
        
        // Mathematics
        const double var_calcium_buffering__delta_fCMi = -0.54200000000000004 * var_chaste_interface__calcium_buffering__fCMi + 227.69999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fCMi) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double var_calcium_buffering__delta_fTC = -0.44600000000000001 * var_chaste_interface__calcium_buffering__fTC + 88.799999999999997 * (1.0 - var_chaste_interface__calcium_buffering__fTC) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double var_calcium_buffering__delta_fTMC = -0.0075100000000000002 * var_chaste_interface__calcium_buffering__fTMC + 227.69999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fTMC - var_chaste_interface__calcium_buffering__fTMM) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double var_intracellular_calcium_dynamics__j_Ca_dif = 25.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub - 25.0 * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double var_intracellular_calcium_dynamics__j_up = 0.0050000000000000001 / (1.0 + 0.00059999999999999995 / var_chaste_interface__intracellular_ion_concentrations__Cai); // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Cai = 0.022164824755288914 * var_intracellular_calcium_dynamics__j_Ca_dif - 0.031 * var_calcium_buffering__delta_fTC - 0.062 * var_calcium_buffering__delta_fTMC - 0.044999999999999998 * var_calcium_buffering__delta_fCMi - 0.025775813072308175 * var_intracellular_calcium_dynamics__j_up; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__Cai;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[15];
            // Units: millimolar; Initial value: 0.000312494921
            double var_chaste_interface__calcium_buffering__fTMM = rY[21];
            // Units: millimolar; Initial value: 0.350600895635
            double var_chaste_interface__calcium_buffering__fCMi = rY[22];
            // Units: millimolar; Initial value: 0.116947220413
            double var_chaste_interface__calcium_buffering__fTC = rY[24];
            // Units: millimolar; Initial value: 0.059206293446
            double var_chaste_interface__calcium_buffering__fTMC = rY[25];
            // Units: millimolar; Initial value: 0.602955114871
            
            const double var_x270 = 1 / (pow((1.0 + 0.00059999999999999995 / var_chaste_interface__intracellular_ion_concentrations__Cai), 2) * pow(var_chaste_interface__intracellular_ion_concentrations__Cai, 2));
            
            partialF = -27.670820618882221 + 10.246499999999999 * var_chaste_interface__calcium_buffering__fCMi + 2.7527999999999997 * var_chaste_interface__calcium_buffering__fTC + 14.1174 * var_chaste_interface__calcium_buffering__fTMC + 14.1174 * var_chaste_interface__calcium_buffering__fTMM - 7.7327439216924522e-8 * var_x270;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[15];
        // Units: millimolar; Initial value: 0.000312494921
        double var_chaste_interface__intracellular_ion_concentrations__Ca_up = rY[16];
        // Units: millimolar; Initial value: 1.462338380106
        double var_chaste_interface__intracellular_ion_concentrations__Ca_rel = rY[17];
        // Units: millimolar; Initial value: 0.296742023718
        
        
        // Mathematics
        const double var_intracellular_calcium_dynamics__j_tr = 0.016666666666666666 * var_chaste_interface__intracellular_ion_concentrations__Ca_up - 0.016666666666666666 * var_chaste_interface__intracellular_ion_concentrations__Ca_rel; // millimolar_per_millisecond
        const double var_intracellular_calcium_dynamics__j_up = 0.0050000000000000001 / (1.0 + 0.00059999999999999995 / var_chaste_interface__intracellular_ion_concentrations__Cai); // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_up = -0.10344717757742063 * var_intracellular_calcium_dynamics__j_tr + var_intracellular_calcium_dynamics__j_up; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_up;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.0017241196262903437;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_up = rY[16];
        // Units: millimolar; Initial value: 1.462338380106
        double var_chaste_interface__intracellular_ion_concentrations__Ca_rel = rY[17];
        // Units: millimolar; Initial value: 0.296742023718
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__calcium_buffering__fCQ = rY[26];
        // Units: millimolar; Initial value: 0.260317260703
        
        
        // Mathematics
        const double var_calcium_buffering__delta_fCQ = -0.44500000000000001 * var_chaste_interface__calcium_buffering__fCQ + 0.53400000000000003 * (1.0 - var_chaste_interface__calcium_buffering__fCQ) * var_chaste_interface__intracellular_ion_concentrations__Ca_rel; // millimolar_per_millisecond
        const double var_intracellular_calcium_dynamics__j_rel = 0.5 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_sub + var_chaste_interface__intracellular_ion_concentrations__Ca_rel) / (1.0 + 1.4399999999999998e-6 / pow(var_chaste_interface__intracellular_ion_concentrations__Ca_sub, 2)); // millimolar_per_millisecond
        const double var_intracellular_calcium_dynamics__j_tr = 0.016666666666666666 * var_chaste_interface__intracellular_ion_concentrations__Ca_up - 0.016666666666666666 * var_chaste_interface__intracellular_ion_concentrations__Ca_rel; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_rel = -var_intracellular_calcium_dynamics__j_rel - 10.0 * var_calcium_buffering__delta_fCQ + var_intracellular_calcium_dynamics__j_tr; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_rel;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
            // Units: millimolar; Initial value: 0.00019074741
            double var_chaste_interface__calcium_buffering__fCQ = rY[26];
            // Units: millimolar; Initial value: 0.260317260703
            
            const double var_x12 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_sub, 2);
            const double var_x272 = 1.0 + 1.4399999999999998e-6 / var_x12;
            const double var_x273 = 1 / var_x272;
            const double var_x274 = 0.5 * var_x273;
            
            partialF = -5.3566666666666674 - var_x274 + 5.3399999999999999 * var_chaste_interface__calcium_buffering__fCQ;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__L_type_calcium_channel_current_d_gate__d = rY[1];
        // Units: dimensionless; Initial value: 0.000602055134
        double var_chaste_interface__L_type_calcium_channel_current_f_gate__f = rY[2];
        // Units: dimensionless; Initial value: 0.626999773853
        double var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa = rY[3];
        // Units: dimensionless; Initial value: 0.589580408056
        double var_chaste_interface__T_type_calcium_channel_current_d_gate__d = rY[4];
        // Units: dimensionless; Initial value: 0.004571884917
        double var_chaste_interface__T_type_calcium_channel_current_f_gate__f = rY[5];
        // Units: dimensionless; Initial value: 0.249637570396
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[15];
        // Units: millimolar; Initial value: 0.000312494921
        double var_chaste_interface__intracellular_ion_concentrations__Ca_rel = rY[17];
        // Units: millimolar; Initial value: 0.296742023718
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
        // Units: millimolar; Initial value: 9.438646305915
        double var_chaste_interface__calcium_buffering__fCMs = rY[23];
        // Units: millimolar; Initial value: 0.074631965653
        
        
        // Mathematics
        const double var_calcium_buffering__delta_fCMs = -0.54200000000000004 * var_chaste_interface__calcium_buffering__fCMs + 227.69999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fCMs) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub; // millimolar_per_millisecond
        const double var_intracellular_calcium_dynamics__j_rel = 0.5 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_sub + var_chaste_interface__intracellular_ion_concentrations__Ca_rel) / (1.0 + 1.4399999999999998e-6 / pow(var_chaste_interface__intracellular_ion_concentrations__Ca_sub, 2)); // millimolar_per_millisecond
        const double var_intracellular_calcium_dynamics__j_Ca_dif = 25.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub - 25.0 * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double var_L_type_calcium_channel_current__i_CaL = 0.57999999999999996 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_channel_current_d_gate__d * var_chaste_interface__L_type_calcium_channel_current_fCa_gate__fCa * var_chaste_interface__L_type_calcium_channel_current_f_gate__f; // picoA
        const double var_T_type_calcium_channel_current__i_CaT = 0.45800000000000002 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_calcium_channel_current_d_gate__d * var_chaste_interface__T_type_calcium_channel_current_f_gate__f; // picoA
        const double var_sodium_calcium_exchange_current__Qco = 0; // dimensionless
        const double var_sodium_calcium_exchange_current__di = 1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai; // dimensionless
        const double var_sodium_calcium_exchange_current__do = 4.8791826399715319 + 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco); // dimensionless
        const double var_sodium_calcium_exchange_current__k12 = 48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k14 = 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k21 = 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k23 = 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k32 = exp(0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k41 = exp(-0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k43 = var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai); // dimensionless
        const double var_sodium_calcium_exchange_current__i_NaCa = 125.0 * (((0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 - (0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12) / (0.96776646412697098 * (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k23 + 0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k21 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k23 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32); // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_sub = -var_intracellular_calcium_dynamics__j_Ca_dif + 0.12030030201151064 * var_intracellular_calcium_dynamics__j_rel - 0.044999999999999998 * var_calcium_buffering__delta_fCMs + 0.00014764809009680174 * (-var_L_type_calcium_channel_current__i_CaL - var_T_type_calcium_channel_current__i_CaT + 2.0 * var_sodium_calcium_exchange_current__i_NaCa) * mParameters[0]; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_sub;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            double var_chaste_interface__intracellular_ion_concentrations__Ca_rel = rY[17];
            // Units: millimolar; Initial value: 0.296742023718
            double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
            // Units: millimolar; Initial value: 0.00019074741
            double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
            // Units: millimolar; Initial value: 9.438646305915
            double var_chaste_interface__calcium_buffering__fCMs = rY[23];
            // Units: millimolar; Initial value: 0.074631965653
            
            const double var_x5 = exp(-0.0051222473865587953 * var_chaste_interface__membrane__V);
            const double var_x6 = 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x7 = 1.0 + var_x6;
            const double var_x8 = (var_x5 + var_x7) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
            const double var_x9 = var_x7 * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x10 = (1.0 + 0.43687199650502401 * var_x9) * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x11 = pow((0.0207 + var_x8 + 5.2365292183152033e-5 * var_x10), (-2));
            const double var_x12 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_sub, 2);
            const double var_x15 = 1 / (1.0 + 48.309178743961354 * var_x8 + 0.0025297242600556538 * var_x10);
            const double var_x16 = var_x5 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
            const double var_x17 = var_x15 * var_x16;
            const double var_x19 = pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2);
            const double var_x20 = 0.0080724972509135153 * var_chaste_interface__membrane__V;
            const double var_x21 = exp(var_x20);
            const double var_x22 = var_x15 * var_x21;
            const double var_x23 = var_x19 * var_x22;
            const double var_x24 = var_x23 * var_x7;
            const double var_x25 = var_x19 * var_x7;
            const double var_x26 = var_x21 * var_x25;
            const double var_x29 = 1 / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai);
            const double var_x30 = var_x29 * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x31 = var_x21 * var_x30;
            const double var_x33 = 48.309178743961354 * var_x5;
            const double var_x34 = var_x15 * var_x33;
            const double var_x35 = var_x34 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
            const double var_x36 = var_x35 + 0.0011051656880977081 * var_x24;
            const double var_x37 = var_x21 * var_x36;
            const double var_x38 = var_x30 * var_x37;
            const double var_x40 = exp(-var_x20);
            const double var_x41 = 0.96776646412697098 + var_x21;
            const double var_x42 = var_x40 * var_x41;
            const double var_x45 = var_x17 * var_x42;
            const double var_x47 = exp(0);
            const double var_x48 = 0.54600054600054604 * var_x47;
            const double var_x49 = 1 / (4.8791826399715319 + var_x48);
            const double var_x50 = var_x48 * var_x49;
            const double var_x51 = var_x40 * var_x49;
            const double var_x52 = 0.66530580717983756 * var_x51;
            const double var_x53 = var_x50 + var_x52;
            const double var_x54 = var_x40 * var_x53;
            const double var_x55 = var_x30 + var_x40;
            const double var_x56 = var_x21 * var_x55;
            const double var_x57 = 0.96776646412697098 * var_x54 + var_x50 * var_x56;
            const double var_x60 = 0.64386064857757164 * var_x51;
            const double var_x61 = var_x47 * var_x49;
            const double var_x63 = var_x56 * var_x61;
            const double var_x67 = var_x29 * var_x53;
            const double var_x68 = pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3);
            const double var_x69 = var_x22 * var_x68;
            const double var_x70 = var_x67 * var_x69;
            const double var_x71 = var_x7 * var_x70;
            const double var_x72 = var_x51 * var_x55;
            const double var_x73 = 32.140377158446256 * var_x72;
            const double var_x74 = var_x41 * var_x61;
            const double var_x75 = var_x24 * var_x74;
            const double var_x76 = var_x38 + var_x35 * var_x42;
            const double var_x77 = 1 / (var_x57 + var_x76 + 0.0011051656880977081 * var_x71 + 0.00060342106912241779 * var_x75 + var_x17 * var_x73 + var_x36 * var_x60);
            const double var_x84 = var_x36 * var_x51;
            const double var_x87 = var_x21 * var_x67 * var_x68 * var_x7;
            const double var_x88 = var_x26 * var_x74;
            const double var_x90 = (var_x50 * var_x76 - var_x35 * var_x57) / pow((var_x45 + 0.0207 * var_x38 + 0.020032765807428299 * var_x54 + 2.2876929743622558e-5 * var_x71 + 0.011302211302211302 * var_x63 + 1.2490816130834047e-5 * var_x75 + 0.013327915425555734 * var_x84 + var_x17 * var_x52 * var_x55), 2);
            const double var_x124 = var_x11 * (-48.309178743961354 - var_x33 - 1.8271247633873431 * var_chaste_interface__intracellular_ion_concentrations__Nai);
            const double var_x125 = 0.0207 * var_x16;
            const double var_x126 = var_x124 * var_x125;
            const double var_x127 = 4.7355244569298691e-7 * var_x26;
            const double var_x128 = var_x126 + var_x34 + var_x124 * var_x127;
            const double var_x129 = var_x128 * var_x31;
            const double var_x130 = var_x34 * var_x42;
            const double var_x131 = var_x126 * var_x42;
            const double var_x132 = var_x50 * (var_x129 + var_x130 + var_x131) - var_x126 * var_x57 - var_x34 * var_x57;
            const double var_x133 = 0.013771830208622637 * var_x16 * var_x72;
            const double var_x134 = 4.7355244569298691e-7 * var_x87;
            const double var_x135 = 2.5855989390826479e-7 * var_x88;
            const double var_x136 = -var_x129 - var_x130 - var_x131 - var_x124 * var_x133 - var_x124 * var_x134 - var_x124 * var_x135 - var_x128 * var_x60 - var_x15 * var_x5 * var_x73;
            const double var_x272 = 1.0 + 1.4399999999999998e-6 / var_x12;
            const double var_x273 = 1 / var_x272;
            const double var_x275 = (-var_chaste_interface__intracellular_ion_concentrations__Ca_sub + var_chaste_interface__intracellular_ion_concentrations__Ca_rel) / (pow(var_x272, 2) * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_sub, 3));
            const double var_x276 = 0.036912022524200436 * var_x77;
            const double var_x277 = 1.5816432531394641e-5 * var_x90;
            const double var_x279 = 0.060150151005755319 * var_x273;
            
            partialF = -35.246499999999997 - var_x279 + 10.246499999999999 * var_chaste_interface__calcium_buffering__fCMs + 1.7323243489657528e-7 * var_x275 + (var_x132 * var_x276 + var_x136 * var_x277) * mParameters[0];
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[12];
        // Units: dimensionless; Initial value: 0.067156687129
        double var_chaste_interface__sustained_inward_current_qa_gate__qa = rY[13];
        // Units: dimensionless; Initial value: 0.426018100136
        double var_chaste_interface__sustained_inward_current_qi_gate__qi = rY[14];
        // Units: dimensionless; Initial value: 0.333330378068
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
        // Units: millimolar; Initial value: 9.438646305915
        
        
        // Mathematics
        const double var_reversal_potentials__E_Na = 26.726549826397882 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai); // millivolt
        const double var_hyperpolarisation_activated_current__i_h_Na = 0.14373749999999999 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V); // picoA
        const double var_sodium_calcium_exchange_current__Qco = 0; // dimensionless
        const double var_sodium_calcium_exchange_current__di = 1.0 + 48.309178743961354 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai + exp(-0.0051222473865587953 * var_chaste_interface__membrane__V)) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub + 0.0025297242600556538 * (1.0 + 0.43687199650502401 * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai; // dimensionless
        const double var_sodium_calcium_exchange_current__do = 4.8791826399715319 + 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco); // dimensionless
        const double var_sodium_calcium_exchange_current__k12 = 48.309178743961354 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub * exp(-0.0051222473865587953 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k14 = 0.0011051656880977081 * pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2) * (1.0 + 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai) * exp(0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__di; // dimensionless
        const double var_sodium_calcium_exchange_current__k21 = 0.54600054600054604 * exp(0.037415977988011655 * var_chaste_interface__membrane__V * var_sodium_calcium_exchange_current__Qco) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k23 = 0.66530580717983756 * exp(-0.0080724972509135153 * var_chaste_interface__membrane__V) / var_sodium_calcium_exchange_current__do; // dimensionless
        const double var_sodium_calcium_exchange_current__k32 = exp(0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k41 = exp(-0.0080724972509135153 * var_chaste_interface__membrane__V); // dimensionless
        const double var_sodium_calcium_exchange_current__k43 = var_chaste_interface__intracellular_ion_concentrations__Nai / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai); // dimensionless
        const double var_sodium_calcium_exchange_current__i_NaCa = 125.0 * (((0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 - (0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12) / (0.96776646412697098 * (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k23 + 0.96776646412697098 * (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k41 + (0.96776646412697098 + var_sodium_calcium_exchange_current__k32) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k21 + (var_sodium_calcium_exchange_current__k12 + var_sodium_calcium_exchange_current__k14) * var_sodium_calcium_exchange_current__k32 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k21 + var_sodium_calcium_exchange_current__k23) * var_sodium_calcium_exchange_current__k14 * var_sodium_calcium_exchange_current__k43 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k12 * var_sodium_calcium_exchange_current__k23 + (var_sodium_calcium_exchange_current__k41 + var_sodium_calcium_exchange_current__k43) * var_sodium_calcium_exchange_current__k21 * var_sodium_calcium_exchange_current__k32); // picoA
        const double var_sodium_dependent_background_current__i_b_Na = 0.0054000000000000003 * var_chaste_interface__membrane__V - 0.0054000000000000003 * var_reversal_potentials__E_Na; // picoA
        const double var_sodium_potassium_pump_current__i_NaK = 3.0052188053939588 / ((1.0 + 30.900566853219949 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Nai, 1.3)) * (1.0 + exp(-4.0 + 0.033333333333333333 * var_reversal_potentials__E_Na - 0.033333333333333333 * var_chaste_interface__membrane__V))); // picoA
        const double var_sustained_inward_current__i_st = 0.014999999999999999 * (-37.399999999999999 + var_chaste_interface__membrane__V) * var_chaste_interface__sustained_inward_current_qa_gate__qa * var_chaste_interface__sustained_inward_current_qi_gate__qi; // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Nai = 6.4032609285536579e-6 * (-var_hyperpolarisation_activated_current__i_h_Na - var_sodium_dependent_background_current__i_b_Na - var_sustained_inward_current__i_st - 3.0 * var_sodium_calcium_exchange_current__i_NaCa - 3.0 * var_sodium_potassium_pump_current__i_NaK) * mParameters[0]; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__Nai;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -58.600291137693
            double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[12];
            // Units: dimensionless; Initial value: 0.067156687129
            double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
            // Units: millimolar; Initial value: 0.00019074741
            double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
            // Units: millimolar; Initial value: 9.438646305915
            
            const double var_x0 = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2);
            const double var_x5 = exp(-0.0051222473865587953 * var_chaste_interface__membrane__V);
            const double var_x6 = 0.037821482602117998 * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x7 = 1.0 + var_x6;
            const double var_x8 = (var_x5 + var_x7) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
            const double var_x9 = var_x7 * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x10 = (1.0 + 0.43687199650502401 * var_x9) * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x11 = pow((0.0207 + var_x8 + 5.2365292183152033e-5 * var_x10), (-2));
            const double var_x15 = 1 / (1.0 + 48.309178743961354 * var_x8 + 0.0025297242600556538 * var_x10);
            const double var_x16 = var_x5 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
            const double var_x17 = var_x15 * var_x16;
            const double var_x19 = pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 2);
            const double var_x20 = 0.0080724972509135153 * var_chaste_interface__membrane__V;
            const double var_x21 = exp(var_x20);
            const double var_x22 = var_x15 * var_x21;
            const double var_x23 = var_x19 * var_x22;
            const double var_x24 = var_x23 * var_x7;
            const double var_x25 = var_x19 * var_x7;
            const double var_x26 = var_x21 * var_x25;
            const double var_x29 = 1 / (26.440000000000001 + var_chaste_interface__intracellular_ion_concentrations__Nai);
            const double var_x30 = var_x29 * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x31 = var_x21 * var_x30;
            const double var_x33 = 48.309178743961354 * var_x5;
            const double var_x34 = var_x15 * var_x33;
            const double var_x35 = var_x34 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
            const double var_x36 = var_x35 + 0.0011051656880977081 * var_x24;
            const double var_x37 = var_x21 * var_x36;
            const double var_x38 = var_x30 * var_x37;
            const double var_x40 = exp(-var_x20);
            const double var_x41 = 0.96776646412697098 + var_x21;
            const double var_x42 = var_x40 * var_x41;
            const double var_x45 = var_x17 * var_x42;
            const double var_x47 = exp(0);
            const double var_x48 = 0.54600054600054604 * var_x47;
            const double var_x49 = 1 / (4.8791826399715319 + var_x48);
            const double var_x50 = var_x48 * var_x49;
            const double var_x51 = var_x40 * var_x49;
            const double var_x52 = 0.66530580717983756 * var_x51;
            const double var_x53 = var_x50 + var_x52;
            const double var_x54 = var_x40 * var_x53;
            const double var_x55 = var_x30 + var_x40;
            const double var_x56 = var_x21 * var_x55;
            const double var_x57 = 0.96776646412697098 * var_x54 + var_x50 * var_x56;
            const double var_x60 = 0.64386064857757164 * var_x51;
            const double var_x61 = var_x47 * var_x49;
            const double var_x63 = var_x56 * var_x61;
            const double var_x67 = var_x29 * var_x53;
            const double var_x68 = pow(var_chaste_interface__intracellular_ion_concentrations__Nai, 3);
            const double var_x69 = var_x22 * var_x68;
            const double var_x70 = var_x67 * var_x69;
            const double var_x71 = var_x7 * var_x70;
            const double var_x72 = var_x51 * var_x55;
            const double var_x73 = 32.140377158446256 * var_x72;
            const double var_x74 = var_x41 * var_x61;
            const double var_x75 = var_x24 * var_x74;
            const double var_x76 = var_x38 + var_x35 * var_x42;
            const double var_x77 = 1 / (var_x57 + var_x76 + 0.0011051656880977081 * var_x71 + 0.00060342106912241779 * var_x75 + var_x17 * var_x73 + var_x36 * var_x60);
            const double var_x84 = var_x36 * var_x51;
            const double var_x86 = var_x69 * var_x7;
            const double var_x87 = var_x21 * var_x67 * var_x68 * var_x7;
            const double var_x88 = var_x26 * var_x74;
            const double var_x90 = (var_x50 * var_x76 - var_x35 * var_x57) / pow((var_x45 + 0.0207 * var_x38 + 0.020032765807428299 * var_x54 + 2.2876929743622558e-5 * var_x71 + 0.011302211302211302 * var_x63 + 1.2490816130834047e-5 * var_x75 + 0.013327915425555734 * var_x84 + var_x17 * var_x52 * var_x55), 2);
            const double var_x92 = 1 / var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x93 = pow(var_x92, 1.3);
            const double var_x94 = log(140.0 * var_x92);
            const double var_x95 = 0.033333333333333333 * var_chaste_interface__membrane__V;
            const double var_x96 = -var_x95;
            const double var_x97 = exp(-4.0 + var_x96 + 0.89088499421326284 * var_x94);
            const double var_x98 = 1.0 + var_x97;
            const double var_x99 = var_x97 / (pow(var_x98, 2) * (1.0 + 30.900566853219949 * var_x93));
            const double var_x125 = 0.0207 * var_x16;
            const double var_x127 = 4.7355244569298691e-7 * var_x26;
            const double var_x133 = 0.013771830208622637 * var_x16 * var_x72;
            const double var_x134 = 4.7355244569298691e-7 * var_x87;
            const double var_x135 = 2.5855989390826479e-7 * var_x88;
            const double var_x137 = var_x29 * var_x37;
            const double var_x138 = var_x11 * (-0.0025297242600556538 - 0.0011051656880977081 * var_x9 - 1.8271247633873431 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub - (0.0011051656880977081 + 8.3598009689690465e-5 * var_chaste_interface__intracellular_ion_concentrations__Nai) * var_chaste_interface__intracellular_ion_concentrations__Nai);
            const double var_x139 = var_x125 * var_x138;
            const double var_x140 = var_x22 * var_x9;
            const double var_x141 = var_x139 + 0.0022103313761954162 * var_x140 + 4.1799004844845232e-5 * var_x23 + var_x127 * var_x138;
            const double var_x142 = var_x141 * var_x31;
            const double var_x143 = pow((1 + var_x6), (-2));
            const double var_x144 = 0.0014304645462223146 * var_x143 * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x145 = var_x144 * var_x37;
            const double var_x146 = var_x139 * var_x42;
            const double var_x147 = var_x29 - var_x144;
            const double var_x148 = var_x147 * var_x21;
            const double var_x149 = var_x50 * (var_x137 + var_x142 + var_x146 - var_x145) - var_x139 * var_x57 - 26.376837971040871 * var_x148 * var_x17 * var_x61;
            const double var_x150 = var_x0 * var_x92;
            const double var_x151 = var_x145 - var_x137 - var_x142 - var_x146 - 4.1799004844845232e-5 * var_x70 - var_x133 * var_x138 - var_x134 * var_x138 - var_x135 * var_x138 - var_x141 * var_x60 - var_x148 * var_x50 - 0.0033154970642931239 * var_x24 * var_x67 - 0.0012068421382448356 * var_x140 * var_x74 - 2.2822279467564968e-5 * var_x23 * var_x74 + 1.5809003345251601e-6 * var_x143 * var_x53 * var_x86 - 32.140377158446256 * var_x147 * var_x17 * var_x51;
            const double var_x153 = var_x92 * var_x93 / (var_x98 * pow((0.032361865876120534 + var_x93), 2));
            const double var_x154 = var_x92 * var_x99;
            const double var_x280 = 0.0024012228482076215 * var_x77;
            const double var_x281 = 1.0288999782284837e-6 * var_x90;
            
            partialF = (-2.4598814923744084e-5 * var_x150 - 2.4287088639502301e-6 * var_x153 - 5.1430434785105685e-5 * var_x154 - 9.2414019019544699e-7 * var_x92 - var_x149 * var_x280 - var_x151 * var_x281) * mParameters[0];
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -58.600291137693
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = rY[6];
        // Units: dimensionless; Initial value: 0.629323128348
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = rY[7];
        // Units: dimensionless; Initial value: 0.3493633709533
        double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = rY[8];
        // Units: dimensionless; Initial value: 0.852396631172
        double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = rY[9];
        // Units: dimensionless; Initial value: 0.054409723782
        double var_chaste_interface__AP_sensitive_currents_q_gate__q = rY[10];
        // Units: dimensionless; Initial value: 0.531446952485
        double var_chaste_interface__AP_sensitive_currents_r_gate__r = rY[11];
        // Units: dimensionless; Initial value: 0.005550489445
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[12];
        // Units: dimensionless; Initial value: 0.067156687129
        double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
        // Units: millimolar; Initial value: 9.438646305915
        double var_chaste_interface__intracellular_ion_concentrations__Ki = rY[20];
        // Units: millimolar; Initial value: 139.984146485614
        
        
        // Mathematics
        const double var_background_muscarinic_potassium_channel_current__i_K_ACh = 0.0021962113249247841 * var_chaste_interface__intracellular_ion_concentrations__Ki - 0.011859541154593834 * exp(-0.037415977988011655 * var_chaste_interface__membrane__V); // picoA
        const double var_reversal_potentials__E_K = 26.726549826397882 * log(5.4000000000000004 / var_chaste_interface__intracellular_ion_concentrations__Ki); // millivolt
        const double var_AP_sensitive_currents__i_sus = 0.02 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_AP_sensitive_currents__i_to = 0.17999999999999999 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r; // picoA
        const double var_hyperpolarisation_activated_current__i_h_K = 0.23126250000000001 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V); // picoA
        const double var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr = 0.067616443970885107 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (0.40000000000000002 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS + 0.59999999999999998 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF) * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy; // picoA
        const double var_reversal_potentials__E_Na = 26.726549826397882 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Nai); // millivolt
        const double var_slowly_activating_delayed_rectifier_potassium_current__i_Ks = 0.025899999999999999 * pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2) * (-26.726549826397882 * log(22.199999999999999 / (var_chaste_interface__intracellular_ion_concentrations__Ki + 0.12 * var_chaste_interface__intracellular_ion_concentrations__Nai)) + var_chaste_interface__membrane__V); // picoA
        const double var_sodium_potassium_pump_current__i_NaK = 3.0052188053939588 / ((1.0 + 30.900566853219949 * pow(1 / var_chaste_interface__intracellular_ion_concentrations__Nai, 1.3)) * (1.0 + exp(-4.0 + 0.033333333333333333 * var_reversal_potentials__E_Na - 0.033333333333333333 * var_chaste_interface__membrane__V))); // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ki = 6.4032609285536579e-6 * (-var_AP_sensitive_currents__i_sus - var_AP_sensitive_currents__i_to - var_background_muscarinic_potassium_channel_current__i_K_ACh - var_hyperpolarisation_activated_current__i_h_K - var_rapidly_activating_delayed_rectifier_potassium_current__i_Kr - var_slowly_activating_delayed_rectifier_potassium_current__i_Ks + 2.0 * var_sodium_potassium_pump_current__i_NaK) * mParameters[0]; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__Ki;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS = rY[6];
            // Units: dimensionless; Initial value: 0.629323128348
            double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF = rY[7];
            // Units: dimensionless; Initial value: 0.3493633709533
            double var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy = rY[8];
            // Units: dimensionless; Initial value: 0.852396631172
            double var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n = rY[9];
            // Units: dimensionless; Initial value: 0.054409723782
            double var_chaste_interface__AP_sensitive_currents_q_gate__q = rY[10];
            // Units: dimensionless; Initial value: 0.531446952485
            double var_chaste_interface__AP_sensitive_currents_r_gate__r = rY[11];
            // Units: dimensionless; Initial value: 0.005550489445
            double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[12];
            // Units: dimensionless; Initial value: 0.067156687129
            double var_chaste_interface__intracellular_ion_concentrations__Nai = rY[19];
            // Units: millimolar; Initial value: 9.438646305915
            double var_chaste_interface__intracellular_ion_concentrations__Ki = rY[20];
            // Units: millimolar; Initial value: 139.984146485614
            
            const double var_x0 = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2);
            const double var_x1 = pow(var_chaste_interface__slowly_activating_delayed_rectifier_potassium_current_n_gate__n, 2);
            const double var_x3 = -0.040569866382531065 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF - 0.027046577588354045 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS;
            const double var_x4 = var_x3 * var_chaste_interface__rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy;
            const double var_x80 = var_chaste_interface__AP_sensitive_currents_q_gate__q * var_chaste_interface__AP_sensitive_currents_r_gate__r;
            const double var_x108 = 1 / var_chaste_interface__intracellular_ion_concentrations__Ki;
            const double var_x114 = var_chaste_interface__intracellular_ion_concentrations__Ki + 0.12 * var_chaste_interface__intracellular_ion_concentrations__Nai;
            const double var_x152 = var_x1 * (0.0054054054054054048 * var_chaste_interface__intracellular_ion_concentrations__Nai + 0.045045045045045043 * var_chaste_interface__intracellular_ion_concentrations__Ki) / pow(var_x114, 2);
            const double var_x155 = var_x0 * var_x108;
            const double var_x156 = var_x108 * var_chaste_interface__AP_sensitive_currents_r_gate__r;
            const double var_x157 = var_x108 * var_x4;
            const double var_x158 = var_x108 * var_x80;
            
            partialF = (-1.406291416773793e-8 + 0.0001711370722584161 * var_x157 - 3.4227414451683221e-6 * var_x156 - 9.8400393807144087e-5 * var_x152 - 3.0804673006514896e-5 * var_x158 - 3.9577587173161957e-5 * var_x155) * mParameters[0];
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_buffering__fTMM = rY[21];
        // Units: millimolar; Initial value: 0.350600895635
        double var_chaste_interface__calcium_buffering__fTMC = rY[25];
        // Units: millimolar; Initial value: 0.602955114871
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_calcium_buffering__fTMM = 5.6925000000000008 - 5.6925000000000008 * var_chaste_interface__calcium_buffering__fTMC - 6.4435000000000002 * var_chaste_interface__calcium_buffering__fTMM; // millimolar / millisecond

        return d_dt_chaste_interface_var_calcium_buffering__fTMM;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -6.4435000000000002;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[15];
        // Units: millimolar; Initial value: 0.000312494921
        double var_chaste_interface__calcium_buffering__fCMi = rY[22];
        // Units: millimolar; Initial value: 0.116947220413
        
        
        // Mathematics
        const double var_calcium_buffering__delta_fCMi = -0.54200000000000004 * var_chaste_interface__calcium_buffering__fCMi + 227.69999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fCMi) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fCMi = var_calcium_buffering__delta_fCMi; // millimolar / millisecond

        return d_dt_chaste_interface_var_calcium_buffering__fCMi;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[15];
            // Units: millimolar; Initial value: 0.000312494921
            
            const double var_x283 = -227.69999999999999 * var_chaste_interface__intracellular_ion_concentrations__Cai;
            
            partialF = -0.54200000000000004 + var_x283;
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
        // Units: millimolar; Initial value: 0.00019074741
        double var_chaste_interface__calcium_buffering__fCMs = rY[23];
        // Units: millimolar; Initial value: 0.074631965653
        
        
        // Mathematics
        const double var_calcium_buffering__delta_fCMs = -0.54200000000000004 * var_chaste_interface__calcium_buffering__fCMs + 227.69999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fCMs) * var_chaste_interface__intracellular_ion_concentrations__Ca_sub; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fCMs = var_calcium_buffering__delta_fCMs; // millimolar / millisecond

        return d_dt_chaste_interface_var_calcium_buffering__fCMs;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_sub = rY[18];
            // Units: millimolar; Initial value: 0.00019074741
            
            
            partialF = -0.54200000000000004 - 227.69999999999999 * var_chaste_interface__intracellular_ion_concentrations__Ca_sub;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[15];
        // Units: millimolar; Initial value: 0.000312494921
        double var_chaste_interface__calcium_buffering__fTC = rY[24];
        // Units: millimolar; Initial value: 0.059206293446
        
        
        // Mathematics
        const double var_calcium_buffering__delta_fTC = -0.44600000000000001 * var_chaste_interface__calcium_buffering__fTC + 88.799999999999997 * (1.0 - var_chaste_interface__calcium_buffering__fTC) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fTC = var_calcium_buffering__delta_fTC; // millimolar / millisecond

        return d_dt_chaste_interface_var_calcium_buffering__fTC;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[15];
            // Units: millimolar; Initial value: 0.000312494921
            
            
            partialF = -0.44600000000000001 - 88.799999999999997 * var_chaste_interface__intracellular_ion_concentrations__Cai;
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[15];
        // Units: millimolar; Initial value: 0.000312494921
        double var_chaste_interface__calcium_buffering__fTMM = rY[21];
        // Units: millimolar; Initial value: 0.350600895635
        double var_chaste_interface__calcium_buffering__fTMC = rY[25];
        // Units: millimolar; Initial value: 0.602955114871
        
        
        // Mathematics
        const double var_calcium_buffering__delta_fTMC = -0.0075100000000000002 * var_chaste_interface__calcium_buffering__fTMC + 227.69999999999999 * (1.0 - var_chaste_interface__calcium_buffering__fTMC - var_chaste_interface__calcium_buffering__fTMM) * var_chaste_interface__intracellular_ion_concentrations__Cai; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fTMC = var_calcium_buffering__delta_fTMC; // millimolar / millisecond

        return d_dt_chaste_interface_var_calcium_buffering__fTMC;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Cai = rY[15];
            // Units: millimolar; Initial value: 0.000312494921
            
            const double var_x283 = -227.69999999999999 * var_chaste_interface__intracellular_ion_concentrations__Cai;
            
            partialF = -0.0075100000000000002 + var_x283;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluateYDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_rel = rY[17];
        // Units: millimolar; Initial value: 0.296742023718
        double var_chaste_interface__calcium_buffering__fCQ = rY[26];
        // Units: millimolar; Initial value: 0.260317260703
        
        
        // Mathematics
        const double var_calcium_buffering__delta_fCQ = -0.44500000000000001 * var_chaste_interface__calcium_buffering__fCQ + 0.53400000000000003 * (1.0 - var_chaste_interface__calcium_buffering__fCQ) * var_chaste_interface__intracellular_ion_concentrations__Ca_rel; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__fCQ = var_calcium_buffering__delta_fCQ; // millimolar / millisecond

        return d_dt_chaste_interface_var_calcium_buffering__fCQ;
    }

    double Cellkurata_model_2002FromCellMLGRL2Opt::EvaluatePartialDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_rel = rY[17];
            // Units: millimolar; Initial value: 0.296742023718
            
            
            partialF = -0.44500000000000001 - 0.53400000000000003 * var_chaste_interface__intracellular_ion_concentrations__Ca_rel;
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }

    std::vector<double> Cellkurata_model_2002FromCellMLGRL2Opt::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__Cm_converted = 9.9999999999999995e-7 * mParameters[0]; // uF

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_membrane__Cm_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellkurata_model_2002FromCellMLGRL2Opt>::Initialise(void)
{
    this->mSystemName = "kurata_model_2002";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-58.600291137693);

    // rY[1]:
    this->mVariableNames.push_back("L_type_calcium_channel_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000602055134);

    // rY[2]:
    this->mVariableNames.push_back("L_type_calcium_channel_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.626999773853);

    // rY[3]:
    this->mVariableNames.push_back("L_type_calcium_channel_current_fCa_gate__fCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.589580408056);

    // rY[4]:
    this->mVariableNames.push_back("T_type_calcium_channel_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004571884917);

    // rY[5]:
    this->mVariableNames.push_back("T_type_calcium_channel_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.249637570396);

    // rY[6]:
    this->mVariableNames.push_back("rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paS");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.629323128348);

    // rY[7]:
    this->mVariableNames.push_back("rapidly_activating_delayed_rectifier_potassium_current_pa_gate__paF");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3493633709533);

    // rY[8]:
    this->mVariableNames.push_back("rapidly_activating_delayed_rectifier_potassium_current_pi_gate__piy");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.852396631172);

    // rY[9]:
    this->mVariableNames.push_back("slowly_activating_delayed_rectifier_potassium_current_n_gate__n");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.054409723782);

    // rY[10]:
    this->mVariableNames.push_back("AP_sensitive_currents_q_gate__q");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.531446952485);

    // rY[11]:
    this->mVariableNames.push_back("AP_sensitive_currents_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.005550489445);

    // rY[12]:
    this->mVariableNames.push_back("hyperpolarisation_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.067156687129);

    // rY[13]:
    this->mVariableNames.push_back("sustained_inward_current_qa_gate__qa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.426018100136);

    // rY[14]:
    this->mVariableNames.push_back("sustained_inward_current_qi_gate__qi");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.333330378068);

    // rY[15]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Cai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.000312494921);

    // rY[16]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.462338380106);

    // rY[17]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.296742023718);

    // rY[18]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_sub");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00019074741);

    // rY[19]:
    this->mVariableNames.push_back("cytosolic_sodium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.438646305915);

    // rY[20]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(139.984146485614);

    // rY[21]:
    this->mVariableNames.push_back("calcium_buffering__fTMM");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.350600895635);

    // rY[22]:
    this->mVariableNames.push_back("calcium_buffering__fCMi");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.116947220413);

    // rY[23]:
    this->mVariableNames.push_back("calcium_buffering__fCMs");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.074631965653);

    // rY[24]:
    this->mVariableNames.push_back("calcium_buffering__fTC");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.059206293446);

    // rY[25]:
    this->mVariableNames.push_back("calcium_buffering__fTMC");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.602955114871);

    // rY[26]:
    this->mVariableNames.push_back("calcium_buffering__fCQ");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.260317260703);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("picoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellkurata_model_2002FromCellMLGRL2Opt)

