//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: iribe_model_2006
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "iribe_model_2006_without_otherwise_section.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane_potential__stim_amplitude_converted = -0.0040000000000000001 * HeartConfig::Instance()->GetCapacitance() / mParameters[1]; // uA_per_cm2
        const double var_chaste_interface__membrane_potential__stim_duration_converted = 2.0; // millisecond
        const double var_chaste_interface__membrane_potential__stim_period_converted = 500.0; // millisecond
        const double var_chaste_interface__membrane_potential__stim_start_converted = 0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane_potential__stim_amplitude_converted),
                var_chaste_interface__membrane_potential__stim_duration_converted,
                var_chaste_interface__membrane_potential__stim_period_converted,
                var_chaste_interface__membrane_potential__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                23,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 0.25; // (var_L_type_Ca_channel__P_Ca_L_Ca) [nanoA_per_millimolar]
        this->mParameters[1] = 9.5000000000000005e-5; // (var_cell_parameters__Cm) [microF]
        this->mParameters[2] = 1.0; // (var_time_dependent_rectifier_potassium_current__i_Kmax) [nanoA]
        this->mParameters[3] = 2.5; // (var_fast_sodium_current__g_Na) [microS]
        this->mParameters[4] = 0; // (var_fast_sodium_current__perc_reduced_inact_for_IpNa) [dimensionless]
        this->mParameters[5] = 0; // (var_fast_sodium_current__shift_INa_inact) [millivolt]
        this->mParameters[6] = 0.00050000000000000001; // (var_sodium_calcium_exchanger__i_NaCa_max) [nanoA_per_millimolar4]
    }

    Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::~Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt()
    {
    }
    
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0013809
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.99569
        double var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x = rY[4];
        // Units: dimensionless; Initial value: 0.051127
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[5];
        // Units: dimensionless; Initial value: 0.95854
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[6];
        // Units: dimensionless; Initial value: 1.5185e-08
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
        // Units: millimolar; Initial value: 138.22
        
        const double var_L_type_Ca_channel__i_Ca_L_converted = 0.001 * (0.14973556329098189 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-2.0 * exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(3.7433890822745473)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V)) + 7.4867781645490941e-5 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-4.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_potassium_concentration__K_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)) + 0.00037433890822745472 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-140.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V))) * HeartConfig::Instance()->GetCapacitance() / mParameters[1]; // uA_per_cm2
        const double var_calcium_background_current__i_b_Ca = 0.00025000000000000001 * var_chaste_interface__membrane_potential__V - 0.0033392200824619565 * log(2.0 / var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(4.0 / var_chaste_interface__intracellular_potassium_concentration__K_i); // millivolt
        const double var_potassium_background_current__i_b_K = 0.00059999999999999995 * var_chaste_interface__membrane_potential__V - 0.00059999999999999995 * var_reversal_potentials__E_K; // nanoA
        const double var_fast_sodium_current__i_Na_converted = 0.001 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(140.47999999999999 / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) + var_chaste_interface__membrane_potential__V) * HeartConfig::Instance()->GetCapacitance() * mParameters[3] * var_chaste_interface__fast_sodium_current_h_gate__h / mParameters[1]; // uA_per_cm2
        const double var_sodium_background_current__i_b_Na = 0.00059999999999999995 * var_chaste_interface__membrane_potential__V - 0.016028256395817387 * log(140.0 / var_chaste_interface__intracellular_sodium_concentration__Na_i); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa_converted = 0.001 * (2.0 * pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3) * exp(0.018716945411372737 * var_chaste_interface__membrane_potential__V) - 2744000.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(-0.018716945411372737 * var_chaste_interface__membrane_potential__V)) * HeartConfig::Instance()->GetCapacitance() * mParameters[6] / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i) * mParameters[1]); // uA_per_cm2
        const double var_sodium_potassium_pump__i_NaK = 1.0880000000000001 * var_chaste_interface__intracellular_sodium_concentration__Na_i / ((21.699999999999999 + var_chaste_interface__intracellular_sodium_concentration__Na_i) * (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__membrane_potential__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__membrane_potential__V))); // nanoA
        const double var_time_dependent_rectifier_potassium_current__i_K_converted = 7.1428571428571427e-6 * (-4.0 * exp(-0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_potassium_concentration__K_i) * HeartConfig::Instance()->GetCapacitance() * mParameters[2] * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x / mParameters[1]; // uA_per_cm2
        const double var_time_independent_potassium_current__i_K1 = 0.2857142857142857 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) / (1.0 + exp(-0.74867781645490938 + 0.074867781645490947 * var_chaste_interface__membrane_potential__V - 0.074867781645490947 * var_reversal_potentials__E_K)); // nanoA
        const double var_transient_outward_current__i_to = 0.0050000000000000001 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // nanoA
        const double var_chaste_interface__i_ionic = ((var_L_type_Ca_channel__i_Ca_L_converted + var_fast_sodium_current__i_Na_converted + var_sodium_calcium_exchanger__i_NaCa_converted + var_time_dependent_rectifier_potassium_current__i_K_converted) * mParameters[1] + 0.001 * HeartConfig::Instance()->GetCapacitance() * var_calcium_background_current__i_b_Ca + 0.001 * HeartConfig::Instance()->GetCapacitance() * var_potassium_background_current__i_b_K + 0.001 * HeartConfig::Instance()->GetCapacitance() * var_sodium_background_current__i_b_Na + 0.001 * HeartConfig::Instance()->GetCapacitance() * var_sodium_potassium_pump__i_NaK + 0.001 * HeartConfig::Instance()->GetCapacitance() * var_time_independent_potassium_current__i_K1 + 0.001 * HeartConfig::Instance()->GetCapacitance() * var_transient_outward_current__i_to) / mParameters[1]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0013809
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.99569
        double var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x = rY[4];
        // Units: dimensionless; Initial value: 0.051127
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[5];
        // Units: dimensionless; Initial value: 0.95854
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[6];
        // Units: dimensionless; Initial value: 1.5185e-08
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
        // Units: millimolar; Initial value: 138.22
        

        // Mathematics
        double d_dt_chaste_interface_var_membrane_potential__V;
        const double var_L_type_Ca_channel__i_Ca_L_Ca = 0.14973556329098189 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-2.0 * exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(3.7433890822745473)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K = 7.4867781645490941e-5 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-4.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_potassium_concentration__K_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na = 0.00037433890822745472 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-140.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_Ca_L_Ca + var_L_type_Ca_channel__i_Ca_L_K + var_L_type_Ca_channel__i_Ca_L_Na; // nanoA
        const double var_calcium_background_current__i_b_Ca = 0.00025000000000000001 * var_chaste_interface__membrane_potential__V - 0.0033392200824619565 * log(2.0 / var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(4.0 / var_chaste_interface__intracellular_potassium_concentration__K_i); // millivolt
        const double var_potassium_background_current__i_b_K = 0.00059999999999999995 * var_chaste_interface__membrane_potential__V - 0.00059999999999999995 * var_reversal_potentials__E_K; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(140.47999999999999 / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) + var_chaste_interface__membrane_potential__V) * mParameters[3] * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_sodium_background_current__i_b_Na = 0.00059999999999999995 * var_chaste_interface__membrane_potential__V - 0.016028256395817387 * log(140.0 / var_chaste_interface__intracellular_sodium_concentration__Na_i); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa = (2.0 * pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3) * exp(0.018716945411372737 * var_chaste_interface__membrane_potential__V) - 2744000.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(-0.018716945411372737 * var_chaste_interface__membrane_potential__V)) * mParameters[6] / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.0880000000000001 * var_chaste_interface__intracellular_sodium_concentration__Na_i / ((21.699999999999999 + var_chaste_interface__intracellular_sodium_concentration__Na_i) * (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__membrane_potential__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__membrane_potential__V))); // nanoA
        const double var_time_dependent_rectifier_potassium_current__i_K = 0.0071428571428571426 * (-4.0 * exp(-0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_potassium_concentration__K_i) * mParameters[2] * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__i_K1 = 0.2857142857142857 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) / (1.0 + exp(-0.74867781645490938 + 0.074867781645490947 * var_chaste_interface__membrane_potential__V - 0.074867781645490947 * var_reversal_potentials__E_K)); // nanoA
        const double var_transient_outward_current__i_to = 0.0050000000000000001 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // nanoA
        d_dt_chaste_interface_var_membrane_potential__V = -0.001 * (1000.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted) * mParameters[1] / HeartConfig::Instance()->GetCapacitance() + var_L_type_Ca_channel__i_Ca_L + var_calcium_background_current__i_b_Ca + var_fast_sodium_current__i_Na + var_potassium_background_current__i_b_K + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa + var_sodium_potassium_pump__i_NaK + var_time_dependent_rectifier_potassium_current__i_K + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / mParameters[1]; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane_potential__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane_potential__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0013809
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.99569
        double var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x = rY[4];
        // Units: dimensionless; Initial value: 0.051127
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[5];
        // Units: dimensionless; Initial value: 0.95854
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[6];
        // Units: dimensionless; Initial value: 1.5185e-08
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__CaMKII_factor__F_CaMK = rY[9];
        // Units: dimensionless; Initial value: 1.028
        double var_chaste_interface__RyR__F_SRCa_RyR = rY[10];
        // Units: millimolar; Initial value: 0.25089
        double var_chaste_interface__RyR__F_1 = rY[11];
        // Units: dimensionless; Initial value: 0.5268
        double var_chaste_interface__RyR__F_2 = rY[12];
        // Units: dimensionless; Initial value: 8.7508e-06
        double var_chaste_interface__calmodulin__Cmdn_Ca = rY[13];
        // Units: millimolar; Initial value: 3.9636e-06
        double var_chaste_interface__troponin__Trpn_Ca = rY[14];
        // Units: millimolar; Initial value: 0.00027661
        double var_chaste_interface__SR_calcium_concentration__Ca_SR = rY[15];
        // Units: millimolar; Initial value: 0.24886
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
        // Units: millimolar; Initial value: 138.22
        double var_chaste_interface__Force__N_0 = rY[18];
        // Units: dimensionless; Initial value: 0.99917
        double var_chaste_interface__Force__P_0 = rY[19];
        // Units: dimensionless; Initial value: 9.8593e-05
        double var_chaste_interface__Force__P_1 = rY[20];
        // Units: dimensionless; Initial value: 0.00013331
        double var_chaste_interface__Force__P_2 = rY[21];
        // Units: dimensionless; Initial value: 0.00023505
        double var_chaste_interface__Force__P_3 = rY[22];
        // Units: dimensionless; Initial value: 0.00015349
        
        
        // Mathematics
        double d_dt_chaste_interface_var_membrane_potential__V;
        const double var_Force__N_1 = 1.0 - var_chaste_interface__Force__N_0 - var_chaste_interface__Force__P_0 - var_chaste_interface__Force__P_1 - var_chaste_interface__Force__P_2 - var_chaste_interface__Force__P_3; // dimensionless
        const double d_dt_chaste_interface_var_Force__P_2 = 0.12214285714285715 * var_chaste_interface__Force__P_3 + 0.10000000000000001 * var_chaste_interface__Force__P_1 - 0.15142857142857144 * var_chaste_interface__Force__P_2; // 1 / millisecond
        const double d_dt_chaste_interface_var_Force__P_3 = 0.070000000000000007 * var_chaste_interface__Force__P_2 - 0.12214285714285715 * var_chaste_interface__Force__P_3; // 1 / millisecond
        const double var_Force__Force_norm = 0.60360360360360366 * var_Force__N_1 + 0.60360360360360366 * var_chaste_interface__Force__P_1 + 1.2072072072072073 * var_chaste_interface__Force__P_2 + 1.8108108108108107 * var_chaste_interface__Force__P_3; // dimensionless
        const double d_dt_chaste_interface_var_RyR__F_SRCa_RyR = 0.02 * var_chaste_interface__SR_calcium_concentration__Ca_SR - 0.02 * var_chaste_interface__RyR__F_SRCa_RyR; // millimolar / millisecond
        const double d_dt_chaste_interface_var_CaMKII_factor__F_CaMK = 24.999999999999996 * var_chaste_interface__calmodulin__Cmdn_Ca - 0.00125 * var_chaste_interface__CaMKII_factor__F_CaMK; // 1 / millisecond
        const double var_RyR__j_rel = 500.0 * pow(var_chaste_interface__RyR__F_2, 2) * (-var_chaste_interface__intracellular_calcium_concentration__Ca_i + var_chaste_interface__SR_calcium_concentration__Ca_SR) * var_chaste_interface__RyR__F_SRCa_RyR / (pow((0.25 + var_chaste_interface__RyR__F_2), 2) * (0.20000000000000001 + var_chaste_interface__RyR__F_SRCa_RyR)); // millimolar_per_second
        const double var_SERCA__j_up = (-0.14537477691850093 * pow(var_chaste_interface__SR_calcium_concentration__Ca_SR, 2) + 5069444.444444444 * pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2) * var_chaste_interface__CaMKII_factor__F_CaMK) / (1.0 + 17361111.111111112 * pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2) + 0.37180249851279007 * pow(var_chaste_interface__SR_calcium_concentration__Ca_SR, 2)); // millimolar_per_second
        const double d_dt_chaste_interface_var_SR_calcium_concentration__Ca_SR = 0.0049000806523882071 * var_SERCA__j_up - 0.001 * var_RyR__j_rel; // millimolar / millisecond
        const double d_dt_chaste_interface_var_calmodulin__Cmdn_Ca = -0.5 * var_chaste_interface__calmodulin__Cmdn_Ca + 10.0 * (0.02 - var_chaste_interface__calmodulin__Cmdn_Ca) * var_chaste_interface__intracellular_calcium_concentration__Ca_i; // millimolar / millisecond
        const double var_L_type_Ca_channel__i_Ca_L_Ca = 0.14973556329098189 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-2.0 * exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(3.7433890822745473)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K = 7.4867781645490941e-5 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-4.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_potassium_concentration__K_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na = 0.00037433890822745472 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-140.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_Ca_L_Ca + var_L_type_Ca_channel__i_Ca_L_K + var_L_type_Ca_channel__i_Ca_L_Na; // nanoA
        const double var_L_type_Ca_channel_d_gate__E0_d = 19.0 + var_chaste_interface__membrane_potential__V; // millivolt
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d = 0.001 * (1.0 - var_chaste_interface__L_type_Ca_channel_d_gate__d) * ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 1.0000000000000001e-5) ? (360.0) : (90.0 * var_L_type_Ca_channel_d_gate__E0_d / (1.0 - exp(-0.25 * var_L_type_Ca_channel_d_gate__E0_d)))) - 0.001 * ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 1.0000000000000001e-5) ? (360.0) : (-36.0 * var_L_type_Ca_channel_d_gate__E0_d / (1.0 - exp(0.10000000000000001 * var_L_type_Ca_channel_d_gate__E0_d)))) * var_chaste_interface__L_type_Ca_channel_d_gate__d; // 1 / millisecond
        const double var_L_type_Ca_channel_f_gate__E0_f = 34.0 + var_chaste_interface__membrane_potential__V; // millivolt
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f = 0.001 * (1.0 - var_chaste_interface__L_type_Ca_channel_f_gate__f) * ((fabs(var_L_type_Ca_channel_f_gate__E0_f) < 1.0000000000000001e-5) ? (12.5) : (3.125 * var_L_type_Ca_channel_f_gate__E0_f / (-1.0 + exp(0.25 * var_L_type_Ca_channel_f_gate__E0_f)))) - 0.025000000000000001 * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 + exp(-0.25 * var_L_type_Ca_channel_f_gate__E0_f)); // 1 / millisecond
        const double var_RyR__k_1 = 30625000.0 * pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2) - 245.0 * var_L_type_Ca_channel__i_Ca_L; // per_second
        const double d_dt_chaste_interface_var_RyR__F_1 = -0.0018 * var_chaste_interface__RyR__F_1 + 0.001885 * pow((4.5454545454545459 * var_chaste_interface__RyR__F_SRCa_RyR), (2.0408163265306123 * pow(var_chaste_interface__CaMKII_factor__F_CaMK, 2))) * (1.0 - var_chaste_interface__RyR__F_1 - var_chaste_interface__RyR__F_2) - 0.001 * var_chaste_interface__RyR__F_1 * var_RyR__k_1; // 1 / millisecond
        const double d_dt_chaste_interface_var_RyR__F_2 = 0.001 * var_chaste_interface__RyR__F_1 * var_RyR__k_1 - 0.45000000000000001 * var_chaste_interface__RyR__F_2 / (1.0 + 0.35999999999999999 / var_chaste_interface__SR_calcium_concentration__Ca_SR); // 1 / millisecond
        const double var_fast_sodium_current_h_gate__alpha_h = 20.0 * exp(-9.375 + 0.125 * mParameters[5] - 0.125 * var_chaste_interface__membrane_potential__V); // per_second
        const double var_fast_sodium_current_h_gate__beta_h = 2000.0 / (1.0 + 320.0 * exp(-7.5 + 0.10000000000000001 * mParameters[5] - 0.10000000000000001 * var_chaste_interface__membrane_potential__V)); // per_second
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = 0.001 * (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h) * (-var_chaste_interface__fast_sodium_current_h_gate__h + 0.01 * mParameters[4] + (1.0 - 0.01 * mParameters[4]) * var_fast_sodium_current_h_gate__alpha_h / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h)); // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * ((fabs(41.0 + var_chaste_interface__membrane_potential__V) < 1.0000000000000001e-5) ? (2000.0) : (200.0 * (41.0 + var_chaste_interface__membrane_potential__V) / (1.0 - exp(-4.1000000000000005 - 0.10000000000000001 * var_chaste_interface__membrane_potential__V)))) - 8.0 * var_chaste_interface__fast_sodium_current_m_gate__m * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane_potential__V); // 1 / millisecond
        const double var_calcium_background_current__i_b_Ca = 0.00025000000000000001 * var_chaste_interface__membrane_potential__V - 0.0033392200824619565 * log(2.0 / var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(4.0 / var_chaste_interface__intracellular_potassium_concentration__K_i); // millivolt
        const double var_potassium_background_current__i_b_K = 0.00059999999999999995 * var_chaste_interface__membrane_potential__V - 0.00059999999999999995 * var_reversal_potentials__E_K; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(140.47999999999999 / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) + var_chaste_interface__membrane_potential__V) * mParameters[3] * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_sodium_background_current__i_b_Na = 0.00059999999999999995 * var_chaste_interface__membrane_potential__V - 0.016028256395817387 * log(140.0 / var_chaste_interface__intracellular_sodium_concentration__Na_i); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa = (2.0 * pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3) * exp(0.018716945411372737 * var_chaste_interface__membrane_potential__V) - 2744000.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(-0.018716945411372737 * var_chaste_interface__membrane_potential__V)) * mParameters[6] / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.0880000000000001 * var_chaste_interface__intracellular_sodium_concentration__Na_i / ((21.699999999999999 + var_chaste_interface__intracellular_sodium_concentration__Na_i) * (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__membrane_potential__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__membrane_potential__V))); // nanoA
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Na_i = -0.00063181349969740222 * var_L_type_Ca_channel__i_Ca_L_Na - 0.00063181349969740222 * var_fast_sodium_current__i_Na - 0.00063181349969740222 * var_sodium_background_current__i_b_Na - 0.0018954404990922066 * var_sodium_calcium_exchanger__i_NaCa - 0.0018954404990922066 * var_sodium_potassium_pump__i_NaK; // millimolar / millisecond
        const double var_time_dependent_rectifier_potassium_current__i_K = 0.0071428571428571426 * (-4.0 * exp(-0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_potassium_concentration__K_i) * mParameters[2] * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x; // nanoA
        const double d_dt_chaste_interface_var_time_dependent_rectifier_potassium_current_x_gate__x = 0.00050000000000000001 * (1.0 - var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x) * exp(4.1300000000000008 + 0.082600000000000007 * var_chaste_interface__membrane_potential__V) / (1.0 + exp(2.8500000000000001 + 0.057000000000000002 * var_chaste_interface__membrane_potential__V)) - 0.0012999999999999999 * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x * exp(-1.2 - 0.059999999999999998 * var_chaste_interface__membrane_potential__V) / (1.0 + exp(-0.80000000000000004 - 0.040000000000000001 * var_chaste_interface__membrane_potential__V)); // 1 / millisecond
        const double var_time_independent_potassium_current__i_K1 = 0.2857142857142857 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) / (1.0 + exp(-0.74867781645490938 + 0.074867781645490947 * var_chaste_interface__membrane_potential__V - 0.074867781645490947 * var_reversal_potentials__E_K)); // nanoA
        const double d_dt_chaste_interface_var_transient_outward_current_r_gate__r = 0.33300000000000002 / (1.0 + exp(-0.80000000000000004 - 0.20000000000000001 * var_chaste_interface__membrane_potential__V)) - 0.33300000000000002 * var_chaste_interface__transient_outward_current_r_gate__r; // 1 / millisecond
        const double var_transient_outward_current__i_to = 0.0050000000000000001 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // nanoA
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__K_i = 0.0012636269993948044 * var_sodium_potassium_pump__i_NaK - 0.00063181349969740222 * var_L_type_Ca_channel__i_Ca_L_K - 0.00063181349969740222 * var_potassium_background_current__i_b_K - 0.00063181349969740222 * var_time_dependent_rectifier_potassium_current__i_K - 0.00063181349969740222 * var_time_independent_potassium_current__i_K1 - 0.00063181349969740222 * var_transient_outward_current__i_to; // millimolar / millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_s_gate__s = 3.3000000000000003e-5 * (1.0 - var_chaste_interface__transient_outward_current_s_gate__s) * exp(-0.058823529411764705 * var_chaste_interface__membrane_potential__V) - 0.033000000000000002 * var_chaste_interface__transient_outward_current_s_gate__s / (1.0 + exp(-1.25 - 0.125 * var_chaste_interface__membrane_potential__V)); // 1 / millisecond
        const double var_Force__alpha_tm = 12600800629.436172 * pow(var_chaste_interface__troponin__Trpn_Ca, 5.1071428571428568); // per_second
        const double d_dt_chaste_interface_var_Force__N_0 = 0.040714285714285717 * var_Force__N_1 + 0.040000000000000001 * var_chaste_interface__Force__P_0 - 0.001 * var_chaste_interface__Force__N_0 * var_Force__alpha_tm; // 1 / millisecond
        const double d_dt_chaste_interface_var_Force__P_0 = 0.040714285714285717 * var_chaste_interface__Force__P_1 - 0.070000000000000007 * var_chaste_interface__Force__P_0 + 0.001 * var_chaste_interface__Force__N_0 * var_Force__alpha_tm; // 1 / millisecond
        const double d_dt_chaste_interface_var_Force__P_1 = 0.081428571428571433 * var_chaste_interface__Force__P_2 + 0.029999999999999999 * var_chaste_interface__Force__P_0 - 0.18071428571428572 * var_chaste_interface__Force__P_1 + 0.001 * var_Force__N_1 * var_Force__alpha_tm; // 1 / millisecond
        const double d_dt_chaste_interface_var_troponin__Trpn_Ca = 80.0 * (0.070000000000000007 - var_chaste_interface__troponin__Trpn_Ca) * var_chaste_interface__intracellular_calcium_concentration__Ca_i - 0.066666666666666666 * (3.0 - 2.0 * var_Force__Force_norm) * var_chaste_interface__troponin__Trpn_Ca; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_i = 0.5 * var_chaste_interface__calmodulin__Cmdn_Ca + 0.00063181349969740222 * var_sodium_calcium_exchanger__i_NaCa + 0.00020407827359180688 * var_RyR__j_rel - 0.00031590674984870111 * var_L_type_Ca_channel__i_Ca_L_Ca - 0.00031590674984870111 * var_calcium_background_current__i_b_Ca - 0.001 * var_SERCA__j_up + 0.066666666666666666 * (3.0 - 2.0 * var_Force__Force_norm) * var_chaste_interface__troponin__Trpn_Ca - 10.0 * (0.02 - var_chaste_interface__calmodulin__Cmdn_Ca) * var_chaste_interface__intracellular_calcium_concentration__Ca_i - 80.0 * (0.070000000000000007 - var_chaste_interface__troponin__Trpn_Ca) * var_chaste_interface__intracellular_calcium_concentration__Ca_i; // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane_potential__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane_potential__V = -0.001 * (1000.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted) * mParameters[1] / HeartConfig::Instance()->GetCapacitance() + var_L_type_Ca_channel__i_Ca_L + var_calcium_background_current__i_b_Ca + var_fast_sodium_current__i_Na + var_potassium_background_current__i_b_K + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa + var_sodium_potassium_pump__i_NaK + var_time_dependent_rectifier_potassium_current__i_K + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / mParameters[1]; // millivolt / millisecond
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_membrane_potential__V;
        mEvalF[1] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_i;
        mEvalF[2] = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        mEvalF[3] = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        mEvalF[4] = d_dt_chaste_interface_var_time_dependent_rectifier_potassium_current_x_gate__x;
        mEvalF[5] = d_dt_chaste_interface_var_transient_outward_current_s_gate__s;
        mEvalF[6] = d_dt_chaste_interface_var_transient_outward_current_r_gate__r;
        mEvalF[7] = d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d;
        mEvalF[8] = d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f;
        mEvalF[9] = d_dt_chaste_interface_var_CaMKII_factor__F_CaMK;
        mEvalF[10] = d_dt_chaste_interface_var_RyR__F_SRCa_RyR;
        mEvalF[11] = d_dt_chaste_interface_var_RyR__F_1;
        mEvalF[12] = d_dt_chaste_interface_var_RyR__F_2;
        mEvalF[13] = d_dt_chaste_interface_var_calmodulin__Cmdn_Ca;
        mEvalF[14] = d_dt_chaste_interface_var_troponin__Trpn_Ca;
        mEvalF[15] = d_dt_chaste_interface_var_SR_calcium_concentration__Ca_SR;
        mEvalF[16] = d_dt_chaste_interface_var_intracellular_sodium_concentration__Na_i;
        mEvalF[17] = d_dt_chaste_interface_var_intracellular_potassium_concentration__K_i;
        mEvalF[18] = d_dt_chaste_interface_var_Force__N_0;
        mEvalF[19] = d_dt_chaste_interface_var_Force__P_0;
        mEvalF[20] = d_dt_chaste_interface_var_Force__P_1;
        mEvalF[21] = d_dt_chaste_interface_var_Force__P_2;
        mEvalF[22] = d_dt_chaste_interface_var_Force__P_3;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time_converted, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        rY[13] = y_save;
        
        
        y_save = rY[14];
        rY[14] = mYInit[14];
        mEvalF[14] = EvaluateYDerivative14(var_chaste_interface__environment__time_converted, rY);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time_converted, rY, delta);
        rY[14] = y_save;
        
        
        y_save = rY[15];
        rY[15] = mYInit[15];
        mEvalF[15] = EvaluateYDerivative15(var_chaste_interface__environment__time_converted, rY);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time_converted, rY, delta);
        rY[15] = y_save;
        
        
        y_save = rY[16];
        rY[16] = mYInit[16];
        mEvalF[16] = EvaluateYDerivative16(var_chaste_interface__environment__time_converted, rY);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time_converted, rY, delta);
        rY[16] = y_save;
        
        
        y_save = rY[17];
        rY[17] = mYInit[17];
        mEvalF[17] = EvaluateYDerivative17(var_chaste_interface__environment__time_converted, rY);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time_converted, rY, delta);
        rY[17] = y_save;
        
        
        y_save = rY[18];
        rY[18] = mYInit[18];
        mEvalF[18] = EvaluateYDerivative18(var_chaste_interface__environment__time_converted, rY);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time_converted, rY, delta);
        rY[18] = y_save;
        
        
        y_save = rY[19];
        rY[19] = mYInit[19];
        mEvalF[19] = EvaluateYDerivative19(var_chaste_interface__environment__time_converted, rY);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time_converted, rY, delta);
        rY[19] = y_save;
        
        
        y_save = rY[20];
        rY[20] = mYInit[20];
        mEvalF[20] = EvaluateYDerivative20(var_chaste_interface__environment__time_converted, rY);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time_converted, rY, delta);
        rY[20] = y_save;
        
        
        y_save = rY[21];
        rY[21] = mYInit[21];
        mEvalF[21] = EvaluateYDerivative21(var_chaste_interface__environment__time_converted, rY);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time_converted, rY, delta);
        rY[21] = y_save;
        
        
        y_save = rY[22];
        rY[22] = mYInit[22];
        mEvalF[22] = EvaluateYDerivative22(var_chaste_interface__environment__time_converted, rY);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time_converted, rY, delta);
        rY[22] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane_potential__V;
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0013809
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.99569
        double var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x = rY[4];
        // Units: dimensionless; Initial value: 0.051127
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[5];
        // Units: dimensionless; Initial value: 0.95854
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[6];
        // Units: dimensionless; Initial value: 1.5185e-08
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
        // Units: millimolar; Initial value: 138.22
        
        
        // Mathematics
        const double var_L_type_Ca_channel__i_Ca_L_Ca = 0.14973556329098189 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-2.0 * exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(3.7433890822745473)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K = 7.4867781645490941e-5 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-4.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_potassium_concentration__K_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na = 0.00037433890822745472 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-140.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_Ca_L_Ca + var_L_type_Ca_channel__i_Ca_L_K + var_L_type_Ca_channel__i_Ca_L_Na; // nanoA
        const double var_calcium_background_current__i_b_Ca = 0.00025000000000000001 * var_chaste_interface__membrane_potential__V - 0.0033392200824619565 * log(2.0 / var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(4.0 / var_chaste_interface__intracellular_potassium_concentration__K_i); // millivolt
        const double var_potassium_background_current__i_b_K = 0.00059999999999999995 * var_chaste_interface__membrane_potential__V - 0.00059999999999999995 * var_reversal_potentials__E_K; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(140.47999999999999 / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) + var_chaste_interface__membrane_potential__V) * mParameters[3] * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_sodium_background_current__i_b_Na = 0.00059999999999999995 * var_chaste_interface__membrane_potential__V - 0.016028256395817387 * log(140.0 / var_chaste_interface__intracellular_sodium_concentration__Na_i); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa = (2.0 * pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3) * exp(0.018716945411372737 * var_chaste_interface__membrane_potential__V) - 2744000.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(-0.018716945411372737 * var_chaste_interface__membrane_potential__V)) * mParameters[6] / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.0880000000000001 * var_chaste_interface__intracellular_sodium_concentration__Na_i / ((21.699999999999999 + var_chaste_interface__intracellular_sodium_concentration__Na_i) * (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__membrane_potential__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__membrane_potential__V))); // nanoA
        const double var_time_dependent_rectifier_potassium_current__i_K = 0.0071428571428571426 * (-4.0 * exp(-0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_potassium_concentration__K_i) * mParameters[2] * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__i_K1 = 0.2857142857142857 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) / (1.0 + exp(-0.74867781645490938 + 0.074867781645490947 * var_chaste_interface__membrane_potential__V - 0.074867781645490947 * var_reversal_potentials__E_K)); // nanoA
        const double var_transient_outward_current__i_to = 0.0050000000000000001 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // nanoA
        d_dt_chaste_interface_var_membrane_potential__V = -0.001 * (1000.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted) * mParameters[1] / HeartConfig::Instance()->GetCapacitance() + var_L_type_Ca_channel__i_Ca_L + var_calcium_background_current__i_b_Ca + var_fast_sodium_current__i_Na + var_potassium_background_current__i_b_K + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa + var_sodium_potassium_pump__i_NaK + var_time_dependent_rectifier_potassium_current__i_K + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / mParameters[1]; // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane_potential__V;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 9.91e-06
            double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
            // Units: dimensionless; Initial value: 0.0013809
            double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
            // Units: dimensionless; Initial value: 0.99569
            double var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x = rY[4];
            // Units: dimensionless; Initial value: 0.051127
            double var_chaste_interface__transient_outward_current_s_gate__s = rY[5];
            // Units: dimensionless; Initial value: 0.95854
            double var_chaste_interface__transient_outward_current_r_gate__r = rY[6];
            // Units: dimensionless; Initial value: 1.5185e-08
            double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
            // Units: dimensionless; Initial value: 1.7908e-08
            double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
            // Units: millimolar; Initial value: 5.8041
            double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
            // Units: millimolar; Initial value: 138.22
            
            const double var_x0 = 0.074867781645490947 * var_chaste_interface__membrane_potential__V;
            const double var_x1 = 1 / var_chaste_interface__intracellular_potassium_concentration__K_i;
            const double var_x2 = log(4.0 * var_x1);
            const double var_x3 = exp(-0.74867781645490938 + var_x0 - 2.0 * var_x2);
            const double var_x4 = 1.0 + var_x3;
            const double var_x5 = 1 / var_x4;
            const double var_x6 = var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s;
            const double var_x7 = 0.018716945411372737 * var_chaste_interface__membrane_potential__V;
            const double var_x8 = exp(var_x7);
            const double var_x9 = var_x8 * pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3);
            const double var_x10 = exp(-var_x7);
            const double var_x11 = var_x10 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x12 = mParameters[6] / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i);
            const double var_x13 = var_x12 * (0.037433890822745473 * var_x9 + 51359.298208806787 * var_x11);
            const double var_x14 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * mParameters[3];
            const double var_x15 = var_x14 * var_chaste_interface__fast_sodium_current_h_gate__h;
            const double var_x16 = -0.037433890822745473 * var_chaste_interface__membrane_potential__V;
            const double var_x17 = exp(var_x16);
            const double var_x18 = mParameters[2] * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x;
            const double var_x19 = var_x17 * var_x18;
            const double var_x20 = var_x3 * (-26.713760659695652 * var_x2 + var_chaste_interface__membrane_potential__V) / pow(var_x4, 2);
            const double var_x21 = 1 / (21.699999999999999 + var_chaste_interface__intracellular_sodium_concentration__Na_i);
            const double var_x22 = exp(-0.0037433890822745472 * var_chaste_interface__membrane_potential__V);
            const double var_x23 = 1.0 + 0.035299999999999998 * var_x17 + 0.1245 * var_x22;
            const double var_x24 = var_x21 * (0.001321416346042915 * var_x17 + 0.00046605194074318115 * var_x22) * var_chaste_interface__intracellular_sodium_concentration__Na_i / pow(var_x23, 2);
            const double var_x25 = mParameters[0] * var_chaste_interface__L_type_Ca_channel_f_gate__f;
            const double var_x26 = var_x25 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
            const double var_x27 = exp(3.7433890822745473 - var_x0);
            const double var_x28 = 1.0 - var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x30 = exp(3.7433890822745473);
            const double var_x31 = -2.0 * var_x27 + var_x30 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x32 = var_x29 * var_x31;
            const double var_x33 = 0.14973556329098189 * var_x32;
            const double var_x34 = exp(1.8716945411372736 + var_x16);
            const double var_x35 = 1.0 - var_x34;
            const double var_x36 = 1 / var_x35;
            const double var_x37 = var_x26 * var_x36;
            const double var_x38 = exp(1.8716945411372736);
            const double var_x39 = -4.0 * var_x34 + var_x38 * var_chaste_interface__intracellular_potassium_concentration__K_i;
            const double var_x40 = 7.4867781645490941e-5 * var_x39;
            const double var_x41 = -140.0 * var_x34 + var_x38 * var_chaste_interface__intracellular_sodium_concentration__Na_i;
            const double var_x42 = 0.00037433890822745472 * var_x41;
            const double var_x43 = -50.0 + var_chaste_interface__membrane_potential__V;
            const double var_x44 = var_x26 * var_x43;
            const double var_x45 = var_x29 * var_x44;
            const double var_x46 = var_x27 * var_x45;
            const double var_x47 = var_x37 * var_x43;
            const double var_x48 = var_x34 * var_x47;
            const double var_x49 = var_x27 * var_x31 * var_x44 / pow(var_x28, 2);
            const double var_x50 = var_x34 * var_x44 / pow(var_x35, 2);
            const double var_x51 = var_x39 * var_x50;
            const double var_x52 = var_x41 * var_x50;
            const double var_x53 = 1 / mParameters[1];
            const double var_x54 = 0.001 * var_x53;
            
            partialF = -var_x54 * (0.0014499999999999999 + var_x13 + var_x15 + 1.0880000000000001 * var_x24 + 0.0050000000000000001 * var_x6 + 0.022420738914067644 * var_x46 + 0.0010695397377927277 * var_x19 + 0.0019730250244379527 * var_x48 + 0.2857142857142857 * var_x5 - 0.011210369457033822 * var_x49 - 2.8025923642584555e-6 * var_x51 - 0.021390794755854554 * var_x20 - 1.4012961821292276e-5 * var_x52 + var_x26 * var_x33 + var_x37 * var_x40 + var_x37 * var_x42);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__CaMKII_factor__F_CaMK = rY[9];
        // Units: dimensionless; Initial value: 1.028
        double var_chaste_interface__RyR__F_SRCa_RyR = rY[10];
        // Units: millimolar; Initial value: 0.25089
        double var_chaste_interface__RyR__F_2 = rY[12];
        // Units: dimensionless; Initial value: 8.7508e-06
        double var_chaste_interface__calmodulin__Cmdn_Ca = rY[13];
        // Units: millimolar; Initial value: 3.9636e-06
        double var_chaste_interface__troponin__Trpn_Ca = rY[14];
        // Units: millimolar; Initial value: 0.00027661
        double var_chaste_interface__SR_calcium_concentration__Ca_SR = rY[15];
        // Units: millimolar; Initial value: 0.24886
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__Force__N_0 = rY[18];
        // Units: dimensionless; Initial value: 0.99917
        double var_chaste_interface__Force__P_0 = rY[19];
        // Units: dimensionless; Initial value: 9.8593e-05
        double var_chaste_interface__Force__P_1 = rY[20];
        // Units: dimensionless; Initial value: 0.00013331
        double var_chaste_interface__Force__P_2 = rY[21];
        // Units: dimensionless; Initial value: 0.00023505
        double var_chaste_interface__Force__P_3 = rY[22];
        // Units: dimensionless; Initial value: 0.00015349
        
        
        // Mathematics
        const double var_Force__N_1 = 1.0 - var_chaste_interface__Force__N_0 - var_chaste_interface__Force__P_0 - var_chaste_interface__Force__P_1 - var_chaste_interface__Force__P_2 - var_chaste_interface__Force__P_3; // dimensionless
        const double var_Force__Force_norm = 0.60360360360360366 * var_Force__N_1 + 0.60360360360360366 * var_chaste_interface__Force__P_1 + 1.2072072072072073 * var_chaste_interface__Force__P_2 + 1.8108108108108107 * var_chaste_interface__Force__P_3; // dimensionless
        const double var_RyR__j_rel = 500.0 * pow(var_chaste_interface__RyR__F_2, 2) * (-var_chaste_interface__intracellular_calcium_concentration__Ca_i + var_chaste_interface__SR_calcium_concentration__Ca_SR) * var_chaste_interface__RyR__F_SRCa_RyR / (pow((0.25 + var_chaste_interface__RyR__F_2), 2) * (0.20000000000000001 + var_chaste_interface__RyR__F_SRCa_RyR)); // millimolar_per_second
        const double var_SERCA__j_up = (-0.14537477691850093 * pow(var_chaste_interface__SR_calcium_concentration__Ca_SR, 2) + 5069444.444444444 * pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2) * var_chaste_interface__CaMKII_factor__F_CaMK) / (1.0 + 17361111.111111112 * pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2) + 0.37180249851279007 * pow(var_chaste_interface__SR_calcium_concentration__Ca_SR, 2)); // millimolar_per_second
        const double var_L_type_Ca_channel__i_Ca_L_Ca = 0.14973556329098189 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-2.0 * exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(3.7433890822745473)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_calcium_background_current__i_b_Ca = 0.00025000000000000001 * var_chaste_interface__membrane_potential__V - 0.0033392200824619565 * log(2.0 / var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa = (2.0 * pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3) * exp(0.018716945411372737 * var_chaste_interface__membrane_potential__V) - 2744000.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(-0.018716945411372737 * var_chaste_interface__membrane_potential__V)) * mParameters[6] / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_i = 0.5 * var_chaste_interface__calmodulin__Cmdn_Ca + 0.00063181349969740222 * var_sodium_calcium_exchanger__i_NaCa + 0.00020407827359180688 * var_RyR__j_rel - 0.00031590674984870111 * var_L_type_Ca_channel__i_Ca_L_Ca - 0.00031590674984870111 * var_calcium_background_current__i_b_Ca - 0.001 * var_SERCA__j_up + 0.066666666666666666 * (3.0 - 2.0 * var_Force__Force_norm) * var_chaste_interface__troponin__Trpn_Ca - 10.0 * (0.02 - var_chaste_interface__calmodulin__Cmdn_Ca) * var_chaste_interface__intracellular_calcium_concentration__Ca_i - 80.0 * (0.070000000000000007 - var_chaste_interface__troponin__Trpn_Ca) * var_chaste_interface__intracellular_calcium_concentration__Ca_i; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_i;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 9.91e-06
            double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
            // Units: dimensionless; Initial value: 1.7908e-08
            double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__CaMKII_factor__F_CaMK = rY[9];
            // Units: dimensionless; Initial value: 1.028
            double var_chaste_interface__RyR__F_SRCa_RyR = rY[10];
            // Units: millimolar; Initial value: 0.25089
            double var_chaste_interface__RyR__F_2 = rY[12];
            // Units: dimensionless; Initial value: 8.7508e-06
            double var_chaste_interface__calmodulin__Cmdn_Ca = rY[13];
            // Units: millimolar; Initial value: 3.9636e-06
            double var_chaste_interface__troponin__Trpn_Ca = rY[14];
            // Units: millimolar; Initial value: 0.00027661
            double var_chaste_interface__SR_calcium_concentration__Ca_SR = rY[15];
            // Units: millimolar; Initial value: 0.24886
            double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
            // Units: millimolar; Initial value: 5.8041
            
            const double var_x0 = 0.074867781645490947 * var_chaste_interface__membrane_potential__V;
            const double var_x7 = 0.018716945411372737 * var_chaste_interface__membrane_potential__V;
            const double var_x8 = exp(var_x7);
            const double var_x9 = var_x8 * pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3);
            const double var_x10 = exp(-var_x7);
            const double var_x11 = var_x10 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x12 = mParameters[6] / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i);
            const double var_x25 = mParameters[0] * var_chaste_interface__L_type_Ca_channel_f_gate__f;
            const double var_x26 = var_x25 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
            const double var_x27 = exp(3.7433890822745473 - var_x0);
            const double var_x28 = 1.0 - var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x30 = exp(3.7433890822745473);
            const double var_x43 = -50.0 + var_chaste_interface__membrane_potential__V;
            const double var_x44 = var_x26 * var_x43;
            const double var_x45 = var_x29 * var_x44;
            const double var_x55 = 1 / var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x56 = var_x10 * var_x12;
            const double var_x57 = (2.0 * var_x9 - 2744000.0 * var_x11) * mParameters[6] / pow((0.0068999999999999999 + var_chaste_interface__intracellular_calcium_concentration__Ca_i), 2);
            const double var_x58 = var_x30 * var_x45;
            const double var_x79 = 10.0 * var_chaste_interface__calmodulin__Cmdn_Ca;
            const double var_x80 = 80.0 * var_chaste_interface__troponin__Trpn_Ca;
            const double var_x81 = pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2);
            const double var_x82 = pow(var_chaste_interface__SR_calcium_concentration__Ca_SR, 2);
            const double var_x83 = (-0.14537477691850093 * var_x82 + 5069444.444444444 * var_x81 * var_chaste_interface__CaMKII_factor__F_CaMK) / pow((5.7600000000000006e-8 + var_x81 + 2.1415823914336707e-8 * var_x82), 2);
            const double var_x84 = var_x83 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x85 = 1 / (1.0 + 17361111.111111112 * var_x81 + 0.37180249851279007 * var_x82);
            const double var_x86 = var_x85 * var_chaste_interface__CaMKII_factor__F_CaMK * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x87 = 0.25 + var_chaste_interface__RyR__F_2;
            const double var_x88 = pow(var_x87, (-2));
            const double var_x89 = 0.20000000000000001 + var_chaste_interface__RyR__F_SRCa_RyR;
            const double var_x90 = 1 / var_x89;
            const double var_x91 = pow(var_chaste_interface__RyR__F_2, 2);
            const double var_x92 = var_x88 * var_x90 * var_x91;
            const double var_x93 = 0.10203913679590344 * var_x92;
            const double var_x94 = var_x93 * var_chaste_interface__RyR__F_SRCa_RyR;
            
            partialF = -5.8000000000000007 + var_x79 + var_x80 - var_x94 + 1.152e-10 * var_x84 - 1.0548821632800683e-6 * var_x55 - 1733.6962431696716 * var_x56 - 4.3595131479120748e-6 * var_x57 - 10138.888888888887 * var_x86 - 4.7302475136018565e-5 * var_x58;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0013809
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * ((fabs(41.0 + var_chaste_interface__membrane_potential__V) < 1.0000000000000001e-5) ? (2000.0) : (200.0 * (41.0 + var_chaste_interface__membrane_potential__V) / (1.0 - exp(-4.1000000000000005 - 0.10000000000000001 * var_chaste_interface__membrane_potential__V)))) - 8.0 * var_chaste_interface__fast_sodium_current_m_gate__m * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane_potential__V); // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x113 = exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane_potential__V);
            const double var_x115 = 41.0 + var_chaste_interface__membrane_potential__V;
            const double var_x116 = fabs(var_x115) < 1.0000000000000001e-5;
            const double var_x118 = -0.10000000000000001 * var_chaste_interface__membrane_potential__V;
            const double var_x119 = exp(-4.1000000000000005 + var_x118);
            const double var_x120 = 1.0 - var_x119;
            const double var_x121 = 0.20000000000000001 / var_x120;
            const double var_x122 = -8.0 * var_x113;
            
            partialF = ((var_x116) ? (-2.0 + var_x122) : (var_x122 - var_x115 * var_x121));
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.99569
        
        
        // Mathematics
        const double var_fast_sodium_current_h_gate__alpha_h = 20.0 * exp(-9.375 + 0.125 * mParameters[5] - 0.125 * var_chaste_interface__membrane_potential__V); // per_second
        const double var_fast_sodium_current_h_gate__beta_h = 2000.0 / (1.0 + 320.0 * exp(-7.5 + 0.10000000000000001 * mParameters[5] - 0.10000000000000001 * var_chaste_interface__membrane_potential__V)); // per_second
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = 0.001 * (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h) * (-var_chaste_interface__fast_sodium_current_h_gate__h + 0.01 * mParameters[4] + (1.0 - 0.01 * mParameters[4]) * var_fast_sodium_current_h_gate__alpha_h / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h)); // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x118 = -0.10000000000000001 * var_chaste_interface__membrane_potential__V;
            const double var_x123 = exp(-7.5 + var_x118 + 0.10000000000000001 * mParameters[5]);
            const double var_x124 = 1 / (1.0 + 320.0 * var_x123);
            const double var_x125 = 2.0 * var_x124;
            const double var_x126 = -0.125 * var_chaste_interface__membrane_potential__V;
            const double var_x127 = exp(-9.375 + var_x126 + 0.125 * mParameters[5]);
            const double var_x128 = 0.02 * var_x127;
            
            partialF = -var_x125 - var_x128;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x = rY[4];
        // Units: dimensionless; Initial value: 0.051127
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_time_dependent_rectifier_potassium_current_x_gate__x = 0.00050000000000000001 * (1.0 - var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x) * exp(4.1300000000000008 + 0.082600000000000007 * var_chaste_interface__membrane_potential__V) / (1.0 + exp(2.8500000000000001 + 0.057000000000000002 * var_chaste_interface__membrane_potential__V)) - 0.0012999999999999999 * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x * exp(-1.2 - 0.059999999999999998 * var_chaste_interface__membrane_potential__V) / (1.0 + exp(-0.80000000000000004 - 0.040000000000000001 * var_chaste_interface__membrane_potential__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_time_dependent_rectifier_potassium_current_x_gate__x;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x135 = exp(-0.80000000000000004 - 0.040000000000000001 * var_chaste_interface__membrane_potential__V);
            const double var_x136 = 1.0 + var_x135;
            const double var_x137 = exp(-1.2 - 0.059999999999999998 * var_chaste_interface__membrane_potential__V);
            const double var_x138 = var_x137 / var_x136;
            const double var_x140 = exp(2.8500000000000001 + 0.057000000000000002 * var_chaste_interface__membrane_potential__V);
            const double var_x141 = 1.0 + var_x140;
            const double var_x142 = exp(4.1300000000000008 + 0.082600000000000007 * var_chaste_interface__membrane_potential__V);
            const double var_x143 = var_x142 / var_x141;
            
            partialF = -0.00050000000000000001 * var_x143 - 0.0012999999999999999 * var_x138;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[5];
        // Units: dimensionless; Initial value: 0.95854
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_transient_outward_current_s_gate__s = 3.3000000000000003e-5 * (1.0 - var_chaste_interface__transient_outward_current_s_gate__s) * exp(-0.058823529411764705 * var_chaste_interface__membrane_potential__V) - 0.033000000000000002 * var_chaste_interface__transient_outward_current_s_gate__s / (1.0 + exp(-1.25 - 0.125 * var_chaste_interface__membrane_potential__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_transient_outward_current_s_gate__s;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x126 = -0.125 * var_chaste_interface__membrane_potential__V;
            const double var_x144 = exp(-0.058823529411764705 * var_chaste_interface__membrane_potential__V);
            const double var_x145 = exp(-1.25 + var_x126);
            const double var_x146 = 1.0 + var_x145;
            
            partialF = -0.033000000000000002 / var_x146 - 3.3000000000000003e-5 * var_x144;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[6];
        // Units: dimensionless; Initial value: 1.5185e-08
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_transient_outward_current_r_gate__r = 0.33300000000000002 / (1.0 + exp(-0.80000000000000004 - 0.20000000000000001 * var_chaste_interface__membrane_potential__V)) - 0.33300000000000002 * var_chaste_interface__transient_outward_current_r_gate__r; // 1 / millisecond

        return d_dt_chaste_interface_var_transient_outward_current_r_gate__r;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.33300000000000002;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 1.7908e-08
        
        
        // Mathematics
        const double var_L_type_Ca_channel_d_gate__E0_d = 19.0 + var_chaste_interface__membrane_potential__V; // millivolt
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d = 0.001 * (1.0 - var_chaste_interface__L_type_Ca_channel_d_gate__d) * ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 1.0000000000000001e-5) ? (360.0) : (90.0 * var_L_type_Ca_channel_d_gate__E0_d / (1.0 - exp(-0.25 * var_L_type_Ca_channel_d_gate__E0_d)))) - 0.001 * ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 1.0000000000000001e-5) ? (360.0) : (-36.0 * var_L_type_Ca_channel_d_gate__E0_d / (1.0 - exp(0.10000000000000001 * var_L_type_Ca_channel_d_gate__E0_d)))) * var_chaste_interface__L_type_Ca_channel_d_gate__d; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x148 = 19.0 + var_chaste_interface__membrane_potential__V;
            const double var_x149 = fabs(var_x148) < 1.0000000000000001e-5;
            const double var_x150 = exp(1.8999999999999999 + 0.10000000000000001 * var_chaste_interface__membrane_potential__V);
            const double var_x151 = 1.0 - var_x150;
            const double var_x152 = 0.035999999999999997 / var_x151;
            const double var_x154 = 0.25 * var_chaste_interface__membrane_potential__V;
            const double var_x155 = -var_x154;
            const double var_x156 = exp(-4.75 + var_x155);
            const double var_x157 = 1.0 - var_x156;
            const double var_x158 = 0.089999999999999997 / var_x157;
            
            partialF = ((var_x149) ? (-0.71999999999999997) : (var_x148 * var_x152 - var_x148 * var_x158));
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        
        
        // Mathematics
        const double var_L_type_Ca_channel_f_gate__E0_f = 34.0 + var_chaste_interface__membrane_potential__V; // millivolt
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f = 0.001 * (1.0 - var_chaste_interface__L_type_Ca_channel_f_gate__f) * ((fabs(var_L_type_Ca_channel_f_gate__E0_f) < 1.0000000000000001e-5) ? (12.5) : (3.125 * var_L_type_Ca_channel_f_gate__E0_f / (-1.0 + exp(0.25 * var_L_type_Ca_channel_f_gate__E0_f)))) - 0.025000000000000001 * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 + exp(-0.25 * var_L_type_Ca_channel_f_gate__E0_f)); // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x154 = 0.25 * var_chaste_interface__membrane_potential__V;
            const double var_x155 = -var_x154;
            const double var_x159 = exp(-8.5 + var_x155);
            const double var_x160 = 1.0 + var_x159;
            const double var_x162 = 34.0 + var_chaste_interface__membrane_potential__V;
            const double var_x163 = fabs(var_x162) < 1.0000000000000001e-5;
            const double var_x165 = exp(8.5 + var_x154);
            const double var_x166 = -1.0 + var_x165;
            const double var_x167 = 0.0031250000000000002 / var_x166;
            const double var_x168 = -0.025000000000000001 / var_x160;
            
            partialF = ((var_x163) ? (-0.012500000000000001 + var_x168) : (var_x168 - var_x162 * var_x167));
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__CaMKII_factor__F_CaMK = rY[9];
        // Units: dimensionless; Initial value: 1.028
        double var_chaste_interface__calmodulin__Cmdn_Ca = rY[13];
        // Units: millimolar; Initial value: 3.9636e-06
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_CaMKII_factor__F_CaMK = 24.999999999999996 * var_chaste_interface__calmodulin__Cmdn_Ca - 0.00125 * var_chaste_interface__CaMKII_factor__F_CaMK; // 1 / millisecond

        return d_dt_chaste_interface_var_CaMKII_factor__F_CaMK;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.00125;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__RyR__F_SRCa_RyR = rY[10];
        // Units: millimolar; Initial value: 0.25089
        double var_chaste_interface__SR_calcium_concentration__Ca_SR = rY[15];
        // Units: millimolar; Initial value: 0.24886
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_RyR__F_SRCa_RyR = 0.02 * var_chaste_interface__SR_calcium_concentration__Ca_SR - 0.02 * var_chaste_interface__RyR__F_SRCa_RyR; // millimolar / millisecond

        return d_dt_chaste_interface_var_RyR__F_SRCa_RyR;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.02;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__CaMKII_factor__F_CaMK = rY[9];
        // Units: dimensionless; Initial value: 1.028
        double var_chaste_interface__RyR__F_SRCa_RyR = rY[10];
        // Units: millimolar; Initial value: 0.25089
        double var_chaste_interface__RyR__F_1 = rY[11];
        // Units: dimensionless; Initial value: 0.5268
        double var_chaste_interface__RyR__F_2 = rY[12];
        // Units: dimensionless; Initial value: 8.7508e-06
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
        // Units: millimolar; Initial value: 138.22
        
        
        // Mathematics
        const double var_L_type_Ca_channel__i_Ca_L_Ca = 0.14973556329098189 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-2.0 * exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(3.7433890822745473)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K = 7.4867781645490941e-5 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-4.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_potassium_concentration__K_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na = 0.00037433890822745472 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-140.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_Ca_L_Ca + var_L_type_Ca_channel__i_Ca_L_K + var_L_type_Ca_channel__i_Ca_L_Na; // nanoA
        const double var_RyR__k_1 = 30625000.0 * pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2) - 245.0 * var_L_type_Ca_channel__i_Ca_L; // per_second
        const double d_dt_chaste_interface_var_RyR__F_1 = -0.0018 * var_chaste_interface__RyR__F_1 + 0.001885 * pow((4.5454545454545459 * var_chaste_interface__RyR__F_SRCa_RyR), (2.0408163265306123 * pow(var_chaste_interface__CaMKII_factor__F_CaMK, 2))) * (1.0 - var_chaste_interface__RyR__F_1 - var_chaste_interface__RyR__F_2) - 0.001 * var_chaste_interface__RyR__F_1 * var_RyR__k_1; // 1 / millisecond

        return d_dt_chaste_interface_var_RyR__F_1;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 9.91e-06
            double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
            // Units: dimensionless; Initial value: 1.7908e-08
            double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__CaMKII_factor__F_CaMK = rY[9];
            // Units: dimensionless; Initial value: 1.028
            double var_chaste_interface__RyR__F_SRCa_RyR = rY[10];
            // Units: millimolar; Initial value: 0.25089
            double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
            // Units: millimolar; Initial value: 5.8041
            double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
            // Units: millimolar; Initial value: 138.22
            
            const double var_x0 = 0.074867781645490947 * var_chaste_interface__membrane_potential__V;
            const double var_x16 = -0.037433890822745473 * var_chaste_interface__membrane_potential__V;
            const double var_x25 = mParameters[0] * var_chaste_interface__L_type_Ca_channel_f_gate__f;
            const double var_x26 = var_x25 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
            const double var_x27 = exp(3.7433890822745473 - var_x0);
            const double var_x28 = 1.0 - var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x30 = exp(3.7433890822745473);
            const double var_x31 = -2.0 * var_x27 + var_x30 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x32 = var_x29 * var_x31;
            const double var_x34 = exp(1.8716945411372736 + var_x16);
            const double var_x35 = 1.0 - var_x34;
            const double var_x36 = 1 / var_x35;
            const double var_x37 = var_x26 * var_x36;
            const double var_x38 = exp(1.8716945411372736);
            const double var_x39 = -4.0 * var_x34 + var_x38 * var_chaste_interface__intracellular_potassium_concentration__K_i;
            const double var_x41 = -140.0 * var_x34 + var_x38 * var_chaste_interface__intracellular_sodium_concentration__Na_i;
            const double var_x43 = -50.0 + var_chaste_interface__membrane_potential__V;
            const double var_x81 = pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2);
            const double var_x169 = 0.03668521300629056 * var_x32;
            const double var_x170 = var_x169 * var_x26;
            const double var_x171 = 1.8342606503145281e-5 * var_x39;
            const double var_x172 = var_x171 * var_x37;
            const double var_x173 = 9.1713032515726407e-5 * var_x41;
            const double var_x174 = var_x173 * var_x37;
            const double var_x188 = 4.5454545454545459 * var_chaste_interface__RyR__F_SRCa_RyR;
            const double var_x189 = pow(var_chaste_interface__CaMKII_factor__F_CaMK, 2);
            const double var_x190 = pow(var_x188, (2.0408163265306123 * var_x189));
            const double var_x192 = 30625.0 * var_x81;
            const double var_x193 = -0.001885 * var_x190;
            const double var_x194 = var_x170 * var_x43;
            const double var_x195 = var_x172 * var_x43;
            const double var_x196 = var_x174 * var_x43;
            
            partialF = -0.0018 + var_x193 + var_x194 + var_x195 + var_x196 - var_x192;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__RyR__F_1 = rY[11];
        // Units: dimensionless; Initial value: 0.5268
        double var_chaste_interface__RyR__F_2 = rY[12];
        // Units: dimensionless; Initial value: 8.7508e-06
        double var_chaste_interface__SR_calcium_concentration__Ca_SR = rY[15];
        // Units: millimolar; Initial value: 0.24886
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
        // Units: millimolar; Initial value: 138.22
        
        
        // Mathematics
        const double var_L_type_Ca_channel__i_Ca_L_Ca = 0.14973556329098189 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-2.0 * exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(3.7433890822745473)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K = 7.4867781645490941e-5 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-4.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_potassium_concentration__K_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na = 0.00037433890822745472 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-140.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_Ca_L_Ca + var_L_type_Ca_channel__i_Ca_L_K + var_L_type_Ca_channel__i_Ca_L_Na; // nanoA
        const double var_RyR__k_1 = 30625000.0 * pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2) - 245.0 * var_L_type_Ca_channel__i_Ca_L; // per_second
        const double d_dt_chaste_interface_var_RyR__F_2 = 0.001 * var_chaste_interface__RyR__F_1 * var_RyR__k_1 - 0.45000000000000001 * var_chaste_interface__RyR__F_2 / (1.0 + 0.35999999999999999 / var_chaste_interface__SR_calcium_concentration__Ca_SR); // 1 / millisecond

        return d_dt_chaste_interface_var_RyR__F_2;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__SR_calcium_concentration__Ca_SR = rY[15];
            // Units: millimolar; Initial value: 0.24886
            
            const double var_x200 = 1.0 + 0.35999999999999999 / var_chaste_interface__SR_calcium_concentration__Ca_SR;
            
            partialF = -0.45000000000000001 / var_x200;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__calmodulin__Cmdn_Ca = rY[13];
        // Units: millimolar; Initial value: 3.9636e-06
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_calmodulin__Cmdn_Ca = -0.5 * var_chaste_interface__calmodulin__Cmdn_Ca + 10.0 * (0.02 - var_chaste_interface__calmodulin__Cmdn_Ca) * var_chaste_interface__intracellular_calcium_concentration__Ca_i; // millimolar / millisecond

        return d_dt_chaste_interface_var_calmodulin__Cmdn_Ca;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 9.91e-06
            
            const double var_x102 = 10.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            
            partialF = -0.5 - var_x102;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__troponin__Trpn_Ca = rY[14];
        // Units: millimolar; Initial value: 0.00027661
        double var_chaste_interface__Force__N_0 = rY[18];
        // Units: dimensionless; Initial value: 0.99917
        double var_chaste_interface__Force__P_0 = rY[19];
        // Units: dimensionless; Initial value: 9.8593e-05
        double var_chaste_interface__Force__P_1 = rY[20];
        // Units: dimensionless; Initial value: 0.00013331
        double var_chaste_interface__Force__P_2 = rY[21];
        // Units: dimensionless; Initial value: 0.00023505
        double var_chaste_interface__Force__P_3 = rY[22];
        // Units: dimensionless; Initial value: 0.00015349
        
        
        // Mathematics
        const double var_Force__N_1 = 1.0 - var_chaste_interface__Force__N_0 - var_chaste_interface__Force__P_0 - var_chaste_interface__Force__P_1 - var_chaste_interface__Force__P_2 - var_chaste_interface__Force__P_3; // dimensionless
        const double var_Force__Force_norm = 0.60360360360360366 * var_Force__N_1 + 0.60360360360360366 * var_chaste_interface__Force__P_1 + 1.2072072072072073 * var_chaste_interface__Force__P_2 + 1.8108108108108107 * var_chaste_interface__Force__P_3; // dimensionless
        const double d_dt_chaste_interface_var_troponin__Trpn_Ca = 80.0 * (0.070000000000000007 - var_chaste_interface__troponin__Trpn_Ca) * var_chaste_interface__intracellular_calcium_concentration__Ca_i - 0.066666666666666666 * (3.0 - 2.0 * var_Force__Force_norm) * var_chaste_interface__troponin__Trpn_Ca; // millimolar / millisecond

        return d_dt_chaste_interface_var_troponin__Trpn_Ca;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 9.91e-06
            double var_chaste_interface__Force__N_0 = rY[18];
            // Units: dimensionless; Initial value: 0.99917
            double var_chaste_interface__Force__P_0 = rY[19];
            // Units: dimensionless; Initial value: 9.8593e-05
            double var_chaste_interface__Force__P_2 = rY[21];
            // Units: dimensionless; Initial value: 0.00023505
            double var_chaste_interface__Force__P_3 = rY[22];
            // Units: dimensionless; Initial value: 0.00015349
            
            const double var_x103 = 80.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x104 = 0.080480480480480482 * var_chaste_interface__Force__N_0;
            const double var_x105 = 0.080480480480480482 * var_chaste_interface__Force__P_0;
            const double var_x106 = 0.080480480480480482 * var_chaste_interface__Force__P_2;
            const double var_x107 = 0.16096096096096096 * var_chaste_interface__Force__P_3;
            
            partialF = -0.11951951951951952 + var_x106 + var_x107 - var_x103 - var_x104 - var_x105;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative15(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__CaMKII_factor__F_CaMK = rY[9];
        // Units: dimensionless; Initial value: 1.028
        double var_chaste_interface__RyR__F_SRCa_RyR = rY[10];
        // Units: millimolar; Initial value: 0.25089
        double var_chaste_interface__RyR__F_2 = rY[12];
        // Units: dimensionless; Initial value: 8.7508e-06
        double var_chaste_interface__SR_calcium_concentration__Ca_SR = rY[15];
        // Units: millimolar; Initial value: 0.24886
        
        
        // Mathematics
        const double var_RyR__j_rel = 500.0 * pow(var_chaste_interface__RyR__F_2, 2) * (-var_chaste_interface__intracellular_calcium_concentration__Ca_i + var_chaste_interface__SR_calcium_concentration__Ca_SR) * var_chaste_interface__RyR__F_SRCa_RyR / (pow((0.25 + var_chaste_interface__RyR__F_2), 2) * (0.20000000000000001 + var_chaste_interface__RyR__F_SRCa_RyR)); // millimolar_per_second
        const double var_SERCA__j_up = (-0.14537477691850093 * pow(var_chaste_interface__SR_calcium_concentration__Ca_SR, 2) + 5069444.444444444 * pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2) * var_chaste_interface__CaMKII_factor__F_CaMK) / (1.0 + 17361111.111111112 * pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2) + 0.37180249851279007 * pow(var_chaste_interface__SR_calcium_concentration__Ca_SR, 2)); // millimolar_per_second
        const double d_dt_chaste_interface_var_SR_calcium_concentration__Ca_SR = 0.0049000806523882071 * var_SERCA__j_up - 0.001 * var_RyR__j_rel; // millimolar / millisecond

        return d_dt_chaste_interface_var_SR_calcium_concentration__Ca_SR;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative15(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 9.91e-06
            double var_chaste_interface__CaMKII_factor__F_CaMK = rY[9];
            // Units: dimensionless; Initial value: 1.028
            double var_chaste_interface__RyR__F_SRCa_RyR = rY[10];
            // Units: millimolar; Initial value: 0.25089
            double var_chaste_interface__RyR__F_2 = rY[12];
            // Units: dimensionless; Initial value: 8.7508e-06
            double var_chaste_interface__SR_calcium_concentration__Ca_SR = rY[15];
            // Units: millimolar; Initial value: 0.24886
            
            const double var_x81 = pow(var_chaste_interface__intracellular_calcium_concentration__Ca_i, 2);
            const double var_x82 = pow(var_chaste_interface__SR_calcium_concentration__Ca_SR, 2);
            const double var_x83 = (-0.14537477691850093 * var_x82 + 5069444.444444444 * var_x81 * var_chaste_interface__CaMKII_factor__F_CaMK) / pow((5.7600000000000006e-8 + var_x81 + 2.1415823914336707e-8 * var_x82), 2);
            const double var_x85 = 1 / (1.0 + 17361111.111111112 * var_x81 + 0.37180249851279007 * var_x82);
            const double var_x87 = 0.25 + var_chaste_interface__RyR__F_2;
            const double var_x88 = pow(var_x87, (-2));
            const double var_x89 = 0.20000000000000001 + var_chaste_interface__RyR__F_SRCa_RyR;
            const double var_x90 = 1 / var_x89;
            const double var_x91 = pow(var_chaste_interface__RyR__F_2, 2);
            const double var_x92 = var_x88 * var_x90 * var_x91;
            const double var_x108 = var_x85 * var_chaste_interface__SR_calcium_concentration__Ca_SR;
            const double var_x109 = var_x83 * var_chaste_interface__SR_calcium_concentration__Ca_SR;
            const double var_x201 = 0.5 * var_x92;
            const double var_x202 = var_x201 * var_chaste_interface__RyR__F_SRCa_RyR;
            
            partialF = -var_x202 - 0.001424696263447196 * var_x108 - 1.2089003260906828e-17 * var_x109;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative16(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0013809
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.99569
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
        // Units: millimolar; Initial value: 138.22
        
        
        // Mathematics
        const double var_L_type_Ca_channel__i_Ca_L_Na = 0.00037433890822745472 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-140.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-26.713760659695652 * log(140.47999999999999 / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) + var_chaste_interface__membrane_potential__V) * mParameters[3] * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_sodium_background_current__i_b_Na = 0.00059999999999999995 * var_chaste_interface__membrane_potential__V - 0.016028256395817387 * log(140.0 / var_chaste_interface__intracellular_sodium_concentration__Na_i); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa = (2.0 * pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3) * exp(0.018716945411372737 * var_chaste_interface__membrane_potential__V) - 2744000.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(-0.018716945411372737 * var_chaste_interface__membrane_potential__V)) * mParameters[6] / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.0880000000000001 * var_chaste_interface__intracellular_sodium_concentration__Na_i / ((21.699999999999999 + var_chaste_interface__intracellular_sodium_concentration__Na_i) * (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__membrane_potential__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__membrane_potential__V))); // nanoA
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Na_i = -0.00063181349969740222 * var_L_type_Ca_channel__i_Ca_L_Na - 0.00063181349969740222 * var_fast_sodium_current__i_Na - 0.00063181349969740222 * var_sodium_background_current__i_b_Na - 0.0018954404990922066 * var_sodium_calcium_exchanger__i_NaCa - 0.0018954404990922066 * var_sodium_potassium_pump__i_NaK; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_sodium_concentration__Na_i;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative16(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 9.91e-06
            double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
            // Units: dimensionless; Initial value: 0.0013809
            double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
            // Units: dimensionless; Initial value: 0.99569
            double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
            // Units: dimensionless; Initial value: 1.7908e-08
            double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
            // Units: millimolar; Initial value: 5.8041
            double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
            // Units: millimolar; Initial value: 138.22
            
            const double var_x7 = 0.018716945411372737 * var_chaste_interface__membrane_potential__V;
            const double var_x8 = exp(var_x7);
            const double var_x12 = mParameters[6] / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i);
            const double var_x14 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * mParameters[3];
            const double var_x15 = var_x14 * var_chaste_interface__fast_sodium_current_h_gate__h;
            const double var_x16 = -0.037433890822745473 * var_chaste_interface__membrane_potential__V;
            const double var_x17 = exp(var_x16);
            const double var_x21 = 1 / (21.699999999999999 + var_chaste_interface__intracellular_sodium_concentration__Na_i);
            const double var_x22 = exp(-0.0037433890822745472 * var_chaste_interface__membrane_potential__V);
            const double var_x23 = 1.0 + 0.035299999999999998 * var_x17 + 0.1245 * var_x22;
            const double var_x25 = mParameters[0] * var_chaste_interface__L_type_Ca_channel_f_gate__f;
            const double var_x26 = var_x25 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
            const double var_x34 = exp(1.8716945411372736 + var_x16);
            const double var_x35 = 1.0 - var_x34;
            const double var_x36 = 1 / var_x35;
            const double var_x37 = var_x26 * var_x36;
            const double var_x38 = exp(1.8716945411372736);
            const double var_x43 = -50.0 + var_chaste_interface__membrane_potential__V;
            const double var_x47 = var_x37 * var_x43;
            const double var_x59 = var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i;
            const double var_x68 = 1 / var_chaste_interface__intracellular_sodium_concentration__Na_i;
            const double var_x69 = 1 / var_x23;
            const double var_x70 = var_x21 * var_x69;
            const double var_x71 = var_x69 * var_chaste_interface__intracellular_sodium_concentration__Na_i / pow((1 + 0.046082949308755762 * var_chaste_interface__intracellular_sodium_concentration__Na_i), 2);
            const double var_x72 = var_x12 * var_x8 * pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 2);
            const double var_x73 = var_x15 * (0.00085421412300683362 * var_chaste_interface__intracellular_potassium_concentration__K_i + 0.0071184510250569474 * var_chaste_interface__intracellular_sodium_concentration__Na_i) / pow(var_x59, 2);
            const double var_x74 = var_x38 * var_x47;
            
            partialF = 4.3794501115171722e-6 * var_x71 - 0.011372642994553239 * var_x72 - 1.0126868767488654e-5 * var_x68 - 0.0020622392630123207 * var_x70 - 2.371037540761344 * var_x73 - 2.3651237568009284e-7 * var_x74;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative17(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x = rY[4];
        // Units: dimensionless; Initial value: 0.051127
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[5];
        // Units: dimensionless; Initial value: 0.95854
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[6];
        // Units: dimensionless; Initial value: 1.5185e-08
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
        // Units: millimolar; Initial value: 138.22
        
        
        // Mathematics
        const double var_L_type_Ca_channel__i_Ca_L_K = 7.4867781645490941e-5 * (-50.0 + var_chaste_interface__membrane_potential__V) * (-4.0 * exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_potassium_concentration__K_i * exp(1.8716945411372736)) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f / (1.0 - exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane_potential__V)); // nanoA
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(4.0 / var_chaste_interface__intracellular_potassium_concentration__K_i); // millivolt
        const double var_potassium_background_current__i_b_K = 0.00059999999999999995 * var_chaste_interface__membrane_potential__V - 0.00059999999999999995 * var_reversal_potentials__E_K; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.0880000000000001 * var_chaste_interface__intracellular_sodium_concentration__Na_i / ((21.699999999999999 + var_chaste_interface__intracellular_sodium_concentration__Na_i) * (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__membrane_potential__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__membrane_potential__V))); // nanoA
        const double var_time_dependent_rectifier_potassium_current__i_K = 0.0071428571428571426 * (-4.0 * exp(-0.037433890822745473 * var_chaste_interface__membrane_potential__V) + var_chaste_interface__intracellular_potassium_concentration__K_i) * mParameters[2] * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__i_K1 = 0.2857142857142857 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) / (1.0 + exp(-0.74867781645490938 + 0.074867781645490947 * var_chaste_interface__membrane_potential__V - 0.074867781645490947 * var_reversal_potentials__E_K)); // nanoA
        const double var_transient_outward_current__i_to = 0.0050000000000000001 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane_potential__V) * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // nanoA
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__K_i = 0.0012636269993948044 * var_sodium_potassium_pump__i_NaK - 0.00063181349969740222 * var_L_type_Ca_channel__i_Ca_L_K - 0.00063181349969740222 * var_potassium_background_current__i_b_K - 0.00063181349969740222 * var_time_dependent_rectifier_potassium_current__i_K - 0.00063181349969740222 * var_time_independent_potassium_current__i_K1 - 0.00063181349969740222 * var_transient_outward_current__i_to; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_potassium_concentration__K_i;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative17(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            double var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x = rY[4];
            // Units: dimensionless; Initial value: 0.051127
            double var_chaste_interface__transient_outward_current_s_gate__s = rY[5];
            // Units: dimensionless; Initial value: 0.95854
            double var_chaste_interface__transient_outward_current_r_gate__r = rY[6];
            // Units: dimensionless; Initial value: 1.5185e-08
            double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
            // Units: dimensionless; Initial value: 1.7908e-08
            double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
            // Units: millimolar; Initial value: 138.22
            
            const double var_x0 = 0.074867781645490947 * var_chaste_interface__membrane_potential__V;
            const double var_x1 = 1 / var_chaste_interface__intracellular_potassium_concentration__K_i;
            const double var_x2 = log(4.0 * var_x1);
            const double var_x3 = exp(-0.74867781645490938 + var_x0 - 2.0 * var_x2);
            const double var_x4 = 1.0 + var_x3;
            const double var_x5 = 1 / var_x4;
            const double var_x6 = var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s;
            const double var_x16 = -0.037433890822745473 * var_chaste_interface__membrane_potential__V;
            const double var_x18 = mParameters[2] * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x;
            const double var_x20 = var_x3 * (-26.713760659695652 * var_x2 + var_chaste_interface__membrane_potential__V) / pow(var_x4, 2);
            const double var_x25 = mParameters[0] * var_chaste_interface__L_type_Ca_channel_f_gate__f;
            const double var_x26 = var_x25 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
            const double var_x34 = exp(1.8716945411372736 + var_x16);
            const double var_x35 = 1.0 - var_x34;
            const double var_x36 = 1 / var_x35;
            const double var_x37 = var_x26 * var_x36;
            const double var_x38 = exp(1.8716945411372736);
            const double var_x43 = -50.0 + var_chaste_interface__membrane_potential__V;
            const double var_x47 = var_x37 * var_x43;
            const double var_x74 = var_x38 * var_x47;
            const double var_x75 = var_x1 * var_x5;
            const double var_x76 = var_x1 * var_x6;
            const double var_x77 = var_x1 * var_x20;
            
            partialF = 0.00036103628554137268 * var_x77 - 4.7302475136018567e-8 * var_x74 - 1.0126868767488654e-5 * var_x1 - 4.5129535692671587e-6 * var_x18 - 0.0048223184607088833 * var_x75 - 8.4390573062405455e-5 * var_x76;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative18(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__troponin__Trpn_Ca = rY[14];
        // Units: millimolar; Initial value: 0.00027661
        double var_chaste_interface__Force__N_0 = rY[18];
        // Units: dimensionless; Initial value: 0.99917
        double var_chaste_interface__Force__P_0 = rY[19];
        // Units: dimensionless; Initial value: 9.8593e-05
        double var_chaste_interface__Force__P_1 = rY[20];
        // Units: dimensionless; Initial value: 0.00013331
        double var_chaste_interface__Force__P_2 = rY[21];
        // Units: dimensionless; Initial value: 0.00023505
        double var_chaste_interface__Force__P_3 = rY[22];
        // Units: dimensionless; Initial value: 0.00015349
        
        
        // Mathematics
        const double var_Force__N_1 = 1.0 - var_chaste_interface__Force__N_0 - var_chaste_interface__Force__P_0 - var_chaste_interface__Force__P_1 - var_chaste_interface__Force__P_2 - var_chaste_interface__Force__P_3; // dimensionless
        const double var_Force__alpha_tm = 12600800629.436172 * pow(var_chaste_interface__troponin__Trpn_Ca, 5.1071428571428568); // per_second
        const double d_dt_chaste_interface_var_Force__N_0 = 0.040714285714285717 * var_Force__N_1 + 0.040000000000000001 * var_chaste_interface__Force__P_0 - 0.001 * var_chaste_interface__Force__N_0 * var_Force__alpha_tm; // 1 / millisecond

        return d_dt_chaste_interface_var_Force__N_0;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative18(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__troponin__Trpn_Ca = rY[14];
            // Units: millimolar; Initial value: 0.00027661
            
            const double var_x209 = 12600800.629436173 * pow(var_chaste_interface__troponin__Trpn_Ca, 5.1071428571428568);
            const double var_x210 = -var_x209;
            
            partialF = -0.040714285714285717 + var_x210;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative19(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__troponin__Trpn_Ca = rY[14];
        // Units: millimolar; Initial value: 0.00027661
        double var_chaste_interface__Force__N_0 = rY[18];
        // Units: dimensionless; Initial value: 0.99917
        double var_chaste_interface__Force__P_0 = rY[19];
        // Units: dimensionless; Initial value: 9.8593e-05
        double var_chaste_interface__Force__P_1 = rY[20];
        // Units: dimensionless; Initial value: 0.00013331
        
        
        // Mathematics
        const double var_Force__alpha_tm = 12600800629.436172 * pow(var_chaste_interface__troponin__Trpn_Ca, 5.1071428571428568); // per_second
        const double d_dt_chaste_interface_var_Force__P_0 = 0.040714285714285717 * var_chaste_interface__Force__P_1 - 0.070000000000000007 * var_chaste_interface__Force__P_0 + 0.001 * var_chaste_interface__Force__N_0 * var_Force__alpha_tm; // 1 / millisecond

        return d_dt_chaste_interface_var_Force__P_0;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative19(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.070000000000000007;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative20(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__troponin__Trpn_Ca = rY[14];
        // Units: millimolar; Initial value: 0.00027661
        double var_chaste_interface__Force__N_0 = rY[18];
        // Units: dimensionless; Initial value: 0.99917
        double var_chaste_interface__Force__P_0 = rY[19];
        // Units: dimensionless; Initial value: 9.8593e-05
        double var_chaste_interface__Force__P_1 = rY[20];
        // Units: dimensionless; Initial value: 0.00013331
        double var_chaste_interface__Force__P_2 = rY[21];
        // Units: dimensionless; Initial value: 0.00023505
        double var_chaste_interface__Force__P_3 = rY[22];
        // Units: dimensionless; Initial value: 0.00015349
        
        
        // Mathematics
        const double var_Force__N_1 = 1.0 - var_chaste_interface__Force__N_0 - var_chaste_interface__Force__P_0 - var_chaste_interface__Force__P_1 - var_chaste_interface__Force__P_2 - var_chaste_interface__Force__P_3; // dimensionless
        const double var_Force__alpha_tm = 12600800629.436172 * pow(var_chaste_interface__troponin__Trpn_Ca, 5.1071428571428568); // per_second
        const double d_dt_chaste_interface_var_Force__P_1 = 0.081428571428571433 * var_chaste_interface__Force__P_2 + 0.029999999999999999 * var_chaste_interface__Force__P_0 - 0.18071428571428572 * var_chaste_interface__Force__P_1 + 0.001 * var_Force__N_1 * var_Force__alpha_tm; // 1 / millisecond

        return d_dt_chaste_interface_var_Force__P_1;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative20(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__troponin__Trpn_Ca = rY[14];
            // Units: millimolar; Initial value: 0.00027661
            
            const double var_x209 = 12600800.629436173 * pow(var_chaste_interface__troponin__Trpn_Ca, 5.1071428571428568);
            const double var_x210 = -var_x209;
            
            partialF = -0.18071428571428572 + var_x210;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative21(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Force__P_1 = rY[20];
        // Units: dimensionless; Initial value: 0.00013331
        double var_chaste_interface__Force__P_2 = rY[21];
        // Units: dimensionless; Initial value: 0.00023505
        double var_chaste_interface__Force__P_3 = rY[22];
        // Units: dimensionless; Initial value: 0.00015349
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Force__P_2 = 0.12214285714285715 * var_chaste_interface__Force__P_3 + 0.10000000000000001 * var_chaste_interface__Force__P_1 - 0.15142857142857144 * var_chaste_interface__Force__P_2; // 1 / millisecond

        return d_dt_chaste_interface_var_Force__P_2;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative21(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.15142857142857144;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluateYDerivative22(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Force__P_2 = rY[21];
        // Units: dimensionless; Initial value: 0.00023505
        double var_chaste_interface__Force__P_3 = rY[22];
        // Units: dimensionless; Initial value: 0.00015349
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Force__P_3 = 0.070000000000000007 * var_chaste_interface__Force__P_2 - 0.12214285714285715 * var_chaste_interface__Force__P_3; // 1 / millisecond

        return d_dt_chaste_interface_var_Force__P_3;
    }

    double Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::EvaluatePartialDerivative22(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.12214285714285715;
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }

    std::vector<double> Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane_potential__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 9.91e-06
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0013809
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[3];
        // Units: dimensionless; Initial value: 0.99569
        double var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x = rY[4];
        // Units: dimensionless; Initial value: 0.051127
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 1.7908e-08
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[16];
        // Units: millimolar; Initial value: 5.8041
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[17];
        // Units: millimolar; Initial value: 138.22
        

        // Mathematics
        const double var_cell_parameters__Ca_o = 2.0; // millimolar
        const double var_cell_parameters__F = 96485.341499999995; // coulomb_per_mole
        const double var_cell_parameters__K_o = 4.0; // millimolar
        const double var_cell_parameters__Na_o = 140.0; // millimolar
        const double var_cell_parameters__R = 8314.4719999999998; // millijoule_per_mole_kelvin
        const double var_cell_parameters__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca = 4.0 * (-50.0 + var_chaste_interface__membrane_potential__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T)) - var_cell_parameters__Ca_o * exp(-2.0 * (-50.0 + var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_cell_parameters__F / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * var_cell_parameters__R * var_cell_parameters__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K = 0.002 * (-50.0 + var_chaste_interface__membrane_potential__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T)) - var_cell_parameters__K_o * exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_cell_parameters__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * var_cell_parameters__R * var_cell_parameters__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na = 0.01 * (-50.0 + var_chaste_interface__membrane_potential__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T)) - var_cell_parameters__Na_o * exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * mParameters[0] * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_cell_parameters__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane_potential__V) * var_cell_parameters__F / (var_cell_parameters__R * var_cell_parameters__T))) * var_cell_parameters__R * var_cell_parameters__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_Ca_L_Ca + var_L_type_Ca_channel__i_Ca_L_K + var_L_type_Ca_channel__i_Ca_L_Na; // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_converted = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_L_type_Ca_channel__i_Ca_L / mParameters[1]; // uA_per_cm2
        const double var_membrane_potential__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
        const double var_reversal_potentials__E_mh = var_cell_parameters__R * var_cell_parameters__T * log((var_cell_parameters__Na_o + 0.12 * var_cell_parameters__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_cell_parameters__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_mh + var_chaste_interface__membrane_potential__V) * mParameters[3] * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_fast_sodium_current__i_Na_converted = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_fast_sodium_current__i_Na / mParameters[1]; // uA_per_cm2
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3) * var_cell_parameters__Ca_o * exp(var_cell_parameters__F * var_chaste_interface__membrane_potential__V * var_sodium_calcium_exchanger__gamma / (var_cell_parameters__R * var_cell_parameters__T)) - pow(var_cell_parameters__Na_o, 3) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * var_cell_parameters__F * var_chaste_interface__membrane_potential__V / (var_cell_parameters__R * var_cell_parameters__T))) * mParameters[6] / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa_converted = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_sodium_calcium_exchanger__i_NaCa / mParameters[1]; // uA_per_cm2
        const double var_time_dependent_rectifier_potassium_current__i_K = 0.0071428571428571426 * (-var_cell_parameters__K_o * exp(-var_cell_parameters__F * var_chaste_interface__membrane_potential__V / (var_cell_parameters__R * var_cell_parameters__T)) + var_chaste_interface__intracellular_potassium_concentration__K_i) * mParameters[2] * var_chaste_interface__time_dependent_rectifier_potassium_current_x_gate__x; // nanoA
        const double var_time_dependent_rectifier_potassium_current__i_K_converted = 0.001 * HeartConfig::Instance()->GetCapacitance() * var_time_dependent_rectifier_potassium_current__i_K / mParameters[1]; // uA_per_cm2

        std::vector<double> dqs(6);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_L_type_Ca_channel__i_Ca_L_converted;
        dqs[2] = var_time_dependent_rectifier_potassium_current__i_K_converted;
        dqs[3] = var_fast_sodium_current__i_Na_converted;
        dqs[4] = var_sodium_calcium_exchanger__i_NaCa_converted;
        dqs[5] = var_membrane_potential__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt>::Initialise(void)
{
    this->mSystemName = "iribe_model_2006";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-92.849333);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.91e-06);

    // rY[2]:
    this->mVariableNames.push_back("membrane_fast_sodium_current_m_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0013809);

    // rY[3]:
    this->mVariableNames.push_back("membrane_fast_sodium_current_h_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99569);

    // rY[4]:
    this->mVariableNames.push_back("time_dependent_rectifier_potassium_current_x_gate__x");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.051127);

    // rY[5]:
    this->mVariableNames.push_back("transient_outward_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.95854);

    // rY[6]:
    this->mVariableNames.push_back("transient_outward_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.5185e-08);

    // rY[7]:
    this->mVariableNames.push_back("membrane_L_type_calcium_current_d_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.7908e-08);

    // rY[8]:
    this->mVariableNames.push_back("membrane_L_type_calcium_current_f_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // rY[9]:
    this->mVariableNames.push_back("CaMKII_factor__F_CaMK");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.028);

    // rY[10]:
    this->mVariableNames.push_back("RyR__F_SRCa_RyR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.25089);

    // rY[11]:
    this->mVariableNames.push_back("RyR__F_1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5268);

    // rY[12]:
    this->mVariableNames.push_back("RyR__F_2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.7508e-06);

    // rY[13]:
    this->mVariableNames.push_back("calmodulin__Cmdn_Ca");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(3.9636e-06);

    // rY[14]:
    this->mVariableNames.push_back("troponin__Trpn_Ca");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00027661);

    // rY[15]:
    this->mVariableNames.push_back("SR_calcium_concentration__Ca_SR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.24886);

    // rY[16]:
    this->mVariableNames.push_back("cytosolic_sodium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.8041);

    // rY[17]:
    this->mVariableNames.push_back("cytosolic_potassium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(138.22);

    // rY[18]:
    this->mVariableNames.push_back("Force__N_0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99917);

    // rY[19]:
    this->mVariableNames.push_back("Force__P_0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.8593e-05);

    // rY[20]:
    this->mVariableNames.push_back("Force__P_1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00013331);

    // rY[21]:
    this->mVariableNames.push_back("Force__P_2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00023505);

    // rY[22]:
    this->mVariableNames.push_back("Force__P_3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00015349);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("nanoA_per_millimolar");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("nanoA");

    // mParameters[3]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("microS");

    // mParameters[4]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_reduced_inactivation");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[5]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_shift_inactivation");
    this->mParameterUnits.push_back("millivolt");

    // mParameters[6]:
    this->mParameterNames.push_back("membrane_sodium_calcium_exchanger_current_conductance");
    this->mParameterUnits.push_back("nanoA_per_millimolar4");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_L_type_calcium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_delayed_rectifier_potassium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [3]:
    this->mDerivedQuantityNames.push_back("membrane_fast_sodium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [4]:
    this->mDerivedQuantityNames.push_back("membrane_sodium_calcium_exchanger_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [5]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celliribe_model_2006_without_otherwise_sectionFromCellMLGRL2Opt)

