//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: hund_rudy_2004
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "hund_rudy_2004_a.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellhund_rudy_2004_aFromCellMLGRL2Opt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__cell__stim_amplitude_converted = -15.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__cell__stim_duration = 3.0; // ms
        const double var_chaste_interface__cell__stim_offset = 0; // ms
        const double var_chaste_interface__cell__stim_period = 1000.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__cell__stim_amplitude_converted),
                var_chaste_interface__cell__stim_duration,
                var_chaste_interface__cell__stim_period,
                var_chaste_interface__cell__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellhund_rudy_2004_aFromCellMLGRL2Opt::Cellhund_rudy_2004_aFromCellMLGRL2Opt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                29,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellhund_rudy_2004_aFromCellMLGRL2Opt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 1.0; // (var_ICaL__G_CaL_mult) [dimensionless]
        this->mParameters[1] = 1.0; // (var_INa__G_Na_mult) [dimensionless]
        this->mParameters[2] = 1.0; // (var_IKr__G_Kr_mult) [dimensionless]
    }

    Cellhund_rudy_2004_aFromCellMLGRL2Opt::~Cellhund_rudy_2004_aFromCellMLGRL2Opt()
    {
    }
    
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__Ito2__AA = rY[17];
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        double var_chaste_interface__Na__Na_i = rY[23];
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = rY[24];
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = rY[25];
        // Units: mM; Initial value: 15.59207157178
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        const double var_Environment__tissue = 0; // dimensionless
        const double var_INaCa__ca_i_NaCa = 1.5 * var_chaste_interface__Ca__Ca_i; // mM
        const double var_INaCa__INaCa = 4.5 * (1.8 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.01310255922773 * var_chaste_interface__cell__V) - 2744000.0 * var_INaCa__ca_i_NaCa * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) / ((1.0 + 0.27000000000000002 * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) * (1.0 + 1.5624999999999999e-8 / pow(var_INaCa__ca_i_NaCa, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_INaCa__ca_i_NaCa)); // uA_per_uF
        const double var_INaK__INaK = 0.48423913043478262 / ((1.0 + 100.0 / pow(var_chaste_interface__Na__Na_i, 2)) * (1.0 + 0.1245 * exp(-0.00374358835078 * var_chaste_interface__cell__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.0374358835078 * var_chaste_interface__cell__V))); // uA_per_uF
        const double var_cell__caiont = -2.0 * var_INaCa__INaCa + 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i) + 0.0028824983370005666 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074871767015599999 * var_chaste_interface__cell__V)) * var_chaste_interface__cell__V / (-1.0 + exp(0.074871767015599999 * var_chaste_interface__cell__V)) + ((var_Environment__tissue == 0) ? (3.5108651860830804 * pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V))) : (3.5108651860830804 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] * var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)))); // uA_per_uF
        const double var_cell__clont = 0.00022499999999999999 * var_chaste_interface__cell__V + 0.00601027620873753 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 0.001444800488100033 * (-100.0 * exp(0.0374358835078 * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2__AA * var_chaste_interface__cell__V / (1.0 - exp(0.0374358835078 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_reversal_potentials__EK = 26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_reversal_potentials__ENa = 26.712338705500134 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_cell__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + 0.0064999999999999997 * pow(var_chaste_interface__INal__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * var_chaste_interface__INal__hL + pow(var_chaste_interface__INa__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * ((var_Environment__tissue == 0) ? (8.25) : (33.0)) * mParameters[1] * var_chaste_interface__INa__H * var_chaste_interface__INa__J; // uA_per_uF
        const double var_cell__kiont = -2.0 * var_INaK__INaK + 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)) + 0.51000000000000001 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)) + (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__EK) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__cell__V)))) + (0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.712338705500134 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V) * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2 + 0.013854200000000001 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * mParameters[2] * var_chaste_interface__IKr__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)) + 0.19 * pow(var_chaste_interface__Ito__ydv, 3) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv * exp(0.0033333333333333335 * var_chaste_interface__cell__V); // uA_per_uF
        const double var_chaste_interface__i_ionic = (var_cell__caiont + var_cell__clont + var_cell__kiont + var_cell__naiont) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellhund_rudy_2004_aFromCellMLGRL2Opt::UpdateTransmembranePotential(double var_chaste_interface__Environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__Ito2__AA = rY[17];
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        double var_chaste_interface__Na__Na_i = rY[23];
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = rY[24];
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = rY[25];
        // Units: mM; Initial value: 15.59207157178
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        

        // Mathematics
        double d_dt_chaste_interface_var_cell__V;
        const double var_Environment__tissue = 0; // dimensionless
        const double var_INaCa__ca_i_NaCa = 1.5 * var_chaste_interface__Ca__Ca_i; // mM
        const double var_IpCa__IpCa = 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i); // uA_per_uF
        const double var_ICaL__ibarca = 3.5108651860830804 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double var_ICab__ICab = 0.0028824983370005666 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074871767015599999 * var_chaste_interface__cell__V)) * var_chaste_interface__cell__V / (-1.0 + exp(0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_INaCa__INaCa = 4.5 * (1.8 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.01310255922773 * var_chaste_interface__cell__V) - 2744000.0 * var_INaCa__ca_i_NaCa * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) / ((1.0 + 0.27000000000000002 * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) * (1.0 + 1.5624999999999999e-8 / pow(var_INaCa__ca_i_NaCa, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_INaCa__ca_i_NaCa)); // uA_per_uF
        const double var_INaK__INaK = 0.48423913043478262 / ((1.0 + 100.0 / pow(var_chaste_interface__Na__Na_i, 2)) * (1.0 + 0.1245 * exp(-0.00374358835078 * var_chaste_interface__cell__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.0374358835078 * var_chaste_interface__cell__V))); // uA_per_uF
        const double var_cell__i_Stim = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time) / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_reversal_potentials__ECl = -26.712338705500134 * log(100.0 / var_chaste_interface__Cl__Cl_i); // mV
        const double var_cell__clont = 0.5 * var_cell__i_Stim + 0.00022499999999999999 * var_chaste_interface__cell__V - 0.00022499999999999999 * var_reversal_potentials__ECl + 0.001444800488100033 * (-100.0 * exp(0.0374358835078 * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2__AA * var_chaste_interface__cell__V / (1.0 - exp(0.0374358835078 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_reversal_potentials__EK = 26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_reversal_potentials__ENa = 26.712338705500134 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_cell__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + 0.0064999999999999997 * pow(var_chaste_interface__INal__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * var_chaste_interface__INal__hL + pow(var_chaste_interface__INa__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * ((var_Environment__tissue == 0) ? (8.25) : (33.0)) * mParameters[1] * var_chaste_interface__INa__H * var_chaste_interface__INa__J; // uA_per_uF
        const double var_cell__kiont = 0.5 * var_cell__i_Stim - 2.0 * var_INaK__INaK + 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)) + 0.51000000000000001 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)) + (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__EK) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__cell__V)))) + (0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.712338705500134 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V) * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2 + 0.013854200000000001 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * mParameters[2] * var_chaste_interface__IKr__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)) + 0.19 * pow(var_chaste_interface__Ito__ydv, 3) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv * exp(0.0033333333333333335 * var_chaste_interface__cell__V); // uA_per_uF
        d_dt_chaste_interface_var_cell__V = -var_ICaL__ICaL - var_ICab__ICab - var_IpCa__IpCa - var_cell__clont - var_cell__kiont - var_cell__naiont + 2.0 * var_INaCa__INaCa; // mV / ms

        double evalF = d_dt_chaste_interface_var_cell__V;
        mEvalF[0] = d_dt_chaste_interface_var_cell__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__Environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__Environment__time, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__Environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Cellhund_rudy_2004_aFromCellMLGRL2Opt::ComputeOneStepExceptVoltage(double var_chaste_interface__Environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__Ito2__AA = rY[17];
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        double var_chaste_interface__Irel__CaMKtrap = rY[20];
        // Units: dimensionless; Initial value: 0.021123704774
        double var_chaste_interface__Irel__ro = rY[21];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Irel__ri = rY[22];
        // Units: dimensionless; Initial value: 0.862666650318
        double var_chaste_interface__Na__Na_i = rY[23];
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = rY[24];
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = rY[25];
        // Units: mM; Initial value: 15.59207157178
        double var_chaste_interface__Ca__Ca_jsr = rY[26];
        // Units: mM; Initial value: 1.737580994071
        double var_chaste_interface__Ca__Ca_nsr = rY[27];
        // Units: mM; Initial value: 1.832822335168
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        
        // Mathematics
        double d_dt_chaste_interface_var_cell__V;
        const double var_Environment__tissue = 0; // dimensionless
        const double var_INaCa__ca_i_NaCa = 1.5 * var_chaste_interface__Ca__Ca_i; // mM
        const double var_Idiff_Itr__idiff = 5.0 * var_chaste_interface__Ca__Ca_ss - 5.0 * var_chaste_interface__Ca__Ca_i; // mM_per_ms
        const double var_Idiff_Itr__itr = 0.0083333333333333332 * var_chaste_interface__Ca__Ca_nsr - 0.0083333333333333332 * var_chaste_interface__Ca__Ca_jsr; // mM_per_ms
        const double var_IpCa__IpCa = 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i); // uA_per_uF
        const double var_Irel__CaMKactive = 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap; // dimensionless
        const double d_dt_chaste_interface_var_Irel__CaMKtrap = -0.00068000000000000005 * var_chaste_interface__Irel__CaMKtrap + 0.050000000000000003 * (-var_chaste_interface__Irel__CaMKtrap + var_Irel__CaMKactive) * var_Irel__CaMKactive; // 1 / ms
        const double d_dt_chaste_interface_var_Ito2__AA = 1 / (1.0 + 0.1502 / var_chaste_interface__Ca__Ca_ss) - 1.0 * var_chaste_interface__Ito2__AA; // 1 / ms
        const double var_Iup_Ileak__iup = 0.0043750000000000004 * (1.0 + 0.75 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive)) * var_chaste_interface__Ca__Ca_i / (0.00092000000000000003 - 0.00017000000000000001 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive) + var_chaste_interface__Ca__Ca_i); // mM_per_ms
        const double var_Iup_Ileak__ileak = 0.00029166666666666669 * var_chaste_interface__Ca__Ca_nsr; // mM_per_ms
        const double d_dt_chaste_interface_var_ICaL__dp = 0.90000000000000002 - 0.10000000000000001 * var_chaste_interface__ICaL__dp - 0.80000000000000004 / (1.0 + exp(-19.117647058823529 - 0.29411764705882354 * var_chaste_interface__cell__V)); // 1 / ms
        const double var_ICaL__ibarca = 3.5108651860830804 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double d_dt_chaste_interface_var_ICaL__fca = (0.14999999999999999 - var_chaste_interface__ICaL__fca + 0.55000000000000004 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss) + 0.29999999999999999 / (1.0 - 20.0 * var_ICaL__ICaL)) / (0.5 + 1 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss) + 10.0 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive)); // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__d = (-var_chaste_interface__ICaL__d + 1 / (1.0 + exp(0.59347181008902072 - 0.14836795252225518 * var_chaste_interface__cell__V))) / (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__cell__V) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__cell__V))); // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__f = (0.052900000000000003 + 0.24110000000000001 * exp(-0.19019454876899997 * pow((-1 + 0.10318426646304972 * var_chaste_interface__cell__V), 2))) * (0.29999999999999999 - var_chaste_interface__ICaL__f + 0.69999999999999996 / (1.0 + exp(2.4457142857142857 + 0.14285714285714285 * var_chaste_interface__cell__V))); // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__f2 = (0.0054000000000000003 + 0.042299999999999997 * exp(-1.20074125971556 * pow((-1 + 0.053842757610673787 * var_chaste_interface__cell__V), 2))) * (0.23000000000000001 - var_chaste_interface__ICaL__f2 + 0.77000000000000002 / (1.0 + exp(2.4457142857142857 + 0.14285714285714285 * var_chaste_interface__cell__V))); // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__fca2 = (-var_chaste_interface__ICaL__fca2 + 1 / (1.0 - 100.0 * var_ICaL__ICaL)) / (125.0 + 300.0 / (1.0 + exp(-4.375 - 25.0 * var_ICaL__ICaL))); // 1 / ms
        const double var_ICab__ICab = 0.0028824983370005666 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074871767015599999 * var_chaste_interface__cell__V)) * var_chaste_interface__cell__V / (-1.0 + exp(0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double d_dt_chaste_interface_var_IKr__xr = (-var_chaste_interface__IKr__xr + 1 / (1.0 + exp(-2.3729411764705883 - 0.23529411764705882 * var_chaste_interface__cell__V))) * (0.00029999999999999997 * (38.360799999999998 + var_chaste_interface__cell__V) / (-1.0 + exp(5.8385137599999997 + 0.1522 * var_chaste_interface__cell__V)) + 0.00059999999999999995 * (-1.7383999999999999 + var_chaste_interface__cell__V) / (1.0 - exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__cell__V))); // 1 / ms
        const double var_IKs__tauxs = 1 / (7.6100000000000007e-5 * (44.600000000000001 + var_chaste_interface__cell__V) / (1.0 - exp(-444.66200000000003 - 9.9700000000000006 * var_chaste_interface__cell__V)) + 0.00036000000000000002 * (-0.55000000000000004 + var_chaste_interface__cell__V) / (-1.0 + exp(-0.070400000000000004 + 0.128 * var_chaste_interface__cell__V))); // ms
        const double var_IKs__xss = 1 / (1.0 + exp(0.4251012145748988 - 0.04048582995951417 * var_chaste_interface__cell__V)); // dimensionless
        const double d_dt_chaste_interface_var_IKs__xs1 = (-var_chaste_interface__IKs__xs1 + var_IKs__xss) / var_IKs__tauxs; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__xs2 = 0.5 * (-var_chaste_interface__IKs__xs2 + var_IKs__xss) / var_IKs__tauxs; // 1 / ms
        const double d_dt_chaste_interface_var_INa__H = (1.0 - var_chaste_interface__INa__H) * ((var_chaste_interface__cell__V >= -40.0) ? (0) : (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V))) - ((var_chaste_interface__cell__V >= -40.0) ? (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V))) : (310000.0 * exp(0.34999999999999998 * var_chaste_interface__cell__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__cell__V))) * var_chaste_interface__INa__H; // 1 / ms
        const double d_dt_chaste_interface_var_INa__J = (1.0 - var_chaste_interface__INa__J) * ((var_chaste_interface__cell__V >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__cell__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__cell__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__cell__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V)))) - ((var_chaste_interface__cell__V >= -40.0) ? (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__V))) : (0.1212 * exp(-0.01052 * var_chaste_interface__cell__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V)))) * var_chaste_interface__INa__J; // 1 / ms
        const double d_dt_chaste_interface_var_INa__m = -0.080000000000000002 * var_chaste_interface__INa__m * exp(-0.090909090909090912 * var_chaste_interface__cell__V) + 0.32000000000000001 * (1.0 - var_chaste_interface__INa__m) * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V)); // 1 / ms
        const double var_INaCa__INaCa = 4.5 * (1.8 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.01310255922773 * var_chaste_interface__cell__V) - 2744000.0 * var_INaCa__ca_i_NaCa * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) / ((1.0 + 0.27000000000000002 * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) * (1.0 + 1.5624999999999999e-8 / pow(var_INaCa__ca_i_NaCa, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_INaCa__ca_i_NaCa)); // uA_per_uF
        const double var_INaK__INaK = 0.48423913043478262 / ((1.0 + 100.0 / pow(var_chaste_interface__Na__Na_i, 2)) * (1.0 + 0.1245 * exp(-0.00374358835078 * var_chaste_interface__cell__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.0374358835078 * var_chaste_interface__cell__V))); // uA_per_uF
        const double d_dt_chaste_interface_var_INal__mL = -0.080000000000000002 * var_chaste_interface__INal__mL * exp(-0.090909090909090912 * var_chaste_interface__cell__V) + 0.32000000000000001 * (1.0 - var_chaste_interface__INal__mL) * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V)); // 1 / ms
        const double d_dt_chaste_interface_var_INal__hL = 0.0016666666666666668 / (1.0 + exp(14.918032786885247 + 0.16393442622950821 * var_chaste_interface__cell__V)) - 0.0016666666666666668 * var_chaste_interface__INal__hL; // 1 / ms
        const double var_Irel__cafac = 1 / (1.0 + exp(3.3333333333333335 + 66.666666666666671 * var_ICaL__ICaL)); // dimensionless
        const double d_dt_chaste_interface_var_Irel__ro = -0.33333333333333331 * var_chaste_interface__Irel__ro + 0.33333333333333331 * pow(var_chaste_interface__Ca__Ca_jsr, 1.8999999999999999) / ((1.0 + 1 / pow(var_ICaL__ICaL, 2)) * (pow(var_chaste_interface__Ca__Ca_jsr, 1.8999999999999999) + 1644.6531773416521 * pow((var_chaste_interface__Ca__Ca_ss / (0.0028 + var_chaste_interface__Ca__Ca_ss)), 1.8999999999999999))); // 1 / ms
        const double d_dt_chaste_interface_var_Irel__ri = (-var_chaste_interface__Irel__ri + 1 / (1.0 + exp(-16.0 + 80.0 * var_Irel__cafac + 40000.0 * var_chaste_interface__Ca__Ca_ss))) / (3.0 + (350.0 - 10.0 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive)) / (1.0 + exp(-15.0 + 5000.0 * var_chaste_interface__Ca__Ca_ss + 15.0 * var_Irel__cafac)) + 10.0 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive)); // 1 / ms
        const double var_Irel__irelcicr = 3000.0 * (-var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_jsr) * ((var_Environment__tissue == 0) ? (1 / (1.0 + exp(2.6000000000000001 + 0.20000000000000001 * var_ICaL__ibarca))) : (1.0)) * var_chaste_interface__Irel__ri * var_chaste_interface__Irel__ro; // mM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_jsr = (-var_Irel__irelcicr + var_Idiff_Itr__itr) / (1.0 + 8.0 / pow((0.80000000000000004 + var_chaste_interface__Ca__Ca_jsr), 2)); // mM / ms
        const double d_dt_chaste_interface_var_Ito__ydv = 25.0 * (1.0 - var_chaste_interface__Ito__ydv) * exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__cell__V)) - 25.0 * var_chaste_interface__Ito__ydv * exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__cell__V)); // 1 / ms
        const double d_dt_chaste_interface_var_Ito__ydv2 = 0.029999999999999999 * (1.0 - var_chaste_interface__Ito__ydv2) / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__cell__V)) - 0.20000000000000001 * var_chaste_interface__Ito__ydv2 * exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V)); // 1 / ms
        const double d_dt_chaste_interface_var_Ito__zdv = 0.0022499999999999998 * (1.0 - var_chaste_interface__Ito__zdv) / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__cell__V)) - 0.10000000000000001 * var_chaste_interface__Ito__zdv * exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V)); // 1 / ms
        const double var_cell__i_Stim = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time) / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_cell__AF = 5.0619267243613002e-10 * M_PI; // uF_mole_per_C
        const double var_cell__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell__vjsr = 0.0047999999999999996 * var_cell__vcell; // uL
        const double var_cell__vmyo = 0.68000000000000005 * var_cell__vcell; // uL
        const double var_cell__vnsr = 0.055199999999999999 * var_cell__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_nsr = -var_Iup_Ileak__ileak - var_Idiff_Itr__itr * var_cell__vjsr / var_cell__vnsr + var_Iup_Ileak__iup; // mM / ms
        const double var_cell__vss = 0.02 * var_cell__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_i = ((-var_Iup_Ileak__iup + var_Iup_Ileak__ileak) * var_cell__vnsr / var_cell__vmyo + var_Idiff_Itr__idiff * var_cell__vss / var_cell__vmyo + 0.5 * (-var_ICab__ICab - var_IpCa__IpCa + 2.0 * var_INaCa__INaCa) * var_cell__AF / var_cell__vmyo) / (1.0 + 0.00011900000000000002 / pow((0.0023800000000000002 + var_chaste_interface__Ca__Ca_i), 2) + 3.5000000000000004e-5 / pow((0.00050000000000000001 + var_chaste_interface__Ca__Ca_i), 2)); // mM / ms
        const double d_dt_chaste_interface_var_Ca__Ca_ss = (-var_Idiff_Itr__idiff + var_Irel__irelcicr * var_cell__vjsr / var_cell__vss - 0.5 * var_ICaL__ICaL * var_cell__AF / var_cell__vss) / (1.0 + 0.0097788000000000007 / pow((0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss), 2) + 4.0890000000000003e-5 / pow((0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss), 2)); // mM / ms
        const double var_reversal_potentials__ECl = -26.712338705500134 * log(100.0 / var_chaste_interface__Cl__Cl_i); // mV
        const double var_cell__clont = 0.5 * var_cell__i_Stim + 0.00022499999999999999 * var_chaste_interface__cell__V - 0.00022499999999999999 * var_reversal_potentials__ECl + 0.001444800488100033 * (-100.0 * exp(0.0374358835078 * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2__AA * var_chaste_interface__cell__V / (1.0 - exp(0.0374358835078 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_reversal_potentials__EK = 26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_K__CTKCl = 7.0755999999999996e-6 * (-var_reversal_potentials__ECl + var_reversal_potentials__EK) / (87.825100000000006 - var_reversal_potentials__ECl + var_reversal_potentials__EK); // mM_per_ms
        const double var_reversal_potentials__ENa = 26.712338705500134 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_Na__CTNaCl = 9.8442999999999999e-6 * pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4) / (59494197.640692554 + pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4)); // mM_per_ms
        const double d_dt_chaste_interface_var_Cl__Cl_i = var_cell__AF * var_cell__clont / var_cell__vmyo + var_K__CTKCl + var_Na__CTNaCl; // mM / ms
        const double var_cell__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + 0.0064999999999999997 * pow(var_chaste_interface__INal__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * var_chaste_interface__INal__hL + pow(var_chaste_interface__INa__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * ((var_Environment__tissue == 0) ? (8.25) : (33.0)) * mParameters[1] * var_chaste_interface__INa__H * var_chaste_interface__INa__J; // uA_per_uF
        const double d_dt_chaste_interface_var_Na__Na_i = -var_cell__AF * var_cell__naiont / var_cell__vmyo + var_Na__CTNaCl; // mM / ms
        const double var_cell__kiont = 0.5 * var_cell__i_Stim - 2.0 * var_INaK__INaK + 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)) + 0.51000000000000001 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)) + (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__EK) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__cell__V)))) + (0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.712338705500134 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V) * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2 + 0.013854200000000001 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * mParameters[2] * var_chaste_interface__IKr__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)) + 0.19 * pow(var_chaste_interface__Ito__ydv, 3) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv * exp(0.0033333333333333335 * var_chaste_interface__cell__V); // uA_per_uF
        const double d_dt_chaste_interface_var_K__K_i = -var_cell__AF * var_cell__kiont / var_cell__vmyo + var_K__CTKCl; // mM / ms

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_cell__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_cell__V = -var_ICaL__ICaL - var_ICab__ICab - var_IpCa__IpCa - var_cell__clont - var_cell__kiont - var_cell__naiont + 2.0 * var_INaCa__INaCa; // mV / ms
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_cell__V;
        mEvalF[1] = d_dt_chaste_interface_var_Ca__Ca_i;
        mEvalF[2] = d_dt_chaste_interface_var_INa__H;
        mEvalF[3] = d_dt_chaste_interface_var_INa__m;
        mEvalF[4] = d_dt_chaste_interface_var_INa__J;
        mEvalF[5] = d_dt_chaste_interface_var_ICaL__d;
        mEvalF[6] = d_dt_chaste_interface_var_ICaL__dp;
        mEvalF[7] = d_dt_chaste_interface_var_ICaL__f;
        mEvalF[8] = d_dt_chaste_interface_var_ICaL__fca;
        mEvalF[9] = d_dt_chaste_interface_var_ICaL__fca2;
        mEvalF[10] = d_dt_chaste_interface_var_ICaL__f2;
        mEvalF[11] = d_dt_chaste_interface_var_IKr__xr;
        mEvalF[12] = d_dt_chaste_interface_var_IKs__xs1;
        mEvalF[13] = d_dt_chaste_interface_var_IKs__xs2;
        mEvalF[14] = d_dt_chaste_interface_var_Ito__ydv;
        mEvalF[15] = d_dt_chaste_interface_var_Ito__ydv2;
        mEvalF[16] = d_dt_chaste_interface_var_Ito__zdv;
        mEvalF[17] = d_dt_chaste_interface_var_Ito2__AA;
        mEvalF[18] = d_dt_chaste_interface_var_INal__mL;
        mEvalF[19] = d_dt_chaste_interface_var_INal__hL;
        mEvalF[20] = d_dt_chaste_interface_var_Irel__CaMKtrap;
        mEvalF[21] = d_dt_chaste_interface_var_Irel__ro;
        mEvalF[22] = d_dt_chaste_interface_var_Irel__ri;
        mEvalF[23] = d_dt_chaste_interface_var_Na__Na_i;
        mEvalF[24] = d_dt_chaste_interface_var_K__K_i;
        mEvalF[25] = d_dt_chaste_interface_var_Cl__Cl_i;
        mEvalF[26] = d_dt_chaste_interface_var_Ca__Ca_jsr;
        mEvalF[27] = d_dt_chaste_interface_var_Ca__Ca_nsr;
        mEvalF[28] = d_dt_chaste_interface_var_Ca__Ca_ss;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__Environment__time, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__Environment__time, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__Environment__time, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__Environment__time, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__Environment__time, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__Environment__time, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__Environment__time, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__Environment__time, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__Environment__time, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__Environment__time, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__Environment__time, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__Environment__time, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__Environment__time, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__Environment__time, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__Environment__time, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__Environment__time, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__Environment__time, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__Environment__time, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__Environment__time, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__Environment__time, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__Environment__time, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__Environment__time, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__Environment__time, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__Environment__time, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__Environment__time, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__Environment__time, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__Environment__time, rY, delta);
        rY[13] = y_save;
        
        
        y_save = rY[14];
        rY[14] = mYInit[14];
        mEvalF[14] = EvaluateYDerivative14(var_chaste_interface__Environment__time, rY);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__Environment__time, rY, delta);
        rY[14] = y_save;
        
        
        y_save = rY[15];
        rY[15] = mYInit[15];
        mEvalF[15] = EvaluateYDerivative15(var_chaste_interface__Environment__time, rY);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__Environment__time, rY, delta);
        rY[15] = y_save;
        
        
        y_save = rY[16];
        rY[16] = mYInit[16];
        mEvalF[16] = EvaluateYDerivative16(var_chaste_interface__Environment__time, rY);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__Environment__time, rY, delta);
        rY[16] = y_save;
        
        
        y_save = rY[17];
        rY[17] = mYInit[17];
        mEvalF[17] = EvaluateYDerivative17(var_chaste_interface__Environment__time, rY);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__Environment__time, rY, delta);
        rY[17] = y_save;
        
        
        y_save = rY[18];
        rY[18] = mYInit[18];
        mEvalF[18] = EvaluateYDerivative18(var_chaste_interface__Environment__time, rY);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__Environment__time, rY, delta);
        rY[18] = y_save;
        
        
        y_save = rY[19];
        rY[19] = mYInit[19];
        mEvalF[19] = EvaluateYDerivative19(var_chaste_interface__Environment__time, rY);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__Environment__time, rY, delta);
        rY[19] = y_save;
        
        
        y_save = rY[20];
        rY[20] = mYInit[20];
        mEvalF[20] = EvaluateYDerivative20(var_chaste_interface__Environment__time, rY);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__Environment__time, rY, delta);
        rY[20] = y_save;
        
        
        y_save = rY[21];
        rY[21] = mYInit[21];
        mEvalF[21] = EvaluateYDerivative21(var_chaste_interface__Environment__time, rY);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__Environment__time, rY, delta);
        rY[21] = y_save;
        
        
        y_save = rY[22];
        rY[22] = mYInit[22];
        mEvalF[22] = EvaluateYDerivative22(var_chaste_interface__Environment__time, rY);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__Environment__time, rY, delta);
        rY[22] = y_save;
        
        
        y_save = rY[23];
        rY[23] = mYInit[23];
        mEvalF[23] = EvaluateYDerivative23(var_chaste_interface__Environment__time, rY);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__Environment__time, rY, delta);
        rY[23] = y_save;
        
        
        y_save = rY[24];
        rY[24] = mYInit[24];
        mEvalF[24] = EvaluateYDerivative24(var_chaste_interface__Environment__time, rY);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__Environment__time, rY, delta);
        rY[24] = y_save;
        
        
        y_save = rY[25];
        rY[25] = mYInit[25];
        mEvalF[25] = EvaluateYDerivative25(var_chaste_interface__Environment__time, rY);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__Environment__time, rY, delta);
        rY[25] = y_save;
        
        
        y_save = rY[26];
        rY[26] = mYInit[26];
        mEvalF[26] = EvaluateYDerivative26(var_chaste_interface__Environment__time, rY);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__Environment__time, rY, delta);
        rY[26] = y_save;
        
        
        y_save = rY[27];
        rY[27] = mYInit[27];
        mEvalF[27] = EvaluateYDerivative27(var_chaste_interface__Environment__time, rY);
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__Environment__time, rY, delta);
        rY[27] = y_save;
        
        
        y_save = rY[28];
        rY[28] = mYInit[28];
        mEvalF[28] = EvaluateYDerivative28(var_chaste_interface__Environment__time, rY);
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__Environment__time, rY, delta);
        rY[28] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative0(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_cell__V;
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__Ito2__AA = rY[17];
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        double var_chaste_interface__Na__Na_i = rY[23];
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = rY[24];
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = rY[25];
        // Units: mM; Initial value: 15.59207157178
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        
        // Mathematics
        const double var_Environment__tissue = 0; // dimensionless
        const double var_INaCa__ca_i_NaCa = 1.5 * var_chaste_interface__Ca__Ca_i; // mM
        const double var_IpCa__IpCa = 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i); // uA_per_uF
        const double var_ICaL__ibarca = 3.5108651860830804 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double var_ICab__ICab = 0.0028824983370005666 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074871767015599999 * var_chaste_interface__cell__V)) * var_chaste_interface__cell__V / (-1.0 + exp(0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_INaCa__INaCa = 4.5 * (1.8 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.01310255922773 * var_chaste_interface__cell__V) - 2744000.0 * var_INaCa__ca_i_NaCa * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) / ((1.0 + 0.27000000000000002 * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) * (1.0 + 1.5624999999999999e-8 / pow(var_INaCa__ca_i_NaCa, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_INaCa__ca_i_NaCa)); // uA_per_uF
        const double var_INaK__INaK = 0.48423913043478262 / ((1.0 + 100.0 / pow(var_chaste_interface__Na__Na_i, 2)) * (1.0 + 0.1245 * exp(-0.00374358835078 * var_chaste_interface__cell__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.0374358835078 * var_chaste_interface__cell__V))); // uA_per_uF
        const double var_cell__i_Stim = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time) / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_reversal_potentials__ECl = -26.712338705500134 * log(100.0 / var_chaste_interface__Cl__Cl_i); // mV
        const double var_cell__clont = 0.5 * var_cell__i_Stim + 0.00022499999999999999 * var_chaste_interface__cell__V - 0.00022499999999999999 * var_reversal_potentials__ECl + 0.001444800488100033 * (-100.0 * exp(0.0374358835078 * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2__AA * var_chaste_interface__cell__V / (1.0 - exp(0.0374358835078 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_reversal_potentials__EK = 26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_reversal_potentials__ENa = 26.712338705500134 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_cell__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + 0.0064999999999999997 * pow(var_chaste_interface__INal__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * var_chaste_interface__INal__hL + pow(var_chaste_interface__INa__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * ((var_Environment__tissue == 0) ? (8.25) : (33.0)) * mParameters[1] * var_chaste_interface__INa__H * var_chaste_interface__INa__J; // uA_per_uF
        const double var_cell__kiont = 0.5 * var_cell__i_Stim - 2.0 * var_INaK__INaK + 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)) + 0.51000000000000001 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)) + (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__EK) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__cell__V)))) + (0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.712338705500134 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V) * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2 + 0.013854200000000001 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * mParameters[2] * var_chaste_interface__IKr__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)) + 0.19 * pow(var_chaste_interface__Ito__ydv, 3) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv * exp(0.0033333333333333335 * var_chaste_interface__cell__V); // uA_per_uF
        d_dt_chaste_interface_var_cell__V = -var_ICaL__ICaL - var_ICab__ICab - var_IpCa__IpCa - var_cell__clont - var_cell__kiont - var_cell__naiont + 2.0 * var_INaCa__INaCa; // mV / ms

        return d_dt_chaste_interface_var_cell__V;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative0(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            double var_chaste_interface__Ca__Ca_i = rY[1];
            // Units: mM; Initial value: 0.00012131666
            double var_chaste_interface__INa__H = rY[2];
            // Units: dimensionless; Initial value: 0.987317750543
            double var_chaste_interface__INa__m = rY[3];
            // Units: dimensionless; Initial value: 0.001356538159
            double var_chaste_interface__INa__J = rY[4];
            // Units: dimensionless; Initial value: 0.991924983076
            double var_chaste_interface__ICaL__d = rY[5];
            // Units: dimensionless; Initial value: 1.64013e-06
            double var_chaste_interface__ICaL__dp = rY[6];
            // Units: dimensionless; Initial value: 8.98230672628
            double var_chaste_interface__ICaL__f = rY[7];
            // Units: dimensionless; Initial value: 0.999961508634
            double var_chaste_interface__ICaL__fca = rY[8];
            // Units: dimensionless; Initial value: 0.97836624923
            double var_chaste_interface__ICaL__fca2 = rY[9];
            // Units: dimensionless; Initial value: 0.893052931249
            double var_chaste_interface__ICaL__f2 = rY[10];
            // Units: dimensionless; Initial value: 0.992234519148
            double var_chaste_interface__IKr__xr = rY[11];
            // Units: dimensionless; Initial value: 7.24074e-06
            double var_chaste_interface__IKs__xs1 = rY[12];
            // Units: dimensionless; Initial value: 0.019883138161
            double var_chaste_interface__IKs__xs2 = rY[13];
            // Units: dimensionless; Initial value: 0.019890650554
            double var_chaste_interface__Ito__ydv = rY[14];
            // Units: dimensionless; Initial value: 0.013970786703
            double var_chaste_interface__Ito__ydv2 = rY[15];
            // Units: dimensionless; Initial value: 0.99996472752
            double var_chaste_interface__Ito__zdv = rY[16];
            // Units: dimensionless; Initial value: 0.829206149767
            double var_chaste_interface__Ito2__AA = rY[17];
            // Units: dimensionless; Initial value: 0.000816605172
            double var_chaste_interface__INal__mL = rY[18];
            // Units: dimensionless; Initial value: 0.001356538159
            double var_chaste_interface__INal__hL = rY[19];
            // Units: dimensionless; Initial value: 0.26130711759
            double var_chaste_interface__Na__Na_i = rY[23];
            // Units: mM; Initial value: 12.972433387269
            double var_chaste_interface__K__K_i = rY[24];
            // Units: mM; Initial value: 135.469546216758
            double var_chaste_interface__Cl__Cl_i = rY[25];
            // Units: mM; Initial value: 15.59207157178
            double var_chaste_interface__Ca__Ca_ss = rY[28];
            // Units: mM; Initial value: 0.00012271265
            
            const double var_x0 = exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V);
            const double var_x1 = 1.0 + var_x0;
            const double var_x2 = 1 / var_x1;
            const double var_x3 = pow(var_chaste_interface__INal__mL, 3);
            const double var_x4 = 0.0064999999999999997 * var_x3;
            const double var_x5 = 0.074871767015599999 * var_chaste_interface__cell__V;
            const double var_x6 = exp(var_x5);
            const double var_x7 = -1.0 + var_x6;
            const double var_x8 = 1 / var_x7;
            const double var_x9 = var_x6 * var_chaste_interface__Ca__Ca_i;
            const double var_x10 = -0.61380000000000001 + var_x9;
            const double var_x11 = var_x10 * var_x8;
            const double var_x12 = 1 / var_chaste_interface__K__K_i;
            const double var_x13 = log(5.4000000000000004 * var_x12);
            const double var_x14 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 6.370892781261781 * var_x13);
            const double var_x15 = 1.0 + var_x14;
            const double var_x16 = 1 / var_x15;
            const double var_x17 = exp(-2.4444678999999998 + 13.738155796238718 * var_x13 - 0.51429999999999998 * var_chaste_interface__cell__V);
            const double var_x18 = 1.0 + var_x17;
            const double var_x19 = 1 / var_x18;
            const double var_x20 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 1.6494869150646332 * var_x13);
            const double var_x21 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 2.1455350448257708 * var_x13);
            const double var_x22 = var_x20 + 0.49124000000000001 * var_x21;
            const double var_x23 = var_x19 * var_x22;
            const double var_x24 = 1 / (var_x23 + 1.02 * var_x16);
            const double var_x25 = var_x16 * var_x24;
            const double var_x26 = 1 / var_chaste_interface__Ca__Ca_i;
            const double var_x27 = pow(var_x26, 1.3999999999999999);
            const double var_x28 = 1.0 + 6.4818210260626455e-7 * var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x30 = -0.024897499999999999 - 0.014938499999999999 * var_x29;
            const double var_x31 = var_x30 * var_chaste_interface__IKs__xs2;
            const double var_x32 = var_x31 * var_chaste_interface__IKs__xs1;
            const double var_x33 = exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V);
            const double var_x34 = 1.0 + var_x33;
            const double var_x35 = mParameters[2] / var_x34;
            const double var_x36 = 0.013854200000000001 * var_x35;
            const double var_x37 = 0.0374358835078 * var_chaste_interface__cell__V;
            const double var_x38 = exp(var_x37);
            const double var_x39 = 1.0 - var_x38;
            const double var_x40 = 1 / var_x39;
            const double var_x41 = -100.0 * var_x38 + var_chaste_interface__Cl__Cl_i;
            const double var_x42 = var_x40 * var_x41;
            const double var_x43 = 0.001444800488100033 * var_x42;
            const double var_x44 = pow(var_chaste_interface__Na__Na_i, 2);
            const double var_x45 = 1 / var_x44;
            const double var_x46 = exp(-0.00374358835078 * var_chaste_interface__cell__V);
            const double var_x47 = exp(2.0802377414561666);
            const double var_x48 = exp(-var_x37);
            const double var_x49 = 1.0 + 0.1245 * var_x46 + 0.036499999999999998 * var_x48 * (-0.14285714285714285 + 0.14285714285714285 * var_x47);
            const double var_x50 = (0.00046607674967211004 * var_x46 + 0.0374358835078 * var_x48 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x47)) / (pow(var_x49, 2) * (1.0 + 100.0 * var_x45));
            const double var_x51 = 26.712338705500134 * var_x13;
            const double var_x52 = -var_x51 + var_chaste_interface__cell__V;
            const double var_x53 = var_x0 * var_x52 / pow(var_x1, 2);
            const double var_x54 = var_x6 * var_chaste_interface__cell__V;
            const double var_x55 = var_x10 * var_x54 / pow(var_x7, 2);
            const double var_x56 = var_chaste_interface__Ito2__AA * var_chaste_interface__cell__V;
            const double var_x57 = var_x40 * var_x56;
            const double var_x58 = var_x38 * var_x57;
            const double var_x59 = var_x14 / pow(var_x15, 2);
            const double var_x60 = var_x24 * var_x52;
            const double var_x61 = var_x59 * var_x60;
            const double var_x62 = pow(var_chaste_interface__Na__Na_i, 3);
            const double var_x63 = exp(0.01310255922773 * var_chaste_interface__cell__V);
            const double var_x64 = var_x62 * var_x63;
            const double var_x65 = exp(-0.024333324280070002 * var_chaste_interface__cell__V);
            const double var_x66 = var_x65 * var_chaste_interface__Ca__Ca_i;
            const double var_x67 = 1 / (13227.9606 + 6516533.0625 * var_chaste_interface__Ca__Ca_i + 8.4084932990912282 * var_x62);
            const double var_x68 = 1.0 + 0.27000000000000002 * var_x65;
            const double var_x69 = 1 / var_x68;
            const double var_x70 = 1.0 + 6.9444444444444451e-9 / pow(var_chaste_interface__Ca__Ca_i, 2);
            const double var_x71 = 1 / var_x70;
            const double var_x72 = var_x69 * var_x71;
            const double var_x73 = var_x67 * var_x72;
            const double var_x74 = var_x73 * (0.023584606609913999 * var_x64 + 100155.96273676812 * var_x66);
            const double var_x75 = pow(var_chaste_interface__INa__m, 3);
            const double var_x76 = var_x75 * mParameters[1] * var_chaste_interface__INa__J;
            const double var_x77 = 8.25 * var_x76;
            const double var_x78 = pow(var_chaste_interface__Ito__ydv, 3);
            const double var_x79 = exp(0.0033333333333333335 * var_chaste_interface__cell__V);
            const double var_x80 = var_x78 * var_x79 * var_chaste_interface__Ito__zdv;
            const double var_x81 = 0.19 * var_x80;
            const double var_x82 = var_x8 * var_x9 * var_chaste_interface__cell__V;
            const double var_x83 = var_x17 * var_x22 / pow(var_x18, 2);
            const double var_x84 = 0.24326999999999999 * var_x59 - 0.51429999999999998 * var_x83 - var_x19 * (0.061749999999999999 * var_x20 + 0.039456396800000001 * var_x21);
            const double var_x85 = var_x16 * var_x52 / pow((var_x16 + 0.98039215686274506 * var_x23), 2);
            const double var_x86 = 0.49019607843137253 * var_x85;
            const double var_x87 = var_x33 * var_x52 * mParameters[2] * var_chaste_interface__IKr__xr / pow(var_x34, 2);
            const double var_x88 = var_x38 * var_x41 * var_x56 / pow(var_x39, 2);
            const double var_x89 = var_x52 * var_chaste_interface__Ito__ydv2;
            const double var_x90 = var_x80 * var_x89;
            const double var_x91 = 1.8 * var_x64 - 4116000.0 * var_x66;
            const double var_x92 = var_x67 * var_x91;
            const double var_x93 = var_x65 * var_x71 * var_x92 / pow(var_x68, 2);
            const double var_x94 = pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp);
            const double var_x95 = exp(-1.1230765052339999 + var_x5);
            const double var_x96 = var_x95 * var_chaste_interface__Ca__Ca_ss;
            const double var_x97 = -0.61380000000000001 + var_x96;
            const double var_x98 = -1.0 + var_x95;
            const double var_x99 = mParameters[0] / var_x98;
            const double var_x100 = var_x97 * var_x99;
            const double var_x101 = var_x100 * var_x94 * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca2;
            const double var_x102 = 3.5108651860830804 * var_chaste_interface__ICaL__fca;
            const double var_x103 = var_x101 * var_x102;
            const double var_x104 = pow(var_x98, 2);
            const double var_x105 = var_x95 * var_x97 * mParameters[0] / var_x104;
            const double var_x106 = -15.0 + var_chaste_interface__cell__V;
            const double var_x107 = var_x106 * var_x94 * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__fca2;
            const double var_x108 = var_x107 * var_chaste_interface__ICaL__fca;
            const double var_x109 = var_x108 * var_chaste_interface__ICaL__f2;
            const double var_x110 = 0.26286468023559356 * var_x109;
            const double var_x111 = var_x96 * var_x99;
            
            partialF = -0.00022499999999999999 + var_x32 - var_x103 + 0.00021581774391076088 * var_x55 + 0.00089962337662337659 * var_x87 + 0.005408738276452542 * var_x58 + 0.12163499999999999 * var_x61 - 4.5 * var_x74 - 0.0027599999999999999 * var_x2 - 0.00021581774391076088 * var_x82 - 5.4087382764525417e-5 * var_x88 - 0.0028824983370005666 * var_x11 - 0.48423913043478262 * var_x50 - 0.51000000000000001 * var_x25 - 0.0006333333333333333 * var_x90 - 0.00046153846153846147 * var_x53 - 0.029564989000285053 * var_x93 + var_x105 * var_x110 - var_x110 * var_x111 - var_x36 * var_chaste_interface__IKr__xr - var_x4 * var_chaste_interface__INal__hL - var_x43 * var_chaste_interface__Ito2__AA - var_x77 * var_chaste_interface__INa__H - var_x81 * var_chaste_interface__Ito__ydv2 - var_x84 * var_x86;
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative1(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__Irel__CaMKtrap = rY[20];
        // Units: dimensionless; Initial value: 0.021123704774
        double var_chaste_interface__Na__Na_i = rY[23];
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__Ca__Ca_nsr = rY[27];
        // Units: mM; Initial value: 1.832822335168
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        
        // Mathematics
        const double var_INaCa__ca_i_NaCa = 1.5 * var_chaste_interface__Ca__Ca_i; // mM
        const double var_Idiff_Itr__idiff = 5.0 * var_chaste_interface__Ca__Ca_ss - 5.0 * var_chaste_interface__Ca__Ca_i; // mM_per_ms
        const double var_IpCa__IpCa = 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i); // uA_per_uF
        const double var_Irel__CaMKactive = 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap; // dimensionless
        const double var_Iup_Ileak__iup = 0.0043750000000000004 * (1.0 + 0.75 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive)) * var_chaste_interface__Ca__Ca_i / (0.00092000000000000003 - 0.00017000000000000001 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive) + var_chaste_interface__Ca__Ca_i); // mM_per_ms
        const double var_Iup_Ileak__ileak = 0.00029166666666666669 * var_chaste_interface__Ca__Ca_nsr; // mM_per_ms
        const double var_ICab__ICab = 0.0028824983370005666 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074871767015599999 * var_chaste_interface__cell__V)) * var_chaste_interface__cell__V / (-1.0 + exp(0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_INaCa__INaCa = 4.5 * (1.8 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.01310255922773 * var_chaste_interface__cell__V) - 2744000.0 * var_INaCa__ca_i_NaCa * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) / ((1.0 + 0.27000000000000002 * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) * (1.0 + 1.5624999999999999e-8 / pow(var_INaCa__ca_i_NaCa, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_INaCa__ca_i_NaCa)); // uA_per_uF
        const double var_cell__AF = 5.0619267243613002e-10 * M_PI; // uF_mole_per_C
        const double var_cell__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell__vmyo = 0.68000000000000005 * var_cell__vcell; // uL
        const double var_cell__vnsr = 0.055199999999999999 * var_cell__vcell; // uL
        const double var_cell__vss = 0.02 * var_cell__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_i = ((-var_Iup_Ileak__iup + var_Iup_Ileak__ileak) * var_cell__vnsr / var_cell__vmyo + var_Idiff_Itr__idiff * var_cell__vss / var_cell__vmyo + 0.5 * (-var_ICab__ICab - var_IpCa__IpCa + 2.0 * var_INaCa__INaCa) * var_cell__AF / var_cell__vmyo) / (1.0 + 0.00011900000000000002 / pow((0.0023800000000000002 + var_chaste_interface__Ca__Ca_i), 2) + 3.5000000000000004e-5 / pow((0.00050000000000000001 + var_chaste_interface__Ca__Ca_i), 2)); // mM / ms

        return d_dt_chaste_interface_var_Ca__Ca_i;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative1(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            double var_chaste_interface__Ca__Ca_i = rY[1];
            // Units: mM; Initial value: 0.00012131666
            double var_chaste_interface__Irel__CaMKtrap = rY[20];
            // Units: dimensionless; Initial value: 0.021123704774
            double var_chaste_interface__Na__Na_i = rY[23];
            // Units: mM; Initial value: 12.972433387269
            double var_chaste_interface__Ca__Ca_nsr = rY[27];
            // Units: mM; Initial value: 1.832822335168
            double var_chaste_interface__Ca__Ca_ss = rY[28];
            // Units: mM; Initial value: 0.00012271265
            
            const double var_x5 = 0.074871767015599999 * var_chaste_interface__cell__V;
            const double var_x6 = exp(var_x5);
            const double var_x7 = -1.0 + var_x6;
            const double var_x8 = 1 / var_x7;
            const double var_x9 = var_x6 * var_chaste_interface__Ca__Ca_i;
            const double var_x10 = -0.61380000000000001 + var_x9;
            const double var_x11 = var_x10 * var_x8;
            const double var_x54 = var_x6 * var_chaste_interface__cell__V;
            const double var_x62 = pow(var_chaste_interface__Na__Na_i, 3);
            const double var_x63 = exp(0.01310255922773 * var_chaste_interface__cell__V);
            const double var_x64 = var_x62 * var_x63;
            const double var_x65 = exp(-0.024333324280070002 * var_chaste_interface__cell__V);
            const double var_x66 = var_x65 * var_chaste_interface__Ca__Ca_i;
            const double var_x67 = 1 / (13227.9606 + 6516533.0625 * var_chaste_interface__Ca__Ca_i + 8.4084932990912282 * var_x62);
            const double var_x68 = 1.0 + 0.27000000000000002 * var_x65;
            const double var_x69 = 1 / var_x68;
            const double var_x70 = 1.0 + 6.9444444444444451e-9 / pow(var_chaste_interface__Ca__Ca_i, 2);
            const double var_x71 = 1 / var_x70;
            const double var_x72 = var_x69 * var_x71;
            const double var_x73 = var_x67 * var_x72;
            const double var_x91 = 1.8 * var_x64 - 4116000.0 * var_x66;
            const double var_x92 = var_x67 * var_x91;
            const double var_x112 = 0.00050000000000000001 + var_chaste_interface__Ca__Ca_i;
            const double var_x113 = 1 / var_x112;
            const double var_x114 = pow(var_x112, (-2));
            const double var_x115 = var_x114 * var_chaste_interface__Ca__Ca_i;
            const double var_x116 = var_x54 * var_x8;
            const double var_x117 = var_x65 * var_x73;
            const double var_x118 = var_x72 * var_x91 / pow((0.0020299076937277489 + 1.2903323313862536e-6 * var_x62 + var_chaste_interface__Ca__Ca_i), 2);
            const double var_x119 = var_x69 * var_x92 / (pow(var_x70, 2) * pow(var_chaste_interface__Ca__Ca_i, 3));
            const double var_x158 = 8.8666719524733664e-8 * var_x11;
            const double var_x159 = 0.0023800000000000002 + var_chaste_interface__Ca__Ca_i;
            const double var_x160 = 1.0 + 0.00011900000000000002 / pow(var_x159, 2) + 3.5000000000000004e-5 * var_x114;
            const double var_x161 = 1 / var_x160;
            const double var_x162 = var_x161;
            const double var_x163 = 1.768721357868101e-6 * var_x113;
            const double var_x164 = 1.0 - var_chaste_interface__Irel__CaMKtrap;
            const double var_x165 = 1 / var_chaste_interface__Ca__Ca_ss;
            const double var_x166 = 1.0 + 0.0015 * var_x165;
            const double var_x167 = 1 / var_x166;
            const double var_x168 = 0.050000000000000003 * var_x167;
            const double var_x169 = var_x164 * var_x168 + var_chaste_interface__Irel__CaMKtrap;
            const double var_x170 = 0.14999999999999999 + var_x169;
            const double var_x171 = 1 / var_x170;
            const double var_x172 = var_x169 * var_x171;
            const double var_x173 = 0.00092000000000000003 - 0.00017000000000000001 * var_x172 + var_chaste_interface__Ca__Ca_i;
            const double var_x174 = 1 / var_x173;
            const double var_x175 = 1.0 + 0.75 * var_x172;
            const double var_x176 = var_x174 * var_x175;
            const double var_x177 = 0.00035514705882352943 * var_x176;
            const double var_x178 = 0.00035514705882352943 * var_chaste_interface__Ca__Ca_i;
            const double var_x179 = var_x175 / pow(var_x173, 2);
            const double var_x180 = var_x178 * var_x179;
            
            partialF = var_x162 * (-0.14705882352941174 + var_x180 - var_x163 - var_x177 + 3.8450464301480458e-12 * var_x119 + 1.768721357868101e-6 * var_x115 - 1139.4871996672337 * var_x117 - 8.8666719524733664e-8 * var_x116 - 4.2483225407660435e-11 * var_x118) + (0.00023800000000000004 / pow(var_x159, 3) + 7.0000000000000007e-5 / pow(var_x112, 3)) * (0.14705882352941174 * var_chaste_interface__Ca__Ca_ss + 2.3676470588235295e-5 * var_chaste_interface__Ca__Ca_nsr - 0.14705882352941174 * var_chaste_interface__Ca__Ca_i - var_x158 * var_chaste_interface__cell__V - var_x163 * var_chaste_interface__Ca__Ca_i - var_x177 * var_chaste_interface__Ca__Ca_i + 0.00027684334297065928 * var_x73 * var_x91) / pow(var_x160, 2);
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative2(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_INa__H = (1.0 - var_chaste_interface__INa__H) * ((var_chaste_interface__cell__V >= -40.0) ? (0) : (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V))) - ((var_chaste_interface__cell__V >= -40.0) ? (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V))) : (310000.0 * exp(0.34999999999999998 * var_chaste_interface__cell__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__cell__V))) * var_chaste_interface__INa__H; // 1 / ms

        return d_dt_chaste_interface_var_INa__H;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative2(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x194 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V);
            const double var_x195 = 1.0 + var_x194;
            const double var_x196 = var_chaste_interface__cell__V >= -40.0;
            const double var_x197 = exp(0.079000000000000001 * var_chaste_interface__cell__V);
            const double var_x198 = exp(0.34999999999999998 * var_chaste_interface__cell__V);
            const double var_x199 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V);
            
            partialF = ((var_x196) ? (-7.6923076923076916 / var_x195) : (-310000.0 * var_x198 - 0.13500000000000001 * var_x199 - 3.5600000000000001 * var_x197));
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative3(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_INa__m = -0.080000000000000002 * var_chaste_interface__INa__m * exp(-0.090909090909090912 * var_chaste_interface__cell__V) + 0.32000000000000001 * (1.0 - var_chaste_interface__INa__m) * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V)); // 1 / ms

        return d_dt_chaste_interface_var_INa__m;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative3(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x201 = -0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x202 = exp(-4.7130000000000001 + var_x201);
            const double var_x203 = 1.0 - var_x202;
            const double var_x204 = 0.32000000000000001 / var_x203;
            const double var_x205 = exp(-0.090909090909090912 * var_chaste_interface__cell__V);
            const double var_x207 = 47.130000000000003 + var_chaste_interface__cell__V;
            const double var_x209 = -0.080000000000000002 * var_x205 - var_x204 * var_x207;
            
            partialF = var_x209;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative4(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_INa__J = (1.0 - var_chaste_interface__INa__J) * ((var_chaste_interface__cell__V >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__cell__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__cell__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__cell__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V)))) - ((var_chaste_interface__cell__V >= -40.0) ? (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__V))) : (0.1212 * exp(-0.01052 * var_chaste_interface__cell__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V)))) * var_chaste_interface__INa__J; // 1 / ms

        return d_dt_chaste_interface_var_INa__J;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative4(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x196 = var_chaste_interface__cell__V >= -40.0;
            const double var_x201 = -0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x210 = exp(-3.2000000000000002 + var_x201);
            const double var_x211 = 1.0 + var_x210;
            const double var_x212 = exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V);
            const double var_x213 = var_x212 / var_x211;
            const double var_x215 = exp(0.24440000000000001 * var_chaste_interface__cell__V);
            const double var_x216 = exp(-0.043909999999999998 * var_chaste_interface__cell__V);
            const double var_x217 = -127140.0 * var_x215 - 3.4740000000000003e-5 * var_x216;
            const double var_x219 = exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V);
            const double var_x220 = 1.0 + var_x219;
            const double var_x221 = 1 / var_x220;
            const double var_x222 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V);
            const double var_x223 = 1.0 + var_x222;
            const double var_x224 = exp(-0.01052 * var_chaste_interface__cell__V);
            const double var_x225 = var_x224 / var_x223;
            const double var_x226 = 37.780000000000001 + var_chaste_interface__cell__V;
            const double var_x227 = var_x221 * var_x226;
            
            partialF = ((var_x196) ? (-0.29999999999999999 * var_x213) : (-0.1212 * var_x225 - var_x217 * var_x227));
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative5(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_ICaL__d = (-var_chaste_interface__ICaL__d + 1 / (1.0 + exp(0.59347181008902072 - 0.14836795252225518 * var_chaste_interface__cell__V))) / (0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__cell__V) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__cell__V))); // 1 / ms

        return d_dt_chaste_interface_var_ICaL__d;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative5(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x228 = exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__cell__V);
            const double var_x229 = 1.0 + var_x228;
            const double var_x230 = exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__cell__V);
            const double var_x231 = var_x230 / var_x229;
            const double var_x234 = 1 / (0.58999999999999997 + 0.80000000000000004 * var_x231);
            
            partialF = -var_x234;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative6(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_ICaL__dp = 0.90000000000000002 - 0.10000000000000001 * var_chaste_interface__ICaL__dp - 0.80000000000000004 / (1.0 + exp(-19.117647058823529 - 0.29411764705882354 * var_chaste_interface__cell__V)); // 1 / ms

        return d_dt_chaste_interface_var_ICaL__dp;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative6(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.10000000000000001;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative7(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_ICaL__f = (0.052900000000000003 + 0.24110000000000001 * exp(-0.19019454876899997 * pow((-1 + 0.10318426646304972 * var_chaste_interface__cell__V), 2))) * (0.29999999999999999 - var_chaste_interface__ICaL__f + 0.69999999999999996 / (1.0 + exp(2.4457142857142857 + 0.14285714285714285 * var_chaste_interface__cell__V))); // 1 / ms

        return d_dt_chaste_interface_var_ICaL__f;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative7(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x239 = 0.24110000000000001 * exp(-0.19019454876899997 * pow((-1 + 0.10318426646304972 * var_chaste_interface__cell__V), 2));
            
            partialF = -0.052900000000000003 - var_x239;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative8(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__Irel__CaMKtrap = rY[20];
        // Units: dimensionless; Initial value: 0.021123704774
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        
        // Mathematics
        const double var_Environment__tissue = 0; // dimensionless
        const double var_Irel__CaMKactive = 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap; // dimensionless
        const double var_ICaL__ibarca = 3.5108651860830804 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double d_dt_chaste_interface_var_ICaL__fca = (0.14999999999999999 - var_chaste_interface__ICaL__fca + 0.55000000000000004 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss) + 0.29999999999999999 / (1.0 - 20.0 * var_ICaL__ICaL)) / (0.5 + 1 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss) + 10.0 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive)); // 1 / ms

        return d_dt_chaste_interface_var_ICaL__fca;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative8(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            double var_chaste_interface__ICaL__d = rY[5];
            // Units: dimensionless; Initial value: 1.64013e-06
            double var_chaste_interface__ICaL__dp = rY[6];
            // Units: dimensionless; Initial value: 8.98230672628
            double var_chaste_interface__ICaL__f = rY[7];
            // Units: dimensionless; Initial value: 0.999961508634
            double var_chaste_interface__ICaL__fca = rY[8];
            // Units: dimensionless; Initial value: 0.97836624923
            double var_chaste_interface__ICaL__fca2 = rY[9];
            // Units: dimensionless; Initial value: 0.893052931249
            double var_chaste_interface__ICaL__f2 = rY[10];
            // Units: dimensionless; Initial value: 0.992234519148
            double var_chaste_interface__Irel__CaMKtrap = rY[20];
            // Units: dimensionless; Initial value: 0.021123704774
            double var_chaste_interface__Ca__Ca_ss = rY[28];
            // Units: mM; Initial value: 0.00012271265
            
            const double var_x5 = 0.074871767015599999 * var_chaste_interface__cell__V;
            const double var_x94 = pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp);
            const double var_x95 = exp(-1.1230765052339999 + var_x5);
            const double var_x96 = var_x95 * var_chaste_interface__Ca__Ca_ss;
            const double var_x97 = -0.61380000000000001 + var_x96;
            const double var_x98 = -1.0 + var_x95;
            const double var_x99 = mParameters[0] / var_x98;
            const double var_x100 = var_x97 * var_x99;
            const double var_x101 = var_x100 * var_x94 * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca2;
            const double var_x106 = -15.0 + var_chaste_interface__cell__V;
            const double var_x135 = var_x101 * var_x106;
            const double var_x164 = 1.0 - var_chaste_interface__Irel__CaMKtrap;
            const double var_x165 = 1 / var_chaste_interface__Ca__Ca_ss;
            const double var_x166 = 1.0 + 0.0015 * var_x165;
            const double var_x167 = 1 / var_x166;
            const double var_x168 = 0.050000000000000003 * var_x167;
            const double var_x169 = var_x164 * var_x168 + var_chaste_interface__Irel__CaMKtrap;
            const double var_x170 = 0.14999999999999999 + var_x169;
            const double var_x171 = 1 / var_x170;
            const double var_x172 = var_x169 * var_x171;
            const double var_x243 = 1 / (1.0 + 333.33333333333331 * var_chaste_interface__Ca__Ca_ss);
            const double var_x244 = 10.0 * var_x172;
            const double var_x245 = 1 / (0.5 + var_x244 + var_x243);
            const double var_x246 = var_x135 * var_chaste_interface__ICaL__fca;
            const double var_x247 = -var_x246;
            const double var_x248 = pow((0.0142415038316475 + var_x247), (-2));
            const double var_x255 = 0.0042724511494942495 * var_x248;
            
            partialF = var_x245 * (-1 + var_x135 * var_x255);
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative9(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        
        // Mathematics
        const double var_Environment__tissue = 0; // dimensionless
        const double var_ICaL__ibarca = 3.5108651860830804 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double d_dt_chaste_interface_var_ICaL__fca2 = (-var_chaste_interface__ICaL__fca2 + 1 / (1.0 - 100.0 * var_ICaL__ICaL)) / (125.0 + 300.0 / (1.0 + exp(-4.375 - 25.0 * var_ICaL__ICaL))); // 1 / ms

        return d_dt_chaste_interface_var_ICaL__fca2;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative9(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            double var_chaste_interface__ICaL__d = rY[5];
            // Units: dimensionless; Initial value: 1.64013e-06
            double var_chaste_interface__ICaL__dp = rY[6];
            // Units: dimensionless; Initial value: 8.98230672628
            double var_chaste_interface__ICaL__f = rY[7];
            // Units: dimensionless; Initial value: 0.999961508634
            double var_chaste_interface__ICaL__fca = rY[8];
            // Units: dimensionless; Initial value: 0.97836624923
            double var_chaste_interface__ICaL__fca2 = rY[9];
            // Units: dimensionless; Initial value: 0.893052931249
            double var_chaste_interface__ICaL__f2 = rY[10];
            // Units: dimensionless; Initial value: 0.992234519148
            double var_chaste_interface__Ca__Ca_ss = rY[28];
            // Units: mM; Initial value: 0.00012271265
            
            const double var_x5 = 0.074871767015599999 * var_chaste_interface__cell__V;
            const double var_x94 = pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp);
            const double var_x95 = exp(-1.1230765052339999 + var_x5);
            const double var_x96 = var_x95 * var_chaste_interface__Ca__Ca_ss;
            const double var_x97 = -0.61380000000000001 + var_x96;
            const double var_x98 = -1.0 + var_x95;
            const double var_x99 = mParameters[0] / var_x98;
            const double var_x100 = var_x97 * var_x99;
            const double var_x101 = var_x100 * var_x94 * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca2;
            const double var_x106 = -15.0 + var_chaste_interface__cell__V;
            const double var_x133 = var_x100 * var_x106 * var_x94 * var_chaste_interface__ICaL__f2;
            const double var_x135 = var_x101 * var_x106;
            const double var_x246 = var_x135 * var_chaste_interface__ICaL__fca;
            const double var_x247 = -var_x246;
            const double var_x253 = var_x133 * var_chaste_interface__ICaL__fca;
            const double var_x256 = var_x253 * var_chaste_interface__ICaL__f;
            const double var_x264 = exp(-4.375 - 87.77162965207701 * var_x246);
            const double var_x265 = 1.0 + var_x264;
            const double var_x266 = 1 / var_x265;
            const double var_x267 = 1 / (125.0 + 300.0 * var_x266);
            const double var_x268 = pow((0.0028483007663294996 + var_x247), (-2));
            const double var_x271 = var_x264 * (-var_chaste_interface__ICaL__fca2 + 1 / (1.0 - 351.08651860830804 * var_x246)) / (pow(var_x265, 2) * pow((0.41666666666666669 + var_x266), 2));
            const double var_x273 = 0.2925720988402567 * var_x271;
            
            partialF = var_x267 * (-1 + 0.0028483007663294996 * var_x256 * var_x268) - var_x256 * var_x273;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative10(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_ICaL__f2 = (0.0054000000000000003 + 0.042299999999999997 * exp(-1.20074125971556 * pow((-1 + 0.053842757610673787 * var_chaste_interface__cell__V), 2))) * (0.23000000000000001 - var_chaste_interface__ICaL__f2 + 0.77000000000000002 / (1.0 + exp(2.4457142857142857 + 0.14285714285714285 * var_chaste_interface__cell__V))); // 1 / ms

        return d_dt_chaste_interface_var_ICaL__f2;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative10(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x274 = 0.042299999999999997 * exp(-1.20074125971556 * pow((-1 + 0.053842757610673787 * var_chaste_interface__cell__V), 2));
            
            partialF = -0.0054000000000000003 - var_x274;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative11(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_IKr__xr = (-var_chaste_interface__IKr__xr + 1 / (1.0 + exp(-2.3729411764705883 - 0.23529411764705882 * var_chaste_interface__cell__V))) * (0.00029999999999999997 * (38.360799999999998 + var_chaste_interface__cell__V) / (-1.0 + exp(5.8385137599999997 + 0.1522 * var_chaste_interface__cell__V)) + 0.00059999999999999995 * (-1.7383999999999999 + var_chaste_interface__cell__V) / (1.0 - exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__cell__V))); // 1 / ms

        return d_dt_chaste_interface_var_IKr__xr;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative11(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x277 = exp(5.8385137599999997 + 0.1522 * var_chaste_interface__cell__V);
            const double var_x278 = -1.0 + var_x277;
            const double var_x279 = 0.00029999999999999997 / var_x278;
            const double var_x280 = exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__cell__V);
            const double var_x281 = 1.0 - var_x280;
            const double var_x282 = 0.00059999999999999995 / var_x281;
            const double var_x283 = -1.7383999999999999 + var_chaste_interface__cell__V;
            const double var_x284 = 38.360799999999998 + var_chaste_interface__cell__V;
            const double var_x285 = var_x279 * var_x284;
            const double var_x286 = var_x282 * var_x283;
            
            partialF = -var_x285 - var_x286;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative12(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        
        
        // Mathematics
        const double var_IKs__tauxs = 1 / (7.6100000000000007e-5 * (44.600000000000001 + var_chaste_interface__cell__V) / (1.0 - exp(-444.66200000000003 - 9.9700000000000006 * var_chaste_interface__cell__V)) + 0.00036000000000000002 * (-0.55000000000000004 + var_chaste_interface__cell__V) / (-1.0 + exp(-0.070400000000000004 + 0.128 * var_chaste_interface__cell__V))); // ms
        const double var_IKs__xss = 1 / (1.0 + exp(0.4251012145748988 - 0.04048582995951417 * var_chaste_interface__cell__V)); // dimensionless
        const double d_dt_chaste_interface_var_IKs__xs1 = (-var_chaste_interface__IKs__xs1 + var_IKs__xss) / var_IKs__tauxs; // 1 / ms

        return d_dt_chaste_interface_var_IKs__xs1;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative12(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x290 = exp(-444.66200000000003 - 9.9700000000000006 * var_chaste_interface__cell__V);
            const double var_x291 = 1.0 - var_x290;
            const double var_x292 = 1 / var_x291;
            const double var_x293 = 7.6100000000000007e-5 * var_x292;
            const double var_x294 = exp(-0.070400000000000004 + 0.128 * var_chaste_interface__cell__V);
            const double var_x295 = -1.0 + var_x294;
            const double var_x296 = 1 / var_x295;
            const double var_x297 = 0.00036000000000000002 * var_x296;
            const double var_x298 = -0.55000000000000004 + var_chaste_interface__cell__V;
            const double var_x299 = 44.600000000000001 + var_chaste_interface__cell__V;
            const double var_x301 = var_x293 * var_x299;
            const double var_x302 = var_x297 * var_x298;
            
            partialF = -var_x301 - var_x302;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative13(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        
        
        // Mathematics
        const double var_IKs__tauxs = 1 / (7.6100000000000007e-5 * (44.600000000000001 + var_chaste_interface__cell__V) / (1.0 - exp(-444.66200000000003 - 9.9700000000000006 * var_chaste_interface__cell__V)) + 0.00036000000000000002 * (-0.55000000000000004 + var_chaste_interface__cell__V) / (-1.0 + exp(-0.070400000000000004 + 0.128 * var_chaste_interface__cell__V))); // ms
        const double var_IKs__xss = 1 / (1.0 + exp(0.4251012145748988 - 0.04048582995951417 * var_chaste_interface__cell__V)); // dimensionless
        const double d_dt_chaste_interface_var_IKs__xs2 = 0.5 * (-var_chaste_interface__IKs__xs2 + var_IKs__xss) / var_IKs__tauxs; // 1 / ms

        return d_dt_chaste_interface_var_IKs__xs2;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative13(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x290 = exp(-444.66200000000003 - 9.9700000000000006 * var_chaste_interface__cell__V);
            const double var_x291 = 1.0 - var_x290;
            const double var_x292 = 1 / var_x291;
            const double var_x294 = exp(-0.070400000000000004 + 0.128 * var_chaste_interface__cell__V);
            const double var_x295 = -1.0 + var_x294;
            const double var_x296 = 1 / var_x295;
            const double var_x298 = -0.55000000000000004 + var_chaste_interface__cell__V;
            const double var_x299 = 44.600000000000001 + var_chaste_interface__cell__V;
            
            partialF = -3.8050000000000003e-5 * var_x292 * var_x299 - 0.00018000000000000001 * var_x296 * var_x298;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative14(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Ito__ydv = 25.0 * (1.0 - var_chaste_interface__Ito__ydv) * exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__cell__V)) - 25.0 * var_chaste_interface__Ito__ydv * exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__cell__V)); // 1 / ms

        return d_dt_chaste_interface_var_Ito__ydv;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative14(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x304 = 0.040000000000000001 * var_chaste_interface__cell__V;
            const double var_x305 = exp(-1.6000000000000001 + var_x304);
            const double var_x306 = 1.0 + var_x305;
            const double var_x307 = var_x305 / var_x306;
            const double var_x309 = exp(-3.6000000000000001 - var_x304);
            const double var_x310 = 1.0 + var_x309;
            const double var_x311 = var_x309 / var_x310;
            
            partialF = -25.0 * var_x307 - 25.0 * var_x311;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative15(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Ito__ydv2 = 0.029999999999999999 * (1.0 - var_chaste_interface__Ito__ydv2) / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__cell__V)) - 0.20000000000000001 * var_chaste_interface__Ito__ydv2 * exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V)); // 1 / ms

        return d_dt_chaste_interface_var_Ito__ydv2;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative15(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x314 = 0.20000000000000001 * var_chaste_interface__cell__V;
            const double var_x315 = exp(5.0 + var_x314);
            const double var_x316 = 1.0 + var_x315;
            const double var_x318 = var_x315 / var_x316;
            const double var_x319 = exp(12.0 + var_x314);
            const double var_x320 = 1.0 + var_x319;
            const double var_x322 = 1 / var_x320;
            
            partialF = -0.029999999999999999 * var_x322 - 0.20000000000000001 * var_x318;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative16(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Ito__zdv = 0.0022499999999999998 * (1.0 - var_chaste_interface__Ito__zdv) / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__cell__V)) - 0.10000000000000001 * var_chaste_interface__Ito__zdv * exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V) / (1.0 + exp(5.0 + 0.20000000000000001 * var_chaste_interface__cell__V)); // 1 / ms

        return d_dt_chaste_interface_var_Ito__zdv;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative16(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x314 = 0.20000000000000001 * var_chaste_interface__cell__V;
            const double var_x315 = exp(5.0 + var_x314);
            const double var_x316 = 1.0 + var_x315;
            const double var_x318 = var_x315 / var_x316;
            const double var_x319 = exp(12.0 + var_x314);
            const double var_x320 = 1.0 + var_x319;
            const double var_x322 = 1 / var_x320;
            
            partialF = -0.10000000000000001 * var_x318 - 0.0022499999999999998 * var_x322;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative17(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ito2__AA = rY[17];
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Ito2__AA = 1 / (1.0 + 0.1502 / var_chaste_interface__Ca__Ca_ss) - 1.0 * var_chaste_interface__Ito2__AA; // 1 / ms

        return d_dt_chaste_interface_var_Ito2__AA;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative17(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -1.0;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative18(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_INal__mL = -0.080000000000000002 * var_chaste_interface__INal__mL * exp(-0.090909090909090912 * var_chaste_interface__cell__V) + 0.32000000000000001 * (1.0 - var_chaste_interface__INal__mL) * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V)); // 1 / ms

        return d_dt_chaste_interface_var_INal__mL;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative18(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            
            const double var_x201 = -0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x202 = exp(-4.7130000000000001 + var_x201);
            const double var_x203 = 1.0 - var_x202;
            const double var_x204 = 0.32000000000000001 / var_x203;
            const double var_x205 = exp(-0.090909090909090912 * var_chaste_interface__cell__V);
            const double var_x207 = 47.130000000000003 + var_chaste_interface__cell__V;
            const double var_x209 = -0.080000000000000002 * var_x205 - var_x204 * var_x207;
            
            partialF = var_x209;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative19(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_INal__hL = 0.0016666666666666668 / (1.0 + exp(14.918032786885247 + 0.16393442622950821 * var_chaste_interface__cell__V)) - 0.0016666666666666668 * var_chaste_interface__INal__hL; // 1 / ms

        return d_dt_chaste_interface_var_INal__hL;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative19(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.0016666666666666668;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative20(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Irel__CaMKtrap = rY[20];
        // Units: dimensionless; Initial value: 0.021123704774
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        
        // Mathematics
        const double var_Irel__CaMKactive = 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap; // dimensionless
        const double d_dt_chaste_interface_var_Irel__CaMKtrap = -0.00068000000000000005 * var_chaste_interface__Irel__CaMKtrap + 0.050000000000000003 * (-var_chaste_interface__Irel__CaMKtrap + var_Irel__CaMKactive) * var_Irel__CaMKactive; // 1 / ms

        return d_dt_chaste_interface_var_Irel__CaMKtrap;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative20(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Irel__CaMKtrap = rY[20];
            // Units: dimensionless; Initial value: 0.021123704774
            double var_chaste_interface__Ca__Ca_ss = rY[28];
            // Units: mM; Initial value: 0.00012271265
            
            const double var_x164 = 1.0 - var_chaste_interface__Irel__CaMKtrap;
            const double var_x165 = 1 / var_chaste_interface__Ca__Ca_ss;
            const double var_x166 = 1.0 + 0.0015 * var_x165;
            const double var_x167 = 1 / var_x166;
            const double var_x168 = 0.050000000000000003 * var_x167;
            const double var_x169 = var_x164 * var_x168 + var_chaste_interface__Irel__CaMKtrap;
            const double var_x181 = 1 - var_x168;
            const double var_x326 = 0.0025000000000000005 * var_x167;
            
            partialF = -0.00068000000000000005 - var_x169 * var_x326 + var_x164 * var_x181 * var_x326;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative21(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__Irel__ro = rY[21];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Ca__Ca_jsr = rY[26];
        // Units: mM; Initial value: 1.737580994071
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        
        // Mathematics
        const double var_Environment__tissue = 0; // dimensionless
        const double var_ICaL__ibarca = 3.5108651860830804 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double d_dt_chaste_interface_var_Irel__ro = -0.33333333333333331 * var_chaste_interface__Irel__ro + 0.33333333333333331 * pow(var_chaste_interface__Ca__Ca_jsr, 1.8999999999999999) / ((1.0 + 1 / pow(var_ICaL__ICaL, 2)) * (pow(var_chaste_interface__Ca__Ca_jsr, 1.8999999999999999) + 1644.6531773416521 * pow((var_chaste_interface__Ca__Ca_ss / (0.0028 + var_chaste_interface__Ca__Ca_ss)), 1.8999999999999999))); // 1 / ms

        return d_dt_chaste_interface_var_Irel__ro;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative21(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.33333333333333331;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative22(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__Irel__CaMKtrap = rY[20];
        // Units: dimensionless; Initial value: 0.021123704774
        double var_chaste_interface__Irel__ri = rY[22];
        // Units: dimensionless; Initial value: 0.862666650318
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        
        // Mathematics
        const double var_Environment__tissue = 0; // dimensionless
        const double var_Irel__CaMKactive = 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap; // dimensionless
        const double var_ICaL__ibarca = 3.5108651860830804 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double var_Irel__cafac = 1 / (1.0 + exp(3.3333333333333335 + 66.666666666666671 * var_ICaL__ICaL)); // dimensionless
        const double d_dt_chaste_interface_var_Irel__ri = (-var_chaste_interface__Irel__ri + 1 / (1.0 + exp(-16.0 + 80.0 * var_Irel__cafac + 40000.0 * var_chaste_interface__Ca__Ca_ss))) / (3.0 + (350.0 - 10.0 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive)) / (1.0 + exp(-15.0 + 5000.0 * var_chaste_interface__Ca__Ca_ss + 15.0 * var_Irel__cafac)) + 10.0 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive)); // 1 / ms

        return d_dt_chaste_interface_var_Irel__ri;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative22(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            double var_chaste_interface__ICaL__d = rY[5];
            // Units: dimensionless; Initial value: 1.64013e-06
            double var_chaste_interface__ICaL__dp = rY[6];
            // Units: dimensionless; Initial value: 8.98230672628
            double var_chaste_interface__ICaL__f = rY[7];
            // Units: dimensionless; Initial value: 0.999961508634
            double var_chaste_interface__ICaL__fca = rY[8];
            // Units: dimensionless; Initial value: 0.97836624923
            double var_chaste_interface__ICaL__fca2 = rY[9];
            // Units: dimensionless; Initial value: 0.893052931249
            double var_chaste_interface__ICaL__f2 = rY[10];
            // Units: dimensionless; Initial value: 0.992234519148
            double var_chaste_interface__Irel__CaMKtrap = rY[20];
            // Units: dimensionless; Initial value: 0.021123704774
            double var_chaste_interface__Ca__Ca_ss = rY[28];
            // Units: mM; Initial value: 0.00012271265
            
            const double var_x5 = 0.074871767015599999 * var_chaste_interface__cell__V;
            const double var_x94 = pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp);
            const double var_x95 = exp(-1.1230765052339999 + var_x5);
            const double var_x96 = var_x95 * var_chaste_interface__Ca__Ca_ss;
            const double var_x97 = -0.61380000000000001 + var_x96;
            const double var_x98 = -1.0 + var_x95;
            const double var_x99 = mParameters[0] / var_x98;
            const double var_x100 = var_x97 * var_x99;
            const double var_x101 = var_x100 * var_x94 * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca2;
            const double var_x106 = -15.0 + var_chaste_interface__cell__V;
            const double var_x135 = var_x101 * var_x106;
            const double var_x164 = 1.0 - var_chaste_interface__Irel__CaMKtrap;
            const double var_x165 = 1 / var_chaste_interface__Ca__Ca_ss;
            const double var_x166 = 1.0 + 0.0015 * var_x165;
            const double var_x167 = 1 / var_x166;
            const double var_x168 = 0.050000000000000003 * var_x167;
            const double var_x169 = var_x164 * var_x168 + var_chaste_interface__Irel__CaMKtrap;
            const double var_x170 = 0.14999999999999999 + var_x169;
            const double var_x171 = 1 / var_x170;
            const double var_x172 = var_x169 * var_x171;
            const double var_x244 = 10.0 * var_x172;
            const double var_x246 = var_x135 * var_chaste_interface__ICaL__fca;
            const double var_x356 = exp(3.3333333333333335 + 234.05767907220539 * var_x246);
            const double var_x357 = 1.0 + var_x356;
            const double var_x358 = 1 / var_x357;
            const double var_x361 = exp(-15.0 + 5000.0 * var_chaste_interface__Ca__Ca_ss + 15.0 * var_x358);
            const double var_x362 = 1.0 + var_x361;
            const double var_x363 = 1 / var_x362;
            const double var_x364 = 350.0 - var_x244;
            const double var_x365 = var_x363 * var_x364;
            const double var_x366 = 1 / (3.0 + var_x244 + var_x365);
            
            partialF = -var_x366;
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative23(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__INa__H = rY[2];
        // Units: dimensionless; Initial value: 0.987317750543
        double var_chaste_interface__INa__m = rY[3];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INa__J = rY[4];
        // Units: dimensionless; Initial value: 0.991924983076
        double var_chaste_interface__INal__mL = rY[18];
        // Units: dimensionless; Initial value: 0.001356538159
        double var_chaste_interface__INal__hL = rY[19];
        // Units: dimensionless; Initial value: 0.26130711759
        double var_chaste_interface__Na__Na_i = rY[23];
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__Cl__Cl_i = rY[25];
        // Units: mM; Initial value: 15.59207157178
        
        
        // Mathematics
        const double var_Environment__tissue = 0; // dimensionless
        const double var_INaCa__ca_i_NaCa = 1.5 * var_chaste_interface__Ca__Ca_i; // mM
        const double var_INaCa__INaCa = 4.5 * (1.8 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.01310255922773 * var_chaste_interface__cell__V) - 2744000.0 * var_INaCa__ca_i_NaCa * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) / ((1.0 + 0.27000000000000002 * exp(-0.024333324280070002 * var_chaste_interface__cell__V)) * (1.0 + 1.5624999999999999e-8 / pow(var_INaCa__ca_i_NaCa, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_INaCa__ca_i_NaCa)); // uA_per_uF
        const double var_INaK__INaK = 0.48423913043478262 / ((1.0 + 100.0 / pow(var_chaste_interface__Na__Na_i, 2)) * (1.0 + 0.1245 * exp(-0.00374358835078 * var_chaste_interface__cell__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.0374358835078 * var_chaste_interface__cell__V))); // uA_per_uF
        const double var_cell__AF = 5.0619267243613002e-10 * M_PI; // uF_mole_per_C
        const double var_cell__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell__vmyo = 0.68000000000000005 * var_cell__vcell; // uL
        const double var_reversal_potentials__ECl = -26.712338705500134 * log(100.0 / var_chaste_interface__Cl__Cl_i); // mV
        const double var_reversal_potentials__ENa = 26.712338705500134 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_Na__CTNaCl = 9.8442999999999999e-6 * pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4) / (59494197.640692554 + pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4)); // mM_per_ms
        const double var_cell__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + 0.0064999999999999997 * pow(var_chaste_interface__INal__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * var_chaste_interface__INal__hL + pow(var_chaste_interface__INa__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__cell__V) * ((var_Environment__tissue == 0) ? (8.25) : (33.0)) * mParameters[1] * var_chaste_interface__INa__H * var_chaste_interface__INa__J; // uA_per_uF
        const double d_dt_chaste_interface_var_Na__Na_i = -var_cell__AF * var_cell__naiont / var_cell__vmyo + var_Na__CTNaCl; // mM / ms

        return d_dt_chaste_interface_var_Na__Na_i;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative23(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            double var_chaste_interface__Ca__Ca_i = rY[1];
            // Units: mM; Initial value: 0.00012131666
            double var_chaste_interface__INa__H = rY[2];
            // Units: dimensionless; Initial value: 0.987317750543
            double var_chaste_interface__INa__m = rY[3];
            // Units: dimensionless; Initial value: 0.001356538159
            double var_chaste_interface__INa__J = rY[4];
            // Units: dimensionless; Initial value: 0.991924983076
            double var_chaste_interface__INal__mL = rY[18];
            // Units: dimensionless; Initial value: 0.001356538159
            double var_chaste_interface__INal__hL = rY[19];
            // Units: dimensionless; Initial value: 0.26130711759
            double var_chaste_interface__Na__Na_i = rY[23];
            // Units: mM; Initial value: 12.972433387269
            double var_chaste_interface__Cl__Cl_i = rY[25];
            // Units: mM; Initial value: 15.59207157178
            
            const double var_x3 = pow(var_chaste_interface__INal__mL, 3);
            const double var_x37 = 0.0374358835078 * var_chaste_interface__cell__V;
            const double var_x44 = pow(var_chaste_interface__Na__Na_i, 2);
            const double var_x45 = 1 / var_x44;
            const double var_x46 = exp(-0.00374358835078 * var_chaste_interface__cell__V);
            const double var_x47 = exp(2.0802377414561666);
            const double var_x48 = exp(-var_x37);
            const double var_x49 = 1.0 + 0.1245 * var_x46 + 0.036499999999999998 * var_x48 * (-0.14285714285714285 + 0.14285714285714285 * var_x47);
            const double var_x62 = pow(var_chaste_interface__Na__Na_i, 3);
            const double var_x63 = exp(0.01310255922773 * var_chaste_interface__cell__V);
            const double var_x64 = var_x62 * var_x63;
            const double var_x65 = exp(-0.024333324280070002 * var_chaste_interface__cell__V);
            const double var_x66 = var_x65 * var_chaste_interface__Ca__Ca_i;
            const double var_x67 = 1 / (13227.9606 + 6516533.0625 * var_chaste_interface__Ca__Ca_i + 8.4084932990912282 * var_x62);
            const double var_x68 = 1.0 + 0.27000000000000002 * var_x65;
            const double var_x69 = 1 / var_x68;
            const double var_x70 = 1.0 + 6.9444444444444451e-9 / pow(var_chaste_interface__Ca__Ca_i, 2);
            const double var_x71 = 1 / var_x70;
            const double var_x72 = var_x69 * var_x71;
            const double var_x73 = var_x67 * var_x72;
            const double var_x75 = pow(var_chaste_interface__INa__m, 3);
            const double var_x76 = var_x75 * mParameters[1] * var_chaste_interface__INa__J;
            const double var_x91 = 1.8 * var_x64 - 4116000.0 * var_x66;
            const double var_x118 = var_x72 * var_x91 / pow((0.0020299076937277489 + 1.2903323313862536e-6 * var_x62 + var_chaste_interface__Ca__Ca_i), 2);
            const double var_x124 = 1 / var_chaste_interface__Na__Na_i;
            const double var_x125 = log(140.0 * var_x124);
            const double var_x141 = 1 / (var_x49 * var_x62 * pow((0.01 + var_x45), 2));
            const double var_x142 = var_x124 * var_x3 * var_chaste_interface__INal__hL;
            const double var_x143 = var_x118 * var_x44;
            const double var_x146 = var_x44 * var_x63 * var_x73;
            const double var_x147 = var_x124 * var_x76 * var_chaste_interface__INa__H;
            const double var_x155 = 1 / var_chaste_interface__Cl__Cl_i;
            const double var_x383 = log(100.0 * var_x155);
            const double var_x384 = var_x125 + var_x383;
            const double var_x385 = pow(var_x384, 4);
            const double var_x386 = 2.8839711417381356e-9 * pow(var_x384, 7) / pow((1 + 0.008558014922736952 * var_x385), 2);
            const double var_x387 = 20.048989239405216 * pow(var_x384, 3) / (59494197.640692554 + 509152.23122530844 * var_x385);
            const double var_x388 = var_x124 * var_x386 - var_x124 * var_x387;
            
            partialF = var_x388 + 4.9335731356566794e-16 * var_x143 - 1.7874450622236046e-6 * var_x141 - 1.068185898837083e-5 * var_x142 - 0.013557744100624516 * var_x147 - 0.0044848621561246801 * var_x146;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative24(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 7.24074e-06
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.019883138161
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.019890650554
        double var_chaste_interface__Ito__ydv = rY[14];
        // Units: dimensionless; Initial value: 0.013970786703
        double var_chaste_interface__Ito__ydv2 = rY[15];
        // Units: dimensionless; Initial value: 0.99996472752
        double var_chaste_interface__Ito__zdv = rY[16];
        // Units: dimensionless; Initial value: 0.829206149767
        double var_chaste_interface__Na__Na_i = rY[23];
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = rY[24];
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = rY[25];
        // Units: mM; Initial value: 15.59207157178
        
        
        // Mathematics
        const double var_INaK__INaK = 0.48423913043478262 / ((1.0 + 100.0 / pow(var_chaste_interface__Na__Na_i, 2)) * (1.0 + 0.1245 * exp(-0.00374358835078 * var_chaste_interface__cell__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.0374358835078 * var_chaste_interface__cell__V))); // uA_per_uF
        const double var_cell__i_Stim = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time) / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_cell__AF = 5.0619267243613002e-10 * M_PI; // uF_mole_per_C
        const double var_cell__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell__vmyo = 0.68000000000000005 * var_cell__vcell; // uL
        const double var_reversal_potentials__ECl = -26.712338705500134 * log(100.0 / var_chaste_interface__Cl__Cl_i); // mV
        const double var_reversal_potentials__EK = 26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_K__CTKCl = 7.0755999999999996e-6 * (-var_reversal_potentials__ECl + var_reversal_potentials__EK) / (87.825100000000006 - var_reversal_potentials__ECl + var_reversal_potentials__EK); // mM_per_ms
        const double var_cell__kiont = 0.5 * var_cell__i_Stim - 2.0 * var_INaK__INaK + 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V)) + 0.51000000000000001 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__EK)) + (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__EK) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__cell__V)))) + (0.024897499999999999 + 0.014938499999999999 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.712338705500134 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V) * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2 + 0.013854200000000001 * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * mParameters[2] * var_chaste_interface__IKr__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V)) + 0.19 * pow(var_chaste_interface__Ito__ydv, 3) * (-var_reversal_potentials__EK + var_chaste_interface__cell__V) * var_chaste_interface__Ito__ydv2 * var_chaste_interface__Ito__zdv * exp(0.0033333333333333335 * var_chaste_interface__cell__V); // uA_per_uF
        const double d_dt_chaste_interface_var_K__K_i = -var_cell__AF * var_cell__kiont / var_cell__vmyo + var_K__CTKCl; // mM / ms

        return d_dt_chaste_interface_var_K__K_i;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative24(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            double var_chaste_interface__Ca__Ca_i = rY[1];
            // Units: mM; Initial value: 0.00012131666
            double var_chaste_interface__IKr__xr = rY[11];
            // Units: dimensionless; Initial value: 7.24074e-06
            double var_chaste_interface__IKs__xs1 = rY[12];
            // Units: dimensionless; Initial value: 0.019883138161
            double var_chaste_interface__IKs__xs2 = rY[13];
            // Units: dimensionless; Initial value: 0.019890650554
            double var_chaste_interface__Ito__ydv = rY[14];
            // Units: dimensionless; Initial value: 0.013970786703
            double var_chaste_interface__Ito__ydv2 = rY[15];
            // Units: dimensionless; Initial value: 0.99996472752
            double var_chaste_interface__Ito__zdv = rY[16];
            // Units: dimensionless; Initial value: 0.829206149767
            double var_chaste_interface__Na__Na_i = rY[23];
            // Units: mM; Initial value: 12.972433387269
            double var_chaste_interface__K__K_i = rY[24];
            // Units: mM; Initial value: 135.469546216758
            double var_chaste_interface__Cl__Cl_i = rY[25];
            // Units: mM; Initial value: 15.59207157178
            
            const double var_x0 = exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__cell__V);
            const double var_x1 = 1.0 + var_x0;
            const double var_x2 = 1 / var_x1;
            const double var_x12 = 1 / var_chaste_interface__K__K_i;
            const double var_x13 = log(5.4000000000000004 * var_x12);
            const double var_x14 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 6.370892781261781 * var_x13);
            const double var_x15 = 1.0 + var_x14;
            const double var_x16 = 1 / var_x15;
            const double var_x17 = exp(-2.4444678999999998 + 13.738155796238718 * var_x13 - 0.51429999999999998 * var_chaste_interface__cell__V);
            const double var_x18 = 1.0 + var_x17;
            const double var_x19 = 1 / var_x18;
            const double var_x20 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 1.6494869150646332 * var_x13);
            const double var_x21 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 2.1455350448257708 * var_x13);
            const double var_x22 = var_x20 + 0.49124000000000001 * var_x21;
            const double var_x23 = var_x19 * var_x22;
            const double var_x24 = 1 / (var_x23 + 1.02 * var_x16);
            const double var_x25 = var_x16 * var_x24;
            const double var_x26 = 1 / var_chaste_interface__Ca__Ca_i;
            const double var_x27 = pow(var_x26, 1.3999999999999999);
            const double var_x28 = 1.0 + 6.4818210260626455e-7 * var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x33 = exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__cell__V);
            const double var_x34 = 1.0 + var_x33;
            const double var_x35 = mParameters[2] / var_x34;
            const double var_x51 = 26.712338705500134 * var_x13;
            const double var_x52 = -var_x51 + var_chaste_interface__cell__V;
            const double var_x59 = var_x14 / pow(var_x15, 2);
            const double var_x60 = var_x24 * var_x52;
            const double var_x78 = pow(var_chaste_interface__Ito__ydv, 3);
            const double var_x79 = exp(0.0033333333333333335 * var_chaste_interface__cell__V);
            const double var_x80 = var_x78 * var_x79 * var_chaste_interface__Ito__zdv;
            const double var_x83 = var_x17 * var_x22 / pow(var_x18, 2);
            const double var_x85 = var_x16 * var_x52 / pow((var_x16 + 0.98039215686274506 * var_x23), 2);
            const double var_x120 = 0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i;
            const double var_x144 = (0.12553036579548593 * var_chaste_interface__K__K_i + 0.002300971605031257 * var_chaste_interface__Na__Na_i) / pow(var_x120, 2);
            const double var_x148 = var_x12 * var_x2;
            const double var_x149 = var_x12 * var_x25;
            const double var_x150 = var_x12 * var_x35 * var_chaste_interface__IKr__xr;
            const double var_x151 = var_x12 * var_x59;
            const double var_x152 = 6.4983106368870169 * var_x151 - var_x19 * (1.6494869150646332 * var_x12 * var_x20 + 1.0539726354202117 * var_x12 * var_x21) - 13.738155796238718 * var_x12 * var_x83;
            const double var_x153 = var_x151 * var_x60;
            const double var_x154 = var_x12 * var_x80 * var_chaste_interface__Ito__ydv2;
            const double var_x155 = 1 / var_chaste_interface__Cl__Cl_i;
            const double var_x383 = log(100.0 * var_x155);
            const double var_x390 = -1.5317126959137754e-6 - 9.1902761754826519e-7 * var_x29;
            const double var_x391 = var_x390 * var_chaste_interface__IKs__xs2;
            const double var_x392 = var_x391 * var_chaste_interface__IKs__xs1;
            const double var_x395 = 3.0157226903121925e-5 * var_x85;
            const double var_x396 = var_x144 * var_x392;
            const double var_x397 = var_x51 + 26.712338705500134 * var_x383;
            const double var_x398 = 0.00018900582374463672 / (87.825100000000006 + var_x397);
            const double var_x399 = 2.4504050574883893e-8 * var_x397 / pow((1 + 0.30415380916731244 * var_x13 + 0.30415380916731244 * var_x383), 2);
            const double var_x400 = var_x12 * var_x399 - var_x12 * var_x398;
            
            partialF = var_x400 + 212.79583259575517 * var_x396 + 0.00019989044893084398 * var_x153 - 4.535681662754383e-6 * var_x148 - 0.00031223895504468581 * var_x154 - 2.2767478584105716e-5 * var_x150 - 0.0008381150898567882 * var_x149 - var_x152 * var_x395;
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative25(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ito2__AA = rY[17];
        // Units: dimensionless; Initial value: 0.000816605172
        double var_chaste_interface__Na__Na_i = rY[23];
        // Units: mM; Initial value: 12.972433387269
        double var_chaste_interface__K__K_i = rY[24];
        // Units: mM; Initial value: 135.469546216758
        double var_chaste_interface__Cl__Cl_i = rY[25];
        // Units: mM; Initial value: 15.59207157178
        
        
        // Mathematics
        const double var_cell__i_Stim = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time) / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_cell__AF = 5.0619267243613002e-10 * M_PI; // uF_mole_per_C
        const double var_cell__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell__vmyo = 0.68000000000000005 * var_cell__vcell; // uL
        const double var_reversal_potentials__ECl = -26.712338705500134 * log(100.0 / var_chaste_interface__Cl__Cl_i); // mV
        const double var_cell__clont = 0.5 * var_cell__i_Stim + 0.00022499999999999999 * var_chaste_interface__cell__V - 0.00022499999999999999 * var_reversal_potentials__ECl + 0.001444800488100033 * (-100.0 * exp(0.0374358835078 * var_chaste_interface__cell__V) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2__AA * var_chaste_interface__cell__V / (1.0 - exp(0.0374358835078 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_reversal_potentials__EK = 26.712338705500134 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_K__CTKCl = 7.0755999999999996e-6 * (-var_reversal_potentials__ECl + var_reversal_potentials__EK) / (87.825100000000006 - var_reversal_potentials__ECl + var_reversal_potentials__EK); // mM_per_ms
        const double var_reversal_potentials__ENa = 26.712338705500134 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_Na__CTNaCl = 9.8442999999999999e-6 * pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4) / (59494197.640692554 + pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4)); // mM_per_ms
        const double d_dt_chaste_interface_var_Cl__Cl_i = var_cell__AF * var_cell__clont / var_cell__vmyo + var_K__CTKCl + var_Na__CTNaCl; // mM / ms

        return d_dt_chaste_interface_var_Cl__Cl_i;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative25(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            double var_chaste_interface__Ito2__AA = rY[17];
            // Units: dimensionless; Initial value: 0.000816605172
            double var_chaste_interface__Na__Na_i = rY[23];
            // Units: mM; Initial value: 12.972433387269
            double var_chaste_interface__K__K_i = rY[24];
            // Units: mM; Initial value: 135.469546216758
            double var_chaste_interface__Cl__Cl_i = rY[25];
            // Units: mM; Initial value: 15.59207157178
            
            const double var_x12 = 1 / var_chaste_interface__K__K_i;
            const double var_x13 = log(5.4000000000000004 * var_x12);
            const double var_x37 = 0.0374358835078 * var_chaste_interface__cell__V;
            const double var_x38 = exp(var_x37);
            const double var_x39 = 1.0 - var_x38;
            const double var_x40 = 1 / var_x39;
            const double var_x51 = 26.712338705500134 * var_x13;
            const double var_x56 = var_chaste_interface__Ito2__AA * var_chaste_interface__cell__V;
            const double var_x57 = var_x40 * var_x56;
            const double var_x124 = 1 / var_chaste_interface__Na__Na_i;
            const double var_x125 = log(140.0 * var_x124);
            const double var_x155 = 1 / var_chaste_interface__Cl__Cl_i;
            const double var_x383 = log(100.0 * var_x155);
            const double var_x384 = var_x125 + var_x383;
            const double var_x385 = pow(var_x384, 4);
            const double var_x386 = 2.8839711417381356e-9 * pow(var_x384, 7) / pow((1 + 0.008558014922736952 * var_x385), 2);
            const double var_x387 = 20.048989239405216 * pow(var_x384, 3) / (59494197.640692554 + 509152.23122530844 * var_x385);
            const double var_x389 = var_x155 * var_x386 - var_x155 * var_x387;
            const double var_x397 = var_x51 + 26.712338705500134 * var_x383;
            const double var_x398 = 0.00018900582374463672 / (87.825100000000006 + var_x397);
            const double var_x399 = 2.4504050574883893e-8 * var_x397 / pow((1 + 0.30415380916731244 * var_x13 + 0.30415380916731244 * var_x383), 2);
            const double var_x401 = var_x155 * var_x399 - var_x155 * var_x398;
            
            partialF = var_x389 + var_x401 + 8.8885199344722979e-8 * var_x57 - 3.6975665728975948e-7 * var_x155;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative26(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Irel__ro = rY[21];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Irel__ri = rY[22];
        // Units: dimensionless; Initial value: 0.862666650318
        double var_chaste_interface__Ca__Ca_jsr = rY[26];
        // Units: mM; Initial value: 1.737580994071
        double var_chaste_interface__Ca__Ca_nsr = rY[27];
        // Units: mM; Initial value: 1.832822335168
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        
        // Mathematics
        const double var_Environment__tissue = 0; // dimensionless
        const double var_Idiff_Itr__itr = 0.0083333333333333332 * var_chaste_interface__Ca__Ca_nsr - 0.0083333333333333332 * var_chaste_interface__Ca__Ca_jsr; // mM_per_ms
        const double var_ICaL__ibarca = 3.5108651860830804 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_Irel__irelcicr = 3000.0 * (-var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_jsr) * ((var_Environment__tissue == 0) ? (1 / (1.0 + exp(2.6000000000000001 + 0.20000000000000001 * var_ICaL__ibarca))) : (1.0)) * var_chaste_interface__Irel__ri * var_chaste_interface__Irel__ro; // mM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_jsr = (-var_Irel__irelcicr + var_Idiff_Itr__itr) / (1.0 + 8.0 / pow((0.80000000000000004 + var_chaste_interface__Ca__Ca_jsr), 2)); // mM / ms

        return d_dt_chaste_interface_var_Ca__Ca_jsr;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative26(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            double var_chaste_interface__Irel__ro = rY[21];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__Irel__ri = rY[22];
            // Units: dimensionless; Initial value: 0.862666650318
            double var_chaste_interface__Ca__Ca_jsr = rY[26];
            // Units: mM; Initial value: 1.737580994071
            double var_chaste_interface__Ca__Ca_nsr = rY[27];
            // Units: mM; Initial value: 1.832822335168
            double var_chaste_interface__Ca__Ca_ss = rY[28];
            // Units: mM; Initial value: 0.00012271265
            
            const double var_x5 = 0.074871767015599999 * var_chaste_interface__cell__V;
            const double var_x95 = exp(-1.1230765052339999 + var_x5);
            const double var_x96 = var_x95 * var_chaste_interface__Ca__Ca_ss;
            const double var_x97 = -0.61380000000000001 + var_x96;
            const double var_x98 = -1.0 + var_x95;
            const double var_x99 = mParameters[0] / var_x98;
            const double var_x100 = var_x97 * var_x99;
            const double var_x106 = -15.0 + var_chaste_interface__cell__V;
            const double var_x403 = 0.80000000000000004 + var_chaste_interface__Ca__Ca_jsr;
            const double var_x404 = pow(var_x403, (-2));
            const double var_x405 = 1 / (1.0 + 8.0 * var_x404);
            const double var_x407 = 0.70217303721661617 * var_x100;
            const double var_x409 = exp(2.6000000000000001 + var_x106 * var_x407);
            const double var_x410 = 1.0 + var_x409;
            const double var_x411 = -var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_jsr;
            const double var_x415 = 1 / var_x410;
            const double var_x416 = var_x415 * var_chaste_interface__Irel__ri;
            const double var_x419 = var_x416 * var_chaste_interface__Irel__ro;
            const double var_x420 = 3000.0 * var_x419;
            const double var_x421 = var_x405;
            
            partialF = var_x421 * (-0.0083333333333333332 - var_x420) + 0.25 * (0.0083333333333333332 * var_chaste_interface__Ca__Ca_nsr - 0.0083333333333333332 * var_chaste_interface__Ca__Ca_jsr - var_x411 * var_x420) / (pow(var_x403, 3) * pow((0.125 + var_x404), 2));
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative27(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__Irel__CaMKtrap = rY[20];
        // Units: dimensionless; Initial value: 0.021123704774
        double var_chaste_interface__Ca__Ca_jsr = rY[26];
        // Units: mM; Initial value: 1.737580994071
        double var_chaste_interface__Ca__Ca_nsr = rY[27];
        // Units: mM; Initial value: 1.832822335168
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        
        // Mathematics
        const double var_Idiff_Itr__itr = 0.0083333333333333332 * var_chaste_interface__Ca__Ca_nsr - 0.0083333333333333332 * var_chaste_interface__Ca__Ca_jsr; // mM_per_ms
        const double var_Irel__CaMKactive = 0.050000000000000003 * (1.0 - var_chaste_interface__Irel__CaMKtrap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss) + var_chaste_interface__Irel__CaMKtrap; // dimensionless
        const double var_Iup_Ileak__iup = 0.0043750000000000004 * (1.0 + 0.75 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive)) * var_chaste_interface__Ca__Ca_i / (0.00092000000000000003 - 0.00017000000000000001 * var_Irel__CaMKactive / (0.14999999999999999 + var_Irel__CaMKactive) + var_chaste_interface__Ca__Ca_i); // mM_per_ms
        const double var_Iup_Ileak__ileak = 0.00029166666666666669 * var_chaste_interface__Ca__Ca_nsr; // mM_per_ms
        const double var_cell__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell__vjsr = 0.0047999999999999996 * var_cell__vcell; // uL
        const double var_cell__vnsr = 0.055199999999999999 * var_cell__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_nsr = -var_Iup_Ileak__ileak - var_Idiff_Itr__itr * var_cell__vjsr / var_cell__vnsr + var_Iup_Ileak__iup; // mM / ms

        return d_dt_chaste_interface_var_Ca__Ca_nsr;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative27(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.0010163043478260869;
        }
        else
        {
            const double y_save = rY[27];
            rY[27] += delta;
            const double temp = EvaluateYDerivative27(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[27])/delta;
            rY[27] = y_save;
        }
        return partialF;
    }
    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluateYDerivative28(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -85.781844107117
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 0.00012131666
        double var_chaste_interface__ICaL__d = rY[5];
        // Units: dimensionless; Initial value: 1.64013e-06
        double var_chaste_interface__ICaL__dp = rY[6];
        // Units: dimensionless; Initial value: 8.98230672628
        double var_chaste_interface__ICaL__f = rY[7];
        // Units: dimensionless; Initial value: 0.999961508634
        double var_chaste_interface__ICaL__fca = rY[8];
        // Units: dimensionless; Initial value: 0.97836624923
        double var_chaste_interface__ICaL__fca2 = rY[9];
        // Units: dimensionless; Initial value: 0.893052931249
        double var_chaste_interface__ICaL__f2 = rY[10];
        // Units: dimensionless; Initial value: 0.992234519148
        double var_chaste_interface__Irel__ro = rY[21];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Irel__ri = rY[22];
        // Units: dimensionless; Initial value: 0.862666650318
        double var_chaste_interface__Ca__Ca_jsr = rY[26];
        // Units: mM; Initial value: 1.737580994071
        double var_chaste_interface__Ca__Ca_ss = rY[28];
        // Units: mM; Initial value: 0.00012271265
        
        
        // Mathematics
        const double var_Environment__tissue = 0; // dimensionless
        const double var_Idiff_Itr__idiff = 5.0 * var_chaste_interface__Ca__Ca_ss - 5.0 * var_chaste_interface__Ca__Ca_i; // mM_per_ms
        const double var_ICaL__ibarca = 3.5108651860830804 * (-15.0 + var_chaste_interface__cell__V) * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss * exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)) * mParameters[0] / (-1.0 + exp(-1.1230765052339999 + 0.074871767015599999 * var_chaste_interface__cell__V)); // uA_per_uF
        const double var_ICaL__ICaL = ((var_Environment__tissue == 0) ? (pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp) * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca) : (var_chaste_interface__ICaL__d * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca * var_chaste_interface__ICaL__fca2 * var_ICaL__ibarca)); // uA_per_uF
        const double var_Irel__irelcicr = 3000.0 * (-var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_jsr) * ((var_Environment__tissue == 0) ? (1 / (1.0 + exp(2.6000000000000001 + 0.20000000000000001 * var_ICaL__ibarca))) : (1.0)) * var_chaste_interface__Irel__ri * var_chaste_interface__Irel__ro; // mM_per_ms
        const double var_cell__AF = 5.0619267243613002e-10 * M_PI; // uF_mole_per_C
        const double var_cell__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell__vjsr = 0.0047999999999999996 * var_cell__vcell; // uL
        const double var_cell__vss = 0.02 * var_cell__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_ss = (-var_Idiff_Itr__idiff + var_Irel__irelcicr * var_cell__vjsr / var_cell__vss - 0.5 * var_ICaL__ICaL * var_cell__AF / var_cell__vss) / (1.0 + 0.0097788000000000007 / pow((0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss), 2) + 4.0890000000000003e-5 / pow((0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss), 2)); // mM / ms

        return d_dt_chaste_interface_var_Ca__Ca_ss;
    }

    double Cellhund_rudy_2004_aFromCellMLGRL2Opt::EvaluatePartialDerivative28(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -85.781844107117
            double var_chaste_interface__Ca__Ca_i = rY[1];
            // Units: mM; Initial value: 0.00012131666
            double var_chaste_interface__ICaL__d = rY[5];
            // Units: dimensionless; Initial value: 1.64013e-06
            double var_chaste_interface__ICaL__dp = rY[6];
            // Units: dimensionless; Initial value: 8.98230672628
            double var_chaste_interface__ICaL__f = rY[7];
            // Units: dimensionless; Initial value: 0.999961508634
            double var_chaste_interface__ICaL__fca = rY[8];
            // Units: dimensionless; Initial value: 0.97836624923
            double var_chaste_interface__ICaL__fca2 = rY[9];
            // Units: dimensionless; Initial value: 0.893052931249
            double var_chaste_interface__ICaL__f2 = rY[10];
            // Units: dimensionless; Initial value: 0.992234519148
            double var_chaste_interface__Irel__ro = rY[21];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__Irel__ri = rY[22];
            // Units: dimensionless; Initial value: 0.862666650318
            double var_chaste_interface__Ca__Ca_jsr = rY[26];
            // Units: mM; Initial value: 1.737580994071
            double var_chaste_interface__Ca__Ca_ss = rY[28];
            // Units: mM; Initial value: 0.00012271265
            
            const double var_x5 = 0.074871767015599999 * var_chaste_interface__cell__V;
            const double var_x94 = pow(var_chaste_interface__ICaL__d, var_chaste_interface__ICaL__dp);
            const double var_x95 = exp(-1.1230765052339999 + var_x5);
            const double var_x96 = var_x95 * var_chaste_interface__Ca__Ca_ss;
            const double var_x97 = -0.61380000000000001 + var_x96;
            const double var_x98 = -1.0 + var_x95;
            const double var_x99 = mParameters[0] / var_x98;
            const double var_x100 = var_x97 * var_x99;
            const double var_x101 = var_x100 * var_x94 * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__f2 * var_chaste_interface__ICaL__fca2;
            const double var_x106 = -15.0 + var_chaste_interface__cell__V;
            const double var_x107 = var_x106 * var_x94 * var_chaste_interface__ICaL__f * var_chaste_interface__ICaL__fca2;
            const double var_x108 = var_x107 * var_chaste_interface__ICaL__fca;
            const double var_x135 = var_x101 * var_x106;
            const double var_x156 = var_x95 * var_x99;
            const double var_x157 = var_x156 * var_chaste_interface__ICaL__f2;
            const double var_x246 = var_x135 * var_chaste_interface__ICaL__fca;
            const double var_x261 = var_x108 * var_x157;
            const double var_x407 = 0.70217303721661617 * var_x100;
            const double var_x409 = exp(2.6000000000000001 + var_x106 * var_x407);
            const double var_x410 = 1.0 + var_x409;
            const double var_x411 = -var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_jsr;
            const double var_x412 = var_x411 * var_chaste_interface__Irel__ro;
            const double var_x413 = var_x409 * var_x412 * var_chaste_interface__Irel__ri / pow(var_x410, 2);
            const double var_x415 = 1 / var_x410;
            const double var_x416 = var_x415 * var_chaste_interface__Irel__ri;
            const double var_x419 = var_x416 * var_chaste_interface__Irel__ro;
            const double var_x422 = var_x106 * var_x156 * var_x413;
            const double var_x427 = 0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss;
            const double var_x428 = 0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss;
            const double var_x429 = 1.0 + 0.0097788000000000007 / pow(var_x427, 2) + 4.0890000000000003e-5 / pow(var_x428, 2);
            const double var_x430 = 1 / var_x429;
            const double var_x431 = var_x430;
            const double var_x434 = 719.99999999999989 * var_x419;
            
            partialF = var_x431 * (-5.0 - var_x434 - 0.0036718475849305066 * var_x261 - 505.56458679596358 * var_x422) + (0.019557600000000001 / pow(var_x427, 3) + 8.1780000000000006e-5 / pow(var_x428, 3)) * (5.0 * var_chaste_interface__Ca__Ca_i - 5.0 * var_chaste_interface__Ca__Ca_ss - 0.0036718475849305066 * var_x246 + var_x411 * var_x434) / pow(var_x429, 2);
        }
        else
        {
            const double y_save = rY[28];
            rY[28] += delta;
            const double temp = EvaluateYDerivative28(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[28])/delta;
            rY[28] = y_save;
        }
        return partialF;
    }

    std::vector<double> Cellhund_rudy_2004_aFromCellMLGRL2Opt::ComputeDerivedQuantities(double var_chaste_interface__Environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__Environment__time;
        dqs[1] = var_cell__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellhund_rudy_2004_aFromCellMLGRL2Opt>::Initialise(void)
{
    this->mSystemName = "hund_rudy_2004";
    this->mFreeVariableName = "Environment__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-85.781844107117);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.00012131666);

    // rY[2]:
    this->mVariableNames.push_back("INa__H");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.987317750543);

    // rY[3]:
    this->mVariableNames.push_back("INa__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001356538159);

    // rY[4]:
    this->mVariableNames.push_back("INa__J");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.991924983076);

    // rY[5]:
    this->mVariableNames.push_back("ICaL__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.64013e-06);

    // rY[6]:
    this->mVariableNames.push_back("ICaL__dp");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.98230672628);

    // rY[7]:
    this->mVariableNames.push_back("ICaL__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999961508634);

    // rY[8]:
    this->mVariableNames.push_back("ICaL__fca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.97836624923);

    // rY[9]:
    this->mVariableNames.push_back("ICaL__fca2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.893052931249);

    // rY[10]:
    this->mVariableNames.push_back("ICaL__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.992234519148);

    // rY[11]:
    this->mVariableNames.push_back("IKr__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.24074e-06);

    // rY[12]:
    this->mVariableNames.push_back("IKs__xs1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.019883138161);

    // rY[13]:
    this->mVariableNames.push_back("IKs__xs2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.019890650554);

    // rY[14]:
    this->mVariableNames.push_back("Ito__ydv");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.013970786703);

    // rY[15]:
    this->mVariableNames.push_back("Ito__ydv2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99996472752);

    // rY[16]:
    this->mVariableNames.push_back("Ito__zdv");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.829206149767);

    // rY[17]:
    this->mVariableNames.push_back("Ito2__AA");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000816605172);

    // rY[18]:
    this->mVariableNames.push_back("INal__mL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001356538159);

    // rY[19]:
    this->mVariableNames.push_back("INal__hL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.26130711759);

    // rY[20]:
    this->mVariableNames.push_back("Irel__CaMKtrap");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.021123704774);

    // rY[21]:
    this->mVariableNames.push_back("Irel__ro");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[22]:
    this->mVariableNames.push_back("Irel__ri");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.862666650318);

    // rY[23]:
    this->mVariableNames.push_back("Na__Na_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(12.972433387269);

    // rY[24]:
    this->mVariableNames.push_back("K__K_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(135.469546216758);

    // rY[25]:
    this->mVariableNames.push_back("Cl__Cl_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(15.59207157178);

    // rY[26]:
    this->mVariableNames.push_back("Ca__Ca_jsr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.737580994071);

    // rY[27]:
    this->mVariableNames.push_back("Ca__Ca_nsr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.832822335168);

    // rY[28]:
    this->mVariableNames.push_back("Ca__Ca_ss");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.00012271265);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("dimensionless");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("Environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellhund_rudy_2004_aFromCellMLGRL2Opt)

