//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: bondarenko_model_2004_apex
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "bondarenko_model_2004_apex.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -80.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 0.5; // millisecond
        const double var_chaste_interface__membrane__stim_period = 71.430000000000007; // millisecond
        const double var_chaste_interface__membrane__stim_start = 20.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::Cellbondarenko_model_2004_apexFromCellMLGRL2Opt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                41,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellbondarenko_model_2004_apexFromCellMLGRL2Opt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
    }

    Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::~Cellbondarenko_model_2004_apexFromCellMLGRL2Opt()
    {
    }
    
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__potassium_concentration__Ki = rY[27];
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) / (0.25 + pow(var_chaste_interface__calcium_concentration__Cai, 2)); // picoA_per_picoF
        const double var_L_type_calcium_current__i_CaL = 0.1729 * (-63.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O; // picoA_per_picoF
        const double var_calcium_activated_chloride_current__i_ClCa = 2.0 * (40.0 + var_chaste_interface__membrane__V) * var_chaste_interface__calcium_concentration__Cai / ((1.0 + exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V)) * (10.0 + var_chaste_interface__calcium_concentration__Cai)); // picoA_per_picoF
        const double var_calcium_background_current__i_Cab = 0.00036699999999999998 * var_chaste_interface__membrane__V - 0.0047112379481865285 * log(1800.0 / var_chaste_interface__calcium_concentration__Cai); // picoA_per_picoF
        const double var_fast_transient_outward_potassium_current__E_K = 25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki); // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = 0.40670000000000001 * pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = 0.050000000000000003 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = 0.0057499999999999999 * pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V); // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__i_Kto_s = 0; // picoA_per_picoF
        const double var_fast_sodium_current__E_Na = 25.674321243523316 * log(140600.0 / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)); // millivolt
        const double var_fast_sodium_current__i_Na = 13.0 * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = 0.078 * (-25.674321243523316 * log(8257.1428571428569 / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = 0.0025999999999999999 * var_chaste_interface__membrane__V - 0.0025999999999999999 * var_fast_sodium_current__E_Na; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = 2.6970585464294846e-17 * (1800.0 * pow(var_chaste_interface__sodium_concentration__Nai, 3) * exp(0.013632298072467722 * var_chaste_interface__membrane__V) - 2744000000000000.0 * var_chaste_interface__calcium_concentration__Cai * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) / (1.0 + 0.10000000000000001 * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = 0.68869565217391304 / ((1.0 + 3043189.1166997822 * pow(1 / var_chaste_interface__sodium_concentration__Nai, 1.5)) * (1.0 + 0.1245 * exp(-0.0038949423064193493 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.038949423064193495 * var_chaste_interface__membrane__V))); // picoA_per_picoF
        const double var_time_independent_potassium_current__i_K1 = 0.28280213903743318 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = 0.16 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        const double var_chaste_interface__i_ionic = (var_L_type_calcium_current__i_CaL + var_calcium_activated_chloride_current__i_ClCa + var_calcium_background_current__i_Cab + var_calcium_pump_current__i_pCa + var_fast_sodium_current__i_Na + var_fast_transient_outward_potassium_current__i_Kto_f + var_non_inactivating_steady_state_potassium_current__i_Kss + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_slow_delayed_rectifier_potassium_current__i_Ks + var_slow_transient_outward_potassium_current__i_Kto_s + var_sodium_background_current__i_Nab + var_sodium_calcium_exchange_current__i_NaCa + var_sodium_potassium_pump_current__i_NaK + var_time_independent_potassium_current__i_K1 + var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__potassium_concentration__Ki = rY[27];
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) / (0.25 + pow(var_chaste_interface__calcium_concentration__Cai, 2)); // picoA_per_picoF
        const double var_L_type_calcium_current__i_CaL = 0.1729 * (-63.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O; // picoA_per_picoF
        const double var_calcium_background_current__i_Cab = 0.00036699999999999998 * var_chaste_interface__membrane__V - 0.0047112379481865285 * log(1800.0 / var_chaste_interface__calcium_concentration__Cai); // picoA_per_picoF
        const double var_fast_transient_outward_potassium_current__E_K = 25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki); // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = 0.40670000000000001 * pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = 0.050000000000000003 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = 0.0057499999999999999 * pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V); // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__i_Kto_s = 0; // picoA_per_picoF
        const double var_fast_sodium_current__E_Na = 25.674321243523316 * log(140600.0 / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)); // millivolt
        const double var_fast_sodium_current__i_Na = 13.0 * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = 0.078 * (-25.674321243523316 * log(8257.1428571428569 / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = 0.0025999999999999999 * var_chaste_interface__membrane__V - 0.0025999999999999999 * var_fast_sodium_current__E_Na; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = 2.6970585464294846e-17 * (1800.0 * pow(var_chaste_interface__sodium_concentration__Nai, 3) * exp(0.013632298072467722 * var_chaste_interface__membrane__V) - 2744000000000000.0 * var_chaste_interface__calcium_concentration__Cai * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) / (1.0 + 0.10000000000000001 * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = 0.68869565217391304 / ((1.0 + 3043189.1166997822 * pow(1 / var_chaste_interface__sodium_concentration__Nai, 1.5)) * (1.0 + 0.1245 * exp(-0.0038949423064193493 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.038949423064193495 * var_chaste_interface__membrane__V))); // picoA_per_picoF
        const double var_time_independent_potassium_current__i_K1 = 0.28280213903743318 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = 0.16 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        d_dt_chaste_interface_var_membrane__V = -var_L_type_calcium_current__i_CaL - var_calcium_background_current__i_Cab - var_calcium_pump_current__i_pCa - var_fast_sodium_current__i_Na - var_fast_transient_outward_potassium_current__i_Kto_f - var_non_inactivating_steady_state_potassium_current__i_Kss - var_rapid_delayed_rectifier_potassium_current__i_Kr - var_slow_delayed_rectifier_potassium_current__i_Ks - var_slow_transient_outward_potassium_current__i_Kto_s - var_sodium_background_current__i_Nab - var_sodium_calcium_exchange_current__i_NaCa - var_sodium_potassium_pump_current__i_NaK - var_time_independent_potassium_current__i_K1 - var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur - GetIntracellularAreaStimulus(var_chaste_interface__environment__time) / HeartConfig::Instance()->GetCapacitance() - 2.0 * (40.0 + var_chaste_interface__membrane__V) * var_chaste_interface__calcium_concentration__Cai / ((1.0 + exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V)) * (10.0 + var_chaste_interface__calcium_concentration__Cai)); // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__CaJSR = rY[3];
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_concentration__CaNSR = rY[4];
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_fluxes__P_RyR = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__calcium_buffering__LTRPN_Ca = rY[6];
        // Units: micromolar; Initial value: 11.2684
        double var_chaste_interface__calcium_buffering__HTRPN_Ca = rY[7];
        // Units: micromolar; Initial value: 125.29
        double var_chaste_interface__ryanodine_receptors__P_O1 = rY[8];
        // Units: dimensionless; Initial value: 1.49102e-05
        double var_chaste_interface__ryanodine_receptors__P_O2 = rY[9];
        // Units: dimensionless; Initial value: 9.51726e-11
        double var_chaste_interface__ryanodine_receptors__P_C2 = rY[10];
        // Units: dimensionless; Initial value: 0.00016774
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__L_type_calcium_current__C2 = rY[12];
        // Units: dimensionless; Initial value: 0.000124216
        double var_chaste_interface__L_type_calcium_current__C3 = rY[13];
        // Units: dimensionless; Initial value: 5.78679e-09
        double var_chaste_interface__L_type_calcium_current__C4 = rY[14];
        // Units: dimensionless; Initial value: 1.19816e-13
        double var_chaste_interface__L_type_calcium_current__I1 = rY[15];
        // Units: dimensionless; Initial value: 4.97923e-19
        double var_chaste_interface__L_type_calcium_current__I2 = rY[16];
        // Units: dimensionless; Initial value: 3.45847e-14
        double var_chaste_interface__L_type_calcium_current__I3 = rY[17];
        // Units: dimensionless; Initial value: 1.85106e-14
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__fast_sodium_current__C_Na1 = rY[20];
        // Units: dimensionless; Initial value: 0.000279132
        double var_chaste_interface__fast_sodium_current__C_Na2 = rY[21];
        // Units: dimensionless; Initial value: 0.020752
        double var_chaste_interface__fast_sodium_current__I1_Na = rY[22];
        // Units: dimensionless; Initial value: 6.73345e-07
        double var_chaste_interface__fast_sodium_current__I2_Na = rY[23];
        // Units: dimensionless; Initial value: 1.55787e-09
        double var_chaste_interface__fast_sodium_current__IF_Na = rY[24];
        // Units: dimensionless; Initial value: 0.000153176
        double var_chaste_interface__fast_sodium_current__IC_Na2 = rY[25];
        // Units: dimensionless; Initial value: 0.0113879
        double var_chaste_interface__fast_sodium_current__IC_Na3 = rY[26];
        // Units: dimensionless; Initial value: 0.34278
        double var_chaste_interface__potassium_concentration__Ki = rY[27];
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_transient_outward_potassium_current__ato_s = rY[30];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__slow_transient_outward_potassium_current__ito_s = rY[31];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 = rY[38];
        // Units: dimensionless; Initial value: 0.000992513
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 = rY[39];
        // Units: dimensionless; Initial value: 0.000641229
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K = rY[40];
        // Units: dimensionless; Initial value: 3.19129e-05
        
        
        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__iKss = 0; // 1 / millisecond
        const double var_L_type_calcium_current__gamma = 0.23324 * var_chaste_interface__calcium_concentration__Cass / (20.0 + var_chaste_interface__calcium_concentration__Cass); // per_millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__HTRPN_Ca = -3.1999999999999999e-5 * var_chaste_interface__calcium_buffering__HTRPN_Ca + 0.0023700000000000001 * (140.0 - var_chaste_interface__calcium_buffering__HTRPN_Ca) * var_chaste_interface__calcium_concentration__Cai; // micromolar / millisecond
        const double d_dt_chaste_interface_var_calcium_buffering__LTRPN_Ca = -0.019599999999999999 * var_chaste_interface__calcium_buffering__LTRPN_Ca + 0.0327 * (70.0 - var_chaste_interface__calcium_buffering__LTRPN_Ca) * var_chaste_interface__calcium_concentration__Cai; // micromolar / millisecond
        const double var_calcium_fluxes__J_tr = 0.050000000000000003 * var_chaste_interface__calcium_concentration__CaNSR - 0.050000000000000003 * var_chaste_interface__calcium_concentration__CaJSR; // micromolar_per_millisecond
        const double var_calcium_fluxes__J_xfer = 0.125 * var_chaste_interface__calcium_concentration__Cass - 0.125 * var_chaste_interface__calcium_concentration__Cai; // micromolar_per_millisecond
        const double var_calcium_fluxes__J_leak = 1.7399999999999999e-5 * var_chaste_interface__calcium_concentration__CaNSR - 1.7399999999999999e-5 * var_chaste_interface__calcium_concentration__Cai; // micromolar_per_millisecond
        const double var_calcium_fluxes__J_up = 0.45000000000000001 * pow(var_chaste_interface__calcium_concentration__Cai, 2) / (0.25 + pow(var_chaste_interface__calcium_concentration__Cai, 2)); // micromolar_per_millisecond
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) / (0.25 + pow(var_chaste_interface__calcium_concentration__Cai, 2)); // picoA_per_picoF
        const double var_fast_sodium_current__C_Na3 = 1.0 - var_chaste_interface__fast_sodium_current__C_Na1 - var_chaste_interface__fast_sodium_current__C_Na2 - var_chaste_interface__fast_sodium_current__I1_Na - var_chaste_interface__fast_sodium_current__I2_Na - var_chaste_interface__fast_sodium_current__IC_Na2 - var_chaste_interface__fast_sodium_current__IC_Na3 - var_chaste_interface__fast_sodium_current__IF_Na - var_chaste_interface__fast_sodium_current__O_Na; // dimensionless
        const double var_L_type_calcium_current__Kpcf = 13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2)); // per_millisecond
        const double var_L_type_calcium_current__alpha = 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_current__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C2 = -var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__beta + 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__beta + 4.0 * (1.0 - var_chaste_interface__L_type_calcium_current__C3 - var_chaste_interface__L_type_calcium_current__C4 - var_chaste_interface__L_type_calcium_current__I1 - var_chaste_interface__L_type_calcium_current__I2 - var_chaste_interface__L_type_calcium_current__I3 - var_chaste_interface__L_type_calcium_current__O - 2 * var_chaste_interface__L_type_calcium_current__C2) * var_L_type_calcium_current__alpha - 3.0 * var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__alpha; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C3 = 3.0 * var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__alpha + 3.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__beta - 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__alpha - 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C4 = -var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha + 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__alpha + 4.0 * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__beta + 0.002 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__beta + 0.0080000000000000002 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__beta + 2.0000000000000002e-5 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__beta - 3.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__beta - 0.002 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf - 1.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__gamma - 0.01 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha * var_L_type_calcium_current__gamma; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I1 = -0.00050000000000000001 * var_chaste_interface__L_type_calcium_current__I1 + var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__gamma + 0.001 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__alpha - 0.001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf + 0.01 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha * var_L_type_calcium_current__gamma - 0.040000000000000001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I2 = 0.00050000000000000001 * var_chaste_interface__L_type_calcium_current__I3 - var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__gamma + 0.001 * var_L_type_calcium_current__Kpcf * var_chaste_interface__L_type_calcium_current__O + 0.002 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf - 0.001 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__alpha - 0.0080000000000000002 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__beta; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I3 = -0.00050000000000000001 * var_chaste_interface__L_type_calcium_current__I3 + var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__gamma + 0.001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf - 0.001 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__alpha - 0.002 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__beta + var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__gamma; // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__O = 0.00050000000000000001 * var_chaste_interface__L_type_calcium_current__I1 + var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha - var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__gamma + 0.001 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__alpha - 4.0 * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__beta - 0.001 * var_L_type_calcium_current__Kpcf * var_chaste_interface__L_type_calcium_current__O; // 1 / millisecond
        const double var_L_type_calcium_current__i_CaL = 0.1729 * (-63.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O; // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_fluxes__P_RyR = -0.040000000000000001 * var_chaste_interface__calcium_fluxes__P_RyR - 0.014285714285714287 * var_L_type_calcium_current__i_CaL * exp(-0.038580246913580245 * pow((-1 + 0.20000000000000001 * var_chaste_interface__membrane__V), 2)); // 1 / millisecond
        const double var_calcium_background_current__i_Cab = 0.00036699999999999998 * var_chaste_interface__membrane__V - 0.0047112379481865285 * log(1800.0 / var_chaste_interface__calcium_concentration__Cai); // picoA_per_picoF
        const double var_fast_sodium_current__alpha_Na11 = 3.802 / (0.20000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na12 = 3.802 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na13 = 3.802 / (0.25 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na2 = 1 / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na3 = 6.9999999999999997e-7 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__alpha_Na4 = 0.001 * var_fast_sodium_current__alpha_Na2; // per_millisecond
        const double var_fast_sodium_current__alpha_Na5 = 1.0526315789473684e-5 * var_fast_sodium_current__alpha_Na2; // per_millisecond
        const double var_fast_sodium_current__beta_Na11 = 0.19170000000000001 * exp(-0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na12 = 0.20000000000000001 * exp(0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na13 = 0.22 * exp(0.36945812807881773 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na3 = 0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__C_Na1 = var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__alpha_Na12 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na3 + var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__beta_Na13 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__alpha_Na13 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na3; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__C_Na2 = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na12 + var_fast_sodium_current__C_Na3 * var_fast_sodium_current__alpha_Na11 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__alpha_Na12 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na11 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na3; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IC_Na2 = var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na11 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na12 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__beta_Na11; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IC_Na3 = var_fast_sodium_current__C_Na3 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__beta_Na11 - var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na11 - var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na3; // 1 / millisecond
        const double var_fast_sodium_current__beta_Na2 = var_fast_sodium_current__alpha_Na13 * var_fast_sodium_current__alpha_Na2 * var_fast_sodium_current__alpha_Na3 / (var_fast_sodium_current__beta_Na13 * var_fast_sodium_current__beta_Na3); // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__O_Na = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__alpha_Na13 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na2 - var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__alpha_Na2 - var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__beta_Na13; // 1 / millisecond
        const double var_fast_sodium_current__beta_Na4 = var_fast_sodium_current__alpha_Na3; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IF_Na = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__beta_Na4 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na12 + var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__alpha_Na2 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na4 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na2; // 1 / millisecond
        const double var_fast_sodium_current__beta_Na5 = 0.02 * var_fast_sodium_current__alpha_Na3; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__I1_Na = var_chaste_interface__fast_sodium_current__I2_Na * var_fast_sodium_current__beta_Na5 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na4 - var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__alpha_Na5 - var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__beta_Na4; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__I2_Na = var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__alpha_Na5 - var_chaste_interface__fast_sodium_current__I2_Na * var_fast_sodium_current__beta_Na5; // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_transient_outward_potassium_current__ato_f = 0.18064 * (1.0 - var_chaste_interface__fast_transient_outward_potassium_current__ato_f) * exp(1.0731000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V) - 0.39560000000000001 * var_chaste_interface__fast_transient_outward_potassium_current__ato_f * exp(-1.8711 - 0.062370000000000002 * var_chaste_interface__membrane__V); // 1 / millisecond
        const double d_dt_chaste_interface_var_fast_transient_outward_potassium_current__ito_f = 0.00015200000000000001 * (1.0 - var_chaste_interface__fast_transient_outward_potassium_current__ito_f) * exp(-1.9285714285714286 - 0.14285714285714285 * var_chaste_interface__membrane__V) / (1.0 + 0.0067083000000000004 * exp(-4.7857142857142856 - 0.14285714285714285 * var_chaste_interface__membrane__V)) - 0.00095 * var_chaste_interface__fast_transient_outward_potassium_current__ito_f * exp(4.7857142857142856 + 0.14285714285714285 * var_chaste_interface__membrane__V) / (1.0 + 0.051334999999999999 * exp(4.7857142857142856 + 0.14285714285714285 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__CaNSR = 12.316491897044804 * var_calcium_fluxes__J_up - 12.316491897044804 * var_calcium_fluxes__J_leak - 0.057197330791229732 * var_calcium_fluxes__J_tr; // micromolar / millisecond
        const double var_fast_transient_outward_potassium_current__E_K = 25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki); // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = 0.40670000000000001 * pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = 0.050000000000000003 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__alpha_a1 = 0.013733 * exp(0.038198000000000003 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__alpha_i = 0.090820999999999999 * exp(0.11695499999999999 + 0.023390999999999999 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_a1 = 6.8899999999999994e-5 * exp(-0.041779999999999998 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_i = 0.0064970000000000002 * exp(-0.16339999999999999 - 0.032680000000000001 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__I_K = var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__alpha_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K * var_rapid_delayed_rectifier_potassium_current__beta_i; // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__O_K = var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__alpha_a1 + var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K * var_rapid_delayed_rectifier_potassium_current__beta_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__alpha_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__beta_a1; // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K1 = 0.036777999999999998 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 - 0.023761000000000001 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 + 0.022348 * (1.0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K) * exp(0.01176 * var_chaste_interface__membrane__V) - 0.047002000000000002 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 * exp(-0.063100000000000003 * var_chaste_interface__membrane__V); // 1 / millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K2 = 0.023761000000000001 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 - 0.036777999999999998 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 + var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__beta_a1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__alpha_a1; // 1 / millisecond
        const double var_calcium_fluxes__J_rel = 4.5 * (-var_chaste_interface__calcium_concentration__Cass + var_chaste_interface__calcium_concentration__CaJSR) * (var_chaste_interface__ryanodine_receptors__P_O1 + var_chaste_interface__ryanodine_receptors__P_O2) * var_chaste_interface__calcium_fluxes__P_RyR; // micromolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__CaJSR = (-var_calcium_fluxes__J_rel + var_calcium_fluxes__J_tr) / (1.0 + 18.75 / pow((1 + 0.00125 * var_chaste_interface__calcium_concentration__CaJSR), 2)); // micromolar / millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__Cass = (80.808080808080803 * var_calcium_fluxes__J_rel - 535.23141606043157 * var_L_type_calcium_current__i_CaL - 17400.6734006734 * var_calcium_fluxes__J_xfer) / (1.0 + 11.899999999999999 / pow((0.23799999999999999 + var_chaste_interface__calcium_concentration__Cass), 2)); // micromolar / millisecond
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_C2 = 0.0089999999999999993 * var_chaste_interface__ryanodine_receptors__P_O1 - 0.00080000000000000004 * var_chaste_interface__ryanodine_receptors__P_C2; // 1 / millisecond
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_O2 = -0.96499999999999997 * var_chaste_interface__ryanodine_receptors__P_O2 + 0.0040499999999999998 * pow(var_chaste_interface__calcium_concentration__Cass, 3.0) * var_chaste_interface__ryanodine_receptors__P_O1; // 1 / millisecond
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_O1 = 0.00080000000000000004 * var_chaste_interface__ryanodine_receptors__P_C2 + 0.96499999999999997 * var_chaste_interface__ryanodine_receptors__P_O2 - 0.080249999999999988 * var_chaste_interface__ryanodine_receptors__P_O1 + 0.0060749999999999997 * pow(var_chaste_interface__calcium_concentration__Cass, 4.0) * (1.0 - var_chaste_interface__ryanodine_receptors__P_C2 - var_chaste_interface__ryanodine_receptors__P_O1 - var_chaste_interface__ryanodine_receptors__P_O2) - 0.0040499999999999998 * pow(var_chaste_interface__calcium_concentration__Cass, 3.0) * var_chaste_interface__ryanodine_receptors__P_O1; // 1 / millisecond
        const double d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current__nKs = -9.5333299999999997e-5 * var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs * exp(-1.0069999999999999 - 0.037999999999999999 * var_chaste_interface__membrane__V) + 4.8133299999999997e-6 * (1.0 - var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs) * (26.5 + var_chaste_interface__membrane__V) / (1.0 - exp(-3.3919999999999999 - 0.128 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = 0.0057499999999999999 * pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V); // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__ass = 1 / (1.0 + exp(-2.9220779220779218 - 0.12987012987012986 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__aKss = (-var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss + var_slow_transient_outward_potassium_current__ass) / (13.17 + 39.299999999999997 * exp(-0.086199999999999999 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double var_slow_transient_outward_potassium_current__iss = 1 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_transient_outward_potassium_current__i_Kto_s = 0; // picoA_per_picoF
        const double d_dt_chaste_interface_var_slow_transient_outward_potassium_current__ato_s = (-var_chaste_interface__slow_transient_outward_potassium_current__ato_s + var_slow_transient_outward_potassium_current__ass) / (2.0579999999999998 + 0.49299999999999999 * exp(-0.062899999999999998 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_slow_transient_outward_potassium_current__ito_s = (-var_chaste_interface__slow_transient_outward_potassium_current__ito_s + var_slow_transient_outward_potassium_current__iss) / (270.0 + 1050.0 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double var_fast_sodium_current__E_Na = 25.674321243523316 * log(140600.0 / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)); // millivolt
        const double var_fast_sodium_current__i_Na = 13.0 * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = 0.078 * (-25.674321243523316 * log(8257.1428571428569 / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = 0.0025999999999999999 * var_chaste_interface__membrane__V - 0.0025999999999999999 * var_fast_sodium_current__E_Na; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = 2.6970585464294846e-17 * (1800.0 * pow(var_chaste_interface__sodium_concentration__Nai, 3) * exp(0.013632298072467722 * var_chaste_interface__membrane__V) - 2744000000000000.0 * var_chaste_interface__calcium_concentration__Cai * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) / (1.0 + 0.10000000000000001 * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_concentration__Cai = (-var_calcium_fluxes__J_up + 0.019599999999999999 * var_chaste_interface__calcium_buffering__LTRPN_Ca + 3.1999999999999999e-5 * var_chaste_interface__calcium_buffering__HTRPN_Ca + 0.061518471582797281 * var_sodium_calcium_exchange_current__i_NaCa - 0.03075923579139864 * var_calcium_background_current__i_Cab - 0.03075923579139864 * var_calcium_pump_current__i_pCa - 0.0327 * (70.0 - var_chaste_interface__calcium_buffering__LTRPN_Ca) * var_chaste_interface__calcium_concentration__Cai - 0.0023700000000000001 * (140.0 - var_chaste_interface__calcium_buffering__HTRPN_Ca) * var_chaste_interface__calcium_concentration__Cai + var_calcium_fluxes__J_leak + var_calcium_fluxes__J_xfer) / (1.0 + 11.899999999999999 / pow((0.23799999999999999 + var_chaste_interface__calcium_concentration__Cai), 2)); // micromolar / millisecond
        const double var_sodium_potassium_pump_current__i_NaK = 0.68869565217391304 / ((1.0 + 3043189.1166997822 * pow(1 / var_chaste_interface__sodium_concentration__Nai, 1.5)) * (1.0 + 0.1245 * exp(-0.0038949423064193493 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.038949423064193495 * var_chaste_interface__membrane__V))); // picoA_per_picoF
        const double d_dt_chaste_interface_var_sodium_concentration__Nai = -0.18455541474839185 * var_sodium_calcium_exchange_current__i_NaCa - 0.18455541474839185 * var_sodium_potassium_pump_current__i_NaK - 0.061518471582797281 * var_fast_sodium_current__i_Na - 0.061518471582797281 * var_sodium_background_current__i_Nab; // micromolar / millisecond
        const double var_time_independent_potassium_current__i_K1 = 0.28280213903743318 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = 0.16 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        const double d_dt_chaste_interface_var_potassium_concentration__Ki = 0.12303694316559456 * var_sodium_potassium_pump_current__i_NaK - 0.061518471582797281 * var_fast_transient_outward_potassium_current__i_Kto_f - 0.061518471582797281 * var_non_inactivating_steady_state_potassium_current__i_Kss - 0.061518471582797281 * var_rapid_delayed_rectifier_potassium_current__i_Kr - 0.061518471582797281 * var_slow_delayed_rectifier_potassium_current__i_Ks - 0.061518471582797281 * var_slow_transient_outward_potassium_current__i_Kto_s - 0.061518471582797281 * var_time_independent_potassium_current__i_K1 - 0.061518471582797281 * var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur; // micromolar / millisecond
        const double d_dt_chaste_interface_var_ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = (-var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur + var_slow_transient_outward_potassium_current__ass) / (2.0579999999999998 + 0.49299999999999999 * exp(-0.062899999999999998 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = (-var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur + var_slow_transient_outward_potassium_current__iss) / (1200.0 - 170.0 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V))); // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__V = -var_L_type_calcium_current__i_CaL - var_calcium_background_current__i_Cab - var_calcium_pump_current__i_pCa - var_fast_sodium_current__i_Na - var_fast_transient_outward_potassium_current__i_Kto_f - var_non_inactivating_steady_state_potassium_current__i_Kss - var_rapid_delayed_rectifier_potassium_current__i_Kr - var_slow_delayed_rectifier_potassium_current__i_Ks - var_slow_transient_outward_potassium_current__i_Kto_s - var_sodium_background_current__i_Nab - var_sodium_calcium_exchange_current__i_NaCa - var_sodium_potassium_pump_current__i_NaK - var_time_independent_potassium_current__i_K1 - var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur - GetIntracellularAreaStimulus(var_chaste_interface__environment__time) / HeartConfig::Instance()->GetCapacitance() - 2.0 * (40.0 + var_chaste_interface__membrane__V) * var_chaste_interface__calcium_concentration__Cai / ((1.0 + exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V)) * (10.0 + var_chaste_interface__calcium_concentration__Cai)); // millivolt / millisecond
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        mEvalF[1] = d_dt_chaste_interface_var_calcium_concentration__Cai;
        mEvalF[2] = d_dt_chaste_interface_var_calcium_concentration__Cass;
        mEvalF[3] = d_dt_chaste_interface_var_calcium_concentration__CaJSR;
        mEvalF[4] = d_dt_chaste_interface_var_calcium_concentration__CaNSR;
        mEvalF[5] = d_dt_chaste_interface_var_calcium_fluxes__P_RyR;
        mEvalF[6] = d_dt_chaste_interface_var_calcium_buffering__LTRPN_Ca;
        mEvalF[7] = d_dt_chaste_interface_var_calcium_buffering__HTRPN_Ca;
        mEvalF[8] = d_dt_chaste_interface_var_ryanodine_receptors__P_O1;
        mEvalF[9] = d_dt_chaste_interface_var_ryanodine_receptors__P_O2;
        mEvalF[10] = d_dt_chaste_interface_var_ryanodine_receptors__P_C2;
        mEvalF[11] = d_dt_chaste_interface_var_L_type_calcium_current__O;
        mEvalF[12] = d_dt_chaste_interface_var_L_type_calcium_current__C2;
        mEvalF[13] = d_dt_chaste_interface_var_L_type_calcium_current__C3;
        mEvalF[14] = d_dt_chaste_interface_var_L_type_calcium_current__C4;
        mEvalF[15] = d_dt_chaste_interface_var_L_type_calcium_current__I1;
        mEvalF[16] = d_dt_chaste_interface_var_L_type_calcium_current__I2;
        mEvalF[17] = d_dt_chaste_interface_var_L_type_calcium_current__I3;
        mEvalF[18] = d_dt_chaste_interface_var_sodium_concentration__Nai;
        mEvalF[19] = d_dt_chaste_interface_var_fast_sodium_current__O_Na;
        mEvalF[20] = d_dt_chaste_interface_var_fast_sodium_current__C_Na1;
        mEvalF[21] = d_dt_chaste_interface_var_fast_sodium_current__C_Na2;
        mEvalF[22] = d_dt_chaste_interface_var_fast_sodium_current__I1_Na;
        mEvalF[23] = d_dt_chaste_interface_var_fast_sodium_current__I2_Na;
        mEvalF[24] = d_dt_chaste_interface_var_fast_sodium_current__IF_Na;
        mEvalF[25] = d_dt_chaste_interface_var_fast_sodium_current__IC_Na2;
        mEvalF[26] = d_dt_chaste_interface_var_fast_sodium_current__IC_Na3;
        mEvalF[27] = d_dt_chaste_interface_var_potassium_concentration__Ki;
        mEvalF[28] = d_dt_chaste_interface_var_fast_transient_outward_potassium_current__ato_f;
        mEvalF[29] = d_dt_chaste_interface_var_fast_transient_outward_potassium_current__ito_f;
        mEvalF[30] = d_dt_chaste_interface_var_slow_transient_outward_potassium_current__ato_s;
        mEvalF[31] = d_dt_chaste_interface_var_slow_transient_outward_potassium_current__ito_s;
        mEvalF[32] = d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current__nKs;
        mEvalF[33] = d_dt_chaste_interface_var_ultra_rapidly_activating_delayed_rectifier_potassium_current__aur;
        mEvalF[34] = d_dt_chaste_interface_var_ultra_rapidly_activating_delayed_rectifier_potassium_current__iur;
        mEvalF[35] = d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__aKss;
        mEvalF[36] = d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__iKss;
        mEvalF[37] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__O_K;
        mEvalF[38] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K1;
        mEvalF[39] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K2;
        mEvalF[40] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__I_K;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time, rY, delta);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time, rY, delta);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time, rY, delta);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time, rY, delta);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time, rY, delta);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time, rY, delta);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time, rY, delta);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time, rY, delta);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time, rY, delta);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time, rY, delta);
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__environment__time, rY, delta);
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__environment__time, rY, delta);
        mPartialF[29] = EvaluatePartialDerivative29(var_chaste_interface__environment__time, rY, delta);
        mPartialF[30] = EvaluatePartialDerivative30(var_chaste_interface__environment__time, rY, delta);
        mPartialF[31] = EvaluatePartialDerivative31(var_chaste_interface__environment__time, rY, delta);
        mPartialF[32] = EvaluatePartialDerivative32(var_chaste_interface__environment__time, rY, delta);
        mPartialF[33] = EvaluatePartialDerivative33(var_chaste_interface__environment__time, rY, delta);
        mPartialF[34] = EvaluatePartialDerivative34(var_chaste_interface__environment__time, rY, delta);
        mPartialF[35] = EvaluatePartialDerivative35(var_chaste_interface__environment__time, rY, delta);
        mPartialF[36] = EvaluatePartialDerivative36(var_chaste_interface__environment__time, rY, delta);
        mPartialF[37] = EvaluatePartialDerivative37(var_chaste_interface__environment__time, rY, delta);
        mPartialF[38] = EvaluatePartialDerivative38(var_chaste_interface__environment__time, rY, delta);
        mPartialF[39] = EvaluatePartialDerivative39(var_chaste_interface__environment__time, rY, delta);
        mPartialF[40] = EvaluatePartialDerivative40(var_chaste_interface__environment__time, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        rY[13] = y_save;
        
        
        y_save = rY[14];
        rY[14] = mYInit[14];
        mEvalF[14] = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        rY[14] = y_save;
        
        
        y_save = rY[15];
        rY[15] = mYInit[15];
        mEvalF[15] = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        rY[15] = y_save;
        
        
        y_save = rY[16];
        rY[16] = mYInit[16];
        mEvalF[16] = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        rY[16] = y_save;
        
        
        y_save = rY[17];
        rY[17] = mYInit[17];
        mEvalF[17] = EvaluateYDerivative17(var_chaste_interface__environment__time, rY);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time, rY, delta);
        rY[17] = y_save;
        
        
        y_save = rY[18];
        rY[18] = mYInit[18];
        mEvalF[18] = EvaluateYDerivative18(var_chaste_interface__environment__time, rY);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time, rY, delta);
        rY[18] = y_save;
        
        
        y_save = rY[19];
        rY[19] = mYInit[19];
        mEvalF[19] = EvaluateYDerivative19(var_chaste_interface__environment__time, rY);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time, rY, delta);
        rY[19] = y_save;
        
        
        y_save = rY[20];
        rY[20] = mYInit[20];
        mEvalF[20] = EvaluateYDerivative20(var_chaste_interface__environment__time, rY);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time, rY, delta);
        rY[20] = y_save;
        
        
        y_save = rY[21];
        rY[21] = mYInit[21];
        mEvalF[21] = EvaluateYDerivative21(var_chaste_interface__environment__time, rY);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time, rY, delta);
        rY[21] = y_save;
        
        
        y_save = rY[22];
        rY[22] = mYInit[22];
        mEvalF[22] = EvaluateYDerivative22(var_chaste_interface__environment__time, rY);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time, rY, delta);
        rY[22] = y_save;
        
        
        y_save = rY[23];
        rY[23] = mYInit[23];
        mEvalF[23] = EvaluateYDerivative23(var_chaste_interface__environment__time, rY);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time, rY, delta);
        rY[23] = y_save;
        
        
        y_save = rY[24];
        rY[24] = mYInit[24];
        mEvalF[24] = EvaluateYDerivative24(var_chaste_interface__environment__time, rY);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time, rY, delta);
        rY[24] = y_save;
        
        
        y_save = rY[25];
        rY[25] = mYInit[25];
        mEvalF[25] = EvaluateYDerivative25(var_chaste_interface__environment__time, rY);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time, rY, delta);
        rY[25] = y_save;
        
        
        y_save = rY[26];
        rY[26] = mYInit[26];
        mEvalF[26] = EvaluateYDerivative26(var_chaste_interface__environment__time, rY);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time, rY, delta);
        rY[26] = y_save;
        
        
        y_save = rY[27];
        rY[27] = mYInit[27];
        mEvalF[27] = EvaluateYDerivative27(var_chaste_interface__environment__time, rY);
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__environment__time, rY, delta);
        rY[27] = y_save;
        
        
        y_save = rY[28];
        rY[28] = mYInit[28];
        mEvalF[28] = EvaluateYDerivative28(var_chaste_interface__environment__time, rY);
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__environment__time, rY, delta);
        rY[28] = y_save;
        
        
        y_save = rY[29];
        rY[29] = mYInit[29];
        mEvalF[29] = EvaluateYDerivative29(var_chaste_interface__environment__time, rY);
        mPartialF[29] = EvaluatePartialDerivative29(var_chaste_interface__environment__time, rY, delta);
        rY[29] = y_save;
        
        
        y_save = rY[30];
        rY[30] = mYInit[30];
        mEvalF[30] = EvaluateYDerivative30(var_chaste_interface__environment__time, rY);
        mPartialF[30] = EvaluatePartialDerivative30(var_chaste_interface__environment__time, rY, delta);
        rY[30] = y_save;
        
        
        y_save = rY[31];
        rY[31] = mYInit[31];
        mEvalF[31] = EvaluateYDerivative31(var_chaste_interface__environment__time, rY);
        mPartialF[31] = EvaluatePartialDerivative31(var_chaste_interface__environment__time, rY, delta);
        rY[31] = y_save;
        
        
        y_save = rY[32];
        rY[32] = mYInit[32];
        mEvalF[32] = EvaluateYDerivative32(var_chaste_interface__environment__time, rY);
        mPartialF[32] = EvaluatePartialDerivative32(var_chaste_interface__environment__time, rY, delta);
        rY[32] = y_save;
        
        
        y_save = rY[33];
        rY[33] = mYInit[33];
        mEvalF[33] = EvaluateYDerivative33(var_chaste_interface__environment__time, rY);
        mPartialF[33] = EvaluatePartialDerivative33(var_chaste_interface__environment__time, rY, delta);
        rY[33] = y_save;
        
        
        y_save = rY[34];
        rY[34] = mYInit[34];
        mEvalF[34] = EvaluateYDerivative34(var_chaste_interface__environment__time, rY);
        mPartialF[34] = EvaluatePartialDerivative34(var_chaste_interface__environment__time, rY, delta);
        rY[34] = y_save;
        
        
        y_save = rY[35];
        rY[35] = mYInit[35];
        mEvalF[35] = EvaluateYDerivative35(var_chaste_interface__environment__time, rY);
        mPartialF[35] = EvaluatePartialDerivative35(var_chaste_interface__environment__time, rY, delta);
        rY[35] = y_save;
        
        
        y_save = rY[36];
        rY[36] = mYInit[36];
        mEvalF[36] = EvaluateYDerivative36(var_chaste_interface__environment__time, rY);
        mPartialF[36] = EvaluatePartialDerivative36(var_chaste_interface__environment__time, rY, delta);
        rY[36] = y_save;
        
        
        y_save = rY[37];
        rY[37] = mYInit[37];
        mEvalF[37] = EvaluateYDerivative37(var_chaste_interface__environment__time, rY);
        mPartialF[37] = EvaluatePartialDerivative37(var_chaste_interface__environment__time, rY, delta);
        rY[37] = y_save;
        
        
        y_save = rY[38];
        rY[38] = mYInit[38];
        mEvalF[38] = EvaluateYDerivative38(var_chaste_interface__environment__time, rY);
        mPartialF[38] = EvaluatePartialDerivative38(var_chaste_interface__environment__time, rY, delta);
        rY[38] = y_save;
        
        
        y_save = rY[39];
        rY[39] = mYInit[39];
        mEvalF[39] = EvaluateYDerivative39(var_chaste_interface__environment__time, rY);
        mPartialF[39] = EvaluatePartialDerivative39(var_chaste_interface__environment__time, rY, delta);
        rY[39] = y_save;
        
        
        y_save = rY[40];
        rY[40] = mYInit[40];
        mEvalF[40] = EvaluateYDerivative40(var_chaste_interface__environment__time, rY);
        mPartialF[40] = EvaluatePartialDerivative40(var_chaste_interface__environment__time, rY, delta);
        rY[40] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__potassium_concentration__Ki = rY[27];
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        
        
        // Mathematics
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) / (0.25 + pow(var_chaste_interface__calcium_concentration__Cai, 2)); // picoA_per_picoF
        const double var_L_type_calcium_current__i_CaL = 0.1729 * (-63.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O; // picoA_per_picoF
        const double var_calcium_background_current__i_Cab = 0.00036699999999999998 * var_chaste_interface__membrane__V - 0.0047112379481865285 * log(1800.0 / var_chaste_interface__calcium_concentration__Cai); // picoA_per_picoF
        const double var_fast_transient_outward_potassium_current__E_K = 25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki); // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = 0.40670000000000001 * pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = 0.050000000000000003 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = 0.0057499999999999999 * pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V); // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__i_Kto_s = 0; // picoA_per_picoF
        const double var_fast_sodium_current__E_Na = 25.674321243523316 * log(140600.0 / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)); // millivolt
        const double var_fast_sodium_current__i_Na = 13.0 * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = 0.078 * (-25.674321243523316 * log(8257.1428571428569 / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = 0.0025999999999999999 * var_chaste_interface__membrane__V - 0.0025999999999999999 * var_fast_sodium_current__E_Na; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = 2.6970585464294846e-17 * (1800.0 * pow(var_chaste_interface__sodium_concentration__Nai, 3) * exp(0.013632298072467722 * var_chaste_interface__membrane__V) - 2744000000000000.0 * var_chaste_interface__calcium_concentration__Cai * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) / (1.0 + 0.10000000000000001 * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = 0.68869565217391304 / ((1.0 + 3043189.1166997822 * pow(1 / var_chaste_interface__sodium_concentration__Nai, 1.5)) * (1.0 + 0.1245 * exp(-0.0038949423064193493 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.038949423064193495 * var_chaste_interface__membrane__V))); // picoA_per_picoF
        const double var_time_independent_potassium_current__i_K1 = 0.28280213903743318 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = 0.16 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        d_dt_chaste_interface_var_membrane__V = -var_L_type_calcium_current__i_CaL - var_calcium_background_current__i_Cab - var_calcium_pump_current__i_pCa - var_fast_sodium_current__i_Na - var_fast_transient_outward_potassium_current__i_Kto_f - var_non_inactivating_steady_state_potassium_current__i_Kss - var_rapid_delayed_rectifier_potassium_current__i_Kr - var_slow_delayed_rectifier_potassium_current__i_Ks - var_slow_transient_outward_potassium_current__i_Kto_s - var_sodium_background_current__i_Nab - var_sodium_calcium_exchange_current__i_NaCa - var_sodium_potassium_pump_current__i_NaK - var_time_independent_potassium_current__i_K1 - var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur - GetIntracellularAreaStimulus(var_chaste_interface__environment__time) / HeartConfig::Instance()->GetCapacitance() - 2.0 * (40.0 + var_chaste_interface__membrane__V) * var_chaste_interface__calcium_concentration__Cai / ((1.0 + exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V)) * (10.0 + var_chaste_interface__calcium_concentration__Cai)); // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane__V;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            double var_chaste_interface__calcium_concentration__Cai = rY[1];
            // Units: micromolar; Initial value: 0.115001
            double var_chaste_interface__L_type_calcium_current__O = rY[11];
            // Units: dimensionless; Initial value: 9.30308e-19
            double var_chaste_interface__sodium_concentration__Nai = rY[18];
            // Units: micromolar; Initial value: 14237.1
            double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
            // Units: dimensionless; Initial value: 7.13483e-07
            double var_chaste_interface__potassium_concentration__Ki = rY[27];
            // Units: micromolar; Initial value: 143720.0
            double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
            // Units: dimensionless; Initial value: 0.00265563
            double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
            // Units: dimensionless; Initial value: 0.999977
            double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
            // Units: dimensionless; Initial value: 0.000262753
            double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
            // Units: dimensionless; Initial value: 0.000417069
            double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
            // Units: dimensionless; Initial value: 0.998543
            double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
            // Units: dimensionless; Initial value: 0.000417069
            double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
            // Units: dimensionless; Initial value: 0.000175298
            
            const double var_x0 = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2);
            const double var_x1 = 1 / var_chaste_interface__potassium_concentration__Ki;
            const double var_x2 = log(5400.0 * var_x1);
            const double var_x3 = exp(0.089599999999999999 * var_chaste_interface__membrane__V - 2.300419183419689 * var_x2);
            const double var_x4 = 1.0 + var_x3;
            const double var_x5 = 1 / var_x4;
            const double var_x6 = var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss;
            const double var_x7 = var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur;
            const double var_x8 = pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3);
            const double var_x9 = 0.40670000000000001 * var_x8;
            const double var_x10 = exp(-0.025317124991725771 * var_chaste_interface__membrane__V);
            const double var_x11 = 1.0 + 0.10000000000000001 * var_x10;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = exp(0.013632298072467722 * var_chaste_interface__membrane__V);
            const double var_x14 = var_x13 * pow(var_chaste_interface__sodium_concentration__Nai, 3);
            const double var_x15 = var_x10 * var_chaste_interface__calcium_concentration__Cai;
            const double var_x16 = var_x12 * (24.5381365304419 * var_x14 + 69470190977295.516 * var_x15);
            const double var_x17 = -25.674321243523316 * var_x2 + var_chaste_interface__membrane__V;
            const double var_x18 = var_x17 * var_x3 / pow(var_x4, 2);
            const double var_x19 = exp(5.9871794871794881 - 0.12820512820512822 * var_chaste_interface__membrane__V);
            const double var_x20 = 1.0 + var_x19;
            const double var_x21 = 1 / var_x20;
            const double var_x22 = var_x21 * var_chaste_interface__calcium_concentration__Cai;
            const double var_x23 = 1 / (10.0 + var_chaste_interface__calcium_concentration__Cai);
            const double var_x24 = 2.0 * var_x23;
            const double var_x25 = 1800.0 * var_x14 - 2744000000000000.0 * var_x15;
            const double var_x26 = var_x10 * var_x25 / pow(var_x11, 2);
            const double var_x27 = 1 / var_chaste_interface__sodium_concentration__Nai;
            const double var_x28 = pow(var_x27, 1.5);
            const double var_x29 = exp(-0.0038949423064193493 * var_chaste_interface__membrane__V);
            const double var_x30 = exp(2.0802377414561666);
            const double var_x31 = exp(-0.038949423064193495 * var_chaste_interface__membrane__V);
            const double var_x32 = 1.0 + 0.1245 * var_x29 + 0.036499999999999998 * var_x31 * (-0.14285714285714285 + 0.14285714285714285 * var_x30);
            const double var_x33 = (0.00048492031714920898 * var_x29 + 0.038949423064193495 * var_x31 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x30)) / (pow(var_x32, 2) * (1.0 + 3043189.1166997822 * var_x28));
            const double var_x34 = 40.0 + var_chaste_interface__membrane__V;
            
            partialF = -0.002967 + 0.025339071657754012 * var_x18 - 13.0 * var_chaste_interface__fast_sodium_current__O_Na - 0.1729 * var_chaste_interface__L_type_calcium_current__O - 0.0057499999999999999 * var_x0 - 0.050000000000000003 * var_x6 - 0.078 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K - 0.16 * var_x7 - 6.8281768329957496e-20 * var_x26 - 0.68869565217391304 * var_x33 - 2.6970585464294846e-17 * var_x16 - 0.28280213903743318 * var_x5 - var_x22 * var_x24 - var_x9 * var_chaste_interface__fast_transient_outward_potassium_current__ito_f - 0.25641025641025644 * var_x19 * var_x23 * var_x34 * var_chaste_interface__calcium_concentration__Cai / pow(var_x20, 2);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__CaNSR = rY[4];
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_buffering__LTRPN_Ca = rY[6];
        // Units: micromolar; Initial value: 11.2684
        double var_chaste_interface__calcium_buffering__HTRPN_Ca = rY[7];
        // Units: micromolar; Initial value: 125.29
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        
        
        // Mathematics
        const double var_calcium_fluxes__J_xfer = 0.125 * var_chaste_interface__calcium_concentration__Cass - 0.125 * var_chaste_interface__calcium_concentration__Cai; // micromolar_per_millisecond
        const double var_calcium_fluxes__J_leak = 1.7399999999999999e-5 * var_chaste_interface__calcium_concentration__CaNSR - 1.7399999999999999e-5 * var_chaste_interface__calcium_concentration__Cai; // micromolar_per_millisecond
        const double var_calcium_fluxes__J_up = 0.45000000000000001 * pow(var_chaste_interface__calcium_concentration__Cai, 2) / (0.25 + pow(var_chaste_interface__calcium_concentration__Cai, 2)); // micromolar_per_millisecond
        const double var_calcium_pump_current__i_pCa = pow(var_chaste_interface__calcium_concentration__Cai, 2) / (0.25 + pow(var_chaste_interface__calcium_concentration__Cai, 2)); // picoA_per_picoF
        const double var_calcium_background_current__i_Cab = 0.00036699999999999998 * var_chaste_interface__membrane__V - 0.0047112379481865285 * log(1800.0 / var_chaste_interface__calcium_concentration__Cai); // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = 2.6970585464294846e-17 * (1800.0 * pow(var_chaste_interface__sodium_concentration__Nai, 3) * exp(0.013632298072467722 * var_chaste_interface__membrane__V) - 2744000000000000.0 * var_chaste_interface__calcium_concentration__Cai * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) / (1.0 + 0.10000000000000001 * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_concentration__Cai = (-var_calcium_fluxes__J_up + 0.019599999999999999 * var_chaste_interface__calcium_buffering__LTRPN_Ca + 3.1999999999999999e-5 * var_chaste_interface__calcium_buffering__HTRPN_Ca + 0.061518471582797281 * var_sodium_calcium_exchange_current__i_NaCa - 0.03075923579139864 * var_calcium_background_current__i_Cab - 0.03075923579139864 * var_calcium_pump_current__i_pCa - 0.0327 * (70.0 - var_chaste_interface__calcium_buffering__LTRPN_Ca) * var_chaste_interface__calcium_concentration__Cai - 0.0023700000000000001 * (140.0 - var_chaste_interface__calcium_buffering__HTRPN_Ca) * var_chaste_interface__calcium_concentration__Cai + var_calcium_fluxes__J_leak + var_calcium_fluxes__J_xfer) / (1.0 + 11.899999999999999 / pow((0.23799999999999999 + var_chaste_interface__calcium_concentration__Cai), 2)); // micromolar / millisecond

        return d_dt_chaste_interface_var_calcium_concentration__Cai;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            double var_chaste_interface__calcium_concentration__Cai = rY[1];
            // Units: micromolar; Initial value: 0.115001
            double var_chaste_interface__calcium_concentration__Cass = rY[2];
            // Units: micromolar; Initial value: 0.115001
            double var_chaste_interface__calcium_concentration__CaNSR = rY[4];
            // Units: micromolar; Initial value: 1299.5
            double var_chaste_interface__calcium_buffering__LTRPN_Ca = rY[6];
            // Units: micromolar; Initial value: 11.2684
            double var_chaste_interface__calcium_buffering__HTRPN_Ca = rY[7];
            // Units: micromolar; Initial value: 125.29
            double var_chaste_interface__sodium_concentration__Nai = rY[18];
            // Units: micromolar; Initial value: 14237.1
            
            const double var_x10 = exp(-0.025317124991725771 * var_chaste_interface__membrane__V);
            const double var_x11 = 1.0 + 0.10000000000000001 * var_x10;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = exp(0.013632298072467722 * var_chaste_interface__membrane__V);
            const double var_x14 = var_x13 * pow(var_chaste_interface__sodium_concentration__Nai, 3);
            const double var_x15 = var_x10 * var_chaste_interface__calcium_concentration__Cai;
            const double var_x25 = 1800.0 * var_x14 - 2744000000000000.0 * var_x15;
            const double var_x35 = 1 / var_chaste_interface__calcium_concentration__Cai;
            const double var_x36 = pow(var_chaste_interface__calcium_concentration__Cai, 2);
            const double var_x37 = 0.25 + var_x36;
            const double var_x38 = pow(var_chaste_interface__calcium_concentration__Cai, 3) / pow(var_x37, 2);
            const double var_x39 = var_x10 * var_x12;
            const double var_x40 = 1 / var_x37;
            const double var_x41 = var_x40 * var_chaste_interface__calcium_concentration__Cai;
            const double var_x61 = 0.23799999999999999 + var_chaste_interface__calcium_concentration__Cai;
            const double var_x62 = pow(var_x61, (-2));
            const double var_x63 = 1 / (1.0 + 11.899999999999999 * var_x62);
            const double var_x64 = 0.0327 * var_chaste_interface__calcium_buffering__LTRPN_Ca;
            const double var_x65 = 0.0023700000000000001 * var_chaste_interface__calcium_buffering__HTRPN_Ca;
            const double var_x66 = 0.0327 * var_chaste_interface__calcium_concentration__Cai;
            const double var_x67 = 0.0023700000000000001 * var_chaste_interface__calcium_concentration__Cai;
            
            partialF = var_x63 * (-2.7458174 + var_x64 + var_x65 + 0.96151847158279735 * var_x38 - 0.0045528151523329874 * var_x39 - 0.96151847158279735 * var_x41 - 0.00014491407891765456 * var_x35) + 0.16806722689075632 * (0.125 * var_chaste_interface__calcium_concentration__Cass + 0.019599999999999999 * var_chaste_interface__calcium_buffering__LTRPN_Ca + 3.1999999999999999e-5 * var_chaste_interface__calcium_buffering__HTRPN_Ca + 1.7399999999999999e-5 * var_chaste_interface__calcium_concentration__CaNSR + 0.00014491407891765456 * log(1800.0 * var_x35) - 0.1250174 * var_chaste_interface__calcium_concentration__Cai - 1.12886395354433e-5 * var_chaste_interface__membrane__V - var_x66 * (70.0 - var_chaste_interface__calcium_buffering__LTRPN_Ca) - var_x67 * (140.0 - var_chaste_interface__calcium_buffering__HTRPN_Ca) + 1.6591891954566281e-18 * var_x12 * var_x25 - 0.48075923579139868 * var_x36 * var_x40) / (pow(var_x61, 3) * pow((0.084033613445378158 + var_x62), 2));
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__CaJSR = rY[3];
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_fluxes__P_RyR = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ryanodine_receptors__P_O1 = rY[8];
        // Units: dimensionless; Initial value: 1.49102e-05
        double var_chaste_interface__ryanodine_receptors__P_O2 = rY[9];
        // Units: dimensionless; Initial value: 9.51726e-11
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        
        
        // Mathematics
        const double var_calcium_fluxes__J_xfer = 0.125 * var_chaste_interface__calcium_concentration__Cass - 0.125 * var_chaste_interface__calcium_concentration__Cai; // micromolar_per_millisecond
        const double var_L_type_calcium_current__i_CaL = 0.1729 * (-63.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O; // picoA_per_picoF
        const double var_calcium_fluxes__J_rel = 4.5 * (-var_chaste_interface__calcium_concentration__Cass + var_chaste_interface__calcium_concentration__CaJSR) * (var_chaste_interface__ryanodine_receptors__P_O1 + var_chaste_interface__ryanodine_receptors__P_O2) * var_chaste_interface__calcium_fluxes__P_RyR; // micromolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__Cass = (80.808080808080803 * var_calcium_fluxes__J_rel - 535.23141606043157 * var_L_type_calcium_current__i_CaL - 17400.6734006734 * var_calcium_fluxes__J_xfer) / (1.0 + 11.899999999999999 / pow((0.23799999999999999 + var_chaste_interface__calcium_concentration__Cass), 2)); // micromolar / millisecond

        return d_dt_chaste_interface_var_calcium_concentration__Cass;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            double var_chaste_interface__calcium_concentration__Cai = rY[1];
            // Units: micromolar; Initial value: 0.115001
            double var_chaste_interface__calcium_concentration__Cass = rY[2];
            // Units: micromolar; Initial value: 0.115001
            double var_chaste_interface__calcium_concentration__CaJSR = rY[3];
            // Units: micromolar; Initial value: 1299.5
            double var_chaste_interface__calcium_fluxes__P_RyR = rY[5];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__ryanodine_receptors__P_O1 = rY[8];
            // Units: dimensionless; Initial value: 1.49102e-05
            double var_chaste_interface__ryanodine_receptors__P_O2 = rY[9];
            // Units: dimensionless; Initial value: 9.51726e-11
            double var_chaste_interface__L_type_calcium_current__O = rY[11];
            // Units: dimensionless; Initial value: 9.30308e-19
            
            const double var_x68 = 0.23799999999999999 + var_chaste_interface__calcium_concentration__Cass;
            const double var_x69 = pow(var_x68, (-2));
            const double var_x70 = 1 / (1.0 + 11.899999999999999 * var_x69);
            const double var_x71 = 92.541511836848613 * var_chaste_interface__L_type_calcium_current__O;
            const double var_x72 = 363.63636363636363 * var_chaste_interface__ryanodine_receptors__P_O1;
            const double var_x73 = 363.63636363636363 * var_chaste_interface__ryanodine_receptors__P_O2;
            const double var_x74 = var_chaste_interface__ryanodine_receptors__P_O1 + var_chaste_interface__ryanodine_receptors__P_O2;
            const double var_x75 = var_x74 * (-var_chaste_interface__calcium_concentration__Cass + var_chaste_interface__calcium_concentration__CaJSR) * var_chaste_interface__calcium_fluxes__P_RyR;
            
            partialF = var_x70 * (-2175.0841750841751 + (-var_x72 - var_x73) * var_chaste_interface__calcium_fluxes__P_RyR) + 0.16806722689075632 * (363.63636363636363 * var_x75 + 2175.0841750841751 * var_chaste_interface__calcium_concentration__Cai - 2175.0841750841751 * var_chaste_interface__calcium_concentration__Cass - var_x71 * (-63.0 + var_chaste_interface__membrane__V)) / (pow(var_x68, 3) * pow((0.084033613445378158 + var_x69), 2));
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__CaJSR = rY[3];
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_concentration__CaNSR = rY[4];
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_fluxes__P_RyR = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ryanodine_receptors__P_O1 = rY[8];
        // Units: dimensionless; Initial value: 1.49102e-05
        double var_chaste_interface__ryanodine_receptors__P_O2 = rY[9];
        // Units: dimensionless; Initial value: 9.51726e-11
        
        
        // Mathematics
        const double var_calcium_fluxes__J_tr = 0.050000000000000003 * var_chaste_interface__calcium_concentration__CaNSR - 0.050000000000000003 * var_chaste_interface__calcium_concentration__CaJSR; // micromolar_per_millisecond
        const double var_calcium_fluxes__J_rel = 4.5 * (-var_chaste_interface__calcium_concentration__Cass + var_chaste_interface__calcium_concentration__CaJSR) * (var_chaste_interface__ryanodine_receptors__P_O1 + var_chaste_interface__ryanodine_receptors__P_O2) * var_chaste_interface__calcium_fluxes__P_RyR; // micromolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__CaJSR = (-var_calcium_fluxes__J_rel + var_calcium_fluxes__J_tr) / (1.0 + 18.75 / pow((1 + 0.00125 * var_chaste_interface__calcium_concentration__CaJSR), 2)); // micromolar / millisecond

        return d_dt_chaste_interface_var_calcium_concentration__CaJSR;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__calcium_concentration__Cass = rY[2];
            // Units: micromolar; Initial value: 0.115001
            double var_chaste_interface__calcium_concentration__CaJSR = rY[3];
            // Units: micromolar; Initial value: 1299.5
            double var_chaste_interface__calcium_concentration__CaNSR = rY[4];
            // Units: micromolar; Initial value: 1299.5
            double var_chaste_interface__calcium_fluxes__P_RyR = rY[5];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__ryanodine_receptors__P_O1 = rY[8];
            // Units: dimensionless; Initial value: 1.49102e-05
            double var_chaste_interface__ryanodine_receptors__P_O2 = rY[9];
            // Units: dimensionless; Initial value: 9.51726e-11
            
            const double var_x74 = var_chaste_interface__ryanodine_receptors__P_O1 + var_chaste_interface__ryanodine_receptors__P_O2;
            const double var_x75 = var_x74 * (-var_chaste_interface__calcium_concentration__Cass + var_chaste_interface__calcium_concentration__CaJSR) * var_chaste_interface__calcium_fluxes__P_RyR;
            const double var_x79 = 4.5 * var_chaste_interface__ryanodine_receptors__P_O1;
            const double var_x80 = 4.5 * var_chaste_interface__ryanodine_receptors__P_O2;
            const double var_x81 = 1 + 0.00125 * var_chaste_interface__calcium_concentration__CaJSR;
            const double var_x82 = pow(var_x81, (-2));
            const double var_x83 = 1 / (1.0 + 18.75 * var_x82);
            
            partialF = var_x83 * (-0.050000000000000003 + (-var_x79 - var_x80) * var_chaste_interface__calcium_fluxes__P_RyR) + 0.00013333333333333334 * (0.050000000000000003 * var_chaste_interface__calcium_concentration__CaNSR - 4.5 * var_x75 - 0.050000000000000003 * var_chaste_interface__calcium_concentration__CaJSR) / (pow(var_x81, 3) * pow((0.053333333333333337 + var_x82), 2));
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_concentration__CaJSR = rY[3];
        // Units: micromolar; Initial value: 1299.5
        double var_chaste_interface__calcium_concentration__CaNSR = rY[4];
        // Units: micromolar; Initial value: 1299.5
        
        
        // Mathematics
        const double var_calcium_fluxes__J_tr = 0.050000000000000003 * var_chaste_interface__calcium_concentration__CaNSR - 0.050000000000000003 * var_chaste_interface__calcium_concentration__CaJSR; // micromolar_per_millisecond
        const double var_calcium_fluxes__J_leak = 1.7399999999999999e-5 * var_chaste_interface__calcium_concentration__CaNSR - 1.7399999999999999e-5 * var_chaste_interface__calcium_concentration__Cai; // micromolar_per_millisecond
        const double var_calcium_fluxes__J_up = 0.45000000000000001 * pow(var_chaste_interface__calcium_concentration__Cai, 2) / (0.25 + pow(var_chaste_interface__calcium_concentration__Cai, 2)); // micromolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_concentration__CaNSR = 12.316491897044804 * var_calcium_fluxes__J_up - 12.316491897044804 * var_calcium_fluxes__J_leak - 0.057197330791229732 * var_calcium_fluxes__J_tr; // micromolar / millisecond

        return d_dt_chaste_interface_var_calcium_concentration__CaNSR;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.0030741734985700662;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_fluxes__P_RyR = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        
        
        // Mathematics
        const double var_L_type_calcium_current__i_CaL = 0.1729 * (-63.0 + var_chaste_interface__membrane__V) * var_chaste_interface__L_type_calcium_current__O; // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_fluxes__P_RyR = -0.040000000000000001 * var_chaste_interface__calcium_fluxes__P_RyR - 0.014285714285714287 * var_L_type_calcium_current__i_CaL * exp(-0.038580246913580245 * pow((-1 + 0.20000000000000001 * var_chaste_interface__membrane__V), 2)); // 1 / millisecond

        return d_dt_chaste_interface_var_calcium_fluxes__P_RyR;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.040000000000000001;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_buffering__LTRPN_Ca = rY[6];
        // Units: micromolar; Initial value: 11.2684
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_calcium_buffering__LTRPN_Ca = -0.019599999999999999 * var_chaste_interface__calcium_buffering__LTRPN_Ca + 0.0327 * (70.0 - var_chaste_interface__calcium_buffering__LTRPN_Ca) * var_chaste_interface__calcium_concentration__Cai; // micromolar / millisecond

        return d_dt_chaste_interface_var_calcium_buffering__LTRPN_Ca;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__calcium_concentration__Cai = rY[1];
            // Units: micromolar; Initial value: 0.115001
            
            const double var_x66 = 0.0327 * var_chaste_interface__calcium_concentration__Cai;
            
            partialF = -0.019599999999999999 - var_x66;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__calcium_buffering__HTRPN_Ca = rY[7];
        // Units: micromolar; Initial value: 125.29
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_calcium_buffering__HTRPN_Ca = -3.1999999999999999e-5 * var_chaste_interface__calcium_buffering__HTRPN_Ca + 0.0023700000000000001 * (140.0 - var_chaste_interface__calcium_buffering__HTRPN_Ca) * var_chaste_interface__calcium_concentration__Cai; // micromolar / millisecond

        return d_dt_chaste_interface_var_calcium_buffering__HTRPN_Ca;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__calcium_concentration__Cai = rY[1];
            // Units: micromolar; Initial value: 0.115001
            
            const double var_x67 = 0.0023700000000000001 * var_chaste_interface__calcium_concentration__Cai;
            
            partialF = -3.1999999999999999e-5 - var_x67;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__ryanodine_receptors__P_O1 = rY[8];
        // Units: dimensionless; Initial value: 1.49102e-05
        double var_chaste_interface__ryanodine_receptors__P_O2 = rY[9];
        // Units: dimensionless; Initial value: 9.51726e-11
        double var_chaste_interface__ryanodine_receptors__P_C2 = rY[10];
        // Units: dimensionless; Initial value: 0.00016774
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_O1 = 0.00080000000000000004 * var_chaste_interface__ryanodine_receptors__P_C2 + 0.96499999999999997 * var_chaste_interface__ryanodine_receptors__P_O2 - 0.080249999999999988 * var_chaste_interface__ryanodine_receptors__P_O1 + 0.0060749999999999997 * pow(var_chaste_interface__calcium_concentration__Cass, 4.0) * (1.0 - var_chaste_interface__ryanodine_receptors__P_C2 - var_chaste_interface__ryanodine_receptors__P_O1 - var_chaste_interface__ryanodine_receptors__P_O2) - 0.0040499999999999998 * pow(var_chaste_interface__calcium_concentration__Cass, 3.0) * var_chaste_interface__ryanodine_receptors__P_O1; // 1 / millisecond

        return d_dt_chaste_interface_var_ryanodine_receptors__P_O1;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__calcium_concentration__Cass = rY[2];
            // Units: micromolar; Initial value: 0.115001
            
            const double var_x90 = pow(var_chaste_interface__calcium_concentration__Cass, 3.0);
            const double var_x92 = 0.0040499999999999998 * var_x90;
            const double var_x93 = -0.0060749999999999997 * pow(var_chaste_interface__calcium_concentration__Cass, 4.0);
            
            partialF = -0.080249999999999988 + var_x93 - var_x92;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__ryanodine_receptors__P_O1 = rY[8];
        // Units: dimensionless; Initial value: 1.49102e-05
        double var_chaste_interface__ryanodine_receptors__P_O2 = rY[9];
        // Units: dimensionless; Initial value: 9.51726e-11
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_O2 = -0.96499999999999997 * var_chaste_interface__ryanodine_receptors__P_O2 + 0.0040499999999999998 * pow(var_chaste_interface__calcium_concentration__Cass, 3.0) * var_chaste_interface__ryanodine_receptors__P_O1; // 1 / millisecond

        return d_dt_chaste_interface_var_ryanodine_receptors__P_O2;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.96499999999999997;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__ryanodine_receptors__P_O1 = rY[8];
        // Units: dimensionless; Initial value: 1.49102e-05
        double var_chaste_interface__ryanodine_receptors__P_C2 = rY[10];
        // Units: dimensionless; Initial value: 0.00016774
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_ryanodine_receptors__P_C2 = 0.0089999999999999993 * var_chaste_interface__ryanodine_receptors__P_O1 - 0.00080000000000000004 * var_chaste_interface__ryanodine_receptors__P_C2; // 1 / millisecond

        return d_dt_chaste_interface_var_ryanodine_receptors__P_C2;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.00080000000000000004;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__L_type_calcium_current__C4 = rY[14];
        // Units: dimensionless; Initial value: 1.19816e-13
        double var_chaste_interface__L_type_calcium_current__I1 = rY[15];
        // Units: dimensionless; Initial value: 4.97923e-19
        double var_chaste_interface__L_type_calcium_current__I2 = rY[16];
        // Units: dimensionless; Initial value: 3.45847e-14
        
        
        // Mathematics
        const double var_L_type_calcium_current__gamma = 0.23324 * var_chaste_interface__calcium_concentration__Cass / (20.0 + var_chaste_interface__calcium_concentration__Cass); // per_millisecond
        const double var_L_type_calcium_current__Kpcf = 13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2)); // per_millisecond
        const double var_L_type_calcium_current__alpha = 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_current__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__O = 0.00050000000000000001 * var_chaste_interface__L_type_calcium_current__I1 + var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha - var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__gamma + 0.001 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__alpha - 4.0 * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__beta - 0.001 * var_L_type_calcium_current__Kpcf * var_chaste_interface__L_type_calcium_current__O; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_calcium_current__O;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            double var_chaste_interface__calcium_concentration__Cass = rY[2];
            // Units: micromolar; Initial value: 0.115001
            
            const double var_x94 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x97 = exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2));
            const double var_x98 = 0.013000000000000001 * var_x97;
            const double var_x122 = 1 / (20.0 + var_chaste_interface__calcium_concentration__Cass);
            const double var_x123 = 0.23324 * var_x122;
            const double var_x128 = 0.20000000000000001 * var_x94;
            const double var_x129 = var_x123 * var_chaste_interface__calcium_concentration__Cass;
            const double var_x130 = -var_x129;
            
            partialF = -0.013000000000000001 + var_x130 + var_x98 - var_x128;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__L_type_calcium_current__C2 = rY[12];
        // Units: dimensionless; Initial value: 0.000124216
        double var_chaste_interface__L_type_calcium_current__C3 = rY[13];
        // Units: dimensionless; Initial value: 5.78679e-09
        double var_chaste_interface__L_type_calcium_current__C4 = rY[14];
        // Units: dimensionless; Initial value: 1.19816e-13
        double var_chaste_interface__L_type_calcium_current__I1 = rY[15];
        // Units: dimensionless; Initial value: 4.97923e-19
        double var_chaste_interface__L_type_calcium_current__I2 = rY[16];
        // Units: dimensionless; Initial value: 3.45847e-14
        double var_chaste_interface__L_type_calcium_current__I3 = rY[17];
        // Units: dimensionless; Initial value: 1.85106e-14
        
        
        // Mathematics
        const double var_L_type_calcium_current__alpha = 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_current__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C2 = -var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__beta + 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__beta + 4.0 * (1.0 - var_chaste_interface__L_type_calcium_current__C3 - var_chaste_interface__L_type_calcium_current__C4 - var_chaste_interface__L_type_calcium_current__I1 - var_chaste_interface__L_type_calcium_current__I2 - var_chaste_interface__L_type_calcium_current__I3 - var_chaste_interface__L_type_calcium_current__O - 2 * var_chaste_interface__L_type_calcium_current__C2) * var_L_type_calcium_current__alpha - 3.0 * var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__alpha; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_calcium_current__C2;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x94 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x101 = 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2));
            const double var_x102 = 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2));
            const double var_x103 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x104 = 1.0 + 0.12 * var_x103;
            const double var_x105 = var_x103 / var_x104;
            const double var_x109 = 1.0 + var_x101 - var_x102;
            const double var_x110 = var_x105 * var_x109;
            
            partialF = -0.050000000000000003 * var_x94 - 4.4000000000000004 * var_x110;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__L_type_calcium_current__C2 = rY[12];
        // Units: dimensionless; Initial value: 0.000124216
        double var_chaste_interface__L_type_calcium_current__C3 = rY[13];
        // Units: dimensionless; Initial value: 5.78679e-09
        double var_chaste_interface__L_type_calcium_current__C4 = rY[14];
        // Units: dimensionless; Initial value: 1.19816e-13
        
        
        // Mathematics
        const double var_L_type_calcium_current__alpha = 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_current__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C3 = 3.0 * var_chaste_interface__L_type_calcium_current__C2 * var_L_type_calcium_current__alpha + 3.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__beta - 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__alpha - 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__beta; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_calcium_current__C3;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x94 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x101 = 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2));
            const double var_x102 = 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2));
            const double var_x103 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x104 = 1.0 + 0.12 * var_x103;
            const double var_x105 = var_x103 / var_x104;
            const double var_x109 = 1.0 + var_x101 - var_x102;
            const double var_x110 = var_x105 * var_x109;
            const double var_x139 = 0.10000000000000001 * var_x94;
            const double var_x144 = 0.80000000000000004 * var_x110;
            
            partialF = -var_x139 - var_x144;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__L_type_calcium_current__C3 = rY[13];
        // Units: dimensionless; Initial value: 5.78679e-09
        double var_chaste_interface__L_type_calcium_current__C4 = rY[14];
        // Units: dimensionless; Initial value: 1.19816e-13
        double var_chaste_interface__L_type_calcium_current__I1 = rY[15];
        // Units: dimensionless; Initial value: 4.97923e-19
        double var_chaste_interface__L_type_calcium_current__I2 = rY[16];
        // Units: dimensionless; Initial value: 3.45847e-14
        double var_chaste_interface__L_type_calcium_current__I3 = rY[17];
        // Units: dimensionless; Initial value: 1.85106e-14
        
        
        // Mathematics
        const double var_L_type_calcium_current__gamma = 0.23324 * var_chaste_interface__calcium_concentration__Cass / (20.0 + var_chaste_interface__calcium_concentration__Cass); // per_millisecond
        const double var_L_type_calcium_current__Kpcf = 13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2)); // per_millisecond
        const double var_L_type_calcium_current__alpha = 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_current__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__C4 = -var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha + 2.0 * var_chaste_interface__L_type_calcium_current__C3 * var_L_type_calcium_current__alpha + 4.0 * var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__beta + 0.002 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__beta + 0.0080000000000000002 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__beta + 2.0000000000000002e-5 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__beta - 3.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__beta - 0.002 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf - 1.0 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__gamma - 0.01 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha * var_L_type_calcium_current__gamma; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_calcium_current__C4;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            double var_chaste_interface__calcium_concentration__Cass = rY[2];
            // Units: micromolar; Initial value: 0.115001
            
            const double var_x94 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x97 = exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2));
            const double var_x101 = 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2));
            const double var_x102 = 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2));
            const double var_x103 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x104 = 1.0 + 0.12 * var_x103;
            const double var_x105 = var_x103 / var_x104;
            const double var_x109 = 1.0 + var_x101 - var_x102;
            const double var_x110 = var_x105 * var_x109;
            const double var_x122 = 1 / (20.0 + var_chaste_interface__calcium_concentration__Cass);
            const double var_x123 = 0.23324 * var_x122;
            const double var_x129 = var_x123 * var_chaste_interface__calcium_concentration__Cass;
            const double var_x131 = 0.40000000000000002 * var_x110;
            const double var_x145 = 0.15000000000000002 * var_x94;
            const double var_x149 = 0.026000000000000002 * var_x97;
            const double var_x152 = var_x122 * var_chaste_interface__calcium_concentration__Cass;
            const double var_x155 = 0.00093296000000000004 * var_x152;
            const double var_x158 = 13.0 - 13.0 * var_x97;
            const double var_x164 = var_x129 * var_x158;
            const double var_x165 = var_x110 * var_x155;
            
            partialF = -0.026000000000000002 + var_x149 - var_x131 - var_x145 - var_x164 - var_x165;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__L_type_calcium_current__C4 = rY[14];
        // Units: dimensionless; Initial value: 1.19816e-13
        double var_chaste_interface__L_type_calcium_current__I1 = rY[15];
        // Units: dimensionless; Initial value: 4.97923e-19
        double var_chaste_interface__L_type_calcium_current__I3 = rY[17];
        // Units: dimensionless; Initial value: 1.85106e-14
        
        
        // Mathematics
        const double var_L_type_calcium_current__gamma = 0.23324 * var_chaste_interface__calcium_concentration__Cass / (20.0 + var_chaste_interface__calcium_concentration__Cass); // per_millisecond
        const double var_L_type_calcium_current__Kpcf = 13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2)); // per_millisecond
        const double var_L_type_calcium_current__alpha = 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_current__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I1 = -0.00050000000000000001 * var_chaste_interface__L_type_calcium_current__I1 + var_chaste_interface__L_type_calcium_current__O * var_L_type_calcium_current__gamma + 0.001 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__alpha - 0.001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf + 0.01 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__alpha * var_L_type_calcium_current__gamma - 0.040000000000000001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__beta; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_calcium_current__I1;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x94 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x97 = exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2));
            const double var_x98 = 0.013000000000000001 * var_x97;
            const double var_x169 = 0.026000000000000002 * var_x97;
            const double var_x170 = var_x94 * (-0.026000000000000002 + var_x169);
            
            partialF = -0.0135 + var_x170 + var_x98;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__O = rY[11];
        // Units: dimensionless; Initial value: 9.30308e-19
        double var_chaste_interface__L_type_calcium_current__C4 = rY[14];
        // Units: dimensionless; Initial value: 1.19816e-13
        double var_chaste_interface__L_type_calcium_current__I2 = rY[16];
        // Units: dimensionless; Initial value: 3.45847e-14
        double var_chaste_interface__L_type_calcium_current__I3 = rY[17];
        // Units: dimensionless; Initial value: 1.85106e-14
        
        
        // Mathematics
        const double var_L_type_calcium_current__gamma = 0.23324 * var_chaste_interface__calcium_concentration__Cass / (20.0 + var_chaste_interface__calcium_concentration__Cass); // per_millisecond
        const double var_L_type_calcium_current__Kpcf = 13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2)); // per_millisecond
        const double var_L_type_calcium_current__alpha = 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_current__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I2 = 0.00050000000000000001 * var_chaste_interface__L_type_calcium_current__I3 - var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__gamma + 0.001 * var_L_type_calcium_current__Kpcf * var_chaste_interface__L_type_calcium_current__O + 0.002 * var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf - 0.001 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__alpha - 0.0080000000000000002 * var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__beta; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_calcium_current__I2;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            double var_chaste_interface__calcium_concentration__Cass = rY[2];
            // Units: micromolar; Initial value: 0.115001
            
            const double var_x94 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x101 = 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2));
            const double var_x102 = 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2));
            const double var_x103 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x104 = 1.0 + 0.12 * var_x103;
            const double var_x105 = var_x103 / var_x104;
            const double var_x109 = 1.0 + var_x101 - var_x102;
            const double var_x110 = var_x105 * var_x109;
            const double var_x122 = 1 / (20.0 + var_chaste_interface__calcium_concentration__Cass);
            const double var_x123 = 0.23324 * var_x122;
            const double var_x129 = var_x123 * var_chaste_interface__calcium_concentration__Cass;
            const double var_x130 = -var_x129;
            const double var_x132 = 0.00040000000000000002 * var_x110;
            const double var_x166 = 0.00040000000000000002 * var_x94;
            const double var_x177 = -var_x132;
            
            partialF = var_x130 + var_x177 - var_x166;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cass = rY[2];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__L_type_calcium_current__C4 = rY[14];
        // Units: dimensionless; Initial value: 1.19816e-13
        double var_chaste_interface__L_type_calcium_current__I1 = rY[15];
        // Units: dimensionless; Initial value: 4.97923e-19
        double var_chaste_interface__L_type_calcium_current__I2 = rY[16];
        // Units: dimensionless; Initial value: 3.45847e-14
        double var_chaste_interface__L_type_calcium_current__I3 = rY[17];
        // Units: dimensionless; Initial value: 1.85106e-14
        
        
        // Mathematics
        const double var_L_type_calcium_current__gamma = 0.23324 * var_chaste_interface__calcium_concentration__Cass / (20.0 + var_chaste_interface__calcium_concentration__Cass); // per_millisecond
        const double var_L_type_calcium_current__Kpcf = 13.0 - 13.0 * exp(-2.1025 * pow((1 + 0.068965517241379309 * var_chaste_interface__membrane__V), 2)); // per_millisecond
        const double var_L_type_calcium_current__alpha = 0.40000000000000002 * (1.0 + 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)) - 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2))) * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V) / (1.0 + 0.12 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_L_type_calcium_current__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_L_type_calcium_current__I3 = -0.00050000000000000001 * var_chaste_interface__L_type_calcium_current__I3 + var_chaste_interface__L_type_calcium_current__I2 * var_L_type_calcium_current__gamma + 0.001 * var_chaste_interface__L_type_calcium_current__I1 * var_L_type_calcium_current__Kpcf - 0.001 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__alpha - 0.002 * var_chaste_interface__L_type_calcium_current__I3 * var_L_type_calcium_current__beta + var_chaste_interface__L_type_calcium_current__C4 * var_L_type_calcium_current__Kpcf * var_L_type_calcium_current__gamma; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_calcium_current__I3;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x94 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x101 = 0.69999999999999996 * exp(-160.0 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2));
            const double var_x102 = 0.75 * exp(-1.0 * pow((1 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2));
            const double var_x103 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x104 = 1.0 + 0.12 * var_x103;
            const double var_x105 = var_x103 / var_x104;
            const double var_x109 = 1.0 + var_x101 - var_x102;
            const double var_x110 = var_x105 * var_x109;
            const double var_x132 = 0.00040000000000000002 * var_x110;
            const double var_x167 = 0.0001 * var_x94;
            const double var_x177 = -var_x132;
            
            partialF = -0.00050000000000000001 + var_x177 - var_x167;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__calcium_concentration__Cai = rY[1];
        // Units: micromolar; Initial value: 0.115001
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__potassium_concentration__Ki = rY[27];
        // Units: micromolar; Initial value: 143720.0
        
        
        // Mathematics
        const double var_fast_sodium_current__E_Na = 25.674321243523316 * log(140600.0 / (var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki)); // millivolt
        const double var_fast_sodium_current__i_Na = 13.0 * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_chaste_interface__fast_sodium_current__O_Na; // picoA_per_picoF
        const double var_sodium_background_current__i_Nab = 0.0025999999999999999 * var_chaste_interface__membrane__V - 0.0025999999999999999 * var_fast_sodium_current__E_Na; // picoA_per_picoF
        const double var_sodium_calcium_exchange_current__i_NaCa = 2.6970585464294846e-17 * (1800.0 * pow(var_chaste_interface__sodium_concentration__Nai, 3) * exp(0.013632298072467722 * var_chaste_interface__membrane__V) - 2744000000000000.0 * var_chaste_interface__calcium_concentration__Cai * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)) / (1.0 + 0.10000000000000001 * exp(-0.025317124991725771 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = 0.68869565217391304 / ((1.0 + 3043189.1166997822 * pow(1 / var_chaste_interface__sodium_concentration__Nai, 1.5)) * (1.0 + 0.1245 * exp(-0.0038949423064193493 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.038949423064193495 * var_chaste_interface__membrane__V))); // picoA_per_picoF
        const double d_dt_chaste_interface_var_sodium_concentration__Nai = -0.18455541474839185 * var_sodium_calcium_exchange_current__i_NaCa - 0.18455541474839185 * var_sodium_potassium_pump_current__i_NaK - 0.061518471582797281 * var_fast_sodium_current__i_Na - 0.061518471582797281 * var_sodium_background_current__i_Nab; // micromolar / millisecond

        return d_dt_chaste_interface_var_sodium_concentration__Nai;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            double var_chaste_interface__sodium_concentration__Nai = rY[18];
            // Units: micromolar; Initial value: 14237.1
            double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
            // Units: dimensionless; Initial value: 7.13483e-07
            double var_chaste_interface__potassium_concentration__Ki = rY[27];
            // Units: micromolar; Initial value: 143720.0
            
            const double var_x10 = exp(-0.025317124991725771 * var_chaste_interface__membrane__V);
            const double var_x11 = 1.0 + 0.10000000000000001 * var_x10;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = exp(0.013632298072467722 * var_chaste_interface__membrane__V);
            const double var_x27 = 1 / var_chaste_interface__sodium_concentration__Nai;
            const double var_x28 = pow(var_x27, 1.5);
            const double var_x29 = exp(-0.0038949423064193493 * var_chaste_interface__membrane__V);
            const double var_x30 = exp(2.0802377414561666);
            const double var_x31 = exp(-0.038949423064193495 * var_chaste_interface__membrane__V);
            const double var_x32 = 1.0 + 0.1245 * var_x29 + 0.036499999999999998 * var_x31 * (-0.14285714285714285 + 0.14285714285714285 * var_x30);
            const double var_x42 = var_chaste_interface__sodium_concentration__Nai + 0.1111111111111111 * var_chaste_interface__potassium_concentration__Ki;
            const double var_x43 = (7.1123755334281649e-6 * var_chaste_interface__sodium_concentration__Nai + 7.9026394815868502e-7 * var_chaste_interface__potassium_concentration__Ki) / pow(var_x42, 2);
            const double var_x44 = var_x12 * var_x13 * pow(var_chaste_interface__sodium_concentration__Nai, 2);
            const double var_x47 = var_x43 * var_chaste_interface__fast_sodium_current__O_Na;
            const double var_x48 = var_x27 * var_x28 / (var_x32 * pow((3.2860264730588296e-7 + var_x28), 2));
            
            partialF = -577.38191486798689 * var_x43 - 6.2649332746797061e-8 * var_x48 - 2886909.5743399346 * var_x47 - 2.6878864966397372e-14 * var_x44;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__fast_sodium_current__C_Na1 = rY[20];
        // Units: dimensionless; Initial value: 0.000279132
        double var_chaste_interface__fast_sodium_current__IF_Na = rY[24];
        // Units: dimensionless; Initial value: 0.000153176
        
        
        // Mathematics
        const double var_fast_sodium_current__alpha_Na13 = 3.802 / (0.25 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na2 = 1 / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na3 = 6.9999999999999997e-7 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na13 = 0.22 * exp(0.36945812807881773 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na3 = 0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V; // per_millisecond
        const double var_fast_sodium_current__beta_Na2 = var_fast_sodium_current__alpha_Na13 * var_fast_sodium_current__alpha_Na2 * var_fast_sodium_current__alpha_Na3 / (var_fast_sodium_current__beta_Na13 * var_fast_sodium_current__beta_Na3); // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__O_Na = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__alpha_Na13 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na2 - var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__alpha_Na2 - var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__beta_Na13; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current__O_Na;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x178 = -0.04926108374384236 * var_chaste_interface__membrane__V;
            const double var_x179 = exp(0.36945812807881773 + var_x178);
            const double var_x185 = exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V);
            const double var_x191 = 1 / (0.39395599999999997 + 0.188495 * var_x185);
            const double var_x204 = var_x191;
            const double var_x205 = 0.22 * var_x179;
            
            partialF = -var_x204 - var_x205;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__fast_sodium_current__C_Na1 = rY[20];
        // Units: dimensionless; Initial value: 0.000279132
        double var_chaste_interface__fast_sodium_current__C_Na2 = rY[21];
        // Units: dimensionless; Initial value: 0.020752
        double var_chaste_interface__fast_sodium_current__IF_Na = rY[24];
        // Units: dimensionless; Initial value: 0.000153176
        
        
        // Mathematics
        const double var_fast_sodium_current__alpha_Na12 = 3.802 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na13 = 3.802 / (0.25 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na3 = 6.9999999999999997e-7 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na12 = 0.20000000000000001 * exp(0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na13 = 0.22 * exp(0.36945812807881773 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na3 = 0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__C_Na1 = var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__alpha_Na12 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na3 + var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__beta_Na13 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__alpha_Na13 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na3; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current__C_Na1;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x178 = -0.04926108374384236 * var_chaste_interface__membrane__V;
            const double var_x181 = exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V);
            const double var_x182 = exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V);
            const double var_x188 = 2.0000000000000002e-5 * var_chaste_interface__membrane__V;
            const double var_x192 = 1 / (0.25 * var_x182 + 0.1027 * var_x181);
            const double var_x206 = 3.802 * var_x192;
            const double var_x210 = exp(0.12315270935960591 + var_x178);
            const double var_x218 = 0.20000000000000001 * var_x210;
            const double var_x219 = -var_x218;
            const double var_x220 = -0.008539999999999999 - var_x188;
            
            partialF = var_x219 + var_x220 - var_x206;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__fast_sodium_current__C_Na1 = rY[20];
        // Units: dimensionless; Initial value: 0.000279132
        double var_chaste_interface__fast_sodium_current__C_Na2 = rY[21];
        // Units: dimensionless; Initial value: 0.020752
        double var_chaste_interface__fast_sodium_current__I1_Na = rY[22];
        // Units: dimensionless; Initial value: 6.73345e-07
        double var_chaste_interface__fast_sodium_current__I2_Na = rY[23];
        // Units: dimensionless; Initial value: 1.55787e-09
        double var_chaste_interface__fast_sodium_current__IF_Na = rY[24];
        // Units: dimensionless; Initial value: 0.000153176
        double var_chaste_interface__fast_sodium_current__IC_Na2 = rY[25];
        // Units: dimensionless; Initial value: 0.0113879
        double var_chaste_interface__fast_sodium_current__IC_Na3 = rY[26];
        // Units: dimensionless; Initial value: 0.34278
        
        
        // Mathematics
        const double var_fast_sodium_current__C_Na3 = 1.0 - var_chaste_interface__fast_sodium_current__C_Na1 - var_chaste_interface__fast_sodium_current__C_Na2 - var_chaste_interface__fast_sodium_current__I1_Na - var_chaste_interface__fast_sodium_current__I2_Na - var_chaste_interface__fast_sodium_current__IC_Na2 - var_chaste_interface__fast_sodium_current__IC_Na3 - var_chaste_interface__fast_sodium_current__IF_Na - var_chaste_interface__fast_sodium_current__O_Na; // dimensionless
        const double var_fast_sodium_current__alpha_Na11 = 3.802 / (0.20000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na12 = 3.802 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na3 = 6.9999999999999997e-7 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na11 = 0.19170000000000001 * exp(-0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na12 = 0.20000000000000001 * exp(0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na3 = 0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__C_Na2 = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na12 + var_fast_sodium_current__C_Na3 * var_fast_sodium_current__alpha_Na11 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__alpha_Na12 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na11 - var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na3; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current__C_Na2;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x178 = -0.04926108374384236 * var_chaste_interface__membrane__V;
            const double var_x182 = exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V);
            const double var_x188 = 2.0000000000000002e-5 * var_chaste_interface__membrane__V;
            const double var_x215 = exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V);
            const double var_x220 = -0.008539999999999999 - var_x188;
            const double var_x221 = 3.802 / (0.1027 * var_x215 + 0.23000000000000001 * var_x182);
            const double var_x225 = exp(-0.12315270935960591 + var_x178);
            const double var_x228 = exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V);
            const double var_x230 = 3.802 / (0.20000000000000001 * var_x182 + 0.1027 * var_x228);
            const double var_x231 = -var_x230;
            const double var_x232 = 0.19170000000000001 * var_x225;
            const double var_x233 = -var_x221 - var_x232;
            const double var_x234 = var_x220 + var_x231;
            
            partialF = var_x233 + var_x234;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_sodium_current__I1_Na = rY[22];
        // Units: dimensionless; Initial value: 6.73345e-07
        double var_chaste_interface__fast_sodium_current__I2_Na = rY[23];
        // Units: dimensionless; Initial value: 1.55787e-09
        double var_chaste_interface__fast_sodium_current__IF_Na = rY[24];
        // Units: dimensionless; Initial value: 0.000153176
        
        
        // Mathematics
        const double var_fast_sodium_current__alpha_Na2 = 1 / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na3 = 6.9999999999999997e-7 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__alpha_Na4 = 0.001 * var_fast_sodium_current__alpha_Na2; // per_millisecond
        const double var_fast_sodium_current__alpha_Na5 = 1.0526315789473684e-5 * var_fast_sodium_current__alpha_Na2; // per_millisecond
        const double var_fast_sodium_current__beta_Na4 = var_fast_sodium_current__alpha_Na3; // per_millisecond
        const double var_fast_sodium_current__beta_Na5 = 0.02 * var_fast_sodium_current__alpha_Na3; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__I1_Na = var_chaste_interface__fast_sodium_current__I2_Na * var_fast_sodium_current__beta_Na5 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na4 - var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__alpha_Na5 - var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__beta_Na4; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current__I1_Na;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x185 = exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V);
            const double var_x191 = 1 / (0.39395599999999997 + 0.188495 * var_x185);
            const double var_x193 = -0.12987012987012986 * var_chaste_interface__membrane__V;
            const double var_x194 = exp(-0.90909090909090906 + var_x193);
            const double var_x222 = 6.9999999999999997e-7 * var_x194;
            const double var_x239 = -var_x222;
            const double var_x240 = 1.0526315789473684e-5 * var_x191;
            
            partialF = var_x239 - var_x240;
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_sodium_current__I1_Na = rY[22];
        // Units: dimensionless; Initial value: 6.73345e-07
        double var_chaste_interface__fast_sodium_current__I2_Na = rY[23];
        // Units: dimensionless; Initial value: 1.55787e-09
        
        
        // Mathematics
        const double var_fast_sodium_current__alpha_Na2 = 1 / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na3 = 6.9999999999999997e-7 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__alpha_Na5 = 1.0526315789473684e-5 * var_fast_sodium_current__alpha_Na2; // per_millisecond
        const double var_fast_sodium_current__beta_Na5 = 0.02 * var_fast_sodium_current__alpha_Na3; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__I2_Na = var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__alpha_Na5 - var_chaste_interface__fast_sodium_current__I2_Na * var_fast_sodium_current__beta_Na5; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current__I2_Na;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x193 = -0.12987012987012986 * var_chaste_interface__membrane__V;
            const double var_x194 = exp(-0.90909090909090906 + var_x193);
            const double var_x241 = 1.4e-8 * var_x194;
            
            partialF = -var_x241;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__fast_sodium_current__C_Na1 = rY[20];
        // Units: dimensionless; Initial value: 0.000279132
        double var_chaste_interface__fast_sodium_current__I1_Na = rY[22];
        // Units: dimensionless; Initial value: 6.73345e-07
        double var_chaste_interface__fast_sodium_current__IF_Na = rY[24];
        // Units: dimensionless; Initial value: 0.000153176
        double var_chaste_interface__fast_sodium_current__IC_Na2 = rY[25];
        // Units: dimensionless; Initial value: 0.0113879
        
        
        // Mathematics
        const double var_fast_sodium_current__alpha_Na12 = 3.802 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na13 = 3.802 / (0.25 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na2 = 1 / (0.39395599999999997 + 0.188495 * exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na3 = 6.9999999999999997e-7 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__alpha_Na4 = 0.001 * var_fast_sodium_current__alpha_Na2; // per_millisecond
        const double var_fast_sodium_current__beta_Na12 = 0.20000000000000001 * exp(0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na13 = 0.22 * exp(0.36945812807881773 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na3 = 0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V; // per_millisecond
        const double var_fast_sodium_current__beta_Na2 = var_fast_sodium_current__alpha_Na13 * var_fast_sodium_current__alpha_Na2 * var_fast_sodium_current__alpha_Na3 / (var_fast_sodium_current__beta_Na13 * var_fast_sodium_current__beta_Na3); // per_millisecond
        const double var_fast_sodium_current__beta_Na4 = var_fast_sodium_current__alpha_Na3; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IF_Na = var_chaste_interface__fast_sodium_current__C_Na1 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__I1_Na * var_fast_sodium_current__beta_Na4 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na12 + var_chaste_interface__fast_sodium_current__O_Na * var_fast_sodium_current__alpha_Na2 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__alpha_Na4 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na2; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current__IF_Na;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x178 = -0.04926108374384236 * var_chaste_interface__membrane__V;
            const double var_x179 = exp(0.36945812807881773 + var_x178);
            const double var_x181 = exp(-0.20833333333333334 - 0.083333333333333329 * var_chaste_interface__membrane__V);
            const double var_x182 = exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V);
            const double var_x185 = exp(-0.42168674698795178 - 0.060240963855421679 * var_chaste_interface__membrane__V);
            const double var_x188 = 2.0000000000000002e-5 * var_chaste_interface__membrane__V;
            const double var_x189 = 0.008539999999999999 + var_x188;
            const double var_x190 = 1 / var_x189;
            const double var_x191 = 1 / (0.39395599999999997 + 0.188495 * var_x185);
            const double var_x192 = 1 / (0.25 * var_x182 + 0.1027 * var_x181);
            const double var_x193 = -0.12987012987012986 * var_chaste_interface__membrane__V;
            const double var_x194 = exp(-0.90909090909090906 + var_x193);
            const double var_x195 = 1 / var_x179;
            const double var_x196 = var_x191 * var_x192 * var_x194 * var_x195;
            const double var_x197 = var_x190 * var_x196;
            const double var_x207 = 1.2097272727272726e-5 * var_x197;
            const double var_x210 = exp(0.12315270935960591 + var_x178);
            const double var_x218 = 0.20000000000000001 * var_x210;
            const double var_x219 = -var_x218;
            const double var_x222 = 6.9999999999999997e-7 * var_x194;
            const double var_x239 = -var_x222;
            const double var_x242 = 0.001 * var_x191;
            
            partialF = var_x219 + var_x239 - var_x207 - var_x242;
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_sodium_current__C_Na2 = rY[21];
        // Units: dimensionless; Initial value: 0.020752
        double var_chaste_interface__fast_sodium_current__IF_Na = rY[24];
        // Units: dimensionless; Initial value: 0.000153176
        double var_chaste_interface__fast_sodium_current__IC_Na2 = rY[25];
        // Units: dimensionless; Initial value: 0.0113879
        double var_chaste_interface__fast_sodium_current__IC_Na3 = rY[26];
        // Units: dimensionless; Initial value: 0.34278
        
        
        // Mathematics
        const double var_fast_sodium_current__alpha_Na11 = 3.802 / (0.20000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na12 = 3.802 / (0.1027 * exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V) + 0.23000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na3 = 6.9999999999999997e-7 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na11 = 0.19170000000000001 * exp(-0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na12 = 0.20000000000000001 * exp(0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na3 = 0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IC_Na2 = var_chaste_interface__fast_sodium_current__C_Na2 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na11 + var_chaste_interface__fast_sodium_current__IF_Na * var_fast_sodium_current__beta_Na12 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na12 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__alpha_Na3 - var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__beta_Na11; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current__IC_Na2;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x178 = -0.04926108374384236 * var_chaste_interface__membrane__V;
            const double var_x182 = exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V);
            const double var_x193 = -0.12987012987012986 * var_chaste_interface__membrane__V;
            const double var_x194 = exp(-0.90909090909090906 + var_x193);
            const double var_x215 = exp(-0.16666666666666666 - 0.066666666666666666 * var_chaste_interface__membrane__V);
            const double var_x221 = 3.802 / (0.1027 * var_x215 + 0.23000000000000001 * var_x182);
            const double var_x222 = 6.9999999999999997e-7 * var_x194;
            const double var_x225 = exp(-0.12315270935960591 + var_x178);
            const double var_x232 = 0.19170000000000001 * var_x225;
            const double var_x233 = -var_x221 - var_x232;
            const double var_x239 = -var_x222;
            
            partialF = var_x233 + var_x239;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_sodium_current__O_Na = rY[19];
        // Units: dimensionless; Initial value: 7.13483e-07
        double var_chaste_interface__fast_sodium_current__C_Na1 = rY[20];
        // Units: dimensionless; Initial value: 0.000279132
        double var_chaste_interface__fast_sodium_current__C_Na2 = rY[21];
        // Units: dimensionless; Initial value: 0.020752
        double var_chaste_interface__fast_sodium_current__I1_Na = rY[22];
        // Units: dimensionless; Initial value: 6.73345e-07
        double var_chaste_interface__fast_sodium_current__I2_Na = rY[23];
        // Units: dimensionless; Initial value: 1.55787e-09
        double var_chaste_interface__fast_sodium_current__IF_Na = rY[24];
        // Units: dimensionless; Initial value: 0.000153176
        double var_chaste_interface__fast_sodium_current__IC_Na2 = rY[25];
        // Units: dimensionless; Initial value: 0.0113879
        double var_chaste_interface__fast_sodium_current__IC_Na3 = rY[26];
        // Units: dimensionless; Initial value: 0.34278
        
        
        // Mathematics
        const double var_fast_sodium_current__C_Na3 = 1.0 - var_chaste_interface__fast_sodium_current__C_Na1 - var_chaste_interface__fast_sodium_current__C_Na2 - var_chaste_interface__fast_sodium_current__I1_Na - var_chaste_interface__fast_sodium_current__I2_Na - var_chaste_interface__fast_sodium_current__IC_Na2 - var_chaste_interface__fast_sodium_current__IC_Na3 - var_chaste_interface__fast_sodium_current__IF_Na - var_chaste_interface__fast_sodium_current__O_Na; // dimensionless
        const double var_fast_sodium_current__alpha_Na11 = 3.802 / (0.20000000000000001 * exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V) + 0.1027 * exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V)); // per_millisecond
        const double var_fast_sodium_current__alpha_Na3 = 6.9999999999999997e-7 * exp(-0.90909090909090906 - 0.12987012987012986 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na11 = 0.19170000000000001 * exp(-0.12315270935960591 - 0.04926108374384236 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_fast_sodium_current__beta_Na3 = 0.008539999999999999 + 2.0000000000000002e-5 * var_chaste_interface__membrane__V; // per_millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current__IC_Na3 = var_fast_sodium_current__C_Na3 * var_fast_sodium_current__beta_Na3 + var_chaste_interface__fast_sodium_current__IC_Na2 * var_fast_sodium_current__beta_Na11 - var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na11 - var_chaste_interface__fast_sodium_current__IC_Na3 * var_fast_sodium_current__alpha_Na3; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current__IC_Na3;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x182 = exp(-0.016666666666666666 - 0.0066666666666666671 * var_chaste_interface__membrane__V);
            const double var_x188 = 2.0000000000000002e-5 * var_chaste_interface__membrane__V;
            const double var_x193 = -0.12987012987012986 * var_chaste_interface__membrane__V;
            const double var_x194 = exp(-0.90909090909090906 + var_x193);
            const double var_x220 = -0.008539999999999999 - var_x188;
            const double var_x222 = 6.9999999999999997e-7 * var_x194;
            const double var_x228 = exp(-0.14705882352941177 - 0.058823529411764705 * var_chaste_interface__membrane__V);
            const double var_x230 = 3.802 / (0.20000000000000001 * var_x182 + 0.1027 * var_x228);
            const double var_x231 = -var_x230;
            const double var_x234 = var_x220 + var_x231;
            const double var_x239 = -var_x222;
            
            partialF = var_x234 + var_x239;
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative27(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__sodium_concentration__Nai = rY[18];
        // Units: micromolar; Initial value: 14237.1
        double var_chaste_interface__potassium_concentration__Ki = rY[27];
        // Units: micromolar; Initial value: 143720.0
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        
        
        // Mathematics
        const double var_fast_transient_outward_potassium_current__E_K = 25.674321243523316 * log(5400.0 / var_chaste_interface__potassium_concentration__Ki); // millivolt
        const double var_fast_transient_outward_potassium_current__i_Kto_f = 0.40670000000000001 * pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__fast_transient_outward_potassium_current__ito_f; // picoA_per_picoF
        const double var_non_inactivating_steady_state_potassium_current__i_Kss = 0.050000000000000003 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss; // picoA_per_picoF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = 0.0057499999999999999 * pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2) * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V); // picoA_per_picoF
        const double var_slow_transient_outward_potassium_current__i_Kto_s = 0; // picoA_per_picoF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = 0.078 * (-25.674321243523316 * log(8257.1428571428569 / (var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai)) + var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = 0.68869565217391304 / ((1.0 + 3043189.1166997822 * pow(1 / var_chaste_interface__sodium_concentration__Nai, 1.5)) * (1.0 + 0.1245 * exp(-0.0038949423064193493 * var_chaste_interface__membrane__V) + 0.036499999999999998 * (-0.14285714285714285 + 0.14285714285714285 * exp(2.0802377414561666)) * exp(-0.038949423064193495 * var_chaste_interface__membrane__V))); // picoA_per_picoF
        const double var_time_independent_potassium_current__i_K1 = 0.28280213903743318 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) / (1.0 + exp(0.089599999999999999 * var_chaste_interface__membrane__V - 0.089599999999999999 * var_fast_transient_outward_potassium_current__E_K)); // picoA_per_picoF
        const double var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur = 0.16 * (-var_fast_transient_outward_potassium_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur; // picoA_per_picoF
        const double d_dt_chaste_interface_var_potassium_concentration__Ki = 0.12303694316559456 * var_sodium_potassium_pump_current__i_NaK - 0.061518471582797281 * var_fast_transient_outward_potassium_current__i_Kto_f - 0.061518471582797281 * var_non_inactivating_steady_state_potassium_current__i_Kss - 0.061518471582797281 * var_rapid_delayed_rectifier_potassium_current__i_Kr - 0.061518471582797281 * var_slow_delayed_rectifier_potassium_current__i_Ks - 0.061518471582797281 * var_slow_transient_outward_potassium_current__i_Kto_s - 0.061518471582797281 * var_time_independent_potassium_current__i_K1 - 0.061518471582797281 * var_ultra_rapidly_activating_delayed_rectifier_potassium_current__i_Kur; // micromolar / millisecond

        return d_dt_chaste_interface_var_potassium_concentration__Ki;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative27(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            double var_chaste_interface__sodium_concentration__Nai = rY[18];
            // Units: micromolar; Initial value: 14237.1
            double var_chaste_interface__potassium_concentration__Ki = rY[27];
            // Units: micromolar; Initial value: 143720.0
            double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
            // Units: dimensionless; Initial value: 0.00265563
            double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
            // Units: dimensionless; Initial value: 0.999977
            double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
            // Units: dimensionless; Initial value: 0.000262753
            double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
            // Units: dimensionless; Initial value: 0.000417069
            double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
            // Units: dimensionless; Initial value: 0.998543
            double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
            // Units: dimensionless; Initial value: 0.000417069
            double var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss = rY[36];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
            // Units: dimensionless; Initial value: 0.000175298
            
            const double var_x0 = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs, 2);
            const double var_x1 = 1 / var_chaste_interface__potassium_concentration__Ki;
            const double var_x2 = log(5400.0 * var_x1);
            const double var_x3 = exp(0.089599999999999999 * var_chaste_interface__membrane__V - 2.300419183419689 * var_x2);
            const double var_x4 = 1.0 + var_x3;
            const double var_x5 = 1 / var_x4;
            const double var_x6 = var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss * var_chaste_interface__non_inactivating_steady_state_potassium_current__iKss;
            const double var_x7 = var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur * var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur;
            const double var_x8 = pow(var_chaste_interface__fast_transient_outward_potassium_current__ato_f, 3);
            const double var_x17 = -25.674321243523316 * var_x2 + var_chaste_interface__membrane__V;
            const double var_x18 = var_x17 * var_x3 / pow(var_x4, 2);
            const double var_x45 = var_chaste_interface__potassium_concentration__Ki + 0.020408163265306124 * var_chaste_interface__sodium_concentration__Nai;
            const double var_x46 = (2.4715768660405338e-6 * var_chaste_interface__sodium_concentration__Nai + 0.00012110726643598615 * var_chaste_interface__potassium_concentration__Ki) * var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K / pow(var_x45, 2);
            const double var_x50 = var_x0 * var_x1;
            const double var_x51 = var_x1 * var_x5;
            const double var_x52 = var_x1 * var_x7;
            const double var_x53 = var_x1 * var_x6;
            const double var_x54 = var_x1 * var_x8 * var_chaste_interface__fast_transient_outward_potassium_current__ito_f;
            const double var_x55 = var_x1 * var_x18;
            
            partialF = 0.040021670080783313 * var_x55 - 0.0090818087605069615 * var_x50 - 0.078972250091364882 * var_x53 - 0.642360282243162 * var_x54 - 0.25271120029236765 * var_x52 - 0.44667042500874232 * var_x51 - 1017.2528351768841 * var_x46;
        }
        else
        {
            const double y_save = rY[27];
            rY[27] += delta;
            const double temp = EvaluateYDerivative27(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[27])/delta;
            rY[27] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative28(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_transient_outward_potassium_current__ato_f = rY[28];
        // Units: dimensionless; Initial value: 0.00265563
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_fast_transient_outward_potassium_current__ato_f = 0.18064 * (1.0 - var_chaste_interface__fast_transient_outward_potassium_current__ato_f) * exp(1.0731000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V) - 0.39560000000000001 * var_chaste_interface__fast_transient_outward_potassium_current__ato_f * exp(-1.8711 - 0.062370000000000002 * var_chaste_interface__membrane__V); // 1 / millisecond

        return d_dt_chaste_interface_var_fast_transient_outward_potassium_current__ato_f;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative28(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x250 = exp(1.0731000000000002 + 0.035770000000000003 * var_chaste_interface__membrane__V);
            const double var_x251 = exp(-1.8711 - 0.062370000000000002 * var_chaste_interface__membrane__V);
            
            partialF = -0.18064 * var_x250 - 0.39560000000000001 * var_x251;
        }
        else
        {
            const double y_save = rY[28];
            rY[28] += delta;
            const double temp = EvaluateYDerivative28(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[28])/delta;
            rY[28] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative29(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__fast_transient_outward_potassium_current__ito_f = rY[29];
        // Units: dimensionless; Initial value: 0.999977
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_fast_transient_outward_potassium_current__ito_f = 0.00015200000000000001 * (1.0 - var_chaste_interface__fast_transient_outward_potassium_current__ito_f) * exp(-1.9285714285714286 - 0.14285714285714285 * var_chaste_interface__membrane__V) / (1.0 + 0.0067083000000000004 * exp(-4.7857142857142856 - 0.14285714285714285 * var_chaste_interface__membrane__V)) - 0.00095 * var_chaste_interface__fast_transient_outward_potassium_current__ito_f * exp(4.7857142857142856 + 0.14285714285714285 * var_chaste_interface__membrane__V) / (1.0 + 0.051334999999999999 * exp(4.7857142857142856 + 0.14285714285714285 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_fast_transient_outward_potassium_current__ito_f;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative29(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x252 = 0.14285714285714285 * var_chaste_interface__membrane__V;
            const double var_x253 = exp(4.7857142857142856 + var_x252);
            const double var_x254 = 1.0 + 0.051334999999999999 * var_x253;
            const double var_x255 = var_x253 / var_x254;
            const double var_x257 = -var_x252;
            const double var_x258 = exp(-4.7857142857142856 + var_x257);
            const double var_x259 = 1.0 + 0.0067083000000000004 * var_x258;
            const double var_x260 = exp(-1.9285714285714286 + var_x257);
            const double var_x261 = var_x260 / var_x259;
            
            partialF = -0.00015200000000000001 * var_x261 - 0.00095 * var_x255;
        }
        else
        {
            const double y_save = rY[29];
            rY[29] += delta;
            const double temp = EvaluateYDerivative29(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[29])/delta;
            rY[29] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative30(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__slow_transient_outward_potassium_current__ato_s = rY[30];
        // Units: dimensionless; Initial value: 0.000417069
        
        
        // Mathematics
        const double var_slow_transient_outward_potassium_current__ass = 1 / (1.0 + exp(-2.9220779220779218 - 0.12987012987012986 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_slow_transient_outward_potassium_current__ato_s = (-var_chaste_interface__slow_transient_outward_potassium_current__ato_s + var_slow_transient_outward_potassium_current__ass) / (2.0579999999999998 + 0.49299999999999999 * exp(-0.062899999999999998 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_slow_transient_outward_potassium_current__ato_s;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative30(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x265 = exp(-0.062899999999999998 * var_chaste_interface__membrane__V);
            const double var_x267 = 1 / (2.0579999999999998 + 0.49299999999999999 * var_x265);
            const double var_x270 = -var_x267;
            
            partialF = var_x270;
        }
        else
        {
            const double y_save = rY[30];
            rY[30] += delta;
            const double temp = EvaluateYDerivative30(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[30])/delta;
            rY[30] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative31(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__slow_transient_outward_potassium_current__ito_s = rY[31];
        // Units: dimensionless; Initial value: 0.998543
        
        
        // Mathematics
        const double var_slow_transient_outward_potassium_current__iss = 1 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_slow_transient_outward_potassium_current__ito_s = (-var_chaste_interface__slow_transient_outward_potassium_current__ito_s + var_slow_transient_outward_potassium_current__iss) / (270.0 + 1050.0 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_slow_transient_outward_potassium_current__ito_s;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative31(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x271 = exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V);
            const double var_x272 = 1.0 + var_x271;
            const double var_x273 = 1 / var_x272;
            const double var_x274 = 1 / (270.0 + 1050.0 * var_x273);
            
            partialF = -var_x274;
        }
        else
        {
            const double y_save = rY[31];
            rY[31] += delta;
            const double temp = EvaluateYDerivative31(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[31])/delta;
            rY[31] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative32(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs = rY[32];
        // Units: dimensionless; Initial value: 0.000262753
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current__nKs = -9.5333299999999997e-5 * var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs * exp(-1.0069999999999999 - 0.037999999999999999 * var_chaste_interface__membrane__V) + 4.8133299999999997e-6 * (1.0 - var_chaste_interface__slow_delayed_rectifier_potassium_current__nKs) * (26.5 + var_chaste_interface__membrane__V) / (1.0 - exp(-3.3919999999999999 - 0.128 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current__nKs;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative32(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x279 = exp(-3.3919999999999999 - 0.128 * var_chaste_interface__membrane__V);
            const double var_x280 = 1.0 - var_x279;
            const double var_x281 = 4.8133299999999997e-6 / var_x280;
            const double var_x282 = exp(-1.0069999999999999 - 0.037999999999999999 * var_chaste_interface__membrane__V);
            const double var_x283 = 26.5 + var_chaste_interface__membrane__V;
            
            partialF = -9.5333299999999997e-5 * var_x282 - var_x281 * var_x283;
        }
        else
        {
            const double y_save = rY[32];
            rY[32] += delta;
            const double temp = EvaluateYDerivative32(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[32])/delta;
            rY[32] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative33(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = rY[33];
        // Units: dimensionless; Initial value: 0.000417069
        
        
        // Mathematics
        const double var_slow_transient_outward_potassium_current__ass = 1 / (1.0 + exp(-2.9220779220779218 - 0.12987012987012986 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_ultra_rapidly_activating_delayed_rectifier_potassium_current__aur = (-var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__aur + var_slow_transient_outward_potassium_current__ass) / (2.0579999999999998 + 0.49299999999999999 * exp(-0.062899999999999998 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_ultra_rapidly_activating_delayed_rectifier_potassium_current__aur;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative33(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x265 = exp(-0.062899999999999998 * var_chaste_interface__membrane__V);
            const double var_x267 = 1 / (2.0579999999999998 + 0.49299999999999999 * var_x265);
            const double var_x270 = -var_x267;
            
            partialF = var_x270;
        }
        else
        {
            const double y_save = rY[33];
            rY[33] += delta;
            const double temp = EvaluateYDerivative33(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[33])/delta;
            rY[33] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative34(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = rY[34];
        // Units: dimensionless; Initial value: 0.998543
        
        
        // Mathematics
        const double var_slow_transient_outward_potassium_current__iss = 1 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_ultra_rapidly_activating_delayed_rectifier_potassium_current__iur = (-var_chaste_interface__ultra_rapidly_activating_delayed_rectifier_potassium_current__iur + var_slow_transient_outward_potassium_current__iss) / (1200.0 - 170.0 / (1.0 + exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_ultra_rapidly_activating_delayed_rectifier_potassium_current__iur;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative34(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x271 = exp(7.9298245614035094 + 0.17543859649122806 * var_chaste_interface__membrane__V);
            const double var_x272 = 1.0 + var_x271;
            const double var_x273 = 1 / var_x272;
            const double var_x284 = 1 / (1200.0 - 170.0 * var_x273);
            
            partialF = -var_x284;
        }
        else
        {
            const double y_save = rY[34];
            rY[34] += delta;
            const double temp = EvaluateYDerivative34(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[34])/delta;
            rY[34] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative35(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss = rY[35];
        // Units: dimensionless; Initial value: 0.000417069
        
        
        // Mathematics
        const double var_slow_transient_outward_potassium_current__ass = 1 / (1.0 + exp(-2.9220779220779218 - 0.12987012987012986 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__aKss = (-var_chaste_interface__non_inactivating_steady_state_potassium_current__aKss + var_slow_transient_outward_potassium_current__ass) / (13.17 + 39.299999999999997 * exp(-0.086199999999999999 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__aKss;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative35(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x285 = exp(-0.086199999999999999 * var_chaste_interface__membrane__V);
            const double var_x286 = 1 / (13.17 + 39.299999999999997 * var_x285);
            
            partialF = -var_x286;
        }
        else
        {
            const double y_save = rY[35];
            rY[35] += delta;
            const double temp = EvaluateYDerivative35(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[35])/delta;
            rY[35] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative36(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__iKss = 0; // 1 / millisecond

        return d_dt_chaste_interface_var_non_inactivating_steady_state_potassium_current__iKss;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative36(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = 0;
        }
        else
        {
            const double y_save = rY[36];
            rY[36] += delta;
            const double temp = EvaluateYDerivative36(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[36])/delta;
            rY[36] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative37(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 = rY[39];
        // Units: dimensionless; Initial value: 0.000641229
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K = rY[40];
        // Units: dimensionless; Initial value: 3.19129e-05
        
        
        // Mathematics
        const double var_rapid_delayed_rectifier_potassium_current__alpha_a1 = 0.013733 * exp(0.038198000000000003 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__alpha_i = 0.090820999999999999 * exp(0.11695499999999999 + 0.023390999999999999 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_a1 = 6.8899999999999994e-5 * exp(-0.041779999999999998 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_i = 0.0064970000000000002 * exp(-0.16339999999999999 - 0.032680000000000001 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__O_K = var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__alpha_a1 + var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K * var_rapid_delayed_rectifier_potassium_current__beta_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__alpha_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__beta_a1; // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__O_K;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative37(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x289 = exp(-0.041779999999999998 * var_chaste_interface__membrane__V);
            const double var_x291 = exp(0.11695499999999999 + 0.023390999999999999 * var_chaste_interface__membrane__V);
            const double var_x295 = 6.8899999999999994e-5 * var_x289;
            const double var_x296 = 0.090820999999999999 * var_x291;
            
            partialF = -var_x295 - var_x296;
        }
        else
        {
            const double y_save = rY[37];
            rY[37] += delta;
            const double temp = EvaluateYDerivative37(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[37])/delta;
            rY[37] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative38(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 = rY[38];
        // Units: dimensionless; Initial value: 0.000992513
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 = rY[39];
        // Units: dimensionless; Initial value: 0.000641229
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K = rY[40];
        // Units: dimensionless; Initial value: 3.19129e-05
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K1 = 0.036777999999999998 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 - 0.023761000000000001 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 + 0.022348 * (1.0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K - var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K) * exp(0.01176 * var_chaste_interface__membrane__V) - 0.047002000000000002 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 * exp(-0.063100000000000003 * var_chaste_interface__membrane__V); // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K1;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative38(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x299 = exp(0.01176 * var_chaste_interface__membrane__V);
            const double var_x300 = exp(-0.063100000000000003 * var_chaste_interface__membrane__V);
            const double var_x301 = -0.022348 * var_x299;
            
            partialF = -0.023761000000000001 + var_x301 - 0.047002000000000002 * var_x300;
        }
        else
        {
            const double y_save = rY[38];
            rY[38] += delta;
            const double temp = EvaluateYDerivative38(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[38])/delta;
            rY[38] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative39(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 = rY[38];
        // Units: dimensionless; Initial value: 0.000992513
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 = rY[39];
        // Units: dimensionless; Initial value: 0.000641229
        
        
        // Mathematics
        const double var_rapid_delayed_rectifier_potassium_current__alpha_a1 = 0.013733 * exp(0.038198000000000003 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_a1 = 6.8899999999999994e-5 * exp(-0.041779999999999998 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K2 = 0.023761000000000001 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K1 - 0.036777999999999998 * var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 + var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__beta_a1 - var_chaste_interface__rapid_delayed_rectifier_potassium_current__C_K2 * var_rapid_delayed_rectifier_potassium_current__alpha_a1; // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__C_K2;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative39(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x287 = exp(0.038198000000000003 * var_chaste_interface__membrane__V);
            const double var_x297 = 0.013733 * var_x287;
            
            partialF = -0.036777999999999998 - var_x297;
        }
        else
        {
            const double y_save = rY[39];
            rY[39] += delta;
            const double temp = EvaluateYDerivative39(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[39])/delta;
            rY[39] = y_save;
        }
        return partialF;
    }
    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluateYDerivative40(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -82.4202
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K = rY[37];
        // Units: dimensionless; Initial value: 0.000175298
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K = rY[40];
        // Units: dimensionless; Initial value: 3.19129e-05
        
        
        // Mathematics
        const double var_rapid_delayed_rectifier_potassium_current__alpha_i = 0.090820999999999999 * exp(0.11695499999999999 + 0.023390999999999999 * var_chaste_interface__membrane__V); // per_millisecond
        const double var_rapid_delayed_rectifier_potassium_current__beta_i = 0.0064970000000000002 * exp(-0.16339999999999999 - 0.032680000000000001 * var_chaste_interface__membrane__V); // per_millisecond
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__I_K = var_chaste_interface__rapid_delayed_rectifier_potassium_current__O_K * var_rapid_delayed_rectifier_potassium_current__alpha_i - var_chaste_interface__rapid_delayed_rectifier_potassium_current__I_K * var_rapid_delayed_rectifier_potassium_current__beta_i; // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current__I_K;
    }

    double Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::EvaluatePartialDerivative40(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -82.4202
            
            const double var_x293 = exp(-0.16339999999999999 - 0.032680000000000001 * var_chaste_interface__membrane__V);
            const double var_x298 = 0.0064970000000000002 * var_x293;
            
            partialF = -var_x298;
        }
        else
        {
            const double y_save = rY[40];
            rY[40] += delta;
            const double temp = EvaluateYDerivative40(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[40])/delta;
            rY[40] = y_save;
        }
        return partialF;
    }

    std::vector<double> Cellbondarenko_model_2004_apexFromCellMLGRL2Opt::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_membrane__i_stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellbondarenko_model_2004_apexFromCellMLGRL2Opt>::Initialise(void)
{
    this->mSystemName = "bondarenko_model_2004_apex";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-82.4202);

    // rY[1]:
    this->mVariableNames.push_back("calcium_concentration__Cai");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(0.115001);

    // rY[2]:
    this->mVariableNames.push_back("calcium_concentration__Cass");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(0.115001);

    // rY[3]:
    this->mVariableNames.push_back("calcium_concentration__CaJSR");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(1299.5);

    // rY[4]:
    this->mVariableNames.push_back("calcium_concentration__CaNSR");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(1299.5);

    // rY[5]:
    this->mVariableNames.push_back("calcium_fluxes__P_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[6]:
    this->mVariableNames.push_back("calcium_buffering__LTRPN_Ca");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(11.2684);

    // rY[7]:
    this->mVariableNames.push_back("calcium_buffering__HTRPN_Ca");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(125.29);

    // rY[8]:
    this->mVariableNames.push_back("ryanodine_receptors__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.49102e-05);

    // rY[9]:
    this->mVariableNames.push_back("ryanodine_receptors__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.51726e-11);

    // rY[10]:
    this->mVariableNames.push_back("ryanodine_receptors__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00016774);

    // rY[11]:
    this->mVariableNames.push_back("L_type_calcium_current__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.30308e-19);

    // rY[12]:
    this->mVariableNames.push_back("L_type_calcium_current__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000124216);

    // rY[13]:
    this->mVariableNames.push_back("L_type_calcium_current__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(5.78679e-09);

    // rY[14]:
    this->mVariableNames.push_back("L_type_calcium_current__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.19816e-13);

    // rY[15]:
    this->mVariableNames.push_back("L_type_calcium_current__I1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(4.97923e-19);

    // rY[16]:
    this->mVariableNames.push_back("L_type_calcium_current__I2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.45847e-14);

    // rY[17]:
    this->mVariableNames.push_back("L_type_calcium_current__I3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.85106e-14);

    // rY[18]:
    this->mVariableNames.push_back("sodium_concentration__Nai");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(14237.1);

    // rY[19]:
    this->mVariableNames.push_back("fast_sodium_current__O_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.13483e-07);

    // rY[20]:
    this->mVariableNames.push_back("fast_sodium_current__C_Na1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000279132);

    // rY[21]:
    this->mVariableNames.push_back("fast_sodium_current__C_Na2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.020752);

    // rY[22]:
    this->mVariableNames.push_back("fast_sodium_current__I1_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.73345e-07);

    // rY[23]:
    this->mVariableNames.push_back("fast_sodium_current__I2_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.55787e-09);

    // rY[24]:
    this->mVariableNames.push_back("fast_sodium_current__IF_Na");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000153176);

    // rY[25]:
    this->mVariableNames.push_back("fast_sodium_current__IC_Na2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0113879);

    // rY[26]:
    this->mVariableNames.push_back("fast_sodium_current__IC_Na3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.34278);

    // rY[27]:
    this->mVariableNames.push_back("potassium_concentration__Ki");
    this->mVariableUnits.push_back("micromolar");
    this->mInitialConditions.push_back(143720.0);

    // rY[28]:
    this->mVariableNames.push_back("fast_transient_outward_potassium_current__ato_f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00265563);

    // rY[29]:
    this->mVariableNames.push_back("fast_transient_outward_potassium_current__ito_f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999977);

    // rY[30]:
    this->mVariableNames.push_back("slow_transient_outward_potassium_current__ato_s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // rY[31]:
    this->mVariableNames.push_back("slow_transient_outward_potassium_current__ito_s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.998543);

    // rY[32]:
    this->mVariableNames.push_back("slow_delayed_rectifier_potassium_current__nKs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000262753);

    // rY[33]:
    this->mVariableNames.push_back("ultra_rapidly_activating_delayed_rectifier_potassium_current__aur");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // rY[34]:
    this->mVariableNames.push_back("ultra_rapidly_activating_delayed_rectifier_potassium_current__iur");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.998543);

    // rY[35]:
    this->mVariableNames.push_back("non_inactivating_steady_state_potassium_current__aKss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417069);

    // rY[36]:
    this->mVariableNames.push_back("non_inactivating_steady_state_potassium_current__iKss");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // rY[37]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__O_K");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000175298);

    // rY[38]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__C_K1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000992513);

    // rY[39]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__C_K2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000641229);

    // rY[40]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current__I_K");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.19129e-05);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.0002;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellbondarenko_model_2004_apexFromCellMLGRL2Opt)

