//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: zhang_SAN_model_2000_all
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "zhang_SAN_model_2000_all.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"


    Cellzhang_SAN_model_2000_allFromCellMLGRL2::Cellzhang_SAN_model_2000_allFromCellMLGRL2(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                15,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellzhang_SAN_model_2000_allFromCellMLGRL2>::Instance();
        Init();
        
    }

    Cellzhang_SAN_model_2000_allFromCellMLGRL2::~Cellzhang_SAN_model_2000_allFromCellMLGRL2()
    {
    }
    
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.092361701692
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.015905380261
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.01445216109
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 0.04804900895
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.48779845203
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.42074047435
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.038968420558
        double var_chaste_interface__four_AP_sensitive_currents_q_gate__q = rY[8];
        // Units: dimensionless; Initial value: 0.29760539675
        double var_chaste_interface__four_AP_sensitive_currents_r_gate__r = rY[9];
        // Units: dimensionless; Initial value: 0.064402950262
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af = rY[10];
        // Units: dimensionless; Initial value: 0.13034201158
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as = rY[11];
        // Units: dimensionless; Initial value: 0.46960956028
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i = rY[12];
        // Units: dimensionless; Initial value: 0.87993375273
        double var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs = rY[13];
        // Units: dimensionless; Initial value: 0.082293827208
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[14];
        // Units: dimensionless; Initial value: 0.03889291759
        
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable = 0.0057938; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable = 0.0082000000000000007; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Centre_Published = 0.0057999999999999996; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Periphery_0DCapable = 0.065886479999999997; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Periphery_1DCapable = 0.0659; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Periphery_Published = 0.0659; // microS
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable = 0.0042780600000000002; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable = 0.0020999999999999999; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Centre_Published = 0.0043; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Periphery_0DCapable = 0.0138823; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Periphery_1DCapable = 0.00694; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Periphery_Published = 0.013899999999999999; // microS
        const double var_calcium_background_current__g_b_Ca_Centre_0DCapable = 1.3236e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Centre_1DCapable = 1.323e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Centre_Published = 1.3200000000000001e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Periphery_0DCapable = 4.2951999999999998e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Periphery_1DCapable = 4.2899999999999999e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Periphery_Published = 4.3000000000000002e-5; // microS
        const double var_four_AP_sensitive_currents__g_sus_Centre_0DCapable = 6.6455040000000003e-5; // microS
        const double var_four_AP_sensitive_currents__g_sus_Centre_1DCapable = 0.00026600000000000001; // microS
        const double var_four_AP_sensitive_currents__g_sus_Centre_Published = 6.6500000000000004e-5; // microS
        const double var_four_AP_sensitive_currents__g_sus_Periphery_0DCapable = 0.01138376; // microS
        const double var_four_AP_sensitive_currents__g_sus_Periphery_1DCapable = 0.0114; // microS
        const double var_four_AP_sensitive_currents__g_sus_Periphery_Published = 0.0114; // microS
        const double var_four_AP_sensitive_currents__g_to_Centre_0DCapable = 0.0049049999999999996; // microS
        const double var_four_AP_sensitive_currents__g_to_Centre_1DCapable = 0.0049049999999999996; // microS
        const double var_four_AP_sensitive_currents__g_to_Centre_Published = 0.0049100000000000003; // microS
        const double var_four_AP_sensitive_currents__g_to_Periphery_0DCapable = 0.036495; // microS
        const double var_four_AP_sensitive_currents__g_to_Periphery_1DCapable = 0.036499999999999998; // microS
        const double var_four_AP_sensitive_currents__g_to_Periphery_Published = 0.036490000000000002; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable = 0.0005465; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable = 0.000437; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Centre_Published = 0.00054799999999999998; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Periphery_0DCapable = 0.006875; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Periphery_1DCapable = 0.0054999999999999997; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Periphery_Published = 0.0068999999999999999; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable = 0.0005465; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable = 0.000437; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Centre_Published = 0.00054799999999999998; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_0DCapable = 0.006875; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_1DCapable = 0.0054999999999999997; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_Published = 0.0068999999999999999; // microS
        const double var_ionic_concentrations__Ca_i = 0.0001; // millimolar
        const double var_ionic_concentrations__Ca_o = 2.0; // millimolar
        const double var_ionic_concentrations__K_i = 140.0; // millimolar
        const double var_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_ionic_concentrations__Na_i = 8.0; // millimolar
        const double var_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_membrane__F = 96845.0; // coulomb_per_mole
        const double var_membrane__FCellConstant = 1.0309347; // dimensionless
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_membrane__dCell = 0; // dimensionless
        const double var_membrane__FCell = ((var_membrane__Version == 0) ? (0.35666666666666669 * (-0.10000000000000001 + 3.0 * var_membrane__dCell) / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : ((var_membrane__Version == 1.0) ? (var_membrane__FCellConstant * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : (1.0343333333333333 * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(12.564102564102564 - 14.871794871794872 * var_membrane__dCell))))); // dimensionless
        const double var_L_type_Ca_channel__g_Ca_L = ((var_membrane__Version == 0) ? ((-var_L_type_Ca_channel__g_Ca_L_Centre_Published + var_L_type_Ca_channel__g_Ca_L_Periphery_Published) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable + var_L_type_Ca_channel__g_Ca_L_Periphery_0DCapable) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable) : ((-var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable + var_L_type_Ca_channel__g_Ca_L_Periphery_1DCapable) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable))); // microS
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.0060000000000000001 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_T_type_Ca_channel__g_Ca_T = ((var_membrane__Version == 0) ? ((-var_T_type_Ca_channel__g_Ca_T_Centre_Published + var_T_type_Ca_channel__g_Ca_T_Periphery_Published) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable + var_T_type_Ca_channel__g_Ca_T_Periphery_0DCapable) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable) : ((-var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable + var_T_type_Ca_channel__g_Ca_T_Periphery_1DCapable) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable))); // microS
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_calcium_background_current__g_b_Ca = ((var_membrane__Version == 0) ? ((-var_calcium_background_current__g_b_Ca_Centre_Published + var_calcium_background_current__g_b_Ca_Periphery_Published) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_calcium_background_current__g_b_Ca_Centre_0DCapable + var_calcium_background_current__g_b_Ca_Periphery_0DCapable) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_0DCapable) : ((-var_calcium_background_current__g_b_Ca_Centre_1DCapable + var_calcium_background_current__g_b_Ca_Periphery_1DCapable) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_1DCapable))); // microS
        const double var_four_AP_sensitive_currents__g_sus = ((var_membrane__Version == 0) ? ((-var_four_AP_sensitive_currents__g_sus_Centre_Published + var_four_AP_sensitive_currents__g_sus_Periphery_Published) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_four_AP_sensitive_currents__g_sus_Centre_0DCapable + var_four_AP_sensitive_currents__g_sus_Periphery_0DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_0DCapable) : ((-var_four_AP_sensitive_currents__g_sus_Centre_1DCapable + var_four_AP_sensitive_currents__g_sus_Periphery_1DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_1DCapable))); // microS
        const double var_four_AP_sensitive_currents__g_to = ((var_membrane__Version == 0) ? ((-var_four_AP_sensitive_currents__g_to_Centre_Published + var_four_AP_sensitive_currents__g_to_Periphery_Published) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_four_AP_sensitive_currents__g_to_Centre_0DCapable + var_four_AP_sensitive_currents__g_to_Periphery_0DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_0DCapable) : ((-var_four_AP_sensitive_currents__g_to_Centre_1DCapable + var_four_AP_sensitive_currents__g_to_Periphery_1DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_1DCapable))); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = ((var_membrane__Version == 0) ? ((-var_hyperpolarisation_activated_current__g_f_K_Centre_Published + var_hyperpolarisation_activated_current__g_f_K_Periphery_Published) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable + var_hyperpolarisation_activated_current__g_f_K_Periphery_0DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable) : ((-var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable + var_hyperpolarisation_activated_current__g_f_K_Periphery_1DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable))); // microS
        const double var_hyperpolarisation_activated_current__g_f_Na = ((var_membrane__Version == 0) ? ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_Published + var_hyperpolarisation_activated_current__g_f_Na_Periphery_Published) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable + var_hyperpolarisation_activated_current__g_f_Na_Periphery_0DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable) : ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable + var_hyperpolarisation_activated_current__g_f_Na_Periphery_1DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable))); // microS
        const double var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable = 0.0041999999999999997; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Centre_Published = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Periphery_0DCapable = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Periphery_1DCapable = 0.033390000000000003; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Periphery_Published = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max = ((var_membrane__Version == 0) ? ((-var_persistent_calcium_current__i_Ca_p_max_Centre_Published + var_persistent_calcium_current__i_Ca_p_max_Periphery_Published) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable + var_persistent_calcium_current__i_Ca_p_max_Periphery_0DCapable) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable) : ((-var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable + var_persistent_calcium_current__i_Ca_p_max_Periphery_1DCapable) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable))); // nanoA
        const double var_persistent_calcium_current__i_Ca_p = var_ionic_concentrations__Ca_i * var_persistent_calcium_current__i_Ca_p_max / (0.00040000000000000002 + var_ionic_concentrations__Ca_i); // nanoA
        const double var_potassium_background_current__g_b_K_Centre_0DCapable = 2.5236359999999998e-5; // microS
        const double var_potassium_background_current__g_b_K_Centre_1DCapable = 2.5199999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K_Centre_Published = 2.5199999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K_Periphery_0DCapable = 8.1891999999999995e-5; // microS
        const double var_potassium_background_current__g_b_K_Periphery_1DCapable = 8.1899999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K_Periphery_Published = 8.1899999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K = ((var_membrane__Version == 0) ? ((-var_potassium_background_current__g_b_K_Centre_Published + var_potassium_background_current__g_b_K_Periphery_Published) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_potassium_background_current__g_b_K_Centre_0DCapable + var_potassium_background_current__g_b_K_Periphery_0DCapable) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_0DCapable) : ((-var_potassium_background_current__g_b_K_Centre_1DCapable + var_potassium_background_current__g_b_K_Periphery_1DCapable) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_1DCapable))); // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable = 0.00079704000000000005; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable = 0.00073800000000000005; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published = 0.00079699999999999997; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_0DCapable = 0.016; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_1DCapable = 0.020799999999999999; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_Published = 0.016; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r = ((var_membrane__Version == 0) ? ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_Published) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_0DCapable) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable) : ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_1DCapable) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable))); // microS
        const double var_rapid_delayed_rectifying_potassium_current__P_a = 0.40000000000000002 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as + 0.59999999999999998 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af; // dimensionless
        const double var_reversal_and_equilibrium_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Ca_o / var_ionic_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_and_equilibrium_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_b_Ca; // nanoA
        const double var_reversal_and_equilibrium_potentials__E_K = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__K_o / var_ionic_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_four_AP_sensitive_currents__i_sus = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_four_AP_sensitive_currents__g_sus * var_chaste_interface__four_AP_sensitive_currents_r_gate__r; // nanoA
        const double var_four_AP_sensitive_currents__i_to = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_four_AP_sensitive_currents__g_to * var_chaste_interface__four_AP_sensitive_currents_q_gate__q * var_chaste_interface__four_AP_sensitive_currents_r_gate__r; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = ((var_membrane__Version != 2.0) ? ((-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) : ((102.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y)); // nanoA
        const double var_potassium_background_current__i_b_K = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_background_current__g_b_K; // nanoA
        const double var_rapid_delayed_rectifying_potassium_current__i_K_r = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_rapid_delayed_rectifying_potassium_current__P_a * var_rapid_delayed_rectifying_potassium_current__g_K_r * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_reversal_and_equilibrium_potentials__E_K_s = ((var_membrane__Version == 0) ? (var_membrane__R * var_membrane__T * log((var_ionic_concentrations__K_o + 0.12 * var_ionic_concentrations__Na_o) / (var_ionic_concentrations__K_i + 0.12 * var_ionic_concentrations__Na_i)) / var_membrane__F) : (var_membrane__R * var_membrane__T * log((var_ionic_concentrations__K_o + 0.029999999999999999 * var_ionic_concentrations__Na_o) / (var_ionic_concentrations__K_i + 0.029999999999999999 * var_ionic_concentrations__Na_i)) / var_membrane__F)); // millivolt
        const double var_reversal_and_equilibrium_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Na_o / var_ionic_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_hyperpolarisation_activated_current__i_f_Na = ((var_membrane__Version != 2.0) ? ((-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) : ((-77.599999999999994 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y)); // nanoA
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable = 0.00034450000000000003; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable = 0.00034499999999999998; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published = 0.00051800000000000001; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_0DCapable = 0.0104; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_1DCapable = 0.0104; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_Published = 0.0104; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s = ((var_membrane__Version == 0) ? ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_Published) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_0DCapable) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable) : ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_1DCapable) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable))); // microS
        const double var_slow_delayed_rectifying_potassium_current__i_K_s = pow(var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs, 2) * (-var_reversal_and_equilibrium_potentials__E_K_s + var_chaste_interface__membrane__V) * var_slow_delayed_rectifying_potassium_current__g_K_s; // nanoA
        const double var_sodium_background_current__g_b_Na_Centre_0DCapable = 5.8181799999999999e-5; // microS
        const double var_sodium_background_current__g_b_Na_Centre_1DCapable = 5.8e-5; // microS
        const double var_sodium_background_current__g_b_Na_Centre_Published = 5.8e-5; // microS
        const double var_sodium_background_current__g_b_Na_Periphery_0DCapable = 0.00018880000000000001; // microS
        const double var_sodium_background_current__g_b_Na_Periphery_1DCapable = 0.00018900000000000001; // microS
        const double var_sodium_background_current__g_b_Na_Periphery_Published = 0.00018900000000000001; // microS
        const double var_sodium_background_current__g_b_Na = ((var_membrane__Version == 0) ? ((-var_sodium_background_current__g_b_Na_Centre_Published + var_sodium_background_current__g_b_Na_Periphery_Published) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_background_current__g_b_Na_Centre_0DCapable + var_sodium_background_current__g_b_Na_Periphery_0DCapable) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_0DCapable) : ((-var_sodium_background_current__g_b_Na_Centre_1DCapable + var_sodium_background_current__g_b_Na_Periphery_1DCapable) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_1DCapable))); // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_b_Na; // nanoA
        const double var_sodium_calcium_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_exchanger__gamma_NaCa = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable = 2.7228999999999998e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable = 2.7999999999999999e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Centre_Published = 2.7e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Periphery_0DCapable = 8.8358400000000004e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Periphery_1DCapable = 8.8000000000000004e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Periphery_Published = 8.8000000000000004e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa = ((var_membrane__Version == 0) ? ((-var_sodium_calcium_exchanger__k_NaCa_Centre_Published + var_sodium_calcium_exchanger__k_NaCa_Periphery_Published) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable + var_sodium_calcium_exchanger__k_NaCa_Periphery_0DCapable) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable) : ((-var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable + var_sodium_calcium_exchanger__k_NaCa_Periphery_1DCapable) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable))); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa = ((var_membrane__Version == 0) ? ((pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma_NaCa) - pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i * exp(0.037400000000000003 * (-1.0 + var_sodium_calcium_exchanger__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_sodium_calcium_exchanger__k_NaCa / (1.0 + (pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o + pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i) * var_sodium_calcium_exchanger__d_NaCa)) : ((pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma_NaCa) - pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_exchanger__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_sodium_calcium_exchanger__k_NaCa / (1.0 + (pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o + pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i) * var_sodium_calcium_exchanger__d_NaCa))); // nanoA
        const double var_sodium_current__g_Na_Centre_0DCapable = 0; // microlitre_per_second
        const double var_sodium_current__g_Na_Centre_1DCapable = 0; // microlitre_per_second
        const double var_sodium_current__g_Na_Centre_Published = 0; // microlitre_per_second
        const double var_sodium_current__g_Na_Periphery_0DCapable = 1.204e-6; // microlitre_per_second
        const double var_sodium_current__g_Na_Periphery_1DCapable = 3.7e-7; // microlitre_per_second
        const double var_sodium_current__g_Na_Periphery_Published = 1.1999999999999999e-6; // microlitre_per_second
        const double var_sodium_current__g_Na = ((var_membrane__Version == 0) ? ((-var_sodium_current__g_Na_Centre_Published + var_sodium_current__g_Na_Periphery_Published) * var_membrane__FCell + var_sodium_current__g_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_current__g_Na_Centre_0DCapable + var_sodium_current__g_Na_Periphery_0DCapable) * var_membrane__FCell + var_sodium_current__g_Na_Centre_0DCapable) : ((-var_sodium_current__g_Na_Centre_1DCapable + var_sodium_current__g_Na_Periphery_1DCapable) * var_membrane__FCell + var_sodium_current__g_Na_Centre_1DCapable))); // microlitre_per_second
        const double var_sodium_current_h_gate__F_Na = ((var_membrane__Version == 0) ? (0.086900000000000005 + 0.095200000000000007 * exp(-2.1671999999999998 - 0.063 * var_chaste_interface__membrane__V) / (1.0 + 1.6599999999999999 * exp(-14.332500000000001 - 0.22500000000000001 * var_chaste_interface__membrane__V))) : (0.086929999999999993 + 0.095180000000000001 * exp(-2.1692640000000001 - 0.063060000000000005 * var_chaste_interface__membrane__V) / (1.0 + 1.6619999999999999 * exp(-14.33887 - 0.22509999999999999 * var_chaste_interface__membrane__V)))); // dimensionless
        const double var_sodium_current_h_gate__h = (1.0 - var_sodium_current_h_gate__F_Na) * var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__F_Na * var_chaste_interface__sodium_current_h_gate__h2; // dimensionless
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_ionic_concentrations__Na_o * var_chaste_interface__membrane__V * var_sodium_current__g_Na * var_sodium_current_h_gate__h / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.6399999999999997; // millimolar
        const double var_sodium_potassium_pump__i_p_max_Centre_0DCapable = 0.047825449999999999; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Centre_1DCapable = 0.047800000000000002; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Centre_Published = 0.047800000000000002; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Periphery_0DCapable = 0.15519359999999999; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Periphery_1DCapable = 0.16; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Periphery_Published = 0.16; // nanoA
        const double var_sodium_potassium_pump__i_p_max = ((var_membrane__Version == 0) ? ((-var_sodium_potassium_pump__i_p_max_Centre_Published + var_sodium_potassium_pump__i_p_max_Periphery_Published) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_potassium_pump__i_p_max_Centre_0DCapable + var_sodium_potassium_pump__i_p_max_Periphery_0DCapable) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_0DCapable) : ((-var_sodium_potassium_pump__i_p_max_Centre_1DCapable + var_sodium_potassium_pump__i_p_max_Periphery_1DCapable) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_1DCapable))); // nanoA
        const double var_sodium_potassium_pump__i_p = 1.6000000000000001 * pow(var_ionic_concentrations__K_o, 2) * pow(var_ionic_concentrations__Na_i, 3) * var_sodium_potassium_pump__i_p_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_ionic_concentrations__K_o + var_sodium_potassium_pump__K_m_K), 2) * pow((var_ionic_concentrations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_b_Ca + var_four_AP_sensitive_currents__i_sus + var_four_AP_sensitive_currents__i_to + var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na + var_persistent_calcium_current__i_Ca_p + var_potassium_background_current__i_b_K + var_rapid_delayed_rectifying_potassium_current__i_K_r + var_slow_delayed_rectifying_potassium_current__i_K_s + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_p) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellzhang_SAN_model_2000_allFromCellMLGRL2::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.092361701692
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.015905380261
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.01445216109
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 0.04804900895
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.48779845203
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.42074047435
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.038968420558
        double var_chaste_interface__four_AP_sensitive_currents_q_gate__q = rY[8];
        // Units: dimensionless; Initial value: 0.29760539675
        double var_chaste_interface__four_AP_sensitive_currents_r_gate__r = rY[9];
        // Units: dimensionless; Initial value: 0.064402950262
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af = rY[10];
        // Units: dimensionless; Initial value: 0.13034201158
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as = rY[11];
        // Units: dimensionless; Initial value: 0.46960956028
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i = rY[12];
        // Units: dimensionless; Initial value: 0.87993375273
        double var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs = rY[13];
        // Units: dimensionless; Initial value: 0.082293827208
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[14];
        // Units: dimensionless; Initial value: 0.03889291759
        

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable = 0.0057938; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable = 0.0082000000000000007; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Centre_Published = 0.0057999999999999996; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Periphery_0DCapable = 0.065886479999999997; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Periphery_1DCapable = 0.0659; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Periphery_Published = 0.0659; // microS
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable = 0.0042780600000000002; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable = 0.0020999999999999999; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Centre_Published = 0.0043; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Periphery_0DCapable = 0.0138823; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Periphery_1DCapable = 0.00694; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Periphery_Published = 0.013899999999999999; // microS
        const double var_calcium_background_current__g_b_Ca_Centre_0DCapable = 1.3236e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Centre_1DCapable = 1.323e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Centre_Published = 1.3200000000000001e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Periphery_0DCapable = 4.2951999999999998e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Periphery_1DCapable = 4.2899999999999999e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Periphery_Published = 4.3000000000000002e-5; // microS
        const double var_four_AP_sensitive_currents__g_sus_Centre_0DCapable = 6.6455040000000003e-5; // microS
        const double var_four_AP_sensitive_currents__g_sus_Centre_1DCapable = 0.00026600000000000001; // microS
        const double var_four_AP_sensitive_currents__g_sus_Centre_Published = 6.6500000000000004e-5; // microS
        const double var_four_AP_sensitive_currents__g_sus_Periphery_0DCapable = 0.01138376; // microS
        const double var_four_AP_sensitive_currents__g_sus_Periphery_1DCapable = 0.0114; // microS
        const double var_four_AP_sensitive_currents__g_sus_Periphery_Published = 0.0114; // microS
        const double var_four_AP_sensitive_currents__g_to_Centre_0DCapable = 0.0049049999999999996; // microS
        const double var_four_AP_sensitive_currents__g_to_Centre_1DCapable = 0.0049049999999999996; // microS
        const double var_four_AP_sensitive_currents__g_to_Centre_Published = 0.0049100000000000003; // microS
        const double var_four_AP_sensitive_currents__g_to_Periphery_0DCapable = 0.036495; // microS
        const double var_four_AP_sensitive_currents__g_to_Periphery_1DCapable = 0.036499999999999998; // microS
        const double var_four_AP_sensitive_currents__g_to_Periphery_Published = 0.036490000000000002; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable = 0.0005465; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable = 0.000437; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Centre_Published = 0.00054799999999999998; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Periphery_0DCapable = 0.006875; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Periphery_1DCapable = 0.0054999999999999997; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Periphery_Published = 0.0068999999999999999; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable = 0.0005465; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable = 0.000437; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Centre_Published = 0.00054799999999999998; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_0DCapable = 0.006875; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_1DCapable = 0.0054999999999999997; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_Published = 0.0068999999999999999; // microS
        const double var_ionic_concentrations__Ca_i = 0.0001; // millimolar
        const double var_ionic_concentrations__Ca_o = 2.0; // millimolar
        const double var_ionic_concentrations__K_i = 140.0; // millimolar
        const double var_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_ionic_concentrations__Na_i = 8.0; // millimolar
        const double var_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_membrane__CmCentre = 2.0000000000000002e-5; // microF
        const double var_membrane__CmPeriphery = 6.4999999999999994e-5; // microF
        const double var_membrane__F = 96845.0; // coulomb_per_mole
        const double var_membrane__FCellConstant = 1.0309347; // dimensionless
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_membrane__dCell = 0; // dimensionless
        const double var_membrane__FCell = ((var_membrane__Version == 0) ? (0.35666666666666669 * (-0.10000000000000001 + 3.0 * var_membrane__dCell) / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : ((var_membrane__Version == 1.0) ? (var_membrane__FCellConstant * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : (1.0343333333333333 * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(12.564102564102564 - 14.871794871794872 * var_membrane__dCell))))); // dimensionless
        const double var_L_type_Ca_channel__g_Ca_L = ((var_membrane__Version == 0) ? ((-var_L_type_Ca_channel__g_Ca_L_Centre_Published + var_L_type_Ca_channel__g_Ca_L_Periphery_Published) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable + var_L_type_Ca_channel__g_Ca_L_Periphery_0DCapable) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable) : ((-var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable + var_L_type_Ca_channel__g_Ca_L_Periphery_1DCapable) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable))); // microS
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.0060000000000000001 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_T_type_Ca_channel__g_Ca_T = ((var_membrane__Version == 0) ? ((-var_T_type_Ca_channel__g_Ca_T_Centre_Published + var_T_type_Ca_channel__g_Ca_T_Periphery_Published) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable + var_T_type_Ca_channel__g_Ca_T_Periphery_0DCapable) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable) : ((-var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable + var_T_type_Ca_channel__g_Ca_T_Periphery_1DCapable) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable))); // microS
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_calcium_background_current__g_b_Ca = ((var_membrane__Version == 0) ? ((-var_calcium_background_current__g_b_Ca_Centre_Published + var_calcium_background_current__g_b_Ca_Periphery_Published) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_calcium_background_current__g_b_Ca_Centre_0DCapable + var_calcium_background_current__g_b_Ca_Periphery_0DCapable) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_0DCapable) : ((-var_calcium_background_current__g_b_Ca_Centre_1DCapable + var_calcium_background_current__g_b_Ca_Periphery_1DCapable) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_1DCapable))); // microS
        const double var_four_AP_sensitive_currents__g_sus = ((var_membrane__Version == 0) ? ((-var_four_AP_sensitive_currents__g_sus_Centre_Published + var_four_AP_sensitive_currents__g_sus_Periphery_Published) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_four_AP_sensitive_currents__g_sus_Centre_0DCapable + var_four_AP_sensitive_currents__g_sus_Periphery_0DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_0DCapable) : ((-var_four_AP_sensitive_currents__g_sus_Centre_1DCapable + var_four_AP_sensitive_currents__g_sus_Periphery_1DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_1DCapable))); // microS
        const double var_four_AP_sensitive_currents__g_to = ((var_membrane__Version == 0) ? ((-var_four_AP_sensitive_currents__g_to_Centre_Published + var_four_AP_sensitive_currents__g_to_Periphery_Published) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_four_AP_sensitive_currents__g_to_Centre_0DCapable + var_four_AP_sensitive_currents__g_to_Periphery_0DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_0DCapable) : ((-var_four_AP_sensitive_currents__g_to_Centre_1DCapable + var_four_AP_sensitive_currents__g_to_Periphery_1DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_1DCapable))); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = ((var_membrane__Version == 0) ? ((-var_hyperpolarisation_activated_current__g_f_K_Centre_Published + var_hyperpolarisation_activated_current__g_f_K_Periphery_Published) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable + var_hyperpolarisation_activated_current__g_f_K_Periphery_0DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable) : ((-var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable + var_hyperpolarisation_activated_current__g_f_K_Periphery_1DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable))); // microS
        const double var_hyperpolarisation_activated_current__g_f_Na = ((var_membrane__Version == 0) ? ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_Published + var_hyperpolarisation_activated_current__g_f_Na_Periphery_Published) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable + var_hyperpolarisation_activated_current__g_f_Na_Periphery_0DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable) : ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable + var_hyperpolarisation_activated_current__g_f_Na_Periphery_1DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable))); // microS
        const double var_membrane__Cm = (-var_membrane__CmCentre + var_membrane__CmPeriphery) * var_membrane__FCell + var_membrane__CmCentre; // microF
        const double var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable = 0.0041999999999999997; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Centre_Published = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Periphery_0DCapable = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Periphery_1DCapable = 0.033390000000000003; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Periphery_Published = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max = ((var_membrane__Version == 0) ? ((-var_persistent_calcium_current__i_Ca_p_max_Centre_Published + var_persistent_calcium_current__i_Ca_p_max_Periphery_Published) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable + var_persistent_calcium_current__i_Ca_p_max_Periphery_0DCapable) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable) : ((-var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable + var_persistent_calcium_current__i_Ca_p_max_Periphery_1DCapable) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable))); // nanoA
        const double var_persistent_calcium_current__i_Ca_p = var_ionic_concentrations__Ca_i * var_persistent_calcium_current__i_Ca_p_max / (0.00040000000000000002 + var_ionic_concentrations__Ca_i); // nanoA
        const double var_potassium_background_current__g_b_K_Centre_0DCapable = 2.5236359999999998e-5; // microS
        const double var_potassium_background_current__g_b_K_Centre_1DCapable = 2.5199999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K_Centre_Published = 2.5199999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K_Periphery_0DCapable = 8.1891999999999995e-5; // microS
        const double var_potassium_background_current__g_b_K_Periphery_1DCapable = 8.1899999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K_Periphery_Published = 8.1899999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K = ((var_membrane__Version == 0) ? ((-var_potassium_background_current__g_b_K_Centre_Published + var_potassium_background_current__g_b_K_Periphery_Published) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_potassium_background_current__g_b_K_Centre_0DCapable + var_potassium_background_current__g_b_K_Periphery_0DCapable) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_0DCapable) : ((-var_potassium_background_current__g_b_K_Centre_1DCapable + var_potassium_background_current__g_b_K_Periphery_1DCapable) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_1DCapable))); // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable = 0.00079704000000000005; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable = 0.00073800000000000005; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published = 0.00079699999999999997; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_0DCapable = 0.016; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_1DCapable = 0.020799999999999999; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_Published = 0.016; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r = ((var_membrane__Version == 0) ? ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_Published) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_0DCapable) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable) : ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_1DCapable) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable))); // microS
        const double var_rapid_delayed_rectifying_potassium_current__P_a = 0.40000000000000002 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as + 0.59999999999999998 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af; // dimensionless
        const double var_reversal_and_equilibrium_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Ca_o / var_ionic_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_and_equilibrium_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_b_Ca; // nanoA
        const double var_reversal_and_equilibrium_potentials__E_K = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__K_o / var_ionic_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_four_AP_sensitive_currents__i_sus = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_four_AP_sensitive_currents__g_sus * var_chaste_interface__four_AP_sensitive_currents_r_gate__r; // nanoA
        const double var_four_AP_sensitive_currents__i_to = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_four_AP_sensitive_currents__g_to * var_chaste_interface__four_AP_sensitive_currents_q_gate__q * var_chaste_interface__four_AP_sensitive_currents_r_gate__r; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = ((var_membrane__Version != 2.0) ? ((-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) : ((102.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y)); // nanoA
        const double var_potassium_background_current__i_b_K = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_background_current__g_b_K; // nanoA
        const double var_rapid_delayed_rectifying_potassium_current__i_K_r = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_rapid_delayed_rectifying_potassium_current__P_a * var_rapid_delayed_rectifying_potassium_current__g_K_r * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_reversal_and_equilibrium_potentials__E_K_s = ((var_membrane__Version == 0) ? (var_membrane__R * var_membrane__T * log((var_ionic_concentrations__K_o + 0.12 * var_ionic_concentrations__Na_o) / (var_ionic_concentrations__K_i + 0.12 * var_ionic_concentrations__Na_i)) / var_membrane__F) : (var_membrane__R * var_membrane__T * log((var_ionic_concentrations__K_o + 0.029999999999999999 * var_ionic_concentrations__Na_o) / (var_ionic_concentrations__K_i + 0.029999999999999999 * var_ionic_concentrations__Na_i)) / var_membrane__F)); // millivolt
        const double var_reversal_and_equilibrium_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Na_o / var_ionic_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_hyperpolarisation_activated_current__i_f_Na = ((var_membrane__Version != 2.0) ? ((-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) : ((-77.599999999999994 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y)); // nanoA
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable = 0.00034450000000000003; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable = 0.00034499999999999998; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published = 0.00051800000000000001; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_0DCapable = 0.0104; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_1DCapable = 0.0104; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_Published = 0.0104; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s = ((var_membrane__Version == 0) ? ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_Published) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_0DCapable) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable) : ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_1DCapable) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable))); // microS
        const double var_slow_delayed_rectifying_potassium_current__i_K_s = pow(var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs, 2) * (-var_reversal_and_equilibrium_potentials__E_K_s + var_chaste_interface__membrane__V) * var_slow_delayed_rectifying_potassium_current__g_K_s; // nanoA
        const double var_sodium_background_current__g_b_Na_Centre_0DCapable = 5.8181799999999999e-5; // microS
        const double var_sodium_background_current__g_b_Na_Centre_1DCapable = 5.8e-5; // microS
        const double var_sodium_background_current__g_b_Na_Centre_Published = 5.8e-5; // microS
        const double var_sodium_background_current__g_b_Na_Periphery_0DCapable = 0.00018880000000000001; // microS
        const double var_sodium_background_current__g_b_Na_Periphery_1DCapable = 0.00018900000000000001; // microS
        const double var_sodium_background_current__g_b_Na_Periphery_Published = 0.00018900000000000001; // microS
        const double var_sodium_background_current__g_b_Na = ((var_membrane__Version == 0) ? ((-var_sodium_background_current__g_b_Na_Centre_Published + var_sodium_background_current__g_b_Na_Periphery_Published) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_background_current__g_b_Na_Centre_0DCapable + var_sodium_background_current__g_b_Na_Periphery_0DCapable) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_0DCapable) : ((-var_sodium_background_current__g_b_Na_Centre_1DCapable + var_sodium_background_current__g_b_Na_Periphery_1DCapable) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_1DCapable))); // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_b_Na; // nanoA
        const double var_sodium_calcium_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_exchanger__gamma_NaCa = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable = 2.7228999999999998e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable = 2.7999999999999999e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Centre_Published = 2.7e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Periphery_0DCapable = 8.8358400000000004e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Periphery_1DCapable = 8.8000000000000004e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Periphery_Published = 8.8000000000000004e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa = ((var_membrane__Version == 0) ? ((-var_sodium_calcium_exchanger__k_NaCa_Centre_Published + var_sodium_calcium_exchanger__k_NaCa_Periphery_Published) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable + var_sodium_calcium_exchanger__k_NaCa_Periphery_0DCapable) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable) : ((-var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable + var_sodium_calcium_exchanger__k_NaCa_Periphery_1DCapable) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable))); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa = ((var_membrane__Version == 0) ? ((pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma_NaCa) - pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i * exp(0.037400000000000003 * (-1.0 + var_sodium_calcium_exchanger__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_sodium_calcium_exchanger__k_NaCa / (1.0 + (pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o + pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i) * var_sodium_calcium_exchanger__d_NaCa)) : ((pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma_NaCa) - pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_exchanger__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_sodium_calcium_exchanger__k_NaCa / (1.0 + (pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o + pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i) * var_sodium_calcium_exchanger__d_NaCa))); // nanoA
        const double var_sodium_current__g_Na_Centre_0DCapable = 0; // microlitre_per_second
        const double var_sodium_current__g_Na_Centre_1DCapable = 0; // microlitre_per_second
        const double var_sodium_current__g_Na_Centre_Published = 0; // microlitre_per_second
        const double var_sodium_current__g_Na_Periphery_0DCapable = 1.204e-6; // microlitre_per_second
        const double var_sodium_current__g_Na_Periphery_1DCapable = 3.7e-7; // microlitre_per_second
        const double var_sodium_current__g_Na_Periphery_Published = 1.1999999999999999e-6; // microlitre_per_second
        const double var_sodium_current__g_Na = ((var_membrane__Version == 0) ? ((-var_sodium_current__g_Na_Centre_Published + var_sodium_current__g_Na_Periphery_Published) * var_membrane__FCell + var_sodium_current__g_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_current__g_Na_Centre_0DCapable + var_sodium_current__g_Na_Periphery_0DCapable) * var_membrane__FCell + var_sodium_current__g_Na_Centre_0DCapable) : ((-var_sodium_current__g_Na_Centre_1DCapable + var_sodium_current__g_Na_Periphery_1DCapable) * var_membrane__FCell + var_sodium_current__g_Na_Centre_1DCapable))); // microlitre_per_second
        const double var_sodium_current_h_gate__F_Na = ((var_membrane__Version == 0) ? (0.086900000000000005 + 0.095200000000000007 * exp(-2.1671999999999998 - 0.063 * var_chaste_interface__membrane__V) / (1.0 + 1.6599999999999999 * exp(-14.332500000000001 - 0.22500000000000001 * var_chaste_interface__membrane__V))) : (0.086929999999999993 + 0.095180000000000001 * exp(-2.1692640000000001 - 0.063060000000000005 * var_chaste_interface__membrane__V) / (1.0 + 1.6619999999999999 * exp(-14.33887 - 0.22509999999999999 * var_chaste_interface__membrane__V)))); // dimensionless
        const double var_sodium_current_h_gate__h = (1.0 - var_sodium_current_h_gate__F_Na) * var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__F_Na * var_chaste_interface__sodium_current_h_gate__h2; // dimensionless
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_ionic_concentrations__Na_o * var_chaste_interface__membrane__V * var_sodium_current__g_Na * var_sodium_current_h_gate__h / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.6399999999999997; // millimolar
        const double var_sodium_potassium_pump__i_p_max_Centre_0DCapable = 0.047825449999999999; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Centre_1DCapable = 0.047800000000000002; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Centre_Published = 0.047800000000000002; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Periphery_0DCapable = 0.15519359999999999; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Periphery_1DCapable = 0.16; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Periphery_Published = 0.16; // nanoA
        const double var_sodium_potassium_pump__i_p_max = ((var_membrane__Version == 0) ? ((-var_sodium_potassium_pump__i_p_max_Centre_Published + var_sodium_potassium_pump__i_p_max_Periphery_Published) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_potassium_pump__i_p_max_Centre_0DCapable + var_sodium_potassium_pump__i_p_max_Periphery_0DCapable) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_0DCapable) : ((-var_sodium_potassium_pump__i_p_max_Centre_1DCapable + var_sodium_potassium_pump__i_p_max_Periphery_1DCapable) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_1DCapable))); // nanoA
        const double var_sodium_potassium_pump__i_p = 1.6000000000000001 * pow(var_ionic_concentrations__K_o, 2) * pow(var_ionic_concentrations__Na_i, 3) * var_sodium_potassium_pump__i_p_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_ionic_concentrations__K_o + var_sodium_potassium_pump__K_m_K), 2) * pow((var_ionic_concentrations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_membrane__V_orig_deriv = -1.0 * (var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_b_Ca + var_four_AP_sensitive_currents__i_sus + var_four_AP_sensitive_currents__i_to + var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na + var_persistent_calcium_current__i_Ca_p + var_potassium_background_current__i_b_K + var_rapid_delayed_rectifying_potassium_current__i_K_r + var_slow_delayed_rectifying_potassium_current__i_K_s + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_p) / var_membrane__Cm; // millivolt / second
        d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Cellzhang_SAN_model_2000_allFromCellMLGRL2::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.092361701692
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.015905380261
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.01445216109
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 0.04804900895
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.48779845203
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.42074047435
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.038968420558
        double var_chaste_interface__four_AP_sensitive_currents_q_gate__q = rY[8];
        // Units: dimensionless; Initial value: 0.29760539675
        double var_chaste_interface__four_AP_sensitive_currents_r_gate__r = rY[9];
        // Units: dimensionless; Initial value: 0.064402950262
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af = rY[10];
        // Units: dimensionless; Initial value: 0.13034201158
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as = rY[11];
        // Units: dimensionless; Initial value: 0.46960956028
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i = rY[12];
        // Units: dimensionless; Initial value: 0.87993375273
        double var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs = rY[13];
        // Units: dimensionless; Initial value: 0.082293827208
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[14];
        // Units: dimensionless; Initial value: 0.03889291759
        
        
        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_membrane__FCellConstant = 1.0309347; // dimensionless
        const double var_L_type_Ca_channel_f_gate__f_L_infinity = 1 / (1.0 + exp(9.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_d_gate__alpha_d_T = 1068.0 * exp(0.87666666666666671 + 0.033333333333333333 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_d_gate__beta_d_T = 1068.0 * exp(-0.87666666666666671 - 0.033333333333333333 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_d_gate__d_T_infinity = 1 / (1.0 + exp(-5.4411764705882355 - 0.14705882352941177 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_d_gate__tau_d_T = 1 / (var_T_type_Ca_channel_d_gate__alpha_d_T + var_T_type_Ca_channel_d_gate__beta_d_T); // second
        const double var_T_type_Ca_channel_d_gate__d_T_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_d_gate__d_T + var_T_type_Ca_channel_d_gate__d_T_infinity) / var_T_type_Ca_channel_d_gate__tau_d_T; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T = 0.001 * var_T_type_Ca_channel_d_gate__d_T_orig_deriv; // 1 / millisecond
        const double var_T_type_Ca_channel_f_gate__f_T_infinity = 1 / (1.0 + exp(7.8888888888888893 + 0.1111111111111111 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_four_AP_sensitive_currents_q_gate__q_infinity = 1 / (1.0 + exp(4.5320610687022898 + 0.076335877862595422 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_four_AP_sensitive_currents_r_gate__r_infinity = 1 / (1.0 + exp(0.5548223350253807 - 0.050761421319796954 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_hyperpolarisation_activated_current_y_gate__beta_y = exp(3.5355294117647058 + 0.047058823529411764 * var_chaste_interface__membrane__V); // per_second
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_L_type_Ca_channel_d_gate__alpha_d_L = ((var_membrane__Version == 0) ? (-84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V)) - 28.379999999999999 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V))) : ((var_membrane__Version == 1.0) ? (-28.390000000000001 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V)) - 84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V))) : (-84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V)) - 28.399999999999999 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V))))); // per_second
        const double var_L_type_Ca_channel_d_gate__beta_d_L = ((var_membrane__Version == 1.0) ? (11.43 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V))) : (11.42 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)))); // per_second
        const double var_L_type_Ca_channel_d_gate__tau_d_L = 2.0 / (var_L_type_Ca_channel_d_gate__alpha_d_L + var_L_type_Ca_channel_d_gate__beta_d_L); // second
        const double var_L_type_Ca_channel_f_gate__alpha_f_L = ((var_membrane__Version == 1.0) ? (3.75 * (28.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(7.0 + 0.25 * var_chaste_interface__membrane__V))) : (3.1200000000000001 * (28.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(7.0 + 0.25 * var_chaste_interface__membrane__V)))); // per_second
        const double var_L_type_Ca_channel_f_gate__beta_f_L = ((var_membrane__Version == 1.0) ? (30.0 / (1.0 + exp(-7.0 - 0.25 * var_chaste_interface__membrane__V))) : (25.0 / (1.0 + exp(-7.0 - 0.25 * var_chaste_interface__membrane__V)))); // per_second
        const double var_T_type_Ca_channel_f_gate__beta_f_T = ((var_membrane__Version == 1.0) ? (15.0 * exp(4.6163849154746419 + 0.065019505851755519 * var_chaste_interface__membrane__V)) : (15.0 * exp(4.6618985695708712 + 0.065019505851755519 * var_chaste_interface__membrane__V))); // per_second
        const double var_four_AP_sensitive_currents_r_gate__tau_r = ((var_membrane__Version == 0) ? (0.00298 + 0.01559 / (1.0369999999999999 * exp(2.7548999999999997 + 0.089999999999999997 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8607999999999998 - 0.12 * var_chaste_interface__membrane__V))) : ((var_membrane__Version == 1.0) ? (0.0029775000000000001 + 0.019595000000000001 / (1.0369999999999999 * exp(2.7585732000000003 + 0.090120000000000006 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8369599999999999 - 0.11899999999999999 * var_chaste_interface__membrane__V))) : (0.00298 + 0.01959 / (1.0369999999999999 * exp(2.7585732000000003 + 0.090120000000000006 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8369599999999999 - 0.11899999999999999 * var_chaste_interface__membrane__V))))); // second
        const double var_four_AP_sensitive_currents_r_gate__r_orig_deriv = (-var_chaste_interface__four_AP_sensitive_currents_r_gate__r + var_four_AP_sensitive_currents_r_gate__r_infinity) / var_four_AP_sensitive_currents_r_gate__tau_r; // 1 / second
        const double d_dt_chaste_interface_var_four_AP_sensitive_currents_r_gate__r = 0.001 * var_four_AP_sensitive_currents_r_gate__r_orig_deriv; // 1 / millisecond
        const double var_hyperpolarisation_activated_current_y_gate__alpha_y = ((var_membrane__Version == 0) ? (exp(-2.9643125469571747 - 0.037565740045078885 * var_chaste_interface__membrane__V)) : (exp(-2.9631993991738641 - 0.037551633496057078 * var_chaste_interface__membrane__V))); // per_second
        const double var_hyperpolarisation_activated_current_y_gate__y_orig_deriv = (1.0 - var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) * var_hyperpolarisation_activated_current_y_gate__alpha_y - var_hyperpolarisation_activated_current_y_gate__beta_y * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // 1 / second
        const double d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y = 0.001 * var_hyperpolarisation_activated_current_y_gate__y_orig_deriv; // 1 / millisecond
        const double var_membrane__dCell = 0; // dimensionless
        const double var_membrane__FCell = ((var_membrane__Version == 0) ? (0.35666666666666669 * (-0.10000000000000001 + 3.0 * var_membrane__dCell) / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : ((var_membrane__Version == 1.0) ? (var_membrane__FCellConstant * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : (1.0343333333333333 * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(12.564102564102564 - 14.871794871794872 * var_membrane__dCell))))); // dimensionless
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = ((var_membrane__Version == 0) ? (1 / (1.0 + exp(-3.8500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V))) : ((var_membrane__Version == 1.0) ? (1 / (1.0 + exp(-3.7166666666666668 - 0.13333333333333333 * var_membrane__FCell - 0.16666666666666666 * var_chaste_interface__membrane__V))) : (1 / (1.0 + exp(-3.6999999999999997 - 0.16666666666666666 * var_chaste_interface__membrane__V))))); // dimensionless
        const double var_L_type_Ca_channel_d_gate__d_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_d_gate__d_L + var_L_type_Ca_channel_d_gate__d_L_infinity) / var_L_type_Ca_channel_d_gate__tau_d_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L = 0.001 * var_L_type_Ca_channel_d_gate__d_L_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_gate__tau_f_L = ((var_membrane__Version == 1.0) ? ((1.2 - 0.20000000000000001 * var_membrane__FCell) / (var_L_type_Ca_channel_f_gate__alpha_f_L + var_L_type_Ca_channel_f_gate__beta_f_L)) : (1 / (var_L_type_Ca_channel_f_gate__alpha_f_L + var_L_type_Ca_channel_f_gate__beta_f_L))); // second
        const double var_L_type_Ca_channel_f_gate__f_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_gate__f_L + var_L_type_Ca_channel_f_gate__f_L_infinity) / var_L_type_Ca_channel_f_gate__tau_f_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L = 0.001 * var_L_type_Ca_channel_f_gate__f_L_orig_deriv; // 1 / millisecond
        const double var_T_type_Ca_channel_f_gate__alpha_f_T = ((var_membrane__Version == 1.0) ? (15.300000000000001 * exp(-0.85234093637454988 - 0.0084033613445378148 * var_membrane__FCell - 0.012004801920768308 * var_chaste_interface__membrane__V)) : (15.300000000000001 * exp(-0.86074429771908767 - 0.012004801920768308 * var_chaste_interface__membrane__V))); // per_second
        const double var_T_type_Ca_channel_f_gate__tau_f_T = 1 / (var_T_type_Ca_channel_f_gate__alpha_f_T + var_T_type_Ca_channel_f_gate__beta_f_T); // second
        const double var_T_type_Ca_channel_f_gate__f_T_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_f_gate__f_T + var_T_type_Ca_channel_f_gate__f_T_infinity) / var_T_type_Ca_channel_f_gate__tau_f_T; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T = 0.001 * var_T_type_Ca_channel_f_gate__f_T_orig_deriv; // 1 / millisecond
        const double var_four_AP_sensitive_currents_q_gate__tau_q = ((var_membrane__Version == 0) ? (0.0101 + 2.4000000000000001e-5 * exp(5.093 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 0.11433333333333336 / exp(-3.9199999999999999 - 0.080000000000000002 * var_chaste_interface__membrane__V)) : ((var_membrane__Version == 1.0) ? (0.010103333333333334 + 0.065166666666666664 / (0.56859999999999999 * exp(-3.1827900000000002 - 0.081610000000000002 * var_chaste_interface__membrane__V - 0.81610000000000005 * var_membrane__FCell) + 0.71740000000000004 * exp((0.27189999999999998 - 0.1719 * var_membrane__FCell) * (40.93 + 10.0 * var_membrane__FCell + var_chaste_interface__membrane__V)))) : (0.0101 + 0.065170000000000006 / (0.56859999999999999 * exp(-3.1827900000000002 - 0.081610000000000002 * var_chaste_interface__membrane__V) + 0.71740000000000004 * exp(11.128867 + 0.27189999999999998 * var_chaste_interface__membrane__V))))); // second
        const double var_four_AP_sensitive_currents_q_gate__q_orig_deriv = (-var_chaste_interface__four_AP_sensitive_currents_q_gate__q + var_four_AP_sensitive_currents_q_gate__q_infinity) / var_four_AP_sensitive_currents_q_gate__tau_q; // 1 / second
        const double d_dt_chaste_interface_var_four_AP_sensitive_currents_q_gate__q = 0.001 * var_four_AP_sensitive_currents_q_gate__q_orig_deriv; // 1 / millisecond
        const double var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_infinity = ((var_membrane__Version != 2.0) ? (1 / (1.0 + exp(-1.3396226415094339 - 0.094339622641509441 * var_chaste_interface__membrane__V))) : (1 / (1.0 + exp(-1.2452830188679245 - 0.094339622641509441 * var_chaste_interface__membrane__V)))); // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_af_gate__tau_P_af = ((var_membrane__Version != 2.0) ? (1 / (0.95999999999999996 * exp(0.40000000000000002 - 0.044444444444444446 * var_chaste_interface__membrane__V) + 37.200000000000003 * exp(-0.56603773584905659 + 0.062893081761006289 * var_chaste_interface__membrane__V))) : (1 / (0.95999999999999996 * exp(0.44444444444444442 - 0.044444444444444446 * var_chaste_interface__membrane__V) + 37.200000000000003 * exp(-0.62893081761006286 + 0.062893081761006289 * var_chaste_interface__membrane__V)))); // second
        const double var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_orig_deriv = (-var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af + var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_infinity) / var_rapid_delayed_rectifying_potassium_current_P_af_gate__tau_P_af; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af = 0.001 * var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_orig_deriv; // 1 / millisecond
        const double var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as_infinity = var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_infinity; // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_as_gate__tau_P_as = ((var_membrane__Version != 2.0) ? (1 / (4.2000000000000002 * exp(-0.52941176470588236 + 0.058823529411764705 * var_chaste_interface__membrane__V) + 0.14999999999999999 * exp(0.41666666666666663 - 0.046296296296296294 * var_chaste_interface__membrane__V))) : (1 / (4.2000000000000002 * exp(-0.58823529411764708 + 0.058823529411764705 * var_chaste_interface__membrane__V) + 0.14999999999999999 * exp(0.46296296296296291 - 0.046296296296296294 * var_chaste_interface__membrane__V)))); // second
        const double var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as_orig_deriv = (-var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as + var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as_infinity) / var_rapid_delayed_rectifying_potassium_current_P_as_gate__tau_P_as; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as = 0.001 * var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as_orig_deriv; // 1 / millisecond
        const double var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i_infinity = 1 / (1.0 + exp(1.8415841584158419 + 0.099009900990099015 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_i_gate__tau_P_i = (((var_membrane__Version == 0) || (var_membrane__Version == 1.0)) ? (0.002) : (0.0060000000000000001)); // second
        const double var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i_orig_deriv = (-var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i + var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i_infinity) / var_rapid_delayed_rectifying_potassium_current_P_i_gate__tau_P_i; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i = 0.001 * var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i_orig_deriv; // 1 / millisecond
        const double var_slow_delayed_rectifying_potassium_current_xs_gate__alpha_xs = 14.0 / (1.0 + exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V)); // per_second
        const double var_slow_delayed_rectifying_potassium_current_xs_gate__beta_xs = exp(-0.022222222222222223 * var_chaste_interface__membrane__V); // per_second
        const double var_slow_delayed_rectifying_potassium_current_xs_gate__xs_orig_deriv = (1.0 - var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs) * var_slow_delayed_rectifying_potassium_current_xs_gate__alpha_xs - var_slow_delayed_rectifying_potassium_current_xs_gate__beta_xs * var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs; // 1 / second
        const double d_dt_chaste_interface_var_slow_delayed_rectifying_potassium_current_xs_gate__xs = 0.001 * var_slow_delayed_rectifying_potassium_current_xs_gate__xs_orig_deriv; // 1 / millisecond
        const double var_sodium_current_h_gate__h1_infinity = 1 / (1.0 + exp(10.328124999999998 + 0.15625 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h_gate__h2_infinity = var_sodium_current_h_gate__h1_infinity; // dimensionless
        const double var_sodium_current_h_gate__tau_h1 = 0.00059770000000000005 + 3.7170000000000002e-6 * exp(-4.8164649999999991 - 0.28149999999999997 * var_chaste_interface__membrane__V) / (1.0 + 0.0037320000000000001 * exp(-12.936576000000001 - 0.34260000000000002 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h_gate__h1_orig_deriv = (-var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__h1_infinity) / var_sodium_current_h_gate__tau_h1; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h1 = 0.001 * var_sodium_current_h_gate__h1_orig_deriv; // 1 / millisecond
        const double var_sodium_current_h_gate__tau_h2 = 0.0035560000000000001 + 3.1860000000000002e-8 * exp(-11.69172 - 0.62190000000000001 * var_chaste_interface__membrane__V) / (1.0 + 7.1890000000000005e-5 * exp(-22.768981 - 0.66830000000000001 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h_gate__h2_orig_deriv = (-var_chaste_interface__sodium_current_h_gate__h2 + var_sodium_current_h_gate__h2_infinity) / var_sodium_current_h_gate__tau_h2; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h2 = 0.001 * var_sodium_current_h_gate__h2_orig_deriv; // 1 / millisecond
        const double var_sodium_current_m_gate__m_infinity = ((var_membrane__Version == 0) ? (pow(1 / (1.0 + exp(-0.18315018315018314 * var_chaste_interface__membrane__V)), 0.33333333333333331)) : (pow(1 / (1.0 + exp(-5.5531135531135529 - 0.18315018315018314 * var_chaste_interface__membrane__V)), 0.33333333333333331))); // dimensionless
        const double var_sodium_current_m_gate__tau_m = ((var_membrane__Version == 0) ? (4.0000000000000003e-5 + 0.00062469999999999995 / (0.627 * exp(5.330820000000001 + 0.082000000000000003 * var_chaste_interface__membrane__V) + 0.83199999999999996 * exp(-18.994500000000002 - 0.33500000000000002 * var_chaste_interface__membrane__V))) : (4.5689999999999998e-5 + 0.00062469999999999995 / (0.62739999999999996 * exp(5.3505781299999997 + 0.082299999999999998 * var_chaste_interface__membrane__V) + 0.83221659999999997 * exp(-19.034003092000003 - 0.33566000000000001 * var_chaste_interface__membrane__V)))); // second
        const double var_sodium_current_m_gate__m_orig_deriv = (-var_chaste_interface__sodium_current_m_gate__m + var_sodium_current_m_gate__m_infinity) / var_sodium_current_m_gate__tau_m; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * var_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
            const double var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable = 0.0057938; // microS
            const double var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable = 0.0082000000000000007; // microS
            const double var_L_type_Ca_channel__g_Ca_L_Centre_Published = 0.0057999999999999996; // microS
            const double var_L_type_Ca_channel__g_Ca_L_Periphery_0DCapable = 0.065886479999999997; // microS
            const double var_L_type_Ca_channel__g_Ca_L_Periphery_1DCapable = 0.0659; // microS
            const double var_L_type_Ca_channel__g_Ca_L_Periphery_Published = 0.0659; // microS
            const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
            const double var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable = 0.0042780600000000002; // microS
            const double var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable = 0.0020999999999999999; // microS
            const double var_T_type_Ca_channel__g_Ca_T_Centre_Published = 0.0043; // microS
            const double var_T_type_Ca_channel__g_Ca_T_Periphery_0DCapable = 0.0138823; // microS
            const double var_T_type_Ca_channel__g_Ca_T_Periphery_1DCapable = 0.00694; // microS
            const double var_T_type_Ca_channel__g_Ca_T_Periphery_Published = 0.013899999999999999; // microS
            const double var_calcium_background_current__g_b_Ca_Centre_0DCapable = 1.3236e-5; // microS
            const double var_calcium_background_current__g_b_Ca_Centre_1DCapable = 1.323e-5; // microS
            const double var_calcium_background_current__g_b_Ca_Centre_Published = 1.3200000000000001e-5; // microS
            const double var_calcium_background_current__g_b_Ca_Periphery_0DCapable = 4.2951999999999998e-5; // microS
            const double var_calcium_background_current__g_b_Ca_Periphery_1DCapable = 4.2899999999999999e-5; // microS
            const double var_calcium_background_current__g_b_Ca_Periphery_Published = 4.3000000000000002e-5; // microS
            const double var_four_AP_sensitive_currents__g_sus_Centre_0DCapable = 6.6455040000000003e-5; // microS
            const double var_four_AP_sensitive_currents__g_sus_Centre_1DCapable = 0.00026600000000000001; // microS
            const double var_four_AP_sensitive_currents__g_sus_Centre_Published = 6.6500000000000004e-5; // microS
            const double var_four_AP_sensitive_currents__g_sus_Periphery_0DCapable = 0.01138376; // microS
            const double var_four_AP_sensitive_currents__g_sus_Periphery_1DCapable = 0.0114; // microS
            const double var_four_AP_sensitive_currents__g_sus_Periphery_Published = 0.0114; // microS
            const double var_four_AP_sensitive_currents__g_to_Centre_0DCapable = 0.0049049999999999996; // microS
            const double var_four_AP_sensitive_currents__g_to_Centre_1DCapable = 0.0049049999999999996; // microS
            const double var_four_AP_sensitive_currents__g_to_Centre_Published = 0.0049100000000000003; // microS
            const double var_four_AP_sensitive_currents__g_to_Periphery_0DCapable = 0.036495; // microS
            const double var_four_AP_sensitive_currents__g_to_Periphery_1DCapable = 0.036499999999999998; // microS
            const double var_four_AP_sensitive_currents__g_to_Periphery_Published = 0.036490000000000002; // microS
            const double var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable = 0.0005465; // microS
            const double var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable = 0.000437; // microS
            const double var_hyperpolarisation_activated_current__g_f_K_Centre_Published = 0.00054799999999999998; // microS
            const double var_hyperpolarisation_activated_current__g_f_K_Periphery_0DCapable = 0.006875; // microS
            const double var_hyperpolarisation_activated_current__g_f_K_Periphery_1DCapable = 0.0054999999999999997; // microS
            const double var_hyperpolarisation_activated_current__g_f_K_Periphery_Published = 0.0068999999999999999; // microS
            const double var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable = 0.0005465; // microS
            const double var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable = 0.000437; // microS
            const double var_hyperpolarisation_activated_current__g_f_Na_Centre_Published = 0.00054799999999999998; // microS
            const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_0DCapable = 0.006875; // microS
            const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_1DCapable = 0.0054999999999999997; // microS
            const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_Published = 0.0068999999999999999; // microS
            const double var_ionic_concentrations__Ca_i = 0.0001; // millimolar
            const double var_ionic_concentrations__Ca_o = 2.0; // millimolar
            const double var_ionic_concentrations__K_i = 140.0; // millimolar
            const double var_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
            const double var_ionic_concentrations__Na_i = 8.0; // millimolar
            const double var_ionic_concentrations__Na_o = 140.0; // millimolar
            const double var_membrane__CmCentre = 2.0000000000000002e-5; // microF
            const double var_membrane__CmPeriphery = 6.4999999999999994e-5; // microF
            const double var_membrane__F = 96845.0; // coulomb_per_mole
            const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
            const double var_membrane__T = 310.0; // kelvin
            const double var_L_type_Ca_channel__g_Ca_L = ((var_membrane__Version == 0) ? ((-var_L_type_Ca_channel__g_Ca_L_Centre_Published + var_L_type_Ca_channel__g_Ca_L_Periphery_Published) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable + var_L_type_Ca_channel__g_Ca_L_Periphery_0DCapable) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable) : ((-var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable + var_L_type_Ca_channel__g_Ca_L_Periphery_1DCapable) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable))); // microS
            const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.0060000000000000001 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
            const double var_T_type_Ca_channel__g_Ca_T = ((var_membrane__Version == 0) ? ((-var_T_type_Ca_channel__g_Ca_T_Centre_Published + var_T_type_Ca_channel__g_Ca_T_Periphery_Published) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable + var_T_type_Ca_channel__g_Ca_T_Periphery_0DCapable) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable) : ((-var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable + var_T_type_Ca_channel__g_Ca_T_Periphery_1DCapable) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable))); // microS
            const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
            const double var_calcium_background_current__g_b_Ca = ((var_membrane__Version == 0) ? ((-var_calcium_background_current__g_b_Ca_Centre_Published + var_calcium_background_current__g_b_Ca_Periphery_Published) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_calcium_background_current__g_b_Ca_Centre_0DCapable + var_calcium_background_current__g_b_Ca_Periphery_0DCapable) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_0DCapable) : ((-var_calcium_background_current__g_b_Ca_Centre_1DCapable + var_calcium_background_current__g_b_Ca_Periphery_1DCapable) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_1DCapable))); // microS
            const double var_four_AP_sensitive_currents__g_sus = ((var_membrane__Version == 0) ? ((-var_four_AP_sensitive_currents__g_sus_Centre_Published + var_four_AP_sensitive_currents__g_sus_Periphery_Published) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_four_AP_sensitive_currents__g_sus_Centre_0DCapable + var_four_AP_sensitive_currents__g_sus_Periphery_0DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_0DCapable) : ((-var_four_AP_sensitive_currents__g_sus_Centre_1DCapable + var_four_AP_sensitive_currents__g_sus_Periphery_1DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_1DCapable))); // microS
            const double var_four_AP_sensitive_currents__g_to = ((var_membrane__Version == 0) ? ((-var_four_AP_sensitive_currents__g_to_Centre_Published + var_four_AP_sensitive_currents__g_to_Periphery_Published) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_four_AP_sensitive_currents__g_to_Centre_0DCapable + var_four_AP_sensitive_currents__g_to_Periphery_0DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_0DCapable) : ((-var_four_AP_sensitive_currents__g_to_Centre_1DCapable + var_four_AP_sensitive_currents__g_to_Periphery_1DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_1DCapable))); // microS
            const double var_hyperpolarisation_activated_current__g_f_K = ((var_membrane__Version == 0) ? ((-var_hyperpolarisation_activated_current__g_f_K_Centre_Published + var_hyperpolarisation_activated_current__g_f_K_Periphery_Published) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable + var_hyperpolarisation_activated_current__g_f_K_Periphery_0DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable) : ((-var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable + var_hyperpolarisation_activated_current__g_f_K_Periphery_1DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable))); // microS
            const double var_hyperpolarisation_activated_current__g_f_Na = ((var_membrane__Version == 0) ? ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_Published + var_hyperpolarisation_activated_current__g_f_Na_Periphery_Published) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable + var_hyperpolarisation_activated_current__g_f_Na_Periphery_0DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable) : ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable + var_hyperpolarisation_activated_current__g_f_Na_Periphery_1DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable))); // microS
            const double var_membrane__Cm = (-var_membrane__CmCentre + var_membrane__CmPeriphery) * var_membrane__FCell + var_membrane__CmCentre; // microF
            const double var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable = 0; // nanoA
            const double var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable = 0.0041999999999999997; // nanoA
            const double var_persistent_calcium_current__i_Ca_p_max_Centre_Published = 0; // nanoA
            const double var_persistent_calcium_current__i_Ca_p_max_Periphery_0DCapable = 0; // nanoA
            const double var_persistent_calcium_current__i_Ca_p_max_Periphery_1DCapable = 0.033390000000000003; // nanoA
            const double var_persistent_calcium_current__i_Ca_p_max_Periphery_Published = 0; // nanoA
            const double var_persistent_calcium_current__i_Ca_p_max = ((var_membrane__Version == 0) ? ((-var_persistent_calcium_current__i_Ca_p_max_Centre_Published + var_persistent_calcium_current__i_Ca_p_max_Periphery_Published) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable + var_persistent_calcium_current__i_Ca_p_max_Periphery_0DCapable) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable) : ((-var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable + var_persistent_calcium_current__i_Ca_p_max_Periphery_1DCapable) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable))); // nanoA
            const double var_persistent_calcium_current__i_Ca_p = var_ionic_concentrations__Ca_i * var_persistent_calcium_current__i_Ca_p_max / (0.00040000000000000002 + var_ionic_concentrations__Ca_i); // nanoA
            const double var_potassium_background_current__g_b_K_Centre_0DCapable = 2.5236359999999998e-5; // microS
            const double var_potassium_background_current__g_b_K_Centre_1DCapable = 2.5199999999999999e-5; // microS
            const double var_potassium_background_current__g_b_K_Centre_Published = 2.5199999999999999e-5; // microS
            const double var_potassium_background_current__g_b_K_Periphery_0DCapable = 8.1891999999999995e-5; // microS
            const double var_potassium_background_current__g_b_K_Periphery_1DCapable = 8.1899999999999999e-5; // microS
            const double var_potassium_background_current__g_b_K_Periphery_Published = 8.1899999999999999e-5; // microS
            const double var_potassium_background_current__g_b_K = ((var_membrane__Version == 0) ? ((-var_potassium_background_current__g_b_K_Centre_Published + var_potassium_background_current__g_b_K_Periphery_Published) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_potassium_background_current__g_b_K_Centre_0DCapable + var_potassium_background_current__g_b_K_Periphery_0DCapable) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_0DCapable) : ((-var_potassium_background_current__g_b_K_Centre_1DCapable + var_potassium_background_current__g_b_K_Periphery_1DCapable) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_1DCapable))); // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable = 0.00079704000000000005; // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable = 0.00073800000000000005; // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published = 0.00079699999999999997; // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_0DCapable = 0.016; // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_1DCapable = 0.020799999999999999; // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_Published = 0.016; // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r = ((var_membrane__Version == 0) ? ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_Published) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_0DCapable) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable) : ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_1DCapable) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable))); // microS
            const double var_rapid_delayed_rectifying_potassium_current__P_a = 0.40000000000000002 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as + 0.59999999999999998 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af; // dimensionless
            const double var_reversal_and_equilibrium_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Ca_o / var_ionic_concentrations__Ca_i) / var_membrane__F; // millivolt
            const double var_calcium_background_current__i_b_Ca = (-var_reversal_and_equilibrium_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_b_Ca; // nanoA
            const double var_reversal_and_equilibrium_potentials__E_K = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__K_o / var_ionic_concentrations__K_i) / var_membrane__F; // millivolt
            const double var_four_AP_sensitive_currents__i_sus = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_four_AP_sensitive_currents__g_sus * var_chaste_interface__four_AP_sensitive_currents_r_gate__r; // nanoA
            const double var_four_AP_sensitive_currents__i_to = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_four_AP_sensitive_currents__g_to * var_chaste_interface__four_AP_sensitive_currents_q_gate__q * var_chaste_interface__four_AP_sensitive_currents_r_gate__r; // nanoA
            const double var_hyperpolarisation_activated_current__i_f_K = ((var_membrane__Version != 2.0) ? ((-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) : ((102.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y)); // nanoA
            const double var_potassium_background_current__i_b_K = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_background_current__g_b_K; // nanoA
            const double var_rapid_delayed_rectifying_potassium_current__i_K_r = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_rapid_delayed_rectifying_potassium_current__P_a * var_rapid_delayed_rectifying_potassium_current__g_K_r * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
            const double var_reversal_and_equilibrium_potentials__E_K_s = ((var_membrane__Version == 0) ? (var_membrane__R * var_membrane__T * log((var_ionic_concentrations__K_o + 0.12 * var_ionic_concentrations__Na_o) / (var_ionic_concentrations__K_i + 0.12 * var_ionic_concentrations__Na_i)) / var_membrane__F) : (var_membrane__R * var_membrane__T * log((var_ionic_concentrations__K_o + 0.029999999999999999 * var_ionic_concentrations__Na_o) / (var_ionic_concentrations__K_i + 0.029999999999999999 * var_ionic_concentrations__Na_i)) / var_membrane__F)); // millivolt
            const double var_reversal_and_equilibrium_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Na_o / var_ionic_concentrations__Na_i) / var_membrane__F; // millivolt
            const double var_hyperpolarisation_activated_current__i_f_Na = ((var_membrane__Version != 2.0) ? ((-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) : ((-77.599999999999994 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y)); // nanoA
            const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable = 0.00034450000000000003; // microS
            const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable = 0.00034499999999999998; // microS
            const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published = 0.00051800000000000001; // microS
            const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_0DCapable = 0.0104; // microS
            const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_1DCapable = 0.0104; // microS
            const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_Published = 0.0104; // microS
            const double var_slow_delayed_rectifying_potassium_current__g_K_s = ((var_membrane__Version == 0) ? ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_Published) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_0DCapable) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable) : ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_1DCapable) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable))); // microS
            const double var_slow_delayed_rectifying_potassium_current__i_K_s = pow(var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs, 2) * (-var_reversal_and_equilibrium_potentials__E_K_s + var_chaste_interface__membrane__V) * var_slow_delayed_rectifying_potassium_current__g_K_s; // nanoA
            const double var_sodium_background_current__g_b_Na_Centre_0DCapable = 5.8181799999999999e-5; // microS
            const double var_sodium_background_current__g_b_Na_Centre_1DCapable = 5.8e-5; // microS
            const double var_sodium_background_current__g_b_Na_Centre_Published = 5.8e-5; // microS
            const double var_sodium_background_current__g_b_Na_Periphery_0DCapable = 0.00018880000000000001; // microS
            const double var_sodium_background_current__g_b_Na_Periphery_1DCapable = 0.00018900000000000001; // microS
            const double var_sodium_background_current__g_b_Na_Periphery_Published = 0.00018900000000000001; // microS
            const double var_sodium_background_current__g_b_Na = ((var_membrane__Version == 0) ? ((-var_sodium_background_current__g_b_Na_Centre_Published + var_sodium_background_current__g_b_Na_Periphery_Published) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_background_current__g_b_Na_Centre_0DCapable + var_sodium_background_current__g_b_Na_Periphery_0DCapable) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_0DCapable) : ((-var_sodium_background_current__g_b_Na_Centre_1DCapable + var_sodium_background_current__g_b_Na_Periphery_1DCapable) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_1DCapable))); // microS
            const double var_sodium_background_current__i_b_Na = (-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_b_Na; // nanoA
            const double var_sodium_calcium_exchanger__d_NaCa = 0.0001; // dimensionless
            const double var_sodium_calcium_exchanger__gamma_NaCa = 0.5; // dimensionless
            const double var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable = 2.7228999999999998e-6; // nanoA
            const double var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable = 2.7999999999999999e-6; // nanoA
            const double var_sodium_calcium_exchanger__k_NaCa_Centre_Published = 2.7e-6; // nanoA
            const double var_sodium_calcium_exchanger__k_NaCa_Periphery_0DCapable = 8.8358400000000004e-6; // nanoA
            const double var_sodium_calcium_exchanger__k_NaCa_Periphery_1DCapable = 8.8000000000000004e-6; // nanoA
            const double var_sodium_calcium_exchanger__k_NaCa_Periphery_Published = 8.8000000000000004e-6; // nanoA
            const double var_sodium_calcium_exchanger__k_NaCa = ((var_membrane__Version == 0) ? ((-var_sodium_calcium_exchanger__k_NaCa_Centre_Published + var_sodium_calcium_exchanger__k_NaCa_Periphery_Published) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable + var_sodium_calcium_exchanger__k_NaCa_Periphery_0DCapable) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable) : ((-var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable + var_sodium_calcium_exchanger__k_NaCa_Periphery_1DCapable) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable))); // nanoA
            const double var_sodium_calcium_exchanger__i_NaCa = ((var_membrane__Version == 0) ? ((pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma_NaCa) - pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i * exp(0.037400000000000003 * (-1.0 + var_sodium_calcium_exchanger__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_sodium_calcium_exchanger__k_NaCa / (1.0 + (pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o + pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i) * var_sodium_calcium_exchanger__d_NaCa)) : ((pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma_NaCa) - pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_exchanger__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_sodium_calcium_exchanger__k_NaCa / (1.0 + (pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o + pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i) * var_sodium_calcium_exchanger__d_NaCa))); // nanoA
            const double var_sodium_current__g_Na_Centre_0DCapable = 0; // microlitre_per_second
            const double var_sodium_current__g_Na_Centre_1DCapable = 0; // microlitre_per_second
            const double var_sodium_current__g_Na_Centre_Published = 0; // microlitre_per_second
            const double var_sodium_current__g_Na_Periphery_0DCapable = 1.204e-6; // microlitre_per_second
            const double var_sodium_current__g_Na_Periphery_1DCapable = 3.7e-7; // microlitre_per_second
            const double var_sodium_current__g_Na_Periphery_Published = 1.1999999999999999e-6; // microlitre_per_second
            const double var_sodium_current__g_Na = ((var_membrane__Version == 0) ? ((-var_sodium_current__g_Na_Centre_Published + var_sodium_current__g_Na_Periphery_Published) * var_membrane__FCell + var_sodium_current__g_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_current__g_Na_Centre_0DCapable + var_sodium_current__g_Na_Periphery_0DCapable) * var_membrane__FCell + var_sodium_current__g_Na_Centre_0DCapable) : ((-var_sodium_current__g_Na_Centre_1DCapable + var_sodium_current__g_Na_Periphery_1DCapable) * var_membrane__FCell + var_sodium_current__g_Na_Centre_1DCapable))); // microlitre_per_second
            const double var_sodium_current_h_gate__F_Na = ((var_membrane__Version == 0) ? (0.086900000000000005 + 0.095200000000000007 * exp(-2.1671999999999998 - 0.063 * var_chaste_interface__membrane__V) / (1.0 + 1.6599999999999999 * exp(-14.332500000000001 - 0.22500000000000001 * var_chaste_interface__membrane__V))) : (0.086929999999999993 + 0.095180000000000001 * exp(-2.1692640000000001 - 0.063060000000000005 * var_chaste_interface__membrane__V) / (1.0 + 1.6619999999999999 * exp(-14.33887 - 0.22509999999999999 * var_chaste_interface__membrane__V)))); // dimensionless
            const double var_sodium_current_h_gate__h = (1.0 - var_sodium_current_h_gate__F_Na) * var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__F_Na * var_chaste_interface__sodium_current_h_gate__h2; // dimensionless
            const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_ionic_concentrations__Na_o * var_chaste_interface__membrane__V * var_sodium_current__g_Na * var_sodium_current_h_gate__h / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
            const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
            const double var_sodium_potassium_pump__K_m_Na = 5.6399999999999997; // millimolar
            const double var_sodium_potassium_pump__i_p_max_Centre_0DCapable = 0.047825449999999999; // nanoA
            const double var_sodium_potassium_pump__i_p_max_Centre_1DCapable = 0.047800000000000002; // nanoA
            const double var_sodium_potassium_pump__i_p_max_Centre_Published = 0.047800000000000002; // nanoA
            const double var_sodium_potassium_pump__i_p_max_Periphery_0DCapable = 0.15519359999999999; // nanoA
            const double var_sodium_potassium_pump__i_p_max_Periphery_1DCapable = 0.16; // nanoA
            const double var_sodium_potassium_pump__i_p_max_Periphery_Published = 0.16; // nanoA
            const double var_sodium_potassium_pump__i_p_max = ((var_membrane__Version == 0) ? ((-var_sodium_potassium_pump__i_p_max_Centre_Published + var_sodium_potassium_pump__i_p_max_Periphery_Published) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_potassium_pump__i_p_max_Centre_0DCapable + var_sodium_potassium_pump__i_p_max_Periphery_0DCapable) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_0DCapable) : ((-var_sodium_potassium_pump__i_p_max_Centre_1DCapable + var_sodium_potassium_pump__i_p_max_Periphery_1DCapable) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_1DCapable))); // nanoA
            const double var_sodium_potassium_pump__i_p = 1.6000000000000001 * pow(var_ionic_concentrations__K_o, 2) * pow(var_ionic_concentrations__Na_i, 3) * var_sodium_potassium_pump__i_p_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_ionic_concentrations__K_o + var_sodium_potassium_pump__K_m_K), 2) * pow((var_ionic_concentrations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
            const double var_membrane__V_orig_deriv = -1.0 * (var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_b_Ca + var_four_AP_sensitive_currents__i_sus + var_four_AP_sensitive_currents__i_to + var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na + var_persistent_calcium_current__i_Ca_p + var_potassium_background_current__i_b_K + var_rapid_delayed_rectifying_potassium_current__i_K_r + var_slow_delayed_rectifying_potassium_current__i_K_s + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_p) / var_membrane__Cm; // millivolt / second
            d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        mEvalF[1] = d_dt_chaste_interface_var_sodium_current_m_gate__m;
        mEvalF[2] = d_dt_chaste_interface_var_sodium_current_h_gate__h1;
        mEvalF[3] = d_dt_chaste_interface_var_sodium_current_h_gate__h2;
        mEvalF[4] = d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L;
        mEvalF[5] = d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L;
        mEvalF[6] = d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T;
        mEvalF[7] = d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T;
        mEvalF[8] = d_dt_chaste_interface_var_four_AP_sensitive_currents_q_gate__q;
        mEvalF[9] = d_dt_chaste_interface_var_four_AP_sensitive_currents_r_gate__r;
        mEvalF[10] = d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af;
        mEvalF[11] = d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as;
        mEvalF[12] = d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i;
        mEvalF[13] = d_dt_chaste_interface_var_slow_delayed_rectifying_potassium_current_xs_gate__xs;
        mEvalF[14] = d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time_converted, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        rY[13] = y_save;
        
        
        y_save = rY[14];
        rY[14] = mYInit[14];
        mEvalF[14] = EvaluateYDerivative14(var_chaste_interface__environment__time_converted, rY);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time_converted, rY, delta);
        rY[14] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.092361701692
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.015905380261
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.01445216109
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 0.04804900895
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.48779845203
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.42074047435
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.038968420558
        double var_chaste_interface__four_AP_sensitive_currents_q_gate__q = rY[8];
        // Units: dimensionless; Initial value: 0.29760539675
        double var_chaste_interface__four_AP_sensitive_currents_r_gate__r = rY[9];
        // Units: dimensionless; Initial value: 0.064402950262
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af = rY[10];
        // Units: dimensionless; Initial value: 0.13034201158
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as = rY[11];
        // Units: dimensionless; Initial value: 0.46960956028
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i = rY[12];
        // Units: dimensionless; Initial value: 0.87993375273
        double var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs = rY[13];
        // Units: dimensionless; Initial value: 0.082293827208
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[14];
        // Units: dimensionless; Initial value: 0.03889291759
        
        
        // Mathematics
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable = 0.0057938; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable = 0.0082000000000000007; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Centre_Published = 0.0057999999999999996; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Periphery_0DCapable = 0.065886479999999997; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Periphery_1DCapable = 0.0659; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Periphery_Published = 0.0659; // microS
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable = 0.0042780600000000002; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable = 0.0020999999999999999; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Centre_Published = 0.0043; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Periphery_0DCapable = 0.0138823; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Periphery_1DCapable = 0.00694; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Periphery_Published = 0.013899999999999999; // microS
        const double var_calcium_background_current__g_b_Ca_Centre_0DCapable = 1.3236e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Centre_1DCapable = 1.323e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Centre_Published = 1.3200000000000001e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Periphery_0DCapable = 4.2951999999999998e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Periphery_1DCapable = 4.2899999999999999e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Periphery_Published = 4.3000000000000002e-5; // microS
        const double var_four_AP_sensitive_currents__g_sus_Centre_0DCapable = 6.6455040000000003e-5; // microS
        const double var_four_AP_sensitive_currents__g_sus_Centre_1DCapable = 0.00026600000000000001; // microS
        const double var_four_AP_sensitive_currents__g_sus_Centre_Published = 6.6500000000000004e-5; // microS
        const double var_four_AP_sensitive_currents__g_sus_Periphery_0DCapable = 0.01138376; // microS
        const double var_four_AP_sensitive_currents__g_sus_Periphery_1DCapable = 0.0114; // microS
        const double var_four_AP_sensitive_currents__g_sus_Periphery_Published = 0.0114; // microS
        const double var_four_AP_sensitive_currents__g_to_Centre_0DCapable = 0.0049049999999999996; // microS
        const double var_four_AP_sensitive_currents__g_to_Centre_1DCapable = 0.0049049999999999996; // microS
        const double var_four_AP_sensitive_currents__g_to_Centre_Published = 0.0049100000000000003; // microS
        const double var_four_AP_sensitive_currents__g_to_Periphery_0DCapable = 0.036495; // microS
        const double var_four_AP_sensitive_currents__g_to_Periphery_1DCapable = 0.036499999999999998; // microS
        const double var_four_AP_sensitive_currents__g_to_Periphery_Published = 0.036490000000000002; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable = 0.0005465; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable = 0.000437; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Centre_Published = 0.00054799999999999998; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Periphery_0DCapable = 0.006875; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Periphery_1DCapable = 0.0054999999999999997; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Periphery_Published = 0.0068999999999999999; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable = 0.0005465; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable = 0.000437; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Centre_Published = 0.00054799999999999998; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_0DCapable = 0.006875; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_1DCapable = 0.0054999999999999997; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_Published = 0.0068999999999999999; // microS
        const double var_ionic_concentrations__Ca_i = 0.0001; // millimolar
        const double var_ionic_concentrations__Ca_o = 2.0; // millimolar
        const double var_ionic_concentrations__K_i = 140.0; // millimolar
        const double var_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_ionic_concentrations__Na_i = 8.0; // millimolar
        const double var_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_membrane__CmCentre = 2.0000000000000002e-5; // microF
        const double var_membrane__CmPeriphery = 6.4999999999999994e-5; // microF
        const double var_membrane__F = 96845.0; // coulomb_per_mole
        const double var_membrane__FCellConstant = 1.0309347; // dimensionless
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_membrane__dCell = 0; // dimensionless
        const double var_membrane__FCell = ((var_membrane__Version == 0) ? (0.35666666666666669 * (-0.10000000000000001 + 3.0 * var_membrane__dCell) / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : ((var_membrane__Version == 1.0) ? (var_membrane__FCellConstant * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : (1.0343333333333333 * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(12.564102564102564 - 14.871794871794872 * var_membrane__dCell))))); // dimensionless
        const double var_L_type_Ca_channel__g_Ca_L = ((var_membrane__Version == 0) ? ((-var_L_type_Ca_channel__g_Ca_L_Centre_Published + var_L_type_Ca_channel__g_Ca_L_Periphery_Published) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable + var_L_type_Ca_channel__g_Ca_L_Periphery_0DCapable) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable) : ((-var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable + var_L_type_Ca_channel__g_Ca_L_Periphery_1DCapable) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable))); // microS
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.0060000000000000001 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_T_type_Ca_channel__g_Ca_T = ((var_membrane__Version == 0) ? ((-var_T_type_Ca_channel__g_Ca_T_Centre_Published + var_T_type_Ca_channel__g_Ca_T_Periphery_Published) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable + var_T_type_Ca_channel__g_Ca_T_Periphery_0DCapable) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable) : ((-var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable + var_T_type_Ca_channel__g_Ca_T_Periphery_1DCapable) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable))); // microS
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_calcium_background_current__g_b_Ca = ((var_membrane__Version == 0) ? ((-var_calcium_background_current__g_b_Ca_Centre_Published + var_calcium_background_current__g_b_Ca_Periphery_Published) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_calcium_background_current__g_b_Ca_Centre_0DCapable + var_calcium_background_current__g_b_Ca_Periphery_0DCapable) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_0DCapable) : ((-var_calcium_background_current__g_b_Ca_Centre_1DCapable + var_calcium_background_current__g_b_Ca_Periphery_1DCapable) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_1DCapable))); // microS
        const double var_four_AP_sensitive_currents__g_sus = ((var_membrane__Version == 0) ? ((-var_four_AP_sensitive_currents__g_sus_Centre_Published + var_four_AP_sensitive_currents__g_sus_Periphery_Published) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_four_AP_sensitive_currents__g_sus_Centre_0DCapable + var_four_AP_sensitive_currents__g_sus_Periphery_0DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_0DCapable) : ((-var_four_AP_sensitive_currents__g_sus_Centre_1DCapable + var_four_AP_sensitive_currents__g_sus_Periphery_1DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_1DCapable))); // microS
        const double var_four_AP_sensitive_currents__g_to = ((var_membrane__Version == 0) ? ((-var_four_AP_sensitive_currents__g_to_Centre_Published + var_four_AP_sensitive_currents__g_to_Periphery_Published) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_four_AP_sensitive_currents__g_to_Centre_0DCapable + var_four_AP_sensitive_currents__g_to_Periphery_0DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_0DCapable) : ((-var_four_AP_sensitive_currents__g_to_Centre_1DCapable + var_four_AP_sensitive_currents__g_to_Periphery_1DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_1DCapable))); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = ((var_membrane__Version == 0) ? ((-var_hyperpolarisation_activated_current__g_f_K_Centre_Published + var_hyperpolarisation_activated_current__g_f_K_Periphery_Published) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable + var_hyperpolarisation_activated_current__g_f_K_Periphery_0DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable) : ((-var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable + var_hyperpolarisation_activated_current__g_f_K_Periphery_1DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable))); // microS
        const double var_hyperpolarisation_activated_current__g_f_Na = ((var_membrane__Version == 0) ? ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_Published + var_hyperpolarisation_activated_current__g_f_Na_Periphery_Published) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable + var_hyperpolarisation_activated_current__g_f_Na_Periphery_0DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable) : ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable + var_hyperpolarisation_activated_current__g_f_Na_Periphery_1DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable))); // microS
        const double var_membrane__Cm = (-var_membrane__CmCentre + var_membrane__CmPeriphery) * var_membrane__FCell + var_membrane__CmCentre; // microF
        const double var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable = 0.0041999999999999997; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Centre_Published = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Periphery_0DCapable = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Periphery_1DCapable = 0.033390000000000003; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Periphery_Published = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max = ((var_membrane__Version == 0) ? ((-var_persistent_calcium_current__i_Ca_p_max_Centre_Published + var_persistent_calcium_current__i_Ca_p_max_Periphery_Published) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable + var_persistent_calcium_current__i_Ca_p_max_Periphery_0DCapable) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable) : ((-var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable + var_persistent_calcium_current__i_Ca_p_max_Periphery_1DCapable) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable))); // nanoA
        const double var_persistent_calcium_current__i_Ca_p = var_ionic_concentrations__Ca_i * var_persistent_calcium_current__i_Ca_p_max / (0.00040000000000000002 + var_ionic_concentrations__Ca_i); // nanoA
        const double var_potassium_background_current__g_b_K_Centre_0DCapable = 2.5236359999999998e-5; // microS
        const double var_potassium_background_current__g_b_K_Centre_1DCapable = 2.5199999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K_Centre_Published = 2.5199999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K_Periphery_0DCapable = 8.1891999999999995e-5; // microS
        const double var_potassium_background_current__g_b_K_Periphery_1DCapable = 8.1899999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K_Periphery_Published = 8.1899999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K = ((var_membrane__Version == 0) ? ((-var_potassium_background_current__g_b_K_Centre_Published + var_potassium_background_current__g_b_K_Periphery_Published) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_potassium_background_current__g_b_K_Centre_0DCapable + var_potassium_background_current__g_b_K_Periphery_0DCapable) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_0DCapable) : ((-var_potassium_background_current__g_b_K_Centre_1DCapable + var_potassium_background_current__g_b_K_Periphery_1DCapable) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_1DCapable))); // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable = 0.00079704000000000005; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable = 0.00073800000000000005; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published = 0.00079699999999999997; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_0DCapable = 0.016; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_1DCapable = 0.020799999999999999; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_Published = 0.016; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r = ((var_membrane__Version == 0) ? ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_Published) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_0DCapable) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable) : ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_1DCapable) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable))); // microS
        const double var_rapid_delayed_rectifying_potassium_current__P_a = 0.40000000000000002 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as + 0.59999999999999998 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af; // dimensionless
        const double var_reversal_and_equilibrium_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Ca_o / var_ionic_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_and_equilibrium_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_b_Ca; // nanoA
        const double var_reversal_and_equilibrium_potentials__E_K = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__K_o / var_ionic_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_four_AP_sensitive_currents__i_sus = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_four_AP_sensitive_currents__g_sus * var_chaste_interface__four_AP_sensitive_currents_r_gate__r; // nanoA
        const double var_four_AP_sensitive_currents__i_to = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_four_AP_sensitive_currents__g_to * var_chaste_interface__four_AP_sensitive_currents_q_gate__q * var_chaste_interface__four_AP_sensitive_currents_r_gate__r; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = ((var_membrane__Version != 2.0) ? ((-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) : ((102.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y)); // nanoA
        const double var_potassium_background_current__i_b_K = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_background_current__g_b_K; // nanoA
        const double var_rapid_delayed_rectifying_potassium_current__i_K_r = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_rapid_delayed_rectifying_potassium_current__P_a * var_rapid_delayed_rectifying_potassium_current__g_K_r * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_reversal_and_equilibrium_potentials__E_K_s = ((var_membrane__Version == 0) ? (var_membrane__R * var_membrane__T * log((var_ionic_concentrations__K_o + 0.12 * var_ionic_concentrations__Na_o) / (var_ionic_concentrations__K_i + 0.12 * var_ionic_concentrations__Na_i)) / var_membrane__F) : (var_membrane__R * var_membrane__T * log((var_ionic_concentrations__K_o + 0.029999999999999999 * var_ionic_concentrations__Na_o) / (var_ionic_concentrations__K_i + 0.029999999999999999 * var_ionic_concentrations__Na_i)) / var_membrane__F)); // millivolt
        const double var_reversal_and_equilibrium_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Na_o / var_ionic_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_hyperpolarisation_activated_current__i_f_Na = ((var_membrane__Version != 2.0) ? ((-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) : ((-77.599999999999994 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y)); // nanoA
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable = 0.00034450000000000003; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable = 0.00034499999999999998; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published = 0.00051800000000000001; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_0DCapable = 0.0104; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_1DCapable = 0.0104; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_Published = 0.0104; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s = ((var_membrane__Version == 0) ? ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_Published) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_0DCapable) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable) : ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_1DCapable) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable))); // microS
        const double var_slow_delayed_rectifying_potassium_current__i_K_s = pow(var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs, 2) * (-var_reversal_and_equilibrium_potentials__E_K_s + var_chaste_interface__membrane__V) * var_slow_delayed_rectifying_potassium_current__g_K_s; // nanoA
        const double var_sodium_background_current__g_b_Na_Centre_0DCapable = 5.8181799999999999e-5; // microS
        const double var_sodium_background_current__g_b_Na_Centre_1DCapable = 5.8e-5; // microS
        const double var_sodium_background_current__g_b_Na_Centre_Published = 5.8e-5; // microS
        const double var_sodium_background_current__g_b_Na_Periphery_0DCapable = 0.00018880000000000001; // microS
        const double var_sodium_background_current__g_b_Na_Periphery_1DCapable = 0.00018900000000000001; // microS
        const double var_sodium_background_current__g_b_Na_Periphery_Published = 0.00018900000000000001; // microS
        const double var_sodium_background_current__g_b_Na = ((var_membrane__Version == 0) ? ((-var_sodium_background_current__g_b_Na_Centre_Published + var_sodium_background_current__g_b_Na_Periphery_Published) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_background_current__g_b_Na_Centre_0DCapable + var_sodium_background_current__g_b_Na_Periphery_0DCapable) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_0DCapable) : ((-var_sodium_background_current__g_b_Na_Centre_1DCapable + var_sodium_background_current__g_b_Na_Periphery_1DCapable) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_1DCapable))); // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_b_Na; // nanoA
        const double var_sodium_calcium_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_exchanger__gamma_NaCa = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable = 2.7228999999999998e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable = 2.7999999999999999e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Centre_Published = 2.7e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Periphery_0DCapable = 8.8358400000000004e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Periphery_1DCapable = 8.8000000000000004e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Periphery_Published = 8.8000000000000004e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa = ((var_membrane__Version == 0) ? ((-var_sodium_calcium_exchanger__k_NaCa_Centre_Published + var_sodium_calcium_exchanger__k_NaCa_Periphery_Published) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable + var_sodium_calcium_exchanger__k_NaCa_Periphery_0DCapable) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable) : ((-var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable + var_sodium_calcium_exchanger__k_NaCa_Periphery_1DCapable) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable))); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa = ((var_membrane__Version == 0) ? ((pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma_NaCa) - pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i * exp(0.037400000000000003 * (-1.0 + var_sodium_calcium_exchanger__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_sodium_calcium_exchanger__k_NaCa / (1.0 + (pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o + pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i) * var_sodium_calcium_exchanger__d_NaCa)) : ((pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma_NaCa) - pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_exchanger__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_sodium_calcium_exchanger__k_NaCa / (1.0 + (pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o + pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i) * var_sodium_calcium_exchanger__d_NaCa))); // nanoA
        const double var_sodium_current__g_Na_Centre_0DCapable = 0; // microlitre_per_second
        const double var_sodium_current__g_Na_Centre_1DCapable = 0; // microlitre_per_second
        const double var_sodium_current__g_Na_Centre_Published = 0; // microlitre_per_second
        const double var_sodium_current__g_Na_Periphery_0DCapable = 1.204e-6; // microlitre_per_second
        const double var_sodium_current__g_Na_Periphery_1DCapable = 3.7e-7; // microlitre_per_second
        const double var_sodium_current__g_Na_Periphery_Published = 1.1999999999999999e-6; // microlitre_per_second
        const double var_sodium_current__g_Na = ((var_membrane__Version == 0) ? ((-var_sodium_current__g_Na_Centre_Published + var_sodium_current__g_Na_Periphery_Published) * var_membrane__FCell + var_sodium_current__g_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_current__g_Na_Centre_0DCapable + var_sodium_current__g_Na_Periphery_0DCapable) * var_membrane__FCell + var_sodium_current__g_Na_Centre_0DCapable) : ((-var_sodium_current__g_Na_Centre_1DCapable + var_sodium_current__g_Na_Periphery_1DCapable) * var_membrane__FCell + var_sodium_current__g_Na_Centre_1DCapable))); // microlitre_per_second
        const double var_sodium_current_h_gate__F_Na = ((var_membrane__Version == 0) ? (0.086900000000000005 + 0.095200000000000007 * exp(-2.1671999999999998 - 0.063 * var_chaste_interface__membrane__V) / (1.0 + 1.6599999999999999 * exp(-14.332500000000001 - 0.22500000000000001 * var_chaste_interface__membrane__V))) : (0.086929999999999993 + 0.095180000000000001 * exp(-2.1692640000000001 - 0.063060000000000005 * var_chaste_interface__membrane__V) / (1.0 + 1.6619999999999999 * exp(-14.33887 - 0.22509999999999999 * var_chaste_interface__membrane__V)))); // dimensionless
        const double var_sodium_current_h_gate__h = (1.0 - var_sodium_current_h_gate__F_Na) * var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__F_Na * var_chaste_interface__sodium_current_h_gate__h2; // dimensionless
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_ionic_concentrations__Na_o * var_chaste_interface__membrane__V * var_sodium_current__g_Na * var_sodium_current_h_gate__h / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.6399999999999997; // millimolar
        const double var_sodium_potassium_pump__i_p_max_Centre_0DCapable = 0.047825449999999999; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Centre_1DCapable = 0.047800000000000002; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Centre_Published = 0.047800000000000002; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Periphery_0DCapable = 0.15519359999999999; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Periphery_1DCapable = 0.16; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Periphery_Published = 0.16; // nanoA
        const double var_sodium_potassium_pump__i_p_max = ((var_membrane__Version == 0) ? ((-var_sodium_potassium_pump__i_p_max_Centre_Published + var_sodium_potassium_pump__i_p_max_Periphery_Published) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_potassium_pump__i_p_max_Centre_0DCapable + var_sodium_potassium_pump__i_p_max_Periphery_0DCapable) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_0DCapable) : ((-var_sodium_potassium_pump__i_p_max_Centre_1DCapable + var_sodium_potassium_pump__i_p_max_Periphery_1DCapable) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_1DCapable))); // nanoA
        const double var_sodium_potassium_pump__i_p = 1.6000000000000001 * pow(var_ionic_concentrations__K_o, 2) * pow(var_ionic_concentrations__Na_i, 3) * var_sodium_potassium_pump__i_p_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_ionic_concentrations__K_o + var_sodium_potassium_pump__K_m_K), 2) * pow((var_ionic_concentrations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_membrane__V_orig_deriv = -1.0 * (var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_b_Ca + var_four_AP_sensitive_currents__i_sus + var_four_AP_sensitive_currents__i_to + var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na + var_persistent_calcium_current__i_Ca_p + var_potassium_background_current__i_b_K + var_rapid_delayed_rectifying_potassium_current__i_K_r + var_slow_delayed_rectifying_potassium_current__i_K_s + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_p) / var_membrane__Cm; // millivolt / second
        d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane__V;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[4];
            // Units: dimensionless; Initial value: 0.04804900895
            double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[5];
            // Units: dimensionless; Initial value: 0.48779845203
            double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[6];
            // Units: dimensionless; Initial value: 0.42074047435
            double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[7];
            // Units: dimensionless; Initial value: 0.038968420558
            double var_chaste_interface__four_AP_sensitive_currents_q_gate__q = rY[8];
            // Units: dimensionless; Initial value: 0.29760539675
            double var_chaste_interface__four_AP_sensitive_currents_r_gate__r = rY[9];
            // Units: dimensionless; Initial value: 0.064402950262
            double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af = rY[10];
            // Units: dimensionless; Initial value: 0.13034201158
            double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as = rY[11];
            // Units: dimensionless; Initial value: 0.46960956028
            double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i = rY[12];
            // Units: dimensionless; Initial value: 0.87993375273
            double var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs = rY[13];
            // Units: dimensionless; Initial value: 0.082293827208
            double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[14];
            // Units: dimensionless; Initial value: 0.03889291759
            
            const double var_x0 = 0.018714999999999999 * var_chaste_interface__membrane__V;
            const double var_x1 = -0.16666666666666666 * var_chaste_interface__membrane__V;
            const double var_x2 = exp(-2.3500000000000001 + var_x1);
            const double var_x3 = 1.0 + var_x2;
            const double var_x4 = exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V);
            const double var_x5 = 13.441615999999998 - 0.28969 * var_chaste_interface__membrane__V;
            
            partialF = -0.0048327079999999998 - 0.0023092690674785805 * exp(var_x0) - 0.00061881194542590091 * exp(-var_x0) - 0.054649999999999997 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y - 0.00173814 / var_x3 - 0.017225000000000001 * pow(var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs, 2) - 0.003322752 * var_chaste_interface__four_AP_sensitive_currents_r_gate__r + (-0.015940800000000001 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as - 0.023911199999999997 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af) * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i - 0.21390299999999998 * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T - 0.24524999999999997 * var_chaste_interface__four_AP_sensitive_currents_q_gate__q * var_chaste_interface__four_AP_sensitive_currents_r_gate__r - 0.28969 * var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L - 0.0068989604918571314 * var_x4 / pow((1 + 0.66666666666666663 * var_x4), 2) + 0.001 * var_x2 * var_x5 / pow(var_x3, 2);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.092361701692
        
        
        // Mathematics
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_sodium_current_m_gate__m_infinity = ((var_membrane__Version == 0) ? (pow(1 / (1.0 + exp(-0.18315018315018314 * var_chaste_interface__membrane__V)), 0.33333333333333331)) : (pow(1 / (1.0 + exp(-5.5531135531135529 - 0.18315018315018314 * var_chaste_interface__membrane__V)), 0.33333333333333331))); // dimensionless
        const double var_sodium_current_m_gate__tau_m = ((var_membrane__Version == 0) ? (4.0000000000000003e-5 + 0.00062469999999999995 / (0.627 * exp(5.330820000000001 + 0.082000000000000003 * var_chaste_interface__membrane__V) + 0.83199999999999996 * exp(-18.994500000000002 - 0.33500000000000002 * var_chaste_interface__membrane__V))) : (4.5689999999999998e-5 + 0.00062469999999999995 / (0.62739999999999996 * exp(5.3505781299999997 + 0.082299999999999998 * var_chaste_interface__membrane__V) + 0.83221659999999997 * exp(-19.034003092000003 - 0.33566000000000001 * var_chaste_interface__membrane__V)))); // second
        const double var_sodium_current_m_gate__m_orig_deriv = (-var_chaste_interface__sodium_current_m_gate__m + var_sodium_current_m_gate__m_infinity) / var_sodium_current_m_gate__tau_m; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * var_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_m_gate__m;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x11 = exp(5.3505781299999997 + 0.082299999999999998 * var_chaste_interface__membrane__V);
            const double var_x12 = exp(-19.034003092000003 - 0.33566000000000001 * var_chaste_interface__membrane__V);
            const double var_x13 = 1 / (0.62739999999999996 * var_x11 + 0.83221659999999997 * var_x12);
            const double var_x14 = 1 / (4.5689999999999998e-5 + 0.00062469999999999995 * var_x13);
            
            partialF = -0.001 * var_x14;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.015905380261
        
        
        // Mathematics
        const double var_sodium_current_h_gate__h1_infinity = 1 / (1.0 + exp(10.328124999999998 + 0.15625 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h_gate__tau_h1 = 0.00059770000000000005 + 3.7170000000000002e-6 * exp(-4.8164649999999991 - 0.28149999999999997 * var_chaste_interface__membrane__V) / (1.0 + 0.0037320000000000001 * exp(-12.936576000000001 - 0.34260000000000002 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h_gate__h1_orig_deriv = (-var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__h1_infinity) / var_sodium_current_h_gate__tau_h1; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h1 = 0.001 * var_sodium_current_h_gate__h1_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_h_gate__h1;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x15 = exp(-12.936576000000001 - 0.34260000000000002 * var_chaste_interface__membrane__V);
            const double var_x16 = 1.0 + 0.0037320000000000001 * var_x15;
            const double var_x17 = exp(-4.8164649999999991 - 0.28149999999999997 * var_chaste_interface__membrane__V);
            const double var_x18 = var_x17 / var_x16;
            const double var_x22 = 1 / (0.00059770000000000005 + 3.7170000000000002e-6 * var_x18);
            
            partialF = -0.001 * var_x22;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.01445216109
        
        
        // Mathematics
        const double var_sodium_current_h_gate__h1_infinity = 1 / (1.0 + exp(10.328124999999998 + 0.15625 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h_gate__h2_infinity = var_sodium_current_h_gate__h1_infinity; // dimensionless
        const double var_sodium_current_h_gate__tau_h2 = 0.0035560000000000001 + 3.1860000000000002e-8 * exp(-11.69172 - 0.62190000000000001 * var_chaste_interface__membrane__V) / (1.0 + 7.1890000000000005e-5 * exp(-22.768981 - 0.66830000000000001 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h_gate__h2_orig_deriv = (-var_chaste_interface__sodium_current_h_gate__h2 + var_sodium_current_h_gate__h2_infinity) / var_sodium_current_h_gate__tau_h2; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h2 = 0.001 * var_sodium_current_h_gate__h2_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_h_gate__h2;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x24 = exp(-22.768981 - 0.66830000000000001 * var_chaste_interface__membrane__V);
            const double var_x25 = 1.0 + 7.1890000000000005e-5 * var_x24;
            const double var_x26 = exp(-11.69172 - 0.62190000000000001 * var_chaste_interface__membrane__V);
            const double var_x27 = var_x26 / var_x25;
            const double var_x28 = 1 / (0.0035560000000000001 + 3.1860000000000002e-8 * var_x27);
            
            partialF = -0.001 * var_x28;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 0.04804900895
        
        
        // Mathematics
        const double var_membrane__FCellConstant = 1.0309347; // dimensionless
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_L_type_Ca_channel_d_gate__alpha_d_L = ((var_membrane__Version == 0) ? (-84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V)) - 28.379999999999999 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V))) : ((var_membrane__Version == 1.0) ? (-28.390000000000001 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V)) - 84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V))) : (-84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V)) - 28.399999999999999 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V))))); // per_second
        const double var_L_type_Ca_channel_d_gate__beta_d_L = ((var_membrane__Version == 1.0) ? (11.43 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V))) : (11.42 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)))); // per_second
        const double var_L_type_Ca_channel_d_gate__tau_d_L = 2.0 / (var_L_type_Ca_channel_d_gate__alpha_d_L + var_L_type_Ca_channel_d_gate__beta_d_L); // second
        const double var_membrane__dCell = 0; // dimensionless
        const double var_membrane__FCell = ((var_membrane__Version == 0) ? (0.35666666666666669 * (-0.10000000000000001 + 3.0 * var_membrane__dCell) / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : ((var_membrane__Version == 1.0) ? (var_membrane__FCellConstant * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : (1.0343333333333333 * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(12.564102564102564 - 14.871794871794872 * var_membrane__dCell))))); // dimensionless
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = ((var_membrane__Version == 0) ? (1 / (1.0 + exp(-3.8500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V))) : ((var_membrane__Version == 1.0) ? (1 / (1.0 + exp(-3.7166666666666668 - 0.13333333333333333 * var_membrane__FCell - 0.16666666666666666 * var_chaste_interface__membrane__V))) : (1 / (1.0 + exp(-3.6999999999999997 - 0.16666666666666666 * var_chaste_interface__membrane__V))))); // dimensionless
        const double var_L_type_Ca_channel_d_gate__d_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_d_gate__d_L + var_L_type_Ca_channel_d_gate__d_L_infinity) / var_L_type_Ca_channel_d_gate__tau_d_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L = 0.001 * var_L_type_Ca_channel_d_gate__d_L_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x31 = exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V);
            const double var_x32 = -1.0 + var_x31;
            const double var_x33 = 1 / var_x32;
            const double var_x35 = exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V);
            const double var_x36 = -1.0 + var_x35;
            const double var_x37 = 1 / var_x36;
            const double var_x39 = exp(-0.20799999999999999 * var_chaste_interface__membrane__V);
            const double var_x40 = -1.0 + var_x39;
            const double var_x41 = 1 / var_x40;
            const double var_x43 = 35.0 + var_chaste_interface__membrane__V;
            const double var_x44 = -5.0 + var_chaste_interface__membrane__V;
            
            partialF = 0.014195000000000001 * var_x37 * var_x43 + 0.042450000000000002 * var_x41 * var_chaste_interface__membrane__V - 0.0057149999999999996 * var_x33 * var_x44;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.48779845203
        
        
        // Mathematics
        const double var_membrane__FCellConstant = 1.0309347; // dimensionless
        const double var_L_type_Ca_channel_f_gate__f_L_infinity = 1 / (1.0 + exp(9.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_L_type_Ca_channel_f_gate__alpha_f_L = ((var_membrane__Version == 1.0) ? (3.75 * (28.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(7.0 + 0.25 * var_chaste_interface__membrane__V))) : (3.1200000000000001 * (28.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(7.0 + 0.25 * var_chaste_interface__membrane__V)))); // per_second
        const double var_L_type_Ca_channel_f_gate__beta_f_L = ((var_membrane__Version == 1.0) ? (30.0 / (1.0 + exp(-7.0 - 0.25 * var_chaste_interface__membrane__V))) : (25.0 / (1.0 + exp(-7.0 - 0.25 * var_chaste_interface__membrane__V)))); // per_second
        const double var_membrane__dCell = 0; // dimensionless
        const double var_membrane__FCell = ((var_membrane__Version == 0) ? (0.35666666666666669 * (-0.10000000000000001 + 3.0 * var_membrane__dCell) / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : ((var_membrane__Version == 1.0) ? (var_membrane__FCellConstant * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : (1.0343333333333333 * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(12.564102564102564 - 14.871794871794872 * var_membrane__dCell))))); // dimensionless
        const double var_L_type_Ca_channel_f_gate__tau_f_L = ((var_membrane__Version == 1.0) ? ((1.2 - 0.20000000000000001 * var_membrane__FCell) / (var_L_type_Ca_channel_f_gate__alpha_f_L + var_L_type_Ca_channel_f_gate__beta_f_L)) : (1 / (var_L_type_Ca_channel_f_gate__alpha_f_L + var_L_type_Ca_channel_f_gate__beta_f_L))); // second
        const double var_L_type_Ca_channel_f_gate__f_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_gate__f_L + var_L_type_Ca_channel_f_gate__f_L_infinity) / var_L_type_Ca_channel_f_gate__tau_f_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L = 0.001 * var_L_type_Ca_channel_f_gate__f_L_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x47 = 0.25 * var_chaste_interface__membrane__V;
            const double var_x48 = exp(7.0 + var_x47);
            const double var_x49 = -1.0 + var_x48;
            const double var_x50 = 1 / var_x49;
            const double var_x52 = exp(-7.0 - var_x47);
            const double var_x53 = 1.0 + var_x52;
            const double var_x54 = 28.0 + var_chaste_interface__membrane__V;
            const double var_x55 = 1 / var_x53;
            
            partialF = -0.025000000000000001 * var_x55 - 0.0031250000000000002 * var_x50 * var_x54;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.42074047435
        
        
        // Mathematics
        const double var_T_type_Ca_channel_d_gate__alpha_d_T = 1068.0 * exp(0.87666666666666671 + 0.033333333333333333 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_d_gate__beta_d_T = 1068.0 * exp(-0.87666666666666671 - 0.033333333333333333 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_d_gate__d_T_infinity = 1 / (1.0 + exp(-5.4411764705882355 - 0.14705882352941177 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_d_gate__tau_d_T = 1 / (var_T_type_Ca_channel_d_gate__alpha_d_T + var_T_type_Ca_channel_d_gate__beta_d_T); // second
        const double var_T_type_Ca_channel_d_gate__d_T_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_d_gate__d_T + var_T_type_Ca_channel_d_gate__d_T_infinity) / var_T_type_Ca_channel_d_gate__tau_d_T; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T = 0.001 * var_T_type_Ca_channel_d_gate__d_T_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x58 = 0.033333333333333333 * var_chaste_interface__membrane__V;
            const double var_x59 = exp(0.87666666666666671 + var_x58);
            const double var_x60 = exp(-0.87666666666666671 - var_x58);
            
            partialF = -1.0680000000000001 * var_x59 - 1.0680000000000001 * var_x60;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.038968420558
        
        
        // Mathematics
        const double var_membrane__FCellConstant = 1.0309347; // dimensionless
        const double var_T_type_Ca_channel_f_gate__f_T_infinity = 1 / (1.0 + exp(7.8888888888888893 + 0.1111111111111111 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_T_type_Ca_channel_f_gate__beta_f_T = ((var_membrane__Version == 1.0) ? (15.0 * exp(4.6163849154746419 + 0.065019505851755519 * var_chaste_interface__membrane__V)) : (15.0 * exp(4.6618985695708712 + 0.065019505851755519 * var_chaste_interface__membrane__V))); // per_second
        const double var_membrane__dCell = 0; // dimensionless
        const double var_membrane__FCell = ((var_membrane__Version == 0) ? (0.35666666666666669 * (-0.10000000000000001 + 3.0 * var_membrane__dCell) / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : ((var_membrane__Version == 1.0) ? (var_membrane__FCellConstant * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : (1.0343333333333333 * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(12.564102564102564 - 14.871794871794872 * var_membrane__dCell))))); // dimensionless
        const double var_T_type_Ca_channel_f_gate__alpha_f_T = ((var_membrane__Version == 1.0) ? (15.300000000000001 * exp(-0.85234093637454988 - 0.0084033613445378148 * var_membrane__FCell - 0.012004801920768308 * var_chaste_interface__membrane__V)) : (15.300000000000001 * exp(-0.86074429771908767 - 0.012004801920768308 * var_chaste_interface__membrane__V))); // per_second
        const double var_T_type_Ca_channel_f_gate__tau_f_T = 1 / (var_T_type_Ca_channel_f_gate__alpha_f_T + var_T_type_Ca_channel_f_gate__beta_f_T); // second
        const double var_T_type_Ca_channel_f_gate__f_T_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_f_gate__f_T + var_T_type_Ca_channel_f_gate__f_T_infinity) / var_T_type_Ca_channel_f_gate__tau_f_T; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T = 0.001 * var_T_type_Ca_channel_f_gate__f_T_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x64 = exp(4.6163849154746419 + 0.065019505851755519 * var_chaste_interface__membrane__V);
            const double var_x65 = exp(-0.85234093637454988 - 0.012004801920768308 * var_chaste_interface__membrane__V);
            
            partialF = -0.015300000000000001 * var_x65 - 0.014999999999999999 * var_x64;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__four_AP_sensitive_currents_q_gate__q = rY[8];
        // Units: dimensionless; Initial value: 0.29760539675
        
        
        // Mathematics
        const double var_membrane__FCellConstant = 1.0309347; // dimensionless
        const double var_four_AP_sensitive_currents_q_gate__q_infinity = 1 / (1.0 + exp(4.5320610687022898 + 0.076335877862595422 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_membrane__dCell = 0; // dimensionless
        const double var_membrane__FCell = ((var_membrane__Version == 0) ? (0.35666666666666669 * (-0.10000000000000001 + 3.0 * var_membrane__dCell) / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : ((var_membrane__Version == 1.0) ? (var_membrane__FCellConstant * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : (1.0343333333333333 * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(12.564102564102564 - 14.871794871794872 * var_membrane__dCell))))); // dimensionless
        const double var_four_AP_sensitive_currents_q_gate__tau_q = ((var_membrane__Version == 0) ? (0.0101 + 2.4000000000000001e-5 * exp(5.093 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 0.11433333333333336 / exp(-3.9199999999999999 - 0.080000000000000002 * var_chaste_interface__membrane__V)) : ((var_membrane__Version == 1.0) ? (0.010103333333333334 + 0.065166666666666664 / (0.56859999999999999 * exp(-3.1827900000000002 - 0.081610000000000002 * var_chaste_interface__membrane__V - 0.81610000000000005 * var_membrane__FCell) + 0.71740000000000004 * exp((0.27189999999999998 - 0.1719 * var_membrane__FCell) * (40.93 + 10.0 * var_membrane__FCell + var_chaste_interface__membrane__V)))) : (0.0101 + 0.065170000000000006 / (0.56859999999999999 * exp(-3.1827900000000002 - 0.081610000000000002 * var_chaste_interface__membrane__V) + 0.71740000000000004 * exp(11.128867 + 0.27189999999999998 * var_chaste_interface__membrane__V))))); // second
        const double var_four_AP_sensitive_currents_q_gate__q_orig_deriv = (-var_chaste_interface__four_AP_sensitive_currents_q_gate__q + var_four_AP_sensitive_currents_q_gate__q_infinity) / var_four_AP_sensitive_currents_q_gate__tau_q; // 1 / second
        const double d_dt_chaste_interface_var_four_AP_sensitive_currents_q_gate__q = 0.001 * var_four_AP_sensitive_currents_q_gate__q_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_four_AP_sensitive_currents_q_gate__q;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x68 = exp(-3.1827900000000002 - 0.081610000000000002 * var_chaste_interface__membrane__V);
            const double var_x69 = exp(11.128867 + 0.27189999999999998 * var_chaste_interface__membrane__V);
            const double var_x70 = 1 / (0.56859999999999999 * var_x68 + 0.71740000000000004 * var_x69);
            const double var_x71 = 1 / (0.010103333333333334 + 0.065166666666666664 * var_x70);
            
            partialF = -0.001 * var_x71;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__four_AP_sensitive_currents_r_gate__r = rY[9];
        // Units: dimensionless; Initial value: 0.064402950262
        
        
        // Mathematics
        const double var_four_AP_sensitive_currents_r_gate__r_infinity = 1 / (1.0 + exp(0.5548223350253807 - 0.050761421319796954 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_four_AP_sensitive_currents_r_gate__tau_r = ((var_membrane__Version == 0) ? (0.00298 + 0.01559 / (1.0369999999999999 * exp(2.7548999999999997 + 0.089999999999999997 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8607999999999998 - 0.12 * var_chaste_interface__membrane__V))) : ((var_membrane__Version == 1.0) ? (0.0029775000000000001 + 0.019595000000000001 / (1.0369999999999999 * exp(2.7585732000000003 + 0.090120000000000006 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8369599999999999 - 0.11899999999999999 * var_chaste_interface__membrane__V))) : (0.00298 + 0.01959 / (1.0369999999999999 * exp(2.7585732000000003 + 0.090120000000000006 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8369599999999999 - 0.11899999999999999 * var_chaste_interface__membrane__V))))); // second
        const double var_four_AP_sensitive_currents_r_gate__r_orig_deriv = (-var_chaste_interface__four_AP_sensitive_currents_r_gate__r + var_four_AP_sensitive_currents_r_gate__r_infinity) / var_four_AP_sensitive_currents_r_gate__tau_r; // 1 / second
        const double d_dt_chaste_interface_var_four_AP_sensitive_currents_r_gate__r = 0.001 * var_four_AP_sensitive_currents_r_gate__r_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_four_AP_sensitive_currents_r_gate__r;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x74 = exp(2.7585732000000003 + 0.090120000000000006 * var_chaste_interface__membrane__V);
            const double var_x75 = exp(-2.8369599999999999 - 0.11899999999999999 * var_chaste_interface__membrane__V);
            const double var_x76 = 1 / (1.0369999999999999 * var_x74 + 0.36899999999999999 * var_x75);
            const double var_x77 = 1 / (0.0029775000000000001 + 0.019595000000000001 * var_x76);
            
            partialF = -0.001 * var_x77;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af = rY[10];
        // Units: dimensionless; Initial value: 0.13034201158
        
        
        // Mathematics
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_infinity = ((var_membrane__Version != 2.0) ? (1 / (1.0 + exp(-1.3396226415094339 - 0.094339622641509441 * var_chaste_interface__membrane__V))) : (1 / (1.0 + exp(-1.2452830188679245 - 0.094339622641509441 * var_chaste_interface__membrane__V)))); // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_af_gate__tau_P_af = ((var_membrane__Version != 2.0) ? (1 / (0.95999999999999996 * exp(0.40000000000000002 - 0.044444444444444446 * var_chaste_interface__membrane__V) + 37.200000000000003 * exp(-0.56603773584905659 + 0.062893081761006289 * var_chaste_interface__membrane__V))) : (1 / (0.95999999999999996 * exp(0.44444444444444442 - 0.044444444444444446 * var_chaste_interface__membrane__V) + 37.200000000000003 * exp(-0.62893081761006286 + 0.062893081761006289 * var_chaste_interface__membrane__V)))); // second
        const double var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_orig_deriv = (-var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af + var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_infinity) / var_rapid_delayed_rectifying_potassium_current_P_af_gate__tau_P_af; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af = 0.001 * var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x81 = exp(-0.56603773584905659 + 0.062893081761006289 * var_chaste_interface__membrane__V);
            const double var_x82 = exp(0.40000000000000002 - 0.044444444444444446 * var_chaste_interface__membrane__V);
            
            partialF = -0.00095999999999999992 * var_x82 - 0.037200000000000004 * var_x81;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as = rY[11];
        // Units: dimensionless; Initial value: 0.46960956028
        
        
        // Mathematics
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_infinity = ((var_membrane__Version != 2.0) ? (1 / (1.0 + exp(-1.3396226415094339 - 0.094339622641509441 * var_chaste_interface__membrane__V))) : (1 / (1.0 + exp(-1.2452830188679245 - 0.094339622641509441 * var_chaste_interface__membrane__V)))); // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as_infinity = var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_infinity; // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_as_gate__tau_P_as = ((var_membrane__Version != 2.0) ? (1 / (4.2000000000000002 * exp(-0.52941176470588236 + 0.058823529411764705 * var_chaste_interface__membrane__V) + 0.14999999999999999 * exp(0.41666666666666663 - 0.046296296296296294 * var_chaste_interface__membrane__V))) : (1 / (4.2000000000000002 * exp(-0.58823529411764708 + 0.058823529411764705 * var_chaste_interface__membrane__V) + 0.14999999999999999 * exp(0.46296296296296291 - 0.046296296296296294 * var_chaste_interface__membrane__V)))); // second
        const double var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as_orig_deriv = (-var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as + var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as_infinity) / var_rapid_delayed_rectifying_potassium_current_P_as_gate__tau_P_as; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as = 0.001 * var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x84 = exp(-0.52941176470588236 + 0.058823529411764705 * var_chaste_interface__membrane__V);
            const double var_x85 = exp(0.41666666666666663 - 0.046296296296296294 * var_chaste_interface__membrane__V);
            
            partialF = -0.00014999999999999999 * var_x85 - 0.0042000000000000006 * var_x84;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i = rY[12];
        // Units: dimensionless; Initial value: 0.87993375273
        
        
        // Mathematics
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i_infinity = 1 / (1.0 + exp(1.8415841584158419 + 0.099009900990099015 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_i_gate__tau_P_i = (((var_membrane__Version == 0) || (var_membrane__Version == 1.0)) ? (0.002) : (0.0060000000000000001)); // second
        const double var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i_orig_deriv = (-var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i + var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i_infinity) / var_rapid_delayed_rectifying_potassium_current_P_i_gate__tau_P_i; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i = 0.001 * var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.5;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs = rY[13];
        // Units: dimensionless; Initial value: 0.082293827208
        
        
        // Mathematics
        const double var_slow_delayed_rectifying_potassium_current_xs_gate__alpha_xs = 14.0 / (1.0 + exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V)); // per_second
        const double var_slow_delayed_rectifying_potassium_current_xs_gate__beta_xs = exp(-0.022222222222222223 * var_chaste_interface__membrane__V); // per_second
        const double var_slow_delayed_rectifying_potassium_current_xs_gate__xs_orig_deriv = (1.0 - var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs) * var_slow_delayed_rectifying_potassium_current_xs_gate__alpha_xs - var_slow_delayed_rectifying_potassium_current_xs_gate__beta_xs * var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs; // 1 / second
        const double d_dt_chaste_interface_var_slow_delayed_rectifying_potassium_current_xs_gate__xs = 0.001 * var_slow_delayed_rectifying_potassium_current_xs_gate__xs_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_slow_delayed_rectifying_potassium_current_xs_gate__xs;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x61 = 0.1111111111111111 * var_chaste_interface__membrane__V;
            const double var_x87 = exp(-0.022222222222222223 * var_chaste_interface__membrane__V);
            const double var_x88 = exp(4.4444444444444446 - var_x61);
            const double var_x89 = 1.0 + var_x88;
            
            partialF = -0.001 * var_x87 - 0.014 / var_x89;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluateYDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[14];
        // Units: dimensionless; Initial value: 0.03889291759
        
        
        // Mathematics
        const double var_hyperpolarisation_activated_current_y_gate__beta_y = exp(3.5355294117647058 + 0.047058823529411764 * var_chaste_interface__membrane__V); // per_second
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_hyperpolarisation_activated_current_y_gate__alpha_y = ((var_membrane__Version == 0) ? (exp(-2.9643125469571747 - 0.037565740045078885 * var_chaste_interface__membrane__V)) : (exp(-2.9631993991738641 - 0.037551633496057078 * var_chaste_interface__membrane__V))); // per_second
        const double var_hyperpolarisation_activated_current_y_gate__y_orig_deriv = (1.0 - var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) * var_hyperpolarisation_activated_current_y_gate__alpha_y - var_hyperpolarisation_activated_current_y_gate__beta_y * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // 1 / second
        const double d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y = 0.001 * var_hyperpolarisation_activated_current_y_gate__y_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;
    }

    double Cellzhang_SAN_model_2000_allFromCellMLGRL2::EvaluatePartialDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -39.013558536
            
            const double var_x90 = exp(3.5355294117647058 + 0.047058823529411764 * var_chaste_interface__membrane__V);
            const double var_x91 = exp(-2.9631993991738641 - 0.037551633496057078 * var_chaste_interface__membrane__V);
            
            partialF = -0.001 * var_x90 - 0.001 * var_x91;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }

    std::vector<double> Cellzhang_SAN_model_2000_allFromCellMLGRL2::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics

        std::vector<double> dqs(1);
        dqs[0] = var_chaste_interface__environment__time_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellzhang_SAN_model_2000_allFromCellMLGRL2>::Initialise(void)
{
    this->mSystemName = "zhang_SAN_model_2000_all";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-39.013558536);

    // rY[1]:
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.092361701692);

    // rY[2]:
    this->mVariableNames.push_back("sodium_current_h_gate__h1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.015905380261);

    // rY[3]:
    this->mVariableNames.push_back("sodium_current_h_gate__h2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01445216109);

    // rY[4]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.04804900895);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_gate__f_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.48779845203);

    // rY[6]:
    this->mVariableNames.push_back("T_type_Ca_channel_d_gate__d_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.42074047435);

    // rY[7]:
    this->mVariableNames.push_back("T_type_Ca_channel_f_gate__f_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.038968420558);

    // rY[8]:
    this->mVariableNames.push_back("four_AP_sensitive_currents_q_gate__q");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.29760539675);

    // rY[9]:
    this->mVariableNames.push_back("four_AP_sensitive_currents_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.064402950262);

    // rY[10]:
    this->mVariableNames.push_back("rapid_delayed_rectifying_potassium_current_P_af_gate__P_af");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.13034201158);

    // rY[11]:
    this->mVariableNames.push_back("rapid_delayed_rectifying_potassium_current_P_as_gate__P_as");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.46960956028);

    // rY[12]:
    this->mVariableNames.push_back("rapid_delayed_rectifying_potassium_current_P_i_gate__P_i");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.87993375273);

    // rY[13]:
    this->mVariableNames.push_back("slow_delayed_rectifying_potassium_current_xs_gate__xs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.082293827208);

    // rY[14]:
    this->mVariableNames.push_back("hyperpolarisation_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.03889291759);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellzhang_SAN_model_2000_allFromCellMLGRL2)
