//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: tentusscher_model_2004_endo
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "ten_tusscher_model_2004_endo.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellten_tusscher_model_2004_endoFromCellMLGRL2::Cellten_tusscher_model_2004_endoFromCellMLGRL2(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                17,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellten_tusscher_model_2004_endoFromCellMLGRL2>::Instance();
        Init();
        
        this->mParameters[0] = 0.000175; // (var_L_type_Ca_current__g_CaL) [litre_per_farad_second]
        this->mParameters[1] = 14.837999999999999; // (var_fast_sodium_current__g_Na) [nanoS_per_picoF]
        this->mParameters[2] = 0.096000000000000002; // (var_rapid_time_dependent_potassium_current__g_Kr) [nanoS_per_picoF]
        this->mParameters[3] = 0.072999999999999995; // (var_transient_outward_current__g_to) [nanoS_per_picoF]
    }

    Cellten_tusscher_model_2004_endoFromCellMLGRL2::~Cellten_tusscher_model_2004_endoFromCellMLGRL2()
    {
    }
    
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0002
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[2];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[3];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[4];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
        // Units: dimensionless; Initial value: 0.75
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[7];
        // Units: dimensionless; Initial value: 0.75
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[8];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[9];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_current_fCa_gate__fCa = rY[10];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
        // Units: dimensionless; Initial value: 0.3212
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__sodium_dynamics__Na_i = rY[15];
        // Units: millimolar; Initial value: 11.6
        double var_chaste_interface__potassium_dynamics__K_i = rY[16];
        // Units: millimolar; Initial value: 138.3
        
        const double var_calcium_background_current__g_bca = 0.00059199999999999997; // nanoS_per_picoF
        const double var_calcium_dynamics__Ca_o = 2.0; // millimolar
        const double var_calcium_pump_current__K_pCa = 0.00050000000000000001; // millimolar
        const double var_calcium_pump_current__g_pCa = 0.82499999999999996; // picoA_per_picoF
        const double var_calcium_pump_current__i_p_Ca = var_chaste_interface__calcium_dynamics__Ca_i * var_calcium_pump_current__g_pCa / (var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_pump_current__K_pCa); // picoA_per_picoF
        const double var_inward_rectifier_potassium_current__g_K1 = 5.4050000000000002; // nanoS_per_picoF
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_current__i_CaL = 4.0 * pow(var_membrane__F, 2) * (-0.34100000000000003 * var_calcium_dynamics__Ca_o + var_chaste_interface__calcium_dynamics__Ca_i * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * mParameters[0] * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_fCa_gate__fCa * var_chaste_interface__L_type_Ca_current_f_gate__f * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA_per_picoF
        const double var_potassium_dynamics__K_o = 5.4000000000000004; // millimolar
        const double var_potassium_pump_current__g_pK = 0.0146; // nanoS_per_picoF
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Ca_o / var_chaste_interface__calcium_dynamics__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // picoA_per_picoF
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_potassium_dynamics__K_o / var_chaste_interface__potassium_dynamics__K_i) / var_membrane__F; // millivolt
        const double var_inward_rectifier_potassium_current__alpha_K1 = 0.10000000000000001 / (1.0 + exp(-12.0 + 0.059999999999999998 * var_chaste_interface__membrane__V - 0.059999999999999998 * var_reversal_potentials__E_K)); // dimensionless
        const double var_inward_rectifier_potassium_current__beta_K1 = (3.0 * exp(0.02 + 0.00020000000000000001 * var_chaste_interface__membrane__V - 0.00020000000000000001 * var_reversal_potentials__E_K) + exp(-1.0 + 0.10000000000000001 * var_chaste_interface__membrane__V - 0.10000000000000001 * var_reversal_potentials__E_K)) / (1.0 + exp(0.5 * var_reversal_potentials__E_K - 0.5 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_inward_rectifier_potassium_current__xK1_inf = var_inward_rectifier_potassium_current__alpha_K1 / (var_inward_rectifier_potassium_current__alpha_K1 + var_inward_rectifier_potassium_current__beta_K1); // dimensionless
        const double var_inward_rectifier_potassium_current__i_K1 = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier_potassium_current__g_K1 * var_inward_rectifier_potassium_current__xK1_inf; // picoA_per_picoF
        const double var_potassium_pump_current__i_p_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_pump_current__g_pK / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[2] * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2; // picoA_per_picoF
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_slow_time_dependent_potassium_current__g_Ks = 0.245; // nanoS_per_picoF
        const double var_sodium_background_current__g_bna = 0.00029; // nanoS_per_picoF
        const double var_sodium_calcium_exchanger_current__K_NaCa = 1000.0; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger_current__Km_Ca = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger_current__Km_Nai = 87.5; // millimolar
        const double var_sodium_calcium_exchanger_current__alpha = 2.5; // dimensionless
        const double var_sodium_calcium_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_reversal_potentials__P_kna * var_sodium_dynamics__Na_o + var_potassium_dynamics__K_o) / (var_reversal_potentials__P_kna * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i)) / var_membrane__F; // millivolt
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_sodium_dynamics__Na_o / var_chaste_interface__sodium_dynamics__Na_i) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * mParameters[1] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // picoA_per_picoF
        const double var_slow_time_dependent_potassium_current__i_Ks = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_time_dependent_potassium_current__g_Ks; // picoA_per_picoF
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__i_NaCa = (pow(var_chaste_interface__sodium_dynamics__Na_i, 3) * var_calcium_dynamics__Ca_o * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger_current__gamma / (var_membrane__R * var_membrane__T)) - pow(var_sodium_dynamics__Na_o, 3) * var_chaste_interface__calcium_dynamics__Ca_i * var_sodium_calcium_exchanger_current__alpha * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger_current__K_NaCa / ((1.0 + var_sodium_calcium_exchanger_current__K_sat * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_sodium_calcium_exchanger_current__Km_Nai, 3) + pow(var_sodium_dynamics__Na_o, 3)) * (var_calcium_dynamics__Ca_o + var_sodium_calcium_exchanger_current__Km_Ca)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump_current__K_mk = 1.0; // millimolar
        const double var_sodium_potassium_pump_current__P_NaK = 1.3620000000000001; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = var_potassium_dynamics__K_o * var_chaste_interface__sodium_dynamics__Na_i * var_sodium_potassium_pump_current__P_NaK / ((var_potassium_dynamics__K_o + var_sodium_potassium_pump_current__K_mk) * (var_chaste_interface__sodium_dynamics__Na_i + var_sodium_potassium_pump_current__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // picoA_per_picoF
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[3] * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // picoA_per_picoF
        const double var_chaste_interface__i_ionic = (var_L_type_Ca_current__i_CaL + var_calcium_background_current__i_b_Ca + var_calcium_pump_current__i_p_Ca + var_fast_sodium_current__i_Na + var_inward_rectifier_potassium_current__i_K1 + var_potassium_pump_current__i_p_K + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger_current__i_NaCa + var_sodium_potassium_pump_current__i_NaK + var_transient_outward_current__i_to) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellten_tusscher_model_2004_endoFromCellMLGRL2::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0002
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[2];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[3];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[4];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
        // Units: dimensionless; Initial value: 0.75
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[7];
        // Units: dimensionless; Initial value: 0.75
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[8];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[9];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_current_fCa_gate__fCa = rY[10];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
        // Units: dimensionless; Initial value: 0.3212
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__sodium_dynamics__Na_i = rY[15];
        // Units: millimolar; Initial value: 11.6
        double var_chaste_interface__potassium_dynamics__K_i = rY[16];
        // Units: millimolar; Initial value: 138.3
        

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_calcium_background_current__g_bca = 0.00059199999999999997; // nanoS_per_picoF
        const double var_calcium_dynamics__Ca_o = 2.0; // millimolar
        const double var_calcium_pump_current__K_pCa = 0.00050000000000000001; // millimolar
        const double var_calcium_pump_current__g_pCa = 0.82499999999999996; // picoA_per_picoF
        const double var_calcium_pump_current__i_p_Ca = var_chaste_interface__calcium_dynamics__Ca_i * var_calcium_pump_current__g_pCa / (var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_pump_current__K_pCa); // picoA_per_picoF
        const double var_inward_rectifier_potassium_current__g_K1 = 5.4050000000000002; // nanoS_per_picoF
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_current__i_CaL = 4.0 * pow(var_membrane__F, 2) * (-0.34100000000000003 * var_calcium_dynamics__Ca_o + var_chaste_interface__calcium_dynamics__Ca_i * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * mParameters[0] * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_fCa_gate__fCa * var_chaste_interface__L_type_Ca_current_f_gate__f * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA_per_picoF
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_Stim = var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // picoA_per_picoF
        const double var_potassium_dynamics__K_o = 5.4000000000000004; // millimolar
        const double var_potassium_pump_current__g_pK = 0.0146; // nanoS_per_picoF
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Ca_o / var_chaste_interface__calcium_dynamics__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // picoA_per_picoF
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_potassium_dynamics__K_o / var_chaste_interface__potassium_dynamics__K_i) / var_membrane__F; // millivolt
        const double var_inward_rectifier_potassium_current__alpha_K1 = 0.10000000000000001 / (1.0 + exp(-12.0 + 0.059999999999999998 * var_chaste_interface__membrane__V - 0.059999999999999998 * var_reversal_potentials__E_K)); // dimensionless
        const double var_inward_rectifier_potassium_current__beta_K1 = (3.0 * exp(0.02 + 0.00020000000000000001 * var_chaste_interface__membrane__V - 0.00020000000000000001 * var_reversal_potentials__E_K) + exp(-1.0 + 0.10000000000000001 * var_chaste_interface__membrane__V - 0.10000000000000001 * var_reversal_potentials__E_K)) / (1.0 + exp(0.5 * var_reversal_potentials__E_K - 0.5 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_inward_rectifier_potassium_current__xK1_inf = var_inward_rectifier_potassium_current__alpha_K1 / (var_inward_rectifier_potassium_current__alpha_K1 + var_inward_rectifier_potassium_current__beta_K1); // dimensionless
        const double var_inward_rectifier_potassium_current__i_K1 = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier_potassium_current__g_K1 * var_inward_rectifier_potassium_current__xK1_inf; // picoA_per_picoF
        const double var_potassium_pump_current__i_p_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_pump_current__g_pK / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[2] * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2; // picoA_per_picoF
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_slow_time_dependent_potassium_current__g_Ks = 0.245; // nanoS_per_picoF
        const double var_sodium_background_current__g_bna = 0.00029; // nanoS_per_picoF
        const double var_sodium_calcium_exchanger_current__K_NaCa = 1000.0; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger_current__Km_Ca = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger_current__Km_Nai = 87.5; // millimolar
        const double var_sodium_calcium_exchanger_current__alpha = 2.5; // dimensionless
        const double var_sodium_calcium_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_reversal_potentials__P_kna * var_sodium_dynamics__Na_o + var_potassium_dynamics__K_o) / (var_reversal_potentials__P_kna * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i)) / var_membrane__F; // millivolt
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_sodium_dynamics__Na_o / var_chaste_interface__sodium_dynamics__Na_i) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * mParameters[1] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // picoA_per_picoF
        const double var_slow_time_dependent_potassium_current__i_Ks = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_time_dependent_potassium_current__g_Ks; // picoA_per_picoF
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__i_NaCa = (pow(var_chaste_interface__sodium_dynamics__Na_i, 3) * var_calcium_dynamics__Ca_o * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger_current__gamma / (var_membrane__R * var_membrane__T)) - pow(var_sodium_dynamics__Na_o, 3) * var_chaste_interface__calcium_dynamics__Ca_i * var_sodium_calcium_exchanger_current__alpha * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger_current__K_NaCa / ((1.0 + var_sodium_calcium_exchanger_current__K_sat * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_sodium_calcium_exchanger_current__Km_Nai, 3) + pow(var_sodium_dynamics__Na_o, 3)) * (var_calcium_dynamics__Ca_o + var_sodium_calcium_exchanger_current__Km_Ca)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump_current__K_mk = 1.0; // millimolar
        const double var_sodium_potassium_pump_current__P_NaK = 1.3620000000000001; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = var_potassium_dynamics__K_o * var_chaste_interface__sodium_dynamics__Na_i * var_sodium_potassium_pump_current__P_NaK / ((var_potassium_dynamics__K_o + var_sodium_potassium_pump_current__K_mk) * (var_chaste_interface__sodium_dynamics__Na_i + var_sodium_potassium_pump_current__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // picoA_per_picoF
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[3] * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // picoA_per_picoF
        d_dt_chaste_interface_var_membrane__V = -var_L_type_Ca_current__i_CaL - var_calcium_background_current__i_b_Ca - var_calcium_pump_current__i_p_Ca - var_fast_sodium_current__i_Na - var_inward_rectifier_potassium_current__i_K1 - var_membrane__i_Stim - var_potassium_pump_current__i_p_K - var_rapid_time_dependent_potassium_current__i_Kr - var_slow_time_dependent_potassium_current__i_Ks - var_sodium_background_current__i_b_Na - var_sodium_calcium_exchanger_current__i_NaCa - var_sodium_potassium_pump_current__i_NaK - var_transient_outward_current__i_to; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Cellten_tusscher_model_2004_endoFromCellMLGRL2::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0002
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[2];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[3];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[4];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
        // Units: dimensionless; Initial value: 0.75
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[7];
        // Units: dimensionless; Initial value: 0.75
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[8];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[9];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_current_fCa_gate__fCa = rY[10];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
        // Units: dimensionless; Initial value: 0.3212
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__calcium_dynamics__Ca_SR = rY[13];
        // Units: millimolar; Initial value: 0.2
        double var_chaste_interface__calcium_dynamics__g = rY[14];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__sodium_dynamics__Na_i = rY[15];
        // Units: millimolar; Initial value: 11.6
        double var_chaste_interface__potassium_dynamics__K_i = rY[16];
        // Units: millimolar; Initial value: 138.3
        
        
        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_L_type_Ca_current_fCa_gate__tau_fCa = 2.0; // millisecond
        const double var_calcium_background_current__g_bca = 0.00059199999999999997; // nanoS_per_picoF
        const double var_calcium_dynamics__Buf_c = 0.14999999999999999; // millimolar
        const double var_calcium_dynamics__Buf_sr = 10.0; // millimolar
        const double var_L_type_Ca_current_fCa_gate__alpha_fCa = 1 / (1.0 + 8.034023767017109e+27 * pow(var_chaste_interface__calcium_dynamics__Ca_i, 8)); // dimensionless
        const double var_L_type_Ca_current_fCa_gate__beta_fCa = 0.10000000000000001 / (1.0 + exp(-5.0 + 10000.0 * var_chaste_interface__calcium_dynamics__Ca_i)); // dimensionless
        const double var_L_type_Ca_current_fCa_gate__gama_fCa = 0.20000000000000001 / (1.0 + exp(-0.9375 + 1250.0 * var_chaste_interface__calcium_dynamics__Ca_i)); // dimensionless
        const double var_L_type_Ca_current_fCa_gate__fCa_inf = 0.15753424657534248 + 0.68493150684931503 * var_L_type_Ca_current_fCa_gate__alpha_fCa + 0.68493150684931503 * var_L_type_Ca_current_fCa_gate__beta_fCa + 0.68493150684931503 * var_L_type_Ca_current_fCa_gate__gama_fCa; // dimensionless
        const double var_L_type_Ca_current_fCa_gate__d_fCa = (-var_chaste_interface__L_type_Ca_current_fCa_gate__fCa + var_L_type_Ca_current_fCa_gate__fCa_inf) / var_L_type_Ca_current_fCa_gate__tau_fCa; // per_millisecond
        const double var_calcium_dynamics__Ca_o = 2.0; // millimolar
        const double var_calcium_dynamics__K_buf_c = 0.001; // millimolar
        const double var_calcium_dynamics__Ca_i_bufc = 1 / (1.0 + var_calcium_dynamics__Buf_c * var_calcium_dynamics__K_buf_c / pow((var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_dynamics__K_buf_c), 2)); // dimensionless
        const double var_calcium_dynamics__K_buf_sr = 0.29999999999999999; // millimolar
        const double var_calcium_dynamics__Ca_sr_bufsr = 1 / (1.0 + var_calcium_dynamics__Buf_sr * var_calcium_dynamics__K_buf_sr / pow((var_chaste_interface__calcium_dynamics__Ca_SR + var_calcium_dynamics__K_buf_sr), 2)); // dimensionless
        const double var_calcium_dynamics__K_up = 0.00025000000000000001; // millimolar
        const double var_calcium_dynamics__V_leak = 8.0000000000000007e-5; // per_millisecond
        const double var_calcium_dynamics__V_sr = 0.0010939999999999999; // micrometre3
        const double var_calcium_dynamics__Vmax_up = 0.00042499999999999998; // millimolar_per_millisecond
        const double var_calcium_dynamics__a_rel = 0.016463999999999999; // millimolar_per_millisecond
        const double var_calcium_dynamics__b_rel = 0.25; // millimolar
        const double var_calcium_dynamics__c_rel = 0.0082319999999999997; // millimolar_per_millisecond
        const double var_calcium_dynamics__g_inf = ((var_chaste_interface__calcium_dynamics__Ca_i < 0.00035) ? (1 / (1.0 + 5.439910241481016e+20 * pow(var_chaste_interface__calcium_dynamics__Ca_i, 6))) : (1 / (1.0 + 1.9720198874049176e+55 * pow(var_chaste_interface__calcium_dynamics__Ca_i, 16)))); // dimensionless
        const double var_calcium_dynamics__i_leak = (-var_chaste_interface__calcium_dynamics__Ca_i + var_chaste_interface__calcium_dynamics__Ca_SR) * var_calcium_dynamics__V_leak; // millimolar_per_millisecond
        const double var_calcium_dynamics__i_rel = (pow(var_chaste_interface__calcium_dynamics__Ca_SR, 2) * var_calcium_dynamics__a_rel / (pow(var_chaste_interface__calcium_dynamics__Ca_SR, 2) + pow(var_calcium_dynamics__b_rel, 2)) + var_calcium_dynamics__c_rel) * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__calcium_dynamics__g; // millimolar_per_millisecond
        const double var_calcium_dynamics__i_up = var_calcium_dynamics__Vmax_up / (1.0 + pow(var_calcium_dynamics__K_up, 2) / pow(var_chaste_interface__calcium_dynamics__Ca_i, 2)); // millimolar_per_millisecond
        const double var_calcium_dynamics__tau_g = 2.0; // millisecond
        const double var_calcium_dynamics__d_g = (-var_chaste_interface__calcium_dynamics__g + var_calcium_dynamics__g_inf) / var_calcium_dynamics__tau_g; // per_millisecond
        const double var_calcium_pump_current__K_pCa = 0.00050000000000000001; // millimolar
        const double var_calcium_pump_current__g_pCa = 0.82499999999999996; // picoA_per_picoF
        const double var_calcium_pump_current__i_p_Ca = var_chaste_interface__calcium_dynamics__Ca_i * var_calcium_pump_current__g_pCa / (var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_pump_current__K_pCa); // picoA_per_picoF
        const double var_inward_rectifier_potassium_current__g_K1 = 5.4050000000000002; // nanoS_per_picoF
        const double var_membrane__Cm = 0.185; // microF
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double d_dt_chaste_interface_var_L_type_Ca_current_fCa_gate__fCa = (((var_chaste_interface__membrane__V > -60.0) && (var_chaste_interface__L_type_Ca_current_fCa_gate__fCa < var_L_type_Ca_current_fCa_gate__fCa_inf)) ? (0) : (var_L_type_Ca_current_fCa_gate__d_fCa)); // 1 / millisecond
        const double d_dt_chaste_interface_var_calcium_dynamics__g = (((var_chaste_interface__membrane__V > -60.0) && (var_chaste_interface__calcium_dynamics__g < var_calcium_dynamics__g_inf)) ? (0) : (var_calcium_dynamics__d_g)); // 1 / millisecond
        const double var_L_type_Ca_current__i_CaL = 4.0 * pow(var_membrane__F, 2) * (-0.34100000000000003 * var_calcium_dynamics__Ca_o + var_chaste_interface__calcium_dynamics__Ca_i * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * mParameters[0] * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_fCa_gate__fCa * var_chaste_interface__L_type_Ca_current_f_gate__f * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA_per_picoF
        const double var_L_type_Ca_current_d_gate__alpha_d = 0.25 + 1.3999999999999999 / (1.0 + exp(-2.6923076923076925 - 0.076923076923076927 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_d_gate__beta_d = 1.3999999999999999 / (1.0 + exp(1.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_d_gate__d_inf = 1 / (1.0 + exp(-0.66666666666666663 - 0.13333333333333333 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_d_gate__gamma_d = 1 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__membrane__V)); // millisecond
        const double var_L_type_Ca_current_d_gate__tau_d = var_L_type_Ca_current_d_gate__alpha_d * var_L_type_Ca_current_d_gate__beta_d + var_L_type_Ca_current_d_gate__gamma_d; // millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current_d_gate__d = (-var_chaste_interface__L_type_Ca_current_d_gate__d + var_L_type_Ca_current_d_gate__d_inf) / var_L_type_Ca_current_d_gate__tau_d; // 1 / millisecond
        const double var_L_type_Ca_current_f_gate__f_inf = 1 / (1.0 + exp(2.8571428571428572 + 0.14285714285714285 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_f_gate__tau_f = 80.0 + 165.0 / (1.0 + exp(2.5 - 0.10000000000000001 * var_chaste_interface__membrane__V)) + 1125.0 * exp(-3.0375000000000001 * pow((1 + 0.037037037037037035 * var_chaste_interface__membrane__V), 2)); // millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current_f_gate__f = (-var_chaste_interface__L_type_Ca_current_f_gate__f + var_L_type_Ca_current_f_gate__f_inf) / var_L_type_Ca_current_f_gate__tau_f; // 1 / millisecond
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (0.057000000000000002 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0)); // per_millisecond
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (310000.0 * exp(0.34849999999999998 * var_chaste_interface__membrane__V) + 2.7000000000000002 * exp(0.079000000000000001 * var_chaste_interface__membrane__V)) : (5.9230769230769234 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_h_gate__h_inf = 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__membrane__V)), 2); // dimensionless
        const double var_fast_sodium_current_h_gate__tau_h = 1 / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h); // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = (-var_chaste_interface__fast_sodium_current_h_gate__h + var_fast_sodium_current_h_gate__h_inf) / var_fast_sodium_current_h_gate__tau_h; // 1 / millisecond
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__membrane__V) * (-25428.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 6.9480000000000002e-6 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))) : (0)); // per_millisecond
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (0.024240000000000001 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (0.59999999999999998 * exp(0.057000000000000002 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_j_gate__j_inf = 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__membrane__V)), 2); // dimensionless
        const double var_fast_sodium_current_j_gate__tau_j = 1 / (var_fast_sodium_current_j_gate__alpha_j + var_fast_sodium_current_j_gate__beta_j); // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_j_gate__j = (-var_chaste_interface__fast_sodium_current_j_gate__j + var_fast_sodium_current_j_gate__j_inf) / var_fast_sodium_current_j_gate__tau_j; // 1 / millisecond
        const double var_fast_sodium_current_m_gate__alpha_m = 1 / (1.0 + exp(-12.0 - 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_fast_sodium_current_m_gate__beta_m = 0.10000000000000001 / (1.0 + exp(7.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)) + 0.10000000000000001 / (1.0 + exp(-0.25 + 0.0050000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_fast_sodium_current_m_gate__m_inf = 1 / pow((1.0 + exp(-6.2967884828349945 - 0.11074197120708749 * var_chaste_interface__membrane__V)), 2); // dimensionless
        const double var_fast_sodium_current_m_gate__tau_m = var_fast_sodium_current_m_gate__alpha_m * var_fast_sodium_current_m_gate__beta_m; // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = (-var_chaste_interface__fast_sodium_current_m_gate__m + var_fast_sodium_current_m_gate__m_inf) / var_fast_sodium_current_m_gate__tau_m; // 1 / millisecond
        const double var_membrane__V_c = 0.016403999999999998; // micrometre3
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_SR = (-var_calcium_dynamics__i_leak - var_calcium_dynamics__i_rel + var_calcium_dynamics__i_up) * var_calcium_dynamics__Ca_sr_bufsr * var_membrane__V_c / var_calcium_dynamics__V_sr; // millimolar / millisecond
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_Stim = var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // picoA_per_picoF
        const double var_potassium_dynamics__K_o = 5.4000000000000004; // millimolar
        const double var_potassium_pump_current__g_pK = 0.0146; // nanoS_per_picoF
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__alpha_xr1 = 450.0 / (1.0 + exp(-4.5 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__beta_xr1 = 6.0 / (1.0 + exp(2.6086956521739131 + 0.086956521739130432 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__tau_xr1 = var_rapid_time_dependent_potassium_current_Xr1_gate__alpha_xr1 * var_rapid_time_dependent_potassium_current_Xr1_gate__beta_xr1; // millisecond
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__xr1_inf = 1 / (1.0 + exp(-3.7142857142857144 - 0.14285714285714285 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = (-var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 + var_rapid_time_dependent_potassium_current_Xr1_gate__xr1_inf) / var_rapid_time_dependent_potassium_current_Xr1_gate__tau_xr1; // 1 / millisecond
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__alpha_xr2 = 3.0 / (1.0 + exp(-3.0 - 0.050000000000000003 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__beta_xr2 = 1.1200000000000001 / (1.0 + exp(-3.0 + 0.050000000000000003 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__tau_xr2 = var_rapid_time_dependent_potassium_current_Xr2_gate__alpha_xr2 * var_rapid_time_dependent_potassium_current_Xr2_gate__beta_xr2; // millisecond
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__xr2_inf = 1 / (1.0 + exp(3.6666666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = (-var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 + var_rapid_time_dependent_potassium_current_Xr2_gate__xr2_inf) / var_rapid_time_dependent_potassium_current_Xr2_gate__tau_xr2; // 1 / millisecond
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Ca_o / var_chaste_interface__calcium_dynamics__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // picoA_per_picoF
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_potassium_dynamics__K_o / var_chaste_interface__potassium_dynamics__K_i) / var_membrane__F; // millivolt
        const double var_inward_rectifier_potassium_current__alpha_K1 = 0.10000000000000001 / (1.0 + exp(-12.0 + 0.059999999999999998 * var_chaste_interface__membrane__V - 0.059999999999999998 * var_reversal_potentials__E_K)); // dimensionless
        const double var_inward_rectifier_potassium_current__beta_K1 = (3.0 * exp(0.02 + 0.00020000000000000001 * var_chaste_interface__membrane__V - 0.00020000000000000001 * var_reversal_potentials__E_K) + exp(-1.0 + 0.10000000000000001 * var_chaste_interface__membrane__V - 0.10000000000000001 * var_reversal_potentials__E_K)) / (1.0 + exp(0.5 * var_reversal_potentials__E_K - 0.5 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_inward_rectifier_potassium_current__xK1_inf = var_inward_rectifier_potassium_current__alpha_K1 / (var_inward_rectifier_potassium_current__alpha_K1 + var_inward_rectifier_potassium_current__beta_K1); // dimensionless
        const double var_inward_rectifier_potassium_current__i_K1 = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier_potassium_current__g_K1 * var_inward_rectifier_potassium_current__xK1_inf; // picoA_per_picoF
        const double var_potassium_pump_current__i_p_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_pump_current__g_pK / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[2] * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2; // picoA_per_picoF
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_slow_time_dependent_potassium_current__g_Ks = 0.245; // nanoS_per_picoF
        const double var_slow_time_dependent_potassium_current_Xs_gate__alpha_xs = 1100.0 / sqrt(1.0 + exp(-1.6666666666666667 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_time_dependent_potassium_current_Xs_gate__beta_xs = 1 / (1.0 + exp(-3.0 + 0.050000000000000003 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_time_dependent_potassium_current_Xs_gate__tau_xs = var_slow_time_dependent_potassium_current_Xs_gate__alpha_xs * var_slow_time_dependent_potassium_current_Xs_gate__beta_xs; // millisecond
        const double var_slow_time_dependent_potassium_current_Xs_gate__xs_inf = 1 / (1.0 + exp(-0.35714285714285715 - 0.071428571428571425 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_Xs_gate__Xs = (-var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs + var_slow_time_dependent_potassium_current_Xs_gate__xs_inf) / var_slow_time_dependent_potassium_current_Xs_gate__tau_xs; // 1 / millisecond
        const double var_sodium_background_current__g_bna = 0.00029; // nanoS_per_picoF
        const double var_sodium_calcium_exchanger_current__K_NaCa = 1000.0; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger_current__Km_Ca = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger_current__Km_Nai = 87.5; // millimolar
        const double var_sodium_calcium_exchanger_current__alpha = 2.5; // dimensionless
        const double var_sodium_calcium_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_reversal_potentials__P_kna * var_sodium_dynamics__Na_o + var_potassium_dynamics__K_o) / (var_reversal_potentials__P_kna * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i)) / var_membrane__F; // millivolt
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_sodium_dynamics__Na_o / var_chaste_interface__sodium_dynamics__Na_i) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * mParameters[1] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // picoA_per_picoF
        const double var_slow_time_dependent_potassium_current__i_Ks = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_time_dependent_potassium_current__g_Ks; // picoA_per_picoF
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__i_NaCa = (pow(var_chaste_interface__sodium_dynamics__Na_i, 3) * var_calcium_dynamics__Ca_o * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger_current__gamma / (var_membrane__R * var_membrane__T)) - pow(var_sodium_dynamics__Na_o, 3) * var_chaste_interface__calcium_dynamics__Ca_i * var_sodium_calcium_exchanger_current__alpha * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger_current__K_NaCa / ((1.0 + var_sodium_calcium_exchanger_current__K_sat * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_sodium_calcium_exchanger_current__Km_Nai, 3) + pow(var_sodium_dynamics__Na_o, 3)) * (var_calcium_dynamics__Ca_o + var_sodium_calcium_exchanger_current__Km_Ca)); // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_i = (-var_calcium_dynamics__i_up - 0.5 * (-2.0 * var_sodium_calcium_exchanger_current__i_NaCa + var_L_type_Ca_current__i_CaL + var_calcium_background_current__i_b_Ca + var_calcium_pump_current__i_p_Ca) * var_membrane__Cm / (var_membrane__F * var_membrane__V_c) + var_calcium_dynamics__i_leak + var_calcium_dynamics__i_rel) * var_calcium_dynamics__Ca_i_bufc; // millimolar / millisecond
        const double var_sodium_potassium_pump_current__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump_current__K_mk = 1.0; // millimolar
        const double var_sodium_potassium_pump_current__P_NaK = 1.3620000000000001; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = var_potassium_dynamics__K_o * var_chaste_interface__sodium_dynamics__Na_i * var_sodium_potassium_pump_current__P_NaK / ((var_potassium_dynamics__K_o + var_sodium_potassium_pump_current__K_mk) * (var_chaste_interface__sodium_dynamics__Na_i + var_sodium_potassium_pump_current__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // picoA_per_picoF
        const double d_dt_chaste_interface_var_sodium_dynamics__Na_i = -1.0 * (3.0 * var_sodium_calcium_exchanger_current__i_NaCa + 3.0 * var_sodium_potassium_pump_current__i_NaK + var_fast_sodium_current__i_Na + var_sodium_background_current__i_b_Na) * var_membrane__Cm / (var_membrane__F * var_membrane__V_c); // millimolar / millisecond
        const double var_transient_outward_current_r_gate__r_inf = 1 / (1.0 + exp(3.3333333333333335 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_transient_outward_current_r_gate__tau_r = 0.80000000000000004 + 9.5 * exp(-0.88888888888888884 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)); // millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_r_gate__r = (-var_chaste_interface__transient_outward_current_r_gate__r + var_transient_outward_current_r_gate__r_inf) / var_transient_outward_current_r_gate__tau_r; // 1 / millisecond
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[3] * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // picoA_per_picoF
        const double d_dt_chaste_interface_var_potassium_dynamics__K_i = -1.0 * (-2.0 * var_sodium_potassium_pump_current__i_NaK + var_inward_rectifier_potassium_current__i_K1 + var_membrane__i_Stim + var_potassium_pump_current__i_p_K + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks + var_transient_outward_current__i_to) * var_membrane__Cm / (var_membrane__F * var_membrane__V_c); // millimolar / millisecond
        const double var_transient_outward_current_s_gate__s_gateparam = 28.0; // millivolt
        const double var_transient_outward_current_s_gate__s_inf = 1 / (1.0 + exp(0.20000000000000001 * var_chaste_interface__membrane__V + 0.20000000000000001 * var_transient_outward_current_s_gate__s_gateparam)); // dimensionless
        const double var_transient_outward_current_s_gate__tau_s_t1V = 67.0; // millivolt
        const double var_transient_outward_current_s_gate__tau_s_t1Vdenom = 1000.0; // millivolt_square
        const double var_transient_outward_current_s_gate__tau_s_term1 = 1000.0; // millisecond
        const double var_transient_outward_current_s_gate__tau_s_term2 = 0; // millisecond
        const double var_transient_outward_current_s_gate__tau_sconstant1 = 8.0; // millisecond
        const double var_transient_outward_current_s_gate__tau_s = var_transient_outward_current_s_gate__tau_s_term2 / (1.0 + exp(-4.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)) + var_transient_outward_current_s_gate__tau_s_term1 * exp(-pow((var_chaste_interface__membrane__V + var_transient_outward_current_s_gate__tau_s_t1V), 2) / var_transient_outward_current_s_gate__tau_s_t1Vdenom) + var_transient_outward_current_s_gate__tau_sconstant1; // millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_s_gate__s = (-var_chaste_interface__transient_outward_current_s_gate__s + var_transient_outward_current_s_gate__s_inf) / var_transient_outward_current_s_gate__tau_s; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__V = -var_L_type_Ca_current__i_CaL - var_calcium_background_current__i_b_Ca - var_calcium_pump_current__i_p_Ca - var_fast_sodium_current__i_Na - var_inward_rectifier_potassium_current__i_K1 - var_membrane__i_Stim - var_potassium_pump_current__i_p_K - var_rapid_time_dependent_potassium_current__i_Kr - var_slow_time_dependent_potassium_current__i_Ks - var_sodium_background_current__i_b_Na - var_sodium_calcium_exchanger_current__i_NaCa - var_sodium_potassium_pump_current__i_NaK - var_transient_outward_current__i_to; // millivolt / millisecond
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        mEvalF[1] = d_dt_chaste_interface_var_calcium_dynamics__Ca_i;
        mEvalF[2] = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_Xr1_gate__Xr1;
        mEvalF[3] = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_Xr2_gate__Xr2;
        mEvalF[4] = d_dt_chaste_interface_var_slow_time_dependent_potassium_current_Xs_gate__Xs;
        mEvalF[5] = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        mEvalF[6] = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        mEvalF[7] = d_dt_chaste_interface_var_fast_sodium_current_j_gate__j;
        mEvalF[8] = d_dt_chaste_interface_var_L_type_Ca_current_d_gate__d;
        mEvalF[9] = d_dt_chaste_interface_var_L_type_Ca_current_f_gate__f;
        mEvalF[10] = d_dt_chaste_interface_var_L_type_Ca_current_fCa_gate__fCa;
        mEvalF[11] = d_dt_chaste_interface_var_transient_outward_current_s_gate__s;
        mEvalF[12] = d_dt_chaste_interface_var_transient_outward_current_r_gate__r;
        mEvalF[13] = d_dt_chaste_interface_var_calcium_dynamics__Ca_SR;
        mEvalF[14] = d_dt_chaste_interface_var_calcium_dynamics__g;
        mEvalF[15] = d_dt_chaste_interface_var_sodium_dynamics__Na_i;
        mEvalF[16] = d_dt_chaste_interface_var_potassium_dynamics__K_i;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        rY[13] = y_save;
        
        
        y_save = rY[14];
        rY[14] = mYInit[14];
        mEvalF[14] = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        rY[14] = y_save;
        
        
        y_save = rY[15];
        rY[15] = mYInit[15];
        mEvalF[15] = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        rY[15] = y_save;
        
        
        y_save = rY[16];
        rY[16] = mYInit[16];
        mEvalF[16] = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        rY[16] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0002
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[2];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[3];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[4];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
        // Units: dimensionless; Initial value: 0.75
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[7];
        // Units: dimensionless; Initial value: 0.75
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[8];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[9];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_current_fCa_gate__fCa = rY[10];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
        // Units: dimensionless; Initial value: 0.3212
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__sodium_dynamics__Na_i = rY[15];
        // Units: millimolar; Initial value: 11.6
        double var_chaste_interface__potassium_dynamics__K_i = rY[16];
        // Units: millimolar; Initial value: 138.3
        
        
        // Mathematics
        const double var_calcium_background_current__g_bca = 0.00059199999999999997; // nanoS_per_picoF
        const double var_calcium_dynamics__Ca_o = 2.0; // millimolar
        const double var_calcium_pump_current__K_pCa = 0.00050000000000000001; // millimolar
        const double var_calcium_pump_current__g_pCa = 0.82499999999999996; // picoA_per_picoF
        const double var_calcium_pump_current__i_p_Ca = var_chaste_interface__calcium_dynamics__Ca_i * var_calcium_pump_current__g_pCa / (var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_pump_current__K_pCa); // picoA_per_picoF
        const double var_inward_rectifier_potassium_current__g_K1 = 5.4050000000000002; // nanoS_per_picoF
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_current__i_CaL = 4.0 * pow(var_membrane__F, 2) * (-0.34100000000000003 * var_calcium_dynamics__Ca_o + var_chaste_interface__calcium_dynamics__Ca_i * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * mParameters[0] * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_fCa_gate__fCa * var_chaste_interface__L_type_Ca_current_f_gate__f * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA_per_picoF
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_Stim = var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // picoA_per_picoF
        const double var_potassium_dynamics__K_o = 5.4000000000000004; // millimolar
        const double var_potassium_pump_current__g_pK = 0.0146; // nanoS_per_picoF
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Ca_o / var_chaste_interface__calcium_dynamics__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // picoA_per_picoF
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_potassium_dynamics__K_o / var_chaste_interface__potassium_dynamics__K_i) / var_membrane__F; // millivolt
        const double var_inward_rectifier_potassium_current__alpha_K1 = 0.10000000000000001 / (1.0 + exp(-12.0 + 0.059999999999999998 * var_chaste_interface__membrane__V - 0.059999999999999998 * var_reversal_potentials__E_K)); // dimensionless
        const double var_inward_rectifier_potassium_current__beta_K1 = (3.0 * exp(0.02 + 0.00020000000000000001 * var_chaste_interface__membrane__V - 0.00020000000000000001 * var_reversal_potentials__E_K) + exp(-1.0 + 0.10000000000000001 * var_chaste_interface__membrane__V - 0.10000000000000001 * var_reversal_potentials__E_K)) / (1.0 + exp(0.5 * var_reversal_potentials__E_K - 0.5 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_inward_rectifier_potassium_current__xK1_inf = var_inward_rectifier_potassium_current__alpha_K1 / (var_inward_rectifier_potassium_current__alpha_K1 + var_inward_rectifier_potassium_current__beta_K1); // dimensionless
        const double var_inward_rectifier_potassium_current__i_K1 = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier_potassium_current__g_K1 * var_inward_rectifier_potassium_current__xK1_inf; // picoA_per_picoF
        const double var_potassium_pump_current__i_p_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_pump_current__g_pK / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[2] * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2; // picoA_per_picoF
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_slow_time_dependent_potassium_current__g_Ks = 0.245; // nanoS_per_picoF
        const double var_sodium_background_current__g_bna = 0.00029; // nanoS_per_picoF
        const double var_sodium_calcium_exchanger_current__K_NaCa = 1000.0; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger_current__Km_Ca = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger_current__Km_Nai = 87.5; // millimolar
        const double var_sodium_calcium_exchanger_current__alpha = 2.5; // dimensionless
        const double var_sodium_calcium_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_reversal_potentials__P_kna * var_sodium_dynamics__Na_o + var_potassium_dynamics__K_o) / (var_reversal_potentials__P_kna * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i)) / var_membrane__F; // millivolt
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_sodium_dynamics__Na_o / var_chaste_interface__sodium_dynamics__Na_i) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * mParameters[1] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // picoA_per_picoF
        const double var_slow_time_dependent_potassium_current__i_Ks = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_time_dependent_potassium_current__g_Ks; // picoA_per_picoF
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__i_NaCa = (pow(var_chaste_interface__sodium_dynamics__Na_i, 3) * var_calcium_dynamics__Ca_o * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger_current__gamma / (var_membrane__R * var_membrane__T)) - pow(var_sodium_dynamics__Na_o, 3) * var_chaste_interface__calcium_dynamics__Ca_i * var_sodium_calcium_exchanger_current__alpha * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger_current__K_NaCa / ((1.0 + var_sodium_calcium_exchanger_current__K_sat * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_sodium_calcium_exchanger_current__Km_Nai, 3) + pow(var_sodium_dynamics__Na_o, 3)) * (var_calcium_dynamics__Ca_o + var_sodium_calcium_exchanger_current__Km_Ca)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump_current__K_mk = 1.0; // millimolar
        const double var_sodium_potassium_pump_current__P_NaK = 1.3620000000000001; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = var_potassium_dynamics__K_o * var_chaste_interface__sodium_dynamics__Na_i * var_sodium_potassium_pump_current__P_NaK / ((var_potassium_dynamics__K_o + var_sodium_potassium_pump_current__K_mk) * (var_chaste_interface__sodium_dynamics__Na_i + var_sodium_potassium_pump_current__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // picoA_per_picoF
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[3] * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // picoA_per_picoF
        d_dt_chaste_interface_var_membrane__V = -var_L_type_Ca_current__i_CaL - var_calcium_background_current__i_b_Ca - var_calcium_pump_current__i_p_Ca - var_fast_sodium_current__i_Na - var_inward_rectifier_potassium_current__i_K1 - var_membrane__i_Stim - var_potassium_pump_current__i_p_K - var_rapid_time_dependent_potassium_current__i_Kr - var_slow_time_dependent_potassium_current__i_Ks - var_sodium_background_current__i_b_Na - var_sodium_calcium_exchanger_current__i_NaCa - var_sodium_potassium_pump_current__i_NaK - var_transient_outward_current__i_to; // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane__V;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0002
            double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[2];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[3];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[4];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
            // Units: dimensionless; Initial value: 0.75
            double var_chaste_interface__fast_sodium_current_j_gate__j = rY[7];
            // Units: dimensionless; Initial value: 0.75
            double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[8];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[9];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__L_type_Ca_current_fCa_gate__fCa = rY[10];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
            // Units: dimensionless; Initial value: 0.3212
            double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__sodium_dynamics__Na_i = rY[15];
            // Units: millimolar; Initial value: 11.6
            double var_chaste_interface__potassium_dynamics__K_i = rY[16];
            // Units: millimolar; Initial value: 138.3
            
            const double var_x0 = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2);
            const double var_x1 = exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V);
            const double var_x2 = 1.0 + var_x1;
            const double var_x3 = 1 / var_x2;
            const double var_x4 = exp(-0.024332029034784559 * var_chaste_interface__membrane__V);
            const double var_x5 = 1.0 + 0.10000000000000001 * var_x4;
            const double var_x6 = 1 / var_x5;
            const double var_x7 = var_x4 * var_chaste_interface__calcium_dynamics__Ca_i;
            const double var_x8 = exp(0.013101861787960915 * var_chaste_interface__membrane__V);
            const double var_x9 = var_x8 * pow(var_chaste_interface__sodium_dynamics__Na_i, 3);
            const double var_x10 = var_x6 * (166917.71917862206 * var_x7 + 0.026203723575921829 * var_x9);
            const double var_x11 = 1 / var_chaste_interface__potassium_dynamics__K_i;
            const double var_x12 = log(5.4000000000000004 * var_x11);
            const double var_x13 = exp(-12.0 + 0.059999999999999998 * var_chaste_interface__membrane__V - 1.6028256395817388 * var_x12);
            const double var_x14 = 1.0 + var_x13;
            const double var_x15 = 1 / var_x14;
            const double var_x16 = exp(13.356880329847826 * var_x12 - 0.5 * var_chaste_interface__membrane__V);
            const double var_x17 = 1.0 + var_x16;
            const double var_x18 = 1 / var_x17;
            const double var_x19 = exp(0.02 + 0.00020000000000000001 * var_chaste_interface__membrane__V - 0.0053427521319391299 * var_x12);
            const double var_x20 = 0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x21 = exp(-1.0 + var_x20 - 2.6713760659695653 * var_x12);
            const double var_x22 = var_x21 + 3.0 * var_x19;
            const double var_x23 = 0.10000000000000001 * var_x15 + var_x18 * var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = var_x15 * var_x24;
            const double var_x26 = mParameters[3] * var_chaste_interface__transient_outward_current_r_gate__r;
            const double var_x27 = var_x26 * var_chaste_interface__transient_outward_current_s_gate__s;
            const double var_x28 = 26.713760659695652 * var_x12;
            const double var_x29 = -var_x28 + var_chaste_interface__membrane__V;
            const double var_x30 = var_x1 * var_x29 / pow(var_x2, 2);
            const double var_x31 = 2.0 * var_x9 - 6860000.0 * var_x7;
            const double var_x32 = var_x31 * var_x4 / pow(var_x5, 2);
            const double var_x33 = mParameters[2] * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2;
            const double var_x34 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
            const double var_x35 = var_x34 * mParameters[1] * var_chaste_interface__fast_sodium_current_j_gate__j;
            const double var_x36 = var_x35 * var_chaste_interface__fast_sodium_current_h_gate__h;
            const double var_x37 = var_x13 / pow(var_x14, 2);
            const double var_x38 = var_x24 * var_x29;
            const double var_x39 = var_x37 * var_x38;
            const double var_x40 = var_x16 * var_x22 / pow(var_x17, 2);
            const double var_x41 = 0.0060000000000000001 * var_x37 - 0.5 * var_x40 - var_x18 * (0.10000000000000001 * var_x21 + 0.00060000000000000006 * var_x19);
            const double var_x42 = var_x15 * var_x29 / pow(var_x23, 2);
            const double var_x43 = 0.54050000000000009 * var_x42;
            const double var_x44 = 1 / (40.0 + var_chaste_interface__sodium_dynamics__Na_i);
            const double var_x45 = exp(-0.037433890822745473 * var_chaste_interface__membrane__V);
            const double var_x46 = exp(-0.0037433890822745472 * var_chaste_interface__membrane__V);
            const double var_x47 = 1.0 + 0.035299999999999998 * var_x45 + 0.1245 * var_x46;
            const double var_x48 = var_x44 * (0.001321416346042915 * var_x45 + 0.00046605194074318115 * var_x46) * var_chaste_interface__sodium_dynamics__Na_i / pow(var_x47, 2);
            const double var_x49 = exp(0.074867781645490947 * var_chaste_interface__membrane__V);
            const double var_x50 = -1.0 + var_x49;
            const double var_x51 = 1 / var_x50;
            const double var_x52 = var_x49 * var_chaste_interface__calcium_dynamics__Ca_i;
            const double var_x53 = -0.68200000000000005 + var_x52;
            const double var_x54 = var_x51 * var_x53 * mParameters[0] * var_chaste_interface__L_type_Ca_current_fCa_gate__fCa * var_chaste_interface__L_type_Ca_current_f_gate__f;
            const double var_x55 = 14447.286958825251 * var_x54;
            const double var_x56 = var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__membrane__V;
            const double var_x57 = var_x56 * mParameters[0] * var_chaste_interface__L_type_Ca_current_f_gate__f;
            const double var_x58 = var_x49 * var_x53 * var_x57 * var_chaste_interface__L_type_Ca_current_fCa_gate__fCa / pow(var_x50, 2);
            const double var_x59 = var_x51 * var_x56 * mParameters[0] * var_chaste_interface__L_type_Ca_current_fCa_gate__fCa;
            const double var_x60 = var_x59 * var_chaste_interface__L_type_Ca_current_f_gate__f;
            const double var_x61 = var_x52 * var_x60;
            
            partialF = -0.00088199999999999997 - var_x27 - var_x36 + 1081.6363254030778 * var_x58 + 0.03243 * var_x39 - 0.245 * var_x0 - 0.0146 * var_x3 - 0.0024414715719063545 * var_x30 - 1081.6363254030778 * var_x61 - 8.6662202299424464e-5 * var_x10 - 0.54050000000000009 * var_x25 - 1.1491875 * var_x48 - 2.1086672225679691e-7 * var_x32 - 1.0 * var_x33 - var_x41 * var_x43 - var_x55 * var_chaste_interface__L_type_Ca_current_d_gate__d;
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0002
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[8];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[9];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_current_fCa_gate__fCa = rY[10];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__calcium_dynamics__Ca_SR = rY[13];
        // Units: millimolar; Initial value: 0.2
        double var_chaste_interface__calcium_dynamics__g = rY[14];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__sodium_dynamics__Na_i = rY[15];
        // Units: millimolar; Initial value: 11.6
        
        
        // Mathematics
        const double var_calcium_background_current__g_bca = 0.00059199999999999997; // nanoS_per_picoF
        const double var_calcium_dynamics__Buf_c = 0.14999999999999999; // millimolar
        const double var_calcium_dynamics__Ca_o = 2.0; // millimolar
        const double var_calcium_dynamics__K_buf_c = 0.001; // millimolar
        const double var_calcium_dynamics__Ca_i_bufc = 1 / (1.0 + var_calcium_dynamics__Buf_c * var_calcium_dynamics__K_buf_c / pow((var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_dynamics__K_buf_c), 2)); // dimensionless
        const double var_calcium_dynamics__K_up = 0.00025000000000000001; // millimolar
        const double var_calcium_dynamics__V_leak = 8.0000000000000007e-5; // per_millisecond
        const double var_calcium_dynamics__Vmax_up = 0.00042499999999999998; // millimolar_per_millisecond
        const double var_calcium_dynamics__a_rel = 0.016463999999999999; // millimolar_per_millisecond
        const double var_calcium_dynamics__b_rel = 0.25; // millimolar
        const double var_calcium_dynamics__c_rel = 0.0082319999999999997; // millimolar_per_millisecond
        const double var_calcium_dynamics__i_leak = (-var_chaste_interface__calcium_dynamics__Ca_i + var_chaste_interface__calcium_dynamics__Ca_SR) * var_calcium_dynamics__V_leak; // millimolar_per_millisecond
        const double var_calcium_dynamics__i_rel = (pow(var_chaste_interface__calcium_dynamics__Ca_SR, 2) * var_calcium_dynamics__a_rel / (pow(var_chaste_interface__calcium_dynamics__Ca_SR, 2) + pow(var_calcium_dynamics__b_rel, 2)) + var_calcium_dynamics__c_rel) * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__calcium_dynamics__g; // millimolar_per_millisecond
        const double var_calcium_dynamics__i_up = var_calcium_dynamics__Vmax_up / (1.0 + pow(var_calcium_dynamics__K_up, 2) / pow(var_chaste_interface__calcium_dynamics__Ca_i, 2)); // millimolar_per_millisecond
        const double var_calcium_pump_current__K_pCa = 0.00050000000000000001; // millimolar
        const double var_calcium_pump_current__g_pCa = 0.82499999999999996; // picoA_per_picoF
        const double var_calcium_pump_current__i_p_Ca = var_chaste_interface__calcium_dynamics__Ca_i * var_calcium_pump_current__g_pCa / (var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_pump_current__K_pCa); // picoA_per_picoF
        const double var_membrane__Cm = 0.185; // microF
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_current__i_CaL = 4.0 * pow(var_membrane__F, 2) * (-0.34100000000000003 * var_calcium_dynamics__Ca_o + var_chaste_interface__calcium_dynamics__Ca_i * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * mParameters[0] * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_fCa_gate__fCa * var_chaste_interface__L_type_Ca_current_f_gate__f * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA_per_picoF
        const double var_membrane__V_c = 0.016403999999999998; // micrometre3
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Ca_o / var_chaste_interface__calcium_dynamics__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__K_NaCa = 1000.0; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger_current__Km_Ca = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger_current__Km_Nai = 87.5; // millimolar
        const double var_sodium_calcium_exchanger_current__alpha = 2.5; // dimensionless
        const double var_sodium_calcium_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_sodium_calcium_exchanger_current__i_NaCa = (pow(var_chaste_interface__sodium_dynamics__Na_i, 3) * var_calcium_dynamics__Ca_o * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger_current__gamma / (var_membrane__R * var_membrane__T)) - pow(var_sodium_dynamics__Na_o, 3) * var_chaste_interface__calcium_dynamics__Ca_i * var_sodium_calcium_exchanger_current__alpha * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger_current__K_NaCa / ((1.0 + var_sodium_calcium_exchanger_current__K_sat * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_sodium_calcium_exchanger_current__Km_Nai, 3) + pow(var_sodium_dynamics__Na_o, 3)) * (var_calcium_dynamics__Ca_o + var_sodium_calcium_exchanger_current__Km_Ca)); // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_i = (-var_calcium_dynamics__i_up - 0.5 * (-2.0 * var_sodium_calcium_exchanger_current__i_NaCa + var_L_type_Ca_current__i_CaL + var_calcium_background_current__i_b_Ca + var_calcium_pump_current__i_p_Ca) * var_membrane__Cm / (var_membrane__F * var_membrane__V_c) + var_calcium_dynamics__i_leak + var_calcium_dynamics__i_rel) * var_calcium_dynamics__Ca_i_bufc; // millimolar / millisecond

        return d_dt_chaste_interface_var_calcium_dynamics__Ca_i;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0002
            double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[8];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[9];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__L_type_Ca_current_fCa_gate__fCa = rY[10];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__calcium_dynamics__Ca_SR = rY[13];
            // Units: millimolar; Initial value: 0.2
            double var_chaste_interface__calcium_dynamics__g = rY[14];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__sodium_dynamics__Na_i = rY[15];
            // Units: millimolar; Initial value: 11.6
            
            const double var_x4 = exp(-0.024332029034784559 * var_chaste_interface__membrane__V);
            const double var_x5 = 1.0 + 0.10000000000000001 * var_x4;
            const double var_x6 = 1 / var_x5;
            const double var_x7 = var_x4 * var_chaste_interface__calcium_dynamics__Ca_i;
            const double var_x8 = exp(0.013101861787960915 * var_chaste_interface__membrane__V);
            const double var_x9 = var_x8 * pow(var_chaste_interface__sodium_dynamics__Na_i, 3);
            const double var_x31 = 2.0 * var_x9 - 6860000.0 * var_x7;
            const double var_x49 = exp(0.074867781645490947 * var_chaste_interface__membrane__V);
            const double var_x50 = -1.0 + var_x49;
            const double var_x51 = 1 / var_x50;
            const double var_x52 = var_x49 * var_chaste_interface__calcium_dynamics__Ca_i;
            const double var_x53 = -0.68200000000000005 + var_x52;
            const double var_x54 = var_x51 * var_x53 * mParameters[0] * var_chaste_interface__L_type_Ca_current_fCa_gate__fCa * var_chaste_interface__L_type_Ca_current_f_gate__f;
            const double var_x56 = var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__membrane__V;
            const double var_x59 = var_x51 * var_x56 * mParameters[0] * var_chaste_interface__L_type_Ca_current_fCa_gate__fCa;
            const double var_x60 = var_x59 * var_chaste_interface__L_type_Ca_current_f_gate__f;
            const double var_x62 = 0.00050000000000000001 + var_chaste_interface__calcium_dynamics__Ca_i;
            const double var_x63 = 1 / var_x62;
            const double var_x64 = 1 / var_chaste_interface__calcium_dynamics__Ca_i;
            const double var_x65 = var_chaste_interface__calcium_dynamics__Ca_i / pow(var_x62, 2);
            const double var_x66 = var_x4 * var_x6;
            const double var_x67 = var_x49 * var_x60;
            const double var_x94 = 0.84433916144939192 * var_x54;
            const double var_x95 = 0.001 + var_chaste_interface__calcium_dynamics__Ca_i;
            const double var_x96 = 1.0 + 0.00014999999999999999 / pow(var_x95, 2);
            const double var_x97 = 1 / var_x96;
            const double var_x98 = var_x97;
            const double var_x99 = 4.8215267695658011e-5 * var_x63;
            const double var_x100 = 1.0 + 6.2499999999999997e-8 / pow(var_chaste_interface__calcium_dynamics__Ca_i, 2);
            const double var_x101 = 5.3124999999999997e-11 / (pow(var_x100, 2) * pow(var_chaste_interface__calcium_dynamics__Ca_i, 3));
            const double var_x102 = 8.0000000000000007e-5 * var_chaste_interface__calcium_dynamics__Ca_SR;
            const double var_x103 = 8.0000000000000007e-5 * var_chaste_interface__calcium_dynamics__Ca_i;
            const double var_x104 = 0.00042499999999999998 / var_x100;
            const double var_x105 = pow(var_chaste_interface__calcium_dynamics__Ca_SR, 2);
            const double var_x106 = 0.0625 + var_x105;
            const double var_x107 = 1 / var_x106;
            const double var_x108 = 0.016463999999999999 * var_x105 * var_x107;
            const double var_x109 = 0.0082319999999999997 + var_x108;
            const double var_x110 = var_x109 * var_chaste_interface__calcium_dynamics__g;
            const double var_x111 = var_x110 * var_chaste_interface__L_type_Ca_current_d_gate__d;
            
            partialF = var_x98 * (-8.0000000000000007e-5 - var_x101 - var_x99 + 4.8215267695658011e-5 * var_x65 - 0.069488744729986562 * var_x66 - 0.84433916144939192 * var_x67 - 4.6212277808973232e-7 * var_x64) + 0.00029999999999999997 * (var_x102 + var_x111 - var_x103 - var_x104 + 4.6212277808973232e-7 * log(2.0 * var_x64) - 3.4598107243429746e-8 * var_chaste_interface__membrane__V - var_x56 * var_x94 - var_x99 * var_chaste_interface__calcium_dynamics__Ca_i + 1.0129554625362472e-8 * var_x31 * var_x6) / (pow(var_x95, 3) * pow(var_x96, 2));
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[2];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__alpha_xr1 = 450.0 / (1.0 + exp(-4.5 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__beta_xr1 = 6.0 / (1.0 + exp(2.6086956521739131 + 0.086956521739130432 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__tau_xr1 = var_rapid_time_dependent_potassium_current_Xr1_gate__alpha_xr1 * var_rapid_time_dependent_potassium_current_Xr1_gate__beta_xr1; // millisecond
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__xr1_inf = 1 / (1.0 + exp(-3.7142857142857144 - 0.14285714285714285 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = (-var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 + var_rapid_time_dependent_potassium_current_Xr1_gate__xr1_inf) / var_rapid_time_dependent_potassium_current_Xr1_gate__tau_xr1; // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_Xr1_gate__Xr1;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            
            const double var_x116 = -0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x117 = exp(-4.5 + var_x116);
            const double var_x118 = 1.0 + var_x117;
            const double var_x123 = exp(2.6086956521739131 + 0.086956521739130432 * var_chaste_interface__membrane__V);
            const double var_x124 = 0.00037037037037037035 + 0.00037037037037037035 * var_x123;
            const double var_x125 = var_x118 * var_x124;
            
            partialF = -var_x125;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[3];
        // Units: dimensionless; Initial value: 1.0
        
        
        // Mathematics
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__alpha_xr2 = 3.0 / (1.0 + exp(-3.0 - 0.050000000000000003 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__beta_xr2 = 1.1200000000000001 / (1.0 + exp(-3.0 + 0.050000000000000003 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__tau_xr2 = var_rapid_time_dependent_potassium_current_Xr2_gate__alpha_xr2 * var_rapid_time_dependent_potassium_current_Xr2_gate__beta_xr2; // millisecond
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__xr2_inf = 1 / (1.0 + exp(3.6666666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = (-var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 + var_rapid_time_dependent_potassium_current_Xr2_gate__xr2_inf) / var_rapid_time_dependent_potassium_current_Xr2_gate__tau_xr2; // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_Xr2_gate__Xr2;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            
            const double var_x126 = 0.050000000000000003 * var_chaste_interface__membrane__V;
            const double var_x127 = -var_x126;
            const double var_x128 = exp(-3.0 + var_x127);
            const double var_x129 = 1.0 + var_x128;
            const double var_x133 = exp(-3.0 + var_x126);
            const double var_x134 = 0.29761904761904762 + 0.29761904761904762 * var_x133;
            const double var_x135 = var_x129 * var_x134;
            
            partialF = -var_x135;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[4];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_slow_time_dependent_potassium_current_Xs_gate__alpha_xs = 1100.0 / sqrt(1.0 + exp(-1.6666666666666667 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_time_dependent_potassium_current_Xs_gate__beta_xs = 1 / (1.0 + exp(-3.0 + 0.050000000000000003 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_time_dependent_potassium_current_Xs_gate__tau_xs = var_slow_time_dependent_potassium_current_Xs_gate__alpha_xs * var_slow_time_dependent_potassium_current_Xs_gate__beta_xs; // millisecond
        const double var_slow_time_dependent_potassium_current_Xs_gate__xs_inf = 1 / (1.0 + exp(-0.35714285714285715 - 0.071428571428571425 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_Xs_gate__Xs = (-var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs + var_slow_time_dependent_potassium_current_Xs_gate__xs_inf) / var_slow_time_dependent_potassium_current_Xs_gate__tau_xs; // 1 / millisecond

        return d_dt_chaste_interface_var_slow_time_dependent_potassium_current_Xs_gate__Xs;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            
            const double var_x126 = 0.050000000000000003 * var_chaste_interface__membrane__V;
            const double var_x133 = exp(-3.0 + var_x126);
            const double var_x136 = -0.16666666666666666 * var_chaste_interface__membrane__V;
            const double var_x137 = exp(-1.6666666666666667 + var_x136);
            const double var_x138 = sqrt(1.0 + var_x137);
            const double var_x142 = 1.0 + var_x133;
            const double var_x143 = var_x138 * var_x142;
            
            partialF = -0.00090909090909090909 * var_x143;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_fast_sodium_current_m_gate__alpha_m = 1 / (1.0 + exp(-12.0 - 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_fast_sodium_current_m_gate__beta_m = 0.10000000000000001 / (1.0 + exp(7.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)) + 0.10000000000000001 / (1.0 + exp(-0.25 + 0.0050000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_fast_sodium_current_m_gate__m_inf = 1 / pow((1.0 + exp(-6.2967884828349945 - 0.11074197120708749 * var_chaste_interface__membrane__V)), 2); // dimensionless
        const double var_fast_sodium_current_m_gate__tau_m = var_fast_sodium_current_m_gate__alpha_m * var_fast_sodium_current_m_gate__beta_m; // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = (-var_chaste_interface__fast_sodium_current_m_gate__m + var_fast_sodium_current_m_gate__m_inf) / var_fast_sodium_current_m_gate__tau_m; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            
            const double var_x144 = 0.20000000000000001 * var_chaste_interface__membrane__V;
            const double var_x145 = exp(7.0 + var_x144);
            const double var_x146 = 1.0 + var_x145;
            const double var_x147 = 1 / var_x146;
            const double var_x148 = exp(-0.25 + 0.0050000000000000001 * var_chaste_interface__membrane__V);
            const double var_x149 = 1.0 + var_x148;
            const double var_x150 = 1 / var_x149;
            const double var_x151 = 1 / (0.10000000000000001 * var_x147 + 0.10000000000000001 * var_x150);
            const double var_x155 = exp(-12.0 - var_x144);
            const double var_x156 = 1.0 + var_x155;
            const double var_x157 = var_x151 * var_x156;
            
            partialF = -1.0 * var_x157;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
        // Units: dimensionless; Initial value: 0.75
        
        
        // Mathematics
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (0.057000000000000002 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0)); // per_millisecond
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (310000.0 * exp(0.34849999999999998 * var_chaste_interface__membrane__V) + 2.7000000000000002 * exp(0.079000000000000001 * var_chaste_interface__membrane__V)) : (5.9230769230769234 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_h_gate__h_inf = 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__membrane__V)), 2); // dimensionless
        const double var_fast_sodium_current_h_gate__tau_h = 1 / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h); // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = (-var_chaste_interface__fast_sodium_current_h_gate__h + var_fast_sodium_current_h_gate__h_inf) / var_fast_sodium_current_h_gate__tau_h; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            
            const double var_x161 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V);
            const double var_x162 = var_chaste_interface__membrane__V < -40.0;
            const double var_x163 = exp(0.34849999999999998 * var_chaste_interface__membrane__V);
            const double var_x164 = exp(0.079000000000000001 * var_chaste_interface__membrane__V);
            const double var_x165 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V);
            const double var_x166 = 1.0 + var_x165;
            const double var_x167 = ((var_x162) ? (0.057000000000000002 * var_x161) : (0));
            const double var_x168 = ((var_x162) ? (310000.0 * var_x163 + 2.7000000000000002 * var_x164) : (5.9230769230769234 / var_x166));
            
            partialF = -var_x167 - var_x168;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[7];
        // Units: dimensionless; Initial value: 0.75
        
        
        // Mathematics
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__membrane__V) * (-25428.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 6.9480000000000002e-6 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))) : (0)); // per_millisecond
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (0.024240000000000001 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (0.59999999999999998 * exp(0.057000000000000002 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_j_gate__j_inf = 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__membrane__V)), 2); // dimensionless
        const double var_fast_sodium_current_j_gate__tau_j = 1 / (var_fast_sodium_current_j_gate__alpha_j + var_fast_sodium_current_j_gate__beta_j); // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_j_gate__j = (-var_chaste_interface__fast_sodium_current_j_gate__j + var_fast_sodium_current_j_gate__j_inf) / var_fast_sodium_current_j_gate__tau_j; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current_j_gate__j;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            
            const double var_x20 = 0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x162 = var_chaste_interface__membrane__V < -40.0;
            const double var_x170 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V);
            const double var_x171 = 1.0 + var_x170;
            const double var_x172 = exp(-0.01052 * var_chaste_interface__membrane__V);
            const double var_x173 = var_x172 / var_x171;
            const double var_x174 = exp(-3.2000000000000002 - var_x20);
            const double var_x175 = 1.0 + var_x174;
            const double var_x176 = exp(0.057000000000000002 * var_chaste_interface__membrane__V);
            const double var_x177 = var_x176 / var_x175;
            const double var_x178 = exp(0.24440000000000001 * var_chaste_interface__membrane__V);
            const double var_x179 = exp(-0.043909999999999998 * var_chaste_interface__membrane__V);
            const double var_x180 = -25428.0 * var_x178 - 6.9480000000000002e-6 * var_x179;
            const double var_x181 = exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V);
            const double var_x182 = 1.0 + var_x181;
            const double var_x183 = 1 / var_x182;
            const double var_x184 = var_x180 * var_x183;
            const double var_x185 = 37.780000000000001 + var_chaste_interface__membrane__V;
            const double var_x186 = ((var_x162) ? (0.024240000000000001 * var_x173) : (0.59999999999999998 * var_x177));
            const double var_x187 = ((var_x162) ? (var_x184 * var_x185) : (0));
            
            partialF = -var_x186 - var_x187;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[8];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_L_type_Ca_current_d_gate__alpha_d = 0.25 + 1.3999999999999999 / (1.0 + exp(-2.6923076923076925 - 0.076923076923076927 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_d_gate__beta_d = 1.3999999999999999 / (1.0 + exp(1.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_d_gate__d_inf = 1 / (1.0 + exp(-0.66666666666666663 - 0.13333333333333333 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_d_gate__gamma_d = 1 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__membrane__V)); // millisecond
        const double var_L_type_Ca_current_d_gate__tau_d = var_L_type_Ca_current_d_gate__alpha_d * var_L_type_Ca_current_d_gate__beta_d + var_L_type_Ca_current_d_gate__gamma_d; // millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current_d_gate__d = (-var_chaste_interface__L_type_Ca_current_d_gate__d + var_L_type_Ca_current_d_gate__d_inf) / var_L_type_Ca_current_d_gate__tau_d; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_current_d_gate__d;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            
            const double var_x126 = 0.050000000000000003 * var_chaste_interface__membrane__V;
            const double var_x127 = -var_x126;
            const double var_x144 = 0.20000000000000001 * var_chaste_interface__membrane__V;
            const double var_x188 = exp(2.5 + var_x127);
            const double var_x189 = 1.0 + var_x188;
            const double var_x190 = 1 / var_x189;
            const double var_x191 = exp(1.0 + var_x144);
            const double var_x192 = 1.0 + var_x191;
            const double var_x193 = 1 / var_x192;
            const double var_x194 = exp(-2.6923076923076925 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x195 = 1.0 + var_x194;
            const double var_x196 = 0.25 + 1.3999999999999999 / var_x195;
            const double var_x197 = var_x193 * var_x196;
            const double var_x200 = 1 / (var_x190 + 1.3999999999999999 * var_x197);
            
            partialF = -var_x200;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__L_type_Ca_current_f_gate__f = rY[9];
        // Units: dimensionless; Initial value: 1.0
        
        
        // Mathematics
        const double var_L_type_Ca_current_f_gate__f_inf = 1 / (1.0 + exp(2.8571428571428572 + 0.14285714285714285 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_f_gate__tau_f = 80.0 + 165.0 / (1.0 + exp(2.5 - 0.10000000000000001 * var_chaste_interface__membrane__V)) + 1125.0 * exp(-3.0375000000000001 * pow((1 + 0.037037037037037035 * var_chaste_interface__membrane__V), 2)); // millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current_f_gate__f = (-var_chaste_interface__L_type_Ca_current_f_gate__f + var_L_type_Ca_current_f_gate__f_inf) / var_L_type_Ca_current_f_gate__tau_f; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_current_f_gate__f;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            
            const double var_x116 = -0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x201 = exp(2.5 + var_x116);
            const double var_x202 = 1.0 + var_x201;
            const double var_x203 = 1 / var_x202;
            const double var_x204 = exp(-3.0375000000000001 * pow((1 + 0.037037037037037035 * var_chaste_interface__membrane__V), 2));
            const double var_x207 = 1125.0 * var_x204;
            const double var_x208 = 1 / (80.0 + var_x207 + 165.0 * var_x203);
            
            partialF = -var_x208;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0002
        double var_chaste_interface__L_type_Ca_current_fCa_gate__fCa = rY[10];
        // Units: dimensionless; Initial value: 1.0
        
        
        // Mathematics
        const double var_L_type_Ca_current_fCa_gate__tau_fCa = 2.0; // millisecond
        const double var_L_type_Ca_current_fCa_gate__alpha_fCa = 1 / (1.0 + 8.034023767017109e+27 * pow(var_chaste_interface__calcium_dynamics__Ca_i, 8)); // dimensionless
        const double var_L_type_Ca_current_fCa_gate__beta_fCa = 0.10000000000000001 / (1.0 + exp(-5.0 + 10000.0 * var_chaste_interface__calcium_dynamics__Ca_i)); // dimensionless
        const double var_L_type_Ca_current_fCa_gate__gama_fCa = 0.20000000000000001 / (1.0 + exp(-0.9375 + 1250.0 * var_chaste_interface__calcium_dynamics__Ca_i)); // dimensionless
        const double var_L_type_Ca_current_fCa_gate__fCa_inf = 0.15753424657534248 + 0.68493150684931503 * var_L_type_Ca_current_fCa_gate__alpha_fCa + 0.68493150684931503 * var_L_type_Ca_current_fCa_gate__beta_fCa + 0.68493150684931503 * var_L_type_Ca_current_fCa_gate__gama_fCa; // dimensionless
        const double var_L_type_Ca_current_fCa_gate__d_fCa = (-var_chaste_interface__L_type_Ca_current_fCa_gate__fCa + var_L_type_Ca_current_fCa_gate__fCa_inf) / var_L_type_Ca_current_fCa_gate__tau_fCa; // per_millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current_fCa_gate__fCa = (((var_chaste_interface__membrane__V > -60.0) && (var_chaste_interface__L_type_Ca_current_fCa_gate__fCa < var_L_type_Ca_current_fCa_gate__fCa_inf)) ? (0) : (var_L_type_Ca_current_fCa_gate__d_fCa)); // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_current_fCa_gate__fCa;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0002
            double var_chaste_interface__L_type_Ca_current_fCa_gate__fCa = rY[10];
            // Units: dimensionless; Initial value: 1.0
            
            const double var_x209 = var_chaste_interface__membrane__V > -60.0;
            const double var_x210 = exp(-5.0 + 10000.0 * var_chaste_interface__calcium_dynamics__Ca_i);
            const double var_x211 = 1.0 + var_x210;
            const double var_x212 = exp(-0.9375 + 1250.0 * var_chaste_interface__calcium_dynamics__Ca_i);
            const double var_x213 = 1.0 + var_x212;
            const double var_x214 = pow(var_chaste_interface__calcium_dynamics__Ca_i, 8);
            const double var_x215 = (var_x209) && (var_chaste_interface__L_type_Ca_current_fCa_gate__fCa < 0.15753424657534248 + 0.068493150684931517 / var_x211 + 0.13698630136986303 / var_x213 + 0.68493150684931503 / (1.0 + 8.034023767017109e+27 * var_x214));
            
            partialF = ((var_x215) ? (0) : (-0.5));
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
        // Units: dimensionless; Initial value: 0.3212
        
        
        // Mathematics
        const double var_transient_outward_current_s_gate__s_gateparam = 28.0; // millivolt
        const double var_transient_outward_current_s_gate__s_inf = 1 / (1.0 + exp(0.20000000000000001 * var_chaste_interface__membrane__V + 0.20000000000000001 * var_transient_outward_current_s_gate__s_gateparam)); // dimensionless
        const double var_transient_outward_current_s_gate__tau_s_t1V = 67.0; // millivolt
        const double var_transient_outward_current_s_gate__tau_s_t1Vdenom = 1000.0; // millivolt_square
        const double var_transient_outward_current_s_gate__tau_s_term1 = 1000.0; // millisecond
        const double var_transient_outward_current_s_gate__tau_s_term2 = 0; // millisecond
        const double var_transient_outward_current_s_gate__tau_sconstant1 = 8.0; // millisecond
        const double var_transient_outward_current_s_gate__tau_s = var_transient_outward_current_s_gate__tau_s_term2 / (1.0 + exp(-4.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)) + var_transient_outward_current_s_gate__tau_s_term1 * exp(-pow((var_chaste_interface__membrane__V + var_transient_outward_current_s_gate__tau_s_t1V), 2) / var_transient_outward_current_s_gate__tau_s_t1Vdenom) + var_transient_outward_current_s_gate__tau_sconstant1; // millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_s_gate__s = (-var_chaste_interface__transient_outward_current_s_gate__s + var_transient_outward_current_s_gate__s_inf) / var_transient_outward_current_s_gate__tau_s; // 1 / millisecond

        return d_dt_chaste_interface_var_transient_outward_current_s_gate__s;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            
            const double var_x218 = exp(-4.4889999999999999 * pow((1 + 0.014925373134328358 * var_chaste_interface__membrane__V), 2));
            const double var_x219 = 1 / (8.0 + 1000.0 * var_x218);
            
            partialF = -var_x219;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_transient_outward_current_r_gate__r_inf = 1 / (1.0 + exp(3.3333333333333335 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_transient_outward_current_r_gate__tau_r = 0.80000000000000004 + 9.5 * exp(-0.88888888888888884 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)); // millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_r_gate__r = (-var_chaste_interface__transient_outward_current_r_gate__r + var_transient_outward_current_r_gate__r_inf) / var_transient_outward_current_r_gate__tau_r; // 1 / millisecond

        return d_dt_chaste_interface_var_transient_outward_current_r_gate__r;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            
            const double var_x222 = exp(-0.88888888888888884 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2));
            const double var_x223 = 1 / (0.80000000000000004 + 9.5 * var_x222);
            
            partialF = -var_x223;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0002
        double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[8];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__calcium_dynamics__Ca_SR = rY[13];
        // Units: millimolar; Initial value: 0.2
        double var_chaste_interface__calcium_dynamics__g = rY[14];
        // Units: dimensionless; Initial value: 1.0
        
        
        // Mathematics
        const double var_calcium_dynamics__Buf_sr = 10.0; // millimolar
        const double var_calcium_dynamics__K_buf_sr = 0.29999999999999999; // millimolar
        const double var_calcium_dynamics__Ca_sr_bufsr = 1 / (1.0 + var_calcium_dynamics__Buf_sr * var_calcium_dynamics__K_buf_sr / pow((var_chaste_interface__calcium_dynamics__Ca_SR + var_calcium_dynamics__K_buf_sr), 2)); // dimensionless
        const double var_calcium_dynamics__K_up = 0.00025000000000000001; // millimolar
        const double var_calcium_dynamics__V_leak = 8.0000000000000007e-5; // per_millisecond
        const double var_calcium_dynamics__V_sr = 0.0010939999999999999; // micrometre3
        const double var_calcium_dynamics__Vmax_up = 0.00042499999999999998; // millimolar_per_millisecond
        const double var_calcium_dynamics__a_rel = 0.016463999999999999; // millimolar_per_millisecond
        const double var_calcium_dynamics__b_rel = 0.25; // millimolar
        const double var_calcium_dynamics__c_rel = 0.0082319999999999997; // millimolar_per_millisecond
        const double var_calcium_dynamics__i_leak = (-var_chaste_interface__calcium_dynamics__Ca_i + var_chaste_interface__calcium_dynamics__Ca_SR) * var_calcium_dynamics__V_leak; // millimolar_per_millisecond
        const double var_calcium_dynamics__i_rel = (pow(var_chaste_interface__calcium_dynamics__Ca_SR, 2) * var_calcium_dynamics__a_rel / (pow(var_chaste_interface__calcium_dynamics__Ca_SR, 2) + pow(var_calcium_dynamics__b_rel, 2)) + var_calcium_dynamics__c_rel) * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__calcium_dynamics__g; // millimolar_per_millisecond
        const double var_calcium_dynamics__i_up = var_calcium_dynamics__Vmax_up / (1.0 + pow(var_calcium_dynamics__K_up, 2) / pow(var_chaste_interface__calcium_dynamics__Ca_i, 2)); // millimolar_per_millisecond
        const double var_membrane__V_c = 0.016403999999999998; // micrometre3
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_SR = (-var_calcium_dynamics__i_leak - var_calcium_dynamics__i_rel + var_calcium_dynamics__i_up) * var_calcium_dynamics__Ca_sr_bufsr * var_membrane__V_c / var_calcium_dynamics__V_sr; // millimolar / millisecond

        return d_dt_chaste_interface_var_calcium_dynamics__Ca_SR;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0002
            double var_chaste_interface__L_type_Ca_current_d_gate__d = rY[8];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__calcium_dynamics__Ca_SR = rY[13];
            // Units: millimolar; Initial value: 0.2
            double var_chaste_interface__calcium_dynamics__g = rY[14];
            // Units: dimensionless; Initial value: 1.0
            
            const double var_x100 = 1.0 + 6.2499999999999997e-8 / pow(var_chaste_interface__calcium_dynamics__Ca_i, 2);
            const double var_x102 = 8.0000000000000007e-5 * var_chaste_interface__calcium_dynamics__Ca_SR;
            const double var_x103 = 8.0000000000000007e-5 * var_chaste_interface__calcium_dynamics__Ca_i;
            const double var_x104 = 0.00042499999999999998 / var_x100;
            const double var_x105 = pow(var_chaste_interface__calcium_dynamics__Ca_SR, 2);
            const double var_x106 = 0.0625 + var_x105;
            const double var_x107 = 1 / var_x106;
            const double var_x108 = 0.016463999999999999 * var_x105 * var_x107;
            const double var_x109 = 0.0082319999999999997 + var_x108;
            const double var_x110 = var_x109 * var_chaste_interface__calcium_dynamics__g;
            const double var_x111 = var_x110 * var_chaste_interface__L_type_Ca_current_d_gate__d;
            const double var_x113 = 0.032927999999999999 * var_x107 * var_chaste_interface__calcium_dynamics__Ca_SR;
            const double var_x114 = 0.032927999999999999 * pow(var_chaste_interface__calcium_dynamics__Ca_SR, 3) / pow(var_x106, 2);
            const double var_x115 = var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__calcium_dynamics__g;
            const double var_x224 = 0.29999999999999999 + var_chaste_interface__calcium_dynamics__Ca_SR;
            const double var_x225 = pow(var_x224, (-2));
            const double var_x226 = 14.994515539305301 / (1.0 + 3.0 * var_x225);
            
            partialF = var_x226 * (-8.0000000000000007e-5 + var_x115 * (var_x114 - var_x113)) + 9.9963436928702016 * (var_x103 + var_x104 - var_x102 - var_x111) / (pow(var_x224, 3) * pow((0.33333333333333337 + var_x225), 2));
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0002
        double var_chaste_interface__calcium_dynamics__g = rY[14];
        // Units: dimensionless; Initial value: 1.0
        
        
        // Mathematics
        const double var_calcium_dynamics__g_inf = ((var_chaste_interface__calcium_dynamics__Ca_i < 0.00035) ? (1 / (1.0 + 5.439910241481016e+20 * pow(var_chaste_interface__calcium_dynamics__Ca_i, 6))) : (1 / (1.0 + 1.9720198874049176e+55 * pow(var_chaste_interface__calcium_dynamics__Ca_i, 16)))); // dimensionless
        const double var_calcium_dynamics__tau_g = 2.0; // millisecond
        const double var_calcium_dynamics__d_g = (-var_chaste_interface__calcium_dynamics__g + var_calcium_dynamics__g_inf) / var_calcium_dynamics__tau_g; // per_millisecond
        const double d_dt_chaste_interface_var_calcium_dynamics__g = (((var_chaste_interface__membrane__V > -60.0) && (var_chaste_interface__calcium_dynamics__g < var_calcium_dynamics__g_inf)) ? (0) : (var_calcium_dynamics__d_g)); // 1 / millisecond

        return d_dt_chaste_interface_var_calcium_dynamics__g;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0002
            double var_chaste_interface__calcium_dynamics__g = rY[14];
            // Units: dimensionless; Initial value: 1.0
            
            const double var_x209 = var_chaste_interface__membrane__V > -60.0;
            const double var_x228 = var_chaste_interface__calcium_dynamics__Ca_i >= 0.00035;
            const double var_x229 = var_chaste_interface__calcium_dynamics__Ca_i < 0.00035;
            const double var_x230 = pow(var_chaste_interface__calcium_dynamics__Ca_i, 6);
            const double var_x231 = pow(var_chaste_interface__calcium_dynamics__Ca_i, 16);
            const double var_x232 = (((var_x209) || (var_x228))) && (((var_x209) || (var_x229))) && (((var_x228) || (var_chaste_interface__calcium_dynamics__g < 1 / (1.0 + 5.439910241481016e+20 * var_x230)))) && (((var_x229) || (var_chaste_interface__calcium_dynamics__g < 1 / (1.0 + 1.9720198874049176e+55 * var_x231))));
            
            partialF = ((var_x232) ? (0) : (-0.5));
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__calcium_dynamics__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0002
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
        // Units: dimensionless; Initial value: 0.75
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[7];
        // Units: dimensionless; Initial value: 0.75
        double var_chaste_interface__sodium_dynamics__Na_i = rY[15];
        // Units: millimolar; Initial value: 11.6
        
        
        // Mathematics
        const double var_calcium_dynamics__Ca_o = 2.0; // millimolar
        const double var_membrane__Cm = 0.185; // microF
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__V_c = 0.016403999999999998; // micrometre3
        const double var_potassium_dynamics__K_o = 5.4000000000000004; // millimolar
        const double var_sodium_background_current__g_bna = 0.00029; // nanoS_per_picoF
        const double var_sodium_calcium_exchanger_current__K_NaCa = 1000.0; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger_current__Km_Ca = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger_current__Km_Nai = 87.5; // millimolar
        const double var_sodium_calcium_exchanger_current__alpha = 2.5; // dimensionless
        const double var_sodium_calcium_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_sodium_dynamics__Na_o / var_chaste_interface__sodium_dynamics__Na_i) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * mParameters[1] * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // picoA_per_picoF
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__i_NaCa = (pow(var_chaste_interface__sodium_dynamics__Na_i, 3) * var_calcium_dynamics__Ca_o * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger_current__gamma / (var_membrane__R * var_membrane__T)) - pow(var_sodium_dynamics__Na_o, 3) * var_chaste_interface__calcium_dynamics__Ca_i * var_sodium_calcium_exchanger_current__alpha * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger_current__K_NaCa / ((1.0 + var_sodium_calcium_exchanger_current__K_sat * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_sodium_calcium_exchanger_current__Km_Nai, 3) + pow(var_sodium_dynamics__Na_o, 3)) * (var_calcium_dynamics__Ca_o + var_sodium_calcium_exchanger_current__Km_Ca)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump_current__K_mk = 1.0; // millimolar
        const double var_sodium_potassium_pump_current__P_NaK = 1.3620000000000001; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = var_potassium_dynamics__K_o * var_chaste_interface__sodium_dynamics__Na_i * var_sodium_potassium_pump_current__P_NaK / ((var_potassium_dynamics__K_o + var_sodium_potassium_pump_current__K_mk) * (var_chaste_interface__sodium_dynamics__Na_i + var_sodium_potassium_pump_current__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // picoA_per_picoF
        const double d_dt_chaste_interface_var_sodium_dynamics__Na_i = -1.0 * (3.0 * var_sodium_calcium_exchanger_current__i_NaCa + 3.0 * var_sodium_potassium_pump_current__i_NaK + var_fast_sodium_current__i_Na + var_sodium_background_current__i_b_Na) * var_membrane__Cm / (var_membrane__F * var_membrane__V_c); // millimolar / millisecond

        return d_dt_chaste_interface_var_sodium_dynamics__Na_i;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
            // Units: dimensionless; Initial value: 0.75
            double var_chaste_interface__fast_sodium_current_j_gate__j = rY[7];
            // Units: dimensionless; Initial value: 0.75
            double var_chaste_interface__sodium_dynamics__Na_i = rY[15];
            // Units: millimolar; Initial value: 11.6
            
            const double var_x4 = exp(-0.024332029034784559 * var_chaste_interface__membrane__V);
            const double var_x5 = 1.0 + 0.10000000000000001 * var_x4;
            const double var_x6 = 1 / var_x5;
            const double var_x8 = exp(0.013101861787960915 * var_chaste_interface__membrane__V);
            const double var_x34 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
            const double var_x35 = var_x34 * mParameters[1] * var_chaste_interface__fast_sodium_current_j_gate__j;
            const double var_x36 = var_x35 * var_chaste_interface__fast_sodium_current_h_gate__h;
            const double var_x44 = 1 / (40.0 + var_chaste_interface__sodium_dynamics__Na_i);
            const double var_x45 = exp(-0.037433890822745473 * var_chaste_interface__membrane__V);
            const double var_x46 = exp(-0.0037433890822745472 * var_chaste_interface__membrane__V);
            const double var_x47 = 1.0 + 0.035299999999999998 * var_x45 + 0.1245 * var_x46;
            const double var_x71 = 1 / var_chaste_interface__sodium_dynamics__Na_i;
            const double var_x81 = 1 / var_x47;
            const double var_x82 = var_x44 * var_x81;
            const double var_x83 = var_x81 * var_chaste_interface__sodium_dynamics__Na_i / pow((1 + 0.025000000000000001 * var_chaste_interface__sodium_dynamics__Na_i), 2);
            const double var_x84 = var_x6 * var_x8 * pow(var_chaste_interface__sodium_dynamics__Na_i, 2);
            const double var_x86 = var_x36 * var_x71;
            
            partialF = 2.5185628611365452e-7 * var_x83 - 9.0551084895961074e-7 * var_x71 - 1.823319832565245e-7 * var_x84 - 0.0031224512033090025 * var_x86 - 0.00040297005778184723 * var_x82;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluateYDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.2
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[2];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[3];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[4];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
        // Units: dimensionless; Initial value: 0.3212
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__sodium_dynamics__Na_i = rY[15];
        // Units: millimolar; Initial value: 11.6
        double var_chaste_interface__potassium_dynamics__K_i = rY[16];
        // Units: millimolar; Initial value: 138.3
        
        
        // Mathematics
        const double var_inward_rectifier_potassium_current__g_K1 = 5.4050000000000002; // nanoS_per_picoF
        const double var_membrane__Cm = 0.185; // microF
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__V_c = 0.016403999999999998; // micrometre3
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_Stim = var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // picoA_per_picoF
        const double var_potassium_dynamics__K_o = 5.4000000000000004; // millimolar
        const double var_potassium_pump_current__g_pK = 0.0146; // nanoS_per_picoF
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_potassium_dynamics__K_o / var_chaste_interface__potassium_dynamics__K_i) / var_membrane__F; // millivolt
        const double var_inward_rectifier_potassium_current__alpha_K1 = 0.10000000000000001 / (1.0 + exp(-12.0 + 0.059999999999999998 * var_chaste_interface__membrane__V - 0.059999999999999998 * var_reversal_potentials__E_K)); // dimensionless
        const double var_inward_rectifier_potassium_current__beta_K1 = (3.0 * exp(0.02 + 0.00020000000000000001 * var_chaste_interface__membrane__V - 0.00020000000000000001 * var_reversal_potentials__E_K) + exp(-1.0 + 0.10000000000000001 * var_chaste_interface__membrane__V - 0.10000000000000001 * var_reversal_potentials__E_K)) / (1.0 + exp(0.5 * var_reversal_potentials__E_K - 0.5 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_inward_rectifier_potassium_current__xK1_inf = var_inward_rectifier_potassium_current__alpha_K1 / (var_inward_rectifier_potassium_current__alpha_K1 + var_inward_rectifier_potassium_current__beta_K1); // dimensionless
        const double var_inward_rectifier_potassium_current__i_K1 = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier_potassium_current__g_K1 * var_inward_rectifier_potassium_current__xK1_inf; // picoA_per_picoF
        const double var_potassium_pump_current__i_p_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_pump_current__g_pK / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[2] * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2; // picoA_per_picoF
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_slow_time_dependent_potassium_current__g_Ks = 0.245; // nanoS_per_picoF
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_reversal_potentials__P_kna * var_sodium_dynamics__Na_o + var_potassium_dynamics__K_o) / (var_reversal_potentials__P_kna * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i)) / var_membrane__F; // millivolt
        const double var_slow_time_dependent_potassium_current__i_Ks = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_time_dependent_potassium_current__g_Ks; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump_current__K_mk = 1.0; // millimolar
        const double var_sodium_potassium_pump_current__P_NaK = 1.3620000000000001; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = var_potassium_dynamics__K_o * var_chaste_interface__sodium_dynamics__Na_i * var_sodium_potassium_pump_current__P_NaK / ((var_potassium_dynamics__K_o + var_sodium_potassium_pump_current__K_mk) * (var_chaste_interface__sodium_dynamics__Na_i + var_sodium_potassium_pump_current__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // picoA_per_picoF
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * mParameters[3] * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // picoA_per_picoF
        const double d_dt_chaste_interface_var_potassium_dynamics__K_i = -1.0 * (-2.0 * var_sodium_potassium_pump_current__i_NaK + var_inward_rectifier_potassium_current__i_K1 + var_membrane__i_Stim + var_potassium_pump_current__i_p_K + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks + var_transient_outward_current__i_to) * var_membrane__Cm / (var_membrane__F * var_membrane__V_c); // millimolar / millisecond

        return d_dt_chaste_interface_var_potassium_dynamics__K_i;
    }

    double Cellten_tusscher_model_2004_endoFromCellMLGRL2::EvaluatePartialDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.2
            double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = rY[2];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = rY[3];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = rY[4];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
            // Units: dimensionless; Initial value: 0.3212
            double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__sodium_dynamics__Na_i = rY[15];
            // Units: millimolar; Initial value: 11.6
            double var_chaste_interface__potassium_dynamics__K_i = rY[16];
            // Units: millimolar; Initial value: 138.3
            
            const double var_x0 = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2);
            const double var_x1 = exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V);
            const double var_x2 = 1.0 + var_x1;
            const double var_x3 = 1 / var_x2;
            const double var_x11 = 1 / var_chaste_interface__potassium_dynamics__K_i;
            const double var_x12 = log(5.4000000000000004 * var_x11);
            const double var_x13 = exp(-12.0 + 0.059999999999999998 * var_chaste_interface__membrane__V - 1.6028256395817388 * var_x12);
            const double var_x14 = 1.0 + var_x13;
            const double var_x15 = 1 / var_x14;
            const double var_x16 = exp(13.356880329847826 * var_x12 - 0.5 * var_chaste_interface__membrane__V);
            const double var_x17 = 1.0 + var_x16;
            const double var_x18 = 1 / var_x17;
            const double var_x19 = exp(0.02 + 0.00020000000000000001 * var_chaste_interface__membrane__V - 0.0053427521319391299 * var_x12);
            const double var_x20 = 0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x21 = exp(-1.0 + var_x20 - 2.6713760659695653 * var_x12);
            const double var_x22 = var_x21 + 3.0 * var_x19;
            const double var_x23 = 0.10000000000000001 * var_x15 + var_x18 * var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = var_x15 * var_x24;
            const double var_x26 = mParameters[3] * var_chaste_interface__transient_outward_current_r_gate__r;
            const double var_x27 = var_x26 * var_chaste_interface__transient_outward_current_s_gate__s;
            const double var_x28 = 26.713760659695652 * var_x12;
            const double var_x29 = -var_x28 + var_chaste_interface__membrane__V;
            const double var_x33 = mParameters[2] * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2;
            const double var_x37 = var_x13 / pow(var_x14, 2);
            const double var_x38 = var_x24 * var_x29;
            const double var_x40 = var_x16 * var_x22 / pow(var_x17, 2);
            const double var_x42 = var_x15 * var_x29 / pow(var_x23, 2);
            const double var_x69 = 0.029999999999999999 * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i;
            const double var_x85 = var_x0 * (0.0031249999999999997 * var_chaste_interface__sodium_dynamics__Na_i + 0.10416666666666667 * var_chaste_interface__potassium_dynamics__K_i) / pow(var_x69, 2);
            const double var_x87 = var_x11 * var_x3;
            const double var_x88 = var_x11 * var_x25;
            const double var_x89 = var_x11 * var_x27;
            const double var_x90 = var_x11 * var_x37;
            const double var_x91 = 0.16028256395817389 * var_x90 - var_x18 * (2.6713760659695653 * var_x11 * var_x21 + 0.01602825639581739 * var_x11 * var_x19) - 13.356880329847826 * var_x11 * var_x40;
            const double var_x92 = var_x11 * var_x33;
            const double var_x93 = var_x38 * var_x90;
            const double var_x233 = 6.3176611368492499e-5 * var_x42;
            
            partialF = 0.00010126109252331096 * var_x93 - 0.0073440052301827737 * var_x85 - 0.0031224512033090025 * var_x92 - 0.0016876848753885161 * var_x88 - 4.5587787568311439e-5 * var_x87 - 0.0031224512033090025 * var_x89 - var_x233 * var_x91;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }

    std::vector<double> Cellten_tusscher_model_2004_endoFromCellMLGRL2::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellten_tusscher_model_2004_endoFromCellMLGRL2>::Initialise(void)
{
    this->mSystemName = "tentusscher_model_2004_endo";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-86.2);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0002);

    // rY[2]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_Xr1_gate__Xr1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[3]:
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_Xr2_gate__Xr2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // rY[4]:
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_Xs_gate__Xs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[5]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[6]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.75);

    // rY[7]:
    this->mVariableNames.push_back("fast_sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.75);

    // rY[8]:
    this->mVariableNames.push_back("L_type_Ca_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[9]:
    this->mVariableNames.push_back("L_type_Ca_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // rY[10]:
    this->mVariableNames.push_back("L_type_Ca_current_fCa_gate__fCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // rY[11]:
    this->mVariableNames.push_back("transient_outward_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3212);

    // rY[12]:
    this->mVariableNames.push_back("transient_outward_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[13]:
    this->mVariableNames.push_back("calcium_dynamics__Ca_SR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.2);

    // rY[14]:
    this->mVariableNames.push_back("calcium_dynamics__g");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // rY[15]:
    this->mVariableNames.push_back("sodium_dynamics__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(11.6);

    // rY[16]:
    this->mVariableNames.push_back("potassium_dynamics__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(138.3);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("litre_per_farad_second");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("nanoS_per_picoF");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("nanoS_per_picoF");

    // mParameters[3]:
    this->mParameterNames.push_back("membrane_transient_outward_current_conductance");
    this->mParameterUnits.push_back("nanoS_per_picoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellten_tusscher_model_2004_endoFromCellMLGRL2)
