//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: noble_model_1998
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "noble_model_1998.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellnoble_model_1998FromCellMLGRL2::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.0030000000000000001 * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 3.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellnoble_model_1998FromCellMLGRL2::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellnoble_model_1998FromCellMLGRL2::Cellnoble_model_1998FromCellMLGRL2(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                22,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellnoble_model_1998FromCellMLGRL2>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 9.5000000000000005e-5; // (var_membrane__Cm) [microF]
    }

    Cellnoble_model_1998FromCellMLGRL2::~Cellnoble_model_1998FromCellMLGRL2()
    {
    }
    
    double Cellnoble_model_1998FromCellMLGRL2::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 = rY[2];
        // Units: dimensionless; Initial value: 1.03e-05
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2 = rY[3];
        // Units: dimensionless; Initial value: 2e-07
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs = rY[4];
        // Units: dimensionless; Initial value: 0.001302
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
        // Units: dimensionless; Initial value: 0.0016203
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
        // Units: dimensionless; Initial value: 0.9944036
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_channel_f2_gate__f2 = rY[9];
        // Units: dimensionless; Initial value: 0.9349197
        double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[10];
        // Units: dimensionless; Initial value: 0.9651958
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
        // Units: dimensionless; Initial value: 0.9948645
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[15];
        // Units: millimolar; Initial value: 7.3321223
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[16];
        // Units: millimolar; Initial value: 136.5644281
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[17];
        // Units: millimolar; Initial value: 1.88e-05
        
        const double var_L_type_Ca_channel__FrICa = 1.0; // dimensionless
        const double var_L_type_Ca_channel__P_CaK = 0.002; // dimensionless
        const double var_L_type_Ca_channel__P_CaNa = 0.01; // dimensionless
        const double var_L_type_Ca_channel__P_Ca_L = 0.10000000000000001; // nanoA_per_millimolar
        const double var_calcium_background_current__g_bca = 0.00025000000000000001; // microS
        const double var_extracellular_calcium_concentration__Ca_o = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__K_o = 4.0; // millimolar
        const double var_extracellular_sodium_concentration__Na_o = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 2.5; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca_cyt = 4.0 * (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Ca_ds = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_persistent_sodium_current__g_pna = 0.0040000000000000001; // microS
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr1 = 0.0020999999999999999; // microS
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr2 = 0.0012999999999999999; // microS
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_extracellular_calcium_concentration__Ca_o / var_chaste_interface__intracellular_calcium_concentration__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_extracellular_potassium_concentration__K_o / var_chaste_interface__intracellular_potassium_concentration__K_i) / var_membrane__F; // millivolt
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (var_rapid_delayed_rectifier_potassium_current__g_Kr1 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 + var_rapid_delayed_rectifier_potassium_current__g_Kr2 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2) / (1.0 + exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V)); // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_extracellular_sodium_concentration__Na_o / var_chaste_interface__intracellular_sodium_concentration__Na_i) / var_membrane__F; // millivolt
        const double var_persistent_sodium_current__i_p_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_persistent_sodium_current__g_pna / (1.0 + exp(-6.5 - 0.125 * var_chaste_interface__membrane__V)); // nanoA
        const double var_reversal_potentials__E_mh = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o + 0.12 * var_extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o * var_reversal_potentials__P_kna + var_extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i * var_reversal_potentials__P_kna + var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.0025999999999999999; // microS
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks; // nanoA
        const double var_sodium_background_current__g_bna = 0.00059999999999999995; // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // nanoA
        const double var_sodium_calcium_exchanger__FRiNaCa = 0.001; // dimensionless
        const double var_sodium_calcium_exchanger__d_NaCa = 0; // dimensionless
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa = 0.00050000000000000001; // nanoA
        const double var_sodium_calcium_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa_cyt = (1.0 - var_sodium_calcium_exchanger__FRiNaCa) * (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa_ds = (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__FRiNaCa * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.69999999999999996; // nanoA
        const double var_sodium_potassium_pump__i_NaK = var_extracellular_potassium_concentration__K_o * var_chaste_interface__intracellular_sodium_concentration__Na_i * var_sodium_potassium_pump__i_NaK_max / ((var_extracellular_potassium_concentration__K_o + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Na_i + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_independent_potassium_current__K_mk1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.5; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__K_o * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(1.25 * (-10.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (var_extracellular_potassium_concentration__K_o + var_time_independent_potassium_current__K_mk1)); // nanoA
        const double var_transient_outward_current__g_to = 0.0050000000000000001; // microS
        const double var_transient_outward_current__g_tos = 0; // dimensionless
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * ((1.0 - var_transient_outward_current__g_tos) * var_chaste_interface__transient_outward_current_s_gate__s + var_transient_outward_current__g_tos) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r; // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_L_type_Ca_channel__i_Ca_L_Ca_cyt + var_L_type_Ca_channel__i_Ca_L_Ca_ds + var_L_type_Ca_channel__i_Ca_L_K_cyt + var_L_type_Ca_channel__i_Ca_L_K_ds + var_L_type_Ca_channel__i_Ca_L_Na_cyt + var_L_type_Ca_channel__i_Ca_L_Na_ds + var_calcium_background_current__i_b_Ca + var_fast_sodium_current__i_Na + var_persistent_sodium_current__i_p_Na + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_slow_delayed_rectifier_potassium_current__i_Ks + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa_cyt + var_sodium_calcium_exchanger__i_NaCa_ds + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellnoble_model_1998FromCellMLGRL2::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 = rY[2];
        // Units: dimensionless; Initial value: 1.03e-05
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2 = rY[3];
        // Units: dimensionless; Initial value: 2e-07
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs = rY[4];
        // Units: dimensionless; Initial value: 0.001302
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
        // Units: dimensionless; Initial value: 0.0016203
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
        // Units: dimensionless; Initial value: 0.9944036
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_channel_f2_gate__f2 = rY[9];
        // Units: dimensionless; Initial value: 0.9349197
        double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[10];
        // Units: dimensionless; Initial value: 0.9651958
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
        // Units: dimensionless; Initial value: 0.9948645
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[15];
        // Units: millimolar; Initial value: 7.3321223
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[16];
        // Units: millimolar; Initial value: 136.5644281
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[17];
        // Units: millimolar; Initial value: 1.88e-05
        

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_L_type_Ca_channel__FrICa = 1.0; // dimensionless
        const double var_L_type_Ca_channel__P_CaK = 0.002; // dimensionless
        const double var_L_type_Ca_channel__P_CaNa = 0.01; // dimensionless
        const double var_L_type_Ca_channel__P_Ca_L = 0.10000000000000001; // nanoA_per_millimolar
        const double var_calcium_background_current__g_bca = 0.00025000000000000001; // microS
        const double var_extracellular_calcium_concentration__Ca_o = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__K_o = 4.0; // millimolar
        const double var_extracellular_sodium_concentration__Na_o = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 2.5; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca_cyt = 4.0 * (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Ca_ds = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
        const double var_membrane__i_Stim = 1000.0 * mParameters[0] * var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // nanoA
        const double var_persistent_sodium_current__g_pna = 0.0040000000000000001; // microS
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr1 = 0.0020999999999999999; // microS
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr2 = 0.0012999999999999999; // microS
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_extracellular_calcium_concentration__Ca_o / var_chaste_interface__intracellular_calcium_concentration__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_extracellular_potassium_concentration__K_o / var_chaste_interface__intracellular_potassium_concentration__K_i) / var_membrane__F; // millivolt
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (var_rapid_delayed_rectifier_potassium_current__g_Kr1 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 + var_rapid_delayed_rectifier_potassium_current__g_Kr2 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2) / (1.0 + exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V)); // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_extracellular_sodium_concentration__Na_o / var_chaste_interface__intracellular_sodium_concentration__Na_i) / var_membrane__F; // millivolt
        const double var_persistent_sodium_current__i_p_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_persistent_sodium_current__g_pna / (1.0 + exp(-6.5 - 0.125 * var_chaste_interface__membrane__V)); // nanoA
        const double var_reversal_potentials__E_mh = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o + 0.12 * var_extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o * var_reversal_potentials__P_kna + var_extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i * var_reversal_potentials__P_kna + var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.0025999999999999999; // microS
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks; // nanoA
        const double var_sodium_background_current__g_bna = 0.00059999999999999995; // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // nanoA
        const double var_sodium_calcium_exchanger__FRiNaCa = 0.001; // dimensionless
        const double var_sodium_calcium_exchanger__d_NaCa = 0; // dimensionless
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa = 0.00050000000000000001; // nanoA
        const double var_sodium_calcium_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa_cyt = (1.0 - var_sodium_calcium_exchanger__FRiNaCa) * (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa_ds = (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__FRiNaCa * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.69999999999999996; // nanoA
        const double var_sodium_potassium_pump__i_NaK = var_extracellular_potassium_concentration__K_o * var_chaste_interface__intracellular_sodium_concentration__Na_i * var_sodium_potassium_pump__i_NaK_max / ((var_extracellular_potassium_concentration__K_o + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Na_i + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_independent_potassium_current__K_mk1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.5; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__K_o * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(1.25 * (-10.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (var_extracellular_potassium_concentration__K_o + var_time_independent_potassium_current__K_mk1)); // nanoA
        const double var_transient_outward_current__g_to = 0.0050000000000000001; // microS
        const double var_transient_outward_current__g_tos = 0; // dimensionless
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * ((1.0 - var_transient_outward_current__g_tos) * var_chaste_interface__transient_outward_current_s_gate__s + var_transient_outward_current__g_tos) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r; // nanoA
        const double var_membrane__V_orig_deriv = -1.0 * (var_L_type_Ca_channel__i_Ca_L_Ca_cyt + var_L_type_Ca_channel__i_Ca_L_Ca_ds + var_L_type_Ca_channel__i_Ca_L_K_cyt + var_L_type_Ca_channel__i_Ca_L_K_ds + var_L_type_Ca_channel__i_Ca_L_Na_cyt + var_L_type_Ca_channel__i_Ca_L_Na_ds + var_calcium_background_current__i_b_Ca + var_fast_sodium_current__i_Na + var_membrane__i_Stim + var_persistent_sodium_current__i_p_Na + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_slow_delayed_rectifier_potassium_current__i_Ks + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa_cyt + var_sodium_calcium_exchanger__i_NaCa_ds + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / mParameters[0]; // millivolt / second
        d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Cellnoble_model_1998FromCellMLGRL2::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 = rY[2];
        // Units: dimensionless; Initial value: 1.03e-05
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2 = rY[3];
        // Units: dimensionless; Initial value: 2e-07
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs = rY[4];
        // Units: dimensionless; Initial value: 0.001302
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
        // Units: dimensionless; Initial value: 0.0016203
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
        // Units: dimensionless; Initial value: 0.9944036
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_channel_f2_gate__f2 = rY[9];
        // Units: dimensionless; Initial value: 0.9349197
        double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[10];
        // Units: dimensionless; Initial value: 0.9651958
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
        // Units: dimensionless; Initial value: 0.9948645
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__calcium_release__ActFrac = rY[13];
        // Units: dimensionless; Initial value: 0.0042614
        double var_chaste_interface__calcium_release__ProdFrac = rY[14];
        // Units: dimensionless; Initial value: 0.4068154
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[15];
        // Units: millimolar; Initial value: 7.3321223
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[16];
        // Units: millimolar; Initial value: 136.5644281
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[17];
        // Units: millimolar; Initial value: 1.88e-05
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[18];
        // Units: millimolar; Initial value: 0.4531889
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[19];
        // Units: millimolar; Initial value: 0.4481927
        double var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod = rY[20];
        // Units: millimolar; Initial value: 0.0005555
        double var_chaste_interface__intracellular_calcium_concentration__Ca_Trop = rY[21];
        // Units: millimolar; Initial value: 0.0003542
        
        
        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_L_type_Ca_channel__FrICa = 1.0; // dimensionless
        const double var_L_type_Ca_channel__Km_f2 = 100000.0; // millimolar
        const double var_L_type_Ca_channel__Km_f2ds = 0.001; // millimolar
        const double var_L_type_Ca_channel__P_CaK = 0.002; // dimensionless
        const double var_L_type_Ca_channel__P_CaNa = 0.01; // dimensionless
        const double var_L_type_Ca_channel__P_Ca_L = 0.10000000000000001; // nanoA_per_millimolar
        const double var_L_type_Ca_channel__R_decay = 20.0; // per_second
        const double var_L_type_Ca_channel_d_gate__speed_d = 3.0; // dimensionless
        const double var_L_type_Ca_channel_f_gate__delta_f = 0.0001; // millivolt
        const double var_L_type_Ca_channel_f_gate__speed_f = 0.29999999999999999; // dimensionless
        const double var_calcium_background_current__g_bca = 0.00025000000000000001; // microS
        const double var_calcium_release__K_leak_rate = 0.050000000000000003; // per_second
        const double var_calcium_release__K_m_Ca_cyt = 0.00050000000000000001; // millimolar
        const double var_calcium_release__K_m_Ca_ds = 0.01; // millimolar
        const double var_calcium_release__K_m_rel = 250.0; // per_second
        const double var_calcium_release__PrecFrac = 1.0 - var_chaste_interface__calcium_release__ActFrac - var_chaste_interface__calcium_release__ProdFrac; // dimensionless
        const double var_extracellular_calcium_concentration__Ca_o = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__K_o = 4.0; // millimolar
        const double var_extracellular_sodium_concentration__Na_o = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 2.5; // microS
        const double var_fast_sodium_current_h_gate__shift_h = 0; // millivolt
        const double var_fast_sodium_current_m_gate__delta_m = 1.0000000000000001e-5; // millivolt
        const double var_L_type_Ca_channel_f2ds_gate__f2ds_orig_deriv = (1.0 - var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds - var_chaste_interface__intracellular_calcium_concentration__Ca_ds / (var_L_type_Ca_channel__Km_f2ds + var_chaste_interface__intracellular_calcium_concentration__Ca_ds)) * var_L_type_Ca_channel__R_decay; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f2ds_gate__f2ds = 0.001 * var_L_type_Ca_channel_f2ds_gate__f2ds_orig_deriv; // 1 / millisecond
        const double var_calcium_release__CadsReg = var_chaste_interface__intracellular_calcium_concentration__Ca_ds / (var_calcium_release__K_m_Ca_ds + var_chaste_interface__intracellular_calcium_concentration__Ca_ds); // dimensionless
        const double var_L_type_Ca_channel_f2_gate__f2_orig_deriv = 1.0 - 1.0 * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 - 1.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i / (var_L_type_Ca_channel__Km_f2 + var_chaste_interface__intracellular_calcium_concentration__Ca_i); // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f2_gate__f2 = 0.001 * var_L_type_Ca_channel_f2_gate__f2_orig_deriv; // 1 / millisecond
        const double var_calcium_release__CaiReg = var_chaste_interface__intracellular_calcium_concentration__Ca_i / (var_calcium_release__K_m_Ca_cyt + var_chaste_interface__intracellular_calcium_concentration__Ca_i); // dimensionless
        const double var_calcium_release__RegBindSite = (1.0 - var_calcium_release__CaiReg) * var_calcium_release__CadsReg + var_calcium_release__CaiReg; // dimensionless
        const double var_calcium_release__ActRate = 500.0 * pow(var_calcium_release__RegBindSite, 2); // per_second
        const double var_calcium_release__InactRate = 60.0 + 500.0 * pow(var_calcium_release__RegBindSite, 2); // per_second
        const double var_calcium_release__i_rel = (pow(var_chaste_interface__calcium_release__ActFrac, 2) * var_calcium_release__K_m_rel / pow((0.25 + var_chaste_interface__calcium_release__ActFrac), 2) + var_calcium_release__K_leak_rate) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel; // millimolar_per_second
        const double var_calcium_translocation__i_trans = 50.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_up - 50.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel; // millimolar_per_second
        const double var_intracellular_calcium_concentration__Calmod = 0.02; // millimolar
        const double var_intracellular_calcium_concentration__Kdecay = 10.0; // per_second
        const double var_intracellular_calcium_concentration__Trop = 0.050000000000000003; // millimolar
        const double var_intracellular_calcium_concentration__V_ds_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_calcium_concentration__V_e_ratio = 0.40000000000000002; // dimensionless
        const double var_intracellular_calcium_concentration__V_rel_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_calcium_concentration__V_up_ratio = 0.01; // dimensionless
        const double var_intracellular_calcium_concentration__Ca_rel_orig_deriv = -var_calcium_release__i_rel + var_calcium_translocation__i_trans * var_intracellular_calcium_concentration__V_up_ratio / var_intracellular_calcium_concentration__V_rel_ratio; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel = 0.001 * var_intracellular_calcium_concentration__Ca_rel_orig_deriv; // millimolar / millisecond
        const double var_intracellular_calcium_concentration__V_i_ratio = 1.0 - var_intracellular_calcium_concentration__V_e_ratio - var_intracellular_calcium_concentration__V_rel_ratio - var_intracellular_calcium_concentration__V_up_ratio; // dimensionless
        const double var_intracellular_calcium_concentration__alpha_Calmod = 100000.0; // per_millimolar_second
        const double var_intracellular_calcium_concentration__alpha_Trop = 100000.0; // per_millimolar_second
        const double var_intracellular_calcium_concentration__beta_Calmod = 50.0; // per_second
        const double var_intracellular_calcium_concentration__Ca_Calmod_orig_deriv = -var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod * var_intracellular_calcium_concentration__beta_Calmod + (-var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod + var_intracellular_calcium_concentration__Calmod) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_intracellular_calcium_concentration__alpha_Calmod; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_Calmod = 0.001 * var_intracellular_calcium_concentration__Ca_Calmod_orig_deriv; // millimolar / millisecond
        const double var_intracellular_calcium_concentration__beta_Trop = 200.0; // per_second
        const double var_intracellular_calcium_concentration__Ca_Trop_orig_deriv = -var_chaste_interface__intracellular_calcium_concentration__Ca_Trop * var_intracellular_calcium_concentration__beta_Trop + (-var_chaste_interface__intracellular_calcium_concentration__Ca_Trop + var_intracellular_calcium_concentration__Trop) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_intracellular_calcium_concentration__alpha_Trop; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_Trop = 0.001 * var_intracellular_calcium_concentration__Ca_Trop_orig_deriv; // millimolar / millisecond
        const double var_intracellular_calcium_concentration__length = 0.073999999999999996; // micrometre
        const double var_intracellular_calcium_concentration__radius = 0.012; // micrometre
        const double var_intracellular_calcium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_calcium_concentration__radius, 2) * var_intracellular_calcium_concentration__length; // micrometre3
        const double var_intracellular_calcium_concentration__V_i = var_intracellular_calcium_concentration__V_Cell * var_intracellular_calcium_concentration__V_i_ratio; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca_cyt = 4.0 * (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Ca_ds = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel_d_gate__E0_d = 19.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_L_type_Ca_channel_d_gate__alpha_d = ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 0.0001) ? (120.0) : (30.0 * var_L_type_Ca_channel_d_gate__E0_d / (1.0 - exp(-0.25 * var_L_type_Ca_channel_d_gate__E0_d)))); // per_second
        const double var_L_type_Ca_channel_d_gate__beta_d = ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 0.0001) ? (120.0) : (12.0 * var_L_type_Ca_channel_d_gate__E0_d / (-1.0 + exp(0.10000000000000001 * var_L_type_Ca_channel_d_gate__E0_d)))); // per_second
        const double var_L_type_Ca_channel_d_gate__d_orig_deriv = ((1.0 - var_chaste_interface__L_type_Ca_channel_d_gate__d) * var_L_type_Ca_channel_d_gate__alpha_d - var_L_type_Ca_channel_d_gate__beta_d * var_chaste_interface__L_type_Ca_channel_d_gate__d) * var_L_type_Ca_channel_d_gate__speed_d; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d = 0.001 * var_L_type_Ca_channel_d_gate__d_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_gate__E0_f = 34.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_L_type_Ca_channel_f_gate__alpha_f = ((var_L_type_Ca_channel_f_gate__delta_f > fabs(var_L_type_Ca_channel_f_gate__E0_f)) ? (25.0) : (6.25 * var_L_type_Ca_channel_f_gate__E0_f / (-1.0 + exp(0.25 * var_L_type_Ca_channel_f_gate__E0_f)))); // per_second
        const double var_L_type_Ca_channel_f_gate__beta_f = 12.0 / (1.0 + exp(-8.5 - 0.25 * var_chaste_interface__membrane__V)); // per_second
        const double var_L_type_Ca_channel_f_gate__f_orig_deriv = ((1.0 - var_chaste_interface__L_type_Ca_channel_f_gate__f) * var_L_type_Ca_channel_f_gate__alpha_f - var_L_type_Ca_channel_f_gate__beta_f * var_chaste_interface__L_type_Ca_channel_f_gate__f) * var_L_type_Ca_channel_f_gate__speed_f; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f = 0.001 * var_L_type_Ca_channel_f_gate__f_orig_deriv; // 1 / millisecond
        const double var_calcium_release__SpeedRel = ((var_chaste_interface__membrane__V < -50.0) ? (5.0) : (1.0)); // dimensionless
        const double var_calcium_release__ActFrac_orig_deriv = var_calcium_release__ActRate * var_calcium_release__PrecFrac * var_calcium_release__SpeedRel - var_chaste_interface__calcium_release__ActFrac * var_calcium_release__InactRate * var_calcium_release__SpeedRel; // 1 / second
        const double d_dt_chaste_interface_var_calcium_release__ActFrac = 0.001 * var_calcium_release__ActFrac_orig_deriv; // 1 / millisecond
        const double var_calcium_release__ProdFrac_orig_deriv = -1.0 * var_chaste_interface__calcium_release__ProdFrac * var_calcium_release__SpeedRel + var_chaste_interface__calcium_release__ActFrac * var_calcium_release__InactRate * var_calcium_release__SpeedRel; // 1 / second
        const double d_dt_chaste_interface_var_calcium_release__ProdFrac = 0.001 * var_calcium_release__ProdFrac_orig_deriv; // 1 / millisecond
        const double var_fast_sodium_current_h_gate__alpha_h = 20.0 * exp(-9.375 + 0.125 * var_fast_sodium_current_h_gate__shift_h - 0.125 * var_chaste_interface__membrane__V); // per_second
        const double var_fast_sodium_current_h_gate__beta_h = 2000.0 / (1.0 + 320.0 * exp(-7.5 + 0.10000000000000001 * var_fast_sodium_current_h_gate__shift_h - 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_second
        const double var_fast_sodium_current_h_gate__h_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_h_gate__h) * var_fast_sodium_current_h_gate__alpha_h - var_fast_sodium_current_h_gate__beta_h * var_chaste_interface__fast_sodium_current_h_gate__h; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = 0.001 * var_fast_sodium_current_h_gate__h_orig_deriv; // 1 / millisecond
        const double var_fast_sodium_current_m_gate__E0_m = 41.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_fast_sodium_current_m_gate__alpha_m = ((var_fast_sodium_current_m_gate__delta_m > fabs(var_fast_sodium_current_m_gate__E0_m)) ? (2000.0) : (200.0 * var_fast_sodium_current_m_gate__E0_m / (1.0 - exp(-0.10000000000000001 * var_fast_sodium_current_m_gate__E0_m)))); // per_second
        const double var_fast_sodium_current_m_gate__beta_m = 8000.0 * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V); // per_second
        const double var_fast_sodium_current_m_gate__m_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m * var_chaste_interface__fast_sodium_current_m_gate__m; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * var_fast_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond
        const double var_intracellular_calcium_concentration__Ca_ds_orig_deriv = -var_chaste_interface__intracellular_calcium_concentration__Ca_ds * var_intracellular_calcium_concentration__Kdecay - 0.5 * var_L_type_Ca_channel__i_Ca_L_Ca_ds / (var_intracellular_calcium_concentration__V_ds_ratio * var_intracellular_calcium_concentration__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_ds = 0.001 * var_intracellular_calcium_concentration__Ca_ds_orig_deriv; // millimolar / millisecond
        const double var_persistent_sodium_current__g_pna = 0.0040000000000000001; // microS
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr1 = 0.0020999999999999999; // microS
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr2 = 0.0012999999999999999; // microS
        const double var_rapid_delayed_rectifier_potassium_current_xr1_gate__alpha_xr1 = 50.0 / (1.0 + exp(0.55555555555555558 - 0.1111111111111111 * var_chaste_interface__membrane__V)); // per_second
        const double var_rapid_delayed_rectifier_potassium_current_xr1_gate__beta_xr1 = 0.050000000000000003 * exp(1.3333333333333333 - 0.066666666666666666 * var_chaste_interface__membrane__V); // per_second
        const double var_rapid_delayed_rectifier_potassium_current_xr1_gate__xr1_orig_deriv = (1.0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1) * var_rapid_delayed_rectifier_potassium_current_xr1_gate__alpha_xr1 - var_rapid_delayed_rectifier_potassium_current_xr1_gate__beta_xr1 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 = 0.001 * var_rapid_delayed_rectifier_potassium_current_xr1_gate__xr1_orig_deriv; // 1 / millisecond
        const double var_rapid_delayed_rectifier_potassium_current_xr2_gate__alpha_xr2 = 50.0 / (1.0 + exp(0.55555555555555558 - 0.1111111111111111 * var_chaste_interface__membrane__V)); // per_second
        const double var_rapid_delayed_rectifier_potassium_current_xr2_gate__beta_xr2 = 0.40000000000000002 * exp(-pow((1.0 + 0.033333333333333333 * var_chaste_interface__membrane__V), 3)); // per_second
        const double var_rapid_delayed_rectifier_potassium_current_xr2_gate__xr2_orig_deriv = (1.0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2) * var_rapid_delayed_rectifier_potassium_current_xr2_gate__alpha_xr2 - var_rapid_delayed_rectifier_potassium_current_xr2_gate__beta_xr2 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current_xr2_gate__xr2 = 0.001 * var_rapid_delayed_rectifier_potassium_current_xr2_gate__xr2_orig_deriv; // 1 / millisecond
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_extracellular_calcium_concentration__Ca_o / var_chaste_interface__intracellular_calcium_concentration__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_extracellular_potassium_concentration__K_o / var_chaste_interface__intracellular_potassium_concentration__K_i) / var_membrane__F; // millivolt
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (var_rapid_delayed_rectifier_potassium_current__g_Kr1 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 + var_rapid_delayed_rectifier_potassium_current__g_Kr2 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2) / (1.0 + exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V)); // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_extracellular_sodium_concentration__Na_o / var_chaste_interface__intracellular_sodium_concentration__Na_i) / var_membrane__F; // millivolt
        const double var_persistent_sodium_current__i_p_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_persistent_sodium_current__g_pna / (1.0 + exp(-6.5 - 0.125 * var_chaste_interface__membrane__V)); // nanoA
        const double var_reversal_potentials__E_mh = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o + 0.12 * var_extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o * var_reversal_potentials__P_kna + var_extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i * var_reversal_potentials__P_kna + var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_sarcoplasmic_reticulum_calcium_pump__K_cyca = 0.00029999999999999997; // millimolar
        const double var_sarcoplasmic_reticulum_calcium_pump__K_srca = 0.5; // millimolar
        const double var_sarcoplasmic_reticulum_calcium_pump__K_xcs = 0.40000000000000002; // dimensionless
        const double var_sarcoplasmic_reticulum_calcium_pump__K_1 = var_sarcoplasmic_reticulum_calcium_pump__K_cyca * var_sarcoplasmic_reticulum_calcium_pump__K_xcs / var_sarcoplasmic_reticulum_calcium_pump__K_srca; // dimensionless
        const double var_sarcoplasmic_reticulum_calcium_pump__K_2 = var_chaste_interface__intracellular_calcium_concentration__Ca_up * var_sarcoplasmic_reticulum_calcium_pump__K_1 + var_sarcoplasmic_reticulum_calcium_pump__K_cyca * var_sarcoplasmic_reticulum_calcium_pump__K_xcs + var_chaste_interface__intracellular_calcium_concentration__Ca_i + var_sarcoplasmic_reticulum_calcium_pump__K_cyca; // millimolar
        const double var_sarcoplasmic_reticulum_calcium_pump__alpha_up = 0.40000000000000002; // millimolar_per_second
        const double var_sarcoplasmic_reticulum_calcium_pump__beta_up = 0.029999999999999999; // millimolar_per_second
        const double var_sarcoplasmic_reticulum_calcium_pump__i_up = var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_sarcoplasmic_reticulum_calcium_pump__alpha_up / var_sarcoplasmic_reticulum_calcium_pump__K_2 - var_chaste_interface__intracellular_calcium_concentration__Ca_up * var_sarcoplasmic_reticulum_calcium_pump__K_1 * var_sarcoplasmic_reticulum_calcium_pump__beta_up / var_sarcoplasmic_reticulum_calcium_pump__K_2; // millimolar_per_second
        const double var_intracellular_calcium_concentration__Ca_up_orig_deriv = -var_calcium_translocation__i_trans + var_intracellular_calcium_concentration__V_i_ratio * var_sarcoplasmic_reticulum_calcium_pump__i_up / var_intracellular_calcium_concentration__V_up_ratio; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up = 0.001 * var_intracellular_calcium_concentration__Ca_up_orig_deriv; // millimolar / millisecond
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.0025999999999999999; // microS
        const double var_slow_delayed_rectifier_potassium_current_xs_gate__alpha_xs = 14.0 / (1.0 + exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V)); // per_second
        const double var_slow_delayed_rectifier_potassium_current_xs_gate__beta_xs = exp(-0.022222222222222223 * var_chaste_interface__membrane__V); // per_second
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks; // nanoA
        const double var_slow_delayed_rectifier_potassium_current_xs_gate__xs_orig_deriv = (1.0 - var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs) * var_slow_delayed_rectifier_potassium_current_xs_gate__alpha_xs - var_slow_delayed_rectifier_potassium_current_xs_gate__beta_xs * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs; // 1 / second
        const double d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current_xs_gate__xs = 0.001 * var_slow_delayed_rectifier_potassium_current_xs_gate__xs_orig_deriv; // 1 / millisecond
        const double var_sodium_background_current__g_bna = 0.00059999999999999995; // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // nanoA
        const double var_sodium_calcium_exchanger__FRiNaCa = 0.001; // dimensionless
        const double var_sodium_calcium_exchanger__d_NaCa = 0; // dimensionless
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa = 0.00050000000000000001; // nanoA
        const double var_sodium_calcium_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa_cyt = (1.0 - var_sodium_calcium_exchanger__FRiNaCa) * (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa_ds = (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__FRiNaCa * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_intracellular_calcium_concentration__Ca_i_orig_deriv = -var_intracellular_calcium_concentration__Ca_Calmod_orig_deriv - var_intracellular_calcium_concentration__Ca_Trop_orig_deriv - var_sarcoplasmic_reticulum_calcium_pump__i_up + var_calcium_release__i_rel * var_intracellular_calcium_concentration__V_rel_ratio / var_intracellular_calcium_concentration__V_i_ratio + var_chaste_interface__intracellular_calcium_concentration__Ca_ds * var_intracellular_calcium_concentration__Kdecay * var_intracellular_calcium_concentration__V_ds_ratio - 0.5 * (-2.0 * var_sodium_calcium_exchanger__i_NaCa_cyt - 2.0 * var_sodium_calcium_exchanger__i_NaCa_ds + var_L_type_Ca_channel__i_Ca_L_Ca_cyt + var_calcium_background_current__i_b_Ca) / (var_intracellular_calcium_concentration__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_i = 0.001 * var_intracellular_calcium_concentration__Ca_i_orig_deriv; // millimolar / millisecond
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.69999999999999996; // nanoA
        const double var_sodium_potassium_pump__i_NaK = var_extracellular_potassium_concentration__K_o * var_chaste_interface__intracellular_sodium_concentration__Na_i * var_sodium_potassium_pump__i_NaK_max / ((var_extracellular_potassium_concentration__K_o + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Na_i + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_intracellular_sodium_concentration__Na_i_orig_deriv = -1.0 * (3.0 * var_sodium_calcium_exchanger__i_NaCa_cyt + 3.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_Ca_L_Na_cyt + var_L_type_Ca_channel__i_Ca_L_Na_ds + var_fast_sodium_current__i_Na + var_persistent_sodium_current__i_p_Na + var_sodium_background_current__i_b_Na) / (var_intracellular_calcium_concentration__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Na_i = 0.001 * var_intracellular_sodium_concentration__Na_i_orig_deriv; // millimolar / millisecond
        const double var_time_independent_potassium_current__K_mk1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.5; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__K_o * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(1.25 * (-10.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (var_extracellular_potassium_concentration__K_o + var_time_independent_potassium_current__K_mk1)); // nanoA
        const double var_transient_outward_current__g_to = 0.0050000000000000001; // microS
        const double var_transient_outward_current__g_tos = 0; // dimensionless
        const double var_transient_outward_current_r_gate__r_orig_deriv = 333.0 / (1.0 + exp(-0.80000000000000004 - 0.20000000000000001 * var_chaste_interface__membrane__V)) - 333.0 * var_chaste_interface__transient_outward_current_r_gate__r; // 1 / second
        const double d_dt_chaste_interface_var_transient_outward_current_r_gate__r = 0.001 * var_transient_outward_current_r_gate__r_orig_deriv; // 1 / millisecond
        const double var_transient_outward_current_s_gate__alpha_s = 0.033000000000000002 * exp(-0.058823529411764705 * var_chaste_interface__membrane__V); // per_second
        const double var_transient_outward_current_s_gate__beta_s = 33.0 / (1.0 + exp(-1.25 - 0.125 * var_chaste_interface__membrane__V)); // per_second
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * ((1.0 - var_transient_outward_current__g_tos) * var_chaste_interface__transient_outward_current_s_gate__s + var_transient_outward_current__g_tos) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r; // nanoA
        const double var_intracellular_potassium_concentration__K_i_orig_deriv = -1.0 * (-2.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_Ca_L_K_cyt + var_L_type_Ca_channel__i_Ca_L_K_ds + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_slow_delayed_rectifier_potassium_current__i_Ks + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / (var_intracellular_calcium_concentration__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__K_i = 0.001 * var_intracellular_potassium_concentration__K_i_orig_deriv; // millimolar / millisecond
        const double var_transient_outward_current_s_gate__s_orig_deriv = (1.0 - var_chaste_interface__transient_outward_current_s_gate__s) * var_transient_outward_current_s_gate__alpha_s - var_transient_outward_current_s_gate__beta_s * var_chaste_interface__transient_outward_current_s_gate__s; // 1 / second
        const double d_dt_chaste_interface_var_transient_outward_current_s_gate__s = 0.001 * var_transient_outward_current_s_gate__s_orig_deriv; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
            const double var_membrane__i_Stim = 1000.0 * mParameters[0] * var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // nanoA
            const double var_membrane__V_orig_deriv = -1.0 * (var_L_type_Ca_channel__i_Ca_L_Ca_cyt + var_L_type_Ca_channel__i_Ca_L_Ca_ds + var_L_type_Ca_channel__i_Ca_L_K_cyt + var_L_type_Ca_channel__i_Ca_L_K_ds + var_L_type_Ca_channel__i_Ca_L_Na_cyt + var_L_type_Ca_channel__i_Ca_L_Na_ds + var_calcium_background_current__i_b_Ca + var_fast_sodium_current__i_Na + var_membrane__i_Stim + var_persistent_sodium_current__i_p_Na + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_slow_delayed_rectifier_potassium_current__i_Ks + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa_cyt + var_sodium_calcium_exchanger__i_NaCa_ds + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / mParameters[0]; // millivolt / second
            d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        mEvalF[1] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_i;
        mEvalF[2] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current_xr1_gate__xr1;
        mEvalF[3] = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current_xr2_gate__xr2;
        mEvalF[4] = d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current_xs_gate__xs;
        mEvalF[5] = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        mEvalF[6] = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        mEvalF[7] = d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d;
        mEvalF[8] = d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f;
        mEvalF[9] = d_dt_chaste_interface_var_L_type_Ca_channel_f2_gate__f2;
        mEvalF[10] = d_dt_chaste_interface_var_L_type_Ca_channel_f2ds_gate__f2ds;
        mEvalF[11] = d_dt_chaste_interface_var_transient_outward_current_s_gate__s;
        mEvalF[12] = d_dt_chaste_interface_var_transient_outward_current_r_gate__r;
        mEvalF[13] = d_dt_chaste_interface_var_calcium_release__ActFrac;
        mEvalF[14] = d_dt_chaste_interface_var_calcium_release__ProdFrac;
        mEvalF[15] = d_dt_chaste_interface_var_intracellular_sodium_concentration__Na_i;
        mEvalF[16] = d_dt_chaste_interface_var_intracellular_potassium_concentration__K_i;
        mEvalF[17] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_ds;
        mEvalF[18] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up;
        mEvalF[19] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel;
        mEvalF[20] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_Calmod;
        mEvalF[21] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_Trop;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time_converted, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        rY[13] = y_save;
        
        
        y_save = rY[14];
        rY[14] = mYInit[14];
        mEvalF[14] = EvaluateYDerivative14(var_chaste_interface__environment__time_converted, rY);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time_converted, rY, delta);
        rY[14] = y_save;
        
        
        y_save = rY[15];
        rY[15] = mYInit[15];
        mEvalF[15] = EvaluateYDerivative15(var_chaste_interface__environment__time_converted, rY);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time_converted, rY, delta);
        rY[15] = y_save;
        
        
        y_save = rY[16];
        rY[16] = mYInit[16];
        mEvalF[16] = EvaluateYDerivative16(var_chaste_interface__environment__time_converted, rY);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time_converted, rY, delta);
        rY[16] = y_save;
        
        
        y_save = rY[17];
        rY[17] = mYInit[17];
        mEvalF[17] = EvaluateYDerivative17(var_chaste_interface__environment__time_converted, rY);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time_converted, rY, delta);
        rY[17] = y_save;
        
        
        y_save = rY[18];
        rY[18] = mYInit[18];
        mEvalF[18] = EvaluateYDerivative18(var_chaste_interface__environment__time_converted, rY);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time_converted, rY, delta);
        rY[18] = y_save;
        
        
        y_save = rY[19];
        rY[19] = mYInit[19];
        mEvalF[19] = EvaluateYDerivative19(var_chaste_interface__environment__time_converted, rY);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time_converted, rY, delta);
        rY[19] = y_save;
        
        
        y_save = rY[20];
        rY[20] = mYInit[20];
        mEvalF[20] = EvaluateYDerivative20(var_chaste_interface__environment__time_converted, rY);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time_converted, rY, delta);
        rY[20] = y_save;
        
        
        y_save = rY[21];
        rY[21] = mYInit[21];
        mEvalF[21] = EvaluateYDerivative21(var_chaste_interface__environment__time_converted, rY);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time_converted, rY, delta);
        rY[21] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 = rY[2];
        // Units: dimensionless; Initial value: 1.03e-05
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2 = rY[3];
        // Units: dimensionless; Initial value: 2e-07
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs = rY[4];
        // Units: dimensionless; Initial value: 0.001302
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
        // Units: dimensionless; Initial value: 0.0016203
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
        // Units: dimensionless; Initial value: 0.9944036
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_channel_f2_gate__f2 = rY[9];
        // Units: dimensionless; Initial value: 0.9349197
        double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[10];
        // Units: dimensionless; Initial value: 0.9651958
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
        // Units: dimensionless; Initial value: 0.9948645
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[15];
        // Units: millimolar; Initial value: 7.3321223
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[16];
        // Units: millimolar; Initial value: 136.5644281
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[17];
        // Units: millimolar; Initial value: 1.88e-05
        
        
        // Mathematics
        const double var_L_type_Ca_channel__FrICa = 1.0; // dimensionless
        const double var_L_type_Ca_channel__P_CaK = 0.002; // dimensionless
        const double var_L_type_Ca_channel__P_CaNa = 0.01; // dimensionless
        const double var_L_type_Ca_channel__P_Ca_L = 0.10000000000000001; // nanoA_per_millimolar
        const double var_calcium_background_current__g_bca = 0.00025000000000000001; // microS
        const double var_extracellular_calcium_concentration__Ca_o = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__K_o = 4.0; // millimolar
        const double var_extracellular_sodium_concentration__Na_o = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 2.5; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca_cyt = 4.0 * (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Ca_ds = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
        const double var_membrane__i_Stim = 1000.0 * mParameters[0] * var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // nanoA
        const double var_persistent_sodium_current__g_pna = 0.0040000000000000001; // microS
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr1 = 0.0020999999999999999; // microS
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr2 = 0.0012999999999999999; // microS
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_extracellular_calcium_concentration__Ca_o / var_chaste_interface__intracellular_calcium_concentration__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_extracellular_potassium_concentration__K_o / var_chaste_interface__intracellular_potassium_concentration__K_i) / var_membrane__F; // millivolt
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (var_rapid_delayed_rectifier_potassium_current__g_Kr1 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 + var_rapid_delayed_rectifier_potassium_current__g_Kr2 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2) / (1.0 + exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V)); // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_extracellular_sodium_concentration__Na_o / var_chaste_interface__intracellular_sodium_concentration__Na_i) / var_membrane__F; // millivolt
        const double var_persistent_sodium_current__i_p_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_persistent_sodium_current__g_pna / (1.0 + exp(-6.5 - 0.125 * var_chaste_interface__membrane__V)); // nanoA
        const double var_reversal_potentials__E_mh = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o + 0.12 * var_extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o * var_reversal_potentials__P_kna + var_extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i * var_reversal_potentials__P_kna + var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.0025999999999999999; // microS
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks; // nanoA
        const double var_sodium_background_current__g_bna = 0.00059999999999999995; // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // nanoA
        const double var_sodium_calcium_exchanger__FRiNaCa = 0.001; // dimensionless
        const double var_sodium_calcium_exchanger__d_NaCa = 0; // dimensionless
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa = 0.00050000000000000001; // nanoA
        const double var_sodium_calcium_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa_cyt = (1.0 - var_sodium_calcium_exchanger__FRiNaCa) * (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa_ds = (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__FRiNaCa * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.69999999999999996; // nanoA
        const double var_sodium_potassium_pump__i_NaK = var_extracellular_potassium_concentration__K_o * var_chaste_interface__intracellular_sodium_concentration__Na_i * var_sodium_potassium_pump__i_NaK_max / ((var_extracellular_potassium_concentration__K_o + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Na_i + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_independent_potassium_current__K_mk1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.5; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__K_o * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(1.25 * (-10.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (var_extracellular_potassium_concentration__K_o + var_time_independent_potassium_current__K_mk1)); // nanoA
        const double var_transient_outward_current__g_to = 0.0050000000000000001; // microS
        const double var_transient_outward_current__g_tos = 0; // dimensionless
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * ((1.0 - var_transient_outward_current__g_tos) * var_chaste_interface__transient_outward_current_s_gate__s + var_transient_outward_current__g_tos) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r; // nanoA
        const double var_membrane__V_orig_deriv = -1.0 * (var_L_type_Ca_channel__i_Ca_L_Ca_cyt + var_L_type_Ca_channel__i_Ca_L_Ca_ds + var_L_type_Ca_channel__i_Ca_L_K_cyt + var_L_type_Ca_channel__i_Ca_L_K_ds + var_L_type_Ca_channel__i_Ca_L_Na_cyt + var_L_type_Ca_channel__i_Ca_L_Na_ds + var_calcium_background_current__i_b_Ca + var_fast_sodium_current__i_Na + var_membrane__i_Stim + var_persistent_sodium_current__i_p_Na + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_slow_delayed_rectifier_potassium_current__i_Ks + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa_cyt + var_sodium_calcium_exchanger__i_NaCa_ds + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / mParameters[0]; // millivolt / second
        d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane__V;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 1.4e-05
            double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 = rY[2];
            // Units: dimensionless; Initial value: 1.03e-05
            double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2 = rY[3];
            // Units: dimensionless; Initial value: 2e-07
            double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs = rY[4];
            // Units: dimensionless; Initial value: 0.001302
            double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
            // Units: dimensionless; Initial value: 0.0016203
            double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
            // Units: dimensionless; Initial value: 0.9944036
            double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[10];
            // Units: dimensionless; Initial value: 0.9651958
            double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
            // Units: dimensionless; Initial value: 0.9948645
            double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[15];
            // Units: millimolar; Initial value: 7.3321223
            double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[16];
            // Units: millimolar; Initial value: 136.5644281
            double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[17];
            // Units: millimolar; Initial value: 1.88e-05
            
            const double var_x0 = -0.125 * var_chaste_interface__membrane__V;
            const double var_x1 = exp(-6.5 + var_x0);
            const double var_x2 = 1.0 + var_x1;
            const double var_x3 = 1 / var_x2;
            const double var_x4 = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs, 2);
            const double var_x5 = 1 / var_chaste_interface__intracellular_potassium_concentration__K_i;
            const double var_x6 = log(4.0 * var_x5);
            const double var_x7 = exp(-0.46792363528431841 + 0.046792363528431836 * var_chaste_interface__membrane__V - 1.25 * var_x6);
            const double var_x8 = 1.0 + var_x7;
            const double var_x9 = 1 / var_x8;
            const double var_x10 = exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V);
            const double var_x11 = 1.0 + var_x10;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = 0.0012999999999999999 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2 + 0.0020999999999999999 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1;
            const double var_x14 = var_x12 * var_x13;
            const double var_x15 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
            const double var_x16 = var_x15 * var_chaste_interface__fast_sodium_current_h_gate__h;
            const double var_x17 = var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s;
            const double var_x18 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i);
            const double var_x19 = 0.018716945411372737 * var_chaste_interface__membrane__V;
            const double var_x20 = exp(var_x19);
            const double var_x21 = var_x20 * pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3.0);
            const double var_x22 = 0.037433890822745473 * var_x21;
            const double var_x23 = exp(-var_x19);
            const double var_x24 = 51359.298208806787 * var_x23;
            const double var_x25 = var_x18 * (var_x22 + var_x24 * var_chaste_interface__intracellular_calcium_concentration__Ca_i);
            const double var_x26 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds);
            const double var_x27 = var_x26 * (var_x22 + var_x24 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds);
            const double var_x28 = 1 / var_chaste_interface__intracellular_sodium_concentration__Na_i;
            const double var_x29 = var_x1 * (-26.713760659695652 * log(140.0 * var_x28) + var_chaste_interface__membrane__V) / pow(var_x2, 2);
            const double var_x30 = -26.713760659695652 * var_x6 + var_chaste_interface__membrane__V;
            const double var_x31 = var_x30 * var_x7 / pow(var_x8, 2);
            const double var_x32 = var_x10 * var_x13 * var_x30 / pow(var_x11, 2);
            const double var_x33 = exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V);
            const double var_x34 = 1.0 - var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x36 = var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f;
            const double var_x37 = var_x36 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
            const double var_x38 = var_x35 * var_x37;
            const double var_x39 = exp(1.8716945411372736);
            const double var_x40 = -140.0 * var_x33 + var_x39 * var_chaste_interface__intracellular_sodium_concentration__Na_i;
            const double var_x41 = 3.7433890822745477e-5 * var_x40;
            const double var_x42 = exp(3.7433890822745473 - 0.074867781645490947 * var_chaste_interface__membrane__V);
            const double var_x43 = 1.0 - var_x42;
            const double var_x44 = 1 / var_x43;
            const double var_x45 = exp(3.7433890822745473);
            const double var_x46 = -2.0 * var_x42 + var_x45 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x47 = var_x44 * var_x46;
            const double var_x48 = 0.014973556329098189 * var_x47;
            const double var_x49 = -4.0 * var_x33 + var_x39 * var_chaste_interface__intracellular_potassium_concentration__K_i;
            const double var_x50 = 7.4867781645490951e-6 * var_x49;
            const double var_x51 = -50.0 + var_chaste_interface__membrane__V;
            const double var_x52 = var_x37 * var_x51;
            const double var_x53 = var_x44 * var_x52;
            const double var_x54 = var_x42 * var_x53;
            const double var_x55 = var_x38 * var_x51;
            const double var_x56 = var_x33 * var_x55;
            const double var_x57 = var_x42 * var_x46 * var_x52 / pow(var_x43, 2);
            const double var_x58 = var_x33 * var_x52 / pow(var_x34, 2);
            const double var_x59 = var_x49 * var_x58;
            const double var_x60 = var_x40 * var_x58;
            const double var_x61 = 1 / mParameters[0];
            const double var_x62 = 0.001 * var_x61;
            
            partialF = -var_x62 * (0.00084999999999999995 + var_x14 + 2.5 * var_x16 + 0.00050000000000000001 * var_x29 + 0.0040000000000000001 * var_x3 + 0.0025999999999999999 * var_x4 + 0.0050000000000000001 * var_x17 + 0.00049950000000000005 * var_x25 + 4.9999999999999998e-7 * var_x27 + 0.14285714285714285 * var_x9 + 0.0022420738914067642 * var_x54 + 0.00019730250244379526 * var_x56 - 0.044642857142857144 * var_x32 - 0.0011210369457033821 * var_x57 - 2.8025923642584553e-7 * var_x59 - 1.4012961821292277e-6 * var_x60 - 0.0066846233612045487 * var_x31 + var_x37 * var_x48 + var_x38 * var_x41 + var_x38 * var_x50);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_channel_f2_gate__f2 = rY[9];
        // Units: dimensionless; Initial value: 0.9349197
        double var_chaste_interface__calcium_release__ActFrac = rY[13];
        // Units: dimensionless; Initial value: 0.0042614
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[15];
        // Units: millimolar; Initial value: 7.3321223
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[17];
        // Units: millimolar; Initial value: 1.88e-05
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[18];
        // Units: millimolar; Initial value: 0.4531889
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[19];
        // Units: millimolar; Initial value: 0.4481927
        double var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod = rY[20];
        // Units: millimolar; Initial value: 0.0005555
        double var_chaste_interface__intracellular_calcium_concentration__Ca_Trop = rY[21];
        // Units: millimolar; Initial value: 0.0003542
        
        
        // Mathematics
        const double var_L_type_Ca_channel__FrICa = 1.0; // dimensionless
        const double var_L_type_Ca_channel__P_Ca_L = 0.10000000000000001; // nanoA_per_millimolar
        const double var_calcium_background_current__g_bca = 0.00025000000000000001; // microS
        const double var_calcium_release__K_leak_rate = 0.050000000000000003; // per_second
        const double var_calcium_release__K_m_rel = 250.0; // per_second
        const double var_extracellular_calcium_concentration__Ca_o = 2.0; // millimolar
        const double var_extracellular_sodium_concentration__Na_o = 140.0; // millimolar
        const double var_calcium_release__i_rel = (pow(var_chaste_interface__calcium_release__ActFrac, 2) * var_calcium_release__K_m_rel / pow((0.25 + var_chaste_interface__calcium_release__ActFrac), 2) + var_calcium_release__K_leak_rate) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel; // millimolar_per_second
        const double var_intracellular_calcium_concentration__Calmod = 0.02; // millimolar
        const double var_intracellular_calcium_concentration__Kdecay = 10.0; // per_second
        const double var_intracellular_calcium_concentration__Trop = 0.050000000000000003; // millimolar
        const double var_intracellular_calcium_concentration__V_ds_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_calcium_concentration__V_e_ratio = 0.40000000000000002; // dimensionless
        const double var_intracellular_calcium_concentration__V_rel_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_calcium_concentration__V_up_ratio = 0.01; // dimensionless
        const double var_intracellular_calcium_concentration__V_i_ratio = 1.0 - var_intracellular_calcium_concentration__V_e_ratio - var_intracellular_calcium_concentration__V_rel_ratio - var_intracellular_calcium_concentration__V_up_ratio; // dimensionless
        const double var_intracellular_calcium_concentration__alpha_Calmod = 100000.0; // per_millimolar_second
        const double var_intracellular_calcium_concentration__alpha_Trop = 100000.0; // per_millimolar_second
        const double var_intracellular_calcium_concentration__beta_Calmod = 50.0; // per_second
        const double var_intracellular_calcium_concentration__Ca_Calmod_orig_deriv = -var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod * var_intracellular_calcium_concentration__beta_Calmod + (-var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod + var_intracellular_calcium_concentration__Calmod) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_intracellular_calcium_concentration__alpha_Calmod; // millimolar / second
        const double var_intracellular_calcium_concentration__beta_Trop = 200.0; // per_second
        const double var_intracellular_calcium_concentration__Ca_Trop_orig_deriv = -var_chaste_interface__intracellular_calcium_concentration__Ca_Trop * var_intracellular_calcium_concentration__beta_Trop + (-var_chaste_interface__intracellular_calcium_concentration__Ca_Trop + var_intracellular_calcium_concentration__Trop) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_intracellular_calcium_concentration__alpha_Trop; // millimolar / second
        const double var_intracellular_calcium_concentration__length = 0.073999999999999996; // micrometre
        const double var_intracellular_calcium_concentration__radius = 0.012; // micrometre
        const double var_intracellular_calcium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_calcium_concentration__radius, 2) * var_intracellular_calcium_concentration__length; // micrometre3
        const double var_intracellular_calcium_concentration__V_i = var_intracellular_calcium_concentration__V_Cell * var_intracellular_calcium_concentration__V_i_ratio; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca_cyt = 4.0 * (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_extracellular_calcium_concentration__Ca_o / var_chaste_interface__intracellular_calcium_concentration__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // nanoA
        const double var_sarcoplasmic_reticulum_calcium_pump__K_cyca = 0.00029999999999999997; // millimolar
        const double var_sarcoplasmic_reticulum_calcium_pump__K_srca = 0.5; // millimolar
        const double var_sarcoplasmic_reticulum_calcium_pump__K_xcs = 0.40000000000000002; // dimensionless
        const double var_sarcoplasmic_reticulum_calcium_pump__K_1 = var_sarcoplasmic_reticulum_calcium_pump__K_cyca * var_sarcoplasmic_reticulum_calcium_pump__K_xcs / var_sarcoplasmic_reticulum_calcium_pump__K_srca; // dimensionless
        const double var_sarcoplasmic_reticulum_calcium_pump__K_2 = var_chaste_interface__intracellular_calcium_concentration__Ca_up * var_sarcoplasmic_reticulum_calcium_pump__K_1 + var_sarcoplasmic_reticulum_calcium_pump__K_cyca * var_sarcoplasmic_reticulum_calcium_pump__K_xcs + var_chaste_interface__intracellular_calcium_concentration__Ca_i + var_sarcoplasmic_reticulum_calcium_pump__K_cyca; // millimolar
        const double var_sarcoplasmic_reticulum_calcium_pump__alpha_up = 0.40000000000000002; // millimolar_per_second
        const double var_sarcoplasmic_reticulum_calcium_pump__beta_up = 0.029999999999999999; // millimolar_per_second
        const double var_sarcoplasmic_reticulum_calcium_pump__i_up = var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_sarcoplasmic_reticulum_calcium_pump__alpha_up / var_sarcoplasmic_reticulum_calcium_pump__K_2 - var_chaste_interface__intracellular_calcium_concentration__Ca_up * var_sarcoplasmic_reticulum_calcium_pump__K_1 * var_sarcoplasmic_reticulum_calcium_pump__beta_up / var_sarcoplasmic_reticulum_calcium_pump__K_2; // millimolar_per_second
        const double var_sodium_calcium_exchanger__FRiNaCa = 0.001; // dimensionless
        const double var_sodium_calcium_exchanger__d_NaCa = 0; // dimensionless
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa = 0.00050000000000000001; // nanoA
        const double var_sodium_calcium_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa_cyt = (1.0 - var_sodium_calcium_exchanger__FRiNaCa) * (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa_ds = (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__FRiNaCa * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_ds + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_intracellular_calcium_concentration__Ca_i_orig_deriv = -var_intracellular_calcium_concentration__Ca_Calmod_orig_deriv - var_intracellular_calcium_concentration__Ca_Trop_orig_deriv - var_sarcoplasmic_reticulum_calcium_pump__i_up + var_calcium_release__i_rel * var_intracellular_calcium_concentration__V_rel_ratio / var_intracellular_calcium_concentration__V_i_ratio + var_chaste_interface__intracellular_calcium_concentration__Ca_ds * var_intracellular_calcium_concentration__Kdecay * var_intracellular_calcium_concentration__V_ds_ratio - 0.5 * (-2.0 * var_sodium_calcium_exchanger__i_NaCa_cyt - 2.0 * var_sodium_calcium_exchanger__i_NaCa_ds + var_L_type_Ca_channel__i_Ca_L_Ca_cyt + var_calcium_background_current__i_b_Ca) / (var_intracellular_calcium_concentration__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_i = 0.001 * var_intracellular_calcium_concentration__Ca_i_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_i;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 1.4e-05
            double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[15];
            // Units: millimolar; Initial value: 7.3321223
            double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[18];
            // Units: millimolar; Initial value: 0.4531889
            double var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod = rY[20];
            // Units: millimolar; Initial value: 0.0005555
            double var_chaste_interface__intracellular_calcium_concentration__Ca_Trop = rY[21];
            // Units: millimolar; Initial value: 0.0003542
            
            const double var_x18 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i);
            const double var_x19 = 0.018716945411372737 * var_chaste_interface__membrane__V;
            const double var_x20 = exp(var_x19);
            const double var_x21 = var_x20 * pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 3.0);
            const double var_x23 = exp(-var_x19);
            const double var_x63 = 1 / var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x64 = var_x18 * var_x23;
            const double var_x65 = 2.0 * var_x21;
            const double var_x66 = 2744000.0 * var_x23;
            const double var_x67 = (var_x65 - var_x66 * var_chaste_interface__intracellular_calcium_concentration__Ca_i) / pow((0.0068999999999999999 + var_chaste_interface__intracellular_calcium_concentration__Ca_i), 2);
            const double var_x100 = 100.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod;
            const double var_x101 = 100.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_Trop;
            const double var_x102 = 0.00041999999999999996 + 0.00023999999999999998 * var_chaste_interface__intracellular_calcium_concentration__Ca_up + var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x103 = 1 / var_x102;
            const double var_x104 = pow(var_x102, (-2));
            const double var_x105 = var_x104 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x106 = var_x104 * var_chaste_interface__intracellular_calcium_concentration__Ca_up;
            
            partialF = -7.0 + var_x100 + var_x101 + 0.00040000000000000002 * var_x105 - 0.00040000000000000002 * var_x103 - 1.0549054718227806e-6 * var_x63 - 0.86600040807582024 * var_x64 - 2.1776249328437171e-9 * var_x67 - 7.1999999999999991e-9 * var_x106;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 = rY[2];
        // Units: dimensionless; Initial value: 1.03e-05
        
        
        // Mathematics
        const double var_rapid_delayed_rectifier_potassium_current_xr1_gate__alpha_xr1 = 50.0 / (1.0 + exp(0.55555555555555558 - 0.1111111111111111 * var_chaste_interface__membrane__V)); // per_second
        const double var_rapid_delayed_rectifier_potassium_current_xr1_gate__beta_xr1 = 0.050000000000000003 * exp(1.3333333333333333 - 0.066666666666666666 * var_chaste_interface__membrane__V); // per_second
        const double var_rapid_delayed_rectifier_potassium_current_xr1_gate__xr1_orig_deriv = (1.0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1) * var_rapid_delayed_rectifier_potassium_current_xr1_gate__alpha_xr1 - var_rapid_delayed_rectifier_potassium_current_xr1_gate__beta_xr1 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 = 0.001 * var_rapid_delayed_rectifier_potassium_current_xr1_gate__xr1_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current_xr1_gate__xr1;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x114 = exp(1.3333333333333333 - 0.066666666666666666 * var_chaste_interface__membrane__V);
            const double var_x115 = -0.1111111111111111 * var_chaste_interface__membrane__V;
            const double var_x116 = exp(0.55555555555555558 + var_x115);
            const double var_x117 = 1.0 + var_x116;
            const double var_x119 = -0.050000000000000003 / var_x117;
            
            partialF = var_x119 - 5.0000000000000002e-5 * var_x114;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2 = rY[3];
        // Units: dimensionless; Initial value: 2e-07
        
        
        // Mathematics
        const double var_rapid_delayed_rectifier_potassium_current_xr2_gate__alpha_xr2 = 50.0 / (1.0 + exp(0.55555555555555558 - 0.1111111111111111 * var_chaste_interface__membrane__V)); // per_second
        const double var_rapid_delayed_rectifier_potassium_current_xr2_gate__beta_xr2 = 0.40000000000000002 * exp(-pow((1.0 + 0.033333333333333333 * var_chaste_interface__membrane__V), 3)); // per_second
        const double var_rapid_delayed_rectifier_potassium_current_xr2_gate__xr2_orig_deriv = (1.0 - var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2) * var_rapid_delayed_rectifier_potassium_current_xr2_gate__alpha_xr2 - var_rapid_delayed_rectifier_potassium_current_xr2_gate__beta_xr2 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current_xr2_gate__xr2 = 0.001 * var_rapid_delayed_rectifier_potassium_current_xr2_gate__xr2_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current_xr2_gate__xr2;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x115 = -0.1111111111111111 * var_chaste_interface__membrane__V;
            const double var_x116 = exp(0.55555555555555558 + var_x115);
            const double var_x117 = 1.0 + var_x116;
            const double var_x119 = -0.050000000000000003 / var_x117;
            const double var_x120 = 1.0 + 0.033333333333333333 * var_chaste_interface__membrane__V;
            const double var_x121 = exp(-pow(var_x120, 3));
            
            partialF = var_x119 - 0.00040000000000000002 * var_x121;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs = rY[4];
        // Units: dimensionless; Initial value: 0.001302
        
        
        // Mathematics
        const double var_slow_delayed_rectifier_potassium_current_xs_gate__alpha_xs = 14.0 / (1.0 + exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V)); // per_second
        const double var_slow_delayed_rectifier_potassium_current_xs_gate__beta_xs = exp(-0.022222222222222223 * var_chaste_interface__membrane__V); // per_second
        const double var_slow_delayed_rectifier_potassium_current_xs_gate__xs_orig_deriv = (1.0 - var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs) * var_slow_delayed_rectifier_potassium_current_xs_gate__alpha_xs - var_slow_delayed_rectifier_potassium_current_xs_gate__beta_xs * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs; // 1 / second
        const double d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current_xs_gate__xs = 0.001 * var_slow_delayed_rectifier_potassium_current_xs_gate__xs_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current_xs_gate__xs;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x115 = -0.1111111111111111 * var_chaste_interface__membrane__V;
            const double var_x122 = exp(-0.022222222222222223 * var_chaste_interface__membrane__V);
            const double var_x123 = exp(4.4444444444444446 + var_x115);
            const double var_x124 = 1.0 + var_x123;
            
            partialF = -0.001 * var_x122 - 0.014 / var_x124;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
        // Units: dimensionless; Initial value: 0.0016203
        
        
        // Mathematics
        const double var_fast_sodium_current_m_gate__delta_m = 1.0000000000000001e-5; // millivolt
        const double var_fast_sodium_current_m_gate__E0_m = 41.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_fast_sodium_current_m_gate__alpha_m = ((var_fast_sodium_current_m_gate__delta_m > fabs(var_fast_sodium_current_m_gate__E0_m)) ? (2000.0) : (200.0 * var_fast_sodium_current_m_gate__E0_m / (1.0 - exp(-0.10000000000000001 * var_fast_sodium_current_m_gate__E0_m)))); // per_second
        const double var_fast_sodium_current_m_gate__beta_m = 8000.0 * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V); // per_second
        const double var_fast_sodium_current_m_gate__m_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m * var_chaste_interface__fast_sodium_current_m_gate__m; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * var_fast_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x125 = 41.0 + var_chaste_interface__membrane__V;
            const double var_x126 = fabs(var_x125) < 1.0000000000000001e-5;
            const double var_x127 = -0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x128 = exp(-4.1000000000000005 + var_x127);
            const double var_x129 = 1.0 - var_x128;
            const double var_x130 = 200.0 / var_x129;
            const double var_x131 = exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V);
            
            partialF = -8.0 * var_x131 - 0.001 * ((var_x126) ? (2000.0) : (var_x125 * var_x130));
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
        // Units: dimensionless; Initial value: 0.9944036
        
        
        // Mathematics
        const double var_fast_sodium_current_h_gate__shift_h = 0; // millivolt
        const double var_fast_sodium_current_h_gate__alpha_h = 20.0 * exp(-9.375 + 0.125 * var_fast_sodium_current_h_gate__shift_h - 0.125 * var_chaste_interface__membrane__V); // per_second
        const double var_fast_sodium_current_h_gate__beta_h = 2000.0 / (1.0 + 320.0 * exp(-7.5 + 0.10000000000000001 * var_fast_sodium_current_h_gate__shift_h - 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_second
        const double var_fast_sodium_current_h_gate__h_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_h_gate__h) * var_fast_sodium_current_h_gate__alpha_h - var_fast_sodium_current_h_gate__beta_h * var_chaste_interface__fast_sodium_current_h_gate__h; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = 0.001 * var_fast_sodium_current_h_gate__h_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x0 = -0.125 * var_chaste_interface__membrane__V;
            const double var_x127 = -0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x132 = exp(-9.375 + var_x0);
            const double var_x133 = exp(-7.5 + var_x127);
            
            partialF = -2.0 / (1.0 + 320.0 * var_x133) - 0.02 * var_x132;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_L_type_Ca_channel_d_gate__speed_d = 3.0; // dimensionless
        const double var_L_type_Ca_channel_d_gate__E0_d = 19.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_L_type_Ca_channel_d_gate__alpha_d = ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 0.0001) ? (120.0) : (30.0 * var_L_type_Ca_channel_d_gate__E0_d / (1.0 - exp(-0.25 * var_L_type_Ca_channel_d_gate__E0_d)))); // per_second
        const double var_L_type_Ca_channel_d_gate__beta_d = ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 0.0001) ? (120.0) : (12.0 * var_L_type_Ca_channel_d_gate__E0_d / (-1.0 + exp(0.10000000000000001 * var_L_type_Ca_channel_d_gate__E0_d)))); // per_second
        const double var_L_type_Ca_channel_d_gate__d_orig_deriv = ((1.0 - var_chaste_interface__L_type_Ca_channel_d_gate__d) * var_L_type_Ca_channel_d_gate__alpha_d - var_L_type_Ca_channel_d_gate__beta_d * var_chaste_interface__L_type_Ca_channel_d_gate__d) * var_L_type_Ca_channel_d_gate__speed_d; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d = 0.001 * var_L_type_Ca_channel_d_gate__d_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x135 = 19.0 + var_chaste_interface__membrane__V;
            const double var_x136 = fabs(var_x135) < 0.0001;
            const double var_x137 = 0.25 * var_chaste_interface__membrane__V;
            const double var_x138 = -var_x137;
            const double var_x139 = exp(-4.75 + var_x138);
            const double var_x140 = 1.0 - var_x139;
            const double var_x141 = 30.0 / var_x140;
            const double var_x142 = exp(1.8999999999999999 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x143 = -1.0 + var_x142;
            const double var_x144 = 12.0 / var_x143;
            
            partialF = -0.0030000000000000001 * ((var_x136) ? (120.0) : (var_x135 * var_x141)) - 0.0030000000000000001 * ((var_x136) ? (120.0) : (var_x135 * var_x144));
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        
        
        // Mathematics
        const double var_L_type_Ca_channel_f_gate__delta_f = 0.0001; // millivolt
        const double var_L_type_Ca_channel_f_gate__speed_f = 0.29999999999999999; // dimensionless
        const double var_L_type_Ca_channel_f_gate__E0_f = 34.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_L_type_Ca_channel_f_gate__alpha_f = ((var_L_type_Ca_channel_f_gate__delta_f > fabs(var_L_type_Ca_channel_f_gate__E0_f)) ? (25.0) : (6.25 * var_L_type_Ca_channel_f_gate__E0_f / (-1.0 + exp(0.25 * var_L_type_Ca_channel_f_gate__E0_f)))); // per_second
        const double var_L_type_Ca_channel_f_gate__beta_f = 12.0 / (1.0 + exp(-8.5 - 0.25 * var_chaste_interface__membrane__V)); // per_second
        const double var_L_type_Ca_channel_f_gate__f_orig_deriv = ((1.0 - var_chaste_interface__L_type_Ca_channel_f_gate__f) * var_L_type_Ca_channel_f_gate__alpha_f - var_L_type_Ca_channel_f_gate__beta_f * var_chaste_interface__L_type_Ca_channel_f_gate__f) * var_L_type_Ca_channel_f_gate__speed_f; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f = 0.001 * var_L_type_Ca_channel_f_gate__f_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x137 = 0.25 * var_chaste_interface__membrane__V;
            const double var_x138 = -var_x137;
            const double var_x145 = 34.0 + var_chaste_interface__membrane__V;
            const double var_x146 = fabs(var_x145) < 0.0001;
            const double var_x147 = exp(8.5 + var_x137);
            const double var_x148 = -1.0 + var_x147;
            const double var_x149 = 6.25 / var_x148;
            const double var_x150 = exp(-8.5 + var_x138);
            const double var_x151 = 1.0 + var_x150;
            
            partialF = -0.00029999999999999997 * ((var_x146) ? (25.0) : (var_x145 * var_x149)) - 0.0035999999999999999 / var_x151;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__L_type_Ca_channel_f2_gate__f2 = rY[9];
        // Units: dimensionless; Initial value: 0.9349197
        
        
        // Mathematics
        const double var_L_type_Ca_channel__Km_f2 = 100000.0; // millimolar
        const double var_L_type_Ca_channel_f2_gate__f2_orig_deriv = 1.0 - 1.0 * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 - 1.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i / (var_L_type_Ca_channel__Km_f2 + var_chaste_interface__intracellular_calcium_concentration__Ca_i); // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f2_gate__f2 = 0.001 * var_L_type_Ca_channel_f2_gate__f2_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_f2_gate__f2;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.001;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[10];
        // Units: dimensionless; Initial value: 0.9651958
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[17];
        // Units: millimolar; Initial value: 1.88e-05
        
        
        // Mathematics
        const double var_L_type_Ca_channel__Km_f2ds = 0.001; // millimolar
        const double var_L_type_Ca_channel__R_decay = 20.0; // per_second
        const double var_L_type_Ca_channel_f2ds_gate__f2ds_orig_deriv = (1.0 - var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds - var_chaste_interface__intracellular_calcium_concentration__Ca_ds / (var_L_type_Ca_channel__Km_f2ds + var_chaste_interface__intracellular_calcium_concentration__Ca_ds)) * var_L_type_Ca_channel__R_decay; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f2ds_gate__f2ds = 0.001 * var_L_type_Ca_channel_f2ds_gate__f2ds_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_f2ds_gate__f2ds;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.02;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
        // Units: dimensionless; Initial value: 0.9948645
        
        
        // Mathematics
        const double var_transient_outward_current_s_gate__alpha_s = 0.033000000000000002 * exp(-0.058823529411764705 * var_chaste_interface__membrane__V); // per_second
        const double var_transient_outward_current_s_gate__beta_s = 33.0 / (1.0 + exp(-1.25 - 0.125 * var_chaste_interface__membrane__V)); // per_second
        const double var_transient_outward_current_s_gate__s_orig_deriv = (1.0 - var_chaste_interface__transient_outward_current_s_gate__s) * var_transient_outward_current_s_gate__alpha_s - var_transient_outward_current_s_gate__beta_s * var_chaste_interface__transient_outward_current_s_gate__s; // 1 / second
        const double d_dt_chaste_interface_var_transient_outward_current_s_gate__s = 0.001 * var_transient_outward_current_s_gate__s_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_transient_outward_current_s_gate__s;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x0 = -0.125 * var_chaste_interface__membrane__V;
            const double var_x153 = exp(-0.058823529411764705 * var_chaste_interface__membrane__V);
            const double var_x154 = exp(-1.25 + var_x0);
            const double var_x155 = 1.0 + var_x154;
            
            partialF = -0.033000000000000002 / var_x155 - 3.3000000000000003e-5 * var_x153;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_transient_outward_current_r_gate__r_orig_deriv = 333.0 / (1.0 + exp(-0.80000000000000004 - 0.20000000000000001 * var_chaste_interface__membrane__V)) - 333.0 * var_chaste_interface__transient_outward_current_r_gate__r; // 1 / second
        const double d_dt_chaste_interface_var_transient_outward_current_r_gate__r = 0.001 * var_transient_outward_current_r_gate__r_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_transient_outward_current_r_gate__r;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.33300000000000002;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__calcium_release__ActFrac = rY[13];
        // Units: dimensionless; Initial value: 0.0042614
        double var_chaste_interface__calcium_release__ProdFrac = rY[14];
        // Units: dimensionless; Initial value: 0.4068154
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[17];
        // Units: millimolar; Initial value: 1.88e-05
        
        
        // Mathematics
        const double var_calcium_release__K_m_Ca_cyt = 0.00050000000000000001; // millimolar
        const double var_calcium_release__K_m_Ca_ds = 0.01; // millimolar
        const double var_calcium_release__PrecFrac = 1.0 - var_chaste_interface__calcium_release__ActFrac - var_chaste_interface__calcium_release__ProdFrac; // dimensionless
        const double var_calcium_release__CadsReg = var_chaste_interface__intracellular_calcium_concentration__Ca_ds / (var_calcium_release__K_m_Ca_ds + var_chaste_interface__intracellular_calcium_concentration__Ca_ds); // dimensionless
        const double var_calcium_release__CaiReg = var_chaste_interface__intracellular_calcium_concentration__Ca_i / (var_calcium_release__K_m_Ca_cyt + var_chaste_interface__intracellular_calcium_concentration__Ca_i); // dimensionless
        const double var_calcium_release__RegBindSite = (1.0 - var_calcium_release__CaiReg) * var_calcium_release__CadsReg + var_calcium_release__CaiReg; // dimensionless
        const double var_calcium_release__ActRate = 500.0 * pow(var_calcium_release__RegBindSite, 2); // per_second
        const double var_calcium_release__InactRate = 60.0 + 500.0 * pow(var_calcium_release__RegBindSite, 2); // per_second
        const double var_calcium_release__SpeedRel = ((var_chaste_interface__membrane__V < -50.0) ? (5.0) : (1.0)); // dimensionless
        const double var_calcium_release__ActFrac_orig_deriv = var_calcium_release__ActRate * var_calcium_release__PrecFrac * var_calcium_release__SpeedRel - var_chaste_interface__calcium_release__ActFrac * var_calcium_release__InactRate * var_calcium_release__SpeedRel; // 1 / second
        const double d_dt_chaste_interface_var_calcium_release__ActFrac = 0.001 * var_calcium_release__ActFrac_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_calcium_release__ActFrac;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 1.4e-05
            double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[17];
            // Units: millimolar; Initial value: 1.88e-05
            
            const double var_x158 = 0.00050000000000000001 + var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x159 = 1 / var_x158;
            const double var_x161 = 0.01 + var_chaste_interface__intracellular_calcium_concentration__Ca_ds;
            const double var_x162 = 1 / var_x161;
            const double var_x164 = ((var_chaste_interface__membrane__V < -50.0) ? (5.0) : (1.0));
            const double var_x165 = var_x159 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x166 = 1.0 - var_x165;
            const double var_x167 = var_x162 * var_x166;
            const double var_x168 = var_x165 + var_x167 * var_chaste_interface__intracellular_calcium_concentration__Ca_ds;
            const double var_x172 = 0.5 * pow(var_x168, 2);
            const double var_x173 = -var_x164 * var_x172;
            
            partialF = var_x173 + var_x164 * (-0.059999999999999998 - var_x172);
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__calcium_release__ActFrac = rY[13];
        // Units: dimensionless; Initial value: 0.0042614
        double var_chaste_interface__calcium_release__ProdFrac = rY[14];
        // Units: dimensionless; Initial value: 0.4068154
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[17];
        // Units: millimolar; Initial value: 1.88e-05
        
        
        // Mathematics
        const double var_calcium_release__K_m_Ca_cyt = 0.00050000000000000001; // millimolar
        const double var_calcium_release__K_m_Ca_ds = 0.01; // millimolar
        const double var_calcium_release__CadsReg = var_chaste_interface__intracellular_calcium_concentration__Ca_ds / (var_calcium_release__K_m_Ca_ds + var_chaste_interface__intracellular_calcium_concentration__Ca_ds); // dimensionless
        const double var_calcium_release__CaiReg = var_chaste_interface__intracellular_calcium_concentration__Ca_i / (var_calcium_release__K_m_Ca_cyt + var_chaste_interface__intracellular_calcium_concentration__Ca_i); // dimensionless
        const double var_calcium_release__RegBindSite = (1.0 - var_calcium_release__CaiReg) * var_calcium_release__CadsReg + var_calcium_release__CaiReg; // dimensionless
        const double var_calcium_release__InactRate = 60.0 + 500.0 * pow(var_calcium_release__RegBindSite, 2); // per_second
        const double var_calcium_release__SpeedRel = ((var_chaste_interface__membrane__V < -50.0) ? (5.0) : (1.0)); // dimensionless
        const double var_calcium_release__ProdFrac_orig_deriv = -1.0 * var_chaste_interface__calcium_release__ProdFrac * var_calcium_release__SpeedRel + var_chaste_interface__calcium_release__ActFrac * var_calcium_release__InactRate * var_calcium_release__SpeedRel; // 1 / second
        const double d_dt_chaste_interface_var_calcium_release__ProdFrac = 0.001 * var_calcium_release__ProdFrac_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_calcium_release__ProdFrac;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            
            const double var_x164 = ((var_chaste_interface__membrane__V < -50.0) ? (5.0) : (1.0));
            
            partialF = -0.001 * var_x164;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative15(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
        // Units: dimensionless; Initial value: 0.0016203
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
        // Units: dimensionless; Initial value: 0.9944036
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_channel_f2_gate__f2 = rY[9];
        // Units: dimensionless; Initial value: 0.9349197
        double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[10];
        // Units: dimensionless; Initial value: 0.9651958
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[15];
        // Units: millimolar; Initial value: 7.3321223
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[16];
        // Units: millimolar; Initial value: 136.5644281
        
        
        // Mathematics
        const double var_L_type_Ca_channel__FrICa = 1.0; // dimensionless
        const double var_L_type_Ca_channel__P_CaNa = 0.01; // dimensionless
        const double var_L_type_Ca_channel__P_Ca_L = 0.10000000000000001; // nanoA_per_millimolar
        const double var_extracellular_calcium_concentration__Ca_o = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__K_o = 4.0; // millimolar
        const double var_extracellular_sodium_concentration__Na_o = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 2.5; // microS
        const double var_intracellular_calcium_concentration__V_e_ratio = 0.40000000000000002; // dimensionless
        const double var_intracellular_calcium_concentration__V_rel_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_calcium_concentration__V_up_ratio = 0.01; // dimensionless
        const double var_intracellular_calcium_concentration__V_i_ratio = 1.0 - var_intracellular_calcium_concentration__V_e_ratio - var_intracellular_calcium_concentration__V_rel_ratio - var_intracellular_calcium_concentration__V_up_ratio; // dimensionless
        const double var_intracellular_calcium_concentration__length = 0.073999999999999996; // micrometre
        const double var_intracellular_calcium_concentration__radius = 0.012; // micrometre
        const double var_intracellular_calcium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_calcium_concentration__radius, 2) * var_intracellular_calcium_concentration__length; // micrometre3
        const double var_intracellular_calcium_concentration__V_i = var_intracellular_calcium_concentration__V_Cell * var_intracellular_calcium_concentration__V_i_ratio; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Na_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_Na_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Na_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_sodium_concentration__Na_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaNa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_persistent_sodium_current__g_pna = 0.0040000000000000001; // microS
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_extracellular_sodium_concentration__Na_o / var_chaste_interface__intracellular_sodium_concentration__Na_i) / var_membrane__F; // millivolt
        const double var_persistent_sodium_current__i_p_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_persistent_sodium_current__g_pna / (1.0 + exp(-6.5 - 0.125 * var_chaste_interface__membrane__V)); // nanoA
        const double var_reversal_potentials__E_mh = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o + 0.12 * var_extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_sodium_background_current__g_bna = 0.00059999999999999995; // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // nanoA
        const double var_sodium_calcium_exchanger__FRiNaCa = 0.001; // dimensionless
        const double var_sodium_calcium_exchanger__d_NaCa = 0; // dimensionless
        const double var_sodium_calcium_exchanger__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa = 0.00050000000000000001; // nanoA
        const double var_sodium_calcium_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_sodium_calcium_exchanger__i_NaCa_cyt = (1.0 - var_sodium_calcium_exchanger__FRiNaCa) * (pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o * exp((-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma / (var_membrane__R * var_membrane__T)) - pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp((-1.0 + var_sodium_calcium_exchanger__gamma) * (-2.0 + var_sodium_calcium_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger__k_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i) * (1.0 + (pow(var_extracellular_sodium_concentration__Na_o, var_sodium_calcium_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_i + pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, var_sodium_calcium_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Ca_o) * var_sodium_calcium_exchanger__d_NaCa)); // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.69999999999999996; // nanoA
        const double var_sodium_potassium_pump__i_NaK = var_extracellular_potassium_concentration__K_o * var_chaste_interface__intracellular_sodium_concentration__Na_i * var_sodium_potassium_pump__i_NaK_max / ((var_extracellular_potassium_concentration__K_o + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Na_i + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_intracellular_sodium_concentration__Na_i_orig_deriv = -1.0 * (3.0 * var_sodium_calcium_exchanger__i_NaCa_cyt + 3.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_Ca_L_Na_cyt + var_L_type_Ca_channel__i_Ca_L_Na_ds + var_fast_sodium_current__i_Na + var_persistent_sodium_current__i_p_Na + var_sodium_background_current__i_b_Na) / (var_intracellular_calcium_concentration__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Na_i = 0.001 * var_intracellular_sodium_concentration__Na_i_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_sodium_concentration__Na_i;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative15(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 1.4e-05
            double var_chaste_interface__fast_sodium_current_m_gate__m = rY[5];
            // Units: dimensionless; Initial value: 0.0016203
            double var_chaste_interface__fast_sodium_current_h_gate__h = rY[6];
            // Units: dimensionless; Initial value: 0.9944036
            double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[10];
            // Units: dimensionless; Initial value: 0.9651958
            double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[15];
            // Units: millimolar; Initial value: 7.3321223
            double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[16];
            // Units: millimolar; Initial value: 136.5644281
            
            const double var_x0 = -0.125 * var_chaste_interface__membrane__V;
            const double var_x1 = exp(-6.5 + var_x0);
            const double var_x2 = 1.0 + var_x1;
            const double var_x3 = 1 / var_x2;
            const double var_x15 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
            const double var_x16 = var_x15 * var_chaste_interface__fast_sodium_current_h_gate__h;
            const double var_x18 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Ca_i);
            const double var_x19 = 0.018716945411372737 * var_chaste_interface__membrane__V;
            const double var_x20 = exp(var_x19);
            const double var_x28 = 1 / var_chaste_interface__intracellular_sodium_concentration__Na_i;
            const double var_x33 = exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V);
            const double var_x34 = 1.0 - var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x36 = var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f;
            const double var_x37 = var_x36 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
            const double var_x38 = var_x35 * var_x37;
            const double var_x39 = exp(1.8716945411372736);
            const double var_x51 = -50.0 + var_chaste_interface__membrane__V;
            const double var_x55 = var_x38 * var_x51;
            const double var_x73 = var_chaste_interface__intracellular_sodium_concentration__Na_i + 0.12 * var_chaste_interface__intracellular_potassium_concentration__K_i;
            const double var_x85 = 1 / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Na_i);
            const double var_x86 = var_x28 * var_x3;
            const double var_x87 = var_chaste_interface__intracellular_sodium_concentration__Na_i / pow((1 + 0.025000000000000001 * var_chaste_interface__intracellular_sodium_concentration__Na_i), 2);
            const double var_x88 = var_x20 * pow(var_chaste_interface__intracellular_sodium_concentration__Na_i, 2.0);
            const double var_x91 = var_x18 * var_x88;
            const double var_x92 = var_x16 * (0.00085421412300683362 * var_chaste_interface__intracellular_potassium_concentration__K_i + 0.0071184510250569474 * var_chaste_interface__intracellular_sodium_concentration__Na_i) / pow(var_x73, 2);
            const double var_x93 = var_x39 * var_x55;
            
            partialF = 6.634188331769168e-7 * var_x87 - 6.7513950196657958e-5 * var_x86 - 0.0010614701330830668 * var_x85 - 1.0127092529498693e-5 * var_x28 - 5.6807606943749135e-6 * var_x91 - 5.9277248272665686 * var_x92 - 2.3651760162759904e-8 * var_x93;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative16(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 = rY[2];
        // Units: dimensionless; Initial value: 1.03e-05
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2 = rY[3];
        // Units: dimensionless; Initial value: 2e-07
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs = rY[4];
        // Units: dimensionless; Initial value: 0.001302
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_channel_f2_gate__f2 = rY[9];
        // Units: dimensionless; Initial value: 0.9349197
        double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[10];
        // Units: dimensionless; Initial value: 0.9651958
        double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
        // Units: dimensionless; Initial value: 0.9948645
        double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[15];
        // Units: millimolar; Initial value: 7.3321223
        double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[16];
        // Units: millimolar; Initial value: 136.5644281
        
        
        // Mathematics
        const double var_L_type_Ca_channel__FrICa = 1.0; // dimensionless
        const double var_L_type_Ca_channel__P_CaK = 0.002; // dimensionless
        const double var_L_type_Ca_channel__P_Ca_L = 0.10000000000000001; // nanoA_per_millimolar
        const double var_extracellular_potassium_concentration__K_o = 4.0; // millimolar
        const double var_extracellular_sodium_concentration__Na_o = 140.0; // millimolar
        const double var_intracellular_calcium_concentration__V_e_ratio = 0.40000000000000002; // dimensionless
        const double var_intracellular_calcium_concentration__V_rel_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_calcium_concentration__V_up_ratio = 0.01; // dimensionless
        const double var_intracellular_calcium_concentration__V_i_ratio = 1.0 - var_intracellular_calcium_concentration__V_e_ratio - var_intracellular_calcium_concentration__V_rel_ratio - var_intracellular_calcium_concentration__V_up_ratio; // dimensionless
        const double var_intracellular_calcium_concentration__length = 0.073999999999999996; // micrometre
        const double var_intracellular_calcium_concentration__radius = 0.012; // micrometre
        const double var_intracellular_calcium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_calcium_concentration__radius, 2) * var_intracellular_calcium_concentration__length; // micrometre3
        const double var_intracellular_calcium_concentration__V_i = var_intracellular_calcium_concentration__V_Cell * var_intracellular_calcium_concentration__V_i_ratio; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_K_cyt = (1.0 - var_L_type_Ca_channel__FrICa) * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2_gate__f2 * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L_K_ds = (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__K_i * exp(50.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_potassium_concentration__K_o * exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_CaK * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp((50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr1 = 0.0020999999999999999; // microS
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr2 = 0.0012999999999999999; // microS
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_extracellular_potassium_concentration__K_o / var_chaste_interface__intracellular_potassium_concentration__K_i) / var_membrane__F; // millivolt
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * (var_rapid_delayed_rectifier_potassium_current__g_Kr1 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 + var_rapid_delayed_rectifier_potassium_current__g_Kr2 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2) / (1.0 + exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V)); // nanoA
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_extracellular_sodium_concentration__Na_o * var_reversal_potentials__P_kna + var_extracellular_potassium_concentration__K_o) / (var_chaste_interface__intracellular_sodium_concentration__Na_i * var_reversal_potentials__P_kna + var_chaste_interface__intracellular_potassium_concentration__K_i)) / var_membrane__F; // millivolt
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.0025999999999999999; // microS
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.69999999999999996; // nanoA
        const double var_sodium_potassium_pump__i_NaK = var_extracellular_potassium_concentration__K_o * var_chaste_interface__intracellular_sodium_concentration__Na_i * var_sodium_potassium_pump__i_NaK_max / ((var_extracellular_potassium_concentration__K_o + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Na_i + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_independent_potassium_current__K_mk1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.5; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__K_o * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(1.25 * (-10.0 - var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (var_extracellular_potassium_concentration__K_o + var_time_independent_potassium_current__K_mk1)); // nanoA
        const double var_transient_outward_current__g_to = 0.0050000000000000001; // microS
        const double var_transient_outward_current__g_tos = 0; // dimensionless
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * ((1.0 - var_transient_outward_current__g_tos) * var_chaste_interface__transient_outward_current_s_gate__s + var_transient_outward_current__g_tos) * var_transient_outward_current__g_to * var_chaste_interface__transient_outward_current_r_gate__r; // nanoA
        const double var_intracellular_potassium_concentration__K_i_orig_deriv = -1.0 * (-2.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_Ca_L_K_cyt + var_L_type_Ca_channel__i_Ca_L_K_ds + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_slow_delayed_rectifier_potassium_current__i_Ks + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / (var_intracellular_calcium_concentration__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__K_i = 0.001 * var_intracellular_potassium_concentration__K_i_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_potassium_concentration__K_i;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative16(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -92.849333
            double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1 = rY[2];
            // Units: dimensionless; Initial value: 1.03e-05
            double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2 = rY[3];
            // Units: dimensionless; Initial value: 2e-07
            double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs = rY[4];
            // Units: dimensionless; Initial value: 0.001302
            double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[10];
            // Units: dimensionless; Initial value: 0.9651958
            double var_chaste_interface__transient_outward_current_s_gate__s = rY[11];
            // Units: dimensionless; Initial value: 0.9948645
            double var_chaste_interface__transient_outward_current_r_gate__r = rY[12];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__intracellular_sodium_concentration__Na_i = rY[15];
            // Units: millimolar; Initial value: 7.3321223
            double var_chaste_interface__intracellular_potassium_concentration__K_i = rY[16];
            // Units: millimolar; Initial value: 136.5644281
            
            const double var_x4 = pow(var_chaste_interface__slow_delayed_rectifier_potassium_current_xs_gate__xs, 2);
            const double var_x5 = 1 / var_chaste_interface__intracellular_potassium_concentration__K_i;
            const double var_x6 = log(4.0 * var_x5);
            const double var_x7 = exp(-0.46792363528431841 + 0.046792363528431836 * var_chaste_interface__membrane__V - 1.25 * var_x6);
            const double var_x8 = 1.0 + var_x7;
            const double var_x9 = 1 / var_x8;
            const double var_x10 = exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V);
            const double var_x11 = 1.0 + var_x10;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = 0.0012999999999999999 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr2_gate__xr2 + 0.0020999999999999999 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr1_gate__xr1;
            const double var_x14 = var_x12 * var_x13;
            const double var_x17 = var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s;
            const double var_x30 = -26.713760659695652 * var_x6 + var_chaste_interface__membrane__V;
            const double var_x31 = var_x30 * var_x7 / pow(var_x8, 2);
            const double var_x33 = exp(1.8716945411372736 - 0.037433890822745473 * var_chaste_interface__membrane__V);
            const double var_x34 = 1.0 - var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x36 = var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f;
            const double var_x37 = var_x36 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
            const double var_x38 = var_x35 * var_x37;
            const double var_x39 = exp(1.8716945411372736);
            const double var_x51 = -50.0 + var_chaste_interface__membrane__V;
            const double var_x55 = var_x38 * var_x51;
            const double var_x71 = 0.029999999999999999 * var_chaste_interface__intracellular_sodium_concentration__Na_i + var_chaste_interface__intracellular_potassium_concentration__K_i;
            const double var_x90 = var_x4 * (0.12195121951219512 * var_chaste_interface__intracellular_potassium_concentration__K_i + 0.0036585365853658534 * var_chaste_interface__intracellular_sodium_concentration__Na_i) / pow(var_x71, 2);
            const double var_x93 = var_x39 * var_x55;
            const double var_x94 = var_x5 * var_x9;
            const double var_x95 = var_x14 * var_x5;
            const double var_x96 = var_x17 * var_x5;
            const double var_x97 = var_x31 * var_x5;
            
            partialF = 0.00011282633217294504 * var_x97 - 8.4392437745822447e-5 * var_x96 - 0.016878487549164489 * var_x95 - 0.0024112125070234981 * var_x94 - 4.7303520325519805e-9 * var_x93 - 0.00035984935454818685 * var_x90;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative17(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -92.849333
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = rY[7];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = rY[8];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds = rY[10];
        // Units: dimensionless; Initial value: 0.9651958
        double var_chaste_interface__intracellular_calcium_concentration__Ca_ds = rY[17];
        // Units: millimolar; Initial value: 1.88e-05
        
        
        // Mathematics
        const double var_L_type_Ca_channel__FrICa = 1.0; // dimensionless
        const double var_L_type_Ca_channel__P_Ca_L = 0.10000000000000001; // nanoA_per_millimolar
        const double var_extracellular_calcium_concentration__Ca_o = 2.0; // millimolar
        const double var_intracellular_calcium_concentration__Kdecay = 10.0; // per_second
        const double var_intracellular_calcium_concentration__V_ds_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_calcium_concentration__V_e_ratio = 0.40000000000000002; // dimensionless
        const double var_intracellular_calcium_concentration__V_rel_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_calcium_concentration__V_up_ratio = 0.01; // dimensionless
        const double var_intracellular_calcium_concentration__V_i_ratio = 1.0 - var_intracellular_calcium_concentration__V_e_ratio - var_intracellular_calcium_concentration__V_rel_ratio - var_intracellular_calcium_concentration__V_up_ratio; // dimensionless
        const double var_intracellular_calcium_concentration__length = 0.073999999999999996; // micrometre
        const double var_intracellular_calcium_concentration__radius = 0.012; // micrometre
        const double var_intracellular_calcium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_calcium_concentration__radius, 2) * var_intracellular_calcium_concentration__length; // micrometre3
        const double var_intracellular_calcium_concentration__V_i = var_intracellular_calcium_concentration__V_Cell * var_intracellular_calcium_concentration__V_i_ratio; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca_ds = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Ca_i * exp(100.0 * var_membrane__F / (var_membrane__R * var_membrane__T)) - var_extracellular_calcium_concentration__Ca_o * exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__FrICa * var_L_type_Ca_channel__P_Ca_L * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__L_type_Ca_channel_f2ds_gate__f2ds * var_chaste_interface__L_type_Ca_channel_f_gate__f * var_membrane__F / ((1.0 - exp(2.0 * (50.0 - var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_intracellular_calcium_concentration__Ca_ds_orig_deriv = -var_chaste_interface__intracellular_calcium_concentration__Ca_ds * var_intracellular_calcium_concentration__Kdecay - 0.5 * var_L_type_Ca_channel__i_Ca_L_Ca_ds / (var_intracellular_calcium_concentration__V_ds_ratio * var_intracellular_calcium_concentration__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_ds = 0.001 * var_intracellular_calcium_concentration__Ca_ds_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_ds;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative17(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.01;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative18(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[18];
        // Units: millimolar; Initial value: 0.4531889
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[19];
        // Units: millimolar; Initial value: 0.4481927
        
        
        // Mathematics
        const double var_calcium_translocation__i_trans = 50.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_up - 50.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel; // millimolar_per_second
        const double var_intracellular_calcium_concentration__V_e_ratio = 0.40000000000000002; // dimensionless
        const double var_intracellular_calcium_concentration__V_rel_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_calcium_concentration__V_up_ratio = 0.01; // dimensionless
        const double var_intracellular_calcium_concentration__V_i_ratio = 1.0 - var_intracellular_calcium_concentration__V_e_ratio - var_intracellular_calcium_concentration__V_rel_ratio - var_intracellular_calcium_concentration__V_up_ratio; // dimensionless
        const double var_sarcoplasmic_reticulum_calcium_pump__K_cyca = 0.00029999999999999997; // millimolar
        const double var_sarcoplasmic_reticulum_calcium_pump__K_srca = 0.5; // millimolar
        const double var_sarcoplasmic_reticulum_calcium_pump__K_xcs = 0.40000000000000002; // dimensionless
        const double var_sarcoplasmic_reticulum_calcium_pump__K_1 = var_sarcoplasmic_reticulum_calcium_pump__K_cyca * var_sarcoplasmic_reticulum_calcium_pump__K_xcs / var_sarcoplasmic_reticulum_calcium_pump__K_srca; // dimensionless
        const double var_sarcoplasmic_reticulum_calcium_pump__K_2 = var_chaste_interface__intracellular_calcium_concentration__Ca_up * var_sarcoplasmic_reticulum_calcium_pump__K_1 + var_sarcoplasmic_reticulum_calcium_pump__K_cyca * var_sarcoplasmic_reticulum_calcium_pump__K_xcs + var_chaste_interface__intracellular_calcium_concentration__Ca_i + var_sarcoplasmic_reticulum_calcium_pump__K_cyca; // millimolar
        const double var_sarcoplasmic_reticulum_calcium_pump__alpha_up = 0.40000000000000002; // millimolar_per_second
        const double var_sarcoplasmic_reticulum_calcium_pump__beta_up = 0.029999999999999999; // millimolar_per_second
        const double var_sarcoplasmic_reticulum_calcium_pump__i_up = var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_sarcoplasmic_reticulum_calcium_pump__alpha_up / var_sarcoplasmic_reticulum_calcium_pump__K_2 - var_chaste_interface__intracellular_calcium_concentration__Ca_up * var_sarcoplasmic_reticulum_calcium_pump__K_1 * var_sarcoplasmic_reticulum_calcium_pump__beta_up / var_sarcoplasmic_reticulum_calcium_pump__K_2; // millimolar_per_second
        const double var_intracellular_calcium_concentration__Ca_up_orig_deriv = -var_calcium_translocation__i_trans + var_intracellular_calcium_concentration__V_i_ratio * var_sarcoplasmic_reticulum_calcium_pump__i_up / var_intracellular_calcium_concentration__V_up_ratio; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up = 0.001 * var_intracellular_calcium_concentration__Ca_up_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative18(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 1.4e-05
            double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[18];
            // Units: millimolar; Initial value: 0.4531889
            
            const double var_x102 = 0.00041999999999999996 + 0.00023999999999999998 * var_chaste_interface__intracellular_calcium_concentration__Ca_up + var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x103 = 1 / var_x102;
            const double var_x104 = pow(var_x102, (-2));
            const double var_x105 = var_x104 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x106 = var_x104 * var_chaste_interface__intracellular_calcium_concentration__Ca_up;
            
            partialF = -0.050000000000000003 + 8.4671999999999982e-11 * var_x106 - 3.5279999999999993e-7 * var_x103 - 4.7039999999999993e-6 * var_x105;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative19(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_release__ActFrac = rY[13];
        // Units: dimensionless; Initial value: 0.0042614
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[18];
        // Units: millimolar; Initial value: 0.4531889
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[19];
        // Units: millimolar; Initial value: 0.4481927
        
        
        // Mathematics
        const double var_calcium_release__K_leak_rate = 0.050000000000000003; // per_second
        const double var_calcium_release__K_m_rel = 250.0; // per_second
        const double var_calcium_release__i_rel = (pow(var_chaste_interface__calcium_release__ActFrac, 2) * var_calcium_release__K_m_rel / pow((0.25 + var_chaste_interface__calcium_release__ActFrac), 2) + var_calcium_release__K_leak_rate) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel; // millimolar_per_second
        const double var_calcium_translocation__i_trans = 50.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_up - 50.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel; // millimolar_per_second
        const double var_intracellular_calcium_concentration__V_rel_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_calcium_concentration__V_up_ratio = 0.01; // dimensionless
        const double var_intracellular_calcium_concentration__Ca_rel_orig_deriv = -var_calcium_release__i_rel + var_calcium_translocation__i_trans * var_intracellular_calcium_concentration__V_up_ratio / var_intracellular_calcium_concentration__V_rel_ratio; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel = 0.001 * var_intracellular_calcium_concentration__Ca_rel_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative19(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__calcium_release__ActFrac = rY[13];
            // Units: dimensionless; Initial value: 0.0042614
            
            const double var_x107 = 0.25 + var_chaste_interface__calcium_release__ActFrac;
            const double var_x108 = pow(var_x107, (-2));
            const double var_x110 = pow(var_chaste_interface__calcium_release__ActFrac, 2);
            const double var_x112 = var_x108 * var_x110;
            
            partialF = -0.0050499999999999998 - 0.25 * var_x112;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative20(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod = rY[20];
        // Units: millimolar; Initial value: 0.0005555
        
        
        // Mathematics
        const double var_intracellular_calcium_concentration__Calmod = 0.02; // millimolar
        const double var_intracellular_calcium_concentration__alpha_Calmod = 100000.0; // per_millimolar_second
        const double var_intracellular_calcium_concentration__beta_Calmod = 50.0; // per_second
        const double var_intracellular_calcium_concentration__Ca_Calmod_orig_deriv = -var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod * var_intracellular_calcium_concentration__beta_Calmod + (-var_chaste_interface__intracellular_calcium_concentration__Ca_Calmod + var_intracellular_calcium_concentration__Calmod) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_intracellular_calcium_concentration__alpha_Calmod; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_Calmod = 0.001 * var_intracellular_calcium_concentration__Ca_Calmod_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_Calmod;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative20(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 1.4e-05
            
            const double var_x113 = 100.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x180 = -var_x113;
            
            partialF = -0.050000000000000003 + var_x180;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Cellnoble_model_1998FromCellMLGRL2::EvaluateYDerivative21(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
        // Units: millimolar; Initial value: 1.4e-05
        double var_chaste_interface__intracellular_calcium_concentration__Ca_Trop = rY[21];
        // Units: millimolar; Initial value: 0.0003542
        
        
        // Mathematics
        const double var_intracellular_calcium_concentration__Trop = 0.050000000000000003; // millimolar
        const double var_intracellular_calcium_concentration__alpha_Trop = 100000.0; // per_millimolar_second
        const double var_intracellular_calcium_concentration__beta_Trop = 200.0; // per_second
        const double var_intracellular_calcium_concentration__Ca_Trop_orig_deriv = -var_chaste_interface__intracellular_calcium_concentration__Ca_Trop * var_intracellular_calcium_concentration__beta_Trop + (-var_chaste_interface__intracellular_calcium_concentration__Ca_Trop + var_intracellular_calcium_concentration__Trop) * var_chaste_interface__intracellular_calcium_concentration__Ca_i * var_intracellular_calcium_concentration__alpha_Trop; // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_Trop = 0.001 * var_intracellular_calcium_concentration__Ca_Trop_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_Trop;
    }

    double Cellnoble_model_1998FromCellMLGRL2::EvaluatePartialDerivative21(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_calcium_concentration__Ca_i = rY[1];
            // Units: millimolar; Initial value: 1.4e-05
            
            const double var_x113 = 100.0 * var_chaste_interface__intracellular_calcium_concentration__Ca_i;
            const double var_x180 = -var_x113;
            
            partialF = -0.20000000000000001 + var_x180;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }

    std::vector<double> Cellnoble_model_1998FromCellMLGRL2::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellnoble_model_1998FromCellMLGRL2>::Initialise(void)
{
    this->mSystemName = "noble_model_1998";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-92.849333);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.4e-05);

    // rY[2]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current_xr1_gate__xr1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.03e-05);

    // rY[3]:
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current_xr2_gate__xr2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2e-07);

    // rY[4]:
    this->mVariableNames.push_back("slow_delayed_rectifier_potassium_current_xs_gate__xs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001302);

    // rY[5]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0016203);

    // rY[6]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9944036);

    // rY[7]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[8]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // rY[9]:
    this->mVariableNames.push_back("L_type_Ca_channel_f2_gate__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9349197);

    // rY[10]:
    this->mVariableNames.push_back("L_type_Ca_channel_f2ds_gate__f2ds");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9651958);

    // rY[11]:
    this->mVariableNames.push_back("transient_outward_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9948645);

    // rY[12]:
    this->mVariableNames.push_back("transient_outward_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[13]:
    this->mVariableNames.push_back("calcium_release__ActFrac");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0042614);

    // rY[14]:
    this->mVariableNames.push_back("calcium_release__ProdFrac");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4068154);

    // rY[15]:
    this->mVariableNames.push_back("intracellular_sodium_concentration__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.3321223);

    // rY[16]:
    this->mVariableNames.push_back("intracellular_potassium_concentration__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(136.5644281);

    // rY[17]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_ds");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.88e-05);

    // rY[18]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.4531889);

    // rY[19]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.4481927);

    // rY[20]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_Calmod");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0005555);

    // rY[21]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_Trop");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0003542);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellnoble_model_1998FromCellMLGRL2)
