//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: Noble_SAN_model_1989
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "noble_SAN_model_1989.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    double Cellnoble_SAN_model_1989FromCellMLGRL2::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellnoble_SAN_model_1989FromCellMLGRL2::Cellnoble_SAN_model_1989FromCellMLGRL2(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                14,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellnoble_SAN_model_1989FromCellMLGRL2>::Instance();
        Init();
        
        this->mParameters[0] = 6.0000000000000002e-5; // (var_membrane__C) [microF]
    }

    Cellnoble_SAN_model_1989FromCellMLGRL2::~Cellnoble_SAN_model_1989FromCellMLGRL2()
    {
    }
    
    double Cellnoble_SAN_model_1989FromCellMLGRL2::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        
        const double var_Na_Ca_exchanger__K_NaCa = 2.0000000000000002e-5; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.0001; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__Kc = 3.0; // millimolar
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 0.012500000000000001; // microS
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 0.059999999999999998; // microS
        const double var_hyperpolarising_activated_current__g_f_Na = 0.059999999999999998; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fK = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_f = var_hyperpolarising_activated_current__i_fK + var_hyperpolarising_activated_current__i_fNa; // nanoA
        const double var_second_inward_current__P_si = 0.12; // nanoA_per_millimolar
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_si = var_second_inward_current__i_siCa + var_second_inward_current__i_siK + var_second_inward_current__i_siNa; // nanoA
        const double var_sodium_background_current__g_Nab = 0.00069999999999999999; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 0.45000000000000001; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_dependent_potassium_current__i_K_max = 0.80000000000000004; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.0074999999999999997; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_Na_Ca_exchanger__i_NaCa + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_hyperpolarising_activated_current__i_f + var_second_inward_current__i_si + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_p + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellnoble_SAN_model_1989FromCellMLGRL2::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_Na_Ca_exchanger__K_NaCa = 2.0000000000000002e-5; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.0001; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__Kc = 3.0; // millimolar
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 0.012500000000000001; // microS
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 0.059999999999999998; // microS
        const double var_hyperpolarising_activated_current__g_f_Na = 0.059999999999999998; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fK = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_f = var_hyperpolarising_activated_current__i_fK + var_hyperpolarising_activated_current__i_fNa; // nanoA
        const double var_second_inward_current__P_si = 0.12; // nanoA_per_millimolar
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_si = var_second_inward_current__i_siCa + var_second_inward_current__i_siK + var_second_inward_current__i_siNa; // nanoA
        const double var_sodium_background_current__g_Nab = 0.00069999999999999999; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 0.45000000000000001; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_dependent_potassium_current__i_K_max = 0.80000000000000004; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.0074999999999999997; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_membrane__V_orig_deriv = (-var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_hyperpolarising_activated_current__i_f - var_second_inward_current__i_si - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_p - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1) / mParameters[0]; // millivolt / second
        d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Cellnoble_SAN_model_1989FromCellMLGRL2::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[10];
        // Units: millimolar; Initial value: 2.3909
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[11];
        // Units: millimolar; Initial value: 0.2207
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.237
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        
        
        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_Na_Ca_exchanger__K_NaCa = 2.0000000000000002e-5; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.0001; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__Kc = 3.0; // millimolar
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 0.012500000000000001; // microS
        const double var_fast_sodium_current_m_gate__delta_m = 1.0000000000000001e-5; // millivolt
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 0.059999999999999998; // microS
        const double var_hyperpolarising_activated_current__g_f_Na = 0.059999999999999998; // microS
        const double var_hyperpolarising_activated_current_y_gate__speed_y = 2.0; // dimensionless
        const double var_intracellular_calcium_concentration__Ca_up_max = 5.0; // millimolar
        const double var_intracellular_calcium_concentration__K_mCa = 0.002; // millimolar
        const double var_intracellular_calcium_concentration__rCa = 2.0; // dimensionless
        const double var_intracellular_calcium_concentration__tau_rel = 0.01; // second
        const double var_intracellular_calcium_concentration__tau_rep = 0.20000000000000001; // second
        const double var_intracellular_calcium_concentration__tau_up = 0.0050000000000000001; // second
        const double var_intracellular_sodium_concentration__V_e_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_sodium_concentration__length = 0.028000000000000001; // micrometre
        const double var_intracellular_sodium_concentration__radius = 0.01; // micrometre
        const double var_intracellular_sodium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_sodium_concentration__radius, 2) * var_intracellular_sodium_concentration__length; // micrometre3
        const double var_intracellular_sodium_concentration__Vi = (1.0 - var_intracellular_sodium_concentration__V_e_ratio) * var_intracellular_sodium_concentration__V_Cell; // micrometre3
        const double var_intracellular_calcium_concentration__V_rel = 0.02 * var_intracellular_sodium_concentration__Vi; // micrometre3
        const double var_intracellular_calcium_concentration__V_up = 0.050000000000000003 * var_intracellular_sodium_concentration__Vi; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_intracellular_calcium_concentration__i_rel = 2.0 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, var_intracellular_calcium_concentration__rCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel * var_intracellular_calcium_concentration__V_rel * var_membrane__F / ((pow(var_chaste_interface__intracellular_calcium_concentration__Cai, var_intracellular_calcium_concentration__rCa) + pow(var_intracellular_calcium_concentration__K_mCa, var_intracellular_calcium_concentration__rCa)) * var_intracellular_calcium_concentration__tau_rel); // nanoA
        const double var_intracellular_calcium_concentration__i_tr = 2.0 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_rel + var_chaste_interface__intracellular_calcium_concentration__Ca_up) * var_intracellular_calcium_concentration__V_rel * var_chaste_interface__intracellular_calcium_concentration__p * var_membrane__F / var_intracellular_calcium_concentration__tau_rep; // nanoA
        const double var_intracellular_calcium_concentration__Ca_rel_orig_deriv = 0.5 * (-var_intracellular_calcium_concentration__i_rel + var_intracellular_calcium_concentration__i_tr) / (var_intracellular_calcium_concentration__V_rel * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel = 0.001 * var_intracellular_calcium_concentration__Ca_rel_orig_deriv; // millimolar / millisecond
        const double var_intracellular_calcium_concentration__i_up = 2.0 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_up + var_intracellular_calcium_concentration__Ca_up_max) * var_chaste_interface__intracellular_calcium_concentration__Cai * var_intracellular_sodium_concentration__Vi * var_membrane__F / (var_intracellular_calcium_concentration__Ca_up_max * var_intracellular_calcium_concentration__tau_up); // nanoA
        const double var_intracellular_calcium_concentration__Ca_up_orig_deriv = 0.5 * (-var_intracellular_calcium_concentration__i_tr + var_intracellular_calcium_concentration__i_up) / (var_intracellular_calcium_concentration__V_up * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up = 0.001 * var_intracellular_calcium_concentration__Ca_up_orig_deriv; // millimolar / millisecond
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_fast_sodium_current_h_gate__alpha_h = 20.0 * exp(-9.375 - 0.125 * var_chaste_interface__membrane__V); // per_second
        const double var_fast_sodium_current_h_gate__beta_h = 2000.0 / (1.0 + 320.0 * exp(-7.5 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_second
        const double var_fast_sodium_current_h_gate__h_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_h_gate__h) * var_fast_sodium_current_h_gate__alpha_h - var_fast_sodium_current_h_gate__beta_h * var_chaste_interface__fast_sodium_current_h_gate__h; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = 0.001 * var_fast_sodium_current_h_gate__h_orig_deriv; // 1 / millisecond
        const double var_fast_sodium_current_m_gate__E0_m = 41.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_fast_sodium_current_m_gate__alpha_m = ((var_fast_sodium_current_m_gate__delta_m > fabs(var_fast_sodium_current_m_gate__E0_m)) ? (2000.0) : (200.0 * var_fast_sodium_current_m_gate__E0_m / (1.0 - exp(-0.10000000000000001 * var_fast_sodium_current_m_gate__E0_m)))); // per_second
        const double var_fast_sodium_current_m_gate__beta_m = 8000.0 * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V); // per_second
        const double var_fast_sodium_current_m_gate__m_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m * var_chaste_interface__fast_sodium_current_m_gate__m; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * var_fast_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond
        const double var_hyperpolarising_activated_current__i_fK = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current_y_gate__alpha_y = 0.014 * exp(-0.0625 * var_chaste_interface__membrane__V); // per_second
        const double var_hyperpolarising_activated_current_y_gate__beta_y = 9.75 * exp(0.052631578947368418 * var_chaste_interface__membrane__V); // per_second
        const double var_hyperpolarising_activated_current_y_gate__y_orig_deriv = ((1.0 - var_chaste_interface__hyperpolarising_activated_current_y_gate__y) * var_hyperpolarising_activated_current_y_gate__alpha_y - var_hyperpolarising_activated_current_y_gate__beta_y * var_chaste_interface__hyperpolarising_activated_current_y_gate__y) * var_hyperpolarising_activated_current_y_gate__speed_y; // 1 / second
        const double d_dt_chaste_interface_var_hyperpolarising_activated_current_y_gate__y = 0.001 * var_hyperpolarising_activated_current_y_gate__y_orig_deriv; // 1 / millisecond
        const double var_intracellular_calcium_concentration__E0_p = 64.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_intracellular_calcium_concentration__alpha_p = 0.625 * var_intracellular_calcium_concentration__E0_p / (-1.0 + exp(0.25 * var_intracellular_calcium_concentration__E0_p)); // per_second
        const double var_intracellular_calcium_concentration__beta_p = 5.0 / (1.0 + exp(-0.25 * var_intracellular_calcium_concentration__E0_p)); // per_second
        const double var_intracellular_calcium_concentration__p_orig_deriv = (1.0 - var_chaste_interface__intracellular_calcium_concentration__p) * var_intracellular_calcium_concentration__alpha_p - var_intracellular_calcium_concentration__beta_p * var_chaste_interface__intracellular_calcium_concentration__p; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__p = 0.001 * var_intracellular_calcium_concentration__p_orig_deriv; // 1 / millisecond
        const double var_second_inward_current__P_si = 0.12; // nanoA_per_millimolar
        const double var_second_inward_current_d_gate__E0_d = 19.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_second_inward_current_d_gate__delta_d = 0.0001; // millivolt
        const double var_second_inward_current_d_gate__alpha_d = ((var_second_inward_current_d_gate__delta_d > fabs(var_second_inward_current_d_gate__E0_d)) ? (120.0) : (30.0 * var_second_inward_current_d_gate__E0_d / (1.0 - exp(-0.25 * var_second_inward_current_d_gate__E0_d)))); // per_second
        const double var_second_inward_current_d_gate__beta_d = ((var_second_inward_current_d_gate__delta_d > fabs(var_second_inward_current_d_gate__E0_d)) ? (120.0) : (12.0 * var_second_inward_current_d_gate__E0_d / (-1.0 + exp(0.10000000000000001 * var_second_inward_current_d_gate__E0_d)))); // per_second
        const double var_second_inward_current_d_gate__d_orig_deriv = (1.0 - var_chaste_interface__second_inward_current_d_gate__d) * var_second_inward_current_d_gate__alpha_d - var_second_inward_current_d_gate__beta_d * var_chaste_interface__second_inward_current_d_gate__d; // 1 / second
        const double d_dt_chaste_interface_var_second_inward_current_d_gate__d = 0.001 * var_second_inward_current_d_gate__d_orig_deriv; // 1 / millisecond
        const double var_second_inward_current_f2_gate__K_mf2 = 0.00050000000000000001; // millimolar
        const double var_second_inward_current_f2_gate__alpha_f2 = 10.0; // per_second
        const double var_second_inward_current_f2_gate__beta_f2 = var_chaste_interface__intracellular_calcium_concentration__Cai * var_second_inward_current_f2_gate__alpha_f2 / var_second_inward_current_f2_gate__K_mf2; // per_second
        const double var_second_inward_current_f2_gate__f2_orig_deriv = -(var_second_inward_current_f2_gate__alpha_f2 + var_second_inward_current_f2_gate__beta_f2) * var_chaste_interface__second_inward_current_f2_gate__f2 + var_second_inward_current_f2_gate__alpha_f2; // 1 / second
        const double d_dt_chaste_interface_var_second_inward_current_f2_gate__f2 = 0.001 * var_second_inward_current_f2_gate__f2_orig_deriv; // 1 / millisecond
        const double var_second_inward_current_f_gate__E0_f = 34.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_second_inward_current_f_gate__beta_f = 50.0 / (1.0 + exp(-8.5 - 0.25 * var_chaste_interface__membrane__V)); // per_second
        const double var_second_inward_current_f_gate__delta_f = 0.0001; // millivolt
        const double var_second_inward_current_f_gate__alpha_f = ((var_second_inward_current_f_gate__delta_f > fabs(var_second_inward_current_f_gate__E0_f)) ? (25.0) : (6.25 * var_second_inward_current_f_gate__E0_f / (-1.0 + exp(0.25 * var_second_inward_current_f_gate__E0_f)))); // per_second
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_intracellular_calcium_concentration__Cai_orig_deriv = -0.5 * (-var_intracellular_calcium_concentration__i_rel - 2.0 * var_Na_Ca_exchanger__i_NaCa / (-2.0 + var_Na_Ca_exchanger__n_NaCa) + var_calcium_background_current__i_Ca_b + var_intracellular_calcium_concentration__i_up + var_second_inward_current__i_siCa) / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai = 0.001 * var_intracellular_calcium_concentration__Cai_orig_deriv; // millimolar / millisecond
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current_f_gate__f_orig_deriv = (1.0 - var_chaste_interface__second_inward_current_f_gate__f) * var_second_inward_current_f_gate__alpha_f - var_second_inward_current_f_gate__beta_f * var_chaste_interface__second_inward_current_f_gate__f; // 1 / second
        const double d_dt_chaste_interface_var_second_inward_current_f_gate__f = 0.001 * var_second_inward_current_f_gate__f_orig_deriv; // 1 / millisecond
        const double var_sodium_background_current__g_Nab = 0.00069999999999999999; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 0.45000000000000001; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_intracellular_sodium_concentration__Nai_orig_deriv = -1.0 * (3.0 * var_sodium_potassium_pump__i_p + var_Na_Ca_exchanger__i_NaCa * var_Na_Ca_exchanger__n_NaCa / (-2.0 + var_Na_Ca_exchanger__n_NaCa) + var_fast_sodium_current__i_Na + var_hyperpolarising_activated_current__i_fNa + var_second_inward_current__i_siNa + var_sodium_background_current__i_Na_b) / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai = 0.001 * var_intracellular_sodium_concentration__Nai_orig_deriv; // millimolar / millisecond
        const double var_time_dependent_potassium_current__i_K_max = 0.80000000000000004; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current_x_gate__alpha_x = 2.1000000000000001 * exp(0.035714285714285712 * var_chaste_interface__membrane__V); // per_second
        const double var_time_dependent_potassium_current_x_gate__beta_x = 0.95999999999999996 * exp(-0.041666666666666664 * var_chaste_interface__membrane__V); // per_second
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_dependent_potassium_current_x_gate__x_orig_deriv = (1.0 - var_chaste_interface__time_dependent_potassium_current_x_gate__x) * var_time_dependent_potassium_current_x_gate__alpha_x - var_time_dependent_potassium_current_x_gate__beta_x * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // 1 / second
        const double d_dt_chaste_interface_var_time_dependent_potassium_current_x_gate__x = 0.001 * var_time_dependent_potassium_current_x_gate__x_orig_deriv; // 1 / millisecond
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.0074999999999999997; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_intracellular_potassium_concentration__i_mK = -2.0 * var_sodium_potassium_pump__i_p + var_hyperpolarising_activated_current__i_fK + var_second_inward_current__i_siK + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1; // nanoA
        const double var_intracellular_potassium_concentration__Ki_orig_deriv = -1.0 * var_intracellular_potassium_concentration__i_mK / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki = 0.001 * var_intracellular_potassium_concentration__Ki_orig_deriv; // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_hyperpolarising_activated_current__i_f = var_hyperpolarising_activated_current__i_fK + var_hyperpolarising_activated_current__i_fNa; // nanoA
            const double var_second_inward_current__i_si = var_second_inward_current__i_siCa + var_second_inward_current__i_siK + var_second_inward_current__i_siNa; // nanoA
            const double var_membrane__V_orig_deriv = (-var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_hyperpolarising_activated_current__i_f - var_second_inward_current__i_si - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_p - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1) / mParameters[0]; // millivolt / second
            d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        mEvalF[1] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai;
        mEvalF[2] = d_dt_chaste_interface_var_hyperpolarising_activated_current_y_gate__y;
        mEvalF[3] = d_dt_chaste_interface_var_time_dependent_potassium_current_x_gate__x;
        mEvalF[4] = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        mEvalF[5] = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        mEvalF[6] = d_dt_chaste_interface_var_second_inward_current_d_gate__d;
        mEvalF[7] = d_dt_chaste_interface_var_second_inward_current_f_gate__f;
        mEvalF[8] = d_dt_chaste_interface_var_second_inward_current_f2_gate__f2;
        mEvalF[9] = d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai;
        mEvalF[10] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up;
        mEvalF[11] = d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel;
        mEvalF[12] = d_dt_chaste_interface_var_intracellular_calcium_concentration__p;
        mEvalF[13] = d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        rY[13] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        
        
        // Mathematics
        const double var_Na_Ca_exchanger__K_NaCa = 2.0000000000000002e-5; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.0001; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__Kc = 3.0; // millimolar
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 0.012500000000000001; // microS
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 0.059999999999999998; // microS
        const double var_hyperpolarising_activated_current__g_f_Na = 0.059999999999999998; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fK = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_hyperpolarising_activated_current__i_f = var_hyperpolarising_activated_current__i_fK + var_hyperpolarising_activated_current__i_fNa; // nanoA
        const double var_second_inward_current__P_si = 0.12; // nanoA_per_millimolar
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_second_inward_current__i_si = var_second_inward_current__i_siCa + var_second_inward_current__i_siK + var_second_inward_current__i_siNa; // nanoA
        const double var_sodium_background_current__g_Nab = 0.00069999999999999999; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 0.45000000000000001; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_dependent_potassium_current__i_K_max = 0.80000000000000004; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.0074999999999999997; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_membrane__V_orig_deriv = (-var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_hyperpolarising_activated_current__i_f - var_second_inward_current__i_si - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_p - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1) / mParameters[0]; // millivolt / second
        d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane__V;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
            // Units: millimolar; Initial value: 5.6e-05
            double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
            // Units: dimensionless; Initial value: 0.0822
            double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
            // Units: dimensionless; Initial value: 0.1231
            double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
            // Units: dimensionless; Initial value: 0.0365
            double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
            // Units: dimensionless; Initial value: 0.1969
            double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
            // Units: dimensionless; Initial value: 0.9997
            double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
            // Units: dimensionless; Initial value: 0.5765
            double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
            // Units: millimolar; Initial value: 7.5
            double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
            // Units: millimolar; Initial value: 140.0
            
            const double var_x0 = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2);
            const double var_x1 = 0.074867781645490947 * var_chaste_interface__membrane__V;
            const double var_x2 = 1 / var_chaste_interface__intracellular_potassium_concentration__Ki;
            const double var_x3 = log(3.0 * var_x2);
            const double var_x4 = exp(0.74867781645490938 + var_x1 - 2.0 * var_x3);
            const double var_x5 = 1.0 + var_x4;
            const double var_x6 = 1 / var_x5;
            const double var_x7 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
            const double var_x8 = var_x7 * var_chaste_interface__fast_sodium_current_h_gate__h;
            const double var_x9 = -0.037433890822745473 * var_chaste_interface__membrane__V;
            const double var_x10 = exp(var_x9);
            const double var_x11 = var_x10 * var_chaste_interface__time_dependent_potassium_current_x_gate__x;
            const double var_x12 = -26.713760659695652 * var_x3 + var_chaste_interface__membrane__V;
            const double var_x13 = var_x12 * var_x4 / pow(var_x5, 2);
            const double var_x14 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0);
            const double var_x15 = 0.018716945411372737 * var_chaste_interface__membrane__V;
            const double var_x16 = exp(var_x15);
            const double var_x17 = var_x14 * var_x16;
            const double var_x18 = exp(-var_x15);
            const double var_x19 = var_x18 * var_chaste_interface__intracellular_calcium_concentration__Cai;
            const double var_x20 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai);
            const double var_x21 = 1 / (1.0 + 0.00020000000000000001 * var_x14 + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai);
            const double var_x22 = var_x20 * var_x21;
            const double var_x23 = var_x22 * (0.037433890822745473 * var_x17 + 51359.298208806787 * var_x19);
            const double var_x24 = var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f;
            const double var_x25 = var_x24 * var_chaste_interface__second_inward_current_d_gate__d;
            const double var_x26 = exp(3.7433890822745473 - var_x1);
            const double var_x27 = 1.0 - var_x26;
            const double var_x28 = 1 / var_x27;
            const double var_x29 = exp(3.7433890822745473);
            const double var_x30 = -2.0 * var_x26 + var_x29 * var_chaste_interface__intracellular_calcium_concentration__Cai;
            const double var_x31 = var_x28 * var_x30;
            const double var_x32 = 0.017968267594917826 * var_x31;
            const double var_x33 = exp(1.8716945411372736 + var_x9);
            const double var_x34 = 1.0 - var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x36 = 4.4920668987294567e-5 * var_x35;
            const double var_x37 = exp(1.8716945411372736);
            const double var_x38 = -3.0 * var_x33 + var_x37 * var_chaste_interface__intracellular_potassium_concentration__Ki;
            const double var_x39 = var_x25 * var_x38;
            const double var_x40 = -140.0 * var_x33 + var_x37 * var_chaste_interface__intracellular_sodium_concentration__Nai;
            const double var_x41 = var_x36 * var_x40;
            const double var_x42 = -50.0 + var_chaste_interface__membrane__V;
            const double var_x43 = var_x25 * var_x42;
            const double var_x44 = var_x28 * var_x43;
            const double var_x45 = var_x26 * var_x44;
            const double var_x46 = var_x33 * var_x35 * var_x43;
            const double var_x47 = var_x26 * var_x30 * var_x43 / pow(var_x27, 2);
            const double var_x48 = var_x33 * var_x42 / pow(var_x34, 2);
            const double var_x49 = 1.6815554185550732e-6 * var_x48;
            const double var_x50 = var_x25 * var_x40;
            const double var_x51 = 1 / mParameters[0];
            const double var_x52 = 0.001 * var_x51;
            
            partialF = var_x52 * (-0.00080000000000000004 + 0.00012957885284796509 * var_x13 + 0.0013452443348440585 * var_x47 - 0.0074999999999999997 * var_x0 - 0.012500000000000001 * var_x8 - 2.0000000000000002e-5 * var_x23 - 0.0017307692307692306 * var_x6 - 0.002690488669688117 * var_x45 - 0.0006417238426756367 * var_x11 - 0.00024046242485337545 * var_x46 + var_x39 * var_x49 + var_x49 * var_x50 - var_x25 * var_x32 - var_x25 * var_x41 - var_x36 * var_x39);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[10];
        // Units: millimolar; Initial value: 2.3909
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[11];
        // Units: millimolar; Initial value: 0.2207
        
        
        // Mathematics
        const double var_Na_Ca_exchanger__K_NaCa = 2.0000000000000002e-5; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_calcium_background_current__g_Cab = 0.0001; // microS
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_intracellular_calcium_concentration__Ca_up_max = 5.0; // millimolar
        const double var_intracellular_calcium_concentration__K_mCa = 0.002; // millimolar
        const double var_intracellular_calcium_concentration__rCa = 2.0; // dimensionless
        const double var_intracellular_calcium_concentration__tau_rel = 0.01; // second
        const double var_intracellular_calcium_concentration__tau_up = 0.0050000000000000001; // second
        const double var_intracellular_sodium_concentration__V_e_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_sodium_concentration__length = 0.028000000000000001; // micrometre
        const double var_intracellular_sodium_concentration__radius = 0.01; // micrometre
        const double var_intracellular_sodium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_sodium_concentration__radius, 2) * var_intracellular_sodium_concentration__length; // micrometre3
        const double var_intracellular_sodium_concentration__Vi = (1.0 - var_intracellular_sodium_concentration__V_e_ratio) * var_intracellular_sodium_concentration__V_Cell; // micrometre3
        const double var_intracellular_calcium_concentration__V_rel = 0.02 * var_intracellular_sodium_concentration__Vi; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_intracellular_calcium_concentration__i_rel = 2.0 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, var_intracellular_calcium_concentration__rCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel * var_intracellular_calcium_concentration__V_rel * var_membrane__F / ((pow(var_chaste_interface__intracellular_calcium_concentration__Cai, var_intracellular_calcium_concentration__rCa) + pow(var_intracellular_calcium_concentration__K_mCa, var_intracellular_calcium_concentration__rCa)) * var_intracellular_calcium_concentration__tau_rel); // nanoA
        const double var_intracellular_calcium_concentration__i_up = 2.0 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_up + var_intracellular_calcium_concentration__Ca_up_max) * var_chaste_interface__intracellular_calcium_concentration__Cai * var_intracellular_sodium_concentration__Vi * var_membrane__F / (var_intracellular_calcium_concentration__Ca_up_max * var_intracellular_calcium_concentration__tau_up); // nanoA
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__RTONF * log(var_extracellular_calcium_concentration__Cao / var_chaste_interface__intracellular_calcium_concentration__Cai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // nanoA
        const double var_second_inward_current__P_si = 0.12; // nanoA_per_millimolar
        const double var_second_inward_current__i_siCa = 4.0 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_calcium_concentration__Cai * exp(100.0 / var_membrane__RTONF) - var_extracellular_calcium_concentration__Cao * exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-2.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_intracellular_calcium_concentration__Cai_orig_deriv = -0.5 * (-var_intracellular_calcium_concentration__i_rel - 2.0 * var_Na_Ca_exchanger__i_NaCa / (-2.0 + var_Na_Ca_exchanger__n_NaCa) + var_calcium_background_current__i_Ca_b + var_intracellular_calcium_concentration__i_up + var_second_inward_current__i_siCa) / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai = 0.001 * var_intracellular_calcium_concentration__Cai_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Cai;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
            // Units: millimolar; Initial value: 5.6e-05
            double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
            // Units: dimensionless; Initial value: 0.9997
            double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
            // Units: dimensionless; Initial value: 0.5765
            double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
            // Units: millimolar; Initial value: 7.5
            double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[10];
            // Units: millimolar; Initial value: 2.3909
            double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[11];
            // Units: millimolar; Initial value: 0.2207
            
            const double var_x1 = 0.074867781645490947 * var_chaste_interface__membrane__V;
            const double var_x14 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0);
            const double var_x15 = 0.018716945411372737 * var_chaste_interface__membrane__V;
            const double var_x16 = exp(var_x15);
            const double var_x17 = var_x14 * var_x16;
            const double var_x18 = exp(-var_x15);
            const double var_x19 = var_x18 * var_chaste_interface__intracellular_calcium_concentration__Cai;
            const double var_x20 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai);
            const double var_x21 = 1 / (1.0 + 0.00020000000000000001 * var_x14 + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai);
            const double var_x22 = var_x20 * var_x21;
            const double var_x24 = var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f;
            const double var_x25 = var_x24 * var_chaste_interface__second_inward_current_d_gate__d;
            const double var_x26 = exp(3.7433890822745473 - var_x1);
            const double var_x27 = 1.0 - var_x26;
            const double var_x28 = 1 / var_x27;
            const double var_x29 = exp(3.7433890822745473);
            const double var_x42 = -50.0 + var_chaste_interface__membrane__V;
            const double var_x43 = var_x25 * var_x42;
            const double var_x44 = var_x28 * var_x43;
            const double var_x53 = 1 / var_chaste_interface__intracellular_calcium_concentration__Cai;
            const double var_x54 = 2.0 * var_x17 - 2744000.0 * var_x19;
            const double var_x55 = var_x21 * var_x54 / pow((0.0068999999999999999 + var_chaste_interface__intracellular_calcium_concentration__Cai), 2);
            const double var_x56 = var_x20 * var_x54 / pow((0.0036443148688046646 + 7.2886297376093296e-7 * var_x14 + var_chaste_interface__intracellular_calcium_concentration__Cai), 2);
            const double var_x57 = var_x18 * var_x22;
            const double var_x58 = var_x29 * var_x44;
            const double var_x83 = 0.0040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_rel;
            const double var_x84 = pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0);
            const double var_x85 = 3.9999999999999998e-6 + var_x84;
            const double var_x86 = 1 / var_x85;
            const double var_x87 = var_x86 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 1.0);
            const double var_x88 = pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 3.0) / pow(var_x85, 2);
            
            partialF = -0.19999999999999998 + 0.040000000000000001 * var_chaste_interface__intracellular_calcium_concentration__Ca_up - 1.1761547293737243e-5 * var_x58 - 1.8066221665073799e-10 * var_x55 - 0.071845959781105084 * var_x57 - 9.5418840923404938e-11 * var_x56 - 8.7430565504672044e-7 * var_x53 + var_x83 * var_x87 - var_x83 * var_x88;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        
        
        // Mathematics
        const double var_hyperpolarising_activated_current_y_gate__speed_y = 2.0; // dimensionless
        const double var_hyperpolarising_activated_current_y_gate__alpha_y = 0.014 * exp(-0.0625 * var_chaste_interface__membrane__V); // per_second
        const double var_hyperpolarising_activated_current_y_gate__beta_y = 9.75 * exp(0.052631578947368418 * var_chaste_interface__membrane__V); // per_second
        const double var_hyperpolarising_activated_current_y_gate__y_orig_deriv = ((1.0 - var_chaste_interface__hyperpolarising_activated_current_y_gate__y) * var_hyperpolarising_activated_current_y_gate__alpha_y - var_hyperpolarising_activated_current_y_gate__beta_y * var_chaste_interface__hyperpolarising_activated_current_y_gate__y) * var_hyperpolarising_activated_current_y_gate__speed_y; // 1 / second
        const double d_dt_chaste_interface_var_hyperpolarising_activated_current_y_gate__y = 0.001 * var_hyperpolarising_activated_current_y_gate__y_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_hyperpolarising_activated_current_y_gate__y;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x90 = exp(-0.0625 * var_chaste_interface__membrane__V);
            const double var_x91 = exp(0.052631578947368418 * var_chaste_interface__membrane__V);
            
            partialF = -2.8e-5 * var_x90 - 0.0195 * var_x91;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        
        
        // Mathematics
        const double var_time_dependent_potassium_current_x_gate__alpha_x = 2.1000000000000001 * exp(0.035714285714285712 * var_chaste_interface__membrane__V); // per_second
        const double var_time_dependent_potassium_current_x_gate__beta_x = 0.95999999999999996 * exp(-0.041666666666666664 * var_chaste_interface__membrane__V); // per_second
        const double var_time_dependent_potassium_current_x_gate__x_orig_deriv = (1.0 - var_chaste_interface__time_dependent_potassium_current_x_gate__x) * var_time_dependent_potassium_current_x_gate__alpha_x - var_time_dependent_potassium_current_x_gate__beta_x * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // 1 / second
        const double d_dt_chaste_interface_var_time_dependent_potassium_current_x_gate__x = 0.001 * var_time_dependent_potassium_current_x_gate__x_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_time_dependent_potassium_current_x_gate__x;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x92 = exp(0.035714285714285712 * var_chaste_interface__membrane__V);
            const double var_x93 = exp(-0.041666666666666664 * var_chaste_interface__membrane__V);
            
            partialF = -0.00095999999999999992 * var_x93 - 0.0021000000000000003 * var_x92;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        
        
        // Mathematics
        const double var_fast_sodium_current_m_gate__delta_m = 1.0000000000000001e-5; // millivolt
        const double var_fast_sodium_current_m_gate__E0_m = 41.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_fast_sodium_current_m_gate__alpha_m = ((var_fast_sodium_current_m_gate__delta_m > fabs(var_fast_sodium_current_m_gate__E0_m)) ? (2000.0) : (200.0 * var_fast_sodium_current_m_gate__E0_m / (1.0 - exp(-0.10000000000000001 * var_fast_sodium_current_m_gate__E0_m)))); // per_second
        const double var_fast_sodium_current_m_gate__beta_m = 8000.0 * exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V); // per_second
        const double var_fast_sodium_current_m_gate__m_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m * var_chaste_interface__fast_sodium_current_m_gate__m; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * var_fast_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x94 = 41.0 + var_chaste_interface__membrane__V;
            const double var_x95 = fabs(var_x94) < 1.0000000000000001e-5;
            const double var_x96 = -0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x97 = exp(-4.1000000000000005 + var_x96);
            const double var_x98 = 1.0 - var_x97;
            const double var_x99 = 200.0 / var_x98;
            const double var_x100 = exp(-3.6960000000000002 - 0.056000000000000001 * var_chaste_interface__membrane__V);
            
            partialF = -8.0 * var_x100 - 0.001 * ((var_x95) ? (2000.0) : (var_x94 * var_x99));
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        
        
        // Mathematics
        const double var_fast_sodium_current_h_gate__alpha_h = 20.0 * exp(-9.375 - 0.125 * var_chaste_interface__membrane__V); // per_second
        const double var_fast_sodium_current_h_gate__beta_h = 2000.0 / (1.0 + 320.0 * exp(-7.5 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_second
        const double var_fast_sodium_current_h_gate__h_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_h_gate__h) * var_fast_sodium_current_h_gate__alpha_h - var_fast_sodium_current_h_gate__beta_h * var_chaste_interface__fast_sodium_current_h_gate__h; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = 0.001 * var_fast_sodium_current_h_gate__h_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x96 = -0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x101 = exp(-9.375 - 0.125 * var_chaste_interface__membrane__V);
            const double var_x102 = exp(-7.5 + var_x96);
            
            partialF = -2.0 / (1.0 + 320.0 * var_x102) - 0.02 * var_x101;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_second_inward_current_d_gate__E0_d = 19.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_second_inward_current_d_gate__delta_d = 0.0001; // millivolt
        const double var_second_inward_current_d_gate__alpha_d = ((var_second_inward_current_d_gate__delta_d > fabs(var_second_inward_current_d_gate__E0_d)) ? (120.0) : (30.0 * var_second_inward_current_d_gate__E0_d / (1.0 - exp(-0.25 * var_second_inward_current_d_gate__E0_d)))); // per_second
        const double var_second_inward_current_d_gate__beta_d = ((var_second_inward_current_d_gate__delta_d > fabs(var_second_inward_current_d_gate__E0_d)) ? (120.0) : (12.0 * var_second_inward_current_d_gate__E0_d / (-1.0 + exp(0.10000000000000001 * var_second_inward_current_d_gate__E0_d)))); // per_second
        const double var_second_inward_current_d_gate__d_orig_deriv = (1.0 - var_chaste_interface__second_inward_current_d_gate__d) * var_second_inward_current_d_gate__alpha_d - var_second_inward_current_d_gate__beta_d * var_chaste_interface__second_inward_current_d_gate__d; // 1 / second
        const double d_dt_chaste_interface_var_second_inward_current_d_gate__d = 0.001 * var_second_inward_current_d_gate__d_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_second_inward_current_d_gate__d;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x104 = 19.0 + var_chaste_interface__membrane__V;
            const double var_x105 = fabs(var_x104) < 0.0001;
            const double var_x106 = 0.25 * var_chaste_interface__membrane__V;
            const double var_x107 = -var_x106;
            const double var_x108 = exp(-4.75 + var_x107);
            const double var_x109 = 1.0 - var_x108;
            const double var_x110 = 30.0 / var_x109;
            const double var_x111 = exp(1.8999999999999999 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x112 = -1.0 + var_x111;
            const double var_x113 = 12.0 / var_x112;
            
            partialF = -0.001 * ((var_x105) ? (120.0) : (var_x104 * var_x110)) - 0.001 * ((var_x105) ? (120.0) : (var_x104 * var_x113));
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        
        
        // Mathematics
        const double var_second_inward_current_f_gate__E0_f = 34.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_second_inward_current_f_gate__beta_f = 50.0 / (1.0 + exp(-8.5 - 0.25 * var_chaste_interface__membrane__V)); // per_second
        const double var_second_inward_current_f_gate__delta_f = 0.0001; // millivolt
        const double var_second_inward_current_f_gate__alpha_f = ((var_second_inward_current_f_gate__delta_f > fabs(var_second_inward_current_f_gate__E0_f)) ? (25.0) : (6.25 * var_second_inward_current_f_gate__E0_f / (-1.0 + exp(0.25 * var_second_inward_current_f_gate__E0_f)))); // per_second
        const double var_second_inward_current_f_gate__f_orig_deriv = (1.0 - var_chaste_interface__second_inward_current_f_gate__f) * var_second_inward_current_f_gate__alpha_f - var_second_inward_current_f_gate__beta_f * var_chaste_interface__second_inward_current_f_gate__f; // 1 / second
        const double d_dt_chaste_interface_var_second_inward_current_f_gate__f = 0.001 * var_second_inward_current_f_gate__f_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_second_inward_current_f_gate__f;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x106 = 0.25 * var_chaste_interface__membrane__V;
            const double var_x107 = -var_x106;
            const double var_x114 = 34.0 + var_chaste_interface__membrane__V;
            const double var_x115 = fabs(var_x114) < 0.0001;
            const double var_x116 = exp(8.5 + var_x106);
            const double var_x117 = -1.0 + var_x116;
            const double var_x118 = 6.25 / var_x117;
            const double var_x119 = exp(-8.5 + var_x107);
            const double var_x120 = 1.0 + var_x119;
            
            partialF = -0.001 * ((var_x115) ? (25.0) : (var_x114 * var_x118)) - 0.050000000000000003 / var_x120;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        
        
        // Mathematics
        const double var_second_inward_current_f2_gate__K_mf2 = 0.00050000000000000001; // millimolar
        const double var_second_inward_current_f2_gate__alpha_f2 = 10.0; // per_second
        const double var_second_inward_current_f2_gate__beta_f2 = var_chaste_interface__intracellular_calcium_concentration__Cai * var_second_inward_current_f2_gate__alpha_f2 / var_second_inward_current_f2_gate__K_mf2; // per_second
        const double var_second_inward_current_f2_gate__f2_orig_deriv = -(var_second_inward_current_f2_gate__alpha_f2 + var_second_inward_current_f2_gate__beta_f2) * var_chaste_interface__second_inward_current_f2_gate__f2 + var_second_inward_current_f2_gate__alpha_f2; // 1 / second
        const double d_dt_chaste_interface_var_second_inward_current_f2_gate__f2 = 0.001 * var_second_inward_current_f2_gate__f2_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_second_inward_current_f2_gate__f2;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
            // Units: millimolar; Initial value: 5.6e-05
            
            
            partialF = -0.01 - 20.0 * var_chaste_interface__intracellular_calcium_concentration__Cai;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.0365
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
        // Units: dimensionless; Initial value: 0.1969
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        
        
        // Mathematics
        const double var_Na_Ca_exchanger__K_NaCa = 2.0000000000000002e-5; // nanoA
        const double var_Na_Ca_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_extracellular_calcium_concentration__Cao = 2.0; // millimolar
        const double var_extracellular_potassium_concentration__Kc = 3.0; // millimolar
        const double var_extracellular_sodium_concentration__Nao = 140.0; // millimolar
        const double var_fast_sodium_current__g_Na = 0.012500000000000001; // microS
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_Na = 0.059999999999999998; // microS
        const double var_intracellular_sodium_concentration__V_e_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_sodium_concentration__length = 0.028000000000000001; // micrometre
        const double var_intracellular_sodium_concentration__radius = 0.01; // micrometre
        const double var_intracellular_sodium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_sodium_concentration__radius, 2) * var_intracellular_sodium_concentration__length; // micrometre3
        const double var_intracellular_sodium_concentration__Vi = (1.0 - var_intracellular_sodium_concentration__V_e_ratio) * var_intracellular_sodium_concentration__V_Cell; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_fast_sodium_current__E_mh = var_membrane__RTONF * log((var_extracellular_sodium_concentration__Nao + 0.12 * var_extracellular_potassium_concentration__Kc) / (var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki)); // millivolt
        const double var_hyperpolarising_activated_current__E_Na = var_membrane__RTONF * log(var_extracellular_sodium_concentration__Nao / var_chaste_interface__intracellular_sodium_concentration__Nai); // millivolt
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_chaste_interface__membrane__V / var_membrane__RTONF) - pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__membrane__V / var_membrane__RTONF)) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai) * (1.0 + (pow(var_extracellular_sodium_concentration__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__intracellular_calcium_concentration__Cai + pow(var_chaste_interface__intracellular_sodium_concentration__Nai, var_Na_Ca_exchanger__n_NaCa) * var_extracellular_calcium_concentration__Cao) * var_Na_Ca_exchanger__d_NaCa)); // nanoA
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_mh + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h; // nanoA
        const double var_hyperpolarising_activated_current__i_fNa = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_Na / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_second_inward_current__P_si = 0.12; // nanoA_per_millimolar
        const double var_second_inward_current__i_siNa = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_sodium_concentration__Nai * exp(50.0 / var_membrane__RTONF) - var_extracellular_sodium_concentration__Nao * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_sodium_background_current__g_Nab = 0.00069999999999999999; // microS
        const double var_sodium_background_current__i_Na_b = (-var_hyperpolarising_activated_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // nanoA
        const double var_sodium_potassium_pump__I_p = 0.45000000000000001; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_intracellular_sodium_concentration__Nai_orig_deriv = -1.0 * (3.0 * var_sodium_potassium_pump__i_p + var_Na_Ca_exchanger__i_NaCa * var_Na_Ca_exchanger__n_NaCa / (-2.0 + var_Na_Ca_exchanger__n_NaCa) + var_fast_sodium_current__i_Na + var_hyperpolarising_activated_current__i_fNa + var_second_inward_current__i_siNa + var_sodium_background_current__i_Na_b) / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai = 0.001 * var_intracellular_sodium_concentration__Nai_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_sodium_concentration__Nai;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
            // Units: millimolar; Initial value: 5.6e-05
            double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
            // Units: dimensionless; Initial value: 0.0822
            double var_chaste_interface__fast_sodium_current_m_gate__m = rY[4];
            // Units: dimensionless; Initial value: 0.0365
            double var_chaste_interface__fast_sodium_current_h_gate__h = rY[5];
            // Units: dimensionless; Initial value: 0.1969
            double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
            // Units: dimensionless; Initial value: 0.9997
            double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
            // Units: dimensionless; Initial value: 0.5765
            double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
            // Units: millimolar; Initial value: 7.5
            double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
            // Units: millimolar; Initial value: 140.0
            
            const double var_x0 = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2);
            const double var_x7 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
            const double var_x8 = var_x7 * var_chaste_interface__fast_sodium_current_h_gate__h;
            const double var_x9 = -0.037433890822745473 * var_chaste_interface__membrane__V;
            const double var_x14 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 3.0);
            const double var_x15 = 0.018716945411372737 * var_chaste_interface__membrane__V;
            const double var_x16 = exp(var_x15);
            const double var_x17 = var_x14 * var_x16;
            const double var_x18 = exp(-var_x15);
            const double var_x19 = var_x18 * var_chaste_interface__intracellular_calcium_concentration__Cai;
            const double var_x20 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__intracellular_calcium_concentration__Cai);
            const double var_x21 = 1 / (1.0 + 0.00020000000000000001 * var_x14 + 274.40000000000003 * var_chaste_interface__intracellular_calcium_concentration__Cai);
            const double var_x22 = var_x20 * var_x21;
            const double var_x24 = var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f;
            const double var_x25 = var_x24 * var_chaste_interface__second_inward_current_d_gate__d;
            const double var_x33 = exp(1.8716945411372736 + var_x9);
            const double var_x34 = 1.0 - var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x37 = exp(1.8716945411372736);
            const double var_x42 = -50.0 + var_chaste_interface__membrane__V;
            const double var_x43 = var_x25 * var_x42;
            const double var_x54 = 2.0 * var_x17 - 2744000.0 * var_x19;
            const double var_x56 = var_x20 * var_x54 / pow((0.0036443148688046646 + 7.2886297376093296e-7 * var_x14 + var_chaste_interface__intracellular_calcium_concentration__Cai), 2);
            const double var_x60 = 1 / var_chaste_interface__intracellular_sodium_concentration__Nai;
            const double var_x62 = var_chaste_interface__intracellular_sodium_concentration__Nai + 0.12 * var_chaste_interface__intracellular_potassium_concentration__Ki;
            const double var_x71 = 1 / (40.0 + var_chaste_interface__intracellular_sodium_concentration__Nai);
            const double var_x72 = var_chaste_interface__intracellular_sodium_concentration__Nai / pow((1 + 0.025000000000000001 * var_chaste_interface__intracellular_sodium_concentration__Nai), 2);
            const double var_x74 = pow(var_chaste_interface__intracellular_sodium_concentration__Nai, 2.0);
            const double var_x75 = var_x56 * var_x74;
            const double var_x76 = var_x16 * var_x22 * var_x74;
            const double var_x77 = var_x8 * (0.0008549444286121402 * var_chaste_interface__intracellular_potassium_concentration__Ki + 0.0071245369051011684 * var_chaste_interface__intracellular_sodium_concentration__Nai) / pow(var_x62, 2);
            const double var_x78 = var_x37 * var_x43;
            const double var_x122 = 5.8807736468686208e-8 * var_x35;
            const double var_x126 = 0.00013114584825700806 * var_x0;
            const double var_x127 = -var_x122 * var_x78;
            
            partialF = var_x127 + 8.2844426792967482e-7 * var_x72 + 6.2592534133428895e-16 * var_x75 - 4.7129273908888172e-7 * var_x76 - 0.0013255108286874798 * var_x71 - 0.061358770871178837 * var_x77 - 2.4480558341308171e-5 * var_x60 - var_x126 * var_x60;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[10];
        // Units: millimolar; Initial value: 2.3909
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[11];
        // Units: millimolar; Initial value: 0.2207
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.237
        
        
        // Mathematics
        const double var_intracellular_calcium_concentration__Ca_up_max = 5.0; // millimolar
        const double var_intracellular_calcium_concentration__tau_rep = 0.20000000000000001; // second
        const double var_intracellular_calcium_concentration__tau_up = 0.0050000000000000001; // second
        const double var_intracellular_sodium_concentration__V_e_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_sodium_concentration__length = 0.028000000000000001; // micrometre
        const double var_intracellular_sodium_concentration__radius = 0.01; // micrometre
        const double var_intracellular_sodium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_sodium_concentration__radius, 2) * var_intracellular_sodium_concentration__length; // micrometre3
        const double var_intracellular_sodium_concentration__Vi = (1.0 - var_intracellular_sodium_concentration__V_e_ratio) * var_intracellular_sodium_concentration__V_Cell; // micrometre3
        const double var_intracellular_calcium_concentration__V_rel = 0.02 * var_intracellular_sodium_concentration__Vi; // micrometre3
        const double var_intracellular_calcium_concentration__V_up = 0.050000000000000003 * var_intracellular_sodium_concentration__Vi; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_intracellular_calcium_concentration__i_tr = 2.0 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_rel + var_chaste_interface__intracellular_calcium_concentration__Ca_up) * var_intracellular_calcium_concentration__V_rel * var_chaste_interface__intracellular_calcium_concentration__p * var_membrane__F / var_intracellular_calcium_concentration__tau_rep; // nanoA
        const double var_intracellular_calcium_concentration__i_up = 2.0 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_up + var_intracellular_calcium_concentration__Ca_up_max) * var_chaste_interface__intracellular_calcium_concentration__Cai * var_intracellular_sodium_concentration__Vi * var_membrane__F / (var_intracellular_calcium_concentration__Ca_up_max * var_intracellular_calcium_concentration__tau_up); // nanoA
        const double var_intracellular_calcium_concentration__Ca_up_orig_deriv = 0.5 * (-var_intracellular_calcium_concentration__i_tr + var_intracellular_calcium_concentration__i_up) / (var_intracellular_calcium_concentration__V_up * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up = 0.001 * var_intracellular_calcium_concentration__Ca_up_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_up;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
            // Units: millimolar; Initial value: 5.6e-05
            double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
            // Units: dimensionless; Initial value: 0.237
            
            const double var_x128 = 0.002 * var_chaste_interface__intracellular_calcium_concentration__p;
            
            partialF = -var_x128 - 0.79999999999999993 * var_chaste_interface__intracellular_calcium_concentration__Cai;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
        // Units: millimolar; Initial value: 5.6e-05
        double var_chaste_interface__intracellular_calcium_concentration__Ca_up = rY[10];
        // Units: millimolar; Initial value: 2.3909
        double var_chaste_interface__intracellular_calcium_concentration__Ca_rel = rY[11];
        // Units: millimolar; Initial value: 0.2207
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.237
        
        
        // Mathematics
        const double var_intracellular_calcium_concentration__K_mCa = 0.002; // millimolar
        const double var_intracellular_calcium_concentration__rCa = 2.0; // dimensionless
        const double var_intracellular_calcium_concentration__tau_rel = 0.01; // second
        const double var_intracellular_calcium_concentration__tau_rep = 0.20000000000000001; // second
        const double var_intracellular_sodium_concentration__V_e_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_sodium_concentration__length = 0.028000000000000001; // micrometre
        const double var_intracellular_sodium_concentration__radius = 0.01; // micrometre
        const double var_intracellular_sodium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_sodium_concentration__radius, 2) * var_intracellular_sodium_concentration__length; // micrometre3
        const double var_intracellular_sodium_concentration__Vi = (1.0 - var_intracellular_sodium_concentration__V_e_ratio) * var_intracellular_sodium_concentration__V_Cell; // micrometre3
        const double var_intracellular_calcium_concentration__V_rel = 0.02 * var_intracellular_sodium_concentration__Vi; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_intracellular_calcium_concentration__i_rel = 2.0 * pow(var_chaste_interface__intracellular_calcium_concentration__Cai, var_intracellular_calcium_concentration__rCa) * var_chaste_interface__intracellular_calcium_concentration__Ca_rel * var_intracellular_calcium_concentration__V_rel * var_membrane__F / ((pow(var_chaste_interface__intracellular_calcium_concentration__Cai, var_intracellular_calcium_concentration__rCa) + pow(var_intracellular_calcium_concentration__K_mCa, var_intracellular_calcium_concentration__rCa)) * var_intracellular_calcium_concentration__tau_rel); // nanoA
        const double var_intracellular_calcium_concentration__i_tr = 2.0 * (-var_chaste_interface__intracellular_calcium_concentration__Ca_rel + var_chaste_interface__intracellular_calcium_concentration__Ca_up) * var_intracellular_calcium_concentration__V_rel * var_chaste_interface__intracellular_calcium_concentration__p * var_membrane__F / var_intracellular_calcium_concentration__tau_rep; // nanoA
        const double var_intracellular_calcium_concentration__Ca_rel_orig_deriv = 0.5 * (-var_intracellular_calcium_concentration__i_rel + var_intracellular_calcium_concentration__i_tr) / (var_intracellular_calcium_concentration__V_rel * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel = 0.001 * var_intracellular_calcium_concentration__Ca_rel_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__Ca_rel;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_calcium_concentration__Cai = rY[1];
            // Units: millimolar; Initial value: 5.6e-05
            double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
            // Units: dimensionless; Initial value: 0.237
            
            const double var_x84 = pow(var_chaste_interface__intracellular_calcium_concentration__Cai, 2.0);
            const double var_x85 = 3.9999999999999998e-6 + var_x84;
            const double var_x86 = 1 / var_x85;
            const double var_x89 = var_x84 * var_x86;
            const double var_x130 = 0.0050000000000000001 * var_chaste_interface__intracellular_calcium_concentration__p;
            
            partialF = -var_x130 - 0.099999999999999992 * var_x89;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__intracellular_calcium_concentration__p = rY[12];
        // Units: dimensionless; Initial value: 0.237
        
        
        // Mathematics
        const double var_intracellular_calcium_concentration__E0_p = 64.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_intracellular_calcium_concentration__alpha_p = 0.625 * var_intracellular_calcium_concentration__E0_p / (-1.0 + exp(0.25 * var_intracellular_calcium_concentration__E0_p)); // per_second
        const double var_intracellular_calcium_concentration__beta_p = 5.0 / (1.0 + exp(-0.25 * var_intracellular_calcium_concentration__E0_p)); // per_second
        const double var_intracellular_calcium_concentration__p_orig_deriv = (1.0 - var_chaste_interface__intracellular_calcium_concentration__p) * var_intracellular_calcium_concentration__alpha_p - var_intracellular_calcium_concentration__beta_p * var_chaste_interface__intracellular_calcium_concentration__p; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_calcium_concentration__p = 0.001 * var_intracellular_calcium_concentration__p_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_calcium_concentration__p;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            
            const double var_x106 = 0.25 * var_chaste_interface__membrane__V;
            const double var_x107 = -var_x106;
            const double var_x132 = exp(16.0 + var_x106);
            const double var_x133 = -1.0 + var_x132;
            const double var_x134 = 0.00062500000000000001 / var_x133;
            const double var_x135 = exp(-16.0 + var_x107);
            const double var_x136 = 1.0 + var_x135;
            const double var_x137 = 64.0 + var_chaste_interface__membrane__V;
            
            partialF = -0.0050000000000000001 / var_x136 - var_x134 * var_x137;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluateYDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -69.1865
        double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
        // Units: dimensionless; Initial value: 0.0822
        double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
        // Units: dimensionless; Initial value: 0.1231
        double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
        // Units: dimensionless; Initial value: 0.9997
        double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
        // Units: dimensionless; Initial value: 0.5765
        double var_chaste_interface__intracellular_sodium_concentration__Nai = rY[9];
        // Units: millimolar; Initial value: 7.5
        double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
        // Units: millimolar; Initial value: 140.0
        
        
        // Mathematics
        const double var_extracellular_potassium_concentration__Kc = 3.0; // millimolar
        const double var_hyperpolarising_activated_current__Km_f = 45.0; // millimolar
        const double var_hyperpolarising_activated_current__g_f_K = 0.059999999999999998; // microS
        const double var_intracellular_sodium_concentration__V_e_ratio = 0.10000000000000001; // dimensionless
        const double var_intracellular_sodium_concentration__length = 0.028000000000000001; // micrometre
        const double var_intracellular_sodium_concentration__radius = 0.01; // micrometre
        const double var_intracellular_sodium_concentration__V_Cell = 3.1415926540000001 * pow(var_intracellular_sodium_concentration__radius, 2) * var_intracellular_sodium_concentration__length; // micrometre3
        const double var_intracellular_sodium_concentration__Vi = (1.0 - var_intracellular_sodium_concentration__V_e_ratio) * var_intracellular_sodium_concentration__V_Cell; // micrometre3
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__RTONF = var_membrane__R * var_membrane__T / var_membrane__F; // millivolt
        const double var_hyperpolarising_activated_current__E_K = var_membrane__RTONF * log(var_extracellular_potassium_concentration__Kc / var_chaste_interface__intracellular_potassium_concentration__Ki); // millivolt
        const double var_hyperpolarising_activated_current__i_fK = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2) * (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_hyperpolarising_activated_current__g_f_K / (var_extracellular_potassium_concentration__Kc + var_hyperpolarising_activated_current__Km_f); // nanoA
        const double var_second_inward_current__P_si = 0.12; // nanoA_per_millimolar
        const double var_second_inward_current__i_siK = 0.01 * (-50.0 + var_chaste_interface__membrane__V) * (var_chaste_interface__intracellular_potassium_concentration__Ki * exp(50.0 / var_membrane__RTONF) - var_extracellular_potassium_concentration__Kc * exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_second_inward_current__P_si * var_chaste_interface__second_inward_current_d_gate__d * var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f / ((1.0 - exp(-1.0 * (-50.0 + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * var_membrane__RTONF); // nanoA
        const double var_sodium_potassium_pump__I_p = 0.45000000000000001; // nanoA
        const double var_sodium_potassium_pump__K_mK = 1.0; // millimolar
        const double var_sodium_potassium_pump__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump__i_p = var_extracellular_potassium_concentration__Kc * var_chaste_interface__intracellular_sodium_concentration__Nai * var_sodium_potassium_pump__I_p / ((var_extracellular_potassium_concentration__Kc + var_sodium_potassium_pump__K_mK) * (var_chaste_interface__intracellular_sodium_concentration__Nai + var_sodium_potassium_pump__K_mNa)); // nanoA
        const double var_time_dependent_potassium_current__i_K_max = 0.80000000000000004; // nanoA
        const double var_time_dependent_potassium_current__I_K = 0.0071428571428571426 * (-var_extracellular_potassium_concentration__Kc * exp(-var_chaste_interface__membrane__V / var_membrane__RTONF) + var_chaste_interface__intracellular_potassium_concentration__Ki) * var_time_dependent_potassium_current__i_K_max; // nanoA
        const double var_time_dependent_potassium_current__i_K = var_time_dependent_potassium_current__I_K * var_chaste_interface__time_dependent_potassium_current_x_gate__x; // nanoA
        const double var_time_independent_potassium_current__Km_K1 = 10.0; // millimolar
        const double var_time_independent_potassium_current__g_K1 = 0.0074999999999999997; // microS
        const double var_time_independent_potassium_current__i_K1 = (-var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) * var_extracellular_potassium_concentration__Kc * var_time_independent_potassium_current__g_K1 / ((1.0 + exp(2.0 * (10.0 - var_hyperpolarising_activated_current__E_K + var_chaste_interface__membrane__V) / var_membrane__RTONF)) * (var_extracellular_potassium_concentration__Kc + var_time_independent_potassium_current__Km_K1)); // nanoA
        const double var_intracellular_potassium_concentration__i_mK = -2.0 * var_sodium_potassium_pump__i_p + var_hyperpolarising_activated_current__i_fK + var_second_inward_current__i_siK + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1; // nanoA
        const double var_intracellular_potassium_concentration__Ki_orig_deriv = -1.0 * var_intracellular_potassium_concentration__i_mK / (var_intracellular_sodium_concentration__Vi * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki = 0.001 * var_intracellular_potassium_concentration__Ki_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_potassium_concentration__Ki;
    }

    double Cellnoble_SAN_model_1989FromCellMLGRL2::EvaluatePartialDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -69.1865
            double var_chaste_interface__hyperpolarising_activated_current_y_gate__y = rY[2];
            // Units: dimensionless; Initial value: 0.0822
            double var_chaste_interface__time_dependent_potassium_current_x_gate__x = rY[3];
            // Units: dimensionless; Initial value: 0.1231
            double var_chaste_interface__second_inward_current_d_gate__d = rY[6];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__second_inward_current_f_gate__f = rY[7];
            // Units: dimensionless; Initial value: 0.9997
            double var_chaste_interface__second_inward_current_f2_gate__f2 = rY[8];
            // Units: dimensionless; Initial value: 0.5765
            double var_chaste_interface__intracellular_potassium_concentration__Ki = rY[13];
            // Units: millimolar; Initial value: 140.0
            
            const double var_x0 = pow(var_chaste_interface__hyperpolarising_activated_current_y_gate__y, 2);
            const double var_x1 = 0.074867781645490947 * var_chaste_interface__membrane__V;
            const double var_x2 = 1 / var_chaste_interface__intracellular_potassium_concentration__Ki;
            const double var_x3 = log(3.0 * var_x2);
            const double var_x4 = exp(0.74867781645490938 + var_x1 - 2.0 * var_x3);
            const double var_x5 = 1.0 + var_x4;
            const double var_x6 = 1 / var_x5;
            const double var_x9 = -0.037433890822745473 * var_chaste_interface__membrane__V;
            const double var_x12 = -26.713760659695652 * var_x3 + var_chaste_interface__membrane__V;
            const double var_x13 = var_x12 * var_x4 / pow(var_x5, 2);
            const double var_x24 = var_chaste_interface__second_inward_current_f2_gate__f2 * var_chaste_interface__second_inward_current_f_gate__f;
            const double var_x25 = var_x24 * var_chaste_interface__second_inward_current_d_gate__d;
            const double var_x33 = exp(1.8716945411372736 + var_x9);
            const double var_x34 = 1.0 - var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x37 = exp(1.8716945411372736);
            const double var_x42 = -50.0 + var_chaste_interface__membrane__V;
            const double var_x43 = var_x25 * var_x42;
            const double var_x78 = var_x37 * var_x43;
            const double var_x80 = var_x2 * var_x6;
            const double var_x81 = var_x13 * var_x2;
            const double var_x122 = 5.8807736468686208e-8 * var_x35;
            const double var_x126 = 0.00013114584825700806 * var_x0;
            const double var_x127 = -var_x122 * var_x78;
            
            partialF = var_x127 + 4.5316609527777084e-6 * var_x81 - 7.4808371283949473e-6 * var_chaste_interface__time_dependent_potassium_current_x_gate__x - 6.0528853041696024e-5 * var_x80 - var_x126 * var_x2;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }

    std::vector<double> Cellnoble_SAN_model_1989FromCellMLGRL2::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics

        std::vector<double> dqs(1);
        dqs[0] = var_chaste_interface__environment__time_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellnoble_SAN_model_1989FromCellMLGRL2>::Initialise(void)
{
    this->mSystemName = "Noble_SAN_model_1989";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-69.1865);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.6e-05);

    // rY[2]:
    this->mVariableNames.push_back("hyperpolarising_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0822);

    // rY[3]:
    this->mVariableNames.push_back("time_dependent_potassium_current_x_gate__x");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1231);

    // rY[4]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0365);

    // rY[5]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1969);

    // rY[6]:
    this->mVariableNames.push_back("second_inward_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[7]:
    this->mVariableNames.push_back("second_inward_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9997);

    // rY[8]:
    this->mVariableNames.push_back("second_inward_current_f2_gate__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5765);

    // rY[9]:
    this->mVariableNames.push_back("intracellular_sodium_concentration__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.5);

    // rY[10]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.3909);

    // rY[11]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.2207);

    // rY[12]:
    this->mVariableNames.push_back("intracellular_calcium_concentration__p");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.237);

    // rY[13]:
    this->mVariableNames.push_back("intracellular_potassium_concentration__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(140.0);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellnoble_SAN_model_1989FromCellMLGRL2)
