//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: mahajan_shiferaw_model_2008
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "mahajan_2008.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellmahajan_2008FromCellMLGRL2::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__cell__stim_amplitude_converted = -14.999999999999998 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__cell__stim_duration = 3.0; // ms
        const double var_chaste_interface__cell__stim_offset = 0; // ms
        const double var_chaste_interface__cell__stim_period = 400.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__cell__stim_amplitude_converted),
                var_chaste_interface__cell__stim_duration,
                var_chaste_interface__cell__stim_period,
                var_chaste_interface__cell__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellmahajan_2008FromCellMLGRL2::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellmahajan_2008FromCellMLGRL2::Cellmahajan_2008FromCellMLGRL2(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                26,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellmahajan_2008FromCellMLGRL2>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 1.0; // (var_IKr__ScaleFactorGkr) [dimensionless]
        this->mParameters[1] = 1.0; // (var_IKs__ScaleFactorGks) [dimensionless]
        this->mParameters[2] = 1.0; // (var_Ito__ScaleFactorIto) [dimensionless]
        this->mParameters[3] = 182.0; // (var_ICaL__gca) [mmole_per_coulomb_cm]
        this->mParameters[4] = 12.0; // (var_INa__gna) [uS_per_nF]
        this->mParameters[5] = 0.012500000000000001; // (var_IKr__gkr) [uS_per_nF]
    }

    Cellmahajan_2008FromCellMLGRL2::~Cellmahajan_2008FromCellMLGRL2()
    {
    }
    
    double Cellmahajan_2008FromCellMLGRL2::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ca__Ca_i_converted = rY[1];
        // Units: millimolar; Initial value: 0.000256752008084
        double var_chaste_interface__INa__xm = rY[2];
        // Units: dimensionless; Initial value: 0.001075453357
        double var_chaste_interface__INa__xh = rY[3];
        // Units: dimensionless; Initial value: 0.990691306716
        double var_chaste_interface__INa__xj = rY[4];
        // Units: dimensionless; Initial value: 0.993888937283
        double var_chaste_interface__ICaL__c1 = rY[5];
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = rY[7];
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi1ba = rY[8];
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ca = rY[9];
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = rY[10];
        // Units: dimensionless; Initial value: 0.015242594688
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 0.007074239331
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.048267587131
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.105468807033
        double var_chaste_interface__Ito__xtos = rY[14];
        // Units: dimensionless; Initial value: 0.00364776906
        double var_chaste_interface__Ito__ytos = rY[15];
        // Units: dimensionless; Initial value: 0.174403618112
        double var_chaste_interface__Ito__xtof = rY[16];
        // Units: dimensionless; Initial value: 0.003643592594
        double var_chaste_interface__Ito__ytof = rY[17];
        // Units: dimensionless; Initial value: 0.993331326442
        double var_chaste_interface__Na__Na_i = rY[20];
        // Units: mM; Initial value: 11.441712311614
        double var_chaste_interface__Ca__Ca_submem = rY[22];
        // Units: uM; Initial value: 0.226941113355
        
        const double var_Ca__Ca_i = 1000.0 * var_chaste_interface__Ca__Ca_i_converted; // uM
        const double var_Ca__csm = 0.001 * var_chaste_interface__Ca__Ca_submem; // mM
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__F = 96.485341500000004; // coulomb_per_mmole
        const double var_Environment__K_o = 5.4000000000000004; // mM
        const double var_Environment__Na_o = 136.0; // mM
        const double var_Environment__R = 8.3144720000000003; // J_per_moleK
        const double var_Environment__T = 308.0; // kelvin
        const double var_Environment__FonRT = var_Environment__F / (var_Environment__R * var_Environment__T); // per_mV
        const double var_ICaL__pca = 0.00054000000000000001; // cm_per_s
        const double var_ICaL__po = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca; // dimensionless
        const double var_IK1__gkix = 0.29999999999999999; // uS_per_nF
        const double var_IKs__gks = 0.1386; // uS_per_nF
        const double var_IKs__gksx = 1.0 + 0.80000000000000004 / (1.0 + 0.125 / pow(var_Ca__Ca_i, 3)); // dimensionless
        const double var_INaCa__gNaCa = 0.83999999999999997; // uM_per_ms
        const double var_INaCa__xkdna = 0.29999999999999999; // uM
        const double var_INaCa__aloss = 1 / (1.0 + pow(var_INaCa__xkdna, 3) / pow(var_chaste_interface__Ca__Ca_submem, 3)); // dimensionless
        const double var_INaCa__xmcai = 0.0035999999999999999; // mM
        const double var_INaCa__xmcao = 1.3; // mM
        const double var_INaCa__xmnai = 12.300000000000001; // mM
        const double var_INaCa__xmnao = 87.5; // mM
        const double var_INaCa__yz2 = pow(var_INaCa__xmnai, 3) * (1.0 + var_Ca__csm / var_INaCa__xmcai) * var_Environment__Ca_o; // mM4
        const double var_INaK__gNaK = 1.5; // nA_per_nF
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_Environment__Na_o); // dimensionless
        const double var_INaK__xkmko = 1.5; // mM
        const double var_INaK__xkmnai = 12.0; // mM
        const double var_Ito__gtof = 0.040000000000000001; // uS_per_nF
        const double var_Ito__gtos = 0.11; // uS_per_nF
        const double var_INaCa__yz1 = pow(var_INaCa__xmnao, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__xmcao; // mM4
        const double var_INaCa__yz3 = pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__xmnai, 3)) * var_INaCa__xmcai; // mM4
        const double var_INaCa__yz4 = pow(var_Environment__Na_o, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o; // mM4
        const double var_INaCa__zw8 = var_INaCa__yz1 + var_INaCa__yz2 + var_INaCa__yz3 + var_INaCa__yz4; // mM4
        const double var_ICaL__za = 2.0 * var_Environment__FonRT * var_chaste_interface__cell__V; // dimensionless
        const double var_ICaL__rxa = ((fabs(var_ICaL__za) < 0.001) ? (2.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_ICaL__pca) : (4.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_Environment__FonRT * var_ICaL__pca * var_chaste_interface__cell__V / (-1.0 + exp(var_ICaL__za)))); // mA_per_cm2
        const double var_ICaL__jca = mParameters[3] * var_ICaL__po * var_ICaL__rxa; // uM_per_ms
        const double var_IKr__rg = 1 / (1.0 + exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaCa__zw3 = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(0.34999999999999998 * var_Environment__FonRT * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_Ca__csm * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__zw4 = 1.0 + 0.20000000000000001 * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__jNaCa = var_INaCa__aloss * var_INaCa__gNaCa * var_INaCa__zw3 / (var_INaCa__zw4 * var_INaCa__zw8); // uM_per_ms
        const double var_INaK__fNaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_Environment__FonRT * var_chaste_interface__cell__V) + 0.036499999999999998 * var_INaK__sigma * exp(-var_Environment__FonRT * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaK__xiNaK = var_Environment__K_o * var_INaK__fNaK * var_INaK__gNaK * var_chaste_interface__Na__Na_i / ((var_Environment__K_o + var_INaK__xkmko) * (var_INaK__xkmnai + var_chaste_interface__Na__Na_i)); // nA_per_nF
        const double var_Ito__rt2 = 3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rs_inf = 1 / (1.0 + exp(var_Ito__rt2)); // dimensionless
        const double var_cell__i_Stim = 0.0; // nA_per_nF
        const double var_cell__wca = 8.0; // mV_per_uM
        const double var_ICaL__xica = 2.0 * var_ICaL__jca * var_cell__wca; // nA_per_nF
        const double var_INaCa__xiNaCa = var_INaCa__jNaCa * var_cell__wca; // nA_per_nF
        const double var_reversal_potentials__K_i = 140.0; // mM
        const double var_reversal_potentials__ek = log(var_Environment__K_o / var_reversal_potentials__K_i) / var_Environment__FonRT; // mV
        const double var_IK1__aki = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__ek)); // per_ms
        const double var_IK1__bki = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__ek) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__ek)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__ek - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_ms
        const double var_IK1__xkin = var_IK1__aki / (var_IK1__aki + var_IK1__bki); // dimensionless
        const double var_IK1__xik1 = 0.43033148291193518 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * var_IK1__gkix * var_IK1__xkin; // nA_per_nF
        const double var_IKr__xikr = 0.43033148291193518 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * mParameters[0] * mParameters[5] * var_IKr__rg * var_chaste_interface__IKr__xr; // nA_per_nF
        const double var_Ito__xitof = (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * var_Ito__gtof * var_chaste_interface__Ito__xtof * var_chaste_interface__Ito__ytof; // nA_per_nF
        const double var_Ito__xitos = (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * (0.5 * var_Ito__rs_inf + var_chaste_interface__Ito__ytos) * mParameters[2] * var_Ito__gtos * var_chaste_interface__Ito__xtos; // nA_per_nF
        const double var_Ito__xito = var_Ito__xitof + var_Ito__xitos; // nA_per_nF
        const double var_reversal_potentials__ena = log(var_Environment__Na_o / var_chaste_interface__Na__Na_i) / var_Environment__FonRT; // mV
        const double var_INa__xina = pow(var_chaste_interface__INa__xm, 3) * (-var_reversal_potentials__ena + var_chaste_interface__cell__V) * mParameters[4] * var_chaste_interface__INa__xh * var_chaste_interface__INa__xj; // nA_per_nF
        const double var_reversal_potentials__prNaK = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__eks = log((var_Environment__Na_o * var_reversal_potentials__prNaK + var_Environment__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prNaK + var_reversal_potentials__K_i)) / var_Environment__FonRT; // mV
        const double var_IKs__xiks = (-var_reversal_potentials__eks + var_chaste_interface__cell__V) * mParameters[1] * var_IKs__gks * var_IKs__gksx * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2; // nA_per_nF
        const double var_cell__Itotal = -var_ICaL__xica - var_IK1__xik1 - var_IKr__xikr - var_IKs__xiks - var_INa__xina - var_INaCa__xiNaCa - var_INaK__xiNaK - var_Ito__xito - var_cell__i_Stim; // nA_per_nF
        const double var_chaste_interface__i_ionic = -0.99999999999999989 * HeartConfig::Instance()->GetCapacitance() * var_cell__Itotal; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellmahajan_2008FromCellMLGRL2::UpdateTransmembranePotential(double var_chaste_interface__Environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ca__Ca_i_converted = rY[1];
        // Units: millimolar; Initial value: 0.000256752008084
        double var_chaste_interface__INa__xm = rY[2];
        // Units: dimensionless; Initial value: 0.001075453357
        double var_chaste_interface__INa__xh = rY[3];
        // Units: dimensionless; Initial value: 0.990691306716
        double var_chaste_interface__INa__xj = rY[4];
        // Units: dimensionless; Initial value: 0.993888937283
        double var_chaste_interface__ICaL__c1 = rY[5];
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = rY[7];
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi1ba = rY[8];
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ca = rY[9];
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = rY[10];
        // Units: dimensionless; Initial value: 0.015242594688
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 0.007074239331
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.048267587131
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.105468807033
        double var_chaste_interface__Ito__xtos = rY[14];
        // Units: dimensionless; Initial value: 0.00364776906
        double var_chaste_interface__Ito__ytos = rY[15];
        // Units: dimensionless; Initial value: 0.174403618112
        double var_chaste_interface__Ito__xtof = rY[16];
        // Units: dimensionless; Initial value: 0.003643592594
        double var_chaste_interface__Ito__ytof = rY[17];
        // Units: dimensionless; Initial value: 0.993331326442
        double var_chaste_interface__Na__Na_i = rY[20];
        // Units: mM; Initial value: 11.441712311614
        double var_chaste_interface__Ca__Ca_submem = rY[22];
        // Units: uM; Initial value: 0.226941113355
        

        // Mathematics
        double d_dt_chaste_interface_var_cell__V;
        const double var_Ca__Ca_i = 1000.0 * var_chaste_interface__Ca__Ca_i_converted; // uM
        const double var_Ca__csm = 0.001 * var_chaste_interface__Ca__Ca_submem; // mM
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__F = 96.485341500000004; // coulomb_per_mmole
        const double var_Environment__K_o = 5.4000000000000004; // mM
        const double var_Environment__Na_o = 136.0; // mM
        const double var_Environment__R = 8.3144720000000003; // J_per_moleK
        const double var_Environment__T = 308.0; // kelvin
        const double var_Environment__FonRT = var_Environment__F / (var_Environment__R * var_Environment__T); // per_mV
        const double var_ICaL__pca = 0.00054000000000000001; // cm_per_s
        const double var_ICaL__po = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca; // dimensionless
        const double var_IK1__gkix = 0.29999999999999999; // uS_per_nF
        const double var_IKs__gks = 0.1386; // uS_per_nF
        const double var_IKs__gksx = 1.0 + 0.80000000000000004 / (1.0 + 0.125 / pow(var_Ca__Ca_i, 3)); // dimensionless
        const double var_INaCa__gNaCa = 0.83999999999999997; // uM_per_ms
        const double var_INaCa__xkdna = 0.29999999999999999; // uM
        const double var_INaCa__aloss = 1 / (1.0 + pow(var_INaCa__xkdna, 3) / pow(var_chaste_interface__Ca__Ca_submem, 3)); // dimensionless
        const double var_INaCa__xmcai = 0.0035999999999999999; // mM
        const double var_INaCa__xmcao = 1.3; // mM
        const double var_INaCa__xmnai = 12.300000000000001; // mM
        const double var_INaCa__xmnao = 87.5; // mM
        const double var_INaCa__yz2 = pow(var_INaCa__xmnai, 3) * (1.0 + var_Ca__csm / var_INaCa__xmcai) * var_Environment__Ca_o; // mM4
        const double var_INaK__gNaK = 1.5; // nA_per_nF
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_Environment__Na_o); // dimensionless
        const double var_INaK__xkmko = 1.5; // mM
        const double var_INaK__xkmnai = 12.0; // mM
        const double var_Ito__gtof = 0.040000000000000001; // uS_per_nF
        const double var_Ito__gtos = 0.11; // uS_per_nF
        const double var_INaCa__yz1 = pow(var_INaCa__xmnao, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__xmcao; // mM4
        const double var_INaCa__yz3 = pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__xmnai, 3)) * var_INaCa__xmcai; // mM4
        const double var_INaCa__yz4 = pow(var_Environment__Na_o, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o; // mM4
        const double var_INaCa__zw8 = var_INaCa__yz1 + var_INaCa__yz2 + var_INaCa__yz3 + var_INaCa__yz4; // mM4
        const double var_ICaL__za = 2.0 * var_Environment__FonRT * var_chaste_interface__cell__V; // dimensionless
        const double var_ICaL__rxa = ((fabs(var_ICaL__za) < 0.001) ? (2.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_ICaL__pca) : (4.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_Environment__FonRT * var_ICaL__pca * var_chaste_interface__cell__V / (-1.0 + exp(var_ICaL__za)))); // mA_per_cm2
        const double var_ICaL__jca = mParameters[3] * var_ICaL__po * var_ICaL__rxa; // uM_per_ms
        const double var_IKr__rg = 1 / (1.0 + exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaCa__zw3 = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(0.34999999999999998 * var_Environment__FonRT * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_Ca__csm * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__zw4 = 1.0 + 0.20000000000000001 * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__jNaCa = var_INaCa__aloss * var_INaCa__gNaCa * var_INaCa__zw3 / (var_INaCa__zw4 * var_INaCa__zw8); // uM_per_ms
        const double var_INaK__fNaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_Environment__FonRT * var_chaste_interface__cell__V) + 0.036499999999999998 * var_INaK__sigma * exp(-var_Environment__FonRT * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaK__xiNaK = var_Environment__K_o * var_INaK__fNaK * var_INaK__gNaK * var_chaste_interface__Na__Na_i / ((var_Environment__K_o + var_INaK__xkmko) * (var_INaK__xkmnai + var_chaste_interface__Na__Na_i)); // nA_per_nF
        const double var_Ito__rt2 = 3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rs_inf = 1 / (1.0 + exp(var_Ito__rt2)); // dimensionless
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2
        const double var_cell__i_Stim = 1.0000000000000002 * var_cell__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // nA_per_nF
        const double var_cell__wca = 8.0; // mV_per_uM
        const double var_ICaL__xica = 2.0 * var_ICaL__jca * var_cell__wca; // nA_per_nF
        const double var_INaCa__xiNaCa = var_INaCa__jNaCa * var_cell__wca; // nA_per_nF
        const double var_reversal_potentials__K_i = 140.0; // mM
        const double var_reversal_potentials__ek = log(var_Environment__K_o / var_reversal_potentials__K_i) / var_Environment__FonRT; // mV
        const double var_IK1__aki = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__ek)); // per_ms
        const double var_IK1__bki = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__ek) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__ek)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__ek - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_ms
        const double var_IK1__xkin = var_IK1__aki / (var_IK1__aki + var_IK1__bki); // dimensionless
        const double var_IK1__xik1 = 0.43033148291193518 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * var_IK1__gkix * var_IK1__xkin; // nA_per_nF
        const double var_IKr__xikr = 0.43033148291193518 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * mParameters[0] * mParameters[5] * var_IKr__rg * var_chaste_interface__IKr__xr; // nA_per_nF
        const double var_Ito__xitof = (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * var_Ito__gtof * var_chaste_interface__Ito__xtof * var_chaste_interface__Ito__ytof; // nA_per_nF
        const double var_Ito__xitos = (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * (0.5 * var_Ito__rs_inf + var_chaste_interface__Ito__ytos) * mParameters[2] * var_Ito__gtos * var_chaste_interface__Ito__xtos; // nA_per_nF
        const double var_Ito__xito = var_Ito__xitof + var_Ito__xitos; // nA_per_nF
        const double var_reversal_potentials__ena = log(var_Environment__Na_o / var_chaste_interface__Na__Na_i) / var_Environment__FonRT; // mV
        const double var_INa__xina = pow(var_chaste_interface__INa__xm, 3) * (-var_reversal_potentials__ena + var_chaste_interface__cell__V) * mParameters[4] * var_chaste_interface__INa__xh * var_chaste_interface__INa__xj; // nA_per_nF
        const double var_reversal_potentials__prNaK = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__eks = log((var_Environment__Na_o * var_reversal_potentials__prNaK + var_Environment__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prNaK + var_reversal_potentials__K_i)) / var_Environment__FonRT; // mV
        const double var_IKs__xiks = (-var_reversal_potentials__eks + var_chaste_interface__cell__V) * mParameters[1] * var_IKs__gks * var_IKs__gksx * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2; // nA_per_nF
        const double var_cell__Itotal = -var_ICaL__xica - var_IK1__xik1 - var_IKr__xikr - var_IKs__xiks - var_INa__xina - var_INaCa__xiNaCa - var_INaK__xiNaK - var_Ito__xito - var_cell__i_Stim; // nA_per_nF
        d_dt_chaste_interface_var_cell__V = var_cell__Itotal; // mV / ms

        double evalF = d_dt_chaste_interface_var_cell__V;
        mEvalF[0] = d_dt_chaste_interface_var_cell__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__Environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__Environment__time, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__Environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Cellmahajan_2008FromCellMLGRL2::ComputeOneStepExceptVoltage(double var_chaste_interface__Environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ca__Ca_i_converted = rY[1];
        // Units: millimolar; Initial value: 0.000256752008084
        double var_chaste_interface__INa__xm = rY[2];
        // Units: dimensionless; Initial value: 0.001075453357
        double var_chaste_interface__INa__xh = rY[3];
        // Units: dimensionless; Initial value: 0.990691306716
        double var_chaste_interface__INa__xj = rY[4];
        // Units: dimensionless; Initial value: 0.993888937283
        double var_chaste_interface__ICaL__c1 = rY[5];
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = rY[7];
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi1ba = rY[8];
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ca = rY[9];
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = rY[10];
        // Units: dimensionless; Initial value: 0.015242594688
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 0.007074239331
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.048267587131
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.105468807033
        double var_chaste_interface__Ito__xtos = rY[14];
        // Units: dimensionless; Initial value: 0.00364776906
        double var_chaste_interface__Ito__ytos = rY[15];
        // Units: dimensionless; Initial value: 0.174403618112
        double var_chaste_interface__Ito__xtof = rY[16];
        // Units: dimensionless; Initial value: 0.003643592594
        double var_chaste_interface__Ito__ytof = rY[17];
        // Units: dimensionless; Initial value: 0.993331326442
        double var_chaste_interface__Irel__Ca_JSR = rY[18];
        // Units: uM; Initial value: 97.505463697266
        double var_chaste_interface__Irel__xir = rY[19];
        // Units: uM_per_ms; Initial value: 0.006679257264
        double var_chaste_interface__Na__Na_i = rY[20];
        // Units: mM; Initial value: 11.441712311614
        double var_chaste_interface__Ca__Ca_dyad = rY[21];
        // Units: uM; Initial value: 1.716573130685
        double var_chaste_interface__Ca__Ca_submem = rY[22];
        // Units: uM; Initial value: 0.226941113355
        double var_chaste_interface__Ca__Ca_NSR = rY[23];
        // Units: uM; Initial value: 104.450004990523
        double var_chaste_interface__Ca__tropi = rY[24];
        // Units: uM; Initial value: 22.171689894953
        double var_chaste_interface__Ca__trops = rY[25];
        // Units: uM; Initial value: 19.864701949854
        
        
        // Mathematics
        double d_dt_chaste_interface_var_cell__V;
        const double var_Ca__Ca_i = 1000.0 * var_chaste_interface__Ca__Ca_i_converted; // uM
        const double var_Ca__bcal = 24.0; // uM
        const double var_Ca__bmem = 15.0; // uM
        const double var_Ca__bsar = 42.0; // uM
        const double var_Ca__btrop = 70.0; // uM
        const double var_Ca__csm = 0.001 * var_chaste_interface__Ca__Ca_submem; // mM
        const double var_Ca__kmem = 0.29999999999999999; // uM
        const double var_Ca__ksar = 13.0; // uM
        const double var_Ca__mempxi = var_Ca__bmem * var_Ca__kmem / pow((var_Ca__Ca_i + var_Ca__kmem), 2); // dimensionless
        const double var_Ca__mempxs = var_Ca__bmem * var_Ca__kmem / pow((var_chaste_interface__Ca__Ca_submem + var_Ca__kmem), 2); // dimensionless
        const double var_Ca__sarpxi = var_Ca__bsar * var_Ca__ksar / pow((var_Ca__Ca_i + var_Ca__ksar), 2); // dimensionless
        const double var_Ca__sarpxs = var_Ca__bsar * var_Ca__ksar / pow((var_chaste_interface__Ca__Ca_submem + var_Ca__ksar), 2); // dimensionless
        const double var_Ca__srkd = 0.59999999999999998; // uM
        const double var_Ca__srmax = 47.0; // uM
        const double var_Ca__spxi = var_Ca__srkd * var_Ca__srmax / pow((var_Ca__Ca_i + var_Ca__srkd), 2); // dimensionless
        const double var_Ca__spxs = var_Ca__srkd * var_Ca__srmax / pow((var_chaste_interface__Ca__Ca_submem + var_Ca__srkd), 2); // dimensionless
        const double var_Ca__taud = 4.0; // ms
        const double var_Ca__jd = (-var_Ca__Ca_i + var_chaste_interface__Ca__Ca_submem) / var_Ca__taud; // uM_per_ms
        const double var_Ca__taups = 0.5; // ms
        const double var_Ca__xkcal = 7.0; // uM
        const double var_Ca__bpxi = var_Ca__bcal * var_Ca__xkcal / pow((var_Ca__Ca_i + var_Ca__xkcal), 2); // dimensionless
        const double var_Ca__bpxs = var_Ca__bcal * var_Ca__xkcal / pow((var_chaste_interface__Ca__Ca_submem + var_Ca__xkcal), 2); // dimensionless
        const double var_Ca__dciib = 1 / (1.0 + var_Ca__bpxi + var_Ca__mempxi + var_Ca__sarpxi + var_Ca__spxi); // dimensionless
        const double var_Ca__dcsib = 1 / (1.0 + var_Ca__bpxs + var_Ca__mempxs + var_Ca__sarpxs + var_Ca__spxs); // dimensionless
        const double var_Ca__xkoff = 0.019599999999999999; // per_ms
        const double var_Ca__xkon = 0.0327; // per_uM_per_ms
        const double var_Ca__xbi = -var_chaste_interface__Ca__tropi * var_Ca__xkoff + (-var_chaste_interface__Ca__tropi + var_Ca__btrop) * var_Ca__Ca_i * var_Ca__xkon; // uM_per_ms
        const double var_Ca__xbs = -var_chaste_interface__Ca__trops * var_Ca__xkoff + (-var_chaste_interface__Ca__trops + var_Ca__btrop) * var_chaste_interface__Ca__Ca_submem * var_Ca__xkon; // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__tropi = var_Ca__xbi; // uM / ms
        const double d_dt_chaste_interface_var_Ca__trops = var_Ca__xbs; // uM / ms
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__F = 96.485341500000004; // coulomb_per_mmole
        const double var_Environment__K_o = 5.4000000000000004; // mM
        const double var_Environment__Na_o = 136.0; // mM
        const double var_Environment__R = 8.3144720000000003; // J_per_moleK
        const double var_Environment__T = 308.0; // kelvin
        const double var_Environment__FonRT = var_Environment__F / (var_Environment__R * var_Environment__T); // per_mV
        const double var_ICaL__cat = 3.0; // uM
        const double var_ICaL__cpt = 6.0936500000000002; // uM
        const double var_ICaL__fca = 1 / (1.0 + pow(var_ICaL__cat, 3) / pow(var_chaste_interface__Ca__Ca_dyad, 3)); // dimensionless
        const double var_ICaL__k1 = 0.024167999999999999 * var_ICaL__fca; // per_ms
        const double var_ICaL__k1t = 0.00413; // per_ms
        const double var_ICaL__k2 = 0.000103615; // per_ms
        const double var_ICaL__k2t = 0.0022399999999999998; // per_ms
        const double var_ICaL__pca = 0.00054000000000000001; // cm_per_s
        const double var_ICaL__r1 = 0.29999999999999999; // per_ms
        const double var_ICaL__r2 = 3.0; // per_ms
        const double var_ICaL__s1 = 0.018268800000000002 * var_ICaL__fca; // per_ms
        const double var_ICaL__s1t = 0.0019499999999999999; // per_ms
        const double var_ICaL__s2 = var_ICaL__k2 * var_ICaL__r1 * var_ICaL__s1 / (var_ICaL__k1 * var_ICaL__r2); // per_ms
        const double var_ICaL__s2t = var_ICaL__k2t * var_ICaL__r1 * var_ICaL__s1t / (var_ICaL__k1t * var_ICaL__r2); // per_ms
        const double var_ICaL__s6 = 8.0; // mV
        const double var_ICaL__sx = 3.0; // mV
        const double var_ICaL__sy = 4.0; // mV
        const double var_ICaL__syr = 11.32; // mV
        const double var_ICaL__tau3 = 3.0; // ms
        const double var_ICaL__taupo = 1.0; // ms
        const double var_ICaL__tca = 78.032899999999998; // ms
        const double var_ICaL__tau_ca = 0.10000000000000001 + var_ICaL__tca / (1.0 + pow(var_chaste_interface__Ca__Ca_dyad, 4) / pow(var_ICaL__cpt, 4)); // ms
        const double var_ICaL__vth = 0; // mV
        const double var_ICaL__vx = -40.0; // mV
        const double var_ICaL__vy = -40.0; // mV
        const double var_ICaL__vyr = -40.0; // mV
        const double var_ICaL__po = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca; // dimensionless
        const double var_INaCa__gNaCa = 0.83999999999999997; // uM_per_ms
        const double var_INaCa__xkdna = 0.29999999999999999; // uM
        const double var_INaCa__aloss = 1 / (1.0 + pow(var_INaCa__xkdna, 3) / pow(var_chaste_interface__Ca__Ca_submem, 3)); // dimensionless
        const double var_INaCa__xmcai = 0.0035999999999999999; // mM
        const double var_INaCa__xmcao = 1.3; // mM
        const double var_INaCa__xmnai = 12.300000000000001; // mM
        const double var_INaCa__xmnao = 87.5; // mM
        const double var_INaCa__yz2 = pow(var_INaCa__xmnai, 3) * (1.0 + var_Ca__csm / var_INaCa__xmcai) * var_Environment__Ca_o; // mM4
        const double var_INaK__gNaK = 1.5; // nA_per_nF
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_Environment__Na_o); // dimensionless
        const double var_INaK__xkmko = 1.5; // mM
        const double var_INaK__xkmnai = 12.0; // mM
        const double var_Ileak_Iup_Ixfer__cup = 0.5; // uM
        const double var_Ileak_Iup_Ixfer__gleak = 2.069e-5; // per_ms
        const double var_Ileak_Iup_Ixfer__kj = 50.0; // uM
        const double var_Ileak_Iup_Ixfer__jleak = pow(var_chaste_interface__Ca__Ca_NSR, 2) * (-var_Ca__Ca_i + 16.667000000000002 * var_chaste_interface__Ca__Ca_NSR) * var_Ileak_Iup_Ixfer__gleak / (pow(var_chaste_interface__Ca__Ca_NSR, 2) + pow(var_Ileak_Iup_Ixfer__kj, 2)); // uM_per_ms
        const double var_Ileak_Iup_Ixfer__vup = 0.40000000000000002; // uM_per_ms
        const double var_Ileak_Iup_Ixfer__jup = pow(var_Ca__Ca_i, 2) * var_Ileak_Iup_Ixfer__vup / (pow(var_Ca__Ca_i, 2) + pow(var_Ileak_Iup_Ixfer__cup, 2)); // uM_per_ms
        const double var_Ca__Ca_i_orig_deriv = (-var_Ca__xbi - var_Ileak_Iup_Ixfer__jup + var_Ca__jd + var_Ileak_Iup_Ixfer__jleak) * var_Ca__dciib; // uM / ms
        const double d_dt_chaste_interface_var_Ca__Ca_i_converted = 0.001 * var_Ca__Ca_i_orig_deriv; // millimolar / ms
        const double var_Irel__av = 11.300000000000001; // per_ms
        const double var_Irel__ax = 0.35759999999999997; // per_mV
        const double var_Irel__ay = 0.050000000000000003; // per_mV
        const double var_Irel__cstar = 90.0; // uM
        const double var_Irel__bv = -50.0 + (1.0 - var_Irel__av) * var_Irel__cstar; // uM_per_ms
        const double var_Irel__Qr0 = (((var_chaste_interface__Irel__Ca_JSR > 50.0) && (var_chaste_interface__Irel__Ca_JSR < var_Irel__cstar)) ? (-50.0 + var_chaste_interface__Irel__Ca_JSR) : ((var_chaste_interface__Irel__Ca_JSR >= var_Irel__cstar) ? (var_chaste_interface__Irel__Ca_JSR * var_Irel__av + var_Irel__bv) : (0))); // uM_per_ms
        const double var_Irel__Qr = var_chaste_interface__Ca__Ca_NSR * var_Irel__Qr0 / var_Irel__cstar; // uM_per_ms
        const double var_Irel__gbarsr = 26841.799999999999; // dimensionless
        const double var_Irel__gdyad = 9000.0; // mmole_per_coulomb_cm
        const double var_Irel__gryr = 2.5807899999999999; // per_ms
        const double var_Irel__taua = 100.0; // ms
        const double d_dt_chaste_interface_var_Irel__Ca_JSR = (-var_chaste_interface__Irel__Ca_JSR + var_chaste_interface__Ca__Ca_NSR) / var_Irel__taua; // uM / ms
        const double var_Irel__taur = 30.0; // ms
        const double var_Ca__dCa_JSR = -var_Ileak_Iup_Ixfer__jleak - var_chaste_interface__Irel__xir + var_Ileak_Iup_Ixfer__jup; // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_NSR = var_Ca__dCa_JSR; // uM / ms
        const double var_INaCa__yz1 = pow(var_INaCa__xmnao, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__xmcao; // mM4
        const double var_INaCa__yz3 = pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__xmnai, 3)) * var_INaCa__xmcai; // mM4
        const double var_INaCa__yz4 = pow(var_Environment__Na_o, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o; // mM4
        const double var_INaCa__zw8 = var_INaCa__yz1 + var_INaCa__yz2 + var_INaCa__yz3 + var_INaCa__yz4; // mM4
        const double var_ICaL__Pr = 1.0 - 1.0 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vy) / var_ICaL__sy)); // dimensionless
        const double var_ICaL__Ps = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vyr) / var_ICaL__syr)); // dimensionless
        const double var_ICaL__poi = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vx) / var_ICaL__sx)); // dimensionless
        const double var_ICaL__k3 = (1.0 - var_ICaL__poi) / var_ICaL__tau3; // per_ms
        const double var_ICaL__k3t = var_ICaL__k3; // per_ms
        const double var_ICaL__poinf = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vth) / var_ICaL__s6)); // dimensionless
        const double var_ICaL__alpha = var_ICaL__poinf / var_ICaL__taupo; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__poinf) / var_ICaL__taupo; // per_ms
        const double d_dt_chaste_interface_var_ICaL__c1 = var_ICaL__alpha * var_chaste_interface__ICaL__c2 + var_ICaL__k2 * var_chaste_interface__ICaL__xi1ca + var_ICaL__k2t * var_chaste_interface__ICaL__xi1ba + var_ICaL__po * var_ICaL__r2 - (var_ICaL__beta + var_ICaL__k1 + var_ICaL__k1t + var_ICaL__r1) * var_chaste_interface__ICaL__c1; // 1 / ms
        const double var_ICaL__recov = 10.0 + 4954.0 * exp(0.064102564102564111 * var_chaste_interface__cell__V); // ms
        const double var_ICaL__tauba = 450.0 + (-450.0 + var_ICaL__recov) * var_ICaL__Pr; // ms
        const double var_ICaL__k5t = (1.0 - var_ICaL__Ps) / var_ICaL__tauba; // per_ms
        const double var_ICaL__k6t = var_ICaL__Ps / var_ICaL__tauba; // per_ms
        const double var_ICaL__k4t = var_ICaL__alpha * var_ICaL__k1t * var_ICaL__k3t * var_ICaL__k5t / (var_ICaL__beta * var_ICaL__k2t * var_ICaL__k6t); // per_ms
        const double d_dt_chaste_interface_var_ICaL__xi1ba = var_chaste_interface__ICaL__c1 * var_ICaL__k1t + var_ICaL__k4t * var_chaste_interface__ICaL__xi2ba + var_ICaL__po * var_ICaL__s1t - (var_ICaL__k2t + var_ICaL__k3t + var_ICaL__s2t) * var_chaste_interface__ICaL__xi1ba; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__xi2ba = var_chaste_interface__ICaL__c2 * var_ICaL__k6t + var_ICaL__k3t * var_chaste_interface__ICaL__xi1ba - (var_ICaL__k4t + var_ICaL__k5t) * var_chaste_interface__ICaL__xi2ba; // 1 / ms
        const double var_ICaL__tauca = (-var_ICaL__tau_ca + var_ICaL__recov) * var_ICaL__Pr + var_ICaL__tau_ca; // ms
        const double var_ICaL__k5 = (1.0 - var_ICaL__Ps) / var_ICaL__tauca; // per_ms
        const double var_ICaL__k6 = var_ICaL__Ps * var_ICaL__fca / var_ICaL__tauca; // per_ms
        const double d_dt_chaste_interface_var_ICaL__c2 = var_ICaL__beta * var_chaste_interface__ICaL__c1 + var_ICaL__k5 * var_chaste_interface__ICaL__xi2ca + var_ICaL__k5t * var_chaste_interface__ICaL__xi2ba - (var_ICaL__alpha + var_ICaL__k6 + var_ICaL__k6t) * var_chaste_interface__ICaL__c2; // 1 / ms
        const double var_ICaL__k4 = var_ICaL__alpha * var_ICaL__k1 * var_ICaL__k3 * var_ICaL__k5 / (var_ICaL__beta * var_ICaL__k2 * var_ICaL__k6); // per_ms
        const double d_dt_chaste_interface_var_ICaL__xi1ca = var_chaste_interface__ICaL__c1 * var_ICaL__k1 + var_ICaL__k4 * var_chaste_interface__ICaL__xi2ca + var_ICaL__po * var_ICaL__s1 - (var_ICaL__k2 + var_ICaL__k3 + var_ICaL__s2) * var_chaste_interface__ICaL__xi1ca; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__xi2ca = var_chaste_interface__ICaL__c2 * var_ICaL__k6 + var_ICaL__k3 * var_chaste_interface__ICaL__xi1ca - (var_ICaL__k4 + var_ICaL__k5) * var_chaste_interface__ICaL__xi2ca; // 1 / ms
        const double var_ICaL__za = 2.0 * var_Environment__FonRT * var_chaste_interface__cell__V; // dimensionless
        const double var_ICaL__rxa = ((fabs(var_ICaL__za) < 0.001) ? (2.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_ICaL__pca) : (4.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_Environment__FonRT * var_ICaL__pca * var_chaste_interface__cell__V / (-1.0 + exp(var_ICaL__za)))); // mA_per_cm2
        const double var_ICaL__jca = mParameters[3] * var_ICaL__po * var_ICaL__rxa; // uM_per_ms
        const double var_IKr__xkrinf = 1 / (1.0 + exp(-6.666666666666667 - 0.13333333333333333 * var_chaste_interface__cell__V)); // dimensionless
        const double var_IKr__xkrv1 = ((fabs(7.0 + var_chaste_interface__cell__V) > 0.001) ? (0.0013799999999999999 * (7.0 + var_chaste_interface__cell__V) / (1.0 - exp(-0.86099999999999999 - 0.123 * var_chaste_interface__cell__V))) : (0.011219512195121951)); // per_ms
        const double var_IKr__xkrv2 = ((fabs(10.0 + var_chaste_interface__cell__V) > 0.001) ? (0.00060999999999999997 * (10.0 + var_chaste_interface__cell__V) / (-1.0 + exp(1.45 + 0.14499999999999999 * var_chaste_interface__cell__V))) : (0.0042068965517241376)); // per_ms
        const double var_IKr__taukr = 1 / (var_IKr__xkrv1 + var_IKr__xkrv2); // ms
        const double d_dt_chaste_interface_var_IKr__xr = (-var_chaste_interface__IKr__xr + var_IKr__xkrinf) / var_IKr__taukr; // 1 / ms
        const double var_IKs__tauxs1 = ((fabs(30.0 + var_chaste_interface__cell__V) < 0.014556040756914121) ? (417.94625266107982) : (1 / (0.00013100000000000001 * (30.0 + var_chaste_interface__cell__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__cell__V)) + 7.1899999999999999e-5 * (30.0 + var_chaste_interface__cell__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__cell__V))))); // ms
        const double var_IKs__tauxs2 = 4.0 * var_IKs__tauxs1; // ms
        const double var_IKs__xs1ss = 1 / (1.0 + exp(0.089820359281437126 - 0.059880239520958084 * var_chaste_interface__cell__V)); // dimensionless
        const double d_dt_chaste_interface_var_IKs__xs1 = (-var_chaste_interface__IKs__xs1 + var_IKs__xs1ss) / var_IKs__tauxs1; // 1 / ms
        const double var_IKs__xs2ss = var_IKs__xs1ss; // dimensionless
        const double d_dt_chaste_interface_var_IKs__xs2 = (-var_chaste_interface__IKs__xs2 + var_IKs__xs2ss) / var_IKs__tauxs2; // 1 / ms
        const double var_INa__ah = ((var_chaste_interface__cell__V < -40.0) ? (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V)) : (0)); // per_ms
        const double var_INa__aj = ((var_chaste_interface__cell__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__cell__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__cell__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__cell__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V))) : (0)); // per_ms
        const double var_INa__am = ((fabs(47.130000000000003 + var_chaste_interface__cell__V) > 0.001) ? (0.32000000000000001 * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V))) : (3.2000000000000002)); // per_ms
        const double var_INa__bh = ((var_chaste_interface__cell__V < -40.0) ? (310000.0 * exp(0.34999999999999998 * var_chaste_interface__cell__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__cell__V)) : (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V)))); // per_ms
        const double d_dt_chaste_interface_var_INa__xh = (1.0 - var_chaste_interface__INa__xh) * var_INa__ah - var_INa__bh * var_chaste_interface__INa__xh; // 1 / ms
        const double var_INa__bj = ((var_chaste_interface__cell__V < -40.0) ? (0.1212 * exp(-0.01052 * var_chaste_interface__cell__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V))) : (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__V)))); // per_ms
        const double d_dt_chaste_interface_var_INa__xj = (1.0 - var_chaste_interface__INa__xj) * var_INa__aj - var_INa__bj * var_chaste_interface__INa__xj; // 1 / ms
        const double var_INa__bm = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__cell__V); // per_ms
        const double d_dt_chaste_interface_var_INa__xm = (1.0 - var_chaste_interface__INa__xm) * var_INa__am - var_INa__bm * var_chaste_interface__INa__xm; // 1 / ms
        const double var_INaCa__zw3 = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(0.34999999999999998 * var_Environment__FonRT * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_Ca__csm * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__zw4 = 1.0 + 0.20000000000000001 * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__jNaCa = var_INaCa__aloss * var_INaCa__gNaCa * var_INaCa__zw3 / (var_INaCa__zw4 * var_INaCa__zw8); // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_submem = (-var_Ca__xbs + 50.0 * var_INaCa__jNaCa + 50.0 * var_chaste_interface__Irel__xir - 50.0 * var_Ca__jd - 50.0 * var_ICaL__jca) * var_Ca__dcsib; // uM / ms
        const double var_INaK__fNaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_Environment__FonRT * var_chaste_interface__cell__V) + 0.036499999999999998 * var_INaK__sigma * exp(-var_Environment__FonRT * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaK__xiNaK = var_Environment__K_o * var_INaK__fNaK * var_INaK__gNaK * var_chaste_interface__Na__Na_i / ((var_Environment__K_o + var_INaK__xkmko) * (var_INaK__xkmnai + var_chaste_interface__Na__Na_i)); // nA_per_nF
        const double var_Irel__sparkV = exp(-(30.0 + var_chaste_interface__cell__V) * var_Irel__ay) / (1.0 + exp(-(30.0 + var_chaste_interface__cell__V) * var_Irel__ay)); // dimensionless
        const double var_Irel__spark_rate = var_ICaL__po * var_Irel__gryr * var_Irel__sparkV * fabs(var_ICaL__rxa); // per_ms
        const double d_dt_chaste_interface_var_Irel__xir = var_Irel__Qr * var_Irel__spark_rate - (1.0 - var_Ca__dCa_JSR * var_Irel__taur / var_chaste_interface__Ca__Ca_NSR) * var_chaste_interface__Irel__xir / var_Irel__taur; // uM_per_ms / ms
        const double var_Irel__xicap = var_ICaL__po * var_Irel__gdyad * fabs(var_ICaL__rxa); // uM_per_ms
        const double var_Irel__xirp = var_ICaL__po * var_Irel__Qr * var_Irel__gbarsr * fabs(var_ICaL__rxa) * exp(-(30.0 + var_chaste_interface__cell__V) * var_Irel__ax) / (1.0 + exp(-(30.0 + var_chaste_interface__cell__V) * var_Irel__ax)); // uM_per_ms
        const double var_Irel__xiryr = var_Irel__xicap + var_Irel__xirp; // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_dyad = -(-var_chaste_interface__Ca__Ca_submem + var_chaste_interface__Ca__Ca_dyad) / var_Ca__taups + var_Irel__xiryr; // uM / ms
        const double var_Ito__rt1 = -0.20000000000000001 - 0.066666666666666666 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rt2 = 3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rt3 = 6.0 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rt4 = -0.0011111111111111111 * pow(var_chaste_interface__cell__V, 2); // dimensionless
        const double var_Ito__rt5 = 3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__txf = 1.5 + 3.5 * exp(var_Ito__rt4); // ms
        const double var_Ito__txs = 0.5 + 9.0 / (1.0 + exp(-var_Ito__rt1)); // ms
        const double var_Ito__tyf = 20.0 + 20.0 / (1.0 + exp(var_Ito__rt5)); // ms
        const double var_Ito__tys = 30.0 + 3000.0 / (1.0 + exp(var_Ito__rt3)); // ms
        const double var_Ito__xtos_inf = 1 / (1.0 + exp(var_Ito__rt1)); // dimensionless
        const double d_dt_chaste_interface_var_Ito__xtos = (-var_chaste_interface__Ito__xtos + var_Ito__xtos_inf) / var_Ito__txs; // 1 / ms
        const double var_Ito__xtof_inf = var_Ito__xtos_inf; // dimensionless
        const double d_dt_chaste_interface_var_Ito__xtof = (-var_chaste_interface__Ito__xtof + var_Ito__xtof_inf) / var_Ito__txf; // 1 / ms
        const double var_Ito__ytos_inf = 1 / (1.0 + exp(var_Ito__rt2)); // dimensionless
        const double d_dt_chaste_interface_var_Ito__ytos = (-var_chaste_interface__Ito__ytos + var_Ito__ytos_inf) / var_Ito__tys; // 1 / ms
        const double var_Ito__ytof_inf = var_Ito__ytos_inf; // dimensionless
        const double d_dt_chaste_interface_var_Ito__ytof = (-var_chaste_interface__Ito__ytof + var_Ito__ytof_inf) / var_Ito__tyf; // 1 / ms
        const double var_cell__wca = 8.0; // mV_per_uM
        const double var_INaCa__xiNaCa = var_INaCa__jNaCa * var_cell__wca; // nA_per_nF
        const double var_reversal_potentials__ena = log(var_Environment__Na_o / var_chaste_interface__Na__Na_i) / var_Environment__FonRT; // mV
        const double var_INa__xina = pow(var_chaste_interface__INa__xm, 3) * (-var_reversal_potentials__ena + var_chaste_interface__cell__V) * mParameters[4] * var_chaste_interface__INa__xh * var_chaste_interface__INa__xj; // nA_per_nF
        const double d_dt_chaste_interface_var_Na__Na_i = 0.001 * (-var_INa__xina - 3.0 * var_INaCa__xiNaCa - 3.0 * var_INaK__xiNaK) / var_cell__wca; // mM / ms

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_cell__V = 0.0;
        }
        else
        {
            const double var_IK1__gkix = 0.29999999999999999; // uS_per_nF
            const double var_IKs__gks = 0.1386; // uS_per_nF
            const double var_IKs__gksx = 1.0 + 0.80000000000000004 / (1.0 + 0.125 / pow(var_Ca__Ca_i, 3)); // dimensionless
            const double var_Ito__gtof = 0.040000000000000001; // uS_per_nF
            const double var_Ito__gtos = 0.11; // uS_per_nF
            const double var_IKr__rg = 1 / (1.0 + exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V)); // dimensionless
            const double var_Ito__rs_inf = 1 / (1.0 + exp(var_Ito__rt2)); // dimensionless
            const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2
            const double var_cell__i_Stim = 1.0000000000000002 * var_cell__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // nA_per_nF
            const double var_ICaL__xica = 2.0 * var_ICaL__jca * var_cell__wca; // nA_per_nF
            const double var_reversal_potentials__K_i = 140.0; // mM
            const double var_reversal_potentials__ek = log(var_Environment__K_o / var_reversal_potentials__K_i) / var_Environment__FonRT; // mV
            const double var_IK1__aki = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__ek)); // per_ms
            const double var_IK1__bki = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__ek) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__ek)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__ek - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_ms
            const double var_IK1__xkin = var_IK1__aki / (var_IK1__aki + var_IK1__bki); // dimensionless
            const double var_IK1__xik1 = 0.43033148291193518 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * var_IK1__gkix * var_IK1__xkin; // nA_per_nF
            const double var_IKr__xikr = 0.43033148291193518 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * mParameters[0] * mParameters[5] * var_IKr__rg * var_chaste_interface__IKr__xr; // nA_per_nF
            const double var_Ito__xitof = (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * var_Ito__gtof * var_chaste_interface__Ito__xtof * var_chaste_interface__Ito__ytof; // nA_per_nF
            const double var_Ito__xitos = (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * (0.5 * var_Ito__rs_inf + var_chaste_interface__Ito__ytos) * mParameters[2] * var_Ito__gtos * var_chaste_interface__Ito__xtos; // nA_per_nF
            const double var_Ito__xito = var_Ito__xitof + var_Ito__xitos; // nA_per_nF
            const double var_reversal_potentials__prNaK = 0.018329999999999999; // dimensionless
            const double var_reversal_potentials__eks = log((var_Environment__Na_o * var_reversal_potentials__prNaK + var_Environment__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prNaK + var_reversal_potentials__K_i)) / var_Environment__FonRT; // mV
            const double var_IKs__xiks = (-var_reversal_potentials__eks + var_chaste_interface__cell__V) * mParameters[1] * var_IKs__gks * var_IKs__gksx * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2; // nA_per_nF
            const double var_cell__Itotal = -var_ICaL__xica - var_IK1__xik1 - var_IKr__xikr - var_IKs__xiks - var_INa__xina - var_INaCa__xiNaCa - var_INaK__xiNaK - var_Ito__xito - var_cell__i_Stim; // nA_per_nF
            d_dt_chaste_interface_var_cell__V = var_cell__Itotal; // mV / ms
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_cell__V;
        mEvalF[1] = d_dt_chaste_interface_var_Ca__Ca_i_converted;
        mEvalF[2] = d_dt_chaste_interface_var_INa__xm;
        mEvalF[3] = d_dt_chaste_interface_var_INa__xh;
        mEvalF[4] = d_dt_chaste_interface_var_INa__xj;
        mEvalF[5] = d_dt_chaste_interface_var_ICaL__c1;
        mEvalF[6] = d_dt_chaste_interface_var_ICaL__c2;
        mEvalF[7] = d_dt_chaste_interface_var_ICaL__xi1ca;
        mEvalF[8] = d_dt_chaste_interface_var_ICaL__xi1ba;
        mEvalF[9] = d_dt_chaste_interface_var_ICaL__xi2ca;
        mEvalF[10] = d_dt_chaste_interface_var_ICaL__xi2ba;
        mEvalF[11] = d_dt_chaste_interface_var_IKr__xr;
        mEvalF[12] = d_dt_chaste_interface_var_IKs__xs1;
        mEvalF[13] = d_dt_chaste_interface_var_IKs__xs2;
        mEvalF[14] = d_dt_chaste_interface_var_Ito__xtos;
        mEvalF[15] = d_dt_chaste_interface_var_Ito__ytos;
        mEvalF[16] = d_dt_chaste_interface_var_Ito__xtof;
        mEvalF[17] = d_dt_chaste_interface_var_Ito__ytof;
        mEvalF[18] = d_dt_chaste_interface_var_Irel__Ca_JSR;
        mEvalF[19] = d_dt_chaste_interface_var_Irel__xir;
        mEvalF[20] = d_dt_chaste_interface_var_Na__Na_i;
        mEvalF[21] = d_dt_chaste_interface_var_Ca__Ca_dyad;
        mEvalF[22] = d_dt_chaste_interface_var_Ca__Ca_submem;
        mEvalF[23] = d_dt_chaste_interface_var_Ca__Ca_NSR;
        mEvalF[24] = d_dt_chaste_interface_var_Ca__tropi;
        mEvalF[25] = d_dt_chaste_interface_var_Ca__trops;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__Environment__time, rY, delta);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__Environment__time, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__Environment__time, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__Environment__time, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__Environment__time, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__Environment__time, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__Environment__time, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__Environment__time, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__Environment__time, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__Environment__time, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__Environment__time, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__Environment__time, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__Environment__time, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__Environment__time, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__Environment__time, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__Environment__time, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__Environment__time, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__Environment__time, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__Environment__time, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__Environment__time, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__Environment__time, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__Environment__time, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__Environment__time, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__Environment__time, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__Environment__time, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__Environment__time, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__Environment__time, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__Environment__time, rY, delta);
        rY[13] = y_save;
        
        
        y_save = rY[14];
        rY[14] = mYInit[14];
        mEvalF[14] = EvaluateYDerivative14(var_chaste_interface__Environment__time, rY);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__Environment__time, rY, delta);
        rY[14] = y_save;
        
        
        y_save = rY[15];
        rY[15] = mYInit[15];
        mEvalF[15] = EvaluateYDerivative15(var_chaste_interface__Environment__time, rY);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__Environment__time, rY, delta);
        rY[15] = y_save;
        
        
        y_save = rY[16];
        rY[16] = mYInit[16];
        mEvalF[16] = EvaluateYDerivative16(var_chaste_interface__Environment__time, rY);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__Environment__time, rY, delta);
        rY[16] = y_save;
        
        
        y_save = rY[17];
        rY[17] = mYInit[17];
        mEvalF[17] = EvaluateYDerivative17(var_chaste_interface__Environment__time, rY);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__Environment__time, rY, delta);
        rY[17] = y_save;
        
        
        y_save = rY[18];
        rY[18] = mYInit[18];
        mEvalF[18] = EvaluateYDerivative18(var_chaste_interface__Environment__time, rY);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__Environment__time, rY, delta);
        rY[18] = y_save;
        
        
        y_save = rY[19];
        rY[19] = mYInit[19];
        mEvalF[19] = EvaluateYDerivative19(var_chaste_interface__Environment__time, rY);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__Environment__time, rY, delta);
        rY[19] = y_save;
        
        
        y_save = rY[20];
        rY[20] = mYInit[20];
        mEvalF[20] = EvaluateYDerivative20(var_chaste_interface__Environment__time, rY);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__Environment__time, rY, delta);
        rY[20] = y_save;
        
        
        y_save = rY[21];
        rY[21] = mYInit[21];
        mEvalF[21] = EvaluateYDerivative21(var_chaste_interface__Environment__time, rY);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__Environment__time, rY, delta);
        rY[21] = y_save;
        
        
        y_save = rY[22];
        rY[22] = mYInit[22];
        mEvalF[22] = EvaluateYDerivative22(var_chaste_interface__Environment__time, rY);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__Environment__time, rY, delta);
        rY[22] = y_save;
        
        
        y_save = rY[23];
        rY[23] = mYInit[23];
        mEvalF[23] = EvaluateYDerivative23(var_chaste_interface__Environment__time, rY);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__Environment__time, rY, delta);
        rY[23] = y_save;
        
        
        y_save = rY[24];
        rY[24] = mYInit[24];
        mEvalF[24] = EvaluateYDerivative24(var_chaste_interface__Environment__time, rY);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__Environment__time, rY, delta);
        rY[24] = y_save;
        
        
        y_save = rY[25];
        rY[25] = mYInit[25];
        mEvalF[25] = EvaluateYDerivative25(var_chaste_interface__Environment__time, rY);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__Environment__time, rY, delta);
        rY[25] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative0(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_cell__V;
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ca__Ca_i_converted = rY[1];
        // Units: millimolar; Initial value: 0.000256752008084
        double var_chaste_interface__INa__xm = rY[2];
        // Units: dimensionless; Initial value: 0.001075453357
        double var_chaste_interface__INa__xh = rY[3];
        // Units: dimensionless; Initial value: 0.990691306716
        double var_chaste_interface__INa__xj = rY[4];
        // Units: dimensionless; Initial value: 0.993888937283
        double var_chaste_interface__ICaL__c1 = rY[5];
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = rY[7];
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi1ba = rY[8];
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ca = rY[9];
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = rY[10];
        // Units: dimensionless; Initial value: 0.015242594688
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 0.007074239331
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.048267587131
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.105468807033
        double var_chaste_interface__Ito__xtos = rY[14];
        // Units: dimensionless; Initial value: 0.00364776906
        double var_chaste_interface__Ito__ytos = rY[15];
        // Units: dimensionless; Initial value: 0.174403618112
        double var_chaste_interface__Ito__xtof = rY[16];
        // Units: dimensionless; Initial value: 0.003643592594
        double var_chaste_interface__Ito__ytof = rY[17];
        // Units: dimensionless; Initial value: 0.993331326442
        double var_chaste_interface__Na__Na_i = rY[20];
        // Units: mM; Initial value: 11.441712311614
        double var_chaste_interface__Ca__Ca_submem = rY[22];
        // Units: uM; Initial value: 0.226941113355
        
        
        // Mathematics
        const double var_Ca__Ca_i = 1000.0 * var_chaste_interface__Ca__Ca_i_converted; // uM
        const double var_Ca__csm = 0.001 * var_chaste_interface__Ca__Ca_submem; // mM
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__F = 96.485341500000004; // coulomb_per_mmole
        const double var_Environment__K_o = 5.4000000000000004; // mM
        const double var_Environment__Na_o = 136.0; // mM
        const double var_Environment__R = 8.3144720000000003; // J_per_moleK
        const double var_Environment__T = 308.0; // kelvin
        const double var_Environment__FonRT = var_Environment__F / (var_Environment__R * var_Environment__T); // per_mV
        const double var_ICaL__pca = 0.00054000000000000001; // cm_per_s
        const double var_ICaL__po = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca; // dimensionless
        const double var_IK1__gkix = 0.29999999999999999; // uS_per_nF
        const double var_IKs__gks = 0.1386; // uS_per_nF
        const double var_IKs__gksx = 1.0 + 0.80000000000000004 / (1.0 + 0.125 / pow(var_Ca__Ca_i, 3)); // dimensionless
        const double var_INaCa__gNaCa = 0.83999999999999997; // uM_per_ms
        const double var_INaCa__xkdna = 0.29999999999999999; // uM
        const double var_INaCa__aloss = 1 / (1.0 + pow(var_INaCa__xkdna, 3) / pow(var_chaste_interface__Ca__Ca_submem, 3)); // dimensionless
        const double var_INaCa__xmcai = 0.0035999999999999999; // mM
        const double var_INaCa__xmcao = 1.3; // mM
        const double var_INaCa__xmnai = 12.300000000000001; // mM
        const double var_INaCa__xmnao = 87.5; // mM
        const double var_INaCa__yz2 = pow(var_INaCa__xmnai, 3) * (1.0 + var_Ca__csm / var_INaCa__xmcai) * var_Environment__Ca_o; // mM4
        const double var_INaK__gNaK = 1.5; // nA_per_nF
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_Environment__Na_o); // dimensionless
        const double var_INaK__xkmko = 1.5; // mM
        const double var_INaK__xkmnai = 12.0; // mM
        const double var_Ito__gtof = 0.040000000000000001; // uS_per_nF
        const double var_Ito__gtos = 0.11; // uS_per_nF
        const double var_INaCa__yz1 = pow(var_INaCa__xmnao, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__xmcao; // mM4
        const double var_INaCa__yz3 = pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__xmnai, 3)) * var_INaCa__xmcai; // mM4
        const double var_INaCa__yz4 = pow(var_Environment__Na_o, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o; // mM4
        const double var_INaCa__zw8 = var_INaCa__yz1 + var_INaCa__yz2 + var_INaCa__yz3 + var_INaCa__yz4; // mM4
        const double var_ICaL__za = 2.0 * var_Environment__FonRT * var_chaste_interface__cell__V; // dimensionless
        const double var_ICaL__rxa = ((fabs(var_ICaL__za) < 0.001) ? (2.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_ICaL__pca) : (4.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_Environment__FonRT * var_ICaL__pca * var_chaste_interface__cell__V / (-1.0 + exp(var_ICaL__za)))); // mA_per_cm2
        const double var_ICaL__jca = mParameters[3] * var_ICaL__po * var_ICaL__rxa; // uM_per_ms
        const double var_IKr__rg = 1 / (1.0 + exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaCa__zw3 = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(0.34999999999999998 * var_Environment__FonRT * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_Ca__csm * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__zw4 = 1.0 + 0.20000000000000001 * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__jNaCa = var_INaCa__aloss * var_INaCa__gNaCa * var_INaCa__zw3 / (var_INaCa__zw4 * var_INaCa__zw8); // uM_per_ms
        const double var_INaK__fNaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_Environment__FonRT * var_chaste_interface__cell__V) + 0.036499999999999998 * var_INaK__sigma * exp(-var_Environment__FonRT * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaK__xiNaK = var_Environment__K_o * var_INaK__fNaK * var_INaK__gNaK * var_chaste_interface__Na__Na_i / ((var_Environment__K_o + var_INaK__xkmko) * (var_INaK__xkmnai + var_chaste_interface__Na__Na_i)); // nA_per_nF
        const double var_Ito__rt2 = 3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rs_inf = 1 / (1.0 + exp(var_Ito__rt2)); // dimensionless
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2
        const double var_cell__i_Stim = 1.0000000000000002 * var_cell__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // nA_per_nF
        const double var_cell__wca = 8.0; // mV_per_uM
        const double var_ICaL__xica = 2.0 * var_ICaL__jca * var_cell__wca; // nA_per_nF
        const double var_INaCa__xiNaCa = var_INaCa__jNaCa * var_cell__wca; // nA_per_nF
        const double var_reversal_potentials__K_i = 140.0; // mM
        const double var_reversal_potentials__ek = log(var_Environment__K_o / var_reversal_potentials__K_i) / var_Environment__FonRT; // mV
        const double var_IK1__aki = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__ek)); // per_ms
        const double var_IK1__bki = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__ek) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__ek)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__ek - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_ms
        const double var_IK1__xkin = var_IK1__aki / (var_IK1__aki + var_IK1__bki); // dimensionless
        const double var_IK1__xik1 = 0.43033148291193518 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * var_IK1__gkix * var_IK1__xkin; // nA_per_nF
        const double var_IKr__xikr = 0.43033148291193518 * sqrt(var_Environment__K_o) * (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * mParameters[0] * mParameters[5] * var_IKr__rg * var_chaste_interface__IKr__xr; // nA_per_nF
        const double var_Ito__xitof = (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * var_Ito__gtof * var_chaste_interface__Ito__xtof * var_chaste_interface__Ito__ytof; // nA_per_nF
        const double var_Ito__xitos = (-var_reversal_potentials__ek + var_chaste_interface__cell__V) * (0.5 * var_Ito__rs_inf + var_chaste_interface__Ito__ytos) * mParameters[2] * var_Ito__gtos * var_chaste_interface__Ito__xtos; // nA_per_nF
        const double var_Ito__xito = var_Ito__xitof + var_Ito__xitos; // nA_per_nF
        const double var_reversal_potentials__ena = log(var_Environment__Na_o / var_chaste_interface__Na__Na_i) / var_Environment__FonRT; // mV
        const double var_INa__xina = pow(var_chaste_interface__INa__xm, 3) * (-var_reversal_potentials__ena + var_chaste_interface__cell__V) * mParameters[4] * var_chaste_interface__INa__xh * var_chaste_interface__INa__xj; // nA_per_nF
        const double var_reversal_potentials__prNaK = 0.018329999999999999; // dimensionless
        const double var_reversal_potentials__eks = log((var_Environment__Na_o * var_reversal_potentials__prNaK + var_Environment__K_o) / (var_chaste_interface__Na__Na_i * var_reversal_potentials__prNaK + var_reversal_potentials__K_i)) / var_Environment__FonRT; // mV
        const double var_IKs__xiks = (-var_reversal_potentials__eks + var_chaste_interface__cell__V) * mParameters[1] * var_IKs__gks * var_IKs__gksx * var_chaste_interface__IKs__xs1 * var_chaste_interface__IKs__xs2; // nA_per_nF
        const double var_cell__Itotal = -var_ICaL__xica - var_IK1__xik1 - var_IKr__xikr - var_IKs__xiks - var_INa__xina - var_INaCa__xiNaCa - var_INaK__xiNaK - var_Ito__xito - var_cell__i_Stim; // nA_per_nF
        d_dt_chaste_interface_var_cell__V = var_cell__Itotal; // mV / ms

        return d_dt_chaste_interface_var_cell__V;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative0(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            double var_chaste_interface__Ca__Ca_i_converted = rY[1];
            // Units: millimolar; Initial value: 0.000256752008084
            double var_chaste_interface__INa__xm = rY[2];
            // Units: dimensionless; Initial value: 0.001075453357
            double var_chaste_interface__INa__xh = rY[3];
            // Units: dimensionless; Initial value: 0.990691306716
            double var_chaste_interface__INa__xj = rY[4];
            // Units: dimensionless; Initial value: 0.993888937283
            double var_chaste_interface__ICaL__c1 = rY[5];
            // Units: dimensionless; Initial value: 1.8211252e-05
            double var_chaste_interface__ICaL__c2 = rY[6];
            // Units: dimensionless; Initial value: 0.979322592773
            double var_chaste_interface__ICaL__xi1ca = rY[7];
            // Units: dimensionless; Initial value: 0.001208153482
            double var_chaste_interface__ICaL__xi1ba = rY[8];
            // Units: dimensionless; Initial value: 3.3616596e-05
            double var_chaste_interface__ICaL__xi2ca = rY[9];
            // Units: dimensionless; Initial value: 0.004173008466
            double var_chaste_interface__ICaL__xi2ba = rY[10];
            // Units: dimensionless; Initial value: 0.015242594688
            double var_chaste_interface__IKr__xr = rY[11];
            // Units: dimensionless; Initial value: 0.007074239331
            double var_chaste_interface__IKs__xs1 = rY[12];
            // Units: dimensionless; Initial value: 0.048267587131
            double var_chaste_interface__IKs__xs2 = rY[13];
            // Units: dimensionless; Initial value: 0.105468807033
            double var_chaste_interface__Ito__xtos = rY[14];
            // Units: dimensionless; Initial value: 0.00364776906
            double var_chaste_interface__Ito__ytos = rY[15];
            // Units: dimensionless; Initial value: 0.174403618112
            double var_chaste_interface__Ito__xtof = rY[16];
            // Units: dimensionless; Initial value: 0.003643592594
            double var_chaste_interface__Ito__ytof = rY[17];
            // Units: dimensionless; Initial value: 0.993331326442
            double var_chaste_interface__Na__Na_i = rY[20];
            // Units: mM; Initial value: 11.441712311614
            double var_chaste_interface__Ca__Ca_submem = rY[22];
            // Units: uM; Initial value: 0.226941113355
            
            const double var_x0 = exp(6.4833277106546534 + 0.23849999999999999 * var_chaste_interface__cell__V);
            const double var_x1 = 1.0 + var_x0;
            const double var_x2 = 1 / var_x1;
            const double var_x3 = exp(-46.879352217986117 - 0.51429999999999998 * var_chaste_interface__cell__V);
            const double var_x4 = 1.0 + var_x3;
            const double var_x5 = 1 / var_x4;
            const double var_x6 = exp(-31.363518823866141 + 0.061749999999999999 * var_chaste_interface__cell__V);
            const double var_x7 = exp(7.3793810433533835 + 0.080320000000000003 * var_chaste_interface__cell__V);
            const double var_x8 = var_x6 + 0.49124000000000001 * var_x7;
            const double var_x9 = var_x5 * var_x8;
            const double var_x10 = 1 / (var_x9 + 1.02 * var_x2);
            const double var_x11 = 0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x12 = exp(3.3500000000000001 + var_x11);
            const double var_x13 = 1.0 + var_x12;
            const double var_x14 = 1 / var_x13;
            const double var_x15 = mParameters[2] * var_chaste_interface__Ito__xtos;
            const double var_x16 = 0.075353936071760372 * var_chaste_interface__cell__V;
            const double var_x17 = exp(var_x16);
            const double var_x18 = var_x17 * var_chaste_interface__Ca__Ca_submem;
            const double var_x19 = fabs(var_x16) < 0.001;
            const double var_x20 = -1.0 + var_x17;
            const double var_x21 = 1 / var_x20;
            const double var_x22 = -0.61380000000000001 + 0.001 * var_x18;
            const double var_x23 = 0.0078521942756732046 * var_x21 * var_x22;
            const double var_x24 = var_x21 * var_chaste_interface__cell__V;
            const double var_x25 = ((var_x19) ? (7.8521942756732062e-6 * var_x18) : (var_x23 + 5.916937454721214e-7 * var_x18 * var_x24 - 0.00059169374547212144 * var_x17 * var_x22 * var_chaste_interface__cell__V / pow(var_x20, 2)));
            const double var_x26 = (-16.0 + 16.0 * var_chaste_interface__ICaL__c1 + 16.0 * var_chaste_interface__ICaL__c2 + 16.0 * var_chaste_interface__ICaL__xi1ba + 16.0 * var_chaste_interface__ICaL__xi1ca + 16.0 * var_chaste_interface__ICaL__xi2ba + 16.0 * var_chaste_interface__ICaL__xi2ca) * mParameters[3];
            const double var_x27 = pow(var_chaste_interface__Ca__Ca_i_converted, 3);
            const double var_x28 = 1.0 + 1.2500000000000001e-10 / var_x27;
            const double var_x29 = -0.1386 - 0.11088000000000001 / var_x28;
            const double var_x30 = var_x29 * mParameters[1] * var_chaste_interface__IKs__xs2;
            const double var_x31 = var_x30 * var_chaste_interface__IKs__xs1;
            const double var_x32 = pow(var_chaste_interface__INa__xm, 3);
            const double var_x33 = var_x32 * mParameters[4] * var_chaste_interface__INa__xj;
            const double var_x34 = var_x33 * var_chaste_interface__INa__xh;
            const double var_x35 = 86.398763985973389 + var_chaste_interface__cell__V;
            const double var_x36 = var_x0 / pow(var_x1, 2);
            const double var_x37 = pow(var_chaste_interface__Na__Na_i, 3);
            const double var_x38 = exp(0.013186938812558063 * var_chaste_interface__cell__V);
            const double var_x39 = var_x37 * var_x38;
            const double var_x40 = exp(-0.024490029223322121 * var_chaste_interface__cell__V);
            const double var_x41 = var_x40 * var_chaste_interface__Ca__Ca_submem;
            const double var_x42 = 1 / (12405.2022 + 7.9663561662386391 * var_x37 + 4115.8113750000002 * var_chaste_interface__Ca__Ca_submem);
            const double var_x43 = 1.0 + 0.20000000000000001 * var_x40;
            const double var_x44 = 1 / var_x43;
            const double var_x45 = 1.0 + 0.026999999999999996 / pow(var_chaste_interface__Ca__Ca_submem, 3);
            const double var_x46 = 1 / var_x45;
            const double var_x47 = var_x44 * var_x46;
            const double var_x48 = var_x42 * var_x47;
            const double var_x49 = var_x48 * (0.023736489862604515 * var_x39 + 61.603590949980969 * var_x41);
            const double var_x50 = 1 / (12.0 + var_chaste_interface__Na__Na_i);
            const double var_x51 = exp(-0.0037676968035880187 * var_chaste_interface__cell__V);
            const double var_x52 = exp(2.0208023774145616);
            const double var_x53 = exp(-0.037676968035880186 * var_chaste_interface__cell__V);
            const double var_x54 = 1.0 + 0.1245 * var_x51 + 0.036499999999999998 * var_x53 * (-0.14285714285714285 + 0.14285714285714285 * var_x52);
            const double var_x55 = var_x50 * (0.00046907825204670832 * var_x51 + 0.037676968035880186 * var_x53 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x52)) * var_chaste_interface__Na__Na_i / pow(var_x54, 2);
            const double var_x56 = mParameters[0] * mParameters[5] * var_chaste_interface__IKr__xr;
            const double var_x57 = exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V);
            const double var_x58 = 1.0 + var_x57;
            const double var_x59 = 1.0 / var_x58;
            const double var_x60 = 1.8 * var_x39 - 2515.4560000000001 * var_x41;
            const double var_x61 = var_x42 * var_x60;
            const double var_x62 = var_x40 * var_x46 * var_x61 / pow(var_x43, 2);
            const double var_x63 = -9.5038640384570741 - 0.11 * var_chaste_interface__cell__V;
            const double var_x64 = var_x15 * var_x63;
            const double var_x65 = var_x12 / pow(var_x13, 2);
            
            partialF = var_x31 - var_x34 - 6.7199999999999998 * var_x49 - 1.173913043478261 * var_x55 - 0.032914599276144929 * var_x62 + var_x15 * (-0.055 * var_x14 - 0.11 * var_chaste_interface__Ito__ytos) + var_x25 * var_x26 - var_x56 * var_x59 - 0.040000000000000001 * var_chaste_interface__Ito__xtof * var_chaste_interface__Ito__ytof - 0.30599999999999999 * var_x10 * var_x2 - 0.050000000000000003 * var_x64 * var_x65 + 0.07298099999999999 * var_x10 * var_x35 * var_x36 + 0.044642857142857144 * var_x35 * var_x56 * var_x57 / pow(var_x58, 2) - 0.29411764705882354 * var_x2 * var_x35 * (0.24326999999999999 * var_x36 - var_x5 * (0.061749999999999999 * var_x6 + 0.039456396800000001 * var_x7) - 0.51429999999999998 * var_x3 * var_x8 / pow(var_x4, 2)) / pow((var_x2 + 0.98039215686274506 * var_x9), 2);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative1(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca__Ca_i_converted = rY[1];
        // Units: millimolar; Initial value: 0.000256752008084
        double var_chaste_interface__Ca__Ca_submem = rY[22];
        // Units: uM; Initial value: 0.226941113355
        double var_chaste_interface__Ca__Ca_NSR = rY[23];
        // Units: uM; Initial value: 104.450004990523
        double var_chaste_interface__Ca__tropi = rY[24];
        // Units: uM; Initial value: 22.171689894953
        
        
        // Mathematics
        const double var_Ca__Ca_i = 1000.0 * var_chaste_interface__Ca__Ca_i_converted; // uM
        const double var_Ca__bcal = 24.0; // uM
        const double var_Ca__bmem = 15.0; // uM
        const double var_Ca__bsar = 42.0; // uM
        const double var_Ca__btrop = 70.0; // uM
        const double var_Ca__kmem = 0.29999999999999999; // uM
        const double var_Ca__ksar = 13.0; // uM
        const double var_Ca__mempxi = var_Ca__bmem * var_Ca__kmem / pow((var_Ca__Ca_i + var_Ca__kmem), 2); // dimensionless
        const double var_Ca__sarpxi = var_Ca__bsar * var_Ca__ksar / pow((var_Ca__Ca_i + var_Ca__ksar), 2); // dimensionless
        const double var_Ca__srkd = 0.59999999999999998; // uM
        const double var_Ca__srmax = 47.0; // uM
        const double var_Ca__spxi = var_Ca__srkd * var_Ca__srmax / pow((var_Ca__Ca_i + var_Ca__srkd), 2); // dimensionless
        const double var_Ca__taud = 4.0; // ms
        const double var_Ca__jd = (-var_Ca__Ca_i + var_chaste_interface__Ca__Ca_submem) / var_Ca__taud; // uM_per_ms
        const double var_Ca__xkcal = 7.0; // uM
        const double var_Ca__bpxi = var_Ca__bcal * var_Ca__xkcal / pow((var_Ca__Ca_i + var_Ca__xkcal), 2); // dimensionless
        const double var_Ca__dciib = 1 / (1.0 + var_Ca__bpxi + var_Ca__mempxi + var_Ca__sarpxi + var_Ca__spxi); // dimensionless
        const double var_Ca__xkoff = 0.019599999999999999; // per_ms
        const double var_Ca__xkon = 0.0327; // per_uM_per_ms
        const double var_Ca__xbi = -var_chaste_interface__Ca__tropi * var_Ca__xkoff + (-var_chaste_interface__Ca__tropi + var_Ca__btrop) * var_Ca__Ca_i * var_Ca__xkon; // uM_per_ms
        const double var_Ileak_Iup_Ixfer__cup = 0.5; // uM
        const double var_Ileak_Iup_Ixfer__gleak = 2.069e-5; // per_ms
        const double var_Ileak_Iup_Ixfer__kj = 50.0; // uM
        const double var_Ileak_Iup_Ixfer__jleak = pow(var_chaste_interface__Ca__Ca_NSR, 2) * (-var_Ca__Ca_i + 16.667000000000002 * var_chaste_interface__Ca__Ca_NSR) * var_Ileak_Iup_Ixfer__gleak / (pow(var_chaste_interface__Ca__Ca_NSR, 2) + pow(var_Ileak_Iup_Ixfer__kj, 2)); // uM_per_ms
        const double var_Ileak_Iup_Ixfer__vup = 0.40000000000000002; // uM_per_ms
        const double var_Ileak_Iup_Ixfer__jup = pow(var_Ca__Ca_i, 2) * var_Ileak_Iup_Ixfer__vup / (pow(var_Ca__Ca_i, 2) + pow(var_Ileak_Iup_Ixfer__cup, 2)); // uM_per_ms
        const double var_Ca__Ca_i_orig_deriv = (-var_Ca__xbi - var_Ileak_Iup_Ixfer__jup + var_Ca__jd + var_Ileak_Iup_Ixfer__jleak) * var_Ca__dciib; // uM / ms
        const double d_dt_chaste_interface_var_Ca__Ca_i_converted = 0.001 * var_Ca__Ca_i_orig_deriv; // millimolar / ms

        return d_dt_chaste_interface_var_Ca__Ca_i_converted;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative1(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca__Ca_i_converted = rY[1];
            // Units: millimolar; Initial value: 0.000256752008084
            double var_chaste_interface__Ca__Ca_submem = rY[22];
            // Units: uM; Initial value: 0.226941113355
            double var_chaste_interface__Ca__Ca_NSR = rY[23];
            // Units: uM; Initial value: 104.450004990523
            double var_chaste_interface__Ca__tropi = rY[24];
            // Units: uM; Initial value: 22.171689894953
            
            const double var_x27 = pow(var_chaste_interface__Ca__Ca_i_converted, 3);
            const double var_x90 = 32.699999999999996 * var_chaste_interface__Ca__tropi;
            const double var_x91 = pow(var_chaste_interface__Ca__Ca_i_converted, 2);
            const double var_x92 = 0.80000000000000004 * var_x27 / pow((2.4999999999999999e-7 + var_x91), 2);
            const double var_x93 = pow(var_chaste_interface__Ca__Ca_NSR, 2);
            const double var_x94 = 1 / (2500.0 + var_x93);
            const double var_x95 = var_x93 * var_x94;
            const double var_x96 = 0.02069 * var_x95;
            const double var_x97 = 1 / (0.25 + 1000000.0 * var_x91);
            const double var_x98 = 800000.0 * var_x97 * var_chaste_interface__Ca__Ca_i_converted;
            const double var_x99 = 0.0070000000000000001 + var_chaste_interface__Ca__Ca_i_converted;
            const double var_x100 = 0.00059999999999999995 + var_chaste_interface__Ca__Ca_i_converted;
            const double var_x101 = 0.013000000000000001 + var_chaste_interface__Ca__Ca_i_converted;
            const double var_x102 = 0.00029999999999999997 + var_chaste_interface__Ca__Ca_i_converted;
            const double var_x103 = 1.0 + 0.00016800000000000002 / pow(var_x99, 2) + 2.8200000000000001e-5 / pow(var_x100, 2) + 0.00054600000000000004 / pow(var_x101, 2) + 4.5000000000000001e-6 / pow(var_x102, 2);
            const double var_x104 = 1 / var_x103;
            const double var_x105 = 0.001 * var_x104;
            const double var_x106 = 32.699999999999996 * var_chaste_interface__Ca__Ca_i_converted;
            const double var_x107 = 400000.0 * var_x91 * var_x97;
            const double var_x108 = 16.667000000000002 * var_chaste_interface__Ca__Ca_NSR - 1000.0 * var_chaste_interface__Ca__Ca_i_converted;
            const double var_x109 = 2.069e-5 * var_x108 * var_x95;
            
            partialF = var_x105 * (-2539.0 + var_x90 + var_x92 - var_x96 - var_x98) + 0.001 * (0.00033600000000000004 / pow(var_x99, 3) + 5.6400000000000002e-5 / pow(var_x100, 3) + 0.0010920000000000001 / pow(var_x101, 3) + 9.0000000000000002e-6 / pow(var_x102, 3)) * (var_x109 - var_x107 + 0.25 * var_chaste_interface__Ca__Ca_submem + 0.019599999999999999 * var_chaste_interface__Ca__tropi - 250.0 * var_chaste_interface__Ca__Ca_i_converted - var_x106 * (70.0 - var_chaste_interface__Ca__tropi)) / pow(var_x103, 2);
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative2(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__INa__xm = rY[2];
        // Units: dimensionless; Initial value: 0.001075453357
        
        
        // Mathematics
        const double var_INa__am = ((fabs(47.130000000000003 + var_chaste_interface__cell__V) > 0.001) ? (0.32000000000000001 * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V))) : (3.2000000000000002)); // per_ms
        const double var_INa__bm = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__cell__V); // per_ms
        const double d_dt_chaste_interface_var_INa__xm = (1.0 - var_chaste_interface__INa__xm) * var_INa__am - var_INa__bm * var_chaste_interface__INa__xm; // 1 / ms

        return d_dt_chaste_interface_var_INa__xm;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative2(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            
            const double var_x113 = -0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x114 = exp(-4.7130000000000001 + var_x113);
            const double var_x115 = 1.0 - var_x114;
            const double var_x116 = 0.32000000000000001 / var_x115;
            const double var_x117 = 47.130000000000003 + var_chaste_interface__cell__V;
            const double var_x118 = fabs(var_x117) > 0.001;
            const double var_x119 = exp(-0.090909090909090912 * var_chaste_interface__cell__V);
            
            partialF = -((var_x118) ? (var_x116 * var_x117) : (3.2000000000000002)) - 0.080000000000000002 * var_x119;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative3(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__INa__xh = rY[3];
        // Units: dimensionless; Initial value: 0.990691306716
        
        
        // Mathematics
        const double var_INa__ah = ((var_chaste_interface__cell__V < -40.0) ? (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V)) : (0)); // per_ms
        const double var_INa__bh = ((var_chaste_interface__cell__V < -40.0) ? (310000.0 * exp(0.34999999999999998 * var_chaste_interface__cell__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__cell__V)) : (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V)))); // per_ms
        const double d_dt_chaste_interface_var_INa__xh = (1.0 - var_chaste_interface__INa__xh) * var_INa__ah - var_INa__bh * var_chaste_interface__INa__xh; // 1 / ms

        return d_dt_chaste_interface_var_INa__xh;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative3(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            
            const double var_x120 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V);
            const double var_x121 = var_chaste_interface__cell__V < -40.0;
            const double var_x122 = exp(0.079000000000000001 * var_chaste_interface__cell__V);
            const double var_x123 = exp(0.34999999999999998 * var_chaste_interface__cell__V);
            const double var_x124 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V);
            const double var_x125 = 1.0 + var_x124;
            
            partialF = -((var_x121) ? (0.13500000000000001 * var_x120) : (0)) - ((var_x121) ? (310000.0 * var_x123 + 3.5600000000000001 * var_x122) : (7.6923076923076916 / var_x125));
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative4(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__INa__xj = rY[4];
        // Units: dimensionless; Initial value: 0.993888937283
        
        
        // Mathematics
        const double var_INa__aj = ((var_chaste_interface__cell__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__cell__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__cell__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__cell__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V))) : (0)); // per_ms
        const double var_INa__bj = ((var_chaste_interface__cell__V < -40.0) ? (0.1212 * exp(-0.01052 * var_chaste_interface__cell__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V))) : (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__V)))); // per_ms
        const double d_dt_chaste_interface_var_INa__xj = (1.0 - var_chaste_interface__INa__xj) * var_INa__aj - var_INa__bj * var_chaste_interface__INa__xj; // 1 / ms

        return d_dt_chaste_interface_var_INa__xj;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative4(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            
            const double var_x113 = -0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x121 = var_chaste_interface__cell__V < -40.0;
            const double var_x126 = exp(0.24440000000000001 * var_chaste_interface__cell__V);
            const double var_x127 = exp(-0.043909999999999998 * var_chaste_interface__cell__V);
            const double var_x128 = -127140.0 * var_x126 - 3.4740000000000003e-5 * var_x127;
            const double var_x129 = exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V);
            const double var_x130 = 1.0 + var_x129;
            const double var_x131 = 1 / var_x130;
            const double var_x132 = var_x128 * var_x131;
            const double var_x133 = 37.780000000000001 + var_chaste_interface__cell__V;
            const double var_x134 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V);
            const double var_x135 = 1.0 + var_x134;
            const double var_x136 = exp(-0.01052 * var_chaste_interface__cell__V);
            const double var_x137 = var_x136 / var_x135;
            const double var_x138 = exp(-3.2000000000000002 + var_x113);
            const double var_x139 = 1.0 + var_x138;
            const double var_x140 = exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V);
            const double var_x141 = var_x140 / var_x139;
            
            partialF = -((var_x121) ? (0.1212 * var_x137) : (0.29999999999999999 * var_x141)) - ((var_x121) ? (var_x132 * var_x133) : (0));
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative5(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__ICaL__c1 = rY[5];
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = rY[7];
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi1ba = rY[8];
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ca = rY[9];
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = rY[10];
        // Units: dimensionless; Initial value: 0.015242594688
        double var_chaste_interface__Ca__Ca_dyad = rY[21];
        // Units: uM; Initial value: 1.716573130685
        
        
        // Mathematics
        const double var_ICaL__cat = 3.0; // uM
        const double var_ICaL__fca = 1 / (1.0 + pow(var_ICaL__cat, 3) / pow(var_chaste_interface__Ca__Ca_dyad, 3)); // dimensionless
        const double var_ICaL__k1 = 0.024167999999999999 * var_ICaL__fca; // per_ms
        const double var_ICaL__k1t = 0.00413; // per_ms
        const double var_ICaL__k2 = 0.000103615; // per_ms
        const double var_ICaL__k2t = 0.0022399999999999998; // per_ms
        const double var_ICaL__r1 = 0.29999999999999999; // per_ms
        const double var_ICaL__r2 = 3.0; // per_ms
        const double var_ICaL__s6 = 8.0; // mV
        const double var_ICaL__taupo = 1.0; // ms
        const double var_ICaL__vth = 0; // mV
        const double var_ICaL__po = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca; // dimensionless
        const double var_ICaL__poinf = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vth) / var_ICaL__s6)); // dimensionless
        const double var_ICaL__alpha = var_ICaL__poinf / var_ICaL__taupo; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__poinf) / var_ICaL__taupo; // per_ms
        const double d_dt_chaste_interface_var_ICaL__c1 = var_ICaL__alpha * var_chaste_interface__ICaL__c2 + var_ICaL__k2 * var_chaste_interface__ICaL__xi1ca + var_ICaL__k2t * var_chaste_interface__ICaL__xi1ba + var_ICaL__po * var_ICaL__r2 - (var_ICaL__beta + var_ICaL__k1 + var_ICaL__k1t + var_ICaL__r1) * var_chaste_interface__ICaL__c1; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__c1;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative5(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            double var_chaste_interface__Ca__Ca_dyad = rY[21];
            // Units: uM; Initial value: 1.716573130685
            
            const double var_x142 = exp(-0.125 * var_chaste_interface__cell__V);
            const double var_x143 = 1.0 + var_x142;
            const double var_x147 = 1 / var_x143;
            const double var_x148 = var_x147;
            const double var_x149 = pow(var_chaste_interface__Ca__Ca_dyad, 3);
            const double var_x150 = 1 / var_x149;
            const double var_x151 = 1 / (1.0 + 27.0 * var_x150);
            
            partialF = -4.3041299999999998 + var_x148 - 0.024167999999999999 * var_x151;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative6(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__ICaL__c1 = rY[5];
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi2ca = rY[9];
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = rY[10];
        // Units: dimensionless; Initial value: 0.015242594688
        double var_chaste_interface__Ca__Ca_dyad = rY[21];
        // Units: uM; Initial value: 1.716573130685
        
        
        // Mathematics
        const double var_ICaL__cat = 3.0; // uM
        const double var_ICaL__cpt = 6.0936500000000002; // uM
        const double var_ICaL__fca = 1 / (1.0 + pow(var_ICaL__cat, 3) / pow(var_chaste_interface__Ca__Ca_dyad, 3)); // dimensionless
        const double var_ICaL__s6 = 8.0; // mV
        const double var_ICaL__sy = 4.0; // mV
        const double var_ICaL__syr = 11.32; // mV
        const double var_ICaL__taupo = 1.0; // ms
        const double var_ICaL__tca = 78.032899999999998; // ms
        const double var_ICaL__tau_ca = 0.10000000000000001 + var_ICaL__tca / (1.0 + pow(var_chaste_interface__Ca__Ca_dyad, 4) / pow(var_ICaL__cpt, 4)); // ms
        const double var_ICaL__vth = 0; // mV
        const double var_ICaL__vy = -40.0; // mV
        const double var_ICaL__vyr = -40.0; // mV
        const double var_ICaL__Pr = 1.0 - 1.0 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vy) / var_ICaL__sy)); // dimensionless
        const double var_ICaL__Ps = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vyr) / var_ICaL__syr)); // dimensionless
        const double var_ICaL__poinf = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vth) / var_ICaL__s6)); // dimensionless
        const double var_ICaL__alpha = var_ICaL__poinf / var_ICaL__taupo; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__poinf) / var_ICaL__taupo; // per_ms
        const double var_ICaL__recov = 10.0 + 4954.0 * exp(0.064102564102564111 * var_chaste_interface__cell__V); // ms
        const double var_ICaL__tauba = 450.0 + (-450.0 + var_ICaL__recov) * var_ICaL__Pr; // ms
        const double var_ICaL__k5t = (1.0 - var_ICaL__Ps) / var_ICaL__tauba; // per_ms
        const double var_ICaL__k6t = var_ICaL__Ps / var_ICaL__tauba; // per_ms
        const double var_ICaL__tauca = (-var_ICaL__tau_ca + var_ICaL__recov) * var_ICaL__Pr + var_ICaL__tau_ca; // ms
        const double var_ICaL__k5 = (1.0 - var_ICaL__Ps) / var_ICaL__tauca; // per_ms
        const double var_ICaL__k6 = var_ICaL__Ps * var_ICaL__fca / var_ICaL__tauca; // per_ms
        const double d_dt_chaste_interface_var_ICaL__c2 = var_ICaL__beta * var_chaste_interface__ICaL__c1 + var_ICaL__k5 * var_chaste_interface__ICaL__xi2ca + var_ICaL__k5t * var_chaste_interface__ICaL__xi2ba - (var_ICaL__alpha + var_ICaL__k6 + var_ICaL__k6t) * var_chaste_interface__ICaL__c2; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__c2;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative6(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            double var_chaste_interface__Ca__Ca_dyad = rY[21];
            // Units: uM; Initial value: 1.716573130685
            
            const double var_x142 = exp(-0.125 * var_chaste_interface__cell__V);
            const double var_x143 = 1.0 + var_x142;
            const double var_x147 = 1 / var_x143;
            const double var_x148 = var_x147;
            const double var_x149 = pow(var_chaste_interface__Ca__Ca_dyad, 3);
            const double var_x150 = 1 / var_x149;
            const double var_x151 = 1 / (1.0 + 27.0 * var_x150);
            const double var_x152 = pow(var_chaste_interface__Ca__Ca_dyad, 4);
            const double var_x156 = exp(-10.0 - 0.25 * var_chaste_interface__cell__V);
            const double var_x157 = 1.0 + var_x156;
            const double var_x158 = 1.0 - 1.0 / var_x157;
            const double var_x159 = exp(0.064102564102564111 * var_chaste_interface__cell__V);
            const double var_x160 = 4954.0 * var_x159;
            const double var_x161 = -440.0 + var_x160;
            const double var_x162 = var_x158 * var_x161;
            const double var_x163 = 1 / (450.0 + var_x162);
            const double var_x164 = exp(-3.5335689045936394 - 0.088339222614840993 * var_chaste_interface__cell__V);
            const double var_x165 = 1.0 + var_x164;
            const double var_x168 = 1 / var_x165;
            const double var_x173 = 1.0 + 0.00072525373756441506 * var_x152;
            const double var_x174 = 1 / var_x173;
            const double var_x175 = 78.032899999999998 * var_x174;
            const double var_x176 = 9.9000000000000004 + var_x160 - var_x175;
            const double var_x177 = var_x158 * var_x176;
            const double var_x178 = 1 / (0.10000000000000001 + var_x175 + var_x177);
            const double var_x179 = var_x151 * var_x178;
            const double var_x185 = var_x168;
            const double var_x190 = -var_x148;
            const double var_x192 = var_x163 * var_x185;
            const double var_x193 = var_x179 * var_x185;
            
            partialF = var_x190 - var_x192 - var_x193;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative7(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__ICaL__c1 = rY[5];
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = rY[7];
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi1ba = rY[8];
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ca = rY[9];
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = rY[10];
        // Units: dimensionless; Initial value: 0.015242594688
        double var_chaste_interface__Ca__Ca_dyad = rY[21];
        // Units: uM; Initial value: 1.716573130685
        
        
        // Mathematics
        const double var_ICaL__cat = 3.0; // uM
        const double var_ICaL__cpt = 6.0936500000000002; // uM
        const double var_ICaL__fca = 1 / (1.0 + pow(var_ICaL__cat, 3) / pow(var_chaste_interface__Ca__Ca_dyad, 3)); // dimensionless
        const double var_ICaL__k1 = 0.024167999999999999 * var_ICaL__fca; // per_ms
        const double var_ICaL__k2 = 0.000103615; // per_ms
        const double var_ICaL__r1 = 0.29999999999999999; // per_ms
        const double var_ICaL__r2 = 3.0; // per_ms
        const double var_ICaL__s1 = 0.018268800000000002 * var_ICaL__fca; // per_ms
        const double var_ICaL__s2 = var_ICaL__k2 * var_ICaL__r1 * var_ICaL__s1 / (var_ICaL__k1 * var_ICaL__r2); // per_ms
        const double var_ICaL__s6 = 8.0; // mV
        const double var_ICaL__sx = 3.0; // mV
        const double var_ICaL__sy = 4.0; // mV
        const double var_ICaL__syr = 11.32; // mV
        const double var_ICaL__tau3 = 3.0; // ms
        const double var_ICaL__taupo = 1.0; // ms
        const double var_ICaL__tca = 78.032899999999998; // ms
        const double var_ICaL__tau_ca = 0.10000000000000001 + var_ICaL__tca / (1.0 + pow(var_chaste_interface__Ca__Ca_dyad, 4) / pow(var_ICaL__cpt, 4)); // ms
        const double var_ICaL__vth = 0; // mV
        const double var_ICaL__vx = -40.0; // mV
        const double var_ICaL__vy = -40.0; // mV
        const double var_ICaL__vyr = -40.0; // mV
        const double var_ICaL__po = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca; // dimensionless
        const double var_ICaL__Pr = 1.0 - 1.0 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vy) / var_ICaL__sy)); // dimensionless
        const double var_ICaL__Ps = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vyr) / var_ICaL__syr)); // dimensionless
        const double var_ICaL__poi = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vx) / var_ICaL__sx)); // dimensionless
        const double var_ICaL__k3 = (1.0 - var_ICaL__poi) / var_ICaL__tau3; // per_ms
        const double var_ICaL__poinf = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vth) / var_ICaL__s6)); // dimensionless
        const double var_ICaL__alpha = var_ICaL__poinf / var_ICaL__taupo; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__poinf) / var_ICaL__taupo; // per_ms
        const double var_ICaL__recov = 10.0 + 4954.0 * exp(0.064102564102564111 * var_chaste_interface__cell__V); // ms
        const double var_ICaL__tauca = (-var_ICaL__tau_ca + var_ICaL__recov) * var_ICaL__Pr + var_ICaL__tau_ca; // ms
        const double var_ICaL__k5 = (1.0 - var_ICaL__Ps) / var_ICaL__tauca; // per_ms
        const double var_ICaL__k6 = var_ICaL__Ps * var_ICaL__fca / var_ICaL__tauca; // per_ms
        const double var_ICaL__k4 = var_ICaL__alpha * var_ICaL__k1 * var_ICaL__k3 * var_ICaL__k5 / (var_ICaL__beta * var_ICaL__k2 * var_ICaL__k6); // per_ms
        const double d_dt_chaste_interface_var_ICaL__xi1ca = var_chaste_interface__ICaL__c1 * var_ICaL__k1 + var_ICaL__k4 * var_chaste_interface__ICaL__xi2ca + var_ICaL__po * var_ICaL__s1 - (var_ICaL__k2 + var_ICaL__k3 + var_ICaL__s2) * var_chaste_interface__ICaL__xi1ca; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__xi1ca;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative7(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            double var_chaste_interface__Ca__Ca_dyad = rY[21];
            // Units: uM; Initial value: 1.716573130685
            
            const double var_x149 = pow(var_chaste_interface__Ca__Ca_dyad, 3);
            const double var_x150 = 1 / var_x149;
            const double var_x151 = 1 / (1.0 + 27.0 * var_x150);
            const double var_x202 = exp(-13.333333333333334 - 0.33333333333333331 * var_chaste_interface__cell__V);
            const double var_x203 = 1.0 + var_x202;
            const double var_x207 = 0.33333333333333331 / var_x203;
            const double var_x218 = -0.018268800000000002 * var_x151;
            const double var_x219 = 41.377027474346242 + 1117.1797418073486 * var_x150;
            
            partialF = -0.33343694833333332 + var_x207 + var_x218 - 1.8929217120000003e-7 * var_x151 * var_x219;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative8(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__ICaL__c1 = rY[5];
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = rY[7];
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi1ba = rY[8];
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ca = rY[9];
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = rY[10];
        // Units: dimensionless; Initial value: 0.015242594688
        
        
        // Mathematics
        const double var_ICaL__k1t = 0.00413; // per_ms
        const double var_ICaL__k2t = 0.0022399999999999998; // per_ms
        const double var_ICaL__r1 = 0.29999999999999999; // per_ms
        const double var_ICaL__r2 = 3.0; // per_ms
        const double var_ICaL__s1t = 0.0019499999999999999; // per_ms
        const double var_ICaL__s2t = var_ICaL__k2t * var_ICaL__r1 * var_ICaL__s1t / (var_ICaL__k1t * var_ICaL__r2); // per_ms
        const double var_ICaL__s6 = 8.0; // mV
        const double var_ICaL__sx = 3.0; // mV
        const double var_ICaL__sy = 4.0; // mV
        const double var_ICaL__syr = 11.32; // mV
        const double var_ICaL__tau3 = 3.0; // ms
        const double var_ICaL__taupo = 1.0; // ms
        const double var_ICaL__vth = 0; // mV
        const double var_ICaL__vx = -40.0; // mV
        const double var_ICaL__vy = -40.0; // mV
        const double var_ICaL__vyr = -40.0; // mV
        const double var_ICaL__po = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca; // dimensionless
        const double var_ICaL__Pr = 1.0 - 1.0 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vy) / var_ICaL__sy)); // dimensionless
        const double var_ICaL__Ps = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vyr) / var_ICaL__syr)); // dimensionless
        const double var_ICaL__poi = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vx) / var_ICaL__sx)); // dimensionless
        const double var_ICaL__k3 = (1.0 - var_ICaL__poi) / var_ICaL__tau3; // per_ms
        const double var_ICaL__k3t = var_ICaL__k3; // per_ms
        const double var_ICaL__poinf = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vth) / var_ICaL__s6)); // dimensionless
        const double var_ICaL__alpha = var_ICaL__poinf / var_ICaL__taupo; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__poinf) / var_ICaL__taupo; // per_ms
        const double var_ICaL__recov = 10.0 + 4954.0 * exp(0.064102564102564111 * var_chaste_interface__cell__V); // ms
        const double var_ICaL__tauba = 450.0 + (-450.0 + var_ICaL__recov) * var_ICaL__Pr; // ms
        const double var_ICaL__k5t = (1.0 - var_ICaL__Ps) / var_ICaL__tauba; // per_ms
        const double var_ICaL__k6t = var_ICaL__Ps / var_ICaL__tauba; // per_ms
        const double var_ICaL__k4t = var_ICaL__alpha * var_ICaL__k1t * var_ICaL__k3t * var_ICaL__k5t / (var_ICaL__beta * var_ICaL__k2t * var_ICaL__k6t); // per_ms
        const double d_dt_chaste_interface_var_ICaL__xi1ba = var_chaste_interface__ICaL__c1 * var_ICaL__k1t + var_ICaL__k4t * var_chaste_interface__ICaL__xi2ba + var_ICaL__po * var_ICaL__s1t - (var_ICaL__k2t + var_ICaL__k3t + var_ICaL__s2t) * var_chaste_interface__ICaL__xi1ba; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__xi1ba;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative8(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            
            const double var_x202 = exp(-13.333333333333334 - 0.33333333333333331 * var_chaste_interface__cell__V);
            const double var_x203 = 1.0 + var_x202;
            const double var_x207 = 0.33333333333333331 / var_x203;
            
            partialF = -0.33762909604519775 + var_x207;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative9(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = rY[7];
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi2ca = rY[9];
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__Ca__Ca_dyad = rY[21];
        // Units: uM; Initial value: 1.716573130685
        
        
        // Mathematics
        const double var_ICaL__cat = 3.0; // uM
        const double var_ICaL__cpt = 6.0936500000000002; // uM
        const double var_ICaL__fca = 1 / (1.0 + pow(var_ICaL__cat, 3) / pow(var_chaste_interface__Ca__Ca_dyad, 3)); // dimensionless
        const double var_ICaL__k1 = 0.024167999999999999 * var_ICaL__fca; // per_ms
        const double var_ICaL__k2 = 0.000103615; // per_ms
        const double var_ICaL__s6 = 8.0; // mV
        const double var_ICaL__sx = 3.0; // mV
        const double var_ICaL__sy = 4.0; // mV
        const double var_ICaL__syr = 11.32; // mV
        const double var_ICaL__tau3 = 3.0; // ms
        const double var_ICaL__taupo = 1.0; // ms
        const double var_ICaL__tca = 78.032899999999998; // ms
        const double var_ICaL__tau_ca = 0.10000000000000001 + var_ICaL__tca / (1.0 + pow(var_chaste_interface__Ca__Ca_dyad, 4) / pow(var_ICaL__cpt, 4)); // ms
        const double var_ICaL__vth = 0; // mV
        const double var_ICaL__vx = -40.0; // mV
        const double var_ICaL__vy = -40.0; // mV
        const double var_ICaL__vyr = -40.0; // mV
        const double var_ICaL__Pr = 1.0 - 1.0 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vy) / var_ICaL__sy)); // dimensionless
        const double var_ICaL__Ps = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vyr) / var_ICaL__syr)); // dimensionless
        const double var_ICaL__poi = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vx) / var_ICaL__sx)); // dimensionless
        const double var_ICaL__k3 = (1.0 - var_ICaL__poi) / var_ICaL__tau3; // per_ms
        const double var_ICaL__poinf = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vth) / var_ICaL__s6)); // dimensionless
        const double var_ICaL__alpha = var_ICaL__poinf / var_ICaL__taupo; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__poinf) / var_ICaL__taupo; // per_ms
        const double var_ICaL__recov = 10.0 + 4954.0 * exp(0.064102564102564111 * var_chaste_interface__cell__V); // ms
        const double var_ICaL__tauca = (-var_ICaL__tau_ca + var_ICaL__recov) * var_ICaL__Pr + var_ICaL__tau_ca; // ms
        const double var_ICaL__k5 = (1.0 - var_ICaL__Ps) / var_ICaL__tauca; // per_ms
        const double var_ICaL__k6 = var_ICaL__Ps * var_ICaL__fca / var_ICaL__tauca; // per_ms
        const double var_ICaL__k4 = var_ICaL__alpha * var_ICaL__k1 * var_ICaL__k3 * var_ICaL__k5 / (var_ICaL__beta * var_ICaL__k2 * var_ICaL__k6); // per_ms
        const double d_dt_chaste_interface_var_ICaL__xi2ca = var_chaste_interface__ICaL__c2 * var_ICaL__k6 + var_ICaL__k3 * var_chaste_interface__ICaL__xi1ca - (var_ICaL__k4 + var_ICaL__k5) * var_chaste_interface__ICaL__xi2ca; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__xi2ca;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative9(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            double var_chaste_interface__Ca__Ca_dyad = rY[21];
            // Units: uM; Initial value: 1.716573130685
            
            const double var_x142 = exp(-0.125 * var_chaste_interface__cell__V);
            const double var_x143 = 1.0 + var_x142;
            const double var_x147 = 1 / var_x143;
            const double var_x148 = var_x147;
            const double var_x152 = pow(var_chaste_interface__Ca__Ca_dyad, 4);
            const double var_x156 = exp(-10.0 - 0.25 * var_chaste_interface__cell__V);
            const double var_x157 = 1.0 + var_x156;
            const double var_x158 = 1.0 - 1.0 / var_x157;
            const double var_x159 = exp(0.064102564102564111 * var_chaste_interface__cell__V);
            const double var_x160 = 4954.0 * var_x159;
            const double var_x164 = exp(-3.5335689045936394 - 0.088339222614840993 * var_chaste_interface__cell__V);
            const double var_x165 = 1.0 + var_x164;
            const double var_x168 = 1 / var_x165;
            const double var_x173 = 1.0 + 0.00072525373756441506 * var_x152;
            const double var_x174 = 1 / var_x173;
            const double var_x175 = 78.032899999999998 * var_x174;
            const double var_x176 = 9.9000000000000004 + var_x160 - var_x175;
            const double var_x177 = var_x158 * var_x176;
            const double var_x178 = 1 / (0.10000000000000001 + var_x175 + var_x177);
            const double var_x185 = var_x168;
            const double var_x186 = 1.0 - var_x185;
            const double var_x190 = -var_x148;
            const double var_x191 = 1.0 + var_x190;
            const double var_x194 = var_x178 * var_x186;
            const double var_x202 = exp(-13.333333333333334 - 0.33333333333333331 * var_chaste_interface__cell__V);
            const double var_x203 = 1.0 + var_x202;
            const double var_x207 = 0.33333333333333331 / var_x203;
            const double var_x208 = 0.33333333333333331 - var_x207;
            const double var_x209 = 1 / var_x191;
            const double var_x210 = var_x147 * var_x209;
            const double var_x215 = var_x165 * var_x208;
            const double var_x220 = var_x186 * var_x215;
            const double var_x221 = var_x210 * var_x220;
            const double var_x222 = 233.2480818414322 * var_x221;
            
            partialF = -var_x194 - var_x222;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative10(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ba = rY[8];
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ba = rY[10];
        // Units: dimensionless; Initial value: 0.015242594688
        
        
        // Mathematics
        const double var_ICaL__k1t = 0.00413; // per_ms
        const double var_ICaL__k2t = 0.0022399999999999998; // per_ms
        const double var_ICaL__s6 = 8.0; // mV
        const double var_ICaL__sx = 3.0; // mV
        const double var_ICaL__sy = 4.0; // mV
        const double var_ICaL__syr = 11.32; // mV
        const double var_ICaL__tau3 = 3.0; // ms
        const double var_ICaL__taupo = 1.0; // ms
        const double var_ICaL__vth = 0; // mV
        const double var_ICaL__vx = -40.0; // mV
        const double var_ICaL__vy = -40.0; // mV
        const double var_ICaL__vyr = -40.0; // mV
        const double var_ICaL__Pr = 1.0 - 1.0 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vy) / var_ICaL__sy)); // dimensionless
        const double var_ICaL__Ps = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vyr) / var_ICaL__syr)); // dimensionless
        const double var_ICaL__poi = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vx) / var_ICaL__sx)); // dimensionless
        const double var_ICaL__k3 = (1.0 - var_ICaL__poi) / var_ICaL__tau3; // per_ms
        const double var_ICaL__k3t = var_ICaL__k3; // per_ms
        const double var_ICaL__poinf = 1 / (1.0 + exp((-var_chaste_interface__cell__V + var_ICaL__vth) / var_ICaL__s6)); // dimensionless
        const double var_ICaL__alpha = var_ICaL__poinf / var_ICaL__taupo; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__poinf) / var_ICaL__taupo; // per_ms
        const double var_ICaL__recov = 10.0 + 4954.0 * exp(0.064102564102564111 * var_chaste_interface__cell__V); // ms
        const double var_ICaL__tauba = 450.0 + (-450.0 + var_ICaL__recov) * var_ICaL__Pr; // ms
        const double var_ICaL__k5t = (1.0 - var_ICaL__Ps) / var_ICaL__tauba; // per_ms
        const double var_ICaL__k6t = var_ICaL__Ps / var_ICaL__tauba; // per_ms
        const double var_ICaL__k4t = var_ICaL__alpha * var_ICaL__k1t * var_ICaL__k3t * var_ICaL__k5t / (var_ICaL__beta * var_ICaL__k2t * var_ICaL__k6t); // per_ms
        const double d_dt_chaste_interface_var_ICaL__xi2ba = var_chaste_interface__ICaL__c2 * var_ICaL__k6t + var_ICaL__k3t * var_chaste_interface__ICaL__xi1ba - (var_ICaL__k4t + var_ICaL__k5t) * var_chaste_interface__ICaL__xi2ba; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__xi2ba;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative10(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            
            const double var_x142 = exp(-0.125 * var_chaste_interface__cell__V);
            const double var_x143 = 1.0 + var_x142;
            const double var_x147 = 1 / var_x143;
            const double var_x148 = var_x147;
            const double var_x156 = exp(-10.0 - 0.25 * var_chaste_interface__cell__V);
            const double var_x157 = 1.0 + var_x156;
            const double var_x158 = 1.0 - 1.0 / var_x157;
            const double var_x159 = exp(0.064102564102564111 * var_chaste_interface__cell__V);
            const double var_x160 = 4954.0 * var_x159;
            const double var_x161 = -440.0 + var_x160;
            const double var_x162 = var_x158 * var_x161;
            const double var_x163 = 1 / (450.0 + var_x162);
            const double var_x164 = exp(-3.5335689045936394 - 0.088339222614840993 * var_chaste_interface__cell__V);
            const double var_x165 = 1.0 + var_x164;
            const double var_x168 = 1 / var_x165;
            const double var_x185 = var_x168;
            const double var_x186 = 1.0 - var_x185;
            const double var_x190 = -var_x148;
            const double var_x191 = 1.0 + var_x190;
            const double var_x195 = var_x163 * var_x186;
            const double var_x202 = exp(-13.333333333333334 - 0.33333333333333331 * var_chaste_interface__cell__V);
            const double var_x203 = 1.0 + var_x202;
            const double var_x207 = 0.33333333333333331 / var_x203;
            const double var_x208 = 0.33333333333333331 - var_x207;
            const double var_x209 = 1 / var_x191;
            const double var_x210 = var_x147 * var_x209;
            const double var_x215 = var_x165 * var_x208;
            const double var_x220 = var_x186 * var_x215;
            const double var_x221 = var_x210 * var_x220;
            const double var_x233 = 1.8437500000000002 * var_x221;
            
            partialF = -var_x195 - var_x233;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative11(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__IKr__xr = rY[11];
        // Units: dimensionless; Initial value: 0.007074239331
        
        
        // Mathematics
        const double var_IKr__xkrinf = 1 / (1.0 + exp(-6.666666666666667 - 0.13333333333333333 * var_chaste_interface__cell__V)); // dimensionless
        const double var_IKr__xkrv1 = ((fabs(7.0 + var_chaste_interface__cell__V) > 0.001) ? (0.0013799999999999999 * (7.0 + var_chaste_interface__cell__V) / (1.0 - exp(-0.86099999999999999 - 0.123 * var_chaste_interface__cell__V))) : (0.011219512195121951)); // per_ms
        const double var_IKr__xkrv2 = ((fabs(10.0 + var_chaste_interface__cell__V) > 0.001) ? (0.00060999999999999997 * (10.0 + var_chaste_interface__cell__V) / (-1.0 + exp(1.45 + 0.14499999999999999 * var_chaste_interface__cell__V))) : (0.0042068965517241376)); // per_ms
        const double var_IKr__taukr = 1 / (var_IKr__xkrv1 + var_IKr__xkrv2); // ms
        const double d_dt_chaste_interface_var_IKr__xr = (-var_chaste_interface__IKr__xr + var_IKr__xkrinf) / var_IKr__taukr; // 1 / ms

        return d_dt_chaste_interface_var_IKr__xr;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative11(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            
            const double var_x237 = exp(1.45 + 0.14499999999999999 * var_chaste_interface__cell__V);
            const double var_x238 = -1.0 + var_x237;
            const double var_x239 = 0.00060999999999999997 / var_x238;
            const double var_x240 = 10.0 + var_chaste_interface__cell__V;
            const double var_x241 = fabs(var_x240) > 0.001;
            const double var_x242 = exp(-0.86099999999999999 - 0.123 * var_chaste_interface__cell__V);
            const double var_x243 = 1.0 - var_x242;
            const double var_x244 = 0.0013799999999999999 / var_x243;
            const double var_x245 = 7.0 + var_chaste_interface__cell__V;
            const double var_x246 = fabs(var_x245) > 0.001;
            const double var_x247 = ((var_x241) ? (var_x239 * var_x240) : (0.0042068965517241376));
            const double var_x248 = ((var_x246) ? (var_x244 * var_x245) : (0.011219512195121951));
            
            partialF = -var_x247 - var_x248;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative12(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__IKs__xs1 = rY[12];
        // Units: dimensionless; Initial value: 0.048267587131
        
        
        // Mathematics
        const double var_IKs__tauxs1 = ((fabs(30.0 + var_chaste_interface__cell__V) < 0.014556040756914121) ? (417.94625266107982) : (1 / (0.00013100000000000001 * (30.0 + var_chaste_interface__cell__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__cell__V)) + 7.1899999999999999e-5 * (30.0 + var_chaste_interface__cell__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__cell__V))))); // ms
        const double var_IKs__xs1ss = 1 / (1.0 + exp(0.089820359281437126 - 0.059880239520958084 * var_chaste_interface__cell__V)); // dimensionless
        const double d_dt_chaste_interface_var_IKs__xs1 = (-var_chaste_interface__IKs__xs1 + var_IKs__xs1ss) / var_IKs__tauxs1; // 1 / ms

        return d_dt_chaste_interface_var_IKs__xs1;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative12(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            
            const double var_x252 = 30.0 + var_chaste_interface__cell__V;
            const double var_x253 = fabs(var_x252) < 0.014556040756914121;
            const double var_x254 = exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__cell__V);
            const double var_x255 = -1.0 + var_x254;
            const double var_x256 = 0.00013100000000000001 / var_x255;
            const double var_x257 = exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__cell__V);
            const double var_x258 = 1.0 - var_x257;
            const double var_x259 = 7.1899999999999999e-5 / var_x258;
            const double var_x261 = ((var_x253) ? (0.0023926521499665608) : (var_x252 * var_x256 + var_x252 * var_x259));
            
            partialF = -var_x261;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative13(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__IKs__xs2 = rY[13];
        // Units: dimensionless; Initial value: 0.105468807033
        
        
        // Mathematics
        const double var_IKs__tauxs1 = ((fabs(30.0 + var_chaste_interface__cell__V) < 0.014556040756914121) ? (417.94625266107982) : (1 / (0.00013100000000000001 * (30.0 + var_chaste_interface__cell__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__cell__V)) + 7.1899999999999999e-5 * (30.0 + var_chaste_interface__cell__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__cell__V))))); // ms
        const double var_IKs__tauxs2 = 4.0 * var_IKs__tauxs1; // ms
        const double var_IKs__xs1ss = 1 / (1.0 + exp(0.089820359281437126 - 0.059880239520958084 * var_chaste_interface__cell__V)); // dimensionless
        const double var_IKs__xs2ss = var_IKs__xs1ss; // dimensionless
        const double d_dt_chaste_interface_var_IKs__xs2 = (-var_chaste_interface__IKs__xs2 + var_IKs__xs2ss) / var_IKs__tauxs2; // 1 / ms

        return d_dt_chaste_interface_var_IKs__xs2;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative13(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            
            const double var_x252 = 30.0 + var_chaste_interface__cell__V;
            const double var_x253 = fabs(var_x252) < 0.014556040756914121;
            const double var_x254 = exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__cell__V);
            const double var_x255 = -1.0 + var_x254;
            const double var_x256 = 0.00013100000000000001 / var_x255;
            const double var_x257 = exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__cell__V);
            const double var_x258 = 1.0 - var_x257;
            const double var_x259 = 7.1899999999999999e-5 / var_x258;
            const double var_x261 = ((var_x253) ? (0.0023926521499665608) : (var_x252 * var_x256 + var_x252 * var_x259));
            
            partialF = -0.25 * var_x261;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative14(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ito__xtos = rY[14];
        // Units: dimensionless; Initial value: 0.00364776906
        
        
        // Mathematics
        const double var_Ito__rt1 = -0.20000000000000001 - 0.066666666666666666 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__txs = 0.5 + 9.0 / (1.0 + exp(-var_Ito__rt1)); // ms
        const double var_Ito__xtos_inf = 1 / (1.0 + exp(var_Ito__rt1)); // dimensionless
        const double d_dt_chaste_interface_var_Ito__xtos = (-var_chaste_interface__Ito__xtos + var_Ito__xtos_inf) / var_Ito__txs; // 1 / ms

        return d_dt_chaste_interface_var_Ito__xtos;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative14(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            
            const double var_x263 = 0.066666666666666666 * var_chaste_interface__cell__V;
            const double var_x264 = exp(0.20000000000000001 + var_x263);
            const double var_x265 = 1.0 + var_x264;
            const double var_x266 = 1 / var_x265;
            const double var_x267 = 1 / (0.5 + 9.0 * var_x266);
            
            partialF = -var_x267;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative15(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ito__ytos = rY[15];
        // Units: dimensionless; Initial value: 0.174403618112
        
        
        // Mathematics
        const double var_Ito__rt2 = 3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rt3 = 6.0 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__tys = 30.0 + 3000.0 / (1.0 + exp(var_Ito__rt3)); // ms
        const double var_Ito__ytos_inf = 1 / (1.0 + exp(var_Ito__rt2)); // dimensionless
        const double d_dt_chaste_interface_var_Ito__ytos = (-var_chaste_interface__Ito__ytos + var_Ito__ytos_inf) / var_Ito__tys; // 1 / ms

        return d_dt_chaste_interface_var_Ito__ytos;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative15(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            
            const double var_x11 = 0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x272 = exp(6.0 + var_x11);
            const double var_x273 = 1.0 + var_x272;
            const double var_x274 = 1 / var_x273;
            const double var_x275 = 1 / (30.0 + 3000.0 * var_x274);
            
            partialF = -var_x275;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative16(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ito__xtof = rY[16];
        // Units: dimensionless; Initial value: 0.003643592594
        
        
        // Mathematics
        const double var_Ito__rt1 = -0.20000000000000001 - 0.066666666666666666 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rt4 = -0.0011111111111111111 * pow(var_chaste_interface__cell__V, 2); // dimensionless
        const double var_Ito__txf = 1.5 + 3.5 * exp(var_Ito__rt4); // ms
        const double var_Ito__xtos_inf = 1 / (1.0 + exp(var_Ito__rt1)); // dimensionless
        const double var_Ito__xtof_inf = var_Ito__xtos_inf; // dimensionless
        const double d_dt_chaste_interface_var_Ito__xtof = (-var_chaste_interface__Ito__xtof + var_Ito__xtof_inf) / var_Ito__txf; // 1 / ms

        return d_dt_chaste_interface_var_Ito__xtof;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative16(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            
            const double var_x278 = exp(-0.0011111111111111111 * pow(var_chaste_interface__cell__V, 2));
            const double var_x279 = 1 / (1.5 + 3.5 * var_x278);
            
            partialF = -var_x279;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative17(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ito__ytof = rY[17];
        // Units: dimensionless; Initial value: 0.993331326442
        
        
        // Mathematics
        const double var_Ito__rt2 = 3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__rt5 = 3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V; // dimensionless
        const double var_Ito__tyf = 20.0 + 20.0 / (1.0 + exp(var_Ito__rt5)); // ms
        const double var_Ito__ytos_inf = 1 / (1.0 + exp(var_Ito__rt2)); // dimensionless
        const double var_Ito__ytof_inf = var_Ito__ytos_inf; // dimensionless
        const double d_dt_chaste_interface_var_Ito__ytof = (-var_chaste_interface__Ito__ytof + var_Ito__ytof_inf) / var_Ito__tyf; // 1 / ms

        return d_dt_chaste_interface_var_Ito__ytof;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative17(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            
            const double var_x11 = 0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x12 = exp(3.3500000000000001 + var_x11);
            const double var_x13 = 1.0 + var_x12;
            const double var_x14 = 1 / var_x13;
            const double var_x280 = 1 / (20.0 + 20.0 * var_x14);
            
            partialF = -var_x280;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative18(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Irel__Ca_JSR = rY[18];
        // Units: uM; Initial value: 97.505463697266
        double var_chaste_interface__Ca__Ca_NSR = rY[23];
        // Units: uM; Initial value: 104.450004990523
        
        
        // Mathematics
        const double var_Irel__taua = 100.0; // ms
        const double d_dt_chaste_interface_var_Irel__Ca_JSR = (-var_chaste_interface__Irel__Ca_JSR + var_chaste_interface__Ca__Ca_NSR) / var_Irel__taua; // uM / ms

        return d_dt_chaste_interface_var_Irel__Ca_JSR;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative18(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.01;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative19(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ca__Ca_i_converted = rY[1];
        // Units: millimolar; Initial value: 0.000256752008084
        double var_chaste_interface__ICaL__c1 = rY[5];
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = rY[7];
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi1ba = rY[8];
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ca = rY[9];
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = rY[10];
        // Units: dimensionless; Initial value: 0.015242594688
        double var_chaste_interface__Irel__Ca_JSR = rY[18];
        // Units: uM; Initial value: 97.505463697266
        double var_chaste_interface__Irel__xir = rY[19];
        // Units: uM_per_ms; Initial value: 0.006679257264
        double var_chaste_interface__Ca__Ca_submem = rY[22];
        // Units: uM; Initial value: 0.226941113355
        double var_chaste_interface__Ca__Ca_NSR = rY[23];
        // Units: uM; Initial value: 104.450004990523
        
        
        // Mathematics
        const double var_Ca__Ca_i = 1000.0 * var_chaste_interface__Ca__Ca_i_converted; // uM
        const double var_Ca__csm = 0.001 * var_chaste_interface__Ca__Ca_submem; // mM
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__F = 96.485341500000004; // coulomb_per_mmole
        const double var_Environment__R = 8.3144720000000003; // J_per_moleK
        const double var_Environment__T = 308.0; // kelvin
        const double var_Environment__FonRT = var_Environment__F / (var_Environment__R * var_Environment__T); // per_mV
        const double var_ICaL__pca = 0.00054000000000000001; // cm_per_s
        const double var_ICaL__po = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca; // dimensionless
        const double var_Ileak_Iup_Ixfer__cup = 0.5; // uM
        const double var_Ileak_Iup_Ixfer__gleak = 2.069e-5; // per_ms
        const double var_Ileak_Iup_Ixfer__kj = 50.0; // uM
        const double var_Ileak_Iup_Ixfer__jleak = pow(var_chaste_interface__Ca__Ca_NSR, 2) * (-var_Ca__Ca_i + 16.667000000000002 * var_chaste_interface__Ca__Ca_NSR) * var_Ileak_Iup_Ixfer__gleak / (pow(var_chaste_interface__Ca__Ca_NSR, 2) + pow(var_Ileak_Iup_Ixfer__kj, 2)); // uM_per_ms
        const double var_Ileak_Iup_Ixfer__vup = 0.40000000000000002; // uM_per_ms
        const double var_Ileak_Iup_Ixfer__jup = pow(var_Ca__Ca_i, 2) * var_Ileak_Iup_Ixfer__vup / (pow(var_Ca__Ca_i, 2) + pow(var_Ileak_Iup_Ixfer__cup, 2)); // uM_per_ms
        const double var_Irel__av = 11.300000000000001; // per_ms
        const double var_Irel__ay = 0.050000000000000003; // per_mV
        const double var_Irel__cstar = 90.0; // uM
        const double var_Irel__bv = -50.0 + (1.0 - var_Irel__av) * var_Irel__cstar; // uM_per_ms
        const double var_Irel__Qr0 = (((var_chaste_interface__Irel__Ca_JSR > 50.0) && (var_chaste_interface__Irel__Ca_JSR < var_Irel__cstar)) ? (-50.0 + var_chaste_interface__Irel__Ca_JSR) : ((var_chaste_interface__Irel__Ca_JSR >= var_Irel__cstar) ? (var_chaste_interface__Irel__Ca_JSR * var_Irel__av + var_Irel__bv) : (0))); // uM_per_ms
        const double var_Irel__Qr = var_chaste_interface__Ca__Ca_NSR * var_Irel__Qr0 / var_Irel__cstar; // uM_per_ms
        const double var_Irel__gryr = 2.5807899999999999; // per_ms
        const double var_Irel__taur = 30.0; // ms
        const double var_Ca__dCa_JSR = -var_Ileak_Iup_Ixfer__jleak - var_chaste_interface__Irel__xir + var_Ileak_Iup_Ixfer__jup; // uM_per_ms
        const double var_ICaL__za = 2.0 * var_Environment__FonRT * var_chaste_interface__cell__V; // dimensionless
        const double var_ICaL__rxa = ((fabs(var_ICaL__za) < 0.001) ? (2.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_ICaL__pca) : (4.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_Environment__FonRT * var_ICaL__pca * var_chaste_interface__cell__V / (-1.0 + exp(var_ICaL__za)))); // mA_per_cm2
        const double var_Irel__sparkV = exp(-(30.0 + var_chaste_interface__cell__V) * var_Irel__ay) / (1.0 + exp(-(30.0 + var_chaste_interface__cell__V) * var_Irel__ay)); // dimensionless
        const double var_Irel__spark_rate = var_ICaL__po * var_Irel__gryr * var_Irel__sparkV * fabs(var_ICaL__rxa); // per_ms
        const double d_dt_chaste_interface_var_Irel__xir = var_Irel__Qr * var_Irel__spark_rate - (1.0 - var_Ca__dCa_JSR * var_Irel__taur / var_chaste_interface__Ca__Ca_NSR) * var_chaste_interface__Irel__xir / var_Irel__taur; // uM_per_ms / ms

        return d_dt_chaste_interface_var_Irel__xir;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative19(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca__Ca_i_converted = rY[1];
            // Units: millimolar; Initial value: 0.000256752008084
            double var_chaste_interface__Irel__xir = rY[19];
            // Units: uM_per_ms; Initial value: 0.006679257264
            double var_chaste_interface__Ca__Ca_NSR = rY[23];
            // Units: uM; Initial value: 104.450004990523
            
            const double var_x91 = pow(var_chaste_interface__Ca__Ca_i_converted, 2);
            const double var_x93 = pow(var_chaste_interface__Ca__Ca_NSR, 2);
            const double var_x94 = 1 / (2500.0 + var_x93);
            const double var_x95 = var_x93 * var_x94;
            const double var_x97 = 1 / (0.25 + 1000000.0 * var_x91);
            const double var_x107 = 400000.0 * var_x91 * var_x97;
            const double var_x108 = 16.667000000000002 * var_chaste_interface__Ca__Ca_NSR - 1000.0 * var_chaste_interface__Ca__Ca_i_converted;
            const double var_x109 = 2.069e-5 * var_x108 * var_x95;
            const double var_x299 = 1 / var_chaste_interface__Ca__Ca_NSR;
            const double var_x300 = var_x299 * var_chaste_interface__Irel__xir;
            const double var_x303 = var_x107 - var_x109 - var_chaste_interface__Irel__xir;
            
            partialF = -0.033333333333333333 - var_x300 + var_x299 * var_x303;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative20(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__INa__xm = rY[2];
        // Units: dimensionless; Initial value: 0.001075453357
        double var_chaste_interface__INa__xh = rY[3];
        // Units: dimensionless; Initial value: 0.990691306716
        double var_chaste_interface__INa__xj = rY[4];
        // Units: dimensionless; Initial value: 0.993888937283
        double var_chaste_interface__Na__Na_i = rY[20];
        // Units: mM; Initial value: 11.441712311614
        double var_chaste_interface__Ca__Ca_submem = rY[22];
        // Units: uM; Initial value: 0.226941113355
        
        
        // Mathematics
        const double var_Ca__csm = 0.001 * var_chaste_interface__Ca__Ca_submem; // mM
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__F = 96.485341500000004; // coulomb_per_mmole
        const double var_Environment__K_o = 5.4000000000000004; // mM
        const double var_Environment__Na_o = 136.0; // mM
        const double var_Environment__R = 8.3144720000000003; // J_per_moleK
        const double var_Environment__T = 308.0; // kelvin
        const double var_Environment__FonRT = var_Environment__F / (var_Environment__R * var_Environment__T); // per_mV
        const double var_INaCa__gNaCa = 0.83999999999999997; // uM_per_ms
        const double var_INaCa__xkdna = 0.29999999999999999; // uM
        const double var_INaCa__aloss = 1 / (1.0 + pow(var_INaCa__xkdna, 3) / pow(var_chaste_interface__Ca__Ca_submem, 3)); // dimensionless
        const double var_INaCa__xmcai = 0.0035999999999999999; // mM
        const double var_INaCa__xmcao = 1.3; // mM
        const double var_INaCa__xmnai = 12.300000000000001; // mM
        const double var_INaCa__xmnao = 87.5; // mM
        const double var_INaCa__yz2 = pow(var_INaCa__xmnai, 3) * (1.0 + var_Ca__csm / var_INaCa__xmcai) * var_Environment__Ca_o; // mM4
        const double var_INaK__gNaK = 1.5; // nA_per_nF
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_Environment__Na_o); // dimensionless
        const double var_INaK__xkmko = 1.5; // mM
        const double var_INaK__xkmnai = 12.0; // mM
        const double var_INaCa__yz1 = pow(var_INaCa__xmnao, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__xmcao; // mM4
        const double var_INaCa__yz3 = pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__xmnai, 3)) * var_INaCa__xmcai; // mM4
        const double var_INaCa__yz4 = pow(var_Environment__Na_o, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o; // mM4
        const double var_INaCa__zw8 = var_INaCa__yz1 + var_INaCa__yz2 + var_INaCa__yz3 + var_INaCa__yz4; // mM4
        const double var_INaCa__zw3 = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(0.34999999999999998 * var_Environment__FonRT * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_Ca__csm * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__zw4 = 1.0 + 0.20000000000000001 * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__jNaCa = var_INaCa__aloss * var_INaCa__gNaCa * var_INaCa__zw3 / (var_INaCa__zw4 * var_INaCa__zw8); // uM_per_ms
        const double var_INaK__fNaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_Environment__FonRT * var_chaste_interface__cell__V) + 0.036499999999999998 * var_INaK__sigma * exp(-var_Environment__FonRT * var_chaste_interface__cell__V)); // dimensionless
        const double var_INaK__xiNaK = var_Environment__K_o * var_INaK__fNaK * var_INaK__gNaK * var_chaste_interface__Na__Na_i / ((var_Environment__K_o + var_INaK__xkmko) * (var_INaK__xkmnai + var_chaste_interface__Na__Na_i)); // nA_per_nF
        const double var_cell__wca = 8.0; // mV_per_uM
        const double var_INaCa__xiNaCa = var_INaCa__jNaCa * var_cell__wca; // nA_per_nF
        const double var_reversal_potentials__ena = log(var_Environment__Na_o / var_chaste_interface__Na__Na_i) / var_Environment__FonRT; // mV
        const double var_INa__xina = pow(var_chaste_interface__INa__xm, 3) * (-var_reversal_potentials__ena + var_chaste_interface__cell__V) * mParameters[4] * var_chaste_interface__INa__xh * var_chaste_interface__INa__xj; // nA_per_nF
        const double d_dt_chaste_interface_var_Na__Na_i = 0.001 * (-var_INa__xina - 3.0 * var_INaCa__xiNaCa - 3.0 * var_INaK__xiNaK) / var_cell__wca; // mM / ms

        return d_dt_chaste_interface_var_Na__Na_i;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative20(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            double var_chaste_interface__INa__xm = rY[2];
            // Units: dimensionless; Initial value: 0.001075453357
            double var_chaste_interface__INa__xh = rY[3];
            // Units: dimensionless; Initial value: 0.990691306716
            double var_chaste_interface__INa__xj = rY[4];
            // Units: dimensionless; Initial value: 0.993888937283
            double var_chaste_interface__Na__Na_i = rY[20];
            // Units: mM; Initial value: 11.441712311614
            double var_chaste_interface__Ca__Ca_submem = rY[22];
            // Units: uM; Initial value: 0.226941113355
            
            const double var_x32 = pow(var_chaste_interface__INa__xm, 3);
            const double var_x33 = var_x32 * mParameters[4] * var_chaste_interface__INa__xj;
            const double var_x34 = var_x33 * var_chaste_interface__INa__xh;
            const double var_x37 = pow(var_chaste_interface__Na__Na_i, 3);
            const double var_x38 = exp(0.013186938812558063 * var_chaste_interface__cell__V);
            const double var_x39 = var_x37 * var_x38;
            const double var_x40 = exp(-0.024490029223322121 * var_chaste_interface__cell__V);
            const double var_x41 = var_x40 * var_chaste_interface__Ca__Ca_submem;
            const double var_x42 = 1 / (12405.2022 + 7.9663561662386391 * var_x37 + 4115.8113750000002 * var_chaste_interface__Ca__Ca_submem);
            const double var_x43 = 1.0 + 0.20000000000000001 * var_x40;
            const double var_x44 = 1 / var_x43;
            const double var_x45 = 1.0 + 0.026999999999999996 / pow(var_chaste_interface__Ca__Ca_submem, 3);
            const double var_x46 = 1 / var_x45;
            const double var_x47 = var_x44 * var_x46;
            const double var_x48 = var_x42 * var_x47;
            const double var_x50 = 1 / (12.0 + var_chaste_interface__Na__Na_i);
            const double var_x51 = exp(-0.0037676968035880187 * var_chaste_interface__cell__V);
            const double var_x52 = exp(2.0208023774145616);
            const double var_x53 = exp(-0.037676968035880186 * var_chaste_interface__cell__V);
            const double var_x54 = 1.0 + 0.1245 * var_x51 + 0.036499999999999998 * var_x53 * (-0.14285714285714285 + 0.14285714285714285 * var_x52);
            const double var_x60 = 1.8 * var_x39 - 2515.4560000000001 * var_x41;
            const double var_x68 = 1 / var_chaste_interface__Na__Na_i;
            const double var_x79 = 1 / var_x54;
            const double var_x80 = var_x50 * var_x79;
            const double var_x81 = var_x79 * var_chaste_interface__Na__Na_i / pow((1 + 0.083333333333333329 * var_chaste_interface__Na__Na_i), 2);
            const double var_x82 = pow(var_chaste_interface__Na__Na_i, 2);
            const double var_x83 = var_x47 * var_x60 / pow((1 + 0.0006421786632577935 * var_x37 + 0.33178107931203249 * var_chaste_interface__Ca__Ca_submem), 2);
            const double var_x84 = var_x82 * var_x83;
            const double var_x85 = var_x34 * var_x68;
            const double var_x86 = var_x38 * var_x48 * var_x82;
            
            partialF = 3.0570652173913045e-6 * var_x81 + 3.9135764302406278e-10 * var_x84 - 0.0033176767270912339 * var_x85 - 0.013608 * var_x86 - 0.00044021739130434783 * var_x80;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative21(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__ICaL__c1 = rY[5];
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = rY[7];
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi1ba = rY[8];
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ca = rY[9];
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = rY[10];
        // Units: dimensionless; Initial value: 0.015242594688
        double var_chaste_interface__Irel__Ca_JSR = rY[18];
        // Units: uM; Initial value: 97.505463697266
        double var_chaste_interface__Ca__Ca_dyad = rY[21];
        // Units: uM; Initial value: 1.716573130685
        double var_chaste_interface__Ca__Ca_submem = rY[22];
        // Units: uM; Initial value: 0.226941113355
        double var_chaste_interface__Ca__Ca_NSR = rY[23];
        // Units: uM; Initial value: 104.450004990523
        
        
        // Mathematics
        const double var_Ca__csm = 0.001 * var_chaste_interface__Ca__Ca_submem; // mM
        const double var_Ca__taups = 0.5; // ms
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__F = 96.485341500000004; // coulomb_per_mmole
        const double var_Environment__R = 8.3144720000000003; // J_per_moleK
        const double var_Environment__T = 308.0; // kelvin
        const double var_Environment__FonRT = var_Environment__F / (var_Environment__R * var_Environment__T); // per_mV
        const double var_ICaL__pca = 0.00054000000000000001; // cm_per_s
        const double var_ICaL__po = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca; // dimensionless
        const double var_Irel__av = 11.300000000000001; // per_ms
        const double var_Irel__ax = 0.35759999999999997; // per_mV
        const double var_Irel__cstar = 90.0; // uM
        const double var_Irel__bv = -50.0 + (1.0 - var_Irel__av) * var_Irel__cstar; // uM_per_ms
        const double var_Irel__Qr0 = (((var_chaste_interface__Irel__Ca_JSR > 50.0) && (var_chaste_interface__Irel__Ca_JSR < var_Irel__cstar)) ? (-50.0 + var_chaste_interface__Irel__Ca_JSR) : ((var_chaste_interface__Irel__Ca_JSR >= var_Irel__cstar) ? (var_chaste_interface__Irel__Ca_JSR * var_Irel__av + var_Irel__bv) : (0))); // uM_per_ms
        const double var_Irel__Qr = var_chaste_interface__Ca__Ca_NSR * var_Irel__Qr0 / var_Irel__cstar; // uM_per_ms
        const double var_Irel__gbarsr = 26841.799999999999; // dimensionless
        const double var_Irel__gdyad = 9000.0; // mmole_per_coulomb_cm
        const double var_ICaL__za = 2.0 * var_Environment__FonRT * var_chaste_interface__cell__V; // dimensionless
        const double var_ICaL__rxa = ((fabs(var_ICaL__za) < 0.001) ? (2.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_ICaL__pca) : (4.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_Environment__FonRT * var_ICaL__pca * var_chaste_interface__cell__V / (-1.0 + exp(var_ICaL__za)))); // mA_per_cm2
        const double var_Irel__xicap = var_ICaL__po * var_Irel__gdyad * fabs(var_ICaL__rxa); // uM_per_ms
        const double var_Irel__xirp = var_ICaL__po * var_Irel__Qr * var_Irel__gbarsr * fabs(var_ICaL__rxa) * exp(-(30.0 + var_chaste_interface__cell__V) * var_Irel__ax) / (1.0 + exp(-(30.0 + var_chaste_interface__cell__V) * var_Irel__ax)); // uM_per_ms
        const double var_Irel__xiryr = var_Irel__xicap + var_Irel__xirp; // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_dyad = -(-var_chaste_interface__Ca__Ca_submem + var_chaste_interface__Ca__Ca_dyad) / var_Ca__taups + var_Irel__xiryr; // uM / ms

        return d_dt_chaste_interface_var_Ca__Ca_dyad;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative21(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -2.0;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative22(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.169816169406
        double var_chaste_interface__Ca__Ca_i_converted = rY[1];
        // Units: millimolar; Initial value: 0.000256752008084
        double var_chaste_interface__ICaL__c1 = rY[5];
        // Units: dimensionless; Initial value: 1.8211252e-05
        double var_chaste_interface__ICaL__c2 = rY[6];
        // Units: dimensionless; Initial value: 0.979322592773
        double var_chaste_interface__ICaL__xi1ca = rY[7];
        // Units: dimensionless; Initial value: 0.001208153482
        double var_chaste_interface__ICaL__xi1ba = rY[8];
        // Units: dimensionless; Initial value: 3.3616596e-05
        double var_chaste_interface__ICaL__xi2ca = rY[9];
        // Units: dimensionless; Initial value: 0.004173008466
        double var_chaste_interface__ICaL__xi2ba = rY[10];
        // Units: dimensionless; Initial value: 0.015242594688
        double var_chaste_interface__Irel__xir = rY[19];
        // Units: uM_per_ms; Initial value: 0.006679257264
        double var_chaste_interface__Na__Na_i = rY[20];
        // Units: mM; Initial value: 11.441712311614
        double var_chaste_interface__Ca__Ca_submem = rY[22];
        // Units: uM; Initial value: 0.226941113355
        double var_chaste_interface__Ca__trops = rY[25];
        // Units: uM; Initial value: 19.864701949854
        
        
        // Mathematics
        const double var_Ca__Ca_i = 1000.0 * var_chaste_interface__Ca__Ca_i_converted; // uM
        const double var_Ca__bcal = 24.0; // uM
        const double var_Ca__bmem = 15.0; // uM
        const double var_Ca__bsar = 42.0; // uM
        const double var_Ca__btrop = 70.0; // uM
        const double var_Ca__csm = 0.001 * var_chaste_interface__Ca__Ca_submem; // mM
        const double var_Ca__kmem = 0.29999999999999999; // uM
        const double var_Ca__ksar = 13.0; // uM
        const double var_Ca__mempxs = var_Ca__bmem * var_Ca__kmem / pow((var_chaste_interface__Ca__Ca_submem + var_Ca__kmem), 2); // dimensionless
        const double var_Ca__sarpxs = var_Ca__bsar * var_Ca__ksar / pow((var_chaste_interface__Ca__Ca_submem + var_Ca__ksar), 2); // dimensionless
        const double var_Ca__srkd = 0.59999999999999998; // uM
        const double var_Ca__srmax = 47.0; // uM
        const double var_Ca__spxs = var_Ca__srkd * var_Ca__srmax / pow((var_chaste_interface__Ca__Ca_submem + var_Ca__srkd), 2); // dimensionless
        const double var_Ca__taud = 4.0; // ms
        const double var_Ca__jd = (-var_Ca__Ca_i + var_chaste_interface__Ca__Ca_submem) / var_Ca__taud; // uM_per_ms
        const double var_Ca__xkcal = 7.0; // uM
        const double var_Ca__bpxs = var_Ca__bcal * var_Ca__xkcal / pow((var_chaste_interface__Ca__Ca_submem + var_Ca__xkcal), 2); // dimensionless
        const double var_Ca__dcsib = 1 / (1.0 + var_Ca__bpxs + var_Ca__mempxs + var_Ca__sarpxs + var_Ca__spxs); // dimensionless
        const double var_Ca__xkoff = 0.019599999999999999; // per_ms
        const double var_Ca__xkon = 0.0327; // per_uM_per_ms
        const double var_Ca__xbs = -var_chaste_interface__Ca__trops * var_Ca__xkoff + (-var_chaste_interface__Ca__trops + var_Ca__btrop) * var_chaste_interface__Ca__Ca_submem * var_Ca__xkon; // uM_per_ms
        const double var_Environment__Ca_o = 1.8; // mM
        const double var_Environment__F = 96.485341500000004; // coulomb_per_mmole
        const double var_Environment__Na_o = 136.0; // mM
        const double var_Environment__R = 8.3144720000000003; // J_per_moleK
        const double var_Environment__T = 308.0; // kelvin
        const double var_Environment__FonRT = var_Environment__F / (var_Environment__R * var_Environment__T); // per_mV
        const double var_ICaL__pca = 0.00054000000000000001; // cm_per_s
        const double var_ICaL__po = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca; // dimensionless
        const double var_INaCa__gNaCa = 0.83999999999999997; // uM_per_ms
        const double var_INaCa__xkdna = 0.29999999999999999; // uM
        const double var_INaCa__aloss = 1 / (1.0 + pow(var_INaCa__xkdna, 3) / pow(var_chaste_interface__Ca__Ca_submem, 3)); // dimensionless
        const double var_INaCa__xmcai = 0.0035999999999999999; // mM
        const double var_INaCa__xmcao = 1.3; // mM
        const double var_INaCa__xmnai = 12.300000000000001; // mM
        const double var_INaCa__xmnao = 87.5; // mM
        const double var_INaCa__yz2 = pow(var_INaCa__xmnai, 3) * (1.0 + var_Ca__csm / var_INaCa__xmcai) * var_Environment__Ca_o; // mM4
        const double var_INaCa__yz1 = pow(var_INaCa__xmnao, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_INaCa__xmcao; // mM4
        const double var_INaCa__yz3 = pow(var_Environment__Na_o, 3) * (1.0 + pow(var_chaste_interface__Na__Na_i, 3) / pow(var_INaCa__xmnai, 3)) * var_INaCa__xmcai; // mM4
        const double var_INaCa__yz4 = pow(var_Environment__Na_o, 3) * var_Ca__csm + pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o; // mM4
        const double var_INaCa__zw8 = var_INaCa__yz1 + var_INaCa__yz2 + var_INaCa__yz3 + var_INaCa__yz4; // mM4
        const double var_ICaL__za = 2.0 * var_Environment__FonRT * var_chaste_interface__cell__V; // dimensionless
        const double var_ICaL__rxa = ((fabs(var_ICaL__za) < 0.001) ? (2.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_ICaL__pca) : (4.0 * (-0.34100000000000003 * var_Environment__Ca_o + var_Ca__csm * exp(var_ICaL__za)) * var_Environment__F * var_Environment__FonRT * var_ICaL__pca * var_chaste_interface__cell__V / (-1.0 + exp(var_ICaL__za)))); // mA_per_cm2
        const double var_ICaL__jca = mParameters[3] * var_ICaL__po * var_ICaL__rxa; // uM_per_ms
        const double var_INaCa__zw3 = pow(var_chaste_interface__Na__Na_i, 3) * var_Environment__Ca_o * exp(0.34999999999999998 * var_Environment__FonRT * var_chaste_interface__cell__V) - pow(var_Environment__Na_o, 3) * var_Ca__csm * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // mM4
        const double var_INaCa__zw4 = 1.0 + 0.20000000000000001 * exp(-0.65000000000000002 * var_Environment__FonRT * var_chaste_interface__cell__V); // dimensionless
        const double var_INaCa__jNaCa = var_INaCa__aloss * var_INaCa__gNaCa * var_INaCa__zw3 / (var_INaCa__zw4 * var_INaCa__zw8); // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_submem = (-var_Ca__xbs + 50.0 * var_INaCa__jNaCa + 50.0 * var_chaste_interface__Irel__xir - 50.0 * var_Ca__jd - 50.0 * var_ICaL__jca) * var_Ca__dcsib; // uM / ms

        return d_dt_chaste_interface_var_Ca__Ca_submem;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative22(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.169816169406
            double var_chaste_interface__Ca__Ca_i_converted = rY[1];
            // Units: millimolar; Initial value: 0.000256752008084
            double var_chaste_interface__ICaL__c1 = rY[5];
            // Units: dimensionless; Initial value: 1.8211252e-05
            double var_chaste_interface__ICaL__c2 = rY[6];
            // Units: dimensionless; Initial value: 0.979322592773
            double var_chaste_interface__ICaL__xi1ca = rY[7];
            // Units: dimensionless; Initial value: 0.001208153482
            double var_chaste_interface__ICaL__xi1ba = rY[8];
            // Units: dimensionless; Initial value: 3.3616596e-05
            double var_chaste_interface__ICaL__xi2ca = rY[9];
            // Units: dimensionless; Initial value: 0.004173008466
            double var_chaste_interface__ICaL__xi2ba = rY[10];
            // Units: dimensionless; Initial value: 0.015242594688
            double var_chaste_interface__Irel__xir = rY[19];
            // Units: uM_per_ms; Initial value: 0.006679257264
            double var_chaste_interface__Na__Na_i = rY[20];
            // Units: mM; Initial value: 11.441712311614
            double var_chaste_interface__Ca__Ca_submem = rY[22];
            // Units: uM; Initial value: 0.226941113355
            double var_chaste_interface__Ca__trops = rY[25];
            // Units: uM; Initial value: 19.864701949854
            
            const double var_x16 = 0.075353936071760372 * var_chaste_interface__cell__V;
            const double var_x17 = exp(var_x16);
            const double var_x18 = var_x17 * var_chaste_interface__Ca__Ca_submem;
            const double var_x19 = fabs(var_x16) < 0.001;
            const double var_x20 = -1.0 + var_x17;
            const double var_x21 = 1 / var_x20;
            const double var_x22 = -0.61380000000000001 + 0.001 * var_x18;
            const double var_x23 = 0.0078521942756732046 * var_x21 * var_x22;
            const double var_x24 = var_x21 * var_chaste_interface__cell__V;
            const double var_x37 = pow(var_chaste_interface__Na__Na_i, 3);
            const double var_x38 = exp(0.013186938812558063 * var_chaste_interface__cell__V);
            const double var_x39 = var_x37 * var_x38;
            const double var_x40 = exp(-0.024490029223322121 * var_chaste_interface__cell__V);
            const double var_x41 = var_x40 * var_chaste_interface__Ca__Ca_submem;
            const double var_x42 = 1 / (12405.2022 + 7.9663561662386391 * var_x37 + 4115.8113750000002 * var_chaste_interface__Ca__Ca_submem);
            const double var_x43 = 1.0 + 0.20000000000000001 * var_x40;
            const double var_x44 = 1 / var_x43;
            const double var_x45 = 1.0 + 0.026999999999999996 / pow(var_chaste_interface__Ca__Ca_submem, 3);
            const double var_x46 = 1 / var_x45;
            const double var_x47 = var_x44 * var_x46;
            const double var_x48 = var_x42 * var_x47;
            const double var_x60 = 1.8 * var_x39 - 2515.4560000000001 * var_x41;
            const double var_x61 = var_x42 * var_x60;
            const double var_x74 = 0.00010420416882000001 * var_x17;
            const double var_x75 = ((var_x19) ? (-0.063960518821716009 + var_x74 * var_chaste_interface__Ca__Ca_submem) : (var_x23 * var_chaste_interface__cell__V));
            const double var_x76 = var_x75 * mParameters[3];
            const double var_x83 = var_x47 * var_x60 / pow((1 + 0.0006421786632577935 * var_x37 + 0.33178107931203249 * var_chaste_interface__Ca__Ca_submem), 2);
            const double var_x87 = ((var_x19) ? (var_x74) : (7.8521942756732062e-6 * var_x17 * var_x24));
            const double var_x88 = var_x40 * var_x48;
            const double var_x89 = var_x44 * var_x61 / (pow(var_x45, 2) * pow(var_chaste_interface__Ca__Ca_submem, 4));
            const double var_x223 = 1.0 - var_chaste_interface__ICaL__c1 - var_chaste_interface__ICaL__c2 - var_chaste_interface__ICaL__xi1ba - var_chaste_interface__ICaL__xi1ca - var_chaste_interface__ICaL__xi2ba - var_chaste_interface__ICaL__xi2ca;
            const double var_x315 = (-50.0 + 50.0 * var_chaste_interface__ICaL__c1 + 50.0 * var_chaste_interface__ICaL__c2 + 50.0 * var_chaste_interface__ICaL__xi1ba + 50.0 * var_chaste_interface__ICaL__xi1ca + 50.0 * var_chaste_interface__ICaL__xi2ba + 50.0 * var_chaste_interface__ICaL__xi2ca) * mParameters[3];
            const double var_x316 = 0.29999999999999999 + var_chaste_interface__Ca__Ca_submem;
            const double var_x317 = pow(var_x316, (-2));
            const double var_x318 = 1 + 0.076923076923076927 * var_chaste_interface__Ca__Ca_submem;
            const double var_x319 = pow(var_x318, (-2));
            const double var_x320 = 0.59999999999999998 + var_chaste_interface__Ca__Ca_submem;
            const double var_x321 = pow(var_x320, (-2));
            const double var_x322 = 1 + 0.14285714285714285 * var_chaste_interface__Ca__Ca_submem;
            const double var_x323 = pow(var_x322, (-2));
            const double var_x324 = 1 / (1.0 + 4.5 * var_x317 + 3.2307692307692308 * var_x319 + 28.199999999999999 * var_x321 + 3.4285714285714284 * var_x323);
            const double var_x325 = var_x324;
            const double var_x328 = 0.0327 * var_chaste_interface__Ca__trops;
            const double var_x329 = 0.0327 * var_chaste_interface__Ca__Ca_submem;
            
            partialF = var_x325 * (-14.789 + var_x328 + 3.4019999999999997 * var_x89 - 0.0011233033614805057 * var_x83 - 105649.152 * var_x88 + var_x315 * var_x87) + 0.0012574820180071425 * (9.0 / pow(var_x316, 3) + 56.399999999999999 / pow(var_x320, 3) + 0.97959183673469385 / pow(var_x322, 3) + 0.49704142011834318 / pow(var_x318, 3)) * (50.0 * var_chaste_interface__Irel__xir + 0.019599999999999999 * var_chaste_interface__Ca__trops + 12500.0 * var_chaste_interface__Ca__Ca_i_converted - 12.5 * var_chaste_interface__Ca__Ca_submem - var_x329 * (70.0 - var_chaste_interface__Ca__trops) + 42.0 * var_x48 * var_x60 - 50.0 * var_x223 * var_x76) / pow((0.035460992907801421 + var_x321 + 0.15957446808510639 * var_x317 + 0.12158054711246201 * var_x323 + 0.11456628477905074 * var_x319), 2);
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative23(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca__Ca_i_converted = rY[1];
        // Units: millimolar; Initial value: 0.000256752008084
        double var_chaste_interface__Irel__xir = rY[19];
        // Units: uM_per_ms; Initial value: 0.006679257264
        double var_chaste_interface__Ca__Ca_NSR = rY[23];
        // Units: uM; Initial value: 104.450004990523
        
        
        // Mathematics
        const double var_Ca__Ca_i = 1000.0 * var_chaste_interface__Ca__Ca_i_converted; // uM
        const double var_Ileak_Iup_Ixfer__cup = 0.5; // uM
        const double var_Ileak_Iup_Ixfer__gleak = 2.069e-5; // per_ms
        const double var_Ileak_Iup_Ixfer__kj = 50.0; // uM
        const double var_Ileak_Iup_Ixfer__jleak = pow(var_chaste_interface__Ca__Ca_NSR, 2) * (-var_Ca__Ca_i + 16.667000000000002 * var_chaste_interface__Ca__Ca_NSR) * var_Ileak_Iup_Ixfer__gleak / (pow(var_chaste_interface__Ca__Ca_NSR, 2) + pow(var_Ileak_Iup_Ixfer__kj, 2)); // uM_per_ms
        const double var_Ileak_Iup_Ixfer__vup = 0.40000000000000002; // uM_per_ms
        const double var_Ileak_Iup_Ixfer__jup = pow(var_Ca__Ca_i, 2) * var_Ileak_Iup_Ixfer__vup / (pow(var_Ca__Ca_i, 2) + pow(var_Ileak_Iup_Ixfer__cup, 2)); // uM_per_ms
        const double var_Ca__dCa_JSR = -var_Ileak_Iup_Ixfer__jleak - var_chaste_interface__Irel__xir + var_Ileak_Iup_Ixfer__jup; // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_NSR = var_Ca__dCa_JSR; // uM / ms

        return d_dt_chaste_interface_var_Ca__Ca_NSR;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative23(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca__Ca_i_converted = rY[1];
            // Units: millimolar; Initial value: 0.000256752008084
            double var_chaste_interface__Ca__Ca_NSR = rY[23];
            // Units: uM; Initial value: 104.450004990523
            
            const double var_x93 = pow(var_chaste_interface__Ca__Ca_NSR, 2);
            const double var_x94 = 1 / (2500.0 + var_x93);
            const double var_x95 = var_x93 * var_x94;
            const double var_x108 = 16.667000000000002 * var_chaste_interface__Ca__Ca_NSR - 1000.0 * var_chaste_interface__Ca__Ca_i_converted;
            const double var_x110 = 0.00034484023000000001 * var_x95;
            const double var_x111 = 4.138e-5 * var_x108 * var_x94 * var_chaste_interface__Ca__Ca_NSR;
            const double var_x112 = 6.6208000000000002e-12 * var_x108 * pow(var_chaste_interface__Ca__Ca_NSR, 3) / pow((1 + 0.00040000000000000002 * var_x93), 2);
            const double var_x304 = var_x112 - var_x110 - var_x111;
            
            partialF = var_x304;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative24(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca__Ca_i_converted = rY[1];
        // Units: millimolar; Initial value: 0.000256752008084
        double var_chaste_interface__Ca__tropi = rY[24];
        // Units: uM; Initial value: 22.171689894953
        
        
        // Mathematics
        const double var_Ca__Ca_i = 1000.0 * var_chaste_interface__Ca__Ca_i_converted; // uM
        const double var_Ca__btrop = 70.0; // uM
        const double var_Ca__xkoff = 0.019599999999999999; // per_ms
        const double var_Ca__xkon = 0.0327; // per_uM_per_ms
        const double var_Ca__xbi = -var_chaste_interface__Ca__tropi * var_Ca__xkoff + (-var_chaste_interface__Ca__tropi + var_Ca__btrop) * var_Ca__Ca_i * var_Ca__xkon; // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__tropi = var_Ca__xbi; // uM / ms

        return d_dt_chaste_interface_var_Ca__tropi;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative24(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca__Ca_i_converted = rY[1];
            // Units: millimolar; Initial value: 0.000256752008084
            
            const double var_x106 = 32.699999999999996 * var_chaste_interface__Ca__Ca_i_converted;
            
            partialF = -0.019599999999999999 - var_x106;
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Cellmahajan_2008FromCellMLGRL2::EvaluateYDerivative25(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca__Ca_submem = rY[22];
        // Units: uM; Initial value: 0.226941113355
        double var_chaste_interface__Ca__trops = rY[25];
        // Units: uM; Initial value: 19.864701949854
        
        
        // Mathematics
        const double var_Ca__btrop = 70.0; // uM
        const double var_Ca__xkoff = 0.019599999999999999; // per_ms
        const double var_Ca__xkon = 0.0327; // per_uM_per_ms
        const double var_Ca__xbs = -var_chaste_interface__Ca__trops * var_Ca__xkoff + (-var_chaste_interface__Ca__trops + var_Ca__btrop) * var_chaste_interface__Ca__Ca_submem * var_Ca__xkon; // uM_per_ms
        const double d_dt_chaste_interface_var_Ca__trops = var_Ca__xbs; // uM / ms

        return d_dt_chaste_interface_var_Ca__trops;
    }

    double Cellmahajan_2008FromCellMLGRL2::EvaluatePartialDerivative25(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca__Ca_submem = rY[22];
            // Units: uM; Initial value: 0.226941113355
            
            const double var_x329 = 0.0327 * var_chaste_interface__Ca__Ca_submem;
            
            partialF = -0.019599999999999999 - var_x329;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }

    std::vector<double> Cellmahajan_2008FromCellMLGRL2::ComputeDerivedQuantities(double var_chaste_interface__Environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__Ca__Ca_i_converted = rY[1];
        // Units: millimolar; Initial value: 0.000256752008084
        

        // Mathematics
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2

        std::vector<double> dqs(3);
        dqs[0] = var_chaste_interface__Environment__time;
        dqs[1] = var_chaste_interface__Ca__Ca_i_converted;
        dqs[2] = var_cell__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellmahajan_2008FromCellMLGRL2>::Initialise(void)
{
    this->mSystemName = "mahajan_shiferaw_model_2008";
    this->mFreeVariableName = "Environment__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-87.169816169406);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.000256752008084);

    // rY[2]:
    this->mVariableNames.push_back("INa__xm");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001075453357);

    // rY[3]:
    this->mVariableNames.push_back("INa__xh");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.990691306716);

    // rY[4]:
    this->mVariableNames.push_back("INa__xj");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.993888937283);

    // rY[5]:
    this->mVariableNames.push_back("ICaL__c1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.8211252e-05);

    // rY[6]:
    this->mVariableNames.push_back("ICaL__c2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.979322592773);

    // rY[7]:
    this->mVariableNames.push_back("ICaL__xi1ca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001208153482);

    // rY[8]:
    this->mVariableNames.push_back("ICaL__xi1ba");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.3616596e-05);

    // rY[9]:
    this->mVariableNames.push_back("ICaL__xi2ca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004173008466);

    // rY[10]:
    this->mVariableNames.push_back("ICaL__xi2ba");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.015242594688);

    // rY[11]:
    this->mVariableNames.push_back("IKr__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.007074239331);

    // rY[12]:
    this->mVariableNames.push_back("IKs__xs1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.048267587131);

    // rY[13]:
    this->mVariableNames.push_back("IKs__xs2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.105468807033);

    // rY[14]:
    this->mVariableNames.push_back("Ito__xtos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00364776906);

    // rY[15]:
    this->mVariableNames.push_back("Ito__ytos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.174403618112);

    // rY[16]:
    this->mVariableNames.push_back("Ito__xtof");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.003643592594);

    // rY[17]:
    this->mVariableNames.push_back("Ito__ytof");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.993331326442);

    // rY[18]:
    this->mVariableNames.push_back("Irel__Ca_JSR");
    this->mVariableUnits.push_back("uM");
    this->mInitialConditions.push_back(97.505463697266);

    // rY[19]:
    this->mVariableNames.push_back("Irel__xir");
    this->mVariableUnits.push_back("uM_per_ms");
    this->mInitialConditions.push_back(0.006679257264);

    // rY[20]:
    this->mVariableNames.push_back("Na__Na_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(11.441712311614);

    // rY[21]:
    this->mVariableNames.push_back("Ca__Ca_dyad");
    this->mVariableUnits.push_back("uM");
    this->mInitialConditions.push_back(1.716573130685);

    // rY[22]:
    this->mVariableNames.push_back("Ca__Ca_submem");
    this->mVariableUnits.push_back("uM");
    this->mInitialConditions.push_back(0.226941113355);

    // rY[23]:
    this->mVariableNames.push_back("Ca__Ca_NSR");
    this->mVariableUnits.push_back("uM");
    this->mInitialConditions.push_back(104.450004990523);

    // rY[24]:
    this->mVariableNames.push_back("Ca__tropi");
    this->mVariableUnits.push_back("uM");
    this->mInitialConditions.push_back(22.171689894953);

    // rY[25]:
    this->mVariableNames.push_back("Ca__trops");
    this->mVariableUnits.push_back("uM");
    this->mInitialConditions.push_back(19.864701949854);

    // mParameters[0]:
    this->mParameterNames.push_back("ScaleFactorGkr");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[1]:
    this->mParameterNames.push_back("ScaleFactorGks");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[2]:
    this->mParameterNames.push_back("ScaleFactorIto");
    this->mParameterUnits.push_back("dimensionless");

    // mParameters[3]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("mmole_per_coulomb_cm");

    // mParameters[4]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("uS_per_nF");

    // mParameters[5]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("uS_per_nF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("Environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("cytosolic_calcium_concentration");
    this->mDerivedQuantityUnits.push_back("millimolar");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellmahajan_2008FromCellMLGRL2)

