//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: jafri_rice_winslow_1998
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "jafri_rice_winslow_model_1998.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Celljafri_rice_winslow_model_1998FromCellMLGRL2::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = 51.628900000000009; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 1.0; // ms
        const double var_chaste_interface__membrane__stim_period = 500.0; // ms
        const double var_chaste_interface__membrane__stim_start = 100.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Celljafri_rice_winslow_model_1998FromCellMLGRL2::Celljafri_rice_winslow_model_1998FromCellMLGRL2(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                31,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celljafri_rice_winslow_model_1998FromCellMLGRL2>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
    }

    Celljafri_rice_winslow_model_1998FromCellMLGRL2::~Celljafri_rice_winslow_model_1998FromCellMLGRL2()
    {
    }
    
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__L_type_Ca_channel__O = rY[4];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
        // Units: dimensionless; Initial value: 0.000928836
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__ionic_concentrations__Nai = rY[28];
        // Units: mM; Initial value: 10.2042
        double var_chaste_interface__ionic_concentrations__Ki = rY[29];
        // Units: mM; Initial value: 143.727
        double var_chaste_interface__ionic_concentrations__Ko = rY[30];
        // Units: mM; Initial value: 5.4
        
        const double var_L_type_Ca_channel__P_Ca = 3.375e-5; // mm_per_ms
        const double var_L_type_Ca_channel__P_K = 1.0000000000000001e-9; // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_Ca_half = -0.0045799999999999999; // uA_per_mm2
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // mM
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // mM
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_Na_Ca_exchanger__k_NaCa = 50.0; // uA_per_mm2
        const double var_Na_Ca_exchanger__k_sat = 0.10000000000000001; // dimensionless
        const double var_calcium_background_current__g_Cab = 6.0319999999999998e-5; // mS_per_mm2
        const double var_fast_sodium_current__g_Na = 0.128; // mS_per_mm2
        const double var_ionic_concentrations__Cao = 1.8; // mM
        const double var_ionic_concentrations__Nao = 140.0; // mM
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Cao / var_chaste_interface__calcium_subsystem__Cai) / var_membrane__F; // mV
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // mV
        const double var_L_type_Ca_channel__i_Ca_L_Ca_max = 4.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_ionic_concentrations__Cao) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__i_Ca_L_Ca = (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__i_Ca_L_Ca_max * var_chaste_interface__L_type_Ca_channel_y_gate__y; // uA_per_mm2
        const double var_L_type_Ca_channel__p_k = var_L_type_Ca_channel__P_K / (1.0 + var_L_type_Ca_channel__i_Ca_L_Ca_max / var_L_type_Ca_channel__i_Ca_L_Ca_half); // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_K = pow(var_membrane__F, 2) * (-var_chaste_interface__ionic_concentrations__Ko + var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__p_k * var_chaste_interface__L_type_Ca_channel_y_gate__y * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, 3) * var_ionic_concentrations__Cao * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, 3) * var_chaste_interface__calcium_subsystem__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__k_NaCa / ((1.0 + var_Na_Ca_exchanger__k_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(var_ionic_concentrations__Nao, 3)) * (var_Na_Ca_exchanger__K_mCa + var_ionic_concentrations__Cao)); // uA_per_mm2
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // uA_per_mm2
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // uA_per_mm2
        const double var_non_specific_calcium_activated_current__EnsCa = var_membrane__R * var_membrane__T * log((var_chaste_interface__ionic_concentrations__Ko + var_ionic_concentrations__Nao) / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai)) / var_membrane__F; // mV
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // mM
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 1.75e-9; // mm_per_ms
        const double var_non_specific_calcium_activated_current__VnsCa = -var_non_specific_calcium_activated_current__EnsCa + var_chaste_interface__membrane__V; // mV
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-0.75 * var_chaste_interface__ionic_concentrations__Ko + 0.75 * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-0.75 * var_ionic_concentrations__Nao + 0.75 * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // uA_per_mm2
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 8.2799999999999993e-5; // mS_per_mm2
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.0115; // uA_per_mm2
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // mM
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_subsystem__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_subsystem__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // uA_per_mm2
        const double var_sodium_background_current__E_NaN = var_fast_sodium_current__E_Na; // mV
        const double var_sodium_background_current__g_Nab = 1.4100000000000001e-5; // mS_per_mm2
        const double var_sodium_background_current__i_Na_b = (-var_sodium_background_current__E_NaN + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // uA_per_mm2
        const double var_sodium_potassium_pump__I_NaK = 0.012999999999999999; // uA_per_mm2
        const double var_sodium_potassium_pump__K_mKo = 1.5; // mM
        const double var_sodium_potassium_pump__K_mNai = 10.0; // mM
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__ionic_concentrations__Nai), 1.5)) * (var_chaste_interface__ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // uA_per_mm2
        const double var_time_dependent_potassium_current__P_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // mV
        const double var_time_dependent_potassium_current__g_K_max = 0.0011280000000000001; // mS_per_mm2
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_dependent_potassium_current__g_K_max; // mS_per_mm2
        const double var_time_dependent_potassium_current_Xi_gate__Xi = 1 / (1.0 + exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2) * (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_time_dependent_potassium_current_Xi_gate__Xi; // uA_per_mm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(var_chaste_interface__ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // mV
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // mV
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // uA_per_mm2
        const double var_time_independent_potassium_current__g_K1_max = 0.0074999999999999997; // mS_per_mm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_independent_potassium_current__g_K1_max; // mS_per_mm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // uA_per_mm2
        const double var_chaste_interface__i_ionic = 100.00000000000001 * var_L_type_Ca_channel__i_Ca_L_Ca + 100.00000000000001 * var_L_type_Ca_channel__i_Ca_L_K + 100.00000000000001 * var_Na_Ca_exchanger__i_NaCa + 100.00000000000001 * var_calcium_background_current__i_Ca_b + 100.00000000000001 * var_fast_sodium_current__i_Na + 100.00000000000001 * var_non_specific_calcium_activated_current__i_ns_Ca + 100.00000000000001 * var_plateau_potassium_current__i_Kp + 100.00000000000001 * var_sarcolemmal_calcium_pump__i_p_Ca + 100.00000000000001 * var_sodium_background_current__i_Na_b + 100.00000000000001 * var_sodium_potassium_pump__i_NaK + 100.00000000000001 * var_time_dependent_potassium_current__i_K + 100.00000000000001 * var_time_independent_potassium_current__i_K1; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celljafri_rice_winslow_model_1998FromCellMLGRL2::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__L_type_Ca_channel__O = rY[4];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
        // Units: dimensionless; Initial value: 0.000928836
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__ionic_concentrations__Nai = rY[28];
        // Units: mM; Initial value: 10.2042
        double var_chaste_interface__ionic_concentrations__Ki = rY[29];
        // Units: mM; Initial value: 143.727
        double var_chaste_interface__ionic_concentrations__Ko = rY[30];
        // Units: mM; Initial value: 5.4
        

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_L_type_Ca_channel__P_Ca = 3.375e-5; // mm_per_ms
        const double var_L_type_Ca_channel__P_K = 1.0000000000000001e-9; // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_Ca_half = -0.0045799999999999999; // uA_per_mm2
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // mM
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // mM
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_Na_Ca_exchanger__k_NaCa = 50.0; // uA_per_mm2
        const double var_Na_Ca_exchanger__k_sat = 0.10000000000000001; // dimensionless
        const double var_calcium_background_current__g_Cab = 6.0319999999999998e-5; // mS_per_mm2
        const double var_fast_sodium_current__g_Na = 0.128; // mS_per_mm2
        const double var_ionic_concentrations__Cao = 1.8; // mM
        const double var_ionic_concentrations__Nao = 140.0; // mM
        const double var_membrane__Cm = 0.01; // uF_per_mm2
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__I_stim_converted = -GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__I_stim = 0.0099999999999999985 * var_membrane__I_stim_converted; // uA_per_mm2
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Cao / var_chaste_interface__calcium_subsystem__Cai) / var_membrane__F; // mV
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // mV
        const double var_L_type_Ca_channel__i_Ca_L_Ca_max = 4.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_ionic_concentrations__Cao) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__i_Ca_L_Ca = (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__i_Ca_L_Ca_max * var_chaste_interface__L_type_Ca_channel_y_gate__y; // uA_per_mm2
        const double var_L_type_Ca_channel__p_k = var_L_type_Ca_channel__P_K / (1.0 + var_L_type_Ca_channel__i_Ca_L_Ca_max / var_L_type_Ca_channel__i_Ca_L_Ca_half); // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_K = pow(var_membrane__F, 2) * (-var_chaste_interface__ionic_concentrations__Ko + var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__p_k * var_chaste_interface__L_type_Ca_channel_y_gate__y * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, 3) * var_ionic_concentrations__Cao * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, 3) * var_chaste_interface__calcium_subsystem__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__k_NaCa / ((1.0 + var_Na_Ca_exchanger__k_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(var_ionic_concentrations__Nao, 3)) * (var_Na_Ca_exchanger__K_mCa + var_ionic_concentrations__Cao)); // uA_per_mm2
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // uA_per_mm2
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // uA_per_mm2
        const double var_non_specific_calcium_activated_current__EnsCa = var_membrane__R * var_membrane__T * log((var_chaste_interface__ionic_concentrations__Ko + var_ionic_concentrations__Nao) / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai)) / var_membrane__F; // mV
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // mM
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 1.75e-9; // mm_per_ms
        const double var_non_specific_calcium_activated_current__VnsCa = -var_non_specific_calcium_activated_current__EnsCa + var_chaste_interface__membrane__V; // mV
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-0.75 * var_chaste_interface__ionic_concentrations__Ko + 0.75 * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-0.75 * var_ionic_concentrations__Nao + 0.75 * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // uA_per_mm2
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 8.2799999999999993e-5; // mS_per_mm2
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.0115; // uA_per_mm2
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // mM
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_subsystem__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_subsystem__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // uA_per_mm2
        const double var_sodium_background_current__E_NaN = var_fast_sodium_current__E_Na; // mV
        const double var_sodium_background_current__g_Nab = 1.4100000000000001e-5; // mS_per_mm2
        const double var_sodium_background_current__i_Na_b = (-var_sodium_background_current__E_NaN + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // uA_per_mm2
        const double var_sodium_potassium_pump__I_NaK = 0.012999999999999999; // uA_per_mm2
        const double var_sodium_potassium_pump__K_mKo = 1.5; // mM
        const double var_sodium_potassium_pump__K_mNai = 10.0; // mM
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__ionic_concentrations__Nai), 1.5)) * (var_chaste_interface__ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // uA_per_mm2
        const double var_time_dependent_potassium_current__P_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // mV
        const double var_time_dependent_potassium_current__g_K_max = 0.0011280000000000001; // mS_per_mm2
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_dependent_potassium_current__g_K_max; // mS_per_mm2
        const double var_time_dependent_potassium_current_Xi_gate__Xi = 1 / (1.0 + exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2) * (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_time_dependent_potassium_current_Xi_gate__Xi; // uA_per_mm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(var_chaste_interface__ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // mV
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // mV
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // uA_per_mm2
        const double var_time_independent_potassium_current__g_K1_max = 0.0074999999999999997; // mS_per_mm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_independent_potassium_current__g_K1_max; // mS_per_mm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // uA_per_mm2
        d_dt_chaste_interface_var_membrane__V = (-var_L_type_Ca_channel__i_Ca_L_Ca - var_L_type_Ca_channel__i_Ca_L_K - var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_non_specific_calcium_activated_current__i_ns_Ca - var_plateau_potassium_current__i_Kp - var_sarcolemmal_calcium_pump__i_p_Ca - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_NaK - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1 + var_membrane__I_stim) / var_membrane__Cm; // mV / ms

        double evalF = d_dt_chaste_interface_var_membrane__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Celljafri_rice_winslow_model_1998FromCellMLGRL2::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__L_type_Ca_channel__O = rY[4];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel__C0 = rY[6];
        // Units: dimensionless; Initial value: 0.997208
        double var_chaste_interface__L_type_Ca_channel__C1 = rY[7];
        // Units: dimensionless; Initial value: 6.38897e-05
        double var_chaste_interface__L_type_Ca_channel__C2 = rY[8];
        // Units: dimensionless; Initial value: 1.535e-09
        double var_chaste_interface__L_type_Ca_channel__C3 = rY[9];
        // Units: dimensionless; Initial value: 1.63909e-14
        double var_chaste_interface__L_type_Ca_channel__C4 = rY[10];
        // Units: dimensionless; Initial value: 6.56337e-20
        double var_chaste_interface__L_type_Ca_channel__C_Ca0 = rY[11];
        // Units: dimensionless; Initial value: 0.00272826
        double var_chaste_interface__L_type_Ca_channel__C_Ca1 = rY[12];
        // Units: dimensionless; Initial value: 6.99215e-07
        double var_chaste_interface__L_type_Ca_channel__C_Ca2 = rY[13];
        // Units: dimensionless; Initial value: 6.71989e-11
        double var_chaste_interface__L_type_Ca_channel__C_Ca3 = rY[14];
        // Units: dimensionless; Initial value: 2.87031e-15
        double var_chaste_interface__L_type_Ca_channel__C_Ca4 = rY[15];
        // Units: dimensionless; Initial value: 4.59752e-20
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
        // Units: dimensionless; Initial value: 0.000928836
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        double var_chaste_interface__calcium_subsystem__P_O1 = rY[20];
        // Units: dimensionless; Initial value: 0.00119168
        double var_chaste_interface__calcium_subsystem__P_O2 = rY[21];
        // Units: dimensionless; Initial value: 6.30613e-09
        double var_chaste_interface__calcium_subsystem__P_C1 = rY[22];
        // Units: dimensionless; Initial value: 0.762527
        double var_chaste_interface__calcium_subsystem__P_C2 = rY[23];
        // Units: dimensionless; Initial value: 0.236283
        double var_chaste_interface__calcium_subsystem__Ca_JSR = rY[24];
        // Units: mM; Initial value: 1.17504
        double var_chaste_interface__calcium_subsystem__Ca_NSR = rY[25];
        // Units: mM; Initial value: 1.243891
        double var_chaste_interface__calcium_subsystem__HTRPNCa = rY[26];
        // Units: mM; Initial value: 0.13598
        double var_chaste_interface__calcium_subsystem__LTRPNCa = rY[27];
        // Units: mM; Initial value: 0.00635
        double var_chaste_interface__ionic_concentrations__Nai = rY[28];
        // Units: mM; Initial value: 10.2042
        double var_chaste_interface__ionic_concentrations__Ki = rY[29];
        // Units: mM; Initial value: 143.727
        double var_chaste_interface__ionic_concentrations__Ko = rY[30];
        // Units: mM; Initial value: 5.4
        
        
        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_L_type_Ca_channel__P_Ca = 3.375e-5; // mm_per_ms
        const double var_L_type_Ca_channel__P_K = 1.0000000000000001e-9; // mm_per_ms
        const double var_L_type_Ca_channel__a = 2.0; // dimensionless
        const double var_L_type_Ca_channel__b = 2.0; // dimensionless
        const double var_L_type_Ca_channel__f = 0.29999999999999999; // per_ms
        const double var_L_type_Ca_channel__f_ = 0; // per_ms
        const double var_L_type_Ca_channel__g = 2.0; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__O = var_chaste_interface__L_type_Ca_channel__C4 * var_L_type_Ca_channel__f - var_chaste_interface__L_type_Ca_channel__O * var_L_type_Ca_channel__g; // 1 / ms
        const double var_L_type_Ca_channel__g_ = 0; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__O_Ca = var_chaste_interface__L_type_Ca_channel__C_Ca4 * var_L_type_Ca_channel__f_ - var_chaste_interface__L_type_Ca_channel__O_Ca * var_L_type_Ca_channel__g_; // 1 / ms
        const double var_L_type_Ca_channel__i_Ca_L_Ca_half = -0.0045799999999999999; // uA_per_mm2
        const double var_L_type_Ca_channel__omega = 0.01; // per_ms
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // mM
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // mM
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_Na_Ca_exchanger__k_NaCa = 50.0; // uA_per_mm2
        const double var_Na_Ca_exchanger__k_sat = 0.10000000000000001; // dimensionless
        const double var_calcium_background_current__g_Cab = 6.0319999999999998e-5; // mS_per_mm2
        const double var_calcium_subsystem__Am = 546.69000000000005; // per_mm
        const double var_calcium_subsystem__CMDN_tot = 0.050000000000000003; // mM
        const double var_calcium_subsystem__CSQN_tot = 15.0; // mM
        const double var_L_type_Ca_channel__gamma = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS; // per_ms
        const double var_calcium_subsystem__HTRPN_tot = 0.14000000000000001; // mM
        const double var_calcium_subsystem__K_mCMDN = 0.0023800000000000002; // mM
        const double var_calcium_subsystem__B_SS = 1 / (1.0 + var_calcium_subsystem__CMDN_tot * var_calcium_subsystem__K_mCMDN / pow((var_chaste_interface__calcium_subsystem__Ca_SS + var_calcium_subsystem__K_mCMDN), 2)); // dimensionless
        const double var_calcium_subsystem__Bi = 1 / (1.0 + var_calcium_subsystem__CMDN_tot * var_calcium_subsystem__K_mCMDN / pow((var_chaste_interface__calcium_subsystem__Cai + var_calcium_subsystem__K_mCMDN), 2)); // dimensionless
        const double var_calcium_subsystem__K_mCSQN = 0.80000000000000004; // mM
        const double var_calcium_subsystem__B_JSR = 1 / (1.0 + var_calcium_subsystem__CSQN_tot * var_calcium_subsystem__K_mCSQN / pow((var_chaste_interface__calcium_subsystem__Ca_JSR + var_calcium_subsystem__K_mCSQN), 2)); // dimensionless
        const double var_calcium_subsystem__K_mup = 0.00050000000000000001; // mM
        const double var_calcium_subsystem__LTRPN_tot = 0.070000000000000007; // mM
        const double var_calcium_subsystem__RyR_open = var_chaste_interface__calcium_subsystem__P_O1 + var_chaste_interface__calcium_subsystem__P_O2; // dimensionless
        const double var_calcium_subsystem__V_myo = 0.92000000000000004; // dimensionless
        const double var_calcium_subsystem__V_JSR = 0.00464 * var_calcium_subsystem__V_myo; // dimensionless
        const double var_calcium_subsystem__V_NSR = 0.081000000000000003 * var_calcium_subsystem__V_myo; // dimensionless
        const double var_calcium_subsystem__V_SS = 5.8279999999999998e-5 * var_calcium_subsystem__V_myo; // dimensionless
        const double var_calcium_subsystem__k_a_minus = 0.14249999999999999; // per_ms
        const double var_calcium_subsystem__k_a_plus = 12150000000.0; // per_mM4_per_ms
        const double var_calcium_subsystem__k_b_minus = 1.9299999999999999; // per_ms
        const double var_calcium_subsystem__k_b_plus = 40500000.0; // per_mM3_per_ms
        const double var_calcium_subsystem__k_c_minus = 0.00080000000000000004; // per_ms
        const double var_calcium_subsystem__k_c_plus = 0.017999999999999999; // per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__P_C2 = var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_c_plus - var_chaste_interface__calcium_subsystem__P_C2 * var_calcium_subsystem__k_c_minus; // 1 / ms
        const double var_calcium_subsystem__k_htrpn_minus = 6.6000000000000005e-5; // per_ms
        const double var_calcium_subsystem__k_htrpn_plus = 20.0; // per_mM_per_ms
        const double var_calcium_subsystem__J_htrpn = -var_chaste_interface__calcium_subsystem__HTRPNCa * var_calcium_subsystem__k_htrpn_minus + (-var_chaste_interface__calcium_subsystem__HTRPNCa + var_calcium_subsystem__HTRPN_tot) * var_chaste_interface__calcium_subsystem__Cai * var_calcium_subsystem__k_htrpn_plus; // mM_per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__HTRPNCa = var_calcium_subsystem__J_htrpn; // mM / ms
        const double var_calcium_subsystem__k_ltrpn_minus = 0.040000000000000001; // per_ms
        const double var_calcium_subsystem__k_ltrpn_plus = 40.0; // per_mM_per_ms
        const double var_calcium_subsystem__J_ltrpn = -var_chaste_interface__calcium_subsystem__LTRPNCa * var_calcium_subsystem__k_ltrpn_minus + (-var_chaste_interface__calcium_subsystem__LTRPNCa + var_calcium_subsystem__LTRPN_tot) * var_chaste_interface__calcium_subsystem__Cai * var_calcium_subsystem__k_ltrpn_plus; // mM_per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__LTRPNCa = var_calcium_subsystem__J_ltrpn; // mM / ms
        const double var_calcium_subsystem__J_trpn = var_calcium_subsystem__J_htrpn + var_calcium_subsystem__J_ltrpn; // mM_per_ms
        const double var_calcium_subsystem__mCa = 3.0; // dimensionless
        const double d_dt_chaste_interface_var_calcium_subsystem__P_O2 = -var_chaste_interface__calcium_subsystem__P_O2 * var_calcium_subsystem__k_b_minus + pow(var_chaste_interface__calcium_subsystem__Ca_SS, var_calcium_subsystem__mCa) * var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_b_plus; // 1 / ms
        const double var_calcium_subsystem__nCa = 4.0; // dimensionless
        const double d_dt_chaste_interface_var_calcium_subsystem__P_C1 = var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_a_minus - pow(var_chaste_interface__calcium_subsystem__Ca_SS, var_calcium_subsystem__nCa) * var_chaste_interface__calcium_subsystem__P_C1 * var_calcium_subsystem__k_a_plus; // 1 / ms
        const double d_dt_chaste_interface_var_calcium_subsystem__P_O1 = var_chaste_interface__calcium_subsystem__P_C2 * var_calcium_subsystem__k_c_minus + var_chaste_interface__calcium_subsystem__P_O2 * var_calcium_subsystem__k_b_minus - var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_a_minus - var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_c_plus + pow(var_chaste_interface__calcium_subsystem__Ca_SS, var_calcium_subsystem__nCa) * var_chaste_interface__calcium_subsystem__P_C1 * var_calcium_subsystem__k_a_plus - pow(var_chaste_interface__calcium_subsystem__Ca_SS, var_calcium_subsystem__mCa) * var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_b_plus; // 1 / ms
        const double var_calcium_subsystem__tau_tr = 34.479999999999997; // ms
        const double var_calcium_subsystem__J_tr = (-var_chaste_interface__calcium_subsystem__Ca_JSR + var_chaste_interface__calcium_subsystem__Ca_NSR) / var_calcium_subsystem__tau_tr; // mM_per_ms
        const double var_calcium_subsystem__tau_xfer = 3.125; // ms
        const double var_calcium_subsystem__J_xfer = (-var_chaste_interface__calcium_subsystem__Cai + var_chaste_interface__calcium_subsystem__Ca_SS) / var_calcium_subsystem__tau_xfer; // mM_per_ms
        const double var_calcium_subsystem__v1 = 1.8; // per_ms
        const double var_calcium_subsystem__J_rel = (-var_chaste_interface__calcium_subsystem__Ca_SS + var_chaste_interface__calcium_subsystem__Ca_JSR) * var_calcium_subsystem__RyR_open * var_calcium_subsystem__v1; // mM_per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__Ca_JSR = (-var_calcium_subsystem__J_rel + var_calcium_subsystem__J_tr) * var_calcium_subsystem__B_JSR; // mM / ms
        const double var_calcium_subsystem__v2 = 5.8e-5; // per_ms
        const double var_calcium_subsystem__J_leak = (-var_chaste_interface__calcium_subsystem__Cai + var_chaste_interface__calcium_subsystem__Ca_NSR) * var_calcium_subsystem__v2; // mM_per_ms
        const double var_calcium_subsystem__v3 = 0.0018; // mM_per_ms
        const double var_calcium_subsystem__J_up = pow(var_chaste_interface__calcium_subsystem__Cai, 2) * var_calcium_subsystem__v3 / (pow(var_chaste_interface__calcium_subsystem__Cai, 2) + pow(var_calcium_subsystem__K_mup, 2)); // mM_per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__Ca_NSR = (-var_calcium_subsystem__J_leak + var_calcium_subsystem__J_up) * var_calcium_subsystem__V_myo / var_calcium_subsystem__V_NSR - var_calcium_subsystem__J_tr * var_calcium_subsystem__V_JSR / var_calcium_subsystem__V_NSR; // mM / ms
        const double var_fast_sodium_current__g_Na = 0.128; // mS_per_mm2
        const double var_ionic_concentrations__Cao = 1.8; // mM
        const double var_ionic_concentrations__Nao = 140.0; // mM
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Cao / var_chaste_interface__calcium_subsystem__Cai) / var_membrane__F; // mV
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // mV
        const double var_L_type_Ca_channel__alpha = 0.40000000000000002 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__alpha_a = var_L_type_Ca_channel__a * var_L_type_Ca_channel__alpha; // per_ms
        const double var_L_type_Ca_channel__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C0 = var_chaste_interface__L_type_Ca_channel__C1 * var_L_type_Ca_channel__beta + var_chaste_interface__L_type_Ca_channel__C_Ca0 * var_L_type_Ca_channel__omega - (4.0 * var_L_type_Ca_channel__alpha + var_L_type_Ca_channel__gamma) * var_chaste_interface__L_type_Ca_channel__C0; // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C1 = -(3.0 * var_L_type_Ca_channel__alpha + var_L_type_Ca_channel__a * var_L_type_Ca_channel__gamma + var_L_type_Ca_channel__beta) * var_chaste_interface__L_type_Ca_channel__C1 + 2.0 * var_chaste_interface__L_type_Ca_channel__C2 * var_L_type_Ca_channel__beta + 4.0 * var_chaste_interface__L_type_Ca_channel__C0 * var_L_type_Ca_channel__alpha + var_chaste_interface__L_type_Ca_channel__C_Ca1 * var_L_type_Ca_channel__omega / var_L_type_Ca_channel__b; // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C2 = -(2.0 * var_L_type_Ca_channel__alpha + 2.0 * var_L_type_Ca_channel__beta + pow(var_L_type_Ca_channel__a, 2) * var_L_type_Ca_channel__gamma) * var_chaste_interface__L_type_Ca_channel__C2 + 3.0 * var_chaste_interface__L_type_Ca_channel__C1 * var_L_type_Ca_channel__alpha + 3.0 * var_chaste_interface__L_type_Ca_channel__C3 * var_L_type_Ca_channel__beta + var_chaste_interface__L_type_Ca_channel__C_Ca2 * var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 2); // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C3 = -(3.0 * var_L_type_Ca_channel__beta + pow(var_L_type_Ca_channel__a, 3) * var_L_type_Ca_channel__gamma + var_L_type_Ca_channel__alpha) * var_chaste_interface__L_type_Ca_channel__C3 + 2.0 * var_chaste_interface__L_type_Ca_channel__C2 * var_L_type_Ca_channel__alpha + 4.0 * var_chaste_interface__L_type_Ca_channel__C4 * var_L_type_Ca_channel__beta + var_chaste_interface__L_type_Ca_channel__C_Ca3 * var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 3); // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C4 = var_chaste_interface__L_type_Ca_channel__C3 * var_L_type_Ca_channel__alpha + var_chaste_interface__L_type_Ca_channel__O * var_L_type_Ca_channel__g - (4.0 * var_L_type_Ca_channel__beta + pow(var_L_type_Ca_channel__a, 4) * var_L_type_Ca_channel__gamma + var_L_type_Ca_channel__f) * var_chaste_interface__L_type_Ca_channel__C4 + var_chaste_interface__L_type_Ca_channel__C_Ca4 * var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 4); // 1 / ms
        const double var_L_type_Ca_channel__beta_b = var_L_type_Ca_channel__beta / var_L_type_Ca_channel__b; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca0 = var_chaste_interface__L_type_Ca_channel__C_Ca0 * var_L_type_Ca_channel__gamma + var_chaste_interface__L_type_Ca_channel__C_Ca1 * var_L_type_Ca_channel__beta_b - (4.0 * var_L_type_Ca_channel__alpha_a + var_L_type_Ca_channel__omega) * var_chaste_interface__L_type_Ca_channel__C_Ca0; // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca1 = -(3.0 * var_L_type_Ca_channel__alpha_a + var_L_type_Ca_channel__omega / var_L_type_Ca_channel__b + var_L_type_Ca_channel__beta_b) * var_chaste_interface__L_type_Ca_channel__C_Ca1 + 2.0 * var_chaste_interface__L_type_Ca_channel__C_Ca2 * var_L_type_Ca_channel__beta_b + 4.0 * var_chaste_interface__L_type_Ca_channel__C_Ca0 * var_L_type_Ca_channel__alpha_a + var_chaste_interface__L_type_Ca_channel__C1 * var_L_type_Ca_channel__a * var_L_type_Ca_channel__gamma; // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca2 = -(2.0 * var_L_type_Ca_channel__alpha_a + 2.0 * var_L_type_Ca_channel__beta_b + var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 2)) * var_chaste_interface__L_type_Ca_channel__C_Ca2 + 3.0 * var_chaste_interface__L_type_Ca_channel__C_Ca1 * var_L_type_Ca_channel__alpha_a + 3.0 * var_chaste_interface__L_type_Ca_channel__C_Ca3 * var_L_type_Ca_channel__beta_b + pow(var_L_type_Ca_channel__a, 2) * var_chaste_interface__L_type_Ca_channel__C2 * var_L_type_Ca_channel__gamma; // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca3 = -(3.0 * var_L_type_Ca_channel__beta_b + var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 3) + var_L_type_Ca_channel__alpha_a) * var_chaste_interface__L_type_Ca_channel__C_Ca3 + 2.0 * var_chaste_interface__L_type_Ca_channel__C_Ca2 * var_L_type_Ca_channel__alpha_a + 4.0 * var_chaste_interface__L_type_Ca_channel__C_Ca4 * var_L_type_Ca_channel__beta_b + pow(var_L_type_Ca_channel__a, 3) * var_chaste_interface__L_type_Ca_channel__C3 * var_L_type_Ca_channel__gamma; // 1 / ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca4 = var_chaste_interface__L_type_Ca_channel__C_Ca3 * var_L_type_Ca_channel__alpha_a + var_chaste_interface__L_type_Ca_channel__O_Ca * var_L_type_Ca_channel__g_ - (4.0 * var_L_type_Ca_channel__beta_b + var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 4) + var_L_type_Ca_channel__f_) * var_chaste_interface__L_type_Ca_channel__C_Ca4 + pow(var_L_type_Ca_channel__a, 4) * var_chaste_interface__L_type_Ca_channel__C4 * var_L_type_Ca_channel__gamma; // 1 / ms
        const double var_L_type_Ca_channel__i_Ca_L_Ca_max = 4.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_ionic_concentrations__Cao) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__i_Ca_L_Ca = (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__i_Ca_L_Ca_max * var_chaste_interface__L_type_Ca_channel_y_gate__y; // uA_per_mm2
        const double d_dt_chaste_interface_var_calcium_subsystem__Ca_SS = (var_calcium_subsystem__J_rel * var_calcium_subsystem__V_JSR / var_calcium_subsystem__V_SS - var_calcium_subsystem__J_xfer * var_calcium_subsystem__V_myo / var_calcium_subsystem__V_SS - 0.5 * var_L_type_Ca_channel__i_Ca_L_Ca * var_calcium_subsystem__Am / (var_calcium_subsystem__V_SS * var_membrane__F)) * var_calcium_subsystem__B_SS; // mM / ms
        const double var_L_type_Ca_channel__p_k = var_L_type_Ca_channel__P_K / (1.0 + var_L_type_Ca_channel__i_Ca_L_Ca_max / var_L_type_Ca_channel__i_Ca_L_Ca_half); // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_K = pow(var_membrane__F, 2) * (-var_chaste_interface__ionic_concentrations__Ko + var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__p_k * var_chaste_interface__L_type_Ca_channel_y_gate__y * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel_y_gate__tau_y = 20.0 + 600.0 / (1.0 + exp(3.1578947368421053 + 0.10526315789473684 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_y_gate__y_infinity = 1 / (1.0 + exp(7.333333333333333 + 0.13333333333333333 * var_chaste_interface__membrane__V)) + 0.10000000000000001 / (1.0 + exp(3.5 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_L_type_Ca_channel_y_gate__y = (-var_chaste_interface__L_type_Ca_channel_y_gate__y + var_L_type_Ca_channel_y_gate__y_infinity) / var_L_type_Ca_channel_y_gate__tau_y; // 1 / ms
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, 3) * var_ionic_concentrations__Cao * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, 3) * var_chaste_interface__calcium_subsystem__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__k_NaCa / ((1.0 + var_Na_Ca_exchanger__k_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(var_ionic_concentrations__Nao, 3)) * (var_Na_Ca_exchanger__K_mCa + var_ionic_concentrations__Cao)); // uA_per_mm2
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // uA_per_mm2
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // uA_per_mm2
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0)); // per_ms
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__V)) : (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)))); // per_ms
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = (1.0 - var_chaste_interface__fast_sodium_current_h_gate__h) * var_fast_sodium_current_h_gate__alpha_h - var_fast_sodium_current_h_gate__beta_h * var_chaste_interface__fast_sodium_current_h_gate__h; // 1 / ms
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))) : (0)); // per_ms
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)))); // per_ms
        const double d_dt_chaste_interface_var_fast_sodium_current_j_gate__j = (1.0 - var_chaste_interface__fast_sodium_current_j_gate__j) * var_fast_sodium_current_j_gate__alpha_j - var_fast_sodium_current_j_gate__beta_j * var_chaste_interface__fast_sodium_current_j_gate__j; // 1 / ms
        const double var_fast_sodium_current_m_gate__alpha_m = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_ms
        const double var_fast_sodium_current_m_gate__beta_m = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V); // per_ms
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m * var_chaste_interface__fast_sodium_current_m_gate__m; // 1 / ms
        const double var_non_specific_calcium_activated_current__EnsCa = var_membrane__R * var_membrane__T * log((var_chaste_interface__ionic_concentrations__Ko + var_ionic_concentrations__Nao) / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai)) / var_membrane__F; // mV
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // mM
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 1.75e-9; // mm_per_ms
        const double var_non_specific_calcium_activated_current__VnsCa = -var_non_specific_calcium_activated_current__EnsCa + var_chaste_interface__membrane__V; // mV
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-0.75 * var_chaste_interface__ionic_concentrations__Ko + 0.75 * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-0.75 * var_ionic_concentrations__Nao + 0.75 * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 8.2799999999999993e-5; // mS_per_mm2
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.0115; // uA_per_mm2
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // mM
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_subsystem__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_subsystem__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // uA_per_mm2
        const double d_dt_chaste_interface_var_calcium_subsystem__Cai = (-var_calcium_subsystem__J_trpn - var_calcium_subsystem__J_up - 0.5 * (-2.0 * var_Na_Ca_exchanger__i_NaCa + var_calcium_background_current__i_Ca_b + var_sarcolemmal_calcium_pump__i_p_Ca) * var_calcium_subsystem__Am / (var_calcium_subsystem__V_myo * var_membrane__F) + var_calcium_subsystem__J_leak + var_calcium_subsystem__J_xfer) * var_calcium_subsystem__Bi; // mM / ms
        const double var_sodium_background_current__E_NaN = var_fast_sodium_current__E_Na; // mV
        const double var_sodium_background_current__g_Nab = 1.4100000000000001e-5; // mS_per_mm2
        const double var_sodium_background_current__i_Na_b = (-var_sodium_background_current__E_NaN + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // uA_per_mm2
        const double var_sodium_potassium_pump__I_NaK = 0.012999999999999999; // uA_per_mm2
        const double var_sodium_potassium_pump__K_mKo = 1.5; // mM
        const double var_sodium_potassium_pump__K_mNai = 10.0; // mM
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__ionic_concentrations__Nai), 1.5)) * (var_chaste_interface__ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // uA_per_mm2
        const double d_dt_chaste_interface_var_ionic_concentrations__Nai = (-var_fast_sodium_current__i_Na - var_non_specific_calcium_activated_current__i_ns_Na - var_sodium_background_current__i_Na_b - 3.0 * var_Na_Ca_exchanger__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) * var_calcium_subsystem__Am / (var_calcium_subsystem__V_myo * var_membrane__F); // mM / ms
        const double var_time_dependent_potassium_current__P_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // mV
        const double var_time_dependent_potassium_current__g_K_max = 0.0011280000000000001; // mS_per_mm2
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_dependent_potassium_current__g_K_max; // mS_per_mm2
        const double var_time_dependent_potassium_current_X_gate__alpha_X = 7.1899999999999999e-5 * (30.0 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_dependent_potassium_current_X_gate__beta_X = 0.00013100000000000001 * (30.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__membrane__V)); // per_ms
        const double d_dt_chaste_interface_var_time_dependent_potassium_current_X_gate__X = (1.0 - var_chaste_interface__time_dependent_potassium_current_X_gate__X) * var_time_dependent_potassium_current_X_gate__alpha_X - var_chaste_interface__time_dependent_potassium_current_X_gate__X * var_time_dependent_potassium_current_X_gate__beta_X; // 1 / ms
        const double var_time_dependent_potassium_current_Xi_gate__Xi = 1 / (1.0 + exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2) * (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_time_dependent_potassium_current_Xi_gate__Xi; // uA_per_mm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(var_chaste_interface__ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // mV
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // mV
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // uA_per_mm2
        const double var_time_independent_potassium_current__g_K1_max = 0.0074999999999999997; // mS_per_mm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_independent_potassium_current__g_K1_max; // mS_per_mm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // uA_per_mm2
        const double d_dt_chaste_interface_var_ionic_concentrations__Ki = (-var_L_type_Ca_channel__i_Ca_L_K - var_non_specific_calcium_activated_current__i_ns_K - var_plateau_potassium_current__i_Kp - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1 + 2.0 * var_sodium_potassium_pump__i_NaK) * var_calcium_subsystem__Am / (var_calcium_subsystem__V_myo * var_membrane__F); // mM / ms
        const double d_dt_chaste_interface_var_ionic_concentrations__Ko = (-2.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_Ca_L_K + var_non_specific_calcium_activated_current__i_ns_K + var_plateau_potassium_current__i_Kp + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1) * var_calcium_subsystem__Am / (var_calcium_subsystem__V_myo * var_membrane__F); // mM / ms

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_membrane__Cm = 0.01; // uF_per_mm2
            const double var_membrane__I_stim_converted = -GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
            const double var_membrane__I_stim = 0.0099999999999999985 * var_membrane__I_stim_converted; // uA_per_mm2
            const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // uA_per_mm2
            d_dt_chaste_interface_var_membrane__V = (-var_L_type_Ca_channel__i_Ca_L_Ca - var_L_type_Ca_channel__i_Ca_L_K - var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_non_specific_calcium_activated_current__i_ns_Ca - var_plateau_potassium_current__i_Kp - var_sarcolemmal_calcium_pump__i_p_Ca - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_NaK - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1 + var_membrane__I_stim) / var_membrane__Cm; // mV / ms
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        mEvalF[1] = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        mEvalF[2] = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        mEvalF[3] = d_dt_chaste_interface_var_fast_sodium_current_j_gate__j;
        mEvalF[4] = d_dt_chaste_interface_var_L_type_Ca_channel__O;
        mEvalF[5] = d_dt_chaste_interface_var_L_type_Ca_channel__O_Ca;
        mEvalF[6] = d_dt_chaste_interface_var_L_type_Ca_channel__C0;
        mEvalF[7] = d_dt_chaste_interface_var_L_type_Ca_channel__C1;
        mEvalF[8] = d_dt_chaste_interface_var_L_type_Ca_channel__C2;
        mEvalF[9] = d_dt_chaste_interface_var_L_type_Ca_channel__C3;
        mEvalF[10] = d_dt_chaste_interface_var_L_type_Ca_channel__C4;
        mEvalF[11] = d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca0;
        mEvalF[12] = d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca1;
        mEvalF[13] = d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca2;
        mEvalF[14] = d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca3;
        mEvalF[15] = d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca4;
        mEvalF[16] = d_dt_chaste_interface_var_L_type_Ca_channel_y_gate__y;
        mEvalF[17] = d_dt_chaste_interface_var_time_dependent_potassium_current_X_gate__X;
        mEvalF[18] = d_dt_chaste_interface_var_calcium_subsystem__Cai;
        mEvalF[19] = d_dt_chaste_interface_var_calcium_subsystem__Ca_SS;
        mEvalF[20] = d_dt_chaste_interface_var_calcium_subsystem__P_O1;
        mEvalF[21] = d_dt_chaste_interface_var_calcium_subsystem__P_O2;
        mEvalF[22] = d_dt_chaste_interface_var_calcium_subsystem__P_C1;
        mEvalF[23] = d_dt_chaste_interface_var_calcium_subsystem__P_C2;
        mEvalF[24] = d_dt_chaste_interface_var_calcium_subsystem__Ca_JSR;
        mEvalF[25] = d_dt_chaste_interface_var_calcium_subsystem__Ca_NSR;
        mEvalF[26] = d_dt_chaste_interface_var_calcium_subsystem__HTRPNCa;
        mEvalF[27] = d_dt_chaste_interface_var_calcium_subsystem__LTRPNCa;
        mEvalF[28] = d_dt_chaste_interface_var_ionic_concentrations__Nai;
        mEvalF[29] = d_dt_chaste_interface_var_ionic_concentrations__Ki;
        mEvalF[30] = d_dt_chaste_interface_var_ionic_concentrations__Ko;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time, rY, delta);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time, rY, delta);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time, rY, delta);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time, rY, delta);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time, rY, delta);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time, rY, delta);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time, rY, delta);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time, rY, delta);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time, rY, delta);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time, rY, delta);
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__environment__time, rY, delta);
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__environment__time, rY, delta);
        mPartialF[29] = EvaluatePartialDerivative29(var_chaste_interface__environment__time, rY, delta);
        mPartialF[30] = EvaluatePartialDerivative30(var_chaste_interface__environment__time, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        rY[13] = y_save;
        
        
        y_save = rY[14];
        rY[14] = mYInit[14];
        mEvalF[14] = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        rY[14] = y_save;
        
        
        y_save = rY[15];
        rY[15] = mYInit[15];
        mEvalF[15] = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        rY[15] = y_save;
        
        
        y_save = rY[16];
        rY[16] = mYInit[16];
        mEvalF[16] = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        rY[16] = y_save;
        
        
        y_save = rY[17];
        rY[17] = mYInit[17];
        mEvalF[17] = EvaluateYDerivative17(var_chaste_interface__environment__time, rY);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time, rY, delta);
        rY[17] = y_save;
        
        
        y_save = rY[18];
        rY[18] = mYInit[18];
        mEvalF[18] = EvaluateYDerivative18(var_chaste_interface__environment__time, rY);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time, rY, delta);
        rY[18] = y_save;
        
        
        y_save = rY[19];
        rY[19] = mYInit[19];
        mEvalF[19] = EvaluateYDerivative19(var_chaste_interface__environment__time, rY);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time, rY, delta);
        rY[19] = y_save;
        
        
        y_save = rY[20];
        rY[20] = mYInit[20];
        mEvalF[20] = EvaluateYDerivative20(var_chaste_interface__environment__time, rY);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time, rY, delta);
        rY[20] = y_save;
        
        
        y_save = rY[21];
        rY[21] = mYInit[21];
        mEvalF[21] = EvaluateYDerivative21(var_chaste_interface__environment__time, rY);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time, rY, delta);
        rY[21] = y_save;
        
        
        y_save = rY[22];
        rY[22] = mYInit[22];
        mEvalF[22] = EvaluateYDerivative22(var_chaste_interface__environment__time, rY);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time, rY, delta);
        rY[22] = y_save;
        
        
        y_save = rY[23];
        rY[23] = mYInit[23];
        mEvalF[23] = EvaluateYDerivative23(var_chaste_interface__environment__time, rY);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time, rY, delta);
        rY[23] = y_save;
        
        
        y_save = rY[24];
        rY[24] = mYInit[24];
        mEvalF[24] = EvaluateYDerivative24(var_chaste_interface__environment__time, rY);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time, rY, delta);
        rY[24] = y_save;
        
        
        y_save = rY[25];
        rY[25] = mYInit[25];
        mEvalF[25] = EvaluateYDerivative25(var_chaste_interface__environment__time, rY);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time, rY, delta);
        rY[25] = y_save;
        
        
        y_save = rY[26];
        rY[26] = mYInit[26];
        mEvalF[26] = EvaluateYDerivative26(var_chaste_interface__environment__time, rY);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time, rY, delta);
        rY[26] = y_save;
        
        
        y_save = rY[27];
        rY[27] = mYInit[27];
        mEvalF[27] = EvaluateYDerivative27(var_chaste_interface__environment__time, rY);
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__environment__time, rY, delta);
        rY[27] = y_save;
        
        
        y_save = rY[28];
        rY[28] = mYInit[28];
        mEvalF[28] = EvaluateYDerivative28(var_chaste_interface__environment__time, rY);
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__environment__time, rY, delta);
        rY[28] = y_save;
        
        
        y_save = rY[29];
        rY[29] = mYInit[29];
        mEvalF[29] = EvaluateYDerivative29(var_chaste_interface__environment__time, rY);
        mPartialF[29] = EvaluatePartialDerivative29(var_chaste_interface__environment__time, rY, delta);
        rY[29] = y_save;
        
        
        y_save = rY[30];
        rY[30] = mYInit[30];
        mEvalF[30] = EvaluateYDerivative30(var_chaste_interface__environment__time, rY);
        mPartialF[30] = EvaluatePartialDerivative30(var_chaste_interface__environment__time, rY, delta);
        rY[30] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__L_type_Ca_channel__O = rY[4];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
        // Units: dimensionless; Initial value: 0.000928836
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__ionic_concentrations__Nai = rY[28];
        // Units: mM; Initial value: 10.2042
        double var_chaste_interface__ionic_concentrations__Ki = rY[29];
        // Units: mM; Initial value: 143.727
        double var_chaste_interface__ionic_concentrations__Ko = rY[30];
        // Units: mM; Initial value: 5.4
        
        
        // Mathematics
        const double var_L_type_Ca_channel__P_Ca = 3.375e-5; // mm_per_ms
        const double var_L_type_Ca_channel__P_K = 1.0000000000000001e-9; // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_Ca_half = -0.0045799999999999999; // uA_per_mm2
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // mM
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // mM
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_Na_Ca_exchanger__k_NaCa = 50.0; // uA_per_mm2
        const double var_Na_Ca_exchanger__k_sat = 0.10000000000000001; // dimensionless
        const double var_calcium_background_current__g_Cab = 6.0319999999999998e-5; // mS_per_mm2
        const double var_fast_sodium_current__g_Na = 0.128; // mS_per_mm2
        const double var_ionic_concentrations__Cao = 1.8; // mM
        const double var_ionic_concentrations__Nao = 140.0; // mM
        const double var_membrane__Cm = 0.01; // uF_per_mm2
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__I_stim_converted = -GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__I_stim = 0.0099999999999999985 * var_membrane__I_stim_converted; // uA_per_mm2
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Cao / var_chaste_interface__calcium_subsystem__Cai) / var_membrane__F; // mV
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // mV
        const double var_L_type_Ca_channel__i_Ca_L_Ca_max = 4.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_ionic_concentrations__Cao) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__i_Ca_L_Ca = (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__i_Ca_L_Ca_max * var_chaste_interface__L_type_Ca_channel_y_gate__y; // uA_per_mm2
        const double var_L_type_Ca_channel__p_k = var_L_type_Ca_channel__P_K / (1.0 + var_L_type_Ca_channel__i_Ca_L_Ca_max / var_L_type_Ca_channel__i_Ca_L_Ca_half); // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_K = pow(var_membrane__F, 2) * (-var_chaste_interface__ionic_concentrations__Ko + var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__p_k * var_chaste_interface__L_type_Ca_channel_y_gate__y * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, 3) * var_ionic_concentrations__Cao * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, 3) * var_chaste_interface__calcium_subsystem__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__k_NaCa / ((1.0 + var_Na_Ca_exchanger__k_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(var_ionic_concentrations__Nao, 3)) * (var_Na_Ca_exchanger__K_mCa + var_ionic_concentrations__Cao)); // uA_per_mm2
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // uA_per_mm2
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // uA_per_mm2
        const double var_non_specific_calcium_activated_current__EnsCa = var_membrane__R * var_membrane__T * log((var_chaste_interface__ionic_concentrations__Ko + var_ionic_concentrations__Nao) / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai)) / var_membrane__F; // mV
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // mM
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 1.75e-9; // mm_per_ms
        const double var_non_specific_calcium_activated_current__VnsCa = -var_non_specific_calcium_activated_current__EnsCa + var_chaste_interface__membrane__V; // mV
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-0.75 * var_chaste_interface__ionic_concentrations__Ko + 0.75 * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-0.75 * var_ionic_concentrations__Nao + 0.75 * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // uA_per_mm2
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 8.2799999999999993e-5; // mS_per_mm2
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.0115; // uA_per_mm2
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // mM
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_subsystem__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_subsystem__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // uA_per_mm2
        const double var_sodium_background_current__E_NaN = var_fast_sodium_current__E_Na; // mV
        const double var_sodium_background_current__g_Nab = 1.4100000000000001e-5; // mS_per_mm2
        const double var_sodium_background_current__i_Na_b = (-var_sodium_background_current__E_NaN + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // uA_per_mm2
        const double var_sodium_potassium_pump__I_NaK = 0.012999999999999999; // uA_per_mm2
        const double var_sodium_potassium_pump__K_mKo = 1.5; // mM
        const double var_sodium_potassium_pump__K_mNai = 10.0; // mM
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__ionic_concentrations__Nai), 1.5)) * (var_chaste_interface__ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // uA_per_mm2
        const double var_time_dependent_potassium_current__P_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // mV
        const double var_time_dependent_potassium_current__g_K_max = 0.0011280000000000001; // mS_per_mm2
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_dependent_potassium_current__g_K_max; // mS_per_mm2
        const double var_time_dependent_potassium_current_Xi_gate__Xi = 1 / (1.0 + exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2) * (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_time_dependent_potassium_current_Xi_gate__Xi; // uA_per_mm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(var_chaste_interface__ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // mV
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // mV
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // uA_per_mm2
        const double var_time_independent_potassium_current__g_K1_max = 0.0074999999999999997; // mS_per_mm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_independent_potassium_current__g_K1_max; // mS_per_mm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // uA_per_mm2
        d_dt_chaste_interface_var_membrane__V = (-var_L_type_Ca_channel__i_Ca_L_Ca - var_L_type_Ca_channel__i_Ca_L_K - var_Na_Ca_exchanger__i_NaCa - var_calcium_background_current__i_Ca_b - var_fast_sodium_current__i_Na - var_non_specific_calcium_activated_current__i_ns_Ca - var_plateau_potassium_current__i_Kp - var_sarcolemmal_calcium_pump__i_p_Ca - var_sodium_background_current__i_Na_b - var_sodium_potassium_pump__i_NaK - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1 + var_membrane__I_stim) / var_membrane__Cm; // mV / ms

        return d_dt_chaste_interface_var_membrane__V;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
            // Units: dimensionless; Initial value: 0.0328302
            double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
            // Units: dimensionless; Initial value: 0.988354
            double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
            // Units: dimensionless; Initial value: 0.99254
            double var_chaste_interface__L_type_Ca_channel__O = rY[4];
            // Units: dimensionless; Initial value: 9.84546e-21
            double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
            // Units: dimensionless; Initial value: 0.998983
            double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
            // Units: dimensionless; Initial value: 0.000928836
            double var_chaste_interface__calcium_subsystem__Cai = rY[18];
            // Units: mM; Initial value: 9.94893e-11
            double var_chaste_interface__ionic_concentrations__Nai = rY[28];
            // Units: mM; Initial value: 10.2042
            double var_chaste_interface__ionic_concentrations__Ki = rY[29];
            // Units: mM; Initial value: 143.727
            double var_chaste_interface__ionic_concentrations__Ko = rY[30];
            // Units: mM; Initial value: 5.4
            
            const double var_x0 = exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V);
            const double var_x1 = 1.0 + var_x0;
            const double var_x2 = 1 / var_x1;
            const double var_x3 = exp(-0.024422646794659157 * var_chaste_interface__membrane__V);
            const double var_x4 = 1.0 + 0.10000000000000001 * var_x3;
            const double var_x5 = 1 / var_x4;
            const double var_x6 = var_x3 * var_chaste_interface__calcium_subsystem__Cai;
            const double var_x7 = exp(0.013150655966354929 * var_chaste_interface__membrane__V);
            const double var_x8 = var_x7 * pow(var_chaste_interface__ionic_concentrations__Nai, 3);
            const double var_x9 = var_x5 * (67015.74280454473 * var_x6 + 0.023671180739438871 * var_x8);
            const double var_x10 = sqrt(var_chaste_interface__ionic_concentrations__Ko);
            const double var_x11 = 1 / var_chaste_interface__ionic_concentrations__Ki;
            const double var_x12 = log(var_x11 * var_chaste_interface__ionic_concentrations__Ko);
            const double var_x13 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 6.3475921059424856 * var_x12);
            const double var_x14 = 1.0 + var_x13;
            const double var_x15 = 1 / var_x14;
            const double var_x16 = exp(-2.4444678999999998 + 13.687910356755641 * var_x12 - 0.51429999999999998 * var_chaste_interface__membrane__V);
            const double var_x17 = 1.0 + var_x16;
            const double var_x18 = 1 / var_x17;
            const double var_x19 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 2.1376880417161446 * var_x12);
            const double var_x20 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 1.6434541406371006 * var_x12);
            const double var_x21 = var_x20 + 0.49124000000000001 * var_x19;
            const double var_x22 = var_x18 * var_x21;
            const double var_x23 = 1 / (var_x22 + 1.02 * var_x15);
            const double var_x24 = var_x15 * var_x23;
            const double var_x25 = var_x10 * var_x24;
            const double var_x26 = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2);
            const double var_x27 = exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V);
            const double var_x28 = 1.0 + var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x30 = var_x10 * var_x29;
            const double var_x31 = var_x26 * var_x30;
            const double var_x32 = 1.8 * var_x8 - 2744000.0 * var_x6;
            const double var_x33 = var_x3 * var_x32 / pow(var_x4, 2);
            const double var_x34 = 0.037573302761014088 * var_chaste_interface__membrane__V;
            const double var_x35 = 1 / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai);
            const double var_x36 = 140.0 + var_chaste_interface__ionic_concentrations__Ko;
            const double var_x37 = log(var_x35 * var_x36);
            const double var_x38 = exp(var_x34 - 1.0 * var_x37);
            const double var_x39 = 0.75 * var_x38;
            const double var_x40 = var_x39 * var_chaste_interface__ionic_concentrations__Nai;
            const double var_x41 = -105.0 + var_x40;
            const double var_x42 = pow(var_chaste_interface__calcium_subsystem__Cai, 3);
            const double var_x43 = 1.0 + 1.7279999999999996e-9 / var_x42;
            const double var_x44 = 1 / var_x43;
            const double var_x45 = -1.0 + var_x38;
            const double var_x46 = 1 / var_x45;
            const double var_x47 = var_x44 * var_x46;
            const double var_x48 = 0.00063678763853082152 * var_x47;
            const double var_x49 = var_x39 * var_chaste_interface__ionic_concentrations__Ki;
            const double var_x50 = var_x49 - 0.75 * var_chaste_interface__ionic_concentrations__Ko;
            const double var_x51 = -26.614641953637257 * var_x12 + var_chaste_interface__membrane__V;
            const double var_x52 = var_x0 * var_x51 / pow(var_x1, 2);
            const double var_x53 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
            const double var_x54 = var_x53 * var_chaste_interface__fast_sodium_current_j_gate__j;
            const double var_x55 = 12.800000000000001 * var_x54;
            const double var_x56 = 49.123617829520519 * var_chaste_interface__L_type_Ca_channel_y_gate__y;
            const double var_x57 = var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca;
            const double var_x58 = exp(0.075146605522028176 * var_chaste_interface__membrane__V);
            const double var_x59 = -1.0 + var_x58;
            const double var_x60 = 1 / var_x59;
            const double var_x61 = -0.61380000000000001 + 0.001 * var_x58;
            const double var_x62 = var_x60 * var_x61;
            const double var_x63 = var_x57 * var_x62;
            const double var_x64 = var_x10 * var_x51;
            const double var_x65 = var_x13 / pow(var_x14, 2);
            const double var_x66 = var_x23 * var_x65;
            const double var_x67 = var_x64 * var_x66;
            const double var_x68 = 1 / (0.018329999999999999 * var_chaste_interface__ionic_concentrations__Nai + var_chaste_interface__ionic_concentrations__Ki);
            const double var_x69 = 2.5661999999999998 + var_chaste_interface__ionic_concentrations__Ko;
            const double var_x70 = -26.614641953637257 * log(var_x68 * var_x69) + var_chaste_interface__membrane__V;
            const double var_x71 = var_x26 * var_x70;
            const double var_x72 = var_x10 * var_x27 * var_x71 / pow(var_x28, 2);
            const double var_x73 = -26.614641953637257 * var_x37 + var_chaste_interface__membrane__V;
            const double var_x74 = var_x38 * var_x73;
            const double var_x75 = var_x44 * var_x74 / pow(var_x45, 2);
            const double var_x76 = 2.3926214736989757e-5 * var_x75;
            const double var_x77 = var_x16 * var_x21 / pow(var_x17, 2);
            const double var_x78 = 0.24326999999999999 * var_x65 - 0.51429999999999998 * var_x77 - var_x18 * (0.061749999999999999 * var_x20 + 0.039456396800000001 * var_x19);
            const double var_x79 = var_x15 * var_x64 / pow((var_x15 + 0.98039215686274506 * var_x22), 2);
            const double var_x80 = 0.31642020802348175 * var_x79;
            const double var_x81 = 1 / var_chaste_interface__ionic_concentrations__Nai;
            const double var_x82 = pow(var_x81, 1.5);
            const double var_x83 = 1 / (1.0 + 31.622776601683793 * var_x82);
            const double var_x84 = exp(-0.0037573302761014088 * var_chaste_interface__membrane__V);
            const double var_x85 = exp(2.0802377414561666);
            const double var_x86 = exp(-var_x34);
            const double var_x87 = 1.0 + 0.1245 * var_x84 + 0.036499999999999998 * var_x86 * (-0.14285714285714285 + 0.14285714285714285 * var_x85);
            const double var_x88 = 1 / (1.5 + var_chaste_interface__ionic_concentrations__Ko);
            const double var_x89 = var_x88 * var_chaste_interface__ionic_concentrations__Ko;
            const double var_x90 = var_x83 * var_x89 * (0.00046778761937462537 * var_x84 + 0.037573302761014088 * var_x86 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x85)) / pow(var_x87, 2);
            const double var_x91 = var_x57 * var_chaste_interface__L_type_Ca_channel_y_gate__y;
            const double var_x92 = var_x62 * var_chaste_interface__membrane__V;
            const double var_x93 = 1 / (1.0 - 107.25680748803607 * var_x92);
            const double var_x94 = exp(var_x34);
            const double var_x95 = -1.0 + var_x94;
            const double var_x96 = 1 / var_x95;
            const double var_x97 = var_x94 * var_chaste_interface__ionic_concentrations__Ki;
            const double var_x98 = var_x97 - var_chaste_interface__ionic_concentrations__Ko;
            const double var_x99 = var_x93 * var_x96 * var_x98;
            const double var_x100 = 0.00036387865058904091 * var_x99;
            const double var_x101 = var_x47 * var_x74;
            const double var_x102 = 1.7944661052742317e-5 * var_x101;
            const double var_x103 = var_x58 * var_chaste_interface__membrane__V;
            const double var_x104 = var_x103 * var_x60;
            const double var_x105 = var_x104 * var_x91;
            const double var_x106 = var_x103 * var_x61 / pow(var_x59, 2);
            const double var_x107 = var_x106 * var_x91;
            const double var_x108 = var_x91 * var_x93 * var_chaste_interface__membrane__V;
            const double var_x109 = var_x108 * var_x94 * var_x98 / pow(var_x95, 2);
            const double var_x110 = var_x108 * var_x96;
            const double var_x111 = var_x110 * var_x97;
            const double var_x112 = var_x91 * var_x96 * var_x98 * (0.0080599850018555647 * var_x104 + 107.25680748803607 * var_x62 - 8.0599850018555639 * var_x106) * var_chaste_interface__membrane__V / pow((0.0093234175379641477 - var_x92), 2);
            
            partialF = -0.0074419999999999998 + 0.078515054885989852 * var_x67 + 1.3672122706851291e-5 * var_x109 + 0.0015121928745316601 * var_x72 + 3.6914731308498485 * var_x107 - 0.32920358442763042 * var_x25 - 0.048541391272466296 * var_x31 - 1.1248174225403713e-6 * var_x33 - 1.2999999999999998 * var_x90 - 0.0013846153846153843 * var_x52 - 1.3672122706851291e-5 * var_x111 - 0.0082799999999999992 * var_x2 - 3.163055727694504e-8 * var_x112 - 0.00046056327637115517 * var_x9 - 0.0036914731308498486 * var_x105 + var_x41 * var_x76 + var_x50 * var_x76 - var_x100 * var_x91 - var_x102 * var_chaste_interface__ionic_concentrations__Ki - var_x102 * var_chaste_interface__ionic_concentrations__Nai - var_x41 * var_x48 - var_x48 * var_x50 - var_x55 * var_chaste_interface__fast_sodium_current_h_gate__h - var_x56 * var_x63 - var_x78 * var_x80;
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        
        
        // Mathematics
        const double var_fast_sodium_current_m_gate__alpha_m = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // per_ms
        const double var_fast_sodium_current_m_gate__beta_m = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V); // per_ms
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m * var_chaste_interface__fast_sodium_current_m_gate__m; // 1 / ms

        return d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            
            const double var_x169 = -0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x170 = exp(-4.7130000000000001 + var_x169);
            const double var_x171 = 1.0 - var_x170;
            const double var_x172 = 0.32000000000000001 / var_x171;
            const double var_x173 = exp(-0.090909090909090912 * var_chaste_interface__membrane__V);
            const double var_x174 = 47.130000000000003 + var_chaste_interface__membrane__V;
            
            partialF = -0.080000000000000002 * var_x173 - var_x172 * var_x174;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        
        
        // Mathematics
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0)); // per_ms
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__V)) : (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)))); // per_ms
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = (1.0 - var_chaste_interface__fast_sodium_current_h_gate__h) * var_fast_sodium_current_h_gate__alpha_h - var_fast_sodium_current_h_gate__beta_h * var_chaste_interface__fast_sodium_current_h_gate__h; // 1 / ms

        return d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            
            const double var_x175 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V);
            const double var_x176 = var_chaste_interface__membrane__V < -40.0;
            const double var_x177 = exp(0.079000000000000001 * var_chaste_interface__membrane__V);
            const double var_x178 = exp(0.34999999999999998 * var_chaste_interface__membrane__V);
            const double var_x179 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V);
            const double var_x180 = 1.0 + var_x179;
            
            partialF = -((var_x176) ? (0.13500000000000001 * var_x175) : (0)) - ((var_x176) ? (310000.0 * var_x178 + 3.5600000000000001 * var_x177) : (7.6923076923076916 / var_x180));
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        
        
        // Mathematics
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))) : (0)); // per_ms
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)))); // per_ms
        const double d_dt_chaste_interface_var_fast_sodium_current_j_gate__j = (1.0 - var_chaste_interface__fast_sodium_current_j_gate__j) * var_fast_sodium_current_j_gate__alpha_j - var_fast_sodium_current_j_gate__beta_j * var_chaste_interface__fast_sodium_current_j_gate__j; // 1 / ms

        return d_dt_chaste_interface_var_fast_sodium_current_j_gate__j;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            
            const double var_x169 = -0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x176 = var_chaste_interface__membrane__V < -40.0;
            const double var_x181 = exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V);
            const double var_x182 = 1.0 + var_x181;
            const double var_x183 = 1 / var_x182;
            const double var_x184 = exp(0.24440000000000001 * var_chaste_interface__membrane__V);
            const double var_x185 = exp(-0.043909999999999998 * var_chaste_interface__membrane__V);
            const double var_x186 = -127140.0 * var_x184 - 3.4740000000000003e-5 * var_x185;
            const double var_x187 = var_x183 * var_x186;
            const double var_x188 = 37.780000000000001 + var_chaste_interface__membrane__V;
            const double var_x189 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V);
            const double var_x190 = 1.0 + var_x189;
            const double var_x191 = exp(-0.01052 * var_chaste_interface__membrane__V);
            const double var_x192 = var_x191 / var_x190;
            const double var_x193 = exp(-3.2000000000000002 + var_x169);
            const double var_x194 = 1.0 + var_x193;
            const double var_x195 = exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V);
            const double var_x196 = var_x195 / var_x194;
            
            partialF = -((var_x176) ? (0.1212 * var_x192) : (0.29999999999999999 * var_x196)) - ((var_x176) ? (var_x187 * var_x188) : (0));
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__L_type_Ca_channel__O = rY[4];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_channel__C4 = rY[10];
        // Units: dimensionless; Initial value: 6.56337e-20
        
        
        // Mathematics
        const double var_L_type_Ca_channel__f = 0.29999999999999999; // per_ms
        const double var_L_type_Ca_channel__g = 2.0; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__O = var_chaste_interface__L_type_Ca_channel__C4 * var_L_type_Ca_channel__f - var_chaste_interface__L_type_Ca_channel__O * var_L_type_Ca_channel__g; // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel__O;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -2.0;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel__C_Ca4 = rY[15];
        // Units: dimensionless; Initial value: 4.59752e-20
        
        
        // Mathematics
        const double var_L_type_Ca_channel__f_ = 0; // per_ms
        const double var_L_type_Ca_channel__g_ = 0; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__O_Ca = var_chaste_interface__L_type_Ca_channel__C_Ca4 * var_L_type_Ca_channel__f_ - var_chaste_interface__L_type_Ca_channel__O_Ca * var_L_type_Ca_channel__g_; // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel__O_Ca;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = 0;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__C0 = rY[6];
        // Units: dimensionless; Initial value: 0.997208
        double var_chaste_interface__L_type_Ca_channel__C1 = rY[7];
        // Units: dimensionless; Initial value: 6.38897e-05
        double var_chaste_interface__L_type_Ca_channel__C_Ca0 = rY[11];
        // Units: dimensionless; Initial value: 0.00272826
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        
        
        // Mathematics
        const double var_L_type_Ca_channel__omega = 0.01; // per_ms
        const double var_L_type_Ca_channel__gamma = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS; // per_ms
        const double var_L_type_Ca_channel__alpha = 0.40000000000000002 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C0 = var_chaste_interface__L_type_Ca_channel__C1 * var_L_type_Ca_channel__beta + var_chaste_interface__L_type_Ca_channel__C_Ca0 * var_L_type_Ca_channel__omega - (4.0 * var_L_type_Ca_channel__alpha + var_L_type_Ca_channel__gamma) * var_chaste_interface__L_type_Ca_channel__C0; // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel__C0;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
            // Units: mM; Initial value: 0.000136058
            
            const double var_x197 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x202 = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS;
            const double var_x203 = 1.6000000000000001 * var_x197;
            const double var_x204 = -var_x203;
            
            partialF = var_x204 - var_x202;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__C0 = rY[6];
        // Units: dimensionless; Initial value: 0.997208
        double var_chaste_interface__L_type_Ca_channel__C1 = rY[7];
        // Units: dimensionless; Initial value: 6.38897e-05
        double var_chaste_interface__L_type_Ca_channel__C2 = rY[8];
        // Units: dimensionless; Initial value: 1.535e-09
        double var_chaste_interface__L_type_Ca_channel__C_Ca1 = rY[12];
        // Units: dimensionless; Initial value: 6.99215e-07
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        
        
        // Mathematics
        const double var_L_type_Ca_channel__a = 2.0; // dimensionless
        const double var_L_type_Ca_channel__b = 2.0; // dimensionless
        const double var_L_type_Ca_channel__omega = 0.01; // per_ms
        const double var_L_type_Ca_channel__gamma = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS; // per_ms
        const double var_L_type_Ca_channel__alpha = 0.40000000000000002 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C1 = -(3.0 * var_L_type_Ca_channel__alpha + var_L_type_Ca_channel__a * var_L_type_Ca_channel__gamma + var_L_type_Ca_channel__beta) * var_chaste_interface__L_type_Ca_channel__C1 + 2.0 * var_chaste_interface__L_type_Ca_channel__C2 * var_L_type_Ca_channel__beta + 4.0 * var_chaste_interface__L_type_Ca_channel__C0 * var_L_type_Ca_channel__alpha + var_chaste_interface__L_type_Ca_channel__C_Ca1 * var_L_type_Ca_channel__omega / var_L_type_Ca_channel__b; // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel__C1;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
            // Units: mM; Initial value: 0.000136058
            
            const double var_x197 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x200 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x205 = 0.050000000000000003 * var_x200;
            const double var_x208 = 0.375 * var_chaste_interface__calcium_subsystem__Ca_SS;
            const double var_x209 = -var_x205;
            const double var_x210 = 1.2000000000000002 * var_x197;
            
            partialF = var_x209 - var_x208 - var_x210;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__C1 = rY[7];
        // Units: dimensionless; Initial value: 6.38897e-05
        double var_chaste_interface__L_type_Ca_channel__C2 = rY[8];
        // Units: dimensionless; Initial value: 1.535e-09
        double var_chaste_interface__L_type_Ca_channel__C3 = rY[9];
        // Units: dimensionless; Initial value: 1.63909e-14
        double var_chaste_interface__L_type_Ca_channel__C_Ca2 = rY[13];
        // Units: dimensionless; Initial value: 6.71989e-11
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        
        
        // Mathematics
        const double var_L_type_Ca_channel__a = 2.0; // dimensionless
        const double var_L_type_Ca_channel__b = 2.0; // dimensionless
        const double var_L_type_Ca_channel__omega = 0.01; // per_ms
        const double var_L_type_Ca_channel__gamma = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS; // per_ms
        const double var_L_type_Ca_channel__alpha = 0.40000000000000002 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C2 = -(2.0 * var_L_type_Ca_channel__alpha + 2.0 * var_L_type_Ca_channel__beta + pow(var_L_type_Ca_channel__a, 2) * var_L_type_Ca_channel__gamma) * var_chaste_interface__L_type_Ca_channel__C2 + 3.0 * var_chaste_interface__L_type_Ca_channel__C1 * var_L_type_Ca_channel__alpha + 3.0 * var_chaste_interface__L_type_Ca_channel__C3 * var_L_type_Ca_channel__beta + var_chaste_interface__L_type_Ca_channel__C_Ca2 * var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 2); // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel__C2;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
            // Units: mM; Initial value: 0.000136058
            
            const double var_x197 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x200 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x211 = 0.10000000000000001 * var_x200;
            const double var_x216 = 0.75 * var_chaste_interface__calcium_subsystem__Ca_SS;
            const double var_x217 = -var_x211;
            const double var_x218 = 0.80000000000000004 * var_x197;
            const double var_x219 = -var_x218;
            
            partialF = var_x217 + var_x219 - var_x216;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__C2 = rY[8];
        // Units: dimensionless; Initial value: 1.535e-09
        double var_chaste_interface__L_type_Ca_channel__C3 = rY[9];
        // Units: dimensionless; Initial value: 1.63909e-14
        double var_chaste_interface__L_type_Ca_channel__C4 = rY[10];
        // Units: dimensionless; Initial value: 6.56337e-20
        double var_chaste_interface__L_type_Ca_channel__C_Ca3 = rY[14];
        // Units: dimensionless; Initial value: 2.87031e-15
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        
        
        // Mathematics
        const double var_L_type_Ca_channel__a = 2.0; // dimensionless
        const double var_L_type_Ca_channel__b = 2.0; // dimensionless
        const double var_L_type_Ca_channel__omega = 0.01; // per_ms
        const double var_L_type_Ca_channel__gamma = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS; // per_ms
        const double var_L_type_Ca_channel__alpha = 0.40000000000000002 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C3 = -(3.0 * var_L_type_Ca_channel__beta + pow(var_L_type_Ca_channel__a, 3) * var_L_type_Ca_channel__gamma + var_L_type_Ca_channel__alpha) * var_chaste_interface__L_type_Ca_channel__C3 + 2.0 * var_chaste_interface__L_type_Ca_channel__C2 * var_L_type_Ca_channel__alpha + 4.0 * var_chaste_interface__L_type_Ca_channel__C4 * var_L_type_Ca_channel__beta + var_chaste_interface__L_type_Ca_channel__C_Ca3 * var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 3); // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel__C3;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
            // Units: mM; Initial value: 0.000136058
            
            const double var_x197 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x200 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x220 = 0.15000000000000002 * var_x200;
            const double var_x224 = 1.5 * var_chaste_interface__calcium_subsystem__Ca_SS;
            const double var_x225 = 0.40000000000000002 * var_x197;
            
            partialF = -var_x220 - var_x224 - var_x225;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__O = rY[4];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_channel__C3 = rY[9];
        // Units: dimensionless; Initial value: 1.63909e-14
        double var_chaste_interface__L_type_Ca_channel__C4 = rY[10];
        // Units: dimensionless; Initial value: 6.56337e-20
        double var_chaste_interface__L_type_Ca_channel__C_Ca4 = rY[15];
        // Units: dimensionless; Initial value: 4.59752e-20
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        
        
        // Mathematics
        const double var_L_type_Ca_channel__a = 2.0; // dimensionless
        const double var_L_type_Ca_channel__b = 2.0; // dimensionless
        const double var_L_type_Ca_channel__f = 0.29999999999999999; // per_ms
        const double var_L_type_Ca_channel__g = 2.0; // per_ms
        const double var_L_type_Ca_channel__omega = 0.01; // per_ms
        const double var_L_type_Ca_channel__gamma = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS; // per_ms
        const double var_L_type_Ca_channel__alpha = 0.40000000000000002 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C4 = var_chaste_interface__L_type_Ca_channel__C3 * var_L_type_Ca_channel__alpha + var_chaste_interface__L_type_Ca_channel__O * var_L_type_Ca_channel__g - (4.0 * var_L_type_Ca_channel__beta + pow(var_L_type_Ca_channel__a, 4) * var_L_type_Ca_channel__gamma + var_L_type_Ca_channel__f) * var_chaste_interface__L_type_Ca_channel__C4 + var_chaste_interface__L_type_Ca_channel__C_Ca4 * var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 4); // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel__C4;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
            // Units: mM; Initial value: 0.000136058
            
            const double var_x200 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x226 = 0.20000000000000001 * var_x200;
            const double var_x228 = 3.0 * var_chaste_interface__calcium_subsystem__Ca_SS;
            
            partialF = -0.29999999999999999 - var_x226 - var_x228;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__C_Ca0 = rY[11];
        // Units: dimensionless; Initial value: 0.00272826
        double var_chaste_interface__L_type_Ca_channel__C_Ca1 = rY[12];
        // Units: dimensionless; Initial value: 6.99215e-07
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        
        
        // Mathematics
        const double var_L_type_Ca_channel__a = 2.0; // dimensionless
        const double var_L_type_Ca_channel__b = 2.0; // dimensionless
        const double var_L_type_Ca_channel__omega = 0.01; // per_ms
        const double var_L_type_Ca_channel__gamma = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS; // per_ms
        const double var_L_type_Ca_channel__alpha = 0.40000000000000002 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__alpha_a = var_L_type_Ca_channel__a * var_L_type_Ca_channel__alpha; // per_ms
        const double var_L_type_Ca_channel__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__beta_b = var_L_type_Ca_channel__beta / var_L_type_Ca_channel__b; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca0 = var_chaste_interface__L_type_Ca_channel__C_Ca0 * var_L_type_Ca_channel__gamma + var_chaste_interface__L_type_Ca_channel__C_Ca1 * var_L_type_Ca_channel__beta_b - (4.0 * var_L_type_Ca_channel__alpha_a + var_L_type_Ca_channel__omega) * var_chaste_interface__L_type_Ca_channel__C_Ca0; // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca0;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
            // Units: mM; Initial value: 0.000136058
            
            const double var_x197 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x202 = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS;
            const double var_x232 = 3.2000000000000002 * var_x197;
            
            partialF = -0.01 + var_x202 - var_x232;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__C1 = rY[7];
        // Units: dimensionless; Initial value: 6.38897e-05
        double var_chaste_interface__L_type_Ca_channel__C_Ca0 = rY[11];
        // Units: dimensionless; Initial value: 0.00272826
        double var_chaste_interface__L_type_Ca_channel__C_Ca1 = rY[12];
        // Units: dimensionless; Initial value: 6.99215e-07
        double var_chaste_interface__L_type_Ca_channel__C_Ca2 = rY[13];
        // Units: dimensionless; Initial value: 6.71989e-11
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        
        
        // Mathematics
        const double var_L_type_Ca_channel__a = 2.0; // dimensionless
        const double var_L_type_Ca_channel__b = 2.0; // dimensionless
        const double var_L_type_Ca_channel__omega = 0.01; // per_ms
        const double var_L_type_Ca_channel__gamma = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS; // per_ms
        const double var_L_type_Ca_channel__alpha = 0.40000000000000002 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__alpha_a = var_L_type_Ca_channel__a * var_L_type_Ca_channel__alpha; // per_ms
        const double var_L_type_Ca_channel__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__beta_b = var_L_type_Ca_channel__beta / var_L_type_Ca_channel__b; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca1 = -(3.0 * var_L_type_Ca_channel__alpha_a + var_L_type_Ca_channel__omega / var_L_type_Ca_channel__b + var_L_type_Ca_channel__beta_b) * var_chaste_interface__L_type_Ca_channel__C_Ca1 + 2.0 * var_chaste_interface__L_type_Ca_channel__C_Ca2 * var_L_type_Ca_channel__beta_b + 4.0 * var_chaste_interface__L_type_Ca_channel__C_Ca0 * var_L_type_Ca_channel__alpha_a + var_chaste_interface__L_type_Ca_channel__C1 * var_L_type_Ca_channel__a * var_L_type_Ca_channel__gamma; // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca1;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            
            const double var_x197 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x200 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x233 = 0.025000000000000001 * var_x200;
            const double var_x235 = 2.4000000000000004 * var_x197;
            
            partialF = -0.0050000000000000001 - var_x233 - var_x235;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__C2 = rY[8];
        // Units: dimensionless; Initial value: 1.535e-09
        double var_chaste_interface__L_type_Ca_channel__C_Ca1 = rY[12];
        // Units: dimensionless; Initial value: 6.99215e-07
        double var_chaste_interface__L_type_Ca_channel__C_Ca2 = rY[13];
        // Units: dimensionless; Initial value: 6.71989e-11
        double var_chaste_interface__L_type_Ca_channel__C_Ca3 = rY[14];
        // Units: dimensionless; Initial value: 2.87031e-15
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        
        
        // Mathematics
        const double var_L_type_Ca_channel__a = 2.0; // dimensionless
        const double var_L_type_Ca_channel__b = 2.0; // dimensionless
        const double var_L_type_Ca_channel__omega = 0.01; // per_ms
        const double var_L_type_Ca_channel__gamma = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS; // per_ms
        const double var_L_type_Ca_channel__alpha = 0.40000000000000002 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__alpha_a = var_L_type_Ca_channel__a * var_L_type_Ca_channel__alpha; // per_ms
        const double var_L_type_Ca_channel__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__beta_b = var_L_type_Ca_channel__beta / var_L_type_Ca_channel__b; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca2 = -(2.0 * var_L_type_Ca_channel__alpha_a + 2.0 * var_L_type_Ca_channel__beta_b + var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 2)) * var_chaste_interface__L_type_Ca_channel__C_Ca2 + 3.0 * var_chaste_interface__L_type_Ca_channel__C_Ca1 * var_L_type_Ca_channel__alpha_a + 3.0 * var_chaste_interface__L_type_Ca_channel__C_Ca3 * var_L_type_Ca_channel__beta_b + pow(var_L_type_Ca_channel__a, 2) * var_chaste_interface__L_type_Ca_channel__C2 * var_L_type_Ca_channel__gamma; // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca2;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            
            const double var_x197 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x200 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x203 = 1.6000000000000001 * var_x197;
            const double var_x204 = -var_x203;
            const double var_x205 = 0.050000000000000003 * var_x200;
            const double var_x209 = -var_x205;
            
            partialF = -0.0025000000000000001 + var_x204 + var_x209;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__C3 = rY[9];
        // Units: dimensionless; Initial value: 1.63909e-14
        double var_chaste_interface__L_type_Ca_channel__C_Ca2 = rY[13];
        // Units: dimensionless; Initial value: 6.71989e-11
        double var_chaste_interface__L_type_Ca_channel__C_Ca3 = rY[14];
        // Units: dimensionless; Initial value: 2.87031e-15
        double var_chaste_interface__L_type_Ca_channel__C_Ca4 = rY[15];
        // Units: dimensionless; Initial value: 4.59752e-20
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        
        
        // Mathematics
        const double var_L_type_Ca_channel__a = 2.0; // dimensionless
        const double var_L_type_Ca_channel__b = 2.0; // dimensionless
        const double var_L_type_Ca_channel__omega = 0.01; // per_ms
        const double var_L_type_Ca_channel__gamma = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS; // per_ms
        const double var_L_type_Ca_channel__alpha = 0.40000000000000002 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__alpha_a = var_L_type_Ca_channel__a * var_L_type_Ca_channel__alpha; // per_ms
        const double var_L_type_Ca_channel__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__beta_b = var_L_type_Ca_channel__beta / var_L_type_Ca_channel__b; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca3 = -(3.0 * var_L_type_Ca_channel__beta_b + var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 3) + var_L_type_Ca_channel__alpha_a) * var_chaste_interface__L_type_Ca_channel__C_Ca3 + 2.0 * var_chaste_interface__L_type_Ca_channel__C_Ca2 * var_L_type_Ca_channel__alpha_a + 4.0 * var_chaste_interface__L_type_Ca_channel__C_Ca4 * var_L_type_Ca_channel__beta_b + pow(var_L_type_Ca_channel__a, 3) * var_chaste_interface__L_type_Ca_channel__C3 * var_L_type_Ca_channel__gamma; // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca3;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            
            const double var_x197 = exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V);
            const double var_x200 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x218 = 0.80000000000000004 * var_x197;
            const double var_x219 = -var_x218;
            const double var_x237 = 0.075000000000000011 * var_x200;
            
            partialF = -0.00125 + var_x219 - var_x237;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel__C4 = rY[10];
        // Units: dimensionless; Initial value: 6.56337e-20
        double var_chaste_interface__L_type_Ca_channel__C_Ca3 = rY[14];
        // Units: dimensionless; Initial value: 2.87031e-15
        double var_chaste_interface__L_type_Ca_channel__C_Ca4 = rY[15];
        // Units: dimensionless; Initial value: 4.59752e-20
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        
        
        // Mathematics
        const double var_L_type_Ca_channel__a = 2.0; // dimensionless
        const double var_L_type_Ca_channel__b = 2.0; // dimensionless
        const double var_L_type_Ca_channel__f_ = 0; // per_ms
        const double var_L_type_Ca_channel__g_ = 0; // per_ms
        const double var_L_type_Ca_channel__omega = 0.01; // per_ms
        const double var_L_type_Ca_channel__gamma = 0.1875 * var_chaste_interface__calcium_subsystem__Ca_SS; // per_ms
        const double var_L_type_Ca_channel__alpha = 0.40000000000000002 * exp(1.2 + 0.10000000000000001 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__alpha_a = var_L_type_Ca_channel__a * var_L_type_Ca_channel__alpha; // per_ms
        const double var_L_type_Ca_channel__beta = 0.050000000000000003 * exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V); // per_ms
        const double var_L_type_Ca_channel__beta_b = var_L_type_Ca_channel__beta / var_L_type_Ca_channel__b; // per_ms
        const double d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca4 = var_chaste_interface__L_type_Ca_channel__C_Ca3 * var_L_type_Ca_channel__alpha_a + var_chaste_interface__L_type_Ca_channel__O_Ca * var_L_type_Ca_channel__g_ - (4.0 * var_L_type_Ca_channel__beta_b + var_L_type_Ca_channel__omega / pow(var_L_type_Ca_channel__b, 4) + var_L_type_Ca_channel__f_) * var_chaste_interface__L_type_Ca_channel__C_Ca4 + pow(var_L_type_Ca_channel__a, 4) * var_chaste_interface__L_type_Ca_channel__C4 * var_L_type_Ca_channel__gamma; // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel__C_Ca4;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            
            const double var_x200 = exp(-0.92307692307692313 - 0.076923076923076927 * var_chaste_interface__membrane__V);
            const double var_x211 = 0.10000000000000001 * var_x200;
            const double var_x217 = -var_x211;
            
            partialF = -0.00062500000000000001 + var_x217;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        
        
        // Mathematics
        const double var_L_type_Ca_channel_y_gate__tau_y = 20.0 + 600.0 / (1.0 + exp(3.1578947368421053 + 0.10526315789473684 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_y_gate__y_infinity = 1 / (1.0 + exp(7.333333333333333 + 0.13333333333333333 * var_chaste_interface__membrane__V)) + 0.10000000000000001 / (1.0 + exp(3.5 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_L_type_Ca_channel_y_gate__y = (-var_chaste_interface__L_type_Ca_channel_y_gate__y + var_L_type_Ca_channel_y_gate__y_infinity) / var_L_type_Ca_channel_y_gate__tau_y; // 1 / ms

        return d_dt_chaste_interface_var_L_type_Ca_channel_y_gate__y;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            
            const double var_x239 = exp(3.1578947368421053 + 0.10526315789473684 * var_chaste_interface__membrane__V);
            const double var_x240 = 1.0 + var_x239;
            const double var_x241 = 1 / var_x240;
            const double var_x242 = 1 / (20.0 + 600.0 * var_x241);
            
            partialF = -var_x242;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
        // Units: dimensionless; Initial value: 0.000928836
        
        
        // Mathematics
        const double var_time_dependent_potassium_current_X_gate__alpha_X = 7.1899999999999999e-5 * (30.0 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_dependent_potassium_current_X_gate__beta_X = 0.00013100000000000001 * (30.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__membrane__V)); // per_ms
        const double d_dt_chaste_interface_var_time_dependent_potassium_current_X_gate__X = (1.0 - var_chaste_interface__time_dependent_potassium_current_X_gate__X) * var_time_dependent_potassium_current_X_gate__alpha_X - var_chaste_interface__time_dependent_potassium_current_X_gate__X * var_time_dependent_potassium_current_X_gate__beta_X; // 1 / ms

        return d_dt_chaste_interface_var_time_dependent_potassium_current_X_gate__X;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            
            const double var_x248 = exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__membrane__V);
            const double var_x249 = 1.0 - var_x248;
            const double var_x250 = 7.1899999999999999e-5 / var_x249;
            const double var_x251 = exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__membrane__V);
            const double var_x252 = -1.0 + var_x251;
            const double var_x253 = 0.00013100000000000001 / var_x252;
            const double var_x254 = 30.0 + var_chaste_interface__membrane__V;
            
            partialF = -var_x250 * var_x254 - var_x253 * var_x254;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        double var_chaste_interface__calcium_subsystem__Ca_NSR = rY[25];
        // Units: mM; Initial value: 1.243891
        double var_chaste_interface__calcium_subsystem__HTRPNCa = rY[26];
        // Units: mM; Initial value: 0.13598
        double var_chaste_interface__calcium_subsystem__LTRPNCa = rY[27];
        // Units: mM; Initial value: 0.00635
        double var_chaste_interface__ionic_concentrations__Nai = rY[28];
        // Units: mM; Initial value: 10.2042
        
        
        // Mathematics
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // mM
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // mM
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_Na_Ca_exchanger__k_NaCa = 50.0; // uA_per_mm2
        const double var_Na_Ca_exchanger__k_sat = 0.10000000000000001; // dimensionless
        const double var_calcium_background_current__g_Cab = 6.0319999999999998e-5; // mS_per_mm2
        const double var_calcium_subsystem__Am = 546.69000000000005; // per_mm
        const double var_calcium_subsystem__CMDN_tot = 0.050000000000000003; // mM
        const double var_calcium_subsystem__HTRPN_tot = 0.14000000000000001; // mM
        const double var_calcium_subsystem__K_mCMDN = 0.0023800000000000002; // mM
        const double var_calcium_subsystem__Bi = 1 / (1.0 + var_calcium_subsystem__CMDN_tot * var_calcium_subsystem__K_mCMDN / pow((var_chaste_interface__calcium_subsystem__Cai + var_calcium_subsystem__K_mCMDN), 2)); // dimensionless
        const double var_calcium_subsystem__K_mup = 0.00050000000000000001; // mM
        const double var_calcium_subsystem__LTRPN_tot = 0.070000000000000007; // mM
        const double var_calcium_subsystem__V_myo = 0.92000000000000004; // dimensionless
        const double var_calcium_subsystem__k_htrpn_minus = 6.6000000000000005e-5; // per_ms
        const double var_calcium_subsystem__k_htrpn_plus = 20.0; // per_mM_per_ms
        const double var_calcium_subsystem__J_htrpn = -var_chaste_interface__calcium_subsystem__HTRPNCa * var_calcium_subsystem__k_htrpn_minus + (-var_chaste_interface__calcium_subsystem__HTRPNCa + var_calcium_subsystem__HTRPN_tot) * var_chaste_interface__calcium_subsystem__Cai * var_calcium_subsystem__k_htrpn_plus; // mM_per_ms
        const double var_calcium_subsystem__k_ltrpn_minus = 0.040000000000000001; // per_ms
        const double var_calcium_subsystem__k_ltrpn_plus = 40.0; // per_mM_per_ms
        const double var_calcium_subsystem__J_ltrpn = -var_chaste_interface__calcium_subsystem__LTRPNCa * var_calcium_subsystem__k_ltrpn_minus + (-var_chaste_interface__calcium_subsystem__LTRPNCa + var_calcium_subsystem__LTRPN_tot) * var_chaste_interface__calcium_subsystem__Cai * var_calcium_subsystem__k_ltrpn_plus; // mM_per_ms
        const double var_calcium_subsystem__J_trpn = var_calcium_subsystem__J_htrpn + var_calcium_subsystem__J_ltrpn; // mM_per_ms
        const double var_calcium_subsystem__tau_xfer = 3.125; // ms
        const double var_calcium_subsystem__J_xfer = (-var_chaste_interface__calcium_subsystem__Cai + var_chaste_interface__calcium_subsystem__Ca_SS) / var_calcium_subsystem__tau_xfer; // mM_per_ms
        const double var_calcium_subsystem__v2 = 5.8e-5; // per_ms
        const double var_calcium_subsystem__J_leak = (-var_chaste_interface__calcium_subsystem__Cai + var_chaste_interface__calcium_subsystem__Ca_NSR) * var_calcium_subsystem__v2; // mM_per_ms
        const double var_calcium_subsystem__v3 = 0.0018; // mM_per_ms
        const double var_calcium_subsystem__J_up = pow(var_chaste_interface__calcium_subsystem__Cai, 2) * var_calcium_subsystem__v3 / (pow(var_chaste_interface__calcium_subsystem__Cai, 2) + pow(var_calcium_subsystem__K_mup, 2)); // mM_per_ms
        const double var_ionic_concentrations__Cao = 1.8; // mM
        const double var_ionic_concentrations__Nao = 140.0; // mM
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_CaN = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Cao / var_chaste_interface__calcium_subsystem__Cai) / var_membrane__F; // mV
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, 3) * var_ionic_concentrations__Cao * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, 3) * var_chaste_interface__calcium_subsystem__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__k_NaCa / ((1.0 + var_Na_Ca_exchanger__k_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(var_ionic_concentrations__Nao, 3)) * (var_Na_Ca_exchanger__K_mCa + var_ionic_concentrations__Cao)); // uA_per_mm2
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_CaN + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // uA_per_mm2
        const double var_sarcolemmal_calcium_pump__I_pCa = 0.0115; // uA_per_mm2
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // mM
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_subsystem__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_subsystem__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // uA_per_mm2
        const double d_dt_chaste_interface_var_calcium_subsystem__Cai = (-var_calcium_subsystem__J_trpn - var_calcium_subsystem__J_up - 0.5 * (-2.0 * var_Na_Ca_exchanger__i_NaCa + var_calcium_background_current__i_Ca_b + var_sarcolemmal_calcium_pump__i_p_Ca) * var_calcium_subsystem__Am / (var_calcium_subsystem__V_myo * var_membrane__F) + var_calcium_subsystem__J_leak + var_calcium_subsystem__J_xfer) * var_calcium_subsystem__Bi; // mM / ms

        return d_dt_chaste_interface_var_calcium_subsystem__Cai;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            double var_chaste_interface__calcium_subsystem__Cai = rY[18];
            // Units: mM; Initial value: 9.94893e-11
            double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
            // Units: mM; Initial value: 0.000136058
            double var_chaste_interface__calcium_subsystem__Ca_NSR = rY[25];
            // Units: mM; Initial value: 1.243891
            double var_chaste_interface__calcium_subsystem__HTRPNCa = rY[26];
            // Units: mM; Initial value: 0.13598
            double var_chaste_interface__calcium_subsystem__LTRPNCa = rY[27];
            // Units: mM; Initial value: 0.00635
            double var_chaste_interface__ionic_concentrations__Nai = rY[28];
            // Units: mM; Initial value: 10.2042
            
            const double var_x3 = exp(-0.024422646794659157 * var_chaste_interface__membrane__V);
            const double var_x4 = 1.0 + 0.10000000000000001 * var_x3;
            const double var_x5 = 1 / var_x4;
            const double var_x6 = var_x3 * var_chaste_interface__calcium_subsystem__Cai;
            const double var_x7 = exp(0.013150655966354929 * var_chaste_interface__membrane__V);
            const double var_x8 = var_x7 * pow(var_chaste_interface__ionic_concentrations__Nai, 3);
            const double var_x32 = 1.8 * var_x8 - 2744000.0 * var_x6;
            const double var_x42 = pow(var_chaste_interface__calcium_subsystem__Cai, 3);
            const double var_x121 = 0.00050000000000000001 + var_chaste_interface__calcium_subsystem__Cai;
            const double var_x122 = 1 / var_x121;
            const double var_x123 = 1 / var_chaste_interface__calcium_subsystem__Cai;
            const double var_x124 = var_chaste_interface__calcium_subsystem__Cai / pow(var_x121, 2);
            const double var_x125 = var_x3 * var_x5;
            const double var_x255 = 0.0023800000000000002 + var_chaste_interface__calcium_subsystem__Cai;
            const double var_x256 = 1.0 + 0.00011900000000000002 / pow(var_x255, 2);
            const double var_x257 = 1 / var_x256;
            const double var_x258 = var_x257;
            const double var_x259 = 20.0 * var_chaste_interface__calcium_subsystem__HTRPNCa;
            const double var_x260 = 40.0 * var_chaste_interface__calcium_subsystem__LTRPNCa;
            const double var_x261 = 3.5281248386597142e-5 * var_x122;
            const double var_x262 = pow(var_chaste_interface__calcium_subsystem__Cai, 2);
            const double var_x263 = 2.4999999999999999e-7 + var_x262;
            const double var_x264 = var_x42 / pow(var_x263, 2);
            const double var_x265 = 1 / var_x263;
            const double var_x266 = var_x265 * var_chaste_interface__calcium_subsystem__Cai;
            const double var_x267 = 20.0 * var_chaste_interface__calcium_subsystem__Cai;
            const double var_x268 = 40.0 * var_chaste_interface__calcium_subsystem__Cai;
            
            partialF = var_x258 * (-5.9200580000000009 + var_x259 + var_x260 - var_x261 + 0.0035999999999999999 * var_x264 + 3.5281248386597142e-5 * var_x124 - 0.0035999999999999999 * var_x266 - 0.077544234316921451 * var_x125 - 2.4626237783962268e-6 * var_x123) + 0.00023800000000000004 * (5.8e-5 * var_chaste_interface__calcium_subsystem__Ca_NSR + 6.6000000000000005e-5 * var_chaste_interface__calcium_subsystem__HTRPNCa + 0.040000000000000001 * var_chaste_interface__calcium_subsystem__LTRPNCa + 0.32000000000000001 * var_chaste_interface__calcium_subsystem__Ca_SS + 2.4626237783962268e-6 * log(1.8 * var_x123) - 0.32005800000000001 * var_chaste_interface__calcium_subsystem__Cai - 1.8505781762430779e-7 * var_chaste_interface__membrane__V - var_x261 * var_chaste_interface__calcium_subsystem__Cai - var_x267 * (0.14000000000000001 - var_chaste_interface__calcium_subsystem__HTRPNCa) - var_x268 * (0.070000000000000007 - var_chaste_interface__calcium_subsystem__LTRPNCa) + 2.8259560611122977e-8 * var_x32 * var_x5 - 0.0018 * var_x262 * var_x265) / (pow(var_x255, 3) * pow(var_x256, 2));
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__O = rY[4];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        double var_chaste_interface__calcium_subsystem__P_O1 = rY[20];
        // Units: dimensionless; Initial value: 0.00119168
        double var_chaste_interface__calcium_subsystem__P_O2 = rY[21];
        // Units: dimensionless; Initial value: 6.30613e-09
        double var_chaste_interface__calcium_subsystem__Ca_JSR = rY[24];
        // Units: mM; Initial value: 1.17504
        
        
        // Mathematics
        const double var_L_type_Ca_channel__P_Ca = 3.375e-5; // mm_per_ms
        const double var_calcium_subsystem__Am = 546.69000000000005; // per_mm
        const double var_calcium_subsystem__CMDN_tot = 0.050000000000000003; // mM
        const double var_calcium_subsystem__K_mCMDN = 0.0023800000000000002; // mM
        const double var_calcium_subsystem__B_SS = 1 / (1.0 + var_calcium_subsystem__CMDN_tot * var_calcium_subsystem__K_mCMDN / pow((var_chaste_interface__calcium_subsystem__Ca_SS + var_calcium_subsystem__K_mCMDN), 2)); // dimensionless
        const double var_calcium_subsystem__RyR_open = var_chaste_interface__calcium_subsystem__P_O1 + var_chaste_interface__calcium_subsystem__P_O2; // dimensionless
        const double var_calcium_subsystem__V_myo = 0.92000000000000004; // dimensionless
        const double var_calcium_subsystem__V_JSR = 0.00464 * var_calcium_subsystem__V_myo; // dimensionless
        const double var_calcium_subsystem__V_SS = 5.8279999999999998e-5 * var_calcium_subsystem__V_myo; // dimensionless
        const double var_calcium_subsystem__tau_xfer = 3.125; // ms
        const double var_calcium_subsystem__J_xfer = (-var_chaste_interface__calcium_subsystem__Cai + var_chaste_interface__calcium_subsystem__Ca_SS) / var_calcium_subsystem__tau_xfer; // mM_per_ms
        const double var_calcium_subsystem__v1 = 1.8; // per_ms
        const double var_calcium_subsystem__J_rel = (-var_chaste_interface__calcium_subsystem__Ca_SS + var_chaste_interface__calcium_subsystem__Ca_JSR) * var_calcium_subsystem__RyR_open * var_calcium_subsystem__v1; // mM_per_ms
        const double var_ionic_concentrations__Cao = 1.8; // mM
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca_max = 4.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_ionic_concentrations__Cao) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__i_Ca_L_Ca = (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__i_Ca_L_Ca_max * var_chaste_interface__L_type_Ca_channel_y_gate__y; // uA_per_mm2
        const double d_dt_chaste_interface_var_calcium_subsystem__Ca_SS = (var_calcium_subsystem__J_rel * var_calcium_subsystem__V_JSR / var_calcium_subsystem__V_SS - var_calcium_subsystem__J_xfer * var_calcium_subsystem__V_myo / var_calcium_subsystem__V_SS - 0.5 * var_L_type_Ca_channel__i_Ca_L_Ca * var_calcium_subsystem__Am / (var_calcium_subsystem__V_SS * var_membrane__F)) * var_calcium_subsystem__B_SS; // mM / ms

        return d_dt_chaste_interface_var_calcium_subsystem__Ca_SS;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            double var_chaste_interface__L_type_Ca_channel__O = rY[4];
            // Units: dimensionless; Initial value: 9.84546e-21
            double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
            // Units: dimensionless; Initial value: 0.998983
            double var_chaste_interface__calcium_subsystem__Cai = rY[18];
            // Units: mM; Initial value: 9.94893e-11
            double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
            // Units: mM; Initial value: 0.000136058
            double var_chaste_interface__calcium_subsystem__P_O1 = rY[20];
            // Units: dimensionless; Initial value: 0.00119168
            double var_chaste_interface__calcium_subsystem__P_O2 = rY[21];
            // Units: dimensionless; Initial value: 6.30613e-09
            double var_chaste_interface__calcium_subsystem__Ca_JSR = rY[24];
            // Units: mM; Initial value: 1.17504
            
            const double var_x57 = var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca;
            const double var_x58 = exp(0.075146605522028176 * var_chaste_interface__membrane__V);
            const double var_x59 = -1.0 + var_x58;
            const double var_x60 = 1 / var_x59;
            const double var_x61 = -0.61380000000000001 + 0.001 * var_x58;
            const double var_x62 = var_x60 * var_x61;
            const double var_x92 = var_x62 * var_chaste_interface__membrane__V;
            const double var_x119 = var_x57 * var_x92;
            const double var_x269 = 25.859308321022734 * var_chaste_interface__L_type_Ca_channel_y_gate__y;
            const double var_x270 = 0.0023800000000000002 + var_chaste_interface__calcium_subsystem__Ca_SS;
            const double var_x271 = 1.0 + 0.00011900000000000002 / pow(var_x270, 2);
            const double var_x272 = 1 / var_x271;
            const double var_x273 = var_x272;
            const double var_x275 = 143.30816746739879 * var_chaste_interface__calcium_subsystem__P_O1;
            const double var_x276 = 143.30816746739879 * var_chaste_interface__calcium_subsystem__P_O2;
            const double var_x277 = (-var_chaste_interface__calcium_subsystem__Ca_SS + var_chaste_interface__calcium_subsystem__Ca_JSR) * (var_chaste_interface__calcium_subsystem__P_O1 + var_chaste_interface__calcium_subsystem__P_O2);
            
            partialF = var_x273 * (-5490.7343857240912 - var_x275 - var_x276) + 0.00023800000000000004 * (143.30816746739879 * var_x277 + 5490.7343857240912 * var_chaste_interface__calcium_subsystem__Cai - 5490.7343857240912 * var_chaste_interface__calcium_subsystem__Ca_SS - var_x119 * var_x269) / (pow(var_x270, 3) * pow(var_x271, 2));
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        double var_chaste_interface__calcium_subsystem__P_O1 = rY[20];
        // Units: dimensionless; Initial value: 0.00119168
        double var_chaste_interface__calcium_subsystem__P_O2 = rY[21];
        // Units: dimensionless; Initial value: 6.30613e-09
        double var_chaste_interface__calcium_subsystem__P_C1 = rY[22];
        // Units: dimensionless; Initial value: 0.762527
        double var_chaste_interface__calcium_subsystem__P_C2 = rY[23];
        // Units: dimensionless; Initial value: 0.236283
        
        
        // Mathematics
        const double var_calcium_subsystem__k_a_minus = 0.14249999999999999; // per_ms
        const double var_calcium_subsystem__k_a_plus = 12150000000.0; // per_mM4_per_ms
        const double var_calcium_subsystem__k_b_minus = 1.9299999999999999; // per_ms
        const double var_calcium_subsystem__k_b_plus = 40500000.0; // per_mM3_per_ms
        const double var_calcium_subsystem__k_c_minus = 0.00080000000000000004; // per_ms
        const double var_calcium_subsystem__k_c_plus = 0.017999999999999999; // per_ms
        const double var_calcium_subsystem__mCa = 3.0; // dimensionless
        const double var_calcium_subsystem__nCa = 4.0; // dimensionless
        const double d_dt_chaste_interface_var_calcium_subsystem__P_O1 = var_chaste_interface__calcium_subsystem__P_C2 * var_calcium_subsystem__k_c_minus + var_chaste_interface__calcium_subsystem__P_O2 * var_calcium_subsystem__k_b_minus - var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_a_minus - var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_c_plus + pow(var_chaste_interface__calcium_subsystem__Ca_SS, var_calcium_subsystem__nCa) * var_chaste_interface__calcium_subsystem__P_C1 * var_calcium_subsystem__k_a_plus - pow(var_chaste_interface__calcium_subsystem__Ca_SS, var_calcium_subsystem__mCa) * var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_b_plus; // 1 / ms

        return d_dt_chaste_interface_var_calcium_subsystem__P_O1;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
            // Units: mM; Initial value: 0.000136058
            
            const double var_x279 = pow(var_chaste_interface__calcium_subsystem__Ca_SS, 3.0);
            const double var_x282 = 40500000.0 * var_x279;
            
            partialF = -0.16049999999999998 - var_x282;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        double var_chaste_interface__calcium_subsystem__P_O1 = rY[20];
        // Units: dimensionless; Initial value: 0.00119168
        double var_chaste_interface__calcium_subsystem__P_O2 = rY[21];
        // Units: dimensionless; Initial value: 6.30613e-09
        
        
        // Mathematics
        const double var_calcium_subsystem__k_b_minus = 1.9299999999999999; // per_ms
        const double var_calcium_subsystem__k_b_plus = 40500000.0; // per_mM3_per_ms
        const double var_calcium_subsystem__mCa = 3.0; // dimensionless
        const double d_dt_chaste_interface_var_calcium_subsystem__P_O2 = -var_chaste_interface__calcium_subsystem__P_O2 * var_calcium_subsystem__k_b_minus + pow(var_chaste_interface__calcium_subsystem__Ca_SS, var_calcium_subsystem__mCa) * var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_b_plus; // 1 / ms

        return d_dt_chaste_interface_var_calcium_subsystem__P_O2;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -1.9299999999999999;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        double var_chaste_interface__calcium_subsystem__P_O1 = rY[20];
        // Units: dimensionless; Initial value: 0.00119168
        double var_chaste_interface__calcium_subsystem__P_C1 = rY[22];
        // Units: dimensionless; Initial value: 0.762527
        
        
        // Mathematics
        const double var_calcium_subsystem__k_a_minus = 0.14249999999999999; // per_ms
        const double var_calcium_subsystem__k_a_plus = 12150000000.0; // per_mM4_per_ms
        const double var_calcium_subsystem__nCa = 4.0; // dimensionless
        const double d_dt_chaste_interface_var_calcium_subsystem__P_C1 = var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_a_minus - pow(var_chaste_interface__calcium_subsystem__Ca_SS, var_calcium_subsystem__nCa) * var_chaste_interface__calcium_subsystem__P_C1 * var_calcium_subsystem__k_a_plus; // 1 / ms

        return d_dt_chaste_interface_var_calcium_subsystem__P_C1;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
            // Units: mM; Initial value: 0.000136058
            
            const double var_x283 = 12150000000.0 * pow(var_chaste_interface__calcium_subsystem__Ca_SS, 4.0);
            
            partialF = -var_x283;
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_subsystem__P_O1 = rY[20];
        // Units: dimensionless; Initial value: 0.00119168
        double var_chaste_interface__calcium_subsystem__P_C2 = rY[23];
        // Units: dimensionless; Initial value: 0.236283
        
        
        // Mathematics
        const double var_calcium_subsystem__k_c_minus = 0.00080000000000000004; // per_ms
        const double var_calcium_subsystem__k_c_plus = 0.017999999999999999; // per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__P_C2 = var_chaste_interface__calcium_subsystem__P_O1 * var_calcium_subsystem__k_c_plus - var_chaste_interface__calcium_subsystem__P_C2 * var_calcium_subsystem__k_c_minus; // 1 / ms

        return d_dt_chaste_interface_var_calcium_subsystem__P_C2;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.00080000000000000004;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
        // Units: mM; Initial value: 0.000136058
        double var_chaste_interface__calcium_subsystem__P_O1 = rY[20];
        // Units: dimensionless; Initial value: 0.00119168
        double var_chaste_interface__calcium_subsystem__P_O2 = rY[21];
        // Units: dimensionless; Initial value: 6.30613e-09
        double var_chaste_interface__calcium_subsystem__Ca_JSR = rY[24];
        // Units: mM; Initial value: 1.17504
        double var_chaste_interface__calcium_subsystem__Ca_NSR = rY[25];
        // Units: mM; Initial value: 1.243891
        
        
        // Mathematics
        const double var_calcium_subsystem__CSQN_tot = 15.0; // mM
        const double var_calcium_subsystem__K_mCSQN = 0.80000000000000004; // mM
        const double var_calcium_subsystem__B_JSR = 1 / (1.0 + var_calcium_subsystem__CSQN_tot * var_calcium_subsystem__K_mCSQN / pow((var_chaste_interface__calcium_subsystem__Ca_JSR + var_calcium_subsystem__K_mCSQN), 2)); // dimensionless
        const double var_calcium_subsystem__RyR_open = var_chaste_interface__calcium_subsystem__P_O1 + var_chaste_interface__calcium_subsystem__P_O2; // dimensionless
        const double var_calcium_subsystem__tau_tr = 34.479999999999997; // ms
        const double var_calcium_subsystem__J_tr = (-var_chaste_interface__calcium_subsystem__Ca_JSR + var_chaste_interface__calcium_subsystem__Ca_NSR) / var_calcium_subsystem__tau_tr; // mM_per_ms
        const double var_calcium_subsystem__v1 = 1.8; // per_ms
        const double var_calcium_subsystem__J_rel = (-var_chaste_interface__calcium_subsystem__Ca_SS + var_chaste_interface__calcium_subsystem__Ca_JSR) * var_calcium_subsystem__RyR_open * var_calcium_subsystem__v1; // mM_per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__Ca_JSR = (-var_calcium_subsystem__J_rel + var_calcium_subsystem__J_tr) * var_calcium_subsystem__B_JSR; // mM / ms

        return d_dt_chaste_interface_var_calcium_subsystem__Ca_JSR;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__calcium_subsystem__Ca_SS = rY[19];
            // Units: mM; Initial value: 0.000136058
            double var_chaste_interface__calcium_subsystem__P_O1 = rY[20];
            // Units: dimensionless; Initial value: 0.00119168
            double var_chaste_interface__calcium_subsystem__P_O2 = rY[21];
            // Units: dimensionless; Initial value: 6.30613e-09
            double var_chaste_interface__calcium_subsystem__Ca_JSR = rY[24];
            // Units: mM; Initial value: 1.17504
            double var_chaste_interface__calcium_subsystem__Ca_NSR = rY[25];
            // Units: mM; Initial value: 1.243891
            
            const double var_x277 = (-var_chaste_interface__calcium_subsystem__Ca_SS + var_chaste_interface__calcium_subsystem__Ca_JSR) * (var_chaste_interface__calcium_subsystem__P_O1 + var_chaste_interface__calcium_subsystem__P_O2);
            const double var_x284 = 1.8 * var_chaste_interface__calcium_subsystem__P_O1;
            const double var_x285 = 1.8 * var_chaste_interface__calcium_subsystem__P_O2;
            const double var_x286 = 0.80000000000000004 + var_chaste_interface__calcium_subsystem__Ca_JSR;
            const double var_x287 = pow(var_x286, (-2));
            const double var_x288 = 1 / (1.0 + 12.0 * var_x287);
            const double var_x289 = var_x288;
            
            partialF = var_x289 * (-0.029002320185614851 - var_x284 - var_x285) + 0.16666666666666666 * (0.029002320185614851 * var_chaste_interface__calcium_subsystem__Ca_NSR - 1.8 * var_x277 - 0.029002320185614851 * var_chaste_interface__calcium_subsystem__Ca_JSR) / (pow(var_x286, 3) * pow((0.083333333333333329 + var_x287), 2));
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__calcium_subsystem__Ca_JSR = rY[24];
        // Units: mM; Initial value: 1.17504
        double var_chaste_interface__calcium_subsystem__Ca_NSR = rY[25];
        // Units: mM; Initial value: 1.243891
        
        
        // Mathematics
        const double var_calcium_subsystem__K_mup = 0.00050000000000000001; // mM
        const double var_calcium_subsystem__V_myo = 0.92000000000000004; // dimensionless
        const double var_calcium_subsystem__V_JSR = 0.00464 * var_calcium_subsystem__V_myo; // dimensionless
        const double var_calcium_subsystem__V_NSR = 0.081000000000000003 * var_calcium_subsystem__V_myo; // dimensionless
        const double var_calcium_subsystem__tau_tr = 34.479999999999997; // ms
        const double var_calcium_subsystem__J_tr = (-var_chaste_interface__calcium_subsystem__Ca_JSR + var_chaste_interface__calcium_subsystem__Ca_NSR) / var_calcium_subsystem__tau_tr; // mM_per_ms
        const double var_calcium_subsystem__v2 = 5.8e-5; // per_ms
        const double var_calcium_subsystem__J_leak = (-var_chaste_interface__calcium_subsystem__Cai + var_chaste_interface__calcium_subsystem__Ca_NSR) * var_calcium_subsystem__v2; // mM_per_ms
        const double var_calcium_subsystem__v3 = 0.0018; // mM_per_ms
        const double var_calcium_subsystem__J_up = pow(var_chaste_interface__calcium_subsystem__Cai, 2) * var_calcium_subsystem__v3 / (pow(var_chaste_interface__calcium_subsystem__Cai, 2) + pow(var_calcium_subsystem__K_mup, 2)); // mM_per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__Ca_NSR = (-var_calcium_subsystem__J_leak + var_calcium_subsystem__J_up) * var_calcium_subsystem__V_myo / var_calcium_subsystem__V_NSR - var_calcium_subsystem__J_tr * var_calcium_subsystem__V_JSR / var_calcium_subsystem__V_NSR; // mM / ms

        return d_dt_chaste_interface_var_calcium_subsystem__Ca_NSR;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.0023774168600154679;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__calcium_subsystem__HTRPNCa = rY[26];
        // Units: mM; Initial value: 0.13598
        
        
        // Mathematics
        const double var_calcium_subsystem__HTRPN_tot = 0.14000000000000001; // mM
        const double var_calcium_subsystem__k_htrpn_minus = 6.6000000000000005e-5; // per_ms
        const double var_calcium_subsystem__k_htrpn_plus = 20.0; // per_mM_per_ms
        const double var_calcium_subsystem__J_htrpn = -var_chaste_interface__calcium_subsystem__HTRPNCa * var_calcium_subsystem__k_htrpn_minus + (-var_chaste_interface__calcium_subsystem__HTRPNCa + var_calcium_subsystem__HTRPN_tot) * var_chaste_interface__calcium_subsystem__Cai * var_calcium_subsystem__k_htrpn_plus; // mM_per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__HTRPNCa = var_calcium_subsystem__J_htrpn; // mM / ms

        return d_dt_chaste_interface_var_calcium_subsystem__HTRPNCa;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__calcium_subsystem__Cai = rY[18];
            // Units: mM; Initial value: 9.94893e-11
            
            const double var_x267 = 20.0 * var_chaste_interface__calcium_subsystem__Cai;
            
            partialF = -6.6000000000000005e-5 - var_x267;
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative27(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__calcium_subsystem__LTRPNCa = rY[27];
        // Units: mM; Initial value: 0.00635
        
        
        // Mathematics
        const double var_calcium_subsystem__LTRPN_tot = 0.070000000000000007; // mM
        const double var_calcium_subsystem__k_ltrpn_minus = 0.040000000000000001; // per_ms
        const double var_calcium_subsystem__k_ltrpn_plus = 40.0; // per_mM_per_ms
        const double var_calcium_subsystem__J_ltrpn = -var_chaste_interface__calcium_subsystem__LTRPNCa * var_calcium_subsystem__k_ltrpn_minus + (-var_chaste_interface__calcium_subsystem__LTRPNCa + var_calcium_subsystem__LTRPN_tot) * var_chaste_interface__calcium_subsystem__Cai * var_calcium_subsystem__k_ltrpn_plus; // mM_per_ms
        const double d_dt_chaste_interface_var_calcium_subsystem__LTRPNCa = var_calcium_subsystem__J_ltrpn; // mM / ms

        return d_dt_chaste_interface_var_calcium_subsystem__LTRPNCa;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative27(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__calcium_subsystem__Cai = rY[18];
            // Units: mM; Initial value: 9.94893e-11
            
            const double var_x268 = 40.0 * var_chaste_interface__calcium_subsystem__Cai;
            
            partialF = -0.040000000000000001 - var_x268;
        }
        else
        {
            const double y_save = rY[27];
            rY[27] += delta;
            const double temp = EvaluateYDerivative27(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[27])/delta;
            rY[27] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative28(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.0328302
        double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.988354
        double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.99254
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__ionic_concentrations__Nai = rY[28];
        // Units: mM; Initial value: 10.2042
        double var_chaste_interface__ionic_concentrations__Ki = rY[29];
        // Units: mM; Initial value: 143.727
        double var_chaste_interface__ionic_concentrations__Ko = rY[30];
        // Units: mM; Initial value: 5.4
        
        
        // Mathematics
        const double var_Na_Ca_exchanger__K_mCa = 1.3799999999999999; // mM
        const double var_Na_Ca_exchanger__K_mNa = 87.5; // mM
        const double var_Na_Ca_exchanger__eta = 0.34999999999999998; // dimensionless
        const double var_Na_Ca_exchanger__k_NaCa = 50.0; // uA_per_mm2
        const double var_Na_Ca_exchanger__k_sat = 0.10000000000000001; // dimensionless
        const double var_calcium_subsystem__Am = 546.69000000000005; // per_mm
        const double var_calcium_subsystem__V_myo = 0.92000000000000004; // dimensionless
        const double var_fast_sodium_current__g_Na = 0.128; // mS_per_mm2
        const double var_ionic_concentrations__Cao = 1.8; // mM
        const double var_ionic_concentrations__Nao = 140.0; // mM
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // mV
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, 3) * var_ionic_concentrations__Cao * exp(var_Na_Ca_exchanger__eta * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, 3) * var_chaste_interface__calcium_subsystem__Cai * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__k_NaCa / ((1.0 + var_Na_Ca_exchanger__k_sat * exp((-1.0 + var_Na_Ca_exchanger__eta) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_Na_Ca_exchanger__K_mNa, 3) + pow(var_ionic_concentrations__Nao, 3)) * (var_Na_Ca_exchanger__K_mCa + var_ionic_concentrations__Cao)); // uA_per_mm2
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // uA_per_mm2
        const double var_non_specific_calcium_activated_current__EnsCa = var_membrane__R * var_membrane__T * log((var_chaste_interface__ionic_concentrations__Ko + var_ionic_concentrations__Nao) / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai)) / var_membrane__F; // mV
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // mM
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 1.75e-9; // mm_per_ms
        const double var_non_specific_calcium_activated_current__VnsCa = -var_non_specific_calcium_activated_current__EnsCa + var_chaste_interface__membrane__V; // mV
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-0.75 * var_ionic_concentrations__Nao + 0.75 * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_sodium_background_current__E_NaN = var_fast_sodium_current__E_Na; // mV
        const double var_sodium_background_current__g_Nab = 1.4100000000000001e-5; // mS_per_mm2
        const double var_sodium_background_current__i_Na_b = (-var_sodium_background_current__E_NaN + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // uA_per_mm2
        const double var_sodium_potassium_pump__I_NaK = 0.012999999999999999; // uA_per_mm2
        const double var_sodium_potassium_pump__K_mKo = 1.5; // mM
        const double var_sodium_potassium_pump__K_mNai = 10.0; // mM
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__ionic_concentrations__Nai), 1.5)) * (var_chaste_interface__ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // uA_per_mm2
        const double d_dt_chaste_interface_var_ionic_concentrations__Nai = (-var_fast_sodium_current__i_Na - var_non_specific_calcium_activated_current__i_ns_Na - var_sodium_background_current__i_Na_b - 3.0 * var_Na_Ca_exchanger__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) * var_calcium_subsystem__Am / (var_calcium_subsystem__V_myo * var_membrane__F); // mM / ms

        return d_dt_chaste_interface_var_ionic_concentrations__Nai;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative28(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            double var_chaste_interface__fast_sodium_current_m_gate__m = rY[1];
            // Units: dimensionless; Initial value: 0.0328302
            double var_chaste_interface__fast_sodium_current_h_gate__h = rY[2];
            // Units: dimensionless; Initial value: 0.988354
            double var_chaste_interface__fast_sodium_current_j_gate__j = rY[3];
            // Units: dimensionless; Initial value: 0.99254
            double var_chaste_interface__calcium_subsystem__Cai = rY[18];
            // Units: mM; Initial value: 9.94893e-11
            double var_chaste_interface__ionic_concentrations__Nai = rY[28];
            // Units: mM; Initial value: 10.2042
            double var_chaste_interface__ionic_concentrations__Ki = rY[29];
            // Units: mM; Initial value: 143.727
            double var_chaste_interface__ionic_concentrations__Ko = rY[30];
            // Units: mM; Initial value: 5.4
            
            const double var_x3 = exp(-0.024422646794659157 * var_chaste_interface__membrane__V);
            const double var_x4 = 1.0 + 0.10000000000000001 * var_x3;
            const double var_x5 = 1 / var_x4;
            const double var_x7 = exp(0.013150655966354929 * var_chaste_interface__membrane__V);
            const double var_x34 = 0.037573302761014088 * var_chaste_interface__membrane__V;
            const double var_x35 = 1 / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai);
            const double var_x36 = 140.0 + var_chaste_interface__ionic_concentrations__Ko;
            const double var_x37 = log(var_x35 * var_x36);
            const double var_x38 = exp(var_x34 - 1.0 * var_x37);
            const double var_x39 = 0.75 * var_x38;
            const double var_x40 = var_x39 * var_chaste_interface__ionic_concentrations__Nai;
            const double var_x41 = -105.0 + var_x40;
            const double var_x42 = pow(var_chaste_interface__calcium_subsystem__Cai, 3);
            const double var_x43 = 1.0 + 1.7279999999999996e-9 / var_x42;
            const double var_x44 = 1 / var_x43;
            const double var_x45 = -1.0 + var_x38;
            const double var_x46 = 1 / var_x45;
            const double var_x47 = var_x44 * var_x46;
            const double var_x53 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
            const double var_x54 = var_x53 * var_chaste_interface__fast_sodium_current_j_gate__j;
            const double var_x73 = -26.614641953637257 * var_x37 + var_chaste_interface__membrane__V;
            const double var_x74 = var_x38 * var_x73;
            const double var_x75 = var_x44 * var_x74 / pow(var_x45, 2);
            const double var_x81 = 1 / var_chaste_interface__ionic_concentrations__Nai;
            const double var_x82 = pow(var_x81, 1.5);
            const double var_x84 = exp(-0.0037573302761014088 * var_chaste_interface__membrane__V);
            const double var_x85 = exp(2.0802377414561666);
            const double var_x86 = exp(-var_x34);
            const double var_x87 = 1.0 + 0.1245 * var_x84 + 0.036499999999999998 * var_x86 * (-0.14285714285714285 + 0.14285714285714285 * var_x85);
            const double var_x88 = 1 / (1.5 + var_chaste_interface__ionic_concentrations__Ko);
            const double var_x89 = var_x88 * var_chaste_interface__ionic_concentrations__Ko;
            const double var_x128 = var_x5 * var_x7 * pow(var_chaste_interface__ionic_concentrations__Nai, 2);
            const double var_x129 = var_x54 * var_x81 * var_chaste_interface__fast_sodium_current_h_gate__h;
            const double var_x130 = var_x39 + var_x35 * var_x40;
            const double var_x135 = 1 / var_x87;
            const double var_x136 = var_x135 * var_x81 * var_x82 * var_x89 / pow((0.031622776601683791 + var_x82), 2);
            const double var_x138 = var_x35 * var_x41;
            const double var_x291 = 3.9072457120905308e-8 * var_x47;
            const double var_x296 = var_x291 * var_x73;
            const double var_x297 = 1.0398994565217392e-6 * var_x47;
            const double var_x298 = 3.9072457120905308e-8 * var_x75;
            const double var_x299 = var_x138 * var_x298 - var_x138 * var_x297;
            
            partialF = var_x299 - 0.020902907402832696 * var_x129 - 1.1350943583223629e-5 * var_x136 - 4.5780488190019227e-7 * var_x128 - 2.3025858935932891e-6 * var_x81 - var_x130 * var_x296;
        }
        else
        {
            const double y_save = rY[28];
            rY[28] += delta;
            const double temp = EvaluateYDerivative28(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[28])/delta;
            rY[28] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative29(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__O = rY[4];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
        // Units: dimensionless; Initial value: 0.000928836
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__ionic_concentrations__Nai = rY[28];
        // Units: mM; Initial value: 10.2042
        double var_chaste_interface__ionic_concentrations__Ki = rY[29];
        // Units: mM; Initial value: 143.727
        double var_chaste_interface__ionic_concentrations__Ko = rY[30];
        // Units: mM; Initial value: 5.4
        
        
        // Mathematics
        const double var_L_type_Ca_channel__P_Ca = 3.375e-5; // mm_per_ms
        const double var_L_type_Ca_channel__P_K = 1.0000000000000001e-9; // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_Ca_half = -0.0045799999999999999; // uA_per_mm2
        const double var_calcium_subsystem__Am = 546.69000000000005; // per_mm
        const double var_calcium_subsystem__V_myo = 0.92000000000000004; // dimensionless
        const double var_ionic_concentrations__Cao = 1.8; // mM
        const double var_ionic_concentrations__Nao = 140.0; // mM
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca_max = 4.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_ionic_concentrations__Cao) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__p_k = var_L_type_Ca_channel__P_K / (1.0 + var_L_type_Ca_channel__i_Ca_L_Ca_max / var_L_type_Ca_channel__i_Ca_L_Ca_half); // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_K = pow(var_membrane__F, 2) * (-var_chaste_interface__ionic_concentrations__Ko + var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__p_k * var_chaste_interface__L_type_Ca_channel_y_gate__y * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__EnsCa = var_membrane__R * var_membrane__T * log((var_chaste_interface__ionic_concentrations__Ko + var_ionic_concentrations__Nao) / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai)) / var_membrane__F; // mV
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // mM
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 1.75e-9; // mm_per_ms
        const double var_non_specific_calcium_activated_current__VnsCa = -var_non_specific_calcium_activated_current__EnsCa + var_chaste_interface__membrane__V; // mV
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-0.75 * var_chaste_interface__ionic_concentrations__Ko + 0.75 * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 8.2799999999999993e-5; // mS_per_mm2
        const double var_sodium_potassium_pump__I_NaK = 0.012999999999999999; // uA_per_mm2
        const double var_sodium_potassium_pump__K_mKo = 1.5; // mM
        const double var_sodium_potassium_pump__K_mNai = 10.0; // mM
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__ionic_concentrations__Nai), 1.5)) * (var_chaste_interface__ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // uA_per_mm2
        const double var_time_dependent_potassium_current__P_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // mV
        const double var_time_dependent_potassium_current__g_K_max = 0.0011280000000000001; // mS_per_mm2
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_dependent_potassium_current__g_K_max; // mS_per_mm2
        const double var_time_dependent_potassium_current_Xi_gate__Xi = 1 / (1.0 + exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2) * (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_time_dependent_potassium_current_Xi_gate__Xi; // uA_per_mm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(var_chaste_interface__ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // mV
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // mV
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // uA_per_mm2
        const double var_time_independent_potassium_current__g_K1_max = 0.0074999999999999997; // mS_per_mm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_independent_potassium_current__g_K1_max; // mS_per_mm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // uA_per_mm2
        const double d_dt_chaste_interface_var_ionic_concentrations__Ki = (-var_L_type_Ca_channel__i_Ca_L_K - var_non_specific_calcium_activated_current__i_ns_K - var_plateau_potassium_current__i_Kp - var_time_dependent_potassium_current__i_K - var_time_independent_potassium_current__i_K1 + 2.0 * var_sodium_potassium_pump__i_NaK) * var_calcium_subsystem__Am / (var_calcium_subsystem__V_myo * var_membrane__F); // mM / ms

        return d_dt_chaste_interface_var_ionic_concentrations__Ki;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative29(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            double var_chaste_interface__L_type_Ca_channel__O = rY[4];
            // Units: dimensionless; Initial value: 9.84546e-21
            double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
            // Units: dimensionless; Initial value: 0.998983
            double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
            // Units: dimensionless; Initial value: 0.000928836
            double var_chaste_interface__calcium_subsystem__Cai = rY[18];
            // Units: mM; Initial value: 9.94893e-11
            double var_chaste_interface__ionic_concentrations__Nai = rY[28];
            // Units: mM; Initial value: 10.2042
            double var_chaste_interface__ionic_concentrations__Ki = rY[29];
            // Units: mM; Initial value: 143.727
            double var_chaste_interface__ionic_concentrations__Ko = rY[30];
            // Units: mM; Initial value: 5.4
            
            const double var_x0 = exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V);
            const double var_x1 = 1.0 + var_x0;
            const double var_x2 = 1 / var_x1;
            const double var_x10 = sqrt(var_chaste_interface__ionic_concentrations__Ko);
            const double var_x11 = 1 / var_chaste_interface__ionic_concentrations__Ki;
            const double var_x12 = log(var_x11 * var_chaste_interface__ionic_concentrations__Ko);
            const double var_x13 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 6.3475921059424856 * var_x12);
            const double var_x14 = 1.0 + var_x13;
            const double var_x15 = 1 / var_x14;
            const double var_x16 = exp(-2.4444678999999998 + 13.687910356755641 * var_x12 - 0.51429999999999998 * var_chaste_interface__membrane__V);
            const double var_x17 = 1.0 + var_x16;
            const double var_x18 = 1 / var_x17;
            const double var_x19 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 2.1376880417161446 * var_x12);
            const double var_x20 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 1.6434541406371006 * var_x12);
            const double var_x21 = var_x20 + 0.49124000000000001 * var_x19;
            const double var_x22 = var_x18 * var_x21;
            const double var_x23 = 1 / (var_x22 + 1.02 * var_x15);
            const double var_x24 = var_x15 * var_x23;
            const double var_x25 = var_x10 * var_x24;
            const double var_x26 = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2);
            const double var_x27 = exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V);
            const double var_x28 = 1.0 + var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x30 = var_x10 * var_x29;
            const double var_x31 = var_x26 * var_x30;
            const double var_x34 = 0.037573302761014088 * var_chaste_interface__membrane__V;
            const double var_x35 = 1 / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai);
            const double var_x36 = 140.0 + var_chaste_interface__ionic_concentrations__Ko;
            const double var_x37 = log(var_x35 * var_x36);
            const double var_x38 = exp(var_x34 - 1.0 * var_x37);
            const double var_x39 = 0.75 * var_x38;
            const double var_x42 = pow(var_chaste_interface__calcium_subsystem__Cai, 3);
            const double var_x43 = 1.0 + 1.7279999999999996e-9 / var_x42;
            const double var_x44 = 1 / var_x43;
            const double var_x45 = -1.0 + var_x38;
            const double var_x46 = 1 / var_x45;
            const double var_x47 = var_x44 * var_x46;
            const double var_x49 = var_x39 * var_chaste_interface__ionic_concentrations__Ki;
            const double var_x50 = var_x49 - 0.75 * var_chaste_interface__ionic_concentrations__Ko;
            const double var_x51 = -26.614641953637257 * var_x12 + var_chaste_interface__membrane__V;
            const double var_x57 = var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca;
            const double var_x58 = exp(0.075146605522028176 * var_chaste_interface__membrane__V);
            const double var_x59 = -1.0 + var_x58;
            const double var_x60 = 1 / var_x59;
            const double var_x61 = -0.61380000000000001 + 0.001 * var_x58;
            const double var_x62 = var_x60 * var_x61;
            const double var_x64 = var_x10 * var_x51;
            const double var_x65 = var_x13 / pow(var_x14, 2);
            const double var_x66 = var_x23 * var_x65;
            const double var_x67 = var_x64 * var_x66;
            const double var_x68 = 1 / (0.018329999999999999 * var_chaste_interface__ionic_concentrations__Nai + var_chaste_interface__ionic_concentrations__Ki);
            const double var_x73 = -26.614641953637257 * var_x37 + var_chaste_interface__membrane__V;
            const double var_x74 = var_x38 * var_x73;
            const double var_x75 = var_x44 * var_x74 / pow(var_x45, 2);
            const double var_x77 = var_x16 * var_x21 / pow(var_x17, 2);
            const double var_x79 = var_x15 * var_x64 / pow((var_x15 + 0.98039215686274506 * var_x22), 2);
            const double var_x91 = var_x57 * var_chaste_interface__L_type_Ca_channel_y_gate__y;
            const double var_x92 = var_x62 * var_chaste_interface__membrane__V;
            const double var_x93 = 1 / (1.0 - 107.25680748803607 * var_x92);
            const double var_x94 = exp(var_x34);
            const double var_x95 = -1.0 + var_x94;
            const double var_x96 = 1 / var_x95;
            const double var_x108 = var_x91 * var_x93 * var_chaste_interface__membrane__V;
            const double var_x110 = var_x108 * var_x96;
            const double var_x132 = var_x31 * var_x68;
            const double var_x144 = var_x39 + var_x35 * var_x49;
            const double var_x145 = var_x11 * var_x25;
            const double var_x146 = 1.0501178736126389 * var_x19;
            const double var_x147 = 1.6434541406371006 * var_x20;
            const double var_x148 = 6.4745439480613349 * var_x65;
            const double var_x149 = 13.687910356755641 * var_x77;
            const double var_x150 = var_x11 * var_x148 - var_x11 * var_x149 - var_x18 * (var_x11 * var_x146 + var_x11 * var_x147);
            const double var_x151 = var_x11 * var_x67;
            const double var_x291 = 3.9072457120905308e-8 * var_x47;
            const double var_x296 = var_x291 * var_x73;
            const double var_x297 = 1.0398994565217392e-6 * var_x47;
            const double var_x298 = 3.9072457120905308e-8 * var_x75;
            const double var_x313 = 1.9415130354461213e-5 * var_x79;
            const double var_x328 = var_x297 * var_x50;
            const double var_x329 = var_x328 * var_x35;
            const double var_x330 = var_x298 * var_x50;
            const double var_x331 = var_x330 * var_x35;
            const double var_x332 = var_x331 - var_x329;
            const double var_x333 = 1.3521568226207399e-5 * var_x2;
            const double var_x334 = var_x11 * var_x333;
            const double var_x335 = 7.9270016169768288e-5 * var_x132;
            const double var_x336 = var_x144 * var_x296;
            const double var_x337 = 0.0005376025032790136 * var_x145;
            const double var_x338 = var_x150 * var_x313;
            const double var_x339 = 0.00012821819703204474 * var_x151;
            const double var_x340 = 2.2327118354803037e-8 * var_x110;
            const double var_x341 = var_x340 * var_x94;
            
            partialF = var_x332 + var_x339 - var_x334 - var_x335 - var_x336 - var_x337 - var_x338 - var_x341;
        }
        else
        {
            const double y_save = rY[29];
            rY[29] += delta;
            const double temp = EvaluateYDerivative29(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[29])/delta;
            rY[29] = y_save;
        }
        return partialF;
    }
    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluateYDerivative30(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -84.1638
        double var_chaste_interface__L_type_Ca_channel__O = rY[4];
        // Units: dimensionless; Initial value: 9.84546e-21
        double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
        // Units: dimensionless; Initial value: 0.998983
        double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
        // Units: dimensionless; Initial value: 0.000928836
        double var_chaste_interface__calcium_subsystem__Cai = rY[18];
        // Units: mM; Initial value: 9.94893e-11
        double var_chaste_interface__ionic_concentrations__Nai = rY[28];
        // Units: mM; Initial value: 10.2042
        double var_chaste_interface__ionic_concentrations__Ki = rY[29];
        // Units: mM; Initial value: 143.727
        double var_chaste_interface__ionic_concentrations__Ko = rY[30];
        // Units: mM; Initial value: 5.4
        
        
        // Mathematics
        const double var_L_type_Ca_channel__P_Ca = 3.375e-5; // mm_per_ms
        const double var_L_type_Ca_channel__P_K = 1.0000000000000001e-9; // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_Ca_half = -0.0045799999999999999; // uA_per_mm2
        const double var_calcium_subsystem__Am = 546.69000000000005; // per_mm
        const double var_calcium_subsystem__V_myo = 0.92000000000000004; // dimensionless
        const double var_ionic_concentrations__Cao = 1.8; // mM
        const double var_ionic_concentrations__Nao = 140.0; // mM
        const double var_membrane__F = 96845.0; // faradays_constant_units
        const double var_membrane__R = 8314.5; // gas_constant_units
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel__i_Ca_L_Ca_max = 4.0 * pow(var_membrane__F, 2) * (0.001 * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - 0.34100000000000003 * var_ionic_concentrations__Cao) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_L_type_Ca_channel__p_k = var_L_type_Ca_channel__P_K / (1.0 + var_L_type_Ca_channel__i_Ca_L_Ca_max / var_L_type_Ca_channel__i_Ca_L_Ca_half); // mm_per_ms
        const double var_L_type_Ca_channel__i_Ca_L_K = pow(var_membrane__F, 2) * (-var_chaste_interface__ionic_concentrations__Ko + var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca) * var_L_type_Ca_channel__p_k * var_chaste_interface__L_type_Ca_channel_y_gate__y * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__EnsCa = var_membrane__R * var_membrane__T * log((var_chaste_interface__ionic_concentrations__Ko + var_ionic_concentrations__Nao) / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai)) / var_membrane__F; // mV
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // mM
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 1.75e-9; // mm_per_ms
        const double var_non_specific_calcium_activated_current__VnsCa = -var_non_specific_calcium_activated_current__EnsCa + var_chaste_interface__membrane__V; // mV
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-0.75 * var_chaste_interface__ionic_concentrations__Ko + 0.75 * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_non_specific_calcium_activated_current__P_ns_Ca * var_non_specific_calcium_activated_current__VnsCa / ((-1.0 + exp(var_membrane__F * var_non_specific_calcium_activated_current__VnsCa / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // uA_per_mm2
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_subsystem__Cai, 3)); // uA_per_mm2
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 8.2799999999999993e-5; // mS_per_mm2
        const double var_sodium_potassium_pump__I_NaK = 0.012999999999999999; // uA_per_mm2
        const double var_sodium_potassium_pump__K_mKo = 1.5; // mM
        const double var_sodium_potassium_pump__K_mNai = 10.0; // mM
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_chaste_interface__ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow((var_sodium_potassium_pump__K_mNai / var_chaste_interface__ionic_concentrations__Nai), 1.5)) * (var_chaste_interface__ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // uA_per_mm2
        const double var_time_dependent_potassium_current__P_NaK = 0.018329999999999999; // dimensionless
        const double var_time_dependent_potassium_current__E_K = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_time_dependent_potassium_current__P_NaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // mV
        const double var_time_dependent_potassium_current__g_K_max = 0.0011280000000000001; // mS_per_mm2
        const double var_time_dependent_potassium_current__g_K = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_dependent_potassium_current__g_K_max; // mS_per_mm2
        const double var_time_dependent_potassium_current_Xi_gate__Xi = 1 / (1.0 + exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_time_dependent_potassium_current__i_K = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2) * (-var_time_dependent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_dependent_potassium_current__g_K * var_time_dependent_potassium_current_Xi_gate__Xi; // uA_per_mm2
        const double var_time_independent_potassium_current__E_K1 = var_membrane__R * var_membrane__T * log(var_chaste_interface__ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // mV
        const double var_plateau_potassium_current__E_Kp = var_time_independent_potassium_current__E_K1; // mV
        const double var_plateau_potassium_current__i_Kp = (-var_plateau_potassium_current__E_Kp + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // uA_per_mm2
        const double var_time_independent_potassium_current__g_K1_max = 0.0074999999999999997; // mS_per_mm2
        const double var_time_independent_potassium_current__g_K1 = 0.43033148291193518 * sqrt(var_chaste_interface__ionic_concentrations__Ko) * var_time_independent_potassium_current__g_K1_max; // mS_per_mm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K1)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K1) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K1)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K1 - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_ms
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K1 + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // uA_per_mm2
        const double d_dt_chaste_interface_var_ionic_concentrations__Ko = (-2.0 * var_sodium_potassium_pump__i_NaK + var_L_type_Ca_channel__i_Ca_L_K + var_non_specific_calcium_activated_current__i_ns_K + var_plateau_potassium_current__i_Kp + var_time_dependent_potassium_current__i_K + var_time_independent_potassium_current__i_K1) * var_calcium_subsystem__Am / (var_calcium_subsystem__V_myo * var_membrane__F); // mM / ms

        return d_dt_chaste_interface_var_ionic_concentrations__Ko;
    }

    double Celljafri_rice_winslow_model_1998FromCellMLGRL2::EvaluatePartialDerivative30(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -84.1638
            double var_chaste_interface__L_type_Ca_channel__O = rY[4];
            // Units: dimensionless; Initial value: 9.84546e-21
            double var_chaste_interface__L_type_Ca_channel__O_Ca = rY[5];
            // Units: dimensionless; Initial value: 0.0
            double var_chaste_interface__L_type_Ca_channel_y_gate__y = rY[16];
            // Units: dimensionless; Initial value: 0.998983
            double var_chaste_interface__time_dependent_potassium_current_X_gate__X = rY[17];
            // Units: dimensionless; Initial value: 0.000928836
            double var_chaste_interface__calcium_subsystem__Cai = rY[18];
            // Units: mM; Initial value: 9.94893e-11
            double var_chaste_interface__ionic_concentrations__Nai = rY[28];
            // Units: mM; Initial value: 10.2042
            double var_chaste_interface__ionic_concentrations__Ki = rY[29];
            // Units: mM; Initial value: 143.727
            double var_chaste_interface__ionic_concentrations__Ko = rY[30];
            // Units: mM; Initial value: 5.4
            
            const double var_x0 = exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V);
            const double var_x1 = 1.0 + var_x0;
            const double var_x2 = 1 / var_x1;
            const double var_x10 = sqrt(var_chaste_interface__ionic_concentrations__Ko);
            const double var_x11 = 1 / var_chaste_interface__ionic_concentrations__Ki;
            const double var_x12 = log(var_x11 * var_chaste_interface__ionic_concentrations__Ko);
            const double var_x13 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 6.3475921059424856 * var_x12);
            const double var_x14 = 1.0 + var_x13;
            const double var_x15 = 1 / var_x14;
            const double var_x16 = exp(-2.4444678999999998 + 13.687910356755641 * var_x12 - 0.51429999999999998 * var_chaste_interface__membrane__V);
            const double var_x17 = 1.0 + var_x16;
            const double var_x18 = 1 / var_x17;
            const double var_x19 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 2.1376880417161446 * var_x12);
            const double var_x20 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 1.6434541406371006 * var_x12);
            const double var_x21 = var_x20 + 0.49124000000000001 * var_x19;
            const double var_x22 = var_x18 * var_x21;
            const double var_x23 = 1 / (var_x22 + 1.02 * var_x15);
            const double var_x24 = var_x15 * var_x23;
            const double var_x26 = pow(var_chaste_interface__time_dependent_potassium_current_X_gate__X, 2);
            const double var_x27 = exp(-1.7526479750778814 + 0.031152647975077882 * var_chaste_interface__membrane__V);
            const double var_x28 = 1.0 + var_x27;
            const double var_x29 = 1 / var_x28;
            const double var_x30 = var_x10 * var_x29;
            const double var_x31 = var_x26 * var_x30;
            const double var_x34 = 0.037573302761014088 * var_chaste_interface__membrane__V;
            const double var_x35 = 1 / (var_chaste_interface__ionic_concentrations__Ki + var_chaste_interface__ionic_concentrations__Nai);
            const double var_x36 = 140.0 + var_chaste_interface__ionic_concentrations__Ko;
            const double var_x37 = log(var_x35 * var_x36);
            const double var_x38 = exp(var_x34 - 1.0 * var_x37);
            const double var_x39 = 0.75 * var_x38;
            const double var_x42 = pow(var_chaste_interface__calcium_subsystem__Cai, 3);
            const double var_x43 = 1.0 + 1.7279999999999996e-9 / var_x42;
            const double var_x44 = 1 / var_x43;
            const double var_x45 = -1.0 + var_x38;
            const double var_x46 = 1 / var_x45;
            const double var_x47 = var_x44 * var_x46;
            const double var_x49 = var_x39 * var_chaste_interface__ionic_concentrations__Ki;
            const double var_x50 = var_x49 - 0.75 * var_chaste_interface__ionic_concentrations__Ko;
            const double var_x51 = -26.614641953637257 * var_x12 + var_chaste_interface__membrane__V;
            const double var_x57 = var_chaste_interface__L_type_Ca_channel__O + var_chaste_interface__L_type_Ca_channel__O_Ca;
            const double var_x58 = exp(0.075146605522028176 * var_chaste_interface__membrane__V);
            const double var_x59 = -1.0 + var_x58;
            const double var_x60 = 1 / var_x59;
            const double var_x61 = -0.61380000000000001 + 0.001 * var_x58;
            const double var_x62 = var_x60 * var_x61;
            const double var_x64 = var_x10 * var_x51;
            const double var_x65 = var_x13 / pow(var_x14, 2);
            const double var_x66 = var_x23 * var_x65;
            const double var_x68 = 1 / (0.018329999999999999 * var_chaste_interface__ionic_concentrations__Nai + var_chaste_interface__ionic_concentrations__Ki);
            const double var_x69 = 2.5661999999999998 + var_chaste_interface__ionic_concentrations__Ko;
            const double var_x70 = -26.614641953637257 * log(var_x68 * var_x69) + var_chaste_interface__membrane__V;
            const double var_x71 = var_x26 * var_x70;
            const double var_x73 = -26.614641953637257 * var_x37 + var_chaste_interface__membrane__V;
            const double var_x74 = var_x38 * var_x73;
            const double var_x75 = var_x44 * var_x74 / pow(var_x45, 2);
            const double var_x77 = var_x16 * var_x21 / pow(var_x17, 2);
            const double var_x79 = var_x15 * var_x64 / pow((var_x15 + 0.98039215686274506 * var_x22), 2);
            const double var_x81 = 1 / var_chaste_interface__ionic_concentrations__Nai;
            const double var_x82 = pow(var_x81, 1.5);
            const double var_x83 = 1 / (1.0 + 31.622776601683793 * var_x82);
            const double var_x84 = exp(-0.0037573302761014088 * var_chaste_interface__membrane__V);
            const double var_x85 = exp(2.0802377414561666);
            const double var_x86 = exp(-var_x34);
            const double var_x87 = 1.0 + 0.1245 * var_x84 + 0.036499999999999998 * var_x86 * (-0.14285714285714285 + 0.14285714285714285 * var_x85);
            const double var_x88 = 1 / (1.5 + var_chaste_interface__ionic_concentrations__Ko);
            const double var_x91 = var_x57 * var_chaste_interface__L_type_Ca_channel_y_gate__y;
            const double var_x92 = var_x62 * var_chaste_interface__membrane__V;
            const double var_x93 = 1 / (1.0 - 107.25680748803607 * var_x92);
            const double var_x94 = exp(var_x34);
            const double var_x95 = -1.0 + var_x94;
            const double var_x96 = 1 / var_x95;
            const double var_x108 = var_x91 * var_x93 * var_chaste_interface__membrane__V;
            const double var_x110 = var_x108 * var_x96;
            const double var_x135 = 1 / var_x87;
            const double var_x146 = 1.0501178736126389 * var_x19;
            const double var_x147 = 1.6434541406371006 * var_x20;
            const double var_x148 = 6.4745439480613349 * var_x65;
            const double var_x149 = 13.687910356755641 * var_x77;
            const double var_x153 = 1 / var_chaste_interface__ionic_concentrations__Ko;
            const double var_x154 = 1 / var_x10;
            const double var_x155 = var_x154 * var_x24;
            const double var_x156 = var_x135 * var_x83;
            const double var_x157 = var_x156 * var_x88;
            const double var_x158 = var_x31 / var_x69;
            const double var_x159 = var_x156 * var_chaste_interface__ionic_concentrations__Ko / pow((1 + 0.66666666666666663 * var_chaste_interface__ionic_concentrations__Ko), 2);
            const double var_x160 = 1 / var_x36;
            const double var_x162 = var_x155 * var_x51;
            const double var_x163 = var_x154 * var_x29 * var_x71;
            const double var_x164 = -0.75 - var_x160 * var_x49;
            const double var_x165 = var_x154 * var_x51 * var_x66;
            const double var_x166 = var_x149 * var_x153 - var_x148 * var_x153 - var_x18 * (-var_x146 * var_x153 - var_x147 * var_x153);
            const double var_x291 = 3.9072457120905308e-8 * var_x47;
            const double var_x296 = var_x291 * var_x73;
            const double var_x297 = 1.0398994565217392e-6 * var_x47;
            const double var_x298 = 3.9072457120905308e-8 * var_x75;
            const double var_x313 = 1.9415130354461213e-5 * var_x79;
            const double var_x328 = var_x297 * var_x50;
            const double var_x330 = var_x298 * var_x50;
            const double var_x333 = 1.3521568226207399e-5 * var_x2;
            const double var_x340 = 2.2327118354803037e-8 * var_x110;
            const double var_x342 = var_x153 * var_x333;
            const double var_x343 = 0.00015953260140026533 * var_x157;
            const double var_x344 = 0.0005376025032790136 * var_x155;
            const double var_x345 = var_x160 * var_x328;
            const double var_x346 = 7.9270016169768288e-5 * var_x158;
            const double var_x347 = 1.0099750810390723e-5 * var_x162;
            const double var_x348 = var_x164 * var_x296;
            const double var_x349 = 7.090337840011793e-5 * var_x159;
            const double var_x350 = 1.4892181587085931e-6 * var_x163;
            const double var_x351 = 0.00012821819703204474 * var_x165;
            const double var_x352 = var_x166 * var_x313;
            const double var_x353 = var_x160 * var_x330;
            
            partialF = var_x347 + var_x348 + var_x349 + var_x350 + var_x351 + var_x352 + var_x353 - var_x340 - var_x342 - var_x343 - var_x344 - var_x345 - var_x346;
        }
        else
        {
            const double y_save = rY[30];
            rY[30] += delta;
            const double temp = EvaluateYDerivative30(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[30])/delta;
            rY[30] = y_save;
        }
        return partialF;
    }

    std::vector<double> Celljafri_rice_winslow_model_1998FromCellMLGRL2::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__I_stim_converted = -GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_membrane__I_stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celljafri_rice_winslow_model_1998FromCellMLGRL2>::Initialise(void)
{
    this->mSystemName = "jafri_rice_winslow_1998";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-84.1638);

    // rY[1]:
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0328302);

    // rY[2]:
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.988354);

    // rY[3]:
    this->mVariableNames.push_back("fast_sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99254);

    // rY[4]:
    this->mVariableNames.push_back("L_type_Ca_channel__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.84546e-21);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel__O_Ca");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel__C0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.997208);

    // rY[7]:
    this->mVariableNames.push_back("L_type_Ca_channel__C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.38897e-05);

    // rY[8]:
    this->mVariableNames.push_back("L_type_Ca_channel__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.535e-09);

    // rY[9]:
    this->mVariableNames.push_back("L_type_Ca_channel__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.63909e-14);

    // rY[10]:
    this->mVariableNames.push_back("L_type_Ca_channel__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.56337e-20);

    // rY[11]:
    this->mVariableNames.push_back("L_type_Ca_channel__C_Ca0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00272826);

    // rY[12]:
    this->mVariableNames.push_back("L_type_Ca_channel__C_Ca1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.99215e-07);

    // rY[13]:
    this->mVariableNames.push_back("L_type_Ca_channel__C_Ca2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.71989e-11);

    // rY[14]:
    this->mVariableNames.push_back("L_type_Ca_channel__C_Ca3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.87031e-15);

    // rY[15]:
    this->mVariableNames.push_back("L_type_Ca_channel__C_Ca4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(4.59752e-20);

    // rY[16]:
    this->mVariableNames.push_back("L_type_Ca_channel_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.998983);

    // rY[17]:
    this->mVariableNames.push_back("time_dependent_potassium_current_X_gate__X");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000928836);

    // rY[18]:
    this->mVariableNames.push_back("calcium_subsystem__Cai");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(9.94893e-11);

    // rY[19]:
    this->mVariableNames.push_back("calcium_subsystem__Ca_SS");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.000136058);

    // rY[20]:
    this->mVariableNames.push_back("calcium_subsystem__P_O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00119168);

    // rY[21]:
    this->mVariableNames.push_back("calcium_subsystem__P_O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6.30613e-09);

    // rY[22]:
    this->mVariableNames.push_back("calcium_subsystem__P_C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.762527);

    // rY[23]:
    this->mVariableNames.push_back("calcium_subsystem__P_C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.236283);

    // rY[24]:
    this->mVariableNames.push_back("calcium_subsystem__Ca_JSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.17504);

    // rY[25]:
    this->mVariableNames.push_back("calcium_subsystem__Ca_NSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(1.243891);

    // rY[26]:
    this->mVariableNames.push_back("calcium_subsystem__HTRPNCa");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.13598);

    // rY[27]:
    this->mVariableNames.push_back("calcium_subsystem__LTRPNCa");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.00635);

    // rY[28]:
    this->mVariableNames.push_back("ionic_concentrations__Nai");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(10.2042);

    // rY[29]:
    this->mVariableNames.push_back("ionic_concentrations__Ki");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(143.727);

    // rY[30]:
    this->mVariableNames.push_back("ionic_concentrations__Ko");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(5.4);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.0001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celljafri_rice_winslow_model_1998FromCellMLGRL2)
