//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: iyer_model_2004
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "iyer_model_2004.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"


    Celliyer_model_2004FromCellMLGRL2::Celliyer_model_2004FromCellMLGRL2(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                67,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celliyer_model_2004FromCellMLGRL2>::Instance();
        Init();
        
    }

    Celliyer_model_2004FromCellMLGRL2::~Celliyer_model_2004FromCellMLGRL2()
    {
    }
    
    double Celliyer_model_2004FromCellMLGRL2::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rY[1];
        // Units: mM; Initial value: 9.798304162
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = rY[2];
        // Units: mM; Initial value: 125.5589432
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
        // Units: mM; Initial value: 8.601192016e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
        // Units: dimensionless; Initial value: 7.757981563e-12
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
        // Units: dimensionless; Initial value: 0.9997157074
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rY[29];
        // Units: dimensionless; Initial value: 2.29955624e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
        // Units: dimensionless; Initial value: 1.975541357e-05
        double var_chaste_interface__INa__na6 = rY[50];
        // Units: dimensionless; Initial value: 1.57442749e-08
        double var_chaste_interface__INa__na7 = rY[51];
        // Units: dimensionless; Initial value: 2.856607179e-09
        double var_chaste_interface__IKr__OHerg = rY[61];
        // Units: dimensionless; Initial value: 9.511789113e-06
        double var_chaste_interface__IKs__O1ks = rY[65];
        // Units: dimensionless; Initial value: 2.491710696e-07
        double var_chaste_interface__IKs__O2ks = rY[66];
        // Units: dimensionless; Initial value: 1.298547822e-05
        
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao = 2.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko = 4.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao = 138.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp = 310.0; // kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_COMPUTE_ICa_ICaK__ICahalf = -0.26500000000000001; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Pscale = 7.0; // dimensionless
        const double var_COMPUTE_ICa_ICaK__PCa = 0.00024689999999999998 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__PK = 4.5740000000000001e-7 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_ICa_ICaK__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_ICa_ICaK__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_ICa_ICaK__a1_Ca = 0.001 * exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT) - 0.34100000000000003 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao; // mM
        const double var_COMPUTE_ICa_ICaK__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // mM
        const double var_COMPUTE_ICa_ICaK__a2_Ca = -1.0 + exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICamax = 4.0 * var_COMPUTE_ICa_ICaK__PCa * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_Ca / var_COMPUTE_ICa_ICaK__a2_Ca; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__ICa = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__ICamax; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Icabar = ((var_COMPUTE_ICa_ICaK__ICamax >= 0) ? (0) : (var_COMPUTE_ICa_ICaK__ICamax)); // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__PKprime = var_COMPUTE_ICa_ICaK__PK / (1.0 + var_COMPUTE_ICa_ICaK__Icabar / var_COMPUTE_ICa_ICaK__ICahalf); // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__a2_K = -1.0 + exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICaK = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__PKprime * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_K / var_COMPUTE_ICa_ICaK__a2_K; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab = 7.6840000000000003e-5; // mS_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax = 2.387; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax = 0.050000000000000003; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa = 1.3799999999999999; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo = 1.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa = 87.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai = 20.0; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax / (var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na = 1.0 + 0.1245 * exp(-0.10000000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K = 1.0 + pow((var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai), 1.5); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx = 0.00020000000000000001 * pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) + 0.00020000000000000001 * pow(var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa, 3); // mM3
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__eta = 0.34999999999999998; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 3) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao * exp(var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT * var_COMPUTE_INaK_INaCa_ICab_IpCa__eta); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx = pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa = 0.44; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat = 0.20000000000000001; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx = 1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa = (-var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx + var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx) * var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na = 0.036499999999999998 * var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma * exp(-1.3300000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK = 1 / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na + var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK = var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax * var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K * var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK / var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 = 0.12530512611880798; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr = 0.018599999999999998; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs = 0.0035000000000000001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa = 56.32; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab = 0.001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac = 0.88900000000000001; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale = 0.872; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43 = 0.10000000000000001 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 = 4.2986000000000001e-7 * (1.0 - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // litre_per_farad_second
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2 = -1.0 + exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na = 0.02 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14 = var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo = 0.5 * sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko); // dimensionless
        const double var_COMPUTE_REVERSAL_POTENTIALS__ECa = 0.5 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai); // mV
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab = (-var_COMPUTE_REVERSAL_POTENTIALS__ECa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__EK = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43 = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Ito1 = var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14 + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf = 1 / (0.93999999999999995 + exp(1.26 * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F)); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 = sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko) * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__ENa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo * var_chaste_interface__IKr__OHerg; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__IKs__O1ks + var_chaste_interface__IKs__O2ks) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__INa__na6 + var_chaste_interface__INa__na7) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa; // uA_per_uF
        const double var_I_stimulus__i_Stim = 0.0; // uA_per_uF
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__i_tot = var_COMPUTE_ICa_ICaK__ICa + var_COMPUTE_ICa_ICaK__ICaK + var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab + var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa + var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK + var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Ito1 + var_I_stimulus__i_Stim; // uA_per_uF
        const double var_chaste_interface__i_ionic = HeartConfig::Instance()->GetCapacitance() * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__i_tot; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celliyer_model_2004FromCellMLGRL2::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rY[1];
        // Units: mM; Initial value: 9.798304162
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = rY[2];
        // Units: mM; Initial value: 125.5589432
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
        // Units: mM; Initial value: 8.601192016e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
        // Units: dimensionless; Initial value: 7.757981563e-12
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
        // Units: dimensionless; Initial value: 0.9997157074
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rY[29];
        // Units: dimensionless; Initial value: 2.29955624e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
        // Units: dimensionless; Initial value: 1.975541357e-05
        double var_chaste_interface__INa__na6 = rY[50];
        // Units: dimensionless; Initial value: 1.57442749e-08
        double var_chaste_interface__INa__na7 = rY[51];
        // Units: dimensionless; Initial value: 2.856607179e-09
        double var_chaste_interface__IKr__OHerg = rY[61];
        // Units: dimensionless; Initial value: 9.511789113e-06
        double var_chaste_interface__IKs__O1ks = rY[65];
        // Units: dimensionless; Initial value: 2.491710696e-07
        double var_chaste_interface__IKs__O2ks = rY[66];
        // Units: dimensionless; Initial value: 1.298547822e-05
        

        // Mathematics
        double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao = 2.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko = 4.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao = 138.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp = 310.0; // kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_COMPUTE_ICa_ICaK__ICahalf = -0.26500000000000001; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Pscale = 7.0; // dimensionless
        const double var_COMPUTE_ICa_ICaK__PCa = 0.00024689999999999998 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__PK = 4.5740000000000001e-7 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_ICa_ICaK__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_ICa_ICaK__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_ICa_ICaK__a1_Ca = 0.001 * exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT) - 0.34100000000000003 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao; // mM
        const double var_COMPUTE_ICa_ICaK__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // mM
        const double var_COMPUTE_ICa_ICaK__a2_Ca = -1.0 + exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICamax = 4.0 * var_COMPUTE_ICa_ICaK__PCa * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_Ca / var_COMPUTE_ICa_ICaK__a2_Ca; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__ICa = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__ICamax; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Icabar = ((var_COMPUTE_ICa_ICaK__ICamax >= 0) ? (0) : (var_COMPUTE_ICa_ICaK__ICamax)); // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__PKprime = var_COMPUTE_ICa_ICaK__PK / (1.0 + var_COMPUTE_ICa_ICaK__Icabar / var_COMPUTE_ICa_ICaK__ICahalf); // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__a2_K = -1.0 + exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICaK = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__PKprime * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_K / var_COMPUTE_ICa_ICaK__a2_K; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab = 7.6840000000000003e-5; // mS_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax = 2.387; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax = 0.050000000000000003; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa = 1.3799999999999999; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo = 1.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa = 87.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai = 20.0; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax / (var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na = 1.0 + 0.1245 * exp(-0.10000000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K = 1.0 + pow((var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai), 1.5); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx = 0.00020000000000000001 * pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) + 0.00020000000000000001 * pow(var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa, 3); // mM3
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__eta = 0.34999999999999998; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 3) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao * exp(var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT * var_COMPUTE_INaK_INaCa_ICab_IpCa__eta); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx = pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa = 0.44; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat = 0.20000000000000001; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx = 1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa = (-var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx + var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx) * var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na = 0.036499999999999998 * var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma * exp(-1.3300000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK = 1 / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na + var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK = var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax * var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K * var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK / var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 = 0.12530512611880798; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr = 0.018599999999999998; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs = 0.0035000000000000001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa = 56.32; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab = 0.001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac = 0.88900000000000001; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale = 0.872; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43 = 0.10000000000000001 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 = 4.2986000000000001e-7 * (1.0 - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // litre_per_farad_second
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2 = -1.0 + exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na = 0.02 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14 = var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo = 0.5 * sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko); // dimensionless
        const double var_COMPUTE_REVERSAL_POTENTIALS__ECa = 0.5 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai); // mV
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab = (-var_COMPUTE_REVERSAL_POTENTIALS__ECa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__EK = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43 = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Ito1 = var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14 + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf = 1 / (0.93999999999999995 + exp(1.26 * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F)); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 = sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko) * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__ENa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo * var_chaste_interface__IKr__OHerg; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__IKs__O1ks + var_chaste_interface__IKs__O2ks) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__INa__na6 + var_chaste_interface__INa__na7) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa; // uA_per_uF
        const double var_I_stimulus__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_I_stimulus__i_Stim = var_I_stimulus__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__i_tot = var_COMPUTE_ICa_ICaK__ICa + var_COMPUTE_ICa_ICaK__ICaK + var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab + var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa + var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK + var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Ito1 + var_I_stimulus__i_Stim; // uA_per_uF
        d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__i_tot; // mV / ms

        double evalF = d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
        mEvalF[0] = d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Celliyer_model_2004FromCellMLGRL2::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rY[1];
        // Units: mM; Initial value: 9.798304162
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = rY[2];
        // Units: mM; Initial value: 125.5589432
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
        // Units: mM; Initial value: 8.601192016e-05
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR = rY[5];
        // Units: mM; Initial value: 0.2852239446
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR = rY[6];
        // Units: mM; Initial value: 0.2855294915
        double var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa = rY[7];
        // Units: dimensionless; Initial value: 0.08046584973
        double var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa = rY[8];
        // Units: dimensionless; Initial value: 0.9772152481
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR = rY[9];
        // Units: dimensionless; Initial value: 0.4448038946
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR = rY[10];
        // Units: dimensionless; Initial value: 3.97392006e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR = rY[11];
        // Units: dimensionless; Initial value: 0.554535924
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = rY[12];
        // Units: dimensionless; Initial value: 0.0006601783287
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 = rY[13];
        // Units: dimensionless; Initial value: 0.8621934054
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 = rY[14];
        // Units: dimensionless; Initial value: 0.01141398211
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 = rY[15];
        // Units: dimensionless; Initial value: 5.666325225e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 = rY[16];
        // Units: dimensionless; Initial value: 1.25021357e-07
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 = rY[17];
        // Units: dimensionless; Initial value: 1.034426748e-10
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 = rY[18];
        // Units: dimensionless; Initial value: 0.1198547081
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 = rY[19];
        // Units: dimensionless; Initial value: 0.006346794302
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 = rY[20];
        // Units: dimensionless; Initial value: 0.0001260326488
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 = rY[21];
        // Units: dimensionless; Initial value: 1.112315238e-06
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 = rY[22];
        // Units: dimensionless; Initial value: 3.681315892e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
        // Units: dimensionless; Initial value: 7.757981563e-12
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
        // Units: dimensionless; Initial value: 0.9997157074
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 = rY[25];
        // Units: dimensionless; Initial value: 0.9513721351
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 = rY[26];
        // Units: dimensionless; Initial value: 0.02668288089
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 = rY[27];
        // Units: dimensionless; Initial value: 0.0002806380358
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 = rY[28];
        // Units: dimensionless; Initial value: 1.311837579e-06
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rY[29];
        // Units: dimensionless; Initial value: 2.29955624e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 = rY[30];
        // Units: dimensionless; Initial value: 0.01513025204
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 = rY[31];
        // Units: dimensionless; Initial value: 0.005442964601
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 = rY[32];
        // Units: dimensionless; Initial value: 0.0009918373359
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 = rY[33];
        // Units: dimensionless; Initial value: 9.514386057e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 = rY[34];
        // Units: dimensionless; Initial value: 2.742677382e-06
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 = rY[35];
        // Units: dimensionless; Initial value: 0.5977099765
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 = rY[36];
        // Units: dimensionless; Initial value: 0.1730990528
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 = rY[37];
        // Units: dimensionless; Initial value: 0.01881072386
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 = rY[38];
        // Units: dimensionless; Initial value: 0.000916070135
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
        // Units: dimensionless; Initial value: 1.975541357e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 = rY[40];
        // Units: dimensionless; Initial value: 0.03539084346
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 = rY[41];
        // Units: dimensionless; Initial value: 0.005428824353
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 = rY[42];
        // Units: dimensionless; Initial value: 0.02287858869
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 = rY[43];
        // Units: dimensionless; Initial value: 0.03233800003
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 = rY[44];
        // Units: dimensionless; Initial value: 0.1134082058
        double var_chaste_interface__INa__na1 = rY[45];
        // Units: dimensionless; Initial value: 0.1437575649
        double var_chaste_interface__INa__na2 = rY[46];
        // Units: dimensionless; Initial value: 0.0417776208
        double var_chaste_interface__INa__na3 = rY[47];
        // Units: dimensionless; Initial value: 0.004552898364
        double var_chaste_interface__INa__na4 = rY[48];
        // Units: dimensionless; Initial value: 0.000220520743
        double var_chaste_interface__INa__na5 = rY[49];
        // Units: dimensionless; Initial value: 4.005266484e-06
        double var_chaste_interface__INa__na6 = rY[50];
        // Units: dimensionless; Initial value: 1.57442749e-08
        double var_chaste_interface__INa__na7 = rY[51];
        // Units: dimensionless; Initial value: 2.856607179e-09
        double var_chaste_interface__INa__na8 = rY[52];
        // Units: dimensionless; Initial value: 0.4749950008
        double var_chaste_interface__INa__na9 = rY[53];
        // Units: dimensionless; Initial value: 0.2707214097
        double var_chaste_interface__INa__na10 = rY[54];
        // Units: dimensionless; Initial value: 0.05786120057
        double var_chaste_interface__INa__na11 = rY[55];
        // Units: dimensionless; Initial value: 0.005496292279
        double var_chaste_interface__INa__na12 = rY[56];
        // Units: dimensionless; Initial value: 0.0001957874519
        double var_chaste_interface__INa__na13 = rY[57];
        // Units: dimensionless; Initial value: 0.000417679396
        double var_chaste_interface__IKr__C1Herg = rY[58];
        // Units: dimensionless; Initial value: 0.996697338
        double var_chaste_interface__IKr__C2Herg = rY[59];
        // Units: dimensionless; Initial value: 0.0004340879648
        double var_chaste_interface__IKr__C3Herg = rY[60];
        // Units: dimensionless; Initial value: 7.634099755e-05
        double var_chaste_interface__IKr__OHerg = rY[61];
        // Units: dimensionless; Initial value: 9.511789113e-06
        double var_chaste_interface__IKr__IHerg = rY[62];
        // Units: dimensionless; Initial value: 1.533347007e-06
        double var_chaste_interface__IKs__C0ks = rY[63];
        // Units: dimensionless; Initial value: 0.9645606295
        double var_chaste_interface__IKs__C1ks = rY[64];
        // Units: dimensionless; Initial value: 0.03542613568
        double var_chaste_interface__IKs__O1ks = rY[65];
        // Units: dimensionless; Initial value: 2.491710696e-07
        double var_chaste_interface__IKs__O2ks = rY[66];
        // Units: dimensionless; Initial value: 1.298547822e-05
        
        
        // Mathematics
        double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Acap = 0.00015339999999999999; // cm2
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C = 0.001 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Acap; // mF
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao = 2.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko = 4.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao = 138.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp = 310.0; // kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VJSR = 1.6e-7; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VNSR = 2.0999999999999998e-6; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VSS = 1.2e-9; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo = 2.584e-5; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1 = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo); // F_M_per_coulomb
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a2 = 0.5 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VSS); // F_M_per_coulomb
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14 = 0.0076854803100000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 = 1.8400241455399999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_C1Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C3Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_OKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14 = 0.00305767916; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_C0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14 = 1.00947847105; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_CI1Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_C1Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI0 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_C0Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_CI1Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14 = 1.1710054056700001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_C2Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14 = 0.63902768757999995; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI3Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_C3Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14 = 2.1203537909499999; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_OIKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_OKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_O = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_OKv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_OKv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14 = 0.077933781739999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 = 0.010817483399999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C1Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_C2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_C3Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C0 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C0Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_C0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C1 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_C1Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C1Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_C1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C2 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C2Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_C2Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_C2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C3 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C3Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_C3Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_C3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14 = 2.44936e-6; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_CI0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C0 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_C1Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_CI0Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14 = 0.52465073996; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_CI1Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C1 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C0Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C2Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_CI1Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI1 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_C1Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI0Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI2Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI0 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_CI0Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14 = 17.51885408639; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_CI2Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI1Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C2 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C1Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_CI2Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI2 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_C2Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI1Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI3Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI1 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_CI1Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_CI1Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14 = 938.58764534555996; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_CI3Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_CI2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C3 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_C2Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_CI3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_OKv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI3 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_C3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_CI2Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_OIKv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI2 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_CI2Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI2Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_CI2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14 = 54749.19473332601; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_CI3Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_OIKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_O = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_C3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_OIKv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_OI = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_CI3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_OKv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI3 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_CI3Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI3Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_CI3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_OI = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_OIKv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_OIKv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43 = 0.028982999999999998; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43 = 0.00037301599999999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 = 0.54370799999999997; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_C1Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C3Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_OKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 = 0.049842400000000002; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_C0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43 = 6.7734800000000002; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_CI1Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_C1Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I043 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_C0Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_CI1Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43 = 15.621270515200001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_C2Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43 = 28.753260331300002; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI3Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_C3Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43 = 524.57620667900005; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_OIKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_OKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_O43 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_OKv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_OKv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43 = 0.046843700000000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 = 0.080185000000000006; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C1Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_C2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_C3Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C043 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C0Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_C0Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C143 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_C1Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C1Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_C1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C243 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C2Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_C2Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_C2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C343 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C3Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_C3Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_C3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 = 0.00081948199999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43 = 5.3739999999999997e-8; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_CI0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C043 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_C1Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_CI0Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43 = 1.8935999999999999; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_CI1Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C143 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C0Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C2Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_CI1Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I143 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_C1Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI0Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI2Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I043 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_CI0Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI0Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43 = 14.224647456; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_CI2Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI1Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C243 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C1Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_CI2Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I243 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_C2Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI1Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI3Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I143 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_CI1Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_CI1Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43 = 158.574378389; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_CI3Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_CI2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C343 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_C2Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_CI3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_OKv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I343 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_C3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_CI2Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_OIKv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I243 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_CI2Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI2Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_CI2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43 = 142.93664535100001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_CI3Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_OIKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_O43 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_C3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_OIKv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_OI43 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_CI3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_OKv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I343 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_CI3Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI3Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_CI3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_OI43 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_OIKv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_OIKv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Cainf = 0.81999999999999995; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha = 1.9967999999999999 * exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_C1 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C3 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_CCa1 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa3 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta = 0.088200000000000001 * exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C1 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_C3 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa1 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_CCa3 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__fL = 0.29999999999999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gL = 4.0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_CCa4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C0 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_C1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C1 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C2 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C3 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C4 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_C3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_CCa4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__fL) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca0 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca1 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_CCa1 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa1; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca2 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa2 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa2; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca3 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa3 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_CCa3; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca4 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_CCa4 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa4; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega = 0.0025000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_C4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca0 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_CCa1) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca1 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa2) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca2 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa3) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca3 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa4) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca4 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_C4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_CCa3) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C0 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C0 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C1 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_C1 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C1 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C2 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C2 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C2 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C3 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C3 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_C3 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C4 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C4 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_C4 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__tau_yCa = 1 / (0.0033633620945199998 / (0.5 + exp(-0.18053804430634462 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V)) + 0.0077904657073700001 * exp(-0.02019777813343069 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V)); // ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa_inf = 1.0 - var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Cainf + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Cainf / (1.0 + exp(3.6538461538461537 + 0.12820512820512822 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V)); // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaminus = 0.57599999999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaplus = 0.012149999999999999; // per_uM4_per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbminus = 1.9299999999999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbplus = 0.0040499999999999998; // per_uM3_per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcminus = 0.00080000000000000004; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcplus = 0.10000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC2_RyR = var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcplus - var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcminus; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__mcoop = 3.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO2_RyR = -var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbminus + pow((1000.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS), var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__mcoop) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbplus; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__ncoop = 4.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC1_RyR = var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaminus - pow((1000.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS), var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__ncoop) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaplus; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO1_RyR = -var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC1_RyR - var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC2_RyR - var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO2_RyR; // per_ms
        const double var_COMPUTE_ICa_ICaK__ICahalf = -0.26500000000000001; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Pscale = 7.0; // dimensionless
        const double var_COMPUTE_ICa_ICaK__PCa = 0.00024689999999999998 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__PK = 4.5740000000000001e-7 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_ICa_ICaK__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_ICa_ICaK__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_ICa_ICaK__a1_Ca = 0.001 * exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT) - 0.34100000000000003 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao; // mM
        const double var_COMPUTE_ICa_ICaK__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // mM
        const double var_COMPUTE_ICa_ICaK__a2_Ca = -1.0 + exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICamax = 4.0 * var_COMPUTE_ICa_ICaK__PCa * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_Ca / var_COMPUTE_ICa_ICaK__a2_Ca; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__ICa = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__ICamax; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Icabar = ((var_COMPUTE_ICa_ICaK__ICamax >= 0) ? (0) : (var_COMPUTE_ICa_ICaK__ICamax)); // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__PKprime = var_COMPUTE_ICa_ICaK__PK / (1.0 + var_COMPUTE_ICa_ICaK__Icabar / var_COMPUTE_ICa_ICaK__ICahalf); // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__a2_K = -1.0 + exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICaK = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__PKprime * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_K / var_COMPUTE_ICa_ICaK__a2_K; // uA_per_uF
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__KSR = 1.2; // mM
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Kfb = 0.00016799999999999999; // mM
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Krb = 3.29; // mM
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nfb = 1.2; // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nrb = 1.0; // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__fb = pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Kfb), var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nfb); // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__rb = pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Krb), var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nrb); // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tautr = 0.57469999999999999; // ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jtr = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR) / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tautr; // mM_per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tauxfer = 26.699999999999999; // ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jxfer = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS) / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tauxfer; // mM_per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__v1 = 1.8; // per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jrel = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR) * (var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR + var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR) * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__v1; // mM_per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxf = 7.4800000000000002e-5; // per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxr = 0.00031799999999999998; // per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jup = (var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__fb * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxf - var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__rb * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxr) * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__KSR / (1.0 + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__fb + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__rb); // mM_per_ms
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab = 7.6840000000000003e-5; // mS_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax = 2.387; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax = 0.050000000000000003; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa = 1.3799999999999999; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo = 1.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa = 87.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai = 20.0; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax / (var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na = 1.0 + 0.1245 * exp(-0.10000000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K = 1.0 + pow((var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai), 1.5); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx = 0.00020000000000000001 * pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) + 0.00020000000000000001 * pow(var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa, 3); // mM3
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__eta = 0.34999999999999998; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 3) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao * exp(var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT * var_COMPUTE_INaK_INaCa_ICab_IpCa__eta); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx = pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa = 0.44; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat = 0.20000000000000001; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx = 1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa = (-var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx + var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx) * var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na = 0.036499999999999998 * var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma * exp(-1.3300000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK = 1 / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na + var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK = var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax * var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K * var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK / var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 = 0.12530512611880798; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr = 0.018599999999999998; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs = 0.0035000000000000001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa = 56.32; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab = 0.001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac = 0.88900000000000001; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale = 0.872; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43 = 0.10000000000000001 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 = 4.2986000000000001e-7 * (1.0 - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // litre_per_farad_second
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2 = -1.0 + exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na = 0.02 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo = 0.5 * sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko); // dimensionless
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CMDNtot = 0.050000000000000003; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CSQNtot = 15.0; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__EGTAtot = 0; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNtot = 0.14000000000000001; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN = 0.0023800000000000002; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCSQN = 0.80000000000000004; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA = 0.00014999999999999999; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNtot = 0.070000000000000007; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_JSR = 1 / (1.0 + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CSQNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCSQN / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCSQN), 2)); // dimensionless
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_SS = 1 / (1.0 + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CMDNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN), 2) + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__EGTAtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA), 2)); // dimensionless
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_i = 1 / (1.0 + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CMDNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN), 2) + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__EGTAtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA), 2)); // dimensionless
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_minus = 6.6000000000000005e-5; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_plus = 20.0; // per_mM_per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dHTRPNCa = -var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_minus + (1.0 - var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_plus; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_minus = 0.040000000000000001; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_plus = 40.0; // per_mM_per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dLTRPNCa = -var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_minus + (1.0 - var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_plus; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__Jtrpn = var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dHTRPNCa + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dLTRPNCa; // mM_per_ms
        const double var_COMPUTE_REVERSAL_POTENTIALS__ECa = 0.5 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai); // mV
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab = (-var_COMPUTE_REVERSAL_POTENTIALS__ECa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__EK = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43 = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf = 1 / (0.93999999999999995 + exp(1.26 * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F)); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 = sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko) * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__ENa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab; // uA_per_uF
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR = (-var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jrel + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jtr) * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_JSR; // mM / ms
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jup / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VNSR - var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VJSR * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jtr / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VNSR; // mM / ms
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = (-var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a2 * var_COMPUTE_ICa_ICaK__ICa + var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VJSR * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jrel / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VSS - var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jxfer / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VSS) * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_SS; // mM / ms
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = (-var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jup - var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__Jtrpn - 0.5 * (-2.0 * var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa + var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab + var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1 + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jxfer) * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_i; // mM / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C0 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C0; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C1 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C1; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C2 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C2; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C3 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C3; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI0 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI0; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI1 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI1; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI2 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI2; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI3 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI3; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_OI + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_OI; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_O + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_O; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C043 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C043; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C143 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C143; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C243 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C243; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C343 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C343; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I043 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I043; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I143 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I143; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I243 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I243; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I343 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I343; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_OI43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_OI43; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_O43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_O43; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C0; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C1; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C2; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C3; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C4; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca0; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca1; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca2; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca3; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca4; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__fL - var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gL; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = (-var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa_inf) / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__tau_yCa; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR = var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC1_RyR; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR = var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC2_RyR; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO1_RyR; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR = var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO2_RyR; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa = var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dHTRPNCa; // 1 / ms
        const double d_dt_chaste_interface_var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa = var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dLTRPNCa; // 1 / ms
        const double var_IKr__A0_HERG = 0.017147641733086; // per_ms
        const double var_IKr__A1_HERG = 0.039693283811409998; // per_ms
        const double var_IKr__A2_HERG = 0.020574486059770001; // per_ms
        const double var_IKr__A3_HERG = 0.00134366604423; // per_ms
        const double var_IKr__A4_HERG = 0.10666316491288; // per_ms
        const double var_IKr__A5_HERG = 0.0064639391004900001; // per_ms
        const double var_IKr__A6_HERG = 8.0393744030000006e-5; // per_ms
        const double var_IKr__B0_HERG = 0.033046080388350003; // per_mV
        const double var_IKr__B1_HERG = -0.043060541639799998; // per_mV
        const double var_IKr__B2_HERG = 0.026174127151180001; // per_mV
        const double var_IKr__B3_HERG = -0.026913854983990002; // per_mV
        const double var_IKr__B4_HERG = 0.0056890885971700002; // per_mV
        const double var_IKr__B5_HERG = -0.045366429595429997; // per_mV
        const double var_IKr__B6_HERG = 6.9808923999999997e-7; // per_mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo * var_chaste_interface__IKr__OHerg; // uA_per_uF
        const double var_IKr__T_Const_HERG = 5.3200000010000004; // dimensionless
        const double var_IKr__C1H_to_C2H = var_IKr__A0_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B0_HERG); // per_ms
        const double var_IKr__C2H_to_C1H = var_IKr__A1_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B1_HERG); // per_ms
        const double d_dt_chaste_interface_var_IKr__C1Herg = var_IKr__C2H_to_C1H * var_chaste_interface__IKr__C2Herg - var_IKr__C1H_to_C2H * var_chaste_interface__IKr__C1Herg; // 1 / ms
        const double var_IKr__C2H_to_C3H = 0.026083620433370001 * var_IKr__T_Const_HERG; // per_ms
        const double var_IKr__C3H_to_C2H = 0.14832978132145 * var_IKr__T_Const_HERG; // per_ms
        const double var_IKr__C3H_to_IH = var_IKr__A6_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B6_HERG); // per_ms
        const double var_IKr__C3H_to_OH = var_IKr__A2_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B2_HERG); // per_ms
        const double var_IKr__IH_to_OH = var_IKr__A5_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B5_HERG); // per_ms
        const double var_IKr__OH_to_C3H = var_IKr__A3_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B3_HERG); // per_ms
        const double var_IKr__OH_to_IH = var_IKr__A4_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B4_HERG); // per_ms
        const double var_IKr__IH_to_C3H = var_IKr__C3H_to_IH * var_IKr__IH_to_OH * var_IKr__OH_to_C3H / (var_IKr__C3H_to_OH * var_IKr__OH_to_IH); // per_ms
        const double var_IKr__a1_C2 = var_IKr__C1H_to_C2H * var_chaste_interface__IKr__C1Herg + var_IKr__C3H_to_C2H * var_chaste_interface__IKr__C3Herg; // per_ms
        const double var_IKr__a1_C3 = var_IKr__C2H_to_C3H * var_chaste_interface__IKr__C2Herg + var_IKr__IH_to_C3H * var_chaste_interface__IKr__IHerg + var_IKr__OH_to_C3H * var_chaste_interface__IKr__OHerg; // per_ms
        const double var_IKr__a1_I = var_IKr__C3H_to_IH * var_chaste_interface__IKr__C3Herg + var_IKr__OH_to_IH * var_chaste_interface__IKr__OHerg; // per_ms
        const double var_IKr__a1_O = var_IKr__C3H_to_OH * var_chaste_interface__IKr__C3Herg + var_IKr__IH_to_OH * var_chaste_interface__IKr__IHerg; // per_ms
        const double var_IKr__a2_C2 = (var_IKr__C2H_to_C1H + var_IKr__C2H_to_C3H) * var_chaste_interface__IKr__C2Herg; // per_ms
        const double d_dt_chaste_interface_var_IKr__C2Herg = -var_IKr__a2_C2 + var_IKr__a1_C2; // 1 / ms
        const double var_IKr__a2_C3 = (var_IKr__C3H_to_C2H + var_IKr__C3H_to_IH + var_IKr__C3H_to_OH) * var_chaste_interface__IKr__C3Herg; // per_ms
        const double d_dt_chaste_interface_var_IKr__C3Herg = -var_IKr__a2_C3 + var_IKr__a1_C3; // 1 / ms
        const double var_IKr__a2_I = (var_IKr__IH_to_C3H + var_IKr__IH_to_OH) * var_chaste_interface__IKr__IHerg; // per_ms
        const double d_dt_chaste_interface_var_IKr__IHerg = -var_IKr__a2_I + var_IKr__a1_I; // 1 / ms
        const double var_IKr__a2_O = (var_IKr__OH_to_C3H + var_IKr__OH_to_IH) * var_chaste_interface__IKr__OHerg; // per_ms
        const double d_dt_chaste_interface_var_IKr__OHerg = -var_IKr__a2_O + var_IKr__a1_O; // 1 / ms
        const double var_IKs__C0ks_C1ks = 0.0079560079800399999; // per_ms
        const double var_IKs__C1ks_C0ks = 0.21625575895849999 * exp(-1.8891230210000001e-5 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double d_dt_chaste_interface_var_IKs__C0ks = var_chaste_interface__IKs__C1ks * var_IKs__C1ks_C0ks - var_chaste_interface__IKs__C0ks * var_IKs__C0ks_C1ks; // 1 / ms
        const double var_IKs__C1ks_O1ks = 0.039667206760709998; // per_ms
        const double var_IKs__O1ks_C1ks = 0.0070080662892900002 * exp(-0.14999754700285001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double d_dt_chaste_interface_var_IKs__C1ks = var_chaste_interface__IKs__C0ks * var_IKs__C0ks_C1ks + var_chaste_interface__IKs__O1ks * var_IKs__O1ks_C1ks - (var_IKs__C1ks_C0ks + var_IKs__C1ks_O1ks) * var_chaste_interface__IKs__C1ks; // 1 / ms
        const double var_IKs__O1ks_O2ks = 0.00767254363063 * exp(0.08662945914655 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__IKs__O1ks + var_chaste_interface__IKs__O2ks) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs; // uA_per_uF
        const double var_IKs__O2ks_O1ks = 0.0037973799836799999 * exp(-0.014256681268810001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double d_dt_chaste_interface_var_IKs__O1ks = var_chaste_interface__IKs__C1ks * var_IKs__C1ks_O1ks + var_chaste_interface__IKs__O2ks * var_IKs__O2ks_O1ks - (var_IKs__O1ks_C1ks + var_IKs__O1ks_O2ks) * var_chaste_interface__IKs__O1ks; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__O2ks = var_chaste_interface__IKs__O1ks * var_IKs__O1ks_O2ks - var_chaste_interface__IKs__O2ks * var_IKs__O2ks_O1ks; // 1 / ms
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Cf = var_INa__KToverH * var_INa__Temp_Scale * exp(0.00711 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 59565.2236284584 / var_INa__RTNa); // per_ms
        const double var_INa__Cn = var_INa__KToverH * var_INa__Temp_Scale * exp(786.21699999999998 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 287913.44653095299 / var_INa__RTNa); // per_ms
        const double var_INa__Delta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(229.20500000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 133689.93040909999 / var_INa__RTNa - 1.55804214553883 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__DeltaDelta = var_INa__KToverH * var_INa__Temp_Scale * exp(-130.63900000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 55700.662465830697 / var_INa__RTNa - 3.6498167292707802 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__GammaGamma = var_INa__KToverH * var_INa__Temp_Scale * exp(116431.14214234801 / var_INa__RTNa - 578.31700000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas + 0.76412601174570705 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__Of = var_INa__KToverH * var_INa__Temp_Scale * exp(1.51 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 97657.849713701493 / var_INa__RTNa + 0.068486199310068496 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__On = var_INa__KToverH * var_INa__Temp_Scale * exp(39.295000000000002 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 62123.078438048098 / var_INa__RTNa + 0.28881604274323203 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__alpha1 = var_INa__KToverH * var_INa__Temp_Scale * exp(224.114 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 114007.462700232 / var_INa__RTNa + 0.28637426859623499 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__beta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(708.14599999999996 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 272470.27348968101 / var_INa__RTNa - 2.2852841758642399 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__epsilon = var_INa__KToverH * var_INa__Temp_Scale * exp(70.078000000000003 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 85800.367557832593 / var_INa__RTNa); // per_ms
        const double var_INa__gamma1 = var_INa__KToverH * var_INa__Temp_Scale * exp(529.952 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 196336.57573592299 / var_INa__RTNa + 2.7808491859604501 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k12 = 4.0 * var_INa__alpha1; // per_ms
        const double var_INa__k1213 = var_INa__GammaGamma; // per_ms
        const double var_INa__k1312 = var_INa__DeltaDelta; // per_ms
        const double var_INa__k136 = var_INa__Of; // per_ms
        const double var_INa__k18 = var_INa__Cn; // per_ms
        const double var_INa__k21 = var_INa__beta1; // per_ms
        const double var_INa__k23 = 3.0 * var_INa__alpha1; // per_ms
        const double var_INa__k32 = 2.0 * var_INa__beta1; // per_ms
        const double var_INa__k34 = 2.0 * var_INa__alpha1; // per_ms
        const double var_INa__k43 = 3.0 * var_INa__beta1; // per_ms
        const double var_INa__k45 = var_INa__alpha1; // per_ms
        const double var_INa__k54 = 4.0 * var_INa__beta1; // per_ms
        const double var_INa__k56 = var_INa__gamma1; // per_ms
        const double var_INa__k613 = var_INa__On; // per_ms
        const double var_INa__k65 = var_INa__Delta1; // per_ms
        const double var_INa__k67 = var_INa__epsilon; // per_ms
        const double var_INa__k81 = var_INa__Cf; // per_ms
        const double var_INa__mu = var_INa__KToverH * var_INa__Temp_Scale * exp(193.26499999999999 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 121322.14327524199 / var_INa__RTNa - 1.74290267020903 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k75 = var_INa__mu; // per_ms
        const double d_dt_chaste_interface_var_INa__na13 = var_INa__k1213 * var_chaste_interface__INa__na12 + var_INa__k613 * var_chaste_interface__INa__na6 - (var_INa__k1312 + var_INa__k136) * var_chaste_interface__INa__na13; // 1 / ms
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__INa__na6 + var_chaste_interface__INa__na7) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa; // uA_per_uF
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = (-var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab - 3.0 * var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa - 3.0 * var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1; // mM / ms
        const double d_dt_chaste_interface_var_INa__na1 = (-var_INa__k12 - var_INa__k18) * var_chaste_interface__INa__na1 + var_INa__k21 * var_chaste_interface__INa__na2 + var_INa__k81 * var_chaste_interface__INa__na8; // 1 / ms
        const double var_INa__omega_na = var_INa__KToverH * var_INa__Temp_Scale * exp(225.17500000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 121955.166154864 / var_INa__RTNa); // per_ms
        const double var_INa__k76 = var_INa__omega_na; // per_ms
        const double d_dt_chaste_interface_var_INa__na6 = var_INa__k136 * var_chaste_interface__INa__na13 + var_INa__k56 * var_chaste_interface__INa__na5 + var_INa__k76 * var_chaste_interface__INa__na7 - (var_INa__k613 + var_INa__k65 + var_INa__k67) * var_chaste_interface__INa__na6; // 1 / ms
        const double var_INa__parameter_a = 1.4004262547740101; // dimensionless
        const double var_INa__k1011 = var_INa__k34 * var_INa__parameter_a; // per_ms
        const double var_INa__k109 = var_INa__k32 / var_INa__parameter_a; // per_ms
        const double var_INa__k1110 = var_INa__k43 / var_INa__parameter_a; // per_ms
        const double var_INa__k1112 = var_INa__k45 * var_INa__parameter_a; // per_ms
        const double var_INa__k1211 = var_INa__k54 / var_INa__parameter_a; // per_ms
        const double var_INa__k29 = var_INa__k18 * var_INa__parameter_a; // per_ms
        const double var_INa__k310 = var_INa__k29 * var_INa__parameter_a; // per_ms
        const double var_INa__k411 = var_INa__k310 * var_INa__parameter_a; // per_ms
        const double var_INa__k512 = var_INa__k411 * var_INa__parameter_a; // per_ms
        const double var_INa__k89 = var_INa__k12 * var_INa__parameter_a; // per_ms
        const double var_INa__k910 = var_INa__k23 * var_INa__parameter_a; // per_ms
        const double var_INa__k92 = var_INa__k81 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na2 = var_INa__k12 * var_chaste_interface__INa__na1 + var_INa__k32 * var_chaste_interface__INa__na3 + var_INa__k92 * var_chaste_interface__INa__na9 - (var_INa__k21 + var_INa__k23 + var_INa__k29) * var_chaste_interface__INa__na2; // 1 / ms
        const double var_INa__k103 = var_INa__k92 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na10 = var_INa__k1110 * var_chaste_interface__INa__na11 + var_INa__k310 * var_chaste_interface__INa__na3 + var_INa__k910 * var_chaste_interface__INa__na9 - (var_INa__k1011 + var_INa__k103 + var_INa__k109) * var_chaste_interface__INa__na10; // 1 / ms
        const double d_dt_chaste_interface_var_INa__na3 = var_INa__k103 * var_chaste_interface__INa__na10 + var_INa__k23 * var_chaste_interface__INa__na2 + var_INa__k43 * var_chaste_interface__INa__na4 - (var_INa__k310 + var_INa__k32 + var_INa__k34) * var_chaste_interface__INa__na3; // 1 / ms
        const double var_INa__k114 = var_INa__k103 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na11 = var_INa__k1011 * var_chaste_interface__INa__na10 + var_INa__k1211 * var_chaste_interface__INa__na12 + var_INa__k411 * var_chaste_interface__INa__na4 - (var_INa__k1110 + var_INa__k1112 + var_INa__k114) * var_chaste_interface__INa__na11; // 1 / ms
        const double d_dt_chaste_interface_var_INa__na4 = var_INa__k114 * var_chaste_interface__INa__na11 + var_INa__k34 * var_chaste_interface__INa__na3 + var_INa__k54 * var_chaste_interface__INa__na5 - (var_INa__k411 + var_INa__k43 + var_INa__k45) * var_chaste_interface__INa__na4; // 1 / ms
        const double var_INa__k125 = var_INa__k114 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na12 = var_INa__k1112 * var_chaste_interface__INa__na11 + var_INa__k1312 * var_chaste_interface__INa__na13 + var_INa__k512 * var_chaste_interface__INa__na5 - (var_INa__k1211 + var_INa__k1213 + var_INa__k125) * var_chaste_interface__INa__na12; // 1 / ms
        const double var_INa__k98 = var_INa__k21 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na8 = var_INa__k18 * var_chaste_interface__INa__na1 + var_INa__k98 * var_chaste_interface__INa__na9 - (var_INa__k81 + var_INa__k89) * var_chaste_interface__INa__na8; // 1 / ms
        const double d_dt_chaste_interface_var_INa__na9 = var_INa__k109 * var_chaste_interface__INa__na10 + var_INa__k29 * var_chaste_interface__INa__na2 + var_INa__k89 * var_chaste_interface__INa__na8 - (var_INa__k910 + var_INa__k92 + var_INa__k98) * var_chaste_interface__INa__na9; // 1 / ms
        const double var_INa__rho = var_INa__KToverH * var_INa__Temp_Scale * exp(338.91500000000002 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 147813.99000503501 / var_INa__RTNa + 2.1360043702125999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k57 = var_INa__rho; // per_ms
        const double d_dt_chaste_interface_var_INa__na5 = var_INa__k125 * var_chaste_interface__INa__na12 + var_INa__k45 * var_chaste_interface__INa__na4 + var_INa__k65 * var_chaste_interface__INa__na6 + var_INa__k75 * var_chaste_interface__INa__na7 - (var_INa__k512 + var_INa__k54 + var_INa__k56 + var_INa__k57) * var_chaste_interface__INa__na5; // 1 / ms
        const double d_dt_chaste_interface_var_INa__na7 = var_INa__k57 * var_chaste_interface__INa__na5 + var_INa__k67 * var_chaste_interface__INa__na6 - (var_INa__k75 + var_INa__k76) * var_chaste_interface__INa__na7; // 1 / ms
        const double var_I_stimulus__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_I_stimulus__i_Stim = var_I_stimulus__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = (-var_COMPUTE_ICa_ICaK__ICaK - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43 - var_I_stimulus__i_Stim + 2.0 * var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1; // mM / ms

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = 0.0;
        }
        else
        {
            const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14 = var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na; // uA_per_uF
            const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Ito1 = var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14 + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43; // uA_per_uF
            const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__i_tot = var_COMPUTE_ICa_ICaK__ICa + var_COMPUTE_ICa_ICaK__ICaK + var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab + var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa + var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK + var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Ito1 + var_I_stimulus__i_Stim; // uA_per_uF
            d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__i_tot; // mV / ms
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
        mEvalF[1] = d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai;
        mEvalF[2] = d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki;
        mEvalF[3] = d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
        mEvalF[4] = d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
        mEvalF[5] = d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR;
        mEvalF[6] = d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR;
        mEvalF[7] = d_dt_chaste_interface_var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa;
        mEvalF[8] = d_dt_chaste_interface_var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa;
        mEvalF[9] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR;
        mEvalF[10] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR;
        mEvalF[11] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR;
        mEvalF[12] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR;
        mEvalF[13] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0;
        mEvalF[14] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1;
        mEvalF[15] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2;
        mEvalF[16] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3;
        mEvalF[17] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4;
        mEvalF[18] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0;
        mEvalF[19] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1;
        mEvalF[20] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2;
        mEvalF[21] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3;
        mEvalF[22] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4;
        mEvalF[23] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open;
        mEvalF[24] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa;
        mEvalF[25] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43;
        mEvalF[26] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43;
        mEvalF[27] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43;
        mEvalF[28] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43;
        mEvalF[29] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43;
        mEvalF[30] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43;
        mEvalF[31] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43;
        mEvalF[32] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43;
        mEvalF[33] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43;
        mEvalF[34] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43;
        mEvalF[35] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14;
        mEvalF[36] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14;
        mEvalF[37] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14;
        mEvalF[38] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14;
        mEvalF[39] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14;
        mEvalF[40] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14;
        mEvalF[41] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14;
        mEvalF[42] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14;
        mEvalF[43] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14;
        mEvalF[44] = d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14;
        mEvalF[45] = d_dt_chaste_interface_var_INa__na1;
        mEvalF[46] = d_dt_chaste_interface_var_INa__na2;
        mEvalF[47] = d_dt_chaste_interface_var_INa__na3;
        mEvalF[48] = d_dt_chaste_interface_var_INa__na4;
        mEvalF[49] = d_dt_chaste_interface_var_INa__na5;
        mEvalF[50] = d_dt_chaste_interface_var_INa__na6;
        mEvalF[51] = d_dt_chaste_interface_var_INa__na7;
        mEvalF[52] = d_dt_chaste_interface_var_INa__na8;
        mEvalF[53] = d_dt_chaste_interface_var_INa__na9;
        mEvalF[54] = d_dt_chaste_interface_var_INa__na10;
        mEvalF[55] = d_dt_chaste_interface_var_INa__na11;
        mEvalF[56] = d_dt_chaste_interface_var_INa__na12;
        mEvalF[57] = d_dt_chaste_interface_var_INa__na13;
        mEvalF[58] = d_dt_chaste_interface_var_IKr__C1Herg;
        mEvalF[59] = d_dt_chaste_interface_var_IKr__C2Herg;
        mEvalF[60] = d_dt_chaste_interface_var_IKr__C3Herg;
        mEvalF[61] = d_dt_chaste_interface_var_IKr__OHerg;
        mEvalF[62] = d_dt_chaste_interface_var_IKr__IHerg;
        mEvalF[63] = d_dt_chaste_interface_var_IKs__C0ks;
        mEvalF[64] = d_dt_chaste_interface_var_IKs__C1ks;
        mEvalF[65] = d_dt_chaste_interface_var_IKs__O1ks;
        mEvalF[66] = d_dt_chaste_interface_var_IKs__O2ks;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time, rY, delta);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time, rY, delta);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time, rY, delta);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time, rY, delta);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time, rY, delta);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time, rY, delta);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time, rY, delta);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time, rY, delta);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time, rY, delta);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time, rY, delta);
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__environment__time, rY, delta);
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__environment__time, rY, delta);
        mPartialF[29] = EvaluatePartialDerivative29(var_chaste_interface__environment__time, rY, delta);
        mPartialF[30] = EvaluatePartialDerivative30(var_chaste_interface__environment__time, rY, delta);
        mPartialF[31] = EvaluatePartialDerivative31(var_chaste_interface__environment__time, rY, delta);
        mPartialF[32] = EvaluatePartialDerivative32(var_chaste_interface__environment__time, rY, delta);
        mPartialF[33] = EvaluatePartialDerivative33(var_chaste_interface__environment__time, rY, delta);
        mPartialF[34] = EvaluatePartialDerivative34(var_chaste_interface__environment__time, rY, delta);
        mPartialF[35] = EvaluatePartialDerivative35(var_chaste_interface__environment__time, rY, delta);
        mPartialF[36] = EvaluatePartialDerivative36(var_chaste_interface__environment__time, rY, delta);
        mPartialF[37] = EvaluatePartialDerivative37(var_chaste_interface__environment__time, rY, delta);
        mPartialF[38] = EvaluatePartialDerivative38(var_chaste_interface__environment__time, rY, delta);
        mPartialF[39] = EvaluatePartialDerivative39(var_chaste_interface__environment__time, rY, delta);
        mPartialF[40] = EvaluatePartialDerivative40(var_chaste_interface__environment__time, rY, delta);
        mPartialF[41] = EvaluatePartialDerivative41(var_chaste_interface__environment__time, rY, delta);
        mPartialF[42] = EvaluatePartialDerivative42(var_chaste_interface__environment__time, rY, delta);
        mPartialF[43] = EvaluatePartialDerivative43(var_chaste_interface__environment__time, rY, delta);
        mPartialF[44] = EvaluatePartialDerivative44(var_chaste_interface__environment__time, rY, delta);
        mPartialF[45] = EvaluatePartialDerivative45(var_chaste_interface__environment__time, rY, delta);
        mPartialF[46] = EvaluatePartialDerivative46(var_chaste_interface__environment__time, rY, delta);
        mPartialF[47] = EvaluatePartialDerivative47(var_chaste_interface__environment__time, rY, delta);
        mPartialF[48] = EvaluatePartialDerivative48(var_chaste_interface__environment__time, rY, delta);
        mPartialF[49] = EvaluatePartialDerivative49(var_chaste_interface__environment__time, rY, delta);
        mPartialF[50] = EvaluatePartialDerivative50(var_chaste_interface__environment__time, rY, delta);
        mPartialF[51] = EvaluatePartialDerivative51(var_chaste_interface__environment__time, rY, delta);
        mPartialF[52] = EvaluatePartialDerivative52(var_chaste_interface__environment__time, rY, delta);
        mPartialF[53] = EvaluatePartialDerivative53(var_chaste_interface__environment__time, rY, delta);
        mPartialF[54] = EvaluatePartialDerivative54(var_chaste_interface__environment__time, rY, delta);
        mPartialF[55] = EvaluatePartialDerivative55(var_chaste_interface__environment__time, rY, delta);
        mPartialF[56] = EvaluatePartialDerivative56(var_chaste_interface__environment__time, rY, delta);
        mPartialF[57] = EvaluatePartialDerivative57(var_chaste_interface__environment__time, rY, delta);
        mPartialF[58] = EvaluatePartialDerivative58(var_chaste_interface__environment__time, rY, delta);
        mPartialF[59] = EvaluatePartialDerivative59(var_chaste_interface__environment__time, rY, delta);
        mPartialF[60] = EvaluatePartialDerivative60(var_chaste_interface__environment__time, rY, delta);
        mPartialF[61] = EvaluatePartialDerivative61(var_chaste_interface__environment__time, rY, delta);
        mPartialF[62] = EvaluatePartialDerivative62(var_chaste_interface__environment__time, rY, delta);
        mPartialF[63] = EvaluatePartialDerivative63(var_chaste_interface__environment__time, rY, delta);
        mPartialF[64] = EvaluatePartialDerivative64(var_chaste_interface__environment__time, rY, delta);
        mPartialF[65] = EvaluatePartialDerivative65(var_chaste_interface__environment__time, rY, delta);
        mPartialF[66] = EvaluatePartialDerivative66(var_chaste_interface__environment__time, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        rY[13] = y_save;
        
        
        y_save = rY[14];
        rY[14] = mYInit[14];
        mEvalF[14] = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        rY[14] = y_save;
        
        
        y_save = rY[15];
        rY[15] = mYInit[15];
        mEvalF[15] = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        rY[15] = y_save;
        
        
        y_save = rY[16];
        rY[16] = mYInit[16];
        mEvalF[16] = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        rY[16] = y_save;
        
        
        y_save = rY[17];
        rY[17] = mYInit[17];
        mEvalF[17] = EvaluateYDerivative17(var_chaste_interface__environment__time, rY);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time, rY, delta);
        rY[17] = y_save;
        
        
        y_save = rY[18];
        rY[18] = mYInit[18];
        mEvalF[18] = EvaluateYDerivative18(var_chaste_interface__environment__time, rY);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time, rY, delta);
        rY[18] = y_save;
        
        
        y_save = rY[19];
        rY[19] = mYInit[19];
        mEvalF[19] = EvaluateYDerivative19(var_chaste_interface__environment__time, rY);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time, rY, delta);
        rY[19] = y_save;
        
        
        y_save = rY[20];
        rY[20] = mYInit[20];
        mEvalF[20] = EvaluateYDerivative20(var_chaste_interface__environment__time, rY);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time, rY, delta);
        rY[20] = y_save;
        
        
        y_save = rY[21];
        rY[21] = mYInit[21];
        mEvalF[21] = EvaluateYDerivative21(var_chaste_interface__environment__time, rY);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time, rY, delta);
        rY[21] = y_save;
        
        
        y_save = rY[22];
        rY[22] = mYInit[22];
        mEvalF[22] = EvaluateYDerivative22(var_chaste_interface__environment__time, rY);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time, rY, delta);
        rY[22] = y_save;
        
        
        y_save = rY[23];
        rY[23] = mYInit[23];
        mEvalF[23] = EvaluateYDerivative23(var_chaste_interface__environment__time, rY);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time, rY, delta);
        rY[23] = y_save;
        
        
        y_save = rY[24];
        rY[24] = mYInit[24];
        mEvalF[24] = EvaluateYDerivative24(var_chaste_interface__environment__time, rY);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time, rY, delta);
        rY[24] = y_save;
        
        
        y_save = rY[25];
        rY[25] = mYInit[25];
        mEvalF[25] = EvaluateYDerivative25(var_chaste_interface__environment__time, rY);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time, rY, delta);
        rY[25] = y_save;
        
        
        y_save = rY[26];
        rY[26] = mYInit[26];
        mEvalF[26] = EvaluateYDerivative26(var_chaste_interface__environment__time, rY);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time, rY, delta);
        rY[26] = y_save;
        
        
        y_save = rY[27];
        rY[27] = mYInit[27];
        mEvalF[27] = EvaluateYDerivative27(var_chaste_interface__environment__time, rY);
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__environment__time, rY, delta);
        rY[27] = y_save;
        
        
        y_save = rY[28];
        rY[28] = mYInit[28];
        mEvalF[28] = EvaluateYDerivative28(var_chaste_interface__environment__time, rY);
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__environment__time, rY, delta);
        rY[28] = y_save;
        
        
        y_save = rY[29];
        rY[29] = mYInit[29];
        mEvalF[29] = EvaluateYDerivative29(var_chaste_interface__environment__time, rY);
        mPartialF[29] = EvaluatePartialDerivative29(var_chaste_interface__environment__time, rY, delta);
        rY[29] = y_save;
        
        
        y_save = rY[30];
        rY[30] = mYInit[30];
        mEvalF[30] = EvaluateYDerivative30(var_chaste_interface__environment__time, rY);
        mPartialF[30] = EvaluatePartialDerivative30(var_chaste_interface__environment__time, rY, delta);
        rY[30] = y_save;
        
        
        y_save = rY[31];
        rY[31] = mYInit[31];
        mEvalF[31] = EvaluateYDerivative31(var_chaste_interface__environment__time, rY);
        mPartialF[31] = EvaluatePartialDerivative31(var_chaste_interface__environment__time, rY, delta);
        rY[31] = y_save;
        
        
        y_save = rY[32];
        rY[32] = mYInit[32];
        mEvalF[32] = EvaluateYDerivative32(var_chaste_interface__environment__time, rY);
        mPartialF[32] = EvaluatePartialDerivative32(var_chaste_interface__environment__time, rY, delta);
        rY[32] = y_save;
        
        
        y_save = rY[33];
        rY[33] = mYInit[33];
        mEvalF[33] = EvaluateYDerivative33(var_chaste_interface__environment__time, rY);
        mPartialF[33] = EvaluatePartialDerivative33(var_chaste_interface__environment__time, rY, delta);
        rY[33] = y_save;
        
        
        y_save = rY[34];
        rY[34] = mYInit[34];
        mEvalF[34] = EvaluateYDerivative34(var_chaste_interface__environment__time, rY);
        mPartialF[34] = EvaluatePartialDerivative34(var_chaste_interface__environment__time, rY, delta);
        rY[34] = y_save;
        
        
        y_save = rY[35];
        rY[35] = mYInit[35];
        mEvalF[35] = EvaluateYDerivative35(var_chaste_interface__environment__time, rY);
        mPartialF[35] = EvaluatePartialDerivative35(var_chaste_interface__environment__time, rY, delta);
        rY[35] = y_save;
        
        
        y_save = rY[36];
        rY[36] = mYInit[36];
        mEvalF[36] = EvaluateYDerivative36(var_chaste_interface__environment__time, rY);
        mPartialF[36] = EvaluatePartialDerivative36(var_chaste_interface__environment__time, rY, delta);
        rY[36] = y_save;
        
        
        y_save = rY[37];
        rY[37] = mYInit[37];
        mEvalF[37] = EvaluateYDerivative37(var_chaste_interface__environment__time, rY);
        mPartialF[37] = EvaluatePartialDerivative37(var_chaste_interface__environment__time, rY, delta);
        rY[37] = y_save;
        
        
        y_save = rY[38];
        rY[38] = mYInit[38];
        mEvalF[38] = EvaluateYDerivative38(var_chaste_interface__environment__time, rY);
        mPartialF[38] = EvaluatePartialDerivative38(var_chaste_interface__environment__time, rY, delta);
        rY[38] = y_save;
        
        
        y_save = rY[39];
        rY[39] = mYInit[39];
        mEvalF[39] = EvaluateYDerivative39(var_chaste_interface__environment__time, rY);
        mPartialF[39] = EvaluatePartialDerivative39(var_chaste_interface__environment__time, rY, delta);
        rY[39] = y_save;
        
        
        y_save = rY[40];
        rY[40] = mYInit[40];
        mEvalF[40] = EvaluateYDerivative40(var_chaste_interface__environment__time, rY);
        mPartialF[40] = EvaluatePartialDerivative40(var_chaste_interface__environment__time, rY, delta);
        rY[40] = y_save;
        
        
        y_save = rY[41];
        rY[41] = mYInit[41];
        mEvalF[41] = EvaluateYDerivative41(var_chaste_interface__environment__time, rY);
        mPartialF[41] = EvaluatePartialDerivative41(var_chaste_interface__environment__time, rY, delta);
        rY[41] = y_save;
        
        
        y_save = rY[42];
        rY[42] = mYInit[42];
        mEvalF[42] = EvaluateYDerivative42(var_chaste_interface__environment__time, rY);
        mPartialF[42] = EvaluatePartialDerivative42(var_chaste_interface__environment__time, rY, delta);
        rY[42] = y_save;
        
        
        y_save = rY[43];
        rY[43] = mYInit[43];
        mEvalF[43] = EvaluateYDerivative43(var_chaste_interface__environment__time, rY);
        mPartialF[43] = EvaluatePartialDerivative43(var_chaste_interface__environment__time, rY, delta);
        rY[43] = y_save;
        
        
        y_save = rY[44];
        rY[44] = mYInit[44];
        mEvalF[44] = EvaluateYDerivative44(var_chaste_interface__environment__time, rY);
        mPartialF[44] = EvaluatePartialDerivative44(var_chaste_interface__environment__time, rY, delta);
        rY[44] = y_save;
        
        
        y_save = rY[45];
        rY[45] = mYInit[45];
        mEvalF[45] = EvaluateYDerivative45(var_chaste_interface__environment__time, rY);
        mPartialF[45] = EvaluatePartialDerivative45(var_chaste_interface__environment__time, rY, delta);
        rY[45] = y_save;
        
        
        y_save = rY[46];
        rY[46] = mYInit[46];
        mEvalF[46] = EvaluateYDerivative46(var_chaste_interface__environment__time, rY);
        mPartialF[46] = EvaluatePartialDerivative46(var_chaste_interface__environment__time, rY, delta);
        rY[46] = y_save;
        
        
        y_save = rY[47];
        rY[47] = mYInit[47];
        mEvalF[47] = EvaluateYDerivative47(var_chaste_interface__environment__time, rY);
        mPartialF[47] = EvaluatePartialDerivative47(var_chaste_interface__environment__time, rY, delta);
        rY[47] = y_save;
        
        
        y_save = rY[48];
        rY[48] = mYInit[48];
        mEvalF[48] = EvaluateYDerivative48(var_chaste_interface__environment__time, rY);
        mPartialF[48] = EvaluatePartialDerivative48(var_chaste_interface__environment__time, rY, delta);
        rY[48] = y_save;
        
        
        y_save = rY[49];
        rY[49] = mYInit[49];
        mEvalF[49] = EvaluateYDerivative49(var_chaste_interface__environment__time, rY);
        mPartialF[49] = EvaluatePartialDerivative49(var_chaste_interface__environment__time, rY, delta);
        rY[49] = y_save;
        
        
        y_save = rY[50];
        rY[50] = mYInit[50];
        mEvalF[50] = EvaluateYDerivative50(var_chaste_interface__environment__time, rY);
        mPartialF[50] = EvaluatePartialDerivative50(var_chaste_interface__environment__time, rY, delta);
        rY[50] = y_save;
        
        
        y_save = rY[51];
        rY[51] = mYInit[51];
        mEvalF[51] = EvaluateYDerivative51(var_chaste_interface__environment__time, rY);
        mPartialF[51] = EvaluatePartialDerivative51(var_chaste_interface__environment__time, rY, delta);
        rY[51] = y_save;
        
        
        y_save = rY[52];
        rY[52] = mYInit[52];
        mEvalF[52] = EvaluateYDerivative52(var_chaste_interface__environment__time, rY);
        mPartialF[52] = EvaluatePartialDerivative52(var_chaste_interface__environment__time, rY, delta);
        rY[52] = y_save;
        
        
        y_save = rY[53];
        rY[53] = mYInit[53];
        mEvalF[53] = EvaluateYDerivative53(var_chaste_interface__environment__time, rY);
        mPartialF[53] = EvaluatePartialDerivative53(var_chaste_interface__environment__time, rY, delta);
        rY[53] = y_save;
        
        
        y_save = rY[54];
        rY[54] = mYInit[54];
        mEvalF[54] = EvaluateYDerivative54(var_chaste_interface__environment__time, rY);
        mPartialF[54] = EvaluatePartialDerivative54(var_chaste_interface__environment__time, rY, delta);
        rY[54] = y_save;
        
        
        y_save = rY[55];
        rY[55] = mYInit[55];
        mEvalF[55] = EvaluateYDerivative55(var_chaste_interface__environment__time, rY);
        mPartialF[55] = EvaluatePartialDerivative55(var_chaste_interface__environment__time, rY, delta);
        rY[55] = y_save;
        
        
        y_save = rY[56];
        rY[56] = mYInit[56];
        mEvalF[56] = EvaluateYDerivative56(var_chaste_interface__environment__time, rY);
        mPartialF[56] = EvaluatePartialDerivative56(var_chaste_interface__environment__time, rY, delta);
        rY[56] = y_save;
        
        
        y_save = rY[57];
        rY[57] = mYInit[57];
        mEvalF[57] = EvaluateYDerivative57(var_chaste_interface__environment__time, rY);
        mPartialF[57] = EvaluatePartialDerivative57(var_chaste_interface__environment__time, rY, delta);
        rY[57] = y_save;
        
        
        y_save = rY[58];
        rY[58] = mYInit[58];
        mEvalF[58] = EvaluateYDerivative58(var_chaste_interface__environment__time, rY);
        mPartialF[58] = EvaluatePartialDerivative58(var_chaste_interface__environment__time, rY, delta);
        rY[58] = y_save;
        
        
        y_save = rY[59];
        rY[59] = mYInit[59];
        mEvalF[59] = EvaluateYDerivative59(var_chaste_interface__environment__time, rY);
        mPartialF[59] = EvaluatePartialDerivative59(var_chaste_interface__environment__time, rY, delta);
        rY[59] = y_save;
        
        
        y_save = rY[60];
        rY[60] = mYInit[60];
        mEvalF[60] = EvaluateYDerivative60(var_chaste_interface__environment__time, rY);
        mPartialF[60] = EvaluatePartialDerivative60(var_chaste_interface__environment__time, rY, delta);
        rY[60] = y_save;
        
        
        y_save = rY[61];
        rY[61] = mYInit[61];
        mEvalF[61] = EvaluateYDerivative61(var_chaste_interface__environment__time, rY);
        mPartialF[61] = EvaluatePartialDerivative61(var_chaste_interface__environment__time, rY, delta);
        rY[61] = y_save;
        
        
        y_save = rY[62];
        rY[62] = mYInit[62];
        mEvalF[62] = EvaluateYDerivative62(var_chaste_interface__environment__time, rY);
        mPartialF[62] = EvaluatePartialDerivative62(var_chaste_interface__environment__time, rY, delta);
        rY[62] = y_save;
        
        
        y_save = rY[63];
        rY[63] = mYInit[63];
        mEvalF[63] = EvaluateYDerivative63(var_chaste_interface__environment__time, rY);
        mPartialF[63] = EvaluatePartialDerivative63(var_chaste_interface__environment__time, rY, delta);
        rY[63] = y_save;
        
        
        y_save = rY[64];
        rY[64] = mYInit[64];
        mEvalF[64] = EvaluateYDerivative64(var_chaste_interface__environment__time, rY);
        mPartialF[64] = EvaluatePartialDerivative64(var_chaste_interface__environment__time, rY, delta);
        rY[64] = y_save;
        
        
        y_save = rY[65];
        rY[65] = mYInit[65];
        mEvalF[65] = EvaluateYDerivative65(var_chaste_interface__environment__time, rY);
        mPartialF[65] = EvaluatePartialDerivative65(var_chaste_interface__environment__time, rY, delta);
        rY[65] = y_save;
        
        
        y_save = rY[66];
        rY[66] = mYInit[66];
        mEvalF[66] = EvaluateYDerivative66(var_chaste_interface__environment__time, rY);
        mPartialF[66] = EvaluatePartialDerivative66(var_chaste_interface__environment__time, rY, delta);
        rY[66] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rY[1];
        // Units: mM; Initial value: 9.798304162
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = rY[2];
        // Units: mM; Initial value: 125.5589432
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
        // Units: mM; Initial value: 8.601192016e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
        // Units: dimensionless; Initial value: 7.757981563e-12
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
        // Units: dimensionless; Initial value: 0.9997157074
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rY[29];
        // Units: dimensionless; Initial value: 2.29955624e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
        // Units: dimensionless; Initial value: 1.975541357e-05
        double var_chaste_interface__INa__na6 = rY[50];
        // Units: dimensionless; Initial value: 1.57442749e-08
        double var_chaste_interface__INa__na7 = rY[51];
        // Units: dimensionless; Initial value: 2.856607179e-09
        double var_chaste_interface__IKr__OHerg = rY[61];
        // Units: dimensionless; Initial value: 9.511789113e-06
        double var_chaste_interface__IKs__O1ks = rY[65];
        // Units: dimensionless; Initial value: 2.491710696e-07
        double var_chaste_interface__IKs__O2ks = rY[66];
        // Units: dimensionless; Initial value: 1.298547822e-05
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao = 2.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko = 4.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao = 138.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp = 310.0; // kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_COMPUTE_ICa_ICaK__ICahalf = -0.26500000000000001; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Pscale = 7.0; // dimensionless
        const double var_COMPUTE_ICa_ICaK__PCa = 0.00024689999999999998 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__PK = 4.5740000000000001e-7 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_ICa_ICaK__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_ICa_ICaK__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_ICa_ICaK__a1_Ca = 0.001 * exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT) - 0.34100000000000003 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao; // mM
        const double var_COMPUTE_ICa_ICaK__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // mM
        const double var_COMPUTE_ICa_ICaK__a2_Ca = -1.0 + exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICamax = 4.0 * var_COMPUTE_ICa_ICaK__PCa * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_Ca / var_COMPUTE_ICa_ICaK__a2_Ca; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__ICa = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__ICamax; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Icabar = ((var_COMPUTE_ICa_ICaK__ICamax >= 0) ? (0) : (var_COMPUTE_ICa_ICaK__ICamax)); // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__PKprime = var_COMPUTE_ICa_ICaK__PK / (1.0 + var_COMPUTE_ICa_ICaK__Icabar / var_COMPUTE_ICa_ICaK__ICahalf); // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__a2_K = -1.0 + exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICaK = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__PKprime * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_K / var_COMPUTE_ICa_ICaK__a2_K; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab = 7.6840000000000003e-5; // mS_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax = 2.387; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax = 0.050000000000000003; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa = 1.3799999999999999; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo = 1.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa = 87.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai = 20.0; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax / (var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na = 1.0 + 0.1245 * exp(-0.10000000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K = 1.0 + pow((var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai), 1.5); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx = 0.00020000000000000001 * pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) + 0.00020000000000000001 * pow(var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa, 3); // mM3
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__eta = 0.34999999999999998; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 3) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao * exp(var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT * var_COMPUTE_INaK_INaCa_ICab_IpCa__eta); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx = pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa = 0.44; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat = 0.20000000000000001; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx = 1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa = (-var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx + var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx) * var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na = 0.036499999999999998 * var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma * exp(-1.3300000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK = 1 / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na + var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK = var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax * var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K * var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK / var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 = 0.12530512611880798; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr = 0.018599999999999998; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs = 0.0035000000000000001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa = 56.32; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab = 0.001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac = 0.88900000000000001; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale = 0.872; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43 = 0.10000000000000001 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 = 4.2986000000000001e-7 * (1.0 - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // litre_per_farad_second
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2 = -1.0 + exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na = 0.02 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14 = var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo = 0.5 * sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko); // dimensionless
        const double var_COMPUTE_REVERSAL_POTENTIALS__ECa = 0.5 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai); // mV
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab = (-var_COMPUTE_REVERSAL_POTENTIALS__ECa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__EK = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43 = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Ito1 = var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14 + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf = 1 / (0.93999999999999995 + exp(1.26 * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F)); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 = sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko) * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__ENa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo * var_chaste_interface__IKr__OHerg; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__IKs__O1ks + var_chaste_interface__IKs__O2ks) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__INa__na6 + var_chaste_interface__INa__na7) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa; // uA_per_uF
        const double var_I_stimulus__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_I_stimulus__i_Stim = var_I_stimulus__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__i_tot = var_COMPUTE_ICa_ICaK__ICa + var_COMPUTE_ICa_ICaK__ICaK + var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab + var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa + var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK + var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab + var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Ito1 + var_I_stimulus__i_Stim; // uA_per_uF
        d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__i_tot; // mV / ms

        return d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rY[1];
            // Units: mM; Initial value: 9.798304162
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = rY[2];
            // Units: mM; Initial value: 125.5589432
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
            // Units: mM; Initial value: 8.601192016e-05
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
            // Units: dimensionless; Initial value: 7.757981563e-12
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
            // Units: dimensionless; Initial value: 0.9997157074
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rY[29];
            // Units: dimensionless; Initial value: 2.29955624e-09
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
            // Units: dimensionless; Initial value: 1.975541357e-05
            double var_chaste_interface__INa__na6 = rY[50];
            // Units: dimensionless; Initial value: 1.57442749e-08
            double var_chaste_interface__INa__na7 = rY[51];
            // Units: dimensionless; Initial value: 2.856607179e-09
            double var_chaste_interface__IKr__OHerg = rY[61];
            // Units: dimensionless; Initial value: 9.511789113e-06
            double var_chaste_interface__IKs__O1ks = rY[65];
            // Units: dimensionless; Initial value: 2.491710696e-07
            double var_chaste_interface__IKs__O2ks = rY[66];
            // Units: dimensionless; Initial value: 1.298547822e-05
            
            const double var_x0 = 1 / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki;
            const double var_x1 = log(4.0 * var_x0);
            const double var_x2 = exp(0.047170872694120618 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V - 1.26 * var_x1);
            const double var_x3 = 0.93999999999999995 + var_x2;
            const double var_x4 = 1 / var_x3;
            const double var_x5 = exp(-0.024334180358078095 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x6 = 1.0 + 0.20000000000000001 * var_x5;
            const double var_x7 = 1 / var_x6;
            const double var_x8 = var_x5 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
            const double var_x9 = exp(0.013103020192811281 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x10 = var_x9 * pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 3);
            const double var_x11 = var_x7 * (63951.97804201502 * var_x8 + 0.026206040385622562 * var_x10);
            const double var_x12 = var_x2 * (-26.71139896373057 * var_x1 + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) / pow(var_x3, 2);
            const double var_x13 = 2.0 * var_x10 - 2628072.0 * var_x8;
            const double var_x14 = var_x13 * var_x5 / pow(var_x6, 2);
            const double var_x15 = 1 / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai;
            const double var_x16 = pow(var_x15, 1.5);
            const double var_x17 = exp(-0.003743720055088938 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x18 = exp(2.0505200594353643);
            const double var_x19 = exp(-0.049791476732682874 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x20 = 1.0 + 0.1245 * var_x17 + 0.036499999999999998 * var_x19 * (-0.14285714285714285 + 0.14285714285714285 * var_x18);
            const double var_x21 = (0.00046609314685857277 * var_x17 + 0.049791476732682874 * var_x19 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x18)) / (pow(var_x20, 2) * (1.0 + 89.442719099991592 * var_x16));
            const double var_x22 = exp(0.03743720055088938 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x23 = -1.0 + var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = var_x24 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14;
            const double var_x26 = var_x22 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki;
            const double var_x27 = -4.0 + var_x26;
            const double var_x28 = 0.00015031321966819388 * var_x27;
            const double var_x29 = var_x22 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai;
            const double var_x30 = -138.0 + var_x29;
            const double var_x31 = 3.006264393363878e-6 * var_x30;
            const double var_x32 = exp(0.074874401101778759 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x33 = -1.0 + var_x32;
            const double var_x34 = 1 / var_x33;
            const double var_x35 = -0.68200000000000005 + 0.001 * var_x32;
            const double var_x36 = var_x34 * var_x35;
            const double var_x37 = 24.975247492871414 * var_x36;
            const double var_x38 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa;
            const double var_x39 = pow(var_x23, (-2));
            const double var_x40 = var_x22 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
            const double var_x41 = var_x39 * var_x40 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14;
            const double var_x42 = var_x27 * var_x41;
            const double var_x43 = var_x30 * var_x41;
            const double var_x44 = var_x25 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
            const double var_x45 = var_x26 * var_x44;
            const double var_x46 = var_x37 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
            const double var_x47 = var_x46 >= 0;
            const double var_x48 = ((var_x47) ? (0) : (var_x46));
            const double var_x49 = 1 / (1.0 - 3.773584905660377 * var_x48);
            const double var_x50 = var_x27 * var_x49;
            const double var_x51 = 0.01156711037185033 * var_x50;
            const double var_x52 = var_x24 * var_x38;
            const double var_x53 = var_x29 * var_x44;
            const double var_x54 = var_x32 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
            const double var_x55 = var_x34 * var_x54;
            const double var_x56 = 0.0018700066983974486 * var_x55;
            const double var_x57 = var_x35 * var_x54 / pow(var_x33, 2);
            const double var_x58 = 1.8700066983974486 * var_x57;
            const double var_x59 = var_x38 * var_x39 * var_x40 * var_x50;
            const double var_x60 = var_x24 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
            const double var_x61 = var_x38 * var_x60;
            const double var_x62 = var_x27 * var_x61 * ((var_x47) ? (0) : (var_x37 + var_x56 - var_x58)) / pow((0.26500000000000001 - var_x48), 2);
            const double var_x63 = var_x49 * var_x61;
            const double var_x64 = var_x26 * var_x63;
            
            partialF = -0.0010768399999999999 + 0.00043304023078523341 * var_x59 + 0.01182150430414204 * var_x12 + 5.6273061501680649e-6 * var_x42 + 1.1254612300336129e-7 * var_x43 - 0.018599999999999998 * var_chaste_interface__IKr__OHerg - 0.25061025223761596 * var_x4 - 56.32 * var_chaste_interface__INa__na6 - 56.32 * var_chaste_interface__INa__na7 - 0.0035000000000000001 * var_chaste_interface__IKs__O1ks - 0.0035000000000000001 * var_chaste_interface__IKs__O2ks - 0.077520800000000001 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 - 9.6051213058629282e-7 * var_x14 - 0.0030652842485403373 * var_x62 - 1.736 * var_x21 - 0.00043304023078523341 * var_x64 - 5.6273061501680649e-6 * var_x45 - 0.00019735863638148724 * var_x11 - 1.1254612300336129e-7 * var_x53 + var_x38 * var_x58 - var_x25 * var_x28 - var_x25 * var_x31 - var_x37 * var_x38 - var_x38 * var_x56 - var_x51 * var_x52;
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rY[1];
        // Units: mM; Initial value: 9.798304162
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
        // Units: mM; Initial value: 8.601192016e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
        // Units: dimensionless; Initial value: 1.975541357e-05
        double var_chaste_interface__INa__na6 = rY[50];
        // Units: dimensionless; Initial value: 1.57442749e-08
        double var_chaste_interface__INa__na7 = rY[51];
        // Units: dimensionless; Initial value: 2.856607179e-09
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Acap = 0.00015339999999999999; // cm2
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C = 0.001 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Acap; // mF
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao = 2.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko = 4.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao = 138.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp = 310.0; // kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo = 2.584e-5; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1 = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo); // F_M_per_coulomb
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax = 2.387; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa = 1.3799999999999999; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo = 1.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa = 87.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai = 20.0; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na = 1.0 + 0.1245 * exp(-0.10000000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K = 1.0 + pow((var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai), 1.5); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx = 0.00020000000000000001 * pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) + 0.00020000000000000001 * pow(var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa, 3); // mM3
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__eta = 0.34999999999999998; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 3) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao * exp(var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT * var_COMPUTE_INaK_INaCa_ICab_IpCa__eta); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx = pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa = 0.44; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat = 0.20000000000000001; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx = 1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa = (-var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx + var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx) * var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na = 0.036499999999999998 * var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma * exp(-1.3300000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK = 1 / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na + var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK = var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax * var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K * var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK / var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa = 56.32; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab = 0.001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac = 0.88900000000000001; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale = 0.872; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 = 4.2986000000000001e-7 * (1.0 - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // litre_per_farad_second
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2 = -1.0 + exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na = 0.02 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_Na / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_REVERSAL_POTENTIALS__ENa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNab; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa = (-var_COMPUTE_REVERSAL_POTENTIALS__ENa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__INa__na6 + var_chaste_interface__INa__na7) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GNa; // uA_per_uF
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = (-var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_Na - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INa - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__INab - 3.0 * var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa - 3.0 * var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1; // mM / ms

        return d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rY[1];
            // Units: mM; Initial value: 9.798304162
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
            // Units: dimensionless; Initial value: 1.975541357e-05
            double var_chaste_interface__INa__na6 = rY[50];
            // Units: dimensionless; Initial value: 1.57442749e-08
            double var_chaste_interface__INa__na7 = rY[51];
            // Units: dimensionless; Initial value: 2.856607179e-09
            
            const double var_x5 = exp(-0.024334180358078095 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x6 = 1.0 + 0.20000000000000001 * var_x5;
            const double var_x7 = 1 / var_x6;
            const double var_x9 = exp(0.013103020192811281 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x15 = 1 / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai;
            const double var_x16 = pow(var_x15, 1.5);
            const double var_x17 = exp(-0.003743720055088938 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x18 = exp(2.0505200594353643);
            const double var_x19 = exp(-0.049791476732682874 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x20 = 1.0 + 0.1245 * var_x17 + 0.036499999999999998 * var_x19 * (-0.14285714285714285 + 0.14285714285714285 * var_x18);
            const double var_x22 = exp(0.03743720055088938 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x23 = -1.0 + var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = var_x24 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14;
            const double var_x40 = var_x22 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
            const double var_x65 = var_x15 * (var_chaste_interface__INa__na6 + var_chaste_interface__INa__na7);
            const double var_x66 = var_x7 * var_x9 * pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 2);
            const double var_x67 = var_x15 * var_x16 / (var_x20 * pow((0.011180339887498949 + var_x16), 2));
            const double var_x68 = var_x25 * var_x40;
            
            partialF = -1.8494079065353104e-10 * var_x68 - 5.3730734579697901e-6 * var_x67 - 0.092547526753060952 * var_x65 - 1.6432444380870198e-6 * var_x15 - 2.1854162994937459e-7 * var_x66;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rY[1];
        // Units: mM; Initial value: 9.798304162
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = rY[2];
        // Units: mM; Initial value: 125.5589432
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
        // Units: dimensionless; Initial value: 7.757981563e-12
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
        // Units: dimensionless; Initial value: 0.9997157074
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rY[29];
        // Units: dimensionless; Initial value: 2.29955624e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
        // Units: dimensionless; Initial value: 1.975541357e-05
        double var_chaste_interface__IKr__OHerg = rY[61];
        // Units: dimensionless; Initial value: 9.511789113e-06
        double var_chaste_interface__IKs__O1ks = rY[65];
        // Units: dimensionless; Initial value: 2.491710696e-07
        double var_chaste_interface__IKs__O2ks = rY[66];
        // Units: dimensionless; Initial value: 1.298547822e-05
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Acap = 0.00015339999999999999; // cm2
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C = 0.001 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Acap; // mF
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao = 2.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko = 4.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao = 138.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp = 310.0; // kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo = 2.584e-5; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1 = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo); // F_M_per_coulomb
        const double var_COMPUTE_ICa_ICaK__ICahalf = -0.26500000000000001; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Pscale = 7.0; // dimensionless
        const double var_COMPUTE_ICa_ICaK__PCa = 0.00024689999999999998 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__PK = 4.5740000000000001e-7 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_ICa_ICaK__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_ICa_ICaK__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_ICa_ICaK__a1_Ca = 0.001 * exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT) - 0.34100000000000003 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao; // mM
        const double var_COMPUTE_ICa_ICaK__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // mM
        const double var_COMPUTE_ICa_ICaK__a2_Ca = -1.0 + exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICamax = 4.0 * var_COMPUTE_ICa_ICaK__PCa * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_Ca / var_COMPUTE_ICa_ICaK__a2_Ca; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__Icabar = ((var_COMPUTE_ICa_ICaK__ICamax >= 0) ? (0) : (var_COMPUTE_ICa_ICaK__ICamax)); // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__PKprime = var_COMPUTE_ICa_ICaK__PK / (1.0 + var_COMPUTE_ICa_ICaK__Icabar / var_COMPUTE_ICa_ICaK__ICahalf); // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__a2_K = -1.0 + exp(var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICaK = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__PKprime * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_K / var_COMPUTE_ICa_ICaK__a2_K; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax = 2.387; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo = 1.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai = 20.0; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmKo); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na = 1.0 + 0.1245 * exp(-0.10000000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K = 1.0 + pow((var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNai / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai), 1.5); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na = 0.036499999999999998 * var_COMPUTE_INaK_INaCa_ICab_IpCa__sigma * exp(-1.3300000000000001 * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK = 1 / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_Na + var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_Na); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK = var_COMPUTE_INaK_INaCa_ICab_IpCa__INaKmax * var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_K * var_COMPUTE_INaK_INaCa_ICab_IpCa__fNaK / var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_K; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 = 0.12530512611880798; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr = 0.018599999999999998; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs = 0.0035000000000000001; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac = 0.88900000000000001; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale = 0.872; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43 = 0.10000000000000001 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // mS_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 = 4.2986000000000001e-7 * (1.0 - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__Kv43Frac) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__KvScale; // litre_per_farad_second
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K = -var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki * exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // mM
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2 = -1.0 + exp(var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VF_over_RT); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__PKv14 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__VFsq_over_RT * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a1_K / var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__a2; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo = 0.5 * sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko); // dimensionless
        const double var_COMPUTE_REVERSAL_POTENTIALS__EK = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki); // mV
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43 = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKv43; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf = 1 / (0.93999999999999995 + exp(1.26 * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F)); // dimensionless
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 = sqrt(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ko) * (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GK1 * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__K1_inf; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKr * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__fKo * var_chaste_interface__IKr__OHerg; // uA_per_uF
        const double var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs = (-var_COMPUTE_REVERSAL_POTENTIALS__EK + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * (var_chaste_interface__IKs__O1ks + var_chaste_interface__IKs__O2ks) * var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__GKs; // uA_per_uF
        const double var_I_stimulus__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_I_stimulus__i_Stim = var_I_stimulus__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = (-var_COMPUTE_ICa_ICaK__ICaK - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IK1 - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKr - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKs - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv14_K - var_COMPUTE_INa_IKr_IKs_Ito1_IK1_INab_IKp__IKv43 - var_I_stimulus__i_Stim + 2.0 * var_COMPUTE_INaK_INaCa_ICab_IpCa__INaK) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1; // mM / ms

        return d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki = rY[2];
            // Units: mM; Initial value: 125.5589432
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
            // Units: dimensionless; Initial value: 7.757981563e-12
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
            // Units: dimensionless; Initial value: 0.9997157074
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rY[29];
            // Units: dimensionless; Initial value: 2.29955624e-09
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
            // Units: dimensionless; Initial value: 1.975541357e-05
            double var_chaste_interface__IKr__OHerg = rY[61];
            // Units: dimensionless; Initial value: 9.511789113e-06
            double var_chaste_interface__IKs__O1ks = rY[65];
            // Units: dimensionless; Initial value: 2.491710696e-07
            double var_chaste_interface__IKs__O2ks = rY[66];
            // Units: dimensionless; Initial value: 1.298547822e-05
            
            const double var_x0 = 1 / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki;
            const double var_x1 = log(4.0 * var_x0);
            const double var_x2 = exp(0.047170872694120618 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V - 1.26 * var_x1);
            const double var_x3 = 0.93999999999999995 + var_x2;
            const double var_x4 = 1 / var_x3;
            const double var_x12 = var_x2 * (-26.71139896373057 * var_x1 + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) / pow(var_x3, 2);
            const double var_x22 = exp(0.03743720055088938 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x23 = -1.0 + var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = var_x24 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14;
            const double var_x32 = exp(0.074874401101778759 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x33 = -1.0 + var_x32;
            const double var_x34 = 1 / var_x33;
            const double var_x35 = -0.68200000000000005 + 0.001 * var_x32;
            const double var_x36 = var_x34 * var_x35;
            const double var_x37 = 24.975247492871414 * var_x36;
            const double var_x38 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa;
            const double var_x40 = var_x22 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
            const double var_x46 = var_x37 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
            const double var_x47 = var_x46 >= 0;
            const double var_x48 = ((var_x47) ? (0) : (var_x46));
            const double var_x49 = 1 / (1.0 - 3.773584905660377 * var_x48);
            const double var_x60 = var_x24 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V;
            const double var_x61 = var_x38 * var_x60;
            const double var_x63 = var_x49 * var_x61;
            const double var_x68 = var_x25 * var_x40;
            const double var_x69 = var_x0 * (var_chaste_interface__IKs__O1ks + var_chaste_interface__IKs__O2ks);
            const double var_x70 = var_x0 * var_chaste_interface__IKr__OHerg;
            const double var_x71 = var_x0 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43;
            const double var_x72 = var_x0 * var_x4;
            const double var_x73 = var_x0 * var_x12;
            const double var_x74 = var_x22 * var_x63;
            
            partialF = 1.9425621197603171e-5 * var_x73 - 0.00012738562343605624 * var_x71 - 3.0564346548418563e-5 * var_x70 - 9.2470395326765519e-9 * var_x68 - 7.1159095070575419e-7 * var_x74 - 5.7513555333045694e-6 * var_x69 - 0.00041181390311704753 * var_x72;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rY[1];
        // Units: mM; Initial value: 9.798304162
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
        // Units: mM; Initial value: 8.601192016e-05
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR = rY[6];
        // Units: mM; Initial value: 0.2855294915
        double var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa = rY[7];
        // Units: dimensionless; Initial value: 0.08046584973
        double var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa = rY[8];
        // Units: dimensionless; Initial value: 0.9772152481
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Acap = 0.00015339999999999999; // cm2
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C = 0.001 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Acap; // mF
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao = 2.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao = 138.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp = 310.0; // kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo = 2.584e-5; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1 = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo); // F_M_per_coulomb
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__KSR = 1.2; // mM
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Kfb = 0.00016799999999999999; // mM
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Krb = 3.29; // mM
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nfb = 1.2; // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nrb = 1.0; // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__fb = pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Kfb), var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nfb); // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__rb = pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Krb), var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nrb); // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tauxfer = 26.699999999999999; // ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jxfer = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS) / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tauxfer; // mM_per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxf = 7.4800000000000002e-5; // per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxr = 0.00031799999999999998; // per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jup = (var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__fb * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxf - var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__rb * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxr) * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__KSR / (1.0 + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__fb + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__rb); // mM_per_ms
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab = 7.6840000000000003e-5; // mS_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax = 0.050000000000000003; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa = 1.3799999999999999; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa = 87.5; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa = 0.00050000000000000001; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCamax / (var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmpCa); // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao + var_COMPUTE_INaK_INaCa_ICab_IpCa__KmCa; // mM
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx = 0.00020000000000000001 * pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) + 0.00020000000000000001 * pow(var_COMPUTE_INaK_INaCa_ICab_IpCa__KmNa, 3); // mM3
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__eta = 0.34999999999999998; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 3) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao * exp(var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT * var_COMPUTE_INaK_INaCa_ICab_IpCa__eta); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx = pow(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nao, 3) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // mM4
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa = 0.44; // uA_per_uF
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat = 0.20000000000000001; // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx = 1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__ksat * exp((-1.0 + var_COMPUTE_INaK_INaCa_ICab_IpCa__eta) * var_COMPUTE_INaK_INaCa_ICab_IpCa__VF_over_RT); // dimensionless
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa = (-var_COMPUTE_INaK_INaCa_ICab_IpCa__a2_ncx + var_COMPUTE_INaK_INaCa_ICab_IpCa__a1_ncx) * var_COMPUTE_INaK_INaCa_ICab_IpCa__kNaCa / (var_COMPUTE_INaK_INaCa_ICab_IpCa__a3_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a4_ncx * var_COMPUTE_INaK_INaCa_ICab_IpCa__a5_ncx); // uA_per_uF
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CMDNtot = 0.050000000000000003; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__EGTAtot = 0; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNtot = 0.14000000000000001; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN = 0.0023800000000000002; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA = 0.00014999999999999999; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNtot = 0.070000000000000007; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_i = 1 / (1.0 + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CMDNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN), 2) + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__EGTAtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA), 2)); // dimensionless
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_minus = 6.6000000000000005e-5; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_plus = 20.0; // per_mM_per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dHTRPNCa = -var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_minus + (1.0 - var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_plus; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_minus = 0.040000000000000001; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_plus = 40.0; // per_mM_per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dLTRPNCa = -var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_minus + (1.0 - var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_plus; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__Jtrpn = var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dHTRPNCa + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dLTRPNCa; // mM_per_ms
        const double var_COMPUTE_REVERSAL_POTENTIALS__ECa = 0.5 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F * log(var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai); // mV
        const double var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab = (-var_COMPUTE_REVERSAL_POTENTIALS__ECa + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) * var_COMPUTE_INaK_INaCa_ICab_IpCa__GCab; // uA_per_uF
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = (-var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jup - var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__Jtrpn - 0.5 * (-2.0 * var_COMPUTE_INaK_INaCa_ICab_IpCa__INaCa + var_COMPUTE_INaK_INaCa_ICab_IpCa__ICab + var_COMPUTE_INaK_INaCa_ICab_IpCa__IpCa) * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a1 + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jxfer) * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_i; // mM / ms

        return d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai = rY[1];
            // Units: mM; Initial value: 9.798304162
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
            // Units: mM; Initial value: 8.601192016e-05
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
            // Units: mM; Initial value: 0.0001420215245
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR = rY[6];
            // Units: mM; Initial value: 0.2855294915
            double var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa = rY[7];
            // Units: dimensionless; Initial value: 0.08046584973
            double var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa = rY[8];
            // Units: dimensionless; Initial value: 0.9772152481
            
            const double var_x5 = exp(-0.024334180358078095 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x6 = 1.0 + 0.20000000000000001 * var_x5;
            const double var_x7 = 1 / var_x6;
            const double var_x8 = var_x5 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
            const double var_x9 = exp(0.013103020192811281 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x10 = var_x9 * pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai, 3);
            const double var_x13 = 2.0 * var_x10 - 2628072.0 * var_x8;
            const double var_x75 = 0.00050000000000000001 + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
            const double var_x76 = 1 / var_x75;
            const double var_x77 = 1 / var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
            const double var_x78 = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai / pow(var_x75, 2);
            const double var_x79 = var_x5 * var_x7;
            const double var_x90 = 0.0023800000000000002 + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
            const double var_x91 = 1.0 + 0.00011900000000000002 / pow(var_x90, 2);
            const double var_x92 = 1 / var_x91;
            const double var_x93 = var_x92;
            const double var_x94 = 1.5379617895699322e-6 * var_x76;
            const double var_x95 = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai, 1.2);
            const double var_x96 = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR, 1.0);
            const double var_x97 = 1 / (1.0 + 33855.471141425078 * var_x95 + 0.303951367781155 * var_x96);
            const double var_x98 = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai, 0.19999999999999996);
            const double var_x99 = var_x97 * var_x98;
            const double var_x100 = 2.532389241378596 * var_x95 - 9.6656534954407287e-5 * var_x96;
            const double var_x101 = var_x100 / pow((2.9537323401073989e-5 + var_x95 + 8.9779098483507565e-6 * var_x96), 2);
            const double var_x102 = var_x101 * var_x98;
            const double var_x103 = 2.8000000000000003 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
            
            partialF = var_x93 * (-5.6374531835205994 - var_x94 + 2.8000000000000003 * var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa + 2.8000000000000003 * var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa + 1.5379617895699322e-6 * var_x78 + 4.2533745697546539e-5 * var_x102 - 0.03190795213912849 * var_x79 - 3.1566725655651652e-8 * var_x77 - 3.6466405075851775 * var_x99) + 0.00023800000000000004 * (0.0028000000000000004 * var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa + 9.2400000000000013e-6 * var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa + 3.1566725655651652e-8 * log(2.0 * var_x77) + 0.037453183520599252 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS - 0.037453183520599252 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai - 2.3635396782110715e-9 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V - var_x103 * (1.0 - var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa) - var_x103 * (1.0 - var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa) - var_x94 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + 1.2141201663854144e-8 * var_x13 * var_x7 - 1.2 * var_x100 * var_x97) / (pow(var_x90, 3) * pow(var_x91, 2));
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
        // Units: mM; Initial value: 8.601192016e-05
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR = rY[5];
        // Units: mM; Initial value: 0.2852239446
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR = rY[10];
        // Units: dimensionless; Initial value: 3.97392006e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = rY[12];
        // Units: dimensionless; Initial value: 0.0006601783287
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
        // Units: dimensionless; Initial value: 7.757981563e-12
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
        // Units: dimensionless; Initial value: 0.9997157074
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Acap = 0.00015339999999999999; // cm2
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C = 0.001 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Acap; // mF
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao = 2.0; // mM
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp = 310.0; // kelvin
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Temp / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VJSR = 1.6e-7; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VSS = 1.2e-9; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo = 2.584e-5; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a2 = 0.5 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__C / (var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VSS); // F_M_per_coulomb
        const double var_COMPUTE_ICa_ICaK__Pscale = 7.0; // dimensionless
        const double var_COMPUTE_ICa_ICaK__PCa = 0.00024689999999999998 * var_COMPUTE_ICa_ICaK__Pscale; // litre_per_farad_second
        const double var_COMPUTE_ICa_ICaK__VF_over_RT = var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__RT_over_F; // dimensionless
        const double var_COMPUTE_ICa_ICaK__VFsq_over_RT = 1000.0 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday * var_COMPUTE_ICa_ICaK__VF_over_RT; // coulomb_per_millimole
        const double var_COMPUTE_ICa_ICaK__a1_Ca = 0.001 * exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT) - 0.34100000000000003 * var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cao; // mM
        const double var_COMPUTE_ICa_ICaK__a2_Ca = -1.0 + exp(2.0 * var_COMPUTE_ICa_ICaK__VF_over_RT); // dimensionless
        const double var_COMPUTE_ICa_ICaK__ICamax = 4.0 * var_COMPUTE_ICa_ICaK__PCa * var_COMPUTE_ICa_ICaK__VFsq_over_RT * var_COMPUTE_ICa_ICaK__a1_Ca / var_COMPUTE_ICa_ICaK__a2_Ca; // uA_per_uF
        const double var_COMPUTE_ICa_ICaK__ICa = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa * var_COMPUTE_ICa_ICaK__ICamax; // uA_per_uF
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tauxfer = 26.699999999999999; // ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jxfer = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS) / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tauxfer; // mM_per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__v1 = 1.8; // per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jrel = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR) * (var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR + var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR) * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__v1; // mM_per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CMDNtot = 0.050000000000000003; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__EGTAtot = 0; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN = 0.0023800000000000002; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA = 0.00014999999999999999; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_SS = 1 / (1.0 + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CMDNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCMDN), 2) + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__EGTAtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmEGTA), 2)); // dimensionless
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = (-var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__a2 * var_COMPUTE_ICa_ICaK__ICa + var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VJSR * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jrel / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VSS - var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jxfer / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VSS) * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_SS; // mM / ms

        return d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
            // Units: mM; Initial value: 8.601192016e-05
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
            // Units: mM; Initial value: 0.0001420215245
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR = rY[5];
            // Units: mM; Initial value: 0.2852239446
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR = rY[10];
            // Units: dimensionless; Initial value: 3.97392006e-09
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = rY[12];
            // Units: dimensionless; Initial value: 0.0006601783287
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
            // Units: dimensionless; Initial value: 7.757981563e-12
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
            // Units: dimensionless; Initial value: 0.9997157074
            
            const double var_x32 = exp(0.074874401101778759 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x33 = -1.0 + var_x32;
            const double var_x34 = 1 / var_x33;
            const double var_x35 = -0.68200000000000005 + 0.001 * var_x32;
            const double var_x36 = var_x34 * var_x35;
            const double var_x38 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa;
            const double var_x104 = 16.54232713906077 * var_x36;
            const double var_x105 = var_x104 * var_x38;
            const double var_x106 = 0.0023800000000000002 + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
            const double var_x107 = 1.0 + 0.00011900000000000002 / pow(var_x106, 2);
            const double var_x108 = 1 / var_x107;
            const double var_x109 = var_x108;
            const double var_x110 = 240.0 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR;
            const double var_x111 = 240.0 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR;
            const double var_x112 = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR) * (var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR + var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR);
            
            partialF = var_x109 * (-806.49188514357058 - var_x110 - var_x111) + 0.00023800000000000004 * (806.49188514357058 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai + 240.0 * var_x112 - 806.49188514357058 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS - var_x105 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V) / (pow(var_x106, 3) * pow(var_x107, 2));
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR = rY[5];
        // Units: mM; Initial value: 0.2852239446
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR = rY[6];
        // Units: mM; Initial value: 0.2855294915
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR = rY[10];
        // Units: dimensionless; Initial value: 3.97392006e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = rY[12];
        // Units: dimensionless; Initial value: 0.0006601783287
        
        
        // Mathematics
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tautr = 0.57469999999999999; // ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jtr = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR) / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tautr; // mM_per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__v1 = 1.8; // per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jrel = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR) * (var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR + var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR) * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__v1; // mM_per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CSQNtot = 15.0; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCSQN = 0.80000000000000004; // mM
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_JSR = 1 / (1.0 + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__CSQNtot * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCSQN / pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR + var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__KmCSQN), 2)); // dimensionless
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR = (-var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jrel + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jtr) * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__beta_JSR; // mM / ms

        return d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
            // Units: mM; Initial value: 0.0001420215245
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR = rY[5];
            // Units: mM; Initial value: 0.2852239446
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR = rY[6];
            // Units: mM; Initial value: 0.2855294915
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR = rY[10];
            // Units: dimensionless; Initial value: 3.97392006e-09
            double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = rY[12];
            // Units: dimensionless; Initial value: 0.0006601783287
            
            const double var_x112 = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR) * (var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR + var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR);
            const double var_x115 = 1.8 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR;
            const double var_x116 = 1.8 * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR;
            const double var_x117 = 0.80000000000000004 + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR;
            const double var_x118 = pow(var_x117, (-2));
            const double var_x119 = 1 / (1.0 + 12.0 * var_x118);
            const double var_x120 = var_x119;
            
            partialF = var_x120 * (-1.7400382808421786 - var_x115 - var_x116) + 0.16666666666666666 * (1.7400382808421786 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR - 1.8 * var_x112 - 1.7400382808421786 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR) / (pow(var_x117, 3) * pow((0.083333333333333329 + var_x118), 2));
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
        // Units: mM; Initial value: 8.601192016e-05
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR = rY[5];
        // Units: mM; Initial value: 0.2852239446
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR = rY[6];
        // Units: mM; Initial value: 0.2855294915
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VJSR = 1.6e-7; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VNSR = 2.0999999999999998e-6; // uL
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo = 2.584e-5; // uL
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__KSR = 1.2; // mM
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Kfb = 0.00016799999999999999; // mM
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Krb = 3.29; // mM
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nfb = 1.2; // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nrb = 1.0; // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__fb = pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Kfb), var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nfb); // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__rb = pow((var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Krb), var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Nrb); // dimensionless
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tautr = 0.57469999999999999; // ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jtr = (-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR + var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR) / var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__tautr; // mM_per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxf = 7.4800000000000002e-5; // per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxr = 0.00031799999999999998; // per_ms
        const double var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jup = (var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__fb * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxf - var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__rb * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__vmaxr) * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__KSR / (1.0 + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__fb + var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__rb); // mM_per_ms
        const double d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Vmyo * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jup / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VNSR - var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VJSR * var_COMPUTE_INTRACELLULAR_CALCIUM_FLUXES__Jtr / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__VNSR; // mM / ms

        return d_dt_chaste_interface_var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
            // Units: mM; Initial value: 8.601192016e-05
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR = rY[6];
            // Units: mM; Initial value: 0.2855294915
            
            const double var_x95 = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai, 1.2);
            const double var_x96 = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR, 1.0);
            const double var_x97 = 1 / (1.0 + 33855.471141425078 * var_x95 + 0.303951367781155 * var_x96);
            const double var_x100 = 2.532389241378596 * var_x95 - 9.6656534954407287e-5 * var_x96;
            const double var_x101 = var_x100 / pow((2.9537323401073989e-5 + var_x95 + 8.9779098483507565e-6 * var_x96), 2);
            
            partialF = -0.13257434520702313 - 3.9156227113154178e-9 * var_x101 - 0.001427202778983934 * var_x97;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
        // Units: mM; Initial value: 8.601192016e-05
        double var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa = rY[7];
        // Units: dimensionless; Initial value: 0.08046584973
        
        
        // Mathematics
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_minus = 0.040000000000000001; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_plus = 40.0; // per_mM_per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dLTRPNCa = -var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_minus + (1.0 - var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__kltrpn_plus; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa = var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dLTRPNCa; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
            // Units: mM; Initial value: 8.601192016e-05
            
            
            partialF = -0.040000000000000001 - 40.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
        // Units: mM; Initial value: 8.601192016e-05
        double var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa = rY[8];
        // Units: dimensionless; Initial value: 0.9772152481
        
        
        // Mathematics
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_minus = 6.6000000000000005e-5; // per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_plus = 20.0; // per_mM_per_ms
        const double var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dHTRPNCa = -var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_minus + (1.0 - var_chaste_interface__COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa) * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai * var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__khtrpn_plus; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa = var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__dHTRPNCa; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai = rY[3];
            // Units: mM; Initial value: 8.601192016e-05
            
            
            partialF = -6.6000000000000005e-5 - 20.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR = rY[9];
        // Units: dimensionless; Initial value: 0.4448038946
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = rY[12];
        // Units: dimensionless; Initial value: 0.0006601783287
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaminus = 0.57599999999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaplus = 0.012149999999999999; // per_uM4_per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__ncoop = 4.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC1_RyR = var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaminus - pow((1000.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS), var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__ncoop) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaplus; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR = var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC1_RyR; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
            // Units: mM; Initial value: 0.0001420215245
            
            const double var_x124 = 12150000000.0 * pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS, 4.0);
            
            partialF = -var_x124;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR = rY[10];
        // Units: dimensionless; Initial value: 3.97392006e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = rY[12];
        // Units: dimensionless; Initial value: 0.0006601783287
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbminus = 1.9299999999999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbplus = 0.0040499999999999998; // per_uM3_per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__mcoop = 3.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO2_RyR = -var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbminus + pow((1000.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS), var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__mcoop) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbplus; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR = var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO2_RyR; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -1.9299999999999999;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR = rY[11];
        // Units: dimensionless; Initial value: 0.554535924
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = rY[12];
        // Units: dimensionless; Initial value: 0.0006601783287
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcminus = 0.00080000000000000004; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcplus = 0.10000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC2_RyR = var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcplus - var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcminus; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR = var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC2_RyR; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.00080000000000000004;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR = rY[9];
        // Units: dimensionless; Initial value: 0.4448038946
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR = rY[10];
        // Units: dimensionless; Initial value: 3.97392006e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR = rY[11];
        // Units: dimensionless; Initial value: 0.554535924
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = rY[12];
        // Units: dimensionless; Initial value: 0.0006601783287
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaminus = 0.57599999999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaplus = 0.012149999999999999; // per_uM4_per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbminus = 1.9299999999999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbplus = 0.0040499999999999998; // per_uM3_per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcminus = 0.00080000000000000004; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcplus = 0.10000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC2_RyR = var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcplus - var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kcminus; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__mcoop = 3.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO2_RyR = -var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbminus + pow((1000.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS), var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__mcoop) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kbplus; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__ncoop = 4.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC1_RyR = var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaminus - pow((1000.0 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS), var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__ncoop) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR * var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__kaplus; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO1_RyR = -var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC1_RyR - var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dC2_RyR - var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO2_RyR; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR = var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__dO1_RyR; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
            // Units: mM; Initial value: 0.0001420215245
            
            const double var_x122 = pow(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS, 3.0);
            const double var_x126 = 4050000.0 * var_x122;
            
            partialF = -0.67599999999999993 - var_x126;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 = rY[13];
        // Units: dimensionless; Initial value: 0.8621934054
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 = rY[14];
        // Units: dimensionless; Initial value: 0.01141398211
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 = rY[18];
        // Units: dimensionless; Initial value: 0.1198547081
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha = 1.9967999999999999 * exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_C1 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta = 0.088200000000000001 * exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C0 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_C1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega = 0.0025000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C0 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C0 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C0; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
            // Units: mM; Initial value: 0.0001420215245
            
            const double var_x129 = exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x133 = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
            const double var_x134 = 7.9871999999999996 * var_x129;
            const double var_x135 = -var_x134;
            
            partialF = var_x135 - var_x133;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 = rY[13];
        // Units: dimensionless; Initial value: 0.8621934054
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 = rY[14];
        // Units: dimensionless; Initial value: 0.01141398211
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 = rY[15];
        // Units: dimensionless; Initial value: 5.666325225e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 = rY[19];
        // Units: dimensionless; Initial value: 0.006346794302
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha = 1.9967999999999999 * exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_C1 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta = 0.088200000000000001 * exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C1 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C1 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega = 0.0025000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C1 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_C1 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C1 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C1; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
            // Units: mM; Initial value: 0.0001420215245
            
            const double var_x127 = exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x129 = exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x136 = 0.088200000000000001 * var_x127;
            const double var_x140 = 5.9903999999999993 * var_x129;
            const double var_x141 = 0.11079599999999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
            const double var_x142 = -var_x136;
            
            partialF = var_x142 - var_x140 - var_x141;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 = rY[14];
        // Units: dimensionless; Initial value: 0.01141398211
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 = rY[15];
        // Units: dimensionless; Initial value: 5.666325225e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 = rY[16];
        // Units: dimensionless; Initial value: 1.25021357e-07
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 = rY[20];
        // Units: dimensionless; Initial value: 0.0001260326488
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha = 1.9967999999999999 * exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C3 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta = 0.088200000000000001 * exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C1 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C2 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega = 0.0025000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C2 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_C2 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C2 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C2; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
            // Units: mM; Initial value: 0.0001420215245
            
            const double var_x127 = exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x129 = exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x143 = 0.1764 * var_x127;
            const double var_x148 = 0.22159199999999998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
            const double var_x149 = -var_x143;
            const double var_x150 = 3.9935999999999998 * var_x129;
            const double var_x151 = -var_x150;
            
            partialF = var_x149 + var_x151 - var_x148;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 = rY[15];
        // Units: dimensionless; Initial value: 5.666325225e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 = rY[16];
        // Units: dimensionless; Initial value: 1.25021357e-07
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 = rY[17];
        // Units: dimensionless; Initial value: 1.034426748e-10
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 = rY[21];
        // Units: dimensionless; Initial value: 1.112315238e-06
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha = 1.9967999999999999 * exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C3 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta = 0.088200000000000001 * exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_C3 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C3 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega = 0.0025000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C3 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_C3 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_C3 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C3; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
            // Units: mM; Initial value: 0.0001420215245
            
            const double var_x127 = exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x129 = exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x152 = 0.2646 * var_x127;
            const double var_x156 = 0.44318399999999997 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
            const double var_x157 = 1.9967999999999999 * var_x129;
            
            partialF = -var_x152 - var_x156 - var_x157;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 = rY[16];
        // Units: dimensionless; Initial value: 1.25021357e-07
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 = rY[17];
        // Units: dimensionless; Initial value: 1.034426748e-10
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 = rY[22];
        // Units: dimensionless; Initial value: 3.681315892e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
        // Units: dimensionless; Initial value: 7.757981563e-12
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha = 1.9967999999999999 * exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta = 0.088200000000000001 * exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_C3 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__fL = 0.29999999999999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gL = 4.0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_CCa4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C4 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_C3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_CCa4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__fL) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega = 0.0025000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_C4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C4 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_C4 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_C4 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gL; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_C4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_C4; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
            // Units: mM; Initial value: 0.0001420215245
            
            const double var_x127 = exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x158 = 0.3528 * var_x127;
            const double var_x160 = 0.88636799999999993 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS;
            
            partialF = -0.29999999999999999 - var_x158 - var_x160;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 = rY[13];
        // Units: dimensionless; Initial value: 0.8621934054
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 = rY[18];
        // Units: dimensionless; Initial value: 0.1198547081
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 = rY[19];
        // Units: dimensionless; Initial value: 0.006346794302
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha = 1.9967999999999999 * exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_CCa1 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta = 0.088200000000000001 * exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca0 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa0; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega = 0.0025000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca0 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_CCa1) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca0; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x129 = exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x163 = 15.974399999999999 * var_x129;
            
            partialF = -0.0025000000000000001 - var_x163;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 = rY[14];
        // Units: dimensionless; Initial value: 0.01141398211
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 = rY[18];
        // Units: dimensionless; Initial value: 0.1198547081
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 = rY[19];
        // Units: dimensionless; Initial value: 0.006346794302
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 = rY[20];
        // Units: dimensionless; Initial value: 0.0001260326488
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha = 1.9967999999999999 * exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_CCa1 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta = 0.088200000000000001 * exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa1 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca1 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_CCa1 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa1; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega = 0.0025000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca1 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa0 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa2) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca1; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x127 = exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x129 = exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x164 = 0.0441 * var_x127;
            const double var_x166 = 11.980799999999999 * var_x129;
            
            partialF = -0.00125 - var_x164 - var_x166;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 = rY[15];
        // Units: dimensionless; Initial value: 5.666325225e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 = rY[19];
        // Units: dimensionless; Initial value: 0.006346794302
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 = rY[20];
        // Units: dimensionless; Initial value: 0.0001260326488
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 = rY[21];
        // Units: dimensionless; Initial value: 1.112315238e-06
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha = 1.9967999999999999 * exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa3 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta = 0.088200000000000001 * exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa1 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca2 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_CCa2 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa2; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega = 0.0025000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca2 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa1 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa3) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca2; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x127 = exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x129 = exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x134 = 7.9871999999999996 * var_x129;
            const double var_x135 = -var_x134;
            const double var_x136 = 0.088200000000000001 * var_x127;
            const double var_x142 = -var_x136;
            
            partialF = -0.00062500000000000001 + var_x135 + var_x142;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 = rY[16];
        // Units: dimensionless; Initial value: 1.25021357e-07
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 = rY[20];
        // Units: dimensionless; Initial value: 0.0001260326488
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 = rY[21];
        // Units: dimensionless; Initial value: 1.112315238e-06
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 = rY[22];
        // Units: dimensionless; Initial value: 3.681315892e-09
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha = 1.9967999999999999 * exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa3 = 2.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta = 0.088200000000000001 * exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa2 = 3.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_CCa3 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca3 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_CCa3 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_CCa3; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega = 0.0025000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca3 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa2 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa4) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca3 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca3; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x127 = exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x129 = exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x150 = 3.9935999999999998 * var_x129;
            const double var_x151 = -var_x150;
            const double var_x168 = 0.1323 * var_x127;
            
            partialF = -0.00031250000000000001 + var_x151 - var_x168;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS = rY[4];
        // Units: mM; Initial value: 0.0001420215245
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 = rY[17];
        // Units: dimensionless; Initial value: 1.034426748e-10
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 = rY[21];
        // Units: dimensionless; Initial value: 1.112315238e-06
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 = rY[22];
        // Units: dimensionless; Initial value: 3.681315892e-09
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha = 1.9967999999999999 * exp(-0.41999999999999998 + 0.012 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__alpha_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL = 2.0; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta = 0.088200000000000001 * exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_CCa3 = 4.0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__beta_prime; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma = 0.055397999999999996 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gamma; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0_to_CCa0 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1_to_CCa1 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2_to_CCa2 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_CCa4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3_to_CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__aL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca4 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4_to_CCa4 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_CCa4; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega = 0.0025000000000000001; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__omega; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0_to_C0 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1_to_C1 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2_to_C2 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_C4 = var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3_to_C3 / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__bL; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca4 = (var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_C4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4_to_CCa3) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4 = -var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Ca4 + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a2_Ca4; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x127 = exp(1.4300000000000002 - 0.065000000000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x143 = 0.1764 * var_x127;
            const double var_x149 = -var_x143;
            
            partialF = -0.00015625 + var_x149;
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 = rY[17];
        // Units: dimensionless; Initial value: 1.034426748e-10
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = rY[23];
        // Units: dimensionless; Initial value: 7.757981563e-12
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__fL = 0.29999999999999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gL = 4.0; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open = var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4 * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__fL - var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open * var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__gL; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -4.0;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = rY[24];
        // Units: dimensionless; Initial value: 0.9997157074
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Cainf = 0.81999999999999995; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__tau_yCa = 1 / (0.0033633620945199998 / (0.5 + exp(-0.18053804430634462 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V)) + 0.0077904657073700001 * exp(-0.02019777813343069 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V)); // ms
        const double var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa_inf = 1.0 - var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Cainf + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__a1_Cainf / (1.0 + exp(3.6538461538461537 + 0.12820512820512822 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V)); // dimensionless
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa = (-var_chaste_interface__COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa + var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa_inf) / var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__tau_yCa; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x170 = exp(-0.02019777813343069 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x171 = exp(-0.18053804430634462 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x172 = 0.5 + var_x171;
            const double var_x175 = 0.0033633620945199998 / var_x172;
            const double var_x176 = 0.0077904657073700001 * var_x170;
            
            partialF = -var_x175 - var_x176;
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 = rY[25];
        // Units: dimensionless; Initial value: 0.9513721351
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 = rY[26];
        // Units: dimensionless; Initial value: 0.02668288089
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 = rY[30];
        // Units: dimensionless; Initial value: 0.01513025204
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43 = 0.028982999999999998; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43 = 0.00037301599999999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 = 0.54370799999999997; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_C1Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 = 0.049842400000000002; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_C0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43 = 0.046843700000000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 = 0.080185000000000006; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C043 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C0Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_C0Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 = 0.00081948199999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43 = 5.3739999999999997e-8; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_CI0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C043 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_C1Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_CI0Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C043 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C043; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x177 = exp(5.3739999999999997e-8 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x179 = exp(0.028982999999999998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x185 = 2.1748319999999999 * var_x179;
            const double var_x186 = 0.00081948199999999996 * var_x177;
            
            partialF = -var_x185 - var_x186;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 = rY[25];
        // Units: dimensionless; Initial value: 0.9513721351
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 = rY[26];
        // Units: dimensionless; Initial value: 0.02668288089
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 = rY[27];
        // Units: dimensionless; Initial value: 0.0002806380358
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 = rY[31];
        // Units: dimensionless; Initial value: 0.005442964601
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43 = 0.028982999999999998; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43 = 0.00037301599999999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 = 0.54370799999999997; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_C1Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 = 0.049842400000000002; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43 = 6.7734800000000002; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_C1Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43 = 0.046843700000000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 = 0.080185000000000006; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C1Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C143 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_C1Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C1Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_C1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 = 0.00081948199999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43 = 5.3739999999999997e-8; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43 = 1.8935999999999999; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_CI1Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C143 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C0Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C2Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_CI1Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C143 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C143; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x177 = exp(5.3739999999999997e-8 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x179 = exp(0.028982999999999998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x183 = exp(-0.046843700000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x187 = 0.080185000000000006 * var_x183;
            const double var_x193 = 1.6311239999999998 * var_x179;
            const double var_x194 = 0.0015517711151999999 * var_x177;
            
            partialF = -var_x187 - var_x193 - var_x194;
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative27(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 = rY[26];
        // Units: dimensionless; Initial value: 0.02668288089
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 = rY[27];
        // Units: dimensionless; Initial value: 0.0002806380358
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 = rY[28];
        // Units: dimensionless; Initial value: 1.311837579e-06
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 = rY[32];
        // Units: dimensionless; Initial value: 0.0009918373359
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43 = 0.028982999999999998; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43 = 0.00037301599999999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 = 0.54370799999999997; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C3Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 = 0.049842400000000002; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43 = 15.621270515200001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_C2Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43 = 0.046843700000000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 = 0.080185000000000006; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C1Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_C2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C243 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_C2Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_C2Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_C2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 = 0.00081948199999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43 = 5.3739999999999997e-8; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43 = 14.224647456; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_CI2Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C243 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C1Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_CI2Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C243 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C243; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative27(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x177 = exp(5.3739999999999997e-8 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x179 = exp(0.028982999999999998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x183 = exp(-0.046843700000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x195 = 0.16037000000000001 * var_x183;
            const double var_x201 = 1.0874159999999999 * var_x179;
            const double var_x202 = 0.011656842546537791 * var_x177;
            
            partialF = -var_x195 - var_x201 - var_x202;
        }
        else
        {
            const double y_save = rY[27];
            rY[27] += delta;
            const double temp = EvaluateYDerivative27(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[27])/delta;
            rY[27] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative28(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 = rY[27];
        // Units: dimensionless; Initial value: 0.0002806380358
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 = rY[28];
        // Units: dimensionless; Initial value: 1.311837579e-06
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rY[29];
        // Units: dimensionless; Initial value: 2.29955624e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 = rY[33];
        // Units: dimensionless; Initial value: 9.514386057e-05
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43 = 0.028982999999999998; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43 = 0.00037301599999999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 = 0.54370799999999997; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C3Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_OKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 = 0.049842400000000002; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43 = 28.753260331300002; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_C3Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43 = 0.046843700000000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 = 0.080185000000000006; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_C2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_C3Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C343 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_C3Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_C3Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_C3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 = 0.00081948199999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43 = 5.3739999999999997e-8; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43 = 158.574378389; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_CI3Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C343 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_C2Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_CI3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_OKv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_C343 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_C343; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative28(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x177 = exp(5.3739999999999997e-8 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x179 = exp(0.028982999999999998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x183 = exp(-0.046843700000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x203 = 0.24055500000000002 * var_x183;
            const double var_x209 = 0.54370799999999997 * var_x179;
            const double var_x210 = 0.12994884875097448 * var_x177;
            
            partialF = -var_x203 - var_x209 - var_x210;
        }
        else
        {
            const double y_save = rY[28];
            rY[28] += delta;
            const double temp = EvaluateYDerivative28(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[28])/delta;
            rY[28] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative29(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 = rY[28];
        // Units: dimensionless; Initial value: 1.311837579e-06
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rY[29];
        // Units: dimensionless; Initial value: 2.29955624e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 = rY[34];
        // Units: dimensionless; Initial value: 2.742677382e-06
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43 = 0.028982999999999998; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43 = 0.00037301599999999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 = 0.54370799999999997; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_OKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 = 0.049842400000000002; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43 = 524.57620667900005; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_OKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_O43 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_OKv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_OKv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43 = 0.046843700000000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 = 0.080185000000000006; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_C3Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 = 0.00081948199999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43 = 5.3739999999999997e-8; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43 = 142.93664535100001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_OIKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_O43 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_C3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_OIKv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_O43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_O43; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative29(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x177 = exp(5.3739999999999997e-8 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x183 = exp(-0.046843700000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x211 = 0.32074000000000003 * var_x183;
            const double var_x215 = 0.11713400800552819 * var_x177;
            
            partialF = -var_x211 - var_x215;
        }
        else
        {
            const double y_save = rY[29];
            rY[29] += delta;
            const double temp = EvaluateYDerivative29(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[29])/delta;
            rY[29] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative30(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 = rY[25];
        // Units: dimensionless; Initial value: 0.9513721351
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 = rY[30];
        // Units: dimensionless; Initial value: 0.01513025204
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 = rY[31];
        // Units: dimensionless; Initial value: 0.005442964601
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43 = 0.028982999999999998; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43 = 0.00037301599999999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 = 0.54370799999999997; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 = 0.049842400000000002; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_C0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43 = 6.7734800000000002; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_CI1Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I043 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_C0Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_CI1Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43 = 0.046843700000000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 = 0.080185000000000006; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 = 0.00081948199999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43 = 5.3739999999999997e-8; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_CI0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43 = 1.8935999999999999; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I043 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43_to_CI0Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI0Kv43; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I043 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I043; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative30(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x179 = exp(0.028982999999999998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x181 = exp(-0.00037301599999999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x188 = 0.049842400000000002 * var_x181;
            const double var_x219 = 14.731181055359999 * var_x179;
            
            partialF = -var_x188 - var_x219;
        }
        else
        {
            const double y_save = rY[30];
            rY[30] += delta;
            const double temp = EvaluateYDerivative30(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[30])/delta;
            rY[30] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative31(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 = rY[26];
        // Units: dimensionless; Initial value: 0.02668288089
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 = rY[30];
        // Units: dimensionless; Initial value: 0.01513025204
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 = rY[31];
        // Units: dimensionless; Initial value: 0.005442964601
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 = rY[32];
        // Units: dimensionless; Initial value: 0.0009918373359
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43 = 0.028982999999999998; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43 = 0.00037301599999999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 = 0.54370799999999997; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 = 0.049842400000000002; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43 = 6.7734800000000002; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_CI1Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_C1Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43 = 15.621270515200001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43 = 0.046843700000000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 = 0.080185000000000006; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 = 0.00081948199999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43 = 5.3739999999999997e-8; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43 = 1.8935999999999999; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_CI1Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI0Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I143 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_C1Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI0Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI2Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43 = 14.224647456; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI1Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I143 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43_to_CI1Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43_to_CI1Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI1Kv43; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I143 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I143; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative31(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x179 = exp(0.028982999999999998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x181 = exp(-0.00037301599999999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x183 = exp(-0.046843700000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x196 = 0.0073584627104531205 * var_x181;
            const double var_x220 = 0.042345268272074361 * var_x183;
            const double var_x223 = 3.7617634137599998 * var_x179;
            
            partialF = -var_x196 - var_x220 - var_x223;
        }
        else
        {
            const double y_save = rY[31];
            rY[31] += delta;
            const double temp = EvaluateYDerivative31(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[31])/delta;
            rY[31] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative32(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 = rY[27];
        // Units: dimensionless; Initial value: 0.0002806380358
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 = rY[31];
        // Units: dimensionless; Initial value: 0.005442964601
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 = rY[32];
        // Units: dimensionless; Initial value: 0.0009918373359
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 = rY[33];
        // Units: dimensionless; Initial value: 9.514386057e-05
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43 = 0.028982999999999998; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43 = 0.00037301599999999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 = 0.54370799999999997; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 = 0.049842400000000002; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43 = 6.7734800000000002; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43 = 15.621270515200001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b1Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_C2Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43 = 28.753260331300002; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI3Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43 = 0.046843700000000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 = 0.080185000000000006; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 = 0.00081948199999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43 = 5.3739999999999997e-8; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43 = 1.8935999999999999; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43 = 14.224647456; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_CI2Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI1Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f1Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I243 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_C2Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI1Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI3Kv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43 = 158.574378389; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_CI2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I243 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43_to_CI2Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43_to_CI2Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_CI2Kv43; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I243 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I243; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative32(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x179 = exp(0.028982999999999998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x181 = exp(-0.00037301599999999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x183 = exp(-0.046843700000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x204 = 0.0031906751727717496 * var_x181;
            const double var_x224 = 0.021348622729620501 * var_x183;
            const double var_x227 = 2.0015500855706554 * var_x179;
            
            partialF = -var_x204 - var_x224 - var_x227;
        }
        else
        {
            const double y_save = rY[32];
            rY[32] += delta;
            const double temp = EvaluateYDerivative32(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[32])/delta;
            rY[32] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative33(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 = rY[28];
        // Units: dimensionless; Initial value: 1.311837579e-06
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 = rY[32];
        // Units: dimensionless; Initial value: 0.0009918373359
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 = rY[33];
        // Units: dimensionless; Initial value: 9.514386057e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 = rY[34];
        // Units: dimensionless; Initial value: 2.742677382e-06
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43 = 0.028982999999999998; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43 = 0.00037301599999999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 = 0.54370799999999997; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 = 0.049842400000000002; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43 = 15.621270515200001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43 = 28.753260331300002; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI3Kv43 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b2Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_C3Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43 = 524.57620667900005; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_OIKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43 = 0.046843700000000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 = 0.080185000000000006; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 = 0.00081948199999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43 = 5.3739999999999997e-8; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43 = 14.224647456; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43 = 158.574378389; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_CI3Kv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_CI2Kv43 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f2Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I343 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_C3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_CI2Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_OIKv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43 = 142.93664535100001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_CI3Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I343 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43_to_CI3Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43_to_CI3Kv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_CI3Kv43; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_I343 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_I343; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative33(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x179 = exp(0.028982999999999998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x181 = exp(-0.00037301599999999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x183 = exp(-0.046843700000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x212 = 0.0017334521172801731 * var_x181;
            const double var_x228 = 0.021578581001175438 * var_x183;
            const double var_x231 = 9.9194413744637924 * var_x179;
            
            partialF = -var_x212 - var_x228 - var_x231;
        }
        else
        {
            const double y_save = rY[33];
            rY[33] += delta;
            const double temp = EvaluateYDerivative33(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[33])/delta;
            rY[33] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative34(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 = rY[29];
        // Units: dimensionless; Initial value: 2.29955624e-09
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 = rY[33];
        // Units: dimensionless; Initial value: 9.514386057e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 = rY[34];
        // Units: dimensionless; Initial value: 2.742677382e-06
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43 = 0.028982999999999998; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43 = 0.00037301599999999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 = 0.54370799999999997; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphaa0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aaKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 = 0.049842400000000002; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alphai0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__aiKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43 = 28.753260331300002; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43 = 524.57620667900005; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_OIKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b3Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_OKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__alpha_inact43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__b4Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43 = 0.046843700000000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 = 0.080185000000000006; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betaa0Kv43 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__baKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 = 0.00081948199999999996; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43 = 5.3739999999999997e-8; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__betai0Kv43 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__biKv43); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43 = 158.574378389; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43 = 142.93664535100001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_CI3Kv43 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_act43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f3Kv43 / var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_OIKv43 = var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__beta_inact43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__f4Kv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_OI43 = (var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_CI3Kv43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43_to_OKv43) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_OI43 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43_to_OIKv43 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43 * var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43_to_OIKv43; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43 = -var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a1_OI43 + var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__a2_OI43; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative34(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x181 = exp(-0.00037301599999999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x183 = exp(-0.046843700000000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x216 = 9.5014602960251466e-5 * var_x181;
            const double var_x232 = 0.35582999726621212 * var_x183;
            
            partialF = -var_x216 - var_x232;
        }
        else
        {
            const double y_save = rY[34];
            rY[34] += delta;
            const double temp = EvaluateYDerivative34(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[34])/delta;
            rY[34] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative35(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 = rY[35];
        // Units: dimensionless; Initial value: 0.5977099765
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 = rY[36];
        // Units: dimensionless; Initial value: 0.1730990528
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 = rY[40];
        // Units: dimensionless; Initial value: 0.03539084346
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14 = 0.0076854803100000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 = 1.8400241455399999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_C1Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14 = 0.00305767916; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_C0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14 = 0.077933781739999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 = 0.010817483399999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C0 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C0Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_C0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14 = 2.44936e-6; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_CI0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C0 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_C1Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_CI0Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C0 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C0; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative35(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x235 = exp(0.0076854803100000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x237 = 7.3600965821599997 * var_x235;
            
            partialF = -2.44936e-6 - var_x237;
        }
        else
        {
            const double y_save = rY[35];
            rY[35] += delta;
            const double temp = EvaluateYDerivative35(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[35])/delta;
            rY[35] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative36(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 = rY[35];
        // Units: dimensionless; Initial value: 0.5977099765
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 = rY[36];
        // Units: dimensionless; Initial value: 0.1730990528
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 = rY[37];
        // Units: dimensionless; Initial value: 0.01881072386
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 = rY[41];
        // Units: dimensionless; Initial value: 0.005428824353
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14 = 0.0076854803100000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 = 1.8400241455399999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_C1Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14 = 0.00305767916; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14 = 1.00947847105; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_C1Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14 = 0.077933781739999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 = 0.010817483399999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C1Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C1 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_C1Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C1Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_C1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14 = 2.44936e-6; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14 = 0.52465073996; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_CI1Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C1 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C0Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C2Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_CI1Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C1 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C1; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative36(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x233 = exp(-0.077933781739999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x235 = exp(0.0076854803100000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x238 = 0.010817483399999999 * var_x233;
            const double var_x241 = 5.5200724366199996 * var_x235;
            
            partialF = -1.2850585364284256e-6 - var_x238 - var_x241;
        }
        else
        {
            const double y_save = rY[36];
            rY[36] += delta;
            const double temp = EvaluateYDerivative36(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[36])/delta;
            rY[36] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative37(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 = rY[36];
        // Units: dimensionless; Initial value: 0.1730990528
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 = rY[37];
        // Units: dimensionless; Initial value: 0.01881072386
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 = rY[38];
        // Units: dimensionless; Initial value: 0.000916070135
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 = rY[42];
        // Units: dimensionless; Initial value: 0.02287858869
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14 = 0.0076854803100000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 = 1.8400241455399999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C3Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14 = 0.00305767916; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14 = 1.1710054056700001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_C2Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14 = 0.077933781739999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 = 0.010817483399999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C1Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_C2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C2 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_C2Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_C2Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_C2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14 = 2.44936e-6; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14 = 17.51885408639; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_CI2Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C2 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C1Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_CI2Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C2 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C2; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative37(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x233 = exp(-0.077933781739999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x235 = exp(0.0076854803100000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x242 = 0.021634966799999999 * var_x233;
            const double var_x245 = 3.6800482910799999 * var_x235;
            
            partialF = -4.290998044504021e-5 - var_x242 - var_x245;
        }
        else
        {
            const double y_save = rY[37];
            rY[37] += delta;
            const double temp = EvaluateYDerivative37(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[37])/delta;
            rY[37] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative38(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 = rY[37];
        // Units: dimensionless; Initial value: 0.01881072386
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 = rY[38];
        // Units: dimensionless; Initial value: 0.000916070135
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
        // Units: dimensionless; Initial value: 1.975541357e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 = rY[43];
        // Units: dimensionless; Initial value: 0.03233800003
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14 = 0.0076854803100000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 = 1.8400241455399999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C3Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_OKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14 = 0.00305767916; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14 = 0.63902768757999995; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_C3Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14 = 0.077933781739999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 = 0.010817483399999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_C2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_C3Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C3 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_C3Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_C3Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_C3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14 = 2.44936e-6; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14 = 938.58764534555996; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_CI3Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C3 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_C2Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_CI3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_OKv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_C3 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_C3; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative38(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x233 = exp(-0.077933781739999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x235 = exp(0.0076854803100000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x246 = 0.032452450199999996 * var_x233;
            const double var_x249 = 1.8400241455399999 * var_x235;
            
            partialF = -0.0022989390350036006 - var_x246 - var_x249;
        }
        else
        {
            const double y_save = rY[38];
            rY[38] += delta;
            const double temp = EvaluateYDerivative38(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[38])/delta;
            rY[38] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative39(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 = rY[38];
        // Units: dimensionless; Initial value: 0.000916070135
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
        // Units: dimensionless; Initial value: 1.975541357e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 = rY[44];
        // Units: dimensionless; Initial value: 0.1134082058
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14 = 0.0076854803100000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 = 1.8400241455399999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_OKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14 = 0.00305767916; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14 = 2.1203537909499999; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_OKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_O = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_OKv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_OKv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14 = 0.077933781739999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 = 0.010817483399999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_C3Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14 = 2.44936e-6; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14 = 54749.19473332601; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_OIKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_O = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_C3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_OIKv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_O + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_O; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative39(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x233 = exp(-0.077933781739999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x250 = 0.043269933599999998 * var_x233;
            
            partialF = -0.1341004876120194 - var_x250;
        }
        else
        {
            const double y_save = rY[39];
            rY[39] += delta;
            const double temp = EvaluateYDerivative39(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[39])/delta;
            rY[39] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative40(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 = rY[35];
        // Units: dimensionless; Initial value: 0.5977099765
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 = rY[40];
        // Units: dimensionless; Initial value: 0.03539084346
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 = rY[41];
        // Units: dimensionless; Initial value: 0.005428824353
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14 = 0.0076854803100000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 = 1.8400241455399999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14 = 0.00305767916; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_C0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14 = 1.00947847105; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_CI1Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI0 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_C0Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_CI1Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14 = 0.077933781739999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 = 0.010817483399999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14 = 2.44936e-6; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_CI0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14 = 0.52465073996; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI0 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14_to_CI0Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI0Kv14; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI0 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI0; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative40(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x235 = exp(0.0076854803100000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x253 = 7.4298590445392074 * var_x235;
            
            partialF = -0.00305767916 - var_x253;
        }
        else
        {
            const double y_save = rY[40];
            rY[40] += delta;
            const double temp = EvaluateYDerivative40(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[40])/delta;
            rY[40] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative41(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 = rY[36];
        // Units: dimensionless; Initial value: 0.1730990528
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 = rY[40];
        // Units: dimensionless; Initial value: 0.03539084346
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 = rY[41];
        // Units: dimensionless; Initial value: 0.005428824353
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 = rY[42];
        // Units: dimensionless; Initial value: 0.02287858869
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14 = 0.0076854803100000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 = 1.8400241455399999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14 = 0.00305767916; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14 = 1.00947847105; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_CI1Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_C1Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14 = 1.1710054056700001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14 = 0.077933781739999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 = 0.010817483399999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14 = 2.44936e-6; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14 = 0.52465073996; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_CI1Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI0Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI1 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_C1Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI0Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI2Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14 = 17.51885408639; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI1Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI1 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14_to_CI1Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14_to_CI1Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI1Kv14; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI1 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI1; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative41(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x233 = exp(-0.077933781739999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x235 = exp(0.0076854803100000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x254 = 0.020618446856331008 * var_x233;
            const double var_x257 = 6.4033407827395079 * var_x235;
            
            partialF = -0.0030289691634726814 - var_x254 - var_x257;
        }
        else
        {
            const double y_save = rY[41];
            rY[41] += delta;
            const double temp = EvaluateYDerivative41(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[41])/delta;
            rY[41] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative42(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 = rY[37];
        // Units: dimensionless; Initial value: 0.01881072386
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 = rY[41];
        // Units: dimensionless; Initial value: 0.005428824353
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 = rY[42];
        // Units: dimensionless; Initial value: 0.02287858869
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 = rY[43];
        // Units: dimensionless; Initial value: 0.03233800003
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14 = 0.0076854803100000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 = 1.8400241455399999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14 = 0.00305767916; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14 = 1.00947847105; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14 = 1.1710054056700001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b1Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_C2Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14 = 0.63902768757999995; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI3Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14 = 0.077933781739999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 = 0.010817483399999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14 = 2.44936e-6; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14 = 0.52465073996; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14 = 17.51885408639; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_CI2Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI1Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f1Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI2 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_C2Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI1Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI3Kv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14 = 938.58764534555996; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_CI2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI2 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14_to_CI2Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14_to_CI2Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_CI2Kv14; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI2 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI2; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative42(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x233 = exp(-0.077933781739999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x235 = exp(0.0076854803100000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x258 = 0.00064791916666788224 * var_x233;
            const double var_x261 = 2.0082338973371909 * var_x235;
            
            partialF = -0.0026111571690401588 - var_x258 - var_x261;
        }
        else
        {
            const double y_save = rY[42];
            rY[42] += delta;
            const double temp = EvaluateYDerivative42(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[42])/delta;
            rY[42] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative43(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 = rY[38];
        // Units: dimensionless; Initial value: 0.000916070135
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 = rY[42];
        // Units: dimensionless; Initial value: 0.02287858869
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 = rY[43];
        // Units: dimensionless; Initial value: 0.03233800003
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 = rY[44];
        // Units: dimensionless; Initial value: 0.1134082058
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14 = 0.0076854803100000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 = 1.8400241455399999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14 = 0.00305767916; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14 = 1.1710054056700001; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14 = 0.63902768757999995; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI3Kv14 = 2.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b2Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_C3Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14 = 2.1203537909499999; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_OIKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14 = 0.077933781739999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 = 0.010817483399999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14 = 2.44936e-6; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14 = 17.51885408639; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14 = 938.58764534555996; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_CI3Kv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_CI2Kv14 = 3.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f2Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI3 = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_C3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_CI2Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_OIKv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14 = 54749.19473332601; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_CI3Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI3 = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14_to_CI3Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14_to_CI3Kv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_CI3Kv14; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_CI3 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_CI3; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative43(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x233 = exp(-0.077933781739999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x235 = exp(0.0076854803100000002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x262 = 0.00060572898292340319 * var_x233;
            const double var_x265 = 6.1053726595326019 * var_x235;
            
            partialF = -0.0047848930796401661 - var_x262 - var_x265;
        }
        else
        {
            const double y_save = rY[43];
            rY[43] += delta;
            const double temp = EvaluateYDerivative43(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[43])/delta;
            rY[43] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative44(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 = rY[39];
        // Units: dimensionless; Initial value: 1.975541357e-05
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 = rY[43];
        // Units: dimensionless; Initial value: 0.03233800003
        double var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 = rY[44];
        // Units: dimensionless; Initial value: 0.1134082058
        
        
        // Mathematics
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14 = 0.0076854803100000002; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 = 1.8400241455399999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphaa0Kv14 * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__aaKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14 = 0.00305767916; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alphai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14 = 0.63902768757999995; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14 = 2.1203537909499999; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_OIKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b3Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_OKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__alpha_inact14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__b4Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14 = 0.077933781739999999; // per_mV
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 = 0.010817483399999999; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betaa0Kv14 * exp(-var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__baKv14); // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14 = 2.44936e-6; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__betai0Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14 = 938.58764534555996; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14 = 54749.19473332601; // dimensionless
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_CI3Kv14 = 4.0 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_act14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f3Kv14 / var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_OIKv14 = var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__beta_inact14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__f4Kv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_OI = (var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_CI3Kv14 + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14_to_OKv14) * var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14; // per_ms
        const double var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_OI = var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14_to_OIKv14 + var_chaste_interface__COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14 * var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14_to_OIKv14; // per_ms
        const double d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14 = -var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a1_OI + var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__a2_OI; // 1 / ms

        return d_dt_chaste_interface_var_COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative44(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x233 = exp(-0.077933781739999999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x266 = 0.00074179401705723523 * var_x233;
            
            partialF = -0.0014420608358145942 - var_x266;
        }
        else
        {
            const double y_save = rY[44];
            rY[44] += delta;
            const double temp = EvaluateYDerivative44(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[44])/delta;
            rY[44] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative45(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na1 = rY[45];
        // Units: dimensionless; Initial value: 0.1437575649
        double var_chaste_interface__INa__na2 = rY[46];
        // Units: dimensionless; Initial value: 0.0417776208
        double var_chaste_interface__INa__na8 = rY[52];
        // Units: dimensionless; Initial value: 0.4749950008
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Cf = var_INa__KToverH * var_INa__Temp_Scale * exp(0.00711 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 59565.2236284584 / var_INa__RTNa); // per_ms
        const double var_INa__Cn = var_INa__KToverH * var_INa__Temp_Scale * exp(786.21699999999998 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 287913.44653095299 / var_INa__RTNa); // per_ms
        const double var_INa__alpha1 = var_INa__KToverH * var_INa__Temp_Scale * exp(224.114 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 114007.462700232 / var_INa__RTNa + 0.28637426859623499 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__beta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(708.14599999999996 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 272470.27348968101 / var_INa__RTNa - 2.2852841758642399 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k12 = 4.0 * var_INa__alpha1; // per_ms
        const double var_INa__k18 = var_INa__Cn; // per_ms
        const double var_INa__k21 = var_INa__beta1; // per_ms
        const double var_INa__k81 = var_INa__Cf; // per_ms
        const double d_dt_chaste_interface_var_INa__na1 = (-var_INa__k12 - var_INa__k18) * var_chaste_interface__INa__na1 + var_INa__k21 * var_chaste_interface__INa__na2 + var_INa__k81 * var_chaste_interface__INa__na8; // 1 / ms

        return d_dt_chaste_interface_var_INa__na1;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative45(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x269 = exp(-19.657914992626967 + 0.011298360712115747 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x271 = exp(-23.156677820503301);
            const double var_x272 = 8513540195.0827656 * var_x271;
            const double var_x273 = 34054160780.331062 * var_x269;
            
            partialF = -var_x272 - var_x273;
        }
        else
        {
            const double y_save = rY[45];
            rY[45] += delta;
            const double temp = EvaluateYDerivative45(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[45])/delta;
            rY[45] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative46(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na1 = rY[45];
        // Units: dimensionless; Initial value: 0.1437575649
        double var_chaste_interface__INa__na2 = rY[46];
        // Units: dimensionless; Initial value: 0.0417776208
        double var_chaste_interface__INa__na3 = rY[47];
        // Units: dimensionless; Initial value: 0.004552898364
        double var_chaste_interface__INa__na9 = rY[53];
        // Units: dimensionless; Initial value: 0.2707214097
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Cf = var_INa__KToverH * var_INa__Temp_Scale * exp(0.00711 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 59565.2236284584 / var_INa__RTNa); // per_ms
        const double var_INa__Cn = var_INa__KToverH * var_INa__Temp_Scale * exp(786.21699999999998 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 287913.44653095299 / var_INa__RTNa); // per_ms
        const double var_INa__alpha1 = var_INa__KToverH * var_INa__Temp_Scale * exp(224.114 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 114007.462700232 / var_INa__RTNa + 0.28637426859623499 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__beta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(708.14599999999996 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 272470.27348968101 / var_INa__RTNa - 2.2852841758642399 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k12 = 4.0 * var_INa__alpha1; // per_ms
        const double var_INa__k18 = var_INa__Cn; // per_ms
        const double var_INa__k21 = var_INa__beta1; // per_ms
        const double var_INa__k23 = 3.0 * var_INa__alpha1; // per_ms
        const double var_INa__k32 = 2.0 * var_INa__beta1; // per_ms
        const double var_INa__k81 = var_INa__Cf; // per_ms
        const double var_INa__parameter_a = 1.4004262547740101; // dimensionless
        const double var_INa__k29 = var_INa__k18 * var_INa__parameter_a; // per_ms
        const double var_INa__k92 = var_INa__k81 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na2 = var_INa__k12 * var_chaste_interface__INa__na1 + var_INa__k32 * var_chaste_interface__INa__na3 + var_INa__k92 * var_chaste_interface__INa__na9 - (var_INa__k21 + var_INa__k23 + var_INa__k29) * var_chaste_interface__INa__na2; // 1 / ms

        return d_dt_chaste_interface_var_INa__na2;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative46(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x267 = exp(-26.232056238852348 - 0.090161609404259865 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x269 = exp(-19.657914992626967 + 0.011298360712115747 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x271 = exp(-23.156677820503301);
            const double var_x274 = 8513540195.0827656 * var_x267;
            const double var_x279 = 11922585210.267752 * var_x271;
            const double var_x280 = 25540620585.248295 * var_x269;
            
            partialF = -var_x274 - var_x279 - var_x280;
        }
        else
        {
            const double y_save = rY[46];
            rY[46] += delta;
            const double temp = EvaluateYDerivative46(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[46])/delta;
            rY[46] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative47(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na2 = rY[46];
        // Units: dimensionless; Initial value: 0.0417776208
        double var_chaste_interface__INa__na3 = rY[47];
        // Units: dimensionless; Initial value: 0.004552898364
        double var_chaste_interface__INa__na4 = rY[48];
        // Units: dimensionless; Initial value: 0.000220520743
        double var_chaste_interface__INa__na10 = rY[54];
        // Units: dimensionless; Initial value: 0.05786120057
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Cf = var_INa__KToverH * var_INa__Temp_Scale * exp(0.00711 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 59565.2236284584 / var_INa__RTNa); // per_ms
        const double var_INa__Cn = var_INa__KToverH * var_INa__Temp_Scale * exp(786.21699999999998 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 287913.44653095299 / var_INa__RTNa); // per_ms
        const double var_INa__alpha1 = var_INa__KToverH * var_INa__Temp_Scale * exp(224.114 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 114007.462700232 / var_INa__RTNa + 0.28637426859623499 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__beta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(708.14599999999996 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 272470.27348968101 / var_INa__RTNa - 2.2852841758642399 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k18 = var_INa__Cn; // per_ms
        const double var_INa__k23 = 3.0 * var_INa__alpha1; // per_ms
        const double var_INa__k32 = 2.0 * var_INa__beta1; // per_ms
        const double var_INa__k34 = 2.0 * var_INa__alpha1; // per_ms
        const double var_INa__k43 = 3.0 * var_INa__beta1; // per_ms
        const double var_INa__k81 = var_INa__Cf; // per_ms
        const double var_INa__parameter_a = 1.4004262547740101; // dimensionless
        const double var_INa__k29 = var_INa__k18 * var_INa__parameter_a; // per_ms
        const double var_INa__k310 = var_INa__k29 * var_INa__parameter_a; // per_ms
        const double var_INa__k92 = var_INa__k81 / var_INa__parameter_a; // per_ms
        const double var_INa__k103 = var_INa__k92 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na3 = var_INa__k103 * var_chaste_interface__INa__na10 + var_INa__k23 * var_chaste_interface__INa__na2 + var_INa__k43 * var_chaste_interface__INa__na4 - (var_INa__k310 + var_INa__k32 + var_INa__k34) * var_chaste_interface__INa__na3; // 1 / ms

        return d_dt_chaste_interface_var_INa__na3;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative47(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x267 = exp(-26.232056238852348 - 0.090161609404259865 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x269 = exp(-19.657914992626967 + 0.011298360712115747 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x271 = exp(-23.156677820503301);
            const double var_x281 = 17027080390.165531 * var_x267;
            const double var_x285 = 16696701353.239271 * var_x271;
            const double var_x286 = 17027080390.165531 * var_x269;
            
            partialF = -var_x281 - var_x285 - var_x286;
        }
        else
        {
            const double y_save = rY[47];
            rY[47] += delta;
            const double temp = EvaluateYDerivative47(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[47])/delta;
            rY[47] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative48(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na3 = rY[47];
        // Units: dimensionless; Initial value: 0.004552898364
        double var_chaste_interface__INa__na4 = rY[48];
        // Units: dimensionless; Initial value: 0.000220520743
        double var_chaste_interface__INa__na5 = rY[49];
        // Units: dimensionless; Initial value: 4.005266484e-06
        double var_chaste_interface__INa__na11 = rY[55];
        // Units: dimensionless; Initial value: 0.005496292279
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Cf = var_INa__KToverH * var_INa__Temp_Scale * exp(0.00711 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 59565.2236284584 / var_INa__RTNa); // per_ms
        const double var_INa__Cn = var_INa__KToverH * var_INa__Temp_Scale * exp(786.21699999999998 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 287913.44653095299 / var_INa__RTNa); // per_ms
        const double var_INa__alpha1 = var_INa__KToverH * var_INa__Temp_Scale * exp(224.114 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 114007.462700232 / var_INa__RTNa + 0.28637426859623499 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__beta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(708.14599999999996 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 272470.27348968101 / var_INa__RTNa - 2.2852841758642399 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k18 = var_INa__Cn; // per_ms
        const double var_INa__k34 = 2.0 * var_INa__alpha1; // per_ms
        const double var_INa__k43 = 3.0 * var_INa__beta1; // per_ms
        const double var_INa__k45 = var_INa__alpha1; // per_ms
        const double var_INa__k54 = 4.0 * var_INa__beta1; // per_ms
        const double var_INa__k81 = var_INa__Cf; // per_ms
        const double var_INa__parameter_a = 1.4004262547740101; // dimensionless
        const double var_INa__k29 = var_INa__k18 * var_INa__parameter_a; // per_ms
        const double var_INa__k310 = var_INa__k29 * var_INa__parameter_a; // per_ms
        const double var_INa__k411 = var_INa__k310 * var_INa__parameter_a; // per_ms
        const double var_INa__k92 = var_INa__k81 / var_INa__parameter_a; // per_ms
        const double var_INa__k103 = var_INa__k92 / var_INa__parameter_a; // per_ms
        const double var_INa__k114 = var_INa__k103 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na4 = var_INa__k114 * var_chaste_interface__INa__na11 + var_INa__k34 * var_chaste_interface__INa__na3 + var_INa__k54 * var_chaste_interface__INa__na5 - (var_INa__k411 + var_INa__k43 + var_INa__k45) * var_chaste_interface__INa__na4; // 1 / ms

        return d_dt_chaste_interface_var_INa__na4;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative48(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x267 = exp(-26.232056238852348 - 0.090161609404259865 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x269 = exp(-19.657914992626967 + 0.011298360712115747 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x271 = exp(-23.156677820503301);
            const double var_x287 = 25540620585.248295 * var_x267;
            const double var_x291 = 23382498943.197018 * var_x271;
            const double var_x292 = 8513540195.0827656 * var_x269;
            
            partialF = -var_x287 - var_x291 - var_x292;
        }
        else
        {
            const double y_save = rY[48];
            rY[48] += delta;
            const double temp = EvaluateYDerivative48(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[48])/delta;
            rY[48] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative49(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na4 = rY[48];
        // Units: dimensionless; Initial value: 0.000220520743
        double var_chaste_interface__INa__na5 = rY[49];
        // Units: dimensionless; Initial value: 4.005266484e-06
        double var_chaste_interface__INa__na6 = rY[50];
        // Units: dimensionless; Initial value: 1.57442749e-08
        double var_chaste_interface__INa__na7 = rY[51];
        // Units: dimensionless; Initial value: 2.856607179e-09
        double var_chaste_interface__INa__na12 = rY[56];
        // Units: dimensionless; Initial value: 0.0001957874519
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Cf = var_INa__KToverH * var_INa__Temp_Scale * exp(0.00711 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 59565.2236284584 / var_INa__RTNa); // per_ms
        const double var_INa__Cn = var_INa__KToverH * var_INa__Temp_Scale * exp(786.21699999999998 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 287913.44653095299 / var_INa__RTNa); // per_ms
        const double var_INa__Delta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(229.20500000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 133689.93040909999 / var_INa__RTNa - 1.55804214553883 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__alpha1 = var_INa__KToverH * var_INa__Temp_Scale * exp(224.114 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 114007.462700232 / var_INa__RTNa + 0.28637426859623499 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__beta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(708.14599999999996 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 272470.27348968101 / var_INa__RTNa - 2.2852841758642399 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__gamma1 = var_INa__KToverH * var_INa__Temp_Scale * exp(529.952 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 196336.57573592299 / var_INa__RTNa + 2.7808491859604501 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k18 = var_INa__Cn; // per_ms
        const double var_INa__k45 = var_INa__alpha1; // per_ms
        const double var_INa__k54 = 4.0 * var_INa__beta1; // per_ms
        const double var_INa__k56 = var_INa__gamma1; // per_ms
        const double var_INa__k65 = var_INa__Delta1; // per_ms
        const double var_INa__k81 = var_INa__Cf; // per_ms
        const double var_INa__mu = var_INa__KToverH * var_INa__Temp_Scale * exp(193.26499999999999 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 121322.14327524199 / var_INa__RTNa - 1.74290267020903 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k75 = var_INa__mu; // per_ms
        const double var_INa__parameter_a = 1.4004262547740101; // dimensionless
        const double var_INa__k29 = var_INa__k18 * var_INa__parameter_a; // per_ms
        const double var_INa__k310 = var_INa__k29 * var_INa__parameter_a; // per_ms
        const double var_INa__k411 = var_INa__k310 * var_INa__parameter_a; // per_ms
        const double var_INa__k512 = var_INa__k411 * var_INa__parameter_a; // per_ms
        const double var_INa__k92 = var_INa__k81 / var_INa__parameter_a; // per_ms
        const double var_INa__k103 = var_INa__k92 / var_INa__parameter_a; // per_ms
        const double var_INa__k114 = var_INa__k103 / var_INa__parameter_a; // per_ms
        const double var_INa__k125 = var_INa__k114 / var_INa__parameter_a; // per_ms
        const double var_INa__rho = var_INa__KToverH * var_INa__Temp_Scale * exp(338.91500000000002 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 147813.99000503501 / var_INa__RTNa + 2.1360043702125999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k57 = var_INa__rho; // per_ms
        const double d_dt_chaste_interface_var_INa__na5 = var_INa__k125 * var_chaste_interface__INa__na12 + var_INa__k45 * var_chaste_interface__INa__na4 + var_INa__k65 * var_chaste_interface__INa__na6 + var_INa__k75 * var_chaste_interface__INa__na7 - (var_INa__k512 + var_INa__k54 + var_INa__k56 + var_INa__k57) * var_chaste_interface__INa__na5; // 1 / ms

        return d_dt_chaste_interface_var_INa__na5;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative49(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x267 = exp(-26.232056238852348 - 0.090161609404259865 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x271 = exp(-23.156677820503301);
            const double var_x293 = 34054160780.331062 * var_x267;
            const double var_x295 = exp(-19.672905196314268 + 0.084272054104636354 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x297 = exp(-16.535928437145476 + 0.1097131992444229 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x303 = 32745465422.278648 * var_x271;
            const double var_x304 = 8513540195.0827656 * var_x297;
            const double var_x305 = 8513540195.0827656 * var_x295;
            
            partialF = -var_x293 - var_x303 - var_x304 - var_x305;
        }
        else
        {
            const double y_save = rY[49];
            rY[49] += delta;
            const double temp = EvaluateYDerivative49(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[49])/delta;
            rY[49] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative50(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na5 = rY[49];
        // Units: dimensionless; Initial value: 4.005266484e-06
        double var_chaste_interface__INa__na6 = rY[50];
        // Units: dimensionless; Initial value: 1.57442749e-08
        double var_chaste_interface__INa__na7 = rY[51];
        // Units: dimensionless; Initial value: 2.856607179e-09
        double var_chaste_interface__INa__na13 = rY[57];
        // Units: dimensionless; Initial value: 0.000417679396
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Delta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(229.20500000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 133689.93040909999 / var_INa__RTNa - 1.55804214553883 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__Of = var_INa__KToverH * var_INa__Temp_Scale * exp(1.51 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 97657.849713701493 / var_INa__RTNa + 0.068486199310068496 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__On = var_INa__KToverH * var_INa__Temp_Scale * exp(39.295000000000002 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 62123.078438048098 / var_INa__RTNa + 0.28881604274323203 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__epsilon = var_INa__KToverH * var_INa__Temp_Scale * exp(70.078000000000003 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 85800.367557832593 / var_INa__RTNa); // per_ms
        const double var_INa__gamma1 = var_INa__KToverH * var_INa__Temp_Scale * exp(529.952 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 196336.57573592299 / var_INa__RTNa + 2.7808491859604501 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k136 = var_INa__Of; // per_ms
        const double var_INa__k56 = var_INa__gamma1; // per_ms
        const double var_INa__k613 = var_INa__On; // per_ms
        const double var_INa__k65 = var_INa__Delta1; // per_ms
        const double var_INa__k67 = var_INa__epsilon; // per_ms
        const double var_INa__omega_na = var_INa__KToverH * var_INa__Temp_Scale * exp(225.17500000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 121955.166154864 / var_INa__RTNa); // per_ms
        const double var_INa__k76 = var_INa__omega_na; // per_ms
        const double d_dt_chaste_interface_var_INa__na6 = var_INa__k136 * var_chaste_interface__INa__na13 + var_INa__k56 * var_chaste_interface__INa__na5 + var_INa__k76 * var_chaste_interface__INa__na7 - (var_INa__k613 + var_INa__k65 + var_INa__k67) * var_chaste_interface__INa__na6; // 1 / ms

        return d_dt_chaste_interface_var_INa__na6;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative50(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x299 = exp(-27.092641999412571 - 0.061469636400174388 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x306 = 8513540195.0827656 * var_x299;
            const double var_x309 = exp(-20.6726464954126 + 0.011394696340402199 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x313 = 8513540195.0827656 * exp(-26.650781465416159);
            const double var_x314 = 8513540195.0827656 * var_x309;
            
            partialF = -var_x306 - var_x313 - var_x314;
        }
        else
        {
            const double y_save = rY[50];
            rY[50] += delta;
            const double temp = EvaluateYDerivative50(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[50])/delta;
            rY[50] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative51(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na5 = rY[49];
        // Units: dimensionless; Initial value: 4.005266484e-06
        double var_chaste_interface__INa__na6 = rY[50];
        // Units: dimensionless; Initial value: 1.57442749e-08
        double var_chaste_interface__INa__na7 = rY[51];
        // Units: dimensionless; Initial value: 2.856607179e-09
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__epsilon = var_INa__KToverH * var_INa__Temp_Scale * exp(70.078000000000003 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 85800.367557832593 / var_INa__RTNa); // per_ms
        const double var_INa__k67 = var_INa__epsilon; // per_ms
        const double var_INa__mu = var_INa__KToverH * var_INa__Temp_Scale * exp(193.26499999999999 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 121322.14327524199 / var_INa__RTNa - 1.74290267020903 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k75 = var_INa__mu; // per_ms
        const double var_INa__omega_na = var_INa__KToverH * var_INa__Temp_Scale * exp(225.17500000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 121955.166154864 / var_INa__RTNa); // per_ms
        const double var_INa__k76 = var_INa__omega_na; // per_ms
        const double var_INa__rho = var_INa__KToverH * var_INa__Temp_Scale * exp(338.91500000000002 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 147813.99000503501 / var_INa__RTNa + 2.1360043702125999 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k57 = var_INa__rho; // per_ms
        const double d_dt_chaste_interface_var_INa__na7 = var_INa__k57 * var_chaste_interface__INa__na5 + var_INa__k67 * var_chaste_interface__INa__na6 - (var_INa__k75 + var_INa__k76) * var_chaste_interface__INa__na7; // 1 / ms

        return d_dt_chaste_interface_var_INa__na7;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative51(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x301 = exp(-26.358496255772213 - 0.068762962366201316 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x307 = 8513540195.0827656 * var_x301;
            const double var_x315 = 8513540195.0827656 * exp(-22.779658962607588);
            
            partialF = -var_x307 - var_x315;
        }
        else
        {
            const double y_save = rY[51];
            rY[51] += delta;
            const double temp = EvaluateYDerivative51(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[51])/delta;
            rY[51] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative52(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na1 = rY[45];
        // Units: dimensionless; Initial value: 0.1437575649
        double var_chaste_interface__INa__na8 = rY[52];
        // Units: dimensionless; Initial value: 0.4749950008
        double var_chaste_interface__INa__na9 = rY[53];
        // Units: dimensionless; Initial value: 0.2707214097
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Cf = var_INa__KToverH * var_INa__Temp_Scale * exp(0.00711 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 59565.2236284584 / var_INa__RTNa); // per_ms
        const double var_INa__Cn = var_INa__KToverH * var_INa__Temp_Scale * exp(786.21699999999998 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 287913.44653095299 / var_INa__RTNa); // per_ms
        const double var_INa__alpha1 = var_INa__KToverH * var_INa__Temp_Scale * exp(224.114 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 114007.462700232 / var_INa__RTNa + 0.28637426859623499 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__beta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(708.14599999999996 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 272470.27348968101 / var_INa__RTNa - 2.2852841758642399 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k12 = 4.0 * var_INa__alpha1; // per_ms
        const double var_INa__k18 = var_INa__Cn; // per_ms
        const double var_INa__k21 = var_INa__beta1; // per_ms
        const double var_INa__k81 = var_INa__Cf; // per_ms
        const double var_INa__parameter_a = 1.4004262547740101; // dimensionless
        const double var_INa__k89 = var_INa__k12 * var_INa__parameter_a; // per_ms
        const double var_INa__k98 = var_INa__k21 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na8 = var_INa__k18 * var_chaste_interface__INa__na1 + var_INa__k98 * var_chaste_interface__INa__na9 - (var_INa__k81 + var_INa__k89) * var_chaste_interface__INa__na8; // 1 / ms

        return d_dt_chaste_interface_var_INa__na8;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative52(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x269 = exp(-19.657914992626967 + 0.011298360712115747 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x275 = exp(-24.35183300086069);
            const double var_x276 = 8513540195.0827656 * var_x275;
            const double var_x319 = 47690340841.071007 * var_x269;
            
            partialF = -var_x276 - var_x319;
        }
        else
        {
            const double y_save = rY[52];
            rY[52] += delta;
            const double temp = EvaluateYDerivative52(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[52])/delta;
            rY[52] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative53(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na2 = rY[46];
        // Units: dimensionless; Initial value: 0.0417776208
        double var_chaste_interface__INa__na8 = rY[52];
        // Units: dimensionless; Initial value: 0.4749950008
        double var_chaste_interface__INa__na9 = rY[53];
        // Units: dimensionless; Initial value: 0.2707214097
        double var_chaste_interface__INa__na10 = rY[54];
        // Units: dimensionless; Initial value: 0.05786120057
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Cf = var_INa__KToverH * var_INa__Temp_Scale * exp(0.00711 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 59565.2236284584 / var_INa__RTNa); // per_ms
        const double var_INa__Cn = var_INa__KToverH * var_INa__Temp_Scale * exp(786.21699999999998 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 287913.44653095299 / var_INa__RTNa); // per_ms
        const double var_INa__alpha1 = var_INa__KToverH * var_INa__Temp_Scale * exp(224.114 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 114007.462700232 / var_INa__RTNa + 0.28637426859623499 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__beta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(708.14599999999996 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 272470.27348968101 / var_INa__RTNa - 2.2852841758642399 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k12 = 4.0 * var_INa__alpha1; // per_ms
        const double var_INa__k18 = var_INa__Cn; // per_ms
        const double var_INa__k21 = var_INa__beta1; // per_ms
        const double var_INa__k23 = 3.0 * var_INa__alpha1; // per_ms
        const double var_INa__k32 = 2.0 * var_INa__beta1; // per_ms
        const double var_INa__k81 = var_INa__Cf; // per_ms
        const double var_INa__parameter_a = 1.4004262547740101; // dimensionless
        const double var_INa__k109 = var_INa__k32 / var_INa__parameter_a; // per_ms
        const double var_INa__k29 = var_INa__k18 * var_INa__parameter_a; // per_ms
        const double var_INa__k89 = var_INa__k12 * var_INa__parameter_a; // per_ms
        const double var_INa__k910 = var_INa__k23 * var_INa__parameter_a; // per_ms
        const double var_INa__k92 = var_INa__k81 / var_INa__parameter_a; // per_ms
        const double var_INa__k98 = var_INa__k21 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na9 = var_INa__k109 * var_chaste_interface__INa__na10 + var_INa__k29 * var_chaste_interface__INa__na2 + var_INa__k89 * var_chaste_interface__INa__na8 - (var_INa__k910 + var_INa__k92 + var_INa__k98) * var_chaste_interface__INa__na9; // 1 / ms

        return d_dt_chaste_interface_var_INa__na9;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative53(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x267 = exp(-26.232056238852348 - 0.090161609404259865 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x269 = exp(-19.657914992626967 + 0.011298360712115747 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x275 = exp(-24.35183300086069);
            const double var_x282 = 6079249204.347868 * var_x275;
            const double var_x320 = 6079249204.347868 * var_x267;
            const double var_x323 = 35767755630.803253 * var_x269;
            
            partialF = -var_x282 - var_x320 - var_x323;
        }
        else
        {
            const double y_save = rY[53];
            rY[53] += delta;
            const double temp = EvaluateYDerivative53(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[53])/delta;
            rY[53] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative54(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na3 = rY[47];
        // Units: dimensionless; Initial value: 0.004552898364
        double var_chaste_interface__INa__na9 = rY[53];
        // Units: dimensionless; Initial value: 0.2707214097
        double var_chaste_interface__INa__na10 = rY[54];
        // Units: dimensionless; Initial value: 0.05786120057
        double var_chaste_interface__INa__na11 = rY[55];
        // Units: dimensionless; Initial value: 0.005496292279
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Cf = var_INa__KToverH * var_INa__Temp_Scale * exp(0.00711 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 59565.2236284584 / var_INa__RTNa); // per_ms
        const double var_INa__Cn = var_INa__KToverH * var_INa__Temp_Scale * exp(786.21699999999998 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 287913.44653095299 / var_INa__RTNa); // per_ms
        const double var_INa__alpha1 = var_INa__KToverH * var_INa__Temp_Scale * exp(224.114 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 114007.462700232 / var_INa__RTNa + 0.28637426859623499 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__beta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(708.14599999999996 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 272470.27348968101 / var_INa__RTNa - 2.2852841758642399 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k18 = var_INa__Cn; // per_ms
        const double var_INa__k23 = 3.0 * var_INa__alpha1; // per_ms
        const double var_INa__k32 = 2.0 * var_INa__beta1; // per_ms
        const double var_INa__k34 = 2.0 * var_INa__alpha1; // per_ms
        const double var_INa__k43 = 3.0 * var_INa__beta1; // per_ms
        const double var_INa__k81 = var_INa__Cf; // per_ms
        const double var_INa__parameter_a = 1.4004262547740101; // dimensionless
        const double var_INa__k1011 = var_INa__k34 * var_INa__parameter_a; // per_ms
        const double var_INa__k109 = var_INa__k32 / var_INa__parameter_a; // per_ms
        const double var_INa__k1110 = var_INa__k43 / var_INa__parameter_a; // per_ms
        const double var_INa__k29 = var_INa__k18 * var_INa__parameter_a; // per_ms
        const double var_INa__k310 = var_INa__k29 * var_INa__parameter_a; // per_ms
        const double var_INa__k910 = var_INa__k23 * var_INa__parameter_a; // per_ms
        const double var_INa__k92 = var_INa__k81 / var_INa__parameter_a; // per_ms
        const double var_INa__k103 = var_INa__k92 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na10 = var_INa__k1110 * var_chaste_interface__INa__na11 + var_INa__k310 * var_chaste_interface__INa__na3 + var_INa__k910 * var_chaste_interface__INa__na9 - (var_INa__k1011 + var_INa__k103 + var_INa__k109) * var_chaste_interface__INa__na10; // 1 / ms

        return d_dt_chaste_interface_var_INa__na10;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative54(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x267 = exp(-26.232056238852348 - 0.090161609404259865 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x269 = exp(-19.657914992626967 + 0.011298360712115747 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x275 = exp(-24.35183300086069);
            const double var_x288 = 4340999166.2352047 * var_x275;
            const double var_x324 = 12158498408.695736 * var_x267;
            const double var_x327 = 23845170420.535503 * var_x269;
            
            partialF = -var_x288 - var_x324 - var_x327;
        }
        else
        {
            const double y_save = rY[54];
            rY[54] += delta;
            const double temp = EvaluateYDerivative54(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[54])/delta;
            rY[54] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative55(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na4 = rY[48];
        // Units: dimensionless; Initial value: 0.000220520743
        double var_chaste_interface__INa__na10 = rY[54];
        // Units: dimensionless; Initial value: 0.05786120057
        double var_chaste_interface__INa__na11 = rY[55];
        // Units: dimensionless; Initial value: 0.005496292279
        double var_chaste_interface__INa__na12 = rY[56];
        // Units: dimensionless; Initial value: 0.0001957874519
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Cf = var_INa__KToverH * var_INa__Temp_Scale * exp(0.00711 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 59565.2236284584 / var_INa__RTNa); // per_ms
        const double var_INa__Cn = var_INa__KToverH * var_INa__Temp_Scale * exp(786.21699999999998 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 287913.44653095299 / var_INa__RTNa); // per_ms
        const double var_INa__alpha1 = var_INa__KToverH * var_INa__Temp_Scale * exp(224.114 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 114007.462700232 / var_INa__RTNa + 0.28637426859623499 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__beta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(708.14599999999996 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 272470.27348968101 / var_INa__RTNa - 2.2852841758642399 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k18 = var_INa__Cn; // per_ms
        const double var_INa__k34 = 2.0 * var_INa__alpha1; // per_ms
        const double var_INa__k43 = 3.0 * var_INa__beta1; // per_ms
        const double var_INa__k45 = var_INa__alpha1; // per_ms
        const double var_INa__k54 = 4.0 * var_INa__beta1; // per_ms
        const double var_INa__k81 = var_INa__Cf; // per_ms
        const double var_INa__parameter_a = 1.4004262547740101; // dimensionless
        const double var_INa__k1011 = var_INa__k34 * var_INa__parameter_a; // per_ms
        const double var_INa__k1110 = var_INa__k43 / var_INa__parameter_a; // per_ms
        const double var_INa__k1112 = var_INa__k45 * var_INa__parameter_a; // per_ms
        const double var_INa__k1211 = var_INa__k54 / var_INa__parameter_a; // per_ms
        const double var_INa__k29 = var_INa__k18 * var_INa__parameter_a; // per_ms
        const double var_INa__k310 = var_INa__k29 * var_INa__parameter_a; // per_ms
        const double var_INa__k411 = var_INa__k310 * var_INa__parameter_a; // per_ms
        const double var_INa__k92 = var_INa__k81 / var_INa__parameter_a; // per_ms
        const double var_INa__k103 = var_INa__k92 / var_INa__parameter_a; // per_ms
        const double var_INa__k114 = var_INa__k103 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na11 = var_INa__k1011 * var_chaste_interface__INa__na10 + var_INa__k1211 * var_chaste_interface__INa__na12 + var_INa__k411 * var_chaste_interface__INa__na4 - (var_INa__k1110 + var_INa__k1112 + var_INa__k114) * var_chaste_interface__INa__na11; // 1 / ms

        return d_dt_chaste_interface_var_INa__na11;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative55(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x267 = exp(-26.232056238852348 - 0.090161609404259865 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x269 = exp(-19.657914992626967 + 0.011298360712115747 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x275 = exp(-24.35183300086069);
            const double var_x294 = 3099769910.3661275 * var_x275;
            const double var_x328 = 18237747613.043602 * var_x267;
            const double var_x331 = 11922585210.267752 * var_x269;
            
            partialF = -var_x294 - var_x328 - var_x331;
        }
        else
        {
            const double y_save = rY[55];
            rY[55] += delta;
            const double temp = EvaluateYDerivative55(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[55])/delta;
            rY[55] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative56(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na5 = rY[49];
        // Units: dimensionless; Initial value: 4.005266484e-06
        double var_chaste_interface__INa__na11 = rY[55];
        // Units: dimensionless; Initial value: 0.005496292279
        double var_chaste_interface__INa__na12 = rY[56];
        // Units: dimensionless; Initial value: 0.0001957874519
        double var_chaste_interface__INa__na13 = rY[57];
        // Units: dimensionless; Initial value: 0.000417679396
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__Cf = var_INa__KToverH * var_INa__Temp_Scale * exp(0.00711 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 59565.2236284584 / var_INa__RTNa); // per_ms
        const double var_INa__Cn = var_INa__KToverH * var_INa__Temp_Scale * exp(786.21699999999998 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 287913.44653095299 / var_INa__RTNa); // per_ms
        const double var_INa__DeltaDelta = var_INa__KToverH * var_INa__Temp_Scale * exp(-130.63900000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 55700.662465830697 / var_INa__RTNa - 3.6498167292707802 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__GammaGamma = var_INa__KToverH * var_INa__Temp_Scale * exp(116431.14214234801 / var_INa__RTNa - 578.31700000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas + 0.76412601174570705 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__alpha1 = var_INa__KToverH * var_INa__Temp_Scale * exp(224.114 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 114007.462700232 / var_INa__RTNa + 0.28637426859623499 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__beta1 = var_INa__KToverH * var_INa__Temp_Scale * exp(708.14599999999996 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 272470.27348968101 / var_INa__RTNa - 2.2852841758642399 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k1213 = var_INa__GammaGamma; // per_ms
        const double var_INa__k1312 = var_INa__DeltaDelta; // per_ms
        const double var_INa__k18 = var_INa__Cn; // per_ms
        const double var_INa__k45 = var_INa__alpha1; // per_ms
        const double var_INa__k54 = 4.0 * var_INa__beta1; // per_ms
        const double var_INa__k81 = var_INa__Cf; // per_ms
        const double var_INa__parameter_a = 1.4004262547740101; // dimensionless
        const double var_INa__k1112 = var_INa__k45 * var_INa__parameter_a; // per_ms
        const double var_INa__k1211 = var_INa__k54 / var_INa__parameter_a; // per_ms
        const double var_INa__k29 = var_INa__k18 * var_INa__parameter_a; // per_ms
        const double var_INa__k310 = var_INa__k29 * var_INa__parameter_a; // per_ms
        const double var_INa__k411 = var_INa__k310 * var_INa__parameter_a; // per_ms
        const double var_INa__k512 = var_INa__k411 * var_INa__parameter_a; // per_ms
        const double var_INa__k92 = var_INa__k81 / var_INa__parameter_a; // per_ms
        const double var_INa__k103 = var_INa__k92 / var_INa__parameter_a; // per_ms
        const double var_INa__k114 = var_INa__k103 / var_INa__parameter_a; // per_ms
        const double var_INa__k125 = var_INa__k114 / var_INa__parameter_a; // per_ms
        const double d_dt_chaste_interface_var_INa__na12 = var_INa__k1112 * var_chaste_interface__INa__na11 + var_INa__k1312 * var_chaste_interface__INa__na13 + var_INa__k512 * var_chaste_interface__INa__na5 - (var_INa__k1211 + var_INa__k1213 + var_INa__k125) * var_chaste_interface__INa__na12; // 1 / ms

        return d_dt_chaste_interface_var_INa__na12;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative56(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x267 = exp(-26.232056238852348 - 0.090161609404259865 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x275 = exp(-24.35183300086069);
            const double var_x308 = 2213447441.3051791 * var_x275;
            const double var_x332 = 24316996817.391472 * var_x267;
            const double var_x333 = exp(-21.949261959797553 + 0.030147161449011892 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x337 = 8513540195.0827656 * var_x333;
            
            partialF = -var_x308 - var_x332 - var_x337;
        }
        else
        {
            const double y_save = rY[56];
            rY[56] += delta;
            const double temp = EvaluateYDerivative56(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[56])/delta;
            rY[56] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative57(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__INa__na6 = rY[50];
        // Units: dimensionless; Initial value: 1.57442749e-08
        double var_chaste_interface__INa__na12 = rY[56];
        // Units: dimensionless; Initial value: 0.0001957874519
        double var_chaste_interface__INa__na13 = rY[57];
        // Units: dimensionless; Initial value: 0.000417679396
        
        
        // Mathematics
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday = 96.5; // coulomb_per_millimole
        const double var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas = 8.3149999999999995; // joule_per_mole_kelvin
        const double var_INa__TNa = 294.16000000000003; // kelvin
        const double var_INa__KToverH = 20842137.035919107 * var_INa__TNa; // per_ms
        const double var_INa__RTNa = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa; // joule_per_mole
        const double var_INa__RTNaF = var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas * var_INa__TNa / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Faraday; // mV
        const double var_INa__Temp_Scale = 1.38862291252871; // dimensionless
        const double var_INa__DeltaDelta = var_INa__KToverH * var_INa__Temp_Scale * exp(-130.63900000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 55700.662465830697 / var_INa__RTNa - 3.6498167292707802 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__GammaGamma = var_INa__KToverH * var_INa__Temp_Scale * exp(116431.14214234801 / var_INa__RTNa - 578.31700000000001 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas + 0.76412601174570705 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__Of = var_INa__KToverH * var_INa__Temp_Scale * exp(1.51 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 97657.849713701493 / var_INa__RTNa + 0.068486199310068496 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__On = var_INa__KToverH * var_INa__Temp_Scale * exp(39.295000000000002 / var_COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Rgas - 62123.078438048098 / var_INa__RTNa + 0.28881604274323203 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V / var_INa__RTNaF); // per_ms
        const double var_INa__k1213 = var_INa__GammaGamma; // per_ms
        const double var_INa__k1312 = var_INa__DeltaDelta; // per_ms
        const double var_INa__k136 = var_INa__Of; // per_ms
        const double var_INa__k613 = var_INa__On; // per_ms
        const double d_dt_chaste_interface_var_INa__na13 = var_INa__k1213 * var_chaste_interface__INa__na12 + var_INa__k613 * var_chaste_interface__INa__na6 - (var_INa__k1312 + var_INa__k136) * var_chaste_interface__INa__na13; // 1 / ms

        return d_dt_chaste_interface_var_INa__na13;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative57(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x311 = exp(-39.744904705650839 + 0.0027019947965296331 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x316 = 8513540195.0827656 * var_x311;
            const double var_x335 = exp(-38.483942906307405 - 0.14399668707161886 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x338 = 8513540195.0827656 * var_x335;
            
            partialF = -var_x316 - var_x338;
        }
        else
        {
            const double y_save = rY[57];
            rY[57] += delta;
            const double temp = EvaluateYDerivative57(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[57])/delta;
            rY[57] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative58(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__IKr__C1Herg = rY[58];
        // Units: dimensionless; Initial value: 0.996697338
        double var_chaste_interface__IKr__C2Herg = rY[59];
        // Units: dimensionless; Initial value: 0.0004340879648
        
        
        // Mathematics
        const double var_IKr__A0_HERG = 0.017147641733086; // per_ms
        const double var_IKr__A1_HERG = 0.039693283811409998; // per_ms
        const double var_IKr__B0_HERG = 0.033046080388350003; // per_mV
        const double var_IKr__B1_HERG = -0.043060541639799998; // per_mV
        const double var_IKr__T_Const_HERG = 5.3200000010000004; // dimensionless
        const double var_IKr__C1H_to_C2H = var_IKr__A0_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B0_HERG); // per_ms
        const double var_IKr__C2H_to_C1H = var_IKr__A1_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B1_HERG); // per_ms
        const double d_dt_chaste_interface_var_IKr__C1Herg = var_IKr__C2H_to_C1H * var_chaste_interface__IKr__C2Herg - var_IKr__C1H_to_C2H * var_chaste_interface__IKr__C1Herg; // 1 / ms

        return d_dt_chaste_interface_var_IKr__C1Herg;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative58(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x339 = exp(0.033046080388350003 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x343 = 0.091225454037165171 * var_x339;
            
            partialF = -var_x343;
        }
        else
        {
            const double y_save = rY[58];
            rY[58] += delta;
            const double temp = EvaluateYDerivative58(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[58])/delta;
            rY[58] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative59(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__IKr__C1Herg = rY[58];
        // Units: dimensionless; Initial value: 0.996697338
        double var_chaste_interface__IKr__C2Herg = rY[59];
        // Units: dimensionless; Initial value: 0.0004340879648
        double var_chaste_interface__IKr__C3Herg = rY[60];
        // Units: dimensionless; Initial value: 7.634099755e-05
        
        
        // Mathematics
        const double var_IKr__A0_HERG = 0.017147641733086; // per_ms
        const double var_IKr__A1_HERG = 0.039693283811409998; // per_ms
        const double var_IKr__B0_HERG = 0.033046080388350003; // per_mV
        const double var_IKr__B1_HERG = -0.043060541639799998; // per_mV
        const double var_IKr__T_Const_HERG = 5.3200000010000004; // dimensionless
        const double var_IKr__C1H_to_C2H = var_IKr__A0_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B0_HERG); // per_ms
        const double var_IKr__C2H_to_C1H = var_IKr__A1_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B1_HERG); // per_ms
        const double var_IKr__C2H_to_C3H = 0.026083620433370001 * var_IKr__T_Const_HERG; // per_ms
        const double var_IKr__C3H_to_C2H = 0.14832978132145 * var_IKr__T_Const_HERG; // per_ms
        const double var_IKr__a1_C2 = var_IKr__C1H_to_C2H * var_chaste_interface__IKr__C1Herg + var_IKr__C3H_to_C2H * var_chaste_interface__IKr__C3Herg; // per_ms
        const double var_IKr__a2_C2 = (var_IKr__C2H_to_C1H + var_IKr__C2H_to_C3H) * var_chaste_interface__IKr__C2Herg; // per_ms
        const double d_dt_chaste_interface_var_IKr__C2Herg = -var_IKr__a2_C2 + var_IKr__a1_C2; // 1 / ms

        return d_dt_chaste_interface_var_IKr__C2Herg;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative59(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x341 = exp(-0.043060541639799998 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x344 = 0.21116826991639448 * var_x341;
            
            partialF = -0.13876486073161204 - var_x344;
        }
        else
        {
            const double y_save = rY[59];
            rY[59] += delta;
            const double temp = EvaluateYDerivative59(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[59])/delta;
            rY[59] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative60(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__IKr__C2Herg = rY[59];
        // Units: dimensionless; Initial value: 0.0004340879648
        double var_chaste_interface__IKr__C3Herg = rY[60];
        // Units: dimensionless; Initial value: 7.634099755e-05
        double var_chaste_interface__IKr__OHerg = rY[61];
        // Units: dimensionless; Initial value: 9.511789113e-06
        double var_chaste_interface__IKr__IHerg = rY[62];
        // Units: dimensionless; Initial value: 1.533347007e-06
        
        
        // Mathematics
        const double var_IKr__A2_HERG = 0.020574486059770001; // per_ms
        const double var_IKr__A3_HERG = 0.00134366604423; // per_ms
        const double var_IKr__A4_HERG = 0.10666316491288; // per_ms
        const double var_IKr__A5_HERG = 0.0064639391004900001; // per_ms
        const double var_IKr__A6_HERG = 8.0393744030000006e-5; // per_ms
        const double var_IKr__B2_HERG = 0.026174127151180001; // per_mV
        const double var_IKr__B3_HERG = -0.026913854983990002; // per_mV
        const double var_IKr__B4_HERG = 0.0056890885971700002; // per_mV
        const double var_IKr__B5_HERG = -0.045366429595429997; // per_mV
        const double var_IKr__B6_HERG = 6.9808923999999997e-7; // per_mV
        const double var_IKr__T_Const_HERG = 5.3200000010000004; // dimensionless
        const double var_IKr__C2H_to_C3H = 0.026083620433370001 * var_IKr__T_Const_HERG; // per_ms
        const double var_IKr__C3H_to_C2H = 0.14832978132145 * var_IKr__T_Const_HERG; // per_ms
        const double var_IKr__C3H_to_IH = var_IKr__A6_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B6_HERG); // per_ms
        const double var_IKr__C3H_to_OH = var_IKr__A2_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B2_HERG); // per_ms
        const double var_IKr__IH_to_OH = var_IKr__A5_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B5_HERG); // per_ms
        const double var_IKr__OH_to_C3H = var_IKr__A3_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B3_HERG); // per_ms
        const double var_IKr__OH_to_IH = var_IKr__A4_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B4_HERG); // per_ms
        const double var_IKr__IH_to_C3H = var_IKr__C3H_to_IH * var_IKr__IH_to_OH * var_IKr__OH_to_C3H / (var_IKr__C3H_to_OH * var_IKr__OH_to_IH); // per_ms
        const double var_IKr__a1_C3 = var_IKr__C2H_to_C3H * var_chaste_interface__IKr__C2Herg + var_IKr__IH_to_C3H * var_chaste_interface__IKr__IHerg + var_IKr__OH_to_C3H * var_chaste_interface__IKr__OHerg; // per_ms
        const double var_IKr__a2_C3 = (var_IKr__C3H_to_C2H + var_IKr__C3H_to_IH + var_IKr__C3H_to_OH) * var_chaste_interface__IKr__C3Herg; // per_ms
        const double d_dt_chaste_interface_var_IKr__C3Herg = -var_IKr__a2_C3 + var_IKr__a1_C3; // 1 / ms

        return d_dt_chaste_interface_var_IKr__C3Herg;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative60(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x345 = exp(6.9808923999999997e-7 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x347 = exp(0.026174127151180001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x355 = 0.10945626585855089 * var_x347;
            const double var_x356 = 0.00042769471831999382 * var_x345;
            
            partialF = -0.78911443677844384 - var_x355 - var_x356;
        }
        else
        {
            const double y_save = rY[60];
            rY[60] += delta;
            const double temp = EvaluateYDerivative60(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[60])/delta;
            rY[60] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative61(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__IKr__C3Herg = rY[60];
        // Units: dimensionless; Initial value: 7.634099755e-05
        double var_chaste_interface__IKr__OHerg = rY[61];
        // Units: dimensionless; Initial value: 9.511789113e-06
        double var_chaste_interface__IKr__IHerg = rY[62];
        // Units: dimensionless; Initial value: 1.533347007e-06
        
        
        // Mathematics
        const double var_IKr__A2_HERG = 0.020574486059770001; // per_ms
        const double var_IKr__A3_HERG = 0.00134366604423; // per_ms
        const double var_IKr__A4_HERG = 0.10666316491288; // per_ms
        const double var_IKr__A5_HERG = 0.0064639391004900001; // per_ms
        const double var_IKr__B2_HERG = 0.026174127151180001; // per_mV
        const double var_IKr__B3_HERG = -0.026913854983990002; // per_mV
        const double var_IKr__B4_HERG = 0.0056890885971700002; // per_mV
        const double var_IKr__B5_HERG = -0.045366429595429997; // per_mV
        const double var_IKr__T_Const_HERG = 5.3200000010000004; // dimensionless
        const double var_IKr__C3H_to_OH = var_IKr__A2_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B2_HERG); // per_ms
        const double var_IKr__IH_to_OH = var_IKr__A5_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B5_HERG); // per_ms
        const double var_IKr__OH_to_C3H = var_IKr__A3_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B3_HERG); // per_ms
        const double var_IKr__OH_to_IH = var_IKr__A4_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B4_HERG); // per_ms
        const double var_IKr__a1_O = var_IKr__C3H_to_OH * var_chaste_interface__IKr__C3Herg + var_IKr__IH_to_OH * var_chaste_interface__IKr__IHerg; // per_ms
        const double var_IKr__a2_O = (var_IKr__OH_to_C3H + var_IKr__OH_to_IH) * var_chaste_interface__IKr__OHerg; // per_ms
        const double d_dt_chaste_interface_var_IKr__OHerg = -var_IKr__a2_O + var_IKr__a1_O; // 1 / ms

        return d_dt_chaste_interface_var_IKr__OHerg;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative61(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x349 = exp(-0.026913854983990002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x352 = exp(0.0056890885971700002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x357 = 0.0071483033566472664 * var_x349;
            const double var_x361 = 0.56744803744318484 * var_x352;
            
            partialF = -var_x357 - var_x361;
        }
        else
        {
            const double y_save = rY[61];
            rY[61] += delta;
            const double temp = EvaluateYDerivative61(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[61])/delta;
            rY[61] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative62(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__IKr__C3Herg = rY[60];
        // Units: dimensionless; Initial value: 7.634099755e-05
        double var_chaste_interface__IKr__OHerg = rY[61];
        // Units: dimensionless; Initial value: 9.511789113e-06
        double var_chaste_interface__IKr__IHerg = rY[62];
        // Units: dimensionless; Initial value: 1.533347007e-06
        
        
        // Mathematics
        const double var_IKr__A2_HERG = 0.020574486059770001; // per_ms
        const double var_IKr__A3_HERG = 0.00134366604423; // per_ms
        const double var_IKr__A4_HERG = 0.10666316491288; // per_ms
        const double var_IKr__A5_HERG = 0.0064639391004900001; // per_ms
        const double var_IKr__A6_HERG = 8.0393744030000006e-5; // per_ms
        const double var_IKr__B2_HERG = 0.026174127151180001; // per_mV
        const double var_IKr__B3_HERG = -0.026913854983990002; // per_mV
        const double var_IKr__B4_HERG = 0.0056890885971700002; // per_mV
        const double var_IKr__B5_HERG = -0.045366429595429997; // per_mV
        const double var_IKr__B6_HERG = 6.9808923999999997e-7; // per_mV
        const double var_IKr__T_Const_HERG = 5.3200000010000004; // dimensionless
        const double var_IKr__C3H_to_IH = var_IKr__A6_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B6_HERG); // per_ms
        const double var_IKr__C3H_to_OH = var_IKr__A2_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B2_HERG); // per_ms
        const double var_IKr__IH_to_OH = var_IKr__A5_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B5_HERG); // per_ms
        const double var_IKr__OH_to_C3H = var_IKr__A3_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B3_HERG); // per_ms
        const double var_IKr__OH_to_IH = var_IKr__A4_HERG * var_IKr__T_Const_HERG * exp(var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V * var_IKr__B4_HERG); // per_ms
        const double var_IKr__IH_to_C3H = var_IKr__C3H_to_IH * var_IKr__IH_to_OH * var_IKr__OH_to_C3H / (var_IKr__C3H_to_OH * var_IKr__OH_to_IH); // per_ms
        const double var_IKr__a1_I = var_IKr__C3H_to_IH * var_chaste_interface__IKr__C3Herg + var_IKr__OH_to_IH * var_chaste_interface__IKr__OHerg; // per_ms
        const double var_IKr__a2_I = (var_IKr__IH_to_C3H + var_IKr__IH_to_OH) * var_chaste_interface__IKr__IHerg; // per_ms
        const double d_dt_chaste_interface_var_IKr__IHerg = -var_IKr__a2_I + var_IKr__a1_I; // 1 / ms

        return d_dt_chaste_interface_var_IKr__IHerg;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative62(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x345 = exp(6.9808923999999997e-7 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x347 = exp(0.026174127151180001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x349 = exp(-0.026913854983990002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x351 = exp(-0.045366429595429997 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x352 = exp(0.0056890885971700002 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x353 = var_x345 * var_x349 * var_x351 / (var_x347 * var_x352);
            const double var_x358 = 1.6926962184371784e-6 * var_x353;
            const double var_x362 = 0.034388156021070745 * var_x351;
            
            partialF = -var_x358 - var_x362;
        }
        else
        {
            const double y_save = rY[62];
            rY[62] += delta;
            const double temp = EvaluateYDerivative62(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[62])/delta;
            rY[62] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative63(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__IKs__C0ks = rY[63];
        // Units: dimensionless; Initial value: 0.9645606295
        double var_chaste_interface__IKs__C1ks = rY[64];
        // Units: dimensionless; Initial value: 0.03542613568
        
        
        // Mathematics
        const double var_IKs__C0ks_C1ks = 0.0079560079800399999; // per_ms
        const double var_IKs__C1ks_C0ks = 0.21625575895849999 * exp(-1.8891230210000001e-5 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double d_dt_chaste_interface_var_IKs__C0ks = var_chaste_interface__IKs__C1ks * var_IKs__C1ks_C0ks - var_chaste_interface__IKs__C0ks * var_IKs__C0ks_C1ks; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C0ks;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative63(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.0079560079800399999;
        }
        else
        {
            const double y_save = rY[63];
            rY[63] += delta;
            const double temp = EvaluateYDerivative63(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[63])/delta;
            rY[63] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative64(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__IKs__C0ks = rY[63];
        // Units: dimensionless; Initial value: 0.9645606295
        double var_chaste_interface__IKs__C1ks = rY[64];
        // Units: dimensionless; Initial value: 0.03542613568
        double var_chaste_interface__IKs__O1ks = rY[65];
        // Units: dimensionless; Initial value: 2.491710696e-07
        
        
        // Mathematics
        const double var_IKs__C0ks_C1ks = 0.0079560079800399999; // per_ms
        const double var_IKs__C1ks_C0ks = 0.21625575895849999 * exp(-1.8891230210000001e-5 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_IKs__C1ks_O1ks = 0.039667206760709998; // per_ms
        const double var_IKs__O1ks_C1ks = 0.0070080662892900002 * exp(-0.14999754700285001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double d_dt_chaste_interface_var_IKs__C1ks = var_chaste_interface__IKs__C0ks * var_IKs__C0ks_C1ks + var_chaste_interface__IKs__O1ks * var_IKs__O1ks_C1ks - (var_IKs__C1ks_C0ks + var_IKs__C1ks_O1ks) * var_chaste_interface__IKs__C1ks; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C1ks;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative64(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x363 = exp(-1.8891230210000001e-5 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x365 = 0.21625575895849999 * var_x363;
            
            partialF = -0.039667206760709998 - var_x365;
        }
        else
        {
            const double y_save = rY[64];
            rY[64] += delta;
            const double temp = EvaluateYDerivative64(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[64])/delta;
            rY[64] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative65(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__IKs__C1ks = rY[64];
        // Units: dimensionless; Initial value: 0.03542613568
        double var_chaste_interface__IKs__O1ks = rY[65];
        // Units: dimensionless; Initial value: 2.491710696e-07
        double var_chaste_interface__IKs__O2ks = rY[66];
        // Units: dimensionless; Initial value: 1.298547822e-05
        
        
        // Mathematics
        const double var_IKs__C1ks_O1ks = 0.039667206760709998; // per_ms
        const double var_IKs__O1ks_C1ks = 0.0070080662892900002 * exp(-0.14999754700285001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_IKs__O1ks_O2ks = 0.00767254363063 * exp(0.08662945914655 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_IKs__O2ks_O1ks = 0.0037973799836799999 * exp(-0.014256681268810001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double d_dt_chaste_interface_var_IKs__O1ks = var_chaste_interface__IKs__C1ks * var_IKs__C1ks_O1ks + var_chaste_interface__IKs__O2ks * var_IKs__O2ks_O1ks - (var_IKs__O1ks_C1ks + var_IKs__O1ks_O2ks) * var_chaste_interface__IKs__O1ks; // 1 / ms

        return d_dt_chaste_interface_var_IKs__O1ks;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative65(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x366 = exp(-0.14999754700285001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x368 = 0.0070080662892900002 * var_x366;
            const double var_x369 = exp(0.08662945914655 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x373 = 0.00767254363063 * var_x369;
            
            partialF = -var_x368 - var_x373;
        }
        else
        {
            const double y_save = rY[65];
            rY[65] += delta;
            const double temp = EvaluateYDerivative65(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[65])/delta;
            rY[65] = y_save;
        }
        return partialF;
    }
    double Celliyer_model_2004FromCellMLGRL2::EvaluateYDerivative66(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -90.65755929
        double var_chaste_interface__IKs__O1ks = rY[65];
        // Units: dimensionless; Initial value: 2.491710696e-07
        double var_chaste_interface__IKs__O2ks = rY[66];
        // Units: dimensionless; Initial value: 1.298547822e-05
        
        
        // Mathematics
        const double var_IKs__O1ks_O2ks = 0.00767254363063 * exp(0.08662945914655 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double var_IKs__O2ks_O1ks = 0.0037973799836799999 * exp(-0.014256681268810001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V); // per_ms
        const double d_dt_chaste_interface_var_IKs__O2ks = var_chaste_interface__IKs__O1ks * var_IKs__O1ks_O2ks - var_chaste_interface__IKs__O2ks * var_IKs__O2ks_O1ks; // 1 / ms

        return d_dt_chaste_interface_var_IKs__O2ks;
    }

    double Celliyer_model_2004FromCellMLGRL2::EvaluatePartialDerivative66(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -90.65755929
            
            const double var_x371 = exp(-0.014256681268810001 * var_chaste_interface__COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__V);
            const double var_x374 = 0.0037973799836799999 * var_x371;
            
            partialF = -var_x374;
        }
        else
        {
            const double y_save = rY[66];
            rY[66] += delta;
            const double temp = EvaluateYDerivative66(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[66])/delta;
            rY[66] = y_save;
        }
        return partialF;
    }

    std::vector<double> Celliyer_model_2004FromCellMLGRL2::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_I_stimulus__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_I_stimulus__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celliyer_model_2004FromCellMLGRL2>::Initialise(void)
{
    this->mSystemName = "iyer_model_2004";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-90.65755929);

    // rY[1]:
    this->mVariableNames.push_back("COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Nai");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(9.798304162);

    // rY[2]:
    this->mVariableNames.push_back("COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Ki");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(125.5589432);

    // rY[3]:
    this->mVariableNames.push_back("COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__Cai");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(8.601192016e-05);

    // rY[4]:
    this->mVariableNames.push_back("COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaSS");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.0001420215245);

    // rY[5]:
    this->mVariableNames.push_back("COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaJSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.2852239446);

    // rY[6]:
    this->mVariableNames.push_back("COMPUTE_CONCENTRATION_AND_VOLTAGE_DERIVATIVES__CaNSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.2855294915);

    // rY[7]:
    this->mVariableNames.push_back("COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__LTRPNCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.08046584973);

    // rY[8]:
    this->mVariableNames.push_back("COMPUTE_Jtrpn_and_BUFFER_SCALE_FACTORS__HTRPNCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9772152481);

    // rY[9]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C1_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4448038946);

    // rY[10]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O2_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.97392006e-09);

    // rY[11]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__C2_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.554535924);

    // rY[12]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_RyR_RECEPTOR_STATES__O1_RyR");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0006601783287);

    // rY[13]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8621934054);

    // rY[14]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01141398211);

    // rY[15]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(5.666325225e-05);

    // rY[16]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.25021357e-07);

    // rY[17]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.034426748e-10);

    // rY[18]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa0");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1198547081);

    // rY[19]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.006346794302);

    // rY[20]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001260326488);

    // rY[21]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.112315238e-06);

    // rY[22]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__CCa4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.681315892e-09);

    // rY[23]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__Open");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.757981563e-12);

    // rY[24]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_LTYPE_CHANNEL_STATES__yCa");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9997157074);

    // rY[25]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C0Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9513721351);

    // rY[26]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C1Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02668288089);

    // rY[27]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C2Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0002806380358);

    // rY[28]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__C3Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.311837579e-06);

    // rY[29]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OKv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.29955624e-09);

    // rY[30]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI0Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01513025204);

    // rY[31]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI1Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.005442964601);

    // rY[32]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI2Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0009918373359);

    // rY[33]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__CI3Kv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.514386057e-05);

    // rY[34]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv4_3_CHANNEL_STATES__OIKv43");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.742677382e-06);

    // rY[35]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C0Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5977099765);

    // rY[36]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C1Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1730990528);

    // rY[37]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C2Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01881072386);

    // rY[38]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__C3Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000916070135);

    // rY[39]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OKv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.975541357e-05);

    // rY[40]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI0Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.03539084346);

    // rY[41]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI1Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.005428824353);

    // rY[42]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI2Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02287858869);

    // rY[43]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__CI3Kv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.03233800003);

    // rY[44]:
    this->mVariableNames.push_back("COMPUTE_DERIVATIVES_OF_Kv1_4_CHANNEL_STATES__OIKv14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1134082058);

    // rY[45]:
    this->mVariableNames.push_back("INa__na1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1437575649);

    // rY[46]:
    this->mVariableNames.push_back("INa__na2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0417776208);

    // rY[47]:
    this->mVariableNames.push_back("INa__na3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004552898364);

    // rY[48]:
    this->mVariableNames.push_back("INa__na4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000220520743);

    // rY[49]:
    this->mVariableNames.push_back("INa__na5");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(4.005266484e-06);

    // rY[50]:
    this->mVariableNames.push_back("INa__na6");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.57442749e-08);

    // rY[51]:
    this->mVariableNames.push_back("INa__na7");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.856607179e-09);

    // rY[52]:
    this->mVariableNames.push_back("INa__na8");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4749950008);

    // rY[53]:
    this->mVariableNames.push_back("INa__na9");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.2707214097);

    // rY[54]:
    this->mVariableNames.push_back("INa__na10");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.05786120057);

    // rY[55]:
    this->mVariableNames.push_back("INa__na11");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.005496292279);

    // rY[56]:
    this->mVariableNames.push_back("INa__na12");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001957874519);

    // rY[57]:
    this->mVariableNames.push_back("INa__na13");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000417679396);

    // rY[58]:
    this->mVariableNames.push_back("IKr__C1Herg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.996697338);

    // rY[59]:
    this->mVariableNames.push_back("IKr__C2Herg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0004340879648);

    // rY[60]:
    this->mVariableNames.push_back("IKr__C3Herg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.634099755e-05);

    // rY[61]:
    this->mVariableNames.push_back("IKr__OHerg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(9.511789113e-06);

    // rY[62]:
    this->mVariableNames.push_back("IKr__IHerg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.533347007e-06);

    // rY[63]:
    this->mVariableNames.push_back("IKs__C0ks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9645606295);

    // rY[64]:
    this->mVariableNames.push_back("IKs__C1ks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.03542613568);

    // rY[65]:
    this->mVariableNames.push_back("IKs__O1ks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.491710696e-07);

    // rY[66]:
    this->mVariableNames.push_back("IKs__O2ks");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.298547822e-05);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.00001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celliyer_model_2004FromCellMLGRL2)
