//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: demir_model_1994
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "demir_model_1994.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    double Celldemir_model_1994FromCellMLGRL2::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Celldemir_model_1994FromCellMLGRL2::Celldemir_model_1994FromCellMLGRL2(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                27,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celldemir_model_1994FromCellMLGRL2>::Instance();
        Init();
        
        this->mParameters[0] = 5.5000000000000002e-5; // (var_membrane__Cm) [microF]
    }

    Celldemir_model_1994FromCellMLGRL2::~Celldemir_model_1994FromCellMLGRL2()
    {
    }
    
    double Celldemir_model_1994FromCellMLGRL2::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.021149999999999999; // microS
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T = 0.02521; // microS
        const double var_calcium_pump_current__i_Ca_P_max = 0.02869; // nanoA
        const double var_cleft_space_equations__K_b = 5.4000000000000004; // millimolar
        const double var_delayed_rectifying_potassium_current__g_K = 0.0069300000000000004 * pow(var_cleft_space_equations__K_b, 0.58999999999999997); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = 0.0128821; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na = 0.0067478; // microS
        const double var_calcium_pump_current__i_Ca_P = var_calcium_pump_current__i_Ca_P_max * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_linear_background_current__g_B_Ca = 3.6399999999999997e-5; // microS
        const double var_linear_background_current__g_B_K = 6.9400000000000006e-5; // microS
        const double var_linear_background_current__g_B_Na = 0.00016000000000000001; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na; // nanoA
        const double var_hyperpolarisation_activated_current__i_f = var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na; // nanoA
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Ca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i) / var_membrane__F; // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifying_potassium_current__g_K * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_K; // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Na; // nanoA
        const double var_linear_background_current__i_B = var_linear_background_current__i_B_Ca + var_linear_background_current__i_B_K + var_linear_background_current__i_B_Na; // nanoA
        const double var_sodium_calcium_pump__K_NaCa = 1.2480000000000001e-5; // nanoA
        const double var_sodium_calcium_pump__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_pump__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_pump__i_NaCa = (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_pump__gamma) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_pump__gamma) * var_chaste_interface__membrane__V)) * var_sodium_calcium_pump__K_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c) * var_sodium_calcium_pump__d_NaCa); // nanoA
        const double var_sodium_current__P_Na = 0.0034399999999999999; // mul_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.46; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.21920000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.6000000000000001 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_chaste_interface__cleft_space_equations__K_c + var_sodium_potassium_pump__K_m_K), 2) * pow((var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_calcium_pump_current__i_Ca_P + var_delayed_rectifying_potassium_current__i_K + var_hyperpolarisation_activated_current__i_f + var_linear_background_current__i_B + var_sodium_calcium_pump__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celldemir_model_1994FromCellMLGRL2::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.021149999999999999; // microS
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T = 0.02521; // microS
        const double var_calcium_pump_current__i_Ca_P_max = 0.02869; // nanoA
        const double var_cleft_space_equations__K_b = 5.4000000000000004; // millimolar
        const double var_delayed_rectifying_potassium_current__g_K = 0.0069300000000000004 * pow(var_cleft_space_equations__K_b, 0.58999999999999997); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = 0.0128821; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na = 0.0067478; // microS
        const double var_calcium_pump_current__i_Ca_P = var_calcium_pump_current__i_Ca_P_max * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_linear_background_current__g_B_Ca = 3.6399999999999997e-5; // microS
        const double var_linear_background_current__g_B_K = 6.9400000000000006e-5; // microS
        const double var_linear_background_current__g_B_Na = 0.00016000000000000001; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na; // nanoA
        const double var_hyperpolarisation_activated_current__i_f = var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na; // nanoA
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Ca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i) / var_membrane__F; // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifying_potassium_current__g_K * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_K; // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Na; // nanoA
        const double var_linear_background_current__i_B = var_linear_background_current__i_B_Ca + var_linear_background_current__i_B_K + var_linear_background_current__i_B_Na; // nanoA
        const double var_sodium_calcium_pump__K_NaCa = 1.2480000000000001e-5; // nanoA
        const double var_sodium_calcium_pump__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_pump__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_pump__i_NaCa = (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_pump__gamma) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_pump__gamma) * var_chaste_interface__membrane__V)) * var_sodium_calcium_pump__K_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c) * var_sodium_calcium_pump__d_NaCa); // nanoA
        const double var_sodium_current__P_Na = 0.0034399999999999999; // mul_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.46; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.21920000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.6000000000000001 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_chaste_interface__cleft_space_equations__K_c + var_sodium_potassium_pump__K_m_K), 2) * pow((var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_membrane__V_orig_deriv = (-var_L_type_Ca_channel__i_Ca_L - var_T_type_Ca_channel__i_Ca_T - var_calcium_pump_current__i_Ca_P - var_delayed_rectifying_potassium_current__i_K - var_hyperpolarisation_activated_current__i_f - var_linear_background_current__i_B - var_sodium_calcium_pump__i_NaCa - var_sodium_current__i_Na - var_sodium_potassium_pump__i_NaK) / mParameters[0]; // millivolt / second
        d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Celldemir_model_1994FromCellMLGRL2::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod = rY[14];
        // Units: dimensionless; Initial value: 0.1411678
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop = rY[15];
        // Units: dimensionless; Initial value: 0.07331396
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = rY[16];
        // Units: dimensionless; Initial value: 0.7618549
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = rY[17];
        // Units: dimensionless; Initial value: 0.2097049
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rY[21];
        // Units: millimolar; Initial value: 16.95311
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rY[22];
        // Units: millimolar; Initial value: 16.85024
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse = rY[23];
        // Units: dimensionless; Initial value: 0.9528726
        double var_chaste_interface__SR_Ca_uptake_and_release__F1 = rY[24];
        // Units: dimensionless; Initial value: 0.1133251
        double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rY[25];
        // Units: dimensionless; Initial value: 0.0007594214
        double var_chaste_interface__SR_Ca_uptake_and_release__F3 = rY[26];
        // Units: dimensionless; Initial value: 0.8859153
        
        
        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.021149999999999999; // microS
        const double var_SR_Ca_uptake_and_release__alpha_rel = 0.5; // nanoA_per_millimolar
        const double var_SR_Ca_uptake_and_release__alpha_up = 0.080000000000000002; // nanoA
        const double var_SR_Ca_uptake_and_release__beta_up = 0.071999999999999995; // nanoA
        const double var_SR_Ca_uptake_and_release__i_rel = pow(var_chaste_interface__SR_Ca_uptake_and_release__F2, 2) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel * var_SR_Ca_uptake_and_release__alpha_rel / pow((0.25 + var_chaste_interface__SR_Ca_uptake_and_release__F2), 2); // nanoA
        const double var_SR_Ca_uptake_and_release__k_SRCa = 22.0; // millimolar
        const double var_SR_Ca_uptake_and_release__k_cyca = 5.0000000000000002e-5; // millimolar
        const double var_SR_Ca_uptake_and_release__k_rel = 0.0040000000000000001; // millimolar
        const double var_SR_Ca_uptake_and_release__k_xcs = 0.90000000000000002; // dimensionless
        const double var_SR_Ca_uptake_and_release__K1 = var_SR_Ca_uptake_and_release__k_cyca * var_SR_Ca_uptake_and_release__k_xcs / var_SR_Ca_uptake_and_release__k_SRCa; // dimensionless
        const double var_SR_Ca_uptake_and_release__phi_Calse = -641.0 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse + 770.0 * (1.0 - var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel; // per_second
        const double var_SR_Ca_uptake_and_release__Ca_Calse_orig_deriv = var_SR_Ca_uptake_and_release__phi_Calse; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_Calse = 0.001 * var_SR_Ca_uptake_and_release__Ca_Calse_orig_deriv; // 1 / millisecond
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T = 0.02521; // microS
        const double var_calcium_pump_current__i_Ca_P_max = 0.02869; // nanoA
        const double var_cleft_space_equations__Ca_b = 2.0; // millimolar
        const double var_cleft_space_equations__K_b = 5.4000000000000004; // millimolar
        const double var_cleft_space_equations__Na_b = 140.0; // millimolar
        const double var_cleft_space_equations__Vol = 3.4970000000000001e-6; // microLitre
        const double var_cleft_space_equations__V_c = 0.13600000000000001 * var_cleft_space_equations__Vol; // microLitre
        const double var_cleft_space_equations__tau_p = 0.01; // second
        const double var_delayed_rectifying_potassium_current__g_K = 0.0069300000000000004 * pow(var_cleft_space_equations__K_b, 0.58999999999999997); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = 0.0128821; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na = 0.0067478; // microS
        const double var_SR_Ca_uptake_and_release__K2 = var_chaste_interface__SR_Ca_uptake_and_release__Ca_up * var_SR_Ca_uptake_and_release__K1 + var_SR_Ca_uptake_and_release__k_cyca * var_SR_Ca_uptake_and_release__k_xcs + var_SR_Ca_uptake_and_release__k_cyca + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // millimolar
        const double var_SR_Ca_uptake_and_release__i_up = (var_SR_Ca_uptake_and_release__alpha_up * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i - var_chaste_interface__SR_Ca_uptake_and_release__Ca_up * var_SR_Ca_uptake_and_release__K1 * var_SR_Ca_uptake_and_release__beta_up) / var_SR_Ca_uptake_and_release__K2; // nanoA
        const double var_SR_Ca_uptake_and_release__r_inact = 40.0 + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((var_SR_Ca_uptake_and_release__k_rel + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double var_SR_Ca_uptake_and_release__F3_orig_deriv = -0.95999999999999996 * var_chaste_interface__SR_Ca_uptake_and_release__F3 + var_chaste_interface__SR_Ca_uptake_and_release__F2 * var_SR_Ca_uptake_and_release__r_inact; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F3 = 0.001 * var_SR_Ca_uptake_and_release__F3_orig_deriv; // 1 / millisecond
        const double var_calcium_pump_current__i_Ca_P = var_calcium_pump_current__i_Ca_P_max * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_intracellular_concentrations_and_buffer_equations__Mg_i = 2.5; // millimolar
        const double var_intracellular_concentrations_and_buffer_equations__V_i = 0.46500000000000002 * var_cleft_space_equations__Vol; // microLitre
        const double var_SR_Ca_uptake_and_release__V_rel = 0.0012960000000000001 * var_intracellular_concentrations_and_buffer_equations__V_i; // microLitre
        const double var_SR_Ca_uptake_and_release__V_up = 0.01166 * var_intracellular_concentrations_and_buffer_equations__V_i; // microLitre
        const double var_intracellular_concentrations_and_buffer_equations__phi_C = -307.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__Ca_Calmod_orig_deriv = var_intracellular_concentrations_and_buffer_equations__phi_C; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Calmod = 0.001 * var_intracellular_concentrations_and_buffer_equations__Ca_Calmod_orig_deriv; // 1 / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__F_C = 0.089999999999999997 * var_intracellular_concentrations_and_buffer_equations__phi_C; // millimolar_per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_TC = -252.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop + 50500.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__Ca_Trop_orig_deriv = var_intracellular_concentrations_and_buffer_equations__phi_TC; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__Ca_Trop_orig_deriv; // 1 / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__F_TC = 0.031 * var_intracellular_concentrations_and_buffer_equations__phi_TC; // millimolar_per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_TMgC = -4.25 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop_orig_deriv = var_intracellular_concentrations_and_buffer_equations__phi_TMgC; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop_orig_deriv; // 1 / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__F_TMgC = 0.062 * var_intracellular_concentrations_and_buffer_equations__phi_TMgC; // millimolar_per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_B = var_intracellular_concentrations_and_buffer_equations__F_C + var_intracellular_concentrations_and_buffer_equations__F_TC + var_intracellular_concentrations_and_buffer_equations__F_TMgC; // millimolar_per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_TMgM = -429.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop + 1290.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop) * var_intracellular_concentrations_and_buffer_equations__Mg_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop_orig_deriv = var_intracellular_concentrations_and_buffer_equations__phi_TMgM; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop_orig_deriv; // 1 / millisecond
        const double var_linear_background_current__g_B_Ca = 3.6399999999999997e-5; // microS
        const double var_linear_background_current__g_B_K = 6.9400000000000006e-5; // microS
        const double var_linear_background_current__g_B_Na = 0.00016000000000000001; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_SR_Ca_uptake_and_release__i_tr = 31.162355874104083 * (-var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel + var_chaste_interface__SR_Ca_uptake_and_release__Ca_up) * var_SR_Ca_uptake_and_release__V_up * var_membrane__F; // nanoA
        const double var_SR_Ca_uptake_and_release__Ca_rel_orig_deriv = -11.48 * var_SR_Ca_uptake_and_release__phi_Calse + 0.5 * (-var_SR_Ca_uptake_and_release__i_rel + var_SR_Ca_uptake_and_release__i_tr) / (var_SR_Ca_uptake_and_release__V_rel * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_rel = 0.001 * var_SR_Ca_uptake_and_release__Ca_rel_orig_deriv; // millimolar / millisecond
        const double var_SR_Ca_uptake_and_release__Ca_up_orig_deriv = 0.5 * (-var_SR_Ca_uptake_and_release__i_tr + var_SR_Ca_uptake_and_release__i_up) / (var_SR_Ca_uptake_and_release__V_up * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_up = 0.001 * var_SR_Ca_uptake_and_release__Ca_up_orig_deriv; // millimolar / millisecond
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel_d_gate__alpha_d_L = -28.390000000000001 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V)) - 84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V)); // per_second
        const double var_L_type_Ca_channel_d_gate__beta_d_L = 11.43 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)); // per_second
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_L_type_Ca_channel_d_gate__tau_d_L = 1 / (var_L_type_Ca_channel_d_gate__alpha_d_L + var_L_type_Ca_channel_d_gate__beta_d_L); // second
        const double var_L_type_Ca_channel_d_gate__d_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_d_gate__d_L + var_L_type_Ca_channel_d_gate__d_L_infinity) / var_L_type_Ca_channel_d_gate__tau_d_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L = 0.001 * var_L_type_Ca_channel_d_gate__d_L_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_gate__alpha_f_L = 3.75 * (28.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(7.0 + 0.25 * var_chaste_interface__membrane__V)); // per_second
        const double var_L_type_Ca_channel_f_gate__beta_f_L = 30.0 / (1.0 + exp(-7.0 - 0.25 * var_chaste_interface__membrane__V)); // per_second
        const double var_L_type_Ca_channel_f_gate__f_L_infinity = 1 / (1.0 + exp(6.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_gate__tau_f_L = 1 / (var_L_type_Ca_channel_f_gate__alpha_f_L + var_L_type_Ca_channel_f_gate__beta_f_L); // second
        const double var_L_type_Ca_channel_f_gate__f_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_gate__f_L + var_L_type_Ca_channel_f_gate__f_L_infinity) / var_L_type_Ca_channel_f_gate__tau_f_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L = 0.001 * var_L_type_Ca_channel_f_gate__f_L_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_uptake_and_release__r_act = 240.0 * exp(-3.2000000000000002 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((var_SR_Ca_uptake_and_release__k_rel + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double var_SR_Ca_uptake_and_release__F1_orig_deriv = 0.95999999999999996 * var_chaste_interface__SR_Ca_uptake_and_release__F3 - var_chaste_interface__SR_Ca_uptake_and_release__F1 * var_SR_Ca_uptake_and_release__r_act; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F1 = 0.001 * var_SR_Ca_uptake_and_release__F1_orig_deriv; // 1 / millisecond
        const double var_SR_Ca_uptake_and_release__F2_orig_deriv = var_chaste_interface__SR_Ca_uptake_and_release__F1 * var_SR_Ca_uptake_and_release__r_act - var_chaste_interface__SR_Ca_uptake_and_release__F2 * var_SR_Ca_uptake_and_release__r_inact; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F2 = 0.001 * var_SR_Ca_uptake_and_release__F2_orig_deriv; // 1 / millisecond
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_T_type_Ca_channel_d_gate__alpha_d_T = 1068.0 * exp(0.87666666666666671 + 0.033333333333333333 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_d_gate__beta_d_T = 1068.0 * exp(-0.87666666666666671 - 0.033333333333333333 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_d_gate__d_T_infinity = 1 / (1.0 + exp(-4.3833333333333337 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_d_gate__tau_d_T = 1 / (var_T_type_Ca_channel_d_gate__alpha_d_T + var_T_type_Ca_channel_d_gate__beta_d_T); // second
        const double var_T_type_Ca_channel_d_gate__d_T_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_d_gate__d_T + var_T_type_Ca_channel_d_gate__d_T_infinity) / var_T_type_Ca_channel_d_gate__tau_d_T; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T = 0.001 * var_T_type_Ca_channel_d_gate__d_T_orig_deriv; // 1 / millisecond
        const double var_T_type_Ca_channel_f_gate__alpha_f_T = 15.300000000000001 * exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_f_gate__beta_f_T = 15.0 * exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_f_gate__f_T_infinity = 1 / (1.0 + exp(11.017857142857144 + 0.17857142857142858 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_f_gate__tau_f_T = 1 / (var_T_type_Ca_channel_f_gate__alpha_f_T + var_T_type_Ca_channel_f_gate__beta_f_T); // second
        const double var_T_type_Ca_channel_f_gate__f_T_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_f_gate__f_T + var_T_type_Ca_channel_f_gate__f_T_infinity) / var_T_type_Ca_channel_f_gate__tau_f_T; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T = 0.001 * var_T_type_Ca_channel_f_gate__f_T_orig_deriv; // 1 / millisecond
        const double var_delayed_rectifying_potassium_current_P_a_gate__P_a_infinity = 1 / (1.0 + exp(-0.68918918918918914 - 0.13513513513513511 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifying_potassium_current_P_a_gate__tau_P_a = 1 / (17.0 * exp(0.039800000000000002 * var_chaste_interface__membrane__V) + 2.1099999999999999 * exp(-0.050999999999999997 * var_chaste_interface__membrane__V)); // second
        const double var_delayed_rectifying_potassium_current_P_a_gate__P_a_orig_deriv = (-var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a + var_delayed_rectifying_potassium_current_P_a_gate__P_a_infinity) / var_delayed_rectifying_potassium_current_P_a_gate__tau_P_a; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_a_gate__P_a = 0.001 * var_delayed_rectifying_potassium_current_P_a_gate__P_a_orig_deriv; // 1 / millisecond
        const double var_delayed_rectifying_potassium_current_P_i_gate__alpha_P_i = 100.0 * exp(-0.0183 * var_chaste_interface__membrane__V); // per_second
        const double var_delayed_rectifying_potassium_current_P_i_gate__beta_P_i = 656.0 * exp(0.0094199999999999996 * var_chaste_interface__membrane__V); // per_second
        const double var_delayed_rectifying_potassium_current_P_i_gate__P_i_orig_deriv = (1.0 - var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i) * var_delayed_rectifying_potassium_current_P_i_gate__alpha_P_i - var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i * var_delayed_rectifying_potassium_current_P_i_gate__beta_P_i; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_i_gate__P_i = 0.001 * var_delayed_rectifying_potassium_current_P_i_gate__P_i_orig_deriv; // 1 / millisecond
        const double var_hyperpolarisation_activated_current__i_f_K = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na; // nanoA
        const double var_hyperpolarisation_activated_current_y_gate__tau_y = 1 / (1.6483000000000001 * exp(-2.2219482120838472 - 0.041101520756267988 * var_chaste_interface__membrane__V) + 14.01055 / (0.69999999999999996 + exp(-10.909090909090908 - 0.18181818181818182 * var_chaste_interface__membrane__V))); // second
        const double var_hyperpolarisation_activated_current_y_gate__y_infinity = 1 / (1.0 + exp(8.0222222222222221 + 0.1111111111111111 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_hyperpolarisation_activated_current_y_gate__y_orig_deriv = (-var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + var_hyperpolarisation_activated_current_y_gate__y_infinity) / var_hyperpolarisation_activated_current_y_gate__tau_y; // 1 / second
        const double d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y = 0.001 * var_hyperpolarisation_activated_current_y_gate__y_orig_deriv; // 1 / millisecond
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Ca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i) / var_membrane__F; // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifying_potassium_current__g_K * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_K; // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Na; // nanoA
        const double var_sodium_calcium_pump__K_NaCa = 1.2480000000000001e-5; // nanoA
        const double var_sodium_calcium_pump__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_pump__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_pump__i_NaCa = (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_pump__gamma) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_pump__gamma) * var_chaste_interface__membrane__V)) * var_sodium_calcium_pump__K_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c) * var_sodium_calcium_pump__d_NaCa); // nanoA
        const double var_cleft_space_equations__Ca_c_orig_deriv = (-var_chaste_interface__cleft_space_equations__Ca_c + var_cleft_space_equations__Ca_b) / var_cleft_space_equations__tau_p + 0.5 * (-2.0 * var_sodium_calcium_pump__i_NaCa + var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_calcium_pump_current__i_Ca_P + var_linear_background_current__i_B_Ca) / (var_cleft_space_equations__V_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_equations__Ca_c = 0.001 * var_cleft_space_equations__Ca_c_orig_deriv; // millimolar / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__Ca_i_orig_deriv = -var_intracellular_concentrations_and_buffer_equations__phi_B + 0.5 * (-var_L_type_Ca_channel__i_Ca_L - var_SR_Ca_uptake_and_release__i_up - var_T_type_Ca_channel__i_Ca_T - var_calcium_pump_current__i_Ca_P - var_linear_background_current__i_B_Ca + 2.0 * var_sodium_calcium_pump__i_NaCa + var_SR_Ca_uptake_and_release__i_rel) / (var_intracellular_concentrations_and_buffer_equations__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_i = 0.001 * var_intracellular_concentrations_and_buffer_equations__Ca_i_orig_deriv; // millimolar / millisecond
        const double var_sodium_current__P_Na = 0.0034399999999999999; // mul_per_second
        const double var_sodium_current_h_gate__alpha_h1 = 165.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V); // per_second
        const double var_sodium_current_h_gate__beta_h1 = 12360.0 / (1.0 + 320.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V)); // per_second
        const double var_sodium_current_h_gate__h1_infinity = var_sodium_current_h_gate__alpha_h1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1); // dimensionless
        const double var_sodium_current_h_gate__h2_infinity = var_sodium_current_h_gate__h1_infinity; // dimensionless
        const double var_sodium_current_h_gate__tau_h1 = 1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1); // second
        const double var_sodium_current_h_gate__h1_orig_deriv = (-var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__h1_infinity) / var_sodium_current_h_gate__tau_h1; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h1 = 0.001 * var_sodium_current_h_gate__h1_orig_deriv; // 1 / millisecond
        const double var_sodium_current_h_gate__tau_h2 = 20.0 * var_sodium_current_h_gate__tau_h1; // second
        const double var_sodium_current_h_gate__h2_orig_deriv = (-var_chaste_interface__sodium_current_h_gate__h2 + var_sodium_current_h_gate__h2_infinity) / var_sodium_current_h_gate__tau_h2; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h2 = 0.001 * var_sodium_current_h_gate__h2_orig_deriv; // 1 / millisecond
        const double var_sodium_current_m_gate__alpha_m = -824.0 * (51.899999999999999 + var_chaste_interface__membrane__V) / (-1.0 + exp(-5.8314606741573032 - 0.11235955056179775 * var_chaste_interface__membrane__V)); // per_second
        const double var_sodium_current_m_gate__beta_m = 32960.0 * exp(-5.8314606741573032 - 0.11235955056179775 * var_chaste_interface__membrane__V); // per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_current_m_gate__m_infinity = var_sodium_current_m_gate__alpha_m / (var_sodium_current_m_gate__alpha_m + var_sodium_current_m_gate__beta_m); // dimensionless
        const double var_sodium_current_m_gate__tau_m = 1.5e-5 + 1 / (var_sodium_current_m_gate__alpha_m + var_sodium_current_m_gate__beta_m); // second
        const double var_sodium_current_m_gate__m_orig_deriv = (-var_chaste_interface__sodium_current_m_gate__m + var_sodium_current_m_gate__m_infinity) / var_sodium_current_m_gate__tau_m; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * var_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.46; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.21920000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.6000000000000001 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_chaste_interface__cleft_space_equations__K_c + var_sodium_potassium_pump__K_m_K), 2) * pow((var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_cleft_space_equations__K_c_orig_deriv = (-var_chaste_interface__cleft_space_equations__K_c + var_cleft_space_equations__K_b) / var_cleft_space_equations__tau_p + (-2.0 * var_sodium_potassium_pump__i_NaK + var_delayed_rectifying_potassium_current__i_K + var_hyperpolarisation_activated_current__i_f_K + var_linear_background_current__i_B_K) / (var_cleft_space_equations__V_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_equations__K_c = 0.001 * var_cleft_space_equations__K_c_orig_deriv; // millimolar / millisecond
        const double var_cleft_space_equations__Na_c_orig_deriv = (-var_chaste_interface__cleft_space_equations__Na_c + var_cleft_space_equations__Na_b) / var_cleft_space_equations__tau_p + (3.0 * var_sodium_calcium_pump__i_NaCa + 3.0 * var_sodium_potassium_pump__i_NaK + var_hyperpolarisation_activated_current__i_f_Na + var_linear_background_current__i_B_Na + var_sodium_current__i_Na) / (var_cleft_space_equations__V_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_equations__Na_c = 0.001 * var_cleft_space_equations__Na_c_orig_deriv; // millimolar / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__K_i_orig_deriv = (-var_delayed_rectifying_potassium_current__i_K - var_hyperpolarisation_activated_current__i_f_K - var_linear_background_current__i_B_K + 2.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_concentrations_and_buffer_equations__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__K_i = 0.001 * var_intracellular_concentrations_and_buffer_equations__K_i_orig_deriv; // millimolar / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__Na_i_orig_deriv = (-var_hyperpolarisation_activated_current__i_f_Na - var_linear_background_current__i_B_Na - var_sodium_current__i_Na - 3.0 * var_sodium_calcium_pump__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_concentrations_and_buffer_equations__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Na_i = 0.001 * var_intracellular_concentrations_and_buffer_equations__Na_i_orig_deriv; // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_hyperpolarisation_activated_current__i_f = var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na; // nanoA
            const double var_linear_background_current__i_B = var_linear_background_current__i_B_Ca + var_linear_background_current__i_B_K + var_linear_background_current__i_B_Na; // nanoA
            const double var_membrane__V_orig_deriv = (-var_L_type_Ca_channel__i_Ca_L - var_T_type_Ca_channel__i_Ca_T - var_calcium_pump_current__i_Ca_P - var_delayed_rectifying_potassium_current__i_K - var_hyperpolarisation_activated_current__i_f - var_linear_background_current__i_B - var_sodium_calcium_pump__i_NaCa - var_sodium_current__i_Na - var_sodium_potassium_pump__i_NaK) / mParameters[0]; // millivolt / second
            d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        mEvalF[1] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_i;
        mEvalF[2] = d_dt_chaste_interface_var_sodium_current_m_gate__m;
        mEvalF[3] = d_dt_chaste_interface_var_sodium_current_h_gate__h1;
        mEvalF[4] = d_dt_chaste_interface_var_sodium_current_h_gate__h2;
        mEvalF[5] = d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L;
        mEvalF[6] = d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L;
        mEvalF[7] = d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T;
        mEvalF[8] = d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T;
        mEvalF[9] = d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_a_gate__P_a;
        mEvalF[10] = d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_i_gate__P_i;
        mEvalF[11] = d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;
        mEvalF[12] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Na_i;
        mEvalF[13] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__K_i;
        mEvalF[14] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Calmod;
        mEvalF[15] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Trop;
        mEvalF[16] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop;
        mEvalF[17] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop;
        mEvalF[18] = d_dt_chaste_interface_var_cleft_space_equations__Na_c;
        mEvalF[19] = d_dt_chaste_interface_var_cleft_space_equations__Ca_c;
        mEvalF[20] = d_dt_chaste_interface_var_cleft_space_equations__K_c;
        mEvalF[21] = d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_up;
        mEvalF[22] = d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_rel;
        mEvalF[23] = d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_Calse;
        mEvalF[24] = d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F1;
        mEvalF[25] = d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F2;
        mEvalF[26] = d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F3;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time_converted, rY, delta);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time_converted, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        rY[13] = y_save;
        
        
        y_save = rY[14];
        rY[14] = mYInit[14];
        mEvalF[14] = EvaluateYDerivative14(var_chaste_interface__environment__time_converted, rY);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time_converted, rY, delta);
        rY[14] = y_save;
        
        
        y_save = rY[15];
        rY[15] = mYInit[15];
        mEvalF[15] = EvaluateYDerivative15(var_chaste_interface__environment__time_converted, rY);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time_converted, rY, delta);
        rY[15] = y_save;
        
        
        y_save = rY[16];
        rY[16] = mYInit[16];
        mEvalF[16] = EvaluateYDerivative16(var_chaste_interface__environment__time_converted, rY);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time_converted, rY, delta);
        rY[16] = y_save;
        
        
        y_save = rY[17];
        rY[17] = mYInit[17];
        mEvalF[17] = EvaluateYDerivative17(var_chaste_interface__environment__time_converted, rY);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time_converted, rY, delta);
        rY[17] = y_save;
        
        
        y_save = rY[18];
        rY[18] = mYInit[18];
        mEvalF[18] = EvaluateYDerivative18(var_chaste_interface__environment__time_converted, rY);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time_converted, rY, delta);
        rY[18] = y_save;
        
        
        y_save = rY[19];
        rY[19] = mYInit[19];
        mEvalF[19] = EvaluateYDerivative19(var_chaste_interface__environment__time_converted, rY);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time_converted, rY, delta);
        rY[19] = y_save;
        
        
        y_save = rY[20];
        rY[20] = mYInit[20];
        mEvalF[20] = EvaluateYDerivative20(var_chaste_interface__environment__time_converted, rY);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time_converted, rY, delta);
        rY[20] = y_save;
        
        
        y_save = rY[21];
        rY[21] = mYInit[21];
        mEvalF[21] = EvaluateYDerivative21(var_chaste_interface__environment__time_converted, rY);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time_converted, rY, delta);
        rY[21] = y_save;
        
        
        y_save = rY[22];
        rY[22] = mYInit[22];
        mEvalF[22] = EvaluateYDerivative22(var_chaste_interface__environment__time_converted, rY);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time_converted, rY, delta);
        rY[22] = y_save;
        
        
        y_save = rY[23];
        rY[23] = mYInit[23];
        mEvalF[23] = EvaluateYDerivative23(var_chaste_interface__environment__time_converted, rY);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time_converted, rY, delta);
        rY[23] = y_save;
        
        
        y_save = rY[24];
        rY[24] = mYInit[24];
        mEvalF[24] = EvaluateYDerivative24(var_chaste_interface__environment__time_converted, rY);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time_converted, rY, delta);
        rY[24] = y_save;
        
        
        y_save = rY[25];
        rY[25] = mYInit[25];
        mEvalF[25] = EvaluateYDerivative25(var_chaste_interface__environment__time_converted, rY);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time_converted, rY, delta);
        rY[25] = y_save;
        
        
        y_save = rY[26];
        rY[26] = mYInit[26];
        mEvalF[26] = EvaluateYDerivative26(var_chaste_interface__environment__time_converted, rY);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time_converted, rY, delta);
        rY[26] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        
        // Mathematics
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.021149999999999999; // microS
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T = 0.02521; // microS
        const double var_calcium_pump_current__i_Ca_P_max = 0.02869; // nanoA
        const double var_cleft_space_equations__K_b = 5.4000000000000004; // millimolar
        const double var_delayed_rectifying_potassium_current__g_K = 0.0069300000000000004 * pow(var_cleft_space_equations__K_b, 0.58999999999999997); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = 0.0128821; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na = 0.0067478; // microS
        const double var_calcium_pump_current__i_Ca_P = var_calcium_pump_current__i_Ca_P_max * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_linear_background_current__g_B_Ca = 3.6399999999999997e-5; // microS
        const double var_linear_background_current__g_B_K = 6.9400000000000006e-5; // microS
        const double var_linear_background_current__g_B_Na = 0.00016000000000000001; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na; // nanoA
        const double var_hyperpolarisation_activated_current__i_f = var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na; // nanoA
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Ca; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i) / var_membrane__F; // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifying_potassium_current__g_K * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_K; // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Na; // nanoA
        const double var_linear_background_current__i_B = var_linear_background_current__i_B_Ca + var_linear_background_current__i_B_K + var_linear_background_current__i_B_Na; // nanoA
        const double var_sodium_calcium_pump__K_NaCa = 1.2480000000000001e-5; // nanoA
        const double var_sodium_calcium_pump__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_pump__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_pump__i_NaCa = (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_pump__gamma) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_pump__gamma) * var_chaste_interface__membrane__V)) * var_sodium_calcium_pump__K_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c) * var_sodium_calcium_pump__d_NaCa); // nanoA
        const double var_sodium_current__P_Na = 0.0034399999999999999; // mul_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.46; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.21920000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.6000000000000001 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_chaste_interface__cleft_space_equations__K_c + var_sodium_potassium_pump__K_m_K), 2) * pow((var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_membrane__V_orig_deriv = (-var_L_type_Ca_channel__i_Ca_L - var_T_type_Ca_channel__i_Ca_T - var_calcium_pump_current__i_Ca_P - var_delayed_rectifying_potassium_current__i_K - var_hyperpolarisation_activated_current__i_f - var_linear_background_current__i_B - var_sodium_calcium_pump__i_NaCa - var_sodium_current__i_Na - var_sodium_potassium_pump__i_NaK) / mParameters[0]; // millivolt / second
        d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane__V;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            double var_chaste_interface__sodium_current_m_gate__m = rY[2];
            // Units: dimensionless; Initial value: 0.250113
            double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
            // Units: dimensionless; Initial value: 0.001386897
            double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
            // Units: dimensionless; Initial value: 0.002065463
            double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
            // Units: dimensionless; Initial value: 0.002572773
            double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
            // Units: dimensionless; Initial value: 0.98651
            double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
            // Units: dimensionless; Initial value: 0.02012114
            double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
            // Units: dimensionless; Initial value: 0.1945111
            double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
            // Units: dimensionless; Initial value: 0.02302278
            double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
            // Units: dimensionless; Initial value: 0.3777728
            double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
            // Units: dimensionless; Initial value: 0.09227776
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
            // Units: millimolar; Initial value: 9.701621
            double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
            // Units: millimolar; Initial value: 139.9988
            double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
            // Units: millimolar; Initial value: 2.00474
            double var_chaste_interface__cleft_space_equations__K_c = rY[20];
            // Units: millimolar; Initial value: 5.389014
            
            const double var_x0 = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2);
            const double var_x1 = -0.16666666666666666 * var_chaste_interface__membrane__V;
            const double var_x2 = exp(-2.3500000000000001 + var_x1);
            const double var_x3 = 1.0 + var_x2;
            const double var_x4 = 1 / var_x3;
            const double var_x5 = var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L;
            const double var_x6 = var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T;
            const double var_x7 = pow(var_chaste_interface__cleft_space_equations__Na_c, 3);
            const double var_x8 = var_x7 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x9 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
            const double var_x10 = var_x9 * var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x11 = 1.0 + 0.0001 * var_x10 + 0.0001 * var_x8;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = 0.018714999999999999 * var_chaste_interface__membrane__V;
            const double var_x14 = exp(-var_x13);
            const double var_x15 = var_x14 * var_x8;
            const double var_x16 = exp(var_x13);
            const double var_x17 = var_x10 * var_x16;
            const double var_x18 = var_x12 * (0.018714999999999999 * var_x15 + 0.018714999999999999 * var_x17);
            const double var_x19 = var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i;
            const double var_x20 = 0.9813599999999999 - 0.021149999999999999 * var_chaste_interface__membrane__V;
            const double var_x21 = var_x2 / pow(var_x3, 2);
            const double var_x22 = 0.015833333333333335 * var_x21;
            const double var_x23 = 0.037433890822745473 * var_chaste_interface__membrane__V;
            const double var_x24 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
            const double var_x25 = var_x24 * var_chaste_interface__cleft_space_equations__Na_c;
            const double var_x26 = exp(var_x23 - 1.0 * log(var_x25));
            const double var_x27 = -1.0 + var_x26;
            const double var_x28 = var_x27 * var_chaste_interface__cleft_space_equations__Na_c;
            const double var_x29 = exp(var_x23);
            const double var_x30 = -1.0 + var_x29;
            const double var_x31 = 1 / var_x30;
            const double var_x32 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
            const double var_x33 = var_x31 * var_x32 * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2;
            const double var_x34 = 12.424666784589714 * var_x33;
            const double var_x35 = exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V);
            const double var_x36 = 0.621 + var_chaste_interface__cleft_space_equations__K_c;
            const double var_x37 = pow(var_x36, (-2));
            const double var_x38 = pow(var_chaste_interface__cleft_space_equations__K_c, 2);
            const double var_x39 = 1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
            const double var_x40 = pow(var_x39, (-3));
            const double var_x41 = var_x35 * var_x37 * var_x38 * var_x40 * var_x9 / pow((1 + 0.66666666666666663 * var_x35), 2);
            const double var_x42 = var_x33 * var_chaste_interface__membrane__V;
            const double var_x43 = var_x26 * var_x42;
            const double var_x44 = var_x43 * var_chaste_interface__cleft_space_equations__Na_c;
            const double var_x45 = var_x28 * var_chaste_interface__sodium_current_h_gate__h2;
            const double var_x46 = var_x45 * var_chaste_interface__membrane__V * var_chaste_interface__sodium_current_h_gate__h1;
            const double var_x47 = var_x29 * var_x32 * var_x46 / pow(var_x30, 2);
            const double var_x48 = 1 / mParameters[0];
            const double var_x49 = 0.001 * var_x48;
            
            partialF = var_x49 * (-0.00026580000000000001 + 0.46510361992332344 * var_x47 - 0.021149999999999999 * var_x5 - 0.02521 * var_x6 - 1.2480000000000001e-5 * var_x18 - 0.019629899999999999 * var_x0 - 0.018743278268729353 * var_x19 - 0.46510361992332344 * var_x44 - 0.0020092499999999998 * var_x4 - 2.3940879178437715e-5 * var_x41 + var_x20 * var_x22 - var_x28 * var_x34);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod = rY[14];
        // Units: dimensionless; Initial value: 0.1411678
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop = rY[15];
        // Units: dimensionless; Initial value: 0.07331396
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = rY[16];
        // Units: dimensionless; Initial value: 0.7618549
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = rY[17];
        // Units: dimensionless; Initial value: 0.2097049
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rY[21];
        // Units: millimolar; Initial value: 16.95311
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rY[22];
        // Units: millimolar; Initial value: 16.85024
        double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rY[25];
        // Units: dimensionless; Initial value: 0.0007594214
        
        
        // Mathematics
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.021149999999999999; // microS
        const double var_SR_Ca_uptake_and_release__alpha_rel = 0.5; // nanoA_per_millimolar
        const double var_SR_Ca_uptake_and_release__alpha_up = 0.080000000000000002; // nanoA
        const double var_SR_Ca_uptake_and_release__beta_up = 0.071999999999999995; // nanoA
        const double var_SR_Ca_uptake_and_release__i_rel = pow(var_chaste_interface__SR_Ca_uptake_and_release__F2, 2) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel * var_SR_Ca_uptake_and_release__alpha_rel / pow((0.25 + var_chaste_interface__SR_Ca_uptake_and_release__F2), 2); // nanoA
        const double var_SR_Ca_uptake_and_release__k_SRCa = 22.0; // millimolar
        const double var_SR_Ca_uptake_and_release__k_cyca = 5.0000000000000002e-5; // millimolar
        const double var_SR_Ca_uptake_and_release__k_xcs = 0.90000000000000002; // dimensionless
        const double var_SR_Ca_uptake_and_release__K1 = var_SR_Ca_uptake_and_release__k_cyca * var_SR_Ca_uptake_and_release__k_xcs / var_SR_Ca_uptake_and_release__k_SRCa; // dimensionless
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T = 0.02521; // microS
        const double var_calcium_pump_current__i_Ca_P_max = 0.02869; // nanoA
        const double var_cleft_space_equations__Vol = 3.4970000000000001e-6; // microLitre
        const double var_SR_Ca_uptake_and_release__K2 = var_chaste_interface__SR_Ca_uptake_and_release__Ca_up * var_SR_Ca_uptake_and_release__K1 + var_SR_Ca_uptake_and_release__k_cyca * var_SR_Ca_uptake_and_release__k_xcs + var_SR_Ca_uptake_and_release__k_cyca + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // millimolar
        const double var_SR_Ca_uptake_and_release__i_up = (var_SR_Ca_uptake_and_release__alpha_up * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i - var_chaste_interface__SR_Ca_uptake_and_release__Ca_up * var_SR_Ca_uptake_and_release__K1 * var_SR_Ca_uptake_and_release__beta_up) / var_SR_Ca_uptake_and_release__K2; // nanoA
        const double var_calcium_pump_current__i_Ca_P = var_calcium_pump_current__i_Ca_P_max * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_intracellular_concentrations_and_buffer_equations__V_i = 0.46500000000000002 * var_cleft_space_equations__Vol; // microLitre
        const double var_intracellular_concentrations_and_buffer_equations__phi_C = -307.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__F_C = 0.089999999999999997 * var_intracellular_concentrations_and_buffer_equations__phi_C; // millimolar_per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_TC = -252.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop + 50500.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__F_TC = 0.031 * var_intracellular_concentrations_and_buffer_equations__phi_TC; // millimolar_per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_TMgC = -4.25 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__F_TMgC = 0.062 * var_intracellular_concentrations_and_buffer_equations__phi_TMgC; // millimolar_per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_B = var_intracellular_concentrations_and_buffer_equations__F_C + var_intracellular_concentrations_and_buffer_equations__F_TC + var_intracellular_concentrations_and_buffer_equations__F_TMgC; // millimolar_per_second
        const double var_linear_background_current__g_B_Ca = 3.6399999999999997e-5; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Ca; // nanoA
        const double var_sodium_calcium_pump__K_NaCa = 1.2480000000000001e-5; // nanoA
        const double var_sodium_calcium_pump__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_pump__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_pump__i_NaCa = (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_pump__gamma) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_pump__gamma) * var_chaste_interface__membrane__V)) * var_sodium_calcium_pump__K_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c) * var_sodium_calcium_pump__d_NaCa); // nanoA
        const double var_intracellular_concentrations_and_buffer_equations__Ca_i_orig_deriv = -var_intracellular_concentrations_and_buffer_equations__phi_B + 0.5 * (-var_L_type_Ca_channel__i_Ca_L - var_SR_Ca_uptake_and_release__i_up - var_T_type_Ca_channel__i_Ca_T - var_calcium_pump_current__i_Ca_P - var_linear_background_current__i_B_Ca + 2.0 * var_sodium_calcium_pump__i_NaCa + var_SR_Ca_uptake_and_release__i_rel) / (var_intracellular_concentrations_and_buffer_equations__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_i = 0.001 * var_intracellular_concentrations_and_buffer_equations__Ca_i_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_i;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
            // Units: millimolar; Initial value: 9.701621
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod = rY[14];
            // Units: dimensionless; Initial value: 0.1411678
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop = rY[15];
            // Units: dimensionless; Initial value: 0.07331396
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = rY[16];
            // Units: dimensionless; Initial value: 0.7618549
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = rY[17];
            // Units: dimensionless; Initial value: 0.2097049
            double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
            // Units: millimolar; Initial value: 139.9988
            double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
            // Units: millimolar; Initial value: 2.00474
            double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rY[21];
            // Units: millimolar; Initial value: 16.95311
            
            const double var_x7 = pow(var_chaste_interface__cleft_space_equations__Na_c, 3);
            const double var_x8 = var_x7 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x9 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
            const double var_x10 = var_x9 * var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x11 = 1.0 + 0.0001 * var_x10 + 0.0001 * var_x8;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = 0.018714999999999999 * var_chaste_interface__membrane__V;
            const double var_x14 = exp(-var_x13);
            const double var_x15 = var_x14 * var_x8;
            const double var_x16 = exp(var_x13);
            const double var_x17 = var_x10 * var_x16;
            const double var_x50 = 0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x51 = 1 / var_x50;
            const double var_x52 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x53 = var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / pow(var_x50, 2);
            const double var_x55 = var_x14 * var_x7;
            const double var_x56 = (var_x17 - var_x15) / pow(var_x11, 2);
            const double var_x96 = 9.5000000000000005e-5 + 2.0454545454545457e-6 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x97 = 1 / var_x96;
            const double var_x98 = (0.080000000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i - 1.4727272727272728e-7 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up) / pow(var_x96, 2);
            const double var_x99 = 7.9543493648916639e-12 * var_x56;
            const double var_x100 = 7.9543493648916641e-8 * var_x12;
            
            partialF = -21.173500000000001 + 9.1430401954624137e-5 * var_x53 + 11.609999999999999 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod + 1.5654999999999999 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop + 0.0031868386878572369 * var_x98 + 7.9980000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop + 7.9980000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop - 9.1430401954624137e-5 * var_x51 - 0.00025494709502857897 * var_x97 - 1.5494105166262771e-6 * var_x52 - var_x100 * var_x55 - var_x7 * var_x99;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        
        
        // Mathematics
        const double var_sodium_current_m_gate__alpha_m = -824.0 * (51.899999999999999 + var_chaste_interface__membrane__V) / (-1.0 + exp(-5.8314606741573032 - 0.11235955056179775 * var_chaste_interface__membrane__V)); // per_second
        const double var_sodium_current_m_gate__beta_m = 32960.0 * exp(-5.8314606741573032 - 0.11235955056179775 * var_chaste_interface__membrane__V); // per_second
        const double var_sodium_current_m_gate__m_infinity = var_sodium_current_m_gate__alpha_m / (var_sodium_current_m_gate__alpha_m + var_sodium_current_m_gate__beta_m); // dimensionless
        const double var_sodium_current_m_gate__tau_m = 1.5e-5 + 1 / (var_sodium_current_m_gate__alpha_m + var_sodium_current_m_gate__beta_m); // second
        const double var_sodium_current_m_gate__m_orig_deriv = (-var_chaste_interface__sodium_current_m_gate__m + var_sodium_current_m_gate__m_infinity) / var_sodium_current_m_gate__tau_m; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * var_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_m_gate__m;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x112 = exp(-5.8314606741573032 - 0.11235955056179775 * var_chaste_interface__membrane__V);
            const double var_x113 = 51.899999999999999 + var_chaste_interface__membrane__V;
            const double var_x114 = -1.0 + var_x112;
            const double var_x115 = 1 / var_x114;
            const double var_x116 = 824.0 * var_x115;
            const double var_x117 = var_x113 * var_x116;
            const double var_x118 = 1 / (-var_x117 + 32960.0 * var_x112);
            const double var_x122 = 1.5e-5 + var_x118;
            const double var_x123 = 0.001 / var_x122;
            
            partialF = -var_x123;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        
        
        // Mathematics
        const double var_sodium_current_h_gate__alpha_h1 = 165.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V); // per_second
        const double var_sodium_current_h_gate__beta_h1 = 12360.0 / (1.0 + 320.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V)); // per_second
        const double var_sodium_current_h_gate__h1_infinity = var_sodium_current_h_gate__alpha_h1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1); // dimensionless
        const double var_sodium_current_h_gate__tau_h1 = 1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1); // second
        const double var_sodium_current_h_gate__h1_orig_deriv = (-var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__h1_infinity) / var_sodium_current_h_gate__tau_h1; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h1 = 0.001 * var_sodium_current_h_gate__h1_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_h_gate__h1;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x124 = exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V);
            const double var_x125 = 1 / (1.0 + 320.0 * var_x124);
            const double var_x132 = 0.16500000000000001 * var_x124;
            
            partialF = -var_x132 - 12.359999999999999 * var_x125;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        
        
        // Mathematics
        const double var_sodium_current_h_gate__alpha_h1 = 165.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V); // per_second
        const double var_sodium_current_h_gate__beta_h1 = 12360.0 / (1.0 + 320.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V)); // per_second
        const double var_sodium_current_h_gate__h1_infinity = var_sodium_current_h_gate__alpha_h1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1); // dimensionless
        const double var_sodium_current_h_gate__h2_infinity = var_sodium_current_h_gate__h1_infinity; // dimensionless
        const double var_sodium_current_h_gate__tau_h1 = 1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1); // second
        const double var_sodium_current_h_gate__tau_h2 = 20.0 * var_sodium_current_h_gate__tau_h1; // second
        const double var_sodium_current_h_gate__h2_orig_deriv = (-var_chaste_interface__sodium_current_h_gate__h2 + var_sodium_current_h_gate__h2_infinity) / var_sodium_current_h_gate__tau_h2; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h2 = 0.001 * var_sodium_current_h_gate__h2_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_h_gate__h2;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x124 = exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V);
            const double var_x125 = 1 / (1.0 + 320.0 * var_x124);
            
            partialF = -0.61799999999999999 * var_x125 - 0.0082500000000000004 * var_x124;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        
        
        // Mathematics
        const double var_L_type_Ca_channel_d_gate__alpha_d_L = -28.390000000000001 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V)) - 84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V)); // per_second
        const double var_L_type_Ca_channel_d_gate__beta_d_L = 11.43 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)); // per_second
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_d_gate__tau_d_L = 1 / (var_L_type_Ca_channel_d_gate__alpha_d_L + var_L_type_Ca_channel_d_gate__beta_d_L); // second
        const double var_L_type_Ca_channel_d_gate__d_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_d_gate__d_L + var_L_type_Ca_channel_d_gate__d_L_infinity) / var_L_type_Ca_channel_d_gate__tau_d_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L = 0.001 * var_L_type_Ca_channel_d_gate__d_L_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x134 = exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V);
            const double var_x135 = -1.0 + var_x134;
            const double var_x136 = 1 / var_x135;
            const double var_x138 = exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V);
            const double var_x139 = -1.0 + var_x138;
            const double var_x140 = 1 / var_x139;
            const double var_x142 = exp(-0.20799999999999999 * var_chaste_interface__membrane__V);
            const double var_x143 = -1.0 + var_x142;
            const double var_x144 = 1 / var_x143;
            const double var_x146 = 35.0 + var_chaste_interface__membrane__V;
            const double var_x147 = -5.0 + var_chaste_interface__membrane__V;
            
            partialF = 0.028390000000000002 * var_x140 * var_x146 + 0.084900000000000003 * var_x144 * var_chaste_interface__membrane__V - 0.011429999999999999 * var_x136 * var_x147;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        
        
        // Mathematics
        const double var_L_type_Ca_channel_f_gate__alpha_f_L = 3.75 * (28.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(7.0 + 0.25 * var_chaste_interface__membrane__V)); // per_second
        const double var_L_type_Ca_channel_f_gate__beta_f_L = 30.0 / (1.0 + exp(-7.0 - 0.25 * var_chaste_interface__membrane__V)); // per_second
        const double var_L_type_Ca_channel_f_gate__f_L_infinity = 1 / (1.0 + exp(6.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_gate__tau_f_L = 1 / (var_L_type_Ca_channel_f_gate__alpha_f_L + var_L_type_Ca_channel_f_gate__beta_f_L); // second
        const double var_L_type_Ca_channel_f_gate__f_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_gate__f_L + var_L_type_Ca_channel_f_gate__f_L_infinity) / var_L_type_Ca_channel_f_gate__tau_f_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L = 0.001 * var_L_type_Ca_channel_f_gate__f_L_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x150 = 0.25 * var_chaste_interface__membrane__V;
            const double var_x151 = exp(7.0 + var_x150);
            const double var_x152 = -1.0 + var_x151;
            const double var_x153 = 1 / var_x152;
            const double var_x155 = exp(-7.0 - var_x150);
            const double var_x156 = 1.0 + var_x155;
            const double var_x157 = 28.0 + var_chaste_interface__membrane__V;
            const double var_x158 = 1 / var_x156;
            
            partialF = -0.029999999999999999 * var_x158 - 0.0037499999999999999 * var_x153 * var_x157;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        
        
        // Mathematics
        const double var_T_type_Ca_channel_d_gate__alpha_d_T = 1068.0 * exp(0.87666666666666671 + 0.033333333333333333 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_d_gate__beta_d_T = 1068.0 * exp(-0.87666666666666671 - 0.033333333333333333 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_d_gate__d_T_infinity = 1 / (1.0 + exp(-4.3833333333333337 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_d_gate__tau_d_T = 1 / (var_T_type_Ca_channel_d_gate__alpha_d_T + var_T_type_Ca_channel_d_gate__beta_d_T); // second
        const double var_T_type_Ca_channel_d_gate__d_T_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_d_gate__d_T + var_T_type_Ca_channel_d_gate__d_T_infinity) / var_T_type_Ca_channel_d_gate__tau_d_T; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T = 0.001 * var_T_type_Ca_channel_d_gate__d_T_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x161 = 0.033333333333333333 * var_chaste_interface__membrane__V;
            const double var_x162 = exp(0.87666666666666671 + var_x161);
            const double var_x163 = exp(-0.87666666666666671 - var_x161);
            
            partialF = -1.0680000000000001 * var_x162 - 1.0680000000000001 * var_x163;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        
        
        // Mathematics
        const double var_T_type_Ca_channel_f_gate__alpha_f_T = 15.300000000000001 * exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_f_gate__beta_f_T = 15.0 * exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_f_gate__f_T_infinity = 1 / (1.0 + exp(11.017857142857144 + 0.17857142857142858 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_f_gate__tau_f_T = 1 / (var_T_type_Ca_channel_f_gate__alpha_f_T + var_T_type_Ca_channel_f_gate__beta_f_T); // second
        const double var_T_type_Ca_channel_f_gate__f_T_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_f_gate__f_T + var_T_type_Ca_channel_f_gate__f_T_infinity) / var_T_type_Ca_channel_f_gate__tau_f_T; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T = 0.001 * var_T_type_Ca_channel_f_gate__f_T_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x166 = exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V);
            const double var_x167 = exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V);
            
            partialF = -0.015300000000000001 * var_x167 - 0.014999999999999999 * var_x166;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        
        
        // Mathematics
        const double var_delayed_rectifying_potassium_current_P_a_gate__P_a_infinity = 1 / (1.0 + exp(-0.68918918918918914 - 0.13513513513513511 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifying_potassium_current_P_a_gate__tau_P_a = 1 / (17.0 * exp(0.039800000000000002 * var_chaste_interface__membrane__V) + 2.1099999999999999 * exp(-0.050999999999999997 * var_chaste_interface__membrane__V)); // second
        const double var_delayed_rectifying_potassium_current_P_a_gate__P_a_orig_deriv = (-var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a + var_delayed_rectifying_potassium_current_P_a_gate__P_a_infinity) / var_delayed_rectifying_potassium_current_P_a_gate__tau_P_a; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_a_gate__P_a = 0.001 * var_delayed_rectifying_potassium_current_P_a_gate__P_a_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_a_gate__P_a;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x168 = exp(0.039800000000000002 * var_chaste_interface__membrane__V);
            const double var_x169 = exp(-0.050999999999999997 * var_chaste_interface__membrane__V);
            
            partialF = -0.0021099999999999999 * var_x169 - 0.017000000000000001 * var_x168;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        
        
        // Mathematics
        const double var_delayed_rectifying_potassium_current_P_i_gate__alpha_P_i = 100.0 * exp(-0.0183 * var_chaste_interface__membrane__V); // per_second
        const double var_delayed_rectifying_potassium_current_P_i_gate__beta_P_i = 656.0 * exp(0.0094199999999999996 * var_chaste_interface__membrane__V); // per_second
        const double var_delayed_rectifying_potassium_current_P_i_gate__P_i_orig_deriv = (1.0 - var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i) * var_delayed_rectifying_potassium_current_P_i_gate__alpha_P_i - var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i * var_delayed_rectifying_potassium_current_P_i_gate__beta_P_i; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_i_gate__P_i = 0.001 * var_delayed_rectifying_potassium_current_P_i_gate__P_i_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_i_gate__P_i;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x172 = exp(-0.0183 * var_chaste_interface__membrane__V);
            const double var_x173 = exp(0.0094199999999999996 * var_chaste_interface__membrane__V);
            
            partialF = -0.65600000000000003 * var_x173 - 0.10000000000000001 * var_x172;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        
        
        // Mathematics
        const double var_hyperpolarisation_activated_current_y_gate__tau_y = 1 / (1.6483000000000001 * exp(-2.2219482120838472 - 0.041101520756267988 * var_chaste_interface__membrane__V) + 14.01055 / (0.69999999999999996 + exp(-10.909090909090908 - 0.18181818181818182 * var_chaste_interface__membrane__V))); // second
        const double var_hyperpolarisation_activated_current_y_gate__y_infinity = 1 / (1.0 + exp(8.0222222222222221 + 0.1111111111111111 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_hyperpolarisation_activated_current_y_gate__y_orig_deriv = (-var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + var_hyperpolarisation_activated_current_y_gate__y_infinity) / var_hyperpolarisation_activated_current_y_gate__tau_y; // 1 / second
        const double d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y = 0.001 * var_hyperpolarisation_activated_current_y_gate__y_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x176 = exp(-2.2219482120838472 - 0.041101520756267988 * var_chaste_interface__membrane__V);
            const double var_x177 = exp(-10.909090909090908 - 0.18181818181818182 * var_chaste_interface__membrane__V);
            const double var_x178 = 0.69999999999999996 + var_x177;
            const double var_x179 = 1 / var_x178;
            
            partialF = -0.0016483000000000001 * var_x176 - 0.01401055 * var_x179;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        
        // Mathematics
        const double var_cleft_space_equations__Vol = 3.4970000000000001e-6; // microLitre
        const double var_hyperpolarisation_activated_current__g_f_Na = 0.0067478; // microS
        const double var_intracellular_concentrations_and_buffer_equations__V_i = 0.46500000000000002 * var_cleft_space_equations__Vol; // microLitre
        const double var_linear_background_current__g_B_Na = 0.00016000000000000001; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_hyperpolarisation_activated_current__i_f_Na = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na; // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Na; // nanoA
        const double var_sodium_calcium_pump__K_NaCa = 1.2480000000000001e-5; // nanoA
        const double var_sodium_calcium_pump__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_pump__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_pump__i_NaCa = (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_pump__gamma) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_pump__gamma) * var_chaste_interface__membrane__V)) * var_sodium_calcium_pump__K_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c) * var_sodium_calcium_pump__d_NaCa); // nanoA
        const double var_sodium_current__P_Na = 0.0034399999999999999; // mul_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.46; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.21920000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.6000000000000001 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_chaste_interface__cleft_space_equations__K_c + var_sodium_potassium_pump__K_m_K), 2) * pow((var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_intracellular_concentrations_and_buffer_equations__Na_i_orig_deriv = (-var_hyperpolarisation_activated_current__i_f_Na - var_linear_background_current__i_B_Na - var_sodium_current__i_Na - 3.0 * var_sodium_calcium_pump__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_concentrations_and_buffer_equations__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Na_i = 0.001 * var_intracellular_concentrations_and_buffer_equations__Na_i_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Na_i;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            double var_chaste_interface__sodium_current_m_gate__m = rY[2];
            // Units: dimensionless; Initial value: 0.250113
            double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
            // Units: dimensionless; Initial value: 0.001386897
            double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
            // Units: dimensionless; Initial value: 0.002065463
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
            // Units: millimolar; Initial value: 9.701621
            double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
            // Units: millimolar; Initial value: 139.9988
            double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
            // Units: millimolar; Initial value: 2.00474
            double var_chaste_interface__cleft_space_equations__K_c = rY[20];
            // Units: millimolar; Initial value: 5.389014
            
            const double var_x7 = pow(var_chaste_interface__cleft_space_equations__Na_c, 3);
            const double var_x8 = var_x7 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x9 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
            const double var_x10 = var_x9 * var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x11 = 1.0 + 0.0001 * var_x10 + 0.0001 * var_x8;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = 0.018714999999999999 * var_chaste_interface__membrane__V;
            const double var_x14 = exp(-var_x13);
            const double var_x15 = var_x14 * var_x8;
            const double var_x16 = exp(var_x13);
            const double var_x17 = var_x10 * var_x16;
            const double var_x23 = 0.037433890822745473 * var_chaste_interface__membrane__V;
            const double var_x24 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
            const double var_x25 = var_x24 * var_chaste_interface__cleft_space_equations__Na_c;
            const double var_x26 = exp(var_x23 - 1.0 * log(var_x25));
            const double var_x29 = exp(var_x23);
            const double var_x30 = -1.0 + var_x29;
            const double var_x31 = 1 / var_x30;
            const double var_x32 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
            const double var_x33 = var_x31 * var_x32 * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2;
            const double var_x35 = exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V);
            const double var_x36 = 0.621 + var_chaste_interface__cleft_space_equations__K_c;
            const double var_x37 = pow(var_x36, (-2));
            const double var_x38 = pow(var_chaste_interface__cleft_space_equations__K_c, 2);
            const double var_x39 = 1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
            const double var_x40 = pow(var_x39, (-3));
            const double var_x42 = var_x33 * var_chaste_interface__membrane__V;
            const double var_x43 = var_x26 * var_x42;
            const double var_x56 = (var_x17 - var_x15) / pow(var_x11, 2);
            const double var_x74 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 2);
            const double var_x75 = var_x74 * var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x78 = var_x16 * var_x75;
            const double var_x79 = 1 / (1.5 + var_x35);
            const double var_x80 = var_x37 * var_x38 * var_x79;
            const double var_x81 = var_x80 * var_x9 / pow(var_x39, 4);
            const double var_x82 = var_x40 * var_x74 * var_x80;
            const double var_x185 = 7.158914428402498e-11 * var_x56;
            const double var_x186 = 7.1589144284024978e-7 * var_x12;
            const double var_x187 = 0.079190817585730572 * var_x43;
            
            partialF = 2.2637191644542304e-5 * var_x81 - 0.00012359906637920097 * var_x82 - 2.7242382709912566e-5 * var_x24 + var_x185 * var_x75 - var_x186 * var_x78 - var_x187 * var_x25;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        
        // Mathematics
        const double var_cleft_space_equations__K_b = 5.4000000000000004; // millimolar
        const double var_cleft_space_equations__Vol = 3.4970000000000001e-6; // microLitre
        const double var_delayed_rectifying_potassium_current__g_K = 0.0069300000000000004 * pow(var_cleft_space_equations__K_b, 0.58999999999999997); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = 0.0128821; // microS
        const double var_intracellular_concentrations_and_buffer_equations__V_i = 0.46500000000000002 * var_cleft_space_equations__Vol; // microLitre
        const double var_linear_background_current__g_B_K = 6.9400000000000006e-5; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_hyperpolarisation_activated_current__i_f_K = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i) / var_membrane__F; // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifying_potassium_current__g_K * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_K; // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.46; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.21920000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.6000000000000001 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_chaste_interface__cleft_space_equations__K_c + var_sodium_potassium_pump__K_m_K), 2) * pow((var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_intracellular_concentrations_and_buffer_equations__K_i_orig_deriv = (-var_delayed_rectifying_potassium_current__i_K - var_hyperpolarisation_activated_current__i_f_K - var_linear_background_current__i_B_K + 2.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_concentrations_and_buffer_equations__V_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__K_i = 0.001 * var_intracellular_concentrations_and_buffer_equations__K_i_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__K_i;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
            // Units: dimensionless; Initial value: 0.02302278
            double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
            // Units: dimensionless; Initial value: 0.3777728
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
            // Units: millimolar; Initial value: 140.7347
            
            const double var_x19 = var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i;
            const double var_x68 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i;
            const double var_x191 = 0.0031913222489694526 * var_x19;
            
            partialF = -1.1816383500424576e-5 * var_x68 - var_x191 * var_x68;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod = rY[14];
        // Units: dimensionless; Initial value: 0.1411678
        
        
        // Mathematics
        const double var_intracellular_concentrations_and_buffer_equations__phi_C = -307.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__Ca_Calmod_orig_deriv = var_intracellular_concentrations_and_buffer_equations__phi_C; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Calmod = 0.001 * var_intracellular_concentrations_and_buffer_equations__Ca_Calmod_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Calmod;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            
            const double var_x193 = -129.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            
            partialF = -0.307 + var_x193;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative15(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop = rY[15];
        // Units: dimensionless; Initial value: 0.07331396
        
        
        // Mathematics
        const double var_intracellular_concentrations_and_buffer_equations__phi_TC = -252.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop + 50500.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__Ca_Trop_orig_deriv = var_intracellular_concentrations_and_buffer_equations__phi_TC; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__Ca_Trop_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Trop;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative15(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            
            
            partialF = -0.252 - 50.5 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative16(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = rY[16];
        // Units: dimensionless; Initial value: 0.7618549
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = rY[17];
        // Units: dimensionless; Initial value: 0.2097049
        
        
        // Mathematics
        const double var_intracellular_concentrations_and_buffer_equations__phi_TMgC = -4.25 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop_orig_deriv = var_intracellular_concentrations_and_buffer_equations__phi_TMgC; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative16(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            
            const double var_x193 = -129.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            
            partialF = -0.0042500000000000003 + var_x193;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative17(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = rY[16];
        // Units: dimensionless; Initial value: 0.7618549
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = rY[17];
        // Units: dimensionless; Initial value: 0.2097049
        
        
        // Mathematics
        const double var_intracellular_concentrations_and_buffer_equations__Mg_i = 2.5; // millimolar
        const double var_intracellular_concentrations_and_buffer_equations__phi_TMgM = -429.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop + 1290.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop) * var_intracellular_concentrations_and_buffer_equations__Mg_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop_orig_deriv = var_intracellular_concentrations_and_buffer_equations__phi_TMgM; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative17(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -3.6539999999999999;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative18(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        
        // Mathematics
        const double var_cleft_space_equations__Na_b = 140.0; // millimolar
        const double var_cleft_space_equations__Vol = 3.4970000000000001e-6; // microLitre
        const double var_cleft_space_equations__V_c = 0.13600000000000001 * var_cleft_space_equations__Vol; // microLitre
        const double var_cleft_space_equations__tau_p = 0.01; // second
        const double var_hyperpolarisation_activated_current__g_f_Na = 0.0067478; // microS
        const double var_linear_background_current__g_B_Na = 0.00016000000000000001; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_hyperpolarisation_activated_current__i_f_Na = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na; // nanoA
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Na; // nanoA
        const double var_sodium_calcium_pump__K_NaCa = 1.2480000000000001e-5; // nanoA
        const double var_sodium_calcium_pump__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_pump__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_pump__i_NaCa = (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_pump__gamma) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_pump__gamma) * var_chaste_interface__membrane__V)) * var_sodium_calcium_pump__K_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c) * var_sodium_calcium_pump__d_NaCa); // nanoA
        const double var_sodium_current__P_Na = 0.0034399999999999999; // mul_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.46; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.21920000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.6000000000000001 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_chaste_interface__cleft_space_equations__K_c + var_sodium_potassium_pump__K_m_K), 2) * pow((var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_cleft_space_equations__Na_c_orig_deriv = (-var_chaste_interface__cleft_space_equations__Na_c + var_cleft_space_equations__Na_b) / var_cleft_space_equations__tau_p + (3.0 * var_sodium_calcium_pump__i_NaCa + 3.0 * var_sodium_potassium_pump__i_NaK + var_hyperpolarisation_activated_current__i_f_Na + var_linear_background_current__i_B_Na + var_sodium_current__i_Na) / (var_cleft_space_equations__V_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_equations__Na_c = 0.001 * var_cleft_space_equations__Na_c_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_cleft_space_equations__Na_c;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative18(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            double var_chaste_interface__sodium_current_m_gate__m = rY[2];
            // Units: dimensionless; Initial value: 0.250113
            double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
            // Units: dimensionless; Initial value: 0.001386897
            double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
            // Units: dimensionless; Initial value: 0.002065463
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
            // Units: millimolar; Initial value: 9.701621
            double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
            // Units: millimolar; Initial value: 139.9988
            double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
            // Units: millimolar; Initial value: 2.00474
            
            const double var_x7 = pow(var_chaste_interface__cleft_space_equations__Na_c, 3);
            const double var_x8 = var_x7 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x9 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
            const double var_x10 = var_x9 * var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x11 = 1.0 + 0.0001 * var_x10 + 0.0001 * var_x8;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = 0.018714999999999999 * var_chaste_interface__membrane__V;
            const double var_x14 = exp(-var_x13);
            const double var_x15 = var_x14 * var_x8;
            const double var_x16 = exp(var_x13);
            const double var_x17 = var_x10 * var_x16;
            const double var_x23 = 0.037433890822745473 * var_chaste_interface__membrane__V;
            const double var_x24 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
            const double var_x25 = var_x24 * var_chaste_interface__cleft_space_equations__Na_c;
            const double var_x26 = exp(var_x23 - 1.0 * log(var_x25));
            const double var_x27 = -1.0 + var_x26;
            const double var_x29 = exp(var_x23);
            const double var_x30 = -1.0 + var_x29;
            const double var_x31 = 1 / var_x30;
            const double var_x32 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
            const double var_x33 = var_x31 * var_x32 * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2;
            const double var_x42 = var_x33 * var_chaste_interface__membrane__V;
            const double var_x43 = var_x26 * var_x42;
            const double var_x56 = (var_x17 - var_x15) / pow(var_x11, 2);
            const double var_x85 = 1 / var_chaste_interface__cleft_space_equations__Na_c;
            const double var_x86 = pow(var_chaste_interface__cleft_space_equations__Na_c, 2) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x87 = var_x14 * var_x86;
            const double var_x188 = var_x27 * var_x42;
            const double var_x198 = 2.447717065593501e-6 * var_x12;
            const double var_x199 = 2.4477170655935014e-10 * var_x56;
            const double var_x200 = 0.27076272189238759 * var_x43;
            
            partialF = -0.099999999999999992 - var_x200 + 0.27076272189238759 * var_x188 - 9.3144911471392233e-5 * var_x85 - var_x198 * var_x87 - var_x199 * var_x86;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative19(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        
        
        // Mathematics
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 0.021149999999999999; // microS
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T = 0.02521; // microS
        const double var_calcium_pump_current__i_Ca_P_max = 0.02869; // nanoA
        const double var_cleft_space_equations__Ca_b = 2.0; // millimolar
        const double var_cleft_space_equations__Vol = 3.4970000000000001e-6; // microLitre
        const double var_cleft_space_equations__V_c = 0.13600000000000001 * var_cleft_space_equations__Vol; // microLitre
        const double var_cleft_space_equations__tau_p = 0.01; // second
        const double var_calcium_pump_current__i_Ca_P = var_calcium_pump_current__i_Ca_P_max * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_linear_background_current__g_B_Ca = 3.6399999999999997e-5; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i) / var_membrane__F; // millivolt
        const double var_linear_background_current__i_B_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_Ca; // nanoA
        const double var_sodium_calcium_pump__K_NaCa = 1.2480000000000001e-5; // nanoA
        const double var_sodium_calcium_pump__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_pump__gamma = 0.5; // dimensionless
        const double var_sodium_calcium_pump__i_NaCa = (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_pump__gamma) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_pump__gamma) * var_chaste_interface__membrane__V)) * var_sodium_calcium_pump__K_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c) * var_sodium_calcium_pump__d_NaCa); // nanoA
        const double var_cleft_space_equations__Ca_c_orig_deriv = (-var_chaste_interface__cleft_space_equations__Ca_c + var_cleft_space_equations__Ca_b) / var_cleft_space_equations__tau_p + 0.5 * (-2.0 * var_sodium_calcium_pump__i_NaCa + var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_calcium_pump_current__i_Ca_P + var_linear_background_current__i_B_Ca) / (var_cleft_space_equations__V_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_equations__Ca_c = 0.001 * var_cleft_space_equations__Ca_c_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_cleft_space_equations__Ca_c;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative19(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
            // Units: millimolar; Initial value: 9.701621
            double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
            // Units: millimolar; Initial value: 139.9988
            double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
            // Units: millimolar; Initial value: 2.00474
            
            const double var_x7 = pow(var_chaste_interface__cleft_space_equations__Na_c, 3);
            const double var_x8 = var_x7 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x9 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
            const double var_x10 = var_x9 * var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x11 = 1.0 + 0.0001 * var_x10 + 0.0001 * var_x8;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = 0.018714999999999999 * var_chaste_interface__membrane__V;
            const double var_x14 = exp(-var_x13);
            const double var_x15 = var_x14 * var_x8;
            const double var_x16 = exp(var_x13);
            const double var_x17 = var_x10 * var_x16;
            const double var_x56 = (var_x17 - var_x15) / pow(var_x11, 2);
            const double var_x88 = 1 / var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x89 = var_x16 * var_x9;
            const double var_x203 = 2.7196856284372237e-11 * var_x56;
            const double var_x204 = 2.7196856284372236e-7 * var_x12;
            
            partialF = -0.099999999999999992 - 5.2976168399354324e-6 * var_x88 + var_x203 * var_x9 - var_x204 * var_x89;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative20(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        
        // Mathematics
        const double var_cleft_space_equations__K_b = 5.4000000000000004; // millimolar
        const double var_cleft_space_equations__Vol = 3.4970000000000001e-6; // microLitre
        const double var_cleft_space_equations__V_c = 0.13600000000000001 * var_cleft_space_equations__Vol; // microLitre
        const double var_cleft_space_equations__tau_p = 0.01; // second
        const double var_delayed_rectifying_potassium_current__g_K = 0.0069300000000000004 * pow(var_cleft_space_equations__K_b, 0.58999999999999997); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = 0.0128821; // microS
        const double var_linear_background_current__g_B_K = 6.9400000000000006e-5; // microS
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_membrane__R = 8314.4719999999998; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_hyperpolarisation_activated_current__i_f_K = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K; // nanoA
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i) / var_membrane__F; // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifying_potassium_current__g_K * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_linear_background_current__g_B_K; // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.46; // millimolar
        const double var_sodium_potassium_pump__i_NaK_max = 0.21920000000000001; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 1.6000000000000001 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_sodium_potassium_pump__i_NaK_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_chaste_interface__cleft_space_equations__K_c + var_sodium_potassium_pump__K_m_K), 2) * pow((var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_cleft_space_equations__K_c_orig_deriv = (-var_chaste_interface__cleft_space_equations__K_c + var_cleft_space_equations__K_b) / var_cleft_space_equations__tau_p + (-2.0 * var_sodium_potassium_pump__i_NaK + var_delayed_rectifying_potassium_current__i_K + var_hyperpolarisation_activated_current__i_f_K + var_linear_background_current__i_B_K) / (var_cleft_space_equations__V_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_equations__K_c = 0.001 * var_cleft_space_equations__K_c_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_cleft_space_equations__K_c;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative20(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
            // Units: dimensionless; Initial value: 0.02302278
            double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
            // Units: dimensionless; Initial value: 0.3777728
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
            // Units: millimolar; Initial value: 9.701621
            double var_chaste_interface__cleft_space_equations__K_c = rY[20];
            // Units: millimolar; Initial value: 5.389014
            
            const double var_x9 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
            const double var_x19 = var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i;
            const double var_x35 = exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V);
            const double var_x36 = 0.621 + var_chaste_interface__cleft_space_equations__K_c;
            const double var_x37 = pow(var_x36, (-2));
            const double var_x38 = pow(var_chaste_interface__cleft_space_equations__K_c, 2);
            const double var_x39 = 1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
            const double var_x40 = pow(var_x39, (-3));
            const double var_x79 = 1 / (1.5 + var_x35);
            const double var_x90 = 1 / var_chaste_interface__cleft_space_equations__K_c;
            const double var_x91 = var_x40 * var_x79 * var_x9;
            const double var_x93 = var_x38 / pow(var_x36, 3);
            const double var_x94 = var_x37 * var_chaste_interface__cleft_space_equations__K_c;
            const double var_x207 = 0.010911506218902908 * var_x19;
            const double var_x208 = 0.00018782211067427598 * var_x91;
            
            partialF = -0.099999999999999992 - 4.040160535071638e-5 * var_x90 + var_x208 * var_x93 - var_x207 * var_x90 - var_x208 * var_x94;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative21(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rY[21];
        // Units: millimolar; Initial value: 16.95311
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rY[22];
        // Units: millimolar; Initial value: 16.85024
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__alpha_up = 0.080000000000000002; // nanoA
        const double var_SR_Ca_uptake_and_release__beta_up = 0.071999999999999995; // nanoA
        const double var_SR_Ca_uptake_and_release__k_SRCa = 22.0; // millimolar
        const double var_SR_Ca_uptake_and_release__k_cyca = 5.0000000000000002e-5; // millimolar
        const double var_SR_Ca_uptake_and_release__k_xcs = 0.90000000000000002; // dimensionless
        const double var_SR_Ca_uptake_and_release__K1 = var_SR_Ca_uptake_and_release__k_cyca * var_SR_Ca_uptake_and_release__k_xcs / var_SR_Ca_uptake_and_release__k_SRCa; // dimensionless
        const double var_cleft_space_equations__Vol = 3.4970000000000001e-6; // microLitre
        const double var_SR_Ca_uptake_and_release__K2 = var_chaste_interface__SR_Ca_uptake_and_release__Ca_up * var_SR_Ca_uptake_and_release__K1 + var_SR_Ca_uptake_and_release__k_cyca * var_SR_Ca_uptake_and_release__k_xcs + var_SR_Ca_uptake_and_release__k_cyca + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // millimolar
        const double var_SR_Ca_uptake_and_release__i_up = (var_SR_Ca_uptake_and_release__alpha_up * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i - var_chaste_interface__SR_Ca_uptake_and_release__Ca_up * var_SR_Ca_uptake_and_release__K1 * var_SR_Ca_uptake_and_release__beta_up) / var_SR_Ca_uptake_and_release__K2; // nanoA
        const double var_intracellular_concentrations_and_buffer_equations__V_i = 0.46500000000000002 * var_cleft_space_equations__Vol; // microLitre
        const double var_SR_Ca_uptake_and_release__V_up = 0.01166 * var_intracellular_concentrations_and_buffer_equations__V_i; // microLitre
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_SR_Ca_uptake_and_release__i_tr = 31.162355874104083 * (-var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel + var_chaste_interface__SR_Ca_uptake_and_release__Ca_up) * var_SR_Ca_uptake_and_release__V_up * var_membrane__F; // nanoA
        const double var_SR_Ca_uptake_and_release__Ca_up_orig_deriv = 0.5 * (-var_SR_Ca_uptake_and_release__i_tr + var_SR_Ca_uptake_and_release__i_up) / (var_SR_Ca_uptake_and_release__V_up * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_up = 0.001 * var_SR_Ca_uptake_and_release__Ca_up_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_up;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative21(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rY[21];
            // Units: millimolar; Initial value: 16.95311
            
            const double var_x96 = 9.5000000000000005e-5 + 2.0454545454545457e-6 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x97 = 1 / var_x96;
            const double var_x98 = (0.080000000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i - 1.4727272727272728e-7 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up) / pow(var_x96, 2);
            
            partialF = -0.015581177937052042 - 4.0251665946738841e-8 * var_x97 - 5.5905091592692838e-7 * var_x98;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative22(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rY[21];
        // Units: millimolar; Initial value: 16.95311
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rY[22];
        // Units: millimolar; Initial value: 16.85024
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse = rY[23];
        // Units: dimensionless; Initial value: 0.9528726
        double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rY[25];
        // Units: dimensionless; Initial value: 0.0007594214
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__alpha_rel = 0.5; // nanoA_per_millimolar
        const double var_SR_Ca_uptake_and_release__i_rel = pow(var_chaste_interface__SR_Ca_uptake_and_release__F2, 2) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel * var_SR_Ca_uptake_and_release__alpha_rel / pow((0.25 + var_chaste_interface__SR_Ca_uptake_and_release__F2), 2); // nanoA
        const double var_SR_Ca_uptake_and_release__phi_Calse = -641.0 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse + 770.0 * (1.0 - var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel; // per_second
        const double var_cleft_space_equations__Vol = 3.4970000000000001e-6; // microLitre
        const double var_intracellular_concentrations_and_buffer_equations__V_i = 0.46500000000000002 * var_cleft_space_equations__Vol; // microLitre
        const double var_SR_Ca_uptake_and_release__V_rel = 0.0012960000000000001 * var_intracellular_concentrations_and_buffer_equations__V_i; // microLitre
        const double var_SR_Ca_uptake_and_release__V_up = 0.01166 * var_intracellular_concentrations_and_buffer_equations__V_i; // microLitre
        const double var_membrane__F = 96485.341499999995; // coulomb_per_mole
        const double var_SR_Ca_uptake_and_release__i_tr = 31.162355874104083 * (-var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel + var_chaste_interface__SR_Ca_uptake_and_release__Ca_up) * var_SR_Ca_uptake_and_release__V_up * var_membrane__F; // nanoA
        const double var_SR_Ca_uptake_and_release__Ca_rel_orig_deriv = -11.48 * var_SR_Ca_uptake_and_release__phi_Calse + 0.5 * (-var_SR_Ca_uptake_and_release__i_rel + var_SR_Ca_uptake_and_release__i_tr) / (var_SR_Ca_uptake_and_release__V_rel * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_rel = 0.001 * var_SR_Ca_uptake_and_release__Ca_rel_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_rel;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative22(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse = rY[23];
            // Units: dimensionless; Initial value: 0.9528726
            double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rY[25];
            // Units: dimensionless; Initial value: 0.0007594214
            
            const double var_x105 = 0.25 + var_chaste_interface__SR_Ca_uptake_and_release__F2;
            const double var_x106 = pow(var_x105, (-2));
            const double var_x107 = pow(var_chaste_interface__SR_Ca_uptake_and_release__F2, 2);
            const double var_x108 = var_x106 * var_x107;
            
            partialF = -8.979782511378108 + 8.8396000000000008 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse - 1.2294902345128229 * var_x108;
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative23(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rY[22];
        // Units: millimolar; Initial value: 16.85024
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse = rY[23];
        // Units: dimensionless; Initial value: 0.9528726
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__phi_Calse = -641.0 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse + 770.0 * (1.0 - var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel; // per_second
        const double var_SR_Ca_uptake_and_release__Ca_Calse_orig_deriv = var_SR_Ca_uptake_and_release__phi_Calse; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_Calse = 0.001 * var_SR_Ca_uptake_and_release__Ca_Calse_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_Calse;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative23(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rY[22];
            // Units: millimolar; Initial value: 16.85024
            
            
            partialF = -0.64100000000000001 - 0.77000000000000002 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative24(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__SR_Ca_uptake_and_release__F1 = rY[24];
        // Units: dimensionless; Initial value: 0.1133251
        double var_chaste_interface__SR_Ca_uptake_and_release__F3 = rY[26];
        // Units: dimensionless; Initial value: 0.8859153
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__k_rel = 0.0040000000000000001; // millimolar
        const double var_SR_Ca_uptake_and_release__r_act = 240.0 * exp(-3.2000000000000002 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((var_SR_Ca_uptake_and_release__k_rel + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double var_SR_Ca_uptake_and_release__F1_orig_deriv = 0.95999999999999996 * var_chaste_interface__SR_Ca_uptake_and_release__F3 - var_chaste_interface__SR_Ca_uptake_and_release__F1 * var_SR_Ca_uptake_and_release__r_act; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F1 = 0.001 * var_SR_Ca_uptake_and_release__F1_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F1;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative24(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            
            const double var_x210 = exp(-3.2000000000000002 + 0.080000000000000002 * var_chaste_interface__membrane__V);
            const double var_x212 = 0.0040000000000000001 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x213 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4);
            const double var_x215 = pow(var_x212, (-4));
            const double var_x218 = 0.23999999999999999 * var_x210;
            const double var_x219 = 0.23999999999999999 * var_x213 * var_x215;
            const double var_x220 = -var_x219;
            
            partialF = var_x220 - var_x218;
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative25(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__SR_Ca_uptake_and_release__F1 = rY[24];
        // Units: dimensionless; Initial value: 0.1133251
        double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rY[25];
        // Units: dimensionless; Initial value: 0.0007594214
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__k_rel = 0.0040000000000000001; // millimolar
        const double var_SR_Ca_uptake_and_release__r_inact = 40.0 + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((var_SR_Ca_uptake_and_release__k_rel + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double var_SR_Ca_uptake_and_release__r_act = 240.0 * exp(-3.2000000000000002 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((var_SR_Ca_uptake_and_release__k_rel + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double var_SR_Ca_uptake_and_release__F2_orig_deriv = var_chaste_interface__SR_Ca_uptake_and_release__F1 * var_SR_Ca_uptake_and_release__r_act - var_chaste_interface__SR_Ca_uptake_and_release__F2 * var_SR_Ca_uptake_and_release__r_inact; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F2 = 0.001 * var_SR_Ca_uptake_and_release__F2_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F2;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative25(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            
            const double var_x212 = 0.0040000000000000001 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x213 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4);
            const double var_x215 = pow(var_x212, (-4));
            const double var_x219 = 0.23999999999999999 * var_x213 * var_x215;
            const double var_x220 = -var_x219;
            
            partialF = -0.040000000000000001 + var_x220;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL2::EvaluateYDerivative26(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rY[25];
        // Units: dimensionless; Initial value: 0.0007594214
        double var_chaste_interface__SR_Ca_uptake_and_release__F3 = rY[26];
        // Units: dimensionless; Initial value: 0.8859153
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__k_rel = 0.0040000000000000001; // millimolar
        const double var_SR_Ca_uptake_and_release__r_inact = 40.0 + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((var_SR_Ca_uptake_and_release__k_rel + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double var_SR_Ca_uptake_and_release__F3_orig_deriv = -0.95999999999999996 * var_chaste_interface__SR_Ca_uptake_and_release__F3 + var_chaste_interface__SR_Ca_uptake_and_release__F2 * var_SR_Ca_uptake_and_release__r_inact; // 1 / second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F3 = 0.001 * var_SR_Ca_uptake_and_release__F3_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F3;
    }

    double Celldemir_model_1994FromCellMLGRL2::EvaluatePartialDerivative26(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.00095999999999999992;
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }

    std::vector<double> Celldemir_model_1994FromCellMLGRL2::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics

        std::vector<double> dqs(1);
        dqs[0] = var_chaste_interface__environment__time_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celldemir_model_1994FromCellMLGRL2>::Initialise(void)
{
    this->mSystemName = "demir_model_1994";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-49.54105);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0003787018);

    // rY[2]:
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.250113);

    // rY[3]:
    this->mVariableNames.push_back("sodium_current_h_gate__h1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001386897);

    // rY[4]:
    this->mVariableNames.push_back("sodium_current_h_gate__h2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002065463);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002572773);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_gate__f_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.98651);

    // rY[7]:
    this->mVariableNames.push_back("T_type_Ca_channel_d_gate__d_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02012114);

    // rY[8]:
    this->mVariableNames.push_back("T_type_Ca_channel_f_gate__f_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1945111);

    // rY[9]:
    this->mVariableNames.push_back("delayed_rectifying_potassium_current_P_a_gate__P_a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02302278);

    // rY[10]:
    this->mVariableNames.push_back("delayed_rectifying_potassium_current_P_i_gate__P_i");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3777728);

    // rY[11]:
    this->mVariableNames.push_back("hyperpolarisation_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09227776);

    // rY[12]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.701621);

    // rY[13]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(140.7347);

    // rY[14]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Ca_Calmod");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1411678);

    // rY[15]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Ca_Trop");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.07331396);

    // rY[16]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.7618549);

    // rY[17]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.2097049);

    // rY[18]:
    this->mVariableNames.push_back("cleft_space_equations__Na_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(139.9988);

    // rY[19]:
    this->mVariableNames.push_back("cleft_space_equations__Ca_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.00474);

    // rY[20]:
    this->mVariableNames.push_back("cleft_space_equations__K_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.389014);

    // rY[21]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(16.95311);

    // rY[22]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(16.85024);

    // rY[23]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__Ca_Calse");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9528726);

    // rY[24]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__F1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1133251);

    // rY[25]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__F2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0007594214);

    // rY[26]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__F3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8859153);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celldemir_model_1994FromCellMLGRL2)
