//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: shannon_2004
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "Shannon2004.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> CellShannon2004FromCellMLGRL2::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__cell__stim_amplitude_converted = 9.5 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__cell__stim_duration = 5.0; // millisecond
        const double var_chaste_interface__cell__stim_period = 1000.0; // millisecond
        const double var_chaste_interface__cell__stim_start = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__cell__stim_amplitude_converted),
                var_chaste_interface__cell__stim_duration,
                var_chaste_interface__cell__stim_period,
                var_chaste_interface__cell__stim_start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double CellShannon2004FromCellMLGRL2::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    CellShannon2004FromCellMLGRL2::CellShannon2004FromCellMLGRL2(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                39,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<CellShannon2004FromCellMLGRL2>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 5.3480000000000003e-6; // (var_Jleak_SR__KSRleak) [per_millisecond]
        this->mParameters[1] = 25.0; // (var_Jrel_SR__ks) [per_millisecond]
        this->mParameters[2] = 0.0053114; // (var_Jpump_SR__V_max) [millimolar_per_millisecond]
        this->mParameters[3] = 135.0; // (var_model_parameters__Ki) [millimolar]
        this->mParameters[4] = 1.8; // (var_model_parameters__Cao) [millimolar]
        this->mParameters[5] = 5.4000000000000004; // (var_model_parameters__Ko) [millimolar]
        this->mParameters[6] = 140.0; // (var_model_parameters__Nao) [millimolar]
        this->mParameters[7] = 0.00054000000000000001; // (var_ICaL__PCa) [litre_per_farad_millisecond]
        this->mParameters[8] = 16.0; // (var_INa__G_INa) [milliS_per_microF]
        this->mParameters[9] = 0.029999999999999999; // (var_IKr__G_IKr_const) [milliS_per_microF]
        this->mParameters[10] = 0.070000000000000007; // (var_IKs__G_Ks_Max) [milliS_per_microF]
        this->mParameters[11] = 9.0; // (var_INaCa__V_max) [microA_per_microF]
        this->mParameters[12] = 0.059999999999999998; // (var_Itos__G_tos) [milliS_per_microF]
    }

    CellShannon2004FromCellMLGRL2::~CellShannon2004FromCellMLGRL2()
    {
    }
    
    double CellShannon2004FromCellMLGRL2::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__INa_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.9867005
        double var_chaste_interface__INa_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.991562
        double var_chaste_interface__INa_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.001405627
        double var_chaste_interface__IKr_Xr_gate__Xr = rY[5];
        // Units: dimensionless; Initial value: 0.008641386
        double var_chaste_interface__IKs_Xs_gate__Xs = rY[6];
        // Units: dimensionless; Initial value: 0.005412034
        double var_chaste_interface__Itos_X_gate__X_tos = rY[7];
        // Units: dimensionless; Initial value: 0.004051574
        double var_chaste_interface__Itos_Y_gate__Y_tos = rY[8];
        // Units: dimensionless; Initial value: 0.9945511
        double var_chaste_interface__Itos_R_gate__R_tos = rY[9];
        // Units: dimensionless; Initial value: 0.9946
        double var_chaste_interface__Itof_X_gate__X_tof = rY[10];
        // Units: dimensionless; Initial value: 0.004051574
        double var_chaste_interface__Itof_Y_gate__Y_tof = rY[11];
        // Units: dimensionless; Initial value: 0.9945511
        double var_chaste_interface__ICaL_d_gate__d = rY[12];
        // Units: dimensionless; Initial value: 7.175662e-06
        double var_chaste_interface__ICaL_f_gate__f = rY[13];
        // Units: dimensionless; Initial value: 1.000681
        double var_chaste_interface__ICaL_fCa_gate__fCaB_SL = rY[14];
        // Units: dimensionless; Initial value: 0.01452605
        double var_chaste_interface__ICaL_fCa_gate__fCaB_jct = rY[15];
        // Units: dimensionless; Initial value: 0.02421991
        double var_chaste_interface__Na_buffer__Na_SL = rY[19];
        // Units: millimolar; Initial value: 8.80733
        double var_chaste_interface__Na_buffer__Na_jct = rY[20];
        // Units: millimolar; Initial value: 8.80329
        double var_chaste_interface__Na_buffer__Nai = rY[23];
        // Units: millimolar; Initial value: 8.80853
        double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
        // Units: millimolar; Initial value: 0.0001031812
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        
        const double var_ICaL__Fx_ICaL_SL = 0.10000000000000001; // dimensionless
        const double var_ICaL__Fx_ICaL_jct = 0.90000000000000002; // dimensionless
        const double var_ICaL__PK = 2.7000000000000001e-7; // litre_per_farad_millisecond
        const double var_ICaL__PNa = 1.4999999999999999e-8; // litre_per_farad_millisecond
        const double var_ICaL__Q10_CaL = 1.8; // dimensionless
        const double var_ICaL__gamma_Cai = 0.34100000000000003; // dimensionless
        const double var_ICaL__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_ICaL__gamma_Ki = 0.75; // dimensionless
        const double var_ICaL__gamma_Ko = 0.75; // dimensionless
        const double var_ICaL__gamma_Nai = 0.75; // dimensionless
        const double var_ICaL__gamma_Nao = 0.75; // dimensionless
        const double var_ICaL_fCa_gate__fCa_SL = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_SL; // dimensionless
        const double var_ICaL_fCa_gate__fCa_jct = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_jct; // dimensionless
        const double var_ICab__Fx_CaBk_SL = 0.89000000000000001; // dimensionless
        const double var_ICab__Fx_CaBk_jct = 0.11; // dimensionless
        const double var_ICab__G_CaBk = 0.00025129999999999998; // milliS_per_microF
        const double var_ICap__Fx_SLCaP_SL = 0.89000000000000001; // dimensionless
        const double var_ICap__Fx_SLCaP_jct = 0.11; // dimensionless
        const double var_ICap__H = 1.6000000000000001; // dimensionless
        const double var_ICap__Km = 0.00050000000000000001; // millimolar
        const double var_ICap__Q10_SLCaP = 2.3500000000000001; // dimensionless
        const double var_ICap__V_maxAF = 0.067299999999999999; // microA_per_microF
        const double var_ICl_Ca__Fx_Cl_SL = 0.89000000000000001; // dimensionless
        const double var_ICl_Ca__Fx_Cl_jct = 0.11; // dimensionless
        const double var_ICl_Ca__G_Cl = 0.109625; // milliS_per_microF
        const double var_ICl_Ca__Kd_ClCa = 0.10000000000000001; // millimolar
        const double var_IClb__G_ClBk = 0.0089999999999999993; // milliS_per_microF
        const double var_IKp__g_Kp = 0.001; // milliS_per_microF
        const double var_IKs__Fx_Ks_SL = 0.89000000000000001; // dimensionless
        const double var_IKs__Fx_Ks_jct = 0.11; // dimensionless
        const double var_IKs__pCa_SL = 3.0 - log10(var_chaste_interface__Ca_buffer__Ca_SL); // dimensionless
        const double var_IKs__G_Ks_SL = (0.057000000000000002 + 0.19 / (1.0 + exp(-12.0 + 1.6666666666666667 * var_IKs__pCa_SL))) * mParameters[10]; // milliS_per_microF
        const double var_IKs__pCa_jct = 3.0 - log10(var_chaste_interface__Ca_buffer__Ca_jct); // dimensionless
        const double var_IKs__G_Ks_jct = (0.057000000000000002 + 0.19 / (1.0 + exp(-12.0 + 1.6666666666666667 * var_IKs__pCa_jct))) * mParameters[10]; // milliS_per_microF
        const double var_IKs__pKNa = 0.018329999999999999; // dimensionless
        const double var_INa__Fx_Na_SL = 0.89000000000000001; // dimensionless
        const double var_INa__Fx_Na_jct = 0.11; // dimensionless
        const double var_INaCa__Fx_NCX_SL = 0.89000000000000001; // dimensionless
        const double var_INaCa__Fx_NCX_jct = 0.11; // dimensionless
        const double var_INaCa__HNa = 3.0; // dimensionless
        const double var_INaCa__K_mCai = 0.0035899999999999999; // millimolar
        const double var_INaCa__K_mCao = 1.3; // millimolar
        const double var_INaCa__K_mNai = 12.289999999999999; // millimolar
        const double var_INaCa__K_mNao = 87.5; // millimolar
        const double var_INaCa__Kd_act = 0.00025599999999999999; // millimolar
        const double var_INaCa__Ka_SL = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_SL, 3)); // dimensionless
        const double var_INaCa__Ka_jct = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_jct, 3)); // dimensionless
        const double var_INaCa__Q10_NCX = 1.5700000000000001; // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_INaK__Fx_NaK_SL = 0.89000000000000001; // dimensionless
        const double var_INaK__Fx_NaK_jct = 0.11; // dimensionless
        const double var_INaK__H_NaK = 4.0; // dimensionless
        const double var_INaK__I_NaK_max = 1.9071899999999999; // microA_per_microF
        const double var_INaK__Km_Ko = 1.5; // millimolar
        const double var_INaK__Km_Nai = 11.0; // millimolar
        const double var_INa__openProb = pow(var_chaste_interface__INa_m_gate__m, 3) * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // dimensionless
        const double var_INab__Fx_NaBk_SL = 0.89000000000000001; // dimensionless
        const double var_INab__Fx_NaBk_jct = 0.11; // dimensionless
        const double var_INab__G_NaBk = 0.00029700000000000001; // milliS_per_microF
        const double var_Itof__G_tof = 0.02; // milliS_per_microF
        const double var_IKr_Rr_gate__Rr = 1 / (1.0 + exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V)); // dimensionless
        const double var_model_parameters__Cli = 15.0; // millimolar
        const double var_model_parameters__Clo = 150.0; // millimolar
        const double var_model_parameters__F = 96485.0; // coulomb_per_mole
        const double var_IK1__G_K1 = 0.3872983346207417 * sqrt(mParameters[5]); // milliS_per_microF
        const double var_IKr__G_IKr = 0.43033148291193518 * sqrt(mParameters[5]) * mParameters[9]; // milliS_per_microF
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * mParameters[6]); // dimensionless
        const double var_model_parameters__R = 8314.2999999999993; // joule_per_kilomole_kelvin
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__Q_CaL = pow(var_ICaL__Q10_CaL, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICaL__temp = 0.45000000000000001 * pow(var_model_parameters__F, 2) * var_ICaL__Q_CaL * var_chaste_interface__ICaL_d_gate__d * var_chaste_interface__ICaL_f_gate__f * var_chaste_interface__cell__V / (var_model_parameters__R * var_model_parameters__T); // coulomb_per_mole
        const double var_ICaL__i_CaL_Ca_SL = 4.0 * (-var_ICaL__gamma_Cao * mParameters[4] + var_chaste_interface__Ca_buffer__Ca_SL * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_SL * mParameters[7] * var_ICaL__temp * var_ICaL_fCa_gate__fCa_SL / (-1.0 + exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Ca_jct = 4.0 * (-var_ICaL__gamma_Cao * mParameters[4] + var_chaste_interface__Ca_buffer__Ca_jct * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_jct * mParameters[7] * var_ICaL__temp * var_ICaL_fCa_gate__fCa_jct / (-1.0 + exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_K = (var_ICaL__Fx_ICaL_SL * var_ICaL_fCa_gate__fCa_SL + var_ICaL__Fx_ICaL_jct * var_ICaL_fCa_gate__fCa_jct) * (-var_ICaL__gamma_Ko * mParameters[5] + var_ICaL__gamma_Ki * mParameters[3] * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__PK * var_ICaL__temp / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Na_SL = (-var_ICaL__gamma_Nao * mParameters[6] + var_ICaL__gamma_Nai * var_chaste_interface__Na_buffer__Na_SL * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_SL * var_ICaL__PNa * var_ICaL__temp * var_ICaL_fCa_gate__fCa_SL / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Na_jct = (-var_ICaL__gamma_Nao * mParameters[6] + var_ICaL__gamma_Nai * var_chaste_interface__Na_buffer__Na_jct * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_jct * var_ICaL__PNa * var_ICaL__temp * var_ICaL_fCa_gate__fCa_jct / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL = var_ICaL__i_CaL_Ca_SL + var_ICaL__i_CaL_Ca_jct + var_ICaL__i_CaL_K + var_ICaL__i_CaL_Na_SL + var_ICaL__i_CaL_Na_jct; // microA_per_microF
        const double var_ICaL__i_CaL_converted = HeartConfig::Instance()->GetCapacitance() * var_ICaL__i_CaL; // uA_per_cm2
        const double var_ICap__Q_SLCaP = pow(var_ICap__Q10_SLCaP, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICap__i_Cap_SL = var_ICap__Fx_SLCaP_SL * var_ICap__Q_SLCaP * var_ICap__V_maxAF / (1.0 + pow((var_ICap__Km / var_chaste_interface__Ca_buffer__Ca_SL), var_ICap__H)); // microA_per_microF
        const double var_ICap__i_Cap_jct = var_ICap__Fx_SLCaP_jct * var_ICap__Q_SLCaP * var_ICap__V_maxAF / (1.0 + pow((var_ICap__Km / var_chaste_interface__Ca_buffer__Ca_jct), var_ICap__H)); // microA_per_microF
        const double var_ICap__i_Cap = var_ICap__i_Cap_SL + var_ICap__i_Cap_jct; // microA_per_microF
        const double var_IKs__E_Ks = var_model_parameters__R * var_model_parameters__T * log((var_IKs__pKNa * mParameters[6] + mParameters[5]) / (var_IKs__pKNa * var_chaste_interface__Na_buffer__Nai + mParameters[3])) / var_model_parameters__F; // millivolt
        const double var_IKs__i_Ks_SL = pow(var_chaste_interface__IKs_Xs_gate__Xs, 2) * (-var_IKs__E_Ks + var_chaste_interface__cell__V) * var_IKs__Fx_Ks_SL * var_IKs__G_Ks_SL; // microA_per_microF
        const double var_IKs__i_Ks_jct = pow(var_chaste_interface__IKs_Xs_gate__Xs, 2) * (-var_IKs__E_Ks + var_chaste_interface__cell__V) * var_IKs__Fx_Ks_jct * var_IKs__G_Ks_jct; // microA_per_microF
        const double var_IKs__i_Ks = var_IKs__i_Ks_SL + var_IKs__i_Ks_jct; // microA_per_microF
        const double var_IKs__i_Ks_converted = HeartConfig::Instance()->GetCapacitance() * var_IKs__i_Ks; // uA_per_cm2
        const double var_INaCa__Q_NCX = pow(var_INaCa__Q10_NCX, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_INaCa__temp_SL = (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_SL = var_INaCa__Fx_NCX_SL * var_INaCa__Ka_SL * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_SL / (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_SL / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_SL + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_SL / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_INaCa__temp_jct = (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_jct = var_INaCa__Fx_NCX_jct * var_INaCa__Ka_jct * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_jct / (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_jct / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_jct + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_jct / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_INaCa__i_NaCa = var_INaCa__i_NaCa_SL + var_INaCa__i_NaCa_jct; // microA_per_microF
        const double var_INaCa__i_NaCa_converted = HeartConfig::Instance()->GetCapacitance() * var_INaCa__i_NaCa; // uA_per_cm2
        const double var_INaK__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) + 0.036499999999999998 * var_INaK__sigma * exp(-var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // dimensionless
        const double var_INaK__i_NaK_SL = var_INaK__Fx_NaK_SL * var_INaK__I_NaK_max * var_INaK__f_NaK * mParameters[5] / ((1.0 + pow((var_INaK__Km_Nai / var_chaste_interface__Na_buffer__Na_SL), var_INaK__H_NaK)) * (var_INaK__Km_Ko + mParameters[5])); // microA_per_microF
        const double var_INaK__i_NaK_jct = var_INaK__Fx_NaK_jct * var_INaK__I_NaK_max * var_INaK__f_NaK * mParameters[5] / ((1.0 + pow((var_INaK__Km_Nai / var_chaste_interface__Na_buffer__Na_jct), var_INaK__H_NaK)) * (var_INaK__Km_Ko + mParameters[5])); // microA_per_microF
        const double var_INaK__i_NaK = var_INaK__i_NaK_SL + var_INaK__i_NaK_jct; // microA_per_microF
        const double var_reversal_potentials__E_Ca_SL = 0.5 * var_model_parameters__R * var_model_parameters__T * log(mParameters[4] / var_chaste_interface__Ca_buffer__Ca_SL) / var_model_parameters__F; // millivolt
        const double var_ICab__i_Cab_SL = (-var_reversal_potentials__E_Ca_SL + var_chaste_interface__cell__V) * var_ICab__Fx_CaBk_SL * var_ICab__G_CaBk; // microA_per_microF
        const double var_reversal_potentials__E_Ca_jct = 0.5 * var_model_parameters__R * var_model_parameters__T * log(mParameters[4] / var_chaste_interface__Ca_buffer__Ca_jct) / var_model_parameters__F; // millivolt
        const double var_ICab__i_Cab_jct = (-var_reversal_potentials__E_Ca_jct + var_chaste_interface__cell__V) * var_ICab__Fx_CaBk_jct * var_ICab__G_CaBk; // microA_per_microF
        const double var_ICab__i_Cab = var_ICab__i_Cab_SL + var_ICab__i_Cab_jct; // microA_per_microF
        const double var_reversal_potentials__E_Cl = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Cli / var_model_parameters__Clo) / var_model_parameters__F; // millivolt
        const double var_ICl_Ca__i_Cl_Ca = (-var_reversal_potentials__E_Cl + var_chaste_interface__cell__V) * (var_ICl_Ca__Fx_Cl_SL / (1.0 + var_ICl_Ca__Kd_ClCa / var_chaste_interface__Ca_buffer__Ca_SL) + var_ICl_Ca__Fx_Cl_jct / (1.0 + var_ICl_Ca__Kd_ClCa / var_chaste_interface__Ca_buffer__Ca_jct)) * var_ICl_Ca__G_Cl; // microA_per_microF
        const double var_IClb__i_Clb = (-var_reversal_potentials__E_Cl + var_chaste_interface__cell__V) * var_IClb__G_ClBk; // microA_per_microF
        const double var_reversal_potentials__E_K = var_model_parameters__R * var_model_parameters__T * log(mParameters[5] / mParameters[3]) / var_model_parameters__F; // millivolt
        const double var_IK1_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__E_K)); // per_millisecond
        const double var_IK1_K1_gate__beta_K1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__E_K) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__E_K)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__E_K - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_millisecond
        const double var_IK1_K1_gate__K1_infinity = var_IK1_K1_gate__alpha_K1 / (var_IK1_K1_gate__alpha_K1 + var_IK1_K1_gate__beta_K1); // dimensionless
        const double var_IK1__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IK1__G_K1 * var_IK1_K1_gate__K1_infinity; // microA_per_microF
        const double var_IK1__i_K1_converted = HeartConfig::Instance()->GetCapacitance() * var_IK1__i_K1; // uA_per_cm2
        const double var_IKp__i_Kp = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IKp__g_Kp / (1.0 + exp(7.4880000000000004 - 0.16722408026755853 * var_chaste_interface__cell__V)); // microA_per_microF
        const double var_IKr__i_Kr = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IKr__G_IKr * var_IKr_Rr_gate__Rr * var_chaste_interface__IKr_Xr_gate__Xr; // microA_per_microF
        const double var_IKr__i_Kr_converted = HeartConfig::Instance()->GetCapacitance() * var_IKr__i_Kr; // uA_per_cm2
        const double var_Itof__i_tof = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_Itof__G_tof * var_chaste_interface__Itof_X_gate__X_tof * var_chaste_interface__Itof_Y_gate__Y_tof; // microA_per_microF
        const double var_Itos__i_tos = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * (0.5 * var_chaste_interface__Itos_R_gate__R_tos + var_chaste_interface__Itos_Y_gate__Y_tos) * mParameters[12] * var_chaste_interface__Itos_X_gate__X_tos; // microA_per_microF
        const double var_Itos__i_tos_converted = HeartConfig::Instance()->GetCapacitance() * var_Itos__i_tos; // uA_per_cm2
        const double var_reversal_potentials__E_Na_SL = var_model_parameters__R * var_model_parameters__T * log(mParameters[6] / var_chaste_interface__Na_buffer__Na_SL) / var_model_parameters__F; // millivolt
        const double var_INa__i_Na_SL = (-var_reversal_potentials__E_Na_SL + var_chaste_interface__cell__V) * var_INa__Fx_Na_SL * mParameters[8] * var_INa__openProb; // microA_per_microF
        const double var_INab__i_Nab_SL = (-var_reversal_potentials__E_Na_SL + var_chaste_interface__cell__V) * var_INab__Fx_NaBk_SL * var_INab__G_NaBk; // microA_per_microF
        const double var_reversal_potentials__E_Na_jct = var_model_parameters__R * var_model_parameters__T * log(mParameters[6] / var_chaste_interface__Na_buffer__Na_jct) / var_model_parameters__F; // millivolt
        const double var_INa__i_Na_jct = (-var_reversal_potentials__E_Na_jct + var_chaste_interface__cell__V) * var_INa__Fx_Na_jct * mParameters[8] * var_INa__openProb; // microA_per_microF
        const double var_INa__i_Na = var_INa__i_Na_SL + var_INa__i_Na_jct; // microA_per_microF
        const double var_INa__i_Na_converted = HeartConfig::Instance()->GetCapacitance() * var_INa__i_Na; // uA_per_cm2
        const double var_INab__i_Nab_jct = (-var_reversal_potentials__E_Na_jct + var_chaste_interface__cell__V) * var_INab__Fx_NaBk_jct * var_INab__G_NaBk; // microA_per_microF
        const double var_INab__i_Nab = var_INab__i_Nab_SL + var_INab__i_Nab_jct; // microA_per_microF
        const double var_chaste_interface__i_ionic = HeartConfig::Instance()->GetCapacitance() * var_ICab__i_Cab + HeartConfig::Instance()->GetCapacitance() * var_ICap__i_Cap + HeartConfig::Instance()->GetCapacitance() * var_ICl_Ca__i_Cl_Ca + HeartConfig::Instance()->GetCapacitance() * var_IClb__i_Clb + HeartConfig::Instance()->GetCapacitance() * var_IKp__i_Kp + HeartConfig::Instance()->GetCapacitance() * var_INaK__i_NaK + HeartConfig::Instance()->GetCapacitance() * var_INab__i_Nab + HeartConfig::Instance()->GetCapacitance() * var_Itof__i_tof + var_ICaL__i_CaL_converted + var_IK1__i_K1_converted + var_IKr__i_Kr_converted + var_IKs__i_Ks_converted + var_INa__i_Na_converted + var_INaCa__i_NaCa_converted + var_Itos__i_tos_converted; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void CellShannon2004FromCellMLGRL2::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;
        const double yinit = rY[v_index];

        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__INa_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.9867005
        double var_chaste_interface__INa_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.991562
        double var_chaste_interface__INa_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.001405627
        double var_chaste_interface__IKr_Xr_gate__Xr = rY[5];
        // Units: dimensionless; Initial value: 0.008641386
        double var_chaste_interface__IKs_Xs_gate__Xs = rY[6];
        // Units: dimensionless; Initial value: 0.005412034
        double var_chaste_interface__Itos_X_gate__X_tos = rY[7];
        // Units: dimensionless; Initial value: 0.004051574
        double var_chaste_interface__Itos_Y_gate__Y_tos = rY[8];
        // Units: dimensionless; Initial value: 0.9945511
        double var_chaste_interface__Itos_R_gate__R_tos = rY[9];
        // Units: dimensionless; Initial value: 0.9946
        double var_chaste_interface__Itof_X_gate__X_tof = rY[10];
        // Units: dimensionless; Initial value: 0.004051574
        double var_chaste_interface__Itof_Y_gate__Y_tof = rY[11];
        // Units: dimensionless; Initial value: 0.9945511
        double var_chaste_interface__ICaL_d_gate__d = rY[12];
        // Units: dimensionless; Initial value: 7.175662e-06
        double var_chaste_interface__ICaL_f_gate__f = rY[13];
        // Units: dimensionless; Initial value: 1.000681
        double var_chaste_interface__ICaL_fCa_gate__fCaB_SL = rY[14];
        // Units: dimensionless; Initial value: 0.01452605
        double var_chaste_interface__ICaL_fCa_gate__fCaB_jct = rY[15];
        // Units: dimensionless; Initial value: 0.02421991
        double var_chaste_interface__Na_buffer__Na_SL = rY[19];
        // Units: millimolar; Initial value: 8.80733
        double var_chaste_interface__Na_buffer__Na_jct = rY[20];
        // Units: millimolar; Initial value: 8.80329
        double var_chaste_interface__Na_buffer__Nai = rY[23];
        // Units: millimolar; Initial value: 8.80853
        double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
        // Units: millimolar; Initial value: 0.0001031812
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        

        // Mathematics
        double d_dt_chaste_interface_var_cell__V;
        const double var_ICaL__Fx_ICaL_SL = 0.10000000000000001; // dimensionless
        const double var_ICaL__Fx_ICaL_jct = 0.90000000000000002; // dimensionless
        const double var_ICaL__PK = 2.7000000000000001e-7; // litre_per_farad_millisecond
        const double var_ICaL__PNa = 1.4999999999999999e-8; // litre_per_farad_millisecond
        const double var_ICaL__Q10_CaL = 1.8; // dimensionless
        const double var_ICaL__gamma_Cai = 0.34100000000000003; // dimensionless
        const double var_ICaL__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_ICaL__gamma_Ki = 0.75; // dimensionless
        const double var_ICaL__gamma_Ko = 0.75; // dimensionless
        const double var_ICaL__gamma_Nai = 0.75; // dimensionless
        const double var_ICaL__gamma_Nao = 0.75; // dimensionless
        const double var_ICaL_fCa_gate__fCa_SL = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_SL; // dimensionless
        const double var_ICaL_fCa_gate__fCa_jct = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_jct; // dimensionless
        const double var_ICab__Fx_CaBk_SL = 0.89000000000000001; // dimensionless
        const double var_ICab__Fx_CaBk_jct = 0.11; // dimensionless
        const double var_ICab__G_CaBk = 0.00025129999999999998; // milliS_per_microF
        const double var_ICap__Fx_SLCaP_SL = 0.89000000000000001; // dimensionless
        const double var_ICap__Fx_SLCaP_jct = 0.11; // dimensionless
        const double var_ICap__H = 1.6000000000000001; // dimensionless
        const double var_ICap__Km = 0.00050000000000000001; // millimolar
        const double var_ICap__Q10_SLCaP = 2.3500000000000001; // dimensionless
        const double var_ICap__V_maxAF = 0.067299999999999999; // microA_per_microF
        const double var_ICl_Ca__Fx_Cl_SL = 0.89000000000000001; // dimensionless
        const double var_ICl_Ca__Fx_Cl_jct = 0.11; // dimensionless
        const double var_ICl_Ca__G_Cl = 0.109625; // milliS_per_microF
        const double var_ICl_Ca__Kd_ClCa = 0.10000000000000001; // millimolar
        const double var_IClb__G_ClBk = 0.0089999999999999993; // milliS_per_microF
        const double var_IKp__g_Kp = 0.001; // milliS_per_microF
        const double var_IKs__Fx_Ks_SL = 0.89000000000000001; // dimensionless
        const double var_IKs__Fx_Ks_jct = 0.11; // dimensionless
        const double var_IKs__pCa_SL = 3.0 - log10(var_chaste_interface__Ca_buffer__Ca_SL); // dimensionless
        const double var_IKs__G_Ks_SL = (0.057000000000000002 + 0.19 / (1.0 + exp(-12.0 + 1.6666666666666667 * var_IKs__pCa_SL))) * mParameters[10]; // milliS_per_microF
        const double var_IKs__pCa_jct = 3.0 - log10(var_chaste_interface__Ca_buffer__Ca_jct); // dimensionless
        const double var_IKs__G_Ks_jct = (0.057000000000000002 + 0.19 / (1.0 + exp(-12.0 + 1.6666666666666667 * var_IKs__pCa_jct))) * mParameters[10]; // milliS_per_microF
        const double var_IKs__pKNa = 0.018329999999999999; // dimensionless
        const double var_INa__Fx_Na_SL = 0.89000000000000001; // dimensionless
        const double var_INa__Fx_Na_jct = 0.11; // dimensionless
        const double var_INaCa__Fx_NCX_SL = 0.89000000000000001; // dimensionless
        const double var_INaCa__Fx_NCX_jct = 0.11; // dimensionless
        const double var_INaCa__HNa = 3.0; // dimensionless
        const double var_INaCa__K_mCai = 0.0035899999999999999; // millimolar
        const double var_INaCa__K_mCao = 1.3; // millimolar
        const double var_INaCa__K_mNai = 12.289999999999999; // millimolar
        const double var_INaCa__K_mNao = 87.5; // millimolar
        const double var_INaCa__Kd_act = 0.00025599999999999999; // millimolar
        const double var_INaCa__Ka_SL = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_SL, 3)); // dimensionless
        const double var_INaCa__Ka_jct = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_jct, 3)); // dimensionless
        const double var_INaCa__Q10_NCX = 1.5700000000000001; // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_INaK__Fx_NaK_SL = 0.89000000000000001; // dimensionless
        const double var_INaK__Fx_NaK_jct = 0.11; // dimensionless
        const double var_INaK__H_NaK = 4.0; // dimensionless
        const double var_INaK__I_NaK_max = 1.9071899999999999; // microA_per_microF
        const double var_INaK__Km_Ko = 1.5; // millimolar
        const double var_INaK__Km_Nai = 11.0; // millimolar
        const double var_INa__openProb = pow(var_chaste_interface__INa_m_gate__m, 3) * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // dimensionless
        const double var_INab__Fx_NaBk_SL = 0.89000000000000001; // dimensionless
        const double var_INab__Fx_NaBk_jct = 0.11; // dimensionless
        const double var_INab__G_NaBk = 0.00029700000000000001; // milliS_per_microF
        const double var_Itof__G_tof = 0.02; // milliS_per_microF
        const double var_IKr_Rr_gate__Rr = 1 / (1.0 + exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V)); // dimensionless
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_cell__i_Stim = var_cell__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // microA_per_microF
        const double var_model_parameters__Cli = 15.0; // millimolar
        const double var_model_parameters__Clo = 150.0; // millimolar
        const double var_model_parameters__F = 96485.0; // coulomb_per_mole
        const double var_IK1__G_K1 = 0.3872983346207417 * sqrt(mParameters[5]); // milliS_per_microF
        const double var_IKr__G_IKr = 0.43033148291193518 * sqrt(mParameters[5]) * mParameters[9]; // milliS_per_microF
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * mParameters[6]); // dimensionless
        const double var_model_parameters__R = 8314.2999999999993; // joule_per_kilomole_kelvin
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__Q_CaL = pow(var_ICaL__Q10_CaL, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICaL__temp = 0.45000000000000001 * pow(var_model_parameters__F, 2) * var_ICaL__Q_CaL * var_chaste_interface__ICaL_d_gate__d * var_chaste_interface__ICaL_f_gate__f * var_chaste_interface__cell__V / (var_model_parameters__R * var_model_parameters__T); // coulomb_per_mole
        const double var_ICaL__i_CaL_Ca_SL = 4.0 * (-var_ICaL__gamma_Cao * mParameters[4] + var_chaste_interface__Ca_buffer__Ca_SL * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_SL * mParameters[7] * var_ICaL__temp * var_ICaL_fCa_gate__fCa_SL / (-1.0 + exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Ca_jct = 4.0 * (-var_ICaL__gamma_Cao * mParameters[4] + var_chaste_interface__Ca_buffer__Ca_jct * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_jct * mParameters[7] * var_ICaL__temp * var_ICaL_fCa_gate__fCa_jct / (-1.0 + exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_K = (var_ICaL__Fx_ICaL_SL * var_ICaL_fCa_gate__fCa_SL + var_ICaL__Fx_ICaL_jct * var_ICaL_fCa_gate__fCa_jct) * (-var_ICaL__gamma_Ko * mParameters[5] + var_ICaL__gamma_Ki * mParameters[3] * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__PK * var_ICaL__temp / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Na_SL = (-var_ICaL__gamma_Nao * mParameters[6] + var_ICaL__gamma_Nai * var_chaste_interface__Na_buffer__Na_SL * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_SL * var_ICaL__PNa * var_ICaL__temp * var_ICaL_fCa_gate__fCa_SL / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Na_jct = (-var_ICaL__gamma_Nao * mParameters[6] + var_ICaL__gamma_Nai * var_chaste_interface__Na_buffer__Na_jct * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_jct * var_ICaL__PNa * var_ICaL__temp * var_ICaL_fCa_gate__fCa_jct / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL = var_ICaL__i_CaL_Ca_SL + var_ICaL__i_CaL_Ca_jct + var_ICaL__i_CaL_K + var_ICaL__i_CaL_Na_SL + var_ICaL__i_CaL_Na_jct; // microA_per_microF
        const double var_ICap__Q_SLCaP = pow(var_ICap__Q10_SLCaP, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICap__i_Cap_SL = var_ICap__Fx_SLCaP_SL * var_ICap__Q_SLCaP * var_ICap__V_maxAF / (1.0 + pow((var_ICap__Km / var_chaste_interface__Ca_buffer__Ca_SL), var_ICap__H)); // microA_per_microF
        const double var_ICap__i_Cap_jct = var_ICap__Fx_SLCaP_jct * var_ICap__Q_SLCaP * var_ICap__V_maxAF / (1.0 + pow((var_ICap__Km / var_chaste_interface__Ca_buffer__Ca_jct), var_ICap__H)); // microA_per_microF
        const double var_ICap__i_Cap = var_ICap__i_Cap_SL + var_ICap__i_Cap_jct; // microA_per_microF
        const double var_IKs__E_Ks = var_model_parameters__R * var_model_parameters__T * log((var_IKs__pKNa * mParameters[6] + mParameters[5]) / (var_IKs__pKNa * var_chaste_interface__Na_buffer__Nai + mParameters[3])) / var_model_parameters__F; // millivolt
        const double var_IKs__i_Ks_SL = pow(var_chaste_interface__IKs_Xs_gate__Xs, 2) * (-var_IKs__E_Ks + var_chaste_interface__cell__V) * var_IKs__Fx_Ks_SL * var_IKs__G_Ks_SL; // microA_per_microF
        const double var_IKs__i_Ks_jct = pow(var_chaste_interface__IKs_Xs_gate__Xs, 2) * (-var_IKs__E_Ks + var_chaste_interface__cell__V) * var_IKs__Fx_Ks_jct * var_IKs__G_Ks_jct; // microA_per_microF
        const double var_IKs__i_Ks = var_IKs__i_Ks_SL + var_IKs__i_Ks_jct; // microA_per_microF
        const double var_INaCa__Q_NCX = pow(var_INaCa__Q10_NCX, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_INaCa__temp_SL = (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_SL = var_INaCa__Fx_NCX_SL * var_INaCa__Ka_SL * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_SL / (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_SL / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_SL + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_SL / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_INaCa__temp_jct = (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_jct = var_INaCa__Fx_NCX_jct * var_INaCa__Ka_jct * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_jct / (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_jct / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_jct + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_jct / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_INaCa__i_NaCa = var_INaCa__i_NaCa_SL + var_INaCa__i_NaCa_jct; // microA_per_microF
        const double var_INaK__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) + 0.036499999999999998 * var_INaK__sigma * exp(-var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // dimensionless
        const double var_INaK__i_NaK_SL = var_INaK__Fx_NaK_SL * var_INaK__I_NaK_max * var_INaK__f_NaK * mParameters[5] / ((1.0 + pow((var_INaK__Km_Nai / var_chaste_interface__Na_buffer__Na_SL), var_INaK__H_NaK)) * (var_INaK__Km_Ko + mParameters[5])); // microA_per_microF
        const double var_INaK__i_NaK_jct = var_INaK__Fx_NaK_jct * var_INaK__I_NaK_max * var_INaK__f_NaK * mParameters[5] / ((1.0 + pow((var_INaK__Km_Nai / var_chaste_interface__Na_buffer__Na_jct), var_INaK__H_NaK)) * (var_INaK__Km_Ko + mParameters[5])); // microA_per_microF
        const double var_INaK__i_NaK = var_INaK__i_NaK_SL + var_INaK__i_NaK_jct; // microA_per_microF
        const double var_reversal_potentials__E_Ca_SL = 0.5 * var_model_parameters__R * var_model_parameters__T * log(mParameters[4] / var_chaste_interface__Ca_buffer__Ca_SL) / var_model_parameters__F; // millivolt
        const double var_ICab__i_Cab_SL = (-var_reversal_potentials__E_Ca_SL + var_chaste_interface__cell__V) * var_ICab__Fx_CaBk_SL * var_ICab__G_CaBk; // microA_per_microF
        const double var_reversal_potentials__E_Ca_jct = 0.5 * var_model_parameters__R * var_model_parameters__T * log(mParameters[4] / var_chaste_interface__Ca_buffer__Ca_jct) / var_model_parameters__F; // millivolt
        const double var_ICab__i_Cab_jct = (-var_reversal_potentials__E_Ca_jct + var_chaste_interface__cell__V) * var_ICab__Fx_CaBk_jct * var_ICab__G_CaBk; // microA_per_microF
        const double var_ICab__i_Cab = var_ICab__i_Cab_SL + var_ICab__i_Cab_jct; // microA_per_microF
        const double var_reversal_potentials__E_Cl = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Cli / var_model_parameters__Clo) / var_model_parameters__F; // millivolt
        const double var_ICl_Ca__i_Cl_Ca = (-var_reversal_potentials__E_Cl + var_chaste_interface__cell__V) * (var_ICl_Ca__Fx_Cl_SL / (1.0 + var_ICl_Ca__Kd_ClCa / var_chaste_interface__Ca_buffer__Ca_SL) + var_ICl_Ca__Fx_Cl_jct / (1.0 + var_ICl_Ca__Kd_ClCa / var_chaste_interface__Ca_buffer__Ca_jct)) * var_ICl_Ca__G_Cl; // microA_per_microF
        const double var_IClb__i_Clb = (-var_reversal_potentials__E_Cl + var_chaste_interface__cell__V) * var_IClb__G_ClBk; // microA_per_microF
        const double var_reversal_potentials__E_K = var_model_parameters__R * var_model_parameters__T * log(mParameters[5] / mParameters[3]) / var_model_parameters__F; // millivolt
        const double var_IK1_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__E_K)); // per_millisecond
        const double var_IK1_K1_gate__beta_K1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__E_K) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__E_K)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__E_K - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_millisecond
        const double var_IK1_K1_gate__K1_infinity = var_IK1_K1_gate__alpha_K1 / (var_IK1_K1_gate__alpha_K1 + var_IK1_K1_gate__beta_K1); // dimensionless
        const double var_IK1__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IK1__G_K1 * var_IK1_K1_gate__K1_infinity; // microA_per_microF
        const double var_IKp__i_Kp = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IKp__g_Kp / (1.0 + exp(7.4880000000000004 - 0.16722408026755853 * var_chaste_interface__cell__V)); // microA_per_microF
        const double var_IKr__i_Kr = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IKr__G_IKr * var_IKr_Rr_gate__Rr * var_chaste_interface__IKr_Xr_gate__Xr; // microA_per_microF
        const double var_Itof__i_tof = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_Itof__G_tof * var_chaste_interface__Itof_X_gate__X_tof * var_chaste_interface__Itof_Y_gate__Y_tof; // microA_per_microF
        const double var_Itos__i_tos = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * (0.5 * var_chaste_interface__Itos_R_gate__R_tos + var_chaste_interface__Itos_Y_gate__Y_tos) * mParameters[12] * var_chaste_interface__Itos_X_gate__X_tos; // microA_per_microF
        const double var_reversal_potentials__E_Na_SL = var_model_parameters__R * var_model_parameters__T * log(mParameters[6] / var_chaste_interface__Na_buffer__Na_SL) / var_model_parameters__F; // millivolt
        const double var_INa__i_Na_SL = (-var_reversal_potentials__E_Na_SL + var_chaste_interface__cell__V) * var_INa__Fx_Na_SL * mParameters[8] * var_INa__openProb; // microA_per_microF
        const double var_INab__i_Nab_SL = (-var_reversal_potentials__E_Na_SL + var_chaste_interface__cell__V) * var_INab__Fx_NaBk_SL * var_INab__G_NaBk; // microA_per_microF
        const double var_reversal_potentials__E_Na_jct = var_model_parameters__R * var_model_parameters__T * log(mParameters[6] / var_chaste_interface__Na_buffer__Na_jct) / var_model_parameters__F; // millivolt
        const double var_INa__i_Na_jct = (-var_reversal_potentials__E_Na_jct + var_chaste_interface__cell__V) * var_INa__Fx_Na_jct * mParameters[8] * var_INa__openProb; // microA_per_microF
        const double var_INa__i_Na = var_INa__i_Na_SL + var_INa__i_Na_jct; // microA_per_microF
        const double var_INab__i_Nab_jct = (-var_reversal_potentials__E_Na_jct + var_chaste_interface__cell__V) * var_INab__Fx_NaBk_jct * var_INab__G_NaBk; // microA_per_microF
        const double var_INab__i_Nab = var_INab__i_Nab_SL + var_INab__i_Nab_jct; // microA_per_microF
        d_dt_chaste_interface_var_cell__V = -var_ICaL__i_CaL - var_ICab__i_Cab - var_ICap__i_Cap - var_ICl_Ca__i_Cl_Ca - var_IClb__i_Clb - var_IK1__i_K1 - var_IKp__i_Kp - var_IKr__i_Kr - var_IKs__i_Ks - var_INa__i_Na - var_INaCa__i_NaCa - var_INaK__i_NaK - var_INab__i_Nab - var_Itof__i_tof - var_Itos__i_tos - var_cell__i_Stim; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_cell__V;
        mEvalF[0] = d_dt_chaste_interface_var_cell__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += 0.5*evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*0.5*mDt)-1.0);
        }

        rY[v_index] = yinit;
        evalF = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
        mEvalF[0] = evalF;
        partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] = yinit + evalF*mDt;
        }
        else
        {
            rY[v_index] = yinit + (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void CellShannon2004FromCellMLGRL2::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta=1e-8;
        const unsigned size = GetNumberOfStateVariables();
        mYInit = rY;
        double y_save;

        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__Ca_buffer__Cai = rY[1];
        // Units: millimolar; Initial value: 8.597401e-05
        double var_chaste_interface__INa_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.9867005
        double var_chaste_interface__INa_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.991562
        double var_chaste_interface__INa_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.001405627
        double var_chaste_interface__IKr_Xr_gate__Xr = rY[5];
        // Units: dimensionless; Initial value: 0.008641386
        double var_chaste_interface__IKs_Xs_gate__Xs = rY[6];
        // Units: dimensionless; Initial value: 0.005412034
        double var_chaste_interface__Itos_X_gate__X_tos = rY[7];
        // Units: dimensionless; Initial value: 0.004051574
        double var_chaste_interface__Itos_Y_gate__Y_tos = rY[8];
        // Units: dimensionless; Initial value: 0.9945511
        double var_chaste_interface__Itos_R_gate__R_tos = rY[9];
        // Units: dimensionless; Initial value: 0.9946
        double var_chaste_interface__Itof_X_gate__X_tof = rY[10];
        // Units: dimensionless; Initial value: 0.004051574
        double var_chaste_interface__Itof_Y_gate__Y_tof = rY[11];
        // Units: dimensionless; Initial value: 0.9945511
        double var_chaste_interface__ICaL_d_gate__d = rY[12];
        // Units: dimensionless; Initial value: 7.175662e-06
        double var_chaste_interface__ICaL_f_gate__f = rY[13];
        // Units: dimensionless; Initial value: 1.000681
        double var_chaste_interface__ICaL_fCa_gate__fCaB_SL = rY[14];
        // Units: dimensionless; Initial value: 0.01452605
        double var_chaste_interface__ICaL_fCa_gate__fCaB_jct = rY[15];
        // Units: dimensionless; Initial value: 0.02421991
        double var_chaste_interface__Jrel_SR__R = rY[16];
        // Units: dimensionless; Initial value: 0.8884332
        double var_chaste_interface__Jrel_SR__I = rY[17];
        // Units: dimensionless; Initial value: 1.024274e-07
        double var_chaste_interface__Jrel_SR__O = rY[18];
        // Units: dimensionless; Initial value: 8.156628e-07
        double var_chaste_interface__Na_buffer__Na_SL = rY[19];
        // Units: millimolar; Initial value: 8.80733
        double var_chaste_interface__Na_buffer__Na_jct = rY[20];
        // Units: millimolar; Initial value: 8.80329
        double var_chaste_interface__Na_buffer__Na_SL_buf = rY[21];
        // Units: millimolar; Initial value: 0.7720854
        double var_chaste_interface__Na_buffer__Na_jct_buf = rY[22];
        // Units: millimolar; Initial value: 3.539892
        double var_chaste_interface__Na_buffer__Nai = rY[23];
        // Units: millimolar; Initial value: 8.80853
        double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
        // Units: millimolar; Initial value: 0.5545201
        double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
        // Units: millimolar; Initial value: 0.0001031812
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        double var_chaste_interface__Ca_buffer__Ca_SLB_SL = rY[27];
        // Units: millimolar; Initial value: 0.1110363
        double var_chaste_interface__Ca_buffer__Ca_SLB_jct = rY[28];
        // Units: millimolar; Initial value: 0.009566355
        double var_chaste_interface__Ca_buffer__Ca_SLHigh_SL = rY[29];
        // Units: millimolar; Initial value: 0.07297378
        double var_chaste_interface__Ca_buffer__Ca_SLHigh_jct = rY[30];
        // Units: millimolar; Initial value: 0.007347888
        double var_chaste_interface__Ca_buffer__Ca_Calsequestrin = rY[31];
        // Units: millimolar; Initial value: 1.242988
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC = rY[32];
        // Units: millimolar; Initial value: 0.008773191
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg = rY[33];
        // Units: millimolar; Initial value: 0.1078283
        double var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg = rY[34];
        // Units: millimolar; Initial value: 0.01524002
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_Calmodulin = rY[35];
        // Units: millimolar; Initial value: 0.0002911916
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin = rY[36];
        // Units: millimolar; Initial value: 0.001298754
        double var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin = rY[37];
        // Units: millimolar; Initial value: 0.1381982
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_SRB = rY[38];
        // Units: millimolar; Initial value: 0.002143165
        
        
        // Mathematics
        double d_dt_chaste_interface_var_cell__V;
        const double var_Ca_buffer__Bmax_Calsequestrin = 0.14000000000000001; // millimolar
        const double var_Ca_buffer__Bmax_SLB_SL = 0.037400000000000003; // millimolar
        const double var_Ca_buffer__Bmax_SLB_jct = 0.0045999999999999999; // millimolar
        const double var_Ca_buffer__Bmax_SLHigh_SL = 0.0134; // millimolar
        const double var_Ca_buffer__Bmax_SLHigh_jct = 0.00165; // millimolar
        const double var_Ca_buffer__koff_Calsequestrin = 65.0; // per_millisecond
        const double var_Ca_buffer__koff_SLB = 1.3; // per_millisecond
        const double var_Ca_buffer__koff_SLHigh = 0.029999999999999999; // per_millisecond
        const double var_Ca_buffer__kon_Calsequestrin = 100.0; // per_millimolar_per_millisecond
        const double var_Ca_buffer__kon_SL = 100.0; // per_millimolar_per_millisecond
        const double var_ICaL__Fx_ICaL_SL = 0.10000000000000001; // dimensionless
        const double var_ICaL__Fx_ICaL_jct = 0.90000000000000002; // dimensionless
        const double var_ICaL__PNa = 1.4999999999999999e-8; // litre_per_farad_millisecond
        const double var_ICaL__Q10_CaL = 1.8; // dimensionless
        const double var_ICaL__gamma_Cai = 0.34100000000000003; // dimensionless
        const double var_ICaL__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_ICaL__gamma_Nai = 0.75; // dimensionless
        const double var_ICaL__gamma_Nao = 0.75; // dimensionless
        const double d_dt_chaste_interface_var_ICaL_fCa_gate__fCaB_SL = -0.011900000000000001 * var_chaste_interface__ICaL_fCa_gate__fCaB_SL + 1.7 * (1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_SL) * var_chaste_interface__Ca_buffer__Ca_SL; // 1 / millisecond
        const double d_dt_chaste_interface_var_ICaL_fCa_gate__fCaB_jct = -0.011900000000000001 * var_chaste_interface__ICaL_fCa_gate__fCaB_jct + 1.7 * (1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_jct) * var_chaste_interface__Ca_buffer__Ca_jct; // 1 / millisecond
        const double var_ICaL_fCa_gate__fCa_SL = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_SL; // dimensionless
        const double var_ICaL_fCa_gate__fCa_jct = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_jct; // dimensionless
        const double var_ICab__Fx_CaBk_SL = 0.89000000000000001; // dimensionless
        const double var_ICab__Fx_CaBk_jct = 0.11; // dimensionless
        const double var_ICab__G_CaBk = 0.00025129999999999998; // milliS_per_microF
        const double var_ICap__Fx_SLCaP_SL = 0.89000000000000001; // dimensionless
        const double var_ICap__Fx_SLCaP_jct = 0.11; // dimensionless
        const double var_ICap__H = 1.6000000000000001; // dimensionless
        const double var_ICap__Km = 0.00050000000000000001; // millimolar
        const double var_ICap__Q10_SLCaP = 2.3500000000000001; // dimensionless
        const double var_ICap__V_maxAF = 0.067299999999999999; // microA_per_microF
        const double var_INa__Fx_Na_SL = 0.89000000000000001; // dimensionless
        const double var_INa__Fx_Na_jct = 0.11; // dimensionless
        const double var_INaCa__Fx_NCX_SL = 0.89000000000000001; // dimensionless
        const double var_INaCa__Fx_NCX_jct = 0.11; // dimensionless
        const double var_INaCa__HNa = 3.0; // dimensionless
        const double var_INaCa__K_mCai = 0.0035899999999999999; // millimolar
        const double var_INaCa__K_mCao = 1.3; // millimolar
        const double var_INaCa__K_mNai = 12.289999999999999; // millimolar
        const double var_INaCa__K_mNao = 87.5; // millimolar
        const double var_INaCa__Kd_act = 0.00025599999999999999; // millimolar
        const double var_INaCa__Ka_SL = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_SL, 3)); // dimensionless
        const double var_INaCa__Ka_jct = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_jct, 3)); // dimensionless
        const double var_INaCa__Q10_NCX = 1.5700000000000001; // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_INaK__Fx_NaK_SL = 0.89000000000000001; // dimensionless
        const double var_INaK__Fx_NaK_jct = 0.11; // dimensionless
        const double var_INaK__H_NaK = 4.0; // dimensionless
        const double var_INaK__I_NaK_max = 1.9071899999999999; // microA_per_microF
        const double var_INaK__Km_Ko = 1.5; // millimolar
        const double var_INaK__Km_Nai = 11.0; // millimolar
        const double var_INa__openProb = pow(var_chaste_interface__INa_m_gate__m, 3) * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // dimensionless
        const double var_INab__Fx_NaBk_SL = 0.89000000000000001; // dimensionless
        const double var_INab__Fx_NaBk_jct = 0.11; // dimensionless
        const double var_INab__G_NaBk = 0.00029700000000000001; // milliS_per_microF
        const double var_Jleak_SR__j_leak_SR = (-var_chaste_interface__Ca_buffer__Ca_jct + var_chaste_interface__Ca_buffer__Ca_SR) * mParameters[0]; // millimolar_per_millisecond
        const double var_Jpump_SR__H = 1.7869999999999999; // dimensionless
        const double var_Jpump_SR__Kmf = 0.00024600000000000002; // millimolar
        const double var_Jpump_SR__Kmr = 1.7; // millimolar
        const double var_Jpump_SR__Q10_SRCaP = 2.6000000000000001; // dimensionless
        const double var_Jrel_SR__EC50_SR = 0.45000000000000001; // millimolar
        const double var_Jrel_SR__HSR = 2.5; // dimensionless
        const double var_Jrel_SR__Max_SR = 15.0; // dimensionless
        const double var_Jrel_SR__Min_SR = 1.0; // dimensionless
        const double var_Jrel_SR__RI = 1.0 - var_chaste_interface__Jrel_SR__I - var_chaste_interface__Jrel_SR__O - var_chaste_interface__Jrel_SR__R; // dimensionless
        const double var_Jrel_SR__kCaSR = -(-var_Jrel_SR__Min_SR + var_Jrel_SR__Max_SR) / (1.0 + pow((var_Jrel_SR__EC50_SR / var_chaste_interface__Ca_buffer__Ca_SR), var_Jrel_SR__HSR)) + var_Jrel_SR__Max_SR; // dimensionless
        const double var_Jrel_SR__kiCa = 0.5; // per_millimolar_per_millisecond
        const double var_Jrel_SR__kiSRCa = var_Jrel_SR__kCaSR * var_Jrel_SR__kiCa; // per_millimolar_per_millisecond
        const double var_Jrel_SR__kim = 0.0050000000000000001; // per_millisecond
        const double var_Jrel_SR__koCa = 10.0; // per_millimolar2_per_millisecond
        const double var_Jrel_SR__koSRCa = var_Jrel_SR__koCa / var_Jrel_SR__kCaSR; // per_millimolar2_per_millisecond
        const double var_Jrel_SR__kom = 0.059999999999999998; // per_millisecond
        const double d_dt_chaste_interface_var_Jrel_SR__I = -var_chaste_interface__Jrel_SR__I * var_Jrel_SR__kim - var_chaste_interface__Jrel_SR__I * var_Jrel_SR__kom + pow(var_chaste_interface__Ca_buffer__Ca_jct, 2) * var_Jrel_SR__RI * var_Jrel_SR__koSRCa + var_chaste_interface__Ca_buffer__Ca_jct * var_chaste_interface__Jrel_SR__O * var_Jrel_SR__kiSRCa; // 1 / millisecond
        const double d_dt_chaste_interface_var_Jrel_SR__O = var_chaste_interface__Jrel_SR__I * var_Jrel_SR__kim - var_chaste_interface__Jrel_SR__O * var_Jrel_SR__kom + pow(var_chaste_interface__Ca_buffer__Ca_jct, 2) * var_chaste_interface__Jrel_SR__R * var_Jrel_SR__koSRCa - var_chaste_interface__Ca_buffer__Ca_jct * var_chaste_interface__Jrel_SR__O * var_Jrel_SR__kiSRCa; // 1 / millisecond
        const double d_dt_chaste_interface_var_Jrel_SR__R = var_chaste_interface__Jrel_SR__O * var_Jrel_SR__kom + var_Jrel_SR__RI * var_Jrel_SR__kim - pow(var_chaste_interface__Ca_buffer__Ca_jct, 2) * var_chaste_interface__Jrel_SR__R * var_Jrel_SR__koSRCa - var_chaste_interface__Ca_buffer__Ca_jct * var_chaste_interface__Jrel_SR__R * var_Jrel_SR__kiSRCa; // 1 / millisecond
        const double var_Jrel_SR__j_rel_SR = (-var_chaste_interface__Ca_buffer__Ca_jct + var_chaste_interface__Ca_buffer__Ca_SR) * var_chaste_interface__Jrel_SR__O * mParameters[1]; // millimolar_per_millisecond
        const double var_Na_buffer__Bmax_SL = 1.6499999999999999; // millimolar
        const double var_Na_buffer__Bmax_jct = 7.5609999999999999; // millimolar
        const double var_Na_buffer__koff = 0.001; // per_millisecond
        const double var_Na_buffer__kon = 0.0001; // per_millimolar_per_millisecond
        const double var_Na_buffer__dNa_SL_buf = -var_chaste_interface__Na_buffer__Na_SL_buf * var_Na_buffer__koff + (-var_chaste_interface__Na_buffer__Na_SL_buf + var_Na_buffer__Bmax_SL) * var_chaste_interface__Na_buffer__Na_SL * var_Na_buffer__kon; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Na_buffer__Na_SL_buf = var_Na_buffer__dNa_SL_buf; // millimolar / millisecond
        const double var_Na_buffer__dNa_jct_buf = -var_chaste_interface__Na_buffer__Na_jct_buf * var_Na_buffer__koff + (-var_chaste_interface__Na_buffer__Na_jct_buf + var_Na_buffer__Bmax_jct) * var_chaste_interface__Na_buffer__Na_jct * var_Na_buffer__kon; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Na_buffer__Na_jct_buf = var_Na_buffer__dNa_jct_buf; // millimolar / millisecond
        const double var_ICaL_d_gate__d_infinity = 1 / (1.0 + exp(-2.4166666666666665 - 0.16666666666666666 * var_chaste_interface__cell__V)); // dimensionless
        const double var_ICaL_d_gate__tau_d = 28.571428571428569 * (1.0 - exp(-2.4166666666666665 - 0.16666666666666666 * var_chaste_interface__cell__V)) * var_ICaL_d_gate__d_infinity / (14.5 + var_chaste_interface__cell__V); // millisecond
        const double d_dt_chaste_interface_var_ICaL_d_gate__d = (-var_chaste_interface__ICaL_d_gate__d + var_ICaL_d_gate__d_infinity) / var_ICaL_d_gate__tau_d; // 1 / millisecond
        const double var_ICaL_f_gate__f_infinity = 1 / (1.0 + exp(9.7388888888888889 + 0.27777777777777779 * var_chaste_interface__cell__V)) + 0.59999999999999998 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__cell__V)); // dimensionless
        const double var_ICaL_f_gate__tau_f = 1 / (0.02 + 0.019699999999999999 * exp(-0.23877882250000002 * pow((1 + 0.068965517241379309 * var_chaste_interface__cell__V), 2))); // millisecond
        const double d_dt_chaste_interface_var_ICaL_f_gate__f = (-var_chaste_interface__ICaL_f_gate__f + var_ICaL_f_gate__f_infinity) / var_ICaL_f_gate__tau_f; // 1 / millisecond
        const double var_IKr_Xr_gate__Xr_infinity = 1 / (1.0 + exp(-6.666666666666667 - 0.13333333333333333 * var_chaste_interface__cell__V)); // dimensionless
        const double var_IKr_Xr_gate__tau_Xr = 1 / (0.00060999999999999997 * (10.0 + var_chaste_interface__cell__V) / (-1.0 + exp(1.45 + 0.14499999999999999 * var_chaste_interface__cell__V)) + 0.0013799999999999999 * (7.0 + var_chaste_interface__cell__V) / (1.0 - exp(-0.86099999999999999 - 0.123 * var_chaste_interface__cell__V))); // millisecond
        const double d_dt_chaste_interface_var_IKr_Xr_gate__Xr = (-var_chaste_interface__IKr_Xr_gate__Xr + var_IKr_Xr_gate__Xr_infinity) / var_IKr_Xr_gate__tau_Xr; // 1 / millisecond
        const double var_IKs_Xs_gate__Xs_infinity = 1 / (1.0 + exp(0.089820359281437126 - 0.059880239520958084 * var_chaste_interface__cell__V)); // dimensionless
        const double var_IKs_Xs_gate__tau_Xs = 1 / (0.00013100000000000001 * (30.0 + var_chaste_interface__cell__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__cell__V)) + 7.1899999999999999e-5 * (30.0 + var_chaste_interface__cell__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__cell__V))); // millisecond
        const double d_dt_chaste_interface_var_IKs_Xs_gate__Xs = (-var_chaste_interface__IKs_Xs_gate__Xs + var_IKs_Xs_gate__Xs_infinity) / var_IKs_Xs_gate__tau_Xs; // 1 / millisecond
        const double var_INa_h_gate__alpha_h = ((var_chaste_interface__cell__V < -40.0) ? (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V)) : (0)); // per_millisecond
        const double var_INa_h_gate__beta_h = ((var_chaste_interface__cell__V < -40.0) ? (310000.0 * exp(0.34999999999999998 * var_chaste_interface__cell__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__cell__V)) : (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V)))); // per_millisecond
        const double d_dt_chaste_interface_var_INa_h_gate__h = (1.0 - var_chaste_interface__INa_h_gate__h) * var_INa_h_gate__alpha_h - var_INa_h_gate__beta_h * var_chaste_interface__INa_h_gate__h; // 1 / millisecond
        const double var_INa_j_gate__alpha_j = ((var_chaste_interface__cell__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__cell__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__cell__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__cell__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V))) : (0)); // per_millisecond
        const double var_INa_j_gate__beta_j = ((var_chaste_interface__cell__V < -40.0) ? (0.1212 * exp(-0.01052 * var_chaste_interface__cell__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V))) : (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__V)))); // per_millisecond
        const double d_dt_chaste_interface_var_INa_j_gate__j = (1.0 - var_chaste_interface__INa_j_gate__j) * var_INa_j_gate__alpha_j - var_INa_j_gate__beta_j * var_chaste_interface__INa_j_gate__j; // 1 / millisecond
        const double var_INa_m_gate__alpha_m = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V)); // per_millisecond
        const double var_INa_m_gate__beta_m = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__cell__V); // per_millisecond
        const double d_dt_chaste_interface_var_INa_m_gate__m = (1.0 - var_chaste_interface__INa_m_gate__m) * var_INa_m_gate__alpha_m - var_INa_m_gate__beta_m * var_chaste_interface__INa_m_gate__m; // 1 / millisecond
        const double var_Itof_X_gate__X_tof_infinity = 1 / (1.0 + exp(-0.20000000000000001 - 0.066666666666666666 * var_chaste_interface__cell__V)); // dimensionless
        const double var_Itof_X_gate__tau_X_tof = 1.5 + 3.5 * exp(-0.0011111111111111111 * pow(var_chaste_interface__cell__V, 2)); // millisecond
        const double d_dt_chaste_interface_var_Itof_X_gate__X_tof = (-var_chaste_interface__Itof_X_gate__X_tof + var_Itof_X_gate__X_tof_infinity) / var_Itof_X_gate__tau_X_tof; // 1 / millisecond
        const double var_Itof_Y_gate__Y_tof_infinity = 1 / (1.0 + exp(3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V)); // dimensionless
        const double var_Itof_Y_gate__tau_Y_tof = 20.0 + 20.0 / (1.0 + exp(3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V)); // millisecond
        const double d_dt_chaste_interface_var_Itof_Y_gate__Y_tof = (-var_chaste_interface__Itof_Y_gate__Y_tof + var_Itof_Y_gate__Y_tof_infinity) / var_Itof_Y_gate__tau_Y_tof; // 1 / millisecond
        const double var_Itos_R_gate__R_tos_infinity = 1 / (1.0 + exp(3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V)); // dimensionless
        const double var_Itos_R_gate__tau_R_tos = 220.0 + 2800.0 / (1.0 + exp(6.0 + 0.10000000000000001 * var_chaste_interface__cell__V)); // millisecond
        const double d_dt_chaste_interface_var_Itos_R_gate__R_tos = (-var_chaste_interface__Itos_R_gate__R_tos + var_Itos_R_gate__R_tos_infinity) / var_Itos_R_gate__tau_R_tos; // 1 / millisecond
        const double var_Itos_X_gate__X_tos_infinity = 1 / (1.0 + exp(-0.20000000000000001 - 0.066666666666666666 * var_chaste_interface__cell__V)); // dimensionless
        const double var_Itos_X_gate__tau_X_tos = 0.5 + 9.0 / (1.0 + exp(0.20000000000000001 + 0.066666666666666666 * var_chaste_interface__cell__V)); // millisecond
        const double d_dt_chaste_interface_var_Itos_X_gate__X_tos = (-var_chaste_interface__Itos_X_gate__X_tos + var_Itos_X_gate__X_tos_infinity) / var_Itos_X_gate__tau_X_tos; // 1 / millisecond
        const double var_Itos_Y_gate__Y_tos_infinity = 1 / (1.0 + exp(3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V)); // dimensionless
        const double var_Itos_Y_gate__tau_Y_tos = 30.0 + 3000.0 / (1.0 + exp(6.0 + 0.10000000000000001 * var_chaste_interface__cell__V)); // millisecond
        const double d_dt_chaste_interface_var_Itos_Y_gate__Y_tos = (-var_chaste_interface__Itos_Y_gate__Y_tos + var_Itos_Y_gate__Y_tos_infinity) / var_Itos_Y_gate__tau_Y_tos; // 1 / millisecond
        const double var_cytosolic_Ca_buffer__Bmax_Calmodulin = 0.024; // millimolar
        const double var_cytosolic_Ca_buffer__Bmax_Myosin_Ca = 0.14000000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__Bmax_Myosin_Mg = 0.14000000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__Bmax_SRB = 0.017100000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__Bmax_TroponinC = 0.070000000000000007; // millimolar
        const double var_cytosolic_Ca_buffer__Bmax_TroponinC_Ca_Mg_Ca = 0.14000000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__Bmax_TroponinC_Ca_Mg_Mg = 0.14000000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__koff_Calmodulin = 0.23799999999999999; // per_millisecond
        const double var_cytosolic_Ca_buffer__koff_Myosin_Ca = 0.00046000000000000001; // per_millisecond
        const double var_cytosolic_Ca_buffer__koff_Myosin_Mg = 5.7000000000000003e-5; // per_millisecond
        const double var_cytosolic_Ca_buffer__koff_SRB = 0.059999999999999998; // per_millisecond
        const double var_cytosolic_Ca_buffer__koff_TroponinC = 0.019599999999999999; // per_millisecond
        const double var_cytosolic_Ca_buffer__koff_TroponinC_Ca_Mg_Ca = 3.1999999999999999e-5; // per_millisecond
        const double var_cytosolic_Ca_buffer__koff_TroponinC_Ca_Mg_Mg = 0.0033300000000000001; // per_millisecond
        const double var_cytosolic_Ca_buffer__kon_Calmodulin = 34.0; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_Calmodulin = -var_chaste_interface__cytosolic_Ca_buffer__Ca_Calmodulin * var_cytosolic_Ca_buffer__koff_Calmodulin + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_Calmodulin + var_cytosolic_Ca_buffer__Bmax_Calmodulin) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_Calmodulin; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_Calmodulin = var_cytosolic_Ca_buffer__dCa_Calmodulin; // millimolar / millisecond
        const double var_cytosolic_Ca_buffer__kon_Myosin_Ca = 13.800000000000001; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_Myosin = -var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin * var_cytosolic_Ca_buffer__koff_Myosin_Ca + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin - var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin + var_cytosolic_Ca_buffer__Bmax_Myosin_Ca) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_Myosin_Ca; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_Myosin = var_cytosolic_Ca_buffer__dCa_Myosin; // millimolar / millisecond
        const double var_cytosolic_Ca_buffer__kon_Myosin_Mg = 0.015699999999999999; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__kon_SRB = 100.0; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_SRB = -var_chaste_interface__cytosolic_Ca_buffer__Ca_SRB * var_cytosolic_Ca_buffer__koff_SRB + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_SRB + var_cytosolic_Ca_buffer__Bmax_SRB) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_SRB; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_SRB = var_cytosolic_Ca_buffer__dCa_SRB; // millimolar / millisecond
        const double var_cytosolic_Ca_buffer__kon_TroponinC = 32.700000000000003; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_TroponinC = -var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC * var_cytosolic_Ca_buffer__koff_TroponinC + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC + var_cytosolic_Ca_buffer__Bmax_TroponinC) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_TroponinC; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_TroponinC = var_cytosolic_Ca_buffer__dCa_TroponinC; // millimolar / millisecond
        const double var_cytosolic_Ca_buffer__kon_TroponinC_Ca_Mg_Ca = 2.3700000000000001; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_TroponinC_Ca_Mg = -var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg * var_cytosolic_Ca_buffer__koff_TroponinC_Ca_Mg_Ca + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg - var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg + var_cytosolic_Ca_buffer__Bmax_TroponinC_Ca_Mg_Ca) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_TroponinC_Ca_Mg_Ca; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg = var_cytosolic_Ca_buffer__dCa_TroponinC_Ca_Mg; // millimolar / millisecond
        const double var_cytosolic_Ca_buffer__kon_TroponinC_Ca_Mg_Mg = 0.0030000000000000001; // per_millimolar_per_millisecond
        const double var_ion_diffusion__J_Ca_SL_myo = 3.7243000000000002e-12 * var_chaste_interface__Ca_buffer__Ca_SL - 3.7243000000000002e-12 * var_chaste_interface__Ca_buffer__Cai; // millimole_per_millisecond
        const double var_ion_diffusion__J_Ca_jct_SL = 8.2413000000000004e-13 * var_chaste_interface__Ca_buffer__Ca_jct - 8.2413000000000004e-13 * var_chaste_interface__Ca_buffer__Ca_SL; // millimole_per_millisecond
        const double var_ion_diffusion__J_Na_SL_myo = 1.6385999999999999e-12 * var_chaste_interface__Na_buffer__Na_SL - 1.6385999999999999e-12 * var_chaste_interface__Na_buffer__Nai; // millimole_per_millisecond
        const double var_ion_diffusion__J_Na_jct_SL = 1.8312999999999999e-14 * var_chaste_interface__Na_buffer__Na_jct - 1.8312999999999999e-14 * var_chaste_interface__Na_buffer__Na_SL; // millimole_per_millisecond
        const double var_model_parameters__Cm = 1.3809999999999999e-10; // farad
        const double var_model_parameters__F = 96485.0; // coulomb_per_mole
        const double var_model_parameters__Mgi = 1.0; // millimolar
        const double var_cytosolic_Ca_buffer__dMg_Myosin = -var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin * var_cytosolic_Ca_buffer__koff_Myosin_Mg + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin - var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin + var_cytosolic_Ca_buffer__Bmax_Myosin_Mg) * var_cytosolic_Ca_buffer__kon_Myosin_Mg * var_model_parameters__Mgi; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Mg_Myosin = var_cytosolic_Ca_buffer__dMg_Myosin; // millimolar / millisecond
        const double var_cytosolic_Ca_buffer__dMg_TroponinC_Ca_Mg = -var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg * var_cytosolic_Ca_buffer__koff_TroponinC_Ca_Mg_Mg + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg - var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg + var_cytosolic_Ca_buffer__Bmax_TroponinC_Ca_Mg_Mg) * var_cytosolic_Ca_buffer__kon_TroponinC_Ca_Mg_Mg * var_model_parameters__Mgi; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg = var_cytosolic_Ca_buffer__dMg_TroponinC_Ca_Mg; // millimolar / millisecond
        const double var_cytosolic_Ca_buffer__dCa_cytosol_tot_bound = var_cytosolic_Ca_buffer__dCa_Calmodulin + var_cytosolic_Ca_buffer__dCa_Myosin + var_cytosolic_Ca_buffer__dCa_SRB + var_cytosolic_Ca_buffer__dCa_TroponinC + var_cytosolic_Ca_buffer__dCa_TroponinC_Ca_Mg + var_cytosolic_Ca_buffer__dMg_Myosin + var_cytosolic_Ca_buffer__dMg_TroponinC_Ca_Mg; // millimolar_per_millisecond
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * mParameters[6]); // dimensionless
        const double var_model_parameters__R = 8314.2999999999993; // joule_per_kilomole_kelvin
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__Q_CaL = pow(var_ICaL__Q10_CaL, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICaL__temp = 0.45000000000000001 * pow(var_model_parameters__F, 2) * var_ICaL__Q_CaL * var_chaste_interface__ICaL_d_gate__d * var_chaste_interface__ICaL_f_gate__f * var_chaste_interface__cell__V / (var_model_parameters__R * var_model_parameters__T); // coulomb_per_mole
        const double var_ICaL__i_CaL_Ca_SL = 4.0 * (-var_ICaL__gamma_Cao * mParameters[4] + var_chaste_interface__Ca_buffer__Ca_SL * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_SL * mParameters[7] * var_ICaL__temp * var_ICaL_fCa_gate__fCa_SL / (-1.0 + exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Ca_jct = 4.0 * (-var_ICaL__gamma_Cao * mParameters[4] + var_chaste_interface__Ca_buffer__Ca_jct * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_jct * mParameters[7] * var_ICaL__temp * var_ICaL_fCa_gate__fCa_jct / (-1.0 + exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Na_SL = (-var_ICaL__gamma_Nao * mParameters[6] + var_ICaL__gamma_Nai * var_chaste_interface__Na_buffer__Na_SL * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_SL * var_ICaL__PNa * var_ICaL__temp * var_ICaL_fCa_gate__fCa_SL / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Na_jct = (-var_ICaL__gamma_Nao * mParameters[6] + var_ICaL__gamma_Nai * var_chaste_interface__Na_buffer__Na_jct * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_jct * var_ICaL__PNa * var_ICaL__temp * var_ICaL_fCa_gate__fCa_jct / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICap__Q_SLCaP = pow(var_ICap__Q10_SLCaP, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICap__i_Cap_SL = var_ICap__Fx_SLCaP_SL * var_ICap__Q_SLCaP * var_ICap__V_maxAF / (1.0 + pow((var_ICap__Km / var_chaste_interface__Ca_buffer__Ca_SL), var_ICap__H)); // microA_per_microF
        const double var_ICap__i_Cap_jct = var_ICap__Fx_SLCaP_jct * var_ICap__Q_SLCaP * var_ICap__V_maxAF / (1.0 + pow((var_ICap__Km / var_chaste_interface__Ca_buffer__Ca_jct), var_ICap__H)); // microA_per_microF
        const double var_INaCa__Q_NCX = pow(var_INaCa__Q10_NCX, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_INaCa__temp_SL = (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_SL = var_INaCa__Fx_NCX_SL * var_INaCa__Ka_SL * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_SL / (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_SL / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_SL + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_SL / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_INaCa__temp_jct = (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_jct = var_INaCa__Fx_NCX_jct * var_INaCa__Ka_jct * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_jct / (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_jct / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_jct + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_jct / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_INaK__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) + 0.036499999999999998 * var_INaK__sigma * exp(-var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // dimensionless
        const double var_INaK__i_NaK_SL = var_INaK__Fx_NaK_SL * var_INaK__I_NaK_max * var_INaK__f_NaK * mParameters[5] / ((1.0 + pow((var_INaK__Km_Nai / var_chaste_interface__Na_buffer__Na_SL), var_INaK__H_NaK)) * (var_INaK__Km_Ko + mParameters[5])); // microA_per_microF
        const double var_INaK__i_NaK_jct = var_INaK__Fx_NaK_jct * var_INaK__I_NaK_max * var_INaK__f_NaK * mParameters[5] / ((1.0 + pow((var_INaK__Km_Nai / var_chaste_interface__Na_buffer__Na_jct), var_INaK__H_NaK)) * (var_INaK__Km_Ko + mParameters[5])); // microA_per_microF
        const double var_Jpump_SR__Q_SRCaP = pow(var_Jpump_SR__Q10_SRCaP, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_Jpump_SR__j_pump_SR = (pow((var_chaste_interface__Ca_buffer__Cai / var_Jpump_SR__Kmf), var_Jpump_SR__H) - pow((var_chaste_interface__Ca_buffer__Ca_SR / var_Jpump_SR__Kmr), var_Jpump_SR__H)) * var_Jpump_SR__Q_SRCaP * mParameters[2] / (1.0 + pow((var_chaste_interface__Ca_buffer__Cai / var_Jpump_SR__Kmf), var_Jpump_SR__H) + pow((var_chaste_interface__Ca_buffer__Ca_SR / var_Jpump_SR__Kmr), var_Jpump_SR__H)); // millimolar_per_millisecond
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_SL = 0.02 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_SR = 0.035000000000000003 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_jct = 0.00053900000000000009 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_myo = 0.65000000000000002 * var_model_parameters__Vol_Cell; // liter
        const double var_Ca_buffer__dCa_SLB_SL = -var_chaste_interface__Ca_buffer__Ca_SLB_SL * var_Ca_buffer__koff_SLB + (-var_chaste_interface__Ca_buffer__Ca_SLB_SL + var_Ca_buffer__Bmax_SLB_SL * var_model_parameters__Vol_myo / var_model_parameters__Vol_SL) * var_chaste_interface__Ca_buffer__Ca_SL * var_Ca_buffer__kon_SL; // millimolar_per_millisecond
        const double var_Ca_buffer__dCa_SLB_jct = -var_chaste_interface__Ca_buffer__Ca_SLB_jct * var_Ca_buffer__koff_SLB + (-var_chaste_interface__Ca_buffer__Ca_SLB_jct + 0.10000000000000001 * var_Ca_buffer__Bmax_SLB_jct * var_model_parameters__Vol_myo / var_model_parameters__Vol_jct) * var_chaste_interface__Ca_buffer__Ca_jct * var_Ca_buffer__kon_SL; // millimolar_per_millisecond
        const double var_Ca_buffer__dCa_SLHigh_SL = -var_chaste_interface__Ca_buffer__Ca_SLHigh_SL * var_Ca_buffer__koff_SLHigh + (-var_chaste_interface__Ca_buffer__Ca_SLHigh_SL + var_Ca_buffer__Bmax_SLHigh_SL * var_model_parameters__Vol_myo / var_model_parameters__Vol_SL) * var_chaste_interface__Ca_buffer__Ca_SL * var_Ca_buffer__kon_SL; // millimolar_per_millisecond
        const double var_Ca_buffer__dCa_SLHigh_jct = -var_chaste_interface__Ca_buffer__Ca_SLHigh_jct * var_Ca_buffer__koff_SLHigh + (-var_chaste_interface__Ca_buffer__Ca_SLHigh_jct + 0.10000000000000001 * var_Ca_buffer__Bmax_SLHigh_jct * var_model_parameters__Vol_myo / var_model_parameters__Vol_jct) * var_chaste_interface__Ca_buffer__Ca_jct * var_Ca_buffer__kon_SL; // millimolar_per_millisecond
        const double var_Ca_buffer__dCa_SL_tot_bound = var_Ca_buffer__dCa_SLB_SL + var_Ca_buffer__dCa_SLHigh_SL; // millimolar_per_millisecond
        const double var_Ca_buffer__dCa_jct_tot_bound = var_Ca_buffer__dCa_SLB_jct + var_Ca_buffer__dCa_SLHigh_jct; // millimolar_per_millisecond
        const double var_Ca_buffer__dCalsequestrin = -var_chaste_interface__Ca_buffer__Ca_Calsequestrin * var_Ca_buffer__koff_Calsequestrin + (-var_chaste_interface__Ca_buffer__Ca_Calsequestrin + var_Ca_buffer__Bmax_Calsequestrin * var_model_parameters__Vol_myo / var_model_parameters__Vol_SR) * var_chaste_interface__Ca_buffer__Ca_SR * var_Ca_buffer__kon_Calsequestrin; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_Calsequestrin = var_Ca_buffer__dCalsequestrin; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_SLB_SL = var_Ca_buffer__dCa_SLB_SL; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_SLB_jct = var_Ca_buffer__dCa_SLB_jct; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_SLHigh_SL = var_Ca_buffer__dCa_SLHigh_SL; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_SLHigh_jct = var_Ca_buffer__dCa_SLHigh_jct; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_SR = -var_Ca_buffer__dCalsequestrin - var_Jrel_SR__j_rel_SR - var_Jleak_SR__j_leak_SR * var_model_parameters__Vol_myo / var_model_parameters__Vol_SR + var_Jpump_SR__j_pump_SR; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Cai = -1.0 * var_cytosolic_Ca_buffer__dCa_cytosol_tot_bound + var_ion_diffusion__J_Ca_SL_myo / var_model_parameters__Vol_myo - var_Jpump_SR__j_pump_SR * var_model_parameters__Vol_SR / var_model_parameters__Vol_myo; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Na_buffer__Nai = var_ion_diffusion__J_Na_SL_myo / var_model_parameters__Vol_myo; // millimolar / millisecond
        const double var_reversal_potentials__E_Ca_SL = 0.5 * var_model_parameters__R * var_model_parameters__T * log(mParameters[4] / var_chaste_interface__Ca_buffer__Ca_SL) / var_model_parameters__F; // millivolt
        const double var_ICab__i_Cab_SL = (-var_reversal_potentials__E_Ca_SL + var_chaste_interface__cell__V) * var_ICab__Fx_CaBk_SL * var_ICab__G_CaBk; // microA_per_microF
        const double var_Ca_buffer__i_Ca_SL_tot = -2.0 * var_INaCa__i_NaCa_SL + var_ICaL__i_CaL_Ca_SL + var_ICab__i_Cab_SL + var_ICap__i_Cap_SL; // microA_per_microF
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_SL = -1.0 * var_Ca_buffer__dCa_SL_tot_bound + (-var_ion_diffusion__J_Ca_SL_myo + var_ion_diffusion__J_Ca_jct_SL) / var_model_parameters__Vol_SL - 0.5 * var_Ca_buffer__i_Ca_SL_tot * var_model_parameters__Cm / (var_model_parameters__F * var_model_parameters__Vol_SL); // millimolar / millisecond
        const double var_reversal_potentials__E_Ca_jct = 0.5 * var_model_parameters__R * var_model_parameters__T * log(mParameters[4] / var_chaste_interface__Ca_buffer__Ca_jct) / var_model_parameters__F; // millivolt
        const double var_ICab__i_Cab_jct = (-var_reversal_potentials__E_Ca_jct + var_chaste_interface__cell__V) * var_ICab__Fx_CaBk_jct * var_ICab__G_CaBk; // microA_per_microF
        const double var_Ca_buffer__i_Ca_jct_tot = -2.0 * var_INaCa__i_NaCa_jct + var_ICaL__i_CaL_Ca_jct + var_ICab__i_Cab_jct + var_ICap__i_Cap_jct; // microA_per_microF
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_jct = -1.0 * var_Ca_buffer__dCa_jct_tot_bound - var_ion_diffusion__J_Ca_jct_SL / var_model_parameters__Vol_jct + var_Jleak_SR__j_leak_SR * var_model_parameters__Vol_myo / var_model_parameters__Vol_jct + var_Jrel_SR__j_rel_SR * var_model_parameters__Vol_SR / var_model_parameters__Vol_jct - 0.5 * var_Ca_buffer__i_Ca_jct_tot * var_model_parameters__Cm / (var_model_parameters__F * var_model_parameters__Vol_jct); // millimolar / millisecond
        const double var_reversal_potentials__E_Na_SL = var_model_parameters__R * var_model_parameters__T * log(mParameters[6] / var_chaste_interface__Na_buffer__Na_SL) / var_model_parameters__F; // millivolt
        const double var_INa__i_Na_SL = (-var_reversal_potentials__E_Na_SL + var_chaste_interface__cell__V) * var_INa__Fx_Na_SL * mParameters[8] * var_INa__openProb; // microA_per_microF
        const double var_INab__i_Nab_SL = (-var_reversal_potentials__E_Na_SL + var_chaste_interface__cell__V) * var_INab__Fx_NaBk_SL * var_INab__G_NaBk; // microA_per_microF
        const double d_dt_chaste_interface_var_Na_buffer__Na_SL = -var_Na_buffer__dNa_SL_buf + (-var_ion_diffusion__J_Na_SL_myo + var_ion_diffusion__J_Na_jct_SL) / var_model_parameters__Vol_SL - (3.0 * var_INaCa__i_NaCa_SL + 3.0 * var_INaK__i_NaK_SL + var_ICaL__i_CaL_Na_SL + var_INa__i_Na_SL + var_INab__i_Nab_SL) * var_model_parameters__Cm / (var_model_parameters__F * var_model_parameters__Vol_SL); // millimolar / millisecond
        const double var_reversal_potentials__E_Na_jct = var_model_parameters__R * var_model_parameters__T * log(mParameters[6] / var_chaste_interface__Na_buffer__Na_jct) / var_model_parameters__F; // millivolt
        const double var_INa__i_Na_jct = (-var_reversal_potentials__E_Na_jct + var_chaste_interface__cell__V) * var_INa__Fx_Na_jct * mParameters[8] * var_INa__openProb; // microA_per_microF
        const double var_INab__i_Nab_jct = (-var_reversal_potentials__E_Na_jct + var_chaste_interface__cell__V) * var_INab__Fx_NaBk_jct * var_INab__G_NaBk; // microA_per_microF
        const double d_dt_chaste_interface_var_Na_buffer__Na_jct = -var_Na_buffer__dNa_jct_buf - var_ion_diffusion__J_Na_jct_SL / var_model_parameters__Vol_jct - (3.0 * var_INaCa__i_NaCa_jct + 3.0 * var_INaK__i_NaK_jct + var_ICaL__i_CaL_Na_jct + var_INa__i_Na_jct + var_INab__i_Nab_jct) * var_model_parameters__Cm / (var_model_parameters__F * var_model_parameters__Vol_jct); // millimolar / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_cell__V = 0.0;
        }
        else
        {
            const double var_ICaL__PK = 2.7000000000000001e-7; // litre_per_farad_millisecond
            const double var_ICaL__gamma_Ki = 0.75; // dimensionless
            const double var_ICaL__gamma_Ko = 0.75; // dimensionless
            const double var_ICl_Ca__Fx_Cl_SL = 0.89000000000000001; // dimensionless
            const double var_ICl_Ca__Fx_Cl_jct = 0.11; // dimensionless
            const double var_ICl_Ca__G_Cl = 0.109625; // milliS_per_microF
            const double var_ICl_Ca__Kd_ClCa = 0.10000000000000001; // millimolar
            const double var_IClb__G_ClBk = 0.0089999999999999993; // milliS_per_microF
            const double var_IKp__g_Kp = 0.001; // milliS_per_microF
            const double var_IKs__Fx_Ks_SL = 0.89000000000000001; // dimensionless
            const double var_IKs__Fx_Ks_jct = 0.11; // dimensionless
            const double var_IKs__pCa_SL = 3.0 - log10(var_chaste_interface__Ca_buffer__Ca_SL); // dimensionless
            const double var_IKs__G_Ks_SL = (0.057000000000000002 + 0.19 / (1.0 + exp(-12.0 + 1.6666666666666667 * var_IKs__pCa_SL))) * mParameters[10]; // milliS_per_microF
            const double var_IKs__pCa_jct = 3.0 - log10(var_chaste_interface__Ca_buffer__Ca_jct); // dimensionless
            const double var_IKs__G_Ks_jct = (0.057000000000000002 + 0.19 / (1.0 + exp(-12.0 + 1.6666666666666667 * var_IKs__pCa_jct))) * mParameters[10]; // milliS_per_microF
            const double var_IKs__pKNa = 0.018329999999999999; // dimensionless
            const double var_Itof__G_tof = 0.02; // milliS_per_microF
            const double var_IKr_Rr_gate__Rr = 1 / (1.0 + exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V)); // dimensionless
            const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
            const double var_cell__i_Stim = var_cell__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // microA_per_microF
            const double var_model_parameters__Cli = 15.0; // millimolar
            const double var_model_parameters__Clo = 150.0; // millimolar
            const double var_IK1__G_K1 = 0.3872983346207417 * sqrt(mParameters[5]); // milliS_per_microF
            const double var_IKr__G_IKr = 0.43033148291193518 * sqrt(mParameters[5]) * mParameters[9]; // milliS_per_microF
            const double var_ICaL__i_CaL_K = (var_ICaL__Fx_ICaL_SL * var_ICaL_fCa_gate__fCa_SL + var_ICaL__Fx_ICaL_jct * var_ICaL_fCa_gate__fCa_jct) * (-var_ICaL__gamma_Ko * mParameters[5] + var_ICaL__gamma_Ki * mParameters[3] * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__PK * var_ICaL__temp / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
            const double var_ICaL__i_CaL = var_ICaL__i_CaL_Ca_SL + var_ICaL__i_CaL_Ca_jct + var_ICaL__i_CaL_K + var_ICaL__i_CaL_Na_SL + var_ICaL__i_CaL_Na_jct; // microA_per_microF
            const double var_ICap__i_Cap = var_ICap__i_Cap_SL + var_ICap__i_Cap_jct; // microA_per_microF
            const double var_IKs__E_Ks = var_model_parameters__R * var_model_parameters__T * log((var_IKs__pKNa * mParameters[6] + mParameters[5]) / (var_IKs__pKNa * var_chaste_interface__Na_buffer__Nai + mParameters[3])) / var_model_parameters__F; // millivolt
            const double var_IKs__i_Ks_SL = pow(var_chaste_interface__IKs_Xs_gate__Xs, 2) * (-var_IKs__E_Ks + var_chaste_interface__cell__V) * var_IKs__Fx_Ks_SL * var_IKs__G_Ks_SL; // microA_per_microF
            const double var_IKs__i_Ks_jct = pow(var_chaste_interface__IKs_Xs_gate__Xs, 2) * (-var_IKs__E_Ks + var_chaste_interface__cell__V) * var_IKs__Fx_Ks_jct * var_IKs__G_Ks_jct; // microA_per_microF
            const double var_IKs__i_Ks = var_IKs__i_Ks_SL + var_IKs__i_Ks_jct; // microA_per_microF
            const double var_INaCa__i_NaCa = var_INaCa__i_NaCa_SL + var_INaCa__i_NaCa_jct; // microA_per_microF
            const double var_INaK__i_NaK = var_INaK__i_NaK_SL + var_INaK__i_NaK_jct; // microA_per_microF
            const double var_ICab__i_Cab = var_ICab__i_Cab_SL + var_ICab__i_Cab_jct; // microA_per_microF
            const double var_reversal_potentials__E_Cl = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Cli / var_model_parameters__Clo) / var_model_parameters__F; // millivolt
            const double var_ICl_Ca__i_Cl_Ca = (-var_reversal_potentials__E_Cl + var_chaste_interface__cell__V) * (var_ICl_Ca__Fx_Cl_SL / (1.0 + var_ICl_Ca__Kd_ClCa / var_chaste_interface__Ca_buffer__Ca_SL) + var_ICl_Ca__Fx_Cl_jct / (1.0 + var_ICl_Ca__Kd_ClCa / var_chaste_interface__Ca_buffer__Ca_jct)) * var_ICl_Ca__G_Cl; // microA_per_microF
            const double var_IClb__i_Clb = (-var_reversal_potentials__E_Cl + var_chaste_interface__cell__V) * var_IClb__G_ClBk; // microA_per_microF
            const double var_reversal_potentials__E_K = var_model_parameters__R * var_model_parameters__T * log(mParameters[5] / mParameters[3]) / var_model_parameters__F; // millivolt
            const double var_IK1_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__E_K)); // per_millisecond
            const double var_IK1_K1_gate__beta_K1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__E_K) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__E_K)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__E_K - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_millisecond
            const double var_IK1_K1_gate__K1_infinity = var_IK1_K1_gate__alpha_K1 / (var_IK1_K1_gate__alpha_K1 + var_IK1_K1_gate__beta_K1); // dimensionless
            const double var_IK1__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IK1__G_K1 * var_IK1_K1_gate__K1_infinity; // microA_per_microF
            const double var_IKp__i_Kp = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IKp__g_Kp / (1.0 + exp(7.4880000000000004 - 0.16722408026755853 * var_chaste_interface__cell__V)); // microA_per_microF
            const double var_IKr__i_Kr = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IKr__G_IKr * var_IKr_Rr_gate__Rr * var_chaste_interface__IKr_Xr_gate__Xr; // microA_per_microF
            const double var_Itof__i_tof = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_Itof__G_tof * var_chaste_interface__Itof_X_gate__X_tof * var_chaste_interface__Itof_Y_gate__Y_tof; // microA_per_microF
            const double var_Itos__i_tos = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * (0.5 * var_chaste_interface__Itos_R_gate__R_tos + var_chaste_interface__Itos_Y_gate__Y_tos) * mParameters[12] * var_chaste_interface__Itos_X_gate__X_tos; // microA_per_microF
            const double var_INa__i_Na = var_INa__i_Na_SL + var_INa__i_Na_jct; // microA_per_microF
            const double var_INab__i_Nab = var_INab__i_Nab_SL + var_INab__i_Nab_jct; // microA_per_microF
            d_dt_chaste_interface_var_cell__V = -var_ICaL__i_CaL - var_ICab__i_Cab - var_ICap__i_Cap - var_ICl_Ca__i_Cl_Ca - var_IClb__i_Clb - var_IK1__i_K1 - var_IKp__i_Kp - var_IKr__i_Kr - var_IKs__i_Ks - var_INa__i_Na - var_INaCa__i_NaCa - var_INaK__i_NaK - var_INab__i_Nab - var_Itof__i_tof - var_Itos__i_tos - var_cell__i_Stim; // millivolt / millisecond
        }
        
        mEvalF[0] = d_dt_chaste_interface_var_cell__V;
        mEvalF[1] = d_dt_chaste_interface_var_Ca_buffer__Cai;
        mEvalF[2] = d_dt_chaste_interface_var_INa_h_gate__h;
        mEvalF[3] = d_dt_chaste_interface_var_INa_j_gate__j;
        mEvalF[4] = d_dt_chaste_interface_var_INa_m_gate__m;
        mEvalF[5] = d_dt_chaste_interface_var_IKr_Xr_gate__Xr;
        mEvalF[6] = d_dt_chaste_interface_var_IKs_Xs_gate__Xs;
        mEvalF[7] = d_dt_chaste_interface_var_Itos_X_gate__X_tos;
        mEvalF[8] = d_dt_chaste_interface_var_Itos_Y_gate__Y_tos;
        mEvalF[9] = d_dt_chaste_interface_var_Itos_R_gate__R_tos;
        mEvalF[10] = d_dt_chaste_interface_var_Itof_X_gate__X_tof;
        mEvalF[11] = d_dt_chaste_interface_var_Itof_Y_gate__Y_tof;
        mEvalF[12] = d_dt_chaste_interface_var_ICaL_d_gate__d;
        mEvalF[13] = d_dt_chaste_interface_var_ICaL_f_gate__f;
        mEvalF[14] = d_dt_chaste_interface_var_ICaL_fCa_gate__fCaB_SL;
        mEvalF[15] = d_dt_chaste_interface_var_ICaL_fCa_gate__fCaB_jct;
        mEvalF[16] = d_dt_chaste_interface_var_Jrel_SR__R;
        mEvalF[17] = d_dt_chaste_interface_var_Jrel_SR__I;
        mEvalF[18] = d_dt_chaste_interface_var_Jrel_SR__O;
        mEvalF[19] = d_dt_chaste_interface_var_Na_buffer__Na_SL;
        mEvalF[20] = d_dt_chaste_interface_var_Na_buffer__Na_jct;
        mEvalF[21] = d_dt_chaste_interface_var_Na_buffer__Na_SL_buf;
        mEvalF[22] = d_dt_chaste_interface_var_Na_buffer__Na_jct_buf;
        mEvalF[23] = d_dt_chaste_interface_var_Na_buffer__Nai;
        mEvalF[24] = d_dt_chaste_interface_var_Ca_buffer__Ca_SR;
        mEvalF[25] = d_dt_chaste_interface_var_Ca_buffer__Ca_SL;
        mEvalF[26] = d_dt_chaste_interface_var_Ca_buffer__Ca_jct;
        mEvalF[27] = d_dt_chaste_interface_var_Ca_buffer__Ca_SLB_SL;
        mEvalF[28] = d_dt_chaste_interface_var_Ca_buffer__Ca_SLB_jct;
        mEvalF[29] = d_dt_chaste_interface_var_Ca_buffer__Ca_SLHigh_SL;
        mEvalF[30] = d_dt_chaste_interface_var_Ca_buffer__Ca_SLHigh_jct;
        mEvalF[31] = d_dt_chaste_interface_var_Ca_buffer__Ca_Calsequestrin;
        mEvalF[32] = d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_TroponinC;
        mEvalF[33] = d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg;
        mEvalF[34] = d_dt_chaste_interface_var_cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg;
        mEvalF[35] = d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_Calmodulin;
        mEvalF[36] = d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_Myosin;
        mEvalF[37] = d_dt_chaste_interface_var_cytosolic_Ca_buffer__Mg_Myosin;
        mEvalF[38] = d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_SRB;

        
        mPartialF[0] = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time, rY, delta);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time, rY, delta);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time, rY, delta);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time, rY, delta);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time, rY, delta);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time, rY, delta);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time, rY, delta);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time, rY, delta);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time, rY, delta);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time, rY, delta);
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__environment__time, rY, delta);
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__environment__time, rY, delta);
        mPartialF[29] = EvaluatePartialDerivative29(var_chaste_interface__environment__time, rY, delta);
        mPartialF[30] = EvaluatePartialDerivative30(var_chaste_interface__environment__time, rY, delta);
        mPartialF[31] = EvaluatePartialDerivative31(var_chaste_interface__environment__time, rY, delta);
        mPartialF[32] = EvaluatePartialDerivative32(var_chaste_interface__environment__time, rY, delta);
        mPartialF[33] = EvaluatePartialDerivative33(var_chaste_interface__environment__time, rY, delta);
        mPartialF[34] = EvaluatePartialDerivative34(var_chaste_interface__environment__time, rY, delta);
        mPartialF[35] = EvaluatePartialDerivative35(var_chaste_interface__environment__time, rY, delta);
        mPartialF[36] = EvaluatePartialDerivative36(var_chaste_interface__environment__time, rY, delta);
        mPartialF[37] = EvaluatePartialDerivative37(var_chaste_interface__environment__time, rY, delta);
        mPartialF[38] = EvaluatePartialDerivative38(var_chaste_interface__environment__time, rY, delta);
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + 0.5*mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*0.5*mDt)-1.0);
            }
            
        }
        
        
        y_save = rY[1];
        rY[1] = mYInit[1];
        mEvalF[1] = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        rY[1] = y_save;
        
        
        y_save = rY[2];
        rY[2] = mYInit[2];
        mEvalF[2] = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        rY[2] = y_save;
        
        
        y_save = rY[3];
        rY[3] = mYInit[3];
        mEvalF[3] = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        rY[3] = y_save;
        
        
        y_save = rY[4];
        rY[4] = mYInit[4];
        mEvalF[4] = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        rY[4] = y_save;
        
        
        y_save = rY[5];
        rY[5] = mYInit[5];
        mEvalF[5] = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        rY[5] = y_save;
        
        
        y_save = rY[6];
        rY[6] = mYInit[6];
        mEvalF[6] = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        rY[6] = y_save;
        
        
        y_save = rY[7];
        rY[7] = mYInit[7];
        mEvalF[7] = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        rY[7] = y_save;
        
        
        y_save = rY[8];
        rY[8] = mYInit[8];
        mEvalF[8] = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        rY[8] = y_save;
        
        
        y_save = rY[9];
        rY[9] = mYInit[9];
        mEvalF[9] = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        rY[9] = y_save;
        
        
        y_save = rY[10];
        rY[10] = mYInit[10];
        mEvalF[10] = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        rY[10] = y_save;
        
        
        y_save = rY[11];
        rY[11] = mYInit[11];
        mEvalF[11] = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        rY[11] = y_save;
        
        
        y_save = rY[12];
        rY[12] = mYInit[12];
        mEvalF[12] = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        rY[12] = y_save;
        
        
        y_save = rY[13];
        rY[13] = mYInit[13];
        mEvalF[13] = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        rY[13] = y_save;
        
        
        y_save = rY[14];
        rY[14] = mYInit[14];
        mEvalF[14] = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        rY[14] = y_save;
        
        
        y_save = rY[15];
        rY[15] = mYInit[15];
        mEvalF[15] = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        rY[15] = y_save;
        
        
        y_save = rY[16];
        rY[16] = mYInit[16];
        mEvalF[16] = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        rY[16] = y_save;
        
        
        y_save = rY[17];
        rY[17] = mYInit[17];
        mEvalF[17] = EvaluateYDerivative17(var_chaste_interface__environment__time, rY);
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time, rY, delta);
        rY[17] = y_save;
        
        
        y_save = rY[18];
        rY[18] = mYInit[18];
        mEvalF[18] = EvaluateYDerivative18(var_chaste_interface__environment__time, rY);
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time, rY, delta);
        rY[18] = y_save;
        
        
        y_save = rY[19];
        rY[19] = mYInit[19];
        mEvalF[19] = EvaluateYDerivative19(var_chaste_interface__environment__time, rY);
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time, rY, delta);
        rY[19] = y_save;
        
        
        y_save = rY[20];
        rY[20] = mYInit[20];
        mEvalF[20] = EvaluateYDerivative20(var_chaste_interface__environment__time, rY);
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time, rY, delta);
        rY[20] = y_save;
        
        
        y_save = rY[21];
        rY[21] = mYInit[21];
        mEvalF[21] = EvaluateYDerivative21(var_chaste_interface__environment__time, rY);
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time, rY, delta);
        rY[21] = y_save;
        
        
        y_save = rY[22];
        rY[22] = mYInit[22];
        mEvalF[22] = EvaluateYDerivative22(var_chaste_interface__environment__time, rY);
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time, rY, delta);
        rY[22] = y_save;
        
        
        y_save = rY[23];
        rY[23] = mYInit[23];
        mEvalF[23] = EvaluateYDerivative23(var_chaste_interface__environment__time, rY);
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time, rY, delta);
        rY[23] = y_save;
        
        
        y_save = rY[24];
        rY[24] = mYInit[24];
        mEvalF[24] = EvaluateYDerivative24(var_chaste_interface__environment__time, rY);
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time, rY, delta);
        rY[24] = y_save;
        
        
        y_save = rY[25];
        rY[25] = mYInit[25];
        mEvalF[25] = EvaluateYDerivative25(var_chaste_interface__environment__time, rY);
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time, rY, delta);
        rY[25] = y_save;
        
        
        y_save = rY[26];
        rY[26] = mYInit[26];
        mEvalF[26] = EvaluateYDerivative26(var_chaste_interface__environment__time, rY);
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time, rY, delta);
        rY[26] = y_save;
        
        
        y_save = rY[27];
        rY[27] = mYInit[27];
        mEvalF[27] = EvaluateYDerivative27(var_chaste_interface__environment__time, rY);
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__environment__time, rY, delta);
        rY[27] = y_save;
        
        
        y_save = rY[28];
        rY[28] = mYInit[28];
        mEvalF[28] = EvaluateYDerivative28(var_chaste_interface__environment__time, rY);
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__environment__time, rY, delta);
        rY[28] = y_save;
        
        
        y_save = rY[29];
        rY[29] = mYInit[29];
        mEvalF[29] = EvaluateYDerivative29(var_chaste_interface__environment__time, rY);
        mPartialF[29] = EvaluatePartialDerivative29(var_chaste_interface__environment__time, rY, delta);
        rY[29] = y_save;
        
        
        y_save = rY[30];
        rY[30] = mYInit[30];
        mEvalF[30] = EvaluateYDerivative30(var_chaste_interface__environment__time, rY);
        mPartialF[30] = EvaluatePartialDerivative30(var_chaste_interface__environment__time, rY, delta);
        rY[30] = y_save;
        
        
        y_save = rY[31];
        rY[31] = mYInit[31];
        mEvalF[31] = EvaluateYDerivative31(var_chaste_interface__environment__time, rY);
        mPartialF[31] = EvaluatePartialDerivative31(var_chaste_interface__environment__time, rY, delta);
        rY[31] = y_save;
        
        
        y_save = rY[32];
        rY[32] = mYInit[32];
        mEvalF[32] = EvaluateYDerivative32(var_chaste_interface__environment__time, rY);
        mPartialF[32] = EvaluatePartialDerivative32(var_chaste_interface__environment__time, rY, delta);
        rY[32] = y_save;
        
        
        y_save = rY[33];
        rY[33] = mYInit[33];
        mEvalF[33] = EvaluateYDerivative33(var_chaste_interface__environment__time, rY);
        mPartialF[33] = EvaluatePartialDerivative33(var_chaste_interface__environment__time, rY, delta);
        rY[33] = y_save;
        
        
        y_save = rY[34];
        rY[34] = mYInit[34];
        mEvalF[34] = EvaluateYDerivative34(var_chaste_interface__environment__time, rY);
        mPartialF[34] = EvaluatePartialDerivative34(var_chaste_interface__environment__time, rY, delta);
        rY[34] = y_save;
        
        
        y_save = rY[35];
        rY[35] = mYInit[35];
        mEvalF[35] = EvaluateYDerivative35(var_chaste_interface__environment__time, rY);
        mPartialF[35] = EvaluatePartialDerivative35(var_chaste_interface__environment__time, rY, delta);
        rY[35] = y_save;
        
        
        y_save = rY[36];
        rY[36] = mYInit[36];
        mEvalF[36] = EvaluateYDerivative36(var_chaste_interface__environment__time, rY);
        mPartialF[36] = EvaluatePartialDerivative36(var_chaste_interface__environment__time, rY, delta);
        rY[36] = y_save;
        
        
        y_save = rY[37];
        rY[37] = mYInit[37];
        mEvalF[37] = EvaluateYDerivative37(var_chaste_interface__environment__time, rY);
        mPartialF[37] = EvaluatePartialDerivative37(var_chaste_interface__environment__time, rY, delta);
        rY[37] = y_save;
        
        
        y_save = rY[38];
        rY[38] = mYInit[38];
        mEvalF[38] = EvaluateYDerivative38(var_chaste_interface__environment__time, rY);
        mPartialF[38] = EvaluatePartialDerivative38(var_chaste_interface__environment__time, rY, delta);
        rY[38] = y_save;
                
        for (unsigned var=0; var<size; var++)
        {
            if (var == 0) continue;
            if (fabs(mPartialF[var]) < delta)
            {
                rY[var] = mYInit[var] + mDt*mEvalF[var];
            }
            else
            {
                rY[var] = mYInit[var] + (mEvalF[var]/mPartialF[var])*(exp(mPartialF[var]*mDt)-1.0);
            }
            
        }


    }
   
    
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_cell__V;
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__INa_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.9867005
        double var_chaste_interface__INa_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.991562
        double var_chaste_interface__INa_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.001405627
        double var_chaste_interface__IKr_Xr_gate__Xr = rY[5];
        // Units: dimensionless; Initial value: 0.008641386
        double var_chaste_interface__IKs_Xs_gate__Xs = rY[6];
        // Units: dimensionless; Initial value: 0.005412034
        double var_chaste_interface__Itos_X_gate__X_tos = rY[7];
        // Units: dimensionless; Initial value: 0.004051574
        double var_chaste_interface__Itos_Y_gate__Y_tos = rY[8];
        // Units: dimensionless; Initial value: 0.9945511
        double var_chaste_interface__Itos_R_gate__R_tos = rY[9];
        // Units: dimensionless; Initial value: 0.9946
        double var_chaste_interface__Itof_X_gate__X_tof = rY[10];
        // Units: dimensionless; Initial value: 0.004051574
        double var_chaste_interface__Itof_Y_gate__Y_tof = rY[11];
        // Units: dimensionless; Initial value: 0.9945511
        double var_chaste_interface__ICaL_d_gate__d = rY[12];
        // Units: dimensionless; Initial value: 7.175662e-06
        double var_chaste_interface__ICaL_f_gate__f = rY[13];
        // Units: dimensionless; Initial value: 1.000681
        double var_chaste_interface__ICaL_fCa_gate__fCaB_SL = rY[14];
        // Units: dimensionless; Initial value: 0.01452605
        double var_chaste_interface__ICaL_fCa_gate__fCaB_jct = rY[15];
        // Units: dimensionless; Initial value: 0.02421991
        double var_chaste_interface__Na_buffer__Na_SL = rY[19];
        // Units: millimolar; Initial value: 8.80733
        double var_chaste_interface__Na_buffer__Na_jct = rY[20];
        // Units: millimolar; Initial value: 8.80329
        double var_chaste_interface__Na_buffer__Nai = rY[23];
        // Units: millimolar; Initial value: 8.80853
        double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
        // Units: millimolar; Initial value: 0.0001031812
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        
        
        // Mathematics
        const double var_ICaL__Fx_ICaL_SL = 0.10000000000000001; // dimensionless
        const double var_ICaL__Fx_ICaL_jct = 0.90000000000000002; // dimensionless
        const double var_ICaL__PK = 2.7000000000000001e-7; // litre_per_farad_millisecond
        const double var_ICaL__PNa = 1.4999999999999999e-8; // litre_per_farad_millisecond
        const double var_ICaL__Q10_CaL = 1.8; // dimensionless
        const double var_ICaL__gamma_Cai = 0.34100000000000003; // dimensionless
        const double var_ICaL__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_ICaL__gamma_Ki = 0.75; // dimensionless
        const double var_ICaL__gamma_Ko = 0.75; // dimensionless
        const double var_ICaL__gamma_Nai = 0.75; // dimensionless
        const double var_ICaL__gamma_Nao = 0.75; // dimensionless
        const double var_ICaL_fCa_gate__fCa_SL = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_SL; // dimensionless
        const double var_ICaL_fCa_gate__fCa_jct = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_jct; // dimensionless
        const double var_ICab__Fx_CaBk_SL = 0.89000000000000001; // dimensionless
        const double var_ICab__Fx_CaBk_jct = 0.11; // dimensionless
        const double var_ICab__G_CaBk = 0.00025129999999999998; // milliS_per_microF
        const double var_ICap__Fx_SLCaP_SL = 0.89000000000000001; // dimensionless
        const double var_ICap__Fx_SLCaP_jct = 0.11; // dimensionless
        const double var_ICap__H = 1.6000000000000001; // dimensionless
        const double var_ICap__Km = 0.00050000000000000001; // millimolar
        const double var_ICap__Q10_SLCaP = 2.3500000000000001; // dimensionless
        const double var_ICap__V_maxAF = 0.067299999999999999; // microA_per_microF
        const double var_ICl_Ca__Fx_Cl_SL = 0.89000000000000001; // dimensionless
        const double var_ICl_Ca__Fx_Cl_jct = 0.11; // dimensionless
        const double var_ICl_Ca__G_Cl = 0.109625; // milliS_per_microF
        const double var_ICl_Ca__Kd_ClCa = 0.10000000000000001; // millimolar
        const double var_IClb__G_ClBk = 0.0089999999999999993; // milliS_per_microF
        const double var_IKp__g_Kp = 0.001; // milliS_per_microF
        const double var_IKs__Fx_Ks_SL = 0.89000000000000001; // dimensionless
        const double var_IKs__Fx_Ks_jct = 0.11; // dimensionless
        const double var_IKs__pCa_SL = 3.0 - log10(var_chaste_interface__Ca_buffer__Ca_SL); // dimensionless
        const double var_IKs__G_Ks_SL = (0.057000000000000002 + 0.19 / (1.0 + exp(-12.0 + 1.6666666666666667 * var_IKs__pCa_SL))) * mParameters[10]; // milliS_per_microF
        const double var_IKs__pCa_jct = 3.0 - log10(var_chaste_interface__Ca_buffer__Ca_jct); // dimensionless
        const double var_IKs__G_Ks_jct = (0.057000000000000002 + 0.19 / (1.0 + exp(-12.0 + 1.6666666666666667 * var_IKs__pCa_jct))) * mParameters[10]; // milliS_per_microF
        const double var_IKs__pKNa = 0.018329999999999999; // dimensionless
        const double var_INa__Fx_Na_SL = 0.89000000000000001; // dimensionless
        const double var_INa__Fx_Na_jct = 0.11; // dimensionless
        const double var_INaCa__Fx_NCX_SL = 0.89000000000000001; // dimensionless
        const double var_INaCa__Fx_NCX_jct = 0.11; // dimensionless
        const double var_INaCa__HNa = 3.0; // dimensionless
        const double var_INaCa__K_mCai = 0.0035899999999999999; // millimolar
        const double var_INaCa__K_mCao = 1.3; // millimolar
        const double var_INaCa__K_mNai = 12.289999999999999; // millimolar
        const double var_INaCa__K_mNao = 87.5; // millimolar
        const double var_INaCa__Kd_act = 0.00025599999999999999; // millimolar
        const double var_INaCa__Ka_SL = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_SL, 3)); // dimensionless
        const double var_INaCa__Ka_jct = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_jct, 3)); // dimensionless
        const double var_INaCa__Q10_NCX = 1.5700000000000001; // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_INaK__Fx_NaK_SL = 0.89000000000000001; // dimensionless
        const double var_INaK__Fx_NaK_jct = 0.11; // dimensionless
        const double var_INaK__H_NaK = 4.0; // dimensionless
        const double var_INaK__I_NaK_max = 1.9071899999999999; // microA_per_microF
        const double var_INaK__Km_Ko = 1.5; // millimolar
        const double var_INaK__Km_Nai = 11.0; // millimolar
        const double var_INa__openProb = pow(var_chaste_interface__INa_m_gate__m, 3) * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // dimensionless
        const double var_INab__Fx_NaBk_SL = 0.89000000000000001; // dimensionless
        const double var_INab__Fx_NaBk_jct = 0.11; // dimensionless
        const double var_INab__G_NaBk = 0.00029700000000000001; // milliS_per_microF
        const double var_Itof__G_tof = 0.02; // milliS_per_microF
        const double var_IKr_Rr_gate__Rr = 1 / (1.0 + exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V)); // dimensionless
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_cell__i_Stim = var_cell__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // microA_per_microF
        const double var_model_parameters__Cli = 15.0; // millimolar
        const double var_model_parameters__Clo = 150.0; // millimolar
        const double var_model_parameters__F = 96485.0; // coulomb_per_mole
        const double var_IK1__G_K1 = 0.3872983346207417 * sqrt(mParameters[5]); // milliS_per_microF
        const double var_IKr__G_IKr = 0.43033148291193518 * sqrt(mParameters[5]) * mParameters[9]; // milliS_per_microF
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * mParameters[6]); // dimensionless
        const double var_model_parameters__R = 8314.2999999999993; // joule_per_kilomole_kelvin
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__Q_CaL = pow(var_ICaL__Q10_CaL, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICaL__temp = 0.45000000000000001 * pow(var_model_parameters__F, 2) * var_ICaL__Q_CaL * var_chaste_interface__ICaL_d_gate__d * var_chaste_interface__ICaL_f_gate__f * var_chaste_interface__cell__V / (var_model_parameters__R * var_model_parameters__T); // coulomb_per_mole
        const double var_ICaL__i_CaL_Ca_SL = 4.0 * (-var_ICaL__gamma_Cao * mParameters[4] + var_chaste_interface__Ca_buffer__Ca_SL * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_SL * mParameters[7] * var_ICaL__temp * var_ICaL_fCa_gate__fCa_SL / (-1.0 + exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Ca_jct = 4.0 * (-var_ICaL__gamma_Cao * mParameters[4] + var_chaste_interface__Ca_buffer__Ca_jct * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_jct * mParameters[7] * var_ICaL__temp * var_ICaL_fCa_gate__fCa_jct / (-1.0 + exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_K = (var_ICaL__Fx_ICaL_SL * var_ICaL_fCa_gate__fCa_SL + var_ICaL__Fx_ICaL_jct * var_ICaL_fCa_gate__fCa_jct) * (-var_ICaL__gamma_Ko * mParameters[5] + var_ICaL__gamma_Ki * mParameters[3] * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__PK * var_ICaL__temp / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Na_SL = (-var_ICaL__gamma_Nao * mParameters[6] + var_ICaL__gamma_Nai * var_chaste_interface__Na_buffer__Na_SL * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_SL * var_ICaL__PNa * var_ICaL__temp * var_ICaL_fCa_gate__fCa_SL / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Na_jct = (-var_ICaL__gamma_Nao * mParameters[6] + var_ICaL__gamma_Nai * var_chaste_interface__Na_buffer__Na_jct * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_jct * var_ICaL__PNa * var_ICaL__temp * var_ICaL_fCa_gate__fCa_jct / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL = var_ICaL__i_CaL_Ca_SL + var_ICaL__i_CaL_Ca_jct + var_ICaL__i_CaL_K + var_ICaL__i_CaL_Na_SL + var_ICaL__i_CaL_Na_jct; // microA_per_microF
        const double var_ICap__Q_SLCaP = pow(var_ICap__Q10_SLCaP, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICap__i_Cap_SL = var_ICap__Fx_SLCaP_SL * var_ICap__Q_SLCaP * var_ICap__V_maxAF / (1.0 + pow((var_ICap__Km / var_chaste_interface__Ca_buffer__Ca_SL), var_ICap__H)); // microA_per_microF
        const double var_ICap__i_Cap_jct = var_ICap__Fx_SLCaP_jct * var_ICap__Q_SLCaP * var_ICap__V_maxAF / (1.0 + pow((var_ICap__Km / var_chaste_interface__Ca_buffer__Ca_jct), var_ICap__H)); // microA_per_microF
        const double var_ICap__i_Cap = var_ICap__i_Cap_SL + var_ICap__i_Cap_jct; // microA_per_microF
        const double var_IKs__E_Ks = var_model_parameters__R * var_model_parameters__T * log((var_IKs__pKNa * mParameters[6] + mParameters[5]) / (var_IKs__pKNa * var_chaste_interface__Na_buffer__Nai + mParameters[3])) / var_model_parameters__F; // millivolt
        const double var_IKs__i_Ks_SL = pow(var_chaste_interface__IKs_Xs_gate__Xs, 2) * (-var_IKs__E_Ks + var_chaste_interface__cell__V) * var_IKs__Fx_Ks_SL * var_IKs__G_Ks_SL; // microA_per_microF
        const double var_IKs__i_Ks_jct = pow(var_chaste_interface__IKs_Xs_gate__Xs, 2) * (-var_IKs__E_Ks + var_chaste_interface__cell__V) * var_IKs__Fx_Ks_jct * var_IKs__G_Ks_jct; // microA_per_microF
        const double var_IKs__i_Ks = var_IKs__i_Ks_SL + var_IKs__i_Ks_jct; // microA_per_microF
        const double var_INaCa__Q_NCX = pow(var_INaCa__Q10_NCX, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_INaCa__temp_SL = (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_SL = var_INaCa__Fx_NCX_SL * var_INaCa__Ka_SL * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_SL / (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_SL / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_SL + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_SL / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_INaCa__temp_jct = (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_jct = var_INaCa__Fx_NCX_jct * var_INaCa__Ka_jct * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_jct / (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_jct / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_jct + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_jct / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_INaCa__i_NaCa = var_INaCa__i_NaCa_SL + var_INaCa__i_NaCa_jct; // microA_per_microF
        const double var_INaK__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) + 0.036499999999999998 * var_INaK__sigma * exp(-var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // dimensionless
        const double var_INaK__i_NaK_SL = var_INaK__Fx_NaK_SL * var_INaK__I_NaK_max * var_INaK__f_NaK * mParameters[5] / ((1.0 + pow((var_INaK__Km_Nai / var_chaste_interface__Na_buffer__Na_SL), var_INaK__H_NaK)) * (var_INaK__Km_Ko + mParameters[5])); // microA_per_microF
        const double var_INaK__i_NaK_jct = var_INaK__Fx_NaK_jct * var_INaK__I_NaK_max * var_INaK__f_NaK * mParameters[5] / ((1.0 + pow((var_INaK__Km_Nai / var_chaste_interface__Na_buffer__Na_jct), var_INaK__H_NaK)) * (var_INaK__Km_Ko + mParameters[5])); // microA_per_microF
        const double var_INaK__i_NaK = var_INaK__i_NaK_SL + var_INaK__i_NaK_jct; // microA_per_microF
        const double var_reversal_potentials__E_Ca_SL = 0.5 * var_model_parameters__R * var_model_parameters__T * log(mParameters[4] / var_chaste_interface__Ca_buffer__Ca_SL) / var_model_parameters__F; // millivolt
        const double var_ICab__i_Cab_SL = (-var_reversal_potentials__E_Ca_SL + var_chaste_interface__cell__V) * var_ICab__Fx_CaBk_SL * var_ICab__G_CaBk; // microA_per_microF
        const double var_reversal_potentials__E_Ca_jct = 0.5 * var_model_parameters__R * var_model_parameters__T * log(mParameters[4] / var_chaste_interface__Ca_buffer__Ca_jct) / var_model_parameters__F; // millivolt
        const double var_ICab__i_Cab_jct = (-var_reversal_potentials__E_Ca_jct + var_chaste_interface__cell__V) * var_ICab__Fx_CaBk_jct * var_ICab__G_CaBk; // microA_per_microF
        const double var_ICab__i_Cab = var_ICab__i_Cab_SL + var_ICab__i_Cab_jct; // microA_per_microF
        const double var_reversal_potentials__E_Cl = var_model_parameters__R * var_model_parameters__T * log(var_model_parameters__Cli / var_model_parameters__Clo) / var_model_parameters__F; // millivolt
        const double var_ICl_Ca__i_Cl_Ca = (-var_reversal_potentials__E_Cl + var_chaste_interface__cell__V) * (var_ICl_Ca__Fx_Cl_SL / (1.0 + var_ICl_Ca__Kd_ClCa / var_chaste_interface__Ca_buffer__Ca_SL) + var_ICl_Ca__Fx_Cl_jct / (1.0 + var_ICl_Ca__Kd_ClCa / var_chaste_interface__Ca_buffer__Ca_jct)) * var_ICl_Ca__G_Cl; // microA_per_microF
        const double var_IClb__i_Clb = (-var_reversal_potentials__E_Cl + var_chaste_interface__cell__V) * var_IClb__G_ClBk; // microA_per_microF
        const double var_reversal_potentials__E_K = var_model_parameters__R * var_model_parameters__T * log(mParameters[5] / mParameters[3]) / var_model_parameters__F; // millivolt
        const double var_IK1_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__E_K)); // per_millisecond
        const double var_IK1_K1_gate__beta_K1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__E_K) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__E_K)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__E_K - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_millisecond
        const double var_IK1_K1_gate__K1_infinity = var_IK1_K1_gate__alpha_K1 / (var_IK1_K1_gate__alpha_K1 + var_IK1_K1_gate__beta_K1); // dimensionless
        const double var_IK1__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IK1__G_K1 * var_IK1_K1_gate__K1_infinity; // microA_per_microF
        const double var_IKp__i_Kp = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IKp__g_Kp / (1.0 + exp(7.4880000000000004 - 0.16722408026755853 * var_chaste_interface__cell__V)); // microA_per_microF
        const double var_IKr__i_Kr = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IKr__G_IKr * var_IKr_Rr_gate__Rr * var_chaste_interface__IKr_Xr_gate__Xr; // microA_per_microF
        const double var_Itof__i_tof = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_Itof__G_tof * var_chaste_interface__Itof_X_gate__X_tof * var_chaste_interface__Itof_Y_gate__Y_tof; // microA_per_microF
        const double var_Itos__i_tos = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * (0.5 * var_chaste_interface__Itos_R_gate__R_tos + var_chaste_interface__Itos_Y_gate__Y_tos) * mParameters[12] * var_chaste_interface__Itos_X_gate__X_tos; // microA_per_microF
        const double var_reversal_potentials__E_Na_SL = var_model_parameters__R * var_model_parameters__T * log(mParameters[6] / var_chaste_interface__Na_buffer__Na_SL) / var_model_parameters__F; // millivolt
        const double var_INa__i_Na_SL = (-var_reversal_potentials__E_Na_SL + var_chaste_interface__cell__V) * var_INa__Fx_Na_SL * mParameters[8] * var_INa__openProb; // microA_per_microF
        const double var_INab__i_Nab_SL = (-var_reversal_potentials__E_Na_SL + var_chaste_interface__cell__V) * var_INab__Fx_NaBk_SL * var_INab__G_NaBk; // microA_per_microF
        const double var_reversal_potentials__E_Na_jct = var_model_parameters__R * var_model_parameters__T * log(mParameters[6] / var_chaste_interface__Na_buffer__Na_jct) / var_model_parameters__F; // millivolt
        const double var_INa__i_Na_jct = (-var_reversal_potentials__E_Na_jct + var_chaste_interface__cell__V) * var_INa__Fx_Na_jct * mParameters[8] * var_INa__openProb; // microA_per_microF
        const double var_INa__i_Na = var_INa__i_Na_SL + var_INa__i_Na_jct; // microA_per_microF
        const double var_INab__i_Nab_jct = (-var_reversal_potentials__E_Na_jct + var_chaste_interface__cell__V) * var_INab__Fx_NaBk_jct * var_INab__G_NaBk; // microA_per_microF
        const double var_INab__i_Nab = var_INab__i_Nab_SL + var_INab__i_Nab_jct; // microA_per_microF
        d_dt_chaste_interface_var_cell__V = -var_ICaL__i_CaL - var_ICab__i_Cab - var_ICap__i_Cap - var_ICl_Ca__i_Cl_Ca - var_IClb__i_Clb - var_IK1__i_K1 - var_IKp__i_Kp - var_IKr__i_Kr - var_IKs__i_Ks - var_INa__i_Na - var_INaCa__i_NaCa - var_INaK__i_NaK - var_INab__i_Nab - var_Itof__i_tof - var_Itos__i_tos - var_cell__i_Stim; // millivolt / millisecond

        return d_dt_chaste_interface_var_cell__V;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            double var_chaste_interface__INa_h_gate__h = rY[2];
            // Units: dimensionless; Initial value: 0.9867005
            double var_chaste_interface__INa_j_gate__j = rY[3];
            // Units: dimensionless; Initial value: 0.991562
            double var_chaste_interface__INa_m_gate__m = rY[4];
            // Units: dimensionless; Initial value: 0.001405627
            double var_chaste_interface__IKr_Xr_gate__Xr = rY[5];
            // Units: dimensionless; Initial value: 0.008641386
            double var_chaste_interface__IKs_Xs_gate__Xs = rY[6];
            // Units: dimensionless; Initial value: 0.005412034
            double var_chaste_interface__Itos_X_gate__X_tos = rY[7];
            // Units: dimensionless; Initial value: 0.004051574
            double var_chaste_interface__Itos_Y_gate__Y_tos = rY[8];
            // Units: dimensionless; Initial value: 0.9945511
            double var_chaste_interface__Itos_R_gate__R_tos = rY[9];
            // Units: dimensionless; Initial value: 0.9946
            double var_chaste_interface__Itof_X_gate__X_tof = rY[10];
            // Units: dimensionless; Initial value: 0.004051574
            double var_chaste_interface__Itof_Y_gate__Y_tof = rY[11];
            // Units: dimensionless; Initial value: 0.9945511
            double var_chaste_interface__ICaL_d_gate__d = rY[12];
            // Units: dimensionless; Initial value: 7.175662e-06
            double var_chaste_interface__ICaL_f_gate__f = rY[13];
            // Units: dimensionless; Initial value: 1.000681
            double var_chaste_interface__ICaL_fCa_gate__fCaB_SL = rY[14];
            // Units: dimensionless; Initial value: 0.01452605
            double var_chaste_interface__ICaL_fCa_gate__fCaB_jct = rY[15];
            // Units: dimensionless; Initial value: 0.02421991
            double var_chaste_interface__Na_buffer__Na_SL = rY[19];
            // Units: millimolar; Initial value: 8.80733
            double var_chaste_interface__Na_buffer__Na_jct = rY[20];
            // Units: millimolar; Initial value: 8.80329
            double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
            // Units: millimolar; Initial value: 0.0001031812
            double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
            // Units: millimolar; Initial value: 0.0001737475
            
            const double var_x0 = exp(7.4880000000000004 - 0.16722408026755853 * var_chaste_interface__cell__V);
            const double var_x1 = 1.0 + var_x0;
            const double var_x2 = 1 / var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x3 = 1.0 + 0.10000000000000001 * var_x2;
            const double var_x4 = 1 / var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x5 = 1.0 + 0.10000000000000001 * var_x4;
            const double var_x6 = -var_chaste_interface__Itos_Y_gate__Y_tos;
            const double var_x7 = (var_x6 - 0.5 * var_chaste_interface__Itos_R_gate__R_tos) * mParameters[12];
            const double var_x8 = log(mParameters[5] / mParameters[3]);
            const double var_x9 = 26.713302585894176 * var_x8;
            const double var_x10 = -var_x9 + var_chaste_interface__cell__V;
            const double var_x11 = exp(-7.0000000000000009 - 1.6666666666666667 * log10(var_chaste_interface__Ca_buffer__Ca_jct));
            const double var_x12 = 1.0 + var_x11;
            const double var_x13 = 0.057000000000000002 + 0.19 / var_x12;
            const double var_x14 = pow(var_chaste_interface__IKs_Xs_gate__Xs, 2) * mParameters[10];
            const double var_x15 = var_x13 * var_x14;
            const double var_x16 = exp(-7.0000000000000009 - 1.6666666666666667 * log10(var_chaste_interface__Ca_buffer__Ca_SL));
            const double var_x17 = 1.0 + var_x16;
            const double var_x18 = 0.057000000000000002 + 0.19 / var_x17;
            const double var_x19 = var_x14 * var_x18;
            const double var_x20 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 6.3711226667357614 * var_x8);
            const double var_x21 = 1.0 + var_x20;
            const double var_x22 = 1 / var_x21;
            const double var_x23 = exp(-2.4444678999999998 + 13.738651519925375 * var_x8 - 0.51429999999999998 * var_chaste_interface__cell__V);
            const double var_x24 = 1.0 + var_x23;
            const double var_x25 = 1 / var_x24;
            const double var_x26 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 1.6495464346789654 * var_x8);
            const double var_x27 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 2.1456124636990204 * var_x8);
            const double var_x28 = var_x26 + 0.49124000000000001 * var_x27;
            const double var_x29 = var_x25 * var_x28;
            const double var_x30 = sqrt(mParameters[5]);
            const double var_x31 = var_x30 / (var_x29 + 1.02 * var_x22);
            const double var_x32 = var_x30 * mParameters[9] * var_chaste_interface__IKr_Xr_gate__Xr;
            const double var_x33 = exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V);
            const double var_x34 = 1.0 + var_x33;
            const double var_x35 = 0.43033148291193518 / var_x34;
            const double var_x36 = pow(var_chaste_interface__INa_m_gate__m, 3);
            const double var_x37 = var_x36 * mParameters[8] * var_chaste_interface__INa_j_gate__j;
            const double var_x38 = var_x37 * var_chaste_interface__INa_h_gate__h;
            const double var_x39 = var_x20 / pow(var_x21, 2);
            const double var_x40 = exp(0.013102086455787599 * var_chaste_interface__cell__V);
            const double var_x41 = pow(var_chaste_interface__Na_buffer__Na_jct, 3.0);
            const double var_x42 = var_x41 * mParameters[4];
            const double var_x43 = var_x40 * var_x42;
            const double var_x44 = exp(-0.024332446275034118 * var_chaste_interface__cell__V);
            const double var_x45 = pow(mParameters[6], 3.0);
            const double var_x46 = var_x45 * var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x47 = var_x44 * var_x46;
            const double var_x48 = 1.0 + 0.27000000000000002 * var_x44;
            const double var_x49 = mParameters[11] / var_x48;
            const double var_x50 = 1.0 + 1.6777215999999998e-11 / pow(var_chaste_interface__Ca_buffer__Ca_jct, 3);
            const double var_x51 = 1 / var_x50;
            const double var_x52 = (1.0 + 278.55153203342621 * var_chaste_interface__Ca_buffer__Ca_jct) * var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x53 = 1.0 + 0.00053869674493876331 * var_x41;
            const double var_x54 = 0.0035899999999999999 * var_x45;
            const double var_x55 = 1 / (var_x42 + var_x46 + 669921.875 * var_x52 + 1.3 * var_x41 + var_x53 * var_x54);
            const double var_x56 = var_x51 * var_x55;
            const double var_x57 = var_x49 * var_x56;
            const double var_x58 = var_x57 * (0.013102086455787599 * var_x43 + 0.024332446275034118 * var_x47);
            const double var_x59 = pow(var_chaste_interface__Na_buffer__Na_SL, 3.0);
            const double var_x60 = var_x59 * mParameters[4];
            const double var_x61 = var_x40 * var_x60;
            const double var_x62 = var_x45 * var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x63 = var_x44 * var_x62;
            const double var_x64 = 1.0 + 1.6777215999999998e-11 / pow(var_chaste_interface__Ca_buffer__Ca_SL, 3);
            const double var_x65 = 1 / var_x64;
            const double var_x66 = (1.0 + 278.55153203342621 * var_chaste_interface__Ca_buffer__Ca_SL) * var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x67 = 1.0 + 0.00053869674493876331 * var_x59;
            const double var_x68 = 1 / (var_x60 + var_x62 + 669921.875 * var_x66 + 1.3 * var_x59 + var_x54 * var_x67);
            const double var_x69 = var_x65 * var_x68;
            const double var_x70 = var_x49 * var_x69;
            const double var_x71 = var_x70 * (0.013102086455787599 * var_x61 + 0.024332446275034118 * var_x63);
            const double var_x72 = 1 / var_chaste_interface__Na_buffer__Na_jct;
            const double var_x73 = pow(var_x72, 4.0);
            const double var_x74 = exp(-0.0037434532730821718 * var_chaste_interface__cell__V);
            const double var_x75 = exp(0.01485884101040119 * mParameters[6]);
            const double var_x76 = 0.037434532730821715 * var_chaste_interface__cell__V;
            const double var_x77 = exp(-var_x76);
            const double var_x78 = 1.0 + 0.1245 * var_x74 + 0.036499999999999998 * var_x77 * (-0.14285714285714285 + 0.14285714285714285 * var_x75);
            const double var_x79 = mParameters[5] / (1.5 + mParameters[5]);
            const double var_x80 = var_x79 * (0.00046605993249873042 * var_x74 + 0.037434532730821715 * var_x77 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x75)) / pow(var_x78, 2);
            const double var_x81 = var_x80 / (1.0 + 14641.0 * var_x73);
            const double var_x82 = 1 / var_chaste_interface__Na_buffer__Na_SL;
            const double var_x83 = pow(var_x82, 4.0);
            const double var_x84 = var_x80 / (1.0 + 14641.0 * var_x83);
            const double var_x85 = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_jct;
            const double var_x86 = var_x85 * var_chaste_interface__ICaL_d_gate__d;
            const double var_x87 = -0.75 * mParameters[6];
            const double var_x88 = exp(var_x76);
            const double var_x89 = 0.75 * var_x88;
            const double var_x90 = var_x87 + var_x89 * var_chaste_interface__Na_buffer__Na_jct;
            const double var_x91 = -1.0 + var_x88;
            const double var_x92 = 1 / var_x91;
            const double var_x93 = var_x92 * var_chaste_interface__ICaL_f_gate__f;
            const double var_x94 = var_x90 * var_x93;
            const double var_x95 = 2.1942115659989999e-5 * var_x94;
            const double var_x96 = -0.75 * mParameters[5] + var_x89 * mParameters[3];
            const double var_x97 = var_x93 * var_chaste_interface__ICaL_d_gate__d;
            const double var_x98 = var_x96 * var_x97;
            const double var_x99 = 1.0 - 0.10000000000000001 * var_chaste_interface__ICaL_fCa_gate__fCaB_SL - 0.90000000000000002 * var_chaste_interface__ICaL_fCa_gate__fCaB_jct;
            const double var_x100 = 0.00043884231319980002 * var_x99;
            const double var_x101 = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_SL;
            const double var_x102 = var_x87 + var_x89 * var_chaste_interface__Na_buffer__Na_SL;
            const double var_x103 = var_x101 * var_x102;
            const double var_x104 = 2.4380128511099999e-6 * var_x103;
            const double var_x105 = var_x10 * var_x30;
            const double var_x106 = var_x43 - var_x47;
            const double var_x107 = var_x44 * mParameters[11] / pow(var_x48, 2);
            const double var_x108 = var_x106 * var_x107 * var_x56;
            const double var_x109 = exp(0.07486906546164343 * var_chaste_interface__cell__V);
            const double var_x110 = -1.0 + var_x109;
            const double var_x111 = mParameters[7] / var_x110;
            const double var_x112 = var_chaste_interface__ICaL_d_gate__d * var_chaste_interface__ICaL_f_gate__f;
            const double var_x113 = var_x111 * var_x112;
            const double var_x114 = -0.34100000000000003 * mParameters[4];
            const double var_x115 = 0.34100000000000003 * var_x109;
            const double var_x116 = var_x114 + var_x115 * var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x117 = var_x101 * var_x116;
            const double var_x118 = 650.13676029600003 * var_x117;
            const double var_x119 = var_x114 + var_x115 * var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x120 = 5851.2308426640002 * var_x119;
            const double var_x121 = var_x111 * var_chaste_interface__ICaL_f_gate__f;
            const double var_x122 = var_x121 * var_x86;
            const double var_x123 = var_x61 - var_x63;
            const double var_x124 = var_x107 * var_x123 * var_x69;
            const double var_x125 = var_x86 * var_x90;
            const double var_x126 = var_chaste_interface__ICaL_f_gate__f * var_chaste_interface__cell__V;
            const double var_x127 = var_x88 / pow(var_x91, 2);
            const double var_x128 = var_x125 * var_x126 * var_x127;
            const double var_x129 = var_x112 * var_chaste_interface__cell__V;
            const double var_x130 = var_x127 * var_x129;
            const double var_x131 = var_x103 * var_x130;
            const double var_x132 = var_x93 * var_chaste_interface__cell__V;
            const double var_x133 = var_x132 * var_x86 * var_x88;
            const double var_x134 = var_x133 * var_chaste_interface__Na_buffer__Na_jct;
            const double var_x135 = var_x97 * var_chaste_interface__cell__V;
            const double var_x136 = var_x135 * var_x88;
            const double var_x137 = var_x101 * var_x136;
            const double var_x138 = var_x137 * var_chaste_interface__Na_buffer__Na_SL;
            const double var_x139 = var_x109 * mParameters[7] / pow(var_x110, 2);
            const double var_x140 = var_x117 * var_x129 * var_x139;
            const double var_x141 = var_x119 * var_x126 * var_x139 * var_x86;
            const double var_x142 = var_x113 * var_chaste_interface__cell__V;
            const double var_x143 = var_x101 * var_x109 * var_x142;
            const double var_x144 = var_x143 * var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x145 = var_x109 * var_x122 * var_chaste_interface__cell__V;
            const double var_x146 = var_x145 * var_chaste_interface__Ca_buffer__Ca_jct;
            
            partialF = -0.0095482999999999991 + 8.2139284685737138e-7 * var_x128 + 48.675131665622011 * var_x140 + 9.1265871873041266e-8 * var_x131 + 438.07618499059811 * var_x141 - 0.001 / var_x1 - 0.11 * var_x15 - 0.11 * var_x58 - 0.89000000000000001 * var_x19 - 0.89000000000000001 * var_x71 - 1.0 * var_x38 - 6.1604463514302854e-7 * var_x134 - 0.01205875 / var_x3 - 0.2097909 * var_x81 - 1.6973990999999999 * var_x84 - 16.598219897977106 * var_x144 - 149.38397908179397 * var_x146 - 0.00072267365436851333 * var_x108 - 6.8449403904780953e-8 * var_x138 - 0.0058470868398906983 * var_x124 - 0.097566250000000007 / var_x5 + var_x7 * var_chaste_interface__Itos_X_gate__X_tos - var_x100 * var_x98 - var_x104 * var_x97 - var_x113 * var_x118 - var_x120 * var_x122 - var_x32 * var_x35 - var_x86 * var_x95 - 0.02 * var_chaste_interface__Itof_X_gate__X_tof * var_chaste_interface__Itof_Y_gate__Y_tof - 0.39504430131315654 * var_x22 * var_x31 + 0.09421806586318783 * var_x10 * var_x31 * var_x39 + 1.6427856937147429e-5 * var_x130 * var_x96 * var_x99 - 0.00016722408026755852 * var_x0 * var_x10 / pow(var_x1, 2) - 1.2320892702860571e-5 * var_x136 * var_x99 * mParameters[3] + 0.019211226915711394 * var_x10 * var_x32 * var_x33 / pow(var_x34, 2) - 0.37970424962817811 * var_x105 * var_x22 * (0.24326999999999999 * var_x39 - var_x25 * (0.061749999999999999 * var_x26 + 0.039456396800000001 * var_x27) - 0.51429999999999998 * var_x23 * var_x28 / pow(var_x24, 2)) / pow((var_x22 + 0.98039215686274506 * var_x29), 2);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_buffer__Cai = rY[1];
        // Units: millimolar; Initial value: 8.597401e-05
        double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
        // Units: millimolar; Initial value: 0.5545201
        double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
        // Units: millimolar; Initial value: 0.0001031812
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC = rY[32];
        // Units: millimolar; Initial value: 0.008773191
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg = rY[33];
        // Units: millimolar; Initial value: 0.1078283
        double var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg = rY[34];
        // Units: millimolar; Initial value: 0.01524002
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_Calmodulin = rY[35];
        // Units: millimolar; Initial value: 0.0002911916
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin = rY[36];
        // Units: millimolar; Initial value: 0.001298754
        double var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin = rY[37];
        // Units: millimolar; Initial value: 0.1381982
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_SRB = rY[38];
        // Units: millimolar; Initial value: 0.002143165
        
        
        // Mathematics
        const double var_Jpump_SR__H = 1.7869999999999999; // dimensionless
        const double var_Jpump_SR__Kmf = 0.00024600000000000002; // millimolar
        const double var_Jpump_SR__Kmr = 1.7; // millimolar
        const double var_Jpump_SR__Q10_SRCaP = 2.6000000000000001; // dimensionless
        const double var_cytosolic_Ca_buffer__Bmax_Calmodulin = 0.024; // millimolar
        const double var_cytosolic_Ca_buffer__Bmax_Myosin_Ca = 0.14000000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__Bmax_Myosin_Mg = 0.14000000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__Bmax_SRB = 0.017100000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__Bmax_TroponinC = 0.070000000000000007; // millimolar
        const double var_cytosolic_Ca_buffer__Bmax_TroponinC_Ca_Mg_Ca = 0.14000000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__Bmax_TroponinC_Ca_Mg_Mg = 0.14000000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__koff_Calmodulin = 0.23799999999999999; // per_millisecond
        const double var_cytosolic_Ca_buffer__koff_Myosin_Ca = 0.00046000000000000001; // per_millisecond
        const double var_cytosolic_Ca_buffer__koff_Myosin_Mg = 5.7000000000000003e-5; // per_millisecond
        const double var_cytosolic_Ca_buffer__koff_SRB = 0.059999999999999998; // per_millisecond
        const double var_cytosolic_Ca_buffer__koff_TroponinC = 0.019599999999999999; // per_millisecond
        const double var_cytosolic_Ca_buffer__koff_TroponinC_Ca_Mg_Ca = 3.1999999999999999e-5; // per_millisecond
        const double var_cytosolic_Ca_buffer__koff_TroponinC_Ca_Mg_Mg = 0.0033300000000000001; // per_millisecond
        const double var_cytosolic_Ca_buffer__kon_Calmodulin = 34.0; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_Calmodulin = -var_chaste_interface__cytosolic_Ca_buffer__Ca_Calmodulin * var_cytosolic_Ca_buffer__koff_Calmodulin + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_Calmodulin + var_cytosolic_Ca_buffer__Bmax_Calmodulin) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_Calmodulin; // millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__kon_Myosin_Ca = 13.800000000000001; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_Myosin = -var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin * var_cytosolic_Ca_buffer__koff_Myosin_Ca + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin - var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin + var_cytosolic_Ca_buffer__Bmax_Myosin_Ca) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_Myosin_Ca; // millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__kon_Myosin_Mg = 0.015699999999999999; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__kon_SRB = 100.0; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_SRB = -var_chaste_interface__cytosolic_Ca_buffer__Ca_SRB * var_cytosolic_Ca_buffer__koff_SRB + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_SRB + var_cytosolic_Ca_buffer__Bmax_SRB) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_SRB; // millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__kon_TroponinC = 32.700000000000003; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_TroponinC = -var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC * var_cytosolic_Ca_buffer__koff_TroponinC + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC + var_cytosolic_Ca_buffer__Bmax_TroponinC) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_TroponinC; // millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__kon_TroponinC_Ca_Mg_Ca = 2.3700000000000001; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_TroponinC_Ca_Mg = -var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg * var_cytosolic_Ca_buffer__koff_TroponinC_Ca_Mg_Ca + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg - var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg + var_cytosolic_Ca_buffer__Bmax_TroponinC_Ca_Mg_Ca) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_TroponinC_Ca_Mg_Ca; // millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__kon_TroponinC_Ca_Mg_Mg = 0.0030000000000000001; // per_millimolar_per_millisecond
        const double var_ion_diffusion__J_Ca_SL_myo = 3.7243000000000002e-12 * var_chaste_interface__Ca_buffer__Ca_SL - 3.7243000000000002e-12 * var_chaste_interface__Ca_buffer__Cai; // millimole_per_millisecond
        const double var_model_parameters__Mgi = 1.0; // millimolar
        const double var_cytosolic_Ca_buffer__dMg_Myosin = -var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin * var_cytosolic_Ca_buffer__koff_Myosin_Mg + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin - var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin + var_cytosolic_Ca_buffer__Bmax_Myosin_Mg) * var_cytosolic_Ca_buffer__kon_Myosin_Mg * var_model_parameters__Mgi; // millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dMg_TroponinC_Ca_Mg = -var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg * var_cytosolic_Ca_buffer__koff_TroponinC_Ca_Mg_Mg + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg - var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg + var_cytosolic_Ca_buffer__Bmax_TroponinC_Ca_Mg_Mg) * var_cytosolic_Ca_buffer__kon_TroponinC_Ca_Mg_Mg * var_model_parameters__Mgi; // millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_cytosol_tot_bound = var_cytosolic_Ca_buffer__dCa_Calmodulin + var_cytosolic_Ca_buffer__dCa_Myosin + var_cytosolic_Ca_buffer__dCa_SRB + var_cytosolic_Ca_buffer__dCa_TroponinC + var_cytosolic_Ca_buffer__dCa_TroponinC_Ca_Mg + var_cytosolic_Ca_buffer__dMg_Myosin + var_cytosolic_Ca_buffer__dMg_TroponinC_Ca_Mg; // millimolar_per_millisecond
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_Jpump_SR__Q_SRCaP = pow(var_Jpump_SR__Q10_SRCaP, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_Jpump_SR__j_pump_SR = (pow((var_chaste_interface__Ca_buffer__Cai / var_Jpump_SR__Kmf), var_Jpump_SR__H) - pow((var_chaste_interface__Ca_buffer__Ca_SR / var_Jpump_SR__Kmr), var_Jpump_SR__H)) * var_Jpump_SR__Q_SRCaP * mParameters[2] / (1.0 + pow((var_chaste_interface__Ca_buffer__Cai / var_Jpump_SR__Kmf), var_Jpump_SR__H) + pow((var_chaste_interface__Ca_buffer__Ca_SR / var_Jpump_SR__Kmr), var_Jpump_SR__H)); // millimolar_per_millisecond
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_SR = 0.035000000000000003 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_myo = 0.65000000000000002 * var_model_parameters__Vol_Cell; // liter
        const double d_dt_chaste_interface_var_Ca_buffer__Cai = -1.0 * var_cytosolic_Ca_buffer__dCa_cytosol_tot_bound + var_ion_diffusion__J_Ca_SL_myo / var_model_parameters__Vol_myo - var_Jpump_SR__j_pump_SR * var_model_parameters__Vol_SR / var_model_parameters__Vol_myo; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_buffer__Cai;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Cai = rY[1];
            // Units: millimolar; Initial value: 8.597401e-05
            double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
            // Units: millimolar; Initial value: 0.5545201
            double var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC = rY[32];
            // Units: millimolar; Initial value: 0.008773191
            double var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg = rY[33];
            // Units: millimolar; Initial value: 0.1078283
            double var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg = rY[34];
            // Units: millimolar; Initial value: 0.01524002
            double var_chaste_interface__cytosolic_Ca_buffer__Ca_Calmodulin = rY[35];
            // Units: millimolar; Initial value: 0.0002911916
            double var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin = rY[36];
            // Units: millimolar; Initial value: 0.001298754
            double var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin = rY[37];
            // Units: millimolar; Initial value: 0.1381982
            double var_chaste_interface__cytosolic_Ca_buffer__Ca_SRB = rY[38];
            // Units: millimolar; Initial value: 0.002143165
            
            const double var_x210 = 34.0 * var_chaste_interface__cytosolic_Ca_buffer__Ca_Calmodulin;
            const double var_x211 = 100.0 * var_chaste_interface__cytosolic_Ca_buffer__Ca_SRB;
            const double var_x212 = 32.700000000000003 * var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC;
            const double var_x213 = 2.3700000000000001 * var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg;
            const double var_x214 = 2.3700000000000001 * var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg;
            const double var_x215 = 13.800000000000001 * var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin;
            const double var_x216 = 13.800000000000001 * var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin;
            const double var_x217 = pow(var_chaste_interface__Ca_buffer__Cai, 0.78699999999999992);
            const double var_x218 = pow(var_chaste_interface__Ca_buffer__Ca_SR, 1.7869999999999999);
            const double var_x219 = 0.38742512113256738 * var_x218;
            const double var_x220 = pow(var_chaste_interface__Ca_buffer__Cai, 1.7869999999999999);
            const double var_x221 = 2814485.1633595936 * var_x220;
            const double var_x222 = mParameters[2] / (1.0 + var_x219 + var_x221);
            const double var_x223 = var_x217 * var_x222;
            const double var_x224 = (var_x221 - var_x219) * mParameters[2] / pow((3.5530476870814998e-7 + var_x220 + 1.3765399305573384e-7 * var_x218), 2);
            const double var_x225 = var_x217 * var_x224;
            
            partialF = -7.2523935948689155 + var_x210 + var_x211 + var_x212 + var_x213 + var_x214 + var_x215 + var_x216 + 3.4188518090540365e-8 * var_x225 - 270818.42237280885 * var_x223;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__INa_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.9867005
        
        
        // Mathematics
        const double var_INa_h_gate__alpha_h = ((var_chaste_interface__cell__V < -40.0) ? (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V)) : (0)); // per_millisecond
        const double var_INa_h_gate__beta_h = ((var_chaste_interface__cell__V < -40.0) ? (310000.0 * exp(0.34999999999999998 * var_chaste_interface__cell__V) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__cell__V)) : (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V)))); // per_millisecond
        const double d_dt_chaste_interface_var_INa_h_gate__h = (1.0 - var_chaste_interface__INa_h_gate__h) * var_INa_h_gate__alpha_h - var_INa_h_gate__beta_h * var_chaste_interface__INa_h_gate__h; // 1 / millisecond

        return d_dt_chaste_interface_var_INa_h_gate__h;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            
            const double var_x234 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V);
            const double var_x235 = var_chaste_interface__cell__V < -40.0;
            const double var_x236 = exp(0.079000000000000001 * var_chaste_interface__cell__V);
            const double var_x237 = exp(0.34999999999999998 * var_chaste_interface__cell__V);
            const double var_x238 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V);
            const double var_x239 = 1.0 + var_x238;
            
            partialF = -((var_x235) ? (0.13500000000000001 * var_x234) : (0)) - ((var_x235) ? (310000.0 * var_x237 + 3.5600000000000001 * var_x236) : (7.6923076923076916 / var_x239));
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__INa_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.991562
        
        
        // Mathematics
        const double var_INa_j_gate__alpha_j = ((var_chaste_interface__cell__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__cell__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__cell__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__cell__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V))) : (0)); // per_millisecond
        const double var_INa_j_gate__beta_j = ((var_chaste_interface__cell__V < -40.0) ? (0.1212 * exp(-0.01052 * var_chaste_interface__cell__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V))) : (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__V)))); // per_millisecond
        const double d_dt_chaste_interface_var_INa_j_gate__j = (1.0 - var_chaste_interface__INa_j_gate__j) * var_INa_j_gate__alpha_j - var_INa_j_gate__beta_j * var_chaste_interface__INa_j_gate__j; // 1 / millisecond

        return d_dt_chaste_interface_var_INa_j_gate__j;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            
            const double var_x235 = var_chaste_interface__cell__V < -40.0;
            const double var_x240 = exp(0.24440000000000001 * var_chaste_interface__cell__V);
            const double var_x241 = exp(-0.043909999999999998 * var_chaste_interface__cell__V);
            const double var_x242 = -127140.0 * var_x240 - 3.4740000000000003e-5 * var_x241;
            const double var_x243 = exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V);
            const double var_x244 = 1.0 + var_x243;
            const double var_x245 = 1 / var_x244;
            const double var_x246 = var_x242 * var_x245;
            const double var_x247 = 37.780000000000001 + var_chaste_interface__cell__V;
            const double var_x248 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V);
            const double var_x249 = 1.0 + var_x248;
            const double var_x250 = exp(-0.01052 * var_chaste_interface__cell__V);
            const double var_x251 = var_x250 / var_x249;
            const double var_x252 = -0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x253 = exp(-3.2000000000000002 + var_x252);
            const double var_x254 = 1.0 + var_x253;
            const double var_x255 = exp(-2.5349999999999999e-7 * var_chaste_interface__cell__V);
            const double var_x256 = var_x255 / var_x254;
            
            partialF = -((var_x235) ? (0.1212 * var_x251) : (0.29999999999999999 * var_x256)) - ((var_x235) ? (var_x246 * var_x247) : (0));
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__INa_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.001405627
        
        
        // Mathematics
        const double var_INa_m_gate__alpha_m = 0.32000000000000001 * (47.130000000000003 + var_chaste_interface__cell__V) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__cell__V)); // per_millisecond
        const double var_INa_m_gate__beta_m = 0.080000000000000002 * exp(-0.090909090909090912 * var_chaste_interface__cell__V); // per_millisecond
        const double d_dt_chaste_interface_var_INa_m_gate__m = (1.0 - var_chaste_interface__INa_m_gate__m) * var_INa_m_gate__alpha_m - var_INa_m_gate__beta_m * var_chaste_interface__INa_m_gate__m; // 1 / millisecond

        return d_dt_chaste_interface_var_INa_m_gate__m;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            
            const double var_x252 = -0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x258 = exp(-4.7130000000000001 + var_x252);
            const double var_x259 = 1.0 - var_x258;
            const double var_x260 = 0.32000000000000001 / var_x259;
            const double var_x261 = exp(-0.090909090909090912 * var_chaste_interface__cell__V);
            const double var_x262 = 47.130000000000003 + var_chaste_interface__cell__V;
            
            partialF = -0.080000000000000002 * var_x261 - var_x260 * var_x262;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__IKr_Xr_gate__Xr = rY[5];
        // Units: dimensionless; Initial value: 0.008641386
        
        
        // Mathematics
        const double var_IKr_Xr_gate__Xr_infinity = 1 / (1.0 + exp(-6.666666666666667 - 0.13333333333333333 * var_chaste_interface__cell__V)); // dimensionless
        const double var_IKr_Xr_gate__tau_Xr = 1 / (0.00060999999999999997 * (10.0 + var_chaste_interface__cell__V) / (-1.0 + exp(1.45 + 0.14499999999999999 * var_chaste_interface__cell__V)) + 0.0013799999999999999 * (7.0 + var_chaste_interface__cell__V) / (1.0 - exp(-0.86099999999999999 - 0.123 * var_chaste_interface__cell__V))); // millisecond
        const double d_dt_chaste_interface_var_IKr_Xr_gate__Xr = (-var_chaste_interface__IKr_Xr_gate__Xr + var_IKr_Xr_gate__Xr_infinity) / var_IKr_Xr_gate__tau_Xr; // 1 / millisecond

        return d_dt_chaste_interface_var_IKr_Xr_gate__Xr;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            
            const double var_x265 = exp(1.45 + 0.14499999999999999 * var_chaste_interface__cell__V);
            const double var_x266 = -1.0 + var_x265;
            const double var_x267 = 0.00060999999999999997 / var_x266;
            const double var_x268 = exp(-0.86099999999999999 - 0.123 * var_chaste_interface__cell__V);
            const double var_x269 = 1.0 - var_x268;
            const double var_x270 = 0.0013799999999999999 / var_x269;
            const double var_x271 = 7.0 + var_chaste_interface__cell__V;
            const double var_x272 = 10.0 + var_chaste_interface__cell__V;
            const double var_x273 = var_x267 * var_x272;
            const double var_x274 = var_x270 * var_x271;
            
            partialF = -var_x273 - var_x274;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__IKs_Xs_gate__Xs = rY[6];
        // Units: dimensionless; Initial value: 0.005412034
        
        
        // Mathematics
        const double var_IKs_Xs_gate__Xs_infinity = 1 / (1.0 + exp(0.089820359281437126 - 0.059880239520958084 * var_chaste_interface__cell__V)); // dimensionless
        const double var_IKs_Xs_gate__tau_Xs = 1 / (0.00013100000000000001 * (30.0 + var_chaste_interface__cell__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__cell__V)) + 7.1899999999999999e-5 * (30.0 + var_chaste_interface__cell__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__cell__V))); // millisecond
        const double d_dt_chaste_interface_var_IKs_Xs_gate__Xs = (-var_chaste_interface__IKs_Xs_gate__Xs + var_IKs_Xs_gate__Xs_infinity) / var_IKs_Xs_gate__tau_Xs; // 1 / millisecond

        return d_dt_chaste_interface_var_IKs_Xs_gate__Xs;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            
            const double var_x277 = exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__cell__V);
            const double var_x278 = -1.0 + var_x277;
            const double var_x279 = 0.00013100000000000001 / var_x278;
            const double var_x280 = exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__cell__V);
            const double var_x281 = 1.0 - var_x280;
            const double var_x282 = 7.1899999999999999e-5 / var_x281;
            const double var_x283 = 30.0 + var_chaste_interface__cell__V;
            const double var_x284 = var_x279 * var_x283;
            const double var_x285 = var_x282 * var_x283;
            
            partialF = -var_x284 - var_x285;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__Itos_X_gate__X_tos = rY[7];
        // Units: dimensionless; Initial value: 0.004051574
        
        
        // Mathematics
        const double var_Itos_X_gate__X_tos_infinity = 1 / (1.0 + exp(-0.20000000000000001 - 0.066666666666666666 * var_chaste_interface__cell__V)); // dimensionless
        const double var_Itos_X_gate__tau_X_tos = 0.5 + 9.0 / (1.0 + exp(0.20000000000000001 + 0.066666666666666666 * var_chaste_interface__cell__V)); // millisecond
        const double d_dt_chaste_interface_var_Itos_X_gate__X_tos = (-var_chaste_interface__Itos_X_gate__X_tos + var_Itos_X_gate__X_tos_infinity) / var_Itos_X_gate__tau_X_tos; // 1 / millisecond

        return d_dt_chaste_interface_var_Itos_X_gate__X_tos;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            
            const double var_x286 = 0.066666666666666666 * var_chaste_interface__cell__V;
            const double var_x287 = exp(0.20000000000000001 + var_x286);
            const double var_x288 = 1.0 + var_x287;
            const double var_x289 = 1 / var_x288;
            const double var_x290 = 1 / (0.5 + 9.0 * var_x289);
            
            partialF = -var_x290;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__Itos_Y_gate__Y_tos = rY[8];
        // Units: dimensionless; Initial value: 0.9945511
        
        
        // Mathematics
        const double var_Itos_Y_gate__Y_tos_infinity = 1 / (1.0 + exp(3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V)); // dimensionless
        const double var_Itos_Y_gate__tau_Y_tos = 30.0 + 3000.0 / (1.0 + exp(6.0 + 0.10000000000000001 * var_chaste_interface__cell__V)); // millisecond
        const double d_dt_chaste_interface_var_Itos_Y_gate__Y_tos = (-var_chaste_interface__Itos_Y_gate__Y_tos + var_Itos_Y_gate__Y_tos_infinity) / var_Itos_Y_gate__tau_Y_tos; // 1 / millisecond

        return d_dt_chaste_interface_var_Itos_Y_gate__Y_tos;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            
            const double var_x295 = 0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x296 = exp(6.0 + var_x295);
            const double var_x297 = 1.0 + var_x296;
            const double var_x298 = 1 / var_x297;
            const double var_x299 = 1 / (30.0 + 3000.0 * var_x298);
            
            partialF = -var_x299;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__Itos_R_gate__R_tos = rY[9];
        // Units: dimensionless; Initial value: 0.9946
        
        
        // Mathematics
        const double var_Itos_R_gate__R_tos_infinity = 1 / (1.0 + exp(3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V)); // dimensionless
        const double var_Itos_R_gate__tau_R_tos = 220.0 + 2800.0 / (1.0 + exp(6.0 + 0.10000000000000001 * var_chaste_interface__cell__V)); // millisecond
        const double d_dt_chaste_interface_var_Itos_R_gate__R_tos = (-var_chaste_interface__Itos_R_gate__R_tos + var_Itos_R_gate__R_tos_infinity) / var_Itos_R_gate__tau_R_tos; // 1 / millisecond

        return d_dt_chaste_interface_var_Itos_R_gate__R_tos;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            
            const double var_x295 = 0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x296 = exp(6.0 + var_x295);
            const double var_x297 = 1.0 + var_x296;
            const double var_x298 = 1 / var_x297;
            const double var_x307 = 1 / (220.0 + 2800.0 * var_x298);
            
            partialF = -var_x307;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__Itof_X_gate__X_tof = rY[10];
        // Units: dimensionless; Initial value: 0.004051574
        
        
        // Mathematics
        const double var_Itof_X_gate__X_tof_infinity = 1 / (1.0 + exp(-0.20000000000000001 - 0.066666666666666666 * var_chaste_interface__cell__V)); // dimensionless
        const double var_Itof_X_gate__tau_X_tof = 1.5 + 3.5 * exp(-0.0011111111111111111 * pow(var_chaste_interface__cell__V, 2)); // millisecond
        const double d_dt_chaste_interface_var_Itof_X_gate__X_tof = (-var_chaste_interface__Itof_X_gate__X_tof + var_Itof_X_gate__X_tof_infinity) / var_Itof_X_gate__tau_X_tof; // 1 / millisecond

        return d_dt_chaste_interface_var_Itof_X_gate__X_tof;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            
            const double var_x308 = exp(-0.0011111111111111111 * pow(var_chaste_interface__cell__V, 2));
            const double var_x309 = 1 / (1.5 + 3.5 * var_x308);
            
            partialF = -var_x309;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__Itof_Y_gate__Y_tof = rY[11];
        // Units: dimensionless; Initial value: 0.9945511
        
        
        // Mathematics
        const double var_Itof_Y_gate__Y_tof_infinity = 1 / (1.0 + exp(3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V)); // dimensionless
        const double var_Itof_Y_gate__tau_Y_tof = 20.0 + 20.0 / (1.0 + exp(3.3500000000000001 + 0.10000000000000001 * var_chaste_interface__cell__V)); // millisecond
        const double d_dt_chaste_interface_var_Itof_Y_gate__Y_tof = (-var_chaste_interface__Itof_Y_gate__Y_tof + var_Itof_Y_gate__Y_tof_infinity) / var_Itof_Y_gate__tau_Y_tof; // 1 / millisecond

        return d_dt_chaste_interface_var_Itof_Y_gate__Y_tof;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            
            const double var_x295 = 0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x300 = exp(3.3500000000000001 + var_x295);
            const double var_x301 = 1.0 + var_x300;
            const double var_x304 = 1 / var_x301;
            const double var_x310 = 1 / (20.0 + 20.0 * var_x304);
            
            partialF = -var_x310;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__ICaL_d_gate__d = rY[12];
        // Units: dimensionless; Initial value: 7.175662e-06
        
        
        // Mathematics
        const double var_ICaL_d_gate__d_infinity = 1 / (1.0 + exp(-2.4166666666666665 - 0.16666666666666666 * var_chaste_interface__cell__V)); // dimensionless
        const double var_ICaL_d_gate__tau_d = 28.571428571428569 * (1.0 - exp(-2.4166666666666665 - 0.16666666666666666 * var_chaste_interface__cell__V)) * var_ICaL_d_gate__d_infinity / (14.5 + var_chaste_interface__cell__V); // millisecond
        const double d_dt_chaste_interface_var_ICaL_d_gate__d = (-var_chaste_interface__ICaL_d_gate__d + var_ICaL_d_gate__d_infinity) / var_ICaL_d_gate__tau_d; // 1 / millisecond

        return d_dt_chaste_interface_var_ICaL_d_gate__d;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            
            const double var_x311 = exp(-2.4166666666666665 - 0.16666666666666666 * var_chaste_interface__cell__V);
            const double var_x312 = 1.0 - var_x311;
            const double var_x313 = 1 / var_x312;
            const double var_x314 = 1.0 + var_x311;
            const double var_x318 = 0.035000000000000003 * var_x314;
            const double var_x319 = 14.5 + var_chaste_interface__cell__V;
            const double var_x320 = var_x313 * var_x319;
            
            partialF = -var_x318 * var_x320;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__ICaL_f_gate__f = rY[13];
        // Units: dimensionless; Initial value: 1.000681
        
        
        // Mathematics
        const double var_ICaL_f_gate__f_infinity = 1 / (1.0 + exp(9.7388888888888889 + 0.27777777777777779 * var_chaste_interface__cell__V)) + 0.59999999999999998 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__cell__V)); // dimensionless
        const double var_ICaL_f_gate__tau_f = 1 / (0.02 + 0.019699999999999999 * exp(-0.23877882250000002 * pow((1 + 0.068965517241379309 * var_chaste_interface__cell__V), 2))); // millisecond
        const double d_dt_chaste_interface_var_ICaL_f_gate__f = (-var_chaste_interface__ICaL_f_gate__f + var_ICaL_f_gate__f_infinity) / var_ICaL_f_gate__tau_f; // 1 / millisecond

        return d_dt_chaste_interface_var_ICaL_f_gate__f;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            
            const double var_x323 = 0.019699999999999999 * exp(-0.23877882250000002 * pow((1 + 0.068965517241379309 * var_chaste_interface__cell__V), 2));
            
            partialF = -0.02 - var_x323;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__ICaL_fCa_gate__fCaB_SL = rY[14];
        // Units: dimensionless; Initial value: 0.01452605
        double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
        // Units: millimolar; Initial value: 0.0001031812
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_ICaL_fCa_gate__fCaB_SL = -0.011900000000000001 * var_chaste_interface__ICaL_fCa_gate__fCaB_SL + 1.7 * (1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_SL) * var_chaste_interface__Ca_buffer__Ca_SL; // 1 / millisecond

        return d_dt_chaste_interface_var_ICaL_fCa_gate__fCaB_SL;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
            // Units: millimolar; Initial value: 0.0001031812
            
            
            partialF = -0.011900000000000001 - 1.7 * var_chaste_interface__Ca_buffer__Ca_SL;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__ICaL_fCa_gate__fCaB_jct = rY[15];
        // Units: dimensionless; Initial value: 0.02421991
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_ICaL_fCa_gate__fCaB_jct = -0.011900000000000001 * var_chaste_interface__ICaL_fCa_gate__fCaB_jct + 1.7 * (1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_jct) * var_chaste_interface__Ca_buffer__Ca_jct; // 1 / millisecond

        return d_dt_chaste_interface_var_ICaL_fCa_gate__fCaB_jct;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
            // Units: millimolar; Initial value: 0.0001737475
            
            
            partialF = -0.011900000000000001 - 1.7 * var_chaste_interface__Ca_buffer__Ca_jct;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Jrel_SR__R = rY[16];
        // Units: dimensionless; Initial value: 0.8884332
        double var_chaste_interface__Jrel_SR__I = rY[17];
        // Units: dimensionless; Initial value: 1.024274e-07
        double var_chaste_interface__Jrel_SR__O = rY[18];
        // Units: dimensionless; Initial value: 8.156628e-07
        double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
        // Units: millimolar; Initial value: 0.5545201
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        
        
        // Mathematics
        const double var_Jrel_SR__EC50_SR = 0.45000000000000001; // millimolar
        const double var_Jrel_SR__HSR = 2.5; // dimensionless
        const double var_Jrel_SR__Max_SR = 15.0; // dimensionless
        const double var_Jrel_SR__Min_SR = 1.0; // dimensionless
        const double var_Jrel_SR__RI = 1.0 - var_chaste_interface__Jrel_SR__I - var_chaste_interface__Jrel_SR__O - var_chaste_interface__Jrel_SR__R; // dimensionless
        const double var_Jrel_SR__kCaSR = -(-var_Jrel_SR__Min_SR + var_Jrel_SR__Max_SR) / (1.0 + pow((var_Jrel_SR__EC50_SR / var_chaste_interface__Ca_buffer__Ca_SR), var_Jrel_SR__HSR)) + var_Jrel_SR__Max_SR; // dimensionless
        const double var_Jrel_SR__kiCa = 0.5; // per_millimolar_per_millisecond
        const double var_Jrel_SR__kiSRCa = var_Jrel_SR__kCaSR * var_Jrel_SR__kiCa; // per_millimolar_per_millisecond
        const double var_Jrel_SR__kim = 0.0050000000000000001; // per_millisecond
        const double var_Jrel_SR__koCa = 10.0; // per_millimolar2_per_millisecond
        const double var_Jrel_SR__koSRCa = var_Jrel_SR__koCa / var_Jrel_SR__kCaSR; // per_millimolar2_per_millisecond
        const double var_Jrel_SR__kom = 0.059999999999999998; // per_millisecond
        const double d_dt_chaste_interface_var_Jrel_SR__R = var_chaste_interface__Jrel_SR__O * var_Jrel_SR__kom + var_Jrel_SR__RI * var_Jrel_SR__kim - pow(var_chaste_interface__Ca_buffer__Ca_jct, 2) * var_chaste_interface__Jrel_SR__R * var_Jrel_SR__koSRCa - var_chaste_interface__Ca_buffer__Ca_jct * var_chaste_interface__Jrel_SR__R * var_Jrel_SR__kiSRCa; // 1 / millisecond

        return d_dt_chaste_interface_var_Jrel_SR__R;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
            // Units: millimolar; Initial value: 0.5545201
            double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
            // Units: millimolar; Initial value: 0.0001737475
            
            const double var_x204 = pow(var_chaste_interface__Ca_buffer__Ca_jct, 2);
            const double var_x328 = 1 / var_chaste_interface__Ca_buffer__Ca_SR;
            const double var_x329 = pow(var_x328, 2.5);
            const double var_x330 = 1.0 + 0.13584112963311223 * var_x329;
            const double var_x331 = 1 / var_x330;
            const double var_x332 = 7.0 * var_x331;
            const double var_x333 = -7.5 + var_x332;
            const double var_x334 = var_x333 * var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x335 = 1 / (15.0 - 14.0 * var_x331);
            const double var_x336 = 10.0 * var_x204 * var_x335;
            const double var_x337 = -var_x336;
            
            partialF = -0.0050000000000000001 + var_x334 + var_x337;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Jrel_SR__R = rY[16];
        // Units: dimensionless; Initial value: 0.8884332
        double var_chaste_interface__Jrel_SR__I = rY[17];
        // Units: dimensionless; Initial value: 1.024274e-07
        double var_chaste_interface__Jrel_SR__O = rY[18];
        // Units: dimensionless; Initial value: 8.156628e-07
        double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
        // Units: millimolar; Initial value: 0.5545201
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        
        
        // Mathematics
        const double var_Jrel_SR__EC50_SR = 0.45000000000000001; // millimolar
        const double var_Jrel_SR__HSR = 2.5; // dimensionless
        const double var_Jrel_SR__Max_SR = 15.0; // dimensionless
        const double var_Jrel_SR__Min_SR = 1.0; // dimensionless
        const double var_Jrel_SR__RI = 1.0 - var_chaste_interface__Jrel_SR__I - var_chaste_interface__Jrel_SR__O - var_chaste_interface__Jrel_SR__R; // dimensionless
        const double var_Jrel_SR__kCaSR = -(-var_Jrel_SR__Min_SR + var_Jrel_SR__Max_SR) / (1.0 + pow((var_Jrel_SR__EC50_SR / var_chaste_interface__Ca_buffer__Ca_SR), var_Jrel_SR__HSR)) + var_Jrel_SR__Max_SR; // dimensionless
        const double var_Jrel_SR__kiCa = 0.5; // per_millimolar_per_millisecond
        const double var_Jrel_SR__kiSRCa = var_Jrel_SR__kCaSR * var_Jrel_SR__kiCa; // per_millimolar_per_millisecond
        const double var_Jrel_SR__kim = 0.0050000000000000001; // per_millisecond
        const double var_Jrel_SR__koCa = 10.0; // per_millimolar2_per_millisecond
        const double var_Jrel_SR__koSRCa = var_Jrel_SR__koCa / var_Jrel_SR__kCaSR; // per_millimolar2_per_millisecond
        const double var_Jrel_SR__kom = 0.059999999999999998; // per_millisecond
        const double d_dt_chaste_interface_var_Jrel_SR__I = -var_chaste_interface__Jrel_SR__I * var_Jrel_SR__kim - var_chaste_interface__Jrel_SR__I * var_Jrel_SR__kom + pow(var_chaste_interface__Ca_buffer__Ca_jct, 2) * var_Jrel_SR__RI * var_Jrel_SR__koSRCa + var_chaste_interface__Ca_buffer__Ca_jct * var_chaste_interface__Jrel_SR__O * var_Jrel_SR__kiSRCa; // 1 / millisecond

        return d_dt_chaste_interface_var_Jrel_SR__I;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
            // Units: millimolar; Initial value: 0.5545201
            double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
            // Units: millimolar; Initial value: 0.0001737475
            
            const double var_x204 = pow(var_chaste_interface__Ca_buffer__Ca_jct, 2);
            const double var_x328 = 1 / var_chaste_interface__Ca_buffer__Ca_SR;
            const double var_x329 = pow(var_x328, 2.5);
            const double var_x330 = 1.0 + 0.13584112963311223 * var_x329;
            const double var_x331 = 1 / var_x330;
            const double var_x335 = 1 / (15.0 - 14.0 * var_x331);
            const double var_x336 = 10.0 * var_x204 * var_x335;
            const double var_x337 = -var_x336;
            
            partialF = -0.065000000000000002 + var_x337;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Jrel_SR__R = rY[16];
        // Units: dimensionless; Initial value: 0.8884332
        double var_chaste_interface__Jrel_SR__I = rY[17];
        // Units: dimensionless; Initial value: 1.024274e-07
        double var_chaste_interface__Jrel_SR__O = rY[18];
        // Units: dimensionless; Initial value: 8.156628e-07
        double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
        // Units: millimolar; Initial value: 0.5545201
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        
        
        // Mathematics
        const double var_Jrel_SR__EC50_SR = 0.45000000000000001; // millimolar
        const double var_Jrel_SR__HSR = 2.5; // dimensionless
        const double var_Jrel_SR__Max_SR = 15.0; // dimensionless
        const double var_Jrel_SR__Min_SR = 1.0; // dimensionless
        const double var_Jrel_SR__kCaSR = -(-var_Jrel_SR__Min_SR + var_Jrel_SR__Max_SR) / (1.0 + pow((var_Jrel_SR__EC50_SR / var_chaste_interface__Ca_buffer__Ca_SR), var_Jrel_SR__HSR)) + var_Jrel_SR__Max_SR; // dimensionless
        const double var_Jrel_SR__kiCa = 0.5; // per_millimolar_per_millisecond
        const double var_Jrel_SR__kiSRCa = var_Jrel_SR__kCaSR * var_Jrel_SR__kiCa; // per_millimolar_per_millisecond
        const double var_Jrel_SR__kim = 0.0050000000000000001; // per_millisecond
        const double var_Jrel_SR__koCa = 10.0; // per_millimolar2_per_millisecond
        const double var_Jrel_SR__koSRCa = var_Jrel_SR__koCa / var_Jrel_SR__kCaSR; // per_millimolar2_per_millisecond
        const double var_Jrel_SR__kom = 0.059999999999999998; // per_millisecond
        const double d_dt_chaste_interface_var_Jrel_SR__O = var_chaste_interface__Jrel_SR__I * var_Jrel_SR__kim - var_chaste_interface__Jrel_SR__O * var_Jrel_SR__kom + pow(var_chaste_interface__Ca_buffer__Ca_jct, 2) * var_chaste_interface__Jrel_SR__R * var_Jrel_SR__koSRCa - var_chaste_interface__Ca_buffer__Ca_jct * var_chaste_interface__Jrel_SR__O * var_Jrel_SR__kiSRCa; // 1 / millisecond

        return d_dt_chaste_interface_var_Jrel_SR__O;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
            // Units: millimolar; Initial value: 0.5545201
            double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
            // Units: millimolar; Initial value: 0.0001737475
            
            const double var_x328 = 1 / var_chaste_interface__Ca_buffer__Ca_SR;
            const double var_x329 = pow(var_x328, 2.5);
            const double var_x330 = 1.0 + 0.13584112963311223 * var_x329;
            const double var_x331 = 1 / var_x330;
            const double var_x332 = 7.0 * var_x331;
            const double var_x333 = -7.5 + var_x332;
            const double var_x334 = var_x333 * var_chaste_interface__Ca_buffer__Ca_jct;
            
            partialF = -0.059999999999999998 + var_x334;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__INa_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.9867005
        double var_chaste_interface__INa_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.991562
        double var_chaste_interface__INa_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.001405627
        double var_chaste_interface__ICaL_d_gate__d = rY[12];
        // Units: dimensionless; Initial value: 7.175662e-06
        double var_chaste_interface__ICaL_f_gate__f = rY[13];
        // Units: dimensionless; Initial value: 1.000681
        double var_chaste_interface__ICaL_fCa_gate__fCaB_SL = rY[14];
        // Units: dimensionless; Initial value: 0.01452605
        double var_chaste_interface__Na_buffer__Na_SL = rY[19];
        // Units: millimolar; Initial value: 8.80733
        double var_chaste_interface__Na_buffer__Na_jct = rY[20];
        // Units: millimolar; Initial value: 8.80329
        double var_chaste_interface__Na_buffer__Na_SL_buf = rY[21];
        // Units: millimolar; Initial value: 0.7720854
        double var_chaste_interface__Na_buffer__Nai = rY[23];
        // Units: millimolar; Initial value: 8.80853
        double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
        // Units: millimolar; Initial value: 0.0001031812
        
        
        // Mathematics
        const double var_ICaL__Fx_ICaL_SL = 0.10000000000000001; // dimensionless
        const double var_ICaL__PNa = 1.4999999999999999e-8; // litre_per_farad_millisecond
        const double var_ICaL__Q10_CaL = 1.8; // dimensionless
        const double var_ICaL__gamma_Nai = 0.75; // dimensionless
        const double var_ICaL__gamma_Nao = 0.75; // dimensionless
        const double var_ICaL_fCa_gate__fCa_SL = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_SL; // dimensionless
        const double var_INa__Fx_Na_SL = 0.89000000000000001; // dimensionless
        const double var_INaCa__Fx_NCX_SL = 0.89000000000000001; // dimensionless
        const double var_INaCa__HNa = 3.0; // dimensionless
        const double var_INaCa__K_mCai = 0.0035899999999999999; // millimolar
        const double var_INaCa__K_mCao = 1.3; // millimolar
        const double var_INaCa__K_mNai = 12.289999999999999; // millimolar
        const double var_INaCa__K_mNao = 87.5; // millimolar
        const double var_INaCa__Kd_act = 0.00025599999999999999; // millimolar
        const double var_INaCa__Ka_SL = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_SL, 3)); // dimensionless
        const double var_INaCa__Q10_NCX = 1.5700000000000001; // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_INaK__Fx_NaK_SL = 0.89000000000000001; // dimensionless
        const double var_INaK__H_NaK = 4.0; // dimensionless
        const double var_INaK__I_NaK_max = 1.9071899999999999; // microA_per_microF
        const double var_INaK__Km_Ko = 1.5; // millimolar
        const double var_INaK__Km_Nai = 11.0; // millimolar
        const double var_INa__openProb = pow(var_chaste_interface__INa_m_gate__m, 3) * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // dimensionless
        const double var_INab__Fx_NaBk_SL = 0.89000000000000001; // dimensionless
        const double var_INab__G_NaBk = 0.00029700000000000001; // milliS_per_microF
        const double var_Na_buffer__Bmax_SL = 1.6499999999999999; // millimolar
        const double var_Na_buffer__koff = 0.001; // per_millisecond
        const double var_Na_buffer__kon = 0.0001; // per_millimolar_per_millisecond
        const double var_Na_buffer__dNa_SL_buf = -var_chaste_interface__Na_buffer__Na_SL_buf * var_Na_buffer__koff + (-var_chaste_interface__Na_buffer__Na_SL_buf + var_Na_buffer__Bmax_SL) * var_chaste_interface__Na_buffer__Na_SL * var_Na_buffer__kon; // millimolar_per_millisecond
        const double var_ion_diffusion__J_Na_SL_myo = 1.6385999999999999e-12 * var_chaste_interface__Na_buffer__Na_SL - 1.6385999999999999e-12 * var_chaste_interface__Na_buffer__Nai; // millimole_per_millisecond
        const double var_ion_diffusion__J_Na_jct_SL = 1.8312999999999999e-14 * var_chaste_interface__Na_buffer__Na_jct - 1.8312999999999999e-14 * var_chaste_interface__Na_buffer__Na_SL; // millimole_per_millisecond
        const double var_model_parameters__Cm = 1.3809999999999999e-10; // farad
        const double var_model_parameters__F = 96485.0; // coulomb_per_mole
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * mParameters[6]); // dimensionless
        const double var_model_parameters__R = 8314.2999999999993; // joule_per_kilomole_kelvin
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__Q_CaL = pow(var_ICaL__Q10_CaL, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICaL__temp = 0.45000000000000001 * pow(var_model_parameters__F, 2) * var_ICaL__Q_CaL * var_chaste_interface__ICaL_d_gate__d * var_chaste_interface__ICaL_f_gate__f * var_chaste_interface__cell__V / (var_model_parameters__R * var_model_parameters__T); // coulomb_per_mole
        const double var_ICaL__i_CaL_Na_SL = (-var_ICaL__gamma_Nao * mParameters[6] + var_ICaL__gamma_Nai * var_chaste_interface__Na_buffer__Na_SL * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_SL * var_ICaL__PNa * var_ICaL__temp * var_ICaL_fCa_gate__fCa_SL / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_INaCa__Q_NCX = pow(var_INaCa__Q10_NCX, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_INaCa__temp_SL = (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_SL = var_INaCa__Fx_NCX_SL * var_INaCa__Ka_SL * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_SL / (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_SL / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_SL + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_SL / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_INaK__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) + 0.036499999999999998 * var_INaK__sigma * exp(-var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // dimensionless
        const double var_INaK__i_NaK_SL = var_INaK__Fx_NaK_SL * var_INaK__I_NaK_max * var_INaK__f_NaK * mParameters[5] / ((1.0 + pow((var_INaK__Km_Nai / var_chaste_interface__Na_buffer__Na_SL), var_INaK__H_NaK)) * (var_INaK__Km_Ko + mParameters[5])); // microA_per_microF
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_SL = 0.02 * var_model_parameters__Vol_Cell; // liter
        const double var_reversal_potentials__E_Na_SL = var_model_parameters__R * var_model_parameters__T * log(mParameters[6] / var_chaste_interface__Na_buffer__Na_SL) / var_model_parameters__F; // millivolt
        const double var_INa__i_Na_SL = (-var_reversal_potentials__E_Na_SL + var_chaste_interface__cell__V) * var_INa__Fx_Na_SL * mParameters[8] * var_INa__openProb; // microA_per_microF
        const double var_INab__i_Nab_SL = (-var_reversal_potentials__E_Na_SL + var_chaste_interface__cell__V) * var_INab__Fx_NaBk_SL * var_INab__G_NaBk; // microA_per_microF
        const double d_dt_chaste_interface_var_Na_buffer__Na_SL = -var_Na_buffer__dNa_SL_buf + (-var_ion_diffusion__J_Na_SL_myo + var_ion_diffusion__J_Na_jct_SL) / var_model_parameters__Vol_SL - (3.0 * var_INaCa__i_NaCa_SL + 3.0 * var_INaK__i_NaK_SL + var_ICaL__i_CaL_Na_SL + var_INa__i_Na_SL + var_INab__i_Nab_SL) * var_model_parameters__Cm / (var_model_parameters__F * var_model_parameters__Vol_SL); // millimolar / millisecond

        return d_dt_chaste_interface_var_Na_buffer__Na_SL;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            double var_chaste_interface__INa_h_gate__h = rY[2];
            // Units: dimensionless; Initial value: 0.9867005
            double var_chaste_interface__INa_j_gate__j = rY[3];
            // Units: dimensionless; Initial value: 0.991562
            double var_chaste_interface__INa_m_gate__m = rY[4];
            // Units: dimensionless; Initial value: 0.001405627
            double var_chaste_interface__ICaL_d_gate__d = rY[12];
            // Units: dimensionless; Initial value: 7.175662e-06
            double var_chaste_interface__ICaL_f_gate__f = rY[13];
            // Units: dimensionless; Initial value: 1.000681
            double var_chaste_interface__ICaL_fCa_gate__fCaB_SL = rY[14];
            // Units: dimensionless; Initial value: 0.01452605
            double var_chaste_interface__Na_buffer__Na_SL = rY[19];
            // Units: millimolar; Initial value: 8.80733
            double var_chaste_interface__Na_buffer__Na_SL_buf = rY[21];
            // Units: millimolar; Initial value: 0.7720854
            double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
            // Units: millimolar; Initial value: 0.0001031812
            
            const double var_x36 = pow(var_chaste_interface__INa_m_gate__m, 3);
            const double var_x37 = var_x36 * mParameters[8] * var_chaste_interface__INa_j_gate__j;
            const double var_x38 = var_x37 * var_chaste_interface__INa_h_gate__h;
            const double var_x40 = exp(0.013102086455787599 * var_chaste_interface__cell__V);
            const double var_x44 = exp(-0.024332446275034118 * var_chaste_interface__cell__V);
            const double var_x45 = pow(mParameters[6], 3.0);
            const double var_x48 = 1.0 + 0.27000000000000002 * var_x44;
            const double var_x49 = mParameters[11] / var_x48;
            const double var_x54 = 0.0035899999999999999 * var_x45;
            const double var_x59 = pow(var_chaste_interface__Na_buffer__Na_SL, 3.0);
            const double var_x60 = var_x59 * mParameters[4];
            const double var_x61 = var_x40 * var_x60;
            const double var_x62 = var_x45 * var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x63 = var_x44 * var_x62;
            const double var_x64 = 1.0 + 1.6777215999999998e-11 / pow(var_chaste_interface__Ca_buffer__Ca_SL, 3);
            const double var_x65 = 1 / var_x64;
            const double var_x66 = (1.0 + 278.55153203342621 * var_chaste_interface__Ca_buffer__Ca_SL) * var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x67 = 1.0 + 0.00053869674493876331 * var_x59;
            const double var_x68 = 1 / (var_x60 + var_x62 + 669921.875 * var_x66 + 1.3 * var_x59 + var_x54 * var_x67);
            const double var_x69 = var_x65 * var_x68;
            const double var_x70 = var_x49 * var_x69;
            const double var_x74 = exp(-0.0037434532730821718 * var_chaste_interface__cell__V);
            const double var_x75 = exp(0.01485884101040119 * mParameters[6]);
            const double var_x76 = 0.037434532730821715 * var_chaste_interface__cell__V;
            const double var_x77 = exp(-var_x76);
            const double var_x78 = 1.0 + 0.1245 * var_x74 + 0.036499999999999998 * var_x77 * (-0.14285714285714285 + 0.14285714285714285 * var_x75);
            const double var_x79 = mParameters[5] / (1.5 + mParameters[5]);
            const double var_x82 = 1 / var_chaste_interface__Na_buffer__Na_SL;
            const double var_x83 = pow(var_x82, 4.0);
            const double var_x88 = exp(var_x76);
            const double var_x91 = -1.0 + var_x88;
            const double var_x92 = 1 / var_x91;
            const double var_x93 = var_x92 * var_chaste_interface__ICaL_f_gate__f;
            const double var_x97 = var_x93 * var_chaste_interface__ICaL_d_gate__d;
            const double var_x101 = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_SL;
            const double var_x123 = var_x61 - var_x63;
            const double var_x135 = var_x97 * var_chaste_interface__cell__V;
            const double var_x136 = var_x135 * var_x88;
            const double var_x137 = var_x101 * var_x136;
            const double var_x174 = var_x38 * var_x82;
            const double var_x175 = pow(var_chaste_interface__Na_buffer__Na_SL, 2.0);
            const double var_x176 = 3.0 * mParameters[4];
            const double var_x177 = 5.8017639429904805e-6 * var_x45;
            const double var_x178 = -3.9000000000000004 * var_x175 - var_x175 * var_x176 - var_x175 * var_x177;
            const double var_x179 = 5.3588338192419823e-9 * var_x45;
            const double var_x180 = var_x123 * var_x49;
            const double var_x181 = var_x180 * var_x65 / pow((var_x66 + 1.9405247813411081e-6 * var_x59 + 1.4927113702623908e-6 * var_x60 + 1.4927113702623908e-6 * var_x62 + var_x179 * var_x67), 2);
            const double var_x183 = var_x79 / var_x78;
            const double var_x184 = var_x183 * var_x82 * var_x83 / pow((6.8301345536507063e-5 + var_x83), 2);
            const double var_x185 = var_x40 * mParameters[4];
            const double var_x186 = var_x175 * var_x185 * var_x70;
            const double var_x350 = 0.0001 * var_chaste_interface__Na_buffer__Na_SL_buf;
            const double var_x351 = 1.2899391426308094e-14 * var_x181;
            
            partialF = -2.5101556644976917 + var_x350 - 0.017367559454884197 * var_x186 - 1.5310180739595352e-5 * var_x82 - 3.9646379347775894e-9 * var_x137 - 3.0164820906368501e-6 * var_x184 - 0.051549430099647651 * var_x174 - var_x178 * var_x351;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__INa_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.9867005
        double var_chaste_interface__INa_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.991562
        double var_chaste_interface__INa_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.001405627
        double var_chaste_interface__ICaL_d_gate__d = rY[12];
        // Units: dimensionless; Initial value: 7.175662e-06
        double var_chaste_interface__ICaL_f_gate__f = rY[13];
        // Units: dimensionless; Initial value: 1.000681
        double var_chaste_interface__ICaL_fCa_gate__fCaB_jct = rY[15];
        // Units: dimensionless; Initial value: 0.02421991
        double var_chaste_interface__Na_buffer__Na_SL = rY[19];
        // Units: millimolar; Initial value: 8.80733
        double var_chaste_interface__Na_buffer__Na_jct = rY[20];
        // Units: millimolar; Initial value: 8.80329
        double var_chaste_interface__Na_buffer__Na_jct_buf = rY[22];
        // Units: millimolar; Initial value: 3.539892
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        
        
        // Mathematics
        const double var_ICaL__Fx_ICaL_jct = 0.90000000000000002; // dimensionless
        const double var_ICaL__PNa = 1.4999999999999999e-8; // litre_per_farad_millisecond
        const double var_ICaL__Q10_CaL = 1.8; // dimensionless
        const double var_ICaL__gamma_Nai = 0.75; // dimensionless
        const double var_ICaL__gamma_Nao = 0.75; // dimensionless
        const double var_ICaL_fCa_gate__fCa_jct = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_jct; // dimensionless
        const double var_INa__Fx_Na_jct = 0.11; // dimensionless
        const double var_INaCa__Fx_NCX_jct = 0.11; // dimensionless
        const double var_INaCa__HNa = 3.0; // dimensionless
        const double var_INaCa__K_mCai = 0.0035899999999999999; // millimolar
        const double var_INaCa__K_mCao = 1.3; // millimolar
        const double var_INaCa__K_mNai = 12.289999999999999; // millimolar
        const double var_INaCa__K_mNao = 87.5; // millimolar
        const double var_INaCa__Kd_act = 0.00025599999999999999; // millimolar
        const double var_INaCa__Ka_jct = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_jct, 3)); // dimensionless
        const double var_INaCa__Q10_NCX = 1.5700000000000001; // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_INaK__Fx_NaK_jct = 0.11; // dimensionless
        const double var_INaK__H_NaK = 4.0; // dimensionless
        const double var_INaK__I_NaK_max = 1.9071899999999999; // microA_per_microF
        const double var_INaK__Km_Ko = 1.5; // millimolar
        const double var_INaK__Km_Nai = 11.0; // millimolar
        const double var_INa__openProb = pow(var_chaste_interface__INa_m_gate__m, 3) * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // dimensionless
        const double var_INab__Fx_NaBk_jct = 0.11; // dimensionless
        const double var_INab__G_NaBk = 0.00029700000000000001; // milliS_per_microF
        const double var_Na_buffer__Bmax_jct = 7.5609999999999999; // millimolar
        const double var_Na_buffer__koff = 0.001; // per_millisecond
        const double var_Na_buffer__kon = 0.0001; // per_millimolar_per_millisecond
        const double var_Na_buffer__dNa_jct_buf = -var_chaste_interface__Na_buffer__Na_jct_buf * var_Na_buffer__koff + (-var_chaste_interface__Na_buffer__Na_jct_buf + var_Na_buffer__Bmax_jct) * var_chaste_interface__Na_buffer__Na_jct * var_Na_buffer__kon; // millimolar_per_millisecond
        const double var_ion_diffusion__J_Na_jct_SL = 1.8312999999999999e-14 * var_chaste_interface__Na_buffer__Na_jct - 1.8312999999999999e-14 * var_chaste_interface__Na_buffer__Na_SL; // millimole_per_millisecond
        const double var_model_parameters__Cm = 1.3809999999999999e-10; // farad
        const double var_model_parameters__F = 96485.0; // coulomb_per_mole
        const double var_INaK__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * mParameters[6]); // dimensionless
        const double var_model_parameters__R = 8314.2999999999993; // joule_per_kilomole_kelvin
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__Q_CaL = pow(var_ICaL__Q10_CaL, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICaL__temp = 0.45000000000000001 * pow(var_model_parameters__F, 2) * var_ICaL__Q_CaL * var_chaste_interface__ICaL_d_gate__d * var_chaste_interface__ICaL_f_gate__f * var_chaste_interface__cell__V / (var_model_parameters__R * var_model_parameters__T); // coulomb_per_mole
        const double var_ICaL__i_CaL_Na_jct = (-var_ICaL__gamma_Nao * mParameters[6] + var_ICaL__gamma_Nai * var_chaste_interface__Na_buffer__Na_jct * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_jct * var_ICaL__PNa * var_ICaL__temp * var_ICaL_fCa_gate__fCa_jct / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_INaCa__Q_NCX = pow(var_INaCa__Q10_NCX, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_INaCa__temp_jct = (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_jct = var_INaCa__Fx_NCX_jct * var_INaCa__Ka_jct * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_jct / (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_jct / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_jct + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_jct / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_INaK__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) + 0.036499999999999998 * var_INaK__sigma * exp(-var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // dimensionless
        const double var_INaK__i_NaK_jct = var_INaK__Fx_NaK_jct * var_INaK__I_NaK_max * var_INaK__f_NaK * mParameters[5] / ((1.0 + pow((var_INaK__Km_Nai / var_chaste_interface__Na_buffer__Na_jct), var_INaK__H_NaK)) * (var_INaK__Km_Ko + mParameters[5])); // microA_per_microF
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_jct = 0.00053900000000000009 * var_model_parameters__Vol_Cell; // liter
        const double var_reversal_potentials__E_Na_jct = var_model_parameters__R * var_model_parameters__T * log(mParameters[6] / var_chaste_interface__Na_buffer__Na_jct) / var_model_parameters__F; // millivolt
        const double var_INa__i_Na_jct = (-var_reversal_potentials__E_Na_jct + var_chaste_interface__cell__V) * var_INa__Fx_Na_jct * mParameters[8] * var_INa__openProb; // microA_per_microF
        const double var_INab__i_Nab_jct = (-var_reversal_potentials__E_Na_jct + var_chaste_interface__cell__V) * var_INab__Fx_NaBk_jct * var_INab__G_NaBk; // microA_per_microF
        const double d_dt_chaste_interface_var_Na_buffer__Na_jct = -var_Na_buffer__dNa_jct_buf - var_ion_diffusion__J_Na_jct_SL / var_model_parameters__Vol_jct - (3.0 * var_INaCa__i_NaCa_jct + 3.0 * var_INaK__i_NaK_jct + var_ICaL__i_CaL_Na_jct + var_INa__i_Na_jct + var_INab__i_Nab_jct) * var_model_parameters__Cm / (var_model_parameters__F * var_model_parameters__Vol_jct); // millimolar / millisecond

        return d_dt_chaste_interface_var_Na_buffer__Na_jct;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            double var_chaste_interface__INa_h_gate__h = rY[2];
            // Units: dimensionless; Initial value: 0.9867005
            double var_chaste_interface__INa_j_gate__j = rY[3];
            // Units: dimensionless; Initial value: 0.991562
            double var_chaste_interface__INa_m_gate__m = rY[4];
            // Units: dimensionless; Initial value: 0.001405627
            double var_chaste_interface__ICaL_d_gate__d = rY[12];
            // Units: dimensionless; Initial value: 7.175662e-06
            double var_chaste_interface__ICaL_f_gate__f = rY[13];
            // Units: dimensionless; Initial value: 1.000681
            double var_chaste_interface__ICaL_fCa_gate__fCaB_jct = rY[15];
            // Units: dimensionless; Initial value: 0.02421991
            double var_chaste_interface__Na_buffer__Na_jct = rY[20];
            // Units: millimolar; Initial value: 8.80329
            double var_chaste_interface__Na_buffer__Na_jct_buf = rY[22];
            // Units: millimolar; Initial value: 3.539892
            double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
            // Units: millimolar; Initial value: 0.0001737475
            
            const double var_x36 = pow(var_chaste_interface__INa_m_gate__m, 3);
            const double var_x37 = var_x36 * mParameters[8] * var_chaste_interface__INa_j_gate__j;
            const double var_x38 = var_x37 * var_chaste_interface__INa_h_gate__h;
            const double var_x40 = exp(0.013102086455787599 * var_chaste_interface__cell__V);
            const double var_x41 = pow(var_chaste_interface__Na_buffer__Na_jct, 3.0);
            const double var_x42 = var_x41 * mParameters[4];
            const double var_x43 = var_x40 * var_x42;
            const double var_x44 = exp(-0.024332446275034118 * var_chaste_interface__cell__V);
            const double var_x45 = pow(mParameters[6], 3.0);
            const double var_x46 = var_x45 * var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x47 = var_x44 * var_x46;
            const double var_x48 = 1.0 + 0.27000000000000002 * var_x44;
            const double var_x49 = mParameters[11] / var_x48;
            const double var_x50 = 1.0 + 1.6777215999999998e-11 / pow(var_chaste_interface__Ca_buffer__Ca_jct, 3);
            const double var_x51 = 1 / var_x50;
            const double var_x52 = (1.0 + 278.55153203342621 * var_chaste_interface__Ca_buffer__Ca_jct) * var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x53 = 1.0 + 0.00053869674493876331 * var_x41;
            const double var_x54 = 0.0035899999999999999 * var_x45;
            const double var_x55 = 1 / (var_x42 + var_x46 + 669921.875 * var_x52 + 1.3 * var_x41 + var_x53 * var_x54);
            const double var_x56 = var_x51 * var_x55;
            const double var_x57 = var_x49 * var_x56;
            const double var_x72 = 1 / var_chaste_interface__Na_buffer__Na_jct;
            const double var_x73 = pow(var_x72, 4.0);
            const double var_x74 = exp(-0.0037434532730821718 * var_chaste_interface__cell__V);
            const double var_x75 = exp(0.01485884101040119 * mParameters[6]);
            const double var_x76 = 0.037434532730821715 * var_chaste_interface__cell__V;
            const double var_x77 = exp(-var_x76);
            const double var_x78 = 1.0 + 0.1245 * var_x74 + 0.036499999999999998 * var_x77 * (-0.14285714285714285 + 0.14285714285714285 * var_x75);
            const double var_x79 = mParameters[5] / (1.5 + mParameters[5]);
            const double var_x85 = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_jct;
            const double var_x86 = var_x85 * var_chaste_interface__ICaL_d_gate__d;
            const double var_x88 = exp(var_x76);
            const double var_x91 = -1.0 + var_x88;
            const double var_x92 = 1 / var_x91;
            const double var_x93 = var_x92 * var_chaste_interface__ICaL_f_gate__f;
            const double var_x106 = var_x43 - var_x47;
            const double var_x132 = var_x93 * var_chaste_interface__cell__V;
            const double var_x133 = var_x132 * var_x86 * var_x88;
            const double var_x176 = 3.0 * mParameters[4];
            const double var_x177 = 5.8017639429904805e-6 * var_x45;
            const double var_x179 = 5.3588338192419823e-9 * var_x45;
            const double var_x183 = var_x79 / var_x78;
            const double var_x185 = var_x40 * mParameters[4];
            const double var_x187 = var_x38 * var_x72;
            const double var_x188 = pow(var_chaste_interface__Na_buffer__Na_jct, 2.0);
            const double var_x189 = -3.9000000000000004 * var_x188 - var_x176 * var_x188 - var_x177 * var_x188;
            const double var_x190 = var_x106 * var_x49;
            const double var_x191 = var_x190 * var_x51 / pow((var_x52 + 1.9405247813411081e-6 * var_x41 + 1.4927113702623908e-6 * var_x42 + 1.4927113702623908e-6 * var_x46 + var_x179 * var_x53), 2);
            const double var_x193 = var_x183 * var_x72 * var_x73 / pow((6.8301345536507063e-5 + var_x73), 2);
            const double var_x194 = var_x185 * var_x188 * var_x57;
            const double var_x356 = 0.0001 * var_chaste_interface__Na_buffer__Na_jct_buf;
            const double var_x357 = 5.9157951966558558e-14 * var_x191;
            
            partialF = -1.0301299389968197 + var_x356 - 1.3833900897210959e-5 * var_x193 - 7.0214082731462295e-5 * var_x72 - 0.079649435702289356 * var_x194 - 1.3239978260852802e-6 * var_x133 - 0.2364110529678865 * var_x187 - var_x189 * var_x357;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Na_buffer__Na_SL = rY[19];
        // Units: millimolar; Initial value: 8.80733
        double var_chaste_interface__Na_buffer__Na_SL_buf = rY[21];
        // Units: millimolar; Initial value: 0.7720854
        
        
        // Mathematics
        const double var_Na_buffer__Bmax_SL = 1.6499999999999999; // millimolar
        const double var_Na_buffer__koff = 0.001; // per_millisecond
        const double var_Na_buffer__kon = 0.0001; // per_millimolar_per_millisecond
        const double var_Na_buffer__dNa_SL_buf = -var_chaste_interface__Na_buffer__Na_SL_buf * var_Na_buffer__koff + (-var_chaste_interface__Na_buffer__Na_SL_buf + var_Na_buffer__Bmax_SL) * var_chaste_interface__Na_buffer__Na_SL * var_Na_buffer__kon; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Na_buffer__Na_SL_buf = var_Na_buffer__dNa_SL_buf; // millimolar / millisecond

        return d_dt_chaste_interface_var_Na_buffer__Na_SL_buf;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Na_buffer__Na_SL = rY[19];
            // Units: millimolar; Initial value: 8.80733
            
            const double var_x352 = 0.0001 * var_chaste_interface__Na_buffer__Na_SL;
            
            partialF = -0.001 - var_x352;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Na_buffer__Na_jct = rY[20];
        // Units: millimolar; Initial value: 8.80329
        double var_chaste_interface__Na_buffer__Na_jct_buf = rY[22];
        // Units: millimolar; Initial value: 3.539892
        
        
        // Mathematics
        const double var_Na_buffer__Bmax_jct = 7.5609999999999999; // millimolar
        const double var_Na_buffer__koff = 0.001; // per_millisecond
        const double var_Na_buffer__kon = 0.0001; // per_millimolar_per_millisecond
        const double var_Na_buffer__dNa_jct_buf = -var_chaste_interface__Na_buffer__Na_jct_buf * var_Na_buffer__koff + (-var_chaste_interface__Na_buffer__Na_jct_buf + var_Na_buffer__Bmax_jct) * var_chaste_interface__Na_buffer__Na_jct * var_Na_buffer__kon; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Na_buffer__Na_jct_buf = var_Na_buffer__dNa_jct_buf; // millimolar / millisecond

        return d_dt_chaste_interface_var_Na_buffer__Na_jct_buf;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Na_buffer__Na_jct = rY[20];
            // Units: millimolar; Initial value: 8.80329
            
            const double var_x358 = 0.0001 * var_chaste_interface__Na_buffer__Na_jct;
            
            partialF = -0.001 - var_x358;
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Na_buffer__Na_SL = rY[19];
        // Units: millimolar; Initial value: 8.80733
        double var_chaste_interface__Na_buffer__Nai = rY[23];
        // Units: millimolar; Initial value: 8.80853
        
        
        // Mathematics
        const double var_ion_diffusion__J_Na_SL_myo = 1.6385999999999999e-12 * var_chaste_interface__Na_buffer__Na_SL - 1.6385999999999999e-12 * var_chaste_interface__Na_buffer__Nai; // millimole_per_millisecond
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_myo = 0.65000000000000002 * var_model_parameters__Vol_Cell; // liter
        const double d_dt_chaste_interface_var_Na_buffer__Nai = var_ion_diffusion__J_Na_SL_myo / var_model_parameters__Vol_myo; // millimolar / millisecond

        return d_dt_chaste_interface_var_Na_buffer__Nai;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.076376893524206985;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_buffer__Cai = rY[1];
        // Units: millimolar; Initial value: 8.597401e-05
        double var_chaste_interface__Jrel_SR__O = rY[18];
        // Units: dimensionless; Initial value: 8.156628e-07
        double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
        // Units: millimolar; Initial value: 0.5545201
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        double var_chaste_interface__Ca_buffer__Ca_Calsequestrin = rY[31];
        // Units: millimolar; Initial value: 1.242988
        
        
        // Mathematics
        const double var_Ca_buffer__Bmax_Calsequestrin = 0.14000000000000001; // millimolar
        const double var_Ca_buffer__koff_Calsequestrin = 65.0; // per_millisecond
        const double var_Ca_buffer__kon_Calsequestrin = 100.0; // per_millimolar_per_millisecond
        const double var_Jleak_SR__j_leak_SR = (-var_chaste_interface__Ca_buffer__Ca_jct + var_chaste_interface__Ca_buffer__Ca_SR) * mParameters[0]; // millimolar_per_millisecond
        const double var_Jpump_SR__H = 1.7869999999999999; // dimensionless
        const double var_Jpump_SR__Kmf = 0.00024600000000000002; // millimolar
        const double var_Jpump_SR__Kmr = 1.7; // millimolar
        const double var_Jpump_SR__Q10_SRCaP = 2.6000000000000001; // dimensionless
        const double var_Jrel_SR__j_rel_SR = (-var_chaste_interface__Ca_buffer__Ca_jct + var_chaste_interface__Ca_buffer__Ca_SR) * var_chaste_interface__Jrel_SR__O * mParameters[1]; // millimolar_per_millisecond
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_Jpump_SR__Q_SRCaP = pow(var_Jpump_SR__Q10_SRCaP, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_Jpump_SR__j_pump_SR = (pow((var_chaste_interface__Ca_buffer__Cai / var_Jpump_SR__Kmf), var_Jpump_SR__H) - pow((var_chaste_interface__Ca_buffer__Ca_SR / var_Jpump_SR__Kmr), var_Jpump_SR__H)) * var_Jpump_SR__Q_SRCaP * mParameters[2] / (1.0 + pow((var_chaste_interface__Ca_buffer__Cai / var_Jpump_SR__Kmf), var_Jpump_SR__H) + pow((var_chaste_interface__Ca_buffer__Ca_SR / var_Jpump_SR__Kmr), var_Jpump_SR__H)); // millimolar_per_millisecond
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_SR = 0.035000000000000003 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_myo = 0.65000000000000002 * var_model_parameters__Vol_Cell; // liter
        const double var_Ca_buffer__dCalsequestrin = -var_chaste_interface__Ca_buffer__Ca_Calsequestrin * var_Ca_buffer__koff_Calsequestrin + (-var_chaste_interface__Ca_buffer__Ca_Calsequestrin + var_Ca_buffer__Bmax_Calsequestrin * var_model_parameters__Vol_myo / var_model_parameters__Vol_SR) * var_chaste_interface__Ca_buffer__Ca_SR * var_Ca_buffer__kon_Calsequestrin; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_SR = -var_Ca_buffer__dCalsequestrin - var_Jrel_SR__j_rel_SR - var_Jleak_SR__j_leak_SR * var_model_parameters__Vol_myo / var_model_parameters__Vol_SR + var_Jpump_SR__j_pump_SR; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_buffer__Ca_SR;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Cai = rY[1];
            // Units: millimolar; Initial value: 8.597401e-05
            double var_chaste_interface__Jrel_SR__O = rY[18];
            // Units: dimensionless; Initial value: 8.156628e-07
            double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
            // Units: millimolar; Initial value: 0.5545201
            double var_chaste_interface__Ca_buffer__Ca_Calsequestrin = rY[31];
            // Units: millimolar; Initial value: 1.242988
            
            const double var_x218 = pow(var_chaste_interface__Ca_buffer__Ca_SR, 1.7869999999999999);
            const double var_x219 = 0.38742512113256738 * var_x218;
            const double var_x220 = pow(var_chaste_interface__Ca_buffer__Cai, 1.7869999999999999);
            const double var_x221 = 2814485.1633595936 * var_x220;
            const double var_x222 = mParameters[2] / (1.0 + var_x219 + var_x221);
            const double var_x224 = (var_x221 - var_x219) * mParameters[2] / pow((3.5530476870814998e-7 + var_x220 + 1.3765399305573384e-7 * var_x218), 2);
            const double var_x226 = pow(var_chaste_interface__Ca_buffer__Ca_SR, 0.78699999999999992);
            const double var_x227 = var_x222 * var_x226;
            const double var_x228 = var_x224 * var_x226;
            const double var_x359 = 100.0 * var_chaste_interface__Ca_buffer__Ca_Calsequestrin;
            const double var_x360 = 18.571428571428569 * mParameters[0];
            const double var_x361 = var_chaste_interface__Jrel_SR__O * mParameters[1];
            
            partialF = -260.0 + var_x359 - var_x360 - var_x361 - 0.69232869146389786 * var_x227 - 8.7400597733819945e-14 * var_x228;
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__Ca_buffer__Cai = rY[1];
        // Units: millimolar; Initial value: 8.597401e-05
        double var_chaste_interface__ICaL_d_gate__d = rY[12];
        // Units: dimensionless; Initial value: 7.175662e-06
        double var_chaste_interface__ICaL_f_gate__f = rY[13];
        // Units: dimensionless; Initial value: 1.000681
        double var_chaste_interface__ICaL_fCa_gate__fCaB_SL = rY[14];
        // Units: dimensionless; Initial value: 0.01452605
        double var_chaste_interface__Na_buffer__Na_SL = rY[19];
        // Units: millimolar; Initial value: 8.80733
        double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
        // Units: millimolar; Initial value: 0.0001031812
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        double var_chaste_interface__Ca_buffer__Ca_SLB_SL = rY[27];
        // Units: millimolar; Initial value: 0.1110363
        double var_chaste_interface__Ca_buffer__Ca_SLHigh_SL = rY[29];
        // Units: millimolar; Initial value: 0.07297378
        
        
        // Mathematics
        const double var_Ca_buffer__Bmax_SLB_SL = 0.037400000000000003; // millimolar
        const double var_Ca_buffer__Bmax_SLHigh_SL = 0.0134; // millimolar
        const double var_Ca_buffer__koff_SLB = 1.3; // per_millisecond
        const double var_Ca_buffer__koff_SLHigh = 0.029999999999999999; // per_millisecond
        const double var_Ca_buffer__kon_SL = 100.0; // per_millimolar_per_millisecond
        const double var_ICaL__Fx_ICaL_SL = 0.10000000000000001; // dimensionless
        const double var_ICaL__Q10_CaL = 1.8; // dimensionless
        const double var_ICaL__gamma_Cai = 0.34100000000000003; // dimensionless
        const double var_ICaL__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_ICaL_fCa_gate__fCa_SL = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_SL; // dimensionless
        const double var_ICab__Fx_CaBk_SL = 0.89000000000000001; // dimensionless
        const double var_ICab__G_CaBk = 0.00025129999999999998; // milliS_per_microF
        const double var_ICap__Fx_SLCaP_SL = 0.89000000000000001; // dimensionless
        const double var_ICap__H = 1.6000000000000001; // dimensionless
        const double var_ICap__Km = 0.00050000000000000001; // millimolar
        const double var_ICap__Q10_SLCaP = 2.3500000000000001; // dimensionless
        const double var_ICap__V_maxAF = 0.067299999999999999; // microA_per_microF
        const double var_INaCa__Fx_NCX_SL = 0.89000000000000001; // dimensionless
        const double var_INaCa__HNa = 3.0; // dimensionless
        const double var_INaCa__K_mCai = 0.0035899999999999999; // millimolar
        const double var_INaCa__K_mCao = 1.3; // millimolar
        const double var_INaCa__K_mNai = 12.289999999999999; // millimolar
        const double var_INaCa__K_mNao = 87.5; // millimolar
        const double var_INaCa__Kd_act = 0.00025599999999999999; // millimolar
        const double var_INaCa__Ka_SL = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_SL, 3)); // dimensionless
        const double var_INaCa__Q10_NCX = 1.5700000000000001; // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_ion_diffusion__J_Ca_SL_myo = 3.7243000000000002e-12 * var_chaste_interface__Ca_buffer__Ca_SL - 3.7243000000000002e-12 * var_chaste_interface__Ca_buffer__Cai; // millimole_per_millisecond
        const double var_ion_diffusion__J_Ca_jct_SL = 8.2413000000000004e-13 * var_chaste_interface__Ca_buffer__Ca_jct - 8.2413000000000004e-13 * var_chaste_interface__Ca_buffer__Ca_SL; // millimole_per_millisecond
        const double var_model_parameters__Cm = 1.3809999999999999e-10; // farad
        const double var_model_parameters__F = 96485.0; // coulomb_per_mole
        const double var_model_parameters__R = 8314.2999999999993; // joule_per_kilomole_kelvin
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__Q_CaL = pow(var_ICaL__Q10_CaL, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICaL__temp = 0.45000000000000001 * pow(var_model_parameters__F, 2) * var_ICaL__Q_CaL * var_chaste_interface__ICaL_d_gate__d * var_chaste_interface__ICaL_f_gate__f * var_chaste_interface__cell__V / (var_model_parameters__R * var_model_parameters__T); // coulomb_per_mole
        const double var_ICaL__i_CaL_Ca_SL = 4.0 * (-var_ICaL__gamma_Cao * mParameters[4] + var_chaste_interface__Ca_buffer__Ca_SL * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_SL * mParameters[7] * var_ICaL__temp * var_ICaL_fCa_gate__fCa_SL / (-1.0 + exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICap__Q_SLCaP = pow(var_ICap__Q10_SLCaP, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICap__i_Cap_SL = var_ICap__Fx_SLCaP_SL * var_ICap__Q_SLCaP * var_ICap__V_maxAF / (1.0 + pow((var_ICap__Km / var_chaste_interface__Ca_buffer__Ca_SL), var_ICap__H)); // microA_per_microF
        const double var_INaCa__Q_NCX = pow(var_INaCa__Q10_NCX, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_INaCa__temp_SL = (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_SL = var_INaCa__Fx_NCX_SL * var_INaCa__Ka_SL * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_SL / (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_SL / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_SL + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_SL / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_SL = 0.02 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_myo = 0.65000000000000002 * var_model_parameters__Vol_Cell; // liter
        const double var_Ca_buffer__dCa_SLB_SL = -var_chaste_interface__Ca_buffer__Ca_SLB_SL * var_Ca_buffer__koff_SLB + (-var_chaste_interface__Ca_buffer__Ca_SLB_SL + var_Ca_buffer__Bmax_SLB_SL * var_model_parameters__Vol_myo / var_model_parameters__Vol_SL) * var_chaste_interface__Ca_buffer__Ca_SL * var_Ca_buffer__kon_SL; // millimolar_per_millisecond
        const double var_Ca_buffer__dCa_SLHigh_SL = -var_chaste_interface__Ca_buffer__Ca_SLHigh_SL * var_Ca_buffer__koff_SLHigh + (-var_chaste_interface__Ca_buffer__Ca_SLHigh_SL + var_Ca_buffer__Bmax_SLHigh_SL * var_model_parameters__Vol_myo / var_model_parameters__Vol_SL) * var_chaste_interface__Ca_buffer__Ca_SL * var_Ca_buffer__kon_SL; // millimolar_per_millisecond
        const double var_Ca_buffer__dCa_SL_tot_bound = var_Ca_buffer__dCa_SLB_SL + var_Ca_buffer__dCa_SLHigh_SL; // millimolar_per_millisecond
        const double var_reversal_potentials__E_Ca_SL = 0.5 * var_model_parameters__R * var_model_parameters__T * log(mParameters[4] / var_chaste_interface__Ca_buffer__Ca_SL) / var_model_parameters__F; // millivolt
        const double var_ICab__i_Cab_SL = (-var_reversal_potentials__E_Ca_SL + var_chaste_interface__cell__V) * var_ICab__Fx_CaBk_SL * var_ICab__G_CaBk; // microA_per_microF
        const double var_Ca_buffer__i_Ca_SL_tot = -2.0 * var_INaCa__i_NaCa_SL + var_ICaL__i_CaL_Ca_SL + var_ICab__i_Cab_SL + var_ICap__i_Cap_SL; // microA_per_microF
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_SL = -1.0 * var_Ca_buffer__dCa_SL_tot_bound + (-var_ion_diffusion__J_Ca_SL_myo + var_ion_diffusion__J_Ca_jct_SL) / var_model_parameters__Vol_SL - 0.5 * var_Ca_buffer__i_Ca_SL_tot * var_model_parameters__Cm / (var_model_parameters__F * var_model_parameters__Vol_SL); // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_buffer__Ca_SL;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            double var_chaste_interface__ICaL_d_gate__d = rY[12];
            // Units: dimensionless; Initial value: 7.175662e-06
            double var_chaste_interface__ICaL_f_gate__f = rY[13];
            // Units: dimensionless; Initial value: 1.000681
            double var_chaste_interface__ICaL_fCa_gate__fCaB_SL = rY[14];
            // Units: dimensionless; Initial value: 0.01452605
            double var_chaste_interface__Na_buffer__Na_SL = rY[19];
            // Units: millimolar; Initial value: 8.80733
            double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
            // Units: millimolar; Initial value: 0.0001031812
            double var_chaste_interface__Ca_buffer__Ca_SLB_SL = rY[27];
            // Units: millimolar; Initial value: 0.1110363
            double var_chaste_interface__Ca_buffer__Ca_SLHigh_SL = rY[29];
            // Units: millimolar; Initial value: 0.07297378
            
            const double var_x4 = 1 / var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x40 = exp(0.013102086455787599 * var_chaste_interface__cell__V);
            const double var_x44 = exp(-0.024332446275034118 * var_chaste_interface__cell__V);
            const double var_x45 = pow(mParameters[6], 3.0);
            const double var_x48 = 1.0 + 0.27000000000000002 * var_x44;
            const double var_x49 = mParameters[11] / var_x48;
            const double var_x54 = 0.0035899999999999999 * var_x45;
            const double var_x59 = pow(var_chaste_interface__Na_buffer__Na_SL, 3.0);
            const double var_x60 = var_x59 * mParameters[4];
            const double var_x61 = var_x40 * var_x60;
            const double var_x62 = var_x45 * var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x63 = var_x44 * var_x62;
            const double var_x64 = 1.0 + 1.6777215999999998e-11 / pow(var_chaste_interface__Ca_buffer__Ca_SL, 3);
            const double var_x65 = 1 / var_x64;
            const double var_x66 = (1.0 + 278.55153203342621 * var_chaste_interface__Ca_buffer__Ca_SL) * var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x67 = 1.0 + 0.00053869674493876331 * var_x59;
            const double var_x68 = 1 / (var_x60 + var_x62 + 669921.875 * var_x66 + 1.3 * var_x59 + var_x54 * var_x67);
            const double var_x69 = var_x65 * var_x68;
            const double var_x70 = var_x49 * var_x69;
            const double var_x101 = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_SL;
            const double var_x109 = exp(0.07486906546164343 * var_chaste_interface__cell__V);
            const double var_x110 = -1.0 + var_x109;
            const double var_x111 = mParameters[7] / var_x110;
            const double var_x112 = var_chaste_interface__ICaL_d_gate__d * var_chaste_interface__ICaL_f_gate__f;
            const double var_x113 = var_x111 * var_x112;
            const double var_x123 = var_x61 - var_x63;
            const double var_x142 = var_x113 * var_chaste_interface__cell__V;
            const double var_x143 = var_x101 * var_x109 * var_x142;
            const double var_x179 = 5.3588338192419823e-9 * var_x45;
            const double var_x180 = var_x123 * var_x49;
            const double var_x181 = var_x180 * var_x65 / pow((var_x66 + 1.9405247813411081e-6 * var_x59 + 1.4927113702623908e-6 * var_x60 + 1.4927113702623908e-6 * var_x62 + var_x179 * var_x67), 2);
            const double var_x196 = pow(var_x4, 1.6000000000000001);
            const double var_x197 = var_x196 * var_x4 / pow((1.0 + 5.2281977629563632e-6 * var_x196), 2);
            const double var_x198 = var_x44 * var_x45;
            const double var_x199 = var_x198 * var_x70;
            const double var_x200 = var_x180 * var_x68 / (pow(var_x64, 2) * pow(var_chaste_interface__Ca_buffer__Ca_SL, 4));
            const double var_x201 = -669921.875 - var_x45;
            const double var_x202 = var_x201 - 373215529.24791086 * var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x364 = 4.2997971421026984e-15 * var_x181;
            const double var_x365 = 100.0 * var_chaste_interface__Ca_buffer__Ca_SLB_SL;
            const double var_x366 = 100.0 * var_chaste_interface__Ca_buffer__Ca_SLHigh_SL;
            
            partialF = -171.99023312516786 + var_x365 + var_x366 + 9.7126432122478125e-14 * var_x200 - 5.4319197230928918e-10 * var_x197 - 3.2385929460103637e-6 * var_x4 - 0.24034516191273925 * var_x143 - 0.0019297288283204664 * var_x199 + var_x202 * var_x364;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__ICaL_d_gate__d = rY[12];
        // Units: dimensionless; Initial value: 7.175662e-06
        double var_chaste_interface__ICaL_f_gate__f = rY[13];
        // Units: dimensionless; Initial value: 1.000681
        double var_chaste_interface__ICaL_fCa_gate__fCaB_jct = rY[15];
        // Units: dimensionless; Initial value: 0.02421991
        double var_chaste_interface__Jrel_SR__O = rY[18];
        // Units: dimensionless; Initial value: 8.156628e-07
        double var_chaste_interface__Na_buffer__Na_jct = rY[20];
        // Units: millimolar; Initial value: 8.80329
        double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
        // Units: millimolar; Initial value: 0.5545201
        double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
        // Units: millimolar; Initial value: 0.0001031812
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        double var_chaste_interface__Ca_buffer__Ca_SLB_jct = rY[28];
        // Units: millimolar; Initial value: 0.009566355
        double var_chaste_interface__Ca_buffer__Ca_SLHigh_jct = rY[30];
        // Units: millimolar; Initial value: 0.007347888
        
        
        // Mathematics
        const double var_Ca_buffer__Bmax_SLB_jct = 0.0045999999999999999; // millimolar
        const double var_Ca_buffer__Bmax_SLHigh_jct = 0.00165; // millimolar
        const double var_Ca_buffer__koff_SLB = 1.3; // per_millisecond
        const double var_Ca_buffer__koff_SLHigh = 0.029999999999999999; // per_millisecond
        const double var_Ca_buffer__kon_SL = 100.0; // per_millimolar_per_millisecond
        const double var_ICaL__Fx_ICaL_jct = 0.90000000000000002; // dimensionless
        const double var_ICaL__Q10_CaL = 1.8; // dimensionless
        const double var_ICaL__gamma_Cai = 0.34100000000000003; // dimensionless
        const double var_ICaL__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_ICaL_fCa_gate__fCa_jct = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_jct; // dimensionless
        const double var_ICab__Fx_CaBk_jct = 0.11; // dimensionless
        const double var_ICab__G_CaBk = 0.00025129999999999998; // milliS_per_microF
        const double var_ICap__Fx_SLCaP_jct = 0.11; // dimensionless
        const double var_ICap__H = 1.6000000000000001; // dimensionless
        const double var_ICap__Km = 0.00050000000000000001; // millimolar
        const double var_ICap__Q10_SLCaP = 2.3500000000000001; // dimensionless
        const double var_ICap__V_maxAF = 0.067299999999999999; // microA_per_microF
        const double var_INaCa__Fx_NCX_jct = 0.11; // dimensionless
        const double var_INaCa__HNa = 3.0; // dimensionless
        const double var_INaCa__K_mCai = 0.0035899999999999999; // millimolar
        const double var_INaCa__K_mCao = 1.3; // millimolar
        const double var_INaCa__K_mNai = 12.289999999999999; // millimolar
        const double var_INaCa__K_mNao = 87.5; // millimolar
        const double var_INaCa__Kd_act = 0.00025599999999999999; // millimolar
        const double var_INaCa__Ka_jct = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_jct, 3)); // dimensionless
        const double var_INaCa__Q10_NCX = 1.5700000000000001; // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_Jleak_SR__j_leak_SR = (-var_chaste_interface__Ca_buffer__Ca_jct + var_chaste_interface__Ca_buffer__Ca_SR) * mParameters[0]; // millimolar_per_millisecond
        const double var_Jrel_SR__j_rel_SR = (-var_chaste_interface__Ca_buffer__Ca_jct + var_chaste_interface__Ca_buffer__Ca_SR) * var_chaste_interface__Jrel_SR__O * mParameters[1]; // millimolar_per_millisecond
        const double var_ion_diffusion__J_Ca_jct_SL = 8.2413000000000004e-13 * var_chaste_interface__Ca_buffer__Ca_jct - 8.2413000000000004e-13 * var_chaste_interface__Ca_buffer__Ca_SL; // millimole_per_millisecond
        const double var_model_parameters__Cm = 1.3809999999999999e-10; // farad
        const double var_model_parameters__F = 96485.0; // coulomb_per_mole
        const double var_model_parameters__R = 8314.2999999999993; // joule_per_kilomole_kelvin
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__Q_CaL = pow(var_ICaL__Q10_CaL, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICaL__temp = 0.45000000000000001 * pow(var_model_parameters__F, 2) * var_ICaL__Q_CaL * var_chaste_interface__ICaL_d_gate__d * var_chaste_interface__ICaL_f_gate__f * var_chaste_interface__cell__V / (var_model_parameters__R * var_model_parameters__T); // coulomb_per_mole
        const double var_ICaL__i_CaL_Ca_jct = 4.0 * (-var_ICaL__gamma_Cao * mParameters[4] + var_chaste_interface__Ca_buffer__Ca_jct * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_jct * mParameters[7] * var_ICaL__temp * var_ICaL_fCa_gate__fCa_jct / (-1.0 + exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICap__Q_SLCaP = pow(var_ICap__Q10_SLCaP, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICap__i_Cap_jct = var_ICap__Fx_SLCaP_jct * var_ICap__Q_SLCaP * var_ICap__V_maxAF / (1.0 + pow((var_ICap__Km / var_chaste_interface__Ca_buffer__Ca_jct), var_ICap__H)); // microA_per_microF
        const double var_INaCa__Q_NCX = pow(var_INaCa__Q10_NCX, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_INaCa__temp_jct = (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_jct = var_INaCa__Fx_NCX_jct * var_INaCa__Ka_jct * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_jct / (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_jct / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_jct + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_jct / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_SR = 0.035000000000000003 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_jct = 0.00053900000000000009 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_myo = 0.65000000000000002 * var_model_parameters__Vol_Cell; // liter
        const double var_Ca_buffer__dCa_SLB_jct = -var_chaste_interface__Ca_buffer__Ca_SLB_jct * var_Ca_buffer__koff_SLB + (-var_chaste_interface__Ca_buffer__Ca_SLB_jct + 0.10000000000000001 * var_Ca_buffer__Bmax_SLB_jct * var_model_parameters__Vol_myo / var_model_parameters__Vol_jct) * var_chaste_interface__Ca_buffer__Ca_jct * var_Ca_buffer__kon_SL; // millimolar_per_millisecond
        const double var_Ca_buffer__dCa_SLHigh_jct = -var_chaste_interface__Ca_buffer__Ca_SLHigh_jct * var_Ca_buffer__koff_SLHigh + (-var_chaste_interface__Ca_buffer__Ca_SLHigh_jct + 0.10000000000000001 * var_Ca_buffer__Bmax_SLHigh_jct * var_model_parameters__Vol_myo / var_model_parameters__Vol_jct) * var_chaste_interface__Ca_buffer__Ca_jct * var_Ca_buffer__kon_SL; // millimolar_per_millisecond
        const double var_Ca_buffer__dCa_jct_tot_bound = var_Ca_buffer__dCa_SLB_jct + var_Ca_buffer__dCa_SLHigh_jct; // millimolar_per_millisecond
        const double var_reversal_potentials__E_Ca_jct = 0.5 * var_model_parameters__R * var_model_parameters__T * log(mParameters[4] / var_chaste_interface__Ca_buffer__Ca_jct) / var_model_parameters__F; // millivolt
        const double var_ICab__i_Cab_jct = (-var_reversal_potentials__E_Ca_jct + var_chaste_interface__cell__V) * var_ICab__Fx_CaBk_jct * var_ICab__G_CaBk; // microA_per_microF
        const double var_Ca_buffer__i_Ca_jct_tot = -2.0 * var_INaCa__i_NaCa_jct + var_ICaL__i_CaL_Ca_jct + var_ICab__i_Cab_jct + var_ICap__i_Cap_jct; // microA_per_microF
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_jct = -1.0 * var_Ca_buffer__dCa_jct_tot_bound - var_ion_diffusion__J_Ca_jct_SL / var_model_parameters__Vol_jct + var_Jleak_SR__j_leak_SR * var_model_parameters__Vol_myo / var_model_parameters__Vol_jct + var_Jrel_SR__j_rel_SR * var_model_parameters__Vol_SR / var_model_parameters__Vol_jct - 0.5 * var_Ca_buffer__i_Ca_jct_tot * var_model_parameters__Cm / (var_model_parameters__F * var_model_parameters__Vol_jct); // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_buffer__Ca_jct;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -85.56885
            double var_chaste_interface__ICaL_d_gate__d = rY[12];
            // Units: dimensionless; Initial value: 7.175662e-06
            double var_chaste_interface__ICaL_f_gate__f = rY[13];
            // Units: dimensionless; Initial value: 1.000681
            double var_chaste_interface__ICaL_fCa_gate__fCaB_jct = rY[15];
            // Units: dimensionless; Initial value: 0.02421991
            double var_chaste_interface__Jrel_SR__O = rY[18];
            // Units: dimensionless; Initial value: 8.156628e-07
            double var_chaste_interface__Na_buffer__Na_jct = rY[20];
            // Units: millimolar; Initial value: 8.80329
            double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
            // Units: millimolar; Initial value: 0.0001737475
            double var_chaste_interface__Ca_buffer__Ca_SLB_jct = rY[28];
            // Units: millimolar; Initial value: 0.009566355
            double var_chaste_interface__Ca_buffer__Ca_SLHigh_jct = rY[30];
            // Units: millimolar; Initial value: 0.007347888
            
            const double var_x2 = 1 / var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x40 = exp(0.013102086455787599 * var_chaste_interface__cell__V);
            const double var_x41 = pow(var_chaste_interface__Na_buffer__Na_jct, 3.0);
            const double var_x42 = var_x41 * mParameters[4];
            const double var_x43 = var_x40 * var_x42;
            const double var_x44 = exp(-0.024332446275034118 * var_chaste_interface__cell__V);
            const double var_x45 = pow(mParameters[6], 3.0);
            const double var_x46 = var_x45 * var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x47 = var_x44 * var_x46;
            const double var_x48 = 1.0 + 0.27000000000000002 * var_x44;
            const double var_x49 = mParameters[11] / var_x48;
            const double var_x50 = 1.0 + 1.6777215999999998e-11 / pow(var_chaste_interface__Ca_buffer__Ca_jct, 3);
            const double var_x51 = 1 / var_x50;
            const double var_x52 = (1.0 + 278.55153203342621 * var_chaste_interface__Ca_buffer__Ca_jct) * var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x53 = 1.0 + 0.00053869674493876331 * var_x41;
            const double var_x54 = 0.0035899999999999999 * var_x45;
            const double var_x55 = 1 / (var_x42 + var_x46 + 669921.875 * var_x52 + 1.3 * var_x41 + var_x53 * var_x54);
            const double var_x56 = var_x51 * var_x55;
            const double var_x57 = var_x49 * var_x56;
            const double var_x85 = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_jct;
            const double var_x86 = var_x85 * var_chaste_interface__ICaL_d_gate__d;
            const double var_x106 = var_x43 - var_x47;
            const double var_x109 = exp(0.07486906546164343 * var_chaste_interface__cell__V);
            const double var_x110 = -1.0 + var_x109;
            const double var_x111 = mParameters[7] / var_x110;
            const double var_x121 = var_x111 * var_chaste_interface__ICaL_f_gate__f;
            const double var_x122 = var_x121 * var_x86;
            const double var_x145 = var_x109 * var_x122 * var_chaste_interface__cell__V;
            const double var_x179 = 5.3588338192419823e-9 * var_x45;
            const double var_x190 = var_x106 * var_x49;
            const double var_x191 = var_x190 * var_x51 / pow((var_x52 + 1.9405247813411081e-6 * var_x41 + 1.4927113702623908e-6 * var_x42 + 1.4927113702623908e-6 * var_x46 + var_x179 * var_x53), 2);
            const double var_x198 = var_x44 * var_x45;
            const double var_x201 = -669921.875 - var_x45;
            const double var_x205 = pow(var_x2, 1.6000000000000001);
            const double var_x206 = var_x2 * var_x205 / pow((1.0 + 5.2281977629563632e-6 * var_x205), 2);
            const double var_x207 = var_x198 * var_x57;
            const double var_x208 = var_x201 - 373215529.24791086 * var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x209 = var_x190 * var_x55 / (pow(var_x50, 2) * pow(var_chaste_interface__Ca_buffer__Ca_jct, 4));
            const double var_x361 = var_chaste_interface__Jrel_SR__O * mParameters[1];
            const double var_x369 = 1.9719317322186186e-14 * var_x191;
            const double var_x370 = 1205.9369202226344 * mParameters[0];
            const double var_x371 = 64.935064935064929 * var_x361;
            const double var_x372 = 100.0 * var_chaste_interface__Ca_buffer__Ca_SLB_jct;
            const double var_x373 = 100.0 * var_chaste_interface__Ca_buffer__Ca_SLHigh_jct;
            
            partialF = -121.69540971903938 + var_x372 + var_x373 - var_x370 - var_x371 + 4.4543192901847336e-13 * var_x209 - 1.4852524402707469e-5 * var_x2 - 0.0088499373002543739 * var_x207 - 80.263690434680996 * var_x145 - 2.4911349337733966e-9 * var_x206 + var_x208 * var_x369;
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative27(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
        // Units: millimolar; Initial value: 0.0001031812
        double var_chaste_interface__Ca_buffer__Ca_SLB_SL = rY[27];
        // Units: millimolar; Initial value: 0.1110363
        
        
        // Mathematics
        const double var_Ca_buffer__Bmax_SLB_SL = 0.037400000000000003; // millimolar
        const double var_Ca_buffer__koff_SLB = 1.3; // per_millisecond
        const double var_Ca_buffer__kon_SL = 100.0; // per_millimolar_per_millisecond
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_SL = 0.02 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_myo = 0.65000000000000002 * var_model_parameters__Vol_Cell; // liter
        const double var_Ca_buffer__dCa_SLB_SL = -var_chaste_interface__Ca_buffer__Ca_SLB_SL * var_Ca_buffer__koff_SLB + (-var_chaste_interface__Ca_buffer__Ca_SLB_SL + var_Ca_buffer__Bmax_SLB_SL * var_model_parameters__Vol_myo / var_model_parameters__Vol_SL) * var_chaste_interface__Ca_buffer__Ca_SL * var_Ca_buffer__kon_SL; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_SLB_SL = var_Ca_buffer__dCa_SLB_SL; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_buffer__Ca_SLB_SL;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative27(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
            // Units: millimolar; Initial value: 0.0001031812
            
            const double var_x367 = 100.0 * var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x375 = -var_x367;
            
            partialF = -1.3 + var_x375;
        }
        else
        {
            const double y_save = rY[27];
            rY[27] += delta;
            const double temp = EvaluateYDerivative27(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[27])/delta;
            rY[27] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative28(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        double var_chaste_interface__Ca_buffer__Ca_SLB_jct = rY[28];
        // Units: millimolar; Initial value: 0.009566355
        
        
        // Mathematics
        const double var_Ca_buffer__Bmax_SLB_jct = 0.0045999999999999999; // millimolar
        const double var_Ca_buffer__koff_SLB = 1.3; // per_millisecond
        const double var_Ca_buffer__kon_SL = 100.0; // per_millimolar_per_millisecond
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_jct = 0.00053900000000000009 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_myo = 0.65000000000000002 * var_model_parameters__Vol_Cell; // liter
        const double var_Ca_buffer__dCa_SLB_jct = -var_chaste_interface__Ca_buffer__Ca_SLB_jct * var_Ca_buffer__koff_SLB + (-var_chaste_interface__Ca_buffer__Ca_SLB_jct + 0.10000000000000001 * var_Ca_buffer__Bmax_SLB_jct * var_model_parameters__Vol_myo / var_model_parameters__Vol_jct) * var_chaste_interface__Ca_buffer__Ca_jct * var_Ca_buffer__kon_SL; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_SLB_jct = var_Ca_buffer__dCa_SLB_jct; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_buffer__Ca_SLB_jct;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative28(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
            // Units: millimolar; Initial value: 0.0001737475
            
            const double var_x374 = 100.0 * var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x376 = -var_x374;
            
            partialF = -1.3 + var_x376;
        }
        else
        {
            const double y_save = rY[28];
            rY[28] += delta;
            const double temp = EvaluateYDerivative28(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[28])/delta;
            rY[28] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative29(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
        // Units: millimolar; Initial value: 0.0001031812
        double var_chaste_interface__Ca_buffer__Ca_SLHigh_SL = rY[29];
        // Units: millimolar; Initial value: 0.07297378
        
        
        // Mathematics
        const double var_Ca_buffer__Bmax_SLHigh_SL = 0.0134; // millimolar
        const double var_Ca_buffer__koff_SLHigh = 0.029999999999999999; // per_millisecond
        const double var_Ca_buffer__kon_SL = 100.0; // per_millimolar_per_millisecond
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_SL = 0.02 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_myo = 0.65000000000000002 * var_model_parameters__Vol_Cell; // liter
        const double var_Ca_buffer__dCa_SLHigh_SL = -var_chaste_interface__Ca_buffer__Ca_SLHigh_SL * var_Ca_buffer__koff_SLHigh + (-var_chaste_interface__Ca_buffer__Ca_SLHigh_SL + var_Ca_buffer__Bmax_SLHigh_SL * var_model_parameters__Vol_myo / var_model_parameters__Vol_SL) * var_chaste_interface__Ca_buffer__Ca_SL * var_Ca_buffer__kon_SL; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_SLHigh_SL = var_Ca_buffer__dCa_SLHigh_SL; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_buffer__Ca_SLHigh_SL;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative29(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
            // Units: millimolar; Initial value: 0.0001031812
            
            const double var_x367 = 100.0 * var_chaste_interface__Ca_buffer__Ca_SL;
            const double var_x375 = -var_x367;
            
            partialF = -0.029999999999999999 + var_x375;
        }
        else
        {
            const double y_save = rY[29];
            rY[29] += delta;
            const double temp = EvaluateYDerivative29(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[29])/delta;
            rY[29] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative30(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        double var_chaste_interface__Ca_buffer__Ca_SLHigh_jct = rY[30];
        // Units: millimolar; Initial value: 0.007347888
        
        
        // Mathematics
        const double var_Ca_buffer__Bmax_SLHigh_jct = 0.00165; // millimolar
        const double var_Ca_buffer__koff_SLHigh = 0.029999999999999999; // per_millisecond
        const double var_Ca_buffer__kon_SL = 100.0; // per_millimolar_per_millisecond
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_jct = 0.00053900000000000009 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_myo = 0.65000000000000002 * var_model_parameters__Vol_Cell; // liter
        const double var_Ca_buffer__dCa_SLHigh_jct = -var_chaste_interface__Ca_buffer__Ca_SLHigh_jct * var_Ca_buffer__koff_SLHigh + (-var_chaste_interface__Ca_buffer__Ca_SLHigh_jct + 0.10000000000000001 * var_Ca_buffer__Bmax_SLHigh_jct * var_model_parameters__Vol_myo / var_model_parameters__Vol_jct) * var_chaste_interface__Ca_buffer__Ca_jct * var_Ca_buffer__kon_SL; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_SLHigh_jct = var_Ca_buffer__dCa_SLHigh_jct; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_buffer__Ca_SLHigh_jct;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative30(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
            // Units: millimolar; Initial value: 0.0001737475
            
            const double var_x374 = 100.0 * var_chaste_interface__Ca_buffer__Ca_jct;
            const double var_x376 = -var_x374;
            
            partialF = -0.029999999999999999 + var_x376;
        }
        else
        {
            const double y_save = rY[30];
            rY[30] += delta;
            const double temp = EvaluateYDerivative30(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[30])/delta;
            rY[30] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative31(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
        // Units: millimolar; Initial value: 0.5545201
        double var_chaste_interface__Ca_buffer__Ca_Calsequestrin = rY[31];
        // Units: millimolar; Initial value: 1.242988
        
        
        // Mathematics
        const double var_Ca_buffer__Bmax_Calsequestrin = 0.14000000000000001; // millimolar
        const double var_Ca_buffer__koff_Calsequestrin = 65.0; // per_millisecond
        const double var_Ca_buffer__kon_Calsequestrin = 100.0; // per_millimolar_per_millisecond
        const double var_model_parameters__cell_length = 100.0; // micrometre
        const double var_model_parameters__cell_radius = 10.25; // micrometre
        const double var_model_parameters__Vol_Cell = 3.1415926540000002e-15 * pow(var_model_parameters__cell_radius, 2) * var_model_parameters__cell_length; // liter
        const double var_model_parameters__Vol_SR = 0.035000000000000003 * var_model_parameters__Vol_Cell; // liter
        const double var_model_parameters__Vol_myo = 0.65000000000000002 * var_model_parameters__Vol_Cell; // liter
        const double var_Ca_buffer__dCalsequestrin = -var_chaste_interface__Ca_buffer__Ca_Calsequestrin * var_Ca_buffer__koff_Calsequestrin + (-var_chaste_interface__Ca_buffer__Ca_Calsequestrin + var_Ca_buffer__Bmax_Calsequestrin * var_model_parameters__Vol_myo / var_model_parameters__Vol_SR) * var_chaste_interface__Ca_buffer__Ca_SR * var_Ca_buffer__kon_Calsequestrin; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Ca_buffer__Ca_Calsequestrin = var_Ca_buffer__dCalsequestrin; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_buffer__Ca_Calsequestrin;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative31(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
            // Units: millimolar; Initial value: 0.5545201
            
            const double var_x362 = 100.0 * var_chaste_interface__Ca_buffer__Ca_SR;
            
            partialF = -65.0 - var_x362;
        }
        else
        {
            const double y_save = rY[31];
            rY[31] += delta;
            const double temp = EvaluateYDerivative31(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[31])/delta;
            rY[31] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative32(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_buffer__Cai = rY[1];
        // Units: millimolar; Initial value: 8.597401e-05
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC = rY[32];
        // Units: millimolar; Initial value: 0.008773191
        
        
        // Mathematics
        const double var_cytosolic_Ca_buffer__Bmax_TroponinC = 0.070000000000000007; // millimolar
        const double var_cytosolic_Ca_buffer__koff_TroponinC = 0.019599999999999999; // per_millisecond
        const double var_cytosolic_Ca_buffer__kon_TroponinC = 32.700000000000003; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_TroponinC = -var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC * var_cytosolic_Ca_buffer__koff_TroponinC + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC + var_cytosolic_Ca_buffer__Bmax_TroponinC) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_TroponinC; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_TroponinC = var_cytosolic_Ca_buffer__dCa_TroponinC; // millimolar / millisecond

        return d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_TroponinC;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative32(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Cai = rY[1];
            // Units: millimolar; Initial value: 8.597401e-05
            
            const double var_x229 = 32.700000000000003 * var_chaste_interface__Ca_buffer__Cai;
            
            partialF = -0.019599999999999999 - var_x229;
        }
        else
        {
            const double y_save = rY[32];
            rY[32] += delta;
            const double temp = EvaluateYDerivative32(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[32])/delta;
            rY[32] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative33(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_buffer__Cai = rY[1];
        // Units: millimolar; Initial value: 8.597401e-05
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg = rY[33];
        // Units: millimolar; Initial value: 0.1078283
        double var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg = rY[34];
        // Units: millimolar; Initial value: 0.01524002
        
        
        // Mathematics
        const double var_cytosolic_Ca_buffer__Bmax_TroponinC_Ca_Mg_Ca = 0.14000000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__koff_TroponinC_Ca_Mg_Ca = 3.1999999999999999e-5; // per_millisecond
        const double var_cytosolic_Ca_buffer__kon_TroponinC_Ca_Mg_Ca = 2.3700000000000001; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_TroponinC_Ca_Mg = -var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg * var_cytosolic_Ca_buffer__koff_TroponinC_Ca_Mg_Ca + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg - var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg + var_cytosolic_Ca_buffer__Bmax_TroponinC_Ca_Mg_Ca) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_TroponinC_Ca_Mg_Ca; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg = var_cytosolic_Ca_buffer__dCa_TroponinC_Ca_Mg; // millimolar / millisecond

        return d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative33(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Cai = rY[1];
            // Units: millimolar; Initial value: 8.597401e-05
            
            const double var_x230 = 2.3700000000000001 * var_chaste_interface__Ca_buffer__Cai;
            const double var_x377 = -var_x230;
            
            partialF = -3.1999999999999999e-5 + var_x377;
        }
        else
        {
            const double y_save = rY[33];
            rY[33] += delta;
            const double temp = EvaluateYDerivative33(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[33])/delta;
            rY[33] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative34(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg = rY[33];
        // Units: millimolar; Initial value: 0.1078283
        double var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg = rY[34];
        // Units: millimolar; Initial value: 0.01524002
        
        
        // Mathematics
        const double var_cytosolic_Ca_buffer__Bmax_TroponinC_Ca_Mg_Mg = 0.14000000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__koff_TroponinC_Ca_Mg_Mg = 0.0033300000000000001; // per_millisecond
        const double var_cytosolic_Ca_buffer__kon_TroponinC_Ca_Mg_Mg = 0.0030000000000000001; // per_millimolar_per_millisecond
        const double var_model_parameters__Mgi = 1.0; // millimolar
        const double var_cytosolic_Ca_buffer__dMg_TroponinC_Ca_Mg = -var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg * var_cytosolic_Ca_buffer__koff_TroponinC_Ca_Mg_Mg + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg - var_chaste_interface__cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg + var_cytosolic_Ca_buffer__Bmax_TroponinC_Ca_Mg_Mg) * var_cytosolic_Ca_buffer__kon_TroponinC_Ca_Mg_Mg * var_model_parameters__Mgi; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg = var_cytosolic_Ca_buffer__dMg_TroponinC_Ca_Mg; // millimolar / millisecond

        return d_dt_chaste_interface_var_cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative34(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.0063300000000000006;
        }
        else
        {
            const double y_save = rY[34];
            rY[34] += delta;
            const double temp = EvaluateYDerivative34(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[34])/delta;
            rY[34] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative35(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_buffer__Cai = rY[1];
        // Units: millimolar; Initial value: 8.597401e-05
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_Calmodulin = rY[35];
        // Units: millimolar; Initial value: 0.0002911916
        
        
        // Mathematics
        const double var_cytosolic_Ca_buffer__Bmax_Calmodulin = 0.024; // millimolar
        const double var_cytosolic_Ca_buffer__koff_Calmodulin = 0.23799999999999999; // per_millisecond
        const double var_cytosolic_Ca_buffer__kon_Calmodulin = 34.0; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_Calmodulin = -var_chaste_interface__cytosolic_Ca_buffer__Ca_Calmodulin * var_cytosolic_Ca_buffer__koff_Calmodulin + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_Calmodulin + var_cytosolic_Ca_buffer__Bmax_Calmodulin) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_Calmodulin; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_Calmodulin = var_cytosolic_Ca_buffer__dCa_Calmodulin; // millimolar / millisecond

        return d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_Calmodulin;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative35(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Cai = rY[1];
            // Units: millimolar; Initial value: 8.597401e-05
            
            const double var_x231 = 34.0 * var_chaste_interface__Ca_buffer__Cai;
            
            partialF = -0.23799999999999999 - var_x231;
        }
        else
        {
            const double y_save = rY[35];
            rY[35] += delta;
            const double temp = EvaluateYDerivative35(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[35])/delta;
            rY[35] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative36(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_buffer__Cai = rY[1];
        // Units: millimolar; Initial value: 8.597401e-05
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin = rY[36];
        // Units: millimolar; Initial value: 0.001298754
        double var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin = rY[37];
        // Units: millimolar; Initial value: 0.1381982
        
        
        // Mathematics
        const double var_cytosolic_Ca_buffer__Bmax_Myosin_Ca = 0.14000000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__koff_Myosin_Ca = 0.00046000000000000001; // per_millisecond
        const double var_cytosolic_Ca_buffer__kon_Myosin_Ca = 13.800000000000001; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_Myosin = -var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin * var_cytosolic_Ca_buffer__koff_Myosin_Ca + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin - var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin + var_cytosolic_Ca_buffer__Bmax_Myosin_Ca) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_Myosin_Ca; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_Myosin = var_cytosolic_Ca_buffer__dCa_Myosin; // millimolar / millisecond

        return d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_Myosin;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative36(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Cai = rY[1];
            // Units: millimolar; Initial value: 8.597401e-05
            
            const double var_x232 = 13.800000000000001 * var_chaste_interface__Ca_buffer__Cai;
            const double var_x378 = -var_x232;
            
            partialF = -0.00046000000000000001 + var_x378;
        }
        else
        {
            const double y_save = rY[36];
            rY[36] += delta;
            const double temp = EvaluateYDerivative36(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[36])/delta;
            rY[36] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative37(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin = rY[36];
        // Units: millimolar; Initial value: 0.001298754
        double var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin = rY[37];
        // Units: millimolar; Initial value: 0.1381982
        
        
        // Mathematics
        const double var_cytosolic_Ca_buffer__Bmax_Myosin_Mg = 0.14000000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__koff_Myosin_Mg = 5.7000000000000003e-5; // per_millisecond
        const double var_cytosolic_Ca_buffer__kon_Myosin_Mg = 0.015699999999999999; // per_millimolar_per_millisecond
        const double var_model_parameters__Mgi = 1.0; // millimolar
        const double var_cytosolic_Ca_buffer__dMg_Myosin = -var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin * var_cytosolic_Ca_buffer__koff_Myosin_Mg + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_Myosin - var_chaste_interface__cytosolic_Ca_buffer__Mg_Myosin + var_cytosolic_Ca_buffer__Bmax_Myosin_Mg) * var_cytosolic_Ca_buffer__kon_Myosin_Mg * var_model_parameters__Mgi; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Mg_Myosin = var_cytosolic_Ca_buffer__dMg_Myosin; // millimolar / millisecond

        return d_dt_chaste_interface_var_cytosolic_Ca_buffer__Mg_Myosin;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative37(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.015757;
        }
        else
        {
            const double y_save = rY[37];
            rY[37] += delta;
            const double temp = EvaluateYDerivative37(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[37])/delta;
            rY[37] = y_save;
        }
        return partialF;
    }
    double CellShannon2004FromCellMLGRL2::EvaluateYDerivative38(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_buffer__Cai = rY[1];
        // Units: millimolar; Initial value: 8.597401e-05
        double var_chaste_interface__cytosolic_Ca_buffer__Ca_SRB = rY[38];
        // Units: millimolar; Initial value: 0.002143165
        
        
        // Mathematics
        const double var_cytosolic_Ca_buffer__Bmax_SRB = 0.017100000000000001; // millimolar
        const double var_cytosolic_Ca_buffer__koff_SRB = 0.059999999999999998; // per_millisecond
        const double var_cytosolic_Ca_buffer__kon_SRB = 100.0; // per_millimolar_per_millisecond
        const double var_cytosolic_Ca_buffer__dCa_SRB = -var_chaste_interface__cytosolic_Ca_buffer__Ca_SRB * var_cytosolic_Ca_buffer__koff_SRB + (-var_chaste_interface__cytosolic_Ca_buffer__Ca_SRB + var_cytosolic_Ca_buffer__Bmax_SRB) * var_chaste_interface__Ca_buffer__Cai * var_cytosolic_Ca_buffer__kon_SRB; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_SRB = var_cytosolic_Ca_buffer__dCa_SRB; // millimolar / millisecond

        return d_dt_chaste_interface_var_cytosolic_Ca_buffer__Ca_SRB;
    }

    double CellShannon2004FromCellMLGRL2::EvaluatePartialDerivative38(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_buffer__Cai = rY[1];
            // Units: millimolar; Initial value: 8.597401e-05
            
            const double var_x233 = 100.0 * var_chaste_interface__Ca_buffer__Cai;
            
            partialF = -0.059999999999999998 - var_x233;
        }
        else
        {
            const double y_save = rY[38];
            rY[38] += delta;
            const double temp = EvaluateYDerivative38(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[38])/delta;
            rY[38] = y_save;
        }
        return partialF;
    }

    std::vector<double> CellShannon2004FromCellMLGRL2::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -85.56885
        double var_chaste_interface__INa_h_gate__h = rY[2];
        // Units: dimensionless; Initial value: 0.9867005
        double var_chaste_interface__INa_j_gate__j = rY[3];
        // Units: dimensionless; Initial value: 0.991562
        double var_chaste_interface__INa_m_gate__m = rY[4];
        // Units: dimensionless; Initial value: 0.001405627
        double var_chaste_interface__IKr_Xr_gate__Xr = rY[5];
        // Units: dimensionless; Initial value: 0.008641386
        double var_chaste_interface__IKs_Xs_gate__Xs = rY[6];
        // Units: dimensionless; Initial value: 0.005412034
        double var_chaste_interface__Itos_X_gate__X_tos = rY[7];
        // Units: dimensionless; Initial value: 0.004051574
        double var_chaste_interface__Itos_Y_gate__Y_tos = rY[8];
        // Units: dimensionless; Initial value: 0.9945511
        double var_chaste_interface__Itos_R_gate__R_tos = rY[9];
        // Units: dimensionless; Initial value: 0.9946
        double var_chaste_interface__ICaL_d_gate__d = rY[12];
        // Units: dimensionless; Initial value: 7.175662e-06
        double var_chaste_interface__ICaL_f_gate__f = rY[13];
        // Units: dimensionless; Initial value: 1.000681
        double var_chaste_interface__ICaL_fCa_gate__fCaB_SL = rY[14];
        // Units: dimensionless; Initial value: 0.01452605
        double var_chaste_interface__ICaL_fCa_gate__fCaB_jct = rY[15];
        // Units: dimensionless; Initial value: 0.02421991
        double var_chaste_interface__Jrel_SR__O = rY[18];
        // Units: dimensionless; Initial value: 8.156628e-07
        double var_chaste_interface__Na_buffer__Na_SL = rY[19];
        // Units: millimolar; Initial value: 8.80733
        double var_chaste_interface__Na_buffer__Na_jct = rY[20];
        // Units: millimolar; Initial value: 8.80329
        double var_chaste_interface__Na_buffer__Nai = rY[23];
        // Units: millimolar; Initial value: 8.80853
        double var_chaste_interface__Ca_buffer__Ca_SR = rY[24];
        // Units: millimolar; Initial value: 0.5545201
        double var_chaste_interface__Ca_buffer__Ca_SL = rY[25];
        // Units: millimolar; Initial value: 0.0001031812
        double var_chaste_interface__Ca_buffer__Ca_jct = rY[26];
        // Units: millimolar; Initial value: 0.0001737475
        

        // Mathematics
        const double var_ICaL__Fx_ICaL_SL = 0.10000000000000001; // dimensionless
        const double var_ICaL__Fx_ICaL_jct = 0.90000000000000002; // dimensionless
        const double var_ICaL__PK = 2.7000000000000001e-7; // litre_per_farad_millisecond
        const double var_ICaL__PNa = 1.4999999999999999e-8; // litre_per_farad_millisecond
        const double var_ICaL__Q10_CaL = 1.8; // dimensionless
        const double var_ICaL__gamma_Cai = 0.34100000000000003; // dimensionless
        const double var_ICaL__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_ICaL__gamma_Ki = 0.75; // dimensionless
        const double var_ICaL__gamma_Ko = 0.75; // dimensionless
        const double var_ICaL__gamma_Nai = 0.75; // dimensionless
        const double var_ICaL__gamma_Nao = 0.75; // dimensionless
        const double var_ICaL_fCa_gate__fCa_SL = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_SL; // dimensionless
        const double var_ICaL_fCa_gate__fCa_jct = 1.0 - var_chaste_interface__ICaL_fCa_gate__fCaB_jct; // dimensionless
        const double var_IKs__Fx_Ks_SL = 0.89000000000000001; // dimensionless
        const double var_IKs__Fx_Ks_jct = 0.11; // dimensionless
        const double var_IKs__pCa_SL = 3.0 - log10(var_chaste_interface__Ca_buffer__Ca_SL); // dimensionless
        const double var_IKs__G_Ks_SL = (0.057000000000000002 + 0.19 / (1.0 + exp(-12.0 + 1.6666666666666667 * var_IKs__pCa_SL))) * mParameters[10]; // milliS_per_microF
        const double var_IKs__pCa_jct = 3.0 - log10(var_chaste_interface__Ca_buffer__Ca_jct); // dimensionless
        const double var_IKs__G_Ks_jct = (0.057000000000000002 + 0.19 / (1.0 + exp(-12.0 + 1.6666666666666667 * var_IKs__pCa_jct))) * mParameters[10]; // milliS_per_microF
        const double var_IKs__pKNa = 0.018329999999999999; // dimensionless
        const double var_INa__Fx_Na_SL = 0.89000000000000001; // dimensionless
        const double var_INa__Fx_Na_jct = 0.11; // dimensionless
        const double var_INaCa__Fx_NCX_SL = 0.89000000000000001; // dimensionless
        const double var_INaCa__Fx_NCX_jct = 0.11; // dimensionless
        const double var_INaCa__HNa = 3.0; // dimensionless
        const double var_INaCa__K_mCai = 0.0035899999999999999; // millimolar
        const double var_INaCa__K_mCao = 1.3; // millimolar
        const double var_INaCa__K_mNai = 12.289999999999999; // millimolar
        const double var_INaCa__K_mNao = 87.5; // millimolar
        const double var_INaCa__Kd_act = 0.00025599999999999999; // millimolar
        const double var_INaCa__Ka_SL = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_SL, 3)); // dimensionless
        const double var_INaCa__Ka_jct = 1 / (1.0 + pow(var_INaCa__Kd_act, 3) / pow(var_chaste_interface__Ca_buffer__Ca_jct, 3)); // dimensionless
        const double var_INaCa__Q10_NCX = 1.5700000000000001; // dimensionless
        const double var_INaCa__eta = 0.34999999999999998; // dimensionless
        const double var_INaCa__ksat = 0.27000000000000002; // dimensionless
        const double var_INa__openProb = pow(var_chaste_interface__INa_m_gate__m, 3) * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // dimensionless
        const double var_Jrel_SR__j_rel_SR = (-var_chaste_interface__Ca_buffer__Ca_jct + var_chaste_interface__Ca_buffer__Ca_SR) * var_chaste_interface__Jrel_SR__O * mParameters[1]; // millimolar_per_millisecond
        const double var_ICaL_f_gate__tau_f = 1 / (0.02 + 0.019699999999999999 * exp(-0.23877882250000002 * pow((1 + 0.068965517241379309 * var_chaste_interface__cell__V), 2))); // millisecond
        const double var_IKr_Rr_gate__Rr = 1 / (1.0 + exp(1.4732142857142858 + 0.044642857142857144 * var_chaste_interface__cell__V)); // dimensionless
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_model_parameters__F = 96485.0; // coulomb_per_mole
        const double var_IK1__G_K1 = 0.3872983346207417 * sqrt(mParameters[5]); // milliS_per_microF
        const double var_IKr__G_IKr = 0.43033148291193518 * sqrt(mParameters[5]) * mParameters[9]; // milliS_per_microF
        const double var_model_parameters__R = 8314.2999999999993; // joule_per_kilomole_kelvin
        const double var_model_parameters__T = 310.0; // kelvin
        const double var_ICaL__Q_CaL = pow(var_ICaL__Q10_CaL, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_ICaL__temp = 0.45000000000000001 * pow(var_model_parameters__F, 2) * var_ICaL__Q_CaL * var_chaste_interface__ICaL_d_gate__d * var_chaste_interface__ICaL_f_gate__f * var_chaste_interface__cell__V / (var_model_parameters__R * var_model_parameters__T); // coulomb_per_mole
        const double var_ICaL__i_CaL_Ca_SL = 4.0 * (-var_ICaL__gamma_Cao * mParameters[4] + var_chaste_interface__Ca_buffer__Ca_SL * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_SL * mParameters[7] * var_ICaL__temp * var_ICaL_fCa_gate__fCa_SL / (-1.0 + exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Ca_jct = 4.0 * (-var_ICaL__gamma_Cao * mParameters[4] + var_chaste_interface__Ca_buffer__Ca_jct * var_ICaL__gamma_Cai * exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_jct * mParameters[7] * var_ICaL__temp * var_ICaL_fCa_gate__fCa_jct / (-1.0 + exp(2.0 * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_K = (var_ICaL__Fx_ICaL_SL * var_ICaL_fCa_gate__fCa_SL + var_ICaL__Fx_ICaL_jct * var_ICaL_fCa_gate__fCa_jct) * (-var_ICaL__gamma_Ko * mParameters[5] + var_ICaL__gamma_Ki * mParameters[3] * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__PK * var_ICaL__temp / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Na_SL = (-var_ICaL__gamma_Nao * mParameters[6] + var_ICaL__gamma_Nai * var_chaste_interface__Na_buffer__Na_SL * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_SL * var_ICaL__PNa * var_ICaL__temp * var_ICaL_fCa_gate__fCa_SL / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL_Na_jct = (-var_ICaL__gamma_Nao * mParameters[6] + var_ICaL__gamma_Nai * var_chaste_interface__Na_buffer__Na_jct * exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) * var_ICaL__Fx_ICaL_jct * var_ICaL__PNa * var_ICaL__temp * var_ICaL_fCa_gate__fCa_jct / (-1.0 + exp(var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // microA_per_microF
        const double var_ICaL__i_CaL = var_ICaL__i_CaL_Ca_SL + var_ICaL__i_CaL_Ca_jct + var_ICaL__i_CaL_K + var_ICaL__i_CaL_Na_SL + var_ICaL__i_CaL_Na_jct; // microA_per_microF
        const double var_ICaL__i_CaL_converted = HeartConfig::Instance()->GetCapacitance() * var_ICaL__i_CaL; // uA_per_cm2
        const double var_IKs__E_Ks = var_model_parameters__R * var_model_parameters__T * log((var_IKs__pKNa * mParameters[6] + mParameters[5]) / (var_IKs__pKNa * var_chaste_interface__Na_buffer__Nai + mParameters[3])) / var_model_parameters__F; // millivolt
        const double var_IKs__i_Ks_SL = pow(var_chaste_interface__IKs_Xs_gate__Xs, 2) * (-var_IKs__E_Ks + var_chaste_interface__cell__V) * var_IKs__Fx_Ks_SL * var_IKs__G_Ks_SL; // microA_per_microF
        const double var_IKs__i_Ks_jct = pow(var_chaste_interface__IKs_Xs_gate__Xs, 2) * (-var_IKs__E_Ks + var_chaste_interface__cell__V) * var_IKs__Fx_Ks_jct * var_IKs__G_Ks_jct; // microA_per_microF
        const double var_IKs__i_Ks = var_IKs__i_Ks_SL + var_IKs__i_Ks_jct; // microA_per_microF
        const double var_IKs__i_Ks_converted = HeartConfig::Instance()->GetCapacitance() * var_IKs__i_Ks; // uA_per_cm2
        const double var_INaCa__Q_NCX = pow(var_INaCa__Q10_NCX, (-31.0 + 0.10000000000000001 * var_model_parameters__T)); // dimensionless
        const double var_INaCa__temp_SL = (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_SL = var_INaCa__Fx_NCX_SL * var_INaCa__Ka_SL * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_SL / (pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_SL, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_SL + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_SL / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_SL + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_SL / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_INaCa__temp_jct = (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] * exp(var_INaCa__eta * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T)) - pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))) / (1.0 + var_INaCa__ksat * exp((-1.0 + var_INaCa__eta) * var_chaste_interface__cell__V * var_model_parameters__F / (var_model_parameters__R * var_model_parameters__T))); // millimolar4
        const double var_INaCa__i_NaCa_jct = var_INaCa__Fx_NCX_jct * var_INaCa__Ka_jct * var_INaCa__Q_NCX * mParameters[11] * var_INaCa__temp_jct / (pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * var_INaCa__K_mCao + pow(var_chaste_interface__Na_buffer__Na_jct, var_INaCa__HNa) * mParameters[4] + pow(mParameters[6], var_INaCa__HNa) * var_chaste_interface__Ca_buffer__Ca_jct + pow(var_INaCa__K_mNao, var_INaCa__HNa) * (1.0 + var_chaste_interface__Ca_buffer__Ca_jct / var_INaCa__K_mCai) * var_chaste_interface__Ca_buffer__Ca_jct + pow(mParameters[6], var_INaCa__HNa) * (1.0 + pow((var_chaste_interface__Na_buffer__Na_jct / var_INaCa__K_mNai), var_INaCa__HNa)) * var_INaCa__K_mCai); // microA_per_microF
        const double var_INaCa__i_NaCa = var_INaCa__i_NaCa_SL + var_INaCa__i_NaCa_jct; // microA_per_microF
        const double var_INaCa__i_NaCa_converted = HeartConfig::Instance()->GetCapacitance() * var_INaCa__i_NaCa; // uA_per_cm2
        const double var_reversal_potentials__E_K = var_model_parameters__R * var_model_parameters__T * log(mParameters[5] / mParameters[3]) / var_model_parameters__F; // millivolt
        const double var_IK1_K1_gate__alpha_K1 = 1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__cell__V - 0.23849999999999999 * var_reversal_potentials__E_K)); // per_millisecond
        const double var_IK1_K1_gate__beta_K1 = (exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__cell__V - 0.061749999999999999 * var_reversal_potentials__E_K) + 0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__cell__V - 0.080320000000000003 * var_reversal_potentials__E_K)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__E_K - 0.51429999999999998 * var_chaste_interface__cell__V)); // per_millisecond
        const double var_IK1_K1_gate__K1_infinity = var_IK1_K1_gate__alpha_K1 / (var_IK1_K1_gate__alpha_K1 + var_IK1_K1_gate__beta_K1); // dimensionless
        const double var_IK1__i_K1 = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IK1__G_K1 * var_IK1_K1_gate__K1_infinity; // microA_per_microF
        const double var_IK1__i_K1_converted = HeartConfig::Instance()->GetCapacitance() * var_IK1__i_K1; // uA_per_cm2
        const double var_IKr__i_Kr = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_IKr__G_IKr * var_IKr_Rr_gate__Rr * var_chaste_interface__IKr_Xr_gate__Xr; // microA_per_microF
        const double var_IKr__i_Kr_converted = HeartConfig::Instance()->GetCapacitance() * var_IKr__i_Kr; // uA_per_cm2
        const double var_Itos__i_tos = (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * (0.5 * var_chaste_interface__Itos_R_gate__R_tos + var_chaste_interface__Itos_Y_gate__Y_tos) * mParameters[12] * var_chaste_interface__Itos_X_gate__X_tos; // microA_per_microF
        const double var_Itos__i_tos_converted = HeartConfig::Instance()->GetCapacitance() * var_Itos__i_tos; // uA_per_cm2
        const double var_reversal_potentials__E_Na_SL = var_model_parameters__R * var_model_parameters__T * log(mParameters[6] / var_chaste_interface__Na_buffer__Na_SL) / var_model_parameters__F; // millivolt
        const double var_INa__i_Na_SL = (-var_reversal_potentials__E_Na_SL + var_chaste_interface__cell__V) * var_INa__Fx_Na_SL * mParameters[8] * var_INa__openProb; // microA_per_microF
        const double var_reversal_potentials__E_Na_jct = var_model_parameters__R * var_model_parameters__T * log(mParameters[6] / var_chaste_interface__Na_buffer__Na_jct) / var_model_parameters__F; // millivolt
        const double var_INa__i_Na_jct = (-var_reversal_potentials__E_Na_jct + var_chaste_interface__cell__V) * var_INa__Fx_Na_jct * mParameters[8] * var_INa__openProb; // microA_per_microF
        const double var_INa__i_Na = var_INa__i_Na_SL + var_INa__i_Na_jct; // microA_per_microF
        const double var_INa__i_Na_converted = HeartConfig::Instance()->GetCapacitance() * var_INa__i_Na; // uA_per_cm2

        std::vector<double> dqs(12);
        dqs[0] = var_Jrel_SR__j_rel_SR;
        dqs[1] = var_ICaL__i_CaL_converted;
        dqs[2] = var_ICaL_fCa_gate__fCa_SL;
        dqs[3] = var_ICaL_f_gate__tau_f;
        dqs[4] = var_INa__i_Na_converted;
        dqs[5] = var_IK1__i_K1_converted;
        dqs[6] = var_IKr__i_Kr_converted;
        dqs[7] = var_IKs__i_Ks_converted;
        dqs[8] = var_INaCa__i_NaCa_converted;
        dqs[9] = var_cell__i_Stim_converted;
        dqs[10] = var_Itos__i_tos_converted;
        dqs[11] = var_chaste_interface__environment__time;
        return dqs;
    }

template<>
void OdeSystemInformation<CellShannon2004FromCellMLGRL2>::Initialise(void)
{
    this->mSystemName = "shannon_2004";
    this->mFreeVariableName = "time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-85.56885);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.597401e-05);

    // rY[2]:
    this->mVariableNames.push_back("membrane_fast_sodium_current_h_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9867005);

    // rY[3]:
    this->mVariableNames.push_back("membrane_fast_sodium_current_j_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.991562);

    // rY[4]:
    this->mVariableNames.push_back("membrane_fast_sodium_current_m_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001405627);

    // rY[5]:
    this->mVariableNames.push_back("IKr_Xr_gate__Xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.008641386);

    // rY[6]:
    this->mVariableNames.push_back("IKs_Xs_gate__Xs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.005412034);

    // rY[7]:
    this->mVariableNames.push_back("Itos_X_gate__X_tos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004051574);

    // rY[8]:
    this->mVariableNames.push_back("Itos_Y_gate__Y_tos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9945511);

    // rY[9]:
    this->mVariableNames.push_back("Itos_R_gate__R_tos");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9946);

    // rY[10]:
    this->mVariableNames.push_back("Itof_X_gate__X_tof");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004051574);

    // rY[11]:
    this->mVariableNames.push_back("Itof_Y_gate__Y_tof");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9945511);

    // rY[12]:
    this->mVariableNames.push_back("membrane_L_type_calcium_current_d_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(7.175662e-06);

    // rY[13]:
    this->mVariableNames.push_back("membrane_L_type_calcium_current_f_gate");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.000681);

    // rY[14]:
    this->mVariableNames.push_back("ICaL_fCa_gate__fCaB_SL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01452605);

    // rY[15]:
    this->mVariableNames.push_back("ICaL_fCa_gate__fCaB_jct");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02421991);

    // rY[16]:
    this->mVariableNames.push_back("Jrel_SR__R");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8884332);

    // rY[17]:
    this->mVariableNames.push_back("Jrel_SR__I");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.024274e-07);

    // rY[18]:
    this->mVariableNames.push_back("Jrel_SR__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.156628e-07);

    // rY[19]:
    this->mVariableNames.push_back("Na_buffer__Na_SL");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.80733);

    // rY[20]:
    this->mVariableNames.push_back("Na_buffer__Na_jct");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.80329);

    // rY[21]:
    this->mVariableNames.push_back("Na_buffer__Na_SL_buf");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.7720854);

    // rY[22]:
    this->mVariableNames.push_back("Na_buffer__Na_jct_buf");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(3.539892);

    // rY[23]:
    this->mVariableNames.push_back("cytosolic_sodium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.80853);

    // rY[24]:
    this->mVariableNames.push_back("JSR_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.5545201);

    // rY[25]:
    this->mVariableNames.push_back("Ca_buffer__Ca_SL");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0001031812);

    // rY[26]:
    this->mVariableNames.push_back("Ca_buffer__Ca_jct");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0001737475);

    // rY[27]:
    this->mVariableNames.push_back("Ca_buffer__Ca_SLB_SL");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.1110363);

    // rY[28]:
    this->mVariableNames.push_back("Ca_buffer__Ca_SLB_jct");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.009566355);

    // rY[29]:
    this->mVariableNames.push_back("Ca_buffer__Ca_SLHigh_SL");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.07297378);

    // rY[30]:
    this->mVariableNames.push_back("Ca_buffer__Ca_SLHigh_jct");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.007347888);

    // rY[31]:
    this->mVariableNames.push_back("Ca_buffer__Ca_Calsequestrin");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.242988);

    // rY[32]:
    this->mVariableNames.push_back("cytosolic_Ca_buffer__Ca_TroponinC");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.008773191);

    // rY[33]:
    this->mVariableNames.push_back("cytosolic_Ca_buffer__Ca_TroponinC_Ca_Mg");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.1078283);

    // rY[34]:
    this->mVariableNames.push_back("cytosolic_Ca_buffer__Mg_TroponinC_Ca_Mg");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.01524002);

    // rY[35]:
    this->mVariableNames.push_back("cytosolic_Ca_buffer__Ca_Calmodulin");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0002911916);

    // rY[36]:
    this->mVariableNames.push_back("cytosolic_Ca_buffer__Ca_Myosin");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.001298754);

    // rY[37]:
    this->mVariableNames.push_back("cytosolic_Ca_buffer__Mg_Myosin");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.1381982);

    // rY[38]:
    this->mVariableNames.push_back("cytosolic_Ca_buffer__Ca_SRB");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.002143165);

    // mParameters[0]:
    this->mParameterNames.push_back("SR_leak_current_max");
    this->mParameterUnits.push_back("per_millisecond");

    // mParameters[1]:
    this->mParameterNames.push_back("SR_release_current_max");
    this->mParameterUnits.push_back("per_millisecond");

    // mParameters[2]:
    this->mParameterNames.push_back("SR_uptake_current_max");
    this->mParameterUnits.push_back("millimolar_per_millisecond");

    // mParameters[3]:
    this->mParameterNames.push_back("cytosolic_potassium_concentration");
    this->mParameterUnits.push_back("millimolar");

    // mParameters[4]:
    this->mParameterNames.push_back("extracellular_calcium_concentration");
    this->mParameterUnits.push_back("millimolar");

    // mParameters[5]:
    this->mParameterNames.push_back("extracellular_potassium_concentration");
    this->mParameterUnits.push_back("millimolar");

    // mParameters[6]:
    this->mParameterNames.push_back("extracellular_sodium_concentration");
    this->mParameterUnits.push_back("millimolar");

    // mParameters[7]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("litre_per_farad_millisecond");

    // mParameters[8]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("milliS_per_microF");

    // mParameters[9]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("milliS_per_microF");

    // mParameters[10]:
    this->mParameterNames.push_back("membrane_slow_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("milliS_per_microF");

    // mParameters[11]:
    this->mParameterNames.push_back("membrane_sodium_calcium_exchanger_current_conductance");
    this->mParameterUnits.push_back("microA_per_microF");

    // mParameters[12]:
    this->mParameterNames.push_back("membrane_transient_outward_current_conductance");
    this->mParameterUnits.push_back("milliS_per_microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("SR_release_current");
    this->mDerivedQuantityUnits.push_back("millimolar_per_millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_L_type_calcium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_L_type_calcium_current_fCa_gate");
    this->mDerivedQuantityUnits.push_back("dimensionless");

    // Derived Quantity index [3]:
    this->mDerivedQuantityNames.push_back("membrane_L_type_calcium_current_f_gate_tau");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [4]:
    this->mDerivedQuantityNames.push_back("membrane_fast_sodium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [5]:
    this->mDerivedQuantityNames.push_back("membrane_inward_rectifier_potassium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [6]:
    this->mDerivedQuantityNames.push_back("membrane_rapid_delayed_rectifier_potassium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [7]:
    this->mDerivedQuantityNames.push_back("membrane_slow_delayed_rectifier_potassium_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [8]:
    this->mDerivedQuantityNames.push_back("membrane_sodium_calcium_exchanger_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [9]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [10]:
    this->mDerivedQuantityNames.push_back("membrane_transient_outward_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    // Derived Quantity index [11]:
    this->mDerivedQuantityNames.push_back("time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(CellShannon2004FromCellMLGRL2)

