//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: fink_noble_giles_model_2008
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "fink_noble_giles_model_2008.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__cell__i_Stim_Amplitude_converted = -51.999999999999993 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__cell__i_Stim_Period = 1000.0; // millisecond
        const double var_chaste_interface__cell__i_Stim_PulseDuration = 1.0; // millisecond
        const double var_chaste_interface__cell__i_Stim_Start = 10.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__cell__i_Stim_Amplitude_converted),
                var_chaste_interface__cell__i_Stim_PulseDuration,
                var_chaste_interface__cell__i_Stim_Period,
                var_chaste_interface__cell__i_Stim_Start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::Cellfink_noble_giles_model_2008FromCellMLGRL1Opt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                27,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellfink_noble_giles_model_2008FromCellMLGRL1Opt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
    }

    Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::~Cellfink_noble_giles_model_2008FromCellMLGRL1Opt()
    {
    }
    
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov__Or4 = rY[4];
        // Units: dimensionless; Initial value: 0.014
        double var_chaste_interface__iKs_Xs_gate__Xs = rY[11];
        // Units: dimensionless; Initial value: 0.00303
        double var_chaste_interface__ito_s_gate__s = rY[12];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__ito_r_gate__r = rY[13];
        // Units: dimensionless; Initial value: 2.11e-08
        double var_chaste_interface__iNa_m_gate__m = rY[14];
        // Units: dimensionless; Initial value: 0.00132
        double var_chaste_interface__iNa_h_gate__h = rY[15];
        // Units: dimensionless; Initial value: 0.7768
        double var_chaste_interface__iNa_j_gate__j = rY[16];
        // Units: dimensionless; Initial value: 0.7766
        double var_chaste_interface__iCaL_d_gate__d = rY[17];
        // Units: dimensionless; Initial value: 5.06e-06
        double var_chaste_interface__iCaL_f_gate__f = rY[18];
        // Units: dimensionless; Initial value: 0.9999
        double var_chaste_interface__iCaL_f2_gate__f2 = rY[19];
        // Units: dimensionless; Initial value: 0.9995
        double var_chaste_interface__iCaL_fCass_gate__fCass = rY[20];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__Ca__Ca_i = rY[21];
        // Units: millimolar; Initial value: 0.0001092
        double var_chaste_interface__Ca__Ca_ss = rY[23];
        // Units: millimolar; Initial value: 0.0001893
        double var_chaste_interface__Na__Na_i = rY[25];
        // Units: millimolar; Initial value: 7.940167
        double var_chaste_interface__K__K_i = rY[26];
        // Units: millimolar; Initial value: 141.0167
        
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // millivolt
        const double var_reversal_potentials__E_Na = 26.713760659695652 * log(140.0 / var_chaste_interface__Na__Na_i); // millivolt
        const double var_cell__i_tot = 0.00076360000000000002 * var_chaste_interface__cell__V - 0.00029 * var_reversal_potentials__E_Na - 0.0063258185242159298 * log(2.0 / var_chaste_interface__Ca__Ca_i) + 0.039199999999999999 * pow(var_chaste_interface__iKs_Xs_gate__Xs, 2) * (-26.713760659695652 * log(9.5999999999999996 / (0.029999999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V) + 0.061899999999999997 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i) + 0.0097300000000000008 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__cell__V)) + 0.68210000000000004 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * (0.11619999999999997 / (1.0 + 0.036532500000000002 / exp(0.11701098901098901 * var_reversal_potentials__E_K - 0.10989010989010989 * var_chaste_interface__cell__V)) + 0.88380000000000003 * pow((1.0 + 0.079111111111111104 / exp(0.053239999999999996 * var_reversal_potentials__E_K - 0.050000000000000003 * var_chaste_interface__cell__V)), 2) / (pow((1.0 + 0.079111111111111104 / exp(0.053239999999999996 * var_reversal_potentials__E_K - 0.050000000000000003 * var_chaste_interface__cell__V)), 3) + 2.0875714285714286 / exp(-0.059333333333333335 + 0.22183333333333333 * var_reversal_potentials__E_K - 0.20833333333333334 * var_chaste_interface__cell__V) + 0.012714285714285714 / exp(0.005915555555555555 * var_reversal_potentials__E_K - 0.0055555555555555558 * var_chaste_interface__cell__V))) + 1.7332440459884893e-5 * (2.0 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.013101861787960915 * var_chaste_interface__cell__V) - 6860000.0 * var_chaste_interface__Ca__Ca_i * exp(-0.024332029034784559 * var_chaste_interface__cell__V)) / (1.0 + 0.10000000000000001 * exp(-0.024332029034784559 * var_chaste_interface__cell__V)) + 0.024 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_chaste_interface__iKr_Markov__Or4 + 0.20000000000000001 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_chaste_interface__ito_r_gate__r * var_chaste_interface__ito_s_gate__s + 1.0943437499999999 * var_chaste_interface__Na__Na_i / ((40.0 + var_chaste_interface__Na__Na_i) * (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__cell__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__cell__V))) + 11.0 * pow(var_chaste_interface__iNa_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__cell__V) * var_chaste_interface__iNa_h_gate__h * var_chaste_interface__iNa_j_gate__j + 0.28894573917650501 * (-2.0 + 0.25 * var_chaste_interface__Ca__Ca_ss * exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__cell__V)) * (-15.0 + var_chaste_interface__cell__V) * var_chaste_interface__iCaL_d_gate__d * var_chaste_interface__iCaL_f2_gate__f2 * var_chaste_interface__iCaL_fCass_gate__fCass * var_chaste_interface__iCaL_f_gate__f / (-1.0 + exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double var_chaste_interface__i_ionic = 0.99999999999999989 * HeartConfig::Instance()->GetCapacitance() * var_cell__i_tot; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::UpdateTransmembranePotential(double var_chaste_interface__Environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;

        double d_dt_chaste_interface_var_cell__V;
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov__Or4 = rY[4];
        // Units: dimensionless; Initial value: 0.014
        double var_chaste_interface__iKs_Xs_gate__Xs = rY[11];
        // Units: dimensionless; Initial value: 0.00303
        double var_chaste_interface__ito_s_gate__s = rY[12];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__ito_r_gate__r = rY[13];
        // Units: dimensionless; Initial value: 2.11e-08
        double var_chaste_interface__iNa_m_gate__m = rY[14];
        // Units: dimensionless; Initial value: 0.00132
        double var_chaste_interface__iNa_h_gate__h = rY[15];
        // Units: dimensionless; Initial value: 0.7768
        double var_chaste_interface__iNa_j_gate__j = rY[16];
        // Units: dimensionless; Initial value: 0.7766
        double var_chaste_interface__iCaL_d_gate__d = rY[17];
        // Units: dimensionless; Initial value: 5.06e-06
        double var_chaste_interface__iCaL_f_gate__f = rY[18];
        // Units: dimensionless; Initial value: 0.9999
        double var_chaste_interface__iCaL_f2_gate__f2 = rY[19];
        // Units: dimensionless; Initial value: 0.9995
        double var_chaste_interface__iCaL_fCass_gate__fCass = rY[20];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__Ca__Ca_i = rY[21];
        // Units: millimolar; Initial value: 0.0001092
        double var_chaste_interface__Ca__Ca_ss = rY[23];
        // Units: millimolar; Initial value: 0.0001893
        double var_chaste_interface__Na__Na_i = rY[25];
        // Units: millimolar; Initial value: 7.940167
        double var_chaste_interface__K__K_i = rY[26];
        // Units: millimolar; Initial value: 141.0167
        

        // Mathematics
        const double var_IpCa__i_p_Ca = 0.061899999999999997 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i); // nanoA_per_nanoF
        const double var_INaCa__i_NaCa = 1.7332440459884893e-5 * (2.0 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.013101861787960915 * var_chaste_interface__cell__V) - 6860000.0 * var_chaste_interface__Ca__Ca_i * exp(-0.024332029034784559 * var_chaste_interface__cell__V)) / (1.0 + 0.10000000000000001 * exp(-0.024332029034784559 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double var_INaK__i_NaK = 1.0943437499999999 * var_chaste_interface__Na__Na_i / ((40.0 + var_chaste_interface__Na__Na_i) * (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__cell__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__cell__V))); // nanoA_per_nanoF
        const double var_cell__i_Stim = 1.0000000000000002 * GetIntracellularAreaStimulus(var_chaste_interface__Environment__time) / HeartConfig::Instance()->GetCapacitance(); // nanoA_per_nanoF
        const double var_ICaL__i_CaL = 0.28894573917650501 * (-2.0 + 0.25 * var_chaste_interface__Ca__Ca_ss * exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__cell__V)) * (-15.0 + var_chaste_interface__cell__V) * var_chaste_interface__iCaL_d_gate__d * var_chaste_interface__iCaL_f2_gate__f2 * var_chaste_interface__iCaL_fCass_gate__fCass * var_chaste_interface__iCaL_f_gate__f / (-1.0 + exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double var_ICab__i_b_Ca = 0.00047360000000000002 * var_chaste_interface__cell__V - 0.0063258185242159298 * log(2.0 / var_chaste_interface__Ca__Ca_i); // nanoA_per_nanoF
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // millivolt
        const double var_IKr__i_Kr = 0.024 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_chaste_interface__iKr_Markov__Or4; // nanoA_per_nanoF
        const double var_IpK__i_p_K = 0.0097300000000000008 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double var_Ito__i_to = 0.20000000000000001 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_chaste_interface__ito_r_gate__r * var_chaste_interface__ito_s_gate__s; // nanoA_per_nanoF
        const double var_IK1__i_K1 = 0.68210000000000004 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * (0.11619999999999997 / (1.0 + 0.036532500000000002 / exp(0.11701098901098901 * var_reversal_potentials__E_K - 0.10989010989010989 * var_chaste_interface__cell__V)) + 0.88380000000000003 * pow((1.0 + 0.079111111111111104 / exp(0.053239999999999996 * var_reversal_potentials__E_K - 0.050000000000000003 * var_chaste_interface__cell__V)), 2) / (pow((1.0 + 0.079111111111111104 / exp(0.053239999999999996 * var_reversal_potentials__E_K - 0.050000000000000003 * var_chaste_interface__cell__V)), 3) + 2.0875714285714286 / exp(-0.059333333333333335 + 0.22183333333333333 * var_reversal_potentials__E_K - 0.20833333333333334 * var_chaste_interface__cell__V) + 0.012714285714285714 / exp(0.005915555555555555 * var_reversal_potentials__E_K - 0.0055555555555555558 * var_chaste_interface__cell__V))); // nanoA_per_nanoF
        const double var_reversal_potentials__E_Na = 26.713760659695652 * log(140.0 / var_chaste_interface__Na__Na_i); // millivolt
        const double var_INa__i_Na = 11.0 * pow(var_chaste_interface__iNa_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__cell__V) * var_chaste_interface__iNa_h_gate__h * var_chaste_interface__iNa_j_gate__j; // nanoA_per_nanoF
        const double var_INab__i_b_Na = 0.00029 * var_chaste_interface__cell__V - 0.00029 * var_reversal_potentials__E_Na; // nanoA_per_nanoF
        const double var_IKs__i_Ks = 0.039199999999999999 * pow(var_chaste_interface__iKs_Xs_gate__Xs, 2) * (-26.713760659695652 * log(9.5999999999999996 / (0.029999999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V); // nanoA_per_nanoF
        d_dt_chaste_interface_var_cell__V = -var_ICaL__i_CaL - var_ICab__i_b_Ca - var_IK1__i_K1 - var_IKr__i_Kr - var_IKs__i_Ks - var_INa__i_Na - var_INaCa__i_NaCa - var_INaK__i_NaK - var_INab__i_b_Na - var_IpCa__i_p_Ca - var_IpK__i_p_K - var_Ito__i_to - var_cell__i_Stim; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_cell__V;
        mEvalF[0] = d_dt_chaste_interface_var_cell__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__Environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::ComputeOneStepExceptVoltage(double var_chaste_interface__Environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta = 1e-8;

        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov__Cr1 = rY[1];
        // Units: dimensionless; Initial value: 0.9786
        double var_chaste_interface__iKr_Markov__Cr2 = rY[2];
        // Units: dimensionless; Initial value: 0.0031
        double var_chaste_interface__iKr_Markov__Cr3 = rY[3];
        // Units: dimensionless; Initial value: 0.0029
        double var_chaste_interface__iKr_Markov__Or4 = rY[4];
        // Units: dimensionless; Initial value: 0.014
        double var_chaste_interface__iKr_Markov__Ir5 = rY[5];
        // Units: dimensionless; Initial value: 0.0014
        double var_chaste_interface__iKr_Markov_Sotalol_block__BCr1 = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKr_Markov_Sotalol_block__BCr2 = rY[7];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKr_Markov_Sotalol_block__BCr3 = rY[8];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKr_Markov_Sotalol_block__BOr4 = rY[9];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKr_Markov_Sotalol_block__BIr5 = rY[10];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKs_Xs_gate__Xs = rY[11];
        // Units: dimensionless; Initial value: 0.00303
        double var_chaste_interface__ito_s_gate__s = rY[12];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__ito_r_gate__r = rY[13];
        // Units: dimensionless; Initial value: 2.11e-08
        double var_chaste_interface__iNa_m_gate__m = rY[14];
        // Units: dimensionless; Initial value: 0.00132
        double var_chaste_interface__iNa_h_gate__h = rY[15];
        // Units: dimensionless; Initial value: 0.7768
        double var_chaste_interface__iNa_j_gate__j = rY[16];
        // Units: dimensionless; Initial value: 0.7766
        double var_chaste_interface__iCaL_d_gate__d = rY[17];
        // Units: dimensionless; Initial value: 5.06e-06
        double var_chaste_interface__iCaL_f_gate__f = rY[18];
        // Units: dimensionless; Initial value: 0.9999
        double var_chaste_interface__iCaL_f2_gate__f2 = rY[19];
        // Units: dimensionless; Initial value: 0.9995
        double var_chaste_interface__iCaL_fCass_gate__fCass = rY[20];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__Ca__Ca_i = rY[21];
        // Units: millimolar; Initial value: 0.0001092
        double var_chaste_interface__Ca__Ca_SR = rY[22];
        // Units: millimolar; Initial value: 2.7656
        double var_chaste_interface__Ca__Ca_ss = rY[23];
        // Units: millimolar; Initial value: 0.0001893
        double var_chaste_interface__Irel__R_prime = rY[24];
        // Units: dimensionless; Initial value: 0.9864
        double var_chaste_interface__Na__Na_i = rY[25];
        // Units: millimolar; Initial value: 7.940167
        double var_chaste_interface__K__K_i = rY[26];
        // Units: millimolar; Initial value: 141.0167
        
        
        // Mathematics
        const double var_INa__shift_INa_inact = 0; // millivolt
        const double var_Ileak_Iup_Ixfer__i_leak = 0.00036000000000000002 * var_chaste_interface__Ca__Ca_SR - 0.00036000000000000002 * var_chaste_interface__Ca__Ca_i; // millimolar_per_millisecond
        const double var_Ileak_Iup_Ixfer__i_up = 0.0063749999999999996 / (1.0 + 6.2499999999999997e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)); // millimolar_per_millisecond
        const double var_Ileak_Iup_Ixfer__i_xfer = 0.0038 * var_chaste_interface__Ca__Ca_ss - 0.0038 * var_chaste_interface__Ca__Ca_i; // millimolar_per_millisecond
        const double var_IpCa__i_p_Ca = 0.061899999999999997 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i); // nanoA_per_nanoF
        const double var_Irel__kcasr = 2.5 - 1.5 / (1.0 + 2.25 / pow(var_chaste_interface__Ca__Ca_SR, 2)); // dimensionless
        const double var_Irel__i_rel = 0.045899999999999996 * pow(var_chaste_interface__Ca__Ca_ss, 2) * (-var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_SR) * var_chaste_interface__Irel__R_prime / ((0.059999999999999998 + 0.14999999999999999 * pow(var_chaste_interface__Ca__Ca_ss, 2) / var_Irel__kcasr) * var_Irel__kcasr); // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Ca__Ca_SR = (-var_Ileak_Iup_Ixfer__i_leak - var_Irel__i_rel + var_Ileak_Iup_Ixfer__i_up) / (1.0 + 3.0 / pow((0.29999999999999999 + var_chaste_interface__Ca__Ca_SR), 2)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_Irel__R_prime = 0.0050000000000000001 - 0.0050000000000000001 * var_chaste_interface__Irel__R_prime - 0.044999999999999998 * var_chaste_interface__Ca__Ca_ss * var_chaste_interface__Irel__R_prime * var_Irel__kcasr; // 1 / millisecond
        const double var_INaCa__i_NaCa = 1.7332440459884893e-5 * (2.0 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.013101861787960915 * var_chaste_interface__cell__V) - 6860000.0 * var_chaste_interface__Ca__Ca_i * exp(-0.024332029034784559 * var_chaste_interface__cell__V)) / (1.0 + 0.10000000000000001 * exp(-0.024332029034784559 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double var_INaK__i_NaK = 1.0943437499999999 * var_chaste_interface__Na__Na_i / ((40.0 + var_chaste_interface__Na__Na_i) * (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__cell__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__cell__V))); // nanoA_per_nanoF
        const double var_cell__i_Stim = 1.0000000000000002 * GetIntracellularAreaStimulus(var_chaste_interface__Environment__time) / HeartConfig::Instance()->GetCapacitance(); // nanoA_per_nanoF
        const double d_dt_chaste_interface_var_iCaL_d_gate__d = (-var_chaste_interface__iCaL_d_gate__d + 1 / (1.0 + exp(0.66666666666666663 - 0.13333333333333333 * var_chaste_interface__cell__V))) / (1 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__cell__V)) + 1.3999999999999999 * (0.25 + 1.3999999999999999 / (1.0 + exp(-2.6923076923076925 - 0.076923076923076927 * var_chaste_interface__cell__V))) / (1.0 + exp(1.0 + 0.20000000000000001 * var_chaste_interface__cell__V))); // 1 / millisecond
        const double d_dt_chaste_interface_var_iCaL_f2_gate__f2 = (0.25 - var_chaste_interface__iCaL_f2_gate__f2 + 0.75 / (1.0 + exp(5.0 + 0.14285714285714285 * var_chaste_interface__cell__V))) / (40.0 / (1.0 + exp(3.0 + 0.10000000000000001 * var_chaste_interface__cell__V)) + 15.5 / (1.0 + exp(2.5 - 0.10000000000000001 * var_chaste_interface__cell__V)) + 281.0 * exp(-3.0375000000000001 * pow((1 + 0.037037037037037035 * var_chaste_interface__cell__V), 2))); // 1 / millisecond
        const double d_dt_chaste_interface_var_iCaL_fCass_gate__fCass = (0.59999999999999998 - var_chaste_interface__iCaL_fCass_gate__fCass + 0.40000000000000002 / (1.0 + 399.99999999999994 * pow(var_chaste_interface__Ca__Ca_ss, 2))) / (2.0 + 80.0 / (1.0 + 399.99999999999994 * pow(var_chaste_interface__Ca__Ca_ss, 2))); // 1 / millisecond
        const double var_ICaL__i_CaL = 0.28894573917650501 * (-2.0 + 0.25 * var_chaste_interface__Ca__Ca_ss * exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__cell__V)) * (-15.0 + var_chaste_interface__cell__V) * var_chaste_interface__iCaL_d_gate__d * var_chaste_interface__iCaL_f2_gate__f2 * var_chaste_interface__iCaL_fCass_gate__fCass * var_chaste_interface__iCaL_f_gate__f / (-1.0 + exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double d_dt_chaste_interface_var_Ca__Ca_ss = (20.007315288953912 * var_Irel__i_rel - 300.0 * var_Ileak_Iup_Ixfer__i_xfer - 0.01089878286978019 * var_ICaL__i_CaL) / (1.0 + 0.0001 / pow((0.00025000000000000001 + var_chaste_interface__Ca__Ca_ss), 2)); // millimolar / millisecond
        const double d_dt_chaste_interface_var_iCaL_f_gate__f = (-var_chaste_interface__iCaL_f_gate__f + 1 / (1.0 + exp(2.8571428571428572 + 0.14285714285714285 * var_chaste_interface__cell__V))) / (5.0 + 50.0 / (1.0 + exp(1.3 - 0.10000000000000001 * var_chaste_interface__cell__V)) + 45.0 / (1.0 + exp(3.0 + 0.10000000000000001 * var_chaste_interface__cell__V)) + 275.625 * exp(-3.2400000000000002 * pow((1 + 0.037037037037037035 * var_chaste_interface__cell__V), 2))); // 1 / millisecond
        const double var_iKr_Markov__alpha_xr1 = exp(-1.5790000000000006 + 0.0112 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__alpha_xr2 = exp(-3.1680000000000028); // per_millisecond
        const double var_iKr_Markov__alpha_xr3 = exp(-3.8160000000000025 + 0.036499999999999998 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__alpha_xr4 = exp(-0.87200000000000344 + 0.0223 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr1 = exp(-2.0190000000000001 - 0.060299999999999999 * var_chaste_interface__cell__V); // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov__Cr1 = var_chaste_interface__iKr_Markov__Cr2 * var_iKr_Markov__beta_xr1 - var_chaste_interface__iKr_Markov__Cr1 * var_iKr_Markov__alpha_xr1; // 1 / millisecond
        const double var_iKr_Markov__beta_xr2 = exp(-2.5140000000000011); // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov__Cr2 = var_chaste_interface__iKr_Markov__Cr1 * var_iKr_Markov__alpha_xr1 + var_chaste_interface__iKr_Markov__Cr3 * var_iKr_Markov__beta_xr2 - (var_iKr_Markov__alpha_xr2 + var_iKr_Markov__beta_xr1) * var_chaste_interface__iKr_Markov__Cr2; // 1 / millisecond
        const double var_iKr_Markov__beta_xr3 = exp(-8.3940000000000019 - 0.039899999999999998 * var_chaste_interface__cell__V); // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov__Cr3 = var_chaste_interface__iKr_Markov__Cr2 * var_iKr_Markov__alpha_xr2 + var_chaste_interface__iKr_Markov__Or4 * var_iKr_Markov__beta_xr3 - (var_iKr_Markov__alpha_xr3 + var_iKr_Markov__beta_xr2) * var_chaste_interface__iKr_Markov__Cr3; // 1 / millisecond
        const double var_iKr_Markov__beta_xr4 = exp(-3.1820000000000022 - 0.031199999999999999 * var_chaste_interface__cell__V); // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov__Ir5 = var_chaste_interface__iKr_Markov__Or4 * var_iKr_Markov__alpha_xr4 - var_chaste_interface__iKr_Markov__Ir5 * var_iKr_Markov__beta_xr4; // 1 / millisecond
        const double d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr1 = var_iKr_Markov__beta_xr1 * var_chaste_interface__iKr_Markov_Sotalol_block__BCr2 - var_iKr_Markov__alpha_xr1 * var_chaste_interface__iKr_Markov_Sotalol_block__BCr1; // 1 / millisecond
        const double d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr2 = var_iKr_Markov__alpha_xr1 * var_chaste_interface__iKr_Markov_Sotalol_block__BCr1 + var_iKr_Markov__beta_xr2 * var_chaste_interface__iKr_Markov_Sotalol_block__BCr3 - (var_iKr_Markov__alpha_xr2 + var_iKr_Markov__beta_xr1) * var_chaste_interface__iKr_Markov_Sotalol_block__BCr2; // 1 / millisecond
        const double d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr3 = var_iKr_Markov__alpha_xr2 * var_chaste_interface__iKr_Markov_Sotalol_block__BCr2 + var_iKr_Markov__beta_xr3 * var_chaste_interface__iKr_Markov_Sotalol_block__BOr4 - (var_iKr_Markov__alpha_xr3 + var_iKr_Markov__beta_xr2) * var_chaste_interface__iKr_Markov_Sotalol_block__BCr3; // 1 / millisecond
        const double d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BIr5 = var_iKr_Markov__alpha_xr4 * var_chaste_interface__iKr_Markov_Sotalol_block__BOr4 - var_iKr_Markov__beta_xr4 * var_chaste_interface__iKr_Markov_Sotalol_block__BIr5; // 1 / millisecond
        const double var_iKr_Markov_Sotalol_block__OtoB = 0; // per_millisecond
        const double var_iKr_Markov_Sotalol_block__BtoO = 0.00125 * var_chaste_interface__iKr_Markov_Sotalol_block__BOr4; // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov__Or4 = -var_iKr_Markov_Sotalol_block__OtoB + var_chaste_interface__iKr_Markov__Cr3 * var_iKr_Markov__alpha_xr3 + var_chaste_interface__iKr_Markov__Ir5 * var_iKr_Markov__beta_xr4 - (var_iKr_Markov__alpha_xr4 + var_iKr_Markov__beta_xr3) * var_chaste_interface__iKr_Markov__Or4 + var_iKr_Markov_Sotalol_block__BtoO; // 1 / millisecond
        const double d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BOr4 = -var_iKr_Markov_Sotalol_block__BtoO + var_iKr_Markov__alpha_xr3 * var_chaste_interface__iKr_Markov_Sotalol_block__BCr3 + var_iKr_Markov__beta_xr4 * var_chaste_interface__iKr_Markov_Sotalol_block__BIr5 - (var_iKr_Markov__alpha_xr4 + var_iKr_Markov__beta_xr3) * var_chaste_interface__iKr_Markov_Sotalol_block__BOr4 + var_iKr_Markov_Sotalol_block__OtoB; // 1 / millisecond
        const double d_dt_chaste_interface_var_iKs_Xs_gate__Xs = (-var_chaste_interface__iKs_Xs_gate__Xs + 1 / (1.0 + exp(-0.35714285714285715 - 0.071428571428571425 * var_chaste_interface__cell__V))) / (80.0 + 1400.0 / (sqrt(1.0 + exp(0.83333333333333337 - 0.16666666666666666 * var_chaste_interface__cell__V)) * (1.0 + exp(-2.3333333333333335 + 0.066666666666666666 * var_chaste_interface__cell__V)))); // 1 / millisecond
        const double d_dt_chaste_interface_var_iNa_h_gate__h = (-var_chaste_interface__iNa_h_gate__h + 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__cell__V - 0.13458950201884254 * var_INa__shift_INa_inact)), 2)) * (((var_chaste_interface__cell__V < -40.0 + var_INa__shift_INa_inact) ? (0.057000000000000002 * exp(-11.764705882352942 + 0.14705882352941177 * var_INa__shift_INa_inact - 0.14705882352941177 * var_chaste_interface__cell__V)) : (0)) + ((var_chaste_interface__cell__V < -40.0 + var_INa__shift_INa_inact) ? (310000.0 * exp(0.34849999999999998 * var_chaste_interface__cell__V - 0.34849999999999998 * var_INa__shift_INa_inact) + 2.7000000000000002 * exp(0.079000000000000001 * var_chaste_interface__cell__V - 0.079000000000000001 * var_INa__shift_INa_inact)) : (5.9230769230769234 / (1.0 + exp(-0.96036036036036043 + 0.0900900900900901 * var_INa__shift_INa_inact - 0.0900900900900901 * var_chaste_interface__cell__V))))); // 1 / millisecond
        const double d_dt_chaste_interface_var_iNa_j_gate__j = (-var_chaste_interface__iNa_j_gate__j + 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__cell__V - 0.13458950201884254 * var_INa__shift_INa_inact)), 2)) * (((var_chaste_interface__cell__V < -40.0 + var_INa__shift_INa_inact) ? (0.024240000000000001 * exp(0.01052 * var_INa__shift_INa_inact - 0.01052 * var_chaste_interface__cell__V) / (1.0 + exp(-5.5312920000000005 + 0.13780000000000001 * var_INa__shift_INa_inact - 0.13780000000000001 * var_chaste_interface__cell__V))) : (0.59999999999999998 * exp(0.057000000000000002 * var_chaste_interface__cell__V - 0.057000000000000002 * var_INa__shift_INa_inact) / (1.0 + exp(-3.2000000000000002 + 0.10000000000000001 * var_INa__shift_INa_inact - 0.10000000000000001 * var_chaste_interface__cell__V)))) + ((var_chaste_interface__cell__V < -40.0 + var_INa__shift_INa_inact) ? ((37.780000000000001 + var_chaste_interface__cell__V) * (-25428.0 * exp(0.24440000000000001 * var_chaste_interface__cell__V - 0.24440000000000001 * var_INa__shift_INa_inact) - 6.9480000000000002e-6 * exp(0.043909999999999998 * var_INa__shift_INa_inact - 0.043909999999999998 * var_chaste_interface__cell__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V - 0.311 * var_INa__shift_INa_inact))) : (0))); // 1 / millisecond
        const double d_dt_chaste_interface_var_iNa_m_gate__m = (1.0 + exp(-12.0 - 0.20000000000000001 * var_chaste_interface__cell__V)) * (-var_chaste_interface__iNa_m_gate__m + 1 / pow((1.0 + exp(-6.2967884828349945 - 0.11074197120708749 * var_chaste_interface__cell__V)), 2)) / (0.10000000000000001 / (1.0 + exp(7.0 + 0.20000000000000001 * var_chaste_interface__cell__V)) + 0.10000000000000001 / (1.0 + exp(-0.25 + 0.0050000000000000001 * var_chaste_interface__cell__V))); // 1 / millisecond
        const double d_dt_chaste_interface_var_ito_r_gate__r = (-var_chaste_interface__ito_r_gate__r + 1 / (1.0 + exp(3.3333333333333335 - 0.16666666666666666 * var_chaste_interface__cell__V))) / (0.80000000000000004 + 9.5 * exp(-0.88888888888888884 * pow((1 + 0.025000000000000001 * var_chaste_interface__cell__V), 2))); // 1 / millisecond
        const double d_dt_chaste_interface_var_ito_s_gate__s = (-var_chaste_interface__ito_s_gate__s + 1 / (1.0 + exp(4.0 + 0.20000000000000001 * var_chaste_interface__cell__V))) / (3.0 + 5.0 / (1.0 + exp(-4.0 + 0.20000000000000001 * var_chaste_interface__cell__V)) + 85.0 * exp(-6.328125 * pow((1 + 0.022222222222222223 * var_chaste_interface__cell__V), 2))); // 1 / millisecond
        const double var_ICab__i_b_Ca = 0.00047360000000000002 * var_chaste_interface__cell__V - 0.0063258185242159298 * log(2.0 / var_chaste_interface__Ca__Ca_i); // nanoA_per_nanoF
        const double d_dt_chaste_interface_var_Ca__Ca_i = (0.066691050963179718 * var_Ileak_Iup_Ixfer__i_leak + 7.2658552465201267e-5 * var_INaCa__i_NaCa - 0.066691050963179718 * var_Ileak_Iup_Ixfer__i_up - 3.6329276232600633e-5 * var_ICab__i_b_Ca - 3.6329276232600633e-5 * var_IpCa__i_p_Ca + var_Ileak_Iup_Ixfer__i_xfer) / (1.0 + 0.00020000000000000001 / pow((0.001 + var_chaste_interface__Ca__Ca_i), 2)); // millimolar / millisecond
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // millivolt
        const double var_IKr__i_Kr = 0.024 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_chaste_interface__iKr_Markov__Or4; // nanoA_per_nanoF
        const double var_IpK__i_p_K = 0.0097300000000000008 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double var_Ito__i_to = 0.20000000000000001 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_chaste_interface__ito_r_gate__r * var_chaste_interface__ito_s_gate__s; // nanoA_per_nanoF
        const double var_IK1__i_K1 = 0.68210000000000004 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * (0.11619999999999997 / (1.0 + 0.036532500000000002 / exp(0.11701098901098901 * var_reversal_potentials__E_K - 0.10989010989010989 * var_chaste_interface__cell__V)) + 0.88380000000000003 * pow((1.0 + 0.079111111111111104 / exp(0.053239999999999996 * var_reversal_potentials__E_K - 0.050000000000000003 * var_chaste_interface__cell__V)), 2) / (pow((1.0 + 0.079111111111111104 / exp(0.053239999999999996 * var_reversal_potentials__E_K - 0.050000000000000003 * var_chaste_interface__cell__V)), 3) + 2.0875714285714286 / exp(-0.059333333333333335 + 0.22183333333333333 * var_reversal_potentials__E_K - 0.20833333333333334 * var_chaste_interface__cell__V) + 0.012714285714285714 / exp(0.005915555555555555 * var_reversal_potentials__E_K - 0.0055555555555555558 * var_chaste_interface__cell__V))); // nanoA_per_nanoF
        const double var_reversal_potentials__E_Na = 26.713760659695652 * log(140.0 / var_chaste_interface__Na__Na_i); // millivolt
        const double var_INa__i_Na = 11.0 * pow(var_chaste_interface__iNa_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__cell__V) * var_chaste_interface__iNa_h_gate__h * var_chaste_interface__iNa_j_gate__j; // nanoA_per_nanoF
        const double var_INab__i_b_Na = 0.00029 * var_chaste_interface__cell__V - 0.00029 * var_reversal_potentials__E_Na; // nanoA_per_nanoF
        const double d_dt_chaste_interface_var_Na__Na_i = -7.2658552465201267e-5 * var_INa__i_Na - 7.2658552465201267e-5 * var_INab__i_b_Na - 0.0002179756573956038 * var_INaCa__i_NaCa - 0.0002179756573956038 * var_INaK__i_NaK; // millimolar / millisecond
        const double var_IKs__i_Ks = 0.039199999999999999 * pow(var_chaste_interface__iKs_Xs_gate__Xs, 2) * (-26.713760659695652 * log(9.5999999999999996 / (0.029999999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V); // nanoA_per_nanoF
        const double d_dt_chaste_interface_var_K__K_i = 0.00014531710493040253 * var_INaK__i_NaK - 7.2658552465201267e-5 * var_IK1__i_K1 - 7.2658552465201267e-5 * var_IKr__i_Kr - 7.2658552465201267e-5 * var_IKs__i_Ks - 7.2658552465201267e-5 * var_IpK__i_p_K - 7.2658552465201267e-5 * var_Ito__i_to - 7.2658552465201267e-5 * var_cell__i_Stim; // millimolar / millisecond
        
        mEvalF[1] = d_dt_chaste_interface_var_iKr_Markov__Cr1;
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[2] = d_dt_chaste_interface_var_iKr_Markov__Cr2;
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[3] = d_dt_chaste_interface_var_iKr_Markov__Cr3;
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[4] = d_dt_chaste_interface_var_iKr_Markov__Or4;
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[5] = d_dt_chaste_interface_var_iKr_Markov__Ir5;
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[6] = d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr1;
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[7] = d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr2;
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[8] = d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr3;
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[9] = d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BOr4;
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[10] = d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BIr5;
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[11] = d_dt_chaste_interface_var_iKs_Xs_gate__Xs;
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[12] = d_dt_chaste_interface_var_ito_s_gate__s;
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[13] = d_dt_chaste_interface_var_ito_r_gate__r;
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[14] = d_dt_chaste_interface_var_iNa_m_gate__m;
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[15] = d_dt_chaste_interface_var_iNa_h_gate__h;
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[16] = d_dt_chaste_interface_var_iNa_j_gate__j;
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[17] = d_dt_chaste_interface_var_iCaL_d_gate__d;
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[18] = d_dt_chaste_interface_var_iCaL_f_gate__f;
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[19] = d_dt_chaste_interface_var_iCaL_f2_gate__f2;
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[20] = d_dt_chaste_interface_var_iCaL_fCass_gate__fCass;
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[21] = d_dt_chaste_interface_var_Ca__Ca_i;
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[22] = d_dt_chaste_interface_var_Ca__Ca_SR;
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[23] = d_dt_chaste_interface_var_Ca__Ca_ss;
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[24] = d_dt_chaste_interface_var_Irel__R_prime;
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[25] = d_dt_chaste_interface_var_Na__Na_i;
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__Environment__time, rY, delta);
        mEvalF[26] = d_dt_chaste_interface_var_K__K_i;
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__Environment__time, rY, delta);
        
        {
            if (fabs(mPartialF[1]) < delta){
                rY[1] += mDt*d_dt_chaste_interface_var_iKr_Markov__Cr1;
            }
            else
            {
                rY[1] += (d_dt_chaste_interface_var_iKr_Markov__Cr1/mPartialF[1])*(exp(mPartialF[1]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[2]) < delta){
                rY[2] += mDt*d_dt_chaste_interface_var_iKr_Markov__Cr2;
            }
            else
            {
                rY[2] += (d_dt_chaste_interface_var_iKr_Markov__Cr2/mPartialF[2])*(exp(mPartialF[2]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[3]) < delta){
                rY[3] += mDt*d_dt_chaste_interface_var_iKr_Markov__Cr3;
            }
            else
            {
                rY[3] += (d_dt_chaste_interface_var_iKr_Markov__Cr3/mPartialF[3])*(exp(mPartialF[3]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[4]) < delta){
                rY[4] += mDt*d_dt_chaste_interface_var_iKr_Markov__Or4;
            }
            else
            {
                rY[4] += (d_dt_chaste_interface_var_iKr_Markov__Or4/mPartialF[4])*(exp(mPartialF[4]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[5]) < delta){
                rY[5] += mDt*d_dt_chaste_interface_var_iKr_Markov__Ir5;
            }
            else
            {
                rY[5] += (d_dt_chaste_interface_var_iKr_Markov__Ir5/mPartialF[5])*(exp(mPartialF[5]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[6]) < delta){
                rY[6] += mDt*d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr1;
            }
            else
            {
                rY[6] += (d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr1/mPartialF[6])*(exp(mPartialF[6]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[7]) < delta){
                rY[7] += mDt*d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr2;
            }
            else
            {
                rY[7] += (d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr2/mPartialF[7])*(exp(mPartialF[7]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[8]) < delta){
                rY[8] += mDt*d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr3;
            }
            else
            {
                rY[8] += (d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr3/mPartialF[8])*(exp(mPartialF[8]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[9]) < delta){
                rY[9] += mDt*d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BOr4;
            }
            else
            {
                rY[9] += (d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BOr4/mPartialF[9])*(exp(mPartialF[9]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[10]) < delta){
                rY[10] += mDt*d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BIr5;
            }
            else
            {
                rY[10] += (d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BIr5/mPartialF[10])*(exp(mPartialF[10]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[11]) < delta){
                rY[11] += mDt*d_dt_chaste_interface_var_iKs_Xs_gate__Xs;
            }
            else
            {
                rY[11] += (d_dt_chaste_interface_var_iKs_Xs_gate__Xs/mPartialF[11])*(exp(mPartialF[11]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[12]) < delta){
                rY[12] += mDt*d_dt_chaste_interface_var_ito_s_gate__s;
            }
            else
            {
                rY[12] += (d_dt_chaste_interface_var_ito_s_gate__s/mPartialF[12])*(exp(mPartialF[12]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[13]) < delta){
                rY[13] += mDt*d_dt_chaste_interface_var_ito_r_gate__r;
            }
            else
            {
                rY[13] += (d_dt_chaste_interface_var_ito_r_gate__r/mPartialF[13])*(exp(mPartialF[13]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[14]) < delta){
                rY[14] += mDt*d_dt_chaste_interface_var_iNa_m_gate__m;
            }
            else
            {
                rY[14] += (d_dt_chaste_interface_var_iNa_m_gate__m/mPartialF[14])*(exp(mPartialF[14]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[15]) < delta){
                rY[15] += mDt*d_dt_chaste_interface_var_iNa_h_gate__h;
            }
            else
            {
                rY[15] += (d_dt_chaste_interface_var_iNa_h_gate__h/mPartialF[15])*(exp(mPartialF[15]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[16]) < delta){
                rY[16] += mDt*d_dt_chaste_interface_var_iNa_j_gate__j;
            }
            else
            {
                rY[16] += (d_dt_chaste_interface_var_iNa_j_gate__j/mPartialF[16])*(exp(mPartialF[16]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[17]) < delta){
                rY[17] += mDt*d_dt_chaste_interface_var_iCaL_d_gate__d;
            }
            else
            {
                rY[17] += (d_dt_chaste_interface_var_iCaL_d_gate__d/mPartialF[17])*(exp(mPartialF[17]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[18]) < delta){
                rY[18] += mDt*d_dt_chaste_interface_var_iCaL_f_gate__f;
            }
            else
            {
                rY[18] += (d_dt_chaste_interface_var_iCaL_f_gate__f/mPartialF[18])*(exp(mPartialF[18]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[19]) < delta){
                rY[19] += mDt*d_dt_chaste_interface_var_iCaL_f2_gate__f2;
            }
            else
            {
                rY[19] += (d_dt_chaste_interface_var_iCaL_f2_gate__f2/mPartialF[19])*(exp(mPartialF[19]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[20]) < delta){
                rY[20] += mDt*d_dt_chaste_interface_var_iCaL_fCass_gate__fCass;
            }
            else
            {
                rY[20] += (d_dt_chaste_interface_var_iCaL_fCass_gate__fCass/mPartialF[20])*(exp(mPartialF[20]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[21]) < delta){
                rY[21] += mDt*d_dt_chaste_interface_var_Ca__Ca_i;
            }
            else
            {
                rY[21] += (d_dt_chaste_interface_var_Ca__Ca_i/mPartialF[21])*(exp(mPartialF[21]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[22]) < delta){
                rY[22] += mDt*d_dt_chaste_interface_var_Ca__Ca_SR;
            }
            else
            {
                rY[22] += (d_dt_chaste_interface_var_Ca__Ca_SR/mPartialF[22])*(exp(mPartialF[22]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[23]) < delta){
                rY[23] += mDt*d_dt_chaste_interface_var_Ca__Ca_ss;
            }
            else
            {
                rY[23] += (d_dt_chaste_interface_var_Ca__Ca_ss/mPartialF[23])*(exp(mPartialF[23]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[24]) < delta){
                rY[24] += mDt*d_dt_chaste_interface_var_Irel__R_prime;
            }
            else
            {
                rY[24] += (d_dt_chaste_interface_var_Irel__R_prime/mPartialF[24])*(exp(mPartialF[24]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[25]) < delta){
                rY[25] += mDt*d_dt_chaste_interface_var_Na__Na_i;
            }
            else
            {
                rY[25] += (d_dt_chaste_interface_var_Na__Na_i/mPartialF[25])*(exp(mPartialF[25]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[26]) < delta){
                rY[26] += mDt*d_dt_chaste_interface_var_K__K_i;
            }
            else
            {
                rY[26] += (d_dt_chaste_interface_var_K__K_i/mPartialF[26])*(exp(mPartialF[26]*mDt)-1.0);
            }
            
        }        
        
    }
   
    
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative0(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_cell__V;
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov__Or4 = rY[4];
        // Units: dimensionless; Initial value: 0.014
        double var_chaste_interface__iKs_Xs_gate__Xs = rY[11];
        // Units: dimensionless; Initial value: 0.00303
        double var_chaste_interface__ito_s_gate__s = rY[12];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__ito_r_gate__r = rY[13];
        // Units: dimensionless; Initial value: 2.11e-08
        double var_chaste_interface__iNa_m_gate__m = rY[14];
        // Units: dimensionless; Initial value: 0.00132
        double var_chaste_interface__iNa_h_gate__h = rY[15];
        // Units: dimensionless; Initial value: 0.7768
        double var_chaste_interface__iNa_j_gate__j = rY[16];
        // Units: dimensionless; Initial value: 0.7766
        double var_chaste_interface__iCaL_d_gate__d = rY[17];
        // Units: dimensionless; Initial value: 5.06e-06
        double var_chaste_interface__iCaL_f_gate__f = rY[18];
        // Units: dimensionless; Initial value: 0.9999
        double var_chaste_interface__iCaL_f2_gate__f2 = rY[19];
        // Units: dimensionless; Initial value: 0.9995
        double var_chaste_interface__iCaL_fCass_gate__fCass = rY[20];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__Ca__Ca_i = rY[21];
        // Units: millimolar; Initial value: 0.0001092
        double var_chaste_interface__Ca__Ca_ss = rY[23];
        // Units: millimolar; Initial value: 0.0001893
        double var_chaste_interface__Na__Na_i = rY[25];
        // Units: millimolar; Initial value: 7.940167
        double var_chaste_interface__K__K_i = rY[26];
        // Units: millimolar; Initial value: 141.0167
        
        
        // Mathematics
        const double var_IpCa__i_p_Ca = 0.061899999999999997 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i); // nanoA_per_nanoF
        const double var_INaCa__i_NaCa = 1.7332440459884893e-5 * (2.0 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.013101861787960915 * var_chaste_interface__cell__V) - 6860000.0 * var_chaste_interface__Ca__Ca_i * exp(-0.024332029034784559 * var_chaste_interface__cell__V)) / (1.0 + 0.10000000000000001 * exp(-0.024332029034784559 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double var_INaK__i_NaK = 1.0943437499999999 * var_chaste_interface__Na__Na_i / ((40.0 + var_chaste_interface__Na__Na_i) * (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__cell__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__cell__V))); // nanoA_per_nanoF
        const double var_cell__i_Stim = 1.0000000000000002 * GetIntracellularAreaStimulus(var_chaste_interface__Environment__time) / HeartConfig::Instance()->GetCapacitance(); // nanoA_per_nanoF
        const double var_ICaL__i_CaL = 0.28894573917650501 * (-2.0 + 0.25 * var_chaste_interface__Ca__Ca_ss * exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__cell__V)) * (-15.0 + var_chaste_interface__cell__V) * var_chaste_interface__iCaL_d_gate__d * var_chaste_interface__iCaL_f2_gate__f2 * var_chaste_interface__iCaL_fCass_gate__fCass * var_chaste_interface__iCaL_f_gate__f / (-1.0 + exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double var_ICab__i_b_Ca = 0.00047360000000000002 * var_chaste_interface__cell__V - 0.0063258185242159298 * log(2.0 / var_chaste_interface__Ca__Ca_i); // nanoA_per_nanoF
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // millivolt
        const double var_IKr__i_Kr = 0.024 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_chaste_interface__iKr_Markov__Or4; // nanoA_per_nanoF
        const double var_IpK__i_p_K = 0.0097300000000000008 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double var_Ito__i_to = 0.20000000000000001 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_chaste_interface__ito_r_gate__r * var_chaste_interface__ito_s_gate__s; // nanoA_per_nanoF
        const double var_IK1__i_K1 = 0.68210000000000004 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * (0.11619999999999997 / (1.0 + 0.036532500000000002 / exp(0.11701098901098901 * var_reversal_potentials__E_K - 0.10989010989010989 * var_chaste_interface__cell__V)) + 0.88380000000000003 * pow((1.0 + 0.079111111111111104 / exp(0.053239999999999996 * var_reversal_potentials__E_K - 0.050000000000000003 * var_chaste_interface__cell__V)), 2) / (pow((1.0 + 0.079111111111111104 / exp(0.053239999999999996 * var_reversal_potentials__E_K - 0.050000000000000003 * var_chaste_interface__cell__V)), 3) + 2.0875714285714286 / exp(-0.059333333333333335 + 0.22183333333333333 * var_reversal_potentials__E_K - 0.20833333333333334 * var_chaste_interface__cell__V) + 0.012714285714285714 / exp(0.005915555555555555 * var_reversal_potentials__E_K - 0.0055555555555555558 * var_chaste_interface__cell__V))); // nanoA_per_nanoF
        const double var_reversal_potentials__E_Na = 26.713760659695652 * log(140.0 / var_chaste_interface__Na__Na_i); // millivolt
        const double var_INa__i_Na = 11.0 * pow(var_chaste_interface__iNa_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__cell__V) * var_chaste_interface__iNa_h_gate__h * var_chaste_interface__iNa_j_gate__j; // nanoA_per_nanoF
        const double var_INab__i_b_Na = 0.00029 * var_chaste_interface__cell__V - 0.00029 * var_reversal_potentials__E_Na; // nanoA_per_nanoF
        const double var_IKs__i_Ks = 0.039199999999999999 * pow(var_chaste_interface__iKs_Xs_gate__Xs, 2) * (-26.713760659695652 * log(9.5999999999999996 / (0.029999999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V); // nanoA_per_nanoF
        d_dt_chaste_interface_var_cell__V = -var_ICaL__i_CaL - var_ICab__i_b_Ca - var_IK1__i_K1 - var_IKr__i_Kr - var_IKs__i_Ks - var_INa__i_Na - var_INaCa__i_NaCa - var_INaK__i_NaK - var_INab__i_b_Na - var_IpCa__i_p_Ca - var_IpK__i_p_K - var_Ito__i_to - var_cell__i_Stim; // millivolt / millisecond

        return d_dt_chaste_interface_var_cell__V;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative0(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            double var_chaste_interface__iKr_Markov__Or4 = rY[4];
            // Units: dimensionless; Initial value: 0.014
            double var_chaste_interface__iKs_Xs_gate__Xs = rY[11];
            // Units: dimensionless; Initial value: 0.00303
            double var_chaste_interface__ito_s_gate__s = rY[12];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__ito_r_gate__r = rY[13];
            // Units: dimensionless; Initial value: 2.11e-08
            double var_chaste_interface__iNa_m_gate__m = rY[14];
            // Units: dimensionless; Initial value: 0.00132
            double var_chaste_interface__iNa_h_gate__h = rY[15];
            // Units: dimensionless; Initial value: 0.7768
            double var_chaste_interface__iNa_j_gate__j = rY[16];
            // Units: dimensionless; Initial value: 0.7766
            double var_chaste_interface__iCaL_d_gate__d = rY[17];
            // Units: dimensionless; Initial value: 5.06e-06
            double var_chaste_interface__iCaL_f_gate__f = rY[18];
            // Units: dimensionless; Initial value: 0.9999
            double var_chaste_interface__iCaL_f2_gate__f2 = rY[19];
            // Units: dimensionless; Initial value: 0.9995
            double var_chaste_interface__iCaL_fCass_gate__fCass = rY[20];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__Ca__Ca_i = rY[21];
            // Units: millimolar; Initial value: 0.0001092
            double var_chaste_interface__Ca__Ca_ss = rY[23];
            // Units: millimolar; Initial value: 0.0001893
            double var_chaste_interface__Na__Na_i = rY[25];
            // Units: millimolar; Initial value: 7.940167
            double var_chaste_interface__K__K_i = rY[26];
            // Units: millimolar; Initial value: 141.0167
            
            const double var_x0 = pow(var_chaste_interface__iKs_Xs_gate__Xs, 2);
            const double var_x1 = exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__cell__V);
            const double var_x2 = 1.0 + var_x1;
            const double var_x3 = 1 / var_x2;
            const double var_x4 = 1 / var_chaste_interface__K__K_i;
            const double var_x5 = log(5.4000000000000004 * var_x4);
            const double var_x6 = -26.713760659695652 * var_x5 + var_chaste_interface__cell__V;
            const double var_x7 = 1 / exp(3.1258035549938383 * var_x5 - 0.10989010989010989 * var_chaste_interface__cell__V);
            const double var_x8 = 1.0 + 0.036532500000000002 * var_x7;
            const double var_x9 = var_x7 / pow(var_x8, 2);
            const double var_x10 = -0.050000000000000003 * var_chaste_interface__cell__V;
            const double var_x11 = 1 / exp(var_x10 + 1.4222406175221964 * var_x5);
            const double var_x12 = 1.0 + 0.079111111111111104 * var_x11;
            const double var_x13 = pow(var_x12, 3);
            const double var_x14 = 1 / exp(-0.059333333333333335 + 5.9260025730091517 * var_x5 - 0.20833333333333334 * var_chaste_interface__cell__V);
            const double var_x15 = 1 / exp(0.15802673528024405 * var_x5 - 0.0055555555555555558 * var_chaste_interface__cell__V);
            const double var_x16 = 1 / (var_x13 + 2.0875714285714286 * var_x14 + 0.012714285714285714 * var_x15);
            const double var_x17 = var_x11 * var_x12 * var_x16;
            const double var_x18 = pow(var_x12, 2);
            const double var_x19 = var_x11 * var_x18;
            const double var_x20 = -7.0634920634920635e-5 * var_x15 - 0.011866666666666666 * var_x19 - 0.43491071428571432 * var_x14;
            const double var_x21 = var_x18 / pow((var_x14 + 0.0060904673920481765 * var_x15 + 0.47902552521727226 * var_x13), 2);
            const double var_x22 = 0.13833094958532058 * var_x21;
            const double var_x23 = var_chaste_interface__ito_r_gate__r * var_chaste_interface__ito_s_gate__s;
            const double var_x24 = exp(-0.024332029034784559 * var_chaste_interface__cell__V);
            const double var_x25 = 1.0 + 0.10000000000000001 * var_x24;
            const double var_x26 = 1 / var_x25;
            const double var_x27 = var_x24 * var_chaste_interface__Ca__Ca_i;
            const double var_x28 = exp(0.013101861787960915 * var_chaste_interface__cell__V);
            const double var_x29 = var_x28 * pow(var_chaste_interface__Na__Na_i, 3);
            const double var_x30 = var_x26 * (166917.71917862206 * var_x27 + 0.026203723575921829 * var_x29);
            const double var_x31 = pow(var_chaste_interface__iNa_m_gate__m, 3);
            const double var_x32 = var_x31 * var_chaste_interface__iNa_j_gate__j;
            const double var_x33 = 11.0 * var_x32;
            const double var_x34 = 2.0 * var_x29 - 6860000.0 * var_x27;
            const double var_x35 = var_x24 * var_x34 / pow(var_x25, 2);
            const double var_x36 = var_x1 * var_x6 / pow(var_x2, 2);
            const double var_x37 = 1 / (40.0 + var_chaste_interface__Na__Na_i);
            const double var_x38 = exp(-0.037433890822745473 * var_chaste_interface__cell__V);
            const double var_x39 = exp(-0.0037433890822745472 * var_chaste_interface__cell__V);
            const double var_x40 = 1.0 + 0.035299999999999998 * var_x38 + 0.1245 * var_x39;
            const double var_x41 = var_x37 * (0.001321416346042915 * var_x38 + 0.00046605194074318115 * var_x39) * var_chaste_interface__Na__Na_i / pow(var_x40, 2);
            const double var_x42 = exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__cell__V);
            const double var_x43 = -1.0 + var_x42;
            const double var_x44 = 1 / var_x43;
            const double var_x45 = var_x44 * var_chaste_interface__iCaL_d_gate__d * var_chaste_interface__iCaL_f2_gate__f2 * var_chaste_interface__iCaL_fCass_gate__fCass * var_chaste_interface__iCaL_f_gate__f;
            const double var_x46 = var_x42 * var_chaste_interface__Ca__Ca_ss;
            const double var_x47 = -2.0 + 0.25 * var_x46;
            const double var_x48 = 0.28894573917650501 * var_x47;
            const double var_x49 = -15.0 + var_chaste_interface__cell__V;
            const double var_x50 = var_x42 * var_x49;
            const double var_x51 = var_x47 * var_x50 * var_chaste_interface__iCaL_d_gate__d * var_chaste_interface__iCaL_f2_gate__f2 * var_chaste_interface__iCaL_fCass_gate__fCass * var_chaste_interface__iCaL_f_gate__f / pow(var_x43, 2);
            const double var_x52 = var_x45 * var_x46 * var_x49;
            const double var_x53 = 1 / var_x8;
            const double var_x54 = var_x16 * var_x18;
            const double var_x55 = -0.60283998000000005 * var_x54 - 0.079260019999999987 * var_x53;
            
            partialF = -0.00076360000000000002 + var_x55 + 0.021632726508061556 * var_x51 - 0.039199999999999999 * var_x0 - 0.20000000000000001 * var_x23 - 0.0097300000000000008 * var_x3 - 0.005408181627015389 * var_x52 - 1.0943437499999999 * var_x41 - 4.2173344451359387e-8 * var_x35 - 1.7332440459884893e-5 * var_x30 - 0.024 * var_chaste_interface__iKr_Markov__Or4 - 0.0016270903010033445 * var_x36 + var_x6 * (0.00031819414073076916 * var_x9 - 0.0047691340640000001 * var_x17 - var_x20 * var_x22) - var_x33 * var_chaste_interface__iNa_h_gate__h - var_x45 * var_x48;
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative1(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov__Cr1 = rY[1];
        // Units: dimensionless; Initial value: 0.9786
        double var_chaste_interface__iKr_Markov__Cr2 = rY[2];
        // Units: dimensionless; Initial value: 0.0031
        
        
        // Mathematics
        const double var_iKr_Markov__alpha_xr1 = exp(-1.5790000000000006 + 0.0112 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr1 = exp(-2.0190000000000001 - 0.060299999999999999 * var_chaste_interface__cell__V); // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov__Cr1 = var_chaste_interface__iKr_Markov__Cr2 * var_iKr_Markov__beta_xr1 - var_chaste_interface__iKr_Markov__Cr1 * var_iKr_Markov__alpha_xr1; // 1 / millisecond

        return d_dt_chaste_interface_var_iKr_Markov__Cr1;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative1(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x87 = exp(-1.5790000000000006 + 0.0112 * var_chaste_interface__cell__V);
            const double var_x93 = var_x87;
            const double var_x94 = -var_x93;
            
            partialF = var_x94;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative2(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov__Cr1 = rY[1];
        // Units: dimensionless; Initial value: 0.9786
        double var_chaste_interface__iKr_Markov__Cr2 = rY[2];
        // Units: dimensionless; Initial value: 0.0031
        double var_chaste_interface__iKr_Markov__Cr3 = rY[3];
        // Units: dimensionless; Initial value: 0.0029
        
        
        // Mathematics
        const double var_iKr_Markov__alpha_xr1 = exp(-1.5790000000000006 + 0.0112 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__alpha_xr2 = exp(-3.1680000000000028); // per_millisecond
        const double var_iKr_Markov__beta_xr1 = exp(-2.0190000000000001 - 0.060299999999999999 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr2 = exp(-2.5140000000000011); // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov__Cr2 = var_chaste_interface__iKr_Markov__Cr1 * var_iKr_Markov__alpha_xr1 + var_chaste_interface__iKr_Markov__Cr3 * var_iKr_Markov__beta_xr2 - (var_iKr_Markov__alpha_xr2 + var_iKr_Markov__beta_xr1) * var_chaste_interface__iKr_Markov__Cr2; // 1 / millisecond

        return d_dt_chaste_interface_var_iKr_Markov__Cr2;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative2(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x90 = exp(-2.0190000000000001 - 0.060299999999999999 * var_chaste_interface__cell__V);
            const double var_x95 = var_x90;
            const double var_x96 = exp(-3.1680000000000028);
            const double var_x97 = -var_x95 - var_x96;
            
            partialF = var_x97;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative3(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov__Cr2 = rY[2];
        // Units: dimensionless; Initial value: 0.0031
        double var_chaste_interface__iKr_Markov__Cr3 = rY[3];
        // Units: dimensionless; Initial value: 0.0029
        double var_chaste_interface__iKr_Markov__Or4 = rY[4];
        // Units: dimensionless; Initial value: 0.014
        
        
        // Mathematics
        const double var_iKr_Markov__alpha_xr2 = exp(-3.1680000000000028); // per_millisecond
        const double var_iKr_Markov__alpha_xr3 = exp(-3.8160000000000025 + 0.036499999999999998 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr2 = exp(-2.5140000000000011); // per_millisecond
        const double var_iKr_Markov__beta_xr3 = exp(-8.3940000000000019 - 0.039899999999999998 * var_chaste_interface__cell__V); // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov__Cr3 = var_chaste_interface__iKr_Markov__Cr2 * var_iKr_Markov__alpha_xr2 + var_chaste_interface__iKr_Markov__Or4 * var_iKr_Markov__beta_xr3 - (var_iKr_Markov__alpha_xr3 + var_iKr_Markov__beta_xr2) * var_chaste_interface__iKr_Markov__Cr3; // 1 / millisecond

        return d_dt_chaste_interface_var_iKr_Markov__Cr3;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative3(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x98 = exp(-2.5140000000000011);
            const double var_x99 = exp(-3.8160000000000025 + 0.036499999999999998 * var_chaste_interface__cell__V);
            const double var_x104 = var_x99;
            const double var_x105 = -var_x104 - var_x98;
            
            partialF = var_x105;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative4(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov__Cr3 = rY[3];
        // Units: dimensionless; Initial value: 0.0029
        double var_chaste_interface__iKr_Markov__Or4 = rY[4];
        // Units: dimensionless; Initial value: 0.014
        double var_chaste_interface__iKr_Markov__Ir5 = rY[5];
        // Units: dimensionless; Initial value: 0.0014
        double var_chaste_interface__iKr_Markov_Sotalol_block__BOr4 = rY[9];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_iKr_Markov__alpha_xr3 = exp(-3.8160000000000025 + 0.036499999999999998 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__alpha_xr4 = exp(-0.87200000000000344 + 0.0223 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr3 = exp(-8.3940000000000019 - 0.039899999999999998 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr4 = exp(-3.1820000000000022 - 0.031199999999999999 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov_Sotalol_block__OtoB = 0; // per_millisecond
        const double var_iKr_Markov_Sotalol_block__BtoO = 0.00125 * var_chaste_interface__iKr_Markov_Sotalol_block__BOr4; // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov__Or4 = -var_iKr_Markov_Sotalol_block__OtoB + var_chaste_interface__iKr_Markov__Cr3 * var_iKr_Markov__alpha_xr3 + var_chaste_interface__iKr_Markov__Ir5 * var_iKr_Markov__beta_xr4 - (var_iKr_Markov__alpha_xr4 + var_iKr_Markov__beta_xr3) * var_chaste_interface__iKr_Markov__Or4 + var_iKr_Markov_Sotalol_block__BtoO; // 1 / millisecond

        return d_dt_chaste_interface_var_iKr_Markov__Or4;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative4(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x102 = exp(-8.3940000000000019 - 0.039899999999999998 * var_chaste_interface__cell__V);
            const double var_x106 = var_x102;
            const double var_x107 = exp(-0.87200000000000344 + 0.0223 * var_chaste_interface__cell__V);
            const double var_x113 = var_x107;
            const double var_x114 = -var_x106 - var_x113;
            
            partialF = var_x114;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative5(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov__Or4 = rY[4];
        // Units: dimensionless; Initial value: 0.014
        double var_chaste_interface__iKr_Markov__Ir5 = rY[5];
        // Units: dimensionless; Initial value: 0.0014
        
        
        // Mathematics
        const double var_iKr_Markov__alpha_xr4 = exp(-0.87200000000000344 + 0.0223 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr4 = exp(-3.1820000000000022 - 0.031199999999999999 * var_chaste_interface__cell__V); // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov__Ir5 = var_chaste_interface__iKr_Markov__Or4 * var_iKr_Markov__alpha_xr4 - var_chaste_interface__iKr_Markov__Ir5 * var_iKr_Markov__beta_xr4; // 1 / millisecond

        return d_dt_chaste_interface_var_iKr_Markov__Ir5;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative5(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x110 = exp(-3.1820000000000022 - 0.031199999999999999 * var_chaste_interface__cell__V);
            const double var_x115 = var_x110;
            const double var_x116 = -var_x115;
            
            partialF = var_x116;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative6(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov_Sotalol_block__BCr1 = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKr_Markov_Sotalol_block__BCr2 = rY[7];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_iKr_Markov__alpha_xr1 = exp(-1.5790000000000006 + 0.0112 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr1 = exp(-2.0190000000000001 - 0.060299999999999999 * var_chaste_interface__cell__V); // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr1 = var_iKr_Markov__beta_xr1 * var_chaste_interface__iKr_Markov_Sotalol_block__BCr2 - var_iKr_Markov__alpha_xr1 * var_chaste_interface__iKr_Markov_Sotalol_block__BCr1; // 1 / millisecond

        return d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr1;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative6(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x87 = exp(-1.5790000000000006 + 0.0112 * var_chaste_interface__cell__V);
            const double var_x93 = var_x87;
            const double var_x94 = -var_x93;
            
            partialF = var_x94;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative7(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov_Sotalol_block__BCr1 = rY[6];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKr_Markov_Sotalol_block__BCr2 = rY[7];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKr_Markov_Sotalol_block__BCr3 = rY[8];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_iKr_Markov__alpha_xr1 = exp(-1.5790000000000006 + 0.0112 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__alpha_xr2 = exp(-3.1680000000000028); // per_millisecond
        const double var_iKr_Markov__beta_xr1 = exp(-2.0190000000000001 - 0.060299999999999999 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr2 = exp(-2.5140000000000011); // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr2 = var_iKr_Markov__alpha_xr1 * var_chaste_interface__iKr_Markov_Sotalol_block__BCr1 + var_iKr_Markov__beta_xr2 * var_chaste_interface__iKr_Markov_Sotalol_block__BCr3 - (var_iKr_Markov__alpha_xr2 + var_iKr_Markov__beta_xr1) * var_chaste_interface__iKr_Markov_Sotalol_block__BCr2; // 1 / millisecond

        return d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr2;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative7(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x90 = exp(-2.0190000000000001 - 0.060299999999999999 * var_chaste_interface__cell__V);
            const double var_x95 = var_x90;
            const double var_x96 = exp(-3.1680000000000028);
            const double var_x97 = -var_x95 - var_x96;
            
            partialF = var_x97;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative8(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov_Sotalol_block__BCr2 = rY[7];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKr_Markov_Sotalol_block__BCr3 = rY[8];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKr_Markov_Sotalol_block__BOr4 = rY[9];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_iKr_Markov__alpha_xr2 = exp(-3.1680000000000028); // per_millisecond
        const double var_iKr_Markov__alpha_xr3 = exp(-3.8160000000000025 + 0.036499999999999998 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr2 = exp(-2.5140000000000011); // per_millisecond
        const double var_iKr_Markov__beta_xr3 = exp(-8.3940000000000019 - 0.039899999999999998 * var_chaste_interface__cell__V); // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr3 = var_iKr_Markov__alpha_xr2 * var_chaste_interface__iKr_Markov_Sotalol_block__BCr2 + var_iKr_Markov__beta_xr3 * var_chaste_interface__iKr_Markov_Sotalol_block__BOr4 - (var_iKr_Markov__alpha_xr3 + var_iKr_Markov__beta_xr2) * var_chaste_interface__iKr_Markov_Sotalol_block__BCr3; // 1 / millisecond

        return d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BCr3;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative8(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x98 = exp(-2.5140000000000011);
            const double var_x99 = exp(-3.8160000000000025 + 0.036499999999999998 * var_chaste_interface__cell__V);
            const double var_x104 = var_x99;
            const double var_x105 = -var_x104 - var_x98;
            
            partialF = var_x105;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative9(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov_Sotalol_block__BCr3 = rY[8];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKr_Markov_Sotalol_block__BOr4 = rY[9];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKr_Markov_Sotalol_block__BIr5 = rY[10];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_iKr_Markov__alpha_xr3 = exp(-3.8160000000000025 + 0.036499999999999998 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__alpha_xr4 = exp(-0.87200000000000344 + 0.0223 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr3 = exp(-8.3940000000000019 - 0.039899999999999998 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr4 = exp(-3.1820000000000022 - 0.031199999999999999 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov_Sotalol_block__OtoB = 0; // per_millisecond
        const double var_iKr_Markov_Sotalol_block__BtoO = 0.00125 * var_chaste_interface__iKr_Markov_Sotalol_block__BOr4; // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BOr4 = -var_iKr_Markov_Sotalol_block__BtoO + var_iKr_Markov__alpha_xr3 * var_chaste_interface__iKr_Markov_Sotalol_block__BCr3 + var_iKr_Markov__beta_xr4 * var_chaste_interface__iKr_Markov_Sotalol_block__BIr5 - (var_iKr_Markov__alpha_xr4 + var_iKr_Markov__beta_xr3) * var_chaste_interface__iKr_Markov_Sotalol_block__BOr4 + var_iKr_Markov_Sotalol_block__OtoB; // 1 / millisecond

        return d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BOr4;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative9(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x102 = exp(-8.3940000000000019 - 0.039899999999999998 * var_chaste_interface__cell__V);
            const double var_x106 = var_x102;
            const double var_x107 = exp(-0.87200000000000344 + 0.0223 * var_chaste_interface__cell__V);
            const double var_x113 = var_x107;
            const double var_x114 = -var_x106 - var_x113;
            
            partialF = -0.00125 + var_x114;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative10(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov_Sotalol_block__BOr4 = rY[9];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__iKr_Markov_Sotalol_block__BIr5 = rY[10];
        // Units: dimensionless; Initial value: 0.0
        
        
        // Mathematics
        const double var_iKr_Markov__alpha_xr4 = exp(-0.87200000000000344 + 0.0223 * var_chaste_interface__cell__V); // per_millisecond
        const double var_iKr_Markov__beta_xr4 = exp(-3.1820000000000022 - 0.031199999999999999 * var_chaste_interface__cell__V); // per_millisecond
        const double d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BIr5 = var_iKr_Markov__alpha_xr4 * var_chaste_interface__iKr_Markov_Sotalol_block__BOr4 - var_iKr_Markov__beta_xr4 * var_chaste_interface__iKr_Markov_Sotalol_block__BIr5; // 1 / millisecond

        return d_dt_chaste_interface_var_iKr_Markov_Sotalol_block__BIr5;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative10(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x110 = exp(-3.1820000000000022 - 0.031199999999999999 * var_chaste_interface__cell__V);
            const double var_x115 = var_x110;
            const double var_x116 = -var_x115;
            
            partialF = var_x116;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative11(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKs_Xs_gate__Xs = rY[11];
        // Units: dimensionless; Initial value: 0.00303
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_iKs_Xs_gate__Xs = (-var_chaste_interface__iKs_Xs_gate__Xs + 1 / (1.0 + exp(-0.35714285714285715 - 0.071428571428571425 * var_chaste_interface__cell__V))) / (80.0 + 1400.0 / (sqrt(1.0 + exp(0.83333333333333337 - 0.16666666666666666 * var_chaste_interface__cell__V)) * (1.0 + exp(-2.3333333333333335 + 0.066666666666666666 * var_chaste_interface__cell__V)))); // 1 / millisecond

        return d_dt_chaste_interface_var_iKs_Xs_gate__Xs;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative11(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x121 = -0.16666666666666666 * var_chaste_interface__cell__V;
            const double var_x122 = exp(0.83333333333333337 + var_x121);
            const double var_x123 = 1.0 + var_x122;
            const double var_x124 = 1 / sqrt(var_x123);
            const double var_x125 = exp(-2.3333333333333335 + 0.066666666666666666 * var_chaste_interface__cell__V);
            const double var_x126 = 1.0 + var_x125;
            const double var_x127 = 1 / var_x126;
            const double var_x128 = var_x124 * var_x127;
            const double var_x131 = 1 / (80.0 + 1400.0 * var_x128);
            
            partialF = -var_x131;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative12(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__ito_s_gate__s = rY[12];
        // Units: dimensionless; Initial value: 1.0
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_ito_s_gate__s = (-var_chaste_interface__ito_s_gate__s + 1 / (1.0 + exp(4.0 + 0.20000000000000001 * var_chaste_interface__cell__V))) / (3.0 + 5.0 / (1.0 + exp(-4.0 + 0.20000000000000001 * var_chaste_interface__cell__V)) + 85.0 * exp(-6.328125 * pow((1 + 0.022222222222222223 * var_chaste_interface__cell__V), 2))); // 1 / millisecond

        return d_dt_chaste_interface_var_ito_s_gate__s;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative12(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x132 = 0.20000000000000001 * var_chaste_interface__cell__V;
            const double var_x133 = exp(-4.0 + var_x132);
            const double var_x134 = 1.0 + var_x133;
            const double var_x135 = 1 / var_x134;
            const double var_x136 = exp(-6.328125 * pow((1 + 0.022222222222222223 * var_chaste_interface__cell__V), 2));
            const double var_x139 = 85.0 * var_x136;
            const double var_x140 = 1 / (3.0 + var_x139 + 5.0 * var_x135);
            
            partialF = -var_x140;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative13(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__ito_r_gate__r = rY[13];
        // Units: dimensionless; Initial value: 2.11e-08
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_ito_r_gate__r = (-var_chaste_interface__ito_r_gate__r + 1 / (1.0 + exp(3.3333333333333335 - 0.16666666666666666 * var_chaste_interface__cell__V))) / (0.80000000000000004 + 9.5 * exp(-0.88888888888888884 * pow((1 + 0.025000000000000001 * var_chaste_interface__cell__V), 2))); // 1 / millisecond

        return d_dt_chaste_interface_var_ito_r_gate__r;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative13(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x143 = exp(-0.88888888888888884 * pow((1 + 0.025000000000000001 * var_chaste_interface__cell__V), 2));
            const double var_x144 = 1 / (0.80000000000000004 + 9.5 * var_x143);
            
            partialF = -var_x144;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative14(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iNa_m_gate__m = rY[14];
        // Units: dimensionless; Initial value: 0.00132
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_iNa_m_gate__m = (1.0 + exp(-12.0 - 0.20000000000000001 * var_chaste_interface__cell__V)) * (-var_chaste_interface__iNa_m_gate__m + 1 / pow((1.0 + exp(-6.2967884828349945 - 0.11074197120708749 * var_chaste_interface__cell__V)), 2)) / (0.10000000000000001 / (1.0 + exp(7.0 + 0.20000000000000001 * var_chaste_interface__cell__V)) + 0.10000000000000001 / (1.0 + exp(-0.25 + 0.0050000000000000001 * var_chaste_interface__cell__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_iNa_m_gate__m;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative14(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x132 = 0.20000000000000001 * var_chaste_interface__cell__V;
            const double var_x145 = exp(7.0 + var_x132);
            const double var_x146 = 1.0 + var_x145;
            const double var_x147 = 1 / var_x146;
            const double var_x148 = exp(-0.25 + 0.0050000000000000001 * var_chaste_interface__cell__V);
            const double var_x149 = 1.0 + var_x148;
            const double var_x150 = 1 / var_x149;
            const double var_x151 = 1 / (0.10000000000000001 * var_x147 + 0.10000000000000001 * var_x150);
            const double var_x155 = exp(-12.0 - var_x132);
            const double var_x156 = 1.0 + var_x155;
            const double var_x157 = var_x151 * var_x156;
            
            partialF = -1.0 * var_x157;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative15(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iNa_h_gate__h = rY[15];
        // Units: dimensionless; Initial value: 0.7768
        
        
        // Mathematics
        const double var_INa__shift_INa_inact = 0; // millivolt
        const double d_dt_chaste_interface_var_iNa_h_gate__h = (-var_chaste_interface__iNa_h_gate__h + 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__cell__V - 0.13458950201884254 * var_INa__shift_INa_inact)), 2)) * (((var_chaste_interface__cell__V < -40.0 + var_INa__shift_INa_inact) ? (0.057000000000000002 * exp(-11.764705882352942 + 0.14705882352941177 * var_INa__shift_INa_inact - 0.14705882352941177 * var_chaste_interface__cell__V)) : (0)) + ((var_chaste_interface__cell__V < -40.0 + var_INa__shift_INa_inact) ? (310000.0 * exp(0.34849999999999998 * var_chaste_interface__cell__V - 0.34849999999999998 * var_INa__shift_INa_inact) + 2.7000000000000002 * exp(0.079000000000000001 * var_chaste_interface__cell__V - 0.079000000000000001 * var_INa__shift_INa_inact)) : (5.9230769230769234 / (1.0 + exp(-0.96036036036036043 + 0.0900900900900901 * var_INa__shift_INa_inact - 0.0900900900900901 * var_chaste_interface__cell__V))))); // 1 / millisecond

        return d_dt_chaste_interface_var_iNa_h_gate__h;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative15(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x162 = exp(0.34849999999999998 * var_chaste_interface__cell__V);
            const double var_x163 = exp(0.079000000000000001 * var_chaste_interface__cell__V);
            const double var_x164 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__cell__V);
            const double var_x165 = 310000.0 * var_x162;
            const double var_x166 = 2.7000000000000002 * var_x163;
            const double var_x167 = 0.057000000000000002 * var_x164;
            const double var_x170 = var_chaste_interface__cell__V < -40.0;
            const double var_x171 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__cell__V);
            const double var_x172 = 1.0 + var_x171;
            const double var_x173 = 1 / var_x172;
            
            partialF = ((var_x170) ? (-var_x165 - var_x166 - var_x167) : (-5.9230769230769234 * var_x173));
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative16(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iNa_j_gate__j = rY[16];
        // Units: dimensionless; Initial value: 0.7766
        
        
        // Mathematics
        const double var_INa__shift_INa_inact = 0; // millivolt
        const double d_dt_chaste_interface_var_iNa_j_gate__j = (-var_chaste_interface__iNa_j_gate__j + 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__cell__V - 0.13458950201884254 * var_INa__shift_INa_inact)), 2)) * (((var_chaste_interface__cell__V < -40.0 + var_INa__shift_INa_inact) ? (0.024240000000000001 * exp(0.01052 * var_INa__shift_INa_inact - 0.01052 * var_chaste_interface__cell__V) / (1.0 + exp(-5.5312920000000005 + 0.13780000000000001 * var_INa__shift_INa_inact - 0.13780000000000001 * var_chaste_interface__cell__V))) : (0.59999999999999998 * exp(0.057000000000000002 * var_chaste_interface__cell__V - 0.057000000000000002 * var_INa__shift_INa_inact) / (1.0 + exp(-3.2000000000000002 + 0.10000000000000001 * var_INa__shift_INa_inact - 0.10000000000000001 * var_chaste_interface__cell__V)))) + ((var_chaste_interface__cell__V < -40.0 + var_INa__shift_INa_inact) ? ((37.780000000000001 + var_chaste_interface__cell__V) * (-25428.0 * exp(0.24440000000000001 * var_chaste_interface__cell__V - 0.24440000000000001 * var_INa__shift_INa_inact) - 6.9480000000000002e-6 * exp(0.043909999999999998 * var_INa__shift_INa_inact - 0.043909999999999998 * var_chaste_interface__cell__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V - 0.311 * var_INa__shift_INa_inact))) : (0))); // 1 / millisecond

        return d_dt_chaste_interface_var_iNa_j_gate__j;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative16(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x170 = var_chaste_interface__cell__V < -40.0;
            const double var_x175 = exp(0.24440000000000001 * var_chaste_interface__cell__V);
            const double var_x176 = exp(-0.043909999999999998 * var_chaste_interface__cell__V);
            const double var_x177 = -25428.0 * var_x175 - 6.9480000000000002e-6 * var_x176;
            const double var_x178 = exp(24.640530000000002 + 0.311 * var_chaste_interface__cell__V);
            const double var_x179 = 1.0 + var_x178;
            const double var_x180 = 1 / var_x179;
            const double var_x181 = var_x177 * var_x180;
            const double var_x182 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__cell__V);
            const double var_x183 = 1.0 + var_x182;
            const double var_x184 = exp(-0.01052 * var_chaste_interface__cell__V);
            const double var_x185 = var_x184 / var_x183;
            const double var_x186 = 37.780000000000001 + var_chaste_interface__cell__V;
            const double var_x187 = 0.024240000000000001 * var_x185;
            const double var_x188 = var_x181 * var_x186;
            const double var_x189 = exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__cell__V);
            const double var_x190 = 1.0 + var_x189;
            const double var_x191 = exp(0.057000000000000002 * var_chaste_interface__cell__V);
            const double var_x192 = var_x191 / var_x190;
            
            partialF = ((var_x170) ? (-var_x187 - var_x188) : (-0.59999999999999998 * var_x192));
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative17(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iCaL_d_gate__d = rY[17];
        // Units: dimensionless; Initial value: 5.06e-06
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_iCaL_d_gate__d = (-var_chaste_interface__iCaL_d_gate__d + 1 / (1.0 + exp(0.66666666666666663 - 0.13333333333333333 * var_chaste_interface__cell__V))) / (1 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__cell__V)) + 1.3999999999999999 * (0.25 + 1.3999999999999999 / (1.0 + exp(-2.6923076923076925 - 0.076923076923076927 * var_chaste_interface__cell__V))) / (1.0 + exp(1.0 + 0.20000000000000001 * var_chaste_interface__cell__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_iCaL_d_gate__d;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative17(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x10 = -0.050000000000000003 * var_chaste_interface__cell__V;
            const double var_x132 = 0.20000000000000001 * var_chaste_interface__cell__V;
            const double var_x193 = exp(2.5 + var_x10);
            const double var_x194 = 1.0 + var_x193;
            const double var_x195 = 1 / var_x194;
            const double var_x196 = exp(1.0 + var_x132);
            const double var_x197 = 1.0 + var_x196;
            const double var_x198 = 1 / var_x197;
            const double var_x199 = exp(-2.6923076923076925 - 0.076923076923076927 * var_chaste_interface__cell__V);
            const double var_x200 = 1.0 + var_x199;
            const double var_x201 = 0.25 + 1.3999999999999999 / var_x200;
            const double var_x202 = var_x198 * var_x201;
            const double var_x205 = 1 / (var_x195 + 1.3999999999999999 * var_x202);
            
            partialF = -var_x205;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative18(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iCaL_f_gate__f = rY[18];
        // Units: dimensionless; Initial value: 0.9999
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_iCaL_f_gate__f = (-var_chaste_interface__iCaL_f_gate__f + 1 / (1.0 + exp(2.8571428571428572 + 0.14285714285714285 * var_chaste_interface__cell__V))) / (5.0 + 50.0 / (1.0 + exp(1.3 - 0.10000000000000001 * var_chaste_interface__cell__V)) + 45.0 / (1.0 + exp(3.0 + 0.10000000000000001 * var_chaste_interface__cell__V)) + 275.625 * exp(-3.2400000000000002 * pow((1 + 0.037037037037037035 * var_chaste_interface__cell__V), 2))); // 1 / millisecond

        return d_dt_chaste_interface_var_iCaL_f_gate__f;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative18(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x206 = 0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x207 = exp(3.0 + var_x206);
            const double var_x208 = 1.0 + var_x207;
            const double var_x209 = 1 / var_x208;
            const double var_x210 = -var_x206;
            const double var_x211 = exp(1.3 + var_x210);
            const double var_x212 = 1.0 + var_x211;
            const double var_x213 = 1 / var_x212;
            const double var_x214 = pow((1 + 0.037037037037037035 * var_chaste_interface__cell__V), 2);
            const double var_x215 = exp(-3.2400000000000002 * var_x214);
            const double var_x220 = 275.625 * var_x215;
            const double var_x221 = 1 / (5.0 + var_x220 + 50.0 * var_x213 + 45.0 * var_x209);
            
            partialF = -var_x221;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative19(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iCaL_f2_gate__f2 = rY[19];
        // Units: dimensionless; Initial value: 0.9995
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_iCaL_f2_gate__f2 = (0.25 - var_chaste_interface__iCaL_f2_gate__f2 + 0.75 / (1.0 + exp(5.0 + 0.14285714285714285 * var_chaste_interface__cell__V))) / (40.0 / (1.0 + exp(3.0 + 0.10000000000000001 * var_chaste_interface__cell__V)) + 15.5 / (1.0 + exp(2.5 - 0.10000000000000001 * var_chaste_interface__cell__V)) + 281.0 * exp(-3.0375000000000001 * pow((1 + 0.037037037037037035 * var_chaste_interface__cell__V), 2))); // 1 / millisecond

        return d_dt_chaste_interface_var_iCaL_f2_gate__f2;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative19(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            
            const double var_x206 = 0.10000000000000001 * var_chaste_interface__cell__V;
            const double var_x207 = exp(3.0 + var_x206);
            const double var_x208 = 1.0 + var_x207;
            const double var_x209 = 1 / var_x208;
            const double var_x210 = -var_x206;
            const double var_x214 = pow((1 + 0.037037037037037035 * var_chaste_interface__cell__V), 2);
            const double var_x222 = exp(2.5 + var_x210);
            const double var_x223 = 1.0 + var_x222;
            const double var_x224 = 1 / var_x223;
            const double var_x225 = exp(-3.0375000000000001 * var_x214);
            const double var_x228 = 281.0 * var_x225;
            const double var_x229 = 1 / (var_x228 + 40.0 * var_x209 + 15.5 * var_x224);
            
            partialF = -var_x229;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative20(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__iCaL_fCass_gate__fCass = rY[20];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__Ca__Ca_ss = rY[23];
        // Units: millimolar; Initial value: 0.0001893
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_iCaL_fCass_gate__fCass = (0.59999999999999998 - var_chaste_interface__iCaL_fCass_gate__fCass + 0.40000000000000002 / (1.0 + 399.99999999999994 * pow(var_chaste_interface__Ca__Ca_ss, 2))) / (2.0 + 80.0 / (1.0 + 399.99999999999994 * pow(var_chaste_interface__Ca__Ca_ss, 2))); // 1 / millisecond

        return d_dt_chaste_interface_var_iCaL_fCass_gate__fCass;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative20(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca__Ca_ss = rY[23];
            // Units: millimolar; Initial value: 0.0001893
            
            const double var_x230 = pow(var_chaste_interface__Ca__Ca_ss, 2);
            const double var_x231 = 1 / (1.0 + 399.99999999999994 * var_x230);
            const double var_x232 = 1 / (2.0 + 80.0 * var_x231);
            
            partialF = -var_x232;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative21(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__Ca__Ca_i = rY[21];
        // Units: millimolar; Initial value: 0.0001092
        double var_chaste_interface__Ca__Ca_SR = rY[22];
        // Units: millimolar; Initial value: 2.7656
        double var_chaste_interface__Ca__Ca_ss = rY[23];
        // Units: millimolar; Initial value: 0.0001893
        double var_chaste_interface__Na__Na_i = rY[25];
        // Units: millimolar; Initial value: 7.940167
        
        
        // Mathematics
        const double var_Ileak_Iup_Ixfer__i_leak = 0.00036000000000000002 * var_chaste_interface__Ca__Ca_SR - 0.00036000000000000002 * var_chaste_interface__Ca__Ca_i; // millimolar_per_millisecond
        const double var_Ileak_Iup_Ixfer__i_up = 0.0063749999999999996 / (1.0 + 6.2499999999999997e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)); // millimolar_per_millisecond
        const double var_Ileak_Iup_Ixfer__i_xfer = 0.0038 * var_chaste_interface__Ca__Ca_ss - 0.0038 * var_chaste_interface__Ca__Ca_i; // millimolar_per_millisecond
        const double var_IpCa__i_p_Ca = 0.061899999999999997 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i); // nanoA_per_nanoF
        const double var_INaCa__i_NaCa = 1.7332440459884893e-5 * (2.0 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.013101861787960915 * var_chaste_interface__cell__V) - 6860000.0 * var_chaste_interface__Ca__Ca_i * exp(-0.024332029034784559 * var_chaste_interface__cell__V)) / (1.0 + 0.10000000000000001 * exp(-0.024332029034784559 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double var_ICab__i_b_Ca = 0.00047360000000000002 * var_chaste_interface__cell__V - 0.0063258185242159298 * log(2.0 / var_chaste_interface__Ca__Ca_i); // nanoA_per_nanoF
        const double d_dt_chaste_interface_var_Ca__Ca_i = (0.066691050963179718 * var_Ileak_Iup_Ixfer__i_leak + 7.2658552465201267e-5 * var_INaCa__i_NaCa - 0.066691050963179718 * var_Ileak_Iup_Ixfer__i_up - 3.6329276232600633e-5 * var_ICab__i_b_Ca - 3.6329276232600633e-5 * var_IpCa__i_p_Ca + var_Ileak_Iup_Ixfer__i_xfer) / (1.0 + 0.00020000000000000001 / pow((0.001 + var_chaste_interface__Ca__Ca_i), 2)); // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca__Ca_i;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative21(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            double var_chaste_interface__Ca__Ca_i = rY[21];
            // Units: millimolar; Initial value: 0.0001092
            double var_chaste_interface__Ca__Ca_SR = rY[22];
            // Units: millimolar; Initial value: 2.7656
            double var_chaste_interface__Ca__Ca_ss = rY[23];
            // Units: millimolar; Initial value: 0.0001893
            double var_chaste_interface__Na__Na_i = rY[25];
            // Units: millimolar; Initial value: 7.940167
            
            const double var_x24 = exp(-0.024332029034784559 * var_chaste_interface__cell__V);
            const double var_x25 = 1.0 + 0.10000000000000001 * var_x24;
            const double var_x26 = 1 / var_x25;
            const double var_x27 = var_x24 * var_chaste_interface__Ca__Ca_i;
            const double var_x28 = exp(0.013101861787960915 * var_chaste_interface__cell__V);
            const double var_x29 = var_x28 * pow(var_chaste_interface__Na__Na_i, 3);
            const double var_x34 = 2.0 * var_x29 - 6860000.0 * var_x27;
            const double var_x68 = 0.00050000000000000001 + var_chaste_interface__Ca__Ca_i;
            const double var_x69 = 1 / var_x68;
            const double var_x70 = 1 / var_chaste_interface__Ca__Ca_i;
            const double var_x71 = var_chaste_interface__Ca__Ca_i / pow(var_x68, 2);
            const double var_x72 = var_x24 * var_x26;
            const double var_x234 = 0.001 + var_chaste_interface__Ca__Ca_i;
            const double var_x235 = 1.0 + 0.00020000000000000001 / pow(var_x234, 2);
            const double var_x236 = 1 / var_x235;
            const double var_x237 = var_x236;
            const double var_x238 = 2.2487821987979791e-6 * var_x69;
            const double var_x239 = 1.0 + 6.2499999999999997e-8 / pow(var_chaste_interface__Ca__Ca_i, 2);
            const double var_x240 = 1 / (pow(var_x239, 2) * pow(var_chaste_interface__Ca__Ca_i, 3));
            const double var_x241 = 1 / var_x239;
            
            partialF = var_x237 * (-0.0038240087783467445 - var_x238 + 2.2487821987979791e-6 * var_x71 - 0.0086391412367010315 * var_x72 - 5.3144431236283834e-11 * var_x240 - 2.298124085635426e-7 * var_x70) + 0.00040000000000000002 * (0.0038 * var_chaste_interface__Ca__Ca_ss + 2.40087783467447e-5 * var_chaste_interface__Ca__Ca_SR + 2.298124085635426e-7 * log(2.0 * var_x70) - 0.0038240087783467445 * var_chaste_interface__Ca__Ca_i - 1.7205545223759661e-8 * var_chaste_interface__cell__V - 0.00042515544989027063 * var_x241 - var_x238 * var_chaste_interface__Ca__Ca_i + 1.2593500345045236e-9 * var_x26 * var_x34) / (pow(var_x234, 3) * pow(var_x235, 2));
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative22(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca__Ca_i = rY[21];
        // Units: millimolar; Initial value: 0.0001092
        double var_chaste_interface__Ca__Ca_SR = rY[22];
        // Units: millimolar; Initial value: 2.7656
        double var_chaste_interface__Ca__Ca_ss = rY[23];
        // Units: millimolar; Initial value: 0.0001893
        double var_chaste_interface__Irel__R_prime = rY[24];
        // Units: dimensionless; Initial value: 0.9864
        
        
        // Mathematics
        const double var_Ileak_Iup_Ixfer__i_leak = 0.00036000000000000002 * var_chaste_interface__Ca__Ca_SR - 0.00036000000000000002 * var_chaste_interface__Ca__Ca_i; // millimolar_per_millisecond
        const double var_Ileak_Iup_Ixfer__i_up = 0.0063749999999999996 / (1.0 + 6.2499999999999997e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)); // millimolar_per_millisecond
        const double var_Irel__kcasr = 2.5 - 1.5 / (1.0 + 2.25 / pow(var_chaste_interface__Ca__Ca_SR, 2)); // dimensionless
        const double var_Irel__i_rel = 0.045899999999999996 * pow(var_chaste_interface__Ca__Ca_ss, 2) * (-var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_SR) * var_chaste_interface__Irel__R_prime / ((0.059999999999999998 + 0.14999999999999999 * pow(var_chaste_interface__Ca__Ca_ss, 2) / var_Irel__kcasr) * var_Irel__kcasr); // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_Ca__Ca_SR = (-var_Ileak_Iup_Ixfer__i_leak - var_Irel__i_rel + var_Ileak_Iup_Ixfer__i_up) / (1.0 + 3.0 / pow((0.29999999999999999 + var_chaste_interface__Ca__Ca_SR), 2)); // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca__Ca_SR;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative22(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca__Ca_i = rY[21];
            // Units: millimolar; Initial value: 0.0001092
            double var_chaste_interface__Ca__Ca_SR = rY[22];
            // Units: millimolar; Initial value: 2.7656
            double var_chaste_interface__Ca__Ca_ss = rY[23];
            // Units: millimolar; Initial value: 0.0001893
            double var_chaste_interface__Irel__R_prime = rY[24];
            // Units: dimensionless; Initial value: 0.9864
            
            const double var_x230 = pow(var_chaste_interface__Ca__Ca_ss, 2);
            const double var_x239 = 1.0 + 6.2499999999999997e-8 / pow(var_chaste_interface__Ca__Ca_i, 2);
            const double var_x241 = 1 / var_x239;
            const double var_x242 = 0.29999999999999999 + var_chaste_interface__Ca__Ca_SR;
            const double var_x243 = pow(var_x242, (-2));
            const double var_x244 = 1 / (1.0 + 3.0 * var_x243);
            const double var_x245 = var_x244;
            const double var_x246 = pow(var_chaste_interface__Ca__Ca_SR, (-2));
            const double var_x247 = 1 / (1.0 + 2.25 * var_x246);
            const double var_x248 = 1 / (2.5 - 1.5 * var_x247);
            const double var_x249 = var_x230 * var_x248;
            const double var_x250 = 1 / (0.059999999999999998 + 0.14999999999999999 * var_x249);
            const double var_x251 = var_x250 * var_chaste_interface__Irel__R_prime;
            const double var_x252 = var_x249 * var_x251;
            const double var_x253 = 0.045899999999999996 * var_x252;
            const double var_x254 = 1 / (pow((0.44444444444444442 + var_x246), 2) * pow(var_chaste_interface__Ca__Ca_SR, 3));
            const double var_x255 = -var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_SR;
            const double var_x256 = var_x255 / pow((1 - 0.59999999999999998 * var_x247), 2);
            const double var_x257 = var_x230 * var_x251 * var_x254 * var_x256;
            const double var_x258 = var_x254 * var_chaste_interface__Irel__R_prime;
            const double var_x259 = var_x256 / pow((0.40000000000000002 + var_x249), 2);
            const double var_x260 = var_x248 * var_x258 * var_x259 * pow(var_chaste_interface__Ca__Ca_ss, 4);
            
            partialF = var_x245 * (-0.00036000000000000002 - var_x253 + 0.065280000000000005 * var_x260 - 0.0097919999999999986 * var_x257) + 0.66666666666666674 * (0.00036000000000000002 * var_chaste_interface__Ca__Ca_i + 0.0063749999999999996 * var_x241 - 0.00036000000000000002 * var_chaste_interface__Ca__Ca_SR - var_x253 * var_x255) / (pow(var_x242, 3) * pow((0.33333333333333337 + var_x243), 2));
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative23(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iCaL_d_gate__d = rY[17];
        // Units: dimensionless; Initial value: 5.06e-06
        double var_chaste_interface__iCaL_f_gate__f = rY[18];
        // Units: dimensionless; Initial value: 0.9999
        double var_chaste_interface__iCaL_f2_gate__f2 = rY[19];
        // Units: dimensionless; Initial value: 0.9995
        double var_chaste_interface__iCaL_fCass_gate__fCass = rY[20];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__Ca__Ca_i = rY[21];
        // Units: millimolar; Initial value: 0.0001092
        double var_chaste_interface__Ca__Ca_SR = rY[22];
        // Units: millimolar; Initial value: 2.7656
        double var_chaste_interface__Ca__Ca_ss = rY[23];
        // Units: millimolar; Initial value: 0.0001893
        double var_chaste_interface__Irel__R_prime = rY[24];
        // Units: dimensionless; Initial value: 0.9864
        
        
        // Mathematics
        const double var_Ileak_Iup_Ixfer__i_xfer = 0.0038 * var_chaste_interface__Ca__Ca_ss - 0.0038 * var_chaste_interface__Ca__Ca_i; // millimolar_per_millisecond
        const double var_Irel__kcasr = 2.5 - 1.5 / (1.0 + 2.25 / pow(var_chaste_interface__Ca__Ca_SR, 2)); // dimensionless
        const double var_Irel__i_rel = 0.045899999999999996 * pow(var_chaste_interface__Ca__Ca_ss, 2) * (-var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_SR) * var_chaste_interface__Irel__R_prime / ((0.059999999999999998 + 0.14999999999999999 * pow(var_chaste_interface__Ca__Ca_ss, 2) / var_Irel__kcasr) * var_Irel__kcasr); // millimolar_per_millisecond
        const double var_ICaL__i_CaL = 0.28894573917650501 * (-2.0 + 0.25 * var_chaste_interface__Ca__Ca_ss * exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__cell__V)) * (-15.0 + var_chaste_interface__cell__V) * var_chaste_interface__iCaL_d_gate__d * var_chaste_interface__iCaL_f2_gate__f2 * var_chaste_interface__iCaL_fCass_gate__fCass * var_chaste_interface__iCaL_f_gate__f / (-1.0 + exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double d_dt_chaste_interface_var_Ca__Ca_ss = (20.007315288953912 * var_Irel__i_rel - 300.0 * var_Ileak_Iup_Ixfer__i_xfer - 0.01089878286978019 * var_ICaL__i_CaL) / (1.0 + 0.0001 / pow((0.00025000000000000001 + var_chaste_interface__Ca__Ca_ss), 2)); // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca__Ca_ss;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative23(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            double var_chaste_interface__iCaL_d_gate__d = rY[17];
            // Units: dimensionless; Initial value: 5.06e-06
            double var_chaste_interface__iCaL_f_gate__f = rY[18];
            // Units: dimensionless; Initial value: 0.9999
            double var_chaste_interface__iCaL_f2_gate__f2 = rY[19];
            // Units: dimensionless; Initial value: 0.9995
            double var_chaste_interface__iCaL_fCass_gate__fCass = rY[20];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__Ca__Ca_i = rY[21];
            // Units: millimolar; Initial value: 0.0001092
            double var_chaste_interface__Ca__Ca_SR = rY[22];
            // Units: millimolar; Initial value: 2.7656
            double var_chaste_interface__Ca__Ca_ss = rY[23];
            // Units: millimolar; Initial value: 0.0001893
            double var_chaste_interface__Irel__R_prime = rY[24];
            // Units: dimensionless; Initial value: 0.9864
            
            const double var_x42 = exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__cell__V);
            const double var_x43 = -1.0 + var_x42;
            const double var_x44 = 1 / var_x43;
            const double var_x45 = var_x44 * var_chaste_interface__iCaL_d_gate__d * var_chaste_interface__iCaL_f2_gate__f2 * var_chaste_interface__iCaL_fCass_gate__fCass * var_chaste_interface__iCaL_f_gate__f;
            const double var_x46 = var_x42 * var_chaste_interface__Ca__Ca_ss;
            const double var_x47 = -2.0 + 0.25 * var_x46;
            const double var_x49 = -15.0 + var_chaste_interface__cell__V;
            const double var_x50 = var_x42 * var_x49;
            const double var_x73 = var_x45 * var_x50;
            const double var_x230 = pow(var_chaste_interface__Ca__Ca_ss, 2);
            const double var_x246 = pow(var_chaste_interface__Ca__Ca_SR, (-2));
            const double var_x247 = 1 / (1.0 + 2.25 * var_x246);
            const double var_x248 = 1 / (2.5 - 1.5 * var_x247);
            const double var_x249 = var_x230 * var_x248;
            const double var_x250 = 1 / (0.059999999999999998 + 0.14999999999999999 * var_x249);
            const double var_x251 = var_x250 * var_chaste_interface__Irel__R_prime;
            const double var_x252 = var_x249 * var_x251;
            const double var_x255 = -var_chaste_interface__Ca__Ca_ss + var_chaste_interface__Ca__Ca_SR;
            const double var_x256 = var_x255 / pow((1 - 0.59999999999999998 * var_x247), 2);
            const double var_x259 = var_x256 / pow((0.40000000000000002 + var_x249), 2);
            const double var_x261 = var_x259 * pow(var_chaste_interface__Ca__Ca_ss, 3) * var_chaste_interface__Irel__R_prime;
            const double var_x262 = var_x248 * var_x251 * var_x255 * var_chaste_interface__Ca__Ca_ss;
            const double var_x264 = 0.0031491568724328674 * var_x47;
            const double var_x265 = var_x264 * var_x45;
            const double var_x266 = 0.00025000000000000001 + var_chaste_interface__Ca__Ca_ss;
            const double var_x267 = 1.0 + 0.0001 / pow(var_x266, 2);
            const double var_x268 = 1 / var_x267;
            const double var_x269 = var_x268;
            const double var_x273 = 0.91833577176298453 * var_x252;
            
            partialF = var_x269 * (-1.1399999999999999 - var_x273 + 1.8366715435259691 * var_x262 - 0.00078728921810821686 * var_x73 - 1.9591163130943672 * var_x261) + 0.00020000000000000001 * (1.1399999999999999 * var_chaste_interface__Ca__Ca_i - 1.1399999999999999 * var_chaste_interface__Ca__Ca_ss + var_x255 * var_x273 - var_x265 * var_x49) / (pow(var_x266, 3) * pow(var_x267, 2));
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative24(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca__Ca_SR = rY[22];
        // Units: millimolar; Initial value: 2.7656
        double var_chaste_interface__Ca__Ca_ss = rY[23];
        // Units: millimolar; Initial value: 0.0001893
        double var_chaste_interface__Irel__R_prime = rY[24];
        // Units: dimensionless; Initial value: 0.9864
        
        
        // Mathematics
        const double var_Irel__kcasr = 2.5 - 1.5 / (1.0 + 2.25 / pow(var_chaste_interface__Ca__Ca_SR, 2)); // dimensionless
        const double d_dt_chaste_interface_var_Irel__R_prime = 0.0050000000000000001 - 0.0050000000000000001 * var_chaste_interface__Irel__R_prime - 0.044999999999999998 * var_chaste_interface__Ca__Ca_ss * var_chaste_interface__Irel__R_prime * var_Irel__kcasr; // 1 / millisecond

        return d_dt_chaste_interface_var_Irel__R_prime;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative24(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca__Ca_SR = rY[22];
            // Units: millimolar; Initial value: 2.7656
            double var_chaste_interface__Ca__Ca_ss = rY[23];
            // Units: millimolar; Initial value: 0.0001893
            
            const double var_x246 = pow(var_chaste_interface__Ca__Ca_SR, (-2));
            const double var_x247 = 1 / (1.0 + 2.25 * var_x246);
            const double var_x274 = -0.11249999999999999 + 0.067500000000000004 * var_x247;
            
            partialF = -0.0050000000000000001 + var_x274 * var_chaste_interface__Ca__Ca_ss;
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative25(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iNa_m_gate__m = rY[14];
        // Units: dimensionless; Initial value: 0.00132
        double var_chaste_interface__iNa_h_gate__h = rY[15];
        // Units: dimensionless; Initial value: 0.7768
        double var_chaste_interface__iNa_j_gate__j = rY[16];
        // Units: dimensionless; Initial value: 0.7766
        double var_chaste_interface__Ca__Ca_i = rY[21];
        // Units: millimolar; Initial value: 0.0001092
        double var_chaste_interface__Na__Na_i = rY[25];
        // Units: millimolar; Initial value: 7.940167
        
        
        // Mathematics
        const double var_INaCa__i_NaCa = 1.7332440459884893e-5 * (2.0 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.013101861787960915 * var_chaste_interface__cell__V) - 6860000.0 * var_chaste_interface__Ca__Ca_i * exp(-0.024332029034784559 * var_chaste_interface__cell__V)) / (1.0 + 0.10000000000000001 * exp(-0.024332029034784559 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double var_INaK__i_NaK = 1.0943437499999999 * var_chaste_interface__Na__Na_i / ((40.0 + var_chaste_interface__Na__Na_i) * (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__cell__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__cell__V))); // nanoA_per_nanoF
        const double var_reversal_potentials__E_Na = 26.713760659695652 * log(140.0 / var_chaste_interface__Na__Na_i); // millivolt
        const double var_INa__i_Na = 11.0 * pow(var_chaste_interface__iNa_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__cell__V) * var_chaste_interface__iNa_h_gate__h * var_chaste_interface__iNa_j_gate__j; // nanoA_per_nanoF
        const double var_INab__i_b_Na = 0.00029 * var_chaste_interface__cell__V - 0.00029 * var_reversal_potentials__E_Na; // nanoA_per_nanoF
        const double d_dt_chaste_interface_var_Na__Na_i = -7.2658552465201267e-5 * var_INa__i_Na - 7.2658552465201267e-5 * var_INab__i_b_Na - 0.0002179756573956038 * var_INaCa__i_NaCa - 0.0002179756573956038 * var_INaK__i_NaK; // millimolar / millisecond

        return d_dt_chaste_interface_var_Na__Na_i;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative25(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            double var_chaste_interface__iNa_m_gate__m = rY[14];
            // Units: dimensionless; Initial value: 0.00132
            double var_chaste_interface__iNa_h_gate__h = rY[15];
            // Units: dimensionless; Initial value: 0.7768
            double var_chaste_interface__iNa_j_gate__j = rY[16];
            // Units: dimensionless; Initial value: 0.7766
            double var_chaste_interface__Na__Na_i = rY[25];
            // Units: millimolar; Initial value: 7.940167
            
            const double var_x24 = exp(-0.024332029034784559 * var_chaste_interface__cell__V);
            const double var_x25 = 1.0 + 0.10000000000000001 * var_x24;
            const double var_x26 = 1 / var_x25;
            const double var_x28 = exp(0.013101861787960915 * var_chaste_interface__cell__V);
            const double var_x31 = pow(var_chaste_interface__iNa_m_gate__m, 3);
            const double var_x32 = var_x31 * var_chaste_interface__iNa_j_gate__j;
            const double var_x37 = 1 / (40.0 + var_chaste_interface__Na__Na_i);
            const double var_x38 = exp(-0.037433890822745473 * var_chaste_interface__cell__V);
            const double var_x39 = exp(-0.0037433890822745472 * var_chaste_interface__cell__V);
            const double var_x40 = 1.0 + 0.035299999999999998 * var_x38 + 0.1245 * var_x39;
            const double var_x59 = 1 / var_chaste_interface__Na__Na_i;
            const double var_x74 = 1 / var_x40;
            const double var_x75 = var_x37 * var_x74;
            const double var_x76 = var_x74 * var_chaste_interface__Na__Na_i / pow((1 + 0.025000000000000001 * var_chaste_interface__Na__Na_i), 2);
            const double var_x77 = var_x26 * var_x28 * pow(var_chaste_interface__Na__Na_i, 2);
            const double var_x79 = var_x32 * var_x59 * var_chaste_interface__iNa_h_gate__h;
            
            partialF = 1.4908768645188767e-7 * var_x76 - 5.6288512232624455e-7 * var_x59 - 0.021350814984788587 * var_x79 - 2.2668300621081427e-8 * var_x77 - 0.00023854029832302029 * var_x75;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluateYDerivative26(double var_chaste_interface__Environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -86.45
        double var_chaste_interface__iKr_Markov__Or4 = rY[4];
        // Units: dimensionless; Initial value: 0.014
        double var_chaste_interface__iKs_Xs_gate__Xs = rY[11];
        // Units: dimensionless; Initial value: 0.00303
        double var_chaste_interface__ito_s_gate__s = rY[12];
        // Units: dimensionless; Initial value: 1.0
        double var_chaste_interface__ito_r_gate__r = rY[13];
        // Units: dimensionless; Initial value: 2.11e-08
        double var_chaste_interface__Na__Na_i = rY[25];
        // Units: millimolar; Initial value: 7.940167
        double var_chaste_interface__K__K_i = rY[26];
        // Units: millimolar; Initial value: 141.0167
        
        
        // Mathematics
        const double var_INaK__i_NaK = 1.0943437499999999 * var_chaste_interface__Na__Na_i / ((40.0 + var_chaste_interface__Na__Na_i) * (1.0 + 0.035299999999999998 * exp(-0.037433890822745473 * var_chaste_interface__cell__V) + 0.1245 * exp(-0.0037433890822745472 * var_chaste_interface__cell__V))); // nanoA_per_nanoF
        const double var_cell__i_Stim = 1.0000000000000002 * GetIntracellularAreaStimulus(var_chaste_interface__Environment__time) / HeartConfig::Instance()->GetCapacitance(); // nanoA_per_nanoF
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // millivolt
        const double var_IKr__i_Kr = 0.024 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_chaste_interface__iKr_Markov__Or4; // nanoA_per_nanoF
        const double var_IpK__i_p_K = 0.0097300000000000008 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__cell__V)); // nanoA_per_nanoF
        const double var_Ito__i_to = 0.20000000000000001 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * var_chaste_interface__ito_r_gate__r * var_chaste_interface__ito_s_gate__s; // nanoA_per_nanoF
        const double var_IK1__i_K1 = 0.68210000000000004 * (-var_reversal_potentials__E_K + var_chaste_interface__cell__V) * (0.11619999999999997 / (1.0 + 0.036532500000000002 / exp(0.11701098901098901 * var_reversal_potentials__E_K - 0.10989010989010989 * var_chaste_interface__cell__V)) + 0.88380000000000003 * pow((1.0 + 0.079111111111111104 / exp(0.053239999999999996 * var_reversal_potentials__E_K - 0.050000000000000003 * var_chaste_interface__cell__V)), 2) / (pow((1.0 + 0.079111111111111104 / exp(0.053239999999999996 * var_reversal_potentials__E_K - 0.050000000000000003 * var_chaste_interface__cell__V)), 3) + 2.0875714285714286 / exp(-0.059333333333333335 + 0.22183333333333333 * var_reversal_potentials__E_K - 0.20833333333333334 * var_chaste_interface__cell__V) + 0.012714285714285714 / exp(0.005915555555555555 * var_reversal_potentials__E_K - 0.0055555555555555558 * var_chaste_interface__cell__V))); // nanoA_per_nanoF
        const double var_IKs__i_Ks = 0.039199999999999999 * pow(var_chaste_interface__iKs_Xs_gate__Xs, 2) * (-26.713760659695652 * log(9.5999999999999996 / (0.029999999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__cell__V); // nanoA_per_nanoF
        const double d_dt_chaste_interface_var_K__K_i = 0.00014531710493040253 * var_INaK__i_NaK - 7.2658552465201267e-5 * var_IK1__i_K1 - 7.2658552465201267e-5 * var_IKr__i_Kr - 7.2658552465201267e-5 * var_IKs__i_Ks - 7.2658552465201267e-5 * var_IpK__i_p_K - 7.2658552465201267e-5 * var_Ito__i_to - 7.2658552465201267e-5 * var_cell__i_Stim; // millimolar / millisecond

        return d_dt_chaste_interface_var_K__K_i;
    }

    double Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::EvaluatePartialDerivative26(double var_chaste_interface__Environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__cell__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -86.45
            double var_chaste_interface__iKr_Markov__Or4 = rY[4];
            // Units: dimensionless; Initial value: 0.014
            double var_chaste_interface__iKs_Xs_gate__Xs = rY[11];
            // Units: dimensionless; Initial value: 0.00303
            double var_chaste_interface__ito_s_gate__s = rY[12];
            // Units: dimensionless; Initial value: 1.0
            double var_chaste_interface__ito_r_gate__r = rY[13];
            // Units: dimensionless; Initial value: 2.11e-08
            double var_chaste_interface__Na__Na_i = rY[25];
            // Units: millimolar; Initial value: 7.940167
            double var_chaste_interface__K__K_i = rY[26];
            // Units: millimolar; Initial value: 141.0167
            
            const double var_x0 = pow(var_chaste_interface__iKs_Xs_gate__Xs, 2);
            const double var_x1 = exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__cell__V);
            const double var_x2 = 1.0 + var_x1;
            const double var_x3 = 1 / var_x2;
            const double var_x4 = 1 / var_chaste_interface__K__K_i;
            const double var_x5 = log(5.4000000000000004 * var_x4);
            const double var_x6 = -26.713760659695652 * var_x5 + var_chaste_interface__cell__V;
            const double var_x7 = 1 / exp(3.1258035549938383 * var_x5 - 0.10989010989010989 * var_chaste_interface__cell__V);
            const double var_x8 = 1.0 + 0.036532500000000002 * var_x7;
            const double var_x9 = var_x7 / pow(var_x8, 2);
            const double var_x10 = -0.050000000000000003 * var_chaste_interface__cell__V;
            const double var_x11 = 1 / exp(var_x10 + 1.4222406175221964 * var_x5);
            const double var_x12 = 1.0 + 0.079111111111111104 * var_x11;
            const double var_x13 = pow(var_x12, 3);
            const double var_x14 = 1 / exp(-0.059333333333333335 + 5.9260025730091517 * var_x5 - 0.20833333333333334 * var_chaste_interface__cell__V);
            const double var_x15 = 1 / exp(0.15802673528024405 * var_x5 - 0.0055555555555555558 * var_chaste_interface__cell__V);
            const double var_x16 = 1 / (var_x13 + 2.0875714285714286 * var_x14 + 0.012714285714285714 * var_x15);
            const double var_x17 = var_x11 * var_x12 * var_x16;
            const double var_x18 = pow(var_x12, 2);
            const double var_x19 = var_x11 * var_x18;
            const double var_x21 = var_x18 / pow((var_x14 + 0.0060904673920481765 * var_x15 + 0.47902552521727226 * var_x13), 2);
            const double var_x23 = var_chaste_interface__ito_r_gate__r * var_chaste_interface__ito_s_gate__s;
            const double var_x53 = 1 / var_x8;
            const double var_x54 = var_x16 * var_x18;
            const double var_x56 = 0.029999999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i;
            const double var_x78 = var_x0 * (0.0031249999999999997 * var_chaste_interface__Na__Na_i + 0.10416666666666667 * var_chaste_interface__K__K_i) / pow(var_x56, 2);
            const double var_x80 = var_x4 * var_x9;
            const double var_x81 = -12.370953657054676 * var_x14 * var_x4 - 0.33754510655860126 * var_x19 * var_x4 - 0.0020091970628488172 * var_x15 * var_x4;
            const double var_x82 = var_x17 * var_x4;
            const double var_x83 = 26.713760659695652 * var_x4;
            const double var_x84 = var_x4 * var_chaste_interface__iKr_Markov__Or4;
            const double var_x85 = var_x3 * var_x4;
            const double var_x86 = var_x23 * var_x4;
            const double var_x276 = 1.0050926558006126e-5 * var_x21;
            const double var_x277 = -4.3801480314950888e-5 * var_x54 - 5.7589183215629007e-6 * var_x53;
            
            partialF = -4.6583596330447822e-5 * var_x84 - 1.8885766345635723e-5 * var_x85 - 0.00038819663608706523 * var_x86 - 0.00073043079046142181 * var_x78 + var_x277 * var_x83 + var_x6 * (6.576305692690868e-7 * var_x80 - 9.8566502268897146e-6 * var_x82 - var_x276 * var_x81);
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__Environment__time, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }

    std::vector<double> Cellfink_noble_giles_model_2008FromCellMLGRL1Opt::ComputeDerivedQuantities(double var_chaste_interface__Environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_cell__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__Environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__Environment__time;
        dqs[1] = var_cell__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellfink_noble_giles_model_2008FromCellMLGRL1Opt>::Initialise(void)
{
    this->mSystemName = "fink_noble_giles_model_2008";
    this->mFreeVariableName = "Environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-86.45);

    // rY[1]:
    this->mVariableNames.push_back("iKr_Markov__Cr1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9786);

    // rY[2]:
    this->mVariableNames.push_back("iKr_Markov__Cr2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0031);

    // rY[3]:
    this->mVariableNames.push_back("iKr_Markov__Cr3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0029);

    // rY[4]:
    this->mVariableNames.push_back("iKr_Markov__Or4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.014);

    // rY[5]:
    this->mVariableNames.push_back("iKr_Markov__Ir5");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0014);

    // rY[6]:
    this->mVariableNames.push_back("iKr_Markov_Sotalol_block__BCr1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[7]:
    this->mVariableNames.push_back("iKr_Markov_Sotalol_block__BCr2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[8]:
    this->mVariableNames.push_back("iKr_Markov_Sotalol_block__BCr3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[9]:
    this->mVariableNames.push_back("iKr_Markov_Sotalol_block__BOr4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[10]:
    this->mVariableNames.push_back("iKr_Markov_Sotalol_block__BIr5");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[11]:
    this->mVariableNames.push_back("iKs_Xs_gate__Xs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00303);

    // rY[12]:
    this->mVariableNames.push_back("ito_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // rY[13]:
    this->mVariableNames.push_back("ito_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.11e-08);

    // rY[14]:
    this->mVariableNames.push_back("iNa_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00132);

    // rY[15]:
    this->mVariableNames.push_back("iNa_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.7768);

    // rY[16]:
    this->mVariableNames.push_back("iNa_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.7766);

    // rY[17]:
    this->mVariableNames.push_back("iCaL_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(5.06e-06);

    // rY[18]:
    this->mVariableNames.push_back("iCaL_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999);

    // rY[19]:
    this->mVariableNames.push_back("iCaL_f2_gate__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9995);

    // rY[20]:
    this->mVariableNames.push_back("iCaL_fCass_gate__fCass");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.0);

    // rY[21]:
    this->mVariableNames.push_back("Ca__Ca_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0001092);

    // rY[22]:
    this->mVariableNames.push_back("Ca__Ca_SR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.7656);

    // rY[23]:
    this->mVariableNames.push_back("Ca__Ca_ss");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0001893);

    // rY[24]:
    this->mVariableNames.push_back("Irel__R_prime");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9864);

    // rY[25]:
    this->mVariableNames.push_back("Na__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.940167);

    // rY[26]:
    this->mVariableNames.push_back("K__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(141.0167);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("Environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellfink_noble_giles_model_2008FromCellMLGRL1Opt)

