//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: demir_model_1994
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "demir_model_1994.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    double Celldemir_model_1994FromCellMLGRL1Opt::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Celldemir_model_1994FromCellMLGRL1Opt::Celldemir_model_1994FromCellMLGRL1Opt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                27,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celldemir_model_1994FromCellMLGRL1Opt>::Instance();
        Init();
        
        this->mParameters[0] = 5.5000000000000002e-5; // (var_membrane__Cm) [microF]
    }

    Celldemir_model_1994FromCellMLGRL1Opt::~Celldemir_model_1994FromCellMLGRL1Opt()
    {
    }
    
    double Celldemir_model_1994FromCellMLGRL1Opt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        const double var_calcium_pump_current__i_Ca_P = 0.02869 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_L_type_Ca_channel__i_Ca_L = 0.021149999999999999 * (-46.399999999999999 + var_chaste_interface__membrane__V) * (0.095000000000000001 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L); // nanoA
        const double var_T_type_Ca_channel__i_Ca_T = 0.02521 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_hyperpolarisation_activated_current__i_f = 0.0128821 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V) + 0.0067478 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V); // nanoA
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i); // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = 0.018743278268729353 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_reversal_potentials__E_Na = 26.713760659695652 * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i); // millivolt
        const double var_linear_background_current__i_B = 0.00026580000000000001 * var_chaste_interface__membrane__V - 6.9400000000000006e-5 * var_reversal_potentials__E_K - 0.00016000000000000001 * var_reversal_potentials__E_Na - 0.00048619044400646078 * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_sodium_calcium_pump__i_NaCa = 1.2480000000000001e-5 * (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.018714999999999999 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(-0.018714999999999999 * var_chaste_interface__membrane__V)) / (1.0 + 0.0001 * pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + 0.0001 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c); // nanoA
        const double var_sodium_current__i_Na = 12.424666784589714 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V - 0.037433890822745473 * var_reversal_potentials__E_Na)) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_sodium_potassium_pump__i_NaK = 0.0021546791260593943 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) / (pow((1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i), 3) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((0.621 + var_chaste_interface__cleft_space_equations__K_c), 2)); // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_calcium_pump_current__i_Ca_P + var_delayed_rectifying_potassium_current__i_K + var_hyperpolarisation_activated_current__i_f + var_linear_background_current__i_B + var_sodium_calcium_pump__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celldemir_model_1994FromCellMLGRL1Opt::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;

        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        

        // Mathematics
        const double var_calcium_pump_current__i_Ca_P = 0.02869 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = 0.021149999999999999 * (-46.399999999999999 + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L); // nanoA
        const double var_T_type_Ca_channel__i_Ca_T = 0.02521 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = 0.0128821 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V); // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = 0.0067478 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V); // nanoA
        const double var_linear_background_current__i_B_Ca = 3.6399999999999997e-5 * var_chaste_interface__membrane__V - 0.00048619044400646078 * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i); // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = 0.018743278268729353 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = 6.9400000000000006e-5 * var_chaste_interface__membrane__V - 6.9400000000000006e-5 * var_reversal_potentials__E_K; // nanoA
        const double var_reversal_potentials__E_Na = 26.713760659695652 * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i); // millivolt
        const double var_linear_background_current__i_B_Na = 0.00016000000000000001 * var_chaste_interface__membrane__V - 0.00016000000000000001 * var_reversal_potentials__E_Na; // nanoA
        const double var_sodium_calcium_pump__i_NaCa = 1.2480000000000001e-5 * (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.018714999999999999 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(-0.018714999999999999 * var_chaste_interface__membrane__V)) / (1.0 + 0.0001 * pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + 0.0001 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c); // nanoA
        const double var_sodium_current__i_Na = 12.424666784589714 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V - 0.037433890822745473 * var_reversal_potentials__E_Na)) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_sodium_potassium_pump__i_NaK = 0.0021546791260593943 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) / (pow((1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i), 3) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((0.621 + var_chaste_interface__cleft_space_equations__K_c), 2)); // nanoA
        d_dt_chaste_interface_var_membrane__V = 0.001 * (-var_L_type_Ca_channel__i_Ca_L - var_T_type_Ca_channel__i_Ca_T - var_calcium_pump_current__i_Ca_P - var_delayed_rectifying_potassium_current__i_K - var_hyperpolarisation_activated_current__i_f_K - var_hyperpolarisation_activated_current__i_f_Na - var_linear_background_current__i_B_Ca - var_linear_background_current__i_B_K - var_linear_background_current__i_B_Na - var_sodium_calcium_pump__i_NaCa - var_sodium_current__i_Na - var_sodium_potassium_pump__i_NaK) / mParameters[0]; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Celldemir_model_1994FromCellMLGRL1Opt::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta = 1e-8;

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod = rY[14];
        // Units: dimensionless; Initial value: 0.1411678
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop = rY[15];
        // Units: dimensionless; Initial value: 0.07331396
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = rY[16];
        // Units: dimensionless; Initial value: 0.7618549
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = rY[17];
        // Units: dimensionless; Initial value: 0.2097049
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rY[21];
        // Units: millimolar; Initial value: 16.95311
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rY[22];
        // Units: millimolar; Initial value: 16.85024
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse = rY[23];
        // Units: dimensionless; Initial value: 0.9528726
        double var_chaste_interface__SR_Ca_uptake_and_release__F1 = rY[24];
        // Units: dimensionless; Initial value: 0.1133251
        double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rY[25];
        // Units: dimensionless; Initial value: 0.0007594214
        double var_chaste_interface__SR_Ca_uptake_and_release__F3 = rY[26];
        // Units: dimensionless; Initial value: 0.8859153
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__i_rel = 0.5 * pow(var_chaste_interface__SR_Ca_uptake_and_release__F2, 2) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel / pow((0.25 + var_chaste_interface__SR_Ca_uptake_and_release__F2), 2); // nanoA
        const double var_SR_Ca_uptake_and_release__phi_Calse = -641.0 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse + 770.0 * (1.0 - var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel; // per_second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_Calse = 0.001 * var_SR_Ca_uptake_and_release__phi_Calse; // 1 / millisecond
        const double var_SR_Ca_uptake_and_release__i_up = (0.080000000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i - 1.4727272727272728e-7 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up) / (9.5000000000000005e-5 + 2.0454545454545457e-6 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_SR_Ca_uptake_and_release__r_inact = 40.0 + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((0.0040000000000000001 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F3 = -0.00095999999999999992 * var_chaste_interface__SR_Ca_uptake_and_release__F3 + 0.001 * var_chaste_interface__SR_Ca_uptake_and_release__F2 * var_SR_Ca_uptake_and_release__r_inact; // 1 / millisecond
        const double var_calcium_pump_current__i_Ca_P = 0.02869 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_intracellular_concentrations_and_buffer_equations__phi_C = -307.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Calmod = 0.001 * var_intracellular_concentrations_and_buffer_equations__phi_C; // 1 / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__phi_TC = -252.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop + 50500.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__phi_TC; // 1 / millisecond
        const double var_intracellular_concentrations_and_buffer_equations__phi_TMgC = -4.25 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__phi_TMgC; // 1 / millisecond
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = 3.2250000000000001 - 3.2250000000000001 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - 3.6539999999999999 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop; // 1 / millisecond
        const double var_SR_Ca_uptake_and_release__i_tr = 0.05700838747761728 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up - 0.05700838747761728 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel; // nanoA
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_rel = 2.4589804690256458 * var_SR_Ca_uptake_and_release__i_tr - 0.011480000000000001 * var_SR_Ca_uptake_and_release__phi_Calse - 2.4589804690256458 * var_SR_Ca_uptake_and_release__i_rel; // millimolar / millisecond
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_up = 0.27331378111983162 * var_SR_Ca_uptake_and_release__i_up - 0.27331378111983162 * var_SR_Ca_uptake_and_release__i_tr; // millimolar / millisecond
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = 0.021149999999999999 * (-46.399999999999999 + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L); // nanoA
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L = 0.001 * (-var_chaste_interface__L_type_Ca_channel_d_gate__d_L + var_L_type_Ca_channel_d_gate__d_L_infinity) * (11.43 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)) - 28.390000000000001 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V)) - 84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L = 0.001 * (-var_chaste_interface__L_type_Ca_channel_f_gate__f_L + 1 / (1.0 + exp(6.0 + 0.20000000000000001 * var_chaste_interface__membrane__V))) * (30.0 / (1.0 + exp(-7.0 - 0.25 * var_chaste_interface__membrane__V)) + 3.75 * (28.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(7.0 + 0.25 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double var_SR_Ca_uptake_and_release__r_act = 240.0 * exp(-3.2000000000000002 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((0.0040000000000000001 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F1 = 0.00095999999999999992 * var_chaste_interface__SR_Ca_uptake_and_release__F3 - 0.001 * var_chaste_interface__SR_Ca_uptake_and_release__F1 * var_SR_Ca_uptake_and_release__r_act; // 1 / millisecond
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F2 = 0.001 * var_chaste_interface__SR_Ca_uptake_and_release__F1 * var_SR_Ca_uptake_and_release__r_act - 0.001 * var_chaste_interface__SR_Ca_uptake_and_release__F2 * var_SR_Ca_uptake_and_release__r_inact; // 1 / millisecond
        const double var_T_type_Ca_channel__i_Ca_T = 0.02521 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T = 0.001 * (-var_chaste_interface__T_type_Ca_channel_d_gate__d_T + 1 / (1.0 + exp(-4.3833333333333337 - 0.16666666666666666 * var_chaste_interface__membrane__V))) * (1068.0 * exp(0.87666666666666671 + 0.033333333333333333 * var_chaste_interface__membrane__V) + 1068.0 * exp(-0.87666666666666671 - 0.033333333333333333 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T = 0.001 * (-var_chaste_interface__T_type_Ca_channel_f_gate__f_T + 1 / (1.0 + exp(11.017857142857144 + 0.17857142857142858 * var_chaste_interface__membrane__V))) * (15.0 * exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V) + 15.300000000000001 * exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_a_gate__P_a = 0.001 * (-var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a + 1 / (1.0 + exp(-0.68918918918918914 - 0.13513513513513511 * var_chaste_interface__membrane__V))) * (17.0 * exp(0.039800000000000002 * var_chaste_interface__membrane__V) + 2.1099999999999999 * exp(-0.050999999999999997 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_i_gate__P_i = 0.10000000000000001 * (1.0 - var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i) * exp(-0.0183 * var_chaste_interface__membrane__V) - 0.65600000000000003 * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i * exp(0.0094199999999999996 * var_chaste_interface__membrane__V); // 1 / millisecond
        const double var_hyperpolarisation_activated_current__i_f_K = 0.0128821 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V); // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = 0.0067478 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V); // nanoA
        const double d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y = 0.001 * (-var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + 1 / (1.0 + exp(8.0222222222222221 + 0.1111111111111111 * var_chaste_interface__membrane__V))) * (1.6483000000000001 * exp(-2.2219482120838472 - 0.041101520756267988 * var_chaste_interface__membrane__V) + 14.01055 / (0.69999999999999996 + exp(-10.909090909090908 - 0.18181818181818182 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double var_linear_background_current__i_B_Ca = 3.6399999999999997e-5 * var_chaste_interface__membrane__V - 0.00048619044400646078 * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i); // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = 0.018743278268729353 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = 6.9400000000000006e-5 * var_chaste_interface__membrane__V - 6.9400000000000006e-5 * var_reversal_potentials__E_K; // nanoA
        const double var_reversal_potentials__E_Na = 26.713760659695652 * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i); // millivolt
        const double var_linear_background_current__i_B_Na = 0.00016000000000000001 * var_chaste_interface__membrane__V - 0.00016000000000000001 * var_reversal_potentials__E_Na; // nanoA
        const double var_sodium_calcium_pump__i_NaCa = 1.2480000000000001e-5 * (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.018714999999999999 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(-0.018714999999999999 * var_chaste_interface__membrane__V)) / (1.0 + 0.0001 * pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + 0.0001 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c); // nanoA
        const double d_dt_chaste_interface_var_cleft_space_equations__Ca_c = 0.19999999999999998 + 0.010896176395982464 * var_L_type_Ca_channel__i_Ca_L + 0.010896176395982464 * var_T_type_Ca_channel__i_Ca_T + 0.010896176395982464 * var_calcium_pump_current__i_Ca_P + 0.010896176395982464 * var_linear_background_current__i_B_Ca - 0.021792352791964929 * var_sodium_calcium_pump__i_NaCa - 0.099999999999999992 * var_chaste_interface__cleft_space_equations__Ca_c; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_i = 0.0031868386878572369 * var_SR_Ca_uptake_and_release__i_rel + 0.0063736773757144738 * var_sodium_calcium_pump__i_NaCa - 3.1000000000000001e-5 * var_intracellular_concentrations_and_buffer_equations__phi_TC - 6.2000000000000003e-5 * var_intracellular_concentrations_and_buffer_equations__phi_TMgC - 8.9999999999999992e-5 * var_intracellular_concentrations_and_buffer_equations__phi_C - 0.0031868386878572369 * var_L_type_Ca_channel__i_Ca_L - 0.0031868386878572369 * var_SR_Ca_uptake_and_release__i_up - 0.0031868386878572369 * var_T_type_Ca_channel__i_Ca_T - 0.0031868386878572369 * var_calcium_pump_current__i_Ca_P - 0.0031868386878572369 * var_linear_background_current__i_B_Ca; // millimolar / millisecond
        const double var_sodium_current_h_gate__alpha_h1 = 165.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V); // per_second
        const double var_sodium_current_h_gate__beta_h1 = 12360.0 / (1.0 + 320.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V)); // per_second
        const double var_sodium_current_h_gate__h1_infinity = var_sodium_current_h_gate__alpha_h1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1); // dimensionless
        const double var_sodium_current_h_gate__tau_h1 = 1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1); // second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h1 = 0.001 * (-var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__h1_infinity) / var_sodium_current_h_gate__tau_h1; // 1 / millisecond
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h2 = 5.0000000000000002e-5 * (-var_chaste_interface__sodium_current_h_gate__h2 + var_sodium_current_h_gate__h1_infinity) / var_sodium_current_h_gate__tau_h1; // 1 / millisecond
        const double var_sodium_current_m_gate__alpha_m = -824.0 * (51.899999999999999 + var_chaste_interface__membrane__V) / (-1.0 + exp(-5.8314606741573032 - 0.11235955056179775 * var_chaste_interface__membrane__V)); // per_second
        const double var_sodium_current_m_gate__beta_m = 32960.0 * exp(-5.8314606741573032 - 0.11235955056179775 * var_chaste_interface__membrane__V); // per_second
        const double var_sodium_current__i_Na = 12.424666784589714 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V - 0.037433890822745473 * var_reversal_potentials__E_Na)) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * (-var_chaste_interface__sodium_current_m_gate__m + var_sodium_current_m_gate__alpha_m / (var_sodium_current_m_gate__alpha_m + var_sodium_current_m_gate__beta_m)) / (1.5e-5 + 1 / (var_sodium_current_m_gate__alpha_m + var_sodium_current_m_gate__beta_m)); // 1 / millisecond
        const double var_sodium_potassium_pump__i_NaK = 0.0021546791260593943 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) / (pow((1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i), 3) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((0.621 + var_chaste_interface__cleft_space_equations__K_c), 2)); // nanoA
        const double d_dt_chaste_interface_var_cleft_space_equations__K_c = 0.54000000000000004 + 0.021792352791964929 * var_delayed_rectifying_potassium_current__i_K + 0.021792352791964929 * var_hyperpolarisation_activated_current__i_f_K + 0.021792352791964929 * var_linear_background_current__i_B_K - 0.043584705583929857 * var_sodium_potassium_pump__i_NaK - 0.099999999999999992 * var_chaste_interface__cleft_space_equations__K_c; // millimolar / millisecond
        const double d_dt_chaste_interface_var_cleft_space_equations__Na_c = 14.0 + 0.021792352791964929 * var_hyperpolarisation_activated_current__i_f_Na + 0.021792352791964929 * var_linear_background_current__i_B_Na + 0.021792352791964929 * var_sodium_current__i_Na + 0.065377058375894789 * var_sodium_calcium_pump__i_NaCa + 0.065377058375894789 * var_sodium_potassium_pump__i_NaK - 0.099999999999999992 * var_chaste_interface__cleft_space_equations__Na_c; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__K_i = 0.012747354751428948 * var_sodium_potassium_pump__i_NaK - 0.0063736773757144738 * var_delayed_rectifying_potassium_current__i_K - 0.0063736773757144738 * var_hyperpolarisation_activated_current__i_f_K - 0.0063736773757144738 * var_linear_background_current__i_B_K; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Na_i = -0.019121032127143424 * var_sodium_calcium_pump__i_NaCa - 0.019121032127143424 * var_sodium_potassium_pump__i_NaK - 0.0063736773757144738 * var_hyperpolarisation_activated_current__i_f_Na - 0.0063736773757144738 * var_linear_background_current__i_B_Na - 0.0063736773757144738 * var_sodium_current__i_Na; // millimolar / millisecond
        
        mEvalF[1] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_i;
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[2] = d_dt_chaste_interface_var_sodium_current_m_gate__m;
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[3] = d_dt_chaste_interface_var_sodium_current_h_gate__h1;
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[4] = d_dt_chaste_interface_var_sodium_current_h_gate__h2;
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[5] = d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L;
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[6] = d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L;
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[7] = d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T;
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[8] = d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T;
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[9] = d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_a_gate__P_a;
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[10] = d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_i_gate__P_i;
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[11] = d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[12] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Na_i;
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[13] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__K_i;
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[14] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Calmod;
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[15] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Trop;
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[16] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop;
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[17] = d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop;
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[18] = d_dt_chaste_interface_var_cleft_space_equations__Na_c;
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[19] = d_dt_chaste_interface_var_cleft_space_equations__Ca_c;
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[20] = d_dt_chaste_interface_var_cleft_space_equations__K_c;
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[21] = d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_up;
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[22] = d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_rel;
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[23] = d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_Calse;
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[24] = d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F1;
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[25] = d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F2;
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[26] = d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F3;
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time_converted, rY, delta);
        
        {
            if (fabs(mPartialF[1]) < delta){
                rY[1] += mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_i;
            }
            else
            {
                rY[1] += (d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_i/mPartialF[1])*(exp(mPartialF[1]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[2]) < delta){
                rY[2] += mDt*d_dt_chaste_interface_var_sodium_current_m_gate__m;
            }
            else
            {
                rY[2] += (d_dt_chaste_interface_var_sodium_current_m_gate__m/mPartialF[2])*(exp(mPartialF[2]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[3]) < delta){
                rY[3] += mDt*d_dt_chaste_interface_var_sodium_current_h_gate__h1;
            }
            else
            {
                rY[3] += (d_dt_chaste_interface_var_sodium_current_h_gate__h1/mPartialF[3])*(exp(mPartialF[3]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[4]) < delta){
                rY[4] += mDt*d_dt_chaste_interface_var_sodium_current_h_gate__h2;
            }
            else
            {
                rY[4] += (d_dt_chaste_interface_var_sodium_current_h_gate__h2/mPartialF[4])*(exp(mPartialF[4]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[5]) < delta){
                rY[5] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L;
            }
            else
            {
                rY[5] += (d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L/mPartialF[5])*(exp(mPartialF[5]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[6]) < delta){
                rY[6] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L;
            }
            else
            {
                rY[6] += (d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L/mPartialF[6])*(exp(mPartialF[6]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[7]) < delta){
                rY[7] += mDt*d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T;
            }
            else
            {
                rY[7] += (d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T/mPartialF[7])*(exp(mPartialF[7]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[8]) < delta){
                rY[8] += mDt*d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T;
            }
            else
            {
                rY[8] += (d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T/mPartialF[8])*(exp(mPartialF[8]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[9]) < delta){
                rY[9] += mDt*d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_a_gate__P_a;
            }
            else
            {
                rY[9] += (d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_a_gate__P_a/mPartialF[9])*(exp(mPartialF[9]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[10]) < delta){
                rY[10] += mDt*d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_i_gate__P_i;
            }
            else
            {
                rY[10] += (d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_i_gate__P_i/mPartialF[10])*(exp(mPartialF[10]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[11]) < delta){
                rY[11] += mDt*d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;
            }
            else
            {
                rY[11] += (d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y/mPartialF[11])*(exp(mPartialF[11]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[12]) < delta){
                rY[12] += mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Na_i;
            }
            else
            {
                rY[12] += (d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Na_i/mPartialF[12])*(exp(mPartialF[12]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[13]) < delta){
                rY[13] += mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__K_i;
            }
            else
            {
                rY[13] += (d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__K_i/mPartialF[13])*(exp(mPartialF[13]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[14]) < delta){
                rY[14] += mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Calmod;
            }
            else
            {
                rY[14] += (d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Calmod/mPartialF[14])*(exp(mPartialF[14]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[15]) < delta){
                rY[15] += mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Trop;
            }
            else
            {
                rY[15] += (d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Trop/mPartialF[15])*(exp(mPartialF[15]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[16]) < delta){
                rY[16] += mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop;
            }
            else
            {
                rY[16] += (d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop/mPartialF[16])*(exp(mPartialF[16]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[17]) < delta){
                rY[17] += mDt*d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop;
            }
            else
            {
                rY[17] += (d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop/mPartialF[17])*(exp(mPartialF[17]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[18]) < delta){
                rY[18] += mDt*d_dt_chaste_interface_var_cleft_space_equations__Na_c;
            }
            else
            {
                rY[18] += (d_dt_chaste_interface_var_cleft_space_equations__Na_c/mPartialF[18])*(exp(mPartialF[18]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[19]) < delta){
                rY[19] += mDt*d_dt_chaste_interface_var_cleft_space_equations__Ca_c;
            }
            else
            {
                rY[19] += (d_dt_chaste_interface_var_cleft_space_equations__Ca_c/mPartialF[19])*(exp(mPartialF[19]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[20]) < delta){
                rY[20] += mDt*d_dt_chaste_interface_var_cleft_space_equations__K_c;
            }
            else
            {
                rY[20] += (d_dt_chaste_interface_var_cleft_space_equations__K_c/mPartialF[20])*(exp(mPartialF[20]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[21]) < delta){
                rY[21] += mDt*d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_up;
            }
            else
            {
                rY[21] += (d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_up/mPartialF[21])*(exp(mPartialF[21]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[22]) < delta){
                rY[22] += mDt*d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_rel;
            }
            else
            {
                rY[22] += (d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_rel/mPartialF[22])*(exp(mPartialF[22]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[23]) < delta){
                rY[23] += mDt*d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_Calse;
            }
            else
            {
                rY[23] += (d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_Calse/mPartialF[23])*(exp(mPartialF[23]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[24]) < delta){
                rY[24] += mDt*d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F1;
            }
            else
            {
                rY[24] += (d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F1/mPartialF[24])*(exp(mPartialF[24]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[25]) < delta){
                rY[25] += mDt*d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F2;
            }
            else
            {
                rY[25] += (d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F2/mPartialF[25])*(exp(mPartialF[25]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[26]) < delta){
                rY[26] += mDt*d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F3;
            }
            else
            {
                rY[26] += (d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F3/mPartialF[26])*(exp(mPartialF[26]*mDt)-1.0);
            }
            
        }        
        
    }
   
    
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        
        // Mathematics
        const double var_calcium_pump_current__i_Ca_P = 0.02869 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = 0.021149999999999999 * (-46.399999999999999 + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L); // nanoA
        const double var_T_type_Ca_channel__i_Ca_T = 0.02521 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = 0.0128821 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V); // nanoA
        const double var_hyperpolarisation_activated_current__i_f_Na = 0.0067478 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V); // nanoA
        const double var_linear_background_current__i_B_Ca = 3.6399999999999997e-5 * var_chaste_interface__membrane__V - 0.00048619044400646078 * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i); // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = 0.018743278268729353 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = 6.9400000000000006e-5 * var_chaste_interface__membrane__V - 6.9400000000000006e-5 * var_reversal_potentials__E_K; // nanoA
        const double var_reversal_potentials__E_Na = 26.713760659695652 * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i); // millivolt
        const double var_linear_background_current__i_B_Na = 0.00016000000000000001 * var_chaste_interface__membrane__V - 0.00016000000000000001 * var_reversal_potentials__E_Na; // nanoA
        const double var_sodium_calcium_pump__i_NaCa = 1.2480000000000001e-5 * (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.018714999999999999 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(-0.018714999999999999 * var_chaste_interface__membrane__V)) / (1.0 + 0.0001 * pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + 0.0001 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c); // nanoA
        const double var_sodium_current__i_Na = 12.424666784589714 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V - 0.037433890822745473 * var_reversal_potentials__E_Na)) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_sodium_potassium_pump__i_NaK = 0.0021546791260593943 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) / (pow((1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i), 3) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((0.621 + var_chaste_interface__cleft_space_equations__K_c), 2)); // nanoA
        d_dt_chaste_interface_var_membrane__V = 0.001 * (-var_L_type_Ca_channel__i_Ca_L - var_T_type_Ca_channel__i_Ca_T - var_calcium_pump_current__i_Ca_P - var_delayed_rectifying_potassium_current__i_K - var_hyperpolarisation_activated_current__i_f_K - var_hyperpolarisation_activated_current__i_f_Na - var_linear_background_current__i_B_Ca - var_linear_background_current__i_B_K - var_linear_background_current__i_B_Na - var_sodium_calcium_pump__i_NaCa - var_sodium_current__i_Na - var_sodium_potassium_pump__i_NaK) / mParameters[0]; // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane__V;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            double var_chaste_interface__sodium_current_m_gate__m = rY[2];
            // Units: dimensionless; Initial value: 0.250113
            double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
            // Units: dimensionless; Initial value: 0.001386897
            double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
            // Units: dimensionless; Initial value: 0.002065463
            double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
            // Units: dimensionless; Initial value: 0.002572773
            double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
            // Units: dimensionless; Initial value: 0.98651
            double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
            // Units: dimensionless; Initial value: 0.02012114
            double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
            // Units: dimensionless; Initial value: 0.1945111
            double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
            // Units: dimensionless; Initial value: 0.02302278
            double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
            // Units: dimensionless; Initial value: 0.3777728
            double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
            // Units: dimensionless; Initial value: 0.09227776
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
            // Units: millimolar; Initial value: 9.701621
            double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
            // Units: millimolar; Initial value: 139.9988
            double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
            // Units: millimolar; Initial value: 2.00474
            double var_chaste_interface__cleft_space_equations__K_c = rY[20];
            // Units: millimolar; Initial value: 5.389014
            
            const double var_x0 = pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2);
            const double var_x1 = -0.16666666666666666 * var_chaste_interface__membrane__V;
            const double var_x2 = exp(-2.3500000000000001 + var_x1);
            const double var_x3 = 1.0 + var_x2;
            const double var_x4 = 1 / var_x3;
            const double var_x5 = var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L;
            const double var_x6 = var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T;
            const double var_x7 = pow(var_chaste_interface__cleft_space_equations__Na_c, 3);
            const double var_x8 = var_x7 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x9 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
            const double var_x10 = var_x9 * var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x11 = 1.0 + 0.0001 * var_x10 + 0.0001 * var_x8;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = 0.018714999999999999 * var_chaste_interface__membrane__V;
            const double var_x14 = exp(-var_x13);
            const double var_x15 = var_x14 * var_x8;
            const double var_x16 = exp(var_x13);
            const double var_x17 = var_x10 * var_x16;
            const double var_x18 = var_x12 * (0.018714999999999999 * var_x15 + 0.018714999999999999 * var_x17);
            const double var_x19 = var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i;
            const double var_x20 = 0.9813599999999999 - 0.021149999999999999 * var_chaste_interface__membrane__V;
            const double var_x21 = var_x2 / pow(var_x3, 2);
            const double var_x22 = 0.015833333333333335 * var_x21;
            const double var_x23 = 0.037433890822745473 * var_chaste_interface__membrane__V;
            const double var_x24 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
            const double var_x25 = var_x24 * var_chaste_interface__cleft_space_equations__Na_c;
            const double var_x26 = exp(var_x23 - 1.0 * log(var_x25));
            const double var_x27 = -1.0 + var_x26;
            const double var_x28 = var_x27 * var_chaste_interface__cleft_space_equations__Na_c;
            const double var_x29 = exp(var_x23);
            const double var_x30 = -1.0 + var_x29;
            const double var_x31 = 1 / var_x30;
            const double var_x32 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
            const double var_x33 = var_x31 * var_x32 * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2;
            const double var_x34 = 12.424666784589714 * var_x33;
            const double var_x35 = exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V);
            const double var_x36 = 0.621 + var_chaste_interface__cleft_space_equations__K_c;
            const double var_x37 = pow(var_x36, (-2));
            const double var_x38 = pow(var_chaste_interface__cleft_space_equations__K_c, 2);
            const double var_x39 = 1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
            const double var_x40 = pow(var_x39, (-3));
            const double var_x41 = var_x35 * var_x37 * var_x38 * var_x40 * var_x9 / pow((1 + 0.66666666666666663 * var_x35), 2);
            const double var_x42 = var_x33 * var_chaste_interface__membrane__V;
            const double var_x43 = var_x26 * var_x42;
            const double var_x44 = var_x43 * var_chaste_interface__cleft_space_equations__Na_c;
            const double var_x45 = var_x28 * var_chaste_interface__sodium_current_h_gate__h2;
            const double var_x46 = var_x45 * var_chaste_interface__membrane__V * var_chaste_interface__sodium_current_h_gate__h1;
            const double var_x47 = var_x29 * var_x32 * var_x46 / pow(var_x30, 2);
            const double var_x48 = 1 / mParameters[0];
            const double var_x49 = 0.001 * var_x48;
            
            partialF = var_x49 * (-0.00026580000000000001 + 0.46510361992332344 * var_x47 - 0.021149999999999999 * var_x5 - 0.02521 * var_x6 - 1.2480000000000001e-5 * var_x18 - 0.019629899999999999 * var_x0 - 0.018743278268729353 * var_x19 - 0.46510361992332344 * var_x44 - 0.0020092499999999998 * var_x4 - 2.3940879178437715e-5 * var_x41 + var_x20 * var_x22 - var_x28 * var_x34);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod = rY[14];
        // Units: dimensionless; Initial value: 0.1411678
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop = rY[15];
        // Units: dimensionless; Initial value: 0.07331396
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = rY[16];
        // Units: dimensionless; Initial value: 0.7618549
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = rY[17];
        // Units: dimensionless; Initial value: 0.2097049
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rY[21];
        // Units: millimolar; Initial value: 16.95311
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rY[22];
        // Units: millimolar; Initial value: 16.85024
        double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rY[25];
        // Units: dimensionless; Initial value: 0.0007594214
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__i_rel = 0.5 * pow(var_chaste_interface__SR_Ca_uptake_and_release__F2, 2) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel / pow((0.25 + var_chaste_interface__SR_Ca_uptake_and_release__F2), 2); // nanoA
        const double var_SR_Ca_uptake_and_release__i_up = (0.080000000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i - 1.4727272727272728e-7 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up) / (9.5000000000000005e-5 + 2.0454545454545457e-6 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_calcium_pump_current__i_Ca_P = 0.02869 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_intracellular_concentrations_and_buffer_equations__phi_C = -307.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_TC = -252.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop + 50500.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_intracellular_concentrations_and_buffer_equations__phi_TMgC = -4.25 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = 0.021149999999999999 * (-46.399999999999999 + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L); // nanoA
        const double var_T_type_Ca_channel__i_Ca_T = 0.02521 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_linear_background_current__i_B_Ca = 3.6399999999999997e-5 * var_chaste_interface__membrane__V - 0.00048619044400646078 * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_sodium_calcium_pump__i_NaCa = 1.2480000000000001e-5 * (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.018714999999999999 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(-0.018714999999999999 * var_chaste_interface__membrane__V)) / (1.0 + 0.0001 * pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + 0.0001 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c); // nanoA
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_i = 0.0031868386878572369 * var_SR_Ca_uptake_and_release__i_rel + 0.0063736773757144738 * var_sodium_calcium_pump__i_NaCa - 3.1000000000000001e-5 * var_intracellular_concentrations_and_buffer_equations__phi_TC - 6.2000000000000003e-5 * var_intracellular_concentrations_and_buffer_equations__phi_TMgC - 8.9999999999999992e-5 * var_intracellular_concentrations_and_buffer_equations__phi_C - 0.0031868386878572369 * var_L_type_Ca_channel__i_Ca_L - 0.0031868386878572369 * var_SR_Ca_uptake_and_release__i_up - 0.0031868386878572369 * var_T_type_Ca_channel__i_Ca_T - 0.0031868386878572369 * var_calcium_pump_current__i_Ca_P - 0.0031868386878572369 * var_linear_background_current__i_B_Ca; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_i;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
            // Units: millimolar; Initial value: 9.701621
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod = rY[14];
            // Units: dimensionless; Initial value: 0.1411678
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop = rY[15];
            // Units: dimensionless; Initial value: 0.07331396
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = rY[16];
            // Units: dimensionless; Initial value: 0.7618549
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = rY[17];
            // Units: dimensionless; Initial value: 0.2097049
            double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
            // Units: millimolar; Initial value: 139.9988
            double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
            // Units: millimolar; Initial value: 2.00474
            double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rY[21];
            // Units: millimolar; Initial value: 16.95311
            
            const double var_x7 = pow(var_chaste_interface__cleft_space_equations__Na_c, 3);
            const double var_x8 = var_x7 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x9 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
            const double var_x10 = var_x9 * var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x11 = 1.0 + 0.0001 * var_x10 + 0.0001 * var_x8;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = 0.018714999999999999 * var_chaste_interface__membrane__V;
            const double var_x14 = exp(-var_x13);
            const double var_x15 = var_x14 * var_x8;
            const double var_x16 = exp(var_x13);
            const double var_x17 = var_x10 * var_x16;
            const double var_x50 = 0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x51 = 1 / var_x50;
            const double var_x52 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x53 = var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / pow(var_x50, 2);
            const double var_x55 = var_x14 * var_x7;
            const double var_x56 = (var_x17 - var_x15) / pow(var_x11, 2);
            const double var_x96 = 9.5000000000000005e-5 + 2.0454545454545457e-6 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x97 = 1 / var_x96;
            const double var_x98 = (0.080000000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i - 1.4727272727272728e-7 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up) / pow(var_x96, 2);
            const double var_x99 = 7.9543493648916639e-12 * var_x56;
            const double var_x100 = 7.9543493648916641e-8 * var_x12;
            
            partialF = -21.173500000000001 + 11.609999999999999 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod + 9.1430401954624137e-5 * var_x53 + 1.5654999999999999 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop + 0.0031868386878572369 * var_x98 + 7.9980000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop + 7.9980000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop - 0.00025494709502857897 * var_x97 - 9.1430401954624137e-5 * var_x51 - 1.5494105166262771e-6 * var_x52 - var_x100 * var_x55 - var_x7 * var_x99;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        
        
        // Mathematics
        const double var_sodium_current_m_gate__alpha_m = -824.0 * (51.899999999999999 + var_chaste_interface__membrane__V) / (-1.0 + exp(-5.8314606741573032 - 0.11235955056179775 * var_chaste_interface__membrane__V)); // per_second
        const double var_sodium_current_m_gate__beta_m = 32960.0 * exp(-5.8314606741573032 - 0.11235955056179775 * var_chaste_interface__membrane__V); // per_second
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * (-var_chaste_interface__sodium_current_m_gate__m + var_sodium_current_m_gate__alpha_m / (var_sodium_current_m_gate__alpha_m + var_sodium_current_m_gate__beta_m)) / (1.5e-5 + 1 / (var_sodium_current_m_gate__alpha_m + var_sodium_current_m_gate__beta_m)); // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_m_gate__m;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x112 = exp(-5.8314606741573032 - 0.11235955056179775 * var_chaste_interface__membrane__V);
            const double var_x113 = 51.899999999999999 + var_chaste_interface__membrane__V;
            const double var_x114 = -1.0 + var_x112;
            const double var_x115 = 1 / var_x114;
            const double var_x116 = 824.0 * var_x115;
            const double var_x117 = var_x113 * var_x116;
            const double var_x118 = 1 / (-var_x117 + 32960.0 * var_x112);
            const double var_x122 = 1.5e-5 + var_x118;
            const double var_x123 = 0.001 / var_x122;
            
            partialF = -var_x123;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        
        
        // Mathematics
        const double var_sodium_current_h_gate__alpha_h1 = 165.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V); // per_second
        const double var_sodium_current_h_gate__beta_h1 = 12360.0 / (1.0 + 320.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V)); // per_second
        const double var_sodium_current_h_gate__h1_infinity = var_sodium_current_h_gate__alpha_h1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1); // dimensionless
        const double var_sodium_current_h_gate__tau_h1 = 1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1); // second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h1 = 0.001 * (-var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__h1_infinity) / var_sodium_current_h_gate__tau_h1; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_h_gate__h1;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x124 = exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V);
            const double var_x125 = 1 / (1.0 + 320.0 * var_x124);
            const double var_x132 = 0.16500000000000001 * var_x124;
            
            partialF = -var_x132 - 12.359999999999999 * var_x125;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        
        
        // Mathematics
        const double var_sodium_current_h_gate__alpha_h1 = 165.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V); // per_second
        const double var_sodium_current_h_gate__beta_h1 = 12360.0 / (1.0 + 320.0 * exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V)); // per_second
        const double var_sodium_current_h_gate__h1_infinity = var_sodium_current_h_gate__alpha_h1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1); // dimensionless
        const double var_sodium_current_h_gate__tau_h1 = 1 / (var_sodium_current_h_gate__alpha_h1 + var_sodium_current_h_gate__beta_h1); // second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h2 = 5.0000000000000002e-5 * (-var_chaste_interface__sodium_current_h_gate__h2 + var_sodium_current_h_gate__h1_infinity) / var_sodium_current_h_gate__tau_h1; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_h_gate__h2;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x124 = exp(-8.0396825396825395 - 0.079365079365079361 * var_chaste_interface__membrane__V);
            const double var_x125 = 1 / (1.0 + 320.0 * var_x124);
            const double var_x134 = 0.0082500000000000004 * var_x124;
            
            partialF = -var_x134 - 0.61799999999999999 * var_x125;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        
        
        // Mathematics
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L = 0.001 * (-var_chaste_interface__L_type_Ca_channel_d_gate__d_L + var_L_type_Ca_channel_d_gate__d_L_infinity) * (11.43 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)) - 28.390000000000001 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V)) - 84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x135 = exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V);
            const double var_x136 = -1.0 + var_x135;
            const double var_x137 = 1 / var_x136;
            const double var_x139 = exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V);
            const double var_x140 = -1.0 + var_x139;
            const double var_x141 = 1 / var_x140;
            const double var_x143 = exp(-0.20799999999999999 * var_chaste_interface__membrane__V);
            const double var_x144 = -1.0 + var_x143;
            const double var_x145 = 1 / var_x144;
            const double var_x147 = 35.0 + var_chaste_interface__membrane__V;
            const double var_x148 = -5.0 + var_chaste_interface__membrane__V;
            
            partialF = 0.028390000000000002 * var_x141 * var_x147 + 0.084900000000000003 * var_x145 * var_chaste_interface__membrane__V - 0.011429999999999999 * var_x137 * var_x148;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L = 0.001 * (-var_chaste_interface__L_type_Ca_channel_f_gate__f_L + 1 / (1.0 + exp(6.0 + 0.20000000000000001 * var_chaste_interface__membrane__V))) * (30.0 / (1.0 + exp(-7.0 - 0.25 * var_chaste_interface__membrane__V)) + 3.75 * (28.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(7.0 + 0.25 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x151 = 0.25 * var_chaste_interface__membrane__V;
            const double var_x152 = exp(7.0 + var_x151);
            const double var_x153 = -1.0 + var_x152;
            const double var_x154 = 1 / var_x153;
            const double var_x156 = exp(-7.0 - var_x151);
            const double var_x157 = 1.0 + var_x156;
            const double var_x158 = 28.0 + var_chaste_interface__membrane__V;
            const double var_x159 = 1 / var_x157;
            
            partialF = -0.029999999999999999 * var_x159 - 0.0037499999999999999 * var_x154 * var_x158;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T = 0.001 * (-var_chaste_interface__T_type_Ca_channel_d_gate__d_T + 1 / (1.0 + exp(-4.3833333333333337 - 0.16666666666666666 * var_chaste_interface__membrane__V))) * (1068.0 * exp(0.87666666666666671 + 0.033333333333333333 * var_chaste_interface__membrane__V) + 1068.0 * exp(-0.87666666666666671 - 0.033333333333333333 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x162 = 0.033333333333333333 * var_chaste_interface__membrane__V;
            const double var_x163 = exp(0.87666666666666671 + var_x162);
            const double var_x164 = exp(-0.87666666666666671 - var_x162);
            
            partialF = -1.0680000000000001 * var_x163 - 1.0680000000000001 * var_x164;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T = 0.001 * (-var_chaste_interface__T_type_Ca_channel_f_gate__f_T + 1 / (1.0 + exp(11.017857142857144 + 0.17857142857142858 * var_chaste_interface__membrane__V))) * (15.0 * exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V) + 15.300000000000001 * exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x167 = exp(4.0117035110533159 + 0.065019505851755519 * var_chaste_interface__membrane__V);
            const double var_x168 = exp(-0.74069627851140463 - 0.012004801920768308 * var_chaste_interface__membrane__V);
            
            partialF = -0.015300000000000001 * var_x168 - 0.014999999999999999 * var_x167;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_a_gate__P_a = 0.001 * (-var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a + 1 / (1.0 + exp(-0.68918918918918914 - 0.13513513513513511 * var_chaste_interface__membrane__V))) * (17.0 * exp(0.039800000000000002 * var_chaste_interface__membrane__V) + 2.1099999999999999 * exp(-0.050999999999999997 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_a_gate__P_a;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x169 = exp(0.039800000000000002 * var_chaste_interface__membrane__V);
            const double var_x170 = exp(-0.050999999999999997 * var_chaste_interface__membrane__V);
            
            partialF = -0.0021099999999999999 * var_x170 - 0.017000000000000001 * var_x169;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_i_gate__P_i = 0.10000000000000001 * (1.0 - var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i) * exp(-0.0183 * var_chaste_interface__membrane__V) - 0.65600000000000003 * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i * exp(0.0094199999999999996 * var_chaste_interface__membrane__V); // 1 / millisecond

        return d_dt_chaste_interface_var_delayed_rectifying_potassium_current_P_i_gate__P_i;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x173 = exp(-0.0183 * var_chaste_interface__membrane__V);
            const double var_x174 = exp(0.0094199999999999996 * var_chaste_interface__membrane__V);
            
            partialF = -0.65600000000000003 * var_x174 - 0.10000000000000001 * var_x173;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y = 0.001 * (-var_chaste_interface__hyperpolarisation_activated_current_y_gate__y + 1 / (1.0 + exp(8.0222222222222221 + 0.1111111111111111 * var_chaste_interface__membrane__V))) * (1.6483000000000001 * exp(-2.2219482120838472 - 0.041101520756267988 * var_chaste_interface__membrane__V) + 14.01055 / (0.69999999999999996 + exp(-10.909090909090908 - 0.18181818181818182 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            
            const double var_x177 = exp(-2.2219482120838472 - 0.041101520756267988 * var_chaste_interface__membrane__V);
            const double var_x178 = exp(-10.909090909090908 - 0.18181818181818182 * var_chaste_interface__membrane__V);
            const double var_x179 = 0.69999999999999996 + var_x178;
            const double var_x180 = 1 / var_x179;
            
            partialF = -0.0016483000000000001 * var_x177 - 0.01401055 * var_x180;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        
        // Mathematics
        const double var_hyperpolarisation_activated_current__i_f_Na = 0.0067478 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V); // nanoA
        const double var_reversal_potentials__E_Na = 26.713760659695652 * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i); // millivolt
        const double var_linear_background_current__i_B_Na = 0.00016000000000000001 * var_chaste_interface__membrane__V - 0.00016000000000000001 * var_reversal_potentials__E_Na; // nanoA
        const double var_sodium_calcium_pump__i_NaCa = 1.2480000000000001e-5 * (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.018714999999999999 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(-0.018714999999999999 * var_chaste_interface__membrane__V)) / (1.0 + 0.0001 * pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + 0.0001 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c); // nanoA
        const double var_sodium_current__i_Na = 12.424666784589714 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V - 0.037433890822745473 * var_reversal_potentials__E_Na)) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_sodium_potassium_pump__i_NaK = 0.0021546791260593943 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) / (pow((1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i), 3) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((0.621 + var_chaste_interface__cleft_space_equations__K_c), 2)); // nanoA
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Na_i = -0.019121032127143424 * var_sodium_calcium_pump__i_NaCa - 0.019121032127143424 * var_sodium_potassium_pump__i_NaK - 0.0063736773757144738 * var_hyperpolarisation_activated_current__i_f_Na - 0.0063736773757144738 * var_linear_background_current__i_B_Na - 0.0063736773757144738 * var_sodium_current__i_Na; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Na_i;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            double var_chaste_interface__sodium_current_m_gate__m = rY[2];
            // Units: dimensionless; Initial value: 0.250113
            double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
            // Units: dimensionless; Initial value: 0.001386897
            double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
            // Units: dimensionless; Initial value: 0.002065463
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
            // Units: millimolar; Initial value: 9.701621
            double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
            // Units: millimolar; Initial value: 139.9988
            double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
            // Units: millimolar; Initial value: 2.00474
            double var_chaste_interface__cleft_space_equations__K_c = rY[20];
            // Units: millimolar; Initial value: 5.389014
            
            const double var_x7 = pow(var_chaste_interface__cleft_space_equations__Na_c, 3);
            const double var_x8 = var_x7 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x9 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
            const double var_x10 = var_x9 * var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x11 = 1.0 + 0.0001 * var_x10 + 0.0001 * var_x8;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = 0.018714999999999999 * var_chaste_interface__membrane__V;
            const double var_x14 = exp(-var_x13);
            const double var_x15 = var_x14 * var_x8;
            const double var_x16 = exp(var_x13);
            const double var_x17 = var_x10 * var_x16;
            const double var_x23 = 0.037433890822745473 * var_chaste_interface__membrane__V;
            const double var_x24 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
            const double var_x25 = var_x24 * var_chaste_interface__cleft_space_equations__Na_c;
            const double var_x26 = exp(var_x23 - 1.0 * log(var_x25));
            const double var_x29 = exp(var_x23);
            const double var_x30 = -1.0 + var_x29;
            const double var_x31 = 1 / var_x30;
            const double var_x32 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
            const double var_x33 = var_x31 * var_x32 * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2;
            const double var_x35 = exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V);
            const double var_x36 = 0.621 + var_chaste_interface__cleft_space_equations__K_c;
            const double var_x37 = pow(var_x36, (-2));
            const double var_x38 = pow(var_chaste_interface__cleft_space_equations__K_c, 2);
            const double var_x39 = 1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
            const double var_x40 = pow(var_x39, (-3));
            const double var_x42 = var_x33 * var_chaste_interface__membrane__V;
            const double var_x43 = var_x26 * var_x42;
            const double var_x56 = (var_x17 - var_x15) / pow(var_x11, 2);
            const double var_x74 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 2);
            const double var_x75 = var_x74 * var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x78 = var_x16 * var_x75;
            const double var_x79 = 1 / (1.5 + var_x35);
            const double var_x80 = var_x37 * var_x38 * var_x79;
            const double var_x81 = var_x80 * var_x9 / pow(var_x39, 4);
            const double var_x82 = var_x40 * var_x74 * var_x80;
            const double var_x186 = 7.158914428402498e-11 * var_x56;
            const double var_x187 = 7.1589144284024978e-7 * var_x12;
            const double var_x188 = 0.079190817585730572 * var_x43;
            
            partialF = 2.2637191644542304e-5 * var_x81 - 2.7242382709912566e-5 * var_x24 - 0.00012359906637920097 * var_x82 + var_x186 * var_x75 - var_x187 * var_x78 - var_x188 * var_x25;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        
        // Mathematics
        const double var_hyperpolarisation_activated_current__i_f_K = 0.0128821 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V); // nanoA
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i); // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = 0.018743278268729353 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = 6.9400000000000006e-5 * var_chaste_interface__membrane__V - 6.9400000000000006e-5 * var_reversal_potentials__E_K; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 0.0021546791260593943 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) / (pow((1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i), 3) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((0.621 + var_chaste_interface__cleft_space_equations__K_c), 2)); // nanoA
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__K_i = 0.012747354751428948 * var_sodium_potassium_pump__i_NaK - 0.0063736773757144738 * var_delayed_rectifying_potassium_current__i_K - 0.0063736773757144738 * var_hyperpolarisation_activated_current__i_f_K - 0.0063736773757144738 * var_linear_background_current__i_B_K; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__K_i;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
            // Units: dimensionless; Initial value: 0.02302278
            double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
            // Units: dimensionless; Initial value: 0.3777728
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
            // Units: millimolar; Initial value: 140.7347
            
            const double var_x19 = var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i;
            const double var_x68 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i;
            const double var_x192 = 0.0031913222489694526 * var_x19;
            
            partialF = -1.1816383500424576e-5 * var_x68 - var_x192 * var_x68;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod = rY[14];
        // Units: dimensionless; Initial value: 0.1411678
        
        
        // Mathematics
        const double var_intracellular_concentrations_and_buffer_equations__phi_C = -307.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Calmod) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Calmod = 0.001 * var_intracellular_concentrations_and_buffer_equations__phi_C; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Calmod;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            
            const double var_x194 = -129.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            
            partialF = -0.307 + var_x194;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative15(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop = rY[15];
        // Units: dimensionless; Initial value: 0.07331396
        
        
        // Mathematics
        const double var_intracellular_concentrations_and_buffer_equations__phi_TC = -252.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop + 50500.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__phi_TC; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Trop;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative15(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            
            
            partialF = -0.252 - 50.5 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative16(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = rY[16];
        // Units: dimensionless; Initial value: 0.7618549
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = rY[17];
        // Units: dimensionless; Initial value: 0.2097049
        
        
        // Mathematics
        const double var_intracellular_concentrations_and_buffer_equations__phi_TMgC = -4.25 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop + 129000.0 * (1.0 - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i; // per_second
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = 0.001 * var_intracellular_concentrations_and_buffer_equations__phi_TMgC; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative16(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            
            const double var_x194 = -129.0 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            
            partialF = -0.0042500000000000003 + var_x194;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative17(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop = rY[16];
        // Units: dimensionless; Initial value: 0.7618549
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = rY[17];
        // Units: dimensionless; Initial value: 0.2097049
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop = 3.2250000000000001 - 3.2250000000000001 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop - 3.6539999999999999 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative17(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -3.6539999999999999;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative18(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.250113
        double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.001386897
        double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.002065463
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        
        // Mathematics
        const double var_hyperpolarisation_activated_current__i_f_Na = 0.0067478 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (-75.0 + var_chaste_interface__membrane__V); // nanoA
        const double var_reversal_potentials__E_Na = 26.713760659695652 * log(var_chaste_interface__cleft_space_equations__Na_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i); // millivolt
        const double var_linear_background_current__i_B_Na = 0.00016000000000000001 * var_chaste_interface__membrane__V - 0.00016000000000000001 * var_reversal_potentials__E_Na; // nanoA
        const double var_sodium_calcium_pump__i_NaCa = 1.2480000000000001e-5 * (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.018714999999999999 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(-0.018714999999999999 * var_chaste_interface__membrane__V)) / (1.0 + 0.0001 * pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + 0.0001 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c); // nanoA
        const double var_sodium_current__i_Na = 12.424666784589714 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V - 0.037433890822745473 * var_reversal_potentials__E_Na)) * var_chaste_interface__cleft_space_equations__Na_c * var_chaste_interface__membrane__V * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2 / (-1.0 + exp(0.037433890822745473 * var_chaste_interface__membrane__V)); // nanoA
        const double var_sodium_potassium_pump__i_NaK = 0.0021546791260593943 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) / (pow((1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i), 3) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((0.621 + var_chaste_interface__cleft_space_equations__K_c), 2)); // nanoA
        const double d_dt_chaste_interface_var_cleft_space_equations__Na_c = 14.0 + 0.021792352791964929 * var_hyperpolarisation_activated_current__i_f_Na + 0.021792352791964929 * var_linear_background_current__i_B_Na + 0.021792352791964929 * var_sodium_current__i_Na + 0.065377058375894789 * var_sodium_calcium_pump__i_NaCa + 0.065377058375894789 * var_sodium_potassium_pump__i_NaK - 0.099999999999999992 * var_chaste_interface__cleft_space_equations__Na_c; // millimolar / millisecond

        return d_dt_chaste_interface_var_cleft_space_equations__Na_c;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative18(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            double var_chaste_interface__sodium_current_m_gate__m = rY[2];
            // Units: dimensionless; Initial value: 0.250113
            double var_chaste_interface__sodium_current_h_gate__h1 = rY[3];
            // Units: dimensionless; Initial value: 0.001386897
            double var_chaste_interface__sodium_current_h_gate__h2 = rY[4];
            // Units: dimensionless; Initial value: 0.002065463
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
            // Units: millimolar; Initial value: 9.701621
            double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
            // Units: millimolar; Initial value: 139.9988
            double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
            // Units: millimolar; Initial value: 2.00474
            
            const double var_x7 = pow(var_chaste_interface__cleft_space_equations__Na_c, 3);
            const double var_x8 = var_x7 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x9 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
            const double var_x10 = var_x9 * var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x11 = 1.0 + 0.0001 * var_x10 + 0.0001 * var_x8;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = 0.018714999999999999 * var_chaste_interface__membrane__V;
            const double var_x14 = exp(-var_x13);
            const double var_x15 = var_x14 * var_x8;
            const double var_x16 = exp(var_x13);
            const double var_x17 = var_x10 * var_x16;
            const double var_x23 = 0.037433890822745473 * var_chaste_interface__membrane__V;
            const double var_x24 = 1 / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
            const double var_x25 = var_x24 * var_chaste_interface__cleft_space_equations__Na_c;
            const double var_x26 = exp(var_x23 - 1.0 * log(var_x25));
            const double var_x27 = -1.0 + var_x26;
            const double var_x29 = exp(var_x23);
            const double var_x30 = -1.0 + var_x29;
            const double var_x31 = 1 / var_x30;
            const double var_x32 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
            const double var_x33 = var_x31 * var_x32 * var_chaste_interface__sodium_current_h_gate__h1 * var_chaste_interface__sodium_current_h_gate__h2;
            const double var_x42 = var_x33 * var_chaste_interface__membrane__V;
            const double var_x43 = var_x26 * var_x42;
            const double var_x56 = (var_x17 - var_x15) / pow(var_x11, 2);
            const double var_x85 = 1 / var_chaste_interface__cleft_space_equations__Na_c;
            const double var_x86 = pow(var_chaste_interface__cleft_space_equations__Na_c, 2) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x87 = var_x14 * var_x86;
            const double var_x189 = var_x27 * var_x42;
            const double var_x199 = 2.447717065593501e-6 * var_x12;
            const double var_x200 = 2.4477170655935014e-10 * var_x56;
            const double var_x201 = 0.27076272189238759 * var_x43;
            
            partialF = -0.099999999999999992 - var_x201 + 0.27076272189238759 * var_x189 - 9.3144911471392233e-5 * var_x85 - var_x199 * var_x87 - var_x200 * var_x86;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative19(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 0.002572773
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = rY[6];
        // Units: dimensionless; Initial value: 0.98651
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = rY[7];
        // Units: dimensionless; Initial value: 0.02012114
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = rY[8];
        // Units: dimensionless; Initial value: 0.1945111
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
        // Units: millimolar; Initial value: 139.9988
        double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
        // Units: millimolar; Initial value: 2.00474
        
        
        // Mathematics
        const double var_calcium_pump_current__i_Ca_P = 0.02869 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i / (0.00040000000000000002 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = 1 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel__i_Ca_L = 0.021149999999999999 * (-46.399999999999999 + var_chaste_interface__membrane__V) * (0.095000000000000001 * var_L_type_Ca_channel_d_gate__d_L_infinity + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L); // nanoA
        const double var_T_type_Ca_channel__i_Ca_T = 0.02521 * (-45.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_linear_background_current__i_B_Ca = 3.6399999999999997e-5 * var_chaste_interface__membrane__V - 0.00048619044400646078 * log(var_chaste_interface__cleft_space_equations__Ca_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_sodium_calcium_pump__i_NaCa = 1.2480000000000001e-5 * (pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c * exp(0.018714999999999999 * var_chaste_interface__membrane__V) - pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i * exp(-0.018714999999999999 * var_chaste_interface__membrane__V)) / (1.0 + 0.0001 * pow(var_chaste_interface__cleft_space_equations__Na_c, 3) * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i + 0.0001 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) * var_chaste_interface__cleft_space_equations__Ca_c); // nanoA
        const double d_dt_chaste_interface_var_cleft_space_equations__Ca_c = 0.19999999999999998 + 0.010896176395982464 * var_L_type_Ca_channel__i_Ca_L + 0.010896176395982464 * var_T_type_Ca_channel__i_Ca_T + 0.010896176395982464 * var_calcium_pump_current__i_Ca_P + 0.010896176395982464 * var_linear_background_current__i_B_Ca - 0.021792352791964929 * var_sodium_calcium_pump__i_NaCa - 0.099999999999999992 * var_chaste_interface__cleft_space_equations__Ca_c; // millimolar / millisecond

        return d_dt_chaste_interface_var_cleft_space_equations__Ca_c;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative19(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
            // Units: millimolar; Initial value: 9.701621
            double var_chaste_interface__cleft_space_equations__Na_c = rY[18];
            // Units: millimolar; Initial value: 139.9988
            double var_chaste_interface__cleft_space_equations__Ca_c = rY[19];
            // Units: millimolar; Initial value: 2.00474
            
            const double var_x7 = pow(var_chaste_interface__cleft_space_equations__Na_c, 3);
            const double var_x8 = var_x7 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x9 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
            const double var_x10 = var_x9 * var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x11 = 1.0 + 0.0001 * var_x10 + 0.0001 * var_x8;
            const double var_x12 = 1 / var_x11;
            const double var_x13 = 0.018714999999999999 * var_chaste_interface__membrane__V;
            const double var_x14 = exp(-var_x13);
            const double var_x15 = var_x14 * var_x8;
            const double var_x16 = exp(var_x13);
            const double var_x17 = var_x10 * var_x16;
            const double var_x56 = (var_x17 - var_x15) / pow(var_x11, 2);
            const double var_x88 = 1 / var_chaste_interface__cleft_space_equations__Ca_c;
            const double var_x89 = var_x16 * var_x9;
            const double var_x204 = 2.7196856284372237e-11 * var_x56;
            const double var_x205 = 2.7196856284372236e-7 * var_x12;
            
            partialF = -0.099999999999999992 - 5.2976168399354324e-6 * var_x88 + var_x204 * var_x9 - var_x205 * var_x89;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative20(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
        // Units: dimensionless; Initial value: 0.02302278
        double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
        // Units: dimensionless; Initial value: 0.3777728
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = rY[11];
        // Units: dimensionless; Initial value: 0.09227776
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
        // Units: millimolar; Initial value: 9.701621
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i = rY[13];
        // Units: millimolar; Initial value: 140.7347
        double var_chaste_interface__cleft_space_equations__K_c = rY[20];
        // Units: millimolar; Initial value: 5.389014
        
        
        // Mathematics
        const double var_hyperpolarisation_activated_current__i_f_K = 0.0128821 * pow(var_chaste_interface__hyperpolarisation_activated_current_y_gate__y, 2) * (85.0 + var_chaste_interface__membrane__V); // nanoA
        const double var_reversal_potentials__E_K = 26.713760659695652 * log(var_chaste_interface__cleft_space_equations__K_c / var_chaste_interface__intracellular_concentrations_and_buffer_equations__K_i); // millivolt
        const double var_delayed_rectifying_potassium_current__i_K = 0.018743278268729353 * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_linear_background_current__i_B_K = 6.9400000000000006e-5 * var_chaste_interface__membrane__V - 6.9400000000000006e-5 * var_reversal_potentials__E_K; // nanoA
        const double var_sodium_potassium_pump__i_NaK = 0.0021546791260593943 * pow(var_chaste_interface__cleft_space_equations__K_c, 2) * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3) / (pow((1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i), 3) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((0.621 + var_chaste_interface__cleft_space_equations__K_c), 2)); // nanoA
        const double d_dt_chaste_interface_var_cleft_space_equations__K_c = 0.54000000000000004 + 0.021792352791964929 * var_delayed_rectifying_potassium_current__i_K + 0.021792352791964929 * var_hyperpolarisation_activated_current__i_f_K + 0.021792352791964929 * var_linear_background_current__i_B_K - 0.043584705583929857 * var_sodium_potassium_pump__i_NaK - 0.099999999999999992 * var_chaste_interface__cleft_space_equations__K_c; // millimolar / millisecond

        return d_dt_chaste_interface_var_cleft_space_equations__K_c;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative20(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a = rY[9];
            // Units: dimensionless; Initial value: 0.02302278
            double var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i = rY[10];
            // Units: dimensionless; Initial value: 0.3777728
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i = rY[12];
            // Units: millimolar; Initial value: 9.701621
            double var_chaste_interface__cleft_space_equations__K_c = rY[20];
            // Units: millimolar; Initial value: 5.389014
            
            const double var_x9 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i, 3);
            const double var_x19 = var_chaste_interface__delayed_rectifying_potassium_current_P_a_gate__P_a * var_chaste_interface__delayed_rectifying_potassium_current_P_i_gate__P_i;
            const double var_x35 = exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V);
            const double var_x36 = 0.621 + var_chaste_interface__cleft_space_equations__K_c;
            const double var_x37 = pow(var_x36, (-2));
            const double var_x38 = pow(var_chaste_interface__cleft_space_equations__K_c, 2);
            const double var_x39 = 1 + 0.18315018315018314 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Na_i;
            const double var_x40 = pow(var_x39, (-3));
            const double var_x79 = 1 / (1.5 + var_x35);
            const double var_x90 = 1 / var_chaste_interface__cleft_space_equations__K_c;
            const double var_x91 = var_x40 * var_x79 * var_x9;
            const double var_x93 = var_x38 / pow(var_x36, 3);
            const double var_x94 = var_x37 * var_chaste_interface__cleft_space_equations__K_c;
            const double var_x210 = 0.010911506218902908 * var_x19;
            const double var_x211 = 0.00018782211067427598 * var_x91;
            
            partialF = -0.099999999999999992 - 4.040160535071638e-5 * var_x90 + var_x211 * var_x93 - var_x210 * var_x90 - var_x211 * var_x94;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative21(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rY[21];
        // Units: millimolar; Initial value: 16.95311
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rY[22];
        // Units: millimolar; Initial value: 16.85024
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__i_up = (0.080000000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i - 1.4727272727272728e-7 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up) / (9.5000000000000005e-5 + 2.0454545454545457e-6 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i); // nanoA
        const double var_SR_Ca_uptake_and_release__i_tr = 0.05700838747761728 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up - 0.05700838747761728 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel; // nanoA
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_up = 0.27331378111983162 * var_SR_Ca_uptake_and_release__i_up - 0.27331378111983162 * var_SR_Ca_uptake_and_release__i_tr; // millimolar / millisecond

        return d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_up;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative21(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rY[21];
            // Units: millimolar; Initial value: 16.95311
            
            const double var_x96 = 9.5000000000000005e-5 + 2.0454545454545457e-6 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x97 = 1 / var_x96;
            const double var_x98 = (0.080000000000000002 * var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i - 1.4727272727272728e-7 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up) / pow(var_x96, 2);
            
            partialF = -0.015581177937052042 - 4.0251665946738841e-8 * var_x97 - 5.5905091592692838e-7 * var_x98;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative22(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_up = rY[21];
        // Units: millimolar; Initial value: 16.95311
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rY[22];
        // Units: millimolar; Initial value: 16.85024
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse = rY[23];
        // Units: dimensionless; Initial value: 0.9528726
        double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rY[25];
        // Units: dimensionless; Initial value: 0.0007594214
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__i_rel = 0.5 * pow(var_chaste_interface__SR_Ca_uptake_and_release__F2, 2) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel / pow((0.25 + var_chaste_interface__SR_Ca_uptake_and_release__F2), 2); // nanoA
        const double var_SR_Ca_uptake_and_release__phi_Calse = -641.0 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse + 770.0 * (1.0 - var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel; // per_second
        const double var_SR_Ca_uptake_and_release__i_tr = 0.05700838747761728 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_up - 0.05700838747761728 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel; // nanoA
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_rel = 2.4589804690256458 * var_SR_Ca_uptake_and_release__i_tr - 0.011480000000000001 * var_SR_Ca_uptake_and_release__phi_Calse - 2.4589804690256458 * var_SR_Ca_uptake_and_release__i_rel; // millimolar / millisecond

        return d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_rel;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative22(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse = rY[23];
            // Units: dimensionless; Initial value: 0.9528726
            double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rY[25];
            // Units: dimensionless; Initial value: 0.0007594214
            
            const double var_x105 = 0.25 + var_chaste_interface__SR_Ca_uptake_and_release__F2;
            const double var_x106 = pow(var_x105, (-2));
            const double var_x107 = pow(var_chaste_interface__SR_Ca_uptake_and_release__F2, 2);
            const double var_x108 = var_x106 * var_x107;
            
            partialF = -8.979782511378108 + 8.8396000000000008 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse - 1.2294902345128229 * var_x108;
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative23(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rY[22];
        // Units: millimolar; Initial value: 16.85024
        double var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse = rY[23];
        // Units: dimensionless; Initial value: 0.9528726
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__phi_Calse = -641.0 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse + 770.0 * (1.0 - var_chaste_interface__SR_Ca_uptake_and_release__Ca_Calse) * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel; // per_second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_Calse = 0.001 * var_SR_Ca_uptake_and_release__phi_Calse; // 1 / millisecond

        return d_dt_chaste_interface_var_SR_Ca_uptake_and_release__Ca_Calse;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative23(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel = rY[22];
            // Units: millimolar; Initial value: 16.85024
            
            
            partialF = -0.64100000000000001 - 0.77000000000000002 * var_chaste_interface__SR_Ca_uptake_and_release__Ca_rel;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative24(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__SR_Ca_uptake_and_release__F1 = rY[24];
        // Units: dimensionless; Initial value: 0.1133251
        double var_chaste_interface__SR_Ca_uptake_and_release__F3 = rY[26];
        // Units: dimensionless; Initial value: 0.8859153
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__r_act = 240.0 * exp(-3.2000000000000002 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((0.0040000000000000001 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F1 = 0.00095999999999999992 * var_chaste_interface__SR_Ca_uptake_and_release__F3 - 0.001 * var_chaste_interface__SR_Ca_uptake_and_release__F1 * var_SR_Ca_uptake_and_release__r_act; // 1 / millisecond

        return d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F1;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative24(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -49.54105
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            
            const double var_x213 = exp(-3.2000000000000002 + 0.080000000000000002 * var_chaste_interface__membrane__V);
            const double var_x215 = 0.0040000000000000001 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x216 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4);
            const double var_x218 = pow(var_x215, (-4));
            const double var_x221 = 0.23999999999999999 * var_x213;
            const double var_x222 = 0.23999999999999999 * var_x216 * var_x218;
            const double var_x223 = -var_x222;
            
            partialF = var_x223 - var_x221;
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative25(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -49.54105
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__SR_Ca_uptake_and_release__F1 = rY[24];
        // Units: dimensionless; Initial value: 0.1133251
        double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rY[25];
        // Units: dimensionless; Initial value: 0.0007594214
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__r_inact = 40.0 + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((0.0040000000000000001 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double var_SR_Ca_uptake_and_release__r_act = 240.0 * exp(-3.2000000000000002 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((0.0040000000000000001 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F2 = 0.001 * var_chaste_interface__SR_Ca_uptake_and_release__F1 * var_SR_Ca_uptake_and_release__r_act - 0.001 * var_chaste_interface__SR_Ca_uptake_and_release__F2 * var_SR_Ca_uptake_and_release__r_inact; // 1 / millisecond

        return d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F2;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative25(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 0.0003787018
            
            const double var_x215 = 0.0040000000000000001 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i;
            const double var_x216 = pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4);
            const double var_x218 = pow(var_x215, (-4));
            const double var_x222 = 0.23999999999999999 * var_x216 * var_x218;
            const double var_x223 = -var_x222;
            
            partialF = -0.040000000000000001 + var_x223;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluateYDerivative26(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 0.0003787018
        double var_chaste_interface__SR_Ca_uptake_and_release__F2 = rY[25];
        // Units: dimensionless; Initial value: 0.0007594214
        double var_chaste_interface__SR_Ca_uptake_and_release__F3 = rY[26];
        // Units: dimensionless; Initial value: 0.8859153
        
        
        // Mathematics
        const double var_SR_Ca_uptake_and_release__r_inact = 40.0 + 240.0 * pow(var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i, 4) / pow((0.0040000000000000001 + var_chaste_interface__intracellular_concentrations_and_buffer_equations__Ca_i), 4); // per_second
        const double d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F3 = -0.00095999999999999992 * var_chaste_interface__SR_Ca_uptake_and_release__F3 + 0.001 * var_chaste_interface__SR_Ca_uptake_and_release__F2 * var_SR_Ca_uptake_and_release__r_inact; // 1 / millisecond

        return d_dt_chaste_interface_var_SR_Ca_uptake_and_release__F3;
    }

    double Celldemir_model_1994FromCellMLGRL1Opt::EvaluatePartialDerivative26(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.00095999999999999992;
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }

    std::vector<double> Celldemir_model_1994FromCellMLGRL1Opt::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics

        std::vector<double> dqs(1);
        dqs[0] = var_chaste_interface__environment__time_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celldemir_model_1994FromCellMLGRL1Opt>::Initialise(void)
{
    this->mSystemName = "demir_model_1994";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-49.54105);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.0003787018);

    // rY[2]:
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.250113);

    // rY[3]:
    this->mVariableNames.push_back("sodium_current_h_gate__h1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001386897);

    // rY[4]:
    this->mVariableNames.push_back("sodium_current_h_gate__h2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002065463);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002572773);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_gate__f_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.98651);

    // rY[7]:
    this->mVariableNames.push_back("T_type_Ca_channel_d_gate__d_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02012114);

    // rY[8]:
    this->mVariableNames.push_back("T_type_Ca_channel_f_gate__f_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1945111);

    // rY[9]:
    this->mVariableNames.push_back("delayed_rectifying_potassium_current_P_a_gate__P_a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02302278);

    // rY[10]:
    this->mVariableNames.push_back("delayed_rectifying_potassium_current_P_i_gate__P_i");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3777728);

    // rY[11]:
    this->mVariableNames.push_back("hyperpolarisation_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.09227776);

    // rY[12]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(9.701621);

    // rY[13]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(140.7347);

    // rY[14]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Ca_Calmod");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1411678);

    // rY[15]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Ca_Trop");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.07331396);

    // rY[16]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Ca_Mg_Trop");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.7618549);

    // rY[17]:
    this->mVariableNames.push_back("intracellular_concentrations_and_buffer_equations__Mg_Mg_Trop");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.2097049);

    // rY[18]:
    this->mVariableNames.push_back("cleft_space_equations__Na_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(139.9988);

    // rY[19]:
    this->mVariableNames.push_back("cleft_space_equations__Ca_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.00474);

    // rY[20]:
    this->mVariableNames.push_back("cleft_space_equations__K_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.389014);

    // rY[21]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(16.95311);

    // rY[22]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(16.85024);

    // rY[23]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__Ca_Calse");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9528726);

    // rY[24]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__F1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1133251);

    // rY[25]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__F2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0007594214);

    // rY[26]:
    this->mVariableNames.push_back("SR_Ca_uptake_and_release__F3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8859153);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celldemir_model_1994FromCellMLGRL1Opt)

