//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: decker_2009
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "decker_2009.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Celldecker_2009FromCellMLGRL1Opt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -80.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration = 0.5; // ms
        const double var_chaste_interface__membrane__stim_offset = 0; // ms
        const double var_chaste_interface__membrane__stim_period = 1000.0; // ms
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration,
                var_chaste_interface__membrane__stim_period,
                var_chaste_interface__membrane__stim_offset
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Celldecker_2009FromCellMLGRL1Opt::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Celldecker_2009FromCellMLGRL1Opt::Celldecker_2009FromCellMLGRL1Opt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                48,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Celldecker_2009FromCellMLGRL1Opt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 0.00015552; // (var_ICaL__PCa) [L_per_F_ms]
        this->mParameters[1] = 9.0749999999999993; // (var_INa__g_Na) [mS_per_uF]
        this->mParameters[2] = 0.013854200000000001; // (var_IKr__gKr_max) [mS_per_uF]
    }

    Celldecker_2009FromCellMLGRL1Opt::~Celldecker_2009FromCellMLGRL1Opt()
    {
    }
    
    double Celldecker_2009FromCellMLGRL1Opt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__IKs__O1 = rY[17];
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = rY[18];
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        double var_chaste_interface__Irel__Irel = rY[37];
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = rY[43];
        // Units: mM; Initial value: 6.935607
        double var_chaste_interface__Cl__Cl_i = rY[44];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = rY[46];
        // Units: mM; Initial value: 145.5689
        
        const double var_INaCa__INaCa = (6.4800000000000004 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 9878400.0 * var_chaste_interface__Ca__Ca_i * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_i)); // uA_per_uF
        const double var_INaCa__INaCa_ss_sr = (1.6200000000000001 * pow(var_chaste_interface__Na__Na_ss_sr, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 2469600.0 * var_chaste_interface__Ca__Ca_ss_sr * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_ss_sr, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_ss_sr, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr)); // uA_per_uF
        const double var_INaK__INaK = 0.062337970750628316 * pow(var_chaste_interface__Na__Na_i, 3) / (pow((1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i), 3) * (1.0 + exp(-3.4441726741524206 - 0.037436659501656748 * var_chaste_interface__membrane__Vm))); // uA_per_uF
        const double var_membrane__caiont = -2.0 * var_INaCa__INaCa - 2.0 * var_INaCa__INaCa_ss_sr + 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i) + 0.0028826178386108462 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) + 14448.603861345418 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss_CaL * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * mParameters[0] * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_membrane__clont = 0.00022499999999999999 * var_chaste_interface__membrane__Vm + 0.0060101516266440041 * log(100.0 / var_chaste_interface__Cl__Cl_i) + 0.0032509358688027189 * (1.0 - 1.0 / (1.0 + 6.2499999999999991 * pow(var_chaste_interface__Irel__Irel, 2))) * (-100.0 * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2_i2f_gate__i2f * var_chaste_interface__membrane__Vm / (1.0 - exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_reversal_potentials__EK = 26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_reversal_potentials__ENa = 26.711785007306684 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_membrane__naiont = 3.0 * var_INaCa__INaCa + 3.0 * var_INaCa__INaCa_ss_sr + 3.0 * var_INaK__INaK + 0.0064999999999999997 * pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * var_chaste_interface__INaL_hL_gate__hL + 1.1558883089076335e-5 * (-140.0 + var_chaste_interface__Na__Na_i * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)) + pow(var_chaste_interface__INa_m_gate__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * mParameters[1] * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // uA_per_uF
        const double var_membrane__kiont = -2.0 * var_INaK__INaK + 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)) + (0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.711785007306684 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__membrane__Vm) * (var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2) + 0.51000000000000001 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)) + (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 0.080320000000000003 * var_reversal_potentials__EK) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 0.061749999999999999 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__membrane__Vm)))) + 1.0 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * mParameters[2] * var_chaste_interface__IKr_xr_gate__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)) + 0.4975 * pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s * exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm); // uA_per_uF
        const double var_chaste_interface__i_ionic = (var_membrane__caiont + var_membrane__clont + var_membrane__kiont + var_membrane__naiont) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Celldecker_2009FromCellMLGRL1Opt::UpdateTransmembranePotential(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;

        double d_dt_chaste_interface_var_membrane__Vm;
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__IKs__O1 = rY[17];
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = rY[18];
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        double var_chaste_interface__Irel__Irel = rY[37];
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = rY[43];
        // Units: mM; Initial value: 6.935607
        double var_chaste_interface__Cl__Cl_i = rY[44];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = rY[46];
        // Units: mM; Initial value: 145.5689
        

        // Mathematics
        const double var_IpCa__IpCa = 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i); // uA_per_uF
        const double var_membrane__i_Stim = GetIntracellularAreaStimulus(var_chaste_interface__environment__time) / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_ICaL__ICaL = 14448.603861345418 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss_CaL * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * mParameters[0] * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_ICab__ICab = 0.0028826178386108462 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_INaCa__INaCa = (6.4800000000000004 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 9878400.0 * var_chaste_interface__Ca__Ca_i * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_i)); // uA_per_uF
        const double var_INaCa__INaCa_ss_sr = (1.6200000000000001 * pow(var_chaste_interface__Na__Na_ss_sr, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 2469600.0 * var_chaste_interface__Ca__Ca_ss_sr * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_ss_sr, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_ss_sr, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr)); // uA_per_uF
        const double var_INaK__INaK = 0.062337970750628316 * pow(var_chaste_interface__Na__Na_i, 3) / (pow((1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i), 3) * (1.0 + exp(-3.4441726741524206 - 0.037436659501656748 * var_chaste_interface__membrane__Vm))); // uA_per_uF
        const double var_INab__INab = 1.1558883089076335e-5 * (-140.0 + var_chaste_interface__Na__Na_i * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_Ito2__Ito2 = 0.0032509358688027189 * (1.0 - 1.0 / (1.0 + 6.2499999999999991 * pow(var_chaste_interface__Irel__Irel, 2))) * (-100.0 * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2_i2f_gate__i2f * var_chaste_interface__membrane__Vm / (1.0 - exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_reversal_potentials__ECl = -26.711785007306684 * log(100.0 / var_chaste_interface__Cl__Cl_i); // mV
        const double var_IClb__IClb = 0.00022499999999999999 * var_chaste_interface__membrane__Vm - 0.00022499999999999999 * var_reversal_potentials__ECl; // uA_per_uF
        const double var_reversal_potentials__EK = 26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_IK1__IK1 = 0.51000000000000001 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)) + (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 0.080320000000000003 * var_reversal_potentials__EK) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 0.061749999999999999 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__membrane__Vm)))); // uA_per_uF
        const double var_IKp__IKp = 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_IKr__IKr = 1.0 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * mParameters[2] * var_chaste_interface__IKr_xr_gate__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_Ito1__Ito1 = 0.4975 * pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s * exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm); // uA_per_uF
        const double var_reversal_potentials__ENa = 26.711785007306684 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_INa__INa = pow(var_chaste_interface__INa_m_gate__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * mParameters[1] * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // uA_per_uF
        const double var_INaL__INaL = 0.0064999999999999997 * pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * var_chaste_interface__INaL_hL_gate__hL; // uA_per_uF
        const double var_IKs__IKs = (0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.711785007306684 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__membrane__Vm) * (var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2); // uA_per_uF
        d_dt_chaste_interface_var_membrane__Vm = -var_ICaL__ICaL - var_ICab__ICab - var_IClb__IClb - var_IK1__IK1 - var_IKp__IKp - var_IKr__IKr - var_IKs__IKs - var_INa__INa - var_INaL__INaL - var_INab__INab - var_IpCa__IpCa - var_Ito1__Ito1 - var_Ito2__Ito2 - var_membrane__i_Stim - 1.0 * var_INaCa__INaCa - 1.0 * var_INaCa__INaCa_ss_sr - 1.0 * var_INaK__INaK; // mV / ms

        double evalF = d_dt_chaste_interface_var_membrane__Vm;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__Vm;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Celldecker_2009FromCellMLGRL1Opt::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta = 1e-8;

        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__IKs__C1 = rY[2];
        // Units: dimensionless; Initial value: 0.476653873938053
        double var_chaste_interface__IKs__C2 = rY[3];
        // Units: dimensionless; Initial value: 0.2551771850026437
        double var_chaste_interface__IKs__C3 = rY[4];
        // Units: dimensionless; Initial value: 0.05122852186842027
        double var_chaste_interface__IKs__C4 = rY[5];
        // Units: dimensionless; Initial value: 0.004570874421666423
        double var_chaste_interface__IKs__C5 = rY[6];
        // Units: dimensionless; Initial value: 0.0001529389211563687
        double var_chaste_interface__IKs__C6 = rY[7];
        // Units: dimensionless; Initial value: 0.1328281770413747
        double var_chaste_interface__IKs__C7 = rY[8];
        // Units: dimensionless; Initial value: 0.05333228495514583
        double var_chaste_interface__IKs__C8 = rY[9];
        // Units: dimensionless; Initial value: 0.007137874613383642
        double var_chaste_interface__IKs__C9 = rY[10];
        // Units: dimensionless; Initial value: 0.0003184390970637536
        double var_chaste_interface__IKs__C10 = rY[11];
        // Units: dimensionless; Initial value: 0.01388061042363991
        double var_chaste_interface__IKs__C11 = rY[12];
        // Units: dimensionless; Initial value: 0.003715500164470033
        double var_chaste_interface__IKs__C12 = rY[13];
        // Units: dimensionless; Initial value: 0.0002486371465457659
        double var_chaste_interface__IKs__C13 = rY[14];
        // Units: dimensionless; Initial value: 0.0006446803014431032
        double var_chaste_interface__IKs__C14 = rY[15];
        // Units: dimensionless; Initial value: 8.628258026770862e-05
        double var_chaste_interface__IKs__C15 = rY[16];
        // Units: dimensionless; Initial value: 1.122823524761588e-05
        double var_chaste_interface__IKs__O1 = rY[17];
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = rY[18];
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        double var_chaste_interface__ICaL__C = rY[19];
        // Units: dimensionless; Initial value: 0.9999613782488198
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__C_star = rY[21];
        // Units: dimensionless; Initial value: 5.936477396599124e-11
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__ICaL__CI = rY[23];
        // Units: dimensionless; Initial value: 1.587938121237188e-05
        double var_chaste_interface__ICaL__OI = rY[24];
        // Units: dimensionless; Initial value: 3.611420243201921e-10
        double var_chaste_interface__ICaL__CI_star = rY[25];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ICaL__OI_star = rY[26];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        double var_chaste_interface__Irel__Irel = rY[37];
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_JSR = rY[38];
        // Units: mM; Initial value: 0.917692717
        double var_chaste_interface__Ca__Ca_NSR = rY[39];
        // Units: mM; Initial value: 0.929835335
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = rY[43];
        // Units: mM; Initial value: 6.935607
        double var_chaste_interface__Cl__Cl_i = rY[44];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__Cl__Cl_ss = rY[45];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = rY[46];
        // Units: mM; Initial value: 145.5689
        double var_chaste_interface__CaMK_active__CaMK_trap = rY[47];
        // Units: dimensionless; Initial value: 0.0018861341
        
        
        // Mathematics
        const double var_Ca__Idiff = 5.0 * var_chaste_interface__Ca__Ca_ss_sr - 5.0 * var_chaste_interface__Ca__Ca_i; // mM_per_ms
        const double var_Ca__Idiff_ss = 0.5 * var_chaste_interface__Ca__Ca_ss_sr - 0.5 * var_chaste_interface__Ca__Ca_ss_CaL; // mM_per_ms
        const double var_CaMK_active__CaMK_active = 0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap; // dimensionless
        const double var_Cl__Idiff_Cl = 5.0 * var_chaste_interface__Cl__Cl_ss - 5.0 * var_chaste_interface__Cl__Cl_i; // mM_per_ms
        const double d_dt_chaste_interface_var_CaMK_active__CaMK_trap = -0.00068000000000000005 * var_chaste_interface__CaMK_active__CaMK_trap + 0.050000000000000003 * (-var_chaste_interface__CaMK_active__CaMK_trap + var_CaMK_active__CaMK_active) * var_CaMK_active__CaMK_active; // 1 / ms
        const double var_ICaL__delta = 3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // per_ms
        const double var_Ileak__Ileak = 0.00029166666666666669 * var_chaste_interface__Ca__Ca_NSR; // mM_per_ms
        const double var_IpCa__IpCa = 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i); // uA_per_uF
        const double var_Irel__beta_tau = 4.75 + 4.75 / (1.0 + 2.9619676669542428e-6 * pow(1 / var_CaMK_active__CaMK_active, 10.0)); // ms
        const double var_Itr__Itr = 0.040000000000000001 * var_chaste_interface__Ca__Ca_NSR - 0.040000000000000001 * var_chaste_interface__Ca__Ca_JSR; // mM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_JSR = (-var_chaste_interface__Irel__Irel + var_Itr__Itr) / (1.0 + 8.0 / pow((0.80000000000000004 + var_chaste_interface__Ca__Ca_JSR), 2)); // mM / ms
        const double var_Iup__Iup = 0.0043750000000000004 * (1.0 + 0.75 * var_CaMK_active__CaMK_active / (0.14999999999999999 + var_CaMK_active__CaMK_active)) * var_chaste_interface__Ca__Ca_i / (0.00092000000000000003 - 0.00017000000000000001 * var_CaMK_active__CaMK_active / (0.14999999999999999 + var_CaMK_active__CaMK_active) + var_chaste_interface__Ca__Ca_i); // mM_per_ms
        const double var_Na__Idiff_Na = 5.0 * var_chaste_interface__Na__Na_ss_sr - 5.0 * var_chaste_interface__Na__Na_i; // mM_per_ms
        const double var_cell_geometry__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell_geometry__Vjsr = 0.0047999999999999996 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vmyo = 0.67800000000000005 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vnsr = 0.055199999999999999 * var_cell_geometry__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_NSR = -var_Ileak__Ileak - var_Itr__Itr * var_cell_geometry__Vjsr / var_cell_geometry__Vnsr + var_Iup__Iup; // mM / ms
        const double var_cell_geometry__Vss_CaL = 0.002 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vss_sr = 0.02 * var_cell_geometry__vcell; // uL
        const double var_ICaL__ACT_infinity = 1 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__ACT_tau = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)); // ms
        const double var_ICaL__IV_infinity = 0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_infinity_star = 9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_tau = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))); // ms
        const double var_ICaL__IV_tau_star = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))); // ms
        const double var_ICaL__alpha = var_ICaL__ACT_infinity / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__ACT_infinity) / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__x = var_ICaL__IV_infinity / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__x_star = var_ICaL__IV_infinity_star / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__y = (1.0 - var_ICaL__IV_infinity) / var_ICaL__IV_tau; // per_ms
        const double d_dt_chaste_interface_var_ICaL__C = var_chaste_interface__ICaL__C_star + (-var_ICaL__alpha - var_ICaL__delta - var_ICaL__y) * var_chaste_interface__ICaL__C + var_chaste_interface__ICaL__CI * var_ICaL__x + var_chaste_interface__ICaL__O * var_ICaL__beta; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__O = var_chaste_interface__ICaL__O_star + (-var_ICaL__beta - var_ICaL__delta - var_ICaL__y) * var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__C * var_ICaL__alpha + var_chaste_interface__ICaL__OI * var_ICaL__x; // 1 / ms
        const double var_ICaL__y_star = (1.0 - var_ICaL__IV_infinity_star) / var_ICaL__IV_tau_star; // per_ms
        const double d_dt_chaste_interface_var_ICaL__C_star = (-1.0 - var_ICaL__alpha - var_ICaL__y_star) * var_chaste_interface__ICaL__C_star + var_chaste_interface__ICaL__C * var_ICaL__delta + var_chaste_interface__ICaL__CI_star * var_ICaL__x_star + var_chaste_interface__ICaL__O_star * var_ICaL__beta; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__O_star = (-1.0 - var_ICaL__beta - var_ICaL__y_star) * var_chaste_interface__ICaL__O_star + var_chaste_interface__ICaL__C_star * var_ICaL__alpha + var_chaste_interface__ICaL__O * var_ICaL__delta + var_chaste_interface__ICaL__OI_star * var_ICaL__x_star; // 1 / ms
        const double var_ICaL__delta_I = 9.9999999999999995e-7 * var_ICaL__delta * var_ICaL__x * var_ICaL__y_star / (var_ICaL__x_star * var_ICaL__y); // per_ms
        const double d_dt_chaste_interface_var_ICaL__CI = 9.9999999999999995e-7 * var_chaste_interface__ICaL__CI_star + (-var_ICaL__alpha - var_ICaL__delta_I - var_ICaL__x) * var_chaste_interface__ICaL__CI + var_chaste_interface__ICaL__C * var_ICaL__y + var_chaste_interface__ICaL__OI * var_ICaL__beta; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__CI_star = (-9.9999999999999995e-7 - var_ICaL__alpha - var_ICaL__x_star) * var_chaste_interface__ICaL__CI_star + var_chaste_interface__ICaL__CI * var_ICaL__delta_I + var_chaste_interface__ICaL__C_star * var_ICaL__y_star + var_chaste_interface__ICaL__OI_star * var_ICaL__beta; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__OI = 9.9999999999999995e-7 * var_chaste_interface__ICaL__OI_star + (-var_ICaL__beta - var_ICaL__delta_I - var_ICaL__x) * var_chaste_interface__ICaL__OI + var_chaste_interface__ICaL__CI * var_ICaL__alpha + var_chaste_interface__ICaL__O * var_ICaL__y; // 1 / ms
        const double d_dt_chaste_interface_var_ICaL__OI_star = (-9.9999999999999995e-7 - var_ICaL__beta - var_ICaL__x_star) * var_chaste_interface__ICaL__OI_star + var_chaste_interface__ICaL__CI_star * var_ICaL__alpha + var_chaste_interface__ICaL__OI * var_ICaL__delta_I + var_chaste_interface__ICaL__O_star * var_ICaL__y_star; // 1 / ms
        const double d_dt_chaste_interface_var_IKr_xr_gate__xr = (-var_chaste_interface__IKr_xr_gate__xr + 1 / (1.0 + exp(-2.3729411764705883 - 0.23529411764705882 * var_chaste_interface__membrane__Vm))) * (0.00029999999999999997 * (38.360799999999998 + var_chaste_interface__membrane__Vm) / (-1.0 + exp(5.8385137599999997 + 0.1522 * var_chaste_interface__membrane__Vm)) + 0.00059999999999999995 * (-1.7383999999999999 + var_chaste_interface__membrane__Vm) / (1.0 - exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__membrane__Vm))); // 1 / ms
        const double d_dt_chaste_interface_var_INaL_hL_gate__hL = 0.0016666666666666668 / (1.0 + exp(14.918032786885247 + 0.16393442622950821 * var_chaste_interface__membrane__Vm)) - 0.0016666666666666668 * var_chaste_interface__INaL_hL_gate__hL; // 1 / ms
        const double d_dt_chaste_interface_var_INaL_mL_gate__mL = -0.080000000000000002 * var_chaste_interface__INaL_mL_gate__mL * exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm) + 0.32000000000000001 * (1.0 - var_chaste_interface__INaL_mL_gate__mL) * (47.130000000000003 + var_chaste_interface__membrane__Vm) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__Vm)); // 1 / ms
        const double d_dt_chaste_interface_var_INa_h_gate__h = (1.0 - var_chaste_interface__INa_h_gate__h) * ((var_chaste_interface__membrane__Vm >= -40.0) ? (0) : (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__Vm))) - ((var_chaste_interface__membrane__Vm >= -40.0) ? (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__Vm))) : (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__Vm) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__Vm))) * var_chaste_interface__INa_h_gate__h; // 1 / ms
        const double d_dt_chaste_interface_var_INa_j_gate__j = (1.0 - var_chaste_interface__INa_j_gate__j) * ((var_chaste_interface__membrane__Vm >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__membrane__Vm) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__Vm) - 6.9480000000000006e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__Vm)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__Vm)))) - ((var_chaste_interface__membrane__Vm >= -40.0) ? (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__Vm))) : (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__Vm)))) * var_chaste_interface__INa_j_gate__j; // 1 / ms
        const double d_dt_chaste_interface_var_INa_m_gate__m = -0.080000000000000002 * var_chaste_interface__INa_m_gate__m * exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm) + 0.32000000000000001 * (1.0 - var_chaste_interface__INa_m_gate__m) * (47.130000000000003 + var_chaste_interface__membrane__Vm) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__Vm)); // 1 / ms
        const double d_dt_chaste_interface_var_Ito1_a_gate__a = (-var_chaste_interface__Ito1_a_gate__a + 1 / (1.0 + exp(-1.3230057479321462 - 0.14019346698443852 * var_chaste_interface__membrane__Vm))) * (3.5 / (1.0 + exp(3.403513787634354 + 0.034035137876343539 * var_chaste_interface__membrane__Vm)) + 0.82719827942757873 / (1.0 + exp(0.62658348478969694 - 0.034035137876343539 * var_chaste_interface__membrane__Vm))); // 1 / ms
        const double d_dt_chaste_interface_var_Ito1_i1f_gate__i1f = 0.025000000000000001 * (1.0 - var_chaste_interface__Ito1_i1f_gate__i1f) / (1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)) - 0.10208977775055385 * var_chaste_interface__Ito1_i1f_gate__i1f / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm)); // 1 / ms
        const double d_dt_chaste_interface_var_Ito1_i1s_gate__i1s = 0.0040000000000000001 * (1.0 - var_chaste_interface__Ito1_i1s_gate__i1s) / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)) - 0.10208977775055385 * var_chaste_interface__Ito1_i1s_gate__i1s / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm)); // 1 / ms
        const double d_dt_chaste_interface_var_Ito2_i2f_gate__i2f = -0.125 * var_chaste_interface__Ito2_i2f_gate__i2f + 0.0031250000000000002 / ((1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)) * (0.025000000000000001 / (1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)) + 0.20000000000000001 / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm)))); // 1 / ms
        const double var_membrane__i_Stim = GetIntracellularAreaStimulus(var_chaste_interface__environment__time) / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_cell_geometry__AF = 5.0618217998279567e-10 * M_PI; // uF_mole_per_C
        const double var_ICaL__ICaL = 14448.603861345418 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss_CaL * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * mParameters[0] * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double d_dt_chaste_interface_var_Ca__Ca_ss_CaL = (var_Ca__Idiff_ss * var_cell_geometry__Vss_sr / var_cell_geometry__Vss_CaL - 0.5 * var_ICaL__ICaL * var_cell_geometry__AF / var_cell_geometry__Vss_CaL) / (1.0 + 0.0097788000000000007 / pow((0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss_CaL), 2) + 4.0890000000000003e-5 / pow((0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss_CaL), 2)); // mM / ms
        const double var_ICab__ICab = 0.0028826178386108462 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C1 = var_chaste_interface__IKs__C2 * var_IKs__beta - 4.0 * var_chaste_interface__IKs__C1 * var_IKs__alpha; // 1 / ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__eta = 0.07732 * exp(-0.0024231252229042349 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C10 = (-2.0 * var_IKs__alpha - 2.0 * var_IKs__delta) * var_chaste_interface__IKs__C10 + var_chaste_interface__IKs__C11 * var_IKs__beta + var_chaste_interface__IKs__C7 * var_IKs__gamma; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C11 = (-var_IKs__alpha - var_IKs__beta - var_IKs__gamma - 2.0 * var_IKs__delta) * var_chaste_interface__IKs__C11 + 2.0 * var_chaste_interface__IKs__C10 * var_IKs__alpha + 2.0 * var_chaste_interface__IKs__C12 * var_IKs__beta + 2.0 * var_chaste_interface__IKs__C8 * var_IKs__gamma + 3.0 * var_chaste_interface__IKs__C13 * var_IKs__delta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C12 = (-2.0 * var_IKs__beta - 2.0 * var_IKs__delta - 2.0 * var_IKs__gamma) * var_chaste_interface__IKs__C12 + var_chaste_interface__IKs__C11 * var_IKs__alpha + 3.0 * var_chaste_interface__IKs__C14 * var_IKs__delta + 3.0 * var_chaste_interface__IKs__C9 * var_IKs__gamma; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C13 = (-var_IKs__alpha - 3.0 * var_IKs__delta) * var_chaste_interface__IKs__C13 + var_chaste_interface__IKs__C11 * var_IKs__gamma + var_chaste_interface__IKs__C14 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C14 = (-var_IKs__beta - var_IKs__gamma - 3.0 * var_IKs__delta) * var_chaste_interface__IKs__C14 + var_chaste_interface__IKs__C13 * var_IKs__alpha + 2.0 * var_chaste_interface__IKs__C12 * var_IKs__gamma + 4.0 * var_chaste_interface__IKs__C15 * var_IKs__delta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C15 = (-0.089538000000000006 - 4.0 * var_IKs__delta) * var_chaste_interface__IKs__C15 + var_chaste_interface__IKs__C14 * var_IKs__gamma + var_chaste_interface__IKs__O1 * var_IKs__eta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C2 = (-var_IKs__beta - var_IKs__gamma - 3.0 * var_IKs__alpha) * var_chaste_interface__IKs__C2 + var_chaste_interface__IKs__C6 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C3 * var_IKs__beta + 4.0 * var_chaste_interface__IKs__C1 * var_IKs__alpha; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C3 = (-2.0 * var_IKs__alpha - 2.0 * var_IKs__beta - 2.0 * var_IKs__gamma) * var_chaste_interface__IKs__C3 + var_chaste_interface__IKs__C7 * var_IKs__delta + 3.0 * var_chaste_interface__IKs__C2 * var_IKs__alpha + 3.0 * var_chaste_interface__IKs__C4 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C4 = (-var_IKs__alpha - 3.0 * var_IKs__beta - 3.0 * var_IKs__gamma) * var_chaste_interface__IKs__C4 + var_chaste_interface__IKs__C8 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C3 * var_IKs__alpha + 4.0 * var_chaste_interface__IKs__C5 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C5 = (-4.0 * var_IKs__beta - 4.0 * var_IKs__gamma) * var_chaste_interface__IKs__C5 + var_chaste_interface__IKs__C4 * var_IKs__alpha + var_chaste_interface__IKs__C9 * var_IKs__delta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C6 = (-var_IKs__delta - 3.0 * var_IKs__alpha) * var_chaste_interface__IKs__C6 + var_chaste_interface__IKs__C2 * var_IKs__gamma + var_chaste_interface__IKs__C7 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C7 = (-var_IKs__beta - var_IKs__delta - var_IKs__gamma - 2.0 * var_IKs__alpha) * var_chaste_interface__IKs__C7 + 2.0 * var_chaste_interface__IKs__C10 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C3 * var_IKs__gamma + 2.0 * var_chaste_interface__IKs__C8 * var_IKs__beta + 3.0 * var_chaste_interface__IKs__C6 * var_IKs__alpha; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C8 = (-var_IKs__alpha - var_IKs__delta - 2.0 * var_IKs__beta - 2.0 * var_IKs__gamma) * var_chaste_interface__IKs__C8 + 2.0 * var_chaste_interface__IKs__C11 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C7 * var_IKs__alpha + 3.0 * var_chaste_interface__IKs__C4 * var_IKs__gamma + 3.0 * var_chaste_interface__IKs__C9 * var_IKs__beta; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__C9 = (-var_IKs__delta - 3.0 * var_IKs__beta - 3.0 * var_IKs__gamma) * var_chaste_interface__IKs__C9 + var_chaste_interface__IKs__C8 * var_IKs__alpha + 2.0 * var_chaste_interface__IKs__C12 * var_IKs__delta + 4.0 * var_chaste_interface__IKs__C5 * var_IKs__gamma; // 1 / ms
        const double var_IKs__omega = 0.79405000000000003 * exp(-0.003001446738885828 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__psi = 0.58638000000000001 * exp(0.0105593841790373 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__O1 = 0.089538000000000006 * var_chaste_interface__IKs__C15 + (-var_IKs__eta - var_IKs__psi) * var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2 * var_IKs__omega; // 1 / ms
        const double d_dt_chaste_interface_var_IKs__O2 = var_chaste_interface__IKs__O1 * var_IKs__psi - var_chaste_interface__IKs__O2 * var_IKs__omega; // 1 / ms
        const double var_INaCa__INaCa = (6.4800000000000004 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 9878400.0 * var_chaste_interface__Ca__Ca_i * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_i)); // uA_per_uF
        const double d_dt_chaste_interface_var_Ca__Ca_i = ((-var_Iup__Iup + var_Ileak__Ileak) * var_cell_geometry__Vnsr / var_cell_geometry__Vmyo + var_Ca__Idiff * var_cell_geometry__Vss_CaL / var_cell_geometry__Vmyo + 0.5 * (-var_ICab__ICab - var_IpCa__IpCa + 2.0 * var_INaCa__INaCa) * var_cell_geometry__AF / var_cell_geometry__Vmyo) / (1.0 + 0.00011900000000000002 / pow((0.0023800000000000002 + var_chaste_interface__Ca__Ca_i), 2) + 3.5000000000000004e-5 / pow((0.00050000000000000001 + var_chaste_interface__Ca__Ca_i), 2)); // mM / ms
        const double var_INaCa__INaCa_ss_sr = (1.6200000000000001 * pow(var_chaste_interface__Na__Na_ss_sr, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 2469600.0 * var_chaste_interface__Ca__Ca_ss_sr * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_ss_sr, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_ss_sr, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr)); // uA_per_uF
        const double d_dt_chaste_interface_var_Ca__Ca_ss_sr = (-var_Ca__Idiff - var_Ca__Idiff_ss + var_chaste_interface__Irel__Irel * var_cell_geometry__Vjsr / var_cell_geometry__Vss_sr + var_INaCa__INaCa_ss_sr * var_cell_geometry__AF / var_cell_geometry__Vss_sr) / (1.0 + 0.0097788000000000007 / pow((0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss_sr), 2) + 4.0890000000000003e-5 / pow((0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss_sr), 2)); // mM / ms
        const double d_dt_chaste_interface_var_Na__Na_ss_sr = -var_Na__Idiff_Na - 3.0 * var_INaCa__INaCa_ss_sr * var_cell_geometry__AF / var_cell_geometry__Vss_sr; // mM / ms
        const double var_INaK__INaK = 0.062337970750628316 * pow(var_chaste_interface__Na__Na_i, 3) / (pow((1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i), 3) * (1.0 + exp(-3.4441726741524206 - 0.037436659501656748 * var_chaste_interface__membrane__Vm))); // uA_per_uF
        const double var_INab__INab = 1.1558883089076335e-5 * (-140.0 + var_chaste_interface__Na__Na_i * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double d_dt_chaste_interface_var_Irel__Irel = (1.0 + 0.0123 / var_chaste_interface__Ca__Ca_JSR) * (-var_chaste_interface__Irel__Irel - 0.1125 * var_ICaL__ICaL * var_Irel__beta_tau / (1.0 + pow(1 / var_chaste_interface__Ca__Ca_JSR, 8.0))) / var_Irel__beta_tau; // mM_per_ms / ms
        const double var_Ito2__Ito2 = 0.0032509358688027189 * (1.0 - 1.0 / (1.0 + 6.2499999999999991 * pow(var_chaste_interface__Irel__Irel, 2))) * (-100.0 * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2_i2f_gate__i2f * var_chaste_interface__membrane__Vm / (1.0 - exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double d_dt_chaste_interface_var_Cl__Cl_ss = -var_Cl__Idiff_Cl + var_Ito2__Ito2 * var_cell_geometry__AF / var_cell_geometry__Vss_sr; // mM / ms
        const double var_reversal_potentials__ECl = -26.711785007306684 * log(100.0 / var_chaste_interface__Cl__Cl_i); // mV
        const double var_IClb__IClb = 0.00022499999999999999 * var_chaste_interface__membrane__Vm - 0.00022499999999999999 * var_reversal_potentials__ECl; // uA_per_uF
        const double var_reversal_potentials__EK = 26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_CT_K_Cl__CT_K_Cl = 1.77e-5 * (-var_reversal_potentials__ECl + var_reversal_potentials__EK) / (87.825100000000006 - var_reversal_potentials__ECl + var_reversal_potentials__EK); // mM_per_ms
        const double var_IK1__IK1 = 0.51000000000000001 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)) + (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 0.080320000000000003 * var_reversal_potentials__EK) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 0.061749999999999999 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__membrane__Vm)))); // uA_per_uF
        const double var_IKp__IKp = 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_IKr__IKr = 1.0 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * mParameters[2] * var_chaste_interface__IKr_xr_gate__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_Ito1__Ito1 = 0.4975 * pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s * exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm); // uA_per_uF
        const double var_reversal_potentials__ENa = 26.711785007306684 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_CT_Na_Cl__CT_Na_Cl = 2.4610800000000002e-5 * pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4) / (59494197.640692554 + pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4)); // mM_per_ms
        const double d_dt_chaste_interface_var_Cl__Cl_i = var_Cl__Idiff_Cl * var_cell_geometry__Vss_sr / var_cell_geometry__Vmyo + var_IClb__IClb * var_cell_geometry__AF / var_cell_geometry__Vmyo + var_CT_K_Cl__CT_K_Cl + var_CT_Na_Cl__CT_Na_Cl; // mM / ms
        const double var_INa__INa = pow(var_chaste_interface__INa_m_gate__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * mParameters[1] * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // uA_per_uF
        const double var_INaL__INaL = 0.0064999999999999997 * pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * var_chaste_interface__INaL_hL_gate__hL; // uA_per_uF
        const double d_dt_chaste_interface_var_Na__Na_i = var_Na__Idiff_Na * var_cell_geometry__Vss_sr / var_cell_geometry__Vmyo - (3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + var_INa__INa + var_INaL__INaL + var_INab__INab) * var_cell_geometry__AF / var_cell_geometry__Vmyo + var_CT_Na_Cl__CT_Na_Cl; // mM / ms
        const double var_IKs__IKs = (0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.711785007306684 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__membrane__Vm) * (var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2); // uA_per_uF
        const double d_dt_chaste_interface_var_K__K_i = -(-2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito1__Ito1 + var_membrane__i_Stim) * var_cell_geometry__AF / var_cell_geometry__Vmyo + var_CT_K_Cl__CT_K_Cl; // mM / ms
        
        mEvalF[1] = d_dt_chaste_interface_var_Ca__Ca_i;
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time, rY, delta);
        mEvalF[2] = d_dt_chaste_interface_var_IKs__C1;
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time, rY, delta);
        mEvalF[3] = d_dt_chaste_interface_var_IKs__C2;
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time, rY, delta);
        mEvalF[4] = d_dt_chaste_interface_var_IKs__C3;
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time, rY, delta);
        mEvalF[5] = d_dt_chaste_interface_var_IKs__C4;
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time, rY, delta);
        mEvalF[6] = d_dt_chaste_interface_var_IKs__C5;
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time, rY, delta);
        mEvalF[7] = d_dt_chaste_interface_var_IKs__C6;
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time, rY, delta);
        mEvalF[8] = d_dt_chaste_interface_var_IKs__C7;
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time, rY, delta);
        mEvalF[9] = d_dt_chaste_interface_var_IKs__C8;
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time, rY, delta);
        mEvalF[10] = d_dt_chaste_interface_var_IKs__C9;
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time, rY, delta);
        mEvalF[11] = d_dt_chaste_interface_var_IKs__C10;
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time, rY, delta);
        mEvalF[12] = d_dt_chaste_interface_var_IKs__C11;
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time, rY, delta);
        mEvalF[13] = d_dt_chaste_interface_var_IKs__C12;
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time, rY, delta);
        mEvalF[14] = d_dt_chaste_interface_var_IKs__C13;
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time, rY, delta);
        mEvalF[15] = d_dt_chaste_interface_var_IKs__C14;
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time, rY, delta);
        mEvalF[16] = d_dt_chaste_interface_var_IKs__C15;
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time, rY, delta);
        mEvalF[17] = d_dt_chaste_interface_var_IKs__O1;
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time, rY, delta);
        mEvalF[18] = d_dt_chaste_interface_var_IKs__O2;
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time, rY, delta);
        mEvalF[19] = d_dt_chaste_interface_var_ICaL__C;
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time, rY, delta);
        mEvalF[20] = d_dt_chaste_interface_var_ICaL__O;
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time, rY, delta);
        mEvalF[21] = d_dt_chaste_interface_var_ICaL__C_star;
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time, rY, delta);
        mEvalF[22] = d_dt_chaste_interface_var_ICaL__O_star;
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time, rY, delta);
        mEvalF[23] = d_dt_chaste_interface_var_ICaL__CI;
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time, rY, delta);
        mEvalF[24] = d_dt_chaste_interface_var_ICaL__OI;
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time, rY, delta);
        mEvalF[25] = d_dt_chaste_interface_var_ICaL__CI_star;
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time, rY, delta);
        mEvalF[26] = d_dt_chaste_interface_var_ICaL__OI_star;
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time, rY, delta);
        mEvalF[27] = d_dt_chaste_interface_var_INa_m_gate__m;
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__environment__time, rY, delta);
        mEvalF[28] = d_dt_chaste_interface_var_INa_h_gate__h;
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__environment__time, rY, delta);
        mEvalF[29] = d_dt_chaste_interface_var_INa_j_gate__j;
        mPartialF[29] = EvaluatePartialDerivative29(var_chaste_interface__environment__time, rY, delta);
        mEvalF[30] = d_dt_chaste_interface_var_INaL_mL_gate__mL;
        mPartialF[30] = EvaluatePartialDerivative30(var_chaste_interface__environment__time, rY, delta);
        mEvalF[31] = d_dt_chaste_interface_var_INaL_hL_gate__hL;
        mPartialF[31] = EvaluatePartialDerivative31(var_chaste_interface__environment__time, rY, delta);
        mEvalF[32] = d_dt_chaste_interface_var_IKr_xr_gate__xr;
        mPartialF[32] = EvaluatePartialDerivative32(var_chaste_interface__environment__time, rY, delta);
        mEvalF[33] = d_dt_chaste_interface_var_Ito1_a_gate__a;
        mPartialF[33] = EvaluatePartialDerivative33(var_chaste_interface__environment__time, rY, delta);
        mEvalF[34] = d_dt_chaste_interface_var_Ito1_i1f_gate__i1f;
        mPartialF[34] = EvaluatePartialDerivative34(var_chaste_interface__environment__time, rY, delta);
        mEvalF[35] = d_dt_chaste_interface_var_Ito1_i1s_gate__i1s;
        mPartialF[35] = EvaluatePartialDerivative35(var_chaste_interface__environment__time, rY, delta);
        mEvalF[36] = d_dt_chaste_interface_var_Ito2_i2f_gate__i2f;
        mPartialF[36] = EvaluatePartialDerivative36(var_chaste_interface__environment__time, rY, delta);
        mEvalF[37] = d_dt_chaste_interface_var_Irel__Irel;
        mPartialF[37] = EvaluatePartialDerivative37(var_chaste_interface__environment__time, rY, delta);
        mEvalF[38] = d_dt_chaste_interface_var_Ca__Ca_JSR;
        mPartialF[38] = EvaluatePartialDerivative38(var_chaste_interface__environment__time, rY, delta);
        mEvalF[39] = d_dt_chaste_interface_var_Ca__Ca_NSR;
        mPartialF[39] = EvaluatePartialDerivative39(var_chaste_interface__environment__time, rY, delta);
        mEvalF[40] = d_dt_chaste_interface_var_Ca__Ca_ss_sr;
        mPartialF[40] = EvaluatePartialDerivative40(var_chaste_interface__environment__time, rY, delta);
        mEvalF[41] = d_dt_chaste_interface_var_Ca__Ca_ss_CaL;
        mPartialF[41] = EvaluatePartialDerivative41(var_chaste_interface__environment__time, rY, delta);
        mEvalF[42] = d_dt_chaste_interface_var_Na__Na_i;
        mPartialF[42] = EvaluatePartialDerivative42(var_chaste_interface__environment__time, rY, delta);
        mEvalF[43] = d_dt_chaste_interface_var_Na__Na_ss_sr;
        mPartialF[43] = EvaluatePartialDerivative43(var_chaste_interface__environment__time, rY, delta);
        mEvalF[44] = d_dt_chaste_interface_var_Cl__Cl_i;
        mPartialF[44] = EvaluatePartialDerivative44(var_chaste_interface__environment__time, rY, delta);
        mEvalF[45] = d_dt_chaste_interface_var_Cl__Cl_ss;
        mPartialF[45] = EvaluatePartialDerivative45(var_chaste_interface__environment__time, rY, delta);
        mEvalF[46] = d_dt_chaste_interface_var_K__K_i;
        mPartialF[46] = EvaluatePartialDerivative46(var_chaste_interface__environment__time, rY, delta);
        mEvalF[47] = d_dt_chaste_interface_var_CaMK_active__CaMK_trap;
        mPartialF[47] = EvaluatePartialDerivative47(var_chaste_interface__environment__time, rY, delta);
        
        {
            if (fabs(mPartialF[1]) < delta){
                rY[1] += mDt*d_dt_chaste_interface_var_Ca__Ca_i;
            }
            else
            {
                rY[1] += (d_dt_chaste_interface_var_Ca__Ca_i/mPartialF[1])*(exp(mPartialF[1]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[2]) < delta){
                rY[2] += mDt*d_dt_chaste_interface_var_IKs__C1;
            }
            else
            {
                rY[2] += (d_dt_chaste_interface_var_IKs__C1/mPartialF[2])*(exp(mPartialF[2]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[3]) < delta){
                rY[3] += mDt*d_dt_chaste_interface_var_IKs__C2;
            }
            else
            {
                rY[3] += (d_dt_chaste_interface_var_IKs__C2/mPartialF[3])*(exp(mPartialF[3]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[4]) < delta){
                rY[4] += mDt*d_dt_chaste_interface_var_IKs__C3;
            }
            else
            {
                rY[4] += (d_dt_chaste_interface_var_IKs__C3/mPartialF[4])*(exp(mPartialF[4]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[5]) < delta){
                rY[5] += mDt*d_dt_chaste_interface_var_IKs__C4;
            }
            else
            {
                rY[5] += (d_dt_chaste_interface_var_IKs__C4/mPartialF[5])*(exp(mPartialF[5]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[6]) < delta){
                rY[6] += mDt*d_dt_chaste_interface_var_IKs__C5;
            }
            else
            {
                rY[6] += (d_dt_chaste_interface_var_IKs__C5/mPartialF[6])*(exp(mPartialF[6]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[7]) < delta){
                rY[7] += mDt*d_dt_chaste_interface_var_IKs__C6;
            }
            else
            {
                rY[7] += (d_dt_chaste_interface_var_IKs__C6/mPartialF[7])*(exp(mPartialF[7]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[8]) < delta){
                rY[8] += mDt*d_dt_chaste_interface_var_IKs__C7;
            }
            else
            {
                rY[8] += (d_dt_chaste_interface_var_IKs__C7/mPartialF[8])*(exp(mPartialF[8]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[9]) < delta){
                rY[9] += mDt*d_dt_chaste_interface_var_IKs__C8;
            }
            else
            {
                rY[9] += (d_dt_chaste_interface_var_IKs__C8/mPartialF[9])*(exp(mPartialF[9]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[10]) < delta){
                rY[10] += mDt*d_dt_chaste_interface_var_IKs__C9;
            }
            else
            {
                rY[10] += (d_dt_chaste_interface_var_IKs__C9/mPartialF[10])*(exp(mPartialF[10]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[11]) < delta){
                rY[11] += mDt*d_dt_chaste_interface_var_IKs__C10;
            }
            else
            {
                rY[11] += (d_dt_chaste_interface_var_IKs__C10/mPartialF[11])*(exp(mPartialF[11]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[12]) < delta){
                rY[12] += mDt*d_dt_chaste_interface_var_IKs__C11;
            }
            else
            {
                rY[12] += (d_dt_chaste_interface_var_IKs__C11/mPartialF[12])*(exp(mPartialF[12]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[13]) < delta){
                rY[13] += mDt*d_dt_chaste_interface_var_IKs__C12;
            }
            else
            {
                rY[13] += (d_dt_chaste_interface_var_IKs__C12/mPartialF[13])*(exp(mPartialF[13]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[14]) < delta){
                rY[14] += mDt*d_dt_chaste_interface_var_IKs__C13;
            }
            else
            {
                rY[14] += (d_dt_chaste_interface_var_IKs__C13/mPartialF[14])*(exp(mPartialF[14]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[15]) < delta){
                rY[15] += mDt*d_dt_chaste_interface_var_IKs__C14;
            }
            else
            {
                rY[15] += (d_dt_chaste_interface_var_IKs__C14/mPartialF[15])*(exp(mPartialF[15]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[16]) < delta){
                rY[16] += mDt*d_dt_chaste_interface_var_IKs__C15;
            }
            else
            {
                rY[16] += (d_dt_chaste_interface_var_IKs__C15/mPartialF[16])*(exp(mPartialF[16]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[17]) < delta){
                rY[17] += mDt*d_dt_chaste_interface_var_IKs__O1;
            }
            else
            {
                rY[17] += (d_dt_chaste_interface_var_IKs__O1/mPartialF[17])*(exp(mPartialF[17]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[18]) < delta){
                rY[18] += mDt*d_dt_chaste_interface_var_IKs__O2;
            }
            else
            {
                rY[18] += (d_dt_chaste_interface_var_IKs__O2/mPartialF[18])*(exp(mPartialF[18]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[19]) < delta){
                rY[19] += mDt*d_dt_chaste_interface_var_ICaL__C;
            }
            else
            {
                rY[19] += (d_dt_chaste_interface_var_ICaL__C/mPartialF[19])*(exp(mPartialF[19]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[20]) < delta){
                rY[20] += mDt*d_dt_chaste_interface_var_ICaL__O;
            }
            else
            {
                rY[20] += (d_dt_chaste_interface_var_ICaL__O/mPartialF[20])*(exp(mPartialF[20]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[21]) < delta){
                rY[21] += mDt*d_dt_chaste_interface_var_ICaL__C_star;
            }
            else
            {
                rY[21] += (d_dt_chaste_interface_var_ICaL__C_star/mPartialF[21])*(exp(mPartialF[21]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[22]) < delta){
                rY[22] += mDt*d_dt_chaste_interface_var_ICaL__O_star;
            }
            else
            {
                rY[22] += (d_dt_chaste_interface_var_ICaL__O_star/mPartialF[22])*(exp(mPartialF[22]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[23]) < delta){
                rY[23] += mDt*d_dt_chaste_interface_var_ICaL__CI;
            }
            else
            {
                rY[23] += (d_dt_chaste_interface_var_ICaL__CI/mPartialF[23])*(exp(mPartialF[23]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[24]) < delta){
                rY[24] += mDt*d_dt_chaste_interface_var_ICaL__OI;
            }
            else
            {
                rY[24] += (d_dt_chaste_interface_var_ICaL__OI/mPartialF[24])*(exp(mPartialF[24]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[25]) < delta){
                rY[25] += mDt*d_dt_chaste_interface_var_ICaL__CI_star;
            }
            else
            {
                rY[25] += (d_dt_chaste_interface_var_ICaL__CI_star/mPartialF[25])*(exp(mPartialF[25]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[26]) < delta){
                rY[26] += mDt*d_dt_chaste_interface_var_ICaL__OI_star;
            }
            else
            {
                rY[26] += (d_dt_chaste_interface_var_ICaL__OI_star/mPartialF[26])*(exp(mPartialF[26]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[27]) < delta){
                rY[27] += mDt*d_dt_chaste_interface_var_INa_m_gate__m;
            }
            else
            {
                rY[27] += (d_dt_chaste_interface_var_INa_m_gate__m/mPartialF[27])*(exp(mPartialF[27]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[28]) < delta){
                rY[28] += mDt*d_dt_chaste_interface_var_INa_h_gate__h;
            }
            else
            {
                rY[28] += (d_dt_chaste_interface_var_INa_h_gate__h/mPartialF[28])*(exp(mPartialF[28]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[29]) < delta){
                rY[29] += mDt*d_dt_chaste_interface_var_INa_j_gate__j;
            }
            else
            {
                rY[29] += (d_dt_chaste_interface_var_INa_j_gate__j/mPartialF[29])*(exp(mPartialF[29]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[30]) < delta){
                rY[30] += mDt*d_dt_chaste_interface_var_INaL_mL_gate__mL;
            }
            else
            {
                rY[30] += (d_dt_chaste_interface_var_INaL_mL_gate__mL/mPartialF[30])*(exp(mPartialF[30]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[31]) < delta){
                rY[31] += mDt*d_dt_chaste_interface_var_INaL_hL_gate__hL;
            }
            else
            {
                rY[31] += (d_dt_chaste_interface_var_INaL_hL_gate__hL/mPartialF[31])*(exp(mPartialF[31]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[32]) < delta){
                rY[32] += mDt*d_dt_chaste_interface_var_IKr_xr_gate__xr;
            }
            else
            {
                rY[32] += (d_dt_chaste_interface_var_IKr_xr_gate__xr/mPartialF[32])*(exp(mPartialF[32]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[33]) < delta){
                rY[33] += mDt*d_dt_chaste_interface_var_Ito1_a_gate__a;
            }
            else
            {
                rY[33] += (d_dt_chaste_interface_var_Ito1_a_gate__a/mPartialF[33])*(exp(mPartialF[33]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[34]) < delta){
                rY[34] += mDt*d_dt_chaste_interface_var_Ito1_i1f_gate__i1f;
            }
            else
            {
                rY[34] += (d_dt_chaste_interface_var_Ito1_i1f_gate__i1f/mPartialF[34])*(exp(mPartialF[34]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[35]) < delta){
                rY[35] += mDt*d_dt_chaste_interface_var_Ito1_i1s_gate__i1s;
            }
            else
            {
                rY[35] += (d_dt_chaste_interface_var_Ito1_i1s_gate__i1s/mPartialF[35])*(exp(mPartialF[35]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[36]) < delta){
                rY[36] += mDt*d_dt_chaste_interface_var_Ito2_i2f_gate__i2f;
            }
            else
            {
                rY[36] += (d_dt_chaste_interface_var_Ito2_i2f_gate__i2f/mPartialF[36])*(exp(mPartialF[36]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[37]) < delta){
                rY[37] += mDt*d_dt_chaste_interface_var_Irel__Irel;
            }
            else
            {
                rY[37] += (d_dt_chaste_interface_var_Irel__Irel/mPartialF[37])*(exp(mPartialF[37]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[38]) < delta){
                rY[38] += mDt*d_dt_chaste_interface_var_Ca__Ca_JSR;
            }
            else
            {
                rY[38] += (d_dt_chaste_interface_var_Ca__Ca_JSR/mPartialF[38])*(exp(mPartialF[38]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[39]) < delta){
                rY[39] += mDt*d_dt_chaste_interface_var_Ca__Ca_NSR;
            }
            else
            {
                rY[39] += (d_dt_chaste_interface_var_Ca__Ca_NSR/mPartialF[39])*(exp(mPartialF[39]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[40]) < delta){
                rY[40] += mDt*d_dt_chaste_interface_var_Ca__Ca_ss_sr;
            }
            else
            {
                rY[40] += (d_dt_chaste_interface_var_Ca__Ca_ss_sr/mPartialF[40])*(exp(mPartialF[40]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[41]) < delta){
                rY[41] += mDt*d_dt_chaste_interface_var_Ca__Ca_ss_CaL;
            }
            else
            {
                rY[41] += (d_dt_chaste_interface_var_Ca__Ca_ss_CaL/mPartialF[41])*(exp(mPartialF[41]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[42]) < delta){
                rY[42] += mDt*d_dt_chaste_interface_var_Na__Na_i;
            }
            else
            {
                rY[42] += (d_dt_chaste_interface_var_Na__Na_i/mPartialF[42])*(exp(mPartialF[42]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[43]) < delta){
                rY[43] += mDt*d_dt_chaste_interface_var_Na__Na_ss_sr;
            }
            else
            {
                rY[43] += (d_dt_chaste_interface_var_Na__Na_ss_sr/mPartialF[43])*(exp(mPartialF[43]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[44]) < delta){
                rY[44] += mDt*d_dt_chaste_interface_var_Cl__Cl_i;
            }
            else
            {
                rY[44] += (d_dt_chaste_interface_var_Cl__Cl_i/mPartialF[44])*(exp(mPartialF[44]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[45]) < delta){
                rY[45] += mDt*d_dt_chaste_interface_var_Cl__Cl_ss;
            }
            else
            {
                rY[45] += (d_dt_chaste_interface_var_Cl__Cl_ss/mPartialF[45])*(exp(mPartialF[45]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[46]) < delta){
                rY[46] += mDt*d_dt_chaste_interface_var_K__K_i;
            }
            else
            {
                rY[46] += (d_dt_chaste_interface_var_K__K_i/mPartialF[46])*(exp(mPartialF[46]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[47]) < delta){
                rY[47] += mDt*d_dt_chaste_interface_var_CaMK_active__CaMK_trap;
            }
            else
            {
                rY[47] += (d_dt_chaste_interface_var_CaMK_active__CaMK_trap/mPartialF[47])*(exp(mPartialF[47]*mDt)-1.0);
            }
            
        }        
        
    }
   
    
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__Vm;
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__IKs__O1 = rY[17];
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = rY[18];
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        double var_chaste_interface__Irel__Irel = rY[37];
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = rY[43];
        // Units: mM; Initial value: 6.935607
        double var_chaste_interface__Cl__Cl_i = rY[44];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = rY[46];
        // Units: mM; Initial value: 145.5689
        
        
        // Mathematics
        const double var_IpCa__IpCa = 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i); // uA_per_uF
        const double var_membrane__i_Stim = GetIntracellularAreaStimulus(var_chaste_interface__environment__time) / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_ICaL__ICaL = 14448.603861345418 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss_CaL * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * mParameters[0] * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_ICab__ICab = 0.0028826178386108462 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_INaCa__INaCa = (6.4800000000000004 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 9878400.0 * var_chaste_interface__Ca__Ca_i * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_i)); // uA_per_uF
        const double var_INaCa__INaCa_ss_sr = (1.6200000000000001 * pow(var_chaste_interface__Na__Na_ss_sr, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 2469600.0 * var_chaste_interface__Ca__Ca_ss_sr * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_ss_sr, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_ss_sr, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr)); // uA_per_uF
        const double var_INaK__INaK = 0.062337970750628316 * pow(var_chaste_interface__Na__Na_i, 3) / (pow((1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i), 3) * (1.0 + exp(-3.4441726741524206 - 0.037436659501656748 * var_chaste_interface__membrane__Vm))); // uA_per_uF
        const double var_INab__INab = 1.1558883089076335e-5 * (-140.0 + var_chaste_interface__Na__Na_i * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_Ito2__Ito2 = 0.0032509358688027189 * (1.0 - 1.0 / (1.0 + 6.2499999999999991 * pow(var_chaste_interface__Irel__Irel, 2))) * (-100.0 * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2_i2f_gate__i2f * var_chaste_interface__membrane__Vm / (1.0 - exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_reversal_potentials__ECl = -26.711785007306684 * log(100.0 / var_chaste_interface__Cl__Cl_i); // mV
        const double var_IClb__IClb = 0.00022499999999999999 * var_chaste_interface__membrane__Vm - 0.00022499999999999999 * var_reversal_potentials__ECl; // uA_per_uF
        const double var_reversal_potentials__EK = 26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_IK1__IK1 = 0.51000000000000001 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)) + (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 0.080320000000000003 * var_reversal_potentials__EK) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 0.061749999999999999 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__membrane__Vm)))); // uA_per_uF
        const double var_IKp__IKp = 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_IKr__IKr = 1.0 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * mParameters[2] * var_chaste_interface__IKr_xr_gate__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_Ito1__Ito1 = 0.4975 * pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s * exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm); // uA_per_uF
        const double var_reversal_potentials__ENa = 26.711785007306684 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_INa__INa = pow(var_chaste_interface__INa_m_gate__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * mParameters[1] * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // uA_per_uF
        const double var_INaL__INaL = 0.0064999999999999997 * pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * var_chaste_interface__INaL_hL_gate__hL; // uA_per_uF
        const double var_IKs__IKs = (0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.711785007306684 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__membrane__Vm) * (var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2); // uA_per_uF
        d_dt_chaste_interface_var_membrane__Vm = -var_ICaL__ICaL - var_ICab__ICab - var_IClb__IClb - var_IK1__IK1 - var_IKp__IKp - var_IKr__IKr - var_IKs__IKs - var_INa__INa - var_INaL__INaL - var_INab__INab - var_IpCa__IpCa - var_Ito1__Ito1 - var_Ito2__Ito2 - var_membrane__i_Stim - 1.0 * var_INaCa__INaCa - 1.0 * var_INaCa__INaCa_ss_sr - 1.0 * var_INaK__INaK; // mV / ms

        return d_dt_chaste_interface_var_membrane__Vm;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative0(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_i = rY[1];
            // Units: mM; Initial value: 7.09945e-05
            double var_chaste_interface__IKs__O1 = rY[17];
            // Units: dimensionless; Initial value: 1.051906959485266e-05
            double var_chaste_interface__IKs__O2 = rY[18];
            // Units: dimensionless; Initial value: 2.372219883411999e-06
            double var_chaste_interface__ICaL__O = rY[20];
            // Units: dimensionless; Initial value: 2.27419494597377e-05
            double var_chaste_interface__ICaL__O_star = rY[22];
            // Units: dimensionless; Initial value: 1.350122566369778e-15
            double var_chaste_interface__INa_m_gate__m = rY[27];
            // Units: dimensionless; Initial value: 0.001022252813581797
            double var_chaste_interface__INa_h_gate__h = rY[28];
            // Units: dimensionless; Initial value: 0.9913109066867
            double var_chaste_interface__INa_j_gate__j = rY[29];
            // Units: dimensionless; Initial value: 0.9970771239754529
            double var_chaste_interface__INaL_mL_gate__mL = rY[30];
            // Units: dimensionless; Initial value: 0.001022252813581797
            double var_chaste_interface__INaL_hL_gate__hL = rY[31];
            // Units: dimensionless; Initial value: 0.3593255076983574
            double var_chaste_interface__IKr_xr_gate__xr = rY[32];
            // Units: dimensionless; Initial value: 1.235996442041028e-08
            double var_chaste_interface__Ito1_a_gate__a = rY[33];
            // Units: dimensionless; Initial value: 1.773318268499115e-05
            double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
            // Units: dimensionless; Initial value: 0.9979722
            double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
            // Units: dimensionless; Initial value: 0.9874435
            double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
            // Units: dimensionless; Initial value: 0.9960352
            double var_chaste_interface__Irel__Irel = rY[37];
            // Units: mM_per_ms; Initial value: 0.00107332
            double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
            // Units: mM; Initial value: 9.04757e-05
            double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
            // Units: mM; Initial value: 9.61545e-05
            double var_chaste_interface__Na__Na_i = rY[42];
            // Units: mM; Initial value: 6.935575
            double var_chaste_interface__Na__Na_ss_sr = rY[43];
            // Units: mM; Initial value: 6.935607
            double var_chaste_interface__Cl__Cl_i = rY[44];
            // Units: mM; Initial value: 20.26842
            double var_chaste_interface__K__K_i = rY[46];
            // Units: mM; Initial value: 145.5689
            
            const double var_x0 = exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm);
            const double var_x1 = 1.0 + var_x0;
            const double var_x2 = 1 / var_x1;
            const double var_x3 = 1 / var_chaste_interface__Ca__Ca_i;
            const double var_x4 = pow(var_x3, 1.3999999999999999);
            const double var_x5 = 1.0 + 6.4818210260626455e-7 * var_x4;
            const double var_x6 = 1 / var_x5;
            const double var_x7 = -0.082600000000000007 - 0.04956 * var_x6;
            const double var_x8 = var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2;
            const double var_x9 = var_x7 * var_x8;
            const double var_x10 = pow(var_chaste_interface__INaL_mL_gate__mL, 3);
            const double var_x11 = 0.0064999999999999997 * var_x10;
            const double var_x12 = 0.037436659501656748 * var_chaste_interface__membrane__Vm;
            const double var_x13 = exp(var_x12);
            const double var_x14 = -1.0 + var_x13;
            const double var_x15 = 1 / var_x14;
            const double var_x16 = var_x13 * var_chaste_interface__Na__Na_i;
            const double var_x17 = -140.0 + var_x16;
            const double var_x18 = var_x15 * var_x17;
            const double var_x19 = 1 / var_chaste_interface__K__K_i;
            const double var_x20 = log(5.4000000000000004 * var_x19);
            const double var_x21 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 6.3707607242426434 * var_x20);
            const double var_x22 = 1.0 + var_x21;
            const double var_x23 = 1 / var_x22;
            const double var_x24 = exp(-2.4444678999999998 + 13.737871029257827 * var_x20 - 0.51429999999999998 * var_chaste_interface__membrane__Vm);
            const double var_x25 = 1.0 + var_x24;
            const double var_x26 = 1 / var_x25;
            const double var_x27 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 2.1454905717868731 * var_x20);
            const double var_x28 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 1.6494527242011876 * var_x20);
            const double var_x29 = var_x28 + 0.49124000000000001 * var_x27;
            const double var_x30 = var_x26 * var_x29;
            const double var_x31 = 1 / (var_x30 + 1.02 * var_x23);
            const double var_x32 = var_x23 * var_x31;
            const double var_x33 = exp(0.074873319003313496 * var_chaste_interface__membrane__Vm);
            const double var_x34 = -1.0 + var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x36 = var_x33;
            const double var_x37 = -0.61380000000000001 + var_x36 * var_chaste_interface__Ca__Ca_i;
            const double var_x38 = var_x35 * var_x37;
            const double var_x39 = 26.711785007306684 * var_x20;
            const double var_x40 = -var_x39 + var_chaste_interface__membrane__Vm;
            const double var_x41 = var_x0 * var_x40 / pow(var_x1, 2);
            const double var_x42 = exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm);
            const double var_x43 = 1.0 + var_x42;
            const double var_x44 = mParameters[2] / var_x43;
            const double var_x45 = 1.0 * var_x44;
            const double var_x46 = pow(var_chaste_interface__INa_m_gate__m, 3);
            const double var_x47 = var_x46 * mParameters[1] * var_chaste_interface__INa_j_gate__j;
            const double var_x48 = var_x47 * var_chaste_interface__INa_h_gate__h;
            const double var_x49 = var_x33 * var_chaste_interface__membrane__Vm;
            const double var_x50 = var_x49 / pow(var_x34, 2);
            const double var_x51 = var_x37 * var_x50;
            const double var_x52 = var_x13 * var_chaste_interface__membrane__Vm;
            const double var_x53 = var_x17 * var_x52 / pow(var_x14, 2);
            const double var_x54 = var_x21 / pow(var_x22, 2);
            const double var_x55 = var_x31 * var_x40;
            const double var_x56 = var_x54 * var_x55;
            const double var_x57 = exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm);
            const double var_x58 = 1.0 + 0.32000000000000001 * var_x57;
            const double var_x59 = 1 / var_x58;
            const double var_x60 = var_x59;
            const double var_x61 = pow(var_chaste_interface__Na__Na_i, 3);
            const double var_x62 = exp(0.010107898065447322 * var_chaste_interface__membrane__Vm);
            const double var_x63 = var_x61 * var_x62;
            const double var_x64 = var_x57 * var_chaste_interface__Ca__Ca_i;
            const double var_x65 = 1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2);
            const double var_x66 = 1 / var_x65;
            const double var_x67 = 1 / (13227.9606 + 8.4084932990912282 * var_x61 + 4344355.375 * var_chaste_interface__Ca__Ca_i);
            const double var_x68 = var_x66 * var_x67;
            const double var_x69 = var_x68 * (0.065499179464098653 * var_x63 + 269964.43697145121 * var_x64);
            const double var_x70 = pow(var_chaste_interface__Na__Na_ss_sr, 3);
            const double var_x71 = var_x62 * var_x70;
            const double var_x72 = var_x57 * var_chaste_interface__Ca__Ca_ss_sr;
            const double var_x73 = pow(var_chaste_interface__Ca__Ca_ss_sr, (-2));
            const double var_x74 = 1.0 + 1.5624999999999999e-8 * var_x73;
            const double var_x75 = 1 / var_x74;
            const double var_x76 = 1 / (13227.9606 + 8.4084932990912282 * var_x70 + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr);
            const double var_x77 = var_x75 * var_x76;
            const double var_x78 = var_x77 * (0.016374794866024663 * var_x71 + 67491.109242862804 * var_x72);
            const double var_x79 = pow(var_chaste_interface__Ito1_a_gate__a, 3);
            const double var_x80 = exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm);
            const double var_x81 = var_x79 * var_x80 * var_chaste_interface__Ito1_i1s_gate__i1s;
            const double var_x82 = 0.4975 * var_x81;
            const double var_x83 = 1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i;
            const double var_x84 = pow(var_x83, (-3));
            const double var_x85 = exp(-3.4441726741524206 - var_x12);
            const double var_x86 = 1.0 + var_x85;
            const double var_x87 = var_x61 * var_x84 * var_x85 / pow(var_x86, 2);
            const double var_x88 = (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * mParameters[0];
            const double var_x89 = 14448.603861345418 * var_x88;
            const double var_x90 = -0.61380000000000001 + var_x36 * var_chaste_interface__Ca__Ca_ss_CaL;
            const double var_x91 = var_x35 * var_x90;
            const double var_x92 = var_x35 * var_x49;
            const double var_x93 = var_x92 * var_chaste_interface__Ca__Ca_i;
            const double var_x94 = var_x15 * var_x16 * var_chaste_interface__membrane__Vm;
            const double var_x95 = var_x24 * var_x29 / pow(var_x25, 2);
            const double var_x96 = 0.24326999999999999 * var_x54 - 0.51429999999999998 * var_x95 - var_x26 * (0.061749999999999999 * var_x28 + 0.039456396800000001 * var_x27);
            const double var_x97 = var_x23 * var_x40 / pow((var_x23 + 0.98039215686274506 * var_x30), 2);
            const double var_x98 = 0.49019607843137253 * var_x97;
            const double var_x99 = 1.0 - var_x13;
            const double var_x100 = 1 / var_x99;
            const double var_x101 = pow(var_chaste_interface__Irel__Irel, 2);
            const double var_x102 = 1.0 - 1.0 / (1.0 + 6.2499999999999991 * var_x101);
            const double var_x103 = -100.0 * var_x13 + var_chaste_interface__Cl__Cl_i;
            const double var_x104 = var_x100 * var_x102 * var_x103;
            const double var_x105 = 0.0032509358688027189 * var_x104;
            const double var_x106 = var_x102 * var_chaste_interface__Ito2_i2f_gate__i2f;
            const double var_x107 = var_x100 * var_x106;
            const double var_x108 = var_x107 * var_x52;
            const double var_x109 = var_x40 * var_x42 * mParameters[2] * var_chaste_interface__IKr_xr_gate__xr / pow(var_x43, 2);
            const double var_x110 = var_x40 * var_chaste_interface__Ito1_i1f_gate__i1f;
            const double var_x111 = var_x110 * var_x81;
            const double var_x112 = 6.4800000000000004 * var_x63 - 9878400.0 * var_x64;
            const double var_x113 = var_x112 * var_x68;
            const double var_x114 = var_x57 / pow(var_x58, 2);
            const double var_x115 = 0.0087452036595870152 * var_x114;
            const double var_x116 = 1.6200000000000001 * var_x71 - 2469600.0 * var_x72;
            const double var_x117 = var_x116 * var_x77;
            const double var_x118 = 1081.8149260630225 * var_x88;
            const double var_x119 = var_x50 * var_x90;
            const double var_x120 = var_x103 * var_x106 * var_x52 / pow(var_x99, 2);
            const double var_x121 = var_x92 * var_chaste_interface__Ca__Ca_ss_CaL;
            
            partialF = -0.00022499999999999999 + var_x9 - var_x48 + 0.012170417918209005 * var_x108 + 0.064935064935064929 * var_x109 + 0.00021583116499495196 * var_x51 + 4.3272597042520909e-7 * var_x53 + 0.12163499999999999 * var_x56 - 0.0027599999999999999 * var_x2 - 0.00012170417918209004 * var_x120 - 0.00233372538501551 * var_x87 - 1.1558883089076335e-5 * var_x18 - 0.00021583116499495196 * var_x93 - 4.3272597042520909e-7 * var_x94 - 0.00090454545454545453 * var_x111 - 0.51000000000000001 * var_x32 - 0.0028826178386108462 * var_x38 - 0.00046153846153846147 * var_x41 + var_x118 * var_x119 - var_x105 * var_chaste_interface__Ito2_i2f_gate__i2f - var_x11 * var_chaste_interface__INaL_hL_gate__hL - var_x113 * var_x115 - var_x115 * var_x117 - var_x118 * var_x121 - var_x45 * var_chaste_interface__IKr_xr_gate__xr - var_x60 * var_x69 - var_x60 * var_x78 - var_x82 * var_chaste_interface__Ito1_i1f_gate__i1f - var_x89 * var_x91 - var_x96 * var_x98;
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__Ca__Ca_NSR = rY[39];
        // Units: mM; Initial value: 0.929835335
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__CaMK_active__CaMK_trap = rY[47];
        // Units: dimensionless; Initial value: 0.0018861341
        
        
        // Mathematics
        const double var_Ca__Idiff = 5.0 * var_chaste_interface__Ca__Ca_ss_sr - 5.0 * var_chaste_interface__Ca__Ca_i; // mM_per_ms
        const double var_CaMK_active__CaMK_active = 0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap; // dimensionless
        const double var_Ileak__Ileak = 0.00029166666666666669 * var_chaste_interface__Ca__Ca_NSR; // mM_per_ms
        const double var_IpCa__IpCa = 0.057500000000000002 * var_chaste_interface__Ca__Ca_i / (0.00050000000000000001 + var_chaste_interface__Ca__Ca_i); // uA_per_uF
        const double var_Iup__Iup = 0.0043750000000000004 * (1.0 + 0.75 * var_CaMK_active__CaMK_active / (0.14999999999999999 + var_CaMK_active__CaMK_active)) * var_chaste_interface__Ca__Ca_i / (0.00092000000000000003 - 0.00017000000000000001 * var_CaMK_active__CaMK_active / (0.14999999999999999 + var_CaMK_active__CaMK_active) + var_chaste_interface__Ca__Ca_i); // mM_per_ms
        const double var_cell_geometry__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell_geometry__Vmyo = 0.67800000000000005 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vnsr = 0.055199999999999999 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vss_CaL = 0.002 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__AF = 5.0618217998279567e-10 * M_PI; // uF_mole_per_C
        const double var_ICab__ICab = 0.0028826178386108462 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_i * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_INaCa__INaCa = (6.4800000000000004 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 9878400.0 * var_chaste_interface__Ca__Ca_i * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_i)); // uA_per_uF
        const double d_dt_chaste_interface_var_Ca__Ca_i = ((-var_Iup__Iup + var_Ileak__Ileak) * var_cell_geometry__Vnsr / var_cell_geometry__Vmyo + var_Ca__Idiff * var_cell_geometry__Vss_CaL / var_cell_geometry__Vmyo + 0.5 * (-var_ICab__ICab - var_IpCa__IpCa + 2.0 * var_INaCa__INaCa) * var_cell_geometry__AF / var_cell_geometry__Vmyo) / (1.0 + 0.00011900000000000002 / pow((0.0023800000000000002 + var_chaste_interface__Ca__Ca_i), 2) + 3.5000000000000004e-5 / pow((0.00050000000000000001 + var_chaste_interface__Ca__Ca_i), 2)); // mM / ms

        return d_dt_chaste_interface_var_Ca__Ca_i;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative1(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_i = rY[1];
            // Units: mM; Initial value: 7.09945e-05
            double var_chaste_interface__Ca__Ca_NSR = rY[39];
            // Units: mM; Initial value: 0.929835335
            double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
            // Units: mM; Initial value: 9.04757e-05
            double var_chaste_interface__Na__Na_i = rY[42];
            // Units: mM; Initial value: 6.935575
            double var_chaste_interface__CaMK_active__CaMK_trap = rY[47];
            // Units: dimensionless; Initial value: 0.0018861341
            
            const double var_x33 = exp(0.074873319003313496 * var_chaste_interface__membrane__Vm);
            const double var_x34 = -1.0 + var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x36 = var_x33;
            const double var_x37 = -0.61380000000000001 + var_x36 * var_chaste_interface__Ca__Ca_i;
            const double var_x38 = var_x35 * var_x37;
            const double var_x49 = var_x33 * var_chaste_interface__membrane__Vm;
            const double var_x57 = exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm);
            const double var_x58 = 1.0 + 0.32000000000000001 * var_x57;
            const double var_x59 = 1 / var_x58;
            const double var_x61 = pow(var_chaste_interface__Na__Na_i, 3);
            const double var_x62 = exp(0.010107898065447322 * var_chaste_interface__membrane__Vm);
            const double var_x63 = var_x61 * var_x62;
            const double var_x64 = var_x57 * var_chaste_interface__Ca__Ca_i;
            const double var_x65 = 1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2);
            const double var_x66 = 1 / var_x65;
            const double var_x67 = 1 / (13227.9606 + 8.4084932990912282 * var_x61 + 4344355.375 * var_chaste_interface__Ca__Ca_i);
            const double var_x68 = var_x66 * var_x67;
            const double var_x92 = var_x35 * var_x49;
            const double var_x112 = 6.4800000000000004 * var_x63 - 9878400.0 * var_x64;
            const double var_x113 = var_x112 * var_x68;
            const double var_x122 = 0.00050000000000000001 + var_chaste_interface__Ca__Ca_i;
            const double var_x123 = 1 / var_x122;
            const double var_x124 = pow(var_x122, (-2));
            const double var_x125 = var_x124 * var_chaste_interface__Ca__Ca_i;
            const double var_x126 = var_x57 * var_x59;
            const double var_x127 = var_x126 * var_x68;
            const double var_x129 = var_x112 * var_x66 / pow((0.0030448615405916234 + 1.9354984970793804e-6 * var_x61 + var_chaste_interface__Ca__Ca_i), 2);
            const double var_x131 = var_x112 * var_x67 / (pow(var_x65, 2) * pow(var_chaste_interface__Ca__Ca_i, 3));
            const double var_x162 = var_x129 * var_x59;
            const double var_x180 = 8.8930116629204303e-8 * var_x38;
            const double var_x181 = 6.1700941025231664e-5 * var_x59;
            const double var_x183 = 0.0023800000000000002 + var_chaste_interface__Ca__Ca_i;
            const double var_x184 = 1.0 + 0.00011900000000000002 / pow(var_x183, 2) + 3.5000000000000004e-5 * var_x124;
            const double var_x185 = 1 / var_x184;
            const double var_x186 = var_x185;
            const double var_x187 = 1.7739020544754105e-6 * var_x123;
            const double var_x188 = 1.0 - var_chaste_interface__CaMK_active__CaMK_trap;
            const double var_x189 = 1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr;
            const double var_x190 = 1 / var_x189;
            const double var_x191 = 0.050000000000000003 * var_x190;
            const double var_x192 = var_x188 * var_x191;
            const double var_x193 = 0.14999999999999999 + var_x192 + var_chaste_interface__CaMK_active__CaMK_trap;
            const double var_x194 = 1 / var_x193;
            const double var_x195 = var_x192 + var_chaste_interface__CaMK_active__CaMK_trap;
            const double var_x196 = var_x194 * var_x195;
            const double var_x197 = 0.00092000000000000003 - 0.00017000000000000001 * var_x196 + var_chaste_interface__Ca__Ca_i;
            const double var_x198 = 1 / var_x197;
            const double var_x199 = 1.0 + 0.75 * var_x196;
            const double var_x200 = var_x198 * var_x199;
            const double var_x201 = 0.00035619469026548675 * var_x200;
            const double var_x202 = 0.00035619469026548675 * var_chaste_interface__Ca__Ca_i;
            const double var_x203 = var_x199 / pow(var_x197, 2);
            const double var_x204 = var_x202 * var_x203;
            const double var_x205 = var_x131 * var_x59;
            
            partialF = var_x186 * (-0.014749262536873154 + var_x204 - var_x187 - var_x201 + 1.9281544070384897e-12 * var_x205 + 1.7739020544754105e-6 * var_x125 - 609.50657582364852 * var_x127 - 1.4202553819674954e-11 * var_x162 - 8.8930116629204303e-8 * var_x92) + (0.00023800000000000004 / pow(var_x183, 3) + 7.0000000000000007e-5 / pow(var_x122, 3)) * (2.3746312684365782e-5 * var_chaste_interface__Ca__Ca_NSR + 0.014749262536873154 * var_chaste_interface__Ca__Ca_ss_sr - 0.014749262536873154 * var_chaste_interface__Ca__Ca_i + var_x113 * var_x181 - var_x180 * var_chaste_interface__membrane__Vm - var_x187 * var_chaste_interface__Ca__Ca_i - var_x201 * var_chaste_interface__Ca__Ca_i) / pow(var_x184, 2);
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C1 = rY[2];
        // Units: dimensionless; Initial value: 0.476653873938053
        double var_chaste_interface__IKs__C2 = rY[3];
        // Units: dimensionless; Initial value: 0.2551771850026437
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C1 = var_chaste_interface__IKs__C2 * var_IKs__beta - 4.0 * var_chaste_interface__IKs__C1 * var_IKs__alpha; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C1;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative2(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x218 = exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm);
            const double var_x222 = 0.059456000000000002 * var_x218;
            
            partialF = -var_x222;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C1 = rY[2];
        // Units: dimensionless; Initial value: 0.476653873938053
        double var_chaste_interface__IKs__C2 = rY[3];
        // Units: dimensionless; Initial value: 0.2551771850026437
        double var_chaste_interface__IKs__C3 = rY[4];
        // Units: dimensionless; Initial value: 0.05122852186842027
        double var_chaste_interface__IKs__C6 = rY[7];
        // Units: dimensionless; Initial value: 0.1328281770413747
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C2 = (-var_IKs__beta - var_IKs__gamma - 3.0 * var_IKs__alpha) * var_chaste_interface__IKs__C2 + var_chaste_interface__IKs__C6 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C3 * var_IKs__beta + 4.0 * var_chaste_interface__IKs__C1 * var_IKs__alpha; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C2;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative3(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x218 = exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm);
            const double var_x220 = exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm);
            const double var_x223 = 0.083986000000000005 * var_x220;
            const double var_x226 = exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm);
            const double var_x232 = 0.044592 * var_x218;
            const double var_x233 = -var_x232;
            const double var_x234 = 0.014600999999999999 * var_x226;
            const double var_x235 = -var_x223 - var_x234;
            
            partialF = var_x233 + var_x235;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C2 = rY[3];
        // Units: dimensionless; Initial value: 0.2551771850026437
        double var_chaste_interface__IKs__C3 = rY[4];
        // Units: dimensionless; Initial value: 0.05122852186842027
        double var_chaste_interface__IKs__C4 = rY[5];
        // Units: dimensionless; Initial value: 0.004570874421666423
        double var_chaste_interface__IKs__C7 = rY[8];
        // Units: dimensionless; Initial value: 0.05333228495514583
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C3 = (-2.0 * var_IKs__alpha - 2.0 * var_IKs__beta - 2.0 * var_IKs__gamma) * var_chaste_interface__IKs__C3 + var_chaste_interface__IKs__C7 * var_IKs__delta + 3.0 * var_chaste_interface__IKs__C2 * var_IKs__alpha + 3.0 * var_chaste_interface__IKs__C4 * var_IKs__beta; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C3;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative4(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x218 = exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm);
            const double var_x220 = exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm);
            const double var_x226 = exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm);
            const double var_x236 = 0.16797200000000001 * var_x220;
            const double var_x243 = 0.029728000000000001 * var_x218;
            const double var_x244 = -var_x243;
            const double var_x245 = 0.029201999999999999 * var_x226;
            const double var_x246 = -var_x236 - var_x245;
            
            partialF = var_x244 + var_x246;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C3 = rY[4];
        // Units: dimensionless; Initial value: 0.05122852186842027
        double var_chaste_interface__IKs__C4 = rY[5];
        // Units: dimensionless; Initial value: 0.004570874421666423
        double var_chaste_interface__IKs__C5 = rY[6];
        // Units: dimensionless; Initial value: 0.0001529389211563687
        double var_chaste_interface__IKs__C8 = rY[9];
        // Units: dimensionless; Initial value: 0.007137874613383642
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C4 = (-var_IKs__alpha - 3.0 * var_IKs__beta - 3.0 * var_IKs__gamma) * var_chaste_interface__IKs__C4 + var_chaste_interface__IKs__C8 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C3 * var_IKs__alpha + 4.0 * var_chaste_interface__IKs__C5 * var_IKs__beta; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C4;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative5(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x218 = exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm);
            const double var_x220 = exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm);
            const double var_x226 = exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm);
            const double var_x247 = 0.25195800000000002 * var_x220;
            const double var_x253 = 0.014864 * var_x218;
            const double var_x254 = -var_x253;
            const double var_x255 = 0.043802999999999995 * var_x226;
            const double var_x256 = -var_x247 - var_x255;
            
            partialF = var_x254 + var_x256;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C4 = rY[5];
        // Units: dimensionless; Initial value: 0.004570874421666423
        double var_chaste_interface__IKs__C5 = rY[6];
        // Units: dimensionless; Initial value: 0.0001529389211563687
        double var_chaste_interface__IKs__C9 = rY[10];
        // Units: dimensionless; Initial value: 0.0003184390970637536
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C5 = (-4.0 * var_IKs__beta - 4.0 * var_IKs__gamma) * var_chaste_interface__IKs__C5 + var_chaste_interface__IKs__C4 * var_IKs__alpha + var_chaste_interface__IKs__C9 * var_IKs__delta; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C5;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative6(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x220 = exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm);
            const double var_x226 = exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm);
            const double var_x257 = 0.33594400000000002 * var_x220;
            const double var_x259 = 0.058403999999999998 * var_x226;
            
            partialF = -var_x257 - var_x259;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C2 = rY[3];
        // Units: dimensionless; Initial value: 0.2551771850026437
        double var_chaste_interface__IKs__C6 = rY[7];
        // Units: dimensionless; Initial value: 0.1328281770413747
        double var_chaste_interface__IKs__C7 = rY[8];
        // Units: dimensionless; Initial value: 0.05333228495514583
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C6 = (-var_IKs__delta - 3.0 * var_IKs__alpha) * var_chaste_interface__IKs__C6 + var_chaste_interface__IKs__C2 * var_IKs__gamma + var_chaste_interface__IKs__C7 * var_IKs__beta; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C6;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative7(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x218 = exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm);
            const double var_x229 = exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm);
            const double var_x232 = 0.044592 * var_x218;
            const double var_x233 = -var_x232;
            const double var_x237 = 0.0031172999999999999 * var_x229;
            const double var_x260 = -var_x237;
            
            partialF = var_x233 + var_x260;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C3 = rY[4];
        // Units: dimensionless; Initial value: 0.05122852186842027
        double var_chaste_interface__IKs__C6 = rY[7];
        // Units: dimensionless; Initial value: 0.1328281770413747
        double var_chaste_interface__IKs__C7 = rY[8];
        // Units: dimensionless; Initial value: 0.05333228495514583
        double var_chaste_interface__IKs__C8 = rY[9];
        // Units: dimensionless; Initial value: 0.007137874613383642
        double var_chaste_interface__IKs__C10 = rY[11];
        // Units: dimensionless; Initial value: 0.01388061042363991
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C7 = (-var_IKs__beta - var_IKs__delta - var_IKs__gamma - 2.0 * var_IKs__alpha) * var_chaste_interface__IKs__C7 + 2.0 * var_chaste_interface__IKs__C10 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C3 * var_IKs__gamma + 2.0 * var_chaste_interface__IKs__C8 * var_IKs__beta + 3.0 * var_chaste_interface__IKs__C6 * var_IKs__alpha; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C7;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative8(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x218 = exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm);
            const double var_x220 = exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm);
            const double var_x223 = 0.083986000000000005 * var_x220;
            const double var_x226 = exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm);
            const double var_x229 = exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm);
            const double var_x234 = 0.014600999999999999 * var_x226;
            const double var_x235 = -var_x223 - var_x234;
            const double var_x237 = 0.0031172999999999999 * var_x229;
            const double var_x243 = 0.029728000000000001 * var_x218;
            const double var_x244 = -var_x243;
            const double var_x260 = -var_x237;
            
            partialF = var_x235 + var_x244 + var_x260;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C4 = rY[5];
        // Units: dimensionless; Initial value: 0.004570874421666423
        double var_chaste_interface__IKs__C7 = rY[8];
        // Units: dimensionless; Initial value: 0.05333228495514583
        double var_chaste_interface__IKs__C8 = rY[9];
        // Units: dimensionless; Initial value: 0.007137874613383642
        double var_chaste_interface__IKs__C9 = rY[10];
        // Units: dimensionless; Initial value: 0.0003184390970637536
        double var_chaste_interface__IKs__C11 = rY[12];
        // Units: dimensionless; Initial value: 0.003715500164470033
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C8 = (-var_IKs__alpha - var_IKs__delta - 2.0 * var_IKs__beta - 2.0 * var_IKs__gamma) * var_chaste_interface__IKs__C8 + 2.0 * var_chaste_interface__IKs__C11 * var_IKs__delta + 2.0 * var_chaste_interface__IKs__C7 * var_IKs__alpha + 3.0 * var_chaste_interface__IKs__C4 * var_IKs__gamma + 3.0 * var_chaste_interface__IKs__C9 * var_IKs__beta; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C8;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative9(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x218 = exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm);
            const double var_x220 = exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm);
            const double var_x226 = exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm);
            const double var_x229 = exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm);
            const double var_x236 = 0.16797200000000001 * var_x220;
            const double var_x237 = 0.0031172999999999999 * var_x229;
            const double var_x245 = 0.029201999999999999 * var_x226;
            const double var_x246 = -var_x236 - var_x245;
            const double var_x253 = 0.014864 * var_x218;
            const double var_x254 = -var_x253;
            const double var_x260 = -var_x237;
            
            partialF = var_x246 + var_x254 + var_x260;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C5 = rY[6];
        // Units: dimensionless; Initial value: 0.0001529389211563687
        double var_chaste_interface__IKs__C8 = rY[9];
        // Units: dimensionless; Initial value: 0.007137874613383642
        double var_chaste_interface__IKs__C9 = rY[10];
        // Units: dimensionless; Initial value: 0.0003184390970637536
        double var_chaste_interface__IKs__C12 = rY[13];
        // Units: dimensionless; Initial value: 0.0002486371465457659
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C9 = (-var_IKs__delta - 3.0 * var_IKs__beta - 3.0 * var_IKs__gamma) * var_chaste_interface__IKs__C9 + var_chaste_interface__IKs__C8 * var_IKs__alpha + 2.0 * var_chaste_interface__IKs__C12 * var_IKs__delta + 4.0 * var_chaste_interface__IKs__C5 * var_IKs__gamma; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C9;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative10(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x220 = exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm);
            const double var_x226 = exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm);
            const double var_x229 = exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm);
            const double var_x237 = 0.0031172999999999999 * var_x229;
            const double var_x247 = 0.25195800000000002 * var_x220;
            const double var_x255 = 0.043802999999999995 * var_x226;
            const double var_x256 = -var_x247 - var_x255;
            const double var_x260 = -var_x237;
            
            partialF = var_x256 + var_x260;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C7 = rY[8];
        // Units: dimensionless; Initial value: 0.05333228495514583
        double var_chaste_interface__IKs__C10 = rY[11];
        // Units: dimensionless; Initial value: 0.01388061042363991
        double var_chaste_interface__IKs__C11 = rY[12];
        // Units: dimensionless; Initial value: 0.003715500164470033
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C10 = (-2.0 * var_IKs__alpha - 2.0 * var_IKs__delta) * var_chaste_interface__IKs__C10 + var_chaste_interface__IKs__C11 * var_IKs__beta + var_chaste_interface__IKs__C7 * var_IKs__gamma; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C10;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative11(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x218 = exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm);
            const double var_x229 = exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm);
            const double var_x243 = 0.029728000000000001 * var_x218;
            const double var_x244 = -var_x243;
            const double var_x262 = 0.0062345999999999999 * var_x229;
            const double var_x263 = -var_x262;
            
            partialF = var_x244 + var_x263;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C8 = rY[9];
        // Units: dimensionless; Initial value: 0.007137874613383642
        double var_chaste_interface__IKs__C10 = rY[11];
        // Units: dimensionless; Initial value: 0.01388061042363991
        double var_chaste_interface__IKs__C11 = rY[12];
        // Units: dimensionless; Initial value: 0.003715500164470033
        double var_chaste_interface__IKs__C12 = rY[13];
        // Units: dimensionless; Initial value: 0.0002486371465457659
        double var_chaste_interface__IKs__C13 = rY[14];
        // Units: dimensionless; Initial value: 0.0006446803014431032
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C11 = (-var_IKs__alpha - var_IKs__beta - var_IKs__gamma - 2.0 * var_IKs__delta) * var_chaste_interface__IKs__C11 + 2.0 * var_chaste_interface__IKs__C10 * var_IKs__alpha + 2.0 * var_chaste_interface__IKs__C12 * var_IKs__beta + 2.0 * var_chaste_interface__IKs__C8 * var_IKs__gamma + 3.0 * var_chaste_interface__IKs__C13 * var_IKs__delta; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C11;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative12(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x218 = exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm);
            const double var_x220 = exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm);
            const double var_x223 = 0.083986000000000005 * var_x220;
            const double var_x226 = exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm);
            const double var_x229 = exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm);
            const double var_x234 = 0.014600999999999999 * var_x226;
            const double var_x235 = -var_x223 - var_x234;
            const double var_x253 = 0.014864 * var_x218;
            const double var_x254 = -var_x253;
            const double var_x262 = 0.0062345999999999999 * var_x229;
            const double var_x263 = -var_x262;
            
            partialF = var_x235 + var_x254 + var_x263;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C9 = rY[10];
        // Units: dimensionless; Initial value: 0.0003184390970637536
        double var_chaste_interface__IKs__C11 = rY[12];
        // Units: dimensionless; Initial value: 0.003715500164470033
        double var_chaste_interface__IKs__C12 = rY[13];
        // Units: dimensionless; Initial value: 0.0002486371465457659
        double var_chaste_interface__IKs__C14 = rY[15];
        // Units: dimensionless; Initial value: 8.628258026770862e-05
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C12 = (-2.0 * var_IKs__beta - 2.0 * var_IKs__delta - 2.0 * var_IKs__gamma) * var_chaste_interface__IKs__C12 + var_chaste_interface__IKs__C11 * var_IKs__alpha + 3.0 * var_chaste_interface__IKs__C14 * var_IKs__delta + 3.0 * var_chaste_interface__IKs__C9 * var_IKs__gamma; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C12;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative13(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x220 = exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm);
            const double var_x226 = exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm);
            const double var_x229 = exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm);
            const double var_x236 = 0.16797200000000001 * var_x220;
            const double var_x245 = 0.029201999999999999 * var_x226;
            const double var_x246 = -var_x236 - var_x245;
            const double var_x262 = 0.0062345999999999999 * var_x229;
            const double var_x263 = -var_x262;
            
            partialF = var_x246 + var_x263;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C11 = rY[12];
        // Units: dimensionless; Initial value: 0.003715500164470033
        double var_chaste_interface__IKs__C13 = rY[14];
        // Units: dimensionless; Initial value: 0.0006446803014431032
        double var_chaste_interface__IKs__C14 = rY[15];
        // Units: dimensionless; Initial value: 8.628258026770862e-05
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C13 = (-var_IKs__alpha - 3.0 * var_IKs__delta) * var_chaste_interface__IKs__C13 + var_chaste_interface__IKs__C11 * var_IKs__gamma + var_chaste_interface__IKs__C14 * var_IKs__beta; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C13;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative14(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x218 = exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm);
            const double var_x229 = exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm);
            const double var_x253 = 0.014864 * var_x218;
            const double var_x254 = -var_x253;
            const double var_x265 = 0.0093518999999999998 * var_x229;
            const double var_x266 = -var_x265;
            
            partialF = var_x254 + var_x266;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C12 = rY[13];
        // Units: dimensionless; Initial value: 0.0002486371465457659
        double var_chaste_interface__IKs__C13 = rY[14];
        // Units: dimensionless; Initial value: 0.0006446803014431032
        double var_chaste_interface__IKs__C14 = rY[15];
        // Units: dimensionless; Initial value: 8.628258026770862e-05
        double var_chaste_interface__IKs__C15 = rY[16];
        // Units: dimensionless; Initial value: 1.122823524761588e-05
        
        
        // Mathematics
        const double var_IKs__alpha = 0.014864 * exp(0.0011184950759309986 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__beta = 0.083986000000000005 * exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C14 = (-var_IKs__beta - var_IKs__gamma - 3.0 * var_IKs__delta) * var_chaste_interface__IKs__C14 + var_chaste_interface__IKs__C13 * var_IKs__alpha + 2.0 * var_chaste_interface__IKs__C12 * var_IKs__gamma + 4.0 * var_chaste_interface__IKs__C15 * var_IKs__delta; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C14;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative15(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x220 = exp(-0.0020762745726213851 * var_chaste_interface__membrane__Vm);
            const double var_x223 = 0.083986000000000005 * var_x220;
            const double var_x226 = exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm);
            const double var_x229 = exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm);
            const double var_x234 = 0.014600999999999999 * var_x226;
            const double var_x235 = -var_x223 - var_x234;
            const double var_x265 = 0.0093518999999999998 * var_x229;
            const double var_x266 = -var_x265;
            
            partialF = var_x235 + var_x266;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C14 = rY[15];
        // Units: dimensionless; Initial value: 8.628258026770862e-05
        double var_chaste_interface__IKs__C15 = rY[16];
        // Units: dimensionless; Initial value: 1.122823524761588e-05
        double var_chaste_interface__IKs__O1 = rY[17];
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        
        
        // Mathematics
        const double var_IKs__delta = 0.0031172999999999999 * exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__eta = 0.07732 * exp(-0.0024231252229042349 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__gamma = 0.014600999999999999 * exp(0.0091588787470803235 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__C15 = (-0.089538000000000006 - 4.0 * var_IKs__delta) * var_chaste_interface__IKs__C15 + var_chaste_interface__IKs__C14 * var_IKs__gamma + var_chaste_interface__IKs__O1 * var_IKs__eta; // 1 / ms

        return d_dt_chaste_interface_var_IKs__C15;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative16(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x229 = exp(-0.01595737611258119 * var_chaste_interface__membrane__Vm);
            const double var_x268 = 0.0124692 * var_x229;
            
            partialF = -0.089538000000000006 - var_x268;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__C15 = rY[16];
        // Units: dimensionless; Initial value: 1.122823524761588e-05
        double var_chaste_interface__IKs__O1 = rY[17];
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = rY[18];
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        
        
        // Mathematics
        const double var_IKs__eta = 0.07732 * exp(-0.0024231252229042349 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__omega = 0.79405000000000003 * exp(-0.003001446738885828 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__psi = 0.58638000000000001 * exp(0.0105593841790373 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__O1 = 0.089538000000000006 * var_chaste_interface__IKs__C15 + (-var_IKs__eta - var_IKs__psi) * var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2 * var_IKs__omega; // 1 / ms

        return d_dt_chaste_interface_var_IKs__O1;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative17(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x269 = exp(-0.0024231252229042349 * var_chaste_interface__membrane__Vm);
            const double var_x271 = 0.07732 * var_x269;
            const double var_x272 = exp(0.0105593841790373 * var_chaste_interface__membrane__Vm);
            const double var_x276 = 0.58638000000000001 * var_x272;
            
            partialF = -var_x271 - var_x276;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKs__O1 = rY[17];
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = rY[18];
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        
        
        // Mathematics
        const double var_IKs__omega = 0.79405000000000003 * exp(-0.003001446738885828 * var_chaste_interface__membrane__Vm); // per_ms
        const double var_IKs__psi = 0.58638000000000001 * exp(0.0105593841790373 * var_chaste_interface__membrane__Vm); // per_ms
        const double d_dt_chaste_interface_var_IKs__O2 = var_chaste_interface__IKs__O1 * var_IKs__psi - var_chaste_interface__IKs__O2 * var_IKs__omega; // 1 / ms

        return d_dt_chaste_interface_var_IKs__O2;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative18(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x274 = exp(-0.003001446738885828 * var_chaste_interface__membrane__Vm);
            const double var_x277 = 0.79405000000000003 * var_x274;
            
            partialF = -var_x277;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__ICaL__C = rY[19];
        // Units: dimensionless; Initial value: 0.9999613782488198
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__C_star = rY[21];
        // Units: dimensionless; Initial value: 5.936477396599124e-11
        double var_chaste_interface__ICaL__CI = rY[23];
        // Units: dimensionless; Initial value: 1.587938121237188e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        
        
        // Mathematics
        const double var_ICaL__delta = 3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // per_ms
        const double var_ICaL__ACT_infinity = 1 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__ACT_tau = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)); // ms
        const double var_ICaL__IV_infinity = 0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_tau = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))); // ms
        const double var_ICaL__alpha = var_ICaL__ACT_infinity / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__ACT_infinity) / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__x = var_ICaL__IV_infinity / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__y = (1.0 - var_ICaL__IV_infinity) / var_ICaL__IV_tau; // per_ms
        const double d_dt_chaste_interface_var_ICaL__C = var_chaste_interface__ICaL__C_star + (-var_ICaL__alpha - var_ICaL__delta - var_ICaL__y) * var_chaste_interface__ICaL__C + var_chaste_interface__ICaL__CI * var_ICaL__x + var_chaste_interface__ICaL__O * var_ICaL__beta; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__C;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative19(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
            // Units: mM; Initial value: 9.61545e-05
            
            const double var_x278 = exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm);
            const double var_x279 = 1.0 + var_x278;
            const double var_x280 = 1 / var_x279;
            const double var_x281 = 0.80000000000000004 * var_x280;
            const double var_x282 = exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm);
            const double var_x283 = 1.0 + var_x282;
            const double var_x285 = exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm);
            const double var_x286 = 1.0 + var_x285;
            const double var_x289 = 0.040277106492669565 / var_x286;
            const double var_x290 = 1 / var_x283;
            const double var_x291 = var_x289 + 0.032730010146303147 * var_x290;
            const double var_x295 = exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm);
            const double var_x296 = 1.0 + var_x295;
            const double var_x297 = exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x298 = 1.0 + var_x297;
            const double var_x299 = exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm);
            const double var_x300 = var_x299 / var_x298;
            const double var_x301 = 1 / (0.58999999999999997 + 0.80000000000000004 * var_x300);
            const double var_x303 = 1 / var_x296;
            const double var_x309 = var_x303;
            const double var_x312 = var_x301 * var_x309;
            const double var_x313 = -var_x312;
            const double var_x314 = 1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4);
            const double var_x315 = 1 / var_x314;
            const double var_x316 = 3.0 * var_x315;
            const double var_x317 = -var_x281;
            const double var_x318 = 0.80000000000000004 + var_x317;
            const double var_x319 = var_x291 * var_x318;
            const double var_x320 = -var_x316 - var_x319;
            
            partialF = var_x313 + var_x320;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__ICaL__C = rY[19];
        // Units: dimensionless; Initial value: 0.9999613782488198
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__ICaL__OI = rY[24];
        // Units: dimensionless; Initial value: 3.611420243201921e-10
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        
        
        // Mathematics
        const double var_ICaL__delta = 3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // per_ms
        const double var_ICaL__ACT_infinity = 1 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__ACT_tau = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)); // ms
        const double var_ICaL__IV_infinity = 0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_tau = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))); // ms
        const double var_ICaL__alpha = var_ICaL__ACT_infinity / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__ACT_infinity) / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__x = var_ICaL__IV_infinity / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__y = (1.0 - var_ICaL__IV_infinity) / var_ICaL__IV_tau; // per_ms
        const double d_dt_chaste_interface_var_ICaL__O = var_chaste_interface__ICaL__O_star + (-var_ICaL__beta - var_ICaL__delta - var_ICaL__y) * var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__C * var_ICaL__alpha + var_chaste_interface__ICaL__OI * var_ICaL__x; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__O;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative20(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
            // Units: mM; Initial value: 9.61545e-05
            
            const double var_x278 = exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm);
            const double var_x279 = 1.0 + var_x278;
            const double var_x280 = 1 / var_x279;
            const double var_x281 = 0.80000000000000004 * var_x280;
            const double var_x282 = exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm);
            const double var_x283 = 1.0 + var_x282;
            const double var_x285 = exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm);
            const double var_x286 = 1.0 + var_x285;
            const double var_x289 = 0.040277106492669565 / var_x286;
            const double var_x290 = 1 / var_x283;
            const double var_x291 = var_x289 + 0.032730010146303147 * var_x290;
            const double var_x295 = exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm);
            const double var_x296 = 1.0 + var_x295;
            const double var_x297 = exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x298 = 1.0 + var_x297;
            const double var_x299 = exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm);
            const double var_x300 = var_x299 / var_x298;
            const double var_x301 = 1 / (0.58999999999999997 + 0.80000000000000004 * var_x300);
            const double var_x303 = 1 / var_x296;
            const double var_x309 = var_x303;
            const double var_x310 = 1.0 - var_x309;
            const double var_x314 = 1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4);
            const double var_x315 = 1 / var_x314;
            const double var_x316 = 3.0 * var_x315;
            const double var_x317 = -var_x281;
            const double var_x318 = 0.80000000000000004 + var_x317;
            const double var_x319 = var_x291 * var_x318;
            const double var_x320 = -var_x316 - var_x319;
            const double var_x321 = var_x301 * var_x310;
            const double var_x327 = -var_x321;
            
            partialF = var_x320 + var_x327;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__ICaL__C = rY[19];
        // Units: dimensionless; Initial value: 0.9999613782488198
        double var_chaste_interface__ICaL__C_star = rY[21];
        // Units: dimensionless; Initial value: 5.936477396599124e-11
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__ICaL__CI_star = rY[25];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        
        
        // Mathematics
        const double var_ICaL__delta = 3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // per_ms
        const double var_ICaL__ACT_infinity = 1 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__ACT_tau = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)); // ms
        const double var_ICaL__IV_infinity_star = 9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_tau_star = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))); // ms
        const double var_ICaL__alpha = var_ICaL__ACT_infinity / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__ACT_infinity) / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__x_star = var_ICaL__IV_infinity_star / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__y_star = (1.0 - var_ICaL__IV_infinity_star) / var_ICaL__IV_tau_star; // per_ms
        const double d_dt_chaste_interface_var_ICaL__C_star = (-1.0 - var_ICaL__alpha - var_ICaL__y_star) * var_chaste_interface__ICaL__C_star + var_chaste_interface__ICaL__C * var_ICaL__delta + var_chaste_interface__ICaL__CI_star * var_ICaL__x_star + var_chaste_interface__ICaL__O_star * var_ICaL__beta; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__C_star;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative21(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
            // Units: mM; Initial value: 9.61545e-05
            
            const double var_x278 = exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm);
            const double var_x279 = 1.0 + var_x278;
            const double var_x280 = 1 / var_x279;
            const double var_x282 = exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm);
            const double var_x283 = 1.0 + var_x282;
            const double var_x285 = exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm);
            const double var_x286 = 1.0 + var_x285;
            const double var_x289 = 0.040277106492669565 / var_x286;
            const double var_x290 = 1 / var_x283;
            const double var_x295 = exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm);
            const double var_x296 = 1.0 + var_x295;
            const double var_x297 = exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x298 = 1.0 + var_x297;
            const double var_x299 = exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm);
            const double var_x300 = var_x299 / var_x298;
            const double var_x301 = 1 / (0.58999999999999997 + 0.80000000000000004 * var_x300);
            const double var_x303 = 1 / var_x296;
            const double var_x309 = var_x303;
            const double var_x312 = var_x301 * var_x309;
            const double var_x313 = -var_x312;
            const double var_x314 = 1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4);
            const double var_x315 = 1 / var_x314;
            const double var_x329 = 0.99990000999900008 * var_x280;
            const double var_x331 = 1 / (25.0 - 17.5 * var_x315);
            const double var_x333 = var_x289 + var_x290 * var_x331;
            const double var_x338 = -var_x329;
            const double var_x339 = 0.99990000999900008 + var_x338;
            const double var_x340 = var_x333 * var_x339;
            const double var_x341 = -1.0 - var_x340;
            
            partialF = var_x313 + var_x341;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__C_star = rY[21];
        // Units: dimensionless; Initial value: 5.936477396599124e-11
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__ICaL__OI_star = rY[26];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        
        
        // Mathematics
        const double var_ICaL__delta = 3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // per_ms
        const double var_ICaL__ACT_infinity = 1 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__ACT_tau = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)); // ms
        const double var_ICaL__IV_infinity_star = 9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_tau_star = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))); // ms
        const double var_ICaL__alpha = var_ICaL__ACT_infinity / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__ACT_infinity) / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__x_star = var_ICaL__IV_infinity_star / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__y_star = (1.0 - var_ICaL__IV_infinity_star) / var_ICaL__IV_tau_star; // per_ms
        const double d_dt_chaste_interface_var_ICaL__O_star = (-1.0 - var_ICaL__beta - var_ICaL__y_star) * var_chaste_interface__ICaL__O_star + var_chaste_interface__ICaL__C_star * var_ICaL__alpha + var_chaste_interface__ICaL__O * var_ICaL__delta + var_chaste_interface__ICaL__OI_star * var_ICaL__x_star; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__O_star;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative22(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
            // Units: mM; Initial value: 9.61545e-05
            
            const double var_x278 = exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm);
            const double var_x279 = 1.0 + var_x278;
            const double var_x280 = 1 / var_x279;
            const double var_x282 = exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm);
            const double var_x283 = 1.0 + var_x282;
            const double var_x285 = exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm);
            const double var_x286 = 1.0 + var_x285;
            const double var_x289 = 0.040277106492669565 / var_x286;
            const double var_x290 = 1 / var_x283;
            const double var_x295 = exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm);
            const double var_x296 = 1.0 + var_x295;
            const double var_x297 = exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x298 = 1.0 + var_x297;
            const double var_x299 = exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm);
            const double var_x300 = var_x299 / var_x298;
            const double var_x301 = 1 / (0.58999999999999997 + 0.80000000000000004 * var_x300);
            const double var_x303 = 1 / var_x296;
            const double var_x309 = var_x303;
            const double var_x310 = 1.0 - var_x309;
            const double var_x314 = 1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4);
            const double var_x315 = 1 / var_x314;
            const double var_x321 = var_x301 * var_x310;
            const double var_x327 = -var_x321;
            const double var_x329 = 0.99990000999900008 * var_x280;
            const double var_x331 = 1 / (25.0 - 17.5 * var_x315);
            const double var_x333 = var_x289 + var_x290 * var_x331;
            const double var_x338 = -var_x329;
            const double var_x339 = 0.99990000999900008 + var_x338;
            const double var_x340 = var_x333 * var_x339;
            const double var_x341 = -1.0 - var_x340;
            
            partialF = var_x327 + var_x341;
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__ICaL__C = rY[19];
        // Units: dimensionless; Initial value: 0.9999613782488198
        double var_chaste_interface__ICaL__CI = rY[23];
        // Units: dimensionless; Initial value: 1.587938121237188e-05
        double var_chaste_interface__ICaL__OI = rY[24];
        // Units: dimensionless; Initial value: 3.611420243201921e-10
        double var_chaste_interface__ICaL__CI_star = rY[25];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        
        
        // Mathematics
        const double var_ICaL__delta = 3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // per_ms
        const double var_ICaL__ACT_infinity = 1 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__ACT_tau = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)); // ms
        const double var_ICaL__IV_infinity = 0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_infinity_star = 9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_tau = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))); // ms
        const double var_ICaL__IV_tau_star = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))); // ms
        const double var_ICaL__alpha = var_ICaL__ACT_infinity / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__ACT_infinity) / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__x = var_ICaL__IV_infinity / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__x_star = var_ICaL__IV_infinity_star / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__y = (1.0 - var_ICaL__IV_infinity) / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__y_star = (1.0 - var_ICaL__IV_infinity_star) / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__delta_I = 9.9999999999999995e-7 * var_ICaL__delta * var_ICaL__x * var_ICaL__y_star / (var_ICaL__x_star * var_ICaL__y); // per_ms
        const double d_dt_chaste_interface_var_ICaL__CI = 9.9999999999999995e-7 * var_chaste_interface__ICaL__CI_star + (-var_ICaL__alpha - var_ICaL__delta_I - var_ICaL__x) * var_chaste_interface__ICaL__CI + var_chaste_interface__ICaL__C * var_ICaL__y + var_chaste_interface__ICaL__OI * var_ICaL__beta; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__CI;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative23(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
            // Units: mM; Initial value: 9.61545e-05
            
            const double var_x278 = exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm);
            const double var_x279 = 1.0 + var_x278;
            const double var_x280 = 1 / var_x279;
            const double var_x281 = 0.80000000000000004 * var_x280;
            const double var_x282 = exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm);
            const double var_x283 = 1.0 + var_x282;
            const double var_x285 = exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm);
            const double var_x286 = 1.0 + var_x285;
            const double var_x289 = 0.040277106492669565 / var_x286;
            const double var_x290 = 1 / var_x283;
            const double var_x291 = var_x289 + 0.032730010146303147 * var_x290;
            const double var_x295 = exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm);
            const double var_x296 = 1.0 + var_x295;
            const double var_x297 = exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x298 = 1.0 + var_x297;
            const double var_x299 = exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm);
            const double var_x300 = var_x299 / var_x298;
            const double var_x301 = 1 / (0.58999999999999997 + 0.80000000000000004 * var_x300);
            const double var_x303 = 1 / var_x296;
            const double var_x307 = 0.20000000000000001 + var_x281;
            const double var_x309 = var_x303;
            const double var_x312 = var_x301 * var_x309;
            const double var_x313 = -var_x312;
            const double var_x314 = 1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4);
            const double var_x315 = 1 / var_x314;
            const double var_x317 = -var_x281;
            const double var_x318 = 0.80000000000000004 + var_x317;
            const double var_x322 = var_x291 * var_x307;
            const double var_x329 = 0.99990000999900008 * var_x280;
            const double var_x336 = 9.9990000999900015e-5 + var_x329;
            const double var_x338 = -var_x329;
            const double var_x339 = 0.99990000999900008 + var_x338;
            const double var_x346 = 1 / var_x318;
            const double var_x347 = 1 / var_x336;
            const double var_x348 = var_x315 * var_x339 * var_x346 * var_x347;
            const double var_x358 = 3.0000000000000001e-6 * var_x307 * var_x348;
            const double var_x359 = -var_x322 - var_x358;
            
            partialF = var_x313 + var_x359;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__CI = rY[23];
        // Units: dimensionless; Initial value: 1.587938121237188e-05
        double var_chaste_interface__ICaL__OI = rY[24];
        // Units: dimensionless; Initial value: 3.611420243201921e-10
        double var_chaste_interface__ICaL__OI_star = rY[26];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        
        
        // Mathematics
        const double var_ICaL__delta = 3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // per_ms
        const double var_ICaL__ACT_infinity = 1 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__ACT_tau = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)); // ms
        const double var_ICaL__IV_infinity = 0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_infinity_star = 9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_tau = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))); // ms
        const double var_ICaL__IV_tau_star = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))); // ms
        const double var_ICaL__alpha = var_ICaL__ACT_infinity / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__ACT_infinity) / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__x = var_ICaL__IV_infinity / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__x_star = var_ICaL__IV_infinity_star / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__y = (1.0 - var_ICaL__IV_infinity) / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__y_star = (1.0 - var_ICaL__IV_infinity_star) / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__delta_I = 9.9999999999999995e-7 * var_ICaL__delta * var_ICaL__x * var_ICaL__y_star / (var_ICaL__x_star * var_ICaL__y); // per_ms
        const double d_dt_chaste_interface_var_ICaL__OI = 9.9999999999999995e-7 * var_chaste_interface__ICaL__OI_star + (-var_ICaL__beta - var_ICaL__delta_I - var_ICaL__x) * var_chaste_interface__ICaL__OI + var_chaste_interface__ICaL__CI * var_ICaL__alpha + var_chaste_interface__ICaL__O * var_ICaL__y; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__OI;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative24(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
            // Units: mM; Initial value: 9.61545e-05
            
            const double var_x278 = exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm);
            const double var_x279 = 1.0 + var_x278;
            const double var_x280 = 1 / var_x279;
            const double var_x281 = 0.80000000000000004 * var_x280;
            const double var_x282 = exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm);
            const double var_x283 = 1.0 + var_x282;
            const double var_x285 = exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm);
            const double var_x286 = 1.0 + var_x285;
            const double var_x289 = 0.040277106492669565 / var_x286;
            const double var_x290 = 1 / var_x283;
            const double var_x291 = var_x289 + 0.032730010146303147 * var_x290;
            const double var_x295 = exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm);
            const double var_x296 = 1.0 + var_x295;
            const double var_x297 = exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x298 = 1.0 + var_x297;
            const double var_x299 = exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm);
            const double var_x300 = var_x299 / var_x298;
            const double var_x301 = 1 / (0.58999999999999997 + 0.80000000000000004 * var_x300);
            const double var_x303 = 1 / var_x296;
            const double var_x307 = 0.20000000000000001 + var_x281;
            const double var_x309 = var_x303;
            const double var_x310 = 1.0 - var_x309;
            const double var_x314 = 1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4);
            const double var_x315 = 1 / var_x314;
            const double var_x317 = -var_x281;
            const double var_x318 = 0.80000000000000004 + var_x317;
            const double var_x321 = var_x301 * var_x310;
            const double var_x322 = var_x291 * var_x307;
            const double var_x327 = -var_x321;
            const double var_x329 = 0.99990000999900008 * var_x280;
            const double var_x336 = 9.9990000999900015e-5 + var_x329;
            const double var_x338 = -var_x329;
            const double var_x339 = 0.99990000999900008 + var_x338;
            const double var_x346 = 1 / var_x318;
            const double var_x347 = 1 / var_x336;
            const double var_x348 = var_x315 * var_x339 * var_x346 * var_x347;
            const double var_x358 = 3.0000000000000001e-6 * var_x307 * var_x348;
            const double var_x359 = -var_x322 - var_x358;
            
            partialF = var_x327 + var_x359;
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__ICaL__C_star = rY[21];
        // Units: dimensionless; Initial value: 5.936477396599124e-11
        double var_chaste_interface__ICaL__CI = rY[23];
        // Units: dimensionless; Initial value: 1.587938121237188e-05
        double var_chaste_interface__ICaL__CI_star = rY[25];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ICaL__OI_star = rY[26];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        
        
        // Mathematics
        const double var_ICaL__delta = 3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // per_ms
        const double var_ICaL__ACT_infinity = 1 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__ACT_tau = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)); // ms
        const double var_ICaL__IV_infinity = 0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_infinity_star = 9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_tau = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))); // ms
        const double var_ICaL__IV_tau_star = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))); // ms
        const double var_ICaL__alpha = var_ICaL__ACT_infinity / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__ACT_infinity) / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__x = var_ICaL__IV_infinity / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__x_star = var_ICaL__IV_infinity_star / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__y = (1.0 - var_ICaL__IV_infinity) / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__y_star = (1.0 - var_ICaL__IV_infinity_star) / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__delta_I = 9.9999999999999995e-7 * var_ICaL__delta * var_ICaL__x * var_ICaL__y_star / (var_ICaL__x_star * var_ICaL__y); // per_ms
        const double d_dt_chaste_interface_var_ICaL__CI_star = (-9.9999999999999995e-7 - var_ICaL__alpha - var_ICaL__x_star) * var_chaste_interface__ICaL__CI_star + var_chaste_interface__ICaL__CI * var_ICaL__delta_I + var_chaste_interface__ICaL__C_star * var_ICaL__y_star + var_chaste_interface__ICaL__OI_star * var_ICaL__beta; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__CI_star;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative25(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
            // Units: mM; Initial value: 9.61545e-05
            
            const double var_x278 = exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm);
            const double var_x279 = 1.0 + var_x278;
            const double var_x280 = 1 / var_x279;
            const double var_x282 = exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm);
            const double var_x283 = 1.0 + var_x282;
            const double var_x285 = exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm);
            const double var_x286 = 1.0 + var_x285;
            const double var_x289 = 0.040277106492669565 / var_x286;
            const double var_x290 = 1 / var_x283;
            const double var_x295 = exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm);
            const double var_x296 = 1.0 + var_x295;
            const double var_x297 = exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x298 = 1.0 + var_x297;
            const double var_x299 = exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm);
            const double var_x300 = var_x299 / var_x298;
            const double var_x301 = 1 / (0.58999999999999997 + 0.80000000000000004 * var_x300);
            const double var_x303 = 1 / var_x296;
            const double var_x309 = var_x303;
            const double var_x312 = var_x301 * var_x309;
            const double var_x313 = -var_x312;
            const double var_x314 = 1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4);
            const double var_x315 = 1 / var_x314;
            const double var_x329 = 0.99990000999900008 * var_x280;
            const double var_x331 = 1 / (25.0 - 17.5 * var_x315);
            const double var_x333 = var_x289 + var_x290 * var_x331;
            const double var_x336 = 9.9990000999900015e-5 + var_x329;
            const double var_x342 = var_x333 * var_x336;
            const double var_x366 = -9.9999999999999995e-7 - var_x342;
            
            partialF = var_x313 + var_x366;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__ICaL__OI = rY[24];
        // Units: dimensionless; Initial value: 3.611420243201921e-10
        double var_chaste_interface__ICaL__CI_star = rY[25];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ICaL__OI_star = rY[26];
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        
        
        // Mathematics
        const double var_ICaL__delta = 3.0 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4)); // per_ms
        const double var_ICaL__ACT_infinity = 1 / (1.0 + exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__ACT_tau = 0.58999999999999997 + 0.80000000000000004 * exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm) / (1.0 + exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm)); // ms
        const double var_ICaL__IV_infinity = 0.20000000000000001 + 0.80000000000000004 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_infinity_star = 9.9990000999900015e-5 + 0.99990000999900008 / (1.0 + exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm)); // dimensionless
        const double var_ICaL__IV_tau = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 0.032730010146303147 / (1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm))); // ms
        const double var_ICaL__IV_tau_star = 1 / (0.040277106492669565 / (1.0 + exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm)) + 1 / ((1.0 + exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm)) * (25.0 - 17.5 / (1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4))))); // ms
        const double var_ICaL__alpha = var_ICaL__ACT_infinity / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__beta = (1.0 - var_ICaL__ACT_infinity) / var_ICaL__ACT_tau; // per_ms
        const double var_ICaL__x = var_ICaL__IV_infinity / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__x_star = var_ICaL__IV_infinity_star / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__y = (1.0 - var_ICaL__IV_infinity) / var_ICaL__IV_tau; // per_ms
        const double var_ICaL__y_star = (1.0 - var_ICaL__IV_infinity_star) / var_ICaL__IV_tau_star; // per_ms
        const double var_ICaL__delta_I = 9.9999999999999995e-7 * var_ICaL__delta * var_ICaL__x * var_ICaL__y_star / (var_ICaL__x_star * var_ICaL__y); // per_ms
        const double d_dt_chaste_interface_var_ICaL__OI_star = (-9.9999999999999995e-7 - var_ICaL__beta - var_ICaL__x_star) * var_chaste_interface__ICaL__OI_star + var_chaste_interface__ICaL__CI_star * var_ICaL__alpha + var_chaste_interface__ICaL__OI * var_ICaL__delta_I + var_chaste_interface__ICaL__O_star * var_ICaL__y_star; // 1 / ms

        return d_dt_chaste_interface_var_ICaL__OI_star;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative26(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
            // Units: mM; Initial value: 9.61545e-05
            
            const double var_x278 = exp(5.833333333333333 + 0.33333333333333331 * var_chaste_interface__membrane__Vm);
            const double var_x279 = 1.0 + var_x278;
            const double var_x280 = 1 / var_x279;
            const double var_x282 = exp(-0.019709447580272044 - 0.092532617747756077 * var_chaste_interface__membrane__Vm);
            const double var_x283 = 1.0 + var_x282;
            const double var_x285 = exp(4.7444197507005512 + 0.096627693496956227 * var_chaste_interface__membrane__Vm);
            const double var_x286 = 1.0 + var_x285;
            const double var_x289 = 0.040277106492669565 / var_x286;
            const double var_x290 = 1 / var_x283;
            const double var_x295 = exp(1.4349206349206352 - 0.10582010582010583 * var_chaste_interface__membrane__Vm);
            const double var_x296 = 1.0 + var_x295;
            const double var_x297 = exp(1.7160000000000002 + 0.13200000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x298 = 1.0 + var_x297;
            const double var_x299 = exp(0.67599999999999993 + 0.051999999999999998 * var_chaste_interface__membrane__Vm);
            const double var_x300 = var_x299 / var_x298;
            const double var_x301 = 1 / (0.58999999999999997 + 0.80000000000000004 * var_x300);
            const double var_x303 = 1 / var_x296;
            const double var_x309 = var_x303;
            const double var_x310 = 1.0 - var_x309;
            const double var_x314 = 1.0 + 8.1000000000000005e-11 / pow(var_chaste_interface__Ca__Ca_ss_CaL, 4);
            const double var_x315 = 1 / var_x314;
            const double var_x321 = var_x301 * var_x310;
            const double var_x327 = -var_x321;
            const double var_x329 = 0.99990000999900008 * var_x280;
            const double var_x331 = 1 / (25.0 - 17.5 * var_x315);
            const double var_x333 = var_x289 + var_x290 * var_x331;
            const double var_x336 = 9.9990000999900015e-5 + var_x329;
            const double var_x342 = var_x333 * var_x336;
            const double var_x366 = -9.9999999999999995e-7 - var_x342;
            
            partialF = var_x327 + var_x366;
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative27(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_INa_m_gate__m = -0.080000000000000002 * var_chaste_interface__INa_m_gate__m * exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm) + 0.32000000000000001 * (1.0 - var_chaste_interface__INa_m_gate__m) * (47.130000000000003 + var_chaste_interface__membrane__Vm) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__Vm)); // 1 / ms

        return d_dt_chaste_interface_var_INa_m_gate__m;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative27(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x370 = -0.10000000000000001 * var_chaste_interface__membrane__Vm;
            const double var_x371 = exp(-4.7130000000000001 + var_x370);
            const double var_x372 = 1.0 - var_x371;
            const double var_x373 = 0.32000000000000001 / var_x372;
            const double var_x374 = exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm);
            const double var_x376 = 47.130000000000003 + var_chaste_interface__membrane__Vm;
            const double var_x378 = -0.080000000000000002 * var_x374 - var_x373 * var_x376;
            
            partialF = var_x378;
        }
        else
        {
            const double y_save = rY[27];
            rY[27] += delta;
            const double temp = EvaluateYDerivative27(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[27])/delta;
            rY[27] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative28(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_INa_h_gate__h = (1.0 - var_chaste_interface__INa_h_gate__h) * ((var_chaste_interface__membrane__Vm >= -40.0) ? (0) : (0.13500000000000001 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__Vm))) - ((var_chaste_interface__membrane__Vm >= -40.0) ? (7.6923076923076916 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__Vm))) : (310000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__Vm) + 3.5600000000000001 * exp(0.079000000000000001 * var_chaste_interface__membrane__Vm))) * var_chaste_interface__INa_h_gate__h; // 1 / ms

        return d_dt_chaste_interface_var_INa_h_gate__h;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative28(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x379 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__Vm);
            const double var_x380 = 1.0 + var_x379;
            const double var_x381 = var_chaste_interface__membrane__Vm >= -40.0;
            const double var_x382 = exp(0.079000000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x383 = exp(0.34999999999999998 * var_chaste_interface__membrane__Vm);
            const double var_x384 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__Vm);
            
            partialF = ((var_x381) ? (-7.6923076923076916 / var_x380) : (-310000.0 * var_x383 - 0.13500000000000001 * var_x384 - 3.5600000000000001 * var_x382));
        }
        else
        {
            const double y_save = rY[28];
            rY[28] += delta;
            const double temp = EvaluateYDerivative28(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[28])/delta;
            rY[28] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative29(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_INa_j_gate__j = (1.0 - var_chaste_interface__INa_j_gate__j) * ((var_chaste_interface__membrane__Vm >= -40.0) ? (0) : ((37.780000000000001 + var_chaste_interface__membrane__Vm) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__Vm) - 6.9480000000000006e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__Vm)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__Vm)))) - ((var_chaste_interface__membrane__Vm >= -40.0) ? (0.29999999999999999 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__Vm))) : (0.1212 * exp(-0.01052 * var_chaste_interface__membrane__Vm) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__Vm)))) * var_chaste_interface__INa_j_gate__j; // 1 / ms

        return d_dt_chaste_interface_var_INa_j_gate__j;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative29(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x370 = -0.10000000000000001 * var_chaste_interface__membrane__Vm;
            const double var_x381 = var_chaste_interface__membrane__Vm >= -40.0;
            const double var_x385 = exp(-3.2000000000000002 + var_x370);
            const double var_x386 = 1.0 + var_x385;
            const double var_x387 = exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__Vm);
            const double var_x388 = var_x387 / var_x386;
            const double var_x390 = exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__Vm);
            const double var_x391 = 1.0 + var_x390;
            const double var_x392 = 1 / var_x391;
            const double var_x393 = exp(0.24440000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x394 = exp(-0.043909999999999998 * var_chaste_interface__membrane__Vm);
            const double var_x395 = -127140.0 * var_x393 - 6.9480000000000006e-5 * var_x394;
            const double var_x396 = var_x392 * var_x395;
            const double var_x397 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x398 = 1.0 + var_x397;
            const double var_x399 = exp(-0.01052 * var_chaste_interface__membrane__Vm);
            const double var_x400 = var_x399 / var_x398;
            const double var_x401 = 37.780000000000001 + var_chaste_interface__membrane__Vm;
            
            partialF = ((var_x381) ? (-0.29999999999999999 * var_x388) : (-0.1212 * var_x400 - var_x396 * var_x401));
        }
        else
        {
            const double y_save = rY[29];
            rY[29] += delta;
            const double temp = EvaluateYDerivative29(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[29])/delta;
            rY[29] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative30(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_INaL_mL_gate__mL = -0.080000000000000002 * var_chaste_interface__INaL_mL_gate__mL * exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm) + 0.32000000000000001 * (1.0 - var_chaste_interface__INaL_mL_gate__mL) * (47.130000000000003 + var_chaste_interface__membrane__Vm) / (1.0 - exp(-4.7130000000000001 - 0.10000000000000001 * var_chaste_interface__membrane__Vm)); // 1 / ms

        return d_dt_chaste_interface_var_INaL_mL_gate__mL;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative30(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x370 = -0.10000000000000001 * var_chaste_interface__membrane__Vm;
            const double var_x371 = exp(-4.7130000000000001 + var_x370);
            const double var_x372 = 1.0 - var_x371;
            const double var_x373 = 0.32000000000000001 / var_x372;
            const double var_x374 = exp(-0.090909090909090912 * var_chaste_interface__membrane__Vm);
            const double var_x376 = 47.130000000000003 + var_chaste_interface__membrane__Vm;
            const double var_x378 = -0.080000000000000002 * var_x374 - var_x373 * var_x376;
            
            partialF = var_x378;
        }
        else
        {
            const double y_save = rY[30];
            rY[30] += delta;
            const double temp = EvaluateYDerivative30(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[30])/delta;
            rY[30] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative31(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_INaL_hL_gate__hL = 0.0016666666666666668 / (1.0 + exp(14.918032786885247 + 0.16393442622950821 * var_chaste_interface__membrane__Vm)) - 0.0016666666666666668 * var_chaste_interface__INaL_hL_gate__hL; // 1 / ms

        return d_dt_chaste_interface_var_INaL_hL_gate__hL;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative31(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.0016666666666666668;
        }
        else
        {
            const double y_save = rY[31];
            rY[31] += delta;
            const double temp = EvaluateYDerivative31(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[31])/delta;
            rY[31] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative32(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_IKr_xr_gate__xr = (-var_chaste_interface__IKr_xr_gate__xr + 1 / (1.0 + exp(-2.3729411764705883 - 0.23529411764705882 * var_chaste_interface__membrane__Vm))) * (0.00029999999999999997 * (38.360799999999998 + var_chaste_interface__membrane__Vm) / (-1.0 + exp(5.8385137599999997 + 0.1522 * var_chaste_interface__membrane__Vm)) + 0.00059999999999999995 * (-1.7383999999999999 + var_chaste_interface__membrane__Vm) / (1.0 - exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__membrane__Vm))); // 1 / ms

        return d_dt_chaste_interface_var_IKr_xr_gate__xr;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative32(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x407 = exp(5.8385137599999997 + 0.1522 * var_chaste_interface__membrane__Vm);
            const double var_x408 = -1.0 + var_x407;
            const double var_x409 = 0.00029999999999999997 / var_x408;
            const double var_x410 = exp(0.2364224 - 0.13600000000000001 * var_chaste_interface__membrane__Vm);
            const double var_x411 = 1.0 - var_x410;
            const double var_x412 = 0.00059999999999999995 / var_x411;
            const double var_x413 = -1.7383999999999999 + var_chaste_interface__membrane__Vm;
            const double var_x414 = 38.360799999999998 + var_chaste_interface__membrane__Vm;
            const double var_x415 = var_x409 * var_x414;
            const double var_x416 = var_x412 * var_x413;
            
            partialF = -var_x415 - var_x416;
        }
        else
        {
            const double y_save = rY[32];
            rY[32] += delta;
            const double temp = EvaluateYDerivative32(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[32])/delta;
            rY[32] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative33(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Ito1_a_gate__a = (-var_chaste_interface__Ito1_a_gate__a + 1 / (1.0 + exp(-1.3230057479321462 - 0.14019346698443852 * var_chaste_interface__membrane__Vm))) * (3.5 / (1.0 + exp(3.403513787634354 + 0.034035137876343539 * var_chaste_interface__membrane__Vm)) + 0.82719827942757873 / (1.0 + exp(0.62658348478969694 - 0.034035137876343539 * var_chaste_interface__membrane__Vm))); // 1 / ms

        return d_dt_chaste_interface_var_Ito1_a_gate__a;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative33(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x419 = 0.034035137876343539 * var_chaste_interface__membrane__Vm;
            const double var_x420 = exp(0.62658348478969694 - var_x419);
            const double var_x421 = 1.0 + var_x420;
            const double var_x422 = exp(3.403513787634354 + var_x419);
            const double var_x423 = 1.0 + var_x422;
            const double var_x424 = 3.5 / var_x423;
            const double var_x425 = 0.82719827942757873 / var_x421;
            
            partialF = -var_x424 - var_x425;
        }
        else
        {
            const double y_save = rY[33];
            rY[33] += delta;
            const double temp = EvaluateYDerivative33(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[33])/delta;
            rY[33] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative34(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Ito1_i1f_gate__i1f = 0.025000000000000001 * (1.0 - var_chaste_interface__Ito1_i1f_gate__i1f) / (1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)) - 0.10208977775055385 * var_chaste_interface__Ito1_i1f_gate__i1f / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm)); // 1 / ms

        return d_dt_chaste_interface_var_Ito1_i1f_gate__i1f;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative34(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x426 = 0.20000000000000001 * var_chaste_interface__membrane__Vm;
            const double var_x427 = exp(11.6 + var_x426);
            const double var_x428 = 1.0 + var_x427;
            const double var_x431 = exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm);
            const double var_x432 = 1.0 + var_x431;
            const double var_x435 = 1 / var_x428;
            const double var_x436 = 0.025000000000000001 * var_x435;
            const double var_x437 = 1 / var_x432;
            const double var_x438 = -0.10208977775055385 * var_x437;
            
            partialF = var_x438 - var_x436;
        }
        else
        {
            const double y_save = rY[34];
            rY[34] += delta;
            const double temp = EvaluateYDerivative34(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[34])/delta;
            rY[34] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative35(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Ito1_i1s_gate__i1s = 0.0040000000000000001 * (1.0 - var_chaste_interface__Ito1_i1s_gate__i1s) / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)) - 0.10208977775055385 * var_chaste_interface__Ito1_i1s_gate__i1s / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm)); // 1 / ms

        return d_dt_chaste_interface_var_Ito1_i1s_gate__i1s;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative35(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            
            const double var_x426 = 0.20000000000000001 * var_chaste_interface__membrane__Vm;
            const double var_x431 = exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm);
            const double var_x432 = 1.0 + var_x431;
            const double var_x437 = 1 / var_x432;
            const double var_x438 = -0.10208977775055385 * var_x437;
            const double var_x439 = exp(12.0 + var_x426);
            const double var_x440 = 1.0 + var_x439;
            
            partialF = var_x438 - 0.0040000000000000001 / var_x440;
        }
        else
        {
            const double y_save = rY[35];
            rY[35] += delta;
            const double temp = EvaluateYDerivative35(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[35])/delta;
            rY[35] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative36(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Ito2_i2f_gate__i2f = -0.125 * var_chaste_interface__Ito2_i2f_gate__i2f + 0.0031250000000000002 / ((1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)) * (0.025000000000000001 / (1.0 + exp(11.6 + 0.20000000000000001 * var_chaste_interface__membrane__Vm)) + 0.20000000000000001 / (1.0 + exp(-2.1111111111111112 - 0.1111111111111111 * var_chaste_interface__membrane__Vm)))); // 1 / ms

        return d_dt_chaste_interface_var_Ito2_i2f_gate__i2f;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative36(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.125;
        }
        else
        {
            const double y_save = rY[36];
            rY[36] += delta;
            const double temp = EvaluateYDerivative36(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[36])/delta;
            rY[36] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative37(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__Irel__Irel = rY[37];
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_JSR = rY[38];
        // Units: mM; Initial value: 0.917692717
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__CaMK_active__CaMK_trap = rY[47];
        // Units: dimensionless; Initial value: 0.0018861341
        
        
        // Mathematics
        const double var_CaMK_active__CaMK_active = 0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap; // dimensionless
        const double var_Irel__beta_tau = 4.75 + 4.75 / (1.0 + 2.9619676669542428e-6 * pow(1 / var_CaMK_active__CaMK_active, 10.0)); // ms
        const double var_ICaL__ICaL = 14448.603861345418 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss_CaL * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * mParameters[0] * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double d_dt_chaste_interface_var_Irel__Irel = (1.0 + 0.0123 / var_chaste_interface__Ca__Ca_JSR) * (-var_chaste_interface__Irel__Irel - 0.1125 * var_ICaL__ICaL * var_Irel__beta_tau / (1.0 + pow(1 / var_chaste_interface__Ca__Ca_JSR, 8.0))) / var_Irel__beta_tau; // mM_per_ms / ms

        return d_dt_chaste_interface_var_Irel__Irel;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative37(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca__Ca_JSR = rY[38];
            // Units: mM; Initial value: 0.917692717
            double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
            // Units: mM; Initial value: 9.04757e-05
            double var_chaste_interface__CaMK_active__CaMK_trap = rY[47];
            // Units: dimensionless; Initial value: 0.0018861341
            
            const double var_x188 = 1.0 - var_chaste_interface__CaMK_active__CaMK_trap;
            const double var_x189 = 1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr;
            const double var_x190 = 1 / var_x189;
            const double var_x191 = 0.050000000000000003 * var_x190;
            const double var_x192 = var_x188 * var_x191;
            const double var_x195 = var_x192 + var_chaste_interface__CaMK_active__CaMK_trap;
            const double var_x441 = 1 / var_x195;
            const double var_x442 = pow(var_x441, 10.0);
            const double var_x443 = 1.0 + 2.9619676669542428e-6 * var_x442;
            const double var_x444 = 1 / var_x443;
            const double var_x445 = 4.75 + 4.75 * var_x444;
            const double var_x446 = 1 / var_chaste_interface__Ca__Ca_JSR;
            const double var_x455 = 1 / var_x445;
            const double var_x456 = 1.0 + 0.0123 * var_x446;
            const double var_x457 = var_x455 * var_x456;
            
            partialF = -var_x457;
        }
        else
        {
            const double y_save = rY[37];
            rY[37] += delta;
            const double temp = EvaluateYDerivative37(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[37])/delta;
            rY[37] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative38(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Irel__Irel = rY[37];
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_JSR = rY[38];
        // Units: mM; Initial value: 0.917692717
        double var_chaste_interface__Ca__Ca_NSR = rY[39];
        // Units: mM; Initial value: 0.929835335
        
        
        // Mathematics
        const double var_Itr__Itr = 0.040000000000000001 * var_chaste_interface__Ca__Ca_NSR - 0.040000000000000001 * var_chaste_interface__Ca__Ca_JSR; // mM_per_ms
        const double d_dt_chaste_interface_var_Ca__Ca_JSR = (-var_chaste_interface__Irel__Irel + var_Itr__Itr) / (1.0 + 8.0 / pow((0.80000000000000004 + var_chaste_interface__Ca__Ca_JSR), 2)); // mM / ms

        return d_dt_chaste_interface_var_Ca__Ca_JSR;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative38(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Irel__Irel = rY[37];
            // Units: mM_per_ms; Initial value: 0.00107332
            double var_chaste_interface__Ca__Ca_JSR = rY[38];
            // Units: mM; Initial value: 0.917692717
            double var_chaste_interface__Ca__Ca_NSR = rY[39];
            // Units: mM; Initial value: 0.929835335
            
            const double var_x459 = -var_chaste_interface__Irel__Irel;
            const double var_x466 = 0.80000000000000004 + var_chaste_interface__Ca__Ca_JSR;
            const double var_x467 = pow(var_x466, (-2));
            const double var_x468 = 1 / (1.0 + 8.0 * var_x467);
            const double var_x469 = 0.040000000000000001 * var_x468;
            
            partialF = -var_x469 + 0.25 * (var_x459 + 0.040000000000000001 * var_chaste_interface__Ca__Ca_NSR - 0.040000000000000001 * var_chaste_interface__Ca__Ca_JSR) / (pow(var_x466, 3) * pow((0.125 + var_x467), 2));
        }
        else
        {
            const double y_save = rY[38];
            rY[38] += delta;
            const double temp = EvaluateYDerivative38(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[38])/delta;
            rY[38] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative39(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__Ca__Ca_JSR = rY[38];
        // Units: mM; Initial value: 0.917692717
        double var_chaste_interface__Ca__Ca_NSR = rY[39];
        // Units: mM; Initial value: 0.929835335
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__CaMK_active__CaMK_trap = rY[47];
        // Units: dimensionless; Initial value: 0.0018861341
        
        
        // Mathematics
        const double var_CaMK_active__CaMK_active = 0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap; // dimensionless
        const double var_Ileak__Ileak = 0.00029166666666666669 * var_chaste_interface__Ca__Ca_NSR; // mM_per_ms
        const double var_Itr__Itr = 0.040000000000000001 * var_chaste_interface__Ca__Ca_NSR - 0.040000000000000001 * var_chaste_interface__Ca__Ca_JSR; // mM_per_ms
        const double var_Iup__Iup = 0.0043750000000000004 * (1.0 + 0.75 * var_CaMK_active__CaMK_active / (0.14999999999999999 + var_CaMK_active__CaMK_active)) * var_chaste_interface__Ca__Ca_i / (0.00092000000000000003 - 0.00017000000000000001 * var_CaMK_active__CaMK_active / (0.14999999999999999 + var_CaMK_active__CaMK_active) + var_chaste_interface__Ca__Ca_i); // mM_per_ms
        const double var_cell_geometry__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell_geometry__Vjsr = 0.0047999999999999996 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vnsr = 0.055199999999999999 * var_cell_geometry__vcell; // uL
        const double d_dt_chaste_interface_var_Ca__Ca_NSR = -var_Ileak__Ileak - var_Itr__Itr * var_cell_geometry__Vjsr / var_cell_geometry__Vnsr + var_Iup__Iup; // mM / ms

        return d_dt_chaste_interface_var_Ca__Ca_NSR;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative39(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.0037699275362318837;
        }
        else
        {
            const double y_save = rY[39];
            rY[39] += delta;
            const double temp = EvaluateYDerivative39(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[39])/delta;
            rY[39] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative40(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__Irel__Irel = rY[37];
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        double var_chaste_interface__Na__Na_ss_sr = rY[43];
        // Units: mM; Initial value: 6.935607
        
        
        // Mathematics
        const double var_Ca__Idiff = 5.0 * var_chaste_interface__Ca__Ca_ss_sr - 5.0 * var_chaste_interface__Ca__Ca_i; // mM_per_ms
        const double var_Ca__Idiff_ss = 0.5 * var_chaste_interface__Ca__Ca_ss_sr - 0.5 * var_chaste_interface__Ca__Ca_ss_CaL; // mM_per_ms
        const double var_cell_geometry__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell_geometry__Vjsr = 0.0047999999999999996 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vss_sr = 0.02 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__AF = 5.0618217998279567e-10 * M_PI; // uF_mole_per_C
        const double var_INaCa__INaCa_ss_sr = (1.6200000000000001 * pow(var_chaste_interface__Na__Na_ss_sr, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 2469600.0 * var_chaste_interface__Ca__Ca_ss_sr * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_ss_sr, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_ss_sr, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr)); // uA_per_uF
        const double d_dt_chaste_interface_var_Ca__Ca_ss_sr = (-var_Ca__Idiff - var_Ca__Idiff_ss + var_chaste_interface__Irel__Irel * var_cell_geometry__Vjsr / var_cell_geometry__Vss_sr + var_INaCa__INaCa_ss_sr * var_cell_geometry__AF / var_cell_geometry__Vss_sr) / (1.0 + 0.0097788000000000007 / pow((0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss_sr), 2) + 4.0890000000000003e-5 / pow((0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss_sr), 2)); // mM / ms

        return d_dt_chaste_interface_var_Ca__Ca_ss_sr;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative40(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_i = rY[1];
            // Units: mM; Initial value: 7.09945e-05
            double var_chaste_interface__Irel__Irel = rY[37];
            // Units: mM_per_ms; Initial value: 0.00107332
            double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
            // Units: mM; Initial value: 9.04757e-05
            double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
            // Units: mM; Initial value: 9.61545e-05
            double var_chaste_interface__Na__Na_ss_sr = rY[43];
            // Units: mM; Initial value: 6.935607
            
            const double var_x57 = exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm);
            const double var_x58 = 1.0 + 0.32000000000000001 * var_x57;
            const double var_x59 = 1 / var_x58;
            const double var_x62 = exp(0.010107898065447322 * var_chaste_interface__membrane__Vm);
            const double var_x70 = pow(var_chaste_interface__Na__Na_ss_sr, 3);
            const double var_x71 = var_x62 * var_x70;
            const double var_x72 = var_x57 * var_chaste_interface__Ca__Ca_ss_sr;
            const double var_x73 = pow(var_chaste_interface__Ca__Ca_ss_sr, (-2));
            const double var_x74 = 1.0 + 1.5624999999999999e-8 * var_x73;
            const double var_x75 = 1 / var_x74;
            const double var_x76 = 1 / (13227.9606 + 8.4084932990912282 * var_x70 + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr);
            const double var_x77 = var_x75 * var_x76;
            const double var_x116 = 1.6200000000000001 * var_x71 - 2469600.0 * var_x72;
            const double var_x117 = var_x116 * var_x77;
            const double var_x126 = var_x57 * var_x59;
            const double var_x151 = var_x126 * var_x77;
            const double var_x152 = var_x116 * var_x75 / pow((0.0030448615405916234 + 1.9354984970793804e-6 * var_x70 + var_chaste_interface__Ca__Ca_ss_sr), 2);
            const double var_x153 = var_x116 * var_x76 / (pow(var_x74, 2) * pow(var_chaste_interface__Ca__Ca_ss_sr, 3));
            const double var_x168 = var_x152 * var_x59;
            const double var_x473 = 0.0020916619007553534 * var_x59;
            const double var_x475 = 0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss_sr;
            const double var_x476 = 0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss_sr;
            const double var_x477 = 1.0 + 0.0097788000000000007 / pow(var_x475, 2) + 4.0890000000000003e-5 / pow(var_x476, 2);
            const double var_x478 = 1 / var_x477;
            const double var_x479 = var_x478;
            const double var_x480 = var_x153 * var_x59;
            
            partialF = var_x479 * (-5.5 + 6.53644343986048e-11 * var_x480 - 4.8146657448698097e-10 * var_x168 - 5165.5682301054212 * var_x151) + (0.019557600000000001 / pow(var_x475, 3) + 8.1780000000000006e-5 / pow(var_x476, 3)) * (0.5 * var_chaste_interface__Ca__Ca_ss_CaL + 0.23999999999999996 * var_chaste_interface__Irel__Irel + 5.0 * var_chaste_interface__Ca__Ca_i - 5.5 * var_chaste_interface__Ca__Ca_ss_sr + var_x117 * var_x473) / pow(var_x477, 2);
        }
        else
        {
            const double y_save = rY[40];
            rY[40] += delta;
            const double temp = EvaluateYDerivative40(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[40])/delta;
            rY[40] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative41(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__ICaL__O = rY[20];
        // Units: dimensionless; Initial value: 2.27419494597377e-05
        double var_chaste_interface__ICaL__O_star = rY[22];
        // Units: dimensionless; Initial value: 1.350122566369778e-15
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
        // Units: mM; Initial value: 9.61545e-05
        
        
        // Mathematics
        const double var_Ca__Idiff_ss = 0.5 * var_chaste_interface__Ca__Ca_ss_sr - 0.5 * var_chaste_interface__Ca__Ca_ss_CaL; // mM_per_ms
        const double var_cell_geometry__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell_geometry__Vss_CaL = 0.002 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vss_sr = 0.02 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__AF = 5.0618217998279567e-10 * M_PI; // uF_mole_per_C
        const double var_ICaL__ICaL = 14448.603861345418 * (-0.61380000000000001 + var_chaste_interface__Ca__Ca_ss_CaL * exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)) * (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * mParameters[0] * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.074873319003313496 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double d_dt_chaste_interface_var_Ca__Ca_ss_CaL = (var_Ca__Idiff_ss * var_cell_geometry__Vss_sr / var_cell_geometry__Vss_CaL - 0.5 * var_ICaL__ICaL * var_cell_geometry__AF / var_cell_geometry__Vss_CaL) / (1.0 + 0.0097788000000000007 / pow((0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss_CaL), 2) + 4.0890000000000003e-5 / pow((0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss_CaL), 2)); // mM / ms

        return d_dt_chaste_interface_var_Ca__Ca_ss_CaL;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative41(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__ICaL__O = rY[20];
            // Units: dimensionless; Initial value: 2.27419494597377e-05
            double var_chaste_interface__ICaL__O_star = rY[22];
            // Units: dimensionless; Initial value: 1.350122566369778e-15
            double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
            // Units: mM; Initial value: 9.04757e-05
            double var_chaste_interface__Ca__Ca_ss_CaL = rY[41];
            // Units: mM; Initial value: 9.61545e-05
            
            const double var_x33 = exp(0.074873319003313496 * var_chaste_interface__membrane__Vm);
            const double var_x34 = -1.0 + var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x36 = var_x33;
            const double var_x49 = var_x33 * var_chaste_interface__membrane__Vm;
            const double var_x88 = (var_chaste_interface__ICaL__O + var_chaste_interface__ICaL__O_star) * mParameters[0];
            const double var_x90 = -0.61380000000000001 + var_x36 * var_chaste_interface__Ca__Ca_ss_CaL;
            const double var_x91 = var_x35 * var_x90;
            const double var_x92 = var_x35 * var_x49;
            const double var_x136 = var_x91 * var_chaste_interface__membrane__Vm;
            const double var_x481 = 151.10797107941448 * var_x88;
            const double var_x483 = 0.0086999999999999994 + var_chaste_interface__Ca__Ca_ss_CaL;
            const double var_x484 = 0.00087000000000000001 + var_chaste_interface__Ca__Ca_ss_CaL;
            const double var_x485 = 1.0 + 0.0097788000000000007 / pow(var_x483, 2) + 4.0890000000000003e-5 / pow(var_x484, 2);
            const double var_x486 = 1 / var_x485;
            const double var_x487 = var_x486;
            
            partialF = var_x487 * (-5.0 - var_x481 * var_x92) + (0.019557600000000001 / pow(var_x483, 3) + 8.1780000000000006e-5 / pow(var_x484, 3)) * (5.0 * var_chaste_interface__Ca__Ca_ss_sr - 5.0 * var_chaste_interface__Ca__Ca_ss_CaL - var_x136 * var_x481) / pow(var_x485, 2);
        }
        else
        {
            const double y_save = rY[41];
            rY[41] += delta;
            const double temp = EvaluateYDerivative41(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[41])/delta;
            rY[41] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative42(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__INa_m_gate__m = rY[27];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INa_h_gate__h = rY[28];
        // Units: dimensionless; Initial value: 0.9913109066867
        double var_chaste_interface__INa_j_gate__j = rY[29];
        // Units: dimensionless; Initial value: 0.9970771239754529
        double var_chaste_interface__INaL_mL_gate__mL = rY[30];
        // Units: dimensionless; Initial value: 0.001022252813581797
        double var_chaste_interface__INaL_hL_gate__hL = rY[31];
        // Units: dimensionless; Initial value: 0.3593255076983574
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = rY[43];
        // Units: mM; Initial value: 6.935607
        double var_chaste_interface__Cl__Cl_i = rY[44];
        // Units: mM; Initial value: 20.26842
        
        
        // Mathematics
        const double var_Na__Idiff_Na = 5.0 * var_chaste_interface__Na__Na_ss_sr - 5.0 * var_chaste_interface__Na__Na_i; // mM_per_ms
        const double var_cell_geometry__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell_geometry__Vmyo = 0.67800000000000005 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vss_sr = 0.02 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__AF = 5.0618217998279567e-10 * M_PI; // uF_mole_per_C
        const double var_INaCa__INaCa = (6.4800000000000004 * pow(var_chaste_interface__Na__Na_i, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 9878400.0 * var_chaste_interface__Ca__Ca_i * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_i, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_i)); // uA_per_uF
        const double var_INaK__INaK = 0.062337970750628316 * pow(var_chaste_interface__Na__Na_i, 3) / (pow((1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i), 3) * (1.0 + exp(-3.4441726741524206 - 0.037436659501656748 * var_chaste_interface__membrane__Vm))); // uA_per_uF
        const double var_INab__INab = 1.1558883089076335e-5 * (-140.0 + var_chaste_interface__Na__Na_i * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)) * var_chaste_interface__membrane__Vm / (-1.0 + exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_reversal_potentials__ECl = -26.711785007306684 * log(100.0 / var_chaste_interface__Cl__Cl_i); // mV
        const double var_reversal_potentials__ENa = 26.711785007306684 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_CT_Na_Cl__CT_Na_Cl = 2.4610800000000002e-5 * pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4) / (59494197.640692554 + pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4)); // mM_per_ms
        const double var_INa__INa = pow(var_chaste_interface__INa_m_gate__m, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * mParameters[1] * var_chaste_interface__INa_h_gate__h * var_chaste_interface__INa_j_gate__j; // uA_per_uF
        const double var_INaL__INaL = 0.0064999999999999997 * pow(var_chaste_interface__INaL_mL_gate__mL, 3) * (-var_reversal_potentials__ENa + var_chaste_interface__membrane__Vm) * var_chaste_interface__INaL_hL_gate__hL; // uA_per_uF
        const double d_dt_chaste_interface_var_Na__Na_i = var_Na__Idiff_Na * var_cell_geometry__Vss_sr / var_cell_geometry__Vmyo - (3.0 * var_INaCa__INaCa + 3.0 * var_INaK__INaK + var_INa__INa + var_INaL__INaL + var_INab__INab) * var_cell_geometry__AF / var_cell_geometry__Vmyo + var_CT_Na_Cl__CT_Na_Cl; // mM / ms

        return d_dt_chaste_interface_var_Na__Na_i;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative42(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_i = rY[1];
            // Units: mM; Initial value: 7.09945e-05
            double var_chaste_interface__INa_m_gate__m = rY[27];
            // Units: dimensionless; Initial value: 0.001022252813581797
            double var_chaste_interface__INa_h_gate__h = rY[28];
            // Units: dimensionless; Initial value: 0.9913109066867
            double var_chaste_interface__INa_j_gate__j = rY[29];
            // Units: dimensionless; Initial value: 0.9970771239754529
            double var_chaste_interface__INaL_mL_gate__mL = rY[30];
            // Units: dimensionless; Initial value: 0.001022252813581797
            double var_chaste_interface__INaL_hL_gate__hL = rY[31];
            // Units: dimensionless; Initial value: 0.3593255076983574
            double var_chaste_interface__Na__Na_i = rY[42];
            // Units: mM; Initial value: 6.935575
            double var_chaste_interface__Cl__Cl_i = rY[44];
            // Units: mM; Initial value: 20.26842
            
            const double var_x10 = pow(var_chaste_interface__INaL_mL_gate__mL, 3);
            const double var_x12 = 0.037436659501656748 * var_chaste_interface__membrane__Vm;
            const double var_x13 = exp(var_x12);
            const double var_x14 = -1.0 + var_x13;
            const double var_x15 = 1 / var_x14;
            const double var_x46 = pow(var_chaste_interface__INa_m_gate__m, 3);
            const double var_x47 = var_x46 * mParameters[1] * var_chaste_interface__INa_j_gate__j;
            const double var_x48 = var_x47 * var_chaste_interface__INa_h_gate__h;
            const double var_x52 = var_x13 * var_chaste_interface__membrane__Vm;
            const double var_x57 = exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm);
            const double var_x58 = 1.0 + 0.32000000000000001 * var_x57;
            const double var_x59 = 1 / var_x58;
            const double var_x61 = pow(var_chaste_interface__Na__Na_i, 3);
            const double var_x62 = exp(0.010107898065447322 * var_chaste_interface__membrane__Vm);
            const double var_x63 = var_x61 * var_x62;
            const double var_x64 = var_x57 * var_chaste_interface__Ca__Ca_i;
            const double var_x65 = 1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_i, 2);
            const double var_x66 = 1 / var_x65;
            const double var_x67 = 1 / (13227.9606 + 8.4084932990912282 * var_x61 + 4344355.375 * var_chaste_interface__Ca__Ca_i);
            const double var_x68 = var_x66 * var_x67;
            const double var_x83 = 1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i;
            const double var_x84 = pow(var_x83, (-3));
            const double var_x85 = exp(-3.4441726741524206 - var_x12);
            const double var_x86 = 1.0 + var_x85;
            const double var_x112 = 6.4800000000000004 * var_x63 - 9878400.0 * var_x64;
            const double var_x129 = var_x112 * var_x66 / pow((0.0030448615405916234 + 1.9354984970793804e-6 * var_x61 + var_chaste_interface__Ca__Ca_i), 2);
            const double var_x139 = 1 / var_chaste_interface__Na__Na_i;
            const double var_x140 = log(140.0 * var_x139);
            const double var_x154 = 1 / var_x86;
            const double var_x155 = var_x154 * var_x61 / pow(var_x83, 4);
            const double var_x156 = var_x15 * var_x52;
            const double var_x157 = var_x10 * var_x139 * var_chaste_interface__INaL_hL_gate__hL;
            const double var_x158 = pow(var_chaste_interface__Na__Na_i, 2);
            const double var_x159 = var_x154 * var_x158 * var_x84;
            const double var_x162 = var_x129 * var_x59;
            const double var_x163 = var_x158 * var_x162;
            const double var_x164 = var_x139 * var_x48;
            const double var_x165 = var_x59 * var_x62;
            const double var_x166 = var_x158 * var_x165 * var_x68;
            const double var_x171 = 1 / var_chaste_interface__Cl__Cl_i;
            const double var_x490 = log(100.0 * var_x171);
            const double var_x491 = var_x140 + var_x490;
            const double var_x492 = pow(var_x491, 4);
            const double var_x493 = 7.2087469970547496e-9 * pow(var_x491, 7) / pow((1 + 0.0085573053764671191 * var_x492), 2);
            const double var_x494 = 50.118419258935766 * pow(var_x491, 3) / (59494197.640692554 + 509110.01733929582 * var_x492);
            const double var_x495 = var_x139 * var_x493 - var_x139 * var_x494;
            
            partialF = -0.14749262536873156 + var_x495 + 2.4740119415402899e-16 * var_x163 + 1.3314155043174696e-5 * var_x155 - 3.4616803112254212e-5 * var_x159 - 7.1319396379664657e-10 * var_x156 - 0.0016481422714144972 * var_x164 - 1.0712924764194231e-5 * var_x157 - 0.0035983988805915112 * var_x166;
        }
        else
        {
            const double y_save = rY[42];
            rY[42] += delta;
            const double temp = EvaluateYDerivative42(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[42])/delta;
            rY[42] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative43(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Na__Na_ss_sr = rY[43];
        // Units: mM; Initial value: 6.935607
        
        
        // Mathematics
        const double var_Na__Idiff_Na = 5.0 * var_chaste_interface__Na__Na_ss_sr - 5.0 * var_chaste_interface__Na__Na_i; // mM_per_ms
        const double var_cell_geometry__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell_geometry__Vss_sr = 0.02 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__AF = 5.0618217998279567e-10 * M_PI; // uF_mole_per_C
        const double var_INaCa__INaCa_ss_sr = (1.6200000000000001 * pow(var_chaste_interface__Na__Na_ss_sr, 3) * exp(0.010107898065447322 * var_chaste_interface__membrane__Vm) - 2469600.0 * var_chaste_interface__Ca__Ca_ss_sr * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) / ((1.0 + 0.32000000000000001 * exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm)) * (1.0 + 1.5624999999999999e-8 / pow(var_chaste_interface__Ca__Ca_ss_sr, 2)) * (13227.9606 + 8.4084932990912282 * pow(var_chaste_interface__Na__Na_ss_sr, 3) + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr)); // uA_per_uF
        const double d_dt_chaste_interface_var_Na__Na_ss_sr = -var_Na__Idiff_Na - 3.0 * var_INaCa__INaCa_ss_sr * var_cell_geometry__AF / var_cell_geometry__Vss_sr; // mM / ms

        return d_dt_chaste_interface_var_Na__Na_ss_sr;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative43(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
            // Units: mM; Initial value: 9.04757e-05
            double var_chaste_interface__Na__Na_ss_sr = rY[43];
            // Units: mM; Initial value: 6.935607
            
            const double var_x57 = exp(-0.027328761436209426 * var_chaste_interface__membrane__Vm);
            const double var_x58 = 1.0 + 0.32000000000000001 * var_x57;
            const double var_x59 = 1 / var_x58;
            const double var_x62 = exp(0.010107898065447322 * var_chaste_interface__membrane__Vm);
            const double var_x70 = pow(var_chaste_interface__Na__Na_ss_sr, 3);
            const double var_x71 = var_x62 * var_x70;
            const double var_x72 = var_x57 * var_chaste_interface__Ca__Ca_ss_sr;
            const double var_x73 = pow(var_chaste_interface__Ca__Ca_ss_sr, (-2));
            const double var_x74 = 1.0 + 1.5624999999999999e-8 * var_x73;
            const double var_x75 = 1 / var_x74;
            const double var_x76 = 1 / (13227.9606 + 8.4084932990912282 * var_x70 + 4344355.375 * var_chaste_interface__Ca__Ca_ss_sr);
            const double var_x77 = var_x75 * var_x76;
            const double var_x116 = 1.6200000000000001 * var_x71 - 2469600.0 * var_x72;
            const double var_x152 = var_x116 * var_x75 / pow((0.0030448615405916234 + 1.9354984970793804e-6 * var_x70 + var_chaste_interface__Ca__Ca_ss_sr), 2);
            const double var_x165 = var_x59 * var_x62;
            const double var_x167 = pow(var_chaste_interface__Na__Na_ss_sr, 2);
            const double var_x168 = var_x152 * var_x59;
            const double var_x169 = var_x167 * var_x168;
            const double var_x170 = var_x165 * var_x167 * var_x77;
            
            partialF = -5.0 + 8.386900481821583e-15 * var_x169 - 0.030496430513013057 * var_x170;
        }
        else
        {
            const double y_save = rY[43];
            rY[43] += delta;
            const double temp = EvaluateYDerivative43(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[43])/delta;
            rY[43] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative44(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Cl__Cl_i = rY[44];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__Cl__Cl_ss = rY[45];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = rY[46];
        // Units: mM; Initial value: 145.5689
        
        
        // Mathematics
        const double var_Cl__Idiff_Cl = 5.0 * var_chaste_interface__Cl__Cl_ss - 5.0 * var_chaste_interface__Cl__Cl_i; // mM_per_ms
        const double var_cell_geometry__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell_geometry__Vmyo = 0.67800000000000005 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__Vss_sr = 0.02 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__AF = 5.0618217998279567e-10 * M_PI; // uF_mole_per_C
        const double var_reversal_potentials__ECl = -26.711785007306684 * log(100.0 / var_chaste_interface__Cl__Cl_i); // mV
        const double var_IClb__IClb = 0.00022499999999999999 * var_chaste_interface__membrane__Vm - 0.00022499999999999999 * var_reversal_potentials__ECl; // uA_per_uF
        const double var_reversal_potentials__EK = 26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_CT_K_Cl__CT_K_Cl = 1.77e-5 * (-var_reversal_potentials__ECl + var_reversal_potentials__EK) / (87.825100000000006 - var_reversal_potentials__ECl + var_reversal_potentials__EK); // mM_per_ms
        const double var_reversal_potentials__ENa = 26.711785007306684 * log(140.0 / var_chaste_interface__Na__Na_i); // mV
        const double var_CT_Na_Cl__CT_Na_Cl = 2.4610800000000002e-5 * pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4) / (59494197.640692554 + pow((-var_reversal_potentials__ECl + var_reversal_potentials__ENa), 4)); // mM_per_ms
        const double d_dt_chaste_interface_var_Cl__Cl_i = var_Cl__Idiff_Cl * var_cell_geometry__Vss_sr / var_cell_geometry__Vmyo + var_IClb__IClb * var_cell_geometry__AF / var_cell_geometry__Vmyo + var_CT_K_Cl__CT_K_Cl + var_CT_Na_Cl__CT_Na_Cl; // mM / ms

        return d_dt_chaste_interface_var_Cl__Cl_i;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative44(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Na__Na_i = rY[42];
            // Units: mM; Initial value: 6.935575
            double var_chaste_interface__Cl__Cl_i = rY[44];
            // Units: mM; Initial value: 20.26842
            double var_chaste_interface__K__K_i = rY[46];
            // Units: mM; Initial value: 145.5689
            
            const double var_x19 = 1 / var_chaste_interface__K__K_i;
            const double var_x20 = log(5.4000000000000004 * var_x19);
            const double var_x39 = 26.711785007306684 * var_x20;
            const double var_x139 = 1 / var_chaste_interface__Na__Na_i;
            const double var_x140 = log(140.0 * var_x139);
            const double var_x171 = 1 / var_chaste_interface__Cl__Cl_i;
            const double var_x490 = log(100.0 * var_x171);
            const double var_x491 = var_x140 + var_x490;
            const double var_x492 = pow(var_x491, 4);
            const double var_x493 = 7.2087469970547496e-9 * pow(var_x491, 7) / pow((1 + 0.0085573053764671191 * var_x492), 2);
            const double var_x494 = 50.118419258935766 * pow(var_x491, 3) / (59494197.640692554 + 509110.01733929582 * var_x492);
            const double var_x496 = var_x171 * var_x493 - var_x171 * var_x494;
            const double var_x497 = var_x39 + 26.711785007306684 * var_x490;
            const double var_x498 = 0.00047279859462932828 / (87.825100000000006 + var_x497);
            const double var_x499 = 6.1296950776416711e-8 * var_x497 / pow((1 + 0.30414750461208334 * var_x20 + 0.30414750461208334 * var_x490), 2);
            const double var_x500 = var_x171 * var_x499 - var_x171 * var_x498;
            
            partialF = -0.14749262536873156 + var_x496 + var_x500 - 3.7083201106826184e-7 * var_x171;
        }
        else
        {
            const double y_save = rY[44];
            rY[44] += delta;
            const double temp = EvaluateYDerivative44(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[44])/delta;
            rY[44] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative45(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ito2_i2f_gate__i2f = rY[36];
        // Units: dimensionless; Initial value: 0.9960352
        double var_chaste_interface__Irel__Irel = rY[37];
        // Units: mM_per_ms; Initial value: 0.00107332
        double var_chaste_interface__Cl__Cl_i = rY[44];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__Cl__Cl_ss = rY[45];
        // Units: mM; Initial value: 20.26842
        
        
        // Mathematics
        const double var_Cl__Idiff_Cl = 5.0 * var_chaste_interface__Cl__Cl_ss - 5.0 * var_chaste_interface__Cl__Cl_i; // mM_per_ms
        const double var_cell_geometry__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell_geometry__Vss_sr = 0.02 * var_cell_geometry__vcell; // uL
        const double var_cell_geometry__AF = 5.0618217998279567e-10 * M_PI; // uF_mole_per_C
        const double var_Ito2__Ito2 = 0.0032509358688027189 * (1.0 - 1.0 / (1.0 + 6.2499999999999991 * pow(var_chaste_interface__Irel__Irel, 2))) * (-100.0 * exp(0.037436659501656748 * var_chaste_interface__membrane__Vm) + var_chaste_interface__Cl__Cl_i) * var_chaste_interface__Ito2_i2f_gate__i2f * var_chaste_interface__membrane__Vm / (1.0 - exp(0.037436659501656748 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double d_dt_chaste_interface_var_Cl__Cl_ss = -var_Cl__Idiff_Cl + var_Ito2__Ito2 * var_cell_geometry__AF / var_cell_geometry__Vss_sr; // mM / ms

        return d_dt_chaste_interface_var_Cl__Cl_ss;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative45(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -5.0;
        }
        else
        {
            const double y_save = rY[45];
            rY[45] += delta;
            const double temp = EvaluateYDerivative45(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[45])/delta;
            rY[45] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative46(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: mV; Initial value: -87.472528
        double var_chaste_interface__Ca__Ca_i = rY[1];
        // Units: mM; Initial value: 7.09945e-05
        double var_chaste_interface__IKs__O1 = rY[17];
        // Units: dimensionless; Initial value: 1.051906959485266e-05
        double var_chaste_interface__IKs__O2 = rY[18];
        // Units: dimensionless; Initial value: 2.372219883411999e-06
        double var_chaste_interface__IKr_xr_gate__xr = rY[32];
        // Units: dimensionless; Initial value: 1.235996442041028e-08
        double var_chaste_interface__Ito1_a_gate__a = rY[33];
        // Units: dimensionless; Initial value: 1.773318268499115e-05
        double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
        // Units: dimensionless; Initial value: 0.9979722
        double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
        // Units: dimensionless; Initial value: 0.9874435
        double var_chaste_interface__Na__Na_i = rY[42];
        // Units: mM; Initial value: 6.935575
        double var_chaste_interface__Cl__Cl_i = rY[44];
        // Units: mM; Initial value: 20.26842
        double var_chaste_interface__K__K_i = rY[46];
        // Units: mM; Initial value: 145.5689
        
        
        // Mathematics
        const double var_cell_geometry__vcell = 1.2100000000000001e-5 * M_PI; // uL
        const double var_cell_geometry__Vmyo = 0.67800000000000005 * var_cell_geometry__vcell; // uL
        const double var_membrane__i_Stim = GetIntracellularAreaStimulus(var_chaste_interface__environment__time) / HeartConfig::Instance()->GetCapacitance(); // uA_per_uF
        const double var_cell_geometry__AF = 5.0618217998279567e-10 * M_PI; // uF_mole_per_C
        const double var_INaK__INaK = 0.062337970750628316 * pow(var_chaste_interface__Na__Na_i, 3) / (pow((1 + 0.38461538461538458 * var_chaste_interface__Na__Na_i), 3) * (1.0 + exp(-3.4441726741524206 - 0.037436659501656748 * var_chaste_interface__membrane__Vm))); // uA_per_uF
        const double var_reversal_potentials__ECl = -26.711785007306684 * log(100.0 / var_chaste_interface__Cl__Cl_i); // mV
        const double var_reversal_potentials__EK = 26.711785007306684 * log(5.4000000000000004 / var_chaste_interface__K__K_i); // mV
        const double var_CT_K_Cl__CT_K_Cl = 1.77e-5 * (-var_reversal_potentials__ECl + var_reversal_potentials__EK) / (87.825100000000006 - var_reversal_potentials__ECl + var_reversal_potentials__EK); // mM_per_ms
        const double var_IK1__IK1 = 0.51000000000000001 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) / ((1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)) * (1.02 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 0.23849999999999999 * var_reversal_potentials__EK)) + (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 0.080320000000000003 * var_reversal_potentials__EK) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 0.061749999999999999 * var_reversal_potentials__EK)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_reversal_potentials__EK - 0.51429999999999998 * var_chaste_interface__membrane__Vm)))); // uA_per_uF
        const double var_IKp__IKp = 0.0027599999999999999 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_IKr__IKr = 1.0 * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * mParameters[2] * var_chaste_interface__IKr_xr_gate__xr / (1.0 + exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm)); // uA_per_uF
        const double var_Ito1__Ito1 = 0.4975 * pow(var_chaste_interface__Ito1_a_gate__a, 3) * (-var_reversal_potentials__EK + var_chaste_interface__membrane__Vm) * var_chaste_interface__Ito1_i1f_gate__i1f * var_chaste_interface__Ito1_i1s_gate__i1s * exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm); // uA_per_uF
        const double var_IKs__IKs = (0.082600000000000007 + 0.04956 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__Ca__Ca_i, 1.3999999999999999))) * (-26.711785007306684 * log(7.9662000000000006 / (0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i)) + var_chaste_interface__membrane__Vm) * (var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2); // uA_per_uF
        const double d_dt_chaste_interface_var_K__K_i = -(-2.0 * var_INaK__INaK + var_IK1__IK1 + var_IKp__IKp + var_IKr__IKr + var_IKs__IKs + var_Ito1__Ito1 + var_membrane__i_Stim) * var_cell_geometry__AF / var_cell_geometry__Vmyo + var_CT_K_Cl__CT_K_Cl; // mM / ms

        return d_dt_chaste_interface_var_K__K_i;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative46(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__Vm = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: mV; Initial value: -87.472528
            double var_chaste_interface__Ca__Ca_i = rY[1];
            // Units: mM; Initial value: 7.09945e-05
            double var_chaste_interface__IKs__O1 = rY[17];
            // Units: dimensionless; Initial value: 1.051906959485266e-05
            double var_chaste_interface__IKs__O2 = rY[18];
            // Units: dimensionless; Initial value: 2.372219883411999e-06
            double var_chaste_interface__IKr_xr_gate__xr = rY[32];
            // Units: dimensionless; Initial value: 1.235996442041028e-08
            double var_chaste_interface__Ito1_a_gate__a = rY[33];
            // Units: dimensionless; Initial value: 1.773318268499115e-05
            double var_chaste_interface__Ito1_i1f_gate__i1f = rY[34];
            // Units: dimensionless; Initial value: 0.9979722
            double var_chaste_interface__Ito1_i1s_gate__i1s = rY[35];
            // Units: dimensionless; Initial value: 0.9874435
            double var_chaste_interface__Na__Na_i = rY[42];
            // Units: mM; Initial value: 6.935575
            double var_chaste_interface__Cl__Cl_i = rY[44];
            // Units: mM; Initial value: 20.26842
            double var_chaste_interface__K__K_i = rY[46];
            // Units: mM; Initial value: 145.5689
            
            const double var_x0 = exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__Vm);
            const double var_x1 = 1.0 + var_x0;
            const double var_x2 = 1 / var_x1;
            const double var_x3 = 1 / var_chaste_interface__Ca__Ca_i;
            const double var_x4 = pow(var_x3, 1.3999999999999999);
            const double var_x5 = 1.0 + 6.4818210260626455e-7 * var_x4;
            const double var_x6 = 1 / var_x5;
            const double var_x8 = var_chaste_interface__IKs__O1 + var_chaste_interface__IKs__O2;
            const double var_x19 = 1 / var_chaste_interface__K__K_i;
            const double var_x20 = log(5.4000000000000004 * var_x19);
            const double var_x21 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__Vm - 6.3707607242426434 * var_x20);
            const double var_x22 = 1.0 + var_x21;
            const double var_x23 = 1 / var_x22;
            const double var_x24 = exp(-2.4444678999999998 + 13.737871029257827 * var_x20 - 0.51429999999999998 * var_chaste_interface__membrane__Vm);
            const double var_x25 = 1.0 + var_x24;
            const double var_x26 = 1 / var_x25;
            const double var_x27 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__Vm - 2.1454905717868731 * var_x20);
            const double var_x28 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__Vm - 1.6494527242011876 * var_x20);
            const double var_x29 = var_x28 + 0.49124000000000001 * var_x27;
            const double var_x30 = var_x26 * var_x29;
            const double var_x31 = 1 / (var_x30 + 1.02 * var_x23);
            const double var_x32 = var_x23 * var_x31;
            const double var_x39 = 26.711785007306684 * var_x20;
            const double var_x40 = -var_x39 + var_chaste_interface__membrane__Vm;
            const double var_x42 = exp(0.64935064935064934 + 0.064935064935064929 * var_chaste_interface__membrane__Vm);
            const double var_x43 = 1.0 + var_x42;
            const double var_x44 = mParameters[2] / var_x43;
            const double var_x54 = var_x21 / pow(var_x22, 2);
            const double var_x55 = var_x31 * var_x40;
            const double var_x79 = pow(var_chaste_interface__Ito1_a_gate__a, 3);
            const double var_x80 = exp(0.0018181818181818182 * var_chaste_interface__membrane__Vm);
            const double var_x81 = var_x79 * var_x80 * var_chaste_interface__Ito1_i1s_gate__i1s;
            const double var_x95 = var_x24 * var_x29 / pow(var_x25, 2);
            const double var_x97 = var_x23 * var_x40 / pow((var_x23 + 0.98039215686274506 * var_x30), 2);
            const double var_x132 = 0.018329999999999999 * var_chaste_interface__Na__Na_i + var_chaste_interface__K__K_i;
            const double var_x160 = (0.12553036579548593 * var_chaste_interface__K__K_i + 0.002300971605031257 * var_chaste_interface__Na__Na_i) / pow(var_x132, 2);
            const double var_x171 = 1 / var_chaste_interface__Cl__Cl_i;
            const double var_x173 = var_x19 * var_x2;
            const double var_x174 = var_x19 * var_x32;
            const double var_x175 = var_x19 * var_x54;
            const double var_x176 = 6.4981759387274964 * var_x175 - var_x26 * (1.0539507884845836 * var_x19 * var_x27 + 1.6494527242011876 * var_x19 * var_x28) - 13.737871029257827 * var_x19 * var_x95;
            const double var_x177 = var_x19 * var_x44 * var_chaste_interface__IKr_xr_gate__xr;
            const double var_x178 = var_x175 * var_x55;
            const double var_x179 = var_x19 * var_x81 * var_chaste_interface__Ito1_i1f_gate__i1f;
            const double var_x490 = log(100.0 * var_x171);
            const double var_x497 = var_x39 + 26.711785007306684 * var_x490;
            const double var_x498 = 0.00047279859462932828 / (87.825100000000006 + var_x497);
            const double var_x499 = 6.1296950776416711e-8 * var_x497 / pow((1 + 0.30414750461208334 * var_x20 + 0.30414750461208334 * var_x490), 2);
            const double var_x501 = var_x19 * var_x499 - var_x19 * var_x498;
            const double var_x503 = -5.0964977286841363e-6 - 3.0578986372104813e-6 * var_x6;
            const double var_x504 = var_x503 * var_x8;
            const double var_x507 = 3.0245559326093954e-5 * var_x97;
            const double var_x509 = var_x160 * var_x504;
            
            partialF = var_x501 + 212.7914217252065 * var_x509 + 0.00020047178518350236 * var_x178 - 4.5488726691040119e-6 * var_x173 - 0.00081995078002871237 * var_x179 - 0.0016481422714144972 * var_x177 - 0.0008405525584213936 * var_x174 - var_x176 * var_x507;
        }
        else
        {
            const double y_save = rY[46];
            rY[46] += delta;
            const double temp = EvaluateYDerivative46(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[46])/delta;
            rY[46] = y_save;
        }
        return partialF;
    }
    double Celldecker_2009FromCellMLGRL1Opt::EvaluateYDerivative47(double var_chaste_interface__environment__time, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
        // Units: mM; Initial value: 9.04757e-05
        double var_chaste_interface__CaMK_active__CaMK_trap = rY[47];
        // Units: dimensionless; Initial value: 0.0018861341
        
        
        // Mathematics
        const double var_CaMK_active__CaMK_active = 0.050000000000000003 * (1.0 - var_chaste_interface__CaMK_active__CaMK_trap) / (1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr) + var_chaste_interface__CaMK_active__CaMK_trap; // dimensionless
        const double d_dt_chaste_interface_var_CaMK_active__CaMK_trap = -0.00068000000000000005 * var_chaste_interface__CaMK_active__CaMK_trap + 0.050000000000000003 * (-var_chaste_interface__CaMK_active__CaMK_trap + var_CaMK_active__CaMK_active) * var_CaMK_active__CaMK_active; // 1 / ms

        return d_dt_chaste_interface_var_CaMK_active__CaMK_trap;
    }

    double Celldecker_2009FromCellMLGRL1Opt::EvaluatePartialDerivative47(double var_chaste_interface__environment__time, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca__Ca_ss_sr = rY[40];
            // Units: mM; Initial value: 9.04757e-05
            double var_chaste_interface__CaMK_active__CaMK_trap = rY[47];
            // Units: dimensionless; Initial value: 0.0018861341
            
            const double var_x188 = 1.0 - var_chaste_interface__CaMK_active__CaMK_trap;
            const double var_x189 = 1.0 + 0.0015 / var_chaste_interface__Ca__Ca_ss_sr;
            const double var_x190 = 1 / var_x189;
            const double var_x191 = 0.050000000000000003 * var_x190;
            const double var_x192 = var_x188 * var_x191;
            const double var_x195 = var_x192 + var_chaste_interface__CaMK_active__CaMK_trap;
            const double var_x213 = 1 - var_x191;
            const double var_x510 = 0.0025000000000000005 * var_x190;
            
            partialF = -0.00068000000000000005 - var_x195 * var_x510 + var_x188 * var_x213 * var_x510;
        }
        else
        {
            const double y_save = rY[47];
            rY[47] += delta;
            const double temp = EvaluateYDerivative47(var_chaste_interface__environment__time, rY);
            partialF = (temp-mEvalF[47])/delta;
            rY[47] = y_save;
        }
        return partialF;
    }

    std::vector<double> Celldecker_2009FromCellMLGRL1Opt::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        std::vector<double> dqs(2);
        dqs[0] = var_chaste_interface__environment__time;
        dqs[1] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Celldecker_2009FromCellMLGRL1Opt>::Initialise(void)
{
    this->mSystemName = "decker_2009";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "ms";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("mV");
    this->mInitialConditions.push_back(-87.472528);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(7.09945e-05);

    // rY[2]:
    this->mVariableNames.push_back("IKs__C1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.476653873938053);

    // rY[3]:
    this->mVariableNames.push_back("IKs__C2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.2551771850026437);

    // rY[4]:
    this->mVariableNames.push_back("IKs__C3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.05122852186842027);

    // rY[5]:
    this->mVariableNames.push_back("IKs__C4");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.004570874421666423);

    // rY[6]:
    this->mVariableNames.push_back("IKs__C5");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001529389211563687);

    // rY[7]:
    this->mVariableNames.push_back("IKs__C6");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1328281770413747);

    // rY[8]:
    this->mVariableNames.push_back("IKs__C7");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.05333228495514583);

    // rY[9]:
    this->mVariableNames.push_back("IKs__C8");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.007137874613383642);

    // rY[10]:
    this->mVariableNames.push_back("IKs__C9");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0003184390970637536);

    // rY[11]:
    this->mVariableNames.push_back("IKs__C10");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01388061042363991);

    // rY[12]:
    this->mVariableNames.push_back("IKs__C11");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.003715500164470033);

    // rY[13]:
    this->mVariableNames.push_back("IKs__C12");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0002486371465457659);

    // rY[14]:
    this->mVariableNames.push_back("IKs__C13");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0006446803014431032);

    // rY[15]:
    this->mVariableNames.push_back("IKs__C14");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(8.628258026770862e-05);

    // rY[16]:
    this->mVariableNames.push_back("IKs__C15");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.122823524761588e-05);

    // rY[17]:
    this->mVariableNames.push_back("IKs__O1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.051906959485266e-05);

    // rY[18]:
    this->mVariableNames.push_back("IKs__O2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.372219883411999e-06);

    // rY[19]:
    this->mVariableNames.push_back("ICaL__C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9999613782488198);

    // rY[20]:
    this->mVariableNames.push_back("ICaL__O");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.27419494597377e-05);

    // rY[21]:
    this->mVariableNames.push_back("ICaL__C_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(5.936477396599124e-11);

    // rY[22]:
    this->mVariableNames.push_back("ICaL__O_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.350122566369778e-15);

    // rY[23]:
    this->mVariableNames.push_back("ICaL__CI");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.587938121237188e-05);

    // rY[24]:
    this->mVariableNames.push_back("ICaL__OI");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.611420243201921e-10);

    // rY[25]:
    this->mVariableNames.push_back("ICaL__CI_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[26]:
    this->mVariableNames.push_back("ICaL__OI_star");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // rY[27]:
    this->mVariableNames.push_back("INa_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001022252813581797);

    // rY[28]:
    this->mVariableNames.push_back("INa_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9913109066867);

    // rY[29]:
    this->mVariableNames.push_back("INa_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9970771239754529);

    // rY[30]:
    this->mVariableNames.push_back("INaL_mL_gate__mL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.001022252813581797);

    // rY[31]:
    this->mVariableNames.push_back("INaL_hL_gate__hL");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.3593255076983574);

    // rY[32]:
    this->mVariableNames.push_back("IKr_xr_gate__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.235996442041028e-08);

    // rY[33]:
    this->mVariableNames.push_back("Ito1_a_gate__a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.773318268499115e-05);

    // rY[34]:
    this->mVariableNames.push_back("Ito1_i1f_gate__i1f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9979722);

    // rY[35]:
    this->mVariableNames.push_back("Ito1_i1s_gate__i1s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9874435);

    // rY[36]:
    this->mVariableNames.push_back("Ito2_i2f_gate__i2f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9960352);

    // rY[37]:
    this->mVariableNames.push_back("Irel__Irel");
    this->mVariableUnits.push_back("mM_per_ms");
    this->mInitialConditions.push_back(0.00107332);

    // rY[38]:
    this->mVariableNames.push_back("Ca__Ca_JSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.917692717);

    // rY[39]:
    this->mVariableNames.push_back("Ca__Ca_NSR");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(0.929835335);

    // rY[40]:
    this->mVariableNames.push_back("Ca__Ca_ss_sr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(9.04757e-05);

    // rY[41]:
    this->mVariableNames.push_back("Ca__Ca_ss_CaL");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(9.61545e-05);

    // rY[42]:
    this->mVariableNames.push_back("Na__Na_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(6.935575);

    // rY[43]:
    this->mVariableNames.push_back("Na__Na_ss_sr");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(6.935607);

    // rY[44]:
    this->mVariableNames.push_back("Cl__Cl_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(20.26842);

    // rY[45]:
    this->mVariableNames.push_back("Cl__Cl_ss");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(20.26842);

    // rY[46]:
    this->mVariableNames.push_back("K__K_i");
    this->mVariableUnits.push_back("mM");
    this->mInitialConditions.push_back(145.5689);

    // rY[47]:
    this->mVariableNames.push_back("CaMK_active__CaMK_trap");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0018861341);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("L_per_F_ms");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("mS_per_uF");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("mS_per_uF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("ms");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Celldecker_2009FromCellMLGRL1Opt)

