//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: aslanidi_model_2009
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "aslanidi_model_2009.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellaslanidi_model_2009FromCellMLGRL1Opt::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_chaste_interface__membrane__stim_amplitude_converted = -1.9999999999999998e-5 * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 0.20000000000000001; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 500.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 10.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    Cellaslanidi_model_2009FromCellMLGRL1Opt::Cellaslanidi_model_2009FromCellMLGRL1Opt(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                29,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellaslanidi_model_2009FromCellMLGRL1Opt>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 5.0000000000000002e-5; // (var_membrane__Cm) [nanoF]
    }

    Cellaslanidi_model_2009FromCellMLGRL1Opt::~Cellaslanidi_model_2009FromCellMLGRL1Opt()
    {
    }
    
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.01309
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.706
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.61493
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 3e-05
        double var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.99981
        double var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.00046
        double var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.30752
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 6e-05
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = rY[9];
        // Units: dimensionless; Initial value: 0.5753
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = rY[10];
        // Units: dimensionless; Initial value: 0.39871
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = rY[11];
        // Units: dimensionless; Initial value: 0.57363
        double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = rY[12];
        // Units: dimensionless; Initial value: 0.02032
        double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.00016
        double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = rY[14];
        // Units: dimensionless; Initial value: 0.76898
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[17];
        // Units: millimolar; Initial value: 100.0
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
        // Units: millimolar; Initial value: 5.0
        
        const double var_environment__PM = 0; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__E_K = 26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i); // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_sus = ((var_environment__PM == 0) ? (0.098000000000000004 + 0.0014 * var_chaste_interface__membrane__V) : (0.070000000000000007 + 0.001 * var_chaste_interface__membrane__V)); // picoA
        const double var_Ca_independent_transient_outward_K_current__i_to = ((var_environment__PM == 0) ? (0.0100004 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r) : (0.050001999999999998 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r)); // picoA
        const double var_L_type_Ca_channel__i_Ca_L = ((var_environment__PM == 0) ? (0.0072000000000000007 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L)) : (0.0040000000000000001 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L))); // picoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = 2.0000000000000002e-5 * (2.5 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.016955889611951675 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.02072386508127427 * var_chaste_interface__membrane__V)) / (1.0 + 0.00074999999999999991 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_T_type_Ca_channel__i_Ca_T = 0.0060000000000000001 * (-38.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T; // picoA
        const double var_background_currents__i_B_Ca = ((var_environment__PM == 0) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 0.0002653945091048535 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i)) : (3.1000000000000001e-5 * var_chaste_interface__membrane__V - 0.00041136148911252295 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i))); // picoA
        const double var_delayed_rectifier_K_current__i_Kr = 0.0035000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i; // picoA
        const double var_delayed_rectifier_K_current__i_Ks = 0.0025000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_z_gate__z; // picoA
        const double var_inward_rectifier__i_K1 = ((var_environment__PM == 0) ? (0.010160000000000001 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3))) : (0.0050800000000000003 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3)))); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP = 0.0095090000000000001 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_sodium_current__E_Na = 26.53945091048535 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i); // millivolt
        const double var_background_currents__i_B_Na = ((var_environment__PM == 0) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 2.0000000000000002e-5 * var_sodium_current__E_Na) : (6.3999999999999997e-5 * var_chaste_interface__membrane__V - 6.3999999999999997e-5 * var_sodium_current__E_Na)); // picoA
        const double var_sodium_current__i_Na = 0.71257887225271721 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V - 0.037679754693225945 * var_sodium_current__E_Na)) * (0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__membrane__V / (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V)); // picoA
        const double var_sodium_potassium_pump__i_p = 0.10305599999999999 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // picoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_Ca_independent_transient_outward_K_current__i_sus + var_Ca_independent_transient_outward_K_current__i_to + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_T_type_Ca_channel__i_Ca_T + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_delayed_rectifier_K_current__i_Kr + var_delayed_rectifier_K_current__i_Ks + var_inward_rectifier__i_K1 + var_sarcolemmal_calcium_pump_current__i_CaP + var_sodium_current__i_Na + var_sodium_potassium_pump__i_p) * HeartConfig::Instance()->GetCapacitance() / mParameters[0]; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellaslanidi_model_2009FromCellMLGRL1Opt::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;

        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.01309
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.706
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.61493
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 3e-05
        double var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.99981
        double var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.00046
        double var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.30752
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 6e-05
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = rY[9];
        // Units: dimensionless; Initial value: 0.5753
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = rY[10];
        // Units: dimensionless; Initial value: 0.39871
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = rY[11];
        // Units: dimensionless; Initial value: 0.57363
        double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = rY[12];
        // Units: dimensionless; Initial value: 0.02032
        double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.00016
        double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = rY[14];
        // Units: dimensionless; Initial value: 0.76898
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[17];
        // Units: millimolar; Initial value: 100.0
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
        // Units: millimolar; Initial value: 5.0
        

        // Mathematics
        const double var_environment__PM = 0; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__E_K = 26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i); // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_sus = ((var_environment__PM == 0) ? (0.098000000000000004 + 0.0014 * var_chaste_interface__membrane__V) : (0.070000000000000007 + 0.001 * var_chaste_interface__membrane__V)); // picoA
        const double var_Ca_independent_transient_outward_K_current__i_to = ((var_environment__PM == 0) ? (0.0100004 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r) : (0.050001999999999998 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r)); // picoA
        const double var_L_type_Ca_channel__i_Ca_L = ((var_environment__PM == 0) ? (0.0072000000000000007 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L)) : (0.0040000000000000001 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L))); // picoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = 2.0000000000000002e-5 * (2.5 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.016955889611951675 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.02072386508127427 * var_chaste_interface__membrane__V)) / (1.0 + 0.00074999999999999991 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_T_type_Ca_channel__i_Ca_T = 0.0060000000000000001 * (-38.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T; // picoA
        const double var_background_currents__i_B_Ca = ((var_environment__PM == 0) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 0.0002653945091048535 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i)) : (3.1000000000000001e-5 * var_chaste_interface__membrane__V - 0.00041136148911252295 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i))); // picoA
        const double var_delayed_rectifier_K_current__i_Kr = 0.0035000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i; // picoA
        const double var_delayed_rectifier_K_current__i_Ks = 0.0025000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_z_gate__z; // picoA
        const double var_inward_rectifier__i_K1 = ((var_environment__PM == 0) ? (0.010160000000000001 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3))) : (0.0050800000000000003 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3)))); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP = 0.0095090000000000001 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_sodium_current__E_Na = 26.53945091048535 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i); // millivolt
        const double var_background_currents__i_B_Na = ((var_environment__PM == 0) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 2.0000000000000002e-5 * var_sodium_current__E_Na) : (6.3999999999999997e-5 * var_chaste_interface__membrane__V - 6.3999999999999997e-5 * var_sodium_current__E_Na)); // picoA
        const double var_sodium_current__i_Na = 0.71257887225271721 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V - 0.037679754693225945 * var_sodium_current__E_Na)) * (0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__membrane__V / (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V)); // picoA
        const double var_sodium_potassium_pump__i_p = 0.10305599999999999 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // picoA
        d_dt_chaste_interface_var_membrane__V = -0.001 * (1000.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted) * mParameters[0] / HeartConfig::Instance()->GetCapacitance() + var_Ca_independent_transient_outward_K_current__i_sus + var_Ca_independent_transient_outward_K_current__i_to + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_T_type_Ca_channel__i_Ca_T + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_delayed_rectifier_K_current__i_Kr + var_delayed_rectifier_K_current__i_Ks + var_inward_rectifier__i_K1 + var_sarcolemmal_calcium_pump_current__i_CaP + var_sodium_current__i_Na + var_sodium_potassium_pump__i_p) / mParameters[0]; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Cellaslanidi_model_2009FromCellMLGRL1Opt::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta = 1e-8;

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.01309
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.706
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.61493
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 3e-05
        double var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.99981
        double var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.00046
        double var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.30752
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 6e-05
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = rY[9];
        // Units: dimensionless; Initial value: 0.5753
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = rY[10];
        // Units: dimensionless; Initial value: 0.39871
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = rY[11];
        // Units: dimensionless; Initial value: 0.57363
        double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = rY[12];
        // Units: dimensionless; Initial value: 0.02032
        double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.00016
        double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = rY[14];
        // Units: dimensionless; Initial value: 0.76898
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[17];
        // Units: millimolar; Initial value: 100.0
        double var_chaste_interface__intracellular_Ca_buffering__O_C = rY[18];
        // Units: dimensionless; Initial value: 0.029108
        double var_chaste_interface__intracellular_Ca_buffering__O_TC = rY[19];
        // Units: dimensionless; Initial value: 0.014071
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[20];
        // Units: dimensionless; Initial value: 0.214036
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[21];
        // Units: dimensionless; Initial value: 0.693565
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
        // Units: millimolar; Initial value: 5.0
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[23];
        // Units: millimolar; Initial value: 0.726776
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[24];
        // Units: millimolar; Initial value: 0.730866
        double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = rY[25];
        // Units: dimensionless; Initial value: 0.465921
        double var_chaste_interface__Ca_handling_by_the_SR__F1 = rY[26];
        // Units: dimensionless; Initial value: 0.288039
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[27];
        // Units: dimensionless; Initial value: 0.002262
        double var_chaste_interface__Ca_handling_by_the_SR__F3 = rY[28];
        // Units: dimensionless; Initial value: 0.612697
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__O_Calse_orig_deriv = -400.0 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse + 480.0 * (1.0 - var_chaste_interface__Ca_handling_by_the_SR__O_Calse) * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // 1 / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse = 0.001 * var_Ca_handling_by_the_SR__O_Calse_orig_deriv; // 1 / millisecond
        const double var_environment__PM = 0; // dimensionless
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg = 5.0 - 5.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC - 5.6660000000000004 * var_chaste_interface__intracellular_Ca_buffering__O_TMgMg; // 1 / millisecond
        const double var_Ca_handling_by_the_SR__i_rel = 200.0 * pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel) / pow((0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2), 2); // picoA
        const double var_Ca_handling_by_the_SR__i_up = 2.7999999999999998 * (3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 0.32000000000000006 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up) / (1.3999999999999999 + 0.80000000000000004 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + 3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_Ca_handling_by_the_SR__r_inact = 33.960000000000001 + 339.60000000000002 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F3 = -0.00081499999999999997 * var_chaste_interface__Ca_handling_by_the_SR__F3 + 0.001 * var_chaste_interface__Ca_handling_by_the_SR__F2 * var_Ca_handling_by_the_SR__r_inact; // 1 / millisecond
        const double var_intracellular_Ca_buffering__dOCdt = -476.0 * var_chaste_interface__intracellular_Ca_buffering__O_C + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_C) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // per_second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C = 0.001 * var_intracellular_Ca_buffering__dOCdt; // 1 / millisecond
        const double var_intracellular_Ca_buffering__dOTCdt = -392.0 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 78400.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TC) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // per_second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC = 0.001 * var_intracellular_Ca_buffering__dOTCdt; // 1 / millisecond
        const double var_intracellular_Ca_buffering__dOTMgCdt = -6.5999999999999996 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // per_second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC = 0.001 * var_intracellular_Ca_buffering__dOTMgCdt; // 1 / millisecond
        const double var_Ca_handling_by_the_SR__i_tr = 0.84908559999999988 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up - 0.84908559999999988 * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // picoA
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel = 0.11777375567316183 * var_Ca_handling_by_the_SR__i_tr - 0.11777375567316183 * var_Ca_handling_by_the_SR__i_rel - 0.031 * var_Ca_handling_by_the_SR__O_Calse_orig_deriv; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up = 0.01305629944474457 * var_Ca_handling_by_the_SR__i_up - 0.01305629944474457 * var_Ca_handling_by_the_SR__i_tr; // millimolar / millisecond
        const double var_Ca_independent_transient_outward_K_current__E_K = 26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i); // millivolt
        const double var_Ca_handling_by_the_SR__r_act = 240.0 * exp(-1.6000000000000001 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double var_Ca_independent_transient_outward_K_current__i_sus = ((var_environment__PM == 0) ? (0.098000000000000004 + 0.0014 * var_chaste_interface__membrane__V) : (0.070000000000000007 + 0.001 * var_chaste_interface__membrane__V)); // picoA
        const double var_Ca_independent_transient_outward_K_current__i_to = ((var_environment__PM == 0) ? (0.0100004 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r) : (0.050001999999999998 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r)); // picoA
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1 = 0.00081499999999999997 * var_chaste_interface__Ca_handling_by_the_SR__F3 - 0.001 * var_chaste_interface__Ca_handling_by_the_SR__F1 * var_Ca_handling_by_the_SR__r_act; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2 = 0.001 * var_chaste_interface__Ca_handling_by_the_SR__F1 * var_Ca_handling_by_the_SR__r_act - 0.001 * var_chaste_interface__Ca_handling_by_the_SR__F2 * var_Ca_handling_by_the_SR__r_inact; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r = 0.001 * (-var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r + 1 / (1.0 + exp(-2.6628794603230959 - 0.17752529735487307 * var_chaste_interface__membrane__V))) / (0.00040000000000000002 + 1 / (8.0109999999999992 * exp(-0.1388888888888889 * var_chaste_interface__membrane__V) + 386.60000000000002 * exp(0.083333333333333329 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s1_gate__s1 = 0.001 * (-var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 + 1 / (1.0 + exp(4.0070821529745047 + 0.14164305949008499 * var_chaste_interface__membrane__V))) / (0.020400000000000001 + 0.54659999999999997 / (1.0 + exp(327.99999999999994 + 10.0 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s2_gate__s2 = 0.001 * (-var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 + 1 / (1.0 + exp(4.0070821529745047 + 0.14164305949008499 * var_chaste_interface__membrane__V))) / (5.75 / (1.0 + exp(327.99999999999994 + 10.0 * var_chaste_interface__membrane__V)) + 0.45000000000000001 / (1.0 + exp(0.96921975662133131 - 0.071581961345740866 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s3_gate__s3 = 0.001 * (0.39975990396158467 - var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 + 0.60024009603841544 / (1.0 + exp(1.8506208911614319 + 0.036523009495982472 * var_chaste_interface__membrane__V))) / (0.5 + 7.5 / (1.0 + exp(46.0 + 2.0 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double var_L_type_Ca_channel__i_Ca_L = ((var_environment__PM == 0) ? (0.0072000000000000007 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L)) : (0.0040000000000000001 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L))); // picoA
        const double var_L_type_Ca_channel_d_L_gate__E10 = 10.0 + var_chaste_interface__membrane__V; // millivolt
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L = 0.001 * (-var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L + 1 / (1.0 + exp(-0.14393939393939395 - 0.15151515151515152 * var_L_type_Ca_channel_d_L_gate__E10))) * (4.4800000000000004 * (5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)) - 50.0 * var_L_type_Ca_channel_d_L_gate__E10 / (-1.0 + exp(-0.20798668885191349 * var_L_type_Ca_channel_d_L_gate__E10)) - 16.719999999999999 * (45.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-18.0 - 0.40000000000000002 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double var_L_type_Ca_channel_f_L_gate__E0_f_L = 18.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_L_type_Ca_channel_f_L_gate__alpha_f_L = 8.4900000000000002 * var_L_type_Ca_channel_f_L_gate__E0_f_L / (-1.0 + exp(0.25 * var_L_type_Ca_channel_f_L_gate__E0_f_L)); // per_second
        const double var_L_type_Ca_channel_f_L_gate__beta_f_L = 67.921999999999997 / (1.0 + exp(-0.25 * var_L_type_Ca_channel_f_L_gate__E0_f_L)); // per_second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_L_gate__f_L = 0.001 * (-var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L + var_L_type_Ca_channel_f_L_gate__alpha_f_L / (var_L_type_Ca_channel_f_L_gate__alpha_f_L + var_L_type_Ca_channel_f_L_gate__beta_f_L)) * (var_L_type_Ca_channel_f_L_gate__alpha_f_L + var_L_type_Ca_channel_f_L_gate__beta_f_L); // 1 / millisecond
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = 2.0000000000000002e-5 * (2.5 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.016955889611951675 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.02072386508127427 * var_chaste_interface__membrane__V)) / (1.0 + 0.00074999999999999991 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_T_type_Ca_channel__i_Ca_T = 0.0060000000000000001 * (-38.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T; // picoA
        const double var_T_type_Ca_channel_d_T_gate__E0_d_T = 23.300000000000001 + var_chaste_interface__membrane__V; // millivolt
        const double d_dt_chaste_interface_var_T_type_Ca_channel_d_T_gate__d_T = 0.001 * (-var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T + 1 / (1.0 + exp(0.049180327868852458 - 0.16393442622950821 * var_T_type_Ca_channel_d_T_gate__E0_d_T))) * (674.173 * exp(0.033333333333333333 * var_T_type_Ca_channel_d_T_gate__E0_d_T) + 674.173 * exp(-0.033333333333333333 * var_T_type_Ca_channel_d_T_gate__E0_d_T)); // 1 / millisecond
        const double var_T_type_Ca_channel_f_T_gate__E0_f_T = 75.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_T_type_Ca_channel_f_T_gate__alpha_f_T = 9.6370000000000005 * exp(-0.012004801920768308 * var_T_type_Ca_channel_f_T_gate__E0_f_T); // per_second
        const double var_T_type_Ca_channel_f_T_gate__beta_f_T = 9.6370000000000005 * exp(0.065019505851755519 * var_T_type_Ca_channel_f_T_gate__E0_f_T); // per_second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_f_T_gate__f_T = 0.001 * (-var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T + var_T_type_Ca_channel_f_T_gate__alpha_f_T / (var_T_type_Ca_channel_f_T_gate__alpha_f_T + var_T_type_Ca_channel_f_T_gate__beta_f_T)) * (var_T_type_Ca_channel_f_T_gate__alpha_f_T + var_T_type_Ca_channel_f_T_gate__beta_f_T); // 1 / millisecond
        const double var_background_currents__i_B_Ca = ((var_environment__PM == 0) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 0.0002653945091048535 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i)) : (3.1000000000000001e-5 * var_chaste_interface__membrane__V - 0.00041136148911252295 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i))); // picoA
        const double var_delayed_rectifier_K_current__i_Kr = 0.0035000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i; // picoA
        const double var_delayed_rectifier_K_current__i_Ks = 0.0025000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_z_gate__z; // picoA
        const double d_dt_chaste_interface_var_delayed_rectifier_K_current_pa_gate__p_a = 0.001 * (-var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a + 1 / (1.0 + exp(-0.68918918918918914 - 0.13513513513513511 * var_chaste_interface__membrane__V))) * (9.0 * exp(0.03941508020968823 * var_chaste_interface__membrane__V) + 1.3 * exp(-0.076769537847382163 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_delayed_rectifier_K_current_pi_gate__p_i = 0.001 * (-var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i + 1 / (1.0 + exp(2.539728728905752 + 0.05358970648917756 * var_chaste_interface__membrane__V))) * (100.0 * exp(-0.018299935950224173 * var_chaste_interface__membrane__V) + 656.0 * exp(0.009420009985210585 * var_chaste_interface__membrane__V)); // 1 / millisecond
        const double d_dt_chaste_interface_var_delayed_rectifier_K_current_z_gate__z = 0.001 * (-var_chaste_interface__delayed_rectifier_K_current_z_gate__z + 1 / (1.0 + exp(0.065217391304347824 - 0.072463768115942032 * var_chaste_interface__membrane__V))) / (0.059999999999999998 + 1 / (0.29999999999999999 * exp(-0.045816915605241454 * var_chaste_interface__membrane__V) + 1.6599999999999999 * exp(0.014398433450440593 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double var_inward_rectifier__i_K1 = ((var_environment__PM == 0) ? (0.010160000000000001 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3))) : (0.0050800000000000003 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3)))); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP = 0.0095090000000000001 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = 0.00088070109612833447 * var_Ca_handling_by_the_SR__i_rel + 0.0017614021922566689 * var_Na_Ca_ion_exchanger_current__i_NaCa - 8.0000000000000007e-5 * var_intracellular_Ca_buffering__dOTCdt - 0.00016000000000000001 * var_intracellular_Ca_buffering__dOTMgCdt - 4.4999999999999996e-5 * var_intracellular_Ca_buffering__dOCdt - 0.00088070109612833447 * var_Ca_handling_by_the_SR__i_up - 0.00088070109612833447 * var_L_type_Ca_channel__i_Ca_L - 0.00088070109612833447 * var_T_type_Ca_channel__i_Ca_T - 0.00088070109612833447 * var_background_currents__i_B_Ca - 0.00088070109612833447 * var_sarcolemmal_calcium_pump_current__i_CaP; // millimolar / millisecond
        const double var_sodium_current__E_Na = 26.53945091048535 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i); // millivolt
        const double var_background_currents__i_B_Na = ((var_environment__PM == 0) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 2.0000000000000002e-5 * var_sodium_current__E_Na) : (6.3999999999999997e-5 * var_chaste_interface__membrane__V - 6.3999999999999997e-5 * var_sodium_current__E_Na)); // picoA
        const double var_sodium_current_h1_gate__h_infinity = 44.899999999999999 * exp(-12.010771992818672 - 0.17953321364452424 * var_chaste_interface__membrane__V) / (1491.0 / (1.0 + 323.30000000000001 * exp(-7.333333333333333 - 0.077519379844961239 * var_chaste_interface__membrane__V)) + 44.899999999999999 * exp(-12.010771992818672 - 0.17953321364452424 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_sodium_current_h1_gate__h1 = 0.001 * (-var_chaste_interface__sodium_current_h1_gate__h1 + var_sodium_current_h1_gate__h_infinity) / (0.00014999999999999999 + 0.029999999999999999 / (1.0 + exp(6.666666666666667 + 0.16666666666666666 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double d_dt_chaste_interface_var_sodium_current_h2_gate__h2 = 0.001 * (-var_chaste_interface__sodium_current_h2_gate__h2 + var_sodium_current_h1_gate__h_infinity) / (0.00044999999999999999 + 0.12 / (1.0 + exp(30.0 + 0.5 * var_chaste_interface__membrane__V))); // 1 / millisecond
        const double var_sodium_current_m_gate__E0_m = 44.399999999999999 + var_chaste_interface__membrane__V; // millivolt
        const double var_sodium_current__i_Na = 0.71257887225271721 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V - 0.037679754693225945 * var_sodium_current__E_Na)) * (0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__membrane__V / (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V)); // picoA
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = -18.399999999999999 * var_chaste_interface__sodium_current_m_gate__m * exp(-0.078907914463820727 * var_sodium_current_m_gate__E0_m) - 0.46000000000000002 * (1.0 - var_chaste_interface__sodium_current_m_gate__m) * var_sodium_current_m_gate__E0_m / (-1.0 + exp(-0.078907914463820727 * var_sodium_current_m_gate__E0_m)); // 1 / millisecond
        const double var_sodium_potassium_pump__i_p = 0.10305599999999999 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // picoA
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c = 0.0041456361996952953 * var_Ca_independent_transient_outward_K_current__i_sus + 0.0041456361996952953 * var_Ca_independent_transient_outward_K_current__i_to + 0.0041456361996952953 * var_delayed_rectifier_K_current__i_Kr + 0.0041456361996952953 * var_delayed_rectifier_K_current__i_Ks + 0.0041456361996952953 * var_inward_rectifier__i_K1 - 0.0082912723993905906 * var_sodium_potassium_pump__i_p; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = 0.0016450937300378158 * var_sodium_potassium_pump__i_p - 0.00082254686501890791 * var_Ca_independent_transient_outward_K_current__i_sus - 0.00082254686501890791 * var_Ca_independent_transient_outward_K_current__i_to - 0.00082254686501890791 * var_delayed_rectifier_K_current__i_Kr - 0.00082254686501890791 * var_delayed_rectifier_K_current__i_Ks - 0.00082254686501890791 * var_inward_rectifier__i_K1; // millimolar / millisecond
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = -0.0024676405950567236 * var_Na_Ca_ion_exchanger_current__i_NaCa - 0.0024676405950567236 * var_sodium_potassium_pump__i_p - 0.00082254686501890791 * var_background_currents__i_B_Na - 0.00082254686501890791 * var_sodium_current__i_Na; // millimolar / millisecond
        
        mEvalF[1] = d_dt_chaste_interface_var_sodium_current_m_gate__m;
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[2] = d_dt_chaste_interface_var_sodium_current_h1_gate__h1;
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[3] = d_dt_chaste_interface_var_sodium_current_h2_gate__h2;
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[4] = d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L;
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[5] = d_dt_chaste_interface_var_L_type_Ca_channel_f_L_gate__f_L;
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[6] = d_dt_chaste_interface_var_T_type_Ca_channel_d_T_gate__d_T;
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[7] = d_dt_chaste_interface_var_T_type_Ca_channel_f_T_gate__f_T;
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[8] = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r;
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[9] = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s1_gate__s1;
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[10] = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s2_gate__s2;
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[11] = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s3_gate__s3;
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[12] = d_dt_chaste_interface_var_delayed_rectifier_K_current_z_gate__z;
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[13] = d_dt_chaste_interface_var_delayed_rectifier_K_current_pa_gate__p_a;
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[14] = d_dt_chaste_interface_var_delayed_rectifier_K_current_pi_gate__p_i;
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[15] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[16] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[17] = d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[18] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C;
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[19] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC;
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[20] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC;
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[21] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg;
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[22] = d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c;
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[23] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel;
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[24] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up;
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[25] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse;
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[26] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1;
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[27] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2;
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[28] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F3;
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__environment__time_converted, rY, delta);
        
        {
            if (fabs(mPartialF[1]) < delta){
                rY[1] += mDt*d_dt_chaste_interface_var_sodium_current_m_gate__m;
            }
            else
            {
                rY[1] += (d_dt_chaste_interface_var_sodium_current_m_gate__m/mPartialF[1])*(exp(mPartialF[1]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[2]) < delta){
                rY[2] += mDt*d_dt_chaste_interface_var_sodium_current_h1_gate__h1;
            }
            else
            {
                rY[2] += (d_dt_chaste_interface_var_sodium_current_h1_gate__h1/mPartialF[2])*(exp(mPartialF[2]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[3]) < delta){
                rY[3] += mDt*d_dt_chaste_interface_var_sodium_current_h2_gate__h2;
            }
            else
            {
                rY[3] += (d_dt_chaste_interface_var_sodium_current_h2_gate__h2/mPartialF[3])*(exp(mPartialF[3]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[4]) < delta){
                rY[4] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L;
            }
            else
            {
                rY[4] += (d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L/mPartialF[4])*(exp(mPartialF[4]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[5]) < delta){
                rY[5] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_f_L_gate__f_L;
            }
            else
            {
                rY[5] += (d_dt_chaste_interface_var_L_type_Ca_channel_f_L_gate__f_L/mPartialF[5])*(exp(mPartialF[5]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[6]) < delta){
                rY[6] += mDt*d_dt_chaste_interface_var_T_type_Ca_channel_d_T_gate__d_T;
            }
            else
            {
                rY[6] += (d_dt_chaste_interface_var_T_type_Ca_channel_d_T_gate__d_T/mPartialF[6])*(exp(mPartialF[6]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[7]) < delta){
                rY[7] += mDt*d_dt_chaste_interface_var_T_type_Ca_channel_f_T_gate__f_T;
            }
            else
            {
                rY[7] += (d_dt_chaste_interface_var_T_type_Ca_channel_f_T_gate__f_T/mPartialF[7])*(exp(mPartialF[7]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[8]) < delta){
                rY[8] += mDt*d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r;
            }
            else
            {
                rY[8] += (d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r/mPartialF[8])*(exp(mPartialF[8]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[9]) < delta){
                rY[9] += mDt*d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s1_gate__s1;
            }
            else
            {
                rY[9] += (d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s1_gate__s1/mPartialF[9])*(exp(mPartialF[9]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[10]) < delta){
                rY[10] += mDt*d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s2_gate__s2;
            }
            else
            {
                rY[10] += (d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s2_gate__s2/mPartialF[10])*(exp(mPartialF[10]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[11]) < delta){
                rY[11] += mDt*d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s3_gate__s3;
            }
            else
            {
                rY[11] += (d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s3_gate__s3/mPartialF[11])*(exp(mPartialF[11]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[12]) < delta){
                rY[12] += mDt*d_dt_chaste_interface_var_delayed_rectifier_K_current_z_gate__z;
            }
            else
            {
                rY[12] += (d_dt_chaste_interface_var_delayed_rectifier_K_current_z_gate__z/mPartialF[12])*(exp(mPartialF[12]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[13]) < delta){
                rY[13] += mDt*d_dt_chaste_interface_var_delayed_rectifier_K_current_pa_gate__p_a;
            }
            else
            {
                rY[13] += (d_dt_chaste_interface_var_delayed_rectifier_K_current_pa_gate__p_a/mPartialF[13])*(exp(mPartialF[13]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[14]) < delta){
                rY[14] += mDt*d_dt_chaste_interface_var_delayed_rectifier_K_current_pi_gate__p_i;
            }
            else
            {
                rY[14] += (d_dt_chaste_interface_var_delayed_rectifier_K_current_pi_gate__p_i/mPartialF[14])*(exp(mPartialF[14]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[15]) < delta){
                rY[15] += mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
            }
            else
            {
                rY[15] += (d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i/mPartialF[15])*(exp(mPartialF[15]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[16]) < delta){
                rY[16] += mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
            }
            else
            {
                rY[16] += (d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i/mPartialF[16])*(exp(mPartialF[16]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[17]) < delta){
                rY[17] += mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
            }
            else
            {
                rY[17] += (d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i/mPartialF[17])*(exp(mPartialF[17]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[18]) < delta){
                rY[18] += mDt*d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C;
            }
            else
            {
                rY[18] += (d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C/mPartialF[18])*(exp(mPartialF[18]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[19]) < delta){
                rY[19] += mDt*d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC;
            }
            else
            {
                rY[19] += (d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC/mPartialF[19])*(exp(mPartialF[19]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[20]) < delta){
                rY[20] += mDt*d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC;
            }
            else
            {
                rY[20] += (d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC/mPartialF[20])*(exp(mPartialF[20]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[21]) < delta){
                rY[21] += mDt*d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg;
            }
            else
            {
                rY[21] += (d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg/mPartialF[21])*(exp(mPartialF[21]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[22]) < delta){
                rY[22] += mDt*d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c;
            }
            else
            {
                rY[22] += (d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c/mPartialF[22])*(exp(mPartialF[22]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[23]) < delta){
                rY[23] += mDt*d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel;
            }
            else
            {
                rY[23] += (d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel/mPartialF[23])*(exp(mPartialF[23]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[24]) < delta){
                rY[24] += mDt*d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up;
            }
            else
            {
                rY[24] += (d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up/mPartialF[24])*(exp(mPartialF[24]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[25]) < delta){
                rY[25] += mDt*d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse;
            }
            else
            {
                rY[25] += (d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse/mPartialF[25])*(exp(mPartialF[25]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[26]) < delta){
                rY[26] += mDt*d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1;
            }
            else
            {
                rY[26] += (d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1/mPartialF[26])*(exp(mPartialF[26]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[27]) < delta){
                rY[27] += mDt*d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2;
            }
            else
            {
                rY[27] += (d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2/mPartialF[27])*(exp(mPartialF[27]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[28]) < delta){
                rY[28] += mDt*d_dt_chaste_interface_var_Ca_handling_by_the_SR__F3;
            }
            else
            {
                rY[28] += (d_dt_chaste_interface_var_Ca_handling_by_the_SR__F3/mPartialF[28])*(exp(mPartialF[28]*mDt)-1.0);
            }
            
        }        
        
    }
   
    
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.01309
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.706
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.61493
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 3e-05
        double var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.99981
        double var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.00046
        double var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.30752
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 6e-05
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = rY[9];
        // Units: dimensionless; Initial value: 0.5753
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = rY[10];
        // Units: dimensionless; Initial value: 0.39871
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = rY[11];
        // Units: dimensionless; Initial value: 0.57363
        double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = rY[12];
        // Units: dimensionless; Initial value: 0.02032
        double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.00016
        double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = rY[14];
        // Units: dimensionless; Initial value: 0.76898
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[17];
        // Units: millimolar; Initial value: 100.0
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
        // Units: millimolar; Initial value: 5.0
        
        
        // Mathematics
        const double var_environment__PM = 0; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__E_K = 26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i); // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_sus = ((var_environment__PM == 0) ? (0.098000000000000004 + 0.0014 * var_chaste_interface__membrane__V) : (0.070000000000000007 + 0.001 * var_chaste_interface__membrane__V)); // picoA
        const double var_Ca_independent_transient_outward_K_current__i_to = ((var_environment__PM == 0) ? (0.0100004 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r) : (0.050001999999999998 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r)); // picoA
        const double var_L_type_Ca_channel__i_Ca_L = ((var_environment__PM == 0) ? (0.0072000000000000007 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L)) : (0.0040000000000000001 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L))); // picoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = 2.0000000000000002e-5 * (2.5 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.016955889611951675 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.02072386508127427 * var_chaste_interface__membrane__V)) / (1.0 + 0.00074999999999999991 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_T_type_Ca_channel__i_Ca_T = 0.0060000000000000001 * (-38.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T; // picoA
        const double var_background_currents__i_B_Ca = ((var_environment__PM == 0) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 0.0002653945091048535 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i)) : (3.1000000000000001e-5 * var_chaste_interface__membrane__V - 0.00041136148911252295 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i))); // picoA
        const double var_delayed_rectifier_K_current__i_Kr = 0.0035000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i; // picoA
        const double var_delayed_rectifier_K_current__i_Ks = 0.0025000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_z_gate__z; // picoA
        const double var_inward_rectifier__i_K1 = ((var_environment__PM == 0) ? (0.010160000000000001 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3))) : (0.0050800000000000003 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3)))); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP = 0.0095090000000000001 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_sodium_current__E_Na = 26.53945091048535 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i); // millivolt
        const double var_background_currents__i_B_Na = ((var_environment__PM == 0) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 2.0000000000000002e-5 * var_sodium_current__E_Na) : (6.3999999999999997e-5 * var_chaste_interface__membrane__V - 6.3999999999999997e-5 * var_sodium_current__E_Na)); // picoA
        const double var_sodium_current__i_Na = 0.71257887225271721 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V - 0.037679754693225945 * var_sodium_current__E_Na)) * (0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__membrane__V / (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V)); // picoA
        const double var_sodium_potassium_pump__i_p = 0.10305599999999999 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // picoA
        d_dt_chaste_interface_var_membrane__V = -0.001 * (1000.0 * GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted) * mParameters[0] / HeartConfig::Instance()->GetCapacitance() + var_Ca_independent_transient_outward_K_current__i_sus + var_Ca_independent_transient_outward_K_current__i_to + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_T_type_Ca_channel__i_Ca_T + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_delayed_rectifier_K_current__i_Kr + var_delayed_rectifier_K_current__i_Ks + var_inward_rectifier__i_K1 + var_sarcolemmal_calcium_pump_current__i_CaP + var_sodium_current__i_Na + var_sodium_potassium_pump__i_p) / mParameters[0]; // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane__V;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            double var_chaste_interface__sodium_current_m_gate__m = rY[1];
            // Units: dimensionless; Initial value: 0.01309
            double var_chaste_interface__sodium_current_h1_gate__h1 = rY[2];
            // Units: dimensionless; Initial value: 0.706
            double var_chaste_interface__sodium_current_h2_gate__h2 = rY[3];
            // Units: dimensionless; Initial value: 0.61493
            double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[4];
            // Units: dimensionless; Initial value: 3e-05
            double var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L = rY[5];
            // Units: dimensionless; Initial value: 0.99981
            double var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T = rY[6];
            // Units: dimensionless; Initial value: 0.00046
            double var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T = rY[7];
            // Units: dimensionless; Initial value: 0.30752
            double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
            // Units: dimensionless; Initial value: 6e-05
            double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = rY[9];
            // Units: dimensionless; Initial value: 0.5753
            double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = rY[10];
            // Units: dimensionless; Initial value: 0.39871
            double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = rY[11];
            // Units: dimensionless; Initial value: 0.57363
            double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = rY[12];
            // Units: dimensionless; Initial value: 0.02032
            double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = rY[13];
            // Units: dimensionless; Initial value: 0.00016
            double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = rY[14];
            // Units: dimensionless; Initial value: 0.76898
            double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
            // Units: millimolar; Initial value: 8.4
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
            // Units: millimolar; Initial value: 7.1e-05
            double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[17];
            // Units: millimolar; Initial value: 100.0
            double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
            // Units: millimolar; Initial value: 5.0
            
            const double var_x0 = 0.083333333333333329 * var_chaste_interface__membrane__V;
            const double var_x1 = exp(1.9166666666666667 - var_x0);
            const double var_x2 = 1.0 + var_x1;
            const double var_x3 = 1 / var_x2;
            const double var_x4 = var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T;
            const double var_x5 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3);
            const double var_x6 = 1 / (1.0 + 0.00074999999999999991 * var_x5 + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i);
            const double var_x7 = exp(0.016955889611951675 * var_chaste_interface__membrane__V);
            const double var_x8 = var_x5 * var_x7;
            const double var_x9 = exp(-0.02072386508127427 * var_chaste_interface__membrane__V);
            const double var_x10 = var_x9 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x11 = var_x6 * (0.042389724029879193 * var_x8 + 56866.285783016596 * var_x10);
            const double var_x12 = var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i;
            const double var_x13 = var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L;
            const double var_x14 = pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6);
            const double var_x15 = 0.00400016 + 0.0060002399999999996 * var_x14;
            const double var_x16 = 0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3);
            const double var_x17 = var_x16 * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r;
            const double var_x18 = var_x15 * var_x17;
            const double var_x19 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3);
            const double var_x20 = 1 / var_chaste_interface__intracellular_ion_concentrations__K_i;
            const double var_x21 = log(var_x20 * var_chaste_interface__cleft_space_ion_concentrations__K_c);
            const double var_x22 = exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 1.393 * var_x21);
            const double var_x23 = 1.0 + var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = 0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x26 = pow(var_x25, (-3));
            const double var_x27 = var_x24 * var_x26;
            const double var_x28 = var_x19 * var_x27;
            const double var_x29 = -0.36000000000000004 + 0.0072000000000000007 * var_chaste_interface__membrane__V;
            const double var_x30 = 0.083333333333333329 * var_x1 / pow(var_x2, 2);
            const double var_x31 = 0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1;
            const double var_x32 = 0.037679754693225945 * var_chaste_interface__membrane__V;
            const double var_x33 = exp(var_x32);
            const double var_x34 = -1.0 + var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x36 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
            const double var_x37 = 1 / var_chaste_interface__intracellular_ion_concentrations__Na_i;
            const double var_x38 = exp(var_x32 - 1.0 * log(140.0 * var_x37));
            const double var_x39 = -1.0 + var_x38;
            const double var_x40 = var_x35 * var_x36 * var_x39;
            const double var_x41 = var_x31 * var_x40;
            const double var_x42 = 0.026849797106057973 * var_x36;
            const double var_x43 = var_x31 * var_x35 * var_chaste_interface__membrane__V;
            const double var_x44 = var_x38 * var_x43;
            const double var_x45 = -26.53945091048535 * var_x21 + var_chaste_interface__membrane__V;
            const double var_x46 = var_x22 * var_x26 * var_x45 / pow(var_x23, 2);
            const double var_x47 = var_x19 * var_x46;
            const double var_x48 = exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V);
            const double var_x49 = 1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x50 = 1 / var_x49;
            const double var_x51 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5);
            const double var_x52 = 1 / (36.4828726939094 + var_x51);
            const double var_x53 = var_x51 * var_x52 * var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x54 = var_x48 * var_x50 * var_x53 / pow((1 + 0.66666666666666663 * var_x48), 2);
            const double var_x55 = var_x31 * var_x33 * var_x39 * var_chaste_interface__membrane__V / pow(var_x34, 2);
            const double var_x56 = 1 / mParameters[0];
            const double var_x57 = 0.001 * var_x56;
            
            partialF = -var_x57 * (0.0014400000000000001 + var_x18 + 0.0060000000000000001 * var_x4 + 0.0025000000000000001 * var_chaste_interface__delayed_rectifier_K_current_z_gate__z + 0.010160000000000001 * var_x28 + 2.0000000000000002e-5 * var_x11 + 0.0035000000000000001 * var_x12 + 0.0011450666666666667 * var_x54 + 0.71257887225271721 * var_x41 + 0.0072000000000000007 * var_x13 + 0.0072000000000000007 * var_x3 - 0.00053327704660266365 * var_x47 + var_x29 * var_x30 + var_x42 * var_x44 - var_x42 * var_x55);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.01309
        
        
        // Mathematics
        const double var_sodium_current_m_gate__E0_m = 44.399999999999999 + var_chaste_interface__membrane__V; // millivolt
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = -18.399999999999999 * var_chaste_interface__sodium_current_m_gate__m * exp(-0.078907914463820727 * var_sodium_current_m_gate__E0_m) - 0.46000000000000002 * (1.0 - var_chaste_interface__sodium_current_m_gate__m) * var_sodium_current_m_gate__E0_m / (-1.0 + exp(-0.078907914463820727 * var_sodium_current_m_gate__E0_m)); // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_m_gate__m;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x105 = exp(-3.5035114021936398 - 0.078907914463820727 * var_chaste_interface__membrane__V);
            const double var_x107 = -1.0 + var_x105;
            const double var_x108 = 0.46000000000000002 / var_x107;
            const double var_x109 = 44.399999999999999 + var_chaste_interface__membrane__V;
            
            partialF = -18.399999999999999 * var_x105 + var_x108 * var_x109;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.706
        
        
        // Mathematics
        const double var_sodium_current_h1_gate__h_infinity = 44.899999999999999 * exp(-12.010771992818672 - 0.17953321364452424 * var_chaste_interface__membrane__V) / (1491.0 / (1.0 + 323.30000000000001 * exp(-7.333333333333333 - 0.077519379844961239 * var_chaste_interface__membrane__V)) + 44.899999999999999 * exp(-12.010771992818672 - 0.17953321364452424 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_sodium_current_h1_gate__h1 = 0.001 * (-var_chaste_interface__sodium_current_h1_gate__h1 + var_sodium_current_h1_gate__h_infinity) / (0.00014999999999999999 + 0.029999999999999999 / (1.0 + exp(6.666666666666667 + 0.16666666666666666 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_h1_gate__h1;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x117 = exp(6.666666666666667 + 0.16666666666666666 * var_chaste_interface__membrane__V);
            const double var_x118 = 1.0 + var_x117;
            const double var_x119 = 1 / var_x118;
            const double var_x120 = 0.001 / (0.00014999999999999999 + 0.029999999999999999 * var_x119);
            
            partialF = -var_x120;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.61493
        
        
        // Mathematics
        const double var_sodium_current_h1_gate__h_infinity = 44.899999999999999 * exp(-12.010771992818672 - 0.17953321364452424 * var_chaste_interface__membrane__V) / (1491.0 / (1.0 + 323.30000000000001 * exp(-7.333333333333333 - 0.077519379844961239 * var_chaste_interface__membrane__V)) + 44.899999999999999 * exp(-12.010771992818672 - 0.17953321364452424 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_sodium_current_h2_gate__h2 = 0.001 * (-var_chaste_interface__sodium_current_h2_gate__h2 + var_sodium_current_h1_gate__h_infinity) / (0.00044999999999999999 + 0.12 / (1.0 + exp(30.0 + 0.5 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_h2_gate__h2;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x122 = exp(30.0 + 0.5 * var_chaste_interface__membrane__V);
            const double var_x123 = 1.0 + var_x122;
            const double var_x124 = 1 / var_x123;
            const double var_x125 = 0.001 / (0.00044999999999999999 + 0.12 * var_x124);
            
            partialF = -var_x125;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 3e-05
        
        
        // Mathematics
        const double var_L_type_Ca_channel_d_L_gate__E10 = 10.0 + var_chaste_interface__membrane__V; // millivolt
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L = 0.001 * (-var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L + 1 / (1.0 + exp(-0.14393939393939395 - 0.15151515151515152 * var_L_type_Ca_channel_d_L_gate__E10))) * (4.4800000000000004 * (5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)) - 50.0 * var_L_type_Ca_channel_d_L_gate__E10 / (-1.0 + exp(-0.20798668885191349 * var_L_type_Ca_channel_d_L_gate__E10)) - 16.719999999999999 * (45.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-18.0 - 0.40000000000000002 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x128 = 0.40000000000000002 * var_chaste_interface__membrane__V;
            const double var_x129 = exp(2.0 + var_x128);
            const double var_x130 = -1.0 + var_x129;
            const double var_x131 = 1 / var_x130;
            const double var_x133 = exp(-2.0798668885191347 - 0.20798668885191349 * var_chaste_interface__membrane__V);
            const double var_x134 = -1.0 + var_x133;
            const double var_x135 = 1 / var_x134;
            const double var_x137 = exp(-18.0 - var_x128);
            const double var_x138 = -1.0 + var_x137;
            const double var_x139 = 1 / var_x138;
            const double var_x141 = 10.0 + var_chaste_interface__membrane__V;
            const double var_x142 = 45.0 + var_chaste_interface__membrane__V;
            const double var_x143 = 5.0 + var_chaste_interface__membrane__V;
            
            partialF = 0.016719999999999999 * var_x139 * var_x142 + 0.050000000000000003 * var_x135 * var_x141 - 0.0044800000000000005 * var_x131 * var_x143;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.99981
        
        
        // Mathematics
        const double var_L_type_Ca_channel_f_L_gate__E0_f_L = 18.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_L_type_Ca_channel_f_L_gate__alpha_f_L = 8.4900000000000002 * var_L_type_Ca_channel_f_L_gate__E0_f_L / (-1.0 + exp(0.25 * var_L_type_Ca_channel_f_L_gate__E0_f_L)); // per_second
        const double var_L_type_Ca_channel_f_L_gate__beta_f_L = 67.921999999999997 / (1.0 + exp(-0.25 * var_L_type_Ca_channel_f_L_gate__E0_f_L)); // per_second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_L_gate__f_L = 0.001 * (-var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L + var_L_type_Ca_channel_f_L_gate__alpha_f_L / (var_L_type_Ca_channel_f_L_gate__alpha_f_L + var_L_type_Ca_channel_f_L_gate__beta_f_L)) * (var_L_type_Ca_channel_f_L_gate__alpha_f_L + var_L_type_Ca_channel_f_L_gate__beta_f_L); // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_f_L_gate__f_L;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x144 = 0.25 * var_chaste_interface__membrane__V;
            const double var_x145 = exp(-4.5 - var_x144);
            const double var_x146 = 1.0 + var_x145;
            const double var_x147 = 1 / var_x146;
            const double var_x148 = 18.0 + var_chaste_interface__membrane__V;
            const double var_x149 = exp(4.5 + var_x144);
            const double var_x150 = -1.0 + var_x149;
            const double var_x151 = 1 / var_x150;
            const double var_x155 = 0.008490000000000001 * var_x151;
            
            partialF = -0.067921999999999996 * var_x147 - var_x148 * var_x155;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.00046
        
        
        // Mathematics
        const double var_T_type_Ca_channel_d_T_gate__E0_d_T = 23.300000000000001 + var_chaste_interface__membrane__V; // millivolt
        const double d_dt_chaste_interface_var_T_type_Ca_channel_d_T_gate__d_T = 0.001 * (-var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T + 1 / (1.0 + exp(0.049180327868852458 - 0.16393442622950821 * var_T_type_Ca_channel_d_T_gate__E0_d_T))) * (674.173 * exp(0.033333333333333333 * var_T_type_Ca_channel_d_T_gate__E0_d_T) + 674.173 * exp(-0.033333333333333333 * var_T_type_Ca_channel_d_T_gate__E0_d_T)); // 1 / millisecond

        return d_dt_chaste_interface_var_T_type_Ca_channel_d_T_gate__d_T;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x163 = 0.033333333333333333 * var_chaste_interface__membrane__V;
            const double var_x164 = exp(0.77666666666666673 + var_x163);
            const double var_x165 = exp(-0.77666666666666673 - var_x163);
            
            partialF = -0.67417300000000002 * var_x164 - 0.67417300000000002 * var_x165;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.30752
        
        
        // Mathematics
        const double var_T_type_Ca_channel_f_T_gate__E0_f_T = 75.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_T_type_Ca_channel_f_T_gate__alpha_f_T = 9.6370000000000005 * exp(-0.012004801920768308 * var_T_type_Ca_channel_f_T_gate__E0_f_T); // per_second
        const double var_T_type_Ca_channel_f_T_gate__beta_f_T = 9.6370000000000005 * exp(0.065019505851755519 * var_T_type_Ca_channel_f_T_gate__E0_f_T); // per_second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_f_T_gate__f_T = 0.001 * (-var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T + var_T_type_Ca_channel_f_T_gate__alpha_f_T / (var_T_type_Ca_channel_f_T_gate__alpha_f_T + var_T_type_Ca_channel_f_T_gate__beta_f_T)) * (var_T_type_Ca_channel_f_T_gate__alpha_f_T + var_T_type_Ca_channel_f_T_gate__beta_f_T); // 1 / millisecond

        return d_dt_chaste_interface_var_T_type_Ca_channel_f_T_gate__f_T;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x166 = exp(4.876462938881664 + 0.065019505851755519 * var_chaste_interface__membrane__V);
            const double var_x167 = exp(-0.9003601440576231 - 0.012004801920768308 * var_chaste_interface__membrane__V);
            const double var_x172 = 0.0096369999999999997 * var_x167;
            
            partialF = -var_x172 - 0.0096369999999999997 * var_x166;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 6e-05
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r = 0.001 * (-var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r + 1 / (1.0 + exp(-2.6628794603230959 - 0.17752529735487307 * var_chaste_interface__membrane__V))) / (0.00040000000000000002 + 1 / (8.0109999999999992 * exp(-0.1388888888888889 * var_chaste_interface__membrane__V) + 386.60000000000002 * exp(0.083333333333333329 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x0 = 0.083333333333333329 * var_chaste_interface__membrane__V;
            const double var_x175 = exp(-0.1388888888888889 * var_chaste_interface__membrane__V);
            const double var_x176 = exp(var_x0);
            const double var_x177 = 0.00040000000000000002 + 1 / (8.0109999999999992 * var_x175 + 386.60000000000002 * var_x176);
            const double var_x178 = 1 / var_x177;
            
            partialF = -0.001 * var_x178;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = rY[9];
        // Units: dimensionless; Initial value: 0.5753
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s1_gate__s1 = 0.001 * (-var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 + 1 / (1.0 + exp(4.0070821529745047 + 0.14164305949008499 * var_chaste_interface__membrane__V))) / (0.020400000000000001 + 0.54659999999999997 / (1.0 + exp(327.99999999999994 + 10.0 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s1_gate__s1;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x179 = exp(327.99999999999994 + 10.0 * var_chaste_interface__membrane__V);
            const double var_x180 = 1.0 + var_x179;
            const double var_x181 = 1 / var_x180;
            const double var_x182 = 1 / (0.020400000000000001 + 0.54659999999999997 * var_x181);
            
            partialF = -0.001 * var_x182;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = rY[10];
        // Units: dimensionless; Initial value: 0.39871
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s2_gate__s2 = 0.001 * (-var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 + 1 / (1.0 + exp(4.0070821529745047 + 0.14164305949008499 * var_chaste_interface__membrane__V))) / (5.75 / (1.0 + exp(327.99999999999994 + 10.0 * var_chaste_interface__membrane__V)) + 0.45000000000000001 / (1.0 + exp(0.96921975662133131 - 0.071581961345740866 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s2_gate__s2;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x179 = exp(327.99999999999994 + 10.0 * var_chaste_interface__membrane__V);
            const double var_x180 = 1.0 + var_x179;
            const double var_x181 = 1 / var_x180;
            const double var_x188 = exp(0.96921975662133131 - 0.071581961345740866 * var_chaste_interface__membrane__V);
            const double var_x189 = 1.0 + var_x188;
            const double var_x190 = 1 / var_x189;
            const double var_x191 = 1 / (5.75 * var_x181 + 0.45000000000000001 * var_x190);
            
            partialF = -0.001 * var_x191;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = rY[11];
        // Units: dimensionless; Initial value: 0.57363
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s3_gate__s3 = 0.001 * (0.39975990396158467 - var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 + 0.60024009603841544 / (1.0 + exp(1.8506208911614319 + 0.036523009495982472 * var_chaste_interface__membrane__V))) / (0.5 + 7.5 / (1.0 + exp(46.0 + 2.0 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s3_gate__s3;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x192 = exp(46.0 + 2.0 * var_chaste_interface__membrane__V);
            const double var_x193 = 1.0 + var_x192;
            const double var_x194 = 1 / var_x193;
            const double var_x195 = 1 / (0.5 + 7.5 * var_x194);
            
            partialF = -0.001 * var_x195;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = rY[12];
        // Units: dimensionless; Initial value: 0.02032
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_delayed_rectifier_K_current_z_gate__z = 0.001 * (-var_chaste_interface__delayed_rectifier_K_current_z_gate__z + 1 / (1.0 + exp(0.065217391304347824 - 0.072463768115942032 * var_chaste_interface__membrane__V))) / (0.059999999999999998 + 1 / (0.29999999999999999 * exp(-0.045816915605241454 * var_chaste_interface__membrane__V) + 1.6599999999999999 * exp(0.014398433450440593 * var_chaste_interface__membrane__V))); // 1 / millisecond

        return d_dt_chaste_interface_var_delayed_rectifier_K_current_z_gate__z;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x200 = exp(-0.045816915605241454 * var_chaste_interface__membrane__V);
            const double var_x201 = exp(0.014398433450440593 * var_chaste_interface__membrane__V);
            const double var_x202 = 0.059999999999999998 + 1 / (0.29999999999999999 * var_x200 + 1.6599999999999999 * var_x201);
            const double var_x203 = 1 / var_x202;
            
            partialF = -0.001 * var_x203;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.00016
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_delayed_rectifier_K_current_pa_gate__p_a = 0.001 * (-var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a + 1 / (1.0 + exp(-0.68918918918918914 - 0.13513513513513511 * var_chaste_interface__membrane__V))) * (9.0 * exp(0.03941508020968823 * var_chaste_interface__membrane__V) + 1.3 * exp(-0.076769537847382163 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_delayed_rectifier_K_current_pa_gate__p_a;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x206 = exp(0.03941508020968823 * var_chaste_interface__membrane__V);
            const double var_x207 = exp(-0.076769537847382163 * var_chaste_interface__membrane__V);
            
            partialF = -0.0089999999999999993 * var_x206 - 0.0012999999999999999 * var_x207;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = rY[14];
        // Units: dimensionless; Initial value: 0.76898
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_delayed_rectifier_K_current_pi_gate__p_i = 0.001 * (-var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i + 1 / (1.0 + exp(2.539728728905752 + 0.05358970648917756 * var_chaste_interface__membrane__V))) * (100.0 * exp(-0.018299935950224173 * var_chaste_interface__membrane__V) + 656.0 * exp(0.009420009985210585 * var_chaste_interface__membrane__V)); // 1 / millisecond

        return d_dt_chaste_interface_var_delayed_rectifier_K_current_pi_gate__p_i;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            
            const double var_x208 = exp(0.009420009985210585 * var_chaste_interface__membrane__V);
            const double var_x209 = exp(-0.018299935950224173 * var_chaste_interface__membrane__V);
            
            partialF = -0.65600000000000003 * var_x208 - 0.10000000000000001 * var_x209;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative15(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__sodium_current_m_gate__m = rY[1];
        // Units: dimensionless; Initial value: 0.01309
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[2];
        // Units: dimensionless; Initial value: 0.706
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[3];
        // Units: dimensionless; Initial value: 0.61493
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
        // Units: millimolar; Initial value: 5.0
        
        
        // Mathematics
        const double var_environment__PM = 0; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = 2.0000000000000002e-5 * (2.5 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.016955889611951675 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.02072386508127427 * var_chaste_interface__membrane__V)) / (1.0 + 0.00074999999999999991 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_sodium_current__E_Na = 26.53945091048535 * log(140.0 / var_chaste_interface__intracellular_ion_concentrations__Na_i); // millivolt
        const double var_background_currents__i_B_Na = ((var_environment__PM == 0) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 2.0000000000000002e-5 * var_sodium_current__E_Na) : (6.3999999999999997e-5 * var_chaste_interface__membrane__V - 6.3999999999999997e-5 * var_sodium_current__E_Na)); // picoA
        const double var_sodium_current__i_Na = 0.71257887225271721 * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V - 0.037679754693225945 * var_sodium_current__E_Na)) * (0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__membrane__V / (-1.0 + exp(0.037679754693225945 * var_chaste_interface__membrane__V)); // picoA
        const double var_sodium_potassium_pump__i_p = 0.10305599999999999 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = -0.0024676405950567236 * var_Na_Ca_ion_exchanger_current__i_NaCa - 0.0024676405950567236 * var_sodium_potassium_pump__i_p - 0.00082254686501890791 * var_background_currents__i_B_Na - 0.00082254686501890791 * var_sodium_current__i_Na; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative15(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            double var_chaste_interface__sodium_current_m_gate__m = rY[1];
            // Units: dimensionless; Initial value: 0.01309
            double var_chaste_interface__sodium_current_h1_gate__h1 = rY[2];
            // Units: dimensionless; Initial value: 0.706
            double var_chaste_interface__sodium_current_h2_gate__h2 = rY[3];
            // Units: dimensionless; Initial value: 0.61493
            double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
            // Units: millimolar; Initial value: 8.4
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
            // Units: millimolar; Initial value: 7.1e-05
            double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
            // Units: millimolar; Initial value: 5.0
            
            const double var_x5 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3);
            const double var_x6 = 1 / (1.0 + 0.00074999999999999991 * var_x5 + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i);
            const double var_x7 = exp(0.016955889611951675 * var_chaste_interface__membrane__V);
            const double var_x8 = var_x5 * var_x7;
            const double var_x9 = exp(-0.02072386508127427 * var_chaste_interface__membrane__V);
            const double var_x10 = var_x9 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x31 = 0.36499999999999999 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.63500000000000001 * var_chaste_interface__sodium_current_h1_gate__h1;
            const double var_x32 = 0.037679754693225945 * var_chaste_interface__membrane__V;
            const double var_x33 = exp(var_x32);
            const double var_x34 = -1.0 + var_x33;
            const double var_x35 = 1 / var_x34;
            const double var_x36 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
            const double var_x37 = 1 / var_chaste_interface__intracellular_ion_concentrations__Na_i;
            const double var_x38 = exp(var_x32 - 1.0 * log(140.0 * var_x37));
            const double var_x43 = var_x31 * var_x35 * var_chaste_interface__membrane__V;
            const double var_x44 = var_x38 * var_x43;
            const double var_x48 = exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V);
            const double var_x49 = 1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x50 = 1 / var_x49;
            const double var_x51 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5);
            const double var_x52 = 1 / (36.4828726939094 + var_x51);
            const double var_x76 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 2);
            const double var_x77 = var_x6 * var_x7 * var_x76;
            const double var_x78 = (2.5 * var_x8 - 2744000.0 * var_x10) / pow((0.0012147716229348883 + 9.1107871720116623e-7 * var_x5 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2);
            const double var_x79 = var_x76 * var_x78;
            const double var_x80 = 1 / (1.5 + var_x48);
            const double var_x81 = var_x50 * var_x80;
            const double var_x82 = var_x52 * var_x81;
            const double var_x83 = var_x82 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 0.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x84 = var_x81 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 2.0) * var_chaste_interface__cleft_space_ion_concentrations__K_c / pow((1 + 0.027410122234342148 * var_x51), 2);
            const double var_x85 = var_x36 * var_x44;
            const double var_x86 = var_x37 * var_x85;
            
            partialF = 1.638640545085862e-16 * var_x79 + 2.8659485630822583e-7 * var_x84 - 3.701460892585086e-7 * var_x77 - 0.00038145775374624855 * var_x83 - 4.3659884291485854e-7 * var_x37 - 0.00058612951745018135 * var_x86;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative16(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[4];
        // Units: dimensionless; Initial value: 3e-05
        double var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L = rY[5];
        // Units: dimensionless; Initial value: 0.99981
        double var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T = rY[6];
        // Units: dimensionless; Initial value: 0.00046
        double var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T = rY[7];
        // Units: dimensionless; Initial value: 0.30752
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_Ca_buffering__O_C = rY[18];
        // Units: dimensionless; Initial value: 0.029108
        double var_chaste_interface__intracellular_Ca_buffering__O_TC = rY[19];
        // Units: dimensionless; Initial value: 0.014071
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[20];
        // Units: dimensionless; Initial value: 0.214036
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[21];
        // Units: dimensionless; Initial value: 0.693565
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[23];
        // Units: millimolar; Initial value: 0.726776
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[24];
        // Units: millimolar; Initial value: 0.730866
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[27];
        // Units: dimensionless; Initial value: 0.002262
        
        
        // Mathematics
        const double var_environment__PM = 0; // dimensionless
        const double var_Ca_handling_by_the_SR__i_rel = 200.0 * pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel) / pow((0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2), 2); // picoA
        const double var_Ca_handling_by_the_SR__i_up = 2.7999999999999998 * (3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 0.32000000000000006 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up) / (1.3999999999999999 + 0.80000000000000004 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + 3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_intracellular_Ca_buffering__dOCdt = -476.0 * var_chaste_interface__intracellular_Ca_buffering__O_C + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_C) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // per_second
        const double var_intracellular_Ca_buffering__dOTCdt = -392.0 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 78400.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TC) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // per_second
        const double var_intracellular_Ca_buffering__dOTMgCdt = -6.5999999999999996 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // per_second
        const double var_L_type_Ca_channel__i_Ca_L = ((var_environment__PM == 0) ? (0.0072000000000000007 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L)) : (0.0040000000000000001 * (-50.0 + var_chaste_interface__membrane__V) * (1 / (1.0 + exp(1.9166666666666667 - 0.083333333333333329 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_L_gate__f_L))); // picoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = 2.0000000000000002e-5 * (2.5 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * exp(0.016955889611951675 * var_chaste_interface__membrane__V) - 2744000.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp(-0.02072386508127427 * var_chaste_interface__membrane__V)) / (1.0 + 0.00074999999999999991 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_T_type_Ca_channel__i_Ca_T = 0.0060000000000000001 * (-38.0 + var_chaste_interface__membrane__V) * var_chaste_interface__T_type_Ca_channel_d_T_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_T_gate__f_T; // picoA
        const double var_background_currents__i_B_Ca = ((var_environment__PM == 0) ? (2.0000000000000002e-5 * var_chaste_interface__membrane__V - 0.0002653945091048535 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i)) : (3.1000000000000001e-5 * var_chaste_interface__membrane__V - 0.00041136148911252295 * log(2.5 / var_chaste_interface__intracellular_ion_concentrations__Ca_i))); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP = 0.0095090000000000001 * var_chaste_interface__intracellular_ion_concentrations__Ca_i / (0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = 0.00088070109612833447 * var_Ca_handling_by_the_SR__i_rel + 0.0017614021922566689 * var_Na_Ca_ion_exchanger_current__i_NaCa - 8.0000000000000007e-5 * var_intracellular_Ca_buffering__dOTCdt - 0.00016000000000000001 * var_intracellular_Ca_buffering__dOTMgCdt - 4.4999999999999996e-5 * var_intracellular_Ca_buffering__dOCdt - 0.00088070109612833447 * var_Ca_handling_by_the_SR__i_up - 0.00088070109612833447 * var_L_type_Ca_channel__i_Ca_L - 0.00088070109612833447 * var_T_type_Ca_channel__i_Ca_T - 0.00088070109612833447 * var_background_currents__i_B_Ca - 0.00088070109612833447 * var_sarcolemmal_calcium_pump_current__i_CaP; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative16(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
            // Units: millimolar; Initial value: 8.4
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
            // Units: millimolar; Initial value: 7.1e-05
            double var_chaste_interface__intracellular_Ca_buffering__O_C = rY[18];
            // Units: dimensionless; Initial value: 0.029108
            double var_chaste_interface__intracellular_Ca_buffering__O_TC = rY[19];
            // Units: dimensionless; Initial value: 0.014071
            double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[20];
            // Units: dimensionless; Initial value: 0.214036
            double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[21];
            // Units: dimensionless; Initial value: 0.693565
            double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[24];
            // Units: millimolar; Initial value: 0.730866
            double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[27];
            // Units: dimensionless; Initial value: 0.002262
            
            const double var_x5 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3);
            const double var_x6 = 1 / (1.0 + 0.00074999999999999991 * var_x5 + 823.19999999999993 * var_chaste_interface__intracellular_ion_concentrations__Ca_i);
            const double var_x7 = exp(0.016955889611951675 * var_chaste_interface__membrane__V);
            const double var_x8 = var_x5 * var_x7;
            const double var_x9 = exp(-0.02072386508127427 * var_chaste_interface__membrane__V);
            const double var_x10 = var_x9 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x78 = (2.5 * var_x8 - 2744000.0 * var_x10) / pow((0.0012147716229348883 + 9.1107871720116623e-7 * var_x5 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2);
            const double var_x87 = 0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x88 = 1 / var_x87;
            const double var_x89 = 1 / var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x90 = var_chaste_interface__intracellular_ion_concentrations__Ca_i / pow(var_x87, 2);
            const double var_x91 = var_x6 * var_x9;
            const double var_x214 = 3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x215 = 1 / (1.3999999999999999 + var_x214 + 0.80000000000000004 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up);
            const double var_x216 = (var_x214 - 0.32000000000000006 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up) / pow((0.00041999999999999996 + 0.00023999999999999998 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2);
            const double var_x217 = 0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2;
            const double var_x218 = pow(var_x217, (-2));
            const double var_x219 = pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2);
            const double var_x220 = var_x218 * var_x219;
            const double var_x221 = 0.17614021922566689 * var_x220;
            
            partialF = -47.271999999999998 - var_x221 + 8.3745867230843319e-6 * var_x90 + 6.2720000000000002 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 9.0 * var_chaste_interface__intracellular_Ca_buffering__O_C + 32.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 32.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgMg + 7.3978892074780085e-7 * var_x216 - 8.3745867230843319e-6 * var_x88 - 0.096665752311045988 * var_x91 - 8.2198768971977874 * var_x215 - 4.2794027994574083e-11 * var_x78 - 2.3373323507508574e-7 * var_x89;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative17(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 6e-05
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = rY[9];
        // Units: dimensionless; Initial value: 0.5753
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = rY[10];
        // Units: dimensionless; Initial value: 0.39871
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = rY[11];
        // Units: dimensionless; Initial value: 0.57363
        double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = rY[12];
        // Units: dimensionless; Initial value: 0.02032
        double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.00016
        double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = rY[14];
        // Units: dimensionless; Initial value: 0.76898
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[17];
        // Units: millimolar; Initial value: 100.0
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
        // Units: millimolar; Initial value: 5.0
        
        
        // Mathematics
        const double var_environment__PM = 0; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__E_K = 26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i); // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_sus = ((var_environment__PM == 0) ? (0.098000000000000004 + 0.0014 * var_chaste_interface__membrane__V) : (0.070000000000000007 + 0.001 * var_chaste_interface__membrane__V)); // picoA
        const double var_Ca_independent_transient_outward_K_current__i_to = ((var_environment__PM == 0) ? (0.0100004 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r) : (0.050001999999999998 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r)); // picoA
        const double var_delayed_rectifier_K_current__i_Kr = 0.0035000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i; // picoA
        const double var_delayed_rectifier_K_current__i_Ks = 0.0025000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_z_gate__z; // picoA
        const double var_inward_rectifier__i_K1 = ((var_environment__PM == 0) ? (0.010160000000000001 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3))) : (0.0050800000000000003 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3)))); // picoA
        const double var_sodium_potassium_pump__i_p = 0.10305599999999999 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // picoA
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = 0.0016450937300378158 * var_sodium_potassium_pump__i_p - 0.00082254686501890791 * var_Ca_independent_transient_outward_K_current__i_sus - 0.00082254686501890791 * var_Ca_independent_transient_outward_K_current__i_to - 0.00082254686501890791 * var_delayed_rectifier_K_current__i_Kr - 0.00082254686501890791 * var_delayed_rectifier_K_current__i_Ks - 0.00082254686501890791 * var_inward_rectifier__i_K1; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative17(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
            // Units: dimensionless; Initial value: 6e-05
            double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = rY[9];
            // Units: dimensionless; Initial value: 0.5753
            double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = rY[10];
            // Units: dimensionless; Initial value: 0.39871
            double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = rY[11];
            // Units: dimensionless; Initial value: 0.57363
            double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = rY[12];
            // Units: dimensionless; Initial value: 0.02032
            double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = rY[13];
            // Units: dimensionless; Initial value: 0.00016
            double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = rY[14];
            // Units: dimensionless; Initial value: 0.76898
            double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[17];
            // Units: millimolar; Initial value: 100.0
            double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
            // Units: millimolar; Initial value: 5.0
            
            const double var_x12 = var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i;
            const double var_x14 = pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6);
            const double var_x16 = 0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3);
            const double var_x17 = var_x16 * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r;
            const double var_x19 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3);
            const double var_x20 = 1 / var_chaste_interface__intracellular_ion_concentrations__K_i;
            const double var_x21 = log(var_x20 * var_chaste_interface__cleft_space_ion_concentrations__K_c);
            const double var_x22 = exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 1.393 * var_x21);
            const double var_x23 = 1.0 + var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = 0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x26 = pow(var_x25, (-3));
            const double var_x27 = var_x24 * var_x26;
            const double var_x28 = var_x19 * var_x27;
            const double var_x45 = -26.53945091048535 * var_x21 + var_chaste_interface__membrane__V;
            const double var_x46 = var_x22 * var_x26 * var_x45 / pow(var_x23, 2);
            const double var_x47 = var_x19 * var_x46;
            const double var_x94 = var_x20 * var_x28;
            const double var_x96 = var_x20 * var_x47;
            const double var_x227 = -3.290319067574035e-6 - 4.9354786013610522e-6 * var_x14;
            const double var_x228 = var_x17 * var_x227;
            const double var_x233 = 5.4574855364357316e-5 * var_chaste_interface__delayed_rectifier_K_current_z_gate__z;
            const double var_x234 = 7.6404797510100245e-5 * var_x12;
            const double var_x235 = 26.53945091048535 * var_x228;
            
            partialF = 1.1641407074988802e-5 * var_x96 - 0.00022179221220074814 * var_x94 + var_x20 * var_x235 - var_x20 * var_x233 - var_x20 * var_x234;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative18(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_Ca_buffering__O_C = rY[18];
        // Units: dimensionless; Initial value: 0.029108
        
        
        // Mathematics
        const double var_intracellular_Ca_buffering__dOCdt = -476.0 * var_chaste_interface__intracellular_Ca_buffering__O_C + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_C) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // per_second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C = 0.001 * var_intracellular_Ca_buffering__dOCdt; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative18(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
            // Units: millimolar; Initial value: 7.1e-05
            
            const double var_x237 = -200.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            
            partialF = -0.47599999999999998 + var_x237;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative19(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_Ca_buffering__O_TC = rY[19];
        // Units: dimensionless; Initial value: 0.014071
        
        
        // Mathematics
        const double var_intracellular_Ca_buffering__dOTCdt = -392.0 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 78400.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TC) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // per_second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC = 0.001 * var_intracellular_Ca_buffering__dOTCdt; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative19(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
            // Units: millimolar; Initial value: 7.1e-05
            
            
            partialF = -0.39200000000000002 - 78.400000000000006 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative20(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[20];
        // Units: dimensionless; Initial value: 0.214036
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[21];
        // Units: dimensionless; Initial value: 0.693565
        
        
        // Mathematics
        const double var_intracellular_Ca_buffering__dOTMgCdt = -6.5999999999999996 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // per_second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC = 0.001 * var_intracellular_Ca_buffering__dOTMgCdt; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative20(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
            // Units: millimolar; Initial value: 7.1e-05
            
            const double var_x237 = -200.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            
            partialF = -0.0066 + var_x237;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative21(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[20];
        // Units: dimensionless; Initial value: 0.214036
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[21];
        // Units: dimensionless; Initial value: 0.693565
        
        
        // Mathematics
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg = 5.0 - 5.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC - 5.6660000000000004 * var_chaste_interface__intracellular_Ca_buffering__O_TMgMg; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative21(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -5.6660000000000004;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative22(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 6e-05
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = rY[9];
        // Units: dimensionless; Initial value: 0.5753
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = rY[10];
        // Units: dimensionless; Initial value: 0.39871
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = rY[11];
        // Units: dimensionless; Initial value: 0.57363
        double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = rY[12];
        // Units: dimensionless; Initial value: 0.02032
        double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.00016
        double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = rY[14];
        // Units: dimensionless; Initial value: 0.76898
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
        // Units: millimolar; Initial value: 8.4
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[17];
        // Units: millimolar; Initial value: 100.0
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
        // Units: millimolar; Initial value: 5.0
        
        
        // Mathematics
        const double var_environment__PM = 0; // dimensionless
        const double var_Ca_independent_transient_outward_K_current__E_K = 26.53945091048535 * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i); // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_sus = ((var_environment__PM == 0) ? (0.098000000000000004 + 0.0014 * var_chaste_interface__membrane__V) : (0.070000000000000007 + 0.001 * var_chaste_interface__membrane__V)); // picoA
        const double var_Ca_independent_transient_outward_K_current__i_to = ((var_environment__PM == 0) ? (0.0100004 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r) : (0.050001999999999998 * (0.40000000000000002 + 0.59999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6)) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * (0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3)) * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r)); // picoA
        const double var_delayed_rectifier_K_current__i_Kr = 0.0035000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i; // picoA
        const double var_delayed_rectifier_K_current__i_Ks = 0.0025000000000000001 * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_chaste_interface__delayed_rectifier_K_current_z_gate__z; // picoA
        const double var_inward_rectifier__i_K1 = ((var_environment__PM == 0) ? (0.010160000000000001 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3))) : (0.0050800000000000003 * pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) / ((1.0 + exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 0.052487898287663745 * var_Ca_independent_transient_outward_K_current__E_K)) * pow((0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c), 3)))); // picoA
        const double var_sodium_potassium_pump__i_p = 0.10305599999999999 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * var_chaste_interface__cleft_space_ion_concentrations__K_c / ((1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c) * (1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * (36.4828726939094 + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5))); // picoA
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c = 0.0041456361996952953 * var_Ca_independent_transient_outward_K_current__i_sus + 0.0041456361996952953 * var_Ca_independent_transient_outward_K_current__i_to + 0.0041456361996952953 * var_delayed_rectifier_K_current__i_Kr + 0.0041456361996952953 * var_delayed_rectifier_K_current__i_Ks + 0.0041456361996952953 * var_inward_rectifier__i_K1 - 0.0082912723993905906 * var_sodium_potassium_pump__i_p; // millimolar / millisecond

        return d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative22(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
            // Units: dimensionless; Initial value: 6e-05
            double var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1 = rY[9];
            // Units: dimensionless; Initial value: 0.5753
            double var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2 = rY[10];
            // Units: dimensionless; Initial value: 0.39871
            double var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3 = rY[11];
            // Units: dimensionless; Initial value: 0.57363
            double var_chaste_interface__delayed_rectifier_K_current_z_gate__z = rY[12];
            // Units: dimensionless; Initial value: 0.02032
            double var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a = rY[13];
            // Units: dimensionless; Initial value: 0.00016
            double var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i = rY[14];
            // Units: dimensionless; Initial value: 0.76898
            double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[15];
            // Units: millimolar; Initial value: 8.4
            double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[17];
            // Units: millimolar; Initial value: 100.0
            double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[22];
            // Units: millimolar; Initial value: 5.0
            
            const double var_x12 = var_chaste_interface__delayed_rectifier_K_current_pa_gate__p_a * var_chaste_interface__delayed_rectifier_K_current_pi_gate__p_i;
            const double var_x14 = pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s3_gate__s3, 6);
            const double var_x16 = 0.58999999999999997 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s1_gate__s1, 3) + 0.40999999999999998 * pow(var_chaste_interface__Ca_independent_transient_outward_K_current_s2_gate__s2, 3);
            const double var_x17 = var_x16 * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r;
            const double var_x19 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 3);
            const double var_x20 = 1 / var_chaste_interface__intracellular_ion_concentrations__K_i;
            const double var_x21 = log(var_x20 * var_chaste_interface__cleft_space_ion_concentrations__K_c);
            const double var_x22 = exp(0.18895643383558949 + 0.052487898287663745 * var_chaste_interface__membrane__V - 1.393 * var_x21);
            const double var_x23 = 1.0 + var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = 0.58999999999999997 + var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x26 = pow(var_x25, (-3));
            const double var_x27 = var_x24 * var_x26;
            const double var_x45 = -26.53945091048535 * var_x21 + var_chaste_interface__membrane__V;
            const double var_x46 = var_x22 * var_x26 * var_x45 / pow(var_x23, 2);
            const double var_x48 = exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V);
            const double var_x49 = 1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x50 = 1 / var_x49;
            const double var_x51 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5);
            const double var_x52 = 1 / (36.4828726939094 + var_x51);
            const double var_x53 = var_x51 * var_x52 * var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x80 = 1 / (1.5 + var_x48);
            const double var_x81 = var_x50 * var_x80;
            const double var_x82 = var_x52 * var_x81;
            const double var_x97 = 1 / var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x98 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 2);
            const double var_x99 = var_x27 * var_x98;
            const double var_x101 = var_x51 * var_x82;
            const double var_x102 = var_x19 * var_x24 / pow(var_x25, 4);
            const double var_x103 = var_x46 * var_x98;
            const double var_x104 = var_x53 * var_x80 / pow(var_x49, 2);
            const double var_x238 = 1.6583208100573134e-5 + 2.4874812150859699e-5 * var_x14;
            const double var_x239 = var_x17 * var_x238;
            const double var_x242 = 0.00027505727103636083 * var_chaste_interface__delayed_rectifier_K_current_z_gate__z;
            const double var_x243 = 0.00038508017945090519 * var_x12;
            const double var_x244 = 26.53945091048535 * var_x239;
            const double var_x245 = 0.00012635899136671262 * var_x45;
            
            partialF = 5.8672691657943555e-5 * var_x103 + 0.00085446536839159674 * var_x104 - 0.0011178327494917705 * var_x99 - 0.00085446536839159674 * var_x101 + var_x245 * var_x99 - var_x102 * var_x245 - var_x242 * var_x97 - var_x243 * var_x97 - var_x244 * var_x97;
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative23(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[23];
        // Units: millimolar; Initial value: 0.726776
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[24];
        // Units: millimolar; Initial value: 0.730866
        double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = rY[25];
        // Units: dimensionless; Initial value: 0.465921
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[27];
        // Units: dimensionless; Initial value: 0.002262
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__O_Calse_orig_deriv = -400.0 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse + 480.0 * (1.0 - var_chaste_interface__Ca_handling_by_the_SR__O_Calse) * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // 1 / second
        const double var_Ca_handling_by_the_SR__i_rel = 200.0 * pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel) / pow((0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2), 2); // picoA
        const double var_Ca_handling_by_the_SR__i_tr = 0.84908559999999988 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up - 0.84908559999999988 * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // picoA
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel = 0.11777375567316183 * var_Ca_handling_by_the_SR__i_tr - 0.11777375567316183 * var_Ca_handling_by_the_SR__i_rel - 0.031 * var_Ca_handling_by_the_SR__O_Calse_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative23(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = rY[25];
            // Units: dimensionless; Initial value: 0.465921
            double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[27];
            // Units: dimensionless; Initial value: 0.002262
            
            const double var_x217 = 0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2;
            const double var_x218 = pow(var_x217, (-2));
            const double var_x219 = pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2);
            const double var_x220 = var_x218 * var_x219;
            const double var_x246 = 23.554751134632365 * var_x220;
            
            partialF = -14.98 - var_x246 + 14.880000000000001 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative24(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[23];
        // Units: millimolar; Initial value: 0.726776
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[24];
        // Units: millimolar; Initial value: 0.730866
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__i_up = 2.7999999999999998 * (3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i - 0.32000000000000006 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up) / (1.3999999999999999 + 0.80000000000000004 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + 3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i); // picoA
        const double var_Ca_handling_by_the_SR__i_tr = 0.84908559999999988 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up - 0.84908559999999988 * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // picoA
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up = 0.01305629944474457 * var_Ca_handling_by_the_SR__i_up - 0.01305629944474457 * var_Ca_handling_by_the_SR__i_tr; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative24(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
            // Units: millimolar; Initial value: 7.1e-05
            double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[24];
            // Units: millimolar; Initial value: 0.730866
            
            const double var_x214 = 3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x215 = 1 / (1.3999999999999999 + var_x214 + 0.80000000000000004 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up);
            const double var_x216 = (var_x214 - 0.32000000000000006 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up) / pow((0.00041999999999999996 + 0.00023999999999999998 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2);
            
            partialF = -0.011085915847820609 - 2.6321499680605046e-9 * var_x216 - 0.011698444302491135 * var_x215;
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative25(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[23];
        // Units: millimolar; Initial value: 0.726776
        double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = rY[25];
        // Units: dimensionless; Initial value: 0.465921
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__O_Calse_orig_deriv = -400.0 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse + 480.0 * (1.0 - var_chaste_interface__Ca_handling_by_the_SR__O_Calse) * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // 1 / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse = 0.001 * var_Ca_handling_by_the_SR__O_Calse_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative25(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[23];
            // Units: millimolar; Initial value: 0.726776
            
            
            partialF = -0.40000000000000002 - 0.47999999999999998 * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative26(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__Ca_handling_by_the_SR__F1 = rY[26];
        // Units: dimensionless; Initial value: 0.288039
        double var_chaste_interface__Ca_handling_by_the_SR__F3 = rY[28];
        // Units: dimensionless; Initial value: 0.612697
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__r_act = 240.0 * exp(-1.6000000000000001 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1 = 0.00081499999999999997 * var_chaste_interface__Ca_handling_by_the_SR__F3 - 0.001 * var_chaste_interface__Ca_handling_by_the_SR__F1 * var_Ca_handling_by_the_SR__r_act; // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative26(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -80.0
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
            // Units: millimolar; Initial value: 7.1e-05
            
            const double var_x248 = exp(-1.6000000000000001 + 0.080000000000000002 * var_chaste_interface__membrane__V);
            const double var_x250 = 0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x251 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4);
            const double var_x254 = pow(var_x250, (-4));
            const double var_x257 = 0.23999999999999999 * var_x248;
            const double var_x258 = var_x251 * var_x254;
            const double var_x259 = 0.20380000000000001 * var_x258;
            
            partialF = -var_x257 - var_x259;
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative27(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -80.0
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__Ca_handling_by_the_SR__F1 = rY[26];
        // Units: dimensionless; Initial value: 0.288039
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[27];
        // Units: dimensionless; Initial value: 0.002262
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__r_inact = 33.960000000000001 + 339.60000000000002 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double var_Ca_handling_by_the_SR__r_act = 240.0 * exp(-1.6000000000000001 + 0.080000000000000002 * var_chaste_interface__membrane__V) + 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2 = 0.001 * var_chaste_interface__Ca_handling_by_the_SR__F1 * var_Ca_handling_by_the_SR__r_act - 0.001 * var_chaste_interface__Ca_handling_by_the_SR__F2 * var_Ca_handling_by_the_SR__r_inact; // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative27(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
            // Units: millimolar; Initial value: 7.1e-05
            
            const double var_x250 = 0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x251 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4);
            const double var_x254 = pow(var_x250, (-4));
            const double var_x258 = var_x251 * var_x254;
            const double var_x262 = 0.33960000000000001 * var_x258;
            
            partialF = -0.033960000000000004 - var_x262;
        }
        else
        {
            const double y_save = rY[27];
            rY[27] += delta;
            const double temp = EvaluateYDerivative27(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[27])/delta;
            rY[27] = y_save;
        }
        return partialF;
    }
    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluateYDerivative28(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[16];
        // Units: millimolar; Initial value: 7.1e-05
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[27];
        // Units: dimensionless; Initial value: 0.002262
        double var_chaste_interface__Ca_handling_by_the_SR__F3 = rY[28];
        // Units: dimensionless; Initial value: 0.612697
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__r_inact = 33.960000000000001 + 339.60000000000002 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F3 = -0.00081499999999999997 * var_chaste_interface__Ca_handling_by_the_SR__F3 + 0.001 * var_chaste_interface__Ca_handling_by_the_SR__F2 * var_Ca_handling_by_the_SR__r_inact; // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_handling_by_the_SR__F3;
    }

    double Cellaslanidi_model_2009FromCellMLGRL1Opt::EvaluatePartialDerivative28(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -0.00081499999999999997;
        }
        else
        {
            const double y_save = rY[28];
            rY[28] += delta;
            const double temp = EvaluateYDerivative28(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[28])/delta;
            rY[28] = y_save;
        }
        return partialF;
    }

    std::vector<double> Cellaslanidi_model_2009FromCellMLGRL1Opt::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(3);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__Cm_converted;
        dqs[2] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellaslanidi_model_2009FromCellMLGRL1Opt>::Initialise(void)
{
    this->mSystemName = "aslanidi_model_2009";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-80.0);

    // rY[1]:
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01309);

    // rY[2]:
    this->mVariableNames.push_back("sodium_current_h1_gate__h1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.706);

    // rY[3]:
    this->mVariableNames.push_back("sodium_current_h2_gate__h2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.61493);

    // rY[4]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_L_gate__d_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3e-05);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_L_gate__f_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99981);

    // rY[6]:
    this->mVariableNames.push_back("T_type_Ca_channel_d_T_gate__d_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00046);

    // rY[7]:
    this->mVariableNames.push_back("T_type_Ca_channel_f_T_gate__f_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.30752);

    // rY[8]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(6e-05);

    // rY[9]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s1_gate__s1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.5753);

    // rY[10]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s2_gate__s2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.39871);

    // rY[11]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s3_gate__s3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.57363);

    // rY[12]:
    this->mVariableNames.push_back("delayed_rectifier_K_current_z_gate__z");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.02032);

    // rY[13]:
    this->mVariableNames.push_back("delayed_rectifier_K_current_pa_gate__p_a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00016);

    // rY[14]:
    this->mVariableNames.push_back("delayed_rectifier_K_current_pi_gate__p_i");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.76898);

    // rY[15]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.4);

    // rY[16]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.1e-05);

    // rY[17]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(100.0);

    // rY[18]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.029108);

    // rY[19]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TC");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.014071);

    // rY[20]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TMgC");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.214036);

    // rY[21]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TMgMg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.693565);

    // rY[22]:
    this->mVariableNames.push_back("cleft_space_ion_concentrations__K_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.0);

    // rY[23]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.726776);

    // rY[24]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.730866);

    // rY[25]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__O_Calse");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.465921);

    // rY[26]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.288039);

    // rY[27]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.002262);

    // rY[28]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.612697);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("nanoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellaslanidi_model_2009FromCellMLGRL1Opt)

