//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: nygren_atrial_model_1998
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "nygren_atrial_model_1998.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellnygren_atrial_model_1998FromCellMLGRL1::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_chaste_interface__membrane__stim_amplitude_converted = -0.00027999999999999998 * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 6.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::GetIntracellularCalciumConcentration()
    {
        return mStateVariables[1];
    }
    Cellnygren_atrial_model_1998FromCellMLGRL1::Cellnygren_atrial_model_1998FromCellMLGRL1(boost::shared_ptr<AbstractIvpOdeSolver> /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractGeneralizedRushLarsenCardiacCell(
                29,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellnygren_atrial_model_1998FromCellMLGRL1>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        
        this->mParameters[0] = 0.050000000000000003; // (var_membrane__Cm) [nanoF]
    }

    Cellnygren_atrial_model_1998FromCellMLGRL1::~Cellnygren_atrial_model_1998FromCellMLGRL1()
    {
    }
    
    double Cellnygren_atrial_model_1998FromCellMLGRL1::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        if (!pStateVariables) pStateVariables = &rGetStateVariables();
        const std::vector<double>& rY = *pStateVariables;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0032017
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.8814
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.8742
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 1.3005e-05
        double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.0010678
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.949
        double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
        // Units: dimensionless; Initial value: 0.00015949
        double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
        // Units: dimensionless; Initial value: 0.9912
        double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
        // Units: dimensionless; Initial value: 0.0048357
        double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.0001
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
        // Units: millimolar; Initial value: 129.435
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
        // Units: millimolar; Initial value: 130.011
        double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
        // Units: millimolar; Initial value: 1.8147
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
        // Units: millimolar; Initial value: 5.3581
        
        const double var_Ca_independent_transient_outward_K_current__g_t = 7.5; // nanoS
        const double var_L_type_Ca_channel__E_Ca_app = 60.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 6.75; // nanoS
        const double var_L_type_Ca_channel__k_Ca = 0.025000000000000001; // millimolar
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.00029999999999999997; // per_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma = 0.45000000000000001; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__k_NaCa = 0.037484200000000002; // picoA_per_millimolar_4
        const double var_background_currents__g_B_Ca = 0.078681000000000001; // nanoS
        const double var_background_currents__g_B_Na = 0.060599; // nanoS
        const double var_delayed_rectifier_K_currents__g_Kr = 0.5; // nanoS
        const double var_delayed_rectifier_K_currents__g_Ks = 1.0; // nanoS
        const double var_L_type_Ca_channel__f_Ca = var_chaste_interface__intracellular_ion_concentrations__Ca_d / (var_L_type_Ca_channel__k_Ca + var_chaste_interface__intracellular_ion_concentrations__Ca_d); // dimensionless
        const double var_inward_rectifier__g_K1 = 3.0; // nanoS
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 306.14999999999998; // kelvin
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s; // picoA
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * ((1.0 - var_L_type_Ca_channel__f_Ca) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_L_type_Ca_channel__f_Ca * var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L; // picoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(var_Na_Ca_ion_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_ion_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_ion_exchanger_current__k_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) * var_Na_Ca_ion_exchanger_current__d_NaCa); // picoA
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // picoA
        const double var_delayed_rectifier_K_currents__i_Ks = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Ks * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n; // picoA
        const double var_delayed_rectifier_K_currents_pi_gate__p_i = 1 / (1.0 + exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents__i_Kr = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Kr * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a * var_delayed_rectifier_K_currents_pi_gate__p_i; // picoA
        const double var_inward_rectifier__i_K1 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / (1.0 + exp(1.5 * (3.6000000000000001 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP_max = 4.0; // picoA
        const double var_sarcolemmal_calcium_pump_current__k_CaP = 0.00020000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump_current__i_CaP = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_CaP_max / (var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_sarcolemmal_calcium_pump_current__k_CaP); // picoA
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // picoA
        const double var_sodium_current__P_Na = 0.0016000000000000001; // nanolitre_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA
        const double var_sodium_potassium_pump__i_NaK_max = 70.825299999999999; // picoA
        const double var_sodium_potassium_pump__k_NaK_K = 1.0; // millimolar
        const double var_sodium_potassium_pump__k_NaK_Na = 11.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c * var_sodium_potassium_pump__i_NaK_max / ((200.0 + var_chaste_interface__membrane__V) * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) + pow(var_sodium_potassium_pump__k_NaK_Na, 1.5)) * (var_chaste_interface__cleft_space_ion_concentrations__K_c + var_sodium_potassium_pump__k_NaK_K)); // picoA
        const double var_sustained_outward_K_current__g_sus = 2.75; // nanoS
        const double var_sustained_outward_K_current__i_sus = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_sustained_outward_K_current__g_sus * var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus; // picoA
        const double var_chaste_interface__i_ionic = 9.9999999999999995e-7 * (var_Ca_independent_transient_outward_K_current__i_t + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_delayed_rectifier_K_currents__i_Kr + var_delayed_rectifier_K_currents__i_Ks + var_inward_rectifier__i_K1 + var_sarcolemmal_calcium_pump_current__i_CaP + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_sustained_outward_K_current__i_sus) * HeartConfig::Instance()->GetCapacitance() / var_membrane__Cm_converted; // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellnygren_atrial_model_1998FromCellMLGRL1::UpdateTransmembranePotential(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        unsigned v_index = GetVoltageIndex();
        const double delta = 1e-8;

        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0032017
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.8814
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.8742
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 1.3005e-05
        double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.0010678
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.949
        double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
        // Units: dimensionless; Initial value: 0.00015949
        double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
        // Units: dimensionless; Initial value: 0.9912
        double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
        // Units: dimensionless; Initial value: 0.0048357
        double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.0001
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
        // Units: millimolar; Initial value: 129.435
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
        // Units: millimolar; Initial value: 130.011
        double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
        // Units: millimolar; Initial value: 1.8147
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
        // Units: millimolar; Initial value: 5.3581
        

        // Mathematics
        const double var_Ca_independent_transient_outward_K_current__g_t = 7.5; // nanoS
        const double var_L_type_Ca_channel__E_Ca_app = 60.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 6.75; // nanoS
        const double var_L_type_Ca_channel__k_Ca = 0.025000000000000001; // millimolar
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.00029999999999999997; // per_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma = 0.45000000000000001; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__k_NaCa = 0.037484200000000002; // picoA_per_millimolar_4
        const double var_background_currents__g_B_Ca = 0.078681000000000001; // nanoS
        const double var_background_currents__g_B_Na = 0.060599; // nanoS
        const double var_delayed_rectifier_K_currents__g_Kr = 0.5; // nanoS
        const double var_delayed_rectifier_K_currents__g_Ks = 1.0; // nanoS
        const double var_L_type_Ca_channel__f_Ca = var_chaste_interface__intracellular_ion_concentrations__Ca_d / (var_L_type_Ca_channel__k_Ca + var_chaste_interface__intracellular_ion_concentrations__Ca_d); // dimensionless
        const double var_inward_rectifier__g_K1 = 3.0; // nanoS
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 306.14999999999998; // kelvin
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s; // picoA
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * ((1.0 - var_L_type_Ca_channel__f_Ca) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_L_type_Ca_channel__f_Ca * var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L; // picoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(var_Na_Ca_ion_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_ion_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_ion_exchanger_current__k_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) * var_Na_Ca_ion_exchanger_current__d_NaCa); // picoA
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // picoA
        const double var_delayed_rectifier_K_currents__i_Ks = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Ks * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n; // picoA
        const double var_delayed_rectifier_K_currents_pi_gate__p_i = 1 / (1.0 + exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents__i_Kr = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Kr * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a * var_delayed_rectifier_K_currents_pi_gate__p_i; // picoA
        const double var_inward_rectifier__i_K1 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / (1.0 + exp(1.5 * (3.6000000000000001 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))); // picoA
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
        const double var_membrane__i_Stim = 1000000.0 * var_membrane__Cm_converted * var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP_max = 4.0; // picoA
        const double var_sarcolemmal_calcium_pump_current__k_CaP = 0.00020000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump_current__i_CaP = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_CaP_max / (var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_sarcolemmal_calcium_pump_current__k_CaP); // picoA
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // picoA
        const double var_sodium_current__P_Na = 0.0016000000000000001; // nanolitre_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA
        const double var_sodium_potassium_pump__i_NaK_max = 70.825299999999999; // picoA
        const double var_sodium_potassium_pump__k_NaK_K = 1.0; // millimolar
        const double var_sodium_potassium_pump__k_NaK_Na = 11.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c * var_sodium_potassium_pump__i_NaK_max / ((200.0 + var_chaste_interface__membrane__V) * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) + pow(var_sodium_potassium_pump__k_NaK_Na, 1.5)) * (var_chaste_interface__cleft_space_ion_concentrations__K_c + var_sodium_potassium_pump__k_NaK_K)); // picoA
        const double var_sustained_outward_K_current__g_sus = 2.75; // nanoS
        const double var_sustained_outward_K_current__i_sus = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_sustained_outward_K_current__g_sus * var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus; // picoA
        const double var_membrane__V_orig_deriv = -1.0 * (var_Ca_independent_transient_outward_K_current__i_t + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_delayed_rectifier_K_currents__i_Kr + var_delayed_rectifier_K_currents__i_Ks + var_inward_rectifier__i_K1 + var_membrane__i_Stim + var_sarcolemmal_calcium_pump_current__i_CaP + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_sustained_outward_K_current__i_sus) / mParameters[0]; // millivolt / second
        d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond

        double evalF = d_dt_chaste_interface_var_membrane__V;
        mEvalF[0] = d_dt_chaste_interface_var_membrane__V;
        double partialF = EvaluatePartialDerivative0(var_chaste_interface__environment__time_converted, rY, delta, true);
        if (fabs(partialF) < delta)
        {
            rY[v_index] += evalF*mDt;
        }
        else
        {
            rY[v_index] += (evalF/partialF)*(exp(partialF*mDt)-1.0);
        }
    }

    void Cellnygren_atrial_model_1998FromCellMLGRL1::ComputeOneStepExceptVoltage(double var_chaste_interface__environment__time_converted)
    {
        std::vector<double>& rY = rGetStateVariables();
        const double delta = 1e-8;

        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0032017
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.8814
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.8742
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 1.3005e-05
        double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.0010678
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.949
        double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
        // Units: dimensionless; Initial value: 0.00015949
        double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
        // Units: dimensionless; Initial value: 0.9912
        double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
        // Units: dimensionless; Initial value: 0.0048357
        double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.0001
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
        // Units: millimolar; Initial value: 129.435
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        double var_chaste_interface__intracellular_Ca_buffering__O_C = rY[17];
        // Units: dimensionless; Initial value: 0.0275
        double var_chaste_interface__intracellular_Ca_buffering__O_TC = rY[18];
        // Units: dimensionless; Initial value: 0.0133
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[19];
        // Units: dimensionless; Initial value: 0.1961
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[20];
        // Units: dimensionless; Initial value: 0.7094
        double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
        // Units: millimolar; Initial value: 130.011
        double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
        // Units: millimolar; Initial value: 1.8147
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
        // Units: millimolar; Initial value: 5.3581
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[24];
        // Units: millimolar; Initial value: 0.6465
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[25];
        // Units: millimolar; Initial value: 0.6646
        double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = rY[26];
        // Units: dimensionless; Initial value: 0.4369
        double var_chaste_interface__Ca_handling_by_the_SR__F1 = rY[27];
        // Units: dimensionless; Initial value: 0.4284
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[28];
        // Units: dimensionless; Initial value: 0.0028
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__I_up_max = 2800.0; // picoA
        const double var_Ca_handling_by_the_SR__O_Calse_orig_deriv = -400.0 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse + 480.0 * (1.0 - var_chaste_interface__Ca_handling_by_the_SR__O_Calse) * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // 1 / second
        const double var_Ca_handling_by_the_SR__Vol_rel = 4.4100000000000001e-5; // nanolitre
        const double var_Ca_handling_by_the_SR__Vol_up = 0.0003969; // nanolitre
        const double var_Ca_handling_by_the_SR__alpha_rel = 200000.0; // picoA_per_millimolar
        const double var_Ca_handling_by_the_SR__k_cyca = 0.00029999999999999997; // millimolar
        const double var_Ca_handling_by_the_SR__k_rel_d = 0.0030000000000000001; // millimolar
        const double var_Ca_handling_by_the_SR__k_rel_i = 0.00029999999999999997; // millimolar
        const double var_Ca_handling_by_the_SR__k_srca = 0.5; // millimolar
        const double var_Ca_handling_by_the_SR__k_xcs = 0.40000000000000002; // dimensionless
        const double var_Ca_handling_by_the_SR__r_recov = 0.81499999999999995; // per_second
        const double var_Ca_handling_by_the_SR__tau_tr = 0.01; // second
        const double var_Ca_independent_transient_outward_K_current__g_t = 7.5; // nanoS
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse = 0.001 * var_Ca_handling_by_the_SR__O_Calse_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel__E_Ca_app = 60.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 6.75; // nanoS
        const double var_L_type_Ca_channel__k_Ca = 0.025000000000000001; // millimolar
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.00029999999999999997; // per_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma = 0.45000000000000001; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__k_NaCa = 0.037484200000000002; // picoA_per_millimolar_4
        const double var_background_currents__g_B_Ca = 0.078681000000000001; // nanoS
        const double var_background_currents__g_B_Na = 0.060599; // nanoS
        const double var_cleft_space_ion_concentrations__Ca_b = 1.8; // millimolar
        const double var_cleft_space_ion_concentrations__K_b = 5.4000000000000004; // millimolar
        const double var_cleft_space_ion_concentrations__Na_b = 130.0; // millimolar
        const double var_cleft_space_ion_concentrations__tau_Ca = 24.699999999999999; // second
        const double var_cleft_space_ion_concentrations__tau_K = 10.0; // second
        const double var_cleft_space_ion_concentrations__tau_Na = 14.300000000000001; // second
        const double var_delayed_rectifier_K_currents__g_Kr = 0.5; // nanoS
        const double var_delayed_rectifier_K_currents__g_Ks = 1.0; // nanoS
        const double var_intracellular_Ca_buffering__Mg_i = 2.5; // millimolar
        const double var_intracellular_Ca_buffering__O_TMgMg_orig_deriv = -666.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgMg + 2000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_intracellular_Ca_buffering__Mg_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg = 0.001 * var_intracellular_Ca_buffering__O_TMgMg_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel__f_Ca = var_chaste_interface__intracellular_ion_concentrations__Ca_d / (var_L_type_Ca_channel__k_Ca + var_chaste_interface__intracellular_ion_concentrations__Ca_d); // dimensionless
        const double var_Ca_handling_by_the_SR__i_rel = pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel) * var_Ca_handling_by_the_SR__alpha_rel / pow((0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2), 2); // picoA
        const double var_Ca_handling_by_the_SR__i_up = (var_chaste_interface__intracellular_ion_concentrations__Ca_i / var_Ca_handling_by_the_SR__k_cyca - pow(var_Ca_handling_by_the_SR__k_xcs, 2) * var_chaste_interface__Ca_handling_by_the_SR__Ca_up / var_Ca_handling_by_the_SR__k_srca) * var_Ca_handling_by_the_SR__I_up_max / ((var_Ca_handling_by_the_SR__k_cyca + var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_Ca_handling_by_the_SR__k_cyca + (var_chaste_interface__Ca_handling_by_the_SR__Ca_up + var_Ca_handling_by_the_SR__k_srca) * var_Ca_handling_by_the_SR__k_xcs / var_Ca_handling_by_the_SR__k_srca); // picoA
        const double var_Ca_handling_by_the_SR__r_act = 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_d, 4) / pow((var_Ca_handling_by_the_SR__k_rel_d + var_chaste_interface__intracellular_ion_concentrations__Ca_d), 4) + 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((var_Ca_handling_by_the_SR__k_rel_i + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double var_Ca_handling_by_the_SR__F1_orig_deriv = (1.0 - var_chaste_interface__Ca_handling_by_the_SR__F1 - var_chaste_interface__Ca_handling_by_the_SR__F2) * var_Ca_handling_by_the_SR__r_recov - var_chaste_interface__Ca_handling_by_the_SR__F1 * var_Ca_handling_by_the_SR__r_act; // 1 / second
        const double var_Ca_handling_by_the_SR__r_inact = 33.960000000000001 + 339.60000000000002 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((var_Ca_handling_by_the_SR__k_rel_i + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double var_Ca_handling_by_the_SR__F2_orig_deriv = var_chaste_interface__Ca_handling_by_the_SR__F1 * var_Ca_handling_by_the_SR__r_act - var_chaste_interface__Ca_handling_by_the_SR__F2 * var_Ca_handling_by_the_SR__r_inact; // 1 / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1 = 0.001 * var_Ca_handling_by_the_SR__F1_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2 = 0.001 * var_Ca_handling_by_the_SR__F2_orig_deriv; // 1 / millisecond
        const double var_intracellular_Ca_buffering__O_C_orig_deriv = -476.0 * var_chaste_interface__intracellular_Ca_buffering__O_C + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_C) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C = 0.001 * var_intracellular_Ca_buffering__O_C_orig_deriv; // 1 / millisecond
        const double var_intracellular_Ca_buffering__O_TC_orig_deriv = -392.0 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 78400.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TC) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC = 0.001 * var_intracellular_Ca_buffering__O_TC_orig_deriv; // 1 / millisecond
        const double var_intracellular_Ca_buffering__O_TMgC_orig_deriv = -6.5999999999999996 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC = 0.001 * var_intracellular_Ca_buffering__O_TMgC_orig_deriv; // 1 / millisecond
        const double var_intracellular_Ca_buffering__dOCdt = var_intracellular_Ca_buffering__O_C_orig_deriv; // per_second
        const double var_intracellular_Ca_buffering__dOTCdt = var_intracellular_Ca_buffering__O_TC_orig_deriv; // per_second
        const double var_intracellular_Ca_buffering__dOTMgCdt = var_intracellular_Ca_buffering__O_TMgC_orig_deriv; // per_second
        const double var_intracellular_ion_concentrations__Vol_i = 0.0058840000000000003; // nanolitre
        const double var_cleft_space_ion_concentrations__Vol_c = 0.13600000000000001 * var_intracellular_ion_concentrations__Vol_i; // nanolitre
        const double var_intracellular_ion_concentrations__Vol_d = 0.02 * var_intracellular_ion_concentrations__Vol_i; // nanolitre
        const double var_intracellular_ion_concentrations__phi_Na_en = -1.6799999999999999; // picoA
        const double var_intracellular_ion_concentrations__tau_di = 0.01; // second
        const double var_inward_rectifier__g_K1 = 3.0; // nanoS
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_Ca_handling_by_the_SR__i_tr = 2.0 * (-var_chaste_interface__Ca_handling_by_the_SR__Ca_rel + var_chaste_interface__Ca_handling_by_the_SR__Ca_up) * var_Ca_handling_by_the_SR__Vol_rel * var_membrane__F / var_Ca_handling_by_the_SR__tau_tr; // picoA
        const double var_Ca_handling_by_the_SR__Ca_rel_orig_deriv = -31.0 * var_Ca_handling_by_the_SR__O_Calse_orig_deriv + 0.5 * (-var_Ca_handling_by_the_SR__i_rel + var_Ca_handling_by_the_SR__i_tr) / (var_Ca_handling_by_the_SR__Vol_rel * var_membrane__F); // millimolar / second
        const double var_Ca_handling_by_the_SR__Ca_up_orig_deriv = 0.5 * (-var_Ca_handling_by_the_SR__i_tr + var_Ca_handling_by_the_SR__i_up) / (var_Ca_handling_by_the_SR__Vol_up * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel = 0.001 * var_Ca_handling_by_the_SR__Ca_rel_orig_deriv; // millimolar / millisecond
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up = 0.001 * var_Ca_handling_by_the_SR__Ca_up_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__i_di = 2.0 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__intracellular_ion_concentrations__Ca_d) * var_intracellular_ion_concentrations__Vol_d * var_membrane__F / var_intracellular_ion_concentrations__tau_di; // picoA
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 306.14999999999998; // kelvin
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s; // picoA
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_infinity = 1 / (1.0 + exp(0.090909090909090912 - 0.090909090909090912 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_r_gate__tau_r = 0.0015 + 0.0035000000000000001 * exp(-0.0011111111111111111 * pow(var_chaste_interface__membrane__V, 2)); // second
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r + var_Ca_independent_transient_outward_K_current_r_gate__r_infinity) / var_Ca_independent_transient_outward_K_current_r_gate__tau_r; // 1 / second
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_infinity = 1 / (1.0 + exp(3.5217391304347827 + 0.086956521739130432 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s_gate__tau_s = 0.01414 + 0.48120000000000002 * exp(-12.275731601256398 * pow((1 + 0.019065776930409912 * var_chaste_interface__membrane__V), 2)); // second
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + var_Ca_independent_transient_outward_K_current_s_gate__s_infinity) / var_Ca_independent_transient_outward_K_current_s_gate__tau_s; // 1 / second
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r = 0.001 * var_Ca_independent_transient_outward_K_current_r_gate__r_orig_deriv; // 1 / millisecond
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_gate__s = 0.001 * var_Ca_independent_transient_outward_K_current_s_gate__s_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * ((1.0 - var_L_type_Ca_channel__f_Ca) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_L_type_Ca_channel__f_Ca * var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L; // picoA
        const double var_L_type_Ca_channel_d_L_gate__d_L_infinity = 1 / (1.0 + exp(-1.5517241379310345 - 0.17241379310344829 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_d_L_gate__tau_d_L = 0.002 + 0.0027000000000000001 * exp(-1.3611111111111112 * pow((1 + 0.028571428571428571 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_d_L_gate__d_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L + var_L_type_Ca_channel_d_L_gate__d_L_infinity) / var_L_type_Ca_channel_d_L_gate__tau_d_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L = 0.001 * var_L_type_Ca_channel_d_L_gate__d_L_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_L1_gate__f_L_infinity = 1 / (1.0 + exp(3.859154929577465 + 0.14084507042253522 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_L1_gate__tau_f_L1 = 0.01 + 0.161 * exp(-7.716049382716049 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_L1_gate__f_L_1_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 + var_L_type_Ca_channel_f_L1_gate__f_L_infinity) / var_L_type_Ca_channel_f_L1_gate__tau_f_L1; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_L1_gate__f_L_1 = 0.001 * var_L_type_Ca_channel_f_L1_gate__f_L_1_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_L2_gate__tau_f_L2 = 0.062600000000000003 + 1.3323 * exp(-7.9349335449315621 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_L2_gate__f_L_2_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_L_type_Ca_channel_f_L1_gate__f_L_infinity) / var_L_type_Ca_channel_f_L2_gate__tau_f_L2; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_L2_gate__f_L_2 = 0.001 * var_L_type_Ca_channel_f_L2_gate__f_L_2_orig_deriv; // 1 / millisecond
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(var_Na_Ca_ion_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_ion_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_ion_exchanger_current__k_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) * var_Na_Ca_ion_exchanger_current__d_NaCa); // picoA
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // picoA
        const double var_delayed_rectifier_K_currents__i_Ks = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Ks * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n; // picoA
        const double var_delayed_rectifier_K_currents_n_gate__n_infinity = 1 / (1.0 + exp(1.5669291338582676 - 0.07874015748031496 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents_n_gate__tau_n = 0.69999999999999996 + 0.40000000000000002 * exp(-pow((-1.0 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2)); // second
        const double var_delayed_rectifier_K_currents_n_gate__n_orig_deriv = (-var_chaste_interface__delayed_rectifier_K_currents_n_gate__n + var_delayed_rectifier_K_currents_n_gate__n_infinity) / var_delayed_rectifier_K_currents_n_gate__tau_n; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifier_K_currents_n_gate__n = 0.001 * var_delayed_rectifier_K_currents_n_gate__n_orig_deriv; // 1 / millisecond
        const double var_delayed_rectifier_K_currents_pa_gate__p_a_infinity = 1 / (1.0 + exp(-2.5 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents_pa_gate__tau_p_a = 0.031179999999999999 + 0.21718000000000001 * exp(-0.82285842787521646 * pow((1 + 0.049658350548228189 * var_chaste_interface__membrane__V), 2)); // second
        const double var_delayed_rectifier_K_currents_pa_gate__p_a_orig_deriv = (-var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a + var_delayed_rectifier_K_currents_pa_gate__p_a_infinity) / var_delayed_rectifier_K_currents_pa_gate__tau_p_a; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifier_K_currents_pa_gate__p_a = 0.001 * var_delayed_rectifier_K_currents_pa_gate__p_a_orig_deriv; // 1 / millisecond
        const double var_delayed_rectifier_K_currents_pi_gate__p_i = 1 / (1.0 + exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents__i_Kr = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Kr * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a * var_delayed_rectifier_K_currents_pi_gate__p_i; // picoA
        const double var_intracellular_ion_concentrations__Ca_d_orig_deriv = 0.5 * (-var_L_type_Ca_channel__i_Ca_L - var_intracellular_ion_concentrations__i_di) / (var_intracellular_ion_concentrations__Vol_d * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_d = 0.001 * var_intracellular_ion_concentrations__Ca_d_orig_deriv; // millimolar / millisecond
        const double var_inward_rectifier__i_K1 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / (1.0 + exp(1.5 * (3.6000000000000001 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP_max = 4.0; // picoA
        const double var_sarcolemmal_calcium_pump_current__k_CaP = 0.00020000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump_current__i_CaP = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_CaP_max / (var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_sarcolemmal_calcium_pump_current__k_CaP); // picoA
        const double var_cleft_space_ion_concentrations__Ca_c_orig_deriv = (-var_chaste_interface__cleft_space_ion_concentrations__Ca_c + var_cleft_space_ion_concentrations__Ca_b) / var_cleft_space_ion_concentrations__tau_Ca + 0.5 * (-2.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + var_L_type_Ca_channel__i_Ca_L + var_background_currents__i_B_Ca + var_sarcolemmal_calcium_pump_current__i_CaP) / (var_cleft_space_ion_concentrations__Vol_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__Ca_c = 0.001 * var_cleft_space_ion_concentrations__Ca_c_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__Ca_i_orig_deriv = -0.044999999999999998 * var_intracellular_Ca_buffering__dOCdt - 0.080000000000000002 * var_intracellular_Ca_buffering__dOTCdt - 0.16 * var_intracellular_Ca_buffering__dOTMgCdt + 0.5 * (-var_Ca_handling_by_the_SR__i_up - var_background_currents__i_B_Ca - var_sarcolemmal_calcium_pump_current__i_CaP + 2.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + var_Ca_handling_by_the_SR__i_rel + var_intracellular_ion_concentrations__i_di) / (var_intracellular_ion_concentrations__Vol_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = 0.001 * var_intracellular_ion_concentrations__Ca_i_orig_deriv; // millimolar / millisecond
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // picoA
        const double var_sodium_current__P_Na = 0.0016000000000000001; // nanolitre_per_second
        const double var_sodium_current_h1_gate__h_infinity = 1 / (1.0 + exp(12.0 + 0.18867924528301888 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h1_gate__tau_h1 = 0.00029999999999999997 + 0.029999999999999999 / (1.0 + exp(10.96875 + 0.3125 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h1_gate__h1_orig_deriv = (-var_chaste_interface__sodium_current_h1_gate__h1 + var_sodium_current_h1_gate__h_infinity) / var_sodium_current_h1_gate__tau_h1; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h1_gate__h1 = 0.001 * var_sodium_current_h1_gate__h1_orig_deriv; // 1 / millisecond
        const double var_sodium_current_h2_gate__tau_h2 = 0.0030000000000000001 + 0.12 / (1.0 + exp(10.96875 + 0.3125 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h2_gate__h2_orig_deriv = (-var_chaste_interface__sodium_current_h2_gate__h2 + var_sodium_current_h1_gate__h_infinity) / var_sodium_current_h2_gate__tau_h2; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h2_gate__h2 = 0.001 * var_sodium_current_h2_gate__h2_orig_deriv; // 1 / millisecond
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA
        const double var_sodium_current_m_gate__m_infinity = 1 / (1.0 + exp(-3.3032886723507917 - 0.12180267965895249 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_m_gate__tau_m = 2.4000000000000001e-5 + 4.1999999999999998e-5 * exp(-0.78827269000771605 * pow((1 + 0.039108330074305829 * var_chaste_interface__membrane__V), 2)); // second
        const double var_sodium_current_m_gate__m_orig_deriv = (-var_chaste_interface__sodium_current_m_gate__m + var_sodium_current_m_gate__m_infinity) / var_sodium_current_m_gate__tau_m; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * var_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond
        const double var_sodium_potassium_pump__i_NaK_max = 70.825299999999999; // picoA
        const double var_sodium_potassium_pump__k_NaK_K = 1.0; // millimolar
        const double var_sodium_potassium_pump__k_NaK_Na = 11.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c * var_sodium_potassium_pump__i_NaK_max / ((200.0 + var_chaste_interface__membrane__V) * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) + pow(var_sodium_potassium_pump__k_NaK_Na, 1.5)) * (var_chaste_interface__cleft_space_ion_concentrations__K_c + var_sodium_potassium_pump__k_NaK_K)); // picoA
        const double var_cleft_space_ion_concentrations__Na_c_orig_deriv = (-var_chaste_interface__cleft_space_ion_concentrations__Na_c + var_cleft_space_ion_concentrations__Na_b) / var_cleft_space_ion_concentrations__tau_Na + (3.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + 3.0 * var_sodium_potassium_pump__i_NaK + var_background_currents__i_B_Na + var_intracellular_ion_concentrations__phi_Na_en + var_sodium_current__i_Na) / (var_cleft_space_ion_concentrations__Vol_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__Na_c = 0.001 * var_cleft_space_ion_concentrations__Na_c_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__Na_i_orig_deriv = (-var_background_currents__i_B_Na - var_intracellular_ion_concentrations__phi_Na_en - var_sodium_current__i_Na - 3.0 * var_Na_Ca_ion_exchanger_current__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__Vol_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = 0.001 * var_intracellular_ion_concentrations__Na_i_orig_deriv; // millimolar / millisecond
        const double var_sustained_outward_K_current__g_sus = 2.75; // nanoS
        const double var_sustained_outward_K_current_r_sus_gate__r_sus_infinity = 1 / (1.0 + exp(-0.53749999999999998 - 0.125 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_outward_K_current_r_sus_gate__tau_r_sus = 0.00050000000000000001 + 0.0089999999999999993 / (1.0 + exp(0.41666666666666669 + 0.083333333333333329 * var_chaste_interface__membrane__V)); // second
        const double var_sustained_outward_K_current_r_sus_gate__r_sus_orig_deriv = (-var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus + var_sustained_outward_K_current_r_sus_gate__r_sus_infinity) / var_sustained_outward_K_current_r_sus_gate__tau_r_sus; // 1 / second
        const double d_dt_chaste_interface_var_sustained_outward_K_current_r_sus_gate__r_sus = 0.001 * var_sustained_outward_K_current_r_sus_gate__r_sus_orig_deriv; // 1 / millisecond
        const double var_sustained_outward_K_current__i_sus = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_sustained_outward_K_current__g_sus * var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus; // picoA
        const double var_cleft_space_ion_concentrations__K_c_orig_deriv = (-var_chaste_interface__cleft_space_ion_concentrations__K_c + var_cleft_space_ion_concentrations__K_b) / var_cleft_space_ion_concentrations__tau_K + (-2.0 * var_sodium_potassium_pump__i_NaK + var_Ca_independent_transient_outward_K_current__i_t + var_delayed_rectifier_K_currents__i_Kr + var_delayed_rectifier_K_currents__i_Ks + var_inward_rectifier__i_K1 + var_sustained_outward_K_current__i_sus) / (var_cleft_space_ion_concentrations__Vol_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c = 0.001 * var_cleft_space_ion_concentrations__K_c_orig_deriv; // millimolar / millisecond
        const double var_intracellular_ion_concentrations__K_i_orig_deriv = (-var_Ca_independent_transient_outward_K_current__i_t - var_delayed_rectifier_K_currents__i_Kr - var_delayed_rectifier_K_currents__i_Ks - var_inward_rectifier__i_K1 - var_sustained_outward_K_current__i_sus + 2.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__Vol_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = 0.001 * var_intracellular_ion_concentrations__K_i_orig_deriv; // millimolar / millisecond
        const double var_sustained_outward_K_current_s_sus_gate__s_sus_infinity = 0.59999999999999998 + 0.40000000000000002 / (1.0 + exp(2.0 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_outward_K_current_s_sus_gate__tau_s_sus = 0.29999999999999999 + 0.047 / (1.0 + exp(6.0 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // second
        const double var_sustained_outward_K_current_s_sus_gate__s_sus_orig_deriv = (-var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus + var_sustained_outward_K_current_s_sus_gate__s_sus_infinity) / var_sustained_outward_K_current_s_sus_gate__tau_s_sus; // 1 / second
        const double d_dt_chaste_interface_var_sustained_outward_K_current_s_sus_gate__s_sus = 0.001 * var_sustained_outward_K_current_s_sus_gate__s_sus_orig_deriv; // 1 / millisecond
        
        mEvalF[1] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
        mPartialF[1] = EvaluatePartialDerivative1(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[2] = d_dt_chaste_interface_var_sodium_current_m_gate__m;
        mPartialF[2] = EvaluatePartialDerivative2(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[3] = d_dt_chaste_interface_var_sodium_current_h1_gate__h1;
        mPartialF[3] = EvaluatePartialDerivative3(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[4] = d_dt_chaste_interface_var_sodium_current_h2_gate__h2;
        mPartialF[4] = EvaluatePartialDerivative4(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[5] = d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L;
        mPartialF[5] = EvaluatePartialDerivative5(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[6] = d_dt_chaste_interface_var_L_type_Ca_channel_f_L1_gate__f_L_1;
        mPartialF[6] = EvaluatePartialDerivative6(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[7] = d_dt_chaste_interface_var_L_type_Ca_channel_f_L2_gate__f_L_2;
        mPartialF[7] = EvaluatePartialDerivative7(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[8] = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r;
        mPartialF[8] = EvaluatePartialDerivative8(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[9] = d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_gate__s;
        mPartialF[9] = EvaluatePartialDerivative9(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[10] = d_dt_chaste_interface_var_sustained_outward_K_current_r_sus_gate__r_sus;
        mPartialF[10] = EvaluatePartialDerivative10(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[11] = d_dt_chaste_interface_var_sustained_outward_K_current_s_sus_gate__s_sus;
        mPartialF[11] = EvaluatePartialDerivative11(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[12] = d_dt_chaste_interface_var_delayed_rectifier_K_currents_n_gate__n;
        mPartialF[12] = EvaluatePartialDerivative12(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[13] = d_dt_chaste_interface_var_delayed_rectifier_K_currents_pa_gate__p_a;
        mPartialF[13] = EvaluatePartialDerivative13(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[14] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
        mPartialF[14] = EvaluatePartialDerivative14(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[15] = d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
        mPartialF[15] = EvaluatePartialDerivative15(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[16] = d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_d;
        mPartialF[16] = EvaluatePartialDerivative16(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[17] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C;
        mPartialF[17] = EvaluatePartialDerivative17(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[18] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC;
        mPartialF[18] = EvaluatePartialDerivative18(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[19] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC;
        mPartialF[19] = EvaluatePartialDerivative19(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[20] = d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg;
        mPartialF[20] = EvaluatePartialDerivative20(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[21] = d_dt_chaste_interface_var_cleft_space_ion_concentrations__Na_c;
        mPartialF[21] = EvaluatePartialDerivative21(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[22] = d_dt_chaste_interface_var_cleft_space_ion_concentrations__Ca_c;
        mPartialF[22] = EvaluatePartialDerivative22(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[23] = d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c;
        mPartialF[23] = EvaluatePartialDerivative23(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[24] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel;
        mPartialF[24] = EvaluatePartialDerivative24(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[25] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up;
        mPartialF[25] = EvaluatePartialDerivative25(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[26] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse;
        mPartialF[26] = EvaluatePartialDerivative26(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[27] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1;
        mPartialF[27] = EvaluatePartialDerivative27(var_chaste_interface__environment__time_converted, rY, delta);
        mEvalF[28] = d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2;
        mPartialF[28] = EvaluatePartialDerivative28(var_chaste_interface__environment__time_converted, rY, delta);
        
        {
            if (fabs(mPartialF[1]) < delta){
                rY[1] += mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
            }
            else
            {
                rY[1] += (d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i/mPartialF[1])*(exp(mPartialF[1]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[2]) < delta){
                rY[2] += mDt*d_dt_chaste_interface_var_sodium_current_m_gate__m;
            }
            else
            {
                rY[2] += (d_dt_chaste_interface_var_sodium_current_m_gate__m/mPartialF[2])*(exp(mPartialF[2]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[3]) < delta){
                rY[3] += mDt*d_dt_chaste_interface_var_sodium_current_h1_gate__h1;
            }
            else
            {
                rY[3] += (d_dt_chaste_interface_var_sodium_current_h1_gate__h1/mPartialF[3])*(exp(mPartialF[3]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[4]) < delta){
                rY[4] += mDt*d_dt_chaste_interface_var_sodium_current_h2_gate__h2;
            }
            else
            {
                rY[4] += (d_dt_chaste_interface_var_sodium_current_h2_gate__h2/mPartialF[4])*(exp(mPartialF[4]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[5]) < delta){
                rY[5] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L;
            }
            else
            {
                rY[5] += (d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L/mPartialF[5])*(exp(mPartialF[5]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[6]) < delta){
                rY[6] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_f_L1_gate__f_L_1;
            }
            else
            {
                rY[6] += (d_dt_chaste_interface_var_L_type_Ca_channel_f_L1_gate__f_L_1/mPartialF[6])*(exp(mPartialF[6]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[7]) < delta){
                rY[7] += mDt*d_dt_chaste_interface_var_L_type_Ca_channel_f_L2_gate__f_L_2;
            }
            else
            {
                rY[7] += (d_dt_chaste_interface_var_L_type_Ca_channel_f_L2_gate__f_L_2/mPartialF[7])*(exp(mPartialF[7]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[8]) < delta){
                rY[8] += mDt*d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r;
            }
            else
            {
                rY[8] += (d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r/mPartialF[8])*(exp(mPartialF[8]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[9]) < delta){
                rY[9] += mDt*d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_gate__s;
            }
            else
            {
                rY[9] += (d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_gate__s/mPartialF[9])*(exp(mPartialF[9]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[10]) < delta){
                rY[10] += mDt*d_dt_chaste_interface_var_sustained_outward_K_current_r_sus_gate__r_sus;
            }
            else
            {
                rY[10] += (d_dt_chaste_interface_var_sustained_outward_K_current_r_sus_gate__r_sus/mPartialF[10])*(exp(mPartialF[10]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[11]) < delta){
                rY[11] += mDt*d_dt_chaste_interface_var_sustained_outward_K_current_s_sus_gate__s_sus;
            }
            else
            {
                rY[11] += (d_dt_chaste_interface_var_sustained_outward_K_current_s_sus_gate__s_sus/mPartialF[11])*(exp(mPartialF[11]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[12]) < delta){
                rY[12] += mDt*d_dt_chaste_interface_var_delayed_rectifier_K_currents_n_gate__n;
            }
            else
            {
                rY[12] += (d_dt_chaste_interface_var_delayed_rectifier_K_currents_n_gate__n/mPartialF[12])*(exp(mPartialF[12]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[13]) < delta){
                rY[13] += mDt*d_dt_chaste_interface_var_delayed_rectifier_K_currents_pa_gate__p_a;
            }
            else
            {
                rY[13] += (d_dt_chaste_interface_var_delayed_rectifier_K_currents_pa_gate__p_a/mPartialF[13])*(exp(mPartialF[13]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[14]) < delta){
                rY[14] += mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
            }
            else
            {
                rY[14] += (d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i/mPartialF[14])*(exp(mPartialF[14]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[15]) < delta){
                rY[15] += mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
            }
            else
            {
                rY[15] += (d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i/mPartialF[15])*(exp(mPartialF[15]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[16]) < delta){
                rY[16] += mDt*d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_d;
            }
            else
            {
                rY[16] += (d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_d/mPartialF[16])*(exp(mPartialF[16]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[17]) < delta){
                rY[17] += mDt*d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C;
            }
            else
            {
                rY[17] += (d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C/mPartialF[17])*(exp(mPartialF[17]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[18]) < delta){
                rY[18] += mDt*d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC;
            }
            else
            {
                rY[18] += (d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC/mPartialF[18])*(exp(mPartialF[18]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[19]) < delta){
                rY[19] += mDt*d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC;
            }
            else
            {
                rY[19] += (d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC/mPartialF[19])*(exp(mPartialF[19]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[20]) < delta){
                rY[20] += mDt*d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg;
            }
            else
            {
                rY[20] += (d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg/mPartialF[20])*(exp(mPartialF[20]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[21]) < delta){
                rY[21] += mDt*d_dt_chaste_interface_var_cleft_space_ion_concentrations__Na_c;
            }
            else
            {
                rY[21] += (d_dt_chaste_interface_var_cleft_space_ion_concentrations__Na_c/mPartialF[21])*(exp(mPartialF[21]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[22]) < delta){
                rY[22] += mDt*d_dt_chaste_interface_var_cleft_space_ion_concentrations__Ca_c;
            }
            else
            {
                rY[22] += (d_dt_chaste_interface_var_cleft_space_ion_concentrations__Ca_c/mPartialF[22])*(exp(mPartialF[22]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[23]) < delta){
                rY[23] += mDt*d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c;
            }
            else
            {
                rY[23] += (d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c/mPartialF[23])*(exp(mPartialF[23]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[24]) < delta){
                rY[24] += mDt*d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel;
            }
            else
            {
                rY[24] += (d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel/mPartialF[24])*(exp(mPartialF[24]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[25]) < delta){
                rY[25] += mDt*d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up;
            }
            else
            {
                rY[25] += (d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up/mPartialF[25])*(exp(mPartialF[25]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[26]) < delta){
                rY[26] += mDt*d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse;
            }
            else
            {
                rY[26] += (d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse/mPartialF[26])*(exp(mPartialF[26]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[27]) < delta){
                rY[27] += mDt*d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1;
            }
            else
            {
                rY[27] += (d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1/mPartialF[27])*(exp(mPartialF[27]*mDt)-1.0);
            }
            
        }
        {
            if (fabs(mPartialF[28]) < delta){
                rY[28] += mDt*d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2;
            }
            else
            {
                rY[28] += (d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2/mPartialF[28])*(exp(mPartialF[28]*mDt)-1.0);
            }
            
        }        
        
    }
   
    
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        double d_dt_chaste_interface_var_membrane__V;
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0032017
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.8814
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.8742
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 1.3005e-05
        double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.0010678
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.949
        double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
        // Units: dimensionless; Initial value: 0.00015949
        double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
        // Units: dimensionless; Initial value: 0.9912
        double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
        // Units: dimensionless; Initial value: 0.0048357
        double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.0001
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
        // Units: millimolar; Initial value: 129.435
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
        // Units: millimolar; Initial value: 130.011
        double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
        // Units: millimolar; Initial value: 1.8147
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
        // Units: millimolar; Initial value: 5.3581
        
        
        // Mathematics
        const double var_Ca_independent_transient_outward_K_current__g_t = 7.5; // nanoS
        const double var_L_type_Ca_channel__E_Ca_app = 60.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 6.75; // nanoS
        const double var_L_type_Ca_channel__k_Ca = 0.025000000000000001; // millimolar
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.00029999999999999997; // per_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma = 0.45000000000000001; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__k_NaCa = 0.037484200000000002; // picoA_per_millimolar_4
        const double var_background_currents__g_B_Ca = 0.078681000000000001; // nanoS
        const double var_background_currents__g_B_Na = 0.060599; // nanoS
        const double var_delayed_rectifier_K_currents__g_Kr = 0.5; // nanoS
        const double var_delayed_rectifier_K_currents__g_Ks = 1.0; // nanoS
        const double var_L_type_Ca_channel__f_Ca = var_chaste_interface__intracellular_ion_concentrations__Ca_d / (var_L_type_Ca_channel__k_Ca + var_chaste_interface__intracellular_ion_concentrations__Ca_d); // dimensionless
        const double var_inward_rectifier__g_K1 = 3.0; // nanoS
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 306.14999999999998; // kelvin
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s; // picoA
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * ((1.0 - var_L_type_Ca_channel__f_Ca) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_L_type_Ca_channel__f_Ca * var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L; // picoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(var_Na_Ca_ion_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_ion_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_ion_exchanger_current__k_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) * var_Na_Ca_ion_exchanger_current__d_NaCa); // picoA
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // picoA
        const double var_delayed_rectifier_K_currents__i_Ks = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Ks * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n; // picoA
        const double var_delayed_rectifier_K_currents_pi_gate__p_i = 1 / (1.0 + exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents__i_Kr = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Kr * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a * var_delayed_rectifier_K_currents_pi_gate__p_i; // picoA
        const double var_inward_rectifier__i_K1 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / (1.0 + exp(1.5 * (3.6000000000000001 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))); // picoA
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
        const double var_membrane__i_Stim = 1000000.0 * var_membrane__Cm_converted * var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP_max = 4.0; // picoA
        const double var_sarcolemmal_calcium_pump_current__k_CaP = 0.00020000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump_current__i_CaP = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_CaP_max / (var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_sarcolemmal_calcium_pump_current__k_CaP); // picoA
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // picoA
        const double var_sodium_current__P_Na = 0.0016000000000000001; // nanolitre_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA
        const double var_sodium_potassium_pump__i_NaK_max = 70.825299999999999; // picoA
        const double var_sodium_potassium_pump__k_NaK_K = 1.0; // millimolar
        const double var_sodium_potassium_pump__k_NaK_Na = 11.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c * var_sodium_potassium_pump__i_NaK_max / ((200.0 + var_chaste_interface__membrane__V) * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) + pow(var_sodium_potassium_pump__k_NaK_Na, 1.5)) * (var_chaste_interface__cleft_space_ion_concentrations__K_c + var_sodium_potassium_pump__k_NaK_K)); // picoA
        const double var_sustained_outward_K_current__g_sus = 2.75; // nanoS
        const double var_sustained_outward_K_current__i_sus = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_sustained_outward_K_current__g_sus * var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus; // picoA
        const double var_membrane__V_orig_deriv = -1.0 * (var_Ca_independent_transient_outward_K_current__i_t + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_ion_exchanger_current__i_NaCa + var_background_currents__i_B_Ca + var_background_currents__i_B_Na + var_delayed_rectifier_K_currents__i_Kr + var_delayed_rectifier_K_currents__i_Ks + var_inward_rectifier__i_K1 + var_membrane__i_Stim + var_sarcolemmal_calcium_pump_current__i_CaP + var_sodium_current__i_Na + var_sodium_potassium_pump__i_NaK + var_sustained_outward_K_current__i_sus) / mParameters[0]; // millivolt / second
        d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond

        return d_dt_chaste_interface_var_membrane__V;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative0(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 6.729e-05
            double var_chaste_interface__sodium_current_m_gate__m = rY[2];
            // Units: dimensionless; Initial value: 0.0032017
            double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
            // Units: dimensionless; Initial value: 0.8814
            double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
            // Units: dimensionless; Initial value: 0.8742
            double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
            // Units: dimensionless; Initial value: 1.3005e-05
            double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
            // Units: dimensionless; Initial value: 0.9986
            double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
            // Units: dimensionless; Initial value: 0.9986
            double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
            // Units: dimensionless; Initial value: 0.0010678
            double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
            // Units: dimensionless; Initial value: 0.949
            double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
            // Units: dimensionless; Initial value: 0.00015949
            double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
            // Units: dimensionless; Initial value: 0.9912
            double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
            // Units: dimensionless; Initial value: 0.0048357
            double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
            // Units: dimensionless; Initial value: 0.0001
            double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
            // Units: millimolar; Initial value: 8.5547
            double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
            // Units: millimolar; Initial value: 129.435
            double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
            // Units: millimolar; Initial value: 7.2495e-05
            double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
            // Units: millimolar; Initial value: 130.011
            double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
            // Units: millimolar; Initial value: 1.8147
            double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
            // Units: millimolar; Initial value: 5.3581
            
            const double var_x0 = 0.025000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d;
            const double var_x1 = 1 / var_x0;
            const double var_x2 = var_x1 * var_chaste_interface__intracellular_ion_concentrations__Ca_d;
            const double var_x3 = 1.0 - var_x2;
            const double var_x4 = var_x3 * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2;
            const double var_x5 = var_x2 * var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1;
            const double var_x6 = exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V);
            const double var_x7 = 1.0 + var_x6;
            const double var_x8 = 1 / var_x7;
            const double var_x9 = var_x8 * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a;
            const double var_x10 = 1 / var_chaste_interface__intracellular_ion_concentrations__K_i;
            const double var_x11 = log(var_x10 * var_chaste_interface__cleft_space_ion_concentrations__K_c);
            const double var_x12 = exp(0.20470020580033774 + 0.056861168277871597 * var_chaste_interface__membrane__V - 1.5 * var_x11);
            const double var_x13 = 1.0 + var_x12;
            const double var_x14 = 1 / var_x13;
            const double var_x15 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999);
            const double var_x16 = var_x14 * var_x15;
            const double var_x17 = var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus;
            const double var_x18 = var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s;
            const double var_x19 = pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3);
            const double var_x20 = var_x19 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x21 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3);
            const double var_x22 = var_x21 * var_chaste_interface__cleft_space_ion_concentrations__Ca_c;
            const double var_x23 = 1.0 + 0.00029999999999999997 * var_x20 + 0.00029999999999999997 * var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = exp(0.017058350483361479 * var_chaste_interface__membrane__V);
            const double var_x26 = var_x22 * var_x25;
            const double var_x27 = exp(-0.020849095035219586 * var_chaste_interface__membrane__V);
            const double var_x28 = var_x20 * var_x27;
            const double var_x29 = var_x24 * (0.017058350483361479 * var_x26 + 0.020849095035219586 * var_x28);
            const double var_x30 = -26.380041870925616 * var_x11;
            const double var_x31 = var_x30 + var_chaste_interface__membrane__V;
            const double var_x32 = var_x31 * var_x6 * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a / pow(var_x7, 2);
            const double var_x33 = var_x12 * var_x31 / pow(var_x13, 2);
            const double var_x34 = var_x15 * var_x33;
            const double var_x35 = 1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x36 = 1 / var_x35;
            const double var_x37 = 1 / (200.0 + var_chaste_interface__membrane__V);
            const double var_x38 = var_x36 * var_x37 * var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x39 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5);
            const double var_x40 = 1 / (36.4828726939094 + var_x39);
            const double var_x41 = var_x39 * var_x40;
            const double var_x42 = 70.825299999999999 * var_x41;
            const double var_x43 = 0.037907445518581065 * var_chaste_interface__membrane__V;
            const double var_x44 = exp(var_x43);
            const double var_x45 = -1.0 + var_x44;
            const double var_x46 = 1 / var_x45;
            const double var_x47 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
            const double var_x48 = 0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1;
            const double var_x49 = var_x46 * var_x47 * var_x48;
            const double var_x50 = 5.8521211132021298 * var_x49;
            const double var_x51 = 1 / var_chaste_interface__intracellular_ion_concentrations__Na_i;
            const double var_x52 = var_x51 * var_chaste_interface__cleft_space_ion_concentrations__Na_c;
            const double var_x53 = exp(var_x43 - 1.0 * log(var_x52));
            const double var_x54 = -1.0 + var_x53;
            const double var_x55 = var_x54 * var_chaste_interface__cleft_space_ion_concentrations__Na_c;
            const double var_x56 = 0.22183896226684771 * var_chaste_interface__membrane__V;
            const double var_x57 = var_x49 * var_x53 * var_chaste_interface__cleft_space_ion_concentrations__Na_c;
            const double var_x58 = 0.0050000000000000001 * var_chaste_interface__membrane__V;
            const double var_x59 = 150.0 + var_chaste_interface__membrane__V;
            const double var_x60 = var_x36 * var_x59;
            const double var_x61 = var_x41 * var_x60 * var_chaste_interface__cleft_space_ion_concentrations__K_c / pow((1 + var_x58), 2);
            const double var_x62 = var_x44 * var_x47 * var_x48 * var_x55 / pow(var_x45, 2);
            const double var_x63 = 1 / mParameters[0];
            const double var_x64 = 0.001 * var_x63;
            
            partialF = -var_x64 * (0.13928000000000001 + 0.5 * var_x9 + var_chaste_interface__delayed_rectifier_K_currents_n_gate__n + 3.0 * var_x16 + 2.75 * var_x17 + 7.5 * var_x18 + 0.037484200000000002 * var_x29 - 0.0017706325 * var_x61 - 0.020833333333333332 * var_x32 - 0.17058350483361479 * var_x34 + var_x38 * var_x42 + var_x50 * var_x55 + var_x56 * var_x57 + (6.75 * var_x4 + 6.75 * var_x5) * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L - var_x56 * var_x62);
        }
        else
        {
            const double y_save = rY[0];
            rY[0] += delta;
            const double temp = EvaluateYDerivative0(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[0])/delta;
            rY[0] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        double var_chaste_interface__intracellular_Ca_buffering__O_C = rY[17];
        // Units: dimensionless; Initial value: 0.0275
        double var_chaste_interface__intracellular_Ca_buffering__O_TC = rY[18];
        // Units: dimensionless; Initial value: 0.0133
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[19];
        // Units: dimensionless; Initial value: 0.1961
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[20];
        // Units: dimensionless; Initial value: 0.7094
        double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
        // Units: millimolar; Initial value: 130.011
        double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
        // Units: millimolar; Initial value: 1.8147
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[24];
        // Units: millimolar; Initial value: 0.6465
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[25];
        // Units: millimolar; Initial value: 0.6646
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[28];
        // Units: dimensionless; Initial value: 0.0028
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__I_up_max = 2800.0; // picoA
        const double var_Ca_handling_by_the_SR__alpha_rel = 200000.0; // picoA_per_millimolar
        const double var_Ca_handling_by_the_SR__k_cyca = 0.00029999999999999997; // millimolar
        const double var_Ca_handling_by_the_SR__k_srca = 0.5; // millimolar
        const double var_Ca_handling_by_the_SR__k_xcs = 0.40000000000000002; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.00029999999999999997; // per_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma = 0.45000000000000001; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__k_NaCa = 0.037484200000000002; // picoA_per_millimolar_4
        const double var_background_currents__g_B_Ca = 0.078681000000000001; // nanoS
        const double var_Ca_handling_by_the_SR__i_rel = pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel) * var_Ca_handling_by_the_SR__alpha_rel / pow((0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2), 2); // picoA
        const double var_Ca_handling_by_the_SR__i_up = (var_chaste_interface__intracellular_ion_concentrations__Ca_i / var_Ca_handling_by_the_SR__k_cyca - pow(var_Ca_handling_by_the_SR__k_xcs, 2) * var_chaste_interface__Ca_handling_by_the_SR__Ca_up / var_Ca_handling_by_the_SR__k_srca) * var_Ca_handling_by_the_SR__I_up_max / ((var_Ca_handling_by_the_SR__k_cyca + var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_Ca_handling_by_the_SR__k_cyca + (var_chaste_interface__Ca_handling_by_the_SR__Ca_up + var_Ca_handling_by_the_SR__k_srca) * var_Ca_handling_by_the_SR__k_xcs / var_Ca_handling_by_the_SR__k_srca); // picoA
        const double var_intracellular_Ca_buffering__O_C_orig_deriv = -476.0 * var_chaste_interface__intracellular_Ca_buffering__O_C + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_C) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / second
        const double var_intracellular_Ca_buffering__O_TC_orig_deriv = -392.0 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 78400.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TC) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / second
        const double var_intracellular_Ca_buffering__O_TMgC_orig_deriv = -6.5999999999999996 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / second
        const double var_intracellular_Ca_buffering__dOCdt = var_intracellular_Ca_buffering__O_C_orig_deriv; // per_second
        const double var_intracellular_Ca_buffering__dOTCdt = var_intracellular_Ca_buffering__O_TC_orig_deriv; // per_second
        const double var_intracellular_Ca_buffering__dOTMgCdt = var_intracellular_Ca_buffering__O_TMgC_orig_deriv; // per_second
        const double var_intracellular_ion_concentrations__Vol_i = 0.0058840000000000003; // nanolitre
        const double var_intracellular_ion_concentrations__Vol_d = 0.02 * var_intracellular_ion_concentrations__Vol_i; // nanolitre
        const double var_intracellular_ion_concentrations__tau_di = 0.01; // second
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_intracellular_ion_concentrations__i_di = 2.0 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__intracellular_ion_concentrations__Ca_d) * var_intracellular_ion_concentrations__Vol_d * var_membrane__F / var_intracellular_ion_concentrations__tau_di; // picoA
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 306.14999999999998; // kelvin
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(var_Na_Ca_ion_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_ion_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_ion_exchanger_current__k_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) * var_Na_Ca_ion_exchanger_current__d_NaCa); // picoA
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP_max = 4.0; // picoA
        const double var_sarcolemmal_calcium_pump_current__k_CaP = 0.00020000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump_current__i_CaP = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_CaP_max / (var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_sarcolemmal_calcium_pump_current__k_CaP); // picoA
        const double var_intracellular_ion_concentrations__Ca_i_orig_deriv = -0.044999999999999998 * var_intracellular_Ca_buffering__dOCdt - 0.080000000000000002 * var_intracellular_Ca_buffering__dOTCdt - 0.16 * var_intracellular_Ca_buffering__dOTMgCdt + 0.5 * (-var_Ca_handling_by_the_SR__i_up - var_background_currents__i_B_Ca - var_sarcolemmal_calcium_pump_current__i_CaP + 2.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + var_Ca_handling_by_the_SR__i_rel + var_intracellular_ion_concentrations__i_di) / (var_intracellular_ion_concentrations__Vol_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i = 0.001 * var_intracellular_ion_concentrations__Ca_i_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_i;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative1(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 6.729e-05
            double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
            // Units: millimolar; Initial value: 8.5547
            double var_chaste_interface__intracellular_Ca_buffering__O_C = rY[17];
            // Units: dimensionless; Initial value: 0.0275
            double var_chaste_interface__intracellular_Ca_buffering__O_TC = rY[18];
            // Units: dimensionless; Initial value: 0.0133
            double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[19];
            // Units: dimensionless; Initial value: 0.1961
            double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[20];
            // Units: dimensionless; Initial value: 0.7094
            double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
            // Units: millimolar; Initial value: 130.011
            double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
            // Units: millimolar; Initial value: 1.8147
            double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[25];
            // Units: millimolar; Initial value: 0.6646
            double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[28];
            // Units: dimensionless; Initial value: 0.0028
            
            const double var_x19 = pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3);
            const double var_x20 = var_x19 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x21 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3);
            const double var_x22 = var_x21 * var_chaste_interface__cleft_space_ion_concentrations__Ca_c;
            const double var_x23 = 1.0 + 0.00029999999999999997 * var_x20 + 0.00029999999999999997 * var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = exp(0.017058350483361479 * var_chaste_interface__membrane__V);
            const double var_x26 = var_x22 * var_x25;
            const double var_x27 = exp(-0.020849095035219586 * var_chaste_interface__membrane__V);
            const double var_x28 = var_x20 * var_x27;
            const double var_x65 = 0.00020000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x66 = 1 / var_x65;
            const double var_x67 = 1 / var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x68 = var_chaste_interface__intracellular_ion_concentrations__Ca_i / pow(var_x65, 2);
            const double var_x70 = var_x19 * var_x27;
            const double var_x71 = (var_x26 - var_x28) / pow(var_x23, 2);
            const double var_x112 = 3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x113 = 1 / (1.3999999999999999 + var_x112 + 0.80000000000000004 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up);
            const double var_x114 = (var_x112 - 0.32000000000000006 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up) / pow((0.00041999999999999996 + 0.00023999999999999998 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2);
            const double var_x115 = 0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2;
            const double var_x116 = pow(var_x115, (-2));
            const double var_x117 = pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2);
            const double var_x118 = var_x116 * var_x117;
            const double var_x119 = 0.17614021922566686 * var_x118;
            const double var_x120 = 6.6024752054987431e-8 * var_x24;
            const double var_x121 = 1.9807425616496225e-11 * var_x71;
            
            partialF = -47.274000000000001 - var_x119 + 6.2720000000000002 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 32.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 32.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgMg + 7.3978892074780085e-7 * var_x114 + 3.5228043845133373e-6 * var_x68 + 9.0 * var_chaste_interface__intracellular_Ca_buffering__O_C - 3.5228043845133373e-6 * var_x66 - 8.2198768971977874 * var_x113 - 9.1399515314883814e-7 * var_x67 - var_x120 * var_x70 - var_x121 * var_x19;
        }
        else
        {
            const double y_save = rY[1];
            rY[1] += delta;
            const double temp = EvaluateYDerivative1(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[1])/delta;
            rY[1] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0032017
        
        
        // Mathematics
        const double var_sodium_current_m_gate__m_infinity = 1 / (1.0 + exp(-3.3032886723507917 - 0.12180267965895249 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_m_gate__tau_m = 2.4000000000000001e-5 + 4.1999999999999998e-5 * exp(-0.78827269000771605 * pow((1 + 0.039108330074305829 * var_chaste_interface__membrane__V), 2)); // second
        const double var_sodium_current_m_gate__m_orig_deriv = (-var_chaste_interface__sodium_current_m_gate__m + var_sodium_current_m_gate__m_infinity) / var_sodium_current_m_gate__tau_m; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * var_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_m_gate__m;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative2(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            
            const double var_x131 = exp(-0.78827269000771605 * pow((1 + 0.039108330074305829 * var_chaste_interface__membrane__V), 2));
            const double var_x132 = 1 / (2.4000000000000001e-5 + 4.1999999999999998e-5 * var_x131);
            
            partialF = -0.001 * var_x132;
        }
        else
        {
            const double y_save = rY[2];
            rY[2] += delta;
            const double temp = EvaluateYDerivative2(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[2])/delta;
            rY[2] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.8814
        
        
        // Mathematics
        const double var_sodium_current_h1_gate__h_infinity = 1 / (1.0 + exp(12.0 + 0.18867924528301888 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h1_gate__tau_h1 = 0.00029999999999999997 + 0.029999999999999999 / (1.0 + exp(10.96875 + 0.3125 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h1_gate__h1_orig_deriv = (-var_chaste_interface__sodium_current_h1_gate__h1 + var_sodium_current_h1_gate__h_infinity) / var_sodium_current_h1_gate__tau_h1; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h1_gate__h1 = 0.001 * var_sodium_current_h1_gate__h1_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_h1_gate__h1;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative3(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            
            const double var_x133 = exp(10.96875 + 0.3125 * var_chaste_interface__membrane__V);
            const double var_x134 = 1.0 + var_x133;
            const double var_x135 = 1 / var_x134;
            const double var_x136 = 1 / (0.00029999999999999997 + 0.029999999999999999 * var_x135);
            
            partialF = -0.001 * var_x136;
        }
        else
        {
            const double y_save = rY[3];
            rY[3] += delta;
            const double temp = EvaluateYDerivative3(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[3])/delta;
            rY[3] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.8742
        
        
        // Mathematics
        const double var_sodium_current_h1_gate__h_infinity = 1 / (1.0 + exp(12.0 + 0.18867924528301888 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h2_gate__tau_h2 = 0.0030000000000000001 + 0.12 / (1.0 + exp(10.96875 + 0.3125 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h2_gate__h2_orig_deriv = (-var_chaste_interface__sodium_current_h2_gate__h2 + var_sodium_current_h1_gate__h_infinity) / var_sodium_current_h2_gate__tau_h2; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h2_gate__h2 = 0.001 * var_sodium_current_h2_gate__h2_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_sodium_current_h2_gate__h2;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative4(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            
            const double var_x133 = exp(10.96875 + 0.3125 * var_chaste_interface__membrane__V);
            const double var_x134 = 1.0 + var_x133;
            const double var_x135 = 1 / var_x134;
            const double var_x142 = 1 / (0.0030000000000000001 + 0.12 * var_x135);
            
            partialF = -0.001 * var_x142;
        }
        else
        {
            const double y_save = rY[4];
            rY[4] += delta;
            const double temp = EvaluateYDerivative4(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[4])/delta;
            rY[4] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 1.3005e-05
        
        
        // Mathematics
        const double var_L_type_Ca_channel_d_L_gate__d_L_infinity = 1 / (1.0 + exp(-1.5517241379310345 - 0.17241379310344829 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_d_L_gate__tau_d_L = 0.002 + 0.0027000000000000001 * exp(-1.3611111111111112 * pow((1 + 0.028571428571428571 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_d_L_gate__d_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L + var_L_type_Ca_channel_d_L_gate__d_L_infinity) / var_L_type_Ca_channel_d_L_gate__tau_d_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L = 0.001 * var_L_type_Ca_channel_d_L_gate__d_L_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_d_L_gate__d_L;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative5(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            
            const double var_x145 = exp(-1.3611111111111112 * pow((1 + 0.028571428571428571 * var_chaste_interface__membrane__V), 2));
            const double var_x146 = 1 / (0.002 + 0.0027000000000000001 * var_x145);
            
            partialF = -0.001 * var_x146;
        }
        else
        {
            const double y_save = rY[5];
            rY[5] += delta;
            const double temp = EvaluateYDerivative5(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[5])/delta;
            rY[5] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
        // Units: dimensionless; Initial value: 0.9986
        
        
        // Mathematics
        const double var_L_type_Ca_channel_f_L1_gate__f_L_infinity = 1 / (1.0 + exp(3.859154929577465 + 0.14084507042253522 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_L1_gate__tau_f_L1 = 0.01 + 0.161 * exp(-7.716049382716049 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_L1_gate__f_L_1_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 + var_L_type_Ca_channel_f_L1_gate__f_L_infinity) / var_L_type_Ca_channel_f_L1_gate__tau_f_L1; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_L1_gate__f_L_1 = 0.001 * var_L_type_Ca_channel_f_L1_gate__f_L_1_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_f_L1_gate__f_L_1;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative6(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            
            const double var_x147 = pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2);
            const double var_x148 = exp(-7.716049382716049 * var_x147);
            const double var_x149 = 1 / (0.01 + 0.161 * var_x148);
            
            partialF = -0.001 * var_x149;
        }
        else
        {
            const double y_save = rY[6];
            rY[6] += delta;
            const double temp = EvaluateYDerivative6(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[6])/delta;
            rY[6] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
        // Units: dimensionless; Initial value: 0.9986
        
        
        // Mathematics
        const double var_L_type_Ca_channel_f_L1_gate__f_L_infinity = 1 / (1.0 + exp(3.859154929577465 + 0.14084507042253522 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_L2_gate__tau_f_L2 = 0.062600000000000003 + 1.3323 * exp(-7.9349335449315621 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)); // second
        const double var_L_type_Ca_channel_f_L2_gate__f_L_2_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_L_type_Ca_channel_f_L1_gate__f_L_infinity) / var_L_type_Ca_channel_f_L2_gate__tau_f_L2; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_L2_gate__f_L_2 = 0.001 * var_L_type_Ca_channel_f_L2_gate__f_L_2_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_L_type_Ca_channel_f_L2_gate__f_L_2;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative7(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            
            const double var_x147 = pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2);
            const double var_x154 = exp(-7.9349335449315621 * var_x147);
            const double var_x155 = 1 / (0.062600000000000003 + 1.3323 * var_x154);
            
            partialF = -0.001 * var_x155;
        }
        else
        {
            const double y_save = rY[7];
            rY[7] += delta;
            const double temp = EvaluateYDerivative7(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[7])/delta;
            rY[7] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.0010678
        
        
        // Mathematics
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_infinity = 1 / (1.0 + exp(0.090909090909090912 - 0.090909090909090912 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_r_gate__tau_r = 0.0015 + 0.0035000000000000001 * exp(-0.0011111111111111111 * pow(var_chaste_interface__membrane__V, 2)); // second
        const double var_Ca_independent_transient_outward_K_current_r_gate__r_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r + var_Ca_independent_transient_outward_K_current_r_gate__r_infinity) / var_Ca_independent_transient_outward_K_current_r_gate__tau_r; // 1 / second
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r = 0.001 * var_Ca_independent_transient_outward_K_current_r_gate__r_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_r_gate__r;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative8(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            
            const double var_x158 = exp(-0.0011111111111111111 * pow(var_chaste_interface__membrane__V, 2));
            const double var_x159 = 1 / (0.0015 + 0.0035000000000000001 * var_x158);
            
            partialF = -0.001 * var_x159;
        }
        else
        {
            const double y_save = rY[8];
            rY[8] += delta;
            const double temp = EvaluateYDerivative8(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[8])/delta;
            rY[8] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.949
        
        
        // Mathematics
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_infinity = 1 / (1.0 + exp(3.5217391304347827 + 0.086956521739130432 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_Ca_independent_transient_outward_K_current_s_gate__tau_s = 0.01414 + 0.48120000000000002 * exp(-12.275731601256398 * pow((1 + 0.019065776930409912 * var_chaste_interface__membrane__V), 2)); // second
        const double var_Ca_independent_transient_outward_K_current_s_gate__s_orig_deriv = (-var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s + var_Ca_independent_transient_outward_K_current_s_gate__s_infinity) / var_Ca_independent_transient_outward_K_current_s_gate__tau_s; // 1 / second
        const double d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_gate__s = 0.001 * var_Ca_independent_transient_outward_K_current_s_gate__s_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_independent_transient_outward_K_current_s_gate__s;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative9(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            
            const double var_x162 = exp(-12.275731601256398 * pow((1 + 0.019065776930409912 * var_chaste_interface__membrane__V), 2));
            const double var_x163 = 1 / (0.01414 + 0.48120000000000002 * var_x162);
            
            partialF = -0.001 * var_x163;
        }
        else
        {
            const double y_save = rY[9];
            rY[9] += delta;
            const double temp = EvaluateYDerivative9(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[9])/delta;
            rY[9] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
        // Units: dimensionless; Initial value: 0.00015949
        
        
        // Mathematics
        const double var_sustained_outward_K_current_r_sus_gate__r_sus_infinity = 1 / (1.0 + exp(-0.53749999999999998 - 0.125 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_outward_K_current_r_sus_gate__tau_r_sus = 0.00050000000000000001 + 0.0089999999999999993 / (1.0 + exp(0.41666666666666669 + 0.083333333333333329 * var_chaste_interface__membrane__V)); // second
        const double var_sustained_outward_K_current_r_sus_gate__r_sus_orig_deriv = (-var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus + var_sustained_outward_K_current_r_sus_gate__r_sus_infinity) / var_sustained_outward_K_current_r_sus_gate__tau_r_sus; // 1 / second
        const double d_dt_chaste_interface_var_sustained_outward_K_current_r_sus_gate__r_sus = 0.001 * var_sustained_outward_K_current_r_sus_gate__r_sus_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_sustained_outward_K_current_r_sus_gate__r_sus;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative10(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            
            const double var_x166 = exp(0.41666666666666669 + 0.083333333333333329 * var_chaste_interface__membrane__V);
            const double var_x167 = 1.0 + var_x166;
            const double var_x168 = 1 / var_x167;
            const double var_x169 = 1 / (0.00050000000000000001 + 0.0089999999999999993 * var_x168);
            
            partialF = -0.001 * var_x169;
        }
        else
        {
            const double y_save = rY[10];
            rY[10] += delta;
            const double temp = EvaluateYDerivative10(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[10])/delta;
            rY[10] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
        // Units: dimensionless; Initial value: 0.9912
        
        
        // Mathematics
        const double var_sustained_outward_K_current_s_sus_gate__s_sus_infinity = 0.59999999999999998 + 0.40000000000000002 / (1.0 + exp(2.0 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sustained_outward_K_current_s_sus_gate__tau_s_sus = 0.29999999999999999 + 0.047 / (1.0 + exp(6.0 + 0.10000000000000001 * var_chaste_interface__membrane__V)); // second
        const double var_sustained_outward_K_current_s_sus_gate__s_sus_orig_deriv = (-var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus + var_sustained_outward_K_current_s_sus_gate__s_sus_infinity) / var_sustained_outward_K_current_s_sus_gate__tau_s_sus; // 1 / second
        const double d_dt_chaste_interface_var_sustained_outward_K_current_s_sus_gate__s_sus = 0.001 * var_sustained_outward_K_current_s_sus_gate__s_sus_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_sustained_outward_K_current_s_sus_gate__s_sus;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative11(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            
            const double var_x170 = 0.10000000000000001 * var_chaste_interface__membrane__V;
            const double var_x173 = exp(6.0 + var_x170);
            const double var_x174 = 1.0 + var_x173;
            const double var_x175 = 1 / var_x174;
            const double var_x176 = 1 / (0.29999999999999999 + 0.047 * var_x175);
            
            partialF = -0.001 * var_x176;
        }
        else
        {
            const double y_save = rY[11];
            rY[11] += delta;
            const double temp = EvaluateYDerivative11(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[11])/delta;
            rY[11] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
        // Units: dimensionless; Initial value: 0.0048357
        
        
        // Mathematics
        const double var_delayed_rectifier_K_currents_n_gate__n_infinity = 1 / (1.0 + exp(1.5669291338582676 - 0.07874015748031496 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents_n_gate__tau_n = 0.69999999999999996 + 0.40000000000000002 * exp(-pow((-1.0 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2)); // second
        const double var_delayed_rectifier_K_currents_n_gate__n_orig_deriv = (-var_chaste_interface__delayed_rectifier_K_currents_n_gate__n + var_delayed_rectifier_K_currents_n_gate__n_infinity) / var_delayed_rectifier_K_currents_n_gate__tau_n; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifier_K_currents_n_gate__n = 0.001 * var_delayed_rectifier_K_currents_n_gate__n_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_delayed_rectifier_K_currents_n_gate__n;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative12(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            
            const double var_x179 = exp(-pow((-1.0 + 0.050000000000000003 * var_chaste_interface__membrane__V), 2));
            const double var_x180 = 1 / (0.69999999999999996 + 0.40000000000000002 * var_x179);
            
            partialF = -0.001 * var_x180;
        }
        else
        {
            const double y_save = rY[12];
            rY[12] += delta;
            const double temp = EvaluateYDerivative12(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[12])/delta;
            rY[12] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.0001
        
        
        // Mathematics
        const double var_delayed_rectifier_K_currents_pa_gate__p_a_infinity = 1 / (1.0 + exp(-2.5 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents_pa_gate__tau_p_a = 0.031179999999999999 + 0.21718000000000001 * exp(-0.82285842787521646 * pow((1 + 0.049658350548228189 * var_chaste_interface__membrane__V), 2)); // second
        const double var_delayed_rectifier_K_currents_pa_gate__p_a_orig_deriv = (-var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a + var_delayed_rectifier_K_currents_pa_gate__p_a_infinity) / var_delayed_rectifier_K_currents_pa_gate__tau_p_a; // 1 / second
        const double d_dt_chaste_interface_var_delayed_rectifier_K_currents_pa_gate__p_a = 0.001 * var_delayed_rectifier_K_currents_pa_gate__p_a_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_delayed_rectifier_K_currents_pa_gate__p_a;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative13(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            
            const double var_x183 = exp(-0.82285842787521646 * pow((1 + 0.049658350548228189 * var_chaste_interface__membrane__V), 2));
            const double var_x184 = 1 / (0.031179999999999999 + 0.21718000000000001 * var_x183);
            
            partialF = -0.001 * var_x184;
        }
        else
        {
            const double y_save = rY[13];
            rY[13] += delta;
            const double temp = EvaluateYDerivative13(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[13])/delta;
            rY[13] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0032017
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.8814
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.8742
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
        // Units: millimolar; Initial value: 130.011
        double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
        // Units: millimolar; Initial value: 1.8147
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
        // Units: millimolar; Initial value: 5.3581
        
        
        // Mathematics
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.00029999999999999997; // per_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma = 0.45000000000000001; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__k_NaCa = 0.037484200000000002; // picoA_per_millimolar_4
        const double var_background_currents__g_B_Na = 0.060599; // nanoS
        const double var_intracellular_ion_concentrations__Vol_i = 0.0058840000000000003; // nanolitre
        const double var_intracellular_ion_concentrations__phi_Na_en = -1.6799999999999999; // picoA
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 306.14999999999998; // kelvin
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(var_Na_Ca_ion_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_ion_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_ion_exchanger_current__k_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) * var_Na_Ca_ion_exchanger_current__d_NaCa); // picoA
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // picoA
        const double var_sodium_current__P_Na = 0.0016000000000000001; // nanolitre_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA
        const double var_sodium_potassium_pump__i_NaK_max = 70.825299999999999; // picoA
        const double var_sodium_potassium_pump__k_NaK_K = 1.0; // millimolar
        const double var_sodium_potassium_pump__k_NaK_Na = 11.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c * var_sodium_potassium_pump__i_NaK_max / ((200.0 + var_chaste_interface__membrane__V) * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) + pow(var_sodium_potassium_pump__k_NaK_Na, 1.5)) * (var_chaste_interface__cleft_space_ion_concentrations__K_c + var_sodium_potassium_pump__k_NaK_K)); // picoA
        const double var_intracellular_ion_concentrations__Na_i_orig_deriv = (-var_background_currents__i_B_Na - var_intracellular_ion_concentrations__phi_Na_en - var_sodium_current__i_Na - 3.0 * var_Na_Ca_ion_exchanger_current__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__Vol_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i = 0.001 * var_intracellular_ion_concentrations__Na_i_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__Na_i;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative14(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 6.729e-05
            double var_chaste_interface__sodium_current_m_gate__m = rY[2];
            // Units: dimensionless; Initial value: 0.0032017
            double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
            // Units: dimensionless; Initial value: 0.8814
            double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
            // Units: dimensionless; Initial value: 0.8742
            double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
            // Units: millimolar; Initial value: 8.5547
            double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
            // Units: millimolar; Initial value: 130.011
            double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
            // Units: millimolar; Initial value: 1.8147
            double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
            // Units: millimolar; Initial value: 5.3581
            
            const double var_x19 = pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3);
            const double var_x20 = var_x19 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x21 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3);
            const double var_x22 = var_x21 * var_chaste_interface__cleft_space_ion_concentrations__Ca_c;
            const double var_x23 = 1.0 + 0.00029999999999999997 * var_x20 + 0.00029999999999999997 * var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = exp(0.017058350483361479 * var_chaste_interface__membrane__V);
            const double var_x26 = var_x22 * var_x25;
            const double var_x27 = exp(-0.020849095035219586 * var_chaste_interface__membrane__V);
            const double var_x28 = var_x20 * var_x27;
            const double var_x35 = 1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x36 = 1 / var_x35;
            const double var_x37 = 1 / (200.0 + var_chaste_interface__membrane__V);
            const double var_x38 = var_x36 * var_x37 * var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x39 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5);
            const double var_x40 = 1 / (36.4828726939094 + var_x39);
            const double var_x43 = 0.037907445518581065 * var_chaste_interface__membrane__V;
            const double var_x44 = exp(var_x43);
            const double var_x45 = -1.0 + var_x44;
            const double var_x46 = 1 / var_x45;
            const double var_x47 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
            const double var_x48 = 0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1;
            const double var_x49 = var_x46 * var_x47 * var_x48;
            const double var_x51 = 1 / var_chaste_interface__intracellular_ion_concentrations__Na_i;
            const double var_x52 = var_x51 * var_chaste_interface__cleft_space_ion_concentrations__Na_c;
            const double var_x53 = exp(var_x43 - 1.0 * log(var_x52));
            const double var_x59 = 150.0 + var_chaste_interface__membrane__V;
            const double var_x71 = (var_x26 - var_x28) / pow(var_x23, 2);
            const double var_x84 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 2) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c;
            const double var_x85 = var_x25 * var_x84;
            const double var_x87 = var_x38 * var_x59;
            const double var_x88 = var_x40 * var_x87 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 0.5);
            const double var_x89 = var_x87 * pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 2.0) / pow((1 + 0.027410122234342148 * var_x39), 2);
            const double var_x186 = 1.0307938958145768e-5 * var_x49;
            const double var_x189 = 1.7826683054846602e-10 * var_x71;
            const double var_x190 = 5.942227684948868e-7 * var_x24;
            const double var_x191 = var_x186 * var_chaste_interface__membrane__V;
            const double var_x192 = var_x191 * var_x53;
            
            partialF = 4.2177556280432989e-7 * var_x89 - 0.00056138327409256303 * var_x88 - 2.8157848672826448e-6 * var_x51 + var_x189 * var_x84 - var_x190 * var_x85 - var_x192 * var_x52;
        }
        else
        {
            const double y_save = rY[14];
            rY[14] += delta;
            const double temp = EvaluateYDerivative14(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[14])/delta;
            rY[14] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative15(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.0010678
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.949
        double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
        // Units: dimensionless; Initial value: 0.00015949
        double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
        // Units: dimensionless; Initial value: 0.9912
        double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
        // Units: dimensionless; Initial value: 0.0048357
        double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.0001
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
        // Units: millimolar; Initial value: 129.435
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
        // Units: millimolar; Initial value: 5.3581
        
        
        // Mathematics
        const double var_Ca_independent_transient_outward_K_current__g_t = 7.5; // nanoS
        const double var_delayed_rectifier_K_currents__g_Kr = 0.5; // nanoS
        const double var_delayed_rectifier_K_currents__g_Ks = 1.0; // nanoS
        const double var_intracellular_ion_concentrations__Vol_i = 0.0058840000000000003; // nanolitre
        const double var_inward_rectifier__g_K1 = 3.0; // nanoS
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 306.14999999999998; // kelvin
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s; // picoA
        const double var_delayed_rectifier_K_currents__i_Ks = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Ks * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n; // picoA
        const double var_delayed_rectifier_K_currents_pi_gate__p_i = 1 / (1.0 + exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents__i_Kr = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Kr * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a * var_delayed_rectifier_K_currents_pi_gate__p_i; // picoA
        const double var_inward_rectifier__i_K1 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / (1.0 + exp(1.5 * (3.6000000000000001 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))); // picoA
        const double var_sodium_potassium_pump__i_NaK_max = 70.825299999999999; // picoA
        const double var_sodium_potassium_pump__k_NaK_K = 1.0; // millimolar
        const double var_sodium_potassium_pump__k_NaK_Na = 11.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c * var_sodium_potassium_pump__i_NaK_max / ((200.0 + var_chaste_interface__membrane__V) * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) + pow(var_sodium_potassium_pump__k_NaK_Na, 1.5)) * (var_chaste_interface__cleft_space_ion_concentrations__K_c + var_sodium_potassium_pump__k_NaK_K)); // picoA
        const double var_sustained_outward_K_current__g_sus = 2.75; // nanoS
        const double var_sustained_outward_K_current__i_sus = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_sustained_outward_K_current__g_sus * var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus; // picoA
        const double var_intracellular_ion_concentrations__K_i_orig_deriv = (-var_Ca_independent_transient_outward_K_current__i_t - var_delayed_rectifier_K_currents__i_Kr - var_delayed_rectifier_K_currents__i_Ks - var_inward_rectifier__i_K1 - var_sustained_outward_K_current__i_sus + 2.0 * var_sodium_potassium_pump__i_NaK) / (var_intracellular_ion_concentrations__Vol_i * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i = 0.001 * var_intracellular_ion_concentrations__K_i_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__K_i;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative15(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
            // Units: dimensionless; Initial value: 0.0010678
            double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
            // Units: dimensionless; Initial value: 0.949
            double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
            // Units: dimensionless; Initial value: 0.00015949
            double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
            // Units: dimensionless; Initial value: 0.9912
            double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
            // Units: dimensionless; Initial value: 0.0048357
            double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
            // Units: dimensionless; Initial value: 0.0001
            double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
            // Units: millimolar; Initial value: 129.435
            double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
            // Units: millimolar; Initial value: 5.3581
            
            const double var_x6 = exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V);
            const double var_x7 = 1.0 + var_x6;
            const double var_x8 = 1 / var_x7;
            const double var_x9 = var_x8 * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a;
            const double var_x10 = 1 / var_chaste_interface__intracellular_ion_concentrations__K_i;
            const double var_x11 = log(var_x10 * var_chaste_interface__cleft_space_ion_concentrations__K_c);
            const double var_x12 = exp(0.20470020580033774 + 0.056861168277871597 * var_chaste_interface__membrane__V - 1.5 * var_x11);
            const double var_x13 = 1.0 + var_x12;
            const double var_x14 = 1 / var_x13;
            const double var_x15 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999);
            const double var_x16 = var_x14 * var_x15;
            const double var_x17 = var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus;
            const double var_x18 = var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s;
            const double var_x30 = -26.380041870925616 * var_x11;
            const double var_x31 = var_x30 + var_chaste_interface__membrane__V;
            const double var_x33 = var_x12 * var_x31 / pow(var_x13, 2);
            const double var_x34 = var_x15 * var_x33;
            const double var_x94 = var_x10 * var_x16;
            const double var_x97 = var_x10 * var_x34;
            const double var_x196 = 4.6465863583271093e-5 * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n;
            const double var_x197 = 0.00034849397687453315 * var_x18;
            const double var_x198 = 0.00012778112485399551 * var_x17;
            const double var_x199 = 2.3232931791635546e-5 * var_x9;
            
            partialF = 7.9263098651550091e-6 * var_x97 - 0.00013939759074981328 * var_x94 - var_x10 * var_x196 - var_x10 * var_x197 - var_x10 * var_x198 - var_x10 * var_x199;
        }
        else
        {
            const double y_save = rY[15];
            rY[15] += delta;
            const double temp = EvaluateYDerivative15(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[15])/delta;
            rY[15] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative16(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 1.3005e-05
        double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        
        
        // Mathematics
        const double var_L_type_Ca_channel__E_Ca_app = 60.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 6.75; // nanoS
        const double var_L_type_Ca_channel__k_Ca = 0.025000000000000001; // millimolar
        const double var_L_type_Ca_channel__f_Ca = var_chaste_interface__intracellular_ion_concentrations__Ca_d / (var_L_type_Ca_channel__k_Ca + var_chaste_interface__intracellular_ion_concentrations__Ca_d); // dimensionless
        const double var_intracellular_ion_concentrations__Vol_i = 0.0058840000000000003; // nanolitre
        const double var_intracellular_ion_concentrations__Vol_d = 0.02 * var_intracellular_ion_concentrations__Vol_i; // nanolitre
        const double var_intracellular_ion_concentrations__tau_di = 0.01; // second
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_intracellular_ion_concentrations__i_di = 2.0 * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__intracellular_ion_concentrations__Ca_d) * var_intracellular_ion_concentrations__Vol_d * var_membrane__F / var_intracellular_ion_concentrations__tau_di; // picoA
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * ((1.0 - var_L_type_Ca_channel__f_Ca) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_L_type_Ca_channel__f_Ca * var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L; // picoA
        const double var_intracellular_ion_concentrations__Ca_d_orig_deriv = 0.5 * (-var_L_type_Ca_channel__i_Ca_L - var_intracellular_ion_concentrations__i_di) / (var_intracellular_ion_concentrations__Vol_d * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_d = 0.001 * var_intracellular_ion_concentrations__Ca_d_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_intracellular_ion_concentrations__Ca_d;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative16(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
            // Units: dimensionless; Initial value: 1.3005e-05
            double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
            // Units: dimensionless; Initial value: 0.9986
            double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
            // Units: dimensionless; Initial value: 0.9986
            double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
            // Units: millimolar; Initial value: 7.2495e-05
            
            const double var_x0 = 0.025000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d;
            const double var_x1 = 1 / var_x0;
            const double var_x98 = var_chaste_interface__intracellular_ion_concentrations__Ca_d / pow(var_x0, 2);
            const double var_x99 = var_x1 * var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 + (var_x98 - var_x1) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 - var_x98 * var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1;
            const double var_x200 = 0.017834197196598772 - 0.00029723661994331282 * var_chaste_interface__membrane__V;
            const double var_x201 = var_x200 * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L;
            
            partialF = -0.099999999999999992 + var_x201 * var_x99;
        }
        else
        {
            const double y_save = rY[16];
            rY[16] += delta;
            const double temp = EvaluateYDerivative16(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[16])/delta;
            rY[16] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative17(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__intracellular_Ca_buffering__O_C = rY[17];
        // Units: dimensionless; Initial value: 0.0275
        
        
        // Mathematics
        const double var_intracellular_Ca_buffering__O_C_orig_deriv = -476.0 * var_chaste_interface__intracellular_Ca_buffering__O_C + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_C) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C = 0.001 * var_intracellular_Ca_buffering__O_C_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_Ca_buffering__O_C;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative17(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 6.729e-05
            
            const double var_x202 = -200.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            
            partialF = -0.47599999999999998 + var_x202;
        }
        else
        {
            const double y_save = rY[17];
            rY[17] += delta;
            const double temp = EvaluateYDerivative17(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[17])/delta;
            rY[17] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative18(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__intracellular_Ca_buffering__O_TC = rY[18];
        // Units: dimensionless; Initial value: 0.0133
        
        
        // Mathematics
        const double var_intracellular_Ca_buffering__O_TC_orig_deriv = -392.0 * var_chaste_interface__intracellular_Ca_buffering__O_TC + 78400.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TC) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC = 0.001 * var_intracellular_Ca_buffering__O_TC_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TC;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative18(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 6.729e-05
            
            
            partialF = -0.39200000000000002 - 78.400000000000006 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
        }
        else
        {
            const double y_save = rY[18];
            rY[18] += delta;
            const double temp = EvaluateYDerivative18(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[18])/delta;
            rY[18] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative19(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[19];
        // Units: dimensionless; Initial value: 0.1961
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[20];
        // Units: dimensionless; Initial value: 0.7094
        
        
        // Mathematics
        const double var_intracellular_Ca_buffering__O_TMgC_orig_deriv = -6.5999999999999996 * var_chaste_interface__intracellular_Ca_buffering__O_TMgC + 200000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_chaste_interface__intracellular_ion_concentrations__Ca_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC = 0.001 * var_intracellular_Ca_buffering__O_TMgC_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgC;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative19(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 6.729e-05
            
            const double var_x202 = -200.0 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            
            partialF = -0.0066 + var_x202;
        }
        else
        {
            const double y_save = rY[19];
            rY[19] += delta;
            const double temp = EvaluateYDerivative19(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[19])/delta;
            rY[19] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative20(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgC = rY[19];
        // Units: dimensionless; Initial value: 0.1961
        double var_chaste_interface__intracellular_Ca_buffering__O_TMgMg = rY[20];
        // Units: dimensionless; Initial value: 0.7094
        
        
        // Mathematics
        const double var_intracellular_Ca_buffering__Mg_i = 2.5; // millimolar
        const double var_intracellular_Ca_buffering__O_TMgMg_orig_deriv = -666.0 * var_chaste_interface__intracellular_Ca_buffering__O_TMgMg + 2000.0 * (1.0 - var_chaste_interface__intracellular_Ca_buffering__O_TMgC - var_chaste_interface__intracellular_Ca_buffering__O_TMgMg) * var_intracellular_Ca_buffering__Mg_i; // 1 / second
        const double d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg = 0.001 * var_intracellular_Ca_buffering__O_TMgMg_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_intracellular_Ca_buffering__O_TMgMg;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative20(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            
            
            partialF = -5.6660000000000004;
        }
        else
        {
            const double y_save = rY[20];
            rY[20] += delta;
            const double temp = EvaluateYDerivative20(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[20])/delta;
            rY[20] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative21(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__sodium_current_m_gate__m = rY[2];
        // Units: dimensionless; Initial value: 0.0032017
        double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
        // Units: dimensionless; Initial value: 0.8814
        double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
        // Units: dimensionless; Initial value: 0.8742
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
        // Units: millimolar; Initial value: 130.011
        double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
        // Units: millimolar; Initial value: 1.8147
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
        // Units: millimolar; Initial value: 5.3581
        
        
        // Mathematics
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.00029999999999999997; // per_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma = 0.45000000000000001; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__k_NaCa = 0.037484200000000002; // picoA_per_millimolar_4
        const double var_background_currents__g_B_Na = 0.060599; // nanoS
        const double var_cleft_space_ion_concentrations__Na_b = 130.0; // millimolar
        const double var_cleft_space_ion_concentrations__tau_Na = 14.300000000000001; // second
        const double var_intracellular_ion_concentrations__Vol_i = 0.0058840000000000003; // nanolitre
        const double var_cleft_space_ion_concentrations__Vol_c = 0.13600000000000001 * var_intracellular_ion_concentrations__Vol_i; // nanolitre
        const double var_intracellular_ion_concentrations__phi_Na_en = -1.6799999999999999; // picoA
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 306.14999999999998; // kelvin
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(var_Na_Ca_ion_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_ion_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_ion_exchanger_current__k_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) * var_Na_Ca_ion_exchanger_current__d_NaCa); // picoA
        const double var_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Na_c / var_chaste_interface__intracellular_ion_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_background_currents__i_B_Na = (-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_background_currents__g_B_Na; // picoA
        const double var_sodium_current__P_Na = 0.0016000000000000001; // nanolitre_per_second
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * (0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1) * var_chaste_interface__cleft_space_ion_concentrations__Na_c * var_chaste_interface__membrane__V * var_sodium_current__P_Na / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA
        const double var_sodium_potassium_pump__i_NaK_max = 70.825299999999999; // picoA
        const double var_sodium_potassium_pump__k_NaK_K = 1.0; // millimolar
        const double var_sodium_potassium_pump__k_NaK_Na = 11.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c * var_sodium_potassium_pump__i_NaK_max / ((200.0 + var_chaste_interface__membrane__V) * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) + pow(var_sodium_potassium_pump__k_NaK_Na, 1.5)) * (var_chaste_interface__cleft_space_ion_concentrations__K_c + var_sodium_potassium_pump__k_NaK_K)); // picoA
        const double var_cleft_space_ion_concentrations__Na_c_orig_deriv = (-var_chaste_interface__cleft_space_ion_concentrations__Na_c + var_cleft_space_ion_concentrations__Na_b) / var_cleft_space_ion_concentrations__tau_Na + (3.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + 3.0 * var_sodium_potassium_pump__i_NaK + var_background_currents__i_B_Na + var_intracellular_ion_concentrations__phi_Na_en + var_sodium_current__i_Na) / (var_cleft_space_ion_concentrations__Vol_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__Na_c = 0.001 * var_cleft_space_ion_concentrations__Na_c_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_cleft_space_ion_concentrations__Na_c;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative21(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 6.729e-05
            double var_chaste_interface__sodium_current_m_gate__m = rY[2];
            // Units: dimensionless; Initial value: 0.0032017
            double var_chaste_interface__sodium_current_h1_gate__h1 = rY[3];
            // Units: dimensionless; Initial value: 0.8814
            double var_chaste_interface__sodium_current_h2_gate__h2 = rY[4];
            // Units: dimensionless; Initial value: 0.8742
            double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
            // Units: millimolar; Initial value: 8.5547
            double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
            // Units: millimolar; Initial value: 130.011
            double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
            // Units: millimolar; Initial value: 1.8147
            
            const double var_x19 = pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3);
            const double var_x20 = var_x19 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x21 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3);
            const double var_x22 = var_x21 * var_chaste_interface__cleft_space_ion_concentrations__Ca_c;
            const double var_x23 = 1.0 + 0.00029999999999999997 * var_x20 + 0.00029999999999999997 * var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = exp(0.017058350483361479 * var_chaste_interface__membrane__V);
            const double var_x26 = var_x22 * var_x25;
            const double var_x27 = exp(-0.020849095035219586 * var_chaste_interface__membrane__V);
            const double var_x28 = var_x20 * var_x27;
            const double var_x43 = 0.037907445518581065 * var_chaste_interface__membrane__V;
            const double var_x44 = exp(var_x43);
            const double var_x45 = -1.0 + var_x44;
            const double var_x46 = 1 / var_x45;
            const double var_x47 = pow(var_chaste_interface__sodium_current_m_gate__m, 3);
            const double var_x48 = 0.10000000000000001 * var_chaste_interface__sodium_current_h2_gate__h2 + 0.90000000000000002 * var_chaste_interface__sodium_current_h1_gate__h1;
            const double var_x49 = var_x46 * var_x47 * var_x48;
            const double var_x51 = 1 / var_chaste_interface__intracellular_ion_concentrations__Na_i;
            const double var_x52 = var_x51 * var_chaste_interface__cleft_space_ion_concentrations__Na_c;
            const double var_x53 = exp(var_x43 - 1.0 * log(var_x52));
            const double var_x54 = -1.0 + var_x53;
            const double var_x71 = (var_x26 - var_x28) / pow(var_x23, 2);
            const double var_x100 = 1 / var_chaste_interface__cleft_space_ion_concentrations__Na_c;
            const double var_x101 = pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 2) * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x102 = var_x101 * var_x27;
            const double var_x203 = 7.5793668809895348e-5 * var_x49;
            const double var_x207 = 4.369285062462403e-6 * var_x24;
            const double var_x208 = 1.3107855187387207e-9 * var_x71;
            const double var_x209 = var_x203 * var_chaste_interface__membrane__V;
            const double var_x210 = var_x209 * var_x53;
            
            partialF = -6.993006993006993e-5 - var_x210 - 2.0704300494725328e-5 * var_x100 + var_x209 * var_x54 - var_x101 * var_x208 - var_x102 * var_x207;
        }
        else
        {
            const double y_save = rY[21];
            rY[21] += delta;
            const double temp = EvaluateYDerivative21(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[21])/delta;
            rY[21] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative22(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L = rY[5];
        // Units: dimensionless; Initial value: 1.3005e-05
        double var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1 = rY[6];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 = rY[7];
        // Units: dimensionless; Initial value: 0.9986
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
        // Units: millimolar; Initial value: 130.011
        double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
        // Units: millimolar; Initial value: 1.8147
        
        
        // Mathematics
        const double var_L_type_Ca_channel__E_Ca_app = 60.0; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L = 6.75; // nanoS
        const double var_L_type_Ca_channel__k_Ca = 0.025000000000000001; // millimolar
        const double var_Na_Ca_ion_exchanger_current__d_NaCa = 0.00029999999999999997; // per_millimolar_4
        const double var_Na_Ca_ion_exchanger_current__gamma = 0.45000000000000001; // dimensionless
        const double var_Na_Ca_ion_exchanger_current__k_NaCa = 0.037484200000000002; // picoA_per_millimolar_4
        const double var_background_currents__g_B_Ca = 0.078681000000000001; // nanoS
        const double var_cleft_space_ion_concentrations__Ca_b = 1.8; // millimolar
        const double var_cleft_space_ion_concentrations__tau_Ca = 24.699999999999999; // second
        const double var_L_type_Ca_channel__f_Ca = var_chaste_interface__intracellular_ion_concentrations__Ca_d / (var_L_type_Ca_channel__k_Ca + var_chaste_interface__intracellular_ion_concentrations__Ca_d); // dimensionless
        const double var_intracellular_ion_concentrations__Vol_i = 0.0058840000000000003; // nanolitre
        const double var_cleft_space_ion_concentrations__Vol_c = 0.13600000000000001 * var_intracellular_ion_concentrations__Vol_i; // nanolitre
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 306.14999999999998; // kelvin
        const double var_background_currents__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__Ca_c / var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_app + var_chaste_interface__membrane__V) * ((1.0 - var_L_type_Ca_channel__f_Ca) * var_chaste_interface__L_type_Ca_channel_f_L2_gate__f_L_2 + var_L_type_Ca_channel__f_Ca * var_chaste_interface__L_type_Ca_channel_f_L1_gate__f_L_1) * var_L_type_Ca_channel__g_Ca_L * var_chaste_interface__L_type_Ca_channel_d_L_gate__d_L; // picoA
        const double var_Na_Ca_ion_exchanger_current__i_NaCa = (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c * exp(var_Na_Ca_ion_exchanger_current__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i * exp((-1.0 + var_Na_Ca_ion_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_ion_exchanger_current__k_NaCa / (1.0 + (pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3) * var_chaste_interface__intracellular_ion_concentrations__Ca_i + pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3) * var_chaste_interface__cleft_space_ion_concentrations__Ca_c) * var_Na_Ca_ion_exchanger_current__d_NaCa); // picoA
        const double var_background_currents__i_B_Ca = (-var_background_currents__E_Ca + var_chaste_interface__membrane__V) * var_background_currents__g_B_Ca; // picoA
        const double var_sarcolemmal_calcium_pump_current__i_CaP_max = 4.0; // picoA
        const double var_sarcolemmal_calcium_pump_current__k_CaP = 0.00020000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump_current__i_CaP = var_chaste_interface__intracellular_ion_concentrations__Ca_i * var_sarcolemmal_calcium_pump_current__i_CaP_max / (var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_sarcolemmal_calcium_pump_current__k_CaP); // picoA
        const double var_cleft_space_ion_concentrations__Ca_c_orig_deriv = (-var_chaste_interface__cleft_space_ion_concentrations__Ca_c + var_cleft_space_ion_concentrations__Ca_b) / var_cleft_space_ion_concentrations__tau_Ca + 0.5 * (-2.0 * var_Na_Ca_ion_exchanger_current__i_NaCa + var_L_type_Ca_channel__i_Ca_L + var_background_currents__i_B_Ca + var_sarcolemmal_calcium_pump_current__i_CaP) / (var_cleft_space_ion_concentrations__Vol_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__Ca_c = 0.001 * var_cleft_space_ion_concentrations__Ca_c_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_cleft_space_ion_concentrations__Ca_c;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative22(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 6.729e-05
            double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
            // Units: millimolar; Initial value: 8.5547
            double var_chaste_interface__cleft_space_ion_concentrations__Na_c = rY[21];
            // Units: millimolar; Initial value: 130.011
            double var_chaste_interface__cleft_space_ion_concentrations__Ca_c = rY[22];
            // Units: millimolar; Initial value: 1.8147
            
            const double var_x19 = pow(var_chaste_interface__cleft_space_ion_concentrations__Na_c, 3);
            const double var_x20 = var_x19 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x21 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 3);
            const double var_x22 = var_x21 * var_chaste_interface__cleft_space_ion_concentrations__Ca_c;
            const double var_x23 = 1.0 + 0.00029999999999999997 * var_x20 + 0.00029999999999999997 * var_x22;
            const double var_x24 = 1 / var_x23;
            const double var_x25 = exp(0.017058350483361479 * var_chaste_interface__membrane__V);
            const double var_x26 = var_x22 * var_x25;
            const double var_x27 = exp(-0.020849095035219586 * var_chaste_interface__membrane__V);
            const double var_x28 = var_x20 * var_x27;
            const double var_x71 = (var_x26 - var_x28) / pow(var_x23, 2);
            const double var_x103 = 1 / var_chaste_interface__cleft_space_ion_concentrations__Ca_c;
            const double var_x104 = var_x21 * var_x25;
            const double var_x211 = 1.4564283541541343e-10 * var_x71;
            const double var_x212 = 4.8547611805137808e-7 * var_x24;
            
            partialF = -4.048582995951417e-5 - 6.7205525966826332e-6 * var_x103 + var_x21 * var_x211 - var_x104 * var_x212;
        }
        else
        {
            const double y_save = rY[22];
            rY[22] += delta;
            const double temp = EvaluateYDerivative22(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[22])/delta;
            rY[22] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative23(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
        // Units: millivolt; Initial value: -74.2525
        double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
        // Units: dimensionless; Initial value: 0.0010678
        double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
        // Units: dimensionless; Initial value: 0.949
        double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
        // Units: dimensionless; Initial value: 0.00015949
        double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
        // Units: dimensionless; Initial value: 0.9912
        double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
        // Units: dimensionless; Initial value: 0.0048357
        double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
        // Units: dimensionless; Initial value: 0.0001
        double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
        // Units: millimolar; Initial value: 8.5547
        double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
        // Units: millimolar; Initial value: 129.435
        double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
        // Units: millimolar; Initial value: 5.3581
        
        
        // Mathematics
        const double var_Ca_independent_transient_outward_K_current__g_t = 7.5; // nanoS
        const double var_cleft_space_ion_concentrations__K_b = 5.4000000000000004; // millimolar
        const double var_cleft_space_ion_concentrations__tau_K = 10.0; // second
        const double var_delayed_rectifier_K_currents__g_Kr = 0.5; // nanoS
        const double var_delayed_rectifier_K_currents__g_Ks = 1.0; // nanoS
        const double var_intracellular_ion_concentrations__Vol_i = 0.0058840000000000003; // nanolitre
        const double var_cleft_space_ion_concentrations__Vol_c = 0.13600000000000001 * var_intracellular_ion_concentrations__Vol_i; // nanolitre
        const double var_inward_rectifier__g_K1 = 3.0; // nanoS
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 306.14999999999998; // kelvin
        const double var_Ca_independent_transient_outward_K_current__E_K = var_membrane__R * var_membrane__T * log(var_chaste_interface__cleft_space_ion_concentrations__K_c / var_chaste_interface__intracellular_ion_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_Ca_independent_transient_outward_K_current__i_t = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_Ca_independent_transient_outward_K_current__g_t * var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s; // picoA
        const double var_delayed_rectifier_K_currents__i_Ks = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Ks * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n; // picoA
        const double var_delayed_rectifier_K_currents_pi_gate__p_i = 1 / (1.0 + exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_delayed_rectifier_K_currents__i_Kr = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_delayed_rectifier_K_currents__g_Kr * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a * var_delayed_rectifier_K_currents_pi_gate__p_i; // picoA
        const double var_inward_rectifier__i_K1 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, 0.44569999999999999) * (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier__g_K1 / (1.0 + exp(1.5 * (3.6000000000000001 - var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))); // picoA
        const double var_sodium_potassium_pump__i_NaK_max = 70.825299999999999; // picoA
        const double var_sodium_potassium_pump__k_NaK_K = 1.0; // millimolar
        const double var_sodium_potassium_pump__k_NaK_Na = 11.0; // millimolar
        const double var_sodium_potassium_pump__i_NaK = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) * (150.0 + var_chaste_interface__membrane__V) * var_chaste_interface__cleft_space_ion_concentrations__K_c * var_sodium_potassium_pump__i_NaK_max / ((200.0 + var_chaste_interface__membrane__V) * (pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5) + pow(var_sodium_potassium_pump__k_NaK_Na, 1.5)) * (var_chaste_interface__cleft_space_ion_concentrations__K_c + var_sodium_potassium_pump__k_NaK_K)); // picoA
        const double var_sustained_outward_K_current__g_sus = 2.75; // nanoS
        const double var_sustained_outward_K_current__i_sus = (-var_Ca_independent_transient_outward_K_current__E_K + var_chaste_interface__membrane__V) * var_sustained_outward_K_current__g_sus * var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus; // picoA
        const double var_cleft_space_ion_concentrations__K_c_orig_deriv = (-var_chaste_interface__cleft_space_ion_concentrations__K_c + var_cleft_space_ion_concentrations__K_b) / var_cleft_space_ion_concentrations__tau_K + (-2.0 * var_sodium_potassium_pump__i_NaK + var_Ca_independent_transient_outward_K_current__i_t + var_delayed_rectifier_K_currents__i_Kr + var_delayed_rectifier_K_currents__i_Ks + var_inward_rectifier__i_K1 + var_sustained_outward_K_current__i_sus) / (var_cleft_space_ion_concentrations__Vol_c * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c = 0.001 * var_cleft_space_ion_concentrations__K_c_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_cleft_space_ion_concentrations__K_c;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative23(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : rY[0]);
            // Units: millivolt; Initial value: -74.2525
            double var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r = rY[8];
            // Units: dimensionless; Initial value: 0.0010678
            double var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s = rY[9];
            // Units: dimensionless; Initial value: 0.949
            double var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus = rY[10];
            // Units: dimensionless; Initial value: 0.00015949
            double var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus = rY[11];
            // Units: dimensionless; Initial value: 0.9912
            double var_chaste_interface__delayed_rectifier_K_currents_n_gate__n = rY[12];
            // Units: dimensionless; Initial value: 0.0048357
            double var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a = rY[13];
            // Units: dimensionless; Initial value: 0.0001
            double var_chaste_interface__intracellular_ion_concentrations__Na_i = rY[14];
            // Units: millimolar; Initial value: 8.5547
            double var_chaste_interface__intracellular_ion_concentrations__K_i = rY[15];
            // Units: millimolar; Initial value: 129.435
            double var_chaste_interface__cleft_space_ion_concentrations__K_c = rY[23];
            // Units: millimolar; Initial value: 5.3581
            
            const double var_x6 = exp(2.2916666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V);
            const double var_x7 = 1.0 + var_x6;
            const double var_x8 = 1 / var_x7;
            const double var_x9 = var_x8 * var_chaste_interface__delayed_rectifier_K_currents_pa_gate__p_a;
            const double var_x10 = 1 / var_chaste_interface__intracellular_ion_concentrations__K_i;
            const double var_x11 = log(var_x10 * var_chaste_interface__cleft_space_ion_concentrations__K_c);
            const double var_x12 = exp(0.20470020580033774 + 0.056861168277871597 * var_chaste_interface__membrane__V - 1.5 * var_x11);
            const double var_x13 = 1.0 + var_x12;
            const double var_x14 = 1 / var_x13;
            const double var_x17 = var_chaste_interface__sustained_outward_K_current_r_sus_gate__r_sus * var_chaste_interface__sustained_outward_K_current_s_sus_gate__s_sus;
            const double var_x18 = var_chaste_interface__Ca_independent_transient_outward_K_current_r_gate__r * var_chaste_interface__Ca_independent_transient_outward_K_current_s_gate__s;
            const double var_x30 = -26.380041870925616 * var_x11;
            const double var_x31 = var_x30 + var_chaste_interface__membrane__V;
            const double var_x33 = var_x12 * var_x31 / pow(var_x13, 2);
            const double var_x35 = 1.0 + var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x36 = 1 / var_x35;
            const double var_x37 = 1 / (200.0 + var_chaste_interface__membrane__V);
            const double var_x39 = pow(var_chaste_interface__intracellular_ion_concentrations__Na_i, 1.5);
            const double var_x40 = 1 / (36.4828726939094 + var_x39);
            const double var_x41 = var_x39 * var_x40;
            const double var_x59 = 150.0 + var_chaste_interface__membrane__V;
            const double var_x60 = var_x36 * var_x59;
            const double var_x105 = pow(var_chaste_interface__cleft_space_ion_concentrations__K_c, (-0.55430000000000001));
            const double var_x106 = var_x105 * var_x14;
            const double var_x107 = 1 / var_chaste_interface__cleft_space_ion_concentrations__K_c;
            const double var_x108 = var_x106 * var_x31;
            const double var_x109 = var_x105 * var_x33;
            const double var_x110 = var_x37 * var_x60;
            const double var_x111 = var_x37 * var_x59 * var_chaste_interface__cleft_space_ion_concentrations__K_c / pow(var_x35, 2);
            const double var_x216 = 0.0018345858630475916 * var_x41;
            const double var_x219 = 0.00034166076164169918 * var_chaste_interface__delayed_rectifier_K_currents_n_gate__n;
            const double var_x220 = 0.0025624557123127439 * var_x18;
            const double var_x221 = 0.00017083038082084959 * var_x9;
            const double var_x222 = 0.00093956709451467277 * var_x17;
            
            partialF = -0.0001 + 1.7317432876958762e-5 * var_x108 + 5.8281690184963299e-5 * var_x109 - 0.0010249822849250974 * var_x106 + var_x111 * var_x216 - var_x107 * var_x219 - var_x107 * var_x220 - var_x107 * var_x221 - var_x107 * var_x222 - var_x110 * var_x216;
        }
        else
        {
            const double y_save = rY[23];
            rY[23] += delta;
            const double temp = EvaluateYDerivative23(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[23])/delta;
            rY[23] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative24(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[24];
        // Units: millimolar; Initial value: 0.6465
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[25];
        // Units: millimolar; Initial value: 0.6646
        double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = rY[26];
        // Units: dimensionless; Initial value: 0.4369
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[28];
        // Units: dimensionless; Initial value: 0.0028
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__O_Calse_orig_deriv = -400.0 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse + 480.0 * (1.0 - var_chaste_interface__Ca_handling_by_the_SR__O_Calse) * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // 1 / second
        const double var_Ca_handling_by_the_SR__Vol_rel = 4.4100000000000001e-5; // nanolitre
        const double var_Ca_handling_by_the_SR__alpha_rel = 200000.0; // picoA_per_millimolar
        const double var_Ca_handling_by_the_SR__tau_tr = 0.01; // second
        const double var_Ca_handling_by_the_SR__i_rel = pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2) * (-var_chaste_interface__intracellular_ion_concentrations__Ca_i + var_chaste_interface__Ca_handling_by_the_SR__Ca_rel) * var_Ca_handling_by_the_SR__alpha_rel / pow((0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2), 2); // picoA
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_Ca_handling_by_the_SR__i_tr = 2.0 * (-var_chaste_interface__Ca_handling_by_the_SR__Ca_rel + var_chaste_interface__Ca_handling_by_the_SR__Ca_up) * var_Ca_handling_by_the_SR__Vol_rel * var_membrane__F / var_Ca_handling_by_the_SR__tau_tr; // picoA
        const double var_Ca_handling_by_the_SR__Ca_rel_orig_deriv = -31.0 * var_Ca_handling_by_the_SR__O_Calse_orig_deriv + 0.5 * (-var_Ca_handling_by_the_SR__i_rel + var_Ca_handling_by_the_SR__i_tr) / (var_Ca_handling_by_the_SR__Vol_rel * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel = 0.001 * var_Ca_handling_by_the_SR__Ca_rel_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_rel;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative24(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = rY[26];
            // Units: dimensionless; Initial value: 0.4369
            double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[28];
            // Units: dimensionless; Initial value: 0.0028
            
            const double var_x115 = 0.25 + var_chaste_interface__Ca_handling_by_the_SR__F2;
            const double var_x116 = pow(var_x115, (-2));
            const double var_x117 = pow(var_chaste_interface__Ca_handling_by_the_SR__F2, 2);
            const double var_x118 = var_x116 * var_x117;
            const double var_x223 = 23.501339000540224 * var_x118;
            
            partialF = -14.98 - var_x223 + 14.880000000000001 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse;
        }
        else
        {
            const double y_save = rY[24];
            rY[24] += delta;
            const double temp = EvaluateYDerivative24(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[24])/delta;
            rY[24] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative25(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[24];
        // Units: millimolar; Initial value: 0.6465
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[25];
        // Units: millimolar; Initial value: 0.6646
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__I_up_max = 2800.0; // picoA
        const double var_Ca_handling_by_the_SR__Vol_rel = 4.4100000000000001e-5; // nanolitre
        const double var_Ca_handling_by_the_SR__Vol_up = 0.0003969; // nanolitre
        const double var_Ca_handling_by_the_SR__k_cyca = 0.00029999999999999997; // millimolar
        const double var_Ca_handling_by_the_SR__k_srca = 0.5; // millimolar
        const double var_Ca_handling_by_the_SR__k_xcs = 0.40000000000000002; // dimensionless
        const double var_Ca_handling_by_the_SR__tau_tr = 0.01; // second
        const double var_Ca_handling_by_the_SR__i_up = (var_chaste_interface__intracellular_ion_concentrations__Ca_i / var_Ca_handling_by_the_SR__k_cyca - pow(var_Ca_handling_by_the_SR__k_xcs, 2) * var_chaste_interface__Ca_handling_by_the_SR__Ca_up / var_Ca_handling_by_the_SR__k_srca) * var_Ca_handling_by_the_SR__I_up_max / ((var_Ca_handling_by_the_SR__k_cyca + var_chaste_interface__intracellular_ion_concentrations__Ca_i) / var_Ca_handling_by_the_SR__k_cyca + (var_chaste_interface__Ca_handling_by_the_SR__Ca_up + var_Ca_handling_by_the_SR__k_srca) * var_Ca_handling_by_the_SR__k_xcs / var_Ca_handling_by_the_SR__k_srca); // picoA
        const double var_membrane__F = 96487.0; // coulomb_per_mole
        const double var_Ca_handling_by_the_SR__i_tr = 2.0 * (-var_chaste_interface__Ca_handling_by_the_SR__Ca_rel + var_chaste_interface__Ca_handling_by_the_SR__Ca_up) * var_Ca_handling_by_the_SR__Vol_rel * var_membrane__F / var_Ca_handling_by_the_SR__tau_tr; // picoA
        const double var_Ca_handling_by_the_SR__Ca_up_orig_deriv = 0.5 * (-var_Ca_handling_by_the_SR__i_tr + var_Ca_handling_by_the_SR__i_up) / (var_Ca_handling_by_the_SR__Vol_up * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up = 0.001 * var_Ca_handling_by_the_SR__Ca_up_orig_deriv; // millimolar / millisecond

        return d_dt_chaste_interface_var_Ca_handling_by_the_SR__Ca_up;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative25(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 6.729e-05
            double var_chaste_interface__Ca_handling_by_the_SR__Ca_up = rY[25];
            // Units: millimolar; Initial value: 0.6646
            
            const double var_x112 = 3333.3333333333335 * var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x113 = 1 / (1.3999999999999999 + var_x112 + 0.80000000000000004 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up);
            const double var_x114 = (var_x112 - 0.32000000000000006 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up) / pow((0.00041999999999999996 + 0.00023999999999999998 * var_chaste_interface__Ca_handling_by_the_SR__Ca_up + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 2);
            
            partialF = -0.011111111111111112 - 2.632149968060505e-9 * var_x114 - 0.011698444302491135 * var_x113;
        }
        else
        {
            const double y_save = rY[25];
            rY[25] += delta;
            const double temp = EvaluateYDerivative25(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[25])/delta;
            rY[25] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative26(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[24];
        // Units: millimolar; Initial value: 0.6465
        double var_chaste_interface__Ca_handling_by_the_SR__O_Calse = rY[26];
        // Units: dimensionless; Initial value: 0.4369
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__O_Calse_orig_deriv = -400.0 * var_chaste_interface__Ca_handling_by_the_SR__O_Calse + 480.0 * (1.0 - var_chaste_interface__Ca_handling_by_the_SR__O_Calse) * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel; // 1 / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse = 0.001 * var_Ca_handling_by_the_SR__O_Calse_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_handling_by_the_SR__O_Calse;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative26(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__Ca_handling_by_the_SR__Ca_rel = rY[24];
            // Units: millimolar; Initial value: 0.6465
            
            
            partialF = -0.40000000000000002 - 0.47999999999999998 * var_chaste_interface__Ca_handling_by_the_SR__Ca_rel;
        }
        else
        {
            const double y_save = rY[26];
            rY[26] += delta;
            const double temp = EvaluateYDerivative26(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[26])/delta;
            rY[26] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative27(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        double var_chaste_interface__Ca_handling_by_the_SR__F1 = rY[27];
        // Units: dimensionless; Initial value: 0.4284
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[28];
        // Units: dimensionless; Initial value: 0.0028
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__k_rel_d = 0.0030000000000000001; // millimolar
        const double var_Ca_handling_by_the_SR__k_rel_i = 0.00029999999999999997; // millimolar
        const double var_Ca_handling_by_the_SR__r_recov = 0.81499999999999995; // per_second
        const double var_Ca_handling_by_the_SR__r_act = 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_d, 4) / pow((var_Ca_handling_by_the_SR__k_rel_d + var_chaste_interface__intracellular_ion_concentrations__Ca_d), 4) + 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((var_Ca_handling_by_the_SR__k_rel_i + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double var_Ca_handling_by_the_SR__F1_orig_deriv = (1.0 - var_chaste_interface__Ca_handling_by_the_SR__F1 - var_chaste_interface__Ca_handling_by_the_SR__F2) * var_Ca_handling_by_the_SR__r_recov - var_chaste_interface__Ca_handling_by_the_SR__F1 * var_Ca_handling_by_the_SR__r_act; // 1 / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1 = 0.001 * var_Ca_handling_by_the_SR__F1_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_handling_by_the_SR__F1;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative27(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 6.729e-05
            double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
            // Units: millimolar; Initial value: 7.2495e-05
            
            const double var_x225 = 0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x226 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4);
            const double var_x229 = pow(var_x225, (-4));
            const double var_x232 = 0.0030000000000000001 + var_chaste_interface__intracellular_ion_concentrations__Ca_d;
            const double var_x233 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_d, 4);
            const double var_x235 = pow(var_x232, (-4));
            const double var_x237 = 0.20380000000000001 * var_x233 * var_x235;
            const double var_x238 = var_x226 * var_x229;
            const double var_x239 = 0.20380000000000001 * var_x238;
            
            partialF = -0.00081499999999999997 - var_x237 - var_x239;
        }
        else
        {
            const double y_save = rY[27];
            rY[27] += delta;
            const double temp = EvaluateYDerivative27(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[27])/delta;
            rY[27] = y_save;
        }
        return partialF;
    }
    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluateYDerivative28(double var_chaste_interface__environment__time_converted, std::vector<double>& rY)
    {
        
        double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
        // Units: millimolar; Initial value: 6.729e-05
        double var_chaste_interface__intracellular_ion_concentrations__Ca_d = rY[16];
        // Units: millimolar; Initial value: 7.2495e-05
        double var_chaste_interface__Ca_handling_by_the_SR__F1 = rY[27];
        // Units: dimensionless; Initial value: 0.4284
        double var_chaste_interface__Ca_handling_by_the_SR__F2 = rY[28];
        // Units: dimensionless; Initial value: 0.0028
        
        
        // Mathematics
        const double var_Ca_handling_by_the_SR__k_rel_d = 0.0030000000000000001; // millimolar
        const double var_Ca_handling_by_the_SR__k_rel_i = 0.00029999999999999997; // millimolar
        const double var_Ca_handling_by_the_SR__r_act = 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_d, 4) / pow((var_Ca_handling_by_the_SR__k_rel_d + var_chaste_interface__intracellular_ion_concentrations__Ca_d), 4) + 203.80000000000001 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((var_Ca_handling_by_the_SR__k_rel_i + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double var_Ca_handling_by_the_SR__r_inact = 33.960000000000001 + 339.60000000000002 * pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4) / pow((var_Ca_handling_by_the_SR__k_rel_i + var_chaste_interface__intracellular_ion_concentrations__Ca_i), 4); // per_second
        const double var_Ca_handling_by_the_SR__F2_orig_deriv = var_chaste_interface__Ca_handling_by_the_SR__F1 * var_Ca_handling_by_the_SR__r_act - var_chaste_interface__Ca_handling_by_the_SR__F2 * var_Ca_handling_by_the_SR__r_inact; // 1 / second
        const double d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2 = 0.001 * var_Ca_handling_by_the_SR__F2_orig_deriv; // 1 / millisecond

        return d_dt_chaste_interface_var_Ca_handling_by_the_SR__F2;
    }

    double Cellnygren_atrial_model_1998FromCellMLGRL1::EvaluatePartialDerivative28(double var_chaste_interface__environment__time_converted, std::vector<double>& rY, double delta, bool forceNumerical)
    {
        double partialF;
        if (!forceNumerical && this->mUseAnalyticJacobian)
        {
            double var_chaste_interface__intracellular_ion_concentrations__Ca_i = rY[1];
            // Units: millimolar; Initial value: 6.729e-05
            
            const double var_x225 = 0.00029999999999999997 + var_chaste_interface__intracellular_ion_concentrations__Ca_i;
            const double var_x226 = pow(var_chaste_interface__intracellular_ion_concentrations__Ca_i, 4);
            const double var_x229 = pow(var_x225, (-4));
            const double var_x238 = var_x226 * var_x229;
            
            partialF = -0.033960000000000004 - 0.33960000000000001 * var_x238;
        }
        else
        {
            const double y_save = rY[28];
            rY[28] += delta;
            const double temp = EvaluateYDerivative28(var_chaste_interface__environment__time_converted, rY);
            partialF = (temp-mEvalF[28])/delta;
            rY[28] = y_save;
        }
        return partialF;
    }

    std::vector<double> Cellnygren_atrial_model_1998FromCellMLGRL1::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const std::vector<double> & rY)
    {
        // Inputs:
        // Time units: millisecond
        

        // Mathematics
        const double var_membrane__Cm_converted = 0.001 * mParameters[0]; // uF
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        std::vector<double> dqs(3);
        dqs[0] = var_chaste_interface__environment__time_converted;
        dqs[1] = var_membrane__Cm_converted;
        dqs[2] = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellnygren_atrial_model_1998FromCellMLGRL1>::Initialise(void)
{
    this->mSystemName = "nygren_atrial_model_1998";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // rY[0]:
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-74.2525);

    // rY[1]:
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(6.729e-05);

    // rY[2]:
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0032017);

    // rY[3]:
    this->mVariableNames.push_back("sodium_current_h1_gate__h1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8814);

    // rY[4]:
    this->mVariableNames.push_back("sodium_current_h2_gate__h2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.8742);

    // rY[5]:
    this->mVariableNames.push_back("L_type_Ca_channel_d_L_gate__d_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.3005e-05);

    // rY[6]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_L1_gate__f_L_1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9986);

    // rY[7]:
    this->mVariableNames.push_back("L_type_Ca_channel_f_L2_gate__f_L_2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9986);

    // rY[8]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0010678);

    // rY[9]:
    this->mVariableNames.push_back("Ca_independent_transient_outward_K_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.949);

    // rY[10]:
    this->mVariableNames.push_back("sustained_outward_K_current_r_sus_gate__r_sus");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00015949);

    // rY[11]:
    this->mVariableNames.push_back("sustained_outward_K_current_s_sus_gate__s_sus");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9912);

    // rY[12]:
    this->mVariableNames.push_back("delayed_rectifier_K_currents_n_gate__n");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0048357);

    // rY[13]:
    this->mVariableNames.push_back("delayed_rectifier_K_currents_pa_gate__p_a");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0001);

    // rY[14]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.5547);

    // rY[15]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(129.435);

    // rY[16]:
    this->mVariableNames.push_back("intracellular_ion_concentrations__Ca_d");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(7.2495e-05);

    // rY[17]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_C");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0275);

    // rY[18]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TC");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0133);

    // rY[19]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TMgC");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.1961);

    // rY[20]:
    this->mVariableNames.push_back("intracellular_Ca_buffering__O_TMgMg");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.7094);

    // rY[21]:
    this->mVariableNames.push_back("cleft_space_ion_concentrations__Na_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(130.011);

    // rY[22]:
    this->mVariableNames.push_back("cleft_space_ion_concentrations__Ca_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(1.8147);

    // rY[23]:
    this->mVariableNames.push_back("cleft_space_ion_concentrations__K_c");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(5.3581);

    // rY[24]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__Ca_rel");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.6465);

    // rY[25]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__Ca_up");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.6646);

    // rY[26]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__O_Calse");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4369);

    // rY[27]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4284);

    // rY[28]:
    this->mVariableNames.push_back("Ca_handling_by_the_SR__F2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0028);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane__Cm");
    this->mParameterUnits.push_back("nanoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_capacitance");
    this->mDerivedQuantityUnits.push_back("uF");

    // Derived Quantity index [2]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellnygren_atrial_model_1998FromCellMLGRL1)
