#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: zhang_SAN_model_2000_all
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "zhang_SAN_model_2000_all.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"


    Cellzhang_SAN_model_2000_allFromCellMLCvode::Cellzhang_SAN_model_2000_allFromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                15,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellzhang_SAN_model_2000_allFromCellMLCvode>::Instance();
        Init();
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
    }

    Cellzhang_SAN_model_2000_allFromCellMLCvode::~Cellzhang_SAN_model_2000_allFromCellMLCvode()
    {
    }
    
    double Cellzhang_SAN_model_2000_allFromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__sodium_current_m_gate__m = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.092361701692
        double var_chaste_interface__sodium_current_h_gate__h1 = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.015905380261
        double var_chaste_interface__sodium_current_h_gate__h2 = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.01445216109
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.04804900895
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.48779845203
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.42074047435
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.038968420558
        double var_chaste_interface__four_AP_sensitive_currents_q_gate__q = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.29760539675
        double var_chaste_interface__four_AP_sensitive_currents_r_gate__r = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.064402950262
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.13034201158
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.46960956028
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.87993375273
        double var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.082293827208
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.03889291759
        
        const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
        const double var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable = 0.0057938; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable = 0.0082000000000000007; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Centre_Published = 0.0057999999999999996; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Periphery_0DCapable = 0.065886479999999997; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Periphery_1DCapable = 0.0659; // microS
        const double var_L_type_Ca_channel__g_Ca_L_Periphery_Published = 0.0659; // microS
        const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
        const double var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable = 0.0042780600000000002; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable = 0.0020999999999999999; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Centre_Published = 0.0043; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Periphery_0DCapable = 0.0138823; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Periphery_1DCapable = 0.00694; // microS
        const double var_T_type_Ca_channel__g_Ca_T_Periphery_Published = 0.013899999999999999; // microS
        const double var_calcium_background_current__g_b_Ca_Centre_0DCapable = 1.3236e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Centre_1DCapable = 1.323e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Centre_Published = 1.3200000000000001e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Periphery_0DCapable = 4.2951999999999998e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Periphery_1DCapable = 4.2899999999999999e-5; // microS
        const double var_calcium_background_current__g_b_Ca_Periphery_Published = 4.3000000000000002e-5; // microS
        const double var_four_AP_sensitive_currents__g_sus_Centre_0DCapable = 6.6455040000000003e-5; // microS
        const double var_four_AP_sensitive_currents__g_sus_Centre_1DCapable = 0.00026600000000000001; // microS
        const double var_four_AP_sensitive_currents__g_sus_Centre_Published = 6.6500000000000004e-5; // microS
        const double var_four_AP_sensitive_currents__g_sus_Periphery_0DCapable = 0.01138376; // microS
        const double var_four_AP_sensitive_currents__g_sus_Periphery_1DCapable = 0.0114; // microS
        const double var_four_AP_sensitive_currents__g_sus_Periphery_Published = 0.0114; // microS
        const double var_four_AP_sensitive_currents__g_to_Centre_0DCapable = 0.0049049999999999996; // microS
        const double var_four_AP_sensitive_currents__g_to_Centre_1DCapable = 0.0049049999999999996; // microS
        const double var_four_AP_sensitive_currents__g_to_Centre_Published = 0.0049100000000000003; // microS
        const double var_four_AP_sensitive_currents__g_to_Periphery_0DCapable = 0.036495; // microS
        const double var_four_AP_sensitive_currents__g_to_Periphery_1DCapable = 0.036499999999999998; // microS
        const double var_four_AP_sensitive_currents__g_to_Periphery_Published = 0.036490000000000002; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable = 0.0005465; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable = 0.000437; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Centre_Published = 0.00054799999999999998; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Periphery_0DCapable = 0.006875; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Periphery_1DCapable = 0.0054999999999999997; // microS
        const double var_hyperpolarisation_activated_current__g_f_K_Periphery_Published = 0.0068999999999999999; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable = 0.0005465; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable = 0.000437; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Centre_Published = 0.00054799999999999998; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_0DCapable = 0.006875; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_1DCapable = 0.0054999999999999997; // microS
        const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_Published = 0.0068999999999999999; // microS
        const double var_ionic_concentrations__Ca_i = 0.0001; // millimolar
        const double var_ionic_concentrations__Ca_o = 2.0; // millimolar
        const double var_ionic_concentrations__K_i = 140.0; // millimolar
        const double var_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
        const double var_ionic_concentrations__Na_i = 8.0; // millimolar
        const double var_ionic_concentrations__Na_o = 140.0; // millimolar
        const double var_membrane__F = 96845.0; // coulomb_per_mole
        const double var_membrane__FCellConstant = 1.0309347; // dimensionless
        const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_membrane__dCell = 0; // dimensionless
        const double var_membrane__FCell = ((var_membrane__Version == 0) ? (0.35666666666666669 * (-0.10000000000000001 + 3.0 * var_membrane__dCell) / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : ((var_membrane__Version == 1.0) ? (var_membrane__FCellConstant * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : (1.0343333333333333 * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(12.564102564102564 - 14.871794871794872 * var_membrane__dCell))))); // dimensionless
        const double var_L_type_Ca_channel__g_Ca_L = ((var_membrane__Version == 0) ? ((-var_L_type_Ca_channel__g_Ca_L_Centre_Published + var_L_type_Ca_channel__g_Ca_L_Periphery_Published) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable + var_L_type_Ca_channel__g_Ca_L_Periphery_0DCapable) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable) : ((-var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable + var_L_type_Ca_channel__g_Ca_L_Periphery_1DCapable) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable))); // microS
        const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.0060000000000000001 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
        const double var_T_type_Ca_channel__g_Ca_T = ((var_membrane__Version == 0) ? ((-var_T_type_Ca_channel__g_Ca_T_Centre_Published + var_T_type_Ca_channel__g_Ca_T_Periphery_Published) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable + var_T_type_Ca_channel__g_Ca_T_Periphery_0DCapable) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable) : ((-var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable + var_T_type_Ca_channel__g_Ca_T_Periphery_1DCapable) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable))); // microS
        const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
        const double var_calcium_background_current__g_b_Ca = ((var_membrane__Version == 0) ? ((-var_calcium_background_current__g_b_Ca_Centre_Published + var_calcium_background_current__g_b_Ca_Periphery_Published) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_calcium_background_current__g_b_Ca_Centre_0DCapable + var_calcium_background_current__g_b_Ca_Periphery_0DCapable) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_0DCapable) : ((-var_calcium_background_current__g_b_Ca_Centre_1DCapable + var_calcium_background_current__g_b_Ca_Periphery_1DCapable) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_1DCapable))); // microS
        const double var_four_AP_sensitive_currents__g_sus = ((var_membrane__Version == 0) ? ((-var_four_AP_sensitive_currents__g_sus_Centre_Published + var_four_AP_sensitive_currents__g_sus_Periphery_Published) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_four_AP_sensitive_currents__g_sus_Centre_0DCapable + var_four_AP_sensitive_currents__g_sus_Periphery_0DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_0DCapable) : ((-var_four_AP_sensitive_currents__g_sus_Centre_1DCapable + var_four_AP_sensitive_currents__g_sus_Periphery_1DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_1DCapable))); // microS
        const double var_four_AP_sensitive_currents__g_to = ((var_membrane__Version == 0) ? ((-var_four_AP_sensitive_currents__g_to_Centre_Published + var_four_AP_sensitive_currents__g_to_Periphery_Published) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_four_AP_sensitive_currents__g_to_Centre_0DCapable + var_four_AP_sensitive_currents__g_to_Periphery_0DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_0DCapable) : ((-var_four_AP_sensitive_currents__g_to_Centre_1DCapable + var_four_AP_sensitive_currents__g_to_Periphery_1DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_1DCapable))); // microS
        const double var_hyperpolarisation_activated_current__g_f_K = ((var_membrane__Version == 0) ? ((-var_hyperpolarisation_activated_current__g_f_K_Centre_Published + var_hyperpolarisation_activated_current__g_f_K_Periphery_Published) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable + var_hyperpolarisation_activated_current__g_f_K_Periphery_0DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable) : ((-var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable + var_hyperpolarisation_activated_current__g_f_K_Periphery_1DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable))); // microS
        const double var_hyperpolarisation_activated_current__g_f_Na = ((var_membrane__Version == 0) ? ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_Published + var_hyperpolarisation_activated_current__g_f_Na_Periphery_Published) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable + var_hyperpolarisation_activated_current__g_f_Na_Periphery_0DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable) : ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable + var_hyperpolarisation_activated_current__g_f_Na_Periphery_1DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable))); // microS
        const double var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable = 0.0041999999999999997; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Centre_Published = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Periphery_0DCapable = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Periphery_1DCapable = 0.033390000000000003; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max_Periphery_Published = 0; // nanoA
        const double var_persistent_calcium_current__i_Ca_p_max = ((var_membrane__Version == 0) ? ((-var_persistent_calcium_current__i_Ca_p_max_Centre_Published + var_persistent_calcium_current__i_Ca_p_max_Periphery_Published) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable + var_persistent_calcium_current__i_Ca_p_max_Periphery_0DCapable) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable) : ((-var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable + var_persistent_calcium_current__i_Ca_p_max_Periphery_1DCapable) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable))); // nanoA
        const double var_persistent_calcium_current__i_Ca_p = var_ionic_concentrations__Ca_i * var_persistent_calcium_current__i_Ca_p_max / (0.00040000000000000002 + var_ionic_concentrations__Ca_i); // nanoA
        const double var_potassium_background_current__g_b_K_Centre_0DCapable = 2.5236359999999998e-5; // microS
        const double var_potassium_background_current__g_b_K_Centre_1DCapable = 2.5199999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K_Centre_Published = 2.5199999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K_Periphery_0DCapable = 8.1891999999999995e-5; // microS
        const double var_potassium_background_current__g_b_K_Periphery_1DCapable = 8.1899999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K_Periphery_Published = 8.1899999999999999e-5; // microS
        const double var_potassium_background_current__g_b_K = ((var_membrane__Version == 0) ? ((-var_potassium_background_current__g_b_K_Centre_Published + var_potassium_background_current__g_b_K_Periphery_Published) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_potassium_background_current__g_b_K_Centre_0DCapable + var_potassium_background_current__g_b_K_Periphery_0DCapable) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_0DCapable) : ((-var_potassium_background_current__g_b_K_Centre_1DCapable + var_potassium_background_current__g_b_K_Periphery_1DCapable) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_1DCapable))); // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable = 0.00079704000000000005; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable = 0.00073800000000000005; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published = 0.00079699999999999997; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_0DCapable = 0.016; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_1DCapable = 0.020799999999999999; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_Published = 0.016; // microS
        const double var_rapid_delayed_rectifying_potassium_current__g_K_r = ((var_membrane__Version == 0) ? ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_Published) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_0DCapable) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable) : ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_1DCapable) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable))); // microS
        const double var_rapid_delayed_rectifying_potassium_current__P_a = 0.40000000000000002 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as + 0.59999999999999998 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af; // dimensionless
        const double var_reversal_and_equilibrium_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Ca_o / var_ionic_concentrations__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_and_equilibrium_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_b_Ca; // nanoA
        const double var_reversal_and_equilibrium_potentials__E_K = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__K_o / var_ionic_concentrations__K_i) / var_membrane__F; // millivolt
        const double var_four_AP_sensitive_currents__i_sus = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_four_AP_sensitive_currents__g_sus * var_chaste_interface__four_AP_sensitive_currents_r_gate__r; // nanoA
        const double var_four_AP_sensitive_currents__i_to = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_four_AP_sensitive_currents__g_to * var_chaste_interface__four_AP_sensitive_currents_q_gate__q * var_chaste_interface__four_AP_sensitive_currents_r_gate__r; // nanoA
        const double var_hyperpolarisation_activated_current__i_f_K = ((var_membrane__Version != 2.0) ? ((-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) : ((102.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y)); // nanoA
        const double var_potassium_background_current__i_b_K = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_background_current__g_b_K; // nanoA
        const double var_rapid_delayed_rectifying_potassium_current__i_K_r = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_rapid_delayed_rectifying_potassium_current__P_a * var_rapid_delayed_rectifying_potassium_current__g_K_r * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
        const double var_reversal_and_equilibrium_potentials__E_K_s = ((var_membrane__Version == 0) ? (var_membrane__R * var_membrane__T * log((var_ionic_concentrations__K_o + 0.12 * var_ionic_concentrations__Na_o) / (var_ionic_concentrations__K_i + 0.12 * var_ionic_concentrations__Na_i)) / var_membrane__F) : (var_membrane__R * var_membrane__T * log((var_ionic_concentrations__K_o + 0.029999999999999999 * var_ionic_concentrations__Na_o) / (var_ionic_concentrations__K_i + 0.029999999999999999 * var_ionic_concentrations__Na_i)) / var_membrane__F)); // millivolt
        const double var_reversal_and_equilibrium_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Na_o / var_ionic_concentrations__Na_i) / var_membrane__F; // millivolt
        const double var_hyperpolarisation_activated_current__i_f_Na = ((var_membrane__Version != 2.0) ? ((-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) : ((-77.599999999999994 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y)); // nanoA
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable = 0.00034450000000000003; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable = 0.00034499999999999998; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published = 0.00051800000000000001; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_0DCapable = 0.0104; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_1DCapable = 0.0104; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_Published = 0.0104; // microS
        const double var_slow_delayed_rectifying_potassium_current__g_K_s = ((var_membrane__Version == 0) ? ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_Published) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_0DCapable) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable) : ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_1DCapable) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable))); // microS
        const double var_slow_delayed_rectifying_potassium_current__i_K_s = pow(var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs, 2) * (-var_reversal_and_equilibrium_potentials__E_K_s + var_chaste_interface__membrane__V) * var_slow_delayed_rectifying_potassium_current__g_K_s; // nanoA
        const double var_sodium_background_current__g_b_Na_Centre_0DCapable = 5.8181799999999999e-5; // microS
        const double var_sodium_background_current__g_b_Na_Centre_1DCapable = 5.8e-5; // microS
        const double var_sodium_background_current__g_b_Na_Centre_Published = 5.8e-5; // microS
        const double var_sodium_background_current__g_b_Na_Periphery_0DCapable = 0.00018880000000000001; // microS
        const double var_sodium_background_current__g_b_Na_Periphery_1DCapable = 0.00018900000000000001; // microS
        const double var_sodium_background_current__g_b_Na_Periphery_Published = 0.00018900000000000001; // microS
        const double var_sodium_background_current__g_b_Na = ((var_membrane__Version == 0) ? ((-var_sodium_background_current__g_b_Na_Centre_Published + var_sodium_background_current__g_b_Na_Periphery_Published) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_background_current__g_b_Na_Centre_0DCapable + var_sodium_background_current__g_b_Na_Periphery_0DCapable) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_0DCapable) : ((-var_sodium_background_current__g_b_Na_Centre_1DCapable + var_sodium_background_current__g_b_Na_Periphery_1DCapable) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_1DCapable))); // microS
        const double var_sodium_background_current__i_b_Na = (-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_b_Na; // nanoA
        const double var_sodium_calcium_exchanger__d_NaCa = 0.0001; // dimensionless
        const double var_sodium_calcium_exchanger__gamma_NaCa = 0.5; // dimensionless
        const double var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable = 2.7228999999999998e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable = 2.7999999999999999e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Centre_Published = 2.7e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Periphery_0DCapable = 8.8358400000000004e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Periphery_1DCapable = 8.8000000000000004e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa_Periphery_Published = 8.8000000000000004e-6; // nanoA
        const double var_sodium_calcium_exchanger__k_NaCa = ((var_membrane__Version == 0) ? ((-var_sodium_calcium_exchanger__k_NaCa_Centre_Published + var_sodium_calcium_exchanger__k_NaCa_Periphery_Published) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable + var_sodium_calcium_exchanger__k_NaCa_Periphery_0DCapable) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable) : ((-var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable + var_sodium_calcium_exchanger__k_NaCa_Periphery_1DCapable) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable))); // nanoA
        const double var_sodium_calcium_exchanger__i_NaCa = ((var_membrane__Version == 0) ? ((pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma_NaCa) - pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i * exp(0.037400000000000003 * (-1.0 + var_sodium_calcium_exchanger__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_sodium_calcium_exchanger__k_NaCa / (1.0 + (pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o + pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i) * var_sodium_calcium_exchanger__d_NaCa)) : ((pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma_NaCa) - pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_exchanger__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_sodium_calcium_exchanger__k_NaCa / (1.0 + (pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o + pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i) * var_sodium_calcium_exchanger__d_NaCa))); // nanoA
        const double var_sodium_current__g_Na_Centre_0DCapable = 0; // microlitre_per_second
        const double var_sodium_current__g_Na_Centre_1DCapable = 0; // microlitre_per_second
        const double var_sodium_current__g_Na_Centre_Published = 0; // microlitre_per_second
        const double var_sodium_current__g_Na_Periphery_0DCapable = 1.204e-6; // microlitre_per_second
        const double var_sodium_current__g_Na_Periphery_1DCapable = 3.7e-7; // microlitre_per_second
        const double var_sodium_current__g_Na_Periphery_Published = 1.1999999999999999e-6; // microlitre_per_second
        const double var_sodium_current__g_Na = ((var_membrane__Version == 0) ? ((-var_sodium_current__g_Na_Centre_Published + var_sodium_current__g_Na_Periphery_Published) * var_membrane__FCell + var_sodium_current__g_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_current__g_Na_Centre_0DCapable + var_sodium_current__g_Na_Periphery_0DCapable) * var_membrane__FCell + var_sodium_current__g_Na_Centre_0DCapable) : ((-var_sodium_current__g_Na_Centre_1DCapable + var_sodium_current__g_Na_Periphery_1DCapable) * var_membrane__FCell + var_sodium_current__g_Na_Centre_1DCapable))); // microlitre_per_second
        const double var_sodium_current_h_gate__F_Na = ((var_membrane__Version == 0) ? (0.086900000000000005 + 0.095200000000000007 * exp(-2.1671999999999998 - 0.063 * var_chaste_interface__membrane__V) / (1.0 + 1.6599999999999999 * exp(-14.332500000000001 - 0.22500000000000001 * var_chaste_interface__membrane__V))) : (0.086929999999999993 + 0.095180000000000001 * exp(-2.1692640000000001 - 0.063060000000000005 * var_chaste_interface__membrane__V) / (1.0 + 1.6619999999999999 * exp(-14.33887 - 0.22509999999999999 * var_chaste_interface__membrane__V)))); // dimensionless
        const double var_sodium_current_h_gate__h = (1.0 - var_sodium_current_h_gate__F_Na) * var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__F_Na * var_chaste_interface__sodium_current_h_gate__h2; // dimensionless
        const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_ionic_concentrations__Na_o * var_chaste_interface__membrane__V * var_sodium_current__g_Na * var_sodium_current_h_gate__h / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
        const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
        const double var_sodium_potassium_pump__K_m_Na = 5.6399999999999997; // millimolar
        const double var_sodium_potassium_pump__i_p_max_Centre_0DCapable = 0.047825449999999999; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Centre_1DCapable = 0.047800000000000002; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Centre_Published = 0.047800000000000002; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Periphery_0DCapable = 0.15519359999999999; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Periphery_1DCapable = 0.16; // nanoA
        const double var_sodium_potassium_pump__i_p_max_Periphery_Published = 0.16; // nanoA
        const double var_sodium_potassium_pump__i_p_max = ((var_membrane__Version == 0) ? ((-var_sodium_potassium_pump__i_p_max_Centre_Published + var_sodium_potassium_pump__i_p_max_Periphery_Published) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_potassium_pump__i_p_max_Centre_0DCapable + var_sodium_potassium_pump__i_p_max_Periphery_0DCapable) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_0DCapable) : ((-var_sodium_potassium_pump__i_p_max_Centre_1DCapable + var_sodium_potassium_pump__i_p_max_Periphery_1DCapable) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_1DCapable))); // nanoA
        const double var_sodium_potassium_pump__i_p = 1.6000000000000001 * pow(var_ionic_concentrations__K_o, 2) * pow(var_ionic_concentrations__Na_i, 3) * var_sodium_potassium_pump__i_p_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_ionic_concentrations__K_o + var_sodium_potassium_pump__K_m_K), 2) * pow((var_ionic_concentrations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
        const double var_chaste_interface__i_ionic = 0.001 * (var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_b_Ca + var_four_AP_sensitive_currents__i_sus + var_four_AP_sensitive_currents__i_to + var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na + var_persistent_calcium_current__i_Ca_p + var_potassium_background_current__i_b_K + var_rapid_delayed_rectifying_potassium_current__i_K_r + var_slow_delayed_rectifying_potassium_current__i_K_s + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_p) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellzhang_SAN_model_2000_allFromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time_converted, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__sodium_current_m_gate__m = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.092361701692
        double var_chaste_interface__sodium_current_h_gate__h1 = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.015905380261
        double var_chaste_interface__sodium_current_h_gate__h2 = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.01445216109
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.04804900895
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.48779845203
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.42074047435
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.038968420558
        double var_chaste_interface__four_AP_sensitive_currents_q_gate__q = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.29760539675
        double var_chaste_interface__four_AP_sensitive_currents_r_gate__r = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.064402950262
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.13034201158
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.46960956028
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.87993375273
        double var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.082293827208
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.03889291759

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_membrane__FCellConstant = 1.0309347; // dimensionless
        const double var_L_type_Ca_channel_f_gate__f_L_infinity = 1 / (1.0 + exp(9.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_d_gate__alpha_d_T = 1068.0 * exp(0.87666666666666671 + 0.033333333333333333 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_d_gate__beta_d_T = 1068.0 * exp(-0.87666666666666671 - 0.033333333333333333 * var_chaste_interface__membrane__V); // per_second
        const double var_T_type_Ca_channel_d_gate__d_T_infinity = 1 / (1.0 + exp(-5.4411764705882355 - 0.14705882352941177 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_d_gate__tau_d_T = 1 / (var_T_type_Ca_channel_d_gate__alpha_d_T + var_T_type_Ca_channel_d_gate__beta_d_T); // second
        const double var_T_type_Ca_channel_d_gate__d_T_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_d_gate__d_T + var_T_type_Ca_channel_d_gate__d_T_infinity) / var_T_type_Ca_channel_d_gate__tau_d_T; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T = 0.001 * var_T_type_Ca_channel_d_gate__d_T_orig_deriv; // 1 / millisecond
        const double var_T_type_Ca_channel_f_gate__f_T_infinity = 1 / (1.0 + exp(7.8888888888888893 + 0.1111111111111111 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_four_AP_sensitive_currents_q_gate__q_infinity = 1 / (1.0 + exp(4.5320610687022898 + 0.076335877862595422 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_four_AP_sensitive_currents_r_gate__r_infinity = 1 / (1.0 + exp(0.5548223350253807 - 0.050761421319796954 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_hyperpolarisation_activated_current_y_gate__beta_y = exp(3.5355294117647058 + 0.047058823529411764 * var_chaste_interface__membrane__V); // per_second
        const double var_membrane__Version = 1.0; // dimensionless
        const double var_L_type_Ca_channel_d_gate__alpha_d_L = ((var_membrane__Version == 0) ? (-84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V)) - 28.379999999999999 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V))) : ((var_membrane__Version == 1.0) ? (-28.390000000000001 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V)) - 84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V))) : (-84.900000000000006 * var_chaste_interface__membrane__V / (-1.0 + exp(-0.20799999999999999 * var_chaste_interface__membrane__V)) - 28.399999999999999 * (35.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V))))); // per_second
        const double var_L_type_Ca_channel_d_gate__beta_d_L = ((var_membrane__Version == 1.0) ? (11.43 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V))) : (11.42 * (-5.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V)))); // per_second
        const double var_L_type_Ca_channel_d_gate__tau_d_L = 2.0 / (var_L_type_Ca_channel_d_gate__alpha_d_L + var_L_type_Ca_channel_d_gate__beta_d_L); // second
        const double var_L_type_Ca_channel_f_gate__alpha_f_L = ((var_membrane__Version == 1.0) ? (3.75 * (28.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(7.0 + 0.25 * var_chaste_interface__membrane__V))) : (3.1200000000000001 * (28.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(7.0 + 0.25 * var_chaste_interface__membrane__V)))); // per_second
        const double var_L_type_Ca_channel_f_gate__beta_f_L = ((var_membrane__Version == 1.0) ? (30.0 / (1.0 + exp(-7.0 - 0.25 * var_chaste_interface__membrane__V))) : (25.0 / (1.0 + exp(-7.0 - 0.25 * var_chaste_interface__membrane__V)))); // per_second
        const double var_T_type_Ca_channel_f_gate__beta_f_T = ((var_membrane__Version == 1.0) ? (15.0 * exp(4.6163849154746419 + 0.065019505851755519 * var_chaste_interface__membrane__V)) : (15.0 * exp(4.6618985695708712 + 0.065019505851755519 * var_chaste_interface__membrane__V))); // per_second
        const double var_four_AP_sensitive_currents_r_gate__tau_r = ((var_membrane__Version == 0) ? (0.00298 + 0.01559 / (1.0369999999999999 * exp(2.7548999999999997 + 0.089999999999999997 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8607999999999998 - 0.12 * var_chaste_interface__membrane__V))) : ((var_membrane__Version == 1.0) ? (0.0029775000000000001 + 0.019595000000000001 / (1.0369999999999999 * exp(2.7585732000000003 + 0.090120000000000006 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8369599999999999 - 0.11899999999999999 * var_chaste_interface__membrane__V))) : (0.00298 + 0.01959 / (1.0369999999999999 * exp(2.7585732000000003 + 0.090120000000000006 * var_chaste_interface__membrane__V) + 0.36899999999999999 * exp(-2.8369599999999999 - 0.11899999999999999 * var_chaste_interface__membrane__V))))); // second
        const double var_four_AP_sensitive_currents_r_gate__r_orig_deriv = (-var_chaste_interface__four_AP_sensitive_currents_r_gate__r + var_four_AP_sensitive_currents_r_gate__r_infinity) / var_four_AP_sensitive_currents_r_gate__tau_r; // 1 / second
        const double d_dt_chaste_interface_var_four_AP_sensitive_currents_r_gate__r = 0.001 * var_four_AP_sensitive_currents_r_gate__r_orig_deriv; // 1 / millisecond
        const double var_hyperpolarisation_activated_current_y_gate__alpha_y = ((var_membrane__Version == 0) ? (exp(-2.9643125469571747 - 0.037565740045078885 * var_chaste_interface__membrane__V)) : (exp(-2.9631993991738641 - 0.037551633496057078 * var_chaste_interface__membrane__V))); // per_second
        const double var_hyperpolarisation_activated_current_y_gate__y_orig_deriv = (1.0 - var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) * var_hyperpolarisation_activated_current_y_gate__alpha_y - var_hyperpolarisation_activated_current_y_gate__beta_y * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y; // 1 / second
        const double d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y = 0.001 * var_hyperpolarisation_activated_current_y_gate__y_orig_deriv; // 1 / millisecond
        const double var_membrane__dCell = 0; // dimensionless
        const double var_membrane__FCell = ((var_membrane__Version == 0) ? (0.35666666666666669 * (-0.10000000000000001 + 3.0 * var_membrane__dCell) / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : ((var_membrane__Version == 1.0) ? (var_membrane__FCellConstant * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(6.9491525423728815 - 10.16949152542373 * var_membrane__dCell))) : (1.0343333333333333 * var_membrane__dCell / (1.0 + 0.77449999999999997 * exp(12.564102564102564 - 14.871794871794872 * var_membrane__dCell))))); // dimensionless
        const double var_L_type_Ca_channel_d_gate__d_L_infinity = ((var_membrane__Version == 0) ? (1 / (1.0 + exp(-3.8500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V))) : ((var_membrane__Version == 1.0) ? (1 / (1.0 + exp(-3.7166666666666668 - 0.13333333333333333 * var_membrane__FCell - 0.16666666666666666 * var_chaste_interface__membrane__V))) : (1 / (1.0 + exp(-3.6999999999999997 - 0.16666666666666666 * var_chaste_interface__membrane__V))))); // dimensionless
        const double var_L_type_Ca_channel_d_gate__d_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_d_gate__d_L + var_L_type_Ca_channel_d_gate__d_L_infinity) / var_L_type_Ca_channel_d_gate__tau_d_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L = 0.001 * var_L_type_Ca_channel_d_gate__d_L_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_gate__tau_f_L = ((var_membrane__Version == 1.0) ? ((1.2 - 0.20000000000000001 * var_membrane__FCell) / (var_L_type_Ca_channel_f_gate__alpha_f_L + var_L_type_Ca_channel_f_gate__beta_f_L)) : (1 / (var_L_type_Ca_channel_f_gate__alpha_f_L + var_L_type_Ca_channel_f_gate__beta_f_L))); // second
        const double var_L_type_Ca_channel_f_gate__f_L_orig_deriv = (-var_chaste_interface__L_type_Ca_channel_f_gate__f_L + var_L_type_Ca_channel_f_gate__f_L_infinity) / var_L_type_Ca_channel_f_gate__tau_f_L; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L = 0.001 * var_L_type_Ca_channel_f_gate__f_L_orig_deriv; // 1 / millisecond
        const double var_T_type_Ca_channel_f_gate__alpha_f_T = ((var_membrane__Version == 1.0) ? (15.300000000000001 * exp(-0.85234093637454988 - 0.0084033613445378148 * var_membrane__FCell - 0.012004801920768308 * var_chaste_interface__membrane__V)) : (15.300000000000001 * exp(-0.86074429771908767 - 0.012004801920768308 * var_chaste_interface__membrane__V))); // per_second
        const double var_T_type_Ca_channel_f_gate__tau_f_T = 1 / (var_T_type_Ca_channel_f_gate__alpha_f_T + var_T_type_Ca_channel_f_gate__beta_f_T); // second
        const double var_T_type_Ca_channel_f_gate__f_T_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_f_gate__f_T + var_T_type_Ca_channel_f_gate__f_T_infinity) / var_T_type_Ca_channel_f_gate__tau_f_T; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T = 0.001 * var_T_type_Ca_channel_f_gate__f_T_orig_deriv; // 1 / millisecond
        const double var_four_AP_sensitive_currents_q_gate__tau_q = ((var_membrane__Version == 0) ? (0.0101 + 2.4000000000000001e-5 * exp(5.093 + 0.10000000000000001 * var_chaste_interface__membrane__V) + 0.11433333333333336 / exp(-3.9199999999999999 - 0.080000000000000002 * var_chaste_interface__membrane__V)) : ((var_membrane__Version == 1.0) ? (0.010103333333333334 + 0.065166666666666664 / (0.56859999999999999 * exp(-3.1827900000000002 - 0.081610000000000002 * var_chaste_interface__membrane__V - 0.81610000000000005 * var_membrane__FCell) + 0.71740000000000004 * exp((0.27189999999999998 - 0.1719 * var_membrane__FCell) * (40.93 + 10.0 * var_membrane__FCell + var_chaste_interface__membrane__V)))) : (0.0101 + 0.065170000000000006 / (0.56859999999999999 * exp(-3.1827900000000002 - 0.081610000000000002 * var_chaste_interface__membrane__V) + 0.71740000000000004 * exp(11.128867 + 0.27189999999999998 * var_chaste_interface__membrane__V))))); // second
        const double var_four_AP_sensitive_currents_q_gate__q_orig_deriv = (-var_chaste_interface__four_AP_sensitive_currents_q_gate__q + var_four_AP_sensitive_currents_q_gate__q_infinity) / var_four_AP_sensitive_currents_q_gate__tau_q; // 1 / second
        const double d_dt_chaste_interface_var_four_AP_sensitive_currents_q_gate__q = 0.001 * var_four_AP_sensitive_currents_q_gate__q_orig_deriv; // 1 / millisecond
        const double var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_infinity = ((var_membrane__Version != 2.0) ? (1 / (1.0 + exp(-1.3396226415094339 - 0.094339622641509441 * var_chaste_interface__membrane__V))) : (1 / (1.0 + exp(-1.2452830188679245 - 0.094339622641509441 * var_chaste_interface__membrane__V)))); // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_af_gate__tau_P_af = ((var_membrane__Version != 2.0) ? (1 / (0.95999999999999996 * exp(0.40000000000000002 - 0.044444444444444446 * var_chaste_interface__membrane__V) + 37.200000000000003 * exp(-0.56603773584905659 + 0.062893081761006289 * var_chaste_interface__membrane__V))) : (1 / (0.95999999999999996 * exp(0.44444444444444442 - 0.044444444444444446 * var_chaste_interface__membrane__V) + 37.200000000000003 * exp(-0.62893081761006286 + 0.062893081761006289 * var_chaste_interface__membrane__V)))); // second
        const double var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_orig_deriv = (-var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af + var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_infinity) / var_rapid_delayed_rectifying_potassium_current_P_af_gate__tau_P_af; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af = 0.001 * var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_orig_deriv; // 1 / millisecond
        const double var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as_infinity = var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af_infinity; // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_as_gate__tau_P_as = ((var_membrane__Version != 2.0) ? (1 / (4.2000000000000002 * exp(-0.52941176470588236 + 0.058823529411764705 * var_chaste_interface__membrane__V) + 0.14999999999999999 * exp(0.41666666666666663 - 0.046296296296296294 * var_chaste_interface__membrane__V))) : (1 / (4.2000000000000002 * exp(-0.58823529411764708 + 0.058823529411764705 * var_chaste_interface__membrane__V) + 0.14999999999999999 * exp(0.46296296296296291 - 0.046296296296296294 * var_chaste_interface__membrane__V)))); // second
        const double var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as_orig_deriv = (-var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as + var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as_infinity) / var_rapid_delayed_rectifying_potassium_current_P_as_gate__tau_P_as; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as = 0.001 * var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as_orig_deriv; // 1 / millisecond
        const double var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i_infinity = 1 / (1.0 + exp(1.8415841584158419 + 0.099009900990099015 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_delayed_rectifying_potassium_current_P_i_gate__tau_P_i = (((var_membrane__Version == 0) || (var_membrane__Version == 1.0)) ? (0.002) : (0.0060000000000000001)); // second
        const double var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i_orig_deriv = (-var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i + var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i_infinity) / var_rapid_delayed_rectifying_potassium_current_P_i_gate__tau_P_i; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i = 0.001 * var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i_orig_deriv; // 1 / millisecond
        const double var_slow_delayed_rectifying_potassium_current_xs_gate__alpha_xs = 14.0 / (1.0 + exp(4.4444444444444446 - 0.1111111111111111 * var_chaste_interface__membrane__V)); // per_second
        const double var_slow_delayed_rectifying_potassium_current_xs_gate__beta_xs = exp(-0.022222222222222223 * var_chaste_interface__membrane__V); // per_second
        const double var_slow_delayed_rectifying_potassium_current_xs_gate__xs_orig_deriv = (1.0 - var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs) * var_slow_delayed_rectifying_potassium_current_xs_gate__alpha_xs - var_slow_delayed_rectifying_potassium_current_xs_gate__beta_xs * var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs; // 1 / second
        const double d_dt_chaste_interface_var_slow_delayed_rectifying_potassium_current_xs_gate__xs = 0.001 * var_slow_delayed_rectifying_potassium_current_xs_gate__xs_orig_deriv; // 1 / millisecond
        const double var_sodium_current_h_gate__h1_infinity = 1 / (1.0 + exp(10.328124999999998 + 0.15625 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_sodium_current_h_gate__h2_infinity = var_sodium_current_h_gate__h1_infinity; // dimensionless
        const double var_sodium_current_h_gate__tau_h1 = 0.00059770000000000005 + 3.7170000000000002e-6 * exp(-4.8164649999999991 - 0.28149999999999997 * var_chaste_interface__membrane__V) / (1.0 + 0.0037320000000000001 * exp(-12.936576000000001 - 0.34260000000000002 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h_gate__h1_orig_deriv = (-var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__h1_infinity) / var_sodium_current_h_gate__tau_h1; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h1 = 0.001 * var_sodium_current_h_gate__h1_orig_deriv; // 1 / millisecond
        const double var_sodium_current_h_gate__tau_h2 = 0.0035560000000000001 + 3.1860000000000002e-8 * exp(-11.69172 - 0.62190000000000001 * var_chaste_interface__membrane__V) / (1.0 + 7.1890000000000005e-5 * exp(-22.768981 - 0.66830000000000001 * var_chaste_interface__membrane__V)); // second
        const double var_sodium_current_h_gate__h2_orig_deriv = (-var_chaste_interface__sodium_current_h_gate__h2 + var_sodium_current_h_gate__h2_infinity) / var_sodium_current_h_gate__tau_h2; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_h_gate__h2 = 0.001 * var_sodium_current_h_gate__h2_orig_deriv; // 1 / millisecond
        const double var_sodium_current_m_gate__m_infinity = ((var_membrane__Version == 0) ? (pow(1 / (1.0 + exp(-0.18315018315018314 * var_chaste_interface__membrane__V)), 0.33333333333333331)) : (pow(1 / (1.0 + exp(-5.5531135531135529 - 0.18315018315018314 * var_chaste_interface__membrane__V)), 0.33333333333333331))); // dimensionless
        const double var_sodium_current_m_gate__tau_m = ((var_membrane__Version == 0) ? (4.0000000000000003e-5 + 0.00062469999999999995 / (0.627 * exp(5.330820000000001 + 0.082000000000000003 * var_chaste_interface__membrane__V) + 0.83199999999999996 * exp(-18.994500000000002 - 0.33500000000000002 * var_chaste_interface__membrane__V))) : (4.5689999999999998e-5 + 0.00062469999999999995 / (0.62739999999999996 * exp(5.3505781299999997 + 0.082299999999999998 * var_chaste_interface__membrane__V) + 0.83221659999999997 * exp(-19.034003092000003 - 0.33566000000000001 * var_chaste_interface__membrane__V)))); // second
        const double var_sodium_current_m_gate__m_orig_deriv = (-var_chaste_interface__sodium_current_m_gate__m + var_sodium_current_m_gate__m_infinity) / var_sodium_current_m_gate__tau_m; // 1 / second
        const double d_dt_chaste_interface_var_sodium_current_m_gate__m = 0.001 * var_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_L_type_Ca_channel__E_Ca_L = 46.399999999999999; // millivolt
            const double var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable = 0.0057938; // microS
            const double var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable = 0.0082000000000000007; // microS
            const double var_L_type_Ca_channel__g_Ca_L_Centre_Published = 0.0057999999999999996; // microS
            const double var_L_type_Ca_channel__g_Ca_L_Periphery_0DCapable = 0.065886479999999997; // microS
            const double var_L_type_Ca_channel__g_Ca_L_Periphery_1DCapable = 0.0659; // microS
            const double var_L_type_Ca_channel__g_Ca_L_Periphery_Published = 0.0659; // microS
            const double var_T_type_Ca_channel__E_Ca_T = 45.0; // millivolt
            const double var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable = 0.0042780600000000002; // microS
            const double var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable = 0.0020999999999999999; // microS
            const double var_T_type_Ca_channel__g_Ca_T_Centre_Published = 0.0043; // microS
            const double var_T_type_Ca_channel__g_Ca_T_Periphery_0DCapable = 0.0138823; // microS
            const double var_T_type_Ca_channel__g_Ca_T_Periphery_1DCapable = 0.00694; // microS
            const double var_T_type_Ca_channel__g_Ca_T_Periphery_Published = 0.013899999999999999; // microS
            const double var_calcium_background_current__g_b_Ca_Centre_0DCapable = 1.3236e-5; // microS
            const double var_calcium_background_current__g_b_Ca_Centre_1DCapable = 1.323e-5; // microS
            const double var_calcium_background_current__g_b_Ca_Centre_Published = 1.3200000000000001e-5; // microS
            const double var_calcium_background_current__g_b_Ca_Periphery_0DCapable = 4.2951999999999998e-5; // microS
            const double var_calcium_background_current__g_b_Ca_Periphery_1DCapable = 4.2899999999999999e-5; // microS
            const double var_calcium_background_current__g_b_Ca_Periphery_Published = 4.3000000000000002e-5; // microS
            const double var_four_AP_sensitive_currents__g_sus_Centre_0DCapable = 6.6455040000000003e-5; // microS
            const double var_four_AP_sensitive_currents__g_sus_Centre_1DCapable = 0.00026600000000000001; // microS
            const double var_four_AP_sensitive_currents__g_sus_Centre_Published = 6.6500000000000004e-5; // microS
            const double var_four_AP_sensitive_currents__g_sus_Periphery_0DCapable = 0.01138376; // microS
            const double var_four_AP_sensitive_currents__g_sus_Periphery_1DCapable = 0.0114; // microS
            const double var_four_AP_sensitive_currents__g_sus_Periphery_Published = 0.0114; // microS
            const double var_four_AP_sensitive_currents__g_to_Centre_0DCapable = 0.0049049999999999996; // microS
            const double var_four_AP_sensitive_currents__g_to_Centre_1DCapable = 0.0049049999999999996; // microS
            const double var_four_AP_sensitive_currents__g_to_Centre_Published = 0.0049100000000000003; // microS
            const double var_four_AP_sensitive_currents__g_to_Periphery_0DCapable = 0.036495; // microS
            const double var_four_AP_sensitive_currents__g_to_Periphery_1DCapable = 0.036499999999999998; // microS
            const double var_four_AP_sensitive_currents__g_to_Periphery_Published = 0.036490000000000002; // microS
            const double var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable = 0.0005465; // microS
            const double var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable = 0.000437; // microS
            const double var_hyperpolarisation_activated_current__g_f_K_Centre_Published = 0.00054799999999999998; // microS
            const double var_hyperpolarisation_activated_current__g_f_K_Periphery_0DCapable = 0.006875; // microS
            const double var_hyperpolarisation_activated_current__g_f_K_Periphery_1DCapable = 0.0054999999999999997; // microS
            const double var_hyperpolarisation_activated_current__g_f_K_Periphery_Published = 0.0068999999999999999; // microS
            const double var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable = 0.0005465; // microS
            const double var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable = 0.000437; // microS
            const double var_hyperpolarisation_activated_current__g_f_Na_Centre_Published = 0.00054799999999999998; // microS
            const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_0DCapable = 0.006875; // microS
            const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_1DCapable = 0.0054999999999999997; // microS
            const double var_hyperpolarisation_activated_current__g_f_Na_Periphery_Published = 0.0068999999999999999; // microS
            const double var_ionic_concentrations__Ca_i = 0.0001; // millimolar
            const double var_ionic_concentrations__Ca_o = 2.0; // millimolar
            const double var_ionic_concentrations__K_i = 140.0; // millimolar
            const double var_ionic_concentrations__K_o = 5.4000000000000004; // millimolar
            const double var_ionic_concentrations__Na_i = 8.0; // millimolar
            const double var_ionic_concentrations__Na_o = 140.0; // millimolar
            const double var_membrane__CmCentre = 2.0000000000000002e-5; // microF
            const double var_membrane__CmPeriphery = 6.4999999999999994e-5; // microF
            const double var_membrane__F = 96845.0; // coulomb_per_mole
            const double var_membrane__R = 8314.0; // millijoule_per_mole_kelvin
            const double var_membrane__T = 310.0; // kelvin
            const double var_L_type_Ca_channel__g_Ca_L = ((var_membrane__Version == 0) ? ((-var_L_type_Ca_channel__g_Ca_L_Centre_Published + var_L_type_Ca_channel__g_Ca_L_Periphery_Published) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable + var_L_type_Ca_channel__g_Ca_L_Periphery_0DCapable) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_0DCapable) : ((-var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable + var_L_type_Ca_channel__g_Ca_L_Periphery_1DCapable) * var_membrane__FCell + var_L_type_Ca_channel__g_Ca_L_Centre_1DCapable))); // microS
            const double var_L_type_Ca_channel__i_Ca_L = (-var_L_type_Ca_channel__E_Ca_L + var_chaste_interface__membrane__V) * (0.0060000000000000001 / (1.0 + exp(-2.3500000000000001 - 0.16666666666666666 * var_chaste_interface__membrane__V)) + var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * var_L_type_Ca_channel__g_Ca_L; // nanoA
            const double var_T_type_Ca_channel__g_Ca_T = ((var_membrane__Version == 0) ? ((-var_T_type_Ca_channel__g_Ca_T_Centre_Published + var_T_type_Ca_channel__g_Ca_T_Periphery_Published) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable + var_T_type_Ca_channel__g_Ca_T_Periphery_0DCapable) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_0DCapable) : ((-var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable + var_T_type_Ca_channel__g_Ca_T_Periphery_1DCapable) * var_membrane__FCell + var_T_type_Ca_channel__g_Ca_T_Centre_1DCapable))); // microS
            const double var_T_type_Ca_channel__i_Ca_T = (-var_T_type_Ca_channel__E_Ca_T + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_Ca_T * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T; // nanoA
            const double var_calcium_background_current__g_b_Ca = ((var_membrane__Version == 0) ? ((-var_calcium_background_current__g_b_Ca_Centre_Published + var_calcium_background_current__g_b_Ca_Periphery_Published) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_calcium_background_current__g_b_Ca_Centre_0DCapable + var_calcium_background_current__g_b_Ca_Periphery_0DCapable) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_0DCapable) : ((-var_calcium_background_current__g_b_Ca_Centre_1DCapable + var_calcium_background_current__g_b_Ca_Periphery_1DCapable) * var_membrane__FCell + var_calcium_background_current__g_b_Ca_Centre_1DCapable))); // microS
            const double var_four_AP_sensitive_currents__g_sus = ((var_membrane__Version == 0) ? ((-var_four_AP_sensitive_currents__g_sus_Centre_Published + var_four_AP_sensitive_currents__g_sus_Periphery_Published) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_four_AP_sensitive_currents__g_sus_Centre_0DCapable + var_four_AP_sensitive_currents__g_sus_Periphery_0DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_0DCapable) : ((-var_four_AP_sensitive_currents__g_sus_Centre_1DCapable + var_four_AP_sensitive_currents__g_sus_Periphery_1DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_sus_Centre_1DCapable))); // microS
            const double var_four_AP_sensitive_currents__g_to = ((var_membrane__Version == 0) ? ((-var_four_AP_sensitive_currents__g_to_Centre_Published + var_four_AP_sensitive_currents__g_to_Periphery_Published) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_four_AP_sensitive_currents__g_to_Centre_0DCapable + var_four_AP_sensitive_currents__g_to_Periphery_0DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_0DCapable) : ((-var_four_AP_sensitive_currents__g_to_Centre_1DCapable + var_four_AP_sensitive_currents__g_to_Periphery_1DCapable) * var_membrane__FCell + var_four_AP_sensitive_currents__g_to_Centre_1DCapable))); // microS
            const double var_hyperpolarisation_activated_current__g_f_K = ((var_membrane__Version == 0) ? ((-var_hyperpolarisation_activated_current__g_f_K_Centre_Published + var_hyperpolarisation_activated_current__g_f_K_Periphery_Published) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable + var_hyperpolarisation_activated_current__g_f_K_Periphery_0DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_0DCapable) : ((-var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable + var_hyperpolarisation_activated_current__g_f_K_Periphery_1DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_K_Centre_1DCapable))); // microS
            const double var_hyperpolarisation_activated_current__g_f_Na = ((var_membrane__Version == 0) ? ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_Published + var_hyperpolarisation_activated_current__g_f_Na_Periphery_Published) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable + var_hyperpolarisation_activated_current__g_f_Na_Periphery_0DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_0DCapable) : ((-var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable + var_hyperpolarisation_activated_current__g_f_Na_Periphery_1DCapable) * var_membrane__FCell + var_hyperpolarisation_activated_current__g_f_Na_Centre_1DCapable))); // microS
            const double var_membrane__Cm = (-var_membrane__CmCentre + var_membrane__CmPeriphery) * var_membrane__FCell + var_membrane__CmCentre; // microF
            const double var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable = 0; // nanoA
            const double var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable = 0.0041999999999999997; // nanoA
            const double var_persistent_calcium_current__i_Ca_p_max_Centre_Published = 0; // nanoA
            const double var_persistent_calcium_current__i_Ca_p_max_Periphery_0DCapable = 0; // nanoA
            const double var_persistent_calcium_current__i_Ca_p_max_Periphery_1DCapable = 0.033390000000000003; // nanoA
            const double var_persistent_calcium_current__i_Ca_p_max_Periphery_Published = 0; // nanoA
            const double var_persistent_calcium_current__i_Ca_p_max = ((var_membrane__Version == 0) ? ((-var_persistent_calcium_current__i_Ca_p_max_Centre_Published + var_persistent_calcium_current__i_Ca_p_max_Periphery_Published) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable + var_persistent_calcium_current__i_Ca_p_max_Periphery_0DCapable) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_0DCapable) : ((-var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable + var_persistent_calcium_current__i_Ca_p_max_Periphery_1DCapable) * var_membrane__FCell + var_persistent_calcium_current__i_Ca_p_max_Centre_1DCapable))); // nanoA
            const double var_persistent_calcium_current__i_Ca_p = var_ionic_concentrations__Ca_i * var_persistent_calcium_current__i_Ca_p_max / (0.00040000000000000002 + var_ionic_concentrations__Ca_i); // nanoA
            const double var_potassium_background_current__g_b_K_Centre_0DCapable = 2.5236359999999998e-5; // microS
            const double var_potassium_background_current__g_b_K_Centre_1DCapable = 2.5199999999999999e-5; // microS
            const double var_potassium_background_current__g_b_K_Centre_Published = 2.5199999999999999e-5; // microS
            const double var_potassium_background_current__g_b_K_Periphery_0DCapable = 8.1891999999999995e-5; // microS
            const double var_potassium_background_current__g_b_K_Periphery_1DCapable = 8.1899999999999999e-5; // microS
            const double var_potassium_background_current__g_b_K_Periphery_Published = 8.1899999999999999e-5; // microS
            const double var_potassium_background_current__g_b_K = ((var_membrane__Version == 0) ? ((-var_potassium_background_current__g_b_K_Centre_Published + var_potassium_background_current__g_b_K_Periphery_Published) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_potassium_background_current__g_b_K_Centre_0DCapable + var_potassium_background_current__g_b_K_Periphery_0DCapable) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_0DCapable) : ((-var_potassium_background_current__g_b_K_Centre_1DCapable + var_potassium_background_current__g_b_K_Periphery_1DCapable) * var_membrane__FCell + var_potassium_background_current__g_b_K_Centre_1DCapable))); // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable = 0.00079704000000000005; // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable = 0.00073800000000000005; // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published = 0.00079699999999999997; // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_0DCapable = 0.016; // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_1DCapable = 0.020799999999999999; // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_Published = 0.016; // microS
            const double var_rapid_delayed_rectifying_potassium_current__g_K_r = ((var_membrane__Version == 0) ? ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_Published) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_0DCapable) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_0DCapable) : ((-var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable + var_rapid_delayed_rectifying_potassium_current__g_K_r_Periphery_1DCapable) * var_membrane__FCell + var_rapid_delayed_rectifying_potassium_current__g_K_r_Centre_1DCapable))); // microS
            const double var_rapid_delayed_rectifying_potassium_current__P_a = 0.40000000000000002 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as + 0.59999999999999998 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af; // dimensionless
            const double var_reversal_and_equilibrium_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Ca_o / var_ionic_concentrations__Ca_i) / var_membrane__F; // millivolt
            const double var_calcium_background_current__i_b_Ca = (-var_reversal_and_equilibrium_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_b_Ca; // nanoA
            const double var_reversal_and_equilibrium_potentials__E_K = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__K_o / var_ionic_concentrations__K_i) / var_membrane__F; // millivolt
            const double var_four_AP_sensitive_currents__i_sus = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_four_AP_sensitive_currents__g_sus * var_chaste_interface__four_AP_sensitive_currents_r_gate__r; // nanoA
            const double var_four_AP_sensitive_currents__i_to = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_four_AP_sensitive_currents__g_to * var_chaste_interface__four_AP_sensitive_currents_q_gate__q * var_chaste_interface__four_AP_sensitive_currents_r_gate__r; // nanoA
            const double var_hyperpolarisation_activated_current__i_f_K = ((var_membrane__Version != 2.0) ? ((-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) : ((102.0 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_K * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y)); // nanoA
            const double var_potassium_background_current__i_b_K = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_background_current__g_b_K; // nanoA
            const double var_rapid_delayed_rectifying_potassium_current__i_K_r = (-var_reversal_and_equilibrium_potentials__E_K + var_chaste_interface__membrane__V) * var_rapid_delayed_rectifying_potassium_current__P_a * var_rapid_delayed_rectifying_potassium_current__g_K_r * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i; // nanoA
            const double var_reversal_and_equilibrium_potentials__E_K_s = ((var_membrane__Version == 0) ? (var_membrane__R * var_membrane__T * log((var_ionic_concentrations__K_o + 0.12 * var_ionic_concentrations__Na_o) / (var_ionic_concentrations__K_i + 0.12 * var_ionic_concentrations__Na_i)) / var_membrane__F) : (var_membrane__R * var_membrane__T * log((var_ionic_concentrations__K_o + 0.029999999999999999 * var_ionic_concentrations__Na_o) / (var_ionic_concentrations__K_i + 0.029999999999999999 * var_ionic_concentrations__Na_i)) / var_membrane__F)); // millivolt
            const double var_reversal_and_equilibrium_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Na_o / var_ionic_concentrations__Na_i) / var_membrane__F; // millivolt
            const double var_hyperpolarisation_activated_current__i_f_Na = ((var_membrane__Version != 2.0) ? ((-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y) : ((-77.599999999999994 + var_chaste_interface__membrane__V) * var_hyperpolarisation_activated_current__g_f_Na * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y)); // nanoA
            const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable = 0.00034450000000000003; // microS
            const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable = 0.00034499999999999998; // microS
            const double var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published = 0.00051800000000000001; // microS
            const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_0DCapable = 0.0104; // microS
            const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_1DCapable = 0.0104; // microS
            const double var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_Published = 0.0104; // microS
            const double var_slow_delayed_rectifying_potassium_current__g_K_s = ((var_membrane__Version == 0) ? ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_Published) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_0DCapable) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_0DCapable) : ((-var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable + var_slow_delayed_rectifying_potassium_current__g_K_s_Periphery_1DCapable) * var_membrane__FCell + var_slow_delayed_rectifying_potassium_current__g_K_s_Centre_1DCapable))); // microS
            const double var_slow_delayed_rectifying_potassium_current__i_K_s = pow(var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs, 2) * (-var_reversal_and_equilibrium_potentials__E_K_s + var_chaste_interface__membrane__V) * var_slow_delayed_rectifying_potassium_current__g_K_s; // nanoA
            const double var_sodium_background_current__g_b_Na_Centre_0DCapable = 5.8181799999999999e-5; // microS
            const double var_sodium_background_current__g_b_Na_Centre_1DCapable = 5.8e-5; // microS
            const double var_sodium_background_current__g_b_Na_Centre_Published = 5.8e-5; // microS
            const double var_sodium_background_current__g_b_Na_Periphery_0DCapable = 0.00018880000000000001; // microS
            const double var_sodium_background_current__g_b_Na_Periphery_1DCapable = 0.00018900000000000001; // microS
            const double var_sodium_background_current__g_b_Na_Periphery_Published = 0.00018900000000000001; // microS
            const double var_sodium_background_current__g_b_Na = ((var_membrane__Version == 0) ? ((-var_sodium_background_current__g_b_Na_Centre_Published + var_sodium_background_current__g_b_Na_Periphery_Published) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_background_current__g_b_Na_Centre_0DCapable + var_sodium_background_current__g_b_Na_Periphery_0DCapable) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_0DCapable) : ((-var_sodium_background_current__g_b_Na_Centre_1DCapable + var_sodium_background_current__g_b_Na_Periphery_1DCapable) * var_membrane__FCell + var_sodium_background_current__g_b_Na_Centre_1DCapable))); // microS
            const double var_sodium_background_current__i_b_Na = (-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_b_Na; // nanoA
            const double var_sodium_calcium_exchanger__d_NaCa = 0.0001; // dimensionless
            const double var_sodium_calcium_exchanger__gamma_NaCa = 0.5; // dimensionless
            const double var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable = 2.7228999999999998e-6; // nanoA
            const double var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable = 2.7999999999999999e-6; // nanoA
            const double var_sodium_calcium_exchanger__k_NaCa_Centre_Published = 2.7e-6; // nanoA
            const double var_sodium_calcium_exchanger__k_NaCa_Periphery_0DCapable = 8.8358400000000004e-6; // nanoA
            const double var_sodium_calcium_exchanger__k_NaCa_Periphery_1DCapable = 8.8000000000000004e-6; // nanoA
            const double var_sodium_calcium_exchanger__k_NaCa_Periphery_Published = 8.8000000000000004e-6; // nanoA
            const double var_sodium_calcium_exchanger__k_NaCa = ((var_membrane__Version == 0) ? ((-var_sodium_calcium_exchanger__k_NaCa_Centre_Published + var_sodium_calcium_exchanger__k_NaCa_Periphery_Published) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable + var_sodium_calcium_exchanger__k_NaCa_Periphery_0DCapable) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_0DCapable) : ((-var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable + var_sodium_calcium_exchanger__k_NaCa_Periphery_1DCapable) * var_membrane__FCell + var_sodium_calcium_exchanger__k_NaCa_Centre_1DCapable))); // nanoA
            const double var_sodium_calcium_exchanger__i_NaCa = ((var_membrane__Version == 0) ? ((pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma_NaCa) - pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i * exp(0.037400000000000003 * (-1.0 + var_sodium_calcium_exchanger__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_sodium_calcium_exchanger__k_NaCa / (1.0 + (pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o + pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i) * var_sodium_calcium_exchanger__d_NaCa)) : ((pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o * exp(0.037429999999999998 * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger__gamma_NaCa) - pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i * exp(0.037429999999999998 * (-1.0 + var_sodium_calcium_exchanger__gamma_NaCa) * var_chaste_interface__membrane__V)) * var_sodium_calcium_exchanger__k_NaCa / (1.0 + (pow(var_ionic_concentrations__Na_i, 3) * var_ionic_concentrations__Ca_o + pow(var_ionic_concentrations__Na_o, 3) * var_ionic_concentrations__Ca_i) * var_sodium_calcium_exchanger__d_NaCa))); // nanoA
            const double var_sodium_current__g_Na_Centre_0DCapable = 0; // microlitre_per_second
            const double var_sodium_current__g_Na_Centre_1DCapable = 0; // microlitre_per_second
            const double var_sodium_current__g_Na_Centre_Published = 0; // microlitre_per_second
            const double var_sodium_current__g_Na_Periphery_0DCapable = 1.204e-6; // microlitre_per_second
            const double var_sodium_current__g_Na_Periphery_1DCapable = 3.7e-7; // microlitre_per_second
            const double var_sodium_current__g_Na_Periphery_Published = 1.1999999999999999e-6; // microlitre_per_second
            const double var_sodium_current__g_Na = ((var_membrane__Version == 0) ? ((-var_sodium_current__g_Na_Centre_Published + var_sodium_current__g_Na_Periphery_Published) * var_membrane__FCell + var_sodium_current__g_Na_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_current__g_Na_Centre_0DCapable + var_sodium_current__g_Na_Periphery_0DCapable) * var_membrane__FCell + var_sodium_current__g_Na_Centre_0DCapable) : ((-var_sodium_current__g_Na_Centre_1DCapable + var_sodium_current__g_Na_Periphery_1DCapable) * var_membrane__FCell + var_sodium_current__g_Na_Centre_1DCapable))); // microlitre_per_second
            const double var_sodium_current_h_gate__F_Na = ((var_membrane__Version == 0) ? (0.086900000000000005 + 0.095200000000000007 * exp(-2.1671999999999998 - 0.063 * var_chaste_interface__membrane__V) / (1.0 + 1.6599999999999999 * exp(-14.332500000000001 - 0.22500000000000001 * var_chaste_interface__membrane__V))) : (0.086929999999999993 + 0.095180000000000001 * exp(-2.1692640000000001 - 0.063060000000000005 * var_chaste_interface__membrane__V) / (1.0 + 1.6619999999999999 * exp(-14.33887 - 0.22509999999999999 * var_chaste_interface__membrane__V)))); // dimensionless
            const double var_sodium_current_h_gate__h = (1.0 - var_sodium_current_h_gate__F_Na) * var_chaste_interface__sodium_current_h_gate__h1 + var_sodium_current_h_gate__F_Na * var_chaste_interface__sodium_current_h_gate__h2; // dimensionless
            const double var_sodium_current__i_Na = pow(var_membrane__F, 2) * pow(var_chaste_interface__sodium_current_m_gate__m, 3) * (-1.0 + exp((-var_reversal_and_equilibrium_potentials__E_Na + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_ionic_concentrations__Na_o * var_chaste_interface__membrane__V * var_sodium_current__g_Na * var_sodium_current_h_gate__h / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // nanoA
            const double var_sodium_potassium_pump__K_m_K = 0.621; // millimolar
            const double var_sodium_potassium_pump__K_m_Na = 5.6399999999999997; // millimolar
            const double var_sodium_potassium_pump__i_p_max_Centre_0DCapable = 0.047825449999999999; // nanoA
            const double var_sodium_potassium_pump__i_p_max_Centre_1DCapable = 0.047800000000000002; // nanoA
            const double var_sodium_potassium_pump__i_p_max_Centre_Published = 0.047800000000000002; // nanoA
            const double var_sodium_potassium_pump__i_p_max_Periphery_0DCapable = 0.15519359999999999; // nanoA
            const double var_sodium_potassium_pump__i_p_max_Periphery_1DCapable = 0.16; // nanoA
            const double var_sodium_potassium_pump__i_p_max_Periphery_Published = 0.16; // nanoA
            const double var_sodium_potassium_pump__i_p_max = ((var_membrane__Version == 0) ? ((-var_sodium_potassium_pump__i_p_max_Centre_Published + var_sodium_potassium_pump__i_p_max_Periphery_Published) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_Published) : ((var_membrane__Version == 1.0) ? ((-var_sodium_potassium_pump__i_p_max_Centre_0DCapable + var_sodium_potassium_pump__i_p_max_Periphery_0DCapable) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_0DCapable) : ((-var_sodium_potassium_pump__i_p_max_Centre_1DCapable + var_sodium_potassium_pump__i_p_max_Periphery_1DCapable) * var_membrane__FCell + var_sodium_potassium_pump__i_p_max_Centre_1DCapable))); // nanoA
            const double var_sodium_potassium_pump__i_p = 1.6000000000000001 * pow(var_ionic_concentrations__K_o, 2) * pow(var_ionic_concentrations__Na_i, 3) * var_sodium_potassium_pump__i_p_max / ((1.5 + exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V)) * pow((var_ionic_concentrations__K_o + var_sodium_potassium_pump__K_m_K), 2) * pow((var_ionic_concentrations__Na_i + var_sodium_potassium_pump__K_m_Na), 3)); // nanoA
            const double var_membrane__V_orig_deriv = -1.0 * (var_L_type_Ca_channel__i_Ca_L + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_b_Ca + var_four_AP_sensitive_currents__i_sus + var_four_AP_sensitive_currents__i_to + var_hyperpolarisation_activated_current__i_f_K + var_hyperpolarisation_activated_current__i_f_Na + var_persistent_calcium_current__i_Ca_p + var_potassium_background_current__i_b_K + var_rapid_delayed_rectifying_potassium_current__i_K_r + var_slow_delayed_rectifying_potassium_current__i_K_s + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger__i_NaCa + var_sodium_current__i_Na + var_sodium_potassium_pump__i_p) / var_membrane__Cm; // millivolt / second
            d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_sodium_current_m_gate__m;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_sodium_current_h_gate__h1;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_sodium_current_h_gate__h2;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d_L;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f_L;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_T_type_Ca_channel_d_gate__d_T;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_T_type_Ca_channel_f_gate__f_T;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_four_AP_sensitive_currents_q_gate__q;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_four_AP_sensitive_currents_r_gate__r;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_af_gate__P_af;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_as_gate__P_as;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_rapid_delayed_rectifying_potassium_current_P_i_gate__P_i;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_slow_delayed_rectifying_potassium_current_xs_gate__xs;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_hyperpolarisation_activated_current_y_gate__y;
    }

    void Cellzhang_SAN_model_2000_allFromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__environment__time_converted, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -39.013558536
        double var_chaste_interface__sodium_current_m_gate__m = NV_Ith_S(rY, 1);
        // Units: dimensionless; Initial value: 0.092361701692
        double var_chaste_interface__sodium_current_h_gate__h1 = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.015905380261
        double var_chaste_interface__sodium_current_h_gate__h2 = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.01445216109
        double var_chaste_interface__L_type_Ca_channel_d_gate__d_L = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.04804900895
        double var_chaste_interface__L_type_Ca_channel_f_gate__f_L = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.48779845203
        double var_chaste_interface__T_type_Ca_channel_d_gate__d_T = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.42074047435
        double var_chaste_interface__T_type_Ca_channel_f_gate__f_T = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.038968420558
        double var_chaste_interface__four_AP_sensitive_currents_q_gate__q = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.29760539675
        double var_chaste_interface__four_AP_sensitive_currents_r_gate__r = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.064402950262
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.13034201158
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.46960956028
        double var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.87993375273
        double var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.082293827208
        double var_chaste_interface__hyperpolarisation_activated_current_y_gate__y = NV_Ith_S(rY, 14);
        // Units: dimensionless; Initial value: 0.03889291759
        
        const double var_x0 = 0.018714999999999999 * var_chaste_interface__membrane__V;
        const double var_x1 = -0.16666666666666666 * var_chaste_interface__membrane__V;
        const double var_x2 = exp(-2.3500000000000001 + var_x1);
        const double var_x3 = 1.0 + var_x2;
        const double var_x4 = exp(-1.5 - 0.025000000000000001 * var_chaste_interface__membrane__V);
        const double var_x5 = 13.441615999999998 - 0.28969 * var_chaste_interface__membrane__V;
        const double var_x6 = 9.6256349999999991 - 0.21390299999999998 * var_chaste_interface__membrane__V;
        const double var_x7 = -21.24648068471733 - 0.24524999999999997 * var_chaste_interface__membrane__V;
        const double var_x8 = exp(-5.5531135531135529 - 0.18315018315018314 * var_chaste_interface__membrane__V);
        const double var_x9 = 1 / (1.0 + var_x8);
        const double var_x10 = pow(var_x9, 0.33333333333333331);
        const double var_x11 = exp(5.3505781299999997 + 0.082299999999999998 * var_chaste_interface__membrane__V);
        const double var_x12 = exp(-19.034003092000003 - 0.33566000000000001 * var_chaste_interface__membrane__V);
        const double var_x13 = 1 / (0.62739999999999996 * var_x11 + 0.83221659999999997 * var_x12);
        const double var_x14 = 1 / (4.5689999999999998e-5 + 0.00062469999999999995 * var_x13);
        const double var_x15 = exp(-12.936576000000001 - 0.34260000000000002 * var_chaste_interface__membrane__V);
        const double var_x16 = 1.0 + 0.0037320000000000001 * var_x15;
        const double var_x17 = exp(-4.8164649999999991 - 0.28149999999999997 * var_chaste_interface__membrane__V);
        const double var_x18 = var_x17 / var_x16;
        const double var_x19 = exp(10.328124999999998 + 0.15625 * var_chaste_interface__membrane__V);
        const double var_x20 = 1.0 + var_x19;
        const double var_x21 = 1 / var_x20;
        const double var_x22 = 1 / (0.00059770000000000005 + 3.7170000000000002e-6 * var_x18);
        const double var_x23 = 0.00015625 * var_x19 / pow(var_x20, 2);
        const double var_x24 = exp(-22.768981 - 0.66830000000000001 * var_chaste_interface__membrane__V);
        const double var_x25 = 1.0 + 7.1890000000000005e-5 * var_x24;
        const double var_x26 = exp(-11.69172 - 0.62190000000000001 * var_chaste_interface__membrane__V);
        const double var_x27 = var_x26 / var_x25;
        const double var_x28 = 1 / (0.0035560000000000001 + 3.1860000000000002e-8 * var_x27);
        const double var_x29 = exp(-3.7166666666666668 + var_x1);
        const double var_x30 = 1.0 + var_x29;
        const double var_x31 = exp(-2.0 + 0.40000000000000002 * var_chaste_interface__membrane__V);
        const double var_x32 = -1.0 + var_x31;
        const double var_x33 = 1 / var_x32;
        const double var_x34 = 5.7149999999999999 * var_x33;
        const double var_x35 = exp(-14.0 - 0.40000000000000002 * var_chaste_interface__membrane__V);
        const double var_x36 = -1.0 + var_x35;
        const double var_x37 = 1 / var_x36;
        const double var_x38 = 14.195 * var_x37;
        const double var_x39 = exp(-0.20799999999999999 * var_chaste_interface__membrane__V);
        const double var_x40 = -1.0 + var_x39;
        const double var_x41 = 1 / var_x40;
        const double var_x42 = 42.450000000000003 * var_x41;
        const double var_x43 = 35.0 + var_chaste_interface__membrane__V;
        const double var_x44 = -5.0 + var_chaste_interface__membrane__V;
        const double var_x45 = exp(9.0 + 0.20000000000000001 * var_chaste_interface__membrane__V);
        const double var_x46 = 1.0 + var_x45;
        const double var_x47 = 0.25 * var_chaste_interface__membrane__V;
        const double var_x48 = exp(7.0 + var_x47);
        const double var_x49 = -1.0 + var_x48;
        const double var_x50 = 1 / var_x49;
        const double var_x51 = 3.125 * var_x50;
        const double var_x52 = exp(-7.0 - var_x47);
        const double var_x53 = 1.0 + var_x52;
        const double var_x54 = 28.0 + var_chaste_interface__membrane__V;
        const double var_x55 = 1 / var_x53;
        const double var_x56 = exp(-5.4411764705882355 - 0.14705882352941177 * var_chaste_interface__membrane__V);
        const double var_x57 = 1.0 + var_x56;
        const double var_x58 = 0.033333333333333333 * var_chaste_interface__membrane__V;
        const double var_x59 = exp(0.87666666666666671 + var_x58);
        const double var_x60 = exp(-0.87666666666666671 - var_x58);
        const double var_x61 = 0.1111111111111111 * var_chaste_interface__membrane__V;
        const double var_x62 = exp(7.8888888888888893 + var_x61);
        const double var_x63 = 1.0 + var_x62;
        const double var_x64 = exp(4.6163849154746419 + 0.065019505851755519 * var_chaste_interface__membrane__V);
        const double var_x65 = exp(-0.85234093637454988 - 0.012004801920768308 * var_chaste_interface__membrane__V);
        const double var_x66 = exp(4.5320610687022898 + 0.076335877862595422 * var_chaste_interface__membrane__V);
        const double var_x67 = 1.0 + var_x66;
        const double var_x68 = exp(-3.1827900000000002 - 0.081610000000000002 * var_chaste_interface__membrane__V);
        const double var_x69 = exp(11.128867 + 0.27189999999999998 * var_chaste_interface__membrane__V);
        const double var_x70 = 1 / (0.56859999999999999 * var_x68 + 0.71740000000000004 * var_x69);
        const double var_x71 = 1 / (0.010103333333333334 + 0.065166666666666664 * var_x70);
        const double var_x72 = exp(0.5548223350253807 - 0.050761421319796954 * var_chaste_interface__membrane__V);
        const double var_x73 = 1.0 + var_x72;
        const double var_x74 = exp(2.7585732000000003 + 0.090120000000000006 * var_chaste_interface__membrane__V);
        const double var_x75 = exp(-2.8369599999999999 - 0.11899999999999999 * var_chaste_interface__membrane__V);
        const double var_x76 = 1 / (1.0369999999999999 * var_x74 + 0.36899999999999999 * var_x75);
        const double var_x77 = 1 / (0.0029775000000000001 + 0.019595000000000001 * var_x76);
        const double var_x78 = exp(-1.3396226415094339 - 0.094339622641509441 * var_chaste_interface__membrane__V);
        const double var_x79 = 1.0 + var_x78;
        const double var_x80 = 0.001 / var_x79;
        const double var_x81 = exp(-0.56603773584905659 + 0.062893081761006289 * var_chaste_interface__membrane__V);
        const double var_x82 = exp(0.40000000000000002 - 0.044444444444444446 * var_chaste_interface__membrane__V);
        const double var_x83 = 9.4339622641509443e-5 * var_x78 / pow(var_x79, 2);
        const double var_x84 = exp(-0.52941176470588236 + 0.058823529411764705 * var_chaste_interface__membrane__V);
        const double var_x85 = exp(0.41666666666666663 - 0.046296296296296294 * var_chaste_interface__membrane__V);
        const double var_x86 = exp(1.8415841584158419 + 0.099009900990099015 * var_chaste_interface__membrane__V);
        const double var_x87 = exp(-0.022222222222222223 * var_chaste_interface__membrane__V);
        const double var_x88 = exp(4.4444444444444446 - var_x61);
        const double var_x89 = 1.0 + var_x88;
        const double var_x90 = exp(3.5355294117647058 + 0.047058823529411764 * var_chaste_interface__membrane__V);
        const double var_x91 = exp(-2.9631993991738641 - 0.037551633496057078 * var_chaste_interface__membrane__V);
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0048327079999999998 - 0.0023092690674785805 * exp(var_x0) - 0.00061881194542590091 * exp(-var_x0) - 0.054649999999999997 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y - 0.00173814 / var_x3 - 0.017225000000000001 * pow(var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs, 2) - 0.003322752 * var_chaste_interface__four_AP_sensitive_currents_r_gate__r + (-0.015940800000000001 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as - 0.023911199999999997 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af) * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i - 0.21390299999999998 * var_chaste_interface__T_type_Ca_channel_d_gate__d_T * var_chaste_interface__T_type_Ca_channel_f_gate__f_T - 0.24524999999999997 * var_chaste_interface__four_AP_sensitive_currents_q_gate__q * var_chaste_interface__four_AP_sensitive_currents_r_gate__r - 0.28969 * var_chaste_interface__L_type_Ca_channel_d_gate__d_L * var_chaste_interface__L_type_Ca_channel_f_gate__f_L - 0.0068989604918571314 * var_x4 / pow((1 + 0.66666666666666663 * var_x4), 2) + 0.001 * var_x2 * var_x5 / pow(var_x3, 2));
        IJth(rJacobian, 1, 0) = 6.105006105006105e-5 * var_x10 * var_x14 * var_x8 * var_x9 - 2.3112969460591231 * (-var_chaste_interface__sodium_current_m_gate__m + var_x10) * (0.27934182395599999 * var_x12 - 0.051635019999999997 * var_x11) / (pow((0.073139106771250198 + var_x13), 2) * pow((var_x12 + 0.75389027327741354 * var_x11), 2));
        IJth(rJacobian, 2, 0) = -var_x22 * var_x23 + 2799.1971566651023 * (var_x21 - var_chaste_interface__sodium_current_h_gate__h1) * (1.0463354999999999e-6 * var_x18 - 4.7524937544000007e-9 * var_x15 * var_x17 / pow(var_x16, 2)) / pow((1 + 0.0062188388823824657 * var_x18), 2);
        IJth(rJacobian, 3, 0) = -var_x23 * var_x28 + 79.081790816642851 * (var_x21 - var_chaste_interface__sodium_current_h_gate__h2) * (1.9813734000000003e-8 * var_x27 - 1.5306846118200001e-12 * var_x24 * var_x26 / pow(var_x25, 2)) / pow((1 + 8.959505061867266e-6 * var_x27), 2);
        IJth(rJacobian, 4, 0) = (0.001 / var_x30 - 0.001 * var_chaste_interface__L_type_Ca_channel_d_gate__d_L) * (var_x34 - var_x38 - var_x42 - 5.6779999999999999 * var_x35 * var_x43 / pow(var_x36, 2) - 8.829600000000001 * var_x39 * var_chaste_interface__membrane__V / pow(var_x40, 2) - 2.286 * var_x31 * var_x44 / pow(var_x32, 2)) + 0.00016666666666666666 * var_x29 * (var_x34 * var_x44 - var_x38 * var_x43 - var_x42 * var_chaste_interface__membrane__V) / pow(var_x30, 2);
        IJth(rJacobian, 5, 0) = (0.001 / var_x46 - 0.001 * var_chaste_interface__L_type_Ca_channel_f_gate__f_L) * (var_x51 + 6.25 * var_x52 / pow(var_x53, 2) - 0.78125 * var_x48 * var_x54 / pow(var_x49, 2)) - 0.00020000000000000001 * var_x45 * (25.0 * var_x55 + var_x51 * var_x54) / pow(var_x46, 2);
        IJth(rJacobian, 6, 0) = (0.001 / var_x57 - 0.001 * var_chaste_interface__T_type_Ca_channel_d_gate__d_T) * (35.600000000000001 * var_x59 - 35.600000000000001 * var_x60) + 0.00014705882352941178 * var_x56 * (1068.0 * var_x59 + 1068.0 * var_x60) / pow(var_x57, 2);
        IJth(rJacobian, 7, 0) = (0.001 / var_x63 - 0.001 * var_chaste_interface__T_type_Ca_channel_f_gate__f_T) * (0.97529258777633288 * var_x64 - 0.18367346938775511 * var_x65) - 0.00011111111111111112 * var_x62 * (15.0 * var_x64 + 15.300000000000001 * var_x65) / pow(var_x63, 2);
        IJth(rJacobian, 8, 0) = -7.6335877862595422e-5 * var_x66 * var_x71 / pow(var_x67, 2) - 0.02981616261141468 * (-var_chaste_interface__four_AP_sensitive_currents_q_gate__q + 1 / var_x67) * (0.046403446000000001 * var_x68 - 0.19506105999999998 * var_x69) / (pow((0.1550383631713555 + var_x70), 2) * pow((var_x69 + 0.79258433231112346 * var_x68), 2));
        IJth(rJacobian, 9, 0) = 5.076142131979696e-5 * var_x72 * var_x77 / pow(var_x73, 2) - 0.047456665474470604 * (-var_chaste_interface__four_AP_sensitive_currents_r_gate__r + 1 / var_x73) * (0.043910999999999999 * var_x75 - 0.09345444 * var_x74) / (pow((0.15195202857871906 + var_x76), 2) * pow((var_x74 + 0.35583413693346194 * var_x75), 2));
        IJth(rJacobian, 10, 0) = var_x83 * (0.95999999999999996 * var_x82 + 37.200000000000003 * var_x81) + (var_x80 - 0.001 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af) * (2.3396226415094339 * var_x81 - 0.042666666666666665 * var_x82);
        IJth(rJacobian, 11, 0) = var_x83 * (4.2000000000000002 * var_x84 + 0.14999999999999999 * var_x85) + (var_x80 - 0.001 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as) * (0.24705882352941178 * var_x84 - 0.0069444444444444441 * var_x85);
        IJth(rJacobian, 12, 0) = -0.049504950495049507 * var_x86 / pow((1.0 + var_x86), 2);
        IJth(rJacobian, 13, 0) = 2.2222222222222223e-5 * var_x87 * var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs + 0.0015555555555555555 * var_x88 * (1.0 - var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs) / pow(var_x89, 2);
        IJth(rJacobian, 14, 0) = -4.7058823529411767e-5 * var_x90 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y - 0.037551633496057078 * var_x91 * (0.001 - 0.001 * var_chaste_interface__hyperpolarisation_activated_current_y_gate__y);
        IJth(rJacobian, 1, 1) = -0.001 * var_x14;
        IJth(rJacobian, 2, 2) = -0.001 * var_x22;
        IJth(rJacobian, 3, 3) = -0.001 * var_x28;
        IJth(rJacobian, 0, 4) = mSetVoltageDerivativeToZero ? 0.0 : (var_x5 * var_chaste_interface__L_type_Ca_channel_f_gate__f_L);
        IJth(rJacobian, 4, 4) = 0.014195000000000001 * var_x37 * var_x43 + 0.042450000000000002 * var_x41 * var_chaste_interface__membrane__V - 0.0057149999999999996 * var_x33 * var_x44;
        IJth(rJacobian, 0, 5) = mSetVoltageDerivativeToZero ? 0.0 : (var_x5 * var_chaste_interface__L_type_Ca_channel_d_gate__d_L);
        IJth(rJacobian, 5, 5) = -0.025000000000000001 * var_x55 - 0.0031250000000000002 * var_x50 * var_x54;
        IJth(rJacobian, 0, 6) = mSetVoltageDerivativeToZero ? 0.0 : (var_x6 * var_chaste_interface__T_type_Ca_channel_f_gate__f_T);
        IJth(rJacobian, 6, 6) = -1.0680000000000001 * var_x59 - 1.0680000000000001 * var_x60;
        IJth(rJacobian, 0, 7) = mSetVoltageDerivativeToZero ? 0.0 : (var_x6 * var_chaste_interface__T_type_Ca_channel_d_gate__d_T);
        IJth(rJacobian, 7, 7) = -0.015300000000000001 * var_x65 - 0.014999999999999999 * var_x64;
        IJth(rJacobian, 0, 8) = mSetVoltageDerivativeToZero ? 0.0 : (var_x7 * var_chaste_interface__four_AP_sensitive_currents_r_gate__r);
        IJth(rJacobian, 8, 8) = -0.001 * var_x71;
        IJth(rJacobian, 0, 9) = mSetVoltageDerivativeToZero ? 0.0 : (-0.28785641666913714 - 0.003322752 * var_chaste_interface__membrane__V + var_x7 * var_chaste_interface__four_AP_sensitive_currents_q_gate__q);
        IJth(rJacobian, 9, 9) = -0.001 * var_x77;
        IJth(rJacobian, 0, 10) = mSetVoltageDerivativeToZero ? 0.0 : ((-2.0714733902075966 - 0.023911199999999997 * var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i);
        IJth(rJacobian, 10, 10) = -0.00095999999999999992 * var_x82 - 0.037200000000000004 * var_x81;
        IJth(rJacobian, 0, 11) = mSetVoltageDerivativeToZero ? 0.0 : ((-1.3809822601383979 - 0.015940800000000001 * var_chaste_interface__membrane__V) * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_i_gate__P_i);
        IJth(rJacobian, 11, 11) = -0.00014999999999999999 * var_x85 - 0.0042000000000000006 * var_x84;
        IJth(rJacobian, 0, 12) = mSetVoltageDerivativeToZero ? 0.0 : ((-3.4524556503459944 - 0.039851999999999999 * var_chaste_interface__membrane__V) * (0.40000000000000002 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_as_gate__P_as + 0.59999999999999998 * var_chaste_interface__rapid_delayed_rectifying_potassium_current_P_af_gate__P_af));
        IJth(rJacobian, 12, 12) = -0.5;
        IJth(rJacobian, 0, 13) = mSetVoltageDerivativeToZero ? 0.0 : (-0.034450000000000001 * (71.365322852196982 + var_chaste_interface__membrane__V) * var_chaste_interface__slow_delayed_rectifying_potassium_current_xs_gate__xs);
        IJth(rJacobian, 13, 13) = -0.001 * var_x87 - 0.014 / var_x89;
        IJth(rJacobian, 0, 14) = mSetVoltageDerivativeToZero ? 0.0 : (-0.28582110376219411 - 0.054649999999999997 * var_chaste_interface__membrane__V);
        IJth(rJacobian, 14, 14) = -0.001 * var_x90 - 0.001 * var_x91;
    }

    N_Vector Cellzhang_SAN_model_2000_allFromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        
        // Mathematics

        N_Vector dqs = N_VNew_Serial(1);
        NV_Ith_S(dqs, 0) = var_chaste_interface__environment__time_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellzhang_SAN_model_2000_allFromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "zhang_SAN_model_2000_all";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-39.013558536);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.092361701692);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("sodium_current_h_gate__h1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.015905380261);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("sodium_current_h_gate__h2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01445216109);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.04804900895);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("L_type_Ca_channel_f_gate__f_L");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.48779845203);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("T_type_Ca_channel_d_gate__d_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.42074047435);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("T_type_Ca_channel_f_gate__f_T");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.038968420558);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("four_AP_sensitive_currents_q_gate__q");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.29760539675);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("four_AP_sensitive_currents_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.064402950262);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("rapid_delayed_rectifying_potassium_current_P_af_gate__P_af");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.13034201158);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("rapid_delayed_rectifying_potassium_current_P_as_gate__P_as");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.46960956028);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("rapid_delayed_rectifying_potassium_current_P_i_gate__P_i");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.87993375273);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("slow_delayed_rectifying_potassium_current_xs_gate__xs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.082293827208);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("hyperpolarisation_activated_current_y_gate__y");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.03889291759);

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellzhang_SAN_model_2000_allFromCellMLCvode)
#endif // CHASTE_CVODE
