#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: viswanathan_model_1999_epi
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "viswanathan_model_1999_epi.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellviswanathan_model_1999_epiFromCellMLCvode::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__stim_amplitude_converted = -25.5 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__stim_duration_converted = 2.0; // millisecond
        const double var_chaste_interface__membrane__stim_period_converted = 1000.0; // millisecond
        const double var_chaste_interface__membrane__stim_start_converted = 100.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__stim_amplitude_converted),
                var_chaste_interface__membrane__stim_duration_converted,
                var_chaste_interface__membrane__stim_period_converted,
                var_chaste_interface__membrane__stim_start_converted
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    double Cellviswanathan_model_1999_epiFromCellMLCvode::GetIntracellularCalciumConcentration()
    {
        return NV_Ith_S(mStateVariables, 1);
    }
    
    Cellviswanathan_model_1999_epiFromCellMLCvode::Cellviswanathan_model_1999_epiFromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                25,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellviswanathan_model_1999_epiFromCellMLCvode>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
        NV_Ith_S(this->mParameters, 0) = 0.001; // (var_membrane__Cm) [microF]
    }

    Cellviswanathan_model_1999_epiFromCellMLCvode::~Cellviswanathan_model_1999_epiFromCellMLCvode()
    {
    }
    
    double Cellviswanathan_model_1999_epiFromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -88.984
        double var_chaste_interface__calcium_dynamics__Cai = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 0.00035237
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.00079287
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.9938
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.99573
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 3.18355e-06
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.9974388
        double var_chaste_interface__T_type_Ca_channel_b_gate__b = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.000967785
        double var_chaste_interface__T_type_Ca_channel_g_gate__g = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.95331988
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.00032151644
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.0272635
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2 = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.0631269
        double var_chaste_interface__transient_outward_current_zdv_gate__zdv = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.011528
        double var_chaste_interface__transient_outward_current_ydv_gate__ydv = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.985232
        double var_chaste_interface__ionic_concentrations__Nai = NV_Ith_S(rY, 23);
        // Units: millimolar; Initial value: 15.6748357
        double var_chaste_interface__ionic_concentrations__Ki = NV_Ith_S(rY, 24);
        // Units: millimolar; Initial value: 137.6244
        
        const double var_ATP_sensitive_potassium_current__ATPi = 3.0; // millimolar
        const double var_ATP_sensitive_potassium_current__hATP = 2.0; // dimensionless
        const double var_ATP_sensitive_potassium_current__kATP = 0.00025000000000000001; // millimolar
        const double var_ATP_sensitive_potassium_current__nATP = 0.23999999999999999; // dimensionless
        const double var_ATP_sensitive_potassium_current__nicholsarea = 5.0000000000000002e-5; // dimensionless
        const double var_ATP_sensitive_potassium_current__g_K_ATP = 0.000193 / var_ATP_sensitive_potassium_current__nicholsarea; // milliS_per_microF
        const double var_ATP_sensitive_potassium_current__pATP = 1 / (1.0 + pow((var_ATP_sensitive_potassium_current__ATPi / var_ATP_sensitive_potassium_current__kATP), var_ATP_sensitive_potassium_current__hATP)); // dimensionless
        const double var_L_type_Ca_channel__P_Ca = 0.00054000000000000001; // cm_per_second
        const double var_L_type_Ca_channel__P_K = 1.9299999999999999e-7; // cm_per_second
        const double var_L_type_Ca_channel__P_Na = 6.75e-7; // cm_per_second
        const double var_L_type_Ca_channel__gamma_Cai = 1.0; // dimensionless
        const double var_L_type_Ca_channel__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ki = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ko = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nai = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nao = 0.75; // dimensionless
        const double var_L_type_Ca_channel_f_Ca_gate__Km_Ca = 0.00059999999999999995; // millimolar
        const double var_Na_Ca_exchanger__K_NaCa = 0.002; // millimolar
        const double var_Na_Ca_exchanger__d_NaCa = 0.001; // millimolar
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_T_type_Ca_channel__g_CaT = 0.050000000000000003; // milliS_per_microF
        const double var_calcium_background_current__g_Cab = 0.003016; // milliS_per_microF
        const double var_L_type_Ca_channel_f_Ca_gate__f_Ca = 1 / (1.0 + var_chaste_interface__calcium_dynamics__Cai / var_L_type_Ca_channel_f_Ca_gate__Km_Ca); // dimensionless
        const double var_calcium_dynamics__Cao = 1.8; // millimolar
        const double var_fast_sodium_current__g_Na = 16.0; // milliS_per_microF
        const double var_ionic_concentrations__Ko = 4.5; // millimolar
        const double var_ATP_sensitive_potassium_current__GKbaraATP = pow((0.25 * var_ionic_concentrations__Ko), var_ATP_sensitive_potassium_current__nATP) * var_ATP_sensitive_potassium_current__g_K_ATP * var_ATP_sensitive_potassium_current__pATP; // milliS_per_microF
        const double var_ionic_concentrations__Nao = 132.0; // millimolar
        const double var_membrane__F = 96485.0; // coulomb_per_mole
        const double var_membrane__R = 8314.0; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Cao / var_chaste_interface__calcium_dynamics__Cai) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // millivolt
        const double var_L_type_Ca_channel__I_CaCa = 4.0 * pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Cao * var_calcium_dynamics__Cao + var_L_type_Ca_channel__gamma_Cai * var_chaste_interface__calcium_dynamics__Cai * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__I_CaK = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * var_ionic_concentrations__Ko + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_K * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__I_CaNa = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * var_ionic_concentrations__Nao + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Na * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__i_CaCa = var_L_type_Ca_channel__I_CaCa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_CaK = var_L_type_Ca_channel__I_CaK * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_CaNa = var_L_type_Ca_channel__I_CaNa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaCa + var_L_type_Ca_channel__i_CaK + var_L_type_Ca_channel__i_CaNa; // microA_per_microF
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, var_Na_Ca_exchanger__n_NaCa) * var_calcium_dynamics__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__calcium_dynamics__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__calcium_dynamics__Cai) * (1.0 + (pow(var_chaste_interface__ionic_concentrations__Nai, var_Na_Ca_exchanger__n_NaCa) * var_calcium_dynamics__Cao + pow(var_ionic_concentrations__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__calcium_dynamics__Cai) * var_Na_Ca_exchanger__d_NaCa)); // microA_per_microF
        const double var_T_type_Ca_channel__i_Ca_T = pow(var_chaste_interface__T_type_Ca_channel_b_gate__b, 2) * (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_CaT * var_chaste_interface__T_type_Ca_channel_g_gate__g; // microA_per_microF
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // microA_per_microF
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // microA_per_microF
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // millimolar
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 0; // cm_per_second
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * var_ionic_concentrations__Ko + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_chaste_interface__membrane__V * var_non_specific_calcium_activated_current__P_ns_Ca / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * var_ionic_concentrations__Nao + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_chaste_interface__membrane__V * var_non_specific_calcium_activated_current__P_ns_Ca / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_dynamics__Cai, 3)); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_dynamics__Cai, 3)); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // microA_per_microF
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 0.0055199999999999997; // milliS_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__Rect = 1 / (1.0 + exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr = 0.011248864963317985 * sqrt(var_ionic_concentrations__Ko); // milliS_per_microF
        const double var_sarcolemmal_calcium_pump__I_pCa = 1.1499999999999999; // microA_per_microF
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_dynamics__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_dynamics__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // microA_per_microF
        const double var_slow_delayed_rectifier_potassium_current__PNaK = 0.018329999999999999; // dimensionless
        const double var_slow_delayed_rectifier_potassium_current__E_Ks = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_slow_delayed_rectifier_potassium_current__PNaK + var_ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_slow_delayed_rectifier_potassium_current__PNaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // millivolt
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.433 + 0.25979999999999998 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__calcium_dynamics__Cai, 1.3999999999999999)); // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = (-var_slow_delayed_rectifier_potassium_current__E_Ks + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2; // microA_per_microF
        const double var_sodium_background_current__g_Nab = 0.0040000000000000001; // milliS_per_microF
        const double var_sodium_background_current__i_Na_b = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // microA_per_microF
        const double var_sodium_potassium_pump__I_NaK = 2.0; // microA_per_microF
        const double var_sodium_potassium_pump__K_mKo = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_mNai = 10.0; // millimolar
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow(var_sodium_potassium_pump__K_mNai, 2) / pow(var_chaste_interface__ionic_concentrations__Nai, 2)) * (var_ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // microA_per_microF
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_ATP_sensitive_potassium_current__i_K_ATP = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_ATP_sensitive_potassium_current__GKbaraATP; // microA_per_microF
        const double var_plateau_potassium_current__i_Kp = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // microA_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_rapid_delayed_rectifier_potassium_current__Rect * var_rapid_delayed_rectifier_potassium_current__g_Kr * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr; // microA_per_microF
        const double var_time_independent_potassium_current__g_K1 = 0.3227486121839514 * sqrt(var_ionic_concentrations__Ko); // milliS_per_cm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1020.0 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K)); // per_second
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = 1000.0 * (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_second
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // microA_per_microF
        const double var_transient_outward_current__g_to = 0; // milliS_per_microF
        const double var_transient_outward_current__rvdv = exp(0.01 * var_chaste_interface__membrane__V); // dimensionless
        const double var_transient_outward_current__i_to = pow(var_chaste_interface__transient_outward_current_zdv_gate__zdv, 3) * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_transient_outward_current__g_to * var_transient_outward_current__rvdv * var_chaste_interface__transient_outward_current_ydv_gate__ydv; // microA_per_microF
        const double var_chaste_interface__i_ionic = -(var_ATP_sensitive_potassium_current__i_K_ATP + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_exchanger__i_NaCa + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_non_specific_calcium_activated_current__i_ns_Ca + var_plateau_potassium_current__i_Kp + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_sarcolemmal_calcium_pump__i_p_Ca + var_slow_delayed_rectifier_potassium_current__i_Ks + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellviswanathan_model_1999_epiFromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time_converted, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -88.984
        double var_chaste_interface__calcium_dynamics__Cai = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 0.00035237
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.00079287
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.9938
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.99573
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 3.18355e-06
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.9974388
        double var_chaste_interface__T_type_Ca_channel_b_gate__b = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.000967785
        double var_chaste_interface__T_type_Ca_channel_g_gate__g = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.95331988
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.00032151644
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.0272635
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2 = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.0631269
        double var_chaste_interface__transient_outward_current_zdv_gate__zdv = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.011528
        double var_chaste_interface__transient_outward_current_ydv_gate__ydv = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.985232
        double var_chaste_interface__calcium_dynamics__Ca_JSR = NV_Ith_S(rY, 14);
        // Units: millimolar; Initial value: 0.817895
        double var_chaste_interface__calcium_dynamics__Ca_NSR = NV_Ith_S(rY, 15);
        // Units: millimolar; Initial value: 2.797668
        double var_chaste_interface__calcium_dynamics__APtrack = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 3.814e-87
        double var_chaste_interface__calcium_dynamics__APtrack2 = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 2.1084e-86
        double var_chaste_interface__calcium_dynamics__APtrack3 = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.01925
        double var_chaste_interface__calcium_dynamics__Cainfluxtrack = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 1.784e-87
        double var_chaste_interface__calcium_dynamics__OVRLDtrack = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__calcium_dynamics__OVRLDtrack2 = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__calcium_dynamics__OVRLDtrack3 = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ionic_concentrations__Nai = NV_Ith_S(rY, 23);
        // Units: millimolar; Initial value: 15.6748357
        double var_chaste_interface__ionic_concentrations__Ki = NV_Ith_S(rY, 24);
        // Units: millimolar; Initial value: 137.6244

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_ATP_sensitive_potassium_current__ATPi = 3.0; // millimolar
        const double var_ATP_sensitive_potassium_current__hATP = 2.0; // dimensionless
        const double var_ATP_sensitive_potassium_current__kATP = 0.00025000000000000001; // millimolar
        const double var_ATP_sensitive_potassium_current__nATP = 0.23999999999999999; // dimensionless
        const double var_ATP_sensitive_potassium_current__nicholsarea = 5.0000000000000002e-5; // dimensionless
        const double var_ATP_sensitive_potassium_current__g_K_ATP = 0.000193 / var_ATP_sensitive_potassium_current__nicholsarea; // milliS_per_microF
        const double var_ATP_sensitive_potassium_current__pATP = 1 / (1.0 + pow((var_ATP_sensitive_potassium_current__ATPi / var_ATP_sensitive_potassium_current__kATP), var_ATP_sensitive_potassium_current__hATP)); // dimensionless
        const double var_L_type_Ca_channel__P_Ca = 0.00054000000000000001; // cm_per_second
        const double var_L_type_Ca_channel__P_K = 1.9299999999999999e-7; // cm_per_second
        const double var_L_type_Ca_channel__P_Na = 6.75e-7; // cm_per_second
        const double var_L_type_Ca_channel__gamma_Cai = 1.0; // dimensionless
        const double var_L_type_Ca_channel__gamma_Cao = 0.34100000000000003; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ki = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Ko = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nai = 0.75; // dimensionless
        const double var_L_type_Ca_channel__gamma_Nao = 0.75; // dimensionless
        const double var_L_type_Ca_channel_f_Ca_gate__Km_Ca = 0.00059999999999999995; // millimolar
        const double var_Na_Ca_exchanger__K_NaCa = 0.002; // millimolar
        const double var_Na_Ca_exchanger__d_NaCa = 0.001; // millimolar
        const double var_Na_Ca_exchanger__gamma = 0.5; // dimensionless
        const double var_Na_Ca_exchanger__n_NaCa = 3.0; // dimensionless
        const double var_T_type_Ca_channel__g_CaT = 0.050000000000000003; // milliS_per_microF
        const double var_calcium_background_current__g_Cab = 0.003016; // milliS_per_microF
        const double var_calcium_dynamics__APtrack2_orig_deriv = (((var_chaste_interface__calcium_dynamics__APtrack > 0.17999999999999999) && (var_chaste_interface__calcium_dynamics__APtrack < 0.20000000000000001)) ? (100000.0 - 100500.0 * var_chaste_interface__calcium_dynamics__APtrack2) : (-500.0 * var_chaste_interface__calcium_dynamics__APtrack2)); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__APtrack2 = 0.001 * var_calcium_dynamics__APtrack2_orig_deriv; // 1 / millisecond
        const double var_calcium_dynamics__APtrack3_orig_deriv = (((var_chaste_interface__calcium_dynamics__APtrack > 0.17999999999999999) && (var_chaste_interface__calcium_dynamics__APtrack < 0.20000000000000001)) ? (100000.0 - 100500.0 * var_chaste_interface__calcium_dynamics__APtrack3) : (-10.0 * var_chaste_interface__calcium_dynamics__APtrack3)); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__APtrack3 = 0.001 * var_calcium_dynamics__APtrack3_orig_deriv; // 1 / millisecond
        const double var_calcium_dynamics__CMDN_max = 0.050000000000000003; // millimolar
        const double var_calcium_dynamics__CSQN_max = 10.0; // millimolar
        const double var_calcium_dynamics__CSQNthresh = 0.69999999999999996; // millimolar
        const double var_calcium_dynamics__Ca_NSR_max = 15.0; // millimolar
        const double var_L_type_Ca_channel_f_Ca_gate__f_Ca = 1 / (1.0 + var_chaste_interface__calcium_dynamics__Cai / var_L_type_Ca_channel_f_Ca_gate__Km_Ca); // dimensionless
        const double var_calcium_dynamics__Cao = 1.8; // millimolar
        const double var_calcium_dynamics__G_rel_max = 60000.0; // per_second
        const double var_calcium_dynamics__G_rel_overload = 4000.0; // per_second
        const double var_calcium_dynamics__I_up = 5.0; // millimolar_per_second
        const double var_calcium_dynamics__K_leak = var_calcium_dynamics__I_up / var_calcium_dynamics__Ca_NSR_max; // per_second
        const double var_calcium_dynamics__K_mCMDN = 0.0023800000000000002; // millimolar
        const double var_calcium_dynamics__K_mCSQN = 0.80000000000000004; // millimolar
        const double var_calcium_dynamics__K_mTn = 0.00050000000000000001; // millimolar
        const double var_calcium_dynamics__K_mrel = 0.00080000000000000004; // millimolar
        const double var_calcium_dynamics__K_mup = 0.00092000000000000003; // millimolar
        const double var_calcium_dynamics__Logicthresh = 0.97999999999999998; // dimensionless
        const double var_calcium_dynamics__OVRLDtrack2_orig_deriv = (((var_calcium_dynamics__Logicthresh > var_chaste_interface__calcium_dynamics__OVRLDtrack2) && (var_calcium_dynamics__Logicthresh < var_chaste_interface__calcium_dynamics__OVRLDtrack)) ? (50000.0 - 50000.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack2) : (-500.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack2)); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__OVRLDtrack2 = 0.001 * var_calcium_dynamics__OVRLDtrack2_orig_deriv; // 1 / millisecond
        const double var_calcium_dynamics__OVRLDtrack3_orig_deriv = (((var_calcium_dynamics__Logicthresh > var_chaste_interface__calcium_dynamics__OVRLDtrack3) && (var_calcium_dynamics__Logicthresh < var_chaste_interface__calcium_dynamics__OVRLDtrack)) ? (50000.0 - 50000.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack3) : (-10.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack3)); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__OVRLDtrack3 = 0.001 * var_calcium_dynamics__OVRLDtrack3_orig_deriv; // 1 / millisecond
        const double var_calcium_dynamics__OVRLDtrack_orig_deriv = (((var_chaste_interface__calcium_dynamics__APtrack3 < 0.37) && (var_chaste_interface__calcium_dynamics__OVRLDtrack3 < 0.37) && (var_calcium_dynamics__CSQNthresh < 1 / (1.0 + var_calcium_dynamics__K_mCSQN / var_chaste_interface__calcium_dynamics__Ca_JSR))) ? (50000.0 - 50000.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack) : (-500.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack)); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__OVRLDtrack = 0.001 * var_calcium_dynamics__OVRLDtrack_orig_deriv; // 1 / millisecond
        const double var_calcium_dynamics__Tn_max = 0.070000000000000007; // millimolar
        const double var_calcium_dynamics__delta_Ca_ith = 0.00018000000000000001; // millimolar
        const double var_calcium_dynamics__G_rel = ((var_chaste_interface__calcium_dynamics__Cainfluxtrack > var_calcium_dynamics__delta_Ca_ith) ? ((1.0 - var_chaste_interface__calcium_dynamics__APtrack2) * (-var_calcium_dynamics__delta_Ca_ith + var_chaste_interface__calcium_dynamics__Cainfluxtrack) * var_chaste_interface__calcium_dynamics__APtrack2 * var_calcium_dynamics__G_rel_max / (-var_calcium_dynamics__delta_Ca_ith + var_chaste_interface__calcium_dynamics__Cainfluxtrack + var_calcium_dynamics__K_mrel)) : ((var_chaste_interface__calcium_dynamics__OVRLDtrack2 > 0) ? ((1.0 - var_chaste_interface__calcium_dynamics__OVRLDtrack2) * var_calcium_dynamics__G_rel_overload * var_chaste_interface__calcium_dynamics__OVRLDtrack2) : (0))); // per_second
        const double var_calcium_dynamics__i_leak = var_chaste_interface__calcium_dynamics__Ca_NSR * var_calcium_dynamics__K_leak; // millimolar_per_second
        const double var_calcium_dynamics__i_rel = (-var_chaste_interface__calcium_dynamics__Cai + var_chaste_interface__calcium_dynamics__Ca_JSR) * var_calcium_dynamics__G_rel; // millimolar_per_second
        const double var_calcium_dynamics__i_up = var_chaste_interface__calcium_dynamics__Cai * var_calcium_dynamics__I_up / (var_chaste_interface__calcium_dynamics__Cai + var_calcium_dynamics__K_mup); // millimolar_per_second
        const double var_calcium_dynamics__tau_tr = 0.17999999999999999; // second
        const double var_calcium_dynamics__i_tr = (-var_chaste_interface__calcium_dynamics__Ca_JSR + var_chaste_interface__calcium_dynamics__Ca_NSR) / var_calcium_dynamics__tau_tr; // millimolar_per_second
        const double var_calcium_dynamics__Ca_JSR_orig_deriv = (-var_calcium_dynamics__i_rel + var_calcium_dynamics__i_tr) / (1.0 + var_calcium_dynamics__CSQN_max * var_calcium_dynamics__K_mCSQN / pow((var_chaste_interface__calcium_dynamics__Ca_JSR + var_calcium_dynamics__K_mCSQN), 2)); // millimolar / second
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_JSR = 0.001 * var_calcium_dynamics__Ca_JSR_orig_deriv; // millimolar / millisecond
        const double var_fast_sodium_current__g_Na = 16.0; // milliS_per_microF
        const double var_fast_sodium_current_m_gate__delta_m = 1.0000000000000001e-5; // dimensionless
        const double var_ionic_concentrations__A_cap = 1.434e-7; // mm2
        const double var_ionic_concentrations__Ko = 4.5; // millimolar
        const double var_ATP_sensitive_potassium_current__GKbaraATP = pow((0.25 * var_ionic_concentrations__Ko), var_ATP_sensitive_potassium_current__nATP) * var_ATP_sensitive_potassium_current__g_K_ATP * var_ATP_sensitive_potassium_current__pATP; // milliS_per_microF
        const double var_ionic_concentrations__Nao = 132.0; // millimolar
        const double var_ionic_concentrations__preplength = 0.001; // mm
        const double var_ionic_concentrations__radius = 0.00011; // mm
        const double var_ionic_concentrations__volume = M_PI * pow(var_ionic_concentrations__radius, 2) * var_ionic_concentrations__preplength; // micro_litre
        const double var_ionic_concentrations__V_myo = 0.68000000000000005 * var_ionic_concentrations__volume; // micro_litre
        const double var_calcium_dynamics__V_JSR = 0.0070588235294117632 * var_ionic_concentrations__V_myo; // micro_litre
        const double var_calcium_dynamics__V_NSR = 0.081176470588235281 * var_ionic_concentrations__V_myo; // micro_litre
        const double var_calcium_dynamics__Ca_NSR_orig_deriv = -var_calcium_dynamics__i_leak - var_calcium_dynamics__V_JSR * var_calcium_dynamics__i_tr / var_calcium_dynamics__V_NSR + var_calcium_dynamics__i_up; // millimolar / second
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_NSR = 0.001 * var_calcium_dynamics__Ca_NSR_orig_deriv; // millimolar / millisecond
        const double var_membrane__F = 96485.0; // coulomb_per_mole
        const double var_membrane__I_st_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2
        const double var_membrane__I_st = var_membrane__I_st_converted / HeartConfig::Instance()->GetCapacitance(); // microA_per_microF
        const double var_membrane__R = 8314.0; // joule_per_kilomole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_calcium_background_current__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Cao / var_chaste_interface__calcium_dynamics__Cai) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__E_Na = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Nao / var_chaste_interface__ionic_concentrations__Nai) / var_membrane__F; // millivolt
        const double var_L_type_Ca_channel__I_CaCa = 4.0 * pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Cao * var_calcium_dynamics__Cao + var_L_type_Ca_channel__gamma_Cai * var_chaste_interface__calcium_dynamics__Cai * exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Ca * var_chaste_interface__membrane__V / ((-1.0 + exp(2.0 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__I_CaK = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * var_ionic_concentrations__Ko + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_K * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__I_CaNa = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * var_ionic_concentrations__Nao + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_L_type_Ca_channel__P_Na * var_chaste_interface__membrane__V / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_L_type_Ca_channel__i_CaCa = var_L_type_Ca_channel__I_CaCa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_CaK = var_L_type_Ca_channel__I_CaK * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_CaNa = var_L_type_Ca_channel__I_CaNa * var_chaste_interface__L_type_Ca_channel_d_gate__d * var_L_type_Ca_channel_f_Ca_gate__f_Ca * var_chaste_interface__L_type_Ca_channel_f_gate__f; // microA_per_microF
        const double var_L_type_Ca_channel__i_Ca_L = var_L_type_Ca_channel__i_CaCa + var_L_type_Ca_channel__i_CaK + var_L_type_Ca_channel__i_CaNa; // microA_per_microF
        const double var_L_type_Ca_channel_d_gate__E0_d = 10.0 + var_chaste_interface__membrane__V; // millivolt
        const double var_L_type_Ca_channel_d_gate__d_infinity = 1 / (1.0 + exp(-0.16025641025641024 * var_L_type_Ca_channel_d_gate__E0_d)); // dimensionless
        const double var_L_type_Ca_channel_d_gate__tau_d = ((fabs(var_L_type_Ca_channel_d_gate__E0_d) < 1.0000000000000001e-5) ? (0.0045787545787545781) : (0.028571428571428571 * (1.0 - exp(-0.16025641025641024 * var_L_type_Ca_channel_d_gate__E0_d)) * var_L_type_Ca_channel_d_gate__d_infinity / var_L_type_Ca_channel_d_gate__E0_d)); // second
        const double var_L_type_Ca_channel_d_gate__alpha_d = var_L_type_Ca_channel_d_gate__d_infinity / var_L_type_Ca_channel_d_gate__tau_d; // per_second
        const double var_L_type_Ca_channel_d_gate__beta_d = (1.0 - var_L_type_Ca_channel_d_gate__d_infinity) / var_L_type_Ca_channel_d_gate__tau_d; // per_second
        const double var_L_type_Ca_channel_d_gate__d_orig_deriv = (1.0 - var_chaste_interface__L_type_Ca_channel_d_gate__d) * var_L_type_Ca_channel_d_gate__alpha_d - var_L_type_Ca_channel_d_gate__beta_d * var_chaste_interface__L_type_Ca_channel_d_gate__d; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d = 0.001 * var_L_type_Ca_channel_d_gate__d_orig_deriv; // 1 / millisecond
        const double var_L_type_Ca_channel_f_gate__f_infinity = 1 / (1.0 + exp(4.0 + 0.125 * var_chaste_interface__membrane__V)) + 0.59999999999999998 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_channel_f_gate__tau_f = 0.001 / (0.02 + 0.019699999999999999 * exp(-0.113569 * pow((1 + 0.10000000000000001 * var_chaste_interface__membrane__V), 2))); // second
        const double var_L_type_Ca_channel_f_gate__alpha_f = var_L_type_Ca_channel_f_gate__f_infinity / var_L_type_Ca_channel_f_gate__tau_f; // per_second
        const double var_L_type_Ca_channel_f_gate__beta_f = (1.0 - var_L_type_Ca_channel_f_gate__f_infinity) / var_L_type_Ca_channel_f_gate__tau_f; // per_second
        const double var_L_type_Ca_channel_f_gate__f_orig_deriv = (1.0 - var_chaste_interface__L_type_Ca_channel_f_gate__f) * var_L_type_Ca_channel_f_gate__alpha_f - var_L_type_Ca_channel_f_gate__beta_f * var_chaste_interface__L_type_Ca_channel_f_gate__f; // 1 / second
        const double d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f = 0.001 * var_L_type_Ca_channel_f_gate__f_orig_deriv; // 1 / millisecond
        const double var_Na_Ca_exchanger__i_NaCa = (pow(var_chaste_interface__ionic_concentrations__Nai, var_Na_Ca_exchanger__n_NaCa) * var_calcium_dynamics__Cao * exp((-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_Na_Ca_exchanger__gamma * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) - pow(var_ionic_concentrations__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__calcium_dynamics__Cai * exp((-1.0 + var_Na_Ca_exchanger__gamma) * (-2.0 + var_Na_Ca_exchanger__n_NaCa) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_Na_Ca_exchanger__K_NaCa / ((1.0 + 144.92753623188406 * var_chaste_interface__calcium_dynamics__Cai) * (1.0 + (pow(var_chaste_interface__ionic_concentrations__Nai, var_Na_Ca_exchanger__n_NaCa) * var_calcium_dynamics__Cao + pow(var_ionic_concentrations__Nao, var_Na_Ca_exchanger__n_NaCa) * var_chaste_interface__calcium_dynamics__Cai) * var_Na_Ca_exchanger__d_NaCa)); // microA_per_microF
        const double var_T_type_Ca_channel__i_Ca_T = pow(var_chaste_interface__T_type_Ca_channel_b_gate__b, 2) * (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_T_type_Ca_channel__g_CaT * var_chaste_interface__T_type_Ca_channel_g_gate__g; // microA_per_microF
        const double var_T_type_Ca_channel_b_gate__b_inf = 1 / (1.0 + exp(-1.2962962962962963 - 0.092592592592592587 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_b_gate__tau_b = 0.0037000000000000002 + 0.0061000000000000004 / (1.0 + exp(5.5555555555555554 + 0.22222222222222221 * var_chaste_interface__membrane__V)); // second
        const double var_T_type_Ca_channel_b_gate__b_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_b_gate__b + var_T_type_Ca_channel_b_gate__b_inf) / var_T_type_Ca_channel_b_gate__tau_b; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_b_gate__b = 0.001 * var_T_type_Ca_channel_b_gate__b_orig_deriv; // 1 / millisecond
        const double var_T_type_Ca_channel_g_gate__g_inf = 1 / (1.0 + exp(10.714285714285715 + 0.17857142857142858 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_T_type_Ca_channel_g_gate__tau_g = ((var_chaste_interface__membrane__V <= 0) ? (0.012 - 0.00087500000000000002 * var_chaste_interface__membrane__V) : (0.012)); // second
        const double var_T_type_Ca_channel_g_gate__g_orig_deriv = (-var_chaste_interface__T_type_Ca_channel_g_gate__g + var_T_type_Ca_channel_g_gate__g_inf) / var_T_type_Ca_channel_g_gate__tau_g; // 1 / second
        const double d_dt_chaste_interface_var_T_type_Ca_channel_g_gate__g = 0.001 * var_T_type_Ca_channel_g_gate__g_orig_deriv; // 1 / millisecond
        const double var_calcium_background_current__i_Ca_b = (-var_calcium_background_current__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_Cab; // microA_per_microF
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_fast_sodium_current__g_Na * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // microA_per_microF
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (135.0 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0)); // per_second
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (3560.0 * exp(0.079000000000000001 * var_chaste_interface__membrane__V) + 310000000.0 * exp(0.34999999999999998 * var_chaste_interface__membrane__V)) : (7692.3076923076933 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)))); // per_second
        const double var_fast_sodium_current_h_gate__h_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_h_gate__h) * var_fast_sodium_current_h_gate__alpha_h - var_fast_sodium_current_h_gate__beta_h * var_chaste_interface__fast_sodium_current_h_gate__h; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = 0.001 * var_fast_sodium_current_h_gate__h_orig_deriv; // 1 / millisecond
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? (1000.0 * (37.780000000000001 + var_chaste_interface__membrane__V) * (-127140.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 3.4740000000000003e-5 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))) : (0)); // per_second
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (121.2 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (300.0 * exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)))); // per_second
        const double var_fast_sodium_current_j_gate__j_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_j_gate__j) * var_fast_sodium_current_j_gate__alpha_j - var_fast_sodium_current_j_gate__beta_j * var_chaste_interface__fast_sodium_current_j_gate__j; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_j_gate__j = 0.001 * var_fast_sodium_current_j_gate__j_orig_deriv; // 1 / millisecond
        const double var_fast_sodium_current_m_gate__E0_m = 47.130000000000003 + var_chaste_interface__membrane__V; // millivolt
        const double var_fast_sodium_current_m_gate__alpha_m = ((var_fast_sodium_current_m_gate__delta_m <= fabs(var_fast_sodium_current_m_gate__E0_m)) ? (320.0 * var_fast_sodium_current_m_gate__E0_m / (1.0 - exp(-0.10000000000000001 * var_fast_sodium_current_m_gate__E0_m))) : (3200.0)); // per_second
        const double var_fast_sodium_current_m_gate__beta_m = 80.0 * exp(-0.090909090909090912 * var_chaste_interface__membrane__V); // per_second
        const double var_fast_sodium_current_m_gate__m_orig_deriv = (1.0 - var_chaste_interface__fast_sodium_current_m_gate__m) * var_fast_sodium_current_m_gate__alpha_m - var_fast_sodium_current_m_gate__beta_m * var_chaste_interface__fast_sodium_current_m_gate__m; // 1 / second
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = 0.001 * var_fast_sodium_current_m_gate__m_orig_deriv; // 1 / millisecond
        const double var_non_specific_calcium_activated_current__K_m_ns_Ca = 0.0011999999999999999; // millimolar
        const double var_non_specific_calcium_activated_current__P_ns_Ca = 0; // cm_per_second
        const double var_non_specific_calcium_activated_current__I_ns_K = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Ko * var_ionic_concentrations__Ko + var_L_type_Ca_channel__gamma_Ki * var_chaste_interface__ionic_concentrations__Ki * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_chaste_interface__membrane__V * var_non_specific_calcium_activated_current__P_ns_Ca / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_non_specific_calcium_activated_current__I_ns_Na = pow(var_membrane__F, 2) * (-var_L_type_Ca_channel__gamma_Nao * var_ionic_concentrations__Nao + var_L_type_Ca_channel__gamma_Nai * var_chaste_interface__ionic_concentrations__Nai * exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_chaste_interface__membrane__V * var_non_specific_calcium_activated_current__P_ns_Ca / ((-1.0 + exp(var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_K = var_non_specific_calcium_activated_current__I_ns_K / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_dynamics__Cai, 3)); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_Na = var_non_specific_calcium_activated_current__I_ns_Na / (1.0 + pow(var_non_specific_calcium_activated_current__K_m_ns_Ca, 3) / pow(var_chaste_interface__calcium_dynamics__Cai, 3)); // microA_per_microF
        const double var_non_specific_calcium_activated_current__i_ns_Ca = var_non_specific_calcium_activated_current__i_ns_K + var_non_specific_calcium_activated_current__i_ns_Na; // microA_per_microF
        const double var_plateau_potassium_current__Kp = 1 / (1.0 + exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_plateau_potassium_current__g_Kp = 0.0055199999999999997; // milliS_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__Rect = 1 / (1.0 + exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_delayed_rectifier_potassium_current__g_Kr = 0.011248864963317985 * sqrt(var_ionic_concentrations__Ko); // milliS_per_microF
        const double var_rapid_delayed_rectifier_potassium_current_xr_gate__tau_xr = 0.001 / (0.00060999999999999997 * (38.899999999999999 + var_chaste_interface__membrane__V) / (-1.0 + exp(5.6404999999999994 + 0.14499999999999999 * var_chaste_interface__membrane__V)) + 0.0013799999999999999 * (14.199999999999999 + var_chaste_interface__membrane__V) / (1.0 - exp(-1.7465999999999999 - 0.123 * var_chaste_interface__membrane__V))); // second
        const double var_rapid_delayed_rectifier_potassium_current_xr_gate__xr_infinity = 1 / (1.0 + exp(-2.8666666666666667 - 0.13333333333333333 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_delayed_rectifier_potassium_current_xr_gate__xr_orig_deriv = (-var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr + var_rapid_delayed_rectifier_potassium_current_xr_gate__xr_infinity) / var_rapid_delayed_rectifier_potassium_current_xr_gate__tau_xr; // 1 / second
        const double d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current_xr_gate__xr = 0.001 * var_rapid_delayed_rectifier_potassium_current_xr_gate__xr_orig_deriv; // 1 / millisecond
        const double var_sarcolemmal_calcium_pump__I_pCa = 1.1499999999999999; // microA_per_microF
        const double var_sarcolemmal_calcium_pump__K_mpCa = 0.00050000000000000001; // millimolar
        const double var_sarcolemmal_calcium_pump__i_p_Ca = var_chaste_interface__calcium_dynamics__Cai * var_sarcolemmal_calcium_pump__I_pCa / (var_chaste_interface__calcium_dynamics__Cai + var_sarcolemmal_calcium_pump__K_mpCa); // microA_per_microF
        const double var_calcium_dynamics__Cai_orig_deriv = ((-var_calcium_dynamics__i_up + var_calcium_dynamics__i_leak) * var_calcium_dynamics__V_NSR / var_ionic_concentrations__V_myo + var_calcium_dynamics__V_JSR * var_calcium_dynamics__i_rel / var_ionic_concentrations__V_myo - 0.5 * (-var_Na_Ca_exchanger__i_NaCa + var_L_type_Ca_channel__i_CaCa + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_Ca_b + var_sarcolemmal_calcium_pump__i_p_Ca) * var_ionic_concentrations__A_cap / (var_ionic_concentrations__V_myo * var_membrane__F)) / (1.0 + var_calcium_dynamics__CMDN_max * var_calcium_dynamics__K_mCMDN / pow((var_chaste_interface__calcium_dynamics__Cai + var_calcium_dynamics__K_mCMDN), 2) + var_calcium_dynamics__K_mTn * var_calcium_dynamics__Tn_max / pow((var_chaste_interface__calcium_dynamics__Cai + var_calcium_dynamics__K_mTn), 2)); // millimolar / second
        const double d_dt_chaste_interface_var_calcium_dynamics__Cai = 0.001 * var_calcium_dynamics__Cai_orig_deriv; // millimolar / millisecond
        const double var_calcium_dynamics__Cainfluxtrack_orig_deriv = ((var_chaste_interface__calcium_dynamics__APtrack > 0.20000000000000001) ? (-0.5 * (-var_Na_Ca_exchanger__i_NaCa + var_L_type_Ca_channel__i_CaCa + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_Ca_b + var_sarcolemmal_calcium_pump__i_p_Ca) * var_ionic_concentrations__A_cap / (var_ionic_concentrations__V_myo * var_membrane__F)) : ((var_chaste_interface__calcium_dynamics__APtrack2 > 0.01) ? (0) : (-500.0 * var_chaste_interface__calcium_dynamics__Cainfluxtrack))); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__Cainfluxtrack = 0.001 * var_calcium_dynamics__Cainfluxtrack_orig_deriv; // 1 / millisecond
        const double var_slow_delayed_rectifier_potassium_current__PNaK = 0.018329999999999999; // dimensionless
        const double var_slow_delayed_rectifier_potassium_current__E_Ks = var_membrane__R * var_membrane__T * log((var_ionic_concentrations__Nao * var_slow_delayed_rectifier_potassium_current__PNaK + var_ionic_concentrations__Ko) / (var_chaste_interface__ionic_concentrations__Nai * var_slow_delayed_rectifier_potassium_current__PNaK + var_chaste_interface__ionic_concentrations__Ki)) / var_membrane__F; // millivolt
        const double var_slow_delayed_rectifier_potassium_current__g_Ks = 0.433 + 0.25979999999999998 / (1.0 + 6.4818210260626455e-7 * pow(1 / var_chaste_interface__calcium_dynamics__Cai, 1.3999999999999999)); // milliS_per_microF
        const double var_slow_delayed_rectifier_potassium_current_xs1_gate__tau_xs1 = 0.001 / (0.00013100000000000001 * (30.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__membrane__V)) + 7.1899999999999999e-5 * (30.0 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__membrane__V))); // second
        const double var_slow_delayed_rectifier_potassium_current_xs1_gate__xs1_infinity = 1 / (1.0 + exp(0.089820359281437126 - 0.059880239520958084 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_delayed_rectifier_potassium_current_xs1_gate__xs1_orig_deriv = (-var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 + var_slow_delayed_rectifier_potassium_current_xs1_gate__xs1_infinity) / var_slow_delayed_rectifier_potassium_current_xs1_gate__tau_xs1; // 1 / second
        const double d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current_xs1_gate__xs1 = 0.001 * var_slow_delayed_rectifier_potassium_current_xs1_gate__xs1_orig_deriv; // 1 / millisecond
        const double var_slow_delayed_rectifier_potassium_current_xs2_gate__tau_xs2 = 0.0040000000000000001 / (0.00013100000000000001 * (30.0 + var_chaste_interface__membrane__V) / (-1.0 + exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__membrane__V)) + 7.1899999999999999e-5 * (30.0 + var_chaste_interface__membrane__V) / (1.0 - exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__membrane__V))); // second
        const double var_slow_delayed_rectifier_potassium_current__i_Ks = (-var_slow_delayed_rectifier_potassium_current__E_Ks + var_chaste_interface__membrane__V) * var_slow_delayed_rectifier_potassium_current__g_Ks * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2; // microA_per_microF
        const double var_slow_delayed_rectifier_potassium_current_xs2_gate__xs2_infinity = 1 / (1.0 + exp(0.089820359281437126 - 0.059880239520958084 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_delayed_rectifier_potassium_current_xs2_gate__xs2_orig_deriv = (-var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2 + var_slow_delayed_rectifier_potassium_current_xs2_gate__xs2_infinity) / var_slow_delayed_rectifier_potassium_current_xs2_gate__tau_xs2; // 1 / second
        const double d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current_xs2_gate__xs2 = 0.001 * var_slow_delayed_rectifier_potassium_current_xs2_gate__xs2_orig_deriv; // 1 / millisecond
        const double var_sodium_background_current__g_Nab = 0.0040000000000000001; // milliS_per_microF
        const double var_sodium_background_current__i_Na_b = (-var_fast_sodium_current__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_Nab; // microA_per_microF
        const double var_sodium_potassium_pump__I_NaK = 2.0; // microA_per_microF
        const double var_sodium_potassium_pump__K_mKo = 1.5; // millimolar
        const double var_sodium_potassium_pump__K_mNai = 10.0; // millimolar
        const double var_sodium_potassium_pump__sigma = -0.14285714285714285 + 0.14285714285714285 * exp(0.01485884101040119 * var_ionic_concentrations__Nao); // dimensionless
        const double var_sodium_potassium_pump__f_NaK = 1 / (1.0 + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.036499999999999998 * var_sodium_potassium_pump__sigma * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))); // dimensionless
        const double var_sodium_potassium_pump__i_NaK = var_ionic_concentrations__Ko * var_sodium_potassium_pump__I_NaK * var_sodium_potassium_pump__f_NaK / ((1.0 + pow(var_sodium_potassium_pump__K_mNai, 2) / pow(var_chaste_interface__ionic_concentrations__Nai, 2)) * (var_ionic_concentrations__Ko + var_sodium_potassium_pump__K_mKo)); // microA_per_microF
        const double var_ionic_concentrations__Nai_orig_deriv = (-var_L_type_Ca_channel__i_CaNa - var_fast_sodium_current__i_Na - var_non_specific_calcium_activated_current__i_ns_Na - var_sodium_background_current__i_Na_b - 3.0 * var_Na_Ca_exchanger__i_NaCa - 3.0 * var_sodium_potassium_pump__i_NaK) * var_ionic_concentrations__A_cap / (var_ionic_concentrations__V_myo * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_ionic_concentrations__Nai = 0.001 * var_ionic_concentrations__Nai_orig_deriv; // millimolar / millisecond
        const double var_time_independent_potassium_current__E_K = var_membrane__R * var_membrane__T * log(var_ionic_concentrations__Ko / var_chaste_interface__ionic_concentrations__Ki) / var_membrane__F; // millivolt
        const double var_ATP_sensitive_potassium_current__i_K_ATP = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_ATP_sensitive_potassium_current__GKbaraATP; // microA_per_microF
        const double var_plateau_potassium_current__i_Kp = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_plateau_potassium_current__Kp * var_plateau_potassium_current__g_Kp; // microA_per_microF
        const double var_rapid_delayed_rectifier_potassium_current__i_Kr = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_rapid_delayed_rectifier_potassium_current__Rect * var_rapid_delayed_rectifier_potassium_current__g_Kr * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr; // microA_per_microF
        const double var_time_independent_potassium_current__g_K1 = 0.3227486121839514 * sqrt(var_ionic_concentrations__Ko); // milliS_per_cm2
        const double var_time_independent_potassium_current_K1_gate__alpha_K1 = 1020.0 / (1.0 + exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 0.23849999999999999 * var_time_independent_potassium_current__E_K)); // per_second
        const double var_time_independent_potassium_current_K1_gate__beta_K1 = 1000.0 * (0.49124000000000001 * exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 0.080320000000000003 * var_time_independent_potassium_current__E_K) + exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 0.061749999999999999 * var_time_independent_potassium_current__E_K)) / (1.0 + exp(-2.4444678999999998 + 0.51429999999999998 * var_time_independent_potassium_current__E_K - 0.51429999999999998 * var_chaste_interface__membrane__V)); // per_second
        const double var_time_independent_potassium_current_K1_gate__K1_infinity = var_time_independent_potassium_current_K1_gate__alpha_K1 / (var_time_independent_potassium_current_K1_gate__alpha_K1 + var_time_independent_potassium_current_K1_gate__beta_K1); // dimensionless
        const double var_time_independent_potassium_current__i_K1 = (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_time_independent_potassium_current__g_K1 * var_time_independent_potassium_current_K1_gate__K1_infinity; // microA_per_microF
        const double var_transient_outward_current__g_to = 0; // milliS_per_microF
        const double var_transient_outward_current__rvdv = exp(0.01 * var_chaste_interface__membrane__V); // dimensionless
        const double var_transient_outward_current_ydv_gate__alpha_ydv = 15.0 / (1.0 + exp(12.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // per_second
        const double var_transient_outward_current_ydv_gate__beta_ydv = 100.0 * exp(5.0 + 0.20000000000000001 * var_chaste_interface__membrane__V) / (1.0 + exp(5.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // per_second
        const double var_transient_outward_current_ydv_gate__tau_ydv = 1 / (var_transient_outward_current_ydv_gate__alpha_ydv + var_transient_outward_current_ydv_gate__beta_ydv); // second
        const double var_transient_outward_current_ydv_gate__ydv_ss = var_transient_outward_current_ydv_gate__alpha_ydv / (var_transient_outward_current_ydv_gate__alpha_ydv + var_transient_outward_current_ydv_gate__beta_ydv); // dimensionless
        const double var_transient_outward_current_ydv_gate__ydv_orig_deriv = (-var_chaste_interface__transient_outward_current_ydv_gate__ydv + var_transient_outward_current_ydv_gate__ydv_ss) / var_transient_outward_current_ydv_gate__tau_ydv; // 1 / second
        const double d_dt_chaste_interface_var_transient_outward_current_ydv_gate__ydv = 0.001 * var_transient_outward_current_ydv_gate__ydv_orig_deriv; // 1 / millisecond
        const double var_transient_outward_current_zdv_gate__alpha_zdv = 10000.0 * exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__membrane__V) / (1.0 + exp(-1.6000000000000001 + 0.040000000000000001 * var_chaste_interface__membrane__V)); // per_second
        const double var_transient_outward_current_zdv_gate__beta_zdv = 10000.0 * exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.6000000000000001 - 0.040000000000000001 * var_chaste_interface__membrane__V)); // per_second
        const double var_transient_outward_current_zdv_gate__tau_zdv = 1 / (var_transient_outward_current_zdv_gate__alpha_zdv + var_transient_outward_current_zdv_gate__beta_zdv); // second
        const double var_transient_outward_current__i_to = pow(var_chaste_interface__transient_outward_current_zdv_gate__zdv, 3) * (-var_time_independent_potassium_current__E_K + var_chaste_interface__membrane__V) * var_transient_outward_current__g_to * var_transient_outward_current__rvdv * var_chaste_interface__transient_outward_current_ydv_gate__ydv; // microA_per_microF
        const double var_ionic_concentrations__Ki_orig_deriv = (-var_ATP_sensitive_potassium_current__i_K_ATP - var_L_type_Ca_channel__i_CaK - var_non_specific_calcium_activated_current__i_ns_K - var_plateau_potassium_current__i_Kp - var_rapid_delayed_rectifier_potassium_current__i_Kr - var_slow_delayed_rectifier_potassium_current__i_Ks - var_time_independent_potassium_current__i_K1 - var_transient_outward_current__i_to + 2.0 * var_sodium_potassium_pump__i_NaK) * var_ionic_concentrations__A_cap / (var_ionic_concentrations__V_myo * var_membrane__F); // millimolar / second
        const double d_dt_chaste_interface_var_ionic_concentrations__Ki = 0.001 * var_ionic_concentrations__Ki_orig_deriv; // millimolar / millisecond
        const double var_membrane__dVdt = -1.0 * (var_ATP_sensitive_potassium_current__i_K_ATP + var_L_type_Ca_channel__i_Ca_L + var_Na_Ca_exchanger__i_NaCa + var_T_type_Ca_channel__i_Ca_T + var_calcium_background_current__i_Ca_b + var_fast_sodium_current__i_Na + var_membrane__I_st + var_non_specific_calcium_activated_current__i_ns_Ca + var_plateau_potassium_current__i_Kp + var_rapid_delayed_rectifier_potassium_current__i_Kr + var_sarcolemmal_calcium_pump__i_p_Ca + var_slow_delayed_rectifier_potassium_current__i_Ks + var_sodium_background_current__i_Na_b + var_sodium_potassium_pump__i_NaK + var_time_independent_potassium_current__i_K1 + var_transient_outward_current__i_to) / NV_Ith_S(mParameters, 0); // dimensionless
        const double var_calcium_dynamics__APtrack_orig_deriv = ((var_membrane__dVdt > 150000.0) ? (100000.0 - 100500.0 * var_chaste_interface__calcium_dynamics__APtrack) : (-500.0 * var_chaste_interface__calcium_dynamics__APtrack)); // 1 / second
        const double d_dt_chaste_interface_var_calcium_dynamics__APtrack = 0.001 * var_calcium_dynamics__APtrack_orig_deriv; // 1 / millisecond
        const double var_transient_outward_current_zdv_gate__zdv_ss = var_transient_outward_current_zdv_gate__alpha_zdv / (var_transient_outward_current_zdv_gate__alpha_zdv + var_transient_outward_current_zdv_gate__beta_zdv); // dimensionless
        const double var_transient_outward_current_zdv_gate__zdv_orig_deriv = (-var_chaste_interface__transient_outward_current_zdv_gate__zdv + var_transient_outward_current_zdv_gate__zdv_ss) / var_transient_outward_current_zdv_gate__tau_zdv; // 1 / second
        const double d_dt_chaste_interface_var_transient_outward_current_zdv_gate__zdv = 0.001 * var_transient_outward_current_zdv_gate__zdv_orig_deriv; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            const double var_membrane__V_orig_deriv = var_membrane__dVdt; // millivolt / second
            d_dt_chaste_interface_var_membrane__V = 0.001 * var_membrane__V_orig_deriv; // millivolt / millisecond
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_calcium_dynamics__Cai;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_fast_sodium_current_j_gate__j;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_L_type_Ca_channel_d_gate__d;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_L_type_Ca_channel_f_gate__f;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_T_type_Ca_channel_b_gate__b;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_T_type_Ca_channel_g_gate__g;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_rapid_delayed_rectifier_potassium_current_xr_gate__xr;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current_xs1_gate__xs1;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_slow_delayed_rectifier_potassium_current_xs2_gate__xs2;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_transient_outward_current_zdv_gate__zdv;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_transient_outward_current_ydv_gate__ydv;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_calcium_dynamics__Ca_JSR;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_calcium_dynamics__Ca_NSR;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_calcium_dynamics__APtrack;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_calcium_dynamics__APtrack2;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_calcium_dynamics__APtrack3;
        NV_Ith_S(rDY,19) = d_dt_chaste_interface_var_calcium_dynamics__Cainfluxtrack;
        NV_Ith_S(rDY,20) = d_dt_chaste_interface_var_calcium_dynamics__OVRLDtrack;
        NV_Ith_S(rDY,21) = d_dt_chaste_interface_var_calcium_dynamics__OVRLDtrack2;
        NV_Ith_S(rDY,22) = d_dt_chaste_interface_var_calcium_dynamics__OVRLDtrack3;
        NV_Ith_S(rDY,23) = d_dt_chaste_interface_var_ionic_concentrations__Nai;
        NV_Ith_S(rDY,24) = d_dt_chaste_interface_var_ionic_concentrations__Ki;
    }

    void Cellviswanathan_model_1999_epiFromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__environment__time_converted, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -88.984
        double var_chaste_interface__calcium_dynamics__Cai = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 0.00035237
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.00079287
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.9938
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.99573
        double var_chaste_interface__L_type_Ca_channel_d_gate__d = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 3.18355e-06
        double var_chaste_interface__L_type_Ca_channel_f_gate__f = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.9974388
        double var_chaste_interface__T_type_Ca_channel_b_gate__b = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.000967785
        double var_chaste_interface__T_type_Ca_channel_g_gate__g = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 0.95331988
        double var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.00032151644
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.0272635
        double var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2 = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.0631269
        double var_chaste_interface__transient_outward_current_zdv_gate__zdv = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.011528
        double var_chaste_interface__transient_outward_current_ydv_gate__ydv = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 0.985232
        double var_chaste_interface__calcium_dynamics__Ca_JSR = NV_Ith_S(rY, 14);
        // Units: millimolar; Initial value: 0.817895
        double var_chaste_interface__calcium_dynamics__Ca_NSR = NV_Ith_S(rY, 15);
        // Units: millimolar; Initial value: 2.797668
        double var_chaste_interface__calcium_dynamics__APtrack = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 3.814e-87
        double var_chaste_interface__calcium_dynamics__APtrack2 = NV_Ith_S(rY, 17);
        // Units: dimensionless; Initial value: 2.1084e-86
        double var_chaste_interface__calcium_dynamics__APtrack3 = NV_Ith_S(rY, 18);
        // Units: dimensionless; Initial value: 0.01925
        double var_chaste_interface__calcium_dynamics__Cainfluxtrack = NV_Ith_S(rY, 19);
        // Units: dimensionless; Initial value: 1.784e-87
        double var_chaste_interface__calcium_dynamics__OVRLDtrack = NV_Ith_S(rY, 20);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__calcium_dynamics__OVRLDtrack2 = NV_Ith_S(rY, 21);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__calcium_dynamics__OVRLDtrack3 = NV_Ith_S(rY, 22);
        // Units: dimensionless; Initial value: 0.0
        double var_chaste_interface__ionic_concentrations__Nai = NV_Ith_S(rY, 23);
        // Units: millimolar; Initial value: 15.6748357
        double var_chaste_interface__ionic_concentrations__Ki = NV_Ith_S(rY, 24);
        // Units: millimolar; Initial value: 137.6244
        
        const double var_x0 = exp(1.2521739130434781 - 0.16722408026755853 * var_chaste_interface__membrane__V);
        const double var_x1 = 1.0 + var_x0;
        const double var_x2 = 1 / var_x1;
        const double var_x3 = 0.0055199999999999997 * var_x2;
        const double var_x4 = 1 / var_chaste_interface__ionic_concentrations__Ki;
        const double var_x5 = log(4.5 * var_x4);
        const double var_x6 = exp(-14.1227775 + 0.23849999999999999 * var_chaste_interface__membrane__V - 6.3708927812613361 * var_x5);
        const double var_x7 = 1.0 + var_x6;
        const double var_x8 = 1 / var_x7;
        const double var_x9 = exp(-2.4444678999999998 + 13.738155796237757 * var_x5 - 0.51429999999999998 * var_chaste_interface__membrane__V);
        const double var_x10 = 1.0 + var_x9;
        const double var_x11 = 1 / var_x10;
        const double var_x12 = exp(0.43983232 + 0.080320000000000003 * var_chaste_interface__membrane__V - 2.1455350448256207 * var_x5);
        const double var_x13 = exp(-36.698642499999998 + 0.061749999999999999 * var_chaste_interface__membrane__V - 1.6494869150645177 * var_x5);
        const double var_x14 = var_x13 + 0.49124000000000001 * var_x12;
        const double var_x15 = var_x11 * var_x14;
        const double var_x16 = 1 / (1000.0 * var_x15 + 1020.0 * var_x8);
        const double var_x17 = var_x16 * var_x8;
        const double var_x18 = 698.34626081908675 * var_x17;
        const double var_x19 = exp(0.4017857142857143 + 0.044642857142857144 * var_chaste_interface__membrane__V);
        const double var_x20 = 1.0 + var_x19;
        const double var_x21 = 1 / var_x20;
        const double var_x22 = var_x21 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr;
        const double var_x23 = 0.023862446088641735 * var_x22;
        const double var_x24 = 1 / var_chaste_interface__calcium_dynamics__Cai;
        const double var_x25 = pow(var_x24, 1.3999999999999999);
        const double var_x26 = 1.0 + 6.4818210260626455e-7 * var_x25;
        const double var_x27 = 0.25979999999999998 / var_x26;
        const double var_x28 = 0.433 + var_x27;
        const double var_x29 = var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1 * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2;
        const double var_x30 = var_x28 * var_x29;
        const double var_x31 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
        const double var_x32 = var_x31 * var_chaste_interface__fast_sodium_current_j_gate__j;
        const double var_x33 = var_x32 * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x34 = 16.0 * var_x33;
        const double var_x35 = pow(var_chaste_interface__ionic_concentrations__Nai, (-2));
        const double var_x36 = 1 / (1.0 + 100.0 * var_x35);
        const double var_x37 = 1.5 * var_x36;
        const double var_x38 = exp(-0.003743588350780262 * var_chaste_interface__membrane__V);
        const double var_x39 = exp(1.961367013372957);
        const double var_x40 = 0.037435883507802616 * var_chaste_interface__membrane__V;
        const double var_x41 = exp(-var_x40);
        const double var_x42 = 1.0 + 0.1245 * var_x38 + 0.036499999999999998 * var_x41 * (-0.14285714285714285 + 0.14285714285714285 * var_x39);
        const double var_x43 = (0.00046607674967214262 * var_x38 + 0.037435883507802616 * var_x41 * (-0.0052142857142857138 + 0.0052142857142857138 * var_x39)) / pow(var_x42, 2);
        const double var_x44 = 0.018717941753901308 * var_chaste_interface__membrane__V;
        const double var_x45 = exp(-var_x44);
        const double var_x46 = var_x45 * var_chaste_interface__calcium_dynamics__Cai;
        const double var_x47 = pow(var_chaste_interface__ionic_concentrations__Nai, 3.0);
        const double var_x48 = exp(var_x44);
        const double var_x49 = var_x47 * var_x48;
        const double var_x50 = 43050.667059836887 * var_x46 + 0.033692295157022357 * var_x49;
        const double var_x51 = 1 / (1.0 + 144.92753623188406 * var_chaste_interface__calcium_dynamics__Cai);
        const double var_x52 = 1 / (1.0 + 2299.9679999999998 * var_chaste_interface__calcium_dynamics__Cai + 0.0018000000000000002 * var_x47);
        const double var_x53 = var_x51 * var_x52;
        const double var_x54 = 0.002 * var_x53;
        const double var_x55 = var_x50 * var_x54;
        const double var_x56 = -26.712338705498265 * var_x5 + var_chaste_interface__membrane__V;
        const double var_x57 = 0.00092307692307692295 * var_x0 * var_x56 / pow(var_x1, 2);
        const double var_x58 = var_x6 / pow(var_x7, 2);
        const double var_x59 = 1000.0 * var_x11;
        const double var_x60 = var_x14 * var_x9 / pow(var_x10, 2);
        const double var_x61 = 0.00067122862439358594 * var_x56 * var_x8 / pow((var_x8 + 0.98039215686274506 * var_x15), 2);
        const double var_x62 = var_x61 * (243.26999999999998 * var_x58 - 514.29999999999995 * var_x60 - var_x59 * (0.061749999999999999 * var_x13 + 0.039456396800000001 * var_x12));
        const double var_x63 = 0.0010652877718143633 * var_x19 * var_x56 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr / pow(var_x20, 2);
        const double var_x64 = var_x16 * var_x56;
        const double var_x65 = 166.55558320535218 * var_x58 * var_x64;
        const double var_x66 = exp(var_x40);
        const double var_x67 = -1.0 + var_x66;
        const double var_x68 = 1 / var_x67;
        const double var_x69 = 1 / (1.0 + 1666.6666666666667 * var_chaste_interface__calcium_dynamics__Cai);
        const double var_x70 = var_x69 * var_chaste_interface__L_type_Ca_channel_f_gate__f;
        const double var_x71 = var_x70 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
        const double var_x72 = var_x68 * var_x71;
        const double var_x73 = 0.75 * var_x66;
        const double var_x74 = -99.0 + var_x73 * var_chaste_interface__ionic_concentrations__Nai;
        const double var_x75 = 0.0024381008236689767 * var_x74;
        const double var_x76 = var_x72 * var_x75;
        const double var_x77 = -3.375 + var_x73 * var_chaste_interface__ionic_concentrations__Ki;
        const double var_x78 = 0.00069711623550831479 * var_x77;
        const double var_x79 = var_x72 * var_x78;
        const double var_x80 = var_x66 * var_x72 * var_chaste_interface__membrane__V;
        const double var_x81 = 6.8454343811362063e-5 * var_x80 * var_chaste_interface__ionic_concentrations__Nai;
        const double var_x82 = 1.9572871637915374e-5 * var_x80 * var_chaste_interface__ionic_concentrations__Ki;
        const double var_x83 = var_x71 * var_chaste_interface__membrane__V;
        const double var_x84 = var_x66 * var_x83 / pow(var_x67, 2);
        const double var_x85 = 2.6097162183887167e-5 * var_x77 * var_x84;
        const double var_x86 = 9.1272458415149417e-5 * var_x74 * var_x84;
        const double var_x87 = pow(var_chaste_interface__T_type_Ca_channel_b_gate__b, 2);
        const double var_x88 = var_x87 * var_chaste_interface__T_type_Ca_channel_g_gate__g;
        const double var_x89 = 0.050000000000000003 * var_x88;
        const double var_x90 = exp(0.074871767015605231 * var_chaste_interface__membrane__V);
        const double var_x91 = -1.0 + var_x90;
        const double var_x92 = 1 / var_x91;
        const double var_x93 = var_x90 * var_chaste_interface__calcium_dynamics__Cai;
        const double var_x94 = -0.61380000000000001 + var_x93;
        const double var_x95 = var_x92 * var_x94;
        const double var_x96 = 7.8019226357407252 * var_x95;
        const double var_x97 = var_x71 * var_x96;
        const double var_x98 = var_x83 * var_x92;
        const double var_x99 = var_x89 + var_x97 + 0.58414373385695628 * var_x93 * var_x98 - 0.58414373385695628 * var_x83 * var_x90 * var_x94 / pow(var_x91, 2);
        const double var_x100 = 1 / NV_Ith_S(mParameters, 0);
        const double var_x101 = 0.001 * var_x100;
        const double var_x102 = var_x45 * var_x53;
        const double var_x103 = 4599.9359999999997 * var_x102;
        const double var_x104 = 1.8 * var_x49 - 2299968.0 * var_x46;
        const double var_x105 = var_x104 * var_x52 / pow((0.0068999999999999999 + var_chaste_interface__calcium_dynamics__Cai), 2);
        const double var_x106 = 1.38e-5 * var_x105;
        const double var_x107 = var_x104 * var_x51 / pow((0.00043478865792915378 + 7.8261958427247687e-7 * var_x47 + var_chaste_interface__calcium_dynamics__Cai), 2);
        const double var_x108 = 8.6957731585830757e-7 * var_x107;
        const double var_x109 = 0.018329999999999999 * var_chaste_interface__ionic_concentrations__Nai + var_chaste_interface__ionic_concentrations__Ki;
        const double var_x110 = -26.712338705498265 * log(6.9195599999999997 / var_x109) + var_chaste_interface__membrane__V;
        const double var_x111 = 2.3575679435995052e-7 * var_x110 * var_x24 * var_x25 * var_x29 / pow(var_x26, 2);
        const double var_x112 = var_chaste_interface__L_type_Ca_channel_d_gate__d * var_chaste_interface__membrane__V;
        const double var_x113 = var_x112 * var_chaste_interface__L_type_Ca_channel_f_gate__f / pow((0.00059999999999999995 + var_chaste_interface__calcium_dynamics__Cai), 2);
        const double var_x114 = var_x113 * var_x68;
        const double var_x115 = 1.4628604942013857e-6 * var_x114 * var_x74;
        const double var_x116 = 4.1826974130498884e-7 * var_x114 * var_x77;
        const double var_x117 = 0.00050000000000000001 + var_chaste_interface__calcium_dynamics__Cai;
        const double var_x118 = 1.1499999999999999 / var_x117;
        const double var_x119 = pow(var_x117, (-2));
        const double var_x120 = var_x118 + 0.040282206767891383 * var_x24 + 7.8019226357407252 * var_x90 * var_x98 + 0.6678084676374566 * var_x24 * var_x88 - 1.1499999999999999 * var_x119 * var_chaste_interface__calcium_dynamics__Cai - 0.0046811535814444347 * var_x113 * var_x95;
        const double var_x121 = 1 / var_chaste_interface__ionic_concentrations__Nai;
        const double var_x122 = log(132.0 * var_x121);
        const double var_x123 = -26.712338705498265 * var_x122 + var_chaste_interface__membrane__V;
        const double var_x124 = var_x123 * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x125 = var_x124 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 2) * var_chaste_interface__fast_sodium_current_j_gate__j;
        const double var_x126 = var_x123 * var_x32;
        const double var_x127 = 0.016 * var_x100;
        const double var_x128 = var_x124 * var_x31;
        const double var_x129 = var_x70 * var_chaste_interface__membrane__V;
        const double var_x130 = var_x129 * var_x68;
        const double var_x131 = var_x112 * var_x69;
        const double var_x132 = var_x131 * var_x68;
        const double var_x133 = log(1.8 * var_x24);
        const double var_x134 = -13.356169352749133 * var_x133 + var_chaste_interface__membrane__V;
        const double var_x135 = var_x134 * var_chaste_interface__T_type_Ca_channel_b_gate__b * var_chaste_interface__T_type_Ca_channel_g_gate__g;
        const double var_x136 = var_x134 * var_x87;
        const double var_x137 = var_x21 * var_x56;
        const double var_x138 = 0.001 * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2;
        const double var_x139 = var_x100 * var_x110 * var_x28;
        const double var_x140 = 0.001 * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1;
        const double var_x141 = 0.10684935482199306 * var_x121;
        const double var_x142 = 1 / var_x42;
        const double var_x143 = var_x142 / (pow((0.01 + var_x35), 2) * pow(var_chaste_interface__ionic_concentrations__Nai, 3));
        const double var_x144 = pow(var_chaste_interface__ionic_concentrations__Nai, 2.0);
        const double var_x145 = var_x144 * var_x48 * var_x53;
        const double var_x146 = 0.010800000000000001 * var_x145;
        const double var_x147 = 427.39741928797224 * var_x121 * var_x33;
        const double var_x148 = var_x107 * var_x144;
        const double var_x149 = 2.0416447122894152e-12 * var_x148;
        const double var_x150 = (0.14451785951707913 * var_chaste_interface__ionic_concentrations__Ki + 0.0026490123649480601 * var_chaste_interface__ionic_concentrations__Nai) / pow(var_x109, 2);
        const double var_x151 = var_x150 * var_x30;
        const double var_x152 = 0.0018285756177517324 * var_x80;
        const double var_x153 = 7.3656881518639831e-7 * var_x4;
        const double var_x154 = 0.14745210965435041 * var_x2 * var_x4;
        const double var_x155 = 18654.461852717679 * var_x17 * var_x4;
        const double var_x156 = 0.63742174226149029 * var_x22 * var_x4;
        const double var_x157 = var_x4 * var_x58;
        const double var_x158 = var_x61 * (6498.310636886562 * var_x157 - var_x59 * (1.053972635420138 * var_x12 * var_x4 + 1.6494869150645177 * var_x13 * var_x4) - 13738.155796237757 * var_x4 * var_x60);
        const double var_x159 = 4449.089151873166 * var_x157 * var_x64;
        const double var_x160 = 0.00052283717663123607 * var_x80;
        const double var_x161 = 0.003016 + var_x99 - var_x55;
        const double var_x162 = 0.0023800000000000002 + var_chaste_interface__calcium_dynamics__Cai;
        const double var_x163 = 1.0 + 0.00011900000000000002 / pow(var_x162, 2) + 3.5000000000000004e-5 * var_x119;
        const double var_x164 = 1 / var_x163;
        const double var_x165 = 1 / M_PI;
        const double var_x166 = var_x164 * var_x165;
        const double var_x167 = 9.0316078310111333e-5 * var_x166;
        const double var_x168 = 0.00092000000000000003 + var_chaste_interface__calcium_dynamics__Cai;
        const double var_x169 = 1 / var_x168;
        const double var_x170 = 0.40588235294117642 * var_x169;
        const double var_x171 = 1.0 - var_chaste_interface__calcium_dynamics__APtrack2;
        const double var_x172 = 0.00062 + var_chaste_interface__calcium_dynamics__Cainfluxtrack;
        const double var_x173 = 1 / var_x172;
        const double var_x174 = -0.00018000000000000001 + var_chaste_interface__calcium_dynamics__Cainfluxtrack;
        const double var_x175 = 60000.0 * var_x173 * var_x174;
        const double var_x176 = var_x171 * var_x175;
        const double var_x177 = var_chaste_interface__calcium_dynamics__Cainfluxtrack > 0.00018000000000000001;
        const double var_x178 = var_chaste_interface__calcium_dynamics__OVRLDtrack2 > 0;
        const double var_x179 = ((var_x177) ? (var_x176 * var_chaste_interface__calcium_dynamics__APtrack2) : ((var_x178) ? (4000.0 * (1.0 - var_chaste_interface__calcium_dynamics__OVRLDtrack2) * var_chaste_interface__calcium_dynamics__OVRLDtrack2) : (0)));
        const double var_x180 = 0.0070588235294117632 * var_x179;
        const double var_x181 = var_chaste_interface__calcium_dynamics__Cai / pow(var_x168, 2);
        const double var_x182 = 0.090316078310111333 * var_x165;
        const double var_x183 = -var_x182 * (var_x103 + var_x106 + var_x108 + var_x120);
        const double var_x184 = 0.001 * var_x164;
        const double var_x185 = -var_chaste_interface__calcium_dynamics__Cai + var_chaste_interface__calcium_dynamics__Ca_JSR;
        const double var_x186 = var_x104 * var_x54;
        const double var_x187 = -0.040282206767891383 * var_x133 + var_x118 * var_chaste_interface__calcium_dynamics__Cai + var_x134 * var_x89 + var_x97 * var_chaste_interface__membrane__V;
        const double var_x188 = var_x129 * var_x95;
        const double var_x189 = 0.00070463905573898956 * var_x166;
        const double var_x190 = var_x131 * var_x95;
        const double var_x191 = ((var_x177) ? (var_x176 - var_x175 * var_chaste_interface__calcium_dynamics__APtrack2) : (0));
        const double var_x192 = var_x184 * (0.0070588235294117632 * var_chaste_interface__calcium_dynamics__Ca_JSR - 0.0070588235294117632 * var_chaste_interface__calcium_dynamics__Cai);
        const double var_x193 = 60000.0 * var_x171 * var_chaste_interface__calcium_dynamics__APtrack2;
        const double var_x194 = ((var_x177) ? (var_x173 * var_x193 - var_x174 * var_x193 / pow(var_x172, 2)) : (0));
        const double var_x195 = ((var_x177) ? (0) : ((var_x178) ? (4000.0 - 8000.0 * var_chaste_interface__calcium_dynamics__OVRLDtrack2) : (0)));
        const double var_x196 = var_x149 - var_x146;
        const double var_x197 = -0.10000000000000001 * var_chaste_interface__membrane__V;
        const double var_x198 = exp(-4.7130000000000001 + var_x197);
        const double var_x199 = 1.0 - var_x198;
        const double var_x200 = 320.0 / var_x199;
        const double var_x201 = 47.130000000000003 + var_chaste_interface__membrane__V;
        const double var_x202 = fabs(var_x201) >= 1.0000000000000001e-5;
        const double var_x203 = exp(-0.090909090909090912 * var_chaste_interface__membrane__V);
        const double var_x204 = 0.001 * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x205 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V);
        const double var_x206 = var_chaste_interface__membrane__V < -40.0;
        const double var_x207 = exp(0.079000000000000001 * var_chaste_interface__membrane__V);
        const double var_x208 = exp(0.34999999999999998 * var_chaste_interface__membrane__V);
        const double var_x209 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V);
        const double var_x210 = 1.0 + var_x209;
        const double var_x211 = 0.001 * var_chaste_interface__fast_sodium_current_j_gate__j;
        const double var_x212 = exp(0.24440000000000001 * var_chaste_interface__membrane__V);
        const double var_x213 = exp(-0.043909999999999998 * var_chaste_interface__membrane__V);
        const double var_x214 = -127140.0 * var_x212 - 3.4740000000000003e-5 * var_x213;
        const double var_x215 = exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V);
        const double var_x216 = 1.0 + var_x215;
        const double var_x217 = 1000.0 / var_x216;
        const double var_x218 = var_x214 * var_x217;
        const double var_x219 = 37.780000000000001 + var_chaste_interface__membrane__V;
        const double var_x220 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V);
        const double var_x221 = 1.0 + var_x220;
        const double var_x222 = exp(-0.01052 * var_chaste_interface__membrane__V);
        const double var_x223 = var_x222 / var_x221;
        const double var_x224 = exp(-3.2000000000000002 + var_x197);
        const double var_x225 = 1.0 + var_x224;
        const double var_x226 = exp(-2.5349999999999999e-7 * var_chaste_interface__membrane__V);
        const double var_x227 = var_x226 / var_x225;
        const double var_x228 = exp(-1.6025641025641024 - 0.16025641025641024 * var_chaste_interface__membrane__V);
        const double var_x229 = 1.0 + var_x228;
        const double var_x230 = 0.001 / var_x229;
        const double var_x231 = -0.001 + var_x230;
        const double var_x232 = 10.0 + var_chaste_interface__membrane__V;
        const double var_x233 = fabs(var_x232) < 1.0000000000000001e-5;
        const double var_x234 = 1.0 - var_x228;
        const double var_x235 = 1 / var_x234;
        const double var_x236 = 35.0 * var_x229 * var_x235;
        const double var_x237 = 5.6089743589743595 * var_x228 * var_x232;
        const double var_x238 = ((var_x233) ? (0) : (var_x236 - var_x235 * var_x237 - var_x229 * var_x237 / pow(var_x234, 2)));
        const double var_x239 = 1.0 - var_chaste_interface__L_type_Ca_channel_d_gate__d;
        const double var_x240 = ((var_x233) ? (218.40000000000003) : (var_x232 * var_x236));
        const double var_x241 = 0.00016025641025641026 * var_x228 * var_x240 / pow(var_x229, 2);
        const double var_x242 = exp(-0.113569 * pow((1 + 0.10000000000000001 * var_chaste_interface__membrane__V), 2));
        const double var_x243 = 19.699999999999999 * var_x242;
        const double var_x244 = 0.001 - 0.001 * var_chaste_interface__L_type_Ca_channel_f_gate__f;
        const double var_x245 = exp(2.5 - 0.050000000000000003 * var_chaste_interface__membrane__V);
        const double var_x246 = 1.0 + var_x245;
        const double var_x247 = 0.029999999999999999 * var_x245 / pow(var_x246, 2);
        const double var_x248 = exp(4.0 + 0.125 * var_chaste_interface__membrane__V);
        const double var_x249 = 1.0 + var_x248;
        const double var_x250 = 0.125 * var_x248 / pow(var_x249, 2);
        const double var_x251 = 0.019699999999999999 * var_x242;
        const double var_x252 = -0.02 - var_x251;
        const double var_x253 = 1 / var_x249;
        const double var_x254 = 0.59999999999999998 / var_x246;
        const double var_x255 = var_x253 + var_x254;
        const double var_x256 = -0.022713800000000003 - 0.0022713799999999999 * var_chaste_interface__membrane__V;
        const double var_x257 = 1.0 - var_x253 - var_x254;
        const double var_x258 = exp(-1.2962962962962963 - 0.092592592592592587 * var_chaste_interface__membrane__V);
        const double var_x259 = 1.0 + var_x258;
        const double var_x260 = exp(5.5555555555555554 + 0.22222222222222221 * var_chaste_interface__membrane__V);
        const double var_x261 = 1.0 + var_x260;
        const double var_x262 = 1 / var_x261;
        const double var_x263 = 1 / (0.0037000000000000002 + 0.0061000000000000004 * var_x262);
        const double var_x264 = exp(10.714285714285715 + 0.17857142857142858 * var_chaste_interface__membrane__V);
        const double var_x265 = 1.0 + var_x264;
        const double var_x266 = var_chaste_interface__membrane__V <= 0;
        const double var_x267 = ((var_x266) ? (1 / (0.012 - 0.00087500000000000002 * var_chaste_interface__membrane__V)) : (83.333333333333329));
        const double var_x268 = exp(-2.8666666666666667 - 0.13333333333333333 * var_chaste_interface__membrane__V);
        const double var_x269 = 1.0 + var_x268;
        const double var_x270 = exp(5.6404999999999994 + 0.14499999999999999 * var_chaste_interface__membrane__V);
        const double var_x271 = -1.0 + var_x270;
        const double var_x272 = 1 / var_x271;
        const double var_x273 = 0.60999999999999999 * var_x272;
        const double var_x274 = exp(-1.7465999999999999 - 0.123 * var_chaste_interface__membrane__V);
        const double var_x275 = 1.0 - var_x274;
        const double var_x276 = 1 / var_x275;
        const double var_x277 = 1.3799999999999999 * var_x276;
        const double var_x278 = 14.199999999999999 + var_chaste_interface__membrane__V;
        const double var_x279 = 38.899999999999999 + var_chaste_interface__membrane__V;
        const double var_x280 = exp(0.089820359281437126 - 0.059880239520958084 * var_chaste_interface__membrane__V);
        const double var_x281 = 1.0 + var_x280;
        const double var_x282 = 0.001 / var_x281;
        const double var_x283 = exp(2.0609999999999999 + 0.068699999999999997 * var_chaste_interface__membrane__V);
        const double var_x284 = -1.0 + var_x283;
        const double var_x285 = 1 / var_x284;
        const double var_x286 = 0.13100000000000001 * var_x285;
        const double var_x287 = exp(-4.4399999999999995 - 0.14799999999999999 * var_chaste_interface__membrane__V);
        const double var_x288 = 1.0 - var_x287;
        const double var_x289 = 1 / var_x288;
        const double var_x290 = 0.071899999999999992 * var_x289;
        const double var_x291 = 30.0 + var_chaste_interface__membrane__V;
        const double var_x292 = var_x283 * var_x291 / pow(var_x284, 2);
        const double var_x293 = var_x287 * var_x291 / pow(var_x288, 2);
        const double var_x294 = 5.9880239520958083e-5 * var_x280 / pow(var_x281, 2);
        const double var_x295 = var_x285 * var_x291;
        const double var_x296 = var_x289 * var_x291;
        const double var_x297 = 0.032750000000000001 * var_x285;
        const double var_x298 = 0.017974999999999998 * var_x289;
        const double var_x299 = 0.040000000000000001 * var_chaste_interface__membrane__V;
        const double var_x300 = exp(-1.6000000000000001 + var_x299);
        const double var_x301 = 1.0 + var_x300;
        const double var_x302 = var_x300 / var_x301;
        const double var_x303 = exp(-3.6000000000000001 - var_x299);
        const double var_x304 = 1.0 + var_x303;
        const double var_x305 = var_x303 / var_x304;
        const double var_x306 = 10000.0 * var_x302 + 10000.0 * var_x305;
        const double var_x307 = 1 / var_x306;
        const double var_x308 = 10.0 * var_x302;
        const double var_x309 = 400.0 * var_x302;
        const double var_x310 = 400.0 * pow(var_x303, 2) / pow(var_x304, 2);
        const double var_x311 = pow(var_x300, 2) / pow(var_x301, 2);
        const double var_x312 = 400.0 * var_x311;
        const double var_x313 = 400.0 * var_x305;
        const double var_x314 = 0.40000000000000002 * var_x307;
        const double var_x315 = 0.20000000000000001 * var_chaste_interface__membrane__V;
        const double var_x316 = exp(12.0 + var_x315);
        const double var_x317 = 1.0 + var_x316;
        const double var_x318 = 1 / var_x317;
        const double var_x319 = exp(5.0 + var_x315);
        const double var_x320 = 1.0 + var_x319;
        const double var_x321 = var_x319 / var_x320;
        const double var_x322 = 15.0 * var_x318 + 100.0 * var_x321;
        const double var_x323 = var_x316 / pow(var_x317, 2);
        const double var_x324 = 3.0 * var_x323;
        const double var_x325 = 20.0 * pow(var_x319, 2) / pow(var_x320, 2);
        const double var_x326 = 20.0 * var_x321;
        const double var_x327 = 1 / var_x322;
        const double var_x328 = 0.014999999999999999 * var_x318;
        const double var_x329 = 0.80000000000000004 + var_chaste_interface__calcium_dynamics__Ca_JSR;
        const double var_x330 = pow(var_x329, (-2));
        const double var_x331 = 1 / (1.0 + 8.0 * var_x330);
        const double var_x332 = 0.001 * var_x331;
        const double var_x333 = var_x332 * (-var_chaste_interface__calcium_dynamics__Ca_JSR + var_chaste_interface__calcium_dynamics__Cai);
        const double var_x334 = (var_chaste_interface__calcium_dynamics__APtrack > 0.17999999999999999) && (var_chaste_interface__calcium_dynamics__APtrack < 0.20000000000000001);
        const double var_x335 = var_chaste_interface__calcium_dynamics__APtrack > 0.20000000000000001;
        const double var_x336 = 0.70463905573898955 * var_x165;
        const double var_x337 = var_chaste_interface__calcium_dynamics__OVRLDtrack > 0.97999999999999998;
        const double var_x338 = var_x36 * var_x43;
        const double var_x339 = 0.00018063215662022267 * var_x165;
        const double var_x340 = 0.0028901145059235626 * var_x165;
        const double var_x341 = var_x130 * var_x165;
        const double var_x342 = 4.4039940983686847e-7 * var_x74;
        const double var_x343 = var_x132 * var_x165;
        const double var_x344 = -0.433 - var_x27;
        const double var_x345 = var_x29 * var_x344;
        const double var_x346 = 1.2592160903483795e-7 * var_x77;
        const double var_x347 = var_x110 * var_x339 * var_x344;
        const double var_x348 = var_x150 * var_x345;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x101 * (0.0070160275741043606 + var_x18 + var_x23 + var_x3 + var_x30 + var_x34 + var_x55 + var_x57 + var_x62 + var_x76 + var_x79 + var_x81 + var_x82 + var_x99 - var_x63 - var_x65 - var_x85 - var_x86 + var_x37 * var_x43));
        IJth(rJacobian, 1, 0) = -var_x161 * var_x167;
        IJth(rJacobian, 2, 0) = (0.001 - 0.001 * var_chaste_interface__fast_sodium_current_m_gate__m) * ((var_x202) ? (var_x200 - 32.0 * var_x198 * var_x201 / pow(var_x199, 2)) : (0)) + 0.0072727272727272727 * var_x203 * var_chaste_interface__fast_sodium_current_m_gate__m;
        IJth(rJacobian, 3, 0) = (0.001 - var_x204) * ((var_x206) ? (-19.852941176470587 * var_x205) : (0)) - var_x204 * ((var_x206) ? (281.24000000000001 * var_x207 + 108500000.0 * var_x208) : (693.0006930006931 * var_x209 / pow(var_x210, 2)));
        IJth(rJacobian, 4, 0) = (0.001 - var_x211) * ((var_x206) ? (var_x218 + var_x217 * var_x219 * (1.5254334000000001e-6 * var_x213 - 31073.016 * var_x212) - 311.0 * var_x214 * var_x215 * var_x219 / pow(var_x216, 2)) : (0)) - var_x211 * ((var_x206) ? (-1.2750239999999999 * var_x223 + 16.701360000000001 * var_x220 * var_x222 / pow(var_x221, 2)) : (-7.6049999999999992e-5 * var_x227 + 30.0 * var_x224 * var_x226 / pow(var_x225, 2)));
        IJth(rJacobian, 5, 0) = var_x239 * var_x241 + var_x241 * var_chaste_interface__L_type_Ca_channel_d_gate__d + var_x230 * var_x238 * var_x239 + var_x231 * var_x238 * var_chaste_interface__L_type_Ca_channel_d_gate__d;
        IJth(rJacobian, 6, 0) = var_x244 * (20.0 + var_x243) * (var_x247 - var_x250) + var_x252 * (var_x250 - var_x247) * var_chaste_interface__L_type_Ca_channel_f_gate__f + var_x243 * var_x244 * var_x255 * var_x256 - var_x251 * var_x256 * var_x257 * var_chaste_interface__L_type_Ca_channel_f_gate__f;
        IJth(rJacobian, 7, 0) = 9.2592592592592588e-5 * var_x258 * var_x263 / pow(var_x259, 2) + 0.036429872495446262 * var_x260 * (-var_chaste_interface__T_type_Ca_channel_b_gate__b + 1 / var_x259) / (pow(var_x261, 2) * pow((0.60655737704918034 + var_x262), 2));
        IJth(rJacobian, 8, 0) = (0.001 / var_x265 - 0.001 * var_chaste_interface__T_type_Ca_channel_g_gate__g) * ((var_x266) ? (6.0763888888888884 / pow((1 - 0.072916666666666671 * var_chaste_interface__membrane__V), 2)) : (0)) - 0.00017857142857142857 * var_x264 * var_x267 / pow(var_x265, 2);
        IJth(rJacobian, 9, 0) = (0.001 / var_x269 - 0.001 * var_chaste_interface__rapid_delayed_rectifier_potassium_current_xr_gate__xr) * (var_x273 + var_x277 - 0.16973999999999997 * var_x274 * var_x278 / pow(var_x275, 2) - 0.088449999999999987 * var_x270 * var_x279 / pow(var_x271, 2)) + 0.00013333333333333334 * var_x268 * (var_x273 * var_x279 + var_x277 * var_x278) / pow(var_x269, 2);
        IJth(rJacobian, 10, 0) = var_x294 * (var_x286 * var_x291 + var_x290 * var_x291) + (var_x282 - var_x140) * (var_x286 + var_x290 - 0.0089997000000000011 * var_x292 - 0.0106412 * var_x293);
        IJth(rJacobian, 11, 0) = var_x294 * (var_x291 * var_x297 + var_x291 * var_x298) + (var_x282 - var_x138) * (var_x297 + var_x298 - 0.0022499250000000003 * var_x292 - 0.0026603 * var_x293);
        IJth(rJacobian, 12, 0) = var_x306 * (var_x302 * var_x314 - var_x311 * var_x314 + 9.9999999999999995e-8 * var_x302 * (var_x312 + var_x313 - var_x309 - var_x310) / pow((var_x302 + var_x305), 2)) + (-0.001 * var_chaste_interface__transient_outward_current_zdv_gate__zdv + var_x307 * var_x308) * (var_x309 + var_x310 - var_x312 - var_x313);
        IJth(rJacobian, 13, 0) = var_x322 * (-0.0030000000000000001 * var_x323 * var_x327 + 1.5e-6 * var_x318 * (var_x324 + var_x325 - var_x326) / pow((var_x321 + 0.14999999999999999 * var_x318), 2)) + (-0.001 * var_chaste_interface__transient_outward_current_ydv_gate__ydv + var_x327 * var_x328) * (var_x326 - var_x324 - var_x325);
        IJth(rJacobian, 19, 0) = 0.001 * ((var_x335) ? (-var_x161 * var_x182) : (0));
        IJth(rJacobian, 23, 0) = var_x339 * (-0.0040000000000000001 + var_x86 - var_x34 - var_x76 - var_x81 - 4.5 * var_x338 - 0.0060000000000000001 * var_x50 * var_x53);
        IJth(rJacobian, 24, 0) = var_x339 * (-2.7574104360798206e-8 + var_x345 + var_x63 + var_x65 + var_x85 - var_x18 - var_x23 - var_x3 - var_x57 - var_x62 - var_x79 - var_x82 + 3.0 * var_x338);
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x101 * (var_x111 + var_x120 - var_x103 - var_x106 - var_x108 - var_x115 - var_x116));
        IJth(rJacobian, 1, 1) = var_x184 * (var_x183 - var_x170 - var_x180 + 0.40588235294117642 * var_x181) + 0.001 * (0.00023800000000000004 / pow(var_x162, 3) + 7.0000000000000007e-5 / pow(var_x117, 3)) * (0.027058823529411764 * var_chaste_interface__calcium_dynamics__Ca_NSR + var_x180 * var_x185 - var_x170 * var_chaste_interface__calcium_dynamics__Cai - var_x182 * (var_x187 - var_x186 + 0.003016 * var_chaste_interface__membrane__V)) / pow(var_x163, 2);
        IJth(rJacobian, 14, 1) = var_x179 * var_x332;
        IJth(rJacobian, 15, 1) = 0.0050000000000000001 * var_x169 - 0.0050000000000000001 * var_x181;
        IJth(rJacobian, 19, 1) = 0.001 * ((var_x335) ? (var_x183) : (0));
        IJth(rJacobian, 23, 1) = var_x339 * (var_x115 + 2.6087319475749228e-6 * var_x107 + 4.1400000000000003e-5 * var_x105 + 13799.808000000001 * var_x102);
        IJth(rJacobian, 24, 1) = var_x339 * (var_x116 - var_x111);
        IJth(rJacobian, 0, 2) = mSetVoltageDerivativeToZero ? 0.0 : (-0.048000000000000001 * var_x100 * var_x125);
        IJth(rJacobian, 2, 2) = -0.001 * ((var_x202) ? (var_x200 * var_x201) : (3200.0)) - 0.080000000000000002 * var_x203;
        IJth(rJacobian, 23, 2) = -0.0086703435177706879 * var_x125 * var_x165;
        IJth(rJacobian, 0, 3) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x126 * var_x127);
        IJth(rJacobian, 3, 3) = -0.001 * ((var_x206) ? (135.0 * var_x205) : (0)) - 0.001 * ((var_x206) ? (3560.0 * var_x207 + 310000000.0 * var_x208) : (7692.3076923076933 / var_x210));
        IJth(rJacobian, 23, 3) = -var_x126 * var_x340;
        IJth(rJacobian, 0, 4) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x127 * var_x128);
        IJth(rJacobian, 4, 4) = -0.001 * ((var_x206) ? (121.2 * var_x223) : (300.0 * var_x227)) - 0.001 * ((var_x206) ? (var_x218 * var_x219) : (0));
        IJth(rJacobian, 23, 4) = -var_x128 * var_x340;
        IJth(rJacobian, 0, 5) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x101 * (var_x129 * var_x96 + var_x130 * var_x75 + var_x130 * var_x78));
        IJth(rJacobian, 1, 5) = -var_x188 * var_x189;
        IJth(rJacobian, 5, 5) = var_x231 * var_x240 - var_x230 * var_x240;
        IJth(rJacobian, 19, 5) = 0.001 * ((var_x335) ? (-var_x188 * var_x336) : (0));
        IJth(rJacobian, 23, 5) = -var_x341 * var_x342;
        IJth(rJacobian, 24, 5) = -var_x341 * var_x346;
        IJth(rJacobian, 0, 6) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x101 * (var_x131 * var_x96 + var_x132 * var_x75 + var_x132 * var_x78));
        IJth(rJacobian, 1, 6) = -var_x189 * var_x190;
        IJth(rJacobian, 6, 6) = var_x252 * var_x255 + var_x252 * var_x257;
        IJth(rJacobian, 19, 6) = 0.001 * ((var_x335) ? (-var_x190 * var_x336) : (0));
        IJth(rJacobian, 23, 6) = -var_x342 * var_x343;
        IJth(rJacobian, 24, 6) = -var_x343 * var_x346;
        IJth(rJacobian, 0, 7) = mSetVoltageDerivativeToZero ? 0.0 : (-0.0001 * var_x100 * var_x135);
        IJth(rJacobian, 1, 7) = -9.0316078310111336e-6 * var_x135 * var_x166;
        IJth(rJacobian, 7, 7) = -0.001 * var_x263;
        IJth(rJacobian, 19, 7) = 0.001 * ((var_x335) ? (-0.0090316078310111337 * var_x135 * var_x165) : (0));
        IJth(rJacobian, 0, 8) = mSetVoltageDerivativeToZero ? 0.0 : (-5.0000000000000002e-5 * var_x100 * var_x136);
        IJth(rJacobian, 1, 8) = -4.5158039155055668e-6 * var_x136 * var_x166;
        IJth(rJacobian, 8, 8) = -0.001 * var_x267;
        IJth(rJacobian, 19, 8) = 0.001 * ((var_x335) ? (-0.0045158039155055668 * var_x136 * var_x165) : (0));
        IJth(rJacobian, 0, 9) = mSetVoltageDerivativeToZero ? 0.0 : (-2.3862446088641737e-5 * var_x100 * var_x137);
        IJth(rJacobian, 9, 9) = -0.0013799999999999999 * var_x276 * var_x278 - 0.00060999999999999997 * var_x272 * var_x279;
        IJth(rJacobian, 24, 9) = -4.3103250992251538e-6 * var_x137 * var_x165;
        IJth(rJacobian, 0, 10) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x138 * var_x139);
        IJth(rJacobian, 10, 10) = -0.00013100000000000001 * var_x295 - 7.1899999999999999e-5 * var_x296;
        IJth(rJacobian, 24, 10) = var_x347 * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs2_gate__xs2;
        IJth(rJacobian, 0, 11) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x139 * var_x140);
        IJth(rJacobian, 11, 11) = -3.2750000000000003e-5 * var_x295 - 1.7975e-5 * var_x296;
        IJth(rJacobian, 24, 11) = var_x347 * var_chaste_interface__slow_delayed_rectifier_potassium_current_xs1_gate__xs1;
        IJth(rJacobian, 12, 12) = -var_x308 - 10.0 * var_x305;
        IJth(rJacobian, 13, 13) = -var_x328 - 0.10000000000000001 * var_x321;
        IJth(rJacobian, 1, 14) = 7.0588235294117632e-6 * var_x164 * var_x179;
        IJth(rJacobian, 14, 14) = var_x332 * (-5.5555555555555554 - var_x179) + 0.00025000000000000001 * (5.5555555555555554 * var_chaste_interface__calcium_dynamics__Ca_NSR - 5.5555555555555554 * var_chaste_interface__calcium_dynamics__Ca_JSR - var_x179 * var_x185) / (pow(var_x329, 3) * pow((0.125 + var_x330), 2));
        IJth(rJacobian, 15, 14) = 0.00048309178743961351;
        IJth(rJacobian, 1, 15) = 2.7058823529411762e-5 * var_x164;
        IJth(rJacobian, 14, 15) = 0.0055555555555555558 * var_x331;
        IJth(rJacobian, 15, 15) = -0.00081642512077294684;
        IJth(rJacobian, 16, 16) = 0.001 * ((var_x100 * (var_x186 + var_x187 + 0.0070160275741043606 * var_chaste_interface__membrane__V - 0.10684935482199306 * var_x122 - 7.3656881518639831e-7 * var_x5 + var_x110 * var_x30 + var_x123 * var_x34 + var_x142 * var_x37 + var_x18 * var_x56 + var_x23 * var_x56 + var_x3 * var_x56 + var_x76 * var_chaste_interface__membrane__V + var_x79 * var_chaste_interface__membrane__V + GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted) / HeartConfig::Instance()->GetCapacitance()) < -150000.0) ? (-100500.0) : (-500.0));
        IJth(rJacobian, 1, 17) = var_x191 * var_x192;
        IJth(rJacobian, 14, 17) = var_x191 * var_x333;
        IJth(rJacobian, 17, 17) = 0.001 * ((var_x334) ? (-100500.0) : (-500.0));
        IJth(rJacobian, 18, 18) = 0.001 * ((var_x334) ? (-100500.0) : (-10.0));
        IJth(rJacobian, 1, 19) = var_x192 * var_x194;
        IJth(rJacobian, 14, 19) = var_x194 * var_x333;
        IJth(rJacobian, 19, 19) = 0.001 * (((var_x335) || (var_chaste_interface__calcium_dynamics__APtrack2 > 0.01)) ? (0) : (-500.0));
        IJth(rJacobian, 20, 20) = 0.001 * (((var_chaste_interface__calcium_dynamics__APtrack3 < 0.37) && (var_chaste_interface__calcium_dynamics__OVRLDtrack3 < 0.37) && (1 / (1.0 + 0.80000000000000004 / var_chaste_interface__calcium_dynamics__Ca_JSR) > 0.69999999999999996)) ? (-50000.0) : (-500.0));
        IJth(rJacobian, 1, 21) = var_x192 * var_x195;
        IJth(rJacobian, 14, 21) = var_x195 * var_x333;
        IJth(rJacobian, 21, 21) = 0.001 * (((var_x337) && (var_chaste_interface__calcium_dynamics__OVRLDtrack2 < 0.97999999999999998)) ? (-50000.0) : (-500.0));
        IJth(rJacobian, 22, 22) = 0.001 * (((var_x337) && (var_chaste_interface__calcium_dynamics__OVRLDtrack3 < 0.97999999999999998)) ? (-50000.0) : (-10.0));
        IJth(rJacobian, 0, 23) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x101 * (var_x141 + var_x146 + var_x147 + var_x152 - var_x149 + 3.3880737654706117 * var_x151 + 0.029999999999999999 * var_x143));
        IJth(rJacobian, 1, 23) = -var_x167 * var_x196;
        IJth(rJacobian, 19, 23) = 0.001 * ((var_x335) ? (-var_x182 * var_x196) : (0));
        IJth(rJacobian, 23, 23) = var_x339 * (-var_x141 - var_x147 - var_x152 + 6.124934136868245e-12 * var_x148 - 0.032399999999999998 * var_x145 - 0.089999999999999997 * var_x143);
        IJth(rJacobian, 24, 23) = var_x339 * (3.3880737654706117 * var_x348 + 0.059999999999999998 * var_x143);
        IJth(rJacobian, 0, 24) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x101 * (var_x153 + var_x154 + var_x155 + var_x156 + var_x158 + var_x160 - var_x159 + 184.83763041301756 * var_x151));
        IJth(rJacobian, 24, 24) = var_x339 * (var_x159 - var_x153 - var_x154 - var_x155 - var_x156 - var_x158 - var_x160 + 184.83763041301756 * var_x348);
    }

    N_Vector Cellviswanathan_model_1999_epiFromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time_converted, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        
        // Mathematics
        const double var_membrane__I_st_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time_converted); // uA_per_cm2

        N_Vector dqs = N_VNew_Serial(2);
        NV_Ith_S(dqs, 0) = var_chaste_interface__environment__time_converted;
        NV_Ith_S(dqs, 1) = var_membrane__I_st_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellviswanathan_model_1999_epiFromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "viswanathan_model_1999_epi";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-88.984);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00035237);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00079287);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9938);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("fast_sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.99573);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("L_type_Ca_channel_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.18355e-06);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("L_type_Ca_channel_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9974388);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("T_type_Ca_channel_b_gate__b");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.000967785);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("T_type_Ca_channel_g_gate__g");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.95331988);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("rapid_delayed_rectifier_potassium_current_xr_gate__xr");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00032151644);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("slow_delayed_rectifier_potassium_current_xs1_gate__xs1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0272635);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("slow_delayed_rectifier_potassium_current_xs2_gate__xs2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0631269);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("transient_outward_current_zdv_gate__zdv");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.011528);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("transient_outward_current_ydv_gate__ydv");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.985232);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("calcium_dynamics__Ca_JSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.817895);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("calcium_dynamics__Ca_NSR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(2.797668);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("calcium_dynamics__APtrack");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.814e-87);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("calcium_dynamics__APtrack2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.1084e-86);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("calcium_dynamics__APtrack3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.01925);

    // NV_Ith_S(rY, 19):
    this->mVariableNames.push_back("calcium_dynamics__Cainfluxtrack");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(1.784e-87);

    // NV_Ith_S(rY, 20):
    this->mVariableNames.push_back("calcium_dynamics__OVRLDtrack");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // NV_Ith_S(rY, 21):
    this->mVariableNames.push_back("calcium_dynamics__OVRLDtrack2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // NV_Ith_S(rY, 22):
    this->mVariableNames.push_back("calcium_dynamics__OVRLDtrack3");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0);

    // NV_Ith_S(rY, 23):
    this->mVariableNames.push_back("ionic_concentrations__Nai");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(15.6748357);

    // NV_Ith_S(rY, 24):
    this->mVariableNames.push_back("ionic_concentrations__Ki");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(137.6244);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_capacitance");
    this->mParameterUnits.push_back("microF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellviswanathan_model_1999_epiFromCellMLCvode)

#endif // CHASTE_CVODE
