#ifdef CHASTE_CVODE
//! @file
//!
//! This source file was generated from CellML by chaste_codegen version 0.1.0
//!
//! Model: tentusscher_panfilov_2006_epi
//!
//! Processed by chaste_codegen: https://github.com/ModellingWebLab/chaste-codegen
//!     (translator: chaste_codegen, model type: normal)
//! on (date omitted as unimportant)
//!
//! <autogenerated>

#include "ten_tusscher_model_2006_epi.hpp"
#include <cmath>
#include <cassert>
#include <memory>
#include "Exception.hpp"
#include "OdeSystemInformation.hpp"
#include "RegularStimulus.hpp"
#include "HeartConfig.hpp"
#include "IsNan.hpp"
#include "MathsCustomFunctions.hpp"

    boost::shared_ptr<RegularStimulus> Cellten_tusscher_model_2006_epiFromCellMLCvode::UseCellMLDefaultStimulus()
    {
        // Use the default stimulus specified by CellML metadata
        const double var_chaste_interface__membrane__i_Stim_Amplitude_converted = -52.0 * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2
        const double var_chaste_interface__membrane__i_Stim_Period = 1000.0; // millisecond
        const double var_chaste_interface__membrane__i_Stim_PulseDuration = 1.0; // millisecond
        const double var_chaste_interface__membrane__i_Stim_Start = 10.0; // millisecond
        boost::shared_ptr<RegularStimulus> p_cellml_stim(new RegularStimulus(
                -fabs(var_chaste_interface__membrane__i_Stim_Amplitude_converted),
                var_chaste_interface__membrane__i_Stim_PulseDuration,
                var_chaste_interface__membrane__i_Stim_Period,
                var_chaste_interface__membrane__i_Stim_Start
                ));
        mpIntracellularStimulus = p_cellml_stim;
        return p_cellml_stim;
    }

    double Cellten_tusscher_model_2006_epiFromCellMLCvode::GetIntracellularCalciumConcentration()
    {
        return NV_Ith_S(mStateVariables, 1);
    }
    
    Cellten_tusscher_model_2006_epiFromCellMLCvode::Cellten_tusscher_model_2006_epiFromCellMLCvode(boost::shared_ptr<AbstractIvpOdeSolver> pOdeSolver /* unused; should be empty */, boost::shared_ptr<AbstractStimulusFunction> pIntracellularStimulus)
        : AbstractCvodeCell(
                pOdeSolver,
                19,
                0,
                pIntracellularStimulus)
    {
        // Time units: millisecond
        //
        this->mpSystemInfo = OdeSystemInformation<Cellten_tusscher_model_2006_epiFromCellMLCvode>::Instance();
        Init();

        // We have a default stimulus specified in the CellML file metadata
        this->mHasDefaultStimulusFromCellML = true;
        mUseAnalyticJacobian = true;
        mHasAnalyticJacobian = true;
        
        NV_Ith_S(this->mParameters, 0) = 3.9799999999999998e-5; // (var_L_type_Ca_current__g_CaL) [litre_per_farad_second]
        NV_Ith_S(this->mParameters, 1) = 14.837999999999999; // (var_fast_sodium_current__g_Na) [nanoS_per_picoF]
        NV_Ith_S(this->mParameters, 2) = 0.153; // (var_rapid_time_dependent_potassium_current__g_Kr) [nanoS_per_picoF]
        NV_Ith_S(this->mParameters, 3) = 0.29399999999999998; // (var_transient_outward_current__g_to) [nanoS_per_picoF]
    }

    Cellten_tusscher_model_2006_epiFromCellMLCvode::~Cellten_tusscher_model_2006_epiFromCellMLCvode()
    {
    }
    
    double Cellten_tusscher_model_2006_epiFromCellMLCvode::GetIIonic(const std::vector<double>* pStateVariables)
    {
        // For state variable interpolation (SVI) we read in interpolated state variables,
        // otherwise for ionic current interpolation (ICI) we use the state variables of this model (node).
        N_Vector rY;
        bool made_new_cvode_vector = false;
        if (!pStateVariables)
        {
            rY = rGetStateVariables();
        }
        else
        {
            made_new_cvode_vector = true;
            rY = MakeNVector(*pStateVariables);
        }
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -85.23
        double var_chaste_interface__calcium_dynamics__Ca_i = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 0.000126
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.00621
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.4712
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.0095
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.00172
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.7444
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.7045
        double var_chaste_interface__L_type_Ca_current_d_gate__d = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 3.373e-05
        double var_chaste_interface__L_type_Ca_current_f_gate__f = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.7888
        double var_chaste_interface__L_type_Ca_current_f2_gate__f2 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.9755
        double var_chaste_interface__L_type_Ca_current_fCass_gate__fCass = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.9953
        double var_chaste_interface__transient_outward_current_s_gate__s = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.999998
        double var_chaste_interface__transient_outward_current_r_gate__r = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 2.42e-08
        double var_chaste_interface__calcium_dynamics__Ca_ss = NV_Ith_S(rY, 15);
        // Units: millimolar; Initial value: 0.00036
        double var_chaste_interface__sodium_dynamics__Na_i = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 8.604
        double var_chaste_interface__potassium_dynamics__K_i = NV_Ith_S(rY, 18);
        // Units: millimolar; Initial value: 136.89
        
        const double var_calcium_background_current__g_bca = 0.00059199999999999997; // nanoS_per_picoF
        const double var_calcium_dynamics__Ca_o = 2.0; // millimolar
        const double var_calcium_pump_current__K_pCa = 0.00050000000000000001; // millimolar
        const double var_calcium_pump_current__g_pCa = 0.12379999999999999; // picoA_per_picoF
        const double var_calcium_pump_current__i_p_Ca = var_chaste_interface__calcium_dynamics__Ca_i * var_calcium_pump_current__g_pCa / (var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_pump_current__K_pCa); // picoA_per_picoF
        const double var_inward_rectifier_potassium_current__g_K1 = 5.4050000000000002; // nanoS_per_picoF
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_current__i_CaL = 4.0 * pow(var_membrane__F, 2) * (-15.0 + var_chaste_interface__membrane__V) * (-var_calcium_dynamics__Ca_o + 0.25 * var_chaste_interface__calcium_dynamics__Ca_ss * exp(2.0 * (-15.0 + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_f2_gate__f2 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass * var_chaste_interface__L_type_Ca_current_f_gate__f / ((-1.0 + exp(2.0 * (-15.0 + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA_per_picoF
        const double var_potassium_dynamics__K_o = 5.4000000000000004; // millimolar
        const double var_potassium_pump_current__g_pK = 0.0146; // nanoS_per_picoF
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Ca_o / var_chaste_interface__calcium_dynamics__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // picoA_per_picoF
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_potassium_dynamics__K_o / var_chaste_interface__potassium_dynamics__K_i) / var_membrane__F; // millivolt
        const double var_inward_rectifier_potassium_current__alpha_K1 = 0.10000000000000001 / (1.0 + exp(-12.0 + 0.059999999999999998 * var_chaste_interface__membrane__V - 0.059999999999999998 * var_reversal_potentials__E_K)); // dimensionless
        const double var_inward_rectifier_potassium_current__beta_K1 = (3.0 * exp(0.02 + 0.00020000000000000001 * var_chaste_interface__membrane__V - 0.00020000000000000001 * var_reversal_potentials__E_K) + exp(-1.0 + 0.10000000000000001 * var_chaste_interface__membrane__V - 0.10000000000000001 * var_reversal_potentials__E_K)) / (1.0 + exp(0.5 * var_reversal_potentials__E_K - 0.5 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_inward_rectifier_potassium_current__xK1_inf = var_inward_rectifier_potassium_current__alpha_K1 / (var_inward_rectifier_potassium_current__alpha_K1 + var_inward_rectifier_potassium_current__beta_K1); // dimensionless
        const double var_inward_rectifier_potassium_current__i_K1 = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier_potassium_current__g_K1 * var_inward_rectifier_potassium_current__xK1_inf; // picoA_per_picoF
        const double var_potassium_pump_current__i_p_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_pump_current__g_pK / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 2) * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2; // picoA_per_picoF
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_slow_time_dependent_potassium_current__g_Ks = 0.39200000000000002; // nanoS_per_picoF
        const double var_sodium_background_current__g_bna = 0.00029; // nanoS_per_picoF
        const double var_sodium_calcium_exchanger_current__K_NaCa = 1000.0; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger_current__Km_Ca = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger_current__Km_Nai = 87.5; // millimolar
        const double var_sodium_calcium_exchanger_current__alpha = 2.5; // dimensionless
        const double var_sodium_calcium_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_reversal_potentials__P_kna * var_sodium_dynamics__Na_o + var_potassium_dynamics__K_o) / (var_reversal_potentials__P_kna * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i)) / var_membrane__F; // millivolt
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_sodium_dynamics__Na_o / var_chaste_interface__sodium_dynamics__Na_i) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 1) * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // picoA_per_picoF
        const double var_slow_time_dependent_potassium_current__i_Ks = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_time_dependent_potassium_current__g_Ks; // picoA_per_picoF
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__i_NaCa = (pow(var_chaste_interface__sodium_dynamics__Na_i, 3) * var_calcium_dynamics__Ca_o * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger_current__gamma / (var_membrane__R * var_membrane__T)) - pow(var_sodium_dynamics__Na_o, 3) * var_chaste_interface__calcium_dynamics__Ca_i * var_sodium_calcium_exchanger_current__alpha * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger_current__K_NaCa / ((1.0 + var_sodium_calcium_exchanger_current__K_sat * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_sodium_calcium_exchanger_current__Km_Nai, 3) + pow(var_sodium_dynamics__Na_o, 3)) * (var_calcium_dynamics__Ca_o + var_sodium_calcium_exchanger_current__Km_Ca)); // picoA_per_picoF
        const double var_sodium_potassium_pump_current__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump_current__K_mk = 1.0; // millimolar
        const double var_sodium_potassium_pump_current__P_NaK = 2.7240000000000002; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = var_potassium_dynamics__K_o * var_chaste_interface__sodium_dynamics__Na_i * var_sodium_potassium_pump_current__P_NaK / ((var_potassium_dynamics__K_o + var_sodium_potassium_pump_current__K_mk) * (var_chaste_interface__sodium_dynamics__Na_i + var_sodium_potassium_pump_current__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // picoA_per_picoF
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 3) * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // picoA_per_picoF
        const double var_chaste_interface__i_ionic = (var_L_type_Ca_current__i_CaL + var_calcium_background_current__i_b_Ca + var_calcium_pump_current__i_p_Ca + var_fast_sodium_current__i_Na + var_inward_rectifier_potassium_current__i_K1 + var_potassium_pump_current__i_p_K + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks + var_sodium_background_current__i_b_Na + var_sodium_calcium_exchanger_current__i_NaCa + var_sodium_potassium_pump_current__i_NaK + var_transient_outward_current__i_to) * HeartConfig::Instance()->GetCapacitance(); // uA_per_cm2

        const double i_ionic = var_chaste_interface__i_ionic;
        if (made_new_cvode_vector)
        {
            DeleteVector(rY);
        }
        EXCEPT_IF_NOT(!std::isnan(i_ionic));
        return i_ionic;
    }

    void Cellten_tusscher_model_2006_epiFromCellMLCvode::EvaluateYDerivatives(double var_chaste_interface__environment__time, const N_Vector rY, N_Vector rDY)
    {
        // Inputs:
        // Time units: millisecond
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -85.23
        double var_chaste_interface__calcium_dynamics__Ca_i = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 0.000126
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.00621
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.4712
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.0095
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.00172
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.7444
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.7045
        double var_chaste_interface__L_type_Ca_current_d_gate__d = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 3.373e-05
        double var_chaste_interface__L_type_Ca_current_f_gate__f = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.7888
        double var_chaste_interface__L_type_Ca_current_f2_gate__f2 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.9755
        double var_chaste_interface__L_type_Ca_current_fCass_gate__fCass = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.9953
        double var_chaste_interface__transient_outward_current_s_gate__s = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.999998
        double var_chaste_interface__transient_outward_current_r_gate__r = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 2.42e-08
        double var_chaste_interface__calcium_dynamics__Ca_SR = NV_Ith_S(rY, 14);
        // Units: millimolar; Initial value: 3.64
        double var_chaste_interface__calcium_dynamics__Ca_ss = NV_Ith_S(rY, 15);
        // Units: millimolar; Initial value: 0.00036
        double var_chaste_interface__calcium_dynamics__R_prime = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 0.9073
        double var_chaste_interface__sodium_dynamics__Na_i = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 8.604
        double var_chaste_interface__potassium_dynamics__K_i = NV_Ith_S(rY, 18);
        // Units: millimolar; Initial value: 136.89

        // Mathematics
        double d_dt_chaste_interface_var_membrane__V;
        const double var_calcium_background_current__g_bca = 0.00059199999999999997; // nanoS_per_picoF
        const double var_calcium_dynamics__Buf_c = 0.20000000000000001; // millimolar
        const double var_calcium_dynamics__Buf_sr = 10.0; // millimolar
        const double var_calcium_dynamics__Buf_ss = 0.40000000000000002; // millimolar
        const double var_calcium_dynamics__Ca_o = 2.0; // millimolar
        const double var_L_type_Ca_current_fCass_gate__fCass_inf = 0.40000000000000002 + 0.59999999999999998 / (1.0 + 399.99999999999994 * pow(var_chaste_interface__calcium_dynamics__Ca_ss, 2)); // dimensionless
        const double var_L_type_Ca_current_fCass_gate__tau_fCass = 2.0 + 80.0 / (1.0 + 399.99999999999994 * pow(var_chaste_interface__calcium_dynamics__Ca_ss, 2)); // millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current_fCass_gate__fCass = (-var_chaste_interface__L_type_Ca_current_fCass_gate__fCass + var_L_type_Ca_current_fCass_gate__fCass_inf) / var_L_type_Ca_current_fCass_gate__tau_fCass; // 1 / millisecond
        const double var_calcium_dynamics__EC = 1.5; // millimolar
        const double var_calcium_dynamics__K_buf_c = 0.001; // millimolar
        const double var_calcium_dynamics__Ca_i_bufc = 1 / (1.0 + var_calcium_dynamics__Buf_c * var_calcium_dynamics__K_buf_c / pow((var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_dynamics__K_buf_c), 2)); // dimensionless
        const double var_calcium_dynamics__K_buf_sr = 0.29999999999999999; // millimolar
        const double var_calcium_dynamics__Ca_sr_bufsr = 1 / (1.0 + var_calcium_dynamics__Buf_sr * var_calcium_dynamics__K_buf_sr / pow((var_chaste_interface__calcium_dynamics__Ca_SR + var_calcium_dynamics__K_buf_sr), 2)); // dimensionless
        const double var_calcium_dynamics__K_buf_ss = 0.00025000000000000001; // millimolar
        const double var_calcium_dynamics__Ca_ss_bufss = 1 / (1.0 + var_calcium_dynamics__Buf_ss * var_calcium_dynamics__K_buf_ss / pow((var_chaste_interface__calcium_dynamics__Ca_ss + var_calcium_dynamics__K_buf_ss), 2)); // dimensionless
        const double var_calcium_dynamics__K_up = 0.00025000000000000001; // millimolar
        const double var_calcium_dynamics__V_leak = 0.00036000000000000002; // per_millisecond
        const double var_calcium_dynamics__V_rel = 0.10199999999999999; // per_millisecond
        const double var_calcium_dynamics__V_sr = 0.0010939999999999999; // micrometre3
        const double var_calcium_dynamics__V_ss = 5.4679999999999998e-5; // micrometre3
        const double var_calcium_dynamics__V_xfer = 0.0038; // per_millisecond
        const double var_calcium_dynamics__Vmax_up = 0.0063749999999999996; // millimolar_per_millisecond
        const double var_calcium_dynamics__i_leak = (-var_chaste_interface__calcium_dynamics__Ca_i + var_chaste_interface__calcium_dynamics__Ca_SR) * var_calcium_dynamics__V_leak; // millimolar_per_millisecond
        const double var_calcium_dynamics__i_up = var_calcium_dynamics__Vmax_up / (1.0 + pow(var_calcium_dynamics__K_up, 2) / pow(var_chaste_interface__calcium_dynamics__Ca_i, 2)); // millimolar_per_millisecond
        const double var_calcium_dynamics__i_xfer = (-var_chaste_interface__calcium_dynamics__Ca_i + var_chaste_interface__calcium_dynamics__Ca_ss) * var_calcium_dynamics__V_xfer; // millimolar_per_millisecond
        const double var_calcium_dynamics__k1_prime = 0.14999999999999999; // per_millimolar2_per_millisecond
        const double var_calcium_dynamics__k2_prime = 0.044999999999999998; // per_millimolar_per_millisecond
        const double var_calcium_dynamics__k3 = 0.059999999999999998; // per_millisecond
        const double var_calcium_dynamics__k4 = 0.0050000000000000001; // per_millisecond
        const double var_calcium_dynamics__max_sr = 2.5; // dimensionless
        const double var_calcium_dynamics__min_sr = 1.0; // dimensionless
        const double var_calcium_dynamics__kcasr = -(-var_calcium_dynamics__min_sr + var_calcium_dynamics__max_sr) / (1.0 + pow(var_calcium_dynamics__EC, 2) / pow(var_chaste_interface__calcium_dynamics__Ca_SR, 2)) + var_calcium_dynamics__max_sr; // dimensionless
        const double var_calcium_dynamics__k1 = var_calcium_dynamics__k1_prime / var_calcium_dynamics__kcasr; // per_millimolar2_per_millisecond
        const double var_calcium_dynamics__O = pow(var_chaste_interface__calcium_dynamics__Ca_ss, 2) * var_chaste_interface__calcium_dynamics__R_prime * var_calcium_dynamics__k1 / (pow(var_chaste_interface__calcium_dynamics__Ca_ss, 2) * var_calcium_dynamics__k1 + var_calcium_dynamics__k3); // dimensionless
        const double var_calcium_dynamics__i_rel = (-var_chaste_interface__calcium_dynamics__Ca_ss + var_chaste_interface__calcium_dynamics__Ca_SR) * var_calcium_dynamics__O * var_calcium_dynamics__V_rel; // millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_SR = (-var_calcium_dynamics__i_leak - var_calcium_dynamics__i_rel + var_calcium_dynamics__i_up) * var_calcium_dynamics__Ca_sr_bufsr; // millimolar / millisecond
        const double var_calcium_dynamics__k2 = var_calcium_dynamics__k2_prime * var_calcium_dynamics__kcasr; // per_millimolar_per_millisecond
        const double d_dt_chaste_interface_var_calcium_dynamics__R_prime = (1.0 - var_chaste_interface__calcium_dynamics__R_prime) * var_calcium_dynamics__k4 - var_chaste_interface__calcium_dynamics__Ca_ss * var_chaste_interface__calcium_dynamics__R_prime * var_calcium_dynamics__k2; // 1 / millisecond
        const double var_calcium_pump_current__K_pCa = 0.00050000000000000001; // millimolar
        const double var_calcium_pump_current__g_pCa = 0.12379999999999999; // picoA_per_picoF
        const double var_calcium_pump_current__i_p_Ca = var_chaste_interface__calcium_dynamics__Ca_i * var_calcium_pump_current__g_pCa / (var_chaste_interface__calcium_dynamics__Ca_i + var_calcium_pump_current__K_pCa); // picoA_per_picoF
        const double var_inward_rectifier_potassium_current__g_K1 = 5.4050000000000002; // nanoS_per_picoF
        const double var_membrane__Cm = 0.185; // microF
        const double var_membrane__F = 96485.341499999995; // coulomb_per_millimole
        const double var_membrane__R = 8314.4719999999998; // joule_per_mole_kelvin
        const double var_membrane__T = 310.0; // kelvin
        const double var_L_type_Ca_current__i_CaL = 4.0 * pow(var_membrane__F, 2) * (-15.0 + var_chaste_interface__membrane__V) * (-var_calcium_dynamics__Ca_o + 0.25 * var_chaste_interface__calcium_dynamics__Ca_ss * exp(2.0 * (-15.0 + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_f2_gate__f2 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass * var_chaste_interface__L_type_Ca_current_f_gate__f / ((-1.0 + exp(2.0 * (-15.0 + var_chaste_interface__membrane__V) * var_membrane__F / (var_membrane__R * var_membrane__T))) * var_membrane__R * var_membrane__T); // picoA_per_picoF
        const double var_L_type_Ca_current_d_gate__alpha_d = 0.25 + 1.3999999999999999 / (1.0 + exp(-2.6923076923076925 - 0.076923076923076927 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_d_gate__beta_d = 1.3999999999999999 / (1.0 + exp(1.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_d_gate__d_inf = 1 / (1.0 + exp(-1.0666666666666667 - 0.13333333333333333 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_d_gate__gamma_d = 1 / (1.0 + exp(2.5 - 0.050000000000000003 * var_chaste_interface__membrane__V)); // millisecond
        const double var_L_type_Ca_current_d_gate__tau_d = var_L_type_Ca_current_d_gate__alpha_d * var_L_type_Ca_current_d_gate__beta_d + var_L_type_Ca_current_d_gate__gamma_d; // millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current_d_gate__d = (-var_chaste_interface__L_type_Ca_current_d_gate__d + var_L_type_Ca_current_d_gate__d_inf) / var_L_type_Ca_current_d_gate__tau_d; // 1 / millisecond
        const double var_L_type_Ca_current_f2_gate__f2_inf = 0.33000000000000002 + 0.67000000000000004 / (1.0 + exp(5.0 + 0.14285714285714285 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_f2_gate__tau_f2 = 80.0 / (1.0 + exp(3.0 + 0.10000000000000001 * var_chaste_interface__membrane__V)) + 31.0 / (1.0 + exp(2.5 - 0.10000000000000001 * var_chaste_interface__membrane__V)) + 562.0 * exp(-3.0375000000000001 * pow((1 + 0.037037037037037035 * var_chaste_interface__membrane__V), 2)); // millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current_f2_gate__f2 = (-var_chaste_interface__L_type_Ca_current_f2_gate__f2 + var_L_type_Ca_current_f2_gate__f2_inf) / var_L_type_Ca_current_f2_gate__tau_f2; // 1 / millisecond
        const double var_L_type_Ca_current_f_gate__f_inf = 1 / (1.0 + exp(2.8571428571428572 + 0.14285714285714285 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_L_type_Ca_current_f_gate__tau_f = 20.0 + 200.0 / (1.0 + exp(1.3 - 0.10000000000000001 * var_chaste_interface__membrane__V)) + 180.0 / (1.0 + exp(3.0 + 0.10000000000000001 * var_chaste_interface__membrane__V)) + 1102.5 * exp(-3.2400000000000002 * pow((1 + 0.037037037037037035 * var_chaste_interface__membrane__V), 2)); // millisecond
        const double d_dt_chaste_interface_var_L_type_Ca_current_f_gate__f = (-var_chaste_interface__L_type_Ca_current_f_gate__f + var_L_type_Ca_current_f_gate__f_inf) / var_L_type_Ca_current_f_gate__tau_f; // 1 / millisecond
        const double var_fast_sodium_current_h_gate__alpha_h = ((var_chaste_interface__membrane__V < -40.0) ? (0.057000000000000002 * exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V)) : (0)); // per_millisecond
        const double var_fast_sodium_current_h_gate__beta_h = ((var_chaste_interface__membrane__V < -40.0) ? (310000.0 * exp(0.34849999999999998 * var_chaste_interface__membrane__V) + 2.7000000000000002 * exp(0.079000000000000001 * var_chaste_interface__membrane__V)) : (5.9230769230769234 / (1.0 + exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_h_gate__h_inf = 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__membrane__V)), 2); // dimensionless
        const double var_fast_sodium_current_h_gate__tau_h = 1 / (var_fast_sodium_current_h_gate__alpha_h + var_fast_sodium_current_h_gate__beta_h); // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_h_gate__h = (-var_chaste_interface__fast_sodium_current_h_gate__h + var_fast_sodium_current_h_gate__h_inf) / var_fast_sodium_current_h_gate__tau_h; // 1 / millisecond
        const double var_fast_sodium_current_j_gate__alpha_j = ((var_chaste_interface__membrane__V < -40.0) ? ((37.780000000000001 + var_chaste_interface__membrane__V) * (-25428.0 * exp(0.24440000000000001 * var_chaste_interface__membrane__V) - 6.9480000000000002e-6 * exp(-0.043909999999999998 * var_chaste_interface__membrane__V)) / (1.0 + exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V))) : (0)); // per_millisecond
        const double var_fast_sodium_current_j_gate__beta_j = ((var_chaste_interface__membrane__V < -40.0) ? (0.024240000000000001 * exp(-0.01052 * var_chaste_interface__membrane__V) / (1.0 + exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V))) : (0.59999999999999998 * exp(0.057000000000000002 * var_chaste_interface__membrane__V) / (1.0 + exp(-3.2000000000000002 - 0.10000000000000001 * var_chaste_interface__membrane__V)))); // per_millisecond
        const double var_fast_sodium_current_j_gate__j_inf = 1 / pow((1.0 + exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__membrane__V)), 2); // dimensionless
        const double var_fast_sodium_current_j_gate__tau_j = 1 / (var_fast_sodium_current_j_gate__alpha_j + var_fast_sodium_current_j_gate__beta_j); // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_j_gate__j = (-var_chaste_interface__fast_sodium_current_j_gate__j + var_fast_sodium_current_j_gate__j_inf) / var_fast_sodium_current_j_gate__tau_j; // 1 / millisecond
        const double var_fast_sodium_current_m_gate__alpha_m = 1 / (1.0 + exp(-12.0 - 0.20000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_fast_sodium_current_m_gate__beta_m = 0.10000000000000001 / (1.0 + exp(7.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)) + 0.10000000000000001 / (1.0 + exp(-0.25 + 0.0050000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_fast_sodium_current_m_gate__m_inf = 1 / pow((1.0 + exp(-6.2967884828349945 - 0.11074197120708749 * var_chaste_interface__membrane__V)), 2); // dimensionless
        const double var_fast_sodium_current_m_gate__tau_m = var_fast_sodium_current_m_gate__alpha_m * var_fast_sodium_current_m_gate__beta_m; // millisecond
        const double d_dt_chaste_interface_var_fast_sodium_current_m_gate__m = (-var_chaste_interface__fast_sodium_current_m_gate__m + var_fast_sodium_current_m_gate__m_inf) / var_fast_sodium_current_m_gate__tau_m; // 1 / millisecond
        const double var_membrane__V_c = 0.016403999999999998; // micrometre3
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_ss = (var_calcium_dynamics__V_sr * var_calcium_dynamics__i_rel / var_calcium_dynamics__V_ss - var_calcium_dynamics__i_xfer * var_membrane__V_c / var_calcium_dynamics__V_ss - 0.5 * var_L_type_Ca_current__i_CaL * var_membrane__Cm / (var_calcium_dynamics__V_ss * var_membrane__F)) * var_calcium_dynamics__Ca_ss_bufss; // millimolar / millisecond
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2
        const double var_membrane__i_Stim = var_membrane__i_Stim_converted / HeartConfig::Instance()->GetCapacitance(); // picoA_per_picoF
        const double var_potassium_dynamics__K_o = 5.4000000000000004; // millimolar
        const double var_potassium_pump_current__g_pK = 0.0146; // nanoS_per_picoF
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__alpha_xr1 = 450.0 / (1.0 + exp(-4.5 - 0.10000000000000001 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__beta_xr1 = 6.0 / (1.0 + exp(2.6086956521739131 + 0.086956521739130432 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__tau_xr1 = var_rapid_time_dependent_potassium_current_Xr1_gate__alpha_xr1 * var_rapid_time_dependent_potassium_current_Xr1_gate__beta_xr1; // millisecond
        const double var_rapid_time_dependent_potassium_current_Xr1_gate__xr1_inf = 1 / (1.0 + exp(-3.7142857142857144 - 0.14285714285714285 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = (-var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 + var_rapid_time_dependent_potassium_current_Xr1_gate__xr1_inf) / var_rapid_time_dependent_potassium_current_Xr1_gate__tau_xr1; // 1 / millisecond
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__alpha_xr2 = 3.0 / (1.0 + exp(-3.0 - 0.050000000000000003 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__beta_xr2 = 1.1200000000000001 / (1.0 + exp(-3.0 + 0.050000000000000003 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__tau_xr2 = var_rapid_time_dependent_potassium_current_Xr2_gate__alpha_xr2 * var_rapid_time_dependent_potassium_current_Xr2_gate__beta_xr2; // millisecond
        const double var_rapid_time_dependent_potassium_current_Xr2_gate__xr2_inf = 1 / (1.0 + exp(3.6666666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = (-var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 + var_rapid_time_dependent_potassium_current_Xr2_gate__xr2_inf) / var_rapid_time_dependent_potassium_current_Xr2_gate__tau_xr2; // 1 / millisecond
        const double var_reversal_potentials__E_Ca = 0.5 * var_membrane__R * var_membrane__T * log(var_calcium_dynamics__Ca_o / var_chaste_interface__calcium_dynamics__Ca_i) / var_membrane__F; // millivolt
        const double var_calcium_background_current__i_b_Ca = (-var_reversal_potentials__E_Ca + var_chaste_interface__membrane__V) * var_calcium_background_current__g_bca; // picoA_per_picoF
        const double var_reversal_potentials__E_K = var_membrane__R * var_membrane__T * log(var_potassium_dynamics__K_o / var_chaste_interface__potassium_dynamics__K_i) / var_membrane__F; // millivolt
        const double var_inward_rectifier_potassium_current__alpha_K1 = 0.10000000000000001 / (1.0 + exp(-12.0 + 0.059999999999999998 * var_chaste_interface__membrane__V - 0.059999999999999998 * var_reversal_potentials__E_K)); // dimensionless
        const double var_inward_rectifier_potassium_current__beta_K1 = (3.0 * exp(0.02 + 0.00020000000000000001 * var_chaste_interface__membrane__V - 0.00020000000000000001 * var_reversal_potentials__E_K) + exp(-1.0 + 0.10000000000000001 * var_chaste_interface__membrane__V - 0.10000000000000001 * var_reversal_potentials__E_K)) / (1.0 + exp(0.5 * var_reversal_potentials__E_K - 0.5 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_inward_rectifier_potassium_current__xK1_inf = var_inward_rectifier_potassium_current__alpha_K1 / (var_inward_rectifier_potassium_current__alpha_K1 + var_inward_rectifier_potassium_current__beta_K1); // dimensionless
        const double var_inward_rectifier_potassium_current__i_K1 = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_inward_rectifier_potassium_current__g_K1 * var_inward_rectifier_potassium_current__xK1_inf; // picoA_per_picoF
        const double var_potassium_pump_current__i_p_K = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * var_potassium_pump_current__g_pK / (1.0 + exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V)); // picoA_per_picoF
        const double var_rapid_time_dependent_potassium_current__i_Kr = 0.43033148291193518 * sqrt(var_potassium_dynamics__K_o) * (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 2) * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2; // picoA_per_picoF
        const double var_reversal_potentials__P_kna = 0.029999999999999999; // dimensionless
        const double var_slow_time_dependent_potassium_current__g_Ks = 0.39200000000000002; // nanoS_per_picoF
        const double var_slow_time_dependent_potassium_current_Xs_gate__alpha_xs = 1400.0 / sqrt(1.0 + exp(0.83333333333333337 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_time_dependent_potassium_current_Xs_gate__beta_xs = 1 / (1.0 + exp(-2.3333333333333335 + 0.066666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_slow_time_dependent_potassium_current_Xs_gate__tau_xs = 80.0 + var_slow_time_dependent_potassium_current_Xs_gate__alpha_xs * var_slow_time_dependent_potassium_current_Xs_gate__beta_xs; // millisecond
        const double var_slow_time_dependent_potassium_current_Xs_gate__xs_inf = 1 / (1.0 + exp(-0.35714285714285715 - 0.071428571428571425 * var_chaste_interface__membrane__V)); // dimensionless
        const double d_dt_chaste_interface_var_slow_time_dependent_potassium_current_Xs_gate__Xs = (-var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs + var_slow_time_dependent_potassium_current_Xs_gate__xs_inf) / var_slow_time_dependent_potassium_current_Xs_gate__tau_xs; // 1 / millisecond
        const double var_sodium_background_current__g_bna = 0.00029; // nanoS_per_picoF
        const double var_sodium_calcium_exchanger_current__K_NaCa = 1000.0; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__K_sat = 0.10000000000000001; // dimensionless
        const double var_sodium_calcium_exchanger_current__Km_Ca = 1.3799999999999999; // millimolar
        const double var_sodium_calcium_exchanger_current__Km_Nai = 87.5; // millimolar
        const double var_sodium_calcium_exchanger_current__alpha = 2.5; // dimensionless
        const double var_sodium_calcium_exchanger_current__gamma = 0.34999999999999998; // dimensionless
        const double var_sodium_dynamics__Na_o = 140.0; // millimolar
        const double var_reversal_potentials__E_Ks = var_membrane__R * var_membrane__T * log((var_reversal_potentials__P_kna * var_sodium_dynamics__Na_o + var_potassium_dynamics__K_o) / (var_reversal_potentials__P_kna * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i)) / var_membrane__F; // millivolt
        const double var_reversal_potentials__E_Na = var_membrane__R * var_membrane__T * log(var_sodium_dynamics__Na_o / var_chaste_interface__sodium_dynamics__Na_i) / var_membrane__F; // millivolt
        const double var_fast_sodium_current__i_Na = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3) * (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 1) * var_chaste_interface__fast_sodium_current_h_gate__h * var_chaste_interface__fast_sodium_current_j_gate__j; // picoA_per_picoF
        const double var_slow_time_dependent_potassium_current__i_Ks = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2) * (-var_reversal_potentials__E_Ks + var_chaste_interface__membrane__V) * var_slow_time_dependent_potassium_current__g_Ks; // picoA_per_picoF
        const double var_sodium_background_current__i_b_Na = (-var_reversal_potentials__E_Na + var_chaste_interface__membrane__V) * var_sodium_background_current__g_bna; // picoA_per_picoF
        const double var_sodium_calcium_exchanger_current__i_NaCa = (pow(var_chaste_interface__sodium_dynamics__Na_i, 3) * var_calcium_dynamics__Ca_o * exp(var_membrane__F * var_chaste_interface__membrane__V * var_sodium_calcium_exchanger_current__gamma / (var_membrane__R * var_membrane__T)) - pow(var_sodium_dynamics__Na_o, 3) * var_chaste_interface__calcium_dynamics__Ca_i * var_sodium_calcium_exchanger_current__alpha * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * var_sodium_calcium_exchanger_current__K_NaCa / ((1.0 + var_sodium_calcium_exchanger_current__K_sat * exp((-1.0 + var_sodium_calcium_exchanger_current__gamma) * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T))) * (pow(var_sodium_calcium_exchanger_current__Km_Nai, 3) + pow(var_sodium_dynamics__Na_o, 3)) * (var_calcium_dynamics__Ca_o + var_sodium_calcium_exchanger_current__Km_Ca)); // picoA_per_picoF
        const double d_dt_chaste_interface_var_calcium_dynamics__Ca_i = ((-var_calcium_dynamics__i_up + var_calcium_dynamics__i_leak) * var_calcium_dynamics__V_sr / var_membrane__V_c - 0.5 * (-2.0 * var_sodium_calcium_exchanger_current__i_NaCa + var_calcium_background_current__i_b_Ca + var_calcium_pump_current__i_p_Ca) * var_membrane__Cm / (var_membrane__F * var_membrane__V_c) + var_calcium_dynamics__i_xfer) * var_calcium_dynamics__Ca_i_bufc; // millimolar / millisecond
        const double var_sodium_potassium_pump_current__K_mNa = 40.0; // millimolar
        const double var_sodium_potassium_pump_current__K_mk = 1.0; // millimolar
        const double var_sodium_potassium_pump_current__P_NaK = 2.7240000000000002; // picoA_per_picoF
        const double var_sodium_potassium_pump_current__i_NaK = var_potassium_dynamics__K_o * var_chaste_interface__sodium_dynamics__Na_i * var_sodium_potassium_pump_current__P_NaK / ((var_potassium_dynamics__K_o + var_sodium_potassium_pump_current__K_mk) * (var_chaste_interface__sodium_dynamics__Na_i + var_sodium_potassium_pump_current__K_mNa) * (1.0 + 0.035299999999999998 * exp(-var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)) + 0.1245 * exp(-0.10000000000000001 * var_membrane__F * var_chaste_interface__membrane__V / (var_membrane__R * var_membrane__T)))); // picoA_per_picoF
        const double d_dt_chaste_interface_var_sodium_dynamics__Na_i = -1.0 * (3.0 * var_sodium_calcium_exchanger_current__i_NaCa + 3.0 * var_sodium_potassium_pump_current__i_NaK + var_fast_sodium_current__i_Na + var_sodium_background_current__i_b_Na) * var_membrane__Cm / (var_membrane__F * var_membrane__V_c); // millimolar / millisecond
        const double var_transient_outward_current_r_gate__r_inf = 1 / (1.0 + exp(3.3333333333333335 - 0.16666666666666666 * var_chaste_interface__membrane__V)); // dimensionless
        const double var_transient_outward_current_r_gate__tau_r = 0.80000000000000004 + 9.5 * exp(-0.88888888888888884 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2)); // millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_r_gate__r = (-var_chaste_interface__transient_outward_current_r_gate__r + var_transient_outward_current_r_gate__r_inf) / var_transient_outward_current_r_gate__tau_r; // 1 / millisecond
        const double var_transient_outward_current__i_to = (-var_reversal_potentials__E_K + var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 3) * var_chaste_interface__transient_outward_current_r_gate__r * var_chaste_interface__transient_outward_current_s_gate__s; // picoA_per_picoF
        const double d_dt_chaste_interface_var_potassium_dynamics__K_i = -1.0 * (-2.0 * var_sodium_potassium_pump_current__i_NaK + var_inward_rectifier_potassium_current__i_K1 + var_membrane__i_Stim + var_potassium_pump_current__i_p_K + var_rapid_time_dependent_potassium_current__i_Kr + var_slow_time_dependent_potassium_current__i_Ks + var_transient_outward_current__i_to) * var_membrane__Cm / (var_membrane__F * var_membrane__V_c); // millimolar / millisecond
        const double var_transient_outward_current_s_gate__s_gateparam = 20.0; // millivolt
        const double var_transient_outward_current_s_gate__s_inf = 1 / (1.0 + exp(0.20000000000000001 * var_chaste_interface__membrane__V + 0.20000000000000001 * var_transient_outward_current_s_gate__s_gateparam)); // dimensionless
        const double var_transient_outward_current_s_gate__tau_s_t1V = 45.0; // millivolt
        const double var_transient_outward_current_s_gate__tau_s_t1Vdenom = 320.0; // millivolt_square
        const double var_transient_outward_current_s_gate__tau_s_term1 = 85.0; // millisecond
        const double var_transient_outward_current_s_gate__tau_s_term2 = 5.0; // millisecond
        const double var_transient_outward_current_s_gate__tau_sconstant1 = 3.0; // millisecond
        const double var_transient_outward_current_s_gate__tau_s = var_transient_outward_current_s_gate__tau_s_term2 / (1.0 + exp(-4.0 + 0.20000000000000001 * var_chaste_interface__membrane__V)) + var_transient_outward_current_s_gate__tau_s_term1 * exp(-pow((var_chaste_interface__membrane__V + var_transient_outward_current_s_gate__tau_s_t1V), 2) / var_transient_outward_current_s_gate__tau_s_t1Vdenom) + var_transient_outward_current_s_gate__tau_sconstant1; // millisecond
        const double d_dt_chaste_interface_var_transient_outward_current_s_gate__s = (-var_chaste_interface__transient_outward_current_s_gate__s + var_transient_outward_current_s_gate__s_inf) / var_transient_outward_current_s_gate__tau_s; // 1 / millisecond

        if (mSetVoltageDerivativeToZero)
        {
            d_dt_chaste_interface_var_membrane__V = 0.0;
        }
        else
        {
            d_dt_chaste_interface_var_membrane__V = -var_L_type_Ca_current__i_CaL - var_calcium_background_current__i_b_Ca - var_calcium_pump_current__i_p_Ca - var_fast_sodium_current__i_Na - var_inward_rectifier_potassium_current__i_K1 - var_membrane__i_Stim - var_potassium_pump_current__i_p_K - var_rapid_time_dependent_potassium_current__i_Kr - var_slow_time_dependent_potassium_current__i_Ks - var_sodium_background_current__i_b_Na - var_sodium_calcium_exchanger_current__i_NaCa - var_sodium_potassium_pump_current__i_NaK - var_transient_outward_current__i_to; // millivolt / millisecond
        }
        
        NV_Ith_S(rDY,0) = d_dt_chaste_interface_var_membrane__V;
        NV_Ith_S(rDY,1) = d_dt_chaste_interface_var_calcium_dynamics__Ca_i;
        NV_Ith_S(rDY,2) = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_Xr1_gate__Xr1;
        NV_Ith_S(rDY,3) = d_dt_chaste_interface_var_rapid_time_dependent_potassium_current_Xr2_gate__Xr2;
        NV_Ith_S(rDY,4) = d_dt_chaste_interface_var_slow_time_dependent_potassium_current_Xs_gate__Xs;
        NV_Ith_S(rDY,5) = d_dt_chaste_interface_var_fast_sodium_current_m_gate__m;
        NV_Ith_S(rDY,6) = d_dt_chaste_interface_var_fast_sodium_current_h_gate__h;
        NV_Ith_S(rDY,7) = d_dt_chaste_interface_var_fast_sodium_current_j_gate__j;
        NV_Ith_S(rDY,8) = d_dt_chaste_interface_var_L_type_Ca_current_d_gate__d;
        NV_Ith_S(rDY,9) = d_dt_chaste_interface_var_L_type_Ca_current_f_gate__f;
        NV_Ith_S(rDY,10) = d_dt_chaste_interface_var_L_type_Ca_current_f2_gate__f2;
        NV_Ith_S(rDY,11) = d_dt_chaste_interface_var_L_type_Ca_current_fCass_gate__fCass;
        NV_Ith_S(rDY,12) = d_dt_chaste_interface_var_transient_outward_current_s_gate__s;
        NV_Ith_S(rDY,13) = d_dt_chaste_interface_var_transient_outward_current_r_gate__r;
        NV_Ith_S(rDY,14) = d_dt_chaste_interface_var_calcium_dynamics__Ca_SR;
        NV_Ith_S(rDY,15) = d_dt_chaste_interface_var_calcium_dynamics__Ca_ss;
        NV_Ith_S(rDY,16) = d_dt_chaste_interface_var_calcium_dynamics__R_prime;
        NV_Ith_S(rDY,17) = d_dt_chaste_interface_var_sodium_dynamics__Na_i;
        NV_Ith_S(rDY,18) = d_dt_chaste_interface_var_potassium_dynamics__K_i;
    }

    void Cellten_tusscher_model_2006_epiFromCellMLCvode::EvaluateAnalyticJacobian(double var_chaste_interface__environment__time, N_Vector rY, N_Vector rDY, CHASTE_CVODE_DENSE_MATRIX rJacobian, N_Vector rTmp1, N_Vector rTmp2, N_Vector rTmp3)
    {
        double var_chaste_interface__membrane__V = (mSetVoltageDerivativeToZero ? this->mFixedVoltage : NV_Ith_S(rY, 0));
        // Units: millivolt; Initial value: -85.23
        double var_chaste_interface__calcium_dynamics__Ca_i = NV_Ith_S(rY, 1);
        // Units: millimolar; Initial value: 0.000126
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 = NV_Ith_S(rY, 2);
        // Units: dimensionless; Initial value: 0.00621
        double var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 = NV_Ith_S(rY, 3);
        // Units: dimensionless; Initial value: 0.4712
        double var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs = NV_Ith_S(rY, 4);
        // Units: dimensionless; Initial value: 0.0095
        double var_chaste_interface__fast_sodium_current_m_gate__m = NV_Ith_S(rY, 5);
        // Units: dimensionless; Initial value: 0.00172
        double var_chaste_interface__fast_sodium_current_h_gate__h = NV_Ith_S(rY, 6);
        // Units: dimensionless; Initial value: 0.7444
        double var_chaste_interface__fast_sodium_current_j_gate__j = NV_Ith_S(rY, 7);
        // Units: dimensionless; Initial value: 0.7045
        double var_chaste_interface__L_type_Ca_current_d_gate__d = NV_Ith_S(rY, 8);
        // Units: dimensionless; Initial value: 3.373e-05
        double var_chaste_interface__L_type_Ca_current_f_gate__f = NV_Ith_S(rY, 9);
        // Units: dimensionless; Initial value: 0.7888
        double var_chaste_interface__L_type_Ca_current_f2_gate__f2 = NV_Ith_S(rY, 10);
        // Units: dimensionless; Initial value: 0.9755
        double var_chaste_interface__L_type_Ca_current_fCass_gate__fCass = NV_Ith_S(rY, 11);
        // Units: dimensionless; Initial value: 0.9953
        double var_chaste_interface__transient_outward_current_s_gate__s = NV_Ith_S(rY, 12);
        // Units: dimensionless; Initial value: 0.999998
        double var_chaste_interface__transient_outward_current_r_gate__r = NV_Ith_S(rY, 13);
        // Units: dimensionless; Initial value: 2.42e-08
        double var_chaste_interface__calcium_dynamics__Ca_SR = NV_Ith_S(rY, 14);
        // Units: millimolar; Initial value: 3.64
        double var_chaste_interface__calcium_dynamics__Ca_ss = NV_Ith_S(rY, 15);
        // Units: millimolar; Initial value: 0.00036
        double var_chaste_interface__calcium_dynamics__R_prime = NV_Ith_S(rY, 16);
        // Units: dimensionless; Initial value: 0.9073
        double var_chaste_interface__sodium_dynamics__Na_i = NV_Ith_S(rY, 17);
        // Units: millimolar; Initial value: 8.604
        double var_chaste_interface__potassium_dynamics__K_i = NV_Ith_S(rY, 18);
        // Units: millimolar; Initial value: 136.89
        
        const double var_x0 = pow(var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs, 2);
        const double var_x1 = exp(4.1806020066889626 - 0.16722408026755853 * var_chaste_interface__membrane__V);
        const double var_x2 = 1.0 + var_x1;
        const double var_x3 = 1 / var_x2;
        const double var_x4 = exp(-0.024332029034784559 * var_chaste_interface__membrane__V);
        const double var_x5 = 1.0 + 0.10000000000000001 * var_x4;
        const double var_x6 = 1 / var_x5;
        const double var_x7 = var_x4 * var_chaste_interface__calcium_dynamics__Ca_i;
        const double var_x8 = exp(0.013101861787960915 * var_chaste_interface__membrane__V);
        const double var_x9 = var_x8 * pow(var_chaste_interface__sodium_dynamics__Na_i, 3);
        const double var_x10 = var_x6 * (166917.71917862206 * var_x7 + 0.026203723575921829 * var_x9);
        const double var_x11 = 1 / var_chaste_interface__potassium_dynamics__K_i;
        const double var_x12 = log(5.4000000000000004 * var_x11);
        const double var_x13 = exp(-12.0 + 0.059999999999999998 * var_chaste_interface__membrane__V - 1.6028256395817388 * var_x12);
        const double var_x14 = 1.0 + var_x13;
        const double var_x15 = 1 / var_x14;
        const double var_x16 = exp(13.356880329847826 * var_x12 - 0.5 * var_chaste_interface__membrane__V);
        const double var_x17 = 1.0 + var_x16;
        const double var_x18 = 1 / var_x17;
        const double var_x19 = exp(0.02 + 0.00020000000000000001 * var_chaste_interface__membrane__V - 0.0053427521319391299 * var_x12);
        const double var_x20 = 0.10000000000000001 * var_chaste_interface__membrane__V;
        const double var_x21 = exp(-1.0 + var_x20 - 2.6713760659695653 * var_x12);
        const double var_x22 = var_x21 + 3.0 * var_x19;
        const double var_x23 = 0.10000000000000001 * var_x15 + var_x18 * var_x22;
        const double var_x24 = 1 / var_x23;
        const double var_x25 = var_x15 * var_x24;
        const double var_x26 = NV_Ith_S(mParameters, 3) * var_chaste_interface__transient_outward_current_r_gate__r;
        const double var_x27 = var_x26 * var_chaste_interface__transient_outward_current_s_gate__s;
        const double var_x28 = 26.713760659695652 * var_x12;
        const double var_x29 = -var_x28 + var_chaste_interface__membrane__V;
        const double var_x30 = var_x1 * var_x29 / pow(var_x2, 2);
        const double var_x31 = 2.0 * var_x9 - 6860000.0 * var_x7;
        const double var_x32 = var_x31 * var_x4 / pow(var_x5, 2);
        const double var_x33 = NV_Ith_S(mParameters, 2) * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2;
        const double var_x34 = pow(var_chaste_interface__fast_sodium_current_m_gate__m, 3);
        const double var_x35 = var_x34 * NV_Ith_S(mParameters, 1) * var_chaste_interface__fast_sodium_current_j_gate__j;
        const double var_x36 = var_x35 * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x37 = var_x13 / pow(var_x14, 2);
        const double var_x38 = var_x24 * var_x29;
        const double var_x39 = var_x37 * var_x38;
        const double var_x40 = var_x16 * var_x22 / pow(var_x17, 2);
        const double var_x41 = 0.0060000000000000001 * var_x37 - 0.5 * var_x40 - var_x18 * (0.10000000000000001 * var_x21 + 0.00060000000000000006 * var_x19);
        const double var_x42 = var_x15 * var_x29 / pow(var_x23, 2);
        const double var_x43 = 0.54050000000000009 * var_x42;
        const double var_x44 = 1 / (40.0 + var_chaste_interface__sodium_dynamics__Na_i);
        const double var_x45 = exp(-0.037433890822745473 * var_chaste_interface__membrane__V);
        const double var_x46 = exp(-0.0037433890822745472 * var_chaste_interface__membrane__V);
        const double var_x47 = 1.0 + 0.035299999999999998 * var_x45 + 0.1245 * var_x46;
        const double var_x48 = var_x44 * (0.001321416346042915 * var_x45 + 0.00046605194074318115 * var_x46) * var_chaste_interface__sodium_dynamics__Na_i / pow(var_x47, 2);
        const double var_x49 = exp(-1.1230167246823641 + 0.074867781645490947 * var_chaste_interface__membrane__V);
        const double var_x50 = -1.0 + var_x49;
        const double var_x51 = 1 / var_x50;
        const double var_x52 = var_x51 * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_f2_gate__f2 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass * var_chaste_interface__L_type_Ca_current_f_gate__f;
        const double var_x53 = var_x49 * var_chaste_interface__calcium_dynamics__Ca_ss;
        const double var_x54 = -2.0 + 0.25 * var_x53;
        const double var_x55 = 14447.286958825251 * var_x54;
        const double var_x56 = -15.0 + var_chaste_interface__membrane__V;
        const double var_x57 = var_x49 * var_x56;
        const double var_x58 = var_x54 * var_x57 * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_f2_gate__f2 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass * var_chaste_interface__L_type_Ca_current_f_gate__f / pow(var_x50, 2);
        const double var_x59 = var_x52 * var_x53 * var_x56;
        const double var_x60 = 0.00050000000000000001 + var_chaste_interface__calcium_dynamics__Ca_i;
        const double var_x61 = 1 / var_x60;
        const double var_x62 = 1 / var_chaste_interface__calcium_dynamics__Ca_i;
        const double var_x63 = var_chaste_interface__calcium_dynamics__Ca_i / pow(var_x60, 2);
        const double var_x64 = var_x4 * var_x6;
        const double var_x65 = (26.713760659695648 * var_x12 - 1.0 * var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 2);
        const double var_x66 = 0.029999999999999999 * var_chaste_interface__sodium_dynamics__Na_i + var_chaste_interface__potassium_dynamics__K_i;
        const double var_x67 = (-26.713760659695652 * log(9.5999999999999996 / var_x66) + var_chaste_interface__membrane__V) * var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs;
        const double var_x68 = 1 / var_chaste_interface__sodium_dynamics__Na_i;
        const double var_x69 = -26.713760659695652 * log(140.0 * var_x68) + var_chaste_interface__membrane__V;
        const double var_x70 = var_x69 * NV_Ith_S(mParameters, 1) * var_chaste_interface__fast_sodium_current_h_gate__h;
        const double var_x71 = var_x70 * pow(var_chaste_interface__fast_sodium_current_m_gate__m, 2) * var_chaste_interface__fast_sodium_current_j_gate__j;
        const double var_x72 = var_x35 * var_x69;
        const double var_x73 = var_x34 * var_x70;
        const double var_x74 = var_x51 * var_x56 * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_current_f2_gate__f2 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass;
        const double var_x75 = var_x55 * var_x74;
        const double var_x76 = var_x51 * var_x56 * NV_Ith_S(mParameters, 0) * var_chaste_interface__L_type_Ca_current_d_gate__d * var_chaste_interface__L_type_Ca_current_f_gate__f;
        const double var_x77 = var_x55 * var_x76;
        const double var_x78 = var_x28 - var_chaste_interface__membrane__V;
        const double var_x79 = NV_Ith_S(mParameters, 3) * var_chaste_interface__transient_outward_current_s_gate__s;
        const double var_x80 = var_x52 * var_x57;
        const double var_x81 = 1 / var_x47;
        const double var_x82 = var_x44 * var_x81;
        const double var_x83 = var_x81 * var_chaste_interface__sodium_dynamics__Na_i / pow((1 + 0.025000000000000001 * var_chaste_interface__sodium_dynamics__Na_i), 2);
        const double var_x84 = var_x6 * var_x8 * pow(var_chaste_interface__sodium_dynamics__Na_i, 2);
        const double var_x85 = var_x0 * (0.0031249999999999997 * var_chaste_interface__sodium_dynamics__Na_i + 0.10416666666666667 * var_chaste_interface__potassium_dynamics__K_i) / pow(var_x66, 2);
        const double var_x86 = var_x36 * var_x68;
        const double var_x87 = var_x11 * var_x3;
        const double var_x88 = var_x11 * var_x25;
        const double var_x89 = var_x11 * var_x27;
        const double var_x90 = var_x11 * var_x37;
        const double var_x91 = 0.16028256395817389 * var_x90 - var_x18 * (2.6713760659695653 * var_x11 * var_x21 + 0.01602825639581739 * var_x11 * var_x19) - 13.356880329847826 * var_x11 * var_x40;
        const double var_x92 = var_x11 * var_x33;
        const double var_x93 = var_x38 * var_x90;
        const double var_x94 = 0.001 + var_chaste_interface__calcium_dynamics__Ca_i;
        const double var_x95 = 1.0 + 0.00020000000000000001 / pow(var_x94, 2);
        const double var_x96 = 1 / var_x95;
        const double var_x97 = var_x96;
        const double var_x98 = 7.2352122917848019e-6 * var_x61;
        const double var_x99 = 1.0 + 6.2499999999999997e-8 / pow(var_chaste_interface__calcium_dynamics__Ca_i, 2);
        const double var_x100 = 1 / (pow(var_x99, 2) * pow(var_chaste_interface__calcium_dynamics__Ca_i, 3));
        const double var_x101 = 1 / var_x99;
        const double var_x102 = 0.10000000000000001 * var_chaste_interface__membrane__V;
        const double var_x103 = -var_x102;
        const double var_x104 = exp(-4.5 + var_x103);
        const double var_x105 = 1.0 + var_x104;
        const double var_x106 = 0.14285714285714285 * var_chaste_interface__membrane__V;
        const double var_x107 = exp(-3.7142857142857144 - var_x106);
        const double var_x108 = 1.0 + var_x107;
        const double var_x109 = -var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1 + 1 / var_x108;
        const double var_x110 = exp(2.6086956521739131 + 0.086956521739130432 * var_chaste_interface__membrane__V);
        const double var_x111 = 0.00037037037037037035 + 0.00037037037037037035 * var_x110;
        const double var_x112 = var_x105 * var_x111;
        const double var_x113 = 0.050000000000000003 * var_chaste_interface__membrane__V;
        const double var_x114 = -var_x113;
        const double var_x115 = exp(-3.0 + var_x114);
        const double var_x116 = 1.0 + var_x115;
        const double var_x117 = exp(3.6666666666666665 + 0.041666666666666664 * var_chaste_interface__membrane__V);
        const double var_x118 = 1.0 + var_x117;
        const double var_x119 = -var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2 + 1 / var_x118;
        const double var_x120 = exp(-3.0 + var_x113);
        const double var_x121 = 0.29761904761904762 + 0.29761904761904762 * var_x120;
        const double var_x122 = var_x116 * var_x121;
        const double var_x123 = -0.16666666666666666 * var_chaste_interface__membrane__V;
        const double var_x124 = exp(0.83333333333333337 + var_x123);
        const double var_x125 = 1.0 + var_x124;
        const double var_x126 = 1 / sqrt(var_x125);
        const double var_x127 = exp(-2.3333333333333335 + 0.066666666666666666 * var_chaste_interface__membrane__V);
        const double var_x128 = 1.0 + var_x127;
        const double var_x129 = 1 / var_x128;
        const double var_x130 = var_x126 * var_x129;
        const double var_x131 = exp(-0.35714285714285715 - 0.071428571428571425 * var_chaste_interface__membrane__V);
        const double var_x132 = 1.0 + var_x131;
        const double var_x133 = 1 / (80.0 + 1400.0 * var_x130);
        const double var_x134 = 0.20000000000000001 * var_chaste_interface__membrane__V;
        const double var_x135 = exp(7.0 + var_x134);
        const double var_x136 = 1.0 + var_x135;
        const double var_x137 = 1 / var_x136;
        const double var_x138 = exp(-0.25 + 0.0050000000000000001 * var_chaste_interface__membrane__V);
        const double var_x139 = 1.0 + var_x138;
        const double var_x140 = 1 / var_x139;
        const double var_x141 = 1 / (0.10000000000000001 * var_x137 + 0.10000000000000001 * var_x140);
        const double var_x142 = exp(-6.2967884828349945 - 0.11074197120708749 * var_chaste_interface__membrane__V);
        const double var_x143 = 1.0 + var_x142;
        const double var_x144 = -var_chaste_interface__fast_sodium_current_m_gate__m + 1 / pow(var_x143, 2);
        const double var_x145 = exp(-12.0 - var_x134);
        const double var_x146 = 1.0 + var_x145;
        const double var_x147 = var_x141 * var_x146;
        const double var_x148 = exp(9.6298788694481825 + 0.13458950201884254 * var_chaste_interface__membrane__V);
        const double var_x149 = 1.0 + var_x148;
        const double var_x150 = 1 / pow(var_x149, 2);
        const double var_x151 = exp(-11.764705882352942 - 0.14705882352941177 * var_chaste_interface__membrane__V);
        const double var_x152 = var_chaste_interface__membrane__V < -40.0;
        const double var_x153 = exp(0.34849999999999998 * var_chaste_interface__membrane__V);
        const double var_x154 = exp(0.079000000000000001 * var_chaste_interface__membrane__V);
        const double var_x155 = exp(-0.96036036036036043 - 0.0900900900900901 * var_chaste_interface__membrane__V);
        const double var_x156 = 1.0 + var_x155;
        const double var_x157 = ((var_x152) ? (0.057000000000000002 * var_x151) : (0));
        const double var_x158 = ((var_x152) ? (310000.0 * var_x153 + 2.7000000000000002 * var_x154) : (5.9230769230769234 / var_x156));
        const double var_x159 = 0.26917900403768508 * var_x148 / pow(var_x149, 3);
        const double var_x160 = exp(-5.5312920000000005 - 0.13780000000000001 * var_chaste_interface__membrane__V);
        const double var_x161 = 1.0 + var_x160;
        const double var_x162 = exp(-0.01052 * var_chaste_interface__membrane__V);
        const double var_x163 = var_x162 / var_x161;
        const double var_x164 = exp(-3.2000000000000002 - var_x20);
        const double var_x165 = 1.0 + var_x164;
        const double var_x166 = exp(0.057000000000000002 * var_chaste_interface__membrane__V);
        const double var_x167 = var_x166 / var_x165;
        const double var_x168 = exp(0.24440000000000001 * var_chaste_interface__membrane__V);
        const double var_x169 = exp(-0.043909999999999998 * var_chaste_interface__membrane__V);
        const double var_x170 = -25428.0 * var_x168 - 6.9480000000000002e-6 * var_x169;
        const double var_x171 = exp(24.640530000000002 + 0.311 * var_chaste_interface__membrane__V);
        const double var_x172 = 1.0 + var_x171;
        const double var_x173 = 1 / var_x172;
        const double var_x174 = var_x170 * var_x173;
        const double var_x175 = 37.780000000000001 + var_chaste_interface__membrane__V;
        const double var_x176 = ((var_x152) ? (0.024240000000000001 * var_x163) : (0.59999999999999998 * var_x167));
        const double var_x177 = ((var_x152) ? (var_x174 * var_x175) : (0));
        const double var_x178 = exp(2.5 + var_x114);
        const double var_x179 = 1.0 + var_x178;
        const double var_x180 = 1 / var_x179;
        const double var_x181 = exp(1.0 + var_x134);
        const double var_x182 = 1.0 + var_x181;
        const double var_x183 = 1 / var_x182;
        const double var_x184 = exp(-2.6923076923076925 - 0.076923076923076927 * var_chaste_interface__membrane__V);
        const double var_x185 = 1.0 + var_x184;
        const double var_x186 = 0.25 + 1.3999999999999999 / var_x185;
        const double var_x187 = var_x183 * var_x186;
        const double var_x188 = exp(-1.0666666666666667 - 0.13333333333333333 * var_chaste_interface__membrane__V);
        const double var_x189 = 1.0 + var_x188;
        const double var_x190 = 1 / (var_x180 + 1.3999999999999999 * var_x187);
        const double var_x191 = exp(3.0 + var_x102);
        const double var_x192 = 1.0 + var_x191;
        const double var_x193 = 1 / var_x192;
        const double var_x194 = exp(1.3 + var_x103);
        const double var_x195 = 1.0 + var_x194;
        const double var_x196 = 1 / var_x195;
        const double var_x197 = pow((1 + 0.037037037037037035 * var_chaste_interface__membrane__V), 2);
        const double var_x198 = exp(-3.2400000000000002 * var_x197);
        const double var_x199 = exp(2.8571428571428572 + var_x106);
        const double var_x200 = 1.0 + var_x199;
        const double var_x201 = var_x191 / pow(var_x192, 2);
        const double var_x202 = 1102.5 * var_x198;
        const double var_x203 = 1 / (20.0 + var_x202 + 200.0 * var_x196 + 180.0 * var_x193);
        const double var_x204 = exp(2.5 + var_x103);
        const double var_x205 = 1.0 + var_x204;
        const double var_x206 = 1 / var_x205;
        const double var_x207 = exp(-3.0375000000000001 * var_x197);
        const double var_x208 = exp(5.0 + var_x106);
        const double var_x209 = 1.0 + var_x208;
        const double var_x210 = 562.0 * var_x207;
        const double var_x211 = 1 / (var_x210 + 80.0 * var_x193 + 31.0 * var_x206);
        const double var_x212 = pow(var_chaste_interface__calcium_dynamics__Ca_ss, 2);
        const double var_x213 = 1 / (1.0 + 399.99999999999994 * var_x212);
        const double var_x214 = 1 / (2.0 + 80.0 * var_x213);
        const double var_x215 = var_chaste_interface__calcium_dynamics__Ca_ss / pow((0.0025000000000000005 + var_x212), 2);
        const double var_x216 = exp(-4.0 + var_x134);
        const double var_x217 = 1.0 + var_x216;
        const double var_x218 = 1 / var_x217;
        const double var_x219 = exp(-6.328125 * pow((1 + 0.022222222222222223 * var_chaste_interface__membrane__V), 2));
        const double var_x220 = exp(4.0 + var_x134);
        const double var_x221 = 1.0 + var_x220;
        const double var_x222 = 85.0 * var_x219;
        const double var_x223 = 1 / (3.0 + var_x222 + 5.0 * var_x218);
        const double var_x224 = exp(3.3333333333333335 + var_x123);
        const double var_x225 = 1.0 + var_x224;
        const double var_x226 = exp(-0.88888888888888884 * pow((1 + 0.025000000000000001 * var_chaste_interface__membrane__V), 2));
        const double var_x227 = 1 / (0.80000000000000004 + 9.5 * var_x226);
        const double var_x228 = 0.29999999999999999 + var_chaste_interface__calcium_dynamics__Ca_SR;
        const double var_x229 = pow(var_x228, (-2));
        const double var_x230 = 1 / (1.0 + 3.0 * var_x229);
        const double var_x231 = var_x230;
        const double var_x232 = pow(var_chaste_interface__calcium_dynamics__Ca_SR, (-2));
        const double var_x233 = 1 / (1.0 + 2.25 * var_x232);
        const double var_x234 = 1 / (2.5 - 1.5 * var_x233);
        const double var_x235 = var_x212 * var_x234;
        const double var_x236 = 1 / (0.059999999999999998 + 0.14999999999999999 * var_x235);
        const double var_x237 = var_x236 * var_chaste_interface__calcium_dynamics__R_prime;
        const double var_x238 = var_x235 * var_x237;
        const double var_x239 = 0.015299999999999998 * var_x238;
        const double var_x240 = 1 / (pow((0.44444444444444442 + var_x232), 2) * pow(var_chaste_interface__calcium_dynamics__Ca_SR, 3));
        const double var_x241 = -var_chaste_interface__calcium_dynamics__Ca_ss + var_chaste_interface__calcium_dynamics__Ca_SR;
        const double var_x242 = var_x241 / pow((1 - 0.59999999999999998 * var_x233), 2);
        const double var_x243 = var_x212 * var_x237 * var_x240 * var_x242;
        const double var_x244 = var_x240 * var_chaste_interface__calcium_dynamics__R_prime;
        const double var_x245 = var_x242 / pow((0.40000000000000002 + var_x235), 2);
        const double var_x246 = var_x234 * var_x244 * var_x245 * pow(var_chaste_interface__calcium_dynamics__Ca_ss, 4);
        const double var_x247 = var_x245 * pow(var_chaste_interface__calcium_dynamics__Ca_ss, 3) * var_chaste_interface__calcium_dynamics__R_prime;
        const double var_x248 = var_x234 * var_x237 * var_x241 * var_chaste_interface__calcium_dynamics__Ca_ss;
        const double var_x249 = var_x235 * var_x236 * var_x241;
        const double var_x250 = 253.30174843481757 * var_x54;
        const double var_x251 = var_x250 * var_x52;
        const double var_x252 = 0.00025000000000000001 + var_chaste_interface__calcium_dynamics__Ca_ss;
        const double var_x253 = 1.0 + 0.0001 / pow(var_x252, 2);
        const double var_x254 = 1 / var_x253;
        const double var_x255 = var_x254;
        const double var_x256 = var_x250 * var_x254;
        const double var_x257 = var_x256 * var_x74;
        const double var_x258 = var_x256 * var_x76;
        const double var_x259 = 0.30611192392099484 * var_x238;
        const double var_x260 = -0.11249999999999999 + 0.067500000000000004 * var_x233;
        const double var_x261 = 6.3176611368492499e-5 * var_x42;
        const double var_x262 = (0.0031224512033090025 * var_x12 - 0.00011688549744401942 * var_chaste_interface__membrane__V) * NV_Ith_S(mParameters, 2);
        const double var_x263 = 0.0031224512033090025 * var_x12 - 0.00011688549744401942 * var_chaste_interface__membrane__V;
        
        // Matrix entries
        IJth(rJacobian, 0, 0) = mSetVoltageDerivativeToZero ? 0.0 : (-0.00088199999999999997 - var_x27 - var_x36 + 1081.6363254030778 * var_x58 + 0.03243 * var_x39 - 0.39200000000000002 * var_x0 - 0.0146 * var_x3 - 0.0024414715719063545 * var_x30 - 270.40908135076944 * var_x59 - 8.6662202299424464e-5 * var_x10 - 0.54050000000000009 * var_x25 - 2.2983750000000001 * var_x48 - 2.1086672225679691e-7 * var_x32 - 1.0 * var_x33 - var_x41 * var_x43 - var_x52 * var_x55);
        IJth(rJacobian, 1, 0) = var_x97 * (-3.4598107243429746e-8 + 2.464726172537559e-11 * var_x32 + 1.0129554625362472e-8 * var_x10);
        IJth(rJacobian, 2, 0) = 3.2206119162640899e-5 * var_x105 * var_x109 * var_x110 + 0.14285714285714285 * var_x107 * var_x112 / pow(var_x108, 2) - 0.10000000000000001 * var_x104 * var_x109 * var_x111;
        IJth(rJacobian, 3, 0) = 0.01488095238095238 * var_x116 * var_x119 * var_x120 - 0.041666666666666664 * var_x117 * var_x122 / pow(var_x118, 2) - 0.050000000000000003 * var_x115 * var_x119 * var_x121;
        IJth(rJacobian, 4, 0) = 5.1020408163265302e-7 * (-var_chaste_interface__slow_time_dependent_potassium_current_Xs_gate__Xs + 1 / var_x132) * (93.333333333333329 * var_x126 * var_x127 / pow(var_x128, 2) - 116.66666666666667 * var_x124 * var_x129 / pow(var_x125, (3 / 2))) / pow((0.057142857142857141 + var_x130), 2) + 0.071428571428571425 * var_x131 * var_x133 / pow(var_x132, 2);
        IJth(rJacobian, 5, 0) = 0.22148394241417499 * var_x142 * var_x147 / pow(var_x143, 3) - 0.20000000000000001 * var_x141 * var_x144 * var_x145 + 99.999999999999986 * var_x144 * var_x146 * (0.02 * var_x135 / pow(var_x136, 2) + 0.00050000000000000001 * var_x138 / pow(var_x139, 2)) / pow((var_x137 + var_x140), 2);
        IJth(rJacobian, 6, 0) = (var_x150 - var_chaste_interface__fast_sodium_current_h_gate__h) * (((var_x152) ? (-0.008382352941176471 * var_x151) : (0)) + ((var_x152) ? (108035.0 * var_x153 + 0.21330000000000002 * var_x154) : (0.53361053361053368 * var_x155 / pow(var_x156, 2)))) - var_x159 * (var_x157 + var_x158);
        IJth(rJacobian, 7, 0) = (var_x150 - var_chaste_interface__fast_sodium_current_j_gate__j) * (((var_x152) ? (-0.00025500480000000003 * var_x163 + 0.0033402720000000005 * var_x160 * var_x162 / pow(var_x161, 2)) : (0.034200000000000001 * var_x167 + 0.059999999999999998 * var_x164 * var_x166 / pow(var_x165, 2))) + ((var_x152) ? (var_x174 + var_x173 * var_x175 * (3.0508668000000001e-7 * var_x169 - 6214.6032000000005 * var_x168) - 0.311 * var_x170 * var_x171 * var_x175 / pow(var_x172, 2)) : (0))) - var_x159 * (var_x176 + var_x177);
        IJth(rJacobian, 8, 0) = 0.51020408163265307 * (-var_chaste_interface__L_type_Ca_current_d_gate__d + 1 / var_x189) * (-0.050000000000000003 * var_x178 / pow(var_x179, 2) + 0.27999999999999997 * var_x181 * var_x186 / pow(var_x182, 2) - 0.15076923076923074 * var_x183 * var_x184 / pow(var_x185, 2)) / pow((var_x187 + 0.7142857142857143 * var_x180), 2) + 0.13333333333333333 * var_x188 * var_x190 / pow(var_x189, 2);
        IJth(rJacobian, 9, 0) = 8.2270247479188195e-7 * (-var_chaste_interface__L_type_Ca_current_f_gate__f + 1 / var_x200) * (18.0 * var_x201 - var_x202 * (-0.23999999999999999 - 0.0088888888888888889 * var_chaste_interface__membrane__V) - 20.0 * var_x194 / pow(var_x195, 2)) / pow((0.018140589569160998 + var_x198 + 0.16326530612244897 * var_x193 + 0.18140589569160998 * var_x196), 2) - 0.14285714285714285 * var_x199 * var_x203 / pow(var_x200, 2);
        IJth(rJacobian, 10, 0) = 3.1661199832828864e-6 * (0.33000000000000002 - var_chaste_interface__L_type_Ca_current_f2_gate__f2 + 0.67000000000000004 / var_x209) * (8.0 * var_x201 - var_x210 * (-0.22500000000000001 - 0.0083333333333333332 * var_chaste_interface__membrane__V) - 3.1000000000000001 * var_x204 / pow(var_x205, 2)) / pow((var_x207 + 0.055160142348754451 * var_x206 + 0.14234875444839859 * var_x193), 2) - 0.095714285714285724 * var_x208 * var_x211 / pow(var_x209, 2);
        IJth(rJacobian, 12, 0) = 0.00013840830449826991 * (-var_chaste_interface__transient_outward_current_s_gate__s + 1 / var_x221) * (-var_x222 * (-0.28125 - 0.0062500000000000003 * var_chaste_interface__membrane__V) + var_x216 / pow(var_x217, 2)) / pow((0.035294117647058823 + var_x219 + 0.058823529411764705 * var_x218), 2) - 0.20000000000000001 * var_x220 * var_x223 / pow(var_x221, 2);
        IJth(rJacobian, 13, 0) = 0.16666666666666666 * var_x224 * var_x227 / pow(var_x225, 2) - 0.10526315789473684 * var_x226 * (-0.044444444444444446 - 0.0011111111111111111 * var_chaste_interface__membrane__V) * (-var_chaste_interface__transient_outward_current_r_gate__r + 1 / var_x225) / pow((0.084210526315789472 + var_x226), 2);
        IJth(rJacobian, 15, 0) = var_x255 * (-var_x251 + 18.964139992238998 * var_x58 - 4.7410349980597495 * var_x59);
        IJth(rJacobian, 17, 0) = -3.389679425876563e-8 - 3.0388663876087418e-8 * var_x10 - 0.00011688549744401942 * var_x36 - 7.3941785176126768e-11 * var_x32 - 0.00080594011556369446 * var_x48;
        IJth(rJacobian, 18, 0) = 0.00053729341037579627 * var_x48 + 3.79059668210955e-6 * var_x39 - 2.8537261917770623e-7 * var_x30 - 0.00011688549744401942 * var_x27 - 6.3176611368492499e-5 * var_x25 - 4.5819114998055616e-5 * var_x0 - 1.7065282626826835e-6 * var_x3 - 0.00011688549744401942 * var_x33 - var_x261 * var_x41;
        IJth(rJacobian, 0, 1) = mSetVoltageDerivativeToZero ? 0.0 : (0.12379999999999999 * var_x63 + 594.50270777405183 * var_x64 - 0.12379999999999999 * var_x61 - 0.0079072731552699126 * var_x62);
        IJth(rJacobian, 1, 1) = var_x97 * (-0.0038240087783467445 - var_x98 + 7.2352122917848019e-6 * var_x63 - 0.069488744729986562 * var_x64 - 5.3144431236283834e-11 * var_x100 - 4.6212277808973232e-7 * var_x62) + 0.00040000000000000002 * (0.0038 * var_chaste_interface__calcium_dynamics__Ca_ss + 2.40087783467447e-5 * var_chaste_interface__calcium_dynamics__Ca_SR + 4.6212277808973232e-7 * log(2.0 * var_x62) - 0.0038240087783467445 * var_chaste_interface__calcium_dynamics__Ca_i - 3.4598107243429746e-8 * var_chaste_interface__membrane__V - 0.00042515544989027063 * var_x101 - var_x98 * var_chaste_interface__calcium_dynamics__Ca_i + 1.0129554625362472e-8 * var_x31 * var_x6) / (pow(var_x94, 3) * pow(var_x95, 2));
        IJth(rJacobian, 14, 1) = var_x231 * (0.00036000000000000002 + 7.96875e-10 * var_x100);
        IJth(rJacobian, 15, 1) = 1.1399999999999999 * var_x254;
        IJth(rJacobian, 17, 1) = 0.20846623418995969 * var_x64;
        IJth(rJacobian, 0, 2) = mSetVoltageDerivativeToZero ? 0.0 : (var_x65 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2);
        IJth(rJacobian, 2, 2) = -var_x112;
        IJth(rJacobian, 18, 2) = var_x262 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr2_gate__Xr2;
        IJth(rJacobian, 0, 3) = mSetVoltageDerivativeToZero ? 0.0 : (var_x65 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1);
        IJth(rJacobian, 3, 3) = -var_x122;
        IJth(rJacobian, 18, 3) = var_x262 * var_chaste_interface__rapid_time_dependent_potassium_current_Xr1_gate__Xr1;
        IJth(rJacobian, 0, 4) = mSetVoltageDerivativeToZero ? 0.0 : (-0.78400000000000003 * var_x67);
        IJth(rJacobian, 4, 4) = -var_x133;
        IJth(rJacobian, 18, 4) = -9.1638229996111233e-5 * var_x67;
        IJth(rJacobian, 0, 5) = mSetVoltageDerivativeToZero ? 0.0 : (-3 * var_x71);
        IJth(rJacobian, 5, 5) = -1.0 * var_x147;
        IJth(rJacobian, 17, 5) = -0.00035065649233205829 * var_x71;
        IJth(rJacobian, 0, 6) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x72);
        IJth(rJacobian, 6, 6) = -var_x157 - var_x158;
        IJth(rJacobian, 17, 6) = -0.00011688549744401942 * var_x72;
        IJth(rJacobian, 0, 7) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x73);
        IJth(rJacobian, 7, 7) = -var_x176 - var_x177;
        IJth(rJacobian, 17, 7) = -0.00011688549744401942 * var_x73;
        IJth(rJacobian, 0, 8) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x75 * var_chaste_interface__L_type_Ca_current_f_gate__f);
        IJth(rJacobian, 8, 8) = -var_x190;
        IJth(rJacobian, 15, 8) = -var_x257 * var_chaste_interface__L_type_Ca_current_f_gate__f;
        IJth(rJacobian, 0, 9) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x75 * var_chaste_interface__L_type_Ca_current_d_gate__d);
        IJth(rJacobian, 9, 9) = -var_x203;
        IJth(rJacobian, 15, 9) = -var_x257 * var_chaste_interface__L_type_Ca_current_d_gate__d;
        IJth(rJacobian, 0, 10) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x77 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass);
        IJth(rJacobian, 10, 10) = -var_x211;
        IJth(rJacobian, 15, 10) = -var_x258 * var_chaste_interface__L_type_Ca_current_fCass_gate__fCass;
        IJth(rJacobian, 0, 11) = mSetVoltageDerivativeToZero ? 0.0 : (-var_x77 * var_chaste_interface__L_type_Ca_current_f2_gate__f2);
        IJth(rJacobian, 11, 11) = -var_x214;
        IJth(rJacobian, 15, 11) = -var_x258 * var_chaste_interface__L_type_Ca_current_f2_gate__f2;
        IJth(rJacobian, 0, 12) = mSetVoltageDerivativeToZero ? 0.0 : (var_x26 * var_x78);
        IJth(rJacobian, 12, 12) = -var_x223;
        IJth(rJacobian, 18, 12) = var_x26 * var_x263;
        IJth(rJacobian, 0, 13) = mSetVoltageDerivativeToZero ? 0.0 : (var_x78 * var_x79);
        IJth(rJacobian, 13, 13) = -var_x227;
        IJth(rJacobian, 18, 13) = var_x263 * var_x79;
        IJth(rJacobian, 1, 14) = 2.40087783467447e-5 * var_x96;
        IJth(rJacobian, 14, 14) = var_x231 * (-0.00036000000000000002 - var_x239 + 0.021759999999999998 * var_x246 - 0.0032639999999999995 * var_x243) + 0.66666666666666674 * (0.00036000000000000002 * var_chaste_interface__calcium_dynamics__Ca_i + 0.0063749999999999996 * var_x101 - 0.00036000000000000002 * var_chaste_interface__calcium_dynamics__Ca_SR - var_x239 * var_x241) / (pow(var_x228, 3) * pow((0.33333333333333337 + var_x229), 2));
        IJth(rJacobian, 15, 14) = var_x255 * (var_x259 + 0.065303877103145572 * var_x243 - 0.43535918068763713 * var_x246);
        IJth(rJacobian, 16, 14) = 0.059999999999999998 * var_x244 * var_chaste_interface__calcium_dynamics__Ca_ss;
        IJth(rJacobian, 0, 15) = mSetVoltageDerivativeToZero ? 0.0 : (-3611.8217397063127 * var_x80);
        IJth(rJacobian, 1, 15) = 0.0038 * var_x96;
        IJth(rJacobian, 11, 15) = -0.0030000000000000001 * var_x214 * var_x215 + 6.2500000000000001e-5 * var_x215 * (0.40000000000000002 - var_chaste_interface__L_type_Ca_current_fCass_gate__fCass + 0.59999999999999998 * var_x213) / pow((0.025000000000000001 + var_x213), 2);
        IJth(rJacobian, 14, 15) = var_x231 * (var_x239 + 0.032639999999999995 * var_x247 - 0.030599999999999995 * var_x248);
        IJth(rJacobian, 15, 15) = var_x255 * (-1.1399999999999999 - var_x259 + 0.61222384784198969 * var_x248 - 0.65303877103145569 * var_x247 - 63.325437108704392 * var_x80) + 0.00020000000000000001 * (1.1399999999999999 * var_chaste_interface__calcium_dynamics__Ca_i - 1.1399999999999999 * var_chaste_interface__calcium_dynamics__Ca_ss + var_x241 * var_x259 - var_x251 * var_x56) / (pow(var_x252, 3) * pow(var_x253, 2));
        IJth(rJacobian, 16, 15) = var_x260 * var_chaste_interface__calcium_dynamics__R_prime;
        IJth(rJacobian, 14, 16) = -0.015299999999999998 * var_x230 * var_x249;
        IJth(rJacobian, 15, 16) = 0.30611192392099484 * var_x249 * var_x254;
        IJth(rJacobian, 16, 16) = -0.0050000000000000001 + var_x260 * var_chaste_interface__calcium_dynamics__Ca_ss;
        IJth(rJacobian, 0, 17) = mSetVoltageDerivativeToZero ? 0.0 : (0.001436484375 * var_x83 - 26.713760659695652 * var_x86 - 0.00051997321379654684 * var_x84 - 2.2983750000000001 * var_x82 - 3.0158767234370001 * var_x85 - 0.0077469905913117388 * var_x68);
        IJth(rJacobian, 1, 17) = 6.0777327752174836e-8 * var_x84 * var_x96;
        IJth(rJacobian, 17, 17) = 5.0371257222730904e-7 * var_x83 - 9.0551084895961074e-7 * var_x68 - 1.823319832565245e-7 * var_x84 - 0.0031224512033090025 * var_x86 - 0.00080594011556369446 * var_x82;
        IJth(rJacobian, 18, 17) = 0.00053729341037579627 * var_x82 - 0.00035251225104877316 * var_x85 - 3.3580838148487267e-7 * var_x83;
        IJth(rJacobian, 0, 18) = mSetVoltageDerivativeToZero ? 0.0 : (0.86632725819392997 * var_x93 - 26.713760659695652 * var_x89 - 100.52922411456667 * var_x85 - 14.4387876365655 * var_x88 - 0.3900209056315565 * var_x87 - 26.713760659695648 * var_x92 - var_x43 * var_x91);
        IJth(rJacobian, 18, 18) = 0.00010126109252331096 * var_x93 - 0.0031224512033090025 * var_x92 - 0.0016876848753885161 * var_x88 - 4.5587787568311439e-5 * var_x87 - 0.011750408368292439 * var_x85 - 0.0031224512033090025 * var_x89 - var_x261 * var_x91;
    }

    N_Vector Cellten_tusscher_model_2006_epiFromCellMLCvode::ComputeDerivedQuantities(double var_chaste_interface__environment__time, const N_Vector & rY)
    {
        // Inputs:
        // Time units: millisecond
        
        // Mathematics
        const double var_membrane__i_Stim_converted = GetIntracellularAreaStimulus(var_chaste_interface__environment__time); // uA_per_cm2

        N_Vector dqs = N_VNew_Serial(2);
        NV_Ith_S(dqs, 0) = var_chaste_interface__environment__time;
        NV_Ith_S(dqs, 1) = var_membrane__i_Stim_converted;
        return dqs;
    }

template<>
void OdeSystemInformation<Cellten_tusscher_model_2006_epiFromCellMLCvode>::Initialise(void)
{
    this->mSystemName = "tentusscher_panfilov_2006_epi";
    this->mFreeVariableName = "environment__time";
    this->mFreeVariableUnits = "millisecond";

    // NV_Ith_S(rY, 0):
    this->mVariableNames.push_back("membrane_voltage");
    this->mVariableUnits.push_back("millivolt");
    this->mInitialConditions.push_back(-85.23);

    // NV_Ith_S(rY, 1):
    this->mVariableNames.push_back("cytosolic_calcium_concentration");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.000126);

    // NV_Ith_S(rY, 2):
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_Xr1_gate__Xr1");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00621);

    // NV_Ith_S(rY, 3):
    this->mVariableNames.push_back("rapid_time_dependent_potassium_current_Xr2_gate__Xr2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.4712);

    // NV_Ith_S(rY, 4):
    this->mVariableNames.push_back("slow_time_dependent_potassium_current_Xs_gate__Xs");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.0095);

    // NV_Ith_S(rY, 5):
    this->mVariableNames.push_back("fast_sodium_current_m_gate__m");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.00172);

    // NV_Ith_S(rY, 6):
    this->mVariableNames.push_back("fast_sodium_current_h_gate__h");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.7444);

    // NV_Ith_S(rY, 7):
    this->mVariableNames.push_back("fast_sodium_current_j_gate__j");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.7045);

    // NV_Ith_S(rY, 8):
    this->mVariableNames.push_back("L_type_Ca_current_d_gate__d");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(3.373e-05);

    // NV_Ith_S(rY, 9):
    this->mVariableNames.push_back("L_type_Ca_current_f_gate__f");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.7888);

    // NV_Ith_S(rY, 10):
    this->mVariableNames.push_back("L_type_Ca_current_f2_gate__f2");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9755);

    // NV_Ith_S(rY, 11):
    this->mVariableNames.push_back("L_type_Ca_current_fCass_gate__fCass");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9953);

    // NV_Ith_S(rY, 12):
    this->mVariableNames.push_back("transient_outward_current_s_gate__s");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.999998);

    // NV_Ith_S(rY, 13):
    this->mVariableNames.push_back("transient_outward_current_r_gate__r");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(2.42e-08);

    // NV_Ith_S(rY, 14):
    this->mVariableNames.push_back("calcium_dynamics__Ca_SR");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(3.64);

    // NV_Ith_S(rY, 15):
    this->mVariableNames.push_back("calcium_dynamics__Ca_ss");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(0.00036);

    // NV_Ith_S(rY, 16):
    this->mVariableNames.push_back("calcium_dynamics__R_prime");
    this->mVariableUnits.push_back("dimensionless");
    this->mInitialConditions.push_back(0.9073);

    // NV_Ith_S(rY, 17):
    this->mVariableNames.push_back("sodium_dynamics__Na_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(8.604);

    // NV_Ith_S(rY, 18):
    this->mVariableNames.push_back("potassium_dynamics__K_i");
    this->mVariableUnits.push_back("millimolar");
    this->mInitialConditions.push_back(136.89);

    // mParameters[0]:
    this->mParameterNames.push_back("membrane_L_type_calcium_current_conductance");
    this->mParameterUnits.push_back("litre_per_farad_second");

    // mParameters[1]:
    this->mParameterNames.push_back("membrane_fast_sodium_current_conductance");
    this->mParameterUnits.push_back("nanoS_per_picoF");

    // mParameters[2]:
    this->mParameterNames.push_back("membrane_rapid_delayed_rectifier_potassium_current_conductance");
    this->mParameterUnits.push_back("nanoS_per_picoF");

    // mParameters[3]:
    this->mParameterNames.push_back("membrane_transient_outward_current_conductance");
    this->mParameterUnits.push_back("nanoS_per_picoF");

    // Derived Quantity index [0]:
    this->mDerivedQuantityNames.push_back("environment__time");
    this->mDerivedQuantityUnits.push_back("millisecond");

    // Derived Quantity index [1]:
    this->mDerivedQuantityNames.push_back("membrane_stimulus_current");
    this->mDerivedQuantityUnits.push_back("uA_per_cm2");

    
    this->mAttributes["SuggestedForwardEulerTimestep"] = 0.001;
    this->mInitialised = true;
}

// Serialization for Boost >= 1.36
#include "SerializationExportWrapperForCpp.hpp"
CHASTE_CLASS_EXPORT(Cellten_tusscher_model_2006_epiFromCellMLCvode)
#endif // CHASTE_CVODE
